"use strict";
(self["webpackChunknearbeach"] = self["webpackChunknearbeach"] || []).push([["vendors-node_modules_naive-ui_es_input_src_Input_mjs"],{

/***/ "./node_modules/naive-ui/es/_internal/icons/EyeOff.mjs":
/*!*************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/icons/EyeOff.mjs ***!
  \*************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'EyeOff',
  render() {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 512 512"
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("path", {
      d: "M432 448a15.92 15.92 0 0 1-11.31-4.69l-352-352a16 16 0 0 1 22.62-22.62l352 352A16 16 0 0 1 432 448z",
      fill: "currentColor"
    }), (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("path", {
      d: "M255.66 384c-41.49 0-81.5-12.28-118.92-36.5c-34.07-22-64.74-53.51-88.7-91v-.08c19.94-28.57 41.78-52.73 65.24-72.21a2 2 0 0 0 .14-2.94L93.5 161.38a2 2 0 0 0-2.71-.12c-24.92 21-48.05 46.76-69.08 76.92a31.92 31.92 0 0 0-.64 35.54c26.41 41.33 60.4 76.14 98.28 100.65C162 402 207.9 416 255.66 416a239.13 239.13 0 0 0 75.8-12.58a2 2 0 0 0 .77-3.31l-21.58-21.58a4 4 0 0 0-3.83-1a204.8 204.8 0 0 1-51.16 6.47z",
      fill: "currentColor"
    }), (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("path", {
      d: "M490.84 238.6c-26.46-40.92-60.79-75.68-99.27-100.53C349 110.55 302 96 255.66 96a227.34 227.34 0 0 0-74.89 12.83a2 2 0 0 0-.75 3.31l21.55 21.55a4 4 0 0 0 3.88 1a192.82 192.82 0 0 1 50.21-6.69c40.69 0 80.58 12.43 118.55 37c34.71 22.4 65.74 53.88 89.76 91a.13.13 0 0 1 0 .16a310.72 310.72 0 0 1-64.12 72.73a2 2 0 0 0-.15 2.95l19.9 19.89a2 2 0 0 0 2.7.13a343.49 343.49 0 0 0 68.64-78.48a32.2 32.2 0 0 0-.1-34.78z",
      fill: "currentColor"
    }), (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("path", {
      d: "M256 160a95.88 95.88 0 0 0-21.37 2.4a2 2 0 0 0-1 3.38l112.59 112.56a2 2 0 0 0 3.38-1A96 96 0 0 0 256 160z",
      fill: "currentColor"
    }), (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("path", {
      d: "M165.78 233.66a2 2 0 0 0-3.38 1a96 96 0 0 0 115 115a2 2 0 0 0 1-3.38z",
      fill: "currentColor"
    }));
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/input/src/Input.mjs":
/*!******************************************************!*\
  !*** ./node_modules/naive-ui/es/input/src/Input.mjs ***!
  \******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   inputProps: () => (/* binding */ inputProps)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/use-merged-state.js");
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/use-memo.js");
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/css/index.js");
/* harmony import */ var vueuc__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! vueuc */ "./node_modules/vueuc/es/resize-observer/src/VResizeObserver.js");
/* harmony import */ var evtd__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! evtd */ "./node_modules/evtd/es/delegate.js");
/* harmony import */ var _utils_env_browser_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../_utils/env/browser.mjs */ "./node_modules/naive-ui/es/_utils/env/browser.mjs");
/* harmony import */ var _internal_icons_index_mjs__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ../../_internal/icons/index.mjs */ "./node_modules/naive-ui/es/_internal/icons/Eye.mjs");
/* harmony import */ var _internal_icons_index_mjs__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ../../_internal/icons/index.mjs */ "./node_modules/naive-ui/es/_internal/icons/EyeOff.mjs");
/* harmony import */ var _mixins_use_rtl_mjs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../_mixins/use-rtl.mjs */ "./node_modules/naive-ui/es/_mixins/use-rtl.mjs");
/* harmony import */ var _internal_index_mjs__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../_internal/index.mjs */ "./node_modules/naive-ui/es/_internal/scrollbar/src/Scrollbar.mjs");
/* harmony import */ var _internal_index_mjs__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../_internal/index.mjs */ "./node_modules/naive-ui/es/_internal/clear/src/Clear.mjs");
/* harmony import */ var _internal_index_mjs__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ../../_internal/index.mjs */ "./node_modules/naive-ui/es/_internal/suffix/src/Suffix.mjs");
/* harmony import */ var _internal_index_mjs__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ../../_internal/index.mjs */ "./node_modules/naive-ui/es/_internal/icon/src/Icon.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-theme.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-config.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-style.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-locale.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-form-item.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-css-vars-class.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/naive/warn.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/vue/call.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/cssr/index.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/vue/resolve-slot.mjs");
/* harmony import */ var _styles_index_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../styles/index.mjs */ "./node_modules/naive-ui/es/input/styles/light.mjs");
/* harmony import */ var _interface_mjs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./interface.mjs */ "./node_modules/naive-ui/es/input/src/interface.mjs");
/* harmony import */ var _utils_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./utils.mjs */ "./node_modules/naive-ui/es/input/src/utils.mjs");
/* harmony import */ var _WordCount_mjs__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./WordCount.mjs */ "./node_modules/naive-ui/es/input/src/WordCount.mjs");
/* harmony import */ var _styles_input_cssr_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./styles/input.cssr.mjs */ "./node_modules/naive-ui/es/input/src/styles/input.cssr.mjs");
















const inputProps = Object.assign(Object.assign({}, _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].props), {
  bordered: {
    type: Boolean,
    default: undefined
  },
  type: {
    type: String,
    default: 'text'
  },
  placeholder: [Array, String],
  defaultValue: {
    type: [String, Array],
    default: null
  },
  value: [String, Array],
  disabled: {
    type: Boolean,
    default: undefined
  },
  size: String,
  rows: {
    type: [Number, String],
    default: 3
  },
  round: Boolean,
  minlength: [String, Number],
  maxlength: [String, Number],
  clearable: Boolean,
  autosize: {
    type: [Boolean, Object],
    default: false
  },
  pair: Boolean,
  separator: String,
  readonly: {
    type: [String, Boolean],
    default: false
  },
  passivelyActivated: Boolean,
  showPasswordOn: String,
  stateful: {
    type: Boolean,
    default: true
  },
  autofocus: Boolean,
  inputProps: Object,
  resizable: {
    type: Boolean,
    default: true
  },
  showCount: Boolean,
  loading: {
    type: Boolean,
    default: undefined
  },
  allowInput: Function,
  renderCount: Function,
  onMousedown: Function,
  onKeydown: Function,
  onKeyup: [Function, Array],
  onInput: [Function, Array],
  onFocus: [Function, Array],
  onBlur: [Function, Array],
  onClick: [Function, Array],
  onChange: [Function, Array],
  onClear: [Function, Array],
  countGraphemes: Function,
  status: String,
  'onUpdate:value': [Function, Array],
  onUpdateValue: [Function, Array],
  /** private */
  textDecoration: [String, Array],
  attrSize: {
    type: Number,
    default: 20
  },
  onInputBlur: [Function, Array],
  onInputFocus: [Function, Array],
  onDeactivate: [Function, Array],
  onActivate: [Function, Array],
  onWrapperFocus: [Function, Array],
  onWrapperBlur: [Function, Array],
  internalDeactivateOnEnter: Boolean,
  internalForceFocus: Boolean,
  internalLoadingBeforeSuffix: {
    type: Boolean,
    default: true
  },
  /** deprecated */
  showPasswordToggle: Boolean
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'Input',
  props: inputProps,
  setup(props) {
    if (true) {
      (0,vue__WEBPACK_IMPORTED_MODULE_0__.watchEffect)(() => {
        if (props.showPasswordToggle) {
          (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_2__.warnOnce)('input', '`show-password-toggle` is deprecated, please use `showPasswordOn="click"` instead');
        }
      });
    }
    const {
      mergedClsPrefixRef,
      mergedBorderedRef,
      inlineThemeDisabled,
      mergedRtlRef
    } = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_3__["default"])(props);
    const themeRef = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])('Input', '-input', _styles_input_cssr_mjs__WEBPACK_IMPORTED_MODULE_4__["default"], _styles_index_mjs__WEBPACK_IMPORTED_MODULE_5__["default"], props, mergedClsPrefixRef);
    if (_utils_env_browser_mjs__WEBPACK_IMPORTED_MODULE_6__.isSafari) {
      (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_7__["default"])('-input-safari', _styles_input_cssr_mjs__WEBPACK_IMPORTED_MODULE_4__.safariStyle, mergedClsPrefixRef);
    }
    // dom refs
    const wrapperElRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    const textareaElRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    const textareaMirrorElRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    const inputMirrorElRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    const inputElRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    const inputEl2Ref = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    const currentFocusedInputRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    const focusedInputCursorControl = (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_8__.useCursor)(currentFocusedInputRef);
    const textareaScrollbarInstRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    // local
    const {
      localeRef
    } = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_9__["default"])('Input');
    // value
    const uncontrolledValueRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(props.defaultValue);
    const controlledValueRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'value');
    const mergedValueRef = (0,vooks__WEBPACK_IMPORTED_MODULE_10__["default"])(controlledValueRef, uncontrolledValueRef);
    // form-item
    const formItem = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_11__["default"])(props);
    const {
      mergedSizeRef,
      mergedDisabledRef,
      mergedStatusRef
    } = formItem;
    // states
    const focusedRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    const hoverRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    const isComposingRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    const activatedRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    let syncSource = null;
    // placeholder
    const mergedPlaceholderRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const {
        placeholder,
        pair
      } = props;
      if (pair) {
        if (Array.isArray(placeholder)) {
          return placeholder;
        } else if (placeholder === undefined) {
          return ['', ''];
        }
        return [placeholder, placeholder];
      } else if (placeholder === undefined) {
        return [localeRef.value.placeholder];
      } else {
        return [placeholder];
      }
    });
    const showPlaceholder1Ref = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const {
        value: isComposing
      } = isComposingRef;
      const {
        value: mergedValue
      } = mergedValueRef;
      const {
        value: mergedPlaceholder
      } = mergedPlaceholderRef;
      return !isComposing && ((0,_utils_mjs__WEBPACK_IMPORTED_MODULE_8__.isEmptyInputValue)(mergedValue) || Array.isArray(mergedValue) && (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_8__.isEmptyInputValue)(mergedValue[0])) && mergedPlaceholder[0];
    });
    const showPlaceholder2Ref = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const {
        value: isComposing
      } = isComposingRef;
      const {
        value: mergedValue
      } = mergedValueRef;
      const {
        value: mergedPlaceholder
      } = mergedPlaceholderRef;
      return !isComposing && mergedPlaceholder[1] && ((0,_utils_mjs__WEBPACK_IMPORTED_MODULE_8__.isEmptyInputValue)(mergedValue) || Array.isArray(mergedValue) && (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_8__.isEmptyInputValue)(mergedValue[1]));
    });
    // focus
    const mergedFocusRef = (0,vooks__WEBPACK_IMPORTED_MODULE_12__["default"])(() => {
      return props.internalForceFocus || focusedRef.value;
    });
    // clear
    const showClearButton = (0,vooks__WEBPACK_IMPORTED_MODULE_12__["default"])(() => {
      if (mergedDisabledRef.value || props.readonly || !props.clearable || !mergedFocusRef.value && !hoverRef.value) {
        return false;
      }
      const {
        value: mergedValue
      } = mergedValueRef;
      const {
        value: mergedFocus
      } = mergedFocusRef;
      if (props.pair) {
        return !!(Array.isArray(mergedValue) && (mergedValue[0] || mergedValue[1])) && (hoverRef.value || mergedFocus);
      } else {
        return !!mergedValue && (hoverRef.value || mergedFocus);
      }
    });
    // passwordVisible
    const mergedShowPasswordOnRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const {
        showPasswordOn
      } = props;
      if (showPasswordOn) {
        return showPasswordOn;
      }
      if (props.showPasswordToggle) return 'click';
      return undefined;
    });
    const passwordVisibleRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    // text-decoration
    const textDecorationStyleRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const {
        textDecoration
      } = props;
      if (!textDecoration) return ['', ''];
      if (Array.isArray(textDecoration)) {
        return textDecoration.map(v => ({
          textDecoration: v
        }));
      }
      return [{
        textDecoration
      }];
    });
    const textAreaScrollContainerWidthRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(undefined);
    // textarea autosize
    const updateTextAreaStyle = () => {
      var _a, _b;
      if (props.type === 'textarea') {
        const {
          autosize
        } = props;
        if (autosize) {
          textAreaScrollContainerWidthRef.value = (_b = (_a = textareaScrollbarInstRef.value) === null || _a === void 0 ? void 0 : _a.$el) === null || _b === void 0 ? void 0 : _b.offsetWidth;
        }
        if (!textareaElRef.value) return;
        if (typeof autosize === 'boolean') return;
        const {
          paddingTop: stylePaddingTop,
          paddingBottom: stylePaddingBottom,
          lineHeight: styleLineHeight
        } = window.getComputedStyle(textareaElRef.value);
        const paddingTop = Number(stylePaddingTop.slice(0, -2));
        const paddingBottom = Number(stylePaddingBottom.slice(0, -2));
        const lineHeight = Number(styleLineHeight.slice(0, -2));
        const {
          value: textareaMirrorEl
        } = textareaMirrorElRef;
        if (!textareaMirrorEl) return;
        if (autosize.minRows) {
          const minRows = Math.max(autosize.minRows, 1);
          const styleMinHeight = `${paddingTop + paddingBottom + lineHeight * minRows}px`;
          textareaMirrorEl.style.minHeight = styleMinHeight;
        }
        if (autosize.maxRows) {
          const styleMaxHeight = `${paddingTop + paddingBottom + lineHeight * autosize.maxRows}px`;
          textareaMirrorEl.style.maxHeight = styleMaxHeight;
        }
      }
    };
    // word count
    const maxlengthRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const {
        maxlength
      } = props;
      return maxlength === undefined ? undefined : Number(maxlength);
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(() => {
      // sync mirror if is not pair
      const {
        value
      } = mergedValueRef;
      if (!Array.isArray(value)) {
        syncMirror(value);
      }
    });
    // other methods
    const vm = (0,vue__WEBPACK_IMPORTED_MODULE_0__.getCurrentInstance)().proxy;
    function doUpdateValue(value, meta) {
      const {
        onUpdateValue,
        'onUpdate:value': _onUpdateValue,
        onInput
      } = props;
      const {
        nTriggerFormInput
      } = formItem;
      if (onUpdateValue) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__.call)(onUpdateValue, value, meta);
      if (_onUpdateValue) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__.call)(_onUpdateValue, value, meta);
      if (onInput) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__.call)(onInput, value, meta);
      uncontrolledValueRef.value = value;
      nTriggerFormInput();
    }
    function doChange(value, meta) {
      const {
        onChange
      } = props;
      const {
        nTriggerFormChange
      } = formItem;
      if (onChange) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__.call)(onChange, value, meta);
      uncontrolledValueRef.value = value;
      nTriggerFormChange();
    }
    function doBlur(e) {
      const {
        onBlur
      } = props;
      const {
        nTriggerFormBlur
      } = formItem;
      if (onBlur) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__.call)(onBlur, e);
      nTriggerFormBlur();
    }
    function doFocus(e) {
      const {
        onFocus
      } = props;
      const {
        nTriggerFormFocus
      } = formItem;
      if (onFocus) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__.call)(onFocus, e);
      nTriggerFormFocus();
    }
    function doClear(e) {
      const {
        onClear
      } = props;
      if (onClear) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__.call)(onClear, e);
    }
    function doUpdateValueBlur(e) {
      const {
        onInputBlur
      } = props;
      if (onInputBlur) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__.call)(onInputBlur, e);
    }
    function doUpdateValueFocus(e) {
      const {
        onInputFocus
      } = props;
      if (onInputFocus) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__.call)(onInputFocus, e);
    }
    function doDeactivate() {
      const {
        onDeactivate
      } = props;
      if (onDeactivate) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__.call)(onDeactivate);
    }
    function doActivate() {
      const {
        onActivate
      } = props;
      if (onActivate) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__.call)(onActivate);
    }
    function doClick(e) {
      const {
        onClick
      } = props;
      if (onClick) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__.call)(onClick, e);
    }
    function doWrapperFocus(e) {
      const {
        onWrapperFocus
      } = props;
      if (onWrapperFocus) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__.call)(onWrapperFocus, e);
    }
    function doWrapperBlur(e) {
      const {
        onWrapperBlur
      } = props;
      if (onWrapperBlur) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__.call)(onWrapperBlur, e);
    }
    // methods
    function handleCompositionStart() {
      isComposingRef.value = true;
    }
    function handleCompositionEnd(e) {
      isComposingRef.value = false;
      if (e.target === inputEl2Ref.value) {
        handleInput(e, 1);
      } else {
        handleInput(e, 0);
      }
    }
    function handleInput(e, index = 0, event = 'input') {
      const targetValue = e.target.value;
      syncMirror(targetValue);
      if (e instanceof InputEvent && !e.isComposing) {
        isComposingRef.value = false;
      }
      if (props.type === 'textarea') {
        const {
          value: textareaScrollbarInst
        } = textareaScrollbarInstRef;
        if (textareaScrollbarInst) {
          textareaScrollbarInst.syncUnifiedContainer();
        }
      }
      syncSource = targetValue;
      if (isComposingRef.value) return;
      focusedInputCursorControl.recordCursor();
      const isIncomingValueValid = allowInput(targetValue);
      if (isIncomingValueValid) {
        if (!props.pair) {
          if (event === 'input') {
            doUpdateValue(targetValue, {
              source: index
            });
          } else {
            doChange(targetValue, {
              source: index
            });
          }
        } else {
          let {
            value
          } = mergedValueRef;
          if (!Array.isArray(value)) {
            value = ['', ''];
          } else {
            value = [value[0], value[1]];
          }
          value[index] = targetValue;
          if (event === 'input') {
            doUpdateValue(value, {
              source: index
            });
          } else {
            doChange(value, {
              source: index
            });
          }
        }
      }
      // force update to sync input's view with value
      // if not set, after input, input value won't sync with dom input value
      vm.$forceUpdate();
      if (!isIncomingValueValid) {
        void (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(focusedInputCursorControl.restoreCursor);
      }
    }
    function allowInput(value) {
      const {
        countGraphemes,
        maxlength,
        minlength
      } = props;
      if (countGraphemes) {
        let graphemesCount;
        if (maxlength !== undefined) {
          if (graphemesCount === undefined) {
            graphemesCount = countGraphemes(value);
          }
          if (graphemesCount > Number(maxlength)) return false;
        }
        if (minlength !== undefined) {
          if (graphemesCount === undefined) {
            graphemesCount = countGraphemes(value);
          }
          if (graphemesCount < Number(maxlength)) return false;
        }
      }
      const {
        allowInput
      } = props;
      if (typeof allowInput === 'function') {
        return allowInput(value);
      }
      return true;
    }
    function handleInputBlur(e) {
      doUpdateValueBlur(e);
      if (e.relatedTarget === wrapperElRef.value) {
        doDeactivate();
      }
      if (!(e.relatedTarget !== null && (e.relatedTarget === inputElRef.value || e.relatedTarget === inputEl2Ref.value || e.relatedTarget === textareaElRef.value))) {
        activatedRef.value = false;
      }
      dealWithEvent(e, 'blur');
      currentFocusedInputRef.value = null;
    }
    function handleInputFocus(e, index) {
      doUpdateValueFocus(e);
      focusedRef.value = true;
      activatedRef.value = true;
      doActivate();
      dealWithEvent(e, 'focus');
      if (index === 0) {
        currentFocusedInputRef.value = inputElRef.value;
      } else if (index === 1) {
        currentFocusedInputRef.value = inputEl2Ref.value;
      } else if (index === 2) {
        currentFocusedInputRef.value = textareaElRef.value;
      }
    }
    function handleWrapperBlur(e) {
      if (props.passivelyActivated) {
        doWrapperBlur(e);
        dealWithEvent(e, 'blur');
      }
    }
    function handleWrapperFocus(e) {
      if (props.passivelyActivated) {
        focusedRef.value = true;
        doWrapperFocus(e);
        dealWithEvent(e, 'focus');
      }
    }
    function dealWithEvent(e, type) {
      if (e.relatedTarget !== null && (e.relatedTarget === inputElRef.value || e.relatedTarget === inputEl2Ref.value || e.relatedTarget === textareaElRef.value || e.relatedTarget === wrapperElRef.value)) {
        /**
         * activeElement transfer inside the input, do nothing
         */
      } else {
        if (type === 'focus') {
          doFocus(e);
          focusedRef.value = true;
        } else if (type === 'blur') {
          doBlur(e);
          focusedRef.value = false;
        }
      }
    }
    function handleChange(e, index) {
      handleInput(e, index, 'change');
    }
    function handleClick(e) {
      doClick(e);
    }
    function handleClear(e) {
      doClear(e);
      clearValue();
    }
    function clearValue() {
      if (props.pair) {
        doUpdateValue(['', ''], {
          source: 'clear'
        });
        doChange(['', ''], {
          source: 'clear'
        });
      } else {
        doUpdateValue('', {
          source: 'clear'
        });
        doChange('', {
          source: 'clear'
        });
      }
    }
    function handleMouseDown(e) {
      const {
        onMousedown
      } = props;
      if (onMousedown) onMousedown(e);
      const {
        tagName
      } = e.target;
      if (tagName !== 'INPUT' && tagName !== 'TEXTAREA') {
        if (props.resizable) {
          const {
            value: wrapperEl
          } = wrapperElRef;
          if (wrapperEl) {
            const {
              left,
              top,
              width,
              height
            } = wrapperEl.getBoundingClientRect();
            const resizeHandleSize = 14;
            if (left + width - resizeHandleSize < e.clientX && e.clientX < left + width && top + height - resizeHandleSize < e.clientY && e.clientY < top + height) {
              // touching resize handle, just let it go.
              // resize won't take focus, maybe there is a better way to do this.
              // hope someone can figure out a better solution
              return;
            }
          }
        }
        e.preventDefault();
        if (!focusedRef.value) {
          focus();
        }
      }
    }
    function handleMouseEnter() {
      var _a;
      hoverRef.value = true;
      if (props.type === 'textarea') {
        (_a = textareaScrollbarInstRef.value) === null || _a === void 0 ? void 0 : _a.handleMouseEnterWrapper();
      }
    }
    function handleMouseLeave() {
      var _a;
      hoverRef.value = false;
      if (props.type === 'textarea') {
        (_a = textareaScrollbarInstRef.value) === null || _a === void 0 ? void 0 : _a.handleMouseLeaveWrapper();
      }
    }
    function handlePasswordToggleClick() {
      if (mergedDisabledRef.value) return;
      if (mergedShowPasswordOnRef.value !== 'click') return;
      passwordVisibleRef.value = !passwordVisibleRef.value;
    }
    function handlePasswordToggleMousedown(e) {
      if (mergedDisabledRef.value) return;
      e.preventDefault();
      const preventDefaultOnce = e => {
        e.preventDefault();
        (0,evtd__WEBPACK_IMPORTED_MODULE_14__.off)('mouseup', document, preventDefaultOnce);
      };
      (0,evtd__WEBPACK_IMPORTED_MODULE_14__.on)('mouseup', document, preventDefaultOnce);
      if (mergedShowPasswordOnRef.value !== 'mousedown') return;
      passwordVisibleRef.value = true;
      const hidePassword = () => {
        passwordVisibleRef.value = false;
        (0,evtd__WEBPACK_IMPORTED_MODULE_14__.off)('mouseup', document, hidePassword);
      };
      (0,evtd__WEBPACK_IMPORTED_MODULE_14__.on)('mouseup', document, hidePassword);
    }
    function handleWrapperKeyup(e) {
      if (props.onKeyup) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__.call)(props.onKeyup, e);
    }
    function handleWrapperKeydown(e) {
      if (props.onKeydown) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__.call)(props.onKeydown, e);
      switch (e.key) {
        case 'Escape':
          handleWrapperKeydownEsc();
          break;
        case 'Enter':
          handleWrapperKeydownEnter(e);
          break;
      }
    }
    function handleWrapperKeydownEnter(e) {
      var _a, _b;
      if (props.passivelyActivated) {
        const {
          value: focused
        } = activatedRef;
        if (focused) {
          if (props.internalDeactivateOnEnter) {
            handleWrapperKeydownEsc();
          }
          return;
        }
        e.preventDefault();
        if (props.type === 'textarea') {
          (_a = textareaElRef.value) === null || _a === void 0 ? void 0 : _a.focus();
        } else {
          (_b = inputElRef.value) === null || _b === void 0 ? void 0 : _b.focus();
        }
      }
    }
    function handleWrapperKeydownEsc() {
      if (props.passivelyActivated) {
        activatedRef.value = false;
        void (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(() => {
          var _a;
          (_a = wrapperElRef.value) === null || _a === void 0 ? void 0 : _a.focus();
        });
      }
    }
    function focus() {
      var _a, _b, _c;
      if (mergedDisabledRef.value) return;
      if (props.passivelyActivated) {
        (_a = wrapperElRef.value) === null || _a === void 0 ? void 0 : _a.focus();
      } else {
        (_b = textareaElRef.value) === null || _b === void 0 ? void 0 : _b.focus();
        (_c = inputElRef.value) === null || _c === void 0 ? void 0 : _c.focus();
      }
    }
    function blur() {
      var _a;
      if ((_a = wrapperElRef.value) === null || _a === void 0 ? void 0 : _a.contains(document.activeElement)) {
        ;
        document.activeElement.blur();
      }
    }
    function select() {
      var _a, _b;
      (_a = textareaElRef.value) === null || _a === void 0 ? void 0 : _a.select();
      (_b = inputElRef.value) === null || _b === void 0 ? void 0 : _b.select();
    }
    function activate() {
      if (mergedDisabledRef.value) return;
      if (textareaElRef.value) textareaElRef.value.focus();else if (inputElRef.value) inputElRef.value.focus();
    }
    function deactivate() {
      const {
        value: wrapperEl
      } = wrapperElRef;
      if ((wrapperEl === null || wrapperEl === void 0 ? void 0 : wrapperEl.contains(document.activeElement)) && wrapperEl !== document.activeElement) {
        handleWrapperKeydownEsc();
      }
    }
    function scrollTo(options) {
      if (props.type === 'textarea') {
        const {
          value: textareaEl
        } = textareaElRef;
        textareaEl === null || textareaEl === void 0 ? void 0 : textareaEl.scrollTo(options);
      } else {
        const {
          value: inputEl
        } = inputElRef;
        inputEl === null || inputEl === void 0 ? void 0 : inputEl.scrollTo(options);
      }
    }
    function syncMirror(value) {
      const {
        type,
        pair,
        autosize
      } = props;
      if (!pair && autosize) {
        if (type === 'textarea') {
          const {
            value: textareaMirrorEl
          } = textareaMirrorElRef;
          if (textareaMirrorEl) {
            textareaMirrorEl.textContent = `${value !== null && value !== void 0 ? value : ''}\r\n`;
          }
        } else {
          const {
            value: inputMirrorEl
          } = inputMirrorElRef;
          if (inputMirrorEl) {
            if (value) {
              inputMirrorEl.textContent = value;
            } else {
              inputMirrorEl.innerHTML = '&nbsp;';
            }
          }
        }
      }
    }
    function handleTextAreaMirrorResize() {
      updateTextAreaStyle();
    }
    const placeholderStyleRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)({
      top: '0'
    });
    function handleTextAreaScroll(e) {
      var _a;
      const {
        scrollTop
      } = e.target;
      placeholderStyleRef.value.top = `${-scrollTop}px`;
      (_a = textareaScrollbarInstRef.value) === null || _a === void 0 ? void 0 : _a.syncUnifiedContainer();
    }
    let stopWatchMergedValue1 = null;
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watchEffect)(() => {
      const {
        autosize,
        type
      } = props;
      if (autosize && type === 'textarea') {
        stopWatchMergedValue1 = (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(mergedValueRef, value => {
          if (!Array.isArray(value) && value !== syncSource) {
            syncMirror(value);
          }
        });
      } else {
        stopWatchMergedValue1 === null || stopWatchMergedValue1 === void 0 ? void 0 : stopWatchMergedValue1();
      }
    });
    let stopWatchMergedValue2 = null;
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watchEffect)(() => {
      if (props.type === 'textarea') {
        stopWatchMergedValue2 = (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(mergedValueRef, value => {
          var _a;
          if (!Array.isArray(value) && value !== syncSource) {
            (_a = textareaScrollbarInstRef.value) === null || _a === void 0 ? void 0 : _a.syncUnifiedContainer();
          }
        });
      } else {
        stopWatchMergedValue2 === null || stopWatchMergedValue2 === void 0 ? void 0 : stopWatchMergedValue2();
      }
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.provide)(_interface_mjs__WEBPACK_IMPORTED_MODULE_15__.inputInjectionKey, {
      mergedValueRef,
      maxlengthRef,
      mergedClsPrefixRef,
      countGraphemesRef: (0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'countGraphemes')
    });
    const exposedProps = {
      wrapperElRef,
      inputElRef,
      textareaElRef,
      isCompositing: isComposingRef,
      clear: clearValue,
      focus,
      blur,
      select,
      deactivate,
      activate,
      scrollTo
    };
    const rtlEnabledRef = (0,_mixins_use_rtl_mjs__WEBPACK_IMPORTED_MODULE_16__.useRtl)('Input', mergedRtlRef, mergedClsPrefixRef);
    const cssVarsRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const {
        value: size
      } = mergedSizeRef;
      const {
        common: {
          cubicBezierEaseInOut
        },
        self: {
          color,
          borderRadius,
          textColor,
          caretColor,
          caretColorError,
          caretColorWarning,
          textDecorationColor,
          border,
          borderDisabled,
          borderHover,
          borderFocus,
          placeholderColor,
          placeholderColorDisabled,
          lineHeightTextarea,
          colorDisabled,
          colorFocus,
          textColorDisabled,
          boxShadowFocus,
          iconSize,
          colorFocusWarning,
          boxShadowFocusWarning,
          borderWarning,
          borderFocusWarning,
          borderHoverWarning,
          colorFocusError,
          boxShadowFocusError,
          borderError,
          borderFocusError,
          borderHoverError,
          clearSize,
          clearColor,
          clearColorHover,
          clearColorPressed,
          iconColor,
          iconColorDisabled,
          suffixTextColor,
          countTextColor,
          countTextColorDisabled,
          iconColorHover,
          iconColorPressed,
          loadingColor,
          loadingColorError,
          loadingColorWarning,
          [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_17__.createKey)('padding', size)]: padding,
          [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_17__.createKey)('fontSize', size)]: fontSize,
          [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_17__.createKey)('height', size)]: height
        }
      } = themeRef.value;
      const {
        left: paddingLeft,
        right: paddingRight
      } = (0,seemly__WEBPACK_IMPORTED_MODULE_18__.getPadding)(padding);
      return {
        '--n-bezier': cubicBezierEaseInOut,
        '--n-count-text-color': countTextColor,
        '--n-count-text-color-disabled': countTextColorDisabled,
        '--n-color': color,
        '--n-font-size': fontSize,
        '--n-border-radius': borderRadius,
        '--n-height': height,
        '--n-padding-left': paddingLeft,
        '--n-padding-right': paddingRight,
        '--n-text-color': textColor,
        '--n-caret-color': caretColor,
        '--n-text-decoration-color': textDecorationColor,
        '--n-border': border,
        '--n-border-disabled': borderDisabled,
        '--n-border-hover': borderHover,
        '--n-border-focus': borderFocus,
        '--n-placeholder-color': placeholderColor,
        '--n-placeholder-color-disabled': placeholderColorDisabled,
        '--n-icon-size': iconSize,
        '--n-line-height-textarea': lineHeightTextarea,
        '--n-color-disabled': colorDisabled,
        '--n-color-focus': colorFocus,
        '--n-text-color-disabled': textColorDisabled,
        '--n-box-shadow-focus': boxShadowFocus,
        '--n-loading-color': loadingColor,
        // form warning
        '--n-caret-color-warning': caretColorWarning,
        '--n-color-focus-warning': colorFocusWarning,
        '--n-box-shadow-focus-warning': boxShadowFocusWarning,
        '--n-border-warning': borderWarning,
        '--n-border-focus-warning': borderFocusWarning,
        '--n-border-hover-warning': borderHoverWarning,
        '--n-loading-color-warning': loadingColorWarning,
        // form error
        '--n-caret-color-error': caretColorError,
        '--n-color-focus-error': colorFocusError,
        '--n-box-shadow-focus-error': boxShadowFocusError,
        '--n-border-error': borderError,
        '--n-border-focus-error': borderFocusError,
        '--n-border-hover-error': borderHoverError,
        '--n-loading-color-error': loadingColorError,
        // clear-button
        '--n-clear-color': clearColor,
        '--n-clear-size': clearSize,
        '--n-clear-color-hover': clearColorHover,
        '--n-clear-color-pressed': clearColorPressed,
        '--n-icon-color': iconColor,
        '--n-icon-color-hover': iconColorHover,
        '--n-icon-color-pressed': iconColorPressed,
        '--n-icon-color-disabled': iconColorDisabled,
        '--n-suffix-text-color': suffixTextColor
      };
    });
    const themeClassHandle = inlineThemeDisabled ? (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_19__.useThemeClass)('input', (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const {
        value: size
      } = mergedSizeRef;
      return size[0];
    }), cssVarsRef, props) : undefined;
    return Object.assign(Object.assign({}, exposedProps), {
      // DOM ref
      wrapperElRef,
      inputElRef,
      inputMirrorElRef,
      inputEl2Ref,
      textareaElRef,
      textareaMirrorElRef,
      textareaScrollbarInstRef,
      // value
      rtlEnabled: rtlEnabledRef,
      uncontrolledValue: uncontrolledValueRef,
      mergedValue: mergedValueRef,
      passwordVisible: passwordVisibleRef,
      mergedPlaceholder: mergedPlaceholderRef,
      showPlaceholder1: showPlaceholder1Ref,
      showPlaceholder2: showPlaceholder2Ref,
      mergedFocus: mergedFocusRef,
      isComposing: isComposingRef,
      activated: activatedRef,
      showClearButton,
      mergedSize: mergedSizeRef,
      mergedDisabled: mergedDisabledRef,
      textDecorationStyle: textDecorationStyleRef,
      mergedClsPrefix: mergedClsPrefixRef,
      mergedBordered: mergedBorderedRef,
      mergedShowPasswordOn: mergedShowPasswordOnRef,
      placeholderStyle: placeholderStyleRef,
      mergedStatus: mergedStatusRef,
      textAreaScrollContainerWidth: textAreaScrollContainerWidthRef,
      // methods
      handleTextAreaScroll,
      handleCompositionStart,
      handleCompositionEnd,
      handleInput,
      handleInputBlur,
      handleInputFocus,
      handleWrapperBlur,
      handleWrapperFocus,
      handleMouseEnter,
      handleMouseLeave,
      handleMouseDown,
      handleChange,
      handleClick,
      handleClear,
      handlePasswordToggleClick,
      handlePasswordToggleMousedown,
      handleWrapperKeydown,
      handleWrapperKeyup,
      handleTextAreaMirrorResize,
      getTextareaScrollContainer: () => {
        return textareaElRef.value;
      },
      mergedTheme: themeRef,
      cssVars: inlineThemeDisabled ? undefined : cssVarsRef,
      themeClass: themeClassHandle === null || themeClassHandle === void 0 ? void 0 : themeClassHandle.themeClass,
      onRender: themeClassHandle === null || themeClassHandle === void 0 ? void 0 : themeClassHandle.onRender
    });
  },
  render() {
    var _a, _b;
    const {
      mergedClsPrefix,
      mergedStatus,
      themeClass,
      type,
      countGraphemes,
      onRender
    } = this;
    const $slots = this.$slots;
    onRender === null || onRender === void 0 ? void 0 : onRender();
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      ref: "wrapperElRef",
      class: [`${mergedClsPrefix}-input`, themeClass, mergedStatus && `${mergedClsPrefix}-input--${mergedStatus}-status`, {
        [`${mergedClsPrefix}-input--rtl`]: this.rtlEnabled,
        [`${mergedClsPrefix}-input--disabled`]: this.mergedDisabled,
        [`${mergedClsPrefix}-input--textarea`]: type === 'textarea',
        [`${mergedClsPrefix}-input--resizable`]: this.resizable && !this.autosize,
        [`${mergedClsPrefix}-input--autosize`]: this.autosize,
        [`${mergedClsPrefix}-input--round`]: this.round && !(type === 'textarea'),
        [`${mergedClsPrefix}-input--pair`]: this.pair,
        [`${mergedClsPrefix}-input--focus`]: this.mergedFocus,
        [`${mergedClsPrefix}-input--stateful`]: this.stateful
      }],
      style: this.cssVars,
      tabindex: !this.mergedDisabled && this.passivelyActivated && !this.activated ? 0 : undefined,
      onFocus: this.handleWrapperFocus,
      onBlur: this.handleWrapperBlur,
      onClick: this.handleClick,
      onMousedown: this.handleMouseDown,
      onMouseenter: this.handleMouseEnter,
      onMouseleave: this.handleMouseLeave,
      onCompositionstart: this.handleCompositionStart,
      onCompositionend: this.handleCompositionEnd,
      onKeyup: this.handleWrapperKeyup,
      onKeydown: this.handleWrapperKeydown
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${mergedClsPrefix}-input-wrapper`
    }, (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_20__.resolveWrappedSlot)($slots.prefix, children => children && (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${mergedClsPrefix}-input__prefix`
    }, children)), type === 'textarea' ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_internal_index_mjs__WEBPACK_IMPORTED_MODULE_21__["default"], {
      ref: "textareaScrollbarInstRef",
      class: `${mergedClsPrefix}-input__textarea`,
      container: this.getTextareaScrollContainer,
      triggerDisplayManually: true,
      useUnifiedContainer: true,
      internalHoistYRail: true
    }, {
      default: () => {
        var _a, _b;
        const {
          textAreaScrollContainerWidth
        } = this;
        const scrollContainerWidthStyle = {
          width: this.autosize && textAreaScrollContainerWidth && `${textAreaScrollContainerWidth}px`
        };
        return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("textarea", Object.assign({}, this.inputProps, {
          ref: "textareaElRef",
          class: [`${mergedClsPrefix}-input__textarea-el`, (_a = this.inputProps) === null || _a === void 0 ? void 0 : _a.class],
          autofocus: this.autofocus,
          rows: Number(this.rows),
          placeholder: this.placeholder,
          value: this.mergedValue,
          disabled: this.mergedDisabled,
          maxlength: countGraphemes ? undefined : this.maxlength,
          minlength: countGraphemes ? undefined : this.minlength,
          readonly: this.readonly,
          tabindex: this.passivelyActivated && !this.activated ? -1 : undefined,
          style: [this.textDecorationStyle[0], (_b = this.inputProps) === null || _b === void 0 ? void 0 : _b.style, scrollContainerWidthStyle],
          onBlur: this.handleInputBlur,
          onFocus: e => {
            this.handleInputFocus(e, 2);
          },
          onInput: this.handleInput,
          onChange: this.handleChange,
          onScroll: this.handleTextAreaScroll
        })), this.showPlaceholder1 ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
          class: `${mergedClsPrefix}-input__placeholder`,
          style: [this.placeholderStyle, scrollContainerWidthStyle],
          key: "placeholder"
        }, this.mergedPlaceholder[0]) : null, this.autosize ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vueuc__WEBPACK_IMPORTED_MODULE_22__["default"], {
          onResize: this.handleTextAreaMirrorResize
        }, {
          default: () => (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
            ref: "textareaMirrorElRef",
            class: `${mergedClsPrefix}-input__textarea-mirror`,
            key: "mirror"
          })
        }) : null);
      }
    }) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${mergedClsPrefix}-input__input`
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("input", Object.assign({
      type: type === 'password' && this.mergedShowPasswordOn && this.passwordVisible ? 'text' : type
    }, this.inputProps, {
      ref: "inputElRef",
      class: [`${mergedClsPrefix}-input__input-el`, (_a = this.inputProps) === null || _a === void 0 ? void 0 : _a.class],
      style: [this.textDecorationStyle[0], (_b = this.inputProps) === null || _b === void 0 ? void 0 : _b.style],
      tabindex: this.passivelyActivated && !this.activated ? -1 : undefined,
      placeholder: this.mergedPlaceholder[0],
      disabled: this.mergedDisabled,
      maxlength: countGraphemes ? undefined : this.maxlength,
      minlength: countGraphemes ? undefined : this.minlength,
      value: Array.isArray(this.mergedValue) ? this.mergedValue[0] : this.mergedValue,
      readonly: this.readonly,
      autofocus: this.autofocus,
      size: this.attrSize,
      onBlur: this.handleInputBlur,
      onFocus: e => {
        this.handleInputFocus(e, 0);
      },
      onInput: e => {
        this.handleInput(e, 0);
      },
      onChange: e => {
        this.handleChange(e, 0);
      }
    })), this.showPlaceholder1 ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${mergedClsPrefix}-input__placeholder`
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("span", null, this.mergedPlaceholder[0])) : null, this.autosize ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${mergedClsPrefix}-input__input-mirror`,
      key: "mirror",
      ref: "inputMirrorElRef"
    }, "\u00A0") : null), !this.pair && (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_20__.resolveWrappedSlot)($slots.suffix, children => {
      return children || this.clearable || this.showCount || this.mergedShowPasswordOn || this.loading !== undefined ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
        class: `${mergedClsPrefix}-input__suffix`
      }, [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_20__.resolveWrappedSlot)($slots['clear-icon-placeholder'], children => {
        return (this.clearable || children) && (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_internal_index_mjs__WEBPACK_IMPORTED_MODULE_23__["default"], {
          clsPrefix: mergedClsPrefix,
          show: this.showClearButton,
          onClear: this.handleClear
        }, {
          placeholder: () => children,
          icon: () => {
            var _a, _b;
            return (_b = (_a = this.$slots)['clear-icon']) === null || _b === void 0 ? void 0 : _b.call(_a);
          }
        });
      }), !this.internalLoadingBeforeSuffix ? children : null, this.loading !== undefined ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_internal_index_mjs__WEBPACK_IMPORTED_MODULE_24__["default"], {
        clsPrefix: mergedClsPrefix,
        loading: this.loading,
        showArrow: false,
        showClear: false,
        style: this.cssVars
      }) : null, this.internalLoadingBeforeSuffix ? children : null, this.showCount && this.type !== 'textarea' ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_WordCount_mjs__WEBPACK_IMPORTED_MODULE_25__["default"], null, {
        default: props => {
          var _a;
          return (_a = $slots.count) === null || _a === void 0 ? void 0 : _a.call($slots, props);
        }
      }) : null, this.mergedShowPasswordOn && this.type === 'password' ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
        class: `${mergedClsPrefix}-input__eye`,
        onMousedown: this.handlePasswordToggleMousedown,
        onClick: this.handlePasswordToggleClick
      }, this.passwordVisible ? (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_20__.resolveSlot)($slots['password-visible-icon'], () => [(0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_internal_index_mjs__WEBPACK_IMPORTED_MODULE_26__["default"], {
        clsPrefix: mergedClsPrefix
      }, {
        default: () => (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_internal_icons_index_mjs__WEBPACK_IMPORTED_MODULE_27__["default"], null)
      })]) : (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_20__.resolveSlot)($slots['password-invisible-icon'], () => [(0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_internal_index_mjs__WEBPACK_IMPORTED_MODULE_26__["default"], {
        clsPrefix: mergedClsPrefix
      }, {
        default: () => (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_internal_icons_index_mjs__WEBPACK_IMPORTED_MODULE_28__["default"], null)
      })])) : null]) : null;
    })), this.pair ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("span", {
      class: `${mergedClsPrefix}-input__separator`
    }, (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_20__.resolveSlot)($slots.separator, () => [this.separator])) : null, this.pair ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${mergedClsPrefix}-input-wrapper`
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${mergedClsPrefix}-input__input`
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("input", {
      ref: "inputEl2Ref",
      type: this.type,
      class: `${mergedClsPrefix}-input__input-el`,
      tabindex: this.passivelyActivated && !this.activated ? -1 : undefined,
      placeholder: this.mergedPlaceholder[1],
      disabled: this.mergedDisabled,
      maxlength: countGraphemes ? undefined : this.maxlength,
      minlength: countGraphemes ? undefined : this.minlength,
      value: Array.isArray(this.mergedValue) ? this.mergedValue[1] : undefined,
      readonly: this.readonly,
      style: this.textDecorationStyle[1],
      onBlur: this.handleInputBlur,
      onFocus: e => {
        this.handleInputFocus(e, 1);
      },
      onInput: e => {
        this.handleInput(e, 1);
      },
      onChange: e => {
        this.handleChange(e, 1);
      }
    }), this.showPlaceholder2 ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${mergedClsPrefix}-input__placeholder`
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("span", null, this.mergedPlaceholder[1])) : null), (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_20__.resolveWrappedSlot)($slots.suffix, children => {
      return (this.clearable || children) && (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
        class: `${mergedClsPrefix}-input__suffix`
      }, [this.clearable && (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_internal_index_mjs__WEBPACK_IMPORTED_MODULE_23__["default"], {
        clsPrefix: mergedClsPrefix,
        show: this.showClearButton,
        onClear: this.handleClear
      }, {
        icon: () => {
          var _a;
          return (_a = $slots['clear-icon']) === null || _a === void 0 ? void 0 : _a.call($slots);
        },
        placeholder: () => {
          var _a;
          return (_a = $slots['clear-icon-placeholder']) === null || _a === void 0 ? void 0 : _a.call($slots);
        }
      }), children]);
    })) : null, this.mergedBordered ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${mergedClsPrefix}-input__border`
    }) : null, this.mergedBordered ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${mergedClsPrefix}-input__state-border`
    }) : null, this.showCount && type === 'textarea' ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_WordCount_mjs__WEBPACK_IMPORTED_MODULE_25__["default"], null, {
      default: props => {
        var _a;
        const {
          renderCount
        } = this;
        if (renderCount) {
          return renderCount(props);
        }
        return (_a = $slots.count) === null || _a === void 0 ? void 0 : _a.call($slots, props);
      }
    }) : null);
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/input/src/WordCount.mjs":
/*!**********************************************************!*\
  !*** ./node_modules/naive-ui/es/input/src/WordCount.mjs ***!
  \**********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/vue/resolve-slot.mjs");
/* harmony import */ var _interface_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./interface.mjs */ "./node_modules/naive-ui/es/input/src/interface.mjs");
/* harmony import */ var _utils_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils.mjs */ "./node_modules/naive-ui/es/input/src/utils.mjs");




/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'InputWordCount',
  setup(_, {
    slots
  }) {
    const {
      mergedValueRef,
      maxlengthRef,
      mergedClsPrefixRef,
      countGraphemesRef
    } = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(_interface_mjs__WEBPACK_IMPORTED_MODULE_1__.inputInjectionKey);
    const wordCountRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const {
        value: mergedValue
      } = mergedValueRef;
      if (mergedValue === null || Array.isArray(mergedValue)) return 0;
      return (countGraphemesRef.value || _utils_mjs__WEBPACK_IMPORTED_MODULE_2__.len)(mergedValue);
    });
    return () => {
      const {
        value: maxlength
      } = maxlengthRef;
      const {
        value: mergedValue
      } = mergedValueRef;
      return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("span", {
        class: `${mergedClsPrefixRef.value}-input-word-count`
      }, (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_3__.resolveSlotWithProps)(slots.default, {
        value: mergedValue === null || Array.isArray(mergedValue) ? '' : mergedValue
      }, () => [maxlength === undefined ? wordCountRef.value : `${wordCountRef.value} / ${maxlength}`]));
    };
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/input/src/interface.mjs":
/*!**********************************************************!*\
  !*** ./node_modules/naive-ui/es/input/src/interface.mjs ***!
  \**********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   inputInjectionKey: () => (/* binding */ inputInjectionKey)
/* harmony export */ });
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/vue/create-injection-key.mjs");

const inputInjectionKey = (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_0__.createInjectionKey)('n-input');

/***/ }),

/***/ "./node_modules/naive-ui/es/input/src/styles/input.cssr.mjs":
/*!******************************************************************!*\
  !*** ./node_modules/naive-ui/es/input/src/styles/input.cssr.mjs ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   safariStyle: () => (/* binding */ safariStyle)
/* harmony export */ });
/* harmony import */ var _utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../_utils/cssr/index.mjs */ "./node_modules/naive-ui/es/_utils/cssr/index.mjs");

// vars:
// --n-bezier
// --n-color
// --n-font-size
// --n-border-radius
// --n-height
// --n-padding-left
// --n-padding-right
// --n-text-color
// --n-text-color-disabled
// --n-caret-color
// --n-text-decoration-color
// --n-border
// --n-border-disabled
// --n-border-hover
// --n-border-focus
// --n-placeholder-color
// --n-placeholder-color-disabled
// --n-line-height-textarea
// --n-color-disabled
// --n-color-focus
// --n-box-shadow-focus
// --n-clear-color
// --n-clear-size
// --n-clear-color-hover
// --n-clear-color-pressed
// --n-suffix-text-color
// --n-icon-color
// --n-icon-color-hover
// --n-icon-color-pressed
// --n-icon-color-disabled
// --n-count-text-color
// --n-count-text-color-disabled
// --n-loading-color
// ...form item vars
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('input', `
 max-width: 100%;
 cursor: text;
 line-height: 1.5;
 z-index: auto;
 outline: none;
 box-sizing: border-box;
 position: relative;
 display: inline-flex;
 border-radius: var(--n-border-radius);
 background-color: var(--n-color);
 transition: background-color .3s var(--n-bezier);
 font-size: var(--n-font-size);
 --n-padding-vertical: calc((var(--n-height) - 1.5 * var(--n-font-size)) / 2);
`, [
// common
(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('input, textarea', `
 overflow: hidden;
 flex-grow: 1;
 position: relative;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('input-el, textarea-el, input-mirror, textarea-mirror, separator, placeholder', `
 box-sizing: border-box;
 font-size: inherit;
 line-height: 1.5;
 font-family: inherit;
 border: none;
 outline: none;
 background-color: #0000;
 text-align: inherit;
 transition:
 -webkit-text-fill-color .3s var(--n-bezier),
 caret-color .3s var(--n-bezier),
 color .3s var(--n-bezier),
 text-decoration-color .3s var(--n-bezier);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('input-el, textarea-el', `
 -webkit-appearance: none;
 scrollbar-width: none;
 width: 100%;
 min-width: 0;
 text-decoration-color: var(--n-text-decoration-color);
 color: var(--n-text-color);
 caret-color: var(--n-caret-color);
 background-color: transparent;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&::-webkit-scrollbar, &::-webkit-scrollbar-track-piece, &::-webkit-scrollbar-thumb', `
 width: 0;
 height: 0;
 display: none;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&::placeholder', `
 color: #0000;
 -webkit-text-fill-color: transparent !important;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:-webkit-autofill ~', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('placeholder', 'display: none;')])]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('round', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cNotM)('textarea', 'border-radius: calc(var(--n-height) / 2);')]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('placeholder', `
 pointer-events: none;
 position: absolute;
 left: 0;
 right: 0;
 top: 0;
 bottom: 0;
 overflow: hidden;
 color: var(--n-placeholder-color);
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('span', `
 width: 100%;
 display: inline-block;
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('textarea', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('placeholder', 'overflow: visible;')]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cNotM)('autosize', 'width: 100%;'), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('autosize', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('textarea-el, input-el', `
 position: absolute;
 top: 0;
 left: 0;
 height: 100%;
 `)]),
// input
(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('input-wrapper', `
 overflow: hidden;
 display: inline-flex;
 flex-grow: 1;
 position: relative;
 padding-left: var(--n-padding-left);
 padding-right: var(--n-padding-right);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('input-mirror', `
 padding: 0;
 height: var(--n-height);
 line-height: var(--n-height);
 overflow: hidden;
 visibility: hidden;
 position: static;
 white-space: pre;
 pointer-events: none;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('input-el', `
 padding: 0;
 height: var(--n-height);
 line-height: var(--n-height);
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&[type=password]::-ms-reveal', 'display: none;'), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('+', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('placeholder', `
 display: flex;
 align-items: center; 
 `)])]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cNotM)('textarea', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('placeholder', 'white-space: nowrap;')]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('eye', `
 display: flex;
 align-items: center;
 justify-content: center;
 transition: color .3s var(--n-bezier);
 `),
// textarea
(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('textarea', 'width: 100%;', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('input-word-count', `
 position: absolute;
 right: var(--n-padding-right);
 bottom: var(--n-padding-vertical);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('resizable', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('input-wrapper', `
 resize: vertical;
 min-height: var(--n-height);
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('textarea-el, textarea-mirror, placeholder', `
 height: 100%;
 padding-left: 0;
 padding-right: 0;
 padding-top: var(--n-padding-vertical);
 padding-bottom: var(--n-padding-vertical);
 word-break: break-word;
 display: inline-block;
 vertical-align: bottom;
 box-sizing: border-box;
 line-height: var(--n-line-height-textarea);
 margin: 0;
 resize: none;
 white-space: pre-wrap;
 scroll-padding-block-end: var(--n-padding-vertical);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('textarea-mirror', `
 width: 100%;
 pointer-events: none;
 overflow: hidden;
 visibility: hidden;
 position: static;
 white-space: pre-wrap;
 overflow-wrap: break-word;
 `)]),
// pair
(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('pair', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('input-el, placeholder', 'text-align: center;'), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('separator', `
 display: flex;
 align-items: center;
 transition: color .3s var(--n-bezier);
 color: var(--n-text-color);
 white-space: nowrap;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('icon', `
 color: var(--n-icon-color);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-icon', `
 color: var(--n-icon-color);
 `)])]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('disabled', `
 cursor: not-allowed;
 background-color: var(--n-color-disabled);
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('border', 'border: var(--n-border-disabled);'), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('input-el, textarea-el', `
 cursor: not-allowed;
 color: var(--n-text-color-disabled);
 text-decoration-color: var(--n-text-color-disabled);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('placeholder', 'color: var(--n-placeholder-color-disabled);'), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('separator', 'color: var(--n-text-color-disabled);', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('icon', `
 color: var(--n-icon-color-disabled);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-icon', `
 color: var(--n-icon-color-disabled);
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('input-word-count', `
 color: var(--n-count-text-color-disabled);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('suffix, prefix', 'color: var(--n-text-color-disabled);', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('icon', `
 color: var(--n-icon-color-disabled);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('internal-icon', `
 color: var(--n-icon-color-disabled);
 `)])]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cNotM)('disabled', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('eye', `
 color: var(--n-icon-color);
 cursor: pointer;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:hover', `
 color: var(--n-icon-color-hover);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:active', `
 color: var(--n-icon-color-pressed);
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:hover', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('state-border', 'border: var(--n-border-hover);')]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('focus', 'background-color: var(--n-color-focus);', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('state-border', `
 border: var(--n-border-focus);
 box-shadow: var(--n-box-shadow-focus);
 `)])]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('border, state-border', `
 box-sizing: border-box;
 position: absolute;
 left: 0;
 right: 0;
 top: 0;
 bottom: 0;
 pointer-events: none;
 border-radius: inherit;
 border: var(--n-border);
 transition:
 box-shadow .3s var(--n-bezier),
 border-color .3s var(--n-bezier);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('state-border', `
 border-color: #0000;
 z-index: 1;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('prefix', 'margin-right: 4px;'), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('suffix', `
 margin-left: 4px;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('suffix, prefix', `
 transition: color .3s var(--n-bezier);
 flex-wrap: nowrap;
 flex-shrink: 0;
 line-height: var(--n-height);
 white-space: nowrap;
 display: inline-flex;
 align-items: center;
 justify-content: center;
 color: var(--n-suffix-text-color);
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-loading', `
 font-size: var(--n-icon-size);
 margin: 0 2px;
 color: var(--n-loading-color);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-clear', `
 font-size: var(--n-icon-size);
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('placeholder', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-icon', `
 transition: color .3s var(--n-bezier);
 color: var(--n-icon-color);
 font-size: var(--n-icon-size);
 `)])]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('>', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('icon', `
 transition: color .3s var(--n-bezier);
 color: var(--n-icon-color);
 font-size: var(--n-icon-size);
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-icon', `
 font-size: var(--n-icon-size);
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('input-word-count', `
 pointer-events: none;
 line-height: 1.5;
 font-size: .85em;
 color: var(--n-count-text-color);
 transition: color .3s var(--n-bezier);
 margin-left: 4px;
 font-variant: tabular-nums;
 `), ['warning', 'error'].map(status => (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)(`${status}-status`, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cNotM)('disabled', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-loading', `
 color: var(--n-loading-color-${status})
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('input-el, textarea-el', `
 caret-color: var(--n-caret-color-${status});
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('state-border', `
 border: var(--n-border-${status});
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:hover', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('state-border', `
 border: var(--n-border-hover-${status});
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:focus', `
 background-color: var(--n-color-focus-${status});
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('state-border', `
 box-shadow: var(--n-box-shadow-focus-${status});
 border: var(--n-border-focus-${status});
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('focus', `
 background-color: var(--n-color-focus-${status});
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('state-border', `
 box-shadow: var(--n-box-shadow-focus-${status});
 border: var(--n-border-focus-${status});
 `)])])]))]));
const safariStyle = (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('input', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('disabled', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('input-el, textarea-el', `
 -webkit-text-fill-color: var(--n-text-color-disabled);
 `)])]);

/***/ }),

/***/ "./node_modules/naive-ui/es/input/src/utils.mjs":
/*!******************************************************!*\
  !*** ./node_modules/naive-ui/es/input/src/utils.mjs ***!
  \******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isEmptyInputValue: () => (/* binding */ isEmptyInputValue),
/* harmony export */   len: () => (/* binding */ len),
/* harmony export */   useCursor: () => (/* binding */ useCursor)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");

function len(s) {
  let count = 0;
  for (const _ of s) {
    count++;
  }
  return count;
}
function isEmptyInputValue(value) {
  return value === '' || value == null;
}
function useCursor(inputElRef) {
  const selectionRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
  function recordCursor() {
    const {
      value: input
    } = inputElRef;
    if (!(input === null || input === void 0 ? void 0 : input.focus)) {
      reset();
      return;
    }
    const {
      selectionStart,
      selectionEnd,
      value
    } = input;
    if (selectionStart == null || selectionEnd == null) {
      reset();
      return;
    }
    selectionRef.value = {
      start: selectionStart,
      end: selectionEnd,
      beforeText: value.slice(0, selectionStart),
      afterText: value.slice(selectionEnd)
    };
  }
  function restoreCursor() {
    var _a;
    const {
      value: selection
    } = selectionRef;
    const {
      value: inputEl
    } = inputElRef;
    if (!selection || !inputEl) {
      return;
    }
    const {
      value
    } = inputEl;
    const {
      start,
      beforeText,
      afterText
    } = selection;
    let startPos = value.length;
    if (value.endsWith(afterText)) {
      startPos = value.length - afterText.length;
    } else if (value.startsWith(beforeText)) {
      startPos = beforeText.length;
    } else {
      const beforeLastChar = beforeText[start - 1];
      const newIndex = value.indexOf(beforeLastChar, start - 1);
      if (newIndex !== -1) {
        startPos = newIndex + 1;
      }
    }
    (_a = inputEl.setSelectionRange) === null || _a === void 0 ? void 0 : _a.call(inputEl, startPos, startPos);
  }
  function reset() {
    selectionRef.value = null;
  }
  (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(inputElRef, reset);
  return {
    recordCursor,
    restoreCursor
  };
}

/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidmVuZG9ycy1ub2RlX21vZHVsZXNfbmFpdmUtdWlfZXNfaW5wdXRfc3JjX0lucHV0X21qcy5taW4uanMiLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7QUFBeUM7QUFDekMsaUVBQWUsb0RBQWU7QUFDOUI7QUFDQTtBQUNBLFdBQVcsc0NBQUM7QUFDWjtBQUNBO0FBQ0EsS0FBSyxFQUFFLHNDQUFDO0FBQ1I7QUFDQTtBQUNBLEtBQUssR0FBRyxzQ0FBQztBQUNUO0FBQ0E7QUFDQSxLQUFLLEdBQUcsc0NBQUM7QUFDVDtBQUNBO0FBQ0EsS0FBSyxHQUFHLHNDQUFDO0FBQ1Q7QUFDQTtBQUNBLEtBQUssR0FBRyxzQ0FBQztBQUNUO0FBQ0E7QUFDQSxLQUFLO0FBQ0w7QUFDQSxDQUFDLENBQUM7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDeEI2STtBQUMvRjtBQUNaO0FBQ0k7QUFDVDtBQUN5QjtBQUNjO0FBQ25CO0FBQ3dDO0FBQ29CO0FBQ1g7QUFDbkQ7QUFDRztBQUNPO0FBQ25CO0FBQ3FCO0FBQ3RELGlEQUFpRCxFQUFFLHlEQUFRO0FBQ2xFO0FBQ0E7QUFDQTtBQUNBLEdBQUc7QUFDSDtBQUNBO0FBQ0E7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBO0FBQ0E7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBO0FBQ0E7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBO0FBQ0E7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEdBQUc7QUFDSDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsR0FBRztBQUNIO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBO0FBQ0E7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEdBQUc7QUFDSDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsR0FBRztBQUNIO0FBQ0E7QUFDQSxDQUFDO0FBQ0QsaUVBQWUsb0RBQWU7QUFDOUI7QUFDQTtBQUNBO0FBQ0EsUUFBUSxJQUFxQztBQUM3QyxNQUFNLGdEQUFXO0FBQ2pCO0FBQ0EsVUFBVSwwREFBUTtBQUNsQjtBQUNBLE9BQU87QUFDUDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxNQUFNLEVBQUUsNkRBQVM7QUFDakIscUJBQXFCLDZEQUFRLG9CQUFvQiw4REFBSyxFQUFFLHlEQUFVO0FBQ2xFLFFBQVEsNERBQVE7QUFDaEIsTUFBTSw2REFBUSxrQkFBa0IsK0RBQVc7QUFDM0M7QUFDQTtBQUNBLHlCQUF5Qix3Q0FBRztBQUM1QiwwQkFBMEIsd0NBQUc7QUFDN0IsZ0NBQWdDLHdDQUFHO0FBQ25DLDZCQUE2Qix3Q0FBRztBQUNoQyx1QkFBdUIsd0NBQUc7QUFDMUIsd0JBQXdCLHdDQUFHO0FBQzNCLG1DQUFtQyx3Q0FBRztBQUN0QyxzQ0FBc0MscURBQVM7QUFDL0MscUNBQXFDLHdDQUFHO0FBQ3hDO0FBQ0E7QUFDQTtBQUNBLE1BQU0sRUFBRSw2REFBUztBQUNqQjtBQUNBLGlDQUFpQyx3Q0FBRztBQUNwQywrQkFBK0IsMENBQUs7QUFDcEMsMkJBQTJCLGtEQUFjO0FBQ3pDO0FBQ0EscUJBQXFCLDhEQUFXO0FBQ2hDO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsTUFBTTtBQUNOO0FBQ0EsdUJBQXVCLHdDQUFHO0FBQzFCLHFCQUFxQix3Q0FBRztBQUN4QiwyQkFBMkIsd0NBQUc7QUFDOUIseUJBQXlCLHdDQUFHO0FBQzVCO0FBQ0E7QUFDQSxpQ0FBaUMsNkNBQVE7QUFDekM7QUFDQTtBQUNBO0FBQ0EsUUFBUTtBQUNSO0FBQ0E7QUFDQTtBQUNBLFVBQVU7QUFDVjtBQUNBO0FBQ0E7QUFDQSxRQUFRO0FBQ1I7QUFDQSxRQUFRO0FBQ1I7QUFDQTtBQUNBLEtBQUs7QUFDTCxnQ0FBZ0MsNkNBQVE7QUFDeEM7QUFDQTtBQUNBLFFBQVE7QUFDUjtBQUNBO0FBQ0EsUUFBUTtBQUNSO0FBQ0E7QUFDQSxRQUFRO0FBQ1IsOEJBQThCLDZEQUFpQiwrQ0FBK0MsNkRBQWlCO0FBQy9HLEtBQUs7QUFDTCxnQ0FBZ0MsNkNBQVE7QUFDeEM7QUFDQTtBQUNBLFFBQVE7QUFDUjtBQUNBO0FBQ0EsUUFBUTtBQUNSO0FBQ0E7QUFDQSxRQUFRO0FBQ1Isc0RBQXNELDZEQUFpQiwrQ0FBK0MsNkRBQWlCO0FBQ3ZJLEtBQUs7QUFDTDtBQUNBLDJCQUEyQixrREFBTztBQUNsQztBQUNBLEtBQUs7QUFDTDtBQUNBLDRCQUE0QixrREFBTztBQUNuQztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsUUFBUTtBQUNSO0FBQ0E7QUFDQSxRQUFRO0FBQ1I7QUFDQTtBQUNBLFFBQVE7QUFDUjtBQUNBO0FBQ0EsS0FBSztBQUNMO0FBQ0Esb0NBQW9DLDZDQUFRO0FBQzVDO0FBQ0E7QUFDQSxRQUFRO0FBQ1I7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEtBQUs7QUFDTCwrQkFBK0Isd0NBQUc7QUFDbEM7QUFDQSxtQ0FBbUMsNkNBQVE7QUFDM0M7QUFDQTtBQUNBLFFBQVE7QUFDUjtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQSxPQUFPO0FBQ1AsS0FBSztBQUNMLDRDQUE0Qyx3Q0FBRztBQUMvQztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxVQUFVO0FBQ1Y7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsVUFBVTtBQUNWO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxVQUFVO0FBQ1Y7QUFDQTtBQUNBO0FBQ0Esb0NBQW9DLGtEQUFrRDtBQUN0RjtBQUNBO0FBQ0E7QUFDQSxvQ0FBb0MsMkRBQTJEO0FBQy9GO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSx5QkFBeUIsNkNBQVE7QUFDakM7QUFDQTtBQUNBLFFBQVE7QUFDUjtBQUNBLEtBQUs7QUFDTCxJQUFJLDhDQUFTO0FBQ2I7QUFDQTtBQUNBO0FBQ0EsUUFBUTtBQUNSO0FBQ0E7QUFDQTtBQUNBLEtBQUs7QUFDTDtBQUNBLGVBQWUsdURBQWtCO0FBQ2pDO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxRQUFRO0FBQ1I7QUFDQTtBQUNBLFFBQVE7QUFDUix5QkFBeUIsdURBQUk7QUFDN0IsMEJBQTBCLHVEQUFJO0FBQzlCLG1CQUFtQix1REFBSTtBQUN2QjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxRQUFRO0FBQ1I7QUFDQTtBQUNBLFFBQVE7QUFDUixvQkFBb0IsdURBQUk7QUFDeEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsUUFBUTtBQUNSO0FBQ0E7QUFDQSxRQUFRO0FBQ1Isa0JBQWtCLHVEQUFJO0FBQ3RCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxRQUFRO0FBQ1I7QUFDQTtBQUNBLFFBQVE7QUFDUixtQkFBbUIsdURBQUk7QUFDdkI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFFBQVE7QUFDUixtQkFBbUIsdURBQUk7QUFDdkI7QUFDQTtBQUNBO0FBQ0E7QUFDQSxRQUFRO0FBQ1IsdUJBQXVCLHVEQUFJO0FBQzNCO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsUUFBUTtBQUNSLHdCQUF3Qix1REFBSTtBQUM1QjtBQUNBO0FBQ0E7QUFDQTtBQUNBLFFBQVE7QUFDUix3QkFBd0IsdURBQUk7QUFDNUI7QUFDQTtBQUNBO0FBQ0E7QUFDQSxRQUFRO0FBQ1Isc0JBQXNCLHVEQUFJO0FBQzFCO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsUUFBUTtBQUNSLG1CQUFtQix1REFBSTtBQUN2QjtBQUNBO0FBQ0E7QUFDQTtBQUNBLFFBQVE7QUFDUiwwQkFBMEIsdURBQUk7QUFDOUI7QUFDQTtBQUNBO0FBQ0E7QUFDQSxRQUFRO0FBQ1IseUJBQXlCLHVEQUFJO0FBQzdCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFFBQVE7QUFDUjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxVQUFVO0FBQ1Y7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxhQUFhO0FBQ2IsWUFBWTtBQUNaO0FBQ0E7QUFDQSxhQUFhO0FBQ2I7QUFDQSxVQUFVO0FBQ1Y7QUFDQTtBQUNBLFlBQVk7QUFDWjtBQUNBO0FBQ0EsWUFBWTtBQUNaO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGFBQWE7QUFDYixZQUFZO0FBQ1o7QUFDQTtBQUNBLGFBQWE7QUFDYjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGFBQWEsNkNBQVE7QUFDckI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxRQUFRO0FBQ1I7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFFBQVE7QUFDUjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxRQUFRO0FBQ1I7QUFDQSxRQUFRO0FBQ1I7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsUUFBUTtBQUNSO0FBQ0E7QUFDQTtBQUNBLFVBQVU7QUFDVjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0EsU0FBUztBQUNULFFBQVE7QUFDUjtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFFBQVE7QUFDUjtBQUNBO0FBQ0E7QUFDQSxRQUFRO0FBQ1I7QUFDQTtBQUNBO0FBQ0E7QUFDQSxZQUFZO0FBQ1o7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsY0FBYztBQUNkO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFFBQVEsMENBQUc7QUFDWDtBQUNBLE1BQU0seUNBQUU7QUFDUjtBQUNBO0FBQ0E7QUFDQTtBQUNBLFFBQVEsMENBQUc7QUFDWDtBQUNBLE1BQU0seUNBQUU7QUFDUjtBQUNBO0FBQ0EseUJBQXlCLHVEQUFJO0FBQzdCO0FBQ0E7QUFDQSwyQkFBMkIsdURBQUk7QUFDL0I7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFVBQVU7QUFDVjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxVQUFVO0FBQ1Y7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxhQUFhLDZDQUFRO0FBQ3JCO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxRQUFRO0FBQ1I7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsMkRBQTJEO0FBQzNEO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsUUFBUTtBQUNSO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxVQUFVO0FBQ1Y7QUFDQSxRQUFRO0FBQ1I7QUFDQTtBQUNBLFVBQVU7QUFDVjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsUUFBUTtBQUNSO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsWUFBWTtBQUNaO0FBQ0EsOENBQThDLGdEQUFnRDtBQUM5RjtBQUNBLFVBQVU7QUFDVjtBQUNBO0FBQ0EsWUFBWTtBQUNaO0FBQ0E7QUFDQTtBQUNBLGNBQWM7QUFDZCwrQ0FBK0M7QUFDL0M7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGdDQUFnQyx3Q0FBRztBQUNuQztBQUNBLEtBQUs7QUFDTDtBQUNBO0FBQ0E7QUFDQTtBQUNBLFFBQVE7QUFDUix5Q0FBeUMsV0FBVztBQUNwRDtBQUNBO0FBQ0E7QUFDQSxJQUFJLGdEQUFXO0FBQ2Y7QUFDQTtBQUNBO0FBQ0EsUUFBUTtBQUNSO0FBQ0EsZ0NBQWdDLDBDQUFLO0FBQ3JDO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVCxRQUFRO0FBQ1I7QUFDQTtBQUNBLEtBQUs7QUFDTDtBQUNBLElBQUksZ0RBQVc7QUFDZjtBQUNBLGdDQUFnQywwQ0FBSztBQUNyQztBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVCxRQUFRO0FBQ1I7QUFDQTtBQUNBLEtBQUs7QUFDTCxJQUFJLDRDQUFPLENBQUMsOERBQWlCO0FBQzdCO0FBQ0E7QUFDQTtBQUNBLHlCQUF5QiwwQ0FBSztBQUM5QixLQUFLO0FBQ0w7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSwwQkFBMEIsNERBQU07QUFDaEMsdUJBQXVCLDZDQUFRO0FBQy9CO0FBQ0E7QUFDQSxRQUFRO0FBQ1I7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxXQUFXLDREQUFTO0FBQ3BCLFdBQVcsNERBQVM7QUFDcEIsV0FBVyw0REFBUztBQUNwQjtBQUNBLFFBQVE7QUFDUjtBQUNBO0FBQ0E7QUFDQSxRQUFRLEVBQUUsbURBQVU7QUFDcEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEtBQUs7QUFDTCxtREFBbUQsaUVBQWEsVUFBVSw2Q0FBUTtBQUNsRjtBQUNBO0FBQ0EsUUFBUTtBQUNSO0FBQ0EsS0FBSztBQUNMLHlDQUF5QztBQUN6QztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxPQUFPO0FBQ1A7QUFDQTtBQUNBO0FBQ0E7QUFDQSxLQUFLO0FBQ0wsR0FBRztBQUNIO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLE1BQU07QUFDTjtBQUNBO0FBQ0EsV0FBVyxzQ0FBQztBQUNaO0FBQ0EsaUJBQWlCLGdCQUFnQix3Q0FBd0MsZ0JBQWdCLFVBQVUsYUFBYTtBQUNoSCxZQUFZLGdCQUFnQjtBQUM1QixZQUFZLGdCQUFnQjtBQUM1QixZQUFZLGdCQUFnQjtBQUM1QixZQUFZLGdCQUFnQjtBQUM1QixZQUFZLGdCQUFnQjtBQUM1QixZQUFZLGdCQUFnQjtBQUM1QixZQUFZLGdCQUFnQjtBQUM1QixZQUFZLGdCQUFnQjtBQUM1QixZQUFZLGdCQUFnQjtBQUM1QixPQUFPO0FBQ1A7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsS0FBSyxFQUFFLHNDQUFDO0FBQ1IsZ0JBQWdCLGdCQUFnQjtBQUNoQyxLQUFLLEVBQUUscUVBQWtCLHdDQUF3QyxzQ0FBQztBQUNsRSxnQkFBZ0IsZ0JBQWdCO0FBQ2hDLEtBQUssb0NBQW9DLHNDQUFDLENBQUMsNERBQVU7QUFDckQ7QUFDQSxnQkFBZ0IsZ0JBQWdCO0FBQ2hDO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsS0FBSztBQUNMO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsVUFBVTtBQUNWO0FBQ0EscUVBQXFFLDZCQUE2QjtBQUNsRztBQUNBLGVBQWUsc0NBQUMsQ0FBQyx5Q0FBUSxRQUFRLHNDQUFDLDZCQUE2QjtBQUMvRDtBQUNBLHFCQUFxQixnQkFBZ0I7QUFDckM7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxXQUFXO0FBQ1g7QUFDQTtBQUNBO0FBQ0EsU0FBUyw0QkFBNEIsc0NBQUM7QUFDdEMsb0JBQW9CLGdCQUFnQjtBQUNwQztBQUNBO0FBQ0EsU0FBUyxxREFBcUQsc0NBQUMsQ0FBQyw4Q0FBZTtBQUMvRTtBQUNBLFNBQVM7QUFDVCx5QkFBeUIsc0NBQUM7QUFDMUI7QUFDQSxzQkFBc0IsZ0JBQWdCO0FBQ3RDO0FBQ0EsV0FBVztBQUNYLFNBQVM7QUFDVDtBQUNBLEtBQUssSUFBSSxzQ0FBQztBQUNWLGdCQUFnQixnQkFBZ0I7QUFDaEMsS0FBSyxFQUFFLHNDQUFDO0FBQ1I7QUFDQSxLQUFLO0FBQ0w7QUFDQSxpQkFBaUIsZ0JBQWdCO0FBQ2pDO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsT0FBTztBQUNQO0FBQ0E7QUFDQSxPQUFPO0FBQ1A7QUFDQTtBQUNBO0FBQ0EsS0FBSyw0QkFBNEIsc0NBQUM7QUFDbEMsZ0JBQWdCLGdCQUFnQjtBQUNoQyxLQUFLLEVBQUUsc0NBQUMsbUVBQW1FLHNDQUFDO0FBQzVFLGdCQUFnQixnQkFBZ0I7QUFDaEM7QUFDQTtBQUNBLEtBQUssbUNBQW1DLHFFQUFrQjtBQUMxRCx1SEFBdUgsc0NBQUM7QUFDeEgsa0JBQWtCLGdCQUFnQjtBQUNsQyxPQUFPLEdBQUcscUVBQWtCO0FBQzVCLCtDQUErQyxzQ0FBQyxDQUFDLDREQUFVO0FBQzNEO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNULE9BQU8scUZBQXFGLHNDQUFDLENBQUMsNERBQVc7QUFDekc7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLE9BQU8sMkdBQTJHLHNDQUFDLENBQUMsdURBQVM7QUFDN0g7QUFDQTtBQUNBO0FBQ0E7QUFDQSxPQUFPLGtFQUFrRSxzQ0FBQztBQUMxRSxrQkFBa0IsZ0JBQWdCO0FBQ2xDO0FBQ0E7QUFDQSxPQUFPLHlCQUF5Qiw4REFBVyx5Q0FBeUMsc0NBQUMsQ0FBQyw0REFBUztBQUMvRjtBQUNBLE9BQU87QUFDUCx1QkFBdUIsc0NBQUMsQ0FBQyxrRUFBTztBQUNoQyxPQUFPLE1BQU0sOERBQVcsMkNBQTJDLHNDQUFDLENBQUMsNERBQVM7QUFDOUU7QUFDQSxPQUFPO0FBQ1AsdUJBQXVCLHNDQUFDLENBQUMsa0VBQVU7QUFDbkMsT0FBTztBQUNQLEtBQUssZ0JBQWdCLHNDQUFDO0FBQ3RCLGdCQUFnQixnQkFBZ0I7QUFDaEMsS0FBSyxFQUFFLDhEQUFXLGdFQUFnRSxzQ0FBQztBQUNuRixnQkFBZ0IsZ0JBQWdCO0FBQ2hDLEtBQUssRUFBRSxzQ0FBQztBQUNSLGdCQUFnQixnQkFBZ0I7QUFDaEMsS0FBSyxFQUFFLHNDQUFDO0FBQ1I7QUFDQTtBQUNBLGdCQUFnQixnQkFBZ0I7QUFDaEM7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLE9BQU87QUFDUDtBQUNBO0FBQ0EsT0FBTztBQUNQO0FBQ0E7QUFDQTtBQUNBLEtBQUssMkJBQTJCLHNDQUFDO0FBQ2pDLGdCQUFnQixnQkFBZ0I7QUFDaEMsS0FBSyxFQUFFLHNDQUFDLG9EQUFvRCxxRUFBa0I7QUFDOUUsNkNBQTZDLHNDQUFDO0FBQzlDLGtCQUFrQixnQkFBZ0I7QUFDbEMsT0FBTyxxQkFBcUIsc0NBQUMsQ0FBQyw0REFBVTtBQUN4QztBQUNBO0FBQ0E7QUFDQSxPQUFPO0FBQ1A7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsT0FBTztBQUNQLEtBQUssaUNBQWlDLHNDQUFDO0FBQ3ZDLGdCQUFnQixnQkFBZ0I7QUFDaEMsS0FBSyxnQ0FBZ0Msc0NBQUM7QUFDdEMsZ0JBQWdCLGdCQUFnQjtBQUNoQyxLQUFLLGtEQUFrRCxzQ0FBQyxDQUFDLHVEQUFTO0FBQ2xFO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsVUFBVTtBQUNWO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxLQUFLO0FBQ0w7QUFDQSxDQUFDLENBQUM7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ2x0Q3lEO0FBQ0c7QUFDVjtBQUNsQjtBQUNsQyxpRUFBZSxvREFBZTtBQUM5QjtBQUNBO0FBQ0E7QUFDQSxHQUFHO0FBQ0g7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLE1BQU0sRUFBRSwyQ0FBTSxDQUFDLDZEQUFpQjtBQUNoQyx5QkFBeUIsNkNBQVE7QUFDakM7QUFDQTtBQUNBLFFBQVE7QUFDUjtBQUNBLHlDQUF5QywyQ0FBRztBQUM1QyxLQUFLO0FBQ0w7QUFDQTtBQUNBO0FBQ0EsUUFBUTtBQUNSO0FBQ0E7QUFDQSxRQUFRO0FBQ1IsYUFBYSxzQ0FBQztBQUNkLGtCQUFrQix5QkFBeUI7QUFDM0MsT0FBTyxFQUFFLHNFQUFvQjtBQUM3QjtBQUNBLE9BQU8sMkRBQTJELG9CQUFvQixJQUFJLFVBQVU7QUFDcEc7QUFDQTtBQUNBLENBQUMsQ0FBQzs7Ozs7Ozs7Ozs7Ozs7O0FDcEMwRDtBQUNyRCwwQkFBMEIsb0VBQWtCOzs7Ozs7Ozs7Ozs7Ozs7O0FDRG1CO0FBQ3RFO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxpRUFBZSx5REFBRTtBQUNqQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSx5REFBRTtBQUNGO0FBQ0E7QUFDQTtBQUNBLEtBQUsseURBQUU7QUFDUDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEtBQUsseURBQUU7QUFDUDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsS0FBSyx3REFBQztBQUNOO0FBQ0E7QUFDQTtBQUNBLEtBQUssd0RBQUM7QUFDTjtBQUNBO0FBQ0EsS0FBSyx3REFBQywwQkFBMEIseURBQUUsK0JBQStCLFFBQVEseURBQUUsV0FBVyw0REFBSyx1REFBdUQsTUFBTSx5REFBRTtBQUMxSjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsS0FBSyx3REFBQztBQUNOO0FBQ0E7QUFDQSxPQUFPLHlEQUFFLGNBQWMseURBQUUsbUNBQW1DLE1BQU0sNERBQUssMEJBQTBCLElBQUkseURBQUUsY0FBYyx5REFBRTtBQUN2SDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSx5REFBRTtBQUNGO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEtBQUsseURBQUU7QUFDUDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsS0FBSyx5REFBRTtBQUNQO0FBQ0E7QUFDQTtBQUNBLEtBQUssd0RBQUMsZ0RBQWdELElBQUksd0RBQUMsT0FBTyx5REFBRTtBQUNwRTtBQUNBO0FBQ0EsU0FBUyw0REFBSyxjQUFjLHlEQUFFLHFDQUFxQyxNQUFNLHlEQUFFO0FBQzNFO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHlEQUFFLDBCQUEwQixJQUFJLHlEQUFFO0FBQ2xDO0FBQ0E7QUFDQTtBQUNBLEtBQUsseURBQUUsZUFBZSx5REFBRTtBQUN4QjtBQUNBO0FBQ0EsT0FBTyx5REFBRTtBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxLQUFLLHlEQUFFO0FBQ1A7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EseURBQUUsVUFBVSx5REFBRSw4Q0FBOEMsSUFBSSx5REFBRTtBQUNsRTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsS0FBSyx5REFBRTtBQUNQO0FBQ0EsS0FBSyx5REFBRTtBQUNQO0FBQ0EsU0FBUyx5REFBRTtBQUNYO0FBQ0E7QUFDQSxLQUFLLHlEQUFFLDZDQUE2QyxJQUFJLHlEQUFFO0FBQzFEO0FBQ0E7QUFDQTtBQUNBLEtBQUsseURBQUUsNERBQTRELElBQUkseURBQUUsbURBQW1ELElBQUkseURBQUU7QUFDbEk7QUFDQSxLQUFLLHlEQUFFO0FBQ1A7QUFDQSxPQUFPLHlEQUFFO0FBQ1Q7QUFDQSxLQUFLLHlEQUFFLHdEQUF3RCxJQUFJLHlEQUFFO0FBQ3JFO0FBQ0EsS0FBSyx5REFBRTtBQUNQO0FBQ0EsU0FBUyw0REFBSyxjQUFjLHlEQUFFO0FBQzlCO0FBQ0E7QUFDQSxLQUFLLHdEQUFDO0FBQ047QUFDQSxLQUFLLHdEQUFDO0FBQ047QUFDQSxPQUFPLHdEQUFDLGFBQWEseURBQUUsZ0RBQWdELE1BQU0seURBQUUsa0RBQWtELElBQUkseURBQUU7QUFDdkk7QUFDQTtBQUNBLFNBQVMseURBQUU7QUFDWDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxLQUFLLHlEQUFFO0FBQ1A7QUFDQTtBQUNBLEtBQUsseURBQUUsOEJBQThCLElBQUkseURBQUU7QUFDM0M7QUFDQSxLQUFLLHlEQUFFO0FBQ1A7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsS0FBSyx5REFBRTtBQUNQO0FBQ0E7QUFDQTtBQUNBLEtBQUsseURBQUU7QUFDUDtBQUNBLEtBQUsseURBQUUsaUJBQWlCLHlEQUFFO0FBQzFCO0FBQ0E7QUFDQTtBQUNBLFNBQVMsd0RBQUMsT0FBTyx5REFBRTtBQUNuQjtBQUNBO0FBQ0E7QUFDQSxPQUFPLHlEQUFFO0FBQ1Q7QUFDQSxPQUFPLHlEQUFFO0FBQ1Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSx3Q0FBd0MseURBQUUsSUFBSSxPQUFPLFdBQVcsNERBQUssY0FBYyx5REFBRTtBQUNyRixnQ0FBZ0MsT0FBTztBQUN2QyxLQUFLLHlEQUFFO0FBQ1Asb0NBQW9DLE9BQU87QUFDM0MsS0FBSyx5REFBRTtBQUNQLDBCQUEwQixPQUFPO0FBQ2pDLEtBQUssd0RBQUMsYUFBYSx5REFBRTtBQUNyQixnQ0FBZ0MsT0FBTztBQUN2QyxPQUFPLHdEQUFDO0FBQ1IseUNBQXlDLE9BQU87QUFDaEQsS0FBSyx5REFBRTtBQUNQLHdDQUF3QyxPQUFPO0FBQy9DLGdDQUFnQyxPQUFPO0FBQ3ZDLE9BQU8seURBQUU7QUFDVCx5Q0FBeUMsT0FBTztBQUNoRCxLQUFLLHlEQUFFO0FBQ1Asd0NBQXdDLE9BQU87QUFDL0MsZ0NBQWdDLE9BQU87QUFDdkMsWUFBWSxFQUFDO0FBQ04sb0JBQW9CLHlEQUFFLFdBQVcseURBQUUsY0FBYyx5REFBRTtBQUMxRDtBQUNBOzs7Ozs7Ozs7Ozs7Ozs7OztBQ3JSaUM7QUFDMUI7QUFDUDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTztBQUNQO0FBQ0E7QUFDTztBQUNQLHVCQUF1Qix3Q0FBRztBQUMxQjtBQUNBO0FBQ0E7QUFDQSxNQUFNO0FBQ047QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLE1BQU07QUFDTjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxNQUFNO0FBQ047QUFDQTtBQUNBLE1BQU07QUFDTjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsTUFBTTtBQUNOO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsTUFBTTtBQUNOO0FBQ0E7QUFDQTtBQUNBLE1BQU07QUFDTjtBQUNBLE1BQU07QUFDTjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsRUFBRSwwQ0FBSztBQUNQO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9uZWFyYmVhY2gvLi9ub2RlX21vZHVsZXMvbmFpdmUtdWkvZXMvX2ludGVybmFsL2ljb25zL0V5ZU9mZi5tanMiLCJ3ZWJwYWNrOi8vbmVhcmJlYWNoLy4vbm9kZV9tb2R1bGVzL25haXZlLXVpL2VzL2lucHV0L3NyYy9JbnB1dC5tanMiLCJ3ZWJwYWNrOi8vbmVhcmJlYWNoLy4vbm9kZV9tb2R1bGVzL25haXZlLXVpL2VzL2lucHV0L3NyYy9Xb3JkQ291bnQubWpzIiwid2VicGFjazovL25lYXJiZWFjaC8uL25vZGVfbW9kdWxlcy9uYWl2ZS11aS9lcy9pbnB1dC9zcmMvaW50ZXJmYWNlLm1qcyIsIndlYnBhY2s6Ly9uZWFyYmVhY2gvLi9ub2RlX21vZHVsZXMvbmFpdmUtdWkvZXMvaW5wdXQvc3JjL3N0eWxlcy9pbnB1dC5jc3NyLm1qcyIsIndlYnBhY2s6Ly9uZWFyYmVhY2gvLi9ub2RlX21vZHVsZXMvbmFpdmUtdWkvZXMvaW5wdXQvc3JjL3V0aWxzLm1qcyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBkZWZpbmVDb21wb25lbnQsIGggfSBmcm9tICd2dWUnO1xuZXhwb3J0IGRlZmF1bHQgZGVmaW5lQ29tcG9uZW50KHtcbiAgbmFtZTogJ0V5ZU9mZicsXG4gIHJlbmRlcigpIHtcbiAgICByZXR1cm4gaChcInN2Z1wiLCB7XG4gICAgICB4bWxuczogXCJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2Z1wiLFxuICAgICAgdmlld0JveDogXCIwIDAgNTEyIDUxMlwiXG4gICAgfSwgaChcInBhdGhcIiwge1xuICAgICAgZDogXCJNNDMyIDQ0OGExNS45MiAxNS45MiAwIDAgMS0xMS4zMS00LjY5bC0zNTItMzUyYTE2IDE2IDAgMCAxIDIyLjYyLTIyLjYybDM1MiAzNTJBMTYgMTYgMCAwIDEgNDMyIDQ0OHpcIixcbiAgICAgIGZpbGw6IFwiY3VycmVudENvbG9yXCJcbiAgICB9KSwgaChcInBhdGhcIiwge1xuICAgICAgZDogXCJNMjU1LjY2IDM4NGMtNDEuNDkgMC04MS41LTEyLjI4LTExOC45Mi0zNi41Yy0zNC4wNy0yMi02NC43NC01My41MS04OC43LTkxdi0uMDhjMTkuOTQtMjguNTcgNDEuNzgtNTIuNzMgNjUuMjQtNzIuMjFhMiAyIDAgMCAwIC4xNC0yLjk0TDkzLjUgMTYxLjM4YTIgMiAwIDAgMC0yLjcxLS4xMmMtMjQuOTIgMjEtNDguMDUgNDYuNzYtNjkuMDggNzYuOTJhMzEuOTIgMzEuOTIgMCAwIDAtLjY0IDM1LjU0YzI2LjQxIDQxLjMzIDYwLjQgNzYuMTQgOTguMjggMTAwLjY1QzE2MiA0MDIgMjA3LjkgNDE2IDI1NS42NiA0MTZhMjM5LjEzIDIzOS4xMyAwIDAgMCA3NS44LTEyLjU4YTIgMiAwIDAgMCAuNzctMy4zMWwtMjEuNTgtMjEuNThhNCA0IDAgMCAwLTMuODMtMWEyMDQuOCAyMDQuOCAwIDAgMS01MS4xNiA2LjQ3elwiLFxuICAgICAgZmlsbDogXCJjdXJyZW50Q29sb3JcIlxuICAgIH0pLCBoKFwicGF0aFwiLCB7XG4gICAgICBkOiBcIk00OTAuODQgMjM4LjZjLTI2LjQ2LTQwLjkyLTYwLjc5LTc1LjY4LTk5LjI3LTEwMC41M0MzNDkgMTEwLjU1IDMwMiA5NiAyNTUuNjYgOTZhMjI3LjM0IDIyNy4zNCAwIDAgMC03NC44OSAxMi44M2EyIDIgMCAwIDAtLjc1IDMuMzFsMjEuNTUgMjEuNTVhNCA0IDAgMCAwIDMuODggMWExOTIuODIgMTkyLjgyIDAgMCAxIDUwLjIxLTYuNjljNDAuNjkgMCA4MC41OCAxMi40MyAxMTguNTUgMzdjMzQuNzEgMjIuNCA2NS43NCA1My44OCA4OS43NiA5MWEuMTMuMTMgMCAwIDEgMCAuMTZhMzEwLjcyIDMxMC43MiAwIDAgMS02NC4xMiA3Mi43M2EyIDIgMCAwIDAtLjE1IDIuOTVsMTkuOSAxOS44OWEyIDIgMCAwIDAgMi43LjEzYTM0My40OSAzNDMuNDkgMCAwIDAgNjguNjQtNzguNDhhMzIuMiAzMi4yIDAgMCAwLS4xLTM0Ljc4elwiLFxuICAgICAgZmlsbDogXCJjdXJyZW50Q29sb3JcIlxuICAgIH0pLCBoKFwicGF0aFwiLCB7XG4gICAgICBkOiBcIk0yNTYgMTYwYTk1Ljg4IDk1Ljg4IDAgMCAwLTIxLjM3IDIuNGEyIDIgMCAwIDAtMSAzLjM4bDExMi41OSAxMTIuNTZhMiAyIDAgMCAwIDMuMzgtMUE5NiA5NiAwIDAgMCAyNTYgMTYwelwiLFxuICAgICAgZmlsbDogXCJjdXJyZW50Q29sb3JcIlxuICAgIH0pLCBoKFwicGF0aFwiLCB7XG4gICAgICBkOiBcIk0xNjUuNzggMjMzLjY2YTIgMiAwIDAgMC0zLjM4IDFhOTYgOTYgMCAwIDAgMTE1IDExNWEyIDIgMCAwIDAgMS0zLjM4elwiLFxuICAgICAgZmlsbDogXCJjdXJyZW50Q29sb3JcIlxuICAgIH0pKTtcbiAgfVxufSk7IiwiaW1wb3J0IHsgRnJhZ21lbnQsIGNvbXB1dGVkLCBkZWZpbmVDb21wb25lbnQsIGdldEN1cnJlbnRJbnN0YW5jZSwgaCwgbmV4dFRpY2ssIG9uTW91bnRlZCwgcHJvdmlkZSwgcmVmLCB0b1JlZiwgd2F0Y2gsIHdhdGNoRWZmZWN0IH0gZnJvbSAndnVlJztcbmltcG9ydCB7IHVzZU1lbW8sIHVzZU1lcmdlZFN0YXRlIH0gZnJvbSAndm9va3MnO1xuaW1wb3J0IHsgZ2V0UGFkZGluZyB9IGZyb20gJ3NlZW1seSc7XG5pbXBvcnQgeyBWUmVzaXplT2JzZXJ2ZXIgfSBmcm9tICd2dWV1Yyc7XG5pbXBvcnQgeyBvZmYsIG9uIH0gZnJvbSAnZXZ0ZCc7XG5pbXBvcnQgeyBpc1NhZmFyaSB9IGZyb20gXCIuLi8uLi9fdXRpbHMvZW52L2Jyb3dzZXIubWpzXCI7XG5pbXBvcnQgeyBFeWVJY29uLCBFeWVPZmZJY29uIH0gZnJvbSBcIi4uLy4uL19pbnRlcm5hbC9pY29ucy9pbmRleC5tanNcIjtcbmltcG9ydCB7IHVzZVJ0bCB9IGZyb20gXCIuLi8uLi9fbWl4aW5zL3VzZS1ydGwubWpzXCI7XG5pbXBvcnQgeyBOQmFzZUNsZWFyLCBOQmFzZUljb24sIE5CYXNlU3VmZml4LCBOU2Nyb2xsYmFyIH0gZnJvbSBcIi4uLy4uL19pbnRlcm5hbC9pbmRleC5tanNcIjtcbmltcG9ydCB7IHVzZUNvbmZpZywgdXNlRm9ybUl0ZW0sIHVzZUxvY2FsZSwgdXNlU3R5bGUsIHVzZVRoZW1lLCB1c2VUaGVtZUNsYXNzIH0gZnJvbSBcIi4uLy4uL19taXhpbnMvaW5kZXgubWpzXCI7XG5pbXBvcnQgeyBjYWxsLCBjcmVhdGVLZXksIHJlc29sdmVTbG90LCByZXNvbHZlV3JhcHBlZFNsb3QsIHdhcm5PbmNlIH0gZnJvbSBcIi4uLy4uL191dGlscy9pbmRleC5tanNcIjtcbmltcG9ydCB7IGlucHV0TGlnaHQgfSBmcm9tIFwiLi4vc3R5bGVzL2luZGV4Lm1qc1wiO1xuaW1wb3J0IHsgaW5wdXRJbmplY3Rpb25LZXkgfSBmcm9tIFwiLi9pbnRlcmZhY2UubWpzXCI7XG5pbXBvcnQgeyBpc0VtcHR5SW5wdXRWYWx1ZSwgdXNlQ3Vyc29yIH0gZnJvbSBcIi4vdXRpbHMubWpzXCI7XG5pbXBvcnQgV29yZENvdW50IGZyb20gXCIuL1dvcmRDb3VudC5tanNcIjtcbmltcG9ydCBzdHlsZSwgeyBzYWZhcmlTdHlsZSB9IGZyb20gXCIuL3N0eWxlcy9pbnB1dC5jc3NyLm1qc1wiO1xuZXhwb3J0IGNvbnN0IGlucHV0UHJvcHMgPSBPYmplY3QuYXNzaWduKE9iamVjdC5hc3NpZ24oe30sIHVzZVRoZW1lLnByb3BzKSwge1xuICBib3JkZXJlZDoge1xuICAgIHR5cGU6IEJvb2xlYW4sXG4gICAgZGVmYXVsdDogdW5kZWZpbmVkXG4gIH0sXG4gIHR5cGU6IHtcbiAgICB0eXBlOiBTdHJpbmcsXG4gICAgZGVmYXVsdDogJ3RleHQnXG4gIH0sXG4gIHBsYWNlaG9sZGVyOiBbQXJyYXksIFN0cmluZ10sXG4gIGRlZmF1bHRWYWx1ZToge1xuICAgIHR5cGU6IFtTdHJpbmcsIEFycmF5XSxcbiAgICBkZWZhdWx0OiBudWxsXG4gIH0sXG4gIHZhbHVlOiBbU3RyaW5nLCBBcnJheV0sXG4gIGRpc2FibGVkOiB7XG4gICAgdHlwZTogQm9vbGVhbixcbiAgICBkZWZhdWx0OiB1bmRlZmluZWRcbiAgfSxcbiAgc2l6ZTogU3RyaW5nLFxuICByb3dzOiB7XG4gICAgdHlwZTogW051bWJlciwgU3RyaW5nXSxcbiAgICBkZWZhdWx0OiAzXG4gIH0sXG4gIHJvdW5kOiBCb29sZWFuLFxuICBtaW5sZW5ndGg6IFtTdHJpbmcsIE51bWJlcl0sXG4gIG1heGxlbmd0aDogW1N0cmluZywgTnVtYmVyXSxcbiAgY2xlYXJhYmxlOiBCb29sZWFuLFxuICBhdXRvc2l6ZToge1xuICAgIHR5cGU6IFtCb29sZWFuLCBPYmplY3RdLFxuICAgIGRlZmF1bHQ6IGZhbHNlXG4gIH0sXG4gIHBhaXI6IEJvb2xlYW4sXG4gIHNlcGFyYXRvcjogU3RyaW5nLFxuICByZWFkb25seToge1xuICAgIHR5cGU6IFtTdHJpbmcsIEJvb2xlYW5dLFxuICAgIGRlZmF1bHQ6IGZhbHNlXG4gIH0sXG4gIHBhc3NpdmVseUFjdGl2YXRlZDogQm9vbGVhbixcbiAgc2hvd1Bhc3N3b3JkT246IFN0cmluZyxcbiAgc3RhdGVmdWw6IHtcbiAgICB0eXBlOiBCb29sZWFuLFxuICAgIGRlZmF1bHQ6IHRydWVcbiAgfSxcbiAgYXV0b2ZvY3VzOiBCb29sZWFuLFxuICBpbnB1dFByb3BzOiBPYmplY3QsXG4gIHJlc2l6YWJsZToge1xuICAgIHR5cGU6IEJvb2xlYW4sXG4gICAgZGVmYXVsdDogdHJ1ZVxuICB9LFxuICBzaG93Q291bnQ6IEJvb2xlYW4sXG4gIGxvYWRpbmc6IHtcbiAgICB0eXBlOiBCb29sZWFuLFxuICAgIGRlZmF1bHQ6IHVuZGVmaW5lZFxuICB9LFxuICBhbGxvd0lucHV0OiBGdW5jdGlvbixcbiAgcmVuZGVyQ291bnQ6IEZ1bmN0aW9uLFxuICBvbk1vdXNlZG93bjogRnVuY3Rpb24sXG4gIG9uS2V5ZG93bjogRnVuY3Rpb24sXG4gIG9uS2V5dXA6IFtGdW5jdGlvbiwgQXJyYXldLFxuICBvbklucHV0OiBbRnVuY3Rpb24sIEFycmF5XSxcbiAgb25Gb2N1czogW0Z1bmN0aW9uLCBBcnJheV0sXG4gIG9uQmx1cjogW0Z1bmN0aW9uLCBBcnJheV0sXG4gIG9uQ2xpY2s6IFtGdW5jdGlvbiwgQXJyYXldLFxuICBvbkNoYW5nZTogW0Z1bmN0aW9uLCBBcnJheV0sXG4gIG9uQ2xlYXI6IFtGdW5jdGlvbiwgQXJyYXldLFxuICBjb3VudEdyYXBoZW1lczogRnVuY3Rpb24sXG4gIHN0YXR1czogU3RyaW5nLFxuICAnb25VcGRhdGU6dmFsdWUnOiBbRnVuY3Rpb24sIEFycmF5XSxcbiAgb25VcGRhdGVWYWx1ZTogW0Z1bmN0aW9uLCBBcnJheV0sXG4gIC8qKiBwcml2YXRlICovXG4gIHRleHREZWNvcmF0aW9uOiBbU3RyaW5nLCBBcnJheV0sXG4gIGF0dHJTaXplOiB7XG4gICAgdHlwZTogTnVtYmVyLFxuICAgIGRlZmF1bHQ6IDIwXG4gIH0sXG4gIG9uSW5wdXRCbHVyOiBbRnVuY3Rpb24sIEFycmF5XSxcbiAgb25JbnB1dEZvY3VzOiBbRnVuY3Rpb24sIEFycmF5XSxcbiAgb25EZWFjdGl2YXRlOiBbRnVuY3Rpb24sIEFycmF5XSxcbiAgb25BY3RpdmF0ZTogW0Z1bmN0aW9uLCBBcnJheV0sXG4gIG9uV3JhcHBlckZvY3VzOiBbRnVuY3Rpb24sIEFycmF5XSxcbiAgb25XcmFwcGVyQmx1cjogW0Z1bmN0aW9uLCBBcnJheV0sXG4gIGludGVybmFsRGVhY3RpdmF0ZU9uRW50ZXI6IEJvb2xlYW4sXG4gIGludGVybmFsRm9yY2VGb2N1czogQm9vbGVhbixcbiAgaW50ZXJuYWxMb2FkaW5nQmVmb3JlU3VmZml4OiB7XG4gICAgdHlwZTogQm9vbGVhbixcbiAgICBkZWZhdWx0OiB0cnVlXG4gIH0sXG4gIC8qKiBkZXByZWNhdGVkICovXG4gIHNob3dQYXNzd29yZFRvZ2dsZTogQm9vbGVhblxufSk7XG5leHBvcnQgZGVmYXVsdCBkZWZpbmVDb21wb25lbnQoe1xuICBuYW1lOiAnSW5wdXQnLFxuICBwcm9wczogaW5wdXRQcm9wcyxcbiAgc2V0dXAocHJvcHMpIHtcbiAgICBpZiAocHJvY2Vzcy5lbnYuTk9ERV9FTlYgIT09ICdwcm9kdWN0aW9uJykge1xuICAgICAgd2F0Y2hFZmZlY3QoKCkgPT4ge1xuICAgICAgICBpZiAocHJvcHMuc2hvd1Bhc3N3b3JkVG9nZ2xlKSB7XG4gICAgICAgICAgd2Fybk9uY2UoJ2lucHV0JywgJ2BzaG93LXBhc3N3b3JkLXRvZ2dsZWAgaXMgZGVwcmVjYXRlZCwgcGxlYXNlIHVzZSBgc2hvd1Bhc3N3b3JkT249XCJjbGlja1wiYCBpbnN0ZWFkJyk7XG4gICAgICAgIH1cbiAgICAgIH0pO1xuICAgIH1cbiAgICBjb25zdCB7XG4gICAgICBtZXJnZWRDbHNQcmVmaXhSZWYsXG4gICAgICBtZXJnZWRCb3JkZXJlZFJlZixcbiAgICAgIGlubGluZVRoZW1lRGlzYWJsZWQsXG4gICAgICBtZXJnZWRSdGxSZWZcbiAgICB9ID0gdXNlQ29uZmlnKHByb3BzKTtcbiAgICBjb25zdCB0aGVtZVJlZiA9IHVzZVRoZW1lKCdJbnB1dCcsICctaW5wdXQnLCBzdHlsZSwgaW5wdXRMaWdodCwgcHJvcHMsIG1lcmdlZENsc1ByZWZpeFJlZik7XG4gICAgaWYgKGlzU2FmYXJpKSB7XG4gICAgICB1c2VTdHlsZSgnLWlucHV0LXNhZmFyaScsIHNhZmFyaVN0eWxlLCBtZXJnZWRDbHNQcmVmaXhSZWYpO1xuICAgIH1cbiAgICAvLyBkb20gcmVmc1xuICAgIGNvbnN0IHdyYXBwZXJFbFJlZiA9IHJlZihudWxsKTtcbiAgICBjb25zdCB0ZXh0YXJlYUVsUmVmID0gcmVmKG51bGwpO1xuICAgIGNvbnN0IHRleHRhcmVhTWlycm9yRWxSZWYgPSByZWYobnVsbCk7XG4gICAgY29uc3QgaW5wdXRNaXJyb3JFbFJlZiA9IHJlZihudWxsKTtcbiAgICBjb25zdCBpbnB1dEVsUmVmID0gcmVmKG51bGwpO1xuICAgIGNvbnN0IGlucHV0RWwyUmVmID0gcmVmKG51bGwpO1xuICAgIGNvbnN0IGN1cnJlbnRGb2N1c2VkSW5wdXRSZWYgPSByZWYobnVsbCk7XG4gICAgY29uc3QgZm9jdXNlZElucHV0Q3Vyc29yQ29udHJvbCA9IHVzZUN1cnNvcihjdXJyZW50Rm9jdXNlZElucHV0UmVmKTtcbiAgICBjb25zdCB0ZXh0YXJlYVNjcm9sbGJhckluc3RSZWYgPSByZWYobnVsbCk7XG4gICAgLy8gbG9jYWxcbiAgICBjb25zdCB7XG4gICAgICBsb2NhbGVSZWZcbiAgICB9ID0gdXNlTG9jYWxlKCdJbnB1dCcpO1xuICAgIC8vIHZhbHVlXG4gICAgY29uc3QgdW5jb250cm9sbGVkVmFsdWVSZWYgPSByZWYocHJvcHMuZGVmYXVsdFZhbHVlKTtcbiAgICBjb25zdCBjb250cm9sbGVkVmFsdWVSZWYgPSB0b1JlZihwcm9wcywgJ3ZhbHVlJyk7XG4gICAgY29uc3QgbWVyZ2VkVmFsdWVSZWYgPSB1c2VNZXJnZWRTdGF0ZShjb250cm9sbGVkVmFsdWVSZWYsIHVuY29udHJvbGxlZFZhbHVlUmVmKTtcbiAgICAvLyBmb3JtLWl0ZW1cbiAgICBjb25zdCBmb3JtSXRlbSA9IHVzZUZvcm1JdGVtKHByb3BzKTtcbiAgICBjb25zdCB7XG4gICAgICBtZXJnZWRTaXplUmVmLFxuICAgICAgbWVyZ2VkRGlzYWJsZWRSZWYsXG4gICAgICBtZXJnZWRTdGF0dXNSZWZcbiAgICB9ID0gZm9ybUl0ZW07XG4gICAgLy8gc3RhdGVzXG4gICAgY29uc3QgZm9jdXNlZFJlZiA9IHJlZihmYWxzZSk7XG4gICAgY29uc3QgaG92ZXJSZWYgPSByZWYoZmFsc2UpO1xuICAgIGNvbnN0IGlzQ29tcG9zaW5nUmVmID0gcmVmKGZhbHNlKTtcbiAgICBjb25zdCBhY3RpdmF0ZWRSZWYgPSByZWYoZmFsc2UpO1xuICAgIGxldCBzeW5jU291cmNlID0gbnVsbDtcbiAgICAvLyBwbGFjZWhvbGRlclxuICAgIGNvbnN0IG1lcmdlZFBsYWNlaG9sZGVyUmVmID0gY29tcHV0ZWQoKCkgPT4ge1xuICAgICAgY29uc3Qge1xuICAgICAgICBwbGFjZWhvbGRlcixcbiAgICAgICAgcGFpclxuICAgICAgfSA9IHByb3BzO1xuICAgICAgaWYgKHBhaXIpIHtcbiAgICAgICAgaWYgKEFycmF5LmlzQXJyYXkocGxhY2Vob2xkZXIpKSB7XG4gICAgICAgICAgcmV0dXJuIHBsYWNlaG9sZGVyO1xuICAgICAgICB9IGVsc2UgaWYgKHBsYWNlaG9sZGVyID09PSB1bmRlZmluZWQpIHtcbiAgICAgICAgICByZXR1cm4gWycnLCAnJ107XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIFtwbGFjZWhvbGRlciwgcGxhY2Vob2xkZXJdO1xuICAgICAgfSBlbHNlIGlmIChwbGFjZWhvbGRlciA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICAgIHJldHVybiBbbG9jYWxlUmVmLnZhbHVlLnBsYWNlaG9sZGVyXTtcbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIHJldHVybiBbcGxhY2Vob2xkZXJdO1xuICAgICAgfVxuICAgIH0pO1xuICAgIGNvbnN0IHNob3dQbGFjZWhvbGRlcjFSZWYgPSBjb21wdXRlZCgoKSA9PiB7XG4gICAgICBjb25zdCB7XG4gICAgICAgIHZhbHVlOiBpc0NvbXBvc2luZ1xuICAgICAgfSA9IGlzQ29tcG9zaW5nUmVmO1xuICAgICAgY29uc3Qge1xuICAgICAgICB2YWx1ZTogbWVyZ2VkVmFsdWVcbiAgICAgIH0gPSBtZXJnZWRWYWx1ZVJlZjtcbiAgICAgIGNvbnN0IHtcbiAgICAgICAgdmFsdWU6IG1lcmdlZFBsYWNlaG9sZGVyXG4gICAgICB9ID0gbWVyZ2VkUGxhY2Vob2xkZXJSZWY7XG4gICAgICByZXR1cm4gIWlzQ29tcG9zaW5nICYmIChpc0VtcHR5SW5wdXRWYWx1ZShtZXJnZWRWYWx1ZSkgfHwgQXJyYXkuaXNBcnJheShtZXJnZWRWYWx1ZSkgJiYgaXNFbXB0eUlucHV0VmFsdWUobWVyZ2VkVmFsdWVbMF0pKSAmJiBtZXJnZWRQbGFjZWhvbGRlclswXTtcbiAgICB9KTtcbiAgICBjb25zdCBzaG93UGxhY2Vob2xkZXIyUmVmID0gY29tcHV0ZWQoKCkgPT4ge1xuICAgICAgY29uc3Qge1xuICAgICAgICB2YWx1ZTogaXNDb21wb3NpbmdcbiAgICAgIH0gPSBpc0NvbXBvc2luZ1JlZjtcbiAgICAgIGNvbnN0IHtcbiAgICAgICAgdmFsdWU6IG1lcmdlZFZhbHVlXG4gICAgICB9ID0gbWVyZ2VkVmFsdWVSZWY7XG4gICAgICBjb25zdCB7XG4gICAgICAgIHZhbHVlOiBtZXJnZWRQbGFjZWhvbGRlclxuICAgICAgfSA9IG1lcmdlZFBsYWNlaG9sZGVyUmVmO1xuICAgICAgcmV0dXJuICFpc0NvbXBvc2luZyAmJiBtZXJnZWRQbGFjZWhvbGRlclsxXSAmJiAoaXNFbXB0eUlucHV0VmFsdWUobWVyZ2VkVmFsdWUpIHx8IEFycmF5LmlzQXJyYXkobWVyZ2VkVmFsdWUpICYmIGlzRW1wdHlJbnB1dFZhbHVlKG1lcmdlZFZhbHVlWzFdKSk7XG4gICAgfSk7XG4gICAgLy8gZm9jdXNcbiAgICBjb25zdCBtZXJnZWRGb2N1c1JlZiA9IHVzZU1lbW8oKCkgPT4ge1xuICAgICAgcmV0dXJuIHByb3BzLmludGVybmFsRm9yY2VGb2N1cyB8fCBmb2N1c2VkUmVmLnZhbHVlO1xuICAgIH0pO1xuICAgIC8vIGNsZWFyXG4gICAgY29uc3Qgc2hvd0NsZWFyQnV0dG9uID0gdXNlTWVtbygoKSA9PiB7XG4gICAgICBpZiAobWVyZ2VkRGlzYWJsZWRSZWYudmFsdWUgfHwgcHJvcHMucmVhZG9ubHkgfHwgIXByb3BzLmNsZWFyYWJsZSB8fCAhbWVyZ2VkRm9jdXNSZWYudmFsdWUgJiYgIWhvdmVyUmVmLnZhbHVlKSB7XG4gICAgICAgIHJldHVybiBmYWxzZTtcbiAgICAgIH1cbiAgICAgIGNvbnN0IHtcbiAgICAgICAgdmFsdWU6IG1lcmdlZFZhbHVlXG4gICAgICB9ID0gbWVyZ2VkVmFsdWVSZWY7XG4gICAgICBjb25zdCB7XG4gICAgICAgIHZhbHVlOiBtZXJnZWRGb2N1c1xuICAgICAgfSA9IG1lcmdlZEZvY3VzUmVmO1xuICAgICAgaWYgKHByb3BzLnBhaXIpIHtcbiAgICAgICAgcmV0dXJuICEhKEFycmF5LmlzQXJyYXkobWVyZ2VkVmFsdWUpICYmIChtZXJnZWRWYWx1ZVswXSB8fCBtZXJnZWRWYWx1ZVsxXSkpICYmIChob3ZlclJlZi52YWx1ZSB8fCBtZXJnZWRGb2N1cyk7XG4gICAgICB9IGVsc2Uge1xuICAgICAgICByZXR1cm4gISFtZXJnZWRWYWx1ZSAmJiAoaG92ZXJSZWYudmFsdWUgfHwgbWVyZ2VkRm9jdXMpO1xuICAgICAgfVxuICAgIH0pO1xuICAgIC8vIHBhc3N3b3JkVmlzaWJsZVxuICAgIGNvbnN0IG1lcmdlZFNob3dQYXNzd29yZE9uUmVmID0gY29tcHV0ZWQoKCkgPT4ge1xuICAgICAgY29uc3Qge1xuICAgICAgICBzaG93UGFzc3dvcmRPblxuICAgICAgfSA9IHByb3BzO1xuICAgICAgaWYgKHNob3dQYXNzd29yZE9uKSB7XG4gICAgICAgIHJldHVybiBzaG93UGFzc3dvcmRPbjtcbiAgICAgIH1cbiAgICAgIGlmIChwcm9wcy5zaG93UGFzc3dvcmRUb2dnbGUpIHJldHVybiAnY2xpY2snO1xuICAgICAgcmV0dXJuIHVuZGVmaW5lZDtcbiAgICB9KTtcbiAgICBjb25zdCBwYXNzd29yZFZpc2libGVSZWYgPSByZWYoZmFsc2UpO1xuICAgIC8vIHRleHQtZGVjb3JhdGlvblxuICAgIGNvbnN0IHRleHREZWNvcmF0aW9uU3R5bGVSZWYgPSBjb21wdXRlZCgoKSA9PiB7XG4gICAgICBjb25zdCB7XG4gICAgICAgIHRleHREZWNvcmF0aW9uXG4gICAgICB9ID0gcHJvcHM7XG4gICAgICBpZiAoIXRleHREZWNvcmF0aW9uKSByZXR1cm4gWycnLCAnJ107XG4gICAgICBpZiAoQXJyYXkuaXNBcnJheSh0ZXh0RGVjb3JhdGlvbikpIHtcbiAgICAgICAgcmV0dXJuIHRleHREZWNvcmF0aW9uLm1hcCh2ID0+ICh7XG4gICAgICAgICAgdGV4dERlY29yYXRpb246IHZcbiAgICAgICAgfSkpO1xuICAgICAgfVxuICAgICAgcmV0dXJuIFt7XG4gICAgICAgIHRleHREZWNvcmF0aW9uXG4gICAgICB9XTtcbiAgICB9KTtcbiAgICBjb25zdCB0ZXh0QXJlYVNjcm9sbENvbnRhaW5lcldpZHRoUmVmID0gcmVmKHVuZGVmaW5lZCk7XG4gICAgLy8gdGV4dGFyZWEgYXV0b3NpemVcbiAgICBjb25zdCB1cGRhdGVUZXh0QXJlYVN0eWxlID0gKCkgPT4ge1xuICAgICAgdmFyIF9hLCBfYjtcbiAgICAgIGlmIChwcm9wcy50eXBlID09PSAndGV4dGFyZWEnKSB7XG4gICAgICAgIGNvbnN0IHtcbiAgICAgICAgICBhdXRvc2l6ZVxuICAgICAgICB9ID0gcHJvcHM7XG4gICAgICAgIGlmIChhdXRvc2l6ZSkge1xuICAgICAgICAgIHRleHRBcmVhU2Nyb2xsQ29udGFpbmVyV2lkdGhSZWYudmFsdWUgPSAoX2IgPSAoX2EgPSB0ZXh0YXJlYVNjcm9sbGJhckluc3RSZWYudmFsdWUpID09PSBudWxsIHx8IF9hID09PSB2b2lkIDAgPyB2b2lkIDAgOiBfYS4kZWwpID09PSBudWxsIHx8IF9iID09PSB2b2lkIDAgPyB2b2lkIDAgOiBfYi5vZmZzZXRXaWR0aDtcbiAgICAgICAgfVxuICAgICAgICBpZiAoIXRleHRhcmVhRWxSZWYudmFsdWUpIHJldHVybjtcbiAgICAgICAgaWYgKHR5cGVvZiBhdXRvc2l6ZSA9PT0gJ2Jvb2xlYW4nKSByZXR1cm47XG4gICAgICAgIGNvbnN0IHtcbiAgICAgICAgICBwYWRkaW5nVG9wOiBzdHlsZVBhZGRpbmdUb3AsXG4gICAgICAgICAgcGFkZGluZ0JvdHRvbTogc3R5bGVQYWRkaW5nQm90dG9tLFxuICAgICAgICAgIGxpbmVIZWlnaHQ6IHN0eWxlTGluZUhlaWdodFxuICAgICAgICB9ID0gd2luZG93LmdldENvbXB1dGVkU3R5bGUodGV4dGFyZWFFbFJlZi52YWx1ZSk7XG4gICAgICAgIGNvbnN0IHBhZGRpbmdUb3AgPSBOdW1iZXIoc3R5bGVQYWRkaW5nVG9wLnNsaWNlKDAsIC0yKSk7XG4gICAgICAgIGNvbnN0IHBhZGRpbmdCb3R0b20gPSBOdW1iZXIoc3R5bGVQYWRkaW5nQm90dG9tLnNsaWNlKDAsIC0yKSk7XG4gICAgICAgIGNvbnN0IGxpbmVIZWlnaHQgPSBOdW1iZXIoc3R5bGVMaW5lSGVpZ2h0LnNsaWNlKDAsIC0yKSk7XG4gICAgICAgIGNvbnN0IHtcbiAgICAgICAgICB2YWx1ZTogdGV4dGFyZWFNaXJyb3JFbFxuICAgICAgICB9ID0gdGV4dGFyZWFNaXJyb3JFbFJlZjtcbiAgICAgICAgaWYgKCF0ZXh0YXJlYU1pcnJvckVsKSByZXR1cm47XG4gICAgICAgIGlmIChhdXRvc2l6ZS5taW5Sb3dzKSB7XG4gICAgICAgICAgY29uc3QgbWluUm93cyA9IE1hdGgubWF4KGF1dG9zaXplLm1pblJvd3MsIDEpO1xuICAgICAgICAgIGNvbnN0IHN0eWxlTWluSGVpZ2h0ID0gYCR7cGFkZGluZ1RvcCArIHBhZGRpbmdCb3R0b20gKyBsaW5lSGVpZ2h0ICogbWluUm93c31weGA7XG4gICAgICAgICAgdGV4dGFyZWFNaXJyb3JFbC5zdHlsZS5taW5IZWlnaHQgPSBzdHlsZU1pbkhlaWdodDtcbiAgICAgICAgfVxuICAgICAgICBpZiAoYXV0b3NpemUubWF4Um93cykge1xuICAgICAgICAgIGNvbnN0IHN0eWxlTWF4SGVpZ2h0ID0gYCR7cGFkZGluZ1RvcCArIHBhZGRpbmdCb3R0b20gKyBsaW5lSGVpZ2h0ICogYXV0b3NpemUubWF4Um93c31weGA7XG4gICAgICAgICAgdGV4dGFyZWFNaXJyb3JFbC5zdHlsZS5tYXhIZWlnaHQgPSBzdHlsZU1heEhlaWdodDtcbiAgICAgICAgfVxuICAgICAgfVxuICAgIH07XG4gICAgLy8gd29yZCBjb3VudFxuICAgIGNvbnN0IG1heGxlbmd0aFJlZiA9IGNvbXB1dGVkKCgpID0+IHtcbiAgICAgIGNvbnN0IHtcbiAgICAgICAgbWF4bGVuZ3RoXG4gICAgICB9ID0gcHJvcHM7XG4gICAgICByZXR1cm4gbWF4bGVuZ3RoID09PSB1bmRlZmluZWQgPyB1bmRlZmluZWQgOiBOdW1iZXIobWF4bGVuZ3RoKTtcbiAgICB9KTtcbiAgICBvbk1vdW50ZWQoKCkgPT4ge1xuICAgICAgLy8gc3luYyBtaXJyb3IgaWYgaXMgbm90IHBhaXJcbiAgICAgIGNvbnN0IHtcbiAgICAgICAgdmFsdWVcbiAgICAgIH0gPSBtZXJnZWRWYWx1ZVJlZjtcbiAgICAgIGlmICghQXJyYXkuaXNBcnJheSh2YWx1ZSkpIHtcbiAgICAgICAgc3luY01pcnJvcih2YWx1ZSk7XG4gICAgICB9XG4gICAgfSk7XG4gICAgLy8gb3RoZXIgbWV0aG9kc1xuICAgIGNvbnN0IHZtID0gZ2V0Q3VycmVudEluc3RhbmNlKCkucHJveHk7XG4gICAgZnVuY3Rpb24gZG9VcGRhdGVWYWx1ZSh2YWx1ZSwgbWV0YSkge1xuICAgICAgY29uc3Qge1xuICAgICAgICBvblVwZGF0ZVZhbHVlLFxuICAgICAgICAnb25VcGRhdGU6dmFsdWUnOiBfb25VcGRhdGVWYWx1ZSxcbiAgICAgICAgb25JbnB1dFxuICAgICAgfSA9IHByb3BzO1xuICAgICAgY29uc3Qge1xuICAgICAgICBuVHJpZ2dlckZvcm1JbnB1dFxuICAgICAgfSA9IGZvcm1JdGVtO1xuICAgICAgaWYgKG9uVXBkYXRlVmFsdWUpIGNhbGwob25VcGRhdGVWYWx1ZSwgdmFsdWUsIG1ldGEpO1xuICAgICAgaWYgKF9vblVwZGF0ZVZhbHVlKSBjYWxsKF9vblVwZGF0ZVZhbHVlLCB2YWx1ZSwgbWV0YSk7XG4gICAgICBpZiAob25JbnB1dCkgY2FsbChvbklucHV0LCB2YWx1ZSwgbWV0YSk7XG4gICAgICB1bmNvbnRyb2xsZWRWYWx1ZVJlZi52YWx1ZSA9IHZhbHVlO1xuICAgICAgblRyaWdnZXJGb3JtSW5wdXQoKTtcbiAgICB9XG4gICAgZnVuY3Rpb24gZG9DaGFuZ2UodmFsdWUsIG1ldGEpIHtcbiAgICAgIGNvbnN0IHtcbiAgICAgICAgb25DaGFuZ2VcbiAgICAgIH0gPSBwcm9wcztcbiAgICAgIGNvbnN0IHtcbiAgICAgICAgblRyaWdnZXJGb3JtQ2hhbmdlXG4gICAgICB9ID0gZm9ybUl0ZW07XG4gICAgICBpZiAob25DaGFuZ2UpIGNhbGwob25DaGFuZ2UsIHZhbHVlLCBtZXRhKTtcbiAgICAgIHVuY29udHJvbGxlZFZhbHVlUmVmLnZhbHVlID0gdmFsdWU7XG4gICAgICBuVHJpZ2dlckZvcm1DaGFuZ2UoKTtcbiAgICB9XG4gICAgZnVuY3Rpb24gZG9CbHVyKGUpIHtcbiAgICAgIGNvbnN0IHtcbiAgICAgICAgb25CbHVyXG4gICAgICB9ID0gcHJvcHM7XG4gICAgICBjb25zdCB7XG4gICAgICAgIG5UcmlnZ2VyRm9ybUJsdXJcbiAgICAgIH0gPSBmb3JtSXRlbTtcbiAgICAgIGlmIChvbkJsdXIpIGNhbGwob25CbHVyLCBlKTtcbiAgICAgIG5UcmlnZ2VyRm9ybUJsdXIoKTtcbiAgICB9XG4gICAgZnVuY3Rpb24gZG9Gb2N1cyhlKSB7XG4gICAgICBjb25zdCB7XG4gICAgICAgIG9uRm9jdXNcbiAgICAgIH0gPSBwcm9wcztcbiAgICAgIGNvbnN0IHtcbiAgICAgICAgblRyaWdnZXJGb3JtRm9jdXNcbiAgICAgIH0gPSBmb3JtSXRlbTtcbiAgICAgIGlmIChvbkZvY3VzKSBjYWxsKG9uRm9jdXMsIGUpO1xuICAgICAgblRyaWdnZXJGb3JtRm9jdXMoKTtcbiAgICB9XG4gICAgZnVuY3Rpb24gZG9DbGVhcihlKSB7XG4gICAgICBjb25zdCB7XG4gICAgICAgIG9uQ2xlYXJcbiAgICAgIH0gPSBwcm9wcztcbiAgICAgIGlmIChvbkNsZWFyKSBjYWxsKG9uQ2xlYXIsIGUpO1xuICAgIH1cbiAgICBmdW5jdGlvbiBkb1VwZGF0ZVZhbHVlQmx1cihlKSB7XG4gICAgICBjb25zdCB7XG4gICAgICAgIG9uSW5wdXRCbHVyXG4gICAgICB9ID0gcHJvcHM7XG4gICAgICBpZiAob25JbnB1dEJsdXIpIGNhbGwob25JbnB1dEJsdXIsIGUpO1xuICAgIH1cbiAgICBmdW5jdGlvbiBkb1VwZGF0ZVZhbHVlRm9jdXMoZSkge1xuICAgICAgY29uc3Qge1xuICAgICAgICBvbklucHV0Rm9jdXNcbiAgICAgIH0gPSBwcm9wcztcbiAgICAgIGlmIChvbklucHV0Rm9jdXMpIGNhbGwob25JbnB1dEZvY3VzLCBlKTtcbiAgICB9XG4gICAgZnVuY3Rpb24gZG9EZWFjdGl2YXRlKCkge1xuICAgICAgY29uc3Qge1xuICAgICAgICBvbkRlYWN0aXZhdGVcbiAgICAgIH0gPSBwcm9wcztcbiAgICAgIGlmIChvbkRlYWN0aXZhdGUpIGNhbGwob25EZWFjdGl2YXRlKTtcbiAgICB9XG4gICAgZnVuY3Rpb24gZG9BY3RpdmF0ZSgpIHtcbiAgICAgIGNvbnN0IHtcbiAgICAgICAgb25BY3RpdmF0ZVxuICAgICAgfSA9IHByb3BzO1xuICAgICAgaWYgKG9uQWN0aXZhdGUpIGNhbGwob25BY3RpdmF0ZSk7XG4gICAgfVxuICAgIGZ1bmN0aW9uIGRvQ2xpY2soZSkge1xuICAgICAgY29uc3Qge1xuICAgICAgICBvbkNsaWNrXG4gICAgICB9ID0gcHJvcHM7XG4gICAgICBpZiAob25DbGljaykgY2FsbChvbkNsaWNrLCBlKTtcbiAgICB9XG4gICAgZnVuY3Rpb24gZG9XcmFwcGVyRm9jdXMoZSkge1xuICAgICAgY29uc3Qge1xuICAgICAgICBvbldyYXBwZXJGb2N1c1xuICAgICAgfSA9IHByb3BzO1xuICAgICAgaWYgKG9uV3JhcHBlckZvY3VzKSBjYWxsKG9uV3JhcHBlckZvY3VzLCBlKTtcbiAgICB9XG4gICAgZnVuY3Rpb24gZG9XcmFwcGVyQmx1cihlKSB7XG4gICAgICBjb25zdCB7XG4gICAgICAgIG9uV3JhcHBlckJsdXJcbiAgICAgIH0gPSBwcm9wcztcbiAgICAgIGlmIChvbldyYXBwZXJCbHVyKSBjYWxsKG9uV3JhcHBlckJsdXIsIGUpO1xuICAgIH1cbiAgICAvLyBtZXRob2RzXG4gICAgZnVuY3Rpb24gaGFuZGxlQ29tcG9zaXRpb25TdGFydCgpIHtcbiAgICAgIGlzQ29tcG9zaW5nUmVmLnZhbHVlID0gdHJ1ZTtcbiAgICB9XG4gICAgZnVuY3Rpb24gaGFuZGxlQ29tcG9zaXRpb25FbmQoZSkge1xuICAgICAgaXNDb21wb3NpbmdSZWYudmFsdWUgPSBmYWxzZTtcbiAgICAgIGlmIChlLnRhcmdldCA9PT0gaW5wdXRFbDJSZWYudmFsdWUpIHtcbiAgICAgICAgaGFuZGxlSW5wdXQoZSwgMSk7XG4gICAgICB9IGVsc2Uge1xuICAgICAgICBoYW5kbGVJbnB1dChlLCAwKTtcbiAgICAgIH1cbiAgICB9XG4gICAgZnVuY3Rpb24gaGFuZGxlSW5wdXQoZSwgaW5kZXggPSAwLCBldmVudCA9ICdpbnB1dCcpIHtcbiAgICAgIGNvbnN0IHRhcmdldFZhbHVlID0gZS50YXJnZXQudmFsdWU7XG4gICAgICBzeW5jTWlycm9yKHRhcmdldFZhbHVlKTtcbiAgICAgIGlmIChlIGluc3RhbmNlb2YgSW5wdXRFdmVudCAmJiAhZS5pc0NvbXBvc2luZykge1xuICAgICAgICBpc0NvbXBvc2luZ1JlZi52YWx1ZSA9IGZhbHNlO1xuICAgICAgfVxuICAgICAgaWYgKHByb3BzLnR5cGUgPT09ICd0ZXh0YXJlYScpIHtcbiAgICAgICAgY29uc3Qge1xuICAgICAgICAgIHZhbHVlOiB0ZXh0YXJlYVNjcm9sbGJhckluc3RcbiAgICAgICAgfSA9IHRleHRhcmVhU2Nyb2xsYmFySW5zdFJlZjtcbiAgICAgICAgaWYgKHRleHRhcmVhU2Nyb2xsYmFySW5zdCkge1xuICAgICAgICAgIHRleHRhcmVhU2Nyb2xsYmFySW5zdC5zeW5jVW5pZmllZENvbnRhaW5lcigpO1xuICAgICAgICB9XG4gICAgICB9XG4gICAgICBzeW5jU291cmNlID0gdGFyZ2V0VmFsdWU7XG4gICAgICBpZiAoaXNDb21wb3NpbmdSZWYudmFsdWUpIHJldHVybjtcbiAgICAgIGZvY3VzZWRJbnB1dEN1cnNvckNvbnRyb2wucmVjb3JkQ3Vyc29yKCk7XG4gICAgICBjb25zdCBpc0luY29taW5nVmFsdWVWYWxpZCA9IGFsbG93SW5wdXQodGFyZ2V0VmFsdWUpO1xuICAgICAgaWYgKGlzSW5jb21pbmdWYWx1ZVZhbGlkKSB7XG4gICAgICAgIGlmICghcHJvcHMucGFpcikge1xuICAgICAgICAgIGlmIChldmVudCA9PT0gJ2lucHV0Jykge1xuICAgICAgICAgICAgZG9VcGRhdGVWYWx1ZSh0YXJnZXRWYWx1ZSwge1xuICAgICAgICAgICAgICBzb3VyY2U6IGluZGV4XG4gICAgICAgICAgICB9KTtcbiAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgZG9DaGFuZ2UodGFyZ2V0VmFsdWUsIHtcbiAgICAgICAgICAgICAgc291cmNlOiBpbmRleFxuICAgICAgICAgICAgfSk7XG4gICAgICAgICAgfVxuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgIGxldCB7XG4gICAgICAgICAgICB2YWx1ZVxuICAgICAgICAgIH0gPSBtZXJnZWRWYWx1ZVJlZjtcbiAgICAgICAgICBpZiAoIUFycmF5LmlzQXJyYXkodmFsdWUpKSB7XG4gICAgICAgICAgICB2YWx1ZSA9IFsnJywgJyddO1xuICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICB2YWx1ZSA9IFt2YWx1ZVswXSwgdmFsdWVbMV1dO1xuICAgICAgICAgIH1cbiAgICAgICAgICB2YWx1ZVtpbmRleF0gPSB0YXJnZXRWYWx1ZTtcbiAgICAgICAgICBpZiAoZXZlbnQgPT09ICdpbnB1dCcpIHtcbiAgICAgICAgICAgIGRvVXBkYXRlVmFsdWUodmFsdWUsIHtcbiAgICAgICAgICAgICAgc291cmNlOiBpbmRleFxuICAgICAgICAgICAgfSk7XG4gICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgIGRvQ2hhbmdlKHZhbHVlLCB7XG4gICAgICAgICAgICAgIHNvdXJjZTogaW5kZXhcbiAgICAgICAgICAgIH0pO1xuICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgfVxuICAgICAgLy8gZm9yY2UgdXBkYXRlIHRvIHN5bmMgaW5wdXQncyB2aWV3IHdpdGggdmFsdWVcbiAgICAgIC8vIGlmIG5vdCBzZXQsIGFmdGVyIGlucHV0LCBpbnB1dCB2YWx1ZSB3b24ndCBzeW5jIHdpdGggZG9tIGlucHV0IHZhbHVlXG4gICAgICB2bS4kZm9yY2VVcGRhdGUoKTtcbiAgICAgIGlmICghaXNJbmNvbWluZ1ZhbHVlVmFsaWQpIHtcbiAgICAgICAgdm9pZCBuZXh0VGljayhmb2N1c2VkSW5wdXRDdXJzb3JDb250cm9sLnJlc3RvcmVDdXJzb3IpO1xuICAgICAgfVxuICAgIH1cbiAgICBmdW5jdGlvbiBhbGxvd0lucHV0KHZhbHVlKSB7XG4gICAgICBjb25zdCB7XG4gICAgICAgIGNvdW50R3JhcGhlbWVzLFxuICAgICAgICBtYXhsZW5ndGgsXG4gICAgICAgIG1pbmxlbmd0aFxuICAgICAgfSA9IHByb3BzO1xuICAgICAgaWYgKGNvdW50R3JhcGhlbWVzKSB7XG4gICAgICAgIGxldCBncmFwaGVtZXNDb3VudDtcbiAgICAgICAgaWYgKG1heGxlbmd0aCAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICAgICAgaWYgKGdyYXBoZW1lc0NvdW50ID09PSB1bmRlZmluZWQpIHtcbiAgICAgICAgICAgIGdyYXBoZW1lc0NvdW50ID0gY291bnRHcmFwaGVtZXModmFsdWUpO1xuICAgICAgICAgIH1cbiAgICAgICAgICBpZiAoZ3JhcGhlbWVzQ291bnQgPiBOdW1iZXIobWF4bGVuZ3RoKSkgcmV0dXJuIGZhbHNlO1xuICAgICAgICB9XG4gICAgICAgIGlmIChtaW5sZW5ndGggIT09IHVuZGVmaW5lZCkge1xuICAgICAgICAgIGlmIChncmFwaGVtZXNDb3VudCA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICAgICAgICBncmFwaGVtZXNDb3VudCA9IGNvdW50R3JhcGhlbWVzKHZhbHVlKTtcbiAgICAgICAgICB9XG4gICAgICAgICAgaWYgKGdyYXBoZW1lc0NvdW50IDwgTnVtYmVyKG1heGxlbmd0aCkpIHJldHVybiBmYWxzZTtcbiAgICAgICAgfVxuICAgICAgfVxuICAgICAgY29uc3Qge1xuICAgICAgICBhbGxvd0lucHV0XG4gICAgICB9ID0gcHJvcHM7XG4gICAgICBpZiAodHlwZW9mIGFsbG93SW5wdXQgPT09ICdmdW5jdGlvbicpIHtcbiAgICAgICAgcmV0dXJuIGFsbG93SW5wdXQodmFsdWUpO1xuICAgICAgfVxuICAgICAgcmV0dXJuIHRydWU7XG4gICAgfVxuICAgIGZ1bmN0aW9uIGhhbmRsZUlucHV0Qmx1cihlKSB7XG4gICAgICBkb1VwZGF0ZVZhbHVlQmx1cihlKTtcbiAgICAgIGlmIChlLnJlbGF0ZWRUYXJnZXQgPT09IHdyYXBwZXJFbFJlZi52YWx1ZSkge1xuICAgICAgICBkb0RlYWN0aXZhdGUoKTtcbiAgICAgIH1cbiAgICAgIGlmICghKGUucmVsYXRlZFRhcmdldCAhPT0gbnVsbCAmJiAoZS5yZWxhdGVkVGFyZ2V0ID09PSBpbnB1dEVsUmVmLnZhbHVlIHx8IGUucmVsYXRlZFRhcmdldCA9PT0gaW5wdXRFbDJSZWYudmFsdWUgfHwgZS5yZWxhdGVkVGFyZ2V0ID09PSB0ZXh0YXJlYUVsUmVmLnZhbHVlKSkpIHtcbiAgICAgICAgYWN0aXZhdGVkUmVmLnZhbHVlID0gZmFsc2U7XG4gICAgICB9XG4gICAgICBkZWFsV2l0aEV2ZW50KGUsICdibHVyJyk7XG4gICAgICBjdXJyZW50Rm9jdXNlZElucHV0UmVmLnZhbHVlID0gbnVsbDtcbiAgICB9XG4gICAgZnVuY3Rpb24gaGFuZGxlSW5wdXRGb2N1cyhlLCBpbmRleCkge1xuICAgICAgZG9VcGRhdGVWYWx1ZUZvY3VzKGUpO1xuICAgICAgZm9jdXNlZFJlZi52YWx1ZSA9IHRydWU7XG4gICAgICBhY3RpdmF0ZWRSZWYudmFsdWUgPSB0cnVlO1xuICAgICAgZG9BY3RpdmF0ZSgpO1xuICAgICAgZGVhbFdpdGhFdmVudChlLCAnZm9jdXMnKTtcbiAgICAgIGlmIChpbmRleCA9PT0gMCkge1xuICAgICAgICBjdXJyZW50Rm9jdXNlZElucHV0UmVmLnZhbHVlID0gaW5wdXRFbFJlZi52YWx1ZTtcbiAgICAgIH0gZWxzZSBpZiAoaW5kZXggPT09IDEpIHtcbiAgICAgICAgY3VycmVudEZvY3VzZWRJbnB1dFJlZi52YWx1ZSA9IGlucHV0RWwyUmVmLnZhbHVlO1xuICAgICAgfSBlbHNlIGlmIChpbmRleCA9PT0gMikge1xuICAgICAgICBjdXJyZW50Rm9jdXNlZElucHV0UmVmLnZhbHVlID0gdGV4dGFyZWFFbFJlZi52YWx1ZTtcbiAgICAgIH1cbiAgICB9XG4gICAgZnVuY3Rpb24gaGFuZGxlV3JhcHBlckJsdXIoZSkge1xuICAgICAgaWYgKHByb3BzLnBhc3NpdmVseUFjdGl2YXRlZCkge1xuICAgICAgICBkb1dyYXBwZXJCbHVyKGUpO1xuICAgICAgICBkZWFsV2l0aEV2ZW50KGUsICdibHVyJyk7XG4gICAgICB9XG4gICAgfVxuICAgIGZ1bmN0aW9uIGhhbmRsZVdyYXBwZXJGb2N1cyhlKSB7XG4gICAgICBpZiAocHJvcHMucGFzc2l2ZWx5QWN0aXZhdGVkKSB7XG4gICAgICAgIGZvY3VzZWRSZWYudmFsdWUgPSB0cnVlO1xuICAgICAgICBkb1dyYXBwZXJGb2N1cyhlKTtcbiAgICAgICAgZGVhbFdpdGhFdmVudChlLCAnZm9jdXMnKTtcbiAgICAgIH1cbiAgICB9XG4gICAgZnVuY3Rpb24gZGVhbFdpdGhFdmVudChlLCB0eXBlKSB7XG4gICAgICBpZiAoZS5yZWxhdGVkVGFyZ2V0ICE9PSBudWxsICYmIChlLnJlbGF0ZWRUYXJnZXQgPT09IGlucHV0RWxSZWYudmFsdWUgfHwgZS5yZWxhdGVkVGFyZ2V0ID09PSBpbnB1dEVsMlJlZi52YWx1ZSB8fCBlLnJlbGF0ZWRUYXJnZXQgPT09IHRleHRhcmVhRWxSZWYudmFsdWUgfHwgZS5yZWxhdGVkVGFyZ2V0ID09PSB3cmFwcGVyRWxSZWYudmFsdWUpKSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBhY3RpdmVFbGVtZW50IHRyYW5zZmVyIGluc2lkZSB0aGUgaW5wdXQsIGRvIG5vdGhpbmdcbiAgICAgICAgICovXG4gICAgICB9IGVsc2Uge1xuICAgICAgICBpZiAodHlwZSA9PT0gJ2ZvY3VzJykge1xuICAgICAgICAgIGRvRm9jdXMoZSk7XG4gICAgICAgICAgZm9jdXNlZFJlZi52YWx1ZSA9IHRydWU7XG4gICAgICAgIH0gZWxzZSBpZiAodHlwZSA9PT0gJ2JsdXInKSB7XG4gICAgICAgICAgZG9CbHVyKGUpO1xuICAgICAgICAgIGZvY3VzZWRSZWYudmFsdWUgPSBmYWxzZTtcbiAgICAgICAgfVxuICAgICAgfVxuICAgIH1cbiAgICBmdW5jdGlvbiBoYW5kbGVDaGFuZ2UoZSwgaW5kZXgpIHtcbiAgICAgIGhhbmRsZUlucHV0KGUsIGluZGV4LCAnY2hhbmdlJyk7XG4gICAgfVxuICAgIGZ1bmN0aW9uIGhhbmRsZUNsaWNrKGUpIHtcbiAgICAgIGRvQ2xpY2soZSk7XG4gICAgfVxuICAgIGZ1bmN0aW9uIGhhbmRsZUNsZWFyKGUpIHtcbiAgICAgIGRvQ2xlYXIoZSk7XG4gICAgICBjbGVhclZhbHVlKCk7XG4gICAgfVxuICAgIGZ1bmN0aW9uIGNsZWFyVmFsdWUoKSB7XG4gICAgICBpZiAocHJvcHMucGFpcikge1xuICAgICAgICBkb1VwZGF0ZVZhbHVlKFsnJywgJyddLCB7XG4gICAgICAgICAgc291cmNlOiAnY2xlYXInXG4gICAgICAgIH0pO1xuICAgICAgICBkb0NoYW5nZShbJycsICcnXSwge1xuICAgICAgICAgIHNvdXJjZTogJ2NsZWFyJ1xuICAgICAgICB9KTtcbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIGRvVXBkYXRlVmFsdWUoJycsIHtcbiAgICAgICAgICBzb3VyY2U6ICdjbGVhcidcbiAgICAgICAgfSk7XG4gICAgICAgIGRvQ2hhbmdlKCcnLCB7XG4gICAgICAgICAgc291cmNlOiAnY2xlYXInXG4gICAgICAgIH0pO1xuICAgICAgfVxuICAgIH1cbiAgICBmdW5jdGlvbiBoYW5kbGVNb3VzZURvd24oZSkge1xuICAgICAgY29uc3Qge1xuICAgICAgICBvbk1vdXNlZG93blxuICAgICAgfSA9IHByb3BzO1xuICAgICAgaWYgKG9uTW91c2Vkb3duKSBvbk1vdXNlZG93bihlKTtcbiAgICAgIGNvbnN0IHtcbiAgICAgICAgdGFnTmFtZVxuICAgICAgfSA9IGUudGFyZ2V0O1xuICAgICAgaWYgKHRhZ05hbWUgIT09ICdJTlBVVCcgJiYgdGFnTmFtZSAhPT0gJ1RFWFRBUkVBJykge1xuICAgICAgICBpZiAocHJvcHMucmVzaXphYmxlKSB7XG4gICAgICAgICAgY29uc3Qge1xuICAgICAgICAgICAgdmFsdWU6IHdyYXBwZXJFbFxuICAgICAgICAgIH0gPSB3cmFwcGVyRWxSZWY7XG4gICAgICAgICAgaWYgKHdyYXBwZXJFbCkge1xuICAgICAgICAgICAgY29uc3Qge1xuICAgICAgICAgICAgICBsZWZ0LFxuICAgICAgICAgICAgICB0b3AsXG4gICAgICAgICAgICAgIHdpZHRoLFxuICAgICAgICAgICAgICBoZWlnaHRcbiAgICAgICAgICAgIH0gPSB3cmFwcGVyRWwuZ2V0Qm91bmRpbmdDbGllbnRSZWN0KCk7XG4gICAgICAgICAgICBjb25zdCByZXNpemVIYW5kbGVTaXplID0gMTQ7XG4gICAgICAgICAgICBpZiAobGVmdCArIHdpZHRoIC0gcmVzaXplSGFuZGxlU2l6ZSA8IGUuY2xpZW50WCAmJiBlLmNsaWVudFggPCBsZWZ0ICsgd2lkdGggJiYgdG9wICsgaGVpZ2h0IC0gcmVzaXplSGFuZGxlU2l6ZSA8IGUuY2xpZW50WSAmJiBlLmNsaWVudFkgPCB0b3AgKyBoZWlnaHQpIHtcbiAgICAgICAgICAgICAgLy8gdG91Y2hpbmcgcmVzaXplIGhhbmRsZSwganVzdCBsZXQgaXQgZ28uXG4gICAgICAgICAgICAgIC8vIHJlc2l6ZSB3b24ndCB0YWtlIGZvY3VzLCBtYXliZSB0aGVyZSBpcyBhIGJldHRlciB3YXkgdG8gZG8gdGhpcy5cbiAgICAgICAgICAgICAgLy8gaG9wZSBzb21lb25lIGNhbiBmaWd1cmUgb3V0IGEgYmV0dGVyIHNvbHV0aW9uXG4gICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgZS5wcmV2ZW50RGVmYXVsdCgpO1xuICAgICAgICBpZiAoIWZvY3VzZWRSZWYudmFsdWUpIHtcbiAgICAgICAgICBmb2N1cygpO1xuICAgICAgICB9XG4gICAgICB9XG4gICAgfVxuICAgIGZ1bmN0aW9uIGhhbmRsZU1vdXNlRW50ZXIoKSB7XG4gICAgICB2YXIgX2E7XG4gICAgICBob3ZlclJlZi52YWx1ZSA9IHRydWU7XG4gICAgICBpZiAocHJvcHMudHlwZSA9PT0gJ3RleHRhcmVhJykge1xuICAgICAgICAoX2EgPSB0ZXh0YXJlYVNjcm9sbGJhckluc3RSZWYudmFsdWUpID09PSBudWxsIHx8IF9hID09PSB2b2lkIDAgPyB2b2lkIDAgOiBfYS5oYW5kbGVNb3VzZUVudGVyV3JhcHBlcigpO1xuICAgICAgfVxuICAgIH1cbiAgICBmdW5jdGlvbiBoYW5kbGVNb3VzZUxlYXZlKCkge1xuICAgICAgdmFyIF9hO1xuICAgICAgaG92ZXJSZWYudmFsdWUgPSBmYWxzZTtcbiAgICAgIGlmIChwcm9wcy50eXBlID09PSAndGV4dGFyZWEnKSB7XG4gICAgICAgIChfYSA9IHRleHRhcmVhU2Nyb2xsYmFySW5zdFJlZi52YWx1ZSkgPT09IG51bGwgfHwgX2EgPT09IHZvaWQgMCA/IHZvaWQgMCA6IF9hLmhhbmRsZU1vdXNlTGVhdmVXcmFwcGVyKCk7XG4gICAgICB9XG4gICAgfVxuICAgIGZ1bmN0aW9uIGhhbmRsZVBhc3N3b3JkVG9nZ2xlQ2xpY2soKSB7XG4gICAgICBpZiAobWVyZ2VkRGlzYWJsZWRSZWYudmFsdWUpIHJldHVybjtcbiAgICAgIGlmIChtZXJnZWRTaG93UGFzc3dvcmRPblJlZi52YWx1ZSAhPT0gJ2NsaWNrJykgcmV0dXJuO1xuICAgICAgcGFzc3dvcmRWaXNpYmxlUmVmLnZhbHVlID0gIXBhc3N3b3JkVmlzaWJsZVJlZi52YWx1ZTtcbiAgICB9XG4gICAgZnVuY3Rpb24gaGFuZGxlUGFzc3dvcmRUb2dnbGVNb3VzZWRvd24oZSkge1xuICAgICAgaWYgKG1lcmdlZERpc2FibGVkUmVmLnZhbHVlKSByZXR1cm47XG4gICAgICBlLnByZXZlbnREZWZhdWx0KCk7XG4gICAgICBjb25zdCBwcmV2ZW50RGVmYXVsdE9uY2UgPSBlID0+IHtcbiAgICAgICAgZS5wcmV2ZW50RGVmYXVsdCgpO1xuICAgICAgICBvZmYoJ21vdXNldXAnLCBkb2N1bWVudCwgcHJldmVudERlZmF1bHRPbmNlKTtcbiAgICAgIH07XG4gICAgICBvbignbW91c2V1cCcsIGRvY3VtZW50LCBwcmV2ZW50RGVmYXVsdE9uY2UpO1xuICAgICAgaWYgKG1lcmdlZFNob3dQYXNzd29yZE9uUmVmLnZhbHVlICE9PSAnbW91c2Vkb3duJykgcmV0dXJuO1xuICAgICAgcGFzc3dvcmRWaXNpYmxlUmVmLnZhbHVlID0gdHJ1ZTtcbiAgICAgIGNvbnN0IGhpZGVQYXNzd29yZCA9ICgpID0+IHtcbiAgICAgICAgcGFzc3dvcmRWaXNpYmxlUmVmLnZhbHVlID0gZmFsc2U7XG4gICAgICAgIG9mZignbW91c2V1cCcsIGRvY3VtZW50LCBoaWRlUGFzc3dvcmQpO1xuICAgICAgfTtcbiAgICAgIG9uKCdtb3VzZXVwJywgZG9jdW1lbnQsIGhpZGVQYXNzd29yZCk7XG4gICAgfVxuICAgIGZ1bmN0aW9uIGhhbmRsZVdyYXBwZXJLZXl1cChlKSB7XG4gICAgICBpZiAocHJvcHMub25LZXl1cCkgY2FsbChwcm9wcy5vbktleXVwLCBlKTtcbiAgICB9XG4gICAgZnVuY3Rpb24gaGFuZGxlV3JhcHBlcktleWRvd24oZSkge1xuICAgICAgaWYgKHByb3BzLm9uS2V5ZG93bikgY2FsbChwcm9wcy5vbktleWRvd24sIGUpO1xuICAgICAgc3dpdGNoIChlLmtleSkge1xuICAgICAgICBjYXNlICdFc2NhcGUnOlxuICAgICAgICAgIGhhbmRsZVdyYXBwZXJLZXlkb3duRXNjKCk7XG4gICAgICAgICAgYnJlYWs7XG4gICAgICAgIGNhc2UgJ0VudGVyJzpcbiAgICAgICAgICBoYW5kbGVXcmFwcGVyS2V5ZG93bkVudGVyKGUpO1xuICAgICAgICAgIGJyZWFrO1xuICAgICAgfVxuICAgIH1cbiAgICBmdW5jdGlvbiBoYW5kbGVXcmFwcGVyS2V5ZG93bkVudGVyKGUpIHtcbiAgICAgIHZhciBfYSwgX2I7XG4gICAgICBpZiAocHJvcHMucGFzc2l2ZWx5QWN0aXZhdGVkKSB7XG4gICAgICAgIGNvbnN0IHtcbiAgICAgICAgICB2YWx1ZTogZm9jdXNlZFxuICAgICAgICB9ID0gYWN0aXZhdGVkUmVmO1xuICAgICAgICBpZiAoZm9jdXNlZCkge1xuICAgICAgICAgIGlmIChwcm9wcy5pbnRlcm5hbERlYWN0aXZhdGVPbkVudGVyKSB7XG4gICAgICAgICAgICBoYW5kbGVXcmFwcGVyS2V5ZG93bkVzYygpO1xuICAgICAgICAgIH1cbiAgICAgICAgICByZXR1cm47XG4gICAgICAgIH1cbiAgICAgICAgZS5wcmV2ZW50RGVmYXVsdCgpO1xuICAgICAgICBpZiAocHJvcHMudHlwZSA9PT0gJ3RleHRhcmVhJykge1xuICAgICAgICAgIChfYSA9IHRleHRhcmVhRWxSZWYudmFsdWUpID09PSBudWxsIHx8IF9hID09PSB2b2lkIDAgPyB2b2lkIDAgOiBfYS5mb2N1cygpO1xuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgIChfYiA9IGlucHV0RWxSZWYudmFsdWUpID09PSBudWxsIHx8IF9iID09PSB2b2lkIDAgPyB2b2lkIDAgOiBfYi5mb2N1cygpO1xuICAgICAgICB9XG4gICAgICB9XG4gICAgfVxuICAgIGZ1bmN0aW9uIGhhbmRsZVdyYXBwZXJLZXlkb3duRXNjKCkge1xuICAgICAgaWYgKHByb3BzLnBhc3NpdmVseUFjdGl2YXRlZCkge1xuICAgICAgICBhY3RpdmF0ZWRSZWYudmFsdWUgPSBmYWxzZTtcbiAgICAgICAgdm9pZCBuZXh0VGljaygoKSA9PiB7XG4gICAgICAgICAgdmFyIF9hO1xuICAgICAgICAgIChfYSA9IHdyYXBwZXJFbFJlZi52YWx1ZSkgPT09IG51bGwgfHwgX2EgPT09IHZvaWQgMCA/IHZvaWQgMCA6IF9hLmZvY3VzKCk7XG4gICAgICAgIH0pO1xuICAgICAgfVxuICAgIH1cbiAgICBmdW5jdGlvbiBmb2N1cygpIHtcbiAgICAgIHZhciBfYSwgX2IsIF9jO1xuICAgICAgaWYgKG1lcmdlZERpc2FibGVkUmVmLnZhbHVlKSByZXR1cm47XG4gICAgICBpZiAocHJvcHMucGFzc2l2ZWx5QWN0aXZhdGVkKSB7XG4gICAgICAgIChfYSA9IHdyYXBwZXJFbFJlZi52YWx1ZSkgPT09IG51bGwgfHwgX2EgPT09IHZvaWQgMCA/IHZvaWQgMCA6IF9hLmZvY3VzKCk7XG4gICAgICB9IGVsc2Uge1xuICAgICAgICAoX2IgPSB0ZXh0YXJlYUVsUmVmLnZhbHVlKSA9PT0gbnVsbCB8fCBfYiA9PT0gdm9pZCAwID8gdm9pZCAwIDogX2IuZm9jdXMoKTtcbiAgICAgICAgKF9jID0gaW5wdXRFbFJlZi52YWx1ZSkgPT09IG51bGwgfHwgX2MgPT09IHZvaWQgMCA/IHZvaWQgMCA6IF9jLmZvY3VzKCk7XG4gICAgICB9XG4gICAgfVxuICAgIGZ1bmN0aW9uIGJsdXIoKSB7XG4gICAgICB2YXIgX2E7XG4gICAgICBpZiAoKF9hID0gd3JhcHBlckVsUmVmLnZhbHVlKSA9PT0gbnVsbCB8fCBfYSA9PT0gdm9pZCAwID8gdm9pZCAwIDogX2EuY29udGFpbnMoZG9jdW1lbnQuYWN0aXZlRWxlbWVudCkpIHtcbiAgICAgICAgO1xuICAgICAgICBkb2N1bWVudC5hY3RpdmVFbGVtZW50LmJsdXIoKTtcbiAgICAgIH1cbiAgICB9XG4gICAgZnVuY3Rpb24gc2VsZWN0KCkge1xuICAgICAgdmFyIF9hLCBfYjtcbiAgICAgIChfYSA9IHRleHRhcmVhRWxSZWYudmFsdWUpID09PSBudWxsIHx8IF9hID09PSB2b2lkIDAgPyB2b2lkIDAgOiBfYS5zZWxlY3QoKTtcbiAgICAgIChfYiA9IGlucHV0RWxSZWYudmFsdWUpID09PSBudWxsIHx8IF9iID09PSB2b2lkIDAgPyB2b2lkIDAgOiBfYi5zZWxlY3QoKTtcbiAgICB9XG4gICAgZnVuY3Rpb24gYWN0aXZhdGUoKSB7XG4gICAgICBpZiAobWVyZ2VkRGlzYWJsZWRSZWYudmFsdWUpIHJldHVybjtcbiAgICAgIGlmICh0ZXh0YXJlYUVsUmVmLnZhbHVlKSB0ZXh0YXJlYUVsUmVmLnZhbHVlLmZvY3VzKCk7ZWxzZSBpZiAoaW5wdXRFbFJlZi52YWx1ZSkgaW5wdXRFbFJlZi52YWx1ZS5mb2N1cygpO1xuICAgIH1cbiAgICBmdW5jdGlvbiBkZWFjdGl2YXRlKCkge1xuICAgICAgY29uc3Qge1xuICAgICAgICB2YWx1ZTogd3JhcHBlckVsXG4gICAgICB9ID0gd3JhcHBlckVsUmVmO1xuICAgICAgaWYgKCh3cmFwcGVyRWwgPT09IG51bGwgfHwgd3JhcHBlckVsID09PSB2b2lkIDAgPyB2b2lkIDAgOiB3cmFwcGVyRWwuY29udGFpbnMoZG9jdW1lbnQuYWN0aXZlRWxlbWVudCkpICYmIHdyYXBwZXJFbCAhPT0gZG9jdW1lbnQuYWN0aXZlRWxlbWVudCkge1xuICAgICAgICBoYW5kbGVXcmFwcGVyS2V5ZG93bkVzYygpO1xuICAgICAgfVxuICAgIH1cbiAgICBmdW5jdGlvbiBzY3JvbGxUbyhvcHRpb25zKSB7XG4gICAgICBpZiAocHJvcHMudHlwZSA9PT0gJ3RleHRhcmVhJykge1xuICAgICAgICBjb25zdCB7XG4gICAgICAgICAgdmFsdWU6IHRleHRhcmVhRWxcbiAgICAgICAgfSA9IHRleHRhcmVhRWxSZWY7XG4gICAgICAgIHRleHRhcmVhRWwgPT09IG51bGwgfHwgdGV4dGFyZWFFbCA9PT0gdm9pZCAwID8gdm9pZCAwIDogdGV4dGFyZWFFbC5zY3JvbGxUbyhvcHRpb25zKTtcbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIGNvbnN0IHtcbiAgICAgICAgICB2YWx1ZTogaW5wdXRFbFxuICAgICAgICB9ID0gaW5wdXRFbFJlZjtcbiAgICAgICAgaW5wdXRFbCA9PT0gbnVsbCB8fCBpbnB1dEVsID09PSB2b2lkIDAgPyB2b2lkIDAgOiBpbnB1dEVsLnNjcm9sbFRvKG9wdGlvbnMpO1xuICAgICAgfVxuICAgIH1cbiAgICBmdW5jdGlvbiBzeW5jTWlycm9yKHZhbHVlKSB7XG4gICAgICBjb25zdCB7XG4gICAgICAgIHR5cGUsXG4gICAgICAgIHBhaXIsXG4gICAgICAgIGF1dG9zaXplXG4gICAgICB9ID0gcHJvcHM7XG4gICAgICBpZiAoIXBhaXIgJiYgYXV0b3NpemUpIHtcbiAgICAgICAgaWYgKHR5cGUgPT09ICd0ZXh0YXJlYScpIHtcbiAgICAgICAgICBjb25zdCB7XG4gICAgICAgICAgICB2YWx1ZTogdGV4dGFyZWFNaXJyb3JFbFxuICAgICAgICAgIH0gPSB0ZXh0YXJlYU1pcnJvckVsUmVmO1xuICAgICAgICAgIGlmICh0ZXh0YXJlYU1pcnJvckVsKSB7XG4gICAgICAgICAgICB0ZXh0YXJlYU1pcnJvckVsLnRleHRDb250ZW50ID0gYCR7dmFsdWUgIT09IG51bGwgJiYgdmFsdWUgIT09IHZvaWQgMCA/IHZhbHVlIDogJyd9XFxyXFxuYDtcbiAgICAgICAgICB9XG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgY29uc3Qge1xuICAgICAgICAgICAgdmFsdWU6IGlucHV0TWlycm9yRWxcbiAgICAgICAgICB9ID0gaW5wdXRNaXJyb3JFbFJlZjtcbiAgICAgICAgICBpZiAoaW5wdXRNaXJyb3JFbCkge1xuICAgICAgICAgICAgaWYgKHZhbHVlKSB7XG4gICAgICAgICAgICAgIGlucHV0TWlycm9yRWwudGV4dENvbnRlbnQgPSB2YWx1ZTtcbiAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgIGlucHV0TWlycm9yRWwuaW5uZXJIVE1MID0gJyZuYnNwOyc7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICB9XG4gICAgfVxuICAgIGZ1bmN0aW9uIGhhbmRsZVRleHRBcmVhTWlycm9yUmVzaXplKCkge1xuICAgICAgdXBkYXRlVGV4dEFyZWFTdHlsZSgpO1xuICAgIH1cbiAgICBjb25zdCBwbGFjZWhvbGRlclN0eWxlUmVmID0gcmVmKHtcbiAgICAgIHRvcDogJzAnXG4gICAgfSk7XG4gICAgZnVuY3Rpb24gaGFuZGxlVGV4dEFyZWFTY3JvbGwoZSkge1xuICAgICAgdmFyIF9hO1xuICAgICAgY29uc3Qge1xuICAgICAgICBzY3JvbGxUb3BcbiAgICAgIH0gPSBlLnRhcmdldDtcbiAgICAgIHBsYWNlaG9sZGVyU3R5bGVSZWYudmFsdWUudG9wID0gYCR7LXNjcm9sbFRvcH1weGA7XG4gICAgICAoX2EgPSB0ZXh0YXJlYVNjcm9sbGJhckluc3RSZWYudmFsdWUpID09PSBudWxsIHx8IF9hID09PSB2b2lkIDAgPyB2b2lkIDAgOiBfYS5zeW5jVW5pZmllZENvbnRhaW5lcigpO1xuICAgIH1cbiAgICBsZXQgc3RvcFdhdGNoTWVyZ2VkVmFsdWUxID0gbnVsbDtcbiAgICB3YXRjaEVmZmVjdCgoKSA9PiB7XG4gICAgICBjb25zdCB7XG4gICAgICAgIGF1dG9zaXplLFxuICAgICAgICB0eXBlXG4gICAgICB9ID0gcHJvcHM7XG4gICAgICBpZiAoYXV0b3NpemUgJiYgdHlwZSA9PT0gJ3RleHRhcmVhJykge1xuICAgICAgICBzdG9wV2F0Y2hNZXJnZWRWYWx1ZTEgPSB3YXRjaChtZXJnZWRWYWx1ZVJlZiwgdmFsdWUgPT4ge1xuICAgICAgICAgIGlmICghQXJyYXkuaXNBcnJheSh2YWx1ZSkgJiYgdmFsdWUgIT09IHN5bmNTb3VyY2UpIHtcbiAgICAgICAgICAgIHN5bmNNaXJyb3IodmFsdWUpO1xuICAgICAgICAgIH1cbiAgICAgICAgfSk7XG4gICAgICB9IGVsc2Uge1xuICAgICAgICBzdG9wV2F0Y2hNZXJnZWRWYWx1ZTEgPT09IG51bGwgfHwgc3RvcFdhdGNoTWVyZ2VkVmFsdWUxID09PSB2b2lkIDAgPyB2b2lkIDAgOiBzdG9wV2F0Y2hNZXJnZWRWYWx1ZTEoKTtcbiAgICAgIH1cbiAgICB9KTtcbiAgICBsZXQgc3RvcFdhdGNoTWVyZ2VkVmFsdWUyID0gbnVsbDtcbiAgICB3YXRjaEVmZmVjdCgoKSA9PiB7XG4gICAgICBpZiAocHJvcHMudHlwZSA9PT0gJ3RleHRhcmVhJykge1xuICAgICAgICBzdG9wV2F0Y2hNZXJnZWRWYWx1ZTIgPSB3YXRjaChtZXJnZWRWYWx1ZVJlZiwgdmFsdWUgPT4ge1xuICAgICAgICAgIHZhciBfYTtcbiAgICAgICAgICBpZiAoIUFycmF5LmlzQXJyYXkodmFsdWUpICYmIHZhbHVlICE9PSBzeW5jU291cmNlKSB7XG4gICAgICAgICAgICAoX2EgPSB0ZXh0YXJlYVNjcm9sbGJhckluc3RSZWYudmFsdWUpID09PSBudWxsIHx8IF9hID09PSB2b2lkIDAgPyB2b2lkIDAgOiBfYS5zeW5jVW5pZmllZENvbnRhaW5lcigpO1xuICAgICAgICAgIH1cbiAgICAgICAgfSk7XG4gICAgICB9IGVsc2Uge1xuICAgICAgICBzdG9wV2F0Y2hNZXJnZWRWYWx1ZTIgPT09IG51bGwgfHwgc3RvcFdhdGNoTWVyZ2VkVmFsdWUyID09PSB2b2lkIDAgPyB2b2lkIDAgOiBzdG9wV2F0Y2hNZXJnZWRWYWx1ZTIoKTtcbiAgICAgIH1cbiAgICB9KTtcbiAgICBwcm92aWRlKGlucHV0SW5qZWN0aW9uS2V5LCB7XG4gICAgICBtZXJnZWRWYWx1ZVJlZixcbiAgICAgIG1heGxlbmd0aFJlZixcbiAgICAgIG1lcmdlZENsc1ByZWZpeFJlZixcbiAgICAgIGNvdW50R3JhcGhlbWVzUmVmOiB0b1JlZihwcm9wcywgJ2NvdW50R3JhcGhlbWVzJylcbiAgICB9KTtcbiAgICBjb25zdCBleHBvc2VkUHJvcHMgPSB7XG4gICAgICB3cmFwcGVyRWxSZWYsXG4gICAgICBpbnB1dEVsUmVmLFxuICAgICAgdGV4dGFyZWFFbFJlZixcbiAgICAgIGlzQ29tcG9zaXRpbmc6IGlzQ29tcG9zaW5nUmVmLFxuICAgICAgY2xlYXI6IGNsZWFyVmFsdWUsXG4gICAgICBmb2N1cyxcbiAgICAgIGJsdXIsXG4gICAgICBzZWxlY3QsXG4gICAgICBkZWFjdGl2YXRlLFxuICAgICAgYWN0aXZhdGUsXG4gICAgICBzY3JvbGxUb1xuICAgIH07XG4gICAgY29uc3QgcnRsRW5hYmxlZFJlZiA9IHVzZVJ0bCgnSW5wdXQnLCBtZXJnZWRSdGxSZWYsIG1lcmdlZENsc1ByZWZpeFJlZik7XG4gICAgY29uc3QgY3NzVmFyc1JlZiA9IGNvbXB1dGVkKCgpID0+IHtcbiAgICAgIGNvbnN0IHtcbiAgICAgICAgdmFsdWU6IHNpemVcbiAgICAgIH0gPSBtZXJnZWRTaXplUmVmO1xuICAgICAgY29uc3Qge1xuICAgICAgICBjb21tb246IHtcbiAgICAgICAgICBjdWJpY0JlemllckVhc2VJbk91dFxuICAgICAgICB9LFxuICAgICAgICBzZWxmOiB7XG4gICAgICAgICAgY29sb3IsXG4gICAgICAgICAgYm9yZGVyUmFkaXVzLFxuICAgICAgICAgIHRleHRDb2xvcixcbiAgICAgICAgICBjYXJldENvbG9yLFxuICAgICAgICAgIGNhcmV0Q29sb3JFcnJvcixcbiAgICAgICAgICBjYXJldENvbG9yV2FybmluZyxcbiAgICAgICAgICB0ZXh0RGVjb3JhdGlvbkNvbG9yLFxuICAgICAgICAgIGJvcmRlcixcbiAgICAgICAgICBib3JkZXJEaXNhYmxlZCxcbiAgICAgICAgICBib3JkZXJIb3ZlcixcbiAgICAgICAgICBib3JkZXJGb2N1cyxcbiAgICAgICAgICBwbGFjZWhvbGRlckNvbG9yLFxuICAgICAgICAgIHBsYWNlaG9sZGVyQ29sb3JEaXNhYmxlZCxcbiAgICAgICAgICBsaW5lSGVpZ2h0VGV4dGFyZWEsXG4gICAgICAgICAgY29sb3JEaXNhYmxlZCxcbiAgICAgICAgICBjb2xvckZvY3VzLFxuICAgICAgICAgIHRleHRDb2xvckRpc2FibGVkLFxuICAgICAgICAgIGJveFNoYWRvd0ZvY3VzLFxuICAgICAgICAgIGljb25TaXplLFxuICAgICAgICAgIGNvbG9yRm9jdXNXYXJuaW5nLFxuICAgICAgICAgIGJveFNoYWRvd0ZvY3VzV2FybmluZyxcbiAgICAgICAgICBib3JkZXJXYXJuaW5nLFxuICAgICAgICAgIGJvcmRlckZvY3VzV2FybmluZyxcbiAgICAgICAgICBib3JkZXJIb3Zlcldhcm5pbmcsXG4gICAgICAgICAgY29sb3JGb2N1c0Vycm9yLFxuICAgICAgICAgIGJveFNoYWRvd0ZvY3VzRXJyb3IsXG4gICAgICAgICAgYm9yZGVyRXJyb3IsXG4gICAgICAgICAgYm9yZGVyRm9jdXNFcnJvcixcbiAgICAgICAgICBib3JkZXJIb3ZlckVycm9yLFxuICAgICAgICAgIGNsZWFyU2l6ZSxcbiAgICAgICAgICBjbGVhckNvbG9yLFxuICAgICAgICAgIGNsZWFyQ29sb3JIb3ZlcixcbiAgICAgICAgICBjbGVhckNvbG9yUHJlc3NlZCxcbiAgICAgICAgICBpY29uQ29sb3IsXG4gICAgICAgICAgaWNvbkNvbG9yRGlzYWJsZWQsXG4gICAgICAgICAgc3VmZml4VGV4dENvbG9yLFxuICAgICAgICAgIGNvdW50VGV4dENvbG9yLFxuICAgICAgICAgIGNvdW50VGV4dENvbG9yRGlzYWJsZWQsXG4gICAgICAgICAgaWNvbkNvbG9ySG92ZXIsXG4gICAgICAgICAgaWNvbkNvbG9yUHJlc3NlZCxcbiAgICAgICAgICBsb2FkaW5nQ29sb3IsXG4gICAgICAgICAgbG9hZGluZ0NvbG9yRXJyb3IsXG4gICAgICAgICAgbG9hZGluZ0NvbG9yV2FybmluZyxcbiAgICAgICAgICBbY3JlYXRlS2V5KCdwYWRkaW5nJywgc2l6ZSldOiBwYWRkaW5nLFxuICAgICAgICAgIFtjcmVhdGVLZXkoJ2ZvbnRTaXplJywgc2l6ZSldOiBmb250U2l6ZSxcbiAgICAgICAgICBbY3JlYXRlS2V5KCdoZWlnaHQnLCBzaXplKV06IGhlaWdodFxuICAgICAgICB9XG4gICAgICB9ID0gdGhlbWVSZWYudmFsdWU7XG4gICAgICBjb25zdCB7XG4gICAgICAgIGxlZnQ6IHBhZGRpbmdMZWZ0LFxuICAgICAgICByaWdodDogcGFkZGluZ1JpZ2h0XG4gICAgICB9ID0gZ2V0UGFkZGluZyhwYWRkaW5nKTtcbiAgICAgIHJldHVybiB7XG4gICAgICAgICctLW4tYmV6aWVyJzogY3ViaWNCZXppZXJFYXNlSW5PdXQsXG4gICAgICAgICctLW4tY291bnQtdGV4dC1jb2xvcic6IGNvdW50VGV4dENvbG9yLFxuICAgICAgICAnLS1uLWNvdW50LXRleHQtY29sb3ItZGlzYWJsZWQnOiBjb3VudFRleHRDb2xvckRpc2FibGVkLFxuICAgICAgICAnLS1uLWNvbG9yJzogY29sb3IsXG4gICAgICAgICctLW4tZm9udC1zaXplJzogZm9udFNpemUsXG4gICAgICAgICctLW4tYm9yZGVyLXJhZGl1cyc6IGJvcmRlclJhZGl1cyxcbiAgICAgICAgJy0tbi1oZWlnaHQnOiBoZWlnaHQsXG4gICAgICAgICctLW4tcGFkZGluZy1sZWZ0JzogcGFkZGluZ0xlZnQsXG4gICAgICAgICctLW4tcGFkZGluZy1yaWdodCc6IHBhZGRpbmdSaWdodCxcbiAgICAgICAgJy0tbi10ZXh0LWNvbG9yJzogdGV4dENvbG9yLFxuICAgICAgICAnLS1uLWNhcmV0LWNvbG9yJzogY2FyZXRDb2xvcixcbiAgICAgICAgJy0tbi10ZXh0LWRlY29yYXRpb24tY29sb3InOiB0ZXh0RGVjb3JhdGlvbkNvbG9yLFxuICAgICAgICAnLS1uLWJvcmRlcic6IGJvcmRlcixcbiAgICAgICAgJy0tbi1ib3JkZXItZGlzYWJsZWQnOiBib3JkZXJEaXNhYmxlZCxcbiAgICAgICAgJy0tbi1ib3JkZXItaG92ZXInOiBib3JkZXJIb3ZlcixcbiAgICAgICAgJy0tbi1ib3JkZXItZm9jdXMnOiBib3JkZXJGb2N1cyxcbiAgICAgICAgJy0tbi1wbGFjZWhvbGRlci1jb2xvcic6IHBsYWNlaG9sZGVyQ29sb3IsXG4gICAgICAgICctLW4tcGxhY2Vob2xkZXItY29sb3ItZGlzYWJsZWQnOiBwbGFjZWhvbGRlckNvbG9yRGlzYWJsZWQsXG4gICAgICAgICctLW4taWNvbi1zaXplJzogaWNvblNpemUsXG4gICAgICAgICctLW4tbGluZS1oZWlnaHQtdGV4dGFyZWEnOiBsaW5lSGVpZ2h0VGV4dGFyZWEsXG4gICAgICAgICctLW4tY29sb3ItZGlzYWJsZWQnOiBjb2xvckRpc2FibGVkLFxuICAgICAgICAnLS1uLWNvbG9yLWZvY3VzJzogY29sb3JGb2N1cyxcbiAgICAgICAgJy0tbi10ZXh0LWNvbG9yLWRpc2FibGVkJzogdGV4dENvbG9yRGlzYWJsZWQsXG4gICAgICAgICctLW4tYm94LXNoYWRvdy1mb2N1cyc6IGJveFNoYWRvd0ZvY3VzLFxuICAgICAgICAnLS1uLWxvYWRpbmctY29sb3InOiBsb2FkaW5nQ29sb3IsXG4gICAgICAgIC8vIGZvcm0gd2FybmluZ1xuICAgICAgICAnLS1uLWNhcmV0LWNvbG9yLXdhcm5pbmcnOiBjYXJldENvbG9yV2FybmluZyxcbiAgICAgICAgJy0tbi1jb2xvci1mb2N1cy13YXJuaW5nJzogY29sb3JGb2N1c1dhcm5pbmcsXG4gICAgICAgICctLW4tYm94LXNoYWRvdy1mb2N1cy13YXJuaW5nJzogYm94U2hhZG93Rm9jdXNXYXJuaW5nLFxuICAgICAgICAnLS1uLWJvcmRlci13YXJuaW5nJzogYm9yZGVyV2FybmluZyxcbiAgICAgICAgJy0tbi1ib3JkZXItZm9jdXMtd2FybmluZyc6IGJvcmRlckZvY3VzV2FybmluZyxcbiAgICAgICAgJy0tbi1ib3JkZXItaG92ZXItd2FybmluZyc6IGJvcmRlckhvdmVyV2FybmluZyxcbiAgICAgICAgJy0tbi1sb2FkaW5nLWNvbG9yLXdhcm5pbmcnOiBsb2FkaW5nQ29sb3JXYXJuaW5nLFxuICAgICAgICAvLyBmb3JtIGVycm9yXG4gICAgICAgICctLW4tY2FyZXQtY29sb3ItZXJyb3InOiBjYXJldENvbG9yRXJyb3IsXG4gICAgICAgICctLW4tY29sb3ItZm9jdXMtZXJyb3InOiBjb2xvckZvY3VzRXJyb3IsXG4gICAgICAgICctLW4tYm94LXNoYWRvdy1mb2N1cy1lcnJvcic6IGJveFNoYWRvd0ZvY3VzRXJyb3IsXG4gICAgICAgICctLW4tYm9yZGVyLWVycm9yJzogYm9yZGVyRXJyb3IsXG4gICAgICAgICctLW4tYm9yZGVyLWZvY3VzLWVycm9yJzogYm9yZGVyRm9jdXNFcnJvcixcbiAgICAgICAgJy0tbi1ib3JkZXItaG92ZXItZXJyb3InOiBib3JkZXJIb3ZlckVycm9yLFxuICAgICAgICAnLS1uLWxvYWRpbmctY29sb3ItZXJyb3InOiBsb2FkaW5nQ29sb3JFcnJvcixcbiAgICAgICAgLy8gY2xlYXItYnV0dG9uXG4gICAgICAgICctLW4tY2xlYXItY29sb3InOiBjbGVhckNvbG9yLFxuICAgICAgICAnLS1uLWNsZWFyLXNpemUnOiBjbGVhclNpemUsXG4gICAgICAgICctLW4tY2xlYXItY29sb3ItaG92ZXInOiBjbGVhckNvbG9ySG92ZXIsXG4gICAgICAgICctLW4tY2xlYXItY29sb3ItcHJlc3NlZCc6IGNsZWFyQ29sb3JQcmVzc2VkLFxuICAgICAgICAnLS1uLWljb24tY29sb3InOiBpY29uQ29sb3IsXG4gICAgICAgICctLW4taWNvbi1jb2xvci1ob3Zlcic6IGljb25Db2xvckhvdmVyLFxuICAgICAgICAnLS1uLWljb24tY29sb3ItcHJlc3NlZCc6IGljb25Db2xvclByZXNzZWQsXG4gICAgICAgICctLW4taWNvbi1jb2xvci1kaXNhYmxlZCc6IGljb25Db2xvckRpc2FibGVkLFxuICAgICAgICAnLS1uLXN1ZmZpeC10ZXh0LWNvbG9yJzogc3VmZml4VGV4dENvbG9yXG4gICAgICB9O1xuICAgIH0pO1xuICAgIGNvbnN0IHRoZW1lQ2xhc3NIYW5kbGUgPSBpbmxpbmVUaGVtZURpc2FibGVkID8gdXNlVGhlbWVDbGFzcygnaW5wdXQnLCBjb21wdXRlZCgoKSA9PiB7XG4gICAgICBjb25zdCB7XG4gICAgICAgIHZhbHVlOiBzaXplXG4gICAgICB9ID0gbWVyZ2VkU2l6ZVJlZjtcbiAgICAgIHJldHVybiBzaXplWzBdO1xuICAgIH0pLCBjc3NWYXJzUmVmLCBwcm9wcykgOiB1bmRlZmluZWQ7XG4gICAgcmV0dXJuIE9iamVjdC5hc3NpZ24oT2JqZWN0LmFzc2lnbih7fSwgZXhwb3NlZFByb3BzKSwge1xuICAgICAgLy8gRE9NIHJlZlxuICAgICAgd3JhcHBlckVsUmVmLFxuICAgICAgaW5wdXRFbFJlZixcbiAgICAgIGlucHV0TWlycm9yRWxSZWYsXG4gICAgICBpbnB1dEVsMlJlZixcbiAgICAgIHRleHRhcmVhRWxSZWYsXG4gICAgICB0ZXh0YXJlYU1pcnJvckVsUmVmLFxuICAgICAgdGV4dGFyZWFTY3JvbGxiYXJJbnN0UmVmLFxuICAgICAgLy8gdmFsdWVcbiAgICAgIHJ0bEVuYWJsZWQ6IHJ0bEVuYWJsZWRSZWYsXG4gICAgICB1bmNvbnRyb2xsZWRWYWx1ZTogdW5jb250cm9sbGVkVmFsdWVSZWYsXG4gICAgICBtZXJnZWRWYWx1ZTogbWVyZ2VkVmFsdWVSZWYsXG4gICAgICBwYXNzd29yZFZpc2libGU6IHBhc3N3b3JkVmlzaWJsZVJlZixcbiAgICAgIG1lcmdlZFBsYWNlaG9sZGVyOiBtZXJnZWRQbGFjZWhvbGRlclJlZixcbiAgICAgIHNob3dQbGFjZWhvbGRlcjE6IHNob3dQbGFjZWhvbGRlcjFSZWYsXG4gICAgICBzaG93UGxhY2Vob2xkZXIyOiBzaG93UGxhY2Vob2xkZXIyUmVmLFxuICAgICAgbWVyZ2VkRm9jdXM6IG1lcmdlZEZvY3VzUmVmLFxuICAgICAgaXNDb21wb3Npbmc6IGlzQ29tcG9zaW5nUmVmLFxuICAgICAgYWN0aXZhdGVkOiBhY3RpdmF0ZWRSZWYsXG4gICAgICBzaG93Q2xlYXJCdXR0b24sXG4gICAgICBtZXJnZWRTaXplOiBtZXJnZWRTaXplUmVmLFxuICAgICAgbWVyZ2VkRGlzYWJsZWQ6IG1lcmdlZERpc2FibGVkUmVmLFxuICAgICAgdGV4dERlY29yYXRpb25TdHlsZTogdGV4dERlY29yYXRpb25TdHlsZVJlZixcbiAgICAgIG1lcmdlZENsc1ByZWZpeDogbWVyZ2VkQ2xzUHJlZml4UmVmLFxuICAgICAgbWVyZ2VkQm9yZGVyZWQ6IG1lcmdlZEJvcmRlcmVkUmVmLFxuICAgICAgbWVyZ2VkU2hvd1Bhc3N3b3JkT246IG1lcmdlZFNob3dQYXNzd29yZE9uUmVmLFxuICAgICAgcGxhY2Vob2xkZXJTdHlsZTogcGxhY2Vob2xkZXJTdHlsZVJlZixcbiAgICAgIG1lcmdlZFN0YXR1czogbWVyZ2VkU3RhdHVzUmVmLFxuICAgICAgdGV4dEFyZWFTY3JvbGxDb250YWluZXJXaWR0aDogdGV4dEFyZWFTY3JvbGxDb250YWluZXJXaWR0aFJlZixcbiAgICAgIC8vIG1ldGhvZHNcbiAgICAgIGhhbmRsZVRleHRBcmVhU2Nyb2xsLFxuICAgICAgaGFuZGxlQ29tcG9zaXRpb25TdGFydCxcbiAgICAgIGhhbmRsZUNvbXBvc2l0aW9uRW5kLFxuICAgICAgaGFuZGxlSW5wdXQsXG4gICAgICBoYW5kbGVJbnB1dEJsdXIsXG4gICAgICBoYW5kbGVJbnB1dEZvY3VzLFxuICAgICAgaGFuZGxlV3JhcHBlckJsdXIsXG4gICAgICBoYW5kbGVXcmFwcGVyRm9jdXMsXG4gICAgICBoYW5kbGVNb3VzZUVudGVyLFxuICAgICAgaGFuZGxlTW91c2VMZWF2ZSxcbiAgICAgIGhhbmRsZU1vdXNlRG93bixcbiAgICAgIGhhbmRsZUNoYW5nZSxcbiAgICAgIGhhbmRsZUNsaWNrLFxuICAgICAgaGFuZGxlQ2xlYXIsXG4gICAgICBoYW5kbGVQYXNzd29yZFRvZ2dsZUNsaWNrLFxuICAgICAgaGFuZGxlUGFzc3dvcmRUb2dnbGVNb3VzZWRvd24sXG4gICAgICBoYW5kbGVXcmFwcGVyS2V5ZG93bixcbiAgICAgIGhhbmRsZVdyYXBwZXJLZXl1cCxcbiAgICAgIGhhbmRsZVRleHRBcmVhTWlycm9yUmVzaXplLFxuICAgICAgZ2V0VGV4dGFyZWFTY3JvbGxDb250YWluZXI6ICgpID0+IHtcbiAgICAgICAgcmV0dXJuIHRleHRhcmVhRWxSZWYudmFsdWU7XG4gICAgICB9LFxuICAgICAgbWVyZ2VkVGhlbWU6IHRoZW1lUmVmLFxuICAgICAgY3NzVmFyczogaW5saW5lVGhlbWVEaXNhYmxlZCA/IHVuZGVmaW5lZCA6IGNzc1ZhcnNSZWYsXG4gICAgICB0aGVtZUNsYXNzOiB0aGVtZUNsYXNzSGFuZGxlID09PSBudWxsIHx8IHRoZW1lQ2xhc3NIYW5kbGUgPT09IHZvaWQgMCA/IHZvaWQgMCA6IHRoZW1lQ2xhc3NIYW5kbGUudGhlbWVDbGFzcyxcbiAgICAgIG9uUmVuZGVyOiB0aGVtZUNsYXNzSGFuZGxlID09PSBudWxsIHx8IHRoZW1lQ2xhc3NIYW5kbGUgPT09IHZvaWQgMCA/IHZvaWQgMCA6IHRoZW1lQ2xhc3NIYW5kbGUub25SZW5kZXJcbiAgICB9KTtcbiAgfSxcbiAgcmVuZGVyKCkge1xuICAgIHZhciBfYSwgX2I7XG4gICAgY29uc3Qge1xuICAgICAgbWVyZ2VkQ2xzUHJlZml4LFxuICAgICAgbWVyZ2VkU3RhdHVzLFxuICAgICAgdGhlbWVDbGFzcyxcbiAgICAgIHR5cGUsXG4gICAgICBjb3VudEdyYXBoZW1lcyxcbiAgICAgIG9uUmVuZGVyXG4gICAgfSA9IHRoaXM7XG4gICAgY29uc3QgJHNsb3RzID0gdGhpcy4kc2xvdHM7XG4gICAgb25SZW5kZXIgPT09IG51bGwgfHwgb25SZW5kZXIgPT09IHZvaWQgMCA/IHZvaWQgMCA6IG9uUmVuZGVyKCk7XG4gICAgcmV0dXJuIGgoXCJkaXZcIiwge1xuICAgICAgcmVmOiBcIndyYXBwZXJFbFJlZlwiLFxuICAgICAgY2xhc3M6IFtgJHttZXJnZWRDbHNQcmVmaXh9LWlucHV0YCwgdGhlbWVDbGFzcywgbWVyZ2VkU3RhdHVzICYmIGAke21lcmdlZENsc1ByZWZpeH0taW5wdXQtLSR7bWVyZ2VkU3RhdHVzfS1zdGF0dXNgLCB7XG4gICAgICAgIFtgJHttZXJnZWRDbHNQcmVmaXh9LWlucHV0LS1ydGxgXTogdGhpcy5ydGxFbmFibGVkLFxuICAgICAgICBbYCR7bWVyZ2VkQ2xzUHJlZml4fS1pbnB1dC0tZGlzYWJsZWRgXTogdGhpcy5tZXJnZWREaXNhYmxlZCxcbiAgICAgICAgW2Ake21lcmdlZENsc1ByZWZpeH0taW5wdXQtLXRleHRhcmVhYF06IHR5cGUgPT09ICd0ZXh0YXJlYScsXG4gICAgICAgIFtgJHttZXJnZWRDbHNQcmVmaXh9LWlucHV0LS1yZXNpemFibGVgXTogdGhpcy5yZXNpemFibGUgJiYgIXRoaXMuYXV0b3NpemUsXG4gICAgICAgIFtgJHttZXJnZWRDbHNQcmVmaXh9LWlucHV0LS1hdXRvc2l6ZWBdOiB0aGlzLmF1dG9zaXplLFxuICAgICAgICBbYCR7bWVyZ2VkQ2xzUHJlZml4fS1pbnB1dC0tcm91bmRgXTogdGhpcy5yb3VuZCAmJiAhKHR5cGUgPT09ICd0ZXh0YXJlYScpLFxuICAgICAgICBbYCR7bWVyZ2VkQ2xzUHJlZml4fS1pbnB1dC0tcGFpcmBdOiB0aGlzLnBhaXIsXG4gICAgICAgIFtgJHttZXJnZWRDbHNQcmVmaXh9LWlucHV0LS1mb2N1c2BdOiB0aGlzLm1lcmdlZEZvY3VzLFxuICAgICAgICBbYCR7bWVyZ2VkQ2xzUHJlZml4fS1pbnB1dC0tc3RhdGVmdWxgXTogdGhpcy5zdGF0ZWZ1bFxuICAgICAgfV0sXG4gICAgICBzdHlsZTogdGhpcy5jc3NWYXJzLFxuICAgICAgdGFiaW5kZXg6ICF0aGlzLm1lcmdlZERpc2FibGVkICYmIHRoaXMucGFzc2l2ZWx5QWN0aXZhdGVkICYmICF0aGlzLmFjdGl2YXRlZCA/IDAgOiB1bmRlZmluZWQsXG4gICAgICBvbkZvY3VzOiB0aGlzLmhhbmRsZVdyYXBwZXJGb2N1cyxcbiAgICAgIG9uQmx1cjogdGhpcy5oYW5kbGVXcmFwcGVyQmx1cixcbiAgICAgIG9uQ2xpY2s6IHRoaXMuaGFuZGxlQ2xpY2ssXG4gICAgICBvbk1vdXNlZG93bjogdGhpcy5oYW5kbGVNb3VzZURvd24sXG4gICAgICBvbk1vdXNlZW50ZXI6IHRoaXMuaGFuZGxlTW91c2VFbnRlcixcbiAgICAgIG9uTW91c2VsZWF2ZTogdGhpcy5oYW5kbGVNb3VzZUxlYXZlLFxuICAgICAgb25Db21wb3NpdGlvbnN0YXJ0OiB0aGlzLmhhbmRsZUNvbXBvc2l0aW9uU3RhcnQsXG4gICAgICBvbkNvbXBvc2l0aW9uZW5kOiB0aGlzLmhhbmRsZUNvbXBvc2l0aW9uRW5kLFxuICAgICAgb25LZXl1cDogdGhpcy5oYW5kbGVXcmFwcGVyS2V5dXAsXG4gICAgICBvbktleWRvd246IHRoaXMuaGFuZGxlV3JhcHBlcktleWRvd25cbiAgICB9LCBoKFwiZGl2XCIsIHtcbiAgICAgIGNsYXNzOiBgJHttZXJnZWRDbHNQcmVmaXh9LWlucHV0LXdyYXBwZXJgXG4gICAgfSwgcmVzb2x2ZVdyYXBwZWRTbG90KCRzbG90cy5wcmVmaXgsIGNoaWxkcmVuID0+IGNoaWxkcmVuICYmIGgoXCJkaXZcIiwge1xuICAgICAgY2xhc3M6IGAke21lcmdlZENsc1ByZWZpeH0taW5wdXRfX3ByZWZpeGBcbiAgICB9LCBjaGlsZHJlbikpLCB0eXBlID09PSAndGV4dGFyZWEnID8gaChOU2Nyb2xsYmFyLCB7XG4gICAgICByZWY6IFwidGV4dGFyZWFTY3JvbGxiYXJJbnN0UmVmXCIsXG4gICAgICBjbGFzczogYCR7bWVyZ2VkQ2xzUHJlZml4fS1pbnB1dF9fdGV4dGFyZWFgLFxuICAgICAgY29udGFpbmVyOiB0aGlzLmdldFRleHRhcmVhU2Nyb2xsQ29udGFpbmVyLFxuICAgICAgdHJpZ2dlckRpc3BsYXlNYW51YWxseTogdHJ1ZSxcbiAgICAgIHVzZVVuaWZpZWRDb250YWluZXI6IHRydWUsXG4gICAgICBpbnRlcm5hbEhvaXN0WVJhaWw6IHRydWVcbiAgICB9LCB7XG4gICAgICBkZWZhdWx0OiAoKSA9PiB7XG4gICAgICAgIHZhciBfYSwgX2I7XG4gICAgICAgIGNvbnN0IHtcbiAgICAgICAgICB0ZXh0QXJlYVNjcm9sbENvbnRhaW5lcldpZHRoXG4gICAgICAgIH0gPSB0aGlzO1xuICAgICAgICBjb25zdCBzY3JvbGxDb250YWluZXJXaWR0aFN0eWxlID0ge1xuICAgICAgICAgIHdpZHRoOiB0aGlzLmF1dG9zaXplICYmIHRleHRBcmVhU2Nyb2xsQ29udGFpbmVyV2lkdGggJiYgYCR7dGV4dEFyZWFTY3JvbGxDb250YWluZXJXaWR0aH1weGBcbiAgICAgICAgfTtcbiAgICAgICAgcmV0dXJuIGgoRnJhZ21lbnQsIG51bGwsIGgoXCJ0ZXh0YXJlYVwiLCBPYmplY3QuYXNzaWduKHt9LCB0aGlzLmlucHV0UHJvcHMsIHtcbiAgICAgICAgICByZWY6IFwidGV4dGFyZWFFbFJlZlwiLFxuICAgICAgICAgIGNsYXNzOiBbYCR7bWVyZ2VkQ2xzUHJlZml4fS1pbnB1dF9fdGV4dGFyZWEtZWxgLCAoX2EgPSB0aGlzLmlucHV0UHJvcHMpID09PSBudWxsIHx8IF9hID09PSB2b2lkIDAgPyB2b2lkIDAgOiBfYS5jbGFzc10sXG4gICAgICAgICAgYXV0b2ZvY3VzOiB0aGlzLmF1dG9mb2N1cyxcbiAgICAgICAgICByb3dzOiBOdW1iZXIodGhpcy5yb3dzKSxcbiAgICAgICAgICBwbGFjZWhvbGRlcjogdGhpcy5wbGFjZWhvbGRlcixcbiAgICAgICAgICB2YWx1ZTogdGhpcy5tZXJnZWRWYWx1ZSxcbiAgICAgICAgICBkaXNhYmxlZDogdGhpcy5tZXJnZWREaXNhYmxlZCxcbiAgICAgICAgICBtYXhsZW5ndGg6IGNvdW50R3JhcGhlbWVzID8gdW5kZWZpbmVkIDogdGhpcy5tYXhsZW5ndGgsXG4gICAgICAgICAgbWlubGVuZ3RoOiBjb3VudEdyYXBoZW1lcyA/IHVuZGVmaW5lZCA6IHRoaXMubWlubGVuZ3RoLFxuICAgICAgICAgIHJlYWRvbmx5OiB0aGlzLnJlYWRvbmx5LFxuICAgICAgICAgIHRhYmluZGV4OiB0aGlzLnBhc3NpdmVseUFjdGl2YXRlZCAmJiAhdGhpcy5hY3RpdmF0ZWQgPyAtMSA6IHVuZGVmaW5lZCxcbiAgICAgICAgICBzdHlsZTogW3RoaXMudGV4dERlY29yYXRpb25TdHlsZVswXSwgKF9iID0gdGhpcy5pbnB1dFByb3BzKSA9PT0gbnVsbCB8fCBfYiA9PT0gdm9pZCAwID8gdm9pZCAwIDogX2Iuc3R5bGUsIHNjcm9sbENvbnRhaW5lcldpZHRoU3R5bGVdLFxuICAgICAgICAgIG9uQmx1cjogdGhpcy5oYW5kbGVJbnB1dEJsdXIsXG4gICAgICAgICAgb25Gb2N1czogZSA9PiB7XG4gICAgICAgICAgICB0aGlzLmhhbmRsZUlucHV0Rm9jdXMoZSwgMik7XG4gICAgICAgICAgfSxcbiAgICAgICAgICBvbklucHV0OiB0aGlzLmhhbmRsZUlucHV0LFxuICAgICAgICAgIG9uQ2hhbmdlOiB0aGlzLmhhbmRsZUNoYW5nZSxcbiAgICAgICAgICBvblNjcm9sbDogdGhpcy5oYW5kbGVUZXh0QXJlYVNjcm9sbFxuICAgICAgICB9KSksIHRoaXMuc2hvd1BsYWNlaG9sZGVyMSA/IGgoXCJkaXZcIiwge1xuICAgICAgICAgIGNsYXNzOiBgJHttZXJnZWRDbHNQcmVmaXh9LWlucHV0X19wbGFjZWhvbGRlcmAsXG4gICAgICAgICAgc3R5bGU6IFt0aGlzLnBsYWNlaG9sZGVyU3R5bGUsIHNjcm9sbENvbnRhaW5lcldpZHRoU3R5bGVdLFxuICAgICAgICAgIGtleTogXCJwbGFjZWhvbGRlclwiXG4gICAgICAgIH0sIHRoaXMubWVyZ2VkUGxhY2Vob2xkZXJbMF0pIDogbnVsbCwgdGhpcy5hdXRvc2l6ZSA/IGgoVlJlc2l6ZU9ic2VydmVyLCB7XG4gICAgICAgICAgb25SZXNpemU6IHRoaXMuaGFuZGxlVGV4dEFyZWFNaXJyb3JSZXNpemVcbiAgICAgICAgfSwge1xuICAgICAgICAgIGRlZmF1bHQ6ICgpID0+IGgoXCJkaXZcIiwge1xuICAgICAgICAgICAgcmVmOiBcInRleHRhcmVhTWlycm9yRWxSZWZcIixcbiAgICAgICAgICAgIGNsYXNzOiBgJHttZXJnZWRDbHNQcmVmaXh9LWlucHV0X190ZXh0YXJlYS1taXJyb3JgLFxuICAgICAgICAgICAga2V5OiBcIm1pcnJvclwiXG4gICAgICAgICAgfSlcbiAgICAgICAgfSkgOiBudWxsKTtcbiAgICAgIH1cbiAgICB9KSA6IGgoXCJkaXZcIiwge1xuICAgICAgY2xhc3M6IGAke21lcmdlZENsc1ByZWZpeH0taW5wdXRfX2lucHV0YFxuICAgIH0sIGgoXCJpbnB1dFwiLCBPYmplY3QuYXNzaWduKHtcbiAgICAgIHR5cGU6IHR5cGUgPT09ICdwYXNzd29yZCcgJiYgdGhpcy5tZXJnZWRTaG93UGFzc3dvcmRPbiAmJiB0aGlzLnBhc3N3b3JkVmlzaWJsZSA/ICd0ZXh0JyA6IHR5cGVcbiAgICB9LCB0aGlzLmlucHV0UHJvcHMsIHtcbiAgICAgIHJlZjogXCJpbnB1dEVsUmVmXCIsXG4gICAgICBjbGFzczogW2Ake21lcmdlZENsc1ByZWZpeH0taW5wdXRfX2lucHV0LWVsYCwgKF9hID0gdGhpcy5pbnB1dFByb3BzKSA9PT0gbnVsbCB8fCBfYSA9PT0gdm9pZCAwID8gdm9pZCAwIDogX2EuY2xhc3NdLFxuICAgICAgc3R5bGU6IFt0aGlzLnRleHREZWNvcmF0aW9uU3R5bGVbMF0sIChfYiA9IHRoaXMuaW5wdXRQcm9wcykgPT09IG51bGwgfHwgX2IgPT09IHZvaWQgMCA/IHZvaWQgMCA6IF9iLnN0eWxlXSxcbiAgICAgIHRhYmluZGV4OiB0aGlzLnBhc3NpdmVseUFjdGl2YXRlZCAmJiAhdGhpcy5hY3RpdmF0ZWQgPyAtMSA6IHVuZGVmaW5lZCxcbiAgICAgIHBsYWNlaG9sZGVyOiB0aGlzLm1lcmdlZFBsYWNlaG9sZGVyWzBdLFxuICAgICAgZGlzYWJsZWQ6IHRoaXMubWVyZ2VkRGlzYWJsZWQsXG4gICAgICBtYXhsZW5ndGg6IGNvdW50R3JhcGhlbWVzID8gdW5kZWZpbmVkIDogdGhpcy5tYXhsZW5ndGgsXG4gICAgICBtaW5sZW5ndGg6IGNvdW50R3JhcGhlbWVzID8gdW5kZWZpbmVkIDogdGhpcy5taW5sZW5ndGgsXG4gICAgICB2YWx1ZTogQXJyYXkuaXNBcnJheSh0aGlzLm1lcmdlZFZhbHVlKSA/IHRoaXMubWVyZ2VkVmFsdWVbMF0gOiB0aGlzLm1lcmdlZFZhbHVlLFxuICAgICAgcmVhZG9ubHk6IHRoaXMucmVhZG9ubHksXG4gICAgICBhdXRvZm9jdXM6IHRoaXMuYXV0b2ZvY3VzLFxuICAgICAgc2l6ZTogdGhpcy5hdHRyU2l6ZSxcbiAgICAgIG9uQmx1cjogdGhpcy5oYW5kbGVJbnB1dEJsdXIsXG4gICAgICBvbkZvY3VzOiBlID0+IHtcbiAgICAgICAgdGhpcy5oYW5kbGVJbnB1dEZvY3VzKGUsIDApO1xuICAgICAgfSxcbiAgICAgIG9uSW5wdXQ6IGUgPT4ge1xuICAgICAgICB0aGlzLmhhbmRsZUlucHV0KGUsIDApO1xuICAgICAgfSxcbiAgICAgIG9uQ2hhbmdlOiBlID0+IHtcbiAgICAgICAgdGhpcy5oYW5kbGVDaGFuZ2UoZSwgMCk7XG4gICAgICB9XG4gICAgfSkpLCB0aGlzLnNob3dQbGFjZWhvbGRlcjEgPyBoKFwiZGl2XCIsIHtcbiAgICAgIGNsYXNzOiBgJHttZXJnZWRDbHNQcmVmaXh9LWlucHV0X19wbGFjZWhvbGRlcmBcbiAgICB9LCBoKFwic3BhblwiLCBudWxsLCB0aGlzLm1lcmdlZFBsYWNlaG9sZGVyWzBdKSkgOiBudWxsLCB0aGlzLmF1dG9zaXplID8gaChcImRpdlwiLCB7XG4gICAgICBjbGFzczogYCR7bWVyZ2VkQ2xzUHJlZml4fS1pbnB1dF9faW5wdXQtbWlycm9yYCxcbiAgICAgIGtleTogXCJtaXJyb3JcIixcbiAgICAgIHJlZjogXCJpbnB1dE1pcnJvckVsUmVmXCJcbiAgICB9LCBcIlxcdTAwQTBcIikgOiBudWxsKSwgIXRoaXMucGFpciAmJiByZXNvbHZlV3JhcHBlZFNsb3QoJHNsb3RzLnN1ZmZpeCwgY2hpbGRyZW4gPT4ge1xuICAgICAgcmV0dXJuIGNoaWxkcmVuIHx8IHRoaXMuY2xlYXJhYmxlIHx8IHRoaXMuc2hvd0NvdW50IHx8IHRoaXMubWVyZ2VkU2hvd1Bhc3N3b3JkT24gfHwgdGhpcy5sb2FkaW5nICE9PSB1bmRlZmluZWQgPyBoKFwiZGl2XCIsIHtcbiAgICAgICAgY2xhc3M6IGAke21lcmdlZENsc1ByZWZpeH0taW5wdXRfX3N1ZmZpeGBcbiAgICAgIH0sIFtyZXNvbHZlV3JhcHBlZFNsb3QoJHNsb3RzWydjbGVhci1pY29uLXBsYWNlaG9sZGVyJ10sIGNoaWxkcmVuID0+IHtcbiAgICAgICAgcmV0dXJuICh0aGlzLmNsZWFyYWJsZSB8fCBjaGlsZHJlbikgJiYgaChOQmFzZUNsZWFyLCB7XG4gICAgICAgICAgY2xzUHJlZml4OiBtZXJnZWRDbHNQcmVmaXgsXG4gICAgICAgICAgc2hvdzogdGhpcy5zaG93Q2xlYXJCdXR0b24sXG4gICAgICAgICAgb25DbGVhcjogdGhpcy5oYW5kbGVDbGVhclxuICAgICAgICB9LCB7XG4gICAgICAgICAgcGxhY2Vob2xkZXI6ICgpID0+IGNoaWxkcmVuLFxuICAgICAgICAgIGljb246ICgpID0+IHtcbiAgICAgICAgICAgIHZhciBfYSwgX2I7XG4gICAgICAgICAgICByZXR1cm4gKF9iID0gKF9hID0gdGhpcy4kc2xvdHMpWydjbGVhci1pY29uJ10pID09PSBudWxsIHx8IF9iID09PSB2b2lkIDAgPyB2b2lkIDAgOiBfYi5jYWxsKF9hKTtcbiAgICAgICAgICB9XG4gICAgICAgIH0pO1xuICAgICAgfSksICF0aGlzLmludGVybmFsTG9hZGluZ0JlZm9yZVN1ZmZpeCA/IGNoaWxkcmVuIDogbnVsbCwgdGhpcy5sb2FkaW5nICE9PSB1bmRlZmluZWQgPyBoKE5CYXNlU3VmZml4LCB7XG4gICAgICAgIGNsc1ByZWZpeDogbWVyZ2VkQ2xzUHJlZml4LFxuICAgICAgICBsb2FkaW5nOiB0aGlzLmxvYWRpbmcsXG4gICAgICAgIHNob3dBcnJvdzogZmFsc2UsXG4gICAgICAgIHNob3dDbGVhcjogZmFsc2UsXG4gICAgICAgIHN0eWxlOiB0aGlzLmNzc1ZhcnNcbiAgICAgIH0pIDogbnVsbCwgdGhpcy5pbnRlcm5hbExvYWRpbmdCZWZvcmVTdWZmaXggPyBjaGlsZHJlbiA6IG51bGwsIHRoaXMuc2hvd0NvdW50ICYmIHRoaXMudHlwZSAhPT0gJ3RleHRhcmVhJyA/IGgoV29yZENvdW50LCBudWxsLCB7XG4gICAgICAgIGRlZmF1bHQ6IHByb3BzID0+IHtcbiAgICAgICAgICB2YXIgX2E7XG4gICAgICAgICAgcmV0dXJuIChfYSA9ICRzbG90cy5jb3VudCkgPT09IG51bGwgfHwgX2EgPT09IHZvaWQgMCA/IHZvaWQgMCA6IF9hLmNhbGwoJHNsb3RzLCBwcm9wcyk7XG4gICAgICAgIH1cbiAgICAgIH0pIDogbnVsbCwgdGhpcy5tZXJnZWRTaG93UGFzc3dvcmRPbiAmJiB0aGlzLnR5cGUgPT09ICdwYXNzd29yZCcgPyBoKFwiZGl2XCIsIHtcbiAgICAgICAgY2xhc3M6IGAke21lcmdlZENsc1ByZWZpeH0taW5wdXRfX2V5ZWAsXG4gICAgICAgIG9uTW91c2Vkb3duOiB0aGlzLmhhbmRsZVBhc3N3b3JkVG9nZ2xlTW91c2Vkb3duLFxuICAgICAgICBvbkNsaWNrOiB0aGlzLmhhbmRsZVBhc3N3b3JkVG9nZ2xlQ2xpY2tcbiAgICAgIH0sIHRoaXMucGFzc3dvcmRWaXNpYmxlID8gcmVzb2x2ZVNsb3QoJHNsb3RzWydwYXNzd29yZC12aXNpYmxlLWljb24nXSwgKCkgPT4gW2goTkJhc2VJY29uLCB7XG4gICAgICAgIGNsc1ByZWZpeDogbWVyZ2VkQ2xzUHJlZml4XG4gICAgICB9LCB7XG4gICAgICAgIGRlZmF1bHQ6ICgpID0+IGgoRXllSWNvbiwgbnVsbClcbiAgICAgIH0pXSkgOiByZXNvbHZlU2xvdCgkc2xvdHNbJ3Bhc3N3b3JkLWludmlzaWJsZS1pY29uJ10sICgpID0+IFtoKE5CYXNlSWNvbiwge1xuICAgICAgICBjbHNQcmVmaXg6IG1lcmdlZENsc1ByZWZpeFxuICAgICAgfSwge1xuICAgICAgICBkZWZhdWx0OiAoKSA9PiBoKEV5ZU9mZkljb24sIG51bGwpXG4gICAgICB9KV0pKSA6IG51bGxdKSA6IG51bGw7XG4gICAgfSkpLCB0aGlzLnBhaXIgPyBoKFwic3BhblwiLCB7XG4gICAgICBjbGFzczogYCR7bWVyZ2VkQ2xzUHJlZml4fS1pbnB1dF9fc2VwYXJhdG9yYFxuICAgIH0sIHJlc29sdmVTbG90KCRzbG90cy5zZXBhcmF0b3IsICgpID0+IFt0aGlzLnNlcGFyYXRvcl0pKSA6IG51bGwsIHRoaXMucGFpciA/IGgoXCJkaXZcIiwge1xuICAgICAgY2xhc3M6IGAke21lcmdlZENsc1ByZWZpeH0taW5wdXQtd3JhcHBlcmBcbiAgICB9LCBoKFwiZGl2XCIsIHtcbiAgICAgIGNsYXNzOiBgJHttZXJnZWRDbHNQcmVmaXh9LWlucHV0X19pbnB1dGBcbiAgICB9LCBoKFwiaW5wdXRcIiwge1xuICAgICAgcmVmOiBcImlucHV0RWwyUmVmXCIsXG4gICAgICB0eXBlOiB0aGlzLnR5cGUsXG4gICAgICBjbGFzczogYCR7bWVyZ2VkQ2xzUHJlZml4fS1pbnB1dF9faW5wdXQtZWxgLFxuICAgICAgdGFiaW5kZXg6IHRoaXMucGFzc2l2ZWx5QWN0aXZhdGVkICYmICF0aGlzLmFjdGl2YXRlZCA/IC0xIDogdW5kZWZpbmVkLFxuICAgICAgcGxhY2Vob2xkZXI6IHRoaXMubWVyZ2VkUGxhY2Vob2xkZXJbMV0sXG4gICAgICBkaXNhYmxlZDogdGhpcy5tZXJnZWREaXNhYmxlZCxcbiAgICAgIG1heGxlbmd0aDogY291bnRHcmFwaGVtZXMgPyB1bmRlZmluZWQgOiB0aGlzLm1heGxlbmd0aCxcbiAgICAgIG1pbmxlbmd0aDogY291bnRHcmFwaGVtZXMgPyB1bmRlZmluZWQgOiB0aGlzLm1pbmxlbmd0aCxcbiAgICAgIHZhbHVlOiBBcnJheS5pc0FycmF5KHRoaXMubWVyZ2VkVmFsdWUpID8gdGhpcy5tZXJnZWRWYWx1ZVsxXSA6IHVuZGVmaW5lZCxcbiAgICAgIHJlYWRvbmx5OiB0aGlzLnJlYWRvbmx5LFxuICAgICAgc3R5bGU6IHRoaXMudGV4dERlY29yYXRpb25TdHlsZVsxXSxcbiAgICAgIG9uQmx1cjogdGhpcy5oYW5kbGVJbnB1dEJsdXIsXG4gICAgICBvbkZvY3VzOiBlID0+IHtcbiAgICAgICAgdGhpcy5oYW5kbGVJbnB1dEZvY3VzKGUsIDEpO1xuICAgICAgfSxcbiAgICAgIG9uSW5wdXQ6IGUgPT4ge1xuICAgICAgICB0aGlzLmhhbmRsZUlucHV0KGUsIDEpO1xuICAgICAgfSxcbiAgICAgIG9uQ2hhbmdlOiBlID0+IHtcbiAgICAgICAgdGhpcy5oYW5kbGVDaGFuZ2UoZSwgMSk7XG4gICAgICB9XG4gICAgfSksIHRoaXMuc2hvd1BsYWNlaG9sZGVyMiA/IGgoXCJkaXZcIiwge1xuICAgICAgY2xhc3M6IGAke21lcmdlZENsc1ByZWZpeH0taW5wdXRfX3BsYWNlaG9sZGVyYFxuICAgIH0sIGgoXCJzcGFuXCIsIG51bGwsIHRoaXMubWVyZ2VkUGxhY2Vob2xkZXJbMV0pKSA6IG51bGwpLCByZXNvbHZlV3JhcHBlZFNsb3QoJHNsb3RzLnN1ZmZpeCwgY2hpbGRyZW4gPT4ge1xuICAgICAgcmV0dXJuICh0aGlzLmNsZWFyYWJsZSB8fCBjaGlsZHJlbikgJiYgaChcImRpdlwiLCB7XG4gICAgICAgIGNsYXNzOiBgJHttZXJnZWRDbHNQcmVmaXh9LWlucHV0X19zdWZmaXhgXG4gICAgICB9LCBbdGhpcy5jbGVhcmFibGUgJiYgaChOQmFzZUNsZWFyLCB7XG4gICAgICAgIGNsc1ByZWZpeDogbWVyZ2VkQ2xzUHJlZml4LFxuICAgICAgICBzaG93OiB0aGlzLnNob3dDbGVhckJ1dHRvbixcbiAgICAgICAgb25DbGVhcjogdGhpcy5oYW5kbGVDbGVhclxuICAgICAgfSwge1xuICAgICAgICBpY29uOiAoKSA9PiB7XG4gICAgICAgICAgdmFyIF9hO1xuICAgICAgICAgIHJldHVybiAoX2EgPSAkc2xvdHNbJ2NsZWFyLWljb24nXSkgPT09IG51bGwgfHwgX2EgPT09IHZvaWQgMCA/IHZvaWQgMCA6IF9hLmNhbGwoJHNsb3RzKTtcbiAgICAgICAgfSxcbiAgICAgICAgcGxhY2Vob2xkZXI6ICgpID0+IHtcbiAgICAgICAgICB2YXIgX2E7XG4gICAgICAgICAgcmV0dXJuIChfYSA9ICRzbG90c1snY2xlYXItaWNvbi1wbGFjZWhvbGRlciddKSA9PT0gbnVsbCB8fCBfYSA9PT0gdm9pZCAwID8gdm9pZCAwIDogX2EuY2FsbCgkc2xvdHMpO1xuICAgICAgICB9XG4gICAgICB9KSwgY2hpbGRyZW5dKTtcbiAgICB9KSkgOiBudWxsLCB0aGlzLm1lcmdlZEJvcmRlcmVkID8gaChcImRpdlwiLCB7XG4gICAgICBjbGFzczogYCR7bWVyZ2VkQ2xzUHJlZml4fS1pbnB1dF9fYm9yZGVyYFxuICAgIH0pIDogbnVsbCwgdGhpcy5tZXJnZWRCb3JkZXJlZCA/IGgoXCJkaXZcIiwge1xuICAgICAgY2xhc3M6IGAke21lcmdlZENsc1ByZWZpeH0taW5wdXRfX3N0YXRlLWJvcmRlcmBcbiAgICB9KSA6IG51bGwsIHRoaXMuc2hvd0NvdW50ICYmIHR5cGUgPT09ICd0ZXh0YXJlYScgPyBoKFdvcmRDb3VudCwgbnVsbCwge1xuICAgICAgZGVmYXVsdDogcHJvcHMgPT4ge1xuICAgICAgICB2YXIgX2E7XG4gICAgICAgIGNvbnN0IHtcbiAgICAgICAgICByZW5kZXJDb3VudFxuICAgICAgICB9ID0gdGhpcztcbiAgICAgICAgaWYgKHJlbmRlckNvdW50KSB7XG4gICAgICAgICAgcmV0dXJuIHJlbmRlckNvdW50KHByb3BzKTtcbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gKF9hID0gJHNsb3RzLmNvdW50KSA9PT0gbnVsbCB8fCBfYSA9PT0gdm9pZCAwID8gdm9pZCAwIDogX2EuY2FsbCgkc2xvdHMsIHByb3BzKTtcbiAgICAgIH1cbiAgICB9KSA6IG51bGwpO1xuICB9XG59KTsiLCJpbXBvcnQgeyBjb21wdXRlZCwgZGVmaW5lQ29tcG9uZW50LCBoLCBpbmplY3QgfSBmcm9tICd2dWUnO1xuaW1wb3J0IHsgcmVzb2x2ZVNsb3RXaXRoUHJvcHMgfSBmcm9tIFwiLi4vLi4vX3V0aWxzL2luZGV4Lm1qc1wiO1xuaW1wb3J0IHsgaW5wdXRJbmplY3Rpb25LZXkgfSBmcm9tIFwiLi9pbnRlcmZhY2UubWpzXCI7XG5pbXBvcnQgeyBsZW4gfSBmcm9tIFwiLi91dGlscy5tanNcIjtcbmV4cG9ydCBkZWZhdWx0IGRlZmluZUNvbXBvbmVudCh7XG4gIG5hbWU6ICdJbnB1dFdvcmRDb3VudCcsXG4gIHNldHVwKF8sIHtcbiAgICBzbG90c1xuICB9KSB7XG4gICAgY29uc3Qge1xuICAgICAgbWVyZ2VkVmFsdWVSZWYsXG4gICAgICBtYXhsZW5ndGhSZWYsXG4gICAgICBtZXJnZWRDbHNQcmVmaXhSZWYsXG4gICAgICBjb3VudEdyYXBoZW1lc1JlZlxuICAgIH0gPSBpbmplY3QoaW5wdXRJbmplY3Rpb25LZXkpO1xuICAgIGNvbnN0IHdvcmRDb3VudFJlZiA9IGNvbXB1dGVkKCgpID0+IHtcbiAgICAgIGNvbnN0IHtcbiAgICAgICAgdmFsdWU6IG1lcmdlZFZhbHVlXG4gICAgICB9ID0gbWVyZ2VkVmFsdWVSZWY7XG4gICAgICBpZiAobWVyZ2VkVmFsdWUgPT09IG51bGwgfHwgQXJyYXkuaXNBcnJheShtZXJnZWRWYWx1ZSkpIHJldHVybiAwO1xuICAgICAgcmV0dXJuIChjb3VudEdyYXBoZW1lc1JlZi52YWx1ZSB8fCBsZW4pKG1lcmdlZFZhbHVlKTtcbiAgICB9KTtcbiAgICByZXR1cm4gKCkgPT4ge1xuICAgICAgY29uc3Qge1xuICAgICAgICB2YWx1ZTogbWF4bGVuZ3RoXG4gICAgICB9ID0gbWF4bGVuZ3RoUmVmO1xuICAgICAgY29uc3Qge1xuICAgICAgICB2YWx1ZTogbWVyZ2VkVmFsdWVcbiAgICAgIH0gPSBtZXJnZWRWYWx1ZVJlZjtcbiAgICAgIHJldHVybiBoKFwic3BhblwiLCB7XG4gICAgICAgIGNsYXNzOiBgJHttZXJnZWRDbHNQcmVmaXhSZWYudmFsdWV9LWlucHV0LXdvcmQtY291bnRgXG4gICAgICB9LCByZXNvbHZlU2xvdFdpdGhQcm9wcyhzbG90cy5kZWZhdWx0LCB7XG4gICAgICAgIHZhbHVlOiBtZXJnZWRWYWx1ZSA9PT0gbnVsbCB8fCBBcnJheS5pc0FycmF5KG1lcmdlZFZhbHVlKSA/ICcnIDogbWVyZ2VkVmFsdWVcbiAgICAgIH0sICgpID0+IFttYXhsZW5ndGggPT09IHVuZGVmaW5lZCA/IHdvcmRDb3VudFJlZi52YWx1ZSA6IGAke3dvcmRDb3VudFJlZi52YWx1ZX0gLyAke21heGxlbmd0aH1gXSkpO1xuICAgIH07XG4gIH1cbn0pOyIsImltcG9ydCB7IGNyZWF0ZUluamVjdGlvbktleSB9IGZyb20gXCIuLi8uLi9fdXRpbHMvaW5kZXgubWpzXCI7XG5leHBvcnQgY29uc3QgaW5wdXRJbmplY3Rpb25LZXkgPSBjcmVhdGVJbmplY3Rpb25LZXkoJ24taW5wdXQnKTsiLCJpbXBvcnQgeyBjLCBjQiwgY0UsIGNNLCBjTm90TSB9IGZyb20gXCIuLi8uLi8uLi9fdXRpbHMvY3Nzci9pbmRleC5tanNcIjtcbi8vIHZhcnM6XG4vLyAtLW4tYmV6aWVyXG4vLyAtLW4tY29sb3Jcbi8vIC0tbi1mb250LXNpemVcbi8vIC0tbi1ib3JkZXItcmFkaXVzXG4vLyAtLW4taGVpZ2h0XG4vLyAtLW4tcGFkZGluZy1sZWZ0XG4vLyAtLW4tcGFkZGluZy1yaWdodFxuLy8gLS1uLXRleHQtY29sb3Jcbi8vIC0tbi10ZXh0LWNvbG9yLWRpc2FibGVkXG4vLyAtLW4tY2FyZXQtY29sb3Jcbi8vIC0tbi10ZXh0LWRlY29yYXRpb24tY29sb3Jcbi8vIC0tbi1ib3JkZXJcbi8vIC0tbi1ib3JkZXItZGlzYWJsZWRcbi8vIC0tbi1ib3JkZXItaG92ZXJcbi8vIC0tbi1ib3JkZXItZm9jdXNcbi8vIC0tbi1wbGFjZWhvbGRlci1jb2xvclxuLy8gLS1uLXBsYWNlaG9sZGVyLWNvbG9yLWRpc2FibGVkXG4vLyAtLW4tbGluZS1oZWlnaHQtdGV4dGFyZWFcbi8vIC0tbi1jb2xvci1kaXNhYmxlZFxuLy8gLS1uLWNvbG9yLWZvY3VzXG4vLyAtLW4tYm94LXNoYWRvdy1mb2N1c1xuLy8gLS1uLWNsZWFyLWNvbG9yXG4vLyAtLW4tY2xlYXItc2l6ZVxuLy8gLS1uLWNsZWFyLWNvbG9yLWhvdmVyXG4vLyAtLW4tY2xlYXItY29sb3ItcHJlc3NlZFxuLy8gLS1uLXN1ZmZpeC10ZXh0LWNvbG9yXG4vLyAtLW4taWNvbi1jb2xvclxuLy8gLS1uLWljb24tY29sb3ItaG92ZXJcbi8vIC0tbi1pY29uLWNvbG9yLXByZXNzZWRcbi8vIC0tbi1pY29uLWNvbG9yLWRpc2FibGVkXG4vLyAtLW4tY291bnQtdGV4dC1jb2xvclxuLy8gLS1uLWNvdW50LXRleHQtY29sb3ItZGlzYWJsZWRcbi8vIC0tbi1sb2FkaW5nLWNvbG9yXG4vLyAuLi5mb3JtIGl0ZW0gdmFyc1xuZXhwb3J0IGRlZmF1bHQgY0IoJ2lucHV0JywgYFxuIG1heC13aWR0aDogMTAwJTtcbiBjdXJzb3I6IHRleHQ7XG4gbGluZS1oZWlnaHQ6IDEuNTtcbiB6LWluZGV4OiBhdXRvO1xuIG91dGxpbmU6IG5vbmU7XG4gYm94LXNpemluZzogYm9yZGVyLWJveDtcbiBwb3NpdGlvbjogcmVsYXRpdmU7XG4gZGlzcGxheTogaW5saW5lLWZsZXg7XG4gYm9yZGVyLXJhZGl1czogdmFyKC0tbi1ib3JkZXItcmFkaXVzKTtcbiBiYWNrZ3JvdW5kLWNvbG9yOiB2YXIoLS1uLWNvbG9yKTtcbiB0cmFuc2l0aW9uOiBiYWNrZ3JvdW5kLWNvbG9yIC4zcyB2YXIoLS1uLWJlemllcik7XG4gZm9udC1zaXplOiB2YXIoLS1uLWZvbnQtc2l6ZSk7XG4gLS1uLXBhZGRpbmctdmVydGljYWw6IGNhbGMoKHZhcigtLW4taGVpZ2h0KSAtIDEuNSAqIHZhcigtLW4tZm9udC1zaXplKSkgLyAyKTtcbmAsIFtcbi8vIGNvbW1vblxuY0UoJ2lucHV0LCB0ZXh0YXJlYScsIGBcbiBvdmVyZmxvdzogaGlkZGVuO1xuIGZsZXgtZ3JvdzogMTtcbiBwb3NpdGlvbjogcmVsYXRpdmU7XG4gYCksIGNFKCdpbnB1dC1lbCwgdGV4dGFyZWEtZWwsIGlucHV0LW1pcnJvciwgdGV4dGFyZWEtbWlycm9yLCBzZXBhcmF0b3IsIHBsYWNlaG9sZGVyJywgYFxuIGJveC1zaXppbmc6IGJvcmRlci1ib3g7XG4gZm9udC1zaXplOiBpbmhlcml0O1xuIGxpbmUtaGVpZ2h0OiAxLjU7XG4gZm9udC1mYW1pbHk6IGluaGVyaXQ7XG4gYm9yZGVyOiBub25lO1xuIG91dGxpbmU6IG5vbmU7XG4gYmFja2dyb3VuZC1jb2xvcjogIzAwMDA7XG4gdGV4dC1hbGlnbjogaW5oZXJpdDtcbiB0cmFuc2l0aW9uOlxuIC13ZWJraXQtdGV4dC1maWxsLWNvbG9yIC4zcyB2YXIoLS1uLWJlemllciksXG4gY2FyZXQtY29sb3IgLjNzIHZhcigtLW4tYmV6aWVyKSxcbiBjb2xvciAuM3MgdmFyKC0tbi1iZXppZXIpLFxuIHRleHQtZGVjb3JhdGlvbi1jb2xvciAuM3MgdmFyKC0tbi1iZXppZXIpO1xuIGApLCBjRSgnaW5wdXQtZWwsIHRleHRhcmVhLWVsJywgYFxuIC13ZWJraXQtYXBwZWFyYW5jZTogbm9uZTtcbiBzY3JvbGxiYXItd2lkdGg6IG5vbmU7XG4gd2lkdGg6IDEwMCU7XG4gbWluLXdpZHRoOiAwO1xuIHRleHQtZGVjb3JhdGlvbi1jb2xvcjogdmFyKC0tbi10ZXh0LWRlY29yYXRpb24tY29sb3IpO1xuIGNvbG9yOiB2YXIoLS1uLXRleHQtY29sb3IpO1xuIGNhcmV0LWNvbG9yOiB2YXIoLS1uLWNhcmV0LWNvbG9yKTtcbiBiYWNrZ3JvdW5kLWNvbG9yOiB0cmFuc3BhcmVudDtcbiBgLCBbYygnJjo6LXdlYmtpdC1zY3JvbGxiYXIsICY6Oi13ZWJraXQtc2Nyb2xsYmFyLXRyYWNrLXBpZWNlLCAmOjotd2Via2l0LXNjcm9sbGJhci10aHVtYicsIGBcbiB3aWR0aDogMDtcbiBoZWlnaHQ6IDA7XG4gZGlzcGxheTogbm9uZTtcbiBgKSwgYygnJjo6cGxhY2Vob2xkZXInLCBgXG4gY29sb3I6ICMwMDAwO1xuIC13ZWJraXQtdGV4dC1maWxsLWNvbG9yOiB0cmFuc3BhcmVudCAhaW1wb3J0YW50O1xuIGApLCBjKCcmOi13ZWJraXQtYXV0b2ZpbGwgficsIFtjRSgncGxhY2Vob2xkZXInLCAnZGlzcGxheTogbm9uZTsnKV0pXSksIGNNKCdyb3VuZCcsIFtjTm90TSgndGV4dGFyZWEnLCAnYm9yZGVyLXJhZGl1czogY2FsYyh2YXIoLS1uLWhlaWdodCkgLyAyKTsnKV0pLCBjRSgncGxhY2Vob2xkZXInLCBgXG4gcG9pbnRlci1ldmVudHM6IG5vbmU7XG4gcG9zaXRpb246IGFic29sdXRlO1xuIGxlZnQ6IDA7XG4gcmlnaHQ6IDA7XG4gdG9wOiAwO1xuIGJvdHRvbTogMDtcbiBvdmVyZmxvdzogaGlkZGVuO1xuIGNvbG9yOiB2YXIoLS1uLXBsYWNlaG9sZGVyLWNvbG9yKTtcbiBgLCBbYygnc3BhbicsIGBcbiB3aWR0aDogMTAwJTtcbiBkaXNwbGF5OiBpbmxpbmUtYmxvY2s7XG4gYCldKSwgY00oJ3RleHRhcmVhJywgW2NFKCdwbGFjZWhvbGRlcicsICdvdmVyZmxvdzogdmlzaWJsZTsnKV0pLCBjTm90TSgnYXV0b3NpemUnLCAnd2lkdGg6IDEwMCU7JyksIGNNKCdhdXRvc2l6ZScsIFtjRSgndGV4dGFyZWEtZWwsIGlucHV0LWVsJywgYFxuIHBvc2l0aW9uOiBhYnNvbHV0ZTtcbiB0b3A6IDA7XG4gbGVmdDogMDtcbiBoZWlnaHQ6IDEwMCU7XG4gYCldKSxcbi8vIGlucHV0XG5jQignaW5wdXQtd3JhcHBlcicsIGBcbiBvdmVyZmxvdzogaGlkZGVuO1xuIGRpc3BsYXk6IGlubGluZS1mbGV4O1xuIGZsZXgtZ3JvdzogMTtcbiBwb3NpdGlvbjogcmVsYXRpdmU7XG4gcGFkZGluZy1sZWZ0OiB2YXIoLS1uLXBhZGRpbmctbGVmdCk7XG4gcGFkZGluZy1yaWdodDogdmFyKC0tbi1wYWRkaW5nLXJpZ2h0KTtcbiBgKSwgY0UoJ2lucHV0LW1pcnJvcicsIGBcbiBwYWRkaW5nOiAwO1xuIGhlaWdodDogdmFyKC0tbi1oZWlnaHQpO1xuIGxpbmUtaGVpZ2h0OiB2YXIoLS1uLWhlaWdodCk7XG4gb3ZlcmZsb3c6IGhpZGRlbjtcbiB2aXNpYmlsaXR5OiBoaWRkZW47XG4gcG9zaXRpb246IHN0YXRpYztcbiB3aGl0ZS1zcGFjZTogcHJlO1xuIHBvaW50ZXItZXZlbnRzOiBub25lO1xuIGApLCBjRSgnaW5wdXQtZWwnLCBgXG4gcGFkZGluZzogMDtcbiBoZWlnaHQ6IHZhcigtLW4taGVpZ2h0KTtcbiBsaW5lLWhlaWdodDogdmFyKC0tbi1oZWlnaHQpO1xuIGAsIFtjKCcmW3R5cGU9cGFzc3dvcmRdOjotbXMtcmV2ZWFsJywgJ2Rpc3BsYXk6IG5vbmU7JyksIGMoJysnLCBbY0UoJ3BsYWNlaG9sZGVyJywgYFxuIGRpc3BsYXk6IGZsZXg7XG4gYWxpZ24taXRlbXM6IGNlbnRlcjsgXG4gYCldKV0pLCBjTm90TSgndGV4dGFyZWEnLCBbY0UoJ3BsYWNlaG9sZGVyJywgJ3doaXRlLXNwYWNlOiBub3dyYXA7JyldKSwgY0UoJ2V5ZScsIGBcbiBkaXNwbGF5OiBmbGV4O1xuIGFsaWduLWl0ZW1zOiBjZW50ZXI7XG4ganVzdGlmeS1jb250ZW50OiBjZW50ZXI7XG4gdHJhbnNpdGlvbjogY29sb3IgLjNzIHZhcigtLW4tYmV6aWVyKTtcbiBgKSxcbi8vIHRleHRhcmVhXG5jTSgndGV4dGFyZWEnLCAnd2lkdGg6IDEwMCU7JywgW2NCKCdpbnB1dC13b3JkLWNvdW50JywgYFxuIHBvc2l0aW9uOiBhYnNvbHV0ZTtcbiByaWdodDogdmFyKC0tbi1wYWRkaW5nLXJpZ2h0KTtcbiBib3R0b206IHZhcigtLW4tcGFkZGluZy12ZXJ0aWNhbCk7XG4gYCksIGNNKCdyZXNpemFibGUnLCBbY0IoJ2lucHV0LXdyYXBwZXInLCBgXG4gcmVzaXplOiB2ZXJ0aWNhbDtcbiBtaW4taGVpZ2h0OiB2YXIoLS1uLWhlaWdodCk7XG4gYCldKSwgY0UoJ3RleHRhcmVhLWVsLCB0ZXh0YXJlYS1taXJyb3IsIHBsYWNlaG9sZGVyJywgYFxuIGhlaWdodDogMTAwJTtcbiBwYWRkaW5nLWxlZnQ6IDA7XG4gcGFkZGluZy1yaWdodDogMDtcbiBwYWRkaW5nLXRvcDogdmFyKC0tbi1wYWRkaW5nLXZlcnRpY2FsKTtcbiBwYWRkaW5nLWJvdHRvbTogdmFyKC0tbi1wYWRkaW5nLXZlcnRpY2FsKTtcbiB3b3JkLWJyZWFrOiBicmVhay13b3JkO1xuIGRpc3BsYXk6IGlubGluZS1ibG9jaztcbiB2ZXJ0aWNhbC1hbGlnbjogYm90dG9tO1xuIGJveC1zaXppbmc6IGJvcmRlci1ib3g7XG4gbGluZS1oZWlnaHQ6IHZhcigtLW4tbGluZS1oZWlnaHQtdGV4dGFyZWEpO1xuIG1hcmdpbjogMDtcbiByZXNpemU6IG5vbmU7XG4gd2hpdGUtc3BhY2U6IHByZS13cmFwO1xuIHNjcm9sbC1wYWRkaW5nLWJsb2NrLWVuZDogdmFyKC0tbi1wYWRkaW5nLXZlcnRpY2FsKTtcbiBgKSwgY0UoJ3RleHRhcmVhLW1pcnJvcicsIGBcbiB3aWR0aDogMTAwJTtcbiBwb2ludGVyLWV2ZW50czogbm9uZTtcbiBvdmVyZmxvdzogaGlkZGVuO1xuIHZpc2liaWxpdHk6IGhpZGRlbjtcbiBwb3NpdGlvbjogc3RhdGljO1xuIHdoaXRlLXNwYWNlOiBwcmUtd3JhcDtcbiBvdmVyZmxvdy13cmFwOiBicmVhay13b3JkO1xuIGApXSksXG4vLyBwYWlyXG5jTSgncGFpcicsIFtjRSgnaW5wdXQtZWwsIHBsYWNlaG9sZGVyJywgJ3RleHQtYWxpZ246IGNlbnRlcjsnKSwgY0UoJ3NlcGFyYXRvcicsIGBcbiBkaXNwbGF5OiBmbGV4O1xuIGFsaWduLWl0ZW1zOiBjZW50ZXI7XG4gdHJhbnNpdGlvbjogY29sb3IgLjNzIHZhcigtLW4tYmV6aWVyKTtcbiBjb2xvcjogdmFyKC0tbi10ZXh0LWNvbG9yKTtcbiB3aGl0ZS1zcGFjZTogbm93cmFwO1xuIGAsIFtjQignaWNvbicsIGBcbiBjb2xvcjogdmFyKC0tbi1pY29uLWNvbG9yKTtcbiBgKSwgY0IoJ2Jhc2UtaWNvbicsIGBcbiBjb2xvcjogdmFyKC0tbi1pY29uLWNvbG9yKTtcbiBgKV0pXSksIGNNKCdkaXNhYmxlZCcsIGBcbiBjdXJzb3I6IG5vdC1hbGxvd2VkO1xuIGJhY2tncm91bmQtY29sb3I6IHZhcigtLW4tY29sb3ItZGlzYWJsZWQpO1xuIGAsIFtjRSgnYm9yZGVyJywgJ2JvcmRlcjogdmFyKC0tbi1ib3JkZXItZGlzYWJsZWQpOycpLCBjRSgnaW5wdXQtZWwsIHRleHRhcmVhLWVsJywgYFxuIGN1cnNvcjogbm90LWFsbG93ZWQ7XG4gY29sb3I6IHZhcigtLW4tdGV4dC1jb2xvci1kaXNhYmxlZCk7XG4gdGV4dC1kZWNvcmF0aW9uLWNvbG9yOiB2YXIoLS1uLXRleHQtY29sb3ItZGlzYWJsZWQpO1xuIGApLCBjRSgncGxhY2Vob2xkZXInLCAnY29sb3I6IHZhcigtLW4tcGxhY2Vob2xkZXItY29sb3ItZGlzYWJsZWQpOycpLCBjRSgnc2VwYXJhdG9yJywgJ2NvbG9yOiB2YXIoLS1uLXRleHQtY29sb3ItZGlzYWJsZWQpOycsIFtjQignaWNvbicsIGBcbiBjb2xvcjogdmFyKC0tbi1pY29uLWNvbG9yLWRpc2FibGVkKTtcbiBgKSwgY0IoJ2Jhc2UtaWNvbicsIGBcbiBjb2xvcjogdmFyKC0tbi1pY29uLWNvbG9yLWRpc2FibGVkKTtcbiBgKV0pLCBjQignaW5wdXQtd29yZC1jb3VudCcsIGBcbiBjb2xvcjogdmFyKC0tbi1jb3VudC10ZXh0LWNvbG9yLWRpc2FibGVkKTtcbiBgKSwgY0UoJ3N1ZmZpeCwgcHJlZml4JywgJ2NvbG9yOiB2YXIoLS1uLXRleHQtY29sb3ItZGlzYWJsZWQpOycsIFtjQignaWNvbicsIGBcbiBjb2xvcjogdmFyKC0tbi1pY29uLWNvbG9yLWRpc2FibGVkKTtcbiBgKSwgY0IoJ2ludGVybmFsLWljb24nLCBgXG4gY29sb3I6IHZhcigtLW4taWNvbi1jb2xvci1kaXNhYmxlZCk7XG4gYCldKV0pLCBjTm90TSgnZGlzYWJsZWQnLCBbY0UoJ2V5ZScsIGBcbiBjb2xvcjogdmFyKC0tbi1pY29uLWNvbG9yKTtcbiBjdXJzb3I6IHBvaW50ZXI7XG4gYCwgW2MoJyY6aG92ZXInLCBgXG4gY29sb3I6IHZhcigtLW4taWNvbi1jb2xvci1ob3Zlcik7XG4gYCksIGMoJyY6YWN0aXZlJywgYFxuIGNvbG9yOiB2YXIoLS1uLWljb24tY29sb3ItcHJlc3NlZCk7XG4gYCldKSwgYygnJjpob3ZlcicsIFtjRSgnc3RhdGUtYm9yZGVyJywgJ2JvcmRlcjogdmFyKC0tbi1ib3JkZXItaG92ZXIpOycpXSksIGNNKCdmb2N1cycsICdiYWNrZ3JvdW5kLWNvbG9yOiB2YXIoLS1uLWNvbG9yLWZvY3VzKTsnLCBbY0UoJ3N0YXRlLWJvcmRlcicsIGBcbiBib3JkZXI6IHZhcigtLW4tYm9yZGVyLWZvY3VzKTtcbiBib3gtc2hhZG93OiB2YXIoLS1uLWJveC1zaGFkb3ctZm9jdXMpO1xuIGApXSldKSwgY0UoJ2JvcmRlciwgc3RhdGUtYm9yZGVyJywgYFxuIGJveC1zaXppbmc6IGJvcmRlci1ib3g7XG4gcG9zaXRpb246IGFic29sdXRlO1xuIGxlZnQ6IDA7XG4gcmlnaHQ6IDA7XG4gdG9wOiAwO1xuIGJvdHRvbTogMDtcbiBwb2ludGVyLWV2ZW50czogbm9uZTtcbiBib3JkZXItcmFkaXVzOiBpbmhlcml0O1xuIGJvcmRlcjogdmFyKC0tbi1ib3JkZXIpO1xuIHRyYW5zaXRpb246XG4gYm94LXNoYWRvdyAuM3MgdmFyKC0tbi1iZXppZXIpLFxuIGJvcmRlci1jb2xvciAuM3MgdmFyKC0tbi1iZXppZXIpO1xuIGApLCBjRSgnc3RhdGUtYm9yZGVyJywgYFxuIGJvcmRlci1jb2xvcjogIzAwMDA7XG4gei1pbmRleDogMTtcbiBgKSwgY0UoJ3ByZWZpeCcsICdtYXJnaW4tcmlnaHQ6IDRweDsnKSwgY0UoJ3N1ZmZpeCcsIGBcbiBtYXJnaW4tbGVmdDogNHB4O1xuIGApLCBjRSgnc3VmZml4LCBwcmVmaXgnLCBgXG4gdHJhbnNpdGlvbjogY29sb3IgLjNzIHZhcigtLW4tYmV6aWVyKTtcbiBmbGV4LXdyYXA6IG5vd3JhcDtcbiBmbGV4LXNocmluazogMDtcbiBsaW5lLWhlaWdodDogdmFyKC0tbi1oZWlnaHQpO1xuIHdoaXRlLXNwYWNlOiBub3dyYXA7XG4gZGlzcGxheTogaW5saW5lLWZsZXg7XG4gYWxpZ24taXRlbXM6IGNlbnRlcjtcbiBqdXN0aWZ5LWNvbnRlbnQ6IGNlbnRlcjtcbiBjb2xvcjogdmFyKC0tbi1zdWZmaXgtdGV4dC1jb2xvcik7XG4gYCwgW2NCKCdiYXNlLWxvYWRpbmcnLCBgXG4gZm9udC1zaXplOiB2YXIoLS1uLWljb24tc2l6ZSk7XG4gbWFyZ2luOiAwIDJweDtcbiBjb2xvcjogdmFyKC0tbi1sb2FkaW5nLWNvbG9yKTtcbiBgKSwgY0IoJ2Jhc2UtY2xlYXInLCBgXG4gZm9udC1zaXplOiB2YXIoLS1uLWljb24tc2l6ZSk7XG4gYCwgW2NFKCdwbGFjZWhvbGRlcicsIFtjQignYmFzZS1pY29uJywgYFxuIHRyYW5zaXRpb246IGNvbG9yIC4zcyB2YXIoLS1uLWJlemllcik7XG4gY29sb3I6IHZhcigtLW4taWNvbi1jb2xvcik7XG4gZm9udC1zaXplOiB2YXIoLS1uLWljb24tc2l6ZSk7XG4gYCldKV0pLCBjKCc+JywgW2NCKCdpY29uJywgYFxuIHRyYW5zaXRpb246IGNvbG9yIC4zcyB2YXIoLS1uLWJlemllcik7XG4gY29sb3I6IHZhcigtLW4taWNvbi1jb2xvcik7XG4gZm9udC1zaXplOiB2YXIoLS1uLWljb24tc2l6ZSk7XG4gYCldKSwgY0IoJ2Jhc2UtaWNvbicsIGBcbiBmb250LXNpemU6IHZhcigtLW4taWNvbi1zaXplKTtcbiBgKV0pLCBjQignaW5wdXQtd29yZC1jb3VudCcsIGBcbiBwb2ludGVyLWV2ZW50czogbm9uZTtcbiBsaW5lLWhlaWdodDogMS41O1xuIGZvbnQtc2l6ZTogLjg1ZW07XG4gY29sb3I6IHZhcigtLW4tY291bnQtdGV4dC1jb2xvcik7XG4gdHJhbnNpdGlvbjogY29sb3IgLjNzIHZhcigtLW4tYmV6aWVyKTtcbiBtYXJnaW4tbGVmdDogNHB4O1xuIGZvbnQtdmFyaWFudDogdGFidWxhci1udW1zO1xuIGApLCBbJ3dhcm5pbmcnLCAnZXJyb3InXS5tYXAoc3RhdHVzID0+IGNNKGAke3N0YXR1c30tc3RhdHVzYCwgW2NOb3RNKCdkaXNhYmxlZCcsIFtjQignYmFzZS1sb2FkaW5nJywgYFxuIGNvbG9yOiB2YXIoLS1uLWxvYWRpbmctY29sb3ItJHtzdGF0dXN9KVxuIGApLCBjRSgnaW5wdXQtZWwsIHRleHRhcmVhLWVsJywgYFxuIGNhcmV0LWNvbG9yOiB2YXIoLS1uLWNhcmV0LWNvbG9yLSR7c3RhdHVzfSk7XG4gYCksIGNFKCdzdGF0ZS1ib3JkZXInLCBgXG4gYm9yZGVyOiB2YXIoLS1uLWJvcmRlci0ke3N0YXR1c30pO1xuIGApLCBjKCcmOmhvdmVyJywgW2NFKCdzdGF0ZS1ib3JkZXInLCBgXG4gYm9yZGVyOiB2YXIoLS1uLWJvcmRlci1ob3Zlci0ke3N0YXR1c30pO1xuIGApXSksIGMoJyY6Zm9jdXMnLCBgXG4gYmFja2dyb3VuZC1jb2xvcjogdmFyKC0tbi1jb2xvci1mb2N1cy0ke3N0YXR1c30pO1xuIGAsIFtjRSgnc3RhdGUtYm9yZGVyJywgYFxuIGJveC1zaGFkb3c6IHZhcigtLW4tYm94LXNoYWRvdy1mb2N1cy0ke3N0YXR1c30pO1xuIGJvcmRlcjogdmFyKC0tbi1ib3JkZXItZm9jdXMtJHtzdGF0dXN9KTtcbiBgKV0pLCBjTSgnZm9jdXMnLCBgXG4gYmFja2dyb3VuZC1jb2xvcjogdmFyKC0tbi1jb2xvci1mb2N1cy0ke3N0YXR1c30pO1xuIGAsIFtjRSgnc3RhdGUtYm9yZGVyJywgYFxuIGJveC1zaGFkb3c6IHZhcigtLW4tYm94LXNoYWRvdy1mb2N1cy0ke3N0YXR1c30pO1xuIGJvcmRlcjogdmFyKC0tbi1ib3JkZXItZm9jdXMtJHtzdGF0dXN9KTtcbiBgKV0pXSldKSldKTtcbmV4cG9ydCBjb25zdCBzYWZhcmlTdHlsZSA9IGNCKCdpbnB1dCcsIFtjTSgnZGlzYWJsZWQnLCBbY0UoJ2lucHV0LWVsLCB0ZXh0YXJlYS1lbCcsIGBcbiAtd2Via2l0LXRleHQtZmlsbC1jb2xvcjogdmFyKC0tbi10ZXh0LWNvbG9yLWRpc2FibGVkKTtcbiBgKV0pXSk7IiwiaW1wb3J0IHsgcmVmLCB3YXRjaCB9IGZyb20gJ3Z1ZSc7XG5leHBvcnQgZnVuY3Rpb24gbGVuKHMpIHtcbiAgbGV0IGNvdW50ID0gMDtcbiAgZm9yIChjb25zdCBfIG9mIHMpIHtcbiAgICBjb3VudCsrO1xuICB9XG4gIHJldHVybiBjb3VudDtcbn1cbmV4cG9ydCBmdW5jdGlvbiBpc0VtcHR5SW5wdXRWYWx1ZSh2YWx1ZSkge1xuICByZXR1cm4gdmFsdWUgPT09ICcnIHx8IHZhbHVlID09IG51bGw7XG59XG5leHBvcnQgZnVuY3Rpb24gdXNlQ3Vyc29yKGlucHV0RWxSZWYpIHtcbiAgY29uc3Qgc2VsZWN0aW9uUmVmID0gcmVmKG51bGwpO1xuICBmdW5jdGlvbiByZWNvcmRDdXJzb3IoKSB7XG4gICAgY29uc3Qge1xuICAgICAgdmFsdWU6IGlucHV0XG4gICAgfSA9IGlucHV0RWxSZWY7XG4gICAgaWYgKCEoaW5wdXQgPT09IG51bGwgfHwgaW5wdXQgPT09IHZvaWQgMCA/IHZvaWQgMCA6IGlucHV0LmZvY3VzKSkge1xuICAgICAgcmVzZXQoKTtcbiAgICAgIHJldHVybjtcbiAgICB9XG4gICAgY29uc3Qge1xuICAgICAgc2VsZWN0aW9uU3RhcnQsXG4gICAgICBzZWxlY3Rpb25FbmQsXG4gICAgICB2YWx1ZVxuICAgIH0gPSBpbnB1dDtcbiAgICBpZiAoc2VsZWN0aW9uU3RhcnQgPT0gbnVsbCB8fCBzZWxlY3Rpb25FbmQgPT0gbnVsbCkge1xuICAgICAgcmVzZXQoKTtcbiAgICAgIHJldHVybjtcbiAgICB9XG4gICAgc2VsZWN0aW9uUmVmLnZhbHVlID0ge1xuICAgICAgc3RhcnQ6IHNlbGVjdGlvblN0YXJ0LFxuICAgICAgZW5kOiBzZWxlY3Rpb25FbmQsXG4gICAgICBiZWZvcmVUZXh0OiB2YWx1ZS5zbGljZSgwLCBzZWxlY3Rpb25TdGFydCksXG4gICAgICBhZnRlclRleHQ6IHZhbHVlLnNsaWNlKHNlbGVjdGlvbkVuZClcbiAgICB9O1xuICB9XG4gIGZ1bmN0aW9uIHJlc3RvcmVDdXJzb3IoKSB7XG4gICAgdmFyIF9hO1xuICAgIGNvbnN0IHtcbiAgICAgIHZhbHVlOiBzZWxlY3Rpb25cbiAgICB9ID0gc2VsZWN0aW9uUmVmO1xuICAgIGNvbnN0IHtcbiAgICAgIHZhbHVlOiBpbnB1dEVsXG4gICAgfSA9IGlucHV0RWxSZWY7XG4gICAgaWYgKCFzZWxlY3Rpb24gfHwgIWlucHV0RWwpIHtcbiAgICAgIHJldHVybjtcbiAgICB9XG4gICAgY29uc3Qge1xuICAgICAgdmFsdWVcbiAgICB9ID0gaW5wdXRFbDtcbiAgICBjb25zdCB7XG4gICAgICBzdGFydCxcbiAgICAgIGJlZm9yZVRleHQsXG4gICAgICBhZnRlclRleHRcbiAgICB9ID0gc2VsZWN0aW9uO1xuICAgIGxldCBzdGFydFBvcyA9IHZhbHVlLmxlbmd0aDtcbiAgICBpZiAodmFsdWUuZW5kc1dpdGgoYWZ0ZXJUZXh0KSkge1xuICAgICAgc3RhcnRQb3MgPSB2YWx1ZS5sZW5ndGggLSBhZnRlclRleHQubGVuZ3RoO1xuICAgIH0gZWxzZSBpZiAodmFsdWUuc3RhcnRzV2l0aChiZWZvcmVUZXh0KSkge1xuICAgICAgc3RhcnRQb3MgPSBiZWZvcmVUZXh0Lmxlbmd0aDtcbiAgICB9IGVsc2Uge1xuICAgICAgY29uc3QgYmVmb3JlTGFzdENoYXIgPSBiZWZvcmVUZXh0W3N0YXJ0IC0gMV07XG4gICAgICBjb25zdCBuZXdJbmRleCA9IHZhbHVlLmluZGV4T2YoYmVmb3JlTGFzdENoYXIsIHN0YXJ0IC0gMSk7XG4gICAgICBpZiAobmV3SW5kZXggIT09IC0xKSB7XG4gICAgICAgIHN0YXJ0UG9zID0gbmV3SW5kZXggKyAxO1xuICAgICAgfVxuICAgIH1cbiAgICAoX2EgPSBpbnB1dEVsLnNldFNlbGVjdGlvblJhbmdlKSA9PT0gbnVsbCB8fCBfYSA9PT0gdm9pZCAwID8gdm9pZCAwIDogX2EuY2FsbChpbnB1dEVsLCBzdGFydFBvcywgc3RhcnRQb3MpO1xuICB9XG4gIGZ1bmN0aW9uIHJlc2V0KCkge1xuICAgIHNlbGVjdGlvblJlZi52YWx1ZSA9IG51bGw7XG4gIH1cbiAgd2F0Y2goaW5wdXRFbFJlZiwgcmVzZXQpO1xuICByZXR1cm4ge1xuICAgIHJlY29yZEN1cnNvcixcbiAgICByZXN0b3JlQ3Vyc29yXG4gIH07XG59Il0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9