"use strict";
(self["webpackChunknearbeach"] = self["webpackChunknearbeach"] || []).push([["vendors-node_modules_naive-ui_es_popover_src_Popover_mjs"],{

/***/ "./node_modules/seemly/es/misc/index.js":
/*!**********************************************!*\
  !*** ./node_modules/seemly/es/misc/index.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createId: () => (/* binding */ createId),
/* harmony export */   indexMap: () => (/* binding */ indexMap),
/* harmony export */   repeat: () => (/* binding */ repeat),
/* harmony export */   sleep: () => (/* binding */ sleep)
/* harmony export */ });
function createId(length = 8) {
    return Math.random()
        .toString(16)
        .slice(2, 2 + length);
}
function repeat(count, v) {
    const ret = [];
    for (let i = 0; i < count; ++i) {
        ret.push(v);
    }
    return ret;
}
function indexMap(count, createValue) {
    const ret = [];
    if (!createValue) {
        for (let i = 0; i < count; ++i) {
            ret.push(i);
        }
        return ret;
    }
    for (let i = 0; i < count; ++i) {
        ret.push(createValue(i));
    }
    return ret;
}

async function sleep(ms) {
    return new Promise(resolve => {
        setTimeout(resolve, ms);
    });
}


/***/ }),

/***/ "./node_modules/vdirs/es/mousemoveoutside.js":
/*!***************************************************!*\
  !*** ./node_modules/vdirs/es/mousemoveoutside.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var evtd__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! evtd */ "./node_modules/evtd/es/delegate.js");

const ctxKey = '@@mmoContext';
const mousemoveoutside = {
    mounted(el, { value }) {
        el[ctxKey] = {
            handler: undefined
        };
        if (typeof value === 'function') {
            el[ctxKey].handler = value;
            (0,evtd__WEBPACK_IMPORTED_MODULE_0__.on)('mousemoveoutside', el, value);
        }
    },
    updated(el, { value }) {
        const ctx = el[ctxKey];
        if (typeof value === 'function') {
            if (ctx.handler) {
                if (ctx.handler !== value) {
                    (0,evtd__WEBPACK_IMPORTED_MODULE_0__.off)('mousemoveoutside', el, ctx.handler);
                    ctx.handler = value;
                    (0,evtd__WEBPACK_IMPORTED_MODULE_0__.on)('mousemoveoutside', el, value);
                }
            }
            else {
                el[ctxKey].handler = value;
                (0,evtd__WEBPACK_IMPORTED_MODULE_0__.on)('mousemoveoutside', el, value);
            }
        }
        else {
            if (ctx.handler) {
                (0,evtd__WEBPACK_IMPORTED_MODULE_0__.off)('mousemoveoutside', el, ctx.handler);
                ctx.handler = undefined;
            }
        }
    },
    unmounted(el) {
        const { handler } = el[ctxKey];
        if (handler) {
            (0,evtd__WEBPACK_IMPORTED_MODULE_0__.off)('mousemoveoutside', el, handler);
        }
        el[ctxKey].handler = undefined;
    }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (mousemoveoutside);


/***/ }),

/***/ "./node_modules/vooks/es/use-compitable.js":
/*!*************************************************!*\
  !*** ./node_modules/vooks/es/use-compitable.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useCompitable)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");

function useCompitable(reactive, keys) {
    // @ts-expect-error
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
        for (const key of keys) {
            if (reactive[key] !== undefined)
                return reactive[key];
        }
        return reactive[keys[keys.length - 1]];
    });
}


/***/ }),

/***/ "./node_modules/vueuc/es/focus-trap/src/index.js":
/*!*******************************************************!*\
  !*** ./node_modules/vueuc/es/focus-trap/src/index.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FocusTrap: () => (/* binding */ FocusTrap)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/misc/index.js");
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/dom/get-precise-event-target.js");
/* harmony import */ var evtd__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! evtd */ "./node_modules/evtd/es/delegate.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./utils */ "./node_modules/vueuc/es/focus-trap/src/utils.js");
/* harmony import */ var _shared__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../shared */ "./node_modules/vueuc/es/shared/resolve-to.js");





let stack = [];
const FocusTrap = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
    name: 'FocusTrap',
    props: {
        disabled: Boolean,
        active: Boolean,
        autoFocus: {
            type: Boolean,
            default: true
        },
        onEsc: Function,
        initialFocusTo: String,
        finalFocusTo: String,
        returnFocusOnDeactivated: {
            type: Boolean,
            default: true
        }
    },
    setup(props) {
        const id = (0,seemly__WEBPACK_IMPORTED_MODULE_1__.createId)();
        const focusableStartRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const focusableEndRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        let activated = false;
        let ignoreInternalFocusChange = false;
        const lastFocusedElement = typeof document === 'undefined' ? null : document.activeElement;
        function isCurrentActive() {
            const currentActiveId = stack[stack.length - 1];
            return currentActiveId === id;
        }
        function handleDocumentKeydown(e) {
            var _a;
            if (e.code === 'Escape') {
                if (isCurrentActive()) {
                    (_a = props.onEsc) === null || _a === void 0 ? void 0 : _a.call(props, e);
                }
            }
        }
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(() => {
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(() => props.active, (value) => {
                if (value) {
                    activate();
                    (0,evtd__WEBPACK_IMPORTED_MODULE_2__.on)('keydown', document, handleDocumentKeydown);
                }
                else {
                    (0,evtd__WEBPACK_IMPORTED_MODULE_2__.off)('keydown', document, handleDocumentKeydown);
                    if (activated) {
                        deactivate();
                    }
                }
            }, {
                immediate: true
            });
        });
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.onBeforeUnmount)(() => {
            (0,evtd__WEBPACK_IMPORTED_MODULE_2__.off)('keydown', document, handleDocumentKeydown);
            if (activated)
                deactivate();
        });
        function handleDocumentFocus(e) {
            if (ignoreInternalFocusChange)
                return;
            if (isCurrentActive()) {
                const mainEl = getMainEl();
                if (mainEl === null)
                    return;
                if (mainEl.contains((0,seemly__WEBPACK_IMPORTED_MODULE_3__.getPreciseEventTarget)(e)))
                    return;
                // I don't handle shift + tab status since it's too tricky to handle
                // Not impossible but I need to sleep
                resetFocusTo('first');
            }
        }
        function getMainEl() {
            const focusableStartEl = focusableStartRef.value;
            if (focusableStartEl === null)
                return null;
            let mainEl = focusableStartEl;
            while (true) {
                mainEl = mainEl.nextSibling;
                if (mainEl === null)
                    break;
                if (mainEl instanceof Element && mainEl.tagName === 'DIV') {
                    break;
                }
            }
            return mainEl;
        }
        function activate() {
            var _a;
            if (props.disabled)
                return;
            stack.push(id);
            if (props.autoFocus) {
                const { initialFocusTo } = props;
                if (initialFocusTo === undefined) {
                    resetFocusTo('first');
                }
                else {
                    (_a = (0,_shared__WEBPACK_IMPORTED_MODULE_4__.resolveTo)(initialFocusTo)) === null || _a === void 0 ? void 0 : _a.focus({ preventScroll: true });
                }
            }
            activated = true;
            document.addEventListener('focus', handleDocumentFocus, true);
        }
        function deactivate() {
            var _a;
            if (props.disabled)
                return;
            document.removeEventListener('focus', handleDocumentFocus, true);
            stack = stack.filter((idInStack) => idInStack !== id);
            if (isCurrentActive())
                return;
            const { finalFocusTo } = props;
            if (finalFocusTo !== undefined) {
                (_a = (0,_shared__WEBPACK_IMPORTED_MODULE_4__.resolveTo)(finalFocusTo)) === null || _a === void 0 ? void 0 : _a.focus({ preventScroll: true });
            }
            else if (props.returnFocusOnDeactivated) {
                if (lastFocusedElement instanceof HTMLElement) {
                    ignoreInternalFocusChange = true;
                    lastFocusedElement.focus({ preventScroll: true });
                    ignoreInternalFocusChange = false;
                }
            }
        }
        function resetFocusTo(target) {
            if (!isCurrentActive())
                return;
            if (props.active) {
                const focusableStartEl = focusableStartRef.value;
                const focusableEndEl = focusableEndRef.value;
                if (focusableStartEl !== null && focusableEndEl !== null) {
                    const mainEl = getMainEl();
                    if (mainEl == null || mainEl === focusableEndEl) {
                        ignoreInternalFocusChange = true;
                        focusableStartEl.focus({ preventScroll: true });
                        ignoreInternalFocusChange = false;
                        return;
                    }
                    ignoreInternalFocusChange = true;
                    const focused = target === 'first'
                        ? (0,_utils__WEBPACK_IMPORTED_MODULE_5__.focusFirstDescendant)(mainEl)
                        : (0,_utils__WEBPACK_IMPORTED_MODULE_5__.focusLastDescendant)(mainEl);
                    ignoreInternalFocusChange = false;
                    if (!focused) {
                        ignoreInternalFocusChange = true;
                        focusableStartEl.focus({ preventScroll: true });
                        ignoreInternalFocusChange = false;
                    }
                }
            }
        }
        function handleStartFocus(e) {
            if (ignoreInternalFocusChange)
                return;
            const mainEl = getMainEl();
            if (mainEl === null)
                return;
            if (e.relatedTarget !== null && mainEl.contains(e.relatedTarget)) {
                // if it comes from inner, focus last
                resetFocusTo('last');
            }
            else {
                // otherwise focus first
                resetFocusTo('first');
            }
        }
        function handleEndFocus(e) {
            if (ignoreInternalFocusChange)
                return;
            if (e.relatedTarget !== null &&
                e.relatedTarget === focusableStartRef.value) {
                // if it comes from first, focus last
                resetFocusTo('last');
            }
            else {
                // otherwise focus first
                resetFocusTo('first');
            }
        }
        return {
            focusableStartRef,
            focusableEndRef,
            focusableStyle: 'position: absolute; height: 0; width: 0;',
            handleStartFocus,
            handleEndFocus
        };
    },
    render() {
        const { default: defaultSlot } = this.$slots;
        if (defaultSlot === undefined)
            return null;
        if (this.disabled)
            return defaultSlot();
        const { active, focusableStyle } = this;
        return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, [
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)('div', {
                'aria-hidden': 'true',
                tabindex: active ? '0' : '-1',
                ref: 'focusableStartRef',
                style: focusableStyle,
                onFocus: this.handleStartFocus
            }),
            defaultSlot(),
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)('div', {
                'aria-hidden': 'true',
                style: focusableStyle,
                ref: 'focusableEndRef',
                tabindex: active ? '0' : '-1',
                onFocus: this.handleEndFocus
            })
        ]);
    }
});


/***/ }),

/***/ "./node_modules/vueuc/es/focus-trap/src/utils.js":
/*!*******************************************************!*\
  !*** ./node_modules/vueuc/es/focus-trap/src/utils.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   focusFirstDescendant: () => (/* binding */ focusFirstDescendant),
/* harmony export */   focusLastDescendant: () => (/* binding */ focusLastDescendant)
/* harmony export */ });
/* eslint-disable @typescript-eslint/strict-boolean-expressions */
// ref https://www.w3.org/TR/wai-aria-practices-1.1/examples/dialog-modal/js/dialog.js
function isHTMLElement(node) {
    return node instanceof HTMLElement;
}
function focusFirstDescendant(node) {
    for (let i = 0; i < node.childNodes.length; i++) {
        const child = node.childNodes[i];
        if (isHTMLElement(child)) {
            if (attemptFocus(child) || focusFirstDescendant(child)) {
                return true;
            }
        }
    }
    return false;
}
function focusLastDescendant(element) {
    for (let i = element.childNodes.length - 1; i >= 0; i--) {
        const child = element.childNodes[i];
        if (isHTMLElement(child)) {
            if (attemptFocus(child) || focusLastDescendant(child)) {
                return true;
            }
        }
    }
    return false;
}
function attemptFocus(element) {
    if (!isFocusable(element)) {
        return false;
    }
    try {
        element.focus({ preventScroll: true });
    }
    catch (e) { }
    return document.activeElement === element;
}
function isFocusable(element) {
    if (element.tabIndex > 0 ||
        (element.tabIndex === 0 && element.getAttribute('tabIndex') !== null)) {
        return true;
    }
    if (element.getAttribute('disabled')) {
        return false;
    }
    switch (element.nodeName) {
        case 'A':
            return (!!element.href &&
                element.rel !== 'ignore');
        case 'INPUT':
            return (element.type !== 'hidden' &&
                element.type !== 'file');
        case 'BUTTON':
        case 'SELECT':
        case 'TEXTAREA':
            return true;
        default:
            return false;
    }
}


/***/ }),

/***/ "./node_modules/vueuc/es/shared/resolve-to.js":
/*!****************************************************!*\
  !*** ./node_modules/vueuc/es/shared/resolve-to.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   resolveTo: () => (/* binding */ resolveTo)
/* harmony export */ });
function resolveTo(selector) {
    if (typeof selector === 'string') {
        return document.querySelector(selector);
    }
    return selector();
}


/***/ }),

/***/ "./node_modules/lodash-es/_DataView.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash-es/_DataView.js ***!
  \*********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _getNative_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_getNative.js */ "./node_modules/lodash-es/_getNative.js");
/* harmony import */ var _root_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_root.js */ "./node_modules/lodash-es/_root.js");



/* Built-in method references that are verified to be native. */
var DataView = (0,_getNative_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_root_js__WEBPACK_IMPORTED_MODULE_1__["default"], 'DataView');

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DataView);


/***/ }),

/***/ "./node_modules/lodash-es/_Promise.js":
/*!********************************************!*\
  !*** ./node_modules/lodash-es/_Promise.js ***!
  \********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _getNative_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_getNative.js */ "./node_modules/lodash-es/_getNative.js");
/* harmony import */ var _root_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_root.js */ "./node_modules/lodash-es/_root.js");



/* Built-in method references that are verified to be native. */
var Promise = (0,_getNative_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_root_js__WEBPACK_IMPORTED_MODULE_1__["default"], 'Promise');

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Promise);


/***/ }),

/***/ "./node_modules/lodash-es/_Set.js":
/*!****************************************!*\
  !*** ./node_modules/lodash-es/_Set.js ***!
  \****************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _getNative_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_getNative.js */ "./node_modules/lodash-es/_getNative.js");
/* harmony import */ var _root_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_root.js */ "./node_modules/lodash-es/_root.js");



/* Built-in method references that are verified to be native. */
var Set = (0,_getNative_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_root_js__WEBPACK_IMPORTED_MODULE_1__["default"], 'Set');

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Set);


/***/ }),

/***/ "./node_modules/lodash-es/_SetCache.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash-es/_SetCache.js ***!
  \*********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _MapCache_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_MapCache.js */ "./node_modules/lodash-es/_MapCache.js");
/* harmony import */ var _setCacheAdd_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_setCacheAdd.js */ "./node_modules/lodash-es/_setCacheAdd.js");
/* harmony import */ var _setCacheHas_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_setCacheHas.js */ "./node_modules/lodash-es/_setCacheHas.js");




/**
 *
 * Creates an array cache object to store unique values.
 *
 * @private
 * @constructor
 * @param {Array} [values] The values to cache.
 */
function SetCache(values) {
  var index = -1,
      length = values == null ? 0 : values.length;

  this.__data__ = new _MapCache_js__WEBPACK_IMPORTED_MODULE_0__["default"];
  while (++index < length) {
    this.add(values[index]);
  }
}

// Add methods to `SetCache`.
SetCache.prototype.add = SetCache.prototype.push = _setCacheAdd_js__WEBPACK_IMPORTED_MODULE_1__["default"];
SetCache.prototype.has = _setCacheHas_js__WEBPACK_IMPORTED_MODULE_2__["default"];

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SetCache);


/***/ }),

/***/ "./node_modules/lodash-es/_WeakMap.js":
/*!********************************************!*\
  !*** ./node_modules/lodash-es/_WeakMap.js ***!
  \********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _getNative_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_getNative.js */ "./node_modules/lodash-es/_getNative.js");
/* harmony import */ var _root_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_root.js */ "./node_modules/lodash-es/_root.js");



/* Built-in method references that are verified to be native. */
var WeakMap = (0,_getNative_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_root_js__WEBPACK_IMPORTED_MODULE_1__["default"], 'WeakMap');

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (WeakMap);


/***/ }),

/***/ "./node_modules/lodash-es/_arrayFilter.js":
/*!************************************************!*\
  !*** ./node_modules/lodash-es/_arrayFilter.js ***!
  \************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * A specialized version of `_.filter` for arrays without support for
 * iteratee shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {Array} Returns the new filtered array.
 */
function arrayFilter(array, predicate) {
  var index = -1,
      length = array == null ? 0 : array.length,
      resIndex = 0,
      result = [];

  while (++index < length) {
    var value = array[index];
    if (predicate(value, index, array)) {
      result[resIndex++] = value;
    }
  }
  return result;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (arrayFilter);


/***/ }),

/***/ "./node_modules/lodash-es/_arrayPush.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash-es/_arrayPush.js ***!
  \**********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Appends the elements of `values` to `array`.
 *
 * @private
 * @param {Array} array The array to modify.
 * @param {Array} values The values to append.
 * @returns {Array} Returns `array`.
 */
function arrayPush(array, values) {
  var index = -1,
      length = values.length,
      offset = array.length;

  while (++index < length) {
    array[offset + index] = values[index];
  }
  return array;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (arrayPush);


/***/ }),

/***/ "./node_modules/lodash-es/_arraySome.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash-es/_arraySome.js ***!
  \**********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * A specialized version of `_.some` for arrays without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {boolean} Returns `true` if any element passes the predicate check,
 *  else `false`.
 */
function arraySome(array, predicate) {
  var index = -1,
      length = array == null ? 0 : array.length;

  while (++index < length) {
    if (predicate(array[index], index, array)) {
      return true;
    }
  }
  return false;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (arraySome);


/***/ }),

/***/ "./node_modules/lodash-es/_baseEach.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash-es/_baseEach.js ***!
  \*********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _baseForOwn_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_baseForOwn.js */ "./node_modules/lodash-es/_baseForOwn.js");
/* harmony import */ var _createBaseEach_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_createBaseEach.js */ "./node_modules/lodash-es/_createBaseEach.js");



/**
 * The base implementation of `_.forEach` without support for iteratee shorthands.
 *
 * @private
 * @param {Array|Object} collection The collection to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array|Object} Returns `collection`.
 */
var baseEach = (0,_createBaseEach_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_baseForOwn_js__WEBPACK_IMPORTED_MODULE_1__["default"]);

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (baseEach);


/***/ }),

/***/ "./node_modules/lodash-es/_baseForOwn.js":
/*!***********************************************!*\
  !*** ./node_modules/lodash-es/_baseForOwn.js ***!
  \***********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _baseFor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_baseFor.js */ "./node_modules/lodash-es/_baseFor.js");
/* harmony import */ var _keys_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./keys.js */ "./node_modules/lodash-es/keys.js");



/**
 * The base implementation of `_.forOwn` without support for iteratee shorthands.
 *
 * @private
 * @param {Object} object The object to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Object} Returns `object`.
 */
function baseForOwn(object, iteratee) {
  return object && (0,_baseFor_js__WEBPACK_IMPORTED_MODULE_0__["default"])(object, iteratee, _keys_js__WEBPACK_IMPORTED_MODULE_1__["default"]);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (baseForOwn);


/***/ }),

/***/ "./node_modules/lodash-es/_baseGet.js":
/*!********************************************!*\
  !*** ./node_modules/lodash-es/_baseGet.js ***!
  \********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _castPath_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_castPath.js */ "./node_modules/lodash-es/_castPath.js");
/* harmony import */ var _toKey_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_toKey.js */ "./node_modules/lodash-es/_toKey.js");



/**
 * The base implementation of `_.get` without support for default values.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Array|string} path The path of the property to get.
 * @returns {*} Returns the resolved value.
 */
function baseGet(object, path) {
  path = (0,_castPath_js__WEBPACK_IMPORTED_MODULE_0__["default"])(path, object);

  var index = 0,
      length = path.length;

  while (object != null && index < length) {
    object = object[(0,_toKey_js__WEBPACK_IMPORTED_MODULE_1__["default"])(path[index++])];
  }
  return (index && index == length) ? object : undefined;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (baseGet);


/***/ }),

/***/ "./node_modules/lodash-es/_baseGetAllKeys.js":
/*!***************************************************!*\
  !*** ./node_modules/lodash-es/_baseGetAllKeys.js ***!
  \***************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _arrayPush_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_arrayPush.js */ "./node_modules/lodash-es/_arrayPush.js");
/* harmony import */ var _isArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isArray.js */ "./node_modules/lodash-es/isArray.js");



/**
 * The base implementation of `getAllKeys` and `getAllKeysIn` which uses
 * `keysFunc` and `symbolsFunc` to get the enumerable property names and
 * symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Function} keysFunc The function to get the keys of `object`.
 * @param {Function} symbolsFunc The function to get the symbols of `object`.
 * @returns {Array} Returns the array of property names and symbols.
 */
function baseGetAllKeys(object, keysFunc, symbolsFunc) {
  var result = keysFunc(object);
  return (0,_isArray_js__WEBPACK_IMPORTED_MODULE_0__["default"])(object) ? result : (0,_arrayPush_js__WEBPACK_IMPORTED_MODULE_1__["default"])(result, symbolsFunc(object));
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (baseGetAllKeys);


/***/ }),

/***/ "./node_modules/lodash-es/_baseHasIn.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash-es/_baseHasIn.js ***!
  \**********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * The base implementation of `_.hasIn` without support for deep paths.
 *
 * @private
 * @param {Object} [object] The object to query.
 * @param {Array|string} key The key to check.
 * @returns {boolean} Returns `true` if `key` exists, else `false`.
 */
function baseHasIn(object, key) {
  return object != null && key in Object(object);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (baseHasIn);


/***/ }),

/***/ "./node_modules/lodash-es/_baseIsEqual.js":
/*!************************************************!*\
  !*** ./node_modules/lodash-es/_baseIsEqual.js ***!
  \************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _baseIsEqualDeep_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_baseIsEqualDeep.js */ "./node_modules/lodash-es/_baseIsEqualDeep.js");
/* harmony import */ var _isObjectLike_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isObjectLike.js */ "./node_modules/lodash-es/isObjectLike.js");



/**
 * The base implementation of `_.isEqual` which supports partial comparisons
 * and tracks traversed objects.
 *
 * @private
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @param {boolean} bitmask The bitmask flags.
 *  1 - Unordered comparison
 *  2 - Partial comparison
 * @param {Function} [customizer] The function to customize comparisons.
 * @param {Object} [stack] Tracks traversed `value` and `other` objects.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 */
function baseIsEqual(value, other, bitmask, customizer, stack) {
  if (value === other) {
    return true;
  }
  if (value == null || other == null || (!(0,_isObjectLike_js__WEBPACK_IMPORTED_MODULE_0__["default"])(value) && !(0,_isObjectLike_js__WEBPACK_IMPORTED_MODULE_0__["default"])(other))) {
    return value !== value && other !== other;
  }
  return (0,_baseIsEqualDeep_js__WEBPACK_IMPORTED_MODULE_1__["default"])(value, other, bitmask, customizer, baseIsEqual, stack);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (baseIsEqual);


/***/ }),

/***/ "./node_modules/lodash-es/_baseIsEqualDeep.js":
/*!****************************************************!*\
  !*** ./node_modules/lodash-es/_baseIsEqualDeep.js ***!
  \****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Stack_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./_Stack.js */ "./node_modules/lodash-es/_Stack.js");
/* harmony import */ var _equalArrays_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./_equalArrays.js */ "./node_modules/lodash-es/_equalArrays.js");
/* harmony import */ var _equalByTag_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./_equalByTag.js */ "./node_modules/lodash-es/_equalByTag.js");
/* harmony import */ var _equalObjects_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./_equalObjects.js */ "./node_modules/lodash-es/_equalObjects.js");
/* harmony import */ var _getTag_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_getTag.js */ "./node_modules/lodash-es/_getTag.js");
/* harmony import */ var _isArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isArray.js */ "./node_modules/lodash-es/isArray.js");
/* harmony import */ var _isBuffer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./isBuffer.js */ "./node_modules/lodash-es/isBuffer.js");
/* harmony import */ var _isTypedArray_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./isTypedArray.js */ "./node_modules/lodash-es/isTypedArray.js");









/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1;

/** `Object#toString` result references. */
var argsTag = '[object Arguments]',
    arrayTag = '[object Array]',
    objectTag = '[object Object]';

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * A specialized version of `baseIsEqual` for arrays and objects which performs
 * deep comparisons and tracks traversed objects enabling objects with circular
 * references to be compared.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} [stack] Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {
  var objIsArr = (0,_isArray_js__WEBPACK_IMPORTED_MODULE_0__["default"])(object),
      othIsArr = (0,_isArray_js__WEBPACK_IMPORTED_MODULE_0__["default"])(other),
      objTag = objIsArr ? arrayTag : (0,_getTag_js__WEBPACK_IMPORTED_MODULE_1__["default"])(object),
      othTag = othIsArr ? arrayTag : (0,_getTag_js__WEBPACK_IMPORTED_MODULE_1__["default"])(other);

  objTag = objTag == argsTag ? objectTag : objTag;
  othTag = othTag == argsTag ? objectTag : othTag;

  var objIsObj = objTag == objectTag,
      othIsObj = othTag == objectTag,
      isSameTag = objTag == othTag;

  if (isSameTag && (0,_isBuffer_js__WEBPACK_IMPORTED_MODULE_2__["default"])(object)) {
    if (!(0,_isBuffer_js__WEBPACK_IMPORTED_MODULE_2__["default"])(other)) {
      return false;
    }
    objIsArr = true;
    objIsObj = false;
  }
  if (isSameTag && !objIsObj) {
    stack || (stack = new _Stack_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
    return (objIsArr || (0,_isTypedArray_js__WEBPACK_IMPORTED_MODULE_4__["default"])(object))
      ? (0,_equalArrays_js__WEBPACK_IMPORTED_MODULE_5__["default"])(object, other, bitmask, customizer, equalFunc, stack)
      : (0,_equalByTag_js__WEBPACK_IMPORTED_MODULE_6__["default"])(object, other, objTag, bitmask, customizer, equalFunc, stack);
  }
  if (!(bitmask & COMPARE_PARTIAL_FLAG)) {
    var objIsWrapped = objIsObj && hasOwnProperty.call(object, '__wrapped__'),
        othIsWrapped = othIsObj && hasOwnProperty.call(other, '__wrapped__');

    if (objIsWrapped || othIsWrapped) {
      var objUnwrapped = objIsWrapped ? object.value() : object,
          othUnwrapped = othIsWrapped ? other.value() : other;

      stack || (stack = new _Stack_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
      return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
    }
  }
  if (!isSameTag) {
    return false;
  }
  stack || (stack = new _Stack_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
  return (0,_equalObjects_js__WEBPACK_IMPORTED_MODULE_7__["default"])(object, other, bitmask, customizer, equalFunc, stack);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (baseIsEqualDeep);


/***/ }),

/***/ "./node_modules/lodash-es/_baseIsMatch.js":
/*!************************************************!*\
  !*** ./node_modules/lodash-es/_baseIsMatch.js ***!
  \************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Stack_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_Stack.js */ "./node_modules/lodash-es/_Stack.js");
/* harmony import */ var _baseIsEqual_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_baseIsEqual.js */ "./node_modules/lodash-es/_baseIsEqual.js");



/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1,
    COMPARE_UNORDERED_FLAG = 2;

/**
 * The base implementation of `_.isMatch` without support for iteratee shorthands.
 *
 * @private
 * @param {Object} object The object to inspect.
 * @param {Object} source The object of property values to match.
 * @param {Array} matchData The property names, values, and compare flags to match.
 * @param {Function} [customizer] The function to customize comparisons.
 * @returns {boolean} Returns `true` if `object` is a match, else `false`.
 */
function baseIsMatch(object, source, matchData, customizer) {
  var index = matchData.length,
      length = index,
      noCustomizer = !customizer;

  if (object == null) {
    return !length;
  }
  object = Object(object);
  while (index--) {
    var data = matchData[index];
    if ((noCustomizer && data[2])
          ? data[1] !== object[data[0]]
          : !(data[0] in object)
        ) {
      return false;
    }
  }
  while (++index < length) {
    data = matchData[index];
    var key = data[0],
        objValue = object[key],
        srcValue = data[1];

    if (noCustomizer && data[2]) {
      if (objValue === undefined && !(key in object)) {
        return false;
      }
    } else {
      var stack = new _Stack_js__WEBPACK_IMPORTED_MODULE_0__["default"];
      if (customizer) {
        var result = customizer(objValue, srcValue, key, object, source, stack);
      }
      if (!(result === undefined
            ? (0,_baseIsEqual_js__WEBPACK_IMPORTED_MODULE_1__["default"])(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG, customizer, stack)
            : result
          )) {
        return false;
      }
    }
  }
  return true;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (baseIsMatch);


/***/ }),

/***/ "./node_modules/lodash-es/_baseIteratee.js":
/*!*************************************************!*\
  !*** ./node_modules/lodash-es/_baseIteratee.js ***!
  \*************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _baseMatches_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./_baseMatches.js */ "./node_modules/lodash-es/_baseMatches.js");
/* harmony import */ var _baseMatchesProperty_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_baseMatchesProperty.js */ "./node_modules/lodash-es/_baseMatchesProperty.js");
/* harmony import */ var _identity_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./identity.js */ "./node_modules/lodash-es/identity.js");
/* harmony import */ var _isArray_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./isArray.js */ "./node_modules/lodash-es/isArray.js");
/* harmony import */ var _property_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./property.js */ "./node_modules/lodash-es/property.js");






/**
 * The base implementation of `_.iteratee`.
 *
 * @private
 * @param {*} [value=_.identity] The value to convert to an iteratee.
 * @returns {Function} Returns the iteratee.
 */
function baseIteratee(value) {
  // Don't store the `typeof` result in a variable to avoid a JIT bug in Safari 9.
  // See https://bugs.webkit.org/show_bug.cgi?id=156034 for more details.
  if (typeof value == 'function') {
    return value;
  }
  if (value == null) {
    return _identity_js__WEBPACK_IMPORTED_MODULE_0__["default"];
  }
  if (typeof value == 'object') {
    return (0,_isArray_js__WEBPACK_IMPORTED_MODULE_1__["default"])(value)
      ? (0,_baseMatchesProperty_js__WEBPACK_IMPORTED_MODULE_2__["default"])(value[0], value[1])
      : (0,_baseMatches_js__WEBPACK_IMPORTED_MODULE_3__["default"])(value);
  }
  return (0,_property_js__WEBPACK_IMPORTED_MODULE_4__["default"])(value);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (baseIteratee);


/***/ }),

/***/ "./node_modules/lodash-es/_baseKeys.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash-es/_baseKeys.js ***!
  \*********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _isPrototype_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_isPrototype.js */ "./node_modules/lodash-es/_isPrototype.js");
/* harmony import */ var _nativeKeys_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_nativeKeys.js */ "./node_modules/lodash-es/_nativeKeys.js");



/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * The base implementation of `_.keys` which doesn't treat sparse arrays as dense.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function baseKeys(object) {
  if (!(0,_isPrototype_js__WEBPACK_IMPORTED_MODULE_0__["default"])(object)) {
    return (0,_nativeKeys_js__WEBPACK_IMPORTED_MODULE_1__["default"])(object);
  }
  var result = [];
  for (var key in Object(object)) {
    if (hasOwnProperty.call(object, key) && key != 'constructor') {
      result.push(key);
    }
  }
  return result;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (baseKeys);


/***/ }),

/***/ "./node_modules/lodash-es/_baseMap.js":
/*!********************************************!*\
  !*** ./node_modules/lodash-es/_baseMap.js ***!
  \********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _baseEach_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_baseEach.js */ "./node_modules/lodash-es/_baseEach.js");
/* harmony import */ var _isArrayLike_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isArrayLike.js */ "./node_modules/lodash-es/isArrayLike.js");



/**
 * The base implementation of `_.map` without support for iteratee shorthands.
 *
 * @private
 * @param {Array|Object} collection The collection to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the new mapped array.
 */
function baseMap(collection, iteratee) {
  var index = -1,
      result = (0,_isArrayLike_js__WEBPACK_IMPORTED_MODULE_0__["default"])(collection) ? Array(collection.length) : [];

  (0,_baseEach_js__WEBPACK_IMPORTED_MODULE_1__["default"])(collection, function(value, key, collection) {
    result[++index] = iteratee(value, key, collection);
  });
  return result;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (baseMap);


/***/ }),

/***/ "./node_modules/lodash-es/_baseMatches.js":
/*!************************************************!*\
  !*** ./node_modules/lodash-es/_baseMatches.js ***!
  \************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _baseIsMatch_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_baseIsMatch.js */ "./node_modules/lodash-es/_baseIsMatch.js");
/* harmony import */ var _getMatchData_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_getMatchData.js */ "./node_modules/lodash-es/_getMatchData.js");
/* harmony import */ var _matchesStrictComparable_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_matchesStrictComparable.js */ "./node_modules/lodash-es/_matchesStrictComparable.js");




/**
 * The base implementation of `_.matches` which doesn't clone `source`.
 *
 * @private
 * @param {Object} source The object of property values to match.
 * @returns {Function} Returns the new spec function.
 */
function baseMatches(source) {
  var matchData = (0,_getMatchData_js__WEBPACK_IMPORTED_MODULE_0__["default"])(source);
  if (matchData.length == 1 && matchData[0][2]) {
    return (0,_matchesStrictComparable_js__WEBPACK_IMPORTED_MODULE_1__["default"])(matchData[0][0], matchData[0][1]);
  }
  return function(object) {
    return object === source || (0,_baseIsMatch_js__WEBPACK_IMPORTED_MODULE_2__["default"])(object, source, matchData);
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (baseMatches);


/***/ }),

/***/ "./node_modules/lodash-es/_baseMatchesProperty.js":
/*!********************************************************!*\
  !*** ./node_modules/lodash-es/_baseMatchesProperty.js ***!
  \********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _baseIsEqual_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./_baseIsEqual.js */ "./node_modules/lodash-es/_baseIsEqual.js");
/* harmony import */ var _get_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./get.js */ "./node_modules/lodash-es/get.js");
/* harmony import */ var _hasIn_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./hasIn.js */ "./node_modules/lodash-es/hasIn.js");
/* harmony import */ var _isKey_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_isKey.js */ "./node_modules/lodash-es/_isKey.js");
/* harmony import */ var _isStrictComparable_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_isStrictComparable.js */ "./node_modules/lodash-es/_isStrictComparable.js");
/* harmony import */ var _matchesStrictComparable_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_matchesStrictComparable.js */ "./node_modules/lodash-es/_matchesStrictComparable.js");
/* harmony import */ var _toKey_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./_toKey.js */ "./node_modules/lodash-es/_toKey.js");








/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1,
    COMPARE_UNORDERED_FLAG = 2;

/**
 * The base implementation of `_.matchesProperty` which doesn't clone `srcValue`.
 *
 * @private
 * @param {string} path The path of the property to get.
 * @param {*} srcValue The value to match.
 * @returns {Function} Returns the new spec function.
 */
function baseMatchesProperty(path, srcValue) {
  if ((0,_isKey_js__WEBPACK_IMPORTED_MODULE_0__["default"])(path) && (0,_isStrictComparable_js__WEBPACK_IMPORTED_MODULE_1__["default"])(srcValue)) {
    return (0,_matchesStrictComparable_js__WEBPACK_IMPORTED_MODULE_2__["default"])((0,_toKey_js__WEBPACK_IMPORTED_MODULE_3__["default"])(path), srcValue);
  }
  return function(object) {
    var objValue = (0,_get_js__WEBPACK_IMPORTED_MODULE_4__["default"])(object, path);
    return (objValue === undefined && objValue === srcValue)
      ? (0,_hasIn_js__WEBPACK_IMPORTED_MODULE_5__["default"])(object, path)
      : (0,_baseIsEqual_js__WEBPACK_IMPORTED_MODULE_6__["default"])(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG);
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (baseMatchesProperty);


/***/ }),

/***/ "./node_modules/lodash-es/_baseProperty.js":
/*!*************************************************!*\
  !*** ./node_modules/lodash-es/_baseProperty.js ***!
  \*************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * The base implementation of `_.property` without support for deep paths.
 *
 * @private
 * @param {string} key The key of the property to get.
 * @returns {Function} Returns the new accessor function.
 */
function baseProperty(key) {
  return function(object) {
    return object == null ? undefined : object[key];
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (baseProperty);


/***/ }),

/***/ "./node_modules/lodash-es/_basePropertyDeep.js":
/*!*****************************************************!*\
  !*** ./node_modules/lodash-es/_basePropertyDeep.js ***!
  \*****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _baseGet_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_baseGet.js */ "./node_modules/lodash-es/_baseGet.js");


/**
 * A specialized version of `baseProperty` which supports deep paths.
 *
 * @private
 * @param {Array|string} path The path of the property to get.
 * @returns {Function} Returns the new accessor function.
 */
function basePropertyDeep(path) {
  return function(object) {
    return (0,_baseGet_js__WEBPACK_IMPORTED_MODULE_0__["default"])(object, path);
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (basePropertyDeep);


/***/ }),

/***/ "./node_modules/lodash-es/_cacheHas.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash-es/_cacheHas.js ***!
  \*********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Checks if a `cache` value for `key` exists.
 *
 * @private
 * @param {Object} cache The cache to query.
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function cacheHas(cache, key) {
  return cache.has(key);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (cacheHas);


/***/ }),

/***/ "./node_modules/lodash-es/_castPath.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash-es/_castPath.js ***!
  \*********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _isArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isArray.js */ "./node_modules/lodash-es/isArray.js");
/* harmony import */ var _isKey_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_isKey.js */ "./node_modules/lodash-es/_isKey.js");
/* harmony import */ var _stringToPath_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_stringToPath.js */ "./node_modules/lodash-es/_stringToPath.js");
/* harmony import */ var _toString_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./toString.js */ "./node_modules/lodash-es/toString.js");





/**
 * Casts `value` to a path array if it's not one.
 *
 * @private
 * @param {*} value The value to inspect.
 * @param {Object} [object] The object to query keys on.
 * @returns {Array} Returns the cast property path array.
 */
function castPath(value, object) {
  if ((0,_isArray_js__WEBPACK_IMPORTED_MODULE_0__["default"])(value)) {
    return value;
  }
  return (0,_isKey_js__WEBPACK_IMPORTED_MODULE_1__["default"])(value, object) ? [value] : (0,_stringToPath_js__WEBPACK_IMPORTED_MODULE_2__["default"])((0,_toString_js__WEBPACK_IMPORTED_MODULE_3__["default"])(value));
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (castPath);


/***/ }),

/***/ "./node_modules/lodash-es/_createBaseEach.js":
/*!***************************************************!*\
  !*** ./node_modules/lodash-es/_createBaseEach.js ***!
  \***************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _isArrayLike_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isArrayLike.js */ "./node_modules/lodash-es/isArrayLike.js");


/**
 * Creates a `baseEach` or `baseEachRight` function.
 *
 * @private
 * @param {Function} eachFunc The function to iterate over a collection.
 * @param {boolean} [fromRight] Specify iterating from right to left.
 * @returns {Function} Returns the new base function.
 */
function createBaseEach(eachFunc, fromRight) {
  return function(collection, iteratee) {
    if (collection == null) {
      return collection;
    }
    if (!(0,_isArrayLike_js__WEBPACK_IMPORTED_MODULE_0__["default"])(collection)) {
      return eachFunc(collection, iteratee);
    }
    var length = collection.length,
        index = fromRight ? length : -1,
        iterable = Object(collection);

    while ((fromRight ? index-- : ++index < length)) {
      if (iteratee(iterable[index], index, iterable) === false) {
        break;
      }
    }
    return collection;
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createBaseEach);


/***/ }),

/***/ "./node_modules/lodash-es/_equalArrays.js":
/*!************************************************!*\
  !*** ./node_modules/lodash-es/_equalArrays.js ***!
  \************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _SetCache_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_SetCache.js */ "./node_modules/lodash-es/_SetCache.js");
/* harmony import */ var _arraySome_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_arraySome.js */ "./node_modules/lodash-es/_arraySome.js");
/* harmony import */ var _cacheHas_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_cacheHas.js */ "./node_modules/lodash-es/_cacheHas.js");




/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1,
    COMPARE_UNORDERED_FLAG = 2;

/**
 * A specialized version of `baseIsEqualDeep` for arrays with support for
 * partial deep comparisons.
 *
 * @private
 * @param {Array} array The array to compare.
 * @param {Array} other The other array to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `array` and `other` objects.
 * @returns {boolean} Returns `true` if the arrays are equivalent, else `false`.
 */
function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
  var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
      arrLength = array.length,
      othLength = other.length;

  if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
    return false;
  }
  // Check that cyclic values are equal.
  var arrStacked = stack.get(array);
  var othStacked = stack.get(other);
  if (arrStacked && othStacked) {
    return arrStacked == other && othStacked == array;
  }
  var index = -1,
      result = true,
      seen = (bitmask & COMPARE_UNORDERED_FLAG) ? new _SetCache_js__WEBPACK_IMPORTED_MODULE_0__["default"] : undefined;

  stack.set(array, other);
  stack.set(other, array);

  // Ignore non-index properties.
  while (++index < arrLength) {
    var arrValue = array[index],
        othValue = other[index];

    if (customizer) {
      var compared = isPartial
        ? customizer(othValue, arrValue, index, other, array, stack)
        : customizer(arrValue, othValue, index, array, other, stack);
    }
    if (compared !== undefined) {
      if (compared) {
        continue;
      }
      result = false;
      break;
    }
    // Recursively compare arrays (susceptible to call stack limits).
    if (seen) {
      if (!(0,_arraySome_js__WEBPACK_IMPORTED_MODULE_1__["default"])(other, function(othValue, othIndex) {
            if (!(0,_cacheHas_js__WEBPACK_IMPORTED_MODULE_2__["default"])(seen, othIndex) &&
                (arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
              return seen.push(othIndex);
            }
          })) {
        result = false;
        break;
      }
    } else if (!(
          arrValue === othValue ||
            equalFunc(arrValue, othValue, bitmask, customizer, stack)
        )) {
      result = false;
      break;
    }
  }
  stack['delete'](array);
  stack['delete'](other);
  return result;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (equalArrays);


/***/ }),

/***/ "./node_modules/lodash-es/_equalByTag.js":
/*!***********************************************!*\
  !*** ./node_modules/lodash-es/_equalByTag.js ***!
  \***********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_Symbol.js */ "./node_modules/lodash-es/_Symbol.js");
/* harmony import */ var _Uint8Array_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_Uint8Array.js */ "./node_modules/lodash-es/_Uint8Array.js");
/* harmony import */ var _eq_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./eq.js */ "./node_modules/lodash-es/eq.js");
/* harmony import */ var _equalArrays_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./_equalArrays.js */ "./node_modules/lodash-es/_equalArrays.js");
/* harmony import */ var _mapToArray_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./_mapToArray.js */ "./node_modules/lodash-es/_mapToArray.js");
/* harmony import */ var _setToArray_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./_setToArray.js */ "./node_modules/lodash-es/_setToArray.js");







/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1,
    COMPARE_UNORDERED_FLAG = 2;

/** `Object#toString` result references. */
var boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    errorTag = '[object Error]',
    mapTag = '[object Map]',
    numberTag = '[object Number]',
    regexpTag = '[object RegExp]',
    setTag = '[object Set]',
    stringTag = '[object String]',
    symbolTag = '[object Symbol]';

var arrayBufferTag = '[object ArrayBuffer]',
    dataViewTag = '[object DataView]';

/** Used to convert symbols to primitives and strings. */
var symbolProto = _Symbol_js__WEBPACK_IMPORTED_MODULE_0__["default"] ? _Symbol_js__WEBPACK_IMPORTED_MODULE_0__["default"].prototype : undefined,
    symbolValueOf = symbolProto ? symbolProto.valueOf : undefined;

/**
 * A specialized version of `baseIsEqualDeep` for comparing objects of
 * the same `toStringTag`.
 *
 * **Note:** This function only supports comparing values with tags of
 * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {string} tag The `toStringTag` of the objects to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack) {
  switch (tag) {
    case dataViewTag:
      if ((object.byteLength != other.byteLength) ||
          (object.byteOffset != other.byteOffset)) {
        return false;
      }
      object = object.buffer;
      other = other.buffer;

    case arrayBufferTag:
      if ((object.byteLength != other.byteLength) ||
          !equalFunc(new _Uint8Array_js__WEBPACK_IMPORTED_MODULE_1__["default"](object), new _Uint8Array_js__WEBPACK_IMPORTED_MODULE_1__["default"](other))) {
        return false;
      }
      return true;

    case boolTag:
    case dateTag:
    case numberTag:
      // Coerce booleans to `1` or `0` and dates to milliseconds.
      // Invalid dates are coerced to `NaN`.
      return (0,_eq_js__WEBPACK_IMPORTED_MODULE_2__["default"])(+object, +other);

    case errorTag:
      return object.name == other.name && object.message == other.message;

    case regexpTag:
    case stringTag:
      // Coerce regexes to strings and treat strings, primitives and objects,
      // as equal. See http://www.ecma-international.org/ecma-262/7.0/#sec-regexp.prototype.tostring
      // for more details.
      return object == (other + '');

    case mapTag:
      var convert = _mapToArray_js__WEBPACK_IMPORTED_MODULE_3__["default"];

    case setTag:
      var isPartial = bitmask & COMPARE_PARTIAL_FLAG;
      convert || (convert = _setToArray_js__WEBPACK_IMPORTED_MODULE_4__["default"]);

      if (object.size != other.size && !isPartial) {
        return false;
      }
      // Assume cyclic values are equal.
      var stacked = stack.get(object);
      if (stacked) {
        return stacked == other;
      }
      bitmask |= COMPARE_UNORDERED_FLAG;

      // Recursively compare objects (susceptible to call stack limits).
      stack.set(object, other);
      var result = (0,_equalArrays_js__WEBPACK_IMPORTED_MODULE_5__["default"])(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
      stack['delete'](object);
      return result;

    case symbolTag:
      if (symbolValueOf) {
        return symbolValueOf.call(object) == symbolValueOf.call(other);
      }
  }
  return false;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (equalByTag);


/***/ }),

/***/ "./node_modules/lodash-es/_equalObjects.js":
/*!*************************************************!*\
  !*** ./node_modules/lodash-es/_equalObjects.js ***!
  \*************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _getAllKeys_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_getAllKeys.js */ "./node_modules/lodash-es/_getAllKeys.js");


/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1;

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * A specialized version of `baseIsEqualDeep` for objects with support for
 * partial deep comparisons.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function equalObjects(object, other, bitmask, customizer, equalFunc, stack) {
  var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
      objProps = (0,_getAllKeys_js__WEBPACK_IMPORTED_MODULE_0__["default"])(object),
      objLength = objProps.length,
      othProps = (0,_getAllKeys_js__WEBPACK_IMPORTED_MODULE_0__["default"])(other),
      othLength = othProps.length;

  if (objLength != othLength && !isPartial) {
    return false;
  }
  var index = objLength;
  while (index--) {
    var key = objProps[index];
    if (!(isPartial ? key in other : hasOwnProperty.call(other, key))) {
      return false;
    }
  }
  // Check that cyclic values are equal.
  var objStacked = stack.get(object);
  var othStacked = stack.get(other);
  if (objStacked && othStacked) {
    return objStacked == other && othStacked == object;
  }
  var result = true;
  stack.set(object, other);
  stack.set(other, object);

  var skipCtor = isPartial;
  while (++index < objLength) {
    key = objProps[index];
    var objValue = object[key],
        othValue = other[key];

    if (customizer) {
      var compared = isPartial
        ? customizer(othValue, objValue, key, other, object, stack)
        : customizer(objValue, othValue, key, object, other, stack);
    }
    // Recursively compare objects (susceptible to call stack limits).
    if (!(compared === undefined
          ? (objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack))
          : compared
        )) {
      result = false;
      break;
    }
    skipCtor || (skipCtor = key == 'constructor');
  }
  if (result && !skipCtor) {
    var objCtor = object.constructor,
        othCtor = other.constructor;

    // Non `Object` object instances with different constructors are not equal.
    if (objCtor != othCtor &&
        ('constructor' in object && 'constructor' in other) &&
        !(typeof objCtor == 'function' && objCtor instanceof objCtor &&
          typeof othCtor == 'function' && othCtor instanceof othCtor)) {
      result = false;
    }
  }
  stack['delete'](object);
  stack['delete'](other);
  return result;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (equalObjects);


/***/ }),

/***/ "./node_modules/lodash-es/_getAllKeys.js":
/*!***********************************************!*\
  !*** ./node_modules/lodash-es/_getAllKeys.js ***!
  \***********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _baseGetAllKeys_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_baseGetAllKeys.js */ "./node_modules/lodash-es/_baseGetAllKeys.js");
/* harmony import */ var _getSymbols_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_getSymbols.js */ "./node_modules/lodash-es/_getSymbols.js");
/* harmony import */ var _keys_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./keys.js */ "./node_modules/lodash-es/keys.js");




/**
 * Creates an array of own enumerable property names and symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names and symbols.
 */
function getAllKeys(object) {
  return (0,_baseGetAllKeys_js__WEBPACK_IMPORTED_MODULE_0__["default"])(object, _keys_js__WEBPACK_IMPORTED_MODULE_1__["default"], _getSymbols_js__WEBPACK_IMPORTED_MODULE_2__["default"]);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (getAllKeys);


/***/ }),

/***/ "./node_modules/lodash-es/_getMatchData.js":
/*!*************************************************!*\
  !*** ./node_modules/lodash-es/_getMatchData.js ***!
  \*************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _isStrictComparable_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_isStrictComparable.js */ "./node_modules/lodash-es/_isStrictComparable.js");
/* harmony import */ var _keys_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./keys.js */ "./node_modules/lodash-es/keys.js");



/**
 * Gets the property names, values, and compare flags of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the match data of `object`.
 */
function getMatchData(object) {
  var result = (0,_keys_js__WEBPACK_IMPORTED_MODULE_0__["default"])(object),
      length = result.length;

  while (length--) {
    var key = result[length],
        value = object[key];

    result[length] = [key, value, (0,_isStrictComparable_js__WEBPACK_IMPORTED_MODULE_1__["default"])(value)];
  }
  return result;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (getMatchData);


/***/ }),

/***/ "./node_modules/lodash-es/_getSymbols.js":
/*!***********************************************!*\
  !*** ./node_modules/lodash-es/_getSymbols.js ***!
  \***********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _arrayFilter_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_arrayFilter.js */ "./node_modules/lodash-es/_arrayFilter.js");
/* harmony import */ var _stubArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./stubArray.js */ "./node_modules/lodash-es/stubArray.js");



/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Built-in value references. */
var propertyIsEnumerable = objectProto.propertyIsEnumerable;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeGetSymbols = Object.getOwnPropertySymbols;

/**
 * Creates an array of the own enumerable symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of symbols.
 */
var getSymbols = !nativeGetSymbols ? _stubArray_js__WEBPACK_IMPORTED_MODULE_0__["default"] : function(object) {
  if (object == null) {
    return [];
  }
  object = Object(object);
  return (0,_arrayFilter_js__WEBPACK_IMPORTED_MODULE_1__["default"])(nativeGetSymbols(object), function(symbol) {
    return propertyIsEnumerable.call(object, symbol);
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (getSymbols);


/***/ }),

/***/ "./node_modules/lodash-es/_getTag.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash-es/_getTag.js ***!
  \*******************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _DataView_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_DataView.js */ "./node_modules/lodash-es/_DataView.js");
/* harmony import */ var _Map_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_Map.js */ "./node_modules/lodash-es/_Map.js");
/* harmony import */ var _Promise_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./_Promise.js */ "./node_modules/lodash-es/_Promise.js");
/* harmony import */ var _Set_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./_Set.js */ "./node_modules/lodash-es/_Set.js");
/* harmony import */ var _WeakMap_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./_WeakMap.js */ "./node_modules/lodash-es/_WeakMap.js");
/* harmony import */ var _baseGetTag_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./_baseGetTag.js */ "./node_modules/lodash-es/_baseGetTag.js");
/* harmony import */ var _toSource_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_toSource.js */ "./node_modules/lodash-es/_toSource.js");








/** `Object#toString` result references. */
var mapTag = '[object Map]',
    objectTag = '[object Object]',
    promiseTag = '[object Promise]',
    setTag = '[object Set]',
    weakMapTag = '[object WeakMap]';

var dataViewTag = '[object DataView]';

/** Used to detect maps, sets, and weakmaps. */
var dataViewCtorString = (0,_toSource_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_DataView_js__WEBPACK_IMPORTED_MODULE_1__["default"]),
    mapCtorString = (0,_toSource_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_Map_js__WEBPACK_IMPORTED_MODULE_2__["default"]),
    promiseCtorString = (0,_toSource_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_Promise_js__WEBPACK_IMPORTED_MODULE_3__["default"]),
    setCtorString = (0,_toSource_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_Set_js__WEBPACK_IMPORTED_MODULE_4__["default"]),
    weakMapCtorString = (0,_toSource_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_WeakMap_js__WEBPACK_IMPORTED_MODULE_5__["default"]);

/**
 * Gets the `toStringTag` of `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
var getTag = _baseGetTag_js__WEBPACK_IMPORTED_MODULE_6__["default"];

// Fallback for data views, maps, sets, and weak maps in IE 11 and promises in Node.js < 6.
if ((_DataView_js__WEBPACK_IMPORTED_MODULE_1__["default"] && getTag(new _DataView_js__WEBPACK_IMPORTED_MODULE_1__["default"](new ArrayBuffer(1))) != dataViewTag) ||
    (_Map_js__WEBPACK_IMPORTED_MODULE_2__["default"] && getTag(new _Map_js__WEBPACK_IMPORTED_MODULE_2__["default"]) != mapTag) ||
    (_Promise_js__WEBPACK_IMPORTED_MODULE_3__["default"] && getTag(_Promise_js__WEBPACK_IMPORTED_MODULE_3__["default"].resolve()) != promiseTag) ||
    (_Set_js__WEBPACK_IMPORTED_MODULE_4__["default"] && getTag(new _Set_js__WEBPACK_IMPORTED_MODULE_4__["default"]) != setTag) ||
    (_WeakMap_js__WEBPACK_IMPORTED_MODULE_5__["default"] && getTag(new _WeakMap_js__WEBPACK_IMPORTED_MODULE_5__["default"]) != weakMapTag)) {
  getTag = function(value) {
    var result = (0,_baseGetTag_js__WEBPACK_IMPORTED_MODULE_6__["default"])(value),
        Ctor = result == objectTag ? value.constructor : undefined,
        ctorString = Ctor ? (0,_toSource_js__WEBPACK_IMPORTED_MODULE_0__["default"])(Ctor) : '';

    if (ctorString) {
      switch (ctorString) {
        case dataViewCtorString: return dataViewTag;
        case mapCtorString: return mapTag;
        case promiseCtorString: return promiseTag;
        case setCtorString: return setTag;
        case weakMapCtorString: return weakMapTag;
      }
    }
    return result;
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (getTag);


/***/ }),

/***/ "./node_modules/lodash-es/_hasPath.js":
/*!********************************************!*\
  !*** ./node_modules/lodash-es/_hasPath.js ***!
  \********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _castPath_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_castPath.js */ "./node_modules/lodash-es/_castPath.js");
/* harmony import */ var _isArguments_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./isArguments.js */ "./node_modules/lodash-es/isArguments.js");
/* harmony import */ var _isArray_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./isArray.js */ "./node_modules/lodash-es/isArray.js");
/* harmony import */ var _isIndex_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./_isIndex.js */ "./node_modules/lodash-es/_isIndex.js");
/* harmony import */ var _isLength_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./isLength.js */ "./node_modules/lodash-es/isLength.js");
/* harmony import */ var _toKey_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_toKey.js */ "./node_modules/lodash-es/_toKey.js");







/**
 * Checks if `path` exists on `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Array|string} path The path to check.
 * @param {Function} hasFunc The function to check properties.
 * @returns {boolean} Returns `true` if `path` exists, else `false`.
 */
function hasPath(object, path, hasFunc) {
  path = (0,_castPath_js__WEBPACK_IMPORTED_MODULE_0__["default"])(path, object);

  var index = -1,
      length = path.length,
      result = false;

  while (++index < length) {
    var key = (0,_toKey_js__WEBPACK_IMPORTED_MODULE_1__["default"])(path[index]);
    if (!(result = object != null && hasFunc(object, key))) {
      break;
    }
    object = object[key];
  }
  if (result || ++index != length) {
    return result;
  }
  length = object == null ? 0 : object.length;
  return !!length && (0,_isLength_js__WEBPACK_IMPORTED_MODULE_2__["default"])(length) && (0,_isIndex_js__WEBPACK_IMPORTED_MODULE_3__["default"])(key, length) &&
    ((0,_isArray_js__WEBPACK_IMPORTED_MODULE_4__["default"])(object) || (0,_isArguments_js__WEBPACK_IMPORTED_MODULE_5__["default"])(object));
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (hasPath);


/***/ }),

/***/ "./node_modules/lodash-es/_isKey.js":
/*!******************************************!*\
  !*** ./node_modules/lodash-es/_isKey.js ***!
  \******************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _isArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isArray.js */ "./node_modules/lodash-es/isArray.js");
/* harmony import */ var _isSymbol_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./isSymbol.js */ "./node_modules/lodash-es/isSymbol.js");



/** Used to match property names within property paths. */
var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,
    reIsPlainProp = /^\w*$/;

/**
 * Checks if `value` is a property name and not a property path.
 *
 * @private
 * @param {*} value The value to check.
 * @param {Object} [object] The object to query keys on.
 * @returns {boolean} Returns `true` if `value` is a property name, else `false`.
 */
function isKey(value, object) {
  if ((0,_isArray_js__WEBPACK_IMPORTED_MODULE_0__["default"])(value)) {
    return false;
  }
  var type = typeof value;
  if (type == 'number' || type == 'symbol' || type == 'boolean' ||
      value == null || (0,_isSymbol_js__WEBPACK_IMPORTED_MODULE_1__["default"])(value)) {
    return true;
  }
  return reIsPlainProp.test(value) || !reIsDeepProp.test(value) ||
    (object != null && value in Object(object));
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isKey);


/***/ }),

/***/ "./node_modules/lodash-es/_isStrictComparable.js":
/*!*******************************************************!*\
  !*** ./node_modules/lodash-es/_isStrictComparable.js ***!
  \*******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _isObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isObject.js */ "./node_modules/lodash-es/isObject.js");


/**
 * Checks if `value` is suitable for strict equality comparisons, i.e. `===`.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` if suitable for strict
 *  equality comparisons, else `false`.
 */
function isStrictComparable(value) {
  return value === value && !(0,_isObject_js__WEBPACK_IMPORTED_MODULE_0__["default"])(value);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isStrictComparable);


/***/ }),

/***/ "./node_modules/lodash-es/_mapToArray.js":
/*!***********************************************!*\
  !*** ./node_modules/lodash-es/_mapToArray.js ***!
  \***********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Converts `map` to its key-value pairs.
 *
 * @private
 * @param {Object} map The map to convert.
 * @returns {Array} Returns the key-value pairs.
 */
function mapToArray(map) {
  var index = -1,
      result = Array(map.size);

  map.forEach(function(value, key) {
    result[++index] = [key, value];
  });
  return result;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (mapToArray);


/***/ }),

/***/ "./node_modules/lodash-es/_matchesStrictComparable.js":
/*!************************************************************!*\
  !*** ./node_modules/lodash-es/_matchesStrictComparable.js ***!
  \************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * A specialized version of `matchesProperty` for source values suitable
 * for strict equality comparisons, i.e. `===`.
 *
 * @private
 * @param {string} key The key of the property to get.
 * @param {*} srcValue The value to match.
 * @returns {Function} Returns the new spec function.
 */
function matchesStrictComparable(key, srcValue) {
  return function(object) {
    if (object == null) {
      return false;
    }
    return object[key] === srcValue &&
      (srcValue !== undefined || (key in Object(object)));
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (matchesStrictComparable);


/***/ }),

/***/ "./node_modules/lodash-es/_memoizeCapped.js":
/*!**************************************************!*\
  !*** ./node_modules/lodash-es/_memoizeCapped.js ***!
  \**************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _memoize_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./memoize.js */ "./node_modules/lodash-es/memoize.js");


/** Used as the maximum memoize cache size. */
var MAX_MEMOIZE_SIZE = 500;

/**
 * A specialized version of `_.memoize` which clears the memoized function's
 * cache when it exceeds `MAX_MEMOIZE_SIZE`.
 *
 * @private
 * @param {Function} func The function to have its output memoized.
 * @returns {Function} Returns the new memoized function.
 */
function memoizeCapped(func) {
  var result = (0,_memoize_js__WEBPACK_IMPORTED_MODULE_0__["default"])(func, function(key) {
    if (cache.size === MAX_MEMOIZE_SIZE) {
      cache.clear();
    }
    return key;
  });

  var cache = result.cache;
  return result;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (memoizeCapped);


/***/ }),

/***/ "./node_modules/lodash-es/_nativeKeys.js":
/*!***********************************************!*\
  !*** ./node_modules/lodash-es/_nativeKeys.js ***!
  \***********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _overArg_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_overArg.js */ "./node_modules/lodash-es/_overArg.js");


/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeKeys = (0,_overArg_js__WEBPACK_IMPORTED_MODULE_0__["default"])(Object.keys, Object);

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (nativeKeys);


/***/ }),

/***/ "./node_modules/lodash-es/_setCacheAdd.js":
/*!************************************************!*\
  !*** ./node_modules/lodash-es/_setCacheAdd.js ***!
  \************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED = '__lodash_hash_undefined__';

/**
 * Adds `value` to the array cache.
 *
 * @private
 * @name add
 * @memberOf SetCache
 * @alias push
 * @param {*} value The value to cache.
 * @returns {Object} Returns the cache instance.
 */
function setCacheAdd(value) {
  this.__data__.set(value, HASH_UNDEFINED);
  return this;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (setCacheAdd);


/***/ }),

/***/ "./node_modules/lodash-es/_setCacheHas.js":
/*!************************************************!*\
  !*** ./node_modules/lodash-es/_setCacheHas.js ***!
  \************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Checks if `value` is in the array cache.
 *
 * @private
 * @name has
 * @memberOf SetCache
 * @param {*} value The value to search for.
 * @returns {number} Returns `true` if `value` is found, else `false`.
 */
function setCacheHas(value) {
  return this.__data__.has(value);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (setCacheHas);


/***/ }),

/***/ "./node_modules/lodash-es/_setToArray.js":
/*!***********************************************!*\
  !*** ./node_modules/lodash-es/_setToArray.js ***!
  \***********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Converts `set` to an array of its values.
 *
 * @private
 * @param {Object} set The set to convert.
 * @returns {Array} Returns the values.
 */
function setToArray(set) {
  var index = -1,
      result = Array(set.size);

  set.forEach(function(value) {
    result[++index] = value;
  });
  return result;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (setToArray);


/***/ }),

/***/ "./node_modules/lodash-es/_stringToPath.js":
/*!*************************************************!*\
  !*** ./node_modules/lodash-es/_stringToPath.js ***!
  \*************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _memoizeCapped_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_memoizeCapped.js */ "./node_modules/lodash-es/_memoizeCapped.js");


/** Used to match property names within property paths. */
var rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;

/** Used to match backslashes in property paths. */
var reEscapeChar = /\\(\\)?/g;

/**
 * Converts `string` to a property path array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the property path array.
 */
var stringToPath = (0,_memoizeCapped_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function(string) {
  var result = [];
  if (string.charCodeAt(0) === 46 /* . */) {
    result.push('');
  }
  string.replace(rePropName, function(match, number, quote, subString) {
    result.push(quote ? subString.replace(reEscapeChar, '$1') : (number || match));
  });
  return result;
});

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (stringToPath);


/***/ }),

/***/ "./node_modules/lodash-es/_toKey.js":
/*!******************************************!*\
  !*** ./node_modules/lodash-es/_toKey.js ***!
  \******************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _isSymbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isSymbol.js */ "./node_modules/lodash-es/isSymbol.js");


/** Used as references for various `Number` constants. */
var INFINITY = 1 / 0;

/**
 * Converts `value` to a string key if it's not a string or symbol.
 *
 * @private
 * @param {*} value The value to inspect.
 * @returns {string|symbol} Returns the key.
 */
function toKey(value) {
  if (typeof value == 'string' || (0,_isSymbol_js__WEBPACK_IMPORTED_MODULE_0__["default"])(value)) {
    return value;
  }
  var result = (value + '');
  return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (toKey);


/***/ }),

/***/ "./node_modules/lodash-es/get.js":
/*!***************************************!*\
  !*** ./node_modules/lodash-es/get.js ***!
  \***************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _baseGet_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_baseGet.js */ "./node_modules/lodash-es/_baseGet.js");


/**
 * Gets the value at `path` of `object`. If the resolved value is
 * `undefined`, the `defaultValue` is returned in its place.
 *
 * @static
 * @memberOf _
 * @since 3.7.0
 * @category Object
 * @param {Object} object The object to query.
 * @param {Array|string} path The path of the property to get.
 * @param {*} [defaultValue] The value returned for `undefined` resolved values.
 * @returns {*} Returns the resolved value.
 * @example
 *
 * var object = { 'a': [{ 'b': { 'c': 3 } }] };
 *
 * _.get(object, 'a[0].b.c');
 * // => 3
 *
 * _.get(object, ['a', '0', 'b', 'c']);
 * // => 3
 *
 * _.get(object, 'a.b.c', 'default');
 * // => 'default'
 */
function get(object, path, defaultValue) {
  var result = object == null ? undefined : (0,_baseGet_js__WEBPACK_IMPORTED_MODULE_0__["default"])(object, path);
  return result === undefined ? defaultValue : result;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (get);


/***/ }),

/***/ "./node_modules/lodash-es/hasIn.js":
/*!*****************************************!*\
  !*** ./node_modules/lodash-es/hasIn.js ***!
  \*****************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _baseHasIn_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_baseHasIn.js */ "./node_modules/lodash-es/_baseHasIn.js");
/* harmony import */ var _hasPath_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_hasPath.js */ "./node_modules/lodash-es/_hasPath.js");



/**
 * Checks if `path` is a direct or inherited property of `object`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Object
 * @param {Object} object The object to query.
 * @param {Array|string} path The path to check.
 * @returns {boolean} Returns `true` if `path` exists, else `false`.
 * @example
 *
 * var object = _.create({ 'a': _.create({ 'b': 2 }) });
 *
 * _.hasIn(object, 'a');
 * // => true
 *
 * _.hasIn(object, 'a.b');
 * // => true
 *
 * _.hasIn(object, ['a', 'b']);
 * // => true
 *
 * _.hasIn(object, 'b');
 * // => false
 */
function hasIn(object, path) {
  return object != null && (0,_hasPath_js__WEBPACK_IMPORTED_MODULE_0__["default"])(object, path, _baseHasIn_js__WEBPACK_IMPORTED_MODULE_1__["default"]);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (hasIn);


/***/ }),

/***/ "./node_modules/lodash-es/keys.js":
/*!****************************************!*\
  !*** ./node_modules/lodash-es/keys.js ***!
  \****************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _arrayLikeKeys_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_arrayLikeKeys.js */ "./node_modules/lodash-es/_arrayLikeKeys.js");
/* harmony import */ var _baseKeys_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_baseKeys.js */ "./node_modules/lodash-es/_baseKeys.js");
/* harmony import */ var _isArrayLike_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isArrayLike.js */ "./node_modules/lodash-es/isArrayLike.js");




/**
 * Creates an array of the own enumerable property names of `object`.
 *
 * **Note:** Non-object values are coerced to objects. See the
 * [ES spec](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
 * for more details.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.keys(new Foo);
 * // => ['a', 'b'] (iteration order is not guaranteed)
 *
 * _.keys('hi');
 * // => ['0', '1']
 */
function keys(object) {
  return (0,_isArrayLike_js__WEBPACK_IMPORTED_MODULE_0__["default"])(object) ? (0,_arrayLikeKeys_js__WEBPACK_IMPORTED_MODULE_1__["default"])(object) : (0,_baseKeys_js__WEBPACK_IMPORTED_MODULE_2__["default"])(object);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (keys);


/***/ }),

/***/ "./node_modules/lodash-es/map.js":
/*!***************************************!*\
  !*** ./node_modules/lodash-es/map.js ***!
  \***************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _arrayMap_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_arrayMap.js */ "./node_modules/lodash-es/_arrayMap.js");
/* harmony import */ var _baseIteratee_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./_baseIteratee.js */ "./node_modules/lodash-es/_baseIteratee.js");
/* harmony import */ var _baseMap_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_baseMap.js */ "./node_modules/lodash-es/_baseMap.js");
/* harmony import */ var _isArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isArray.js */ "./node_modules/lodash-es/isArray.js");





/**
 * Creates an array of values by running each element in `collection` thru
 * `iteratee`. The iteratee is invoked with three arguments:
 * (value, index|key, collection).
 *
 * Many lodash methods are guarded to work as iteratees for methods like
 * `_.every`, `_.filter`, `_.map`, `_.mapValues`, `_.reject`, and `_.some`.
 *
 * The guarded methods are:
 * `ary`, `chunk`, `curry`, `curryRight`, `drop`, `dropRight`, `every`,
 * `fill`, `invert`, `parseInt`, `random`, `range`, `rangeRight`, `repeat`,
 * `sampleSize`, `slice`, `some`, `sortBy`, `split`, `take`, `takeRight`,
 * `template`, `trim`, `trimEnd`, `trimStart`, and `words`
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Collection
 * @param {Array|Object} collection The collection to iterate over.
 * @param {Function} [iteratee=_.identity] The function invoked per iteration.
 * @returns {Array} Returns the new mapped array.
 * @example
 *
 * function square(n) {
 *   return n * n;
 * }
 *
 * _.map([4, 8], square);
 * // => [16, 64]
 *
 * _.map({ 'a': 4, 'b': 8 }, square);
 * // => [16, 64] (iteration order is not guaranteed)
 *
 * var users = [
 *   { 'user': 'barney' },
 *   { 'user': 'fred' }
 * ];
 *
 * // The `_.property` iteratee shorthand.
 * _.map(users, 'user');
 * // => ['barney', 'fred']
 */
function map(collection, iteratee) {
  var func = (0,_isArray_js__WEBPACK_IMPORTED_MODULE_0__["default"])(collection) ? _arrayMap_js__WEBPACK_IMPORTED_MODULE_1__["default"] : _baseMap_js__WEBPACK_IMPORTED_MODULE_2__["default"];
  return func(collection, (0,_baseIteratee_js__WEBPACK_IMPORTED_MODULE_3__["default"])(iteratee, 3));
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (map);


/***/ }),

/***/ "./node_modules/lodash-es/memoize.js":
/*!*******************************************!*\
  !*** ./node_modules/lodash-es/memoize.js ***!
  \*******************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _MapCache_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_MapCache.js */ "./node_modules/lodash-es/_MapCache.js");


/** Error message constants. */
var FUNC_ERROR_TEXT = 'Expected a function';

/**
 * Creates a function that memoizes the result of `func`. If `resolver` is
 * provided, it determines the cache key for storing the result based on the
 * arguments provided to the memoized function. By default, the first argument
 * provided to the memoized function is used as the map cache key. The `func`
 * is invoked with the `this` binding of the memoized function.
 *
 * **Note:** The cache is exposed as the `cache` property on the memoized
 * function. Its creation may be customized by replacing the `_.memoize.Cache`
 * constructor with one whose instances implement the
 * [`Map`](http://ecma-international.org/ecma-262/7.0/#sec-properties-of-the-map-prototype-object)
 * method interface of `clear`, `delete`, `get`, `has`, and `set`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Function
 * @param {Function} func The function to have its output memoized.
 * @param {Function} [resolver] The function to resolve the cache key.
 * @returns {Function} Returns the new memoized function.
 * @example
 *
 * var object = { 'a': 1, 'b': 2 };
 * var other = { 'c': 3, 'd': 4 };
 *
 * var values = _.memoize(_.values);
 * values(object);
 * // => [1, 2]
 *
 * values(other);
 * // => [3, 4]
 *
 * object.a = 2;
 * values(object);
 * // => [1, 2]
 *
 * // Modify the result cache.
 * values.cache.set(object, ['a', 'b']);
 * values(object);
 * // => ['a', 'b']
 *
 * // Replace `_.memoize.Cache`.
 * _.memoize.Cache = WeakMap;
 */
function memoize(func, resolver) {
  if (typeof func != 'function' || (resolver != null && typeof resolver != 'function')) {
    throw new TypeError(FUNC_ERROR_TEXT);
  }
  var memoized = function() {
    var args = arguments,
        key = resolver ? resolver.apply(this, args) : args[0],
        cache = memoized.cache;

    if (cache.has(key)) {
      return cache.get(key);
    }
    var result = func.apply(this, args);
    memoized.cache = cache.set(key, result) || cache;
    return result;
  };
  memoized.cache = new (memoize.Cache || _MapCache_js__WEBPACK_IMPORTED_MODULE_0__["default"]);
  return memoized;
}

// Expose `MapCache`.
memoize.Cache = _MapCache_js__WEBPACK_IMPORTED_MODULE_0__["default"];

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (memoize);


/***/ }),

/***/ "./node_modules/lodash-es/property.js":
/*!********************************************!*\
  !*** ./node_modules/lodash-es/property.js ***!
  \********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _baseProperty_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_baseProperty.js */ "./node_modules/lodash-es/_baseProperty.js");
/* harmony import */ var _basePropertyDeep_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./_basePropertyDeep.js */ "./node_modules/lodash-es/_basePropertyDeep.js");
/* harmony import */ var _isKey_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_isKey.js */ "./node_modules/lodash-es/_isKey.js");
/* harmony import */ var _toKey_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_toKey.js */ "./node_modules/lodash-es/_toKey.js");





/**
 * Creates a function that returns the value at `path` of a given object.
 *
 * @static
 * @memberOf _
 * @since 2.4.0
 * @category Util
 * @param {Array|string} path The path of the property to get.
 * @returns {Function} Returns the new accessor function.
 * @example
 *
 * var objects = [
 *   { 'a': { 'b': 2 } },
 *   { 'a': { 'b': 1 } }
 * ];
 *
 * _.map(objects, _.property('a.b'));
 * // => [2, 1]
 *
 * _.map(_.sortBy(objects, _.property(['a', 'b'])), 'a.b');
 * // => [1, 2]
 */
function property(path) {
  return (0,_isKey_js__WEBPACK_IMPORTED_MODULE_0__["default"])(path) ? (0,_baseProperty_js__WEBPACK_IMPORTED_MODULE_1__["default"])((0,_toKey_js__WEBPACK_IMPORTED_MODULE_2__["default"])(path)) : (0,_basePropertyDeep_js__WEBPACK_IMPORTED_MODULE_3__["default"])(path);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (property);


/***/ }),

/***/ "./node_modules/lodash-es/stubArray.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash-es/stubArray.js ***!
  \*********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * This method returns a new empty array.
 *
 * @static
 * @memberOf _
 * @since 4.13.0
 * @category Util
 * @returns {Array} Returns the new empty array.
 * @example
 *
 * var arrays = _.times(2, _.stubArray);
 *
 * console.log(arrays);
 * // => [[], []]
 *
 * console.log(arrays[0] === arrays[1]);
 * // => false
 */
function stubArray() {
  return [];
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (stubArray);


/***/ }),

/***/ "./node_modules/naive-ui/es/_utils/css/format-length.mjs":
/*!***************************************************************!*\
  !*** ./node_modules/naive-ui/es/_utils/css/format-length.mjs ***!
  \***************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formatLength: () => (/* binding */ formatLength)
/* harmony export */ });
const pureNumberRegex = /^(\d|\.)+$/;
const numberRegex = /(\d|\.)+/;
function formatLength(length, {
  c = 1,
  offset = 0,
  attachPx = true
} = {}) {
  if (typeof length === 'number') {
    const result = (length + offset) * c;
    if (result === 0) return '0';
    return `${result}px`;
  } else if (typeof length === 'string') {
    if (pureNumberRegex.test(length)) {
      const result = (Number(length) + offset) * c;
      if (attachPx) {
        if (result === 0) return '0';
        return `${result}px`;
      } else {
        return `${result}`;
      }
    } else {
      const result = numberRegex.exec(length);
      if (!result) return length;
      return length.replace(numberRegex, String((Number(result[0]) + offset) * c));
    }
  }
  return length;
}

/***/ }),

/***/ "./node_modules/naive-ui/es/_utils/env/is-jsdom.mjs":
/*!**********************************************************!*\
  !*** ./node_modules/naive-ui/es/_utils/env/is-jsdom.mjs ***!
  \**********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isJsdom: () => (/* binding */ isJsdom)
/* harmony export */ });
let _isJsdom;
function isJsdom() {
  if (_isJsdom === undefined) {
    _isJsdom = navigator.userAgent.includes('Node.js') || navigator.userAgent.includes('jsdom');
  }
  return _isJsdom;
}

/***/ }),

/***/ "./node_modules/naive-ui/es/_utils/vue/flatten.mjs":
/*!*********************************************************!*\
  !*** ./node_modules/naive-ui/es/_utils/vue/flatten.mjs ***!
  \*********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   flatten: () => (/* binding */ flatten)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");

// o(n) flatten
function flatten(vNodes, filterCommentNode = true, result = []) {
  vNodes.forEach(vNode => {
    if (vNode === null) return;
    if (typeof vNode !== 'object') {
      if (typeof vNode === 'string' || typeof vNode === 'number') {
        result.push((0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(String(vNode)));
      }
      return;
    }
    if (Array.isArray(vNode)) {
      flatten(vNode, filterCommentNode, result);
      return;
    }
    if (vNode.type === vue__WEBPACK_IMPORTED_MODULE_0__.Fragment) {
      if (vNode.children === null) return;
      if (Array.isArray(vNode.children)) {
        flatten(vNode.children, filterCommentNode, result);
      }
      // rawSlot
    } else {
      if (vNode.type === vue__WEBPACK_IMPORTED_MODULE_0__.Comment && filterCommentNode) return;
      result.push(vNode);
    }
  });
  return result;
}

/***/ }),

/***/ "./node_modules/naive-ui/es/_utils/vue/get-first-slot-vnode.mjs":
/*!**********************************************************************!*\
  !*** ./node_modules/naive-ui/es/_utils/vue/get-first-slot-vnode.mjs ***!
  \**********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getFirstSlotVNode: () => (/* binding */ getFirstSlotVNode)
/* harmony export */ });
/* harmony import */ var _naive_index_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../naive/index.mjs */ "./node_modules/naive-ui/es/_utils/naive/warn.mjs");
/* harmony import */ var _flatten_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./flatten.mjs */ "./node_modules/naive-ui/es/_utils/vue/flatten.mjs");


function getFirstSlotVNode(slots, slotName = 'default', props = undefined) {
  const slot = slots[slotName];
  if (!slot) {
    (0,_naive_index_mjs__WEBPACK_IMPORTED_MODULE_0__.warn)('getFirstSlotVNode', `slot[${slotName}] is empty`);
    return null;
  }
  const slotContent = (0,_flatten_mjs__WEBPACK_IMPORTED_MODULE_1__.flatten)(slot(props));
  // vue will normalize the slot, so slot must be an array
  if (slotContent.length === 1) {
    return slotContent[0];
  } else {
    (0,_naive_index_mjs__WEBPACK_IMPORTED_MODULE_0__.warn)('getFirstSlotVNode', `slot[${slotName}] should have exactly one child`);
    return null;
  }
}

/***/ }),

/***/ "./node_modules/naive-ui/es/_utils/vue/keep.mjs":
/*!******************************************************!*\
  !*** ./node_modules/naive-ui/es/_utils/vue/keep.mjs ***!
  \******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   keep: () => (/* binding */ keep)
/* harmony export */ });
function keep(object, keys = [], rest) {
  const keepedObject = {};
  keys.forEach(key => {
    keepedObject[key] = object[key];
  });
  return Object.assign(keepedObject, rest);
}

/***/ }),

/***/ "./node_modules/naive-ui/es/popover/src/Popover.mjs":
/*!**********************************************************!*\
  !*** ./node_modules/naive-ui/es/popover/src/Popover.mjs ***!
  \**********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   popoverBaseProps: () => (/* binding */ popoverBaseProps),
/* harmony export */   popoverProps: () => (/* binding */ popoverProps)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var vueuc__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! vueuc */ "./node_modules/vueuc/es/binder/src/Binder.js");
/* harmony import */ var vueuc__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! vueuc */ "./node_modules/vueuc/es/binder/src/Target.js");
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/life-cycle/use-is-mounted.js");
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/use-merged-state.js");
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/use-memo.js");
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/use-compitable.js");
/* harmony import */ var vdirs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! vdirs */ "./node_modules/vdirs/es/zindexable/index.js");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/composable/use-adjusted-to.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/naive/warn.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/vue/call.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/vue/get-first-slot-vnode.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/vue/keep.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-theme.mjs");
/* harmony import */ var _PopoverBody_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./PopoverBody.mjs */ "./node_modules/naive-ui/es/popover/src/PopoverBody.mjs");







const bodyPropKeys = Object.keys(_PopoverBody_mjs__WEBPACK_IMPORTED_MODULE_1__.popoverBodyProps);
const triggerEventMap = {
  focus: ['onFocus', 'onBlur'],
  click: ['onClick'],
  hover: ['onMouseenter', 'onMouseleave'],
  manual: [],
  nested: ['onFocus', 'onBlur', 'onMouseenter', 'onMouseleave', 'onClick']
};
function appendEvents(vNode, trigger, events) {
  triggerEventMap[trigger].forEach(eventName => {
    if (!vNode.props) {
      vNode.props = {};
    } else {
      vNode.props = Object.assign({}, vNode.props);
    }
    const originalHandler = vNode.props[eventName];
    const handler = events[eventName];
    if (!originalHandler) {
      vNode.props[eventName] = handler;
    } else {
      vNode.props[eventName] = (...args) => {
        originalHandler(...args);
        handler(...args);
      };
    }
  });
}
const popoverBaseProps = {
  show: {
    type: Boolean,
    default: undefined
  },
  defaultShow: Boolean,
  showArrow: {
    type: Boolean,
    default: true
  },
  trigger: {
    type: String,
    default: 'hover'
  },
  delay: {
    type: Number,
    default: 100
  },
  duration: {
    type: Number,
    default: 100
  },
  raw: Boolean,
  placement: {
    type: String,
    default: 'top'
  },
  x: Number,
  y: Number,
  arrowPointToCenter: Boolean,
  disabled: Boolean,
  getDisabled: Function,
  displayDirective: {
    type: String,
    default: 'if'
  },
  arrowClass: String,
  arrowStyle: [String, Object],
  arrowWrapperClass: String,
  arrowWrapperStyle: [String, Object],
  flip: {
    type: Boolean,
    default: true
  },
  animated: {
    type: Boolean,
    default: true
  },
  width: {
    type: [Number, String],
    default: undefined
  },
  overlap: Boolean,
  keepAliveOnHover: {
    type: Boolean,
    default: true
  },
  zIndex: Number,
  to: _utils_index_mjs__WEBPACK_IMPORTED_MODULE_2__.useAdjustedTo.propTo,
  scrollable: Boolean,
  contentClass: String,
  contentStyle: [Object, String],
  headerClass: String,
  headerStyle: [Object, String],
  footerClass: String,
  footerStyle: [Object, String],
  // events
  onClickoutside: Function,
  'onUpdate:show': [Function, Array],
  onUpdateShow: [Function, Array],
  // internal
  internalDeactivateImmediately: Boolean,
  internalSyncTargetWithParent: Boolean,
  internalInheritedEventHandlers: {
    type: Array,
    default: () => []
  },
  internalTrapFocus: Boolean,
  internalExtraClass: {
    type: Array,
    default: () => []
  },
  // deprecated
  onShow: [Function, Array],
  onHide: [Function, Array],
  arrow: {
    type: Boolean,
    default: undefined
  },
  minWidth: Number,
  maxWidth: Number
};
const popoverProps = Object.assign(Object.assign(Object.assign({}, _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_3__["default"].props), popoverBaseProps), {
  internalOnAfterLeave: Function,
  internalRenderBody: Function
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'Popover',
  inheritAttrs: false,
  props: popoverProps,
  __popover__: true,
  setup(props) {
    if (true) {
      (0,vue__WEBPACK_IMPORTED_MODULE_0__.watchEffect)(() => {
        if (props.maxWidth !== undefined) {
          (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_4__.warnOnce)('popover', '`max-width` is deprecated, please use `style` instead.');
        }
        if (props.minWidth !== undefined) {
          (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_4__.warnOnce)('popover', '`min-width` is deprecated, please use `style` instead.');
        }
        if (props.arrow !== undefined) {
          (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_4__.warnOnce)('popover', '`arrow` is deprecated, please use `showArrow` instead.');
        }
        if (props.onHide !== undefined) {
          (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_4__.warnOnce)('popover', '`on-hide` is deprecated, please use `on-update:show` instead.');
        }
        if (props.onShow !== undefined) {
          (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_4__.warnOnce)('popover', '`on-show` is deprecated, please use `on-update:show` instead.');
        }
      });
    }
    const isMountedRef = (0,vooks__WEBPACK_IMPORTED_MODULE_5__["default"])();
    const binderInstRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    // setup show
    const controlledShowRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => props.show);
    const uncontrolledShowRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(props.defaultShow);
    const mergedShowWithoutDisabledRef = (0,vooks__WEBPACK_IMPORTED_MODULE_6__["default"])(controlledShowRef, uncontrolledShowRef);
    const mergedShowConsideringDisabledPropRef = (0,vooks__WEBPACK_IMPORTED_MODULE_7__["default"])(() => {
      if (props.disabled) return false;
      return mergedShowWithoutDisabledRef.value;
    });
    const getMergedDisabled = () => {
      if (props.disabled) return true;
      const {
        getDisabled
      } = props;
      if (getDisabled === null || getDisabled === void 0 ? void 0 : getDisabled()) return true;
      return false;
    };
    const getMergedShow = () => {
      if (getMergedDisabled()) return false;
      return mergedShowWithoutDisabledRef.value;
    };
    // setup show-arrow
    const compatibleShowArrowRef = (0,vooks__WEBPACK_IMPORTED_MODULE_8__["default"])(props, ['arrow', 'showArrow']);
    const mergedShowArrowRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      if (props.overlap) return false;
      return compatibleShowArrowRef.value;
    });
    // bodyInstance
    let bodyInstance = null;
    const showTimerIdRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    const hideTimerIdRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    const positionManuallyRef = (0,vooks__WEBPACK_IMPORTED_MODULE_7__["default"])(() => {
      return props.x !== undefined && props.y !== undefined;
    });
    // methods
    function doUpdateShow(value) {
      const {
        'onUpdate:show': _onUpdateShow,
        onUpdateShow,
        onShow,
        onHide
      } = props;
      uncontrolledShowRef.value = value;
      if (_onUpdateShow) {
        (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_9__.call)(_onUpdateShow, value);
      }
      if (onUpdateShow) {
        (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_9__.call)(onUpdateShow, value);
      }
      if (value && onShow) {
        (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_9__.call)(onShow, true);
      }
      if (value && onHide) {
        (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_9__.call)(onHide, false);
      }
    }
    function syncPosition() {
      if (bodyInstance) {
        bodyInstance.syncPosition();
      }
    }
    function clearShowTimer() {
      const {
        value: showTimerId
      } = showTimerIdRef;
      if (showTimerId) {
        window.clearTimeout(showTimerId);
        showTimerIdRef.value = null;
      }
    }
    function clearHideTimer() {
      const {
        value: hideTimerId
      } = hideTimerIdRef;
      if (hideTimerId) {
        window.clearTimeout(hideTimerId);
        hideTimerIdRef.value = null;
      }
    }
    function handleFocus() {
      const mergedDisabled = getMergedDisabled();
      if (props.trigger === 'focus' && !mergedDisabled) {
        if (getMergedShow()) return;
        doUpdateShow(true);
      }
    }
    function handleBlur() {
      const mergedDisabled = getMergedDisabled();
      if (props.trigger === 'focus' && !mergedDisabled) {
        if (!getMergedShow()) return;
        doUpdateShow(false);
      }
    }
    function handleMouseEnter() {
      const mergedDisabled = getMergedDisabled();
      if (props.trigger === 'hover' && !mergedDisabled) {
        clearHideTimer();
        if (showTimerIdRef.value !== null) return;
        if (getMergedShow()) return;
        const delayCallback = () => {
          doUpdateShow(true);
          showTimerIdRef.value = null;
        };
        const {
          delay
        } = props;
        if (delay === 0) {
          delayCallback();
        } else {
          showTimerIdRef.value = window.setTimeout(delayCallback, delay);
        }
      }
    }
    function handleMouseLeave() {
      const mergedDisabled = getMergedDisabled();
      if (props.trigger === 'hover' && !mergedDisabled) {
        clearShowTimer();
        if (hideTimerIdRef.value !== null) return;
        if (!getMergedShow()) return;
        const delayedCallback = () => {
          doUpdateShow(false);
          hideTimerIdRef.value = null;
        };
        const {
          duration
        } = props;
        if (duration === 0) {
          delayedCallback();
        } else {
          hideTimerIdRef.value = window.setTimeout(delayedCallback, duration);
        }
      }
    }
    // will be called in popover-content
    function handleMouseMoveOutside() {
      handleMouseLeave();
    }
    // will be called in popover-content
    function handleClickOutside(e) {
      var _a;
      if (!getMergedShow()) return;
      if (props.trigger === 'click') {
        clearShowTimer();
        clearHideTimer();
        doUpdateShow(false);
      }
      (_a = props.onClickoutside) === null || _a === void 0 ? void 0 : _a.call(props, e);
    }
    function handleClick() {
      if (props.trigger === 'click' && !getMergedDisabled()) {
        clearShowTimer();
        clearHideTimer();
        const nextShow = !getMergedShow();
        doUpdateShow(nextShow);
      }
    }
    function handleKeydown(e) {
      if (!props.internalTrapFocus) return;
      if (e.key === 'Escape') {
        clearShowTimer();
        clearHideTimer();
        doUpdateShow(false);
      }
    }
    function setShow(value) {
      uncontrolledShowRef.value = value;
    }
    function getTriggerElement() {
      var _a;
      return (_a = binderInstRef.value) === null || _a === void 0 ? void 0 : _a.targetRef;
    }
    function setBodyInstance(value) {
      bodyInstance = value;
    }
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.provide)('NPopover', {
      getTriggerElement,
      handleKeydown,
      handleMouseEnter,
      handleMouseLeave,
      handleClickOutside,
      handleMouseMoveOutside,
      setBodyInstance,
      positionManuallyRef,
      isMountedRef,
      zIndexRef: (0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'zIndex'),
      extraClassRef: (0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'internalExtraClass'),
      internalRenderBodyRef: (0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'internalRenderBody')
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watchEffect)(() => {
      if (mergedShowWithoutDisabledRef.value && getMergedDisabled()) {
        doUpdateShow(false);
      }
    });
    const returned = {
      binderInstRef,
      positionManually: positionManuallyRef,
      mergedShowConsideringDisabledProp: mergedShowConsideringDisabledPropRef,
      // if to show popover body
      uncontrolledShow: uncontrolledShowRef,
      mergedShowArrow: mergedShowArrowRef,
      getMergedShow,
      setShow,
      handleClick,
      handleMouseEnter,
      handleMouseLeave,
      handleFocus,
      handleBlur,
      syncPosition
    };
    return returned;
  },
  render() {
    var _a;
    const {
      positionManually,
      $slots: slots
    } = this;
    let triggerVNode;
    let popoverInside = false;
    if (!positionManually) {
      if (slots.activator) {
        triggerVNode = (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_10__.getFirstSlotVNode)(slots, 'activator');
      } else {
        triggerVNode = (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_10__.getFirstSlotVNode)(slots, 'trigger');
      }
      if (triggerVNode) {
        triggerVNode = (0,vue__WEBPACK_IMPORTED_MODULE_0__.cloneVNode)(triggerVNode);
        triggerVNode = triggerVNode.type === vue__WEBPACK_IMPORTED_MODULE_0__.Text ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)('span', [triggerVNode]) : triggerVNode;
        const handlers = {
          onClick: this.handleClick,
          onMouseenter: this.handleMouseEnter,
          onMouseleave: this.handleMouseLeave,
          onFocus: this.handleFocus,
          onBlur: this.handleBlur
        };
        if ((_a = triggerVNode.type) === null || _a === void 0 ? void 0 : _a.__popover__) {
          popoverInside = true;
          // We assume that there's no DOM event handlers on popover element
          if (!triggerVNode.props) {
            triggerVNode.props = {
              internalSyncTargetWithParent: true,
              internalInheritedEventHandlers: []
            };
          }
          triggerVNode.props.internalSyncTargetWithParent = true;
          if (!triggerVNode.props.internalInheritedEventHandlers) {
            triggerVNode.props.internalInheritedEventHandlers = [handlers];
          } else {
            triggerVNode.props.internalInheritedEventHandlers = [handlers, ...triggerVNode.props.internalInheritedEventHandlers];
          }
        } else {
          const {
            internalInheritedEventHandlers
          } = this;
          const ascendantAndCurrentHandlers = [handlers, ...internalInheritedEventHandlers];
          const mergedHandlers = {
            onBlur: e => {
              ascendantAndCurrentHandlers.forEach(_handlers => {
                _handlers.onBlur(e);
              });
            },
            onFocus: e => {
              ascendantAndCurrentHandlers.forEach(_handlers => {
                _handlers.onFocus(e);
              });
            },
            onClick: e => {
              ascendantAndCurrentHandlers.forEach(_handlers => {
                _handlers.onClick(e);
              });
            },
            onMouseenter: e => {
              ascendantAndCurrentHandlers.forEach(_handlers => {
                _handlers.onMouseenter(e);
              });
            },
            onMouseleave: e => {
              ascendantAndCurrentHandlers.forEach(_handlers => {
                _handlers.onMouseleave(e);
              });
            }
          };
          appendEvents(triggerVNode, internalInheritedEventHandlers ? 'nested' : positionManually ? 'manual' : this.trigger, mergedHandlers);
        }
      }
    }
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vueuc__WEBPACK_IMPORTED_MODULE_11__["default"], {
      ref: "binderInstRef",
      syncTarget: !popoverInside,
      syncTargetWithParent: this.internalSyncTargetWithParent
    }, {
      default: () => {
        // We need to subscribe it. Sometimes rerender won't ge triggered.
        // `mergedShowConsideringDisabledProp` is not the final disabled status.
        // In ellpisis it's dynamic.
        void this.mergedShowConsideringDisabledProp;
        const mergedShow = this.getMergedShow();
        return [this.internalTrapFocus && mergedShow ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
          style: {
            position: 'fixed',
            inset: 0
          }
        }), [[vdirs__WEBPACK_IMPORTED_MODULE_12__["default"], {
          enabled: mergedShow,
          zIndex: this.zIndex
        }]]) : null, positionManually ? null : (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vueuc__WEBPACK_IMPORTED_MODULE_13__["default"], null, {
          default: () => triggerVNode
        }), (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_PopoverBody_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_14__.keep)(this.$props, bodyPropKeys, Object.assign(Object.assign({}, this.$attrs), {
          showArrow: this.mergedShowArrow,
          show: mergedShow
        })), {
          default: () => {
            var _a, _b;
            return (_b = (_a = this.$slots).default) === null || _b === void 0 ? void 0 : _b.call(_a);
          },
          header: () => {
            var _a, _b;
            return (_b = (_a = this.$slots).header) === null || _b === void 0 ? void 0 : _b.call(_a);
          },
          footer: () => {
            var _a, _b;
            return (_b = (_a = this.$slots).footer) === null || _b === void 0 ? void 0 : _b.call(_a);
          }
        })];
      }
    });
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/popover/src/PopoverBody.mjs":
/*!**************************************************************!*\
  !*** ./node_modules/naive-ui/es/popover/src/PopoverBody.mjs ***!
  \**************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   popoverBodyProps: () => (/* binding */ popoverBodyProps),
/* harmony export */   renderArrow: () => (/* binding */ renderArrow)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var vueuc__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! vueuc */ "./node_modules/vueuc/es/focus-trap/src/index.js");
/* harmony import */ var vueuc__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! vueuc */ "./node_modules/vueuc/es/binder/src/Follower.js");
/* harmony import */ var vdirs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! vdirs */ "./node_modules/vdirs/es/clickoutside.js");
/* harmony import */ var vdirs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! vdirs */ "./node_modules/vdirs/es/mousemoveoutside.js");
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/dom/get-precise-event-target.js");
/* harmony import */ var _internal_scrollbar_index_mjs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../_internal/scrollbar/index.mjs */ "./node_modules/naive-ui/es/_internal/scrollbar/src/Scrollbar.mjs");
/* harmony import */ var _drawer_src_interface_mjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../drawer/src/interface.mjs */ "./node_modules/naive-ui/es/drawer/src/interface.mjs");
/* harmony import */ var _modal_src_interface_mjs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../modal/src/interface.mjs */ "./node_modules/naive-ui/es/modal/src/interface.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-theme.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-config.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-css-vars-class.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/composable/use-adjusted-to.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/env/is-jsdom.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/css/format-length.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/vue/resolve-slot.mjs");
/* harmony import */ var _styles_index_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../styles/index.mjs */ "./node_modules/naive-ui/es/popover/styles/light.mjs");
/* harmony import */ var _interface_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./interface.mjs */ "./node_modules/naive-ui/es/popover/src/interface.mjs");
/* harmony import */ var _styles_index_cssr_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./styles/index.cssr.mjs */ "./node_modules/naive-ui/es/popover/src/styles/index.cssr.mjs");












const popoverBodyProps = Object.assign(Object.assign({}, _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].props), {
  to: _utils_index_mjs__WEBPACK_IMPORTED_MODULE_2__.useAdjustedTo.propTo,
  show: Boolean,
  trigger: String,
  showArrow: Boolean,
  delay: Number,
  duration: Number,
  raw: Boolean,
  arrowPointToCenter: Boolean,
  arrowClass: String,
  arrowStyle: [String, Object],
  arrowWrapperClass: String,
  arrowWrapperStyle: [String, Object],
  displayDirective: String,
  x: Number,
  y: Number,
  flip: Boolean,
  overlap: Boolean,
  placement: String,
  width: [Number, String],
  keepAliveOnHover: Boolean,
  scrollable: Boolean,
  contentClass: String,
  contentStyle: [Object, String],
  headerClass: String,
  headerStyle: [Object, String],
  footerClass: String,
  footerStyle: [Object, String],
  // private
  internalDeactivateImmediately: Boolean,
  animated: Boolean,
  onClickoutside: Function,
  internalTrapFocus: Boolean,
  internalOnAfterLeave: Function,
  // deprecated
  minWidth: Number,
  maxWidth: Number
});
function renderArrow({
  arrowClass,
  arrowStyle,
  arrowWrapperClass,
  arrowWrapperStyle,
  clsPrefix
}) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
    key: "__popover-arrow__",
    style: arrowWrapperStyle,
    class: [`${clsPrefix}-popover-arrow-wrapper`, arrowWrapperClass]
  }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
    class: [`${clsPrefix}-popover-arrow`, arrowClass],
    style: arrowStyle
  }));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'PopoverBody',
  inheritAttrs: false,
  props: popoverBodyProps,
  setup(props, {
    slots,
    attrs
  }) {
    const {
      namespaceRef,
      mergedClsPrefixRef,
      inlineThemeDisabled
    } = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_3__["default"])(props);
    const themeRef = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])('Popover', '-popover', _styles_index_cssr_mjs__WEBPACK_IMPORTED_MODULE_4__["default"], _styles_index_mjs__WEBPACK_IMPORTED_MODULE_5__["default"], props, mergedClsPrefixRef);
    const followerRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    const NPopover = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)('NPopover');
    const bodyRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    const followerEnabledRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(props.show);
    const displayedRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watchEffect)(() => {
      const {
        show
      } = props;
      if (show && !(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_6__.isJsdom)() && !props.internalDeactivateImmediately) {
        displayedRef.value = true;
      }
    });
    const directivesRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const {
        trigger,
        onClickoutside
      } = props;
      const directives = [];
      const {
        positionManuallyRef: {
          value: positionManually
        }
      } = NPopover;
      if (!positionManually) {
        if (trigger === 'click' && !onClickoutside) {
          directives.push([vdirs__WEBPACK_IMPORTED_MODULE_7__["default"], handleClickOutside, undefined, {
            capture: true
          }]);
        }
        if (trigger === 'hover') {
          directives.push([vdirs__WEBPACK_IMPORTED_MODULE_8__["default"], handleMouseMoveOutside]);
        }
      }
      if (onClickoutside) {
        directives.push([vdirs__WEBPACK_IMPORTED_MODULE_7__["default"], handleClickOutside, undefined, {
          capture: true
        }]);
      }
      if (props.displayDirective === 'show' || props.animated && displayedRef.value) {
        directives.push([vue__WEBPACK_IMPORTED_MODULE_0__.vShow, props.show]);
      }
      return directives;
    });
    const cssVarsRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const {
        common: {
          cubicBezierEaseInOut,
          cubicBezierEaseIn,
          cubicBezierEaseOut
        },
        self: {
          space,
          spaceArrow,
          padding,
          fontSize,
          textColor,
          dividerColor,
          color,
          boxShadow,
          borderRadius,
          arrowHeight,
          arrowOffset,
          arrowOffsetVertical
        }
      } = themeRef.value;
      return {
        '--n-box-shadow': boxShadow,
        '--n-bezier': cubicBezierEaseInOut,
        '--n-bezier-ease-in': cubicBezierEaseIn,
        '--n-bezier-ease-out': cubicBezierEaseOut,
        '--n-font-size': fontSize,
        '--n-text-color': textColor,
        '--n-color': color,
        '--n-divider-color': dividerColor,
        '--n-border-radius': borderRadius,
        '--n-arrow-height': arrowHeight,
        '--n-arrow-offset': arrowOffset,
        '--n-arrow-offset-vertical': arrowOffsetVertical,
        '--n-padding': padding,
        '--n-space': space,
        '--n-space-arrow': spaceArrow
      };
    });
    const styleRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const width = props.width === 'trigger' ? undefined : (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_9__.formatLength)(props.width);
      const style = [];
      if (width) {
        style.push({
          width
        });
      }
      const {
        maxWidth,
        minWidth
      } = props;
      if (maxWidth) {
        style.push({
          maxWidth: (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_9__.formatLength)(maxWidth)
        });
      }
      if (minWidth) {
        style.push({
          maxWidth: (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_9__.formatLength)(minWidth)
        });
      }
      if (!inlineThemeDisabled) {
        style.push(cssVarsRef.value);
      }
      return style;
    });
    const themeClassHandle = inlineThemeDisabled ? (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_10__.useThemeClass)('popover', undefined, cssVarsRef, props) : undefined;
    NPopover.setBodyInstance({
      syncPosition
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onBeforeUnmount)(() => {
      NPopover.setBodyInstance(null);
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)((0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'show'), value => {
      // If no animation, no transition component will be applied to the
      // component. So we need to trigger follower manaully.
      if (props.animated) return;
      if (value) {
        followerEnabledRef.value = true;
      } else {
        followerEnabledRef.value = false;
      }
    });
    function syncPosition() {
      var _a;
      (_a = followerRef.value) === null || _a === void 0 ? void 0 : _a.syncPosition();
    }
    function handleMouseEnter(e) {
      if (props.trigger === 'hover' && props.keepAliveOnHover && props.show) {
        NPopover.handleMouseEnter(e);
      }
    }
    function handleMouseLeave(e) {
      if (props.trigger === 'hover' && props.keepAliveOnHover) {
        NPopover.handleMouseLeave(e);
      }
    }
    function handleMouseMoveOutside(e) {
      if (props.trigger === 'hover' && !getTriggerElement().contains((0,seemly__WEBPACK_IMPORTED_MODULE_11__.getPreciseEventTarget)(e))) {
        NPopover.handleMouseMoveOutside(e);
      }
    }
    function handleClickOutside(e) {
      if (props.trigger === 'click' && !getTriggerElement().contains((0,seemly__WEBPACK_IMPORTED_MODULE_11__.getPreciseEventTarget)(e)) || props.onClickoutside) {
        NPopover.handleClickOutside(e);
      }
    }
    function getTriggerElement() {
      return NPopover.getTriggerElement();
    }
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.provide)(_interface_mjs__WEBPACK_IMPORTED_MODULE_12__.popoverBodyInjectionKey, bodyRef);
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.provide)(_drawer_src_interface_mjs__WEBPACK_IMPORTED_MODULE_13__.drawerBodyInjectionKey, null);
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.provide)(_modal_src_interface_mjs__WEBPACK_IMPORTED_MODULE_14__.modalBodyInjectionKey, null);
    function renderContentNode() {
      themeClassHandle === null || themeClassHandle === void 0 ? void 0 : themeClassHandle.onRender();
      const shouldRenderDom = props.displayDirective === 'show' || props.show || props.animated && displayedRef.value;
      if (!shouldRenderDom) {
        return null;
      }
      let contentNode;
      const renderBody = NPopover.internalRenderBodyRef.value;
      const {
        value: mergedClsPrefix
      } = mergedClsPrefixRef;
      if (!renderBody) {
        const {
          value: extraClass
        } = NPopover.extraClassRef;
        const {
          internalTrapFocus
        } = props;
        const hasHeaderOrFooter = !(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_15__.isSlotEmpty)(slots.header) || !(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_15__.isSlotEmpty)(slots.footer);
        const renderContentInnerNode = () => {
          var _a, _b;
          const body = hasHeaderOrFooter ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_15__.resolveWrappedSlot)(slots.header, children => {
            return children ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
              class: [`${mergedClsPrefix}-popover__header`, props.headerClass],
              style: props.headerStyle
            }, children) : null;
          }), (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_15__.resolveWrappedSlot)(slots.default, children => {
            return children ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
              class: [`${mergedClsPrefix}-popover__content`, props.contentClass],
              style: props.contentStyle
            }, slots) : null;
          }), (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_15__.resolveWrappedSlot)(slots.footer, children => {
            return children ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
              class: [`${mergedClsPrefix}-popover__footer`, props.footerClass],
              style: props.footerStyle
            }, children) : null;
          })) : props.scrollable ? (_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
            class: [`${mergedClsPrefix}-popover__content`, props.contentClass],
            style: props.contentStyle
          }, slots);
          const maybeScrollableBody = props.scrollable ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_internal_scrollbar_index_mjs__WEBPACK_IMPORTED_MODULE_16__.XScrollbar, {
            contentClass: hasHeaderOrFooter ? undefined : `${mergedClsPrefix}-popover__content ${(_b = props.contentClass) !== null && _b !== void 0 ? _b : ''}`,
            contentStyle: hasHeaderOrFooter ? undefined : props.contentStyle
          }, {
            default: () => body
          }) : body;
          const arrow = props.showArrow ? renderArrow({
            arrowClass: props.arrowClass,
            arrowStyle: props.arrowStyle,
            arrowWrapperClass: props.arrowWrapperClass,
            arrowWrapperStyle: props.arrowWrapperStyle,
            clsPrefix: mergedClsPrefix
          }) : null;
          return [maybeScrollableBody, arrow];
        };
        contentNode = (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)('div', (0,vue__WEBPACK_IMPORTED_MODULE_0__.mergeProps)({
          class: [`${mergedClsPrefix}-popover`, `${mergedClsPrefix}-popover-shared`, themeClassHandle === null || themeClassHandle === void 0 ? void 0 : themeClassHandle.themeClass.value, extraClass.map(v => `${mergedClsPrefix}-${v}`), {
            [`${mergedClsPrefix}-popover--scrollable`]: props.scrollable,
            [`${mergedClsPrefix}-popover--show-header-or-footer`]: hasHeaderOrFooter,
            [`${mergedClsPrefix}-popover--raw`]: props.raw,
            [`${mergedClsPrefix}-popover-shared--overlap`]: props.overlap,
            [`${mergedClsPrefix}-popover-shared--show-arrow`]: props.showArrow,
            [`${mergedClsPrefix}-popover-shared--center-arrow`]: props.arrowPointToCenter
          }],
          ref: bodyRef,
          style: styleRef.value,
          onKeydown: NPopover.handleKeydown,
          onMouseenter: handleMouseEnter,
          onMouseleave: handleMouseLeave
        }, attrs), internalTrapFocus ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vueuc__WEBPACK_IMPORTED_MODULE_17__.FocusTrap, {
          active: props.show,
          autoFocus: true
        }, {
          default: renderContentInnerNode
        }) : renderContentInnerNode());
      } else {
        contentNode = renderBody(
        // The popover class and overlap class must exists, they will be used
        // to place the body & transition animation.
        // Shadow class exists for reuse box-shadow.
        [`${mergedClsPrefix}-popover-shared`, themeClassHandle === null || themeClassHandle === void 0 ? void 0 : themeClassHandle.themeClass.value, props.overlap && `${mergedClsPrefix}-popover-shared--overlap`, props.showArrow && `${mergedClsPrefix}-popover-shared--show-arrow`, props.arrowPointToCenter && `${mergedClsPrefix}-popover-shared--center-arrow`], bodyRef, styleRef.value, handleMouseEnter, handleMouseLeave);
      }
      return (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)(contentNode, directivesRef.value);
    }
    return {
      displayed: displayedRef,
      namespace: namespaceRef,
      isMounted: NPopover.isMountedRef,
      zIndex: NPopover.zIndexRef,
      followerRef,
      adjustedTo: (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_2__.useAdjustedTo)(props),
      followerEnabled: followerEnabledRef,
      renderContentNode
    };
  },
  render() {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vueuc__WEBPACK_IMPORTED_MODULE_18__["default"], {
      ref: "followerRef",
      zIndex: this.zIndex,
      show: this.show,
      enabled: this.followerEnabled,
      to: this.adjustedTo,
      x: this.x,
      y: this.y,
      flip: this.flip,
      placement: this.placement,
      containerClass: this.namespace,
      overlap: this.overlap,
      width: this.width === 'trigger' ? 'target' : undefined,
      teleportDisabled: this.adjustedTo === _utils_index_mjs__WEBPACK_IMPORTED_MODULE_2__.useAdjustedTo.tdkey
    }, {
      default: () => {
        return this.animated ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vue__WEBPACK_IMPORTED_MODULE_0__.Transition, {
          name: "popover-transition",
          appear: this.isMounted,
          // Don't use watch to enable follower, since the transition may
          // make position sync timing very subtle and buggy.
          onEnter: () => {
            this.followerEnabled = true;
          },
          onAfterLeave: () => {
            var _a;
            (_a = this.internalOnAfterLeave) === null || _a === void 0 ? void 0 : _a.call(this);
            this.followerEnabled = false;
            this.displayed = false;
          }
        }, {
          default: this.renderContentNode
        }) : this.renderContentNode();
      }
    });
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/popover/src/styles/index.cssr.mjs":
/*!********************************************************************!*\
  !*** ./node_modules/naive-ui/es/popover/src/styles/index.cssr.mjs ***!
  \********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash-es */ "./node_modules/lodash-es/map.js");
/* harmony import */ var _utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../_utils/cssr/index.mjs */ "./node_modules/naive-ui/es/_utils/cssr/index.mjs");


const oppositePlacement = {
  top: 'bottom',
  bottom: 'top',
  left: 'right',
  right: 'left'
};
const arrowSize = 'var(--n-arrow-height) * 1.414';
// vars:
// --n-bezier
// --n-bezier-ease-in
// --n-bezier-ease-out
// --n-font-size
// --n-text-color
// --n-color
// --n-border-radius
// --n-arrow-height
// --n-arrow-offset
// --n-arrow-offset-vertical
// --n-padding
// --n-space
// --n-space-arrow
// --n-divider-color
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)([(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('popover', `
 transition:
 box-shadow .3s var(--n-bezier),
 background-color .3s var(--n-bezier),
 color .3s var(--n-bezier);
 position: relative;
 font-size: var(--n-font-size);
 color: var(--n-text-color);
 box-shadow: var(--n-box-shadow);
 word-break: break-word;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('>', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('scrollbar', `
 height: inherit;
 max-height: inherit;
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cNotM)('raw', `
 background-color: var(--n-color);
 border-radius: var(--n-border-radius);
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cNotM)('scrollable', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cNotM)('show-header-or-footer', 'padding: var(--n-padding);')])]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('header', `
 padding: var(--n-padding);
 border-bottom: 1px solid var(--n-divider-color);
 transition: border-color .3s var(--n-bezier);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('footer', `
 padding: var(--n-padding);
 border-top: 1px solid var(--n-divider-color);
 transition: border-color .3s var(--n-bezier);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('scrollable, show-header-or-footer', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('content', `
 padding: var(--n-padding);
 `)])]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('popover-shared', `
 transform-origin: inherit;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('popover-arrow-wrapper', `
 position: absolute;
 overflow: hidden;
 pointer-events: none;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('popover-arrow', `
 transition: background-color .3s var(--n-bezier);
 position: absolute;
 display: block;
 width: calc(${arrowSize});
 height: calc(${arrowSize});
 box-shadow: 0 0 8px 0 rgba(0, 0, 0, .12);
 transform: rotate(45deg);
 background-color: var(--n-color);
 pointer-events: all;
 `)]),
// body transition
(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&.popover-transition-enter-from, &.popover-transition-leave-to', `
 opacity: 0;
 transform: scale(.85);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&.popover-transition-enter-to, &.popover-transition-leave-from', `
 transform: scale(1);
 opacity: 1;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&.popover-transition-enter-active', `
 transition:
 box-shadow .3s var(--n-bezier),
 background-color .3s var(--n-bezier),
 color .3s var(--n-bezier),
 opacity .15s var(--n-bezier-ease-out),
 transform .15s var(--n-bezier-ease-out);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&.popover-transition-leave-active', `
 transition:
 box-shadow .3s var(--n-bezier),
 background-color .3s var(--n-bezier),
 color .3s var(--n-bezier),
 opacity .15s var(--n-bezier-ease-in),
 transform .15s var(--n-bezier-ease-in);
 `)]), placementStyle('top-start', `
 top: calc(${arrowSize} / -2);
 left: calc(${getArrowOffset('top-start')} - var(--v-offset-left));
 `), placementStyle('top', `
 top: calc(${arrowSize} / -2);
 transform: translateX(calc(${arrowSize} / -2)) rotate(45deg);
 left: 50%;
 `), placementStyle('top-end', `
 top: calc(${arrowSize} / -2);
 right: calc(${getArrowOffset('top-end')} + var(--v-offset-left));
 `), placementStyle('bottom-start', `
 bottom: calc(${arrowSize} / -2);
 left: calc(${getArrowOffset('bottom-start')} - var(--v-offset-left));
 `), placementStyle('bottom', `
 bottom: calc(${arrowSize} / -2);
 transform: translateX(calc(${arrowSize} / -2)) rotate(45deg);
 left: 50%;
 `), placementStyle('bottom-end', `
 bottom: calc(${arrowSize} / -2);
 right: calc(${getArrowOffset('bottom-end')} + var(--v-offset-left));
 `), placementStyle('left-start', `
 left: calc(${arrowSize} / -2);
 top: calc(${getArrowOffset('left-start')} - var(--v-offset-top));
 `), placementStyle('left', `
 left: calc(${arrowSize} / -2);
 transform: translateY(calc(${arrowSize} / -2)) rotate(45deg);
 top: 50%;
 `), placementStyle('left-end', `
 left: calc(${arrowSize} / -2);
 bottom: calc(${getArrowOffset('left-end')} + var(--v-offset-top));
 `), placementStyle('right-start', `
 right: calc(${arrowSize} / -2);
 top: calc(${getArrowOffset('right-start')} - var(--v-offset-top));
 `), placementStyle('right', `
 right: calc(${arrowSize} / -2);
 transform: translateY(calc(${arrowSize} / -2)) rotate(45deg);
 top: 50%;
 `), placementStyle('right-end', `
 right: calc(${arrowSize} / -2);
 bottom: calc(${getArrowOffset('right-end')} + var(--v-offset-top));
 `), ...(0,lodash_es__WEBPACK_IMPORTED_MODULE_1__["default"])({
  top: ['right-start', 'left-start'],
  right: ['top-end', 'bottom-end'],
  bottom: ['right-end', 'left-end'],
  left: ['top-start', 'bottom-start']
}, (placements, direction) => {
  const isVertical = ['right', 'left'].includes(direction);
  const sizeType = isVertical ? 'width' : 'height';
  return placements.map(placement => {
    const isReverse = placement.split('-')[1] === 'end';
    const targetSize = `var(--v-target-${sizeType}, 0px)`;
    const centerOffset = `calc((${targetSize} - ${arrowSize}) / 2)`;
    const offset = getArrowOffset(placement);
    return (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)(`[v-placement="${placement}"] >`, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('popover-shared', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('center-arrow', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('popover-arrow', `${direction}: calc(max(${centerOffset}, ${offset}) ${isReverse ? '+' : '-'} var(--v-offset-${isVertical ? 'left' : 'top'}));`)])])]);
  });
})]));
function getArrowOffset(placement) {
  return ['top', 'bottom'].includes(placement.split('-')[0]) ? 'var(--n-arrow-offset)' : 'var(--n-arrow-offset-vertical)';
}
function placementStyle(placement, arrowStyleLiteral) {
  const position = placement.split('-')[0];
  const sizeStyle = ['top', 'bottom'].includes(position) ? 'height: var(--n-space-arrow);' : 'width: var(--n-space-arrow);';
  return (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)(`[v-placement="${placement}"] >`, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('popover-shared', `
 margin-${oppositePlacement[position]}: var(--n-space);
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('show-arrow', `
 margin-${oppositePlacement[position]}: var(--n-space-arrow);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('overlap', `
 margin: 0;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cCB)('popover-arrow-wrapper', `
 right: 0;
 left: 0;
 top: 0;
 bottom: 0;
 ${position}: 100%;
 ${oppositePlacement[position]}: auto;
 ${sizeStyle}
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('popover-arrow', arrowStyleLiteral)])])]);
}

/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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