"use strict";
(self["webpackChunknearbeach"] = self["webpackChunknearbeach"] || []).push([["vendors-node_modules_naive-ui_es_select_src_Select_mjs"],{

/***/ "./node_modules/seemly/es/dom/happens-in.js":
/*!**************************************************!*\
  !*** ./node_modules/seemly/es/dom/happens-in.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   happensIn: () => (/* binding */ happensIn)
/* harmony export */ });
function happensIn(e, dataSetPropName) {
    let { target } = e;
    while (target) {
        if (target.dataset) {
            if (target.dataset[dataSetPropName] !== undefined)
                return true;
        }
        target = target.parentElement;
    }
    return false;
}


/***/ }),

/***/ "./node_modules/treemate/es/check.js":
/*!*******************************************!*\
  !*** ./node_modules/treemate/es/check.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SubtreeNotLoadedError: () => (/* binding */ SubtreeNotLoadedError),
/* harmony export */   getCheckedKeys: () => (/* binding */ getCheckedKeys),
/* harmony export */   getExtendedCheckedKeySet: () => (/* binding */ getExtendedCheckedKeySet)
/* harmony export */ });
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils */ "./node_modules/treemate/es/utils.js");

class SubtreeNotLoadedError extends Error {
    constructor() {
        super();
        this.message =
            'SubtreeNotLoadedError: checking a subtree whose required nodes are not fully loaded.';
    }
}
function getExtendedCheckedKeySetAfterCheck(checkKeys, currentCheckedKeys, treeMate, allowNotLoaded) {
    return getExtendedCheckedKeySet(currentCheckedKeys.concat(checkKeys), treeMate, allowNotLoaded, false);
}
function getAvailableAscendantNodeSet(uncheckedKeys, treeMate) {
    const visitedKeys = new Set();
    uncheckedKeys.forEach((uncheckedKey) => {
        const uncheckedTreeNode = treeMate.treeNodeMap.get(uncheckedKey);
        if (uncheckedTreeNode !== undefined) {
            let nodeCursor = uncheckedTreeNode.parent;
            while (nodeCursor !== null) {
                if (nodeCursor.disabled)
                    break;
                if (visitedKeys.has(nodeCursor.key))
                    break;
                else {
                    visitedKeys.add(nodeCursor.key);
                }
                nodeCursor = nodeCursor.parent;
            }
        }
    });
    return visitedKeys;
}
function getExtendedCheckedKeySetAfterUncheck(uncheckedKeys, currentCheckedKeys, treeMate, allowNotLoaded) {
    const extendedCheckedKeySet = getExtendedCheckedKeySet(currentCheckedKeys, treeMate, allowNotLoaded, false);
    const extendedKeySetToUncheck = getExtendedCheckedKeySet(uncheckedKeys, treeMate, allowNotLoaded, true);
    const ascendantKeySet = getAvailableAscendantNodeSet(uncheckedKeys, treeMate);
    const keysToRemove = [];
    extendedCheckedKeySet.forEach((key) => {
        if (extendedKeySetToUncheck.has(key) || ascendantKeySet.has(key)) {
            keysToRemove.push(key);
        }
    });
    keysToRemove.forEach((key) => extendedCheckedKeySet.delete(key));
    return extendedCheckedKeySet;
}
function getCheckedKeys(options, treeMate) {
    const { checkedKeys, keysToCheck, keysToUncheck, indeterminateKeys, cascade, leafOnly, checkStrategy, allowNotLoaded } = options;
    if (!cascade) {
        if (keysToCheck !== undefined) {
            return {
                checkedKeys: (0,_utils__WEBPACK_IMPORTED_MODULE_0__.merge)(checkedKeys, keysToCheck),
                indeterminateKeys: Array.from(indeterminateKeys)
            };
        }
        else if (keysToUncheck !== undefined) {
            return {
                checkedKeys: (0,_utils__WEBPACK_IMPORTED_MODULE_0__.minus)(checkedKeys, keysToUncheck),
                indeterminateKeys: Array.from(indeterminateKeys)
            };
        }
        else {
            return {
                checkedKeys: Array.from(checkedKeys),
                indeterminateKeys: Array.from(indeterminateKeys)
            };
        }
    }
    const { levelTreeNodeMap } = treeMate;
    let extendedCheckedKeySet;
    if (keysToUncheck !== undefined) {
        extendedCheckedKeySet = getExtendedCheckedKeySetAfterUncheck(keysToUncheck, checkedKeys, treeMate, allowNotLoaded);
    }
    else if (keysToCheck !== undefined) {
        extendedCheckedKeySet = getExtendedCheckedKeySetAfterCheck(keysToCheck, checkedKeys, treeMate, allowNotLoaded);
    }
    else {
        extendedCheckedKeySet = getExtendedCheckedKeySet(checkedKeys, treeMate, allowNotLoaded, false);
    }
    const checkStrategyIsParent = checkStrategy === 'parent';
    const checkStrategyIsChild = checkStrategy === 'child' || leafOnly;
    const syntheticCheckedKeySet = extendedCheckedKeySet;
    const syntheticIndeterminateKeySet = new Set();
    const maxLevel = Math.max.apply(null, Array.from(levelTreeNodeMap.keys()));
    // cascade check
    // 1. if tree is fully loaded, it just works
    // 2. if the tree is not fully loaded, we assume that keys which is in not
    //    loaded tree are not in checked keys
    //    for example:
    //    a -- b(fully-loaded)   -- c(fully-loaded)
    //      |- d(partial-loaded) -- ?e(not-loaded)
    //    in the case, `e` is assumed not to be checked, nor we can't calc `d`'s
    //    and `a`'s status
    for (let level = maxLevel; level >= 0; level -= 1) {
        const levelIsZero = level === 0;
        // it should exists, nor it is a bug
        const levelTreeNodes = levelTreeNodeMap.get(level);
        for (const levelTreeNode of levelTreeNodes) {
            if (levelTreeNode.isLeaf)
                continue;
            const { key: levelTreeNodeKey, shallowLoaded } = levelTreeNode;
            if (checkStrategyIsChild && shallowLoaded) {
                // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                levelTreeNode.children.forEach((v) => {
                    if (!v.disabled &&
                        !v.isLeaf &&
                        v.shallowLoaded &&
                        syntheticCheckedKeySet.has(v.key)) {
                        syntheticCheckedKeySet.delete(v.key);
                    }
                });
            }
            if (levelTreeNode.disabled || !shallowLoaded) {
                continue;
            }
            let fullyChecked = true;
            let partialChecked = false;
            let allDisabled = true;
            // it is shallow loaded, so `children` must exist
            for (const childNode of levelTreeNode.children) {
                const childKey = childNode.key;
                if (childNode.disabled)
                    continue;
                if (allDisabled)
                    allDisabled = false;
                if (syntheticCheckedKeySet.has(childKey)) {
                    partialChecked = true;
                }
                else if (syntheticIndeterminateKeySet.has(childKey)) {
                    partialChecked = true;
                    fullyChecked = false;
                    break;
                }
                else {
                    fullyChecked = false;
                    if (partialChecked) {
                        break;
                    }
                }
            }
            if (fullyChecked && !allDisabled) {
                if (checkStrategyIsParent) {
                    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                    levelTreeNode.children.forEach((v) => {
                        if (!v.disabled && syntheticCheckedKeySet.has(v.key)) {
                            syntheticCheckedKeySet.delete(v.key);
                        }
                    });
                }
                syntheticCheckedKeySet.add(levelTreeNodeKey);
            }
            else if (partialChecked) {
                syntheticIndeterminateKeySet.add(levelTreeNodeKey);
            }
            if (levelIsZero &&
                checkStrategyIsChild &&
                syntheticCheckedKeySet.has(levelTreeNodeKey)) {
                syntheticCheckedKeySet.delete(levelTreeNodeKey);
            }
        }
    }
    return {
        checkedKeys: Array.from(syntheticCheckedKeySet),
        indeterminateKeys: Array.from(syntheticIndeterminateKeySet)
    };
}
// unchecking is safe when doing cascade uncheck in async mode
function getExtendedCheckedKeySet(checkedKeys, treeMate, allowNotLoaded, isUnchecking) {
    const { treeNodeMap, getChildren } = treeMate;
    const visitedKeySet = new Set();
    const extendedKeySet = new Set(checkedKeys);
    checkedKeys.forEach((checkedKey) => {
        const checkedTreeNode = treeNodeMap.get(checkedKey);
        if (checkedTreeNode !== undefined) {
            (0,_utils__WEBPACK_IMPORTED_MODULE_0__.traverseWithCb)(checkedTreeNode, (treeNode) => {
                if (treeNode.disabled) {
                    return _utils__WEBPACK_IMPORTED_MODULE_0__.TRAVERSE_COMMAND.STOP;
                }
                const { key } = treeNode;
                if (visitedKeySet.has(key))
                    return;
                visitedKeySet.add(key);
                // Adding keys before loaded check is okay, since if not valid error
                // would be thrown
                extendedKeySet.add(key);
                if ((0,_utils__WEBPACK_IMPORTED_MODULE_0__.isExpilicitlyNotLoaded)(treeNode.rawNode, getChildren)) {
                    if (isUnchecking) {
                        return _utils__WEBPACK_IMPORTED_MODULE_0__.TRAVERSE_COMMAND.STOP;
                    }
                    else if (!allowNotLoaded) {
                        throw new SubtreeNotLoadedError();
                    }
                }
            });
        }
    });
    return extendedKeySet;
}


/***/ }),

/***/ "./node_modules/treemate/es/contains.js":
/*!**********************************************!*\
  !*** ./node_modules/treemate/es/contains.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   contains: () => (/* binding */ contains)
/* harmony export */ });
function contains(parent, child) {
    const parentKey = parent.key;
    // eslint-disable-next-line no-unmodified-loop-condition
    while (child) {
        if (child.key === parentKey)
            return true;
        child = child.parent;
    }
    return false;
}


/***/ }),

/***/ "./node_modules/treemate/es/create.js":
/*!********************************************!*\
  !*** ./node_modules/treemate/es/create.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createTreeMate: () => (/* binding */ createTreeMate)
/* harmony export */ });
/* harmony import */ var _check__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./check */ "./node_modules/treemate/es/check.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils */ "./node_modules/treemate/es/utils.js");
/* harmony import */ var _path__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./path */ "./node_modules/treemate/es/path.js");
/* harmony import */ var _move__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./move */ "./node_modules/treemate/es/move.js");
/* harmony import */ var _flatten__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./flatten */ "./node_modules/treemate/es/flatten.js");
/* harmony import */ var _contains__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./contains */ "./node_modules/treemate/es/contains.js");






function createTreeNodes(rawNodes, treeNodeMap, levelTreeNodeMap, nodeProto, getChildren, parent = null, level = 0) {
    const treeNodes = [];
    rawNodes.forEach((rawNode, index) => {
        var _a;
        if ( true &&
            (0,_utils__WEBPACK_IMPORTED_MODULE_0__.isNodeInvalid)(rawNode, getChildren)) {
            console.error('[treemate]: node', rawNode, 'is invalid');
        }
        const treeNode = Object.create(nodeProto);
        treeNode.rawNode = rawNode;
        treeNode.siblings = treeNodes;
        treeNode.level = level;
        treeNode.index = index;
        treeNode.isFirstChild = index === 0;
        treeNode.isLastChild = index + 1 === rawNodes.length;
        treeNode.parent = parent;
        if (!treeNode.ignored) {
            const rawChildren = getChildren(rawNode);
            if (Array.isArray(rawChildren)) {
                treeNode.children = createTreeNodes(rawChildren, treeNodeMap, levelTreeNodeMap, nodeProto, getChildren, treeNode, level + 1);
            }
        }
        treeNodes.push(treeNode);
        treeNodeMap.set(treeNode.key, treeNode);
        if (!levelTreeNodeMap.has(level))
            levelTreeNodeMap.set(level, []);
        (_a = levelTreeNodeMap.get(level)) === null || _a === void 0 ? void 0 : _a.push(treeNode);
    });
    return treeNodes;
}
function createTreeMate(rawNodes, options = {}) {
    var _a;
    const treeNodeMap = new Map();
    const levelTreeNodeMap = new Map();
    const { getDisabled = _utils__WEBPACK_IMPORTED_MODULE_0__.isDisabled, getIgnored = _utils__WEBPACK_IMPORTED_MODULE_0__.isIgnored, getIsGroup = _utils__WEBPACK_IMPORTED_MODULE_0__.isGroup, getKey = _utils__WEBPACK_IMPORTED_MODULE_0__.defaultGetKey } = options;
    const _getChildren = (_a = options.getChildren) !== null && _a !== void 0 ? _a : _utils__WEBPACK_IMPORTED_MODULE_0__.defaultGetChildren;
    const getChildren = options.ignoreEmptyChildren
        ? (node) => {
            const children = _getChildren(node);
            if (Array.isArray(children)) {
                if (!children.length)
                    return null;
                return children;
            }
            return children;
        }
        : _getChildren;
    const nodeProto = Object.assign({
        get key() {
            // do not pass parent or related things to it
            // the key need to be specified explicitly
            return getKey(this.rawNode);
        },
        get disabled() {
            return getDisabled(this.rawNode);
        },
        get isGroup() {
            return getIsGroup(this.rawNode);
        },
        get isLeaf() {
            return (0,_utils__WEBPACK_IMPORTED_MODULE_0__.isLeaf)(this.rawNode, getChildren);
        },
        get shallowLoaded() {
            return (0,_utils__WEBPACK_IMPORTED_MODULE_0__.isShallowLoaded)(this.rawNode, getChildren);
        },
        get ignored() {
            return getIgnored(this.rawNode);
        },
        contains(node) {
            return (0,_contains__WEBPACK_IMPORTED_MODULE_1__.contains)(this, node);
        }
    }, _move__WEBPACK_IMPORTED_MODULE_2__.moveMethods);
    const treeNodes = createTreeNodes(rawNodes, treeNodeMap, levelTreeNodeMap, nodeProto, getChildren);
    function getNode(key) {
        if (key === null || key === undefined)
            return null;
        const tmNode = treeNodeMap.get(key);
        if (tmNode && !tmNode.isGroup && !tmNode.ignored) {
            return tmNode;
        }
        return null;
    }
    function _getNode(key) {
        if (key === null || key === undefined)
            return null;
        const tmNode = treeNodeMap.get(key);
        if (tmNode && !tmNode.ignored) {
            return tmNode;
        }
        return null;
    }
    function getPrev(key, options) {
        const node = _getNode(key);
        if (!node)
            return null;
        return node.getPrev(options);
    }
    function getNext(key, options) {
        const node = _getNode(key);
        if (!node)
            return null;
        return node.getNext(options);
    }
    function getParent(key) {
        const node = _getNode(key);
        if (!node)
            return null;
        return node.getParent();
    }
    function getChild(key) {
        const node = _getNode(key);
        if (!node)
            return null;
        return node.getChild();
    }
    const treemate = {
        treeNodes,
        treeNodeMap,
        levelTreeNodeMap,
        maxLevel: Math.max(...levelTreeNodeMap.keys()),
        getChildren,
        getFlattenedNodes(expandedKeys) {
            return (0,_flatten__WEBPACK_IMPORTED_MODULE_3__.flatten)(treeNodes, expandedKeys);
        },
        getNode,
        getPrev,
        getNext,
        getParent,
        getChild,
        getFirstAvailableNode() {
            return (0,_move__WEBPACK_IMPORTED_MODULE_2__.getFirstAvailableNode)(treeNodes);
        },
        getPath(key, options = {}) {
            return (0,_path__WEBPACK_IMPORTED_MODULE_4__.getPath)(key, options, treemate);
        },
        getCheckedKeys(checkedKeys, options = {}) {
            const { cascade = true, leafOnly = false, checkStrategy = 'all', allowNotLoaded = false } = options;
            return (0,_check__WEBPACK_IMPORTED_MODULE_5__.getCheckedKeys)({
                checkedKeys: (0,_utils__WEBPACK_IMPORTED_MODULE_0__.unwrapCheckedKeys)(checkedKeys),
                indeterminateKeys: (0,_utils__WEBPACK_IMPORTED_MODULE_0__.unwrapIndeterminateKeys)(checkedKeys),
                cascade,
                leafOnly,
                checkStrategy,
                allowNotLoaded
            }, treemate);
        },
        check(keysToCheck, checkedKeys, options = {}) {
            const { cascade = true, leafOnly = false, checkStrategy = 'all', allowNotLoaded = false } = options;
            return (0,_check__WEBPACK_IMPORTED_MODULE_5__.getCheckedKeys)({
                checkedKeys: (0,_utils__WEBPACK_IMPORTED_MODULE_0__.unwrapCheckedKeys)(checkedKeys),
                indeterminateKeys: (0,_utils__WEBPACK_IMPORTED_MODULE_0__.unwrapIndeterminateKeys)(checkedKeys),
                keysToCheck: keysToCheck === undefined || keysToCheck === null
                    ? []
                    : (0,_utils__WEBPACK_IMPORTED_MODULE_0__.toArray)(keysToCheck),
                cascade,
                leafOnly,
                checkStrategy,
                allowNotLoaded
            }, treemate);
        },
        uncheck(keysToUncheck, checkedKeys, options = {}) {
            const { cascade = true, leafOnly = false, checkStrategy = 'all', allowNotLoaded = false } = options;
            return (0,_check__WEBPACK_IMPORTED_MODULE_5__.getCheckedKeys)({
                checkedKeys: (0,_utils__WEBPACK_IMPORTED_MODULE_0__.unwrapCheckedKeys)(checkedKeys),
                indeterminateKeys: (0,_utils__WEBPACK_IMPORTED_MODULE_0__.unwrapIndeterminateKeys)(checkedKeys),
                keysToUncheck: keysToUncheck === null || keysToUncheck === undefined
                    ? []
                    : (0,_utils__WEBPACK_IMPORTED_MODULE_0__.toArray)(keysToUncheck),
                cascade,
                leafOnly,
                checkStrategy,
                allowNotLoaded
            }, treemate);
        },
        getNonLeafKeys(options = {}) {
            return (0,_utils__WEBPACK_IMPORTED_MODULE_0__.getNonLeafKeys)(treeNodes, options);
        }
    };
    return treemate;
}


/***/ }),

/***/ "./node_modules/treemate/es/flatten.js":
/*!*********************************************!*\
  !*** ./node_modules/treemate/es/flatten.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   flatten: () => (/* binding */ flatten)
/* harmony export */ });
function flatten(treeNodes, expandedKeys) {
    const expandedKeySet = expandedKeys ? new Set(expandedKeys) : undefined;
    const flattenedNodes = [];
    function traverse(treeNodes) {
        treeNodes.forEach((treeNode) => {
            flattenedNodes.push(treeNode);
            if (treeNode.isLeaf || !treeNode.children || treeNode.ignored)
                return;
            if (treeNode.isGroup) {
                // group node shouldn't be expanded
                traverse(treeNode.children);
            }
            else if (
            // normal non-leaf node
            expandedKeySet === undefined ||
                expandedKeySet.has(treeNode.key)) {
                traverse(treeNode.children);
            }
        });
    }
    traverse(treeNodes);
    return flattenedNodes;
}


/***/ }),

/***/ "./node_modules/treemate/es/move.js":
/*!******************************************!*\
  !*** ./node_modules/treemate/es/move.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getFirstAvailableNode: () => (/* binding */ getFirstAvailableNode),
/* harmony export */   moveMethods: () => (/* binding */ moveMethods)
/* harmony export */ });
function getFirstAvailableNode(nodes) {
    if (nodes.length === 0)
        return null;
    const node = nodes[0];
    if (node.isGroup || node.ignored || node.disabled) {
        return node.getNext();
    }
    return node;
}
function rawGetNext(node, loop) {
    const sibs = node.siblings;
    const l = sibs.length;
    const { index } = node;
    if (loop) {
        return sibs[(index + 1) % l];
    }
    else {
        if (index === sibs.length - 1)
            return null;
        return sibs[index + 1];
    }
}
function move(fromNode, dir, { loop = false, includeDisabled = false } = {}) {
    const iterate = dir === 'prev' ? rawGetPrev : rawGetNext;
    const getChildOptions = {
        reverse: dir === 'prev'
    };
    let meet = false;
    let endNode = null;
    function traverse(node) {
        if (node === null)
            return;
        if (node === fromNode) {
            if (!meet) {
                meet = true;
            }
            else if (!fromNode.disabled && !fromNode.isGroup) {
                endNode = fromNode;
                return;
            }
        }
        else {
            if ((!node.disabled || includeDisabled) &&
                !node.ignored &&
                !node.isGroup) {
                endNode = node;
                return;
            }
        }
        if (node.isGroup) {
            const child = getChild(node, getChildOptions);
            if (child !== null) {
                endNode = child;
            }
            else {
                traverse(iterate(node, loop));
            }
        }
        else {
            const nextNode = iterate(node, false);
            if (nextNode !== null) {
                traverse(nextNode);
            }
            else {
                const parent = rawGetParent(node);
                if (parent === null || parent === void 0 ? void 0 : parent.isGroup) {
                    traverse(iterate(parent, loop));
                }
                else if (loop) {
                    traverse(iterate(node, true));
                }
            }
        }
    }
    traverse(fromNode);
    return endNode;
}
function rawGetPrev(node, loop) {
    const sibs = node.siblings;
    const l = sibs.length;
    const { index } = node;
    if (loop) {
        return sibs[(index - 1 + l) % l];
    }
    else {
        if (index === 0)
            return null;
        return sibs[index - 1];
    }
}
function rawGetParent(node) {
    return node.parent;
}
function getChild(node, options = {}) {
    const { reverse = false } = options;
    const { children } = node;
    if (children) {
        const { length } = children;
        const start = reverse ? length - 1 : 0;
        const end = reverse ? -1 : length;
        const delta = reverse ? -1 : 1;
        for (let i = start; i !== end; i += delta) {
            const child = children[i];
            if (!child.disabled && !child.ignored) {
                if (child.isGroup) {
                    const childInGroup = getChild(child, options);
                    if (childInGroup !== null)
                        return childInGroup;
                }
                else {
                    return child;
                }
            }
        }
    }
    return null;
}
const moveMethods = {
    getChild() {
        if (this.ignored)
            return null;
        return getChild(this);
    },
    getParent() {
        const { parent } = this;
        if (parent === null || parent === void 0 ? void 0 : parent.isGroup) {
            return parent.getParent();
        }
        return parent;
    },
    getNext(options = {}) {
        return move(this, 'next', options);
    },
    getPrev(options = {}) {
        return move(this, 'prev', options);
    }
};


/***/ }),

/***/ "./node_modules/treemate/es/path.js":
/*!******************************************!*\
  !*** ./node_modules/treemate/es/path.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getPath: () => (/* binding */ getPath)
/* harmony export */ });
function getPath(key, { includeGroup = false, includeSelf = true }, treeMate) {
    var _a;
    const treeNodeMap = treeMate.treeNodeMap;
    let treeNode = key === null || key === undefined ? null : (_a = treeNodeMap.get(key)) !== null && _a !== void 0 ? _a : null;
    const mergedPath = {
        keyPath: [],
        treeNodePath: [],
        treeNode: treeNode
    };
    if (treeNode === null || treeNode === void 0 ? void 0 : treeNode.ignored) {
        mergedPath.treeNode = null;
        return mergedPath;
    }
    while (treeNode) {
        if (!treeNode.ignored && (includeGroup || !treeNode.isGroup)) {
            mergedPath.treeNodePath.push(treeNode);
        }
        treeNode = treeNode.parent;
    }
    mergedPath.treeNodePath.reverse();
    if (!includeSelf)
        mergedPath.treeNodePath.pop();
    mergedPath.keyPath = mergedPath.treeNodePath.map((treeNode) => treeNode.key);
    return mergedPath;
}


/***/ }),

/***/ "./node_modules/treemate/es/utils.js":
/*!*******************************************!*\
  !*** ./node_modules/treemate/es/utils.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TRAVERSE_COMMAND: () => (/* binding */ TRAVERSE_COMMAND),
/* harmony export */   createIndexGetter: () => (/* binding */ createIndexGetter),
/* harmony export */   defaultGetChildren: () => (/* binding */ defaultGetChildren),
/* harmony export */   defaultGetKey: () => (/* binding */ defaultGetKey),
/* harmony export */   getNonLeafKeys: () => (/* binding */ getNonLeafKeys),
/* harmony export */   isDisabled: () => (/* binding */ isDisabled),
/* harmony export */   isExpilicitlyNotLoaded: () => (/* binding */ isExpilicitlyNotLoaded),
/* harmony export */   isGroup: () => (/* binding */ isGroup),
/* harmony export */   isIgnored: () => (/* binding */ isIgnored),
/* harmony export */   isLeaf: () => (/* binding */ isLeaf),
/* harmony export */   isNodeInvalid: () => (/* binding */ isNodeInvalid),
/* harmony export */   isShallowLoaded: () => (/* binding */ isShallowLoaded),
/* harmony export */   merge: () => (/* binding */ merge),
/* harmony export */   minus: () => (/* binding */ minus),
/* harmony export */   toArray: () => (/* binding */ toArray),
/* harmony export */   traverseWithCb: () => (/* binding */ traverseWithCb),
/* harmony export */   unwrapCheckedKeys: () => (/* binding */ unwrapCheckedKeys),
/* harmony export */   unwrapIndeterminateKeys: () => (/* binding */ unwrapIndeterminateKeys)
/* harmony export */ });
function toArray(arg) {
    if (Array.isArray(arg))
        return arg;
    return [arg];
}
// Do not use enum for lint plugin has error
const TRAVERSE_COMMAND = {
    STOP: 'STOP'
};
function traverseWithCb(treeNode, callback) {
    const command = callback(treeNode);
    if (treeNode.children !== undefined && command !== TRAVERSE_COMMAND.STOP) {
        treeNode.children.forEach((childNode) => traverseWithCb(childNode, callback));
    }
}
function getNonLeafKeys(treeNodes, options = {}) {
    const { preserveGroup = false } = options;
    const keys = [];
    const cb = preserveGroup
        ? (node) => {
            if (!node.isLeaf) {
                keys.push(node.key);
                traverse(node.children);
            }
        }
        : (node) => {
            if (!node.isLeaf) {
                if (!node.isGroup)
                    keys.push(node.key);
                traverse(node.children);
            }
        };
    function traverse(nodes) {
        nodes.forEach(cb);
    }
    traverse(treeNodes);
    return keys;
}
function isLeaf(rawNode, getChildren) {
    const { isLeaf } = rawNode;
    if (isLeaf !== undefined)
        return isLeaf;
    else if (!getChildren(rawNode))
        return true;
    return false;
}
function defaultGetChildren(node) {
    return node.children;
}
function defaultGetKey(node) {
    return node.key;
}
function isIgnored() {
    return false;
}
function isShallowLoaded(rawNode, getChildren) {
    const { isLeaf } = rawNode;
    if (isLeaf === false && !Array.isArray(getChildren(rawNode)))
        return false;
    return true;
}
function isDisabled(rawNode) {
    return rawNode.disabled === true;
}
function isExpilicitlyNotLoaded(rawNode, getChildren) {
    return (rawNode.isLeaf === false && !Array.isArray(getChildren(rawNode)));
}
function isNodeInvalid(rawNode, getChildren) {
    if (rawNode.isLeaf === true) {
        const children = getChildren(rawNode);
        if (Array.isArray(children) && children.length > 0)
            return true;
    }
    return false;
}
function unwrapCheckedKeys(result) {
    var _a;
    if (result === undefined || result === null)
        return [];
    if (Array.isArray(result))
        return result;
    return (_a = result.checkedKeys) !== null && _a !== void 0 ? _a : [];
}
function unwrapIndeterminateKeys(result) {
    var _a;
    if (result === undefined || result === null || Array.isArray(result)) {
        return [];
    }
    return (_a = result.indeterminateKeys) !== null && _a !== void 0 ? _a : [];
}
function merge(originalKeys, keysToAdd) {
    const set = new Set(originalKeys);
    keysToAdd.forEach((key) => {
        if (!set.has(key)) {
            set.add(key);
        }
    });
    return Array.from(set);
}
function minus(originalKeys, keysToRemove) {
    const set = new Set(originalKeys);
    keysToRemove.forEach((key) => {
        if (set.has(key)) {
            set.delete(key);
        }
    });
    return Array.from(set);
}
function isGroup(rawNode) {
    return (rawNode === null || rawNode === void 0 ? void 0 : rawNode.type) === 'group';
}
function createIndexGetter(treeNodes) {
    const map = new Map();
    treeNodes.forEach((treeNode, i) => {
        map.set(treeNode.key, i);
    });
    return (key) => { var _a; return (_a = map.get(key)) !== null && _a !== void 0 ? _a : null; };
}


/***/ }),

/***/ "./node_modules/vueuc/es/overflow/src/index.js":
/*!*****************************************************!*\
  !*** ./node_modules/vueuc/es/overflow/src/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _css_render_vue3_ssr__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @css-render/vue3-ssr */ "./node_modules/@css-render/vue3-ssr/esm/index.js");
/* harmony import */ var _shared__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../shared */ "./node_modules/vueuc/es/shared/cssr.js");
/* eslint-disable @typescript-eslint/strict-boolean-expressions */



const hiddenAttr = 'v-hidden';
const style = (0,_shared__WEBPACK_IMPORTED_MODULE_1__.c)('[v-hidden]', {
    display: 'none!important'
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
    name: 'Overflow',
    props: {
        getCounter: Function,
        getTail: Function,
        updateCounter: Function,
        onUpdateCount: Function,
        onUpdateOverflow: Function
    },
    setup(props, { slots }) {
        const selfRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const counterRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        function deriveCounter(options) {
            const { value: self } = selfRef;
            const { getCounter, getTail } = props;
            let counter;
            if (getCounter !== undefined)
                counter = getCounter();
            else {
                counter = counterRef.value;
            }
            if (!self || !counter)
                return;
            if (counter.hasAttribute(hiddenAttr)) {
                counter.removeAttribute(hiddenAttr);
            }
            const { children } = self;
            if (options.showAllItemsBeforeCalculate) {
                for (const child of children) {
                    if (child.hasAttribute(hiddenAttr)) {
                        child.removeAttribute(hiddenAttr);
                    }
                }
            }
            const containerWidth = self.offsetWidth;
            const childWidths = [];
            const tail = slots.tail ? getTail === null || getTail === void 0 ? void 0 : getTail() : null;
            let childWidthSum = tail ? tail.offsetWidth : 0;
            let overflow = false;
            const len = self.children.length - (slots.tail ? 1 : 0);
            for (let i = 0; i < len - 1; ++i) {
                if (i < 0)
                    continue;
                const child = children[i];
                if (overflow) {
                    if (!child.hasAttribute(hiddenAttr)) {
                        child.setAttribute(hiddenAttr, '');
                    }
                    continue;
                }
                else if (child.hasAttribute(hiddenAttr)) {
                    child.removeAttribute(hiddenAttr);
                }
                const childWidth = child.offsetWidth;
                childWidthSum += childWidth;
                childWidths[i] = childWidth;
                if (childWidthSum > containerWidth) {
                    const { updateCounter } = props;
                    for (let j = i; j >= 0; --j) {
                        const restCount = len - 1 - j;
                        if (updateCounter !== undefined) {
                            updateCounter(restCount);
                        }
                        else {
                            counter.textContent = `${restCount}`;
                        }
                        const counterWidth = counter.offsetWidth;
                        childWidthSum -= childWidths[j];
                        if (childWidthSum + counterWidth <= containerWidth || j === 0) {
                            overflow = true;
                            i = j - 1;
                            if (tail) {
                                // tail too long or 1st element too long
                                // we only consider tail now
                                if (i === -1) {
                                    tail.style.maxWidth = `${containerWidth - counterWidth}px`;
                                    tail.style.boxSizing = 'border-box';
                                }
                                else {
                                    tail.style.maxWidth = '';
                                }
                            }
                            const { onUpdateCount } = props;
                            if (onUpdateCount)
                                onUpdateCount(restCount);
                            break;
                        }
                    }
                }
            }
            const { onUpdateOverflow } = props;
            if (!overflow) {
                if (onUpdateOverflow !== undefined) {
                    onUpdateOverflow(false);
                }
                counter.setAttribute(hiddenAttr, '');
            }
            else {
                if (onUpdateOverflow !== undefined) {
                    onUpdateOverflow(true);
                }
            }
        }
        const ssrAdapter = (0,_css_render_vue3_ssr__WEBPACK_IMPORTED_MODULE_2__.useSsrAdapter)();
        style.mount({
            id: 'vueuc/overflow',
            head: true,
            anchorMetaName: _shared__WEBPACK_IMPORTED_MODULE_1__.cssrAnchorMetaName,
            ssr: ssrAdapter
        });
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(() => deriveCounter({
            showAllItemsBeforeCalculate: false
        }));
        // besides onMounted, other case should be manually triggered, or we shoud watch items
        return {
            selfRef,
            counterRef,
            sync: deriveCounter
        };
    },
    render() {
        const { $slots } = this;
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(() => this.sync({
            showAllItemsBeforeCalculate: false
        }));
        // It shouldn't have border
        return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)('div', {
            class: 'v-overflow',
            ref: 'selfRef'
        }, [
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderSlot)($slots, 'default'),
            // $slots.counter should only has 1 element
            $slots.counter
                ? $slots.counter()
                : (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)('span', {
                    style: {
                        display: 'inline-block'
                    },
                    ref: 'counterRef'
                }),
            // $slots.tail should only has 1 element
            $slots.tail ? $slots.tail() : null
        ]);
    }
}));


/***/ }),

/***/ "./node_modules/vueuc/es/shared/finweck-tree.js":
/*!******************************************************!*\
  !*** ./node_modules/vueuc/es/shared/finweck-tree.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FinweckTree: () => (/* binding */ FinweckTree)
/* harmony export */ });
function lowBit(n) {
    return n & -n;
}
class FinweckTree {
    /**
     * @param l length of the array
     * @param min min value of the array
     */
    constructor(l, min) {
        this.l = l;
        this.min = min;
        const ft = new Array(l + 1);
        for (let i = 0; i < l + 1; ++i) {
            ft[i] = 0;
        }
        this.ft = ft;
    }
    /**
     * Add arr[i] by n, start from 0
     * @param i the index of the element to be added
     * @param n the value to be added
     */
    add(i, n) {
        if (n === 0)
            return;
        const { l, ft } = this;
        i += 1;
        while (i <= l) {
            ft[i] += n;
            i += lowBit(i);
        }
    }
    /**
     * Get the value of index i
     * @param i index
     * @returns value of the index
     */
    get(i) {
        return this.sum(i + 1) - this.sum(i);
    }
    /**
     * Get the sum of first i elements
     * @param i count of head elements to be added
     * @returns the sum of first i elements
     */
    sum(i) {
        if (i === undefined)
            i = this.l;
        if (i <= 0)
            return 0;
        const { ft, min, l } = this;
        if (i > l)
            throw new Error('[FinweckTree.sum]: `i` is larger than length.');
        let ret = i * min;
        while (i > 0) {
            ret += ft[i];
            i -= lowBit(i);
        }
        return ret;
    }
    /**
     * Get the largest count of head elements whose sum are <= threshold
     * @param threshold
     * @returns the largest count of head elements whose sum are <= threshold
     */
    getBound(threshold) {
        let l = 0;
        let r = this.l;
        while (r > l) {
            const m = Math.floor((l + r) / 2);
            const sumM = this.sum(m);
            if (sumM > threshold) {
                r = m;
                continue;
            }
            else if (sumM < threshold) {
                if (l === m) {
                    if (this.sum(l + 1) <= threshold)
                        return l + 1;
                    return m;
                }
                l = m;
            }
            else {
                return m;
            }
        }
        return l;
    }
}


/***/ }),

/***/ "./node_modules/vueuc/es/virtual-list/src/VirtualList.js":
/*!***************************************************************!*\
  !*** ./node_modules/vueuc/es/virtual-list/src/VirtualList.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/css/index.js");
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/animation/next-frame-once.js");
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/use-memo.js");
/* harmony import */ var _css_render_vue3_ssr__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @css-render/vue3-ssr */ "./node_modules/@css-render/vue3-ssr/esm/index.js");
/* harmony import */ var _resize_observer_src_VResizeObserver__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../resize-observer/src/VResizeObserver */ "./node_modules/vueuc/es/resize-observer/src/VResizeObserver.js");
/* harmony import */ var _shared__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../shared */ "./node_modules/vueuc/es/shared/cssr.js");
/* harmony import */ var _shared__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../shared */ "./node_modules/vueuc/es/shared/finweck-tree.js");
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./config */ "./node_modules/vueuc/es/virtual-list/src/config.js");
/* eslint-disable no-void */
/* eslint-disable @typescript-eslint/restrict-plus-operands */







const styles = (0,_shared__WEBPACK_IMPORTED_MODULE_1__.c)('.v-vl', {
    maxHeight: 'inherit',
    height: '100%',
    overflow: 'auto',
    minWidth: '1px' // a zero width container won't be scrollable
}, [
    (0,_shared__WEBPACK_IMPORTED_MODULE_1__.c)('&:not(.v-vl--show-scrollbar)', {
        scrollbarWidth: 'none'
    }, [
        (0,_shared__WEBPACK_IMPORTED_MODULE_1__.c)('&::-webkit-scrollbar, &::-webkit-scrollbar-track-piece, &::-webkit-scrollbar-thumb', {
            width: 0,
            height: 0,
            display: 'none'
        })
    ])
]);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
    name: 'VirtualList',
    inheritAttrs: false,
    props: {
        showScrollbar: {
            type: Boolean,
            default: true
        },
        items: {
            type: Array,
            default: () => []
        },
        // it is suppose to be the min height
        itemSize: {
            type: Number,
            required: true
        },
        itemResizable: Boolean,
        itemsStyle: [String, Object],
        visibleItemsTag: {
            type: [String, Object],
            default: 'div'
        },
        visibleItemsProps: Object,
        ignoreItemResize: Boolean,
        onScroll: Function,
        onWheel: Function,
        onResize: Function,
        defaultScrollKey: [Number, String],
        defaultScrollIndex: Number,
        keyField: {
            type: String,
            default: 'key'
        },
        // Whether it is a good API?
        // ResizeObserver + footer & header is not enough.
        // Too complex for simple case
        paddingTop: {
            type: [Number, String],
            default: 0
        },
        paddingBottom: {
            type: [Number, String],
            default: 0
        }
    },
    setup(props) {
        const ssrAdapter = (0,_css_render_vue3_ssr__WEBPACK_IMPORTED_MODULE_2__.useSsrAdapter)();
        styles.mount({
            id: 'vueuc/virtual-list',
            head: true,
            anchorMetaName: _shared__WEBPACK_IMPORTED_MODULE_1__.cssrAnchorMetaName,
            ssr: ssrAdapter
        });
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(() => {
            const { defaultScrollIndex, defaultScrollKey } = props;
            if (defaultScrollIndex !== undefined && defaultScrollIndex !== null) {
                scrollTo({ index: defaultScrollIndex });
            }
            else if (defaultScrollKey !== undefined && defaultScrollKey !== null) {
                scrollTo({ key: defaultScrollKey });
            }
        });
        let isDeactivated = false;
        let activateStateInitialized = false;
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.onActivated)(() => {
            isDeactivated = false;
            if (!activateStateInitialized) {
                activateStateInitialized = true;
                return;
            }
            // remount
            scrollTo({ top: scrollTopRef.value, left: scrollLeft });
        });
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.onDeactivated)(() => {
            isDeactivated = true;
            if (!activateStateInitialized) {
                activateStateInitialized = true;
            }
        });
        const keyIndexMapRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const map = new Map();
            const { keyField } = props;
            props.items.forEach((item, index) => {
                map.set(item[keyField], index);
            });
            return map;
        });
        const listElRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const listHeightRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(undefined);
        const keyToHeightOffset = new Map();
        const finweckTreeRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { items, itemSize, keyField } = props;
            const ft = new _shared__WEBPACK_IMPORTED_MODULE_3__.FinweckTree(items.length, itemSize);
            items.forEach((item, index) => {
                const key = item[keyField];
                const heightOffset = keyToHeightOffset.get(key);
                if (heightOffset !== undefined) {
                    ft.add(index, heightOffset);
                }
            });
            return ft;
        });
        const finweckTreeUpdateTrigger = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(0);
        let scrollLeft = 0;
        const scrollTopRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(0);
        const startIndexRef = (0,vooks__WEBPACK_IMPORTED_MODULE_4__["default"])(() => {
            return Math.max(finweckTreeRef.value.getBound(scrollTopRef.value - (0,seemly__WEBPACK_IMPORTED_MODULE_5__.depx)(props.paddingTop)) - 1, 0);
        });
        const viewportItemsRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { value: listHeight } = listHeightRef;
            if (listHeight === undefined)
                return [];
            const { items, itemSize } = props;
            const startIndex = startIndexRef.value;
            const endIndex = Math.min(startIndex + Math.ceil(listHeight / itemSize + 1), items.length - 1);
            const viewportItems = [];
            for (let i = startIndex; i <= endIndex; ++i) {
                viewportItems.push(items[i]);
            }
            return viewportItems;
        });
        const scrollTo = (options, y) => {
            if (typeof options === 'number') {
                scrollToPosition(options, y, 'auto');
                return;
            }
            const { left, top, index, key, position, behavior, debounce = true } = options;
            if (left !== undefined || top !== undefined) {
                scrollToPosition(left, top, behavior);
            }
            else if (index !== undefined) {
                scrollToIndex(index, behavior, debounce);
            }
            else if (key !== undefined) {
                const toIndex = keyIndexMapRef.value.get(key);
                if (toIndex !== undefined)
                    scrollToIndex(toIndex, behavior, debounce);
            }
            else if (position === 'bottom') {
                scrollToPosition(0, Number.MAX_SAFE_INTEGER, behavior);
            }
            else if (position === 'top') {
                scrollToPosition(0, 0, behavior);
            }
        };
        let anchorIndex;
        let anchorTimerId = null;
        function scrollToIndex(index, behavior, debounce) {
            const { value: ft } = finweckTreeRef;
            const targetTop = ft.sum(index) + (0,seemly__WEBPACK_IMPORTED_MODULE_5__.depx)(props.paddingTop);
            if (!debounce) {
                listElRef.value.scrollTo({
                    left: 0,
                    top: targetTop,
                    behavior
                });
            }
            else {
                anchorIndex = index;
                if (anchorTimerId !== null) {
                    window.clearTimeout(anchorTimerId);
                }
                anchorTimerId = window.setTimeout(() => {
                    anchorIndex = undefined;
                    anchorTimerId = null;
                }, 16); // use 0 ms may be ealier than resize callback...
                const { scrollTop, offsetHeight } = listElRef.value;
                if (targetTop > scrollTop) {
                    const itemSize = ft.get(index);
                    if (targetTop + itemSize <= scrollTop + offsetHeight) {
                        // do nothing
                    }
                    else {
                        listElRef.value.scrollTo({
                            left: 0,
                            top: targetTop + itemSize - offsetHeight,
                            behavior
                        });
                    }
                }
                else {
                    listElRef.value.scrollTo({
                        left: 0,
                        top: targetTop,
                        behavior
                    });
                }
            }
        }
        function scrollToPosition(left, top, behavior) {
            listElRef.value.scrollTo({
                left,
                top,
                behavior
            });
        }
        function handleItemResize(key, entry) {
            var _a, _b, _c;
            if (isDeactivated)
                return;
            if (props.ignoreItemResize)
                return;
            if (isHideByVShow(entry.target))
                return;
            const { value: ft } = finweckTreeRef;
            const index = keyIndexMapRef.value.get(key);
            const previousHeight = ft.get(index);
            const height = (_c = (_b = (_a = entry.borderBoxSize) === null || _a === void 0 ? void 0 : _a[0]) === null || _b === void 0 ? void 0 : _b.blockSize) !== null && _c !== void 0 ? _c : entry.contentRect.height;
            if (height === previousHeight)
                return;
            // height offset based on itemSize
            // used when rebuild the finweck tree
            const offset = height - props.itemSize;
            if (offset === 0) {
                keyToHeightOffset.delete(key);
            }
            else {
                keyToHeightOffset.set(key, height - props.itemSize);
            }
            // delta height based on finweck tree data
            const delta = height - previousHeight;
            if (delta === 0)
                return;
            ft.add(index, delta);
            const listEl = listElRef.value;
            if (listEl != null) {
                if (anchorIndex === undefined) {
                    const previousHeightSum = ft.sum(index);
                    if (listEl.scrollTop > previousHeightSum) {
                        listEl.scrollBy(0, delta);
                    }
                }
                else {
                    if (index < anchorIndex) {
                        listEl.scrollBy(0, delta);
                    }
                    else if (index === anchorIndex) {
                        const previousHeightSum = ft.sum(index);
                        if (height + previousHeightSum >
                            // Note, listEl shouldn't have border, nor offsetHeight won't be
                            // correct
                            listEl.scrollTop + listEl.offsetHeight) {
                            listEl.scrollBy(0, delta);
                        }
                    }
                }
                syncViewport();
            }
            finweckTreeUpdateTrigger.value++;
        }
        const mayUseWheel = !(0,_config__WEBPACK_IMPORTED_MODULE_6__.ensureMaybeTouch)();
        let wheelCatched = false;
        function handleListScroll(e) {
            var _a;
            (_a = props.onScroll) === null || _a === void 0 ? void 0 : _a.call(props, e);
            if (!mayUseWheel || !wheelCatched) {
                syncViewport();
            }
        }
        function handleListWheel(e) {
            var _a;
            (_a = props.onWheel) === null || _a === void 0 ? void 0 : _a.call(props, e);
            if (mayUseWheel) {
                const listEl = listElRef.value;
                if (listEl != null) {
                    if (e.deltaX === 0) {
                        if (listEl.scrollTop === 0 && e.deltaY <= 0) {
                            return;
                        }
                        if (listEl.scrollTop + listEl.offsetHeight >= listEl.scrollHeight &&
                            e.deltaY >= 0) {
                            return;
                        }
                    }
                    e.preventDefault();
                    listEl.scrollTop += e.deltaY / (0,_config__WEBPACK_IMPORTED_MODULE_6__.ensureWheelScale)();
                    listEl.scrollLeft += e.deltaX / (0,_config__WEBPACK_IMPORTED_MODULE_6__.ensureWheelScale)();
                    syncViewport();
                    wheelCatched = true;
                    (0,seemly__WEBPACK_IMPORTED_MODULE_7__.beforeNextFrameOnce)(() => {
                        wheelCatched = false;
                    });
                }
            }
        }
        function handleListResize(entry) {
            if (isDeactivated)
                return;
            // List is HTMLElement
            if (isHideByVShow(entry.target))
                return;
            // If height is same, return
            if (entry.contentRect.height === listHeightRef.value)
                return;
            listHeightRef.value = entry.contentRect.height;
            const { onResize } = props;
            if (onResize !== undefined)
                onResize(entry);
        }
        function syncViewport() {
            const { value: listEl } = listElRef;
            // sometime ref el can be null
            // https://github.com/TuSimple/naive-ui/issues/811
            if (listEl == null)
                return;
            scrollTopRef.value = listEl.scrollTop;
            scrollLeft = listEl.scrollLeft;
        }
        function isHideByVShow(el) {
            let cursor = el;
            while (cursor !== null) {
                if (cursor.style.display === 'none')
                    return true;
                cursor = cursor.parentElement;
            }
            return false;
        }
        return {
            listHeight: listHeightRef,
            listStyle: {
                overflow: 'auto'
            },
            keyToIndex: keyIndexMapRef,
            itemsStyle: (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
                const { itemResizable } = props;
                const height = (0,seemly__WEBPACK_IMPORTED_MODULE_5__.pxfy)(finweckTreeRef.value.sum());
                // eslint-disable-next-line @typescript-eslint/no-unused-expressions
                finweckTreeUpdateTrigger.value;
                return [
                    props.itemsStyle,
                    {
                        boxSizing: 'content-box',
                        height: itemResizable ? '' : height,
                        minHeight: itemResizable ? height : '',
                        paddingTop: (0,seemly__WEBPACK_IMPORTED_MODULE_5__.pxfy)(props.paddingTop),
                        paddingBottom: (0,seemly__WEBPACK_IMPORTED_MODULE_5__.pxfy)(props.paddingBottom)
                    }
                ];
            }),
            visibleItemsStyle: (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
                // eslint-disable-next-line @typescript-eslint/no-unused-expressions
                finweckTreeUpdateTrigger.value;
                return {
                    transform: `translateY(${(0,seemly__WEBPACK_IMPORTED_MODULE_5__.pxfy)(finweckTreeRef.value.sum(startIndexRef.value))})`
                };
            }),
            viewportItems: viewportItemsRef,
            listElRef,
            itemsElRef: (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null),
            scrollTo,
            handleListResize,
            handleListScroll,
            handleListWheel,
            handleItemResize
        };
    },
    render() {
        const { itemResizable, keyField, keyToIndex, visibleItemsTag } = this;
        return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_resize_observer_src_VResizeObserver__WEBPACK_IMPORTED_MODULE_8__["default"], {
            onResize: this.handleListResize
        }, {
            default: () => {
                var _a, _b;
                return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)('div', (0,vue__WEBPACK_IMPORTED_MODULE_0__.mergeProps)(this.$attrs, {
                    class: ['v-vl', this.showScrollbar && 'v-vl--show-scrollbar'],
                    onScroll: this.handleListScroll,
                    onWheel: this.handleListWheel,
                    ref: 'listElRef'
                }), [
                    this.items.length !== 0
                        ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)('div', {
                            ref: 'itemsElRef',
                            class: 'v-vl-items',
                            style: this.itemsStyle
                        }, [
                            (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(visibleItemsTag, Object.assign({
                                class: 'v-vl-visible-items',
                                style: this.visibleItemsStyle
                            }, this.visibleItemsProps), {
                                default: () => this.viewportItems.map((item) => {
                                    const key = item[keyField];
                                    const index = keyToIndex.get(key);
                                    const itemVNode = this.$slots.default({
                                        item,
                                        index
                                    })[0];
                                    if (itemResizable) {
                                        return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_resize_observer_src_VResizeObserver__WEBPACK_IMPORTED_MODULE_8__["default"], {
                                            key,
                                            onResize: (entry) => this.handleItemResize(key, entry)
                                        }, {
                                            default: () => itemVNode
                                        });
                                    }
                                    itemVNode.key = key;
                                    return itemVNode;
                                })
                            })
                        ])
                        : (_b = (_a = this.$slots).empty) === null || _b === void 0 ? void 0 : _b.call(_a)
                ]);
            }
        });
    }
}));


/***/ }),

/***/ "./node_modules/vueuc/es/virtual-list/src/config.js":
/*!**********************************************************!*\
  !*** ./node_modules/vueuc/es/virtual-list/src/config.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ensureMaybeTouch: () => (/* binding */ ensureMaybeTouch),
/* harmony export */   ensureWheelScale: () => (/* binding */ ensureWheelScale)
/* harmony export */ });
let maybeTouch;
function ensureMaybeTouch() {
    if (typeof document === 'undefined')
        return false;
    if (maybeTouch === undefined) {
        if ('matchMedia' in window) {
            maybeTouch = window.matchMedia('(pointer:coarse)').matches;
        }
        else {
            maybeTouch = false;
        }
    }
    return maybeTouch;
}
let wheelScale;
function ensureWheelScale() {
    if (typeof document === 'undefined')
        return 1;
    if (wheelScale === undefined) {
        wheelScale = 'chrome' in window ? window.devicePixelRatio : 1;
    }
    return wheelScale;
}


/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/clear/src/Clear.mjs":
/*!****************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/clear/src/Clear.mjs ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/vue/resolve-slot.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-style.mjs");
/* harmony import */ var _icons_index_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../icons/index.mjs */ "./node_modules/naive-ui/es/_internal/icons/Clear.mjs");
/* harmony import */ var _icon_index_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../icon/index.mjs */ "./node_modules/naive-ui/es/_internal/icon/src/Icon.mjs");
/* harmony import */ var _icon_switch_transition_index_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../icon-switch-transition/index.mjs */ "./node_modules/naive-ui/es/_internal/icon-switch-transition/src/IconSwitchTransition.mjs");
/* harmony import */ var _styles_index_cssr_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./styles/index.cssr.mjs */ "./node_modules/naive-ui/es/_internal/clear/src/styles/index.cssr.mjs");







/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'BaseClear',
  props: {
    clsPrefix: {
      type: String,
      required: true
    },
    show: Boolean,
    onClear: Function
  },
  setup(props) {
    (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])('-base-clear', _styles_index_cssr_mjs__WEBPACK_IMPORTED_MODULE_2__["default"], (0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'clsPrefix'));
    return {
      handleMouseDown(e) {
        e.preventDefault();
      }
    };
  },
  render() {
    const {
      clsPrefix
    } = this;
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${clsPrefix}-base-clear`
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_icon_switch_transition_index_mjs__WEBPACK_IMPORTED_MODULE_3__["default"], null, {
      default: () => {
        var _a, _b;
        return this.show ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
          key: "dismiss",
          class: `${clsPrefix}-base-clear__clear`,
          onClick: this.onClear,
          onMousedown: this.handleMouseDown,
          "data-clear": true
        }, (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_4__.resolveSlot)(this.$slots.icon, () => [(0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_icon_index_mjs__WEBPACK_IMPORTED_MODULE_5__["default"], {
          clsPrefix: clsPrefix
        }, {
          default: () => (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_icons_index_mjs__WEBPACK_IMPORTED_MODULE_6__["default"], null)
        })])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
          key: "icon",
          class: `${clsPrefix}-base-clear__placeholder`
        }, (_b = (_a = this.$slots).placeholder) === null || _b === void 0 ? void 0 : _b.call(_a));
      }
    }));
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/clear/src/styles/index.cssr.mjs":
/*!****************************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/clear/src/styles/index.cssr.mjs ***!
  \****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../_utils/cssr/index.mjs */ "./node_modules/naive-ui/es/_utils/cssr/index.mjs");
/* harmony import */ var _styles_transitions_icon_switch_cssr_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../_styles/transitions/icon-switch.cssr.mjs */ "./node_modules/naive-ui/es/_styles/transitions/icon-switch.cssr.mjs");


// vars:
// --n-bezier
// --n-clear-color
// --n-clear-size
// --n-clear-color-hover
// --n-clear-color-pressed
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-clear', `
 flex-shrink: 0;
 height: 1em;
 width: 1em;
 position: relative;
`, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('>', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('clear', `
 font-size: var(--n-clear-size);
 height: 1em;
 width: 1em;
 cursor: pointer;
 color: var(--n-clear-color);
 transition: color .3s var(--n-bezier);
 display: flex;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:hover', `
 color: var(--n-clear-color-hover)!important;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:active', `
 color: var(--n-clear-color-pressed)!important;
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('placeholder', `
 display: flex;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('clear, placeholder', `
 position: absolute;
 left: 50%;
 top: 50%;
 transform: translateX(-50%) translateY(-50%);
 `, [(0,_styles_transitions_icon_switch_cssr_mjs__WEBPACK_IMPORTED_MODULE_1__.iconSwitchTransition)({
  originalTransform: 'translateX(-50%) translateY(-50%)',
  left: '50%',
  top: '50%'
})])])]));

/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/close/src/Close.mjs":
/*!****************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/close/src/Close.mjs ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-style.mjs");
/* harmony import */ var _icon_index_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../icon/index.mjs */ "./node_modules/naive-ui/es/_internal/icon/src/Icon.mjs");
/* harmony import */ var _icons_index_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../icons/index.mjs */ "./node_modules/naive-ui/es/_internal/icons/Close.mjs");
/* harmony import */ var _styles_index_cssr_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./styles/index.cssr.mjs */ "./node_modules/naive-ui/es/_internal/close/src/styles/index.cssr.mjs");





/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'BaseClose',
  props: {
    isButtonTag: {
      type: Boolean,
      default: true
    },
    clsPrefix: {
      type: String,
      required: true
    },
    disabled: {
      type: Boolean,
      default: undefined
    },
    focusable: {
      type: Boolean,
      default: true
    },
    round: Boolean,
    onClick: Function,
    absolute: Boolean
  },
  setup(props) {
    (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])('-base-close', _styles_index_cssr_mjs__WEBPACK_IMPORTED_MODULE_2__["default"], (0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'clsPrefix'));
    return () => {
      const {
        clsPrefix,
        disabled,
        absolute,
        round,
        isButtonTag
      } = props;
      const Tag = isButtonTag ? 'button' : 'div';
      return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(Tag, {
        type: isButtonTag ? 'button' : undefined,
        tabindex: disabled || !props.focusable ? -1 : 0,
        "aria-disabled": disabled,
        "aria-label": "close",
        role: isButtonTag ? undefined : 'button',
        disabled: disabled,
        class: [`${clsPrefix}-base-close`, absolute && `${clsPrefix}-base-close--absolute`, disabled && `${clsPrefix}-base-close--disabled`, round && `${clsPrefix}-base-close--round`],
        onMousedown: e => {
          if (!props.focusable) {
            e.preventDefault();
          }
        },
        onClick: props.onClick
      }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_icon_index_mjs__WEBPACK_IMPORTED_MODULE_3__["default"], {
        clsPrefix: clsPrefix
      }, {
        default: () => (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_icons_index_mjs__WEBPACK_IMPORTED_MODULE_4__["default"], null)
      }));
    };
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/close/src/styles/index.cssr.mjs":
/*!****************************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/close/src/styles/index.cssr.mjs ***!
  \****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../_utils/cssr/index.mjs */ "./node_modules/naive-ui/es/_utils/cssr/index.mjs");

// vars:
// --n-close-border-radius
// --n-close-color-hover
// --n-close-color-pressed
// --n-close-icon-color
// --n-close-icon-color-hover
// --n-close-icon-color-pressed
// --n-close-icon-color-disabled
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-close', `
 display: flex;
 align-items: center;
 justify-content: center;
 cursor: pointer;
 background-color: transparent;
 color: var(--n-close-icon-color);
 border-radius: var(--n-close-border-radius);
 height: var(--n-close-size);
 width: var(--n-close-size);
 font-size: var(--n-close-icon-size);
 outline: none;
 border: none;
 position: relative;
 padding: 0;
`, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('absolute', `
 height: var(--n-close-icon-size);
 width: var(--n-close-icon-size);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&::before', `
 content: "";
 position: absolute;
 width: var(--n-close-size);
 height: var(--n-close-size);
 left: 50%;
 top: 50%;
 transform: translateY(-50%) translateX(-50%);
 transition: inherit;
 border-radius: inherit;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cNotM)('disabled', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:hover', `
 color: var(--n-close-icon-color-hover);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:hover::before', `
 background-color: var(--n-close-color-hover);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:focus::before', `
 background-color: var(--n-close-color-hover);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:active', `
 color: var(--n-close-icon-color-pressed);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:active::before', `
 background-color: var(--n-close-color-pressed);
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('disabled', `
 cursor: not-allowed;
 color: var(--n-close-icon-color-disabled);
 background-color: transparent;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('round', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&::before', `
 border-radius: 50%;
 `)])]));

/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/focus-detector/index.mjs":
/*!*********************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/focus-detector/index.mjs ***!
  \*********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _src_FocusDetector_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./src/FocusDetector.mjs */ "./node_modules/naive-ui/es/_internal/focus-detector/src/FocusDetector.mjs");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_src_FocusDetector_mjs__WEBPACK_IMPORTED_MODULE_0__["default"]);

/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/focus-detector/src/FocusDetector.mjs":
/*!*********************************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/focus-detector/src/FocusDetector.mjs ***!
  \*********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  props: {
    onFocus: Function,
    onBlur: Function
  },
  setup(props) {
    return () => (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      style: "width: 0; height: 0",
      tabindex: 0,
      onFocus: props.onFocus,
      onBlur: props.onBlur
    });
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/icons/Checkmark.mjs":
/*!****************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/icons/Checkmark.mjs ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'Checkmark',
  render() {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 16 16"
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("g", {
      fill: "none"
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("path", {
      d: "M14.046 3.486a.75.75 0 0 1-.032 1.06l-7.93 7.474a.85.85 0 0 1-1.188-.022l-2.68-2.72a.75.75 0 1 1 1.068-1.053l2.234 2.267l7.468-7.038a.75.75 0 0 1 1.06.032z",
      fill: "currentColor"
    })));
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/icons/ChevronDown.mjs":
/*!******************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/icons/ChevronDown.mjs ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'ChevronDown',
  render() {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("svg", {
      viewBox: "0 0 16 16",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("path", {
      d: "M3.14645 5.64645C3.34171 5.45118 3.65829 5.45118 3.85355 5.64645L8 9.79289L12.1464 5.64645C12.3417 5.45118 12.6583 5.45118 12.8536 5.64645C13.0488 5.84171 13.0488 6.15829 12.8536 6.35355L8.35355 10.8536C8.15829 11.0488 7.84171 11.0488 7.64645 10.8536L3.14645 6.35355C2.95118 6.15829 2.95118 5.84171 3.14645 5.64645Z",
      fill: "currentColor"
    }));
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/icons/Clear.mjs":
/*!************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/icons/Clear.mjs ***!
  \************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _replaceable_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./replaceable.mjs */ "./node_modules/naive-ui/es/_internal/icons/replaceable.mjs");


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_replaceable_mjs__WEBPACK_IMPORTED_MODULE_1__.replaceable)('clear', (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("svg", {
  viewBox: "0 0 16 16",
  version: "1.1",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("g", {
  stroke: "none",
  "stroke-width": "1",
  fill: "none",
  "fill-rule": "evenodd"
}, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("g", {
  fill: "currentColor",
  "fill-rule": "nonzero"
}, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("path", {
  d: "M8,2 C11.3137085,2 14,4.6862915 14,8 C14,11.3137085 11.3137085,14 8,14 C4.6862915,14 2,11.3137085 2,8 C2,4.6862915 4.6862915,2 8,2 Z M6.5343055,5.83859116 C6.33943736,5.70359511 6.07001296,5.72288026 5.89644661,5.89644661 L5.89644661,5.89644661 L5.83859116,5.9656945 C5.70359511,6.16056264 5.72288026,6.42998704 5.89644661,6.60355339 L5.89644661,6.60355339 L7.293,8 L5.89644661,9.39644661 L5.83859116,9.4656945 C5.70359511,9.66056264 5.72288026,9.92998704 5.89644661,10.1035534 L5.89644661,10.1035534 L5.9656945,10.1614088 C6.16056264,10.2964049 6.42998704,10.2771197 6.60355339,10.1035534 L6.60355339,10.1035534 L8,8.707 L9.39644661,10.1035534 L9.4656945,10.1614088 C9.66056264,10.2964049 9.92998704,10.2771197 10.1035534,10.1035534 L10.1035534,10.1035534 L10.1614088,10.0343055 C10.2964049,9.83943736 10.2771197,9.57001296 10.1035534,9.39644661 L10.1035534,9.39644661 L8.707,8 L10.1035534,6.60355339 L10.1614088,6.5343055 C10.2964049,6.33943736 10.2771197,6.07001296 10.1035534,5.89644661 L10.1035534,5.89644661 L10.0343055,5.83859116 C9.83943736,5.70359511 9.57001296,5.72288026 9.39644661,5.89644661 L9.39644661,5.89644661 L8,7.293 L6.60355339,5.89644661 Z"
}))))));

/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/icons/Close.mjs":
/*!************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/icons/Close.mjs ***!
  \************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _replaceable_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./replaceable.mjs */ "./node_modules/naive-ui/es/_internal/icons/replaceable.mjs");


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_replaceable_mjs__WEBPACK_IMPORTED_MODULE_1__.replaceable)('close', (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("svg", {
  viewBox: "0 0 12 12",
  version: "1.1",
  xmlns: "http://www.w3.org/2000/svg",
  "aria-hidden": true
}, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("g", {
  stroke: "none",
  "stroke-width": "1",
  fill: "none",
  "fill-rule": "evenodd"
}, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("g", {
  fill: "currentColor",
  "fill-rule": "nonzero"
}, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("path", {
  d: "M2.08859116,2.2156945 L2.14644661,2.14644661 C2.32001296,1.97288026 2.58943736,1.95359511 2.7843055,2.08859116 L2.85355339,2.14644661 L6,5.293 L9.14644661,2.14644661 C9.34170876,1.95118446 9.65829124,1.95118446 9.85355339,2.14644661 C10.0488155,2.34170876 10.0488155,2.65829124 9.85355339,2.85355339 L6.707,6 L9.85355339,9.14644661 C10.0271197,9.32001296 10.0464049,9.58943736 9.91140884,9.7843055 L9.85355339,9.85355339 C9.67998704,10.0271197 9.41056264,10.0464049 9.2156945,9.91140884 L9.14644661,9.85355339 L6,6.707 L2.85355339,9.85355339 C2.65829124,10.0488155 2.34170876,10.0488155 2.14644661,9.85355339 C1.95118446,9.65829124 1.95118446,9.34170876 2.14644661,9.14644661 L5.293,6 L2.14644661,2.85355339 C1.97288026,2.67998704 1.95359511,2.41056264 2.08859116,2.2156945 L2.14644661,2.14644661 L2.08859116,2.2156945 Z"
}))))));

/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/icons/Empty.mjs":
/*!************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/icons/Empty.mjs ***!
  \************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'Empty',
  render() {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("svg", {
      viewBox: "0 0 28 28",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("path", {
      d: "M26 7.5C26 11.0899 23.0899 14 19.5 14C15.9101 14 13 11.0899 13 7.5C13 3.91015 15.9101 1 19.5 1C23.0899 1 26 3.91015 26 7.5ZM16.8536 4.14645C16.6583 3.95118 16.3417 3.95118 16.1464 4.14645C15.9512 4.34171 15.9512 4.65829 16.1464 4.85355L18.7929 7.5L16.1464 10.1464C15.9512 10.3417 15.9512 10.6583 16.1464 10.8536C16.3417 11.0488 16.6583 11.0488 16.8536 10.8536L19.5 8.20711L22.1464 10.8536C22.3417 11.0488 22.6583 11.0488 22.8536 10.8536C23.0488 10.6583 23.0488 10.3417 22.8536 10.1464L20.2071 7.5L22.8536 4.85355C23.0488 4.65829 23.0488 4.34171 22.8536 4.14645C22.6583 3.95118 22.3417 3.95118 22.1464 4.14645L19.5 6.79289L16.8536 4.14645Z",
      fill: "currentColor"
    }), (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("path", {
      d: "M25 22.75V12.5991C24.5572 13.0765 24.053 13.4961 23.5 13.8454V16H17.5L17.3982 16.0068C17.0322 16.0565 16.75 16.3703 16.75 16.75C16.75 18.2688 15.5188 19.5 14 19.5C12.4812 19.5 11.25 18.2688 11.25 16.75L11.2432 16.6482C11.1935 16.2822 10.8797 16 10.5 16H4.5V7.25C4.5 6.2835 5.2835 5.5 6.25 5.5H12.2696C12.4146 4.97463 12.6153 4.47237 12.865 4H6.25C4.45507 4 3 5.45507 3 7.25V22.75C3 24.5449 4.45507 26 6.25 26H21.75C23.5449 26 25 24.5449 25 22.75ZM4.5 22.75V17.5H9.81597L9.85751 17.7041C10.2905 19.5919 11.9808 21 14 21L14.215 20.9947C16.2095 20.8953 17.842 19.4209 18.184 17.5H23.5V22.75C23.5 23.7165 22.7165 24.5 21.75 24.5H6.25C5.2835 24.5 4.5 23.7165 4.5 22.75Z",
      fill: "currentColor"
    }));
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/select-menu/src/SelectGroupHeader.mjs":
/*!**********************************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/select-menu/src/SelectGroupHeader.mjs ***!
  \**********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/vue/render.mjs");
/* harmony import */ var _interface_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./interface.mjs */ "./node_modules/naive-ui/es/_internal/select-menu/src/interface.mjs");



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'NBaseSelectGroupHeader',
  props: {
    clsPrefix: {
      type: String,
      required: true
    },
    tmNode: {
      type: Object,
      required: true
    }
  },
  setup() {
    const {
      renderLabelRef,
      renderOptionRef,
      labelFieldRef,
      nodePropsRef
    } = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(_interface_mjs__WEBPACK_IMPORTED_MODULE_1__.internalSelectionMenuInjectionKey);
    return {
      labelField: labelFieldRef,
      nodeProps: nodePropsRef,
      renderLabel: renderLabelRef,
      renderOption: renderOptionRef
    };
  },
  render() {
    const {
      clsPrefix,
      renderLabel,
      renderOption,
      nodeProps,
      tmNode: {
        rawNode
      }
    } = this;
    const attrs = nodeProps === null || nodeProps === void 0 ? void 0 : nodeProps(rawNode);
    const children = renderLabel ? renderLabel(rawNode, false) : (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_2__.render)(rawNode[this.labelField], rawNode, false);
    const node = (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", Object.assign({}, attrs, {
      class: [`${clsPrefix}-base-select-group-header`, attrs === null || attrs === void 0 ? void 0 : attrs.class]
    }), children);
    return rawNode.render ? rawNode.render({
      node,
      option: rawNode
    }) : renderOption ? renderOption({
      node,
      option: rawNode,
      selected: false
    }) : node;
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/select-menu/src/SelectMenu.mjs":
/*!***************************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/select-menu/src/SelectMenu.mjs ***!
  \***************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var treemate__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! treemate */ "./node_modules/treemate/es/utils.js");
/* harmony import */ var vueuc__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! vueuc */ "./node_modules/vueuc/es/virtual-list/src/VirtualList.js");
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/css/index.js");
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/dom/happens-in.js");
/* harmony import */ var _empty_index_mjs__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../../empty/index.mjs */ "./node_modules/naive-ui/es/empty/src/Empty.mjs");
/* harmony import */ var _scrollbar_index_mjs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../scrollbar/index.mjs */ "./node_modules/naive-ui/es/_internal/scrollbar/src/Scrollbar.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/composable/use-resize.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/vue/resolve-slot.mjs");
/* harmony import */ var _utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../_utils/cssr/index.mjs */ "./node_modules/naive-ui/es/_utils/cssr/index.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-theme.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-config.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-rtl.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-css-vars-class.mjs");
/* harmony import */ var _loading_index_mjs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../loading/index.mjs */ "./node_modules/naive-ui/es/_internal/loading/src/Loading.mjs");
/* harmony import */ var _focus_detector_index_mjs__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../focus-detector/index.mjs */ "./node_modules/naive-ui/es/_internal/focus-detector/index.mjs");
/* harmony import */ var _styles_index_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../styles/index.mjs */ "./node_modules/naive-ui/es/_internal/select-menu/styles/light.mjs");
/* harmony import */ var _SelectOption_mjs__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./SelectOption.mjs */ "./node_modules/naive-ui/es/_internal/select-menu/src/SelectOption.mjs");
/* harmony import */ var _SelectGroupHeader_mjs__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./SelectGroupHeader.mjs */ "./node_modules/naive-ui/es/_internal/select-menu/src/SelectGroupHeader.mjs");
/* harmony import */ var _interface_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./interface.mjs */ "./node_modules/naive-ui/es/_internal/select-menu/src/interface.mjs");
/* harmony import */ var _styles_index_cssr_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./styles/index.cssr.mjs */ "./node_modules/naive-ui/es/_internal/select-menu/src/styles/index.cssr.mjs");
















/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'InternalSelectMenu',
  props: Object.assign(Object.assign({}, _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].props), {
    clsPrefix: {
      type: String,
      required: true
    },
    scrollable: {
      type: Boolean,
      default: true
    },
    treeMate: {
      type: Object,
      required: true
    },
    multiple: Boolean,
    size: {
      type: String,
      default: 'medium'
    },
    value: {
      type: [String, Number, Array],
      default: null
    },
    autoPending: Boolean,
    virtualScroll: {
      type: Boolean,
      default: true
    },
    // show is used to toggle pending state initialization
    show: {
      type: Boolean,
      default: true
    },
    labelField: {
      type: String,
      default: 'label'
    },
    valueField: {
      type: String,
      default: 'value'
    },
    loading: Boolean,
    focusable: Boolean,
    renderLabel: Function,
    renderOption: Function,
    nodeProps: Function,
    showCheckmark: {
      type: Boolean,
      default: true
    },
    onMousedown: Function,
    onScroll: Function,
    onFocus: Function,
    onBlur: Function,
    onKeyup: Function,
    onKeydown: Function,
    onTabOut: Function,
    onMouseenter: Function,
    onMouseleave: Function,
    onResize: Function,
    resetMenuOnOptionsChange: {
      type: Boolean,
      default: true
    },
    inlineThemeDisabled: Boolean,
    // deprecated
    onToggle: Function
  }),
  setup(props) {
    const {
      mergedClsPrefixRef,
      mergedRtlRef
    } = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"])(props);
    const rtlEnabledRef = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_3__.useRtl)('InternalSelectMenu', mergedRtlRef, mergedClsPrefixRef);
    const themeRef = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])('InternalSelectMenu', '-internal-select-menu', _styles_index_cssr_mjs__WEBPACK_IMPORTED_MODULE_4__["default"], _styles_index_mjs__WEBPACK_IMPORTED_MODULE_5__["default"], props, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'clsPrefix'));
    const selfRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    const virtualListRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    const scrollbarRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    const flattenedNodesRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => props.treeMate.getFlattenedNodes());
    const fIndexGetterRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => (0,treemate__WEBPACK_IMPORTED_MODULE_6__.createIndexGetter)(flattenedNodesRef.value));
    const pendingNodeRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    function initPendingNode() {
      const {
        treeMate
      } = props;
      let defaultPendingNode = null;
      const {
        value
      } = props;
      if (value === null) {
        defaultPendingNode = treeMate.getFirstAvailableNode();
      } else {
        if (props.multiple) {
          defaultPendingNode = treeMate.getNode((value || [])[(value || []).length - 1]);
        } else {
          defaultPendingNode = treeMate.getNode(value);
        }
        if (!defaultPendingNode || defaultPendingNode.disabled) {
          defaultPendingNode = treeMate.getFirstAvailableNode();
        }
      }
      if (defaultPendingNode) {
        setPendingTmNode(defaultPendingNode);
      } else {
        setPendingTmNode(null);
      }
    }
    function clearPendingNodeIfInvalid() {
      const {
        value: pendingNode
      } = pendingNodeRef;
      if (pendingNode && !props.treeMate.getNode(pendingNode.key)) {
        pendingNodeRef.value = null;
      }
    }
    let initPendingNodeWatchStopHandle;
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(() => props.show, show => {
      if (show) {
        initPendingNodeWatchStopHandle = (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(() => props.treeMate, () => {
          if (props.resetMenuOnOptionsChange) {
            if (props.autoPending) {
              initPendingNode();
            } else {
              clearPendingNodeIfInvalid();
            }
            void (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(scrollToPendingNode);
          } else {
            clearPendingNodeIfInvalid();
          }
        }, {
          immediate: true
        });
      } else {
        initPendingNodeWatchStopHandle === null || initPendingNodeWatchStopHandle === void 0 ? void 0 : initPendingNodeWatchStopHandle();
      }
    }, {
      immediate: true
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onBeforeUnmount)(() => {
      initPendingNodeWatchStopHandle === null || initPendingNodeWatchStopHandle === void 0 ? void 0 : initPendingNodeWatchStopHandle();
    });
    const itemSizeRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      return (0,seemly__WEBPACK_IMPORTED_MODULE_7__.depx)(themeRef.value.self[(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_8__.createKey)('optionHeight', props.size)]);
    });
    const paddingRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      return (0,seemly__WEBPACK_IMPORTED_MODULE_7__.getPadding)(themeRef.value.self[(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_8__.createKey)('padding', props.size)]);
    });
    const valueSetRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      if (props.multiple && Array.isArray(props.value)) {
        return new Set(props.value);
      }
      return new Set();
    });
    const emptyRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const tmNodes = flattenedNodesRef.value;
      return tmNodes && tmNodes.length === 0;
    });
    function doToggle(tmNode) {
      const {
        onToggle
      } = props;
      if (onToggle) onToggle(tmNode);
    }
    function doScroll(e) {
      const {
        onScroll
      } = props;
      if (onScroll) onScroll(e);
    }
    // required, scroller sync need to be triggered manually
    function handleVirtualListScroll(e) {
      var _a;
      (_a = scrollbarRef.value) === null || _a === void 0 ? void 0 : _a.sync();
      doScroll(e);
    }
    function handleVirtualListResize() {
      var _a;
      (_a = scrollbarRef.value) === null || _a === void 0 ? void 0 : _a.sync();
    }
    function getPendingTmNode() {
      const {
        value: pendingTmNode
      } = pendingNodeRef;
      if (pendingTmNode) return pendingTmNode;
      return null;
    }
    function handleOptionMouseEnter(e, tmNode) {
      if (tmNode.disabled) return;
      setPendingTmNode(tmNode, false);
    }
    function handleOptionClick(e, tmNode) {
      if (tmNode.disabled) return;
      doToggle(tmNode);
    }
    // keyboard related methods
    function handleKeyUp(e) {
      var _a;
      if ((0,seemly__WEBPACK_IMPORTED_MODULE_9__.happensIn)(e, 'action')) return;
      (_a = props.onKeyup) === null || _a === void 0 ? void 0 : _a.call(props, e);
    }
    function handleKeyDown(e) {
      var _a;
      if ((0,seemly__WEBPACK_IMPORTED_MODULE_9__.happensIn)(e, 'action')) return;
      (_a = props.onKeydown) === null || _a === void 0 ? void 0 : _a.call(props, e);
    }
    function handleMouseDown(e) {
      var _a;
      (_a = props.onMousedown) === null || _a === void 0 ? void 0 : _a.call(props, e);
      if (props.focusable) return;
      e.preventDefault();
    }
    function next() {
      const {
        value: pendingTmNode
      } = pendingNodeRef;
      if (pendingTmNode) {
        setPendingTmNode(pendingTmNode.getNext({
          loop: true
        }), true);
      }
    }
    function prev() {
      const {
        value: pendingTmNode
      } = pendingNodeRef;
      if (pendingTmNode) {
        setPendingTmNode(pendingTmNode.getPrev({
          loop: true
        }), true);
      }
    }
    function setPendingTmNode(tmNode, doScroll = false) {
      pendingNodeRef.value = tmNode;
      if (doScroll) scrollToPendingNode();
    }
    function scrollToPendingNode() {
      var _a, _b;
      const tmNode = pendingNodeRef.value;
      if (!tmNode) return;
      const fIndex = fIndexGetterRef.value(tmNode.key);
      if (fIndex === null) return;
      if (props.virtualScroll) {
        (_a = virtualListRef.value) === null || _a === void 0 ? void 0 : _a.scrollTo({
          index: fIndex
        });
      } else {
        (_b = scrollbarRef.value) === null || _b === void 0 ? void 0 : _b.scrollTo({
          index: fIndex,
          elSize: itemSizeRef.value
        });
      }
    }
    function handleFocusin(e) {
      var _a, _b;
      if ((_a = selfRef.value) === null || _a === void 0 ? void 0 : _a.contains(e.target)) {
        (_b = props.onFocus) === null || _b === void 0 ? void 0 : _b.call(props, e);
      }
    }
    function handleFocusout(e) {
      var _a, _b;
      if (!((_a = selfRef.value) === null || _a === void 0 ? void 0 : _a.contains(e.relatedTarget))) {
        (_b = props.onBlur) === null || _b === void 0 ? void 0 : _b.call(props, e);
      }
    }
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.provide)(_interface_mjs__WEBPACK_IMPORTED_MODULE_10__.internalSelectionMenuInjectionKey, {
      handleOptionMouseEnter,
      handleOptionClick,
      valueSetRef,
      pendingTmNodeRef: pendingNodeRef,
      nodePropsRef: (0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'nodeProps'),
      showCheckmarkRef: (0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'showCheckmark'),
      multipleRef: (0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'multiple'),
      valueRef: (0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'value'),
      renderLabelRef: (0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'renderLabel'),
      renderOptionRef: (0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'renderOption'),
      labelFieldRef: (0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'labelField'),
      valueFieldRef: (0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'valueField')
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.provide)(_interface_mjs__WEBPACK_IMPORTED_MODULE_10__.internalSelectionMenuBodyInjectionKey, selfRef);
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(() => {
      const {
        value
      } = scrollbarRef;
      if (value) value.sync();
    });
    const cssVarsRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const {
        size
      } = props;
      const {
        common: {
          cubicBezierEaseInOut
        },
        self: {
          height,
          borderRadius,
          color,
          groupHeaderTextColor,
          actionDividerColor,
          optionTextColorPressed,
          optionTextColor,
          optionTextColorDisabled,
          optionTextColorActive,
          optionOpacityDisabled,
          optionCheckColor,
          actionTextColor,
          optionColorPending,
          optionColorActive,
          loadingColor,
          loadingSize,
          optionColorActivePending,
          [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_8__.createKey)('optionFontSize', size)]: fontSize,
          [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_8__.createKey)('optionHeight', size)]: optionHeight,
          [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_8__.createKey)('optionPadding', size)]: optionPadding
        }
      } = themeRef.value;
      return {
        '--n-height': height,
        '--n-action-divider-color': actionDividerColor,
        '--n-action-text-color': actionTextColor,
        '--n-bezier': cubicBezierEaseInOut,
        '--n-border-radius': borderRadius,
        '--n-color': color,
        '--n-option-font-size': fontSize,
        '--n-group-header-text-color': groupHeaderTextColor,
        '--n-option-check-color': optionCheckColor,
        '--n-option-color-pending': optionColorPending,
        '--n-option-color-active': optionColorActive,
        '--n-option-color-active-pending': optionColorActivePending,
        '--n-option-height': optionHeight,
        '--n-option-opacity-disabled': optionOpacityDisabled,
        '--n-option-text-color': optionTextColor,
        '--n-option-text-color-active': optionTextColorActive,
        '--n-option-text-color-disabled': optionTextColorDisabled,
        '--n-option-text-color-pressed': optionTextColorPressed,
        '--n-option-padding': optionPadding,
        '--n-option-padding-left': (0,seemly__WEBPACK_IMPORTED_MODULE_7__.getPadding)(optionPadding, 'left'),
        '--n-option-padding-right': (0,seemly__WEBPACK_IMPORTED_MODULE_7__.getPadding)(optionPadding, 'right'),
        '--n-loading-color': loadingColor,
        '--n-loading-size': loadingSize
      };
    });
    const {
      inlineThemeDisabled
    } = props;
    const themeClassHandle = inlineThemeDisabled ? (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_11__.useThemeClass)('internal-select-menu', (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => props.size[0]), cssVarsRef, props) : undefined;
    const exposedProps = {
      selfRef,
      next,
      prev,
      getPendingTmNode
    };
    (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_12__.useOnResize)(selfRef, props.onResize);
    return Object.assign({
      mergedTheme: themeRef,
      mergedClsPrefix: mergedClsPrefixRef,
      rtlEnabled: rtlEnabledRef,
      virtualListRef,
      scrollbarRef,
      itemSize: itemSizeRef,
      padding: paddingRef,
      flattenedNodes: flattenedNodesRef,
      empty: emptyRef,
      virtualListContainer() {
        const {
          value
        } = virtualListRef;
        return value === null || value === void 0 ? void 0 : value.listElRef;
      },
      virtualListContent() {
        const {
          value
        } = virtualListRef;
        return value === null || value === void 0 ? void 0 : value.itemsElRef;
      },
      doScroll,
      handleFocusin,
      handleFocusout,
      handleKeyUp,
      handleKeyDown,
      handleMouseDown,
      handleVirtualListResize,
      handleVirtualListScroll,
      cssVars: inlineThemeDisabled ? undefined : cssVarsRef,
      themeClass: themeClassHandle === null || themeClassHandle === void 0 ? void 0 : themeClassHandle.themeClass,
      onRender: themeClassHandle === null || themeClassHandle === void 0 ? void 0 : themeClassHandle.onRender
    }, exposedProps);
  },
  render() {
    const {
      $slots,
      virtualScroll,
      clsPrefix,
      mergedTheme,
      themeClass,
      onRender
    } = this;
    onRender === null || onRender === void 0 ? void 0 : onRender();
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      ref: "selfRef",
      tabindex: this.focusable ? 0 : -1,
      class: [`${clsPrefix}-base-select-menu`, this.rtlEnabled && `${clsPrefix}-base-select-menu--rtl`, themeClass, this.multiple && `${clsPrefix}-base-select-menu--multiple`],
      style: this.cssVars,
      onFocusin: this.handleFocusin,
      onFocusout: this.handleFocusout,
      onKeyup: this.handleKeyUp,
      onKeydown: this.handleKeyDown,
      onMousedown: this.handleMouseDown,
      onMouseenter: this.onMouseenter,
      onMouseleave: this.onMouseleave
    }, (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__.resolveWrappedSlot)($slots.header, children => children && (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${clsPrefix}-base-select-menu__header`,
      "data-header": true,
      key: "header"
    }, children)), this.loading ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${clsPrefix}-base-select-menu__loading`
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_loading_index_mjs__WEBPACK_IMPORTED_MODULE_14__["default"], {
      clsPrefix: clsPrefix,
      strokeWidth: 20
    })) : !this.empty ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_scrollbar_index_mjs__WEBPACK_IMPORTED_MODULE_15__["default"], {
      ref: "scrollbarRef",
      theme: mergedTheme.peers.Scrollbar,
      themeOverrides: mergedTheme.peerOverrides.Scrollbar,
      scrollable: this.scrollable,
      container: virtualScroll ? this.virtualListContainer : undefined,
      content: virtualScroll ? this.virtualListContent : undefined,
      onScroll: virtualScroll ? undefined : this.doScroll
    }, {
      default: () => {
        return virtualScroll ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vueuc__WEBPACK_IMPORTED_MODULE_16__["default"], {
          ref: "virtualListRef",
          class: `${clsPrefix}-virtual-list`,
          items: this.flattenedNodes,
          itemSize: this.itemSize,
          showScrollbar: false,
          paddingTop: this.padding.top,
          paddingBottom: this.padding.bottom,
          onResize: this.handleVirtualListResize,
          onScroll: this.handleVirtualListScroll,
          itemResizable: true
        }, {
          default: ({
            item: tmNode
          }) => {
            return tmNode.isGroup ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_SelectGroupHeader_mjs__WEBPACK_IMPORTED_MODULE_17__["default"], {
              key: tmNode.key,
              clsPrefix: clsPrefix,
              tmNode: tmNode
            }) : tmNode.ignored ? null : (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_SelectOption_mjs__WEBPACK_IMPORTED_MODULE_18__["default"], {
              clsPrefix: clsPrefix,
              key: tmNode.key,
              tmNode: tmNode
            });
          }
        }) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
          class: `${clsPrefix}-base-select-menu-option-wrapper`,
          style: {
            paddingTop: this.padding.top,
            paddingBottom: this.padding.bottom
          }
        }, this.flattenedNodes.map(tmNode => tmNode.isGroup ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_SelectGroupHeader_mjs__WEBPACK_IMPORTED_MODULE_17__["default"], {
          key: tmNode.key,
          clsPrefix: clsPrefix,
          tmNode: tmNode
        }) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_SelectOption_mjs__WEBPACK_IMPORTED_MODULE_18__["default"], {
          clsPrefix: clsPrefix,
          key: tmNode.key,
          tmNode: tmNode
        })));
      }
    }) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${clsPrefix}-base-select-menu__empty`,
      "data-empty": true
    }, (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__.resolveSlot)($slots.empty, () => [(0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_empty_index_mjs__WEBPACK_IMPORTED_MODULE_19__["default"], {
      theme: mergedTheme.peers.Empty,
      themeOverrides: mergedTheme.peerOverrides.Empty
    })])), (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__.resolveWrappedSlot)($slots.action, children => children && [(0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${clsPrefix}-base-select-menu__action`,
      "data-action": true,
      key: "action"
    }, children), (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_focus_detector_index_mjs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      onFocus: this.onTabOut,
      key: "focus-detector"
    })]));
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/select-menu/src/SelectOption.mjs":
/*!*****************************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/select-menu/src/SelectOption.mjs ***!
  \*****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/use-memo.js");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/vue/render.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/vue/merge-handlers.mjs");
/* harmony import */ var _icons_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../icons/index.mjs */ "./node_modules/naive-ui/es/_internal/icons/Checkmark.mjs");
/* harmony import */ var _icon_index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../icon/index.mjs */ "./node_modules/naive-ui/es/_internal/icon/src/Icon.mjs");
/* harmony import */ var _interface_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./interface.mjs */ "./node_modules/naive-ui/es/_internal/select-menu/src/interface.mjs");






function renderCheckMark(show, clsPrefix) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vue__WEBPACK_IMPORTED_MODULE_0__.Transition, {
    name: "fade-in-scale-up-transition"
  }, {
    default: () => show ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_icon_index_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], {
      clsPrefix: clsPrefix,
      class: `${clsPrefix}-base-select-option__check`
    }, {
      default: () => (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_icons_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"])
    }) : null
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'NBaseSelectOption',
  props: {
    clsPrefix: {
      type: String,
      required: true
    },
    tmNode: {
      type: Object,
      required: true
    }
  },
  setup(props) {
    const {
      valueRef,
      pendingTmNodeRef,
      multipleRef,
      valueSetRef,
      renderLabelRef,
      renderOptionRef,
      labelFieldRef,
      valueFieldRef,
      showCheckmarkRef,
      nodePropsRef,
      handleOptionClick,
      handleOptionMouseEnter
    } = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(_interface_mjs__WEBPACK_IMPORTED_MODULE_3__.internalSelectionMenuInjectionKey);
    const isPendingRef = (0,vooks__WEBPACK_IMPORTED_MODULE_4__["default"])(() => {
      const {
        value: pendingTmNode
      } = pendingTmNodeRef;
      if (!pendingTmNode) return false;
      return props.tmNode.key === pendingTmNode.key;
    });
    function handleClick(e) {
      const {
        tmNode
      } = props;
      if (tmNode.disabled) return;
      handleOptionClick(e, tmNode);
    }
    function handleMouseEnter(e) {
      const {
        tmNode
      } = props;
      if (tmNode.disabled) return;
      handleOptionMouseEnter(e, tmNode);
    }
    function handleMouseMove(e) {
      const {
        tmNode
      } = props;
      const {
        value: isPending
      } = isPendingRef;
      if (tmNode.disabled || isPending) return;
      handleOptionMouseEnter(e, tmNode);
    }
    return {
      multiple: multipleRef,
      isGrouped: (0,vooks__WEBPACK_IMPORTED_MODULE_4__["default"])(() => {
        const {
          tmNode
        } = props;
        const {
          parent
        } = tmNode;
        return parent && parent.rawNode.type === 'group';
      }),
      showCheckmark: showCheckmarkRef,
      nodeProps: nodePropsRef,
      isPending: isPendingRef,
      isSelected: (0,vooks__WEBPACK_IMPORTED_MODULE_4__["default"])(() => {
        const {
          value
        } = valueRef;
        const {
          value: multiple
        } = multipleRef;
        if (value === null) return false;
        const optionValue = props.tmNode.rawNode[valueFieldRef.value];
        if (multiple) {
          const {
            value: valueSet
          } = valueSetRef;
          return valueSet.has(optionValue);
        } else {
          return value === optionValue;
        }
      }),
      labelField: labelFieldRef,
      renderLabel: renderLabelRef,
      renderOption: renderOptionRef,
      handleMouseMove,
      handleMouseEnter,
      handleClick
    };
  },
  render() {
    const {
      clsPrefix,
      tmNode: {
        rawNode
      },
      isSelected,
      isPending,
      isGrouped,
      showCheckmark,
      nodeProps,
      renderOption,
      renderLabel,
      handleClick,
      handleMouseEnter,
      handleMouseMove
    } = this;
    const checkmark = renderCheckMark(isSelected, clsPrefix);
    const children = renderLabel ? [renderLabel(rawNode, isSelected), showCheckmark && checkmark] : [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_5__.render)(rawNode[this.labelField], rawNode, isSelected), showCheckmark && checkmark];
    const attrs = nodeProps === null || nodeProps === void 0 ? void 0 : nodeProps(rawNode);
    const node = (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", Object.assign({}, attrs, {
      class: [`${clsPrefix}-base-select-option`, rawNode.class, attrs === null || attrs === void 0 ? void 0 : attrs.class, {
        [`${clsPrefix}-base-select-option--disabled`]: rawNode.disabled,
        [`${clsPrefix}-base-select-option--selected`]: isSelected,
        [`${clsPrefix}-base-select-option--grouped`]: isGrouped,
        [`${clsPrefix}-base-select-option--pending`]: isPending,
        [`${clsPrefix}-base-select-option--show-checkmark`]: showCheckmark
      }],
      style: [(attrs === null || attrs === void 0 ? void 0 : attrs.style) || '', rawNode.style || ''],
      onClick: (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_6__.mergeEventHandlers)([handleClick, attrs === null || attrs === void 0 ? void 0 : attrs.onClick]),
      onMouseenter: (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_6__.mergeEventHandlers)([handleMouseEnter, attrs === null || attrs === void 0 ? void 0 : attrs.onMouseenter]),
      onMousemove: (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_6__.mergeEventHandlers)([handleMouseMove, attrs === null || attrs === void 0 ? void 0 : attrs.onMousemove])
    }), (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${clsPrefix}-base-select-option__content`
    }, children));
    return rawNode.render ? rawNode.render({
      node,
      option: rawNode,
      selected: isSelected
    }) : renderOption ? renderOption({
      node,
      option: rawNode,
      selected: isSelected
    }) : node;
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/select-menu/src/styles/index.cssr.mjs":
/*!**********************************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/select-menu/src/styles/index.cssr.mjs ***!
  \**********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../_utils/cssr/index.mjs */ "./node_modules/naive-ui/es/_utils/cssr/index.mjs");
/* harmony import */ var _styles_transitions_fade_in_scale_up_cssr_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../_styles/transitions/fade-in-scale-up.cssr.mjs */ "./node_modules/naive-ui/es/_styles/transitions/fade-in-scale-up.cssr.mjs");


// --n-loading-color
// --n-loading-size
// --n-option-padding-right
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-select-menu', `
 line-height: 1.5;
 outline: none;
 z-index: 0;
 position: relative;
 border-radius: var(--n-border-radius);
 transition:
 background-color .3s var(--n-bezier),
 box-shadow .3s var(--n-bezier);
 background-color: var(--n-color);
`, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('scrollbar', `
 max-height: var(--n-height);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('virtual-list', `
 max-height: var(--n-height);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-select-option', `
 min-height: var(--n-option-height);
 font-size: var(--n-option-font-size);
 display: flex;
 align-items: center;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('content', `
 z-index: 1;
 white-space: nowrap;
 text-overflow: ellipsis;
 overflow: hidden;
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-select-group-header', `
 min-height: var(--n-option-height);
 font-size: .93em;
 display: flex;
 align-items: center;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-select-menu-option-wrapper', `
 position: relative;
 width: 100%;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('loading, empty', `
 display: flex;
 padding: 12px 32px;
 flex: 1;
 justify-content: center;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('loading', `
 color: var(--n-loading-color);
 font-size: var(--n-loading-size);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('header', `
 padding: 8px var(--n-option-padding-left);
 font-size: var(--n-option-font-size);
 transition: 
 color .3s var(--n-bezier),
 border-color .3s var(--n-bezier);
 border-bottom: 1px solid var(--n-action-divider-color);
 color: var(--n-action-text-color);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('action', `
 padding: 8px var(--n-option-padding-left);
 font-size: var(--n-option-font-size);
 transition: 
 color .3s var(--n-bezier),
 border-color .3s var(--n-bezier);
 border-top: 1px solid var(--n-action-divider-color);
 color: var(--n-action-text-color);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-select-group-header', `
 position: relative;
 cursor: default;
 padding: var(--n-option-padding);
 color: var(--n-group-header-text-color);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-select-option', `
 cursor: pointer;
 position: relative;
 padding: var(--n-option-padding);
 transition:
 color .3s var(--n-bezier),
 opacity .3s var(--n-bezier);
 box-sizing: border-box;
 color: var(--n-option-text-color);
 opacity: 1;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('show-checkmark', `
 padding-right: calc(var(--n-option-padding-right) + 20px);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&::before', `
 content: "";
 position: absolute;
 left: 4px;
 right: 4px;
 top: 0;
 bottom: 0;
 border-radius: var(--n-border-radius);
 transition: background-color .3s var(--n-bezier);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:active', `
 color: var(--n-option-text-color-pressed);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('grouped', `
 padding-left: calc(var(--n-option-padding-left) * 1.5);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('pending', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&::before', `
 background-color: var(--n-option-color-pending);
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('selected', `
 color: var(--n-option-text-color-active);
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&::before', `
 background-color: var(--n-option-color-active);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('pending', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&::before', `
 background-color: var(--n-option-color-active-pending);
 `)])]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('disabled', `
 cursor: not-allowed;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cNotM)('selected', `
 color: var(--n-option-text-color-disabled);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('selected', `
 opacity: var(--n-option-opacity-disabled);
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('check', `
 font-size: 16px;
 position: absolute;
 right: calc(var(--n-option-padding-right) - 4px);
 top: calc(50% - 7px);
 color: var(--n-option-check-color);
 transition: color .3s var(--n-bezier);
 `, [(0,_styles_transitions_fade_in_scale_up_cssr_mjs__WEBPACK_IMPORTED_MODULE_1__.fadeInScaleUpTransition)({
  enterScale: '0.5'
})])])]));

/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/selection/src/Selection.mjs":
/*!************************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/selection/src/Selection.mjs ***!
  \************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var vueuc__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! vueuc */ "./node_modules/vueuc/es/overflow/src/index.js");
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/css/index.js");
/* harmony import */ var _popover_index_mjs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../../popover/index.mjs */ "./node_modules/naive-ui/es/popover/src/Popover.mjs");
/* harmony import */ var _tag_index_mjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../../tag/index.mjs */ "./node_modules/naive-ui/es/tag/src/Tag.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-theme.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-config.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-rtl.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-css-vars-class.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/vue/render.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/composable/use-resize.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/cssr/index.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/vue/wrapper.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/naive/attribute.mjs");
/* harmony import */ var _suffix_index_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../suffix/index.mjs */ "./node_modules/naive-ui/es/_internal/suffix/src/Suffix.mjs");
/* harmony import */ var _styles_index_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../styles/index.mjs */ "./node_modules/naive-ui/es/_internal/selection/styles/light.mjs");
/* harmony import */ var _styles_index_cssr_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./styles/index.cssr.mjs */ "./node_modules/naive-ui/es/_internal/selection/src/styles/index.cssr.mjs");










/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'InternalSelection',
  props: Object.assign(Object.assign({}, _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].props), {
    clsPrefix: {
      type: String,
      required: true
    },
    bordered: {
      type: Boolean,
      default: undefined
    },
    active: Boolean,
    pattern: {
      type: String,
      default: ''
    },
    placeholder: String,
    selectedOption: {
      type: Object,
      default: null
    },
    selectedOptions: {
      type: Array,
      default: null
    },
    labelField: {
      type: String,
      default: 'label'
    },
    valueField: {
      type: String,
      default: 'value'
    },
    multiple: Boolean,
    filterable: Boolean,
    clearable: Boolean,
    disabled: Boolean,
    size: {
      type: String,
      default: 'medium'
    },
    loading: Boolean,
    autofocus: Boolean,
    showArrow: {
      type: Boolean,
      default: true
    },
    inputProps: Object,
    focused: Boolean,
    renderTag: Function,
    onKeydown: Function,
    onClick: Function,
    onBlur: Function,
    onFocus: Function,
    onDeleteOption: Function,
    maxTagCount: [String, Number],
    ellipsisTagPopoverProps: Object,
    onClear: Function,
    onPatternInput: Function,
    onPatternFocus: Function,
    onPatternBlur: Function,
    renderLabel: Function,
    status: String,
    inlineThemeDisabled: Boolean,
    ignoreComposition: {
      type: Boolean,
      default: true
    },
    onResize: Function
  }),
  setup(props) {
    const {
      mergedClsPrefixRef,
      mergedRtlRef
    } = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"])(props);
    const rtlEnabledRef = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_3__.useRtl)('InternalSelection', mergedRtlRef, mergedClsPrefixRef);
    const patternInputMirrorRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    const patternInputRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    const selfRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    const multipleElRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    const singleElRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    const patternInputWrapperRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    const counterRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    const counterWrapperRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    const overflowRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    const inputTagElRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    const showTagsPopoverRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    const patternInputFocusedRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    const hoverRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    const themeRef = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])('InternalSelection', '-internal-selection', _styles_index_cssr_mjs__WEBPACK_IMPORTED_MODULE_4__["default"], _styles_index_mjs__WEBPACK_IMPORTED_MODULE_5__["default"], props, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'clsPrefix'));
    const mergedClearableRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      return props.clearable && !props.disabled && (hoverRef.value || props.active);
    });
    const filterablePlaceholderRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      return props.selectedOption ? props.renderTag ? props.renderTag({
        option: props.selectedOption,
        handleClose: () => {}
      }) : props.renderLabel ? props.renderLabel(props.selectedOption, true) : (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_6__.render)(props.selectedOption[props.labelField], props.selectedOption, true) : props.placeholder;
    });
    const labelRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const option = props.selectedOption;
      if (!option) return undefined;
      return option[props.labelField];
    });
    const selectedRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      if (props.multiple) {
        return !!(Array.isArray(props.selectedOptions) && props.selectedOptions.length);
      } else {
        return props.selectedOption !== null;
      }
    });
    function syncMirrorWidth() {
      var _a;
      const {
        value: patternInputMirrorEl
      } = patternInputMirrorRef;
      if (patternInputMirrorEl) {
        const {
          value: patternInputEl
        } = patternInputRef;
        if (patternInputEl) {
          patternInputEl.style.width = `${patternInputMirrorEl.offsetWidth}px`;
          if (props.maxTagCount !== 'responsive') {
            (_a = overflowRef.value) === null || _a === void 0 ? void 0 : _a.sync({
              showAllItemsBeforeCalculate: false
            });
          }
        }
      }
    }
    function hideInputTag() {
      const {
        value: inputTagEl
      } = inputTagElRef;
      if (inputTagEl) inputTagEl.style.display = 'none';
    }
    function showInputTag() {
      const {
        value: inputTagEl
      } = inputTagElRef;
      if (inputTagEl) inputTagEl.style.display = 'inline-block';
    }
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)((0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'active'), value => {
      if (!value) hideInputTag();
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)((0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'pattern'), () => {
      if (props.multiple) {
        void (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(syncMirrorWidth);
      }
    });
    function doFocus(e) {
      const {
        onFocus
      } = props;
      if (onFocus) onFocus(e);
    }
    function doBlur(e) {
      const {
        onBlur
      } = props;
      if (onBlur) onBlur(e);
    }
    function doDeleteOption(value) {
      const {
        onDeleteOption
      } = props;
      if (onDeleteOption) onDeleteOption(value);
    }
    function doClear(e) {
      const {
        onClear
      } = props;
      if (onClear) onClear(e);
    }
    function doPatternInput(value) {
      const {
        onPatternInput
      } = props;
      if (onPatternInput) onPatternInput(value);
    }
    function handleFocusin(e) {
      var _a;
      if (!e.relatedTarget || !((_a = selfRef.value) === null || _a === void 0 ? void 0 : _a.contains(e.relatedTarget))) {
        doFocus(e);
      }
    }
    function handleFocusout(e) {
      var _a;
      if ((_a = selfRef.value) === null || _a === void 0 ? void 0 : _a.contains(e.relatedTarget)) return;
      doBlur(e);
    }
    function handleClear(e) {
      doClear(e);
    }
    function handleMouseEnter() {
      hoverRef.value = true;
    }
    function handleMouseLeave() {
      hoverRef.value = false;
    }
    function handleMouseDown(e) {
      if (!props.active || !props.filterable) return;
      if (e.target === patternInputRef.value) return;
      e.preventDefault();
    }
    function handleDeleteOption(option) {
      doDeleteOption(option);
    }
    const isComposingRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    function handlePatternKeyDown(e) {
      if (e.key === 'Backspace' && !isComposingRef.value) {
        if (!props.pattern.length) {
          const {
            selectedOptions
          } = props;
          if (selectedOptions === null || selectedOptions === void 0 ? void 0 : selectedOptions.length) {
            handleDeleteOption(selectedOptions[selectedOptions.length - 1]);
          }
        }
      }
    }
    // the composition end is later than its input so we can cached the event
    // and return the input event
    let cachedInputEvent = null;
    function handlePatternInputInput(e) {
      // we should sync mirror width here
      const {
        value: patternInputMirrorEl
      } = patternInputMirrorRef;
      if (patternInputMirrorEl) {
        const inputText = e.target.value;
        patternInputMirrorEl.textContent = inputText;
        syncMirrorWidth();
      }
      if (props.ignoreComposition) {
        if (!isComposingRef.value) {
          doPatternInput(e);
        } else {
          cachedInputEvent = e;
        }
      } else {
        doPatternInput(e);
      }
    }
    function handleCompositionStart() {
      isComposingRef.value = true;
    }
    function handleCompositionEnd() {
      isComposingRef.value = false;
      if (props.ignoreComposition) {
        doPatternInput(cachedInputEvent);
      }
      cachedInputEvent = null;
    }
    function handlePatternInputFocus(e) {
      var _a;
      patternInputFocusedRef.value = true;
      (_a = props.onPatternFocus) === null || _a === void 0 ? void 0 : _a.call(props, e);
    }
    function handlePatternInputBlur(e) {
      var _a;
      patternInputFocusedRef.value = false;
      (_a = props.onPatternBlur) === null || _a === void 0 ? void 0 : _a.call(props, e);
    }
    function blur() {
      var _a, _b;
      if (props.filterable) {
        patternInputFocusedRef.value = false;
        (_a = patternInputWrapperRef.value) === null || _a === void 0 ? void 0 : _a.blur();
        (_b = patternInputRef.value) === null || _b === void 0 ? void 0 : _b.blur();
      } else if (props.multiple) {
        const {
          value: multipleEl
        } = multipleElRef;
        multipleEl === null || multipleEl === void 0 ? void 0 : multipleEl.blur();
      } else {
        const {
          value: singleEl
        } = singleElRef;
        singleEl === null || singleEl === void 0 ? void 0 : singleEl.blur();
      }
    }
    function focus() {
      var _a, _b, _c;
      if (props.filterable) {
        patternInputFocusedRef.value = false;
        (_a = patternInputWrapperRef.value) === null || _a === void 0 ? void 0 : _a.focus();
      } else if (props.multiple) {
        (_b = multipleElRef.value) === null || _b === void 0 ? void 0 : _b.focus();
      } else {
        (_c = singleElRef.value) === null || _c === void 0 ? void 0 : _c.focus();
      }
    }
    function focusInput() {
      const {
        value: patternInputEl
      } = patternInputRef;
      if (patternInputEl) {
        showInputTag();
        patternInputEl.focus();
      }
    }
    function blurInput() {
      const {
        value: patternInputEl
      } = patternInputRef;
      if (patternInputEl) {
        patternInputEl.blur();
      }
    }
    function updateCounter(count) {
      const {
        value
      } = counterRef;
      if (value) {
        value.setTextContent(`+${count}`);
      }
    }
    function getCounter() {
      const {
        value
      } = counterWrapperRef;
      return value;
    }
    function getTail() {
      return patternInputRef.value;
    }
    let enterTimerId = null;
    function clearEnterTimer() {
      if (enterTimerId !== null) window.clearTimeout(enterTimerId);
    }
    function handleMouseEnterCounter() {
      if (props.active) return;
      clearEnterTimer();
      enterTimerId = window.setTimeout(() => {
        if (selectedRef.value) {
          showTagsPopoverRef.value = true;
        }
      }, 100);
    }
    function handleMouseLeaveCounter() {
      clearEnterTimer();
    }
    function onPopoverUpdateShow(show) {
      if (!show) {
        clearEnterTimer();
        showTagsPopoverRef.value = false;
      }
    }
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(selectedRef, value => {
      if (!value) {
        showTagsPopoverRef.value = false;
      }
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(() => {
      (0,vue__WEBPACK_IMPORTED_MODULE_0__.watchEffect)(() => {
        const patternInputWrapperEl = patternInputWrapperRef.value;
        if (!patternInputWrapperEl) return;
        if (props.disabled) {
          patternInputWrapperEl.removeAttribute('tabindex');
        } else {
          patternInputWrapperEl.tabIndex = patternInputFocusedRef.value ? -1 : 0;
        }
      });
    });
    (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_7__.useOnResize)(selfRef, props.onResize);
    const {
      inlineThemeDisabled
    } = props;
    const cssVarsRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const {
        size
      } = props;
      const {
        common: {
          cubicBezierEaseInOut
        },
        self: {
          borderRadius,
          color,
          placeholderColor,
          textColor,
          paddingSingle,
          paddingMultiple,
          caretColor,
          colorDisabled,
          textColorDisabled,
          placeholderColorDisabled,
          colorActive,
          boxShadowFocus,
          boxShadowActive,
          boxShadowHover,
          border,
          borderFocus,
          borderHover,
          borderActive,
          arrowColor,
          arrowColorDisabled,
          loadingColor,
          // form warning
          colorActiveWarning,
          boxShadowFocusWarning,
          boxShadowActiveWarning,
          boxShadowHoverWarning,
          borderWarning,
          borderFocusWarning,
          borderHoverWarning,
          borderActiveWarning,
          // form error
          colorActiveError,
          boxShadowFocusError,
          boxShadowActiveError,
          boxShadowHoverError,
          borderError,
          borderFocusError,
          borderHoverError,
          borderActiveError,
          // clear
          clearColor,
          clearColorHover,
          clearColorPressed,
          clearSize,
          // arrow
          arrowSize,
          [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_8__.createKey)('height', size)]: height,
          [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_8__.createKey)('fontSize', size)]: fontSize
        }
      } = themeRef.value;
      const paddingSingleDiscrete = (0,seemly__WEBPACK_IMPORTED_MODULE_9__.getPadding)(paddingSingle);
      const paddingMultipleDiscrete = (0,seemly__WEBPACK_IMPORTED_MODULE_9__.getPadding)(paddingMultiple);
      return {
        '--n-bezier': cubicBezierEaseInOut,
        '--n-border': border,
        '--n-border-active': borderActive,
        '--n-border-focus': borderFocus,
        '--n-border-hover': borderHover,
        '--n-border-radius': borderRadius,
        '--n-box-shadow-active': boxShadowActive,
        '--n-box-shadow-focus': boxShadowFocus,
        '--n-box-shadow-hover': boxShadowHover,
        '--n-caret-color': caretColor,
        '--n-color': color,
        '--n-color-active': colorActive,
        '--n-color-disabled': colorDisabled,
        '--n-font-size': fontSize,
        '--n-height': height,
        '--n-padding-single-top': paddingSingleDiscrete.top,
        '--n-padding-multiple-top': paddingMultipleDiscrete.top,
        '--n-padding-single-right': paddingSingleDiscrete.right,
        '--n-padding-multiple-right': paddingMultipleDiscrete.right,
        '--n-padding-single-left': paddingSingleDiscrete.left,
        '--n-padding-multiple-left': paddingMultipleDiscrete.left,
        '--n-padding-single-bottom': paddingSingleDiscrete.bottom,
        '--n-padding-multiple-bottom': paddingMultipleDiscrete.bottom,
        '--n-placeholder-color': placeholderColor,
        '--n-placeholder-color-disabled': placeholderColorDisabled,
        '--n-text-color': textColor,
        '--n-text-color-disabled': textColorDisabled,
        '--n-arrow-color': arrowColor,
        '--n-arrow-color-disabled': arrowColorDisabled,
        '--n-loading-color': loadingColor,
        // form warning
        '--n-color-active-warning': colorActiveWarning,
        '--n-box-shadow-focus-warning': boxShadowFocusWarning,
        '--n-box-shadow-active-warning': boxShadowActiveWarning,
        '--n-box-shadow-hover-warning': boxShadowHoverWarning,
        '--n-border-warning': borderWarning,
        '--n-border-focus-warning': borderFocusWarning,
        '--n-border-hover-warning': borderHoverWarning,
        '--n-border-active-warning': borderActiveWarning,
        // form error
        '--n-color-active-error': colorActiveError,
        '--n-box-shadow-focus-error': boxShadowFocusError,
        '--n-box-shadow-active-error': boxShadowActiveError,
        '--n-box-shadow-hover-error': boxShadowHoverError,
        '--n-border-error': borderError,
        '--n-border-focus-error': borderFocusError,
        '--n-border-hover-error': borderHoverError,
        '--n-border-active-error': borderActiveError,
        // clear
        '--n-clear-size': clearSize,
        '--n-clear-color': clearColor,
        '--n-clear-color-hover': clearColorHover,
        '--n-clear-color-pressed': clearColorPressed,
        // arrow-size
        '--n-arrow-size': arrowSize
      };
    });
    const themeClassHandle = inlineThemeDisabled ? (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_10__.useThemeClass)('internal-selection', (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      return props.size[0];
    }), cssVarsRef, props) : undefined;
    return {
      mergedTheme: themeRef,
      mergedClearable: mergedClearableRef,
      mergedClsPrefix: mergedClsPrefixRef,
      rtlEnabled: rtlEnabledRef,
      patternInputFocused: patternInputFocusedRef,
      filterablePlaceholder: filterablePlaceholderRef,
      label: labelRef,
      selected: selectedRef,
      showTagsPanel: showTagsPopoverRef,
      isComposing: isComposingRef,
      // dom ref
      counterRef,
      counterWrapperRef,
      patternInputMirrorRef,
      patternInputRef,
      selfRef,
      multipleElRef,
      singleElRef,
      patternInputWrapperRef,
      overflowRef,
      inputTagElRef,
      handleMouseDown,
      handleFocusin,
      handleClear,
      handleMouseEnter,
      handleMouseLeave,
      handleDeleteOption,
      handlePatternKeyDown,
      handlePatternInputInput,
      handlePatternInputBlur,
      handlePatternInputFocus,
      handleMouseEnterCounter,
      handleMouseLeaveCounter,
      handleFocusout,
      handleCompositionEnd,
      handleCompositionStart,
      onPopoverUpdateShow,
      focus,
      focusInput,
      blur,
      blurInput,
      updateCounter,
      getCounter,
      getTail,
      renderLabel: props.renderLabel,
      cssVars: inlineThemeDisabled ? undefined : cssVarsRef,
      themeClass: themeClassHandle === null || themeClassHandle === void 0 ? void 0 : themeClassHandle.themeClass,
      onRender: themeClassHandle === null || themeClassHandle === void 0 ? void 0 : themeClassHandle.onRender
    };
  },
  render() {
    const {
      status,
      multiple,
      size,
      disabled,
      filterable,
      maxTagCount,
      bordered,
      clsPrefix,
      ellipsisTagPopoverProps,
      onRender,
      renderTag,
      renderLabel
    } = this;
    onRender === null || onRender === void 0 ? void 0 : onRender();
    const maxTagCountResponsive = maxTagCount === 'responsive';
    const maxTagCountNumeric = typeof maxTagCount === 'number';
    const useMaxTagCount = maxTagCountResponsive || maxTagCountNumeric;
    const suffix = (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_utils_index_mjs__WEBPACK_IMPORTED_MODULE_11__.Wrapper, null, {
      default: () => (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_suffix_index_mjs__WEBPACK_IMPORTED_MODULE_12__["default"], {
        clsPrefix: clsPrefix,
        loading: this.loading,
        showArrow: this.showArrow,
        showClear: this.mergedClearable && this.selected,
        onClear: this.handleClear
      }, {
        default: () => {
          var _a, _b;
          return (_b = (_a = this.$slots).arrow) === null || _b === void 0 ? void 0 : _b.call(_a);
        }
      })
    });
    let body;
    if (multiple) {
      const {
        labelField
      } = this;
      const createTag = option => (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
        class: `${clsPrefix}-base-selection-tag-wrapper`,
        key: option.value
      }, renderTag ? renderTag({
        option,
        handleClose: () => {
          this.handleDeleteOption(option);
        }
      }) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_tag_index_mjs__WEBPACK_IMPORTED_MODULE_13__["default"], {
        size: size,
        closable: !option.disabled,
        disabled: disabled,
        onClose: () => {
          this.handleDeleteOption(option);
        },
        internalCloseIsButtonTag: false,
        internalCloseFocusable: false
      }, {
        default: () => renderLabel ? renderLabel(option, true) : (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_6__.render)(option[labelField], option, true)
      }));
      const createOriginalTagNodes = () => (maxTagCountNumeric ? this.selectedOptions.slice(0, maxTagCount) : this.selectedOptions).map(createTag);
      const input = filterable ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
        class: `${clsPrefix}-base-selection-input-tag`,
        ref: "inputTagElRef",
        key: "__input-tag__"
      }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("input", Object.assign({}, this.inputProps, {
        ref: "patternInputRef",
        tabindex: -1,
        disabled: disabled,
        value: this.pattern,
        autofocus: this.autofocus,
        class: `${clsPrefix}-base-selection-input-tag__input`,
        onBlur: this.handlePatternInputBlur,
        onFocus: this.handlePatternInputFocus,
        onKeydown: this.handlePatternKeyDown,
        onInput: this.handlePatternInputInput,
        onCompositionstart: this.handleCompositionStart,
        onCompositionend: this.handleCompositionEnd
      })), (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("span", {
        ref: "patternInputMirrorRef",
        class: `${clsPrefix}-base-selection-input-tag__mirror`
      }, this.pattern)) : null;
      // May Overflow
      const renderCounter = maxTagCountResponsive ? () => (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
        class: `${clsPrefix}-base-selection-tag-wrapper`,
        ref: "counterWrapperRef"
      }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_tag_index_mjs__WEBPACK_IMPORTED_MODULE_13__["default"], {
        size: size,
        ref: "counterRef",
        onMouseenter: this.handleMouseEnterCounter,
        onMouseleave: this.handleMouseLeaveCounter,
        disabled: disabled
      })) : undefined;
      let counter;
      if (maxTagCountNumeric) {
        const rest = this.selectedOptions.length - maxTagCount;
        if (rest > 0) {
          counter = (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
            class: `${clsPrefix}-base-selection-tag-wrapper`,
            key: "__counter__"
          }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_tag_index_mjs__WEBPACK_IMPORTED_MODULE_13__["default"], {
            size: size,
            ref: "counterRef",
            onMouseenter: this.handleMouseEnterCounter,
            disabled: disabled
          }, {
            default: () => `+${rest}`
          }));
        }
      }
      const tags = maxTagCountResponsive ? filterable ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vueuc__WEBPACK_IMPORTED_MODULE_14__["default"], {
        ref: "overflowRef",
        updateCounter: this.updateCounter,
        getCounter: this.getCounter,
        getTail: this.getTail,
        style: {
          width: '100%',
          display: 'flex',
          overflow: 'hidden'
        }
      }, {
        default: createOriginalTagNodes,
        counter: renderCounter,
        tail: () => input
      }) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vueuc__WEBPACK_IMPORTED_MODULE_14__["default"], {
        ref: "overflowRef",
        updateCounter: this.updateCounter,
        getCounter: this.getCounter,
        style: {
          width: '100%',
          display: 'flex',
          overflow: 'hidden'
        }
      }, {
        default: createOriginalTagNodes,
        counter: renderCounter
      }) : maxTagCountNumeric && counter ? createOriginalTagNodes().concat(counter) : createOriginalTagNodes();
      const renderPopover = useMaxTagCount ? () => (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
        class: `${clsPrefix}-base-selection-popover`
      }, maxTagCountResponsive ? createOriginalTagNodes() : this.selectedOptions.map(createTag)) : undefined;
      const popoverProps = useMaxTagCount ? Object.assign({
        show: this.showTagsPanel,
        trigger: 'hover',
        overlap: true,
        placement: 'top',
        width: 'trigger',
        onUpdateShow: this.onPopoverUpdateShow,
        theme: this.mergedTheme.peers.Popover,
        themeOverrides: this.mergedTheme.peerOverrides.Popover
      }, ellipsisTagPopoverProps) : null;
      const showPlaceholder = this.selected ? false : this.active ? !this.pattern && !this.isComposing : true;
      const placeholder = showPlaceholder ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
        class: `${clsPrefix}-base-selection-placeholder ${clsPrefix}-base-selection-overlay`
      }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
        class: `${clsPrefix}-base-selection-placeholder__inner`
      }, this.placeholder)) : null;
      const popoverTrigger = filterable ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
        ref: "patternInputWrapperRef",
        class: `${clsPrefix}-base-selection-tags`
      }, tags, maxTagCountResponsive ? null : input, suffix) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
        ref: "multipleElRef",
        class: `${clsPrefix}-base-selection-tags`,
        tabindex: disabled ? undefined : 0
      }, tags, suffix);
      body = (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, useMaxTagCount ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_popover_index_mjs__WEBPACK_IMPORTED_MODULE_15__["default"], Object.assign({}, popoverProps, {
        scrollable: true,
        style: "max-height: calc(var(--v-target-height) * 6.6);"
      }), {
        trigger: () => popoverTrigger,
        default: renderPopover
      }) : popoverTrigger, placeholder);
    } else {
      if (filterable) {
        const hasInput = this.pattern || this.isComposing;
        const showPlaceholder = this.active ? !hasInput : !this.selected;
        const showSelectedLabel = this.active ? false : this.selected;
        body = (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
          ref: "patternInputWrapperRef",
          class: `${clsPrefix}-base-selection-label`,
          title: this.patternInputFocused ? undefined : (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_16__.getTitleAttribute)(this.label)
        }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("input", Object.assign({}, this.inputProps, {
          ref: "patternInputRef",
          class: `${clsPrefix}-base-selection-input`,
          value: this.active ? this.pattern : '',
          placeholder: "",
          readonly: disabled,
          disabled: disabled,
          tabindex: -1,
          autofocus: this.autofocus,
          onFocus: this.handlePatternInputFocus,
          onBlur: this.handlePatternInputBlur,
          onInput: this.handlePatternInputInput,
          onCompositionstart: this.handleCompositionStart,
          onCompositionend: this.handleCompositionEnd
        })), showSelectedLabel ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
          class: `${clsPrefix}-base-selection-label__render-label ${clsPrefix}-base-selection-overlay`,
          key: "input"
        }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
          class: `${clsPrefix}-base-selection-overlay__wrapper`
        }, renderTag ? renderTag({
          option: this.selectedOption,
          handleClose: () => {}
        }) : renderLabel ? renderLabel(this.selectedOption, true) : (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_6__.render)(this.label, this.selectedOption, true))) : null, showPlaceholder ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
          class: `${clsPrefix}-base-selection-placeholder ${clsPrefix}-base-selection-overlay`,
          key: "placeholder"
        }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
          class: `${clsPrefix}-base-selection-overlay__wrapper`
        }, this.filterablePlaceholder)) : null, suffix);
      } else {
        body = (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
          ref: "singleElRef",
          class: `${clsPrefix}-base-selection-label`,
          tabindex: this.disabled ? undefined : 0
        }, this.label !== undefined ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
          class: `${clsPrefix}-base-selection-input`,
          title: (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_16__.getTitleAttribute)(this.label),
          key: "input"
        }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
          class: `${clsPrefix}-base-selection-input__content`
        }, renderTag ? renderTag({
          option: this.selectedOption,
          handleClose: () => {}
        }) : renderLabel ? renderLabel(this.selectedOption, true) : (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_6__.render)(this.label, this.selectedOption, true))) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
          class: `${clsPrefix}-base-selection-placeholder ${clsPrefix}-base-selection-overlay`,
          key: "placeholder"
        }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
          class: `${clsPrefix}-base-selection-placeholder__inner`
        }, this.placeholder)), suffix);
      }
    }
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      ref: "selfRef",
      class: [`${clsPrefix}-base-selection`, this.rtlEnabled && `${clsPrefix}-base-selection--rtl`, this.themeClass, status && `${clsPrefix}-base-selection--${status}-status`, {
        [`${clsPrefix}-base-selection--active`]: this.active,
        [`${clsPrefix}-base-selection--selected`]: this.selected || this.active && this.pattern,
        [`${clsPrefix}-base-selection--disabled`]: this.disabled,
        [`${clsPrefix}-base-selection--multiple`]: this.multiple,
        // focus is not controlled by selection itself since it always need
        // to be managed together with menu. provide :focus style will cause
        // many redundant codes.
        [`${clsPrefix}-base-selection--focus`]: this.focused
      }],
      style: this.cssVars,
      onClick: this.onClick,
      onMouseenter: this.handleMouseEnter,
      onMouseleave: this.handleMouseLeave,
      onKeydown: this.onKeydown,
      onFocusin: this.handleFocusin,
      onFocusout: this.handleFocusout,
      onMousedown: this.handleMouseDown
    }, body, bordered ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${clsPrefix}-base-selection__border`
    }) : null, bordered ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${clsPrefix}-base-selection__state-border`
    }) : null);
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/selection/src/styles/index.cssr.mjs":
/*!********************************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/selection/src/styles/index.cssr.mjs ***!
  \********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../_utils/cssr/index.mjs */ "./node_modules/naive-ui/es/_utils/cssr/index.mjs");

// vars:
// --n-bezier
// --n-border
// --n-border-active
// --n-border-focus
// --n-border-hover
// --n-border-radius
// --n-box-shadow-active
// --n-box-shadow-focus
// --n-box-shadow-hover
// --n-caret-color
// --n-color
// --n-color-active
// --n-color-disabled
// --n-font-size
// --n-height
// --n-padding-single
// --n-padding-multiple
// --n-placeholder-color
// --n-placeholder-color-disabled
// --n-text-color
// --n-text-color-disabled
// --n-arrow-color
// --n-arrow-size
// --n-loading-color
// ...clear vars
// ...form item vars
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)([(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-selection', `
 --n-padding-single: var(--n-padding-single-top) var(--n-padding-single-right) var(--n-padding-single-bottom) var(--n-padding-single-left);
 --n-padding-multiple: var(--n-padding-multiple-top) var(--n-padding-multiple-right) var(--n-padding-multiple-bottom) var(--n-padding-multiple-left);
 position: relative;
 z-index: auto;
 box-shadow: none;
 width: 100%;
 max-width: 100%;
 display: inline-block;
 vertical-align: bottom;
 border-radius: var(--n-border-radius);
 min-height: var(--n-height);
 line-height: 1.5;
 font-size: var(--n-font-size);
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-loading', `
 color: var(--n-loading-color);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-selection-tags', 'min-height: var(--n-height);'), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('border, state-border', `
 position: absolute;
 left: 0;
 right: 0;
 top: 0;
 bottom: 0;
 pointer-events: none;
 border: var(--n-border);
 border-radius: inherit;
 transition:
 box-shadow .3s var(--n-bezier),
 border-color .3s var(--n-bezier);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('state-border', `
 z-index: 1;
 border-color: #0000;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-suffix', `
 cursor: pointer;
 position: absolute;
 top: 50%;
 transform: translateY(-50%);
 right: 10px;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('arrow', `
 font-size: var(--n-arrow-size);
 color: var(--n-arrow-color);
 transition: color .3s var(--n-bezier);
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-selection-overlay', `
 display: flex;
 align-items: center;
 white-space: nowrap;
 pointer-events: none;
 position: absolute;
 top: 0;
 right: 0;
 bottom: 0;
 left: 0;
 padding: var(--n-padding-single);
 transition: color .3s var(--n-bezier);
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('wrapper', `
 flex-basis: 0;
 flex-grow: 1;
 overflow: hidden;
 text-overflow: ellipsis;
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-selection-placeholder', `
 color: var(--n-placeholder-color);
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('inner', `
 max-width: 100%;
 overflow: hidden;
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-selection-tags', `
 cursor: pointer;
 outline: none;
 box-sizing: border-box;
 position: relative;
 z-index: auto;
 display: flex;
 padding: var(--n-padding-multiple);
 flex-wrap: wrap;
 align-items: center;
 width: 100%;
 vertical-align: bottom;
 background-color: var(--n-color);
 border-radius: inherit;
 transition:
 color .3s var(--n-bezier),
 box-shadow .3s var(--n-bezier),
 background-color .3s var(--n-bezier);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-selection-label', `
 height: var(--n-height);
 display: inline-flex;
 width: 100%;
 vertical-align: bottom;
 cursor: pointer;
 outline: none;
 z-index: auto;
 box-sizing: border-box;
 position: relative;
 transition:
 color .3s var(--n-bezier),
 box-shadow .3s var(--n-bezier),
 background-color .3s var(--n-bezier);
 border-radius: inherit;
 background-color: var(--n-color);
 align-items: center;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-selection-input', `
 font-size: inherit;
 line-height: inherit;
 outline: none;
 cursor: pointer;
 box-sizing: border-box;
 border:none;
 width: 100%;
 padding: var(--n-padding-single);
 background-color: #0000;
 color: var(--n-text-color);
 transition: color .3s var(--n-bezier);
 caret-color: var(--n-caret-color);
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('content', `
 text-overflow: ellipsis;
 overflow: hidden;
 white-space: nowrap; 
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('render-label', `
 color: var(--n-text-color);
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cNotM)('disabled', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:hover', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('state-border', `
 box-shadow: var(--n-box-shadow-hover);
 border: var(--n-border-hover);
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('focus', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('state-border', `
 box-shadow: var(--n-box-shadow-focus);
 border: var(--n-border-focus);
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('active', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('state-border', `
 box-shadow: var(--n-box-shadow-active);
 border: var(--n-border-active);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-selection-label', 'background-color: var(--n-color-active);'), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-selection-tags', 'background-color: var(--n-color-active);')])]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('disabled', 'cursor: not-allowed;', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('arrow', `
 color: var(--n-arrow-color-disabled);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-selection-label', `
 cursor: not-allowed;
 background-color: var(--n-color-disabled);
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-selection-input', `
 cursor: not-allowed;
 color: var(--n-text-color-disabled);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('render-label', `
 color: var(--n-text-color-disabled);
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-selection-tags', `
 cursor: not-allowed;
 background-color: var(--n-color-disabled);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-selection-placeholder', `
 cursor: not-allowed;
 color: var(--n-placeholder-color-disabled);
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-selection-input-tag', `
 height: calc(var(--n-height) - 6px);
 line-height: calc(var(--n-height) - 6px);
 outline: none;
 display: none;
 position: relative;
 margin-bottom: 3px;
 max-width: 100%;
 vertical-align: bottom;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('input', `
 font-size: inherit;
 font-family: inherit;
 min-width: 1px;
 padding: 0;
 background-color: #0000;
 outline: none;
 border: none;
 max-width: 100%;
 overflow: hidden;
 width: 1em;
 line-height: inherit;
 cursor: pointer;
 color: var(--n-text-color);
 caret-color: var(--n-caret-color);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('mirror', `
 position: absolute;
 left: 0;
 top: 0;
 white-space: pre;
 visibility: hidden;
 user-select: none;
 -webkit-user-select: none;
 opacity: 0;
 `)]), ['warning', 'error'].map(status => (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)(`${status}-status`, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('state-border', `border: var(--n-border-${status});`), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cNotM)('disabled', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:hover', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('state-border', `
 box-shadow: var(--n-box-shadow-hover-${status});
 border: var(--n-border-hover-${status});
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('active', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('state-border', `
 box-shadow: var(--n-box-shadow-active-${status});
 border: var(--n-border-active-${status});
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-selection-label', `background-color: var(--n-color-active-${status});`), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-selection-tags', `background-color: var(--n-color-active-${status});`)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('focus', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('state-border', `
 box-shadow: var(--n-box-shadow-focus-${status});
 border: var(--n-border-focus-${status});
 `)])])]))]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-selection-popover', `
 margin-bottom: -3px;
 display: flex;
 flex-wrap: wrap;
 margin-right: -8px;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-selection-tag-wrapper', `
 max-width: 100%;
 display: inline-flex;
 padding: 0 7px 3px 0;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:last-child', 'padding-right: 0;'), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('tag', `
 font-size: 14px;
 max-width: 100%;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('content', `
 line-height: 1.25;
 text-overflow: ellipsis;
 overflow: hidden;
 `)])])]));

/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/suffix/src/Suffix.mjs":
/*!******************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/suffix/src/Suffix.mjs ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _clear_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../clear/index.mjs */ "./node_modules/naive-ui/es/_internal/clear/src/Clear.mjs");
/* harmony import */ var _loading_index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../loading/index.mjs */ "./node_modules/naive-ui/es/_internal/loading/src/Loading.mjs");
/* harmony import */ var _icon_index_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../icon/index.mjs */ "./node_modules/naive-ui/es/_internal/icon/src/Icon.mjs");
/* harmony import */ var _icons_index_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../icons/index.mjs */ "./node_modules/naive-ui/es/_internal/icons/ChevronDown.mjs");
/* harmony import */ var _utils_vue_index_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../_utils/vue/index.mjs */ "./node_modules/naive-ui/es/_utils/vue/resolve-slot.mjs");






/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'InternalSelectionSuffix',
  props: {
    clsPrefix: {
      type: String,
      required: true
    },
    showArrow: {
      type: Boolean,
      default: undefined
    },
    showClear: {
      type: Boolean,
      default: undefined
    },
    loading: {
      type: Boolean,
      default: false
    },
    onClear: Function
  },
  setup(props, {
    slots
  }) {
    return () => {
      const {
        clsPrefix
      } = props;
      return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_loading_index_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], {
        clsPrefix: clsPrefix,
        class: `${clsPrefix}-base-suffix`,
        strokeWidth: 24,
        scale: 0.85,
        show: props.loading
      }, {
        default: () => props.showArrow ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_clear_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"], {
          clsPrefix: clsPrefix,
          show: props.showClear,
          onClear: props.onClear
        }, {
          placeholder: () => (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_icon_index_mjs__WEBPACK_IMPORTED_MODULE_3__["default"], {
            clsPrefix: clsPrefix,
            class: `${clsPrefix}-base-suffix__arrow`
          }, {
            default: () => (0,_utils_vue_index_mjs__WEBPACK_IMPORTED_MODULE_4__.resolveSlot)(slots.default, () => [(0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_icons_index_mjs__WEBPACK_IMPORTED_MODULE_5__["default"], null)])
          })
        }) : null
      });
    };
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/_utils/composable/use-resize.mjs":
/*!*******************************************************************!*\
  !*** ./node_modules/naive-ui/es/_utils/composable/use-resize.mjs ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useOnResize: () => (/* binding */ useOnResize)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var vueuc__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vueuc */ "./node_modules/vueuc/es/resize-observer/src/delegate.js");


function useOnResize(elRef, onResize) {
  // it needn't be reactive since it's for internal usage
  if (onResize) {
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(() => {
      const {
        value: el
      } = elRef;
      if (el) {
        vueuc__WEBPACK_IMPORTED_MODULE_1__["default"].registerHandler(el, onResize);
      }
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onBeforeUnmount)(() => {
      const {
        value: el
      } = elRef;
      if (el) {
        vueuc__WEBPACK_IMPORTED_MODULE_1__["default"].unregisterHandler(el);
      }
    });
  }
}

/***/ }),

/***/ "./node_modules/naive-ui/es/_utils/event/index.mjs":
/*!*********************************************************!*\
  !*** ./node_modules/naive-ui/es/_utils/event/index.mjs ***!
  \*********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   eventEffectNotPerformed: () => (/* binding */ eventEffectNotPerformed),
/* harmony export */   markEventEffectPerformed: () => (/* binding */ markEventEffectPerformed)
/* harmony export */ });
const eventSet = new WeakSet();
function markEventEffectPerformed(event) {
  eventSet.add(event);
}
function eventEffectNotPerformed(event) {
  return !eventSet.has(event);
}

/***/ }),

/***/ "./node_modules/naive-ui/es/_utils/naive/attribute.mjs":
/*!*************************************************************!*\
  !*** ./node_modules/naive-ui/es/_utils/naive/attribute.mjs ***!
  \*************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getTitleAttribute: () => (/* binding */ getTitleAttribute)
/* harmony export */ });
function getTitleAttribute(value) {
  switch (typeof value) {
    case 'string':
      // The empty string should also be reset to undefined.
      return value || undefined;
    case 'number':
      return String(value);
    default:
      return undefined;
  }
}

/***/ }),

/***/ "./node_modules/naive-ui/es/_utils/vue/merge-handlers.mjs":
/*!****************************************************************!*\
  !*** ./node_modules/naive-ui/es/_utils/vue/merge-handlers.mjs ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   mergeEventHandlers: () => (/* binding */ mergeEventHandlers)
/* harmony export */ });
function mergeEventHandlers(handlers) {
  const filteredHandlers = handlers.filter(handler => handler !== undefined);
  if (filteredHandlers.length === 0) return undefined;
  if (filteredHandlers.length === 1) return filteredHandlers[0];
  return e => {
    handlers.forEach(handler => {
      if (handler) {
        handler(e);
      }
    });
  };
}

/***/ }),

/***/ "./node_modules/naive-ui/es/_utils/vue/render.mjs":
/*!********************************************************!*\
  !*** ./node_modules/naive-ui/es/_utils/vue/render.mjs ***!
  \********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");

function render(r, ...args) {
  if (typeof r === 'function') {
    return r(...args);
  } else if (typeof r === 'string') {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(r);
  } else if (typeof r === 'number') {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(String(r));
  } else {
    return null;
  }
}

/***/ }),

/***/ "./node_modules/naive-ui/es/empty/src/Empty.mjs":
/*!******************************************************!*\
  !*** ./node_modules/naive-ui/es/empty/src/Empty.mjs ***!
  \******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   emptyProps: () => (/* binding */ emptyProps)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _config_provider_src_context_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../config-provider/src/context.mjs */ "./node_modules/naive-ui/es/config-provider/src/context.mjs");
/* harmony import */ var _internal_icon_index_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../_internal/icon/index.mjs */ "./node_modules/naive-ui/es/_internal/icon/src/Icon.mjs");
/* harmony import */ var _internal_icons_index_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../_internal/icons/index.mjs */ "./node_modules/naive-ui/es/_internal/icons/Empty.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-theme.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-config.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-locale.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-css-vars-class.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/cssr/index.mjs");
/* harmony import */ var _styles_index_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../styles/index.mjs */ "./node_modules/naive-ui/es/empty/styles/light.mjs");
/* harmony import */ var _styles_index_cssr_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./styles/index.cssr.mjs */ "./node_modules/naive-ui/es/empty/src/styles/index.cssr.mjs");








const emptyProps = Object.assign(Object.assign({}, _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].props), {
  description: String,
  showDescription: {
    type: Boolean,
    default: true
  },
  showIcon: {
    type: Boolean,
    default: true
  },
  size: {
    type: String,
    default: 'medium'
  },
  renderIcon: Function
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'Empty',
  props: emptyProps,
  setup(props) {
    const {
      mergedClsPrefixRef,
      inlineThemeDisabled
    } = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"])(props);
    const themeRef = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])('Empty', '-empty', _styles_index_cssr_mjs__WEBPACK_IMPORTED_MODULE_3__["default"], _styles_index_mjs__WEBPACK_IMPORTED_MODULE_4__["default"], props, mergedClsPrefixRef);
    const {
      localeRef
    } = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_5__["default"])('Empty');
    const NConfigProvider = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(_config_provider_src_context_mjs__WEBPACK_IMPORTED_MODULE_6__.configProviderInjectionKey, null);
    const mergedDescriptionRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      var _a, _b, _c;
      return (_a = props.description) !== null && _a !== void 0 ? _a : (_c = (_b = NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedComponentPropsRef.value) === null || _b === void 0 ? void 0 : _b.Empty) === null || _c === void 0 ? void 0 : _c.description;
    });
    const mergedRenderIconRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      var _a, _b;
      return ((_b = (_a = NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedComponentPropsRef.value) === null || _a === void 0 ? void 0 : _a.Empty) === null || _b === void 0 ? void 0 : _b.renderIcon) || (() => (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_internal_icons_index_mjs__WEBPACK_IMPORTED_MODULE_7__["default"], null));
    });
    const cssVarsRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const {
        size
      } = props;
      const {
        common: {
          cubicBezierEaseInOut
        },
        self: {
          [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_8__.createKey)('iconSize', size)]: iconSize,
          [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_8__.createKey)('fontSize', size)]: fontSize,
          textColor,
          iconColor,
          extraTextColor
        }
      } = themeRef.value;
      return {
        '--n-icon-size': iconSize,
        '--n-font-size': fontSize,
        '--n-bezier': cubicBezierEaseInOut,
        '--n-text-color': textColor,
        '--n-icon-color': iconColor,
        '--n-extra-text-color': extraTextColor
      };
    });
    const themeClassHandle = inlineThemeDisabled ? (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_9__.useThemeClass)('empty', (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      let hash = '';
      const {
        size
      } = props;
      hash += size[0];
      return hash;
    }), cssVarsRef, props) : undefined;
    return {
      mergedClsPrefix: mergedClsPrefixRef,
      mergedRenderIcon: mergedRenderIconRef,
      localizedDescription: (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
        return mergedDescriptionRef.value || localeRef.value.description;
      }),
      cssVars: inlineThemeDisabled ? undefined : cssVarsRef,
      themeClass: themeClassHandle === null || themeClassHandle === void 0 ? void 0 : themeClassHandle.themeClass,
      onRender: themeClassHandle === null || themeClassHandle === void 0 ? void 0 : themeClassHandle.onRender
    };
  },
  render() {
    const {
      $slots,
      mergedClsPrefix,
      onRender
    } = this;
    onRender === null || onRender === void 0 ? void 0 : onRender();
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: [`${mergedClsPrefix}-empty`, this.themeClass],
      style: this.cssVars
    }, this.showIcon ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${mergedClsPrefix}-empty__icon`
    }, $slots.icon ? $slots.icon() : (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_internal_icon_index_mjs__WEBPACK_IMPORTED_MODULE_10__["default"], {
      clsPrefix: mergedClsPrefix
    }, {
      default: this.mergedRenderIcon
    })) : null, this.showDescription ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${mergedClsPrefix}-empty__description`
    }, $slots.default ? $slots.default() : this.localizedDescription) : null, $slots.extra ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${mergedClsPrefix}-empty__extra`
    }, $slots.extra()) : null);
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/empty/src/styles/index.cssr.mjs":
/*!******************************************************************!*\
  !*** ./node_modules/naive-ui/es/empty/src/styles/index.cssr.mjs ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../_utils/cssr/index.mjs */ "./node_modules/naive-ui/es/_utils/cssr/index.mjs");

// vars:
// --n-font-size
// --n-icon-size
// --n-icon-color
// --n-bezier
// --n-text-color
// --n-extra-text-color
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('empty', `
 display: flex;
 flex-direction: column;
 align-items: center;
 font-size: var(--n-font-size);
`, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('icon', `
 width: var(--n-icon-size);
 height: var(--n-icon-size);
 font-size: var(--n-icon-size);
 line-height: var(--n-icon-size);
 color: var(--n-icon-color);
 transition:
 color .3s var(--n-bezier);
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('+', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('description', `
 margin-top: 8px;
 `)])]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('description', `
 transition: color .3s var(--n-bezier);
 color: var(--n-text-color);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('extra', `
 text-align: center;
 transition: color .3s var(--n-bezier);
 margin-top: 12px;
 color: var(--n-extra-text-color);
 `)]));

/***/ }),

/***/ "./node_modules/naive-ui/es/select/src/Select.mjs":
/*!********************************************************!*\
  !*** ./node_modules/naive-ui/es/select/src/Select.mjs ***!
  \********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   selectProps: () => (/* binding */ selectProps)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/dom/get-precise-event-target.js");
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/dom/happens-in.js");
/* harmony import */ var treemate__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! treemate */ "./node_modules/treemate/es/create.js");
/* harmony import */ var vueuc__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! vueuc */ "./node_modules/vueuc/es/binder/src/Binder.js");
/* harmony import */ var vueuc__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! vueuc */ "./node_modules/vueuc/es/binder/src/Target.js");
/* harmony import */ var vueuc__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! vueuc */ "./node_modules/vueuc/es/binder/src/Follower.js");
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/use-merged-state.js");
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/use-compitable.js");
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/life-cycle/use-is-mounted.js");
/* harmony import */ var vdirs__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! vdirs */ "./node_modules/vdirs/es/clickoutside.js");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-theme.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-config.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-locale.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-form-item.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-css-vars-class.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/composable/use-adjusted-to.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/naive/warn.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/vue/call.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/event/index.mjs");
/* harmony import */ var _internal_index_mjs__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../_internal/index.mjs */ "./node_modules/naive-ui/es/_internal/selection/src/Selection.mjs");
/* harmony import */ var _internal_index_mjs__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../_internal/index.mjs */ "./node_modules/naive-ui/es/_internal/select-menu/src/SelectMenu.mjs");
/* harmony import */ var _styles_index_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../styles/index.mjs */ "./node_modules/naive-ui/es/select/styles/light.mjs");
/* harmony import */ var _utils_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./utils.mjs */ "./node_modules/naive-ui/es/select/src/utils.mjs");
/* harmony import */ var _styles_index_cssr_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./styles/index.cssr.mjs */ "./node_modules/naive-ui/es/select/src/styles/index.cssr.mjs");












const selectProps = Object.assign(Object.assign({}, _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].props), {
  to: _utils_index_mjs__WEBPACK_IMPORTED_MODULE_2__.useAdjustedTo.propTo,
  bordered: {
    type: Boolean,
    default: undefined
  },
  clearable: Boolean,
  clearFilterAfterSelect: {
    type: Boolean,
    default: true
  },
  options: {
    type: Array,
    default: () => []
  },
  defaultValue: {
    type: [String, Number, Array],
    default: null
  },
  keyboard: {
    type: Boolean,
    default: true
  },
  value: [String, Number, Array],
  placeholder: String,
  menuProps: Object,
  multiple: Boolean,
  size: String,
  filterable: Boolean,
  disabled: {
    type: Boolean,
    default: undefined
  },
  remote: Boolean,
  loading: Boolean,
  filter: Function,
  placement: {
    type: String,
    default: 'bottom-start'
  },
  widthMode: {
    type: String,
    default: 'trigger'
  },
  tag: Boolean,
  onCreate: Function,
  fallbackOption: {
    type: [Function, Boolean],
    default: undefined
  },
  show: {
    type: Boolean,
    default: undefined
  },
  showArrow: {
    type: Boolean,
    default: true
  },
  maxTagCount: [Number, String],
  ellipsisTagPopoverProps: Object,
  consistentMenuWidth: {
    type: Boolean,
    default: true
  },
  virtualScroll: {
    type: Boolean,
    default: true
  },
  labelField: {
    type: String,
    default: 'label'
  },
  valueField: {
    type: String,
    default: 'value'
  },
  childrenField: {
    type: String,
    default: 'children'
  },
  renderLabel: Function,
  renderOption: Function,
  renderTag: Function,
  'onUpdate:value': [Function, Array],
  inputProps: Object,
  nodeProps: Function,
  ignoreComposition: {
    type: Boolean,
    default: true
  },
  showOnFocus: Boolean,
  // for jsx
  onUpdateValue: [Function, Array],
  onBlur: [Function, Array],
  onClear: [Function, Array],
  onFocus: [Function, Array],
  onScroll: [Function, Array],
  onSearch: [Function, Array],
  onUpdateShow: [Function, Array],
  'onUpdate:show': [Function, Array],
  displayDirective: {
    type: String,
    default: 'show'
  },
  resetMenuOnOptionsChange: {
    type: Boolean,
    default: true
  },
  status: String,
  showCheckmark: {
    type: Boolean,
    default: true
  },
  /** deprecated */
  onChange: [Function, Array],
  items: Array
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'Select',
  props: selectProps,
  setup(props) {
    if (true) {
      (0,vue__WEBPACK_IMPORTED_MODULE_0__.watchEffect)(() => {
        if (props.items !== undefined) {
          (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_3__.warnOnce)('select', '`items` is deprecated, please use `options` instead.');
        }
        if (props.onChange !== undefined) {
          (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_3__.warnOnce)('select', '`on-change` is deprecated, please use `on-update:value` instead.');
        }
      });
    }
    const {
      mergedClsPrefixRef,
      mergedBorderedRef,
      namespaceRef,
      inlineThemeDisabled
    } = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_4__["default"])(props);
    const themeRef = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])('Select', '-select', _styles_index_cssr_mjs__WEBPACK_IMPORTED_MODULE_5__["default"], _styles_index_mjs__WEBPACK_IMPORTED_MODULE_6__["default"], props, mergedClsPrefixRef);
    const uncontrolledValueRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(props.defaultValue);
    const controlledValueRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'value');
    const mergedValueRef = (0,vooks__WEBPACK_IMPORTED_MODULE_7__["default"])(controlledValueRef, uncontrolledValueRef);
    const focusedRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    const patternRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)('');
    const compitableOptionsRef = (0,vooks__WEBPACK_IMPORTED_MODULE_8__["default"])(props, ['items', 'options']);
    const createdOptionsRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)([]);
    const beingCreatedOptionsRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)([]);
    const localOptionsRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      return beingCreatedOptionsRef.value.concat(createdOptionsRef.value).concat(compitableOptionsRef.value);
    });
    const resolvedFilterRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const {
        filter
      } = props;
      if (filter) return filter;
      const {
        labelField,
        valueField
      } = props;
      return (pattern, option) => {
        if (!option) return false;
        const label = option[labelField];
        if (typeof label === 'string') {
          return (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_9__.patternMatched)(pattern, label);
        }
        const value = option[valueField];
        if (typeof value === 'string') {
          return (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_9__.patternMatched)(pattern, value);
        }
        if (typeof value === 'number') {
          return (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_9__.patternMatched)(pattern, String(value));
        }
        return false;
      };
    });
    const filteredOptionsRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      if (props.remote) {
        return compitableOptionsRef.value;
      } else {
        const {
          value: localOptions
        } = localOptionsRef;
        const {
          value: pattern
        } = patternRef;
        if (!pattern.length || !props.filterable) {
          return localOptions;
        } else {
          return (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_9__.filterOptions)(localOptions, resolvedFilterRef.value, pattern, props.childrenField);
        }
      }
    });
    const treeMateRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const {
        valueField,
        childrenField
      } = props;
      const options = (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_9__.createTmOptions)(valueField, childrenField);
      return (0,treemate__WEBPACK_IMPORTED_MODULE_10__.createTreeMate)(filteredOptionsRef.value, options);
    });
    const valOptMapRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_9__.createValOptMap)(localOptionsRef.value, props.valueField, props.childrenField));
    const uncontrolledShowRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    const mergedShowRef = (0,vooks__WEBPACK_IMPORTED_MODULE_7__["default"])((0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'show'), uncontrolledShowRef);
    const triggerRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    const followerRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    const menuRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    const {
      localeRef
    } = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_11__["default"])('Select');
    const localizedPlaceholderRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      var _a;
      return (_a = props.placeholder) !== null && _a !== void 0 ? _a : localeRef.value.placeholder;
    });
    const emptyArray = [];
    const memoValOptMapRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(new Map());
    const wrappedFallbackOptionRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const {
        fallbackOption
      } = props;
      if (fallbackOption === undefined) {
        const {
          labelField,
          valueField
        } = props;
        return value => ({
          [labelField]: String(value),
          [valueField]: value
        });
      }
      if (fallbackOption === false) return false;
      return value => {
        return Object.assign(fallbackOption(value), {
          value
        });
      };
    });
    function getMergedOptions(values) {
      const remote = props.remote;
      const {
        value: memoValOptMap
      } = memoValOptMapRef;
      const {
        value: valOptMap
      } = valOptMapRef;
      const {
        value: wrappedFallbackOption
      } = wrappedFallbackOptionRef;
      const options = [];
      values.forEach(value => {
        if (valOptMap.has(value)) {
          options.push(valOptMap.get(value));
        } else if (remote && memoValOptMap.has(value)) {
          options.push(memoValOptMap.get(value));
        } else if (wrappedFallbackOption) {
          const option = wrappedFallbackOption(value);
          if (option) {
            options.push(option);
          }
        }
      });
      return options;
    }
    const selectedOptionsRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      if (props.multiple) {
        const {
          value: values
        } = mergedValueRef;
        if (!Array.isArray(values)) return [];
        return getMergedOptions(values);
      }
      return null;
    });
    const selectedOptionRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const {
        value: mergedValue
      } = mergedValueRef;
      if (!props.multiple && !Array.isArray(mergedValue)) {
        if (mergedValue === null) return null;
        return getMergedOptions([mergedValue])[0] || null;
      }
      return null;
    });
    const formItem = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_12__["default"])(props);
    const {
      mergedSizeRef,
      mergedDisabledRef,
      mergedStatusRef
    } = formItem;
    function doUpdateValue(value, option) {
      const {
        onChange,
        'onUpdate:value': _onUpdateValue,
        onUpdateValue
      } = props;
      const {
        nTriggerFormChange,
        nTriggerFormInput
      } = formItem;
      if (onChange) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__.call)(onChange, value, option);
      if (onUpdateValue) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__.call)(onUpdateValue, value, option);
      if (_onUpdateValue) {
        (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__.call)(_onUpdateValue, value, option);
      }
      uncontrolledValueRef.value = value;
      nTriggerFormChange();
      nTriggerFormInput();
    }
    function doBlur(e) {
      const {
        onBlur
      } = props;
      const {
        nTriggerFormBlur
      } = formItem;
      if (onBlur) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__.call)(onBlur, e);
      nTriggerFormBlur();
    }
    function doClear() {
      const {
        onClear
      } = props;
      if (onClear) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__.call)(onClear);
    }
    function doFocus(e) {
      const {
        onFocus,
        showOnFocus
      } = props;
      const {
        nTriggerFormFocus
      } = formItem;
      if (onFocus) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__.call)(onFocus, e);
      nTriggerFormFocus();
      if (showOnFocus) {
        openMenu();
      }
    }
    function doSearch(value) {
      const {
        onSearch
      } = props;
      if (onSearch) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__.call)(onSearch, value);
    }
    function doScroll(e) {
      const {
        onScroll
      } = props;
      if (onScroll) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__.call)(onScroll, e);
    }
    // remote related methods
    function updateMemorizedOptions() {
      var _a;
      const {
        remote,
        multiple
      } = props;
      if (remote) {
        const {
          value: memoValOptMap
        } = memoValOptMapRef;
        if (multiple) {
          const {
            valueField
          } = props;
          (_a = selectedOptionsRef.value) === null || _a === void 0 ? void 0 : _a.forEach(option => {
            memoValOptMap.set(option[valueField], option);
          });
        } else {
          const option = selectedOptionRef.value;
          if (option) {
            memoValOptMap.set(option[props.valueField], option);
          }
        }
      }
    }
    // menu related methods
    function doUpdateShow(value) {
      const {
        onUpdateShow,
        'onUpdate:show': _onUpdateShow
      } = props;
      if (onUpdateShow) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__.call)(onUpdateShow, value);
      if (_onUpdateShow) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__.call)(_onUpdateShow, value);
      uncontrolledShowRef.value = value;
    }
    function openMenu() {
      if (!mergedDisabledRef.value) {
        doUpdateShow(true);
        uncontrolledShowRef.value = true;
        if (props.filterable) {
          focusSelectionInput();
        }
      }
    }
    function closeMenu() {
      doUpdateShow(false);
    }
    function handleMenuAfterLeave() {
      patternRef.value = '';
      beingCreatedOptionsRef.value = emptyArray;
    }
    const activeWithoutMenuOpenRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    function onTriggerInputFocus() {
      if (props.filterable) {
        activeWithoutMenuOpenRef.value = true;
      }
    }
    function onTriggerInputBlur() {
      if (props.filterable) {
        activeWithoutMenuOpenRef.value = false;
        if (!mergedShowRef.value) {
          handleMenuAfterLeave();
        }
      }
    }
    function handleTriggerClick() {
      if (mergedDisabledRef.value) return;
      if (!mergedShowRef.value) {
        openMenu();
      } else {
        if (!props.filterable) {
          // already focused, don't need to return focus
          closeMenu();
        } else {
          focusSelectionInput();
        }
      }
    }
    function handleTriggerBlur(e) {
      var _a, _b;
      if ((_b = (_a = menuRef.value) === null || _a === void 0 ? void 0 : _a.selfRef) === null || _b === void 0 ? void 0 : _b.contains(e.relatedTarget)) {
        return;
      }
      focusedRef.value = false;
      doBlur(e);
      // outside select, don't need to return focus
      closeMenu();
    }
    function handleTriggerFocus(e) {
      doFocus(e);
      focusedRef.value = true;
    }
    function handleMenuFocus() {
      focusedRef.value = true;
    }
    function handleMenuBlur(e) {
      var _a;
      if ((_a = triggerRef.value) === null || _a === void 0 ? void 0 : _a.$el.contains(e.relatedTarget)) return;
      focusedRef.value = false;
      doBlur(e);
      // outside select, don't need to return focus
      closeMenu();
    }
    function handleMenuTabOut() {
      var _a;
      (_a = triggerRef.value) === null || _a === void 0 ? void 0 : _a.focus();
      closeMenu();
    }
    function handleMenuClickOutside(e) {
      var _a;
      if (mergedShowRef.value) {
        if (!((_a = triggerRef.value) === null || _a === void 0 ? void 0 : _a.$el.contains((0,seemly__WEBPACK_IMPORTED_MODULE_14__.getPreciseEventTarget)(e)))) {
          // outside select, don't need to return focus
          closeMenu();
        }
      }
    }
    function createClearedMultipleSelectValue(value) {
      if (!Array.isArray(value)) return [];
      if (wrappedFallbackOptionRef.value) {
        // if option has a fallback, I can't help user to clear some unknown value
        return Array.from(value);
      } else {
        // if there's no option fallback, unappeared options are treated as invalid
        const {
          remote
        } = props;
        const {
          value: valOptMap
        } = valOptMapRef;
        if (remote) {
          const {
            value: memoValOptMap
          } = memoValOptMapRef;
          return value.filter(v => valOptMap.has(v) || memoValOptMap.has(v));
        } else {
          return value.filter(v => valOptMap.has(v));
        }
      }
    }
    function handleToggleByTmNode(tmNode) {
      handleToggleByOption(tmNode.rawNode);
    }
    function handleToggleByOption(option) {
      if (mergedDisabledRef.value) return;
      const {
        tag,
        remote,
        clearFilterAfterSelect,
        valueField
      } = props;
      if (tag && !remote) {
        const {
          value: beingCreatedOptions
        } = beingCreatedOptionsRef;
        const beingCreatedOption = beingCreatedOptions[0] || null;
        if (beingCreatedOption) {
          const createdOptions = createdOptionsRef.value;
          if (!createdOptions.length) {
            createdOptionsRef.value = [beingCreatedOption];
          } else {
            createdOptions.push(beingCreatedOption);
          }
          beingCreatedOptionsRef.value = emptyArray;
        }
      }
      if (remote) {
        memoValOptMapRef.value.set(option[valueField], option);
      }
      if (props.multiple) {
        const changedValue = createClearedMultipleSelectValue(mergedValueRef.value);
        const index = changedValue.findIndex(value => value === option[valueField]);
        if (~index) {
          changedValue.splice(index, 1);
          if (tag && !remote) {
            const createdOptionIndex = getCreatedOptionIndex(option[valueField]);
            if (~createdOptionIndex) {
              createdOptionsRef.value.splice(createdOptionIndex, 1);
              if (clearFilterAfterSelect) patternRef.value = '';
            }
          }
        } else {
          changedValue.push(option[valueField]);
          if (clearFilterAfterSelect) patternRef.value = '';
        }
        doUpdateValue(changedValue, getMergedOptions(changedValue));
      } else {
        if (tag && !remote) {
          const createdOptionIndex = getCreatedOptionIndex(option[valueField]);
          if (~createdOptionIndex) {
            createdOptionsRef.value = [createdOptionsRef.value[createdOptionIndex]];
          } else {
            createdOptionsRef.value = emptyArray;
          }
        }
        focusSelection();
        closeMenu();
        doUpdateValue(option[valueField], option);
      }
    }
    function getCreatedOptionIndex(optionValue) {
      const createdOptions = createdOptionsRef.value;
      return createdOptions.findIndex(createdOption => createdOption[props.valueField] === optionValue);
    }
    function handlePatternInput(e) {
      if (!mergedShowRef.value) {
        openMenu();
      }
      const {
        value
      } = e.target;
      patternRef.value = value;
      const {
        tag,
        remote
      } = props;
      doSearch(value);
      if (tag && !remote) {
        if (!value) {
          beingCreatedOptionsRef.value = emptyArray;
          return;
        }
        const {
          onCreate
        } = props;
        const optionBeingCreated = onCreate ? onCreate(value) : {
          [props.labelField]: value,
          [props.valueField]: value
        };
        const {
          valueField,
          labelField
        } = props;
        if (compitableOptionsRef.value.some(option => {
          return option[valueField] === optionBeingCreated[valueField] || option[labelField] === optionBeingCreated[labelField];
        }) || createdOptionsRef.value.some(option => {
          return option[valueField] === optionBeingCreated[valueField] || option[labelField] === optionBeingCreated[labelField];
        })) {
          beingCreatedOptionsRef.value = emptyArray;
        } else {
          beingCreatedOptionsRef.value = [optionBeingCreated];
        }
      }
    }
    function handleClear(e) {
      e.stopPropagation();
      const {
        multiple
      } = props;
      if (!multiple && props.filterable) {
        closeMenu();
      }
      doClear();
      if (multiple) {
        doUpdateValue([], []);
      } else {
        doUpdateValue(null, null);
      }
    }
    function handleMenuMousedown(e) {
      if (!(0,seemly__WEBPACK_IMPORTED_MODULE_15__.happensIn)(e, 'action') && !(0,seemly__WEBPACK_IMPORTED_MODULE_15__.happensIn)(e, 'empty') && !(0,seemly__WEBPACK_IMPORTED_MODULE_15__.happensIn)(e, 'header')) {
        e.preventDefault();
      }
    }
    // scroll events on menu
    function handleMenuScroll(e) {
      doScroll(e);
    }
    // keyboard events
    // also for menu keydown
    function handleKeydown(e) {
      var _a, _b, _c, _d, _e;
      if (!props.keyboard) {
        e.preventDefault();
        return;
      }
      switch (e.key) {
        case ' ':
          if (props.filterable) {
            break;
          } else {
            e.preventDefault();
          }
        // eslint-disable-next-line no-fallthrough
        case 'Enter':
          if (!((_a = triggerRef.value) === null || _a === void 0 ? void 0 : _a.isComposing)) {
            if (mergedShowRef.value) {
              const pendingTmNode = (_b = menuRef.value) === null || _b === void 0 ? void 0 : _b.getPendingTmNode();
              if (pendingTmNode) {
                handleToggleByTmNode(pendingTmNode);
              } else if (!props.filterable) {
                closeMenu();
                focusSelection();
              }
            } else {
              openMenu();
              if (props.tag && activeWithoutMenuOpenRef.value) {
                const beingCreatedOption = beingCreatedOptionsRef.value[0];
                if (beingCreatedOption) {
                  const optionValue = beingCreatedOption[props.valueField];
                  const {
                    value: mergedValue
                  } = mergedValueRef;
                  if (props.multiple) {
                    if (Array.isArray(mergedValue) && mergedValue.includes(optionValue)) {
                      // do nothing
                    } else {
                      handleToggleByOption(beingCreatedOption);
                    }
                  } else {
                    handleToggleByOption(beingCreatedOption);
                  }
                }
              }
            }
          }
          e.preventDefault();
          break;
        case 'ArrowUp':
          e.preventDefault();
          if (props.loading) return;
          if (mergedShowRef.value) {
            (_c = menuRef.value) === null || _c === void 0 ? void 0 : _c.prev();
          }
          break;
        case 'ArrowDown':
          e.preventDefault();
          if (props.loading) return;
          if (mergedShowRef.value) {
            (_d = menuRef.value) === null || _d === void 0 ? void 0 : _d.next();
          } else {
            openMenu();
          }
          break;
        case 'Escape':
          if (mergedShowRef.value) {
            (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_16__.markEventEffectPerformed)(e);
            closeMenu();
          }
          (_e = triggerRef.value) === null || _e === void 0 ? void 0 : _e.focus();
          break;
      }
    }
    function focusSelection() {
      var _a;
      (_a = triggerRef.value) === null || _a === void 0 ? void 0 : _a.focus();
    }
    function focusSelectionInput() {
      var _a;
      (_a = triggerRef.value) === null || _a === void 0 ? void 0 : _a.focusInput();
    }
    function handleTriggerOrMenuResize() {
      var _a;
      if (!mergedShowRef.value) return;
      (_a = followerRef.value) === null || _a === void 0 ? void 0 : _a.syncPosition();
    }
    updateMemorizedOptions();
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)((0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'options'), updateMemorizedOptions);
    const exposedMethods = {
      focus: () => {
        var _a;
        (_a = triggerRef.value) === null || _a === void 0 ? void 0 : _a.focus();
      },
      focusInput: () => {
        var _a;
        (_a = triggerRef.value) === null || _a === void 0 ? void 0 : _a.focusInput();
      },
      blur: () => {
        var _a;
        (_a = triggerRef.value) === null || _a === void 0 ? void 0 : _a.blur();
      },
      blurInput: () => {
        var _a;
        (_a = triggerRef.value) === null || _a === void 0 ? void 0 : _a.blurInput();
      }
    };
    const cssVarsRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const {
        self: {
          menuBoxShadow
        }
      } = themeRef.value;
      return {
        '--n-menu-box-shadow': menuBoxShadow
      };
    });
    const themeClassHandle = inlineThemeDisabled ? (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_17__.useThemeClass)('select', undefined, cssVarsRef, props) : undefined;
    return Object.assign(Object.assign({}, exposedMethods), {
      mergedStatus: mergedStatusRef,
      mergedClsPrefix: mergedClsPrefixRef,
      mergedBordered: mergedBorderedRef,
      namespace: namespaceRef,
      treeMate: treeMateRef,
      isMounted: (0,vooks__WEBPACK_IMPORTED_MODULE_18__["default"])(),
      triggerRef,
      menuRef,
      pattern: patternRef,
      uncontrolledShow: uncontrolledShowRef,
      mergedShow: mergedShowRef,
      adjustedTo: (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_2__.useAdjustedTo)(props),
      uncontrolledValue: uncontrolledValueRef,
      mergedValue: mergedValueRef,
      followerRef,
      localizedPlaceholder: localizedPlaceholderRef,
      selectedOption: selectedOptionRef,
      selectedOptions: selectedOptionsRef,
      mergedSize: mergedSizeRef,
      mergedDisabled: mergedDisabledRef,
      focused: focusedRef,
      activeWithoutMenuOpen: activeWithoutMenuOpenRef,
      inlineThemeDisabled,
      onTriggerInputFocus,
      onTriggerInputBlur,
      handleTriggerOrMenuResize,
      handleMenuFocus,
      handleMenuBlur,
      handleMenuTabOut,
      handleTriggerClick,
      handleToggle: handleToggleByTmNode,
      handleDeleteOption: handleToggleByOption,
      handlePatternInput,
      handleClear,
      handleTriggerBlur,
      handleTriggerFocus,
      handleKeydown,
      handleMenuAfterLeave,
      handleMenuClickOutside,
      handleMenuScroll,
      handleMenuKeydown: handleKeydown,
      handleMenuMousedown,
      mergedTheme: themeRef,
      cssVars: inlineThemeDisabled ? undefined : cssVarsRef,
      themeClass: themeClassHandle === null || themeClassHandle === void 0 ? void 0 : themeClassHandle.themeClass,
      onRender: themeClassHandle === null || themeClassHandle === void 0 ? void 0 : themeClassHandle.onRender
    });
  },
  render() {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${this.mergedClsPrefix}-select`
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vueuc__WEBPACK_IMPORTED_MODULE_19__["default"], null, {
      default: () => [(0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vueuc__WEBPACK_IMPORTED_MODULE_20__["default"], null, {
        default: () => (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_internal_index_mjs__WEBPACK_IMPORTED_MODULE_21__["default"], {
          ref: "triggerRef",
          inlineThemeDisabled: this.inlineThemeDisabled,
          status: this.mergedStatus,
          inputProps: this.inputProps,
          clsPrefix: this.mergedClsPrefix,
          showArrow: this.showArrow,
          maxTagCount: this.maxTagCount,
          ellipsisTagPopoverProps: this.ellipsisTagPopoverProps,
          bordered: this.mergedBordered,
          active: this.activeWithoutMenuOpen || this.mergedShow,
          pattern: this.pattern,
          placeholder: this.localizedPlaceholder,
          selectedOption: this.selectedOption,
          selectedOptions: this.selectedOptions,
          multiple: this.multiple,
          renderTag: this.renderTag,
          renderLabel: this.renderLabel,
          filterable: this.filterable,
          clearable: this.clearable,
          disabled: this.mergedDisabled,
          size: this.mergedSize,
          theme: this.mergedTheme.peers.InternalSelection,
          labelField: this.labelField,
          valueField: this.valueField,
          themeOverrides: this.mergedTheme.peerOverrides.InternalSelection,
          loading: this.loading,
          focused: this.focused,
          onClick: this.handleTriggerClick,
          onDeleteOption: this.handleDeleteOption,
          onPatternInput: this.handlePatternInput,
          onClear: this.handleClear,
          onBlur: this.handleTriggerBlur,
          onFocus: this.handleTriggerFocus,
          onKeydown: this.handleKeydown,
          onPatternBlur: this.onTriggerInputBlur,
          onPatternFocus: this.onTriggerInputFocus,
          onResize: this.handleTriggerOrMenuResize,
          ignoreComposition: this.ignoreComposition
        }, {
          arrow: () => {
            var _a, _b;
            return [(_b = (_a = this.$slots).arrow) === null || _b === void 0 ? void 0 : _b.call(_a)];
          }
        })
      }), (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vueuc__WEBPACK_IMPORTED_MODULE_22__["default"], {
        ref: "followerRef",
        show: this.mergedShow,
        to: this.adjustedTo,
        teleportDisabled: this.adjustedTo === _utils_index_mjs__WEBPACK_IMPORTED_MODULE_2__.useAdjustedTo.tdkey,
        containerClass: this.namespace,
        width: this.consistentMenuWidth ? 'target' : undefined,
        minWidth: "target",
        placement: this.placement
      }, {
        default: () => (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vue__WEBPACK_IMPORTED_MODULE_0__.Transition, {
          name: "fade-in-scale-up-transition",
          appear: this.isMounted,
          onAfterLeave: this.handleMenuAfterLeave
        }, {
          default: () => {
            var _a, _b, _c;
            if (!(this.mergedShow || this.displayDirective === 'show')) {
              return null;
            }
            (_a = this.onRender) === null || _a === void 0 ? void 0 : _a.call(this);
            return (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_internal_index_mjs__WEBPACK_IMPORTED_MODULE_23__["default"], Object.assign({}, this.menuProps, {
              ref: "menuRef",
              onResize: this.handleTriggerOrMenuResize,
              inlineThemeDisabled: this.inlineThemeDisabled,
              virtualScroll: this.consistentMenuWidth && this.virtualScroll,
              class: [`${this.mergedClsPrefix}-select-menu`, this.themeClass, (_b = this.menuProps) === null || _b === void 0 ? void 0 : _b.class],
              clsPrefix: this.mergedClsPrefix,
              focusable: true,
              labelField: this.labelField,
              valueField: this.valueField,
              autoPending: true,
              nodeProps: this.nodeProps,
              theme: this.mergedTheme.peers.InternalSelectMenu,
              themeOverrides: this.mergedTheme.peerOverrides.InternalSelectMenu,
              treeMate: this.treeMate,
              multiple: this.multiple,
              size: "medium",
              renderOption: this.renderOption,
              renderLabel: this.renderLabel,
              value: this.mergedValue,
              style: [(_c = this.menuProps) === null || _c === void 0 ? void 0 : _c.style, this.cssVars],
              onToggle: this.handleToggle,
              onScroll: this.handleMenuScroll,
              onFocus: this.handleMenuFocus,
              onBlur: this.handleMenuBlur,
              onKeydown: this.handleMenuKeydown,
              onTabOut: this.handleMenuTabOut,
              onMousedown: this.handleMenuMousedown,
              show: this.mergedShow,
              showCheckmark: this.showCheckmark,
              resetMenuOnOptionsChange: this.resetMenuOnOptionsChange
            }), {
              empty: () => {
                var _a, _b;
                return [(_b = (_a = this.$slots).empty) === null || _b === void 0 ? void 0 : _b.call(_a)];
              },
              header: () => {
                var _a, _b;
                return [(_b = (_a = this.$slots).header) === null || _b === void 0 ? void 0 : _b.call(_a)];
              },
              action: () => {
                var _a, _b;
                return [(_b = (_a = this.$slots).action) === null || _b === void 0 ? void 0 : _b.call(_a)];
              }
            }), this.displayDirective === 'show' ? [[vue__WEBPACK_IMPORTED_MODULE_0__.vShow, this.mergedShow], [vdirs__WEBPACK_IMPORTED_MODULE_24__["default"], this.handleMenuClickOutside, undefined, {
              capture: true
            }]] : [[vdirs__WEBPACK_IMPORTED_MODULE_24__["default"], this.handleMenuClickOutside, undefined, {
              capture: true
            }]]);
          }
        })
      })]
    }));
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/select/src/styles/index.cssr.mjs":
/*!*******************************************************************!*\
  !*** ./node_modules/naive-ui/es/select/src/styles/index.cssr.mjs ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../_utils/cssr/index.mjs */ "./node_modules/naive-ui/es/_utils/cssr/index.mjs");
/* harmony import */ var _styles_transitions_fade_in_scale_up_cssr_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../_styles/transitions/fade-in-scale-up.cssr.mjs */ "./node_modules/naive-ui/es/_styles/transitions/fade-in-scale-up.cssr.mjs");


// --n-menu-box-shadow
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)([(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('select', `
 z-index: auto;
 outline: none;
 width: 100%;
 position: relative;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('select-menu', `
 margin: 4px 0;
 box-shadow: var(--n-menu-box-shadow);
 `, [(0,_styles_transitions_fade_in_scale_up_cssr_mjs__WEBPACK_IMPORTED_MODULE_1__.fadeInScaleUpTransition)({
  originalTransition: 'background-color .3s var(--n-bezier), box-shadow .3s var(--n-bezier)'
})])]));

/***/ }),

/***/ "./node_modules/naive-ui/es/select/src/utils.mjs":
/*!*******************************************************!*\
  !*** ./node_modules/naive-ui/es/select/src/utils.mjs ***!
  \*******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createTmOptions: () => (/* binding */ createTmOptions),
/* harmony export */   createValOptMap: () => (/* binding */ createValOptMap),
/* harmony export */   filterOptions: () => (/* binding */ filterOptions),
/* harmony export */   getIgnored: () => (/* binding */ getIgnored),
/* harmony export */   getIsGroup: () => (/* binding */ getIsGroup),
/* harmony export */   patternMatched: () => (/* binding */ patternMatched)
/* harmony export */ });
function getIsGroup(option) {
  return option.type === 'group';
}
function getIgnored(option) {
  return option.type === 'ignored';
}
function patternMatched(pattern, value) {
  try {
    return !!(1 + value.toString().toLowerCase().indexOf(pattern.trim().toLowerCase()));
  } catch (_a) {
    return false;
  }
}
function createTmOptions(valueField, childrenField) {
  const options = {
    getIsGroup,
    getIgnored,
    getKey(option) {
      if (getIsGroup(option)) {
        return option.name || option.key || 'key-required';
      }
      // Required for non-custom label & value field
      return option[valueField];
    },
    getChildren(option) {
      return option[childrenField];
    }
  };
  return options;
}
function filterOptions(originalOpts, filter, pattern, childrenField) {
  if (!filter) return originalOpts;
  function traverse(options) {
    if (!Array.isArray(options)) return [];
    const filteredOptions = [];
    for (const option of options) {
      if (getIsGroup(option)) {
        const children = traverse(option[childrenField]);
        if (children.length) {
          filteredOptions.push(Object.assign({}, option, {
            [childrenField]: children
          }));
        }
      } else if (getIgnored(option)) {
        continue;
      } else if (filter(pattern, option)) {
        filteredOptions.push(option);
      }
    }
    return filteredOptions;
  }
  return traverse(originalOpts);
}
function createValOptMap(options, valueField, childrenField) {
  const valOptMap = new Map();
  options.forEach(option => {
    if (getIsGroup(option)) {
      ;
      option[childrenField].forEach(selectGroupOption => {
        valOptMap.set(selectGroupOption[valueField], selectGroupOption);
      });
    } else {
      valOptMap.set(option[valueField], option);
    }
  });
  return valOptMap;
}

/***/ }),

/***/ "./node_modules/naive-ui/es/tag/src/Tag.mjs":
/*!**************************************************!*\
  !*** ./node_modules/naive-ui/es/tag/src/Tag.mjs ***!
  \**************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   tagInjectionKey: () => (/* binding */ tagInjectionKey),
/* harmony export */   tagProps: () => (/* binding */ tagProps)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/css/index.js");
/* harmony import */ var _mixins_use_rtl_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../_mixins/use-rtl.mjs */ "./node_modules/naive-ui/es/_mixins/use-rtl.mjs");
/* harmony import */ var _internal_close_index_mjs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../_internal/close/index.mjs */ "./node_modules/naive-ui/es/_internal/close/src/Close.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-theme.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-config.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-css-vars-class.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/vue/create-injection-key.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/naive/warn.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/vue/call.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/cssr/index.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/css/color-to-class.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/vue/resolve-slot.mjs");
/* harmony import */ var _styles_index_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../styles/index.mjs */ "./node_modules/naive-ui/es/tag/styles/light.mjs");
/* harmony import */ var _common_props_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./common-props.mjs */ "./node_modules/naive-ui/es/tag/src/common-props.mjs");
/* harmony import */ var _styles_index_cssr_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./styles/index.cssr.mjs */ "./node_modules/naive-ui/es/tag/src/styles/index.cssr.mjs");









const tagProps = Object.assign(Object.assign(Object.assign({}, _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].props), _common_props_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]), {
  bordered: {
    type: Boolean,
    default: undefined
  },
  checked: Boolean,
  checkable: Boolean,
  strong: Boolean,
  triggerClickOnClose: Boolean,
  onClose: [Array, Function],
  onMouseenter: Function,
  onMouseleave: Function,
  'onUpdate:checked': Function,
  onUpdateChecked: Function,
  // private
  internalCloseFocusable: {
    type: Boolean,
    default: true
  },
  internalCloseIsButtonTag: {
    type: Boolean,
    default: true
  },
  // deprecated
  onCheckedChange: Function
});
const tagInjectionKey = (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_3__.createInjectionKey)('n-tag');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'Tag',
  props: tagProps,
  setup(props) {
    if (true) {
      (0,vue__WEBPACK_IMPORTED_MODULE_0__.watchEffect)(() => {
        if (props.onCheckedChange !== undefined) {
          (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_4__.warnOnce)('tag', '`on-checked-change` is deprecated, please use `on-update:checked` instead');
        }
      });
    }
    const contentRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    const {
      mergedBorderedRef,
      mergedClsPrefixRef,
      inlineThemeDisabled,
      mergedRtlRef
    } = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_5__["default"])(props);
    const themeRef = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])('Tag', '-tag', _styles_index_cssr_mjs__WEBPACK_IMPORTED_MODULE_6__["default"], _styles_index_mjs__WEBPACK_IMPORTED_MODULE_7__["default"], props, mergedClsPrefixRef);
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.provide)(tagInjectionKey, {
      roundRef: (0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'round')
    });
    function handleClick() {
      if (!props.disabled) {
        if (props.checkable) {
          const {
            checked,
            onCheckedChange,
            onUpdateChecked,
            'onUpdate:checked': _onUpdateChecked
          } = props;
          if (onUpdateChecked) onUpdateChecked(!checked);
          if (_onUpdateChecked) _onUpdateChecked(!checked);
          // deprecated
          if (onCheckedChange) onCheckedChange(!checked);
        }
      }
    }
    function handleCloseClick(e) {
      if (!props.triggerClickOnClose) {
        e.stopPropagation();
      }
      if (!props.disabled) {
        const {
          onClose
        } = props;
        if (onClose) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_8__.call)(onClose, e);
      }
    }
    const tagPublicMethods = {
      setTextContent(textContent) {
        const {
          value
        } = contentRef;
        if (value) value.textContent = textContent;
      }
    };
    const rtlEnabledRef = (0,_mixins_use_rtl_mjs__WEBPACK_IMPORTED_MODULE_9__.useRtl)('Tag', mergedRtlRef, mergedClsPrefixRef);
    const cssVarsRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const {
        type,
        size,
        color: {
          color,
          textColor
        } = {}
      } = props;
      const {
        common: {
          cubicBezierEaseInOut
        },
        self: {
          padding,
          closeMargin,
          borderRadius,
          opacityDisabled,
          textColorCheckable,
          textColorHoverCheckable,
          textColorPressedCheckable,
          textColorChecked,
          colorCheckable,
          colorHoverCheckable,
          colorPressedCheckable,
          colorChecked,
          colorCheckedHover,
          colorCheckedPressed,
          closeBorderRadius,
          fontWeightStrong,
          [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_10__.createKey)('colorBordered', type)]: colorBordered,
          [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_10__.createKey)('closeSize', size)]: closeSize,
          [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_10__.createKey)('closeIconSize', size)]: closeIconSize,
          [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_10__.createKey)('fontSize', size)]: fontSize,
          [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_10__.createKey)('height', size)]: height,
          [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_10__.createKey)('color', type)]: typedColor,
          [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_10__.createKey)('textColor', type)]: typeTextColor,
          [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_10__.createKey)('border', type)]: border,
          [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_10__.createKey)('closeIconColor', type)]: closeIconColor,
          [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_10__.createKey)('closeIconColorHover', type)]: closeIconColorHover,
          [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_10__.createKey)('closeIconColorPressed', type)]: closeIconColorPressed,
          [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_10__.createKey)('closeColorHover', type)]: closeColorHover,
          [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_10__.createKey)('closeColorPressed', type)]: closeColorPressed
        }
      } = themeRef.value;
      const closeMarginDiscrete = (0,seemly__WEBPACK_IMPORTED_MODULE_11__.getMargin)(closeMargin);
      return {
        '--n-font-weight-strong': fontWeightStrong,
        '--n-avatar-size-override': `calc(${height} - 8px)`,
        '--n-bezier': cubicBezierEaseInOut,
        '--n-border-radius': borderRadius,
        '--n-border': border,
        '--n-close-icon-size': closeIconSize,
        '--n-close-color-pressed': closeColorPressed,
        '--n-close-color-hover': closeColorHover,
        '--n-close-border-radius': closeBorderRadius,
        '--n-close-icon-color': closeIconColor,
        '--n-close-icon-color-hover': closeIconColorHover,
        '--n-close-icon-color-pressed': closeIconColorPressed,
        '--n-close-icon-color-disabled': closeIconColor,
        '--n-close-margin-top': closeMarginDiscrete.top,
        '--n-close-margin-right': closeMarginDiscrete.right,
        '--n-close-margin-bottom': closeMarginDiscrete.bottom,
        '--n-close-margin-left': closeMarginDiscrete.left,
        '--n-close-size': closeSize,
        '--n-color': color || (mergedBorderedRef.value ? colorBordered : typedColor),
        '--n-color-checkable': colorCheckable,
        '--n-color-checked': colorChecked,
        '--n-color-checked-hover': colorCheckedHover,
        '--n-color-checked-pressed': colorCheckedPressed,
        '--n-color-hover-checkable': colorHoverCheckable,
        '--n-color-pressed-checkable': colorPressedCheckable,
        '--n-font-size': fontSize,
        '--n-height': height,
        '--n-opacity-disabled': opacityDisabled,
        '--n-padding': padding,
        '--n-text-color': textColor || typeTextColor,
        '--n-text-color-checkable': textColorCheckable,
        '--n-text-color-checked': textColorChecked,
        '--n-text-color-hover-checkable': textColorHoverCheckable,
        '--n-text-color-pressed-checkable': textColorPressedCheckable
      };
    });
    const themeClassHandle = inlineThemeDisabled ? (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_12__.useThemeClass)('tag', (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      let hash = '';
      const {
        type,
        size,
        color: {
          color,
          textColor
        } = {}
      } = props;
      hash += type[0];
      hash += size[0];
      if (color) {
        hash += `a${(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__.color2Class)(color)}`;
      }
      if (textColor) {
        hash += `b${(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_13__.color2Class)(textColor)}`;
      }
      if (mergedBorderedRef.value) {
        hash += 'c';
      }
      return hash;
    }), cssVarsRef, props) : undefined;
    return Object.assign(Object.assign({}, tagPublicMethods), {
      rtlEnabled: rtlEnabledRef,
      mergedClsPrefix: mergedClsPrefixRef,
      contentRef,
      mergedBordered: mergedBorderedRef,
      handleClick,
      handleCloseClick,
      cssVars: inlineThemeDisabled ? undefined : cssVarsRef,
      themeClass: themeClassHandle === null || themeClassHandle === void 0 ? void 0 : themeClassHandle.themeClass,
      onRender: themeClassHandle === null || themeClassHandle === void 0 ? void 0 : themeClassHandle.onRender
    });
  },
  render() {
    var _a, _b;
    const {
      mergedClsPrefix,
      rtlEnabled,
      closable,
      color: {
        borderColor
      } = {},
      round,
      onRender,
      $slots
    } = this;
    onRender === null || onRender === void 0 ? void 0 : onRender();
    const avatarNode = (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_14__.resolveWrappedSlot)($slots.avatar, children => children && (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${mergedClsPrefix}-tag__avatar`
    }, children));
    const iconNode = (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_14__.resolveWrappedSlot)($slots.icon, children => children && (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${mergedClsPrefix}-tag__icon`
    }, children));
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: [`${mergedClsPrefix}-tag`, this.themeClass, {
        [`${mergedClsPrefix}-tag--rtl`]: rtlEnabled,
        [`${mergedClsPrefix}-tag--strong`]: this.strong,
        [`${mergedClsPrefix}-tag--disabled`]: this.disabled,
        [`${mergedClsPrefix}-tag--checkable`]: this.checkable,
        [`${mergedClsPrefix}-tag--checked`]: this.checkable && this.checked,
        [`${mergedClsPrefix}-tag--round`]: round,
        [`${mergedClsPrefix}-tag--avatar`]: avatarNode,
        [`${mergedClsPrefix}-tag--icon`]: iconNode,
        [`${mergedClsPrefix}-tag--closable`]: closable
      }],
      style: this.cssVars,
      onClick: this.handleClick,
      onMouseenter: this.onMouseenter,
      onMouseleave: this.onMouseleave
    }, iconNode || avatarNode, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("span", {
      class: `${mergedClsPrefix}-tag__content`,
      ref: "contentRef"
    }, (_b = (_a = this.$slots).default) === null || _b === void 0 ? void 0 : _b.call(_a)), !this.checkable && closable ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_internal_close_index_mjs__WEBPACK_IMPORTED_MODULE_15__["default"], {
      clsPrefix: mergedClsPrefix,
      class: `${mergedClsPrefix}-tag__close`,
      disabled: this.disabled,
      onClick: this.handleCloseClick,
      focusable: this.internalCloseFocusable,
      round: round,
      isButtonTag: this.internalCloseIsButtonTag,
      absolute: true
    }) : null, !this.checkable && this.mergedBordered ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${mergedClsPrefix}-tag__border`,
      style: {
        borderColor
      }
    }) : null);
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/tag/src/common-props.mjs":
/*!***********************************************************!*\
  !*** ./node_modules/naive-ui/es/tag/src/common-props.mjs ***!
  \***********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  color: Object,
  type: {
    type: String,
    default: 'default'
  },
  round: Boolean,
  size: {
    type: String,
    default: 'medium'
  },
  closable: Boolean,
  disabled: {
    type: Boolean,
    default: undefined
  }
});

/***/ }),

/***/ "./node_modules/naive-ui/es/tag/src/styles/index.cssr.mjs":
/*!****************************************************************!*\
  !*** ./node_modules/naive-ui/es/tag/src/styles/index.cssr.mjs ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../_utils/cssr/index.mjs */ "./node_modules/naive-ui/es/_utils/cssr/index.mjs");

// vars:
// --n-bezier
// --n-border-radius
// --n-border
// --n-close-icon-color
// --n-close-icon-color-hover
// --n-close-icon-color-pressed
// --n-close-margin
// --n-close-size
// --n-color
// --n-color-checkable
// --n-color-checked
// --n-color-checked-hover
// --n-color-checked-pressed
// --n-color-hover-checkable
// --n-color-pressed-checkable
// --n-font-size
// --n-height
// --n-opacity-disabled
// --n-padding
// --n-text-color
// --n-text-color-checkable
// --n-text-color-checked
// --n-text-color-hover-checkable
// --n-text-color-pressed-checkable
// --n-font-weight-strong
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('tag', `
 --n-close-margin: var(--n-close-margin-top) var(--n-close-margin-right) var(--n-close-margin-bottom) var(--n-close-margin-left);
 white-space: nowrap;
 position: relative;
 box-sizing: border-box;
 cursor: default;
 display: inline-flex;
 align-items: center;
 flex-wrap: nowrap;
 padding: var(--n-padding);
 border-radius: var(--n-border-radius);
 color: var(--n-text-color);
 background-color: var(--n-color);
 transition: 
 border-color .3s var(--n-bezier),
 background-color .3s var(--n-bezier),
 color .3s var(--n-bezier),
 box-shadow .3s var(--n-bezier),
 opacity .3s var(--n-bezier);
 line-height: 1;
 height: var(--n-height);
 font-size: var(--n-font-size);
`, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('strong', `
 font-weight: var(--n-font-weight-strong);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('border', `
 pointer-events: none;
 position: absolute;
 left: 0;
 right: 0;
 top: 0;
 bottom: 0;
 border-radius: inherit;
 border: var(--n-border);
 transition: border-color .3s var(--n-bezier);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('icon', `
 display: flex;
 margin: 0 4px 0 0;
 color: var(--n-text-color);
 transition: color .3s var(--n-bezier);
 font-size: var(--n-avatar-size-override);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('avatar', `
 display: flex;
 margin: 0 6px 0 0;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('close', `
 margin: var(--n-close-margin);
 transition:
 background-color .3s var(--n-bezier),
 color .3s var(--n-bezier);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('round', `
 padding: 0 calc(var(--n-height) / 3);
 border-radius: calc(var(--n-height) / 2);
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('icon', `
 margin: 0 4px 0 calc((var(--n-height) - 8px) / -2);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('avatar', `
 margin: 0 6px 0 calc((var(--n-height) - 8px) / -2);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('closable', `
 padding: 0 calc(var(--n-height) / 4) 0 calc(var(--n-height) / 3);
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('icon, avatar', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('round', `
 padding: 0 calc(var(--n-height) / 3) 0 calc(var(--n-height) / 2);
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('disabled', `
 cursor: not-allowed !important;
 opacity: var(--n-opacity-disabled);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('checkable', `
 cursor: pointer;
 box-shadow: none;
 color: var(--n-text-color-checkable);
 background-color: var(--n-color-checkable);
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cNotM)('disabled', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:hover', 'background-color: var(--n-color-hover-checkable);', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cNotM)('checked', 'color: var(--n-text-color-hover-checkable);')]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:active', 'background-color: var(--n-color-pressed-checkable);', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cNotM)('checked', 'color: var(--n-text-color-pressed-checkable);')])]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('checked', `
 color: var(--n-text-color-checked);
 background-color: var(--n-color-checked);
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cNotM)('disabled', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:hover', 'background-color: var(--n-color-checked-hover);'), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:active', 'background-color: var(--n-color-checked-pressed);')])])])]));

/***/ }),

/***/ "./node_modules/naive-ui/es/tag/styles/light.mjs":
/*!*******************************************************!*\
  !*** ./node_modules/naive-ui/es/tag/styles/light.mjs ***!
  \*******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/color/index.js");
/* harmony import */ var _styles_common_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../_styles/common/index.mjs */ "./node_modules/naive-ui/es/_styles/common/light.mjs");
/* harmony import */ var _common_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_common.mjs */ "./node_modules/naive-ui/es/tag/styles/_common.mjs");



function self(vars) {
  const {
    textColor2,
    primaryColorHover,
    primaryColorPressed,
    primaryColor,
    infoColor,
    successColor,
    warningColor,
    errorColor,
    baseColor,
    borderColor,
    opacityDisabled,
    tagColor,
    closeIconColor,
    closeIconColorHover,
    closeIconColorPressed,
    borderRadiusSmall: borderRadius,
    fontSizeMini,
    fontSizeTiny,
    fontSizeSmall,
    fontSizeMedium,
    heightMini,
    heightTiny,
    heightSmall,
    heightMedium,
    closeColorHover,
    closeColorPressed,
    buttonColor2Hover,
    buttonColor2Pressed,
    fontWeightStrong
  } = vars;
  return Object.assign(Object.assign({}, _common_mjs__WEBPACK_IMPORTED_MODULE_0__["default"]), {
    closeBorderRadius: borderRadius,
    heightTiny: heightMini,
    heightSmall: heightTiny,
    heightMedium: heightSmall,
    heightLarge: heightMedium,
    borderRadius,
    opacityDisabled,
    fontSizeTiny: fontSizeMini,
    fontSizeSmall: fontSizeTiny,
    fontSizeMedium: fontSizeSmall,
    fontSizeLarge: fontSizeMedium,
    fontWeightStrong,
    // checked
    textColorCheckable: textColor2,
    textColorHoverCheckable: textColor2,
    textColorPressedCheckable: textColor2,
    textColorChecked: baseColor,
    colorCheckable: '#0000',
    colorHoverCheckable: buttonColor2Hover,
    colorPressedCheckable: buttonColor2Pressed,
    colorChecked: primaryColor,
    colorCheckedHover: primaryColorHover,
    colorCheckedPressed: primaryColorPressed,
    // default
    border: `1px solid ${borderColor}`,
    textColor: textColor2,
    color: tagColor,
    colorBordered: 'rgb(250, 250, 252)',
    closeIconColor,
    closeIconColorHover,
    closeIconColorPressed,
    closeColorHover,
    closeColorPressed,
    borderPrimary: `1px solid ${(0,seemly__WEBPACK_IMPORTED_MODULE_1__.changeColor)(primaryColor, {
      alpha: 0.3
    })}`,
    textColorPrimary: primaryColor,
    colorPrimary: (0,seemly__WEBPACK_IMPORTED_MODULE_1__.changeColor)(primaryColor, {
      alpha: 0.12
    }),
    colorBorderedPrimary: (0,seemly__WEBPACK_IMPORTED_MODULE_1__.changeColor)(primaryColor, {
      alpha: 0.1
    }),
    closeIconColorPrimary: primaryColor,
    closeIconColorHoverPrimary: primaryColor,
    closeIconColorPressedPrimary: primaryColor,
    closeColorHoverPrimary: (0,seemly__WEBPACK_IMPORTED_MODULE_1__.changeColor)(primaryColor, {
      alpha: 0.12
    }),
    closeColorPressedPrimary: (0,seemly__WEBPACK_IMPORTED_MODULE_1__.changeColor)(primaryColor, {
      alpha: 0.18
    }),
    borderInfo: `1px solid ${(0,seemly__WEBPACK_IMPORTED_MODULE_1__.changeColor)(infoColor, {
      alpha: 0.3
    })}`,
    textColorInfo: infoColor,
    colorInfo: (0,seemly__WEBPACK_IMPORTED_MODULE_1__.changeColor)(infoColor, {
      alpha: 0.12
    }),
    colorBorderedInfo: (0,seemly__WEBPACK_IMPORTED_MODULE_1__.changeColor)(infoColor, {
      alpha: 0.1
    }),
    closeIconColorInfo: infoColor,
    closeIconColorHoverInfo: infoColor,
    closeIconColorPressedInfo: infoColor,
    closeColorHoverInfo: (0,seemly__WEBPACK_IMPORTED_MODULE_1__.changeColor)(infoColor, {
      alpha: 0.12
    }),
    closeColorPressedInfo: (0,seemly__WEBPACK_IMPORTED_MODULE_1__.changeColor)(infoColor, {
      alpha: 0.18
    }),
    borderSuccess: `1px solid ${(0,seemly__WEBPACK_IMPORTED_MODULE_1__.changeColor)(successColor, {
      alpha: 0.3
    })}`,
    textColorSuccess: successColor,
    colorSuccess: (0,seemly__WEBPACK_IMPORTED_MODULE_1__.changeColor)(successColor, {
      alpha: 0.12
    }),
    colorBorderedSuccess: (0,seemly__WEBPACK_IMPORTED_MODULE_1__.changeColor)(successColor, {
      alpha: 0.1
    }),
    closeIconColorSuccess: successColor,
    closeIconColorHoverSuccess: successColor,
    closeIconColorPressedSuccess: successColor,
    closeColorHoverSuccess: (0,seemly__WEBPACK_IMPORTED_MODULE_1__.changeColor)(successColor, {
      alpha: 0.12
    }),
    closeColorPressedSuccess: (0,seemly__WEBPACK_IMPORTED_MODULE_1__.changeColor)(successColor, {
      alpha: 0.18
    }),
    borderWarning: `1px solid ${(0,seemly__WEBPACK_IMPORTED_MODULE_1__.changeColor)(warningColor, {
      alpha: 0.35
    })}`,
    textColorWarning: warningColor,
    colorWarning: (0,seemly__WEBPACK_IMPORTED_MODULE_1__.changeColor)(warningColor, {
      alpha: 0.15
    }),
    colorBorderedWarning: (0,seemly__WEBPACK_IMPORTED_MODULE_1__.changeColor)(warningColor, {
      alpha: 0.12
    }),
    closeIconColorWarning: warningColor,
    closeIconColorHoverWarning: warningColor,
    closeIconColorPressedWarning: warningColor,
    closeColorHoverWarning: (0,seemly__WEBPACK_IMPORTED_MODULE_1__.changeColor)(warningColor, {
      alpha: 0.12
    }),
    closeColorPressedWarning: (0,seemly__WEBPACK_IMPORTED_MODULE_1__.changeColor)(warningColor, {
      alpha: 0.18
    }),
    borderError: `1px solid ${(0,seemly__WEBPACK_IMPORTED_MODULE_1__.changeColor)(errorColor, {
      alpha: 0.23
    })}`,
    textColorError: errorColor,
    colorError: (0,seemly__WEBPACK_IMPORTED_MODULE_1__.changeColor)(errorColor, {
      alpha: 0.1
    }),
    colorBorderedError: (0,seemly__WEBPACK_IMPORTED_MODULE_1__.changeColor)(errorColor, {
      alpha: 0.08
    }),
    closeIconColorError: errorColor,
    closeIconColorHoverError: errorColor,
    closeIconColorPressedError: errorColor,
    closeColorHoverError: (0,seemly__WEBPACK_IMPORTED_MODULE_1__.changeColor)(errorColor, {
      alpha: 0.12
    }),
    closeColorPressedError: (0,seemly__WEBPACK_IMPORTED_MODULE_1__.changeColor)(errorColor, {
      alpha: 0.18
    })
  });
}
const tagLight = {
  name: 'Tag',
  common: _styles_common_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"],
  self
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (tagLight);

/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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