"use strict";
(self["webpackChunknearbeach"] = self["webpackChunknearbeach"] || []).push([["vendors-node_modules_naive-ui_es_switch_src_Switch_js"],{

/***/ "./node_modules/naive-ui/es/switch/src/Switch.js":
/*!*******************************************************!*\
  !*** ./node_modules/naive-ui/es/switch/src/Switch.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   switchProps: () => (/* binding */ switchProps)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/css/index.js");
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/use-merged-state.js");
/* harmony import */ var _mixins__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../_mixins */ "./node_modules/naive-ui/es/_mixins/use-theme.js");
/* harmony import */ var _mixins__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../_mixins */ "./node_modules/naive-ui/es/_mixins/use-config.js");
/* harmony import */ var _mixins__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../_mixins */ "./node_modules/naive-ui/es/_mixins/use-form-item.js");
/* harmony import */ var _mixins__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../_mixins */ "./node_modules/naive-ui/es/_mixins/use-css-vars-class.js");
/* harmony import */ var _internal__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../_internal */ "./node_modules/naive-ui/es/_internal/icon-switch-transition/src/IconSwitchTransition.js");
/* harmony import */ var _internal__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../_internal */ "./node_modules/naive-ui/es/_internal/loading/src/Loading.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../_utils */ "./node_modules/naive-ui/es/_utils/naive/warn.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../_utils */ "./node_modules/naive-ui/es/_utils/vue/call.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../_utils */ "./node_modules/naive-ui/es/_utils/cssr/create-key.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../_utils */ "./node_modules/naive-ui/es/_utils/vue/resolve-slot.js");
/* harmony import */ var _styles__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../styles */ "./node_modules/naive-ui/es/switch/styles/light.js");
/* harmony import */ var _styles_index_cssr__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./styles/index.cssr */ "./node_modules/naive-ui/es/switch/src/styles/index.cssr.js");








const switchProps = Object.assign(Object.assign({}, _mixins__WEBPACK_IMPORTED_MODULE_1__["default"].props), { size: {
        type: String,
        default: 'medium'
    }, value: {
        type: [String, Number, Boolean],
        default: undefined
    }, loading: Boolean, defaultValue: {
        type: [String, Number, Boolean],
        default: false
    }, disabled: {
        type: Boolean,
        default: undefined
    }, round: {
        type: Boolean,
        default: true
    }, 'onUpdate:value': [Function, Array], onUpdateValue: [Function, Array], checkedValue: {
        type: [String, Number, Boolean],
        default: true
    }, uncheckedValue: {
        type: [String, Number, Boolean],
        default: false
    }, railStyle: Function, rubberBand: {
        type: Boolean,
        default: true
    }, 
    /** @deprecated */
    onChange: [Function, Array] });
let supportCssMax;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
    name: 'Switch',
    props: switchProps,
    setup(props) {
        if (true) {
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.watchEffect)(() => {
                if (props.onChange) {
                    (0,_utils__WEBPACK_IMPORTED_MODULE_2__.warnOnce)('switch', '`on-change` is deprecated, please use `on-update:value` instead.');
                }
            });
        }
        if (supportCssMax === undefined) {
            if (typeof CSS !== 'undefined') {
                if (typeof CSS.supports !== 'undefined') {
                    supportCssMax = CSS.supports('width', 'max(1px)');
                }
                else {
                    supportCssMax = false;
                }
            }
            else {
                // If you are using SSR, we assume that you are targeting browsers with
                // recent versions
                supportCssMax = true;
            }
        }
        const { mergedClsPrefixRef, inlineThemeDisabled } = (0,_mixins__WEBPACK_IMPORTED_MODULE_3__["default"])(props);
        const themeRef = (0,_mixins__WEBPACK_IMPORTED_MODULE_1__["default"])('Switch', '-switch', _styles_index_cssr__WEBPACK_IMPORTED_MODULE_4__["default"], _styles__WEBPACK_IMPORTED_MODULE_5__["default"], props, mergedClsPrefixRef);
        const formItem = (0,_mixins__WEBPACK_IMPORTED_MODULE_6__["default"])(props);
        const { mergedSizeRef, mergedDisabledRef } = formItem;
        const uncontrolledValueRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(props.defaultValue);
        const controlledValueRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'value');
        const mergedValueRef = (0,vooks__WEBPACK_IMPORTED_MODULE_7__["default"])(controlledValueRef, uncontrolledValueRef);
        const checkedRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            return mergedValueRef.value === props.checkedValue;
        });
        const pressedRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
        const focusedRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
        const mergedRailStyleRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { railStyle } = props;
            if (!railStyle)
                return undefined;
            return railStyle({ focused: focusedRef.value, checked: checkedRef.value });
        });
        function doUpdateValue(value) {
            const { 'onUpdate:value': _onUpdateValue, onChange, onUpdateValue } = props;
            const { nTriggerFormInput, nTriggerFormChange } = formItem;
            if (_onUpdateValue)
                (0,_utils__WEBPACK_IMPORTED_MODULE_8__.call)(_onUpdateValue, value);
            if (onUpdateValue)
                (0,_utils__WEBPACK_IMPORTED_MODULE_8__.call)(onUpdateValue, value);
            if (onChange)
                (0,_utils__WEBPACK_IMPORTED_MODULE_8__.call)(onChange, value);
            uncontrolledValueRef.value = value;
            nTriggerFormInput();
            nTriggerFormChange();
        }
        function doFocus() {
            const { nTriggerFormFocus } = formItem;
            nTriggerFormFocus();
        }
        function doBlur() {
            const { nTriggerFormBlur } = formItem;
            nTriggerFormBlur();
        }
        function handleClick() {
            if (props.loading || mergedDisabledRef.value)
                return;
            if (mergedValueRef.value !== props.checkedValue) {
                doUpdateValue(props.checkedValue);
            }
            else {
                doUpdateValue(props.uncheckedValue);
            }
        }
        function handleFocus() {
            focusedRef.value = true;
            doFocus();
        }
        function handleBlur() {
            focusedRef.value = false;
            doBlur();
            pressedRef.value = false;
        }
        function handleKeyup(e) {
            if (props.loading || mergedDisabledRef.value)
                return;
            if (e.key === ' ') {
                if (mergedValueRef.value !== props.checkedValue) {
                    doUpdateValue(props.checkedValue);
                }
                else {
                    doUpdateValue(props.uncheckedValue);
                }
                pressedRef.value = false;
            }
        }
        function handleKeydown(e) {
            if (props.loading || mergedDisabledRef.value)
                return;
            if (e.key === ' ') {
                e.preventDefault();
                pressedRef.value = true;
            }
        }
        const cssVarsRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { value: size } = mergedSizeRef;
            const { self: { opacityDisabled, railColor, railColorActive, buttonBoxShadow, buttonColor, boxShadowFocus, loadingColor, textColor, iconColor, [(0,_utils__WEBPACK_IMPORTED_MODULE_9__.createKey)('buttonHeight', size)]: buttonHeight, [(0,_utils__WEBPACK_IMPORTED_MODULE_9__.createKey)('buttonWidth', size)]: buttonWidth, [(0,_utils__WEBPACK_IMPORTED_MODULE_9__.createKey)('buttonWidthPressed', size)]: buttonWidthPressed, [(0,_utils__WEBPACK_IMPORTED_MODULE_9__.createKey)('railHeight', size)]: railHeight, [(0,_utils__WEBPACK_IMPORTED_MODULE_9__.createKey)('railWidth', size)]: railWidth, [(0,_utils__WEBPACK_IMPORTED_MODULE_9__.createKey)('railBorderRadius', size)]: railBorderRadius, [(0,_utils__WEBPACK_IMPORTED_MODULE_9__.createKey)('buttonBorderRadius', size)]: buttonBorderRadius }, common: { cubicBezierEaseInOut } } = themeRef.value;
            let offset;
            let height;
            let width;
            if (supportCssMax) {
                offset = `calc((${railHeight} - ${buttonHeight}) / 2)`;
                height = `max(${railHeight}, ${buttonHeight})`;
                width = `max(${railWidth}, calc(${railWidth} + ${buttonHeight} - ${railHeight}))`;
            }
            else {
                offset = (0,seemly__WEBPACK_IMPORTED_MODULE_10__.pxfy)(((0,seemly__WEBPACK_IMPORTED_MODULE_10__.depx)(railHeight) - (0,seemly__WEBPACK_IMPORTED_MODULE_10__.depx)(buttonHeight)) / 2);
                height = (0,seemly__WEBPACK_IMPORTED_MODULE_10__.pxfy)(Math.max((0,seemly__WEBPACK_IMPORTED_MODULE_10__.depx)(railHeight), (0,seemly__WEBPACK_IMPORTED_MODULE_10__.depx)(buttonHeight)));
                width =
                    (0,seemly__WEBPACK_IMPORTED_MODULE_10__.depx)(railHeight) > (0,seemly__WEBPACK_IMPORTED_MODULE_10__.depx)(buttonHeight)
                        ? railWidth
                        : (0,seemly__WEBPACK_IMPORTED_MODULE_10__.pxfy)((0,seemly__WEBPACK_IMPORTED_MODULE_10__.depx)(railWidth) + (0,seemly__WEBPACK_IMPORTED_MODULE_10__.depx)(buttonHeight) - (0,seemly__WEBPACK_IMPORTED_MODULE_10__.depx)(railHeight));
            }
            return {
                '--n-bezier': cubicBezierEaseInOut,
                '--n-button-border-radius': buttonBorderRadius,
                '--n-button-box-shadow': buttonBoxShadow,
                '--n-button-color': buttonColor,
                '--n-button-width': buttonWidth,
                '--n-button-width-pressed': buttonWidthPressed,
                '--n-button-height': buttonHeight,
                '--n-height': height,
                '--n-offset': offset,
                '--n-opacity-disabled': opacityDisabled,
                '--n-rail-border-radius': railBorderRadius,
                '--n-rail-color': railColor,
                '--n-rail-color-active': railColorActive,
                '--n-rail-height': railHeight,
                '--n-rail-width': railWidth,
                '--n-width': width,
                '--n-box-shadow-focus': boxShadowFocus,
                '--n-loading-color': loadingColor,
                '--n-text-color': textColor,
                '--n-icon-color': iconColor
            };
        });
        const themeClassHandle = inlineThemeDisabled
            ? (0,_mixins__WEBPACK_IMPORTED_MODULE_11__.useThemeClass)('switch', (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
                return mergedSizeRef.value[0];
            }), cssVarsRef, props)
            : undefined;
        return {
            handleClick,
            handleBlur,
            handleFocus,
            handleKeyup,
            handleKeydown,
            mergedRailStyle: mergedRailStyleRef,
            pressed: pressedRef,
            mergedClsPrefix: mergedClsPrefixRef,
            mergedValue: mergedValueRef,
            checked: checkedRef,
            mergedDisabled: mergedDisabledRef,
            cssVars: inlineThemeDisabled ? undefined : cssVarsRef,
            themeClass: themeClassHandle === null || themeClassHandle === void 0 ? void 0 : themeClassHandle.themeClass,
            onRender: themeClassHandle === null || themeClassHandle === void 0 ? void 0 : themeClassHandle.onRender
        };
    },
    render() {
        const { mergedClsPrefix, mergedDisabled, checked, mergedRailStyle, onRender, $slots } = this;
        onRender === null || onRender === void 0 ? void 0 : onRender();
        const { checked: checkedSlot, unchecked: uncheckedSlot, icon: iconSlot, 'checked-icon': checkedIconSlot, 'unchecked-icon': uncheckedIconSlot } = $slots;
        const hasIcon = !((0,_utils__WEBPACK_IMPORTED_MODULE_12__.isSlotEmpty)(iconSlot) &&
            (0,_utils__WEBPACK_IMPORTED_MODULE_12__.isSlotEmpty)(checkedIconSlot) &&
            (0,_utils__WEBPACK_IMPORTED_MODULE_12__.isSlotEmpty)(uncheckedIconSlot));
        return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { role: "switch", "aria-checked": checked, class: [
                `${mergedClsPrefix}-switch`,
                this.themeClass,
                hasIcon && `${mergedClsPrefix}-switch--icon`,
                checked && `${mergedClsPrefix}-switch--active`,
                mergedDisabled && `${mergedClsPrefix}-switch--disabled`,
                this.round && `${mergedClsPrefix}-switch--round`,
                this.loading && `${mergedClsPrefix}-switch--loading`,
                this.pressed && `${mergedClsPrefix}-switch--pressed`,
                this.rubberBand && `${mergedClsPrefix}-switch--rubber-band`
            ], tabindex: !this.mergedDisabled ? 0 : undefined, style: this.cssVars, onClick: this.handleClick, onFocus: this.handleFocus, onBlur: this.handleBlur, onKeyup: this.handleKeyup, onKeydown: this.handleKeydown },
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${mergedClsPrefix}-switch__rail`, "aria-hidden": "true", style: mergedRailStyle },
                (0,_utils__WEBPACK_IMPORTED_MODULE_12__.resolveWrappedSlot)(checkedSlot, (checkedSlotChildren) => (0,_utils__WEBPACK_IMPORTED_MODULE_12__.resolveWrappedSlot)(uncheckedSlot, (uncheckedSlotChildren) => {
                    if (checkedSlotChildren || uncheckedSlotChildren) {
                        return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { "aria-hidden": true, class: `${mergedClsPrefix}-switch__children-placeholder` },
                            (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${mergedClsPrefix}-switch__rail-placeholder` },
                                (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${mergedClsPrefix}-switch__button-placeholder` }),
                                checkedSlotChildren),
                            (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${mergedClsPrefix}-switch__rail-placeholder` },
                                (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${mergedClsPrefix}-switch__button-placeholder` }),
                                uncheckedSlotChildren)));
                    }
                    return null;
                })),
                (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${mergedClsPrefix}-switch__button` },
                    (0,_utils__WEBPACK_IMPORTED_MODULE_12__.resolveWrappedSlot)(iconSlot, (icon) => (0,_utils__WEBPACK_IMPORTED_MODULE_12__.resolveWrappedSlot)(checkedIconSlot, (checkedIcon) => (0,_utils__WEBPACK_IMPORTED_MODULE_12__.resolveWrappedSlot)(uncheckedIconSlot, (uncheckedIcon) => {
                        return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_internal__WEBPACK_IMPORTED_MODULE_13__["default"], null, {
                            default: () => this.loading ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_internal__WEBPACK_IMPORTED_MODULE_14__["default"], { key: "loading", clsPrefix: mergedClsPrefix, strokeWidth: 20 })) : this.checked && (checkedIcon || icon) ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${mergedClsPrefix}-switch__button-icon`, key: checkedIcon ? 'checked-icon' : 'icon' }, checkedIcon || icon)) : !this.checked && (uncheckedIcon || icon) ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${mergedClsPrefix}-switch__button-icon`, key: uncheckedIcon ? 'unchecked-icon' : 'icon' }, uncheckedIcon || icon)) : null
                        }));
                    }))),
                    (0,_utils__WEBPACK_IMPORTED_MODULE_12__.resolveWrappedSlot)(checkedSlot, (children) => children && ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { key: "checked", class: `${mergedClsPrefix}-switch__checked` }, children))),
                    (0,_utils__WEBPACK_IMPORTED_MODULE_12__.resolveWrappedSlot)(uncheckedSlot, (children) => children && ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { key: "unchecked", class: `${mergedClsPrefix}-switch__unchecked` }, children)))))));
    }
}));


/***/ }),

/***/ "./node_modules/naive-ui/es/switch/src/styles/index.cssr.js":
/*!******************************************************************!*\
  !*** ./node_modules/naive-ui/es/switch/src/styles/index.cssr.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _styles_transitions_icon_switch_cssr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../_styles/transitions/icon-switch.cssr */ "./node_modules/naive-ui/es/_styles/transitions/icon-switch.cssr.js");
/* harmony import */ var _utils_cssr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../_utils/cssr */ "./node_modules/naive-ui/es/_utils/cssr/index.js");


// vars:
// --n-bezier
// --n-button-border-radius
// --n-button-box-shadow
// --n-button-color
// --n-button-width
// --n-button-width-pressed
// --n-height
// --n-offset
// --n-rail-border-radius
// --n-rail-color
// --n-rail-color-active
// --n-rail-height
// --n-rail-width
// --n-width
// --n-box-shadow-focus
// --n-loading-color
// --n-text-color
// --n-icon-color
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('switch', `
 height: var(--n-height);
 min-width: var(--n-width);
 vertical-align: middle;
 user-select: none;
 -webkit-user-select: none;
 display: inline-flex;
 outline: none;
 justify-content: center;
 align-items: center;
`, [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('children-placeholder', `
 height: var(--n-rail-height);
 display: flex;
 flex-direction: column;
 overflow: hidden;
 pointer-events: none;
 visibility: hidden;
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('rail-placeholder', `
 display: flex;
 flex-wrap: none;
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('button-placeholder', `
 width: calc(1.75 * var(--n-rail-height));
 height: var(--n-rail-height);
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('base-loading', `
 position: absolute;
 top: 50%;
 left: 50%;
 transform: translateX(-50%) translateY(-50%);
 font-size: calc(var(--n-button-width) - 4px);
 color: var(--n-loading-color);
 transition: color .3s var(--n-bezier);
 `, [(0,_styles_transitions_icon_switch_cssr__WEBPACK_IMPORTED_MODULE_1__.iconSwitchTransition)({
  left: '50%',
  top: '50%',
  originalTransform: 'translateX(-50%) translateY(-50%)'
})]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('checked, unchecked', `
 transition: color .3s var(--n-bezier);
 color: var(--n-text-color);
 box-sizing: border-box;
 position: absolute;
 white-space: nowrap;
 top: 0;
 bottom: 0;
 display: flex;
 align-items: center;
 line-height: 1;
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('checked', `
 right: 0;
 padding-right: calc(1.25 * var(--n-rail-height) - var(--n-offset));
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('unchecked', `
 left: 0;
 justify-content: flex-end;
 padding-left: calc(1.25 * var(--n-rail-height) - var(--n-offset));
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('&:focus', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('rail', `
 box-shadow: var(--n-box-shadow-focus);
 `)]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cM)('round', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('rail', 'border-radius: calc(var(--n-rail-height) / 2);', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('button', 'border-radius: calc(var(--n-button-height) / 2);')])]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cNotM)('disabled', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cNotM)('icon', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cM)('rubber-band', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cM)('pressed', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('rail', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('button', 'max-width: var(--n-button-width-pressed);')])]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('rail', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('&:active', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('button', 'max-width: var(--n-button-width-pressed);')])]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cM)('active', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cM)('pressed', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('rail', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('button', 'left: calc(100% - var(--n-offset) - var(--n-button-width-pressed));')])]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('rail', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('&:active', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('button', 'left: calc(100% - var(--n-offset) - var(--n-button-width-pressed));')])])])])])]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cM)('active', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('rail', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('button', 'left: calc(100% - var(--n-button-width) - var(--n-offset))')])]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('rail', `
 overflow: hidden;
 height: var(--n-rail-height);
 min-width: var(--n-rail-width);
 border-radius: var(--n-rail-border-radius);
 cursor: pointer;
 position: relative;
 transition:
 opacity .3s var(--n-bezier),
 background .3s var(--n-bezier),
 box-shadow .3s var(--n-bezier);
 background-color: var(--n-rail-color);
 `, [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('button-icon', `
 color: var(--n-icon-color);
 transition: color .3s var(--n-bezier);
 font-size: calc(var(--n-button-height) - 4px);
 position: absolute;
 left: 0;
 right: 0;
 top: 0;
 bottom: 0;
 display: flex;
 justify-content: center;
 align-items: center;
 line-height: 1;
 `, [(0,_styles_transitions_icon_switch_cssr__WEBPACK_IMPORTED_MODULE_1__.iconSwitchTransition)()]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('button', `
 align-items: center; 
 top: var(--n-offset);
 left: var(--n-offset);
 height: var(--n-button-height);
 width: var(--n-button-width-pressed);
 max-width: var(--n-button-width);
 border-radius: var(--n-button-border-radius);
 background-color: var(--n-button-color);
 box-shadow: var(--n-button-box-shadow);
 box-sizing: border-box;
 cursor: inherit;
 content: "";
 position: absolute;
 transition:
 background-color .3s var(--n-bezier),
 left .3s var(--n-bezier),
 opacity .3s var(--n-bezier),
 max-width .3s var(--n-bezier),
 box-shadow .3s var(--n-bezier);
 `)]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cM)('active', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('rail', 'background-color: var(--n-rail-color-active);')]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cM)('loading', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('rail', `
 cursor: wait;
 `)]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cM)('disabled', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('rail', `
 cursor: not-allowed;
 opacity: .5;
 `)])]));

/***/ }),

/***/ "./node_modules/naive-ui/es/switch/styles/light.js":
/*!*********************************************************!*\
  !*** ./node_modules/naive-ui/es/switch/styles/light.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/color/index.js");
/* harmony import */ var _common__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_common */ "./node_modules/naive-ui/es/switch/styles/_common.js");
/* harmony import */ var _styles_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../_styles/common */ "./node_modules/naive-ui/es/_styles/common/light.js");



const self = (vars) => {
    const { primaryColor, opacityDisabled, borderRadius, textColor3 } = vars;
    const railOverlayColor = 'rgba(0, 0, 0, .14)';
    return Object.assign(Object.assign({}, _common__WEBPACK_IMPORTED_MODULE_0__["default"]), { iconColor: textColor3, textColor: 'white', loadingColor: primaryColor, opacityDisabled, railColor: railOverlayColor, railColorActive: primaryColor, buttonBoxShadow: '0 1px 4px 0 rgba(0, 0, 0, 0.3), inset 0 0 1px 0 rgba(0, 0, 0, 0.05)', buttonColor: '#FFF', railBorderRadiusSmall: borderRadius, railBorderRadiusMedium: borderRadius, railBorderRadiusLarge: borderRadius, buttonBorderRadiusSmall: borderRadius, buttonBorderRadiusMedium: borderRadius, buttonBorderRadiusLarge: borderRadius, boxShadowFocus: `0 0 0 2px ${(0,seemly__WEBPACK_IMPORTED_MODULE_1__.changeColor)(primaryColor, { alpha: 0.2 })}` });
};
const switchLight = {
    name: 'Switch',
    common: _styles_common__WEBPACK_IMPORTED_MODULE_2__["default"],
    self
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (switchLight);


/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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