"use strict";
(self["webpackChunknearbeach"] = self["webpackChunknearbeach"] || []).push([["vendors-node_modules_naive-ui_es_switch_src_Switch_mjs"],{

/***/ "./node_modules/naive-ui/es/switch/src/Switch.mjs":
/*!********************************************************!*\
  !*** ./node_modules/naive-ui/es/switch/src/Switch.mjs ***!
  \********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   switchProps: () => (/* binding */ switchProps)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/css/index.js");
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/use-merged-state.js");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-theme.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-config.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-form-item.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-css-vars-class.mjs");
/* harmony import */ var _internal_index_mjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../_internal/index.mjs */ "./node_modules/naive-ui/es/_internal/icon-switch-transition/src/IconSwitchTransition.mjs");
/* harmony import */ var _internal_index_mjs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../_internal/index.mjs */ "./node_modules/naive-ui/es/_internal/loading/src/Loading.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/naive/warn.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/vue/call.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/cssr/index.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/vue/resolve-slot.mjs");
/* harmony import */ var _styles_index_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../styles/index.mjs */ "./node_modules/naive-ui/es/switch/styles/light.mjs");
/* harmony import */ var _styles_index_cssr_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./styles/index.cssr.mjs */ "./node_modules/naive-ui/es/switch/src/styles/index.cssr.mjs");








const switchProps = Object.assign(Object.assign({}, _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].props), {
  size: {
    type: String,
    default: 'medium'
  },
  value: {
    type: [String, Number, Boolean],
    default: undefined
  },
  loading: Boolean,
  defaultValue: {
    type: [String, Number, Boolean],
    default: false
  },
  disabled: {
    type: Boolean,
    default: undefined
  },
  round: {
    type: Boolean,
    default: true
  },
  'onUpdate:value': [Function, Array],
  onUpdateValue: [Function, Array],
  checkedValue: {
    type: [String, Number, Boolean],
    default: true
  },
  uncheckedValue: {
    type: [String, Number, Boolean],
    default: false
  },
  railStyle: Function,
  rubberBand: {
    type: Boolean,
    default: true
  },
  /** @deprecated */
  onChange: [Function, Array]
});
let supportCssMax;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'Switch',
  props: switchProps,
  setup(props) {
    if (true) {
      (0,vue__WEBPACK_IMPORTED_MODULE_0__.watchEffect)(() => {
        if (props.onChange) {
          (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_2__.warnOnce)('switch', '`on-change` is deprecated, please use `on-update:value` instead.');
        }
      });
    }
    if (supportCssMax === undefined) {
      if (typeof CSS !== 'undefined') {
        if (typeof CSS.supports !== 'undefined') {
          supportCssMax = CSS.supports('width', 'max(1px)');
        } else {
          supportCssMax = false;
        }
      } else {
        // If you are using SSR, we assume that you are targeting browsers with
        // recent versions
        supportCssMax = true;
      }
    }
    const {
      mergedClsPrefixRef,
      inlineThemeDisabled
    } = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_3__["default"])(props);
    const themeRef = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])('Switch', '-switch', _styles_index_cssr_mjs__WEBPACK_IMPORTED_MODULE_4__["default"], _styles_index_mjs__WEBPACK_IMPORTED_MODULE_5__["default"], props, mergedClsPrefixRef);
    const formItem = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_6__["default"])(props);
    const {
      mergedSizeRef,
      mergedDisabledRef
    } = formItem;
    const uncontrolledValueRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(props.defaultValue);
    const controlledValueRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'value');
    const mergedValueRef = (0,vooks__WEBPACK_IMPORTED_MODULE_7__["default"])(controlledValueRef, uncontrolledValueRef);
    const checkedRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      return mergedValueRef.value === props.checkedValue;
    });
    const pressedRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    const focusedRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    const mergedRailStyleRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const {
        railStyle
      } = props;
      if (!railStyle) return undefined;
      return railStyle({
        focused: focusedRef.value,
        checked: checkedRef.value
      });
    });
    function doUpdateValue(value) {
      const {
        'onUpdate:value': _onUpdateValue,
        onChange,
        onUpdateValue
      } = props;
      const {
        nTriggerFormInput,
        nTriggerFormChange
      } = formItem;
      if (_onUpdateValue) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_8__.call)(_onUpdateValue, value);
      if (onUpdateValue) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_8__.call)(onUpdateValue, value);
      if (onChange) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_8__.call)(onChange, value);
      uncontrolledValueRef.value = value;
      nTriggerFormInput();
      nTriggerFormChange();
    }
    function doFocus() {
      const {
        nTriggerFormFocus
      } = formItem;
      nTriggerFormFocus();
    }
    function doBlur() {
      const {
        nTriggerFormBlur
      } = formItem;
      nTriggerFormBlur();
    }
    function handleClick() {
      if (props.loading || mergedDisabledRef.value) return;
      if (mergedValueRef.value !== props.checkedValue) {
        doUpdateValue(props.checkedValue);
      } else {
        doUpdateValue(props.uncheckedValue);
      }
    }
    function handleFocus() {
      focusedRef.value = true;
      doFocus();
    }
    function handleBlur() {
      focusedRef.value = false;
      doBlur();
      pressedRef.value = false;
    }
    function handleKeyup(e) {
      if (props.loading || mergedDisabledRef.value) return;
      if (e.key === ' ') {
        if (mergedValueRef.value !== props.checkedValue) {
          doUpdateValue(props.checkedValue);
        } else {
          doUpdateValue(props.uncheckedValue);
        }
        pressedRef.value = false;
      }
    }
    function handleKeydown(e) {
      if (props.loading || mergedDisabledRef.value) return;
      if (e.key === ' ') {
        e.preventDefault();
        pressedRef.value = true;
      }
    }
    const cssVarsRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const {
        value: size
      } = mergedSizeRef;
      const {
        self: {
          opacityDisabled,
          railColor,
          railColorActive,
          buttonBoxShadow,
          buttonColor,
          boxShadowFocus,
          loadingColor,
          textColor,
          iconColor,
          [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_9__.createKey)('buttonHeight', size)]: buttonHeight,
          [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_9__.createKey)('buttonWidth', size)]: buttonWidth,
          [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_9__.createKey)('buttonWidthPressed', size)]: buttonWidthPressed,
          [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_9__.createKey)('railHeight', size)]: railHeight,
          [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_9__.createKey)('railWidth', size)]: railWidth,
          [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_9__.createKey)('railBorderRadius', size)]: railBorderRadius,
          [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_9__.createKey)('buttonBorderRadius', size)]: buttonBorderRadius
        },
        common: {
          cubicBezierEaseInOut
        }
      } = themeRef.value;
      let offset;
      let height;
      let width;
      if (supportCssMax) {
        offset = `calc((${railHeight} - ${buttonHeight}) / 2)`;
        height = `max(${railHeight}, ${buttonHeight})`;
        width = `max(${railWidth}, calc(${railWidth} + ${buttonHeight} - ${railHeight}))`;
      } else {
        offset = (0,seemly__WEBPACK_IMPORTED_MODULE_10__.pxfy)(((0,seemly__WEBPACK_IMPORTED_MODULE_10__.depx)(railHeight) - (0,seemly__WEBPACK_IMPORTED_MODULE_10__.depx)(buttonHeight)) / 2);
        height = (0,seemly__WEBPACK_IMPORTED_MODULE_10__.pxfy)(Math.max((0,seemly__WEBPACK_IMPORTED_MODULE_10__.depx)(railHeight), (0,seemly__WEBPACK_IMPORTED_MODULE_10__.depx)(buttonHeight)));
        width = (0,seemly__WEBPACK_IMPORTED_MODULE_10__.depx)(railHeight) > (0,seemly__WEBPACK_IMPORTED_MODULE_10__.depx)(buttonHeight) ? railWidth : (0,seemly__WEBPACK_IMPORTED_MODULE_10__.pxfy)((0,seemly__WEBPACK_IMPORTED_MODULE_10__.depx)(railWidth) + (0,seemly__WEBPACK_IMPORTED_MODULE_10__.depx)(buttonHeight) - (0,seemly__WEBPACK_IMPORTED_MODULE_10__.depx)(railHeight));
      }
      return {
        '--n-bezier': cubicBezierEaseInOut,
        '--n-button-border-radius': buttonBorderRadius,
        '--n-button-box-shadow': buttonBoxShadow,
        '--n-button-color': buttonColor,
        '--n-button-width': buttonWidth,
        '--n-button-width-pressed': buttonWidthPressed,
        '--n-button-height': buttonHeight,
        '--n-height': height,
        '--n-offset': offset,
        '--n-opacity-disabled': opacityDisabled,
        '--n-rail-border-radius': railBorderRadius,
        '--n-rail-color': railColor,
        '--n-rail-color-active': railColorActive,
        '--n-rail-height': railHeight,
        '--n-rail-width': railWidth,
        '--n-width': width,
        '--n-box-shadow-focus': boxShadowFocus,
        '--n-loading-color': loadingColor,
        '--n-text-color': textColor,
        '--n-icon-color': iconColor
      };
    });
    const themeClassHandle = inlineThemeDisabled ? (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_11__.useThemeClass)('switch', (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      return mergedSizeRef.value[0];
    }), cssVarsRef, props) : undefined;
    return {
      handleClick,
      handleBlur,
      handleFocus,
      handleKeyup,
      handleKeydown,
      mergedRailStyle: mergedRailStyleRef,
      pressed: pressedRef,
      mergedClsPrefix: mergedClsPrefixRef,
      mergedValue: mergedValueRef,
      checked: checkedRef,
      mergedDisabled: mergedDisabledRef,
      cssVars: inlineThemeDisabled ? undefined : cssVarsRef,
      themeClass: themeClassHandle === null || themeClassHandle === void 0 ? void 0 : themeClassHandle.themeClass,
      onRender: themeClassHandle === null || themeClassHandle === void 0 ? void 0 : themeClassHandle.onRender
    };
  },
  render() {
    const {
      mergedClsPrefix,
      mergedDisabled,
      checked,
      mergedRailStyle,
      onRender,
      $slots
    } = this;
    onRender === null || onRender === void 0 ? void 0 : onRender();
    const {
      checked: checkedSlot,
      unchecked: uncheckedSlot,
      icon: iconSlot,
      'checked-icon': checkedIconSlot,
      'unchecked-icon': uncheckedIconSlot
    } = $slots;
    const hasIcon = !((0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_12__.isSlotEmpty)(iconSlot) && (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_12__.isSlotEmpty)(checkedIconSlot) && (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_12__.isSlotEmpty)(uncheckedIconSlot));
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      role: "switch",
      "aria-checked": checked,
      class: [`${mergedClsPrefix}-switch`, this.themeClass, hasIcon && `${mergedClsPrefix}-switch--icon`, checked && `${mergedClsPrefix}-switch--active`, mergedDisabled && `${mergedClsPrefix}-switch--disabled`, this.round && `${mergedClsPrefix}-switch--round`, this.loading && `${mergedClsPrefix}-switch--loading`, this.pressed && `${mergedClsPrefix}-switch--pressed`, this.rubberBand && `${mergedClsPrefix}-switch--rubber-band`],
      tabindex: !this.mergedDisabled ? 0 : undefined,
      style: this.cssVars,
      onClick: this.handleClick,
      onFocus: this.handleFocus,
      onBlur: this.handleBlur,
      onKeyup: this.handleKeyup,
      onKeydown: this.handleKeydown
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${mergedClsPrefix}-switch__rail`,
      "aria-hidden": "true",
      style: mergedRailStyle
    }, (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_12__.resolveWrappedSlot)(checkedSlot, checkedSlotChildren => (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_12__.resolveWrappedSlot)(uncheckedSlot, uncheckedSlotChildren => {
      if (checkedSlotChildren || uncheckedSlotChildren) {
        return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
          "aria-hidden": true,
          class: `${mergedClsPrefix}-switch__children-placeholder`
        }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
          class: `${mergedClsPrefix}-switch__rail-placeholder`
        }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
          class: `${mergedClsPrefix}-switch__button-placeholder`
        }), checkedSlotChildren), (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
          class: `${mergedClsPrefix}-switch__rail-placeholder`
        }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
          class: `${mergedClsPrefix}-switch__button-placeholder`
        }), uncheckedSlotChildren));
      }
      return null;
    })), (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${mergedClsPrefix}-switch__button`
    }, (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_12__.resolveWrappedSlot)(iconSlot, icon => (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_12__.resolveWrappedSlot)(checkedIconSlot, checkedIcon => (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_12__.resolveWrappedSlot)(uncheckedIconSlot, uncheckedIcon => {
      return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_internal_index_mjs__WEBPACK_IMPORTED_MODULE_13__["default"], null, {
        default: () => this.loading ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_internal_index_mjs__WEBPACK_IMPORTED_MODULE_14__["default"], {
          key: "loading",
          clsPrefix: mergedClsPrefix,
          strokeWidth: 20
        }) : this.checked && (checkedIcon || icon) ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
          class: `${mergedClsPrefix}-switch__button-icon`,
          key: checkedIcon ? 'checked-icon' : 'icon'
        }, checkedIcon || icon) : !this.checked && (uncheckedIcon || icon) ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
          class: `${mergedClsPrefix}-switch__button-icon`,
          key: uncheckedIcon ? 'unchecked-icon' : 'icon'
        }, uncheckedIcon || icon) : null
      });
    }))), (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_12__.resolveWrappedSlot)(checkedSlot, children => children && (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      key: "checked",
      class: `${mergedClsPrefix}-switch__checked`
    }, children)), (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_12__.resolveWrappedSlot)(uncheckedSlot, children => children && (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      key: "unchecked",
      class: `${mergedClsPrefix}-switch__unchecked`
    }, children)))));
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/switch/src/styles/index.cssr.mjs":
/*!*******************************************************************!*\
  !*** ./node_modules/naive-ui/es/switch/src/styles/index.cssr.mjs ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _styles_transitions_icon_switch_cssr_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../_styles/transitions/icon-switch.cssr.mjs */ "./node_modules/naive-ui/es/_styles/transitions/icon-switch.cssr.mjs");
/* harmony import */ var _utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../_utils/cssr/index.mjs */ "./node_modules/naive-ui/es/_utils/cssr/index.mjs");


// vars:
// --n-bezier
// --n-button-border-radius
// --n-button-box-shadow
// --n-button-color
// --n-button-width
// --n-button-width-pressed
// --n-height
// --n-offset
// --n-rail-border-radius
// --n-rail-color
// --n-rail-color-active
// --n-rail-height
// --n-rail-width
// --n-width
// --n-box-shadow-focus
// --n-loading-color
// --n-text-color
// --n-icon-color
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('switch', `
 height: var(--n-height);
 min-width: var(--n-width);
 vertical-align: middle;
 user-select: none;
 -webkit-user-select: none;
 display: inline-flex;
 outline: none;
 justify-content: center;
 align-items: center;
`, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('children-placeholder', `
 height: var(--n-rail-height);
 display: flex;
 flex-direction: column;
 overflow: hidden;
 pointer-events: none;
 visibility: hidden;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('rail-placeholder', `
 display: flex;
 flex-wrap: none;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('button-placeholder', `
 width: calc(1.75 * var(--n-rail-height));
 height: var(--n-rail-height);
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-loading', `
 position: absolute;
 top: 50%;
 left: 50%;
 transform: translateX(-50%) translateY(-50%);
 font-size: calc(var(--n-button-width) - 4px);
 color: var(--n-loading-color);
 transition: color .3s var(--n-bezier);
 `, [(0,_styles_transitions_icon_switch_cssr_mjs__WEBPACK_IMPORTED_MODULE_1__.iconSwitchTransition)({
  left: '50%',
  top: '50%',
  originalTransform: 'translateX(-50%) translateY(-50%)'
})]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('checked, unchecked', `
 transition: color .3s var(--n-bezier);
 color: var(--n-text-color);
 box-sizing: border-box;
 position: absolute;
 white-space: nowrap;
 top: 0;
 bottom: 0;
 display: flex;
 align-items: center;
 line-height: 1;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('checked', `
 right: 0;
 padding-right: calc(1.25 * var(--n-rail-height) - var(--n-offset));
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('unchecked', `
 left: 0;
 justify-content: flex-end;
 padding-left: calc(1.25 * var(--n-rail-height) - var(--n-offset));
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:focus', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('rail', `
 box-shadow: var(--n-box-shadow-focus);
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('round', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('rail', 'border-radius: calc(var(--n-rail-height) / 2);', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('button', 'border-radius: calc(var(--n-button-height) / 2);')])]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cNotM)('disabled', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cNotM)('icon', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('rubber-band', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('pressed', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('rail', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('button', 'max-width: var(--n-button-width-pressed);')])]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('rail', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:active', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('button', 'max-width: var(--n-button-width-pressed);')])]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('active', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('pressed', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('rail', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('button', 'left: calc(100% - var(--n-offset) - var(--n-button-width-pressed));')])]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('rail', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:active', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('button', 'left: calc(100% - var(--n-offset) - var(--n-button-width-pressed));')])])])])])]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('active', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('rail', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('button', 'left: calc(100% - var(--n-button-width) - var(--n-offset))')])]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('rail', `
 overflow: hidden;
 height: var(--n-rail-height);
 min-width: var(--n-rail-width);
 border-radius: var(--n-rail-border-radius);
 cursor: pointer;
 position: relative;
 transition:
 opacity .3s var(--n-bezier),
 background .3s var(--n-bezier),
 box-shadow .3s var(--n-bezier);
 background-color: var(--n-rail-color);
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('button-icon', `
 color: var(--n-icon-color);
 transition: color .3s var(--n-bezier);
 font-size: calc(var(--n-button-height) - 4px);
 position: absolute;
 left: 0;
 right: 0;
 top: 0;
 bottom: 0;
 display: flex;
 justify-content: center;
 align-items: center;
 line-height: 1;
 `, [(0,_styles_transitions_icon_switch_cssr_mjs__WEBPACK_IMPORTED_MODULE_1__.iconSwitchTransition)()]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('button', `
 align-items: center; 
 top: var(--n-offset);
 left: var(--n-offset);
 height: var(--n-button-height);
 width: var(--n-button-width-pressed);
 max-width: var(--n-button-width);
 border-radius: var(--n-button-border-radius);
 background-color: var(--n-button-color);
 box-shadow: var(--n-button-box-shadow);
 box-sizing: border-box;
 cursor: inherit;
 content: "";
 position: absolute;
 transition:
 background-color .3s var(--n-bezier),
 left .3s var(--n-bezier),
 opacity .3s var(--n-bezier),
 max-width .3s var(--n-bezier),
 box-shadow .3s var(--n-bezier);
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('active', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('rail', 'background-color: var(--n-rail-color-active);')]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('loading', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('rail', `
 cursor: wait;
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('disabled', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('rail', `
 cursor: not-allowed;
 opacity: .5;
 `)])]));

/***/ }),

/***/ "./node_modules/naive-ui/es/switch/styles/light.mjs":
/*!**********************************************************!*\
  !*** ./node_modules/naive-ui/es/switch/styles/light.mjs ***!
  \**********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/color/index.js");
/* harmony import */ var _styles_common_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../_styles/common/index.mjs */ "./node_modules/naive-ui/es/_styles/common/light.mjs");
/* harmony import */ var _common_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_common.mjs */ "./node_modules/naive-ui/es/switch/styles/_common.mjs");



function self(vars) {
  const {
    primaryColor,
    opacityDisabled,
    borderRadius,
    textColor3
  } = vars;
  const railOverlayColor = 'rgba(0, 0, 0, .14)';
  return Object.assign(Object.assign({}, _common_mjs__WEBPACK_IMPORTED_MODULE_0__["default"]), {
    iconColor: textColor3,
    textColor: 'white',
    loadingColor: primaryColor,
    opacityDisabled,
    railColor: railOverlayColor,
    railColorActive: primaryColor,
    buttonBoxShadow: '0 1px 4px 0 rgba(0, 0, 0, 0.3), inset 0 0 1px 0 rgba(0, 0, 0, 0.05)',
    buttonColor: '#FFF',
    railBorderRadiusSmall: borderRadius,
    railBorderRadiusMedium: borderRadius,
    railBorderRadiusLarge: borderRadius,
    buttonBorderRadiusSmall: borderRadius,
    buttonBorderRadiusMedium: borderRadius,
    buttonBorderRadiusLarge: borderRadius,
    boxShadowFocus: `0 0 0 2px ${(0,seemly__WEBPACK_IMPORTED_MODULE_1__.changeColor)(primaryColor, {
      alpha: 0.2
    })}`
  });
}
const switchLight = {
  name: 'Switch',
  common: _styles_common_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"],
  self
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (switchLight);

/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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