"use strict";
(self["webpackChunknearbeach"] = self["webpackChunknearbeach"] || []).push([["vendors-node_modules_seemly_es_css_index_js-node_modules_naive-ui_es__internal_suffix_src_Suf-0706eb"],{

/***/ "./node_modules/seemly/es/css/index.js":
/*!*********************************************!*\
  !*** ./node_modules/seemly/es/css/index.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   depx: () => (/* binding */ depx),
/* harmony export */   getGap: () => (/* binding */ getGap),
/* harmony export */   getMargin: () => (/* binding */ getMargin),
/* harmony export */   getPadding: () => (/* binding */ getMargin),
/* harmony export */   parseResponsiveProp: () => (/* reexport safe */ _responsive__WEBPACK_IMPORTED_MODULE_0__.parseResponsiveProp),
/* harmony export */   parseResponsivePropValue: () => (/* reexport safe */ _responsive__WEBPACK_IMPORTED_MODULE_0__.parseResponsivePropValue),
/* harmony export */   pxfy: () => (/* binding */ pxfy)
/* harmony export */ });
/* harmony import */ var _responsive__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./responsive */ "./node_modules/seemly/es/css/responsive.js");
function depx(value) {
    if (typeof value === 'string') {
        if (value.endsWith('px')) {
            return Number(value.slice(0, value.length - 2));
        }
        return Number(value);
    }
    return value;
}
function pxfy(value) {
    if (value === undefined || value === null)
        return undefined;
    if (typeof value === 'number')
        return `${value}px`;
    if (value.endsWith('px'))
        return value;
    return `${value}px`;
}

function getMargin(value, position) {
    const parts = value.trim().split(/\s+/g);
    const margin = {
        top: parts[0]
    };
    switch (parts.length) {
        case 1:
            margin.right = parts[0];
            margin.bottom = parts[0];
            margin.left = parts[0];
            break;
        case 2:
            margin.right = parts[1];
            margin.left = parts[1];
            margin.bottom = parts[0];
            break;
        case 3:
            margin.right = parts[1];
            margin.bottom = parts[2];
            margin.left = parts[1];
            break;
        case 4:
            margin.right = parts[1];
            margin.bottom = parts[2];
            margin.left = parts[3];
            break;
        default:
            throw new Error('[seemly/getMargin]:' + value + ' is not a valid value.');
    }
    if (position === undefined)
        return margin;
    return margin[position];
}
function getGap(value, orient) {
    const [rowGap, colGap] = value.split(' ');
    if (!orient)
        return {
            row: rowGap,
            col: colGap || rowGap
        };
    return orient === 'row' ? rowGap : colGap;
}




/***/ }),

/***/ "./node_modules/seemly/es/css/responsive.js":
/*!**************************************************!*\
  !*** ./node_modules/seemly/es/css/responsive.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseResponsiveProp: () => (/* binding */ parseResponsiveProp),
/* harmony export */   parseResponsivePropValue: () => (/* binding */ parseResponsivePropValue)
/* harmony export */ });
function parseResponsiveProp(reponsiveProp) {
    if (typeof reponsiveProp === "number") {
        return {
            '': reponsiveProp.toString()
        };
    }
    const params = {};
    reponsiveProp.split(/ +/).forEach((pairLiteral) => {
        if (pairLiteral === '')
            return;
        const [prefix, value] = pairLiteral.split(':');
        if (value === undefined) {
            params[''] = prefix;
        }
        else {
            params[prefix] = value;
        }
    });
    return params;
}
function parseResponsivePropValue(reponsiveProp, activeKeyOrSize) {
    var _a;
    if (reponsiveProp === undefined || reponsiveProp === null)
        return undefined;
    const classObj = parseResponsiveProp(reponsiveProp);
    if (activeKeyOrSize === undefined)
        return classObj[''];
    if (typeof activeKeyOrSize === 'string') {
        return (_a = classObj[activeKeyOrSize]) !== null && _a !== void 0 ? _a : classObj[''];
    }
    else if (Array.isArray(activeKeyOrSize)) {
        for (let i = activeKeyOrSize.length - 1; i >= 0; --i) {
            const key = activeKeyOrSize[i];
            if (key in classObj)
                return classObj[key];
        }
        return classObj[''];
    }
    else {
        // Here we suppose all the keys are number formatted
        let activeValue = undefined;
        let activeKey = -1;
        Object.keys(classObj).forEach((key) => {
            const keyAsNum = Number(key);
            if (!Number.isNaN(keyAsNum) &&
                activeKeyOrSize >= keyAsNum &&
                keyAsNum >= activeKey) {
                activeKey = keyAsNum;
                activeValue = classObj[key];
            }
        });
        return activeValue;
    }
}



/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/clear/src/Clear.mjs":
/*!****************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/clear/src/Clear.mjs ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/vue/resolve-slot.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-style.mjs");
/* harmony import */ var _icons_index_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../icons/index.mjs */ "./node_modules/naive-ui/es/_internal/icons/Clear.mjs");
/* harmony import */ var _icon_index_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../icon/index.mjs */ "./node_modules/naive-ui/es/_internal/icon/src/Icon.mjs");
/* harmony import */ var _icon_switch_transition_index_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../icon-switch-transition/index.mjs */ "./node_modules/naive-ui/es/_internal/icon-switch-transition/src/IconSwitchTransition.mjs");
/* harmony import */ var _styles_index_cssr_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./styles/index.cssr.mjs */ "./node_modules/naive-ui/es/_internal/clear/src/styles/index.cssr.mjs");







/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'BaseClear',
  props: {
    clsPrefix: {
      type: String,
      required: true
    },
    show: Boolean,
    onClear: Function
  },
  setup(props) {
    (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])('-base-clear', _styles_index_cssr_mjs__WEBPACK_IMPORTED_MODULE_2__["default"], (0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'clsPrefix'));
    return {
      handleMouseDown(e) {
        e.preventDefault();
      }
    };
  },
  render() {
    const {
      clsPrefix
    } = this;
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${clsPrefix}-base-clear`
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_icon_switch_transition_index_mjs__WEBPACK_IMPORTED_MODULE_3__["default"], null, {
      default: () => {
        var _a, _b;
        return this.show ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
          key: "dismiss",
          class: `${clsPrefix}-base-clear__clear`,
          onClick: this.onClear,
          onMousedown: this.handleMouseDown,
          "data-clear": true
        }, (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_4__.resolveSlot)(this.$slots.icon, () => [(0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_icon_index_mjs__WEBPACK_IMPORTED_MODULE_5__["default"], {
          clsPrefix: clsPrefix
        }, {
          default: () => (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_icons_index_mjs__WEBPACK_IMPORTED_MODULE_6__["default"], null)
        })])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
          key: "icon",
          class: `${clsPrefix}-base-clear__placeholder`
        }, (_b = (_a = this.$slots).placeholder) === null || _b === void 0 ? void 0 : _b.call(_a));
      }
    }));
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/clear/src/styles/index.cssr.mjs":
/*!****************************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/clear/src/styles/index.cssr.mjs ***!
  \****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../_utils/cssr/index.mjs */ "./node_modules/naive-ui/es/_utils/cssr/index.mjs");
/* harmony import */ var _styles_transitions_icon_switch_cssr_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../_styles/transitions/icon-switch.cssr.mjs */ "./node_modules/naive-ui/es/_styles/transitions/icon-switch.cssr.mjs");


// vars:
// --n-bezier
// --n-clear-color
// --n-clear-size
// --n-clear-color-hover
// --n-clear-color-pressed
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-clear', `
 flex-shrink: 0;
 height: 1em;
 width: 1em;
 position: relative;
`, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('>', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('clear', `
 font-size: var(--n-clear-size);
 height: 1em;
 width: 1em;
 cursor: pointer;
 color: var(--n-clear-color);
 transition: color .3s var(--n-bezier);
 display: flex;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:hover', `
 color: var(--n-clear-color-hover)!important;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:active', `
 color: var(--n-clear-color-pressed)!important;
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('placeholder', `
 display: flex;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('clear, placeholder', `
 position: absolute;
 left: 50%;
 top: 50%;
 transform: translateX(-50%) translateY(-50%);
 `, [(0,_styles_transitions_icon_switch_cssr_mjs__WEBPACK_IMPORTED_MODULE_1__.iconSwitchTransition)({
  originalTransform: 'translateX(-50%) translateY(-50%)',
  left: '50%',
  top: '50%'
})])])]));

/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/icons/ChevronDown.mjs":
/*!******************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/icons/ChevronDown.mjs ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'ChevronDown',
  render() {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("svg", {
      viewBox: "0 0 16 16",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("path", {
      d: "M3.14645 5.64645C3.34171 5.45118 3.65829 5.45118 3.85355 5.64645L8 9.79289L12.1464 5.64645C12.3417 5.45118 12.6583 5.45118 12.8536 5.64645C13.0488 5.84171 13.0488 6.15829 12.8536 6.35355L8.35355 10.8536C8.15829 11.0488 7.84171 11.0488 7.64645 10.8536L3.14645 6.35355C2.95118 6.15829 2.95118 5.84171 3.14645 5.64645Z",
      fill: "currentColor"
    }));
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/icons/Clear.mjs":
/*!************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/icons/Clear.mjs ***!
  \************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _replaceable_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./replaceable.mjs */ "./node_modules/naive-ui/es/_internal/icons/replaceable.mjs");


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_replaceable_mjs__WEBPACK_IMPORTED_MODULE_1__.replaceable)('clear', (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("svg", {
  viewBox: "0 0 16 16",
  version: "1.1",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("g", {
  stroke: "none",
  "stroke-width": "1",
  fill: "none",
  "fill-rule": "evenodd"
}, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("g", {
  fill: "currentColor",
  "fill-rule": "nonzero"
}, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("path", {
  d: "M8,2 C11.3137085,2 14,4.6862915 14,8 C14,11.3137085 11.3137085,14 8,14 C4.6862915,14 2,11.3137085 2,8 C2,4.6862915 4.6862915,2 8,2 Z M6.5343055,5.83859116 C6.33943736,5.70359511 6.07001296,5.72288026 5.89644661,5.89644661 L5.89644661,5.89644661 L5.83859116,5.9656945 C5.70359511,6.16056264 5.72288026,6.42998704 5.89644661,6.60355339 L5.89644661,6.60355339 L7.293,8 L5.89644661,9.39644661 L5.83859116,9.4656945 C5.70359511,9.66056264 5.72288026,9.92998704 5.89644661,10.1035534 L5.89644661,10.1035534 L5.9656945,10.1614088 C6.16056264,10.2964049 6.42998704,10.2771197 6.60355339,10.1035534 L6.60355339,10.1035534 L8,8.707 L9.39644661,10.1035534 L9.4656945,10.1614088 C9.66056264,10.2964049 9.92998704,10.2771197 10.1035534,10.1035534 L10.1035534,10.1035534 L10.1614088,10.0343055 C10.2964049,9.83943736 10.2771197,9.57001296 10.1035534,9.39644661 L10.1035534,9.39644661 L8.707,8 L10.1035534,6.60355339 L10.1614088,6.5343055 C10.2964049,6.33943736 10.2771197,6.07001296 10.1035534,5.89644661 L10.1035534,5.89644661 L10.0343055,5.83859116 C9.83943736,5.70359511 9.57001296,5.72288026 9.39644661,5.89644661 L9.39644661,5.89644661 L8,7.293 L6.60355339,5.89644661 Z"
}))))));

/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/suffix/src/Suffix.mjs":
/*!******************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/suffix/src/Suffix.mjs ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _clear_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../clear/index.mjs */ "./node_modules/naive-ui/es/_internal/clear/src/Clear.mjs");
/* harmony import */ var _loading_index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../loading/index.mjs */ "./node_modules/naive-ui/es/_internal/loading/src/Loading.mjs");
/* harmony import */ var _icon_index_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../icon/index.mjs */ "./node_modules/naive-ui/es/_internal/icon/src/Icon.mjs");
/* harmony import */ var _icons_index_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../icons/index.mjs */ "./node_modules/naive-ui/es/_internal/icons/ChevronDown.mjs");
/* harmony import */ var _utils_vue_index_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../_utils/vue/index.mjs */ "./node_modules/naive-ui/es/_utils/vue/resolve-slot.mjs");






/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'InternalSelectionSuffix',
  props: {
    clsPrefix: {
      type: String,
      required: true
    },
    showArrow: {
      type: Boolean,
      default: undefined
    },
    showClear: {
      type: Boolean,
      default: undefined
    },
    loading: {
      type: Boolean,
      default: false
    },
    onClear: Function
  },
  setup(props, {
    slots
  }) {
    return () => {
      const {
        clsPrefix
      } = props;
      return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_loading_index_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], {
        clsPrefix: clsPrefix,
        class: `${clsPrefix}-base-suffix`,
        strokeWidth: 24,
        scale: 0.85,
        show: props.loading
      }, {
        default: () => props.showArrow ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_clear_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"], {
          clsPrefix: clsPrefix,
          show: props.showClear,
          onClear: props.onClear
        }, {
          placeholder: () => (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_icon_index_mjs__WEBPACK_IMPORTED_MODULE_3__["default"], {
            clsPrefix: clsPrefix,
            class: `${clsPrefix}-base-suffix__arrow`
          }, {
            default: () => (0,_utils_vue_index_mjs__WEBPACK_IMPORTED_MODULE_4__.resolveSlot)(slots.default, () => [(0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_icons_index_mjs__WEBPACK_IMPORTED_MODULE_5__["default"], null)])
          })
        }) : null
      });
    };
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/color-picker/src/AlphaSlider.mjs":
/*!*******************************************************************!*\
  !*** ./node_modules/naive-ui/es/color-picker/src/AlphaSlider.mjs ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var evtd__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! evtd */ "./node_modules/evtd/es/delegate.js");
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/color/index.js");
/* harmony import */ var _utils_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils.mjs */ "./node_modules/naive-ui/es/color-picker/src/utils.mjs");




const HANDLE_SIZE = '12px';
const HANDLE_SIZE_NUM = 12;
const RADIUS = '6px';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'AlphaSlider',
  props: {
    clsPrefix: {
      type: String,
      required: true
    },
    rgba: {
      type: Array,
      default: null
    },
    alpha: {
      type: Number,
      default: 0
    },
    onUpdateAlpha: {
      type: Function,
      required: true
    },
    onComplete: Function
  },
  setup(props) {
    const railRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    function handleMouseDown(e) {
      if (!railRef.value || !props.rgba) return;
      (0,evtd__WEBPACK_IMPORTED_MODULE_1__.on)('mousemove', document, handleMouseMove);
      (0,evtd__WEBPACK_IMPORTED_MODULE_1__.on)('mouseup', document, handleMouseUp);
      handleMouseMove(e);
    }
    function handleMouseMove(e) {
      const {
        value: railEl
      } = railRef;
      if (!railEl) return;
      const {
        width,
        left
      } = railEl.getBoundingClientRect();
      const newAlpha = (e.clientX - left) / (width - HANDLE_SIZE_NUM);
      props.onUpdateAlpha((0,_utils_mjs__WEBPACK_IMPORTED_MODULE_2__.normalizeAlpha)(newAlpha));
    }
    function handleMouseUp() {
      var _a;
      (0,evtd__WEBPACK_IMPORTED_MODULE_1__.off)('mousemove', document, handleMouseMove);
      (0,evtd__WEBPACK_IMPORTED_MODULE_1__.off)('mouseup', document, handleMouseUp);
      (_a = props.onComplete) === null || _a === void 0 ? void 0 : _a.call(props);
    }
    return {
      railRef,
      railBackgroundImage: (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
        const {
          rgba
        } = props;
        if (!rgba) return '';
        return `linear-gradient(to right, rgba(${rgba[0]}, ${rgba[1]}, ${rgba[2]}, 0) 0%, rgba(${rgba[0]}, ${rgba[1]}, ${rgba[2]}, 1) 100%)`;
      }),
      handleMouseDown
    };
  },
  render() {
    const {
      clsPrefix
    } = this;
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${clsPrefix}-color-picker-slider`,
      ref: "railRef",
      style: {
        height: HANDLE_SIZE,
        borderRadius: RADIUS
      },
      onMousedown: this.handleMouseDown
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      style: {
        borderRadius: RADIUS,
        position: 'absolute',
        left: 0,
        right: 0,
        top: 0,
        bottom: 0,
        overflow: 'hidden'
      }
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${clsPrefix}-color-picker-checkboard`
    }), (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${clsPrefix}-color-picker-slider__image`,
      style: {
        backgroundImage: this.railBackgroundImage
      }
    })), this.rgba && (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      style: {
        position: 'absolute',
        left: RADIUS,
        right: RADIUS,
        top: 0,
        bottom: 0
      }
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${clsPrefix}-color-picker-handle`,
      style: {
        left: `calc(${this.alpha * 100}% - ${RADIUS})`,
        borderRadius: RADIUS,
        width: HANDLE_SIZE,
        height: HANDLE_SIZE
      }
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${clsPrefix}-color-picker-handle__fill`,
      style: {
        backgroundColor: (0,seemly__WEBPACK_IMPORTED_MODULE_3__.toRgbaString)(this.rgba),
        borderRadius: RADIUS,
        width: HANDLE_SIZE,
        height: HANDLE_SIZE
      }
    }))));
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/color-picker/src/ColorInput.mjs":
/*!******************************************************************!*\
  !*** ./node_modules/naive-ui/es/color-picker/src/ColorInput.mjs ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/color/index.js");
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _input_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../input/index.mjs */ "./node_modules/naive-ui/es/input/src/InputGroup.mjs");
/* harmony import */ var _ColorInputUnit_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ColorInputUnit.mjs */ "./node_modules/naive-ui/es/color-picker/src/ColorInputUnit.mjs");




/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'ColorInput',
  props: {
    clsPrefix: {
      type: String,
      required: true
    },
    mode: {
      type: String,
      required: true
    },
    modes: {
      type: Array,
      required: true
    },
    showAlpha: {
      type: Boolean,
      required: true
    },
    value: {
      // for hex to get percise value
      type: String,
      default: null
    },
    valueArr: {
      type: Array,
      default: null
    },
    onUpdateValue: {
      type: Function,
      required: true
    },
    onUpdateMode: {
      type: Function,
      required: true
    }
  },
  setup(props) {
    return {
      handleUnitUpdateValue(index, value) {
        const {
          showAlpha
        } = props;
        if (props.mode === 'hex') {
          props.onUpdateValue((showAlpha ? seemly__WEBPACK_IMPORTED_MODULE_1__.toHexaString : seemly__WEBPACK_IMPORTED_MODULE_1__.toHexString)(value));
          return;
        }
        let nextValueArr;
        if (props.valueArr === null) {
          nextValueArr = [0, 0, 0, 0];
        } else {
          nextValueArr = Array.from(props.valueArr);
        }
        switch (props.mode) {
          case 'hsv':
            nextValueArr[index] = value;
            props.onUpdateValue((showAlpha ? seemly__WEBPACK_IMPORTED_MODULE_1__.toHsvaString : seemly__WEBPACK_IMPORTED_MODULE_1__.toHsvString)(nextValueArr));
            break;
          case 'rgb':
            nextValueArr[index] = value;
            props.onUpdateValue((showAlpha ? seemly__WEBPACK_IMPORTED_MODULE_1__.toRgbaString : seemly__WEBPACK_IMPORTED_MODULE_1__.toRgbString)(nextValueArr));
            break;
          case 'hsl':
            nextValueArr[index] = value;
            props.onUpdateValue((showAlpha ? seemly__WEBPACK_IMPORTED_MODULE_1__.toHslaString : seemly__WEBPACK_IMPORTED_MODULE_1__.toHslString)(nextValueArr));
            break;
        }
      }
    };
  },
  render() {
    const {
      clsPrefix,
      modes
    } = this;
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${clsPrefix}-color-picker-input`
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${clsPrefix}-color-picker-input__mode`,
      onClick: this.onUpdateMode,
      style: {
        cursor: modes.length === 1 ? '' : 'pointer'
      }
    }, this.mode.toUpperCase() + (this.showAlpha ? 'A' : '')), (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_input_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"], null, {
      default: () => {
        const {
          mode,
          valueArr,
          showAlpha
        } = this;
        if (mode === 'hex') {
          // hex and rgba shares the same value arr
          let hexValue = null;
          try {
            hexValue = valueArr === null ? null : (showAlpha ? seemly__WEBPACK_IMPORTED_MODULE_1__.toHexaString : seemly__WEBPACK_IMPORTED_MODULE_1__.toHexString)(valueArr);
          } catch (_a) {}
          return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_ColorInputUnit_mjs__WEBPACK_IMPORTED_MODULE_3__["default"], {
            label: 'HEX',
            showAlpha: showAlpha,
            value: hexValue,
            onUpdateValue: unitValue => {
              this.handleUnitUpdateValue(0, unitValue);
            }
          });
        }
        return (mode + (showAlpha ? 'a' : '')).split('').map((v, i) => (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_ColorInputUnit_mjs__WEBPACK_IMPORTED_MODULE_3__["default"], {
          label: v.toUpperCase(),
          value: valueArr === null ? null : valueArr[i],
          onUpdateValue: unitValue => {
            this.handleUnitUpdateValue(i, unitValue);
          }
        }));
      }
    }));
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/color-picker/src/ColorInputUnit.mjs":
/*!**********************************************************************!*\
  !*** ./node_modules/naive-ui/es/color-picker/src/ColorInputUnit.mjs ***!
  \**********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _input_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../input/index.mjs */ "./node_modules/naive-ui/es/input/src/Input.mjs");
/* harmony import */ var _context_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./context.mjs */ "./node_modules/naive-ui/es/color-picker/src/context.mjs");



// 0 - 255
function normalizeRgbUnit(value) {
  if (/^\d{1,3}\.?\d*$/.test(value.trim())) {
    return Math.max(0, Math.min(parseInt(value), 255));
  }
  return false;
}
// 0 - 360
function normalizeHueUnit(value) {
  if (/^\d{1,3}\.?\d*$/.test(value.trim())) {
    return Math.max(0, Math.min(parseInt(value), 360));
  }
  return false;
}
// 0 - 100
function normalizeSlvUnit(value) {
  if (/^\d{1,3}\.?\d*$/.test(value.trim())) {
    return Math.max(0, Math.min(parseInt(value), 100));
  }
  return false;
}
function normalizeHexaUnit(value) {
  const trimmedValue = value.trim();
  if (/^#[0-9a-fA-F]+$/.test(trimmedValue)) {
    return [4, 5, 7, 9].includes(trimmedValue.length);
  }
  return false;
}
// 0 - 100%
function normalizeAlphaUnit(value) {
  if (/^\d{1,3}\.?\d*%$/.test(value.trim())) {
    return Math.max(0, Math.min(parseInt(value) / 100, 100));
  }
  return false;
}
const inputThemeOverrides = {
  paddingSmall: '0 4px'
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'ColorInputUnit',
  props: {
    label: {
      type: String,
      required: true
    },
    value: {
      type: [Number, String],
      default: null
    },
    showAlpha: Boolean,
    onUpdateValue: {
      type: Function,
      required: true
    }
  },
  setup(props) {
    const inputValueRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)('');
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    const {
      themeRef
    } = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(_context_mjs__WEBPACK_IMPORTED_MODULE_1__.colorPickerInjectionKey, null);
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watchEffect)(() => {
      inputValueRef.value = getInputString();
    });
    function getInputString() {
      const {
        value
      } = props;
      if (value === null) return '';
      const {
        label
      } = props;
      if (label === 'HEX') {
        return value;
      }
      if (label === 'A') {
        return `${Math.floor(value * 100)}%`;
      }
      return String(Math.floor(value));
    }
    function handleInputUpdateValue(value) {
      inputValueRef.value = value;
    }
    function handleInputChange(value) {
      let unit;
      let valid;
      switch (props.label) {
        case 'HEX':
          valid = normalizeHexaUnit(value);
          if (valid) {
            props.onUpdateValue(value);
          }
          inputValueRef.value = getInputString(); // to normalized new value
          break;
        case 'H':
          unit = normalizeHueUnit(value);
          if (unit === false) {
            inputValueRef.value = getInputString();
          } else {
            props.onUpdateValue(unit);
          }
          break;
        case 'S':
        case 'L':
        case 'V':
          unit = normalizeSlvUnit(value);
          if (unit === false) {
            inputValueRef.value = getInputString();
          } else {
            props.onUpdateValue(unit);
          }
          break;
        case 'A':
          unit = normalizeAlphaUnit(value);
          if (unit === false) {
            inputValueRef.value = getInputString();
          } else {
            props.onUpdateValue(unit);
          }
          break;
        case 'R':
        case 'G':
        case 'B':
          unit = normalizeRgbUnit(value);
          if (unit === false) {
            inputValueRef.value = getInputString();
          } else {
            props.onUpdateValue(unit);
          }
          break;
      }
    }
    return {
      mergedTheme: themeRef,
      inputValue: inputValueRef,
      handleInputChange,
      handleInputUpdateValue
    };
  },
  render() {
    const {
      mergedTheme
    } = this;
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_input_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"], {
      size: "small",
      placeholder: this.label,
      theme: mergedTheme.peers.Input,
      themeOverrides: mergedTheme.peerOverrides.Input,
      builtinThemeOverrides: inputThemeOverrides,
      value: this.inputValue,
      onUpdateValue: this.handleInputUpdateValue,
      onChange: this.handleInputChange,
      // add more space for xxx% input
      style: this.label === 'A' ? 'flex-grow: 1.25;' : ''
    });
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/color-picker/src/ColorPicker.mjs":
/*!*******************************************************************!*\
  !*** ./node_modules/naive-ui/es/color-picker/src/ColorPicker.mjs ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   colorPickerProps: () => (/* binding */ colorPickerProps),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/color/index.js");
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/color/convert.js");
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/dom/get-precise-event-target.js");
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/use-merged-state.js");
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/life-cycle/use-is-mounted.js");
/* harmony import */ var vueuc__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! vueuc */ "./node_modules/vueuc/es/binder/src/Binder.js");
/* harmony import */ var vueuc__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! vueuc */ "./node_modules/vueuc/es/binder/src/Target.js");
/* harmony import */ var vueuc__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! vueuc */ "./node_modules/vueuc/es/binder/src/Follower.js");
/* harmony import */ var vdirs__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! vdirs */ "./node_modules/vdirs/es/clickoutside.js");
/* harmony import */ var _styles_index_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../styles/index.mjs */ "./node_modules/naive-ui/es/color-picker/styles/light.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-theme.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-form-item.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-locale.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-config.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-css-vars-class.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/composable/use-adjusted-to.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/vue/call.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/cssr/index.mjs");
/* harmony import */ var _button_index_mjs__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../button/index.mjs */ "./node_modules/naive-ui/es/button/src/Button.mjs");
/* harmony import */ var _HueSlider_mjs__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./HueSlider.mjs */ "./node_modules/naive-ui/es/color-picker/src/HueSlider.mjs");
/* harmony import */ var _AlphaSlider_mjs__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./AlphaSlider.mjs */ "./node_modules/naive-ui/es/color-picker/src/AlphaSlider.mjs");
/* harmony import */ var _Pallete_mjs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./Pallete.mjs */ "./node_modules/naive-ui/es/color-picker/src/Pallete.mjs");
/* harmony import */ var _ColorInput_mjs__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./ColorInput.mjs */ "./node_modules/naive-ui/es/color-picker/src/ColorInput.mjs");
/* harmony import */ var _ColorPickerTrigger_mjs__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./ColorPickerTrigger.mjs */ "./node_modules/naive-ui/es/color-picker/src/ColorPickerTrigger.mjs");
/* harmony import */ var _utils_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./utils.mjs */ "./node_modules/naive-ui/es/color-picker/src/utils.mjs");
/* harmony import */ var _ColorPickerSwatches_mjs__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./ColorPickerSwatches.mjs */ "./node_modules/naive-ui/es/color-picker/src/ColorPickerSwatches.mjs");
/* harmony import */ var _ColorPreview_mjs__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./ColorPreview.mjs */ "./node_modules/naive-ui/es/color-picker/src/ColorPreview.mjs");
/* harmony import */ var _context_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./context.mjs */ "./node_modules/naive-ui/es/color-picker/src/context.mjs");
/* harmony import */ var _styles_index_cssr_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./styles/index.cssr.mjs */ "./node_modules/naive-ui/es/color-picker/src/styles/index.cssr.mjs");



















const colorPickerProps = Object.assign(Object.assign({}, _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].props), {
  value: String,
  show: {
    type: Boolean,
    default: undefined
  },
  defaultShow: Boolean,
  defaultValue: String,
  modes: {
    type: Array,
    // no hsva by default since browser doesn't support it
    default: () => ['rgb', 'hex', 'hsl']
  },
  placement: {
    type: String,
    default: 'bottom-start'
  },
  to: _utils_index_mjs__WEBPACK_IMPORTED_MODULE_2__.useAdjustedTo.propTo,
  showAlpha: {
    type: Boolean,
    default: true
  },
  showPreview: Boolean,
  swatches: Array,
  disabled: {
    type: Boolean,
    default: undefined
  },
  actions: {
    type: Array,
    default: null
  },
  internalActions: Array,
  size: String,
  renderLabel: Function,
  onComplete: Function,
  onConfirm: Function,
  'onUpdate:show': [Function, Array],
  onUpdateShow: [Function, Array],
  'onUpdate:value': [Function, Array],
  onUpdateValue: [Function, Array]
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'ColorPicker',
  props: colorPickerProps,
  setup(props, {
    slots
  }) {
    const selfRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    let upcomingValue = null;
    const formItem = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_3__["default"])(props);
    const {
      mergedSizeRef,
      mergedDisabledRef
    } = formItem;
    const {
      localeRef
    } = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_4__["default"])('global');
    const {
      mergedClsPrefixRef,
      namespaceRef,
      inlineThemeDisabled
    } = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_5__["default"])(props);
    const themeRef = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])('ColorPicker', '-color-picker', _styles_index_cssr_mjs__WEBPACK_IMPORTED_MODULE_6__["default"], _styles_index_mjs__WEBPACK_IMPORTED_MODULE_7__["default"], props, mergedClsPrefixRef);
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.provide)(_context_mjs__WEBPACK_IMPORTED_MODULE_8__.colorPickerInjectionKey, {
      themeRef,
      renderLabelRef: (0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'renderLabel'),
      colorPickerSlots: slots
    });
    const uncontrolledShowRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(props.defaultShow);
    const mergedShowRef = (0,vooks__WEBPACK_IMPORTED_MODULE_9__["default"])((0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'show'), uncontrolledShowRef);
    function doUpdateShow(value) {
      const {
        onUpdateShow,
        'onUpdate:show': _onUpdateShow
      } = props;
      if (onUpdateShow) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_10__.call)(onUpdateShow, value);
      if (_onUpdateShow) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_10__.call)(_onUpdateShow, value);
      uncontrolledShowRef.value = value;
    }
    const {
      defaultValue
    } = props;
    const uncontrolledValueRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(defaultValue === undefined ? (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_11__.deriveDefaultValue)(props.modes, props.showAlpha) : defaultValue);
    const mergedValueRef = (0,vooks__WEBPACK_IMPORTED_MODULE_9__["default"])((0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'value'), uncontrolledValueRef);
    const undoStackRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)([mergedValueRef.value]);
    const valueIndexRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(0);
    const valueModeRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_11__.getModeFromValue)(mergedValueRef.value));
    const {
      modes
    } = props;
    const displayedModeRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)((0,_utils_mjs__WEBPACK_IMPORTED_MODULE_11__.getModeFromValue)(mergedValueRef.value) || modes[0] || 'rgb');
    function handleUpdateDisplayedMode() {
      const {
        modes
      } = props;
      const {
        value: displayedMode
      } = displayedModeRef;
      const currentModeIndex = modes.findIndex(mode => mode === displayedMode);
      if (~currentModeIndex) {
        displayedModeRef.value = modes[(currentModeIndex + 1) % modes.length];
      } else {
        displayedModeRef.value = 'rgb';
      }
    }
    let _h,
      // avoid conflict with render function's h
      s, l, v, r, g, b, a;
    const hsvaRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const {
        value: mergedValue
      } = mergedValueRef;
      if (!mergedValue) return null;
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
      switch (valueModeRef.value) {
        case 'hsv':
          return (0,seemly__WEBPACK_IMPORTED_MODULE_12__.hsva)(mergedValue);
        case 'hsl':
          ;
          [_h, s, l, a] = (0,seemly__WEBPACK_IMPORTED_MODULE_12__.hsla)(mergedValue);
          return [...(0,seemly__WEBPACK_IMPORTED_MODULE_13__.hsl2hsv)(_h, s, l), a];
        case 'rgb':
        case 'hex':
          ;
          [r, g, b, a] = (0,seemly__WEBPACK_IMPORTED_MODULE_12__.rgba)(mergedValue);
          return [...(0,seemly__WEBPACK_IMPORTED_MODULE_13__.rgb2hsv)(r, g, b), a];
      }
    });
    const rgbaRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const {
        value: mergedValue
      } = mergedValueRef;
      if (!mergedValue) return null;
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
      switch (valueModeRef.value) {
        case 'rgb':
        case 'hex':
          return (0,seemly__WEBPACK_IMPORTED_MODULE_12__.rgba)(mergedValue);
        case 'hsv':
          ;
          [_h, s, v, a] = (0,seemly__WEBPACK_IMPORTED_MODULE_12__.hsva)(mergedValue);
          return [...(0,seemly__WEBPACK_IMPORTED_MODULE_13__.hsv2rgb)(_h, s, v), a];
        case 'hsl':
          ;
          [_h, s, l, a] = (0,seemly__WEBPACK_IMPORTED_MODULE_12__.hsla)(mergedValue);
          return [...(0,seemly__WEBPACK_IMPORTED_MODULE_13__.hsl2rgb)(_h, s, l), a];
      }
    });
    const hslaRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const {
        value: mergedValue
      } = mergedValueRef;
      if (!mergedValue) return null;
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
      switch (valueModeRef.value) {
        case 'hsl':
          return (0,seemly__WEBPACK_IMPORTED_MODULE_12__.hsla)(mergedValue);
        case 'hsv':
          ;
          [_h, s, v, a] = (0,seemly__WEBPACK_IMPORTED_MODULE_12__.hsva)(mergedValue);
          return [...(0,seemly__WEBPACK_IMPORTED_MODULE_13__.hsv2hsl)(_h, s, v), a];
        case 'rgb':
        case 'hex':
          ;
          [r, g, b, a] = (0,seemly__WEBPACK_IMPORTED_MODULE_12__.rgba)(mergedValue);
          return [...(0,seemly__WEBPACK_IMPORTED_MODULE_13__.rgb2hsl)(r, g, b), a];
      }
    });
    const mergedValueArrRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      switch (displayedModeRef.value) {
        case 'rgb':
        case 'hex':
          return rgbaRef.value;
        case 'hsv':
          return hsvaRef.value;
        case 'hsl':
          return hslaRef.value;
      }
    });
    const displayedHueRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(0);
    const displayedAlphaRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(1);
    const displayedSvRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)([0, 0]);
    function handleUpdateSv(s, v) {
      const {
        value: hsvaArr
      } = hsvaRef;
      const hue = displayedHueRef.value;
      const alpha = hsvaArr ? hsvaArr[3] : 1;
      displayedSvRef.value = [s, v];
      const {
        showAlpha
      } = props;
      switch (displayedModeRef.value) {
        case 'hsv':
          doUpdateValue((showAlpha ? seemly__WEBPACK_IMPORTED_MODULE_12__.toHsvaString : seemly__WEBPACK_IMPORTED_MODULE_12__.toHsvString)([hue, s, v, alpha]), 'cursor');
          break;
        case 'hsl':
          doUpdateValue((showAlpha ? seemly__WEBPACK_IMPORTED_MODULE_12__.toHslaString : seemly__WEBPACK_IMPORTED_MODULE_12__.toHslString)([...(0,seemly__WEBPACK_IMPORTED_MODULE_13__.hsv2hsl)(hue, s, v), alpha]), 'cursor');
          break;
        case 'rgb':
          doUpdateValue((showAlpha ? seemly__WEBPACK_IMPORTED_MODULE_12__.toRgbaString : seemly__WEBPACK_IMPORTED_MODULE_12__.toRgbString)([...(0,seemly__WEBPACK_IMPORTED_MODULE_13__.hsv2rgb)(hue, s, v), alpha]), 'cursor');
          break;
        case 'hex':
          doUpdateValue((showAlpha ? seemly__WEBPACK_IMPORTED_MODULE_12__.toHexaString : seemly__WEBPACK_IMPORTED_MODULE_12__.toHexString)([...(0,seemly__WEBPACK_IMPORTED_MODULE_13__.hsv2rgb)(hue, s, v), alpha]), 'cursor');
          break;
      }
    }
    function handleUpdateHue(hue) {
      displayedHueRef.value = hue;
      const {
        value: hsvaArr
      } = hsvaRef;
      if (!hsvaArr) {
        return;
      }
      const [, s, v, a] = hsvaArr;
      const {
        showAlpha
      } = props;
      switch (displayedModeRef.value) {
        case 'hsv':
          doUpdateValue((showAlpha ? seemly__WEBPACK_IMPORTED_MODULE_12__.toHsvaString : seemly__WEBPACK_IMPORTED_MODULE_12__.toHsvString)([hue, s, v, a]), 'cursor');
          break;
        case 'rgb':
          doUpdateValue((showAlpha ? seemly__WEBPACK_IMPORTED_MODULE_12__.toRgbaString : seemly__WEBPACK_IMPORTED_MODULE_12__.toRgbString)([...(0,seemly__WEBPACK_IMPORTED_MODULE_13__.hsv2rgb)(hue, s, v), a]), 'cursor');
          break;
        case 'hex':
          doUpdateValue((showAlpha ? seemly__WEBPACK_IMPORTED_MODULE_12__.toHexaString : seemly__WEBPACK_IMPORTED_MODULE_12__.toHexString)([...(0,seemly__WEBPACK_IMPORTED_MODULE_13__.hsv2rgb)(hue, s, v), a]), 'cursor');
          break;
        case 'hsl':
          doUpdateValue((showAlpha ? seemly__WEBPACK_IMPORTED_MODULE_12__.toHslaString : seemly__WEBPACK_IMPORTED_MODULE_12__.toHslString)([...(0,seemly__WEBPACK_IMPORTED_MODULE_13__.hsv2hsl)(hue, s, v), a]), 'cursor');
          break;
      }
    }
    function handleUpdateAlpha(alpha) {
      switch (displayedModeRef.value) {
        case 'hsv':
          // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
          ;
          [_h, s, v] = hsvaRef.value;
          doUpdateValue((0,seemly__WEBPACK_IMPORTED_MODULE_12__.toHsvaString)([_h, s, v, alpha]), 'cursor');
          break;
        case 'rgb':
          // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
          ;
          [r, g, b] = rgbaRef.value;
          doUpdateValue((0,seemly__WEBPACK_IMPORTED_MODULE_12__.toRgbaString)([r, g, b, alpha]), 'cursor');
          break;
        case 'hex':
          // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
          ;
          [r, g, b] = rgbaRef.value;
          doUpdateValue((0,seemly__WEBPACK_IMPORTED_MODULE_12__.toHexaString)([r, g, b, alpha]), 'cursor');
          break;
        case 'hsl':
          // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
          ;
          [_h, s, l] = hslaRef.value;
          doUpdateValue((0,seemly__WEBPACK_IMPORTED_MODULE_12__.toHslaString)([_h, s, l, alpha]), 'cursor');
          break;
      }
      displayedAlphaRef.value = alpha;
    }
    function doUpdateValue(value, updateSource) {
      if (updateSource === 'cursor') {
        upcomingValue = value;
      } else {
        upcomingValue = null;
      }
      const {
        nTriggerFormChange,
        nTriggerFormInput
      } = formItem;
      const {
        onUpdateValue,
        'onUpdate:value': _onUpdateValue
      } = props;
      if (onUpdateValue) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_10__.call)(onUpdateValue, value);
      if (_onUpdateValue) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_10__.call)(_onUpdateValue, value);
      nTriggerFormChange();
      nTriggerFormInput();
      uncontrolledValueRef.value = value;
    }
    function handleInputUpdateValue(value) {
      doUpdateValue(value, 'input');
      void (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(handleComplete);
    }
    function handleComplete(pushStack = true) {
      const {
        value
      } = mergedValueRef;
      // no value & only hue changes will complete with no value
      if (value) {
        const {
          nTriggerFormChange,
          nTriggerFormInput
        } = formItem;
        const {
          onComplete
        } = props;
        if (onComplete) {
          ;
          onComplete(value);
        }
        const {
          value: undoStack
        } = undoStackRef;
        const {
          value: valueIndex
        } = valueIndexRef;
        if (pushStack) {
          undoStack.splice(valueIndex + 1, undoStack.length, value);
          valueIndexRef.value = valueIndex + 1;
        }
        nTriggerFormChange();
        nTriggerFormInput();
      }
    }
    function undo() {
      const {
        value: valueIndex
      } = valueIndexRef;
      if (valueIndex - 1 < 0) return;
      doUpdateValue(undoStackRef.value[valueIndex - 1], 'input');
      handleComplete(false);
      valueIndexRef.value = valueIndex - 1;
    }
    function redo() {
      const {
        value: valueIndex
      } = valueIndexRef;
      if (valueIndex < 0 || valueIndex + 1 >= undoStackRef.value.length) return;
      doUpdateValue(undoStackRef.value[valueIndex + 1], 'input');
      handleComplete(false);
      valueIndexRef.value = valueIndex + 1;
    }
    function handleClear() {
      doUpdateValue(null, 'input');
      doUpdateShow(false);
    }
    function handleConfirm() {
      const {
        value
      } = mergedValueRef;
      const {
        onConfirm
      } = props;
      if (onConfirm) {
        ;
        onConfirm(value);
      }
      doUpdateShow(false);
    }
    const undoableRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => valueIndexRef.value >= 1);
    const redoableRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const {
        value: undoStack
      } = undoStackRef;
      return undoStack.length > 1 && valueIndexRef.value < undoStack.length - 1;
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(mergedShowRef, value => {
      if (!value) {
        undoStackRef.value = [mergedValueRef.value];
        valueIndexRef.value = 0;
      }
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watchEffect)(() => {
      if (upcomingValue && upcomingValue === mergedValueRef.value) {
        // let it works in uncontrolled mode
      } else {
        const {
          value
        } = hsvaRef;
        if (value) {
          displayedHueRef.value = value[0];
          displayedAlphaRef.value = value[3];
          displayedSvRef.value = [value[1], value[2]];
        }
      }
      upcomingValue = null;
    });
    const cssVarsRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const {
        value: mergedSize
      } = mergedSizeRef;
      const {
        common: {
          cubicBezierEaseInOut
        },
        self: {
          textColor,
          color,
          panelFontSize,
          boxShadow,
          border,
          borderRadius,
          dividerColor,
          [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_14__.createKey)('height', mergedSize)]: height,
          [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_14__.createKey)('fontSize', mergedSize)]: fontSize
        }
      } = themeRef.value;
      return {
        '--n-bezier': cubicBezierEaseInOut,
        '--n-text-color': textColor,
        '--n-color': color,
        '--n-panel-font-size': panelFontSize,
        '--n-font-size': fontSize,
        '--n-box-shadow': boxShadow,
        '--n-border': border,
        '--n-border-radius': borderRadius,
        '--n-height': height,
        '--n-divider-color': dividerColor
      };
    });
    const themeClassHandle = inlineThemeDisabled ? (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_15__.useThemeClass)('color-picker', (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      return mergedSizeRef.value[0];
    }), cssVarsRef, props) : undefined;
    function renderPanel() {
      var _a;
      const {
        value: rgba
      } = rgbaRef;
      const {
        value: displayedHue
      } = displayedHueRef;
      const {
        internalActions,
        modes,
        actions
      } = props;
      const {
        value: mergedTheme
      } = themeRef;
      const {
        value: mergedClsPrefix
      } = mergedClsPrefixRef;
      return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
        class: [`${mergedClsPrefix}-color-picker-panel`, themeClassHandle === null || themeClassHandle === void 0 ? void 0 : themeClassHandle.themeClass.value],
        onDragstart: e => {
          e.preventDefault();
        },
        style: inlineThemeDisabled ? undefined : cssVarsRef.value
      }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
        class: `${mergedClsPrefix}-color-picker-control`
      }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_Pallete_mjs__WEBPACK_IMPORTED_MODULE_16__["default"], {
        clsPrefix: mergedClsPrefix,
        rgba: rgba,
        displayedHue: displayedHue,
        displayedSv: displayedSvRef.value,
        onUpdateSV: handleUpdateSv,
        onComplete: handleComplete
      }), (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
        class: `${mergedClsPrefix}-color-picker-preview`
      }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
        class: `${mergedClsPrefix}-color-picker-preview__sliders`
      }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_HueSlider_mjs__WEBPACK_IMPORTED_MODULE_17__["default"], {
        clsPrefix: mergedClsPrefix,
        hue: displayedHue,
        onUpdateHue: handleUpdateHue,
        onComplete: handleComplete
      }), props.showAlpha ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_AlphaSlider_mjs__WEBPACK_IMPORTED_MODULE_18__["default"], {
        clsPrefix: mergedClsPrefix,
        rgba: rgba,
        alpha: displayedAlphaRef.value,
        onUpdateAlpha: handleUpdateAlpha,
        onComplete: handleComplete
      }) : null), props.showPreview ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_ColorPreview_mjs__WEBPACK_IMPORTED_MODULE_19__["default"], {
        clsPrefix: mergedClsPrefix,
        mode: displayedModeRef.value,
        color: rgbaRef.value && (0,seemly__WEBPACK_IMPORTED_MODULE_12__.toHexString)(rgbaRef.value),
        onUpdateColor: color => {
          doUpdateValue(color, 'input');
        }
      }) : null), (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_ColorInput_mjs__WEBPACK_IMPORTED_MODULE_20__["default"], {
        clsPrefix: mergedClsPrefix,
        showAlpha: props.showAlpha,
        mode: displayedModeRef.value,
        modes: modes,
        onUpdateMode: handleUpdateDisplayedMode,
        value: mergedValueRef.value,
        valueArr: mergedValueArrRef.value,
        onUpdateValue: handleInputUpdateValue
      }), ((_a = props.swatches) === null || _a === void 0 ? void 0 : _a.length) && (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_ColorPickerSwatches_mjs__WEBPACK_IMPORTED_MODULE_21__["default"], {
        clsPrefix: mergedClsPrefix,
        mode: displayedModeRef.value,
        swatches: props.swatches,
        onUpdateColor: color => {
          doUpdateValue(color, 'input');
        }
      })), (actions === null || actions === void 0 ? void 0 : actions.length) ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
        class: `${mergedClsPrefix}-color-picker-action`
      }, actions.includes('confirm') && (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_button_index_mjs__WEBPACK_IMPORTED_MODULE_22__["default"], {
        size: "small",
        onClick: handleConfirm,
        theme: mergedTheme.peers.Button,
        themeOverrides: mergedTheme.peerOverrides.Button
      }, {
        default: () => localeRef.value.confirm
      }), actions.includes('clear') && (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_button_index_mjs__WEBPACK_IMPORTED_MODULE_22__["default"], {
        size: "small",
        onClick: handleClear,
        disabled: !mergedValueRef.value,
        theme: mergedTheme.peers.Button,
        themeOverrides: mergedTheme.peerOverrides.Button
      }, {
        default: () => localeRef.value.clear
      })) : null, slots.action ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
        class: `${mergedClsPrefix}-color-picker-action`
      }, {
        default: slots.action
      }) : internalActions ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
        class: `${mergedClsPrefix}-color-picker-action`
      }, internalActions.includes('undo') && (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_button_index_mjs__WEBPACK_IMPORTED_MODULE_22__["default"], {
        size: "small",
        onClick: undo,
        disabled: !undoableRef.value,
        theme: mergedTheme.peers.Button,
        themeOverrides: mergedTheme.peerOverrides.Button
      }, {
        default: () => localeRef.value.undo
      }), internalActions.includes('redo') && (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_button_index_mjs__WEBPACK_IMPORTED_MODULE_22__["default"], {
        size: "small",
        onClick: redo,
        disabled: !redoableRef.value,
        theme: mergedTheme.peers.Button,
        themeOverrides: mergedTheme.peerOverrides.Button
      }, {
        default: () => localeRef.value.redo
      })) : null);
    }
    return {
      mergedClsPrefix: mergedClsPrefixRef,
      namespace: namespaceRef,
      selfRef,
      hsla: hslaRef,
      rgba: rgbaRef,
      mergedShow: mergedShowRef,
      mergedDisabled: mergedDisabledRef,
      isMounted: (0,vooks__WEBPACK_IMPORTED_MODULE_23__["default"])(),
      adjustedTo: (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_2__.useAdjustedTo)(props),
      mergedValue: mergedValueRef,
      handleTriggerClick() {
        doUpdateShow(true);
      },
      handleClickOutside(e) {
        var _a;
        if ((_a = selfRef.value) === null || _a === void 0 ? void 0 : _a.contains((0,seemly__WEBPACK_IMPORTED_MODULE_24__.getPreciseEventTarget)(e))) {
          return;
        }
        doUpdateShow(false);
      },
      renderPanel,
      cssVars: inlineThemeDisabled ? undefined : cssVarsRef,
      themeClass: themeClassHandle === null || themeClassHandle === void 0 ? void 0 : themeClassHandle.themeClass,
      onRender: themeClassHandle === null || themeClassHandle === void 0 ? void 0 : themeClassHandle.onRender
    };
  },
  render() {
    const {
      $slots,
      mergedClsPrefix,
      onRender
    } = this;
    onRender === null || onRender === void 0 ? void 0 : onRender();
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: [this.themeClass, `${mergedClsPrefix}-color-picker`],
      ref: "selfRef",
      style: this.cssVars
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vueuc__WEBPACK_IMPORTED_MODULE_25__["default"], null, {
      default: () => [(0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vueuc__WEBPACK_IMPORTED_MODULE_26__["default"], null, {
        default: () => (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_ColorPickerTrigger_mjs__WEBPACK_IMPORTED_MODULE_27__["default"], {
          clsPrefix: mergedClsPrefix,
          value: this.mergedValue,
          hsla: this.hsla,
          disabled: this.mergedDisabled,
          onClick: this.handleTriggerClick
        }, {
          label: $slots.label
        })
      }), (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vueuc__WEBPACK_IMPORTED_MODULE_28__["default"], {
        placement: this.placement,
        show: this.mergedShow,
        containerClass: this.namespace,
        teleportDisabled: this.adjustedTo === _utils_index_mjs__WEBPACK_IMPORTED_MODULE_2__.useAdjustedTo.tdkey,
        to: this.adjustedTo
      }, {
        default: () => (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vue__WEBPACK_IMPORTED_MODULE_0__.Transition, {
          name: "fade-in-scale-up-transition",
          appear: this.isMounted
        }, {
          default: () => this.mergedShow ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)(this.renderPanel(), [[vdirs__WEBPACK_IMPORTED_MODULE_29__["default"], this.handleClickOutside, undefined, {
            capture: true
          }]]) : null
        })
      })]
    }));
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/color-picker/src/ColorPickerSwatches.mjs":
/*!***************************************************************************!*\
  !*** ./node_modules/naive-ui/es/color-picker/src/ColorPickerSwatches.mjs ***!
  \***************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/color/index.js");
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/color/convert.js");
/* harmony import */ var _utils_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./utils.mjs */ "./node_modules/naive-ui/es/color-picker/src/utils.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/naive/warn.mjs");




// Try to normalize the color values to ensure that they are valid CSS colors
function normalizeColor(color, mode) {
  if (mode === 'hsv') {
    const [h, s, v, a] = (0,seemly__WEBPACK_IMPORTED_MODULE_1__.hsva)(color);
    return (0,seemly__WEBPACK_IMPORTED_MODULE_1__.toRgbaString)([...(0,seemly__WEBPACK_IMPORTED_MODULE_2__.hsv2rgb)(h, s, v), a]);
  }
  // For the mode that is not in preset, we keep the original value.
  // For color names, they are legal to CSS, so we don’t deal with them,
  // and only standardize them when outputting.
  return color;
}
function getHexFromName(color) {
  const ctx = document.createElement('canvas').getContext('2d');
  if (!ctx) {
    return '#000000';
  }
  ctx.fillStyle = color;
  return ctx.fillStyle;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'ColorPickerSwatches',
  props: {
    clsPrefix: {
      type: String,
      required: true
    },
    mode: {
      type: String,
      required: true
    },
    swatches: {
      type: Array,
      required: true
    },
    onUpdateColor: {
      type: Function,
      required: true
    }
  },
  setup(props) {
    const parsedSwatchesRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => props.swatches.map(value => {
      const mode = (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_3__.getModeFromValue)(value);
      return {
        value,
        mode,
        legalValue: normalizeColor(value, mode)
      };
    }));
    function normalizeOutput(parsed) {
      const {
        mode: modeProp
      } = props;
      let {
        value,
        mode: swatchColorMode
      } = parsed;
      // color name is converted to hex
      if (!swatchColorMode) {
        swatchColorMode = 'hex';
        if (/^[a-zA-Z]+$/.test(value)) {
          value = getHexFromName(value);
        } else {
          // for invalid color, we make it black
          (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_4__.warn)('color-picker', `color ${value} in swatches is invalid.`);
          value = '#000000';
        }
      }
      if (swatchColorMode === modeProp) return value;
      // swatch value to current mode value
      return (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_3__.convertColor)(value, modeProp, swatchColorMode);
    }
    function handleSwatchSelect(parsed) {
      props.onUpdateColor(normalizeOutput(parsed));
    }
    function handleSwatchKeyDown(e, parsed) {
      if (e.key === 'Enter') handleSwatchSelect(parsed);
    }
    return {
      parsedSwatchesRef,
      handleSwatchSelect,
      handleSwatchKeyDown
    };
  },
  render() {
    const {
      clsPrefix
    } = this;
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${clsPrefix}-color-picker-swatches`
    }, this.parsedSwatchesRef.map(swatch => (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${clsPrefix}-color-picker-swatch`,
      tabindex: 0,
      onClick: () => {
        this.handleSwatchSelect(swatch);
      },
      onKeydown: e => {
        this.handleSwatchKeyDown(e, swatch);
      }
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${clsPrefix}-color-picker-swatch__fill`,
      style: {
        background: swatch.legalValue
      }
    }))));
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/color-picker/src/ColorPickerTrigger.mjs":
/*!**************************************************************************!*\
  !*** ./node_modules/naive-ui/es/color-picker/src/ColorPickerTrigger.mjs ***!
  \**************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/color/index.js");
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _context_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./context.mjs */ "./node_modules/naive-ui/es/color-picker/src/context.mjs");



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'ColorPickerTrigger',
  props: {
    clsPrefix: {
      type: String,
      required: true
    },
    value: {
      type: String,
      default: null
    },
    hsla: {
      type: Array,
      default: null
    },
    disabled: Boolean,
    onClick: Function
  },
  setup(props) {
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    const {
      colorPickerSlots,
      renderLabelRef
    } = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(_context_mjs__WEBPACK_IMPORTED_MODULE_1__.colorPickerInjectionKey, null);
    return () => {
      const {
        hsla,
        value,
        clsPrefix,
        onClick,
        disabled
      } = props;
      const renderLabel = colorPickerSlots.label || renderLabelRef.value;
      return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
        class: [`${clsPrefix}-color-picker-trigger`, disabled && `${clsPrefix}-color-picker-trigger--disabled`],
        onClick: disabled ? undefined : onClick
      }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
        class: `${clsPrefix}-color-picker-trigger__fill`
      }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
        class: `${clsPrefix}-color-picker-checkboard`
      }), (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
        style: {
          position: 'absolute',
          left: 0,
          right: 0,
          top: 0,
          bottom: 0,
          backgroundColor: hsla ? (0,seemly__WEBPACK_IMPORTED_MODULE_2__.toHslaString)(hsla) : ''
        }
      }), value && hsla ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
        class: `${clsPrefix}-color-picker-trigger__value`,
        style: {
          color: hsla[2] > 50 || hsla[3] < 0.5 ? 'black' : 'white'
        }
      }, renderLabel ? renderLabel(value) : value) : null));
    };
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/color-picker/src/ColorPreview.mjs":
/*!********************************************************************!*\
  !*** ./node_modules/naive-ui/es/color-picker/src/ColorPreview.mjs ***!
  \********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _utils_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils.mjs */ "./node_modules/naive-ui/es/color-picker/src/utils.mjs");


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'ColorPreview',
  props: {
    clsPrefix: {
      type: String,
      required: true
    },
    mode: {
      type: String,
      required: true
    },
    color: {
      type: String,
      default: null,
      validator: value => {
        const mode = (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_1__.getModeFromValue)(value);
        return Boolean(!value || mode && mode !== 'hsv');
      }
    },
    onUpdateColor: {
      type: Function,
      required: true
    }
  },
  setup(props) {
    function handleChange(e) {
      var _a;
      // hex
      const value = e.target.value;
      (_a = props.onUpdateColor) === null || _a === void 0 ? void 0 : _a.call(props, (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_1__.convertColor)(value.toUpperCase(), props.mode, 'hex'));
      e.stopPropagation();
    }
    return {
      handleChange
    };
  },
  render() {
    const {
      clsPrefix
    } = this;
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${clsPrefix}-color-picker-preview__preview`
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("span", {
      class: `${clsPrefix}-color-picker-preview__fill`,
      style: {
        background: this.color || '#000000'
      }
    }), (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("input", {
      class: `${clsPrefix}-color-picker-preview__input`,
      type: "color",
      value: this.color,
      onChange: this.handleChange
    }));
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/color-picker/src/HueSlider.mjs":
/*!*****************************************************************!*\
  !*** ./node_modules/naive-ui/es/color-picker/src/HueSlider.mjs ***!
  \*****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var evtd__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! evtd */ "./node_modules/evtd/es/delegate.js");
/* harmony import */ var _utils_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils.mjs */ "./node_modules/naive-ui/es/color-picker/src/utils.mjs");



const HANDLE_SIZE = '12px';
const HANDLE_SIZE_NUM = 12;
const RADIUS = '6px';
const RADIUS_NUM = 6;
const GRADIENT = 'linear-gradient(90deg,red,#ff0 16.66%,#0f0 33.33%,#0ff 50%,#00f 66.66%,#f0f 83.33%,red)';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'HueSlider',
  props: {
    clsPrefix: {
      type: String,
      required: true
    },
    hue: {
      type: Number,
      required: true
    },
    onUpdateHue: {
      type: Function,
      required: true
    },
    onComplete: Function
  },
  setup(props) {
    const railRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    function handleMouseDown(e) {
      if (!railRef.value) return;
      (0,evtd__WEBPACK_IMPORTED_MODULE_1__.on)('mousemove', document, handleMouseMove);
      (0,evtd__WEBPACK_IMPORTED_MODULE_1__.on)('mouseup', document, handleMouseUp);
      handleMouseMove(e);
    }
    function handleMouseMove(e) {
      const {
        value: railEl
      } = railRef;
      if (!railEl) return;
      const {
        width,
        left
      } = railEl.getBoundingClientRect();
      const newHue = (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_2__.normalizeHue)((e.clientX - left - RADIUS_NUM) / (width - HANDLE_SIZE_NUM) * 360);
      props.onUpdateHue(newHue);
    }
    function handleMouseUp() {
      var _a;
      (0,evtd__WEBPACK_IMPORTED_MODULE_1__.off)('mousemove', document, handleMouseMove);
      (0,evtd__WEBPACK_IMPORTED_MODULE_1__.off)('mouseup', document, handleMouseUp);
      (_a = props.onComplete) === null || _a === void 0 ? void 0 : _a.call(props);
    }
    return {
      railRef,
      handleMouseDown
    };
  },
  render() {
    const {
      clsPrefix
    } = this;
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${clsPrefix}-color-picker-slider`,
      style: {
        height: HANDLE_SIZE,
        borderRadius: RADIUS
      }
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      ref: "railRef",
      style: {
        boxShadow: 'inset 0 0 2px 0 rgba(0, 0, 0, .24)',
        boxSizing: 'border-box',
        backgroundImage: GRADIENT,
        height: HANDLE_SIZE,
        borderRadius: RADIUS,
        position: 'relative'
      },
      onMousedown: this.handleMouseDown
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      style: {
        position: 'absolute',
        left: RADIUS,
        right: RADIUS,
        top: 0,
        bottom: 0
      }
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${clsPrefix}-color-picker-handle`,
      style: {
        left: `calc((${this.hue}%) / 359 * 100 - ${RADIUS})`,
        borderRadius: RADIUS,
        width: HANDLE_SIZE,
        height: HANDLE_SIZE
      }
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${clsPrefix}-color-picker-handle__fill`,
      style: {
        backgroundColor: `hsl(${this.hue}, 100%, 50%)`,
        borderRadius: RADIUS,
        width: HANDLE_SIZE,
        height: HANDLE_SIZE
      }
    })))));
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/color-picker/src/Pallete.mjs":
/*!***************************************************************!*\
  !*** ./node_modules/naive-ui/es/color-picker/src/Pallete.mjs ***!
  \***************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var evtd__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! evtd */ "./node_modules/evtd/es/delegate.js");
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");


const HANDLE_SIZE = '12px';
const RADIUS = '6px';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'Pallete',
  props: {
    clsPrefix: {
      type: String,
      required: true
    },
    rgba: {
      type: Array,
      default: null
    },
    // 0 - 360
    displayedHue: {
      type: Number,
      required: true
    },
    displayedSv: {
      type: Array,
      required: true
    },
    onUpdateSV: {
      type: Function,
      required: true
    },
    onComplete: Function
  },
  setup(props) {
    const palleteRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    function handleMouseDown(e) {
      if (!palleteRef.value) return;
      (0,evtd__WEBPACK_IMPORTED_MODULE_1__.on)('mousemove', document, handleMouseMove);
      (0,evtd__WEBPACK_IMPORTED_MODULE_1__.on)('mouseup', document, handleMouseUp);
      handleMouseMove(e);
    }
    function handleMouseMove(e) {
      const {
        value: palleteEl
      } = palleteRef;
      if (!palleteEl) return;
      const {
        width,
        height,
        left,
        bottom
      } = palleteEl.getBoundingClientRect();
      const newV = (bottom - e.clientY) / height;
      const newS = (e.clientX - left) / width;
      const normalizedNewS = 100 * (newS > 1 ? 1 : newS < 0 ? 0 : newS);
      const normalizedNewV = 100 * (newV > 1 ? 1 : newV < 0 ? 0 : newV);
      props.onUpdateSV(normalizedNewS, normalizedNewV);
    }
    function handleMouseUp() {
      var _a;
      (0,evtd__WEBPACK_IMPORTED_MODULE_1__.off)('mousemove', document, handleMouseMove);
      (0,evtd__WEBPACK_IMPORTED_MODULE_1__.off)('mouseup', document, handleMouseUp);
      (_a = props.onComplete) === null || _a === void 0 ? void 0 : _a.call(props);
    }
    return {
      palleteRef,
      handleColor: (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
        const {
          rgba
        } = props;
        if (!rgba) return '';
        return `rgb(${rgba[0]}, ${rgba[1]}, ${rgba[2]})`;
      }),
      handleMouseDown
    };
  },
  render() {
    const {
      clsPrefix
    } = this;
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${clsPrefix}-color-picker-pallete`,
      onMousedown: this.handleMouseDown,
      ref: "palleteRef"
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${clsPrefix}-color-picker-pallete__layer`,
      style: {
        backgroundImage: `linear-gradient(90deg, white, hsl(${this.displayedHue}, 100%, 50%))`
      }
    }), (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${clsPrefix}-color-picker-pallete__layer ${clsPrefix}-color-picker-pallete__layer--shadowed`,
      style: {
        backgroundImage: 'linear-gradient(180deg, rgba(0, 0, 0, 0%), rgba(0, 0, 0, 100%))'
      }
    }), this.rgba && (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${clsPrefix}-color-picker-handle`,
      style: {
        width: HANDLE_SIZE,
        height: HANDLE_SIZE,
        borderRadius: RADIUS,
        left: `calc(${this.displayedSv[0]}% - ${RADIUS})`,
        bottom: `calc(${this.displayedSv[1]}% - ${RADIUS})`
      }
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${clsPrefix}-color-picker-handle__fill`,
      style: {
        backgroundColor: this.handleColor,
        borderRadius: RADIUS,
        width: HANDLE_SIZE,
        height: HANDLE_SIZE
      }
    })));
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/color-picker/src/context.mjs":
/*!***************************************************************!*\
  !*** ./node_modules/naive-ui/es/color-picker/src/context.mjs ***!
  \***************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   colorPickerInjectionKey: () => (/* binding */ colorPickerInjectionKey)
/* harmony export */ });
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/vue/create-injection-key.mjs");

const colorPickerInjectionKey = (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_0__.createInjectionKey)('n-color-picker');

/***/ }),

/***/ "./node_modules/naive-ui/es/color-picker/src/styles/index.cssr.mjs":
/*!*************************************************************************!*\
  !*** ./node_modules/naive-ui/es/color-picker/src/styles/index.cssr.mjs ***!
  \*************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../_utils/cssr/index.mjs */ "./node_modules/naive-ui/es/_utils/cssr/index.mjs");
/* harmony import */ var _styles_transitions_fade_in_scale_up_cssr_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../_styles/transitions/fade-in-scale-up.cssr.mjs */ "./node_modules/naive-ui/es/_styles/transitions/fade-in-scale-up.cssr.mjs");


// vars:
// --n-color
// --n-text-color
// --n-border-radius
// --n-panel-font-size
// --n-font-size
// --n-bezier
// --n-height
// --n-box-shadow
// --n-divider-color
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)([(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('color-picker', `
 display: inline-block;
 box-sizing: border-box;
 height: var(--n-height);
 font-size: var(--n-font-size);
 width: 100%;
 position: relative;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('color-picker-panel', `
 margin: 4px 0;
 width: 240px;
 font-size: var(--n-panel-font-size);
 color: var(--n-text-color);
 background-color: var(--n-color);
 transition:
 box-shadow .3s var(--n-bezier),
 color .3s var(--n-bezier),
 background-color .3s var(--n-bezier);
 border-radius: var(--n-border-radius);
 box-shadow: var(--n-box-shadow);
 `, [(0,_styles_transitions_fade_in_scale_up_cssr_mjs__WEBPACK_IMPORTED_MODULE_1__.fadeInScaleUpTransition)(), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('input', `
 text-align: center;
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('color-picker-checkboard', `
 background: white; 
 position: absolute;
 left: 0;
 right: 0;
 top: 0;
 bottom: 0;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&::after', `
 background-image: linear-gradient(45deg, #DDD 25%, #0000 25%), linear-gradient(-45deg, #DDD 25%, #0000 25%), linear-gradient(45deg, #0000 75%, #DDD 75%), linear-gradient(-45deg, #0000 75%, #DDD 75%);
 background-size: 12px 12px;
 background-position: 0 0, 0 6px, 6px -6px, -6px 0px;
 background-repeat: repeat;
 content: "";
 position: absolute;
 left: 0;
 right: 0;
 top: 0;
 bottom: 0;
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('color-picker-slider', `
 margin-bottom: 8px;
 position: relative;
 box-sizing: border-box;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('image', `
 position: absolute;
 left: 0;
 right: 0;
 top: 0;
 bottom: 0;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&::after', `
 content: "";
 position: absolute;
 border-radius: inherit;
 left: 0;
 right: 0;
 top: 0;
 bottom: 0;
 box-shadow: inset 0 0 2px 0 rgba(0, 0, 0, .24);
 pointer-events: none;
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('color-picker-handle', `
 z-index: 1;
 box-shadow: 0 0 2px 0 rgba(0, 0, 0, .45);
 position: absolute;
 background-color: white;
 overflow: hidden;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('fill', `
 box-sizing: border-box;
 border: 2px solid white;
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('color-picker-pallete', `
 height: 180px;
 position: relative;
 margin-bottom: 8px;
 cursor: crosshair;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('layer', `
 position: absolute;
 left: 0;
 right: 0;
 top: 0;
 bottom: 0;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('shadowed', `
 box-shadow: inset 0 0 2px 0 rgba(0, 0, 0, .24);
 `)])]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('color-picker-preview', `
 display: flex;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('sliders', `
 flex: 1 0 auto;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('preview', `
 position: relative;
 height: 30px;
 width: 30px;
 margin: 0 0 8px 6px;
 border-radius: 50%;
 box-shadow: rgba(0, 0, 0, .15) 0px 0px 0px 1px inset;
 overflow: hidden;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('fill', `
 display: block;
 width: 30px;
 height: 30px;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('input', `
 position: absolute;
 top: 0;
 left: 0;
 width: 30px;
 height: 30px;
 opacity: 0;
 z-index: 1;
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('color-picker-input', `
 display: flex;
 align-items: center;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('input', `
 flex-grow: 1;
 flex-basis: 0;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('mode', `
 width: 72px;
 text-align: center;
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('color-picker-control', `
 padding: 12px;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('color-picker-action', `
 display: flex;
 margin-top: -4px;
 border-top: 1px solid var(--n-divider-color);
 padding: 8px 12px;
 justify-content: flex-end;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('button', 'margin-left: 8px;')]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('color-picker-trigger', `
 border: var(--n-border);
 height: 100%;
 box-sizing: border-box;
 border-radius: var(--n-border-radius);
 transition: border-color .3s var(--n-bezier);
 cursor: pointer;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('value', `
 white-space: nowrap;
 position: relative;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('fill', `
 border-radius: var(--n-border-radius);
 position: absolute;
 display: flex;
 align-items: center;
 justify-content: center;
 left: 4px;
 right: 4px;
 top: 4px;
 bottom: 4px;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cM)('disabled', 'cursor: not-allowed'), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('color-picker-checkboard', `
 border-radius: var(--n-border-radius);
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&::after', `
 --n-block-size: calc((var(--n-height) - 8px) / 3);
 background-size: calc(var(--n-block-size) * 2) calc(var(--n-block-size) * 2);
 background-position: 0 0, 0 var(--n-block-size), var(--n-block-size) calc(-1 * var(--n-block-size)), calc(-1 * var(--n-block-size)) 0px; 
 `)])]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('color-picker-swatches', `
 display: grid;
 grid-gap: 8px;
 flex-wrap: wrap;
 position: relative;
 grid-template-columns: repeat(auto-fill, 18px);
 margin-top: 10px;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('color-picker-swatch', `
 width: 18px;
 height: 18px;
 background-image: linear-gradient(45deg, #DDD 25%, #0000 25%), linear-gradient(-45deg, #DDD 25%, #0000 25%), linear-gradient(45deg, #0000 75%, #DDD 75%), linear-gradient(-45deg, #0000 75%, #DDD 75%);
 background-size: 8px 8px;
 background-position: 0px 0, 0px 4px, 4px -4px, -4px 0px;
 background-repeat: repeat;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('fill', `
 position: relative;
 width: 100%;
 height: 100%;
 border-radius: 3px;
 box-shadow: rgba(0, 0, 0, .15) 0px 0px 0px 1px inset;
 cursor: pointer;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:focus', `
 outline: none;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('fill', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&::after', `
 position: absolute;
 top: 0;
 right: 0;
 bottom: 0;
 left: 0;
 background: inherit;
 filter: blur(2px);
 content: "";
 `)])])])])]));

/***/ }),

/***/ "./node_modules/naive-ui/es/color-picker/src/utils.mjs":
/*!*************************************************************!*\
  !*** ./node_modules/naive-ui/es/color-picker/src/utils.mjs ***!
  \*************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   convertColor: () => (/* binding */ convertColor),
/* harmony export */   deriveDefaultValue: () => (/* binding */ deriveDefaultValue),
/* harmony export */   floor: () => (/* binding */ floor),
/* harmony export */   getModeFromValue: () => (/* binding */ getModeFromValue),
/* harmony export */   normalizeAlpha: () => (/* binding */ normalizeAlpha),
/* harmony export */   normalizeHue: () => (/* binding */ normalizeHue)
/* harmony export */ });
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/color/index.js");
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/color/convert.js");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/naive/warn.mjs");


function deriveDefaultValue(modes, showAlpha) {
  const mode = modes[0];
  switch (mode) {
    case 'hex':
      return showAlpha ? '#000000FF' : '#000000';
    case 'rgb':
      return showAlpha ? 'rgba(0, 0, 0, 1)' : 'rgb(0, 0, 0)';
    case 'hsl':
      return showAlpha ? 'hsla(0, 0%, 0%, 1)' : 'hsl(0, 0%, 0%)';
    case 'hsv':
      return showAlpha ? 'hsva(0, 0%, 0%, 1)' : 'hsv(0, 0%, 0%)';
  }
  if (true) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_0__.warn)('color-picker', 'props.modes is invalid.');
  // in case of invalid modes
  return '#000000';
}
function getModeFromValue(color) {
  if (color === null) return null;
  if (/^ *#/.test(color)) return 'hex';
  if (color.includes('rgb')) return 'rgb';
  if (color.includes('hsl')) return 'hsl';
  if (color.includes('hsv')) return 'hsv';
  return null;
}
function floor(color) {
  return color.map(channel => Math.floor(channel));
}
function normalizeHue(hue) {
  hue = Math.round(hue);
  return hue >= 360 ? 359 : hue < 0 ? 0 : hue;
}
function normalizeAlpha(alpha) {
  alpha = Math.round(alpha * 100) / 100;
  return alpha > 1 ? 1 : alpha < 0 ? 0 : alpha;
}
const convert = {
  rgb: {
    hex(value) {
      return (0,seemly__WEBPACK_IMPORTED_MODULE_1__.toHexaString)((0,seemly__WEBPACK_IMPORTED_MODULE_1__.rgba)(value));
    },
    hsl(value) {
      const [r, g, b, a] = (0,seemly__WEBPACK_IMPORTED_MODULE_1__.rgba)(value);
      return (0,seemly__WEBPACK_IMPORTED_MODULE_1__.toHslaString)([...(0,seemly__WEBPACK_IMPORTED_MODULE_2__.rgb2hsl)(r, g, b), a]);
    },
    hsv(value) {
      const [r, g, b, a] = (0,seemly__WEBPACK_IMPORTED_MODULE_1__.rgba)(value);
      return (0,seemly__WEBPACK_IMPORTED_MODULE_1__.toHsvaString)([...(0,seemly__WEBPACK_IMPORTED_MODULE_2__.rgb2hsv)(r, g, b), a]);
    }
  },
  hex: {
    rgb(value) {
      return (0,seemly__WEBPACK_IMPORTED_MODULE_1__.toRgbaString)((0,seemly__WEBPACK_IMPORTED_MODULE_1__.rgba)(value));
    },
    hsl(value) {
      const [r, g, b, a] = (0,seemly__WEBPACK_IMPORTED_MODULE_1__.rgba)(value);
      return (0,seemly__WEBPACK_IMPORTED_MODULE_1__.toHslaString)([...(0,seemly__WEBPACK_IMPORTED_MODULE_2__.rgb2hsl)(r, g, b), a]);
    },
    hsv(value) {
      const [r, g, b, a] = (0,seemly__WEBPACK_IMPORTED_MODULE_1__.rgba)(value);
      return (0,seemly__WEBPACK_IMPORTED_MODULE_1__.toHsvaString)([...(0,seemly__WEBPACK_IMPORTED_MODULE_2__.rgb2hsv)(r, g, b), a]);
    }
  },
  hsl: {
    hex(value) {
      const [h, s, l, a] = (0,seemly__WEBPACK_IMPORTED_MODULE_1__.hsla)(value);
      return (0,seemly__WEBPACK_IMPORTED_MODULE_1__.toHexaString)([...(0,seemly__WEBPACK_IMPORTED_MODULE_2__.hsl2rgb)(h, s, l), a]);
    },
    rgb(value) {
      const [h, s, l, a] = (0,seemly__WEBPACK_IMPORTED_MODULE_1__.hsla)(value);
      return (0,seemly__WEBPACK_IMPORTED_MODULE_1__.toRgbaString)([...(0,seemly__WEBPACK_IMPORTED_MODULE_2__.hsl2rgb)(h, s, l), a]);
    },
    hsv(value) {
      const [h, s, l, a] = (0,seemly__WEBPACK_IMPORTED_MODULE_1__.hsla)(value);
      return (0,seemly__WEBPACK_IMPORTED_MODULE_1__.toHsvaString)([...(0,seemly__WEBPACK_IMPORTED_MODULE_2__.hsl2hsv)(h, s, l), a]);
    }
  },
  hsv: {
    hex(value) {
      const [h, s, v, a] = (0,seemly__WEBPACK_IMPORTED_MODULE_1__.hsva)(value);
      return (0,seemly__WEBPACK_IMPORTED_MODULE_1__.toHexaString)([...(0,seemly__WEBPACK_IMPORTED_MODULE_2__.hsv2rgb)(h, s, v), a]);
    },
    rgb(value) {
      const [h, s, v, a] = (0,seemly__WEBPACK_IMPORTED_MODULE_1__.hsva)(value);
      return (0,seemly__WEBPACK_IMPORTED_MODULE_1__.toRgbaString)([...(0,seemly__WEBPACK_IMPORTED_MODULE_2__.hsv2rgb)(h, s, v), a]);
    },
    hsl(value) {
      const [h, s, v, a] = (0,seemly__WEBPACK_IMPORTED_MODULE_1__.hsva)(value);
      return (0,seemly__WEBPACK_IMPORTED_MODULE_1__.toHslaString)([...(0,seemly__WEBPACK_IMPORTED_MODULE_2__.hsv2hsl)(h, s, v), a]);
    }
  }
};
// implementation
function convertColor(value, mode, originalMode) {
  originalMode = originalMode || getModeFromValue(value);
  if (!originalMode) return null;
  if (originalMode === mode) return value;
  const conversions = convert[originalMode];
  return conversions[mode](value);
}

/***/ }),

/***/ "./node_modules/naive-ui/es/input/src/InputGroup.mjs":
/*!***********************************************************!*\
  !*** ./node_modules/naive-ui/es/input/src/InputGroup.mjs ***!
  \***********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   inputGroupProps: () => (/* binding */ inputGroupProps)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-config.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-style.mjs");
/* harmony import */ var _styles_input_group_cssr_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./styles/input-group.cssr.mjs */ "./node_modules/naive-ui/es/input/src/styles/input-group.cssr.mjs");



const inputGroupProps = {};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'InputGroup',
  props: inputGroupProps,
  setup(props) {
    const {
      mergedClsPrefixRef
    } = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(props);
    (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"])('-input-group', _styles_input_group_cssr_mjs__WEBPACK_IMPORTED_MODULE_3__["default"], mergedClsPrefixRef);
    return {
      mergedClsPrefix: mergedClsPrefixRef
    };
  },
  render() {
    const {
      mergedClsPrefix
    } = this;
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: `${mergedClsPrefix}-input-group`
    }, this.$slots);
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/input/src/styles/input-group.cssr.mjs":
/*!************************************************************************!*\
  !*** ./node_modules/naive-ui/es/input/src/styles/input-group.cssr.mjs ***!
  \************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../_utils/cssr/index.mjs */ "./node_modules/naive-ui/es/_utils/cssr/index.mjs");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('input-group', `
 display: inline-flex;
 width: 100%;
 flex-wrap: nowrap;
 vertical-align: bottom;
`, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('>', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('input', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:not(:last-child)', `
 border-top-right-radius: 0!important;
 border-bottom-right-radius: 0!important;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:not(:first-child)', `
 border-top-left-radius: 0!important;
 border-bottom-left-radius: 0!important;
 margin-left: -1px!important;
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('button', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:not(:last-child)', `
 border-top-right-radius: 0!important;
 border-bottom-right-radius: 0!important;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('state-border, border', `
 border-top-right-radius: 0!important;
 border-bottom-right-radius: 0!important;
 `)]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:not(:first-child)', `
 border-top-left-radius: 0!important;
 border-bottom-left-radius: 0!important;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('state-border, border', `
 border-top-left-radius: 0!important;
 border-bottom-left-radius: 0!important;
 `)])]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('*', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:not(:last-child)', `
 border-top-right-radius: 0!important;
 border-bottom-right-radius: 0!important;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('>', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('input', `
 border-top-right-radius: 0!important;
 border-bottom-right-radius: 0!important;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-selection', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-selection-label', `
 border-top-right-radius: 0!important;
 border-bottom-right-radius: 0!important;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-selection-tags', `
 border-top-right-radius: 0!important;
 border-bottom-right-radius: 0!important;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('box-shadow, border, state-border', `
 border-top-right-radius: 0!important;
 border-bottom-right-radius: 0!important;
 `)])])]), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('&:not(:first-child)', `
 margin-left: -1px!important;
 border-top-left-radius: 0!important;
 border-bottom-left-radius: 0!important;
 `, [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)('>', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('input', `
 border-top-left-radius: 0!important;
 border-bottom-left-radius: 0!important;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-selection', [(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-selection-label', `
 border-top-left-radius: 0!important;
 border-bottom-left-radius: 0!important;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('base-selection-tags', `
 border-top-left-radius: 0!important;
 border-bottom-left-radius: 0!important;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cE)('box-shadow, border, state-border', `
 border-top-left-radius: 0!important;
 border-bottom-left-radius: 0!important;
 `)])])])])])]));

/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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