from collections import namedtuple

from django.test import TestCase

from NearBeach.management.commands.runscheduler import Command
from NearBeach.models import ScheduledObject
from unittest import mock

import datetime


SCHEDULETest = namedtuple(
    "SCHEDULETest",
    ["year", "month", "day", "expected_ids"],
    defaults=[2024, 1, 1, [1]]
)


class RunSchedulerTest(TestCase):
    fixtures = ["NearBeach_basic_setup.json"]

    @mock.patch('NearBeach.management.commands.runscheduler.Command.get_today')
    def test_run_set_day_of_the_week(self, mock_get_today):
        # Data Array for loop
        data_array = [
            SCHEDULETest(2023, 12, 1, []),
            SCHEDULETest(2023, 12, 2, []),
            SCHEDULETest(2023, 12, 3, []),
            SCHEDULETest(2023, 12, 4, []),
            SCHEDULETest(2023, 12, 5, []),
            SCHEDULETest(2023, 12, 6, []),
            SCHEDULETest(2023, 12, 7, []),
            SCHEDULETest(2024, 1, 1, [1]),
            SCHEDULETest(2024, 1, 2, []),
            SCHEDULETest(2024, 1, 3, [1]),
            SCHEDULETest(2024, 1, 4, []),
            SCHEDULETest(2024, 1, 5, [1]),
            SCHEDULETest(2024, 1, 6, []),
            SCHEDULETest(2024, 1, 7, []),
            SCHEDULETest(2024, 1, 8, [1]),
            SCHEDULETest(2024, 1, 9, []),
            SCHEDULETest(2024, 1, 10, [1]),
            SCHEDULETest(2024, 1, 11, []),
            SCHEDULETest(2024, 1, 12, [1]),
            SCHEDULETest(2024, 1, 13, []),
            SCHEDULETest(2024, 1, 14, []),
            SCHEDULETest(2024, 2, 1, []),
            SCHEDULETest(2024, 2, 2, []),
            SCHEDULETest(2024, 2, 3, []),
            SCHEDULETest(2024, 2, 4, []),
            SCHEDULETest(2024, 2, 5, []),
            SCHEDULETest(2024, 2, 6, []),
            SCHEDULETest(2024, 2, 7, []),
        ]
        
        for data in data_array:
            # Arrange
            expected_results = ScheduledObject.objects.filter(pk__in=data.expected_ids)
            mock_get_today.return_value = datetime.date(data.year, data.month, data.day)

            # Act
            results = Command().run_set_day_of_the_week()

            # Assert
            self.assertEqual(
                list(expected_results.values("pk")),
                list(results.values("pk")),
                F"Run set day of the week: Date: {data.year}-{data.month}-{data.day}"
            )

    @mock.patch('NearBeach.management.commands.runscheduler.Command.get_today')
    def test_run_weekly(self, mock_get_today):
        # Data Array for loop
        data_array = [
            SCHEDULETest(2023, 12, 1, []),
            SCHEDULETest(2023, 12, 2, []),
            SCHEDULETest(2023, 12, 3, []),
            SCHEDULETest(2023, 12, 4, []),
            SCHEDULETest(2023, 12, 5, []),
            SCHEDULETest(2023, 12, 6, []),
            SCHEDULETest(2023, 12, 7, []),
            SCHEDULETest(2024, 1, 1, [2]),
            SCHEDULETest(2024, 1, 2, []),
            SCHEDULETest(2024, 1, 3, []),
            SCHEDULETest(2024, 1, 4, []),
            SCHEDULETest(2024, 1, 5, []),
            SCHEDULETest(2024, 1, 6, []),
            SCHEDULETest(2024, 1, 7, []),
            SCHEDULETest(2024, 1, 8, [2]),
            SCHEDULETest(2024, 1, 9, []),
            SCHEDULETest(2024, 1, 10, []),
            SCHEDULETest(2024, 1, 11, []),
            SCHEDULETest(2024, 1, 12, []),
            SCHEDULETest(2024, 1, 13, []),
            SCHEDULETest(2024, 1, 14, []),
            SCHEDULETest(2024, 2, 1, []),
            SCHEDULETest(2024, 2, 2, []),
            SCHEDULETest(2024, 2, 3, []),
            SCHEDULETest(2024, 2, 4, []),
            SCHEDULETest(2024, 2, 5, []),
            SCHEDULETest(2024, 2, 6, []),
            SCHEDULETest(2024, 2, 7, []),
        ]

        for data in data_array:
            # Arrange
            expected_results = ScheduledObject.objects.filter(pk__in=data.expected_ids)
            mock_get_today.return_value = datetime.date(data.year, data.month, data.day)

            # Act
            results = Command().run_weekly()

            # Assert
            self.assertEqual(
                list(expected_results.values("pk")),
                list(results.values("pk")),
                F"Run Weekly: Date: {data.year}-{data.month}-{data.day}. Expected: {data.expected_ids}"
            )
            
            

    @mock.patch('NearBeach.management.commands.runscheduler.Command.get_today')
    def test_run_fortnightly(self, mock_get_today):
        # Data Array for loop
        data_array = [
            SCHEDULETest(2023, 12, 1, []),
            SCHEDULETest(2023, 12, 2, []),
            SCHEDULETest(2023, 12, 3, []),
            SCHEDULETest(2023, 12, 4, []),
            SCHEDULETest(2023, 12, 5, []),
            SCHEDULETest(2023, 12, 6, []),
            SCHEDULETest(2023, 12, 7, []),
            SCHEDULETest(2023, 12, 8, []),
            SCHEDULETest(2023, 12, 9, []),
            SCHEDULETest(2023, 12, 10, []),
            SCHEDULETest(2023, 12, 11, []),
            SCHEDULETest(2023, 12, 12, []),
            SCHEDULETest(2023, 12, 13, []),
            SCHEDULETest(2023, 12, 14, []),
            SCHEDULETest(2023, 12, 15, []),
            SCHEDULETest(2023, 12, 16, []),
            SCHEDULETest(2023, 12, 17, []),
            SCHEDULETest(2023, 12, 18, []),
            SCHEDULETest(2023, 12, 19, []),
            SCHEDULETest(2023, 12, 20, []),
            SCHEDULETest(2023, 12, 21, []),
            SCHEDULETest(2023, 12, 22, []),
            SCHEDULETest(2023, 12, 23, []),
            SCHEDULETest(2023, 12, 24, []),
            SCHEDULETest(2023, 12, 25, []),
            SCHEDULETest(2023, 12, 26, []),
            SCHEDULETest(2023, 12, 27, []),
            SCHEDULETest(2023, 12, 28, []),
            SCHEDULETest(2023, 12, 29, []),
            SCHEDULETest(2023, 12, 30, []),
            SCHEDULETest(2023, 12, 31, []),
            SCHEDULETest(2024, 1, 1, []),
            SCHEDULETest(2024, 1, 2, []),
            SCHEDULETest(2024, 1, 3, []),
            SCHEDULETest(2024, 1, 4, []),
            SCHEDULETest(2024, 1, 5, []),
            SCHEDULETest(2024, 1, 6, [3]),
            SCHEDULETest(2024, 1, 7, []),
            SCHEDULETest(2024, 1, 8, []),
            SCHEDULETest(2024, 1, 9, []),
            SCHEDULETest(2024, 1, 10, []),
            SCHEDULETest(2024, 1, 11, []),
            SCHEDULETest(2024, 1, 12, []),
            SCHEDULETest(2024, 1, 13, []),
            SCHEDULETest(2024, 1, 14, []),
            SCHEDULETest(2024, 1, 15, []),
            SCHEDULETest(2024, 1, 16, []),
            SCHEDULETest(2024, 1, 17, []),
            SCHEDULETest(2024, 1, 18, []),
            SCHEDULETest(2024, 1, 19, []),
            SCHEDULETest(2024, 1, 20, [12]),
            SCHEDULETest(2024, 1, 21, []),
            SCHEDULETest(2024, 1, 22, []),
            SCHEDULETest(2024, 1, 23, []),
            SCHEDULETest(2024, 1, 24, []),
            SCHEDULETest(2024, 1, 25, []),
            SCHEDULETest(2024, 1, 26, []),
            SCHEDULETest(2024, 1, 27, []),
            SCHEDULETest(2024, 1, 28, []),
            SCHEDULETest(2024, 1, 29, []),
            SCHEDULETest(2024, 1, 30, []),
            SCHEDULETest(2024, 1, 31, []),
            SCHEDULETest(2024, 2, 1, []),
            SCHEDULETest(2024, 2, 2, []),
            SCHEDULETest(2024, 2, 3, []),
            SCHEDULETest(2024, 2, 4, []),
            SCHEDULETest(2024, 2, 5, []),
            SCHEDULETest(2024, 2, 6, []),
            SCHEDULETest(2024, 2, 7, []),
            SCHEDULETest(2024, 2, 8, []),
            SCHEDULETest(2024, 2, 9, []),
            SCHEDULETest(2024, 2, 10, []),
            SCHEDULETest(2024, 2, 11, []),
            SCHEDULETest(2024, 2, 12, []),
            SCHEDULETest(2024, 2, 13, []),
            SCHEDULETest(2024, 2, 14, []),
            SCHEDULETest(2024, 2, 15, []),
            SCHEDULETest(2024, 2, 16, []),
            SCHEDULETest(2024, 2, 17, []),
            SCHEDULETest(2024, 2, 18, []),
            SCHEDULETest(2024, 2, 19, []),
            SCHEDULETest(2024, 2, 20, []),
            SCHEDULETest(2024, 2, 21, []),
        ]

        for data in data_array:
            # Arrange
            expected_results = ScheduledObject.objects.filter(pk__in=data.expected_ids)
            mock_get_today.return_value = datetime.date(data.year, data.month, data.day)

            # Act
            results = Command().run_fortnightly()

            # Assert
            self.assertEqual(
                list(expected_results.values("pk")),
                list(results.values("pk")),
                F"Run Fortnightly: Date: {data.year}-{data.month}-{data.day}. Expected: {data.expected_ids}"
            )

    @mock.patch('NearBeach.management.commands.runscheduler.Command.get_today')
    def test_run_monthly(self, mock_get_today):
        # Data Array for loop
        data_array = [
            SCHEDULETest(2023, 12, 1, []),
            SCHEDULETest(2023, 12, 2, []),
            SCHEDULETest(2023, 12, 3, []),
            SCHEDULETest(2023, 12, 4, []),
            SCHEDULETest(2023, 12, 5, []),
            SCHEDULETest(2023, 12, 6, []),
            SCHEDULETest(2023, 12, 7, []),
            SCHEDULETest(2023, 12, 8, []),
            SCHEDULETest(2023, 12, 9, []),
            SCHEDULETest(2023, 12, 10, []),
            SCHEDULETest(2023, 12, 11, []),
            SCHEDULETest(2023, 12, 12, []),
            SCHEDULETest(2023, 12, 13, []),
            SCHEDULETest(2023, 12, 14, []),
            SCHEDULETest(2023, 12, 15, []),
            SCHEDULETest(2023, 12, 16, []),
            SCHEDULETest(2023, 12, 17, []),
            SCHEDULETest(2023, 12, 18, []),
            SCHEDULETest(2023, 12, 19, []),
            SCHEDULETest(2023, 12, 20, []),
            SCHEDULETest(2023, 12, 21, []),
            SCHEDULETest(2023, 12, 22, []),
            SCHEDULETest(2023, 12, 23, []),
            SCHEDULETest(2023, 12, 24, []),
            SCHEDULETest(2023, 12, 25, []),
            SCHEDULETest(2023, 12, 26, []),
            SCHEDULETest(2023, 12, 27, []),
            SCHEDULETest(2023, 12, 28, []),
            SCHEDULETest(2023, 12, 29, []),
            SCHEDULETest(2023, 12, 30, []),
            SCHEDULETest(2023, 12, 31, []),
            SCHEDULETest(2024, 1, 1, []),
            SCHEDULETest(2024, 1, 2, []),
            SCHEDULETest(2024, 1, 3, []),
            SCHEDULETest(2024, 1, 4, []),
            SCHEDULETest(2024, 1, 5, []),
            SCHEDULETest(2024, 1, 6, []),
            SCHEDULETest(2024, 1, 7, []),
            SCHEDULETest(2024, 1, 8, []),
            SCHEDULETest(2024, 1, 9, []),
            SCHEDULETest(2024, 1, 10, []),
            SCHEDULETest(2024, 1, 11, []),
            SCHEDULETest(2024, 1, 12, []),
            SCHEDULETest(2024, 1, 13, []),
            SCHEDULETest(2024, 1, 14, []),
            SCHEDULETest(2024, 1, 15, []),
            SCHEDULETest(2024, 1, 16, []),
            SCHEDULETest(2024, 1, 17, []),
            SCHEDULETest(2024, 1, 18, []),
            SCHEDULETest(2024, 1, 19, []),
            SCHEDULETest(2024, 1, 20, []),
            SCHEDULETest(2024, 1, 21, []),
            SCHEDULETest(2024, 1, 22, [13]),
            SCHEDULETest(2024, 1, 23, []),
            SCHEDULETest(2024, 1, 24, []),
            SCHEDULETest(2024, 1, 25, []),
            SCHEDULETest(2024, 1, 26, []),
            SCHEDULETest(2024, 1, 27, []),
            SCHEDULETest(2024, 1, 28, []),
            SCHEDULETest(2024, 1, 29, []),
            SCHEDULETest(2024, 1, 30, []),
            SCHEDULETest(2024, 1, 31, []),
            SCHEDULETest(2024, 2, 1, []),
            SCHEDULETest(2024, 2, 2, []),
            SCHEDULETest(2024, 2, 3, []),
            SCHEDULETest(2024, 2, 4, []),
            SCHEDULETest(2024, 2, 5, []),
            SCHEDULETest(2024, 2, 6, []),
            SCHEDULETest(2024, 2, 7, []),
            SCHEDULETest(2024, 2, 8, []),
            SCHEDULETest(2024, 2, 9, []),
            SCHEDULETest(2024, 2, 10, []),
            SCHEDULETest(2024, 2, 11, []),
            SCHEDULETest(2024, 2, 12, []),
            SCHEDULETest(2024, 2, 13, []),
            SCHEDULETest(2024, 2, 14, []),
            SCHEDULETest(2024, 2, 15, []),
            SCHEDULETest(2024, 2, 16, []),
            SCHEDULETest(2024, 2, 17, []),
            SCHEDULETest(2024, 2, 18, []),
            SCHEDULETest(2024, 2, 19, []),
            SCHEDULETest(2024, 2, 20, []),
            SCHEDULETest(2024, 2, 21, []),
            SCHEDULETest(2024, 2, 22, [13]),
            SCHEDULETest(2024, 2, 23, []),
            SCHEDULETest(2024, 2, 24, []),
            SCHEDULETest(2024, 2, 25, []),
            SCHEDULETest(2024, 2, 26, []),
            SCHEDULETest(2024, 2, 27, []),
            SCHEDULETest(2024, 2, 28, []),
            SCHEDULETest(2024, 2, 29, []),
            SCHEDULETest(2024, 3, 1, []),
            SCHEDULETest(2024, 3, 2, []),
            SCHEDULETest(2024, 3, 3, []),
            SCHEDULETest(2024, 3, 4, []),
            SCHEDULETest(2024, 3, 5, []),
            SCHEDULETest(2024, 3, 6, []),
            SCHEDULETest(2024, 3, 7, []),
            SCHEDULETest(2024, 3, 8, []),
            SCHEDULETest(2024, 3, 9, []),
            SCHEDULETest(2024, 3, 10, []),
            SCHEDULETest(2024, 3, 11, []),
            SCHEDULETest(2024, 3, 12, []),
            SCHEDULETest(2024, 3, 13, []),
            SCHEDULETest(2024, 3, 14, []),
            SCHEDULETest(2024, 3, 15, []),
            SCHEDULETest(2024, 3, 16, []),
            SCHEDULETest(2024, 3, 17, []),
            SCHEDULETest(2024, 3, 18, []),
            SCHEDULETest(2024, 3, 19, []),
            SCHEDULETest(2024, 3, 20, []),
            SCHEDULETest(2024, 3, 21, []),
            SCHEDULETest(2024, 3, 22, [13]),
            SCHEDULETest(2024, 3, 23, []),
            SCHEDULETest(2024, 3, 24, []),
            SCHEDULETest(2024, 3, 25, []),
            SCHEDULETest(2024, 3, 26, []),
            SCHEDULETest(2024, 3, 27, []),
            SCHEDULETest(2024, 3, 28, []),
            SCHEDULETest(2024, 3, 29, []),
            SCHEDULETest(2024, 3, 30, []),
            SCHEDULETest(2024, 3, 31, []),
            SCHEDULETest(2024, 4, 1, []),
            SCHEDULETest(2024, 4, 2, []),
            SCHEDULETest(2024, 4, 3, []),
            SCHEDULETest(2024, 4, 4, []),
            SCHEDULETest(2024, 4, 5, []),
            SCHEDULETest(2024, 4, 6, []),
            SCHEDULETest(2024, 4, 7, []),
            SCHEDULETest(2024, 4, 8, []),
            SCHEDULETest(2024, 4, 9, []),
            SCHEDULETest(2024, 4, 10, []),
            SCHEDULETest(2024, 4, 11, []),
            SCHEDULETest(2024, 4, 12, []),
            SCHEDULETest(2024, 4, 13, []),
            SCHEDULETest(2024, 4, 14, []),
            SCHEDULETest(2024, 4, 15, []),
            SCHEDULETest(2024, 4, 16, []),
            SCHEDULETest(2024, 4, 17, []),
            SCHEDULETest(2024, 4, 18, []),
            SCHEDULETest(2024, 4, 19, []),
            SCHEDULETest(2024, 4, 20, []),
            SCHEDULETest(2024, 4, 21, []),
            SCHEDULETest(2024, 4, 22, []),
            SCHEDULETest(2024, 4, 23, []),
            SCHEDULETest(2024, 4, 24, []),
            SCHEDULETest(2024, 4, 25, []),
            SCHEDULETest(2024, 4, 26, []),
            SCHEDULETest(2024, 4, 27, []),
            SCHEDULETest(2024, 4, 28, []),
            SCHEDULETest(2024, 4, 29, []),
            SCHEDULETest(2024, 4, 30, []),
        ]

        for data in data_array:
            # Arrange
            expected_results = ScheduledObject.objects.filter(pk__in=data.expected_ids)
            mock_get_today.return_value = datetime.date(data.year, data.month, data.day)

            # Act
            results = Command().run_monthly()

            # Assert
            self.assertEqual(
                list(expected_results.values("pk")),
                list(results.values("pk")),
                F"Run Monthly: Date: {data.year}-{data.month}-{data.day}. Expected: {data.expected_ids}"
            )

    @mock.patch('NearBeach.management.commands.runscheduler.Command.get_today')
    def test_run_start_of_the_month(self, mock_get_today):
        # Data Array for loop
        data_array = [
            SCHEDULETest(2023, 12, 1, []),
            SCHEDULETest(2023, 12, 2, []),
            SCHEDULETest(2023, 12, 3, []),
            SCHEDULETest(2023, 12, 4, []),
            SCHEDULETest(2023, 12, 5, []),
            SCHEDULETest(2023, 12, 6, []),
            SCHEDULETest(2023, 12, 7, []),
            SCHEDULETest(2023, 12, 8, []),
            SCHEDULETest(2023, 12, 9, []),
            SCHEDULETest(2023, 12, 10, []),
            SCHEDULETest(2023, 12, 11, []),
            SCHEDULETest(2023, 12, 12, []),
            SCHEDULETest(2023, 12, 13, []),
            SCHEDULETest(2023, 12, 14, []),
            SCHEDULETest(2023, 12, 15, []),
            SCHEDULETest(2023, 12, 16, []),
            SCHEDULETest(2023, 12, 17, []),
            SCHEDULETest(2023, 12, 18, []),
            SCHEDULETest(2023, 12, 19, []),
            SCHEDULETest(2023, 12, 20, []),
            SCHEDULETest(2023, 12, 21, []),
            SCHEDULETest(2023, 12, 22, []),
            SCHEDULETest(2023, 12, 23, []),
            SCHEDULETest(2023, 12, 24, []),
            SCHEDULETest(2023, 12, 25, []),
            SCHEDULETest(2023, 12, 26, []),
            SCHEDULETest(2023, 12, 27, []),
            SCHEDULETest(2023, 12, 28, []),
            SCHEDULETest(2023, 12, 29, []),
            SCHEDULETest(2023, 12, 30, []),
            SCHEDULETest(2023, 12, 31, []),
            SCHEDULETest(2024, 1, 1, [4]),
            SCHEDULETest(2024, 1, 2, []),
            SCHEDULETest(2024, 1, 3, []),
            SCHEDULETest(2024, 1, 4, []),
            SCHEDULETest(2024, 1, 5, []),
            SCHEDULETest(2024, 1, 6, []),
            SCHEDULETest(2024, 1, 7, []),
            SCHEDULETest(2024, 1, 8, []),
            SCHEDULETest(2024, 1, 9, []),
            SCHEDULETest(2024, 1, 10, []),
            SCHEDULETest(2024, 1, 11, []),
            SCHEDULETest(2024, 1, 12, []),
            SCHEDULETest(2024, 1, 13, []),
            SCHEDULETest(2024, 1, 14, []),
            SCHEDULETest(2024, 1, 15, []),
            SCHEDULETest(2024, 1, 16, []),
            SCHEDULETest(2024, 1, 17, []),
            SCHEDULETest(2024, 1, 18, []),
            SCHEDULETest(2024, 1, 19, []),
            SCHEDULETest(2024, 1, 20, []),
            SCHEDULETest(2024, 1, 21, []),
            SCHEDULETest(2024, 1, 22, []),
            SCHEDULETest(2024, 1, 23, []),
            SCHEDULETest(2024, 1, 24, []),
            SCHEDULETest(2024, 1, 25, []),
            SCHEDULETest(2024, 1, 26, []),
            SCHEDULETest(2024, 1, 27, []),
            SCHEDULETest(2024, 1, 28, []),
            SCHEDULETest(2024, 1, 29, []),
            SCHEDULETest(2024, 1, 30, []),
            SCHEDULETest(2024, 1, 31, []),
            SCHEDULETest(2024, 2, 1, [4]),
            SCHEDULETest(2024, 2, 2, []),
            SCHEDULETest(2024, 2, 3, []),
            SCHEDULETest(2024, 2, 4, []),
            SCHEDULETest(2024, 2, 5, []),
            SCHEDULETest(2024, 2, 6, []),
            SCHEDULETest(2024, 2, 7, []),
            SCHEDULETest(2024, 2, 8, []),
            SCHEDULETest(2024, 2, 9, []),
            SCHEDULETest(2024, 2, 10, []),
            SCHEDULETest(2024, 2, 11, []),
            SCHEDULETest(2024, 2, 12, []),
            SCHEDULETest(2024, 2, 13, []),
            SCHEDULETest(2024, 2, 14, []),
            SCHEDULETest(2024, 2, 15, []),
            SCHEDULETest(2024, 2, 16, []),
            SCHEDULETest(2024, 2, 17, []),
            SCHEDULETest(2024, 2, 18, []),
            SCHEDULETest(2024, 2, 19, []),
            SCHEDULETest(2024, 2, 20, []),
            SCHEDULETest(2024, 2, 21, []),
            SCHEDULETest(2024, 2, 22, []),
            SCHEDULETest(2024, 2, 23, []),
            SCHEDULETest(2024, 2, 24, []),
            SCHEDULETest(2024, 2, 25, []),
            SCHEDULETest(2024, 2, 26, []),
            SCHEDULETest(2024, 2, 27, []),
            SCHEDULETest(2024, 2, 28, []),
            SCHEDULETest(2024, 2, 29, []),
            SCHEDULETest(2024, 3, 1, []),
            SCHEDULETest(2024, 3, 2, []),
            SCHEDULETest(2024, 3, 3, []),
            SCHEDULETest(2024, 3, 4, []),
            SCHEDULETest(2024, 3, 5, []),
            SCHEDULETest(2024, 3, 6, []),
            SCHEDULETest(2024, 3, 7, []),
            SCHEDULETest(2024, 3, 8, []),
            SCHEDULETest(2024, 3, 9, []),
            SCHEDULETest(2024, 3, 10, []),
            SCHEDULETest(2024, 3, 11, []),
            SCHEDULETest(2024, 3, 12, []),
            SCHEDULETest(2024, 3, 13, []),
            SCHEDULETest(2024, 3, 14, []),
            SCHEDULETest(2024, 3, 15, []),
            SCHEDULETest(2024, 3, 16, []),
            SCHEDULETest(2024, 3, 17, []),
            SCHEDULETest(2024, 3, 18, []),
            SCHEDULETest(2024, 3, 19, []),
            SCHEDULETest(2024, 3, 20, []),
            SCHEDULETest(2024, 3, 21, []),
            SCHEDULETest(2024, 3, 22, []),
            SCHEDULETest(2024, 3, 23, []),
            SCHEDULETest(2024, 3, 24, []),
            SCHEDULETest(2024, 3, 25, []),
            SCHEDULETest(2024, 3, 26, []),
            SCHEDULETest(2024, 3, 27, []),
            SCHEDULETest(2024, 3, 28, []),
            SCHEDULETest(2024, 3, 29, []),
            SCHEDULETest(2024, 3, 30, []),
            SCHEDULETest(2024, 3, 31, []),
            SCHEDULETest(2024, 4, 1, []),
            SCHEDULETest(2024, 4, 2, []),
            SCHEDULETest(2024, 4, 3, []),
            SCHEDULETest(2024, 4, 4, []),
            SCHEDULETest(2024, 4, 5, []),
            SCHEDULETest(2024, 4, 6, []),
            SCHEDULETest(2024, 4, 7, []),
            SCHEDULETest(2024, 4, 8, []),
            SCHEDULETest(2024, 4, 9, []),
            SCHEDULETest(2024, 4, 10, []),
            SCHEDULETest(2024, 4, 11, []),
            SCHEDULETest(2024, 4, 12, []),
            SCHEDULETest(2024, 4, 13, []),
            SCHEDULETest(2024, 4, 14, []),
            SCHEDULETest(2024, 4, 15, []),
            SCHEDULETest(2024, 4, 16, []),
            SCHEDULETest(2024, 4, 17, []),
            SCHEDULETest(2024, 4, 18, []),
            SCHEDULETest(2024, 4, 19, []),
            SCHEDULETest(2024, 4, 20, []),
            SCHEDULETest(2024, 4, 21, []),
            SCHEDULETest(2024, 4, 22, []),
            SCHEDULETest(2024, 4, 23, []),
            SCHEDULETest(2024, 4, 24, []),
            SCHEDULETest(2024, 4, 25, []),
            SCHEDULETest(2024, 4, 26, []),
            SCHEDULETest(2024, 4, 27, []),
            SCHEDULETest(2024, 4, 28, []),
            SCHEDULETest(2024, 4, 29, []),
            SCHEDULETest(2024, 4, 30, []),
        ]

        for data in data_array:
            # Arrange
            expected_results = ScheduledObject.objects.filter(pk__in=data.expected_ids)
            mock_get_today.return_value = datetime.date(data.year, data.month, data.day)

            # Act
            results = Command().run_start_of_the_month()

            # Assert
            self.assertEqual(
                list(expected_results.values("pk")),
                list(results.values("pk")),
                F"Run Start of the Month: Date: {data.year}-{data.month}-{data.day}. Expected: {data.expected_ids}"
            )

    @mock.patch('NearBeach.management.commands.runscheduler.Command.get_today')
    def test_run_end_of_the_month(self, mock_get_today):
        # Data Array for loop
        data_array = [
            SCHEDULETest(2023, 12, 1, []),
            SCHEDULETest(2023, 12, 2, []),
            SCHEDULETest(2023, 12, 3, []),
            SCHEDULETest(2023, 12, 4, []),
            SCHEDULETest(2023, 12, 5, []),
            SCHEDULETest(2023, 12, 6, []),
            SCHEDULETest(2023, 12, 7, []),
            SCHEDULETest(2023, 12, 8, []),
            SCHEDULETest(2023, 12, 9, []),
            SCHEDULETest(2023, 12, 10, []),
            SCHEDULETest(2023, 12, 11, []),
            SCHEDULETest(2023, 12, 12, []),
            SCHEDULETest(2023, 12, 13, []),
            SCHEDULETest(2023, 12, 14, []),
            SCHEDULETest(2023, 12, 15, []),
            SCHEDULETest(2023, 12, 16, []),
            SCHEDULETest(2023, 12, 17, []),
            SCHEDULETest(2023, 12, 18, []),
            SCHEDULETest(2023, 12, 19, []),
            SCHEDULETest(2023, 12, 20, []),
            SCHEDULETest(2023, 12, 21, []),
            SCHEDULETest(2023, 12, 22, []),
            SCHEDULETest(2023, 12, 23, []),
            SCHEDULETest(2023, 12, 24, []),
            SCHEDULETest(2023, 12, 25, []),
            SCHEDULETest(2023, 12, 26, []),
            SCHEDULETest(2023, 12, 27, []),
            SCHEDULETest(2023, 12, 28, []),
            SCHEDULETest(2023, 12, 29, []),
            SCHEDULETest(2023, 12, 30, []),
            SCHEDULETest(2023, 12, 31, []),
            SCHEDULETest(2024, 1, 1, []),
            SCHEDULETest(2024, 1, 2, []),
            SCHEDULETest(2024, 1, 3, []),
            SCHEDULETest(2024, 1, 4, []),
            SCHEDULETest(2024, 1, 5, []),
            SCHEDULETest(2024, 1, 6, []),
            SCHEDULETest(2024, 1, 7, []),
            SCHEDULETest(2024, 1, 8, []),
            SCHEDULETest(2024, 1, 9, []),
            SCHEDULETest(2024, 1, 10, []),
            SCHEDULETest(2024, 1, 11, []),
            SCHEDULETest(2024, 1, 12, []),
            SCHEDULETest(2024, 1, 13, []),
            SCHEDULETest(2024, 1, 14, []),
            SCHEDULETest(2024, 1, 15, []),
            SCHEDULETest(2024, 1, 16, []),
            SCHEDULETest(2024, 1, 17, []),
            SCHEDULETest(2024, 1, 18, []),
            SCHEDULETest(2024, 1, 19, []),
            SCHEDULETest(2024, 1, 20, []),
            SCHEDULETest(2024, 1, 21, []),
            SCHEDULETest(2024, 1, 22, []),
            SCHEDULETest(2024, 1, 23, []),
            SCHEDULETest(2024, 1, 24, []),
            SCHEDULETest(2024, 1, 25, []),
            SCHEDULETest(2024, 1, 26, []),
            SCHEDULETest(2024, 1, 27, []),
            SCHEDULETest(2024, 1, 28, []),
            SCHEDULETest(2024, 1, 29, []),
            SCHEDULETest(2024, 1, 30, []),
            SCHEDULETest(2024, 1, 31, [5]),
            SCHEDULETest(2024, 2, 1, []),
            SCHEDULETest(2024, 2, 2, []),
            SCHEDULETest(2024, 2, 3, []),
            SCHEDULETest(2024, 2, 4, []),
            SCHEDULETest(2024, 2, 5, []),
            SCHEDULETest(2024, 2, 6, []),
            SCHEDULETest(2024, 2, 7, []),
            SCHEDULETest(2024, 2, 8, []),
            SCHEDULETest(2024, 2, 9, []),
            SCHEDULETest(2024, 2, 10, []),
            SCHEDULETest(2024, 2, 11, []),
            SCHEDULETest(2024, 2, 12, []),
            SCHEDULETest(2024, 2, 13, []),
            SCHEDULETest(2024, 2, 14, []),
            SCHEDULETest(2024, 2, 15, []),
            SCHEDULETest(2024, 2, 16, []),
            SCHEDULETest(2024, 2, 17, []),
            SCHEDULETest(2024, 2, 18, []),
            SCHEDULETest(2024, 2, 19, []),
            SCHEDULETest(2024, 2, 20, []),
            SCHEDULETest(2024, 2, 21, []),
            SCHEDULETest(2024, 2, 22, []),
            SCHEDULETest(2024, 2, 23, []),
            SCHEDULETest(2024, 2, 24, []),
            SCHEDULETest(2024, 2, 25, []),
            SCHEDULETest(2024, 2, 26, []),
            SCHEDULETest(2024, 2, 27, []),
            SCHEDULETest(2024, 2, 28, []),
            SCHEDULETest(2024, 2, 29, [5]),
            SCHEDULETest(2024, 3, 1, []),
            SCHEDULETest(2024, 3, 2, []),
            SCHEDULETest(2024, 3, 3, []),
            SCHEDULETest(2024, 3, 4, []),
            SCHEDULETest(2024, 3, 5, []),
            SCHEDULETest(2024, 3, 6, []),
            SCHEDULETest(2024, 3, 7, []),
            SCHEDULETest(2024, 3, 8, []),
            SCHEDULETest(2024, 3, 9, []),
            SCHEDULETest(2024, 3, 10, []),
            SCHEDULETest(2024, 3, 11, []),
            SCHEDULETest(2024, 3, 12, []),
            SCHEDULETest(2024, 3, 13, []),
            SCHEDULETest(2024, 3, 14, []),
            SCHEDULETest(2024, 3, 15, []),
            SCHEDULETest(2024, 3, 16, []),
            SCHEDULETest(2024, 3, 17, []),
            SCHEDULETest(2024, 3, 18, []),
            SCHEDULETest(2024, 3, 19, []),
            SCHEDULETest(2024, 3, 20, []),
            SCHEDULETest(2024, 3, 21, []),
            SCHEDULETest(2024, 3, 22, []),
            SCHEDULETest(2024, 3, 23, []),
            SCHEDULETest(2024, 3, 24, []),
            SCHEDULETest(2024, 3, 25, []),
            SCHEDULETest(2024, 3, 26, []),
            SCHEDULETest(2024, 3, 27, []),
            SCHEDULETest(2024, 3, 28, []),
            SCHEDULETest(2024, 3, 29, []),
            SCHEDULETest(2024, 3, 30, []),
            SCHEDULETest(2024, 3, 31, []),
            SCHEDULETest(2024, 4, 1, []),
            SCHEDULETest(2024, 4, 2, []),
            SCHEDULETest(2024, 4, 3, []),
            SCHEDULETest(2024, 4, 4, []),
            SCHEDULETest(2024, 4, 5, []),
            SCHEDULETest(2024, 4, 6, []),
            SCHEDULETest(2024, 4, 7, []),
            SCHEDULETest(2024, 4, 8, []),
            SCHEDULETest(2024, 4, 9, []),
            SCHEDULETest(2024, 4, 10, []),
            SCHEDULETest(2024, 4, 11, []),
            SCHEDULETest(2024, 4, 12, []),
            SCHEDULETest(2024, 4, 13, []),
            SCHEDULETest(2024, 4, 14, []),
            SCHEDULETest(2024, 4, 15, []),
            SCHEDULETest(2024, 4, 16, []),
            SCHEDULETest(2024, 4, 17, []),
            SCHEDULETest(2024, 4, 18, []),
            SCHEDULETest(2024, 4, 19, []),
            SCHEDULETest(2024, 4, 20, []),
            SCHEDULETest(2024, 4, 21, []),
            SCHEDULETest(2024, 4, 22, []),
            SCHEDULETest(2024, 4, 23, []),
            SCHEDULETest(2024, 4, 24, []),
            SCHEDULETest(2024, 4, 25, []),
            SCHEDULETest(2024, 4, 26, []),
            SCHEDULETest(2024, 4, 27, []),
            SCHEDULETest(2024, 4, 28, []),
            SCHEDULETest(2024, 4, 29, []),
            SCHEDULETest(2024, 4, 30, []),
        ]

        for data in data_array:
            # Arrange
            expected_results = ScheduledObject.objects.filter(pk__in=data.expected_ids)
            mock_get_today.return_value = datetime.date(data.year, data.month, data.day)

            # Act
            results = Command().run_end_of_the_month()

            # Assert
            self.assertEqual(
                list(expected_results.values("pk")),
                list(results.values("pk")),
                F"Run End of the Month: Date: {data.year}-{data.month}-{data.day}. Expected: {data.expected_ids}"
            )


    @mock.patch('NearBeach.management.commands.runscheduler.Command.get_today')
    def test_x_days_before_end_of_the_month(self, mock_get_today):
        # Data Array for loop
        data_array = [
            SCHEDULETest(2023, 12, 1, []),
            SCHEDULETest(2023, 12, 2, []),
            SCHEDULETest(2023, 12, 3, []),
            SCHEDULETest(2023, 12, 4, []),
            SCHEDULETest(2023, 12, 5, []),
            SCHEDULETest(2023, 12, 6, []),
            SCHEDULETest(2023, 12, 7, []),
            SCHEDULETest(2023, 12, 8, []),
            SCHEDULETest(2023, 12, 9, []),
            SCHEDULETest(2023, 12, 10, []),
            SCHEDULETest(2023, 12, 11, []),
            SCHEDULETest(2023, 12, 12, []),
            SCHEDULETest(2023, 12, 13, []),
            SCHEDULETest(2023, 12, 14, []),
            SCHEDULETest(2023, 12, 15, []),
            SCHEDULETest(2023, 12, 16, []),
            SCHEDULETest(2023, 12, 17, []),
            SCHEDULETest(2023, 12, 18, []),
            SCHEDULETest(2023, 12, 19, []),
            SCHEDULETest(2023, 12, 20, []),
            SCHEDULETest(2023, 12, 21, []),
            SCHEDULETest(2023, 12, 22, []),
            SCHEDULETest(2023, 12, 23, []),
            SCHEDULETest(2023, 12, 24, []),
            SCHEDULETest(2023, 12, 25, []),
            SCHEDULETest(2023, 12, 26, []),
            SCHEDULETest(2023, 12, 27, []),
            SCHEDULETest(2023, 12, 28, []),
            SCHEDULETest(2023, 12, 29, []),
            SCHEDULETest(2023, 12, 30, []),
            SCHEDULETest(2023, 12, 31, []),
            SCHEDULETest(2024, 1, 1, []),
            SCHEDULETest(2024, 1, 2, []),
            SCHEDULETest(2024, 1, 3, []),
            SCHEDULETest(2024, 1, 4, []),
            SCHEDULETest(2024, 1, 5, []),
            SCHEDULETest(2024, 1, 6, []),
            SCHEDULETest(2024, 1, 7, []),
            SCHEDULETest(2024, 1, 8, []),
            SCHEDULETest(2024, 1, 9, []),
            SCHEDULETest(2024, 1, 10, []),
            SCHEDULETest(2024, 1, 11, []),
            SCHEDULETest(2024, 1, 12, []),
            SCHEDULETest(2024, 1, 13, []),
            SCHEDULETest(2024, 1, 14, []),
            SCHEDULETest(2024, 1, 15, []),
            SCHEDULETest(2024, 1, 16, []),
            SCHEDULETest(2024, 1, 17, []),
            SCHEDULETest(2024, 1, 18, []),
            SCHEDULETest(2024, 1, 19, []),
            SCHEDULETest(2024, 1, 20, []),
            SCHEDULETest(2024, 1, 21, []),
            SCHEDULETest(2024, 1, 22, []),
            SCHEDULETest(2024, 1, 23, []),
            SCHEDULETest(2024, 1, 24, []),
            SCHEDULETest(2024, 1, 25, []),
            SCHEDULETest(2024, 1, 26, [6]),
            SCHEDULETest(2024, 1, 27, []),
            SCHEDULETest(2024, 1, 28, []),
            SCHEDULETest(2024, 1, 29, []),
            SCHEDULETest(2024, 1, 30, []),
            SCHEDULETest(2024, 1, 31, []),
            SCHEDULETest(2024, 2, 1, []),
            SCHEDULETest(2024, 2, 2, []),
            SCHEDULETest(2024, 2, 3, []),
            SCHEDULETest(2024, 2, 4, []),
            SCHEDULETest(2024, 2, 5, []),
            SCHEDULETest(2024, 2, 6, []),
            SCHEDULETest(2024, 2, 7, []),
            SCHEDULETest(2024, 2, 8, []),
            SCHEDULETest(2024, 2, 9, []),
            SCHEDULETest(2024, 2, 10, []),
            SCHEDULETest(2024, 2, 11, []),
            SCHEDULETest(2024, 2, 12, []),
            SCHEDULETest(2024, 2, 13, []),
            SCHEDULETest(2024, 2, 14, []),
            SCHEDULETest(2024, 2, 15, []),
            SCHEDULETest(2024, 2, 16, []),
            SCHEDULETest(2024, 2, 17, []),
            SCHEDULETest(2024, 2, 18, []),
            SCHEDULETest(2024, 2, 19, []),
            SCHEDULETest(2024, 2, 20, []),
            SCHEDULETest(2024, 2, 21, []),
            SCHEDULETest(2024, 2, 22, []),
            SCHEDULETest(2024, 2, 23, []),
            SCHEDULETest(2024, 2, 24, [6]),
            SCHEDULETest(2024, 2, 25, []),
            SCHEDULETest(2024, 2, 26, []),
            SCHEDULETest(2024, 2, 27, []),
            SCHEDULETest(2024, 2, 28, []),
            SCHEDULETest(2024, 2, 29, []),
            SCHEDULETest(2024, 3, 1, []),
            SCHEDULETest(2024, 3, 2, []),
            SCHEDULETest(2024, 3, 3, []),
            SCHEDULETest(2024, 3, 4, []),
            SCHEDULETest(2024, 3, 5, []),
            SCHEDULETest(2024, 3, 6, []),
            SCHEDULETest(2024, 3, 7, []),
            SCHEDULETest(2024, 3, 8, []),
            SCHEDULETest(2024, 3, 9, []),
            SCHEDULETest(2024, 3, 10, []),
            SCHEDULETest(2024, 3, 11, []),
            SCHEDULETest(2024, 3, 12, []),
            SCHEDULETest(2024, 3, 13, []),
            SCHEDULETest(2024, 3, 14, []),
            SCHEDULETest(2024, 3, 15, []),
            SCHEDULETest(2024, 3, 16, []),
            SCHEDULETest(2024, 3, 17, []),
            SCHEDULETest(2024, 3, 18, []),
            SCHEDULETest(2024, 3, 19, []),
            SCHEDULETest(2024, 3, 20, []),
            SCHEDULETest(2024, 3, 21, []),
            SCHEDULETest(2024, 3, 22, []),
            SCHEDULETest(2024, 3, 23, []),
            SCHEDULETest(2024, 3, 24, []),
            SCHEDULETest(2024, 3, 25, []),
            SCHEDULETest(2024, 3, 26, [6]),
            SCHEDULETest(2024, 3, 27, []),
            SCHEDULETest(2024, 3, 28, []),
            SCHEDULETest(2024, 3, 29, []),
            SCHEDULETest(2024, 3, 30, []),
            SCHEDULETest(2024, 3, 31, []),
            SCHEDULETest(2024, 4, 1, []),
            SCHEDULETest(2024, 4, 2, []),
            SCHEDULETest(2024, 4, 3, []),
            SCHEDULETest(2024, 4, 4, []),
            SCHEDULETest(2024, 4, 5, []),
            SCHEDULETest(2024, 4, 6, []),
            SCHEDULETest(2024, 4, 7, []),
            SCHEDULETest(2024, 4, 8, []),
            SCHEDULETest(2024, 4, 9, []),
            SCHEDULETest(2024, 4, 10, []),
            SCHEDULETest(2024, 4, 11, []),
            SCHEDULETest(2024, 4, 12, []),
            SCHEDULETest(2024, 4, 13, []),
            SCHEDULETest(2024, 4, 14, []),
            SCHEDULETest(2024, 4, 15, []),
            SCHEDULETest(2024, 4, 16, []),
            SCHEDULETest(2024, 4, 17, []),
            SCHEDULETest(2024, 4, 18, []),
            SCHEDULETest(2024, 4, 19, []),
            SCHEDULETest(2024, 4, 20, []),
            SCHEDULETest(2024, 4, 21, []),
            SCHEDULETest(2024, 4, 22, []),
            SCHEDULETest(2024, 4, 23, []),
            SCHEDULETest(2024, 4, 24, []),
            SCHEDULETest(2024, 4, 25, []),
            SCHEDULETest(2024, 4, 26, []),
            SCHEDULETest(2024, 4, 27, []),
            SCHEDULETest(2024, 4, 28, []),
            SCHEDULETest(2024, 4, 29, []),
            SCHEDULETest(2024, 4, 30, []),
        ]

        for data in data_array:
            # Arrange
            expected_results = ScheduledObject.objects.filter(pk__in=data.expected_ids)
            mock_get_today.return_value = datetime.date(data.year, data.month, data.day)

            # Act
            results = Command().run_x_days_before_end_of_the_month()

            # Assert
            self.assertEqual(
                list(expected_results.values("pk")),
                list(results.values("pk")),
                F"Run End of the Month: Date: {data.year}-{data.month}-{data.day}. Expected: {data.expected_ids}"
            )

