from django.contrib.auth import views as auth_views
from django.urls import path, include

from .views import (
    admin_views,
    change_task_views,
    card_views,
    customer_views,
    dashboard_views,
    diagnostic_views,
    document_views,
    gdpr_wizard_views,
    error_views,
    gantt_chart_views,
    group_views,
    kanban_column_views,
    kanban_level_views,
    kanban_views,
    note_views,
    notification_views,
    object_data_views,
    object_scheduler_views,
    organisation_views,
    permission_set_views,
    profile_views,
    project_views,
    public_views,
    request_for_change_views,
    requirement_item_views,
    requirement_views,
    search_views,
    sprint_views,
    tag_views,
    task_views,
    user_job_views,
    user_setting_views,
    user_views, object_status_editor_views,
)
from .views.authentication import (
    authentication_views,
)
from .views.authentication.login_view import TwoFactorLoginView
from .urls_two_factor import urlpatterns as tf_urls

# The following two imports are for the static files
# 404 and 500 pages

urlpatterns = [
    path("", dashboard_views.dashboard, name="dashboard"),
    path('', include(tf_urls)),
    # Administration
    path("admin_add_user/", admin_views.add_user, name="admin_add_user"),
    path(
        "admin_update_user_password/",
        admin_views.update_user_password,
        name="update_user_password",
    ),
    # Card Information
    path(
        "card_information/<int:card_id>/",
        card_views.card_information,
        name="card_information",
    ),
    # Change Task
    path(
        "change_task_information/<int:change_task_id>/",
        change_task_views.change_task_information,
        name="change_task_information",
    ),
    path(
        "change_task_information/<int:change_task_id>/delete/",
        change_task_views.change_task_delete,
        name="change_task_delete",
    ),
    path(
        "change_task_information/<int:change_task_id>/get_change_task_list/",
        change_task_views.get_change_task_list,
        name="change_task_get_change_task_list",
    ),
    path(
        "change_task_information/<int:change_task_id>/save/",
        change_task_views.change_task_save,
        name="change_task_save",
    ),
    path(
        "change_task_information/<int:change_task_id>/update/description/",
        change_task_views.update_description,
        name="change_task_update_description",
    ),
    path(
        "change_task_information/<int:change_task_id>/update/is_downtime/",
        change_task_views.update_is_downtime,
        name="change_task_update_is_downtime",
    ),
    path(
        "change_task_information/<int:change_task_id>/update/required_by/",
        change_task_views.update_required_by,
        name="change_task_update_required_by",
    ),
    path(
        "change_task_update_status/<int:change_task_id>/",
        change_task_views.update_status,
        name="change_task_update_status",
    ),
    # Customer
    path(
        "customer_information/<int:customer_id>/",
        customer_views.customer_information,
        name="customer_information",
    ),
    path(
        "customer_information/<int:customer_id>/delete/",
        customer_views.customer_information_delete,
        name="customer_information_delete",
    ),
    path(
        "customer_information/<int:customer_id>/get_profile_picture/",
        customer_views.get_profile_picture,
        name="customer_get_profile_image",
    ),
    path(
        "customer_information/<int:customer_id>/update_profile/",
        customer_views.customer_update_profile,
        name="customer_update_profile",
    ),
    path(
        "customer_information/<int:customer_id>/save/",
        customer_views.customer_information_save,
        name="customer_information_save",
    ),
    # Dashboard
    path("dashboard/get/bug_list/", dashboard_views.get_bug_list, name="get_bug_list"),
    path(
        "dashboard/get/kanban_list/",
        dashboard_views.get_kanban_list,
        name="get_kanban_list",
    ),
    path(
        "dashboard/get/my_objects/",
        dashboard_views.get_my_objects,
        name="get_my_objects",
    ),
    path(
        "dashboard/get/rfc_approvals/",
        dashboard_views.rfc_approvals,
        name="rfc_approvals",
    ),
    path(
        "dashboard/get/todo_today/",
        dashboard_views.get_todo_today,
        name="get_todo_today",
    ),
    path(
        "dashboard/get/unassigned_objects/",
        dashboard_views.get_unassigned_objects,
        name="get_unassigned_objects",
    ),
    path(
        "dashboard/get/users_with_no_groups/",
        dashboard_views.users_with_no_groups,
        name="users_with_no_groups",
    ),
    # Diagnostic Page
    path(
        "diagnostic_information/",
        diagnostic_views.diagnostic_information,
        name="diagnostic_information",
    ),
    path(
        "diagnostic_information/email_test/",
        diagnostic_views.diagnostic_email_test,
        name="diagnostic_information_email_test",
    ),
    path(
        "diagnostic_information/upload_test/",
        diagnostic_views.diagnostic_upload_test,
        name="diagnostic_information_upload_test",
    ),
    # Documentation
    path(
        "documentation/<destination>/<location_id>/add_folder/",
        document_views.document_add_folder,
        name="document_add_folder",
    ),
    path(
        "documentation/<destination>/<location_id>/add_link/",
        document_views.document_add_link,
        name="document_add_link",
    ),
    path(
        "documentation/<destination>/<location_id>/list/files/",
        document_views.document_list_files,
        name="document_list_files",
    ),
    path(
        "documentation/<destination>/<location_id>/list/folders/",
        document_views.document_list_folders,
        name="document_list_folders",
    ),
    path(
        "documentation/<destination>/<location_id>/remove/",
        document_views.document_remove,
        name="document_remove",
    ),
    path(
        "documentation/<destination>/<location_id>/remove_folder/",
        document_views.document_remove_folder,
        name="document_remove_folder",
    ),
    path(
        "documentation/<destination>/<location_id>/update_document/",
        document_views.document_update_document,
        name="document_update_document",
    ),
    path(
        "documentation/<destination>/<location_id>/update_folder/",
        document_views.document_update_folder,
        name="document_update_folder",
    ),
    path(
        "documentation/<destination>/<location_id>/upload/",
        document_views.document_upload,
        name="document_upload",
    ),
    path(
        "documentation/get/max_upload/",
        document_views.get_max_upload,
        name="document_get_max_upload",
    ),
    path(
        "documentation/new_object_upload/",
        document_views.new_object_upload,
        name="document_new_object_upload",
    ),
    # Gantt
    path(
        "gantt_data/<destination>/<int:location_id>/update_data/",
        gantt_chart_views.gantt_data_update_data,
        name="gantt_chart_update_data",
    ),
    # GDPR Wizard
    path(
        "gdpr_wizard/",
        gdpr_wizard_views.gdpr_wizard,
        name="gdpr_wizard",
    ),
    path(
        "gdpr_wizard/get_data/",
        gdpr_wizard_views.gdpr_get_data,
        name="gdpr_get_data",
    ),
    path(
        "gdpr_wizard/search_data/",
        gdpr_wizard_views.gdpr_search_data,
        name="gdpr_search_data",
    ),
    path(
        "gdpr_wizard/success/",
        gdpr_wizard_views.gdpr_wizard_success,
        name="gdpr_wizard_success",
    ),
    path(
        "gdpr_wizard/submit/",
        gdpr_wizard_views.gdpr_submit,
        name="gdpr_submit",
    ),
    # Groups
    path(
        "group_information/<int:group_id>/",
        group_views.group_information,
        name="group_information",
    ),
    path(
        "group_information/<int:group_id>/delete/",
        group_views.group_information_delete,
        name="group_information_delete",
    ),
    path(
        "group_information/<int:group_id>/save/",
        group_views.group_information_save,
        name="group_information_save",
    ),
    path(
        "group_information/check_group_name/",
        group_views.check_group_name,
        name="check_group_name",
    ),
    # Kanban Columns
    path(
        "kanban_column/<int:kanban_column_id>/edit/",
        kanban_column_views.edit_column,
        name="kanban_edit_column",
    ),
    path(
        "kanban_column/<int:kanban_board_id>/delete/",
        kanban_column_views.delete_column,
        name="kanban_delete_column",
    ),
    path(
        "kanban_column/<int:kanban_board_id>/new/",
        kanban_column_views.new_column,
        name="kanban_new_column",
    ),
    path(
        "kanban_column/<int:kanban_board_id>/resort/",
        kanban_column_views.resort_column,
        name="kanban_resort_column",
    ),
    # Kanban Levels
    path(
        "kanban_level/<int:kanban_level_id>/edit/",
        kanban_level_views.edit_level,
        name="kanban_edit_level",
    ),
    path(
        "kanban_level/<int:kanban_board_id>/delete/",
        kanban_level_views.delete_level,
        name="kanban_delete_level",
    ),
    path(
        "kanban_level/<int:kanban_board_id>/new/",
        kanban_level_views.new_level,
        name="kanban_new_level",
    ),
    path(
        "kanban_level/<int:kanban_board_id>/resort/",
        kanban_level_views.resort_level,
        name="kanban_resort_level",
    ),
    # Kanban
    path(
        "kanban_information/archive_kanban_cards/",
        kanban_views.archive_kanban_cards,
        name="archive_kanban_cards",
    ),
    path(
        "kanban_information/fix_card_ordering/",
        kanban_views.fix_card_ordering,
        name="fix_card_ordering",
    ),
    path(
        "kanban_information/<int:kanban_board_id>/",
        kanban_views.kanban_information,
        name="kanban_information",
    ),
    path(
        "kanban_information/<int:kanban_board_id>/card/<int:open_card_on_load>/",
        kanban_views.kanban_information,
        name="kanban_information",
    ),
    path(
        "kanban_information/<int:kanban_board_id>/close_board/",
        kanban_views.kanban_close_board,
        name="kanban_close_board",
    ),
    path(
        "kanban_information/<int:kanban_board_id>/edit_board/",
        kanban_views.kanban_edit_board,
        name="kanban_edit_board",
    ),
    path(
        "kanban_information/<int:kanban_board_id>/reopen_board/",
        kanban_views.kanban_reopen_board,
        name="kanban_reopen_board",
    ),
    path(
        "kanban_information/<int:kanban_board_id>/<object_lookup>/add_link/",
        kanban_views.add_kanban_link,
        name="add_kanban_link",
    ),
    path(
        "kanban_information/<int:kanban_board_id>/link_list/",
        kanban_views.kanban_link_list,
        name="kanban_link_list",
    ),
    path(
        "kanban_information/<int:kanban_board_id>/new_card/",
        kanban_views.new_kanban_card,
        name="new_kanban_card",
    ),
    path(
        "kanban_information/<int:kanban_card_id>/move_card/",
        kanban_views.move_kanban_card,
        name="move_kanban_card",
    ),
    path(
        "kanban_information/check_kanban_board_name/",
        kanban_views.check_kanban_board_name,
        name="check_kanban_board_name",
    ),
    path(
        "kanban_information/update_card/",
        kanban_views.update_card,
        name="kanban_update_card",
    ),
    path("login", TwoFactorLoginView.as_view(), name="login"),
    path("logout", authentication_views.logout, name="logout"),
    # My Planner
    path(
        "my_planner",
        user_job_views.my_planner,
        name="my_planner",
    ),
    path(
        "my_planner/add_object/",
        user_job_views.my_planner_add_object,
        name="my_planner_add_object",
    ),
    path(
        "my_planner/delete_user_job/",
        user_job_views.my_planner_delete_user_job,
        name="my_planner_delete_user_job",
    ),
    path(
        "my_planner/get_object_list/",
        user_job_views.my_planner_get_object_list,
        name="my_planner_get_object_list",
    ),
    path(
        "my_planner/update_object_list/",
        user_job_views.my_planner_update_object_list,
        name="my_planner_update_object_list",
    ),
    # Object Status
    path(
        "object_status_information/<destination>/",
        object_status_editor_views.object_status_information,
        name="object_status_information",
    ),
    path(
        "object_status_information/<destination>/create/",
        object_status_editor_views.object_status_create,
        name="object_status_create",
    ),
    path(
        "object_status_information/<destination>/delete/",
        object_status_editor_views.object_status_delete,
        name="object_status_delete",
    ),
    path(
        "object_status_information/<destination>/reorder/",
        object_status_editor_views.object_status_reorder,
        name="object_status_reorder",
    ),
    path(
        "object_status_information/<destination>/update/",
        object_status_editor_views.object_status_update,
        name="object_status_update",
    ),
    path(
        "object_status_list/",
        object_status_editor_views.object_status_list,
        name="object_status_list"
    ),
    # Permission Sets
    path(
        "permission_set_information/<int:permission_set_id>/",
        permission_set_views.permission_set_information,
        name="permission_set_information",
    ),
    path(
        "permission_set_information/<int:permission_set_id>/delete/",
        permission_set_views.permission_set_information_delete,
        name="permission_set_information_delete",
    ),
    path(
        "permission_set_information/<int:permission_set_id>/save/",
        permission_set_views.permission_set_information_save,
        name="permission_set_information_save",
    ),
    path(
        "permission_set_information/check_permission_set_name/",
        permission_set_views.check_permission_set_name,
        name="check_permission_set_name",
    ),
    # Private files
    path(
        "private/<uuid:document_key>/",
        document_views.private_download_file,
        name="private_download_file",
    ),
    # Profiles
    path(
        "profile_information/",
        profile_views.profile_information,
        name="profile_information",
    ),
    path(
        "profile_information/get_profile_picture/",
        profile_views.get_profile_picture,
        name="get_profile_picture",
    ),
    path(
        "profile_information/update_data/",
        profile_views.update_data,
        name="profile_update_data",
    ),
    path(
        "profile_information/update_profile/",
        profile_views.update_profile,
        name="profile_update_profile",
    ),
    # New Objects
    path("new_customer/", customer_views.new_customer, name="new_customer"),
    path(
        "new_customer/save/", customer_views.new_customer_save, name="new_customer_save"
    ),
    path("new_group/", group_views.new_group, name="new_group"),
    path("new_group/save/", group_views.new_group_save, name="new_group_save"),
    path("new_kanban/", kanban_views.new_kanban, name="new_kanban"),
    path("new_kanban_save/", kanban_views.new_kanban_save, name="new_kanban_save"),
    path("new_notification/", notification_views.new_notification, name="new_notification"),
    path("new_notification_save/", notification_views.new_notification_save, name="new_notification_save"),
    path(
        "new_organisation/",
        organisation_views.new_organisation,
        name="new_organisation",
    ),
    path(
        "new_organisation/save/",
        organisation_views.new_organisation_save,
        name="new_organisation_save",
    ),
    path(
        "new_permission_set/",
        permission_set_views.new_permission_set,
        name="new_permission_set",
    ),
    path(
        "new_permission_set/save/",
        permission_set_views.new_permission_set_save,
        name="new_permission_set_save",
    ),
    path("new_project/", project_views.new_project, name="new_project"),
    path("new_project/save/", project_views.new_project_save, name="new_project_save"),
    path(
        "new_request_for_change/",
        request_for_change_views.new_request_for_change,
        name="new_request_for_change",
    ),
    path(
        "new_request_for_change/save/",
        request_for_change_views.new_request_for_change_save,
        name="new_request_for_change_save",
    ),
    path("new_requirement/", requirement_views.new_requirement, name="new_requirement"),
    path(
        "new_requirement/save/",
        requirement_views.new_requirement_save,
        name="new_requirement_save",
    ),
    path(
        "new_requirement_item/save/<int:requirement_id>/",
        requirement_item_views.new_requirement_item,
        name="new_requirement_item_save",
    ),
    path(
        "new_scheduled_object/",
        object_scheduler_views.new_scheduled_object,
        name="new_scheduled_object"
    ),
    path(
        "new_scheduled_object/save/",
        object_scheduler_views.new_scheduled_object_save,
        name="new_scheduled_object_save",
    ),
    path(
        "new_sprint/<destination>/<int:location_id>/save/",
        sprint_views.new_sprint,
        name="new_sprint"
    ),
    path("new_task/", task_views.new_task, name="new_task"),
    path("new_task/save/", task_views.new_task_save, name="new_task_save"),
    path("new_user/", user_views.new_user, name="new_user"),
    path("new_user/save/", user_views.new_user_save, name="new_user_save"),
    path("note/delete/<int:object_note_id>/", note_views.delete_note, name="delete_note"),
    path("note/delete/<int:object_note_id>/", note_views.delete_note, name="delete_note"),
    path(
        "note/organisation/delete/<int:object_note_id>/",
        note_views.organisation_delete_note,
        name="organisation_delete_note"
    ),
    path(
        "note/organisation/update/<int:object_note_id>/",
        note_views.organisation_update_note,
        name="organisation_update_note"
    ),
    path("note/update/<int:object_note_id>/", note_views.update_note, name="update_note"),
    path(
        "notification_information/delete/",
        notification_views.notification_information_delete,
        name="notification_delete",
    ),
    path(
        "notification_information/<notification_id>/",
        notification_views.notification_information,
        name="notification_information"
    ),
    path(
        "notification_information/<notification_id>/save/",
        notification_views.notification_information_save,
        name="notification_information_save"
    ),
    # Object Data
    path(
        "object_data/admin_add_user/",
        object_data_views.admin_add_user,
        name="object_admin_add_user",
    ),
    path(
        "object_data/<destination>/<location_id>/add_bug/",
        object_data_views.add_bug,
        name="add_bug",
    ),
    path(
        "object_data/<destination>/<location_id>/add_customer/",
        object_data_views.add_customer,
        name="add_customer",
    ),
    path(
        "object_data/<destination>/<location_id>/add_group/",
        object_data_views.add_group,
        name="add_group",
    ),
    path(
        "object_data/<destination>/<location_id>/add_link/",
        object_data_views.add_link,
        name="add_link",
    ),
    path(
        "object_data/<destination>/<location_id>/add_notes/",
        note_views.add_notes,
        name="add_notes",
    ),
    path(
        "object_data/<destination>/<organisation_id>/organisation_add_notes/",
        note_views.organisation_add_notes,
        name="organisation_add_notes",
    ),
    path(
        "object_data/<destination>/<location_id>/add_object_to_sprint/",
        sprint_views.add_object_to_sprint,
        name="add_object_to_sprint",
    ),
    path(
        "object_data/<destination>/<location_id>/add_sprint/<sprint_id>/",
        sprint_views.add_sprint_to_object,
        name="add_sprint_to_object",
    ),
    path(
        "object_data/<destination>/<location_id>/add_tags/",
        object_data_views.add_tags,
        name="add_tags",
    ),
    path(
        "object_data/<destination>/<location_id>/add_user/",
        object_data_views.add_user,
        name="add_user",
    ),
    path(
        "object_data/<destination>/<location_id>/associated_objects/",
        object_data_views.associated_objects,
        name="associated_objects",
    ),
    path(
        "object_data/<destination>/<location_id>/delete/",
        object_data_views.object_delete,
        name="object_delete",
    ),
    path(
        "object_data/<destination>/<location_id>/remove_object_from_sprint/",
        sprint_views.remove_object_from_sprint,
        name="remove_object_from_sprint",
    ),
    path(
        "object_data/bug_client_list/",
        object_data_views.bug_client_list,
        name="bug_client_list",
    ),
    path(
        "object_data/<destination>/<location_id>/bug_list/",
        object_data_views.bug_list,
        name="bug_list",
    ),
    path(
        "object_data/<destination>/<location_id>/customer_list/",
        object_data_views.customer_list,
        name="customer_list",
    ),
    path(
        "object_data/<destination>/<location_id>/customer_list_all/",
        object_data_views.customer_list_all,
        name="customer_list_all",
    ),
    path(
        "object_data/<destination>/<location_id>/group_and_user_data/",
        object_data_views.group_and_user_data,
        name="group_and_user_data",
    ),
    path(
        "object_data/<destination>/<location_id>/delete_tag/",
        object_data_views.delete_tag,
        name="delete_tag"
    ),
    path(
        "object_data/<destination>/<location_id>/migrate_link/",
        object_data_views.migrate_link,
        name="migrate_link",
    ),
    path(
        "object_data/<destination>/<location_id>/note_list/",
        note_views.note_list,
        name="note_list",
    ),
    path(
        "object_data/<destination>/<organisation_id>/organisation_note_list/",
        note_views.organisation_note_list,
        name="organisation_note_list",
    ),
    path(
        "object_data/<destination>/<location_id>/object_link_list/",
        object_data_views.object_link_list,
        name="object_link_list",
    ), 
    path(
        "object_data/<destination>/<location_id>/query_bug_client/",
        object_data_views.query_bug_client,
        name="query_bug_client",
    ),
    path(
        "object_data/<destination>/<location_id>/remove_customer/",
        object_data_views.remove_customer,
        name="remove_customer",
    ),
    path(
        "object_data/<destination>/<location_id>/remove_group/",
        object_data_views.remove_group,
        name="remove_group",
    ),
    path(
        "object_data/<destination>/<location_id>/remove_link/",
        object_data_views.remove_link,
        name="remove_link",
    ),
    path(
        "object_data/<destination>/<location_id>/remove_sprint/<sprint_id>/",
        sprint_views.remove_sprint,
        name="remove_sprint",
    ),
    path(
        "object_data/<destination>/<location_id>/remove_user/",
        object_data_views.remove_user,
        name="remove_user",
    ),
    path(
        "object_data/<destination>/<location_id>/sprint_list/assigned/",
        sprint_views.list_assigned_sprints,
        name="list_assigned_sprints",
    ),
    path(
        "object_data/<destination>/<location_id>/sprint_list/child/",
        sprint_views.list_child_sprints,
        name="list_child_sprints"
    ),
    path(
        "object_data/<destination>/<location_id>/tag_list/",
        object_data_views.tag_list,
        name="tag_list",
    ),
    path(
        "object_data/tag_list_all/", object_data_views.tag_list_all, name="tag_list_all"
    ),
    path(
        "object_data/<destination>/<location_id>/user_list/",
        object_data_views.user_list,
        name="user_list",
    ),
    path("object_data/delete_bug/", object_data_views.delete_bug, name="delete_bug"),
    path("object_data/delete_link/", object_data_views.delete_link, name="delete_link"),
    path(
        "object_data/lead_user_list/",
        object_data_views.lead_user_list,
        name="lead_user_list",
    ),
    path(
        "object_data/sprint_list/",
        sprint_views.sprint_list,
        name="sprint_list",
    ),
    # Organisation
    path(
        "organisation_duplicates/",
        organisation_views.organisation_duplicates,
        name="organisation_duplicates",
    ),
    path(
        "organisation_information/<int:organisation_id>/",
        organisation_views.organisation_information,
        name="organisation_information",
    ),
    path(
        "organisation_information/<int:organisation_id>/get_profile_picture/",
        organisation_views.get_profile_picture,
        name="organisation_get_profile_picture",
    ),
    path(
        "organisation_information/<int:organisation_id>/save/",
        organisation_views.organisation_information_save,
        name="organisation_information_save",
    ),
    path(
        "organisation_information/<int:organisation_id>/update_profile/",
        organisation_views.organisation_update_profile,
        name="organisation_update_profile",
    ),
    # Projects
    path(
        "project_information/<int:project_id>/",
        project_views.project_information,
        name="project_information",
    ),
    path(
        "project_information/<int:project_id>/save/",
        project_views.project_information_save,
        name="project_information_save",
    ),
    # Public
    path(
        "public/<destination>/<int:location_id>/<uuid:public_link_id>/",
        public_views.public_link,
        name="public_link",
    ),
    path(
        "public_data/<destination>/<int:location_id>/create/",
        public_views.create_public_link,
        name="create_public_link",
    ),
    path(
        "public_data/<destination>/<int:location_id>/delete/",
        public_views.delete_public_link,
        name="delete_public_link",
    ),
    path(
        "public_data/<destination>/<int:location_id>/get_links/",
        public_views.get_public_links,
        name="get_public_links",
    ),
    path(
        "public_data/<destination>/<int:location_id>/update_link/",
        public_views.update_public_link,
        name="update_public_link",
    ),
    # Requirements
    path(
        "requirement_information/<int:requirement_id>/",
        requirement_views.requirement_information,
        name="requirement_information",
    ),
    path(
        "requirement_information/<int:requirement_id>/add_link/",
        requirement_views.add_requirement_link,
        name="add_requirement_link",
    ),
    path(
        "requirement_information/<int:requirement_id>/data/item_links/",
        requirement_views.get_requirement_item_links,
        name="get_requirement_item_links",
    ),
    path(
        "requirement_information/<int:requirement_id>/data/items/",
        requirement_views.get_requirement_items,
        name="get_requirement_items",
    ),
    path(
        #"requirement_information/<int:requirement_id>/data/item_status/",
        "requirement_information/data/list_of_item_status_values/",
        requirement_views.get_requirement_item_status_list,
        name="get_requirement_item_status_list",
    ),
    path(
        #"requirement_information/<int:requirement_id>/data/item_type/",
        "requirement_information/data/list_of_item_type_values/",
        requirement_views.get_requirement_item_type_list,
        name="get_requirement_item_type_list",
    ),
    path(
        "requirement_information/<int:requirement_id>/save/",
        requirement_views.requirement_information_save,
        name="requirement_information_save",
    ),
    # Requirement Items
    path(
        "requirement_item_information/<int:requirement_item_id>/",
        requirement_item_views.requirement_item_information,
        name="requirement_item_information",
    ),
    path(
        "requirement_item_information/<int:requirement_item_id>/add_link/",
        requirement_item_views.add_requirement_item_link,
        name="add_requirement_item_link",
    ),
    path(
        "requirement_item_information/<int:requirement_item_id>/",
        requirement_item_views.requirement_item_information,
        name="requirement_item_information",
    ),
    path(
        "requirement_item_information/<int:requirement_item_id>/save/",
        requirement_item_views.requirement_item_information_save,
        name="requirement_information_save",
    ),
    # Request for Change
    path(
        "rfc_deployment/<int:rfc_id>/",
        request_for_change_views.rfc_deployment,
        name="rfc_deployment",
    ),
    path(
        "rfc_information/<int:rfc_id>/",
        request_for_change_views.rfc_information,
        name="rfc_information",
    ),
    path(
        "rfc_information/<int:rfc_id>/change_task_list/",
        request_for_change_views.rfc_change_task_list,
        name="rfc_change_task_list",
    ),
    path(
        "rfc_information/<int:rfc_id>/get_approval_users/",
        request_for_change_views.rfc_get_approval_users,
        name="rfc_get_approval_users",
    ),
    path(
        "rfc_information/<int:rfc_id>/new_change_task/",
        request_for_change_views.rfc_new_change_task,
        name="rfc_new_change_task",
    ),
    path(
        "rfc_information/<int:rfc_id>/save/",
        request_for_change_views.rfc_information_save,
        name="rfc_information_save",
    ),
    path(
        "rfc_information/<int:rfc_id>/save/backout/",
        request_for_change_views.rfc_save_backout,
        name="rfc_save_backout",
    ),
    path(
        "rfc_information/<int:rfc_id>/save/implementation/",
        request_for_change_views.rfc_save_implementation,
        name="rfc_save_implementation",
    ),
    path(
        "rfc_information/<int:rfc_id>/save/risk/",
        request_for_change_views.rfc_save_risk,
        name="rfc_save_risk",
    ),
    path(
        "rfc_information/<int:rfc_id>/save/test/",
        request_for_change_views.rfc_save_test,
        name="rfc_save_test",
    ),
    path(
        "rfc_information/<int:rfc_id>/update_change_lead/",
        request_for_change_views.rfc_update_change_lead,
        name="rfc_update_change_lead",
    ),
    path(
        "rfc_information/<int:rfc_id>/update_status/",
        request_for_change_views.rfc_update_status,
        name="rfc_update_status",
    ),
    path(
        "rfc_readonly/<int:rfc_id>/",
        request_for_change_views.rfc_readonly,
        name="rfc_readonly",
    ),
    # Scheduled Objects
    path(
        "scheduled_objects/",
        object_scheduler_views.scheduled_objects,
        name="scheduled_objects",
    ),
    path(
        "scheduled_object_information/<int:schedule_object_id>/",
        object_scheduler_views.scheduled_object_information,
        name="schedule_object_information",
    ),
    path(
        "scheduled_object_information/<int:schedule_object_id>/save/",
        object_scheduler_views.scheduled_object_information_save,
        name="schedule_object_information_save",
    ),
    # Search Items
    path("search/", search_views.search, name="search"),
    path("search/data/", search_views.search_data, name="search_data"),
    path("search/group/", search_views.search_group, name="search_group"),
    path(
        "search/group/data/", search_views.search_group_data, name="search_group_data"
    ),
    path("search/customer/", search_views.search_customer, name="search_customer"),
    path(
        "search/customer/data/",
        search_views.search_customer_data,
        name="search_customer_data",
    ),
    path(
        "search/notification/",
        search_views.search_notification,
        name="search_notification",
    ),
    path(
        "search/notification/data/",
        search_views.search_notification_data,
        name="search_notification_data",
    ),
    path(
        "search/organisation/",
        search_views.search_organisation,
        name="search_organisation",
    ),
    path(
        "search/organisation/data/",
        search_views.search_organisation_data,
        name="search_organisation_data",
    ),
    path(
        "search/permission_set/",
        search_views.search_permission_set,
        name="search_permission_set",
    ),
    path(
        "search/permission_set/data/",
        search_views.search_permission_set_data,
        name="search_permission_set_data",
    ),
    path(
        "search/sprint/",
        search_views.search_sprint,
        name="search_sprint",
    ),
    path(
        "search/scheduled_objects/",
        search_views.search_scheduled_objects,
        name="search_scheduled_objects",
    ),
    path(
        "search/sprint/data/",
        search_views.search_sprint_data,
        name="search_sprint_data",
    ),
    path("search/tag/", search_views.search_tag, name="search_tag"),
    path("search/user/", search_views.search_user, name="search_user"),
    path("search/user/data/", search_views.search_user_data, name="search_user_data"),
    path(
        "sprint_information/<int:sprint_id>/",
        sprint_views.sprint_information,
        name="sprint_information"
    ),
    path(
        "sprint_information/<int:sprint_id>/delete/",
        sprint_views.delete_sprint,
        name="sprint_information_delete",
    ),
    path(
        "sprint_information/<int:sprint_id>/edit/",
        sprint_views.edit_sprint,
        name="sprint_information_edit"
    ),
    path(
        "sprint_information/<int:sprint_id>/finish_sprint/",
        sprint_views.finish_sprint,
        name="sprint_information_finish_sprint",
    ),
    path(
        "sprint_information/<int:sprint_id>/potential_object_list/",
        sprint_views.potential_object_list,
        name="sprint_information_potential_object_list",
    ),
    path(
        "sprint_information/<int:sprint_id>/start_sprint/",
        sprint_views.start_sprint,
        name="sprint_information_start_sprint",
    ),
    path(
        "sprint_information/<int:sprint_id>/update_sprint/",
        sprint_views.update_sprint,
        name="sprint_information_update"
    ),
    # Tags
    path("tag/delete/<int:tag_id>/", tag_views.delete_tag, name="delete_tag"),
    path("tag/new/", tag_views.new_tag, name="new_tag"),
    path("tag/save/", tag_views.save_tag, name="save_tag"),
    # Tasks
    path(
        "task_information/<int:task_id>/",
        task_views.task_information,
        name="task_information",
    ),
    path(
        "task_information/<int:task_id>/save/",
        task_views.task_information_save,
        name="task_information_save",
    ),
    # Users
    path(
        "user_information/<int:username>/",
        user_views.user_information,
        name="user_information",
    ),
    path(
        "user_information/<int:username>/save/",
        user_views.user_information_save,
        name="user_information_save",
    ),
    path(
        "user_information/update_user_password/",
        user_views.update_password,
        name="update_password",
    ),
    path(
        "user_information/remove_permission/",
        user_views.user_remove_permission,
        name="user_remove_permission"
    ),
    path(
        "test/permission_denied/",
        authentication_views.test_permission_denied,
        name="test_permission_denied",
    ),
    path(
        "update_group_leader_status/<destination>/",
        admin_views.update_group_leader_status,
        name="update_group_leader_status",
    ),
    # DELETE IS CURRENTLY NOT USED!!! PLACE INTO THE SYSTEM JUST IN CASE :)
    # path(
    #     "user_settings/delete/",
    #     user_setting_views.delete_user_settings,
    #     name="user_settings_delete",
    # ),
    path(
        "user_settings/update/",
        user_setting_views.update_user_settings,
        name="user_settings_update",
    ),
    # Changing and Resetting Passwords
    path(
        "password_reset/",
        auth_views.PasswordResetView.as_view(
            template_name="NearBeach/authentication/password_reset.html",
            html_email_template_name="NearBeach/authentication/password_reset_email.html",
            email_template_name="NearBeach/authentication/password_reset_email.html",
        ),
        name="password_reset",
    ),
    path(
        "password_reset/done/",
        auth_views.PasswordResetDoneView.as_view(
            template_name="NearBeach/authentication/password_reset_done.html",
        ),
        name="password_reset_done",
    ),
    path(
        "reset/<uidb64>/<token>/",
        auth_views.PasswordResetConfirmView.as_view(
            template_name="NearBeach/authentication/reset.html",
        ),
        name="password_reset_confirm",
    ),
    path(
        "reset/done",
        auth_views.PasswordResetCompleteView.as_view(
            template_name="NearBeach/authentication/reset_done.html",
        ),
        name="password_reset_complete",
    ),
]

handler403 = error_views.error_403
handler404 = error_views.error_404
handler500 = error_views.error_500
