// Vitest
import { describe, expect, test } from "vitest";
import {mount, VueWrapper} from "@vue/test-utils";

// Import vue component
import KanbanInformation from "/src/js/components/kanban/KanbanInformation.vue";

// VueX
import { store } from "/src/js/vuex-store";

// Axios
const axios = require('axios');

describe('KanbanInformation.vue - rendering component', () => {
    //Using mount - insert data
    const wrapper = mount(KanbanInformation, {
        props: {
            columnResults:[{"model":"NearBeach.kanbancolumn","pk":1,"fields":{"kanban_column_name":"Backlog","kanban_column_property":"Normal","kanban_column_sort_number":0,"kanban_board":1,"date_created":"2023-02-15T09:12:31.597Z","date_modified":"2023-02-15T09:12:31.597Z","change_user":1,"is_deleted":false}},{"model":"NearBeach.kanbancolumn","pk":2,"fields":{"kanban_column_name":"Blocked","kanban_column_property":"Blocked","kanban_column_sort_number":1,"kanban_board":1,"date_created":"2023-02-15T09:12:31.599Z","date_modified":"2023-02-15T09:12:31.599Z","change_user":1,"is_deleted":false}},{"model":"NearBeach.kanbancolumn","pk":3,"fields":{"kanban_column_name":"In Progress","kanban_column_property":"Normal","kanban_column_sort_number":2,"kanban_board":1,"date_created":"2023-02-15T09:12:31.600Z","date_modified":"2023-02-15T09:12:31.600Z","change_user":1,"is_deleted":false}},{"model":"NearBeach.kanbancolumn","pk":4,"fields":{"kanban_column_name":"Review and QA","kanban_column_property":"Normal","kanban_column_sort_number":3,"kanban_board":1,"date_created":"2023-02-15T09:12:31.600Z","date_modified":"2023-02-15T09:12:31.601Z","change_user":1,"is_deleted":false}},{"model":"NearBeach.kanbancolumn","pk":5,"fields":{"kanban_column_name":"Completed","kanban_column_property":"Closed","kanban_column_sort_number":4,"kanban_board":1,"date_created":"2023-02-15T09:12:31.601Z","date_modified":"2023-02-15T09:12:31.602Z","change_user":1,"is_deleted":false}}],
            kanbanBoardResults:[{"model":"NearBeach.kanbanboard","pk":1,"fields":{"kanban_board_name":"Kanban Admin Only","requirement":null,"kanban_board_status":"Open","date_created":"2023-02-15T09:12:31.594Z","date_modified":"2023-02-15T09:12:31.594Z","change_user":1,"creation_user":1,"is_deleted":false}}],
            kanbanCardResults:[{"model":"NearBeach.kanbancard","pk":1,"fields":{"kanban_card_text":"Administration Card.","kanban_card_description":"undefined","kanban_card_sort_number":0,"kanban_level":1,"kanban_column":2,"kanban_board":1,"kanban_card_priority":0,"project":null,"task":null,"requirement":null,"is_archived":false,"date_created":"2023-02-15T09:12:40.336Z","date_modified":"2023-11-08T08:59:20.811Z","change_user":1,"is_deleted":false}},{"model":"NearBeach.kanbancard","pk":6,"fields":{"kanban_card_text":"Bottom Card","kanban_card_description":"","kanban_card_sort_number":0,"kanban_level":2,"kanban_column":1,"kanban_board":1,"kanban_card_priority":2,"project":null,"task":null,"requirement":null,"is_archived":false,"date_created":"2023-10-16T09:03:56.471Z","date_modified":"2023-10-18T11:38:57.522Z","change_user":1,"is_deleted":false}},{"model":"NearBeach.kanbancard","pk":7,"fields":{"kanban_card_text":"Top","kanban_card_description":"","kanban_card_sort_number":0,"kanban_level":2,"kanban_column":2,"kanban_board":1,"kanban_card_priority":2,"project":null,"task":null,"requirement":null,"is_archived":false,"date_created":"2023-10-16T09:04:01.985Z","date_modified":"2023-10-18T11:38:13.261Z","change_user":1,"is_deleted":false}},{"model":"NearBeach.kanbancard","pk":9,"fields":{"kanban_card_text":"Middle","kanban_card_description":"<p>asdfasdf</p>","kanban_card_sort_number":0,"kanban_level":1,"kanban_column":1,"kanban_board":1,"kanban_card_priority":2,"project":null,"task":null,"requirement":null,"is_archived":false,"date_created":"2023-10-18T08:34:24.784Z","date_modified":"2023-10-27T10:40:49.608Z","change_user":1,"is_deleted":false}},{"model":"NearBeach.kanbancard","pk":11,"fields":{"kanban_card_text":"Card 1","kanban_card_description":"","kanban_card_sort_number":0,"kanban_level":9,"kanban_column":1,"kanban_board":1,"kanban_card_priority":2,"project":null,"task":null,"requirement":null,"is_archived":false,"date_created":"2023-10-18T09:13:08.277Z","date_modified":"2023-10-18T10:12:52.786Z","change_user":1,"is_deleted":false}},{"model":"NearBeach.kanbancard","pk":19,"fields":{"kanban_card_text":"New coard","kanban_card_description":"","kanban_card_sort_number":0,"kanban_level":9,"kanban_column":2,"kanban_board":1,"kanban_card_priority":2,"project":null,"task":null,"requirement":null,"is_archived":false,"date_created":"2023-10-18T10:17:03.243Z","date_modified":"2023-10-18T10:17:18.748Z","change_user":1,"is_deleted":false}},{"model":"NearBeach.kanbancard","pk":5,"fields":{"kanban_card_text":"TOP CARD","kanban_card_description":"","kanban_card_sort_number":1,"kanban_level":1,"kanban_column":2,"kanban_board":1,"kanban_card_priority":2,"project":null,"task":null,"requirement":null,"is_archived":false,"date_created":"2023-10-16T09:02:08.074Z","date_modified":"2023-11-08T08:59:20.813Z","change_user":1,"is_deleted":false}},{"model":"NearBeach.kanbancard","pk":8,"fields":{"kanban_card_text":"Bottom","kanban_card_description":"","kanban_card_sort_number":1,"kanban_level":2,"kanban_column":2,"kanban_board":1,"kanban_card_priority":2,"project":null,"task":null,"requirement":null,"is_archived":false,"date_created":"2023-10-16T09:04:06.953Z","date_modified":"2023-10-18T11:38:13.263Z","change_user":1,"is_deleted":false}},{"model":"NearBeach.kanbancard","pk":10,"fields":{"kanban_card_text":"Bottom Cars","kanban_card_description":"","kanban_card_sort_number":1,"kanban_level":1,"kanban_column":1,"kanban_board":1,"kanban_card_priority":2,"project":null,"task":null,"requirement":null,"is_archived":false,"date_created":"2023-10-18T08:34:36.918Z","date_modified":"2023-10-27T10:40:52.013Z","change_user":1,"is_deleted":false}},{"model":"NearBeach.kanbancard","pk":12,"fields":{"kanban_card_text":"Card 2","kanban_card_description":"","kanban_card_sort_number":1,"kanban_level":9,"kanban_column":1,"kanban_board":1,"kanban_card_priority":2,"project":null,"task":null,"requirement":null,"is_archived":false,"date_created":"2023-10-18T09:13:11.985Z","date_modified":"2023-10-18T10:12:52.791Z","change_user":1,"is_deleted":false}},{"model":"NearBeach.kanbancard","pk":13,"fields":{"kanban_card_text":"Card 3","kanban_card_description":"","kanban_card_sort_number":2,"kanban_level":9,"kanban_column":1,"kanban_board":1,"kanban_card_priority":2,"project":null,"task":null,"requirement":null,"is_archived":false,"date_created":"2023-10-18T09:13:15.742Z","date_modified":"2023-10-18T10:12:52.796Z","change_user":1,"is_deleted":false}},{"model":"NearBeach.kanbancard","pk":14,"fields":{"kanban_card_text":"Card 4","kanban_card_description":"","kanban_card_sort_number":3,"kanban_level":9,"kanban_column":1,"kanban_board":1,"kanban_card_priority":2,"project":null,"task":null,"requirement":null,"is_archived":false,"date_created":"2023-10-18T09:14:42.898Z","date_modified":"2023-10-18T10:12:52.798Z","change_user":1,"is_deleted":false}},{"model":"NearBeach.kanbancard","pk":15,"fields":{"kanban_card_text":"Card 5","kanban_card_description":"","kanban_card_sort_number":4,"kanban_level":9,"kanban_column":1,"kanban_board":1,"kanban_card_priority":2,"project":null,"task":null,"requirement":null,"is_archived":false,"date_created":"2023-10-18T09:14:48.460Z","date_modified":"2023-10-18T10:12:52.800Z","change_user":1,"is_deleted":false}},{"model":"NearBeach.kanbancard","pk":16,"fields":{"kanban_card_text":"Card 6","kanban_card_description":"","kanban_card_sort_number":5,"kanban_level":9,"kanban_column":1,"kanban_board":1,"kanban_card_priority":2,"project":null,"task":null,"requirement":null,"is_archived":false,"date_created":"2023-10-18T09:14:58.355Z","date_modified":"2023-10-18T10:12:52.801Z","change_user":1,"is_deleted":false}},{"model":"NearBeach.kanbancard","pk":17,"fields":{"kanban_card_text":"Card 7","kanban_card_description":"<p>All the pip</p>","kanban_card_sort_number":6,"kanban_level":9,"kanban_column":1,"kanban_board":1,"kanban_card_priority":2,"project":null,"task":null,"requirement":null,"is_archived":false,"date_created":"2023-10-18T09:15:02.926Z","date_modified":"2023-10-27T10:40:37.401Z","change_user":1,"is_deleted":false}},{"model":"NearBeach.kanbancard","pk":18,"fields":{"kanban_card_text":"Card 8","kanban_card_description":"","kanban_card_sort_number":7,"kanban_level":9,"kanban_column":1,"kanban_board":1,"kanban_card_priority":2,"project":null,"task":null,"requirement":null,"is_archived":false,"date_created":"2023-10-18T09:15:08.696Z","date_modified":"2023-10-18T10:12:52.805Z","change_user":1,"is_deleted":false}}],
            kanbanSettings:{"setting_data":{"canDragCards":true,"levels":[{"level_id":15,"is_collapsed":false},{"level_id":1,"is_collapsed":false},{"level_id":2,"is_collapsed":false},{"level_id":9,"is_collapsed":false},{"level_id":10,"is_collapsed":false},{"level_id":11,"is_collapsed":false},{"level_id":12,"is_collapsed":false}]}},
            levelResults:[{"model":"NearBeach.kanbanlevel","pk":1,"fields":{"kanban_level_name":"Sprint 1","kanban_level_sort_number":0,"kanban_board":1,"date_created":"2023-02-15T09:12:31.603Z","date_modified":"2023-10-09T10:01:11.301Z","change_user":1,"is_deleted":false}},{"model":"NearBeach.kanbanlevel","pk":2,"fields":{"kanban_level_name":"Sprint 2","kanban_level_sort_number":1,"kanban_board":1,"date_created":"2023-02-15T09:12:31.604Z","date_modified":"2023-10-09T10:01:11.304Z","change_user":1,"is_deleted":false}},{"model":"NearBeach.kanbanlevel","pk":9,"fields":{"kanban_level_name":"Sprint 3","kanban_level_sort_number":2,"kanban_board":1,"date_created":"2023-10-09T10:00:58.211Z","date_modified":"2023-10-09T10:01:11.306Z","change_user":1,"is_deleted":false}},{"model":"NearBeach.kanbanlevel","pk":10,"fields":{"kanban_level_name":"Sprint 4","kanban_level_sort_number":3,"kanban_board":1,"date_created":"2023-10-09T10:01:02.402Z","date_modified":"2023-10-09T10:01:11.308Z","change_user":1,"is_deleted":false}},{"model":"NearBeach.kanbanlevel","pk":11,"fields":{"kanban_level_name":"Sprint 5","kanban_level_sort_number":4,"kanban_board":1,"date_created":"2023-10-09T10:01:06.605Z","date_modified":"2023-10-09T10:01:11.310Z","change_user":1,"is_deleted":false}},{"model":"NearBeach.kanbanlevel","pk":12,"fields":{"kanban_level_name":"Sprint 6","kanban_level_sort_number":12,"kanban_board":1,"date_created":"2023-10-09T10:01:11.294Z","date_modified":"2023-10-09T10:01:11.294Z","change_user":1,"is_deleted":false}}],
            locationId:1,
            openCardOnLoad:0,
            potentialUserList:[],
            rootUrl:"/",
            staticUrl:"/static/",
            theme:"dark",
            userLevel:4
        },
        global: {
            plugins: [store],
            mocks: {
                axios,
            }
        },
    });

    test('Empty test', () => {});
});