const SvgMaritalkIcon = (props) => (
  <svg
    version="1.1"
    xmlns="http://www.w3.org/2000/svg"
    viewBox="0 0 118 118"
    {...props}
  >
    <path
      d="M0 0 C3.43739487 3.53029744 4.54420068 6.10015733 5 11 C5.66 11 6.32 11 7 11 C12.90150827 20.84310604 14.16501426 30.1571562 11.80859375 41.38671875 C10.70894187 44.94066614 9.07476326 47.97130203 7.12109375 51.125 C5.84466871 53.10693813 5.84466871 53.10693813 5 56 C5.75446855 57.93537584 6.51189439 59.86976625 7.296875 61.79296875 C8.40505709 65.27142921 8.19424994 68.37400115 8 72 C5.83125748 71.49396008 4.00032373 71.00016187 2 70 C1.7328418 70.59240479 1.46568359 71.18480957 1.19042969 71.79516602 C-0.01802166 74.0333785 -1.24858328 75.49278973 -3.046875 77.27734375 C-3.645 77.87353516 -4.243125 78.46972656 -4.859375 79.08398438 C-5.79523438 80.00147461 -5.79523438 80.00147461 -6.75 80.9375 C-7.3584375 81.54529297 -7.966875 82.15308594 -8.59375 82.77929688 C-10.37463485 84.54305783 -12.18295869 86.27360819 -14 88 C-14.52142578 88.52480957 -15.04285156 89.04961914 -15.58007812 89.59033203 C-17.99943473 91.87326468 -19.51367431 92.96289613 -22.8671875 93.21875 C-27.35298192 91.47365292 -30.52675552 88.64429156 -34.125 85.5 C-35.51818635 84.29598024 -36.91645186 83.09780658 -38.3203125 81.90625 C-38.93148926 81.37322266 -39.54266602 80.84019531 -40.17236328 80.29101562 C-43.12664512 78.20415451 -45.20212388 77.87306516 -48.75 78.4375 C-49.4925 78.623125 -50.235 78.80875 -51 79 C-52.25664978 76.09399739 -53 74.20395416 -53 71 C-53.763125 71.495 -54.52625 71.99 -55.3125 72.5 C-58 74 -58 74 -61 74 C-61.02698189 72.37509046 -61.04638757 70.75005367 -61.0625 69.125 C-61.07410156 68.22007813 -61.08570312 67.31515625 -61.09765625 66.3828125 C-61 64 -61 64 -60 62 C-60.99 61.67 -61.98 61.34 -63 61 C-62.69288414 56.42503267 -62.26984635 52.62604354 -60.4375 48.375 C-58.82717113 44.49487424 -58.93115181 41.17687245 -59.0625 37 C-59.30680053 24.77275823 -56.74335323 12.72222708 -48.546875 3.3359375 C-37.01797106 -8.02506978 -12.72743656 -10.12409726 0 0 Z "
      fill="#D6CF4C"
      transform="translate(82,17)"
    />
    <path
      d="M0 0 C0.81498562 1.6029053 1.62689927 3.20737278 2.4375 4.8125 C3.11619141 6.15248047 3.11619141 6.15248047 3.80859375 7.51953125 C6.21743422 12.53465814 6.21674323 16.73754683 6.25 22.1875 C6.270625 23.01314453 6.29125 23.83878906 6.3125 24.68945312 C6.34922614 30.51513648 5.20948343 34.62573923 3 40 C3.19822852 43.3038087 3.91828363 45.77888512 5.0625 48.875 C6.23249378 52.77497927 6.13998031 55.94057089 6 60 C3.83125748 59.49396008 2.00032373 59.00016187 0 58 C-0.2671582 58.59240479 -0.53431641 59.18480957 -0.80957031 59.79516602 C-2.01802166 62.0333785 -3.24858328 63.49278973 -5.046875 65.27734375 C-5.645 65.87353516 -6.243125 66.46972656 -6.859375 67.08398438 C-7.79523438 68.00147461 -7.79523438 68.00147461 -8.75 68.9375 C-9.3584375 69.54529297 -9.966875 70.15308594 -10.59375 70.77929688 C-12.37463485 72.54305783 -14.18295869 74.27360819 -16 76 C-16.52142578 76.52480957 -17.04285156 77.04961914 -17.58007812 77.59033203 C-20.0012327 79.87496127 -21.50990184 80.96394373 -24.8671875 81.2109375 C-29.33219884 79.4850603 -32.52219412 76.7264878 -36.125 73.625 C-37.52308219 72.4500979 -38.92150889 71.27560561 -40.3203125 70.1015625 C-41.23707764 69.31773193 -41.23707764 69.31773193 -42.17236328 68.51806641 C-44.06825104 66.94330951 -46.01716825 65.46319309 -48 64 C-47.34 64 -46.68 64 -46 64 C-45.7525 63.278125 -45.505 62.55625 -45.25 61.8125 C-44 59 -44 59 -42 56.5625 C-39.8317046 53.78437151 -38.94096937 51.37180689 -38 48 C-37.34 48 -36.68 48 -36 48 C-36 48.66 -36 49.32 -36 50 C-32.97592912 47.23889181 -32.09977117 45.22505907 -31.76171875 41.07421875 C-31.53352767 32.23109543 -31.53352767 32.23109543 -36 25 C-36.33 24.34 -36.66 23.68 -37 23 C-36.39671875 22.96003906 -35.7934375 22.92007813 -35.171875 22.87890625 C-32.53622323 22.5345711 -30.42786961 22.0978193 -28 21 C-26.55980288 18.8683321 -25.80563519 16.79357622 -24.9296875 14.37890625 C-22.51865071 8.20948859 -18.41263483 4.92345635 -12.5625 2.0625 C-8.10840177 0.2005409 -4.78183446 -0.53131494 0 0 Z "
      fill="#B81877"
      transform="translate(84,29)"
    />
    <path
      d="M0 0 C0.81498562 1.6029053 1.62689927 3.20737278 2.4375 4.8125 C3.11619141 6.15248047 3.11619141 6.15248047 3.80859375 7.51953125 C6.21743422 12.53465814 6.21674323 16.73754683 6.25 22.1875 C6.270625 23.01314453 6.29125 23.83878906 6.3125 24.68945312 C6.34922614 30.51513648 5.20948343 34.62573923 3 40 C3.19822852 43.3038087 3.91828363 45.77888512 5.0625 48.875 C6.23249378 52.77497927 6.13998031 55.94057089 6 60 C2.125 59.125 2.125 59.125 1 58 C0.60430892 55.98688551 0.25747809 53.96402792 -0.0625 51.9375 C-0.23910156 50.83277344 -0.41570312 49.72804687 -0.59765625 48.58984375 C-0.73042969 47.73519531 -0.86320312 46.88054687 -1 46 C-1.66 46 -2.32 46 -3 46 C-2.979375 45.05125 -2.95875 44.1025 -2.9375 43.125 C-2.77448174 40.09333717 -2.77448174 40.09333717 -4 38 C-4.52722656 38.15984375 -5.05445312 38.3196875 -5.59765625 38.484375 C-8.57890664 39.12425313 -11.38880912 39.20770602 -14.4375 39.25 C-16.10619141 39.28867188 -16.10619141 39.28867188 -17.80859375 39.328125 C-21.36004724 38.96298168 -23.16360065 38.12729951 -26 36 C-28.49520882 32.30020761 -29.66736937 28.85373066 -29.4765625 24.34375 C-27.97502038 16.9591166 -23.99212045 9.71183601 -17.91796875 5.1796875 C-11.97832005 1.52638015 -7.02323198 -0.59772187 0 0 Z "
      fill="#192342"
      transform="translate(84,29)"
    />
    <path
      d="M0 0 C4.8325314 2.37067578 7.76408623 5.09818904 10 10 C10.7762251 16.84647984 10.98839331 23.18359309 7 29 C6.34 29 5.68 29 5 29 C5 28.34 5 27.68 5 27 C4.34 27 3.68 27 3 27 C2.85884766 28.31871094 2.85884766 28.31871094 2.71484375 29.6640625 C1.9322283 33.31626793 0.73647182 35.36488517 -1.4375 38.375 C-2.05496094 39.24898437 -2.67242187 40.12296875 -3.30859375 41.0234375 C-3.86675781 41.67570312 -4.42492187 42.32796875 -5 43 C-5.66 43 -6.32 43 -7 43 C-7 43.66 -7 44.32 -7 45 C-9.475 45.495 -9.475 45.495 -12 46 C-13.25664978 43.09399739 -14 41.20395416 -14 38 C-14.763125 38.495 -15.52625 38.99 -16.3125 39.5 C-19 41 -19 41 -22 41 C-22.02698189 39.37509046 -22.04638757 37.75005367 -22.0625 36.125 C-22.07410156 35.22007813 -22.08570312 34.31515625 -22.09765625 33.3828125 C-22 31 -22 31 -21 29 C-21.99 28.67 -22.98 28.34 -24 28 C-23.38029501 18.19156581 -23.38029501 18.19156581 -20 14 C-19.34 14 -18.68 14 -18 14 C-18 12.989375 -18 11.97875 -18 10.9375 C-17.33343341 6.40114402 -14.81042181 4.10520123 -11.3203125 1.328125 C-7.49529833 -0.86127705 -4.24744824 -0.98502974 0 0 Z "
      fill="#1EA6CF"
      transform="translate(43,50)"
    />
    <path
      d="M0 0 C4 4.31578947 4 4.31578947 4 8 C3.195625 7.67 2.39125 7.34 1.5625 7 C-5.98576918 4.8811876 -11.01209358 5.77299686 -17.9609375 9.17578125 C-20.93510569 10.37798334 -22.90532882 9.72815793 -26 9 C-31.65481291 8.55418487 -36.40219219 8.21511196 -41.5625 10.75 C-42.7690625 11.86375 -42.7690625 11.86375 -44 13 C-44.639375 13.5775 -45.27875 14.155 -45.9375 14.75 C-47.57497023 18.21758402 -46.96157446 21.4172448 -46 25 C-44.53888984 27.79897943 -44.53888984 27.79897943 -43 30 C-43 30.66 -43 31.32 -43 32 C-42.34 32.33 -41.68 32.66 -41 33 C-41.59167969 33.08636719 -42.18335937 33.17273437 -42.79296875 33.26171875 C-48.2975583 34.240512 -51.55344351 35.30015024 -55 40 C-55.92345923 42.34267025 -56.46568619 44.52272687 -57 47 C-57.66 47 -58.32 47 -59 47 C-59.64722183 31.46667611 -59.27679357 15.6234249 -48.546875 3.3359375 C-37.01797106 -8.02506978 -12.72743656 -10.12409726 0 0 Z "
      fill="#63BA50"
      transform="translate(82,17)"
    />
    <path
      d="M0 0 C0.99 0.33 1.98 0.66 3 1 C4.125 6.75 4.125 6.75 3 9 C3.66 9 4.32 9 5 9 C7.02512352 13.17681725 7.70408743 16.38431573 7 21 C4.97381193 23.98805825 2.54369132 26.450976 0 29 C-0.825 29.99 -1.65 30.98 -2.5 32 C-5.78938167 34.63150533 -7.89283747 34.15353879 -12 34 C-12.02505615 33.38592285 -12.0501123 32.7718457 -12.07592773 32.13916016 C-12.19345264 29.30097366 -12.31545526 26.4629956 -12.4375 23.625 C-12.47681641 22.65949219 -12.51613281 21.69398437 -12.55664062 20.69921875 C-12.82980822 14.43737688 -13.30323128 8.22902691 -14 2 C-13.15695313 1.93941406 -12.31390625 1.87882812 -11.4453125 1.81640625 C-10.34960938 1.73261719 -9.25390625 1.64882812 -8.125 1.5625 C-7.03445312 1.48128906 -5.94390625 1.40007812 -4.8203125 1.31640625 C-2.05271029 1.16998297 -2.05271029 1.16998297 0 0 Z "
      fill="#EACD35"
      transform="translate(78,66)"
    />
    <path
      d="M0 0 C0.33 0 0.66 0 1 0 C1 1.65 1 3.3 1 5 C4.3 3.35 7.6 1.7 11 0 C11.33 1.98 11.66 3.96 12 6 C14.38564077 5.42415568 16.66682784 4.77772405 19 4 C20.31626692 7.61973402 21 10.09567131 21 14 C21.66 14.33 22.32 14.66 23 15 C21.7260411 17.03833424 20.38938077 19.03852126 19 21 C18.34 21 17.68 21 17 21 C17 21.66 17 22.32 17 23 C15.35 23.33 13.7 23.66 12 24 C10.74335022 21.09399739 10 19.20395416 10 16 C9.236875 16.495 8.47375 16.99 7.6875 17.5 C5 19 5 19 2 19 C1.97301811 17.37509046 1.95361243 15.75005367 1.9375 14.125 C1.92589844 13.22007813 1.91429688 12.31515625 1.90234375 11.3828125 C2 9 2 9 3 7 C2.01 6.67 1.02 6.34 0 6 C0 4.02 0 2.04 0 0 Z "
      fill="#1F4A8C"
      transform="translate(19,72)"
    />
    <path
      d="M0 0 C0.96744141 -0.01611328 1.93488281 -0.03222656 2.93164062 -0.04882812 C8.33082764 -0.05252367 12.31240995 0.19113381 16.9375 3.3125 C17.4325 4.3025 17.4325 4.3025 17.9375 5.3125 C17.17566406 5.26609375 16.41382813 5.2196875 15.62890625 5.171875 C9.06785136 4.94252477 4.70499033 5.524537 -1.12890625 8.48828125 C-4.03103114 9.72534863 -6.02811833 9.02647216 -9.0625 8.3125 C-17.19553015 7.48591259 -17.19553015 7.48591259 -24.625 10.1875 C-25.429375 10.88875 -26.23375 11.59 -27.0625 12.3125 C-28.0525 12.9725 -29.0425 13.6325 -30.0625 14.3125 C-27.79030304 8.73528927 -23.36231107 4.96240554 -18.0625 2.3125 C-12.00860544 0.14869012 -6.39489827 -0.02138762 0 0 Z "
      fill="#4D619A"
      transform="translate(65.0625,17.6875)"
    />
    <path
      d="M0 0 C0.66 0.33 1.32 0.66 2 1 C2.54591121 4.74339115 2.75830191 6.86468923 0.6171875 10.0703125 C-1.18733496 12.12481209 -3.06881924 14.06477065 -5 16 C-5.825 16.99 -6.65 17.98 -7.5 19 C-10.7807952 21.62463616 -12.9090117 21.40107728 -17 21 C-17 16.71 -17 12.42 -17 8 C-15.63875 7.896875 -14.2775 7.79375 -12.875 7.6875 C-8.70279004 7.21443052 -5.56128172 6.34523431 -2 4 C-0.59533047 1.94906855 -0.59533047 1.94906855 0 0 Z "
      fill="#E6622C"
      transform="translate(83,79)"
    />
    <path
      d="M0 0 C5.89469527 9.83174266 7.18180743 19.160854 4.8046875 30.37890625 C3.50999034 34.59609942 1.59215521 38.4274784 -1 42 C-1.99 42.495 -1.99 42.495 -3 43 C-2.7834375 42.49855469 -2.566875 41.99710938 -2.34375 41.48046875 C1.20607508 31.83349041 2.41912837 18.13436232 -1.9375 8.5625 C-2.29714844 7.94503906 -2.65679687 7.32757813 -3.02734375 6.69140625 C-4.10211735 4.82242244 -4.56122607 3.10149618 -5 1 C-12.68636026 2.35225523 -12.68636026 2.35225523 -20 5 C-20 4.34 -20 3.68 -20 3 C-13.45841601 -0.65111665 -7.36120371 -0.29887594 0 0 Z "
      fill="#A7A6A4"
      transform="translate(89,28)"
    />
    <path
      d="M0 0 C0.8971875 0.495 0.8971875 0.495 1.8125 1 C4.05386471 2.20787988 4.05386471 2.20787988 7 2 C7.66 1.67 8.32 1.34 9 1 C10.5 2.25 10.5 2.25 12 4 C12 5.32 12 6.64 12 8 C13.98 7.67 15.96 7.34 18 7 C17.34 8.32 16.68 9.64 16 11 C15.34 11 14.68 11 14 11 C14 10.34 14 9.68 14 9 C13.34 9 12.68 9 12 9 C11.87625 9.928125 11.7525 10.85625 11.625 11.8125 C11 15 11 15 9 18 C8.01 18 7.02 18 6 18 C5.01 15.03 4.02 12.06 3 9 C2.01 9.66 1.02 10.32 0 11 C-2.1875 10.625 -2.1875 10.625 -4 10 C-4.25 6.6875 -4.25 6.6875 -4 3 C-2 1.0625 -2 1.0625 0 0 Z "
      fill="#2774BA"
      transform="translate(34,68)"
    />
    <path
      d="M0 0 C0 0.99 0 1.98 0 3 C-0.70125 3.03738281 -1.4025 3.07476563 -2.125 3.11328125 C-6.89147838 3.44356712 -10.95037927 3.77966704 -15.3125 5.8125 C-16.529375 6.204375 -17.74625 6.59625 -19 7 C-22.5 5.1875 -22.5 5.1875 -25 3 C-24.67 2.01 -24.34 1.02 -24 0 C-15.51939583 -4.08886272 -8.386863 -4.28265345 0 0 Z "
      fill="#EA5934"
      transform="translate(87,25)"
    />
    <path
      d="M0 0 C1.0725 -0.01417969 2.145 -0.02835938 3.25 -0.04296875 C6 0.1875 6 0.1875 8 2.1875 C5.69 2.5175 3.38 2.8475 1 3.1875 C1.66 4.8375 2.32 6.4875 3 8.1875 C2.030625 8.001875 1.06125 7.81625 0.0625 7.625 C-0.948125 7.480625 -1.95875 7.33625 -3 7.1875 C-4.29633621 8.25395115 -4.29633621 8.25395115 -4.0625 10.75 C-4.041875 11.554375 -4.02125 12.35875 -4 13.1875 C-0.41672247 14.18967064 -0.41672247 14.18967064 3 13.1875 C2.67 14.1775 2.34 15.1675 2 16.1875 C-3.37313433 17.50093284 -3.37313433 17.50093284 -5.875 16.25 C-7.67836628 12.94382849 -7.18323695 9.91331793 -7 6.1875 C-9.64 7.8375 -12.28 9.4875 -15 11.1875 C-14.84817368 8.53053932 -14.52675976 6.74515476 -12.66796875 4.77734375 C-8.15385945 1.01009439 -5.79544929 0.03482842 0 0 Z "
      fill="#EEDF4B"
      transform="translate(50,24.8125)"
    />
    <path
      d="M0 0 C0.70253906 0.14308594 1.40507813 0.28617188 2.12890625 0.43359375 C4.04732904 0.81205811 5.97237089 1.15835381 7.90234375 1.47265625 C13.55141693 2.57048128 17.2289345 3.43112036 20.75 8.1875 C21.53390986 9.43770106 22.29727619 10.70242665 23 12 C20 13 20 13 16.6015625 11.5234375 C15.27036372 10.81790215 13.94500705 10.10125871 12.625 9.375 C11.965 9.03082031 11.305 8.68664063 10.625 8.33203125 C6.37639529 6.03846177 3.24765018 3.57366911 0 0 Z "
      fill="#0C1222"
      transform="translate(59,52)"
    />
    <path
      d="M0 0 C0.99 0.33 1.98 0.66 3 1 C5.66161816 6.61897168 6.3306901 10.82711812 6 17 C2.125 16.125 2.125 16.125 1 15 C0.60430892 12.98688551 0.25747809 10.96402792 -0.0625 8.9375 C-0.23910156 7.83277344 -0.41570312 6.72804688 -0.59765625 5.58984375 C-0.73042969 4.73519531 -0.86320312 3.88054687 -1 3 C-1.66 3 -2.32 3 -3 3 C-2 1 -2 1 0 0 Z "
      fill="#339A40"
      transform="translate(84,72)"
    />
    <path
      d="M0 0 C0.8971875 0.495 0.8971875 0.495 1.8125 1 C4.05386471 2.20787988 4.05386471 2.20787988 7 2 C7.66 1.67 8.32 1.34 9 1 C7.95125002 3.62187494 7.35068687 4.79371361 4.875 6.25 C4.25625 6.4975 3.6375 6.745 3 7 C3 7.66 3 8.32 3 9 C0 11 0 11 -2.1875 10.625 C-2.785625 10.41875 -3.38375 10.2125 -4 10 C-4.25 6.6875 -4.25 6.6875 -4 3 C-2 1.0625 -2 1.0625 0 0 Z "
      fill="#2381C4"
      transform="translate(34,68)"
    />
    <path
      d="M0 0 C0.66 0.33 1.32 0.66 2 1 C2.56963205 4.90604833 2.73522899 6.91600854 0.4765625 10.24609375 C-1.28122373 12.25857962 -3.03661153 14.18727923 -5 16 C-5.33 16 -5.66 16 -6 16 C-6 12.7 -6 9.4 -6 6 C-4.68 5.34 -3.36 4.68 -2 4 C-0.73195434 1.9664052 -0.73195434 1.9664052 0 0 Z "
      fill="#DB8E22"
      transform="translate(83,79)"
    />
    <path
      d="M0 0 C0.336611 1.77021322 0.66917293 3.54119674 1 5.3125 C1.185625 6.29863281 1.37125 7.28476562 1.5625 8.30078125 C2 11 2 11 2 14 C1.34 13.67 0.68 13.34 0 13 C0 15.64 0 18.28 0 21 C-0.33 21 -0.66 21 -1 21 C-1.01417969 20.3709375 -1.02835938 19.741875 -1.04296875 19.09375 C-1.41572683 12.40425361 -3.10211236 8.37276404 -7 3 C-7.33 2.34 -7.66 1.68 -8 1 C-1.125 0 -1.125 0 0 0 Z "
      fill="#DB216C"
      transform="translate(55,51)"
    />
    <path
      d="M0 0 C4.55555556 0.55555556 4.55555556 0.55555556 6 2 C6.1875 4.4375 6.1875 4.4375 6 7 C5.34 7.66 4.68 8.32 4 9 C-0.55555556 8.44444444 -0.55555556 8.44444444 -2 7 C-2.1875 4.5625 -2.1875 4.5625 -2 2 C-1.34 1.34 -0.68 0.68 0 0 Z "
      fill="#0D0C1F"
      transform="translate(47,31)"
    />
    <path
      d="M0 0 C2.109375 4.7109375 2.109375 4.7109375 1.125 7.3125 C0.568125 8.1478125 0.568125 8.1478125 0 9 C-0.66 9 -1.32 9 -2 9 C-5 3.25 -5 3.25 -5 1 C-12.68636026 2.35225523 -12.68636026 2.35225523 -20 5 C-20 4.34 -20 3.68 -20 3 C-13.45841601 -0.65111665 -7.36120371 -0.29887594 0 0 Z "
      fill="#CCBFBC"
      transform="translate(89,28)"
    />
    <path
      d="M0 0 C0.66 1.32 1.32 2.64 2 4 C1.030625 3.814375 0.06125 3.62875 -0.9375 3.4375 C-1.948125 3.293125 -2.95875 3.14875 -4 3 C-5.29633621 4.06645115 -5.29633621 4.06645115 -5.0625 6.5625 C-5.041875 7.366875 -5.02125 8.17125 -5 9 C-1.41672247 10.00217064 -1.41672247 10.00217064 2 9 C1.67 9.99 1.34 10.98 1 12 C-4.4 13.32 -4.4 13.32 -6.875 12 C-8.61178961 8.91237402 -8.37142345 6.4666189 -8 3 C-5.91685466 -0.39881608 -3.78885018 -0.30720407 0 0 Z "
      fill="#FAF9ED"
      transform="translate(51,29)"
    />
    <path
      d="M0 0 C0.33 0 0.66 0 1 0 C1 7.26 1 14.52 1 22 C2.98 22 4.96 22 7 22 C3.375 26.875 3.375 26.875 0 28 C0 18.76 0 9.52 0 0 Z "
      fill="#BF2563"
      transform="translate(65,78)"
    />
    <path
      d="M0 0 C0.99 0.33 1.98 0.66 3 1 C4.36884358 5.51718381 3.47075246 8.58774263 2 13 C1.67 13 1.34 13 1 13 C0.34 9.7 -0.32 6.4 -1 3 C-1.66 3 -2.32 3 -3 3 C-2 1 -2 1 0 0 Z "
      fill="#38A549"
      transform="translate(84,72)"
    />
    <path
      d="M0 0 C0.99 0.33 1.98 0.66 3 1 C2.01 1.495 2.01 1.495 1 2 C1.66 2.66 2.32 3.32 3 4 C1.783125 4.4125 0.56625 4.825 -0.6875 5.25 C-4.36735474 6.6160562 -7.06918364 8.34394768 -10 11 C-7.99155908 6.07019047 -4.35894926 2.90596617 0 0 Z "
      fill="#475E88"
      transform="translate(45,21)"
    />
    <path
      d="M0 0 C3.35435922 1.38801071 5.11290303 2.88629 7 6 C7 6.99 7 7.98 7 9 C3.58841744 7.86280581 2.88145399 6.95657056 1 4 C1 3.34 1 2.68 1 2 C0.34 1.67 -0.32 1.34 -1 1 C-0.67 0.67 -0.34 0.34 0 0 Z "
      fill="#6AA83B"
      transform="translate(79,16)"
    />
    <path
      d="M0 0 C0 1.65 0 3.3 0 5 C-1.98 5.99 -1.98 5.99 -4 7 C-5.32 5.02 -6.64 3.04 -8 1 C-1.125 0 -1.125 0 0 0 Z "
      fill="#C01F60"
      transform="translate(55,51)"
    />
    <path
      d="M0 0 C2.125 0.375 2.125 0.375 4 1 C3.01 1.33 2.02 1.66 1 2 C1 3.32 1 4.64 1 6 C2.32 6.66 3.64 7.32 5 8 C3.1875 8.625 3.1875 8.625 1 9 C0.01 8.34 -0.98 7.68 -2 7 C-2.3125 4.5 -2.3125 4.5 -2 2 C-1.34 1.34 -0.68 0.68 0 0 Z "
      fill="#793CA7"
      transform="translate(47,31)"
    />
    <path
      d="M0 0 C1.98 0 3.96 0 6 0 C4.71937515 1.7074998 3.38232443 3.37373596 2 5 C1.34 5 0.68 5 0 5 C0 3.35 0 1.7 0 0 Z "
      fill="#C6342C"
      transform="translate(66,100)"
    />
    <path
      d="M0 0 C0.99 0 1.98 0 3 0 C3 0.99 3 1.98 3 3 C0.5 4.6875 0.5 4.6875 -2 6 C-1.125 1.125 -1.125 1.125 0 0 Z "
      fill="#F4E23F"
      transform="translate(37,30)"
    />
    <path
      d="M0 0 C0.33 1.32 0.66 2.64 1 4 C-1 5 -3 6 -5 7 C-5 5.68 -5 4.36 -5 3 C-2.5 1.25 -2.5 1.25 0 0 Z "
      fill="#1D5A9D"
      transform="translate(29,72)"
    />
    <path
      d="M0 0 C0.33 0 0.66 0 1 0 C1 4.29 1 8.58 1 13 C0.67 13 0.34 13 0 13 C0 8.71 0 4.42 0 0 Z "
      fill="#80E180"
      transform="translate(21,47)"
    />
    <path
      d="M0 0 C0.33 0 0.66 0 1 0 C1 1.98 1 3.96 1 6 C0.67 6 0.34 6 0 6 C0 4.02 0 2.04 0 0 Z "
      fill="#E9E9E9"
      transform="translate(95,39)"
    />
    <path
      d="M0 0 C0.33 0 0.66 0 1 0 C1 1.65 1 3.3 1 5 C0.67 5 0.34 5 0 5 C0 3.35 0 1.7 0 0 Z "
      fill="#80CC80"
      transform="translate(91,83)"
    />
    <path
      d="M0 0 C0.33 0 0.66 0 1 0 C1 1.65 1 3.3 1 5 C0.67 5 0.34 5 0 5 C0 3.35 0 1.7 0 0 Z "
      fill="#197F99"
      transform="translate(19,82)"
    />
    <path
      d="M0 0 C0.33 0 0.66 0 1 0 C1 1.65 1 3.3 1 5 C0.67 5 0.34 5 0 5 C0 3.35 0 1.7 0 0 Z "
      fill="#1980B2"
      transform="translate(17,73)"
    />
    <path
      d="M0 0 C4 1 4 1 4 1 Z "
      fill="#9FBF60"
      transform="translate(69,10)"
    />
    <path
      d="M0 0 C4 1 4 1 4 1 Z "
      fill="#80FF80"
      transform="translate(52,10)"
    />
    <path d="" fill="#2A6AAA" transform="translate(0,0)" />
    <path d="" fill="#80AA80" transform="translate(0,0)" />
    <path d="" fill="#1C637F" transform="translate(0,0)" />
    <path d="" fill="#AAAAAA" transform="translate(0,0)" />
    <path d="" fill="#80D480" transform="translate(0,0)" />
    <path
      d="M0 0 C2 1 2 1 2 1 Z "
      fill="#400040"
      transform="translate(60,111)"
    />
    <path
      d="M0 0 C2 1 2 1 2 1 Z "
      fill="#7F407F"
      transform="translate(44,101)"
    />
    <path
      d="M0 0 C2 1 2 1 2 1 Z "
      fill="#008080"
      transform="translate(32,97)"
    />
    <path
      d="M0 0 C2 1 2 1 2 1 Z "
      fill="#004080"
      transform="translate(34,96)"
    />
    <path
      d="M0 0 C2 1 2 1 2 1 Z "
      fill="#004040"
      transform="translate(36,95)"
    />
    <path
      d="M0 0 C2 1 2 1 2 1 Z "
      fill="#004080"
      transform="translate(22,92)"
    />
    <path d="" fill="#406080" transform="translate(0,0)" />
    <path d="" fill="#40BF40" transform="translate(0,0)" />
    <path d="" fill="#609F60" transform="translate(0,0)" />
    <path d="" fill="#BF8080" transform="translate(0,0)" />
    <path d="" fill="#40BFFF" transform="translate(0,0)" />
    <path d="" fill="#407FFF" transform="translate(0,0)" />
    <path d="" fill="#BFBFBF" transform="translate(0,0)" />
    <path d="" fill="#009595" transform="translate(0,0)" />
    <path d="" fill="#BFBF80" transform="translate(0,0)" />
    <path d="" fill="#808080" transform="translate(0,0)" />
    <path d="" fill="#80FF80" transform="translate(0,0)" />
    <path d="" fill="#FFFFFF" transform="translate(0,0)" />
    <path d="" fill="#80FF80" transform="translate(0,0)" />
    <path d="" fill="#BFBFBF" transform="translate(0,0)" />
    <path d="" fill="#BFBFBF" transform="translate(0,0)" />
    <path d="" fill="#80FF80" transform="translate(0,0)" />
    <path d="" fill="#80FF80" transform="translate(0,0)" />
    <path d="" fill="#80BF40" transform="translate(0,0)" />
    <path d="" fill="#BFFF80" transform="translate(0,0)" />
    <path
      d="M0 0 C2 1 2 1 2 1 Z "
      fill="#80BF40"
      transform="translate(42,13)"
    />
    <path
      d="M0 0 C2 1 2 1 2 1 Z "
      fill="#BFFF40"
      transform="translate(45,12)"
    />
    <path
      d="M0 0 C2 1 2 1 2 1 Z "
      fill="#80BF80"
      transform="translate(74,11)"
    />
    <path
      d="M0 0 C2 1 2 1 2 1 Z "
      fill="#80FF80"
      transform="translate(48,11)"
    />
    <path d="" fill="#800080" transform="translate(0,0)" />
    <path d="" fill="#800080" transform="translate(0,0)" />
    <path d="" fill="#FF00FF" transform="translate(0,0)" />
    <path d="" fill="#800040" transform="translate(0,0)" />
    <path d="" fill="#800040" transform="translate(0,0)" />
    <path d="" fill="#BF4080" transform="translate(0,0)" />
    <path d="" fill="#BF4080" transform="translate(0,0)" />
    <path d="" fill="#FF8080" transform="translate(0,0)" />
    <path d="" fill="#800000" transform="translate(0,0)" />
    <path d="" fill="#800000" transform="translate(0,0)" />
    <path d="" fill="#804080" transform="translate(0,0)" />
    <path d="" fill="#FF0000" transform="translate(0,0)" />
    <path d="" fill="#FF8080" transform="translate(0,0)" />
    <path d="" fill="#BF4040" transform="translate(0,0)" />
    <path d="" fill="#800000" transform="translate(0,0)" />
    <path d="" fill="#BF4040" transform="translate(0,0)" />
    <path d="" fill="#800040" transform="translate(0,0)" />
    <path d="" fill="#BF4040" transform="translate(0,0)" />
    <path d="" fill="#BF4080" transform="translate(0,0)" />
    <path d="" fill="#FF4040" transform="translate(0,0)" />
    <path d="" fill="#FF8080" transform="translate(0,0)" />
    <path d="" fill="#800080" transform="translate(0,0)" />
    <path d="" fill="#FF8080" transform="translate(0,0)" />
    <path d="" fill="#800040" transform="translate(0,0)" />
    <path d="" fill="#800080" transform="translate(0,0)" />
    <path d="" fill="#800080" transform="translate(0,0)" />
    <path d="" fill="#FF8080" transform="translate(0,0)" />
    <path d="" fill="#008080" transform="translate(0,0)" />
    <path d="" fill="#FFFF55" transform="translate(0,0)" />
    <path d="" fill="#FFAA55" transform="translate(0,0)" />
    <path d="" fill="#000080" transform="translate(0,0)" />
    <path d="" fill="#808080" transform="translate(0,0)" />
    <path d="" fill="#FFAA00" transform="translate(0,0)" />
    <path d="" fill="#008080" transform="translate(0,0)" />
    <path d="" fill="#55AA55" transform="translate(0,0)" />
    <path d="" fill="#AAAA00" transform="translate(0,0)" />
    <path d="" fill="#008080" transform="translate(0,0)" />
    <path d="" fill="#499224" transform="translate(0,0)" />
    <path d="" fill="#80FF80" transform="translate(0,0)" />
    <path d="" fill="#804080" transform="translate(0,0)" />
    <path d="" fill="#808080" transform="translate(0,0)" />
    <path d="" fill="#808080" transform="translate(0,0)" />
    <path d="" fill="#BFBFBF" transform="translate(0,0)" />
    <path d="" fill="#808080" transform="translate(0,0)" />
    <path d="" fill="#BF8040" transform="translate(0,0)" />
    <path d="" fill="#80FF80" transform="translate(0,0)" />
    <path d="" fill="#80BF40" transform="translate(0,0)" />
    <path d="" fill="#80BF40" transform="translate(0,0)" />
    <path d="" fill="#80FF80" transform="translate(0,0)" />
    <path d="" fill="#80FF80" transform="translate(0,0)" />
    <path d="" fill="#FFFF80" transform="translate(0,0)" />
    <path d="" fill="#808080" transform="translate(0,0)" />
    <path d="" fill="#80FF80" transform="translate(0,0)" />
    <path d="" fill="#80FF80" transform="translate(0,0)" />
    <path d="" fill="#80BF40" transform="translate(0,0)" />
    <path d="" fill="#80FF80" transform="translate(0,0)" />
    <path d="" fill="#808000" transform="translate(0,0)" />
    <path d="" fill="#FFFF80" transform="translate(0,0)" />
    <path d="" fill="#80FF80" transform="translate(0,0)" />
    <path d="" fill="#80FF80" transform="translate(0,0)" />
    <path d="" fill="#80FF80" transform="translate(0,0)" />
    <path d="" fill="#80FF80" transform="translate(0,0)" />
    <path d="" fill="#808000" transform="translate(0,0)" />
    <path d="" fill="#808000" transform="translate(0,0)" />
    <path d="" fill="#80FF80" transform="translate(0,0)" />
  </svg>
);
export default SvgMaritalkIcon;
