const SvgSearchApi = (props) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    xmlnsXlink="http://www.w3.org/1999/xlink"
    version="1"
    viewBox="0 0 810 810"
    {...props}
  >
    <defs>
      <image
        xlinkHref="data:image/png;base64,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"
        id="6fe21a01f0"
        width="226"
        height="226"
        x="0"
        y="0"
        preserveAspectRatio="xMidYMid meet"
      ></image>
    </defs>
    <image
      xlinkHref="data:image/png;base64,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"
      width="226"
      height="226"
      transform="scale(3.58407)"
    ></image>
  </svg>
);
export default SvgSearchApi;
