from dataclasses import dataclass
from typing import Optional
from datetime import date

import openpyxl
from openpyxl.utils import get_column_letter

@dataclass
class SoleProprietorBeneficiary:
    # Основания / договоры
    contract_number: str
    contract_date: date

    # Регистрационные данные
    full_name: str
    inn: str
    ogrnip: str
    registration_date: date
    registration_authority: str
    registration_city: str

    # Контакты
    website: Optional[str]
    birth_date: date
    birth_place: str

    # Паспортные данные
    document_type: str
    document_number: str
    issued_by: str
    division_code: str
    issue_date: date

    # Миграционные документы (если применимо)
    migration_card_number: Optional[str]
    migration_card_expiry: Optional[date]

    # Документ на право пребывания
    residence_doc_type: Optional[str]
    residence_doc_number: Optional[str]
    residence_doc_expiry: Optional[date]

    # Адрес
    address: str

    # Публичный должностное лицо (ПДЛ)
    is_pdl: bool

    # Лицензия (если есть)
    license_type: Optional[str]
    license_number: Optional[str]
    license_expiry: Optional[date]
    license_authority: Optional[str]

    # Виды деятельности
    activities: Optional[str]


    def save_beneficiaries_to_excel(beneficiaries, filename="beneficiaries.xlsx"):
        wb = openpyxl.Workbook()
        ws = wb.active
        ws.title = "Beneficiaries"

        # Заголовки из полей dataclass
        headers = [field.name for field in beneficiaries[0].__dataclass_fields__.values()]
        ws.append(headers)

        # Заполняем строки
        for b in beneficiaries:
            ws.append([getattr(b, h) for h in headers])

        # Автоширина
        for col in ws.columns:
            max_len = max(len(str(cell.value)) if cell.value else 0 for cell in col)
            ws.column_dimensions[get_column_letter(col[0].column)].width = max_len + 2

        wb.save(filename)