import requests
from .exceptions import Bank131Error


class EscrowClient:
    def __init__(self, base_url="https://api.bank131.ru/api/v1", session=None):
        self.base_url = base_url.rstrip("/")
        self.http = session or requests.Session()

    def create_account(self, payload: dict) -> dict:
        """Создание эскроу-счёта для бенефициара"""
        url = f"{self.base_url}/escrow/account/create"
        resp = self.http.post(url, json=payload)
        if not resp.ok:
            raise Bank131Error(f"Ошибка {resp.status_code}: {resp.text}")
        return resp.json()

    def get_account(self, account_id: str) -> dict:
        """Получение информации по эскроу-счёту"""
        url = f"{self.base_url}/escrow/account/get"
        resp = self.http.post(url, json={"account_id": account_id})
        if not resp.ok:
            raise Bank131Error(f"Ошибка {resp.status_code}: {resp.text}")
        return resp.json()

    def payout(self, payload: dict) -> dict:
        """Выплата с эскроу-счёта"""
        url = f"{self.base_url}/escrow/payout"
        resp = self.http.post(url, json=payload)
        if not resp.ok:
            raise Bank131Error(f"Ошибка {resp.status_code}: {resp.text}")
        return resp.json()

    def transfer(self, payload: dict) -> dict:
        """Перевод между эскроу-счетами"""
        url = f"{self.base_url}/escrow/transfer"
        resp = self.http.post(url, json=payload)
        if not resp.ok:
            raise Bank131Error(f"Ошибка {resp.status_code}: {resp.text}")
        return resp.json()