# bank131/integrations/django.py
import json
from django.http import JsonResponse
from bank131.webhooks_core import Bank131WebhookHandler

class DjangoBank131Webhooks:
    """Адаптер вебхуков Bank131 для Django."""

    def __init__(self, client):
        self.handler = Bank131WebhookHandler(client)

    def ready_to_confirm(self, request):
        data = json.loads(request.body.decode("utf-8"))
        result = self.handler.handle("ready_to_confirm", data)
        return JsonResponse(result)

    def payment_finished(self, request):
        data = json.loads(request.body.decode("utf-8"))
        result = self.handler.handle("payment_finished", data)
        return JsonResponse(result)