# bank131/integrations/fastapi.py
from fastapi import APIRouter, Request
from bank131.webhooks_core import Bank131WebhookHandler

def get_webhook_router(client):
    handler = Bank131WebhookHandler(client)
    router = APIRouter()

    @router.post("/webhook/ready_to_confirm")
    async def ready_to_confirm(request: Request):
        data = await request.json()
        return handler.handle("ready_to_confirm", data)

    @router.post("/webhook/payment_finished")
    async def payment_finished(request: Request):
        data = await request.json()
        return handler.handle("payment_finished", data)

    return router