import json
import base64
from cryptography.hazmat.backends import default_backend
from cryptography.hazmat.primitives import serialization, hashes
from cryptography.hazmat.primitives.asymmetric import padding

class Signer:
    def __init__(self, private_key_path: str):
        with open(private_key_path, "rb") as key_file:
            self.private_key = serialization.load_pem_private_key(
                key_file.read(),
                password=None,
                backend=default_backend()
            )

    def sign(self, payload: dict) -> str:
        payload = {k: v for k, v in payload.items() if v is not None}
        data_bytes = json.dumps(payload, ensure_ascii=False, separators=(",", ":")).encode("utf-8")
        signature = self.private_key.sign(
            data_bytes,
            padding.PKCS1v15(),
            hashes.SHA256()
        )
        return base64.b64encode(signature).decode("utf-8")

    def verify_signature(self,public_key_path, payload: dict, signature: str) -> bool:
        with open(public_key_path, "rb") as key_file:
            public_key = serialization.load_pem_public_key(
                key_file.read(),
                backend=default_backend()
            )

        data_bytes = json.dumps(payload, separators=(",", ":")).encode("utf-8")
        decoded_signature = base64.b64decode(signature)

        try:
            public_key.verify(
                decoded_signature,
                data_bytes,
                padding.PKCS1v15(),
                hashes.SHA256()
            )
            return True  # Подпись действительна
        except Exception as e:
            print(f"Verification failed: {e}")
            return False  # Подпись недействительна
