class Bank131WebhookHandler:
    """
    Универсальный обработчик вебхуков Bank131, не зависящий от фреймворка.
    """

    def __init__(self, client):
        self.client = client

    def handle(self, event: str, data: dict) -> dict:
        """
        Основная точка входа.
        event: 'ready_to_confirm' или 'payment_finished'
        """
        if event == "ready_to_confirm":
            return self.on_ready_to_confirm(data)
        elif event == "payment_finished":
            return self.on_payment_finished(data)
        else:
            print(f"⚠️ Неизвестный вебхук: {event}")
            return {"status": "ignored"}

    # --- конкретные события ---

    def on_ready_to_confirm(self, data: dict) -> dict:
        session_id = data.get("session", {}).get("id")
        if session_id:
            result = self.client.confirm_session(session_id)
            print("✅ CONFIRM RESULT:", result)
        return {"status": "ok"}

    def on_payment_finished(self, data: dict) -> dict:
        print("💰 PAYMENT FINISHED:", data)
        return {"status": "ok"}


