# bank131/widget.py
def generate_payment_form_html(public_token: str, success_url: str = "/success", fail_url: str = "/fail") -> str:
    """
    Возвращает HTML-код страницы с платёжной формой Bank131.
    """
    return f"""
    <!DOCTYPE html>
    <html lang="ru">
    <head>
        <meta charset="utf-8">
        <title>Оплата</title>
        <link href="https://widget-demo.bank131.ru/payment-form.css" rel="stylesheet" />
        <script src="https://widget-demo.bank131.ru/payment-form.js" defer></script>
    </head>
    <body>
        <div id="bank131-payment-form"></div>
        <script>
        document.addEventListener('DOMContentLoaded', function() {{
            if (!window.Bank131PaymentForm) return;
            const paymentForm = new Bank131PaymentForm('{public_token}', {{
                isCvcMasked: true,
                customerInteractionRedirect: {{ target: "_blank" }},
            }});
            paymentForm.onPaymentSuccess = () => window.location.href = '{success_url}';
            paymentForm.onPaymentFail = () => window.location.href = '{fail_url}';
            paymentForm.render();
        }});
        </script>
    </body>
    </html>
    """