import responses
from bank131.client import Bank131Client


@responses.activate
def test_create_session(tmp_path):
    # Временный ключ (заглушка)
    private_key = tmp_path / "key.pem"
    private_key.write_text(
        "-----BEGIN PRIVATE KEY-----\nFAKEKEYDATA\n-----END PRIVATE KEY-----"
    )

    client = Bank131Client("test_project", str(private_key), "https://demo.bank131.ru/api/v1")

    responses.add(
        responses.POST,
        "https://demo.bank131.ru/api/v1/session/create",
        json={"id": "123", "status": "created"},
        status=200
    )

    result = client.create_session(1000, "RUB", "Test")
    assert result["status"] == "created"
