"""Initialization.

This submodule incorporates modified source code from the python-bibtexparser project
(https://github.com/sciunto-org/python-bibtexparser), which is licensed under the MIT License.
The original copyright notice and license terms have been preserved in accordance with the license requirements.
"""

__all__ = [
    "Block",
    "Field",
    "Entry",
    "ImplicitComment",
    "ExplicitComment",
    "String",
    "Preamble",
    "ParsingFailedBlock",
    "DuplicateBlockKeyBlock",
    "Library",

    "MiddlewaresStrToStr",
    "MiddlewaresStrToLibrary",
    "MiddlewaresLibraryToLibrary",
    "MiddlewaresLibraryToStr",

    "Splitter",

    "BibtexFormat",
]

from .bibtex_format import BibtexFormat
from .library import Library
from .middlewares_library_to_library import MiddlewaresLibraryToLibrary
from .middlewares_library_to_str import MiddlewaresLibraryToStr
from .middlewares_str_to_library import MiddlewaresStrToLibrary
from .middlewares_str_to_str import MiddlewaresStrToStr
from .model import (
    Block,
    DuplicateBlockKeyBlock,
    Entry,
    ExplicitComment,
    Field,
    ImplicitComment,
    ParsingFailedBlock,
    Preamble,
    String,
)
from .splitter import Splitter
