# Development Commands

## Testing
```bash
# Run all tests
uv run pytest

# Run single test file
uv run pytest tests/test_fftlog.py

# Run with verbose output
uv run pytest -v tests/test_fftlog.py
```

## Linting & Formatting
```bash
# Lint and fix
ruff check . --fix

# Format code
ruff format .
```

## Dependencies
```bash
# Install core dependencies
uv sync

# Install with dev dependencies
uv sync --group dev
```

# Code Style Guidelines

## Imports
- Use absolute imports from package root
- Group imports: stdlib, third-party, local
- Import specific classes/functions, not modules with `from module import *`

## Formatting & Types
- Follow ruff formatting (Black-compatible)
- Use type hints for all public APIs
- Prefer `numpy.typing.NDArray` over `np.ndarray`

## Naming Conventions
- Classes: PascalCase (FFTLog, Grid, Kernel)
- Functions/variables: snake_case
- Constants: UPPER_SNAKE_CASE
- Private methods: prefix with underscore

## Error Handling
- Use descriptive error messages with context
- Raise ValueError for invalid input parameters
- Use custom exceptions for domain-specific errors

## Documentation
- Add docstrings for all public classes and methods
- Use numpy-style docstring format
- Include parameter types and return values