from pydantic_settings import BaseSettings
from pydantic import Field


class Settings(BaseSettings):
    base_issuer_url: str = Field(...)
    oauth_client_id: str = Field(...)
    oauth_client_secret: str = Field(...)

    class Config:
        env_file = ".env"   # Each service can have its own .env
        # If you want a prefix like IKON_, uncomment this:
        # env_prefix = "IKON_"


# This will read from env vars / .env of the *service* using the package
settings = Settings()
