# Generated by Django 4.2.18 on 2025-02-03 13:08

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    replaces = [
        ('projects', '0002_initial'),
        ('projects', '0003_project_retention_max_event_count'),
        ('projects', '0004_project_quota_exceeded_until'),
        ('projects', '0005_project_ingested_event_count'),
        ('projects', '0006_initial_ingested_count_value'),
        ('projects', '0007_rename_ingested_event_count_project_digested_event_count'),
        ('projects', '0008_project_next_quota_check'),
        ('projects', '0009_alter_project_visibility'),
    ]

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("teams", "0001_initial"),  # defines the Team model, which we have a FK to
        ("projects", "0001_initial"),  # this is the previous migration
    ]

    operations = [
        migrations.AddField(
            model_name="project",
            name="digested_event_count",
            field=models.PositiveIntegerField(default=0, editable=False),
        ),
        migrations.AddField(
            model_name="project",
            name="next_quota_check",
            field=models.PositiveIntegerField(default=0),
        ),
        migrations.AddField(
            model_name="project",
            name="quota_exceeded_until",
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="project",
            name="retention_max_event_count",
            field=models.PositiveIntegerField(default=10000),
        ),
        migrations.AddField(
            model_name="project",
            name="team",
            field=models.ForeignKey(
                null=True, on_delete=django.db.models.deletion.SET_NULL, to="teams.team"
            ),
        ),
        migrations.AddField(
            model_name="project",
            name="users",
            field=models.ManyToManyField(
                blank=True,
                through="projects.ProjectMembership",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="projectmembership",
            name="user",
            field=models.ForeignKey(
                default=1,  # unused; this migration is run against no-rows
                on_delete=django.db.models.deletion.CASCADE,
                to=settings.AUTH_USER_MODEL,
            ),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="project",
            name="visibility",
            field=models.IntegerField(
                choices=[(1, "Joinable"), (10, "Discoverable"), (99, "Team Members")],
                default=99,
                help_text="Which users can see this project and its issues?",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="projectmembership",
            unique_together={("project", "user")},
        ),
    ]
