# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2025-06-30T15:28:49+00:00

from __future__ import annotations

from enum import Enum
from typing import Dict, List, Optional

from pydantic import BaseModel, conint


class AnalysisOption(BaseModel):
    dimensionality: str
    id: conint(ge=0)
    max_iterations: Optional[conint(ge=0)] = None
    order: str
    solve_loadcases: bool
    solver: str
    tolerance: float


class GeneralInfo(BaseModel):
    author: str
    project_name: str
    version: str


class LoadCombination(BaseModel):
    check: str
    load_cases_factors: Dict[str, float]
    load_combination_id: conint(ge=0)
    name: str
    situation: Optional[str] = None


class Material(BaseModel):
    density: float
    eMod: float
    gMod: float
    id: conint(ge=0)
    name: str
    yieldStress: float


class MemberHinge(BaseModel):
    hinge_type: str
    id: conint(ge=0)
    max_moment_mx: Optional[float] = None
    max_moment_my: Optional[float] = None
    max_moment_mz: Optional[float] = None
    max_tension_vx: Optional[float] = None
    max_tension_vy: Optional[float] = None
    max_tension_vz: Optional[float] = None
    rotational_release_mx: Optional[float] = None
    rotational_release_my: Optional[float] = None
    rotational_release_mz: Optional[float] = None
    translational_release_vx: Optional[float] = None
    translational_release_vy: Optional[float] = None
    translational_release_vz: Optional[float] = None


class MemberResultMap(BaseModel):
    data: Dict[str, Dict[str, float]]


class MemberType(Enum):
    Normal = "Normal"
    Truss = "Truss"
    Tension = "Tension"
    Compression = "Compression"
    Rigid = "Rigid"


class NodalLoad(BaseModel):
    direction: List
    id: conint(ge=0)
    load_case: conint(ge=0)
    load_type: str
    magnitude: float
    node: conint(ge=0)


class NodalMoment(BaseModel):
    direction: List
    id: conint(ge=0)
    load_case: conint(ge=0)
    load_type: str
    magnitude: float
    node: conint(ge=0)


class NodalSupport(BaseModel):
    classification: Optional[str] = None
    displacement_conditions: Dict[str, str]
    id: conint(ge=0)
    rotation_conditions: Dict[str, str]


class Node(BaseModel):
    X: float
    Y: float
    Z: float
    id: conint(ge=0)
    nodal_support: Optional[conint(ge=0)] = None


class NodeDisplacement(BaseModel):
    dx: float
    dy: float
    dz: float
    rx: float
    ry: float
    rz: float


class NodeForces(BaseModel):
    fx: float
    fy: float
    fz: float
    mx: float
    my: float
    mz: float


class ReactionForce(BaseModel):
    fx: float
    fy: float
    fz: float
    mx: float
    my: float
    mz: float
    support_id: conint(ge=0)


class ResultsSummary(BaseModel):
    total_displacements: conint(ge=0)
    total_member_forces: conint(ge=0)
    total_reaction_forces: conint(ge=0)


class Section(BaseModel):
    area: float
    b: Optional[float] = None
    h: Optional[float] = None
    i_y: float
    i_z: float
    id: conint(ge=0)
    j: float
    material: conint(ge=0)
    name: str
    shape_path: Optional[conint(ge=0)] = None


class Settings(BaseModel):
    analysis_option: AnalysisOption
    general_info: GeneralInfo
    id: conint(ge=0)


class ShapeCommand(BaseModel):
    command: str
    control_y1: Optional[float] = None
    control_y2: Optional[float] = None
    control_z1: Optional[float] = None
    control_z2: Optional[float] = None
    r: Optional[float] = None
    y: Optional[float] = None
    z: Optional[float] = None


class ShapePath(BaseModel):
    id: conint(ge=0)
    name: str
    shape_commands: List[ShapeCommand]


class Member(BaseModel):
    chi: Optional[float] = None
    classification: str
    end_hinge: Optional[conint(ge=0)] = None
    end_node: Node
    id: conint(ge=0)
    member_type: MemberType
    reference_member: Optional[conint(ge=0)] = None
    reference_node: Optional[conint(ge=0)] = None
    rotation_angle: float
    section: conint(ge=0)
    start_hinge: Optional[conint(ge=0)] = None
    start_node: Node
    weight: float


class MemberForce(BaseModel):
    end_node_forces: NodeForces
    member_id: conint(ge=0)
    start_node_forces: NodeForces


class MemberSet(BaseModel):
    classification: Optional[str] = None
    id: conint(ge=0)
    l_y: Optional[float] = None
    l_z: Optional[float] = None
    members: List[Member]


class Results(BaseModel):
    displacement_nodes: Dict[str, NodeDisplacement]
    member_forces: List[MemberForce]
    member_maximums: Optional[MemberResultMap] = None
    member_minimums: Optional[MemberResultMap] = None
    name: str
    reaction_forces: List[ReactionForce]
    result_type: str
    summary: ResultsSummary


class RotationImperfection(BaseModel):
    axis: List
    axis_only: bool
    magnitude: float
    memberset: List[MemberSet]
    point: List


class TranslationImperfection(BaseModel):
    axis: List
    magnitude: float
    memberset: List[MemberSet]


class ImperfectionCase(BaseModel):
    imperfection_case_id: conint(ge=0)
    load_combinations: List[LoadCombination]
    rotation_imperfections: List[RotationImperfection]
    translation_imperfections: List[TranslationImperfection]


class LineLoad(BaseModel):
    direction: List
    end_pos: float
    load_case: conint(ge=0)
    magnitude: float
    member: Member
    start_pos: float


class LoadCase(BaseModel):
    distributed_loads: List[LineLoad]
    id: conint(ge=0)
    name: str
    nodal_loads: List[NodalLoad]
    nodal_moments: List[NodalMoment]
    rotation_imperfections: List[RotationImperfection]
    translation_imperfections: List[TranslationImperfection]


class FERS(BaseModel):
    imperfection_cases: List[ImperfectionCase]
    load_cases: List[LoadCase]
    load_combinations: List[LoadCombination]
    materials: List[Material]
    member_sets: List[MemberSet]
    memberhinges: Optional[List[MemberHinge]] = None
    nodal_supports: List[NodalSupport]
    results: Optional[Results] = None
    sections: List[Section]
    settings: Settings
    shape_paths: Optional[List[ShapePath]] = None
