/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.gitlog;

import net.sourceforge.plantuml.gitlog.Commit;
import net.sourceforge.plantuml.gitlog.GitTextArea;

public class CursorPosition {
    private final int x;
    private final int y;
    private final GitTextArea source;

    public CursorPosition(GitTextArea source, int x, int y) {
        this.source = source;
        this.x = x;
        this.y = y;
    }

    private String getCurrentLine() {
        return this.source.getLine(this.y);
    }

    public String toString() {
        return "(" + (this.x + 1) + "," + (this.y + 1) + ")";
    }

    public CursorPosition move(int dx, int dy) {
        return new CursorPosition(this.source, this.x + dx, this.y + dy);
    }

    public boolean matches(String prefix) {
        if (this.x < 0) {
            return false;
        }
        String line = this.getCurrentLine();
        if (this.x > line.length()) {
            return false;
        }
        return line.substring(this.x).startsWith(prefix);
    }

    public String getCommentInLine() {
        String line = this.getCurrentLine();
        int x = line.indexOf("*");
        if (x == -1) {
            return null;
        }
        int y = line.indexOf("(", x);
        if (y == -1) {
            return null;
        }
        int z = line.indexOf(")", y);
        if (z == -1) {
            return null;
        }
        return line.substring(y + 1, z);
    }

    public static String getCommitNameInLine(String s2) {
        int x = s2.indexOf("*");
        if (x == -1) {
            return null;
        }
        int space = (s2 = s2.replaceAll("[-.*|/\\\\]", "").trim()).indexOf(" ");
        if (space == -1) {
            return s2;
        }
        String name = s2.substring(0, space);
        return name;
    }

    public String getCommitDefinition() {
        return CursorPosition.getCommitNameInLine(this.getCurrentLine().substring(this.x));
    }

    public Commit getCommit() {
        return new Commit(this.getCommitDefinition(), this);
    }

    public CursorPosition getDownFromHere() {
        return CursorPosition.getDownFromInternal(this);
    }

    private static CursorPosition getDownFromInternal(CursorPosition current) {
        while (true) {
            if (current.matches("* ")) {
                return current;
            }
            if (current.matches("/") && current.move(-2, 0).matches("_|/")) {
                current = current.move(-2, 0);
                continue;
            }
            if (current.matches("_") && current.move(-2, 0).matches("_|_")) {
                current = current.move(-2, 0);
                continue;
            }
            if (current.matches("_") && current.move(-2, 1).matches("/")) {
                current = current.move(-2, 1);
                continue;
            }
            if (current.matches("|") && current.move(0, 1).matches("* ")) {
                current = current.move(0, 1);
                continue;
            }
            if (current.matches("|") && current.move(0, 1).matches("|")) {
                current = current.move(0, 1);
                continue;
            }
            if (current.matches("| ") && current.move(0, 1).matches(" \\") && current.move(2, 2).matches("|")) {
                current = current.move(2, 2);
                continue;
            }
            if (current.matches("| ") && current.move(0, 1).matches(" \\") && current.move(2, 2).matches("\\")) {
                current = current.move(2, 2);
                continue;
            }
            if (current.matches("| ") && current.move(-1, 1).matches("/ ") && current.move(-2, 2).matches("* ")) {
                current = current.move(-2, 2);
                continue;
            }
            if (current.matches("| ") && current.move(-3, 1).matches("_|/ ")) {
                current = current.move(-3, 1);
                continue;
            }
            if (current.matches("| ") && current.move(-1, 1).matches("/ ") && current.move(-2, 2).matches("| ")) {
                current = current.move(-2, 2);
                continue;
            }
            if (current.matches("| ") && current.move(-3, 1).matches("_|/")) {
                current = current.move(-3, 1);
                continue;
            }
            if (current.matches("| ") && current.move(0, 1).matches(" \\") && current.move(1, 2).matches("/ ")) {
                current = current.move(1, 2);
                continue;
            }
            if (current.matches("| ") && current.move(0, 1).matches(" \\") && current.move(2, 2).matches("* ")) {
                current = current.move(2, 2);
                continue;
            }
            if (current.matches("\\ ") && current.move(1, 1).matches("* ")) {
                current = current.move(1, 1);
                continue;
            }
            if (current.matches(" \\")) {
                current = current.move(2, 1);
                continue;
            }
            if (current.matches("\\ ") && current.move(0, 1).matches("/ ")) {
                current = current.move(0, 1);
                continue;
            }
            if (current.matches("\\ ") && current.move(1, 1).matches("\\ ")) {
                current = current.move(1, 1);
                continue;
            }
            if (current.matches("\\ ") && current.move(1, 1).matches("|")) {
                current = current.move(1, 1);
                continue;
            }
            if (current.matches("/ ") && current.move(-1, 1).matches("/ ")) {
                current = current.move(-1, 1);
                continue;
            }
            if (current.matches("/ ") && current.move(-2, 1).matches("/| ")) {
                current = current.move(-2, 1);
                continue;
            }
            if (current.matches("/") && current.move(-1, 1).matches("* ")) {
                current = current.move(-1, 1);
                continue;
            }
            if (!current.matches("/") || !current.move(-1, 1).matches("|")) break;
            current = current.move(-1, 1);
        }
        System.err.println("this=" + current);
        throw new UnsupportedOperationException(current.toString());
    }
}

