/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.util.List;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.EntityPortion;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.FontParam;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.CircledCharacter;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockGeneric;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.skin.SkinParamUtils;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.HeaderLayout;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.text.Guillemet;

public class EntityImageClassHeader
extends AbstractEntityImage {
    private final HeaderLayout headerLayout;

    public EntityImageClassHeader(Entity entity, PortionShower portionShower) {
        super(entity);
        TextBlock genericBlock;
        boolean italic = entity.getLeafType() == LeafType.ABSTRACT_CLASS || entity.getLeafType() == LeafType.INTERFACE;
        Stereotype stereotype = entity.getStereotype();
        boolean displayGenericWithOldFashion = this.getSkinParam().displayGenericWithOldFashion();
        String generic = displayGenericWithOldFashion ? null : entity.getGeneric();
        Style styleHeader = StyleSignatureBasic.of(SName.root, SName.element, SName.classDiagram, SName.class_, SName.header).withTOBECHANGED(stereotype).with(entity.getStereostyles()).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
        FontConfiguration fontConfigurationName = FontConfiguration.create(this.getSkinParam(), styleHeader, entity.getColors());
        if (italic) {
            fontConfigurationName = fontConfigurationName.italic();
        }
        Display display = entity.getDisplay();
        if (displayGenericWithOldFashion && entity.getGeneric() != null) {
            display = display.addGeneric(entity.getGeneric());
        }
        TextBlock name = display.create8(fontConfigurationName, HorizontalAlignment.CENTER, this.getSkinParam(), CreoleMode.FULL_BUT_UNDERSCORE, styleHeader.wrapWidth());
        VisibilityModifier modifier = entity.getVisibilityModifier();
        if (modifier == null) {
            name = TextBlockUtils.withMargin(name, 3.0, 3.0, 0.0, 0.0);
        } else {
            Rose rose = new Rose();
            HColor back = rose.getHtmlColor(this.getSkinParam(), modifier.getBackground());
            HColor fore = rose.getHtmlColor(this.getSkinParam(), modifier.getForeground());
            TextBlock uBlock = modifier.getUBlock(this.getSkinParam().classAttributeIconSize(), fore, back, false);
            name = TextBlockUtils.mergeLR(uBlock, name, VerticalAlignment.CENTER);
            name = TextBlockUtils.withMargin(name, 3.0, 3.0, 0.0, 0.0);
        }
        List<String> stereotypeLabels = portionShower.getVisibleStereotypeLabels(entity);
        TextBlock stereo = stereotype == null || stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR) == null || stereotypeLabels.isEmpty() ? null : TextBlockUtils.withMargin(Display.create(stereotypeLabels).create(FontConfiguration.create(this.getSkinParam(), FontParam.CLASS_STEREOTYPE, stereotype), HorizontalAlignment.CENTER, this.getSkinParam()), 1.0, 0.0);
        if (generic == null) {
            genericBlock = null;
        } else {
            Style styleGeneric = StyleSignatureBasic.of(SName.root, SName.element, SName.classDiagram, SName.class_, SName.generic).withTOBECHANGED(stereotype).with(entity.getStereostyles()).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
            genericBlock = Display.getWithNewlines(this.getSkinParam().getPragma(), generic).create(FontConfiguration.create(this.getSkinParam(), FontParam.CLASS_STEREOTYPE, stereotype), HorizontalAlignment.CENTER, this.getSkinParam());
            genericBlock = TextBlockUtils.withMargin(genericBlock, 1.0, 1.0);
            HColor classBackground = styleGeneric.value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet());
            HColor classBorder = styleGeneric.value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
            genericBlock = new TextBlockGeneric(genericBlock, classBackground, classBorder);
            genericBlock = TextBlockUtils.withMargin(genericBlock, 1.0, 1.0);
        }
        TextBlock circledCharacter = portionShower.showPortion(EntityPortion.CIRCLED_CHARACTER, this.getEntity()) ? TextBlockUtils.withMargin(this.getCircledCharacter(entity, this.getSkinParam()), 4.0, 0.0, 5.0, 5.0) : null;
        this.headerLayout = new HeaderLayout(circledCharacter, stereo, name, genericBlock);
    }

    private TextBlock getCircledCharacter(Entity entity, ISkinParam skinParam) {
        Stereotype stereotype = entity.getStereotype();
        if (stereotype != null && stereotype.getSprite(skinParam) != null) {
            return stereotype.getSprite(skinParam);
        }
        UFont font = SkinParamUtils.getFont(this.getSkinParam(), FontParam.CIRCLED_CHARACTER, null);
        LeafType leafType = entity.getLeafType();
        Style style = this.spotStyleSignature(leafType).getMergedStyle(skinParam.getCurrentStyleBuilder());
        HColor spotBorder = style.value(PName.LineColor).asColor(skinParam.getIHtmlColorSet());
        HColor spotBackColor = style.value(PName.BackGroundColor).asColor(skinParam.getIHtmlColorSet());
        HColor fontColor = style.value(PName.FontColor).asColor(skinParam.getIHtmlColorSet());
        if (stereotype != null && stereotype.getCharacter() != '\u0000') {
            return new CircledCharacter(stereotype.getCharacter(), this.getSkinParam().getCircledCharacterRadius(), font, stereotype.getHtmlColor() == null ? spotBackColor : stereotype.getHtmlColor(), spotBorder, fontColor);
        }
        char circledChar = '\u0000';
        if (stereotype != null) {
            circledChar = this.getSkinParam().getCircledCharacter(stereotype);
        }
        if (circledChar == '\u0000') {
            circledChar = this.getCircledChar(leafType);
        }
        return new CircledCharacter(circledChar, this.getSkinParam().getCircledCharacterRadius(), font, spotBackColor, spotBorder, fontColor);
    }

    private StyleSignatureBasic spotStyleSignature(LeafType leafType) {
        switch (leafType) {
            case ANNOTATION: {
                return StyleSignatureBasic.of(SName.root, SName.element, SName.spot, SName.spotAnnotation);
            }
            case ABSTRACT_CLASS: {
                return StyleSignatureBasic.of(SName.root, SName.element, SName.spot, SName.spotAbstractClass);
            }
            case CLASS: {
                return StyleSignatureBasic.of(SName.root, SName.element, SName.spot, SName.spotClass);
            }
            case INTERFACE: {
                return StyleSignatureBasic.of(SName.root, SName.element, SName.spot, SName.spotInterface);
            }
            case ENUM: {
                return StyleSignatureBasic.of(SName.root, SName.element, SName.spot, SName.spotEnum);
            }
            case ENTITY: {
                return StyleSignatureBasic.of(SName.root, SName.element, SName.spot, SName.spotEntity);
            }
            case PROTOCOL: {
                return StyleSignatureBasic.of(SName.root, SName.element, SName.spot, SName.spotProtocol);
            }
            case STRUCT: {
                return StyleSignatureBasic.of(SName.root, SName.element, SName.spot, SName.spotStruct);
            }
            case EXCEPTION: {
                return StyleSignatureBasic.of(SName.root, SName.element, SName.spot, SName.spotException);
            }
            case METACLASS: {
                return StyleSignatureBasic.of(SName.root, SName.element, SName.spot, SName.spotMetaClass);
            }
            case STEREOTYPE: {
                return StyleSignatureBasic.of(SName.root, SName.element, SName.spot, SName.spotStereotype);
            }
        }
        throw new IllegalStateException();
    }

    private char getCircledChar(LeafType leafType) {
        switch (leafType) {
            case ANNOTATION: {
                return '@';
            }
            case ABSTRACT_CLASS: {
                return 'A';
            }
            case CLASS: {
                return 'C';
            }
            case INTERFACE: {
                return 'I';
            }
            case ENUM: {
                return 'E';
            }
            case ENTITY: {
                return 'E';
            }
            case PROTOCOL: {
                return 'P';
            }
            case STRUCT: {
                return 'S';
            }
            case EXCEPTION: {
                return 'X';
            }
            case METACLASS: {
                return 'M';
            }
            case STEREOTYPE: {
                return 'S';
            }
        }
        assert (false);
        return '?';
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return this.headerLayout.getDimension(stringBounder);
    }

    @Override
    public final void drawU(UGraphic ug) {
        throw new UnsupportedOperationException();
    }

    public void drawU(UGraphic ug, double width, double height) {
        this.headerLayout.drawU(ug, width, height);
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }
}

