/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim.builtin;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.json.Json;
import net.sourceforge.plantuml.json.JsonObject;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.preproc.Stdlib;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TFunctionSignature;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.builtin.SimpleReturnFunction;
import net.sourceforge.plantuml.tim.expression.TValue;

public class GetStdlib
extends SimpleReturnFunction {
    @Override
    public TFunctionSignature getSignature() {
        return new TFunctionSignature("%get_stdlib", 1);
    }

    @Override
    public boolean canCover(int nbArg, Set<String> namedArgument) {
        return nbArg == 0 || nbArg == 1 || nbArg == 2;
    }

    @Override
    public TValue executeReturnFunction(TContext context, TMemory memory, StringLocated location, List<TValue> values, Map<String, TValue> named) throws EaterException {
        JsonObject result = Json.object();
        try {
            if (values.size() == 0) {
                for (String folderName : Stdlib.getAllFolderNames()) {
                    Stdlib folder = Stdlib.retrieve(folderName);
                    JsonObject metadata = Json.object();
                    for (Map.Entry<String, String> ent : folder.getMetadata().entrySet()) {
                        metadata.add(ent.getKey().toLowerCase(), ent.getValue());
                    }
                    result.add(folderName, metadata);
                }
            } else if (values.size() == 1) {
                String folderName = values.get(0).toString();
                Stdlib folder = Stdlib.retrieve(folderName);
                for (Map.Entry<String, String> ent : folder.getMetadata().entrySet()) {
                    result.add(ent.getKey().toLowerCase(), ent.getValue());
                }
            } else if (values.size() == 2) {
                String folderName = values.get(0).toString();
                String key = values.get(1).toString().toLowerCase();
                Stdlib folder = Stdlib.retrieve(folderName);
                String value = folder.getMetadata().get(key);
                if (value == null) {
                    value = folder.getMetadata().get(key.toUpperCase());
                }
                if (value == null) {
                    value = "";
                }
                return TValue.fromString(value);
            }
        }
        catch (IOException e) {
            Logme.error(e);
        }
        return TValue.fromJson(result);
    }
}

