# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

import os
from typing import Any, cast

import pytest

from perplexity import Perplexity, AsyncPerplexity
from tests.utils import assert_matches_type
from perplexity.types.async_.chat import (
    CompletionGetResponse,
    CompletionListResponse,
    CompletionCreateResponse,
)

base_url = os.environ.get("TEST_API_BASE_URL", "http://127.0.0.1:4010")


class TestCompletions:
    parametrize = pytest.mark.parametrize("client", [False, True], indirect=True, ids=["loose", "strict"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_method_create(self, client: Perplexity) -> None:
        completion = client.async_.chat.completions.create(
            request={
                "messages": [
                    {
                        "content": "string",
                        "role": "system",
                    }
                ],
                "model": "model",
            },
        )
        assert_matches_type(CompletionCreateResponse, completion, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_method_create_with_all_params(self, client: Perplexity) -> None:
        completion = client.async_.chat.completions.create(
            request={
                "messages": [
                    {
                        "content": "string",
                        "role": "system",
                        "reasoning_steps": [
                            {
                                "thought": "thought",
                                "execute_python": {
                                    "code": "code",
                                    "result": "result",
                                },
                                "fetch_url_content": {
                                    "contents": [
                                        {
                                            "title": "title",
                                            "url": "url",
                                            "date": "date",
                                            "last_updated": "last_updated",
                                            "snippet": "snippet",
                                            "source": "web",
                                        }
                                    ]
                                },
                                "type": "type",
                                "web_search": {
                                    "search_keywords": ["string"],
                                    "search_results": [
                                        {
                                            "title": "title",
                                            "url": "url",
                                            "date": "date",
                                            "last_updated": "last_updated",
                                            "snippet": "snippet",
                                            "source": "web",
                                        }
                                    ],
                                },
                            }
                        ],
                        "tool_call_id": "tool_call_id",
                        "tool_calls": [
                            {
                                "id": "id",
                                "function": {
                                    "arguments": "arguments",
                                    "name": "name",
                                },
                                "type": "function",
                            }
                        ],
                    }
                ],
                "model": "model",
                "_debug_pro_search": True,
                "_force_new_agent": True,
                "_inputs": [0],
                "_prompt_token_length": 0,
                "best_of": 0,
                "country": "country",
                "cum_logprobs": True,
                "disable_search": True,
                "diverse_first_token": True,
                "enable_search_classifier": True,
                "file_workspace_id": "file_workspace_id",
                "frequency_penalty": -2,
                "has_image_url": True,
                "image_domain_filter": ["string"],
                "image_format_filter": ["string"],
                "language_preference": "language_preference",
                "last_updated_after_filter": "last_updated_after_filter",
                "last_updated_before_filter": "last_updated_before_filter",
                "latitude": 0,
                "logprobs": True,
                "longitude": 0,
                "max_tokens": 1,
                "n": 1,
                "num_images": 0,
                "num_search_results": 0,
                "parallel_tool_calls": True,
                "presence_penalty": -2,
                "ranking_model": "ranking_model",
                "reasoning_effort": "minimal",
                "response_format": {"type": "text"},
                "response_metadata": {"foo": "bar"},
                "return_images": True,
                "return_related_questions": True,
                "safe_search": True,
                "search_after_date_filter": "search_after_date_filter",
                "search_before_date_filter": "search_before_date_filter",
                "search_domain_filter": ["string"],
                "search_internal_properties": {"foo": "bar"},
                "search_language_filter": ["string"],
                "search_mode": "web",
                "search_recency_filter": "hour",
                "search_tenant": "search_tenant",
                "stop": "string",
                "stream": True,
                "stream_mode": "full",
                "temperature": 0,
                "thread_id": "thread_id",
                "tool_choice": "none",
                "tools": [
                    {
                        "function": {
                            "description": "description",
                            "name": "name",
                            "parameters": {
                                "properties": {"foo": "bar"},
                                "type": "type",
                                "additional_properties": True,
                                "required": ["string"],
                            },
                            "strict": True,
                        },
                        "type": "function",
                    }
                ],
                "top_k": 0,
                "top_logprobs": 0,
                "top_p": 0,
                "updated_after_timestamp": 0,
                "updated_before_timestamp": 0,
                "use_threads": True,
                "user_original_query": "user_original_query",
                "web_search_options": {
                    "image_results_enhanced_relevance": True,
                    "search_context_size": "low",
                    "search_type": "fast",
                    "user_location": {
                        "city": "city",
                        "country": "country",
                        "latitude": 0,
                        "longitude": 0,
                        "region": "region",
                    },
                },
            },
            idempotency_key="idempotency_key",
        )
        assert_matches_type(CompletionCreateResponse, completion, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_raw_response_create(self, client: Perplexity) -> None:
        response = client.async_.chat.completions.with_raw_response.create(
            request={
                "messages": [
                    {
                        "content": "string",
                        "role": "system",
                    }
                ],
                "model": "model",
            },
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        completion = response.parse()
        assert_matches_type(CompletionCreateResponse, completion, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_streaming_response_create(self, client: Perplexity) -> None:
        with client.async_.chat.completions.with_streaming_response.create(
            request={
                "messages": [
                    {
                        "content": "string",
                        "role": "system",
                    }
                ],
                "model": "model",
            },
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            completion = response.parse()
            assert_matches_type(CompletionCreateResponse, completion, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_method_list(self, client: Perplexity) -> None:
        completion = client.async_.chat.completions.list()
        assert_matches_type(CompletionListResponse, completion, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_raw_response_list(self, client: Perplexity) -> None:
        response = client.async_.chat.completions.with_raw_response.list()

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        completion = response.parse()
        assert_matches_type(CompletionListResponse, completion, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_streaming_response_list(self, client: Perplexity) -> None:
        with client.async_.chat.completions.with_streaming_response.list() as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            completion = response.parse()
            assert_matches_type(CompletionListResponse, completion, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_method_get(self, client: Perplexity) -> None:
        completion = client.async_.chat.completions.get(
            api_request="api_request",
        )
        assert_matches_type(CompletionGetResponse, completion, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_method_get_with_all_params(self, client: Perplexity) -> None:
        completion = client.async_.chat.completions.get(
            api_request="api_request",
            local_mode=True,
            x_client_env="x-client-env",
            x_client_name="x-client-name",
            x_created_at_epoch_seconds="x-created-at-epoch-seconds",
            x_request_time="x-request-time",
            x_usage_tier="x-usage-tier",
            x_user_id="x-user-id",
        )
        assert_matches_type(CompletionGetResponse, completion, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_raw_response_get(self, client: Perplexity) -> None:
        response = client.async_.chat.completions.with_raw_response.get(
            api_request="api_request",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        completion = response.parse()
        assert_matches_type(CompletionGetResponse, completion, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_streaming_response_get(self, client: Perplexity) -> None:
        with client.async_.chat.completions.with_streaming_response.get(
            api_request="api_request",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            completion = response.parse()
            assert_matches_type(CompletionGetResponse, completion, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    def test_path_params_get(self, client: Perplexity) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `api_request` but received ''"):
            client.async_.chat.completions.with_raw_response.get(
                api_request="",
            )


class TestAsyncCompletions:
    parametrize = pytest.mark.parametrize(
        "async_client", [False, True, {"http_client": "aiohttp"}], indirect=True, ids=["loose", "strict", "aiohttp"]
    )

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_method_create(self, async_client: AsyncPerplexity) -> None:
        completion = await async_client.async_.chat.completions.create(
            request={
                "messages": [
                    {
                        "content": "string",
                        "role": "system",
                    }
                ],
                "model": "model",
            },
        )
        assert_matches_type(CompletionCreateResponse, completion, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_method_create_with_all_params(self, async_client: AsyncPerplexity) -> None:
        completion = await async_client.async_.chat.completions.create(
            request={
                "messages": [
                    {
                        "content": "string",
                        "role": "system",
                        "reasoning_steps": [
                            {
                                "thought": "thought",
                                "execute_python": {
                                    "code": "code",
                                    "result": "result",
                                },
                                "fetch_url_content": {
                                    "contents": [
                                        {
                                            "title": "title",
                                            "url": "url",
                                            "date": "date",
                                            "last_updated": "last_updated",
                                            "snippet": "snippet",
                                            "source": "web",
                                        }
                                    ]
                                },
                                "type": "type",
                                "web_search": {
                                    "search_keywords": ["string"],
                                    "search_results": [
                                        {
                                            "title": "title",
                                            "url": "url",
                                            "date": "date",
                                            "last_updated": "last_updated",
                                            "snippet": "snippet",
                                            "source": "web",
                                        }
                                    ],
                                },
                            }
                        ],
                        "tool_call_id": "tool_call_id",
                        "tool_calls": [
                            {
                                "id": "id",
                                "function": {
                                    "arguments": "arguments",
                                    "name": "name",
                                },
                                "type": "function",
                            }
                        ],
                    }
                ],
                "model": "model",
                "_debug_pro_search": True,
                "_force_new_agent": True,
                "_inputs": [0],
                "_prompt_token_length": 0,
                "best_of": 0,
                "country": "country",
                "cum_logprobs": True,
                "disable_search": True,
                "diverse_first_token": True,
                "enable_search_classifier": True,
                "file_workspace_id": "file_workspace_id",
                "frequency_penalty": -2,
                "has_image_url": True,
                "image_domain_filter": ["string"],
                "image_format_filter": ["string"],
                "language_preference": "language_preference",
                "last_updated_after_filter": "last_updated_after_filter",
                "last_updated_before_filter": "last_updated_before_filter",
                "latitude": 0,
                "logprobs": True,
                "longitude": 0,
                "max_tokens": 1,
                "n": 1,
                "num_images": 0,
                "num_search_results": 0,
                "parallel_tool_calls": True,
                "presence_penalty": -2,
                "ranking_model": "ranking_model",
                "reasoning_effort": "minimal",
                "response_format": {"type": "text"},
                "response_metadata": {"foo": "bar"},
                "return_images": True,
                "return_related_questions": True,
                "safe_search": True,
                "search_after_date_filter": "search_after_date_filter",
                "search_before_date_filter": "search_before_date_filter",
                "search_domain_filter": ["string"],
                "search_internal_properties": {"foo": "bar"},
                "search_language_filter": ["string"],
                "search_mode": "web",
                "search_recency_filter": "hour",
                "search_tenant": "search_tenant",
                "stop": "string",
                "stream": True,
                "stream_mode": "full",
                "temperature": 0,
                "thread_id": "thread_id",
                "tool_choice": "none",
                "tools": [
                    {
                        "function": {
                            "description": "description",
                            "name": "name",
                            "parameters": {
                                "properties": {"foo": "bar"},
                                "type": "type",
                                "additional_properties": True,
                                "required": ["string"],
                            },
                            "strict": True,
                        },
                        "type": "function",
                    }
                ],
                "top_k": 0,
                "top_logprobs": 0,
                "top_p": 0,
                "updated_after_timestamp": 0,
                "updated_before_timestamp": 0,
                "use_threads": True,
                "user_original_query": "user_original_query",
                "web_search_options": {
                    "image_results_enhanced_relevance": True,
                    "search_context_size": "low",
                    "search_type": "fast",
                    "user_location": {
                        "city": "city",
                        "country": "country",
                        "latitude": 0,
                        "longitude": 0,
                        "region": "region",
                    },
                },
            },
            idempotency_key="idempotency_key",
        )
        assert_matches_type(CompletionCreateResponse, completion, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_raw_response_create(self, async_client: AsyncPerplexity) -> None:
        response = await async_client.async_.chat.completions.with_raw_response.create(
            request={
                "messages": [
                    {
                        "content": "string",
                        "role": "system",
                    }
                ],
                "model": "model",
            },
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        completion = await response.parse()
        assert_matches_type(CompletionCreateResponse, completion, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_streaming_response_create(self, async_client: AsyncPerplexity) -> None:
        async with async_client.async_.chat.completions.with_streaming_response.create(
            request={
                "messages": [
                    {
                        "content": "string",
                        "role": "system",
                    }
                ],
                "model": "model",
            },
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            completion = await response.parse()
            assert_matches_type(CompletionCreateResponse, completion, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_method_list(self, async_client: AsyncPerplexity) -> None:
        completion = await async_client.async_.chat.completions.list()
        assert_matches_type(CompletionListResponse, completion, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_raw_response_list(self, async_client: AsyncPerplexity) -> None:
        response = await async_client.async_.chat.completions.with_raw_response.list()

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        completion = await response.parse()
        assert_matches_type(CompletionListResponse, completion, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_streaming_response_list(self, async_client: AsyncPerplexity) -> None:
        async with async_client.async_.chat.completions.with_streaming_response.list() as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            completion = await response.parse()
            assert_matches_type(CompletionListResponse, completion, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_method_get(self, async_client: AsyncPerplexity) -> None:
        completion = await async_client.async_.chat.completions.get(
            api_request="api_request",
        )
        assert_matches_type(CompletionGetResponse, completion, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_method_get_with_all_params(self, async_client: AsyncPerplexity) -> None:
        completion = await async_client.async_.chat.completions.get(
            api_request="api_request",
            local_mode=True,
            x_client_env="x-client-env",
            x_client_name="x-client-name",
            x_created_at_epoch_seconds="x-created-at-epoch-seconds",
            x_request_time="x-request-time",
            x_usage_tier="x-usage-tier",
            x_user_id="x-user-id",
        )
        assert_matches_type(CompletionGetResponse, completion, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_raw_response_get(self, async_client: AsyncPerplexity) -> None:
        response = await async_client.async_.chat.completions.with_raw_response.get(
            api_request="api_request",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        completion = await response.parse()
        assert_matches_type(CompletionGetResponse, completion, path=["response"])

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_streaming_response_get(self, async_client: AsyncPerplexity) -> None:
        async with async_client.async_.chat.completions.with_streaming_response.get(
            api_request="api_request",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            completion = await response.parse()
            assert_matches_type(CompletionGetResponse, completion, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip(reason="Prism tests are disabled")
    @parametrize
    async def test_path_params_get(self, async_client: AsyncPerplexity) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `api_request` but received ''"):
            await async_client.async_.chat.completions.with_raw_response.get(
                api_request="",
            )
