"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/core");
const index_1 = require("./index");
const spot_1 = require("./spot");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stackName = app.node.tryGetContext('stackName') || 'SpotOneStack';
        const stack = new cdk.Stack(app, stackName, { env });
        const instanceType = stack.node.tryGetContext('instance_type') || 't3.large';
        const eipAllocationId = stack.node.tryGetContext('eip_allocation_id');
        const volumeSize = stack.node.tryGetContext('volume_size') || 60;
        const keyName = stack.node.tryGetContext('ssh_key_name');
        const vpc = spot_1.VpcProvider.getOrCreate(stack);
        new spot_1.SpotInstance(stack, 'SpotInstance', {
            vpc,
            instanceInterruptionBehavior: index_1.InstanceInterruptionBehavior.STOP,
            eipAllocationId: eipAllocationId,
            assignEip: false,
            defaultInstanceType: new aws_ec2_1.InstanceType(instanceType),
            keyName,
            ebsVolumeSize: volumeSize,
        });
        // const fleet = new SpotFleet(stack, 'SpotFleet', {
        //   vpc,
        //   instanceOnly: true,
        //   instanceInterruptionBehavior: InstanceInterruptionBehavior.STOP,
        //   blockDuration: BlockDuration.SIX_HOURS,
        //   eipAllocationId: eipAllocationId,
        //   assignEip: false,
        //   defaultInstanceType: new InstanceType(instanceType),
        //   keyName,
        //   blockDeviceMappings: [
        //     {
        //       deviceName: '/dev/xvda',
        //       ebs: {
        //         volumeSize,
        //       },
        //     },
        //   ],
        // });
        // const expireAfter = stack.node.tryGetContext('expire_after');
        // if (expireAfter) {
        //   fleet.expireAfter(cdk.Duration.hours(expireAfter));
        // }
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
// run the integ testing
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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