"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LaunchTemplateResource = exports.SpotFleet = exports.SpotInstance = exports.SpotOne = exports.LaunchTemplate = exports.InstanceInterruptionBehavior = exports.NodeType = exports.BlockDuration = exports.VpcProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const ec2 = require("@aws-cdk/aws-ec2");
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const logs = require("@aws-cdk/aws-logs");
const core_1 = require("@aws-cdk/core");
const cr = require("@aws-cdk/custom-resources");
const DEFAULT_INSTANCE_TYPE = 't3.large';
/**
 * @stability stable
 */
class VpcProvider extends core_1.Stack {
    /**
     * @stability stable
     */
    static getOrCreate(scope) {
        const stack = core_1.Stack.of(scope);
        return stack.node.tryGetContext('use_default_vpc') === '1' ?
            ec2.Vpc.fromLookup(stack, 'Vpc', { isDefault: true }) :
            stack.node.tryGetContext('use_vpc_id') ?
                ec2.Vpc.fromLookup(stack, 'Vpc', { vpcId: stack.node.tryGetContext('use_vpc_id') }) :
                new ec2.Vpc(stack, 'Vpc', { maxAzs: 3, natGateways: 1 });
    }
}
exports.VpcProvider = VpcProvider;
_a = JSII_RTTI_SYMBOL_1;
VpcProvider[_a] = { fqn: "cdk-spot-one.VpcProvider", version: "0.6.147" };
/**
 * @stability stable
 */
var BlockDuration;
(function (BlockDuration) {
    BlockDuration[BlockDuration["ONE_HOUR"] = 60] = "ONE_HOUR";
    BlockDuration[BlockDuration["TWO_HOURS"] = 120] = "TWO_HOURS";
    BlockDuration[BlockDuration["THREE_HOURS"] = 180] = "THREE_HOURS";
    BlockDuration[BlockDuration["FOUR_HOURS"] = 240] = "FOUR_HOURS";
    BlockDuration[BlockDuration["FIVE_HOURS"] = 300] = "FIVE_HOURS";
    BlockDuration[BlockDuration["SIX_HOURS"] = 360] = "SIX_HOURS";
    BlockDuration[BlockDuration["NONE"] = 0] = "NONE";
})(BlockDuration = exports.BlockDuration || (exports.BlockDuration = {}));
/**
 * Whether the worker nodes should support GPU or just standard instances.
 *
 * @stability stable
 */
var NodeType;
(function (NodeType) {
    NodeType["STANDARD"] = "Standard";
    NodeType["GPU"] = "GPU";
    NodeType["INFERENTIA"] = "INFERENTIA";
    NodeType["ARM"] = "ARM";
})(NodeType = exports.NodeType || (exports.NodeType = {}));
/**
 * @stability stable
 */
var InstanceInterruptionBehavior;
(function (InstanceInterruptionBehavior) {
    InstanceInterruptionBehavior["HIBERNATE"] = "hibernate";
    InstanceInterruptionBehavior["STOP"] = "stop";
    InstanceInterruptionBehavior["TERMINATE"] = "terminate";
})(InstanceInterruptionBehavior = exports.InstanceInterruptionBehavior || (exports.InstanceInterruptionBehavior = {}));
/**
 * @stability stable
 */
class LaunchTemplate {
    /**
     * @stability stable
     */
    bind(spotfleet) {
        return {
            spotfleet,
            launchTemplate: this,
        };
    }
}
exports.LaunchTemplate = LaunchTemplate;
_b = JSII_RTTI_SYMBOL_1;
LaunchTemplate[_b] = { fqn: "cdk-spot-one.LaunchTemplate", version: "0.6.147" };
/**
 * @stability stable
 */
class SpotOne extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _g, _h, _j;
        super(scope, id);
        this.vpc = (_g = props.vpc) !== null && _g !== void 0 ? _g : VpcProvider.getOrCreate(this);
        this.defaultSecurityGroup = props.securityGroup || this.createSecurityGroup();
        this.instanceProfile = props.instanceProfile;
        this.defaultInstanceType = (_h = props.defaultInstanceType) !== null && _h !== void 0 ? _h : new ec2.InstanceType(DEFAULT_INSTANCE_TYPE);
        this.imageId = (_j = props.customAmiId) !== null && _j !== void 0 ? _j : ec2.MachineImage.latestAmazonLinux({
            generation: ec2.AmazonLinuxGeneration.AMAZON_LINUX_2,
            cpuType: nodeTypeForInstanceType(this.defaultInstanceType) === NodeType.ARM ? ec2.AmazonLinuxCpuType.ARM_64 : undefined,
        }).getImage(this).imageId;
        this.userData = ec2.UserData.forLinux();
        /**
         * If not using custom AMI, we use amazon linux 2 and install the SSM agent and enable docker by default.
         * Otherwise, we simply do nothing here.
         */
        if (props.customAmiId == undefined) {
            this.userData.addCommands('yum install -y https://s3.amazonaws.com/ec2-downloads-windows/SSMAgent/latest/linux_amd64/amazon-ssm-agent.rpm', 'yum install -y docker', 'usermod -aG docker ec2-user', 'usermod -aG docker ssm-user', 'service docker start');
        }
        if (props.additionalUserData) {
            this.userData.addCommands(...props.additionalUserData);
        }
        this.associateEip(props);
    }
    /**
     * @stability stable
     */
    createInstanceRole() {
        this.instanceRole = new iam.Role(this, 'InstanceRole', {
            roleName: core_1.PhysicalName.GENERATE_IF_NEEDED,
            assumedBy: new iam.ServicePrincipal('ec2.amazonaws.com'),
        });
        this.instanceRole.addManagedPolicy({
            managedPolicyArn: 'arn:aws:iam::aws:policy/AmazonSSMManagedInstanceCore',
        });
        return this.instanceRole;
    }
    /**
     * @stability stable
     */
    createSecurityGroup() {
        const securityGroup = new ec2.SecurityGroup(this, 'SpotFleetSg', {
            vpc: this.vpc,
        });
        securityGroup.connections.allowFromAnyIpv4(ec2.Port.tcp(22));
        return securityGroup;
    }
    /**
     * @stability stable
     */
    associateEip(props) {
        // EIP association
        if (props.eipAllocationId) {
            new ec2.CfnEIPAssociation(this, 'EipAssocation', {
                allocationId: props.eipAllocationId,
                instanceId: this.instanceId,
            });
        }
        else if (props.assignEip !== false) {
            new ec2.CfnEIP(this, 'EIP', {
                instanceId: this.instanceId,
            });
        }
    }
    /**
     * @stability stable
     */
    createInstanceProfile(role) {
        return new iam.CfnInstanceProfile(this, 'InstanceProfile', {
            roles: [role.roleName],
        });
    }
}
exports.SpotOne = SpotOne;
_c = JSII_RTTI_SYMBOL_1;
SpotOne[_c] = { fqn: "cdk-spot-one.SpotOne", version: "0.6.147" };
/**
 * @stability stable
 */
class SpotInstance extends SpotOne {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        var _g, _h, _j;
        super(scope, id, props);
        const spotInstance = new ec2.Instance(this, 'SpotInstance', {
            vpc: this.vpc,
            instanceType: this.defaultInstanceType,
            machineImage: ec2.MachineImage.latestAmazonLinux({
                generation: ec2.AmazonLinuxGeneration.AMAZON_LINUX_2,
                cpuType: nodeTypeForInstanceType(this.defaultInstanceType) === NodeType.ARM ? ec2.AmazonLinuxCpuType.ARM_64 : undefined,
            }),
            keyName: props.keyName,
            securityGroup: this.defaultSecurityGroup,
            role: this.instanceRole,
            userData: this.userData,
            vpcSubnets: (_g = props.vpcSubnet) !== null && _g !== void 0 ? _g : {
                subnetType: ec2.SubnetType.PUBLIC,
            },
            blockDevices: [
                {
                    deviceName: '/dev/xvda',
                    volume: ec2.BlockDeviceVolume.ebs((_h = props.ebsVolumeSize) !== null && _h !== void 0 ? _h : 60),
                },
            ],
        });
        const cfnInstance = spotInstance.node.defaultChild;
        // create custom launch template reousrce
        const launchTemplate = new LaunchTemplateResource(this, 'launchTemplateForInstance', {
            instanceMarketOptions: {
                marketType: 'spot',
                spotOptions: {
                    instanceInterruptionBehavior: (_j = props.instanceInterruptionBehavior) !== null && _j !== void 0 ? _j : InstanceInterruptionBehavior.TERMINATE,
                    spotInstanceType: 'persistent',
                },
            },
            iamInstanceProfile: this.instanceProfile,
        });
        cfnInstance.addPropertyOverride('LaunchTemplate', {
            LaunchTemplateId: launchTemplate.resource.ref,
            Version: launchTemplate.resource.attrLatestVersionNumber,
        });
        // As we can't specify IamInstanceProfile both in launch template and instane property
        // we need delete the property here.
        cfnInstance.addPropertyDeletionOverride('IamInstanceProfile');
        this.instanceId = spotInstance.instanceId;
        this.instanceType = this.defaultInstanceType.toString();
        new core_1.CfnOutput(this, 'PublicIpAddress', { value: cfnInstance.attrPublicIp });
    }
}
exports.SpotInstance = SpotInstance;
_d = JSII_RTTI_SYMBOL_1;
SpotInstance[_d] = { fqn: "cdk-spot-one.SpotInstance", version: "0.6.147" };
/**
 * @stability stable
 */
class SpotFleet extends SpotOne {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        var _g, _h, _j, _k, _l, _m, _o, _p, _q;
        super(scope, id, props);
        this.spotFleetId = id;
        this.launchTemplate = (_g = props.launchTemplate) !== null && _g !== void 0 ? _g : new LaunchTemplate();
        this.targetCapacity = (_h = props.targetCapacity) !== null && _h !== void 0 ? _h : 1;
        this.validUntil = props.validUntil;
        const stack = core_1.Stack.of(this);
        this.instanceProfile = ((_j = props.instanceProfile) !== null && _j !== void 0 ? _j : props.instanceRole) ? this.createInstanceProfile(props.instanceRole)
            : this.createInstanceProfile(this.createInstanceRole());
        const lt = new LaunchTemplateResource(this, 'LaunchTemplate', {
            blockDeviceMappings: props.blockDeviceMappings,
            defaultInstanceType: this.defaultInstanceType,
            iamInstanceProfile: this.instanceProfile,
            imageId: this.imageId,
            instanceMarketOptions: {
                marketType: 'spot',
                spotOptions: {
                    blockDurationMinutes: (props.blockDuration == BlockDuration.NONE) ? undefined : ((_k = props.blockDuration) !== null && _k !== void 0 ? _k : BlockDuration.ONE_HOUR),
                    instanceInterruptionBehavior: (_l = props.instanceInterruptionBehavior) !== null && _l !== void 0 ? _l : InstanceInterruptionBehavior.TERMINATE,
                },
            },
            keyName: props.keyName,
            securityGroup: this.defaultSecurityGroup.connections.securityGroups,
            userData: this.userData,
        });
        const spotFleetRole = new iam.Role(this, 'FleetRole', {
            assumedBy: new iam.ServicePrincipal('spotfleet.amazonaws.com'),
            managedPolicies: [
                iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AmazonEC2SpotFleetTaggingRole'),
            ],
        });
        const vpcSubnetSelection = (_m = props.vpcSubnet) !== null && _m !== void 0 ? _m : {
            subnetType: ec2.SubnetType.PUBLIC,
        };
        const subnetConfig = this.vpc.selectSubnets(vpcSubnetSelection).subnets.map(s => ({
            subnetId: s.subnetId,
        }));
        const cfnSpotFleet = new ec2.CfnSpotFleet(this, id, {
            spotFleetRequestConfigData: {
                launchTemplateConfigs: [
                    {
                        launchTemplateSpecification: {
                            launchTemplateId: lt.resource.ref,
                            version: lt.resource.attrLatestVersionNumber,
                        },
                        overrides: subnetConfig,
                    },
                ],
                iamFleetRole: spotFleetRole.roleArn,
                targetCapacity: (_o = props.targetCapacity) !== null && _o !== void 0 ? _o : 1,
                validFrom: props.validFrom,
                validUntil: core_1.Lazy.string({ produce: () => this.validUntil }),
                terminateInstancesWithExpiration: (_p = props.terminateInstancesWithExpiration) !== null && _p !== void 0 ? _p : true,
                instanceInterruptionBehavior: (_q = props.instanceInterruptionBehavior) !== null && _q !== void 0 ? _q : InstanceInterruptionBehavior.TERMINATE,
            },
        });
        new core_1.CfnOutput(stack, 'SpotFleetId', { value: cfnSpotFleet.ref });
        const onEvent = new lambda.Function(this, 'OnEvent', {
            code: lambda.Code.fromAsset(path.join(__dirname, '../eip-handler')),
            handler: 'index.on_event',
            runtime: lambda.Runtime.PYTHON_3_8,
            timeout: core_1.Duration.seconds(60),
        });
        const isComplete = new lambda.Function(this, 'IsComplete', {
            code: lambda.Code.fromAsset(path.join(__dirname, '../eip-handler')),
            handler: 'index.is_complete',
            runtime: lambda.Runtime.PYTHON_3_8,
            timeout: core_1.Duration.seconds(60),
            role: onEvent.role,
        });
        const myProvider = new cr.Provider(this, 'MyProvider', {
            onEventHandler: onEvent,
            isCompleteHandler: isComplete,
            logRetention: logs.RetentionDays.ONE_DAY,
        });
        onEvent.addToRolePolicy(new iam.PolicyStatement({
            actions: ['ec2:DescribeSpotFleetInstances'],
            resources: ['*'],
        }));
        const fleetInstances = new core_1.CustomResource(this, 'SpotFleetInstances', {
            serviceToken: myProvider.serviceToken,
            properties: {
                SpotFleetRequestId: cfnSpotFleet.ref,
            },
        });
        fleetInstances.node.addDependency(cfnSpotFleet);
        this.instanceId = core_1.Token.asString(fleetInstances.getAtt('InstanceId'));
        this.instanceType = core_1.Token.asString(fleetInstances.getAtt('InstanceType'));
        this.spotFleetRequestId = core_1.Token.asString(fleetInstances.getAtt('SpotInstanceRequestId'));
        new core_1.CfnOutput(stack, 'InstanceId', { value: this.instanceId });
    }
    /**
     * @stability stable
     */
    expireAfter(duration) {
        const date = new Date();
        date.setSeconds(date.getSeconds() + duration.toSeconds());
        this.validUntil = date.toISOString();
    }
}
exports.SpotFleet = SpotFleet;
_e = JSII_RTTI_SYMBOL_1;
SpotFleet[_e] = { fqn: "cdk-spot-one.SpotFleet", version: "0.6.147" };
/**
 * @stability stable
 */
class LaunchTemplateResource extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        var _g, _h, _j, _k, _l;
        super(scope, id);
        this.defaultInstanceType = (_g = props.defaultInstanceType) !== null && _g !== void 0 ? _g : new ec2.InstanceType(DEFAULT_INSTANCE_TYPE);
        const imageId = (_h = props.imageId) !== null && _h !== void 0 ? _h : ec2.MachineImage.latestAmazonLinux({
            generation: ec2.AmazonLinuxGeneration.AMAZON_LINUX_2,
            cpuType: nodeTypeForInstanceType(this.defaultInstanceType) === NodeType.ARM ? ec2.AmazonLinuxCpuType.ARM_64 : undefined,
        }).getImage(this).imageId;
        const userData = (_j = props.userData) !== null && _j !== void 0 ? _j : ec2.UserData.forLinux();
        this.resource = new ec2.CfnLaunchTemplate(this, 'LaunchTemplate', {
            launchTemplateData: {
                imageId,
                instanceType: this.defaultInstanceType.toString(),
                userData: core_1.Fn.base64(userData.render()),
                keyName: props.keyName,
                tagSpecifications: [
                    {
                        resourceType: 'instance',
                        tags: [
                            {
                                key: 'Name',
                                value: `${core_1.Stack.of(this).stackName}/${id}`,
                            },
                        ],
                    },
                ],
                blockDeviceMappings: (_k = props.blockDeviceMappings) !== null && _k !== void 0 ? _k : undefined,
                instanceMarketOptions: props.instanceMarketOptions,
                securityGroupIds: (_l = props.securityGroup) === null || _l === void 0 ? void 0 : _l.map(s => s.securityGroupId),
                iamInstanceProfile: props.iamInstanceProfile ? {
                    arn: props.iamInstanceProfile.attrArn,
                } : undefined,
            },
        });
    }
}
exports.LaunchTemplateResource = LaunchTemplateResource;
_f = JSII_RTTI_SYMBOL_1;
LaunchTemplateResource[_f] = { fqn: "cdk-spot-one.LaunchTemplateResource", version: "0.6.147" };
const GRAVITON_INSTANCETYPES = ['a1'];
const GRAVITON2_INSTANCETYPES = ['c6g', 'm6g', 'r6g'];
const GPU_INSTANCETYPES = ['p2', 'p3', 'g4'];
const INFERENTIA_INSTANCETYPES = ['inf1'];
function nodeTypeForInstanceType(instanceType) {
    return GPU_INSTANCETYPES.includes(instanceType.toString().substring(0, 2)) ? NodeType.GPU :
        INFERENTIA_INSTANCETYPES.includes(instanceType.toString().substring(0, 4)) ? NodeType.INFERENTIA :
            GRAVITON2_INSTANCETYPES.includes(instanceType.toString().substring(0, 3)) ? NodeType.ARM :
                GRAVITON_INSTANCETYPES.includes(instanceType.toString().substring(0, 2)) ? NodeType.ARM :
                    NodeType.STANDARD;
}
//# sourceMappingURL=data:application/json;base64,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