<a id="mypy-boto3-waf"></a>

# mypy-boto3-waf

[![PyPI - mypy-boto3-waf](https://img.shields.io/pypi/v/mypy-boto3-waf.svg?color=blue)](https://pypi.org/project/mypy-boto3-waf)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-waf.svg?color=blue)](https://pypi.org/project/mypy-boto3-waf)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/mypy-boto3-waf?color=blue)](https://pypistats.org/packages/mypy-boto3-waf)

![boto3.typed](https://github.com/youtype/mypy_boto3_builder/raw/main/logo.png)

Type annotations for
[boto3.WAF 1.24.0](https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/waf.html#WAF)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 7.6.1](https://github.com/youtype/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-waf docs](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_waf/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/youtype/mypy_boto3_builder/raw/main/demo.gif)

- [mypy-boto3-waf](#mypy-boto3-waf)
  - [How to install](#how-to-install)
    - [VSCode extension](#vscode-extension)
    - [From PyPI with pip](#from-pypi-with-pip)
  - [How to uninstall](#how-to-uninstall)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Emacs](#emacs)
    - [Sublime Text](#sublime-text)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [How it works](#how-it-works)
  - [What's new](#what's-new)
    - [Implemented features](#implemented-features)
    - [Latest changes](#latest-changes)
  - [Versioning](#versioning)
  - [Thank you](#thank-you)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

<a id="vscode-extension"></a>

### VSCode extension

Add
[AWS Boto3](https://marketplace.visualstudio.com/items?itemName=Boto3typed.boto3-ide)
extension to your VSCode and run `AWS boto3: Quick Start` command.

Click `Modify` and select `boto3 common` and `WAF`.

<a id="from-pypi-with-pip"></a>

### From PyPI with pip

Install `boto3-stubs` for `WAF` service.

```bash
# install with boto3 type annotations
python -m pip install 'boto3-stubs[waf]'


# Lite version does not provide session.client/resource overloads
# it is more RAM-friendly, but requires explicit type annotations
python -m pip install 'boto3-stubs-lite[waf]'


# standalone installation
python -m pip install mypy-boto3-waf
```

<a id="how-to-uninstall"></a>

## How to uninstall

```bash
python -m pip uninstall -y mypy-boto3-waf
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto3-stubs[waf]` in your environment:

```bash
python -m pip install 'boto3-stubs[waf]'
```

Both type checking and code completion should now work. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

Install `boto3-stubs-lite[waf]` in your environment:

```bash
python -m pip install 'boto3-stubs-lite[waf]'`
```

Both type checking and code completion should now work. Explicit type
annotations **are required**.

Use `boto3-stubs` package instead for implicit type discovery.

<a id="emacs"></a>

### Emacs

- Install `boto3-stubs` with services you use in your environment:

```bash
python -m pip install 'boto3-stubs[waf]'
```

- Install [use-package](https://github.com/jwiegley/use-package),
  [lsp](https://github.com/emacs-lsp/lsp-mode/),
  [company](https://github.com/company-mode/company-mode) and
  [flycheck](https://github.com/flycheck/flycheck) packages
- Install [lsp-pyright](https://github.com/emacs-lsp/lsp-pyright) package

```elisp
(use-package lsp-pyright
  :ensure t
  :hook (python-mode . (lambda ()
                          (require 'lsp-pyright)
                          (lsp)))  ; or lsp-deferred
  :init (when (executable-find "python3")
          (setq lsp-pyright-python-executable-cmd "python3"))
  )
```

- Make sure emacs uses the environment where you have installed `boto3-stubs`

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="sublime-text"></a>

### Sublime Text

- Install `boto3-stubs[waf]` with services you use in your environment:

```bash
python -m pip install 'boto3-stubs[waf]'
```

- Install [LSP-pyright](https://github.com/sublimelsp/LSP-pyright) package

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto3-stubs[waf]` in your environment:

```bash
python -m pip install 'boto3-stubs[waf]'`
```

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `npm i -g pyright`
- Install `boto3-stubs[waf]` in your environment:

```bash
python -m pip install 'boto3-stubs[waf]'
```

Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`WAFClient` provides annotations for `boto3.client("waf")`.

```python
from boto3.session import Session

from mypy_boto3_waf import WAFClient

client: WAFClient = Session().client("waf")

# now client usage is checked by mypy and IDE should provide code completion
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_waf.paginator` module contains type annotations for all paginators.

```python
from boto3.session import Session

from mypy_boto3_waf import WAFClient
from mypy_boto3_waf.paginator import (
    GetRateBasedRuleManagedKeysPaginator,
    ListActivatedRulesInRuleGroupPaginator,
    ListByteMatchSetsPaginator,
    ListGeoMatchSetsPaginator,
    ListIPSetsPaginator,
    ListLoggingConfigurationsPaginator,
    ListRateBasedRulesPaginator,
    ListRegexMatchSetsPaginator,
    ListRegexPatternSetsPaginator,
    ListRuleGroupsPaginator,
    ListRulesPaginator,
    ListSizeConstraintSetsPaginator,
    ListSqlInjectionMatchSetsPaginator,
    ListSubscribedRuleGroupsPaginator,
    ListWebACLsPaginator,
    ListXssMatchSetsPaginator,
)

client: WAFClient = Session().client("waf")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
get_rate_based_rule_managed_keys_paginator: GetRateBasedRuleManagedKeysPaginator = client.get_paginator("get_rate_based_rule_managed_keys")
list_activated_rules_in_rule_group_paginator: ListActivatedRulesInRuleGroupPaginator = client.get_paginator("list_activated_rules_in_rule_group")
list_byte_match_sets_paginator: ListByteMatchSetsPaginator = client.get_paginator("list_byte_match_sets")
list_geo_match_sets_paginator: ListGeoMatchSetsPaginator = client.get_paginator("list_geo_match_sets")
list_ip_sets_paginator: ListIPSetsPaginator = client.get_paginator("list_ip_sets")
list_logging_configurations_paginator: ListLoggingConfigurationsPaginator = client.get_paginator("list_logging_configurations")
list_rate_based_rules_paginator: ListRateBasedRulesPaginator = client.get_paginator("list_rate_based_rules")
list_regex_match_sets_paginator: ListRegexMatchSetsPaginator = client.get_paginator("list_regex_match_sets")
list_regex_pattern_sets_paginator: ListRegexPatternSetsPaginator = client.get_paginator("list_regex_pattern_sets")
list_rule_groups_paginator: ListRuleGroupsPaginator = client.get_paginator("list_rule_groups")
list_rules_paginator: ListRulesPaginator = client.get_paginator("list_rules")
list_size_constraint_sets_paginator: ListSizeConstraintSetsPaginator = client.get_paginator("list_size_constraint_sets")
list_sql_injection_match_sets_paginator: ListSqlInjectionMatchSetsPaginator = client.get_paginator("list_sql_injection_match_sets")
list_subscribed_rule_groups_paginator: ListSubscribedRuleGroupsPaginator = client.get_paginator("list_subscribed_rule_groups")
list_web_acls_paginator: ListWebACLsPaginator = client.get_paginator("list_web_acls")
list_xss_match_sets_paginator: ListXssMatchSetsPaginator = client.get_paginator("list_xss_match_sets")
```

<a id="literals"></a>

### Literals

`mypy_boto3_waf.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_waf.literals import (
    ChangeActionType,
    ChangeTokenStatusType,
    ComparisonOperatorType,
    GeoMatchConstraintTypeType,
    GeoMatchConstraintValueType,
    GetRateBasedRuleManagedKeysPaginatorName,
    IPSetDescriptorTypeType,
    ListActivatedRulesInRuleGroupPaginatorName,
    ListByteMatchSetsPaginatorName,
    ListGeoMatchSetsPaginatorName,
    ListIPSetsPaginatorName,
    ListLoggingConfigurationsPaginatorName,
    ListRateBasedRulesPaginatorName,
    ListRegexMatchSetsPaginatorName,
    ListRegexPatternSetsPaginatorName,
    ListRuleGroupsPaginatorName,
    ListRulesPaginatorName,
    ListSizeConstraintSetsPaginatorName,
    ListSqlInjectionMatchSetsPaginatorName,
    ListSubscribedRuleGroupsPaginatorName,
    ListWebACLsPaginatorName,
    ListXssMatchSetsPaginatorName,
    MatchFieldTypeType,
    PositionalConstraintType,
    PredicateTypeType,
    RateKeyType,
    TextTransformationType,
    WafActionTypeType,
    WafOverrideActionTypeType,
    WafRuleTypeType,
    WAFServiceName,
    ServiceName,
    ResourceServiceName,
    PaginatorName,
)

def check_value(value: ChangeActionType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_waf.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_waf.type_defs import (
    ExcludedRuleTypeDef,
    WafActionTypeDef,
    WafOverrideActionTypeDef,
    ByteMatchSetSummaryTypeDef,
    FieldToMatchTypeDef,
    CreateByteMatchSetRequestRequestTypeDef,
    ResponseMetadataTypeDef,
    CreateGeoMatchSetRequestRequestTypeDef,
    CreateIPSetRequestRequestTypeDef,
    TagTypeDef,
    CreateRegexMatchSetRequestRequestTypeDef,
    CreateRegexPatternSetRequestRequestTypeDef,
    RegexPatternSetTypeDef,
    RuleGroupTypeDef,
    CreateSizeConstraintSetRequestRequestTypeDef,
    CreateSqlInjectionMatchSetRequestRequestTypeDef,
    CreateWebACLMigrationStackRequestRequestTypeDef,
    CreateXssMatchSetRequestRequestTypeDef,
    DeleteByteMatchSetRequestRequestTypeDef,
    DeleteGeoMatchSetRequestRequestTypeDef,
    DeleteIPSetRequestRequestTypeDef,
    DeleteLoggingConfigurationRequestRequestTypeDef,
    DeletePermissionPolicyRequestRequestTypeDef,
    DeleteRateBasedRuleRequestRequestTypeDef,
    DeleteRegexMatchSetRequestRequestTypeDef,
    DeleteRegexPatternSetRequestRequestTypeDef,
    DeleteRuleGroupRequestRequestTypeDef,
    DeleteRuleRequestRequestTypeDef,
    DeleteSizeConstraintSetRequestRequestTypeDef,
    DeleteSqlInjectionMatchSetRequestRequestTypeDef,
    DeleteWebACLRequestRequestTypeDef,
    DeleteXssMatchSetRequestRequestTypeDef,
    GeoMatchConstraintTypeDef,
    GeoMatchSetSummaryTypeDef,
    GetByteMatchSetRequestRequestTypeDef,
    GetChangeTokenStatusRequestRequestTypeDef,
    GetGeoMatchSetRequestRequestTypeDef,
    GetIPSetRequestRequestTypeDef,
    GetLoggingConfigurationRequestRequestTypeDef,
    GetPermissionPolicyRequestRequestTypeDef,
    PaginatorConfigTypeDef,
    GetRateBasedRuleManagedKeysRequestRequestTypeDef,
    GetRateBasedRuleRequestRequestTypeDef,
    GetRegexMatchSetRequestRequestTypeDef,
    GetRegexPatternSetRequestRequestTypeDef,
    GetRuleGroupRequestRequestTypeDef,
    GetRuleRequestRequestTypeDef,
    TimeWindowTypeDef,
    GetSizeConstraintSetRequestRequestTypeDef,
    GetSqlInjectionMatchSetRequestRequestTypeDef,
    GetWebACLRequestRequestTypeDef,
    GetXssMatchSetRequestRequestTypeDef,
    HTTPHeaderTypeDef,
    IPSetDescriptorTypeDef,
    IPSetSummaryTypeDef,
    ListActivatedRulesInRuleGroupRequestRequestTypeDef,
    ListByteMatchSetsRequestRequestTypeDef,
    ListGeoMatchSetsRequestRequestTypeDef,
    ListIPSetsRequestRequestTypeDef,
    ListLoggingConfigurationsRequestRequestTypeDef,
    ListRateBasedRulesRequestRequestTypeDef,
    RuleSummaryTypeDef,
    ListRegexMatchSetsRequestRequestTypeDef,
    RegexMatchSetSummaryTypeDef,
    ListRegexPatternSetsRequestRequestTypeDef,
    RegexPatternSetSummaryTypeDef,
    ListRuleGroupsRequestRequestTypeDef,
    RuleGroupSummaryTypeDef,
    ListRulesRequestRequestTypeDef,
    ListSizeConstraintSetsRequestRequestTypeDef,
    SizeConstraintSetSummaryTypeDef,
    ListSqlInjectionMatchSetsRequestRequestTypeDef,
    SqlInjectionMatchSetSummaryTypeDef,
    ListSubscribedRuleGroupsRequestRequestTypeDef,
    SubscribedRuleGroupSummaryTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListWebACLsRequestRequestTypeDef,
    WebACLSummaryTypeDef,
    ListXssMatchSetsRequestRequestTypeDef,
    XssMatchSetSummaryTypeDef,
    PredicateTypeDef,
    PutPermissionPolicyRequestRequestTypeDef,
    RegexPatternSetUpdateTypeDef,
    UntagResourceRequestRequestTypeDef,
    ActivatedRuleTypeDef,
    ByteMatchTupleTypeDef,
    LoggingConfigurationTypeDef,
    RegexMatchTupleTypeDef,
    SizeConstraintTypeDef,
    SqlInjectionMatchTupleTypeDef,
    XssMatchTupleTypeDef,
    CreateWebACLMigrationStackResponseTypeDef,
    DeleteByteMatchSetResponseTypeDef,
    DeleteGeoMatchSetResponseTypeDef,
    DeleteIPSetResponseTypeDef,
    DeleteRateBasedRuleResponseTypeDef,
    DeleteRegexMatchSetResponseTypeDef,
    DeleteRegexPatternSetResponseTypeDef,
    DeleteRuleGroupResponseTypeDef,
    DeleteRuleResponseTypeDef,
    DeleteSizeConstraintSetResponseTypeDef,
    DeleteSqlInjectionMatchSetResponseTypeDef,
    DeleteWebACLResponseTypeDef,
    DeleteXssMatchSetResponseTypeDef,
    GetChangeTokenResponseTypeDef,
    GetChangeTokenStatusResponseTypeDef,
    GetPermissionPolicyResponseTypeDef,
    GetRateBasedRuleManagedKeysResponseTypeDef,
    ListByteMatchSetsResponseTypeDef,
    UpdateByteMatchSetResponseTypeDef,
    UpdateGeoMatchSetResponseTypeDef,
    UpdateIPSetResponseTypeDef,
    UpdateRateBasedRuleResponseTypeDef,
    UpdateRegexMatchSetResponseTypeDef,
    UpdateRegexPatternSetResponseTypeDef,
    UpdateRuleGroupResponseTypeDef,
    UpdateRuleResponseTypeDef,
    UpdateSizeConstraintSetResponseTypeDef,
    UpdateSqlInjectionMatchSetResponseTypeDef,
    UpdateWebACLResponseTypeDef,
    UpdateXssMatchSetResponseTypeDef,
    CreateRateBasedRuleRequestRequestTypeDef,
    CreateRuleGroupRequestRequestTypeDef,
    CreateRuleRequestRequestTypeDef,
    CreateWebACLRequestRequestTypeDef,
    TagInfoForResourceTypeDef,
    TagResourceRequestRequestTypeDef,
    CreateRegexPatternSetResponseTypeDef,
    GetRegexPatternSetResponseTypeDef,
    CreateRuleGroupResponseTypeDef,
    GetRuleGroupResponseTypeDef,
    GeoMatchSetTypeDef,
    GeoMatchSetUpdateTypeDef,
    ListGeoMatchSetsResponseTypeDef,
    GetRateBasedRuleManagedKeysRequestGetRateBasedRuleManagedKeysPaginateTypeDef,
    ListActivatedRulesInRuleGroupRequestListActivatedRulesInRuleGroupPaginateTypeDef,
    ListByteMatchSetsRequestListByteMatchSetsPaginateTypeDef,
    ListGeoMatchSetsRequestListGeoMatchSetsPaginateTypeDef,
    ListIPSetsRequestListIPSetsPaginateTypeDef,
    ListLoggingConfigurationsRequestListLoggingConfigurationsPaginateTypeDef,
    ListRateBasedRulesRequestListRateBasedRulesPaginateTypeDef,
    ListRegexMatchSetsRequestListRegexMatchSetsPaginateTypeDef,
    ListRegexPatternSetsRequestListRegexPatternSetsPaginateTypeDef,
    ListRuleGroupsRequestListRuleGroupsPaginateTypeDef,
    ListRulesRequestListRulesPaginateTypeDef,
    ListSizeConstraintSetsRequestListSizeConstraintSetsPaginateTypeDef,
    ListSqlInjectionMatchSetsRequestListSqlInjectionMatchSetsPaginateTypeDef,
    ListSubscribedRuleGroupsRequestListSubscribedRuleGroupsPaginateTypeDef,
    ListWebACLsRequestListWebACLsPaginateTypeDef,
    ListXssMatchSetsRequestListXssMatchSetsPaginateTypeDef,
    GetSampledRequestsRequestRequestTypeDef,
    HTTPRequestTypeDef,
    IPSetTypeDef,
    IPSetUpdateTypeDef,
    ListIPSetsResponseTypeDef,
    ListRateBasedRulesResponseTypeDef,
    ListRulesResponseTypeDef,
    ListRegexMatchSetsResponseTypeDef,
    ListRegexPatternSetsResponseTypeDef,
    ListRuleGroupsResponseTypeDef,
    ListSizeConstraintSetsResponseTypeDef,
    ListSqlInjectionMatchSetsResponseTypeDef,
    ListSubscribedRuleGroupsResponseTypeDef,
    ListWebACLsResponseTypeDef,
    ListXssMatchSetsResponseTypeDef,
    RateBasedRuleTypeDef,
    RuleTypeDef,
    RuleUpdateTypeDef,
    UpdateRegexPatternSetRequestRequestTypeDef,
    ListActivatedRulesInRuleGroupResponseTypeDef,
    RuleGroupUpdateTypeDef,
    WebACLTypeDef,
    WebACLUpdateTypeDef,
    ByteMatchSetTypeDef,
    ByteMatchSetUpdateTypeDef,
    GetLoggingConfigurationResponseTypeDef,
    ListLoggingConfigurationsResponseTypeDef,
    PutLoggingConfigurationRequestRequestTypeDef,
    PutLoggingConfigurationResponseTypeDef,
    RegexMatchSetTypeDef,
    RegexMatchSetUpdateTypeDef,
    SizeConstraintSetTypeDef,
    SizeConstraintSetUpdateTypeDef,
    SqlInjectionMatchSetTypeDef,
    SqlInjectionMatchSetUpdateTypeDef,
    XssMatchSetTypeDef,
    XssMatchSetUpdateTypeDef,
    ListTagsForResourceResponseTypeDef,
    CreateGeoMatchSetResponseTypeDef,
    GetGeoMatchSetResponseTypeDef,
    UpdateGeoMatchSetRequestRequestTypeDef,
    SampledHTTPRequestTypeDef,
    CreateIPSetResponseTypeDef,
    GetIPSetResponseTypeDef,
    UpdateIPSetRequestRequestTypeDef,
    CreateRateBasedRuleResponseTypeDef,
    GetRateBasedRuleResponseTypeDef,
    CreateRuleResponseTypeDef,
    GetRuleResponseTypeDef,
    UpdateRateBasedRuleRequestRequestTypeDef,
    UpdateRuleRequestRequestTypeDef,
    UpdateRuleGroupRequestRequestTypeDef,
    CreateWebACLResponseTypeDef,
    GetWebACLResponseTypeDef,
    UpdateWebACLRequestRequestTypeDef,
    CreateByteMatchSetResponseTypeDef,
    GetByteMatchSetResponseTypeDef,
    UpdateByteMatchSetRequestRequestTypeDef,
    CreateRegexMatchSetResponseTypeDef,
    GetRegexMatchSetResponseTypeDef,
    UpdateRegexMatchSetRequestRequestTypeDef,
    CreateSizeConstraintSetResponseTypeDef,
    GetSizeConstraintSetResponseTypeDef,
    UpdateSizeConstraintSetRequestRequestTypeDef,
    CreateSqlInjectionMatchSetResponseTypeDef,
    GetSqlInjectionMatchSetResponseTypeDef,
    UpdateSqlInjectionMatchSetRequestRequestTypeDef,
    CreateXssMatchSetResponseTypeDef,
    GetXssMatchSetResponseTypeDef,
    UpdateXssMatchSetRequestRequestTypeDef,
    GetSampledRequestsResponseTypeDef,
)

def get_structure() -> ExcludedRuleTypeDef:
    return {
      ...
    }
```

<a id="how-it-works"></a>

## How it works

Fully automated
[mypy-boto3-builder](https://github.com/youtype/mypy_boto3_builder) carefully
generates type annotations for each service, patiently waiting for `boto3`
updates. It delivers a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type
  annotations extracted from the documentation (blame `botocore` docs if types
  are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) and
  [isort](https://github.com/PyCQA/isort) for readability.

<a id="what's-new"></a>

## What's new

<a id="implemented-features"></a>

### Implemented features

- Fully type annotated `boto3`, `botocore` and `aiobotocore` libraries
- `mypy`, `pyright`, `VSCode`, `PyCharm`, `Sublime Text` and `Emacs`
  compatibility
- `Client`, `ServiceResource`, `Resource`, `Waiter` `Paginator` type
  annotations for each service
- Generated `TypeDefs` for each service
- Generated `Literals` for each service
- Auto discovery of types for `boto3.client` and `boto3.session` calls
- Auto discovery of types for `session.client` and `session.session` calls
- Auto discovery of types for `client.get_waiter` and `client.get_paginator`
  calls
- Auto discovery of types for `ServiceResource` and `Resource` collections
- Auto discovery of types for `aiobotocore.Session.create_client` calls

<a id="latest-changes"></a>

### Latest changes

Builder changelog can be found in
[Releases](https://github.com/youtype/mypy_boto3_builder/releases).

<a id="versioning"></a>

## Versioning

`mypy-boto3-waf` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="thank-you"></a>

## Thank you

- [Allie Fitter](https://github.com/alliefitter) for
  [boto3-type-annotations](https://pypi.org/project/boto3-type-annotations/),
  this package is based on top of his work
- [black](https://github.com/psf/black) developers for an awesome formatting
  tool
- [Timothy Edmund Crosley](https://github.com/timothycrosley) for
  [isort](https://github.com/PyCQA/isort) and how flexible it is
- [mypy](https://github.com/python/mypy) developers for doing all dirty work
  for us
- [pyright](https://github.com/microsoft/pyright) team for the new era of typed
  Python

<a id="documentation"></a>

## Documentation

All services type annotations can be found in
[boto3 docs](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_waf/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/youtype/mypy_boto3_builder/issues/)
repository.
