crypto_exchanges = { 
    1: 'Coinbase', 2: 'Bitfinex', 6: 'Bitstamp', 23: 'Kraken'
}
crypto_conditions_dict = {

 0: 'Regular Trade', 
 1: 'Sell Side', 
 2: 'Buy Side'}


# Map channel IDs to sectors
channel_to_sector = {'financials': 1152761724752105513,
 'consumer_cyclical': 1152761281200279632,
 'energy': 1152761528035070033,
 'etfs': 1153325170451288064,
 'healthcare': 1152761278176170046,
 'industrials': 1152761733920858152,
 'materials': 1152761735275630632,
 'technology': 1152761276913680524,
 'real_estate': 1152761736630390925,
 'communications': 1152761897033154641,
 'utilities': 1152761738060644483}

# Map channel IDs to sectors
dp_channel_list = [1152761724752105513,
 1152761281200279632,
 1152761528035070033,
 1153325170451288064,
 1152761278176170046,
 1152761733920858152,
 1152761735275630632,
 1152761276913680524,
 1152761736630390925,
1152761897033154641,
1152761738060644483]

sec_filing_titles = ['Rule 24F-2 notice', 'Securities to be offered to employees in employee benefit plans, post-effective amendments', 'Notice of disclosure filed pursuant to Section 219 of the Iran Threat Reduction and Syria Human Rights Act of 2012 (Exchange Act Section 13(r)).', 'Report of foreign issuer [Rules 13a-16 and 15d-16] - amended', 'Report of proposed sale of securities - amended', 'Form - 424I', 'Automatic shelf registration statement of securities of well-known seasoned issuers', 'Definitive proxy statement relating to merger or acquisition', 'Notice under Exchange Act Rule 12b-25 of inability to timely file Form N-CSR (annual or semi-annual report)', 'Report of proposed sale of securities', 'Prospectus [Rule 424(b)(2)]', 'Preliminary proxy statements relating to merger or acquisition', 'Registration statement [Section 12] or Annual Report [Section 13(a), 15(d)]', 'Annual and transition report of foreign private issuers [Sections 13 or 15(d)]', 'Asset-backed securitizer report pursuant to Section 15G', 'Current report - amended', 'Registration adding securities to prior Form S-3 registration [Rule 462(b)]', 'Certification of no change in definitive materials', 'Tender offer statement by Issuer', 'Initial statement of beneficial ownership of securities', 'Tender offer statement by Issuer - amended', 'Prospectuses and communications, business combinations', 'Securities registration termination [Section 12(g)]', 'Annual report of employee stock purchase, savings and similar plans - amended', 'Post-effective amendment [Rule 485(a)]', 'Certified Shareholder Report', 'Notification of inability to timely file Form 20-F', 'Quarterly report filed by institutional managers, Holdings - amended', 'Other definitive proxy statements', 'General form for registration of securities under the Securities Act of 1933 - amended', 'Notice under Exchange Act Rule 12b-25 of inability to timely file Form N-CSR (annual or semi-annual report) - amended', 'Quarterly report [Sections 13 or 15(d)] - amended', 'Registration statement for closed-end investment companies - amended', 'Definitive proxy statement, contested solicitations', 'Registration of securities [Section 12(b)] - amended', 'Registration of securities [Section 12(b)]', 'Tender Offer/Rights Offering Notification Form', 'Voluntary Supplemental Material by Foreign Issuers [Section 11(a)]', 'Quarterly report filed by institutional managers, Notice', 'Certified Shareholder Report, Semi-Annual - amended', 'Notice of Exempt Offering of Securities', 'Annual Report to Security Holders - amended', 'Certified Shareholder Report, Semi-Annual', 'Withdrawal of an Application for exemption [Section 12(g)] or from filing certain reports [Section 13(a)]', 'Registration of securities, business combinations - amended', 'Certificate of accounting of securities in custody of management investment companies [Rule 17f-2]', 'Notification of inability to timely file Form 10-K 405, 10-K, 10-KSB 405, 10-KSB, 10-KT, or 10-KT405', 'Certified Shareholder Report - amended', 'Notification filed by national security exchange to report the removal from listing and registration of matured, redeemed or retired securities', 'Initial statement of beneficial ownership of securities - amended', 'Prospectus [Rule 424(b)(4)]', 'Summary Prospectus for certain open-end management investment companies filed pursuant to Securities Act Rule 497(K)', 'Registration of securities, foreign private issuers, business combinations - amended', 'Post-effective Amendment to an automatic shelf registration statement', 'Registration of securities [Section 12(g)]', 'Registration statement by foreign private issuers - amended', 'Registration Withdrawal Request', 'Registration statement for closed-end investment companies', 'Form - CERT', 'Application for exemption and other relief filed under the Investment Company Act of 1940', 'Transition report [Rule 13a-10 or 15d-10]', 'Annual report [Section 13 and 15(d), not S-K Item 405] - amended', 'Annual Report for Registered Investment Companies', 'Securities to be offered to employees in employee benefit plans', 'Annual Report to Security Holders', 'Revised definitive proxy soliciting materials', 'Registration of securities, foreign private issuers, business combinations', 'Tender offer statement by Third Party', 'Notice of Exempt Offering of Securities - amended', 'Preliminary Proxy Soliciting materials', 'Registration statement for closed-end investment company (business combinations)', 'Non-management revised preliminary proxy soliciting materials, contested and otherwise', 'Post-effective amendment [Rule 485(b)]', 'Notice of Effectiveness', 'Form - N-2ASR', 'Annual Report of proxy voting record of management investment companies', 'Periodic and interim reports mailed to shareholders', 'Registration of securities issued by real estate companies - amended', 'Correspondence', 'Registration of securities, business combinations', 'Fidelity Bond [Rule 17G-1(g)] - amended', 'Registration statement for certain foreign private issuers', 'Statement of changes in beneficial ownership of securities - amended', 'Post-effective amendment adding exhibits to registration statement [Rule 462(d)]', 'Statement of acquisition of beneficial ownership by individuals', 'Statement of acquisition of beneficial ownership by individuals - amended', 'Fidelity Bond [Rule 17G-1(g)]', 'Annual report [Section 13 and 15(d), not S-K Item 405]', 'Draft Registration Statement - amended', 'Prospectus [Rule 424(b)(3)]', 'Notification of inability to timely file Form 10-Q or 10-QSB - amended', 'Current report', 'Monthly Portfolio Investments Report on Form N-PORT (Public) - amended', 'Annual Report of proxy voting record of management investment companies - amended', 'Registration adding securities to prior Form S-1 registration [Rule 462(b)]', 'SEC-generated letter', 'Annual statement of changes in beneficial ownership of securities - amended', 'Solicitation, recommendation statements - amended', 'Solicitation, recommendation statements', 'Application for exemption and other relief filed under the Investment Company Act of 1940 - amended', 'Quarterly report [Sections 13 or 15(d)]', 'Registration statement under Securities Act of 1933', 'Other definitive information statements', 'Other preliminary proxy statements', 'General form for registration of securities under the Securities Act of 1933', 'New effective date for post-effective amendment [Rule 485(b)(1)(iii)]', 'General statement of acquisition of beneficial ownership - amended', 'SEC Staff Letter', 'Amendment Withdrawal Request', 'Form - SPDSCL', 'Going private transaction by certain issuers - amended', 'Registration statement for certain foreign private issuers - amended', 'Filing by certain investment companies of Rule 482 advertising [Rule 497 and 482(c)]', 'Prospectus [Rule 424(b)(7)]', 'Post-effective amendments for immediately effective filing', 'Annual and transition report of foreign private issuers [Sections 13 or 15(d)] - amended', 'Prospectus [Rule 424(b)(5)]', 'Designates a U.S. agent for service of process by foreign banks and foreign insurance companies', 'Other preliminary information statements', 'Prospectus [Rule 424(b)(1)]', 'Additional definitive proxy soliciting materials filed by non-management and Rule 14(a)(12) material', 'Appointment of Agent for Service of Process and Undertaking', 'Registration statement [Section 12] or Annual Report [Section 13(a), 15(d)] - amended', 'Form - SD', 'Monthly Portfolio Investments Report on Form N-PORT (Public)', 'Draft Registration Statement', 'Written communication relating to third party tender offer', 'Written communication relating to an issuer or third party', 'Notification of inability to timely file Form 10-Q or 10-QSB', 'Notice of exempt solicitation submitted by non-management', 'General statement of acquisition of beneficial ownership', 'Report of foreign issuer [Rules 13a-16 and 15d-16]', 'Registration statement by foreign private issuers', 'Statement of changes in beneficial ownership of securities', 'Filing under Securities Act Rules 163/433 of free writing prospectuses', 'Registration Statement for Securities of certain Canadian Issuers.', 'Confidential treatment order', 'Definitive materials', 'Post-Effective amendments for registration statement', 'Notification of the removal from listing and registration of matured, redeemed or retired securities', 'Annual statement of changes in beneficial ownership of securities', 'Asset-Backed Issuer Distribution Report [Section 13 or 15(d) of the Securities Exchange Act of 1934]', 'Going private transaction by certain issuers', 'Quarterly report filed by institutional managers, Holdings', 'Notice by closed-end investment companies of intent to purchase their own securities', 'Annual Report for Registered Investment Companies - amended', 'Registration statement under Securities Act of 1933 - amended', 'Registration Statement for Securities of certain Canadian Issuers. - amended', 'Additional definitive proxy soliciting materials and Rule 14(a)(12) material', 'Annual report of employee stock purchase, savings and similar plans', 'Tender offer statement by Third Party - amended']

# sec_filing_titles1 = sec_filing_titles

# sec_filing_titles = sorted(sec_filing_titles1)
# print(sec_filing_titles)

# for i in sec_filing_titles:
#     print(i)





import os
import sys

parent_dir = os.path.abspath(os.path.join(os.path.dirname(__file__), '..'))
sys.path.append(parent_dir)


la = "<a:_:1047009752678408192>"
lb="<a:_:1045848939628339303>"
lc = "<a:_:1044647558133334126>"
le = "<a:_:1044647465724420146>"
lg = "<a:_:1044658349435785297>"
lt = "<a:_:1044647292201881622>"
lf = "<a:_:1044647531075862579>"
fireworks="<a:_:1104966851504652348>"
calendar="<a:_:1104233012020908042>"
lg = "<a:_:1044890977128685639>"
redline2="<a:_:1047965653375647765>"
india="<a:_:1103116109143613440>"
lh = "<a:_:1044647331997421628>"
li = "<a:_:1047009875152093244>"
magicspark="<a:_:1104567449023680542>"
green_magic="<a:_:1103772073299562628>"
red_magic="<a:_:1103772063912689835>"
infospin="<a:_:1104142591110418585>"
giveup = "<a:_:1039356920248676352>"
econcalendar="<a:_:1104567015810813992>"
lk="<a:_:1044891484203257907>"
sparkly="<a:_:1103867630001070111>"
ll = "<a:_:1047009895418957915>"
yellowmagic="<a:_:1104970138882682880>"
lm = "<a:_:1044891225221758986>"
ln = "<a:_:1044891293114974268>"
white_magic="<a:_:1104970201453305906>"
lo="<a:_:1044647404693106728>"
lp = "<a:_:1044648005694935150>"
lr = "<a:_:1044889950723768391>"
z="<a:_:1045882281945989190>"
download="<a:_:1048334456680882226>"
lw="<a:_:1047010090789634078>"
ls = "<a:_:1044891055872548884>"
lt = "<a:_:1047010360554704977>"
z="<a:_:1045882281945989190>"
ly="<a:_:1045883208530673684>"
eightball="<a:_:1049952868372856882>"
ofr="<:_:1050673837496336454>"
ld="<a:_:1045877274978811926>"
lj="<a:_:1044891452787916800>"
lq="<a:_:1047010303478616135>"
confirmed = "<a:_:1044143909623828490>"
lww="<a:_:1045878173021245440>"
lyy="<a:_:1045878234669129728>"
zz="<a:_:1045878307163471912>"
letr="<a:_:1044889950723768391>"
lv="<a:_:1045878049188614204>"
boss="<a:_:1050672885812957204>"
lu="<a:_:1045877932167528499>"
leftarrow = "<a:_:1043187704160071711>"
rightarrow = "<a:_:1043216013208064050>"
downarrow = "<a:_:1044140237183537232>"
uparrow = "<a:_:1044140790764535848>"
num1 = "<a:_:1043676146899877958>"
topleft="<:_:1044888244187316254>"
topright="<:_:1044888230530658324>"
bottomleft="<:_:1044888205092192397>"
bottomright="<:_:1044888219067629568>"
numb2 = "<a:_:1044765851506716673>"
shield="<a:_:1047279498468544612>"
sword="<a:_:1047279725875310623>"
greencheck = "<a:_:1044503960842670150>"
redcheck = "<a:_:1044504251805745182>"
liquid="<a:_:1062604701222326362>"
cmds="<:_:1054127352541609985>"
help="<:_:1054127724693827695>"
bottomrightarrow = "<a:_:1044884479367458856>"
coolchart="<a:_:1045908394751565904>"
num2 = "<a:_:1044890936724951060>"
tradertools = "<a:_:1044306475134222356>"
book = "<a:_:1044306890001227846>"
cooldownload="<a:_:1048872787269406771>"
signal = "<a:_:1043679047617622078>"
marketworld = "<a:_:1043277116487258175>"
downarrow = "<a:_:1044140237183537232>"
lx="<a:_:1047010384063770644>"
radar="<a:_:1045016684433510411>"
clockspin = "<a:_:1043017902191808523>"
float="<a:_:1045434703014006895>"
lightboltneon = "<a:_:1042674986474807388>"
chains="<a:_:1043679314731872296>"
economy="<a:_:1043016869797441607>"
btcemoji="<a:_:1043394475000598528>"
greenfire="<a:_:1043589872885174292>"
redfire="<a:_:1043589715145805934>"
movers="<a:_:1045076432755363920>"
moneycoin = "<a:_:1043016869797441607>"
greensignal = "<a:_:1043016503710208030>"
jasmy = "<a:_:1043024795404599438>"

portal = "<a:_:1044503531878621195>"

diamond = "<a:_:1043216090265821284>"
purpleslash="<a:_:1046691125391528057>"
lightningstrike = "<a:_:1043015881631993856>"
bughunter = "<a:_:1044447100286541824>"
pink1 = "<a:_:1046689587449315349>"
pink2 = "<a:_:1046689563617267743>"
pink3 = "<a:_:1046689536845033472>"
pink4 = "<a:_:1046689353386180710>"
pink5 = "<a:_:1046689344024477736>"
pink6 = "<a:_:1046689293080469514>"
pink7 = "<a:_:1046689252907429888>"
pink8 = "<a:_:1046689261505753139>"
pink9 = "<a:_:1046689129720721488>"
pink0 = "<a:_:1046689371497181185>"
botcmds = "<a:_:1043216006052585532>"
eye="<a:_:1044805505534660678>"
flowcmd="<a:_:1043016503710208030>"
worldwide= "<a:_:1043277116487258175>"
optioncmd="<a:_:1043015881631993856>"
exit = "<a:_:1042804564816039968>"

occ="<:_:1046522659736932403>"

stock="<a:_:1046840636197847071>"
finrawhite="<:_:1046265273033969695>"
question="<a:_:1043215909105451119>"
pinkrocket="<a:_:1043013214180483112>"
fudstop="<a:_:963244979063517184>"
links="<a:_:1044133031402811432>"
webullcmd="<a:_:1042676749357555794>"
earnings="<a:_:1043016743246901339>"
stocklightning="<a:_:1047558361765400576>"
learncmd="<a:_:1046087166838718524>"
balloons="<a:_:1044487851682836510>"
crown="<a:_:1045953364392935514>"
boom="<a:_:1043215915057152030>"
nose="👃🏼"
lightchart="<a:_:1047558361765400576>"
redline="<a:_:1047966739981406296>"
jailed="<:_:1047951378930225162>"
mouth="<a:_:1047417368646782988>"
blackmouth="<a:_:1047420547388145695>"
greyfire="<a:_:1043589654215143526>"
shot="<a:_:1047717231162834986>"
needle="<a:_:1047379706640597013>"
circlearrow="<a:_:1044135138944106587>"
moneytower="<a:_:1045016624601759806>"
turnover="<a:_:1043015510549348412>"
fail="<a:_:1045076835077202010>"
onemin="<a:_:1043215847038144572>"
uptrend="<a:_:1045174789150605375>"
movingchart="<a:_:1044795645799714846>"
glowstick="<a:_:1043016260415410206>"
toprightarrow="<:_:1044888230530658324>"
syringe="<a:_:1045018616606773380>"
rssfeeds="<a:_:1043215920484581447>"
pants="<a:_:1045016262541054073>"
video="<a:_:1044306544063430786>"
tools="<a:_:1044306475134222356>"
alert="<a:_:1043288010986369124>"
discordhelp="<a:_:1042675633278418944>"
drs="<a:_:1043215984695193672>"
important="<a:_:1043216020552302653>"
uptrend2="<a:_:1045916262615744532>"
madbear="<a:_:1045947201152634890>"
downtrend_arrow="<a:_:1045945801756643390>"
othercmd="<a:_:1042675967283441664>"
memx="<:_:1045909208450744330>"
nscc="<:_:1045909211592269916>"
fed="<:_:1046515029001904148>"
sec="<:_:1045909222770085979>"
fedstatic="<:_:1048811001946046484>"
dtcc="<:_:1045909203291738163>"
finra="<:_:1045909205531496569>"
ice="<:_:1045909206961766420>"
cboe="<:_:1046522227790716968>"
nyse="<:_:1045909213269983262>"
oic="<:_:1045909214708633700>"
reddit="<:_:1045909219276230707>"
salomon="<:_:1045909221197221939>"
cmdtext =f"🇨 🇲 🇩 🇸"
datas="<a:_:1048242541872562206>"
economydata="<a:_:1048243101170421781>"
china="<a:_:1048244168876642355>"
repo="<a:_:1048243785408184362>"
moneygun="<a:_:1048245870514159706>"
pinkcrystal="<a:_:1048245381420552282>"
hammering="<a:_:1048246249058471977>"
treasury="<a:_:1048288266618679336>"

usa="<a:_:1048392681585389570>"
newzealand="<a:_:1048392751676391475>"
japan="<a:_:1048393085882732636>"
germany="<a:_:1048393601853427752>"
ukraine="<a:_:1048393374014648381>"
switzerland="<a:_:1048393294935244840>"
australia="<a:_:1048393806766161941>"
france="<a:_:1048393544378875915>"
canada="<a:_:1048393669268484096>"
russia="<a:_:1048393151464886314>"
unitedkingdom="<a:_:1048394904264519711>"
italy="<a:_:1048395123131686993>"



real_subs=["BVN", "BHC", 'I:SPX', 'I:VIX', 'I:NDX', "AMC", "BYND", "SNAP", "TAL", "AGNC", "NIO", "AAOI", "RIOT", "TEVA", "ETRN", "ZIM", "NOVA", "HOOD", "VTRS", "LYFT", "KEY", "ENVX", "WBD", "GPS", "WW", "DB", "STNE", "RUN", "VKTX", "HTZ", "NYCB", "UPWK", "SOXS", "M", "LMND", "PARA", "AROC", "F", "GT", "SPXU", "AAL", "VALE", "CCL", "BILI", "ET", "ABR", "PAAS", "PBR", "FYBR", "BITO", "GRPN", "GOLD", "T", "JWN", "IONQ", "NVCR", "GME", "OSTK", "PCG", "CLF", "BEKE", "PLTR", "PTGX", "KMI", "SPXS", "TSLL", "NCLH", "AEO", "SAVE", "VFC", "TDS", "PATH", "JETS", "CPNG", "MP", "LTHM", "TOST", "NLY", "AFRM", "XPEV", "IEP", "FSLY", "CHWY", "TDOC", "FL", "SOXL", "STLA", "CVE", "NOV", "SLV", "MANU", "KVUE", "SQQQ", "KSS", "PENN", "BYLD", "MXL", "WBA", "DOCN", "LNC", "PPC", "RIVN", "BTU", "AR", "BBIO", "AI", "MRO", "QQMG", "ALLY", "ONON", "ASHR", "FXI", "EWG", "YINN", "GDX", "BAC", "HPQ", "TNA", "TRUP", "PINS", "KWEB", "UPST", "EPD", "SDOW", "AA", "TFC", "LUV", "JD", "CRTO", "DKNG", "EWZ", "U", "RBLX", "UUP", "BTI", "GDXJ", "CSX", "EWU", "COHR", "GM", "SPIB", "UCO", "USB", "VZ", "SU", "OPCH", "FNGS", "X", "XLF", "WMB", "B", "KHC", "PFE", "ZION", "MOS", "TZA", "MGM", "SLG", "LI", "NEM", "FLR", "FCX", "INTC", "TQQQ", "DAL", "CCJ", "BP", "EEM", "APLS", "CVNA", "MTCH", "APA", "VRT", "HAL", "ARKK", "WFC", "TECK", "CMA", "EQT", "C", "CPB", "UPRO", "KRE", "TBT", "UAL", "DOCU", "MO", "SE", "SQ", "YELP", "EBAY", "WAL", "DVN", "AEM", "CMCSA", "Z", "LVS", "CZR", "UBER", "WDC", "SMG", "TSN", "DPST", "IAC", "STNG", "XME", "NEE", "DOW", "SCHW", "BSX", "MNST", "AAP", "SHOP", "SIMO", "BUD", "MRVL", "CSCO", "FIS", "FUTU", "CARR", "KO", "FAS", "SLB", "TWLO", "BOIL", "BMY", "XLU", "EWY", "EWJ", "W", "KOLD", "FTNT", "PYPL", "EDU", "NET", "XRT", "MET", "OXY", "RIO", "CAMT", "SHEL", "ETSY", "ZM", "AZN", "EFA", "MU", "KMX", "XLP", "CVS", "XBI", "RTX", "ROKU", "HYG", "COIN", "DD", "GDDY", "XPO", "GILD", "XHB", "USO", "IYR", "MDT", "SPB", "SPXL", "MCHP", "DASH", "OKTA", "MS", "DIS", "TTD", "EMB", "BABA", "CROX", "XLE", "TLT", "TSM", "FND", "MMM", "WYNN", "DDOG", "RCL", "ON", "IEF", "SBUX", "ATVI", "ABT", "NKE", "NVS", "PDD", "XLI", "EXPE", "LQD", "GNRC", "MRK", "TIP", "AMD", "BX", "MRNA", "TGT", "ORCL", "GE", "QCOM", "XOM", "IEI", "COP", "HZNP", "ENPH", "DLR", "EOG", "SEDG", "AMZN", "ABNB", "BIDU", "XLV", "VLO", "GOOGL", "GOOG", "XOP", "TMUS", "RSP", "AMAT", "TTWO", "IBM", "MPC", "JPM", "SMH", "FANG", "PG", "AXP", "ABBV", "HLT", "FSLR", "SNOW", "UPS", "ZS", "JNJ", "TXN", "ALB", "SPOT", "XLY", "WMT", "CVX", "CRWD", "XLK", "VMW", "PEP", "GLD", "IWM", "AAPL", "ADI", "ANET", "BA", "TEAM", "LOW", "CRM", "UNP", "SGEN", "V", "PANW", "MCD", "FDX", "TSLA", "CAT", "AMGN", "SMCI", "HD", "META", "GS", "MSFT", "MSTR", "DIA", "MDB", "QQQ", "LULU", "NFLX", "DE", "MA", "ULTA", "URI", "SPY", "NVDA", "HUM", "UNH", "ADBE", "LLY", "NOW", "COST", "LRCX", "AVGO", "CMG", "BKNG"]



indices_names_and_symbols_dict={"I:A1BSC": "Dow Jones Americas Basic Materials Index", "I:A1CYC": "Dow Jones Americas Consumer Services Index", "I:A1DOW": "Dow Jones Americas Index", "I:A1ENE": "Dow Jones Americas Oil & Gas Index", "I:A1FIN": "Dow Jones Americas Financials Index", "I:A1HCR": "Dow Jones Americas Health Care Index", "I:A1IDU": "Dow Jones Americas Industrials Index", "I:A1NCY": "Dow Jones Americas Consumer Goods Index", "I:A1SGI": "Dow Jones Sustainability North America Composite Index (USD)", "I:A1TEC": "Dow Jones Americas Technology Index", "I:A1TLS": "Dow Jones Americas Telecommunications Index", "I:A1UTI": "Dow Jones Americas Utilities Index", "I:AAVE100": "Cboe 100 Aave / US Dollar RealPrice Index", "I:AAVE10RP": "Cboe 10 Aave / US Dollar RealPrice Index", "I:AAVE25RP": "Cboe 25 Aave / US Dollar RealPrice Index", "I:AAVE400": "Cboe 400 Aave / US Dollar RealPrice Index", "I:AAVE50RP": "Cboe 50 Aave / US Dollar RealPrice Index", "I:ABAQ": "ABA NASDAQ Community Bank", "I:ABQI": "NASDAQ OMX ABA Community Bank", "I:ABQX": "NASDAQ OMX ABA Community Bank Total Rtn", "I:ADA100K": "Cboe 100K Cardano / US Dollar RealPrice Index", "I:ADA10KRP": "Cboe 10K Cardano / US Dollar RealPrice Index", "I:ADA25KRP": "Cboe 25K Cardano / US Dollar RealPrice Index", "I:ADA50KRP": "Cboe 50K Cardano / US Dollar RealPrice Index", "I:ADA5KRP": "Cboe 5000 Cardano / US Dollar RealPrice Index", "I:ADOW": "The Asia Dow (USD)", "I:ADOWA": "The Asia Dow (AUD)", "I:ADOWE": "The Asia Dow (EUR)", "I:ADOWJ": "The Asia Dow (JPY)", "I:AGQIV": "PROSHARES ULTRA SILVER ETF", "I:ALGO100": "Cboe 100 Algorand / US Dollar RealPrice Index", "I:ALGO1KRP": "Cboe 1000 Algorand / US Dollar RealPrice Index", "I:ALGO5KRP": "Cboe 5000 Algorand / US Dollar RealPrice Index", "I:AMBOR1M": "AMERIBOR 1 Month Spot Rate", "I:AMBOR1W": "AMERIBOR 1 Week Spot Rate", "I:AMBOR1Y": "AMERIBOR 1 Year Spot Rate", "I:AMBOR2Y": "AMERIBOR 2 Year Spot Rate", "I:AMBOR30": "30 Day Average AMERIBOR Rate", "I:AMBOR30T": "AMERIBOR Term-30 Rate", "I:AMBOR3M": "AMERIBOR 3 Month Spot Rate", "I:AMBOR6M": "AMERIBOR 6 Month Spot Rate", "I:AMBOR90": "90 Day Average AMERIBOR Rate", "I:AMBOR90T": "AMERIBOR Term-90 Rate", "I:AMBOS": "One Month AMERIBOR Average Settlement", "I:AMBOX": "One Month AMERIBOR Average Rate", "I:AMBRS": "14 Day AMERIBOR Average Settlement", "I:AMBRX": "14 Day AMERIBOR Average Rate", "I:AMBTS": "Three Month AMERIBOR Compound Average Settlement", "I:AMBTX": "Three Month AMERIBOR Compound Average Rate", "I:AMBWS": "7 Day AMERIBOR Average Settlement", "I:AMBWX": "7 Day AMERIBOR Average Rate", "I:AMERIBOR": "AMERIBOR Unsecured Overnight Rate", "I:AMT1M": "AMERIBOR Term-30 Rate", "I:AMT1R": "Ameribor 30 Day Term Settlement Rate", "I:AMT1S": "Ameribor 30 Day Term Settlement Value", "I:AMT3M": "AMERIBOR Term-90 Rate", "I:AMT3R": "Ameribor 90 Day Term Settlement Rate", "I:AMT3S": "Ameribor 90 Day Term Settlement Value", "I:ANEWIV": "PROSHARES MSCI TRANSFORMATIONAL CHANGES ETF", "I:APRTIV": "AllianzIM U.S. Large Cap Buffer10 Apr ETF Intraday Indicative Value", "I:APRWIV": "AllianzIM U.S. Large Cap Buffer20 Apr ETF Intraday Indicative Value", "I:APRZIV": "TrueShares Structured Outcome (April) ETF Intraday Indicative Value", "I:ATDOW": "Dow Jones Austria Index", "I:ATDOWD": "Dow Jones Austria Index (USD)", "I:ATOM150": "Cboe 150 Cosmos / US Dollar RealPrice Index", "I:ATOM300": "Cboe 300 Cosmos / US Dollar RealPrice Index", "I:ATOM600": "Cboe 600 Cosmos / US Dollar RealPrice Index", "I:ATOM75RP": "Cboe 75 Cosmos / US Dollar RealPrice Index","I:AUDOWD": "Dow Jones Australia Index (USD)", "I:AUGZIV": "TrueShares Structured Outcome (August) ETF Intraday Indicative Value", "I:AVCHQYLD": "Alpha Vee Quality Yield", "I:AVGRNTSP": "Alpha Vee Green Transportation", "I:AVRMENEQ": "Alpha Vee Risk Managed Enhanced US Equity", "I:AVT5EQTB": "Alpha Vee Risk Managed Top 5 Sector Equities & Treasury Bonds", "I:AVT5ETTB": "Alpha Vee Risk Managed Top 5 Sector ETFs & Treasuries", "I:AVT5SMID": "Alpha Vee Risk Managed SMID Top 5 Sector Equities", "I:AVUSMEGA": "Alpha Vee US Mega Cap", "I:B10GI": "OMX Baltic Technology GI", "I:B10PI": "OMX Baltic Technology PI", "I:B15GI": "OMX Baltic Telecommunications GI", "I:B15PI": "OMX Baltic Telecommunications PI", "I:B20GI": "OMX Baltic Health Care GI", "I:B20PI": "OMX Baltic Health Care PI", "I:B3010GI": "OMX Baltic Banks GI", "I:B3010PI": "OMX Baltic Banks PI", "I:B3020GI": "OMX Baltic Financial Services GI", "I:B3020PI": "OMX Baltic Financial Services PI", "I:B30GI": "OMX Baltic Financials GI", "I:B30PI": "OMX Baltic Financials PI", "I:B35GI": "OMX Baltic Real Estate GI", "I:B35PI": "OMX Baltic Real Estate PI", "I:B4020GI": "OMX Baltic Consumer Products and Services GI", "I:B4020PI": "OMX Baltic Consumer Products and Services PI", "I:B4030GI": "OMX Baltic Media GI", "I:B4030PI": "OMX Baltic Media PI", "I:B4040GI": "OMX Baltic Retail GI", "I:B4040PI": "OMX Baltic Retail PI", "I:B4050GI": "OMX Baltic Travel and Leisure GI", "I:B4050PI": "OMX Baltic Travel and Leisure PI", "I:B40GI": "OMX Baltic Consumer Discretionary GI", "I:B40PI": "OMX Baltic Consumer Discretionary PI", "I:B4510GI": "OMX Baltic Food, Beverage and Tobacco  GI", "I:B4510PI": "OMX Baltic Food, Beverage and Tobacco  PI", "I:B45GI": "OMX Baltic Consumer Staples GI", "I:B45PI": "OMX Baltic Consumer Staples PI", "I:B5010GI": "OMX Baltic Construction and Materials GI", "I:B5010PI": "OMX Baltic Construction and Materials PI", "I:B5020GI": "OMX Baltic Industrial Goods and Services GI", "I:B5020PI": "OMX Baltic Industrial Goods and Services PI", "I:B50BRD": "Dow Jones BRIC Brazil 15 Index (USD)", "I:B50BRE": "Dow Jones BRIC Brazil 15 Index (EUR)", "I:B50CND": "Dow Jones BRIC China 15 Index (USD)", "I:B50CNE": "Dow Jones BRIC China 15 Index (EUR)", "I:B50GI": "OMX Baltic Industrials GI", "I:B50IND": "Dow Jones BRIC India 15 Index (USD)", "I:B50INE": "Dow Jones BRIC India 15 Index (EUR)", "I:B50PI": "OMX Baltic Industrials PI", "I:B5510GI": "OMX Baltic Basic Resources GI", "I:B5510PI": "OMX Baltic Basic Resources PI", "I:B55GI": "OMX Baltic Basic Materials GI", "I:B55PI": "OMX Baltic Basic Materials PI", "I:B65GI": "OMX Baltic Utilities GI", "I:B65PI": "OMX Baltic Utilities PI", "I:BANK": "Nasdaq Bank", "I:BANKT": "Nasdaq Bank Total Return", "I:BAT100RP": "Cboe 100 Basic Attention Token / US Dollar RealPrice Index", "I:BAT1KRP": "Cboe 1000 Basic Attention Token / US Dollar RealPrice Index", "I:BAT200RP": "Cboe 200 Basic Attention Token / US Dollar RealPrice Index", "I:BAT500RP": "Cboe 500 Basic Attention Token / US Dollar RealPrice Index", "I:BCH100RP": "Cboe 100 Bitcoin Cash / USD RealPrice", "I:BCH10RP": "Cboe 10 Bitcoin Cash / USD RealPrice", "I:BCH1RP": "Cboe 1 Bitcoin Cash / US Dollar RealPrice Index", "I:BCH20RP": "Cboe 20 Bitcoin Cash / USD RealPrice", "I:BCH40RP": "Cboe 40 Bitcoin Cash / USD RealPrice", "I:BCH5RP": "Cboe 5 Bitcoin Cash / USD RealPrice", "I:BCHBTC": "Bitcoin Cash vs Bitcoin", "I:BCHUSD": "Bitcoin Cash vs US Dollar", "I:BDEA": "Cboe MSCI EAFE 20-Delta BuyWrite Index", "I:BDEF": "Cboe MSCI Emerging Markets 20-Delta BuyWrite Index", "I:BEDOW": "Dow Jones Belgium Index", "I:BEDOWD": "Dow Jones Belgium Index (USD)", "I:BEWELL": "Nasdaq CTA Global Digital Health Index", "I:BEWELLAU": "Nasdaq CTA Global Digital Health AUD Index", "I:BEWELLAUNR": "Nasdaq CTA Global Digital Health Net Total Return AUD Index", "I:BEWELLAUTR": "Nasdaq CTA Global Digital Health Gross Total Return AUD Index", "I:BEWELLNR": "Nasdaq CTA Global Digital Health Net Total Return Index", "I:BEWELLTR": "Nasdaq CTA Global Digital Health Gross Total Return Index", "I:BFLY": "Cboe S&P 500 Iron Butterfly Index", "I:BFLYEA": "Cboe MSCI EAFE Iron Butterfly Index", "I:BFLYEF": "Cboe MSCI Emerging Markets Iron Butterfly Index", "I:BIBIV": "PROSHARES ULTRA NASDAQ BIOTECHNOLOGY ETF", "I:BIQ": "ISE BICK Index", "I:BIQNTR": "ISE BICK Net Total Return Index", "I:BIQTR": "ISE BICK Total Return Index", "I:BISIV": "PROSHARES ULTRASHORT NASDAQ BIOTECHNOLOGY ETF", "I:BITIIV": "ProShares Short Bitcoin Strategy ETF", "I:BITOIV": "ProShares Bitcoin Strategy ETF", "I:BKX": "KBW Nasdaq Bank Index", "I:BKXNTR": "KBW Nasdaq Bank Net Total Return Index", "I:BKXTR": "KBW Nasdaq Bank Total Return Index", "I:BLX": "Bitcoin Liquid Index", "I:BNB100RP": "Cboe 100 Binance Coin / US Dollar RealPrice Index", "I:BNB20RP": "Cboe 20 Binance Coin / US Dollar RealPrice Index", "I:BNB400RP": "Cboe 400 Binance Coin / US Dollar RealPrice Index", "I:BNB5RP": "Cboe 5 Binance Coin / US Dollar RealPrice Index", "I:BNT200RP": "Cboe 200 Bancor / US Dollar RealPrice Index", "I:BNT2KRP": "Cboe 2000 Bancor / US Dollar RealPrice Index", "I:BNT500RP": "Cboe 500 Bancor / US Dollar RealPrice Index", "I:BNT50RP": "Cboe 50 Bancor / US Dollar RealPrice Index", "I:BOILIV": "PROSHARES ULTRA BLOOMBERG NATURAL GAS ETF", "I:BR20": "Dow Jones Brazil Titans 20 ADR Index", "I:BRIC50D": "Dow Jones BRIC 50 Index (USD)", "I:BRIC50E": "Dow Jones BRIC 50 Index (EUR)", "I:BSZ": "Cboe S&P 500 Index Binary Options", "I:BTC10RP": "Cboe 10 Bitcoin / USD RealPrice", "I:BTC1RP": "Cboe 1 Bitcoin / USD RealPrice", "I:BTC20PRP": "Cboe 0.2 Bitcoin / USD RealPrice", "I:BTC20RP": "Cboe 20 Bitcoin / USD RealPrice", "I:BTC5RP": "Cboe 5 Bitcoin / USD RealPrice", "I:BTCUSD": "Bitcoin vs US Dollar", "I:BXD": "Cboe DJIA BuyWrite Index", "I:BXDE": "DJIA Cboe BuyWrite V2 Index", "I:BXEA": "Cboe MSCI EAFE BuyWrite Index", "I:BXEF": "Cboe MSCI Emerging Markets BuyWrite Index", "I:BXESG": "Cboe S&P 500 ESG BuyWrite Index", "I:BXHB": "Cboe HYG BuyWrite Index", "I:BXLB": "Cboe LQD BuyWrite Index", "I:BXLFH": "Cboe S&P Financials Select Sector Half BuyWrite Index", "I:BXLKH": "Cboe S&P Technology Select Sector Half BuyWrite Index", "I:BXLVH": "Cboe S&P Health Care Select Sector Half BuyWrite Index", "I:BXM": "Cboe S&P 500 BuyWrite Index", "I:BXMC": "Cboe S&P 500 Conditional BuyWrite Index", "I:BXMD": "Cboe S&P 500 30-Delta BuyWrite Index", "I:BXMH": "Cboe S&P 500 Half BuyWrite Index", "I:BXMU": "Cboe S&P 500 BuyWrite 15% WHT", "I:BXMVM": "Cboe S&P 500 Managed Volatility BuyWrite Index", "I:BXMW": "Cboe S&P 500 Multi-Week BuyWrite Index", "I:BXN": "Cboe NASDAQ-100 BuyWrite Index", "I:BXNH": "Cboe NASDAQ-100 Half BuyWrite V2 Index", "I:BXNT": "Cboe NASDAQ-100 BuyWrite V2 Index", "I:BXNTU": "Cboe NASDAQ-100 BuyWrite V2 UCITS Index", "I:BXR": "Cboe Russell 2000 BuyWrite Index", "I:BXRC": "Cboe Russell 2000 Conditional Buywrite Index", "I:BXRD": "Cboe Russell 2000 30-Delta BuyWrite Index", "I:BXRH": "Cboe Russell 2000 Half BuyWrite Index", "I:BXRT": "CBOE Russell 2000 30-Delta Buywrite V2 Index", "I:BXTB": "Cboe TLT 2% OTM BuyWrite Index", "I:BXTW": "Cboe 20+ Year Treasury Bond One", "I:BXY": "Cboe S&P 500 2% OTM BuyWrite Index", "I:BYC": "Morgan Stanley 0% STARS Cboe S&P 500 Buy", "I:BYEA": "Cboe MSCI EAFE 2% OTM BuyWrite Index", "I:BYEF": "Cboe MSCI Emerging Markets 2% OTM BuyWrite Index", "I:BZQIV": "PROSHARES ULTRASHORT MSCI BRAZIL CAPPED ETF", "I:CADOW": "Dow Jones Canada Index", "I:CADOWD": "Dow Jones Canada Index (USD)", "I:CALD": "Cboe Validus S&P500 Dynamic Call BuyWrite Index", "I:CAPEXA": "Nasdaq US CapEx Achievers Index", "I:CAPEXAN": "Nasdaq US CapEx Achievers Net Total Return Index", "I:CAPEXAT": "Nasdaq US CapEx Achievers Total Return Index", "I:CBMKCCSI": "Wholesale Cannabis Price Paid by the Distributor", "I:CBMKCNLP": "Wholesale Cannabis Price Paid to Licensed Producer", "I:CBMKETAX": "Canada Wt Avg Fed/Prov Excise Tax Paid by Lic Prod", "I:CDSPG": "SPX Gamma Weighted Dispersion", "I:CDSPT": "SPX Theta Weighted Dispersion", "I:CDSPV": "SPX Vega Weighted Dispersion", "I:CELS": "NASDAQ Clean Edge Green Energy", "I:CELSEW": "Nasdaq Clean Edge Green Energy EW Index", "I:CELSEWN": "Nasdaq Clean Edge Green Energy EW NTR Index", "I:CELSEWT": "Nasdaq Clean Edge Green Energy EW TR Index", "I:CELSI": "Nasdaq Clean Edge International Green Energy Index", "I:CELSIN": "Nasdaq Clean Edge International Green Energy Net Total Return Index", "I:CELSIT": "Nasdaq Clean Edge International Green Energy Total Return Index", "I:CELSN": "Nasdaq Clean Edge Green Energy Net Total Return Index", "I:CEX": "Standard & Poors Chemicals Index", "I:CEXX": "NASDAQ Clean Edge Green Energy Total Return", "I:CH30": "Dow Jones Switzerland Titans 30 Index", "I:CH30D": "Dow Jones Switzerland Titans 30 Index (USD)", "I:CHDOW": "Dow Jones Switzerland Index", "I:CHDOWD": "Dow Jones Switzerland Index (USD)", "I:CHXN9000": "NASDAQ OMX China Technology", "I:CHXN9000NX": "NASDAQ OMX China Technology Net Total Return", "I:CHXN9000X": "NASDAQ OMX China Technology Total Return", "I:CLDOW": "Dow Jones Chile Index", "I:CLDOWD": "Dow Jones Chile Index (USD)", "I:CLESG": "CRSP ISS US Large Cap ESG Index", "I:CLESGB": "CRSP ISS US Large Cap ESG Industry Balanced Index", "I:CLESGBR": "CRSP ISS US Large Cap ESG Industry Balanced Remain", "I:CLESGBRT": "CRSP ISS US Large Cap ESG Industry Balanced Remain", "I:CLESGBT": "CRSP ISS US Large Cap ESG Industry Balanced Index", "I:CLESGNP": "CRSP ISS US Large Cap ESG Non-Prime Index", "I:CLESGNPT": "CRSP ISS US Large Cap ESG Non-Prime Index TR", "I:CLESGP": "CRSP ISS US Large Cap ESG Prime Index", "I:CLESGPT": "CRSP ISS US Large Cap ESG Prime Index TR", "I:CLESGR": "CRSP ISS US Large Cap ESG Remainder Index", "I:CLESGRT": "CRSP ISS US Large Cap ESG Remainder Index TR", "I:CLESGT": "CRSP ISS US Large Cap ESG Index TR", "I:CLIXIV": "PROSHARES LONG ONLINE/SHORT STORES ETF", "I:CLL": "Cboe S&P 500 95-110 Collar Index", "I:CLL1M": "Cboe S&P 500 Risk Managed Income Index", "I:CLL3M": "Cboe S&P 500 3-Month Collar 95-110 Index", "I:CLLR": "Cboe Russell 2000 Zero-Cost Put Spread Collar Index", "I:CLLZ": "Cboe S&P 500 Zero-Cost Put Spread Collar Index", "I:CLMTCH": "Nasdaq CTA Global Climate Technology Index", "I:CLMTCHN": "Nasdaq CTA Global Climate Technology Net Total Return Index", "I:CLMTCHT": "Nasdaq CTA Global Climate Technology Total Return Index", "I:CMBO": "Cboe S&P 500 Covered Combo Index", "I:CMBOEA": "Cboe MSCI EAFE Covered Combo Index", "I:CMBOEF": "Cboe MSCI Emerging Markets Covered Combo Index", "I:CMC200": "CMC Crypto 200 Index by Solactive", "I:CMC200EX": "CMC Crypto 200 ex BTC Index by Solactive", "I:CNDR": "Cboe S&P 500 Iron Condor Index", "I:CNDREA": "Cboe MSCI EAFE Iron Condor Index", "I:CNDREF": "Cboe MSCI Emerging Markets Iron Condor Index", "I:COMP": "NASDAQ Composite", "I:COMPCAD": "NASDAQ Composite Index CAD", "I:COMPCADMH": "NASDAQ Composite Monthly Currency Hedged CAD", "I:COR10D": "Cboe 3-Month 10 Delta Implied Correlation Index", "I:COR1M": "Cboe 1-Month Implied Correlation Index", "I:COR1Y": "Cboe 1-Year Implied Correlation Index", "I:COR30D": "Cboe 3-Month 30 Delta Cboe Implied Correlation Index", "I:COR3M": "Cboe 3-Month Implied Correlation Index", "I:COR6M": "Cboe 6-Month Implied Correlation Index", "I:COR70D": "Cboe 3-Month 70 Delta Cboe Implied Correlation Index", "I:COR90D": "Cboe 3-Month 90 Delta Cboe Implied Correlation Index", "I:COR9M": "Cboe 9-Month Implied Correlation Index", "I:CPQ": "ISE CTA Cloud Computing Index", "I:CPQI": "Nasdaq CTA International Cloud Computing Index", "I:CPQINTR": "Nasdaq CTA International Cloud Computing Net Total Return Index", "I:CPQITR": "Nasdaq CTA International Cloud Computing Total Return Index", "I:CPQNTR": "ISE CTA Cloud Computing Net Total Return Index", "I:CPQTR": "ISE CTA Cloud Computing Total Return Index", "I:CRSPCD1": "CRSP US Consumer Discretionary Index", "I:CRSPCDT": "CRSP US Consumer Discretionary Total Return Index", "I:CRSPCS1": "CRSP US Consumer Staples Index", "I:CRSPCST": "CRSP US Consumer Staples Total Return Index", "I:CRSPEN1": "CRSP US Energy Index", "I:CRSPENT": "CRSP US Energy Total Return Index", "I:CRSPFN1": "CRSP US Financials Index", "I:CRSPFNT": "CRSP US Financials TR Index", "I:CRSPHC1": "CRSP US Health Care Index", "I:CRSPHCT": "CRSP US Health Care TR Index", "I:CRSPID1": "CRSP US Industrials Index", "I:CRSPIDT": "CRSP US Industrials TR Index", "I:CRSPIT1": "CRSP US Technology Index", "I:CRSPITT": "CRSP US Technology TR Index", "I:CRSPLC1": "CRSP US Large Cap Index", "I:CRSPLCG1": "CRSP US Large Cap Growth Index", "I:CRSPLCGT": "CRSP US Large Cap Growth TR Index", "I:CRSPLCGV": "CRSP US Large Cap Growth OSV Index", "I:CRSPLCT": "CRSP US Large Cap TR Index", "I:CRSPLCV": "CRSP US Large Cap OSV Index", "I:CRSPLCV1": "CRSP US Large Cap Value Index", "I:CRSPLCVT": "CRSP US Large Cap Value TR Index", "I:CRSPLCVV": "CRSP US Large Cap Value OSV Index", "I:CRSPMC1": "CRSP US Micro Cap Index", "I:CRSPMCT": "CRSP US Micro Cap TR Index", "I:CRSPME1": "CRSP US Mega Cap Index", "I:CRSPMEG1": "CRSP US Mega Cap Growth Index", "I:CRSPMEGT": "CRSP US Mega Cap Growth TR Index", "I:CRSPMEGV": "CRSP US Mega Cap Growth OSV Index", "I:CRSPMET": "CRSP US Mega Cap TR Index", "I:CRSPMEV": "CRSP US Mega Cap OSV Index", "I:CRSPMEV1": "CRSP US Mega Cap Value Index", "I:CRSPMEVT": "CRSP US Mega Cap Value TR Index", "I:CRSPMEVV": "CRSP US Mega Cap Value OSV Index", "I:CRSPMI1": "CRSP US Mid Cap Index", "I:CRSPMIG1": "CRSP US Mid Cap Growth Index", "I:CRSPMIGT": "CRSP US Mid Cap Growth TR Index", "I:CRSPMIGV": "CRSP US Mid Cap Growth OSV Index", "I:CRSPMIT": "CRSP US Mid Cap TR Index", "I:CRSPMIV": "CRSP US Mid Cap OSV Index", "I:CRSPMIV1": "CRSP US Mid Cap Value Index", "I:CRSPMIVT": "CRSP US Mid Cap Value TR Index", "I:CRSPMIVV": "CRSP US Mid Cap Value OSV Index", "I:CRSPMT1": "CRSP US Basic Materials Index", "I:CRSPMTT": "CRSP US Basic Materials Total Return Index", "I:CRSPRE1": "CRSP US Real Estate Index", "I:CRSPRET": "CRSP US Real Estate Total Return Index", "I:CRSPSC1": "CRSP US Small Cap Index", "I:CRSPSCG1": "CRSP US Small Cap Growth Index", "I:CRSPSCGT": "CRSP US Small Cap Growth TR Index", "I:CRSPSCGV": "CRSP US Small Cap Growth OSV Index", "I:CRSPSCT": "CRSP US Small Cap TR Index", "I:CRSPSCV": "CRSP US Small Cap OSV Index", "I:CRSPSCV1": "CRSP US Small Cap Value Index", "I:CRSPSCVT": "CRSP US Small Cap Value TR Index", "I:CRSPSCVV": "CRSP US Small Cap Value OSV Index", "I:CRSPSM1": "CRSP US Small/Mid Cap  Index", "I:CRSPSMG1": "CRSP US Small/Mid Cap Growth Index", "I:CRSPSMGT": "CRSP US Small/Mid Cap Growth Total Return Index", "I:CRSPSMGV.TEST": "CRSP US Small/Mid Cap Growth OS TEST", "I:CRSPSMT": "CRSP US Small/Mid Cap Total Return Index", "I:CRSPSMV": "CRSP US Small/Mid Cap\u00a0OSV Index", "I:CRSPSMV1": "CRSP US Small/Mid Cap Value Index", "I:CRSPSMVT": "CRSP US Small/Mid Cap Value Total Return Index", "I:CRSPSMVV": "CRSP US Small/Mid Cap Value OSV Index", "I:CRSPSX1": "CRSP US Small Cap Ex-Real Estate Index", "I:CRSPSXT": "CRSP US Small Cap Ex-Real Estate Total Return Inde", "I:CRSPTAH1": "CRSP US Total Market Index (AUD-hedged)", "I:CRSPTAHT": "CRSP US Total Market Total Return Index (AUD-hedge", "I:CRSPTCH1": "CRSP US Total Market Index (CAD-hedged)", "I:CRSPTCHT": "CRSP US Total Market TR Index (CAD-hedged)", "I:CRSPTE1": "CRSP US Telecommunications Index", "I:CRSPTET": "CRSP US Telecommunications Total Return Index", "I:CRSPTM1": "CRSP US Total Market Index", "I:CRSPTMA1": "CRSP US Total Market Index AUD", "I:CRSPTMAT": "CRSP US Total Market Total Return Index AUD", "I:CRSPTMC1": "CRSP US Total Market Index CAD", "I:CRSPTMCT": "CRSP US Total Market Total Return Index CAD", "I:CRSPTMT": "CRSP US Total Market TR Index", "I:CRSPTMV": "CRSP US Total Market OSV Index", "I:CRSPUT1": "CRSP US Utilities Index", "I:CRSPUTT": "CRSP US Utilities TR Index", "I:CSMIV": "PROSHARES LARGE CAP CORE PLUS ETF", "I:CTEXIV": "PROSHARES S&P KENSHO CLEANTECH ETF", "I:CUSCELS": "Nasdaq Clean Edge Green Energy Custom Index", "I:CUSCELSNR": "Nasdaq Clean Edge Green Energy Custom Net Total Return Index", "I:CUSCELSTR": "Nasdaq Clean Edge Green Energy Custom Gross Total Return Index", "I:CX101010GI": "OMX Copenhagen Software and Computer Services GI", "I:CX101010PI": "OMX Copenhagen Software and Computer Services PI", "I:CX101020GI": "OMX Copenhagen Technology Hardware and Equipment GI", "I:CX101020PI": "OMX Copenhagen Technology Hardware and Equipment PI", "I:CX10GI": "OMX Copenhagen Technology GI", "I:CX10PI": "OMX Copenhagen Technology PI", "I:CX151010GI": "OMX Copenhagen Telecommunications Equipment GI", "I:CX151010PI": "OMX Copenhagen Telecommunications Equipment PI", "I:CX15GI": "OMX Copenhagen Telecommunications GI", "I:CX15PI": "OMX Copenhagen Telecommunications PI", "I:CX201020GI": "OMX Copenhagen Medical Equipment and Services GI", "I:CX201020PI": "OMX Copenhagen Medical Equipment and Services PI", "I:CX201030GI": "OMX Copenhagen Pharmaceuticals and Biotechnology GI", "I:CX201030PI": "OMX Copenhagen Pharmaceuticals and Biotechnology PI", "I:CX20GI": "OMX Copenhagen Health Care GI", "I:CX20PI": "OMX Copenhagen Health Care PI", "I:CX3010GI": "OMX Copenhagen Banks GI", "I:CX3010PI": "OMX Copenhagen Banks PI", "I:CX302020GI": "OMX Copenhagen Investment Banking and Brokerage Services  GI", "I:CX302020PI": "OMX Copenhagen Investment Banking and Brokerage Services  PI", "I:CX3020GI": "OMX Copenhagen Financial Services GI", "I:CX3020PI": "OMX Copenhagen Financial Services PI", "I:CX303020GI": "OMX Copenhagen Non-life Insurance GI", "I:CX303020PI": "OMX Copenhagen Non-life Insurance PI", "I:CX3030GI": "OMX Copenhagen Insurance GI", "I:CX3030PI": "OMX Copenhagen Insurance PI", "I:CX30GI": "OMX Copenhagen Financials GI", "I:CX30PI": "OMX Copenhagen Financials PI", "I:CX351010GI": "OMX Copenhagen Real Estate Investment and Services GI", "I:CX351010PI": "OMX Copenhagen Real Estate Investment and Services PI", "I:CX351020GI": "OMX Copenhagen Real Estate Investment Trusts GI", "I:CX351020PI": "OMX Copenhagen Real Estate Investment Trusts PI", "I:CX35GI": "OMX Copenhagen Real Estate GI", "I:CX35PI": "OMX Copenhagen Real Estate PI", "I:CX4010GI": "OMX Copenhagen Automobiles and Parts GI", "I:CX4010PI": "OMX Copenhagen Automobiles and Parts PI", "I:CX402020GI": "OMX Copenhagen Household Goods and Home Construction GI", "I:CX402020PI": "OMX Copenhagen Household Goods and Home Construction PI", "I:CX402030GI": "OMX Copenhagen Leisure Goods GI", "I:CX402030PI": "OMX Copenhagen Leisure Goods PI", "I:CX402040GI": "OMX Copenhagen Personal Goods GI", "I:CX402040PI": "OMX Copenhagen Personal Goods PI", "I:CX4020GI": "OMX Copenhagen Consumer Products and Services GI", "I:CX4020PI": "OMX Copenhagen Consumer Products and Services PI", "I:CX4030GI": "OMX Copenhagen Media GI", "I:CX4030PI": "OMX Copenhagen Media PI", "I:CX404010GI": "OMX Copenhagen Retailers GI", "I:CX404010PI": "OMX Copenhagen Retailers PI", "I:CX4040GI": "OMX Copenhagen Retail GI", "I:CX4040PI": "OMX Copenhagen Retail PI", "I:CX4050GI": "OMX Copenhagen Travel and Leisure GI", "I:CX4050PI": "OMX Copenhagen Travel and Leisure PI", "I:CX40GI": "OMX Copenhagen Consumer Discretionary GI", "I:CX40PI": "OMX Copenhagen Consumer Discretionary PI", "I:CX451010GI": "OMX Copenhagen Beverages GI", "I:CX451010PI": "OMX Copenhagen Beverages PI", "I:CX451020GI": "OMX Copenhagen Food Producers GI", "I:CX451020PI": "OMX Copenhagen Food Producers PI", "I:CX451030GI": "OMX Copenhagen Tobacco GI", "I:CX451030PI": "OMX Copenhagen Tobacco PI", "I:CX4510GI": "OMX Copenhagen Food, Beverage and Tobacco  GI", "I:CX4510PI": "OMX Copenhagen Food, Beverage and Tobacco  PI", "I:CX45GI": "OMX Copenhagen Consumer Staples GI", "I:CX45PI": "OMX Copenhagen Consumer Staples PI", "I:CX5010GI": "OMX Copenhagen Construction and Materials GI", "I:CX5010PI": "OMX Copenhagen Construction and Materials PI", "I:CX502020GI": "OMX Copenhagen Electronic and Electrical Equipment GI", "I:CX502020PI": "OMX Copenhagen Electronic and Electrical Equipment PI", "I:CX502030GI": "OMX Copenhagen General Industrials GI", "I:CX502030PI": "OMX Copenhagen General Industrials PI", "I:CX502040GI": "OMX Copenhagen Industrial Engineering GI", "I:CX502040PI": "OMX Copenhagen Industrial Engineering PI", "I:CX502050GI": "OMX Copenhagen Industrial Support Services GI", "I:CX502050PI": "OMX Copenhagen Industrial Support Services PI", "I:CX502060GI": "OMX Copenhagen Industrial Transportation GI", "I:CX502060PI": "OMX Copenhagen Industrial Transportation PI", "I:CX5020GI": "OMX Copenhagen Industrial Goods and Services GI", "I:CX5020PI": "OMX Copenhagen Industrial Goods and Services PI", "I:CX50GI": "OMX Copenhagen Industrials GI", "I:CX50PI": "OMX Copenhagen Industrials PI", "I:CX5520GI": "OMX Copenhagen Chemicals GI", "I:CX5520PI": "OMX Copenhagen Chemicals PI", "I:CX601010GI": "OMX Copenhagen Oil, Gas and Coal GI", "I:CX601010PI": "OMX Copenhagen Oil, Gas and Coal PI", "I:CX601020GI": "OMX Copenhagen Alternative Energy GI", "I:CX601020PI": "OMX Copenhagen Alternative Energy PI", "I:CX60GI": "OMX Copenhagen Energy GI", "I:CX60PI": "OMX Copenhagen Energy PI", "I:CX651010GI": "OMX Copenhagen Electricity GI", "I:CX651010PI": "OMX Copenhagen Electricity PI", "I:CX65GI": "OMX Copenhagen Utilities GI", "I:CX65PI": "OMX Copenhagen Utilities PI", "I:CXU": "U.S.-Europe-Japan Basket", "I:DAA": "NASDAQ US Broad Dividend Achievers Index", "I:DAACAD": "Nasdaq US Broad Dividend Achievers CAD", "I:DAACADMH": "DAACAD Monthly Currency Hedged", "I:DAACADNTR": "Nasdaq US Broad Dividend Achievers CAD NTR", "I:DAACADNTRMH": "DAACADNTR Monthly Currency Hedged", "I:DAACADTR": "Nasdaq US Broad Dividend Achievers CAD TR", "I:DAACADTRMH": "DAACADTR Monthly Currency Hedged", "I:DAANTR": "Nasdaq US Broad Dividend Achievers NTR", "I:DAATR": "NASDAQ US Broad Dividend Achievers Index TR", "I:DAAXJP": "NASDAQ Asia ex Japan Dividend Achievers", "I:DAAXJPHKD": "NASDAQ Asia ex Japan Dividend Achievers HKD", "I:DAAXJPHKDN": "NASDAQ Asia ex Japan Dividend Achievers HKD NTR", "I:DAAXJPHKDT": "NASDAQ Asia ex Japan Dividend Achievers HKD TR", "I:DAAXJPN": "NASDAQ Asia ex Japan Dividend Achievers NTR", "I:DAAXJPT": "NASDAQ Asia ex Japan Dividend Achievers TR", "I:DAAXMLPREIT": "Nasdaq US Broad Div Achievers Ex-MLP & REIT Index", "I:DAAXMLPREITTR": "Nasdaq US Broad Div Achievers Ex-MLP & REIT TR", "I:DACA": "NASDAQ Broad Canadian Dividend Achievers Index", "I:DACATR": "NASDAQ Broad Canadian Dividend Achievers Index TR", "I:DASH100": "Cboe 100 Dash / US Dollar RealPrice Index", "I:DASH10RP": "Cboe 10 Dash / US Dollar RealPrice Index", "I:DASH20RP": "Cboe 20 Dash / US Dollar RealPrice Index", "I:DASH50RP": "Cboe 50 Dash / US Dollar RealPrice Index", "I:DASH5RP": "Cboe 5 Dash / US Dollar RealPrice Index", "I:DAT": "NASDAQ International Dividend Achievers Index", "I:DATIV": "PROSHARES BIG DATA REFINERS ETF", "I:DATLOC": "Nasdaq International Dividend Achievers Local", "I:DATLOCCAD": "Nasdaq International Dividend Achievers Local CAD", "I:DATLOCCADMH": "Nasdaq Intl Div Achiever Local CAD Hedged", "I:DATLOCCADNTR": "Nasdaq International Div Achievers Local CAD NTR", "I:DATLOCCADNTRMH": "Nasdaq Intl Div Achiever Local CAD NTR Hedged", "I:DATLOCCADTR": "Nasdaq International Div Achievers Local CAD TR", "I:DATLOCCADTRMH": "Nasdaq Intl Div Achiever Local CAD TR Hedged", "I:DATLOCNTR": "Nasdaq International Dividend Achievers Local NTR", "I:DATLOCTR": "Nasdaq International Dividend Achievers Local TR", "I:DATNTR": "NASDAQ International Dividend Achievers NTR", "I:DATTR": "NASDAQ International Dividend Achievers Index TR", "I:DAUGIV": "FT Cboe Vest U.S. Equity Deep Buffer ETF - August Intraday Indicative Value", "I:DAY": "NASDAQ US Dividend Achievers 50 Index", "I:DAYTR": "NASDAQ US Dividend Achievers 50 Index TR", "I:DC1ICLEP": "Dow Jones Commodity Index Inverse Crude Oil Enhanced ER", "I:DC1ICLET": "Dow Jones Commodity Index Inverse Crude Oil Enhanced TR", "I:DC2LCLEP": "Dow Jones Commodity Index 2X Leverage Crude Oil Enhanced ER", "I:DC2LCLET": "Dow Jones Commodity Index 2X Leverage Crude Oil Enhanced TR", "I:DDMIV": "PROSHARES ULTRA DOW30 ETF", "I:DE30": "Dow Jones Germany Titans 30 Index (EUR)", "I:DE30D": "Dow Jones Germany Titans 30 Index (USD)", "I:DECTIV": "AllianzIM U.S. Large Cap Buffer10 Dec ETF Intraday Indicative Value", "I:DECWIV": "AllianzIM U.S. Large Cap Buffer20 Dec ETF Intraday Indicative Value", "I:DECZIV": "TrueShares Structured Outcome (December) ETF Intraday Indicative Value", "I:DEDOW": "Dow Jones Germany Index", "I:DEDOWD": "Dow Jones Germany Index (USD)", "I:DEFENSE": "Nasdaq Yewno Aerospace & Defense Index", "I:DEFENSEN": "Nasdaq Yewno Aerospace & Defense Net Total Return Index", "I:DEFENSET": "Nasdaq Yewno Aerospace & Defense Total Return Index", "I:DEFX": "DEFIX: Decentralized Finance Index", "I:DEY": "NEV for Morgan Stanley STARS","I:DGLDIV": "VelocityShares 3x Inverse Gold ETN Intraday Indicative Value", "I:DIGIV": "PROSHARES ULTRA OIL & GAS ETF", "I:DJAES3UN": "Dow Jones Asia ESG Select Dividend 30 Index (USD) NTR", "I:DJAES3UP": "Dow Jones Asia ESG Select Dividend 30 Index (USD)", "I:DJAES3UT": "Dow Jones Asia ESG Select Dividend 30 Index (USD) TR", "I:DJAFK": "Dow Jones Africa Titans 50 Index", "I:DJAP25": "Dow Jones Islamic Market Asia/Pacific Titans 25 Index", "I:DJAPSD": "Dow Jones Asia/Pacific Select Dividend 50 Index", "I:DJAPSDE": "Dow Jones Asia/Pacific Select Dividend 50 Index (EUR)", "I:DJARB50": "Dow Jones Arabia Titans 50 Index", "I:DJASD": "Dow Jones Asia Select Dividend 30 Index (USD)", "I:DJASDE": "Dow Jones Asia Select Dividend 30 Index (EUR)", "I:DJAT": "Dow Jones Asian Titans 50 Index (USD)", "I:DJAU": "Dow Jones Australia Index", "I:DJAUL": "Dow Jones Australia Large-Cap Index", "I:DJAULPT": "Dow Jones Australia LPT Index", "I:DJAUM": "Dow Jones Australia Mid-Cap Index", "I:DJAUS": "Dow Jones Australia Small-Cap Index", "I:DJBGI": "Dow Jones Brookfield Global Infrastructure Index (USD)", "I:DJBGICT": "Dow Jones Brookfield Global Infrastructure Total Return Index (CAD)", "I:DJBGICU": "Dow Jones Brookfield Global Infrastructure Composite Index (USD)", "I:DJBGIE": "Dow Jones Brookfield Global Infrastructure Index (EUR)", "I:DJBGINAC": "Dow Jones Brookfield Global Infrastructure North American Listed Index (CAD)", "I:DJBGIT": "Dow Jones Brookfield Global Infrastructure Total Return Index (USD)", "I:DJBGIY": "Dow Jones Brookfield Global Infrastructure Composite Yield Index (USD)", "I:DJBICEEN": "Dow Jones Brookfield Global Infrastructure Net Zero 2050 Climate Transition ESG Index (EUR) NTR", "I:DJBICEEP": "Dow Jones Brookfield Global Infrastructure Net Zero 2050 Climate Transition ESG Index (EUR)", "I:DJBICEET": "Dow Jones Brookfield Global Infrastructure Net Zero 2050 Climate Transition ESG Index (EUR) TR", "I:DJBICEUN": "Dow Jones Brookfield Global Infrastructure Net Zero 2050 Climate Transition ESG Index (USD) NTR", "I:DJBICEUP": "Dow Jones Brookfield Global Infrastructure Net Zero 2050 Climate Transition ESG Index (USD)", "I:DJBICEUT": "Dow Jones Brookfield Global Infrastructure Net Zero 2050 Climate Transition ESG Index (USD) TR", "I:DJBIEM": "Dow Jones Brookfield Emerging Markets Infrastructure Index (USD)", "I:DJBIEME": "Dow Jones Brookfield Emerging Markets Infrastructure Index (EUR)", "I:DJC": "Dow Jones Composite Average", "I:DJC2IBRP": "Dow Jones Commodity Index 2X Inverse Brent Crude ER", "I:DJC2IBRT": "Dow Jones Commodity Index 2X Inverse Brent Crude TR", "I:DJC2ICLP": "Dow Jones Commodity Index 2X Inverse Crude Oil ER", "I:DJC2ICLT": "Dow Jones Commodity Index 2X Inverse Crude Oil TR", "I:DJC2IGCP": "Dow Jones Commodity Index 2X Inverse Gold ER", "I:DJC2IGCT": "Dow Jones Commodity Index 2X Inverse Gold TR", "I:DJC2IHGP": "Dow Jones Commodity Index 2X Inverse North American Copper ER", "I:DJC2IHGT": "Dow Jones Commodity Index 2X Inverse North American Copper TR", "I:DJC2ISIP": "Dow Jones Commodity Index 2X Inverse Silver ER", "I:DJC2ISIT": "Dow Jones Commodity Index 2X Inverse Silver TR", "I:DJC2LBRP": "Dow Jones Commodity Index 2X Leverage Brent Crude ER", "I:DJC2LBRT": "Dow Jones Commodity Index 2X Leverage Brent Crude TR", "I:DJC2LCLP": "Dow Jones Commodity Index 2X Leverage Crude Oil ER", "I:DJC2LCLT": "Dow Jones Commodity Index 2X Leverage Crude Oil TR", "I:DJC2LGCP": "Dow Jones Commodity Index 2X Leverage Gold ER", "I:DJC2LGCT": "Dow Jones Commodity Index 2X Leverage Gold TR", "I:DJC2LHGP": "Dow Jones Commodity Index 2X Leverage North American Copper ER", "I:DJC2LHGT": "Dow Jones Commodity Index 2X Leverage North American Copper TR", "I:DJC2LSIP": "Dow Jones Commodity Index 2X Leverage Silver ER", "I:DJC2LSIT": "Dow Jones Commodity Index 2X Leverage Silver TR", "I:DJCASD": "Dow Jones Canada Select Dividend Index", "I:DJCASG": "Dow Jones Canada Select Growth Index", "I:DJCASV": "Dow Jones Canada Select Value Index", "I:DJCCN1IP": "Dow Jones Commodity Index Corn 1x Inverse Daily ER", "I:DJCCN1IT": "Dow Jones Commodity Index Corn 1x Inverse Daily TR", "I:DJCCN2IP": "Dow Jones Commodity Index Corn 2x Inverse Daily ER", "I:DJCCN2IT": "Dow Jones Commodity Index Corn 2x Inverse Daily TR", "I:DJCCN2LP": "Dow Jones Commodity Index Corn 2x Leveraged Daily ER", "I:DJCCN2LT": "Dow Jones Commodity Index Corn 2x Leveraged Daily TR", "I:DJCHINA": "Dow Jones China Broad Market Index", "I:DJCHN88": "Dow Jones China 88 Index", "I:DJCI": "Dow Jones Commodity Index", "I:DJCIA1IT": "Dow Jones Commodity Index Aluminum Inverse TR", "I:DJCIA2IT": "Dow Jones Commodity Index Aluminum 2X Inverse TR", "I:DJCIA2LT": "Dow Jones Commodity Index Aluminum 2X Leveraged TR", "I:DJCIAC": "Dow Jones Commodity Index All Cattle", "I:DJCIACP": "Dow Jones Commodity Index All Cattle ER", "I:DJCIACT": "Dow Jones Commodity Index All Cattle TR", "I:DJCIAGC": "Dow Jones Commodity Index Agriculture Capped Component", "I:DJCIAGCP": "Dow Jones Commodity Index Agriculture Capped Component ER", "I:DJCIAGCT": "Dow Jones Commodity Index Agriculture Capped Component TR", "I:DJCIALC": "Dow Jones Commodity Index Agriculture & Livestock Capped Component", "I:DJCIALCP": "Dow Jones Commodity Index Agriculture & Livestock Capped Component ER", "I:DJCIALCT": "Dow Jones Commodity Index Agriculture & Livestock Capped Component TR", "I:DJCIAMC": "Dow Jones Commodity Index All Metals Capped Component", "I:DJCIAMCP": "Dow Jones Commodity Index All Metals Capped Component ER", "I:DJCIAMCT": "Dow Jones Commodity Index All Metals Capped Component TR", "I:DJCIAW": "Dow Jones Commodity Index All Wheat", "I:DJCIAWP": "Dow Jones Commodity Index All Wheat ER", "I:DJCIAWT": "Dow Jones Commodity Index All Wheat TR", "I:DJCIBR": "Dow Jones Commodity Index Brent Crude", "I:DJCIBRP": "Dow Jones Commodity Index Brent Crude ER", "I:DJCIBRT": "Dow Jones Commodity Index Brent Crude TR", "I:DJCIC2IT": "Dow Jones Commodity Index Copper 2X Inverse TR", "I:DJCIC2LT": "Dow Jones Commodity Index Copper 2X Leveraged TR", "I:DJCICC": "Dow Jones Commodity Index Cocoa", "I:DJCICCP": "Dow Jones Commodity Index Cocoa ER", "I:DJCICCT": "Dow Jones Commodity Index Cocoa TR", "I:DJCICL": "Dow Jones Commodity Index Crude Oil", "I:DJCICLP": "Dow Jones Commodity Index Crude Oil ER", "I:DJCICLT": "Dow Jones Commodity Index Crude Oil TR", "I:DJCICN": "Dow Jones Commodity Index Corn", "I:DJCICNP": "Dow Jones Commodity Index Corn ER", "I:DJCICNT": "Dow Jones Commodity Index Corn TR", "I:DJCICT": "Dow Jones Commodity Index Cotton", "I:DJCICTP": "Dow Jones Commodity Index Cotton ER", "I:DJCICTT": "Dow Jones Commodity Index Cotton TR", "I:DJCIECLP": "Dow Jones Commodity Index Crude Oil Enhanced ER", "I:DJCIECLT": "Dow Jones Commodity Index Crude Oil Enhanced TR", "I:DJCIEMC": "Dow Jones Commodity Index Energy & Metals Capped Component", "I:DJCIEMCP": "Dow Jones Commodity Index Energy & Metals Capped Component ER", "I:DJCIEMCT": "Dow Jones Commodity Index Energy & Metals Capped Component TR", "I:DJCIEN": "Dow Jones Commodity Index Energy", "I:DJCIENP": "Dow Jones Commodity Index Energy ER", "I:DJCIENT": "Dow Jones Commodity Index Energy TR", "I:DJCIFC": "Dow Jones Commodity Index Feeder Cattle", "I:DJCIFCP": "Dow Jones Commodity Index Feeder Cattle ER", "I:DJCIFCT": "Dow Jones Commodity Index Feeder Cattle TR", "I:DJCIGC": "Dow Jones Commodity Index Gold", "I:DJCIGCP": "Dow Jones Commodity Index Gold ER", "I:DJCIGCT": "Dow Jones Commodity Index Gold TR", "I:DJCIGR": "Dow Jones Commodity Index Grains", "I:DJCIGRP": "Dow Jones Commodity Index Grains ER", "I:DJCIGRT": "Dow Jones Commodity Index Grains TR", "I:DJCIHG": "Dow Jones Commodity Index North American Copper", "I:DJCIHGP": "Dow Jones Commodity Index North American Copper ER", "I:DJCIHGT": "Dow Jones Commodity Index North American Copper TR", "I:DJCIHO": "Dow Jones Commodity Index Heating Oil", "I:DJCIHOP": "Dow Jones Commodity Index Heating Oil ER", "I:DJCIHOT": "Dow Jones Commodity Index Heating Oil TR", "I:DJCIIA": "Dow Jones Commodity Index Aluminum", "I:DJCIIAP": "Dow Jones Commodity Index Aluminum ER", "I:DJCIIAT": "Dow Jones Commodity Index Aluminum TR", "I:DJCIIBRP": "Dow Jones Commodity Index Inverse Brent Crude ER", "I:DJCIIBRT": "Dow Jones Commodity Index Inverse Brent Crude TR", "I:DJCIIC": "Dow Jones Commodity Index Copper", "I:DJCIICLP": "Dow Jones Commodity Index Crude Oil Inverse (USD) ER", "I:DJCIICLT": "Dow Jones Commodity Index Crude Oil Inverse (USD) TR", "I:DJCIICP": "Dow Jones Commodity Index Copper ER", "I:DJCIICT": "Dow Jones Commodity Index Copper TR", "I:DJCIIGCP": "Dow Jones Commodity Index Inverse Gold ER", "I:DJCIIGCT": "Dow Jones Commodity Index Inverse Gold TR", "I:DJCIIHGP": "Dow Jones Commodity Index Inverse North American Copper ER", "I:DJCIIHGT": "Dow Jones Commodity Index Inverse North American Copper TR", "I:DJCIIK": "Dow Jones Commodity Index Nickel", "I:DJCIIKP": "Dow Jones Commodity Index Nickel ER", "I:DJCIIKT": "Dow Jones Commodity Index Nickel TR", "I:DJCIIL": "Dow Jones Commodity Index Lead", "I:DJCIILP": "Dow Jones Commodity Index Lead ER", "I:DJCIILT": "Dow Jones Commodity Index Lead TR", "I:DJCIIM": "Dow Jones Commodity Index Industrial Metals", "I:DJCIIMP": "Dow Jones Commodity Index Industrial Metals ER", "I:DJCIIMT": "Dow Jones Commodity Index Industrial Metals TR", "I:DJCIISIP": "Dow Jones Commodity Index Inverse Silver ER", "I:DJCIISIT": "Dow Jones Commodity Index Inverse Silver TR", "I:DJCIIZ": "Dow Jones Commodity Index Zinc", "I:DJCIIZP": "Dow Jones Commodity Index Zinc ER", "I:DJCIIZT": "Dow Jones Commodity Index Zinc TR", "I:DJCIK2IT": "Dow Jones Commodity Index Nickel 2X Inverse TR", "I:DJCIK2LT": "Dow Jones Commodity Index Nickel 2X Leveraged TR", "I:DJCIKC": "Dow Jones Commodity Index Coffee", "I:DJCIKCP": "Dow Jones Commodity Index Coffee ER", "I:DJCIKCT": "Dow Jones Commodity Index Coffee TR", "I:DJCIKW": "Dow Jones Commodity Index Kansas Wheat", "I:DJCIKWP": "Dow Jones Commodity Index Kansas Wheat ER", "I:DJCIKWT": "Dow Jones Commodity Index Kansas Wheat TR", "I:DJCILC": "Dow Jones Commodity Index Live Cattle", "I:DJCILCP": "Dow Jones Commodity Index Live Cattle ER", "I:DJCILCT": "Dow Jones Commodity Index Live Cattle TR", "I:DJCILH": "Dow Jones Commodity Index Lean Hogs", "I:DJCILHP": "Dow Jones Commodity Index Lean Hogs ER", "I:DJCILHT": "Dow Jones Commodity Index Lean Hogs TR", "I:DJCILV": "Dow Jones Commodity Index Livestock", "I:DJCILVP": "Dow Jones Commodity Index Livestock ER", "I:DJCILVT": "Dow Jones Commodity Index Livestock TR", "I:DJCING": "Dow Jones Commodity Index Natural Gas", "I:DJCINGP": "Dow Jones Commodity Index Natural Gas ER", "I:DJCINGT": "Dow Jones Commodity Index Natural Gas TR", "I:DJCIP": "Dow Jones Commodity Index ER", "I:DJCIP2IT": "Dow Jones Commodity Index Platinum 2X Inverse (USD) TR", "I:DJCIP2LT": "Dow Jones Commodity Index Platinum 2X Leveraged (USD) TR", "I:DJCIPM": "Dow Jones Commodity Index Precious Metals", "I:DJCIPMP": "Dow Jones Commodity Index Precious Metals ER", "I:DJCIPMT": "Dow Jones Commodity Index Precious Metals TR", "I:DJCIPT": "Dow Jones Commodity Index Petroleum", "I:DJCIPTP": "Dow Jones Commodity Index Petroleum ER", "I:DJCIPTT": "Dow Jones Commodity Index Petroleum TR", "I:DJCIRB": "Dow Jones Commodity Index Unleaded Gasoline", "I:DJCIRBP": "Dow Jones Commodity Index Unleaded Gasoline ER", "I:DJCIRBT": "Dow Jones Commodity Index Unleaded Gasoline TR", "I:DJCISB": "Dow Jones Commodity Index Sugar", "I:DJCISBP": "Dow Jones Commodity Index Sugar ER", "I:DJCISBT": "Dow Jones Commodity Index Sugar TR", "I:DJCISF": "Dow Jones Commodity Index Softs", "I:DJCISFP": "Dow Jones Commodity Index Softs ER", "I:DJCISFT": "Dow Jones Commodity Index Softs TR", "I:DJCISI": "Dow Jones Commodity Index Silver", "I:DJCISIP": "Dow Jones Commodity Index Silver ER", "I:DJCISIT": "Dow Jones Commodity Index Silver TR", "I:DJCISO": "Dow Jones Commodity Index Soybeans", "I:DJCISOP": "Dow Jones Commodity Index Soybeans ER", "I:DJCISOT": "Dow Jones Commodity Index Soybeans TR", "I:DJCIT": "Dow Jones Commodity Index TR", "I:DJCIWH": "Dow Jones Commodity Index Wheat", "I:DJCIWHP": "Dow Jones Commodity Index Wheat ER", "I:DJCIWHT": "Dow Jones Commodity Index Wheat TR", "I:DJCIZ2IT": "Dow Jones Commodity Index Zinc 2X Inverse TR", "I:DJCIZ2LT": "Dow Jones Commodity Index Zinc 2X Leveraged TR", "I:DJCMED": "Dow Jones CME Spot FX$Index", "I:DJCNG1IP": "Dow Jones Commodity Index Natural Gas Inverse ER", "I:DJCNG1IT": "Dow Jones Commodity Index Natural Gas Inverse TR", "I:DJCNG2IT": "Dow Jones Commodity Index Natural Gas 2X Inverse TR", "I:DJCNG2LT": "Dow Jones Commodity Index Natural Gas 2X Leveraged TR", "I:DJCOS50N": "Dow Jones China Offshore 50 Total Return Net Index", "I:DJCSO1IP": "Dow Jones Commodity Index Soybeans Inverse ER", "I:DJCSO1IT": "Dow Jones Commodity Index Soybeans Inverse TR", "I:DJCSO2IT": "Dow Jones Commodity Index Soybeans 2X Inverse TR", "I:DJCSO2LT": "Dow Jones Commodity Index Soybeans 2X Leveraged TR", "I:DJCTR": "Dow Jones Composite Average TR", "I:DJCY10": "Dow Jones Cyprus 10 Titans Index","I:DJDVN": "Dow Jones U.S. Select Dividend Net Total Return Index", "I:DJDVP": "Dow Jones U.S. Select Dividend Index", "I:DJDVY": "Dow Jones U.S. Select Dividend Total Return Index", "I:DJDXAHAP": "Dow Jones Developed Markets Ex-Australia Select RESI AUD Hedged", "I:DJDXAHAT": "Dow Jones Developed Markets Ex-Australia Select RESI AUD Hedged TR", "I:DJDXAHUP": "Dow Jones Developed Markets Ex-Australia Select RESI USD Hedged", "I:DJDXAHUT": "Dow Jones Developed Markets Ex-Australia Select RESI USD Hedged TR", "I:DJDXARAN": "Dow Jones Developed Markets Ex-Australia Select RESI (AUD) NTR", "I:DJDXARAP": "Dow Jones Developed Markets Ex-Australia Select RESI (AUD)", "I:DJDXARAT": "Dow Jones Developed Markets Ex-Australia Select RESI (AUD) TR", "I:DJDXARUN": "Dow Jones Developed Markets Ex-Australia Select RESI (USD) NTR", "I:DJDXARUP": "Dow Jones Developed Markets Ex-Australia Select RESI (USD)", "I:DJDXARUT": "Dow Jones Developed Markets Ex-Australia Select RESI (USD) TR", "I:DJDXNA": "Dow Jones Developed Markets ex-North America Index (USD)", "I:DJECOM": "Dow Jones Internet Commerce Index", "I:DJECON": "Dow Jones Emerging Markets Consumer Titans 30 Index (USD)", "I:DJECONE": "Dow Jones Emerging Markets Consumer Titans Index (EUR)", "I:DJEG20": "Dow Jones EGX Egypt Titans 20 Index (EGP)", "I:DJEG20D": "Dow Jones EGX Egypt Titans 20 Index (USD)", "I:DJEG20DT": "Dow Jones EGX Egypt Titans 20 Total Return Index (USD)", "I:DJEG20E": "Dow Jones EGX Egypt Titans 20 Index (EUR)", "I:DJEMDIV": "Dow Jones Emerging Markets Select Dividend Index (USD)", "I:DJEMDIVE": "Dow Jones Emerging Markets Select Dividend Index (EUR)", "I:DJEPCSD": "Dow Jones EPAC Select Dividend Index", "I:DJERCUP": "Dow Jones Equity All REIT Capped Index (USD)", "I:DJERCUT": "Dow Jones Equity All REIT Capped Index (USD) TR", "I:DJEU25": "Dow Jones Islamic Market Europe Titans 25 Index", "I:DJGALY": "Dow Jones Global Alternative Yield Index", "I:DJGALYT": "Dow Jones Global Alternative Yield Total Return Index", "I:DJGEQY": "Dow Jones Global Equity Yield Index", "I:DJGEQYT": "Dow Jones Global Equity Yield Total Return Index", "I:DJGREY": "Dow Jones Global Real Estate Yield Index", "I:DJGREYT": "Dow Jones Global Real Estate Yield Total Return Index", "I:DJGSD": "Dow Jones Global Select Dividend Index", "I:DJGSDC": "Dow Jones Global Select Dividend Composite Index (USD)", "I:DJGSDCC": "Dow Jones Global Select Dividend Composite Index (CAD)", "I:DJGSDCCN": "Dow Jones Global Select Dividend Composite Net Total Return Index (CAD)", "I:DJGSDCH": "Dow Jones Global Select Dividend Composite Index Canadian Dollar Hedged (CAD)", "I:DJGSDCHN": "Dow Jones Global Select Dividend Composite Net Total Return Index Canadian Dollar Hedged (CAD)", "I:DJGSDCN": "Dow Jones Global Select Dividend Composite Net Total Return Index (USD)", "I:DJGSP": "Dow Jones Precious Metals Index", "I:DJGSPT": "Dow Jones Precious Metals Total Return Index", "I:DJGT": "Dow Jones Global Titans 50 Index (USD)", "I:DJGTE": "Dow Jones Global Titans 50 Index (EUR)", "I:DJGXAHAP": "Dow Jones Global Ex-Australia Select RESI AUD Hedged", "I:DJGXAHAT": "Dow Jones Global Ex-Australia Select RESI AUD Hedged TR", "I:DJGXAHUP": "Dow Jones Global Ex-Australia Select RESI USD Hedged", "I:DJGXAHUT": "Dow Jones Global Ex-Australia Select RESI USD Hedged TR", "I:DJGXARAN": "Dow Jones Global Ex-Australia Select RESI (AUD) NTR", "I:DJGXARAP": "Dow Jones Global Ex-Australia Select RESI (AUD)", "I:DJGXARAT": "Dow Jones Global Ex-Australia Select RESI (AUD) TR", "I:DJGXARUN": "Dow Jones Global Ex-Australia Select RESI (USD) NTR", "I:DJGXARUP": "Dow Jones Global Ex-Australia Select RESI (USD)", "I:DJGXARUT": "Dow Jones Global Ex-Australia Select RESI (USD) TR", "I:DJGYLDT": "Dow Jones Global Composite Yield Total Return Index", "I:DJI": "Dow Jones Industrial Average", "I:DJI100X": "Dow Jones Islamic Market International Titans 100 Index", "I:DJI2MN": "Dow Jones Industrial Average (2 Minute)", "I:DJIAFT1I": "Dow Jones Industrial Average Futures Inverse Daily Index (USD) TR", "I:DJIAFT2I": "Dow Jones Industrial Average Futures 2X Inverse Daily Index (USD) TR", "I:DJIAFT2L": "Dow Jones Industrial Average Futures 2X Leveraged Daily Index (USD) TR", "I:DJIAFTR": "Dow Jones Industrial Average Futures Index (USD) TR", "I:DJIAP": "Dow Jones Islamic Market Asia/Pacific Index", "I:DJIAPL": "Dow Jones Islamic Market Asia/Pacific Large-Cap Index", "I:DJIAPM": "Dow Jones Islamic Market Asia/Pacific Mid-Cap Index", "I:DJIAPS": "Dow Jones Islamic Market Asia/Pacific Small-Cap Index", "I:DJIBSC": "Dow Jones Islamic Market Basic Materials Index", "I:DJIBSCT": "Dow Jones Islamic Market Basic Materials Total Return Index", "I:DJICA": "Dow Jones Islamic Market Canada Index", "I:DJICH1MN": "Dow Jones Islamic Market China A 100 Index (MYR) NTR", "I:DJICH1MP": "Dow Jones Islamic Market China A 100 Index (MYR)", "I:DJICH1MT": "Dow Jones Islamic Market China A 100 Index (MYR) TR", "I:DJICHK": "Dow Jones Islamic Market China/Hong Kong Titans 30 Index (HKD)", "I:DJICHKU": "Dow Jones Islamic Market China/Hong Kong Titans 30 Index (USD)", "I:DJICYC": "Dow Jones Islamic Market Consumer Services Index", "I:DJIEMG": "Dow Jones Islamic Market World Emerging Markets Index", "I:DJIENE": "Dow Jones Islamic Market Oil & Gas Index", "I:DJIENET": "Dow Jones Islamic Market Oil & Gas Total Return Index", "I:DJIEU": "Dow Jones Islamic Market Europe Index", "I:DJIEUL": "Dow Jones Islamic Market Europe Large-Cap Index", "I:DJIEUM": "Dow Jones Islamic Market Europe Mid-Cap Index", "I:DJIEUS": "Dow Jones Islamic Market Europe Small-Cap Index", "I:DJIEW": "Dow Jones Industrial Average Equal Weight Index (USD)", "I:DJIEWNTR": "Dow Jones Industrial Average Equal Weight Index (USD) NTR", "I:DJIEWTR": "Dow Jones Industrial Average Equal Weight Index TR (USD)", "I:DJIEZ": "Dow Jones Islamic Market Euro Index", "I:DJIEZL": "Dow Jones Islamic Market Euro Large-Cap Index", "I:DJIEZM": "Dow Jones Islamic Market Euro Mid-Cap Index", "I:DJIEZS": "Dow Jones Islamic Market Euro Small-Cap Index", "I:DJIFIN": "Dow Jones Islamic Market Financials Index", "I:DJIGSD": "Dow Jones Islamic Market Global Select Dividend Index (USD)", "I:DJIGSDT": "Dow Jones Islamic Market Global Select Dividend Total Return Index (USD)", "I:DJIHCR": "Dow Jones Islamic Market Health Care Index", "I:DJIIDU": "Dow Jones Islamic Market Industrials Index", "I:DJIJP": "Dow Jones Islamic Market Japan Index", "I:DJILRG": "Dow Jones Islamic Market World Large-Cap Index", "I:DJILSCS": "Dow Jones Israel Select Consumer Index", "I:DJILSCST": "Dow Jones Israel Select Consumer Total Return Index", "I:DJILSHC": "Dow Jones Israel Select Health Care Index", "I:DJILSHCT": "Dow Jones Israel Select Health Care Total Return Index", "I:DJILSOG": "Dow Jones Israel Select Oil & Gas Index", "I:DJILSOGT": "Dow Jones Israel Select Oil & Gas Total Return Index", "I:DJIM": "Dow Jones Islamic Market World Index", "I:DJIMDXJ": "Dow Jones Islamic Market Developed Markets ex Japan Index (USD)", "I:DJIMID": "Dow Jones Islamic Market World Mid-Cap Index", "I:DJIMIN": "Dow Jones Islamic Market India Index (INR)", "I:DJIMIND": "Dow Jones Islamic Market India Index (USD)", "I:DJIMKW": "Dow Jones Islamic Market Kuwait Index", "I:DJIMTR": "Dow Jones Islamic Market Turkey Index", "I:DJINCY": "Dow Jones Islamic Market Consumer Goods Index", "I:DJINET": "Dow Jones Internet Composite Index", "I:DJINETN": "Dow Jones Internet Composite Net Total Return Index", "I:DJINETT": "Dow Jones Internet Composite Total Return Index", "I:DJINR": "Dow Jones Industrial Average NTR", "I:DJINTCUN": "Dow Jones International Internet Index (USD) NTR", "I:DJINTCUP": "Dow Jones International Internet Index (USD)", "I:DJINTCUT": "Dow Jones International Internet Index (USD) TR", "I:DJIP2": "Dow Jones Islamic Market Asia/Pacific ex-Japan Index", "I:DJIPICF": "Dow Jones Industrial Average Inverse Carry-Free Daily Index (USD)", "I:DJIPICFH": "Dow Jones Industrial Average Inverse Carry-Free Daily Index (HKD)", "I:DJIPICFT": "Dow Jones Industrial Average Inverse Carry-Free Daily Index (TWD)", "I:DJIPLCF": "Dow Jones Industrial Average 2X Leveraged Carry-Free Daily Index (USD)", "I:DJIPLCFH": "Dow Jones Industrial Average 2X Leveraged Carry-Free Daily Index (HKD)", "I:DJIPLCFT": "Dow Jones Industrial Average 2X Leveraged Carry-Free Daily Index (TWD)", "I:DJISML": "Dow Jones Islamic Market World Small-Cap Index", "I:DJISRL": "Dow Jones Islamic Market Sri Lanka Index (LKR)", "I:DJISRLD": "Dow Jones Islamic Market Sri Lanka Index (USD)", "I:DJISVC": "Dow Jones Internet Services Index", "I:DJITEC": "Dow Jones Islamic Market Technology Index", "I:DJITLS": "Dow Jones Islamic Market Telecommunications Index", "I:DJITR": "Dow Jones Industrial Average TR", "I:DJIUK": "Dow Jones Islamic Market U.K. Index", "I:DJIUTI": "Dow Jones Islamic Market Utilities Index", "I:DJIYW": "Dow Jones Industrial Average Yield Weighted Index (USD)", "I:DJIYWT": "Dow Jones Industrial Average Yield Weighted Index (USD) TR", "I:DJMENXD": "Dow Jones MENA ex-Saudi Index (USD)", "I:DJMY25": "Dow Jones Islamic Market Malaysia Titans 25 Index", "I:DJMY25D": "Dow Jones Islamic Market Malaysia Titans 25 Index (USD)", "I:DJNAJG": "Dow Jones North America Select Junior Gold Index (CAD)", "I:DJNAJGA": "Dow Jones North America Select Junior Gas Index (CAD)", "I:DJNAJGAD": "Dow Jones North America Select Junior Gas Index (USD)", "I:DJNAJGD": "Dow Jones North America Select Junior Gold Index (USD)", "I:DJNAJO": "Dow Jones North America Select Junior Oil Index (CAD)", "I:DJNAJOD": "Dow Jones North America Select Junior Oil Index (USD)", "I:DJR": "Dow Jones Equity Real Estate Investment Trust Index", "I:DJS": "Dow Jones", "I:DJSA30": "Dow Jones Saudi Titans 30 Index (SAR)", "I:DJSASD": "Dow Jones U.S. Select Aerospace & Defense Index","I:DJSASDT": "Dow Jones U.S. Select Aerospace & Defense Total Return Index", "I:DJSEA1UN": "Dow Jones Emerging ASEAN Titans 100 Index (USD) NTR", "I:DJSENAE": "Dow Jones Sustainability Europe Ex-Alcohol, Tobacco, Gambling, Armaments & Firearms, and Adult Enter", "I:DJSENAED": "Dow Jones Sustainability Europe Ex-Alcohol, Tobacco, Gambling, Armaments & Firearms, and Adult Enter", "I:DJSEUR": "Dow Jones Sustainability Europe Index (EUR)", "I:DJSEURD": "Dow Jones Sustainability Europe Index (USD)", "I:DJSEUXA": "Dow Jones Sustainability Europe Ex-Alcohol, Tobacco, Gambling, and Armaments & Firearms Index (EUR)", "I:DJSEUXAD": "Dow Jones Sustainability Europe Ex-Alcohol, Tobacco, Gambling, and Armaments & Firearms Index", "I:DJSEUZ": "Dow Jones Sustainability Eurozone Index (EUR)", "I:DJSEUZD": "Dow Jones Sustainability Eurozone Index (USD)", "I:DJSEZXA": "Dow Jones Sustainability Eurozone Ex-Alcohol, Tobacco, Gambling, Armaments & Firearms Index (EUR)", "I:DJSEZXAD": "Dow Jones Sustainability Eurozone Ex-Alcohol, Tobacco, Gambling, Armaments & Firearms Index", "I:DJSH": "Dow Jones Shanghai Index", "I:DJSHCP": "Dow Jones U.S. Select Health Care Providers Index", "I:DJSHCPT": "Dow Jones U.S. Select Health Care Providers Total Return Index", "I:DJSHMB": "Dow Jones U.S. Select Home Construction Index", "I:DJSHMBT": "Dow Jones U.S. Select Home Construction Total Return Index", "I:DJSIK": "Dow Jones Sustainability Korea Index (KRW)", "I:DJSINS": "Dow Jones U.S. Select Insurance Index", "I:DJSINST": "Dow Jones U.S. Select Insurance Total Return Index", "I:DJSINV": "Dow Jones U.S. Select Investment Services Index", "I:DJSINVT": "Dow Jones U.S. Select Investment Services Total Return Index", "I:DJSKC2": "Dow Jones Sustainability Korea Capped 25% Index (KRW)", "I:DJSKC2T": "Dow Jones Sustainability Korea Capped Total Return 25% Index (KRW)", "I:DJSM": "Dow Jones Select Micro-Cap Index", "I:DJSMDQ": "Dow Jones U.S. Select Medical Equipment Index", "I:DJSMDQT": "Dow Jones U.S. Select Medical Equipment Total Return Index", "I:DJSMDQUN": "Dow Jones U.S. Select Medical Equipment Index NTR", "I:DJSMT": "Dow Jones Select Micro-Cap Total Return Index", "I:DJSND": "Dow Jones Sustainability Nordic Index", "I:DJSNE": "Dow Jones Sustainability Nordic Index (EUR)", "I:DJSOEP": "Dow Jones U.S. Select Oil Exploration & Production Index", "I:DJSOEPT": "Dow Jones U.S. Select Oil Exploration & Production Total Return Index", "I:DJSOES": "Dow Jones U.S. Select Oil Equipment & Services Index", "I:DJSOEST": "Dow Jones U.S. Select Oil Equipment & Services Total Return Index", "I:DJSPHM": "Dow Jones U.S. Select Pharmaceuticals Index", "I:DJSPHMT": "Dow Jones U.S. Select Pharmaceuticals Total Return Index", "I:DJSRBK": "Dow Jones U.S. Select Regional Banks Index", "I:DJSRBKT": "Dow Jones U.S. Select Regional Banks Total Return Index", "I:DJSTEL": "Dow Jones U.S. Select Telecommunications Index", "I:DJSTELT": "Dow Jones U.S. Select Telecommunications Total Return Index", "I:DJSWECD": "Dow Jones Sustainability World EnLarged Index", "I:DJSWECE": "Dow Jones Sustainability World EnLarged Index (EUR)", "I:DJSWEX4D": "Dow Jones Sustainability World EnLarged Ex-Alcohol, Tobacco, Gambling, Armaments & Firearms, and Adu", "I:DJSWEX4E": "Dow Jones Sustainability World EnLarged Ex-Alcohol, Tobacco, Gambling, Armaments & Firearms, and Adu", "I:DJSZ": "Dow Jones Shenzhen Index", "I:DJSZXAE": "Dow Jones Sustainability Eurozone Ex-Alcohol, Tobacco, Gambling, Armaments & Firearms, and Adult Ent", "I:DJSZXAED": "Dow Jones Sustainability Eurozone Ex-Alcohol, Tobacco, Gambling, Armaments & Firearms, and Adult Ent", "I:DJT": "Dow Jones Transportation Average", "I:DJTATO": "Dow Jones Automobiles & Parts Titans 30 Index", "I:DJTATOE": "Dow Jones Automobiles & Parts Titans 30 Index (EUR)", "I:DJTATOT": "Dow Jones Automobiles & Parts Titans 30 Total Return Index", "I:DJTBAK": "Dow Jones Banks Titans 30 Index (USD)", "I:DJTBAKE": "Dow Jones Banks Titans 30 Index (EUR)", "I:DJTBAKT": "Dow Jones Banks Titans 30 Index TR (USD)", "I:DJTBAS": "Dow Jones Basic Resources Titans 30 Index (USD)", "I:DJTBASE": "Dow Jones Basic Resources Titans 30 Index (EUR)", "I:DJTBAST": "Dow Jones Basic Resources Titans 30 Index TR (USD)", "I:DJTCGS": "Dow Jones Travel & Leisure Titans 30 Index (USD)", "I:DJTCGSE": "Dow Jones Travel & Leisure Titans 30 Index (EUR)", "I:DJTCGST": "Dow Jones Travel & Leisure Titans 30 Index TR (USD)", "I:DJTCHE": "Dow Jones Chemicals Titans 30 Index", "I:DJTCHEE": "Dow Jones Chemicals Titans 30 Index (EUR)", "I:DJTCHET": "Dow Jones Chemicals Titans 30 Total Return Index", "I:DJTCNS": "Dow Jones Construction & Materials Titans 30 Index", "I:DJTCNSE": "Dow Jones Construction & Materials Titans 30 Index (EUR)", "I:DJTCNST": "Dow Jones Construction & Materials Titans 30 Total Return Index", "I:DJTENG": "Dow Jones Oil & Gas Titans 30 Index (USD)", "I:DJTENGE": "Dow Jones Oil & Gas Titans 30 Index (EUR)", "I:DJTENGT": "Dow Jones Oil & Gas Titans 30 Index TR (USD)", "I:DJTFOB": "Dow Jones Food & Beverage Titans 30 Index", "I:DJTFOBE": "Dow Jones Food & Beverage Titans 30 Index (EUR)", "I:DJTFOBT": "Dow Jones Food & Beverage Titans 30 Total Return Index", "I:DJTFVS": "Dow Jones Financial Services Titans 30 Index (USD)", "I:DJTFVSE": "Dow Jones Financial Services Titans 30 Index (EUR)", "I:DJTFVST": "Dow Jones Financial Services Titans 30 Index TR (USD)", "I:DJTGR": "Dow Jones Tiger Titans 50 Index", "I:DJTHCA": "Dow Jones Health Care Titans 30 Index", "I:DJTHCAE": "Dow Jones Health Care Titans 30 Index (EUR)", "I:DJTHCAT": "Dow Jones Health Care Titans 30 Total Return Index", "I:DJTIGS": "Dow Jones Industrial Goods and Services Titans 30 Index (USD)", "I:DJTIGSE": "Dow Jones Industrial Goods and Services Titans 30 Index (EUR)", "I:DJTIGST": "Dow Jones Industrial Goods and Services Titans 30 Index TR (EUR)", "I:DJTINN": "Dow Jones Insurance Titans 30 Index (USD)", "I:DJTINNE": "Dow Jones Insurance Titans 30 Index (EUR)", "I:DJTINNT": "Dow Jones Insurance Titans 30 Index TR (USD)", "I:DJTLAB": "Dow Jones U.S. Low Beta Index", "I:DJTLABT": "Dow Jones U.S. Low Beta Total Return Index", "I:DJTLMO": "Dow Jones U.S. High Momentum Index", "I:DJTLMOT": "Dow Jones U.S. High Momentum Total Return Index", "I:DJTLQU": "Dow Jones U.S. Thematic Long Quality Index", "I:DJTLQUT": "Dow Jones U.S. Thematic Long Quality Total Return Index", "I:DJTLSS": "Dow Jones U.S. Thematic Long Size Index", "I:DJTLSST": "Dow Jones U.S. Thematic Long Size Total Return Index", "I:DJTLSV": "Dow Jones U.S. Relative Value Index", "I:DJTLSVT": "Dow Jones U.S. Relative Value Total Return Index", "I:DJTMDI": "Dow Jones Media Titans 30 Index", "I:DJTMDIE": "Dow Jones Media Titans 30 Index (EUR)", "I:DJTMDIT": "Dow Jones Media Titans 30 Total Return Index", "I:DJTMNAB": "Dow Jones U.S. Thematic Market Neutral Low Beta Index", "I:DJTMNABT": "Dow Jones U.S. Thematic Market Neutral Low Beta Total Return Index", "I:DJTMNMO": "Dow Jones U.S. Thematic Market Neutral Momentum Index", "I:DJTMNMOT": "Dow Jones U.S. Thematic Market Neutral Momentum Total Return Index", "I:DJTMNQU": "Dow Jones U.S. Thematic Market Neutral Quality Index", "I:DJTMNQUT": "Dow Jones U.S. Thematic Market Neutral Quality Total Return Index", "I:DJTMNSS": "Dow Jones U.S. Thematic Market Neutral Size Index", "I:DJTMNSST": "Dow Jones U.S. Thematic Market Neutral Size Total Return Index", "I:DJTMNSV": "Dow Jones U.S. Thematic Market Neutral Value Index", "I:DJTMNSVT": "Dow Jones U.S. Thematic Market Neutral Value Total Return Index", "I:DJTNCG": "Dow Jones Personal & Household Goods Titans 30 Index", "I:DJTNCGE": "Dow Jones Personal & Household Goods Titans 30 Index (EUR)", "I:DJTNCGT": "Dow Jones Personal & Household Goods Titans 30 Total Return Index", "I:DJTREA": "Dow Jones Real Estate Titans 30 Index (USD)", "I:DJTREAE": "Dow Jones Real Estate Titans 30 Index (EUR)", "I:DJTREAT": "Dow Jones Real Estate Titans 30 Index TR (USD)", "I:DJTRET": "Dow Jones Retail Titans 30 Index", "I:DJTRETE": "Dow Jones Retail Titans 30 Index (EUR)", "I:DJTRETT": "Dow Jones Retail Titans 30 Total Return Index", "I:DJTSAB": "Dow Jones U.S. High Beta Index", "I:DJTSABT": "Dow Jones U.S. High Beta Total Return Index", "I:DJTSEC": "Dow Jones Sector Titans Composite Index", "I:DJTSECE": "Dow Jones Sector Titans Composite Titans Index (EUR)", "I:DJTSMO": "Dow Jones U.S. Low Momentum Index", "I:DJTSMOT": "Dow Jones U.S. Low Momentum Total Return Index", "I:DJTSQU": "Dow Jones U.S. Thematic Short Quality Index", "I:DJTSQUT": "Dow Jones U.S. Thematic Short Quality Total Return Index", "I:DJTSSS": "Dow Jones U.S. Thematic Short Size Index", "I:DJTSSST": "Dow Jones U.S. Thematic Short Size Total Return Index", "I:DJTSSV": "Dow Jones U.S. Short Relative Value Index", "I:DJTSSVT": "Dow Jones U.S. Short Relative Value Total Return Index", "I:DJTTEL": "Dow Jones Telecommunications Titans 30 Index", "I:DJTTELE": "Dow Jones Telecommunications Titans 30 Index (EUR)", "I:DJTTELT": "Dow Jones Telecommunications Titans 30 Total Return Index", "I:DJTTHE": "Dow Jones Technology Titans 30 Index", "I:DJTTHEE": "Dow Jones Technology Titans 30 Index (EUR)", "I:DJTTHET": "Dow Jones Technology Titans 30 Total Return Index", "I:DJTTR": "Dow Jones Transportation Average TR", "I:DJTUTS": "Dow Jones Utilities Titans 30 Index (USD)", "I:DJTUTSE": "Dow Jones Utilities Titans 30 Index (EUR)", "I:DJTUTST": "Dow Jones Utilities Titans 30 Index TR (USD)", "I:DJTWD3TP": "Dow Jones Taiwan High Quality Dividend 30 Index (TWD)", "I:DJU": "Dow Jones Utility Average", "I:DJULIV": "FT Cboe Vest U.S. Equity Deep Buffer ETF July Intraday Indicative Value", "I:DJULTC": "Dow Jones U.S. Large-Cap Technology Index", "I:DJUMECUN": "Dow Jones U.S. Select Medical Equipment Capped 35/20 Index (USD) NTR", "I:DJUMECUP": "Dow Jones U.S. Select Medical Equipment Capped 35/20 Index (USD)", "I:DJUMECUT": "Dow Jones U.S. Select Medical Equipment Capped 35/20 Index (USD) TR", "I:DJUNIV": "FT Cboe Vest U.S. Equity Deep Buffer ETF June Intraday Indicative Value", "I:DJUS": "Dow Jones U.S. Index", "I:DJUS50": "Dow Jones Islamic Market U.S. Titans 50 Index", "I:DJUSAE": "Dow Jones U.S. Aerospace & Defense Index", "I:DJUSAF": "Dow Jones U.S. Delivery Services Index", "I:DJUSAG": "Dow Jones U.S. Asset Managers Index", "I:DJUSAI": "Dow Jones U.S. Electronic Equipment Index", "I:DJUSAL": "Dow Jones U.S. Aluminum Index", "I:DJUSAM": "Dow Jones U.S. Medical Equipment Index", "I:DJUSAP": "Dow Jones U.S. Automobiles & Parts Index", "I:DJUSAR": "Dow Jones U.S. Airlines Index", "I:DJUSAS": "Dow Jones U.S. Aerospace Index", "I:DJUSAT": "Dow Jones U.S. Auto Parts Index", "I:DJUSAU": "Dow Jones U.S. Automobiles Index", "I:DJUSAV": "Dow Jones U.S. Media Agencies Index", "I:DJUSBC": "Dow Jones U.S. Broadcasting & Entertainment Index", "I:DJUSBD": "Dow Jones U.S. Building Materials & Fixtures Index", "I:DJUSBE": "Dow Jones U.S. Business Training & Employment Agencies Index", "I:DJUSBK": "Dow Jones U.S. Banks Index", "I:DJUSBKT": "Dow Jones U.S. Banks Total Return Index", "I:DJUSBM": "Dow Jones U.S. Basic Materials Index", "I:DJUSBMT": "Dow Jones U.S. Basic Materials Total Return Index", "I:DJUSBS": "Dow Jones U.S. Basic Resources Index", "I:DJUSBT": "Dow Jones U.S. Biotechnology Index", "I:DJUSBTT": "Dow Jones U.S. Biotechnology Total Return Index", "I:DJUSBV": "Dow Jones U.S. Beverages Index", "I:DJUSCA": "Dow Jones U.S. Gambling Index", "I:DJUSCC": "Dow Jones U.S. Commodity Chemicals Index", "I:DJUSCF": "Dow Jones U.S. Clothing & Accessories Index", "I:DJUSCG": "Dow Jones U.S. Travel & Leisure Index", "I:DJUSCH": "Dow Jones U.S. Chemicals Index", "I:DJUSCM": "Dow Jones U.S. Personal Products Index", "I:DJUSCN": "Dow Jones U.S. Construction & Materials Index", "I:DJUSCP": "Dow Jones U.S. Containers & Packaging Index", "I:DJUSCR": "Dow Jones U.S. Computer Hardware Index", "I:DJUSCS": "Dow Jones U.S. Specialized Consumer Services Index", "I:DJUSCT": "Dow Jones U.S. Telecommunications Equipment Index", "I:DJUSCX": "Dow Jones U.S. Specialty Chemicals Index", "I:DJUSCY": "Dow Jones U.S. Consumer Services Index", "I:DJUSCYC": "Dow Jones U.S. Consumer Services Capped Index (USD)", "I:DJUSCYCT": "Dow Jones U.S. Consumer Services Capped Index (USD) TR", "I:DJUSCYT": "Dow Jones U.S. Consumer Services Total Return Index", "I:DJUSDB": "Dow Jones U.S. Brewers Index", "I:DJUSDIV": "Dow Jones U.S. Dividend 100 Index", "I:DJUSDIVN": "Dow Jones U.S. Dividend 100 Net Total Return Index", "I:DJUSDIVT": "Dow Jones U.S. Dividend 100 Total Return Index", "I:DJUSDN": "Dow Jones U.S. Defense Index", "I:DJUSDR": "Dow Jones U.S. Food & Drug Retailers Index", "I:DJUSDS": "Dow Jones U.S. Industrial Suppliers Index", "I:DJUSDT": "Dow Jones U.S. Diversified REITs Index", "I:DJUSDV": "Dow Jones U.S. Computer Services Index", "I:DJUSEC": "Dow Jones U.S. Electrical Components & Equipment Index", "I:DJUSEE": "Dow Jones U.S. Electronic & Electrical Equipment Index", "I:DJUSEH": "Dow Jones U.S. Real Estate Holding & Development Index", "I:DJUSEN": "Dow Jones U.S. Oil & Gas Index", "I:DJUSENN": "Dow Jones U.S. Oil & Gas Net Total Return Index", "I:DJUSENT": "Dow Jones U.S. Oil & Gas Total Return Index", "I:DJUSES": "Dow Jones U.S. Real Estate Services Index", "I:DJUSEU": "Dow Jones U.S. Electricity Index", "I:DJUSFA": "Dow Jones U.S. Financial Administration Index", "I:DJUSFB": "Dow Jones U.S. Food & Beverage Index", "I:DJUSFC": "Dow Jones U.S. Fixed Line Telecommunications Index", "I:DJUSFD": "Dow Jones U.S. Food Retailers & Wholesalers Index", "I:DJUSFE": "Dow Jones U.S. Industrial Machinery Index", "I:DJUSFH": "Dow Jones U.S. Furnishings Index", "I:DJUSFI": "Dow Jones U.S. Financial Services Supersector Index (USD)", "I:DJUSFN": "Dow Jones U.S. Financials Index", "I:DJUSFNC": "Dow Jones U.S. Financials Capped Index (USD)", "I:DJUSFNCT": "Dow Jones U.S. Financials Capped Index (USD) TR", "I:DJUSFNT": "Dow Jones U.S. Financials Total Return Index", "I:DJUSFO": "Dow Jones U.S. Food Producers Index", "I:DJUSFP": "Dow Jones U.S. Food Products Index", "I:DJUSFT": "Dow Jones U.S. Footwear Index", "I:DJUSFV": "Dow Jones U.S. Financial Services Index (USD)", "I:DJUSFVT": "Dow Jones U.S. Financial Services Index TR (USD)", "I:DJUSGF": "Dow Jones U.S. Financial Services Sector Index (USD)", "I:DJUSGI": "Dow Jones U.S. General Industrials Index", "I:DJUSGL": "Dow Jones U.S. Large-Cap Growth Index", "I:DJUSGM": "Dow Jones U.S. Mid-Cap Growth Index", "I:DJUSGR": "Dow Jones U.S. Growth Index", "I:DJUSGS": "Dow Jones U.S. Small-Cap Growth Index", "I:DJUSGT": "Dow Jones U.S. General Retailers Index", "I:DJUSGU": "Dow Jones U.S. Gas Distribution Index", "I:DJUSHB": "Dow Jones U.S. Home Construction Index", "I:DJUSHC": "Dow Jones U.S. Health Care Index", "I:DJUSHCT": "Dow Jones U.S. Health Care Total Return Index", "I:DJUSHD": "Dow Jones U.S. Durable Household Products Index", "I:DJUSHG": "Dow Jones U.S. Household Goods & Home Construction Index", "I:DJUSHI": "Dow Jones U.S. Home Improvement Retailers Index", "I:DJUSHL": "Dow Jones U.S. Hotel & Lodging REITs Index", "I:DJUSHN": "Dow Jones U.S. Nondurable Household Products Index", "I:DJUSHP": "Dow Jones U.S. Health Care Providers Index", "I:DJUSHR": "Dow Jones U.S. Commercial Vehicles & Trucks Index", "I:DJUSHV": "Dow Jones U.S. Heavy Construction Index", "I:DJUSIB": "Dow Jones U.S. Insurance Brokers Index", "I:DJUSID": "Dow Jones U.S. Diversified Industrials Index", "I:DJUSIF": "Dow Jones U.S. Full Line Insurance Index", "I:DJUSIG": "Dow Jones U.S. Industrial Goods & Services Index", "I:DJUSIL": "Dow Jones U.S. Life Insurance Index", "I:DJUSIM": "Dow Jones U.S. Industrial Metals & Mining Index", "I:DJUSIN": "Dow Jones U.S. Industrials Index", "I:DJUSINT": "Dow Jones U.S. Industrials Total Return Index", "I:DJUSIO": "Dow Jones U.S. Industrial & Office REITs Index", "I:DJUSIP": "Dow Jones U.S. Property & Casualty Insurance Index", "I:DJUSIQ": "Dow Jones U.S. Industrial Engineering Index", "I:DJUSIR": "Dow Jones U.S. Insurance Index", "I:DJUSIS": "Dow Jones U.S. Support Services Index", "I:DJUSIT": "Dow Jones U.S. Industrial Transportation Index", "I:DJUSIU": "Dow Jones U.S. Reinsurance Index", "I:DJUSIV": "Dow Jones U.S. Business Support Services Index", "I:DJUSIX": "Dow Jones U.S. Nonlife Insurance Index", "I:DJUSL": "Dow Jones U.S. Large-Cap Index", "I:DJUSLE": "Dow Jones U.S. Leisure Goods Index", "I:DJUSLG": "Dow Jones U.S. Hotels Index", "I:DJUSLW": "Dow Jones U.S. Low-Cap Index", "I:DJUSM": "Dow Jones U.S. Mid-Cap Index", "I:DJUSMC": "Dow Jones U.S. Health Care Equipment & Services Index", "I:DJUSME": "Dow Jones U.S. Media Index", "I:DJUSMF": "Dow Jones U.S. Mortgage Finance Index", "I:DJUSMG": "Dow Jones U.S. Mining Index", "I:DJUSMR": "Dow Jones U.S. Mortgage REITs Index", "I:DJUSMS": "Dow Jones U.S. Medical Supplies Index", "I:DJUSMT": "Dow Jones U.S. Marine Transportation Index", "I:DJUSMU": "Dow Jones U.S. Multiutilities Index", "I:DJUSNC": "Dow Jones U.S. Consumer Goods Index", "I:DJUSNCT": "Dow Jones U.S. Consumer Goods Total Return Index", "I:DJUSNF": "Dow Jones U.S. Nonferrous Metals Index", "I:DJUSNG": "Dow Jones U.S. Personal & Household Goods Index", "I:DJUSNS": "Dow Jones U.S. Internet Index", "I:DJUSOG": "Dow Jones U.S. Oil & Gas Producers Index", "I:DJUSOI": "Dow Jones U.S. Oil Equipment & Services Index", "I:DJUSOL": "Dow Jones U.S. Integrated Oil & Gas Index", "I:DJUSOQ": "Dow Jones U.S. Oil Equipment Services & Distribution Index", "I:DJUSOQT": "Dow Jones U.S. Oil Equipment Services & Distribution Total Return Index", "I:DJUSOS": "Dow Jones U.S. Exploration & Production Index", "I:DJUSPB": "Dow Jones U.S. Publishing Index", "I:DJUSPC": "Dow Jones U.S. Waste & Disposal Services Index", "I:DJUSPG": "Dow Jones U.S. Personal Goods Index", "I:DJUSPL": "Dow Jones U.S. Pipelines Index", "I:DJUSPM": "Dow Jones U.S. Gold Mining Index", "I:DJUSPN": "Dow Jones U.S. Pharmaceuticals & Biotechnology Index", "I:DJUSPR": "Dow Jones U.S. Pharmaceuticals Index", "I:DJUSPRT": "Dow Jones U.S. Pharmaceuticals Total Return Index", "I:DJUSRA": "Dow Jones U.S. Apparel Retailers Index", "I:DJUSRB": "Dow Jones U.S. Broadline Retailers Index", "I:DJUSRD": "Dow Jones U.S. Drug Retailers Index", "I:DJUSRE": "Dow Jones U.S. Real Estate Index", "I:DJUSRET": "Dow Jones U.S. Real Estate Total Return Index", "I:DJUSRH": "Dow Jones U.S. Real Estate Investment & Services Index", "I:DJUSRI": "Dow Jones U.S. Real Estate Investment Trusts Index", "I:DJUSRL": "Dow Jones U.S. Retail REITs Index", "I:DJUSRN": "Dow Jones U.S. Residential REITs Index", "I:DJUSRP": "Dow Jones U.S. Recreational Products Index", "I:DJUSRQ": "Dow Jones U.S. Recreational Services Index", "I:DJUSRR": "Dow Jones U.S. Railroads Index", "I:DJUSRS": "Dow Jones U.S. Specialty Retailers Index", "I:DJUSRT": "Dow Jones U.S. Retail Index", "I:DJUSRU": "Dow Jones U.S. Restaurants & Bars Index", "I:DJUSS": "Dow Jones U.S. Small-Cap Index", "I:DJUSSB": "Dow Jones U.S. Investment Services Index", "I:DJUSSC": "Dow Jones U.S. Semiconductors Index", "I:DJUSSCT": "Dow Jones U.S. Semiconductors Total Return Index", "I:DJUSSD": "Dow Jones U.S. Soft Drinks Index", "I:DJUSSF": "Dow Jones U.S. Consumer Finance Index", "I:DJUSSP": "Dow Jones U.S. Specialty Finance Index", "I:DJUSSR": "Dow Jones U.S. Specialty REITs Index", "I:DJUSST": "Dow Jones U.S. Iron & Steel Index", "I:DJUSSTRN": "Dow Jones U.S. Select Short-Term REIT Index NTR", "I:DJUSSV": "Dow Jones U.S. Software & Computer Services Index", "I:DJUSSW": "Dow Jones U.S. Software Index", "I:DJUSTB": "Dow Jones U.S. Tobacco Index", "I:DJUSTC": "Dow Jones U.S. Technology Index", "I:DJUSTCC": "Dow Jones U.S. Technology Capped Index (USD)", "I:DJUSTCCT": "Dow Jones U.S. Technology Index Capped (USD) TR", "I:DJUSTCT": "Dow Jones U.S. Technology Total Return Index", "I:DJUSTK": "Dow Jones U.S. Trucking Index", "I:DJUSTL": "Dow Jones U.S. Telecommunications Index", "I:DJUSTLT": "Dow Jones U.S. Telecommunications Total Return Index", "I:DJUSTP": "Dow Jones U.S. Top-Cap Index", "I:DJUSTQ": "Dow Jones U.S. Technology Hardware & Equipment Index", "I:DJUSTS": "Dow Jones U.S. Transportation Services Index", "I:DJUSTT": "Dow Jones U.S. Travel & Tourism Index", "I:DJUSTY": "Dow Jones U.S. Toys Index", "I:DJUSUO": "Dow Jones U.S. Gas Water & Multiutilities Index", "I:DJUSUT": "Dow Jones U.S. Utilities Index", "I:DJUSUTT": "Dow Jones U.S. Utilities Total Return Index", "I:DJUSVA": "Dow Jones U.S. Value Index", "I:DJUSVE": "Dow Jones U.S. Conventional Electricity Index", "I:DJUSVL": "Dow Jones U.S. Large-Cap Value Index", "I:DJUSVM": "Dow Jones U.S. Mid-Cap Value Index", "I:DJUSVN": "Dow Jones U.S. Distillers & Vintners Index", "I:DJUSVS": "Dow Jones U.S. Small-Cap Value Index", "I:DJUSWC": "Dow Jones U.S. Mobile Telecommunications Index", "I:DJUSWCT": "Dow Jones U.S. Mobile Telecommunications Total Return Index", "I:DJUSWU": "Dow Jones U.S. Water Index", "I:DJUTR": "Dow Jones Utility Average TR", "I:DJX": "Options on the Dow Jones Industrial Average", "I:DKDOW": "Dow Jones Denmark Index", "I:DKDOWD": "Dow Jones Denmark Index (USD)", "I:DLVIX": "Dynamic Long VIX Futures Index", "I:DMAYIV": "FT Cboe Vest U.S. Equity Deep Buffer ETF May Intraday Indicative Value", "I:DNOVIV": "FT Cboe Vest U.S. Equity Deep Buffer ETF - November Intraday Indicative Value", "I:DOCTIV": "FT Cboe Vest U.S. Equity Deep Buffer ETF October Intraday Indicative Value", "I:DOGE100K": "Cboe 100k DOGE / USD RealPrice", "I:DOGE10K": "Cboe 10000 DOGE / USD RealPrice", "I:DOGE200K": "Cboe 200K Dogecoin / US Dollar RealPrice Index", "I:DOGE500K": "Cboe 500K Dogecoin / US Dollar RealPrice Index", "I:DOGE50K": "Cboe 50000 DOGE / USD RealPrice", "I:DOGIV": "PROSHARES SHORT DOW30 ETF", "I:DOT10KRP": "Cboe 10000 Polkadot / USD RealPrice", "I:DOT1KRP": "Cboe 1000 Polkadot / USD RealPrice", "I:DOT2500": "Cboe 2500 Polkadot / USD RealPrice", "I:DOT250RP": "Cboe 250 Polkadot / USD RealPrice", "I:DOT5KRP": "Cboe 5000 Polkadot / USD RealPrice", "I:DRB": "NASDAQ US Buyback Achievers Index", "I:DRBG": "NASDAQ Global Buyback Achievers Index", "I:DRBGN": "NASDAQ Global Buyback Achievers NTR Index", "I:DRBGT": "NASDAQ Global Buyback Achievers TR Index", "I:DRBN": "NASDAQ US Buyback Achievers Net Total Return Index", "I:DRBNNR": "NASDAQ US Buyback Achievers Notational Net Total", "I:DRBS": "NASDAQ US Buyback Achievers Select Index", "I:DRBSN": "NASDAQ US Buyback Achievers Select NTR Index", "I:DRBST": "NASDAQ US Buyback Achievers Select TR Index", "I:DRBTR": "NASDAQ US Buyback Achievers Index TR", "I:DRBXUS": "NASDAQ International BuyBack Achievers Index", "I:DRBXUSN": "NASDAQ International BuyBack Achievers Net Total R", "I:DRBXUST": "NASDAQ International BuyBack Achievers Total Retur", "I:DRVIX": "Defined Risk Volatility Income", "I:DSEPIV": "FT Cboe Vest U.S. Equity Deep Buffer ETF September Intraday Indicative Value", "I:DSLVIV": "VelocityShares 3x Inverse Silver ETN Intraday Indicative Value", "I:DSVIER": "Dynamic Short VIX Futures Index", "I:DSVIX": "Dynamic Short VIX Futures Index", "I:DTX": "Dow Jones 1/10 Trans Index", "I:DUGIV": "PROSHARES ULTRASHORT OIL & GAS ETF", "I:DUX": "Dow Jones Utility Average Index", "I:DVG": "NASDAQ US Dividend Achievers Select Index", "I:DVGCAD": "NASDAQ US Dividend Achievers Select CAD Index", "I:DVGCADH": "NASDAQ US Dividend Achievers Selected Currency Hed", "I:DVGCADN": "NASDAQ US Dividend Achievers Select CAD NR", "I:DVGCADNY4": "NASDAQ US Dividend Achievers Select CAD NY4", "I:DVGCADNY4N": "NASDAQ US Dividend Achievers Select CAD NR NY4", "I:DVGCADTR": "NASDAQ US Dividend Achievers Select CAD Total Retu", "I:DVGCADTRNY4": "NASDAQ US Dividend Achievers Select CAD TR NY4", "I:DVGTCADH": "NASDAQ US Dividend Achievers Selected Currency Hed", "I:DVGTR": "NASDAQ US Dividend Achievers Select Index TR", "I:DVNDIV": "Touchstone Dividend Select ETF", "I:DVS": "S&P 500 Dividend Index 10X", "I:DW25": "Dow Jones U.S. Broad Stock Market Index", "I:DW25T": "Dow Jones U.S. Broad Stock Market Total Return Index", "I:DWACSM": "Dorsey Wright Country and Stock Momentum Index", "I:DWACSMN": "Dorsey Wright Country and Stock Momentum NTR Index", "I:DWACSMT": "Dorsey Wright Country and Stock Momentum TR Index", "I:DWADM": "Dorsey Wright Developed Markets Tech Leaders", "I:DWADMNTR": "Dorsey Wright Developed Markets Tech Leaders NTR", "I:DWAEM": "Dorsey Wright Emerging Markets Tech Leaders", "I:DWAEMNTR": "Dorsey Wright Emerging Markets Tech Leaders NTR", "I:DWAMLP": "DWA MLP Select Index", "I:DWAMLPN": "DWA MLP Select NTR Index", "I:DWAMLPT": "DWA MLP Select Total Return Index", "I:DWAMLV": "Dorsey Wright Momentum Plus Low Volatility Index", "I:DWAMLVCH": "DWA Switzerland Momentum & Low Volatility", "I:DWAMLVCHNTR": "DWA Switzerland Momentum & Low Volatility NTR", "I:DWAMLVCHT": "DWA Switzerland Momentum & Low Volatility TR", "I:DWAMLVDM": "DWA Developed Market Momentum & Low Volatility", "I:DWAMLVDMNTR": "DWA Developed Market Momentum & Low Volatility NTR", "I:DWAMLVDMT": "DWA Developed Market Momentum & Low Volatility TR", "I:DWAMLVEM": "DWA Emerging Market Momentum & Low Volatility", "I:DWAMLVEMNTR": "DWA Emerging Market Momentum & Low Volatility NTR", "I:DWAMLVEMT": "DWA Emerging Market Momentum & Low Volatility TR", "I:DWAMLVN": "Dorsey Wright Momentum Plus Low Vol NTR Index", "I:DWAMLVT": "Dorsey Wright Momentum Plus Low Vol TR Index", "I:DWAMRS": "Dow Jones Americas Select Real Estate Securities Index", "I:DWAMRT": "Dow Jones Americas Select REIT Index (USD)", "I:DWAMV": "Dorsey Wright Momentum Plus Value Index", "I:DWAMVN": "Dorsey Wright Momentum Plus Value NTR Index", "I:DWAMVT": "Dorsey Wright Momentum Plus Value TR Index", "I:DWAMY": "Dorsey Wright Momentum Plus Dividend Yield Index", "I:DWAMYN": "Dorsey Wright Momentum Plus Dividend Yld NTR Index", "I:DWAMYT": "Dorsey Wright Momentum Plus Dividend Yld TR Index", "I:DWANQDFF": "Dorsey Wright Dynamic Focus Five Index", "I:DWANQDFFT": "Dorsey Wright Dynamic Focus Five Total Return Inde", "I:DWANQFF": "Dorsey Wright Focus Five Index", "I:DWANQFFT": "Dorsey Wright Focus Five Total Return Index", "I:DWANQIFF": "Dorsey Wright International Focus Five Index", "I:DWANQIFFT": "Dorsey Wright International Focus Five Total Retur", "I:DWAPRS": "Dow Jones Asia/Pacific Select Real Estate Securities Index", "I:DWAPRT": "Dow Jones Asia/Pacific Select REIT Index (USD)", "I:DWATLMY": "Dorsey Wright Technical Leaders Malaysia Index", "I:DWATLMYMYR": "Dorsey Wright TL Malaysia MYR Index", "I:DWATLMYMYRNTR": "Dorsey Wright TL Malaysia MYR Index NTR Index", "I:DWATLMYMYRTR": "Dorsey Wright TL Malaysia MYR Index TR Index", "I:DWATLMYNTR": "Dorsey Wright Technical Leaders Malaysia Index NTR", "I:DWATLMYTR": "Dorsey Wright Technical Leaders Malaysia Index TR", "I:DWATLSC": "Dorsey Wright SmallCap Tech Leaders", "I:DWATLSCT": "Dorsey Wright SmallCap Tech Leaders TR", "I:DWATRDM": "Dorsey Wright Developed Markets Tech Leaders TR", "I:DWATREM": "Dorsey Wright Emerging Markets Tech Leaders TR", "I:DWATTMC": "Dorsey Wright Tactical Tilt Moderate Core Index", "I:DWATTMCT": "Dorsey Wright Tactical Tilt Moderate Core TR Index","I:DWBM": "Dorsey Wright Basic Materials Tech Leaders", "I:DWBMTR": "Dorsey Wright Basic Materials Tech Leaders TR", "I:DWCAEC": "Dow Jones U.S. Alternative Electricity Total Stock Market Index", "I:DWCAEG": "Dow Jones U.S. Alternative Energy Total Stock Market Index", "I:DWCAFL": "Dow Jones U.S. Alternative Fuels Total Stock Market Index", "I:DWCAIR": "Dow Jones U.S. Airlines Total Stock Market Index", "I:DWCALU": "Dow Jones U.S. Aluminum Total Stock Market Index", "I:DWCAMG": "Dow Jones U.S. Asset Managers Total Stock Market Index", "I:DWCAPR": "Dow Jones U.S. Apparel Retailers Total Stock Market Index", "I:DWCAPT": "Dow Jones U.S. Auto Parts Total Stock Market Index", "I:DWCARD": "Dow Jones U.S. Aerospace & Defense Total Stock Market Index", "I:DWCARO": "Dow Jones U.S. Aerospace Total Stock Market Index", "I:DWCATO": "Dow Jones U.S. Automobiles Total Stock Market Index", "I:DWCAUP": "Dow Jones U.S. Automobiles & Parts Total Stock Market Index", "I:DWCBLD": "Dow Jones U.S. Building Materials & Fixtures Total Stock Market Index", "I:DWCBNK": "Dow Jones U.S. Banks Total Stock Market Index", "I:DWCBRD": "Dow Jones U.S. Broadcasting & Entertainment Total Stock Market Index", "I:DWCBRW": "Dow Jones U.S. Brewers Total Stock Market Index", "I:DWCBSC": "Dow Jones U.S. Basic Resources Total Stock Market Index", "I:DWCBSM": "Dow Jones U.S. Basic Materials Total Stock Market Index", "I:DWCBSS": "Dow Jones U.S. Business Support Services Total Stock Market Index", "I:DWCBTC": "Dow Jones U.S. Biotechnology Total Stock Market Index", "I:DWCBTE": "Dow Jones U.S. Business Training & Employment Agencies Total Stock Market Index", "I:DWCBVG": "Dow Jones U.S. Beverages Total Stock Market Index", "I:DWCC": "Dorsey Wright Consumer Cyclicals Tech Leaders", "I:DWCCEC": "Dow Jones U.S. Conventional Electricity Total Stock Market Index", "I:DWCCGS": "Dow Jones U.S. Consumer Goods Total Stock Market Index", "I:DWCCHC": "Dow Jones U.S. Commodity Chemicals Total Stock Market Index", "I:DWCCHM": "Dow Jones U.S. Chemicals Total Stock Market Index", "I:DWCCHS": "Dow Jones U.S. Specialty Chemicals Total Stock Market Index", "I:DWCCLO": "Dow Jones U.S. Clothing & Accessories Total Stock Market Index", "I:DWCCMP": "Dow Jones U.S. Computer Services Total Stock Market Index", "I:DWCCNS": "Dow Jones U.S. Construction & Materials Total Stock Market Index", "I:DWCCOA": "Dow Jones U.S. Coal Total Stock Market Index", "I:DWCCON": "Dow Jones U.S. Heavy Construction Total Stock Market Index", "I:DWCCPR": "Dow Jones U.S. Computer Hardware Total Stock Market Index", "I:DWCCSE": "Dow Jones U.S. Consumer Electronics Total Stock Market Index", "I:DWCCSF": "Dow Jones U.S. Consumer Finance Total Stock Market Index", "I:DWCCSV": "Dow Jones U.S. Consumer Services Total Stock Market Index", "I:DWCCTR": "Dorsey Wright Consumer Cyclicals Tech Leaders TR", "I:DWCDEF": "Dow Jones U.S. Defense Total Stock Market Index", "I:DWCDLS": "Dow Jones U.S. Delivery Services Total Stock Market Index", "I:DWCDSV": "Dow Jones U.S. Distillers & Vintners Total Stock Market Index", "I:DWCDVF": "Dow Jones U.S. Diversified REITs Total Stock Market Index", "I:DWCEEE": "Dow Jones U.S. Electronic & Electrical Equipment Total Stock Market Index", "I:DWCELC": "Dow Jones U.S. Electricity Total Stock Market Index", "I:DWCELQ": "Dow Jones U.S. Electrical Components & Equipment Total Stock Market Index", "I:DWCEXP": "Dow Jones U.S. Exploration & Production Total Stock Market Index", "I:DWCF": "Dow Jones U.S. Total Stock Market Index", "I:DWCFAC": "Dow Jones U.S. Industrial Machinery Total Stock Market Index", "I:DWCFAD": "Dow Jones U.S. Financial Administration Total Stock Market Index", "I:DWCFAF": "Dow Jones U.S. Farming & Fishing Total Stock Market Index", "I:DWCFDR": "Dow Jones U.S. Food & Drug Retailers Total Stock Market Index", "I:DWCFIN": "Dow Jones U.S. Financials Total Stock Market Index", "I:DWCFNT": "Dow Jones U.S. Total Stock Market Total Return Net Index", "I:DWCFOB": "Dow Jones U.S. Food & Beverage Total Stock Market Index", "I:DWCFOD": "Dow Jones U.S. Food Products Total Stock Market Index", "I:DWCFOP": "Dow Jones U.S. Food Producers Total Stock Market Index", "I:DWCFOT": "Dow Jones U.S. Footwear Total Stock Market Index", "I:DWCFRN": "Dow Jones U.S. Furnishings Total Stock Market Index", "I:DWCFRP": "Dow Jones U.S. Forestry & Paper Total Stock Market Index", "I:DWCFRW": "Dow Jones U.S. Food Retailers & Wholesalers Total Stock Market Index", "I:DWCFSV": "Dow Jones U.S. Financial Services Supersector Total Stock Market Index (USD)", "I:DWCFT": "Dow Jones U.S. Total Stock Market Total Return Index", "I:DWCFTL": "Dow Jones U.S. Fixed Line Telecommunications Total Stock Market Index", "I:DWCGAM": "Dow Jones U.S. Gambling Total Stock Market Index", "I:DWCGAS": "Dow Jones U.S. Gas Distribution Total Stock Market Index", "I:DWCGFN": "Dow Jones U.S. Financial Services Sector Total Stock Market Index (USD)", "I:DWCGWM": "Dow Jones U.S. Gas Water & Multiutilities Total Stock Market Index", "I:DWCHCE": "Dow Jones U.S. Health Care Equipment & Services Total Stock Market Index", "I:DWCHCR": "Dow Jones U.S. Health Care Total Stock Market Index", "I:DWCHEA": "Dow Jones U.S. Health Care Providers Total Stock Market Index", "I:DWCHHG": "Dow Jones U.S. Household Goods & Home Construction Total Stock Market Index", "I:DWCHIR": "Dow Jones U.S. Home Improvement Retailers Total Stock Market Index", "I:DWCHOM": "Dow Jones U.S. Home Construction Total Stock Market Index", "I:DWCHPD": "Dow Jones U.S. Durable Household Products Total Stock Market Index", "I:DWCHPN": "Dow Jones U.S. Nondurable Household Products Total Stock Market Index", "I:DWCHTL": "Dow Jones U.S. Hotels Total Stock Market Index", "I:DWCHTR": "Dow Jones U.S. Hotel & Lodging REITs Total Stock Market Index", "I:DWCIDD": "Dow Jones U.S. Diversified Industrials Total Stock Market Index", "I:DWCIDE": "Dow Jones U.S. Industrial Engineering Total Stock Market Index", "I:DWCIDM": "Dow Jones U.S. Industrial Metals & Mining Total Stock Market Index", "I:DWCIDS": "Dow Jones U.S. Industrial Suppliers Total Stock Market Index", "I:DWCIDU": "Dow Jones U.S. Industrials Total Stock Market Index", "I:DWCIGS": "Dow Jones U.S. Industrial Goods & Services Total Stock Market Index", "I:DWCINB": "Dow Jones U.S. Insurance Brokers Total Stock Market Index", "I:DWCIND": "Dow Jones U.S. General Industrials Total Stock Market Index", "I:DWCINF": "Dow Jones U.S. Full Line Insurance Total Stock Market Index", "I:DWCINL": "Dow Jones U.S. Life Insurance Total Stock Market Index", "I:DWCINP": "Dow Jones U.S. Property & Casualty Insurance Total Stock Market Index", "I:DWCINS": "Dow Jones U.S. Insurance Total Stock Market Index", "I:DWCINT": "Dow Jones U.S. Internet Total Stock Market Index", "I:DWCINV": "Dow Jones U.S. Investment Services Total Stock Market Index", "I:DWCIOF": "Dow Jones U.S. Industrial & Office REITs Total Stock Market Index", "I:DWCIOG": "Dow Jones U.S. Integrated Oil & Gas Total Stock Market Index", "I:DWCITC": "Dow Jones U.S. Electronic Equipment Total Stock Market Index", "I:DWCLSG": "Dow Jones U.S. Leisure Goods Total Stock Market Index", "I:DWCMAC": "Dow Jones U.S. Commercial Vehicles & Trucks Total Stock Market Index", "I:DWCMAR": "Dow Jones U.S. Marine Transportation Total Stock Market Index", "I:DWCMDA": "Dow Jones U.S. Media Agencies Total Stock Market Index", "I:DWCMDI": "Dow Jones U.S. Media Total Stock Market Index", "I:DWCMDS": "Dow Jones U.S. Medical Supplies Total Stock Market Index", "I:DWCMED": "Dow Jones U.S. Medical Equipment Total Stock Market Index", "I:DWCMGF": "Dow Jones U.S. Mortgage Finance Total Stock Market Index", "I:DWCMIN": "Dow Jones U.S. Mining Total Stock Market Index", "I:DWCMNG": "Dow Jones U.S. General Mining Total Stock Market Index", "I:DWCMTG": "Dow Jones U.S. Mortgage REITs Total Stock Market Index", "I:DWCMTL": "Dow Jones U.S. Mobile Telecommunications Total Stock Market Index", "I:DWCMUT": "Dow Jones U.S. Multiutilities Total Stock Market Index", "I:DWCNLI": "Dow Jones U.S. Nonlife Insurance Total Stock Market Index", "I:DWCOES": "Dow Jones U.S. Oil Equipment & Services Total Stock Market Index", "I:DWCOFF": "Dow Jones U.S. Electronic Office Equipment Total Stock Market Index", "I:DWCOGP": "Dow Jones U.S. Oil & Gas Producers Total Stock Market Index", "I:DWCOGS": "Dow Jones U.S. Oil & Gas Total Stock Market Index", "I:DWCONF": "Dow Jones U.S. Nonferrous Metals Total Stock Market Index", "I:DWCOSD": "Dow Jones U.S. Oil Equipment Services & Distribution Total Stock Market Index", "I:DWCPAP": "Dow Jones U.S. Paper Total Stock Market Index", "I:DWCPBT": "Dow Jones U.S. Pharmaceuticals & Biotechnology Total Stock Market Index", "I:DWCPCS": "Dow Jones U.S. Gold Mining Total Stock Market Index", "I:DWCPF": "Dow Jones U.S. Completion Total Stock Market Index", "I:DWCPHG": "Dow Jones U.S. Personal & Household Goods Total Stock Market Index", "I:DWCPHM": "Dow Jones U.S. Pharmaceuticals Total Stock Market Index", "I:DWCPIP": "Dow Jones U.S. Pipelines Total Stock Market Index", "I:DWCPOL": "Dow Jones U.S. Waste & Disposal Services Total Stock Market Index", "I:DWCPPD": "Dow Jones U.S. Personal Products Total Stock Market Index", "I:DWCPSG": "Dow Jones U.S. Personal Goods Total Stock Market Index", "I:DWCPUB": "Dow Jones U.S. Publishing Total Stock Market Index", "I:DWCRAI": "Dow Jones U.S. Railroads Total Stock Market Index", "I:DWCRCS": "Dow Jones U.S. Recreational Services Total Stock Market Index", "I:DWCREA": "Dow Jones U.S. Real Estate Total Stock Market Index", "I:DWCREE": "Dow Jones U.S. Renewable Energy Equipment Total Stock Market Index", "I:DWCREH": "Dow Jones U.S. Real Estate Holding & Development Total Stock Market Index", "I:DWCREI": "Dow Jones U.S. Real Estate Investment Trusts Total Stock Market Index", "I:DWCREQ": "Dow Jones U.S. Recreational Products Total Stock Market Index", "I:DWCRES": "Dow Jones U.S. Restaurants & Bars Total Stock Market Index", "I:DWCRHD": "Dow Jones U.S. Real Estate Investment & Services Total Stock Market Index", "I:DWCRNS": "Dow Jones U.S. Reinsurance Total Stock Market Index", "I:DWCRSD": "Dow Jones U.S. Residential REITs Total Stock Market Index", "I:DWCRSV": "Dow Jones U.S. Real Estate Services Total Stock Market Index", "I:DWCRTB": "Dow Jones U.S. Broadline Retailers Total Stock Market Index", "I:DWCRTD": "Dow Jones U.S. Drug Retailers Total Stock Market Index", "I:DWCRTL": "Dow Jones U.S. Retail Total Stock Market Index", "I:DWCRTR": "Dow Jones U.S. Retail REITs Total Stock Market Index", "I:DWCRTS": "Dow Jones U.S. General Retailers Total Stock Market Index", "I:DWCS": "Dorsey Wright Consumer Staples Tech Leaders", "I:DWCSCV": "Dow Jones U.S. Specialized Consumer Services Total Stock Market Index", "I:DWCSEM": "Dow Jones U.S. Semiconductors Total Stock Market Index", "I:DWCSFC": "Dow Jones U.S. Software & Computer Services Total Stock Market Index", "I:DWCSFT": "Dow Jones U.S. Soft Drinks Total Stock Market Index", "I:DWCSOF": "Dow Jones U.S. Software Total Stock Market Index", "I:DWCSPC": "Dow Jones U.S. Specialty REITs Total Stock Market Index", "I:DWCSPF": "Dow Jones U.S. Specialty Finance Total Stock Market Index", "I:DWCSPS": "Dow Jones U.S. Support Services Total Stock Market Index", "I:DWCSRT": "Dow Jones U.S. Specialty Retailers Total Stock Market Index", "I:DWCSTL": "Dow Jones U.S. Iron & Steel Total Stock Market Index", "I:DWCSTR": "Dorsey Wright Consumer Staples Tech Leaders TR", "I:DWCTCQ": "Dow Jones U.S. Technology Hardware & Equipment Total Stock Market Index", "I:DWCTEC": "Dow Jones U.S. Technology Total Stock Market Index", "I:DWCTIR": "Dow Jones U.S. Tires Total Stock Market Index", "I:DWCTLQ": "Dow Jones U.S. Telecommunications Equipment Total Stock Market Index", "I:DWCTLS": "Dow Jones U.S. Telecommunications Total Stock Market Index", "I:DWCTOB": "Dow Jones U.S. Tobacco Total Stock Market Index", "I:DWCTOY": "Dow Jones U.S. Toys Total Stock Market Index", "I:DWCTRA": "Dow Jones U.S. Industrial Transportation Total Stock Market Index", "I:DWCTRK": "Dow Jones U.S. Trucking Total Stock Market Index", "I:DWCTRS": "Dow Jones U.S. Transportation Services Total Stock Market Index", "I:DWCTTR": "Dow Jones U.S. Travel & Tourism Total Stock Market Index", "I:DWCTVL": "Dow Jones U.S. Travel & Leisure Total Stock Market Index", "I:DWCUTI": "Dow Jones U.S. Utilities Total Stock Market Index", "I:DWCWAT": "Dow Jones U.S. Water Total Stock Market Index", "I:DWEDRS": "Dow Jones Europe Developed Markets Select Real Estate Securities Index (USD)", "I:DWEDRSE": "Dow Jones Europe Developed Markets Select Real Estate Securities Index (EUR)", "I:DWEDRT": "Dow Jones Europe Developed Markets Select REIT Index (USD)", "I:DWEDRTE": "Dow Jones Europe Developed Markets Select REIT Index (EUR)", "I:DWEN": "Dorsey Wright Energy Tech Leaders", "I:DWENTR": "Dorsey Wright Energy Tech Leaders TR", "I:DWEURS": "Dow Jones Europe Select Real Estate Securities Index", "I:DWEURT": "Dow Jones Total Europe Select REIT Index (USD)", "I:DWFN": "Dorsey Wright Financials Tech Leaders", "I:DWFNTR": "Dorsey Wright Financials Tech Leaders TR", "I:DWGRO": "Dow Jones U.S. Growth Total Stock Market Index", "I:DWGRS": "Dow Jones Global Select Real Estate Securities Index", "I:DWGRSA": "Dow Jones Global Select Real Estate Securities Index Australian Dollar", "I:DWGRSAT": "Dow Jones Global Select Real Estate Securities Total Return Gross Index Australian Dollar", "I:DWGRST": "Dow Jones Global Select Real Estate Securities Total Return Gross Index", "I:DWGRT": "Dow Jones Global Select REIT Index (USD)", "I:DWHC": "Dorsey Wright Healthcare Tech Leaders", "I:DWHCTR": "Dorsey Wright Healthcare Tech Leaders TR", "I:DWIDX": "Dorsey Wright Industrials Tech Leaders", "I:DWIDXTR": "Dorsey Wright Industrials Tech Leaders TR", "I:DWL": "Dow Jones U.S. Large-Cap Total Stock Market Index", "I:DWLG": "Dow Jones U.S. Large-Cap Growth Total Stock Market Index", "I:DWLGT": "Dow Jones U.S. Large-Cap Growth Total Stock Market Total Return Index", "I:DWLT": "Dow Jones U.S. Large-Cap Total Stock Market Total Return Index", "I:DWLV": "Dow Jones U.S. Large-Cap Value Total Stock Market Index", "I:DWLVT": "Dow Jones U.S. Large-Cap Value Total Stock Market Total Return Index", "I:DWM": "Dow Jones U.S. Mid-Cap Total Stock Market Index", "I:DWMFRS": "Dow Jones Middle East & Africa Select Real Estate Securities Index", "I:DWMFRT": "Dow Jones Africa & Middle East Select REIT Index (USD)", "I:DWMG": "Dow Jones U.S. Mid-Cap Growth Total Stock Market Index", "I:DWMI": "Dow Jones U.S. Micro-Cap Total Stock Market Index", "I:DWMT": "Dow Jones U.S. Mid-Cap Total Stock Market Total Return Index", "I:DWMV": "Dow Jones U.S. Mid-Cap Value Total Stock Market Index", "I:DWRSF": "Dow Jones U.S. Select Real Estate Securities Index", "I:DWRTF": "Dow Jones U.S. Select REIT Index (USD)", "I:DWRTFN": "Dow Jones U.S. Select REIT Net Total Return Index (USD)", "I:DWRTFT": "Dow Jones U.S. Select REIT Total Return Index (USD)", "I:DWS": "Dow Jones U.S. Small-Cap Total Stock Market Index", "I:DWSG": "Dow Jones U.S. Small-Cap Growth Total Stock Market Index", "I:DWST": "Dow Jones U.S. Small-Cap Total Stock Market Total Return Index", "I:DWSV": "Dow Jones U.S. Small-Cap Value Total Stock Market Index", "I:DWTL": "Dorsey Wright Tech Leaders", "I:DWTLTR": "Dorsey Wright Tech Leaders TR", "I:DWTY": "Dorsey Wright Technology Tech Leaders", "I:DWTYTR": "Dorsey Wright Technology Tech Leaders TR", "I:DWUT": "Dorsey Wright Utilities Tech Leaders", "I:DWUTTR": "Dorsey Wright Utilities Tech Leaders TR", "I:DWVAL": "Dow Jones U.S. Value Total Stock Market Index", "I:DWXRS": "Dow Jones Global ex-U.S. Select Real Estate Securities Index", "I:DWXRSN": "Dow Jones Global ex-U.S. Select Real Estate Securities Total Return Net Index", "I:DWXRSNUH": "Dow Jones Global ex-U.S. Select Real Estate Securities Total Return Net Index (USD) Hedged", "I:DWXRST": "Dow Jones Global ex-U.S. Select Real Estate Securities Total Return Gross Index", "I:DWXRSTUH": "Dow Jones Global ex-U.S. Select Real Estate Securities Total Return Gross Index (USD) Hedged", "I:DWXRSUH": "Dow Jones Global ex-U.S. Select Real Estate Securities Index (USD) Hedged", "I:DWXRT": "Dow Jones Global ex-US Select REIT Index (USD)", "I:DXDIV": "PROSHARES ULTRASHORT DOW30 ETF", "I:DXL": "Cboe Jumbo DJX Index", "I:E1BSC": "Dow Jones Europe Basic Materials Index", "I:E1CYC": "Dow Jones Europe Consumer Services Index", "I:E1DOW": "Dow Jones Europe Index", "I:E1ENE": "Dow Jones Europe Oil & Gas Index", "I:E1FIN": "Dow Jones Europe Financials Index", "I:E1HCR": "Dow Jones Europe Health Care Index", "I:E1IDU": "Dow Jones Europe Industrials Index","I:E1TEC": "Dow Jones Europe Technology Index", "I:E1TLS": "Dow Jones Europe Telecommunications Index", "I:E1UTI": "Dow Jones Europe Utilities Index", "I:E2BSC": "Dow Jones Europe ex-U.K. Basic Materials Index", "I:E2CYC": "Dow Jones Europe ex-U.K. Consumer Services Index", "I:E2DOW": "Dow Jones Europe ex-U.K. Index", "I:E2ENE": "Dow Jones Europe ex-U.K. Oil & Gas Index", "I:E2FIN": "Dow Jones Europe ex-U.K. Financials Index", "I:E2HCR": "Dow Jones Europe ex-U.K. Health Care Index", "I:E2IDU": "Dow Jones Europe ex-U.K. Industrials Index", "I:E2NCY": "Dow Jones Europe ex-U.K. Consumer Goods Index", "I:E2TEC": "Dow Jones Europe ex-U.K. Technology Index", "I:E2TLS": "Dow Jones Europe ex-U.K. Telecommunications Index", "I:E2UTI": "Dow Jones Europe ex-U.K. Utilities Index", "I:E3DOW": "Dow Jones Europe - Nordic Index", "I:EAVOL": "Equity Armor Investments VOL 365 Index", "I:ECM": "Dow Jones Internet Commerce Index", "I:EDOW": "The Europe Dow (USD)", "I:EDOWD": "The Europe Dow Total Return (USD)", "I:EDOWE": "The Europe Dow (EUR)", "I:EDOWR": "The Europe Dow Total Return (EUR)", "I:EETIV": "PROSHARES ULTRA MSCI EMERGING MARKETS ETF", "I:EEVIV": "PROSHARES ULTRASHORT MSCI EMERGING MARKETS ETF", "I:EFADIV": "PROSHARES MSCI EAFE DIVIDEND GROWERS ETF", "I:EFOIV": "PROSHARES ULTRA MSCI EAFE ETF", "I:EFS": "MXEF Option Settlement Value", "I:EFUIV": "PROSHARES ULTRASHORT MSCI EAFE ETF", "I:EFZIV": "PROSHARES SHORT MSCI EAFE ETF", "I:ELX": "Ethereum Liquid Index", "I:EMCLOUD": "BVP Nasdaq Emerging Cloud Index", "I:EMCLOUDN": "BVP Nasdaq Emerging Cloud NTR Index", "I:EMCLOUDT": "BVP Nasdaq Emerging Cloud TR Index", "I:EMDVIV": "PROSHARES MSCI EM DIVIDEND GROWERS ETF", "I:EMTYIV": "PROSHARES DECLINE OF THE RETAIL STORE ETF", "I:ENDOW": "Endowment Index", "I:EOS100RP": "Cboe 100 Eos / US Dollar RealPrice Index", "I:EOS10RP": "Cboe 10 Eos / US Dollar RealPrice Index", "I:EOS400RP": "Cboe 400 Eos / US Dollar RealPrice Index", "I:EOS40RP": "Cboe 40 Eos / US Dollar RealPrice Index", "I:EOS800RP": "Cboe 800 Eos / US Dollar RealPrice Index", "I:EPVIV": "PROSHARES ULTRASHORT FTSE EUROPE ETF", "I:EQRRIV": "PROSHARES EQUITIES FOR RISING RATES ETF", "I:ES30": "Dow Jones Spain Titans 30 Index (EUR)", "I:ES30D": "Dow Jones Spain Titans 30 Index (USD)", "I:ESDOW": "Dow Jones Spain Index", "I:ESDOWD": "Dow Jones Spain Index (USD)", "I:ESGST": "Cboe ESG Options Settlement Symbol", "I:ESOX": "PHLX Semiconductor Equal Weighted Index", "I:ESOXNR": "PHLX Semiconductor Equal Weighted Net Total Return Index", "I:ESOXTR": "PHLX Semiconductor Equal Weighted Total Return Index", "I:ETC100RP": "Cboe 100 Ethereum Classic / US Dollar RealPrice Index", "I:ETC1KRP": "Cboe 1000 Ethereum Classic / US Dollar RealPrice Index", "I:ETC250RP": "Cboe 250 Ethereum Classic / US Dollar RealPrice Index", "I:ETC2KRP": "Cboe 2000 Ethereum Classic / US Dollar RealPrice Index", "I:ETC500RP": "Cboe 500 Ethereum Classic / US Dollar RealPrice Index", "I:ETFCOMP": "ISE ETF Composite Index", "I:ETFCOMPNTR": "ISE ETF Composite Net Total Return Index", "I:ETFCOMPTR": "ISE ETF Composite Total Return Index", "I:ETH100RP": "Cboe 100 Ethereum / USD RealPrice", "I:ETH200RP": "Cboe 200 Ethereum / USD RealPrice", "I:ETH20RP": "Cboe 20 Ethereum / USD RealPrice", "I:ETH400RP": "Cboe 400 Ethereum / USD RealPrice", "I:ETH50RP": "Cboe 50 Ethereum / USD RealPrice", "I:ETH5RP": "Cboe 5 Ethereum / USD RealPrice", "I:ETHBTC": "Ether vs Bitcoin", "I:ETHUSD": "Ether vs US Dollar", "I:ETI": "ISE ETF 50 Index", "I:ETIN": "ISE ETF 50 Net Total Return Index", "I:ETIT": "ISE ETF 50 Total Return Index", "I:ETT": "Morgan Stanley STARS-Cboe S&P 500 BuyWrite Index", "I:EUDVIV": "PROSHARES MSCI EUROPE DIVIDEND GROWERS ETF", "I:EUMIV": "PROSHARES SHORT MSCI EMERGING MARKETS ETF", "I:EUOIV": "PROSHARES ULTRASHORT EURO ETF", "I:EVZ": "Cboe EuroCurrency Volatility Index", "I:EWVIV": "PROSHARES ULTRASHORT MSCI JAPAN ETF", "I:EZJIV": "PROSHARES ULTRA MSCI JAPAN ETF", "I:FAUGIV": "FT Cboe Vest U.S. Equity Buffer ETF - August Intraday Indicative Value", "I:FDSESPR": "FactSet Global Extended Space Price Return Index", "I:FDSESTR": "FactSet Global Extended Space Total Return Index", "I:FDSFTPR": "FactSet Global FinTech PR Index", "I:FDSFTPRJPY": "GLOBAL FINTECH JAPAN HEDGED INDEX PRICE RETURN VAL", "I:FDSFTTR": "FactSet Global FinTech Total Return Index", "I:FDSFTTRJPY": "GLOBAL FINTECH JAPAN HEDGED INDEX TOTAL RETURN", "I:FDSMBPR": "FactSet Global Mobility Price Return Index", "I:FDSMBTR": "FACTSET GLOBAL MOBILITY TOTAL RETURN INDEX", "I:FEBTIV": "AllianzIM U.S. Large Cap Buffer10 Feb ETF Intraday Indicative Value", "I:FEBWIV": "AllianzIM U.S. Large Cap Buffer20 Feb ETF Intraday Indicative Value", "I:FEBZIV": "TrueShares Structured Outcome (February) ETF Intraday Indicative Value", "I:FFEBIV": "FT Cboe Vest U.S. Equity Buffer ETF - February Intraday Indicative Value", "I:FGLDIV": "FRANKLIN RESPONSIBLY SOURCED GOLD ETF", "I:FIDOW": "Dow Jones Finland Index", "I:FIDOWD": "Dow Jones Finland Index (USD)", "I:FIL100RP": "Cboe 100 Filecoin / US Dollar RealPrice Index", "I:FIL1KRP": "Cboe 1000 Filecoin / US Dollar RealPrice Index", "I:FIL2500": "Cboe 2500 Filecoin / US Dollar RealPrice Index", "I:FIL500RP": "Cboe 500 Filecoin / US Dollar RealPrice Index", "I:FIL5KRP": "Cboe 5000 Filecoin / US Dollar RealPrice Index", "I:FIRSTNORTHDKK": "First North All-Share DKK", "I:FIRSTNORTHEUR": "First North All-Share EUR", "I:FIRSTNORTHISK": "First North All-Share ISK", "I:FIRSTNORTHNOK": "First North All-Share NOK", "I:FIRSTNORTHSEK": "First North All-Share SEK", "I:FJULIV": "FT Cboe Vest U.S. Equity Buffer ETF July Intraday Indicative Value", "I:FJUNIV": "FT Cboe Vest U.S. Equity Buffer ETF June Intraday Indicative Value", "I:FMAYIV": "FT Cboe Vest U.S. Equity Buffer ETF May Intraday Indicative Value", "I:FN10GI": "First North Technology GI", "I:FN10PI": "First North Technology PI", "I:FN15GI": "First North Telecommunications GI", "I:FN15PI": "First North Telecommunications PI", "I:FN20GI": "First North Health Care GI", "I:FN20PI": "First North Health Care PI", "I:FN25": "First North 25", "I:FN25GI": "First North 25 GI", "I:FN30GI": "First North Financials GI", "I:FN30PI": "First North Financials PI", "I:FN35GI": "First North Real Estate GI", "I:FN35PI": "First North Real Estate PI", "I:FN40GI": "First North Consumer Discretionary GI", "I:FN40PI": "First North Consumer Discretionary PI", "I:FN45GI": "First North Consumer Staples GI", "I:FN45PI": "First North Consumer Staples PI", "I:FN50GI": "First North Industrials GI", "I:FN50PI": "First North Industrials PI", "I:FN55GI": "First North Basic Materials GI", "I:FN55PI": "First North Basic Materials PI", "I:FN60GI": "First North Energy GI", "I:FN60PI": "First North Energy PI", "I:FN65GI": "First North Utilities GI", "I:FN65PI": "First North Utilities PI", "I:FNDKDKKGI": "First North Denmark DKK GI", "I:FNDKDKKPI": "First North Denmark DKK PI", "I:FNDKEURGI": "First North Denmark EUR GI", "I:FNDKEURPI": "First North Denmark EUR PI", "I:FNFIEURGI": "First North Finland EUR GI", "I:FNFIEURPI": "First North Finland EUR PI", "I:FNISEURGI": "First North Iceland EUR GI", "I:FNISEURPI": "First North Iceland EUR PI", "I:FNISISKGI": "First North Iceland ISK GI", "I:FNISISKPI": "First North Iceland ISK PI", "I:FNOVIV": "FT Cboe Vest U.S. Equity Buffer ETF - November Intraday Indicative Value", "I:FNSEEURGI": "First North Sweden EUR GI", "I:FNSEEURPI": "First North Sweden EUR PI", "I:FNSESEKGI": "First North Sweden SEK GI", "I:FNSESEKPI": "First North Sweden SEK PI", "I:FOCTIV": "FT Cboe Vest U.S. Equity Buffer ETF October Intraday Indicative Value", "I:FR30": "Dow Jones France Titans 30 Index (EUR)", "I:FR30D": "Dow Jones France Titans 30 Index (USD)", "I:FRDOW": "Dow Jones France Index", "I:FRDOWD": "Dow Jones France Index (USD)", "I:FSEPIV": "FT Cboe Vest U.S. Equity Buffer ETF September Intraday Indicative Value", "I:FUM": "ISE-Revere Natural Gas Index", "I:FUMNTR": "ISE-Revere Natural Gas Net Total Return Index", "I:FUMTR": "ISE-Revere Natural Gas Total Return Index", "I:FVX": "Cboe 5 Year Treasury Yield Index", "I:FXPIV": "PROSHARES ULTRASHORT FTSE CHINA 50 ETF", "I:GAMMA": "Realized Volatility Index", "I:GBDOW": "Dow Jones U.K. Index", "I:GBDOWD": "Dow Jones U.K. Index (USD)", "I:GBKX": "KBW Nasdaq Global Bank Index", "I:GBKXN": "KBW Nasdaq Global Bank Net Total Return Index", "I:GBKXT": "KBW Nasdaq Global Bank Total Return Index", "I:GDOW": "The Global Dow (USD)", "I:GDOWE": "The Global Dow (EUR)", "I:GGINC": "Nasdaq Clean Edge Global Green Income Index", "I:GGINCN": "Nasdaq Clean Edge Global Green Income Index NTR", "I:GGINCT": "Nasdaq Clean Edge Global Green Income Index TR", "I:GLDBUF": "Cboe Gold 10% (-5% to -15%) Buffer Protect Index", "I:GLDPRO": "Cboe Gold 10% Buffer Protect Index Balanced Series", "I:GLDPRO01": "Cboe Gold 10% Buffer Protect Index January Series", "I:GLDPRO02": "Cboe Gold 10% Buffer Protect Index February Series", "I:GLDPRO03": "Cboe Gold 10% Buffer Protect Index March Series", "I:GLDPRO04": "Cboe Gold 10% Buffer Protect Index April Series", "I:GLDPRO05": "Cboe Gold 10% Buffer Protect Index May Series", "I:GLDPRO06": "Cboe Gold 10% Buffer Protect Index June Series", "I:GLDPRO07": "Cboe Gold 10% Buffer Protect Index July Series", "I:GLDPRO08": "Cboe Gold 10% Buffer Protect Index August Series", "I:GLDPRO09": "Cboe Gold 10% Buffer Protect Index September Series", "I:GLDPRO10": "Cboe Gold 10% Buffer Protect Index October Series", "I:GLDPRO11": "Cboe Gold 10% Buffer Protect Index November Series", "I:GLDPRO12": "Cboe Gold 10%  Buffer Protect Index December Series", "I:GLDTI": "Cboe Gold Target Income Index Monthly Series", "I:GLLIV": "PROSHARES ULTRASHORT GOLD ETF", "I:GNDX": "IPOX Growth Infusion Index", "I:GRDOW": "Dow Jones Greece Index (EUR)", "I:GRDOWD": "Dow Jones Greece Index (USD)", "I:GREENIT": "NASDAQ OMX Green IT", "I:GREENITX": "NASDAQ OMX Green IT Total Return", "I:GRNAM": "NASDAQ OMX Advanced Materials", "I:GRNAMX": "NASDAQ OMX Advanced Materials Total Return", "I:GRNASIA": "NASDAQ OMX Green Economy Asia USD", "I:GRNASIAX": "NASDAQ OMX Green Economy Asia USD Total Return", "I:GRNBIO": "NASDAQ OMX Bio/Clean Fuels", "I:GRNBIOX": "NASDAQ OMX Bio/Clean Fuels Total Return", "I:GRNCLNFO": "NASDAQ OMX Clean Energy Focused", "I:GRNCLNFOX": "NASDAQ OMX Clean Energy Focused Total Return", "I:GRNDO": "NASDAQ OMX Developer/Operator", "I:GRNDOX": "NASDAQ OMX Developer/Operator Total Return", "I:GRNENEF": "NASDAQ OMX Energy Efficiency Index", "I:GRNENEFX": "NASDAQ OMX Energy Efficiency Total Return", "I:GRNEUROPE": "NASDAQ OMX Green Economy Europe USD", "I:GRNEUROPEX": "NASDAQ OMX Green Economy Europe USD Total Return", "I:GRNEXUS": "NASDAQ OMX Green Economy ex-US USD", "I:GRNEXUSX": "NASDAQ OMX Green Economy ex-US USD Total Return", "I:GRNFCEXUS": "NASDAQ OMX Clean Energy Focused ex-US USD", "I:GRNFCEXUSX": "NASDAQ OMX Clean Energy Focused ex-US USD Ttl Ret", "I:GRNFOCAS": "NASDAQ OMX Clean Energy Focused Asia USD", "I:GRNFOCASX": "NASDAQ OMX Clean Energy Focused Asia USD Total Ret", "I:GRNFOCEUR": "NASDAQ OMX Clean Energy Focused Europe USD", "I:GRNFOCEURX": "NASDAQ OMX Clean Energy Focused Europe USD Ttl Ret", "I:GRNFOCUS": "NASDAQ OMX Clean Energy Focused US", "I:GRNFOCUSX": "NASDAQ OMX Clean Energy Focused US Total Return", "I:GRNFUEL": "NASDAQ OMX Fuel Cell", "I:GRNFUELX": "NASDAQ OMX Fuel Cell Total Return", "I:GRNGB": "NASDAQ OMX Green Building", "I:GRNGBX": "NASDAQ OMX Green Building Total Return", "I:GRNGEO": "NASDAQ OMX Geothermal", "I:GRNGEOX": "NASDAQ OMX Geothermal Total Return", "I:GRNGRD": "NASDAQ OMX Smart Grid", "I:GRNGRDX": "NASDAQ OMX Smart Grid Total Return", "I:GRNHL": "NASDAQ OMX Healthy Living", "I:GRNHLX": "NASDAQ OMX Healthy Living Total Return", "I:GRNLIGHT": "NASDAQ OMX Lighting", "I:GRNLIGHTX": "NASDAQ OMX Lighting Total Return", "I:GRNMAN": "NASDAQ OMX Energy Management", "I:GRNMANX": "NASDAQ OMX Energy Management Total Return", "I:GRNNR": "NASDAQ OMX Natural Resources", "I:GRNNRX": "NASDAQ OMX Natural Resources Total Return", "I:GRNPOL": "NASDAQ OMX Pollution Mitigation", "I:GRNPOLX": "NASDAQ OMX Pollution Mitigation Total Return", "I:GRNREC": "NASDAQ OMX Recycling", "I:GRNRECX": "NASDAQ OMX Recycling Total Return", "I:GRNREG": "NASDAQ OMX Renewable Energy Generation", "I:GRNREGX": "NASDAQ OMX Renewable Energy Generation Total Rtn", "I:GRNSOLAR": "NASDAQ OMX Solar", "I:GRNSOLARX": "NASDAQ OMX Solar Total Return", "I:GRNSTOR": "NASDAQ OMX Energy Storage", "I:GRNSTORX": "NASDAQ OMX Energy Storage Total Return", "I:GRNTRN": "NASDAQ OMX Green Transportation", "I:GRNTRNX": "NASDAQ OMX Green Transportation Total Return", "I:GRNUS": "NASDAQ OMX Green Economy US", "I:GRNUSX": "NASDAQ OMX Green Economy US Total Return", "I:GRNWATER": "NASDAQ OMX Water", "I:GRNWATERL": "NASDAQ OMX Global Water", "I:GRNWATERLEUR": "NASDAQ OMX Global Water EUR Index", "I:GRNWATERLEURNNR": "NASDAQ OMX Global Water EUR Notional NetTotal Retu", "I:GRNWATERLEURX": "NASDAQ OMX Global Water EUR Total Return Index", "I:GRNWATERLNNR": "NASDAQ OMX Global Water Notional NetTotal Return I", "I:GRNWATERLX": "NASDAQ OMX Global Water Total Return", "I:GRNWATERX": "NASDAQ OMX Water Total Return", "I:GRNWATUSL": "NASDAQ OMX US Water", "I:GRNWATUSLN": "Nasdaq OMX US Water Net Total Return Index", "I:GRNWATUSLX": "NASDAQ OMX US Water Total Return", "I:GRNWIND": "NASDAQ OMX Wind", "I:GRNWINDX": "NASDAQ OMX Wind Total Return", "I:GSOX": "Nasdaq Global Semiconductor Index", "I:GSOXNR": "Nasdaq Global Semiconductor Net Total Return Index", "I:GSOXTR": "Nasdaq Global Semiconductor Total Return Index", "I:GVZ": "Cboe Gold ETF Volatility Index", "I:GWE": "ISE Clean Edge Global Wind Energy Index", "I:GWENTR": "ISE Clean Edge Global Wind Energy Net Total Return", "I:GWETR": "ISE Clean Edge Global Wind Energy Total Return Ind","I:HDGIV": "PROSHARES HEDGE REPLICATION ETF", "I:HEGDIV": "Swan Hedged Equity US Large Cap ETF Intraday Indicative Value", "I:HERBAL": "Nasdaq CRB Monitor Global Cannabis Index", "I:HERBALAU": "Nasdaq CRB Monitor Global Cannabis AUD Index", "I:HERBALAUNR": "Nasdaq CRB Monitor Global Cannabis Net Total Return AUD Index", "I:HERBALAUTR": "Nasdaq CRB Monitor Global Cannabis Gross Total Return AUD Index", "I:HERBALNR": "Nasdaq CRB Monitor Global Cannabis Net Total Return Index", "I:HERBALTR": "Nasdaq CRB Monitor Global Cannabis Gross Total Return Index", "I:HGX": "PHLX Housing Sector", "I:HHO": "ISE Clean Edge Water Index", "I:HHONTR": "ISE Clean Edge Water Net Total Return Index", "I:HHOTR": "ISE Clean Edge Water Total Return Index", "I:HKDOWD": "Dow Jones Hong Kong Index (USD)", "I:HUR": "ISE Cyber Security UCITS Index", "I:HURNTR": "ISE Cyber Security UCITS Net Total Return Index", "I:HURTR": "ISE Cyber Security UCITS Total Return Index", "I:HX101010GI": "OMX Helsinki Software and Computer Services GI", "I:HX101010PI": "OMX Helsinki Software and Computer Services PI", "I:HX101020GI": "OMX Helsinki Technology Hardware and Equipment GI", "I:HX101020PI": "OMX Helsinki Technology Hardware and Equipment PI", "I:HX10GI": "OMX Helsinki Technology GI", "I:HX10PI": "OMX Helsinki Technology PI", "I:HX151010GI": "OMX Helsinki Telecommunications Equipment GI", "I:HX151010PI": "OMX Helsinki Telecommunications Equipment PI", "I:HX151020GI": "OMX Helsinki Telecommunications Service Providers GI", "I:HX151020PI": "OMX Helsinki Telecommunications Service Providers PI", "I:HX15GI": "OMX Helsinki Telecommunications GI", "I:HX15PI": "OMX Helsinki Telecommunications PI", "I:HX201010GI": "OMX Helsinki Health Care Providers GI", "I:HX201010PI": "OMX Helsinki Health Care Providers PI", "I:HX201020GI": "OMX Helsinki Medical Equipment and Services GI", "I:HX201020PI": "OMX Helsinki Medical Equipment and Services PI", "I:HX201030GI": "OMX Helsinki Pharmaceuticals and Biotechnology GI", "I:HX201030PI": "OMX Helsinki Pharmaceuticals and Biotechnology PI", "I:HX20GI": "OMX Helsinki Health Care GI", "I:HX20PI": "OMX Helsinki Health Care PI", "I:HX3010GI": "OMX Helsinki Banks GI", "I:HX3010PI": "OMX Helsinki Banks PI", "I:HX302010GI": "OMX Helsinki Finance and Credit Services GI", "I:HX302010PI": "OMX Helsinki Finance and Credit Services PI", "I:HX302020GI": "OMX Helsinki Investment Banking and Brokerage Services  GI", "I:HX302020PI": "OMX Helsinki Investment Banking and Brokerage Services  PI", "I:HX3020GI": "OMX Helsinki Financial Services GI", "I:HX3020PI": "OMX Helsinki Financial Services PI", "I:HX303020GI": "OMX Helsinki Non-life Insurance GI", "I:HX303020PI": "OMX Helsinki Non-life Insurance PI", "I:HX3030GI": "OMX Helsinki Insurance GI", "I:HX3030PI": "OMX Helsinki Insurance PI", "I:HX30GI": "OMX Helsinki Financials GI", "I:HX30PI": "OMX Helsinki Financials PI", "I:HX351010GI": "OMX Helsinki Real Estate Investment and Services GI", "I:HX351010PI": "OMX Helsinki Real Estate Investment and Services PI", "I:HX35GI": "OMX Helsinki Real Estate GI", "I:HX35PI": "OMX Helsinki Real Estate PI", "I:HX4010GI": "OMX Helsinki Automobiles and Parts GI", "I:HX4010PI": "OMX Helsinki Automobiles and Parts PI", "I:HX402020GI": "OMX Helsinki Household Goods and Home Construction GI", "I:HX402020PI": "OMX Helsinki Household Goods and Home Construction PI", "I:HX402030GI": "OMX Helsinki Leisure Goods GI", "I:HX402030PI": "OMX Helsinki Leisure Goods PI", "I:HX402040GI": "OMX Helsinki Personal Goods GI", "I:HX402040PI": "OMX Helsinki Personal Goods PI", "I:HX4020GI": "OMX Helsinki Consumer Products and Services GI", "I:HX4020PI": "OMX Helsinki Consumer Products and Services PI", "I:HX4030GI": "OMX Helsinki Media GI", "I:HX4030PI": "OMX Helsinki Media PI", "I:HX404010GI": "OMX Helsinki Retailers GI", "I:HX404010PI": "OMX Helsinki Retailers PI", "I:HX4040GI": "OMX Helsinki Retail GI", "I:HX4040PI": "OMX Helsinki Retail PI", "I:HX4050GI": "OMX Helsinki Travel and Leisure GI", "I:HX4050PI": "OMX Helsinki Travel and Leisure PI", "I:HX40GI": "OMX Helsinki Consumer Discretionary GI", "I:HX40PI": "OMX Helsinki Consumer Discretionary PI", "I:HX451010GI": "OMX Helsinki Beverages GI", "I:HX451010PI": "OMX Helsinki Beverages PI", "I:HX451020GI": "OMX Helsinki Food Producers GI", "I:HX451020PI": "OMX Helsinki Food Producers PI", "I:HX4510GI": "OMX Helsinki Food, Beverage and Tobacco  GI", "I:HX4510PI": "OMX Helsinki Food, Beverage and Tobacco  PI", "I:HX4520GI": "OMX Helsinki Personal Care, Drug and Grocery Stores GI", "I:HX4520PI": "OMX Helsinki Personal Care, Drug and Grocery Stores PI", "I:HX45GI": "OMX Helsinki Consumer Staples GI", "I:HX45PI": "OMX Helsinki Consumer Staples PI", "I:HX5010GI": "OMX Helsinki Construction and Materials GI", "I:HX5010PI": "OMX Helsinki Construction and Materials PI", "I:HX502020GI": "OMX Helsinki Electronic and Electrical Equipment GI", "I:HX502020PI": "OMX Helsinki Electronic and Electrical Equipment PI", "I:HX502030GI": "OMX Helsinki General Industrials GI", "I:HX502030PI": "OMX Helsinki General Industrials PI", "I:HX502040GI": "OMX Helsinki Industrial Engineering GI", "I:HX502040PI": "OMX Helsinki Industrial Engineering PI", "I:HX502050GI": "OMX Helsinki Industrial Support Services GI", "I:HX502050PI": "OMX Helsinki Industrial Support Services PI", "I:HX502060GI": "OMX Helsinki Industrial Transportation GI", "I:HX502060PI": "OMX Helsinki Industrial Transportation PI", "I:HX5020GI": "OMX Helsinki Industrial Goods and Services GI", "I:HX5020PI": "OMX Helsinki Industrial Goods and Services PI", "I:HX50GI": "OMX Helsinki Industrials GI", "I:HX50PI": "OMX Helsinki Industrials PI", "I:HX551010GI": "OMX Helsinki Industrial Materials GI", "I:HX551010PI": "OMX Helsinki Industrial Materials PI", "I:HX551020GI": "OMX Helsinki Industrial Metals and Mining GI", "I:HX551020PI": "OMX Helsinki Industrial Metals and Mining PI", "I:HX551030GI": "OMX Helsinki Precious Metals and Mining GI", "I:HX551030PI": "OMX Helsinki Precious Metals and Mining PI", "I:HX5510GI": "OMX Helsinki Basic Resources GI", "I:HX5510PI": "OMX Helsinki Basic Resources PI", "I:HX5520GI": "OMX Helsinki Chemicals GI", "I:HX5520PI": "OMX Helsinki Chemicals PI", "I:HX55GI": "OMX Helsinki Basic Materials GI", "I:HX55PI": "OMX Helsinki Basic Materials PI", "I:HX601010GI": "OMX Helsinki Oil, Gas and Coal GI", "I:HX601010PI": "OMX Helsinki Oil, Gas and Coal PI", "I:HX60GI": "OMX Helsinki Energy GI", "I:HX60PI": "OMX Helsinki Energy PI", "I:HX651010GI": "OMX Helsinki Electricity GI", "I:HX651010PI": "OMX Helsinki Electricity PI", "I:HX651030GI": "OMX Helsinki Waste and Disposal Services GI", "I:HX651030PI": "OMX Helsinki Waste and Disposal Services PI", "I:HX65GI": "OMX Helsinki Utilities GI", "I:HX65PI": "OMX Helsinki Utilities PI", "I:HXC": "NASDAQ Golden Dragon China Index", "I:HXCNTR": "NASDAQ Golden Dragon China Net Total Return Index", "I:HXCX": "NASDAQ Golden Dragon China Total Return Index", "I:HXR": "ISE Cyber Security Index", "I:HXRNTR": "ISE Cyber Security Net Total Return Index", "I:HXRTR": "ISE Cyber Security Total Return Index", "I:HYGWIV": "iShares HY Corp Bond BuyWrite Strategy ETF Intraday Indicative Value", "I:HYHGIV": "PROSHARES HIGH YIELD-INTEREST RATE HEDGED ETF", "I:IBHY": "iBoxx iShares USD High Yield Corporate Bond Index", "I:IBIG": "iBoxx iShares USD Investment Grade Corporate Bond Index", "I:ICDX": "IPOX Canada Index", "I:ICK": "ISE ChIndia Index", "I:ICKNTR": "ISE ChIndia Net Total Return Index", "I:ICKTR": "ISE ChIndia Total Return Index", "I:IDB50N": "IDB IndexAmericas 50 Net Total Return Index", "I:IDBTVER": "IDB IndexAmericas 50 Stability Excess Return Index", "I:IDDOW": "Dow Jones Indonesia Index", "I:IDDOWD": "Dow Jones Indonesia Index (USD)", "I:IEDOW": "Dow Jones Ireland Index", "I:IEDOWD": "Dow Jones Ireland Index (USD)", "I:IGHGIV": "PROSHARES INV GRADE-INTEREST RATE HEDGED", "I:IMUS": "Dow Jones Islamic Market U.S. Index", "I:IMUSL": "Dow Jones Islamic Market U.S. Large-Cap Index", "I:IMUSM": "Dow Jones Islamic Market U.S. Mid-Cap Index", "I:IMUSS": "Dow Jones Islamic Market U.S. Small-Cap Index", "I:IMXL": "Dow Jones Islamic Market Titans 100 Index", "I:INDS": "Nasdaq Industrial", "I:INDSSCNR": "Kelly Industrial Real Estate Net Total Return Inde", "I:INDSSCPR": "Kelly Industrial Real Estate Index", "I:INDSSCTR": "Kelly Industrial Real Estate Total Return Index", "I:INSR": "Nasdaq Insurance", "I:INW": "Horizon Kinetics ISE International Wealth Index", "I:INWNTR": "Horizon Kinetics ISE International Wealth NTR", "I:INWTR": "Horizon Kinetics ISE International Wealth TR Index", "I:IONIV": "PROSHARES TR S&P GLOBAL CORE BATTERY", "I:IPY": "ISE Mobile Payments Index", "I:IPYNTR": "ISE Mobile Payments Net Total Return Index", "I:IPYTR": "ISE Mobile Payments Total Return Index", "I:IRX": "Cboe Short-Term Interest Rate Index", "I:ISWNXT": "S-Network International BlackSwan Index", "I:IT30": "Dow Jones Italy Titans 30 Index (EUR)", "I:IT30D": "Dow Jones Italy Titans 30 Index (USD)", "I:ITDOW": "Dow Jones Italy Index", "I:ITDOWD": "Dow Jones Italy Index (USD)","I:IX10GI": "OMX Iceland Technology GI", "I:IX10PI": "OMX Iceland Technology PI", "I:IX15GI": "OMX Iceland Telecommunications GI", "I:IX15PI": "OMX Iceland Telecommunications PI", "I:IX20GI": "OMX Iceland Health Care GI", "I:IX20PI": "OMX Iceland Health Care PI", "I:IX30GI": "OMX Iceland Financials GI", "I:IX30PI": "OMX Iceland Financials PI", "I:IX35GI": "OMX Iceland Real Estate GI", "I:IX35PI": "OMX Iceland Real Estate PI", "I:IX40GI": "OMX Iceland Consumer Discretionary GI", "I:IX40PI": "OMX Iceland Consumer Discretionary PI", "I:IX45GI": "OMX Iceland Consumer Staples GI", "I:IX45PI": "OMX Iceland Consumer Staples PI", "I:IX50GI": "OMX Iceland Industrials GI", "I:IX50PI": "OMX Iceland Industrials PI", "I:IX60GI": "OMX Iceland Energy GI", "I:IX60PI": "OMX Iceland Energy PI", "I:IXBI": "ixBitcoin Index", "I:IXCI": "ixCrypto Index", "I:IXCO": "Nasdaq Computer", "I:IXEI": "ixEthereum Index", "I:IXF": "NASDAQ Financial 100", "I:IXFTR": "NASDAQ Financial 100 Total Return Index", "I:IXHC": "Nasdaq Health Care", "I:IXTC": "Nasdaq Telecommunications", "I:JANTIV": "AllianzIM U.S. Large Cap Buffer10 Jan ETF Intraday Indicative Value", "I:JANWIV": "AllianzIM U.S. Large Cap Buffer20 Jan ETF Intraday Indicative Value", "I:JANZIV": "TrueShares Structured Outcome (January) ETF Intraday Indicative Value", "I:JPDOW": "Dow Jones Japan Index", "I:JPDOWD": "Dow Jones Japan Index (USD)", "I:JULTIV": "AllianzIM U.S. Large Cap Buffer10 Jul ETF Intraday Indicative Value", "I:JULWIV": "AllianzIM U.S. Large Cap Buffer20 Jul ETF Intraday Indicative Value", "I:JULZIV": "TrueShares Structured Outcome (July) ETF Intraday Indicative Value","I:JUNZIV": "TrueShares Structured Outcome (June) ETF Intraday Indicative Value", "I:KDX": "KBW Nasdaq Financial Sector Dividend Yield Index", "I:KDXTR": "KBW Nasdaq Financial Sector Dividend Yield TR Inde", "I:KFTX": "KBW Nasdaq Financial Technology Index", "I:KFTXNNR70": "KBW Nasdaq Financial Technology NNR 70 Index", "I:KFTXNNR85": "KBW Nasdaq Financial Technology NNR 85 Index", "I:KFTXT": "KBW Nasdaq Financial Technology TR Index", "I:KIX": "KBW Nasdaq Insurance Index", "I:KIXTR": "KBW Nasdaq Insurance Total Return Index", "I:KNC100RP": "Cboe 100 Kyber Network / US Dollar RealPrice Index", "I:KNC1KRP": "Cboe 1000 Kyber Network / US Dollar RealPrice Index", "I:KNC250RP": "Cboe 250 Kyber Network / US Dollar RealPrice Index", "I:KNC2KRP": "Cboe 2000 Kyber Network / US Dollar RealPrice Index", "I:KNC500RP": "Cboe 500 Kyber Network / US Dollar RealPrice Index", "I:KOLDIV": "PROSHARES ULTRASHORT BBG NATURAL GAS ETF", "I:KPX": "KBW Nasdaq Property & Casualty Index", "I:KPXTR": "KBW Nasdaq Property & Casualty Total Return Index", "I:KR30": "Dow Jones South Korea Titans 30 Index (KRW)", "I:KR30D": "Dow Jones South Korea Titans 30 Index (USD)", "I:KR30DT": "Dow Jones South Korea Titans 30 Total Return Index (USD)", "I:KRDOW": "Dow Jones South Korea Index", "I:KRDOWD": "Dow Jones South Korea Index (USD)", "I:KRX": "KBW Nasdaq Regional Banking Index", "I:KRXTR": "KBW Nasdaq Regional Banking Total Return Index", "I:KSX": "KBW Nasdaq Capital Markets Index", "I:KSXTR": "KBW Nasdaq Capital Markets Total Return Index", "I:KYX": "KBW Nasdaq Premium Yield Equity REIT Index", "I:KYXTR": "KBW Nasdaq Premium Yield Equity REIT TR Index", "I:LATMTI": "Nasdaq CTA Latin American Technology Innovators Index", "I:LATMTIBRL": "Nasdaq CTA Latin American Technology Innovators BRL Index", "I:LATMTIBRLN": "Nasdaq CTA Latin American Technology Innovators Net Total Return BRL Index", "I:LATMTIBRLT": "Nasdaq CTA Latin American Technology Innovators Total Return BRL Index", "I:LATMTIN": "Nasdaq CTA Latin American Technology Innovators Net Total Return Index", "I:LATMTIT": "Nasdaq CTA Latin American Technology Innovators Total Return Index", "I:LCFIV": "Touchstone US Large Cap Focused ETF", "I:LINK100": "Cboe 100 Chainlink / USD RealPrice", "I:LINK1KRP": "Cboe 1000 Chainlink / USD RealPrice", "I:LINK2500": "Cboe 2500 Chainlink / US Dollar RealPrice Index", "I:LINK500": "Cboe 500 Chainlink / USD RealPrice", "I:LINK5KRP": "Cboe 5000 Chainlink / US Dollar RealPrice Index", "I:LONGVOL": "Long VIX Futures Index", "I:LOVOL": "Cboe Low Volatility Index", "I:LQDWIV": "iShares IG Corp Bond BuyWrite Strategy ETF Intraday Indicative Value", "I:LTACQG": "Linden Thomas US Equity All-Cap Quality Growth 150 Index", "I:LTACQGN": "Linden Thomas US Equity All-Cap Quality Growth 150 Net Total Return Index", "I:LTACQGT": "Linden Thomas US Equity All-Cap Quality Growth 150 Total Return Index", "I:LTC100RP": "Cboe 100 Litecoin / USD RealPrice", "I:LTC10RP": "Cboe 10 Litecoin / USD RealPrice", "I:LTC200RP": "Cboe 200 Litecoin / USD RealPrice", "I:LTC25RP": "Cboe 25 Litecoin / USD RealPrice", "I:LTC50RP": "Cboe 50 Litecoin / USD RealPrice", "I:LTC5RP": "Cboe 5 Litecoin / USD RealPrice", "I:LTCBTC": "Litecoin vs Bitcoin", "I:LTCUSD": "Litecoin vs US Dollar", "I:LTLIV": "PROSHARES ULTRA TELECOMMUNICATIONS ETF", "I:LTQDLX": "Linden Thomas Quality Dividends US Large-Cap Index", "I:LTQDLXN": "Linden Thomas Quality Dividends US Large-Cap Net Total Return Index", "I:LTQDLXT": "Linden Thomas Quality Dividends US Large-Cap Total Return Index", "I:LTQDMX": "Linden Thomas Quality Dividends US Mid-Cap Index", "I:LTQDMXN": "Linden Thomas Quality Dividends US Mid-Cap Net Total Return Index", "I:LTQDMXT": "Linden Thomas Quality Dividends US Mid-Cap Total Return Index", "I:LTQDSX": "Linden Thomas Quality Dividends US Small-Cap Index", "I:LTQDSXN": "Linden Thomas Quality Dividends US Small-Cap Net Total Return Index", "I:LTQDSXT": "Linden Thomas Quality Dividends US Small-Cap Total Return Index", "I:LUNTFCNR": "Lunt Capital Large Cap Factor Rotation NTR Index", "I:LUNTFCPR": "Lunt Capital Large Cap Factor Rotation Index", "I:LUNTFCTR": "Lunt Capital Large Cap Factor Rotation TR Index", "I:LVDA": "Nasdaq US Low Volatility Dividend Achievers Index", "I:LVDAKRW": "Nasdaq US Low Volatility Dividend Achievers KRW Index", "I:LVDAKRWN": "Nasdaq US Low Volatility Dividend Achievers KRW Net Total Return Index", "I:LVDAKRWT": "Nasdaq US Low Volatility Dividend Achievers KRW Total Return Index", "I:LVDAN": "Nasdaq US Low Volatility Dividend Achievers Net Total Return Index", "I:LVDAT": "Nasdaq US Low Volatility Dividend Achievers Total Return Index", "I:MAKXIV": "PROSHARES S&P KENSHO SMART FACTORIES ETF", "I:MANA10K": "Cboe 10K Decentraland / US Dollar RealPrice Index", "I:MANA1250": "Cboe 1250 Decentraland / US Dollar RealPrice Index", "I:MANA3KRP": "Cboe 3000 Decentraland / US Dollar RealPrice Index", "I:MANA500": "Cboe 500 Decentraland / US Dollar RealPrice Index","I:MARZIV": "TrueShares Structured Outcome (March) ETF Intraday Indicative Value", "I:MATIC100K": "Cboe 100K Polygon / US Dollar RealPrice Index", "I:MATIC10K": "Cboe 10K Polygon / US Dollar RealPrice Index", "I:MATIC1K": "Cboe 1000 Polygon / US Dollar RealPrice Index", "I:MATIC25K": "Cboe 25K Polygon / US Dollar RealPrice Index", "I:MATIC50K": "Cboe 50K Polygon / US Dollar RealPrice Index","I:MAYZIV": "TrueShares Structured Outcome (May) ETF Intraday Indicative Value", "I:METAL": "Nasdaq Sprott Energy Transition Materials Select Index", "I:METALA": "Nasdaq Sprott Energy Transition Materials Select AUD Index", "I:METALANR": "Nasdaq Sprott Energy Transition Materials Select Net Total Return AUD Index", "I:METALATR": "Nasdaq Sprott Energy Transition Materials Select Total Return AUD Index", "I:METALNR": "Nasdaq Sprott Energy Transition Materials Select Net Total Return Index", "I:METALTR": "Nasdaq Sprott Energy Transition Materials Select Total Return Index", "I:MINERS": "The S-Network MicroSectors Gold Miners Total Return Index (USD)", "I:MINERSV": "The S-Network MicroSectors Gold Miners VWAP Index (USD)", "I:MKR10RP": "Cboe 10 Maker / US Dollar RealPrice Index", "I:MKR25RP": "Cboe 25 Maker / US Dollar RealPrice Index", "I:MKR2RP": "Cboe 2 Maker / US Dollar RealPrice Index", "I:MKR50RP": "Cboe 50 Maker / US Dollar RealPrice Index", "I:MKR5RP": "Cboe 5 Maker / US Dollar RealPrice Index", "I:MNV": "Invesco S&P 500 BuyWrite ETF-INAV", "I:MNX1": "Nasdaq-100 Mini Index", "I:MRGRIV": "PROSHARES MERGER ETF", "I:MRLS": "Mini-Russell 2000 Index (AM Settlement)", "I:MRUT": "Mini-Russell 2000 Index", "I:MSDEOGGE": "Morningstar DM Europe Large-Mid Oil and Gas GR EUR", "I:MSDEOGNE": "Morningstar DM Europe Large-Mid Oil and Gas NR EUR", "I:MSDEOGPE": "Morningstar DM Europe Large-Mid Oil and Gas PR EUR", "I:MSEBKSGE": "Morningstar Eurozone Large-Mid Banks GR EUR", "I:MSEBKSNE": "Morningstar Eurozone Large-Mid Banks NR EUR", "I:MSEBKSPE": "Morningstar Eurozone Large-Mid Banks PR EUR", "I:MSV": "Cboe MS U.S. Portfolio Intrinsic Value Basket", "I:MSX": "MS Style Select Japan Index Net Entitlement Value", "I:MUT": "Dow Jones High Yield Select 10 Index (USD)", "I:MUTR": "Dow Jones High Yield Select 10 Index (USD) TR", "I:MVVIV": "PROSHARES ULTRA MIDCAP400 ETF", "I:MXDOW": "Dow Jones Mexico Index", "I:MXDOWD": "Dow Jones Mexico Index (USD)", "I:MXEA": "MSCI EAFE Index", "I:MXEF": "MSCI Emerging Markets Index", "I:MXS": "MXEA Option Settlement Value", "I:MYDOW": "Dow Jones Malaysia Index", "I:MYDOWD": "Dow Jones Malaysia Index (USD)", "I:MYYIV": "PROSHARES SHORT MIDCAP400 ETF", "I:MZZIV": "PROSHARES ULTRASHORT MIDCAP400 ETF", "I:N10EURGI": "N Technology EUR GI", "I:N10EURPI": "N Technology EUR PI", "I:N15EURGI": "N Telecommunications EUR GI", "I:N15EURPI": "N Telecommunications EUR PI", "I:N20EURGI": "N Health Care EUR GI", "I:N20EURPI": "N Health Care EUR PI", "I:N3010EURGI": "N Banks EUR GI", "I:N3010EURPI": "N Banks EUR PI", "I:N3020GI": "N Financial Services EUR GI", "I:N3020PI": "N Financial Services EUR PI", "I:N3030EURGI": "N Insurance EUR GI", "I:N3030EURPI": "N Insurance EUR PI", "I:N30EURGI": "N Financials EUR GI", "I:N30EURPI": "N Financials EUR PI", "I:N35EURGI": "N Real Estate EUR GI", "I:N35EURPI": "N Real Estate EUR PI", "I:N4010EURGI": "N Automobiles and Parts EUR GI", "I:N4010EURPI": "N Automobiles and Parts EUR PI", "I:N4020EURGI": "N Consumer Products and Services EUR GI", "I:N4020EURPI": "N Consumer Products and Services EUR PI", "I:N4030EURGI": "N Media EUR GI", "I:N4030EURPI": "N Media EUR PI", "I:N4040EURGI": "N Retail EUR GI", "I:N4040EURPI": "N Retail EUR PI", "I:N4050EURGI": "N Travel and Leisure EUR GI", "I:N4050EURPI": "N Travel and Leisure EUR PI", "I:N40EURGI": "N Consumer Discretionary EUR GI", "I:N40EURPI": "N Consumer Discretionary EUR PI", "I:N4510EURGI": "N Food, Beverage and Tobacco  EUR GI", "I:N4510EURPI": "N Food, Beverage and Tobacco  EUR PI", "I:N4520GI": "N Personal Care, Drug and Grocery Stores EUR GI", "I:N4520PI": "N Personal Care, Drug and Grocery Stores EUR PI", "I:N45EURGI": "N Consumer Staples EUR GI", "I:N45EURPI": "N Consumer Staples EUR PI", "I:N5010EURGI": "N Construction and Materials EUR GI", "I:N5010EURPI": "N Construction and Materials EUR PI", "I:N5020EURGI": "N Industrial Goods and Services EUR GI", "I:N5020EURPI": "N Industrial Goods and Services EUR PI", "I:N50EURGI": "N Industrials EUR GI", "I:N50EURPI": "N Industrials EUR PI", "I:N5510EURGI": "N Basic Resources EUR GI", "I:N5510EURPI": "N Basic Resources EUR PI", "I:N5520EURGI": "N Chemicals EUR GI", "I:N5520EURPI": "N Chemicals EUR PI", "I:N55EURGI": "N Basic Materials EUR GI", "I:N55EURPI": "N Basic Materials EUR PI", "I:N60EURGI": "N Energy EUR GI", "I:N60EURPI": "N Energy EUR PI", "I:N65EURGI": "N Utilities EUR GI", "I:N65EURPI": "N Utilities EUR PI", "I:NANOS": "Nanos S&P 500 Index", "I:NBI": "NASDAQ Biotechnology", "I:NBIJPY": "NASDAQ Biotechnology JPY", "I:NBIJR": "Nasdaq Junior Biotechnology Index", "I:NCI": "Nasdaq Crypto Index", "I:NCIE": "Nasdaq Crypto Index Europe", "I:NCMETA": "Nasdaq CB Insights UCITS Metaverse Index", "I:NCMETA01": "Nasdaq CB Insights UCITS Metaverse AUD Index", "I:NCMETA02": "Nasdaq CB Insights UCITS Metaverse CAD Index", "I:NCMETA03": "Nasdaq CB Insights UCITS Metaverse CHF Index", "I:NCMETA04": "Nasdaq CB Insights UCITS Metaverse EUR Index", "I:NCMETA05": "Nasdaq CB Insights UCITS Metaverse GBP Index", "I:NCMETA06": "Nasdaq CB Insights UCITS Metaverse HKD Index", "I:NCMETA07": "Nasdaq CB Insights UCITS Metaverse JPY Index", "I:NCMETA11": "Nasdaq CB Insights UCITS Metaverse Total Return AUD Index", "I:NCMETA12": "Nasdaq CB Insights UCITS Metaverse Total Return CAD Index", "I:NCMETA13": "Nasdaq CB Insights UCITS Metaverse Total Return CHF Index", "I:NCMETA14": "Nasdaq CB Insights UCITS Metaverse Total Return EUR Index", "I:NCMETA15": "Nasdaq CB Insights UCITS Metaverse Total Return GBP Index", "I:NCMETA16": "Nasdaq CB Insights UCITS Metaverse Total Return HKD Index","I:NCMETA21": "Nasdaq CB Insights UCITS Metaverse Net Total Return AUD Index", "I:NCMETA22": "Nasdaq CB Insights UCITS Metaverse Net Total Return CAD Index", "I:NCMETA23": "Nasdaq CB Insights UCITS Metaverse Net Total Return CHF Index", "I:NCMETA24": "Nasdaq CB Insights UCITS Metaverse Net Total Return EUR Index", "I:NCMETA25": "Nasdaq CB Insights UCITS Metaverse Net Total Return GBP Index", "I:NCMETA26": "Nasdaq CB Insights UCITS Metaverse Net Total Return HKD Index", "I:NCMETA27": "Nasdaq CB Insights UCITS Metaverse Net Total Return JPY Index", "I:NCMETAN": "Nasdaq CB Insights Metaverse UCITS Net Total Return Index", "I:NCMETAT": "Nasdaq CB Insights Metaverse UCITS Total Return Index", "I:NCMETV": "Nasdaq CB Insights Metaverse Index", "I:NCMETV01": "Nasdaq CB Insights Metaverse AUD Index", "I:NCMETV02": "Nasdaq CB Insights Metaverse CAD Index", "I:NCMETV03": "Nasdaq CB Insights Metaverse CHF Index", "I:NCMETV04": "Nasdaq CB Insights Metaverse EUR Index", "I:NCMETV05": "Nasdaq CB Insights Metaverse GBP Index", "I:NCMETV06": "Nasdaq CB Insights Metaverse HKD Index", "I:NCMETV07": "Nasdaq CB Insights Metaverse JPY Index", "I:NCMETV11": "Nasdaq CB Insights Metaverse Total Return AUD Index", "I:NCMETV12": "Nasdaq CB Insights Metaverse Total Return CAD Index", "I:NCMETV13": "Nasdaq CB Insights Metaverse Total Return CHF Index", "I:NCMETV14": "Nasdaq CB Insights Metaverse Total Return EUR Index", "I:NCMETV15": "Nasdaq CB Insights Metaverse Total Return GBP Index", "I:NCMETV16": "Nasdaq CB Insights Metaverse Total Return HKD Index", "I:NCMETV17": "Nasdaq CB Insights Metaverse Total Return JPY Index", "I:NCMETV21": "Nasdaq CB Insights Metaverse Net Total Return AUD Index", "I:NCMETV22": "Nasdaq CB Insights Metaverse Net Total Return CAD Index", "I:NCMETV23": "Nasdaq CB Insights Metaverse Net Total Return CHF Index", "I:NCMETV24": "Nasdaq CB Insights Metaverse Net Total Return EUR Index", "I:NCMETV25": "Nasdaq CB Insights Metaverse Net Total Return GBP Index", "I:NCMETV26": "Nasdaq CB Insights Metaverse Net Total Return HKD Index", "I:NCMETV27": "Nasdaq CB Insights Metaverse Net Total Return JPY Index", "I:NCMETVN": "Nasdaq CB Insights Metaverse Net Total Return Index", "I:NCMETVT": "Nasdaq CB Insights Metaverse Total Return Index", "I:NCX": "Nasdaq Innovators Completion Cap Index", "I:NCXAUD": "Nasdaq Innovators Completion Cap Index AUD", "I:NCXCAD": "Nasdaq Innovators Completion Cap Index CAD", "I:NCXCHF": "Nasdaq Innovators Completion Cap Index CHF", "I:NCXEUR": "Nasdaq Innovators Completion Cap Index EUR", "I:NCXGBP": "Nasdaq Innovators Completion Cap Index GBP", "I:NCXHKD": "Nasdaq Innovators Completion Cap Index HKD", "I:NCXJPY": "Nasdaq Innovators Completion Cap Index JPY", "I:NCXN": "Nasdaq Innovators Completion Cap Notional Net Total Return Index", "I:NCXNAUD": "Nasdaq Innovators Completion Cap Notional Net Total Return Index AUD", "I:NCXNCAD": "Nasdaq Innovators Completion Cap Notional Net Total Return Index CAD", "I:NCXNCHF": "Nasdaq Innovators Completion Cap Notional Net Total Return Index CHF", "I:NCXNEUR": "Nasdaq Innovators Completion Cap Notional Net Total Return Index EUR", "I:NCXNGBP": "Nasdaq Innovators Completion Cap Notional Net Total Return Index GBP", "I:NCXNHKD": "Nasdaq Innovators Completion Cap Notional Net Total Return Index HKD", "I:NCXNJPY": "Nasdaq Innovators Completion Cap Notional Net Total Return Index JPY", "I:NCXT": "Nasdaq Innovators Completion Cap Total Return Index", "I:NCXTAUD": "Nasdaq Innovators Completion Cap Total Return Index AUD", "I:NCXTCAD": "Nasdaq Innovators Completion Cap Total Return Index CAD", "I:NCXTCHF": "Nasdaq Innovators Completion Cap Total Return Index CHF", "I:NCXTEUR": "Nasdaq Innovators Completion Cap Total Return Index EUR", "I:NCXTGBP": "Nasdaq Innovators Completion Cap Total Return Index GBP", "I:NCXTHKD": "Nasdaq Innovators Completion Cap Total Return Index HKD", "I:NCXTJPY": "Nasdaq Innovators Completion Cap Total Return Index JPY", "I:NDX": "NASDAQ-100", "I:NDXAUD": "Nasdaq-100 Index AUD", "I:NDXAUDMH": "Nasdaq-100 Currency Hedged AUD Index", "I:NDXCAD": "Nasdaq-100 Index CAD", "I:NDXCHF": "Nasdaq-100 Index CHF", "I:NDXCHFMH": "NDXCHF Monthly Currency Hedged", "I:NDXDIV": "NASDAQ-100 Dividend Point Index", "I:NDXDWA": "NASDAQ-100 Dorsey Wright Momentum Index", "I:NDXDWAN": "NASDAQ-100 Dorsey Wright Momentum Notional Net Total Return Index", "I:NDXDWAT": "NASDAQ-100 Dorsey Wright Momentum Total Return Index", "I:NDXE": "NASDAQ-100 Equal Weighted", "I:NDXEAUD": "NASDAQ-100 Equal Weighted AUD Index", "I:NDXEAUDMH": "Nasdaq-100 Equal Weighted Currency Hedged AUD Index", "I:NDXECAD": "NASDAQ-100 Equal Weighted CAD Index", "I:NDXECADMH": "Nasdaq-100 Equal Weighted Currency Hedged CAD Index", "I:NDXECHF": "NASDAQ-100 Equal Weighted CHF Index", "I:NDXECHFMH": "Nasdaq-100 Equal Weighted Currency Hedged CHF Index", "I:NDXEEUR": "NASDAQ-100 Equal Weighted EUR Index", "I:NDXEEURMH": "Nasdaq-100 Equal Weighted Currency Hedged EUR Index", "I:NDXEGBP": "NASDAQ-100 Equal Weighted GBP Index", "I:NDXEGBPMH": "Nasdaq-100 Equal Weighted Currency Hedged GBP Index", "I:NDXEHKD": "NASDAQ-100 Equal Weighted HKD Index", "I:NDXEHKDMH": "Nasdaq-100 Equal Weighted Currency Hedged HKD Index", "I:NDXEJPY": "NASDAQ-100 Equal Weighted JPY Index", "I:NDXEJPYMH": "Nasdaq-100 Equal Weighted Currency Hedged JPY Index", "I:NDXESG": "Nasdaq-100 ESG Index", "I:NDXESG01": "Nasdaq-100 ESG AUD Index", "I:NDXESG02": "Nasdaq-100 ESG CAD Index", "I:NDXESG03": "Nasdaq-100 ESG CHF Index", "I:NDXESG04": "Nasdaq-100 ESG EUR Index", "I:NDXESG05": "Nasdaq-100 ESG GBP Index", "I:NDXESG06": "Nasdaq 100 ESG HKD Index", "I:NDXESG07": "Nasdaq-100 ESG JPY Index", "I:NDXESG11": "Nasdaq-100 ESG Total Return AUD Index", "I:NDXESG12": "Nasdaq-100 ESG Total Return CAD Index", "I:NDXESG13": "Nasdaq-100 ESG Total Return CHF Index", "I:NDXESG14": "Nasdaq-100 ESG Total Return EUR Index", "I:NDXESG15": "Nasdaq-100 ESG Total Return GBP Index", "I:NDXESG16": "Nasdaq-100 ESG Total Return HKD Index", "I:NDXESG17": "Nasdaq-100 ESG Total Return JPY Index", "I:NDXESG21": "Nasdaq-100 ESG Net Notional Total Return AUD Index", "I:NDXESG22": "Nasdaq-100 ESG Net Notional Total Return CAD Index", "I:NDXESG23": "Nasdaq-100 ESG Net Notional Total Return CHF Index", "I:NDXESG24": "Nasdaq-100 ESG Net Notional Total Return EUR Index", "I:NDXESG25": "Nasdaq-100 ESG Net Notional Total Return GBP Index", "I:NDXESG26": "Nasdaq-100 ESG Net Notional Total Return HKD Index", "I:NDXESG27": "Nasdaq-100 ESG Net Notional Total Return JPY Index", "I:NDXESGN": "Nasdaq-100 ESG Notional Net Total Return Index", "I:NDXESGT": "Nasdaq-100 ESG Total Return Index", "I:NDXEUR": "Nasdaq-100 Index EUR", "I:NDXEURMH": "NDXEUR Monthly Currency Hedged", "I:NDXG02MH": "Nasdaq-100 ESG Currency Hedged CAD Index", "I:NDXG12MH": "Nasdaq-100 ESG Total Return Currency Hedged CAD Index", "I:NDXG22MH": "Nasdaq-100 ESG Notional Net Total Return Currency Hedged CAD Index", "I:NDXGBP": "Nasdaq-100 Index GBP", "I:NDXGBPMH": "NDXGBP Monthly Currency Hedged", "I:NDXHKD": "Nasdaq-100 Index HKD", "I:NDXINR": "Nasdaq-100 Index INR", "I:NDXJPY": "Nasdaq-100 Index JPY", "I:NDXJPYMH": "NASDAQ -100 Currency Hedged JPY Index", "I:NDXL": "NASDAQ-100 Leveraged Index", "I:NDXL3": "NASDAQ-100 3x Leveraged Index", "I:NDXNNEE5": "Nasdaq-100 Notional Net Return Euro Excess Return Index", "I:NDXS1": "NASDAQ-100 1x Short Index", "I:NDXS2": "NASDAQ-100 2x Short Index", "I:NDXS3": "NASDAQ-100 3x Inverse Index", "I:NDXT": "NASDAQ-100 Technology Sector","I:NDXT25": "NASDAQ-100 Target 25 Index", "I:NDXT2D": "NASDAQ-100 Technology Sector Synthetic Dividend 2%", "I:NDXTMC": "NASDAQ-100 Technology Sector Market-Cap Weighted Index", "I:NDXTMCNR": "NASDAQ-100 Technology Sector Market-Cap Weighted Notional Net Total Return Index", "I:NDXTMCTR": "NASDAQ-100 Technology Sector Market-Cap Weighted T", "I:NDXTNR": "NASDAQ-100 Technology Sector Net Total Return", "I:NDXTRND": "NASDAQ-100 Trendpilot PR Index", "I:NDXTRND1": "NASDAQ-100 Trendpilot PR Index 1", "I:NDXX": "NASDAQ-100 Ex-Tech Sector", "I:NETLX": "Fundamental Income Net Lease Real Estate Index", "I:NETLXN": "Fundamental Income Net Lease Real Estate NTR Index", "I:NETLXT": "Fundamental Income Net Lease Real Estate TR Index", "I:NETR": "NASDAQ-100 Equal Weighted Total Return", "I:NETRAUD": "NASDAQ-100 Equal Weighted Total Return AUD Index", "I:NETRAUDMH": "Nasdaq-100 Equal Weighted Total Return Currency Hedged AUD Index", "I:NETRCAD": "NASDAQ-100 Equal Weighted Total Return CAD Index", "I:NETRCADMH": "Nasdaq-100 Equal Weighted Total Return Currency Hedged CAD Index", "I:NETRCHF": "NASDAQ-100 Equal Weighted Total Return CHF Index", "I:NETRCHFMH": "Nasdaq-100 Equal Weighted Total Return Currency Hedged CHF Index", "I:NETREUR": "NASDAQ-100 Equal Weighted Total Return EUR Index", "I:NETREURMH": "Nasdaq-100 Equal Weighted Total Return Currency Hedged EUR Index", "I:NETRGBP": "NASDAQ-100 Equal Weighted Total Return GBP Index", "I:NETRGBPMH": "Nasdaq-100 Equal Weighted Total Return Currency Hedged GBP Index", "I:NETRHKD": "NASDAQ-100 Equal Weighted Total Return HKD Index", "I:NETRHKDMH": "Nasdaq-100 Equal Weighted Total Return Currency Hedged HKD Index", "I:NETRJPY": "NASDAQ-100 Equal Weighted Total Return JPY Index", "I:NETRJPYMH": "Nasdaq-100 Equal Weighted Total Return Currency Hedged JPY Index", "I:NETRNNR": "NASDAQ-100 Equal Weighted Net Notional Return Index", "I:NETRNNRAUD": "NASDAQ-100 Equal Weighted Net Notional Return AUD Index", "I:NETRNNRAUDMH": "Nasdaq-100 Equal Weighted Net Notional Return Currency Hedged AUD Index", "I:NETRNNRCAD": "NASDAQ-100 Equal Weighted Net Notional Return CAD Index", "I:NETRNNRCADMH": "Nasdaq-100 Equal Weighted Net Notional Return Currency Hedged CAD Index", "I:NETRNNRCHF": "NASDAQ-100 Equal Weighted Net Notional Return CHF Index", "I:NETRNNRCHFMH": "Nasdaq-100 Equal Weighted Net Notional Return Currency Hedged CHF Index", "I:NETRNNREUR": "NASDAQ-100 Equal Weighted Net Notional Return EUR Index", "I:NETRNNREURMH": "Nasdaq-100 Equal Weighted Net Notional Return Currency Hedged EUR Index", "I:NETRNNRGBP": "NASDAQ-100 Equal Weighted Net Notional Return GBP Index", "I:NETRNNRGBPMH": "Nasdaq-100 Equal Weighted Net Notional Return Currency Hedged GBP Index", "I:NETRNNRHKD": "NASDAQ-100 Equal Weighted Net Notional Return HKD Index", "I:NETRNNRHKDMH": "Nasdaq-100 Equal Weighted Net Notional Return Currency Hedged HKD Index", "I:NETRNNRJPY": "NASDAQ-100 Equal Weighted Net Notional Return JPY Index", "I:NETRNNRJPYMH": "Nasdaq-100 Equal Weighted Net Notional Return Currency Hedged JPY Index", "I:NETX": "Nasdaq CTA Internet Total Return Index", "I:NGX": "Nasdaq Next Generation 100 Index", "I:NGXAUD": "Nasdaq Next Generation 100 Index AUD", "I:NGXCAD": "Nasdaq Next Generation 100 Index CAD", "I:NGXCADMH": "Nasdaq Next Generation 100 Currency Hedged CAD Index", "I:NGXCHF": "Nasdaq Next Generation 100 Index CHF", "I:NGXESG": "Nasdaq Next Generation 100 ESG Index", "I:NGXESG01": "Nasdaq Next Generation 100 ESG AUD Index", "I:NGXESG02": "Nasdaq Next Generation 100 ESG CAD Index", "I:NGXESG03": "Nasdaq Next Generation 100 ESG CHF Index", "I:NGXESG04": "Nasdaq Next Generation 100 ESG EUR Index", "I:NGXESG05": "Nasdaq Next Generation 100 ESG GBP Index", "I:NGXESG06": "Nasdaq Next Generation 100 ESG HKD Index", "I:NGXESG07": "Nasdaq Next Generation 100 ESG JPY Index", "I:NGXESG11": "Nasdaq Next Generation 100 ESG Total Return AUD Index", "I:NGXESG12": "Nasdaq Next Generation 100 ESG Total Return CAD Index", "I:NGXESG13": "Nasdaq Next Generation 100 ESG Total Return CHF Index", "I:NGXESG14": "Nasdaq Next Generation 100 ESG Total Return EUR Index", "I:NGXESG15": "Nasdaq Next Generation 100 ESG Total Return GBP Index", "I:NGXESG16": "Nasdaq Next Generation 100 ESG Total Return HKD Index", "I:NGXESG17": "Nasdaq Next Generation 100 ESG Total Return JPY Index", "I:NGXESG21": "Nasdaq Next Generation 100 ESG Net Notional Total Return AUD Index", "I:NGXESG22": "Nasdaq Next Generation 100 ESG Net Notional Total Return CAD Index", "I:NGXESG23": "Nasdaq Next Generation 100 ESG Net Notional Total Return CHF Index", "I:NGXESG24": "Nasdaq Next Generation 100 ESG Net Notional Total Return EUR Index", "I:NGXESG25": "Nasdaq Next Generation 100 ESG Net Notional Total Return GBP Index", "I:NGXESG26": "Nasdaq Next Generation 100 ESG Net Notional Total Return HKD Index", "I:NGXESG27": "Nasdaq Next Generation 100 ESG Net Notional Total Return JPY Index", "I:NGXESGN": "Nasdaq Next Generation 100 ESG Notional Net Total Return Index", "I:NGXESGT": "Nasdaq Next Generation 100 ESG Total Return Index", "I:NGXEUR": "Nasdaq Next Generation 100 Index EUR", "I:NGXG02MH": "Nasdaq Next Generation 100 ESG Currency Hedged CAD Index", "I:NGXG12MH": "Nasdaq Next Generation 100 ESG Total Return Currency Hedged CAD Index", "I:NGXG22MH": "Nasdaq Next Generation 100 ESG Notional Net Total Return Currency Hedged CAD Index", "I:NGXGBP": "Nasdaq Next Generation 100 Index GBP", "I:NGXHKD": "Nasdaq Next Generation 100 Index HKD", "I:NGXJPY": "Nasdaq Next Generation 100 Index JPY", "I:NGXN": "Nasdaq Next Generation 100 Notional Net Return", "I:NGXN2D": "Nasdaq NextGeneration Synthetic Dividend 2%", "I:NGXNAUD": "Nasdaq Next Generation 100 Notional Net Return AUD", "I:NGXNCAD": "Nasdaq Next Generation 100 Notional Net Return CAD", "I:NGXNCADMH": "Nasdaq Next Generation 100 Currency Hedged CAD NTR Index", "I:NGXNCHF": "Nasdaq Next Generation 100 Notional Net Return CHF", "I:NGXNEUR": "Nasdaq Next Generation 100 Notional Net Return EUR", "I:NGXNGBP": "Nasdaq Next Generation 100 Notional Net Return GBP", "I:NGXNHKD": "Nasdaq Next Generation 100 Notional Net Return HKD", "I:NGXNJPY": "Nasdaq Next Generation 100 Notional Net Return JPY", "I:NGXT": "Nasdaq Next Generation 100 Total Return", "I:NGXTAUD": "Nasdaq Next Generation 100 Total Return AUD", "I:NGXTCAD": "Nasdaq Next Generation 100 Total Return CAD", "I:NGXTCADMH": "Nasdaq Next Generation 100 Currency Hedged CAD TR Index", "I:NGXTCHF": "Nasdaq Next Generation 100 Total Return CHF", "I:NGXTEUR": "Nasdaq Next Generation 100 Total Return EUR", "I:NGXTGBP": "Nasdaq Next Generation 100 Total Return GBP", "I:NGXTHKD": "Nasdaq Next Generation 100 Total Return HKD", "I:NGXTJPY": "Nasdaq Next Generation 100 Total Return JPY", "I:NHT": "Cboe Nasdaq-100 BuyWrite", "I:NL30": "Dow Jones Netherlands Titans 30 Index (EUR)", "I:NL30D": "Dow Jones Netherlands Titans 30 Index (USD)","I:NLDOW": "Dow Jones Netherlands Index", "I:NLDOWD": "Dow Jones Netherlands Index (USD)", "I:NOBLIV": "PROSHARES S&P 500 DIVIDEND ARISTOCRATS ETF", "I:NODOW": "Dow Jones Norway Index", "I:NODOWD": "Dow Jones Norway Index (USD)", "I:NOMXN120": "NASDAQ OMX Nordic 120", "I:NOMXN120GI": "NASDAQ OMX Nordic 120 Gross Index", "I:NOMXN120NI": "NASDAQ OMX Nordic 120 Net Index", "I:NOMXN120SEK": "NASDAQ OMX Nordic 120 SEK", "I:NOMXN120SEKGI": "NASDAQ OMX Nordic 120 SEK Gross Index", "I:NOMXN120SEKNI": "NASDAQ OMX Nordic 120 SEK Net Index", "I:NOMXNBI": "NASDAQ OMX Nordic Bank & Insurance", "I:NOMXNBIGI": "NASDAQ OMX Nordic Bank & Insurance Gross Index", "I:NOMXNBINI": "NASDAQ OMX Nordic Bank & Insurance Net Index", "I:NOMXNBISEK": "NASDAQ OMX Nordic Bank & Insurance SEK", "I:NOMXNBISEKGI": "NASDAQ OMX Nordic Bank & Insurance SEK Gross Index", "I:NOMXNBISEKNI": "NASDAQ OMX Nordic Bank & Insurance SEK Net Index", "I:NOMXNCO": "NASDAQ OMX Nordic Consumer", "I:NOMXNCOGI": "NASDAQ OMX Nordic Consumer Gross Index", "I:NOMXNCONI": "NASDAQ OMX Nordic Consumer Net Index", "I:NOMXNCOSEK": "NASDAQ OMX Nordic Consumer SEK", "I:NOMXNCOSEKGI": "NASDAQ OMX Nordic Consumer SEK Gross Index", "I:NOMXNCOSEKNI": "NASDAQ OMX Nordic Consumer SEK Net Index", "I:NOMXNCR": "NASDAQ OMX Nordic Construction & Real Estate", "I:NOMXNCRGI": "NASDAQ OMX Nordic Construction & Real Estate GI", "I:NOMXNCRNI": "NASDAQ OMX Nordic Construction & Real Estate NI", "I:NOMXNCRSEK": "NASDAQ OMX Nordic Const & Real Est SEK", "I:NOMXNCRSEKGI": "NASDAQ OMX Nordic Const & Real Est SEK Gross Index", "I:NOMXNCRSEKNI": "NASDAQ OMX Nordic Const & Real Est SEK Net Index", "I:NOMXNEN": "NASDAQ OMX Nordic Energy", "I:NOMXNENGI": "NASDAQ OMX Nordic Energy Gross Index", "I:NOMXNENNI": "NASDAQ OMX Nordic Energy Net Index", "I:NOMXNENSEK": "NASDAQ OMX Nordic Energy SEK", "I:NOMXNENSEKGI": "NASDAQ OMX Nordic Energy SEK Gross Index", "I:NOMXNENSEKNI": "NASDAQ OMX Nordic Energy SEK Net Index", "I:NOMXNHC": "NASDAQ OMX Nordic Health Care", "I:NOMXNHCGI": "NASDAQ OMX Nordic Health Care Gross Index", "I:NOMXNHCNI": "NASDAQ OMX Nordic Health Care Net Index", "I:NOMXNHCSEK": "NASDAQ OMX Nordic Health Care SEK", "I:NOMXNHCSEKGI": "NASDAQ OMX Nordic Health Care SEK Gross Index", "I:NOMXNHCSEKNI": "NASDAQ OMX Nordic Health Care SEK Net Index", "I:NOMXNIC": "NASDAQ OMX Nordic Investment Companies", "I:NOMXNICGI": "NASDAQ OMX Nordic Investment Companies Gross Index", "I:NOMXNICNI": "NASDAQ OMX Nordic Investment Companies Net Index", "I:NOMXNICSEK": "NASDAQ OMX Nordic Invest Companies SEK", "I:NOMXNICSEKGI": "NASDAQ OMX Nordic Invest Companies SEK Gross Index", "I:NOMXNICSEKNI": "NASDAQ OMX Nordic Invest Companies SEK Net Index", "I:NOMXNIN": "NASDAQ OMX Nordic Industrials", "I:NOMXNINGI": "NASDAQ OMX Nordic Industrials Gross Index", "I:NOMXNINNI": "NASDAQ OMX Nordic Industrials Net Index", "I:NOMXNINSEK": "NASDAQ OMX Nordic Industrials SEK", "I:NOMXNINSEKGI": "NASDAQ OMX Nordic Industrials SEK Gross Index", "I:NOMXNINSEKNI": "NASDAQ OMX Nordic Industrials SEK Net Index", "I:NOMXNMA": "NASDAQ OMX Nordic Materials", "I:NOMXNMAGI": "NASDAQ OMX Nordic Materials Gross Index", "I:NOMXNMANI": "NASDAQ OMX Nordic Materials Net Index", "I:NOMXNMASEK": "NASDAQ OMX Nordic Materials SEK", "I:NOMXNMASEKGI": "NASDAQ OMX Nordic Materials SEK Gross Index", "I:NOMXNMASEKNI": "NASDAQ OMX Nordic Materials SEK Net Index", "I:NOMXNTI": "NASDAQ OMX Nordic Telecom & InfoTech", "I:NOMXNTIGI": "NASDAQ OMX Nordic Telecom & InfoTech Gross Index", "I:NOMXNTINI": "NASDAQ OMX Nordic Telecom & InfoTech Net Index", "I:NOMXNTISEK": "NASDAQ OMX Nordic Tele & InfoTech SEK", "I:NOMXNTISEKGI": "NASDAQ OMX Nordic Tele & InfoTech SEK Gross Index", "I:NOMXNTISEKNI": "NASDAQ OMX Nordic Tele & InfoTech SEK Net Index", "I:NOMXNTP": "NASDAQ OMX Nordic Transportation", "I:NOMXNTPGI": "NASDAQ OMX Nordic Transportation Gross Index", "I:NOMXNTPNI": "NASDAQ OMX Nordic Transportation Net Index", "I:NOMXNTPSEK": "NASDAQ OMX Nordic Transportation SEK", "I:NOMXNTPSEKGI": "NASDAQ OMX Nordic Transportation SEK Gross Index", "I:NOMXNTPSEKNI": "NASDAQ OMX Nordic Transportation SEK Net Index", "I:NOMXSCSEGI": "NASDAQ OMX Small Cap Sweden GI", "I:NOMXSCSENI": "NASDAQ OMX Small Cap Sweden NI", "I:NOMXSCSEPI": "NASDAQ OMX Small Cap Sweden PI", "I:NOVZIV": "TrueShares Structured Outcome (November) ETF Intraday Indicative Value", "I:NQ10HANDLL": "Nasdaq 10HANDL PR Index", "I:NQ10HANDLLE": "10HANDL Price Excess Return Index (PER)", "I:NQ10HANDLNL": "Nasdaq 10HANDL NTR Index", "I:NQ10HANDLNLE": "10HANDL Net Excess Return Index (NER)", "I:NQ10HANDLTL": "Nasdaq 10HANDL Index", "I:NQ10HANDLTLE": "10HANDL Total Excess Return Index (TER)", "I:NQ2045": "Nasdaq Singularity Index", "I:NQ2045N": "Nasdaq Singularity Net Total Return Index", "I:NQ2045T": "Nasdaq Singularity Total Return Index", "I:NQ5HANDL": "Nasdaq 5HANDL Index", "I:NQ5HANDLE": "Nasdaq 5HANDL PER Index", "I:NQ5HANDLN": "Nasdaq 5HANDL NTR Index", "I:NQ5HANDLNE": "Nasdaq 5HANDL NER Index", "I:NQ5HANDLT": "Nasdaq 5HANDL TR Index", "I:NQ5HANDLTE": "Nasdaq 5HANDL TER Index", "I:NQ7HANDL": "Nasdaq HANDL Base Index", "I:NQ7HANDLL": "Nasdaq 7HANDL PR Index", "I:NQ7HANDLLE": "Nasdaq 7HANDL PER Index", "I:NQ7HANDLN": "Nasdaq 7HANDL Base NTR Index", "I:NQ7HANDLNL": "Nasdaq 7HANDL NTR Return Index", "I:NQ7HANDLNLE": "Nasdaq 7HANDL NER Index", "I:NQ7HANDLT": "Nasdaq HANDL Base TR Index", "I:NQ7HANDLTL": "Nasdaq 7HANDL Index", "I:NQ7HANDLTLE": "Nasdaq 7HANDL TER Index", "I:NQ96DIVUS": "NASDAQ Technology Dividend Index", "I:NQ96DIVUSX": "NASDAQ Technology Dividend TR Index", "I:NQASIA": "NASDAQ Asia Index", "I:NQASIA10": "Nasdaq Asia Technology Index", "I:NQASIA10LM": "Nasdaq Asia Technology Large Mid Cap Index", "I:NQASIA10LMN": "Nasdaq Asia Technology Large Mid Cap NTR Index", "I:NQASIA10LMT": "Nasdaq Asia Technology Large Mid Cap TR Index", "I:NQASIA10N": "Nasdaq Asia Technology NTR Index", "I:NQASIA10T": "Nasdaq Asia Technology TR Index", "I:NQASIA15": "Nasdaq Asia Telecommunications Index", "I:NQASIA15LM": "Nasdaq Asia Telecommunications Large Mid Cap Index", "I:NQASIA15LMN": "Nasdaq Asia Telecommunications Large Mid Cap NTR Index", "I:NQASIA15LMT": "Nasdaq Asia Telecommunications Large Mid Cap TR Index", "I:NQASIA15N": "Nasdaq Asia Telecommunications NTR Index", "I:NQASIA15T": "Nasdaq Asia Telecommunications TR Index", "I:NQASIA20": "NASDAQ Asia Health Care Index", "I:NQASIA20LM": "Nasdaq Asia Health Care Large Mid Cap Index", "I:NQASIA20LMN": "NASDAQ Asia Health Care Large Mid Cap NTR Index", "I:NQASIA20LMT": "NASDAQ Asia Health Care Large Mid Cap TR Index", "I:NQASIA20N": "NASDAQ Asia Health Care NTR Index", "I:NQASIA20T": "NASDAQ Asia Health Care TR Index", "I:NQASIA30": "NASDAQ Asia Financials Index", "I:NQASIA30LM": "Nasdaq Asia Financials Large Mid Cap Index", "I:NQASIA30LMN": "NASDAQ Asia Financials Large Mid Cap NTR Index", "I:NQASIA30LMT": "NASDAQ Asia Financials Large Mid Cap TR Index", "I:NQASIA30N": "NASDAQ Asia Financials NTR Index", "I:NQASIA30T": "NASDAQ Asia Financials TR Index", "I:NQASIA35": "Nasdaq Asia Real Estate Index", "I:NQASIA35LM": "Nasdaq Asia Real Estate Large Mid Cap Index", "I:NQASIA35LMN": "Nasdaq Asia Real Estate Large Mid Cap NTR Index", "I:NQASIA35LMT": "Nasdaq Asia Real Estate Large Mid Cap TR Index", "I:NQASIA35N": "Nasdaq Asia Real Estate NTR Index", "I:NQASIA35T": "Nasdaq Asia Real Estate TR Index", "I:NQASIA40": "Nasdaq Asia Consumer Discretionary Index", "I:NQASIA40LM": "Nasdaq Asia Consumer Discretionary Large Mid Cap Index", "I:NQASIA40LMN": "Nasdaq Asia Consumer Discretionary Large Mid Cap NTR Index", "I:NQASIA40LMT": "Nasdaq Asia Consumer Discretionary Large Mid Cap TR Index", "I:NQASIA40N": "Nasdaq Asia Consumer Discretionary NTR Index", "I:NQASIA40T": "Nasdaq Asia Consumer Discretionary TR Index", "I:NQASIA45": "Nasdaq Asia Consumer Staples Index", "I:NQASIA45LM": "Nasdaq Asia Consumer Staples Large Mid Cap Index", "I:NQASIA45LMN": "Nasdaq Asia Consumer Staples Large Mid Cap NTR Index", "I:NQASIA45LMT": "Nasdaq Asia Consumer Staples Large Mid Cap TR Index", "I:NQASIA45N": "Nasdaq Asia Consumer Staples NTR Index", "I:NQASIA45T": "Nasdaq Asia Consumer Staples TR Index", "I:NQASIA50": "Nasdaq Asia Industrials Index", "I:NQASIA50LM": "Nasdaq Asia Industrials Large Mid Cap Index", "I:NQASIA50LMN": "Nasdaq Asia Industrials Large Mid Cap NTR Index", "I:NQASIA50LMT": "Nasdaq Asia Industrials Large Mid Cap TR Index", "I:NQASIA50N": "Nasdaq Asia Industrials NTR Index", "I:NQASIA50T": "Nasdaq Asia Industrials TR Index", "I:NQASIA55": "Nasdaq Asia Basic Materials Index", "I:NQASIA55LM": "Nasdaq Asia Basic Materials Large Mid Cap Index", "I:NQASIA55LMN": "Nasdaq Asia Basic Materials Large Mid Cap NTR Index", "I:NQASIA55LMT": "Nasdaq Asia Basic Materials Large Mid Cap TR Index", "I:NQASIA55N": "Nasdaq Asia Basic Materials NTR Index", "I:NQASIA55T": "Nasdaq Asia Basic Materials TR Index", "I:NQASIA60": "Nasdaq Asia Energy Index", "I:NQASIA60LM": "Nasdaq Asia Energy Large Mid Cap Index", "I:NQASIA60LMN": "Nasdaq Asia Energy Large Mid Cap NTR Index", "I:NQASIA60LMT": "Nasdaq Asia Energy Large Mid Cap TR Index", "I:NQASIA60N": "Nasdaq Asia Energy NTR Index", "I:NQASIA60T": "Nasdaq Asia Energy TR Index", "I:NQASIA65": "NASDAQ Asia Utilities Index", "I:NQASIA65LM": "Nasdaq Asia Utilities Large Mid Cap Index", "I:NQASIA65LMN": "NASDAQ Asia Utilities Large Mid Cap NTR Index", "I:NQASIA65LMT": "NASDAQ Asia Utilities Large Mid Cap TR Index", "I:NQASIA65N": "NASDAQ Asia Utilities NTR Index", "I:NQASIA65T": "NASDAQ Asia Utilities TR Index", "I:NQASIALM": "NASDAQ Asia Large Mid Cap Index", "I:NQASIALMN": "NASDAQ Asia Large Mid Cap NTR Index", "I:NQASIALMT": "NASDAQ Asia Large Mid Cap TR Index", "I:NQASIAN": "NASDAQ Asia NTR Index", "I:NQASIAT": "NASDAQ Asia TR Index", "I:NQASPA": "NASDAQ ASPA Index", "I:NQASPA10": "Nasdaq ASPA Technology Index", "I:NQASPA10LM": "Nasdaq ASPA Technology Large Mid Cap Index", "I:NQASPA10LMN": "Nasdaq ASPA Technology Large Mid Cap NTR Index", "I:NQASPA10LMT": "Nasdaq ASPA Technology Large Mid Cap TR Index", "I:NQASPA10N": "Nasdaq ASPA Technology NTR Index", "I:NQASPA10T": "Nasdaq ASPA Technology TR Index", "I:NQASPA15": "Nasdaq ASPA Telecommunications Index", "I:NQASPA15LM": "Nasdaq ASPA Telecommunications Large Mid Cap Index", "I:NQASPA15LMN": "Nasdaq ASPA Telecommunications Large Mid Cap NTR Index", "I:NQASPA15LMT": "Nasdaq ASPA Telecommunications Large Mid Cap TR Index", "I:NQASPA15N": "Nasdaq ASPA Telecommunications NTR Index", "I:NQASPA15T": "Nasdaq ASPA Telecommunications TR Index", "I:NQASPA20": "NASDAQ ASPA Health Care Index", "I:NQASPA20LM": "Nasdaq ASPA Health Care Large Mid Cap Index", "I:NQASPA20LMN": "NASDAQ ASPA Health Care Large Mid Cap NTR Index", "I:NQASPA20LMT": "NASDAQ ASPA Health Care Large Mid Cap TR Index", "I:NQASPA20N": "NASDAQ ASPA Health Care NTR Index", "I:NQASPA20T": "NASDAQ ASPA Health Care TR Index", "I:NQASPA30": "NASDAQ ASPA Financials Index", "I:NQASPA3010": "NASDAQ ASPA Banks Index", "I:NQASPA3010LM": "Nasdaq ASPA Banks Large Mid Cap Index", "I:NQASPA3010LMN": "NASDAQ ASPA Banks Large Mid Cap NTR Index", "I:NQASPA3010LMT": "NASDAQ ASPA Banks Large Mid Cap TR Index", "I:NQASPA3010N": "NASDAQ ASPA Banks NTR Index", "I:NQASPA3010T": "NASDAQ ASPA Banks TR Index", "I:NQASPA3020": "Nasdaq ASPA Financial Services Index", "I:NQASPA3020LM": "Nasdaq ASPA Financial Services Large Mid Cap Index", "I:NQASPA3020LMN": "Nasdaq ASPA Financial Services Large Mid Cap NTR Index", "I:NQASPA3020LMT": "Nasdaq ASPA Financial Services Large Mid Cap TR Index", "I:NQASPA3020N": "Nasdaq ASPA Financial Services NTR Index", "I:NQASPA3020T": "Nasdaq ASPA Financial Services TR Index", "I:NQASPA3030": "Nasdaq ASPA Insurance Index", "I:NQASPA3030LM": "Nasdaq ASPA Insurance Large Mid Cap Index", "I:NQASPA3030LMN": "Nasdaq ASPA Insurance Large Mid Cap NTR Index", "I:NQASPA3030LMT": "Nasdaq ASPA Insurance Large Mid Cap TR Index", "I:NQASPA3030N": "Nasdaq ASPA Insurance NTR Index", "I:NQASPA3030T": "Nasdaq ASPA Insurance TR Index", "I:NQASPA30LM": "Nasdaq ASPA Financials Large Mid Cap Index", "I:NQASPA30LMN": "NASDAQ ASPA Financials Large Mid Cap NTR Index", "I:NQASPA30LMT": "NASDAQ ASPA Financials Large Mid Cap TR Index", "I:NQASPA30N": "NASDAQ ASPA Financials NTR Index", "I:NQASPA30T": "NASDAQ ASPA Financials TR Index", "I:NQASPA35": "NASDAQ ASPA Real Estate Index", "I:NQASPA35LM": "Nasdaq ASPA Real Estate Large Mid Cap Index", "I:NQASPA35LMN": "NASDAQ ASPA Real Estate Large Mid Cap NTR Index", "I:NQASPA35LMT": "NASDAQ ASPA Real Estate Large Mid Cap TR Index", "I:NQASPA35N": "NASDAQ ASPA Real Estate NTR Index", "I:NQASPA35T": "NASDAQ ASPA Real Estate TR Index", "I:NQASPA40": "Nasdaq ASPA Consumer Discretionary Index", "I:NQASPA4010": "Nasdaq ASPA Automobiles and Parts Index", "I:NQASPA4010LM": "Nasdaq ASPA Automobiles and Parts Large Mid Cap Index", "I:NQASPA4010LMN": "Nasdaq ASPA Automobiles and Parts Large Mid Cap NTR Index", "I:NQASPA4010LMT": "Nasdaq ASPA Automobiles and Parts Large Mid Cap TR Index", "I:NQASPA4010N": "Nasdaq ASPA Automobiles and Parts NTR Index", "I:NQASPA4010T": "Nasdaq ASPA Automobiles and Parts TR Index", "I:NQASPA4020": "Nasdaq ASPA Consumer Products and Services Index", "I:NQASPA4020LM": "Nasdaq ASPA Consumer Products and Services Large Mid Cap Index", "I:NQASPA4020LMN": "Nasdaq ASPA Consumer Products and Services Large Mid Cap NTR Index", "I:NQASPA4020LMT": "Nasdaq ASPA Consumer Products and Services Large Mid Cap TR Index", "I:NQASPA4020N": "Nasdaq ASPA Consumer Products and Services NTR Index", "I:NQASPA4020T": "Nasdaq ASPA Consumer Products and Services TR Index", "I:NQASPA4030": "NASDAQ ASPA Media Index", "I:NQASPA4030LM": "Nasdaq ASPA Media Large Mid Cap Index", "I:NQASPA4030LMN": "NASDAQ ASPA Media Large Mid Cap NTR Index", "I:NQASPA4030LMT": "NASDAQ ASPA Media Large Mid Cap TR Index", "I:NQASPA4030N": "NASDAQ ASPA Media NTR Index", "I:NQASPA4030T": "NASDAQ ASPA Media TR Index", "I:NQASPA4040": "NASDAQ ASPA Retail Index", "I:NQASPA4040LM": "Nasdaq ASPA Retail Large Mid Cap Index", "I:NQASPA4040LMN": "NASDAQ ASPA Retail Large Mid Cap NTR Index", "I:NQASPA4040LMT": "NASDAQ ASPA Retail Large Mid Cap TR Index", "I:NQASPA4040N": "NASDAQ ASPA Retail NTR Index", "I:NQASPA4040T": "NASDAQ ASPA Retail TR Index", "I:NQASPA4050": "Nasdaq ASPA Travel and Leisure Index", "I:NQASPA4050LM": "Nasdaq ASPA Travel and Leisure Large Mid Cap Index", "I:NQASPA4050LMN": "Nasdaq ASPA Travel and Leisure Large Mid Cap NTR Index", "I:NQASPA4050LMT": "Nasdaq ASPA Travel and Leisure Large Mid Cap TR Index", "I:NQASPA4050N": "Nasdaq ASPA Travel and Leisure NTR Index", "I:NQASPA4050T": "Nasdaq ASPA Travel and Leisure TR Index", "I:NQASPA40LM": "Nasdaq ASPA Consumer Discretionary Large Mid Cap Index", "I:NQASPA40LMN": "Nasdaq ASPA Consumer Discretionary Large Mid Cap NTR Index", "I:NQASPA40LMT": "Nasdaq ASPA Consumer Discretionary Large Mid Cap TR Index", "I:NQASPA40N": "Nasdaq ASPA Consumer Discretionary NTR Index", "I:NQASPA40T": "Nasdaq ASPA Consumer Discretionary TR Index", "I:NQASPA45": "Nasdaq ASPA Consumer Staples Index", "I:NQASPA4510": "Nasdaq ASPA Food, Beverage and Tobacco Index", "I:NQASPA4510LM": "Nasdaq ASPA Food, Beverage and Tobacco Large Mid Cap Index", "I:NQASPA4510LMN": "Nasdaq ASPA Food, Beverage and Tobacco Large Mid Cap NTR Index", "I:NQASPA4510LMT": "Nasdaq ASPA Food, Beverage and Tobacco Large Mid Cap TR Index", "I:NQASPA4510N": "Nasdaq ASPA Food, Beverage and Tobacco NTR Index", "I:NQASPA4510T": "Nasdaq ASPA Food, Beverage and Tobacco TR Index", "I:NQASPA4520": "Nasdaq ASPA Personal Care, Drug and Grocery Stores Index", "I:NQASPA4520LM": "Nasdaq ASPA Personal Care, Drug and Grocery Stores Large Mid Cap Index", "I:NQASPA4520LMN": "Nasdaq ASPA Personal Care, Drug and Grocery Stores Large Mid Cap NTR Index", "I:NQASPA4520LMT": "Nasdaq ASPA Personal Care, Drug and Grocery Stores Large Mid Cap TR Index", "I:NQASPA4520N": "Nasdaq ASPA Personal Care, Drug and Grocery Stores NTR Index", "I:NQASPA4520T": "Nasdaq ASPA Personal Care, Drug and Grocery Stores TR Index", "I:NQASPA45LM": "Nasdaq ASPA Consumer Staples Large Mid Cap Index", "I:NQASPA45LMN": "Nasdaq ASPA Consumer Staples Large Mid Cap NTR Index", "I:NQASPA45LMT": "Nasdaq ASPA Consumer Staples Large Mid Cap TR Index", "I:NQASPA45N": "Nasdaq ASPA Consumer Staples NTR Index", "I:NQASPA45T": "Nasdaq ASPA Consumer Staples TR Index", "I:NQASPA50": "Nasdaq ASPA Industrials Index", "I:NQASPA5010": "Nasdaq ASPA Construction and Materials Index", "I:NQASPA5010LM": "Nasdaq ASPA Construction and Materials Large Mid Cap Index", "I:NQASPA5010LMN": "Nasdaq ASPA Construction and Materials Large Mid Cap NTR Index", "I:NQASPA5010LMT": "Nasdaq ASPA Construction and Materials Large Mid Cap TR Index", "I:NQASPA5010N": "Nasdaq ASPA Construction and Materials NTR Index", "I:NQASPA5010T": "Nasdaq ASPA Construction and Materials TR Index", "I:NQASPA5020": "Nasdaq ASPA Industrial Goods and Services Index", "I:NQASPA5020LM": "Nasdaq ASPA Industrial Goods and Services Large Mid Cap Index", "I:NQASPA5020LMN": "Nasdaq ASPA Industrial Goods and Services Large Mid Cap NTR Index", "I:NQASPA5020LMT": "Nasdaq ASPA Industrial Goods and Services Large Mid Cap TR Index", "I:NQASPA5020N": "Nasdaq ASPA Industrial Goods and Services NTR Index", "I:NQASPA5020T": "Nasdaq ASPA Industrial Goods and Services TR Index", "I:NQASPA50LM": "Nasdaq ASPA Industrials Large Mid Cap Index", "I:NQASPA50LMN": "Nasdaq ASPA Industrials Large Mid Cap NTR Index", "I:NQASPA50LMT": "Nasdaq ASPA Industrials Large Mid Cap TR Index", "I:NQASPA50N": "Nasdaq ASPA Industrials NTR Index", "I:NQASPA50T": "Nasdaq ASPA Industrials TR Index", "I:NQASPA55": "Nasdaq ASPA Basic Materials Index", "I:NQASPA5510": "NASDAQ ASPA Basic Resources Index", "I:NQASPA5510LM": "Nasdaq ASPA Basic Resources Large Mid Cap Index", "I:NQASPA5510LMN": "Nasdaq ASPA Basic Resources Large Mid Cap NTR Index", "I:NQASPA5510LMT": "Nasdaq ASPA Basic Resources Large Mid Cap TR Index", "I:NQASPA5510N": "NASDAQ ASPA Basic Resources NTR Index", "I:NQASPA5510T": "NASDAQ ASPA Basic Resources TR Index", "I:NQASPA5520": "NASDAQ ASPA Chemicals Index", "I:NQASPA5520LM": "Nasdaq ASPA Chemicals Large Mid Cap Index", "I:NQASPA5520LMN": "NASDAQ ASPA Chemicals Large Mid Cap NTR Index", "I:NQASPA5520LMT": "NASDAQ ASPA Chemicals Large Mid Cap TR Index", "I:NQASPA5520N": "NASDAQ ASPA Chemicals NTR Index", "I:NQASPA5520T": "NASDAQ ASPA Chemicals TR Index", "I:NQASPA55LM": "Nasdaq ASPA Basic Materials Large Mid Cap Index", "I:NQASPA55LMN": "Nasdaq ASPA Basic Materials Large Mid Cap NTR Index", "I:NQASPA55LMT": "Nasdaq ASPA Basic Materials Large Mid Cap TR Index", "I:NQASPA55N": "Nasdaq ASPA Basic Materials NTR Index", "I:NQASPA55T": "Nasdaq ASPA Basic Materials TR Index", "I:NQASPA60": "Nasdaq ASPA Energy Index", "I:NQASPA60LM": "Nasdaq ASPA Energy Large Mid Cap Index", "I:NQASPA60LMN": "Nasdaq ASPA Energy Large Mid Cap NTR Index", "I:NQASPA60LMT": "Nasdaq ASPA Energy Large Mid Cap TR Index", "I:NQASPA60N": "Nasdaq ASPA Energy NTR Index", "I:NQASPA60T": "Nasdaq ASPA Energy TR Index", "I:NQASPA65": "NASDAQ ASPA Utilities Index", "I:NQASPA65LM": "Nasdaq ASPA Utilities Large Mid Cap Index", "I:NQASPA65LMN": "NASDAQ ASPA Utilities Large Mid Cap NTR Index", "I:NQASPA65LMT": "NASDAQ ASPA Utilities Large Mid Cap TR Index", "I:NQASPA65N": "NASDAQ ASPA Utilities NTR Index", "I:NQASPA65T": "NASDAQ ASPA Utilities TR Index", "I:NQASPALC": "NASDAQ ASPA Large Cap Index", "I:NQASPALCN": "NASDAQ ASPA Large Cap NTR Index", "I:NQASPALCT": "NASDAQ ASPA Large Cap TR Index", "I:NQASPALM": "NASDAQ ASPA Large Mid Cap Index", "I:NQASPALMN": "NASDAQ ASPA Large Mid Cap NTR Index", "I:NQASPALMT": "NASDAQ ASPA Large Mid Cap TR Index", "I:NQASPAMC": "NASDAQ ASPA Mid Cap Index", "I:NQASPAMCN": "NASDAQ ASPA Mid Cap NTR Index", "I:NQASPAMCT": "NASDAQ ASPA Mid Cap TR Index", "I:NQASPAN": "NASDAQ ASPA NTR Index", "I:NQASPASC": "NASDAQ ASPA Small Cap Index", "I:NQASPASCN": "NASDAQ ASPA Small Cap NTR Index", "I:NQASPASCT": "NASDAQ ASPA Small Cap TR Index", "I:NQASPAT": "NASDAQ ASPA TR Index", "I:NQASPAXJP": "NASDAQ ASPA Ex Japan Index", "I:NQASPAXJPLM": "NASDAQ ASPA Ex Japan Large Mid Cap Index", "I:NQASPAXJPLMN": "NASDAQ ASPA Ex Japan Large Mid Cap NTR Index", "I:NQASPAXJPLMT": "NASDAQ ASPA Ex Japan Large Mid Cap TR Index", "I:NQASPAXJPN": "NASDAQ ASPA Ex Japan NTR Index", "I:NQASPAXJPT": "NASDAQ ASPA Ex Japan TR Index", "I:NQAT": "NASDAQ Austria Index", "I:NQAT30": "NASDAQ Austria Financials Index", "I:NQAT30N": "NASDAQ Austria Financials NTR Index", "I:NQAT30T": "NASDAQ Austria Financials TR Index", "I:NQAT50": "Nasdaq Austria Industrials Index", "I:NQAT50N": "Nasdaq Austria Industrials NTR Index", "I:NQAT50T": "Nasdaq Austria Industrials TR Index", "I:NQATLM": "NASDAQ Austria Large Mid Cap Index", "I:NQATLMN": "NASDAQ Austria Large Mid Cap NTR Index", "I:NQATLMT": "NASDAQ Austria Large Mid Cap TR Index", "I:NQATMC": "NASDAQ Austria Mid Cap Index", "I:NQATMCN": "NASDAQ Austria Mid Cap NTR Index", "I:NQATMCT": "NASDAQ Austria Mid Cap TR Index", "I:NQATN": "NASDAQ Austria NTR Index", "I:NQATSC": "NASDAQ Austria Small Cap Index", "I:NQATSCN": "NASDAQ Austria Small Cap NTR Index", "I:NQATSCT": "NASDAQ Austria Small Cap TR Index", "I:NQATT": "NASDAQ Austria TR Index", "I:NQAU": "NASDAQ Australia Index", "I:NQAU10": "Nasdaq Australia Technology Index", "I:NQAU10N": "Nasdaq Australia Technology NTR Index", "I:NQAU10T": "Nasdaq Australia Technology TR Index", "I:NQAU15": "Nasdaq Australia Telecommunications Index", "I:NQAU15N": "Nasdaq Australia Telecommunications NTR Index", "I:NQAU15T": "Nasdaq Australia Telecommunications TR Index", "I:NQAU20": "NASDAQ Australia Health Care Index", "I:NQAU20LM": "Nasdaq Australia Health Care Large Mid Cap Index", "I:NQAU20LMN": "Nasdaq Australia Health Care Large Mid Cap NTR Index", "I:NQAU20LMT": "Nasdaq Australia Health Care Large Mid Cap TR Index", "I:NQAU20N": "NASDAQ Australia Health Care NTR Index", "I:NQAU20T": "NASDAQ Australia Health Care TR Index", "I:NQAU30": "NASDAQ Australia Financials Index", "I:NQAU30LM": "Nasdaq Australia Financials Large Mid Cap Index", "I:NQAU30LMN": "Nasdaq Australia Financials Large Mid Cap NTR Index", "I:NQAU30LMT": "Nasdaq Australia Financials Large Mid Cap TR Index", "I:NQAU30N": "NASDAQ Australia Financials NTR Index", "I:NQAU30T": "NASDAQ Australia Financials TR Index", "I:NQAU35": "Nasdaq Australia Real Estate Index", "I:NQAU35LM": "Nasdaq Australia Real Estate Large Mid Cap Index", "I:NQAU35LMN": "Nasdaq Australia Real Estate Large Mid Cap NTR Index", "I:NQAU35LMT": "Nasdaq Australia Real Estate Large Mid Cap TR Index", "I:NQAU35N": "Nasdaq Australia Real Estate NTR Index", "I:NQAU35T": "Nasdaq Australia Real Estate TR Index", "I:NQAU40": "Nasdaq Australia Consumer Discretionary Index", "I:NQAU40LM": "Nasdaq Australia Consumer Discretionary Large Mid Cap Index", "I:NQAU40LMN": "Nasdaq Australia Consumer Discretionary Large Mid Cap NTR Index", "I:NQAU40LMT": "Nasdaq Australia Consumer Discretionary Large Mid Cap TR Index", "I:NQAU40N": "Nasdaq Australia Consumer Discretionary NTR Index", "I:NQAU40T": "Nasdaq Australia Consumer Discretionary TR Index", "I:NQAU45": "Nasdaq Australia Consumer Staples Index", "I:NQAU45N": "Nasdaq Australia Consumer Staples NTR Index", "I:NQAU45T": "Nasdaq Australia Consumer Staples TR Index", "I:NQAU50": "Nasdaq Australia Industrials Index", "I:NQAU50LM": "Nasdaq Australia Industrials Large Mid Cap Index", "I:NQAU50LMN": "Nasdaq Australia Industrials Large Mid Cap NTR Index", "I:NQAU50LMT": "Nasdaq Australia Industrials Large Mid Cap TR Index", "I:NQAU50N": "Nasdaq Australia Industrials NTR Index", "I:NQAU50T": "Nasdaq Australia Industrials TR Index", "I:NQAU55": "Nasdaq Australia Basic Materials Index", "I:NQAU55LM": "Nasdaq Australia Basic Materials Large Mid Cap Index", "I:NQAU55LMN": "Nasdaq Australia Basic Materials Large Mid Cap NTR Index", "I:NQAU55LMT": "Nasdaq Australia Basic Materials Large Mid Cap TR Index", "I:NQAU55N": "Nasdaq Australia Basic Materials NTR Index", "I:NQAU55T": "Nasdaq Australia Basic Materials TR Index", "I:NQAU60": "Nasdaq Australia Energy Index", "I:NQAU60LM": "Nasdaq Australia Energy Large Mid Cap Index", "I:NQAU60LMN": "Nasdaq Australia Energy Large Mid Cap NTR Index", "I:NQAU60LMT": "Nasdaq Australia Energy Large Mid Cap TR Index", "I:NQAU60N": "Nasdaq Australia Energy NTR Index", "I:NQAU60T": "Nasdaq Australia Energy TR Index", "I:NQAU65": "NASDAQ Australia Utilities Index", "I:NQAU65LM": "Nasdaq Australia Utilities Large Mid Cap Index", "I:NQAU65LMN": "NASDAQ Australia Utilities Large Mid Cap NTR Index", "I:NQAU65LMT": "NASDAQ Australia Utilities Large Mid Cap TR Index", "I:NQAU65N": "NASDAQ Australia Utilities NTR Index", "I:NQAU65T": "NASDAQ Australia Utilities TR Index", "I:NQAULC": "NASDAQ Australia Large Cap Index", "I:NQAULCN": "NASDAQ Australia Large Cap NTR Index", "I:NQAULCT": "NASDAQ Australia Large Cap TR Index", "I:NQAULM": "NASDAQ Australia Large Mid Cap Index", "I:NQAULMN": "NASDAQ Australia Large Mid Cap NTR Index", "I:NQAULMT": "NASDAQ Australia Large Mid Cap TR Index", "I:NQAUMC": "NASDAQ Australia Mid Cap Index", "I:NQAUMCN": "NASDAQ Australia Mid Cap NTR Index", "I:NQAUMCT": "NASDAQ Australia Mid Cap TR Index", "I:NQAUN": "NASDAQ Australia NTR Index", "I:NQAUSC": "NASDAQ Australia Small Cap Index", "I:NQAUSCN": "NASDAQ Australia Small Cap NTR Index", "I:NQAUSCT": "NASDAQ Australia Small Cap TR Index", "I:NQAUT": "NASDAQ Australia TR Index", "I:NQBE": "NASDAQ Belgium Index", "I:NQBE20": "NASDAQ Belgium Health Care Index", "I:NQBE20N": "NASDAQ Belgium Health Care NTR Index", "I:NQBE20T": "NASDAQ Belgium Health Care TR Index", "I:NQBE30": "NASDAQ Belgium Financials Index", "I:NQBE30LM": "Nasdaq Belgium Financials Large Mid Cap Index", "I:NQBE30LMN": "NASDAQ Belgium Financials Large Mid Cap NTR Index", "I:NQBE30LMT": "NASDAQ Belgium Financials Large Mid Cap TR Index", "I:NQBE30N": "NASDAQ Belgium Financials NTR Index", "I:NQBE30T": "NASDAQ Belgium Financials TR Index", "I:NQBE35": "Nasdaq Belgium Real Estate Index", "I:NQBE35N": "Nasdaq Belgium Real Estate NTR Index", "I:NQBE35T": "Nasdaq Belgium Real Estate TR Index", "I:NQBE50": "Nasdaq Belgium Industrials Index", "I:NQBE50N": "Nasdaq Belgium Industrials NTR Index", "I:NQBE50T": "Nasdaq Belgium Industrials TR Index", "I:NQBE55": "Nasdaq Belgium Basic Materials Index", "I:NQBE55N": "Nasdaq Belgium Basic Materials NTR Index", "I:NQBE55T": "Nasdaq Belgium Basic Materials TR Index", "I:NQBEI": "Nasdaq Bitcoin/Ethereum Index", "I:NQBELC": "NASDAQ Belgium Large Cap Index", "I:NQBELCN": "NASDAQ Belgium Large Cap NTR Index", "I:NQBELCT": "NASDAQ Belgium Large Cap TR Index", "I:NQBELM": "NASDAQ Belgium Large Mid Cap Index", "I:NQBELMN": "NASDAQ Belgium Large Mid Cap NTR Index", "I:NQBELMT": "NASDAQ Belgium Large Mid Cap TR Index", "I:NQBEMC": "NASDAQ Belgium Mid Cap Index", "I:NQBEMCN": "NASDAQ Belgium Mid Cap NTR Index", "I:NQBEMCT": "NASDAQ Belgium Mid Cap TR Index", "I:NQBEN": "NASDAQ Belgium NTR Index", "I:NQBESC": "NASDAQ Belgium Small Cap Index", "I:NQBESCN": "NASDAQ Belgium Small Cap NTR Index", "I:NQBESCT": "NASDAQ Belgium Small Cap TR Index", "I:NQBET": "NASDAQ Belgium TR Index", "I:NQBHY3": "Nasdaq BulletShares High Yield 3 Year Ladder", "I:NQBHY3T": "Nasdaq BulletShares High Yield 3 Year Ladder TR", "I:NQBHY5": "Nasdaq BulletShares High Yield 5 Year Ladder", "I:NQBHY5T": "Nasdaq BulletShares High Yield 5 Year Ladder TR", "I:NQBHY7": "Nasdaq BulletShares High Yield 7 Year Ladder", "I:NQBHY7T": "Nasdaq BulletShares High Yield 7 Year Ladder TR", "I:NQBIG3": "Nasdaq BulletShares Investment Grade 3 Year Ladder", "I:NQBIG3T": "Nasdaq BulletShares Investment Grade 3 Year Lad TR", "I:NQBIG5": "Nasdaq BulletShares Investment Grade 5 Year Ladder", "I:NQBIG5T": "Nasdaq BulletShares Investment Grade 5 Year Lad TR", "I:NQBIG7": "Nasdaq BulletShares Investment Grade 7 Year Ladder", "I:NQBIG7T": "Nasdaq BulletShares Investment Grade 7 Year Lad TR", "I:NQBR": "NASDAQ Brazil Index", "I:NQBR15": "Nasdaq Brazil Telecommunications Index", "I:NQBR15N": "Nasdaq Brazil Telecommunications NTR Index", "I:NQBR15T": "Nasdaq Brazil Telecommunications TR Index", "I:NQBR20": "NASDAQ Brazil Health Care Index", "I:NQBR20LM": "Nasdaq Brazil Health Care Large Mid Cap Index", "I:NQBR20LMN": "NASDAQ Brazil Health Care Large Mid Cap NTR Index", "I:NQBR20LMT": "NASDAQ Brazil Health Care Large Mid Cap TR Index", "I:NQBR20N": "NASDAQ Brazil Health Care NTR Index", "I:NQBR20T": "NASDAQ Brazil Health Care TR Index", "I:NQBR30": "NASDAQ Brazil Financials Index", "I:NQBR30LM": "Nasdaq Brazil Financials Large Mid Cap Index", "I:NQBR30LMN": "NASDAQ Brazil Financials Large Mid Cap NTR Index", "I:NQBR30LMT": "NASDAQ Brazil Financials Large Mid Cap TR Index", "I:NQBR30N": "NASDAQ Brazil Financials NTR Index", "I:NQBR30T": "NASDAQ Brazil Financials TR Index", "I:NQBR35": "Nasdaq Brazil Real Estate Index", "I:NQBR35N": "Nasdaq Brazil Real Estate NTR Index", "I:NQBR35T": "Nasdaq Brazil Real Estate TR Index", "I:NQBR40": "Nasdaq Brazil Consumer Discretionary Index", "I:NQBR40LM": "Nasdaq Brazil Consumer Discretionary Large Mid Cap Index", "I:NQBR40LMN": "Nasdaq Brazil Consumer Discretionary Large Mid Cap NTR Index", "I:NQBR40LMT": "Nasdaq Brazil Consumer Discretionary Large Mid Cap TR Index", "I:NQBR40N": "Nasdaq Brazil Consumer Discretionary NTR Index", "I:NQBR40T": "Nasdaq Brazil Consumer Discretionary TR Index", "I:NQBR45": "Nasdaq Brazil Consumer Staples Index", "I:NQBR45LM": "Nasdaq Brazil Consumer Staples Large Mid Cap Index", "I:NQBR45LMN": "Nasdaq Brazil Consumer Staples Large Mid Cap NTR Index", "I:NQBR45LMT": "Nasdaq Brazil Consumer Staples Large Mid Cap TR Index", "I:NQBR45N": "Nasdaq Brazil Consumer Staples NTR Index", "I:NQBR45T": "Nasdaq Brazil Consumer Staples TR Index", "I:NQBR50": "Nasdaq Brazil Industrials Index", "I:NQBR50LM": "Nasdaq Brazil Industrials Large Mid Cap Index", "I:NQBR50LMN": "Nasdaq Brazil Industrials Large Mid Cap NTR Index", "I:NQBR50LMT": "Nasdaq Brazil Industrials Large Mid Cap TR Index", "I:NQBR50N": "Nasdaq Brazil Industrials NTR Index", "I:NQBR50T": "Nasdaq Brazil Industrials TR Index", "I:NQBR55": "Nasdaq Brazil Basic Materials Index", "I:NQBR55LM": "Nasdaq Brazil Basic Materials Large Mid Cap Index", "I:NQBR55LMN": "Nasdaq Brazil Basic Materials Large Mid Cap NTR Index", "I:NQBR55LMT": "Nasdaq Brazil Basic Materials Large Mid Cap TR Index", "I:NQBR55N": "Nasdaq Brazil Basic Materials NTR Index", "I:NQBR55T": "Nasdaq Brazil Basic Materials TR Index", "I:NQBR60": "Nasdaq Brazil Energy Index", "I:NQBR60LM": "Nasdaq Brazil Energy Large Mid Cap Index", "I:NQBR60LMN": "Nasdaq Brazil Energy Large Mid Cap NTR Index", "I:NQBR60LMT": "Nasdaq Brazil Energy Large Mid Cap TR Index", "I:NQBR60N": "Nasdaq Brazil Energy NTR Index", "I:NQBR60T": "Nasdaq Brazil Energy TR Index", "I:NQBR65": "NASDAQ Brazil Utilities Index", "I:NQBR65LM": "Nasdaq Brazil Utilities Large Mid Cap Index", "I:NQBR65LMN": "NASDAQ Brazil Utilities Large Mid Cap NTR Index", "I:NQBR65LMT": "NASDAQ Brazil Utilities Large Mid Cap TR Index", "I:NQBR65N": "NASDAQ Brazil Utilities NTR Index", "I:NQBR65T": "NASDAQ Brazil Utilities TR Index", "I:NQBRIC": "NASDAQ BRIC Index", "I:NQBRIC10": "Nasdaq BRIC Technology Index", "I:NQBRIC10LM": "Nasdaq BRIC Technology Large Mid Cap Index", "I:NQBRIC10LMN": "Nasdaq BRIC Technology Large Mid Cap NTR Index", "I:NQBRIC10LMT": "Nasdaq BRIC Technology Large Mid Cap TR Index", "I:NQBRIC10N": "Nasdaq BRIC Technology NTR Index", "I:NQBRIC10T": "Nasdaq BRIC Technology TR Index", "I:NQBRIC15": "Nasdaq BRIC Telecommunications Index", "I:NQBRIC15LM": "Nasdaq BRIC Telecommunications Large Mid Cap Index", "I:NQBRIC15LMN": "Nasdaq BRIC Telecommunications Large Mid Cap NTR Index", "I:NQBRIC15LMT": "Nasdaq BRIC Telecommunications Large Mid Cap TR Index", "I:NQBRIC15N": "Nasdaq BRIC Telecommunications NTR Index", "I:NQBRIC15T": "Nasdaq BRIC Telecommunications TR Index", "I:NQBRIC20": "NASDAQ BRIC Health Care Index", "I:NQBRIC20LM": "Nasdaq BRIC Health Care Large Mid Cap Index", "I:NQBRIC20LMN": "NASDAQ BRIC Health Care Large Mid Cap NTR Index", "I:NQBRIC20LMT": "NASDAQ BRIC Health Care Large Mid Cap TR Index", "I:NQBRIC20N": "NASDAQ BRIC Health Care NTR Index", "I:NQBRIC20T": "NASDAQ BRIC Health Care TR Index", "I:NQBRIC30": "NASDAQ BRIC Financials Index", "I:NQBRIC30LM": "Nasdaq BRIC Financials Large Mid Cap Index", "I:NQBRIC30LMN": "NASDAQ BRIC Financials Large Mid Cap NTR Index", "I:NQBRIC30LMT": "NASDAQ BRIC Financials Large Mid Cap TR Index", "I:NQBRIC30N": "NASDAQ BRIC Financials NTR Index", "I:NQBRIC30T": "NASDAQ BRIC Financials TR Index", "I:NQBRIC35": "Nasdaq BRIC Real Estate Index", "I:NQBRIC35LM": "Nasdaq BRIC Real Estate Large Mid Cap Index", "I:NQBRIC35LMN": "Nasdaq BRIC Real Estate Large Mid Cap NTR Index", "I:NQBRIC35LMT": "Nasdaq BRIC Real Estate Large Mid Cap TR Index", "I:NQBRIC35N": "Nasdaq BRIC Real Estate NTR Index", "I:NQBRIC35T": "Nasdaq BRIC Real Estate TR Index", "I:NQBRIC40": "Nasdaq BRIC Consumer Discretionary Index", "I:NQBRIC40LM": "Nasdaq BRIC Consumer Discretionary Large Mid Cap Index", "I:NQBRIC40LMN": "Nasdaq BRIC Consumer Discretionary Large Mid Cap NTR Index", "I:NQBRIC40LMT": "Nasdaq BRIC Consumer Discretionary Large Mid Cap TR Index", "I:NQBRIC40N": "Nasdaq BRIC Consumer Discretionary NTR Index", "I:NQBRIC40T": "Nasdaq BRIC Consumer Discretionary TR Index", "I:NQBRIC45": "Nasdaq BRIC Consumer Staples Index", "I:NQBRIC45LM": "Nasdaq BRIC Consumer Staples Large Mid Cap Index", "I:NQBRIC45LMN": "Nasdaq BRIC Consumer Staples Large Mid Cap NTR Index", "I:NQBRIC45LMT": "Nasdaq BRIC Consumer Staples Large Mid Cap TR Index", "I:NQBRIC45N": "Nasdaq BRIC Consumer Staples NTR Index", "I:NQBRIC45T": "Nasdaq BRIC Consumer Staples TR Index", "I:NQBRIC50": "Nasdaq BRIC Industrials Index", "I:NQBRIC50LM": "Nasdaq BRIC Industrials Large Mid Cap Index", "I:NQBRIC50LMN": "Nasdaq BRIC Industrials Large Mid Cap NTR Index", "I:NQBRIC50LMT": "Nasdaq BRIC Industrials Large Mid Cap TR Index", "I:NQBRIC50N": "Nasdaq BRIC Industrials NTR Index", "I:NQBRIC50T": "Nasdaq BRIC Industrials TR Index", "I:NQBRIC55": "Nasdaq BRIC Basic Materials Index", "I:NQBRIC55LM": "Nasdaq BRIC Basic Materials Large Mid Cap Index", "I:NQBRIC55LMN": "Nasdaq BRIC Basic Materials Large Mid Cap NTR Index", "I:NQBRIC55LMT": "Nasdaq BRIC Basic Materials Large Mid Cap TR Index", "I:NQBRIC55N": "Nasdaq BRIC Basic Materials NTR Index", "I:NQBRIC55T": "Nasdaq BRIC Basic Materials TR Index", "I:NQBRIC60": "Nasdaq BRIC Energy Index", "I:NQBRIC60LM": "Nasdaq BRIC Energy Large Mid Cap Index", "I:NQBRIC60LMN": "Nasdaq BRIC Energy Large Mid Cap NTR Index", "I:NQBRIC60LMT": "Nasdaq BRIC Energy Large Mid Cap TR Index", "I:NQBRIC60N": "Nasdaq BRIC Energy NTR Index", "I:NQBRIC60T": "Nasdaq BRIC Energy TR Index", "I:NQBRIC65": "NASDAQ BRIC Utilities Index", "I:NQBRIC65LM": "Nasdaq BRIC Utilities Large Mid Cap Index", "I:NQBRIC65LMN": "NASDAQ BRIC Utilities Large Mid Cap NTR Index", "I:NQBRIC65LMT": "NASDAQ BRIC Utilities Large Mid Cap TR Index", "I:NQBRIC65N": "NASDAQ BRIC Utilities NTR Index", "I:NQBRIC65T": "NASDAQ BRIC Utilities TR Index", "I:NQBRICLM": "NASDAQ BRIC Large Mid Cap Index", "I:NQBRICLMN": "NASDAQ BRIC Large Mid Cap NTR Index", "I:NQBRICLMT": "NASDAQ BRIC Large Mid Cap TR Index", "I:NQBRICN": "NASDAQ BRIC NTR Index", "I:NQBRICT": "NASDAQ BRIC TR Index", "I:NQBRLC": "NASDAQ Brazil Large Cap Index", "I:NQBRLCN": "NASDAQ Brazil Large Cap NTR Index", "I:NQBRLCT": "NASDAQ Brazil Large Cap TR Index", "I:NQBRLM": "NASDAQ Brazil Large Mid Cap Index", "I:NQBRLMN": "NASDAQ Brazil Large Mid Cap NTR Index", "I:NQBRLMT": "NASDAQ Brazil Large Mid Cap TR Index", "I:NQBRMC": "NASDAQ Brazil Mid Cap Index", "I:NQBRMCN": "NASDAQ Brazil Mid Cap NTR Index", "I:NQBRMCT": "NASDAQ Brazil Mid Cap TR Index", "I:NQBRN": "NASDAQ Brazil NTR Index", "I:NQBRSC": "NASDAQ Brazil Small Cap Index", "I:NQBRSCN": "NASDAQ Brazil Small Cap NTR Index", "I:NQBRSCT": "NASDAQ Brazil Small Cap TR Index", "I:NQBRT": "NASDAQ Brazil TR Index", "I:NQBTC": "Nasdaq Bitcoin Reference Price", "I:NQCA": "NASDAQ Canada Index", "I:NQCA10": "Nasdaq Canada Technology Index", "I:NQCA10LM": "Nasdaq Canada Technology Large Mid Cap Index", "I:NQCA10LMN": "Nasdaq Canada Technology Large Mid Cap NTR Index", "I:NQCA10LMT": "Nasdaq Canada Technology Large Mid Cap TR Index", "I:NQCA10N": "Nasdaq Canada Technology NTR Index", "I:NQCA10T": "Nasdaq Canada Technology TR Index", "I:NQCA15": "Nasdaq Canada Telecommunications Index", "I:NQCA15N": "Nasdaq Canada Telecommunications NTR Index", "I:NQCA15T": "Nasdaq Canada Telecommunications TR Index", "I:NQCA20": "NASDAQ Canada Health Care Index", "I:NQCA20N": "NASDAQ Canada Health Care NTR Index", "I:NQCA20T": "NASDAQ Canada Health Care TR Index", "I:NQCA30": "NASDAQ Canada Financials Index", "I:NQCA30LM": "Nasdaq Canada Financials Large Mid Cap Index", "I:NQCA30LMN": "NASDAQ Canada Financials Large Mid Cap NTR Index", "I:NQCA30LMT": "NASDAQ Canada Financials Large Mid Cap TR Index", "I:NQCA30N": "NASDAQ Canada Financials NTR Index", "I:NQCA30T": "NASDAQ Canada Financials TR Index", "I:NQCA35": "Nasdaq Canada Real Estate Index", "I:NQCA35LM": "Nasdaq Canada Real Estate Large Mid Cap Index", "I:NQCA35LMN": "Nasdaq Canada Real Estate Large Mid Cap NTR Index", "I:NQCA35LMT": "Nasdaq Canada Real Estate Large Mid Cap TR Index", "I:NQCA35N": "Nasdaq Canada Real Estate NTR Index", "I:NQCA35T": "Nasdaq Canada Real Estate TR Index", "I:NQCA40": "Nasdaq Canada Consumer Discretionary Index", "I:NQCA40LM": "Nasdaq Canada Consumer Discretionary Large Mid Cap Index", "I:NQCA40LMN": "Nasdaq Canada Consumer Discretionary Large Mid Cap NTR Index", "I:NQCA40LMT": "Nasdaq Canada Consumer Discretionary Large Mid Cap TR Index", "I:NQCA40N": "Nasdaq Canada Consumer Discretionary NTR Index", "I:NQCA40T": "Nasdaq Canada Consumer Discretionary TR Index", "I:NQCA45": "Nasdaq Canada Consumer Staples Index", "I:NQCA45LM": "Nasdaq Canada Consumer Staples Large Mid Cap Index", "I:NQCA45LMN": "Nasdaq Canada Consumer Staples Large Mid Cap NTR Index", "I:NQCA45LMT": "Nasdaq Canada Consumer Staples Large Mid Cap TR Index", "I:NQCA45N": "Nasdaq Canada Consumer Staples NTR Index", "I:NQCA45T": "Nasdaq Canada Consumer Staples TR Index", "I:NQCA50": "Nasdaq Canada Industrials Index", "I:NQCA50LM": "Nasdaq Canada Industrials Large Mid Cap Index", "I:NQCA50LMN": "Nasdaq Canada Industrials Large Mid Cap NTR Index", "I:NQCA50LMT": "Nasdaq Canada Industrials Large Mid Cap TR Index", "I:NQCA50N": "Nasdaq Canada Industrials NTR Index", "I:NQCA50T": "Nasdaq Canada Industrials TR Index", "I:NQCA55": "Nasdaq Canada Basic Materials Index", "I:NQCA55LM": "Nasdaq Canada Basic Materials Large Mid Cap Index", "I:NQCA55LMN": "Nasdaq Canada Basic Materials Large Mid Cap NTR Index", "I:NQCA55LMT": "Nasdaq Canada Basic Materials Large Mid Cap TR Index", "I:NQCA55N": "Nasdaq Canada Basic Materials NTR Index", "I:NQCA55T": "Nasdaq Canada Basic Materials TR Index", "I:NQCA60": "Nasdaq Canada Energy Index", "I:NQCA60LM": "Nasdaq Canada Energy Large Mid Cap Index", "I:NQCA60LMN": "Nasdaq Canada Energy Large Mid Cap NTR Index", "I:NQCA60LMT": "Nasdaq Canada Energy Large Mid Cap TR Index", "I:NQCA60N": "Nasdaq Canada Energy NTR Index", "I:NQCA60T": "Nasdaq Canada Energy TR Index", "I:NQCA65": "NASDAQ Canada Utilities Index", "I:NQCA65LM": "Nasdaq Canada Utilities Large Mid Cap Index", "I:NQCA65LMN": "NASDAQ Canada Utilities Large Mid Cap NTR Index", "I:NQCA65LMT": "NASDAQ Canada Utilities Large Mid Cap TR Index", "I:NQCA65N": "NASDAQ Canada Utilities NTR Index", "I:NQCA65T": "NASDAQ Canada Utilities TR Index", "I:NQCADIV": "NASDAQ Select Canadian Dividend Index", "I:NQCADIVT": "NASDAQ Select Canadian Dividend Index TR", "I:NQCALC": "NASDAQ Canada Large Cap Index", "I:NQCALCN": "NASDAQ Canada Large Cap NTR Index", "I:NQCALCT": "NASDAQ Canada Large Cap TR Index", "I:NQCALM": "NASDAQ Canada Large Mid Cap Index", "I:NQCALMN": "NASDAQ Canada Large Mid Cap NTR Index", "I:NQCALMT": "NASDAQ Canada Large Mid Cap TR Index", "I:NQCAMC": "NASDAQ Canada Mid Cap Index", "I:NQCAMCN": "NASDAQ Canada Mid Cap NTR Index", "I:NQCAMCT": "NASDAQ Canada Mid Cap TR Index", "I:NQCAN": "NASDAQ Canada NTR Index", "I:NQCAPFD": "NASDAQ Select Canadian Preferred Share Index", "I:NQCAPFDT": "NASDAQ Select Canadian Preferred Share Index TR", "I:NQCAPSG": "The Growth Strength Index", "I:NQCAPSGN": "The Growth Strength Net Total Return Index", "I:NQCAPSGT": "The Growth Strength Total Return Index", "I:NQCAPST": "The Capital Strength Index", "I:NQCAPSTDMXUS": "The International Developed Capital Strength Index", "I:NQCAPSTDMXUSN": "The International Developed Capital Strength NTR", "I:NQCAPSTDMXUST": "The International Developed Capital Strength TR", "I:NQCAPSTN": "The Capital Strength Net Total Return Index", "I:NQCAPSTNF": "NQCAPSTNF", "I:NQCAPSTT": "The Capital Strength Total Return Index", "I:NQCASC": "NASDAQ Canada Small Cap Index", "I:NQCASCN": "NASDAQ Canada Small Cap NTR Index", "I:NQCASCT": "NASDAQ Canada Small Cap TR Index", "I:NQCASH": "NASDAQ US T-Bill Index", "I:NQCASH2": "NASDAQ US T-Bill V2 Index", "I:NQCAT": "NASDAQ Canada TR Index", "I:NQCH": "NASDAQ Switzerland Index", "I:NQCH10": "Nasdaq Switzerland Technology Index", "I:NQCH10N": "Nasdaq Switzerland Technology NTR Index", "I:NQCH10T": "Nasdaq Switzerland Technology TR Index", "I:NQCH20": "NASDAQ Switzerland Health Care Index", "I:NQCH20LM": "Nasdaq Switzerland Health Care Large Mid Cap Index", "I:NQCH20LMN": "Nasdaq Switzerland Health Care Large Mid Cap NTR Index", "I:NQCH20LMT": "Nasdaq Switzerland Health Care Large Mid Cap TR Index", "I:NQCH20N": "NASDAQ Switzerland Health Care NTR Index", "I:NQCH20T": "NASDAQ Switzerland Health Care TR Index", "I:NQCH30": "NASDAQ Switzerland Financials Index", "I:NQCH30LM": "Nasdaq Switzerland Financials Large Mid Cap Index", "I:NQCH30LMN": "Nasdaq Switzerland Financials Large Mid Cap NTR Index", "I:NQCH30LMT": "Nasdaq Switzerland Financials Large Mid Cap TR Index", "I:NQCH30N": "NASDAQ Switzerland Financials NTR Index", "I:NQCH30T": "NASDAQ Switzerland Financials TR Index", "I:NQCH35": "Nasdaq Switzerland Real Estate Index", "I:NQCH35N": "Nasdaq Switzerland Real Estate NTR Index", "I:NQCH35T": "Nasdaq Switzerland Real Estate TR Index", "I:NQCH40": "Nasdaq Switzerland Consumer Discretionary Index", "I:NQCH40N": "Nasdaq Switzerland Consumer Discretionary NTR Index", "I:NQCH40T": "Nasdaq Switzerland Consumer Discretionary TR Index", "I:NQCH45": "Nasdaq Switzerland Consumer Staples Index", "I:NQCH45LM": "Nasdaq Switzerland Consumer Staples Large Mid Cap Index", "I:NQCH45LMN": "Nasdaq Switzerland Consumer Staples Large Mid Cap NTR Index", "I:NQCH45LMT": "Nasdaq Switzerland Consumer Staples Large Mid Cap TR Index", "I:NQCH45N": "Nasdaq Switzerland Consumer Staples NTR Index", "I:NQCH45T": "Nasdaq Switzerland Consumer Staples TR Index", "I:NQCH50": "Nasdaq Switzerland Industrials Index", "I:NQCH50LM": "Nasdaq Switzerland Industrials Large Mid Cap Index", "I:NQCH50LMN": "Nasdaq Switzerland Industrials Large Mid Cap NTR Index", "I:NQCH50LMT": "Nasdaq Switzerland Industrials Large Mid Cap TR Index", "I:NQCH50N": "Nasdaq Switzerland Industrials NTR Index", "I:NQCH50T": "Nasdaq Switzerland Industrials TR Index", "I:NQCH55": "Nasdaq Switzerland Basic Materials Index", "I:NQCH55N": "Nasdaq Switzerland Basic Materials NTR Index", "I:NQCH55T": "Nasdaq Switzerland Basic Materials TR Index", "I:NQCHLC": "NASDAQ Switzerland Large Cap Index", "I:NQCHLCN": "NASDAQ Switzerland Large Cap NTR Index", "I:NQCHLCT": "NASDAQ Switzerland Large Cap TR Index", "I:NQCHLM": "NASDAQ Switzerland Large Mid Cap Index", "I:NQCHLMN": "NASDAQ Switzerland Large Mid Cap NTR Index", "I:NQCHLMT": "NASDAQ Switzerland Large Mid Cap TR Index", "I:NQCHMC": "NASDAQ Switzerland Mid Cap Index", "I:NQCHMCN": "NASDAQ Switzerland Mid Cap NTR Index", "I:NQCHMCT": "NASDAQ Switzerland Mid Cap TR Index", "I:NQCHN": "NASDAQ Switzerland NTR Index", "I:NQCHSC": "NASDAQ Switzerland Small Cap Index", "I:NQCHSCN": "NASDAQ Switzerland Small Cap NTR Index", "I:NQCHSCT": "NASDAQ Switzerland Small Cap TR Index", "I:NQCHT": "NASDAQ Switzerland TR Index", "I:NQCL": "NASDAQ Chile Index", "I:NQCL30": "NASDAQ Chile Financials Index", "I:NQCL30LM": "Nasdaq Chile Financials Large Mid Cap Index", "I:NQCL30LMN": "NASDAQ Chile Financials Large Mid Cap NTR Index", "I:NQCL30LMT": "NASDAQ Chile Financials Large Mid Cap TR Index", "I:NQCL30N": "NASDAQ Chile Financials NTR Index", "I:NQCL30T": "NASDAQ Chile Financials TR Index", "I:NQCL40": "Nasdaq Chile Consumer Discretionary Index", "I:NQCL40N": "Nasdaq Chile Consumer Discretionary NTR Index", "I:NQCL40T": "Nasdaq Chile Consumer Discretionary TR Index", "I:NQCL45": "Nasdaq Chile Consumer Staples Index", "I:NQCL45N": "Nasdaq Chile Consumer Staples NTR Index", "I:NQCL45T": "Nasdaq Chile Consumer Staples TR Index", "I:NQCL50": "Nasdaq Chile Industrials Index", "I:NQCL50N": "Nasdaq Chile Industrials NTR Index", "I:NQCL50T": "Nasdaq Chile Industrials TR Index", "I:NQCL65": "NASDAQ Chile Utilities Index", "I:NQCL65LM": "Nasdaq Chile Utilities Large Mid Cap Index", "I:NQCL65LMN": "NASDAQ Chile Utilities Large Mid Cap NTR Index", "I:NQCL65LMT": "NASDAQ Chile Utilities Large Mid Cap TR Index", "I:NQCL65N": "NASDAQ Chile Utilities NTR Index", "I:NQCL65T": "NASDAQ Chile Utilities TR Index", "I:NQCLLC": "NASDAQ Chile Large Cap Index", "I:NQCLLCN": "NASDAQ Chile Large Cap NTR Index", "I:NQCLLCT": "NASDAQ Chile Large Cap TR Index", "I:NQCLLM": "NASDAQ Chile Large Mid Cap Index", "I:NQCLLMN": "NASDAQ Chile Large Mid Cap NTR Index", "I:NQCLLMT": "NASDAQ Chile Large Mid Cap TR Index", "I:NQCLMC": "NASDAQ Chile Mid Cap Index", "I:NQCLMCN": "NASDAQ Chile Mid Cap NTR Index", "I:NQCLMCT": "NASDAQ Chile Mid Cap TR Index", "I:NQCLN": "NASDAQ Chile NTR Index", "I:NQCLRI": "Nasdaq-100 Quarterly Collar 95-110 Index", "I:NQCLSC": "NASDAQ Chile Small Cap Index", "I:NQCLSCN": "NASDAQ Chile Small Cap NTR Index", "I:NQCLSCT": "NASDAQ Chile Small Cap TR Index", "I:NQCLT": "NASDAQ Chile TR Index", "I:NQCN": "NASDAQ China Index", "I:NQCN10": "Nasdaq China Technology Index", "I:NQCN10LM": "Nasdaq China Technology Large Mid Cap Index", "I:NQCN10LMN": "Nasdaq China Technology Large Mid Cap NTR Index", "I:NQCN10LMT": "Nasdaq China Technology Large Mid Cap TR Index", "I:NQCN10N": "Nasdaq China Technology NTR Index", "I:NQCN10T": "Nasdaq China Technology TR Index", "I:NQCN20": "NASDAQ China Health Care Index", "I:NQCN20LM": "Nasdaq China Health Care Large Mid Cap Index", "I:NQCN20LMN": "NASDAQ China Health Care Large Mid Cap NTR Index", "I:NQCN20LMT": "NASDAQ China Health Care Large Mid Cap TR Index", "I:NQCN20N": "NASDAQ China Health Care NTR Index", "I:NQCN20T": "NASDAQ China Health Care TR Index", "I:NQCN30": "NASDAQ China Financials Index", "I:NQCN30LM": "Nasdaq China Financials Large Mid Cap Index", "I:NQCN30LMN": "NASDAQ China Financials Large Mid Cap NTR Index", "I:NQCN30LMT": "NASDAQ China Financials Large Mid Cap TR Index", "I:NQCN30N": "NASDAQ China Financials NTR Index", "I:NQCN30T": "NASDAQ China Financials TR Index", "I:NQCN35": "Nasdaq China Real Estate Index", "I:NQCN35LM": "Nasdaq China Real Estate Large Mid Cap Index", "I:NQCN35LMN": "Nasdaq China Real Estate Large Mid Cap NTR Index", "I:NQCN35LMT": "Nasdaq China Real Estate Large Mid Cap TR Index", "I:NQCN35N": "Nasdaq China Real Estate NTR Index", "I:NQCN35T": "Nasdaq China Real Estate TR Index", "I:NQCN40": "Nasdaq China Consumer Discretionary Index", "I:NQCN40LM": "Nasdaq China Consumer Discretionary Large Mid Cap Index", "I:NQCN40LMN": "Nasdaq China Consumer Discretionary Large Mid Cap NTR Index", "I:NQCN40LMT": "Nasdaq China Consumer Discretionary Large Mid Cap TR Index", "I:NQCN40N": "Nasdaq China Consumer Discretionary NTR Index", "I:NQCN40T": "Nasdaq China Consumer Discretionary TR Index", "I:NQCN45": "Nasdaq China Consumer Staples Index", "I:NQCN45LM": "Nasdaq China Consumer Staples Large Mid Cap Index", "I:NQCN45LMN": "Nasdaq China Consumer Staples Large Mid Cap NTR Index", "I:NQCN45LMT": "Nasdaq China Consumer Staples Large Mid Cap TR Index", "I:NQCN45N": "Nasdaq China Consumer Staples NTR Index", "I:NQCN45T": "Nasdaq China Consumer Staples TR Index", "I:NQCN50": "Nasdaq China Industrials Index", "I:NQCN50LM": "Nasdaq China Industrials Large Mid Cap Index", "I:NQCN50LMN": "Nasdaq China Industrials Large Mid Cap NTR Index", "I:NQCN50LMT": "Nasdaq China Industrials Large Mid Cap TR Index", "I:NQCN50N": "Nasdaq China Industrials NTR Index", "I:NQCN50T": "Nasdaq China Industrials TR Index", "I:NQCN55": "Nasdaq China Basic Materials Index", "I:NQCN55LM": "Nasdaq China Basic Materials Large Mid Cap Index", "I:NQCN55LMN": "Nasdaq China Basic Materials Large Mid Cap NTR Index", "I:NQCN55LMT": "Nasdaq China Basic Materials Large Mid Cap TR Index", "I:NQCN55N": "Nasdaq China Basic Materials NTR Index", "I:NQCN55T": "Nasdaq China Basic Materials TR Index", "I:NQCN60": "Nasdaq China Energy Index", "I:NQCN60LM": "Nasdaq China Energy Large Mid Cap Index", "I:NQCN60LMN": "Nasdaq China Energy Large Mid Cap NTR Index", "I:NQCN60LMT": "Nasdaq China Energy Large Mid Cap TR Index", "I:NQCN60N": "Nasdaq China Energy NTR Index", "I:NQCN60T": "Nasdaq China Energy TR Index", "I:NQCN65": "NASDAQ China Utilities Index", "I:NQCN65LM": "Nasdaq China Utilities Large Mid Cap Index", "I:NQCN65LMN": "NASDAQ China Utilities Large Mid Cap NTR Index", "I:NQCN65LMT": "NASDAQ China Utilities Large Mid Cap TR Index", "I:NQCN65N": "NASDAQ China Utilities NTR Index", "I:NQCN65T": "NASDAQ China Utilities TR Index", "I:NQCNAN": "NASDAQ China A Shares NTR Index", "I:NQCNAP": "NASDAQ China A Shares Index", "I:NQCNAT": "NASDAQ China A Shares TR Index", "I:NQCNLC": "NASDAQ China Large Cap Index", "I:NQCNLCN": "NASDAQ China Large Cap NTR Index", "I:NQCNLCT": "NASDAQ China Large Cap TR Index", "I:NQCNLM": "NASDAQ China Large Mid Cap Index", "I:NQCNLMN": "NASDAQ China Large Mid Cap NTR Index", "I:NQCNLMT": "NASDAQ China Large Mid Cap TR Index", "I:NQCNMC": "NASDAQ China Mid Cap Index", "I:NQCNMCN": "NASDAQ China Mid Cap NTR Index", "I:NQCNMCT": "NASDAQ China Mid Cap TR Index", "I:NQCNN": "NASDAQ China NTR Index", "I:NQCNNEW": "Nasdaq Overseas China New Economy Top 50", "I:NQCNNEWCNY": "Nasdaq Overseas China New Economy Top 50 CNY", "I:NQCNNEWCNYN": "Nasdaq Overseas China New Economy Top 50 CNY NTR", "I:NQCNNEWCNYT": "Nasdaq Overseas China New Economy Top 50 CNY TR", "I:NQCNNEWHKD": "Nasdaq Overseas China New Economy Top 50 HKD", "I:NQCNNEWHKDN": "Nasdaq Overseas China New Economy Top 50 HKD NTR", "I:NQCNNEWHKDT": "Nasdaq Overseas China New Economy Top 50 HKD TR", "I:NQCNNEWN": "Nasdaq Overseas China New Economy Top 50 NTR", "I:NQCNNEWT": "Nasdaq Overseas China New Economy Top 50 TR", "I:NQCNSC": "NASDAQ China Small Cap Index", "I:NQCNSCN": "NASDAQ China Small Cap NTR Index", "I:NQCNSCT": "NASDAQ China Small Cap TR Index", "I:NQCNT": "NASDAQ China TR Index", "I:NQCO": "NASDAQ Colombia Index", "I:NQCO30": "NASDAQ Colombia Financials Index", "I:NQCO30LM": "Nasdaq Colombia Financials Large Mid Cap Index", "I:NQCO30LMN": "NASDAQ Colombia Financials Large Mid Cap NTR Index", "I:NQCO30LMT": "NASDAQ Colombia Financials Large Mid Cap TR Index", "I:NQCO30N": "NASDAQ Colombia Financials NTR Index", "I:NQCO30T": "NASDAQ Colombia Financials TR Index", "I:NQCO50": "Nasdaq Colombia Industrials Index", "I:NQCO50N": "Nasdaq Colombia Industrials NTR Index", "I:NQCO50T": "Nasdaq Colombia Industrials TR Index", "I:NQCOLC": "NASDAQ Colombia Large Cap Index", "I:NQCOLCN": "NASDAQ Colombia Large Cap NTR Index", "I:NQCOLCT": "NASDAQ Colombia Large Cap TR Index", "I:NQCOLM": "NASDAQ Colombia Large Mid Cap Index", "I:NQCOLMN": "NASDAQ Colombia Large Mid Cap NTR Index", "I:NQCOLMT": "NASDAQ Colombia Large Mid Cap TR Index", "I:NQCOMC": "NASDAQ Colombia Mid Cap Index", "I:NQCOMCN": "NASDAQ Colombia Mid Cap NTR Index", "I:NQCOMCT": "NASDAQ Colombia Mid Cap TR Index", "I:NQCON": "NASDAQ Colombia NTR Index", "I:NQCOT": "NASDAQ Colombia TR Index", "I:NQCYBR": "Nasdaq CTA Cybersecurity Index", "I:NQCYBRN": "Nasdaq CTA Cybersecurity Net Total Return Index", "I:NQCYBRT": "Nasdaq CTA Cybersecurity Total Return Index", "I:NQCZ": "NASDAQ Czech Republic Index", "I:NQCZN": "NASDAQ Czech Republic NTR Index", "I:NQCZT": "NASDAQ Czech Republic TR Index", "I:NQDACHK": "NASDAQ Chaikin Power US Dividend Achievers Index", "I:NQDACHKT": "NASDAQ Chaikin Power US Dividend Achievers TR", "I:NQDALI": "Nasdaq Dorsey Wright DALI1 Index", "I:NQDALIC": "Nasdaq Dorsey Wright DALI1 Commodity", "I:NQDALICT": "Nasdaq Dorsey Wright DALI1 Commodity TR", "I:NQDALIDE": "Nasdaq Dorsey Wright DALI1 Domestic Equity", "I:NQDALIDET": "Nasdaq Dorsey Wright DALI1 Domestic Equity TR", "I:NQDALIIE": "Nasdaq Dorsey Wright DALI1 Int'l Equity", "I:NQDALIIET": "Nasdaq Dorsey Wright DALI1 Int'l Equity TR", "I:NQDALIT": "Nasdaq Dorsey Wright DALI1 Total Return Index", "I:NQDE": "NASDAQ Germany Index", "I:NQDE10": "Nasdaq Germany Technology Index", "I:NQDE10LM": "Nasdaq Germany Technology Large Mid Cap Index", "I:NQDE10LMN": "Nasdaq Germany Technology Large Mid Cap NTR Index", "I:NQDE10LMT": "Nasdaq Germany Technology Large Mid Cap TR Index", "I:NQDE10N": "Nasdaq Germany Technology NTR Index", "I:NQDE10T": "Nasdaq Germany Technology TR Index", "I:NQDE20": "NASDAQ Germany Health Care Index", "I:NQDE20LM": "Nasdaq Germany Health Care Large Mid Cap Index", "I:NQDE20LMN": "NASDAQ Germany Health Care Large Mid Cap NTR Index", "I:NQDE20LMT": "NASDAQ Germany Health Care Large Mid Cap TR Index", "I:NQDE20N": "NASDAQ Germany Health Care NTR Index", "I:NQDE20T": "NASDAQ Germany Health Care TR Index", "I:NQDE30": "NASDAQ Germany Financials Index", "I:NQDE30LM": "Nasdaq Germany Financials Large Mid Cap Index", "I:NQDE30LMN": "NASDAQ Germany Financials Large Mid Cap NTR Index", "I:NQDE30LMT": "NASDAQ Germany Financials Large Mid Cap TR Index", "I:NQDE30N": "NASDAQ Germany Financials NTR Index", "I:NQDE30T": "NASDAQ Germany Financials TR Index", "I:NQDE35": "Nasdaq Germany Real Estate Index", "I:NQDE35LM": "Nasdaq Germany Real Estate Large Mid Cap Index", "I:NQDE35LMN": "Nasdaq Germany Real Estate Large Mid Cap NTR Index", "I:NQDE35LMT": "Nasdaq Germany Real Estate Large Mid Cap TR Index", "I:NQDE35N": "Nasdaq Germany Real Estate NTR Index", "I:NQDE35T": "Nasdaq Germany Real Estate TR Index", "I:NQDE40": "Nasdaq Germany Consumer Discretionary Index", "I:NQDE40LM": "Nasdaq Germany Consumer Discretionary Large Mid Cap Index", "I:NQDE40LMN": "Nasdaq Germany Consumer Discretionary Large Mid Cap NTR Index", "I:NQDE40LMT": "Nasdaq Germany Consumer Discretionary Large Mid Cap TR Index", "I:NQDE40N": "Nasdaq Germany Consumer Discretionary NTR Index", "I:NQDE40T": "Nasdaq Germany Consumer Discretionary TR Index", "I:NQDE45": "Nasdaq Germany Consumer Staples Index", "I:NQDE45N": "Nasdaq Germany Consumer Staples NTR Index", "I:NQDE45T": "Nasdaq Germany Consumer Staples TR Index", "I:NQDE50": "Nasdaq Germany Industrials Index", "I:NQDE50LM": "Nasdaq Germany Industrials Large Mid Cap Index", "I:NQDE50LMN": "Nasdaq Germany Industrials Large Mid Cap NTR Index", "I:NQDE50LMT": "Nasdaq Germany Industrials Large Mid Cap TR Index", "I:NQDE50N": "Nasdaq Germany Industrials NTR Index", "I:NQDE50T": "Nasdaq Germany Industrials TR Index", "I:NQDE55": "Nasdaq Germany Basic Materials Index", "I:NQDE55LM": "Nasdaq Germany Basic Materials Large Mid Cap Index", "I:NQDE55LMN": "Nasdaq Germany Basic Materials Large Mid Cap NTR Index", "I:NQDE55LMT": "Nasdaq Germany Basic Materials Large Mid Cap TR Index", "I:NQDE55N": "Nasdaq Germany Basic Materials NTR Index", "I:NQDE55T": "Nasdaq Germany Basic Materials TR Index", "I:NQDE60": "Nasdaq Germany Energy Index", "I:NQDE60N": "Nasdaq Germany Energy NTR Index", "I:NQDE60T": "Nasdaq Germany Energy TR Index", "I:NQDELC": "NASDAQ Germany Large Cap Index", "I:NQDELCN": "NASDAQ Germany Large Cap NTR Index", "I:NQDELCT": "NASDAQ Germany Large Cap TR Index", "I:NQDELM": "NASDAQ Germany Large Mid Cap Index", "I:NQDELMAUD": "NASDAQ Germany Large Mid Cap AUD Index", "I:NQDELMAUDN": "NASDAQ Germany Large Mid Cap AUD NTR Index", "I:NQDELMAUDT": "NASDAQ Germany Large Mid Cap AUD TR Index", "I:NQDELMCAD": "NASDAQ Germany Large Mid Cap CAD Index", "I:NQDELMCADN": "NASDAQ Germany Large Mid Cap CAD NTR Index", "I:NQDELMCADT": "NASDAQ Germany Large Mid Cap CAD TR Index", "I:NQDELMEUR": "NASDAQ Germany Large Mid Cap EUR Index", "I:NQDELMEURN": "NASDAQ Germany Large Mid Cap EUR NTR Index", "I:NQDELMEURT": "NASDAQ Germany Large Mid Cap EUR TR Index", "I:NQDELMGBP": "NASDAQ Germany Large Mid Cap GBP Index", "I:NQDELMGBPN": "NASDAQ Germany Large Mid Cap GBP NTR Index", "I:NQDELMGBPT": "NASDAQ Germany Large Mid Cap GBP TR Index", "I:NQDELMJPY": "NASDAQ Germany Large Mid Cap JPY Index", "I:NQDELMJPYN": "NASDAQ Germany Large Mid Cap JPY NTR Index", "I:NQDELMJPYT": "NASDAQ Germany Large Mid Cap JPY TR Index", "I:NQDELMN": "NASDAQ Germany Large Mid Cap NTR Index", "I:NQDELMT": "NASDAQ Germany Large Mid Cap TR Index", "I:NQDEMC": "NASDAQ Germany Mid Cap Index", "I:NQDEMCN": "NASDAQ Germany Mid Cap NTR Index", "I:NQDEMCT": "NASDAQ Germany Mid Cap TR Index", "I:NQDEN": "NASDAQ Germany NTR Index", "I:NQDESC": "NASDAQ Germany Small Cap Index", "I:NQDESCN": "NASDAQ Germany Small Cap NTR Index", "I:NQDESCT": "NASDAQ Germany Small Cap TR Index", "I:NQDET": "NASDAQ Germany TR Index", "I:NQDIVST": "The Dividend Strength Index", "I:NQDIVSTN": "The Dividend Strength Net Total Return Index", "I:NQDIVSTT": "The Dividend Strength Total Return Index", "I:NQDK": "NASDAQ Denmark Index", "I:NQDK20": "NASDAQ Denmark Health Care Index", "I:NQDK20LM": "Nasdaq Denmark Health Care Large Mid Cap Index", "I:NQDK20LMN": "NASDAQ Denmark Health Care Large Mid Cap NTR Index", "I:NQDK20LMT": "NASDAQ Denmark Health Care Large Mid Cap TR Index", "I:NQDK20N": "NASDAQ Denmark Health Care NTR Index", "I:NQDK20T": "NASDAQ Denmark Health Care TR Index", "I:NQDK30": "NASDAQ Denmark Financials Index", "I:NQDK30N": "NASDAQ Denmark Financials NTR Index", "I:NQDK30T": "NASDAQ Denmark Financials TR Index", "I:NQDK50": "Nasdaq Denmark Industrials Index", "I:NQDK50LM": "Nasdaq Denmark Industrials Large Mid Cap Index", "I:NQDK50LMN": "Nasdaq Denmark Industrials Large Mid Cap NTR Index", "I:NQDK50LMT": "Nasdaq Denmark Industrials Large Mid Cap TR Index", "I:NQDK50N": "Nasdaq Denmark Industrials NTR Index", "I:NQDK50T": "Nasdaq Denmark Industrials TR Index", "I:NQDKLC": "NASDAQ Denmark Large Cap Index", "I:NQDKLCN": "NASDAQ Denmark Large Cap NTR Index", "I:NQDKLCT": "NASDAQ Denmark Large Cap TR Index", "I:NQDKLM": "NASDAQ Denmark Large Mid Cap Index", "I:NQDKLMN": "NASDAQ Denmark Large Mid Cap NTR Index", "I:NQDKLMT": "NASDAQ Denmark Large Mid Cap TR Index", "I:NQDKMC": "NASDAQ Denmark Mid Cap Index", "I:NQDKMCN": "NASDAQ Denmark Mid Cap NTR Index", "I:NQDKMCT": "NASDAQ Denmark Mid Cap TR Index", "I:NQDKN": "NASDAQ Denmark NTR Index", "I:NQDKSC": "NASDAQ Denmark Small Cap Index", "I:NQDKSCN": "NASDAQ Denmark Small Cap NTR Index", "I:NQDKSCT": "NASDAQ Denmark Small Cap TR Index", "I:NQDKT": "NASDAQ Denmark TR Index", "I:NQDM": "NASDAQ Developed Markets Index", "I:NQDM10": "Nasdaq Developed Markets Technology Index", "I:NQDM10LM": "Nasdaq Developed Markets Technology Large Mid Cap Index", "I:NQDM10LMN": "Nasdaq Developed Markets Technology Large Mid Cap NTR Index", "I:NQDM10LMT": "Nasdaq Developed Markets Technology Large Mid Cap TR Index", "I:NQDM10N": "Nasdaq Developed Markets Technology NTR Index", "I:NQDM10T": "Nasdaq Developed Markets Technology TR Index", "I:NQDM15": "Nasdaq Developed Markets Telecommunications Index", "I:NQDM15LM": "Nasdaq Developed Markets Telecommunications Large Mid Cap Index", "I:NQDM15LMN": "Nasdaq Developed Markets Telecommunications Large Mid Cap NTR Index", "I:NQDM15LMT": "Nasdaq Developed Markets Telecommunications Large Mid Cap TR Index", "I:NQDM15N": "Nasdaq Developed Markets Telecommunications NTR Index", "I:NQDM15T": "Nasdaq Developed Markets Telecommunications TR Index", "I:NQDM20": "Nasdaq Developed Markets Health Care Index", "I:NQDM20LM": "Nasdaq Developed Markets Health Care Large Mid Cap Index", "I:NQDM20LMN": "Nasdaq Developed Markets Health Care Large Mid Cap NTR Index", "I:NQDM20LMT": "Nasdaq Developed Markets Health Care Large Mid Cap TR Index", "I:NQDM20N": "Nasdaq Developed Markets Health Care NTR Index", "I:NQDM20T": "Nasdaq Developed Markets Health Care TR Index", "I:NQDM30": "Nasdaq Developed Markets Financials Index", "I:NQDM3010": "Nasdaq Developed Markets Banks Index", "I:NQDM3010LM": "Nasdaq Developed Markets Banks Large Mid Cap Index", "I:NQDM3010LMN": "Nasdaq Developed Markets Banks Large Mid Cap NTR Index", "I:NQDM3010LMT": "Nasdaq Developed Markets Banks Large Mid Cap TR Index", "I:NQDM3010N": "Nasdaq Developed Markets Banks NTR Index", "I:NQDM3010T": "Nasdaq Developed Markets Banks TR Index", "I:NQDM3020": "Nasdaq Developed Markets Financial Services Index", "I:NQDM3020LM": "Nasdaq Developed Markets Financial Services Large Mid Cap Index", "I:NQDM3020LMN": "Nasdaq Developed Markets Financial Services Large Mid Cap NTR Index", "I:NQDM3020LMT": "Nasdaq Developed Markets Financial Services Large Mid Cap TR Index", "I:NQDM3020N": "Nasdaq Developed Markets Financial Services NTR Index", "I:NQDM3020T": "Nasdaq Developed Markets Financial Services TR Index", "I:NQDM3030": "Nasdaq Developed Markets Insurance Index", "I:NQDM3030LM": "Nasdaq Developed Markets Insurance Large Mid Cap Index", "I:NQDM3030LMN": "Nasdaq Developed Markets Insurance Large Mid Cap NTR Index", "I:NQDM3030LMT": "Nasdaq Developed Markets Insurance Large Mid Cap TR Index", "I:NQDM3030N": "Nasdaq Developed Markets Insurance NTR Index", "I:NQDM3030T": "Nasdaq Developed Markets Insurance TR Index", "I:NQDM30LM": "Nasdaq Developed Markets Financials Large Mid Cap Index", "I:NQDM30LMN": "Nasdaq Developed Markets Financials Large Mid Cap NTR Index", "I:NQDM30LMT": "Nasdaq Developed Markets Financials Large Mid Cap TR Index", "I:NQDM30N": "Nasdaq Developed Markets Financials NTR Index", "I:NQDM30T": "Nasdaq Developed Markets Financials TR Index", "I:NQDM35": "Nasdaq Developed Markets Real Estate Index", "I:NQDM35LM": "Nasdaq Developed Markets Real Estate Large Mid Cap Index", "I:NQDM35LMN": "Nasdaq Developed Markets Real Estate Large Mid Cap NTR Index", "I:NQDM35LMT": "Nasdaq Developed Markets Real Estate Large Mid Cap TR Index", "I:NQDM35N": "Nasdaq Developed Markets Real Estate NTR Index", "I:NQDM35T": "Nasdaq Developed Markets Real Estate TR Index", "I:NQDM40": "Nasdaq Developed Markets Consumer Discretionary Index", "I:NQDM4010": "Nasdaq Developed Markets Automobiles and Parts Index", "I:NQDM4010LM": "Nasdaq Developed Markets Automobiles and Parts Large Mid Cap Index", "I:NQDM4010LMN": "Nasdaq Developed Markets Automobiles and Parts Large Mid Cap NTR Index", "I:NQDM4010LMT": "Nasdaq Developed Markets Automobiles and Parts Large Mid Cap TR Index", "I:NQDM4010N": "Nasdaq Developed Markets Automobiles and Parts NTR Index", "I:NQDM4010T": "Nasdaq Developed Markets Automobiles and Parts TR Index", "I:NQDM4020": "Nasdaq Developed Markets Consumer Products and Services Index", "I:NQDM4020LM": "Nasdaq Developed Markets Consumer Products and Services Large Mid Cap Index", "I:NQDM4020LMN": "Nasdaq Developed Markets Consumer Products and Services Large Mid Cap NTR Index", "I:NQDM4020LMT": "Nasdaq Developed Markets Consumer Products and Services Large Mid Cap TR Index", "I:NQDM4020N": "Nasdaq Developed Markets Consumer Products and Services NTR Index", "I:NQDM4020T": "Nasdaq Developed Markets Consumer Products and Services TR Index", "I:NQDM4030": "Nasdaq Developed Markets Media Index", "I:NQDM4030LM": "Nasdaq Developed Markets Media Large Mid Cap Index", "I:NQDM4030LMN": "Nasdaq Developed Markets Media Large Mid Cap NTR Index", "I:NQDM4030LMT": "Nasdaq Developed Markets Media Large Mid Cap TR Index", "I:NQDM4030N": "Nasdaq Developed Markets Media NTR Index", "I:NQDM4030T": "Nasdaq Developed Markets Media TR Index", "I:NQDM4040": "Nasdaq Developed Markets Retail Index", "I:NQDM4040LM": "Nasdaq Developed Markets Retail Large Mid Cap Index", "I:NQDM4040LMN": "Nasdaq Developed Markets Retail Large Mid Cap NTR Index", "I:NQDM4040LMT": "Nasdaq Developed Markets Retail Large Mid Cap TR Index", "I:NQDM4040N": "Nasdaq Developed Markets Retail NTR Index", "I:NQDM4040T": "Nasdaq Developed Markets Retail TR Index", "I:NQDM4050": "Nasdaq Developed Markets Travel and Leisure Index", "I:NQDM4050LM": "Nasdaq Developed Markets Travel and Leisure Large Mid Cap Index", "I:NQDM4050LMN": "Nasdaq Developed Markets Travel and Leisure Large Mid Cap NTR Index", "I:NQDM4050LMT": "Nasdaq Developed Markets Travel and Leisure Large Mid Cap TR Index", "I:NQDM4050N": "Nasdaq Developed Markets Travel and Leisure NTR Index", "I:NQDM4050T": "Nasdaq Developed Markets Travel and Leisure TR Index", "I:NQDM40LM": "Nasdaq Developed Markets Consumer Discretionary Large Mid Cap Index", "I:NQDM40LMN": "Nasdaq Developed Markets Consumer Discretionary Large Mid Cap NTR Index", "I:NQDM40LMT": "Nasdaq Developed Markets Consumer Discretionary Large Mid Cap TR Index", "I:NQDM40N": "Nasdaq Developed Markets Consumer Discretionary NTR Index", "I:NQDM40T": "Nasdaq Developed Markets Consumer Discretionary TR Index", "I:NQDM45": "Nasdaq Developed Markets Consumer Staples Index", "I:NQDM4510": "Nasdaq Developed Markets Food, Beverage and Tobacco Index", "I:NQDM4510LM": "Nasdaq Developed Markets Food, Beverage and Tobacco Large Mid Cap Index", "I:NQDM4510LMN": "Nasdaq Developed Markets Food, Beverage and Tobacco Large Mid Cap NTR Index", "I:NQDM4510LMT": "Nasdaq Developed Markets Food, Beverage and Tobacco Large Mid Cap TR Index", "I:NQDM4510N": "Nasdaq Developed Markets Food, Beverage and Tobacco NTR Index", "I:NQDM4510T": "Nasdaq Developed Markets Food, Beverage and Tobacco TR Index", "I:NQDM4520": "Nasdaq Developed Markets Personal Care, Drug and Grocery Stores Index", "I:NQDM4520LM": "Nasdaq Developed Markets Personal Care, Drug and Grocery Stores Large Mid Cap Index", "I:NQDM4520LMN": "Nasdaq Developed Markets Personal Care, Drug and Grocery Stores Large Mid Cap NTR Index", "I:NQDM4520LMT": "Nasdaq Developed Markets Personal Care, Drug and Grocery Stores Large Mid Cap TR Index", "I:NQDM4520N": "Nasdaq Developed Markets Personal Care, Drug and Grocery Stores NTR Index", "I:NQDM4520T": "Nasdaq Developed Markets Personal Care, Drug and Grocery Stores TR Index", "I:NQDM45LM": "Nasdaq Developed Markets Consumer Staples Large Mid Cap Index", "I:NQDM45LMN": "Nasdaq Developed Markets Consumer Staples Large Mid Cap NTR Index", "I:NQDM45LMT": "Nasdaq Developed Markets Consumer Staples Large Mid Cap TR Index", "I:NQDM45N": "Nasdaq Developed Markets Consumer Staples NTR Index", "I:NQDM45T": "Nasdaq Developed Markets Consumer Staples TR Index", "I:NQDM50": "Nasdaq Developed Markets Industrials Index", "I:NQDM5010": "Nasdaq Developed Markets Construction and Materials Index", "I:NQDM5010LM": "Nasdaq Developed Markets Construction and Materials Large Mid Cap Index", "I:NQDM5010LMN": "Nasdaq Developed Markets Construction and Materials Large Mid Cap NTR Index", "I:NQDM5010LMT": "Nasdaq Developed Markets Construction and Materials Large Mid Cap TR Index", "I:NQDM5010N": "Nasdaq Developed Markets Construction and Materials NTR Index", "I:NQDM5010T": "Nasdaq Developed Markets Construction and Materials TR Index", "I:NQDM5020": "Nasdaq Developed Markets Industrial Goods and Services Index", "I:NQDM5020LM": "Nasdaq Developed Markets Industrial Goods and Services Large Mid Cap Index", "I:NQDM5020LMN": "Nasdaq Developed Markets Industrial Goods and Services Large Mid Cap NTR Index", "I:NQDM5020LMT": "Nasdaq Developed Markets Industrial Goods and Services Large Mid Cap TR Index", "I:NQDM5020N": "Nasdaq Developed Markets Industrial Goods and Services NTR Index", "I:NQDM5020T": "Nasdaq Developed Markets Industrial Goods and Services TR Index", "I:NQDM50LM": "Nasdaq Developed Markets Industrials Large Mid Cap Index", "I:NQDM50LMN": "Nasdaq Developed Markets Industrials Large Mid Cap NTR Index", "I:NQDM50LMT": "Nasdaq Developed Markets Industrials Large Mid Cap TR Index", "I:NQDM50N": "Nasdaq Developed Markets Industrials NTR Index", "I:NQDM50T": "Nasdaq Developed Markets Industrials TR Index", "I:NQDM55": "Nasdaq Developed Markets Basic Materials Index", "I:NQDM5510": "Nasdaq Developed Markets Basic Resources Index", "I:NQDM5510LM": "Nasdaq Developed Markets Basic Resources Large Mid Cap Index", "I:NQDM5510LMN": "Nasdaq Developed Markets Basic Resources Large Mid Cap NTR Index", "I:NQDM5510LMT": "Nasdaq Developed Markets Basic Resources Large Mid Cap TR Index", "I:NQDM5510N": "Nasdaq Developed Markets Basic Resources NTR Index", "I:NQDM5510T": "Nasdaq Developed Markets Basic Resources TR Index", "I:NQDM5520": "Nasdaq Developed Markets Chemicals Index", "I:NQDM5520LM": "Nasdaq Developed Markets Chemicals Large Mid Cap Index", "I:NQDM5520LMN": "Nasdaq Developed Markets Chemicals Large Mid Cap NTR Index", "I:NQDM5520LMT": "Nasdaq Developed Markets Chemicals Large Mid Cap TR Index", "I:NQDM5520N": "Nasdaq Developed Markets Chemicals NTR Index", "I:NQDM5520T": "Nasdaq Developed Markets Chemicals TR Index", "I:NQDM55LM": "Nasdaq Developed Markets Basic Materials Large Mid Cap Index", "I:NQDM55LMN": "Nasdaq Developed Markets Basic Materials Large Mid Cap NTR Index", "I:NQDM55LMT": "Nasdaq Developed Markets Basic Materials Large Mid Cap TR Index", "I:NQDM55N": "Nasdaq Developed Markets Basic Materials NTR Index", "I:NQDM55T": "Nasdaq Developed Markets Basic Materials TR Index", "I:NQDM60": "Nasdaq Developed Markets Energy Index", "I:NQDM60LM": "Nasdaq Developed Markets Energy Large Mid Cap Index", "I:NQDM60LMN": "Nasdaq Developed Markets Energy Large Mid Cap NTR Index", "I:NQDM60LMT": "Nasdaq Developed Markets Energy Large Mid Cap TR Index", "I:NQDM60N": "Nasdaq Developed Markets Energy NTR Index", "I:NQDM60T": "Nasdaq Developed Markets Energy TR Index", "I:NQDM65": "Nasdaq Developed Markets Utilities Index", "I:NQDM65LM": "Nasdaq Developed Markets Utilities Large Mid Cap Index", "I:NQDM65LMN": "Nasdaq Developed Markets Utilities Large Mid Cap NTR Index", "I:NQDM65LMT": "Nasdaq Developed Markets Utilities Large Mid Cap TR Index", "I:NQDM65N": "Nasdaq Developed Markets Utilities NTR Index", "I:NQDM65T": "Nasdaq Developed Markets Utilities TR Index", "I:NQDMASIA": "NASDAQ DM Asia Index", "I:NQDMASIA10": "Nasdaq DM Asia Technology Index", "I:NQDMASIA10LM": "Nasdaq DM Asia Technology Large Mid Cap Index", "I:NQDMASIA10LMN": "Nasdaq DM Asia Technology Large Mid Cap NTR Index", "I:NQDMASIA10LMT": "Nasdaq DM Asia Technology Large Mid Cap TR Index", "I:NQDMASIA10N": "Nasdaq DM Asia Technology NTR Index", "I:NQDMASIA10T": "Nasdaq DM Asia Technology TR Index", "I:NQDMASIA15": "Nasdaq DM Asia Telecommunications Index", "I:NQDMASIA15LM": "Nasdaq DM Asia Telecommunications Large Mid Cap Index", "I:NQDMASIA15LMN": "Nasdaq DM Asia Telecommunications Large Mid Cap NTR Index", "I:NQDMASIA15LMT": "Nasdaq DM Asia Telecommunications Large Mid Cap TR Index", "I:NQDMASIA15N": "Nasdaq DM Asia Telecommunications NTR Index", "I:NQDMASIA15T": "Nasdaq DM Asia Telecommunications TR Index", "I:NQDMASIA20": "NASDAQ DM Asia Health Care Index", "I:NQDMASIA20LM": "Nasdaq DM Asia Health Care Large Mid Cap Index", "I:NQDMASIA20LMN": "NASDAQ DM Asia Health Care Large Mid Cap NTR Index", "I:NQDMASIA20LMT": "NASDAQ DM Asia Health Care Large Mid Cap TR Index", "I:NQDMASIA20N": "NASDAQ DM Asia Health Care NTR Index", "I:NQDMASIA20T": "NASDAQ DM Asia Health Care TR Index", "I:NQDMASIA30": "NASDAQ DM Asia Financials Index", "I:NQDMASIA3010": "NASDAQ DM Asia Banks Index", "I:NQDMASIA3010LM": "Nasdaq DM Asia Banks Large Mid Cap Index", "I:NQDMASIA3010LMN": "NASDAQ DM Asia Banks Large Mid Cap NTR Index", "I:NQDMASIA3010LMT": "NASDAQ DM Asia Banks Large Mid Cap TR Index", "I:NQDMASIA3010N": "NASDAQ DM Asia Banks NTR Index", "I:NQDMASIA3010T": "NASDAQ DM Asia Banks TR Index", "I:NQDMASIA3020": "Nasdaq DM Asia Financial Services Index", "I:NQDMASIA3020LM": "Nasdaq DM Asia Financial Services Large Mid Cap Index", "I:NQDMASIA3020LMN": "Nasdaq DM Asia Financial Services Large Mid Cap NTR Index", "I:NQDMASIA3020LMT": "Nasdaq DM Asia Financial Services Large Mid Cap TR Index", "I:NQDMASIA3020N": "Nasdaq DM Asia Financial Services NTR Index", "I:NQDMASIA3020T": "Nasdaq DM Asia Financial Services TR Index", "I:NQDMASIA3030": "Nasdaq DM Asia Insurance Index", "I:NQDMASIA3030LM": "Nasdaq DM Asia Insurance Large Mid Cap Index", "I:NQDMASIA3030LMN": "Nasdaq DM Asia Insurance Large Mid Cap NTR Index", "I:NQDMASIA3030LMT": "Nasdaq DM Asia Insurance Large Mid Cap TR Index", "I:NQDMASIA3030N": "Nasdaq DM Asia Insurance NTR Index", "I:NQDMASIA3030T": "Nasdaq DM Asia Insurance TR Index", "I:NQDMASIA30LM": "Nasdaq DM Asia Financials Large Mid Cap Index", "I:NQDMASIA30LMN": "NASDAQ DM Asia Financials Large Mid Cap NTR Index", "I:NQDMASIA30LMT": "NASDAQ DM Asia Financials Large Mid Cap TR Index", "I:NQDMASIA30N": "NASDAQ DM Asia Financials NTR Index", "I:NQDMASIA30T": "NASDAQ DM Asia Financials TR Index", "I:NQDMASIA35": "NASDAQ DM Asia Real Estate Index", "I:NQDMASIA35LM": "Nasdaq DM Asia Real Estate Large Mid Cap Index", "I:NQDMASIA35LMN": "NASDAQ DM Asia Real Estate Large Mid Cap NTR Index", "I:NQDMASIA35LMT": "NASDAQ DM Asia Real Estate Large Mid Cap TR Index", "I:NQDMASIA35N": "NASDAQ DM Asia Real Estate NTR Index", "I:NQDMASIA35T": "NASDAQ DM Asia Real Estate TR Index", "I:NQDMASIA40": "Nasdaq DM Asia Consumer Discretionary Index", "I:NQDMASIA4010": "Nasdaq DM Asia Automobiles and Parts Index", "I:NQDMASIA4010LM": "Nasdaq DM Asia Automobiles and Parts Large Mid Cap Index", "I:NQDMASIA4010LMN": "Nasdaq DM Asia Automobiles and Parts Large Mid Cap NTR Index", "I:NQDMASIA4010LMT": "Nasdaq DM Asia Automobiles and Parts Large Mid Cap TR Index", "I:NQDMASIA4010N": "Nasdaq DM Asia Automobiles and Parts NTR Index", "I:NQDMASIA4010T": "Nasdaq DM Asia Automobiles and Parts TR Index", "I:NQDMASIA4020": "Nasdaq DM Asia Consumer Products and Services Index", "I:NQDMASIA4020LM": "Nasdaq DM Asia Consumer Products and Services Large Mid Cap Index", "I:NQDMASIA4020LMN": "Nasdaq DM Asia Consumer Products and Services Large Mid Cap NTR Index", "I:NQDMASIA4020LMT": "Nasdaq DM Asia Consumer Products and Services Large Mid Cap TR Index", "I:NQDMASIA4020N": "Nasdaq DM Asia Consumer Products and Services NTR Index", "I:NQDMASIA4020T": "Nasdaq DM Asia Consumer Products and Services TR Index", "I:NQDMASIA4030": "NASDAQ DM Asia Media Index", "I:NQDMASIA4030LM": "Nasdaq DM Asia Media Large Mid Cap Index", "I:NQDMASIA4030LMN": "NASDAQ DM Asia Media Large Mid Cap NTR Index", "I:NQDMASIA4030LMT": "NASDAQ DM Asia Media Large Mid Cap TR Index", "I:NQDMASIA4030N": "NASDAQ DM Asia Media NTR Index", "I:NQDMASIA4030T": "NASDAQ DM Asia Media TR Index", "I:NQDMASIA4040": "NASDAQ DM Asia Retail Index", "I:NQDMASIA4040LM": "Nasdaq DM Asia Retail Large Mid Cap Index", "I:NQDMASIA4040LMN": "NASDAQ DM Asia Retail Large Mid Cap NTR Index", "I:NQDMASIA4040LMT": "NASDAQ DM Asia Retail Large Mid Cap TR Index", "I:NQDMASIA4040N": "NASDAQ DM Asia Retail NTR Index", "I:NQDMASIA4040T": "NASDAQ DM Asia Retail TR Index", "I:NQDMASIA4050": "Nasdaq DM Asia Travel and Leisure Index", "I:NQDMASIA4050LM": "Nasdaq DM Asia Travel and Leisure Large Mid Cap Index", "I:NQDMASIA4050LMN": "Nasdaq DM Asia Travel and Leisure Large Mid Cap NTR Index", "I:NQDMASIA4050LMT": "Nasdaq DM Asia Travel and Leisure Large Mid Cap TR Index", "I:NQDMASIA4050N": "Nasdaq DM Asia Travel and Leisure NTR Index", "I:NQDMASIA4050T": "Nasdaq DM Asia Travel and Leisure TR Index", "I:NQDMASIA40LM": "Nasdaq DM Asia Consumer Discretionary Large Mid Cap Index", "I:NQDMASIA40LMN": "Nasdaq DM Asia Consumer Discretionary Large Mid Cap NTR Index", "I:NQDMASIA40LMT": "Nasdaq DM Asia Consumer Discretionary Large Mid Cap TR Index", "I:NQDMASIA40N": "Nasdaq DM Asia Consumer Discretionary NTR Index", "I:NQDMASIA40T": "Nasdaq DM Asia Consumer Discretionary TR Index", "I:NQDMASIA45": "Nasdaq DM Asia Consumer Staples Index", "I:NQDMASIA4510": "Nasdaq DM Asia Food, Beverage and Tobacco Index", "I:NQDMASIA4510LM": "Nasdaq DM Asia Food, Beverage and Tobacco Large Mid Cap Index", "I:NQDMASIA4510LMN": "Nasdaq DM Asia Food, Beverage and Tobacco Large Mid Cap NTR Index", "I:NQDMASIA4510LMT": "Nasdaq DM Asia Food, Beverage and Tobacco Large Mid Cap TR Index", "I:NQDMASIA4510N": "Nasdaq DM Asia Food, Beverage and Tobacco NTR Index", "I:NQDMASIA4510T": "Nasdaq DM Asia Food, Beverage and Tobacco TR Index", "I:NQDMASIA4520": "Nasdaq DM Asia Personal Care, Drug and Grocery Stores Index", "I:NQDMASIA4520LM": "Nasdaq DM Asia Personal Care, Drug and Grocery Stores Large Mid Cap Index", "I:NQDMASIA4520LMN": "Nasdaq DM Asia Personal Care, Drug and Grocery Stores Large Mid Cap NTR Index", "I:NQDMASIA4520LMT": "Nasdaq DM Asia Personal Care, Drug and Grocery Stores Large Mid Cap TR Index", "I:NQDMASIA4520N": "Nasdaq DM Asia Personal Care, Drug and Grocery Stores NTR Index", "I:NQDMASIA4520T": "Nasdaq DM Asia Personal Care, Drug and Grocery Stores TR Index", "I:NQDMASIA45LM": "Nasdaq DM Asia Consumer Staples Large Mid Cap Index", "I:NQDMASIA45LMN": "Nasdaq DM Asia Consumer Staples Large Mid Cap NTR Index", "I:NQDMASIA45LMT": "Nasdaq DM Asia Consumer Staples Large Mid Cap TR Index", "I:NQDMASIA45N": "Nasdaq DM Asia Consumer Staples NTR Index", "I:NQDMASIA45T": "Nasdaq DM Asia Consumer Staples TR Index", "I:NQDMASIA50": "Nasdaq DM Asia Industrials Index", "I:NQDMASIA5010": "Nasdaq DM Asia Construction and Materials Index", "I:NQDMASIA5010LM": "Nasdaq DM Asia Construction and Materials Large Mid Cap Index", "I:NQDMASIA5010LMN": "Nasdaq DM Asia Construction and Materials Large Mid Cap NTR Index", "I:NQDMASIA5010LMT": "Nasdaq DM Asia Construction and Materials Large Mid Cap TR Index", "I:NQDMASIA5010N": "Nasdaq DM Asia Construction and Materials NTR Index", "I:NQDMASIA5010T": "Nasdaq DM Asia Construction and Materials TR Index", "I:NQDMASIA5020": "Nasdaq DM Asia Industrial Goods and Services Index", "I:NQDMASIA5020LM": "Nasdaq DM Asia Industrial Goods and Services Large Mid Cap Index", "I:NQDMASIA5020LMN": "Nasdaq DM Asia Industrial Goods and Services Large Mid Cap NTR Index", "I:NQDMASIA5020LMT": "Nasdaq DM Asia Industrial Goods and Services Large Mid Cap TR Index", "I:NQDMASIA5020N": "Nasdaq DM Asia Industrial Goods and Services NTR Index", "I:NQDMASIA5020T": "Nasdaq DM Asia Industrial Goods and Services TR Index", "I:NQDMASIA50LM": "Nasdaq DM Asia Industrials Large Mid Cap Index", "I:NQDMASIA50LMN": "Nasdaq DM Asia Industrials Large Mid Cap NTR Index", "I:NQDMASIA50LMT": "Nasdaq DM Asia Industrials Large Mid Cap TR Index", "I:NQDMASIA50N": "Nasdaq DM Asia Industrials NTR Index", "I:NQDMASIA50T": "Nasdaq DM Asia Industrials TR Index", "I:NQDMASIA55": "Nasdaq DM Asia Basic Materials Index", "I:NQDMASIA5510": "NASDAQ DM Asia Basic Resources Index", "I:NQDMASIA5510LM": "Nasdaq DM Asia Basic Resources Large Mid Cap Index", "I:NQDMASIA5510LMN": "Nasdaq DM Asia Basic Resources Large Mid Cap NTR Index", "I:NQDMASIA5510LMT": "Nasdaq DM Asia Basic Resources Large Mid Cap TR Index", "I:NQDMASIA5510N": "NASDAQ DM Asia Basic Resources NTR Index", "I:NQDMASIA5510T": "NASDAQ DM Asia Basic Resources TR Index", "I:NQDMASIA5520": "NASDAQ DM Asia Chemicals Index", "I:NQDMASIA5520LM": "Nasdaq DM Asia Chemicals Large Mid Cap Index", "I:NQDMASIA5520LMN": "NASDAQ DM Asia Chemicals Large Mid Cap NTR Index", "I:NQDMASIA5520LMT": "NASDAQ DM Asia Chemicals Large Mid Cap TR Index", "I:NQDMASIA5520N": "NASDAQ DM Asia Chemicals NTR Index", "I:NQDMASIA5520T": "NASDAQ DM Asia Chemicals TR Index", "I:NQDMASIA55LM": "Nasdaq DM Asia Basic Materials Large Mid Cap Index", "I:NQDMASIA55LMN": "Nasdaq DM Asia Basic Materials Large Mid Cap NTR Index", "I:NQDMASIA55LMT": "Nasdaq DM Asia Basic Materials Large Mid Cap TR Index", "I:NQDMASIA55N": "Nasdaq DM Asia Basic Materials NTR Index", "I:NQDMASIA55T": "Nasdaq DM Asia Basic Materials TR Index", "I:NQDMASIA60": "Nasdaq DM Asia Energy Index", "I:NQDMASIA60LM": "Nasdaq DM Asia Energy Large Mid Cap Index", "I:NQDMASIA60LMN": "Nasdaq DM Asia Energy Large Mid Cap NTR Index", "I:NQDMASIA60LMT": "Nasdaq DM Asia Energy Large Mid Cap TR Index", "I:NQDMASIA60N": "Nasdaq DM Asia Energy NTR Index", "I:NQDMASIA60T": "Nasdaq DM Asia Energy TR Index", "I:NQDMASIA65": "NASDAQ DM Asia Utilities Index", "I:NQDMASIA65LM": "Nasdaq DM Asia Utilities Large Mid Cap Index", "I:NQDMASIA65LMN": "NASDAQ DM Asia Utilities Large Mid Cap NTR Index", "I:NQDMASIA65LMT": "NASDAQ DM Asia Utilities Large Mid Cap TR Index", "I:NQDMASIA65N": "NASDAQ DM Asia Utilities NTR Index", "I:NQDMASIA65T": "NASDAQ DM Asia Utilities TR Index", "I:NQDMASIALM": "NASDAQ DM Asia Large Mid Cap Index", "I:NQDMASIALMN": "NASDAQ DM Asia Large Mid Cap NTR Index", "I:NQDMASIALMT": "NASDAQ DM Asia Large Mid Cap TR Index", "I:NQDMASIAN": "NASDAQ DM Asia NTR Index", "I:NQDMASIAT": "NASDAQ DM Asia TR Index", "I:NQDMASPA": "NASDAQ DM ASPA Index", "I:NQDMASPA10": "Nasdaq DM ASPA Technology Index", "I:NQDMASPA10LM": "Nasdaq DM ASPA Technology Large Mid Cap Index", "I:NQDMASPA10LMN": "Nasdaq DM ASPA Technology Large Mid Cap NTR Index", "I:NQDMASPA10LMT": "Nasdaq DM ASPA Technology Large Mid Cap TR Index", "I:NQDMASPA10N": "Nasdaq DM ASPA Technology NTR Index", "I:NQDMASPA10T": "Nasdaq DM ASPA Technology TR Index", "I:NQDMASPA15": "Nasdaq DM ASPA Telecommunications Index", "I:NQDMASPA15LM": "Nasdaq DM ASPA Telecommunications Large Mid Cap Index", "I:NQDMASPA15LMN": "Nasdaq DM ASPA Telecommunications Large Mid Cap NTR Index", "I:NQDMASPA15LMT": "Nasdaq DM ASPA Telecommunications Large Mid Cap TR Index", "I:NQDMASPA15N": "Nasdaq DM ASPA Telecommunications NTR Index", "I:NQDMASPA15T": "Nasdaq DM ASPA Telecommunications TR Index", "I:NQDMASPA20": "NASDAQ DM ASPA Health Care Index", "I:NQDMASPA20LM": "Nasdaq DM ASPA Health Care Large Mid Cap Index", "I:NQDMASPA20LMN": "NASDAQ DM ASPA Health Care Large Mid Cap NTR Index", "I:NQDMASPA20LMT": "NASDAQ DM ASPA Health Care Large Mid Cap TR Index", "I:NQDMASPA20N": "NASDAQ DM ASPA Health Care NTR Index", "I:NQDMASPA20T": "NASDAQ DM ASPA Health Care TR Index", "I:NQDMASPA30": "NASDAQ DM ASPA Financials Index", "I:NQDMASPA3010": "NASDAQ DM ASPA Banks Index", "I:NQDMASPA3010LM": "Nasdaq DM ASPA Banks Large Mid Cap Index", "I:NQDMASPA3010LMN": "NASDAQ DM ASPA Banks Large Mid Cap NTR Index", "I:NQDMASPA3010LMT": "NASDAQ DM ASPA Banks Large Mid Cap TR Index", "I:NQDMASPA3010N": "NASDAQ DM ASPA Banks NTR Index", "I:NQDMASPA3010T": "NASDAQ DM ASPA Banks TR Index", "I:NQDMASPA3020": "Nasdaq DM ASPA Financial Services Index", "I:NQDMASPA3020LM": "Nasdaq DM ASPA Financial Services Large Mid Cap Index", "I:NQDMASPA3020LMN": "Nasdaq DM ASPA Financial Services Large Mid Cap NTR Index", "I:NQDMASPA3020LMT": "Nasdaq DM ASPA Financial Services Large Mid Cap TR Index", "I:NQDMASPA3020N": "Nasdaq DM ASPA Financial Services NTR Index", "I:NQDMASPA3020T": "Nasdaq DM ASPA Financial Services TR Index", "I:NQDMASPA3030": "Nasdaq DM ASPA Insurance Index", "I:NQDMASPA3030LM": "Nasdaq DM ASPA Insurance Large Mid Cap Index", "I:NQDMASPA3030LMN": "Nasdaq DM ASPA Insurance Large Mid Cap NTR Index", "I:NQDMASPA3030LMT": "Nasdaq DM ASPA Insurance Large Mid Cap TR Index", "I:NQDMASPA3030N": "Nasdaq DM ASPA Insurance NTR Index", "I:NQDMASPA3030T": "Nasdaq DM ASPA Insurance TR Index", "I:NQDMASPA30LM": "Nasdaq DM ASPA Financials Large Mid Cap Index", "I:NQDMASPA30LMN": "NASDAQ DM ASPA Financials Large Mid Cap NTR Index", "I:NQDMASPA30LMT": "NASDAQ DM ASPA Financials Large Mid Cap TR Index", "I:NQDMASPA30N": "NASDAQ DM ASPA Financials NTR Index", "I:NQDMASPA30T": "NASDAQ DM ASPA Financials TR Index", "I:NQDMASPA35": "NASDAQ DM ASPA Real Estate Index", "I:NQDMASPA35LM": "Nasdaq DM ASPA Real Estate Large Mid Cap Index", "I:NQDMASPA35LMN": "NASDAQ DM ASPA Real Estate Large Mid Cap NTR Index", "I:NQDMASPA35LMT": "NASDAQ DM ASPA Real Estate Large Mid Cap TR Index", "I:NQDMASPA35N": "NASDAQ DM ASPA Real Estate NTR Index", "I:NQDMASPA35T": "NASDAQ DM ASPA Real Estate TR Index", "I:NQDMASPA40": "Nasdaq DM ASPA Consumer Discretionary Index", "I:NQDMASPA4010": "Nasdaq DM ASPA Automobiles and Parts Index", "I:NQDMASPA4010LM": "Nasdaq DM ASPA Automobiles and Parts Large Mid Cap Index", "I:NQDMASPA4010LMN": "Nasdaq DM ASPA Automobiles and Parts Large Mid Cap NTR Index", "I:NQDMASPA4010LMT": "Nasdaq DM ASPA Automobiles and Parts Large Mid Cap TR Index", "I:NQDMASPA4010N": "Nasdaq DM ASPA Automobiles and Parts NTR Index", "I:NQDMASPA4010T": "Nasdaq DM ASPA Automobiles and Parts TR Index", "I:NQDMASPA4020": "Nasdaq DM ASPA Consumer Products and Services Index", "I:NQDMASPA4020LM": "Nasdaq DM ASPA Consumer Products and Services Large Mid Cap Index", "I:NQDMASPA4020LMN": "Nasdaq DM ASPA Consumer Products and Services Large Mid Cap NTR Index", "I:NQDMASPA4020LMT": "Nasdaq DM ASPA Consumer Products and Services Large Mid Cap TR Index", "I:NQDMASPA4020N": "Nasdaq DM ASPA Consumer Products and Services NTR Index", "I:NQDMASPA4020T": "Nasdaq DM ASPA Consumer Products and Services TR Index", "I:NQDMASPA4030": "NASDAQ DM ASPA Media Index", "I:NQDMASPA4030LM": "Nasdaq DM ASPA Media Large Mid Cap Index", "I:NQDMASPA4030LMN": "NASDAQ DM ASPA Media Large Mid Cap NTR Index", "I:NQDMASPA4030LMT": "NASDAQ DM ASPA Media Large Mid Cap TR Index", "I:NQDMASPA4030N": "NASDAQ DM ASPA Media NTR Index", "I:NQDMASPA4030T": "NASDAQ DM ASPA Media TR Index", "I:NQDMASPA4040": "NASDAQ DM ASPA Retail Index", "I:NQDMASPA4040LM": "Nasdaq DM ASPA Retail Large Mid Cap Index", "I:NQDMASPA4040LMN": "NASDAQ DM ASPA Retail Large Mid Cap NTR Index", "I:NQDMASPA4040LMT": "NASDAQ DM ASPA Retail Large Mid Cap TR Index", "I:NQDMASPA4040N": "NASDAQ DM ASPA Retail NTR Index", "I:NQDMASPA4040T": "NASDAQ DM ASPA Retail TR Index", "I:NQDMASPA4050": "Nasdaq DM ASPA Travel and Leisure Index", "I:NQDMASPA4050LM": "Nasdaq DM ASPA Travel and Leisure Large Mid Cap Index", "I:NQDMASPA4050LMN": "Nasdaq DM ASPA Travel and Leisure Large Mid Cap NTR Index", "I:NQDMASPA4050LMT": "Nasdaq DM ASPA Travel and Leisure Large Mid Cap TR Index", "I:NQDMASPA4050N": "Nasdaq DM ASPA Travel and Leisure NTR Index", "I:NQDMASPA4050T": "Nasdaq DM ASPA Travel and Leisure TR Index", "I:NQDMASPA40LM": "Nasdaq DM ASPA Consumer Discretionary Large Mid Cap Index", "I:NQDMASPA40LMN": "Nasdaq DM ASPA Consumer Discretionary Large Mid Cap NTR Index", "I:NQDMASPA40LMT": "Nasdaq DM ASPA Consumer Discretionary Large Mid Cap TR Index", "I:NQDMASPA40N": "Nasdaq DM ASPA Consumer Discretionary NTR Index", "I:NQDMASPA40T": "Nasdaq DM ASPA Consumer Discretionary TR Index", "I:NQDMASPA45": "Nasdaq DM ASPA Consumer Staples Index", "I:NQDMASPA4510": "Nasdaq DM ASPA Food, Beverage and Tobacco Index", "I:NQDMASPA4510LM": "Nasdaq DM ASPA Food, Beverage and Tobacco Large Mid Cap Index", "I:NQDMASPA4510LMN": "Nasdaq DM ASPA Food, Beverage and Tobacco Large Mid Cap NTR Index", "I:NQDMASPA4510LMT": "Nasdaq DM ASPA Food, Beverage and Tobacco Large Mid Cap TR Index", "I:NQDMASPA4510N": "Nasdaq DM ASPA Food, Beverage and Tobacco NTR Index", "I:NQDMASPA4510T": "Nasdaq DM ASPA Food, Beverage and Tobacco TR Index", "I:NQDMASPA4520": "Nasdaq DM ASPA Personal Care, Drug and Grocery Stores Index", "I:NQDMASPA4520LM": "Nasdaq DM ASPA Personal Care, Drug and Grocery Stores Large Mid Cap Index", "I:NQDMASPA4520LMN": "Nasdaq DM ASPA Personal Care, Drug and Grocery Stores Large Mid Cap NTR Index", "I:NQDMASPA4520LMT": "Nasdaq DM ASPA Personal Care, Drug and Grocery Stores Large Mid Cap TR Index", "I:NQDMASPA4520N": "Nasdaq DM ASPA Personal Care, Drug and Grocery Stores NTR Index", "I:NQDMASPA4520T": "Nasdaq DM ASPA Personal Care, Drug and Grocery Stores TR Index", "I:NQDMASPA45LM": "Nasdaq DM ASPA Consumer Staples Large Mid Cap Index", "I:NQDMASPA45LMN": "Nasdaq DM ASPA Consumer Staples Large Mid Cap NTR Index", "I:NQDMASPA45LMT": "Nasdaq DM ASPA Consumer Staples Large Mid Cap TR Index", "I:NQDMASPA45N": "Nasdaq DM ASPA Consumer Staples NTR Index", "I:NQDMASPA45T": "Nasdaq DM ASPA Consumer Staples TR Index", "I:NQDMASPA50": "Nasdaq DM ASPA Industrials Index", "I:NQDMASPA5010": "Nasdaq DM ASPA Construction and Materials Index", "I:NQDMASPA5010LM": "Nasdaq DM ASPA Construction and Materials Large Mid Cap Index", "I:NQDMASPA5010LMN": "Nasdaq DM ASPA Construction and Materials Large Mid Cap NTR Index", "I:NQDMASPA5010LMT": "Nasdaq DM ASPA Construction and Materials Large Mid Cap TR Index", "I:NQDMASPA5010N": "Nasdaq DM ASPA Construction and Materials NTR Index", "I:NQDMASPA5010T": "Nasdaq DM ASPA Construction and Materials TR Index", "I:NQDMASPA5020": "Nasdaq DM ASPA Industrial Goods and Services Index", "I:NQDMASPA5020LM": "Nasdaq DM ASPA Industrial Goods and Services Large Mid Cap Index", "I:NQDMASPA5020LMN": "Nasdaq DM ASPA Industrial Goods and Services Large Mid Cap NTR Index", "I:NQDMASPA5020LMT": "Nasdaq DM ASPA Industrial Goods and Services Large Mid Cap TR Index", "I:NQDMASPA5020N": "Nasdaq DM ASPA Industrial Goods and Services NTR Index", "I:NQDMASPA5020T": "Nasdaq DM ASPA Industrial Goods and Services TR Index", "I:NQDMASPA50LM": "Nasdaq DM ASPA Industrials Large Mid Cap Index", "I:NQDMASPA50LMN": "Nasdaq DM ASPA Industrials Large Mid Cap NTR Index", "I:NQDMASPA50LMT": "Nasdaq DM ASPA Industrials Large Mid Cap TR Index", "I:NQDMASPA50N": "Nasdaq DM ASPA Industrials NTR Index", "I:NQDMASPA50T": "Nasdaq DM ASPA Industrials TR Index", "I:NQDMASPA55": "Nasdaq DM ASPA Basic Materials Index", "I:NQDMASPA5510": "NASDAQ DM ASPA Basic Resources Index", "I:NQDMASPA5510LM": "Nasdaq DM ASPA Basic Resources Large Mid Cap Index", "I:NQDMASPA5510LMN": "Nasdaq DM ASPA Basic Resources Large Mid Cap NTR Index", "I:NQDMASPA5510LMT": "Nasdaq DM ASPA Basic Resources Large Mid Cap TR Index", "I:NQDMASPA5510N": "NASDAQ DM ASPA Basic Resources NTR Index", "I:NQDMASPA5510T": "NASDAQ DM ASPA Basic Resources TR Index", "I:NQDMASPA5520": "NASDAQ DM ASPA Chemicals Index", "I:NQDMASPA5520LM": "Nasdaq DM ASPA Chemicals Large Mid Cap Index", "I:NQDMASPA5520LMN": "NASDAQ DM ASPA Chemicals Large Mid Cap NTR Index", "I:NQDMASPA5520LMT": "NASDAQ DM ASPA Chemicals Large Mid Cap TR Index", "I:NQDMASPA5520N": "NASDAQ DM ASPA Chemicals NTR Index", "I:NQDMASPA5520T": "NASDAQ DM ASPA Chemicals TR Index", "I:NQDMASPA55LM": "Nasdaq DM ASPA Basic Materials Large Mid Cap Index", "I:NQDMASPA55LMN": "Nasdaq DM ASPA Basic Materials Large Mid Cap NTR Index", "I:NQDMASPA55LMT": "Nasdaq DM ASPA Basic Materials Large Mid Cap TR Index", "I:NQDMASPA55N": "Nasdaq DM ASPA Basic Materials NTR Index", "I:NQDMASPA55T": "Nasdaq DM ASPA Basic Materials TR Index", "I:NQDMASPA60": "Nasdaq DM ASPA Energy Index", "I:NQDMASPA60LM": "Nasdaq DM ASPA Energy Large Mid Cap Index", "I:NQDMASPA60LMN": "Nasdaq DM ASPA Energy Large Mid Cap NTR Index", "I:NQDMASPA60LMT": "Nasdaq DM ASPA Energy Large Mid Cap TR Index", "I:NQDMASPA60N": "Nasdaq DM ASPA Energy NTR Index", "I:NQDMASPA60T": "Nasdaq DM ASPA Energy TR Index", "I:NQDMASPA65": "NASDAQ DM ASPA Utilities Index", "I:NQDMASPA65LM": "Nasdaq DM ASPA Utilities Large Mid Cap Index", "I:NQDMASPA65LMN": "NASDAQ DM ASPA Utilities Large Mid Cap NTR Index", "I:NQDMASPA65LMT": "NASDAQ DM ASPA Utilities Large Mid Cap TR Index", "I:NQDMASPA65N": "NASDAQ DM ASPA Utilities NTR Index", "I:NQDMASPA65T": "NASDAQ DM ASPA Utilities TR Index", "I:NQDMASPALC": "NASDAQ DM ASPA Large Cap Index", "I:NQDMASPALCN": "NASDAQ DM ASPA Large Cap NTR Index", "I:NQDMASPALCT": "NASDAQ DM ASPA Large Cap TR Index", "I:NQDMASPALM": "NASDAQ DM ASPA Large Mid Cap Index", "I:NQDMASPALMN": "NASDAQ DM ASPA Large Mid Cap NTR Index", "I:NQDMASPALMT": "NASDAQ DM ASPA Large Mid Cap TR Index", "I:NQDMASPAMC": "NASDAQ DM ASPA Mid Cap Index", "I:NQDMASPAMCN": "NASDAQ DM ASPA Mid Cap NTR Index", "I:NQDMASPAMCT": "NASDAQ DM ASPA Mid Cap TR Index", "I:NQDMASPAN": "NASDAQ DM ASPA NTR Index", "I:NQDMASPASC": "NASDAQ DM ASPA Small Cap Index", "I:NQDMASPASCN": "NASDAQ DM ASPA Small Cap NTR Index", "I:NQDMASPASCT": "NASDAQ DM ASPA Small Cap TR Index", "I:NQDMASPAT": "NASDAQ DM ASPA TR Index", "I:NQDMASPAXJP": "Nasdaq DM ASPA Ex Japan Index", "I:NQDMASPAXJPLC": "Nasdaq DM ASPA Ex Japan Large Cap", "I:NQDMASPAXJPLCN": "Nasdaq DM ASPA Ex Japan Large Cap NTR", "I:NQDMASPAXJPLCT": "Nasdaq DM ASPA Ex Japan Large Cap TR", "I:NQDMASPAXJPLM": "Nasdaq DM ASPA Ex Japan Large Mid Cap", "I:NQDMASPAXJPLMN": "Nasdaq DM ASPA Ex Japan Large Mid Cap NTR", "I:NQDMASPAXJPLMT": "Nasdaq DM ASPA Ex Japan Large Mid Cap TR", "I:NQDMASPAXJPMC": "Nasdaq DM ASPA Ex Japan Mid Cap", "I:NQDMASPAXJPMCN": "Nasdaq DM ASPA Ex Japan Mid Cap NTR", "I:NQDMASPAXJPMCT": "Nasdaq DM ASPA Ex Japan Mid Cap TR", "I:NQDMASPAXJPN": "Nasdaq DM ASPA Ex Japan NTR", "I:NQDMASPAXJPSC": "Nasdaq DM ASPA Ex Japan Small Cap", "I:NQDMASPAXJPSCN": "Nasdaq DM ASPA Ex Japan Small Cap NTR", "I:NQDMASPAXJPSCT": "Nasdaq DM ASPA Ex Japan Small Cap TR", "I:NQDMASPAXJPT": "Nasdaq DM ASPA Ex Japan TR", "I:NQDMEU": "NASDAQ DM Europe Index", "I:NQDMEU10": "Nasdaq DM Europe Technology Index", "I:NQDMEU10LM": "Nasdaq DM Europe Technology Large Mid Cap Index", "I:NQDMEU10LMN": "Nasdaq DM Europe Technology Large Mid Cap NTR Index", "I:NQDMEU10LMT": "Nasdaq DM Europe Technology Large Mid Cap TR Index", "I:NQDMEU10N": "Nasdaq DM Europe Technology NTR Index", "I:NQDMEU10T": "Nasdaq DM Europe Technology TR Index", "I:NQDMEU15": "Nasdaq DM Europe Telecommunications Index", "I:NQDMEU15LM": "Nasdaq DM Europe Telecommunications Large Mid Cap Index", "I:NQDMEU15LMN": "Nasdaq DM Europe Telecommunications Large Mid Cap NTR Index", "I:NQDMEU15LMT": "Nasdaq DM Europe Telecommunications Large Mid Cap TR Index", "I:NQDMEU15N": "Nasdaq DM Europe Telecommunications NTR Index", "I:NQDMEU15T": "Nasdaq DM Europe Telecommunications TR Index", "I:NQDMEU20": "NASDAQ DM Europe Health Care Index", "I:NQDMEU20LM": "Nasdaq DM Europe Health Care Large Mid Cap Index", "I:NQDMEU20LMN": "Nasdaq DM Europe Health Care Large Mid Cap NTR Index", "I:NQDMEU20LMT": "Nasdaq DM Europe Health Care Large Mid Cap TR Index", "I:NQDMEU20N": "NASDAQ DM Europe Health Care NTR Index", "I:NQDMEU20T": "NASDAQ DM Europe Health Care TR Index", "I:NQDMEU30": "NASDAQ DM Europe Financials Index", "I:NQDMEU3010": "NASDAQ DM Europe Banks Index", "I:NQDMEU3010LM": "Nasdaq DM Europe Banks Large Mid Cap Index", "I:NQDMEU3010LMN": "NASDAQ DM Europe Banks Large Mid Cap NTR Index", "I:NQDMEU3010LMT": "NASDAQ DM Europe Banks Large Mid Cap TR Index", "I:NQDMEU3010N": "NASDAQ DM Europe Banks NTR Index", "I:NQDMEU3010T": "NASDAQ DM Europe Banks TR Index", "I:NQDMEU3020": "Nasdaq DM Europe Financial Services Index", "I:NQDMEU3020LM": "Nasdaq DM Europe Financial Services Large Mid Cap Index", "I:NQDMEU3020LMN": "Nasdaq DM Europe Financial Services Large Mid Cap NTR Index", "I:NQDMEU3020LMT": "Nasdaq DM Europe Financial Services Large Mid Cap TR Index", "I:NQDMEU3020N": "Nasdaq DM Europe Financial Services NTR Index", "I:NQDMEU3020T": "Nasdaq DM Europe Financial Services TR Index", "I:NQDMEU3030": "Nasdaq DM Europe Insurance Index", "I:NQDMEU3030LM": "Nasdaq DM Europe Insurance Large Mid Cap Index", "I:NQDMEU3030LMN": "Nasdaq DM Europe Insurance Large Mid Cap NTR Index", "I:NQDMEU3030LMT": "Nasdaq DM Europe Insurance Large Mid Cap TR Index", "I:NQDMEU3030N": "Nasdaq DM Europe Insurance NTR Index", "I:NQDMEU3030T": "Nasdaq DM Europe Insurance TR Index", "I:NQDMEU30LM": "Nasdaq DM Europe Financials Large Mid Cap Index", "I:NQDMEU30LMN": "Nasdaq DM Europe Financials Large Mid Cap NTR Index", "I:NQDMEU30LMT": "Nasdaq DM Europe Financials Large Mid Cap TR Index", "I:NQDMEU30N": "NASDAQ DM Europe Financials NTR Index", "I:NQDMEU30T": "NASDAQ DM Europe Financials TR Index", "I:NQDMEU35": "NASDAQ DM Europe Real Estate Index", "I:NQDMEU35LM": "Nasdaq DM Europe Real Estate Large Mid Cap Index", "I:NQDMEU35LMN": "Nasdaq DM Europe Real Estate Large Mid Cap NTR Index", "I:NQDMEU35LMT": "Nasdaq DM Europe Real Estate Large Mid Cap TR Index", "I:NQDMEU35N": "NASDAQ DM Europe Real Estate NTR Index", "I:NQDMEU35T": "NASDAQ DM Europe Real Estate TR Index", "I:NQDMEU40": "Nasdaq DM Europe Consumer Discretionary Index", "I:NQDMEU4010": "Nasdaq DM Europe Automobiles and Parts Index", "I:NQDMEU4010LM": "Nasdaq DM Europe Automobiles and Parts Large Mid Cap Index", "I:NQDMEU4010LMN": "Nasdaq DM Europe Automobiles and Parts Large Mid Cap NTR Index", "I:NQDMEU4010LMT": "Nasdaq DM Europe Automobiles and Parts Large Mid Cap TR Index", "I:NQDMEU4010N": "Nasdaq DM Europe Automobiles and Parts NTR Index", "I:NQDMEU4010T": "Nasdaq DM Europe Automobiles and Parts TR Index", "I:NQDMEU4020": "Nasdaq DM Europe Consumer Products and Services Index", "I:NQDMEU4020LM": "Nasdaq DM Europe Consumer Products and Services Large Mid Cap Index", "I:NQDMEU4020LMN": "Nasdaq DM Europe Consumer Products and Services Large Mid Cap NTR Index", "I:NQDMEU4020LMT": "Nasdaq DM Europe Consumer Products and Services Large Mid Cap TR Index", "I:NQDMEU4020N": "Nasdaq DM Europe Consumer Products and Services NTR Index", "I:NQDMEU4020T": "Nasdaq DM Europe Consumer Products and Services TR Index", "I:NQDMEU4030": "NASDAQ DM Europe Media Index", "I:NQDMEU4030LM": "Nasdaq DM Europe Media Large Mid Cap Index", "I:NQDMEU4030LMN": "NASDAQ DM Europe Media Large Mid Cap NTR Index", "I:NQDMEU4030LMT": "NASDAQ DM Europe Media Large Mid Cap TR Index", "I:NQDMEU4030N": "NASDAQ DM Europe Media NTR Index", "I:NQDMEU4030T": "NASDAQ DM Europe Media TR Index", "I:NQDMEU4040": "NASDAQ DM Europe Retail Index", "I:NQDMEU4040LM": "Nasdaq DM Europe Retail Large Mid Cap Index", "I:NQDMEU4040LMN": "NASDAQ DM Europe Retail Large Mid Cap NTR Index", "I:NQDMEU4040LMT": "NASDAQ DM Europe Retail Large Mid Cap TR Index", "I:NQDMEU4040N": "NASDAQ DM Europe Retail NTR Index", "I:NQDMEU4040T": "NASDAQ DM Europe Retail TR Index", "I:NQDMEU4050": "Nasdaq DM Europe Travel and Leisure Index", "I:NQDMEU4050LM": "Nasdaq DM Europe Travel and Leisure Large Mid Cap Index", "I:NQDMEU4050LMN": "Nasdaq DM Europe Travel and Leisure Large Mid Cap NTR Index", "I:NQDMEU4050LMT": "Nasdaq DM Europe Travel and Leisure Large Mid Cap TR Index", "I:NQDMEU4050N": "Nasdaq DM Europe Travel and Leisure NTR Index", "I:NQDMEU4050T": "Nasdaq DM Europe Travel and Leisure TR Index", "I:NQDMEU40LM": "Nasdaq DM Europe Consumer Discretionary Large Mid Cap Index", "I:NQDMEU40LMN": "Nasdaq DM Europe Consumer Discretionary Large Mid Cap NTR Index", "I:NQDMEU40LMT": "Nasdaq DM Europe Consumer Discretionary Large Mid Cap TR Index", "I:NQDMEU40N": "Nasdaq DM Europe Consumer Discretionary NTR Index", "I:NQDMEU40T": "Nasdaq DM Europe Consumer Discretionary TR Index", "I:NQDMEU45": "Nasdaq DM Europe Consumer Staples Index", "I:NQDMEU4510": "Nasdaq DM Europe Food, Beverage and Tobacco Index", "I:NQDMEU4510LM": "Nasdaq DM Europe Food, Beverage and Tobacco Large Mid Cap Index", "I:NQDMEU4510LMN": "Nasdaq DM Europe Food, Beverage and Tobacco Large Mid Cap NTR Index", "I:NQDMEU4510LMT": "Nasdaq DM Europe Food, Beverage and Tobacco Large Mid Cap TR Index", "I:NQDMEU4510N": "Nasdaq DM Europe Food, Beverage and Tobacco NTR Index", "I:NQDMEU4510T": "Nasdaq DM Europe Food, Beverage and Tobacco TR Index", "I:NQDMEU4520": "Nasdaq DM Europe Personal Care, Drug and Grocery Stores Index", "I:NQDMEU4520LM": "Nasdaq DM Europe Personal Care, Drug and Grocery Stores Large Mid Cap Index", "I:NQDMEU4520LMN": "Nasdaq DM Europe Personal Care, Drug and Grocery Stores Large Mid Cap NTR Index", "I:NQDMEU4520LMT": "Nasdaq DM Europe Personal Care, Drug and Grocery Stores Large Mid Cap TR Index", "I:NQDMEU4520N": "Nasdaq DM Europe Personal Care, Drug and Grocery Stores NTR Index", "I:NQDMEU4520T": "Nasdaq DM Europe Personal Care, Drug and Grocery Stores TR Index", "I:NQDMEU45LM": "Nasdaq DM Europe Consumer Staples Large Mid Cap Index", "I:NQDMEU45LMN": "Nasdaq DM Europe Consumer Staples Large Mid Cap NTR Index", "I:NQDMEU45LMT": "Nasdaq DM Europe Consumer Staples Large Mid Cap TR Index", "I:NQDMEU45N": "Nasdaq DM Europe Consumer Staples NTR Index", "I:NQDMEU45T": "Nasdaq DM Europe Consumer Staples TR Index", "I:NQDMEU50": "Nasdaq DM Europe Industrials Index", "I:NQDMEU5010": "Nasdaq DM Europe Construction and Materials Index", "I:NQDMEU5010LM": "Nasdaq DM Europe Construction and Materials Large Mid Cap Index", "I:NQDMEU5010LMN": "Nasdaq DM Europe Construction and Materials Large Mid Cap NTR Index", "I:NQDMEU5010LMT": "Nasdaq DM Europe Construction and Materials Large Mid Cap TR Index", "I:NQDMEU5010N": "Nasdaq DM Europe Construction and Materials NTR Index", "I:NQDMEU5010T": "Nasdaq DM Europe Construction and Materials TR Index", "I:NQDMEU5020": "Nasdaq DM Europe Industrial Goods and Services Index", "I:NQDMEU5020LM": "Nasdaq DM Europe Industrial Goods and Services Large Mid Cap Index", "I:NQDMEU5020LMN": "Nasdaq DM Europe Industrial Goods and Services Large Mid Cap NTR Index", "I:NQDMEU5020LMT": "Nasdaq DM Europe Industrial Goods and Services Large Mid Cap TR Index", "I:NQDMEU5020N": "Nasdaq DM Europe Industrial Goods and Services NTR Index", "I:NQDMEU5020T": "Nasdaq DM Europe Industrial Goods and Services TR Index", "I:NQDMEU50LM": "Nasdaq DM Europe Industrials Large Mid Cap Index", "I:NQDMEU50LMN": "Nasdaq DM Europe Industrials Large Mid Cap NTR Index", "I:NQDMEU50LMT": "Nasdaq DM Europe Industrials Large Mid Cap TR Index", "I:NQDMEU50N": "Nasdaq DM Europe Industrials NTR Index", "I:NQDMEU50T": "Nasdaq DM Europe Industrials TR Index", "I:NQDMEU55": "Nasdaq DM Europe Basic Materials Index", "I:NQDMEU5510": "NASDAQ DM Europe Basic Resources Index", "I:NQDMEU5510LM": "Nasdaq DM Europe Basic Resources Large Mid Cap Index", "I:NQDMEU5510LMN": "Nasdaq DM Europe Basic Resources Large Mid Cap NTR Index", "I:NQDMEU5510LMT": "Nasdaq DM Europe Basic Resources Large Mid Cap TR Index", "I:NQDMEU5510N": "NASDAQ DM Europe Basic Resources NTR Index", "I:NQDMEU5510T": "NASDAQ DM Europe Basic Resources TR Index", "I:NQDMEU5520": "NASDAQ DM Europe Chemicals Index", "I:NQDMEU5520LM": "Nasdaq DM Europe Chemicals Large Mid Cap Index", "I:NQDMEU5520LMN": "NASDAQ DM Europe Chemicals Large Mid Cap NTR Index", "I:NQDMEU5520LMT": "NASDAQ DM Europe Chemicals Large Mid Cap TR Index", "I:NQDMEU5520N": "NASDAQ DM Europe Chemicals NTR Index", "I:NQDMEU5520T": "NASDAQ DM Europe Chemicals TR Index", "I:NQDMEU55LM": "Nasdaq DM Europe Basic Materials Large Mid Cap Index", "I:NQDMEU55LMN": "Nasdaq DM Europe Basic Materials Large Mid Cap NTR Index", "I:NQDMEU55LMT": "Nasdaq DM Europe Basic Materials Large Mid Cap TR Index", "I:NQDMEU55N": "Nasdaq DM Europe Basic Materials NTR Index", "I:NQDMEU55T": "Nasdaq DM Europe Basic Materials TR Index", "I:NQDMEU60": "Nasdaq DM Europe Energy Index", "I:NQDMEU60LM": "Nasdaq DM Europe Energy Large Mid Cap Index", "I:NQDMEU60LMN": "Nasdaq DM Europe Energy Large Mid Cap NTR Index", "I:NQDMEU60LMT": "Nasdaq DM Europe Energy Large Mid Cap TR Index", "I:NQDMEU60N": "Nasdaq DM Europe Energy NTR Index", "I:NQDMEU60T": "Nasdaq DM Europe Energy TR Index", "I:NQDMEU65": "NASDAQ DM Europe Utilities Index", "I:NQDMEU65LM": "Nasdaq DM Europe Utilities Large Mid Cap Index", "I:NQDMEU65LMN": "NASDAQ DM Europe Utilities Large Mid Cap NTR Index", "I:NQDMEU65LMT": "NASDAQ DM Europe Utilities Large Mid Cap TR Index", "I:NQDMEU65N": "NASDAQ DM Europe Utilities NTR Index", "I:NQDMEU65T": "NASDAQ DM Europe Utilities TR Index", "I:NQDMEULC": "NASDAQ DM Europe Large Cap Index", "I:NQDMEULCN": "NASDAQ DM Europe Large Cap NTR Index", "I:NQDMEULCT": "NASDAQ DM Europe Large Cap TR Index", "I:NQDMEULM": "NASDAQ DM Europe Large Mid Cap Index", "I:NQDMEULMN": "NASDAQ DM Europe Large Mid Cap NTR Index", "I:NQDMEULMT": "NASDAQ DM Europe Large Mid Cap TR Index", "I:NQDMEUMC": "NASDAQ DM Europe Mid Cap Index", "I:NQDMEUMCN": "NASDAQ DM Europe Mid Cap NTR Index", "I:NQDMEUMCT": "NASDAQ DM Europe Mid Cap TR Index", "I:NQDMEUN": "NASDAQ DM Europe NTR Index", "I:NQDMEUSC": "NASDAQ DM Europe Small Cap Index", "I:NQDMEUSCN": "NASDAQ DM Europe Small Cap NTR Index", "I:NQDMEUSCT": "NASDAQ DM Europe Small Cap TR Index", "I:NQDMEUT": "NASDAQ DM Europe TR Index", "I:NQDMEUXGB": "NASDAQ DM Europe Ex UK Index", "I:NQDMEUXGBLM": "NASDAQ DM Europe Ex UK Large Mid Cap Index", "I:NQDMEUXGBLMN": "NASDAQ DM Europe Ex UK Large Mid Cap NTR Index", "I:NQDMEUXGBLMT": "NASDAQ DM Europe Ex UK Large Mid Cap TR Index", "I:NQDMEUXGBN": "NASDAQ DM Europe Ex UK NTR Index", "I:NQDMEUXGBT": "NASDAQ DM Europe Ex UK TR Index", "I:NQDMLC": "NASDAQ Developed Large Cap Index", "I:NQDMLCN": "NASDAQ Developed Large Cap NTR Index", "I:NQDMLCT": "NASDAQ Developed Large Cap TR Index", "I:NQDMLMC": "NASDAQ Developed Large Mid Cap Index", "I:NQDMLMCN": "NASDAQ Developed Large Mid Cap NTR Index", "I:NQDMLMCT": "NASDAQ Developed Large Mid Cap TR Index", "I:NQDMMC": "NASDAQ Developed Mid Cap Index", "I:NQDMMCN": "NASDAQ Developed Mid Cap NTR Index", "I:NQDMMCT": "NASDAQ Developed Mid Cap TR Index", "I:NQDMMEA": "NASDAQ DM MEA Index", "I:NQDMMEA10": "Nasdaq DM MEA Technology Index", "I:NQDMMEA10N": "Nasdaq DM MEA Technology NTR Index", "I:NQDMMEA10T": "Nasdaq DM MEA Technology TR Index", "I:NQDMMEA15": "Nasdaq DM MEA Telecommunications Index", "I:NQDMMEA15N": "Nasdaq DM MEA Telecommunications NTR Index", "I:NQDMMEA15T": "Nasdaq DM MEA Telecommunications TR Index", "I:NQDMMEA20": "NASDAQ DM MEA Health Care Index", "I:NQDMMEA20N": "NASDAQ DM MEA Health Care NTR Index", "I:NQDMMEA20T": "NASDAQ DM MEA Health Care TR Index", "I:NQDMMEA30": "NASDAQ DM MEA Financials Index", "I:NQDMMEA3010": "NASDAQ DM MEA Banks Index", "I:NQDMMEA3010N": "NASDAQ DM MEA Banks NTR Index", "I:NQDMMEA3010T": "NASDAQ DM MEA Banks TR Index", "I:NQDMMEA3020": "Nasdaq DM MEA Financial Services Index", "I:NQDMMEA3020N": "Nasdaq DM MEA Financial Services NTR Index", "I:NQDMMEA3020T": "Nasdaq DM MEA Financial Services TR Index", "I:NQDMMEA3030": "Nasdaq DM MEA Insurance Index", "I:NQDMMEA3030N": "Nasdaq DM MEA Insurance NTR Index", "I:NQDMMEA3030T": "Nasdaq DM MEA Insurance TR Index", "I:NQDMMEA30LM": "Nasdaq DM MEA Financials Large Mid Cap Index", "I:NQDMMEA30LMN": "NASDAQ DM MEA Financials Large Mid Cap NTR Index", "I:NQDMMEA30LMT": "NASDAQ DM MEA Financials Large Mid Cap TR Index", "I:NQDMMEA30N": "NASDAQ DM MEA Financials NTR Index", "I:NQDMMEA30T": "NASDAQ DM MEA Financials TR Index", "I:NQDMMEA35": "NASDAQ DM MEA Real Estate Index", "I:NQDMMEA35N": "NASDAQ DM MEA Real Estate NTR Index", "I:NQDMMEA35T": "NASDAQ DM MEA Real Estate TR Index", "I:NQDMMEA40": "Nasdaq DM MEA Consumer Discretionary Index", "I:NQDMMEA40N": "Nasdaq DM MEA Consumer Discretionary NTR Index", "I:NQDMMEA40T": "Nasdaq DM MEA Consumer Discretionary TR Index", "I:NQDMMEA50": "Nasdaq DM MEA Industrials Index", "I:NQDMMEA5020": "Nasdaq DM MEA Industrial Goods and Services Index", "I:NQDMMEA5020N": "Nasdaq DM MEA Industrial Goods and Services NTR Index", "I:NQDMMEA5020T": "Nasdaq DM MEA Industrial Goods and Services TR Index", "I:NQDMMEA50N": "Nasdaq DM MEA Industrials NTR Index", "I:NQDMMEA50T": "Nasdaq DM MEA Industrials TR Index", "I:NQDMMEA55": "Nasdaq DM MEA Basic Materials Index", "I:NQDMMEA5520": "NASDAQ DM MEA Chemicals Index", "I:NQDMMEA5520N": "NASDAQ DM MEA Chemicals NTR Index", "I:NQDMMEA5520T": "NASDAQ DM MEA Chemicals TR Index", "I:NQDMMEA55N": "Nasdaq DM MEA Basic Materials NTR Index", "I:NQDMMEA55T": "Nasdaq DM MEA Basic Materials TR Index", "I:NQDMMEA60": "Nasdaq DM MEA Energy Index", "I:NQDMMEA60N": "Nasdaq DM MEA Energy NTR Index", "I:NQDMMEA60T": "Nasdaq DM MEA Energy TR Index", "I:NQDMMEALM": "NASDAQ DM MEA Large Mid Cap Index", "I:NQDMMEALMN": "NASDAQ DM MEA Large Mid Cap NTR Index", "I:NQDMMEALMT": "NASDAQ DM MEA Large Mid Cap TR Index", "I:NQDMMEAMC": "NASDAQ DM MEA Mid Cap Index", "I:NQDMMEAMCN": "NASDAQ DM MEA Mid Cap NTR Index", "I:NQDMMEAMCT": "NASDAQ DM MEA Mid Cap TR Index", "I:NQDMMEAN": "NASDAQ DM MEA NTR Index", "I:NQDMMEASC": "NASDAQ DM MEA Small Cap Index", "I:NQDMMEASCN": "NASDAQ DM MEA Small Cap NTR Index", "I:NQDMMEASCT": "NASDAQ DM MEA Small Cap TR Index", "I:NQDMMEAT": "NASDAQ DM MEA TR Index", "I:NQDMN": "NASDAQ Developed Markets NTR Index", "I:NQDMSC": "NASDAQ Developed Small Cap Index", "I:NQDMSCN": "NASDAQ Developed Small Cap NTR Index", "I:NQDMSCT": "NASDAQ Developed Small Cap TR Index", "I:NQDMT": "NASDAQ Developed Markets TR Index", "I:NQDMXGB": "NASDAQ DM Ex UK Index", "I:NQDMXGBLM": "NASDAQ DM Ex UK Large Mid Cap Index", "I:NQDMXGBLMN": "NASDAQ DM Ex UK Large Mid Cap NTR Index", "I:NQDMXGBLMT": "NASDAQ DM Ex UK Large Mid Cap TR Index", "I:NQDMXGBN": "NASDAQ DM Ex UK NTR Index", "I:NQDMXGBT": "NASDAQ DM Ex UK TR Index", "I:NQDMXJP": "NASDAQ DM Ex Japan Index", "I:NQDMXJPLM": "NASDAQ DM Ex Japan Large Mid Cap Index", "I:NQDMXJPLMN": "NASDAQ DM Ex Japan Large Mid Cap NTR Index", "I:NQDMXJPLMT": "NASDAQ DM Ex Japan Large Mid Cap TR Index", "I:NQDMXJPN": "NASDAQ DM Ex Japan NTR Index", "I:NQDMXJPT": "NASDAQ DM Ex Japan TR Index", "I:NQDMXKR": "Nasdaq Developed Markets Ex Korea Index", "I:NQDMXKRLC": "Nasdaq DM Ex Korea Large Cap", "I:NQDMXKRLCN": "Nasdaq DM Ex Korea Large Cap NTR", "I:NQDMXKRLCT": "Nasdaq DM Ex Korea Large Cap TR", "I:NQDMXKRLM": "Nasdaq DM Ex Korea Large Mid Cap", "I:NQDMXKRLMN": "Nasdaq DM Ex Korea Large Mid Cap NTR", "I:NQDMXKRLMT": "Nasdaq DM Ex Korea Large Mid Cap TR", "I:NQDMXKRMC": "Nasdaq DM Ex Korea Mid Cap", "I:NQDMXKRMCN": "Nasdaq DM Ex Korea Mid Cap NTR", "I:NQDMXKRMCT": "Nasdaq DM Ex Korea Mid Cap TR", "I:NQDMXKRN": "Nasdaq DM Ex Korea NTR", "I:NQDMXKRSC": "Nasdaq DM Ex Korea Small Cap", "I:NQDMXKRSCN": "Nasdaq DM Ex Korea Small Cap NTR", "I:NQDMXKRSCT": "Nasdaq DM Ex Korea Small Cap TR", "I:NQDMXKRT": "Nasdaq DM Ex Korea TR", "I:NQDMXNA": "NASDAQ DM Ex N America Index", "I:NQDMXNALMC": "NASDAQ DM Ex N America Large Mid Cap Index", "I:NQDMXNALMCN": "NASDAQ DM Ex N America Large Mid Cap NTR Index", "I:NQDMXNALMCT": "NASDAQ DM Ex N America Large Mid Cap TR Index", "I:NQDMXNAN": "NASDAQ DM Ex N America NTR Index", "I:NQDMXNASC": "NASDAQ Developed ex North America Small Cap", "I:NQDMXNASCN": "NASDAQ Developed ex North America Small Cap Net To", "I:NQDMXNASCT": "NASDAQ Developed ex North America Small Cap Total", "I:NQDMXNAT": "NASDAQ DM Ex N America TR Index", "I:NQDMXNAXKR": "Nasdaq Developed Markets Ex NA Ex Korea Index", "I:NQDMXNAXKRLC": "Nasdaq DM Ex NA Ex Korea Large Cap", "I:NQDMXNAXKRLCN": "Nasdaq DM Ex NA Ex Korea Large Cap NTR", "I:NQDMXNAXKRLCT": "Nasdaq DM Ex NA Ex Korea Large Cap TR", "I:NQDMXNAXKRLM": "Nasdaq DM Ex NA Ex Korea Large Mid Cap", "I:NQDMXNAXKRLMN": "Nasdaq DM Ex NA Ex Korea Large Mid Cap NTR", "I:NQDMXNAXKRLMT": "Nasdaq DM Ex NA Ex Korea Large Mid Cap TR", "I:NQDMXNAXKRMC": "Nasdaq DM Ex NA Ex Korea Mid Cap", "I:NQDMXNAXKRMCN": "Nasdaq DM Ex NA Ex Korea Mid Cap NTR", "I:NQDMXNAXKRMCT": "Nasdaq DM Ex NA Ex Korea Mid Cap TR", "I:NQDMXNAXKRN": "Nasdaq DM Ex NA Ex Korea NTR", "I:NQDMXNAXKRSC": "Nasdaq DM Ex NA Ex Korea Small Cap", "I:NQDMXNAXKRSCN": "Nasdaq DM Ex NA Ex Korea Small Cap NTR", "I:NQDMXNAXKRSCT": "Nasdaq DM Ex NA Ex Korea Small Cap TR", "I:NQDMXNAXKRT": "Nasdaq DM Ex NA Ex Korea TR", "I:NQDMXUS": "NASDAQ DM Ex United States Index", "I:NQDMXUS10": "NASDAQ DM Ex US Technology Index", "I:NQDMXUS10N": "NASDAQ DM Ex US Technology NTR Index", "I:NQDMXUS10T": "NASDAQ DM Ex US Technology TR Index", "I:NQDMXUS15": "NASDAQ DM Ex US Telecommunications Index", "I:NQDMXUS15N": "NASDAQ DM Ex US Telecommunications NTR Index", "I:NQDMXUS15T": "NASDAQ DM Ex US Telecommunications TR Index", "I:NQDMXUS20": "NASDAQ DM Ex US Health Care Index", "I:NQDMXUS20N": "NASDAQ DM Ex US Health Care NTR Index", "I:NQDMXUS20T": "NASDAQ DM Ex US Health Care TR Index", "I:NQDMXUS30": "NASDAQ DM Ex US Financials Index", "I:NQDMXUS30N": "NASDAQ DM Ex US Financials NTR Index", "I:NQDMXUS30T": "NASDAQ DM Ex US Financials TR Index", "I:NQDMXUS35": "Nasdaq DM Ex US Real Estate Index", "I:NQDMXUS35N": "Nasdaq DM Ex US Real Estate NTR Index", "I:NQDMXUS35T": "Nasdaq DM Ex US Real Estate TR Index", "I:NQDMXUS40": "Nasdaq DM Ex US Consumer Discretionary Index", "I:NQDMXUS40N": "Nasdaq DM Ex US Consumer Discretionary NTR Index", "I:NQDMXUS40T": "Nasdaq DM Ex US Consumer Discretionary TR Index", "I:NQDMXUS45": "Nasdaq DM Ex US Consumer Staples Index", "I:NQDMXUS45N": "Nasdaq DM Ex US Consumer Staples NTR Index", "I:NQDMXUS45T": "Nasdaq DM Ex US Consumer Staples TR Index", "I:NQDMXUS50": "NASDAQ DM Ex US Industrials Index", "I:NQDMXUS50N": "NASDAQ DM Ex US Industrials NTR Index", "I:NQDMXUS50T": "NASDAQ DM Ex US Industrials TR Index", "I:NQDMXUS55": "NASDAQ DM Ex US Basic Materials Index", "I:NQDMXUS55N": "NASDAQ DM Ex US Basic Materials NTR Index", "I:NQDMXUS55T": "NASDAQ DM Ex US Basic Materials TR Index", "I:NQDMXUS60": "Nasdaq DM Ex US Energy Index", "I:NQDMXUS60N": "Nasdaq DM Ex US Energy NTR Index", "I:NQDMXUS60T": "Nasdaq DM Ex US Energy TR Index", "I:NQDMXUS65": "NASDAQ DM Ex US Utilities Index", "I:NQDMXUS65N": "NASDAQ DM Ex US Utilities NTR Index", "I:NQDMXUS65T": "NASDAQ DM Ex US Utilities TR Index", "I:NQDMXUSLM": "NASDAQ DM Ex United States Large Mid Cap Index", "I:NQDMXUSLMN": "NASDAQ DM Ex United States Large Mid Cap NTR Index", "I:NQDMXUSLMT": "NASDAQ DM Ex United States Large Mid Cap TR Index", "I:NQDMXUSN": "NASDAQ DM Ex United States NTR Index", "I:NQDMXUSSC": "NASDAQ Developed ex US Small Cap", "I:NQDMXUSSCN": "NASDAQ Developed ex US Small Cap Net Total Return", "I:NQDMXUSSCT": "NASDAQ Developed ex US Small Cap Total Return", "I:NQDMXUST": "NASDAQ DM Ex United States TR Index", "I:NQDMXUSXKR": "Nasdaq Developed Markets Ex US Ex Korea Index", "I:NQDMXUSXKRLC": "Nasdaq DM Ex US Ex Korea Large Cap", "I:NQDMXUSXKRLCN": "Nasdaq DM Ex US Ex Korea Large Cap NTR", "I:NQDMXUSXKRLCT": "Nasdaq DM Ex US Ex Korea Large Cap TR", "I:NQDMXUSXKRLM": "Nasdaq DM Ex US Ex Korea Large Mid Cap", "I:NQDMXUSXKRLMN": "Nasdaq DM Ex US Ex Korea Large Mid Cap NTR", "I:NQDMXUSXKRLMT": "Nasdaq DM Ex US Ex Korea Large Mid Cap TR", "I:NQDMXUSXKRMC": "Nasdaq DM Ex US Ex Korea Mid Cap", "I:NQDMXUSXKRMCN": "Nasdaq DM Ex US Ex Korea Mid Cap NTR", "I:NQDMXUSXKRMCT": "Nasdaq DM Ex US Ex Korea Mid Cap TR", "I:NQDMXUSXKRN": "Nasdaq DM Ex US Ex Korea NTR", "I:NQDMXUSXKRSC": "Nasdaq DM Ex US Ex Korea Small Cap", "I:NQDMXUSXKRSCN": "Nasdaq DM Ex US Ex Korea Small Cap NTR", "I:NQDMXUSXKRSCT": "Nasdaq DM Ex US Ex Korea Small Cap TR", "I:NQDMXUSXKRT": "Nasdaq DM Ex US Ex Korea TR", "I:NQDOG": "Nasdaq Factor Dog Index", "I:NQDOGN": "Nasdaq Factor Dog NTR Index", "I:NQDOGT": "Nasdaq Factor Dog TR Index", "I:NQDVRIS": "NASDAQ US Rising Dividend Achievers Index", "I:NQDVRIST": "NASDAQ US Rising Dividend Achievers TR", "I:NQDVSMR": "Nasdaq US SMID Cap Rising Dividend Achievers", "I:NQDVSMRNNR": "Nasdaq US SMID Cap Rising Dividend Achievers NNR", "I:NQDVSMRT": "Nasdaq US SMID Cap Rising Dividend Achievers TR", "I:NQDXASPAXJP": "NASDAQ AlphaDEX Asia Pac Ex-Japan Index", "I:NQDXASPAXJPEUR": "NASDAQ AlphaDEX Asia Pacific Ex-Japan EUR Index", "I:NQDXASPAXJPEURN": "NASDAQ AlphaDEX Asia Pacific Ex-Japan EUR NTR Inde", "I:NQDXASPAXJPEURT": "NASDAQ AlphaDEX Asia Pacific Ex-Japan EUR TR Index", "I:NQDXASPAXJPGBP": "NASDAQ AlphaDEX Asia Pacific Ex-Japan GBP Index", "I:NQDXASPAXJPGBPN": "NASDAQ AlphaDEX Asia Pacific Ex-Japan GBP NTR Inde", "I:NQDXASPAXJPGBPT": "NASDAQ AlphaDEX Asia Pacific Ex-Japan GBP TR Index", "I:NQDXASPAXJPN": "NASDAQ AlphaDEX Asia Pac Ex-Japan NTR Index", "I:NQDXASPAXJPT": "NASDAQ AlphaDEX Asia Pac Ex-Japan TR Index", "I:NQDXAU": "NASDAQ AlphaDEX Australia Index", "I:NQDXAUN": "NASDAQ AlphaDEX Australia NTR Index", "I:NQDXAUT": "NASDAQ AlphaDEX Australia TR Index", "I:NQDXBR": "NASDAQ AlphaDEX Brazil Index", "I:NQDXBRN": "NASDAQ AlphaDEX Brazil NTR Index", "I:NQDXBRT": "NASDAQ AlphaDEX Brazil TR Index", "I:NQDXCA": "NASDAQ AlphaDEX Canada Index", "I:NQDXCAN": "NASDAQ AlphaDEX Canada NTR Index", "I:NQDXCAT": "NASDAQ AlphaDEX Canada TR Index", "I:NQDXCH": "NASDAQ AlphaDEX Switzerland Index", "I:NQDXCHCHF": "NASDAQ AlphaDEX Switzerland CHF Index", "I:NQDXCHCHFN": "NASDAQ AlphaDEX Switzerland CHF NTR Index", "I:NQDXCHCHFT": "NASDAQ AlphaDEX Switzerland CHF TR Index", "I:NQDXCHEUR": "NASDAQ AlphaDEX Switzerland EUR Index", "I:NQDXCHEURN": "NASDAQ AlphaDEX Switzerland EUR NTR Index", "I:NQDXCHEURT": "NASDAQ AlphaDEX Switzerland EUR TR Index", "I:NQDXCHGBP": "NASDAQ AlphaDEX Switzerland GBP Index", "I:NQDXCHGBPN": "NASDAQ AlphaDEX Switzerland GBP NTR Index", "I:NQDXCHGBPT": "NASDAQ AlphaDEX Switzerland GBP TR Index", "I:NQDXCHN": "NASDAQ AlphaDEX Switzerland NTR Index", "I:NQDXCHT": "NASDAQ AlphaDEX Switzerland TR Index", "I:NQDXCN": "NASDAQ AlphaDEX China Index", "I:NQDXCNN": "NASDAQ AlphaDEX China NTR Index", "I:NQDXCNT": "NASDAQ AlphaDEX China TR Index", "I:NQDXDE": "NASDAQ AlphaDEX Germany Index", "I:NQDXDEEUR": "NASDAQ AlphaDEX Germany EUR Index", "I:NQDXDEEURN": "NASDAQ AlphaDEX Germany EUR NTR Index", "I:NQDXDEEURT": "NASDAQ AlphaDEX Germany EUR TR Index", "I:NQDXDEGBP": "NASDAQ AlphaDEX Germany GBP Index", "I:NQDXDEGBPN": "NASDAQ AlphaDEX Germany GBP NTR Index", "I:NQDXDEGBPT": "NASDAQ AlphaDEX Germany GBP TR Index", "I:NQDXDEN": "NASDAQ AlphaDEX Germany NTR Index", "I:NQDXDET": "NASDAQ AlphaDEX Germany TR Index", "I:NQDXDMXUS": "NASDAQ AlphaDEX DM Ex-US Index", "I:NQDXDMXUSN": "NASDAQ AlphaDEX DM Ex-US NTR Index", "I:NQDXDMXUSSC": "NASDAQ AlphaDEX DM Ex-US Small Cap Index", "I:NQDXDMXUSSCN": "NASDAQ AlphaDEX DM Ex-US Small Cap NTR Index", "I:NQDXDMXUSSCT": "NASDAQ AlphaDEX DM Ex-US Small Cap TR Index", "I:NQDXDMXUST": "NASDAQ AlphaDEX DM Ex-US TR Index", "I:NQDXEM": "NASDAQ AlphaDEX EM Index", "I:NQDXEMEUR": "NASDAQ AlphaDEX EM EUR Index", "I:NQDXEMEURN": "NASDAQ AlphaDEX EM EUR NTR Index", "I:NQDXEMEURT": "NASDAQ AlphaDEX EM EUR TR Index", "I:NQDXEMGBP": "NASDAQ AlphaDEX EM GBP Index", "I:NQDXEMGBPN": "NASDAQ AlphaDEX EM GBP NTR Index", "I:NQDXEMGBPT": "NASDAQ AlphaDEX EM GBP TR Index", "I:NQDXEMN": "NASDAQ AlphaDEX EM NTR Index", "I:NQDXEMSC": "NASDAQ AlphaDEX EM Small Cap Index", "I:NQDXEMSCN": "NASDAQ AlphaDEX EM Small Cap NTR Index", "I:NQDXEMSCT": "NASDAQ AlphaDEX EM Small Cap TR Index", "I:NQDXEMT": "NASDAQ AlphaDEX EM TR Index", "I:NQDXEU": "NASDAQ AlphaDEX Europe Index", "I:NQDXEUN": "NASDAQ AlphaDEX Europe NTR Index", "I:NQDXEURO": "NASDAQ AlphaDEX Eurozone  Index", "I:NQDXEUROEUR": "NASDAQ AlphaDEX Eurozone EUR  Index", "I:NQDXEUROEURN": "NASDAQ AlphaDEX Eurozone EUR NTR Index", "I:NQDXEUROEURT": "NASDAQ AlphaDEX Eurozone EUR TR Index", "I:NQDXEUROGBP": "NASDAQ AlphaDEX Eurozone GBP  Index", "I:NQDXEUROGBPN": "NASDAQ AlphaDEX Eurozone GBP NTR Index", "I:NQDXEUROGBPT": "NASDAQ AlphaDEX Eurozone GBP TR Index", "I:NQDXEUROMH": "Nasdaq AlphaDex Eurozone Hedged USD", "I:NQDXEURON": "NASDAQ AlphaDEX Eurozone NTR Index", "I:NQDXEURONMH": "Nasdaq AlphaDex Eurozone Hedged USD NTR", "I:NQDXEUROT": "NASDAQ AlphaDEX Eurozone TR Index", "I:NQDXEUROTMH": "Nasdaq AlphaDex Eurozone Hedged USD TR", "I:NQDXEUT": "NASDAQ AlphaDEX Europe TR Index", "I:NQDXGB": "NASDAQ AlphaDEX United Kingdom Index", "I:NQDXGBEUR": "NASDAQ AlphaDEX United Kingdom EUR Index", "I:NQDXGBEURN": "NASDAQ AlphaDEX United Kingdom EUR NTR Index", "I:NQDXGBEURT": "NASDAQ AlphaDEX United Kingdom EUR TR Index", "I:NQDXGBGBP": "NASDAQ AlphaDEX United Kingdom GBP Index", "I:NQDXGBGBPN": "NASDAQ AlphaDEX United Kingdom GBP NTR Index", "I:NQDXGBGBPT": "NASDAQ AlphaDEX United Kingdom GBP TR Index", "I:NQDXGBN": "NASDAQ AlphaDEX United Kingdom NTR Index", "I:NQDXGBT": "NASDAQ AlphaDEX United Kingdom TR Index", "I:NQDXHK": "NASDAQ AlphaDEX Hong Kong Index", "I:NQDXHKN": "NASDAQ AlphaDEX Hong Kong NTR Index", "I:NQDXHKT": "NASDAQ AlphaDEX Hong Kong TR Index", "I:NQDXJP": "NASDAQ AlphaDEX Japan Index", "I:NQDXJPEUR": "NASDAQ AlphaDEX Japan EUR Index", "I:NQDXJPEURMH": "NASDAQ AlphaDEX Japan Hedged EUR", "I:NQDXJPEURN": "NASDAQ AlphaDEX Japan EUR NTR Index", "I:NQDXJPEURNMH": "NASDAQ AlphaDEX Japan Hedged EUR NTR", "I:NQDXJPEURT": "NASDAQ AlphaDEX Japan EUR TR Index", "I:NQDXJPEURTMH": "NASDAQ AlphaDEX Japan EUR Hedged TR", "I:NQDXJPGBP": "NASDAQ AlphaDEX Japan GBP Index", "I:NQDXJPGBPN": "NASDAQ AlphaDEX Japan GBP NTR Index", "I:NQDXJPGBPT": "NASDAQ AlphaDEX Japan GBP TR Index", "I:NQDXJPJPY": "NASDAQ AlphaDEX Japan JPY Index", "I:NQDXJPJPYN": "NASDAQ AlphaDEX Japan JPY NTR Index", "I:NQDXJPJPYT": "NASDAQ AlphaDEX Japan JPY TR Index", "I:NQDXJPMH": "NASDAQ AlphaDEX Japan Hedged USD", "I:NQDXJPN": "NASDAQ AlphaDEX Japan NTR Index", "I:NQDXJPNMH": "NASDAQ AlphaDEX Japan Hedged USD NTR", "I:NQDXJPT": "NASDAQ AlphaDEX Japan TR Index", "I:NQDXJPTMH": "NASDAQ AlphaDEX Japan Hedged USD TR", "I:NQDXKR": "NASDAQ AlphaDEX South Korea Index", "I:NQDXKRN": "NASDAQ AlphaDEX South Korea NTR Index", "I:NQDXKRT": "NASDAQ AlphaDEX South Korea TR Index", "I:NQDXLA": "NASDAQ AlphaDEX Latin America Index", "I:NQDXLAN": "NASDAQ AlphaDEX Latin America NTR Index", "I:NQDXLAT": "NASDAQ AlphaDEX Latin America TR Index", "I:NQDXUSB": "NASDAQ AlphaDEX Total US Market Index", "I:NQDXUSBN": "NASDAQ AlphaDEX Total US Market NTR Index", "I:NQDXUSBT": "NASDAQ AlphaDEX Total US Market TR Index", "I:NQDXUSLC": "Nasdaq AlphaDEX Large Cap Core Index", "I:NQDXUSLCEUR": "Nasdaq AlphaDEX Large Cap Core EUR Index", "I:NQDXUSLCEURN": "Nasdaq AlphaDEX Large Cap Core EUR Net Total Retur", "I:NQDXUSLCEURT": "Nasdaq AlphaDEX Large Cap Core EUR Total Return In", "I:NQDXUSLCG": "Nasdaq AlphaDEX Large Cap Growth Index", "I:NQDXUSLCGBP": "Nasdaq AlphaDEX Large Cap Core GBP Index", "I:NQDXUSLCGBPN": "Nasdaq AlphaDEX Large Cap Core GBP Net Total Retur", "I:NQDXUSLCGBPT": "Nasdaq AlphaDEX Large Cap Core GBP Total Return In", "I:NQDXUSLCGN": "Nasdaq AlphaDEX Large Cap Growth Net Total Return", "I:NQDXUSLCGT": "Nasdaq AlphaDEX Large Cap Growth Total Return Inde", "I:NQDXUSLCN": "Nasdaq AlphaDEX Large Cap Core Net Total Return In", "I:NQDXUSLCT": "Nasdaq AlphaDEX Large Cap Core Total Return Index", "I:NQDXUSLCV": "Nasdaq AlphaDEX Large Cap Value Index", "I:NQDXUSLCVN": "Nasdaq AlphaDEX Large Cap Value Net Total Return I", "I:NQDXUSLCVT": "Nasdaq AlphaDEX Large Cap Value Total Return Index", "I:NQDXUSMC": "Nasdaq AlphaDEX Mid Cap Core Index", "I:NQDXUSMCG": "Nasdaq AlphaDEX Mid Cap Growth Index", "I:NQDXUSMCGN": "Nasdaq AlphaDEX Mid Cap Growth Net Total Return In", "I:NQDXUSMCGT": "Nasdaq AlphaDEX Mid Cap Growth Total Return Index", "I:NQDXUSMCN": "Nasdaq AlphaDEX Mid Cap Core Net Total Return Inde", "I:NQDXUSMCT": "Nasdaq AlphaDEX Mid Cap Core Total Return Index", "I:NQDXUSMCV": "Nasdaq AlphaDEX Mid Cap Value Index", "I:NQDXUSMCVN": "Nasdaq AlphaDEX Mid Cap Value Net Total Return Ind", "I:NQDXUSMCVT": "Nasdaq AlphaDEX Mid Cap Value Total Return Index", "I:NQDXUSMLTCG": "Nasdaq AlphaDEX Multi Cap Growth Index", "I:NQDXUSMLTCGN": "Nasdaq AlphaDEX Multi Cap Growth Net Total Return", "I:NQDXUSMLTCGT": "Nasdaq AlphaDEX Multi Cap Growth Total Return Inde", "I:NQDXUSMLTCV": "Nasdaq AlphaDEX Multi Cap Value Index", "I:NQDXUSMLTCVN": "Nasdaq AlphaDEX Multi Cap Value Net Total Return I", "I:NQDXUSMLTCVT": "Nasdaq AlphaDEX Multi Cap Value Total Return Index", "I:NQDXUSSC": "Nasdaq AlphaDEX Small Cap Core Index", "I:NQDXUSSCEUR": "Nasdaq AlphaDEX Small Cap Core EUR Index", "I:NQDXUSSCEURN": "Nasdaq AlphaDEX Small Cap Core EUR Net Total Retur", "I:NQDXUSSCEURT": "Nasdaq AlphaDEX Small Cap Core EUR Total Return In", "I:NQDXUSSCG": "Nasdaq AlphaDEX Small Cap Growth Index", "I:NQDXUSSCGBP": "Nasdaq AlphaDEX Small Cap Core GBP Index", "I:NQDXUSSCGBPN": "Nasdaq AlphaDEX Small Cap Core GBP Net Total Retur", "I:NQDXUSSCGBPT": "Nasdaq AlphaDEX Small Cap Core GBP Total Return In", "I:NQDXUSSCGN": "Nasdaq AlphaDEX Small Cap Growth Net Total Return", "I:NQDXUSSCGT": "Nasdaq AlphaDEX Small Cap Growth Total Return Inde", "I:NQDXUSSCN": "Nasdaq AlphaDEX Small Cap Core Net Total Return In", "I:NQDXUSSCT": "Nasdaq AlphaDEX Small Cap Core Total Return Index", "I:NQDXUSSCV": "Nasdaq AlphaDEX Small Cap Value Index", "I:NQDXUSSCVN": "Nasdaq AlphaDEX Small Cap Value Net Total Return I", "I:NQDXUSSCVT": "Nasdaq AlphaDEX Small Cap Value Total Return Index", "I:NQEG": "NASDAQ Egypt Index", "I:NQEG30": "NASDAQ Egypt Financials Index", "I:NQEG30N": "NASDAQ Egypt Financials NTR Index", "I:NQEG30T": "NASDAQ Egypt Financials TR Index", "I:NQEG35": "Nasdaq Egypt Real Estate Index", "I:NQEG35N": "Nasdaq Egypt Real Estate NTR Index", "I:NQEG35T": "Nasdaq Egypt Real Estate TR Index", "I:NQEGLM": "NASDAQ Egypt Large Mid Cap Index", "I:NQEGLMN": "NASDAQ Egypt Large Mid Cap NTR Index", "I:NQEGLMT": "NASDAQ Egypt Large Mid Cap TR Index", "I:NQEGMC": "NASDAQ Egypt Mid Cap Index", "I:NQEGMCN": "NASDAQ Egypt Mid Cap NTR Index", "I:NQEGMCT": "NASDAQ Egypt Mid Cap TR Index", "I:NQEGN": "NASDAQ Egypt NTR Index", "I:NQEGSC": "NASDAQ Egypt Small Cap Index", "I:NQEGSCN": "NASDAQ Egypt Small Cap NTR Index", "I:NQEGSCT": "NASDAQ Egypt Small Cap TR Index", "I:NQEGT": "NASDAQ Egypt TR Index", "I:NQEM": "NASDAQ Emerging Markets Index", "I:NQEM10": "Nasdaq Emerging Markets Technology Index", "I:NQEM10LM": "Nasdaq Emerging Markets Technology Large Mid Cap Index", "I:NQEM10LMN": "Nasdaq Emerging Markets Technology Large Mid Cap NTR Index", "I:NQEM10LMT": "Nasdaq Emerging Markets Technology Large Mid Cap TR Index", "I:NQEM10N": "Nasdaq Emerging Markets Technology NTR Index", "I:NQEM10T": "Nasdaq Emerging Markets Technology TR Index", "I:NQEM15": "Nasdaq Emerging Markets Telecommunications Index", "I:NQEM15LM": "Nasdaq Emerging Markets Telecommunications Large Mid Cap Index", "I:NQEM15LMN": "Nasdaq Emerging Markets Telecommunications Large Mid Cap NTR Index", "I:NQEM15LMT": "Nasdaq Emerging Markets Telecommunications Large Mid Cap TR Index", "I:NQEM15N": "Nasdaq Emerging Markets Telecommunications NTR Index", "I:NQEM15T": "Nasdaq Emerging Markets Telecommunications TR Index", "I:NQEM20": "Nasdaq Emerging Markets Health Care Index", "I:NQEM20LM": "Nasdaq Emerging Markets Health Care Large Mid Cap Index", "I:NQEM20LMN": "Nasdaq Emerging Markets Health Care Large Mid Cap NTR Index", "I:NQEM20LMT": "Nasdaq Emerging Markets Health Care Large Mid Cap TR Index", "I:NQEM20N": "Nasdaq Emerging Markets Health Care NTR Index", "I:NQEM20T": "Nasdaq Emerging Markets Health Care TR Index", "I:NQEM30": "Nasdaq Emerging Markets Financials Index", "I:NQEM3010": "Nasdaq Emerging Markets Banks Index", "I:NQEM3010LM": "Nasdaq Emerging Markets Banks Large Mid Cap Index", "I:NQEM3010LMN": "Nasdaq Emerging Markets Banks Large Mid Cap NTR Index", "I:NQEM3010LMT": "Nasdaq Emerging Markets Banks Large Mid Cap TR Index", "I:NQEM3010N": "Nasdaq Emerging Markets Banks NTR Index", "I:NQEM3010T": "Nasdaq Emerging Markets Banks TR Index", "I:NQEM3020": "Nasdaq Emerging Markets Financial Services Index", "I:NQEM3020LM": "Nasdaq Emerging Markets Financial Services Large Mid Cap Index", "I:NQEM3020LMN": "Nasdaq Emerging Markets Financial Services Large Mid Cap NTR Index", "I:NQEM3020LMT": "Nasdaq Emerging Markets Financial Services Large Mid Cap TR Index", "I:NQEM3020N": "Nasdaq Emerging Markets Financial Services NTR Index", "I:NQEM3020T": "Nasdaq Emerging Markets Financial Services TR Index", "I:NQEM3030": "Nasdaq Emerging Markets Insurance Index", "I:NQEM3030LM": "Nasdaq Emerging Markets Insurance Large Mid Cap Index", "I:NQEM3030LMN": "Nasdaq Emerging Markets Insurance Large Mid Cap NTR Index", "I:NQEM3030LMT": "Nasdaq Emerging Markets Insurance Large Mid Cap TR Index", "I:NQEM3030N": "Nasdaq Emerging Markets Insurance NTR Index", "I:NQEM3030T": "Nasdaq Emerging Markets Insurance TR Index", "I:NQEM30LM": "Nasdaq Emerging Markets Financials Large Mid Cap Index", "I:NQEM30LMN": "Nasdaq Emerging Markets Financials Large Mid Cap NTR Index", "I:NQEM30LMT": "Nasdaq Emerging Markets Financials Large Mid Cap TR Index", "I:NQEM30N": "Nasdaq Emerging Markets Financials NTR Index", "I:NQEM30T": "Nasdaq Emerging Markets Financials TR Index", "I:NQEM35": "Nasdaq Emerging Markets Real Estate Index", "I:NQEM35LM": "Nasdaq Emerging Markets Real Estate Large Mid Cap Index", "I:NQEM35LMN": "Nasdaq Emerging Markets Real Estate Large Mid Cap NTR Index", "I:NQEM35LMT": "Nasdaq Emerging Markets Real Estate Large Mid Cap TR Index", "I:NQEM35N": "Nasdaq Emerging Markets Real Estate NTR Index", "I:NQEM35T": "Nasdaq Emerging Markets Real Estate TR Index", "I:NQEM40": "Nasdaq Emerging Markets Consumer Discretionary Index", "I:NQEM4010": "Nasdaq Emerging Markets Automobiles and Parts Index", "I:NQEM4010LM": "Nasdaq Emerging Markets Automobiles and Parts Large Mid Cap Index", "I:NQEM4010LMN": "Nasdaq Emerging Markets Automobiles and Parts Large Mid Cap NTR Index", "I:NQEM4010LMT": "Nasdaq Emerging Markets Automobiles and Parts Large Mid Cap TR Index", "I:NQEM4010N": "Nasdaq Emerging Markets Automobiles and Parts NTR Index", "I:NQEM4010T": "Nasdaq Emerging Markets Automobiles and Parts TR Index", "I:NQEM4020": "Nasdaq Emerging Markets Consumer Products and Services Index", "I:NQEM4020LM": "Nasdaq Emerging Markets Consumer Products and Services Large Mid Cap Index", "I:NQEM4020LMN": "Nasdaq Emerging Markets Consumer Products and Services Large Mid Cap NTR Index", "I:NQEM4020LMT": "Nasdaq Emerging Markets Consumer Products and Services Large Mid Cap TR Index", "I:NQEM4020N": "Nasdaq Emerging Markets Consumer Products and Services NTR Index", "I:NQEM4020T": "Nasdaq Emerging Markets Consumer Products and Services TR Index", "I:NQEM4030": "Nasdaq Emerging Markets Media Index", "I:NQEM4030LM": "Nasdaq Emerging Markets Media Large Mid Cap Index", "I:NQEM4030LMN": "Nasdaq Emerging Markets Media Large Mid Cap NTR Index", "I:NQEM4030LMT": "Nasdaq Emerging Markets Media Large Mid Cap TR Index", "I:NQEM4030N": "Nasdaq Emerging Markets Media NTR Index", "I:NQEM4030T": "Nasdaq Emerging Markets Media TR Index", "I:NQEM4040": "Nasdaq Emerging Markets Retail Index", "I:NQEM4040LM": "Nasdaq Emerging Markets Retail Large Mid Cap Index", "I:NQEM4040LMN": "Nasdaq Emerging Markets Retail Large Mid Cap NTR Index", "I:NQEM4040LMT": "Nasdaq Emerging Markets Retail Large Mid Cap TR Index", "I:NQEM4040N": "Nasdaq Emerging Markets Retail NTR Index", "I:NQEM4040T": "Nasdaq Emerging Markets Retail TR Index", "I:NQEM4050": "Nasdaq Emerging Markets Travel and Leisure Index", "I:NQEM4050LM": "Nasdaq Emerging Markets Travel and Leisure Large Mid Cap Index", "I:NQEM4050LMN": "Nasdaq Emerging Markets Travel and Leisure Large Mid Cap NTR Index", "I:NQEM4050LMT": "Nasdaq Emerging Markets Travel and Leisure Large Mid Cap TR Index", "I:NQEM4050N": "Nasdaq Emerging Markets Travel and Leisure NTR Index", "I:NQEM4050T": "Nasdaq Emerging Markets Travel and Leisure TR Index", "I:NQEM40LM": "Nasdaq Emerging Markets Consumer Discretionary Large Mid Cap Index", "I:NQEM40LMN": "Nasdaq Emerging Markets Consumer Discretionary Large Mid Cap NTR Index", "I:NQEM40LMT": "Nasdaq Emerging Markets Consumer Discretionary Large Mid Cap TR Index", "I:NQEM40N": "Nasdaq Emerging Markets Consumer Discretionary NTR Index", "I:NQEM40T": "Nasdaq Emerging Markets Consumer Discretionary TR Index", "I:NQEM45": "Nasdaq Emerging Markets Consumer Staples Index", "I:NQEM4510": "Nasdaq Emerging Markets Food, Beverage and Tobacco Index", "I:NQEM4510LM": "Nasdaq Emerging Markets Food, Beverage and Tobacco Large Mid Cap Index", "I:NQEM4510LMN": "Nasdaq Emerging Markets Food, Beverage and Tobacco Large Mid Cap NTR Index", "I:NQEM4510LMT": "Nasdaq Emerging Markets Food, Beverage and Tobacco Large Mid Cap TR Index", "I:NQEM4510N": "Nasdaq Emerging Markets Food, Beverage and Tobacco NTR Index", "I:NQEM4510T": "Nasdaq Emerging Markets Food, Beverage and Tobacco TR Index", "I:NQEM4520": "Nasdaq Emerging Markets Personal Care, Drug and Grocery Stores Index", "I:NQEM4520LM": "Nasdaq Emerging Markets Personal Care, Drug and Grocery Stores Large Mid Cap Index", "I:NQEM4520LMN": "Nasdaq Emerging Markets Personal Care, Drug and Grocery Stores Large Mid Cap NTR Index", "I:NQEM4520LMT": "Nasdaq Emerging Markets Personal Care, Drug and Grocery Stores Large Mid Cap TR Index", "I:NQEM4520N": "Nasdaq Emerging Markets Personal Care, Drug and Grocery Stores NTR Index", "I:NQEM4520T": "Nasdaq Emerging Markets Personal Care, Drug and Grocery Stores TR Index", "I:NQEM45LM": "Nasdaq Emerging Markets Consumer Staples Large Mid Cap Index", "I:NQEM45LMN": "Nasdaq Emerging Markets Consumer Staples Large Mid Cap NTR Index", "I:NQEM45LMT": "Nasdaq Emerging Markets Consumer Staples Large Mid Cap TR Index", "I:NQEM45N": "Nasdaq Emerging Markets Consumer Staples NTR Index", "I:NQEM45T": "Nasdaq Emerging Markets Consumer Staples TR Index", "I:NQEM50": "Nasdaq Emerging Markets Industrials Index", "I:NQEM5010": "Nasdaq Emerging Markets Construction and Materials Index", "I:NQEM5010LM": "Nasdaq Emerging Markets Construction and Materials Large Mid Cap Index", "I:NQEM5010LMN": "Nasdaq Emerging Markets Construction and Materials Large Mid Cap NTR Index", "I:NQEM5010LMT": "Nasdaq Emerging Markets Construction and Materials Large Mid Cap TR Index", "I:NQEM5010N": "Nasdaq Emerging Markets Construction and Materials NTR Index", "I:NQEM5010T": "Nasdaq Emerging Markets Construction and Materials TR Index", "I:NQEM5020": "Nasdaq Emerging Markets Industrial Goods and Services Index", "I:NQEM5020LM": "Nasdaq Emerging Markets Industrial Goods and Services Large Mid Cap Index", "I:NQEM5020LMN": "Nasdaq Emerging Markets Industrial Goods and Services Large Mid Cap NTR Index", "I:NQEM5020LMT": "Nasdaq Emerging Markets Industrial Goods and Services Large Mid Cap TR Index", "I:NQEM5020N": "Nasdaq Emerging Markets Industrial Goods and Services NTR Index", "I:NQEM5020T": "Nasdaq Emerging Markets Industrial Goods and Services TR Index", "I:NQEM50LM": "Nasdaq Emerging Markets Industrials Large Mid Cap Index", "I:NQEM50LMN": "Nasdaq Emerging Markets Industrials Large Mid Cap NTR Index", "I:NQEM50LMT": "Nasdaq Emerging Markets Industrials Large Mid Cap TR Index", "I:NQEM50N": "Nasdaq Emerging Markets Industrials NTR Index", "I:NQEM50T": "Nasdaq Emerging Markets Industrials TR Index", "I:NQEM55": "Nasdaq Emerging Markets Basic Materials Index", "I:NQEM5510": "Nasdaq Emerging Markets Basic Resources Index", "I:NQEM5510LM": "Nasdaq Emerging Markets Basic Resources Large Mid Cap Index", "I:NQEM5510LMN": "Nasdaq Emerging Markets Basic Resources Large Mid Cap NTR Index", "I:NQEM5510LMT": "Nasdaq Emerging Markets Basic Resources Large Mid Cap TR Index", "I:NQEM5510N": "Nasdaq Emerging Markets Basic Resources NTR Index", "I:NQEM5510T": "Nasdaq Emerging Markets Basic Resources TR Index", "I:NQEM5520": "Nasdaq Emerging Markets Chemicals Index", "I:NQEM5520LM": "Nasdaq Emerging Markets Chemicals Large Mid Cap Index", "I:NQEM5520LMN": "Nasdaq Emerging Markets Chemicals Large Mid Cap NTR Index", "I:NQEM5520LMT": "Nasdaq Emerging Markets Chemicals Large Mid Cap TR Index", "I:NQEM5520N": "Nasdaq Emerging Markets Chemicals NTR Index", "I:NQEM5520T": "Nasdaq Emerging Markets Chemicals TR Index", "I:NQEM55LM": "Nasdaq Emerging Markets Basic Materials Large Mid Cap Index", "I:NQEM55LMN": "Nasdaq Emerging Markets Basic Materials Large Mid Cap NTR Index", "I:NQEM55LMT": "Nasdaq Emerging Markets Basic Materials Large Mid Cap TR Index", "I:NQEM55N": "Nasdaq Emerging Markets Basic Materials NTR Index", "I:NQEM55T": "Nasdaq Emerging Markets Basic Materials TR Index", "I:NQEM60": "Nasdaq Emerging Markets Energy Index", "I:NQEM60LM": "Nasdaq Emerging Markets Energy Large Mid Cap Index", "I:NQEM60LMN": "Nasdaq Emerging Markets Energy Large Mid Cap NTR Index", "I:NQEM60LMT": "Nasdaq Emerging Markets Energy Large Mid Cap TR Index", "I:NQEM60N": "Nasdaq Emerging Markets Energy NTR Index", "I:NQEM60T": "Nasdaq Emerging Markets Energy TR Index", "I:NQEM65": "Nasdaq Emerging Markets Utilities Index", "I:NQEM65LM": "Nasdaq Emerging Markets Utilities Large Mid Cap Index", "I:NQEM65LMN": "Nasdaq Emerging Markets Utilities Large Mid Cap NTR Index", "I:NQEM65LMT": "Nasdaq Emerging Markets Utilities Large Mid Cap TR Index", "I:NQEM65N": "Nasdaq Emerging Markets Utilities NTR Index", "I:NQEM65T": "Nasdaq Emerging Markets Utilities TR Index", "I:NQEMASIA": "NASDAQ EM Asia Index", "I:NQEMASIA10": "Nasdaq EM Asia Technology Index", "I:NQEMASIA10LM": "Nasdaq EM Asia Technology Large Mid Cap Index", "I:NQEMASIA10LMN": "Nasdaq EM Asia Technology Large Mid Cap NTR Index", "I:NQEMASIA10LMT": "Nasdaq EM Asia Technology Large Mid Cap TR Index", "I:NQEMASIA10N": "Nasdaq EM Asia Technology NTR Index", "I:NQEMASIA10T": "Nasdaq EM Asia Technology TR Index", "I:NQEMASIA15": "Nasdaq EM Asia Telecommunications Index", "I:NQEMASIA15LM": "Nasdaq EM Asia Telecommunications Large Mid Cap Index", "I:NQEMASIA15LMN": "Nasdaq EM Asia Telecommunications Large Mid Cap NTR Index", "I:NQEMASIA15LMT": "Nasdaq EM Asia Telecommunications Large Mid Cap TR Index", "I:NQEMASIA15N": "Nasdaq EM Asia Telecommunications NTR Index", "I:NQEMASIA15T": "Nasdaq EM Asia Telecommunications TR Index", "I:NQEMASIA20": "NASDAQ EM Asia Health Care Index", "I:NQEMASIA20LM": "Nasdaq EM Asia Health Care Large Mid Cap Index", "I:NQEMASIA20LMN": "NASDAQ EM Asia Health Care Large Mid Cap NTR Index", "I:NQEMASIA20LMT": "NASDAQ EM Asia Health Care Large Mid Cap TR Index", "I:NQEMASIA20N": "NASDAQ EM Asia Health Care NTR Index", "I:NQEMASIA20T": "NASDAQ EM Asia Health Care TR Index", "I:NQEMASIA30": "NASDAQ EM Asia Financials Index", "I:NQEMASIA3010": "NASDAQ EM Asia Banks Index", "I:NQEMASIA3010LM": "Nasdaq EM Asia Banks Large Mid Cap Index", "I:NQEMASIA3010LMN": "NASDAQ EM Asia Banks Large Mid Cap NTR Index", "I:NQEMASIA3010LMT": "NASDAQ EM Asia Banks Large Mid Cap TR Index", "I:NQEMASIA3010N": "NASDAQ EM Asia Banks NTR Index", "I:NQEMASIA3010T": "NASDAQ EM Asia Banks TR Index", "I:NQEMASIA3020": "Nasdaq EM Asia Financial Services Index", "I:NQEMASIA3020LM": "Nasdaq EM Asia Financial Services Large Mid Cap Index", "I:NQEMASIA3020LMN": "Nasdaq EM Asia Financial Services Large Mid Cap NTR Index", "I:NQEMASIA3020LMT": "Nasdaq EM Asia Financial Services Large Mid Cap TR Index", "I:NQEMASIA3020N": "Nasdaq EM Asia Financial Services NTR Index", "I:NQEMASIA3020T": "Nasdaq EM Asia Financial Services TR Index", "I:NQEMASIA3030": "Nasdaq EM Asia Insurance Index", "I:NQEMASIA3030LM": "Nasdaq EM Asia Insurance Large Mid Cap Index", "I:NQEMASIA3030LMN": "Nasdaq EM Asia Insurance Large Mid Cap NTR Index", "I:NQEMASIA3030LMT": "Nasdaq EM Asia Insurance Large Mid Cap TR Index", "I:NQEMASIA3030N": "Nasdaq EM Asia Insurance NTR Index", "I:NQEMASIA3030T": "Nasdaq EM Asia Insurance TR Index", "I:NQEMASIA30LM": "Nasdaq EM Asia Financials Large Mid Cap Index", "I:NQEMASIA30LMN": "NASDAQ EM Asia Financials Large Mid Cap NTR Index", "I:NQEMASIA30LMT": "NASDAQ EM Asia Financials Large Mid Cap TR Index", "I:NQEMASIA30N": "NASDAQ EM Asia Financials NTR Index", "I:NQEMASIA30T": "NASDAQ EM Asia Financials TR Index", "I:NQEMASIA35": "NASDAQ EM Asia Real Estate Index", "I:NQEMASIA35LM": "Nasdaq EM Asia Real Estate Large Mid Cap Index", "I:NQEMASIA35LMN": "NASDAQ EM Asia Real Estate Large Mid Cap NTR Index", "I:NQEMASIA35LMT": "NASDAQ EM Asia Real Estate Large Mid Cap TR Index", "I:NQEMASIA35N": "NASDAQ EM Asia Real Estate NTR Index", "I:NQEMASIA35T": "NASDAQ EM Asia Real Estate TR Index", "I:NQEMASIA40": "Nasdaq EM Asia Consumer Discretionary Index", "I:NQEMASIA4010": "Nasdaq EM Asia Automobiles and Parts Index", "I:NQEMASIA4010LM": "Nasdaq EM Asia Automobiles and Parts Large Mid Cap Index", "I:NQEMASIA4010LMN": "Nasdaq EM Asia Automobiles and Parts Large Mid Cap NTR Index", "I:NQEMASIA4010LMT": "Nasdaq EM Asia Automobiles and Parts Large Mid Cap TR Index", "I:NQEMASIA4010N": "Nasdaq EM Asia Automobiles and Parts NTR Index", "I:NQEMASIA4010T": "Nasdaq EM Asia Automobiles and Parts TR Index", "I:NQEMASIA4020": "Nasdaq EM Asia Consumer Products and Services Index", "I:NQEMASIA4020LM": "Nasdaq EM Asia Consumer Products and Services Large Mid Cap Index", "I:NQEMASIA4020LMN": "Nasdaq EM Asia Consumer Products and Services Large Mid Cap NTR Index", "I:NQEMASIA4020LMT": "Nasdaq EM Asia Consumer Products and Services Large Mid Cap TR Index", "I:NQEMASIA4020N": "Nasdaq EM Asia Consumer Products and Services NTR Index", "I:NQEMASIA4020T": "Nasdaq EM Asia Consumer Products and Services TR Index", "I:NQEMASIA4030": "NASDAQ EM Asia Media Index", "I:NQEMASIA4030LM": "Nasdaq EM Asia Media Large Mid Cap Index", "I:NQEMASIA4030LMN": "NASDAQ EM Asia Media Large Mid Cap NTR Index", "I:NQEMASIA4030LMT": "NASDAQ EM Asia Media Large Mid Cap TR Index", "I:NQEMASIA4030N": "NASDAQ EM Asia Media NTR Index", "I:NQEMASIA4030T": "NASDAQ EM Asia Media TR Index", "I:NQEMASIA4040": "NASDAQ EM Asia Retail Index", "I:NQEMASIA4040LM": "Nasdaq EM Asia Retail Large Mid Cap Index", "I:NQEMASIA4040LMN": "NASDAQ EM Asia Retail Large Mid Cap NTR Index", "I:NQEMASIA4040LMT": "NASDAQ EM Asia Retail Large Mid Cap TR Index", "I:NQEMASIA4040N": "NASDAQ EM Asia Retail NTR Index", "I:NQEMASIA4040T": "NASDAQ EM Asia Retail TR Index", "I:NQEMASIA4050": "Nasdaq EM Asia Travel and Leisure Index", "I:NQEMASIA4050LM": "Nasdaq EM Asia Travel and Leisure Large Mid Cap Index", "I:NQEMASIA4050LMN": "Nasdaq EM Asia Travel and Leisure Large Mid Cap NTR Index", "I:NQEMASIA4050LMT": "Nasdaq EM Asia Travel and Leisure Large Mid Cap TR Index", "I:NQEMASIA4050N": "Nasdaq EM Asia Travel and Leisure NTR Index", "I:NQEMASIA4050T": "Nasdaq EM Asia Travel and Leisure TR Index", "I:NQEMASIA40LM": "Nasdaq EM Asia Consumer Discretionary Large Mid Cap Index", "I:NQEMASIA40LMN": "Nasdaq EM Asia Consumer Discretionary Large Mid Cap NTR Index", "I:NQEMASIA40LMT": "Nasdaq EM Asia Consumer Discretionary Large Mid Cap TR Index", "I:NQEMASIA40N": "Nasdaq EM Asia Consumer Discretionary NTR Index", "I:NQEMASIA40T": "Nasdaq EM Asia Consumer Discretionary TR Index", "I:NQEMASIA45": "Nasdaq EM Asia Consumer Staples Index", "I:NQEMASIA4510": "Nasdaq EM Asia Food, Beverage and Tobacco Index", "I:NQEMASIA4510LM": "Nasdaq EM Asia Food, Beverage and Tobacco Large Mid Cap Index", "I:NQEMASIA4510LMN": "Nasdaq EM Asia Food, Beverage and Tobacco Large Mid Cap NTR Index", "I:NQEMASIA4510LMT": "Nasdaq EM Asia Food, Beverage and Tobacco Large Mid Cap TR Index", "I:NQEMASIA4510N": "Nasdaq EM Asia Food, Beverage and Tobacco NTR Index", "I:NQEMASIA4510T": "Nasdaq EM Asia Food, Beverage and Tobacco TR Index", "I:NQEMASIA4520": "Nasdaq EM Asia Personal Care, Drug and Grocery Stores Index", "I:NQEMASIA4520LM": "Nasdaq EM Asia Personal Care, Drug and Grocery Stores Large Mid Cap Index", "I:NQEMASIA4520LMN": "Nasdaq EM Asia Personal Care, Drug and Grocery Stores Large Mid Cap NTR Index", "I:NQEMASIA4520LMT": "Nasdaq EM Asia Personal Care, Drug and Grocery Stores Large Mid Cap TR Index", "I:NQEMASIA4520N": "Nasdaq EM Asia Personal Care, Drug and Grocery Stores NTR Index", "I:NQEMASIA4520T": "Nasdaq EM Asia Personal Care, Drug and Grocery Stores TR Index", "I:NQEMASIA45LM": "Nasdaq EM Asia Consumer Staples Large Mid Cap Index", "I:NQEMASIA45LMN": "Nasdaq EM Asia Consumer Staples Large Mid Cap NTR Index", "I:NQEMASIA45LMT": "Nasdaq EM Asia Consumer Staples Large Mid Cap TR Index", "I:NQEMASIA45N": "Nasdaq EM Asia Consumer Staples NTR Index", "I:NQEMASIA45T": "Nasdaq EM Asia Consumer Staples TR Index", "I:NQEMASIA50": "Nasdaq EM Asia Industrials Index", "I:NQEMASIA5010": "Nasdaq EM Asia Construction and Materials Index", "I:NQEMASIA5010LM": "Nasdaq EM Asia Construction and Materials Large Mid Cap Index", "I:NQEMASIA5010LMN": "Nasdaq EM Asia Construction and Materials Large Mid Cap NTR Index", "I:NQEMASIA5010LMT": "Nasdaq EM Asia Construction and Materials Large Mid Cap TR Index", "I:NQEMASIA5010N": "Nasdaq EM Asia Construction and Materials NTR Index", "I:NQEMASIA5010T": "Nasdaq EM Asia Construction and Materials TR Index", "I:NQEMASIA5020": "Nasdaq EM Asia Industrial Goods and Services Index", "I:NQEMASIA5020LM": "Nasdaq EM Asia Industrial Goods and Services Large Mid Cap Index", "I:NQEMASIA5020LMN": "Nasdaq EM Asia Industrial Goods and Services Large Mid Cap NTR Index", "I:NQEMASIA5020LMT": "Nasdaq EM Asia Industrial Goods and Services Large Mid Cap TR Index", "I:NQEMASIA5020N": "Nasdaq EM Asia Industrial Goods and Services NTR Index", "I:NQEMASIA5020T": "Nasdaq EM Asia Industrial Goods and Services TR Index", "I:NQEMASIA50LM": "Nasdaq EM Asia Industrials Large Mid Cap Index", "I:NQEMASIA50LMN": "Nasdaq EM Asia Industrials Large Mid Cap NTR Index", "I:NQEMASIA50LMT": "Nasdaq EM Asia Industrials Large Mid Cap TR Index", "I:NQEMASIA50N": "Nasdaq EM Asia Industrials NTR Index", "I:NQEMASIA50T": "Nasdaq EM Asia Industrials TR Index", "I:NQEMASIA55": "Nasdaq EM Asia Basic Materials Index", "I:NQEMASIA5510": "NASDAQ EM Asia Basic Resources Index", "I:NQEMASIA5510LM": "Nasdaq EM Asia Basic Resources Large Mid Cap Index", "I:NQEMASIA5510LMN": "Nasdaq EM Asia Basic Resources Large Mid Cap NTR Index", "I:NQEMASIA5510LMT": "Nasdaq EM Asia Basic Resources Large Mid Cap TR Index", "I:NQEMASIA5510N": "NASDAQ EM Asia Basic Resources NTR Index", "I:NQEMASIA5510T": "NASDAQ EM Asia Basic Resources TR Index", "I:NQEMASIA5520": "NASDAQ EM Asia Chemicals Index", "I:NQEMASIA5520LM": "Nasdaq EM Asia Chemicals Large Mid Cap Index", "I:NQEMASIA5520LMN": "NASDAQ EM Asia Chemicals Large Mid Cap NTR Index", "I:NQEMASIA5520LMT": "NASDAQ EM Asia Chemicals Large Mid Cap TR Index", "I:NQEMASIA5520N": "NASDAQ EM Asia Chemicals NTR Index", "I:NQEMASIA5520T": "NASDAQ EM Asia Chemicals TR Index", "I:NQEMASIA55LM": "Nasdaq EM Asia Basic Materials Large Mid Cap Index", "I:NQEMASIA55LMN": "Nasdaq EM Asia Basic Materials Large Mid Cap NTR Index", "I:NQEMASIA55LMT": "Nasdaq EM Asia Basic Materials Large Mid Cap TR Index", "I:NQEMASIA55N": "Nasdaq EM Asia Basic Materials NTR Index", "I:NQEMASIA55T": "Nasdaq EM Asia Basic Materials TR Index", "I:NQEMASIA60": "Nasdaq EM Asia Energy Index", "I:NQEMASIA60LM": "Nasdaq EM Asia Energy Large Mid Cap Index", "I:NQEMASIA60LMN": "Nasdaq EM Asia Energy Large Mid Cap NTR Index", "I:NQEMASIA60LMT": "Nasdaq EM Asia Energy Large Mid Cap TR Index", "I:NQEMASIA60N": "Nasdaq EM Asia Energy NTR Index", "I:NQEMASIA60T": "Nasdaq EM Asia Energy TR Index", "I:NQEMASIA65": "NASDAQ EM Asia Utilities Index", "I:NQEMASIA65LM": "Nasdaq EM Asia Utilities Large Mid Cap Index", "I:NQEMASIA65LMN": "NASDAQ EM Asia Utilities Large Mid Cap NTR Index", "I:NQEMASIA65LMT": "NASDAQ EM Asia Utilities Large Mid Cap TR Index", "I:NQEMASIA65N": "NASDAQ EM Asia Utilities NTR Index", "I:NQEMASIA65T": "NASDAQ EM Asia Utilities TR Index", "I:NQEMASIALC": "NASDAQ EM Asia Large Cap Index", "I:NQEMASIALCN": "NASDAQ EM Asia Large Cap NTR Index", "I:NQEMASIALCT": "NASDAQ EM Asia Large Cap TR Index", "I:NQEMASIALM": "NASDAQ EM Asia Large Mid Cap Index", "I:NQEMASIALMN": "NASDAQ EM Asia Large Mid Cap NTR Index", "I:NQEMASIALMT": "NASDAQ EM Asia Large Mid Cap TR Index", "I:NQEMASIAMC": "NASDAQ EM Asia Mid Cap Index", "I:NQEMASIAMCN": "NASDAQ EM Asia Mid Cap NTR Index", "I:NQEMASIAMCT": "NASDAQ EM Asia Mid Cap TR Index", "I:NQEMASIAN": "NASDAQ EM Asia NTR Index", "I:NQEMASIASC": "NASDAQ EM Asia Small Cap Index", "I:NQEMASIASCN": "NASDAQ EM Asia Small Cap NTR Index", "I:NQEMASIASCT": "NASDAQ EM Asia Small Cap TR Index", "I:NQEMASIAT": "NASDAQ EM Asia TR Index", "I:NQEMEA": "NASDAQ EMEA Index", "I:NQEMEA10": "Nasdaq EMEA Technology Index", "I:NQEMEA10LM": "Nasdaq EMEA Technology Large Mid Cap Index", "I:NQEMEA10LMN": "Nasdaq EMEA Technology Large Mid Cap NTR Index", "I:NQEMEA10LMT": "Nasdaq EMEA Technology Large Mid Cap TR Index", "I:NQEMEA10N": "Nasdaq EMEA Technology NTR Index", "I:NQEMEA10T": "Nasdaq EMEA Technology TR Index", "I:NQEMEA15": "Nasdaq EMEA Telecommunications Index", "I:NQEMEA15LM": "Nasdaq EMEA Telecommunications Large Mid Cap Index", "I:NQEMEA15LMN": "Nasdaq EMEA Telecommunications Large Mid Cap NTR Index", "I:NQEMEA15LMT": "Nasdaq EMEA Telecommunications Large Mid Cap TR Index", "I:NQEMEA15N": "Nasdaq EMEA Telecommunications NTR Index", "I:NQEMEA15T": "Nasdaq EMEA Telecommunications TR Index", "I:NQEMEA20": "NASDAQ EMEA Health Care Index", "I:NQEMEA20LM": "Nasdaq EMEA Health Care Large Mid Cap Index", "I:NQEMEA20LMN": "NASDAQ EMEA Health Care Large Mid Cap NTR Index", "I:NQEMEA20LMT": "NASDAQ EMEA Health Care Large Mid Cap TR Index", "I:NQEMEA20N": "NASDAQ EMEA Health Care NTR Index", "I:NQEMEA20T": "NASDAQ EMEA Health Care TR Index", "I:NQEMEA30": "NASDAQ EMEA Financials Index", "I:NQEMEA3010": "NASDAQ EMEA Banks Index", "I:NQEMEA3010LM": "Nasdaq EMEA Banks Large Mid Cap Index", "I:NQEMEA3010LMN": "NASDAQ EMEA Banks Large Mid Cap NTR Index", "I:NQEMEA3010LMT": "NASDAQ EMEA Banks Large Mid Cap TR Index", "I:NQEMEA3010N": "NASDAQ EMEA Banks NTR Index", "I:NQEMEA3010T": "NASDAQ EMEA Banks TR Index", "I:NQEMEA3020": "Nasdaq EMEA Financial Services Index", "I:NQEMEA3020LM": "Nasdaq EMEA Financial Services Large Mid Cap Index", "I:NQEMEA3020LMN": "Nasdaq EMEA Financial Services Large Mid Cap NTR Index", "I:NQEMEA3020LMT": "Nasdaq EMEA Financial Services Large Mid Cap TR Index", "I:NQEMEA3020N": "Nasdaq EMEA Financial Services NTR Index", "I:NQEMEA3020T": "Nasdaq EMEA Financial Services TR Index", "I:NQEMEA3030": "Nasdaq EMEA Insurance Index", "I:NQEMEA3030LM": "Nasdaq EMEA Insurance Large Mid Cap Index", "I:NQEMEA3030LMN": "Nasdaq EMEA Insurance Large Mid Cap NTR Index", "I:NQEMEA3030LMT": "Nasdaq EMEA Insurance Large Mid Cap TR Index", "I:NQEMEA3030N": "Nasdaq EMEA Insurance NTR Index", "I:NQEMEA3030T": "Nasdaq EMEA Insurance TR Index", "I:NQEMEA30LM": "Nasdaq EMEA Financials Large Mid Cap Index", "I:NQEMEA30LMN": "NASDAQ EMEA Financials Large Mid Cap NTR Index", "I:NQEMEA30LMT": "NASDAQ EMEA Financials Large Mid Cap TR Index", "I:NQEMEA30N": "NASDAQ EMEA Financials NTR Index", "I:NQEMEA30T": "NASDAQ EMEA Financials TR Index", "I:NQEMEA35": "NASDAQ EMEA Real Estate Index", "I:NQEMEA35LM": "Nasdaq EMEA Real Estate Large Mid Cap Index", "I:NQEMEA35LMN": "NASDAQ EMEA Real Estate Large Mid Cap NTR Index", "I:NQEMEA35LMT": "NASDAQ EMEA Real Estate Large Mid Cap TR Index", "I:NQEMEA35N": "NASDAQ EMEA Real Estate NTR Index", "I:NQEMEA35T": "NASDAQ EMEA Real Estate TR Index", "I:NQEMEA40": "Nasdaq EMEA Consumer Discretionary Index", "I:NQEMEA4010": "Nasdaq EMEA Automobiles and Parts Index", "I:NQEMEA4010LM": "Nasdaq EMEA Automobiles and Parts Large Mid Cap Index", "I:NQEMEA4010LMN": "Nasdaq EMEA Automobiles and Parts Large Mid Cap NTR Index", "I:NQEMEA4010LMT": "Nasdaq EMEA Automobiles and Parts Large Mid Cap TR Index", "I:NQEMEA4010N": "Nasdaq EMEA Automobiles and Parts NTR Index", "I:NQEMEA4010T": "Nasdaq EMEA Automobiles and Parts TR Index", "I:NQEMEA4020": "Nasdaq EMEA Consumer Products and Services Index", "I:NQEMEA4020LM": "Nasdaq EMEA Consumer Products and Services Large Mid Cap Index", "I:NQEMEA4020LMN": "Nasdaq EMEA Consumer Products and Services Large Mid Cap NTR Index", "I:NQEMEA4020LMT": "Nasdaq EMEA Consumer Products and Services Large Mid Cap TR Index", "I:NQEMEA4020N": "Nasdaq EMEA Consumer Products and Services NTR Index", "I:NQEMEA4020T": "Nasdaq EMEA Consumer Products and Services TR Index", "I:NQEMEA4030": "NASDAQ EMEA Media Index", "I:NQEMEA4030LM": "Nasdaq EMEA Media Large Mid Cap Index", "I:NQEMEA4030LMN": "NASDAQ EMEA Media Large Mid Cap NTR Index", "I:NQEMEA4030LMT": "NASDAQ EMEA Media Large Mid Cap TR Index", "I:NQEMEA4030N": "NASDAQ EMEA Media NTR Index", "I:NQEMEA4030T": "NASDAQ EMEA Media TR Index", "I:NQEMEA4040": "NASDAQ EMEA Retail Index", "I:NQEMEA4040LM": "Nasdaq EMEA Retail Large Mid Cap Index", "I:NQEMEA4040LMN": "NASDAQ EMEA Retail Large Mid Cap NTR Index", "I:NQEMEA4040LMT": "NASDAQ EMEA Retail Large Mid Cap TR Index", "I:NQEMEA4040N": "NASDAQ EMEA Retail NTR Index", "I:NQEMEA4040T": "NASDAQ EMEA Retail TR Index", "I:NQEMEA4050": "Nasdaq EMEA Travel and Leisure Index", "I:NQEMEA4050LM": "Nasdaq EMEA Travel and Leisure Large Mid Cap Index", "I:NQEMEA4050LMN": "Nasdaq EMEA Travel and Leisure Large Mid Cap NTR Index", "I:NQEMEA4050LMT": "Nasdaq EMEA Travel and Leisure Large Mid Cap TR Index", "I:NQEMEA4050N": "Nasdaq EMEA Travel and Leisure NTR Index", "I:NQEMEA4050T": "Nasdaq EMEA Travel and Leisure TR Index", "I:NQEMEA40LM": "Nasdaq EMEA Consumer Discretionary Large Mid Cap Index", "I:NQEMEA40LMN": "Nasdaq EMEA Consumer Discretionary Large Mid Cap NTR Index", "I:NQEMEA40LMT": "Nasdaq EMEA Consumer Discretionary Large Mid Cap TR Index", "I:NQEMEA40N": "Nasdaq EMEA Consumer Discretionary NTR Index", "I:NQEMEA40T": "Nasdaq EMEA Consumer Discretionary TR Index", "I:NQEMEA45": "Nasdaq EMEA Consumer Staples Index", "I:NQEMEA4510": "Nasdaq EMEA Food, Beverage and Tobacco Index", "I:NQEMEA4510LM": "Nasdaq EMEA Food, Beverage and Tobacco Large Mid Cap Index", "I:NQEMEA4510LMN": "Nasdaq EMEA Food, Beverage and Tobacco Large Mid Cap NTR Index", "I:NQEMEA4510LMT": "Nasdaq EMEA Food, Beverage and Tobacco Large Mid Cap TR Index", "I:NQEMEA4510N": "Nasdaq EMEA Food, Beverage and Tobacco NTR Index", "I:NQEMEA4510T": "Nasdaq EMEA Food, Beverage and Tobacco TR Index", "I:NQEMEA4520": "Nasdaq EMEA Personal Care, Drug and Grocery Stores Index", "I:NQEMEA4520LM": "Nasdaq EMEA Personal Care, Drug and Grocery Stores Large Mid Cap Index", "I:NQEMEA4520LMN": "Nasdaq EMEA Personal Care, Drug and Grocery Stores Large Mid Cap NTR Index", "I:NQEMEA4520LMT": "Nasdaq EMEA Personal Care, Drug and Grocery Stores Large Mid Cap TR Index", "I:NQEMEA4520N": "Nasdaq EMEA Personal Care, Drug and Grocery Stores NTR Index", "I:NQEMEA4520T": "Nasdaq EMEA Personal Care, Drug and Grocery Stores TR Index", "I:NQEMEA45LM": "Nasdaq EMEA Consumer Staples Large Mid Cap Index", "I:NQEMEA45LMN": "Nasdaq EMEA Consumer Staples Large Mid Cap NTR Index", "I:NQEMEA45LMT": "Nasdaq EMEA Consumer Staples Large Mid Cap TR Index", "I:NQEMEA45N": "Nasdaq EMEA Consumer Staples NTR Index", "I:NQEMEA45T": "Nasdaq EMEA Consumer Staples TR Index", "I:NQEMEA50": "Nasdaq EMEA Industrials Index", "I:NQEMEA5010": "Nasdaq EMEA Construction and Materials Index", "I:NQEMEA5010LM": "Nasdaq EMEA Construction and Materials Large Mid Cap Index", "I:NQEMEA5010LMN": "Nasdaq EMEA Construction and Materials Large Mid Cap NTR Index", "I:NQEMEA5010LMT": "Nasdaq EMEA Construction and Materials Large Mid Cap TR Index", "I:NQEMEA5010N": "Nasdaq EMEA Construction and Materials NTR Index", "I:NQEMEA5010T": "Nasdaq EMEA Construction and Materials TR Index", "I:NQEMEA5020": "Nasdaq EMEA Industrial Goods and Services Index", "I:NQEMEA5020LM": "Nasdaq EMEA Industrial Goods and Services Large Mid Cap Index", "I:NQEMEA5020LMN": "Nasdaq EMEA Industrial Goods and Services Large Mid Cap NTR Index", "I:NQEMEA5020LMT": "Nasdaq EMEA Industrial Goods and Services Large Mid Cap TR Index", "I:NQEMEA5020N": "Nasdaq EMEA Industrial Goods and Services NTR Index", "I:NQEMEA5020T": "Nasdaq EMEA Industrial Goods and Services TR Index", "I:NQEMEA50LM": "Nasdaq EMEA Industrials Large Mid Cap Index", "I:NQEMEA50LMN": "Nasdaq EMEA Industrials Large Mid Cap NTR Index", "I:NQEMEA50LMT": "Nasdaq EMEA Industrials Large Mid Cap TR Index", "I:NQEMEA50N": "Nasdaq EMEA Industrials NTR Index", "I:NQEMEA50T": "Nasdaq EMEA Industrials TR Index", "I:NQEMEA55": "Nasdaq EMEA Basic Materials Index", "I:NQEMEA5510": "NASDAQ EMEA Basic Resources Index", "I:NQEMEA5510LM": "Nasdaq EMEA Basic Resources Large Mid Cap Index", "I:NQEMEA5510LMN": "Nasdaq EMEA Basic Resources Large Mid Cap NTR Index", "I:NQEMEA5510LMT": "Nasdaq EMEA Basic Resources Large Mid Cap TR Index", "I:NQEMEA5510N": "NASDAQ EMEA Basic Resources NTR Index", "I:NQEMEA5510T": "NASDAQ EMEA Basic Resources TR Index", "I:NQEMEA5520": "NASDAQ EMEA Chemicals Index", "I:NQEMEA5520LM": "Nasdaq EMEA Chemicals Large Mid Cap Index", "I:NQEMEA5520LMN": "NASDAQ EMEA Chemicals Large Mid Cap NTR Index", "I:NQEMEA5520LMT": "NASDAQ EMEA Chemicals Large Mid Cap TR Index", "I:NQEMEA5520N": "NASDAQ EMEA Chemicals NTR Index", "I:NQEMEA5520T": "NASDAQ EMEA Chemicals TR Index", "I:NQEMEA55LM": "Nasdaq EMEA Basic Materials Large Mid Cap Index", "I:NQEMEA55LMN": "Nasdaq EMEA Basic Materials Large Mid Cap NTR Index", "I:NQEMEA55LMT": "Nasdaq EMEA Basic Materials Large Mid Cap TR Index", "I:NQEMEA55N": "Nasdaq EMEA Basic Materials NTR Index", "I:NQEMEA55T": "Nasdaq EMEA Basic Materials TR Index", "I:NQEMEA60": "Nasdaq EMEA Energy Index", "I:NQEMEA60LM": "Nasdaq EMEA Energy Large Mid Cap Index", "I:NQEMEA60LMN": "Nasdaq EMEA Energy Large Mid Cap NTR Index", "I:NQEMEA60LMT": "Nasdaq EMEA Energy Large Mid Cap TR Index", "I:NQEMEA60N": "Nasdaq EMEA Energy NTR Index", "I:NQEMEA60T": "Nasdaq EMEA Energy TR Index", "I:NQEMEA65": "NASDAQ EMEA Utilities Index", "I:NQEMEA65LM": "Nasdaq EMEA Utilities Large Mid Cap Index", "I:NQEMEA65LMN": "NASDAQ EMEA Utilities Large Mid Cap NTR Index", "I:NQEMEA65LMT": "NASDAQ EMEA Utilities Large Mid Cap TR Index", "I:NQEMEA65N": "NASDAQ EMEA Utilities NTR Index", "I:NQEMEA65T": "NASDAQ EMEA Utilities TR Index", "I:NQEMEALC": "NASDAQ EMEA Large Cap Index", "I:NQEMEALCN": "NASDAQ EMEA Large Cap NTR Index", "I:NQEMEALCT": "NASDAQ EMEA Large Cap TR Index", "I:NQEMEALM": "NASDAQ EMEA Large Mid Cap Index", "I:NQEMEALMN": "NASDAQ EMEA Large Mid Cap NTR Index", "I:NQEMEALMT": "NASDAQ EMEA Large Mid Cap TR Index", "I:NQEMEAMC": "NASDAQ EMEA Mid Cap Index", "I:NQEMEAMCN": "NASDAQ EMEA Mid Cap NTR Index", "I:NQEMEAMCT": "NASDAQ EMEA Mid Cap TR Index", "I:NQEMEAN": "NASDAQ EMEA NTR Index", "I:NQEMEASC": "NASDAQ EMEA Small Cap Index", "I:NQEMEASCN": "NASDAQ EMEA Small Cap NTR Index", "I:NQEMEASCT": "NASDAQ EMEA Small Cap TR Index", "I:NQEMEAT": "NASDAQ EMEA TR Index", "I:NQEMEU": "NASDAQ EM Europe Index", "I:NQEMEU15": "Nasdaq EM Europe Telecommunications Index", "I:NQEMEU15LM": "Nasdaq EM Europe Telecommunications Large Mid Cap Index", "I:NQEMEU15LMN": "Nasdaq EM Europe Telecommunications Large Mid Cap NTR Index", "I:NQEMEU15LMT": "Nasdaq EM Europe Telecommunications Large Mid Cap TR Index", "I:NQEMEU15N": "Nasdaq EM Europe Telecommunications NTR Index", "I:NQEMEU15T": "Nasdaq EM Europe Telecommunications TR Index", "I:NQEMEU20": "NASDAQ EM Europe Health Care Index", "I:NQEMEU20N": "NASDAQ EM Europe Health Care NTR Index", "I:NQEMEU20T": "NASDAQ EM Europe Health Care TR Index", "I:NQEMEU30": "NASDAQ EM Europe Financials Index", "I:NQEMEU3010": "NASDAQ EM Europe Banks Index", "I:NQEMEU3010LM": "Nasdaq EM Europe Banks Large Mid Cap Index", "I:NQEMEU3010LMN": "NASDAQ EM Europe Banks Large Mid Cap NTR Index", "I:NQEMEU3010LMT": "NASDAQ EM Europe Banks Large Mid Cap TR Index", "I:NQEMEU3010N": "NASDAQ EM Europe Banks NTR Index", "I:NQEMEU3010T": "NASDAQ EM Europe Banks TR Index", "I:NQEMEU3020": "Nasdaq EM Europe Financial Services Index", "I:NQEMEU3020N": "Nasdaq EM Europe Financial Services NTR Index", "I:NQEMEU3020T": "Nasdaq EM Europe Financial Services TR Index", "I:NQEMEU30LM": "Nasdaq EM Europe Financials Large Mid Cap Index", "I:NQEMEU30LMN": "Nasdaq EM Europe Financials Large Mid Cap NTR Index", "I:NQEMEU30LMT": "Nasdaq EM Europe Financials Large Mid Cap TR Index", "I:NQEMEU30N": "NASDAQ EM Europe Financials NTR Index", "I:NQEMEU30T": "NASDAQ EM Europe Financials TR Index", "I:NQEMEU35": "NASDAQ EM Europe Real Estate Index", "I:NQEMEU35N": "NASDAQ EM Europe Real Estate NTR Index", "I:NQEMEU35T": "NASDAQ EM Europe Real Estate TR Index", "I:NQEMEU40": "Nasdaq EM Europe Consumer Discretionary Index", "I:NQEMEU4010": "Nasdaq EM Europe Automobiles and Parts Index", "I:NQEMEU4010N": "Nasdaq EM Europe Automobiles and Parts NTR Index", "I:NQEMEU4010T": "Nasdaq EM Europe Automobiles and Parts TR Index", "I:NQEMEU4020": "Nasdaq EM Europe Consumer Products and Services Index", "I:NQEMEU4020N": "Nasdaq EM Europe Consumer Products and Services NTR Index", "I:NQEMEU4020T": "Nasdaq EM Europe Consumer Products and Services TR Index", "I:NQEMEU4040": "NASDAQ EM Europe Retail Index", "I:NQEMEU4040N": "NASDAQ EM Europe Retail NTR Index", "I:NQEMEU4040T": "NASDAQ EM Europe Retail TR Index", "I:NQEMEU4050": "Nasdaq EM Europe Travel and Leisure Index", "I:NQEMEU4050N": "Nasdaq EM Europe Travel and Leisure NTR Index", "I:NQEMEU4050T": "Nasdaq EM Europe Travel and Leisure TR Index", "I:NQEMEU40LM": "Nasdaq EM Europe Consumer Discretionary Large Mid Cap Index", "I:NQEMEU40LMN": "Nasdaq EM Europe Consumer Discretionary Large Mid Cap NTR Index", "I:NQEMEU40LMT": "Nasdaq EM Europe Consumer Discretionary Large Mid Cap TR Index", "I:NQEMEU40N": "Nasdaq EM Europe Consumer Discretionary NTR Index", "I:NQEMEU40T": "Nasdaq EM Europe Consumer Discretionary TR Index", "I:NQEMEU45": "Nasdaq EM Europe Consumer Staples Index", "I:NQEMEU4510": "Nasdaq EM Europe Food, Beverage and Tobacco Index", "I:NQEMEU4510N": "Nasdaq EM Europe Food, Beverage and Tobacco NTR Index", "I:NQEMEU4510T": "Nasdaq EM Europe Food, Beverage and Tobacco TR Index", "I:NQEMEU4520": "Nasdaq EM Europe Personal Care, Drug and Grocery Stores Index", "I:NQEMEU4520N": "Nasdaq EM Europe Personal Care, Drug and Grocery Stores NTR Index", "I:NQEMEU4520T": "Nasdaq EM Europe Personal Care, Drug and Grocery Stores TR Index", "I:NQEMEU45LM": "Nasdaq EM Europe Consumer Staples Large Mid Cap Index", "I:NQEMEU45LMN": "Nasdaq EM Europe Consumer Staples Large Mid Cap NTR Index", "I:NQEMEU45LMT": "Nasdaq EM Europe Consumer Staples Large Mid Cap TR Index", "I:NQEMEU45N": "Nasdaq EM Europe Consumer Staples NTR Index", "I:NQEMEU45T": "Nasdaq EM Europe Consumer Staples TR Index", "I:NQEMEU50": "Nasdaq EM Europe Industrials Index", "I:NQEMEU5010": "Nasdaq EM Europe Construction and Materials Index", "I:NQEMEU5010N": "Nasdaq EM Europe Construction and Materials NTR Index", "I:NQEMEU5010T": "Nasdaq EM Europe Construction and Materials TR Index", "I:NQEMEU5020": "Nasdaq EM Europe Industrial Goods and Services Index", "I:NQEMEU5020N": "Nasdaq EM Europe Industrial Goods and Services NTR Index", "I:NQEMEU5020T": "Nasdaq EM Europe Industrial Goods and Services TR Index", "I:NQEMEU50N": "Nasdaq EM Europe Industrials NTR Index", "I:NQEMEU50T": "Nasdaq EM Europe Industrials TR Index", "I:NQEMEU55": "Nasdaq EM Europe Basic Materials Index", "I:NQEMEU5510": "NASDAQ EM Europe Basic Resources Index", "I:NQEMEU5510LM": "Nasdaq EM Europe Basic Resources Large Mid Cap Index", "I:NQEMEU5510LMN": "Nasdaq EM Europe Basic Resources Large Mid Cap NTR Index", "I:NQEMEU5510LMT": "Nasdaq EM Europe Basic Resources Large Mid Cap TR Index", "I:NQEMEU5510N": "NASDAQ EM Europe Basic Resources NTR Index", "I:NQEMEU5510T": "NASDAQ EM Europe Basic Resources TR Index", "I:NQEMEU5520": "NASDAQ EM Europe Chemicals Index", "I:NQEMEU5520N": "NASDAQ EM Europe Chemicals NTR Index", "I:NQEMEU5520T": "NASDAQ EM Europe Chemicals TR Index", "I:NQEMEU55LM": "Nasdaq EM Europe Basic Materials Large Mid Cap Index", "I:NQEMEU55LMN": "Nasdaq EM Europe Basic Materials Large Mid Cap NTR Index", "I:NQEMEU55LMT": "Nasdaq EM Europe Basic Materials Large Mid Cap TR Index", "I:NQEMEU55N": "Nasdaq EM Europe Basic Materials NTR Index", "I:NQEMEU55T": "Nasdaq EM Europe Basic Materials TR Index", "I:NQEMEU60": "Nasdaq EM Europe Energy Index", "I:NQEMEU60LM": "Nasdaq EM Europe Energy Large Mid Cap Index", "I:NQEMEU60LMN": "Nasdaq EM Europe Energy Large Mid Cap NTR Index", "I:NQEMEU60LMT": "Nasdaq EM Europe Energy Large Mid Cap TR Index", "I:NQEMEU60N": "Nasdaq EM Europe Energy NTR Index", "I:NQEMEU60T": "Nasdaq EM Europe Energy TR Index", "I:NQEMEU65": "NASDAQ EM Europe Utilities Index", "I:NQEMEU65LM": "Nasdaq EM Europe Utilities Large Mid Cap Index", "I:NQEMEU65LMN": "NASDAQ EM Europe Utilities Large Mid Cap NTR Index", "I:NQEMEU65LMT": "NASDAQ EM Europe Utilities Large Mid Cap TR Index", "I:NQEMEU65N": "NASDAQ EM Europe Utilities NTR Index", "I:NQEMEU65T": "NASDAQ EM Europe Utilities TR Index", "I:NQEMEULC": "NASDAQ EM Europe Large Cap Index", "I:NQEMEULCN": "NASDAQ EM Europe Large Cap NTR Index", "I:NQEMEULCT": "NASDAQ EM Europe Large Cap TR Index", "I:NQEMEULM": "NASDAQ EM Europe Large Mid Cap Index", "I:NQEMEULMN": "NASDAQ EM Europe Large Mid Cap NTR Index", "I:NQEMEULMT": "NASDAQ EM Europe Large Mid Cap TR Index", "I:NQEMEUMC": "NASDAQ EM Europe Mid Cap Index", "I:NQEMEUMCN": "NASDAQ EM Europe Mid Cap NTR Index", "I:NQEMEUMCT": "NASDAQ EM Europe Mid Cap TR Index", "I:NQEMEUN": "NASDAQ EM Europe NTR Index", "I:NQEMEUSC": "NASDAQ EM Europe Small Cap Index", "I:NQEMEUSCN": "NASDAQ EM Europe Small Cap NTR Index", "I:NQEMEUSCT": "NASDAQ EM Europe Small Cap TR Index", "I:NQEMEUT": "NASDAQ EM Europe TR Index", "I:NQEMKR": "Nasdaq Emerging Markets Plus Korea Index", "I:NQEMKRLC": "Nasdaq EM Plus Korea Large Cap", "I:NQEMKRLCN": "Nasdaq EM Plus Korea Large Cap NTR", "I:NQEMKRLCT": "Nasdaq EM Plus Korea Large Cap TR", "I:NQEMKRLM": "Nasdaq EM Plus Korea Large Mid Cap", "I:NQEMKRLMN": "Nasdaq EM Plus Korea Large Mid Cap NTR", "I:NQEMKRLMT": "Nasdaq EM Plus Korea Large Mid Cap TR", "I:NQEMKRMC": "Nasdaq EM Plus Korea Mid Cap", "I:NQEMKRMCN": "Nasdaq EM Plus Korea Mid Cap NTR", "I:NQEMKRMCT": "Nasdaq EM Plus Korea Mid Cap TR", "I:NQEMKRN": "Nasdaq EM Plus Korea NTR", "I:NQEMKRSC": "Nasdaq EM Plus Korea Small Cap", "I:NQEMKRSCN": "Nasdaq EM Plus Korea Small Cap NTR", "I:NQEMKRSCT": "Nasdaq EM Plus Korea Small Cap TR", "I:NQEMKRT": "Nasdaq EM Plus Korea TR", "I:NQEMLC": "NASDAQ Emerging Large Cap Index", "I:NQEMLCN": "NASDAQ Emerging Large Cap NTR Index", "I:NQEMLCT": "NASDAQ Emerging Large Cap TR Index", "I:NQEMLMC": "NASDAQ Emerging Large Mid Cap Index", "I:NQEMLMCN": "NASDAQ Emerging Large Mid Cap NTR Index", "I:NQEMLMCT": "NASDAQ Emerging Large Mid Cap TR Index", "I:NQEMMC": "NASDAQ Emerging Mid Cap Index", "I:NQEMMCN": "NASDAQ Emerging Mid Cap NTR Index", "I:NQEMMCT": "NASDAQ Emerging Mid Cap TR Index", "I:NQEMMEA": "NASDAQ EM MEA Index", "I:NQEMMEA10": "Nasdaq EM MEA Technology Index", "I:NQEMMEA10N": "Nasdaq EM MEA Technology NTR Index", "I:NQEMMEA10T": "Nasdaq EM MEA Technology TR Index", "I:NQEMMEA15": "Nasdaq EM MEA Telecommunications Index", "I:NQEMMEA15LM": "Nasdaq EM MEA Telecommunications Large Mid Cap Index", "I:NQEMMEA15LMN": "Nasdaq EM MEA Telecommunications Large Mid Cap NTR Index", "I:NQEMMEA15LMT": "Nasdaq EM MEA Telecommunications Large Mid Cap TR Index", "I:NQEMMEA15N": "Nasdaq EM MEA Telecommunications NTR Index", "I:NQEMMEA15T": "Nasdaq EM MEA Telecommunications TR Index", "I:NQEMMEA20": "NASDAQ EM MEA Health Care Index", "I:NQEMMEA20N": "NASDAQ EM MEA Health Care NTR Index", "I:NQEMMEA20T": "NASDAQ EM MEA Health Care TR Index", "I:NQEMMEA30": "NASDAQ EM MEA Financials Index", "I:NQEMMEA3010": "NASDAQ EM MEA Banks Index", "I:NQEMMEA3010LM": "Nasdaq EM MEA Banks Large Mid Cap Index", "I:NQEMMEA3010LMN": "NASDAQ EM MEA Banks Large Mid Cap NTR Index", "I:NQEMMEA3010LMT": "NASDAQ EM MEA Banks Large Mid Cap TR Index", "I:NQEMMEA3010N": "NASDAQ EM MEA Banks NTR Index", "I:NQEMMEA3010T": "NASDAQ EM MEA Banks TR Index", "I:NQEMMEA3020": "Nasdaq EM MEA Financial Services Index", "I:NQEMMEA3020LM": "Nasdaq EM MEA Financial Services Large Mid Cap Index", "I:NQEMMEA3020LMN": "Nasdaq EM MEA Financial Services Large Mid Cap NTR Index", "I:NQEMMEA3020LMT": "Nasdaq EM MEA Financial Services Large Mid Cap TR Index", "I:NQEMMEA3020N": "Nasdaq EM MEA Financial Services NTR Index", "I:NQEMMEA3020T": "Nasdaq EM MEA Financial Services TR Index", "I:NQEMMEA3030": "Nasdaq EM MEA Insurance Index", "I:NQEMMEA3030LM": "Nasdaq EM MEA Insurance Large Mid Cap Index", "I:NQEMMEA3030LMN": "Nasdaq EM MEA Insurance Large Mid Cap NTR Index", "I:NQEMMEA3030LMT": "Nasdaq EM MEA Insurance Large Mid Cap TR Index", "I:NQEMMEA3030N": "Nasdaq EM MEA Insurance NTR Index", "I:NQEMMEA3030T": "Nasdaq EM MEA Insurance TR Index", "I:NQEMMEA30LM": "Nasdaq EM MEA Financials Large Mid Cap Index", "I:NQEMMEA30LMN": "NASDAQ EM MEA Financials Large Mid Cap NTR Index", "I:NQEMMEA30LMT": "NASDAQ EM MEA Financials Large Mid Cap TR Index", "I:NQEMMEA30N": "NASDAQ EM MEA Financials NTR Index", "I:NQEMMEA30T": "NASDAQ EM MEA Financials TR Index", "I:NQEMMEA35": "NASDAQ EM MEA Real Estate Index", "I:NQEMMEA35LM": "Nasdaq EM MEA Real Estate Large Mid Cap Index", "I:NQEMMEA35LMN": "NASDAQ EM MEA Real Estate Large Mid Cap NTR Index", "I:NQEMMEA35LMT": "NASDAQ EM MEA Real Estate Large Mid Cap TR Index", "I:NQEMMEA35N": "NASDAQ EM MEA Real Estate NTR Index", "I:NQEMMEA35T": "NASDAQ EM MEA Real Estate TR Index", "I:NQEMMEA40": "Nasdaq EM MEA Consumer Discretionary Index", "I:NQEMMEA4040": "NASDAQ EM MEA Retail Index", "I:NQEMMEA4040LM": "Nasdaq EM MEA Retail Large Mid Cap Index", "I:NQEMMEA4040LMN": "NASDAQ EM MEA Retail Large Mid Cap NTR Index", "I:NQEMMEA4040LMT": "NASDAQ EM MEA Retail Large Mid Cap TR Index", "I:NQEMMEA4040N": "NASDAQ EM MEA Retail NTR Index", "I:NQEMMEA4040T": "NASDAQ EM MEA Retail TR Index", "I:NQEMMEA4050": "Nasdaq EM MEA Travel and Leisure Index", "I:NQEMMEA4050N": "Nasdaq EM MEA Travel and Leisure NTR Index", "I:NQEMMEA4050T": "Nasdaq EM MEA Travel and Leisure TR Index", "I:NQEMMEA40N": "Nasdaq EM MEA Consumer Discretionary NTR Index", "I:NQEMMEA40T": "Nasdaq EM MEA Consumer Discretionary TR Index", "I:NQEMMEA45": "Nasdaq EM MEA Consumer Staples Index", "I:NQEMMEA4510": "Nasdaq EM MEA Food, Beverage and Tobacco Index", "I:NQEMMEA4510LM": "Nasdaq EM MEA Food, Beverage and Tobacco Large Mid Cap Index", "I:NQEMMEA4510LMN": "Nasdaq EM MEA Food, Beverage and Tobacco Large Mid Cap NTR Index", "I:NQEMMEA4510LMT": "Nasdaq EM MEA Food, Beverage and Tobacco Large Mid Cap TR Index", "I:NQEMMEA4510N": "Nasdaq EM MEA Food, Beverage and Tobacco NTR Index", "I:NQEMMEA4510T": "Nasdaq EM MEA Food, Beverage and Tobacco TR Index", "I:NQEMMEA4520": "Nasdaq EM MEA Personal Care, Drug and Grocery Stores Index", "I:NQEMMEA4520N": "Nasdaq EM MEA Personal Care, Drug and Grocery Stores NTR Index", "I:NQEMMEA4520T": "Nasdaq EM MEA Personal Care, Drug and Grocery Stores TR Index", "I:NQEMMEA45LM": "Nasdaq EM MEA Consumer Staples Large Mid Cap Index", "I:NQEMMEA45LMN": "Nasdaq EM MEA Consumer Staples Large Mid Cap NTR Index", "I:NQEMMEA45LMT": "Nasdaq EM MEA Consumer Staples Large Mid Cap TR Index", "I:NQEMMEA45N": "Nasdaq EM MEA Consumer Staples NTR Index", "I:NQEMMEA45T": "Nasdaq EM MEA Consumer Staples TR Index", "I:NQEMMEA50": "Nasdaq EM MEA Industrials Index", "I:NQEMMEA5010": "Nasdaq EM MEA Construction and Materials Index", "I:NQEMMEA5010N": "Nasdaq EM MEA Construction and Materials NTR Index", "I:NQEMMEA5010T": "Nasdaq EM MEA Construction and Materials TR Index", "I:NQEMMEA5020": "Nasdaq EM MEA Industrial Goods and Services Index", "I:NQEMMEA5020LM": "Nasdaq EM MEA Industrial Goods and Services Large Mid Cap Index", "I:NQEMMEA5020LMN": "Nasdaq EM MEA Industrial Goods and Services Large Mid Cap NTR Index", "I:NQEMMEA5020LMT": "Nasdaq EM MEA Industrial Goods and Services Large Mid Cap TR Index", "I:NQEMMEA5020N": "Nasdaq EM MEA Industrial Goods and Services NTR Index", "I:NQEMMEA5020T": "Nasdaq EM MEA Industrial Goods and Services TR Index", "I:NQEMMEA50LM": "Nasdaq EM MEA Industrials Large Mid Cap Index", "I:NQEMMEA50LMN": "Nasdaq EM MEA Industrials Large Mid Cap NTR Index", "I:NQEMMEA50LMT": "Nasdaq EM MEA Industrials Large Mid Cap TR Index", "I:NQEMMEA50N": "Nasdaq EM MEA Industrials NTR Index", "I:NQEMMEA50T": "Nasdaq EM MEA Industrials TR Index", "I:NQEMMEA55": "Nasdaq EM MEA Basic Materials Index", "I:NQEMMEA5510": "NASDAQ EM MEA Basic Resources Index", "I:NQEMMEA5510LM": "Nasdaq EM MEA Basic Resources Large Mid Cap Index", "I:NQEMMEA5510LMN": "Nasdaq EM MEA Basic Resources Large Mid Cap NTR Index", "I:NQEMMEA5510LMT": "Nasdaq EM MEA Basic Resources Large Mid Cap TR Index", "I:NQEMMEA5510N": "NASDAQ EM MEA Basic Resources NTR Index", "I:NQEMMEA5510T": "NASDAQ EM MEA Basic Resources TR Index", "I:NQEMMEA5520": "NASDAQ EM MEA Chemicals Index", "I:NQEMMEA5520N": "NASDAQ EM MEA Chemicals NTR Index", "I:NQEMMEA5520T": "NASDAQ EM MEA Chemicals TR Index", "I:NQEMMEA55LM": "Nasdaq EM MEA Basic Materials Large Mid Cap Index", "I:NQEMMEA55LMN": "Nasdaq EM MEA Basic Materials Large Mid Cap NTR Index", "I:NQEMMEA55LMT": "Nasdaq EM MEA Basic Materials Large Mid Cap TR Index", "I:NQEMMEA55N": "Nasdaq EM MEA Basic Materials NTR Index", "I:NQEMMEA55T": "Nasdaq EM MEA Basic Materials TR Index", "I:NQEMMEALC": "NASDAQ EM MEA Large Cap Index", "I:NQEMMEALCN": "NASDAQ EM MEA Large Cap NTR Index", "I:NQEMMEALCT": "NASDAQ EM MEA Large Cap TR Index", "I:NQEMMEALM": "NASDAQ EM MEA Large Mid Cap Index", "I:NQEMMEALMN": "NASDAQ EM MEA Large Mid Cap NTR Index", "I:NQEMMEALMT": "NASDAQ EM MEA Large Mid Cap TR Index", "I:NQEMMEAMC": "NASDAQ EM MEA Mid Cap Index", "I:NQEMMEAMCN": "NASDAQ EM MEA Mid Cap NTR Index", "I:NQEMMEAMCT": "NASDAQ EM MEA Mid Cap TR Index", "I:NQEMMEAN": "NASDAQ EM MEA NTR Index", "I:NQEMMEASC": "NASDAQ EM MEA Small Cap Index", "I:NQEMMEASCN": "NASDAQ EM MEA Small Cap NTR Index", "I:NQEMMEASCT": "NASDAQ EM MEA Small Cap TR Index", "I:NQEMMEAT": "NASDAQ EM MEA TR Index", "I:NQEMN": "NASDAQ Emerging Markets NTR Index", "I:NQEMSC": "NASDAQ Emerging Small Cap Index", "I:NQEMSCN": "NASDAQ Emerging Small Cap NTR Index", "I:NQEMSCT": "NASDAQ Emerging Small Cap TR Index", "I:NQEMT": "NASDAQ Emerging Markets TR Index", "I:NQERR": "Nasdaq US Large Cap Equity Rising Rates Index", "I:NQERRN": "Nasdaq US Large Cap Equity Rising Rates NTR Index", "I:NQERRT": "Nasdaq US Large Cap Equity Rising Rates TR Index", "I:NQES": "NASDAQ Spain Index", "I:NQES20": "NASDAQ Spain Health Care Index", "I:NQES20N": "NASDAQ Spain Health Care NTR Index", "I:NQES20T": "NASDAQ Spain Health Care TR Index", "I:NQES30": "NASDAQ Spain Financials Index", "I:NQES30LM": "Nasdaq Spain Financials Large Mid Cap Index", "I:NQES30LMN": "NASDAQ Spain Financials Large Mid Cap NTR Index", "I:NQES30LMT": "NASDAQ Spain Financials Large Mid Cap TR Index", "I:NQES30N": "NASDAQ Spain Financials NTR Index", "I:NQES30T": "NASDAQ Spain Financials TR Index", "I:NQES35": "Nasdaq Spain Real Estate Index", "I:NQES35N": "Nasdaq Spain Real Estate NTR Index", "I:NQES35T": "Nasdaq Spain Real Estate TR Index", "I:NQES40": "Nasdaq Spain Consumer Discretionary Index", "I:NQES40N": "Nasdaq Spain Consumer Discretionary NTR Index", "I:NQES40T": "Nasdaq Spain Consumer Discretionary TR Index", "I:NQES50": "Nasdaq Spain Industrials Index", "I:NQES50LM": "Nasdaq Spain Industrials Large Mid Cap Index", "I:NQES50LMN": "Nasdaq Spain Industrials Large Mid Cap NTR Index", "I:NQES50LMT": "Nasdaq Spain Industrials Large Mid Cap TR Index", "I:NQES50N": "Nasdaq Spain Industrials NTR Index", "I:NQES50T": "Nasdaq Spain Industrials TR Index", "I:NQES55": "Nasdaq Spain Basic Materials Index", "I:NQES55N": "Nasdaq Spain Basic Materials NTR Index", "I:NQES55T": "Nasdaq Spain Basic Materials TR Index", "I:NQES60": "Nasdaq Spain Energy Index", "I:NQES60LM": "Nasdaq Spain Energy Large Mid Cap Index", "I:NQES60LMN": "Nasdaq Spain Energy Large Mid Cap NTR Index", "I:NQES60LMT": "Nasdaq Spain Energy Large Mid Cap TR Index", "I:NQES60N": "Nasdaq Spain Energy NTR Index", "I:NQES60T": "Nasdaq Spain Energy TR Index", "I:NQES65": "NASDAQ Spain Utilities Index", "I:NQES65LM": "Nasdaq Spain Utilities Large Mid Cap Index", "I:NQES65LMN": "NASDAQ Spain Utilities Large Mid Cap NTR Index", "I:NQES65LMT": "NASDAQ Spain Utilities Large Mid Cap TR Index", "I:NQES65N": "NASDAQ Spain Utilities NTR Index", "I:NQES65T": "NASDAQ Spain Utilities TR Index", "I:NQESLC": "NASDAQ Spain Large Cap Index", "I:NQESLCN": "NASDAQ Spain Large Cap NTR Index", "I:NQESLCT": "NASDAQ Spain Large Cap TR Index", "I:NQESLM": "NASDAQ Spain Large Mid Cap Index", "I:NQESLMN": "NASDAQ Spain Large Mid Cap NTR Index", "I:NQESLMT": "NASDAQ Spain Large Mid Cap TR Index", "I:NQESMC": "NASDAQ Spain Mid Cap Index", "I:NQESMCN": "NASDAQ Spain Mid Cap NTR Index", "I:NQESMCT": "NASDAQ Spain Mid Cap TR Index", "I:NQESN": "NASDAQ Spain NTR Index", "I:NQESSC": "NASDAQ Spain Small Cap Index", "I:NQESSCN": "NASDAQ Spain Small Cap NTR Index", "I:NQESSCT": "NASDAQ Spain Small Cap TR Index", "I:NQEST": "NASDAQ Spain TR Index", "I:NQETH": "Nasdaq Ether Reference Price", "I:NQEU": "NASDAQ Europe Index", "I:NQEU10": "Nasdaq Europe Technology Index", "I:NQEU10LM": "Nasdaq Europe Technology Large Mid Cap Index", "I:NQEU10LMN": "Nasdaq Europe Technology Large Mid Cap NTR Index", "I:NQEU10LMT": "Nasdaq Europe Technology Large Mid Cap TR Index", "I:NQEU10N": "Nasdaq Europe Technology NTR Index", "I:NQEU10T": "Nasdaq Europe Technology TR Index", "I:NQEU15": "Nasdaq Europe Telecommunications Index", "I:NQEU15LM": "Nasdaq Europe Telecommunications Large Mid Cap Index", "I:NQEU15LMN": "Nasdaq Europe Telecommunications Large Mid Cap NTR Index", "I:NQEU15LMT": "Nasdaq Europe Telecommunications Large Mid Cap TR Index", "I:NQEU15N": "Nasdaq Europe Telecommunications NTR Index", "I:NQEU15T": "Nasdaq Europe Telecommunications TR Index", "I:NQEU20": "NASDAQ Europe Health Care Index", "I:NQEU20LM": "Nasdaq Europe Health Care Large Mid Cap Index", "I:NQEU20LMN": "NASDAQ Europe Health Care Large Mid Cap NTR Index", "I:NQEU20LMT": "NASDAQ Europe Health Care Large Mid Cap TR Index", "I:NQEU20N": "NASDAQ Europe Health Care NTR Index", "I:NQEU20T": "NASDAQ Europe Health Care TR Index", "I:NQEU30": "NASDAQ Europe Financials Index", "I:NQEU3010": "NASDAQ Europe Banks Index", "I:NQEU3010LM": "Nasdaq Europe Banks Large Mid Cap Index", "I:NQEU3010LMN": "NASDAQ Europe Banks Large Mid Cap NTR Index", "I:NQEU3010LMT": "NASDAQ Europe Banks Large Mid Cap TR Index", "I:NQEU3010N": "NASDAQ Europe Banks NTR Index", "I:NQEU3010T": "NASDAQ Europe Banks TR Index", "I:NQEU3020": "Nasdaq Europe Financial Services Index", "I:NQEU3020LM": "Nasdaq Europe Financial Services Large Mid Cap Index", "I:NQEU3020LMN": "Nasdaq Europe Financial Services Large Mid Cap NTR Index", "I:NQEU3020LMT": "Nasdaq Europe Financial Services Large Mid Cap TR Index", "I:NQEU3020N": "Nasdaq Europe Financial Services NTR Index", "I:NQEU3020T": "Nasdaq Europe Financial Services TR Index", "I:NQEU3030": "Nasdaq Europe Insurance Index", "I:NQEU3030LM": "Nasdaq Europe Insurance Large Mid Cap Index", "I:NQEU3030LMN": "Nasdaq Europe Insurance Large Mid Cap NTR Index", "I:NQEU3030LMT": "Nasdaq Europe Insurance Large Mid Cap TR Index", "I:NQEU3030N": "Nasdaq Europe Insurance NTR Index", "I:NQEU3030T": "Nasdaq Europe Insurance TR Index", "I:NQEU30LM": "Nasdaq Europe Financials Large Mid Cap Index", "I:NQEU30LMN": "NASDAQ Europe Financials Large Mid Cap NTR Index", "I:NQEU30LMT": "NASDAQ Europe Financials Large Mid Cap TR Index", "I:NQEU30N": "NASDAQ Europe Financials NTR Index", "I:NQEU30T": "NASDAQ Europe Financials TR Index", "I:NQEU35": "NASDAQ Europe Real Estate Index", "I:NQEU35LM": "Nasdaq Europe Real Estate Large Mid Cap Index", "I:NQEU35LMN": "NASDAQ Europe Real Estate Large Mid Cap NTR Index", "I:NQEU35LMT": "NASDAQ Europe Real Estate Large Mid Cap TR Index", "I:NQEU35N": "NASDAQ Europe Real Estate NTR Index", "I:NQEU35T": "NASDAQ Europe Real Estate TR Index", "I:NQEU40": "Nasdaq Europe Consumer Discretionary Index", "I:NQEU4010": "Nasdaq Europe Automobiles and Parts Index", "I:NQEU4010LM": "Nasdaq Europe Automobiles and Parts Large Mid Cap Index", "I:NQEU4010LMN": "Nasdaq Europe Automobiles and Parts Large Mid Cap NTR Index", "I:NQEU4010LMT": "Nasdaq Europe Automobiles and Parts Large Mid Cap TR Index", "I:NQEU4010N": "Nasdaq Europe Automobiles and Parts NTR Index", "I:NQEU4010T": "Nasdaq Europe Automobiles and Parts TR Index", "I:NQEU4020": "Nasdaq Europe Consumer Products and Services Index", "I:NQEU4020LM": "Nasdaq Europe Consumer Products and Services Large Mid Cap Index", "I:NQEU4020LMN": "Nasdaq Europe Consumer Products and Services Large Mid Cap NTR Index", "I:NQEU4020LMT": "Nasdaq Europe Consumer Products and Services Large Mid Cap TR Index", "I:NQEU4020N": "Nasdaq Europe Consumer Products and Services NTR Index", "I:NQEU4020T": "Nasdaq Europe Consumer Products and Services TR Index", "I:NQEU4030": "NASDAQ Europe Media Index", "I:NQEU4030LM": "Nasdaq Europe Media Large Mid Cap Index", "I:NQEU4030LMN": "NASDAQ Europe Media Large Mid Cap NTR Index", "I:NQEU4030LMT": "NASDAQ Europe Media Large Mid Cap TR Index", "I:NQEU4030N": "NASDAQ Europe Media NTR Index", "I:NQEU4030T": "NASDAQ Europe Media TR Index", "I:NQEU4040": "NASDAQ Europe Retail Index", "I:NQEU4040LM": "Nasdaq Europe Retail Large Mid Cap Index", "I:NQEU4040LMN": "NASDAQ Europe Retail Large Mid Cap NTR Index", "I:NQEU4040LMT": "NASDAQ Europe Retail Large Mid Cap TR Index", "I:NQEU4040N": "NASDAQ Europe Retail NTR Index", "I:NQEU4040T": "NASDAQ Europe Retail TR Index", "I:NQEU4050": "Nasdaq Europe Travel and Leisure Index", "I:NQEU4050LM": "Nasdaq Europe Travel and Leisure Large Mid Cap Index", "I:NQEU4050LMN": "Nasdaq Europe Travel and Leisure Large Mid Cap NTR Index", "I:NQEU4050LMT": "Nasdaq Europe Travel and Leisure Large Mid Cap TR Index", "I:NQEU4050N": "Nasdaq Europe Travel and Leisure NTR Index", "I:NQEU4050T": "Nasdaq Europe Travel and Leisure TR Index", "I:NQEU40LM": "Nasdaq Europe Consumer Discretionary Large Mid Cap Index", "I:NQEU40LMN": "Nasdaq Europe Consumer Discretionary Large Mid Cap NTR Index", "I:NQEU40LMT": "Nasdaq Europe Consumer Discretionary Large Mid Cap TR Index", "I:NQEU40N": "Nasdaq Europe Consumer Discretionary NTR Index", "I:NQEU40T": "Nasdaq Europe Consumer Discretionary TR Index", "I:NQEU45": "Nasdaq Europe Consumer Staples Index", "I:NQEU4510": "Nasdaq Europe Food, Beverage and Tobacco Index", "I:NQEU4510LM": "Nasdaq Europe Food, Beverage and Tobacco Large Mid Cap Index", "I:NQEU4510LMN": "Nasdaq Europe Food, Beverage and Tobacco Large Mid Cap NTR Index", "I:NQEU4510LMT": "Nasdaq Europe Food, Beverage and Tobacco Large Mid Cap TR Index", "I:NQEU4510N": "Nasdaq Europe Food, Beverage and Tobacco NTR Index", "I:NQEU4510T": "Nasdaq Europe Food, Beverage and Tobacco TR Index", "I:NQEU4520": "Nasdaq Europe Personal Care, Drug and Grocery Stores Index", "I:NQEU4520LM": "Nasdaq Europe Personal Care, Drug and Grocery Stores Large Mid Cap Index", "I:NQEU4520LMN": "Nasdaq Europe Personal Care, Drug and Grocery Stores Large Mid Cap NTR Index", "I:NQEU4520LMT": "Nasdaq Europe Personal Care, Drug and Grocery Stores Large Mid Cap TR Index", "I:NQEU4520N": "Nasdaq Europe Personal Care, Drug and Grocery Stores NTR Index", "I:NQEU4520T": "Nasdaq Europe Personal Care, Drug and Grocery Stores TR Index", "I:NQEU45LM": "Nasdaq Europe Consumer Staples Large Mid Cap Index", "I:NQEU45LMN": "Nasdaq Europe Consumer Staples Large Mid Cap NTR Index", "I:NQEU45LMT": "Nasdaq Europe Consumer Staples Large Mid Cap TR Index", "I:NQEU45N": "Nasdaq Europe Consumer Staples NTR Index", "I:NQEU45T": "Nasdaq Europe Consumer Staples TR Index", "I:NQEU50": "Nasdaq Europe Industrials Index", "I:NQEU5010": "Nasdaq Europe Construction and Materials Index", "I:NQEU5010LM": "Nasdaq Europe Construction and Materials Large Mid Cap Index", "I:NQEU5010LMN": "Nasdaq Europe Construction and Materials Large Mid Cap NTR Index", "I:NQEU5010LMT": "Nasdaq Europe Construction and Materials Large Mid Cap TR Index", "I:NQEU5010N": "Nasdaq Europe Construction and Materials NTR Index", "I:NQEU5010T": "Nasdaq Europe Construction and Materials TR Index", "I:NQEU5020": "Nasdaq Europe Industrial Goods and Services Index", "I:NQEU5020LM": "Nasdaq Europe Industrial Goods and Services Large Mid Cap Index", "I:NQEU5020LMN": "Nasdaq Europe Industrial Goods and Services Large Mid Cap NTR Index", "I:NQEU5020LMT": "Nasdaq Europe Industrial Goods and Services Large Mid Cap TR Index", "I:NQEU5020N": "Nasdaq Europe Industrial Goods and Services NTR Index", "I:NQEU5020T": "Nasdaq Europe Industrial Goods and Services TR Index", "I:NQEU50LM": "Nasdaq Europe Industrials Large Mid Cap Index", "I:NQEU50LMN": "Nasdaq Europe Industrials Large Mid Cap NTR Index", "I:NQEU50LMT": "Nasdaq Europe Industrials Large Mid Cap TR Index", "I:NQEU50N": "Nasdaq Europe Industrials NTR Index", "I:NQEU50T": "Nasdaq Europe Industrials TR Index", "I:NQEU55": "Nasdaq Europe Basic Materials Index", "I:NQEU5510": "NASDAQ Europe Basic Resources Index", "I:NQEU5510LM": "Nasdaq Europe Basic Resources Large Mid Cap Index", "I:NQEU5510LMN": "Nasdaq Europe Basic Resources Large Mid Cap NTR Index", "I:NQEU5510LMT": "Nasdaq Europe Basic Resources Large Mid Cap TR Index", "I:NQEU5510N": "NASDAQ Europe Basic Resources NTR Index", "I:NQEU5510T": "NASDAQ Europe Basic Resources TR Index", "I:NQEU5520": "NASDAQ Europe Chemicals Index", "I:NQEU5520LM": "Nasdaq Europe Chemicals Large Mid Cap Index", "I:NQEU5520LMN": "NASDAQ Europe Chemicals Large Mid Cap NTR Index", "I:NQEU5520LMT": "NASDAQ Europe Chemicals Large Mid Cap TR Index", "I:NQEU5520N": "NASDAQ Europe Chemicals NTR Index", "I:NQEU5520T": "NASDAQ Europe Chemicals TR Index", "I:NQEU55LM": "Nasdaq Europe Basic Materials Large Mid Cap Index", "I:NQEU55LMN": "Nasdaq Europe Basic Materials Large Mid Cap NTR Index", "I:NQEU55LMT": "Nasdaq Europe Basic Materials Large Mid Cap TR Index", "I:NQEU55N": "Nasdaq Europe Basic Materials NTR Index", "I:NQEU55T": "Nasdaq Europe Basic Materials TR Index", "I:NQEU60": "Nasdaq Europe Energy Index", "I:NQEU60LM": "Nasdaq Europe Energy Large Mid Cap Index", "I:NQEU60LMN": "Nasdaq Europe Energy Large Mid Cap NTR Index", "I:NQEU60LMT": "Nasdaq Europe Energy Large Mid Cap TR Index", "I:NQEU60N": "Nasdaq Europe Energy NTR Index", "I:NQEU60T": "Nasdaq Europe Energy TR Index", "I:NQEU65": "NASDAQ Europe Utilities Index", "I:NQEU65LM": "Nasdaq Europe Utilities Large Mid Cap Index", "I:NQEU65LMN": "NASDAQ Europe Utilities Large Mid Cap NTR Index", "I:NQEU65LMT": "NASDAQ Europe Utilities Large Mid Cap TR Index", "I:NQEU65N": "NASDAQ Europe Utilities NTR Index", "I:NQEU65T": "NASDAQ Europe Utilities TR Index", "I:NQEULC": "NASDAQ Europe Large Cap Index", "I:NQEULCN": "NASDAQ Europe Large Cap NTR Index", "I:NQEULCT": "NASDAQ Europe Large Cap TR Index", "I:NQEULM": "NASDAQ Europe Large Mid Cap Index", "I:NQEULMN": "NASDAQ Europe Large Mid Cap NTR Index", "I:NQEULMT": "NASDAQ Europe Large Mid Cap TR Index", "I:NQEUMC": "NASDAQ Europe Mid Cap Index", "I:NQEUMCN": "NASDAQ Europe Mid Cap NTR Index", "I:NQEUMCT": "NASDAQ Europe Mid Cap TR Index", "I:NQEUN": "NASDAQ Europe NTR Index", "I:NQEURO": "NASDAQ Eurozone Index", "I:NQEURO50": "NASDAQ EURO 50 Index", "I:NQEURO50N": "NASDAQ EURO 50 Index NTR", "I:NQEURO50T": "NASDAQ EURO 50 Index TR", "I:NQEUROLM": "NASDAQ Eurozone Large Mid Cap Index", "I:NQEUROLMAUD": "NASDAQ Eurozone Large Mid Cap AUD Index", "I:NQEUROLMAUDN": "NASDAQ Eurozone Large Mid Cap AUD NTR Index", "I:NQEUROLMAUDT": "NASDAQ Eurozone Large Mid Cap AUD TR Index", "I:NQEUROLMCAD": "NASDAQ Eurozone Large Mid Cap CAD Index", "I:NQEUROLMCADN": "NASDAQ Eurozone Large Mid Cap CAD NTR Index", "I:NQEUROLMCADT": "NASDAQ Eurozone Large Mid Cap CAD TR Index", "I:NQEUROLMEUR": "NASDAQ Eurozone Large Mid Cap EUR Index", "I:NQEUROLMEURN": "NASDAQ Eurozone Large Mid Cap EUR NTR Index", "I:NQEUROLMEURT": "NASDAQ Eurozone Large Mid Cap EUR TR Index", "I:NQEUROLMGBP": "NASDAQ Eurozone Large Mid Cap GBP Index", "I:NQEUROLMGBPN": "NASDAQ Eurozone Large Mid Cap GBP NTR Index", "I:NQEUROLMGBPT": "NASDAQ Eurozone Large Mid Cap GBP TR Index", "I:NQEUROLMJPY": "NASDAQ Eurozone Large Mid Cap JPY Index", "I:NQEUROLMJPYN": "NASDAQ Eurozone Large Mid Cap JPY NTR Index", "I:NQEUROLMJPYT": "NASDAQ Eurozone Large Mid Cap JPY TR Index", "I:NQEUROLMN": "NASDAQ Eurozone Large Mid Cap NTR Index", "I:NQEUROLMT": "NASDAQ Eurozone Large Mid Cap TR Index", "I:NQEURON": "NASDAQ Eurozone NTR Index", "I:NQEUROT": "NASDAQ Eurozone TR Index", "I:NQEUROZ10": "Nasdaq Eurozone Technology Index", "I:NQEUROZ10LM": "Nasdaq Eurozone Technology Large Mid Cap Index", "I:NQEUROZ10LMN": "Nasdaq Eurozone Technology Large Mid Cap NTR Index", "I:NQEUROZ10LMT": "Nasdaq Eurozone Technology Large Mid Cap TR Index", "I:NQEUROZ10N": "Nasdaq Eurozone Technology NTR Index", "I:NQEUROZ10T": "Nasdaq Eurozone Technology TR Index", "I:NQEUROZ15": "Nasdaq Eurozone Telecommunications Index", "I:NQEUROZ15LM": "Nasdaq Eurozone Telecommunications Large Mid Cap Index", "I:NQEUROZ15LMN": "Nasdaq Eurozone Telecommunications Large Mid Cap NTR Index", "I:NQEUROZ15LMT": "Nasdaq Eurozone Telecommunications Large Mid Cap TR Index", "I:NQEUROZ15N": "Nasdaq Eurozone Telecommunications NTR Index", "I:NQEUROZ15T": "Nasdaq Eurozone Telecommunications TR Index", "I:NQEUROZ20": "NASDAQ Eurozone Health Care Index", "I:NQEUROZ20LM": "Nasdaq Eurozone Health Care Large Mid Cap Index", "I:NQEUROZ20LMN": "Nasdaq Eurozone Health Care Large Mid Cap NTR Index", "I:NQEUROZ20LMT": "Nasdaq Eurozone Health Care Large Mid Cap TR Index", "I:NQEUROZ20N": "NASDAQ Eurozone Health Care NTR Index", "I:NQEUROZ20T": "NASDAQ Eurozone Health Care TR Index", "I:NQEUROZ30": "NASDAQ Eurozone Financials Index", "I:NQEUROZ3010": "NASDAQ Eurozone Banks Index", "I:NQEUROZ3010LM": "Nasdaq Eurozone Banks Large Mid Cap Index", "I:NQEUROZ3010LMN": "NASDAQ Eurozone Banks Large Mid Cap NTR Index", "I:NQEUROZ3010LMT": "NASDAQ Eurozone Banks Large Mid Cap TR Index", "I:NQEUROZ3010N": "NASDAQ Eurozone Banks NTR Index", "I:NQEUROZ3010T": "NASDAQ Eurozone Banks TR Index", "I:NQEUROZ3020": "Nasdaq Eurozone Financial Services Index", "I:NQEUROZ3020LM": "Nasdaq Eurozone Financial Services Large Mid Cap Index", "I:NQEUROZ3020LMN": "Nasdaq Eurozone Financial Services Large Mid Cap NTR Index", "I:NQEUROZ3020LMT": "Nasdaq Eurozone Financial Services Large Mid Cap TR Index", "I:NQEUROZ3020N": "Nasdaq Eurozone Financial Services NTR Index", "I:NQEUROZ3020T": "Nasdaq Eurozone Financial Services TR Index", "I:NQEUROZ3030": "Nasdaq Eurozone Insurance Index", "I:NQEUROZ3030LM": "Nasdaq Eurozone Insurance Large Mid Cap Index", "I:NQEUROZ3030LMN": "Nasdaq Eurozone Insurance Large Mid Cap NTR Index", "I:NQEUROZ3030LMT": "Nasdaq Eurozone Insurance Large Mid Cap TR Index", "I:NQEUROZ3030N": "Nasdaq Eurozone Insurance NTR Index", "I:NQEUROZ3030T": "Nasdaq Eurozone Insurance TR Index", "I:NQEUROZ30LM": "Nasdaq Eurozone Financials Large Mid Cap Index", "I:NQEUROZ30LMN": "NASDAQ Eurozone Financials Large Mid Cap NTR Index", "I:NQEUROZ30LMT": "NASDAQ Eurozone Financials Large Mid Cap TR Index", "I:NQEUROZ30N": "NASDAQ Eurozone Financials NTR Index", "I:NQEUROZ30T": "NASDAQ Eurozone Financials TR Index", "I:NQEUROZ35": "NASDAQ Eurozone Real Estate Index", "I:NQEUROZ35LM": "Nasdaq Eurozone Real Estate Large Mid Cap Index", "I:NQEUROZ35LMN": "Nasdaq Eurozone Real Estate Large Mid Cap NTR Index", "I:NQEUROZ35LMT": "Nasdaq Eurozone Real Estate Large Mid Cap TR Index", "I:NQEUROZ35N": "NASDAQ Eurozone Real Estate NTR Index", "I:NQEUROZ35T": "NASDAQ Eurozone Real Estate TR Index", "I:NQEUROZ40": "Nasdaq Eurozone Consumer Discretionary Index", "I:NQEUROZ4010": "Nasdaq Eurozone Automobiles and Parts Index", "I:NQEUROZ4010LM": "Nasdaq Eurozone Automobiles and Parts Large Mid Cap Index", "I:NQEUROZ4010LMN": "Nasdaq Eurozone Automobiles and Parts Large Mid Cap NTR Index", "I:NQEUROZ4010LMT": "Nasdaq Eurozone Automobiles and Parts Large Mid Cap TR Index", "I:NQEUROZ4010N": "Nasdaq Eurozone Automobiles and Parts NTR Index", "I:NQEUROZ4010T": "Nasdaq Eurozone Automobiles and Parts TR Index", "I:NQEUROZ4020": "Nasdaq Eurozone Consumer Products and Services Index", "I:NQEUROZ4020LM": "Nasdaq Eurozone Consumer Products and Services Large Mid Cap Index", "I:NQEUROZ4020LMN": "Nasdaq Eurozone Consumer Products and Services Large Mid Cap NTR Index", "I:NQEUROZ4020LMT": "Nasdaq Eurozone Consumer Products and Services Large Mid Cap TR Index", "I:NQEUROZ4020N": "Nasdaq Eurozone Consumer Products and Services NTR Index", "I:NQEUROZ4020T": "Nasdaq Eurozone Consumer Products and Services TR Index", "I:NQEUROZ4030": "NASDAQ Eurozone Media Index", "I:NQEUROZ4030LM": "Nasdaq Eurozone Media Large Mid Cap Index", "I:NQEUROZ4030LMN": "NASDAQ Eurozone Media Large Mid Cap NTR Index", "I:NQEUROZ4030LMT": "NASDAQ Eurozone Media Large Mid Cap TR Index", "I:NQEUROZ4030N": "NASDAQ Eurozone Media NTR Index", "I:NQEUROZ4030T": "NASDAQ Eurozone Media TR Index", "I:NQEUROZ4040": "NASDAQ Eurozone Retail Index", "I:NQEUROZ4040LM": "Nasdaq Eurozone Retail Large Mid Cap Index", "I:NQEUROZ4040LMN": "NASDAQ Eurozone Retail Large Mid Cap NTR Index", "I:NQEUROZ4040LMT": "NASDAQ Eurozone Retail Large Mid Cap TR Index", "I:NQEUROZ4040N": "NASDAQ Eurozone Retail NTR Index", "I:NQEUROZ4040T": "NASDAQ Eurozone Retail TR Index", "I:NQEUROZ4050": "Nasdaq Eurozone Travel and Leisure Index", "I:NQEUROZ4050LM": "Nasdaq Eurozone Travel and Leisure Large Mid Cap Index", "I:NQEUROZ4050LMN": "Nasdaq Eurozone Travel and Leisure Large Mid Cap NTR Index", "I:NQEUROZ4050LMT": "Nasdaq Eurozone Travel and Leisure Large Mid Cap TR Index", "I:NQEUROZ4050N": "Nasdaq Eurozone Travel and Leisure NTR Index", "I:NQEUROZ4050T": "Nasdaq Eurozone Travel and Leisure TR Index", "I:NQEUROZ40LM": "Nasdaq Eurozone Consumer Discretionary Large Mid Cap Index", "I:NQEUROZ40LMN": "Nasdaq Eurozone Consumer Discretionary Large Mid Cap NTR Index", "I:NQEUROZ40LMT": "Nasdaq Eurozone Consumer Discretionary Large Mid Cap TR Index", "I:NQEUROZ40N": "Nasdaq Eurozone Consumer Discretionary NTR Index", "I:NQEUROZ40T": "Nasdaq Eurozone Consumer Discretionary TR Index", "I:NQEUROZ45": "Nasdaq Eurozone Consumer Staples Index", "I:NQEUROZ4510": "Nasdaq Eurozone Food, Beverage and Tobacco Index", "I:NQEUROZ4510LM": "Nasdaq Eurozone Food, Beverage and Tobacco Large Mid Cap Index", "I:NQEUROZ4510LMN": "Nasdaq Eurozone Food, Beverage and Tobacco Large Mid Cap NTR Index", "I:NQEUROZ4510LMT": "Nasdaq Eurozone Food, Beverage and Tobacco Large Mid Cap TR Index", "I:NQEUROZ4510N": "Nasdaq Eurozone Food, Beverage and Tobacco NTR Index", "I:NQEUROZ4510T": "Nasdaq Eurozone Food, Beverage and Tobacco TR Index", "I:NQEUROZ4520": "Nasdaq Eurozone Personal Care, Drug and Grocery Stores Index", "I:NQEUROZ4520LM": "Nasdaq Eurozone Personal Care, Drug and Grocery Stores Large Mid Cap Index", "I:NQEUROZ4520LMN": "Nasdaq Eurozone Personal Care, Drug and Grocery Stores Large Mid Cap NTR Index", "I:NQEUROZ4520LMT": "Nasdaq Eurozone Personal Care, Drug and Grocery Stores Large Mid Cap TR Index", "I:NQEUROZ4520N": "Nasdaq Eurozone Personal Care, Drug and Grocery Stores NTR Index", "I:NQEUROZ4520T": "Nasdaq Eurozone Personal Care, Drug and Grocery Stores TR Index", "I:NQEUROZ45LM": "Nasdaq Eurozone Consumer Staples Large Mid Cap Index", "I:NQEUROZ45LMN": "Nasdaq Eurozone Consumer Staples Large Mid Cap NTR Index", "I:NQEUROZ45LMT": "Nasdaq Eurozone Consumer Staples Large Mid Cap TR Index", "I:NQEUROZ45N": "Nasdaq Eurozone Consumer Staples NTR Index", "I:NQEUROZ45T": "Nasdaq Eurozone Consumer Staples TR Index", "I:NQEUROZ50": "Nasdaq Eurozone Industrials Index", "I:NQEUROZ5010": "Nasdaq Eurozone Construction and Materials Index", "I:NQEUROZ5010LM": "Nasdaq Eurozone Construction and Materials Large Mid Cap Index", "I:NQEUROZ5010LMN": "Nasdaq Eurozone Construction and Materials Large Mid Cap NTR Index", "I:NQEUROZ5010LMT": "Nasdaq Eurozone Construction and Materials Large Mid Cap TR Index", "I:NQEUROZ5010N": "Nasdaq Eurozone Construction and Materials NTR Index", "I:NQEUROZ5010T": "Nasdaq Eurozone Construction and Materials TR Index", "I:NQEUROZ5020": "Nasdaq Eurozone Industrial Goods and Services Index", "I:NQEUROZ5020LM": "Nasdaq Eurozone Industrial Goods and Services Large Mid Cap Index", "I:NQEUROZ5020LMN": "Nasdaq Eurozone Industrial Goods and Services Large Mid Cap NTR Index", "I:NQEUROZ5020LMT": "Nasdaq Eurozone Industrial Goods and Services Large Mid Cap TR Index", "I:NQEUROZ5020N": "Nasdaq Eurozone Industrial Goods and Services NTR Index", "I:NQEUROZ5020T": "Nasdaq Eurozone Industrial Goods and Services TR Index", "I:NQEUROZ50LM": "Nasdaq Eurozone Industrials Large Mid Cap Index", "I:NQEUROZ50LMN": "Nasdaq Eurozone Industrials Large Mid Cap NTR Index", "I:NQEUROZ50LMT": "Nasdaq Eurozone Industrials Large Mid Cap TR Index", "I:NQEUROZ50N": "Nasdaq Eurozone Industrials NTR Index", "I:NQEUROZ50T": "Nasdaq Eurozone Industrials TR Index", "I:NQEUROZ55": "Nasdaq Eurozone Basic Materials Index", "I:NQEUROZ5510": "NASDAQ Eurozone Basic Resources Index", "I:NQEUROZ5510LM": "Nasdaq Eurozone Basic Resources Large Mid Cap Index", "I:NQEUROZ5510LMN": "Nasdaq Eurozone Basic Resources Large Mid Cap NTR Index", "I:NQEUROZ5510LMT": "Nasdaq Eurozone Basic Resources Large Mid Cap TR Index", "I:NQEUROZ5510N": "NASDAQ Eurozone Basic Resources NTR Index", "I:NQEUROZ5510T": "NASDAQ Eurozone Basic Resources TR Index", "I:NQEUROZ5520": "NASDAQ Eurozone Chemicals Index", "I:NQEUROZ5520LM": "Nasdaq Eurozone Chemicals Large Mid Cap Index", "I:NQEUROZ5520LMN": "NASDAQ Eurozone Chemicals Large Mid Cap NTR Index", "I:NQEUROZ5520LMT": "NASDAQ Eurozone Chemicals Large Mid Cap TR Index", "I:NQEUROZ5520N": "NASDAQ Eurozone Chemicals NTR Index", "I:NQEUROZ5520T": "NASDAQ Eurozone Chemicals TR Index", "I:NQEUROZ55LM": "Nasdaq Eurozone Basic Materials Large Mid Cap Index", "I:NQEUROZ55LMN": "Nasdaq Eurozone Basic Materials Large Mid Cap NTR Index", "I:NQEUROZ55LMT": "Nasdaq Eurozone Basic Materials Large Mid Cap TR Index", "I:NQEUROZ55N": "Nasdaq Eurozone Basic Materials NTR Index", "I:NQEUROZ55T": "Nasdaq Eurozone Basic Materials TR Index", "I:NQEUROZ60": "Nasdaq Eurozone Energy Index", "I:NQEUROZ60LM": "Nasdaq Eurozone Energy Large Mid Cap Index", "I:NQEUROZ60LMN": "Nasdaq Eurozone Energy Large Mid Cap NTR Index", "I:NQEUROZ60LMT": "Nasdaq Eurozone Energy Large Mid Cap TR Index", "I:NQEUROZ60N": "Nasdaq Eurozone Energy NTR Index", "I:NQEUROZ60T": "Nasdaq Eurozone Energy TR Index", "I:NQEUROZ65": "NASDAQ Eurozone Utilities Index", "I:NQEUROZ65LM": "Nasdaq Eurozone Utilities Large Mid Cap Index", "I:NQEUROZ65LMN": "NASDAQ Eurozone Utilities Large Mid Cap NTR Index", "I:NQEUROZ65LMT": "NASDAQ Eurozone Utilities Large Mid Cap TR Index", "I:NQEUROZ65N": "NASDAQ Eurozone Utilities NTR Index", "I:NQEUROZ65T": "NASDAQ Eurozone Utilities TR Index", "I:NQEUSC": "NASDAQ Europe Small Cap Index", "I:NQEUSCN": "NASDAQ Europe Small Cap NTR Index", "I:NQEUSCT": "NASDAQ Europe Small Cap TR Index", "I:NQEUT": "NASDAQ Europe TR Index", "I:NQEUXGB": "NASDAQ Europe Ex UK Index", "I:NQEUXGBLM": "NASDAQ Europe Ex UK Large Mid Cap Index", "I:NQEUXGBLMN": "NASDAQ Europe Ex UK Large Mid Cap NTR Index", "I:NQEUXGBLMT": "NASDAQ Europe Ex UK Large Mid Cap TR Index", "I:NQEUXGBN": "NASDAQ Europe Ex UK NTR Index", "I:NQEUXGBT": "NASDAQ Europe Ex UK TR Index", "I:NQFASL": "Nasdaq Future AU Sustainability Leaders", "I:NQFASLGL": "Nasdaq Future AU Sustainability Leaders GLR", "I:NQFASLT": "Nasdaq Future AU Sustainability Leaders TR", "I:NQFFLUSLV": "Nasdaq Factor Laggard US Low Volatility Index", "I:NQFFLUSLVN": "Nasdaq Factor Laggard US Low Volatility NTR Index", "I:NQFFLUSLVT": "Nasdaq Factor Laggard US Low Volatility TR Index", "I:NQFFLUSM": "Nasdaq Factor Laggard US Momentum Index", "I:NQFFLUSMN": "Nasdaq Factor Laggard US Momentum NTR Index", "I:NQFFLUSMT": "Nasdaq Factor Laggard US Momentum TR Index", "I:NQFFLUSQ": "Nasdaq Factor Laggard US Quality Index", "I:NQFFLUSQN": "Nasdaq Factor Laggard US Quality NTR Index", "I:NQFFLUSQT": "Nasdaq Factor Laggard US Quality TR Index", "I:NQFFLUSV": "Nasdaq Factor Laggard US Value Index", "I:NQFFLUSVN": "Nasdaq Factor Laggard US Value NTR Index", "I:NQFFLUSVT": "Nasdaq Factor Laggard US Value TR Index", "I:NQFFUSG": "Nasdaq Factor Family US Growth Index", "I:NQFFUSGN": "Nasdaq Factor Family US Growth NTR Index", "I:NQFFUSGT": "Nasdaq Factor Family US Growth TR Index", "I:NQFFUSHY": "Nasdaq Factor Family US High Yield Index", "I:NQFFUSHYN": "Nasdaq Factor Family US High Yield NTR Index", "I:NQFFUSHYT": "Nasdaq Factor Family US High Yield TR Index", "I:NQFFUSLV": "Nasdaq Factor Family US Low Volatility Index", "I:NQFFUSLVN": "Nasdaq Factor Family US Low Volatility NTR Index", "I:NQFFUSLVT": "Nasdaq Factor Family US Low Volatility TR Index", "I:NQFFUSM": "Nasdaq Factor Family US Momentum Index", "I:NQFFUSMN": "Nasdaq Factor Family US Momentum NTR Index", "I:NQFFUSMT": "Nasdaq Factor Family US Momentum TR Index", "I:NQFFUSQ": "Nasdaq Factor Family US Quality Index", "I:NQFFUSQN": "Nasdaq Factor Family US Quality NTR Index", "I:NQFFUSQT": "Nasdaq Factor Family US Quality TR Index", "I:NQFFUSV": "Nasdaq Factor Family US Value Index", "I:NQFFUSVN": "Nasdaq Factor Family US Value NTR Index", "I:NQFFUSVT": "Nasdaq Factor Family US Value TR Index", "I:NQFGSL": "Nasdaq Future Global Sustainability Leaders", "I:NQFGSLAUDMH": "Nasdaq Future Global Sustainability Leaders Currency Hedged AUD", "I:NQFGSLN": "Nasdaq Future Global Sustainability Leaders  NTR", "I:NQFGSLNAUDMH": "Nasdaq Future Global Sustainability Leaders Currency Hedged AUD NTR", "I:NQFGSLNUSD": "Nasdaq Future Global Sustainability Leaders USD NT", "I:NQFGSLT": "Nasdaq Future Global Sustainability Leaders  TR", "I:NQFGSLTAUDMH": "Nasdaq Future Global Sustainability Leaders Currency Hedged AUD TR", "I:NQFGSLTUSD": "Nasdaq Future Global Sustainability Leaders USD TR", "I:NQFGSLUSD": "Nasdaq Future Global Sustainability Leaders USD", "I:NQFI": "NASDAQ Finland Index", "I:NQFI30": "NASDAQ Finland Financials Index", "I:NQFI30N": "NASDAQ Finland Financials NTR Index", "I:NQFI30T": "NASDAQ Finland Financials TR Index", "I:NQFI40": "Nasdaq Finland Consumer Discretionary Index", "I:NQFI40N": "Nasdaq Finland Consumer Discretionary NTR Index", "I:NQFI40T": "Nasdaq Finland Consumer Discretionary TR Index", "I:NQFI50": "Nasdaq Finland Industrials Index", "I:NQFI50LM": "Nasdaq Finland Industrials Large Mid Cap Index", "I:NQFI50LMN": "Nasdaq Finland Industrials Large Mid Cap NTR Index", "I:NQFI50LMT": "Nasdaq Finland Industrials Large Mid Cap TR Index", "I:NQFI50N": "Nasdaq Finland Industrials NTR Index", "I:NQFI50T": "Nasdaq Finland Industrials TR Index", "I:NQFI55": "Nasdaq Finland Basic Materials Index", "I:NQFI55N": "Nasdaq Finland Basic Materials NTR Index", "I:NQFI55T": "Nasdaq Finland Basic Materials TR Index", "I:NQFILC": "NASDAQ Finland Large Cap Index", "I:NQFILCN": "NASDAQ Finland Large Cap NTR Index", "I:NQFILCT": "NASDAQ Finland Large Cap TR Index", "I:NQFILM": "NASDAQ Finland Large Mid Cap Index", "I:NQFILMN": "NASDAQ Finland Large Mid Cap NTR Index", "I:NQFILMT": "NASDAQ Finland Large Mid Cap TR Index", "I:NQFIMC": "NASDAQ Finland Mid Cap Index", "I:NQFIMCN": "NASDAQ Finland Mid Cap NTR Index", "I:NQFIMCT": "NASDAQ Finland Mid Cap TR Index", "I:NQFIN": "NASDAQ Finland NTR Index", "I:NQFISC": "NASDAQ Finland Small Cap Index", "I:NQFISCN": "NASDAQ Finland Small Cap NTR Index", "I:NQFISCT": "NASDAQ Finland Small Cap TR Index", "I:NQFIT": "NASDAQ Finland TR Index", "I:NQFR": "NASDAQ France Index", "I:NQFR10": "Nasdaq France Technology Index", "I:NQFR10LM": "Nasdaq France Technology Large Mid Cap Index", "I:NQFR10LMN": "Nasdaq France Technology Large Mid Cap NTR Index", "I:NQFR10LMT": "Nasdaq France Technology Large Mid Cap TR Index", "I:NQFR10N": "Nasdaq France Technology NTR Index", "I:NQFR10T": "Nasdaq France Technology TR Index", "I:NQFR20": "NASDAQ France Health Care Index", "I:NQFR20LM": "Nasdaq France Health Care Large Mid Cap Index", "I:NQFR20LMN": "NASDAQ France Health Care Large Mid Cap NTR Index", "I:NQFR20LMT": "NASDAQ France Health Care Large Mid Cap TR Index", "I:NQFR20N": "NASDAQ France Health Care NTR Index", "I:NQFR20T": "NASDAQ France Health Care TR Index", "I:NQFR30": "NASDAQ France Financials Index", "I:NQFR30LM": "Nasdaq France Financials Large Mid Cap Index", "I:NQFR30LMN": "NASDAQ France Financials Large Mid Cap NTR Index", "I:NQFR30LMT": "NASDAQ France Financials Large Mid Cap TR Index", "I:NQFR30N": "NASDAQ France Financials NTR Index", "I:NQFR30T": "NASDAQ France Financials TR Index", "I:NQFR35": "Nasdaq France Real Estate Index", "I:NQFR35N": "Nasdaq France Real Estate NTR Index", "I:NQFR35T": "Nasdaq France Real Estate TR Index", "I:NQFR40": "Nasdaq France Consumer Discretionary Index", "I:NQFR40LM": "Nasdaq France Consumer Discretionary Large Mid Cap Index", "I:NQFR40LMN": "Nasdaq France Consumer Discretionary Large Mid Cap NTR Index", "I:NQFR40LMT": "Nasdaq France Consumer Discretionary Large Mid Cap TR Index", "I:NQFR40N": "Nasdaq France Consumer Discretionary NTR Index", "I:NQFR40T": "Nasdaq France Consumer Discretionary TR Index", "I:NQFR45": "Nasdaq France Consumer Staples Index", "I:NQFR45N": "Nasdaq France Consumer Staples NTR Index", "I:NQFR45T": "Nasdaq France Consumer Staples TR Index", "I:NQFR50": "Nasdaq France Industrials Index", "I:NQFR50LM": "Nasdaq France Industrials Large Mid Cap Index", "I:NQFR50LMN": "Nasdaq France Industrials Large Mid Cap NTR Index", "I:NQFR50LMT": "Nasdaq France Industrials Large Mid Cap TR Index", "I:NQFR50N": "Nasdaq France Industrials NTR Index", "I:NQFR50T": "Nasdaq France Industrials TR Index", "I:NQFR55": "Nasdaq France Basic Materials Index", "I:NQFR55N": "Nasdaq France Basic Materials NTR Index", "I:NQFR55T": "Nasdaq France Basic Materials TR Index", "I:NQFR60": "Nasdaq France Energy Index", "I:NQFR60N": "Nasdaq France Energy NTR Index", "I:NQFR60T": "Nasdaq France Energy TR Index", "I:NQFR65": "NASDAQ France Utilities Index", "I:NQFR65LM": "Nasdaq France Utilities Large Mid Cap Index", "I:NQFR65LMN": "NASDAQ France Utilities Large Mid Cap NTR Index", "I:NQFR65LMT": "NASDAQ France Utilities Large Mid Cap TR Index", "I:NQFR65N": "NASDAQ France Utilities NTR Index", "I:NQFR65T": "NASDAQ France Utilities TR Index", "I:NQFRLC": "NASDAQ France Large Cap Index", "I:NQFRLCN": "NASDAQ France Large Cap NTR Index", "I:NQFRLCT": "NASDAQ France Large Cap TR Index", "I:NQFRLM": "NASDAQ France Large Mid Cap Index", "I:NQFRLMN": "NASDAQ France Large Mid Cap NTR Index", "I:NQFRLMT": "NASDAQ France Large Mid Cap TR Index", "I:NQFRMC": "NASDAQ France Mid Cap Index", "I:NQFRMCN": "NASDAQ France Mid Cap NTR Index", "I:NQFRMCT": "NASDAQ France Mid Cap TR Index", "I:NQFRN": "NASDAQ France NTR Index", "I:NQFRSC": "NASDAQ France Small Cap Index", "I:NQFRSCN": "NASDAQ France Small Cap NTR Index", "I:NQFRSCT": "NASDAQ France Small Cap TR Index", "I:NQFRT": "NASDAQ France TR Index", "I:NQG10": "Nasdaq Global Technology Index", "I:NQG10LM": "Nasdaq Global Technology Large Mid Cap Index", "I:NQG10LMN": "Nasdaq Global Technology Large Mid Cap NTR Index", "I:NQG10LMT": "Nasdaq Global Technology Large Mid Cap TR Index", "I:NQG10N": "Nasdaq Global Technology NTR Index", "I:NQG10T": "Nasdaq Global Technology TR Index", "I:NQG15": "Nasdaq Global Telecommunications Index", "I:NQG15LM": "Nasdaq Global Telecommunications Large Mid Cap Index", "I:NQG15LMN": "Nasdaq Global Telecommunications Large Mid Cap NTR Index", "I:NQG15LMT": "Nasdaq Global Telecommunications Large Mid Cap TR Index", "I:NQG15N": "Nasdaq Global Telecommunications NTR Index", "I:NQG15T": "Nasdaq Global Telecommunications TR Index", "I:NQG20": "NASDAQ Global Health Care Index", "I:NQG20LM": "Nasdaq Global Health Care Large Mid Cap Index", "I:NQG20LMN": "NASDAQ Global Health Care Large Mid Cap NTR Index", "I:NQG20LMT": "NASDAQ Global Health Care Large Mid Cap TR Index", "I:NQG20N": "NASDAQ Global Health Care NTR Index", "I:NQG20T": "NASDAQ Global Health Care TR Index", "I:NQG30": "NASDAQ Global Financials Index", "I:NQG3010": "NASDAQ Global Banks Index", "I:NQG3010LM": "Nasdaq Global Banks Large Mid Cap Index", "I:NQG3010LMN": "NASDAQ Global Banks Large Mid Cap NTR Index", "I:NQG3010LMT": "NASDAQ Global Banks Large Mid Cap TR Index", "I:NQG3010N": "NASDAQ Global Banks NTR Index", "I:NQG3010T": "NASDAQ Global Banks TR Index", "I:NQG3020": "Nasdaq Global Financial Services Index", "I:NQG3020LM": "Nasdaq Global Financial Services Large Mid Cap Index", "I:NQG3020LMN": "Nasdaq Global Financial Services Large Mid Cap NTR Index", "I:NQG3020LMT": "Nasdaq Global Financial Services Large Mid Cap TR Index", "I:NQG3020N": "Nasdaq Global Financial Services NTR Index", "I:NQG3020T": "Nasdaq Global Financial Services TR Index", "I:NQG3030": "Nasdaq Global Insurance Index", "I:NQG3030LM": "Nasdaq Global Insurance Large Mid Cap Index", "I:NQG3030LMN": "Nasdaq Global Insurance Large Mid Cap NTR Index", "I:NQG3030LMT": "Nasdaq Global Insurance Large Mid Cap TR Index", "I:NQG3030N": "Nasdaq Global Insurance NTR Index", "I:NQG3030T": "Nasdaq Global Insurance TR Index", "I:NQG30LM": "Nasdaq Global Financials Large Mid Cap Index", "I:NQG30LMN": "NASDAQ Global Financials Large Mid Cap NTR Index", "I:NQG30LMT": "NASDAQ Global Financials Large Mid Cap TR Index", "I:NQG30N": "NASDAQ Global Financials NTR Index", "I:NQG30T": "NASDAQ Global Financials TR Index", "I:NQG35": "NASDAQ Global Real Estate Index", "I:NQG35LM": "Nasdaq Global Real Estate Large Mid Cap Index", "I:NQG35LMN": "NASDAQ Global Real Estate Large Mid Cap NTR Index", "I:NQG35LMT": "NASDAQ Global Real Estate Large Mid Cap TR Index", "I:NQG35N": "NASDAQ Global Real Estate NTR Index", "I:NQG35T": "NASDAQ Global Real Estate TR Index", "I:NQG40": "Nasdaq Global Consumer Discretionary Index", "I:NQG4010": "Nasdaq Global Automobiles and Parts Index", "I:NQG4010LM": "Nasdaq Global Automobiles and Parts Large Mid Cap Index", "I:NQG4010LMN": "Nasdaq Global Automobiles and Parts Large Mid Cap NTR Index", "I:NQG4010LMT": "Nasdaq Global Automobiles and Parts Large Mid Cap TR Index", "I:NQG4010N": "Nasdaq Global Automobiles and Parts NTR Index", "I:NQG4010T": "Nasdaq Global Automobiles and Parts TR Index", "I:NQG4020": "Nasdaq Global Consumer Products and Services Index", "I:NQG4020LM": "Nasdaq Global Consumer Products and Services Large Mid Cap Index", "I:NQG4020LMN": "Nasdaq Global Consumer Products and Services Large Mid Cap NTR Index", "I:NQG4020LMT": "Nasdaq Global Consumer Products and Services Large Mid Cap TR Index", "I:NQG4020N": "Nasdaq Global Consumer Products and Services NTR Index", "I:NQG4020T": "Nasdaq Global Consumer Products and Services TR Index", "I:NQG4030": "NASDAQ Global Media Index", "I:NQG4030LM": "Nasdaq Global Media Large Mid Cap Index", "I:NQG4030LMN": "NASDAQ Global Media Large Mid Cap NTR Index", "I:NQG4030LMT": "NASDAQ Global Media Large Mid Cap TR Index", "I:NQG4030N": "NASDAQ Global Media NTR Index", "I:NQG4030T": "NASDAQ Global Media TR Index", "I:NQG4040": "NASDAQ Global Retail Index", "I:NQG4040LM": "Nasdaq Global Retail Large Mid Cap Index", "I:NQG4040LMN": "NASDAQ Global Retail Large Mid Cap NTR Index", "I:NQG4040LMT": "NASDAQ Global Retail Large Mid Cap TR Index", "I:NQG4040N": "NASDAQ Global Retail NTR Index", "I:NQG4040T": "NASDAQ Global Retail TR Index", "I:NQG4050": "Nasdaq Global Travel and Leisure Index", "I:NQG4050LM": "Nasdaq Global Travel and Leisure Large Mid Cap Index", "I:NQG4050LMN": "Nasdaq Global Travel and Leisure Large Mid Cap NTR Index", "I:NQG4050LMT": "Nasdaq Global Travel and Leisure Large Mid Cap TR Index", "I:NQG4050N": "Nasdaq Global Travel and Leisure NTR Index", "I:NQG4050T": "Nasdaq Global Travel and Leisure TR Index", "I:NQG40LM": "Nasdaq Global Consumer Discretionary Large Mid Cap Index", "I:NQG40LMN": "Nasdaq Global Consumer Discretionary Large Mid Cap NTR Index", "I:NQG40LMT": "Nasdaq Global Consumer Discretionary Large Mid Cap TR Index", "I:NQG40N": "Nasdaq Global Consumer Discretionary NTR Index", "I:NQG40T": "Nasdaq Global Consumer Discretionary TR Index", "I:NQG45": "Nasdaq Global Consumer Staples Index", "I:NQG4510": "Nasdaq Global Food, Beverage and Tobacco Index", "I:NQG4510LM": "Nasdaq Global Food, Beverage and Tobacco Large Mid Cap Index", "I:NQG4510LMN": "Nasdaq Global Food, Beverage and Tobacco Large Mid Cap NTR Index", "I:NQG4510LMT": "Nasdaq Global Food, Beverage and Tobacco Large Mid Cap TR Index", "I:NQG4510N": "Nasdaq Global Food, Beverage and Tobacco NTR Index", "I:NQG4510T": "Nasdaq Global Food, Beverage and Tobacco TR Index", "I:NQG4520": "Nasdaq Global Personal Care, Drug and Grocery Stores Index", "I:NQG4520LM": "Nasdaq Global Personal Care, Drug and Grocery Stores Large Mid Cap Index", "I:NQG4520LMN": "Nasdaq Global Personal Care, Drug and Grocery Stores Large Mid Cap NTR Index", "I:NQG4520LMT": "Nasdaq Global Personal Care, Drug and Grocery Stores Large Mid Cap TR Index", "I:NQG4520N": "Nasdaq Global Personal Care, Drug and Grocery Stores NTR Index", "I:NQG4520T": "Nasdaq Global Personal Care, Drug and Grocery Stores TR Index", "I:NQG45LM": "Nasdaq Global Consumer Staples Large Mid Cap Index", "I:NQG45LMN": "Nasdaq Global Consumer Staples Large Mid Cap NTR Index", "I:NQG45LMT": "Nasdaq Global Consumer Staples Large Mid Cap TR Index", "I:NQG45N": "Nasdaq Global Consumer Staples NTR Index", "I:NQG45T": "Nasdaq Global Consumer Staples TR Index", "I:NQG50": "Nasdaq Global Industrials Index", "I:NQG5010": "Nasdaq Global Construction and Materials Index", "I:NQG5010LM": "Nasdaq Global Construction and Materials Large Mid Cap Index", "I:NQG5010LMN": "Nasdaq Global Construction and Materials Large Mid Cap NTR Index", "I:NQG5010LMT": "Nasdaq Global Construction and Materials Large Mid Cap TR Index", "I:NQG5010N": "Nasdaq Global Construction and Materials NTR Index", "I:NQG5010T": "Nasdaq Global Construction and Materials TR Index", "I:NQG5020": "Nasdaq Global Industrial Goods and Services Index", "I:NQG5020LM": "Nasdaq Global Industrial Goods and Services Large Mid Cap Index", "I:NQG5020LMN": "Nasdaq Global Industrial Goods and Services Large Mid Cap NTR Index", "I:NQG5020LMT": "Nasdaq Global Industrial Goods and Services Large Mid Cap TR Index", "I:NQG5020N": "Nasdaq Global Industrial Goods and Services NTR Index", "I:NQG5020T": "Nasdaq Global Industrial Goods and Services TR Index", "I:NQG50LM": "Nasdaq Global Industrials Large Mid Cap Index", "I:NQG50LMN": "Nasdaq Global Industrials Large Mid Cap NTR Index", "I:NQG50LMT": "Nasdaq Global Industrials Large Mid Cap TR Index", "I:NQG50N": "Nasdaq Global Industrials NTR Index", "I:NQG50T": "Nasdaq Global Industrials TR Index", "I:NQG55": "Nasdaq Global Basic Materials Index", "I:NQG5510": "NASDAQ Global Basic Resources Index", "I:NQG5510LM": "Nasdaq Global Basic Resources Large Mid Cap Index", "I:NQG5510LMN": "Nasdaq Global Basic Resources Large Mid Cap NTR Index", "I:NQG5510LMT": "Nasdaq Global Basic Resources Large Mid Cap TR Index", "I:NQG5510N": "NASDAQ Global Basic Resources NTR Index", "I:NQG5510T": "NASDAQ Global Basic Resources TR Index", "I:NQG5520": "NASDAQ Global Chemicals Index", "I:NQG5520LM": "Nasdaq Global Chemicals Large Mid Cap Index", "I:NQG5520LMN": "NASDAQ Global Chemicals Large Mid Cap NTR Index", "I:NQG5520LMT": "NASDAQ Global Chemicals Large Mid Cap TR Index", "I:NQG5520N": "NASDAQ Global Chemicals NTR Index", "I:NQG5520T": "NASDAQ Global Chemicals TR Index", "I:NQG55LM": "Nasdaq Global Basic Materials Large Mid Cap Index", "I:NQG55LMN": "Nasdaq Global Basic Materials Large Mid Cap NTR Index", "I:NQG55LMT": "Nasdaq Global Basic Materials Large Mid Cap TR Index", "I:NQG55N": "Nasdaq Global Basic Materials NTR Index", "I:NQG55T": "Nasdaq Global Basic Materials TR Index", "I:NQG60": "Nasdaq Global Energy Index", "I:NQG60LM": "Nasdaq Global Energy Large Mid Cap Index", "I:NQG60LMN": "Nasdaq Global Energy Large Mid Cap NTR Index", "I:NQG60LMT": "Nasdaq Global Energy Large Mid Cap TR Index", "I:NQG60N": "Nasdaq Global Energy NTR Index", "I:NQG60T": "Nasdaq Global Energy TR Index", "I:NQG65": "NASDAQ Global Utilities Index", "I:NQG65LM": "Nasdaq Global Utilities Large Mid Cap Index", "I:NQG65LMN": "NASDAQ Global Utilities Large Mid Cap NTR Index", "I:NQG65LMT": "NASDAQ Global Utilities Large Mid Cap TR Index", "I:NQG65N": "NASDAQ Global Utilities NTR Index", "I:NQG65T": "NASDAQ Global Utilities TR Index", "I:NQGB": "NASDAQ UK Index", "I:NQGB10": "Nasdaq United Kingdom Technology Index", "I:NQGB10LM": "Nasdaq United Kingdom Technology Large Mid Cap Index", "I:NQGB10LMN": "Nasdaq United Kingdom Technology Large Mid Cap NTR Index", "I:NQGB10LMT": "Nasdaq United Kingdom Technology Large Mid Cap TR Index", "I:NQGB10N": "Nasdaq United Kingdom Technology NTR Index", "I:NQGB10T": "Nasdaq United Kingdom Technology TR Index", "I:NQGB15": "Nasdaq United Kingdom Telecommunications Index", "I:NQGB15LM": "Nasdaq United Kingdom Telecommunications Large Mid Cap Index", "I:NQGB15LMN": "Nasdaq United Kingdom Telecommunications Large Mid Cap NTR Index", "I:NQGB15LMT": "Nasdaq United Kingdom Telecommunications Large Mid Cap TR Index", "I:NQGB15N": "Nasdaq United Kingdom Telecommunications NTR Index", "I:NQGB15T": "Nasdaq United Kingdom Telecommunications TR Index", "I:NQGB20": "Nasdaq United Kingdom Health Care Index", "I:NQGB20LM": "Nasdaq United Kingdom Health Care Large Mid Cap Index", "I:NQGB20LMN": "Nasdaq United Kingdom Health Care Large Mid Cap NTR Index", "I:NQGB20LMT": "Nasdaq United Kingdom Health Care Large Mid Cap TR Index", "I:NQGB20N": "Nasdaq United Kingdom Health Care NTR Index", "I:NQGB20T": "Nasdaq United Kingdom Health Care TR Index", "I:NQGB30": "Nasdaq United Kingdom Financials Index", "I:NQGB3010": "Nasdaq United Kingdom Banks Index", "I:NQGB3010LM": "Nasdaq United Kingdom Banks Large Mid Cap Index", "I:NQGB3010LMN": "Nasdaq United Kingdom Banks Large Mid Cap NTR Index", "I:NQGB3010LMT": "Nasdaq United Kingdom Banks Large Mid Cap TR Index", "I:NQGB3010N": "Nasdaq United Kingdom Banks NTR Index", "I:NQGB3010T": "Nasdaq United Kingdom Banks TR Index", "I:NQGB3020": "Nasdaq United Kingdom Financial Services Index", "I:NQGB3020LM": "Nasdaq United Kingdom Financial Services Large Mid Cap Index", "I:NQGB3020LMN": "Nasdaq United Kingdom Financial Services Large Mid Cap NTR Index", "I:NQGB3020LMT": "Nasdaq United Kingdom Financial Services Large Mid Cap TR Index", "I:NQGB3020N": "Nasdaq United Kingdom Financial Services NTR Index", "I:NQGB3020T": "Nasdaq United Kingdom Financial Services TR Index", "I:NQGB3030": "Nasdaq United Kingdom Insurance Index", "I:NQGB3030LM": "Nasdaq United Kingdom Insurance Large Mid Cap Index", "I:NQGB3030LMN": "Nasdaq United Kingdom Insurance Large Mid Cap NTR Index", "I:NQGB3030LMT": "Nasdaq United Kingdom Insurance Large Mid Cap TR Index", "I:NQGB3030N": "Nasdaq United Kingdom Insurance NTR Index", "I:NQGB3030T": "Nasdaq United Kingdom Insurance TR Index", "I:NQGB30LM": "Nasdaq United Kingdom Financials Large Mid Cap Index", "I:NQGB30LMN": "Nasdaq United Kingdom Financials Large Mid Cap NTR Index", "I:NQGB30LMT": "Nasdaq United Kingdom Financials Large Mid Cap TR Index", "I:NQGB30N": "Nasdaq United Kingdom Financials NTR Index", "I:NQGB30T": "Nasdaq United Kingdom Financials TR Index", "I:NQGB35": "Nasdaq United Kingdom Real Estate Index", "I:NQGB35LM": "Nasdaq United Kingdom Real Estate Large Mid Cap Index", "I:NQGB35LMN": "Nasdaq United Kingdom Real Estate Large Mid Cap NTR Index", "I:NQGB35LMT": "Nasdaq United Kingdom Real Estate Large Mid Cap TR Index", "I:NQGB35N": "Nasdaq United Kingdom Real Estate NTR Index", "I:NQGB35T": "Nasdaq United Kingdom Real Estate TR Index", "I:NQGB40": "Nasdaq United Kingdom Consumer Discretionary Index", "I:NQGB4020": "Nasdaq United Kingdom Consumer Products and Services Index", "I:NQGB4020LM": "Nasdaq United Kingdom Consumer Products and Services Large Mid Cap Index", "I:NQGB4020LMN": "Nasdaq United Kingdom Consumer Products and Services Large Mid Cap NTR Index", "I:NQGB4020LMT": "Nasdaq United Kingdom Consumer Products and Services Large Mid Cap TR Index", "I:NQGB4020N": "Nasdaq United Kingdom Consumer Products and Services NTR Index", "I:NQGB4020T": "Nasdaq United Kingdom Consumer Products and Services TR Index", "I:NQGB4030": "Nasdaq United Kingdom Media Index", "I:NQGB4030LM": "Nasdaq United Kingdom Media Large Mid Cap Index", "I:NQGB4030LMN": "Nasdaq United Kingdom Media Large Mid Cap NTR Index", "I:NQGB4030LMT": "Nasdaq United Kingdom Media Large Mid Cap TR Index", "I:NQGB4030N": "Nasdaq United Kingdom Media NTR Index", "I:NQGB4030T": "Nasdaq United Kingdom Media TR Index", "I:NQGB4040": "Nasdaq United Kingdom Retail Index", "I:NQGB4040LM": "Nasdaq United Kingdom Retail Large Mid Cap Index", "I:NQGB4040LMN": "Nasdaq United Kingdom Retail Large Mid Cap NTR Index", "I:NQGB4040LMT": "Nasdaq United Kingdom Retail Large Mid Cap TR Index", "I:NQGB4040N": "Nasdaq United Kingdom Retail NTR Index", "I:NQGB4040T": "Nasdaq United Kingdom Retail TR Index", "I:NQGB4050": "Nasdaq United Kingdom Travel and Leisure Index", "I:NQGB4050LM": "Nasdaq United Kingdom Travel and Leisure Large Mid Cap Index", "I:NQGB4050LMN": "Nasdaq United Kingdom Travel and Leisure Large Mid Cap NTR Index", "I:NQGB4050LMT": "Nasdaq United Kingdom Travel and Leisure Large Mid Cap TR Index", "I:NQGB4050N": "Nasdaq United Kingdom Travel and Leisure NTR Index", "I:NQGB4050T": "Nasdaq United Kingdom Travel and Leisure TR Index", "I:NQGB40LM": "Nasdaq United Kingdom Consumer Discretionary Large Mid Cap Index", "I:NQGB40LMN": "Nasdaq United Kingdom Consumer Discretionary Large Mid Cap NTR Index", "I:NQGB40LMT": "Nasdaq United Kingdom Consumer Discretionary Large Mid Cap TR Index", "I:NQGB40N": "Nasdaq United Kingdom Consumer Discretionary NTR Index", "I:NQGB40T": "Nasdaq United Kingdom Consumer Discretionary TR Index", "I:NQGB45": "Nasdaq United Kingdom Consumer Staples Index", "I:NQGB4510": "Nasdaq United Kingdom Food, Beverage and Tobacco Index", "I:NQGB4510LM": "Nasdaq United Kingdom Food, Beverage and Tobacco Large Mid Cap Index", "I:NQGB4510LMN": "Nasdaq United Kingdom Food, Beverage and Tobacco Large Mid Cap NTR Index", "I:NQGB4510LMT": "Nasdaq United Kingdom Food, Beverage and Tobacco Large Mid Cap TR Index", "I:NQGB4510N": "Nasdaq United Kingdom Food, Beverage and Tobacco NTR Index", "I:NQGB4510T": "Nasdaq United Kingdom Food, Beverage and Tobacco TR Index", "I:NQGB4520": "Nasdaq United Kingdom Personal Care, Drug and Grocery Stores Index", "I:NQGB4520LM": "Nasdaq United Kingdom Personal Care, Drug and Grocery Stores Large Mid Cap Index", "I:NQGB4520LMN": "Nasdaq United Kingdom Personal Care, Drug and Grocery Stores Large Mid Cap NTR Index", "I:NQGB4520LMT": "Nasdaq United Kingdom Personal Care, Drug and Grocery Stores Large Mid Cap TR Index", "I:NQGB4520N": "Nasdaq United Kingdom Personal Care, Drug and Grocery Stores NTR Index", "I:NQGB4520T": "Nasdaq United Kingdom Personal Care, Drug and Grocery Stores TR Index", "I:NQGB45LM": "Nasdaq United Kingdom Consumer Staples Large Mid Cap Index", "I:NQGB45LMN": "Nasdaq United Kingdom Consumer Staples Large Mid Cap NTR Index", "I:NQGB45LMT": "Nasdaq United Kingdom Consumer Staples Large Mid Cap TR Index", "I:NQGB45N": "Nasdaq United Kingdom Consumer Staples NTR Index", "I:NQGB45T": "Nasdaq United Kingdom Consumer Staples TR Index", "I:NQGB50": "Nasdaq United Kingdom Industrials Index", "I:NQGB5010": "Nasdaq United Kingdom Construction and Materials Index", "I:NQGB5010N": "Nasdaq United Kingdom Construction and Materials NTR Index", "I:NQGB5010T": "Nasdaq United Kingdom Construction and Materials TR Index", "I:NQGB5020": "Nasdaq United Kingdom Industrial Goods and Services Index", "I:NQGB5020LM": "Nasdaq United Kingdom Industrial Goods and Services Large Mid Cap Index", "I:NQGB5020LMN": "Nasdaq United Kingdom Industrial Goods and Services Large Mid Cap NTR Index", "I:NQGB5020LMT": "Nasdaq United Kingdom Industrial Goods and Services Large Mid Cap TR Index", "I:NQGB5020N": "Nasdaq United Kingdom Industrial Goods and Services NTR Index", "I:NQGB5020T": "Nasdaq United Kingdom Industrial Goods and Services TR Index", "I:NQGB50LM": "Nasdaq United Kingdom Industrials Large Mid Cap Index", "I:NQGB50LMN": "Nasdaq United Kingdom Industrials Large Mid Cap NTR Index", "I:NQGB50LMT": "Nasdaq United Kingdom Industrials Large Mid Cap TR Index", "I:NQGB50N": "Nasdaq United Kingdom Industrials NTR Index", "I:NQGB50T": "Nasdaq United Kingdom Industrials TR Index", "I:NQGB55": "Nasdaq United Kingdom Basic Materials Index", "I:NQGB5510": "Nasdaq United Kingdom Basic Resources Index", "I:NQGB5510LM": "Nasdaq United Kingdom Basic Resources Large Mid Cap Index", "I:NQGB5510LMN": "Nasdaq United Kingdom Basic Resources Large Mid Cap NTR Index", "I:NQGB5510LMT": "Nasdaq United Kingdom Basic Resources Large Mid Cap TR Index", "I:NQGB5510N": "Nasdaq United Kingdom Basic Resources NTR Index", "I:NQGB5510T": "Nasdaq United Kingdom Basic Resources TR Index", "I:NQGB5520": "Nasdaq United Kingdom Chemicals Index", "I:NQGB5520N": "Nasdaq United Kingdom Chemicals NTR Index", "I:NQGB5520T": "Nasdaq United Kingdom Chemicals TR Index", "I:NQGB55LM": "Nasdaq United Kingdom Basic Materials Large Mid Cap Index", "I:NQGB55LMN": "Nasdaq United Kingdom Basic Materials Large Mid Cap NTR Index", "I:NQGB55LMT": "Nasdaq United Kingdom Basic Materials Large Mid Cap TR Index", "I:NQGB55N": "Nasdaq United Kingdom Basic Materials NTR Index", "I:NQGB55T": "Nasdaq United Kingdom Basic Materials TR Index", "I:NQGB60": "Nasdaq United Kingdom Energy Index", "I:NQGB60LM": "Nasdaq United Kingdom Energy Large Mid Cap Index", "I:NQGB60LMN": "Nasdaq United Kingdom Energy Large Mid Cap NTR Index", "I:NQGB60LMT": "Nasdaq United Kingdom Energy Large Mid Cap TR Index", "I:NQGB60N": "Nasdaq United Kingdom Energy NTR Index", "I:NQGB60T": "Nasdaq United Kingdom Energy TR Index", "I:NQGB65": "Nasdaq United Kingdom Utilities Index", "I:NQGB65LM": "Nasdaq United Kingdom Utilities Large Mid Cap Index", "I:NQGB65LMN": "Nasdaq United Kingdom Utilities Large Mid Cap NTR Index", "I:NQGB65LMT": "Nasdaq United Kingdom Utilities Large Mid Cap TR Index", "I:NQGB65N": "Nasdaq United Kingdom Utilities NTR Index", "I:NQGB65T": "Nasdaq United Kingdom Utilities TR Index", "I:NQGBLC": "NASDAQ UK Large Cap Index", "I:NQGBLCN": "NASDAQ UK Large Cap NTR Index", "I:NQGBLCT": "NASDAQ UK Large Cap TR Index", "I:NQGBLM": "NASDAQ UK Large Mid Cap Index", "I:NQGBLMN": "NASDAQ UK Large Mid Cap NTR Index", "I:NQGBLMT": "NASDAQ UK Large Mid Cap TR Index", "I:NQGBMC": "NASDAQ UK Mid Cap Index", "I:NQGBMCN": "NASDAQ UK Mid Cap NTR Index", "I:NQGBMCT": "NASDAQ UK Mid Cap TR Index", "I:NQGBN": "NASDAQ UK NTR Index", "I:NQGBSC": "NASDAQ UK Small Cap Index", "I:NQGBSCN": "NASDAQ UK Small Cap NTR Index", "I:NQGBSCT": "NASDAQ UK Small Cap TR Index", "I:NQGBT": "NASDAQ UK TR Index", "I:NQGI": "NASDAQ Global Index", "I:NQGICNA": "NASDAQ Global plus China A Shares Index", "I:NQGIHEI": "Nasdaq Global High Equity Income Index", "I:NQGIHEIEUR": "Nasdaq Global High Equity Income EUR Index", "I:NQGIHEIEURN": "Nasdaq Global High Equity Income EUR Net Total Ret", "I:NQGIHEIEURT": "Nasdaq Global High Equity Income EUR Total Return", "I:NQGIHEIGBP": "Nasdaq Global High Equity Income GBP Index", "I:NQGIHEIGBPN": "Nasdaq Global High Equity Income GBP Net Total Ret", "I:NQGIHEIGBPT": "Nasdaq Global High Equity Income GBP Total Return", "I:NQGIHEIN": "Nasdaq Global High Equity Income Net Total Return", "I:NQGIHEIT": "Nasdaq Global High Equity Income Total Return Inde", "I:NQGILI": "Nasdaq Global Income Leaders Index", "I:NQGILIAUD": "Nasdaq Global Income Leaders AUD Index", "I:NQGILIAUDN": "Nasdaq Global Income Leaders AUD NTR Index", "I:NQGILIAUDT": "Nasdaq Global Income Leaders AUD TR Index", "I:NQGILIN": "Nasdaq Global Income Leaders NTR Index", "I:NQGILIT": "Nasdaq Global Income Leaders TR Index", "I:NQGIN": "NASDAQ Global NTR Index", "I:NQGIT": "NASDAQ Global TR Index", "I:NQGLCI": "NASDAQ Global Large Cap Index", "I:NQGLCIN": "NASDAQ Global Large Cap NTR Index", "I:NQGLCIT": "NASDAQ Global Large Cap TR Index", "I:NQGLMCI": "NASDAQ Global Large Mid Cap Index", "I:NQGLMCIN": "NASDAQ Global Large Mid Cap NTR Index", "I:NQGLMCIT": "NASDAQ Global Large Mid Cap TR Index", "I:NQGM": "NASDAQ Global Market Composite", "I:NQGMCI": "NASDAQ Global Mid Cap Index", "I:NQGMCIN": "NASDAQ Global Mid Cap NTR Index", "I:NQGMCIT": "NASDAQ Global Mid Cap TR Index", "I:NQGR": "NASDAQ Greece Index", "I:NQGR30": "NASDAQ Greece Financials Index", "I:NQGR30N": "NASDAQ Greece Financials NTR Index", "I:NQGR30T": "NASDAQ Greece Financials TR Index", "I:NQGR50": "Nasdaq Greece Industrials Index", "I:NQGR50N": "Nasdaq Greece Industrials NTR Index", "I:NQGR50T": "Nasdaq Greece Industrials TR Index", "I:NQGRLM": "NASDAQ Greece Large Mid Cap Index", "I:NQGRLMN": "NASDAQ Greece Large Mid Cap NTR Index", "I:NQGRLMT": "NASDAQ Greece Large Mid Cap TR Index", "I:NQGRMC": "NASDAQ Greece Mid Cap Index", "I:NQGRMCN": "NASDAQ Greece Mid Cap NTR Index", "I:NQGRMCT": "NASDAQ Greece Mid Cap TR Index", "I:NQGRMI": "NASDAQ Global Risk Managed Income Index", "I:NQGRMIC": "NASDAQ Global Risk Managed Income CAD Index", "I:NQGRMICT": "NASDAQ Global Risk Managed Income CAD TR Index", "I:NQGRMIT": "NASDAQ Global Risk Managed Income TR Index", "I:NQGRN": "NASDAQ Greece NTR Index", "I:NQGRSC": "NASDAQ Greece Small Cap Index", "I:NQGRSCN": "NASDAQ Greece Small Cap NTR Index", "I:NQGRSCT": "NASDAQ Greece Small Cap TR Index", "I:NQGRT": "NASDAQ Greece TR Index", "I:NQGS": "NASDAQ Global Select Market Composite", "I:NQGSCI": "NASDAQ Global Small Cap Index", "I:NQGSCIN": "NASDAQ Global Small Cap NTR Index", "I:NQGSCIT": "NASDAQ Global Small Cap TR Index", "I:NQGSSA": "Nasdaq Global Smart Airlines Index", "I:NQGSSAN": "Nasdaq Global Smart Airlines NTR Index", "I:NQGSSAT": "Nasdaq Global Smart Airlines TR Index", "I:NQGXGB": "NASDAQ Global Ex UK Index", "I:NQGXGBLM": "NASDAQ Global Ex UK Large Mid Cap Index", "I:NQGXGBLMN": "NASDAQ Global Ex UK Large Mid Cap NTR Index", "I:NQGXGBLMT": "NASDAQ Global Ex UK Large Mid Cap TR Index", "I:NQGXGBN": "NASDAQ Global Ex UK NTR Index", "I:NQGXGBT": "NASDAQ Global Ex UK TR Index", "I:NQGXJP": "NASDAQ Global Ex Japan Index", "I:NQGXJPLM": "NASDAQ Global Ex Japan Large Mid Cap Index", "I:NQGXJPLMN": "NASDAQ Global Ex Japan Large Mid Cap NTR Index", "I:NQGXJPLMT": "NASDAQ Global Ex Japan Large Mid Cap TR Index", "I:NQGXJPN": "NASDAQ Global Ex Japan NTR Index", "I:NQGXJPT": "NASDAQ Global Ex Japan TR Index", "I:NQGXNA": "NASDAQ Global Ex N America Index", "I:NQGXNALM": "NASDAQ Global Ex N America Large Mid Cap Index", "I:NQGXNALMN": "NASDAQ Global Ex N America Large Mid Cap NTR Index", "I:NQGXNALMT": "NASDAQ Global Ex N America Large Mid Cap TR Index", "I:NQGXNAN": "NASDAQ Global Ex N America NTR Index", "I:NQGXNAT": "NASDAQ Global Ex N America TR Index", "I:NQGXUS": "NASDAQ Global Ex United States Index", "I:NQGXUSLM": "NASDAQ Global Ex United States Lg Md Cap Index", "I:NQGXUSLMN": "NASDAQ Global Ex United States Lg Md Cap NTR Index", "I:NQGXUSLMT": "NASDAQ Global Ex United States Lg Md Cap TR Index", "I:NQGXUSN": "NASDAQ Global Ex United States NTR Index", "I:NQGXUSSC": "NASDAQ Global Ex United States Sm Cap Index", "I:NQGXUSSCN": "NASDAQ Global Ex United States Sm Cap NTR Index", "I:NQGXUSSCT": "NASDAQ Global Ex United States Sm Cap TR Index", "I:NQGXUST": "NASDAQ Global Ex United States TR Index", "I:NQHK": "NASDAQ Hong Kong Index", "I:NQHK10": "Nasdaq Hong Kong Technology Index", "I:NQHK10N": "Nasdaq Hong Kong Technology NTR Index", "I:NQHK10T": "Nasdaq Hong Kong Technology TR Index", "I:NQHK15": "Nasdaq Hong Kong Telecommunications Index", "I:NQHK15N": "Nasdaq Hong Kong Telecommunications NTR Index", "I:NQHK15T": "Nasdaq Hong Kong Telecommunications TR Index", "I:NQHK20": "NASDAQ Hong Kong Health Care Index", "I:NQHK20N": "NASDAQ Hong Kong Health Care NTR Index", "I:NQHK20T": "NASDAQ Hong Kong Health Care TR Index", "I:NQHK30": "NASDAQ Hong Kong Financials Index", "I:NQHK30LM": "Nasdaq Hong Kong Financials Large Mid Cap Index", "I:NQHK30LMN": "Nasdaq Hong Kong Financials Large Mid Cap NTR Index", "I:NQHK30LMT": "Nasdaq Hong Kong Financials Large Mid Cap TR Index", "I:NQHK30N": "NASDAQ Hong Kong Financials NTR Index", "I:NQHK30T": "NASDAQ Hong Kong Financials TR Index", "I:NQHK35": "Nasdaq Hong Kong Real Estate Index", "I:NQHK35LM": "Nasdaq Hong Kong Real Estate Large Mid Cap Index", "I:NQHK35LMN": "Nasdaq Hong Kong Real Estate Large Mid Cap NTR Index", "I:NQHK35LMT": "Nasdaq Hong Kong Real Estate Large Mid Cap TR Index", "I:NQHK35N": "Nasdaq Hong Kong Real Estate NTR Index", "I:NQHK35T": "Nasdaq Hong Kong Real Estate TR Index", "I:NQHK40": "Nasdaq Hong Kong Consumer Discretionary Index", "I:NQHK40LM": "Nasdaq Hong Kong Consumer Discretionary Large Mid Cap Index", "I:NQHK40LMN": "Nasdaq Hong Kong Consumer Discretionary Large Mid Cap NTR Index", "I:NQHK40LMT": "Nasdaq Hong Kong Consumer Discretionary Large Mid Cap TR Index", "I:NQHK40N": "Nasdaq Hong Kong Consumer Discretionary NTR Index", "I:NQHK40T": "Nasdaq Hong Kong Consumer Discretionary TR Index", "I:NQHK45": "Nasdaq Hong Kong Consumer Staples Index", "I:NQHK45N": "Nasdaq Hong Kong Consumer Staples NTR Index", "I:NQHK45T": "Nasdaq Hong Kong Consumer Staples TR Index", "I:NQHK50": "Nasdaq Hong Kong Industrials Index", "I:NQHK50LM": "Nasdaq Hong Kong Industrials Large Mid Cap Index", "I:NQHK50LMN": "Nasdaq Hong Kong Industrials Large Mid Cap NTR Index", "I:NQHK50LMT": "Nasdaq Hong Kong Industrials Large Mid Cap TR Index", "I:NQHK50N": "Nasdaq Hong Kong Industrials NTR Index", "I:NQHK50T": "Nasdaq Hong Kong Industrials TR Index", "I:NQHK55": "Nasdaq Hong Kong Basic Materials Index", "I:NQHK55N": "Nasdaq Hong Kong Basic Materials NTR Index", "I:NQHK55T": "Nasdaq Hong Kong Basic Materials TR Index", "I:NQHK65": "NASDAQ Hong Kong Utilities Index", "I:NQHK65LM": "Nasdaq Hong Kong Utilities Large Mid Cap Index", "I:NQHK65LMN": "NASDAQ Hong Kong Utilities Large Mid Cap NTR Index", "I:NQHK65LMT": "NASDAQ Hong Kong Utilities Large Mid Cap TR Index", "I:NQHK65N": "NASDAQ Hong Kong Utilities NTR Index", "I:NQHK65T": "NASDAQ Hong Kong Utilities TR Index", "I:NQHKBANK": "NASDAQ Hong Kong Banks", "I:NQHKBANKHKD": "NASDAQ Hong Kong Banks HKD", "I:NQHKBANKHKDN": "NASDAQ Hong Kong Banks Net Total Return HKD", "I:NQHKBANKHKDT": "NASDAQ Hong Kong Banks Total Return HKD", "I:NQHKBANKN": "NASDAQ Hong Kong Banks Net Total Return", "I:NQHKBANKT": "NASDAQ Hong Kong Banks Total Return", "I:NQHKLC": "NASDAQ Hong Kong Large Cap Index", "I:NQHKLCN": "NASDAQ Hong Kong Large Cap NTR Index", "I:NQHKLCT": "NASDAQ Hong Kong Large Cap TR Index", "I:NQHKLM": "NASDAQ Hong Kong Large Mid Cap Index", "I:NQHKLMN": "NASDAQ Hong Kong Large Mid Cap NTR Index", "I:NQHKLMT": "NASDAQ Hong Kong Large Mid Cap TR Index", "I:NQHKMC": "NASDAQ Hong Kong Mid Cap Index", "I:NQHKMCN": "NASDAQ Hong Kong Mid Cap NTR Index", "I:NQHKMCT": "NASDAQ Hong Kong Mid Cap TR Index", "I:NQHKN": "NASDAQ Hong Kong NTR Index", "I:NQHKSC": "NASDAQ Hong Kong Small Cap Index", "I:NQHKSCN": "NASDAQ Hong Kong Small Cap NTR Index", "I:NQHKSCT": "NASDAQ Hong Kong Small Cap TR Index", "I:NQHKT": "NASDAQ Hong Kong TR Index", "I:NQHTEC": "Nasdaq Lux Health Tech Index", "I:NQHTECN": "Nasdaq Lux Health Tech Net Total Return Index", "I:NQHTECT": "Nasdaq Lux Health Tech Total Return Index", "I:NQHU": "NASDAQ Hungary Index", "I:NQHUN": "NASDAQ Hungary NTR Index", "I:NQHUT": "NASDAQ Hungary TR Index", "I:NQICA": "Nasdaq Inovestor Canada Index", "I:NQICAN": "Nasdaq Inovestor Canada Net Total Return Index", "I:NQICAT": "Nasdaq Inovestor Canada Total Return Index", "I:NQICP": "Nasdaq Canadian Preservation Index", "I:NQICPCAD": "Nasdaq Canadian Preservation CAD Index", "I:NQICPCADT": "Nasdaq Canadian Preservation CAD TR Index", "I:NQICPT": "Nasdaq Canadian Preservation TR Index", "I:NQID": "NASDAQ Indonesia Index", "I:NQID15": "Nasdaq Indonesia Telecommunications Index", "I:NQID15LM": "Nasdaq Indonesia Telecommunications Large Mid Cap Index", "I:NQID15LMN": "Nasdaq Indonesia Telecommunications Large Mid Cap NTR Index", "I:NQID15LMT": "Nasdaq Indonesia Telecommunications Large Mid Cap TR Index", "I:NQID15N": "Nasdaq Indonesia Telecommunications NTR Index", "I:NQID15T": "Nasdaq Indonesia Telecommunications TR Index", "I:NQID30": "NASDAQ Indonesia Financials Index", "I:NQID30LM": "Nasdaq Indonesia Financials Large Mid Cap Index", "I:NQID30LMN": "Nasdaq Indonesia Financials Large Mid Cap NTR Index", "I:NQID30LMT": "Nasdaq Indonesia Financials Large Mid Cap TR Index", "I:NQID30N": "NASDAQ Indonesia Financials NTR Index", "I:NQID30T": "NASDAQ Indonesia Financials TR Index", "I:NQID35": "Nasdaq Indonesia Real Estate Index", "I:NQID35N": "Nasdaq Indonesia Real Estate NTR Index", "I:NQID35T": "Nasdaq Indonesia Real Estate TR Index", "I:NQID40": "Nasdaq Indonesia Consumer Discretionary Index", "I:NQID40N": "Nasdaq Indonesia Consumer Discretionary NTR Index", "I:NQID40T": "Nasdaq Indonesia Consumer Discretionary TR Index", "I:NQID45": "Nasdaq Indonesia Consumer Staples Index", "I:NQID45N": "Nasdaq Indonesia Consumer Staples NTR Index", "I:NQID45T": "Nasdaq Indonesia Consumer Staples TR Index", "I:NQID50": "Nasdaq Indonesia Industrials Index", "I:NQID50LM": "Nasdaq Indonesia Industrials Large Mid Cap Index", "I:NQID50LMN": "Nasdaq Indonesia Industrials Large Mid Cap NTR Index", "I:NQID50LMT": "Nasdaq Indonesia Industrials Large Mid Cap TR Index", "I:NQID50N": "Nasdaq Indonesia Industrials NTR Index", "I:NQID50T": "Nasdaq Indonesia Industrials TR Index", "I:NQID55": "Nasdaq Indonesia Basic Materials Index", "I:NQID55LM": "Nasdaq Indonesia Basic Materials Large Mid Cap Index", "I:NQID55LMN": "Nasdaq Indonesia Basic Materials Large Mid Cap NTR Index", "I:NQID55LMT": "Nasdaq Indonesia Basic Materials Large Mid Cap TR Index", "I:NQID55N": "Nasdaq Indonesia Basic Materials NTR Index", "I:NQID55T": "Nasdaq Indonesia Basic Materials TR Index","I:NQIDLC": "NASDAQ Indonesia Large Cap Index", "I:NQIDLCN": "NASDAQ Indonesia Large Cap NTR Index", "I:NQIDLCT": "NASDAQ Indonesia Large Cap TR Index", "I:NQIDLM": "NASDAQ Indonesia Large Mid Cap Index", "I:NQIDLMN": "NASDAQ Indonesia Large Mid Cap NTR Index", "I:NQIDLMT": "NASDAQ Indonesia Large Mid Cap TR Index", "I:NQIDMC": "NASDAQ Indonesia Mid Cap Index", "I:NQIDMCN": "NASDAQ Indonesia Mid Cap NTR Index", "I:NQIDMCT": "NASDAQ Indonesia Mid Cap TR Index", "I:NQIDN": "NASDAQ Indonesia NTR Index", "I:NQIDSC": "NASDAQ Indonesia Small Cap Index", "I:NQIDSCN": "NASDAQ Indonesia Small Cap NTR Index", "I:NQIDSCT": "NASDAQ Indonesia Small Cap TR Index", "I:NQIDT": "NASDAQ Indonesia TR Index", "I:NQIE": "NASDAQ Ireland Index", "I:NQIE30": "NASDAQ Ireland Financials Index", "I:NQIE30N": "NASDAQ Ireland Financials NTR Index", "I:NQIE30T": "NASDAQ Ireland Financials TR Index", "I:NQIE50": "Nasdaq Ireland Industrials Index", "I:NQIE50N": "Nasdaq Ireland Industrials NTR Index", "I:NQIE50T": "Nasdaq Ireland Industrials TR Index", "I:NQIELM": "NASDAQ Ireland Large Mid Cap Index", "I:NQIELMN": "NASDAQ Ireland Large Mid Cap NTR Index", "I:NQIELMT": "NASDAQ Ireland Large Mid Cap TR Index", "I:NQIEMC": "NASDAQ Ireland Mid Cap Index", "I:NQIEMCN": "NASDAQ Ireland Mid Cap NTR Index", "I:NQIEMCT": "NASDAQ Ireland Mid Cap TR Index", "I:NQIEN": "NASDAQ Ireland NTR Index", "I:NQIESC": "NASDAQ Ireland Small Cap Index", "I:NQIESCN": "NASDAQ Ireland Small Cap NTR Index", "I:NQIESCT": "NASDAQ Ireland Small Cap TR Index", "I:NQIET": "NASDAQ Ireland TR Index", "I:NQIL": "NASDAQ Israel Index", "I:NQIL10": "Nasdaq Israel Technology Index", "I:NQIL10N": "Nasdaq Israel Technology NTR Index", "I:NQIL10T": "Nasdaq Israel Technology TR Index", "I:NQIL15": "Nasdaq Israel Telecommunications Index", "I:NQIL15N": "Nasdaq Israel Telecommunications NTR Index", "I:NQIL15T": "Nasdaq Israel Telecommunications TR Index", "I:NQIL20": "NASDAQ Israel Health Care Index", "I:NQIL20N": "NASDAQ Israel Health Care NTR Index", "I:NQIL20T": "NASDAQ Israel Health Care TR Index", "I:NQIL30": "NASDAQ Israel Financials Index", "I:NQIL30LM": "Nasdaq Israel Financials Large Mid Cap Index", "I:NQIL30LMN": "NASDAQ Israel Financials Large Mid Cap NTR Index", "I:NQIL30LMT": "NASDAQ Israel Financials Large Mid Cap TR Index", "I:NQIL30N": "NASDAQ Israel Financials NTR Index", "I:NQIL30T": "NASDAQ Israel Financials TR Index", "I:NQIL35": "Nasdaq Israel Real Estate Index", "I:NQIL35N": "Nasdaq Israel Real Estate NTR Index", "I:NQIL35T": "Nasdaq Israel Real Estate TR Index", "I:NQIL40": "Nasdaq Israel Consumer Discretionary Index", "I:NQIL40N": "Nasdaq Israel Consumer Discretionary NTR Index", "I:NQIL40T": "Nasdaq Israel Consumer Discretionary TR Index", "I:NQIL50": "Nasdaq Israel Industrials Index", "I:NQIL50N": "Nasdaq Israel Industrials NTR Index", "I:NQIL50T": "Nasdaq Israel Industrials TR Index", "I:NQIL55": "Nasdaq Israel Basic Materials Index", "I:NQIL55N": "Nasdaq Israel Basic Materials NTR Index", "I:NQIL55T": "Nasdaq Israel Basic Materials TR Index", "I:NQIL60": "Nasdaq Israel Energy Index", "I:NQIL60N": "Nasdaq Israel Energy NTR Index", "I:NQIL60T": "Nasdaq Israel Energy TR Index", "I:NQILLM": "NASDAQ Israel Large Mid Cap Index", "I:NQILLMN": "NASDAQ Israel Large Mid Cap NTR Index", "I:NQILLMT": "NASDAQ Israel Large Mid Cap TR Index", "I:NQILMC": "NASDAQ Israel Mid Cap Index", "I:NQILMCN": "NASDAQ Israel Mid Cap NTR Index", "I:NQILMCT": "NASDAQ Israel Mid Cap TR Index", "I:NQILN": "NASDAQ Israel NTR Index", "I:NQILSC": "NASDAQ Israel Small Cap Index", "I:NQILSCN": "NASDAQ Israel Small Cap NTR Index", "I:NQILSCT": "NASDAQ Israel Small Cap TR Index", "I:NQILT": "NASDAQ Israel TR Index", "I:NQIN": "NASDAQ India Index", "I:NQIN10": "Nasdaq India Technology Index", "I:NQIN10LM": "Nasdaq India Technology Large Mid Cap Index", "I:NQIN10LMN": "Nasdaq India Technology Large Mid Cap NTR Index", "I:NQIN10LMT": "Nasdaq India Technology Large Mid Cap TR Index", "I:NQIN10N": "Nasdaq India Technology NTR Index", "I:NQIN10T": "Nasdaq India Technology TR Index", "I:NQIN15": "Nasdaq India Telecommunications Index", "I:NQIN15LM": "Nasdaq India Telecommunications Large Mid Cap Index", "I:NQIN15LMN": "Nasdaq India Telecommunications Large Mid Cap NTR Index", "I:NQIN15LMT": "Nasdaq India Telecommunications Large Mid Cap TR Index", "I:NQIN15N": "Nasdaq India Telecommunications NTR Index", "I:NQIN15T": "Nasdaq India Telecommunications TR Index", "I:NQIN20": "NASDAQ India Health Care Index", "I:NQIN20LM": "Nasdaq India Health Care Large Mid Cap Index", "I:NQIN20LMN": "NASDAQ India Health Care Large Mid Cap NTR Index", "I:NQIN20LMT": "NASDAQ India Health Care Large Mid Cap TR Index", "I:NQIN20N": "NASDAQ India Health Care NTR Index", "I:NQIN20T": "NASDAQ India Health Care TR Index", "I:NQIN30": "NASDAQ India Financials Index", "I:NQIN30LM": "Nasdaq India Financials Large Mid Cap Index", "I:NQIN30LMN": "NASDAQ India Financials Large Mid Cap NTR Index", "I:NQIN30LMT": "NASDAQ India Financials Large Mid Cap TR Index", "I:NQIN30N": "NASDAQ India Financials NTR Index", "I:NQIN30T": "NASDAQ India Financials TR Index", "I:NQIN35": "Nasdaq India Real Estate Index", "I:NQIN35N": "Nasdaq India Real Estate NTR Index", "I:NQIN35T": "Nasdaq India Real Estate TR Index", "I:NQIN40": "Nasdaq India Consumer Discretionary Index", "I:NQIN40LM": "Nasdaq India Consumer Discretionary Large Mid Cap Index", "I:NQIN40LMN": "Nasdaq India Consumer Discretionary Large Mid Cap NTR Index", "I:NQIN40LMT": "Nasdaq India Consumer Discretionary Large Mid Cap TR Index", "I:NQIN40N": "Nasdaq India Consumer Discretionary NTR Index", "I:NQIN40T": "Nasdaq India Consumer Discretionary TR Index", "I:NQIN45": "Nasdaq India Consumer Staples Index", "I:NQIN45LM": "Nasdaq India Consumer Staples Large Mid Cap Index", "I:NQIN45LMN": "Nasdaq India Consumer Staples Large Mid Cap NTR Index", "I:NQIN45LMT": "Nasdaq India Consumer Staples Large Mid Cap TR Index", "I:NQIN45N": "Nasdaq India Consumer Staples NTR Index", "I:NQIN45T": "Nasdaq India Consumer Staples TR Index", "I:NQIN50": "Nasdaq India Industrials Index", "I:NQIN50LM": "Nasdaq India Industrials Large Mid Cap Index", "I:NQIN50LMN": "Nasdaq India Industrials Large Mid Cap NTR Index", "I:NQIN50LMT": "Nasdaq India Industrials Large Mid Cap TR Index", "I:NQIN50N": "Nasdaq India Industrials NTR Index", "I:NQIN50T": "Nasdaq India Industrials TR Index", "I:NQIN55": "Nasdaq India Basic Materials Index", "I:NQIN55LM": "Nasdaq India Basic Materials Large Mid Cap Index", "I:NQIN55LMN": "Nasdaq India Basic Materials Large Mid Cap NTR Index", "I:NQIN55LMT": "Nasdaq India Basic Materials Large Mid Cap TR Index", "I:NQIN55N": "Nasdaq India Basic Materials NTR Index", "I:NQIN55T": "Nasdaq India Basic Materials TR Index", "I:NQIN60": "Nasdaq India Energy Index", "I:NQIN60LM": "Nasdaq India Energy Large Mid Cap Index", "I:NQIN60LMN": "Nasdaq India Energy Large Mid Cap NTR Index", "I:NQIN60LMT": "Nasdaq India Energy Large Mid Cap TR Index", "I:NQIN60N": "Nasdaq India Energy NTR Index", "I:NQIN60T": "Nasdaq India Energy TR Index", "I:NQIN65": "NASDAQ India Utilities Index", "I:NQIN65LM": "Nasdaq India Utilities Large Mid Cap Index", "I:NQIN65LMN": "NASDAQ India Utilities Large Mid Cap NTR Index", "I:NQIN65LMT": "NASDAQ India Utilities Large Mid Cap TR Index", "I:NQIN65N": "NASDAQ India Utilities NTR Index", "I:NQIN65T": "NASDAQ India Utilities TR Index", "I:NQINLC": "NASDAQ India Large Cap Index", "I:NQINLCN": "NASDAQ India Large Cap NTR Index", "I:NQINLCT": "NASDAQ India Large Cap TR Index", "I:NQINLM": "NASDAQ India Large Mid Cap Index", "I:NQINLMN": "NASDAQ India Large Mid Cap NTR Index", "I:NQINLMT": "NASDAQ India Large Mid Cap TR Index", "I:NQINMC": "NASDAQ India Mid Cap Index", "I:NQINMCN": "NASDAQ India Mid Cap NTR Index", "I:NQINMCT": "NASDAQ India Mid Cap TR Index", "I:NQINN": "NASDAQ India NTR Index", "I:NQINSC": "NASDAQ India Small Cap Index", "I:NQINSCN": "NASDAQ India Small Cap NTR Index", "I:NQINSCT": "NASDAQ India Small Cap TR Index", "I:NQINT": "NASDAQ India TR Index", "I:NQINTEL": "Nasdaq CTA Artificial Intelligence Index", "I:NQINTELN": "Nasdaq CTA Artificial Intelligence NTR Index", "I:NQINTELT": "Nasdaq CTA Artificial Intelligence TR Index", "I:NQIT": "NASDAQ Italy Index", "I:NQIT10": "Nasdaq Italy Technology Index", "I:NQIT10N": "Nasdaq Italy Technology NTR Index", "I:NQIT10T": "Nasdaq Italy Technology TR Index", "I:NQIT20": "NASDAQ Italy Health Care Index", "I:NQIT20N": "NASDAQ Italy Health Care NTR Index", "I:NQIT20T": "NASDAQ Italy Health Care TR Index", "I:NQIT30": "NASDAQ Italy Financials Index", "I:NQIT30LM": "Nasdaq Italy Financials Large Mid Cap Index", "I:NQIT30LMN": "NASDAQ Italy Financials Large Mid Cap NTR Index", "I:NQIT30LMT": "NASDAQ Italy Financials Large Mid Cap TR Index", "I:NQIT30N": "NASDAQ Italy Financials NTR Index", "I:NQIT30T": "NASDAQ Italy Financials TR Index", "I:NQIT40": "Nasdaq Italy Consumer Discretionary Index", "I:NQIT40N": "Nasdaq Italy Consumer Discretionary NTR Index", "I:NQIT40T": "Nasdaq Italy Consumer Discretionary TR Index", "I:NQIT50": "Nasdaq Italy Industrials Index", "I:NQIT50LM": "Nasdaq Italy Industrials Large Mid Cap Index", "I:NQIT50LMN": "Nasdaq Italy Industrials Large Mid Cap NTR Index", "I:NQIT50LMT": "Nasdaq Italy Industrials Large Mid Cap TR Index", "I:NQIT50N": "Nasdaq Italy Industrials NTR Index", "I:NQIT50T": "Nasdaq Italy Industrials TR Index", "I:NQIT60": "Nasdaq Italy Energy Index", "I:NQIT60N": "Nasdaq Italy Energy NTR Index", "I:NQIT60T": "Nasdaq Italy Energy TR Index", "I:NQIT65": "NASDAQ Italy Utilities Index", "I:NQIT65LM": "Nasdaq Italy Utilities Large Mid Cap Index", "I:NQIT65LMN": "NASDAQ Italy Utilities Large Mid Cap NTR Index", "I:NQIT65LMT": "NASDAQ Italy Utilities Large Mid Cap TR Index", "I:NQIT65N": "NASDAQ Italy Utilities NTR Index", "I:NQIT65T": "NASDAQ Italy Utilities TR Index", "I:NQITLC": "NASDAQ Italy Large Cap Index", "I:NQITLCN": "NASDAQ Italy Large Cap NTR Index", "I:NQITLCT": "NASDAQ Italy Large Cap TR Index", "I:NQITLM": "NASDAQ Italy Large Mid Cap Index", "I:NQITLMN": "NASDAQ Italy Large Mid Cap NTR Index", "I:NQITLMT": "NASDAQ Italy Large Mid Cap TR Index", "I:NQITMC": "NASDAQ Italy Mid Cap Index", "I:NQITMCN": "NASDAQ Italy Mid Cap NTR Index", "I:NQITMCT": "NASDAQ Italy Mid Cap TR Index", "I:NQITN": "NASDAQ Italy NTR Index", "I:NQITSC": "NASDAQ Italy Small Cap Index", "I:NQITSCN": "NASDAQ Italy Small Cap NTR Index", "I:NQITSCT": "NASDAQ Italy Small Cap TR Index", "I:NQITT": "NASDAQ Italy TR Index", "I:NQJP": "NASDAQ Japan Index", "I:NQJP10": "Nasdaq Japan Technology Index", "I:NQJP10LM": "Nasdaq Japan Technology Large Mid Cap Index", "I:NQJP10LMN": "Nasdaq Japan Technology Large Mid Cap NTR Index", "I:NQJP10LMT": "Nasdaq Japan Technology Large Mid Cap TR Index", "I:NQJP10N": "Nasdaq Japan Technology NTR Index", "I:NQJP10T": "Nasdaq Japan Technology TR Index", "I:NQJP15": "Nasdaq Japan Telecommunications Index", "I:NQJP15LM": "Nasdaq Japan Telecommunications Large Mid Cap Index", "I:NQJP15LMN": "Nasdaq Japan Telecommunications Large Mid Cap NTR Index", "I:NQJP15LMT": "Nasdaq Japan Telecommunications Large Mid Cap TR Index", "I:NQJP15N": "Nasdaq Japan Telecommunications NTR Index", "I:NQJP15T": "Nasdaq Japan Telecommunications TR Index", "I:NQJP20": "NASDAQ Japan Health Care Index", "I:NQJP20LM": "Nasdaq Japan Health Care Large Mid Cap Index", "I:NQJP20LMN": "NASDAQ Japan Health Care Large Mid Cap NTR Index", "I:NQJP20LMT": "NASDAQ Japan Health Care Large Mid Cap TR Index", "I:NQJP20N": "NASDAQ Japan Health Care NTR Index", "I:NQJP20T": "NASDAQ Japan Health Care TR Index", "I:NQJP30": "NASDAQ Japan Financials Index", "I:NQJP3010": "NASDAQ Japan Banks Index", "I:NQJP3010LM": "Nasdaq Japan Banks Large Mid Cap Index", "I:NQJP3010LMN": "NASDAQ Japan Banks Large Mid Cap NTR Index", "I:NQJP3010LMT": "NASDAQ Japan Banks Large Mid Cap TR Index", "I:NQJP3010N": "NASDAQ Japan Banks NTR Index", "I:NQJP3010T": "NASDAQ Japan Banks TR Index", "I:NQJP3020": "Nasdaq Japan Financial Services Index", "I:NQJP3020LM": "Nasdaq Japan Financial Services Large Mid Cap Index", "I:NQJP3020LMN": "Nasdaq Japan Financial Services Large Mid Cap NTR Index", "I:NQJP3020LMT": "Nasdaq Japan Financial Services Large Mid Cap TR Index", "I:NQJP3020N": "Nasdaq Japan Financial Services NTR Index", "I:NQJP3020T": "Nasdaq Japan Financial Services TR Index", "I:NQJP3030": "Nasdaq Japan Insurance Index", "I:NQJP3030LM": "Nasdaq Japan Insurance Large Mid Cap Index", "I:NQJP3030LMN": "Nasdaq Japan Insurance Large Mid Cap NTR Index", "I:NQJP3030LMT": "Nasdaq Japan Insurance Large Mid Cap TR Index", "I:NQJP3030N": "Nasdaq Japan Insurance NTR Index", "I:NQJP3030T": "Nasdaq Japan Insurance TR Index", "I:NQJP30LM": "Nasdaq Japan Financials Large Mid Cap Index", "I:NQJP30LMN": "NASDAQ Japan Financials Large Mid Cap NTR Index", "I:NQJP30LMT": "NASDAQ Japan Financials Large Mid Cap TR Index", "I:NQJP30N": "NASDAQ Japan Financials NTR Index", "I:NQJP30T": "NASDAQ Japan Financials TR Index", "I:NQJP35": "NASDAQ Japan Real Estate Index", "I:NQJP35LM": "Nasdaq Japan Real Estate Large Mid Cap Index", "I:NQJP35LMN": "NASDAQ Japan Real Estate Large Mid Cap NTR Index", "I:NQJP35LMT": "NASDAQ Japan Real Estate Large Mid Cap TR Index", "I:NQJP35N": "NASDAQ Japan Real Estate NTR Index", "I:NQJP35T": "NASDAQ Japan Real Estate TR Index", "I:NQJP40": "Nasdaq Japan Consumer Discretionary Index", "I:NQJP4010": "Nasdaq Japan Automobiles and Parts Index", "I:NQJP4010LM": "Nasdaq Japan Automobiles and Parts Large Mid Cap Index", "I:NQJP4010LMN": "Nasdaq Japan Automobiles and Parts Large Mid Cap NTR Index", "I:NQJP4010LMT": "Nasdaq Japan Automobiles and Parts Large Mid Cap TR Index", "I:NQJP4010N": "Nasdaq Japan Automobiles and Parts NTR Index", "I:NQJP4010T": "Nasdaq Japan Automobiles and Parts TR Index", "I:NQJP4020": "Nasdaq Japan Consumer Products and Services Index", "I:NQJP4020LM": "Nasdaq Japan Consumer Products and Services Large Mid Cap Index", "I:NQJP4020LMN": "Nasdaq Japan Consumer Products and Services Large Mid Cap NTR Index", "I:NQJP4020LMT": "Nasdaq Japan Consumer Products and Services Large Mid Cap TR Index", "I:NQJP4020N": "Nasdaq Japan Consumer Products and Services NTR Index", "I:NQJP4020T": "Nasdaq Japan Consumer Products and Services TR Index", "I:NQJP4030": "NASDAQ Japan Media Index", "I:NQJP4030LM": "Nasdaq Japan Media Large Mid Cap Index", "I:NQJP4030LMN": "NASDAQ Japan Media Large Mid Cap NTR Index", "I:NQJP4030LMT": "NASDAQ Japan Media Large Mid Cap TR Index", "I:NQJP4030N": "NASDAQ Japan Media NTR Index", "I:NQJP4030T": "NASDAQ Japan Media TR Index", "I:NQJP4040": "NASDAQ Japan Retail Index", "I:NQJP4040LM": "Nasdaq Japan Retail Large Mid Cap Index", "I:NQJP4040LMN": "NASDAQ Japan Retail Large Mid Cap NTR Index", "I:NQJP4040LMT": "NASDAQ Japan Retail Large Mid Cap TR Index", "I:NQJP4040N": "NASDAQ Japan Retail NTR Index", "I:NQJP4040T": "NASDAQ Japan Retail TR Index", "I:NQJP4050": "Nasdaq Japan Travel and Leisure Index", "I:NQJP4050LM": "Nasdaq Japan Travel and Leisure Large Mid Cap Index", "I:NQJP4050LMN": "Nasdaq Japan Travel and Leisure Large Mid Cap NTR Index", "I:NQJP4050LMT": "Nasdaq Japan Travel and Leisure Large Mid Cap TR Index", "I:NQJP4050N": "Nasdaq Japan Travel and Leisure NTR Index", "I:NQJP4050T": "Nasdaq Japan Travel and Leisure TR Index", "I:NQJP40LM": "Nasdaq Japan Consumer Discretionary Large Mid Cap Index", "I:NQJP40LMN": "Nasdaq Japan Consumer Discretionary Large Mid Cap NTR Index", "I:NQJP40LMT": "Nasdaq Japan Consumer Discretionary Large Mid Cap TR Index", "I:NQJP40N": "Nasdaq Japan Consumer Discretionary NTR Index", "I:NQJP40T": "Nasdaq Japan Consumer Discretionary TR Index", "I:NQJP45": "Nasdaq Japan Consumer Staples Index", "I:NQJP4510": "Nasdaq Japan Food, Beverage and Tobacco Index", "I:NQJP4510LM": "Nasdaq Japan Food, Beverage and Tobacco Large Mid Cap Index", "I:NQJP4510LMN": "Nasdaq Japan Food, Beverage and Tobacco Large Mid Cap NTR Index", "I:NQJP4510LMT": "Nasdaq Japan Food, Beverage and Tobacco Large Mid Cap TR Index", "I:NQJP4510N": "Nasdaq Japan Food, Beverage and Tobacco NTR Index", "I:NQJP4510T": "Nasdaq Japan Food, Beverage and Tobacco TR Index", "I:NQJP4520": "Nasdaq Japan Personal Care, Drug and Grocery Stores Index", "I:NQJP4520LM": "Nasdaq Japan Personal Care, Drug and Grocery Stores Large Mid Cap Index", "I:NQJP4520LMN": "Nasdaq Japan Personal Care, Drug and Grocery Stores Large Mid Cap NTR Index", "I:NQJP4520LMT": "Nasdaq Japan Personal Care, Drug and Grocery Stores Large Mid Cap TR Index", "I:NQJP4520N": "Nasdaq Japan Personal Care, Drug and Grocery Stores NTR Index", "I:NQJP4520T": "Nasdaq Japan Personal Care, Drug and Grocery Stores TR Index", "I:NQJP45LM": "Nasdaq Japan Consumer Staples Large Mid Cap Index", "I:NQJP45LMN": "Nasdaq Japan Consumer Staples Large Mid Cap NTR Index", "I:NQJP45LMT": "Nasdaq Japan Consumer Staples Large Mid Cap TR Index", "I:NQJP45N": "Nasdaq Japan Consumer Staples NTR Index", "I:NQJP45T": "Nasdaq Japan Consumer Staples TR Index", "I:NQJP50": "Nasdaq Japan Industrials Index", "I:NQJP5010": "Nasdaq Japan Construction and Materials Index", "I:NQJP5010LM": "Nasdaq Japan Construction and Materials Large Mid Cap Index", "I:NQJP5010LMN": "Nasdaq Japan Construction and Materials Large Mid Cap NTR Index", "I:NQJP5010LMT": "Nasdaq Japan Construction and Materials Large Mid Cap TR Index", "I:NQJP5010N": "Nasdaq Japan Construction and Materials NTR Index", "I:NQJP5010T": "Nasdaq Japan Construction and Materials TR Index", "I:NQJP5020": "Nasdaq Japan Industrial Goods and Services Index", "I:NQJP5020LM": "Nasdaq Japan Industrial Goods and Services Large Mid Cap Index", "I:NQJP5020LMN": "Nasdaq Japan Industrial Goods and Services Large Mid Cap NTR Index", "I:NQJP5020LMT": "Nasdaq Japan Industrial Goods and Services Large Mid Cap TR Index", "I:NQJP5020N": "Nasdaq Japan Industrial Goods and Services NTR Index", "I:NQJP5020T": "Nasdaq Japan Industrial Goods and Services TR Index", "I:NQJP50LM": "Nasdaq Japan Industrials Large Mid Cap Index", "I:NQJP50LMN": "Nasdaq Japan Industrials Large Mid Cap NTR Index", "I:NQJP50LMT": "Nasdaq Japan Industrials Large Mid Cap TR Index", "I:NQJP50N": "Nasdaq Japan Industrials NTR Index", "I:NQJP50T": "Nasdaq Japan Industrials TR Index", "I:NQJP55": "Nasdaq Japan Basic Materials Index", "I:NQJP5510": "NASDAQ Japan Basic Resources Index", "I:NQJP5510LM": "Nasdaq Japan Basic Resources Large Mid Cap Index", "I:NQJP5510LMN": "Nasdaq Japan Basic Resources Large Mid Cap NTR Index", "I:NQJP5510LMT": "Nasdaq Japan Basic Resources Large Mid Cap TR Index", "I:NQJP5510N": "NASDAQ Japan Basic Resources NTR Index", "I:NQJP5510T": "NASDAQ Japan Basic Resources TR Index", "I:NQJP5520": "NASDAQ Japan Chemicals Index", "I:NQJP5520LM": "Nasdaq Japan Chemicals Large Mid Cap Index", "I:NQJP5520LMN": "NASDAQ Japan Chemicals Large Mid Cap NTR Index", "I:NQJP5520LMT": "NASDAQ Japan Chemicals Large Mid Cap TR Index", "I:NQJP5520N": "NASDAQ Japan Chemicals NTR Index", "I:NQJP5520T": "NASDAQ Japan Chemicals TR Index", "I:NQJP55LM": "Nasdaq Japan Basic Materials Large Mid Cap Index", "I:NQJP55LMN": "Nasdaq Japan Basic Materials Large Mid Cap NTR Index", "I:NQJP55LMT": "Nasdaq Japan Basic Materials Large Mid Cap TR Index", "I:NQJP55N": "Nasdaq Japan Basic Materials NTR Index", "I:NQJP55T": "Nasdaq Japan Basic Materials TR Index", "I:NQJP60": "Nasdaq Japan Energy Index", "I:NQJP60LM": "Nasdaq Japan Energy Large Mid Cap Index", "I:NQJP60LMN": "Nasdaq Japan Energy Large Mid Cap NTR Index", "I:NQJP60LMT": "Nasdaq Japan Energy Large Mid Cap TR Index", "I:NQJP60N": "Nasdaq Japan Energy NTR Index", "I:NQJP60T": "Nasdaq Japan Energy TR Index", "I:NQJP65": "NASDAQ Japan Utilities Index", "I:NQJP65LM": "Nasdaq Japan Utilities Large Mid Cap Index", "I:NQJP65LMN": "NASDAQ Japan Utilities Large Mid Cap NTR Index", "I:NQJP65LMT": "NASDAQ Japan Utilities Large Mid Cap TR Index", "I:NQJP65N": "NASDAQ Japan Utilities NTR Index", "I:NQJP65T": "NASDAQ Japan Utilities TR Index", "I:NQJPLC": "NASDAQ Japan Large Cap Index", "I:NQJPLCN": "NASDAQ Japan Large Cap NTR Index", "I:NQJPLCT": "NASDAQ Japan Large Cap TR Index", "I:NQJPLM": "NASDAQ Japan Large Mid Cap Index", "I:NQJPLMN": "NASDAQ Japan Large Mid Cap NTR Index", "I:NQJPLMT": "NASDAQ Japan Large Mid Cap TR Index", "I:NQJPMC": "NASDAQ Japan Mid Cap Index", "I:NQJPMCN": "NASDAQ Japan Mid Cap NTR Index", "I:NQJPMCT": "NASDAQ Japan Mid Cap TR Index", "I:NQJPN": "NASDAQ Japan NTR Index", "I:NQJPSC": "NASDAQ Japan Small Cap Index", "I:NQJPSCN": "NASDAQ Japan Small Cap NTR Index", "I:NQJPSCT": "NASDAQ Japan Small Cap TR Index", "I:NQJPT": "NASDAQ Japan TR Index", "I:NQKR": "NASDAQ Korea Index", "I:NQKR10": "Nasdaq Korea Technology Index", "I:NQKR10LM": "Nasdaq Korea Technology Large Mid Cap Index", "I:NQKR10LMN": "Nasdaq Korea Technology Large Mid Cap NTR Index", "I:NQKR10LMT": "Nasdaq Korea Technology Large Mid Cap TR Index", "I:NQKR10N": "Nasdaq Korea Technology NTR Index", "I:NQKR10T": "Nasdaq Korea Technology TR Index", "I:NQKR20": "NASDAQ Korea Health Care Index", "I:NQKR20LM": "Nasdaq Korea Health Care Large Mid Cap Index", "I:NQKR20LMN": "NASDAQ Korea Health Care Large Mid Cap NTR Index", "I:NQKR20LMT": "NASDAQ Korea Health Care Large Mid Cap TR Index", "I:NQKR20N": "NASDAQ Korea Health Care NTR Index", "I:NQKR20T": "NASDAQ Korea Health Care TR Index", "I:NQKR30": "NASDAQ Korea Financials Index", "I:NQKR30LM": "Nasdaq Korea Financials Large Mid Cap Index", "I:NQKR30LMN": "NASDAQ Korea Financials Large Mid Cap NTR Index", "I:NQKR30LMT": "NASDAQ Korea Financials Large Mid Cap TR Index", "I:NQKR30N": "NASDAQ Korea Financials NTR Index", "I:NQKR30T": "NASDAQ Korea Financials TR Index", "I:NQKR35": "Nasdaq Korea Real Estate Index", "I:NQKR35N": "Nasdaq Korea Real Estate NTR Index", "I:NQKR35T": "Nasdaq Korea Real Estate TR Index", "I:NQKR40": "Nasdaq Korea Consumer Discretionary Index", "I:NQKR40LM": "Nasdaq Korea Consumer Discretionary Large Mid Cap Index", "I:NQKR40LMN": "Nasdaq Korea Consumer Discretionary Large Mid Cap NTR Index", "I:NQKR40LMT": "Nasdaq Korea Consumer Discretionary Large Mid Cap TR Index", "I:NQKR40N": "Nasdaq Korea Consumer Discretionary NTR Index", "I:NQKR40T": "Nasdaq Korea Consumer Discretionary TR Index", "I:NQKR45": "Nasdaq Korea Consumer Staples Index", "I:NQKR45LM": "Nasdaq Korea Consumer Staples Large Mid Cap Index", "I:NQKR45LMN": "Nasdaq Korea Consumer Staples Large Mid Cap NTR Index", "I:NQKR45LMT": "Nasdaq Korea Consumer Staples Large Mid Cap TR Index", "I:NQKR45N": "Nasdaq Korea Consumer Staples NTR Index", "I:NQKR45T": "Nasdaq Korea Consumer Staples TR Index", "I:NQKR50": "Nasdaq Korea Industrials Index", "I:NQKR50LM": "Nasdaq Korea Industrials Large Mid Cap Index", "I:NQKR50LMN": "Nasdaq Korea Industrials Large Mid Cap NTR Index", "I:NQKR50LMT": "Nasdaq Korea Industrials Large Mid Cap TR Index", "I:NQKR50N": "Nasdaq Korea Industrials NTR Index", "I:NQKR50T": "Nasdaq Korea Industrials TR Index", "I:NQKR55": "Nasdaq Korea Basic Materials Index", "I:NQKR55LM": "Nasdaq Korea Basic Materials Large Mid Cap Index", "I:NQKR55LMN": "Nasdaq Korea Basic Materials Large Mid Cap NTR Index", "I:NQKR55LMT": "Nasdaq Korea Basic Materials Large Mid Cap TR Index", "I:NQKR55N": "Nasdaq Korea Basic Materials NTR Index", "I:NQKR55T": "Nasdaq Korea Basic Materials TR Index", "I:NQKR60": "Nasdaq Korea Energy Index", "I:NQKR60LM": "Nasdaq Korea Energy Large Mid Cap Index", "I:NQKR60LMN": "Nasdaq Korea Energy Large Mid Cap NTR Index", "I:NQKR60LMT": "Nasdaq Korea Energy Large Mid Cap TR Index", "I:NQKR60N": "Nasdaq Korea Energy NTR Index", "I:NQKR60T": "Nasdaq Korea Energy TR Index", "I:NQKR65": "NASDAQ Korea Utilities Index", "I:NQKR65N": "NASDAQ Korea Utilities NTR Index", "I:NQKR65T": "NASDAQ Korea Utilities TR Index", "I:NQKRLC": "NASDAQ Korea Large Cap Index", "I:NQKRLCN": "NASDAQ Korea Large Cap NTR Index", "I:NQKRLCT": "NASDAQ Korea Large Cap TR Index", "I:NQKRLM": "NASDAQ Korea Large Mid Cap Index", "I:NQKRLMN": "NASDAQ Korea Large Mid Cap NTR Index", "I:NQKRLMT": "NASDAQ Korea Large Mid Cap TR Index", "I:NQKRMC": "NASDAQ Korea Mid Cap Index", "I:NQKRMCN": "NASDAQ Korea Mid Cap NTR Index", "I:NQKRMCT": "NASDAQ Korea Mid Cap TR Index", "I:NQKRN": "NASDAQ Korea NTR Index", "I:NQKRSC": "NASDAQ Korea Small Cap Index", "I:NQKRSCN": "NASDAQ Korea Small Cap NTR Index", "I:NQKRSCT": "NASDAQ Korea Small Cap TR Index", "I:NQKRT": "NASDAQ Korea TR Index", "I:NQLA": "NASDAQ Lat America Index", "I:NQLA15": "Nasdaq Latin America Telecommunications Index", "I:NQLA15LM": "Nasdaq Latin America Telecommunications Large Mid Cap Index", "I:NQLA15LMN": "Nasdaq Latin America Telecommunications Large Mid Cap NTR Index", "I:NQLA15LMT": "Nasdaq Latin America Telecommunications Large Mid Cap TR Index", "I:NQLA15N": "Nasdaq Latin America Telecommunications NTR Index", "I:NQLA15T": "Nasdaq Latin America Telecommunications TR Index", "I:NQLA20": "Nasdaq Latin America Health Care Index", "I:NQLA20LM": "Nasdaq Latin America Health Care Large Mid Cap Index", "I:NQLA20LMN": "Nasdaq Latin America Health Care Large Mid Cap NTR Index", "I:NQLA20LMT": "Nasdaq Latin America Health Care Large Mid Cap TR Index", "I:NQLA20N": "Nasdaq Latin America Health Care NTR Index", "I:NQLA20T": "Nasdaq Latin America Health Care TR Index", "I:NQLA30": "Nasdaq Latin America Financials Index", "I:NQLA3010": "Nasdaq Latin America Banks Index", "I:NQLA3010LM": "Nasdaq Latin America Banks Large Mid Cap Index", "I:NQLA3010LMN": "Nasdaq Latin America Banks Large Mid Cap NTR Index", "I:NQLA3010LMT": "Nasdaq Latin America Banks Large Mid Cap TR Index", "I:NQLA3010N": "Nasdaq Latin America Banks NTR Index", "I:NQLA3010T": "Nasdaq Latin America Banks TR Index", "I:NQLA3020": "Nasdaq Latin America Financial Services Index", "I:NQLA3020LM": "Nasdaq Latin America Financial Services Large Mid Cap Index", "I:NQLA3020LMN": "Nasdaq Latin America Financial Services Large Mid Cap NTR Index", "I:NQLA3020LMT": "Nasdaq Latin America Financial Services Large Mid Cap TR Index", "I:NQLA3020N": "Nasdaq Latin America Financial Services NTR Index", "I:NQLA3020T": "Nasdaq Latin America Financial Services TR Index", "I:NQLA3030": "Nasdaq Latin America Insurance Index", "I:NQLA3030LM": "Nasdaq Latin America Insurance Large Mid Cap Index", "I:NQLA3030LMN": "Nasdaq Latin America Insurance Large Mid Cap NTR Index", "I:NQLA3030LMT": "Nasdaq Latin America Insurance Large Mid Cap TR Index", "I:NQLA3030N": "Nasdaq Latin America Insurance NTR Index", "I:NQLA3030T": "Nasdaq Latin America Insurance TR Index", "I:NQLA30LM": "Nasdaq Latin America Financials Large Mid Cap Index", "I:NQLA30LMN": "Nasdaq Latin America Financials Large Mid Cap NTR Index", "I:NQLA30LMT": "Nasdaq Latin America Financials Large Mid Cap TR Index", "I:NQLA30N": "Nasdaq Latin America Financials NTR Index", "I:NQLA30T": "Nasdaq Latin America Financials TR Index", "I:NQLA35": "Nasdaq Latin America Real Estate Index", "I:NQLA35LM": "Nasdaq Latin America Real Estate Large Mid Cap Index", "I:NQLA35LMN": "Nasdaq Latin America Real Estate Large Mid Cap NTR Index", "I:NQLA35LMT": "Nasdaq Latin America Real Estate Large Mid Cap TR Index", "I:NQLA35N": "Nasdaq Latin America Real Estate NTR Index", "I:NQLA35T": "Nasdaq Latin America Real Estate TR Index", "I:NQLA40": "Nasdaq Latin America Consumer Discretionary Index", "I:NQLA4020": "Nasdaq Latin America Consumer Products and Services Index", "I:NQLA4020LM": "Nasdaq Latin America Consumer Products and Services Large Mid Cap Index", "I:NQLA4020LMN": "Nasdaq Latin America Consumer Products and Services Large Mid Cap NTR Index", "I:NQLA4020LMT": "Nasdaq Latin America Consumer Products and Services Large Mid Cap TR Index", "I:NQLA4020N": "Nasdaq Latin America Consumer Products and Services NTR Index", "I:NQLA4020T": "Nasdaq Latin America Consumer Products and Services TR Index", "I:NQLA4040": "Nasdaq Latin America Retail Index", "I:NQLA4040LM": "Nasdaq Latin America Retail Large Mid Cap Index", "I:NQLA4040LMN": "Nasdaq Latin America Retail Large Mid Cap NTR Index", "I:NQLA4040LMT": "Nasdaq Latin America Retail Large Mid Cap TR Index", "I:NQLA4040N": "Nasdaq Latin America Retail NTR Index", "I:NQLA4040T": "Nasdaq Latin America Retail TR Index", "I:NQLA4050": "Nasdaq Latin America Travel and Leisure Index", "I:NQLA4050N": "Nasdaq Latin America Travel and Leisure NTR Index", "I:NQLA4050T": "Nasdaq Latin America Travel and Leisure TR Index", "I:NQLA40LM": "Nasdaq Latin America Consumer Discretionary Large Mid Cap Index", "I:NQLA40LMN": "Nasdaq Latin America Consumer Discretionary Large Mid Cap NTR Index", "I:NQLA40LMT": "Nasdaq Latin America Consumer Discretionary Large Mid Cap TR Index", "I:NQLA40N": "Nasdaq Latin America Consumer Discretionary NTR Index", "I:NQLA40T": "Nasdaq Latin America Consumer Discretionary TR Index", "I:NQLA45": "Nasdaq Latin America Consumer Staples Index", "I:NQLA4510": "Nasdaq Latin America Food, Beverage and Tobacco Index", "I:NQLA4510LM": "Nasdaq Latin America Food, Beverage and Tobacco Large Mid Cap Index", "I:NQLA4510LMN": "Nasdaq Latin America Food, Beverage and Tobacco Large Mid Cap NTR Index", "I:NQLA4510LMT": "Nasdaq Latin America Food, Beverage and Tobacco Large Mid Cap TR Index", "I:NQLA4510N": "Nasdaq Latin America Food, Beverage and Tobacco NTR Index", "I:NQLA4510T": "Nasdaq Latin America Food, Beverage and Tobacco TR Index", "I:NQLA4520": "Nasdaq Latin America Personal Care, Drug and Grocery Stores Index", "I:NQLA4520LM": "Nasdaq Latin America Personal Care, Drug and Grocery Stores Large Mid Cap Index", "I:NQLA4520LMN": "Nasdaq Latin America Personal Care, Drug and Grocery Stores Large Mid Cap NTR Index", "I:NQLA4520LMT": "Nasdaq Latin America Personal Care, Drug and Grocery Stores Large Mid Cap TR Index", "I:NQLA4520N": "Nasdaq Latin America Personal Care, Drug and Grocery Stores NTR Index", "I:NQLA4520T": "Nasdaq Latin America Personal Care, Drug and Grocery Stores TR Index", "I:NQLA45LM": "Nasdaq Latin America Consumer Staples Large Mid Cap Index", "I:NQLA45LMN": "Nasdaq Latin America Consumer Staples Large Mid Cap NTR Index", "I:NQLA45LMT": "Nasdaq Latin America Consumer Staples Large Mid Cap TR Index", "I:NQLA45N": "Nasdaq Latin America Consumer Staples NTR Index", "I:NQLA45T": "Nasdaq Latin America Consumer Staples TR Index", "I:NQLA50": "Nasdaq Latin America Industrials Index", "I:NQLA5010": "Nasdaq Latin America Construction and Materials Index", "I:NQLA5010LM": "Nasdaq Latin America Construction and Materials Large Mid Cap Index", "I:NQLA5010LMN": "Nasdaq Latin America Construction and Materials Large Mid Cap NTR Index", "I:NQLA5010LMT": "Nasdaq Latin America Construction and Materials Large Mid Cap TR Index", "I:NQLA5010N": "Nasdaq Latin America Construction and Materials NTR Index", "I:NQLA5010T": "Nasdaq Latin America Construction and Materials TR Index", "I:NQLA5020": "Nasdaq Latin America Industrial Goods and Services Index", "I:NQLA5020LM": "Nasdaq Latin America Industrial Goods and Services Large Mid Cap Index", "I:NQLA5020LMN": "Nasdaq Latin America Industrial Goods and Services Large Mid Cap NTR Index", "I:NQLA5020LMT": "Nasdaq Latin America Industrial Goods and Services Large Mid Cap TR Index", "I:NQLA5020N": "Nasdaq Latin America Industrial Goods and Services NTR Index", "I:NQLA5020T": "Nasdaq Latin America Industrial Goods and Services TR Index", "I:NQLA50LM": "Nasdaq Latin America Industrials Large Mid Cap Index", "I:NQLA50LMN": "Nasdaq Latin America Industrials Large Mid Cap NTR Index", "I:NQLA50LMT": "Nasdaq Latin America Industrials Large Mid Cap TR Index", "I:NQLA50N": "Nasdaq Latin America Industrials NTR Index", "I:NQLA50T": "Nasdaq Latin America Industrials TR Index", "I:NQLA55": "Nasdaq Latin America Basic Materials Index", "I:NQLA5510": "Nasdaq Latin America Basic Resources Index", "I:NQLA5510LM": "Nasdaq Latin America Basic Resources Large Mid Cap Index", "I:NQLA5510LMN": "Nasdaq Latin America Basic Resources Large Mid Cap NTR Index", "I:NQLA5510LMT": "Nasdaq Latin America Basic Resources Large Mid Cap TR Index", "I:NQLA5510N": "Nasdaq Latin America Basic Resources NTR Index", "I:NQLA5510T": "Nasdaq Latin America Basic Resources TR Index", "I:NQLA5520": "Nasdaq Latin America Chemicals Index", "I:NQLA5520N": "Nasdaq Latin America Chemicals NTR Index", "I:NQLA5520T": "Nasdaq Latin America Chemicals TR Index", "I:NQLA55LM": "Nasdaq Latin America Basic Materials Large Mid Cap Index", "I:NQLA55LMN": "Nasdaq Latin America Basic Materials Large Mid Cap NTR Index", "I:NQLA55LMT": "Nasdaq Latin America Basic Materials Large Mid Cap TR Index", "I:NQLA55N": "Nasdaq Latin America Basic Materials NTR Index", "I:NQLA55T": "Nasdaq Latin America Basic Materials TR Index", "I:NQLA60": "Nasdaq Latin America Energy Index", "I:NQLA60LM": "Nasdaq Latin America Energy Large Mid Cap Index", "I:NQLA60LMN": "Nasdaq Latin America Energy Large Mid Cap NTR Index", "I:NQLA60LMT": "Nasdaq Latin America Energy Large Mid Cap TR Index", "I:NQLA60N": "Nasdaq Latin America Energy NTR Index", "I:NQLA60T": "Nasdaq Latin America Energy TR Index", "I:NQLA65": "Nasdaq Latin America Utilities Index", "I:NQLA65LM": "Nasdaq Latin America Utilities Large Mid Cap Index", "I:NQLA65LMN": "Nasdaq Latin America Utilities Large Mid Cap NTR Index", "I:NQLA65LMT": "Nasdaq Latin America Utilities Large Mid Cap TR Index", "I:NQLA65N": "Nasdaq Latin America Utilities NTR Index", "I:NQLA65T": "Nasdaq Latin America Utilities TR Index", "I:NQLALC": "NASDAQ Lat America Large Cap Index", "I:NQLALCN": "NASDAQ Lat America Large Cap NTR Index", "I:NQLALCT": "NASDAQ Lat America Large Cap TR Index", "I:NQLALM": "NASDAQ Lat America Large Mid Cap Index", "I:NQLALMN": "NASDAQ Lat America Large Mid Cap NTR Index", "I:NQLALMT": "NASDAQ Lat America Large Mid Cap TR Index", "I:NQLAMC": "NASDAQ Lat America Mid Cap Index", "I:NQLAMCN": "NASDAQ Lat America Mid Cap NTR Index", "I:NQLAMCT": "NASDAQ Lat America Mid Cap TR Index", "I:NQLAN": "NASDAQ Lat America NTR Index", "I:NQLASC": "NASDAQ Lat America Small Cap Index", "I:NQLASCN": "NASDAQ Lat America Small Cap NTR Index", "I:NQLASCT": "NASDAQ Lat America Small Cap TR Index", "I:NQLAT": "NASDAQ Lat America TR Index", "I:NQMA": "NASDAQ Morocco Index", "I:NQMA30": "NASDAQ Morocco Financials Index", "I:NQMA30LM": "Nasdaq Morocco Financials Large Mid Cap Index", "I:NQMA30LMN": "NASDAQ Morocco Financials Large Mid Cap NTR Index", "I:NQMA30LMT": "NASDAQ Morocco Financials Large Mid Cap TR Index", "I:NQMA30N": "NASDAQ Morocco Financials NTR Index", "I:NQMA30T": "NASDAQ Morocco Financials TR Index", "I:NQMAEQY": "Nasdaq US Multi-Asset Equity Index", "I:NQMAEQYT": "Nasdaq US Multi-Asset Equity Total Return Index", "I:NQMAFI": "Nasdaq US Multi-Asset High Yield Corporate Bond In", "I:NQMAFIT": "Nasdaq US Multi-Asset High Yield Corporate Bond To", "I:NQMALM": "NASDAQ Morocco Large Mid Cap Index", "I:NQMALMN": "NASDAQ Morocco Large Mid Cap NTR Index", "I:NQMALMT": "NASDAQ Morocco Large Mid Cap TR Index", "I:NQMAMC": "NASDAQ Morocco Mid Cap Index", "I:NQMAMCN": "NASDAQ Morocco Mid Cap NTR Index", "I:NQMAMCT": "NASDAQ Morocco Mid Cap TR Index", "I:NQMAMLP": "Nasdaq US Multi-Asset MLP Index", "I:NQMAMLPT": "Nasdaq US Multi-Asset MLP Total Return Index", "I:NQMAN": "NASDAQ Morocco NTR Index", "I:NQMAPREF": "Nasdaq US Multi-Asset Preferred Index", "I:NQMAPREFT": "Nasdaq US Multi-Asset Preferred Total Return Index", "I:NQMAREIT": "Nasdaq US Multi-Asset REIT Index", "I:NQMAREITT": "Nasdaq US Multi-Asset REIT Total Return Index", "I:NQMASC": "NASDAQ Morocco Small Cap Index", "I:NQMASCN": "NASDAQ Morocco Small Cap NTR Index", "I:NQMASCT": "NASDAQ Morocco Small Cap TR Index", "I:NQMAT": "NASDAQ Morocco TR Index", "I:NQMAUS": "NASDAQ US Multi-Asset Diversified Income Index", "I:NQMAUSN": "NASDAQ US Multi-Asset Diversified Income NTR Index", "I:NQMAUSX": "NASDAQ US Multi-Asset Diversified Income Total Ret", "I:NQMEA": "NASDAQ MEA Index", "I:NQMEA10": "Nasdaq MEA Technology Index", "I:NQMEA10N": "Nasdaq MEA Technology NTR Index", "I:NQMEA10T": "Nasdaq MEA Technology TR Index", "I:NQMEA15": "Nasdaq MEA Telecommunications Index", "I:NQMEA15LM": "Nasdaq MEA Telecommunications Large Mid Cap Index", "I:NQMEA15LMN": "Nasdaq MEA Telecommunications Large Mid Cap NTR Index", "I:NQMEA15LMT": "Nasdaq MEA Telecommunications Large Mid Cap TR Index", "I:NQMEA15N": "Nasdaq MEA Telecommunications NTR Index", "I:NQMEA15T": "Nasdaq MEA Telecommunications TR Index", "I:NQMEA20": "NASDAQ MEA Health Care Index", "I:NQMEA20LM": "Nasdaq MEA Health Care Large Mid Cap Index", "I:NQMEA20LMN": "NASDAQ MEA Health Care Large Mid Cap NTR Index", "I:NQMEA20LMT": "NASDAQ MEA Health Care Large Mid Cap TR Index", "I:NQMEA20N": "NASDAQ MEA Health Care NTR Index", "I:NQMEA20T": "NASDAQ MEA Health Care TR Index", "I:NQMEA30": "NASDAQ MEA Financials Index", "I:NQMEA3010": "NASDAQ MEA Banks Index", "I:NQMEA3010LM": "Nasdaq MEA Banks Large Mid Cap Index", "I:NQMEA3010LMN": "NASDAQ MEA Banks Large Mid Cap NTR Index", "I:NQMEA3010LMT": "NASDAQ MEA Banks Large Mid Cap TR Index", "I:NQMEA3010N": "NASDAQ MEA Banks NTR Index", "I:NQMEA3010T": "NASDAQ MEA Banks TR Index", "I:NQMEA3020": "Nasdaq MEA Financial Services Index", "I:NQMEA3020LM": "Nasdaq MEA Financial Services Large Mid Cap Index", "I:NQMEA3020LMN": "Nasdaq MEA Financial Services Large Mid Cap NTR Index", "I:NQMEA3020LMT": "Nasdaq MEA Financial Services Large Mid Cap TR Index", "I:NQMEA3020N": "Nasdaq MEA Financial Services NTR Index", "I:NQMEA3020T": "Nasdaq MEA Financial Services TR Index", "I:NQMEA3030": "Nasdaq MEA Insurance Index", "I:NQMEA3030LM": "Nasdaq MEA Insurance Large Mid Cap Index", "I:NQMEA3030LMN": "Nasdaq MEA Insurance Large Mid Cap NTR Index", "I:NQMEA3030LMT": "Nasdaq MEA Insurance Large Mid Cap TR Index", "I:NQMEA3030N": "Nasdaq MEA Insurance NTR Index", "I:NQMEA3030T": "Nasdaq MEA Insurance TR Index", "I:NQMEA30LM": "Nasdaq MEA Financials Large Mid Cap Index", "I:NQMEA30LMN": "NASDAQ MEA Financials Large Mid Cap NTR Index", "I:NQMEA30LMT": "NASDAQ MEA Financials Large Mid Cap TR Index", "I:NQMEA30N": "NASDAQ MEA Financials NTR Index", "I:NQMEA30T": "NASDAQ MEA Financials TR Index", "I:NQMEA35": "NASDAQ MEA Real Estate Index", "I:NQMEA35LM": "Nasdaq MEA Real Estate Large Mid Cap Index", "I:NQMEA35LMN": "NASDAQ MEA Real Estate Large Mid Cap NTR Index", "I:NQMEA35LMT": "NASDAQ MEA Real Estate Large Mid Cap TR Index", "I:NQMEA35N": "NASDAQ MEA Real Estate NTR Index", "I:NQMEA35T": "NASDAQ MEA Real Estate TR Index", "I:NQMEA40": "Nasdaq MEA Consumer Discretionary Index", "I:NQMEA4020": "Nasdaq MEA Consumer Products and Services Index", "I:NQMEA4020N": "Nasdaq MEA Consumer Products and Services NTR Index", "I:NQMEA4020T": "Nasdaq MEA Consumer Products and Services TR Index", "I:NQMEA4040": "NASDAQ MEA Retail Index", "I:NQMEA4040LM": "Nasdaq MEA Retail Large Mid Cap Index", "I:NQMEA4040LMN": "NASDAQ MEA Retail Large Mid Cap NTR Index", "I:NQMEA4040LMT": "NASDAQ MEA Retail Large Mid Cap TR Index", "I:NQMEA4040N": "NASDAQ MEA Retail NTR Index", "I:NQMEA4040T": "NASDAQ MEA Retail TR Index", "I:NQMEA4050": "Nasdaq MEA Travel and Leisure Index", "I:NQMEA4050N": "Nasdaq MEA Travel and Leisure NTR Index", "I:NQMEA4050T": "Nasdaq MEA Travel and Leisure TR Index", "I:NQMEA40N": "Nasdaq MEA Consumer Discretionary NTR Index", "I:NQMEA40T": "Nasdaq MEA Consumer Discretionary TR Index", "I:NQMEA45": "Nasdaq MEA Consumer Staples Index", "I:NQMEA4510": "Nasdaq MEA Food, Beverage and Tobacco Index", "I:NQMEA4510LM": "Nasdaq MEA Food, Beverage and Tobacco Large Mid Cap Index", "I:NQMEA4510LMN": "Nasdaq MEA Food, Beverage and Tobacco Large Mid Cap NTR Index", "I:NQMEA4510LMT": "Nasdaq MEA Food, Beverage and Tobacco Large Mid Cap TR Index", "I:NQMEA4510N": "Nasdaq MEA Food, Beverage and Tobacco NTR Index", "I:NQMEA4510T": "Nasdaq MEA Food, Beverage and Tobacco TR Index", "I:NQMEA4520": "Nasdaq MEA Personal Care, Drug and Grocery Stores Index", "I:NQMEA4520N": "Nasdaq MEA Personal Care, Drug and Grocery Stores NTR Index", "I:NQMEA4520T": "Nasdaq MEA Personal Care, Drug and Grocery Stores TR Index", "I:NQMEA45LM": "Nasdaq MEA Consumer Staples Large Mid Cap Index", "I:NQMEA45LMN": "Nasdaq MEA Consumer Staples Large Mid Cap NTR Index", "I:NQMEA45LMT": "Nasdaq MEA Consumer Staples Large Mid Cap TR Index", "I:NQMEA45N": "Nasdaq MEA Consumer Staples NTR Index", "I:NQMEA45T": "Nasdaq MEA Consumer Staples TR Index", "I:NQMEA50": "Nasdaq MEA Industrials Index", "I:NQMEA5010": "Nasdaq MEA Construction and Materials Index", "I:NQMEA5010N": "Nasdaq MEA Construction and Materials NTR Index", "I:NQMEA5010T": "Nasdaq MEA Construction and Materials TR Index", "I:NQMEA5020": "Nasdaq MEA Industrial Goods and Services Index", "I:NQMEA5020LM": "Nasdaq MEA Industrial Goods and Services Large Mid Cap Index", "I:NQMEA5020LMN": "Nasdaq MEA Industrial Goods and Services Large Mid Cap NTR Index", "I:NQMEA5020LMT": "Nasdaq MEA Industrial Goods and Services Large Mid Cap TR Index", "I:NQMEA5020N": "Nasdaq MEA Industrial Goods and Services NTR Index", "I:NQMEA5020T": "Nasdaq MEA Industrial Goods and Services TR Index", "I:NQMEA50LM": "Nasdaq MEA Industrials Large Mid Cap Index", "I:NQMEA50LMN": "Nasdaq MEA Industrials Large Mid Cap NTR Index", "I:NQMEA50LMT": "Nasdaq MEA Industrials Large Mid Cap TR Index", "I:NQMEA50N": "Nasdaq MEA Industrials NTR Index", "I:NQMEA50T": "Nasdaq MEA Industrials TR Index", "I:NQMEA55": "Nasdaq MEA Basic Materials Index", "I:NQMEA5510": "NASDAQ MEA Basic Resources Index", "I:NQMEA5510LM": "Nasdaq MEA Basic Resources Large Mid Cap Index", "I:NQMEA5510LMN": "NASDAQ MEA Basic Resources Large Mid Cap NTR Index", "I:NQMEA5510LMT": "NASDAQ MEA Basic Resources Large Mid Cap TR Index", "I:NQMEA5510N": "NASDAQ MEA Basic Resources NTR Index", "I:NQMEA5510T": "NASDAQ MEA Basic Resources TR Index", "I:NQMEA5520": "NASDAQ MEA Chemicals Index", "I:NQMEA5520N": "NASDAQ MEA Chemicals NTR Index", "I:NQMEA5520T": "NASDAQ MEA Chemicals TR Index","I:NQMEA55LM": "Nasdaq MEA Basic Materials Large Mid Cap Index", "I:NQMEA55LMN": "Nasdaq MEA Basic Materials Large Mid Cap NTR Index", "I:NQMEA55LMT": "Nasdaq MEA Basic Materials Large Mid Cap TR Index", "I:NQMEA55N": "Nasdaq MEA Basic Materials NTR Index", "I:NQMEA55T": "Nasdaq MEA Basic Materials TR Index", "I:NQMEA60": "Nasdaq MEA Energy Index", "I:NQMEA60N": "Nasdaq MEA Energy NTR Index", "I:NQMEA60T": "Nasdaq MEA Energy TR Index", "I:NQMEALC": "NASDAQ MEA Large Cap Index", "I:NQMEALCN": "NASDAQ MEA Large Cap NTR Index", "I:NQMEALCT": "NASDAQ MEA Large Cap TR Index", "I:NQMEALM": "NASDAQ MEA Large Mid Cap Index", "I:NQMEALMN": "NASDAQ MEA Large Mid Cap NTR Index", "I:NQMEALMT": "NASDAQ MEA Large Mid Cap TR Index", "I:NQMEAMC": "NASDAQ MEA Mid Cap Index", "I:NQMEAMCN": "NASDAQ MEA Mid Cap NTR Index", "I:NQMEAMCT": "NASDAQ MEA Mid Cap TR Index", "I:NQMEAN": "NASDAQ MEA NTR Index", "I:NQMEASC": "NASDAQ MEA Small Cap Index", "I:NQMEASCN": "NASDAQ MEA Small Cap NTR Index", "I:NQMEASCT": "NASDAQ MEA Small Cap TR Index", "I:NQMEAT": "NASDAQ MEA TR Index", "I:NQMX": "NASDAQ Mexico Index", "I:NQMX30": "NASDAQ Mexico Financials Index", "I:NQMX30LM": "Nasdaq Mexico Financials Large Mid Cap Index", "I:NQMX30LMN": "NASDAQ Mexico Financials Large Mid Cap NTR Index", "I:NQMX30LMT": "NASDAQ Mexico Financials Large Mid Cap TR Index", "I:NQMX30N": "NASDAQ Mexico Financials NTR Index", "I:NQMX30T": "NASDAQ Mexico Financials TR Index", "I:NQMX35": "Nasdaq Mexico Real Estate Index", "I:NQMX35N": "Nasdaq Mexico Real Estate NTR Index", "I:NQMX35T": "Nasdaq Mexico Real Estate TR Index", "I:NQMX40": "Nasdaq Mexico Consumer Discretionary Index", "I:NQMX40N": "Nasdaq Mexico Consumer Discretionary NTR Index", "I:NQMX40T": "Nasdaq Mexico Consumer Discretionary TR Index", "I:NQMX45": "Nasdaq Mexico Consumer Staples Index", "I:NQMX45LM": "Nasdaq Mexico Consumer Staples Large Mid Cap Index", "I:NQMX45LMN": "Nasdaq Mexico Consumer Staples Large Mid Cap NTR Index", "I:NQMX45LMT": "Nasdaq Mexico Consumer Staples Large Mid Cap TR Index", "I:NQMX45N": "Nasdaq Mexico Consumer Staples NTR Index", "I:NQMX45T": "Nasdaq Mexico Consumer Staples TR Index", "I:NQMX50": "Nasdaq Mexico Industrials Index", "I:NQMX50LM": "Nasdaq Mexico Industrials Large Mid Cap Index", "I:NQMX50LMN": "Nasdaq Mexico Industrials Large Mid Cap NTR Index", "I:NQMX50LMT": "Nasdaq Mexico Industrials Large Mid Cap TR Index", "I:NQMX50N": "Nasdaq Mexico Industrials NTR Index", "I:NQMX50T": "Nasdaq Mexico Industrials TR Index", "I:NQMX55": "Nasdaq Mexico Basic Materials Index", "I:NQMX55LM": "Nasdaq Mexico Basic Materials Large Mid Cap Index", "I:NQMX55LMN": "Nasdaq Mexico Basic Materials Large Mid Cap NTR Index", "I:NQMX55LMT": "Nasdaq Mexico Basic Materials Large Mid Cap TR Index", "I:NQMX55N": "Nasdaq Mexico Basic Materials NTR Index", "I:NQMX55T": "Nasdaq Mexico Basic Materials TR Index", "I:NQMXLC": "NASDAQ Mexico Large Cap Index", "I:NQMXLCN": "NASDAQ Mexico Large Cap NTR Index", "I:NQMXLCT": "NASDAQ Mexico Large Cap TR Index", "I:NQMXLM": "NASDAQ Mexico Large Mid Cap Index", "I:NQMXLMN": "NASDAQ Mexico Large Mid Cap NTR Index", "I:NQMXLMT": "NASDAQ Mexico Large Mid Cap TR Index", "I:NQMXMC": "NASDAQ Mexico Mid Cap Index", "I:NQMXMCN": "NASDAQ Mexico Mid Cap NTR Index", "I:NQMXMCT": "NASDAQ Mexico Mid Cap TR Index", "I:NQMXN": "NASDAQ Mexico NTR Index", "I:NQMXSC": "NASDAQ Mexico Small Cap Index", "I:NQMXSCN": "NASDAQ Mexico Small Cap NTR Index", "I:NQMXSCT": "NASDAQ Mexico Small Cap TR Index", "I:NQMXT": "NASDAQ Mexico TR Index", "I:NQMY": "NASDAQ Malaysia Index", "I:NQMY10": "Nasdaq Malaysia Technology Index", "I:NQMY10N": "Nasdaq Malaysia Technology NTR Index", "I:NQMY10T": "Nasdaq Malaysia Technology TR Index", "I:NQMY15": "Nasdaq Malaysia Telecommunications Index", "I:NQMY15N": "Nasdaq Malaysia Telecommunications NTR Index", "I:NQMY15T": "Nasdaq Malaysia Telecommunications TR Index", "I:NQMY20": "NASDAQ Malaysia Health Care Index", "I:NQMY20N": "NASDAQ Malaysia Health Care NTR Index", "I:NQMY20T": "NASDAQ Malaysia Health Care TR Index", "I:NQMY30": "NASDAQ Malaysia Financials Index", "I:NQMY30LM": "Nasdaq Malaysia Financials Large Mid Cap Index", "I:NQMY30LMN": "NASDAQ Malaysia Financials Large Mid Cap NTR Index", "I:NQMY30LMT": "NASDAQ Malaysia Financials Large Mid Cap TR Index", "I:NQMY30N": "NASDAQ Malaysia Financials NTR Index", "I:NQMY30T": "NASDAQ Malaysia Financials TR Index", "I:NQMY35": "Nasdaq Malaysia Real Estate Index", "I:NQMY35N": "Nasdaq Malaysia Real Estate NTR Index", "I:NQMY35T": "Nasdaq Malaysia Real Estate TR Index", "I:NQMY40": "Nasdaq Malaysia Consumer Discretionary Index", "I:NQMY40N": "Nasdaq Malaysia Consumer Discretionary NTR Index", "I:NQMY40T": "Nasdaq Malaysia Consumer Discretionary TR Index", "I:NQMY45": "Nasdaq Malaysia Consumer Staples Index", "I:NQMY45LM": "Nasdaq Malaysia Consumer Staples Large Mid Cap Index", "I:NQMY45LMN": "Nasdaq Malaysia Consumer Staples Large Mid Cap NTR Index", "I:NQMY45LMT": "Nasdaq Malaysia Consumer Staples Large Mid Cap TR Index", "I:NQMY45N": "Nasdaq Malaysia Consumer Staples NTR Index", "I:NQMY45T": "Nasdaq Malaysia Consumer Staples TR Index", "I:NQMY50": "Nasdaq Malaysia Industrials Index", "I:NQMY50LM": "Nasdaq Malaysia Industrials Large Mid Cap Index", "I:NQMY50LMN": "Nasdaq Malaysia Industrials Large Mid Cap NTR Index", "I:NQMY50LMT": "Nasdaq Malaysia Industrials Large Mid Cap TR Index", "I:NQMY50N": "Nasdaq Malaysia Industrials NTR Index", "I:NQMY50T": "Nasdaq Malaysia Industrials TR Index", "I:NQMY55": "Nasdaq Malaysia Basic Materials Index", "I:NQMY55N": "Nasdaq Malaysia Basic Materials NTR Index", "I:NQMY55T": "Nasdaq Malaysia Basic Materials TR Index", "I:NQMY60": "Nasdaq Malaysia Energy Index", "I:NQMY60LM": "Nasdaq Malaysia Energy Large Mid Cap Index", "I:NQMY60LMN": "Nasdaq Malaysia Energy Large Mid Cap NTR Index", "I:NQMY60LMT": "Nasdaq Malaysia Energy Large Mid Cap TR Index", "I:NQMY60N": "Nasdaq Malaysia Energy NTR Index", "I:NQMY60T": "Nasdaq Malaysia Energy TR Index", "I:NQMY65": "NASDAQ Malaysia Utilities Index", "I:NQMY65LM": "Nasdaq Malaysia Utilities Large Mid Cap Index", "I:NQMY65LMN": "NASDAQ Malaysia Utilities Large Mid Cap NTR Index", "I:NQMY65LMT": "NASDAQ Malaysia Utilities Large Mid Cap TR Index", "I:NQMY65N": "NASDAQ Malaysia Utilities NTR Index", "I:NQMY65T": "NASDAQ Malaysia Utilities TR Index", "I:NQMYLC": "NASDAQ Malaysia Large Cap Index", "I:NQMYLCN": "NASDAQ Malaysia Large Cap NTR Index", "I:NQMYLCT": "NASDAQ Malaysia Large Cap TR Index", "I:NQMYLM": "NASDAQ Malaysia Large Mid Cap Index", "I:NQMYLMN": "NASDAQ Malaysia Large Mid Cap NTR Index", "I:NQMYLMT": "NASDAQ Malaysia Large Mid Cap TR Index", "I:NQMYMC": "NASDAQ Malaysia Mid Cap Index", "I:NQMYMCN": "NASDAQ Malaysia Mid Cap NTR Index", "I:NQMYMCT": "NASDAQ Malaysia Mid Cap TR Index", "I:NQMYN": "NASDAQ Malaysia NTR Index", "I:NQMYSC": "NASDAQ Malaysia Small Cap Index", "I:NQMYSCN": "NASDAQ Malaysia Small Cap NTR Index", "I:NQMYSCT": "NASDAQ Malaysia Small Cap TR Index", "I:NQMYT": "NASDAQ Malaysia TR Index", "I:NQNA": "NASDAQ N America Index", "I:NQNA10": "Nasdaq North America Technology Index", "I:NQNA10LM": "Nasdaq N America Technology Large Mid Cap Index", "I:NQNA10LMN": "Nasdaq N America Technology Large Mid Cap NTR Index", "I:NQNA10LMT": "Nasdaq N America Technology Large Mid Cap TR Index", "I:NQNA10N": "Nasdaq North America Technology NTR Index", "I:NQNA10T": "Nasdaq North America Technology TR Index", "I:NQNA15": "Nasdaq North America Telecommunications Index", "I:NQNA15LM": "Nasdaq N America Telecommunications Large Mid Cap Index", "I:NQNA15LMN": "Nasdaq N America Telecommunications Large Mid Cap NTR Index", "I:NQNA15LMT": "Nasdaq N America Telecommunications Large Mid Cap TR Index", "I:NQNA15N": "Nasdaq North America Telecommunications NTR Index", "I:NQNA15T": "Nasdaq North America Telecommunications TR Index", "I:NQNA20": "Nasdaq North America Health Care Index", "I:NQNA20LM": "Nasdaq N America Health Care Large Mid Cap Index", "I:NQNA20LMN": "Nasdaq N America Health Care Large Mid Cap NTR Index", "I:NQNA20LMT": "Nasdaq N America Health Care Large Mid Cap TR Index", "I:NQNA20N": "Nasdaq North America Health Care NTR Index", "I:NQNA20T": "Nasdaq North America Health Care TR Index", "I:NQNA30": "Nasdaq North America Financials Index", "I:NQNA3010": "Nasdaq North America Banks Index", "I:NQNA3010LM": "Nasdaq N America Banks Large Mid Cap Index", "I:NQNA3010LMN": "NASDAQ N America Banks Large Mid Cap NTR Index", "I:NQNA3010LMT": "NASDAQ N America Banks Large Mid Cap TR Index", "I:NQNA3010N": "Nasdaq North America Banks NTR Index", "I:NQNA3010T": "Nasdaq North America Banks TR Index", "I:NQNA3020": "Nasdaq North America Financial Services Index", "I:NQNA3020LM": "Nasdaq N America Financial Services Large Mid Cap Index", "I:NQNA3020LMN": "Nasdaq N America Financial Services Large Mid Cap NTR Index", "I:NQNA3020LMT": "Nasdaq N America Financial Services Large Mid Cap TR Index", "I:NQNA3020N": "Nasdaq North America Financial Services NTR Index", "I:NQNA3020T": "Nasdaq North America Financial Services TR Index", "I:NQNA3030": "Nasdaq North America Insurance Index", "I:NQNA3030LM": "Nasdaq N America Insurance Large Mid Cap Index", "I:NQNA3030LMN": "Nasdaq N America Insurance Large Mid Cap NTR Index", "I:NQNA3030LMT": "Nasdaq N America Insurance Large Mid Cap TR Index", "I:NQNA3030N": "Nasdaq North America Insurance NTR Index", "I:NQNA3030T": "Nasdaq North America Insurance TR Index", "I:NQNA30LM": "Nasdaq N America Financials Large Mid Cap Index", "I:NQNA30LMN": "Nasdaq N America Financials Large Mid Cap NTR Index", "I:NQNA30LMT": "Nasdaq N America Financials Large Mid Cap TR Index", "I:NQNA30N": "Nasdaq North America Financials NTR Index", "I:NQNA30T": "Nasdaq North America Financials TR Index", "I:NQNA35": "Nasdaq North America Real Estate Index", "I:NQNA35LM": "Nasdaq N America Real Estate Large Mid Cap Index", "I:NQNA35LMN": "Nasdaq N America Real Estate Large Mid Cap NTR Index", "I:NQNA35LMT": "Nasdaq N America Real Estate Large Mid Cap TR Index", "I:NQNA35N": "Nasdaq North America Real Estate NTR Index", "I:NQNA35T": "Nasdaq North America Real Estate TR Index", "I:NQNA40": "Nasdaq North America Consumer Discretionary Index", "I:NQNA4010": "Nasdaq North America Automobiles and Parts Index", "I:NQNA4010LM": "Nasdaq N America Automobiles and Parts Large Mid Cap Index", "I:NQNA4010LMN": "Nasdaq N America Automobiles and Parts Large Mid Cap NTR Index", "I:NQNA4010LMT": "Nasdaq N America Automobiles and Parts Large Mid Cap TR Index", "I:NQNA4010N": "Nasdaq North America Automobiles and Parts NTR Index", "I:NQNA4010T": "Nasdaq North America Automobiles and Parts TR Index", "I:NQNA4020": "Nasdaq North America Consumer Products and Services Index", "I:NQNA4020LM": "Nasdaq N America Consumer Products and Services Large Mid Cap Index", "I:NQNA4020LMN": "Nasdaq N America Consumer Products and Services Large Mid Cap NTR Index", "I:NQNA4020LMT": "Nasdaq N America Consumer Products and Services Large Mid Cap TR Index", "I:NQNA4020N": "Nasdaq North America Consumer Products and Services NTR Index", "I:NQNA4020T": "Nasdaq North America Consumer Products and Services TR Index", "I:NQNA4030": "Nasdaq North America Media Index", "I:NQNA4030LM": "Nasdaq N America Media Large Mid Cap Index", "I:NQNA4030LMN": "NASDAQ N America Media Large Mid Cap NTR Index", "I:NQNA4030LMT": "NASDAQ N America Media Large Mid Cap TR Index", "I:NQNA4030N": "Nasdaq North America Media NTR Index", "I:NQNA4030T": "Nasdaq North America Media TR Index", "I:NQNA4040": "Nasdaq North America Retail Index", "I:NQNA4040LM": "Nasdaq N America Retail Large Mid Cap Index", "I:NQNA4040LMN": "NASDAQ N America Retail Large Mid Cap NTR Index", "I:NQNA4040LMT": "NASDAQ N America Retail Large Mid Cap TR Index", "I:NQNA4040N": "Nasdaq North America Retail NTR Index", "I:NQNA4040T": "Nasdaq North America Retail TR Index", "I:NQNA4050": "Nasdaq North America Travel and Leisure Index", "I:NQNA4050LM": "Nasdaq N America Travel and Leisure Large Mid Cap Index", "I:NQNA4050LMN": "Nasdaq N America Travel and Leisure Large Mid Cap NTR Index", "I:NQNA4050LMT": "Nasdaq N America Travel and Leisure Large Mid Cap TR Index", "I:NQNA4050N": "Nasdaq North America Travel and Leisure NTR Index", "I:NQNA4050T": "Nasdaq North America Travel and Leisure TR Index", "I:NQNA40LM": "Nasdaq North America Consumer Discretionary Large Mid Cap Index", "I:NQNA40LMN": "Nasdaq North America Consumer Discretionary Large Mid Cap NTR Index", "I:NQNA40LMT": "Nasdaq North America Consumer Discretionary Large Mid Cap TR Index", "I:NQNA40N": "Nasdaq North America Consumer Discretionary NTR Index", "I:NQNA40T": "Nasdaq North America Consumer Discretionary TR Index", "I:NQNA45": "Nasdaq North America Consumer Staples Index", "I:NQNA4510": "Nasdaq North America Food, Beverage and Tobacco Index", "I:NQNA4510LM": "Nasdaq North America Food, Beverage and Tobacco Large Mid Cap Index", "I:NQNA4510LMN": "Nasdaq North America Food, Beverage and Tobacco Large Mid Cap NTR Index", "I:NQNA4510LMT": "Nasdaq North America Food, Beverage and Tobacco Large Mid Cap TR Index", "I:NQNA4510N": "Nasdaq North America Food, Beverage and Tobacco NTR Index", "I:NQNA4510T": "Nasdaq North America Food, Beverage and Tobacco TR Index", "I:NQNA4520": "Nasdaq North America Personal Care, Drug and Grocery Stores Index", "I:NQNA4520LM": "Nasdaq North America Personal Care, Drug and Grocery Stores Large Mid Cap Index", "I:NQNA4520LMN": "Nasdaq North America Personal Care, Drug and Grocery Stores Large Mid Cap NTR Index", "I:NQNA4520LMT": "Nasdaq North America Personal Care, Drug and Grocery Stores Large Mid Cap TR Index", "I:NQNA4520N": "Nasdaq North America Personal Care, Drug and Grocery Stores NTR Index", "I:NQNA4520T": "Nasdaq North America Personal Care, Drug and Grocery Stores TR Index", "I:NQNA45LM": "Nasdaq North America Consumer Staples Large Mid Cap Index", "I:NQNA45LMN": "Nasdaq North America Consumer Staples Large Mid Cap NTR Index", "I:NQNA45LMT": "Nasdaq North America Consumer Staples Large Mid Cap TR Index", "I:NQNA45N": "Nasdaq North America Consumer Staples NTR Index", "I:NQNA45T": "Nasdaq North America Consumer Staples TR Index", "I:NQNA50": "Nasdaq North America Industrials Index", "I:NQNA5010": "Nasdaq North America Construction and Materials Index", "I:NQNA5010LM": "Nasdaq North America Construction and Materials Large Mid Cap Index", "I:NQNA5010LMN": "Nasdaq North America Construction and Materials Large Mid Cap NTR Index", "I:NQNA5010LMT": "Nasdaq North America Construction and Materials Large Mid Cap TR Index", "I:NQNA5010N": "Nasdaq North America Construction and Materials NTR Index", "I:NQNA5010T": "Nasdaq North America Construction and Materials TR Index", "I:NQNA5020": "Nasdaq North America Industrial Goods and Services Index", "I:NQNA5020LM": "Nasdaq N America Industrial Goods and Services Large Mid Cap Index", "I:NQNA5020LMN": "Nasdaq N America Industrial Goods and Services Large Mid Cap NTR Index", "I:NQNA5020LMT": "Nasdaq N America Industrial Goods and Services Large Mid Cap TR Index", "I:NQNA5020N": "Nasdaq North America Industrial Goods and Services NTR Index", "I:NQNA5020T": "Nasdaq North America Industrial Goods and Services TR Index", "I:NQNA50LM": "Nasdaq N America Industrials Large Mid Cap Index", "I:NQNA50LMN": "Nasdaq N America Industrials Large Mid Cap NTR Index", "I:NQNA50LMT": "Nasdaq N America Industrials Large Mid Cap TR Index", "I:NQNA50N": "Nasdaq North America Industrials NTR Index", "I:NQNA50T": "Nasdaq North America Industrials TR Index", "I:NQNA55": "Nasdaq North America Basic Materials Index", "I:NQNA5510": "Nasdaq North America Basic Resources Index", "I:NQNA5510LM": "Nasdaq North America Basic Resources Large Mid Cap Index", "I:NQNA5510LMN": "Nasdaq North America Basic Resources Large Mid Cap NTR Index", "I:NQNA5510LMT": "Nasdaq North America Basic Resources Large Mid Cap TR Index", "I:NQNA5510N": "Nasdaq North America Basic Resources NTR Index", "I:NQNA5510T": "Nasdaq North America Basic Resources TR Index", "I:NQNA5520": "Nasdaq North America Chemicals Index", "I:NQNA5520LM": "Nasdaq North America Chemicals Large Mid Cap Index", "I:NQNA5520LMN": "Nasdaq North America Chemicals Large Mid Cap NTR Index", "I:NQNA5520LMT": "Nasdaq North America Chemicals Large Mid Cap TR Index", "I:NQNA5520N": "Nasdaq North America Chemicals NTR Index", "I:NQNA5520T": "Nasdaq North America Chemicals TR Index", "I:NQNA55LM": "Nasdaq N America Basic Materials Large Mid Cap Index", "I:NQNA55LMN": "Nasdaq N America Basic Materials Large Mid Cap NTR Index", "I:NQNA55LMT": "Nasdaq N America Basic Materials Large Mid Cap TR Index", "I:NQNA55N": "Nasdaq North America Basic Materials NTR Index", "I:NQNA55T": "Nasdaq North America Basic Materials TR Index", "I:NQNA60": "Nasdaq North America Energy Index", "I:NQNA60LM": "Nasdaq N America Energy Large Mid Cap Index", "I:NQNA60LMN": "Nasdaq N America Energy Large Mid Cap NTR Index", "I:NQNA60LMT": "Nasdaq N America Energy Large Mid Cap TR Index", "I:NQNA60N": "Nasdaq North America Energy NTR Index", "I:NQNA60T": "Nasdaq North America Energy TR Index", "I:NQNA65": "Nasdaq North America Utilities Index", "I:NQNA65LM": "Nasdaq N America Utilities Large Mid Cap Index", "I:NQNA65LMN": "NASDAQ N America Utilities Large Mid Cap NTR Index", "I:NQNA65LMT": "NASDAQ N America Utilities Large Mid Cap TR Index", "I:NQNA65N": "Nasdaq North America Utilities NTR Index", "I:NQNA65T": "Nasdaq North America Utilities TR Index", "I:NQNAAT": "Nasdaq North America Air Transportation Index", "I:NQNAATT": "Nasdaq North America Air Transportation TR Index", "I:NQNALC": "NASDAQ N America Large Cap Index", "I:NQNALCN": "NASDAQ N America Large Cap NTR Index", "I:NQNALCT": "NASDAQ N America Large Cap TR Index", "I:NQNALM": "NASDAQ N America Large Mid Cap Index", "I:NQNALMN": "NASDAQ N America Large Mid Cap NTR Index", "I:NQNALMT": "NASDAQ N America Large Mid Cap TR Index", "I:NQNAMC": "NASDAQ N America Mid Cap Index", "I:NQNAMCN": "NASDAQ N America Mid Cap NTR Index", "I:NQNAMCT": "NASDAQ N America Mid Cap TR Index", "I:NQNAN": "NASDAQ N America NTR Index", "I:NQNASC": "NASDAQ N America Small Cap Index", "I:NQNASCN": "NASDAQ N America Small Cap NTR Index", "I:NQNASCT": "NASDAQ N America Small Cap TR Index", "I:NQNAT": "NASDAQ N America TR Index", "I:NQNDDIP": "Nasdaq Nordea SmartBeta Dividend Price Index", "I:NQNDDIT": "Nasdaq Nordea SmartBeta Dividend TR Index", "I:NQNDDMBEURON": "Nasdaq Nordea SmartBeta Dividend Momentum Beta Eur", "I:NQNDDMBEUROP": "Nasdaq Nordea SmartBeta Dividend Momentum Beta Eur", "I:NQNDDMBEUROT": "Nasdaq Nordea SmartBeta Dividend Momentum Beta Eur", "I:NQNDDMP": "NASDAQ Nordea SmartBeta Dividend Momentum Swe PR", "I:NQNDDMT": "NASDAQ Nordea SmartBeta Dividend Momentum Swe TR", "I:NQNDDVP": "NASDAQ Nordea SmartBeta Dividend Volatility Swe PR", "I:NQNDDVT": "NASDAQ Nordea SmartBeta Dividend Volatility Swe TR", "I:NQNDMFEEURON": "Nasdaq Nordea SmartBeta Multifactor ESG Eurozone N", "I:NQNDMFEEUROP": "Nasdaq Nordea SmartBeta Multifactor ESG Eurozone P", "I:NQNDMFEEUROT": "Nasdaq Nordea SmartBeta Multifactor ESG Eurozone T", "I:NQNDMOP": "Nasdaq Nordea SmartBeta Momentum PR Index", "I:NQNDMOT": "Nasdaq Nordea SmartBeta Momentum TR Index", "I:NQNDMVEURON": "Nasdaq Nordea SmartBeta Momentum Volatility Eurozo", "I:NQNDMVEUROP": "Nasdaq Nordea SmartBeta Momentum Volatility Eurozo", "I:NQNDMVEUROT": "Nasdaq Nordea SmartBeta Momentum Volatility Eurozo", "I:NQNDMVP": "NASDAQ Nordea SmartBeta Momentum Volatility Swe PR", "I:NQNDMVT": "NASDAQ Nordea SmartBeta Momentum Volatility Swe TR", "I:NQNDVOP": "Nasdaq Nordea SmartBeta Volatility PR Inde", "I:NQNDVOT": "Nasdaq Nordea SmartBeta Volatility TR Index", "I:NQNL": "NASDAQ Netherlands Index", "I:NQNL10": "Nasdaq Netherlands Technology Index", "I:NQNL10LM": "Nasdaq Netherlands Technology Large Mid Cap Index", "I:NQNL10LMN": "Nasdaq Netherlands Technology Large Mid Cap NTR Index", "I:NQNL10LMT": "Nasdaq Netherlands Technology Large Mid Cap TR Index", "I:NQNL10N": "Nasdaq Netherlands Technology NTR Index", "I:NQNL10T": "Nasdaq Netherlands Technology TR Index", "I:NQNL30": "NASDAQ Netherlands Financials Index", "I:NQNL30LM": "Nasdaq Netherlands Financials Large Mid Cap Index", "I:NQNL30LMN": "Nasdaq Netherlands Financials Large Mid Cap NTR Index", "I:NQNL30LMT": "Nasdaq Netherlands Financials Large Mid Cap TR Index", "I:NQNL30N": "NASDAQ Netherlands Financials NTR Index", "I:NQNL30T": "NASDAQ Netherlands Financials TR Index", "I:NQNL35": "Nasdaq Netherlands Real Estate Index", "I:NQNL35N": "Nasdaq Netherlands Real Estate NTR Index", "I:NQNL35T": "Nasdaq Netherlands Real Estate TR Index", "I:NQNL40": "Nasdaq Netherlands Consumer Discretionary Index", "I:NQNL40N": "Nasdaq Netherlands Consumer Discretionary NTR Index", "I:NQNL40T": "Nasdaq Netherlands Consumer Discretionary TR Index", "I:NQNL45": "Nasdaq Netherlands Consumer Staples Index", "I:NQNL45N": "Nasdaq Netherlands Consumer Staples NTR Index", "I:NQNL45T": "Nasdaq Netherlands Consumer Staples TR Index", "I:NQNL50": "Nasdaq Netherlands Industrials Index", "I:NQNL50LM": "Nasdaq Netherlands Industrials Large Mid Cap Index", "I:NQNL50LMN": "Nasdaq Netherlands Industrials Large Mid Cap NTR Index", "I:NQNL50LMT": "Nasdaq Netherlands Industrials Large Mid Cap TR Index",
"I:NQNL50N": "Nasdaq Netherlands Industrials NTR Index", "I:NQNL50T": "Nasdaq Netherlands Industrials TR Index", "I:NQNL55": "Nasdaq Netherlands Basic Materials Index", "I:NQNL55LM": "Nasdaq Netherlands Basic Materials Large Mid Cap Index", "I:NQNL55LMN": "Nasdaq Netherlands Basic Materials Large Mid Cap NTR Index", "I:NQNL55LMT": "Nasdaq Netherlands Basic Materials Large Mid Cap TR Index", "I:NQNL55N": "Nasdaq Netherlands Basic Materials NTR Index", "I:NQNL55T": "Nasdaq Netherlands Basic Materials TR Index", "I:NQNLLC": "NASDAQ Netherlands Large Cap Index", "I:NQNLLCN": "NASDAQ Netherlands Large Cap NTR Index", "I:NQNLLCT": "NASDAQ Netherlands Large Cap TR Index", "I:NQNLLM": "NASDAQ Netherlands Large Mid Cap Index", "I:NQNLLMN": "NASDAQ Netherlands Large Mid Cap NTR Index", "I:NQNLLMT": "NASDAQ Netherlands Large Mid Cap TR Index", "I:NQNLMC": "NASDAQ Netherlands Mid Cap Index", "I:NQNLMCN": "NASDAQ Netherlands Mid Cap NTR Index", "I:NQNLMCT": "NASDAQ Netherlands Mid Cap TR Index", "I:NQNLN": "NASDAQ Netherlands NTR Index", "I:NQNLSC": "NASDAQ Netherlands Small Cap Index", "I:NQNLSCN": "NASDAQ Netherlands Small Cap NTR Index", "I:NQNLSCT": "NASDAQ Netherlands Small Cap TR Index", "I:NQNLT": "NASDAQ Netherlands TR Index", "I:NQNO": "NASDAQ Norway Index", "I:NQNO10": "Nasdaq Norway Technology Index", "I:NQNO10N": "Nasdaq Norway Technology NTR Index", "I:NQNO10T": "Nasdaq Norway Technology TR Index", "I:NQNO30": "NASDAQ Norway Financials Index", "I:NQNO30N": "NASDAQ Norway Financials NTR Index", "I:NQNO30T": "NASDAQ Norway Financials TR Index", "I:NQNO40": "Nasdaq Norway Consumer Discretionary Index", "I:NQNO40N": "Nasdaq Norway Consumer Discretionary NTR Index", "I:NQNO40T": "Nasdaq Norway Consumer Discretionary TR Index", "I:NQNO45": "Nasdaq Norway Consumer Staples Index", "I:NQNO45LM": "Nasdaq Norway Consumer Staples Large Mid Cap Index", "I:NQNO45LMN": "Nasdaq Norway Consumer Staples Large Mid Cap NTR Index", "I:NQNO45LMT": "Nasdaq Norway Consumer Staples Large Mid Cap TR Index", "I:NQNO45N": "Nasdaq Norway Consumer Staples NTR Index", "I:NQNO45T": "Nasdaq Norway Consumer Staples TR Index", "I:NQNO50": "Nasdaq Norway Industrials Index", "I:NQNO50N": "Nasdaq Norway Industrials NTR Index", "I:NQNO50T": "Nasdaq Norway Industrials TR Index", "I:NQNO55": "Nasdaq Norway Basic Materials Index", "I:NQNO55N": "Nasdaq Norway Basic Materials NTR Index", "I:NQNO55T": "Nasdaq Norway Basic Materials TR Index", "I:NQNO60": "Nasdaq Norway Energy Index", "I:NQNO60LM": "Nasdaq Norway Energy Large Mid Cap Index", "I:NQNO60LMN": "Nasdaq Norway Energy Large Mid Cap NTR Index", "I:NQNO60LMT": "Nasdaq Norway Energy Large Mid Cap TR Index", "I:NQNO60N": "Nasdaq Norway Energy NTR Index", "I:NQNO60T": "Nasdaq Norway Energy TR Index", "I:NQNOLC": "NASDAQ Norway Large Cap Index", "I:NQNOLCN": "NASDAQ Norway Large Cap NTR Index", "I:NQNOLCT": "NASDAQ Norway Large Cap TR Index", "I:NQNOLM": "NASDAQ Norway Large Mid Cap Index", "I:NQNOLMN": "NASDAQ Norway Large Mid Cap NTR Index", "I:NQNOLMT": "NASDAQ Norway Large Mid Cap TR Index", "I:NQNOMC": "NASDAQ Norway Mid Cap Index", "I:NQNOMCN": "NASDAQ Norway Mid Cap NTR Index", "I:NQNOMCT": "NASDAQ Norway Mid Cap TR Index", "I:NQNON": "NASDAQ Norway NTR Index", "I:NQNOSC": "NASDAQ Norway Small Cap Index", "I:NQNOSCN": "NASDAQ Norway Small Cap NTR Index", "I:NQNOSCT": "NASDAQ Norway Small Cap TR Index", "I:NQNOT": "NASDAQ Norway TR Index", "I:NQNZ": "NASDAQ New Zealand Index", "I:NQNZ20": "NASDAQ New Zealand Health Care Index", "I:NQNZ20N": "NASDAQ New Zealand Health Care NTR Index", "I:NQNZ20T": "NASDAQ New Zealand Health Care TR Index", "I:NQNZ30": "NASDAQ New Zealand Financials Index", "I:NQNZ30N": "NASDAQ New Zealand Financials NTR Index", "I:NQNZ30T": "NASDAQ New Zealand Financials TR Index", "I:NQNZ35": "Nasdaq New Zealand Real Estate Index", "I:NQNZ35N": "Nasdaq New Zealand Real Estate NTR Index", "I:NQNZ35T": "Nasdaq New Zealand Real Estate TR Index", "I:NQNZ50": "Nasdaq New Zealand Industrials Index", "I:NQNZ50N": "Nasdaq New Zealand Industrials NTR Index", "I:NQNZ50T": "Nasdaq New Zealand Industrials TR Index", "I:NQNZ65": "NASDAQ New Zealand Utilities Index", "I:NQNZ65N": "NASDAQ New Zealand Utilities NTR Index", "I:NQNZ65T": "NASDAQ New Zealand Utilities TR Index", "I:NQNZLM": "NASDAQ New Zealand Large Mid Cap Index", "I:NQNZLMN": "NASDAQ New Zealand Large Mid Cap NTR Index", "I:NQNZLMT": "NASDAQ New Zealand Large Mid Cap TR Index", "I:NQNZMC": "NASDAQ New Zealand Mid Cap Index", "I:NQNZMCN": "NASDAQ New Zealand Mid Cap NTR Index", "I:NQNZMCT": "NASDAQ New Zealand Mid Cap TR Index", "I:NQNZN": "NASDAQ New Zealand NTR Index", "I:NQNZSC": "NASDAQ New Zealand Small Cap Index", "I:NQNZSCN": "NASDAQ New Zealand Small Cap NTR Index", "I:NQNZSCT": "NASDAQ New Zealand Small Cap TR Index", "I:NQNZT": "NASDAQ New Zealand TR Index", "I:NQPE": "NASDAQ Peru Index", "I:NQPELM": "NASDAQ Peru Large Mid Cap Index", "I:NQPELMN": "NASDAQ Peru Large Mid Cap NTR Index", "I:NQPELMT": "NASDAQ Peru Large Mid Cap TR Index", "I:NQPEMC": "NASDAQ Peru Mid Cap Index", "I:NQPEMCN": "NASDAQ Peru Mid Cap NTR Index", "I:NQPEMCT": "NASDAQ Peru Mid Cap TR Index", "I:NQPEN": "NASDAQ Peru NTR Index", "I:NQPESC": "NASDAQ Peru Small Cap Index", "I:NQPESCN": "NASDAQ Peru Small Cap NTR Index", "I:NQPESCT": "NASDAQ Peru Small Cap TR Index", "I:NQPET": "NASDAQ Peru TR Index", "I:NQPFDUS": "NASDAQ US Preferred Security Index", "I:NQPFDUSN": "Nasdaq US Preferred Security NTR Index", "I:NQPFDUSX": "NASDAQ US Preferred Security Total Return Index", "I:NQPH": "NASDAQ Philippines Index", "I:NQPH30": "NASDAQ Philippines Financials Index", "I:NQPH30LM": "Nasdaq Philippines Financials Large Mid Cap Index", "I:NQPH30LMN": "Nasdaq Philippines Financials Large Mid Cap NTR Index", "I:NQPH30LMT": "Nasdaq Philippines Financials Large Mid Cap TR Index", "I:NQPH30N": "NASDAQ Philippines Financials NTR Index", "I:NQPH30T": "NASDAQ Philippines Financials TR Index", "I:NQPH35": "Nasdaq Philippines Real Estate Index", "I:NQPH35N": "Nasdaq Philippines Real Estate NTR Index", "I:NQPH35T": "Nasdaq Philippines Real Estate TR Index", "I:NQPH40": "Nasdaq Philippines Consumer Discretionary Index", "I:NQPH40N": "Nasdaq Philippines Consumer Discretionary NTR Index", "I:NQPH40T": "Nasdaq Philippines Consumer Discretionary TR Index", "I:NQPH50": "Nasdaq Philippines Industrials Index", "I:NQPH50N": "Nasdaq Philippines Industrials NTR Index", "I:NQPH50T": "Nasdaq Philippines Industrials TR Index", "I:NQPH55": "Nasdaq Philippines Basic Materials Index", "I:NQPH55N": "Nasdaq Philippines Basic Materials NTR Index", "I:NQPH55T": "Nasdaq Philippines Basic Materials TR Index", "I:NQPH65": "NASDAQ Philippines Utilities Index", "I:NQPH65LM": "Nasdaq Philippines Utilities Large Mid Cap Index", "I:NQPH65LMN": "Nasdaq Philippines Utilities Large Mid Cap NTR Index", "I:NQPH65LMT": "Nasdaq Philippines Utilities Large Mid Cap TR Index", "I:NQPH65N": "NASDAQ Philippines Utilities NTR Index", "I:NQPH65T": "NASDAQ Philippines Utilities TR Index", "I:NQPHLC": "NASDAQ Philippines Large Cap Index", "I:NQPHLCN": "NASDAQ Philippines Large Cap NTR Index", "I:NQPHLCT": "NASDAQ Philippines Large Cap TR Index", "I:NQPHLM": "NASDAQ Philippines Large Mid Cap Index", "I:NQPHLMN": "NASDAQ Philippines Large Mid Cap NTR Index", "I:NQPHLMT": "NASDAQ Philippines Large Mid Cap TR Index", "I:NQPHMC": "NASDAQ Philippines Mid Cap Index", "I:NQPHMCN": "NASDAQ Philippines Mid Cap NTR Index", "I:NQPHMCT": "NASDAQ Philippines Mid Cap TR Index", "I:NQPHN": "NASDAQ Philippines NTR Index", "I:NQPHSC": "NASDAQ Philippines Small Cap Index", "I:NQPHSCN": "NASDAQ Philippines Small Cap NTR Index", "I:NQPHSCT": "NASDAQ Philippines Small Cap TR Index", "I:NQPHT": "NASDAQ Philippines TR Index", "I:NQPL": "NASDAQ Poland Index", "I:NQPL30": "NASDAQ Poland Financials Index", "I:NQPL30LM": "Nasdaq Poland Financials Large Mid Cap Index", "I:NQPL30LMN": "NASDAQ Poland Financials Large Mid Cap NTR Index", "I:NQPL30LMT": "NASDAQ Poland Financials Large Mid Cap TR Index", "I:NQPL30N": "NASDAQ Poland Financials NTR Index", "I:NQPL30T": "NASDAQ Poland Financials TR Index", "I:NQPL40": "Nasdaq Poland Consumer Discretionary Index", "I:NQPL40N": "Nasdaq Poland Consumer Discretionary NTR Index", "I:NQPL40T": "Nasdaq Poland Consumer Discretionary TR Index", "I:NQPL50": "Nasdaq Poland Industrials Index", "I:NQPL50N": "Nasdaq Poland Industrials NTR Index", "I:NQPL50T": "Nasdaq Poland Industrials TR Index", "I:NQPL55": "Nasdaq Poland Basic Materials Index", "I:NQPL55N": "Nasdaq Poland Basic Materials NTR Index", "I:NQPL55T": "Nasdaq Poland Basic Materials TR Index", "I:NQPLLC": "NASDAQ Poland Large Cap Index", "I:NQPLLCN": "NASDAQ Poland Large Cap NTR Index", "I:NQPLLCT": "NASDAQ Poland Large Cap TR Index", "I:NQPLLM": "NASDAQ Poland Large Mid Cap Index", "I:NQPLLMN": "NASDAQ Poland Large Mid Cap NTR Index", "I:NQPLLMT": "NASDAQ Poland Large Mid Cap TR Index", "I:NQPLMC": "NASDAQ Poland Mid Cap Index", "I:NQPLMCN": "NASDAQ Poland Mid Cap NTR Index", "I:NQPLMCT": "NASDAQ Poland Mid Cap TR Index", "I:NQPLN": "NASDAQ Poland NTR Index", "I:NQPLSC": "NASDAQ Poland Small Cap Index", "I:NQPLSCN": "NASDAQ Poland Small Cap NTR Index", "I:NQPLSCT": "NASDAQ Poland Small Cap TR Index", "I:NQPLT": "NASDAQ Poland TR Index", "I:NQPRCE": "Nasdaq US Price Setters Index", "I:NQPRCEN": "Nasdaq US Price Setters Net Total Return Index", "I:NQPRCET": "Nasdaq US Price Setters Total Return Index", "I:NQPROP": "Nasdaq Catella Sweden Property Index", "I:NQPROPN": "Nasdaq Catella Sweden Property Net Total Return Index", "I:NQPROPT": "Nasdaq Catella Sweden Property Total Return Index", "I:NQPT": "NASDAQ Portugal Index", "I:NQPTLM": "NASDAQ Portugal Large Mid Cap Index", "I:NQPTLMN": "NASDAQ Portugal Large Mid Cap NTR Index", "I:NQPTLMT": "NASDAQ Portugal Large Mid Cap TR Index", "I:NQPTN": "NASDAQ Portugal NTR Index", "I:NQPTSC": "NASDAQ Portugal Small Cap Index", "I:NQPTSCN": "NASDAQ Portugal Small Cap NTR Index", "I:NQPTSCT": "NASDAQ Portugal Small Cap TR Index", "I:NQPTT": "NASDAQ Portugal TR Index", "I:NQRMII": "Nasdaq-100 Monthly Net Credit Collar 95-100 Index", "I:NQROBO": "Nasdaq CTA Artificial Intelligence & Robotics", "I:NQROBON": "Nasdaq CTA Artificial Intelligence & Robotics NTR", "I:NQROBOT": "Nasdaq CTA Artificial Intelligence & Robotics TR", "I:NQROBOUS": "Nasdaq CTA US AI & Robotics", "I:NQROBOUSN": "Nasdaq CTA US AI & Robotics NTR", "I:NQROBOUST": "Nasdaq CTA US AI & Robotics TR", "I:NQRSKDM": "Nasdaq Riskalyze Developed Markets Index", "I:NQRSKDMN": "Nasdaq Riskalyze Developed Markets NTR Index", "I:NQRSKDMT": "Nasdaq Riskalyze Developed Markets TR Index", "I:NQRSKEM": "Nasdaq Riskalyze Emerging Markets Index", "I:NQRSKEMN": "Nasdaq Riskalyze Emerging Markets NTR Index", "I:NQRSKEMT": "Nasdaq Riskalyze Emerging Markets TR Index", "I:NQRSKUSL": "Nasdaq Riskalyze US Large Cap Index", "I:NQRSKUSLD": "Nasdaq Riskalyze US Large Cap Select Dividend", "I:NQRSKUSLDN": "Nasdaq Riskalyze US Large Cap Select Dividend NTR", "I:NQRSKUSLDT": "Nasdaq Riskalyze US Large Cap Select Dividend TR", "I:NQRSKUSLN": "Nasdaq Riskalyze US Large Cap NTR Index", "I:NQRSKUSLT": "Nasdaq Riskalyze US Large Cap TR Index", "I:NQRSKUSM": "Nasdaq Riskalyze US Mid Cap Index", "I:NQRSKUSMN": "Nasdaq Riskalyze US Mid Cap NTR Index", "I:NQRSKUSMT": "Nasdaq Riskalyze US Mid Cap TR Index", "I:NQRSKUSS": "Nasdaq Riskalyze US Small Cap Index", "I:NQRSKUSSN": "Nasdaq Riskalyze US Small Cap NTR Index", "I:NQRSKUSST": "Nasdaq Riskalyze US Small Cap TR Index", "I:NQSDDI": "Nasdaq Short Duration Diversified Income Index", "I:NQSDDIT": "Nasdaq Short Duration Diversified Income TR Index", "I:NQSE": "NASDAQ Sweden Index", "I:NQSE15": "Nasdaq Sweden Telecommunications Index", "I:NQSE15N": "Nasdaq Sweden Telecommunications NTR Index", "I:NQSE15T": "Nasdaq Sweden Telecommunications TR Index", "I:NQSE20": "NASDAQ Sweden Health Care Index", "I:NQSE20N": "NASDAQ Sweden Health Care NTR Index", "I:NQSE20T": "NASDAQ Sweden Health Care TR Index", "I:NQSE30": "NASDAQ Sweden Financials Index", "I:NQSE30LM": "Nasdaq Sweden Financials Large Mid Cap Index", "I:NQSE30LMN": "NASDAQ Sweden Financials Large Mid Cap NTR Index", "I:NQSE30LMT": "NASDAQ Sweden Financials Large Mid Cap TR Index", "I:NQSE30N": "NASDAQ Sweden Financials NTR Index", "I:NQSE30T": "NASDAQ Sweden Financials TR Index", "I:NQSE35": "Nasdaq Sweden Real Estate Index", "I:NQSE35LM": "Nasdaq Sweden Real Estate Large Mid Cap Index", "I:NQSE35LMN": "Nasdaq Sweden Real Estate Large Mid Cap NTR Index", "I:NQSE35LMT": "Nasdaq Sweden Real Estate Large Mid Cap TR Index", "I:NQSE35N": "Nasdaq Sweden Real Estate NTR Index", "I:NQSE35T": "Nasdaq Sweden Real Estate TR Index", "I:NQSE40": "Nasdaq Sweden Consumer Discretionary Index", "I:NQSE40LM": "Nasdaq Sweden Consumer Discretionary Large Mid Cap Index", "I:NQSE40LMN": "Nasdaq Sweden Consumer Discretionary Large Mid Cap NTR Index", "I:NQSE40LMT": "Nasdaq Sweden Consumer Discretionary Large Mid Cap TR Index", "I:NQSE40N": "Nasdaq Sweden Consumer Discretionary NTR Index", "I:NQSE40T": "Nasdaq Sweden Consumer Discretionary TR Index", "I:NQSE45": "Nasdaq Sweden Consumer Staples Index", "I:NQSE45LM": "Nasdaq Sweden Consumer Staples Large Mid Cap Index", "I:NQSE45LMN": "Nasdaq Sweden Consumer Staples Large Mid Cap NTR Index", "I:NQSE45LMT": "Nasdaq Sweden Consumer Staples Large Mid Cap TR Index", "I:NQSE45N": "Nasdaq Sweden Consumer Staples NTR Index", "I:NQSE45T": "Nasdaq Sweden Consumer Staples TR Index", "I:NQSE50": "Nasdaq Sweden Industrials Index", "I:NQSE50LM": "Nasdaq Sweden Industrials Large Mid Cap Index", "I:NQSE50LMN": "Nasdaq Sweden Industrials Large Mid Cap NTR Index", "I:NQSE50LMT": "Nasdaq Sweden Industrials Large Mid Cap TR Index", "I:NQSE50N": "Nasdaq Sweden Industrials NTR Index", "I:NQSE50T": "Nasdaq Sweden Industrials TR Index", "I:NQSE55": "Nasdaq Sweden Basic Materials Index", "I:NQSE55LM": "Nasdaq Sweden Basic Materials Large Mid Cap Index", "I:NQSE55LMN": "Nasdaq Sweden Basic Materials Large Mid Cap NTR Index", "I:NQSE55LMT": "Nasdaq Sweden Basic Materials Large Mid Cap TR Index", "I:NQSE55N": "Nasdaq Sweden Basic Materials NTR Index", "I:NQSE55T": "Nasdaq Sweden Basic Materials TR Index", "I:NQSELC": "NASDAQ Sweden Large Cap Index", "I:NQSELCN": "NASDAQ Sweden Large Cap NTR Index", "I:NQSELCT": "NASDAQ Sweden Large Cap TR Index", "I:NQSELM": "NASDAQ Sweden Large Mid Cap Index", "I:NQSELMN": "NASDAQ Sweden Large Mid Cap NTR Index", "I:NQSELMT": "NASDAQ Sweden Large Mid Cap TR Index", "I:NQSEMC": "NASDAQ Sweden Mid Cap Index", "I:NQSEMCN": "NASDAQ Sweden Mid Cap NTR Index", "I:NQSEMCT": "NASDAQ Sweden Mid Cap TR Index", "I:NQSEN": "NASDAQ Sweden NTR Index", "I:NQSESC": "NASDAQ Sweden Small Cap Index", "I:NQSESCN": "NASDAQ Sweden Small Cap NTR Index", "I:NQSESCT": "NASDAQ Sweden Small Cap TR Index", "I:NQSET": "NASDAQ Sweden TR Index", "I:NQSG": "NASDAQ Singapore Index", "I:NQSG10": "Nasdaq Singapore Technology Index", "I:NQSG10N": "Nasdaq Singapore Technology NTR Index", "I:NQSG10T": "Nasdaq Singapore Technology TR Index", "I:NQSG20": "NASDAQ Singapore Health Care Index", "I:NQSG20N": "NASDAQ Singapore Health Care NTR Index", "I:NQSG20T": "NASDAQ Singapore Health Care TR Index", "I:NQSG30": "NASDAQ Singapore Financials Index", "I:NQSG30LM": "Nasdaq Singapore Financials Large Mid Cap Index", "I:NQSG30LMN": "Nasdaq Singapore Financials Large Mid Cap NTR Index", "I:NQSG30LMT": "Nasdaq Singapore Financials Large Mid Cap TR Index", "I:NQSG30N": "NASDAQ Singapore Financials NTR Index", "I:NQSG30T": "NASDAQ Singapore Financials TR Index", "I:NQSG35": "Nasdaq Singapore Real Estate Index", "I:NQSG35LM": "Nasdaq Singapore Real Estate Large Mid Cap Index", "I:NQSG35LMN": "Nasdaq Singapore Real Estate Large Mid Cap NTR Index", "I:NQSG35LMT": "Nasdaq Singapore Real Estate Large Mid Cap TR Index", "I:NQSG35N": "Nasdaq Singapore Real Estate NTR Index", "I:NQSG35T": "Nasdaq Singapore Real Estate TR Index", "I:NQSG40": "Nasdaq Singapore Consumer Discretionary Index", "I:NQSG40N": "Nasdaq Singapore Consumer Discretionary NTR Index", "I:NQSG40T": "Nasdaq Singapore Consumer Discretionary TR Index", "I:NQSG45": "Nasdaq Singapore Consumer Staples Index", "I:NQSG45N": "Nasdaq Singapore Consumer Staples NTR Index", "I:NQSG45T": "Nasdaq Singapore Consumer Staples TR Index", "I:NQSG50": "Nasdaq Singapore Industrials Index", "I:NQSG50LM": "Nasdaq Singapore Industrials Large Mid Cap Index", "I:NQSG50LMN": "Nasdaq Singapore Industrials Large Mid Cap NTR Index", "I:NQSG50LMT": "Nasdaq Singapore Industrials Large Mid Cap TR Index", "I:NQSG50N": "Nasdaq Singapore Industrials NTR Index", "I:NQSG50T": "Nasdaq Singapore Industrials TR Index", "I:NQSG55": "Nasdaq Singapore Basic Materials Index", "I:NQSG55N": "Nasdaq Singapore Basic Materials NTR Index", "I:NQSG55T": "Nasdaq Singapore Basic Materials TR Index", "I:NQSG60": "Nasdaq Singapore Energy Index", "I:NQSG60N": "Nasdaq Singapore Energy NTR Index", "I:NQSG60T": "Nasdaq Singapore Energy TR Index", "I:NQSG65": "NASDAQ Singapore Utilities Index", "I:NQSG65N": "NASDAQ Singapore Utilities NTR Index", "I:NQSG65T": "NASDAQ Singapore Utilities TR Index", "I:NQSGLC": "NASDAQ Singapore Large Cap Index", "I:NQSGLCN": "NASDAQ Singapore Large Cap NTR Index", "I:NQSGLCT": "NASDAQ Singapore Large Cap TR Index", "I:NQSGLM": "NASDAQ Singapore Large Mid Cap Index", "I:NQSGLMN": "NASDAQ Singapore Large Mid Cap NTR Index", "I:NQSGLMT": "NASDAQ Singapore Large Mid Cap TR Index", "I:NQSGMC": "NASDAQ Singapore Mid Cap Index", "I:NQSGMCN": "NASDAQ Singapore Mid Cap NTR Index", "I:NQSGMCT": "NASDAQ Singapore Mid Cap TR Index", "I:NQSGN": "NASDAQ Singapore NTR Index", "I:NQSGSC": "NASDAQ Singapore Small Cap Index", "I:NQSGSCN": "NASDAQ Singapore Small Cap NTR Index", "I:NQSGSCT": "NASDAQ Singapore Small Cap TR Index", "I:NQSGT": "NASDAQ Singapore TR Index", "I:NQSSBA": "Nasdaq US Smart Banks Index", "I:NQSSBAN": "Nasdaq US Smart Banks Net Total Return Index", "I:NQSSBAT": "Nasdaq US Smart Banks Total Return Index", "I:NQSSFB": "Nasdaq US Smart Food & Beverage Index", "I:NQSSFBN": "Nasdaq US Smart Food & Beverage Net Total Return I", "I:NQSSFBT": "Nasdaq US Smart Food & Beverage Total Return Index", "I:NQSSOG": "Nasdaq US Smart Oil & Gas  Index", "I:NQSSOGN": "Nasdaq US Smart Oil & Gas  Net Total Return Index", "I:NQSSOGT": "Nasdaq US Smart Oil & Gas  Total Return Index", "I:NQSSPH": "Nasdaq US Smart Pharmaceuticals Index", "I:NQSSPHN": "Nasdaq US Smart Pharmaceuticals Net Total Return I", "I:NQSSPHT": "Nasdaq US Smart Pharmaceuticals Total Return Index", "I:NQSSRE": "Nasdaq US Smart Retail Index", "I:NQSSREN": "Nasdaq US Smart Retail Net Total Return Index", "I:NQSSRET": "Nasdaq US Smart Retail Total Return Index", "I:NQSSSE": "Nasdaq US Smart Semiconductor Index", "I:NQSSSEN": "Nasdaq US Smart Semiconductor Net Total Return Ind", "I:NQSSSET": "Nasdaq US Smart Semiconductor Total Return Index", "I:NQSSTR": "Nasdaq US Smart Transportation Index", "I:NQSSTRN": "Nasdaq US Smart Transportation Net Total Return In", "I:NQSSTRT": "Nasdaq US Smart Transportation Total Return Index", "I:NQSXY": "SmartX NASDAQ Quality Dividend Index", "I:NQSXYN": "SmartX NASDAQ Quality Dividend NTR Index", "I:NQSXYT": "SmartX NASDAQ Quality Dividend TR Index", "I:NQTH": "NASDAQ Thailand Index", "I:NQTH10": "Nasdaq Thailand Technology Index", "I:NQTH10N": "Nasdaq Thailand Technology NTR Index", "I:NQTH10T": "Nasdaq Thailand Technology TR Index", "I:NQTH15": "Nasdaq Thailand Telecommunications Index", "I:NQTH15LM": "Nasdaq Thailand Telecommunications Large Mid Cap Index", "I:NQTH15LMN": "Nasdaq Thailand Telecommunications Large Mid Cap NTR Index", "I:NQTH15LMT": "Nasdaq Thailand Telecommunications Large Mid Cap TR Index", "I:NQTH15N": "Nasdaq Thailand Telecommunications NTR Index", "I:NQTH15T": "Nasdaq Thailand Telecommunications TR Index", "I:NQTH20": "NASDAQ Thailand Health Care Index", "I:NQTH20N": "NASDAQ Thailand Health Care NTR Index", "I:NQTH20T": "NASDAQ Thailand Health Care TR Index", "I:NQTH30": "NASDAQ Thailand Financials Index", "I:NQTH30LM": "Nasdaq Thailand Financials Large Mid Cap Index", "I:NQTH30LMN": "NASDAQ Thailand Financials Large Mid Cap NTR Index", "I:NQTH30LMT": "NASDAQ Thailand Financials Large Mid Cap TR Index", "I:NQTH30N": "NASDAQ Thailand Financials NTR Index", "I:NQTH30T": "NASDAQ Thailand Financials TR Index", "I:NQTH35": "Nasdaq Thailand Real Estate Index", "I:NQTH35N": "Nasdaq Thailand Real Estate NTR Index", "I:NQTH35T": "Nasdaq Thailand Real Estate TR Index", "I:NQTH40": "Nasdaq Thailand Consumer Discretionary Index", "I:NQTH40LM": "Nasdaq Thailand Consumer Discretionary Large Mid Cap Index", "I:NQTH40LMN": "Nasdaq Thailand Consumer Discretionary Large Mid Cap NTR Index", "I:NQTH40LMT": "Nasdaq Thailand Consumer Discretionary Large Mid Cap TR Index", "I:NQTH40N": "Nasdaq Thailand Consumer Discretionary NTR Index", "I:NQTH40T": "Nasdaq Thailand Consumer Discretionary TR Index", "I:NQTH45": "Nasdaq Thailand Consumer Staples Index", "I:NQTH45LM": "Nasdaq Thailand Consumer Staples Large Mid Cap Index", "I:NQTH45LMN": "Nasdaq Thailand Consumer Staples Large Mid Cap NTR Index", "I:NQTH45LMT": "Nasdaq Thailand Consumer Staples Large Mid Cap TR Index", "I:NQTH45N": "Nasdaq Thailand Consumer Staples NTR Index", "I:NQTH45T": "Nasdaq Thailand Consumer Staples TR Index", "I:NQTH50": "Nasdaq Thailand Industrials Index", "I:NQTH50LM": "Nasdaq Thailand Industrials Large Mid Cap Index", "I:NQTH50LMN": "Nasdaq Thailand Industrials Large Mid Cap NTR Index", "I:NQTH50LMT": "Nasdaq Thailand Industrials Large Mid Cap TR Index", "I:NQTH50N": "Nasdaq Thailand Industrials NTR Index", "I:NQTH50T": "Nasdaq Thailand Industrials TR Index", "I:NQTH55": "Nasdaq Thailand Basic Materials Index", "I:NQTH55N": "Nasdaq Thailand Basic Materials NTR Index", "I:NQTH55T": "Nasdaq Thailand Basic Materials TR Index", "I:NQTH60": "Nasdaq Thailand Energy Index", "I:NQTH60LM": "Nasdaq Thailand Energy Large Mid Cap Index", "I:NQTH60LMN": "Nasdaq Thailand Energy Large Mid Cap NTR Index", "I:NQTH60LMT": "Nasdaq Thailand Energy Large Mid Cap TR Index", "I:NQTH60N": "Nasdaq Thailand Energy NTR Index", "I:NQTH60T": "Nasdaq Thailand Energy TR Index", "I:NQTH65": "NASDAQ Thailand Utilities Index", "I:NQTH65LM": "Nasdaq Thailand Utilities Large Mid Cap Index", "I:NQTH65LMN": "NASDAQ Thailand Utilities Large Mid Cap NTR Index", "I:NQTH65LMT": "NASDAQ Thailand Utilities Large Mid Cap TR Index", "I:NQTH65N": "NASDAQ Thailand Utilities NTR Index", "I:NQTH65T": "NASDAQ Thailand Utilities TR Index", "I:NQTHLC": "NASDAQ Thailand Large Cap Index", "I:NQTHLCN": "NASDAQ Thailand Large Cap NTR Index", "I:NQTHLCT": "NASDAQ Thailand Large Cap TR Index", "I:NQTHLM": "NASDAQ Thailand Large Mid Cap Index", "I:NQTHLMN": "NASDAQ Thailand Large Mid Cap NTR Index", "I:NQTHLMT": "NASDAQ Thailand Large Mid Cap TR Index", "I:NQTHMC": "NASDAQ Thailand Mid Cap Index", "I:NQTHMCN": "NASDAQ Thailand Mid Cap NTR Index", "I:NQTHMCT": "NASDAQ Thailand Mid Cap TR Index", "I:NQTHN": "NASDAQ Thailand NTR Index", "I:NQTHSC": "NASDAQ Thailand Small Cap Index", "I:NQTHSCN": "NASDAQ Thailand Small Cap NTR Index", "I:NQTHSCT": "NASDAQ Thailand Small Cap TR Index", "I:NQTHT": "NASDAQ Thailand TR Index", "I:NQTR": "NASDAQ Turkey Index", "I:NQTR30": "NASDAQ Turkey Financials Index", "I:NQTR30LM": "Nasdaq Turkey Financials Large Mid Cap Index", "I:NQTR30LMN": "NASDAQ Turkey Financials Large Mid Cap NTR Index", "I:NQTR30LMT": "NASDAQ Turkey Financials Large Mid Cap TR Index", "I:NQTR30N": "NASDAQ Turkey Financials NTR Index", "I:NQTR30T": "NASDAQ Turkey Financials TR Index", "I:NQTR40": "Nasdaq Turkey Consumer Discretionary Index","I:NQTR40N": "Nasdaq Turkey Consumer Discretionary NTR Index", "I:NQTR40T": "Nasdaq Turkey Consumer Discretionary TR Index", "I:NQTR45": "Nasdaq Turkey Consumer Staples Index", "I:NQTR45N": "Nasdaq Turkey Consumer Staples NTR Index", "I:NQTR45T": "Nasdaq Turkey Consumer Staples TR Index", "I:NQTR50": "Nasdaq Turkey Industrials Index", "I:NQTR50N": "Nasdaq Turkey Industrials NTR Index", "I:NQTR50T": "Nasdaq Turkey Industrials TR Index", "I:NQTR55": "Nasdaq Turkey Basic Materials Index", "I:NQTR55N": "Nasdaq Turkey Basic Materials NTR Index", "I:NQTR55T": "Nasdaq Turkey Basic Materials TR Index", "I:NQTRI": "Nasdaq-100 Quarterly Protective Put 90 Index", "I:NQTRLC": "NASDAQ Turkey Large Cap Index", "I:NQTRLCN": "NASDAQ Turkey Large Cap NTR Index", "I:NQTRLCT": "NASDAQ Turkey Large Cap TR Index", "I:NQTRLM": "NASDAQ Turkey Large Mid Cap Index", "I:NQTRLMN": "NASDAQ Turkey Large Mid Cap NTR Index", "I:NQTRLMT": "NASDAQ Turkey Large Mid Cap TR Index", "I:NQTRMC": "NASDAQ Turkey Mid Cap Index", "I:NQTRMCN": "NASDAQ Turkey Mid Cap NTR Index", "I:NQTRMCT": "NASDAQ Turkey Mid Cap TR Index", "I:NQTRN": "NASDAQ Turkey NTR Index", "I:NQTRSC": "NASDAQ Turkey Small Cap Index", "I:NQTRSCN": "NASDAQ Turkey Small Cap NTR Index", "I:NQTRSCT": "NASDAQ Turkey Small Cap TR Index", "I:NQTRT": "NASDAQ Turkey TR Index", "I:NQTW": "NASDAQ Taiwan Index", "I:NQTW10": "Nasdaq Taiwan Technology Index", "I:NQTW10LM": "Nasdaq Taiwan Technology Large Mid Cap Index", "I:NQTW10LMN": "Nasdaq Taiwan Technology Large Mid Cap NTR Index", "I:NQTW10LMT": "Nasdaq Taiwan Technology Large Mid Cap TR Index", "I:NQTW10N": "Nasdaq Taiwan Technology NTR Index", "I:NQTW10T": "Nasdaq Taiwan Technology TR Index", "I:NQTW20": "NASDAQ Taiwan Health Care Index", "I:NQTW20N": "NASDAQ Taiwan Health Care NTR Index", "I:NQTW20T": "NASDAQ Taiwan Health Care TR Index", "I:NQTW30": "NASDAQ Taiwan Financials Index", "I:NQTW30LM": "Nasdaq Taiwan Financials Large Mid Cap Index", "I:NQTW30LMN": "NASDAQ Taiwan Financials Large Mid Cap NTR Index", "I:NQTW30LMT": "NASDAQ Taiwan Financials Large Mid Cap TR Index", "I:NQTW30N": "NASDAQ Taiwan Financials NTR Index", "I:NQTW30T": "NASDAQ Taiwan Financials TR Index", "I:NQTW35": "Nasdaq Taiwan Real Estate Index", "I:NQTW35N": "Nasdaq Taiwan Real Estate NTR Index", "I:NQTW35T": "Nasdaq Taiwan Real Estate TR Index", "I:NQTW40": "Nasdaq Taiwan Consumer Discretionary Index", "I:NQTW40LM": "Nasdaq Taiwan Consumer Discretionary Large Mid Cap Index", "I:NQTW40LMN": "Nasdaq Taiwan Consumer Discretionary Large Mid Cap NTR Index", "I:NQTW40LMT": "Nasdaq Taiwan Consumer Discretionary Large Mid Cap TR Index", "I:NQTW40N": "Nasdaq Taiwan Consumer Discretionary NTR Index", "I:NQTW40T": "Nasdaq Taiwan Consumer Discretionary TR Index", "I:NQTW45": "Nasdaq Taiwan Consumer Staples Index", "I:NQTW45N": "Nasdaq Taiwan Consumer Staples NTR Index", "I:NQTW45T": "Nasdaq Taiwan Consumer Staples TR Index", "I:NQTW50": "Nasdaq Taiwan Industrials Index", "I:NQTW50LM": "Nasdaq Taiwan Industrials Large Mid Cap Index", "I:NQTW50LMN": "Nasdaq Taiwan Industrials Large Mid Cap NTR Index", "I:NQTW50LMT": "Nasdaq Taiwan Industrials Large Mid Cap TR Index", "I:NQTW50N": "Nasdaq Taiwan Industrials NTR Index", "I:NQTW50T": "Nasdaq Taiwan Industrials TR Index", "I:NQTW55": "Nasdaq Taiwan Basic Materials Index", "I:NQTW55LM": "Nasdaq Taiwan Basic Materials Large Mid Cap Index", "I:NQTW55LMN": "Nasdaq Taiwan Basic Materials Large Mid Cap NTR Index", "I:NQTW55LMT": "Nasdaq Taiwan Basic Materials Large Mid Cap TR Index", "I:NQTW55N": "Nasdaq Taiwan Basic Materials NTR Index", "I:NQTW55T": "Nasdaq Taiwan Basic Materials TR Index", "I:NQTW60": "Nasdaq Taiwan Energy Index", "I:NQTW60N": "Nasdaq Taiwan Energy NTR Index", "I:NQTW60T": "Nasdaq Taiwan Energy TR Index", "I:NQTWLC": "NASDAQ Taiwan Large Cap Index", "I:NQTWLCN": "NASDAQ Taiwan Large Cap NTR Index", "I:NQTWLCT": "NASDAQ Taiwan Large Cap TR Index", "I:NQTWLM": "NASDAQ Taiwan Large Mid Cap Index", "I:NQTWLMN": "NASDAQ Taiwan Large Mid Cap NTR Index", "I:NQTWLMT": "NASDAQ Taiwan Large Mid Cap TR Index", "I:NQTWMC": "NASDAQ Taiwan Mid Cap Index", "I:NQTWMCN": "NASDAQ Taiwan Mid Cap NTR Index", "I:NQTWMCT": "NASDAQ Taiwan Mid Cap TR Index", "I:NQTWN": "NASDAQ Taiwan NTR Index", "I:NQTWSC": "NASDAQ Taiwan Small Cap Index", "I:NQTWSCN": "NASDAQ Taiwan Small Cap NTR Index", "I:NQTWSCT": "NASDAQ Taiwan Small Cap TR Index", "I:NQTWT": "NASDAQ Taiwan TR Index", "I:NQULCHK": "NASDAQ Chaikin Power US Large Cap Index", "I:NQULCHKT": "NASDAQ Chaikin Power US Large Cap TR", "I:NQUS1300SMC": "Nasdaq US 1300 Small Mid Cap Index", "I:NQUS1300SMCN": "Nasdaq US 1300 Small Mid Cap Net Total Return Index", "I:NQUS1300SMCT": "Nasdaq US 1300 Small Mid Cap Total Return Index", "I:NQUS500LC": "Nasdaq US 500 Large Cap Index", "I:NQUS500LCE": "Nasdaq US 500 Large Cap Equal Weight Index", "I:NQUS500LCEN": "Nasdaq US 500 Large Cap Equal Weight NTR Index", "I:NQUS500LCET": "Nasdaq US 500 Large Cap Equal Weight TR Index", "I:NQUS500LCG": "Nasdaq US 500 Large Cap Growth Index", "I:NQUS500LCGN": "Nasdaq US 500 Large Cap Growth Net Total Return In", "I:NQUS500LCGT": "Nasdaq US 500 Large Cap Growth Total Return Index", "I:NQUS500LCN": "Nasdaq US 500 Large Cap Net Total Return Index", "I:NQUS500LCT": "Nasdaq US 500 Large Cap Total Return Index", "I:NQUS500LCV": "Nasdaq US 500 Large Cap Value Index", "I:NQUS500LCVN": "Nasdaq US 500 Large Cap Value Net Total Return Ind", "I:NQUS500LCVT": "Nasdaq US 500 Large Cap Value Total Return Index", "I:NQUS600MC": "Nasdaq US 600 Mid Cap Index", "I:NQUS600MCG": "Nasdaq US 600 Mid Cap Growth Index", "I:NQUS600MCGN": "Nasdaq US 600 Mid Cap Growth Net Total Return Inde", "I:NQUS600MCGT": "Nasdaq US 600 Mid Cap Growth Total Return Index", "I:NQUS600MCN": "Nasdaq US 600 Mid Cap Net Total Return Index", "I:NQUS600MCT": "Nasdaq US 600 Mid Cap Total Return Index", "I:NQUS600MCV": "Nasdaq US 600 Mid Cap Value Index", "I:NQUS600MCVN": "Nasdaq US 600 Mid Cap Value Net Total Return Index", "I:NQUS600MCVT": "Nasdaq US 600 Mid Cap Value Total Return Index", "I:NQUS700SC": "Nasdaq US 700 Small Cap Index", "I:NQUS700SCG": "Nasdaq US 700 Small Cap Growth Index", "I:NQUS700SCGN": "Nasdaq US 700 Small Cap Growth Net Total Return In", "I:NQUS700SCGT": "Nasdaq US 700 Small Cap Growth Total Return Index", "I:NQUS700SCN": "Nasdaq US 700 Small Cap Net Total Return Index", "I:NQUS700SCT": "Nasdaq US 700 Small Cap Total Return Index", "I:NQUS700SCV": "Nasdaq US 700 Small Cap Value Index", "I:NQUS700SCVN": "Nasdaq US 700 Small Cap Value Net Total Return Ind", "I:NQUS700SCVT": "Nasdaq US 700 Small Cap Value Total Return Index", "I:NQUSB": "NASDAQ US Benchmark Index", "I:NQUSB10": "Nasdaq US Benchmark Technology Index", "I:NQUSB101010": "Nasdaq US Benchmark Software and Computer Services Index", "I:NQUSB10101010": "Nasdaq US Benchmark Computer Services Index", "I:NQUSB10101010LM": "Nasdaq US Computer Services Large Mid Cap Index", "I:NQUSB10101010LMN": "Nasdaq US Computer Services Large Mid Cap NTR Index", "I:NQUSB10101010LMT": "Nasdaq US Computer Services Large Mid Cap TR Index", "I:NQUSB10101010N": "Nasdaq US Benchmark Computer Services NTR Index", "I:NQUSB10101010T": "Nasdaq US Benchmark Computer Services TR Index", "I:NQUSB10101015": "Nasdaq US Benchmark Software Index", "I:NQUSB10101015LM": "Nasdaq US Software Large Mid Cap Index", "I:NQUSB10101015LMN": "Nasdaq US Software Large Mid Cap NTR Index", "I:NQUSB10101015LMT": "Nasdaq US Software Large Mid Cap TR Index", "I:NQUSB10101015N": "Nasdaq US Benchmark Software NTR Index", "I:NQUSB10101015T": "Nasdaq US Benchmark Software TR Index", "I:NQUSB10101020": "Nasdaq US Benchmark Consumer Digital Services Index", "I:NQUSB10101020LM": "Nasdaq US Consumer Digital Services Large Mid Cap Index", "I:NQUSB10101020LMN": "Nasdaq US Consumer Digital Services Large Mid Cap NTR Index", "I:NQUSB10101020LMT": "Nasdaq US Consumer Digital Services Large Mid Cap TR Index", "I:NQUSB10101020N": "Nasdaq US Benchmark Consumer Digital Services NTR Index", "I:NQUSB10101020T": "Nasdaq US Benchmark Consumer Digital Services TR Index", "I:NQUSB101010LM": "Nasdaq US Software and Computer Services Large Mid Cap Index", "I:NQUSB101010LMN": "Nasdaq US Software and Computer Services Large Mid Cap NTR Index", "I:NQUSB101010LMT": "Nasdaq US Software and Computer Services Large Mid Cap TR Index", "I:NQUSB101010N": "Nasdaq US Benchmark Software and Computer Services NTR Index", "I:NQUSB101010T": "Nasdaq US Benchmark Software and Computer Services TR Index", "I:NQUSB101020": "Nasdaq US Benchmark Technology Hardware and Equipment Index", "I:NQUSB10102010": "Nasdaq US Benchmark Semiconductors Index", "I:NQUSB10102010LM": "Nasdaq US Semiconductors Large Mid Cap Index", "I:NQUSB10102010LMN": "Nasdaq US Semiconductors Large Mid Cap NTR Index", "I:NQUSB10102010LMT": "Nasdaq US Semiconductors Large Mid Cap TR Index", "I:NQUSB10102010N": "Nasdaq US Benchmark Semiconductors NTR Index", "I:NQUSB10102010T": "Nasdaq US Benchmark Semiconductors TR Index", "I:NQUSB10102015": "Nasdaq US Benchmark Electronic Components Index", "I:NQUSB10102015LM": "Nasdaq US Electronic Components Large Mid Cap Index", "I:NQUSB10102015LMN": "Nasdaq US Electronic Components Large Mid Cap NTR Index", "I:NQUSB10102015LMT": "Nasdaq US Electronic Components Large Mid Cap TR Index", "I:NQUSB10102015N": "Nasdaq US Benchmark Electronic Components NTR Index", "I:NQUSB10102015T": "Nasdaq US Benchmark Electronic Components TR Index", "I:NQUSB10102020": "Nasdaq US Benchmark Production Technology Equipment Index", "I:NQUSB10102020LM": "Nasdaq US Production Technology Equipment Large Mid Cap Index", "I:NQUSB10102020LMN": "Nasdaq US Production Technology Equipment Large Mid Cap NTR Index", "I:NQUSB10102020LMT": "Nasdaq US Production Technology Equipment Large Mid Cap TR Index", "I:NQUSB10102020N": "Nasdaq US Benchmark Production Technology Equipment NTR Index", "I:NQUSB10102020T": "Nasdaq US Benchmark Production Technology Equipment TR Index", "I:NQUSB10102030": "Nasdaq US Benchmark Computer Hardware Index", "I:NQUSB10102030LM": "Nasdaq US Computer Hardware Large Mid Cap Index", "I:NQUSB10102030LMN": "Nasdaq US Computer Hardware Large Mid Cap NTR Index", "I:NQUSB10102030LMT": "Nasdaq US Computer Hardware Large Mid Cap TR Index", "I:NQUSB10102030N": "Nasdaq US Benchmark Computer Hardware NTR Index", "I:NQUSB10102030T": "Nasdaq US Benchmark Computer Hardware TR Index", "I:NQUSB101020LM": "Nasdaq US Technology Hardware and Equipment Large Mid Cap Index", "I:NQUSB101020LMN": "Nasdaq US Technology Hardware and Equipment Large Mid Cap NTR Index", "I:NQUSB101020LMT": "Nasdaq US Technology Hardware and Equipment Large Mid Cap TR Index", "I:NQUSB101020N": "Nasdaq US Benchmark Technology Hardware and Equipment NTR Index", "I:NQUSB101020T": "Nasdaq US Benchmark Technology Hardware and Equipment TR Index", "I:NQUSB10LM": "Nasdaq US Technology Large Mid Cap Index", "I:NQUSB10LMN": "Nasdaq US Technology Large Mid Cap NTR Index", "I:NQUSB10LMT": "Nasdaq US Technology Large Mid Cap TR Index", "I:NQUSB10N": "Nasdaq US Benchmark Technology NTR Index", "I:NQUSB10T": "Nasdaq US Benchmark Technology TR Index", "I:NQUSB15": "Nasdaq US Benchmark Telecommunications Index", "I:NQUSB151010": "Nasdaq US Benchmark Telecommunications Equipment Index", "I:NQUSB151010LM": "Nasdaq US Telecommunications Equipment Large Mid Cap Index", "I:NQUSB151010LMN": "Nasdaq US Telecommunications Equipment Large Mid Cap NTR Index", "I:NQUSB151010LMT": "Nasdaq US Telecommunications Equipment Large Mid Cap TR Index", "I:NQUSB151010N": "Nasdaq US Benchmark Telecommunications Equipment NTR Index", "I:NQUSB151010T": "Nasdaq US Benchmark Telecommunications Equipment TR Index", "I:NQUSB151020": "Nasdaq US Benchmark Telecommunications Service Providers Index", "I:NQUSB15102010": "Nasdaq US Benchmark Cable Television Services Index", "I:NQUSB15102010LM": "Nasdaq US Cable Television Services Large Mid Cap Index", "I:NQUSB15102010LMN": "Nasdaq US Cable Television Services Large Mid Cap NTR Index", "I:NQUSB15102010LMT": "Nasdaq US Cable Television Services Large Mid Cap TR Index", "I:NQUSB15102010N": "Nasdaq US Benchmark Cable Television Services NTR Index", "I:NQUSB15102010T": "Nasdaq US Benchmark Cable Television Services TR Index", "I:NQUSB15102015": "Nasdaq US Benchmark Telecommunications Services Index", "I:NQUSB15102015LM": "Nasdaq US Telecommunications Services Large Mid Cap Index", "I:NQUSB15102015LMN": "Nasdaq US Telecommunications Services Large Mid Cap NTR Index", "I:NQUSB15102015LMT": "Nasdaq US Telecommunications Services Large Mid Cap TR Index", "I:NQUSB15102015N": "Nasdaq US Benchmark Telecommunications Services NTR Index", "I:NQUSB15102015T": "Nasdaq US Benchmark Telecommunications Services TR Index", "I:NQUSB151020LM": "Nasdaq US Telecommunications Service Provider Large Mid Cap Index", "I:NQUSB151020LMN": "Nasdaq US Telecommunications Service Provider Large Mid Cap NTR Index", "I:NQUSB151020LMT": "Nasdaq US Telecommunications Service Provider Large Mid Cap TR Index", "I:NQUSB151020N": "Nasdaq US Benchmark Telecommunications Service Providers NTR Index", "I:NQUSB151020T": "Nasdaq US Benchmark Telecommunications Service Providers TR Index", "I:NQUSB15LM": "Nasdaq US Telecommunications Large Mid Cap Index", "I:NQUSB15LMN": "Nasdaq US Telecommunications Large Mid Cap NTR Index", "I:NQUSB15LMT": "Nasdaq US Telecommunications Large Mid Cap TR Index", "I:NQUSB15N": "Nasdaq US Benchmark Telecommunications NTR Index", "I:NQUSB15T": "Nasdaq US Benchmark Telecommunications TR Index", "I:NQUSB20": "Nasdaq US Benchmark Health Care Index", "I:NQUSB201010": "Nasdaq US Benchmark Health Care Providers Index", "I:NQUSB20101010": "Nasdaq US Benchmark Health Care Facilities Index", "I:NQUSB20101010LM": "Nasdaq US Health Care Facilities Large Mid Cap Index", "I:NQUSB20101010LMN": "Nasdaq US Health Care Facilities Large Mid Cap NTR Index", "I:NQUSB20101010LMT": "Nasdaq US Health Care Facilities Large Mid Cap TR Index", "I:NQUSB20101010N": "Nasdaq US Benchmark Health Care Facilities NTR Index", "I:NQUSB20101010T": "Nasdaq US Benchmark Health Care Facilities TR Index", "I:NQUSB20101020": "Nasdaq US Benchmark Health Care Management Services Index", "I:NQUSB20101020LM": "Nasdaq US Health Care Management Services Large Mid Cap Index", "I:NQUSB20101020LMN": "Nasdaq US Health Care Management Services Large Mid Cap NTR Index", "I:NQUSB20101020LMT": "Nasdaq US Health Care Management Services Large Mid Cap TR Index", "I:NQUSB20101020N": "Nasdaq US Benchmark Health Care Management Services NTR Index", "I:NQUSB20101020T": "Nasdaq US Benchmark Health Care Management Services TR Index", "I:NQUSB20101025": "Nasdaq US Benchmark Health Care Services Index", "I:NQUSB20101025LM": "Nasdaq US Health Care Services Large Mid Cap Index", "I:NQUSB20101025LMN": "Nasdaq US Health Care Services Large Mid Cap NTR Index", "I:NQUSB20101025LMT": "Nasdaq US Health Care Services Large Mid Cap TR Index", "I:NQUSB20101025N": "Nasdaq US Benchmark Health Care Services NTR Index", "I:NQUSB20101025T": "Nasdaq US Benchmark Health Care Services TR Index", "I:NQUSB201010LM": "Nasdaq US Health Care Providers Large Mid Cap Index", "I:NQUSB201010LMN": "Nasdaq US Health Care Providers Large Mid Cap NTR Index", "I:NQUSB201010LMT": "Nasdaq US Health Care Providers Large Mid Cap TR Index", "I:NQUSB201010N": "Nasdaq US Benchmark Health Care Providers NTR Index", "I:NQUSB201010T": "Nasdaq US Benchmark Health Care Providers TR Index", "I:NQUSB201020": "Nasdaq US Benchmark Medical Equipment and Services Index", "I:NQUSB20102010": "Nasdaq US Benchmark Medical Equipment Index", "I:NQUSB20102010LM": "Nasdaq US Medical Equipment Large Mid Cap Index", "I:NQUSB20102010LMN": "Nasdaq US Medical Equipment Large Mid Cap NTR Index", "I:NQUSB20102010LMT": "Nasdaq US Medical Equipment Large Mid Cap TR Index", "I:NQUSB20102010N": "Nasdaq US Benchmark Medical Equipment NTR Index", "I:NQUSB20102010T": "Nasdaq US Benchmark Medical Equipment TR Index", "I:NQUSB20102015": "Nasdaq US Benchmark Medical Supplies Index", "I:NQUSB20102015LM": "Nasdaq US Medical Supplies Large Mid Cap Index", "I:NQUSB20102015LMN": "Nasdaq US Medical Supplies Large Mid Cap NTR Index", "I:NQUSB20102015LMT": "Nasdaq US Medical Supplies Large Mid Cap TR Index", "I:NQUSB20102015N": "Nasdaq US Benchmark Medical Supplies NTR Index", "I:NQUSB20102015T": "Nasdaq US Benchmark Medical Supplies TR Index", "I:NQUSB20102020": "Nasdaq US Benchmark Medical Services Index", "I:NQUSB20102020LM": "Nasdaq US Medical Services Large Mid Cap Index", "I:NQUSB20102020LMN": "Nasdaq US Medical Services Large Mid Cap NTR Index", "I:NQUSB20102020LMT": "Nasdaq US Medical Services Large Mid Cap TR Index", "I:NQUSB20102020N": "Nasdaq US Benchmark Medical Services NTR Index", "I:NQUSB20102020T": "Nasdaq US Benchmark Medical Services TR Index", "I:NQUSB201020LM": "Nasdaq US Medical Equipment and Services Large Mid Cap Index", "I:NQUSB201020LMN": "Nasdaq US Medical Equipment and Services Large Mid Cap NTR Index", "I:NQUSB201020LMT": "Nasdaq US Medical Equipment and Services Large Mid Cap TR Index", "I:NQUSB201020N": "Nasdaq US Benchmark Medical Equipment and Services NTR Index", "I:NQUSB201020T": "Nasdaq US Benchmark Medical Equipment and Services TR Index", "I:NQUSB201030": "Nasdaq US Benchmark Pharmaceuticals and Biotechnology Index", "I:NQUSB20103010": "Nasdaq US Benchmark Biotechnology Index", "I:NQUSB20103010LM": "Nasdaq US Biotechnology Large Mid Cap Index", "I:NQUSB20103010LMN": "Nasdaq US Biotechnology Large Mid Cap NTR Index", "I:NQUSB20103010LMT": "Nasdaq US Biotechnology Large Mid Cap TR Index", "I:NQUSB20103010N": "Nasdaq US Benchmark Biotechnology NTR Index", "I:NQUSB20103010T": "Nasdaq US Benchmark Biotechnology TR Index", "I:NQUSB20103015": "Nasdaq US Benchmark Pharmaceuticals Index", "I:NQUSB20103015LM": "Nasdaq US Pharmaceuticals Large Mid Cap Index", "I:NQUSB20103015LMN": "Nasdaq US Pharmaceuticals Large Mid Cap NTR Index", "I:NQUSB20103015LMT": "Nasdaq US Pharmaceuticals Large Mid Cap TR Index", "I:NQUSB20103015N": "Nasdaq US Benchmark Pharmaceuticals NTR Index", "I:NQUSB20103015T": "Nasdaq US Benchmark Pharmaceuticals TR Index", "I:NQUSB201030LM": "Nasdaq US Pharmaceuticals and Biotechnology Large Mid Cap Index", "I:NQUSB201030LMN": "Nasdaq US Pharmaceuticals and Biotechnology Large Mid Cap NTR Index", "I:NQUSB201030LMT": "Nasdaq US Pharmaceuticals and Biotechnology Large Mid Cap TR Index", "I:NQUSB201030N": "Nasdaq US Benchmark Pharmaceuticals and Biotechnology NTR Index", "I:NQUSB201030T": "Nasdaq US Benchmark Pharmaceuticals and Biotechnology TR Index", "I:NQUSB20LM": "Nasdaq US Health Care Large Mid Cap Index", "I:NQUSB20LMN": "Nasdaq US Health Care Large Mid Cap NTR Index", "I:NQUSB20LMT": "Nasdaq US Health Care Large Mid Cap TR Index", "I:NQUSB20N": "Nasdaq US Benchmark Health Care NTR Index", "I:NQUSB20T": "Nasdaq US Benchmark Health Care TR Index", "I:NQUSB30": "Nasdaq US Benchmark Financials Index", "I:NQUSB3010": "Nasdaq US Benchmark Banks Index", "I:NQUSB3010LM": "Nasdaq US Banks Large Mid Cap Index", "I:NQUSB3010LMN": "Nasdaq US Banks Large Mid Cap NTR Index", "I:NQUSB3010LMT": "Nasdaq US Banks Large Mid Cap TR Index", "I:NQUSB3010N": "Nasdaq US Benchmark Banks NTR Index", "I:NQUSB3010T": "Nasdaq US Benchmark Banks TR Index", "I:NQUSB3020": "Nasdaq US Benchmark Financial Services Index", "I:NQUSB302010": "Nasdaq US Benchmark Finance and Credit Services Index", "I:NQUSB30201020": "Nasdaq US Benchmark Consumer Lending Index", "I:NQUSB30201020LM": "Nasdaq US Consumer Lending Large Mid Cap Index", "I:NQUSB30201020LMN": "Nasdaq US Consumer Lending Large Mid Cap NTR Index", "I:NQUSB30201020LMT": "Nasdaq US Consumer Lending Large Mid Cap TR Index", "I:NQUSB30201020N": "Nasdaq US Benchmark Consumer Lending NTR Index", "I:NQUSB30201020T": "Nasdaq US Benchmark Consumer Lending TR Index", "I:NQUSB30201025": "Nasdaq US Benchmark Mortgage Finance Index", "I:NQUSB30201025N": "Nasdaq US Benchmark Mortgage Finance NTR Index", "I:NQUSB30201025T": "Nasdaq US Benchmark Mortgage Finance TR Index", "I:NQUSB30201030": "Nasdaq US Benchmark Financial Data Providers Index", "I:NQUSB30201030LM": "Nasdaq US Financial Data Providers Large Mid Cap Index", "I:NQUSB30201030LMN": "Nasdaq US Financial Data Providers Large Mid Cap NTR Index", "I:NQUSB30201030LMT": "Nasdaq US Financial Data Providers Large Mid Cap TR Index", "I:NQUSB30201030N": "Nasdaq US Benchmark Financial Data Providers NTR Index", "I:NQUSB30201030T": "Nasdaq US Benchmark Financial Data Providers TR Index", "I:NQUSB302010LM": "Nasdaq US Finance and Credit Services Large Mid Cap Index", "I:NQUSB302010LMN": "Nasdaq US Finance and Credit Services Large Mid Cap NTR Index", "I:NQUSB302010LMT": "Nasdaq US Finance and Credit Services Large Mid Cap TR Index", "I:NQUSB302010N": "Nasdaq US Benchmark Finance and Credit Services NTR Index", "I:NQUSB302010T": "Nasdaq US Benchmark Finance and Credit Services TR Index", "I:NQUSB302020": "Nasdaq US Benchmark Investment Banking and Brokerage Services Index", "I:NQUSB30202000": "Nasdaq US Benchmark Diversified Financial Services Index", "I:NQUSB30202000LM": "Nasdaq US Diversified Financial Services Large Mid Cap Index", "I:NQUSB30202000LMN": "Nasdaq US Diversified Financial Services Large Mid Cap NTR Index", "I:NQUSB30202000LMT": "Nasdaq US Diversified Financial Services Large Mid Cap TR Index", "I:NQUSB30202000N": "Nasdaq US Benchmark Diversified Financial Services NTR Index", "I:NQUSB30202000T": "Nasdaq US Benchmark Diversified Financial Services TR Index", "I:NQUSB30202010": "Nasdaq US Benchmark Asset Managers and Custodians Index", "I:NQUSB30202010LM": "Nasdaq US Asset Managers and Custodians Large Mid Cap Index", "I:NQUSB30202010LMN": "Nasdaq US Asset Managers and Custodians Large Mid Cap NTR Index", "I:NQUSB30202010LMT": "Nasdaq US Asset Managers and Custodians Large Mid Cap TR Index", "I:NQUSB30202010N": "Nasdaq US Benchmark Asset Managers and Custodians NTR Index", "I:NQUSB30202010T": "Nasdaq US Benchmark Asset Managers and Custodians TR Index", "I:NQUSB30202015": "Nasdaq US Benchmark Investment Services Index", "I:NQUSB30202015LM": "Nasdaq US Investment Services Large Mid Cap Index", "I:NQUSB30202015LMN": "Nasdaq US Investment Services Large Mid Cap NTR Index", "I:NQUSB30202015LMT": "Nasdaq US Investment Services Large Mid Cap TR Index", "I:NQUSB30202015N": "Nasdaq US Benchmark Investment Services NTR Index", "I:NQUSB30202015T": "Nasdaq US Benchmark Investment Services TR Index", "I:NQUSB302020LM": "Nasdaq US Investment Banking and Brokerage Services Large Mid Cap Index", "I:NQUSB302020LMN": "Nasdaq US Investment Banking and Brokerage Services Large Mid Cap NTR Index", "I:NQUSB302020LMT": "Nasdaq US Investment Banking and Brokerage Services Large Mid Cap TR Index", "I:NQUSB302020N": "Nasdaq US Benchmark Investment Banking and Brokerage Services NTR Index", "I:NQUSB302020T": "Nasdaq US Benchmark Investment Banking and Brokerage Services TR Index", "I:NQUSB302030": "Nasdaq US Benchmark Mortgage Real Estate Investment Trusts Index", "I:NQUSB30203000": "Nasdaq US Benchmark Mortgage REITs: Diversified Index", "I:NQUSB30203000N": "Nasdaq US Benchmark Mortgage REITs: Diversified NTR Index", "I:NQUSB30203000T": "Nasdaq US Benchmark Mortgage REITs: Diversified TR Index", "I:NQUSB30203010": "Nasdaq US Benchmark Mortgage REITs: Commercial Index", "I:NQUSB30203010N": "Nasdaq US Benchmark Mortgage REITs: Commercial NTR Index", "I:NQUSB30203010T": "Nasdaq US Benchmark Mortgage REITs: Commercial TR Index", "I:NQUSB30203020": "Nasdaq US Benchmark Mortgage REITs: Residential Index", "I:NQUSB30203020LM": "Nasdaq US Mortgage REITs: Residential Large Mid Cap Index", "I:NQUSB30203020LMN": "Nasdaq US Mortgage REITs: Residential Large Mid Cap NTR Index", "I:NQUSB30203020LMT": "Nasdaq US Mortgage REITs: Residential Large Mid Cap TR Index", "I:NQUSB30203020N": "Nasdaq US Benchmark Mortgage REITs: Residential NTR Index", "I:NQUSB30203020T": "Nasdaq US Benchmark Mortgage REITs: Residential TR Index", "I:NQUSB302030LM": "Nasdaq US Mortgage Real Estate Investment Trusts Large Mid Cap Index", "I:NQUSB302030LMN": "Nasdaq US Mortgage Real Estate Investment Trusts Large Mid Cap NTR Index", "I:NQUSB302030LMT": "Nasdaq US Mortgage Real Estate Investment Trusts Large Mid Cap TR Index", "I:NQUSB302030N": "Nasdaq US Benchmark Mortgage Real Estate Investment Trusts NTR Index", "I:NQUSB302030T": "Nasdaq US Benchmark Mortgage Real Estate Investment Trusts TR Index", "I:NQUSB3020LM": "Nasdaq US Financial Services Large Mid Cap Index", "I:NQUSB3020LMN": "Nasdaq US Financial Services Large Mid Cap NTR Index", "I:NQUSB3020LMT": "Nasdaq US Financial Services Large Mid Cap TR Index", "I:NQUSB3020N": "Nasdaq US Benchmark Financial Services NTR Index", "I:NQUSB3020T": "Nasdaq US Benchmark Financial Services TR Index", "I:NQUSB3030": "Nasdaq US Benchmark Insurance Index", "I:NQUSB303010": "Nasdaq US Benchmark Life Insurance Index", "I:NQUSB303010LM": "Nasdaq US Life Insurance Large Mid Cap Index", "I:NQUSB303010LMN": "Nasdaq US Life Insurance Large Mid Cap NTR Index", "I:NQUSB303010LMT": "Nasdaq US Life Insurance Large Mid Cap TR Index", "I:NQUSB303010N": "Nasdaq US Benchmark Life Insurance NTR Index", "I:NQUSB303010T": "Nasdaq US Benchmark Life Insurance TR Index", "I:NQUSB303020": "Nasdaq US Benchmark Non-life Insurance Index", "I:NQUSB30302010": "Nasdaq US Benchmark Full Line Insurance Index", "I:NQUSB30302010LM": "Nasdaq US Full Line Insurance Large Mid Cap Index", "I:NQUSB30302010LMN": "Nasdaq US Full Line Insurance Large Mid Cap NTR Index", "I:NQUSB30302010LMT": "Nasdaq US Full Line Insurance Large Mid Cap TR Index", "I:NQUSB30302010N": "Nasdaq US Benchmark Full Line Insurance NTR Index", "I:NQUSB30302010T": "Nasdaq US Benchmark Full Line Insurance TR Index", "I:NQUSB30302015": "Nasdaq US Benchmark Insurance Brokers Index", "I:NQUSB30302015N": "Nasdaq US Benchmark Insurance Brokers NTR Index", "I:NQUSB30302015T": "Nasdaq US Benchmark Insurance Brokers TR Index", "I:NQUSB30302020": "Nasdaq US Benchmark Reinsurance Index", "I:NQUSB30302020LM": "Nasdaq US Reinsurance Large Mid Cap Index", "I:NQUSB30302020LMN": "Nasdaq US Reinsurance Large Mid Cap NTR Index", "I:NQUSB30302020LMT": "Nasdaq US Reinsurance Large Mid Cap TR Index", "I:NQUSB30302020N": "Nasdaq US Benchmark Reinsurance NTR Index", "I:NQUSB30302020T": "Nasdaq US Benchmark Reinsurance TR Index", "I:NQUSB30302025": "Nasdaq US Benchmark Property and Casualty Insurance Index", "I:NQUSB30302025LM": "Nasdaq US Property and Casualty Insurance Large Mid Cap Index", "I:NQUSB30302025LMN": "Nasdaq US Property and Casualty Insurance Large Mid Cap NTR Index", "I:NQUSB30302025LMT": "Nasdaq US Property and Casualty Insurance Large Mid Cap TR Index", "I:NQUSB30302025N": "Nasdaq US Benchmark Property and Casualty Insurance NTR Index", "I:NQUSB30302025T": "Nasdaq US Benchmark Property and Casualty Insurance TR Index", "I:NQUSB303020LM": "Nasdaq US Non-life Insurance Large Mid Cap Index", "I:NQUSB303020LMN": "Nasdaq US Non-life Insurance Large Mid Cap NTR Index", "I:NQUSB303020LMT": "Nasdaq US Non-life Insurance Large Mid Cap TR Index", "I:NQUSB303020N": "Nasdaq US Benchmark Non-life Insurance NTR Index", "I:NQUSB303020T": "Nasdaq US Benchmark Non-life Insurance TR Index", "I:NQUSB3030LM": "Nasdaq US Insurance Large Mid Cap Index", "I:NQUSB3030LMN": "Nasdaq US Insurance Large Mid Cap NTR Index", "I:NQUSB3030LMT": "Nasdaq US Insurance Large Mid Cap TR Index", "I:NQUSB3030N": "Nasdaq US Benchmark Insurance NTR Index", "I:NQUSB3030T": "Nasdaq US Benchmark Insurance TR Index", "I:NQUSB30LM": "Nasdaq US Financials Large Mid Cap Index", "I:NQUSB30LMN": "Nasdaq US Financials Large Mid Cap NTR Index", "I:NQUSB30LMT": "Nasdaq US Financials Large Mid Cap TR Index", "I:NQUSB30N": "Nasdaq US Benchmark Financials NTR Index", "I:NQUSB30T": "Nasdaq US Benchmark Financials TR Index", "I:NQUSB35": "Nasdaq US Benchmark Real Estate Index", "I:NQUSB351010": "Nasdaq US Benchmark Real Estate Investment and Services Index", "I:NQUSB35101010": "Nasdaq US Benchmark Real Estate Holding and Development Index", "I:NQUSB35101010N": "Nasdaq US Benchmark Real Estate Holding and Development NTR Index", "I:NQUSB35101010T": "Nasdaq US Benchmark Real Estate Holding and Development TR Index", "I:NQUSB35101015": "Nasdaq US Benchmark Real Estate Services Index", "I:NQUSB35101015LM": "Nasdaq US Real Estate Services Large Mid Cap Index", "I:NQUSB35101015LMN": "Nasdaq US Real Estate Services Large Mid Cap NTR Index", "I:NQUSB35101015LMT": "Nasdaq US Real Estate Services Large Mid Cap TR Index", "I:NQUSB35101015N": "Nasdaq US Benchmark Real Estate Services NTR Index", "I:NQUSB35101015T": "Nasdaq US Benchmark Real Estate Services TR Index", "I:NQUSB351010LM": "Nasdaq US Real Estate Investment and Services Large Mid Cap Index", "I:NQUSB351010LMN": "Nasdaq US Real Estate Investment and Services Large Mid Cap NTR Index", "I:NQUSB351010LMT": "Nasdaq US Real Estate Investment and Services Large Mid Cap TR Index", "I:NQUSB351010N": "Nasdaq US Benchmark Real Estate Investment and Services NTR Index", "I:NQUSB351010T": "Nasdaq US Benchmark Real Estate Investment and Services TR Index", "I:NQUSB351020": "Nasdaq US Benchmark Real Estate Investment Trusts Index", "I:NQUSB35102000": "Nasdaq US Benchmark Diversified REITs Index", "I:NQUSB35102000N": "Nasdaq US Benchmark Diversified REITs NTR Index", "I:NQUSB35102000T": "Nasdaq US Benchmark Diversified REITs TR Index", "I:NQUSB35102010": "Nasdaq US Benchmark Health Care REITs Index", "I:NQUSB35102010LM": "Nasdaq US Health Care REITs Large Mid Cap Index", "I:NQUSB35102010LMN": "Nasdaq US Health Care REITs Large Mid Cap NTR Index", "I:NQUSB35102010LMT": "Nasdaq US Health Care REITs Large Mid Cap TR Index", "I:NQUSB35102010N": "Nasdaq US Benchmark Health Care REITs NTR Index", "I:NQUSB35102010T": "Nasdaq US Benchmark Health Care REITs TR Index", "I:NQUSB35102015": "Nasdaq US Benchmark Hotel and Lodging REITs Index", "I:NQUSB35102015LM": "Nasdaq US Hotel and Lodging REITs Large Mid Cap Index", "I:NQUSB35102015LMN": "Nasdaq US Hotel and Lodging REITs Large Mid Cap NTR Index", "I:NQUSB35102015LMT": "Nasdaq US Hotel and Lodging REITs Large Mid Cap TR Index", "I:NQUSB35102015N": "Nasdaq US Benchmark Hotel and Lodging REITs NTR Index", "I:NQUSB35102015T": "Nasdaq US Benchmark Hotel and Lodging REITs TR Index", "I:NQUSB35102020": "Nasdaq US Benchmark Industrial REITs Index", "I:NQUSB35102020LM": "Nasdaq US Industrial REITs Large Mid Cap Index", "I:NQUSB35102020LMN": "Nasdaq US Industrial REITs Large Mid Cap NTR Index", "I:NQUSB35102020LMT": "Nasdaq US Industrial REITs Large Mid Cap TR Index", "I:NQUSB35102020N": "Nasdaq US Benchmark Industrial REITs NTR Index", "I:NQUSB35102020T": "Nasdaq US Benchmark Industrial REITs TR Index", "I:NQUSB35102025": "Nasdaq US Benchmark Infrastructure REITs Index", "I:NQUSB35102025N": "Nasdaq US Benchmark Infrastructure REITs NTR Index", "I:NQUSB35102025T": "Nasdaq US Benchmark Infrastructure REITs TR Index", "I:NQUSB35102030": "Nasdaq US Benchmark Office REITs Index", "I:NQUSB35102030LM": "Nasdaq US Office REITs Large Mid Cap Index", "I:NQUSB35102030LMN": "Nasdaq US Office REITs Large Mid Cap NTR Index", "I:NQUSB35102030LMT": "Nasdaq US Office REITs Large Mid Cap TR Index", "I:NQUSB35102030N": "Nasdaq US Benchmark Office REITs NTR Index", "I:NQUSB35102030T": "Nasdaq US Benchmark Office REITs TR Index", "I:NQUSB35102040": "Nasdaq US Benchmark Residential REITs Index", "I:NQUSB35102040LM": "Nasdaq US Residential REITs Large Mid Cap Index", "I:NQUSB35102040LMN": "Nasdaq US Residential REITs Large Mid Cap NTR Index", "I:NQUSB35102040LMT": "Nasdaq US Residential REITs Large Mid Cap TR Index", "I:NQUSB35102040N": "Nasdaq US Benchmark Residential REITs NTR Index", "I:NQUSB35102040T": "Nasdaq US Benchmark Residential REITs TR Index", "I:NQUSB35102045": "Nasdaq US Benchmark Retail REITs Index", "I:NQUSB35102045LM": "Nasdaq US Retail REITs Large Mid Cap Index", "I:NQUSB35102045LMN": "Nasdaq US Retail REITs Large Mid Cap NTR Index", "I:NQUSB35102045LMT": "Nasdaq US Retail REITs Large Mid Cap TR Index", "I:NQUSB35102045N": "Nasdaq US Benchmark Retail REITs NTR Index", "I:NQUSB35102045T": "Nasdaq US Benchmark Retail REITs TR Index", "I:NQUSB35102070": "Nasdaq US Benchmark Other Specialty REITs Index", "I:NQUSB35102070LM": "Nasdaq US Other Specialty REITs Large Mid Cap Index", "I:NQUSB35102070LMN": "Nasdaq US Other Specialty REITs Large Mid Cap NTR Index", "I:NQUSB35102070LMT": "Nasdaq US Other Specialty REITs Large Mid Cap TR Index", "I:NQUSB35102070N": "Nasdaq US Benchmark Other Specialty REITs NTR Index", "I:NQUSB35102070T": "Nasdaq US Benchmark Other Specialty REITs TR Index", "I:NQUSB351020LM": "Nasdaq US Real Estate Investment Trusts Large Mid Cap Index", "I:NQUSB351020LMN": "Nasdaq US Real Estate Investment Trusts Large Mid Cap NTR Index", "I:NQUSB351020LMT": "Nasdaq US Real Estate Investment Trusts Large Mid Cap TR Index", "I:NQUSB351020N": "Nasdaq US Benchmark Real Estate Investment Trusts NTR Index", "I:NQUSB351020T": "Nasdaq US Benchmark Real Estate Investment Trusts TR Index", "I:NQUSB35LM": "Nasdaq US Real Estate Large Mid Cap Index", "I:NQUSB35LMN": "Nasdaq US Real Estate Large Mid Cap NTR Index", "I:NQUSB35LMT": "Nasdaq US Real Estate Large Mid Cap TR Index", "I:NQUSB35N": "Nasdaq US Benchmark Real Estate NTR Index", "I:NQUSB35T": "Nasdaq US Benchmark Real Estate TR Index", "I:NQUSB40": "Nasdaq US Benchmark Consumer Discretionary Index", "I:NQUSB4010": "Nasdaq US Benchmark Automobiles and Parts Index", "I:NQUSB40101020": "Nasdaq US Benchmark Automobiles Index", "I:NQUSB40101020LM": "Nasdaq US Automobiles Large Mid Cap Index", "I:NQUSB40101020LMN": "Nasdaq US Automobiles Large Mid Cap NTR Index", "I:NQUSB40101020LMT": "Nasdaq US Automobiles Large Mid Cap TR Index", "I:NQUSB40101020N": "Nasdaq US Benchmark Automobiles NTR Index", "I:NQUSB40101020T": "Nasdaq US Benchmark Automobiles TR Index", "I:NQUSB40101025": "Nasdaq US Benchmark Auto Parts Index", "I:NQUSB40101025LM": "Nasdaq US Auto Parts Large Mid Cap Index", "I:NQUSB40101025LMN": "Nasdaq US Auto Parts Large Mid Cap NTR Index", "I:NQUSB40101025LMT": "Nasdaq US Auto Parts Large Mid Cap TR Index", "I:NQUSB40101025N": "Nasdaq US Benchmark Auto Parts NTR Index", "I:NQUSB40101025T": "Nasdaq US Benchmark Auto Parts TR Index", "I:NQUSB4010LM": "Nasdaq US Automobiles and Parts Large Mid Cap Index", "I:NQUSB4010LMN": "Nasdaq US Automobiles and Parts Large Mid Cap NTR Index", "I:NQUSB4010LMT": "Nasdaq US Automobiles and Parts Large Mid Cap TR Index", "I:NQUSB4010N": "Nasdaq US Benchmark Automobiles and Parts NTR Index", "I:NQUSB4010T": "Nasdaq US Benchmark Automobiles and Parts TR Index", "I:NQUSB4020": "Nasdaq US Benchmark Consumer Products and Services Index", "I:NQUSB402010": "Nasdaq US Benchmark Consumer Services Index", "I:NQUSB40201010": "Nasdaq US Benchmark Education Services Index", "I:NQUSB40201010N": "Nasdaq US Benchmark Education Services NTR Index", "I:NQUSB40201010T": "Nasdaq US Benchmark Education Services TR Index", "I:NQUSB40201040": "Nasdaq US Benchmark Rental and Leasing Services: Consumer Index", "I:NQUSB40201040N": "Nasdaq US Benchmark Rental and Leasing Services: Consumer NTR Index", "I:NQUSB40201040T": "Nasdaq US Benchmark Rental and Leasing Services: Consumer TR Index", "I:NQUSB40201070": "Nasdaq US Benchmark Consumer Services: Misc. Index", "I:NQUSB40201070LM": "Nasdaq US Consumer Services: Misc. Large Mid Cap Index", "I:NQUSB40201070LMN": "Nasdaq US Consumer Services: Misc. Large Mid Cap NTR Index", "I:NQUSB40201070LMT": "Nasdaq US Consumer Services: Misc. Large Mid Cap TR Index", "I:NQUSB40201070N": "Nasdaq US Benchmark Consumer Services: Misc. NTR Index", "I:NQUSB40201070T": "Nasdaq US Benchmark Consumer Services: Misc. TR Index", "I:NQUSB402010LM": "Nasdaq US Consumer Services Large Mid Cap Index", "I:NQUSB402010LMN": "Nasdaq US Consumer Services Large Mid Cap NTR Index", "I:NQUSB402010LMT": "Nasdaq US Consumer Services Large Mid Cap TR Index", "I:NQUSB402010N": "Nasdaq US Benchmark Consumer Services NTR Index", "I:NQUSB402010T": "Nasdaq US Benchmark Consumer Services TR Index", "I:NQUSB402020": "Nasdaq US Benchmark Household Goods and Home Construction Index", "I:NQUSB40202010": "Nasdaq US Benchmark Home Construction Index", "I:NQUSB40202010LM": "Nasdaq US Home Construction Large Mid Cap Index", "I:NQUSB40202010LMN": "Nasdaq US Home Construction Large Mid Cap NTR Index", "I:NQUSB40202010LMT": "Nasdaq US Home Construction Large Mid Cap TR Index", "I:NQUSB40202010N": "Nasdaq US Benchmark Home Construction NTR Index", "I:NQUSB40202010T": "Nasdaq US Benchmark Home Construction TR Index", "I:NQUSB40202015": "Nasdaq US Benchmark Household Furnishings Index", "I:NQUSB40202015LM": "Nasdaq US Household Furnishings Large Mid Cap Index", "I:NQUSB40202015LMN": "Nasdaq US Household Furnishings Large Mid Cap NTR Index", "I:NQUSB40202015LMT": "Nasdaq US Household Furnishings Large Mid Cap TR Index", "I:NQUSB40202015N": "Nasdaq US Benchmark Household Furnishings NTR Index", "I:NQUSB40202015T": "Nasdaq US Benchmark Household Furnishings TR Index", "I:NQUSB40202025": "Nasdaq US Benchmark Household Equipment and Products Index", "I:NQUSB40202025LM": "Nasdaq US Household Equipment and Products Large Mid Cap Index", "I:NQUSB40202025LMN": "Nasdaq US Household Equipment and Products Large Mid Cap NTR Index", "I:NQUSB40202025LMT": "Nasdaq US Household Equipment and Products Large Mid Cap TR Index", "I:NQUSB40202025N": "Nasdaq US Benchmark Household Equipment and Products NTR Index", "I:NQUSB40202025T": "Nasdaq US Benchmark Household Equipment and Products TR Index", "I:NQUSB402020LM": "Nasdaq US Household Goods and Home Construction Large Mid Cap Index", "I:NQUSB402020LMN": "Nasdaq US Household Goods and Home Construction Large Mid Cap NTR Index", "I:NQUSB402020LMT": "Nasdaq US Household Goods and Home Construction Large Mid Cap TR Index", "I:NQUSB402020N": "Nasdaq US Benchmark Household Goods and Home Construction NTR Index", "I:NQUSB402020T": "Nasdaq US Benchmark Household Goods and Home Construction TR Index", "I:NQUSB402030": "Nasdaq US Benchmark Leisure Goods Index", "I:NQUSB40203010": "Nasdaq US Benchmark Consumer Electronics Index", "I:NQUSB40203010N": "Nasdaq US Benchmark Consumer Electronics NTR Index", "I:NQUSB40203010T": "Nasdaq US Benchmark Consumer Electronics TR Index", "I:NQUSB40203040": "Nasdaq US Benchmark Electronic Entertainment Index", "I:NQUSB40203040LM": "Nasdaq US Electronic Entertainment Large Mid Cap Index", "I:NQUSB40203040LMN": "Nasdaq US Electronic Entertainment Large Mid Cap NTR Index", "I:NQUSB40203040LMT": "Nasdaq US Electronic Entertainment Large Mid Cap TR Index", "I:NQUSB40203040N": "Nasdaq US Benchmark Electronic Entertainment NTR Index", "I:NQUSB40203040T": "Nasdaq US Benchmark Electronic Entertainment TR Index", "I:NQUSB40203045": "Nasdaq US Benchmark Toys Index", "I:NQUSB40203045LM": "Nasdaq US Toys Large Mid Cap Index", "I:NQUSB40203045LMN": "Nasdaq US Toys Large Mid Cap NTR Index", "I:NQUSB40203045LMT": "Nasdaq US Toys Large Mid Cap TR Index", "I:NQUSB40203045N": "Nasdaq US Benchmark Toys NTR Index", "I:NQUSB40203045T": "Nasdaq US Benchmark Toys TR Index", "I:NQUSB40203050": "Nasdaq US Benchmark Recreational Products Index", "I:NQUSB40203050LM": "Nasdaq US Recreational Products Large Mid Cap Index", "I:NQUSB40203050LMN": "Nasdaq US Recreational Products Large Mid Cap NTR Index", "I:NQUSB40203050LMT": "Nasdaq US Recreational Products Large Mid Cap TR Index", "I:NQUSB40203050N": "Nasdaq US Benchmark Recreational Products NTR Index", "I:NQUSB40203050T": "Nasdaq US Benchmark Recreational Products TR Index", "I:NQUSB40203055": "Nasdaq US Benchmark Recreational Vehicles and Boats Index", "I:NQUSB40203055N": "Nasdaq US Benchmark Recreational Vehicles and Boats NTR Index", "I:NQUSB40203055T": "Nasdaq US Benchmark Recreational Vehicles and Boats TR Index", "I:NQUSB402030LM": "Nasdaq US Leisure Goods Large Mid Cap Index", "I:NQUSB402030LMN": "Nasdaq US Leisure Goods Large Mid Cap NTR Index", "I:NQUSB402030LMT": "Nasdaq US Leisure Goods Large Mid Cap TR Index", "I:NQUSB402030N": "Nasdaq US Benchmark Leisure Goods NTR Index", "I:NQUSB402030T": "Nasdaq US Benchmark Leisure Goods TR Index", "I:NQUSB402040": "Nasdaq US Benchmark Personal Goods Index", "I:NQUSB40204020": "Nasdaq US Benchmark Clothing and Accessories Index", "I:NQUSB40204020LM": "Nasdaq US Clothing and Accessories Large Mid Cap Index", "I:NQUSB40204020LMN": "Nasdaq US Clothing and Accessories Large Mid Cap NTR Index", "I:NQUSB40204020LMT": "Nasdaq US Clothing and Accessories Large Mid Cap TR Index", "I:NQUSB40204020N": "Nasdaq US Benchmark Clothing and Accessories NTR Index", "I:NQUSB40204020T": "Nasdaq US Benchmark Clothing and Accessories TR Index", "I:NQUSB40204025": "Nasdaq US Benchmark Footwear Index", "I:NQUSB40204025N": "Nasdaq US Benchmark Footwear NTR Index", "I:NQUSB40204025T": "Nasdaq US Benchmark Footwear TR Index", "I:NQUSB40204035": "Nasdaq US Benchmark Cosmetics Index", "I:NQUSB40204035N": "Nasdaq US Benchmark Cosmetics NTR Index", "I:NQUSB40204035T": "Nasdaq US Benchmark Cosmetics TR Index", "I:NQUSB402040LM": "Nasdaq US Personal Goods Large Mid Cap Index", "I:NQUSB402040LMN": "Nasdaq US Personal Goods Large Mid Cap NTR Index", "I:NQUSB402040LMT": "Nasdaq US Personal Goods Large Mid Cap TR Index", "I:NQUSB402040N": "Nasdaq US Benchmark Personal Goods NTR Index", "I:NQUSB402040T": "Nasdaq US Benchmark Personal Goods TR Index", "I:NQUSB4020LM": "Nasdaq US Consumer Products and Services Large Mid Cap Index", "I:NQUSB4020LMN": "Nasdaq US Consumer Products and Services Large Mid Cap NTR Index", "I:NQUSB4020LMT": "Nasdaq US Consumer Products and Services Large Mid Cap TR Index", "I:NQUSB4020N": "Nasdaq US Benchmark Consumer Products and Services NTR Index", "I:NQUSB4020T": "Nasdaq US Benchmark Consumer Products and Services TR Index", "I:NQUSB4030": "Nasdaq US Benchmark Media Index", "I:NQUSB40301010": "Nasdaq US Benchmark Entertainment Index", "I:NQUSB40301010LM": "Nasdaq US Entertainment Large Mid Cap Index", "I:NQUSB40301010LMN": "Nasdaq US Entertainment Large Mid Cap NTR Index", "I:NQUSB40301010LMT": "Nasdaq US Entertainment Large Mid Cap TR Index", "I:NQUSB40301010N": "Nasdaq US Benchmark Entertainment NTR Index", "I:NQUSB40301010T": "Nasdaq US Benchmark Entertainment TR Index", "I:NQUSB40301020": "Nasdaq US Benchmark Media Agencies Index", "I:NQUSB40301020LM": "Nasdaq US Media Agencies Large Mid Cap Index", "I:NQUSB40301020LMN": "Nasdaq US Media Agencies Large Mid Cap NTR Index", "I:NQUSB40301020LMT": "Nasdaq US Media Agencies Large Mid Cap TR Index", "I:NQUSB40301020N": "Nasdaq US Benchmark Media Agencies NTR Index", "I:NQUSB40301020T": "Nasdaq US Benchmark Media Agencies TR Index", "I:NQUSB40301030": "Nasdaq US Benchmark Publishing Index", "I:NQUSB40301030LM": "Nasdaq US Publishing Large Mid Cap Index", "I:NQUSB40301030LMN": "Nasdaq US Publishing Large Mid Cap NTR Index", "I:NQUSB40301030LMT": "Nasdaq US Publishing Large Mid Cap TR Index", "I:NQUSB40301030N": "Nasdaq US Benchmark Publishing NTR Index", "I:NQUSB40301030T": "Nasdaq US Benchmark Publishing TR Index", "I:NQUSB40301035": "Nasdaq US Benchmark Radio and TV Broadcasters Index", "I:NQUSB40301035LM": "Nasdaq US Radio and TV Broadcasters Large Mid Cap Index", "I:NQUSB40301035LMN": "Nasdaq US Radio and TV Broadcasters Large Mid Cap NTR Index", "I:NQUSB40301035LMT": "Nasdaq US Radio and TV Broadcasters Large Mid Cap TR Index", "I:NQUSB40301035N": "Nasdaq US Benchmark Radio and TV Broadcasters NTR Index", "I:NQUSB40301035T": "Nasdaq US Benchmark Radio and TV Broadcasters TR Index", "I:NQUSB4030LM": "Nasdaq US Media Large Mid Cap Index", "I:NQUSB4030LMN": "Nasdaq US Media Large Mid Cap NTR Index", "I:NQUSB4030LMT": "Nasdaq US Media Large Mid Cap TR Index", "I:NQUSB4030N": "Nasdaq US Benchmark Media NTR Index", "I:NQUSB4030T": "Nasdaq US Benchmark Media TR Index", "I:NQUSB4040": "Nasdaq US Benchmark Retail Index", "I:NQUSB404010": "Nasdaq US Benchmark Retailers Index", "I:NQUSB40401010": "Nasdaq US Benchmark Diversified Retailers Index", "I:NQUSB40401010LM": "Nasdaq US Broadline Diversified Retailers Large Mid Cap Index", "I:NQUSB40401010LMN": "Nasdaq US Broadline Diversified Retailers Large Mid Cap NTR Index", "I:NQUSB40401010LMT": "Nasdaq US Broadline Diversified Retailers Large Mid Cap TR Index", "I:NQUSB40401010N": "Nasdaq US Benchmark Diversified Retailers NTR Index", "I:NQUSB40401010T": "Nasdaq US Benchmark Diversified Retailers TR Index", "I:NQUSB40401020": "Nasdaq US Benchmark Apparel Retailers Index", "I:NQUSB40401020LM": "Nasdaq US Apparel Retailers Large Mid Cap Index", "I:NQUSB40401020LMN": "Nasdaq US Apparel Retailers Large Mid Cap NTR Index", "I:NQUSB40401020LMT": "Nasdaq US Apparel Retailers Large Mid Cap TR Index", "I:NQUSB40401020N": "Nasdaq US Benchmark Apparel Retailers NTR Index", "I:NQUSB40401020T": "Nasdaq US Benchmark Apparel Retailers TR Index", "I:NQUSB40401025": "Nasdaq US Benchmark Home Improvement Retailers Index", "I:NQUSB40401025N": "Nasdaq US Benchmark Home Improvement Retailers NTR Index", "I:NQUSB40401025T": "Nasdaq US Benchmark Home Improvement Retailers TR Index", "I:NQUSB40401030": "Nasdaq US Benchmark Specialty Retailers Index", "I:NQUSB40401030LM": "Nasdaq US Specialty Retailers Large Mid Cap Index", "I:NQUSB40401030LMN": "Nasdaq US Specialty Retailers Large Mid Cap NTR Index", "I:NQUSB40401030LMT": "Nasdaq US Specialty Retailers Large Mid Cap TR Index", "I:NQUSB40401030N": "Nasdaq US Benchmark Specialty Retailers NTR Index", "I:NQUSB40401030T": "Nasdaq US Benchmark Specialty Retailers TR Index", "I:NQUSB404010LM": "Nasdaq US Retailers Large Mid Cap Index", "I:NQUSB404010LMN": "Nasdaq US Retailers Large Mid Cap NTR Index", "I:NQUSB404010LMT": "Nasdaq US Retailers Large Mid Cap TR Index", "I:NQUSB404010N": "Nasdaq US Benchmark Retailers NTR Index", "I:NQUSB404010T": "Nasdaq US Benchmark Retailers TR Index", "I:NQUSB4040LM": "Nasdaq US Retail Large Mid Cap Index", "I:NQUSB4040LMN": "Nasdaq US Retail Large Mid Cap NTR Index", "I:NQUSB4040LMT": "Nasdaq US Retail Large Mid Cap TR Index", "I:NQUSB4040N": "Nasdaq US Benchmark Retail NTR Index", "I:NQUSB4040T": "Nasdaq US Benchmark Retail TR Index", "I:NQUSB4050": "Nasdaq US Benchmark Travel and Leisure Index", "I:NQUSB40501010": "Nasdaq US Benchmark Airlines Index", "I:NQUSB40501010LM": "Nasdaq US Airlines Large Mid Cap Index", "I:NQUSB40501010LMN": "Nasdaq US Airlines Large Mid Cap NTR Index", "I:NQUSB40501010LMT": "Nasdaq US Airlines Large Mid Cap TR Index", "I:NQUSB40501010N": "Nasdaq US Benchmark Airlines NTR Index", "I:NQUSB40501010T": "Nasdaq US Benchmark Airlines TR Index", "I:NQUSB40501015": "Nasdaq US Benchmark Travel and Tourism Index", "I:NQUSB40501015LM": "Nasdaq US Travel and Tourism Large Mid Cap Index", "I:NQUSB40501015LMN": "Nasdaq US Travel and Tourism Large Mid Cap NTR Index", "I:NQUSB40501015LMT": "Nasdaq US Travel and Tourism Large Mid Cap TR Index", "I:NQUSB40501015N": "Nasdaq US Benchmark Travel and Tourism NTR Index", "I:NQUSB40501015T": "Nasdaq US Benchmark Travel and Tourism TR Index", "I:NQUSB40501020": "Nasdaq US Benchmark Casinos and Gambling Index", "I:NQUSB40501020LM": "Nasdaq US Casinos and Gambling Large Mid Cap Index", "I:NQUSB40501020LMN": "Nasdaq US Casinos and Gambling Large Mid Cap NTR Index", "I:NQUSB40501020LMT": "Nasdaq US Casinos and Gambling Large Mid Cap TR Index", "I:NQUSB40501020N": "Nasdaq US Benchmark Casinos and Gambling NTR Index", "I:NQUSB40501020T": "Nasdaq US Benchmark Casinos and Gambling TR Index", "I:NQUSB40501025": "Nasdaq US Benchmark Hotels and Motels Index", "I:NQUSB40501025LM": "Nasdaq US Hotels and Motels Large Mid Cap Index", "I:NQUSB40501025LMN": "Nasdaq US Hotels and Motels Large Mid Cap NTR Index", "I:NQUSB40501025LMT": "Nasdaq US Hotels and Motels Large Mid Cap TR Index", "I:NQUSB40501025N": "Nasdaq US Benchmark Hotels and Motels NTR Index", "I:NQUSB40501025T": "Nasdaq US Benchmark Hotels and Motels TR Index", "I:NQUSB40501030": "Nasdaq US Benchmark Recreational Services Index", "I:NQUSB40501030LM": "Nasdaq US Recreational Services Large Mid Cap Index", "I:NQUSB40501030LMN": "Nasdaq US Recreational Services Large Mid Cap NTR Index", "I:NQUSB40501030LMT": "Nasdaq US Recreational Services Large Mid Cap TR Index", "I:NQUSB40501030N": "Nasdaq US Benchmark Recreational Services NTR Index", "I:NQUSB40501030T": "Nasdaq US Benchmark Recreational Services TR Index", "I:NQUSB40501040": "Nasdaq US Benchmark Restaurants and Bars Index", "I:NQUSB40501040LM": "Nasdaq US Restaurants and Bars Large Mid Cap Index", "I:NQUSB40501040LMN": "Nasdaq US Restaurants and Bars Large Mid Cap NTR Index", "I:NQUSB40501040LMT": "Nasdaq US Restaurants and Bars Large Mid Cap TR Index", "I:NQUSB40501040N": "Nasdaq US Benchmark Restaurants and Bars NTR Index", "I:NQUSB40501040T": "Nasdaq US Benchmark Restaurants and Bars TR Index", "I:NQUSB4050LM": "Nasdaq US Travel and Leisure Large Mid Cap Index", "I:NQUSB4050LMN": "Nasdaq US Travel and Leisure Large Mid Cap NTR Index", "I:NQUSB4050LMT": "Nasdaq US Travel and Leisure Large Mid Cap TR Index", "I:NQUSB4050N": "Nasdaq US Benchmark Travel and Leisure NTR Index", "I:NQUSB4050T": "Nasdaq US Benchmark Travel and Leisure TR Index", "I:NQUSB40LM": "Nasdaq US Consumer Discretionary Large Mid Cap Index", "I:NQUSB40LMN": "Nasdaq US Consumer Discretionary Large Mid Cap NTR Index", "I:NQUSB40LMT": "Nasdaq US Consumer Discretionary Large Mid Cap TR Index", "I:NQUSB40N": "Nasdaq US Benchmark Consumer Discretionary NTR Index", "I:NQUSB40T": "Nasdaq US Benchmark Consumer Discretionary TR Index", "I:NQUSB45": "Nasdaq US Benchmark Consumer Staples Index", "I:NQUSB4510": "Nasdaq US Benchmark Food, Beverage and Tobacco Index", "I:NQUSB451010": "Nasdaq US Benchmark Beverages Index", "I:NQUSB45101015": "Nasdaq US Benchmark Distillers and Vintners Index", "I:NQUSB45101015N": "Nasdaq US Benchmark Distillers and Vintners NTR Index", "I:NQUSB45101015T": "Nasdaq US Benchmark Distillers and Vintners TR Index", "I:NQUSB45101020": "Nasdaq US Benchmark Soft Drinks Index", "I:NQUSB45101020LM": "Nasdaq US Soft Drinks Large Mid Cap Index", "I:NQUSB45101020LMN": "Nasdaq US Soft Drinks Large Mid Cap NTR Index", "I:NQUSB45101020LMT": "Nasdaq US Soft Drinks Large Mid Cap TR Index", "I:NQUSB45101020N": "Nasdaq US Benchmark Soft Drinks NTR Index", "I:NQUSB45101020T": "Nasdaq US Benchmark Soft Drinks TR Index", "I:NQUSB451010LM": "Nasdaq US Beverages Large Mid Cap Index", "I:NQUSB451010LMN": "Nasdaq US Beverages Large Mid Cap NTR Index", "I:NQUSB451010LMT": "Nasdaq US Beverages Large Mid Cap TR Index", "I:NQUSB451010N": "Nasdaq US Benchmark Beverages NTR Index", "I:NQUSB451010T": "Nasdaq US Benchmark Beverages TR Index", "I:NQUSB451020": "Nasdaq US Benchmark Food Producers Index", "I:NQUSB45102010": "Nasdaq US Benchmark Farming, Fishing, Ranching and Plantations Index", "I:NQUSB45102010N": "Nasdaq US Benchmark Farming, Fishing, Ranching and Plantations NTR Index", "I:NQUSB45102010T": "Nasdaq US Benchmark Farming, Fishing, Ranching and Plantations TR Index", "I:NQUSB45102020": "Nasdaq US Benchmark Food Products Index", "I:NQUSB45102020LM": "Nasdaq US Food Products Large Mid Cap Index", "I:NQUSB45102020LMN": "Nasdaq US Food Products Large Mid Cap NTR Index", "I:NQUSB45102020LMT": "Nasdaq US Food Products Large Mid Cap TR Index", "I:NQUSB45102020N": "Nasdaq US Benchmark Food Products NTR Index", "I:NQUSB45102020T": "Nasdaq US Benchmark Food Products TR Index", "I:NQUSB451020LM": "Nasdaq US Food Producers Large Mid Cap Index", "I:NQUSB451020LMN": "Nasdaq US Food Producers Large Mid Cap NTR Index", "I:NQUSB451020LMT": "Nasdaq US Food Producers Large Mid Cap TR Index", "I:NQUSB451020N": "Nasdaq US Benchmark Food Producers NTR Index", "I:NQUSB451020T": "Nasdaq US Benchmark Food Producers TR Index", "I:NQUSB451030": "Nasdaq US Benchmark Tobacco Index", "I:NQUSB451030N": "Nasdaq US Benchmark Tobacco NTR Index", "I:NQUSB451030T": "Nasdaq US Benchmark Tobacco TR Index", "I:NQUSB4510LM": "Nasdaq US Food, Beverage and Tobacco Large Mid Cap Index", "I:NQUSB4510LMN": "Nasdaq US Food, Beverage and Tobacco Large Mid Cap NTR Index", "I:NQUSB4510LMT": "Nasdaq US Food, Beverage and Tobacco Large Mid Cap TR Index", "I:NQUSB4510N": "Nasdaq US Benchmark Food, Beverage and Tobacco NTR Index", "I:NQUSB4510T": "Nasdaq US Benchmark Food, Beverage and Tobacco TR Index", "I:NQUSB4520": "Nasdaq US Benchmark Personal Care, Drug and Grocery Stores Index", "I:NQUSB45201010": "Nasdaq US Benchmark Food Retailers and Wholesalers Index", "I:NQUSB45201010LM": "Nasdaq US Food Retailers and Wholesalers Large Mid Cap Index", "I:NQUSB45201010LMN": "Nasdaq US Food Retailers and Wholesalers Large Mid Cap NTR Index", "I:NQUSB45201010LMT": "Nasdaq US Food Retailers and Wholesalers Large Mid Cap TR Index", "I:NQUSB45201010N": "Nasdaq US Benchmark Food Retailers and Wholesalers NTR Index", "I:NQUSB45201010T": "Nasdaq US Benchmark Food Retailers and Wholesalers TR Index", "I:NQUSB45201015": "Nasdaq US Benchmark Drug Retailers Index", "I:NQUSB45201015LM": "Nasdaq US Drug Retailers Large Mid Cap Index", "I:NQUSB45201015LMN": "Nasdaq US Drug Retailers Large Mid Cap NTR Index", "I:NQUSB45201015LMT": "Nasdaq US Drug Retailers Large Mid Cap TR Index", "I:NQUSB45201015N": "Nasdaq US Benchmark Drug Retailers NTR Index", "I:NQUSB45201015T": "Nasdaq US Benchmark Drug Retailers TR Index", "I:NQUSB45201020": "Nasdaq US Benchmark Personal Products Index", "I:NQUSB45201020LM": "Nasdaq US Personal Products Large Mid Cap Index", "I:NQUSB45201020LMN": "Nasdaq US Personal Products Large Mid Cap NTR Index", "I:NQUSB45201020LMT": "Nasdaq US Personal Products Large Mid Cap TR Index", "I:NQUSB45201020N": "Nasdaq US Benchmark Personal Products NTR Index", "I:NQUSB45201020T": "Nasdaq US Benchmark Personal Products TR Index", "I:NQUSB45201030": "Nasdaq US Benchmark Nondurable Household Products Index", "I:NQUSB45201030LM": "Nasdaq US Nondurable Household Products Large Mid Cap Index", "I:NQUSB45201030LMN": "Nasdaq US Nondurable Household Products Large Mid Cap NTR Index", "I:NQUSB45201030LMT": "Nasdaq US Nondurable Household Products Large Mid Cap TR Index", "I:NQUSB45201030N": "Nasdaq US Benchmark Nondurable Household Products NTR Index", "I:NQUSB45201030T": "Nasdaq US Benchmark Nondurable Household Products TR Index", "I:NQUSB4520LM": "Nasdaq US  Personal Care, Drug and Grocery Stores Large Mid Cap Index", "I:NQUSB4520LMN": "Nasdaq US  Personal Care, Drug and Grocery Stores Large Mid Cap NTR Index", "I:NQUSB4520LMT": "Nasdaq US  Personal Care, Drug and Grocery Stores Large Mid Cap TR Index", "I:NQUSB4520N": "Nasdaq US Benchmark Personal Care, Drug and Grocery Stores NTR Index", "I:NQUSB4520T": "Nasdaq US Benchmark Personal Care, Drug and Grocery Stores TR Index", "I:NQUSB45LM": "Nasdaq US Consumer Staples Large Mid Cap Index", "I:NQUSB45LMN": "Nasdaq US Consumer Staples Large Mid Cap NTR Index", "I:NQUSB45LMT": "Nasdaq US Consumer Staples Large Mid Cap TR Index", "I:NQUSB45N": "Nasdaq US Benchmark Consumer Staples NTR Index", "I:NQUSB45T": "Nasdaq US Benchmark Consumer Staples TR Index", "I:NQUSB50": "Nasdaq US Benchmark Industrials Index", "I:NQUSB5010": "Nasdaq US Benchmark Construction and Materials Index", "I:NQUSB50101010": "Nasdaq US Benchmark Construction Index", "I:NQUSB50101010N": "Nasdaq US Benchmark Construction NTR Index", "I:NQUSB50101010T": "Nasdaq US Benchmark Construction TR Index", "I:NQUSB50101015": "Nasdaq US Benchmark Engineering and Contracting Services Index", "I:NQUSB50101015LM": "Nasdaq US Engineering and Contacting Services Large Mid Cap Index", "I:NQUSB50101015LMN": "Nasdaq US Engineering and Contacting Services Large Mid Cap NTR Index", "I:NQUSB50101015LMT": "Nasdaq US Engineering and Contacting Services Large Mid Cap TR Index", "I:NQUSB50101015N": "Nasdaq US Benchmark Engineering and Contracting Services NTR Index", "I:NQUSB50101015T": "Nasdaq US Benchmark Engineering and Contracting Services TR Index", "I:NQUSB50101020": "Nasdaq US Benchmark Building, Roofing/Wallboard and Plumbing Index", "I:NQUSB50101020N": "Nasdaq US Benchmark Building, Roofing/Wallboard and Plumbing NTR Index", "I:NQUSB50101020T": "Nasdaq US Benchmark Building, Roofing/Wallboard and Plumbing TR Index", "I:NQUSB50101025": "Nasdaq US Benchmark Building: Climate Control Index", "I:NQUSB50101025LM": "Nasdaq US Building: Climate Control Large Mid Cap Index", "I:NQUSB50101025LMN": "Nasdaq US Building: Climate Control Large Mid Cap NTR Index", "I:NQUSB50101025LMT": "Nasdaq US Building: Climate Control Large Mid Cap TR Index", "I:NQUSB50101025N": "Nasdaq US Benchmark Building: Climate Control NTR Index", "I:NQUSB50101025T": "Nasdaq US Benchmark Building: Climate Control TR Index", "I:NQUSB50101035": "Nasdaq US Benchmark Building Materials: Other Index", "I:NQUSB50101035LM": "Nasdaq US Building Materials: Other Large Mid Cap Index", "I:NQUSB50101035LMN": "Nasdaq US Building Materials: Other Large Mid Cap NTR Index", "I:NQUSB50101035LMT": "Nasdaq US Building Materials: Other Large Mid Cap TR Index", "I:NQUSB50101035N": "Nasdaq US Benchmark Building Materials: Other NTR Index", "I:NQUSB50101035T": "Nasdaq US Benchmark Building Materials: Other TR Index", "I:NQUSB5010LM": "Nasdaq US Construction and Materials Large Mid Cap Index", "I:NQUSB5010LMN": "Nasdaq US Construction and Materials Large Mid Cap NTR Index", "I:NQUSB5010LMT": "Nasdaq US Construction and Materials Large Mid Cap TR Index", "I:NQUSB5010N": "Nasdaq US Benchmark Construction and Materials NTR Index", "I:NQUSB5010T": "Nasdaq US Benchmark Construction and Materials TR Index", "I:NQUSB5020": "Nasdaq US Benchmark Industrial Goods and Services Index", "I:NQUSB502010": "Nasdaq US Benchmark Aerospace and Defense Index", "I:NQUSB50201010": "Nasdaq US Benchmark Aerospace Index", "I:NQUSB50201010LM": "Nasdaq US Aerospace Large Mid Cap Index", "I:NQUSB50201010LMN": "Nasdaq US Aerospace Large Mid Cap NTR Index", "I:NQUSB50201010LMT": "Nasdaq US Aerospace Large Mid Cap TR Index", "I:NQUSB50201010N": "Nasdaq US Benchmark Aerospace NTR Index", "I:NQUSB50201010T": "Nasdaq US Benchmark Aerospace TR Index", "I:NQUSB50201020": "Nasdaq US Benchmark Defense Index", "I:NQUSB50201020LM": "Nasdaq US Defense Large Mid Cap Index", "I:NQUSB50201020LMN": "Nasdaq US Defense Large Mid Cap NTR Index", "I:NQUSB50201020LMT": "Nasdaq US Defense Large Mid Cap TR Index", "I:NQUSB50201020N": "Nasdaq US Benchmark Defense NTR Index", "I:NQUSB50201020T": "Nasdaq US Benchmark Defense TR Index", "I:NQUSB502010LM": "Nasdaq US Aerospace and Defense Large Mid Cap Index", "I:NQUSB502010LMN": "Nasdaq US Aerospace and Defense Large Mid Cap NTR Index", "I:NQUSB502010LMT": "Nasdaq US Aerospace and Defense Large Mid Cap TR Index", "I:NQUSB502010N": "Nasdaq US Benchmark Aerospace and Defense NTR Index", "I:NQUSB502010T": "Nasdaq US Benchmark Aerospace and Defense TR Index", "I:NQUSB502020": "Nasdaq US Benchmark Electronic and Electrical Equipment Index", "I:NQUSB50202010": "Nasdaq US Benchmark Electrical Components Index", "I:NQUSB50202010N": "Nasdaq US Benchmark Electrical Components NTR Index", "I:NQUSB50202010T": "Nasdaq US Benchmark Electrical Components TR Index", "I:NQUSB50202020": "Nasdaq US Benchmark Electronic Equipment: Control and Filter Index", "I:NQUSB50202020LM": "Nasdaq US Electronic Equipment: Control and Filter Large Mid Cap Index", "I:NQUSB50202020LMN": "Nasdaq US Electronic Equipment: Control and Filter Large Mid Cap NTR Index", "I:NQUSB50202020LMT": "Nasdaq US Electronic Equipment: Control and Filter Large Mid Cap TR Index", "I:NQUSB50202020N": "Nasdaq US Benchmark Electronic Equipment: Control and Filter NTR Index", "I:NQUSB50202020T": "Nasdaq US Benchmark Electronic Equipment: Control and Filter TR Index", "I:NQUSB50202025": "Nasdaq US Benchmark Electronic Equipment: Gauges and Meters Index", "I:NQUSB50202025LM": "Nasdaq US Electronic Equipment: Gauges and Meters Large Mid Cap Index", "I:NQUSB50202025LMN": "Nasdaq US Electronic Equipment: Gauges and Meters Large Mid Cap NTR Index", "I:NQUSB50202025LMT": "Nasdaq US Electronic Equipment: Gauges and Meters Large Mid Cap TR Index", "I:NQUSB50202025N": "Nasdaq US Benchmark Electronic Equipment: Gauges and Meters NTR Index", "I:NQUSB50202025T": "Nasdaq US Benchmark Electronic Equipment: Gauges and Meters TR Index", "I:NQUSB50202040": "Nasdaq US Benchmark Electronic Equipment: Other Index", "I:NQUSB50202040N": "Nasdaq US Benchmark Electronic Equipment: Other NTR Index", "I:NQUSB50202040T": "Nasdaq US Benchmark Electronic Equipment: Other TR Index", "I:NQUSB502020LM": "Nasdaq US Electronic and Electrical Equipment Large Mid Cap Index", "I:NQUSB502020LMN": "Nasdaq US Electronic and Electrical Equipment Large Mid Cap NTR Index", "I:NQUSB502020LMT": "Nasdaq US Electronic and Electrical Equipment Large Mid Cap TR Index", "I:NQUSB502020N": "Nasdaq US Benchmark Electronic and Electrical Equipment NTR Index", "I:NQUSB502020T": "Nasdaq US Benchmark Electronic and Electrical Equipment TR Index", "I:NQUSB502030": "Nasdaq US Benchmark General Industrials Index", "I:NQUSB50203000": "Nasdaq US Benchmark Diversified Industrials Index", "I:NQUSB50203000LM": "Nasdaq US Diversified Industrials Large Mid Cap Index", "I:NQUSB50203000LMN": "Nasdaq US Diversified Industrials Large Mid Cap NTR Index", "I:NQUSB50203000LMT": "Nasdaq US Diversified Industrials Large Mid Cap TR Index", "I:NQUSB50203000N": "Nasdaq US Benchmark Diversified Industrials NTR Index", "I:NQUSB50203000T": "Nasdaq US Benchmark Diversified Industrials TR Index", "I:NQUSB50203010": "Nasdaq US Benchmark Paints and Coatings Index", "I:NQUSB50203010N": "Nasdaq US Benchmark Paints and Coatings NTR Index", "I:NQUSB50203010T": "Nasdaq US Benchmark Paints and Coatings TR Index", "I:NQUSB50203030": "Nasdaq US Benchmark Containers and Packaging Index", "I:NQUSB50203030LM": "Nasdaq US Containers and Packaging Large Mid Cap Index", "I:NQUSB50203030LMN": "Nasdaq US Containers and Packaging Large Mid Cap NTR Index", "I:NQUSB50203030LMT": "Nasdaq US Containers and Packaging Large Mid Cap TR Index", "I:NQUSB50203030N": "Nasdaq US Benchmark Containers and Packaging NTR Index", "I:NQUSB50203030T": "Nasdaq US Benchmark Containers and Packaging TR Index", "I:NQUSB502030LM": "Nasdaq US General Industrials Large Mid Cap Index", "I:NQUSB502030LMN": "Nasdaq US General Industrials Large Mid Cap NTR Index", "I:NQUSB502030LMT": "Nasdaq US General Industrials Large Mid Cap TR Index", "I:NQUSB502030N": "Nasdaq US Benchmark General Industrials NTR Index", "I:NQUSB502030T": "Nasdaq US Benchmark General Industrials TR Index", "I:NQUSB502040": "Nasdaq US Benchmark Industrial Engineering Index", "I:NQUSB50204000": "Nasdaq US Benchmark Machinery: Industrial Index", "I:NQUSB50204000LM": "Nasdaq US Machinery: Industrial Large Mid Cap Index", "I:NQUSB50204000LMN": "Nasdaq US Machinery: Industrial Large Mid Cap NTR Index", "I:NQUSB50204000LMT": "Nasdaq US Machinery: Industrial Large Mid Cap TR Index", "I:NQUSB50204000N": "Nasdaq US Benchmark Machinery: Industrial NTR Index", "I:NQUSB50204000T": "Nasdaq US Benchmark Machinery: Industrial TR Index", "I:NQUSB50204010": "Nasdaq US Benchmark Machinery: Agricultural Index", "I:NQUSB50204010N": "Nasdaq US Benchmark Machinery: Agricultural NTR Index", "I:NQUSB50204010T": "Nasdaq US Benchmark Machinery: Agricultural TR Index", "I:NQUSB50204020": "Nasdaq US Benchmark Machinery: Construction and Handling Index", "I:NQUSB50204020N": "Nasdaq US Benchmark Machinery: Construction and Handling NTR Index", "I:NQUSB50204020T": "Nasdaq US Benchmark Machinery: Construction and Handling TR Index", "I:NQUSB50204050": "Nasdaq US Benchmark Machinery: Specialty Index", "I:NQUSB50204050N": "Nasdaq US Benchmark Machinery: Specialty NTR Index", "I:NQUSB50204050T": "Nasdaq US Benchmark Machinery: Specialty TR Index", "I:NQUSB502040LM": "Nasdaq US Industrial Engineering Large Mid Cap Index", "I:NQUSB502040LMN": "Nasdaq US Industrial Engineering Large Mid Cap NTR Index", "I:NQUSB502040LMT": "Nasdaq US Industrial Engineering Large Mid Cap TR Index", "I:NQUSB502040N": "Nasdaq US Benchmark Industrial Engineering NTR Index", "I:NQUSB502040T": "Nasdaq US Benchmark Industrial Engineering TR Index", "I:NQUSB502050": "Nasdaq US Benchmark Industrial Support Services Index", "I:NQUSB50205010": "Nasdaq US Benchmark Industrial Suppliers Index", "I:NQUSB50205010LM": "Nasdaq US Industrial Suppliers Large Mid Cap Index", "I:NQUSB50205010LMN": "Nasdaq US Industrial Suppliers Large Mid Cap NTR Index", "I:NQUSB50205010LMT": "Nasdaq US Industrial Suppliers Large Mid Cap TR Index", "I:NQUSB50205010N": "Nasdaq US Benchmark Industrial Suppliers NTR Index", "I:NQUSB50205010T": "Nasdaq US Benchmark Industrial Suppliers TR Index", "I:NQUSB50205015": "Nasdaq US Benchmark Transaction Processing Services Index", "I:NQUSB50205015LM": "Nasdaq US Transaction Processing Services Large Mid Cap Index", "I:NQUSB50205015LMN": "Nasdaq US Transaction Processing Services Large Mid Cap NTR Index", "I:NQUSB50205015LMT": "Nasdaq US Transaction Processing Services Large Mid Cap TR Index", "I:NQUSB50205015N": "Nasdaq US Benchmark Transaction Processing Services NTR Index", "I:NQUSB50205015T": "Nasdaq US Benchmark Transaction Processing Services TR Index", "I:NQUSB50205020": "Nasdaq US Benchmark Professional Business Support Services Index", "I:NQUSB50205020LM": "Nasdaq US Professional Business Support Services Large Mid Cap Index", "I:NQUSB50205020LMN": "Nasdaq US Professional Business Support Services Large Mid Cap NTR Index", "I:NQUSB50205020LMT": "Nasdaq US Professional Business Support Services Large Mid Cap TR Index", "I:NQUSB50205020N": "Nasdaq US Benchmark Professional Business Support Services NTR Index", "I:NQUSB50205020T": "Nasdaq US Benchmark Professional Business Support Services TR Index", "I:NQUSB50205025": "Nasdaq US Benchmark Business Training and Employment Agencies Index", "I:NQUSB50205025LM": "Nasdaq US Business Training and Employment Agencies Large Mid Cap Index", "I:NQUSB50205025LMN": "Nasdaq US Business Training and Employment Agencies Large Mid Cap NTR Index", "I:NQUSB50205025LMT": "Nasdaq US Business Training and Employment Agencies Large Mid Cap TR Index", "I:NQUSB50205025N": "Nasdaq US Benchmark Business Training and Employment Agencies NTR Index", "I:NQUSB50205025T": "Nasdaq US Benchmark Business Training and Employment Agencies TR Index", "I:NQUSB50205030": "Nasdaq US Benchmark Forms and Bulk Printing Services Index", "I:NQUSB50205030N": "Nasdaq US Benchmark Forms and Bulk Printing Services NTR Index", "I:NQUSB50205030T": "Nasdaq US Benchmark Forms and Bulk Printing Services TR Index", "I:NQUSB50205040": "Nasdaq US Benchmark Security Services Index", "I:NQUSB50205040N": "Nasdaq US Benchmark Security Services NTR Index", "I:NQUSB50205040T": "Nasdaq US Benchmark Security Services TR Index", "I:NQUSB502050LM": "Nasdaq US Industrial Support Services Large Mid Cap Index", "I:NQUSB502050LMN": "Nasdaq US Industrial Support Services Large Mid Cap NTR Index", "I:NQUSB502050LMT": "Nasdaq US Industrial Support Services Large Mid Cap TR Index", "I:NQUSB502050N": "Nasdaq US Benchmark Industrial Support Services NTR Index", "I:NQUSB502050T": "Nasdaq US Benchmark Industrial Support Services TR Index", "I:NQUSB502060": "Nasdaq US Benchmark Industrial Transportation Index", "I:NQUSB50206010": "Nasdaq US Benchmark Trucking Index", "I:NQUSB50206010LM": "Nasdaq US Trucking Large Mid Cap Index", "I:NQUSB50206010LMN": "Nasdaq US Trucking Large Mid Cap NTR Index", "I:NQUSB50206010LMT": "Nasdaq US Trucking Large Mid Cap TR Index", "I:NQUSB50206010N": "Nasdaq US Benchmark Trucking NTR Index", "I:NQUSB50206010T": "Nasdaq US Benchmark Trucking TR Index", "I:NQUSB50206015": "Nasdaq US Benchmark Commercial Vehicles and Parts Index", "I:NQUSB50206015LM": "Nasdaq US Commercial Vehicles and Parts Large Mid Cap Index", "I:NQUSB50206015LMN": "Nasdaq US Commercial Vehicles and Parts Large Mid Cap NTR Index", "I:NQUSB50206015LMT": "Nasdaq US Commercial Vehicles and Parts Large Mid Cap TR Index", "I:NQUSB50206015N": "Nasdaq US Benchmark Commercial Vehicles and Parts NTR Index", "I:NQUSB50206015T": "Nasdaq US Benchmark Commercial Vehicles and Parts TR Index", "I:NQUSB50206020": "Nasdaq US Benchmark Railroads Index", "I:NQUSB50206020LM": "Nasdaq US Railroads Large Mid Cap Index", "I:NQUSB50206020LMN": "Nasdaq US Railroads Large Mid Cap NTR Index", "I:NQUSB50206020LMT": "Nasdaq US Railroads Large Mid Cap TR Index", "I:NQUSB50206020N": "Nasdaq US Benchmark Railroads NTR Index", "I:NQUSB50206020T": "Nasdaq US Benchmark Railroads TR Index", "I:NQUSB50206030": "Nasdaq US Benchmark Marine Transportation Index", "I:NQUSB50206030N": "Nasdaq US Benchmark Marine Transportation NTR Index", "I:NQUSB50206030T": "Nasdaq US Benchmark Marine Transportation TR Index", "I:NQUSB50206040": "Nasdaq US Benchmark Delivery Services Index", "I:NQUSB50206040N": "Nasdaq US Benchmark Delivery Services NTR Index", "I:NQUSB50206040T": "Nasdaq US Benchmark Delivery Services TR Index", "I:NQUSB50206050": "Nasdaq US Benchmark Commercial Vehicle-Equipment Leasing Index", "I:NQUSB50206050N": "Nasdaq US Benchmark Commercial Vehicle-Equipment Leasing NTR Index", "I:NQUSB50206050T": "Nasdaq US Benchmark Commercial Vehicle-Equipment Leasing TR Index", "I:NQUSB50206060": "Nasdaq US Benchmark Transportation Services Index", "I:NQUSB50206060LM": "Nasdaq US Transportation Services Large Mid Cap Index", "I:NQUSB50206060LMN": "Nasdaq US Transportation Services Large Mid Cap NTR Index", "I:NQUSB50206060LMT": "Nasdaq US Transportation Services Large Mid Cap TR Index", "I:NQUSB50206060N": "Nasdaq US Benchmark Transportation Services NTR Index", "I:NQUSB50206060T": "Nasdaq US Benchmark Transportation Services TR Index", "I:NQUSB502060LM": "Nasdaq US Industrial Transportation Large Mid Cap Index", "I:NQUSB502060LMN": "Nasdaq US Industrial Transportation Large Mid Cap NTR Index", "I:NQUSB502060LMT": "Nasdaq US Industrial Transportation Large Mid Cap TR Index", "I:NQUSB502060N": "Nasdaq US Benchmark Industrial Transportation NTR Index", "I:NQUSB502060T": "Nasdaq US Benchmark Industrial Transportation TR Index", "I:NQUSB5020LM": "Nasdaq US Industrial Goods and Services Large Mid Cap Index", "I:NQUSB5020LMN": "Nasdaq US Industrial Goods and Services Large Mid Cap NTR Index", "I:NQUSB5020LMT": "Nasdaq US Industrial Goods and Services Large Mid Cap TR Index", "I:NQUSB5020N": "Nasdaq US Benchmark Industrial Goods and Services NTR Index", "I:NQUSB5020T": "Nasdaq US Benchmark Industrial Goods and Services TR Index", "I:NQUSB50LM": "Nasdaq US Industrials Large Mid Cap Index", "I:NQUSB50LMN": "Nasdaq US Industrials Large Mid Cap NTR Index", "I:NQUSB50LMT": "Nasdaq US Industrials Large Mid Cap TR Index", "I:NQUSB50N": "Nasdaq US Benchmark Industrials NTR Index", "I:NQUSB50T": "Nasdaq US Benchmark Industrials TR Index", "I:NQUSB55": "Nasdaq US Benchmark Basic Materials Index", "I:NQUSB5510": "Nasdaq US Benchmark Basic Resources Index", "I:NQUSB551010": "Nasdaq US Benchmark Industrial Materials Index", "I:NQUSB55101000": "Nasdaq US Benchmark Diversified Materials Index", "I:NQUSB55101000N": "Nasdaq US Benchmark Diversified Materials NTR Index", "I:NQUSB55101000T": "Nasdaq US Benchmark Diversified Materials TR Index", "I:NQUSB55101015": "Nasdaq US Benchmark Paper Index", "I:NQUSB55101015N": "Nasdaq US Benchmark Paper NTR Index", "I:NQUSB55101015T": "Nasdaq US Benchmark Paper TR Index", "I:NQUSB551010LM": "Nasdaq US Industrial Materials Large Mid Cap Index", "I:NQUSB551010LMN": "Nasdaq US Industrial Materials Large Mid Cap NTR Index", "I:NQUSB551010LMT": "Nasdaq US Industrial Materials Large Mid Cap TR Index", "I:NQUSB551010N": "Nasdaq US Benchmark Industrial Materials NTR Index", "I:NQUSB551010T": "Nasdaq US Benchmark Industrial Materials TR Index", "I:NQUSB551020": "Nasdaq US Benchmark Industrial Metals and Mining Index", "I:NQUSB55102000": "Nasdaq US Benchmark General Mining Index", "I:NQUSB55102000N": "Nasdaq US Benchmark General Mining NTR Index", "I:NQUSB55102000T": "Nasdaq US Benchmark General Mining TR Index", "I:NQUSB55102010": "Nasdaq US Benchmark Iron and Steel Index", "I:NQUSB55102010LM": "Nasdaq US Iron and Steel Large Mid Cap Index", "I:NQUSB55102010LMN": "Nasdaq US Iron and Steel Large Mid Cap NTR Index", "I:NQUSB55102010LMT": "Nasdaq US Iron and Steel Large Mid Cap TR Index", "I:NQUSB55102010N": "Nasdaq US Benchmark Iron and Steel NTR Index", "I:NQUSB55102010T": "Nasdaq US Benchmark Iron and Steel TR Index", "I:NQUSB55102015": "Nasdaq US Benchmark Metal Fabricating Index", "I:NQUSB55102015N": "Nasdaq US Benchmark Metal Fabricating NTR Index", "I:NQUSB55102015T": "Nasdaq US Benchmark Metal Fabricating TR Index", "I:NQUSB551020LM": "Nasdaq US Industrial Metals and Mining Large Mid Cap Index", "I:NQUSB551020LMN": "Nasdaq US Industrial Metals and Mining Large Mid Cap NTR Index", "I:NQUSB551020LMT": "Nasdaq US Industrial Metals and Mining Large Mid Cap TR Index", "I:NQUSB551020N": "Nasdaq US Benchmark Industrial Metals and Mining NTR Index", "I:NQUSB551020T": "Nasdaq US Benchmark Industrial Metals and Mining TR Index", "I:NQUSB551030": "Nasdaq US Benchmark Precious Metals and Mining Index", "I:NQUSB55103025": "Nasdaq US Benchmark Gold Mining Index", "I:NQUSB55103025N": "Nasdaq US Benchmark Gold Mining NTR Index", "I:NQUSB55103025T": "Nasdaq US Benchmark Gold Mining TR Index", "I:NQUSB551030LM": "Nasdaq US Precious Metals and Mining Large Mid Cap Index", "I:NQUSB551030LMN": "Nasdaq US Precious Metals and Mining Large Mid Cap NTR Index", "I:NQUSB551030LMT": "Nasdaq US Precious Metals and Mining Large Mid Cap TR Index", "I:NQUSB551030N": "Nasdaq US Benchmark Precious Metals and Mining NTR Index", "I:NQUSB551030T": "Nasdaq US Benchmark Precious Metals and Mining TR Index", "I:NQUSB5510LM": "Nasdaq US Basic Resources Large Mid Cap Index", "I:NQUSB5510LMN": "Nasdaq US Basic Resources Large Mid Cap NTR Index", "I:NQUSB5510LMT": "Nasdaq US Basic Resources Large Mid Cap TR Index", "I:NQUSB5510N": "Nasdaq US Benchmark Basic Resources NTR Index", "I:NQUSB5510T": "Nasdaq US Benchmark Basic Resources TR Index", "I:NQUSB5520": "Nasdaq US Benchmark Chemicals Index", "I:NQUSB55201000": "Nasdaq US Benchmark Chemicals: Diversified Index", "I:NQUSB55201000LM": "Nasdaq US Chemicals: Diversified Large Mid Cap Index", "I:NQUSB55201000LMN": "Nasdaq US Chemicals: Diversified Large Mid Cap NTR Index", "I:NQUSB55201000LMT": "Nasdaq US Chemicals: Diversified Large Mid Cap TR Index", "I:NQUSB55201000N": "Nasdaq US Benchmark Chemicals: Diversified NTR Index", "I:NQUSB55201000T": "Nasdaq US Benchmark Chemicals: Diversified TR Index", "I:NQUSB55201015": "Nasdaq US Benchmark Fertilizers Index", "I:NQUSB55201015N": "Nasdaq US Benchmark Fertilizers NTR Index", "I:NQUSB55201015T": "Nasdaq US Benchmark Fertilizers TR Index", "I:NQUSB55201020": "Nasdaq US Benchmark Specialty Chemicals Index", "I:NQUSB55201020LM": "Nasdaq US Specialty Chemicals Large Mid Cap Index", "I:NQUSB55201020LMN": "Nasdaq US Specialty Chemicals Large Mid Cap NTR Index", "I:NQUSB55201020LMT": "Nasdaq US Specialty Chemicals Large Mid Cap TR Index", "I:NQUSB55201020N": "Nasdaq US Benchmark Specialty Chemicals NTR Index", "I:NQUSB55201020T": "Nasdaq US Benchmark Specialty Chemicals TR Index", "I:NQUSB5520LM": "Nasdaq US Chemicals Large Mid Cap Index", "I:NQUSB5520LMN": "Nasdaq US Chemicals Large Mid Cap NTR Index", "I:NQUSB5520LMT": "Nasdaq US Chemicals Large Mid Cap TR Index", "I:NQUSB5520N": "Nasdaq US Benchmark Chemicals NTR Index", "I:NQUSB5520T": "Nasdaq US Benchmark Chemicals TR Index", "I:NQUSB55LM": "Nasdaq US Basic Materials Large Mid Cap Index", "I:NQUSB55LMN": "Nasdaq US Basic Materials Large Mid Cap NTR Index", "I:NQUSB55LMT": "Nasdaq US Basic Materials Large Mid Cap TR Index", "I:NQUSB55N": "Nasdaq US Benchmark Basic Materials NTR Index", "I:NQUSB55T": "Nasdaq US Benchmark Basic Materials TR Index", "I:NQUSB60": "Nasdaq US Benchmark Energy Index", "I:NQUSB601010": "Nasdaq US Benchmark Oil, Gas and Coal Index", "I:NQUSB60101000": "Nasdaq US Benchmark Integrated Oil and Gas Index", "I:NQUSB60101000LM": "Nasdaq US Integrated Oil and Gas Large Mid Cap Index", "I:NQUSB60101000LMN": "Nasdaq US Integrated Oil and Gas Large Mid Cap NTR Index", "I:NQUSB60101000LMT": "Nasdaq US Integrated Oil and Gas Large Mid Cap TR Index", "I:NQUSB60101000N": "Nasdaq US Benchmark Integrated Oil and Gas NTR Index", "I:NQUSB60101000T": "Nasdaq US Benchmark Integrated Oil and Gas TR Index", "I:NQUSB60101010": "Nasdaq US Benchmark Oil: Crude Producers Index", "I:NQUSB60101010LM": "Nasdaq US Oil: Crude Producers Large Mid Cap Index", "I:NQUSB60101010LMN": "Nasdaq US Oil: Crude Producers Large Mid Cap NTR Index", "I:NQUSB60101010LMT": "Nasdaq US Oil: Crude Producers Large Mid Cap TR Index", "I:NQUSB60101010N": "Nasdaq US Benchmark Oil: Crude Producers NTR Index", "I:NQUSB60101010T": "Nasdaq US Benchmark Oil: Crude Producers TR Index", "I:NQUSB60101015": "Nasdaq US Benchmark Offshore Drilling and Other Services Index", "I:NQUSB60101015N": "Nasdaq US Benchmark Offshore Drilling and Other Services NTR Index", "I:NQUSB60101015T": "Nasdaq US Benchmark Offshore Drilling and Other Services TR Index", "I:NQUSB60101020": "Nasdaq US Benchmark Oil Refining and Marketing Index", "I:NQUSB60101020N": "Nasdaq US Benchmark Oil Refining and Marketing NTR Index", "I:NQUSB60101020T": "Nasdaq US Benchmark Oil Refining and Marketing TR Index", "I:NQUSB60101030": "Nasdaq US Benchmark Oil Equipment and Services Index", "I:NQUSB60101030LM": "Nasdaq US Oil Equipment and Services Large Mid Cap Index", "I:NQUSB60101030LMN": "Nasdaq US Oil Equipment and Services Large Mid Cap NTR Index", "I:NQUSB60101030LMT": "Nasdaq US Oil Equipment and Services Large Mid Cap TR Index", "I:NQUSB60101030N": "Nasdaq US Benchmark Oil Equipment and Services NTR Index", "I:NQUSB60101030T": "Nasdaq US Benchmark Oil Equipment and Services TR Index", "I:NQUSB60101035": "Nasdaq US Benchmark Pipelines Index", "I:NQUSB60101035LM": "Nasdaq US Pipelines Large Mid Cap Index", "I:NQUSB60101035LMN": "Nasdaq US Pipelines Large Mid Cap NTR Index", "I:NQUSB60101035LMT": "Nasdaq US Pipelines Large Mid Cap TR Index", "I:NQUSB60101035N": "Nasdaq US Benchmark Pipelines NTR Index", "I:NQUSB60101035T": "Nasdaq US Benchmark Pipelines TR Index", "I:NQUSB60101040": "Nasdaq US Benchmark Coal Index", "I:NQUSB60101040N": "Nasdaq US Benchmark Coal NTR Index", "I:NQUSB60101040T": "Nasdaq US Benchmark Coal TR Index", "I:NQUSB601010LM": "Nasdaq US Oil, Gas and Coal Large Mid Cap Index", "I:NQUSB601010LMN": "Nasdaq US Oil, Gas and Coal Large Mid Cap NTR Index", "I:NQUSB601010LMT": "Nasdaq US Oil, Gas and Coal Large Mid Cap TR Index", "I:NQUSB601010N": "Nasdaq US Benchmark Oil, Gas and Coal NTR Index", "I:NQUSB601010T": "Nasdaq US Benchmark Oil, Gas and Coal TR Index", "I:NQUSB601020": "Nasdaq US Benchmark Alternative Energy Index", "I:NQUSB60102010": "Nasdaq US Benchmark Alternative Fuels Index", "I:NQUSB60102010N": "Nasdaq US Benchmark Alternative Fuels NTR Index", "I:NQUSB60102010T": "Nasdaq US Benchmark Alternative Fuels TR Index", "I:NQUSB60102020": "Nasdaq US Benchmark Renewable Energy Equipment Index", "I:NQUSB60102020LM": "Nasdaq US Renewable Energy Equipment Large Mid Cap Index", "I:NQUSB60102020LMN": "Nasdaq US Renewable Energy Equipment Large Mid Cap NTR Index", "I:NQUSB60102020LMT": "Nasdaq US Renewable Energy Equipment Large Mid Cap TR Index", "I:NQUSB60102020N": "Nasdaq US Benchmark Renewable Energy Equipment NTR Index", "I:NQUSB60102020T": "Nasdaq US Benchmark Renewable Energy Equipment TR Index", "I:NQUSB601020LM": "Nasdaq US Alternative Energy Large Mid Cap Index", "I:NQUSB601020LMN": "Nasdaq US Alternative Energy Large Mid Cap NTR Index", "I:NQUSB601020LMT": "Nasdaq US Alternative Energy Large Mid Cap TR Index", "I:NQUSB601020N": "Nasdaq US Benchmark Alternative Energy NTR Index", "I:NQUSB601020T": "Nasdaq US Benchmark Alternative Energy TR Index", "I:NQUSB60LM": "Nasdaq US Energy Large Mid Cap Index", "I:NQUSB60LMN": "Nasdaq US Energy Large Mid Cap NTR Index", "I:NQUSB60LMT": "Nasdaq US Energy Large Mid Cap TR Index", "I:NQUSB60N": "Nasdaq US Benchmark Energy NTR Index", "I:NQUSB60T": "Nasdaq US Benchmark Energy TR Index", "I:NQUSB65": "Nasdaq US Benchmark Utilities Index", "I:NQUSB651010": "Nasdaq US Benchmark Electricity Index", "I:NQUSB65101010": "Nasdaq US Benchmark Alternative Electricity Index", "I:NQUSB65101010N": "Nasdaq US Benchmark Alternative Electricity NTR Index", "I:NQUSB65101010T": "Nasdaq US Benchmark Alternative Electricity TR Index", "I:NQUSB65101015": "Nasdaq US Benchmark Conventional Electricity Index", "I:NQUSB65101015LM": "Nasdaq US Conventional Electricity Large Mid Cap Index", "I:NQUSB65101015LMN": "Nasdaq US Conventional Electricity Large Mid Cap NTR Index", "I:NQUSB65101015LMT": "Nasdaq US Conventional Electricity Large Mid Cap TR Index", "I:NQUSB65101015N": "Nasdaq US Benchmark Conventional Electricity NTR Index", "I:NQUSB65101015T": "Nasdaq US Benchmark Conventional Electricity TR Index", "I:NQUSB651010LM": "Nasdaq US Electricity Large Mid Cap Index", "I:NQUSB651010LMN": "Nasdaq US Electricity Large Mid Cap NTR Index", "I:NQUSB651010LMT": "Nasdaq US Electricity Large Mid Cap TR Index", "I:NQUSB651010N": "Nasdaq US Benchmark Electricity NTR Index", "I:NQUSB651010T": "Nasdaq US Benchmark Electricity TR Index", "I:NQUSB651020": "Nasdaq US Benchmark Gas, Water and Multi-utilities Index", "I:NQUSB65102000": "Nasdaq US Benchmark Multi-utilities Index", "I:NQUSB65102000LM": "Nasdaq US Multi-utilities Large Mid Cap Index", "I:NQUSB65102000LMN": "Nasdaq US Multi-utilities Large Mid Cap NTR Index", "I:NQUSB65102000LMT": "Nasdaq US Multi-utilities Large Mid Cap TR Index", "I:NQUSB65102000N": "Nasdaq US Benchmark Multi-utilities NTR Index", "I:NQUSB65102000T": "Nasdaq US Benchmark Multi-utilities TR Index", "I:NQUSB65102020": "Nasdaq US Benchmark Gas Distribution Index", "I:NQUSB65102020LM": "Nasdaq US Gas Distribution Large Mid Cap Index", "I:NQUSB65102020LMN": "Nasdaq US Gas Distribution Large Mid Cap NTR Index", "I:NQUSB65102020LMT": "Nasdaq US Gas Distribution Large Mid Cap TR Index", "I:NQUSB65102020N": "Nasdaq US Benchmark Gas Distribution NTR Index", "I:NQUSB65102020T": "Nasdaq US Benchmark Gas Distribution TR Index", "I:NQUSB65102030": "Nasdaq US Benchmark Water Index", "I:NQUSB65102030N": "Nasdaq US Benchmark Water NTR Index", "I:NQUSB65102030T": "Nasdaq US Benchmark Water TR Index", "I:NQUSB651020LM": "Nasdaq US Gas, Water and Multi-utilities Large Mid Cap Index", "I:NQUSB651020LMN": "Nasdaq US Gas, Water and Multi-utilities Large Mid Cap NTR Index", "I:NQUSB651020LMT": "Nasdaq US Gas, Water and Multi-utilities Large Mid Cap TR Index", "I:NQUSB651020N": "Nasdaq US Benchmark Gas, Water and Multi-utilities NTR Index", "I:NQUSB651020T": "Nasdaq US Benchmark Gas, Water and Multi-utilities TR Index", "I:NQUSB651030": "Nasdaq US Benchmark Waste and Disposal Services Index", "I:NQUSB651030LM": "Nasdaq US Waste and Disposal Services Large Mid Cap Index", "I:NQUSB651030LMN": "Nasdaq US Waste and Disposal Services Large Mid Cap NTR Index", "I:NQUSB651030LMT": "Nasdaq US Waste and Disposal Services Large Mid Cap TR Index", "I:NQUSB651030N": "Nasdaq US Benchmark Waste and Disposal Services NTR Index", "I:NQUSB651030T": "Nasdaq US Benchmark Waste and Disposal Services TR Index", "I:NQUSB65LM": "Nasdaq US Utilities Large Mid Cap Index", "I:NQUSB65LMN": "Nasdaq US Utilities Large Mid Cap NTR Index", "I:NQUSB65LMT": "Nasdaq US Utilities Large Mid Cap TR Index", "I:NQUSB65N": "Nasdaq US Benchmark Utilities NTR Index", "I:NQUSB65T": "Nasdaq US Benchmark Utilities TR Index", "I:NQUSBLM": "NASDAQ US  Large Mid Cap Index", "I:NQUSBLMN": "NASDAQ US  Large Mid Cap NTR Index", "I:NQUSBLMT": "NASDAQ US  Large Mid Cap TR Index", "I:NQUSBN": "NASDAQ US Bnchmk NTR Index", "I:NQUSBT": "NASDAQ US Benchmark TR Index", "I:NQUSCHK": "NASDAQ Chaikin Power US Small Cap Index", "I:NQUSCHKT": "NASDAQ Chaikin Power US Small Cap TR", "I:NQUSHEI": "Nasdaq US High Equity Income Index", "I:NQUSHEIEUR": "Nasdaq US High Equity Income EUR Index", "I:NQUSHEIEURN": "Nasdaq US High Equity Income EUR Net Total Return", "I:NQUSHEIEURT": "Nasdaq US High Equity Income EUR Total Return Inde", "I:NQUSHEIGBP": "Nasdaq US High Equity Income GBP Index", "I:NQUSHEIGBPN": "Nasdaq US High Equity Income GBP Net Total Return", "I:NQUSHEIGBPT": "Nasdaq US High Equity Income GBP Total Return Inde", "I:NQUSHEIN": "Nasdaq US High Equity Income Net Total Return Inde", "I:NQUSHEIT": "Nasdaq US High Equity Income Total Return Index", "I:NQUSL": "NASDAQ US Large Cap Index", "I:NQUSL10": "Nasdaq US Large Cap Technology Index", "I:NQUSL101010": "Nasdaq US Large Cap Software and Computer Services Index", "I:NQUSL10101010": "Nasdaq US Large Cap Computer Services Index", "I:NQUSL10101010N": "Nasdaq US Large Cap Computer Services NTR Index", "I:NQUSL10101010T": "Nasdaq US Large Cap Computer Services TR Index", "I:NQUSL10101015": "Nasdaq US Large Cap Software Index", "I:NQUSL10101015N": "Nasdaq US Large Cap Software NTR Index", "I:NQUSL10101015T": "Nasdaq US Large Cap Software TR Index", "I:NQUSL10101020": "Nasdaq US Large Cap Consumer Digital Services Index", "I:NQUSL10101020N": "Nasdaq US Large Cap Consumer Digital Services NTR Index", "I:NQUSL10101020T": "Nasdaq US Large Cap Consumer Digital Services TR Index", "I:NQUSL101010N": "Nasdaq US Large Cap Software and Computer Services NTR Index", "I:NQUSL101010T": "Nasdaq US Large Cap Software and Computer Services TR Index", "I:NQUSL101020": "Nasdaq US Large Cap Technology Hardware and Equipment Index", "I:NQUSL10102010": "Nasdaq US Large Cap Semiconductors Index", "I:NQUSL10102010N": "Nasdaq US Large Cap Semiconductors NTR Index", "I:NQUSL10102010T": "Nasdaq US Large Cap Semiconductors TR Index", "I:NQUSL10102030": "Nasdaq US Large Cap Computer Hardware Index", "I:NQUSL10102030N": "Nasdaq US Large Cap Computer Hardware NTR Index", "I:NQUSL10102030T": "Nasdaq US Large Cap Computer Hardware TR Index", "I:NQUSL101020N": "Nasdaq US Large Cap Technology Hardware and Equipment NTR Index", "I:NQUSL101020T": "Nasdaq US Large Cap Technology Hardware and Equipment TR Index", "I:NQUSL10N": "Nasdaq US Large Cap Technology NTR Index", "I:NQUSL10T": "Nasdaq US Large Cap Technology TR Index", "I:NQUSL15": "Nasdaq US Large Cap Telecommunications Index", "I:NQUSL151010": "Nasdaq US Large Cap Telecommunications Equipment Index", "I:NQUSL151010N": "Nasdaq US Large Cap Telecommunications Equipment NTR Index", "I:NQUSL151010T": "Nasdaq US Large Cap Telecommunications Equipment TR Index", "I:NQUSL151020": "Nasdaq US Large Cap Telecommunications Service Providers Index", "I:NQUSL15102010": "Nasdaq Large Cap Cable Television Services Index", "I:NQUSL15102010N": "Nasdaq Large Cap Cable Television Services NTR Index", "I:NQUSL15102010T": "Nasdaq Large Cap Cable Television Services TR Index", "I:NQUSL151020N": "Nasdaq US Large Cap Telecommunications Service Providers NTR Index", "I:NQUSL151020T": "Nasdaq US Large Cap Telecommunications Service Providers TR Index", "I:NQUSL15N": "Nasdaq US Large Cap Telecommunications NTR Index", "I:NQUSL15T": "Nasdaq US Large Cap Telecommunications TR Index", "I:NQUSL20": "Nasdaq US Large Cap Health Care Index", "I:NQUSL201010": "Nasdaq US Large Cap Health Care Providers Index", "I:NQUSL20101020": "Nasdaq Large Cap Health Care Management Services Index", "I:NQUSL20101020N": "Nasdaq Large Cap Health Care Management Services NTR Index", "I:NQUSL20101020T": "Nasdaq Large Cap Health Care Management Services TR Index", "I:NQUSL201010N": "Nasdaq US Large Cap Health Care Providers NTR Index", "I:NQUSL201010T": "Nasdaq US Large Cap Health Care Providers TR Index", "I:NQUSL201020": "Nasdaq US Large Cap Medical Equipment and Services Index", "I:NQUSL20102010": "Nasdaq US Large Cap Medical Equipment Index", "I:NQUSL20102010N": "Nasdaq US Large Cap Medical Equipment NTR Index", "I:NQUSL20102010T": "Nasdaq US Large Cap Medical Equipment TR Index", "I:NQUSL20102015": "Nasdaq US Large Cap Medical Supplies Index", "I:NQUSL20102015N": "Nasdaq US Large Cap Medical Supplies NTR Index", "I:NQUSL20102015T": "Nasdaq US Large Cap Medical Supplies TR Index", "I:NQUSL201020N": "Nasdaq US Large Cap Medical Equipment and Services NTR Index", "I:NQUSL201020T": "Nasdaq US Large Cap Medical Equipment and Services TR Index", "I:NQUSL201030": "Nasdaq US Large Cap Pharmaceuticals and Biotechnology Index", "I:NQUSL20103010": "Nasdaq US Large Cap Biotechnology Index", "I:NQUSL20103010N": "Nasdaq US Large Cap Biotechnology NTR Index", "I:NQUSL20103010T": "Nasdaq US Large Cap Biotechnology TR Index", "I:NQUSL20103015": "Nasdaq US Large Cap Pharmaceuticals Index", "I:NQUSL20103015N": "Nasdaq US Large Cap Pharmaceuticals NTR Index", "I:NQUSL20103015T": "Nasdaq US Large Cap Pharmaceuticals TR Index", "I:NQUSL201030N": "Nasdaq US Large Cap Pharmaceuticals and Biotechnology NTR Index", "I:NQUSL201030T": "Nasdaq US Large Cap Pharmaceuticals and Biotechnology TR Index", "I:NQUSL20N": "Nasdaq US Large Cap Health Care NTR Index", "I:NQUSL20T": "Nasdaq US Large Cap Health Care TR Index", "I:NQUSL30": "Nasdaq US Large Cap Financials Index", "I:NQUSL300": "NASDAQ US 300 Index", "I:NQUSL300N": "NASDAQ US 300 NTR Index", "I:NQUSL300T": "NASDAQ US 300 TR Index", "I:NQUSL3010": "Nasdaq US Large Cap Banks Index", "I:NQUSL3010N": "Nasdaq US Large Cap Banks NTR Index", "I:NQUSL3010T": "Nasdaq US Large Cap Banks TR Index", "I:NQUSL3020": "Nasdaq US Large Cap Financial Services Index", "I:NQUSL302020": "Nasdaq US Large Cap Investment Banking and Brokerage Services Index", "I:NQUSL30202000": "Nasdaq US Large Cap Diversified Financial Services Index", "I:NQUSL30202000N": "Nasdaq US Large Cap Diversified Financial Services NTR Index", "I:NQUSL30202000T": "Nasdaq US Large Cap Diversified Financial Services TR Index", "I:NQUSL30202010": "Nasdaq US Large Cap Asset Managers and Custodians Index", "I:NQUSL30202010N": "Nasdaq US Large Cap Asset Managers and Custodians NTR Index", "I:NQUSL30202010T": "Nasdaq US Large Cap Asset Managers and Custodians TR Index", "I:NQUSL30202015": "Nasdaq US Large Cap Investment Services Index", "I:NQUSL30202015N": "Nasdaq US Large Cap Investment Services NTR Index", "I:NQUSL30202015T": "Nasdaq US Large Cap Investment Services TR Index", "I:NQUSL302020N": "Nasdaq US Large Cap Investment Banking and Brokerage Services NTR Index", "I:NQUSL302020T": "Nasdaq US Large Cap Investment Banking and Brokerage Services TR Index", "I:NQUSL3020N": "Nasdaq US Large Cap Financial Services NTR Index", "I:NQUSL3020T": "Nasdaq US Large Cap Financial Services TR Index", "I:NQUSL3030": "Nasdaq US Large Cap Insurance Index", "I:NQUSL303010": "Nasdaq US Large Cap Life Insurance Index", "I:NQUSL303010N": "Nasdaq US Large Cap Life Insurance NTR Index", "I:NQUSL303010T": "Nasdaq US Large Cap Life Insurance TR Index", "I:NQUSL303020": "Nasdaq US Large Cap Non-life Insurance Index", "I:NQUSL30302025": "Nasdaq US Large Cap Property and Casualty Insurance Index", "I:NQUSL30302025N": "Nasdaq US Large Cap Property and Casualty Insurance NTR Index", "I:NQUSL30302025T": "Nasdaq US Large Cap Property and Casualty Insurance TR Index", "I:NQUSL303020N": "Nasdaq US Large Cap Non-life Insurance NTR Index", "I:NQUSL303020T": "Nasdaq US Large Cap Non-life Insurance TR Index", "I:NQUSL3030N": "Nasdaq US Large Cap Insurance NTR Index", "I:NQUSL3030T": "Nasdaq US Large Cap Insurance TR Index", "I:NQUSL30N": "Nasdaq US Large Cap Financials NTR Index", "I:NQUSL30T": "Nasdaq US Large Cap Financials TR Index", "I:NQUSL35": "Nasdaq US Large Cap Real Estate Index", "I:NQUSL351020": "Nasdaq US Large Cap Real Estate Investment Trusts Index", "I:NQUSL35102030": "Nasdaq Large Cap Office REITs Index", "I:NQUSL35102030N": "Nasdaq Large Cap Office REITs NTR Index", "I:NQUSL35102030T": "Nasdaq Large Cap Office REITs TR Index", "I:NQUSL35102040": "Nasdaq US Large Cap Residential REITs Index", "I:NQUSL35102040N": "Nasdaq US Large Cap Residential REITs NTR Index", "I:NQUSL35102040T": "Nasdaq US Large Cap Residential REITs TR Index", "I:NQUSL35102045": "Nasdaq US Large Cap Retail REITs Index", "I:NQUSL35102045N": "Nasdaq US Large Cap Retail REITs NTR Index", "I:NQUSL35102045T": "Nasdaq US Large Cap Retail REITs TR Index", "I:NQUSL35102070": "Nasdaq Large Cap Other Specialty REITs Index", "I:NQUSL35102070N": "Nasdaq Large Cap Other Specialty REITs NTR Index", "I:NQUSL35102070T": "Nasdaq Large Cap Other Specialty REITs TR Index", "I:NQUSL351020N": "Nasdaq US Large Cap Real Estate Investment Trusts NTR Index", "I:NQUSL351020T": "Nasdaq US Large Cap Real Estate Investment Trusts TR Index", "I:NQUSL35N": "Nasdaq US Large Cap Real Estate NTR Index", "I:NQUSL35T": "Nasdaq US Large Cap Real Estate TR Index", "I:NQUSL40": "Nasdaq US Large Cap Consumer Discretionary Index", "I:NQUSL4010": "Nasdaq US Large Cap Automobiles and Parts Index", "I:NQUSL40101020": "Nasdaq US Large Cap Automobiles Index", "I:NQUSL40101020N": "Nasdaq US Large Cap Automobiles NTR Index", "I:NQUSL40101020T": "Nasdaq US Large Cap Automobiles TR Index", "I:NQUSL4010N": "Nasdaq US Large Cap Automobiles and Parts NTR Index", "I:NQUSL4010T": "Nasdaq US Large Cap Automobiles and Parts TR Index", "I:NQUSL4020": "Nasdaq US Large Cap Consumer Products and Services Index", "I:NQUSL402020": "Nasdaq US Large Cap Household Goods and Home Construction Index", "I:NQUSL402020N": "Nasdaq US Large Cap Household Goods and Home Construction NTR Index", "I:NQUSL402020T": "Nasdaq US Large Cap Household Goods and Home Construction TR Index", "I:NQUSL402030": "Nasdaq US Large Cap Leisure Goods Index", "I:NQUSL402030N": "Nasdaq US Large Cap Leisure Goods NTR Index", "I:NQUSL402030T": "Nasdaq US Large Cap Leisure Goods TR Index", "I:NQUSL402040": "Nasdaq US Large Cap Personal Goods Index", "I:NQUSL402040N": "Nasdaq US Large Cap Personal Goods NTR Index", "I:NQUSL402040T": "Nasdaq US Large Cap Personal Goods TR Index", "I:NQUSL4020N": "Nasdaq US Large Cap Consumer Products and Services NTR Index", "I:NQUSL4020T": "Nasdaq US Large Cap Consumer Products and Services TR Index", "I:NQUSL4030": "Nasdaq US Large Cap Media Index", "I:NQUSL40301035": "Nasdaq Large Cap Radio and TV Broadcasters Index", "I:NQUSL40301035N": "Nasdaq Large Cap Radio and TV Broadcasters NTR Index", "I:NQUSL40301035T": "Nasdaq Large Cap Radio and TV Broadcasters TR Index", "I:NQUSL4030N": "Nasdaq US Large Cap Media NTR Index", "I:NQUSL4030T": "Nasdaq US Large Cap Media TR Index", "I:NQUSL4040": "Nasdaq US Large Cap Retail Index", "I:NQUSL404010": "Nasdaq US Large Cap Retailers Index", "I:NQUSL40401010": "Nasdaq US Large Cap Diversified Retailers Index", "I:NQUSL40401010N": "Nasdaq US Large Cap Diversified Retailers NTR Index", "I:NQUSL40401010T": "Nasdaq US Large Cap Diversified Retailers TR Index", "I:NQUSL40401020": "Nasdaq US Large Cap Apparel Retailers Index", "I:NQUSL40401020N": "Nasdaq US Large Cap Apparel Retailers NTR Index", "I:NQUSL40401020T": "Nasdaq US Large Cap Apparel Retailers TR Index", "I:NQUSL40401030": "Nasdaq US Large Cap Specialty Retailers Index", "I:NQUSL40401030N": "Nasdaq US Large Cap Specialty Retailers NTR Index", "I:NQUSL40401030T": "Nasdaq US Large Cap Specialty Retailers TR Index", "I:NQUSL404010N": "Nasdaq US Large Cap Retailers NTR Index", "I:NQUSL404010T": "Nasdaq US Large Cap Retailers TR Index", "I:NQUSL4040N": "Nasdaq US Large Cap Retail NTR Index", "I:NQUSL4040T": "Nasdaq US Large Cap Retail TR Index", "I:NQUSL4050": "Nasdaq US Large Cap Travel and Leisure Index", "I:NQUSL40501010": "Nasdaq US Large Cap Airlines Index", "I:NQUSL40501010N": "Nasdaq US Large Cap Airlines NTR Index", "I:NQUSL40501010T": "Nasdaq US Large Cap Airlines TR Index", "I:NQUSL40501015": "Nasdaq US Large Cap Travel and Tourism Index", "I:NQUSL40501015N": "Nasdaq US Large Cap Travel and Tourism NTR Index", "I:NQUSL40501015T": "Nasdaq US Large Cap Travel and Tourism TR Index", "I:NQUSL40501040": "Nasdaq US Large Cap Restaurants and Bars Index", "I:NQUSL40501040N": "Nasdaq US Large Cap Restaurants and Bars NTR Index", "I:NQUSL40501040T": "Nasdaq US Large Cap Restaurants and Bars TR Index", "I:NQUSL4050N": "Nasdaq US Large Cap Travel and Leisure NTR Index", "I:NQUSL4050T": "Nasdaq US Large Cap Travel and Leisure TR Index", "I:NQUSL40N": "Nasdaq US Large Cap Consumer Discretionary NTR Index", "I:NQUSL40T": "Nasdaq US Large Cap Consumer Discretionary TR Index", "I:NQUSL45": "Nasdaq US Large Cap Consumer Staples Index", "I:NQUSL4510": "Nasdaq US Large Cap Food, Beverage and Tobacco Index", "I:NQUSL451010": "Nasdaq US Large Cap Beverages Index", "I:NQUSL45101020": "Nasdaq US Large Cap Soft Drinks Index", "I:NQUSL45101020N": "Nasdaq US Large Cap Soft Drinks NTR Index", "I:NQUSL45101020T": "Nasdaq US Large Cap Soft Drinks TR Index", "I:NQUSL451010N": "Nasdaq US Large Cap Beverages NTR Index", "I:NQUSL451010T": "Nasdaq US Large Cap Beverages TR Index", "I:NQUSL451020": "Nasdaq US Large Cap Food Producers Index", "I:NQUSL45102020": "Nasdaq US Large Cap Food Products Index", "I:NQUSL45102020N": "Nasdaq US Large Cap Food Products NTR Index", "I:NQUSL45102020T": "Nasdaq US Large Cap Food Products TR Index", "I:NQUSL451020N": "Nasdaq US Large Cap Food Producers NTR Index", "I:NQUSL451020T": "Nasdaq US Large Cap Food Producers TR Index", "I:NQUSL4510N": "Nasdaq US Large Cap Food, Beverage and Tobacco NTR Index", "I:NQUSL4510T": "Nasdaq US Large Cap Food, Beverage and Tobacco TR Index", "I:NQUSL4520": "Nasdaq US Large Cap Personal Care, Drug and Grocery Stores Index", "I:NQUSL45201015": "Nasdaq US Large Cap Drug Retailers Index", "I:NQUSL45201015N": "Nasdaq US Large Cap Drug Retailers NTR Index", "I:NQUSL45201015T": "Nasdaq US Large Cap Drug Retailers TR Index", "I:NQUSL4520N": "Nasdaq US Large Cap Personal Care, Drug and Grocery Stores NTR Index", "I:NQUSL4520T": "Nasdaq US Large Cap Personal Care, Drug and Grocery Stores TR Index", "I:NQUSL45N": "Nasdaq US Large Cap Consumer Staples NTR Index", "I:NQUSL45T": "Nasdaq US Large Cap Consumer Staples TR Index", "I:NQUSL50": "Nasdaq US Large Cap Industrials Index", "I:NQUSL5010": "Nasdaq US Large Cap Construction and Materials Index", "I:NQUSL50101035": "Nasdaq Large Cap Building Materials: Other Index", "I:NQUSL50101035N": "Nasdaq Large Cap Building Materials: Other NTR Index", "I:NQUSL50101035T": "Nasdaq Large Cap Building Materials: Other TR Index", "I:NQUSL5010N": "Nasdaq US Large Cap Construction and Materials NTR Index", "I:NQUSL5010T": "Nasdaq US Large Cap Construction and Materials TR Index", "I:NQUSL5020": "Nasdaq US Large Cap Industrial Goods and Services Index", "I:NQUSL502010": "Nasdaq US Large Cap Aerospace and Defense Index", "I:NQUSL50201010": "Nasdaq US Large Cap Aerospace Index", "I:NQUSL50201010N": "Nasdaq US Large Cap Aerospace NTR Index", "I:NQUSL50201010T": "Nasdaq US Large Cap Aerospace TR Index", "I:NQUSL50201020": "Nasdaq US Large Cap Defense Index", "I:NQUSL50201020N": "Nasdaq US Large Cap Defense NTR Index", "I:NQUSL50201020T": "Nasdaq US Large Cap Defense TR Index", "I:NQUSL502010N": "Nasdaq US Large Cap Aerospace and Defense NTR Index", "I:NQUSL502010T": "Nasdaq US Large Cap Aerospace and Defense TR Index", "I:NQUSL502020": "Nasdaq US Large Cap Electronic and Electrical Equipment Index", "I:NQUSL50202020": "Nasdaq Large Cap Electronic Equipment: Control and Filter Index", "I:NQUSL50202020N": "Nasdaq Large Cap Electronic Equipment: Control and Filter NTR Index", "I:NQUSL50202020T": "Nasdaq Large Cap Electronic Equipment: Control and Filter TR Index", "I:NQUSL50202025": "Nasdaq Large Cap Electronic Equipment: Gauges and Meters Index", "I:NQUSL50202025N": "Nasdaq Large Cap Electronic Equipment: Gauges and Meters NTR Index", "I:NQUSL50202025T": "Nasdaq Large Cap Electronic Equipment: Gauges and Meters TR Index", "I:NQUSL502020N": "Nasdaq US Large Cap Electronic and Electrical Equipment NTR Index", "I:NQUSL502020T": "Nasdaq US Large Cap Electronic and Electrical Equipment TR Index", "I:NQUSL502030": "Nasdaq US Large Cap General Industrials Index", "I:NQUSL50203000": "Nasdaq US Large Cap Diversified Industrials Index", "I:NQUSL50203000N": "Nasdaq US Large Cap Diversified Industrials NTR Index", "I:NQUSL50203000T": "Nasdaq US Large Cap Diversified Industrials TR Index", "I:NQUSL502030N": "Nasdaq US Large Cap General Industrials NTR Index", "I:NQUSL502030T": "Nasdaq US Large Cap General Industrials TR Index", "I:NQUSL502040": "Nasdaq US Large Cap Industrial Engineering Index", "I:NQUSL50204000": "Nasdaq Large Cap Machinery: Industrial Index", "I:NQUSL50204000N": "Nasdaq Large Cap Machinery: Industrial NTR Index", "I:NQUSL50204000T": "Nasdaq Large Cap Machinery: Industrial TR Index", "I:NQUSL502040N": "Nasdaq US Large Cap Industrial Engineering NTR Index", "I:NQUSL502040T": "Nasdaq US Large Cap Industrial Engineering TR Index", "I:NQUSL502050": "Nasdaq US Large Cap Industrial Support Services Index", "I:NQUSL50205015": "Nasdaq Large Cap Transaction Processing Services Index", "I:NQUSL50205015N": "Nasdaq Large Cap Transaction Processing Services NTR Index", "I:NQUSL50205015T": "Nasdaq Large Cap Transaction Processing Services TR Index", "I:NQUSL50205020": "Nasdaq Large Cap Professional Business Support Services Index", "I:NQUSL50205020N": "Nasdaq Large Cap Professional Business Support Services NTR Index", "I:NQUSL50205020T": "Nasdaq Large Cap Professional Business Support Services TR Index", "I:NQUSL502050N": "Nasdaq US Large Cap Industrial Support Services NTR Index", "I:NQUSL502050T": "Nasdaq US Large Cap Industrial Support Services TR Index", "I:NQUSL502060": "Nasdaq US Large Cap Industrial Transportation Index", "I:NQUSL50206015": "Nasdaq Large Cap Commercial Vehicles and Parts Index", "I:NQUSL50206015N": "Nasdaq Large Cap Commercial Vehicles and Parts NTR Index", "I:NQUSL50206015T": "Nasdaq Large Cap Commercial Vehicles and Parts TR Index", "I:NQUSL502060N": "Nasdaq US Large Cap Industrial Transportation NTR Index", "I:NQUSL502060T": "Nasdaq US Large Cap Industrial Transportation TR Index", "I:NQUSL5020N": "Nasdaq US Large Cap Industrial Goods and Services NTR Index", "I:NQUSL5020T": "Nasdaq US Large Cap Industrial Goods and Services TR Index", "I:NQUSL50N": "Nasdaq US Large Cap Industrials NTR Index", "I:NQUSL50T": "Nasdaq US Large Cap Industrials TR Index", "I:NQUSL55": "Nasdaq US Large Cap Basic Materials Index", "I:NQUSL5510": "Nasdaq US Large Cap Basic Resources Index", "I:NQUSL551020": "Nasdaq US Large Cap Industrial Metals and Mining Index", "I:NQUSL551020N": "Nasdaq US Large Cap Industrial Metals and Mining NTR Index", "I:NQUSL551020T": "Nasdaq US Large Cap Industrial Metals and Mining TR Index", "I:NQUSL5510N": "Nasdaq US Large Cap Basic Resources NTR Index", "I:NQUSL5510T": "Nasdaq US Large Cap Basic Resources TR Index", "I:NQUSL5520": "Nasdaq US Large Cap Chemicals Index", "I:NQUSL55201000": "Nasdaq Large Cap Chemicals: Diversified Index", "I:NQUSL55201000N": "Nasdaq Large Cap Chemicals: Diversified NTR Index", "I:NQUSL55201000T": "Nasdaq Large Cap Chemicals: Diversified TR Index", "I:NQUSL55201020": "Nasdaq US Large Cap Specialty Chemicals Index", "I:NQUSL55201020N": "Nasdaq US Large Cap Specialty Chemicals NTR Index", "I:NQUSL55201020T": "Nasdaq US Large Cap Specialty Chemicals TR Index", "I:NQUSL5520N": "Nasdaq US Large Cap Chemicals NTR Index", "I:NQUSL5520T": "Nasdaq US Large Cap Chemicals TR Index", "I:NQUSL55N": "Nasdaq US Large Cap Basic Materials NTR Index", "I:NQUSL55T": "Nasdaq US Large Cap Basic Materials TR Index", "I:NQUSL60": "Nasdaq US Large Cap Energy Index", "I:NQUSL601010": "Nasdaq US Large Cap Oil, Gas and Coal Index", "I:NQUSL60101000": "Nasdaq US Large Cap Integrated Oil and Gas Index", "I:NQUSL60101000N": "Nasdaq US Large Cap Integrated Oil and Gas NTR Index", "I:NQUSL60101000T": "Nasdaq US Large Cap Integrated Oil and Gas TR Index", "I:NQUSL60101010": "Nasdaq Large Cap Oil: Crude Producers Index", "I:NQUSL60101010N": "Nasdaq Large Cap Oil: Crude Producers NTR Index", "I:NQUSL60101010T": "Nasdaq Large Cap Oil: Crude Producers TR Index", "I:NQUSL60101030": "Nasdaq US Large Cap Oil Equipment and Services Index", "I:NQUSL60101030N": "Nasdaq US Large Cap Oil Equipment and Services NTR Index", "I:NQUSL60101030T": "Nasdaq US Large Cap Oil Equipment and Services TR Index", "I:NQUSL601010N": "Nasdaq US Large Cap Oil, Gas and Coal NTR Index", "I:NQUSL601010T": "Nasdaq US Large Cap Oil, Gas and Coal TR Index", "I:NQUSL60N": "Nasdaq US Large Cap Energy NTR Index", "I:NQUSL60T": "Nasdaq US Large Cap Energy TR Index", "I:NQUSL65": "Nasdaq US Large Cap Utilities Index", "I:NQUSL651010": "Nasdaq US Large Cap Electricity Index", "I:NQUSL65101015": "Nasdaq US Large Cap Conventional Electricity Index", "I:NQUSL65101015N": "Nasdaq US Large Cap Conventional Electricity NTR Index", "I:NQUSL65101015T": "Nasdaq US Large Cap Conventional Electricity TR Index", "I:NQUSL651010N": "Nasdaq US Large Cap Electricity NTR Index", "I:NQUSL651010T": "Nasdaq US Large Cap Electricity TR Index", "I:NQUSL651020": "Nasdaq US Large Cap Gas, Water and Multi-utilities Index", "I:NQUSL65102000": "Nasdaq US Large Cap Multi-utilities Index", "I:NQUSL65102000N": "Nasdaq US Large Cap Multi-utilities NTR Index", "I:NQUSL65102000T": "Nasdaq US Large Cap Multi-utilities TR Index", "I:NQUSL651020N": "Nasdaq US Large Cap Gas, Water and Multi-utilities NTR Index", "I:NQUSL651020T": "Nasdaq US Large Cap Gas, Water and Multi-utilities TR Index", "I:NQUSL65N": "Nasdaq US Large Cap Utilities NTR Index", "I:NQUSL65T": "Nasdaq US Large Cap Utilities TR Index", "I:NQUSLG": "Nasdaq US Large Cap Growth Index", "I:NQUSLGN": "Nasdaq US Large Cap Growth NTR Index", "I:NQUSLGT": "Nasdaq US Large Cap Growth TR Index", "I:NQUSLN": "NASDAQ US  Large Cap NTR Index", "I:NQUSLT": "NASDAQ US Large Cap TR Index", "I:NQUSLV": "Nasdaq US Large Cap Value Index", "I:NQUSLVN": "Nasdaq US Large Cap Value NTR Index", "I:NQUSLVT": "Nasdaq US Large Cap Value TR Index", "I:NQUSM": "NASDAQ US Mid Cap Index", "I:NQUSM10": "Nasdaq US Mid Cap Technology Index", "I:NQUSM101010": "Nasdaq US Mid Cap Software and Computer Services Index", "I:NQUSM10101010": "Nasdaq US Mid Cap Computer Services Index", "I:NQUSM10101010N": "Nasdaq US Mid Cap Computer Services NTR Index", "I:NQUSM10101010T": "Nasdaq US Mid Cap Computer Services TR Index", "I:NQUSM10101015": "Nasdaq US Mid Cap Software Index", "I:NQUSM10101015N": "Nasdaq US Mid Cap Software NTR Index", "I:NQUSM10101015T": "Nasdaq US Mid Cap Software TR Index", "I:NQUSM10101020": "Nasdaq US Mid Cap Consumer Digital Services Index", "I:NQUSM10101020N": "Nasdaq US Mid Cap Consumer Digital Services NTR Index", "I:NQUSM10101020T": "Nasdaq US Mid Cap Consumer Digital Services TR Index", "I:NQUSM101010N": "Nasdaq US Mid Cap Software and Computer Services NTR Index", "I:NQUSM101010T": "Nasdaq US Mid Cap Software and Computer Services TR Index", "I:NQUSM101020": "Nasdaq US Mid Cap Technology Hardware and Equipment Index", "I:NQUSM10102010": "Nasdaq US Mid Cap Semiconductors Index", "I:NQUSM10102010N": "Nasdaq US Mid Cap Semiconductors NTR Index", "I:NQUSM10102010T": "Nasdaq US Mid Cap Semiconductors TR Index", "I:NQUSM10102015": "Nasdaq Mid Cap Electronic Components Index", "I:NQUSM10102015N": "Nasdaq Mid Cap Electronic Components NTR Index", "I:NQUSM10102015T": "Nasdaq Mid Cap Electronic Components TR Index", "I:NQUSM10102020": "Nasdaq Mid Cap Production Technology Equipment Index", "I:NQUSM10102020N": "Nasdaq Mid Cap Production Technology Equipment NTR Index", "I:NQUSM10102020T": "Nasdaq Mid Cap Production Technology Equipment TR Index", "I:NQUSM10102030": "Nasdaq US Mid Cap Computer Hardware Index", "I:NQUSM10102030N": "Nasdaq US Mid Cap Computer Hardware NTR Index", "I:NQUSM10102030T": "Nasdaq US Mid Cap Computer Hardware TR Index", "I:NQUSM101020N": "Nasdaq US Mid Cap Technology Hardware and Equipment NTR Index", "I:NQUSM101020T": "Nasdaq US Mid Cap Technology Hardware and Equipment TR Index", "I:NQUSM10N": "Nasdaq US Mid Cap Technology NTR Index", "I:NQUSM10T": "Nasdaq US Mid Cap Technology TR Index", "I:NQUSM151010": "Nasdaq US Mid Cap Telecommunications Equipment Index", "I:NQUSM151010N": "Nasdaq US Mid Cap Telecommunications Equipment NTR Index", "I:NQUSM151010T": "Nasdaq US Mid Cap Telecommunications Equipment TR Index", "I:NQUSM151020": "Nasdaq US Mid Cap Telecommunications Service Providers Index", "I:NQUSM15102010": "Nasdaq Mid Cap Cable Television Services Index", "I:NQUSM15102010N": "Nasdaq Mid Cap Cable Television Services NTR Index", "I:NQUSM15102010T": "Nasdaq Mid Cap Cable Television Services TR Index", "I:NQUSM151020N": "Nasdaq US Mid Cap Telecommunications Service Providers NTR Index", "I:NQUSM151020T": "Nasdaq US Mid Cap Telecommunications Service Providers TR Index", "I:NQUSM20": "Nasdaq US Mid Cap Health Care Index", "I:NQUSM201010": "Nasdaq US Mid Cap Health Care Providers Index", "I:NQUSM20101010": "Nasdaq Mid Cap Health Care Facilities Index", "I:NQUSM20101010N": "Nasdaq Mid Cap Health Care Facilities NTR Index", "I:NQUSM20101010T": "Nasdaq Mid Cap Health Care Facilities TR Index", "I:NQUSM20101020": "Nasdaq Mid Cap Health Care Management Services Index", "I:NQUSM20101020N": "Nasdaq Mid Cap Health Care Management Services NTR Index", "I:NQUSM20101020T": "Nasdaq Mid Cap Health Care Management Services TR Index", "I:NQUSM20101025": "Nasdaq Mid Cap Health Care Services Index", "I:NQUSM20101025N": "Nasdaq Mid Cap Health Care Services NTR Index", "I:NQUSM20101025T": "Nasdaq Mid Cap Health Care Services TR Index", "I:NQUSM201010N": "Nasdaq US Mid Cap Health Care Providers NTR Index", "I:NQUSM201010T": "Nasdaq US Mid Cap Health Care Providers TR Index", "I:NQUSM201020": "Nasdaq US Mid Cap Medical Equipment and Services Index", "I:NQUSM20102010": "Nasdaq US Mid Cap Medical Equipment Index", "I:NQUSM20102010N": "Nasdaq US Mid Cap Medical Equipment NTR Index", "I:NQUSM20102010T": "Nasdaq US Mid Cap Medical Equipment TR Index", "I:NQUSM20102015": "Nasdaq US Mid Cap Medical Supplies Index", "I:NQUSM20102015N": "Nasdaq US Mid Cap Medical Supplies NTR Index", "I:NQUSM20102015T": "Nasdaq US Mid Cap Medical Supplies TR Index", "I:NQUSM201020N": "Nasdaq US Mid Cap Medical Equipment and Services NTR Index", "I:NQUSM201020T": "Nasdaq US Mid Cap Medical Equipment and Services TR Index", "I:NQUSM201030": "Nasdaq US Mid Cap Pharmaceuticals and Biotechnology Index", "I:NQUSM20103010": "Nasdaq US Mid Cap Biotechnology Index", "I:NQUSM20103010N": "Nasdaq US Mid Cap Biotechnology NTR Index", "I:NQUSM20103010T": "Nasdaq US Mid Cap Biotechnology TR Index", "I:NQUSM20103015": "Nasdaq US Mid Cap Pharmaceuticals Index", "I:NQUSM20103015N": "Nasdaq US Mid Cap Pharmaceuticals NTR Index", "I:NQUSM20103015T": "Nasdaq US Mid Cap Pharmaceuticals TR Index", "I:NQUSM201030N": "Nasdaq US Mid Cap Pharmaceuticals and Biotechnology NTR Index", "I:NQUSM201030T": "Nasdaq US Mid Cap Pharmaceuticals and Biotechnology TR Index", "I:NQUSM20N": "Nasdaq US Mid Cap Health Care NTR Index", "I:NQUSM20T": "Nasdaq US Mid Cap Health Care TR Index", "I:NQUSM30": "Nasdaq US Mid Cap Financials Index", "I:NQUSM3010": "Nasdaq US Mid Cap Banks Index", "I:NQUSM3010N": "Nasdaq US Mid Cap Banks NTR Index", "I:NQUSM3010T": "Nasdaq US Mid Cap Banks TR Index", "I:NQUSM3020": "Nasdaq US Mid Cap Financial Services Index", "I:NQUSM302010": "Nasdaq US Mid Cap Finance and Credit Services Index", "I:NQUSM30201020": "Nasdaq US Mid Cap Consumer Lending Index", "I:NQUSM30201020N": "Nasdaq US Mid Cap Consumer Lending NTR Index", "I:NQUSM30201020T": "Nasdaq US Mid Cap Consumer Lending TR Index", "I:NQUSM302010N": "Nasdaq US Mid Cap Finance and Credit Services NTR Index", "I:NQUSM302010T": "Nasdaq US Mid Cap Finance and Credit Services TR Index", "I:NQUSM302020": "Nasdaq US Mid Cap Investment Banking and Brokerage Services Index", "I:NQUSM30202000": "Nasdaq US Mid Cap Diversified Financial Services Index", "I:NQUSM30202000N": "Nasdaq US Mid Cap Diversified Financial Services NTR Index", "I:NQUSM30202000T": "Nasdaq US Mid Cap Diversified Financial Services TR Index", "I:NQUSM30202010": "Nasdaq US Mid Cap Asset Managers and Custodians Index", "I:NQUSM30202010N": "Nasdaq US Mid Cap Asset Managers and Custodians NTR Index", "I:NQUSM30202010T": "Nasdaq US Mid Cap Asset Managers and Custodians TR Index", "I:NQUSM30202015": "Nasdaq US Mid Cap Investment Services Index", "I:NQUSM30202015N": "Nasdaq US Mid Cap Investment Services NTR Index", "I:NQUSM30202015T": "Nasdaq US Mid Cap Investment Services TR Index", "I:NQUSM302020N": "Nasdaq US Mid Cap Investment Banking and Brokerage Services NTR Index", "I:NQUSM302020T": "Nasdaq US Mid Cap Investment Banking and Brokerage Services TR Index", "I:NQUSM302030": "Nasdaq US Mid Cap Mortgage Real Estate Investment Trusts Index", "I:NQUSM30203020": "Nasdaq Mid Cap Mortgage REITs: Residential Index", "I:NQUSM30203020N": "Nasdaq Mid Cap Mortgage REITs: Residential NTR Index", "I:NQUSM30203020T": "Nasdaq Mid Cap Mortgage REITs: Residential TR Index", "I:NQUSM302030N": "Nasdaq US Mid Cap Mortgage Real Estate Investment Trusts NTR Index", "I:NQUSM302030T": "Nasdaq US Mid Cap Mortgage Real Estate Investment Trusts TR Index", "I:NQUSM3020N": "Nasdaq US Mid Cap Financial Services NTR Index", "I:NQUSM3020T": "Nasdaq US Mid Cap Financial Services TR Index", "I:NQUSM3030": "Nasdaq US Mid Cap Insurance Index", "I:NQUSM303010": "Nasdaq US Mid Cap Life Insurance Index", "I:NQUSM303010N": "Nasdaq US Mid Cap Life Insurance NTR Index", "I:NQUSM303010T": "Nasdaq US Mid Cap Life Insurance TR Index", "I:NQUSM303020": "Nasdaq US Mid Cap Non-life Insurance Index", "I:NQUSM30302020": "Nasdaq US Mid Cap Reinsurance Index", "I:NQUSM30302020N": "Nasdaq US Mid Cap Reinsurance NTR Index", "I:NQUSM30302020T": "Nasdaq US Mid Cap Reinsurance TR Index", "I:NQUSM30302025": "Nasdaq US Mid Cap Property and Casualty Insurance Index", "I:NQUSM30302025N": "Nasdaq US Mid Cap Property and Casualty Insurance NTR Index", "I:NQUSM30302025T": "Nasdaq US Mid Cap Property and Casualty Insurance TR Index", "I:NQUSM303020N": "Nasdaq US Mid Cap Non-life Insurance NTR Index", "I:NQUSM303020T": "Nasdaq US Mid Cap Non-life Insurance TR Index", "I:NQUSM3030N": "Nasdaq US Mid Cap Insurance NTR Index", "I:NQUSM3030T": "Nasdaq US Mid Cap Insurance TR Index", "I:NQUSM30N": "Nasdaq US Mid Cap Financials NTR Index", "I:NQUSM30T": "Nasdaq US Mid Cap Financials TR Index", "I:NQUSM35": "Nasdaq US Mid Cap Real Estate Index", "I:NQUSM351010": "Nasdaq US Mid Cap Real Estate Investment and Services Index", "I:NQUSM351010N": "Nasdaq US Mid Cap Real Estate Investment and Services NTR Index", "I:NQUSM351010T": "Nasdaq US Mid Cap Real Estate Investment and Services TR Index", "I:NQUSM351020": "Nasdaq US Mid Cap Real Estate Investment Trusts Index", "I:NQUSM35102015": "Nasdaq US Mid Cap Hotel and Lodging REITs Index", "I:NQUSM35102015N": "Nasdaq US Mid Cap Hotel and Lodging REITs NTR Index", "I:NQUSM35102015T": "Nasdaq US Mid Cap Hotel and Lodging REITs TR Index", "I:NQUSM35102020": "Nasdaq Mid Cap Industrial REITs Index", "I:NQUSM35102020N": "Nasdaq Mid Cap Industrial REITs NTR Index", "I:NQUSM35102020T": "Nasdaq Mid Cap Industrial REITs TR Index", "I:NQUSM35102030": "Nasdaq Mid Cap Office REITs Index", "I:NQUSM35102030N": "Nasdaq Mid Cap Office REITs NTR Index", "I:NQUSM35102030T": "Nasdaq Mid Cap Office REITs TR Index", "I:NQUSM35102040": "Nasdaq US Mid Cap Residential REITs Index", "I:NQUSM35102040N": "Nasdaq US Mid Cap Residential REITs NTR Index", "I:NQUSM35102040T": "Nasdaq US Mid Cap Residential REITs TR Index", "I:NQUSM35102045": "Nasdaq US Mid Cap Retail REITs Index", "I:NQUSM35102045N": "Nasdaq US Mid Cap Retail REITs NTR Index", "I:NQUSM35102045T": "Nasdaq US Mid Cap Retail REITs TR Index", "I:NQUSM35102070": "Nasdaq Mid Cap Other Specialty REITs Index", "I:NQUSM35102070N": "Nasdaq Mid Cap Other Specialty REITs NTR Index", "I:NQUSM35102070T": "Nasdaq Mid Cap Other Specialty REITs TR Index", "I:NQUSM351020N": "Nasdaq US Mid Cap Real Estate Investment Trusts NTR Index", "I:NQUSM351020T": "Nasdaq US Mid Cap Real Estate Investment Trusts TR Index", "I:NQUSM35N": "Nasdaq US Mid Cap Real Estate NTR Index", "I:NQUSM35T": "Nasdaq US Mid Cap Real Estate TR Index", "I:NQUSM40": "Nasdaq US Mid Cap Consumer Discretionary Index", "I:NQUSM4010": "Nasdaq US Mid Cap Automobiles and Parts Index", "I:NQUSM40101025": "Nasdaq US Mid Cap Auto Parts Index", "I:NQUSM40101025N": "Nasdaq US Mid Cap Auto Parts NTR Index", "I:NQUSM40101025T": "Nasdaq US Mid Cap Auto Parts TR Index", "I:NQUSM4010N": "Nasdaq US Mid Cap Automobiles and Parts NTR Index", "I:NQUSM4010T": "Nasdaq US Mid Cap Automobiles and Parts TR Index", "I:NQUSM4020": "Nasdaq US Mid Cap Consumer Products and Services Index", "I:NQUSM402010": "Nasdaq US Mid Cap Consumer Services Index", "I:NQUSM40201070": "Nasdaq Mid Cap Consumer Services: Misc. Index", "I:NQUSM40201070N": "Nasdaq Mid Cap Consumer Services: Misc. NTR Index", "I:NQUSM40201070T": "Nasdaq Mid Cap Consumer Services: Misc. TR Index", "I:NQUSM402010N": "Nasdaq US Mid Cap Consumer Services NTR Index", "I:NQUSM402010T": "Nasdaq US Mid Cap Consumer Services TR Index", "I:NQUSM402020": "Nasdaq US Mid Cap Household Goods and Home Construction Index", "I:NQUSM40202010": "Nasdaq US Mid Cap Home Construction Index", "I:NQUSM40202010N": "Nasdaq US Mid Cap Home Construction NTR Index", "I:NQUSM40202010T": "Nasdaq US Mid Cap Home Construction TR Index", "I:NQUSM40202015": "Nasdaq US Mid Cap Household Furnishings Index", "I:NQUSM40202015N": "Nasdaq US Mid Cap Household Furnishings NTR Index", "I:NQUSM40202015T": "Nasdaq US Mid Cap Household Furnishings TR Index", "I:NQUSM40202025": "Nasdaq Mid Cap Household Equipment and Products Index", "I:NQUSM40202025N": "Nasdaq Mid Cap Household Equipment and Products NTR Index", "I:NQUSM40202025T": "Nasdaq Mid Cap Household Equipment and Products TR Index", "I:NQUSM402020N": "Nasdaq US Mid Cap Household Goods and Home Construction NTR Index", "I:NQUSM402020T": "Nasdaq US Mid Cap Household Goods and Home Construction TR Index", "I:NQUSM402030": "Nasdaq US Mid Cap Leisure Goods Index", "I:NQUSM40203050": "Nasdaq US Mid Cap Recreational Products Index", "I:NQUSM40203050N": "Nasdaq US Mid Cap Recreational Products NTR Index", "I:NQUSM40203050T": "Nasdaq US Mid Cap Recreational Products TR Index", "I:NQUSM402030N": "Nasdaq US Mid Cap Leisure Goods NTR Index", "I:NQUSM402030T": "Nasdaq US Mid Cap Leisure Goods TR Index", "I:NQUSM402040": "Nasdaq US Mid Cap Personal Goods Index", "I:NQUSM40204020": "Nasdaq US Mid Cap Clothing and Accessories Index", "I:NQUSM40204020N": "Nasdaq US Mid Cap Clothing and Accessories NTR Index", "I:NQUSM40204020T": "Nasdaq US Mid Cap Clothing and Accessories TR Index", "I:NQUSM402040N": "Nasdaq US Mid Cap Personal Goods NTR Index", "I:NQUSM402040T": "Nasdaq US Mid Cap Personal Goods TR Index", "I:NQUSM4020N": "Nasdaq US Mid Cap Consumer Products and Services NTR Index", "I:NQUSM4020T": "Nasdaq US Mid Cap Consumer Products and Services TR Index", "I:NQUSM4030": "Nasdaq US Mid Cap Media Index", "I:NQUSM40301030": "Nasdaq US Mid Cap Publishing Index", "I:NQUSM40301030N": "Nasdaq US Mid Cap Publishing NTR Index", "I:NQUSM40301030T": "Nasdaq US Mid Cap Publishing TR Index", "I:NQUSM40301035": "Nasdaq Mid Cap Radio and TV Broadcasters Index", "I:NQUSM40301035N": "Nasdaq Mid Cap Radio and TV Broadcasters NTR Index", "I:NQUSM40301035T": "Nasdaq Mid Cap Radio and TV Broadcasters TR Index", "I:NQUSM4030N": "Nasdaq US Mid Cap Media NTR Index", "I:NQUSM4030T": "Nasdaq US Mid Cap Media TR Index", "I:NQUSM4040": "Nasdaq US Mid Cap Retail Index", "I:NQUSM404010": "Nasdaq US Mid Cap Retailers Index", "I:NQUSM40401010": "Nasdaq US Mid Cap Diversified Retailers Index", "I:NQUSM40401010N": "Nasdaq US Mid Cap Diversified Retailers NTR Index", "I:NQUSM40401010T": "Nasdaq US Mid Cap Diversified Retailers TR Index", "I:NQUSM40401020": "Nasdaq US Mid Cap Apparel Retailers Index", "I:NQUSM40401020N": "Nasdaq US Mid Cap Apparel Retailers NTR Index", "I:NQUSM40401020T": "Nasdaq US Mid Cap Apparel Retailers TR Index", "I:NQUSM40401030": "Nasdaq US Mid Cap Specialty Retailers Index", "I:NQUSM40401030N": "Nasdaq US Mid Cap Specialty Retailers NTR Index", "I:NQUSM40401030T": "Nasdaq US Mid Cap Specialty Retailers TR Index", "I:NQUSM404010N": "Nasdaq US Mid Cap Retailers NTR Index", "I:NQUSM404010T": "Nasdaq US Mid Cap Retailers TR Index", "I:NQUSM4040N": "Nasdaq US Mid Cap Retail NTR Index", "I:NQUSM4040T": "Nasdaq US Mid Cap Retail TR Index", "I:NQUSM4050": "Nasdaq US Mid Cap Travel and Leisure Index", "I:NQUSM40501025": "Nasdaq US Mid Cap Hotels and Motels Index", "I:NQUSM40501025N": "Nasdaq US Mid Cap Hotels and Motels NTR Index", "I:NQUSM40501025T": "Nasdaq US Mid Cap Hotels and Motels TR Index", "I:NQUSM40501030": "Nasdaq US Mid Cap Recreational Services Index", "I:NQUSM40501030N": "Nasdaq US Mid Cap Recreational Services NTR Index", "I:NQUSM40501030T": "Nasdaq US Mid Cap Recreational Services TR Index", "I:NQUSM40501040": "Nasdaq US Mid Cap Restaurants and Bars Index", "I:NQUSM40501040N": "Nasdaq US Mid Cap Restaurants and Bars NTR Index", "I:NQUSM40501040T": "Nasdaq US Mid Cap Restaurants and Bars TR Index", "I:NQUSM4050N": "Nasdaq US Mid Cap Travel and Leisure NTR Index", "I:NQUSM4050T": "Nasdaq US Mid Cap Travel and Leisure TR Index", "I:NQUSM40N": "Nasdaq US Mid Cap Consumer Discretionary NTR Index", "I:NQUSM40T": "Nasdaq US Mid Cap Consumer Discretionary TR Index", "I:NQUSM45": "Nasdaq US Mid Cap Consumer Staples Index", "I:NQUSM450": "NASDAQ US 450 Index", "I:NQUSM450N": "NASDAQ US 450 NTR Index", "I:NQUSM450T": "NASDAQ US 450 TR Index", "I:NQUSM4510": "Nasdaq US Mid Cap Food, Beverage and Tobacco Index", "I:NQUSM451020": "Nasdaq US Mid Cap Food Producers Index", "I:NQUSM45102020": "Nasdaq US Mid Cap Food Products Index", "I:NQUSM45102020N": "Nasdaq US Mid Cap Food Products NTR Index", "I:NQUSM45102020T": "Nasdaq US Mid Cap Food Products TR Index", "I:NQUSM451020N": "Nasdaq US Mid Cap Food Producers NTR Index", "I:NQUSM451020T": "Nasdaq US Mid Cap Food Producers TR Index", "I:NQUSM4510N": "Nasdaq US Mid Cap Food, Beverage and Tobacco NTR Index", "I:NQUSM4510T": "Nasdaq US Mid Cap Food, Beverage and Tobacco TR Index", "I:NQUSM4520": "Nasdaq US Mid Cap Personal Care, Drug and Grocery Stores Index", "I:NQUSM45201010": "Nasdaq US Mid Cap Food Retailers and Wholesalers Index", "I:NQUSM45201010N": "Nasdaq US Mid Cap Food Retailers and Wholesalers NTR Index", "I:NQUSM45201010T": "Nasdaq US Mid Cap Food Retailers and Wholesalers TR Index", "I:NQUSM4520N": "Nasdaq US Mid Cap Personal Care, Drug and Grocery Stores NTR Index", "I:NQUSM4520T": "Nasdaq US Mid Cap Personal Care, Drug and Grocery Stores TR Index", "I:NQUSM45N": "Nasdaq US Mid Cap Consumer Staples NTR Index", "I:NQUSM45T": "Nasdaq US Mid Cap Consumer Staples TR Index", "I:NQUSM50": "Nasdaq US Mid Cap Industrials Index", "I:NQUSM5010": "Nasdaq US Mid Cap Construction and Materials Index", "I:NQUSM50101015": "Nasdaq Mid Cap Engineering and Contracting Services Index", "I:NQUSM50101015N": "Nasdaq Mid Cap Engineering and Contracting Services NTR Index", "I:NQUSM50101015T": "Nasdaq Mid Cap Engineering and Contracting Services TR Index", "I:NQUSM50101035": "Nasdaq Mid Cap Building Materials: Other Index", "I:NQUSM50101035N": "Nasdaq Mid Cap Building Materials: Other NTR Index", "I:NQUSM50101035T": "Nasdaq Mid Cap Building Materials: Other TR Index", "I:NQUSM5010N": "Nasdaq US Mid Cap Construction and Materials NTR Index", "I:NQUSM5010T": "Nasdaq US Mid Cap Construction and Materials TR Index", "I:NQUSM5020": "Nasdaq US Mid Cap Industrial Goods and Services Index", "I:NQUSM502010": "Nasdaq US Mid Cap Aerospace and Defense Index", "I:NQUSM50201010": "Nasdaq US Mid Cap Aerospace Index", "I:NQUSM50201010N": "Nasdaq US Mid Cap Aerospace NTR Index", "I:NQUSM50201010T": "Nasdaq US Mid Cap Aerospace TR Index", "I:NQUSM50201020": "Nasdaq US Mid Cap Defense Index", "I:NQUSM50201020N": "Nasdaq US Mid Cap Defense NTR Index", "I:NQUSM50201020T": "Nasdaq US Mid Cap Defense TR Index", "I:NQUSM502010N": "Nasdaq US Mid Cap Aerospace and Defense NTR Index", "I:NQUSM502010T": "Nasdaq US Mid Cap Aerospace and Defense TR Index", "I:NQUSM502020": "Nasdaq US Mid Cap Electronic and Electrical Equipment Index", "I:NQUSM50202020": "Nasdaq Mid Cap Electronic Equipment: Control and Filter Index", "I:NQUSM50202020N": "Nasdaq Mid Cap Electronic Equipment: Control and Filter NTR Index", "I:NQUSM50202020T": "Nasdaq Mid Cap Electronic Equipment: Control and Filter TR Index", "I:NQUSM50202025": "Nasdaq Mid Cap Electronic Equipment: Gauges and Meters Index", "I:NQUSM50202025N": "Nasdaq Mid Cap Electronic Equipment: Gauges and Meters NTR Index", "I:NQUSM50202025T": "Nasdaq Mid Cap Electronic Equipment: Gauges and Meters TR Index", "I:NQUSM502020N": "Nasdaq US Mid Cap Electronic and Electrical Equipment NTR Index", "I:NQUSM502020T": "Nasdaq US Mid Cap Electronic and Electrical Equipment TR Index", "I:NQUSM502030": "Nasdaq US Mid Cap General Industrials Index", "I:NQUSM50203030": "Nasdaq US Mid Cap Containers and Packaging Index", "I:NQUSM50203030N": "Nasdaq US Mid Cap Containers and Packaging NTR Index", "I:NQUSM50203030T": "Nasdaq US Mid Cap Containers and Packaging TR Index", "I:NQUSM502030N": "Nasdaq US Mid Cap General Industrials NTR Index", "I:NQUSM502030T": "Nasdaq US Mid Cap General Industrials TR Index", "I:NQUSM502040": "Nasdaq US Mid Cap Industrial Engineering Index", "I:NQUSM50204000": "Nasdaq Mid Cap Machinery: Industrial Index", "I:NQUSM50204000N": "Nasdaq Mid Cap Machinery: Industrial NTR Index", "I:NQUSM50204000T": "Nasdaq Mid Cap Machinery: Industrial TR Index", "I:NQUSM502040N": "Nasdaq US Mid Cap Industrial Engineering NTR Index", "I:NQUSM502040T": "Nasdaq US Mid Cap Industrial Engineering TR Index", "I:NQUSM502050": "Nasdaq US Mid Cap Industrial Support Services Index", "I:NQUSM50205015": "Nasdaq Mid Cap Transaction Processing Services Index", "I:NQUSM50205015N": "Nasdaq Mid Cap Transaction Processing Services NTR Index", "I:NQUSM50205015T": "Nasdaq Mid Cap Transaction Processing Services TR Index", "I:NQUSM50205020": "Nasdaq Mid Cap Professional Business Support Services Index", "I:NQUSM50205020N": "Nasdaq Mid Cap Professional Business Support Services NTR Index", "I:NQUSM50205020T": "Nasdaq Mid Cap Professional Business Support Services TR Index", "I:NQUSM50205025": "Nasdaq US Mid Cap Business Training and Employment Agencies Index", "I:NQUSM50205025N": "Nasdaq US Mid Cap Business Training and Employment Agencies NTR Index", "I:NQUSM50205025T": "Nasdaq US Mid Cap Business Training and Employment Agencies TR Index", "I:NQUSM502050N": "Nasdaq US Mid Cap Industrial Support Services NTR Index", "I:NQUSM502050T": "Nasdaq US Mid Cap Industrial Support Services TR Index", "I:NQUSM502060": "Nasdaq US Mid Cap Industrial Transportation Index", "I:NQUSM50206010": "Nasdaq US Mid Cap Trucking Index", "I:NQUSM50206010N": "Nasdaq US Mid Cap Trucking NTR Index", "I:NQUSM50206010T": "Nasdaq US Mid Cap Trucking TR Index", "I:NQUSM50206015": "Nasdaq Mid Cap Commercial Vehicles and Parts Index", "I:NQUSM50206015N": "Nasdaq Mid Cap Commercial Vehicles and Parts NTR Index", "I:NQUSM50206015T": "Nasdaq Mid Cap Commercial Vehicles and Parts TR Index", "I:NQUSM50206060": "Nasdaq US Mid Cap Transportation Services Index", "I:NQUSM50206060N": "Nasdaq US Mid Cap Transportation Services NTR Index", "I:NQUSM50206060T": "Nasdaq US Mid Cap Transportation Services TR Index", "I:NQUSM502060N": "Nasdaq US Mid Cap Industrial Transportation NTR Index", "I:NQUSM502060T": "Nasdaq US Mid Cap Industrial Transportation TR Index", "I:NQUSM5020N": "Nasdaq US Mid Cap Industrial Goods and Services NTR Index", "I:NQUSM5020T": "Nasdaq US Mid Cap Industrial Goods and Services TR Index", "I:NQUSM50N": "Nasdaq US Mid Cap Industrials NTR Index", "I:NQUSM50T": "Nasdaq US Mid Cap Industrials TR Index", "I:NQUSM55": "Nasdaq US Mid Cap Basic Materials Index", "I:NQUSM5510": "Nasdaq US Mid Cap Basic Resources Index", "I:NQUSM551020": "Nasdaq US Mid Cap Industrial Metals and Mining Index", "I:NQUSM55102010": "Nasdaq US Mid Cap Iron and Steel Index", "I:NQUSM55102010N": "Nasdaq US Mid Cap Iron and Steel NTR Index", "I:NQUSM55102010T": "Nasdaq US Mid Cap Iron and Steel TR Index", "I:NQUSM551020N": "Nasdaq US Mid Cap Industrial Metals and Mining NTR Index", "I:NQUSM551020T": "Nasdaq US Mid Cap Industrial Metals and Mining TR Index", "I:NQUSM5510N": "Nasdaq US Mid Cap Basic Resources NTR Index", "I:NQUSM5510T": "Nasdaq US Mid Cap Basic Resources TR Index", "I:NQUSM5520": "Nasdaq US Mid Cap Chemicals Index", "I:NQUSM55201000": "Nasdaq Mid Cap Chemicals: Diversified Index", "I:NQUSM55201000N": "Nasdaq Mid Cap Chemicals: Diversified NTR Index", "I:NQUSM55201000T": "Nasdaq Mid Cap Chemicals: Diversified TR Index", "I:NQUSM55201020": "Nasdaq US Mid Cap Specialty Chemicals Index", "I:NQUSM55201020N": "Nasdaq US Mid Cap Specialty Chemicals NTR Index", "I:NQUSM55201020T": "Nasdaq US Mid Cap Specialty Chemicals TR Index", "I:NQUSM5520N": "Nasdaq US Mid Cap Chemicals NTR Index", "I:NQUSM5520T": "Nasdaq US Mid Cap Chemicals TR Index", "I:NQUSM55N": "Nasdaq US Mid Cap Basic Materials NTR Index", "I:NQUSM55T": "Nasdaq US Mid Cap Basic Materials TR Index", "I:NQUSM60": "Nasdaq US Mid Cap Energy Index", "I:NQUSM601010": "Nasdaq US Mid Cap Oil, Gas and Coal Index", "I:NQUSM60101010": "Nasdaq Mid Cap Oil: Crude Producers Index", "I:NQUSM60101010N": "Nasdaq Mid Cap Oil: Crude Producers NTR Index", "I:NQUSM60101010T": "Nasdaq Mid Cap Oil: Crude Producers TR Index", "I:NQUSM60101030": "Nasdaq US Mid Cap Oil Equipment and Services Index", "I:NQUSM60101030N": "Nasdaq US Mid Cap Oil Equipment and Services NTR Index", "I:NQUSM60101030T": "Nasdaq US Mid Cap Oil Equipment and Services TR Index", "I:NQUSM601010N": "Nasdaq US Mid Cap Oil, Gas and Coal NTR Index", "I:NQUSM601010T": "Nasdaq US Mid Cap Oil, Gas and Coal TR Index", "I:NQUSM60N": "Nasdaq US Mid Cap Energy NTR Index", "I:NQUSM60T": "Nasdaq US Mid Cap Energy TR Index", "I:NQUSM65": "Nasdaq US Mid Cap Utilities Index", "I:NQUSM651010": "Nasdaq US Mid Cap Electricity Index", "I:NQUSM65101015": "Nasdaq US Mid Cap Conventional Electricity Index", "I:NQUSM65101015N": "Nasdaq US Mid Cap Conventional Electricity NTR Index", "I:NQUSM65101015T": "Nasdaq US Mid Cap Conventional Electricity TR Index", "I:NQUSM651010N": "Nasdaq US Mid Cap Electricity NTR Index", "I:NQUSM651010T": "Nasdaq US Mid Cap Electricity TR Index", "I:NQUSM651020": "Nasdaq US Mid Cap Gas, Water and Multi-utilities Index", "I:NQUSM65102020": "Nasdaq US Mid Cap Gas Distribution Index", "I:NQUSM65102020N": "Nasdaq US Mid Cap Gas Distribution NTR Index", "I:NQUSM65102020T": "Nasdaq US Mid Cap Gas Distribution TR Index", "I:NQUSM651020N": "Nasdaq US Mid Cap Gas, Water and Multi-utilities NTR Index", "I:NQUSM651020T": "Nasdaq US Mid Cap Gas, Water and Multi-utilities TR Index", "I:NQUSM65N": "Nasdaq US Mid Cap Utilities NTR Index", "I:NQUSM65T": "Nasdaq US Mid Cap Utilities TR Index", "I:NQUSMG": "Nasdaq US Mid Cap Growth Index", "I:NQUSMGN": "Nasdaq US Mid Cap Growth NTR Index", "I:NQUSMGT": "Nasdaq US Mid Cap Growth TR Index", "I:NQUSMLTCG": "Nasdaq US Multi Cap Growth Index", "I:NQUSMLTCGN": "Nasdaq US Multi Cap Growth Net Total Return Index", "I:NQUSMLTCGT": "Nasdaq US Multi Cap Growth Total Return Index", "I:NQUSMLTCV": "Nasdaq US Multi Cap Value Index", "I:NQUSMLTCVN": "Nasdaq US Multi Cap Value Net Total Return Index", "I:NQUSMLTCVT": "Nasdaq US Multi Cap Value Total Return Index", "I:NQUSMN": "NASDAQ US  Mid Cap NTR Index", "I:NQUSMT": "NASDAQ US Mid Cap TR Index", "I:NQUSMV": "Nasdaq US Mid Cap Value Index", "I:NQUSMVN": "Nasdaq US Mid Cap Value NTR Index", "I:NQUSMVT": "Nasdaq US Mid Cap Value TR Index", "I:NQUSS": "NASDAQ US Small Cap Index", "I:NQUSS10": "Nasdaq US Small Cap Technology Index", "I:NQUSS101010": "Nasdaq US Small Cap Software and Computer Services Index", "I:NQUSS10101010": "Nasdaq US Small Cap Computer Services Index", "I:NQUSS10101010N": "Nasdaq US Small Cap Computer Services NTR Index", "I:NQUSS10101010T": "Nasdaq US Small Cap Computer Services TR Index", "I:NQUSS10101015": "Nasdaq US Small Cap Software Index", "I:NQUSS10101015N": "Nasdaq US Small Cap Software NTR Index", "I:NQUSS10101015T": "Nasdaq US Small Cap Software TR Index", "I:NQUSS10101020": "Nasdaq US Small Cap Consumer Digital Services Index", "I:NQUSS10101020N": "Nasdaq US Small Cap Consumer Digital Services NTR Index", "I:NQUSS10101020T": "Nasdaq US Small Cap Consumer Digital Services TR Index", "I:NQUSS101010N": "Nasdaq US Small Cap Software and Computer Services NTR Index", "I:NQUSS101010T": "Nasdaq US Small Cap Software and Computer Services TR Index", "I:NQUSS101020": "Nasdaq US Small Cap Technology Hardware and Equipment Index", "I:NQUSS10102010": "Nasdaq US Small Cap Semiconductors Index", "I:NQUSS10102010N": "Nasdaq US Small Cap Semiconductors NTR Index", "I:NQUSS10102010T": "Nasdaq US Small Cap Semiconductors TR Index", "I:NQUSS10102015": "Nasdaq Small Cap Electronic Components Index", "I:NQUSS10102015N": "Nasdaq Small Cap Electronic Components NTR Index", "I:NQUSS10102015T": "Nasdaq Small Cap Electronic Components TR Index", "I:NQUSS10102020": "Nasdaq Small Cap Production Technology Equipment Index", "I:NQUSS10102020N": "Nasdaq Small Cap Production Technology Equipment NTR Index", "I:NQUSS10102020T": "Nasdaq Small Cap Production Technology Equipment TR Index", "I:NQUSS10102030": "Nasdaq US Small Cap Computer Hardware Index", "I:NQUSS10102030N": "Nasdaq US Small Cap Computer Hardware NTR Index", "I:NQUSS10102030T": "Nasdaq US Small Cap Computer Hardware TR Index", "I:NQUSS101020N": "Nasdaq US Small Cap Technology Hardware and Equipment NTR Index", "I:NQUSS101020T": "Nasdaq US Small Cap Technology Hardware and Equipment TR Index", "I:NQUSS10N": "Nasdaq US Small Cap Technology NTR Index", "I:NQUSS10T": "Nasdaq US Small Cap Technology TR Index", "I:NQUSS15": "Nasdaq US Small Cap Telecommunications Index", "I:NQUSS1500": "NASDAQ US 1500 Index", "I:NQUSS1500N": "NASDAQ US 1500 NTR Index", "I:NQUSS1500T": "NASDAQ US 1500 TR Index", "I:NQUSS151010": "Nasdaq US Small Cap Telecommunications Equipment Index", "I:NQUSS151010N": "Nasdaq US Small Cap Telecommunications Equipment NTR Index", "I:NQUSS151010T": "Nasdaq US Small Cap Telecommunications Equipment TR Index", "I:NQUSS151020": "Nasdaq US Small Cap Telecommunications Service Providers Index", "I:NQUSS15102010": "Nasdaq Small Cap Cable Television Services Index", "I:NQUSS15102010N": "Nasdaq Small Cap Cable Television Services NTR Index", "I:NQUSS15102010T": "Nasdaq Small Cap Cable Television Services TR Index", "I:NQUSS15102015": "Nasdaq Small Cap Telecommunications Services Index", "I:NQUSS15102015N": "Nasdaq Small Cap Telecommunications Services NTR Index", "I:NQUSS15102015T": "Nasdaq Small Cap Telecommunications Services TR Index", "I:NQUSS151020N": "Nasdaq US Small Cap Telecommunications Service Providers NTR Index", "I:NQUSS151020T": "Nasdaq US Small Cap Telecommunications Service Providers TR Index", "I:NQUSS15N": "Nasdaq US Small Cap Telecommunications NTR Index", "I:NQUSS15T": "Nasdaq US Small Cap Telecommunications TR Index", "I:NQUSS20": "Nasdaq US Small Cap Health Care Index", "I:NQUSS201010": "Nasdaq US Small Cap Health Care Providers Index", "I:NQUSS20101010": "Nasdaq Small Cap Health Care Facilities Index", "I:NQUSS20101010N": "Nasdaq Small Cap Health Care Facilities NTR Index", "I:NQUSS20101010T": "Nasdaq Small Cap Health Care Facilities TR Index", "I:NQUSS20101020": "Nasdaq Small Cap Health Care Management Services Index", "I:NQUSS20101020N": "Nasdaq Small Cap Health Care Management Services NTR Index", "I:NQUSS20101020T": "Nasdaq Small Cap Health Care Management Services TR Index", "I:NQUSS20101025": "Nasdaq Small Cap Health Care Services Index", "I:NQUSS20101025N": "Nasdaq Small Cap Health Care Services NTR Index", "I:NQUSS20101025T": "Nasdaq Small Cap Health Care Services TR Index", "I:NQUSS201010N": "Nasdaq US Small Cap Health Care Providers NTR Index", "I:NQUSS201010T": "Nasdaq US Small Cap Health Care Providers TR Index", "I:NQUSS201020": "Nasdaq US Small Cap Medical Equipment and Services Index", "I:NQUSS20102010": "Nasdaq US Small Cap Medical Equipment Index", "I:NQUSS20102010N": "Nasdaq US Small Cap Medical Equipment NTR Index", "I:NQUSS20102010T": "Nasdaq US Small Cap Medical Equipment TR Index", "I:NQUSS20102015": "Nasdaq US Small Cap Medical Supplies Index", "I:NQUSS20102015N": "Nasdaq US Small Cap Medical Supplies NTR Index", "I:NQUSS20102015T": "Nasdaq US Small Cap Medical Supplies TR Index", "I:NQUSS20102020": "Nasdaq Small Cap Medical Services Index", "I:NQUSS20102020N": "Nasdaq Small Cap Medical Services NTR Index", "I:NQUSS20102020T": "Nasdaq Small Cap Medical Services TR Index", "I:NQUSS201020N": "Nasdaq US Small Cap Medical Equipment and Services NTR Index", "I:NQUSS201020T": "Nasdaq US Small Cap Medical Equipment and Services TR Index", "I:NQUSS201030": "Nasdaq US Small Cap Pharmaceuticals and Biotechnology Index", "I:NQUSS20103010": "Nasdaq US Small Cap Biotechnology Index", "I:NQUSS20103010N": "Nasdaq US Small Cap Biotechnology NTR Index", "I:NQUSS20103010T": "Nasdaq US Small Cap Biotechnology TR Index", "I:NQUSS20103015": "Nasdaq US Small Cap Pharmaceuticals Index", "I:NQUSS20103015N": "Nasdaq US Small Cap Pharmaceuticals NTR Index", "I:NQUSS20103015T": "Nasdaq US Small Cap Pharmaceuticals TR Index", "I:NQUSS201030N": "Nasdaq US Small Cap Pharmaceuticals and Biotechnology NTR Index", "I:NQUSS201030T": "Nasdaq US Small Cap Pharmaceuticals and Biotechnology TR Index", "I:NQUSS20N": "Nasdaq US Small Cap Health Care NTR Index", "I:NQUSS20T": "Nasdaq US Small Cap Health Care TR Index", "I:NQUSS30": "Nasdaq US Small Cap Financials Index", "I:NQUSS3010": "Nasdaq US Small Cap Banks Index", "I:NQUSS3010N": "Nasdaq US Small Cap Banks NTR Index", "I:NQUSS3010T": "Nasdaq US Small Cap Banks TR Index", "I:NQUSS3020": "Nasdaq US Small Cap Financial Services Index", "I:NQUSS302010": "Nasdaq US Small Cap Finance and Credit Services Index", "I:NQUSS30201020": "Nasdaq US Small Cap Consumer Lending Index", "I:NQUSS30201020N": "Nasdaq US Small Cap Consumer Lending NTR Index", "I:NQUSS30201020T": "Nasdaq US Small Cap Consumer Lending TR Index", "I:NQUSS30201025": "Nasdaq US Small Cap Mortgage Finance Index", "I:NQUSS30201025N": "Nasdaq US Small Cap Mortgage Finance NTR Index", "I:NQUSS30201025T": "Nasdaq US Small Cap Mortgage Finance TR Index", "I:NQUSS302010N": "Nasdaq US Small Cap Finance and Credit Services NTR Index", "I:NQUSS302010T": "Nasdaq US Small Cap Finance and Credit Services TR Index", "I:NQUSS302020": "Nasdaq US Small Cap Investment Banking and Brokerage Services Index", "I:NQUSS30202000": "Nasdaq US Small Cap Diversified Financial Services Index", "I:NQUSS30202000N": "Nasdaq US Small Cap Diversified Financial Services NTR Index", "I:NQUSS30202000T": "Nasdaq US Small Cap Diversified Financial Services TR Index", "I:NQUSS30202010": "Nasdaq US Small Cap Asset Managers and Custodians Index", "I:NQUSS30202010N": "Nasdaq US Small Cap Asset Managers and Custodians NTR Index", "I:NQUSS30202010T": "Nasdaq US Small Cap Asset Managers and Custodians TR Index", "I:NQUSS30202015": "Nasdaq US Small Cap Investment Services Index", "I:NQUSS30202015N": "Nasdaq US Small Cap Investment Services NTR Index", "I:NQUSS30202015T": "Nasdaq US Small Cap Investment Services TR Index", "I:NQUSS302020N": "Nasdaq US Small Cap Investment Banking and Brokerage Services NTR Index", "I:NQUSS302020T": "Nasdaq US Small Cap Investment Banking and Brokerage Services TR Index", "I:NQUSS302030": "Nasdaq US Small Cap Mortgage Real Estate Investment Trusts Index", "I:NQUSS30203000": "Nasdaq Small Cap Mortgage REITs: Diversified Index", "I:NQUSS30203000N": "Nasdaq Small Cap Mortgage REITs: Diversified NTR Index", "I:NQUSS30203000T": "Nasdaq Small Cap Mortgage REITs: Diversified TR Index", "I:NQUSS30203010": "Nasdaq Small Cap Mortgage REITs: Commercial Index", "I:NQUSS30203010N": "Nasdaq Small Cap Mortgage REITs: Commercial NTR Index", "I:NQUSS30203010T": "Nasdaq Small Cap Mortgage REITs: Commercial TR Index", "I:NQUSS30203020": "Nasdaq Small Cap Mortgage REITs: Residential Index", "I:NQUSS30203020N": "Nasdaq Small Cap Mortgage REITs: Residential NTR Index", "I:NQUSS30203020T": "Nasdaq Small Cap Mortgage REITs: Residential TR Index", "I:NQUSS302030N": "Nasdaq US Small Cap Mortgage Real Estate Investment Trusts NTR Index", "I:NQUSS302030T": "Nasdaq US Small Cap Mortgage Real Estate Investment Trusts TR Index", "I:NQUSS3020N": "Nasdaq US Small Cap Financial Services NTR Index", "I:NQUSS3020T": "Nasdaq US Small Cap Financial Services TR Index", "I:NQUSS3030": "Nasdaq US Small Cap Insurance Index", "I:NQUSS303010": "Nasdaq US Small Cap Life Insurance Index", "I:NQUSS303010N": "Nasdaq US Small Cap Life Insurance NTR Index", "I:NQUSS303010T": "Nasdaq US Small Cap Life Insurance TR Index", "I:NQUSS303020": "Nasdaq US Small Cap Non-life Insurance Index", "I:NQUSS30302010": "Nasdaq US Small Cap Full Line Insurance Index", "I:NQUSS30302010N": "Nasdaq US Small Cap Full Line Insurance NTR Index", "I:NQUSS30302010T": "Nasdaq US Small Cap Full Line Insurance TR Index", "I:NQUSS30302020": "Nasdaq US Small Cap Reinsurance Index", "I:NQUSS30302020N": "Nasdaq US Small Cap Reinsurance NTR Index", "I:NQUSS30302020T": "Nasdaq US Small Cap Reinsurance TR Index", "I:NQUSS30302025": "Nasdaq US Small Cap Property and Casualty Insurance Index", "I:NQUSS30302025N": "Nasdaq US Small Cap Property and Casualty Insurance NTR Index", "I:NQUSS30302025T": "Nasdaq US Small Cap Property and Casualty Insurance TR Index", "I:NQUSS303020N": "Nasdaq US Small Cap Non-life Insurance NTR Index", "I:NQUSS303020T": "Nasdaq US Small Cap Non-life Insurance TR Index", "I:NQUSS3030N": "Nasdaq US Small Cap Insurance NTR Index", "I:NQUSS3030T": "Nasdaq US Small Cap Insurance TR Index", "I:NQUSS30N": "Nasdaq US Small Cap Financials NTR Index", "I:NQUSS30T": "Nasdaq US Small Cap Financials TR Index", "I:NQUSS35": "Nasdaq US Small Cap Real Estate Index", "I:NQUSS351010": "Nasdaq US Small Cap Real Estate Investment and Services Index", "I:NQUSS35101010": "Nasdaq US Small Cap Real Estate Holding and Development Index", "I:NQUSS35101010N": "Nasdaq US Small Cap Real Estate Holding and Development NTR Index", "I:NQUSS35101010T": "Nasdaq US Small Cap Real Estate Holding and Development TR Index", "I:NQUSS35101015": "Nasdaq US Small Cap Real Estate Services Index", "I:NQUSS35101015N": "Nasdaq US Small Cap Real Estate Services NTR Index", "I:NQUSS35101015T": "Nasdaq US Small Cap Real Estate Services TR Index", "I:NQUSS351010N": "Nasdaq US Small Cap Real Estate Investment and Services NTR Index", "I:NQUSS351010T": "Nasdaq US Small Cap Real Estate Investment and Services TR Index", "I:NQUSS351020": "Nasdaq US Small Cap Real Estate Investment Trusts Index", "I:NQUSS35102000": "Nasdaq US Small Cap Diversified REITs Index", "I:NQUSS35102000N": "Nasdaq US Small Cap Diversified REITs NTR Index", "I:NQUSS35102000T": "Nasdaq US Small Cap Diversified REITs TR Index", "I:NQUSS35102010": "Nasdaq Small Cap Health Care REITs Index", "I:NQUSS35102010N": "Nasdaq Small Cap Health Care REITs NTR Index", "I:NQUSS35102010T": "Nasdaq Small Cap Health Care REITs TR Index", "I:NQUSS35102015": "Nasdaq US Small Cap Hotel and Lodging REITs Index", "I:NQUSS35102015N": "Nasdaq US Small Cap Hotel and Lodging REITs NTR Index", "I:NQUSS35102015T": "Nasdaq US Small Cap Hotel and Lodging REITs TR Index", "I:NQUSS35102020": "Nasdaq Small Cap Industrial REITs Index", "I:NQUSS35102020N": "Nasdaq Small Cap Industrial REITs NTR Index", "I:NQUSS35102020T": "Nasdaq Small Cap Industrial REITs TR Index", "I:NQUSS35102030": "Nasdaq Small Cap Office REITs Index", "I:NQUSS35102030N": "Nasdaq Small Cap Office REITs NTR Index", "I:NQUSS35102030T": "Nasdaq Small Cap Office REITs TR Index", "I:NQUSS35102040": "Nasdaq US Small Cap Residential REITs Index", "I:NQUSS35102040N": "Nasdaq US Small Cap Residential REITs NTR Index", "I:NQUSS35102040T": "Nasdaq US Small Cap Residential REITs TR Index", "I:NQUSS35102045": "Nasdaq US Small Cap Retail REITs Index", "I:NQUSS35102045N": "Nasdaq US Small Cap Retail REITs NTR Index", "I:NQUSS35102045T": "Nasdaq US Small Cap Retail REITs TR Index", "I:NQUSS35102070": "Nasdaq Small Cap Other Specialty REITs Index", "I:NQUSS35102070N": "Nasdaq Small Cap Other Specialty REITs NTR Index", "I:NQUSS35102070T": "Nasdaq Small Cap Other Specialty REITs TR Index", "I:NQUSS351020N": "Nasdaq US Small Cap Real Estate Investment Trusts NTR Index", "I:NQUSS351020T": "Nasdaq US Small Cap Real Estate Investment Trusts TR Index", "I:NQUSS35N": "Nasdaq US Small Cap Real Estate NTR Index", "I:NQUSS35T": "Nasdaq US Small Cap Real Estate TR Index", "I:NQUSS40": "Nasdaq US Small Cap Consumer Discretionary Index", "I:NQUSS4010": "Nasdaq US Small Cap Automobiles and Parts Index", "I:NQUSS40101020": "Nasdaq US Small Cap Automobiles Index", "I:NQUSS40101020N": "Nasdaq US Small Cap Automobiles NTR Index", "I:NQUSS40101020T": "Nasdaq US Small Cap Automobiles TR Index", "I:NQUSS40101025": "Nasdaq US Small Cap Auto Parts Index", "I:NQUSS40101025N": "Nasdaq US Small Cap Auto Parts NTR Index", "I:NQUSS40101025T": "Nasdaq US Small Cap Auto Parts TR Index", "I:NQUSS4010N": "Nasdaq US Small Cap Automobiles and Parts NTR Index", "I:NQUSS4010T": "Nasdaq US Small Cap Automobiles and Parts TR Index", "I:NQUSS4020": "Nasdaq US Small Cap Consumer Products and Services Index", "I:NQUSS402010": "Nasdaq US Small Cap Consumer Services Index", "I:NQUSS40201010": "Nasdaq Small Cap Education Services Index", "I:NQUSS40201010N": "Nasdaq Small Cap Education Services NTR Index", "I:NQUSS40201010T": "Nasdaq Small Cap Education Services TR Index", "I:NQUSS40201070": "Nasdaq Small Cap Consumer Services: Misc. Index", "I:NQUSS40201070N": "Nasdaq Small Cap Consumer Services: Misc. NTR Index", "I:NQUSS40201070T": "Nasdaq Small Cap Consumer Services: Misc. TR Index", "I:NQUSS402010N": "Nasdaq US Small Cap Consumer Services NTR Index", "I:NQUSS402010T": "Nasdaq US Small Cap Consumer Services TR Index", "I:NQUSS402020": "Nasdaq US Small Cap Household Goods and Home Construction Index", "I:NQUSS40202010": "Nasdaq US Small Cap Home Construction Index", "I:NQUSS40202010N": "Nasdaq US Small Cap Home Construction NTR Index", "I:NQUSS40202010T": "Nasdaq US Small Cap Home Construction TR Index", "I:NQUSS40202015": "Nasdaq US Small Cap Household Furnishings Index", "I:NQUSS40202015N": "Nasdaq US Small Cap Household Furnishings NTR Index", "I:NQUSS40202015T": "Nasdaq US Small Cap Household Furnishings TR Index", "I:NQUSS40202025": "Nasdaq Small Cap Household Equipment and Products Index", "I:NQUSS40202025N": "Nasdaq Small Cap Household Equipment and Products NTR Index", "I:NQUSS40202025T": "Nasdaq Small Cap Household Equipment and Products TR Index", "I:NQUSS402020N": "Nasdaq US Small Cap Household Goods and Home Construction NTR Index", "I:NQUSS402020T": "Nasdaq US Small Cap Household Goods and Home Construction TR Index", "I:NQUSS402030": "Nasdaq US Small Cap Leisure Goods Index", "I:NQUSS40203010": "Nasdaq US Small Cap Consumer Electronics Index", "I:NQUSS40203010N": "Nasdaq US Small Cap Consumer Electronics NTR Index", "I:NQUSS40203010T": "Nasdaq US Small Cap Consumer Electronics TR Index", "I:NQUSS40203045": "Nasdaq US Small Cap Toys Index", "I:NQUSS40203045N": "Nasdaq US Small Cap Toys NTR Index", "I:NQUSS40203045T": "Nasdaq US Small Cap Toys TR Index", "I:NQUSS40203050": "Nasdaq US Small Cap Recreational Products Index", "I:NQUSS40203050N": "Nasdaq US Small Cap Recreational Products NTR Index", "I:NQUSS40203050T": "Nasdaq US Small Cap Recreational Products TR Index", "I:NQUSS40203055": "Nasdaq Small Cap Recreational Vehicles and Boats Index", "I:NQUSS40203055N": "Nasdaq Small Cap Recreational Vehicles and Boats NTR Index", "I:NQUSS40203055T": "Nasdaq Small Cap Recreational Vehicles and Boats TR Index", "I:NQUSS402030N": "Nasdaq US Small Cap Leisure Goods NTR Index", "I:NQUSS402030T": "Nasdaq US Small Cap Leisure Goods TR Index", "I:NQUSS402040": "Nasdaq US Small Cap Personal Goods Index", "I:NQUSS40204020": "Nasdaq US Small Cap Clothing and Accessories Index", "I:NQUSS40204020N": "Nasdaq US Small Cap Clothing and Accessories NTR Index", "I:NQUSS40204020T": "Nasdaq US Small Cap Clothing and Accessories TR Index", "I:NQUSS40204025": "Nasdaq US Small Cap Footwear Index", "I:NQUSS40204025N": "Nasdaq US Small Cap Footwear NTR Index", "I:NQUSS40204025T": "Nasdaq US Small Cap Footwear TR Index", "I:NQUSS402040N": "Nasdaq US Small Cap Personal Goods NTR Index", "I:NQUSS402040T": "Nasdaq US Small Cap Personal Goods TR Index", "I:NQUSS4020N": "Nasdaq US Small Cap Consumer Products and Services NTR Index", "I:NQUSS4020T": "Nasdaq US Small Cap Consumer Products and Services TR Index", "I:NQUSS4030": "Nasdaq US Small Cap Media Index", "I:NQUSS40301010": "Nasdaq Small Cap Entertainment Index", "I:NQUSS40301010N": "Nasdaq Small Cap Entertainment NTR Index", "I:NQUSS40301010T": "Nasdaq Small Cap Entertainment TR Index", "I:NQUSS40301020": "Nasdaq US Small Cap Media Agencies Index", "I:NQUSS40301020N": "Nasdaq US Small Cap Media Agencies NTR Index", "I:NQUSS40301020T": "Nasdaq US Small Cap Media Agencies TR Index", "I:NQUSS40301030": "Nasdaq US Small Cap Publishing Index", "I:NQUSS40301030N": "Nasdaq US Small Cap Publishing NTR Index", "I:NQUSS40301030T": "Nasdaq US Small Cap Publishing TR Index", "I:NQUSS40301035": "Nasdaq Small Cap Radio and TV Broadcasters Index", "I:NQUSS40301035N": "Nasdaq Small Cap Radio and TV Broadcasters NTR Index", "I:NQUSS40301035T": "Nasdaq Small Cap Radio and TV Broadcasters TR Index", "I:NQUSS4030N": "Nasdaq US Small Cap Media NTR Index", "I:NQUSS4030T": "Nasdaq US Small Cap Media TR Index", "I:NQUSS4040": "Nasdaq US Small Cap Retail Index", "I:NQUSS404010": "Nasdaq US Small Cap Retailers Index", "I:NQUSS40401010": "Nasdaq US Small Cap Diversified Retailers Index", "I:NQUSS40401010N": "Nasdaq US Small Cap Diversified Retailers NTR Index", "I:NQUSS40401010T": "Nasdaq US Small Cap Diversified Retailers TR Index", "I:NQUSS40401020": "Nasdaq US Small Cap Apparel Retailers Index", "I:NQUSS40401020N": "Nasdaq US Small Cap Apparel Retailers NTR Index", "I:NQUSS40401020T": "Nasdaq US Small Cap Apparel Retailers TR Index", "I:NQUSS40401025": "Nasdaq US Small Cap Home Improvement Retailers Index", "I:NQUSS40401025N": "Nasdaq US Small Cap Home Improvement Retailers NTR Index", "I:NQUSS40401025T": "Nasdaq US Small Cap Home Improvement Retailers TR Index", "I:NQUSS40401030": "Nasdaq US Small Cap Specialty Retailers Index", "I:NQUSS40401030N": "Nasdaq US Small Cap Specialty Retailers NTR Index", "I:NQUSS40401030T": "Nasdaq US Small Cap Specialty Retailers TR Index", "I:NQUSS404010N": "Nasdaq US Small Cap Retailers NTR Index", "I:NQUSS404010T": "Nasdaq US Small Cap Retailers TR Index", "I:NQUSS4040N": "Nasdaq US Small Cap Retail NTR Index", "I:NQUSS4040T": "Nasdaq US Small Cap Retail TR Index", "I:NQUSS4050": "Nasdaq US Small Cap Travel and Leisure Index", "I:NQUSS40501010": "Nasdaq US Small Cap Airlines Index", "I:NQUSS40501010N": "Nasdaq US Small Cap Airlines NTR Index", "I:NQUSS40501010T": "Nasdaq US Small Cap Airlines TR Index", "I:NQUSS40501015": "Nasdaq US Small Cap Travel and Tourism Index", "I:NQUSS40501015N": "Nasdaq US Small Cap Travel and Tourism NTR Index", "I:NQUSS40501015T": "Nasdaq US Small Cap Travel and Tourism TR Index", "I:NQUSS40501020": "Nasdaq US Small Cap Casinos and Gambling Index", "I:NQUSS40501020N": "Nasdaq US Small Cap Casinos and Gambling NTR Index", "I:NQUSS40501020T": "Nasdaq US Small Cap Casinos and Gambling TR Index", "I:NQUSS40501025": "Nasdaq US Small Cap Hotels and Motels Index", "I:NQUSS40501025N": "Nasdaq US Small Cap Hotels and Motels NTR Index", "I:NQUSS40501025T": "Nasdaq US Small Cap Hotels and Motels TR Index", "I:NQUSS40501030": "Nasdaq US Small Cap Recreational Services Index", "I:NQUSS40501030N": "Nasdaq US Small Cap Recreational Services NTR Index", "I:NQUSS40501030T": "Nasdaq US Small Cap Recreational Services TR Index", "I:NQUSS40501040": "Nasdaq US Small Cap Restaurants and Bars Index", "I:NQUSS40501040N": "Nasdaq US Small Cap Restaurants and Bars NTR Index", "I:NQUSS40501040T": "Nasdaq US Small Cap Restaurants and Bars TR Index", "I:NQUSS4050N": "Nasdaq US Small Cap Travel and Leisure NTR Index", "I:NQUSS4050T": "Nasdaq US Small Cap Travel and Leisure TR Index", "I:NQUSS40N": "Nasdaq US Small Cap Consumer Discretionary NTR Index", "I:NQUSS40T": "Nasdaq US Small Cap Consumer Discretionary TR Index", "I:NQUSS45": "Nasdaq US Small Cap Consumer Staples Index", "I:NQUSS4510": "Nasdaq US Small Cap Food, Beverage and Tobacco Index", "I:NQUSS451010": "Nasdaq US Small Cap Beverages Index", "I:NQUSS45101020": "Nasdaq US Small Cap Soft Drinks Index", "I:NQUSS45101020N": "Nasdaq US Small Cap Soft Drinks NTR Index", "I:NQUSS45101020T": "Nasdaq US Small Cap Soft Drinks TR Index", "I:NQUSS451010N": "Nasdaq US Small Cap Beverages NTR Index", "I:NQUSS451010T": "Nasdaq US Small Cap Beverages TR Index", "I:NQUSS451020": "Nasdaq US Small Cap Food Producers Index", "I:NQUSS45102020": "Nasdaq US Small Cap Food Products Index", "I:NQUSS45102020N": "Nasdaq US Small Cap Food Products NTR Index", "I:NQUSS45102020T": "Nasdaq US Small Cap Food Products TR Index", "I:NQUSS451020N": "Nasdaq US Small Cap Food Producers NTR Index", "I:NQUSS451020T": "Nasdaq US Small Cap Food Producers TR Index", "I:NQUSS451030": "Nasdaq US Small Cap Tobacco Index", "I:NQUSS451030N": "Nasdaq US Small Cap Tobacco NTR Index", "I:NQUSS451030T": "Nasdaq US Small Cap Tobacco TR Index", "I:NQUSS4510N": "Nasdaq US Small Cap Food, Beverage and Tobacco NTR Index", "I:NQUSS4510T": "Nasdaq US Small Cap Food, Beverage and Tobacco TR Index", "I:NQUSS4520": "Nasdaq US Small Cap Personal Care, Drug and Grocery Stores Index", "I:NQUSS45201010": "Nasdaq US Small Cap Food Retailers and Wholesalers Index", "I:NQUSS45201010N": "Nasdaq US Small Cap Food Retailers and Wholesalers NTR Index", "I:NQUSS45201010T": "Nasdaq US Small Cap Food Retailers and Wholesalers TR Index", "I:NQUSS45201020": "Nasdaq US Small Cap Personal Products Index", "I:NQUSS45201020N": "Nasdaq US Small Cap Personal Products NTR Index", "I:NQUSS45201020T": "Nasdaq US Small Cap Personal Products TR Index", "I:NQUSS45201030": "Nasdaq US Small Cap Nondurable Household Products Index", "I:NQUSS45201030N": "Nasdaq US Small Cap Nondurable Household Products NTR Index", "I:NQUSS45201030T": "Nasdaq US Small Cap Nondurable Household Products TR Index", "I:NQUSS4520N": "Nasdaq US Small Cap Personal Care, Drug and Grocery Stores NTR Index", "I:NQUSS4520T": "Nasdaq US Small Cap Personal Care, Drug and Grocery Stores TR Index", "I:NQUSS45N": "Nasdaq US Small Cap Consumer Staples NTR Index", "I:NQUSS45T": "Nasdaq US Small Cap Consumer Staples TR Index", "I:NQUSS50": "Nasdaq US Small Cap Industrials Index", "I:NQUSS5010": "Nasdaq US Small Cap Construction and Materials Index", "I:NQUSS50101010": "Nasdaq Small Cap Construction Index", "I:NQUSS50101010N": "Nasdaq Small Cap Construction NTR Index", "I:NQUSS50101010T": "Nasdaq Small Cap Construction TR Index", "I:NQUSS50101015": "Nasdaq Small Cap Engineering and Contracting Services Index", "I:NQUSS50101015N": "Nasdaq Small Cap Engineering and Contracting Services NTR Index", "I:NQUSS50101015T": "Nasdaq Small Cap Engineering and Contracting Services TR Index", "I:NQUSS50101020": "Nasdaq Small Cap Building, Roofing/Wallboard and Plumbing Index", "I:NQUSS50101020N": "Nasdaq Small Cap Building, Roofing/Wallboard and Plumbing NTR Index", "I:NQUSS50101020T": "Nasdaq Small Cap Building, Roofing/Wallboard and Plumbing TR Index", "I:NQUSS50101035": "Nasdaq Small Cap Building Materials: Other Index", "I:NQUSS50101035N": "Nasdaq Small Cap Building Materials: Other NTR Index", "I:NQUSS50101035T": "Nasdaq Small Cap Building Materials: Other TR Index", "I:NQUSS5010N": "Nasdaq US Small Cap Construction and Materials NTR Index", "I:NQUSS5010T": "Nasdaq US Small Cap Construction and Materials TR Index", "I:NQUSS5020": "Nasdaq US Small Cap Industrial Goods and Services Index", "I:NQUSS502010": "Nasdaq US Small Cap Aerospace and Defense Index", "I:NQUSS50201010": "Nasdaq US Small Cap Aerospace Index", "I:NQUSS50201010N": "Nasdaq US Small Cap Aerospace NTR Index", "I:NQUSS50201010T": "Nasdaq US Small Cap Aerospace TR Index", "I:NQUSS50201020": "Nasdaq US Small Cap Defense Index", "I:NQUSS50201020N": "Nasdaq US Small Cap Defense NTR Index", "I:NQUSS50201020T": "Nasdaq US Small Cap Defense TR Index", "I:NQUSS502010N": "Nasdaq US Small Cap Aerospace and Defense NTR Index", "I:NQUSS502010T": "Nasdaq US Small Cap Aerospace and Defense TR Index", "I:NQUSS502020": "Nasdaq US Small Cap Electronic and Electrical Equipment Index", "I:NQUSS50202010": "Nasdaq Small Cap Electrical Components Index", "I:NQUSS50202010N": "Nasdaq Small Cap Electrical Components NTR Index", "I:NQUSS50202010T": "Nasdaq Small Cap Electrical Components TR Index", "I:NQUSS50202020": "Nasdaq Small Cap Electronic Equipment: Control and Filter Index", "I:NQUSS50202020N": "Nasdaq Small Cap Electronic Equipment: Control and Filter NTR Index", "I:NQUSS50202020T": "Nasdaq Small Cap Electronic Equipment: Control and Filter TR Index", "I:NQUSS50202025": "Nasdaq Small Cap Electronic Equipment: Gauges and Meters Index", "I:NQUSS50202025N": "Nasdaq Small Cap Electronic Equipment: Gauges and Meters NTR Index", "I:NQUSS50202025T": "Nasdaq Small Cap Electronic Equipment: Gauges and Meters TR Index", "I:NQUSS502020N": "Nasdaq US Small Cap Electronic and Electrical Equipment NTR Index", "I:NQUSS502020T": "Nasdaq US Small Cap Electronic and Electrical Equipment TR Index", "I:NQUSS502030": "Nasdaq US Small Cap General Industrials Index", "I:NQUSS50203000": "Nasdaq US Small Cap Diversified Industrials Index", "I:NQUSS50203000N": "Nasdaq US Small Cap Diversified Industrials NTR Index", "I:NQUSS50203000T": "Nasdaq US Small Cap Diversified Industrials TR Index", "I:NQUSS50203030": "Nasdaq US Small Cap Containers and Packaging Index", "I:NQUSS50203030N": "Nasdaq US Small Cap Containers and Packaging NTR Index", "I:NQUSS50203030T": "Nasdaq US Small Cap Containers and Packaging TR Index", "I:NQUSS502030N": "Nasdaq US Small Cap General Industrials NTR Index", "I:NQUSS502030T": "Nasdaq US Small Cap General Industrials TR Index", "I:NQUSS502040": "Nasdaq US Small Cap Industrial Engineering Index", "I:NQUSS50204000": "Nasdaq Small Cap Machinery: Industrial Index", "I:NQUSS50204000N": "Nasdaq Small Cap Machinery: Industrial NTR Index", "I:NQUSS50204000T": "Nasdaq Small Cap Machinery: Industrial TR Index", "I:NQUSS50204020": "Nasdaq Small Cap Machinery: Construction and Handling Index", "I:NQUSS50204020N": "Nasdaq Small Cap Machinery: Construction and Handling NTR Index", "I:NQUSS50204020T": "Nasdaq Small Cap Machinery: Construction and Handling TR Index", "I:NQUSS50204050": "Nasdaq Small Cap Machinery: Specialty Index", "I:NQUSS50204050N": "Nasdaq Small Cap Machinery: Specialty NTR Index", "I:NQUSS50204050T": "Nasdaq Small Cap Machinery: Specialty TR Index", "I:NQUSS502040N": "Nasdaq US Small Cap Industrial Engineering NTR Index", "I:NQUSS502040T": "Nasdaq US Small Cap Industrial Engineering TR Index", "I:NQUSS502050": "Nasdaq US Small Cap Industrial Support Services Index", "I:NQUSS50205010": "Nasdaq US Small Cap Industrial Suppliers Index", "I:NQUSS50205010N": "Nasdaq US Small Cap Industrial Suppliers NTR Index", "I:NQUSS50205010T": "Nasdaq US Small Cap Industrial Suppliers TR Index", "I:NQUSS50205015": "Nasdaq Small Cap Transaction Processing Services Index", "I:NQUSS50205015N": "Nasdaq Small Cap Transaction Processing Services NTR Index", "I:NQUSS50205015T": "Nasdaq Small Cap Transaction Processing Services TR Index", "I:NQUSS50205020": "Nasdaq Small Cap Professional Business Support Services Index", "I:NQUSS50205020N": "Nasdaq Small Cap Professional Business Support Services NTR Index", "I:NQUSS50205020T": "Nasdaq Small Cap Professional Business Support Services TR Index", "I:NQUSS50205025": "Nasdaq US Small Cap Business Training and Employment Agencies Index", "I:NQUSS50205025N": "Nasdaq US Small Cap Business Training and Employment Agencies NTR Index", "I:NQUSS50205025T": "Nasdaq US Small Cap Business Training and Employment Agencies TR Index", "I:NQUSS50205030": "Nasdaq Small Cap Forms and Bulk Printing Services Index", "I:NQUSS50205030N": "Nasdaq Small Cap Forms and Bulk Printing Services NTR Index", "I:NQUSS50205030T": "Nasdaq Small Cap Forms and Bulk Printing Services TR Index", "I:NQUSS50205040": "Nasdaq Small Cap Security Services Index", "I:NQUSS50205040N": "Nasdaq Small Cap Security Services NTR Index", "I:NQUSS50205040T": "Nasdaq Small Cap Security Services TR Index", "I:NQUSS502050N": "Nasdaq US Small Cap Industrial Support Services NTR Index", "I:NQUSS502050T": "Nasdaq US Small Cap Industrial Support Services TR Index", "I:NQUSS502060": "Nasdaq US Small Cap Industrial Transportation Index", "I:NQUSS50206010": "Nasdaq US Small Cap Trucking Index", "I:NQUSS50206010N": "Nasdaq US Small Cap Trucking NTR Index", "I:NQUSS50206010T": "Nasdaq US Small Cap Trucking TR Index", "I:NQUSS50206015": "Nasdaq Small Cap Commercial Vehicles and Parts Index", "I:NQUSS50206015N": "Nasdaq Small Cap Commercial Vehicles and Parts NTR Index", "I:NQUSS50206015T": "Nasdaq Small Cap Commercial Vehicles and Parts TR Index", "I:NQUSS50206030": "Nasdaq US Small Cap Marine Transportation Index", "I:NQUSS50206030N": "Nasdaq US Small Cap Marine Transportation NTR Index", "I:NQUSS50206030T": "Nasdaq US Small Cap Marine Transportation TR Index", "I:NQUSS50206050": "Nasdaq Small Cap Commercial Vehicle-Equipment Leasing Index", "I:NQUSS50206050N": "Nasdaq Small Cap Commercial Vehicle-Equipment Leasing NTR Index", "I:NQUSS50206050T": "Nasdaq Small Cap Commercial Vehicle-Equipment Leasing TR Index", "I:NQUSS50206060": "Nasdaq US Small Cap Transportation Services Index", "I:NQUSS50206060N": "Nasdaq US Small Cap Transportation Services NTR Index", "I:NQUSS50206060T": "Nasdaq US Small Cap Transportation Services TR Index", "I:NQUSS502060N": "Nasdaq US Small Cap Industrial Transportation NTR Index", "I:NQUSS502060T": "Nasdaq US Small Cap Industrial Transportation TR Index", "I:NQUSS5020N": "Nasdaq US Small Cap Industrial Goods and Services NTR Index", "I:NQUSS5020T": "Nasdaq US Small Cap Industrial Goods and Services TR Index", "I:NQUSS50N": "Nasdaq US Small Cap Industrials NTR Index", "I:NQUSS50T": "Nasdaq US Small Cap Industrials TR Index", "I:NQUSS55": "Nasdaq US Small Cap Basic Materials Index", "I:NQUSS5510": "Nasdaq US Small Cap Basic Resources Index", "I:NQUSS551010": "Nasdaq US Small Cap Industrial Materials Index", "I:NQUSS55101000": "Nasdaq Small Cap Diversified Materials Index", "I:NQUSS55101000N": "Nasdaq Small Cap Diversified Materials NTR Index", "I:NQUSS55101000T": "Nasdaq Small Cap Diversified Materials TR Index", "I:NQUSS55101015": "Nasdaq US Small Cap Paper Index", "I:NQUSS55101015N": "Nasdaq US Small Cap Paper NTR Index", "I:NQUSS55101015T": "Nasdaq US Small Cap Paper TR Index", "I:NQUSS551010N": "Nasdaq US Small Cap Industrial Materials NTR Index", "I:NQUSS551010T": "Nasdaq US Small Cap Industrial Materials TR Index", "I:NQUSS551020": "Nasdaq US Small Cap Industrial Metals and Mining Index", "I:NQUSS55102000": "Nasdaq US Small Cap General Mining Index", "I:NQUSS55102000N": "Nasdaq US Small Cap General Mining NTR Index", "I:NQUSS55102000T": "Nasdaq US Small Cap General Mining TR Index", "I:NQUSS55102010": "Nasdaq US Small Cap Iron and Steel Index", "I:NQUSS55102010N": "Nasdaq US Small Cap Iron and Steel NTR Index", "I:NQUSS55102010T": "Nasdaq US Small Cap Iron and Steel TR Index", "I:NQUSS55102015": "Nasdaq Small Cap Metal Fabricating Index", "I:NQUSS55102015N": "Nasdaq Small Cap Metal Fabricating NTR Index", "I:NQUSS55102015T": "Nasdaq Small Cap Metal Fabricating TR Index", "I:NQUSS551020N": "Nasdaq US Small Cap Industrial Metals and Mining NTR Index", "I:NQUSS551020T": "Nasdaq US Small Cap Industrial Metals and Mining TR Index", "I:NQUSS551030": "Nasdaq US Small Cap Precious Metals and Mining Index", "I:NQUSS55103025": "Nasdaq US Small Cap Gold Mining Index", "I:NQUSS55103025N": "Nasdaq US Small Cap Gold Mining NTR Index", "I:NQUSS55103025T": "Nasdaq US Small Cap Gold Mining TR Index", "I:NQUSS551030N": "Nasdaq US Small Cap Precious Metals and Mining NTR Index", "I:NQUSS551030T": "Nasdaq US Small Cap Precious Metals and Mining TR Index", "I:NQUSS5510N": "Nasdaq US Small Cap Basic Resources NTR Index", "I:NQUSS5510T": "Nasdaq US Small Cap Basic Resources TR Index", "I:NQUSS5520": "Nasdaq US Small Cap Chemicals Index", "I:NQUSS55201000": "Nasdaq Small Cap Chemicals: Diversified Index", "I:NQUSS55201000N": "Nasdaq Small Cap Chemicals: Diversified NTR Index", "I:NQUSS55201000T": "Nasdaq Small Cap Chemicals: Diversified TR Index", "I:NQUSS55201020": "Nasdaq US Small Cap Specialty Chemicals Index", "I:NQUSS55201020N": "Nasdaq US Small Cap Specialty Chemicals NTR Index", "I:NQUSS55201020T": "Nasdaq US Small Cap Specialty Chemicals TR Index", "I:NQUSS5520N": "Nasdaq US Small Cap Chemicals NTR Index", "I:NQUSS5520T": "Nasdaq US Small Cap Chemicals TR Index", "I:NQUSS55N": "Nasdaq US Small Cap Basic Materials NTR Index", "I:NQUSS55T": "Nasdaq US Small Cap Basic Materials TR Index", "I:NQUSS60": "Nasdaq US Small Cap Energy Index", "I:NQUSS601010": "Nasdaq US Small Cap Oil, Gas and Coal Index", "I:NQUSS60101010": "Nasdaq Small Cap Oil: Crude Producers Index", "I:NQUSS60101010N": "Nasdaq Small Cap Oil: Crude Producers NTR Index", "I:NQUSS60101010T": "Nasdaq Small Cap Oil: Crude Producers TR Index", "I:NQUSS60101020": "Nasdaq Small Cap Oil Refining and Marketing Index", "I:NQUSS60101020N": "Nasdaq Small Cap Oil Refining and Marketing NTR Index", "I:NQUSS60101020T": "Nasdaq Small Cap Oil Refining and Marketing TR Index", "I:NQUSS60101030": "Nasdaq US Small Cap Oil Equipment and Services Index", "I:NQUSS60101030N": "Nasdaq US Small Cap Oil Equipment and Services NTR Index", "I:NQUSS60101030T": "Nasdaq US Small Cap Oil Equipment and Services TR Index", "I:NQUSS60101035": "Nasdaq US Small Cap Pipelines Index", "I:NQUSS60101035N": "Nasdaq US Small Cap Pipelines NTR Index", "I:NQUSS60101035T": "Nasdaq US Small Cap Pipelines TR Index", "I:NQUSS60101040": "Nasdaq US Small Cap Coal Index", "I:NQUSS60101040N": "Nasdaq US Small Cap Coal NTR Index", "I:NQUSS60101040T": "Nasdaq US Small Cap Coal TR Index", "I:NQUSS601010N": "Nasdaq US Small Cap Oil, Gas and Coal NTR Index", "I:NQUSS601010T": "Nasdaq US Small Cap Oil, Gas and Coal TR Index", "I:NQUSS601020": "Nasdaq US Small Cap Alternative Energy Index", "I:NQUSS60102010": "Nasdaq US Small Cap Alternative Fuels Index", "I:NQUSS60102010N": "Nasdaq US Small Cap Alternative Fuels NTR Index", "I:NQUSS60102010T": "Nasdaq US Small Cap Alternative Fuels TR Index", "I:NQUSS60102020": "Nasdaq US Small Cap Renewable Energy Equipment Index", "I:NQUSS60102020N": "Nasdaq US Small Cap Renewable Energy Equipment NTR Index", "I:NQUSS60102020T": "Nasdaq US Small Cap Renewable Energy Equipment TR Index", "I:NQUSS601020N": "Nasdaq US Small Cap Alternative Energy NTR Index", "I:NQUSS601020T": "Nasdaq US Small Cap Alternative Energy TR Index", "I:NQUSS60N": "Nasdaq US Small Cap Energy NTR Index", "I:NQUSS60T": "Nasdaq US Small Cap Energy TR Index", "I:NQUSS65": "Nasdaq US Small Cap Utilities Index", "I:NQUSS651010": "Nasdaq US Small Cap Electricity Index", "I:NQUSS65101010": "Nasdaq US Small Cap Alternative Electricity Index", "I:NQUSS65101010N": "Nasdaq US Small Cap Alternative Electricity NTR Index", "I:NQUSS65101010T": "Nasdaq US Small Cap Alternative Electricity TR Index", "I:NQUSS65101015": "Nasdaq US Small Cap Conventional Electricity Index", "I:NQUSS65101015N": "Nasdaq US Small Cap Conventional Electricity NTR Index", "I:NQUSS65101015T": "Nasdaq US Small Cap Conventional Electricity TR Index", "I:NQUSS651010N": "Nasdaq US Small Cap Electricity NTR Index", "I:NQUSS651010T": "Nasdaq US Small Cap Electricity TR Index", "I:NQUSS651020": "Nasdaq US Small Cap Gas, Water and Multi-utilities Index", "I:NQUSS65102020": "Nasdaq US Small Cap Gas Distribution Index", "I:NQUSS65102020N": "Nasdaq US Small Cap Gas Distribution NTR Index", "I:NQUSS65102020T": "Nasdaq US Small Cap Gas Distribution TR Index", "I:NQUSS65102030": "Nasdaq US Small Cap Water Index", "I:NQUSS65102030N": "Nasdaq US Small Cap Water NTR Index", "I:NQUSS65102030T": "Nasdaq US Small Cap Water TR Index", "I:NQUSS651020N": "Nasdaq US Small Cap Gas, Water and Multi-utilities NTR Index", "I:NQUSS651020T": "Nasdaq US Small Cap Gas, Water and Multi-utilities TR Index", "I:NQUSS651030": "Nasdaq US Small Cap Waste and Disposal Services Index", "I:NQUSS651030N": "Nasdaq US Small Cap Waste and Disposal Services NTR Index", "I:NQUSS651030T": "Nasdaq US Small Cap Waste and Disposal Services TR Index", "I:NQUSS65N": "Nasdaq US Small Cap Utilities NTR Index", "I:NQUSS65T": "Nasdaq US Small Cap Utilities TR Index", "I:NQUSSG": "Nasdaq US Small Cap Growth Index", "I:NQUSSGN": "Nasdaq US Small Cap Growth NTR Index", "I:NQUSSGT": "Nasdaq US Small Cap Growth TR Index", "I:NQUSSN": "NASDAQ US Small Cap NTR Index", "I:NQUSST": "NASDAQ US Small Cap TR Index", "I:NQUSSV": "Nasdaq US Small Cap Value Index", "I:NQUSSVN": "Nasdaq US Small Cap Value NTR Index", "I:NQUSSVT": "Nasdaq US Small Cap Value TR Index", "I:NQVDIV": "Nasdaq Victory Dividend Accelerator Index", "I:NQVDIVDVP": "Nasdaq Victory Dividend Accelerator Dividend Point", "I:NQVDIVN": "Nasdaq Victory Dividend Accelerator NTR Index", "I:NQVDIVT": "Nasdaq Victory Dividend Accelerator TR Index", "I:NQVMVG": "Nasdaq Victory Global Multi-Factor Min Vol Index", "I:NQVMVGN": "Nasdaq Victory Global Multi-Factor Min Vol NTR", "I:NQVMVGT": "Nasdaq Victory Global Multi-Factor Min Vol TR", "I:NQVMVI": "Nasdaq Victory Int'l Multi-Factor Min Vol Index", "I:NQVMVIN": "Nasdaq Victory Int'l Multi-Factor Min Vol NTR", "I:NQVMVIT": "Nasdaq Victory Int'l Multi-Factor Min Vol TR", "I:NQVMVUS": "Nasdaq Victory US Multi-Factor Minimum Volatility", "I:NQVMVUSN": "Nasdaq Victory US Multi-Factor Mini Volatility NTR", "I:NQVMVUST": "Nasdaq Victory US Multi-Factor Min Volatility TR", "I:NQVWED": "Nasdaq Victory EM 100 High Div Vol Wt Index", "I:NQVWEDN": "Nasdaq Victory EM 100 High Div Vol Wt NTR Index", "I:NQVWEDT": "Nasdaq Victory EM 100 High Div Vol Wt TR Index", "I:NQVWEM": "Nasdaq Victory EM 500 Vol Wt Index", "I:NQVWEMN": "Nasdaq Victory EM 500 Vol Wt NTR Index", "I:NQVWEMT": "Nasdaq Victory EM 500 Vol Wt TR Index", "I:NQVWID": "Nasdaq Victory Intl 100 High Div Vol Wt", "I:NQVWIDN": "Nasdaq Victory Intl 100 High Div Vol Wt NTR", "I:NQVWIDT": "Nasdaq Victory Intl 100 High Div Vol Wt TR", "I:NQVWIL": "Nasdaq Victory International 500 Vol Wt Index", "I:NQVWILC": "Nasdaq Victory International 500 Vol Wt L/C", "I:NQVWILCN": "Nasdaq Victory International 500 Vol Wt L/C NTR", "I:NQVWILCT": "Nasdaq Victory International 500 Vol Wt L/C TR", "I:NQVWILN": "Nasdaq Victory International 500 Vol Wt NTR Index", "I:NQVWILT": "Nasdaq Victory International 500 Vol Wt TR", "I:NQVWJDJ": "Nasdaq Victory JP 100 Hi Div Vol Wt JPY Index", "I:NQVWJDJN": "Nasdaq Victory JP 100 Hi Div Vol Wt JPY NTR Index", "I:NQVWJDJT": "Nasdaq Victory JP 100 Hi Div Vol Wt JPY TR Index", "I:NQVWLC": "Nasdaq Victory US 500 Large Vol Wt Index", "I:NQVWLCC": "Nasdaq Victory US 500 Large Vol Wt L/C", "I:NQVWLCCN": "Nasdaq Victory US 500 Large Vol Wt L/C NTR", "I:NQVWLCCT": "Nasdaq Victory US 500 Large Vol Wt L/C TR", "I:NQVWLCN": "Nasdaq Victory US 500 Large Vol Wt NTR Index", "I:NQVWLCT": "Nasdaq Victory US 500 Large Vol Wt TR Index", "I:NQVWLD": "Nasdaq Victory US 100 Large High Div Vol Wt", "I:NQVWLDC": "Nasdaq Victory US 100 Large High Div Vol Wt L/C", "I:NQVWLDCN": "Nasdaq Victory US 100 Large High Div Vol Wt LC NTR", "I:NQVWLDCT": "Nasdaq Victory US 100 Large High Div Vol Wt L/C TR", "I:NQVWLDN": "Nasdaq Victory US 100 Large High Div Vol Wt NTR", "I:NQVWLDT": "Nasdaq Victory US 100 Large High Div Vol Wt TR", "I:NQVWSC": "Nasdaq Victory US 500 Small Vol Wt", "I:NQVWSCC": "Nasdaq Victory US 500 Small Vol Wt L/C", "I:NQVWSCCN": "Nasdaq Victory US 500 Small Vol Wt L/C NTR", "I:NQVWSCCT": "Nasdaq Victory US 500 Small Vol Wt L/C TR", "I:NQVWSCN": "Nasdaq Victory US 500 Small Vol Wt NTR", "I:NQVWSCT": "Nasdaq Victory US 500 Small Vol Wt TR", "I:NQVWSD": "Nasdaq Victory US 100 Small High Div Vol Wt", "I:NQVWSDN": "Nasdaq Victory US 100 Small High Div Vol Wt NTR", "I:NQVWSDT": "Nasdaq Victory US 100 Small High Div Vol Wt TR", "I:NQX": "NASDAQ-100 Reduced Value Index", "I:NQXAUAGR": "Nasdaq Gbl Ex-Australia Agriculture Companies", "I:NQXAUAGRAUD": "Nasdaq Gbl Ex-Australia Agriculture Companies AUD", "I:NQXAUAGRAUDMH": "NQXAUAGRAUD Monthly Currency Hedged", "I:NQXAUAGRAUDN": "Nasdaq Gbl Ex-Australia Agriculture Comps AUD NTR", "I:NQXAUAGRAUDNMH": "NQXAUAGRAUDN Monthly Currency Hedged", "I:NQXAUAGRAUDT": "Nasdaq Gbl Ex-Australia Agriculture Comps AUD TR", "I:NQXAUAGRAUDTMH": "NQXAUAGRAUDT Monthly Currency Hedged", "I:NQXAUAGRN": "Nasdaq Gbl Ex-Australia Agriculture Companies NTR", "I:NQXAUAGRT": "Nasdaq Gbl Ex-Australia Agriculture Companies TR", "I:NQXAUB": "Nasdaq Global Ex-Australia Banks Index", "I:NQXAUBAUD": "Nasdaq Global Ex-Australia Banks AUD Index", "I:NQXAUBAUDMH": "NQXAUBAUD Monthly Currency Hedged", "I:NQXAUBAUDN": "Nasdaq Global Ex-Australia Banks AUD NTR Index", "I:NQXAUBAUDNMH": "NQXAUBAUDN Monthly Currency Hedged", "I:NQXAUBAUDT": "Nasdaq Global Ex-Australia Banks AUD TR Index", "I:NQXAUBAUDTMH": "NQXAUBAUDT Monthly Currency Hedged", "I:NQXAUBN": "Nasdaq Global Ex-Australia Banks NTR Index", "I:NQXAUBT": "Nasdaq Global Ex-Australia Banks TR Index", "I:NQXAUE": "Nasdaq Global Ex-Australia Energy Companies Index", "I:NQXAUEAUD": "Nasdaq Global Ex-Australia Energy Companies AUD", "I:NQXAUEAUDMH": "NQXAUEAUD Monthly Currency Hedged", "I:NQXAUEAUDN": "Nasdaq Gbl Ex-Australia Energy Companies AUD NTR", "I:NQXAUEAUDNMH": "NQXAUEAUDN Monthly Currency Hedged", "I:NQXAUEAUDT": "Nasdaq Global Ex-Australia Energy Companies AUD TR", "I:NQXAUEAUDTMH": "NQXAUEAUDT Monthly Currency Hedged", "I:NQXAUEN": "Nasdaq Global Ex-Australia Energy Companies NTR", "I:NQXAUET": "Nasdaq Global Ex-Australia Energy Companies TR", "I:NQXAUGLD": "Nasdaq Global Ex-Australia Gold Miners Index", "I:NQXAUGLDAUD": "Nasdaq Global Ex-Australia Gold Miners AUD Index", "I:NQXAUGLDAUDMH": "NQXAUGLDAUD Monthly Currency Hedged", "I:NQXAUGLDAUDN": "Nasdaq Global Ex-Australia Gold Miners AUD NTR", "I:NQXAUGLDAUDNMH": "NQXAUGLDAUDN Monthly Currency Hedged", "I:NQXAUGLDAUDT": "Nasdaq Global Ex-Australia Gold Miners AUD TR", "I:NQXAUGLDAUDTMH": "NQXAUGLDAUDT Monthly Currency Hedged", "I:NQXAUGLDN": "Nasdaq Global Ex-Australia Gold Miners NTR Index", "I:NQXAUGLDT": "Nasdaq Global Ex-Australia Gold Miners TR Index", "I:NQXAUH": "Nasdaq Global Ex-Australia Healthcare Index", "I:NQXAUHAUD": "Nasdaq Global Ex-Australia Healthcare AUD Index", "I:NQXAUHAUDMH": "NQXAUHAUD Monthly Currency Hedged", "I:NQXAUHAUDN": "Nasdaq Global Ex-Australia Healthcare AUD NTR", "I:NQXAUHAUDNMH": "NQXAUHAUDN Monthly Currency Hedged", "I:NQXAUHAUDT": "Nasdaq Global Ex-Australia Healthcare AUD TR Index", "I:NQXAUHAUDTMH": "NQXAUHAUDT Monthly Currency Hedged", "I:NQXAUHN": "Nasdaq Global Ex-Australia Healthcare NTR Index", "I:NQXAUHT": "Nasdaq Global Ex-Australia Healthcare TR Index", "I:NQYLEI": "Nasdaq-100 ESG BuyWrite Index", "I:NQZA": "NASDAQ South Africa Index", "I:NQZA10": "Nasdaq South Africa Technology Index", "I:NQZA10N": "Nasdaq South Africa Technology NTR Index", "I:NQZA10T": "Nasdaq South Africa Technology TR Index", "I:NQZA15": "Nasdaq South Africa Telecommunications Index", "I:NQZA15N": "Nasdaq South Africa Telecommunications NTR Index", "I:NQZA15T": "Nasdaq South Africa Telecommunications TR Index", "I:NQZA20": "NASDAQ South Africa Health Care Index", "I:NQZA20N": "NASDAQ South Africa Health Care NTR Index", "I:NQZA20T": "NASDAQ South Africa Health Care TR Index", "I:NQZA30": "NASDAQ South Africa Financials Index", "I:NQZA30LM": "Nasdaq South Africa Financials Large Mid Cap Index", "I:NQZA30LMN": "Nasdaq South Africa Financials Large Mid Cap NTR Index", "I:NQZA30LMT": "Nasdaq South Africa Financials Large Mid Cap TR Index", "I:NQZA30N": "NASDAQ South Africa Financials NTR Index", "I:NQZA30T": "NASDAQ South Africa Financials TR Index", "I:NQZA35": "Nasdaq South Africa Real Estate Index", "I:NQZA35N": "Nasdaq South Africa Real Estate NTR Index", "I:NQZA35T": "Nasdaq South Africa Real Estate TR Index", "I:NQZA40": "Nasdaq South Africa Consumer Discretionary Index", "I:NQZA40N": "Nasdaq South Africa Consumer Discretionary NTR Index", "I:NQZA40T": "Nasdaq South Africa Consumer Discretionary TR Index", "I:NQZA45": "Nasdaq South Africa Consumer Staples Index", "I:NQZA45LM": "Nasdaq South Africa Consumer Staples Large Mid Cap Index", "I:NQZA45LMN": "Nasdaq South Africa Consumer Staples Large Mid Cap NTR Index", "I:NQZA45LMT": "Nasdaq South Africa Consumer Staples Large Mid Cap TR Index", "I:NQZA45N": "Nasdaq South Africa Consumer Staples NTR Index", "I:NQZA45T": "Nasdaq South Africa Consumer Staples TR Index", "I:NQZA50": "Nasdaq South Africa Industrials Index", "I:NQZA50LM": "Nasdaq South Africa Industrials Large Mid Cap Index", "I:NQZA50LMN": "Nasdaq South Africa Industrials Large Mid Cap NTR Index", "I:NQZA50LMT": "Nasdaq South Africa Industrials Large Mid Cap TR Index", "I:NQZA50N": "Nasdaq South Africa Industrials NTR Index", "I:NQZA50T": "Nasdaq South Africa Industrials TR Index", "I:NQZA55": "Nasdaq South Africa Basic Materials Index", "I:NQZA55LM": "Nasdaq South Africa Basic Materials Large Mid Cap Index", "I:NQZA55LMN": "Nasdaq South Africa Basic Materials Large Mid Cap NTR Index", "I:NQZA55LMT": "Nasdaq South Africa Basic Materials Large Mid Cap TR Index", "I:NQZA55N": "Nasdaq South Africa Basic Materials NTR Index", "I:NQZA55T": "Nasdaq South Africa Basic Materials TR Index", "I:NQZALC": "NASDAQ South Africa Large Cap Index", "I:NQZALCN": "NASDAQ South Africa Large Cap NTR Index", "I:NQZALCT": "NASDAQ South Africa Large Cap TR Index", "I:NQZALM": "NASDAQ South Africa Large Mid Cap Index", "I:NQZALMN": "NASDAQ South Africa Large Mid Cap NTR Index", "I:NQZALMT": "NASDAQ South Africa Large Mid Cap TR Index", "I:NQZAMC": "NASDAQ South Africa Mid Cap Index", "I:NQZAMCN": "NASDAQ South Africa Mid Cap NTR Index", "I:NQZAMCT": "NASDAQ South Africa Mid Cap TR Index", "I:NQZAN": "NASDAQ South Africa NTR Index", "I:NQZASC": "NASDAQ South Africa Small Cap Index", "I:NQZASCN": "NASDAQ South Africa Small Cap NTR Index", "I:NQZASCT": "NASDAQ South Africa Small Cap TR Index", "I:NQZAT": "NASDAQ South Africa TR Index", "I:NSCOPJ": "Nasdaq Sprott Junior Copper Miners Index", "I:NSCOPJN": "Nasdaq Sprott Junior Copper Miners Net Total Return Index", "I:NSCOPJT": "Nasdaq Sprott Junior Copper Miners Total Return Index", "I:NSETM": "Nasdaq Sprott Energy Transition Materials Index", "I:NSETMN": "Nasdaq Sprott Energy Transition Materials Net Total Return Index", "I:NSETMT": "Nasdaq Sprott Energy Transition Materials Total Return Index", "I:NSETMU": "Nasdaq Sprott Energy Transition Materials ex Uranium Index", "I:NSETMUN": "Nasdaq Sprott Energy Transition Materials ex Uranium Net Total Return Index", "I:NSETMUT": "Nasdaq Sprott Energy Transition Materials ex Uranium Total Return Index", "I:NSLITP": "Nasdaq Sprott Lithium Miners Index", "I:NSLITPN": "Nasdaq Sprott Lithium Miners Net Total Return Index", "I:NSLITPT": "Nasdaq Sprott Lithium Miners Total Return Index", "I:NSNIKL": "Nasdaq Sprott Nickel Miners Index", "I:NSNIKLN": "Nasdaq Sprott Nickel Miners Net Total Return Index", "I:NSNIKLT": "Nasdaq Sprott Nickel Miners Total Return Index", "I:NSURNJ": "Nasdaq Sprott Junior Uranium Miners Index", "I:NSURNJN": "Nasdaq Sprott Junior Uranium Miners Net Total Return Index", "I:NSURNJT": "Nasdaq Sprott Junior Uranium Miners Total Return Index", "I:NTQX": "NASDAQ Q-50 Total Return", "I:NTTR": "NASDAQ-100 Technology Sector Total Return", "I:NVBTIV": "AllianzIM U.S. Large Cap Buffer10 Nov ETF Intraday Indicative Value", "I:NVBWIV": "AllianzIM U.S. Large Cap Buffer20 Nov ETF Intraday Indicative Value", "I:NXTQ": "NASDAQ Q-50", "I:NXTQNNR": "Nasdaq Q-50 Notional Net Return", "I:NXTR": "NASDAQ-100 Ex-Tech Total Return", "I:NYDTB": "Nasdaq Yewno Global Disruptive Tech Bench", "I:NYDTBCNY": "Nasdaq Yewno Global Disruptive Tech Bench CNY", "I:NYDTBEUR": "Nasdaq Yewno Global Disruptive Tech Bench EUR", "I:NYDTBGBP": "Nasdaq Yewno Global Disruptive Tech Bench GBP", "I:NYDTBHKD": "Nasdaq Yewno Global Disruptive Tech Bench HKD", "I:NYDTBJPY": "Nasdaq Yewno Global Disruptive Tech Bench JPY", "I:NYDTBN": "Nasdaq Yewno Global Disruptive Tech Bench NTR", "I:NYDTBNCNY": "Nasdaq Yewno Global Disruptive Tech Bench CNY NTR", "I:NYDTBNEUR": "Nasdaq Yewno Global Disruptive Tech Bench EUR NTR", "I:NYDTBNGBP": "Nasdaq Yewno Global Disruptive Tech Bench GBP NTR", "I:NYDTBNHKD": "Nasdaq Yewno Global Disruptive Tech Bench HKD NTR", "I:NYDTBNJPY": "Nasdaq Yewno Global Disruptive Tech Bench JPY NTR", "I:NYDTBT": "Nasdaq Yewno Global Disruptive Tech Bench TR", "I:NYDTBTCNY": "Nasdaq Yewno Global Disruptive Tech Bench CNY TR", "I:NYDTBTEUR": "Nasdaq Yewno Global Disruptive Tech Bench EUR TR", "I:NYDTBTGBP": "Nasdaq Yewno Global Disruptive Tech Bench GBP TR", "I:NYDTBTHKD": "Nasdaq Yewno Global Disruptive Tech Bench HKD TR", "I:NYDTBTJPY": "Nasdaq Yewno Global Disruptive Tech Bench JPY TR", "I:NYGBIG": "Nasdaq Yewno Global AI and Big Data Index", "I:NYGBIGEUR": "Nasdaq Yewno Global AI and Big Data Index EUR", "I:NYGBIGEURN": "Nasdaq Yewno Global AI and Big Data Index EUR NTR", "I:NYGBIGEURT": "Nasdaq Yewno Global AI and Big Data Index EUR TR", "I:NYGBIGN": "Nasdaq Yewno Global AI and Big Data Index NTR", "I:NYGBIGT": "Nasdaq Yewno Global AI and Big Data Index TR", "I:NYGCAR": "Nasdaq Yewno Global Future Mobility Index", "I:NYGCAREUR": "Nasdaq Yewno Global Future Mobility Index EUR", "I:NYGCAREURN": "Nasdaq Yewno Global Future Mobility Index EUR NTR", "I:NYGCAREURT": "Nasdaq Yewno Global Future Mobility Index EUR TR", "I:NYGCARN": "Nasdaq Yewno Global Future Mobility Index NTR", "I:NYGCART": "Nasdaq Yewno Global Future Mobility Index TR", "I:NYGIT": "Nasdaq Yewno Global Innovative Tech Index", "I:NYGITE": "Nasdaq Yewno Global Innovative Tech USD NTR 3% Decrement Index", "I:NYGITEEUR": "Nasdaq Yewno Global Innovative Tech EUR NTR 3% Decrement Index", "I:NYGITEN5": "Nasdaq Yewno Global Innovative Tech EUR NTR 5% Decrement Index", "I:NYGITEUR": "Nasdaq Yewno Global Innovative Tech Index EUR", "I:NYGITN": "Nasdaq Yewno Global Innovative Tech index NTR", "I:NYGITNEUR": "Nasdaq Yewno Global Innovative Tech Index EUR NTR", "I:NYGITT": "Nasdaq Yewno Global Innovative Tech Index TR", "I:NYGITTEUR": "Nasdaq Yewno Global Innovative Tech Index EUR TR", "I:NYGITXDE": "Nasdaq Yewno Global Innovative Tech Ex Disputable Activities USD NTR 3% Decrement Index", "I:NYGITXDE5": "Nasdaq Yewno Global Innovative Tech Ex Disputable Activities USD NTR 5% Decrement Index", "I:NYGITXDN": "Nasdaq Yewno Glbll Innovative Tech Ex Index NTR", "I:NYGITXDP": "Nasdaq Yewno Glbl Innovative Tech Ex Index", "I:NYGITXDT": "Nasdaq Yewno Glbl Innovative Tech Ex Index TR", "I:NYGITXEE": "Nasdaq Yewno Global Innovative Tech Ex Disputable Activities EUR NTR 3% Decrement Index", "I:NYGITXEE5": "Nasdaq Yewno Global Innovative Tech Ex Disputable Activities EUR NTR 5% Decrement index", "I:NYGITXEN": "Nasdaq Yewno Glbl Innovative Tech Ex Index EUR NTR", "I:NYGITXEP": "Nasdaq Yewno Glbl Innovative Tech Ex Index EUR", "I:NYGITXET": "Nasdaq Yewno Glbl Innovative Tech Ex Index EUR TR", "I:NYMETA": "Nasdaq Yewno Metaverse Index", "I:NYMETAN": "Nasdaq Yewno Metaverse Net Total Return Index", "I:NYMETAT": "Nasdaq Yewno Metaverse Total Return Index", "I:NZDOW": "Dow Jones New Zealand Index", "I:NZDOWD": "Dow Jones New Zealand Index (USD)", "I:OCTTIV": "AllianzIM U.S. Large Cap Buffer10 Oct ETF Intraday Indicative Value", "I:OCTWIV": "AllianzIM U.S. Large Cap Buffer20 Oct ETF Intraday Indicative Value", "I:OCTZIV": "TrueShares Structured Outcome (October) ETF Intraday Indicative Value", "I:OET": "S&P 100 Flex Settlement Index", "I:OEX": "S&P 100", "I:OFIN": "Nasdaq Real Estate and Other Financial Services", "I:OILKIV": "PROSHARES K-1 FREE CRUDE OIL STRATEGY ETF", "I:OMG100RP": "Cboe 100 OMG / US Dollar RealPrice Index", "I:OMG1KRP": "Cboe 1000 OMG / US Dollar RealPrice Index", "I:OMG25RP": "Cboe 25 OMG / US Dollar RealPrice Index", "I:OMG2KRP": "Cboe 2000 OMG / US Dollar RealPrice Index", "I:OMG500RP": "Cboe 500 OMG / US Dollar RealPrice Index", "I:OMRXALL": "OMRX All Index", "I:OMRXALLXMUNI": "OMRX All ex Muni Index", "I:OMRXBOND": "OMRX Total Bond Index", "I:OMRXBOND13": "OMRX Bond All 1-3 y Index", "I:OMRXBOND130": "OMRXBOND 1 - 30 Years Index", "I:OMRXBOND35": "OMRX Bond All 3-5 y Index", "I:OMRXBOND5": "OMRX Bond All 5- y Index", "I:OMRXBONDALL": "OMRX Bond All Index", "I:OMRXBONDALLXMUN": "OMRX Bond All ex Muni Index", "I:OMRXBONDXMUNI13": "OMRX Bond All ex Muni 1-3 y Index", "I:OMRXBONDXMUNI35": "OMRX Bond All ex Muni 3-5 y Index", "I:OMRXBONDXMUNI5": "OMRX Bond All ex Muni 5- y Index", "I:OMRXGOVT": "OMRX Government Debt Index", "I:OMRXMM": "OMRX Money Market Index", "I:OMRXMORT": "OMRX Mortgage Bond Index", "I:OMRXMORT13": "OMRX Mortgage Bond 1-3 y Index", "I:OMRXMORT35": "OMRX Mortgage Bond 3-5 y Index", "I:OMRXMORT5": "OMRX Mortgage Bond 5- y Index", "I:OMRXMORTALL": "OMRX Mortgage Bond All Index", "I:OMRXMUNI": "OMRX Municipal Bond Index", "I:OMRXON": "OMRX Deposition Overnight Index", "I:OMRXREAL": "OMRX Real Return Bond Index", "I:OMRXTBILL": "OMRX Treasury Bill Index", "I:OMRXTBILL180": "OMRX Treasury Bill 180 day Index", "I:OMRXTBILL30": "OMRX Treasury Bill 30 day Index", "I:OMRXTBILL60": "OMRX Treasury Bill 60 day Index", "I:OMRXTBILL90": "OMRX Treasury Bill 90 day Index", "I:OMRXTBOND": "OMRX Treasury Bond Index", "I:OMRXTBOND13": "OMRX Treasury Bond 1-3 y Index", "I:OMRXTBOND130": "OMRXTBOND 1 - 30 Years Index", "I:OMRXTBOND35": "OMRX Treasury Bond 3-5 y Index", "I:OMRXTBOND5": "OMRX Treasury Bond 5- y Index", "I:OMRXTOT": "OMRX Total Market Index", "I:OMXAFGX": "OMX Affarsvarldens Generalindex", "I:OMXB10": "OMX_Baltic_10", "I:OMXB10GI": "OMX_Baltic_10_GI", "I:OMXBBCAPGI": "OMX_Baltic_Benchmark_Cap_GI", "I:OMXBBCAPPI": "OMX_Baltic_Benchmark_Cap_PI", "I:OMXBBGI": "OMX_Baltic_Benchmark_GI", "I:OMXBBPI": "OMX_Baltic_Benchmark_PI", "I:OMXBGI": "OMX_Baltic_GI", "I:OMXBPI": "OMX_Baltic_PI", "I:OMXC20": "OMX Copenhagen 20", "I:OMXC20GI": "OMX Copenhagen 20 GI", "I:OMXC25": "OMX Copenhagen 25 Index", "I:OMXC25DVP": "OMX Copenhagen 25 Dividend Point Index", "I:OMXC25ESG": "OMX Copenhagen 25 ESG Responsible Index", "I:OMXC25ESGGI": "OMX Copenhagen 25 ESG Responsible Gross Index", "I:OMXC25ESGNI": "OMX Copenhagen 25 ESG Responsible Net Index", "I:OMXC25EXP": "OMX Copenhagen 25 Expiration Index", "I:OMXC25GI": "OMX Copenhagen 25 GI Index", "I:OMXC25NI": "OMX Copenhagen 25 NI Index", "I:OMXCBCAPGI": "OMX Copenhagen Benchmark Cap_GI", "I:OMXCBCAPPI": "OMX Copenhagen Benchmark Cap_PI", "I:OMXCBGI": "OMX Copenhagen Benchmark_GI", "I:OMXCBPI": "OMX Copenhagen Benchmark_PI", "I:OMXCCAPGI": "OMX Copenhagen Cap_GI", "I:OMXCCAPNI": "OMX Copenhagen Cap_NI", "I:OMXCCAPPI": "OMX Copenhagen Cap_PI", "I:OMXCCAPXTRYGGI": "OMX Copenhagen Cap Index Ex Tryg_GI", "I:OMXCCAPXTRYGNI": "OMX Copenhagen Cap Index Ex Tryg_NI", "I:OMXCCAPXTRYGPI": "OMX Copenhagen Cap Index Ex Tryg_PI", "I:OMXCGI": "OMX Copenhagen_GI", "I:OMXCLCGI": "OMX_Copenhagen_Large_Cap_GI", "I:OMXCLCPI": "OMX_Copenhagen_Large_Cap_PI", "I:OMXCMCGI": "OMX_Copenhagen_Mid_Cap_GI", "I:OMXCMCPI": "OMX_Copenhagen_Mid_Cap_PI", "I:OMXCNI": "OMX Copenhagen_NI", "I:OMXCPI": "OMX Copenhagen_PI", "I:OMXCSCGI": "OMX_Copenhagen_Small_Cap_GI", "I:OMXCSCPI": "OMX_Copenhagen_Small_Cap_PI", "I:OMXCXC20GI": "OMX Copenhagen Ex OMXC20 Index GI", "I:OMXCXC20PI": "OMX Copenhagen Ex OMXC20 Index PI", "I:OMXH15": "OMX Helsinki 15", "I:OMXH15GI": "OMX Helsinki 15 Gross Index", "I:OMXH15NI": "OMX Helsinki 15 Net Index", "I:OMXH25": "OMX Helsinki 25", "I:OMXH25DVP": "OMX Helsinki 25 Dividend Point Index", "I:OMXH25ER": "OMX Helsinki 25 GI 3.5% Excess Return Index", "I:OMXH25ESG": "OMX Helsinki 25 ESG Responsible Index", "I:OMXH25ESGGI": "OMX Helsinki 25 ESG Responsible Gross Index", "I:OMXH25ESGNI": "OMX Helsinki 25 ESG Responsible Net Index", "I:OMXH25EXP": "OMX Helsinki 25 Expiration", "I:OMXH25GI": "OMX Helsinki 25 GI", "I:OMXHBCAPGI": "OMX Helsinki Benchmark CAP_GI", "I:OMXHBCAPPI": "OMX Helsinki Benchmark CAP_PI", "I:OMXHBGI": "OMX Helsinki Benchmark_GI", "I:OMXHBPI": "OMX Helsinki Benchmark_PI", "I:OMXHCAPGI": "OMX Helsinki Cap_GI", "I:OMXHCAPPI": "OMX Helsinki Cap_PI", "I:OMXHGI": "OMX Helsinki_GI", "I:OMXHLCGI": "OMX_Helsinki_Large_Cap_GI", "I:OMXHLCPI": "OMX_Helsinki_Large_Cap_PI", "I:OMXHMCGI": "OMX_Helsinki_Mid_Cap_GI", "I:OMXHMCPI": "OMX_Helsinki_Mid_Cap_PI", "I:OMXHPI": "OMX Helsinki_PI", "I:OMXHSCGI": "OMX_Helsinki_Small_Cap_GI", "I:OMXHSCPI": "OMX_Helsinki_Small_Cap_PI", "I:OMXI10": "OMX Iceland 10", "I:OMXI10CAP": "OMX Iceland 10 Cap", "I:OMXI10CAPEUR": "OMX Iceland 10 Cap EUR", "I:OMXI10CAPGI": "OMX Iceland 10 Cap GI", "I:OMXI10EUR": "OMX Iceland 10 EUR", "I:OMXI10EURGI": "OMX Iceland 10 EUR GI", "I:OMXI10GI": "OMX Iceland 10 GI", "I:OMXIGI": "OMX Iceland All-Share GI", "I:OMXIMCGI": "OMX Iceland Mid Cap GI", "I:OMXIMCPI": "OMX Iceland Mid Cap PI", "I:OMXIPI": "OMX Iceland All-Share PI", "I:OMXISCGI": "OMX Iceland Small Cap GI", "I:OMXISCPI": "OMX Iceland Small Cap PI", "I:OMXN40": "OMX Nordic 40", "I:OMXNLCDKKGI": "OMX_Nordic_Large_Cap_DKK_GI", "I:OMXNLCDKKPI": "OMX_Nordic_Large_Cap_DKK_PI", "I:OMXNLCEURGI": "OMX_Nordic_Large_Cap_EUR_GI", "I:OMXNLCEURPI": "OMX_Nordic_Large_Cap_EUR_PI", "I:OMXNLCISKGI": "OMX_Nordic_Large_Cap_ISK_GI", "I:OMXNLCISKPI": "OMX_Nordic_Large_Cap_ISK_PI", "I:OMXNLCSEKGI": "OMX_Nordic_Large_Cap_SEK_GI", "I:OMXNLCSEKPI": "OMX_Nordic_Large_Cap_SEK_PI", "I:OMXNMCDKKGI": "OMX_Nordic_Mid_Cap_DKK_GI", "I:OMXNMCDKKPI": "OMX_Nordic_Mid_Cap_DKK_PI", "I:OMXNMCEURGI": "OMX_Nordic_Mid_Cap_EUR_GI", "I:OMXNMCEURPI": "OMX_Nordic_Mid_Cap_EUR_PI", "I:OMXNMCISKGI": "OMX_Nordic_Mid_Cap_ISK_GI", "I:OMXNMCISKPI": "OMX_Nordic_Mid_Cap_ISK_PI", "I:OMXNMCSEKGI": "OMX_Nordic_Mid_Cap_SEK_GI", "I:OMXNMCSEKPI": "OMX_Nordic_Mid_Cap_SEK_PI"}




indices_list2= {"I:OMXNORDICDKKGI": "OMX_Nordic_DKK_GI", "I:OMXNORDICDKKPI": "OMX_Nordic_DKK_PI", "I:OMXNORDICEURGI": "OMX_Nordic_EUR_GI", "I:OMXNORDICEURPI": "OMX_Nordic_EUR_PI", "I:OMXNORDICISKGI": "OMX_Nordic_ISK_GI", "I:OMXNORDICISKPI": "OMX_Nordic_ISK_PI", "I:OMXNORDICSEKGI": "OMX_Nordic_SEK_GI", "I:OMXNORDICSEKPI": "OMX_Nordic_SEK_PI", "I:OMXNSCDKKGI": "OMX_Nordic_Small_Cap_DKK_GI", "I:OMXNSCDKKPI": "OMX_Nordic_Small_Cap_DKK_PI", "I:OMXNSCEURGI": "OMX_Nordic_Small_Cap_EUR_GI", "I:OMXNSCEURPI": "OMX_Nordic_Small_Cap_EUR_PI", "I:OMXNSCISKGI": "OMX_Nordic_Small_Cap_ISK_GI", "I:OMXNSCISKPI": "OMX_Nordic_Small_Cap_ISK_PI", "I:OMXNSCSEKGI": "OMX_Nordic_Small_Cap_SEK_GI", "I:OMXNSCSEKPI": "OMX_Nordic_Small_Cap_SEK_PI", "I:OMXO20GI": "OMX Oslo 20 GI", "I:OMXO20GIEXP": "OMX Oslo 20 GI Expiration Index", "I:OMXO20PI": "OMX Oslo 20 PI", "I:OMXRGI": "OMX Riga_GI", "I:OMXS30": "OMX Stockholm 30 Index", "I:OMXS30ASK": "OMX Stockholm 30 Ask", "I:OMXS30BID": "OMX Stockholm 30 Bid", "I:OMXS30CAPGI": "OMX Stockholm 30 Cap_GI", "I:OMXS30DVP": "OMX Stockholm 30 Dividend Point Index", "I:OMXS30ER": "OMX Stockholm 30 GI 3.5% Excess Return Index", "I:OMXS30ESG": "OMX Stockholm 30 ESG Responsible Index", "I:OMXS30ESGEXP": "OMX Stockholm 30 ESG Responsible Expiration Index", "I:OMXS30ESGGI": "OMX Stockholm 30 ESG Responsible Gross Index", "I:OMXS30ESGNI": "OMX Stockholm 30 ESG Responsible Net Index", "I:OMXS30ETHICGI": "OMX GES OMXS30 Ethical Gross Index", "I:OMXS30ETHICPI": "OMX GES OMXS30 Ethical Price Index", "I:OMXS30EXP": "OMX Stockholm 30 Expiration Index", "I:OMXS30GI": "OMX Stockholm 30_GI", "I:OMXS30NEXT": "OMX Stockholm 30 Next_PI", "I:OMXS30NEXTGI": "OMX Stockholm 30 Next_GI", "I:OMXS30NI": "OMX Stockholm 30_NI", "I:OMXS30WEEKEXP": "OMX Stockholm 30 Weekly Expiration Index", "I:OMXS40": "OMX Stockholm 40 Equal Weighted Index", "I:OMXS40ER": "OMX Stockholm 40 Equal Weighted Excess Return Inde", "I:OMXS40NR": "OMX Stockholm 40 Equal Weighted NTR Index", "I:OMXS40TR": "OMX Stockholm 40 Equal Weighted TR Index", "I:OMXS50EW": "OMX Stockholm 50 Equal Weighted", "I:OMXS60": "OMX Stockholm 60_GI", "I:OMXS60CAPGI": "OMX Stockholm 60 Cap_GI", "I:OMXS60CAPPI": "OMX Stockholm 60 Cap_PI", "I:OMXS60PI": "OMX Stockholm 60_PI", "I:OMXSBCAPGI": "OMX Stockholm Benchmark Cap_GI", "I:OMXSBCAPNI": "OMX Stockholm Benchmark Cap_NI", "I:OMXSBCAPPI": "OMX Stockholm Benchmark Cap_PI", "I:OMXSBESGCAPGI": "OMX Stockholm Benchmark ESG Responsible Capped Gross Index", "I:OMXSBESGCAPNI": "OMX Stockholm Benchmark ESG Responsible Capped Net Index", "I:OMXSBESGCAPPI": "OMX Stockholm Benchmark ESG Responsible Capped Index", "I:OMXSBESGGI": "OMX Stockholm Benchmark ESG Responsible Gross Index", "I:OMXSBESGNI": "OMX Stockholm Benchmark ESG Responsible Net Index", "I:OMXSBESGPI": "OMX Stockholm Benchmark ESG Responsible Index", "I:OMXSBGI": "OMX Stockholm Benchmark_GI", "I:OMXSBGIEXP": "OMX Stockholm Benchmark_GI Exp", "I:OMXSBNI": "OMX Stockholm Benchmark_NI", "I:OMXSBPI": "OMX Stockholm Benchmark_PI", "I:OMXSCAPGI": "OMX Stockholm All-Share Cap_GI", "I:OMXSCAPPI": "OMX Stockholm All-Share Cap_PI", "I:OMXSGI": "OMX Stockholm_GI", "I:OMXSLCGI": "OMX_Stockholm_Large_Cap_GI", "I:OMXSLCPI": "OMX_Stockholm_Large_Cap_PI", "I:OMXSMCGI": "OMX_Stockholm_Mid_Cap_GI", "I:OMXSMCPI": "OMX_Stockholm_Mid_Cap_PI", "I:OMXSPI": "OMX Stockholm_PI", "I:OMXSSCGI": "OMX_Stockholm_Small_Cap_GI", "I:OMXSSCPI": "OMX_Stockholm_Small_Cap_PI", "I:OMXSUSTAINFIGI": "OMX Sustainability Finland GI", "I:OMXSUSTAINFIPI": "OMX Sustainability Finland PI", "I:OMXSUSTFICAPGI": "OMX Sustainability Finland CAP GI", "I:OMXSUSTFICAPPI": "OMX Sustainability Finland CAP PI", "I:OMXTGI": "OMX Tallinn_GI", "I:OMXVGI": "OMX Vilnius_GI", "I:ONDIV": "PROSHARES ON-DEMAND ETF", "I:OSX": "PHLX Oil Service Sector", "I:OVX": "Cboe Crude Oil ETF Volatility Index", "I:OXT1KRP": "Cboe 1000 Orchid / US Dollar RealPrice Index", "I:OXT25KRP": "Cboe 25K Orchid / US Dollar RealPrice Index", "I:OXT5KRP": "Cboe 5000 Orchid / US Dollar RealPrice Index", "I:PCJ": "Citigroup BXM Pistons Net Investment Value", "I:PDEA": "Cboe MSCI EAFE 20-Delta PutWrite Index", "I:PDEF": "Cboe MSCI Emerging Markets 20-Delta PutWrite Index", "I:PEXIV": "PROSHARES GLOBAL LISTED PRIVATE EQUITY ETF", "I:PHDOW": "Dow Jones Philippines Index", "I:PHDOWD": "Dow Jones Philippines Index (USD)", "I:PLAYER": "Nasdaq CTA Global Video Games and ESports Index", "I:PLAYERAU": "Nasdaq CTA Global Video Games and ESports AUD Index", "I:PLAYERAUNR": "Nasdaq CTA Global Video Games and ESports Net Total Return AUD Index", "I:PLAYERAUTR": "Nasdaq CTA Global Video Games and ESports Gross Total Return AUD Index", "I:PLAYERNR": "Nasdaq CTA Global Video Games and ESports Net Total Return Index", "I:PLAYERTR": "Nasdaq CTA Global Video Games and ESports Gross Total Return Index", "I:PLAYR2": "Nasdaq CTA Global Video Games Software Index", "I:PLAYR2A": "Nasdaq CTA Global Video Games Software AUD Index", "I:PLAYR2AN": "Nasdaq CTA Global Video Games Software Net Total Return AUD Index", "I:PLAYR2AT": "Nasdaq CTA Global Video Games Software Gross Total Return AUD Index", "I:PLAYR2N": "Nasdaq CTA Global Video Games Software Net Total Return Index", "I:PLAYR2T": "Nasdaq CTA Global Video Games Software Gross Total Return Index", "I:PPUT": "Cboe S&P 500 5% Put Protection Index", "I:PPUT3M": "Cboe S&P 500 Tail Risk Index", "I:PPUTEA": "Cboe MSCI EAFE 5% Put Protection Index", "I:PPUTEF": "Cboe MSCI Emerging Markets 5% Put Protection Index", "I:PSCJIV": "Pacer Swan SOS Conservative (July) ETF Intraday Indicative Value", "I:PSCQIV": "Pacer Swan SOS Conservative (October) ETF Intraday Indicative Value", "I:PSCWIV": "Pacer Swan SOS Conservative (April) ETF Intraday Indicative Value", "I:PSCXIV": "Pacer Swan SOS Conservative (December) ETF Intraday Indicative Value", "I:PSFDIV": "Pacer Swan SOS Flex (December) ETF  Intraday Indicative Value", "I:PSFJIV": "Pacer Swan SOS Flex (July) ETF Intraday Indicative Value", "I:PSFMIV": "Pacer Swan SOS Flex (April) ETF Intraday Indicative Value", "I:PSFOIV": "Pacer Swan SOS Flex (October) ETF Intraday Indicative Value", "I:PSMDIV": "Pacer Swan SOS Moderate (December) ETF Intraday Indicative Value", "I:PSMJIV": "Pacer Swan SOS Moderate (July) ETF Intraday Indicative Value", "I:PSMOIV": "Pacer Swan SOS Moderate (October) ETF Intraday Indicative Value", "I:PSMRIV": "Pacer Swan SOS Moderate (April) ETF Intraday Indicative Value", "I:PSQIV": "PROSHARES SHORT QQQ ETF", "I:PSTIV": "PROSHARES ULTRASHORT 7-10 YEAR TREASURY ETF", "I:PTDOW": "Dow Jones Portugal Index", "I:PTDOWD": "Dow Jones Portugal Index (USD)", "I:PTLT": "Cboe 20+ Year Treasury Bond PutWrite Index", "I:PUT": "Cboe S&P 500 PutWrite Index", "I:PUTD": "Cboe Validus S&P500 Dynamic PutWrite Index", "I:PUTR": "Cboe Russell 2000 Putwrite Index", "I:PUTVM": "Cboe S&P 500 Volatility Managed PutWrite Index", "I:PUTY": "Cboe S&P 500 2% OTM PutWrite Index", "I:PWT": "Cboe S&P 500 PutWrite TW Index", "I:PXEA": "Cboe MSCI EAFE PutWrite Index", "I:PXEF": "Cboe MSCI Emerging Markets PutWrite Index", "I:PYEA": "Cboe MSCI EAFE 2% OTM PutWrite Index", "I:PYEF": "Cboe MSCI Emerging Markets 2% OTM PutWrite Index", "I:QAUTO": "NASDAQ OMX Global Automobile", "I:QAUTOX": "NASDAQ OMX Global Automobile Total Return", "I:QFNX": "Nasdaq CTA Smartphone Total Return Index", "I:QFON": "Nasdaq CTA Smartphone Index", "I:QGDN": "NASDAQ OMX Clean Edge Smart Grid Infrastructure Net Total Return Index", "I:QGDX": "NASDAQ OMX Clean Edge Smart Grid Infrastructure TR", "I:QGLDI": "Credit Suisse NASDAQ Gold FLOWS103 Price Index", "I:QGLDID": "Credit Suisse NASDAQ Gold FLOWS 103 Distribution I", "I:QGLDITR": "Credit Suisse NASDAQ Gold FLOWS103 Total Return In", "I:QGRD": "NASDAQ OMX Clean Edge Smart Grid Infrastructure", "I:QGREEN": "NASDAQ OMX Green Economy", "I:QGREENX": "NASDAQ OMX Green Economy Total Return", "I:QIDIV": "PROSHARES ULTRASHORT QQQ ETF", "I:QIV": "NASDAQ-100 After Hours Indicator", "I:QLDIV": "PROSHARES ULTRA QQQ ETF", "I:QMI": "NASDAQ-100 Pre Market Indicator", "I:QNET": "Nasdaq CTA Internet Index", "I:QNETEM": "Nasdaq CTA Emerging Markets Internet & E-commerce Index", "I:QNETEMAUD": "Nasdaq CTA Emerging Markets Internet & E-commerce Index AUD", "I:QNETEMCAD": "Nasdaq CTA Emerging Markets Internet & E-commerce Index CAD", "I:QNETEMCHF": "Nasdaq CTA Emerging Markets Internet & E-commerce Index CHF", "I:QNETEMEUR": "Nasdaq CTA Emerging Markets Internet & E-commerce Index EUR", "I:QNETEMGBP": "Nasdaq CTA Emerging Markets Internet & E-commerce Index GBP", "I:QNETEMHKD": "Nasdaq CTA Emerging Markets Internet & E-commerce Index HKD", "I:QNETEMJPY": "Nasdaq CTA Emerging Markets Internet & E-commerce Index JPY", "I:QNETEMNR": "Nasdaq CTA Emerging Markets Internet & E-commerce Net Total Return Index", "I:QNETEMNRAUD": "Nasdaq CTA Emerging Markets Internet & E-commerce Net Total Return Index AUD", "I:QNETEMNRCAD": "Nasdaq CTA Emerging Markets Internet & E-commerce Net Total Return Index CAD", "I:QNETEMNRCHF": "Nasdaq CTA Emerging Markets Internet & E-commerce Net Total Return Index CHF", "I:QNETEMNREUR": "Nasdaq CTA Emerging Markets Internet & E-commerce Net Total Return Index EUR", "I:QNETEMNRGBP": "Nasdaq CTA Emerging Markets Internet & E-commerce Net Total Return Index GBP", "I:QNETEMNRHKD": "Nasdaq CTA Emerging Markets Internet & E-commerce Net Total Return Index HKD", "I:QNETEMNRJPY": "Nasdaq CTA Emerging Markets Internet & E-commerce Net Total Return Index JPY", "I:QNETEMTR": "Nasdaq CTA Emerging Markets Internet & E-commerce Total Return Index", "I:QNETEMTRAUD": "Nasdaq CTA Emerging Markets Internet & E-commerce Total Return Index AUD", "I:QNETEMTRCAD": "Nasdaq CTA Emerging Markets Internet & E-commerce Total Return Index CAD", "I:QNETEMTRCHF": "Nasdaq CTA Emerging Markets Internet & E-commerce Total Return Index CHF", "I:QNETEMTREUR": "Nasdaq CTA Emerging Markets Internet & E-commerce Total Return Index EUR", "I:QNETEMTRGBP": "Nasdaq CTA Emerging Markets Internet & E-commerce Total Return Index GBP", "I:QNETEMTRHKD": "Nasdaq CTA Emerging Markets Internet & E-commerce Total Return Index HKD", "I:QNETEMTRJPY": "Nasdaq CTA Emerging Markets Internet & E-commerce Total Return Index JPY", "I:QQQAIV": "PROSHARES NAS-100 DORSEY WRIGHT MOMENTUM", "I:QSLVO": "Credit Suisse NASDAQ Silver FLOWS106 Price Index", "I:QSLVOD": "Credit Suisse NASDAQ Silver FLOWS 106 Distribution", "I:QSLVOTR": "Credit Suisse NASDAQ Silv FLOWS106 TR Index", "I:QSWNXT": "The S-Network BlackSwan Tech & Treasury Index", "I:QTUM100": "Cboe 100 QTUM / US Dollar RealPrice Index", "I:QTUM1KRP": "Cboe 1000 QTUM / US Dollar RealPrice Index", "I:QTUM25RP": "Cboe 25 QTUM / US Dollar RealPrice Index", "I:QTUM2KRP": "Cboe 2000 QTUM / US Dollar RealPrice Index", "I:QTUM500": "Cboe 500 QTUM / US Dollar RealPrice Index", "I:QUSOI": "Credit Suisse NASDAQ WTI Crude Oil FLOWS 106 PR", "I:QUSOID": "Credit Suisse NASDAQ WTI Crude Oil FLOWS 106 Dist", "I:QUSOITR": "Credit Suisse NASDAQ WTI Crude Oil FLOWS 106 TR", "I:QYLGIV": "Global X Nasdaq 100 Covered Call & Growth ETF Intraday Indicative Value", "I:RCH": "Horizon Kinetics ISE Wealth Index", "I:RCHNTR": "Horizon Kinetics ISE Wealth Net Total Return Index", "I:RCHTR": "Horizon Kinetics ISE Wealth Total Return Index", "I:RCI": "Dow Jones Composite All REIT Index", "I:RCIT": "Dow Jones Composite All REIT Total Return Index", "I:RCMP": "NASDAQ Capital Market Composite", "I:REGLIV": "PROSHARES S&P MCAP 400 DIVIDEND ARISTOCRATS", "I:REI": "Dow Jones Equity All REIT Index", "I:REIT": "Dow Jones Equity All REIT Total Return Index", "I:REKIV": "PROSHARES SHORT REAL ESTATE ETF", "I:REP15RP": "Cboe 15 Augur / US Dollar RealPrice Index", "I:REP250RP": "Cboe 250 Augur / US Dollar RealPrice Index", "I:REP75RP": "Cboe 75 Augur / US Dollar RealPrice Index", "I:REWIV": "PROSHARES ULTRASHORT TECHNOLOGY ETF", "I:RINFIV": "ProShares Inflation Expectations ETF", "I:RIR": "Russell 1000 Index Settlement Value", "I:RLR": "Russell 1000 Growth Index Option Settlement", "I:RLS": "Russell 2000 Index Settlement Value", "I:ROMIV": "PROSHARES ULTRA TECHNOLOGY ETF", "I:RON": "UBS Return Optimization", "I:RPEN": "Cboe Russell 2000 Enhanced Growth Balanced Series", "I:RPEN01": "Cboe Russell 2000 Enhanced Growth Index January Series", "I:RPEN02": "Cboe Russell 2000 Enhanced Growth Index February Series", "I:RPEN03": "Cboe Russell 2000 Enhanced Growth Index March Series", "I:RPEN04": "Cboe Russell 2000 Enhanced Growth Index April Series", "I:RPEN05": "Cboe Russell 2000 Enhanced Growth Index May Series", "I:RPEN06": "Cboe Russell 2000 Enhanced Growth Index June Series", "I:RPEN07": "Cboe Russell 2000 Enhanced Growth Index July Series", "I:RPEN08": "Cboe Russell 2000 Enhanced Growth Index August Series", "I:RPEN09": "Cboe Russell 2000 Enhanced Growth Index September Series", "I:RPEN10": "Cboe Russell 2000 Enhanced Growth Index October Series", "I:RPEN11": "Cboe Russell 2000 Enhanced Growth Index November Series", "I:RPEN12": "Cboe Russell 2000 Enhanced Growth Index December Series", "I:RPRO": "Cboe Russell 2000 Buffer Protect Index Balanced Series", "I:RPRO01": "Cboe Russell 2000 Buffer Protect Index January Series", "I:RPRO02": "Cboe Russell 2000 Buffer Protect Index February Series", "I:RPRO03": "Cboe Russell 2000 Buffer Protect Index March Series", "I:RPRO04": "Cboe Russell 2000 Buffer Protect Index April Series", "I:RPRO05": "Cboe Russell 2000 Buffer Protect Index May Series", "I:RPRO06": "Cboe Russell 2000 Buffer Protect Index June Series", "I:RPRO07": "Cboe Russell 2000 Buffer Protect Index July Series", "I:RPRO08": "Cboe Russell 2000 Buffer Protect Index August Series", "I:RPRO09": "Cboe Russell 2000 Buffer Protect Index September Series", "I:RPRO10": "Cboe Russell 2000 Buffer Protect Index October Series", "I:RPRO11": "Cboe Russell 2000 Buffer Protect Index November Series", "I:RPRO12": "Cboe Russell 2000 Buffer Protect Index December Series", "I:RSBLCN": "Nasdaq Blockchain Economy Index", "I:RSBLCNN": "Nasdaq Blockchain Economy NTR", "I:RSBLCNT": "Nasdaq Blockchain Economy TR Index", "I:RUI": "Russell 1000 Index", "I:RVOL": "Cboe Realized Volatility Index", "I:RVOL12M": "Cboe 12-Month Realized Volatility Index", "I:RVOL3M": "Cboe 3-Month Realized Volatility Index", "I:RVOL6M": "Cboe 6-Month Realized Volatility Index", "I:RVS": "Russell 1000 Value Index Option Settlement", "I:RVX": "Cboe Russell 2000 Volatility Index", "I:RWMIV": "PROSHARES SHORT RUSSELL2000 ETF", "I:RXDIV": "PROSHARES ULTRASHORT HEALTH CARE ETF", "I:RXLIV": "PROSHARES ULTRA HEALTH CARE ETF", "I:RXM": "Cboe S&P 500 Risk Reversal Index", "I:S30ESG5D": "OMX Stockholm 30 ESG NTR 5% Decrement", "I:SAAIV": "PROSHARES ULTRA SMALLCAP600 ETF", "I:SBBIV": "PROSHARES SHORT SMALLCAP600 ETF", "I:SCCIV": "PROSHARES ULTRASHORT CONSUMER SERVICES ETF", "I:SCOIV": "PROSHARES ULTRASHORT BLOOMBERG CRUDE OIL ETF", "I:SDDIV": "PROSHARES ULTRASHORT SMALLCAP600 ETF", "I:SDEX": "Nations SkewDex", "I:SDOWIV": "PROSHARES ULTRAPRO SHORT DOW30 ETF", "I:SDPIV": "PROSHARES ULTRASHORT UTILITIES ETF", "I:SDSIV": "PROSHARES ULTRASHORT S&P500 ETF", "I:SE30": "Dow Jones Sweden Titans 30 Index", "I:SE30D": "Dow Jones Sweden Titans 30 Index (USD)", "I:SEDOW": "Dow Jones Sweden Index", "I:SEDOWD": "Dow Jones Sweden Index (USD)", "I:SEFIV": "PROSHARES SHORT FINANCIALS ETF", "I:SEPZIV": "TrueShares Structured Outcome (September) ETF Intraday Indicative Value", "I:SET": "S&P 500 Settlement Index", "I:SGDOW": "Dow Jones Singapore Index", "I:SGDOWD": "Dow Jones Singapore Index (USD)", "I:SHIV": "PROSHARES SHORT S&P500", "I:SHORTVOL": "Short VIX Futures Index", "I:SIJIV": "PROSHARES ULTRASHORT INDUSTRIALS ETF", "I:SIOIV": "Touchstone Strategic Income Opportunities ETF", "I:SISB": "Materials Select Sector Settlement Index", "I:SISC": "Communication Services Select Sector Settlement Index", "I:SISE": "Energy Select Sector Settlement Index", "I:SISIN": "Industrials Select Sector Settlement Index", "I:SISM": "Financial Select Sector Settlement Index", "I:SISR": "Consumer Staples Select Sector Settlement Index", "I:SISRE": "Real Estate Select Sector Settlement Index", "I:SIST": "Technology Select Sector Settlement Index", "I:SISUT": "Utilities Select Sector Settlement Index", "I:SISV": "Health Care Select Sector Settlement Index", "I:SISY": "Consumer Discretionary Select Sector Settlement Index", "I:SIXB": "Materials Select Sector Index", "I:SIXC": "Communication Services Select Sector Index", "I:SIXE": "Energy Select Sector Index", "I:SIXI": "Industrials Select Sector Index", "I:SIXJIV": "AllianzIM U.S. Large Cap 6 Month Buffer10 Jan/Jul ETF Intraday Indicative Value", "I:SIXM": "Financial Select Sector Index", "I:SIXOIV": "AllianzIM U.S. Large Cap 6 Month Buffer10 Apr/Oct ETF Intraday Indicative Value", "I:SIXR": "Consumer Staples Select Sector Index", "I:SIXRE": "Real Estate Select Sector Index", "I:SIXT": "Technology Select Sector Index", "I:SIXU": "Utilities Select Sector Index", "I:SIXV": "Health Care Select Sector Index", "I:SIXY": "Consumer Discretionary Select Sector Index", "I:SJBIV": "PROSHARES SHORT HIGH YIELD ETF", "I:SKEW": "Cboe SKEW Index", "I:SKFIV": "PROSHARES ULTRASHORT FINANCIALS ETF", "I:SKYUIV": "PROSHARES ULTRA NASDAQ CLOUD COMPUTING ETF", "I:SMDDIV": "PROSHARES ULTRAPRO SHORT MIDCAP400 ETF", "I:SMDVIV": "PROSHARES RUSSELL 2000 DIVIDEND GROWERS ETF", "I:SMILE": "Cboe SMILE Index", "I:SMNIV": "PROSHARES ULTRASHORT BASIC MATERIALS ETF", "I:SOL100RP": "Cboe 100 Solana / US Dollar RealPrice Index", "I:SOL1KRP": "Cboe 1000 Solana / US Dollar RealPrice Index", "I:SOL2500": "Cboe 2500 Solana / US Dollar RealPrice Index", "I:SOL500RP": "Cboe 500 Solana / US Dollar RealPrice Index", "I:SOL5KRP": "Cboe 5000 Solana / US Dollar RealPrice Index", "I:SOX": "PHLX Semiconductor", "I:SOX2DL": "PHLX Semiconductor 2.0x Daily Leveraged", "I:SOXNTR": "PHLX Semiconductor Net Total Return", "I:SP0BF10A": "Cboe S&P 500 10% Buffered Zero Apr Index Series", "I:SP0BF10D": "Cboe S&P 500 10% Buffered Zero Dec Index Series", "I:SP0BF10F": "Cboe S&P 500 10% Buffered Zero Feb Index Series", "I:SP0BF10G": "Cboe S&P 500 10% Buffered Zero Aug Index Series", "I:SP0BF10J": "Cboe S&P 500 10% Buffered Zero Jan Index Series", "I:SP0BF10L": "Cboe S&P 500 10% Buffered Zero Jul Index Series", "I:SP0BF10M": "Cboe S&P 500 10% Buffered Zero Mar Index Series", "I:SP0BF10N": "Cboe S&P 500 10% Buffered Zero Nov Index Series", "I:SP0BF10O": "Cboe S&P 500 10% Buffered Zero Oct Index Series", "I:SP0BF10S": "Cboe S&P 500 10% Buffered Zero Sep Index Series", "I:SP0BF10U": "Cboe S&P 500 10% Buffered Zero Jun Index Series", "I:SP0BF10Y": "Cboe S&P 500 10% Buffered Zero May Index Series", "I:SP2BF10A": "Cboe S&P 500 10% Buffered 25 Apr Index Series", "I:SP2BF10D": "Cboe S&P 500 10% Buffered 25 Dec Index Series", "I:SP2BF10F": "Cboe S&P 500 10% Buffered 25 Feb Index Series", "I:SP2BF10G": "Cboe S&P 500 10% Buffered 25 Aug Index Series", "I:SP2BF10J": "Cboe S&P 500 10% Buffered 25 Jan Index Series", "I:SP2BF10L": "Cboe S&P 500 10% Buffered 25 Jul Index Series", "I:SP2BF10M": "Cboe S&P 500 10% Buffered 25 Mar Index Series", "I:SP2BF10N": "Cboe S&P 500 10% Buffered 25 Nov Index Series", "I:SP2BF10O": "Cboe S&P 500 10% Buffered 25 Oct Index Series", "I:SP2BF10S": "Cboe S&P 500 10% Buffered 25 Sep Index Series", "I:SP2BF10U": "Cboe S&P 500 10% Buffered 25 Jun Index Series", "I:SP2BF10Y": "Cboe S&P 500 10% Buffered 25 May Index Series", "I:SP7BF10A": "Cboe S&P 500 10% Buffered 75 Apr Index Series", "I:SP7BF10D": "Cboe S&P 500 10% Buffered 75 Dec Index Series", "I:SP7BF10F": "Cboe S&P 500 10% Buffered 75 Feb Index Series", "I:SP7BF10G": "Cboe S&P 500 10% Buffered 75 Aug Index Series", "I:SP7BF10J": "Cboe S&P 500 10% Buffered 75 Jan Index Series", "I:SP7BF10L": "Cboe S&P 500 10% Buffered 75 Jul Index Series", "I:SP7BF10M": "Cboe S&P 500 10% Buffered 75 Mar Index Series", "I:SP7BF10N": "Cboe S&P 500 10% Buffered 75 Nov Index Series", "I:SP7BF10O": "Cboe S&P 500 10% Buffered 75 Oct Index Series", "I:SP7BF10S": "Cboe S&P 500 10% Buffered 75 Sep Index Series", "I:SP7BF10U": "Cboe S&P 500 10% Buffered 75 Jun Index Series", "I:SP7BF10Y": "Cboe S&P 500 10% Buffered 75 May Index Series", "I:SPAI": "Cboe S&P 500 Dividend Aristocrat Target Income Index", "I:SPATI": "Cboe S&P 500 Dividend Aristocrats Target Income Index Monthly Series", "I:SPBFQ": "Cboe S&P 500 15% WHT Quarterly 5% Buffer Protect Index", "I:SPBNQ": "Cboe S&P 500 15% WHT Quarterly 9% (-3% to -12%) Buffer Protect Index", "I:SPBUF10A": "Cboe S&P 500 10% Buffered Apr Index Series", "I:SPBUF10D": "Cboe S&P 500 10% Buffered Dec Index Series", "I:SPBUF10F": "Cboe S&P 500 10% Buffered Feb Index Series", "I:SPBUF10G": "Cboe S&P 500 10% Buffered Aug Index Series", "I:SPBUF10J": "Cboe S&P 500 10% Buffered Jan Index Series", "I:SPBUF10L": "Cboe S&P 500 10% Buffered Jul Index Series", "I:SPBUF10M": "Cboe S&P 500 10% Buffered Mar Index Series", "I:SPBUF10N": "Cboe S&P 500 10% Buffered Nov Index Series", "I:SPBUF10O": "Cboe S&P 500 10% Buffered Oct Index Series", "I:SPBUF10S": "Cboe S&P 500 10% Buffered Sep Index Series", "I:SPBUF10U": "Cboe S&P 500 10% Buffered Jun Index Series", "I:SPBUF10Y": "Cboe S&P 500 10% Buffered May Index Series", "I:SPDVXE": "S&P 500 Dynamic VIX Futures Index ER", "I:SPDVXT": "S&P 500 Dynamic VIX Futures Index TR", "I:SPEN": "Cboe S&P 500 Enhanced Growth Index Series", "I:SPEN01": "Cboe S&P 500 Enhanced Growth Index Series", "I:SPEN02": "Cboe S&P 500 Enhanced Growth Index Series", "I:SPEN03": "Cboe S&P 500 Enhanced Growth Index Series", "I:SPEN04": "Cboe S&P 500 Enhanced Growth Index Series", "I:SPEN05": "Cboe S&P 500 Enhanced Growth Index Series", "I:SPEN06": "Cboe S&P 500 Enhanced Growth Index Series", "I:SPEN07": "Cboe S&P 500 Enhanced Growth Index Series", "I:SPEN08": "Cboe S&P 500 Enhanced Growth Index Series", "I:SPEN09": "Cboe S&P 500 Enhanced Growth Index Series", "I:SPEN10": "Cboe S&P 500 Enhanced Growth Index Series", "I:SPEN11": "Cboe S&P 500 Enhanced Growth Index Series", "I:SPEN12": "Cboe S&P 500 Enhanced Growth Index Series", "I:SPENME": "Cboe S&P 500 Enhanced Growth Balanced Series", "I:SPENME01": "Cboe S&P 500 Enhanced Growth Index January Series", "I:SPENME02": "Cboe S&P 500 Enhanced Growth Index February Series", "I:SPENME03": "Cboe S&P 500 Enhanced Growth Index March Series", "I:SPENME04": "Cboe S&P 500 Enhanced Growth Index April Series", "I:SPENME05": "Cboe S&P 500 Enhanced Growth Index May Series", "I:SPENME06": "Cboe S&P 500 Enhanced Growth Index June Series", "I:SPENME07": "Cboe S&P 500 Enhanced Growth Index July Series", "I:SPENME08": "Cboe S&P 500 Enhanced Growth Index August Series", "I:SPENME09": "Cboe S&P 500 Enhanced Growth Index September Series", "I:SPENME10": "Cboe S&P 500 Enhanced Growth Index October Series", "I:SPENME11": "Cboe S&P 500 Enhanced Growth Index November Series", "I:SPENME12": "Cboe S&P 500 Enhanced Growth Index December Series", "I:SPESG": "S&P 500 ESG Index", "I:SPHB6": "Dow Jones Indices-DJI", "I:SPJGBV": "S&P/JPX JGB VIX", "I:SPJGBVRT": "S&P/JPX JGB VIX Real-time", "I:SPRF": "Cboe S&P 500 15% Buffer Protect Index Balanced Series", "I:SPRF01": "Cboe S&P 500 15% Buffer Protect Index January Series", "I:SPRF02": "Cboe S&P 500 15% Buffer Protect Index February Series", "I:SPRF03": "Cboe S&P 500 15% Buffer Protect Index March Series", "I:SPRF04": "Cboe S&P 500 15% Buffer Protect Index April Series", "I:SPRF05": "Cboe S&P 500 15% Buffer Protect Index May Series", "I:SPRF06": "Cboe S&P 500 15% Buffer Protect Index June Series", "I:SPRF07": "Cboe S&P 500 15% Buffer Protect Index July Series", "I:SPRF08": "Cboe S&P 500 15% Buffer Protect Index August Series", "I:SPRF09": "Cboe S&P 500 15% Buffer Protect Index September Series", "I:SPRF10": "Cboe S&P 500 15% Buffer Protect Index October Series", "I:SPRF11": "Cboe S&P 500 15% Buffer Protect Index November Series", "I:SPRF12": "Cboe S&P 500 15% Buffer Protect Index December Series", "I:SPRI": "Cboe S&P 500 Range-Bound Premium Income Index Series", "I:SPRO": "Cboe S&P500 Buffer Protect Index Balanced Series", "I:SPRO01": "Cboe S&P500 Buffer Protect Index Balanced Series", "I:SPRO02": "Cboe S&P500 Buffer Protect Index Balanced Series", "I:SPRO03": "Cboe S&P500 Buffer Protect Index Balanced Series", "I:SPRO04": "Cboe S&P500 Buffer Protect Index Balanced Series", "I:SPRO05": "Cboe S&P500 Buffer Protect Index Balanced Series", "I:SPRO06": "Cboe S&P500 Buffer Protect Index Balanced Series", "I:SPRO07": "Cboe S&P500 Buffer Protect Index Balanced Series", "I:SPRO08": "Cboe S&P500 Buffer Protect Index Balanced Series", "I:SPRO09": "Cboe S&P500 Buffer Protect Index Balanced Series", "I:SPRO10": "Cboe S&P500 Buffer Protect Index Balanced Series", "I:SPRO11": "Cboe S&P500 Buffer Protect Index Balanced Series", "I:SPRO12": "Cboe S&P500 Buffer Protect Index Balanced Series", "I:SPROME": "Cboe S&P 500 Buffer Protect Index Balanced Series", "I:SPROME01": "Cboe S&P 500 Buffer Protect Index January Series", "I:SPROME02": "Cboe S&P 500 Buffer Protect Index February Series", "I:SPROME03": "Cboe S&P 500 Buffer Protect Index March Series", "I:SPROME04": "Cboe S&P 500 Buffer Protect Index April Series", "I:SPROME05": "Cboe S&P 500 Buffer Protect Index May Series", "I:SPROME06": "Cboe S&P 500 Buffer Protect Index June Series", "I:SPROME07": "Cboe S&P 500 Buffer Protect Index July Series", "I:SPROME08": "Cboe S&P 500 Buffer Protect Index August Series", "I:SPROME09": "Cboe S&P 500 Buffer Protect Index September Series", "I:SPROME10": "Cboe S&P 500 Buffer Protect Index October Series", "I:SPROME11": "Cboe S&P 500 Buffer Protect Index November Series", "I:SPROME12": "Cboe S&P 500 Buffer Protect Index December Series", "I:SPRS01": "Cboe S&P 500 30% (-5% to -35%) Buffer Protect Index January Series", "I:SPRS04": "Cboe S&P 500 30% (-5% to -35%) Buffer Protect Index April Series", "I:SPRS07": "Cboe S&P 500 30% (-5% to -35%) Buffer Protect Index July Series", "I:SPRS10": "Cboe S&P 500 30% (-5% to -35%) Buffer Protect Index October Series", "I:SPTST": "S&P 500 TEST", "I:SPVXEP": "S&P 500 VIX Futures Enhanced Roll Index ER", "I:SPVXET": "S&P 500 VIX Futures Enhanced Roll Index TR", "I:SPX": "Standard & Poor's 500", "I:SPXBIV": "PROSHARES S&P 500 BOND ETF", "I:SPXEIV": "PROSHARES S&P 500 EX-ENERGY ETF", "I:SPXNIV": "PROSHARES S&P 500 EX-FINANCIALS ETF", "I:SPXTIV": "PROSHARES S&P 500 EX-TECHNOLOGY ETF", "I:SPXUIV": "PROSHARES ULTRAPRO SHORT SP500 ETF", "I:SPXVIV": "PROSHARES S&P 500 EX-HEALTH CARE ETF", "I:SQQQIV": "PROSHARES ULTRAPRO SHORT QQQ ETF", "I:SRO": "S&P 500 Range Option Underlying Index", "I:SRSIV": "PROSHARES ULTRASHORT REAL ESTATE ETF", "I:SRTYIV": "PROSHARES ULTRAPRO SHORT RUSSELL2000 ETF", "I:SRVRSCNR": "Kelly Data Center & Tech Infrastructure Net Total", "I:SRVRSCPR": "Kelly Data Center & Tech Infrastructure Index", "I:SRVRSCTR": "Kelly Data Center & Tech Infrastructure Total Retu", "I:SSGIV": "PROSHARES ULTRASHORT SEMICONDUCTORS ETF", "I:SSOIV": "PROSHARES ULTRA S&P500 ETF", "I:SSTGK": "Cboe S&P 500 4% OTM Short Strangle Index (with KRW 3 month Certificate of Deposit)", "I:SUPDN": "Cboe S&P Enhance and Buffer Index", "I:SUPLIV": "PROSHARES SUPPLY CHAIN LOGISTICS ETF", "I:SVIXIV": "-1x Short VIX Futures ETF - Intraday Indicative Value", "I:SVRPO": "Cboe S&P 500 Market-Neutral Volatility Risk Premia Optimized Index", "I:SVXYIV": "ProShares Short VIX Short-Term Futures ETF", "I:SWANXT": "The ARGI BlackSwan Core Index", "I:SWGOVT115": "Swedish Government Bond 1-15", "I:SX101010GI": "OMX Stockholm Software and Computer Services GI", "I:SX101010PI": "OMX Stockholm Software and Computer Services PI", "I:SX101020GI": "OMX Stockholm Technology Hardware and Equipment GI", "I:SX101020PI": "OMX Stockholm Technology Hardware and Equipment PI", "I:SX10GI": "OMX Stockholm Technology GI", "I:SX10PI": "OMX Stockholm Technology PI", "I:SX151010GI": "OMX Stockholm Telecommunications Equipment GI", "I:SX151010PI": "OMX Stockholm Telecommunications Equipment PI", "I:SX151020GI": "OMX Stockholm Telecommunications Service Providers GI", "I:SX151020PI": "OMX Stockholm Telecommunications Service Providers PI", "I:SX15GI": "OMX Stockholm Telecommunications GI", "I:SX15PI": "OMX Stockholm Telecommunications PI", "I:SX201010GI": "OMX Stockholm Health Care Providers GI", "I:SX201010PI": "OMX Stockholm Health Care Providers PI", "I:SX201020GI": "OMX Stockholm Medical Equipment and Services GI", "I:SX201020PI": "OMX Stockholm Medical Equipment and Services PI", "I:SX201030GI": "OMX Stockholm Pharmaceuticals and Biotechnology GI", "I:SX201030PI": "OMX Stockholm Pharmaceuticals and Biotechnology PI", "I:SX20GI": "OMX Stockholm Health Care GI", "I:SX20PI": "OMX Stockholm Health Care PI", "I:SX3010GI": "OMX Stockholm Banks GI", "I:SX3010PI": "OMX Stockholm Banks PI", "I:SX302010GI": "OMX Stockholm Finance and Credit Services GI", "I:SX302010PI": "OMX Stockholm Finance and Credit Services PI", "I:SX302020GI": "OMX Stockholm Investment Banking and Brokerage Services  GI", "I:SX302020PI": "OMX Stockholm Investment Banking and Brokerage Services  PI", "I:SX3020GI": "OMX Stockholm Financial Services GI", "I:SX3020PI": "OMX Stockholm Financial Services PI", "I:SX303020GI": "OMX Stockholm Non-life Insurance GI", "I:SX303020PI": "OMX Stockholm Non-life Insurance PI", "I:SX3030GI": "OMX Stockholm Insurance GI", "I:SX3030PI": "OMX Stockholm Insurance PI", "I:SX30GI": "OMX Stockholm Financials GI", "I:SX30PI": "OMX Stockholm Financials PI", "I:SX351010GI": "OMX Stockholm Real Estate Investment and Services GI", "I:SX351010PI": "OMX Stockholm Real Estate Investment and Services PI", "I:SX35GI": "OMX Stockholm Real Estate GI", "I:SX35PI": "OMX Stockholm Real Estate PI", "I:SX4010GI": "OMX Stockholm Automobiles and Parts GI", "I:SX4010PI": "OMX Stockholm Automobiles and Parts PI", "I:SX402010GI": "OMX Stockholm Consumer Services GI", "I:SX402010PI": "OMX Stockholm Consumer Services PI", "I:SX402020GI": "OMX Stockholm Household Goods and Home Construction GI", "I:SX402020PI": "OMX Stockholm Household Goods and Home Construction PI", "I:SX402030GI": "OMX Stockholm Leisure Goods GI", "I:SX402030PI": "OMX Stockholm Leisure Goods PI", "I:SX402040GI": "OMX Stockholm Personal Goods GI", "I:SX402040PI": "OMX Stockholm Personal Goods PI", "I:SX4020GI": "OMX Stockholm Consumer Products and Services GI", "I:SX4020PI": "OMX Stockholm Consumer Products and Services PI", "I:SX4030GI": "OMX Stockholm Media GI", "I:SX4030PI": "OMX Stockholm Media PI", "I:SX404010GI": "OMX Stockholm Retailers GI", "I:SX404010PI": "OMX Stockholm Retailers PI", "I:SX4040GI": "OMX Stockholm Retail GI", "I:SX4040PI": "OMX Stockholm Retail PI", "I:SX4050GI": "OMX Stockholm Travel and Leisure GI", "I:SX4050PI": "OMX Stockholm Travel and Leisure PI", "I:SX40GI": "OMX Stockholm Consumer Discretionary GI", "I:SX40PI": "OMX Stockholm Consumer Discretionary PI", "I:SX451020GI": "OMX Stockholm Food Producers GI", "I:SX451020PI": "OMX Stockholm Food Producers PI", "I:SX4510GI": "OMX Stockholm Food, Beverage and Tobacco  GI", "I:SX4510PI": "OMX Stockholm Food, Beverage and Tobacco  PI", "I:SX4520GI": "OMX Stockholm Personal Care, Drug and Grocery Stores GI", "I:SX4520PI": "OMX Stockholm Personal Care, Drug and Grocery Stores PI", "I:SX45GI": "OMX Stockholm Consumer Staples GI", "I:SX45PI": "OMX Stockholm Consumer Staples PI", "I:SX5010GI": "OMX Stockholm Construction and Materials GI", "I:SX5010PI": "OMX Stockholm Construction and Materials PI", "I:SX502010GI": "OMX Stockholm Aerospace and Defense GI", "I:SX502010PI": "OMX Stockholm Aerospace and Defense PI", "I:SX502020GI": "OMX Stockholm Electronic and Electrical Equipment GI", "I:SX502020PI": "OMX Stockholm Electronic and Electrical Equipment PI", "I:SX502030GI": "OMX Stockholm General Industrials GI", "I:SX502030PI": "OMX Stockholm General Industrials PI", "I:SX502040GI": "OMX Stockholm Industrial Engineering GI", "I:SX502040PI": "OMX Stockholm Industrial Engineering PI", "I:SX502050GI": "OMX Stockholm Industrial Support Services GI", "I:SX502050PI": "OMX Stockholm Industrial Support Services PI", "I:SX502060GI": "OMX Stockholm Industrial Transportation GI", "I:SX502060PI": "OMX Stockholm Industrial Transportation PI", "I:SX5020GI": "OMX Stockholm Industrial Goods and Services GI", "I:SX5020PI": "OMX Stockholm Industrial Goods and Services PI", "I:SX50GI": "OMX Stockholm Industrials GI", "I:SX50PI": "OMX Stockholm Industrials PI", "I:SX551010GI": "OMX Stockholm Industrial Materials GI", "I:SX551010PI": "OMX Stockholm Industrial Materials PI", "I:SX551020GI": "OMX Stockholm Industrial Metals and Mining GI", "I:SX551020PI": "OMX Stockholm Industrial Metals and Mining PI", "I:SX551030GI": "OMX Stockholm Precious Metals and Mining GI", "I:SX551030PI": "OMX Stockholm Precious Metals and Mining PI", "I:SX5510GI": "OMX Stockholm Basic Resources GI", "I:SX5510PI": "OMX Stockholm Basic Resources PI", "I:SX5520GI": "OMX Stockholm Chemicals GI", "I:SX5520PI": "OMX Stockholm Chemicals PI", "I:SX55GI": "OMX Stockholm Basic Materials GI", "I:SX55PI": "OMX Stockholm Basic Materials PI", "I:SX601010GI": "OMX Stockholm Oil, Gas and Coal GI", "I:SX601010PI": "OMX Stockholm Oil, Gas and Coal PI", "I:SX601020GI": "OMX Stockholm Alternative Energy GI", "I:SX601020PI": "OMX Stockholm Alternative Energy PI", "I:SX60GI": "OMX Stockholm Energy GI", "I:SX60PI": "OMX Stockholm Energy PI", "I:SX651010GI": "OMX Stockholm Electricity GI", "I:SX651010PI": "OMX Stockholm Electricity PI", "I:SX65GI": "OMX Stockholm Utilities GI", "I:SX65PI": "OMX Stockholm Utilities PI", "I:SZKIV": "PROSHARES ULTRASHORT CONSUMER GOODS ETF", "I:TBFIV": "PROSHARES SHORT 20+ YEAR TREASURY ETF", "I:TBTIV": "PROSHARES ULTRASHORT BARCLAYS 20+YR TR", "I:TBXIV": "PROSHARES SHORT 7-10 YEAR TREASURY ETF", "I:TDEX": "Nations TailDex", "I:TDVIV": "PROSHARES S&P TECHNOLOGY DIV ARISTOCRATS", "I:TINTIV": "PROSHARES SMART MATERIALS ETF", "I:TINYIV": "PROSHARES NANOTECHNOLOGY ETF", "I:TLTPRO": "Cboe 20 Year Treasury 10% Buffer Protect Index Balanced Series", "I:TLTPRO01": "Cboe 20 Year Treasury 10% Buffer Protect Index January Series", "I:TLTPRO02": "Cboe 20 Year Treasury 10% Buffer Protect Index February Series", "I:TLTPRO03": "Cboe 20 Year Treasury 10% Buffer Protect Index March Series", "I:TLTPRO04": "Cboe 20 Year Treasury 10% Buffer Protect Index April Series", "I:TLTPRO05": "Cboe 20 Year Treasury 10% Buffer Protect Index May Series", "I:TLTPRO06": "Cboe 20 Year Treasury 10% Buffer Protect Index June Series", "I:TLTPRO07": "Cboe 20 Year Treasury 10% Buffer Protect Index July Series", "I:TLTPRO08": "Cboe 20 Year Treasury 10% Buffer Protect Index August Series", "I:TLTPRO09": "Cboe 20 Year Treasury 10% Buffer Protect Index September Series", "I:TLTPRO10": "Cboe 20 Year Treasury 10% Buffer Protect Index October Series", "I:TLTPRO11": "Cboe 20 Year Treasury 10% Buffer Protect Index November Series", "I:TLTPRO12": "Cboe 20 Year Treasury 10% Buffer Protect Index December Series", "I:TLTWIV": "iShares 20+ Year Treasury Bond BuyWrite Strategy ETF Intraday Indicative Value", "I:TMDVIV": "PROSHARES RUSSELL US DIVIDEND GROWERS ETF", "I:TNX": "Cboe Interest Rate 10 Year T Note", "I:TOLZIV": "PROSHARES DJ BROOKFIELD GLOBAL INFRASTRUCTURE ETF", "I:TQQQIV": "PROSHARES ULTRAPRO QQQ ETF", "I:TR20": "Dow Jones Turkey Titans 20 Index", "I:TR20D": "Dow Jones Turkey Titans 20 Index (USD)", "I:TR20DT": "Dow Jones Turkey Titans 20 Total Return Index (USD)", "I:TR20E": "Dow Jones Turkey Titans 20 Index (EUR)", "I:TRAN": "Nasdaq Transportation", "I:TRESTAT": "Strategic Technology & Ecommerce Real Estate Index", "I:TRESTATAUD": "Strategic Technology & Ecommerce Real Estate AUD Index", "I:TRESTATCAD": "Strategic Technology & Ecommerce Real Estate CAD Index", "I:TRESTATEUR": "Strategic Technology & Ecommerce Real Estate EUR Index", "I:TRESTATGBP": "Strategic Technology & Ecommerce Real Estate GBP Index", "I:TRESTATJPY": "Strategic Technology & Ecommerce Real Estate JPY Index", "I:TRESTATN": "Strategic Technology & Ecommerce Real Estate Net Total Return Index", "I:TRESTATNAUD": "Strategic Technology & Ecommerce Real Estate Net Total Return AUD Index", "I:TRESTATNCAD": "Strategic Technology & Ecommerce Real Estate Net Total Return CAD Index", "I:TRESTATNEUR": "Strategic Technology & Ecommerce Real Estate Net Total Return EUR Index", "I:TRESTATNGBP": "Strategic Technology & Ecommerce Real Estate Net Total Return GBP Index", "I:TRESTATNJPY": "Strategic Technology & Ecommerce Real Estate Net Total Return JPY Index", "I:TRESTATT": "Strategic Technology & Ecommerce Real Estate Total Return Index", "I:TRESTATTAUD": "Strategic Technology & Ecommerce Real Estate Total Return AUD Index", "I:TRESTATTCAD": "Strategic Technology & Ecommerce Real Estate Total Return CAD Index", "I:TRESTATTEUR": "Strategic Technology & Ecommerce Real Estate Total Return EUR Index", "I:TRESTATTGBP": "Strategic Technology & Ecommerce Real Estate Total Return GBP Index", "I:TRESTATTJPY": "Strategic Technology & Ecommerce Real Estate Total Return JPY Index", "I:TSMEHOLIV": "Thrivent Small-Mid Cap ESG ETF \u2013 Holdings Basket", "I:TSMEIV": "Thrivent Small-Mid Cap ESG ETF", "I:TTTIV": "PROSHARES ULTRAPRO SHORT 20Y PLUS TREASURY", "I:TUSIIV": "Touchstone Ultra Short Income ETF", "I:TVIXIV": "VelocityShares Daily 2x VIX Short-Term ETN Intraday Indicative Value", "I:TWAV1": "Mid-morning TWAP value of Cboe 1st VIX Futures", "I:TWAV2": "Mid-morning TWAP value of Cboe 2nd VIX Futures", "I:TWAV3": "Cboe 3rd VIX Futures Mid-Morning 15 Minute Indicative TWAP Value", "I:TWBV1": "Cboe 1st VIX Futures Mid-Morning 3hour Ind TWAP Value", "I:TWBV2": "Cboe 2nd VIX Futures Mid-Morning 3hour Ind TWAP Value", "I:TWBV3": "Cboe 3rd VIX Futures Mid-Morning 3 Hour Indicative TWAP Value", "I:TWDOW": "Dow Jones Taiwan Index", "I:TWDOWD": "Dow Jones Taiwan Index (USD)", "I:TWLV1": "Cboe 1st VIX Futures Mid-Morning Indicative TWAP Value", "I:TWLV2": "Cboe 2nd VIX Futures Mid-Morning Indicative TWAP Value", "I:TWLV3": "Cboe 3rd VIX Futures Mid-Morning Indicative TWAP Value", "I:TWLV4": "Cboe 4th VIX Futures Mid-Morning Indicative TWAP Value", "I:TWLV5": "Cboe 5th VIX Futures Mid-Morning Indicative TWAP Value", "I:TWLV6": "Cboe 6th VIX Futures Mid-Morning Indicative TWAP Value", "I:TWLV7": "Cboe 7th VIX Futures Mid-Morning Indicative TWAP Value", "I:TWLV8": "Cboe 8th VIX Futures Mid-Morning Indicative TWAP Value", "I:TWLV9": "Mid-morning TWAP value of Cboe 9th VIX Futures", "I:TWMIV": "PROSHARES ULTRASHORT RUSSELL2000 ETF", "I:TYX": "Cboe 30 Year Treasury Yield Index", "I:UBRIV": "PROSHARES ULTRA MSCI BRAZIL CAPPED ETF", "I:UBTIV": "PROSHARES ULTRA 20+ YEAR TREASURY ETF", "I:UCCIV": "PROSHARES ULTRA CONSUMER SERVICES ETF", "I:UCOIV": "PROSHARES ULTRA BLOOMBERG CRUDE OIL ETF", "I:UCYBIV": "PROSHARES ULTRA NASDAQ CYBERSECURITY ETF", "I:UDOWIV": "PROSHARES ULTRAPRO DOW30 ETF", "I:UGAZIV": "VelocityShares 3x Long Natural Gas ETN Intraday Indicative Value", "I:UGEIV": "PROSHARES ULTRA CONSUMER GOODS ETF", "I:UGLDIV": "VelocityShares 3x Long Gold ETN Intraday Indicative Value", "I:UGLIV": "PROSHARES ULTRA GOLD ETF", "I:UJBIV": "PROSHARES ULTRA HIGH YIELD ETF", "I:UK50": "Dow Jones U.K. Titans 50 Index", "I:UK50D": "Dow Jones U.K. Titans 50 Index (USD)", "I:UK50E": "Dow Jones U.K. Titans 50 Index (EUR)", "I:ULEIV": "PROSHARES ULTRA EURO ETF", "I:UMDDIV": "PROSHARES ULTRAPRO MIDCAP400", "I:UNI1KRP": "Cboe 1000 Uniswap / US Dollar RealPrice Index", "I:UNI2500": "Cboe 2500 Uniswap / US Dollar RealPrice Index", "I:UNI250RP": "Cboe 250 Uniswap / US Dollar RealPrice Index", "I:UNI50RP": "Cboe 50 Uniswap / US Dollar RealPrice Index", "I:UNI5KRP": "Cboe 5000 Uniswap / US Dollar RealPrice Index", "I:UPROIV": "PROSHARES ULTRAPRO S&P500 ETF", "I:UPVIV": "PROSHARES ULTRA FTSE EUROPE ETF", "I:UPWIV": "PROSHARES ULTRA UTILITIES ETF", "I:UREIV": "PROSHARES ULTRA REAL ESTATE ETF", "I:URTYIV": "PROSHARES ULTRAPRO RUSSELL2000 ETF", "I:USDIV": "PROSHARES ULTRA SEMICONDUCTORS", "I:USLVIV": "VelocityShares 3x Long Silver ETN Intraday Indicative Value", "I:USTIV": "ProShares Ultra 7-10 Year Treasury", "I:UTY": "PHLX Utility Sector", "I:UVIXIV": "2x Long VIX Futures ETF January Intraday Indicative Value", "I:UVXYIV": "ProShares Ultra VIX Short-Term Futures ETF", "I:UWMIV": "PROSHARES ULTRA RUSSELL2000 ETF", "I:UXIIV": "PROSHARES ULTRA INDUSTRIALS ETF", "I:UYGIV": "PROSHARES ULTRA FINANCIALS ETF", "I:UYMIV": "PROSHARES ULTRA BASIC MATERIALS ETF", "I:UZF": "Cboe VIX Jan Futures 4pm EST Mark Index", "I:UZG": "Cboe VIX Feb Futures 4pm EST Mark Index", "I:UZH": "Cboe VIX Mar Futures 4 pm EST Mark Index", "I:UZJ": "Cboe VIX Apr Futures 4 pm EST Mark Index", "I:UZK": "Cboe VIX May Futures 4 pm EST Mark Index", "I:UZM": "Cboe VIX Jun Futures 4 pm EST Mark Index", "I:UZN": "Cboe VIX Jul Futures 4 pm EST Mark Index", "I:UZQ": "Cboe VIX Aug Futures 4 pm EST Mark Index", "I:UZU": "Cboe VIX Sep Futures 4 pm EST Mark Index", "I:UZV": "Cboe VIX Oct Futures 4 pm EST Mark Index", "I:UZX": "Cboe VIX Nov Futures 4 pm EST Mark Index", "I:UZZ": "Cboe VIX Dec Futures 4 pm EST Mark Index", "I:VERSIV": "PROSHARES METAVERSE ETF", "I:VFTW1": "Cboe 1st Month VIX Futures 15 Mins EOD Ind TWAP Value", "I:VFTW2": "Cboe 2nd Month VIX Futures 15 Mins EOD Ind TWAP Value", "I:VIF": "VIX Component Volatility Index", "I:VIFMO": "Cboe Far-Term VIXMO Index", "I:VIIXIV": "VelocityShares VIX Short-Term ETN Intraday Indicative Value", "I:VIN": "VIX Component Volatility Index", "I:VINMO": "Cboe Near-Term VIXMO Index", "I:VINXE": "VIX Near-Term Month", "I:VIX": "Cboe Volatility Index","I:VIX1Y": "Cboe S&P 500 One-Year Volatility Index", "I:VIX3M": "Cboe S&P 500 3 Month Volatility Index", "I:VIX6M": "CBOE S&P 500 6-Month Volatility Index", "I:VIX9D": "CBOE S&P 500 9-Day Volatility Index", "I:VIXMIV": "ProShares VIX Mid-Term Futures ETF", "I:VIXMO": "CBOE Standard Monthly Only 30-day Volatility Index", "I:VIXYIV": "ProShares VIX Short-Term Futures ETF", "I:VMELM": "Nasdaq Victory Emerging Market Value Momentum Index", "I:VMELMN": "Nasdaq Victory Emerging Market Value Momentum Net Total Return Index", "I:VMELMT": "Nasdaq Victory Emerging Market Value Momentum Total Return Index", "I:VMILM": "Nasdaq Victory International Value Momentum Index", "I:VMILMN": "Nasdaq Victory International Value Momentum Net Total Return Index", "I:VMILMT": "Nasdaq Victory International Value Momentum Total Return Index", "I:VMILMT.TEST": "Nasdaq Victory International Value Momentum Total Return Index TEST", "I:VMULC": "Nasdaq Victory US Value Momentum Index", "I:VMULCN": "Nasdaq Victory US Value Momentum Net Total Return Index", "I:VMULCT": "Nasdaq Victory US Value Momentum Total Return Index", "I:VMUSM": "Nasdaq Victory US Small Mid Cap Value Momentum Index", "I:VMUSMN": "Nasdaq Victory US Small Mid Cap Value Momentum Net Total Return Index", "I:VMUSMT": "Nasdaq Victory US Small Mid Cap Value Momentum Total Return Index", "I:VOLI": "Nations VolDex", "I:VOLNDX": "Volatility NASDAQ - 100", "I:VOLQ": "Nasdaq-100 Volatility Index VOLQ", "I:VOLS": "Nasdaq-100 Volatility Index Final Settlement Price", "I:VPD": "Cboe VIX Premium Strategy Indexes", "I:VPN": "Cboe Capped VIX Premium Strategy Index", "I:VRO": "Cboe Volatility Index Settlement Value", "I:VSTF": "CBOE S&P 500 Far-Term 9-Day Volatility Index", "I:VSTG": "Cboe VIX Strangle Index", "I:VSTN": "CBOE S&P 500 Near-Term 9-Day Volatility Index", "I:VVIX": "Cboe VVIX Index", "I:VW1VX": "Cboe Near-Term VIX Future Contract 2 Minute VWAP", "I:VW2VX": "Cboe Second-Term VIX Future Contract 2 Minute VWAP", "I:VW3VX": "Cboe Third-Term VIX Future Contract 2 Minute VWAP", "I:VWA": "Cboe VIX Indicative Ask Index", "I:VWB": "Cboe VIX Indicative Bid Index", "I:VX15TW1": "Cboe 1st VIX Futures 15min Indicative TWAP Midpoint Value", "I:VX15TW1A": "Cboe 1st VIX Futures 15min Indicative TWAP Ask Value", "I:VX15TW1B": "Cboe 1st VIX Futures 15min Indicative TWAP Bid Value", "I:VX15TW2": "Cboe 2nd VIX Futures 15min Indicative TWAP Midpoint Value", "I:VX15TW2A": "Cboe 2nd VIX Futures 15min Indicative TWAP Ask Value", "I:VX15TW2B": "Cboe 2nd VIX Futures 15min Indicative TWAP Bid Value", "I:VXAPL": "VXAPL (Cboe APPLE VIX)", "I:VXAZN": "Cboe Options on AMZN - Amazon Inc.", "I:VXD": "Cboe DJIA Volatility Index", "I:VXEEM": "Cboe Emerging Markets Volatility Index", "I:VXEFA": "Cboe EFA ETF Volatility Index", "I:VXEWZ": "Cboe Brazil ETF Volatility Index", "I:VXGOG": "Cboe Equity VIX on Google", "I:VXGS": "Cboe Equity VIX on Goldman Sachs", "I:VXIBM": "Cboe Equity VIX on IBM", "I:VXIND1": "Cboe VX Futures 1st Near-Term Month Indicative Daily Settlement Value", "I:VXIND2": "Cboe VX Futures 2nd Near-Term Month Indicative Daily Settlement Value", "I:VXIND3": "Cboe VX Futures 3rd Near-Term Month Indicative Daily Settlement Value", "I:VXN": "Cboe NASDAQ-100 Volatility Index", "I:VXS": "Cboe Volatility Index Options Settlement Price", "I:VXTA1": "Cboe 1st VIX Futures TAS Ask Price Index", "I:VXTA2": "Cboe 2nd VIX Futures TAS Ask Price Index", "I:VXTA3": "Cboe 3rd VIX Futures TAS Ask Price Index", "I:VXTB1": "Cboe 1st VIX Futures TAS Bid Price Index", "I:VXTB2": "Cboe 2nd VIX Futures TAS Bid Price Index", "I:VXTB3": "Cboe 3rd VIX Futures TAS Bid Price Index", "I:VXTH": "Cboe VIX Tail Hedge Index", "I:VXTLT": "TLT VIX", "I:W1BSC": "Dow Jones Global Basic Materials Index", "I:W1CYC": "Dow Jones Global Consumer Services Index", "I:W1DOW": "Dow Jones Global Index", "I:W1ENE": "Dow Jones Global Oil & Gas Index", "I:W1FIN": "Dow Jones Global Financials Index", "I:W1HCR": "Dow Jones Global Health Care Index", "I:W1IDU": "Dow Jones Global Industrials Index", "I:W1NCY": "Dow Jones Global Consumer Goods Index", "I:W1SGI": "Dow Jones Sustainability World Index", "I:W1SUS": "Dow Jones Sustainability World Ex-Alcohol, Tobacco, Gambling, and Armaments & Firearms Index", "I:W1TEC": "Dow Jones Global Technology Index", "I:W1TLS": "Dow Jones Global Telecommunications Index", "I:W1UTI": "Dow Jones Global Utilities Index", "I:W2BSC": "Dow Jones Global ex-U.S. Basic Materials Index", "I:W2CYC": "Dow Jones Global ex-U.S. Consumer Services Index", "I:W2DOW": "Dow Jones Global ex-U.S. Index", "I:W2ENE": "Dow Jones Global ex-U.S. Oil & Gas Index", "I:W2FIN": "Dow Jones Global ex-U.S. Financials Index", "I:W2HCR": "Dow Jones Global ex-U.S. Health Care Index", "I:W2IDU": "Dow Jones Global ex-U.S. Industrials Index", "I:W2NCY": "Dow Jones Global ex-U.S. Consumer Goods Index", "I:W2TEC": "Dow Jones Global ex-U.S. Technology Index", "I:W2TLS": "Dow Jones Global ex-U.S. Telecommunications Index", "I:W2UTI": "Dow Jones Global ex-U.S. Utilities Index", "I:W3SGI": "Dow Jones Sustainability World Developed Index", "I:WALLET": "Nasdaq CTA Global Digital Payments Index", "I:WALLETAU": "Nasdaq CTA Global Digital Payments AUD Index", "I:WALLETAUNR": "Nasdaq CTA Global Digital Payments Net Total Return AUD Index", "I:WALLETAUTR": "Nasdaq CTA Global Digital Payments Gross Total Return AUD Index", "I:WALLETNR": "Nasdaq CTA Global Digital Payments Net Total Return Index", "I:WALLETTR": "Nasdaq CTA Global Digital Payments Gross Total Return Index", "I:WAVES1K": "Cboe 1000 Waves / US Dollar RealPrice Index", "I:WAVES20K": "Cboe 20K Waves / US Dollar RealPrice Index", "I:WAVES250": "Cboe 250 Waves / US Dollar RealPrice Index", "I:WAVES5K": "Cboe 5000 Waves / US Dollar RealPrice Index", "I:WEALTHAN": "Horizon Kinetics ISE Asia ex Japan Wealth NTR", "I:WEALTHAT": "Horizon Kinetics ISE Asia ex Japan Wealth TR Index", "I:WEALTHAX": "Horizon Kinetics ISE Asia ex Japan Wealth Index", "I:WEALTHGL": "Horizon Kinetics ISE Global Wealth Index", "I:WEALTHGN": "Horizon Kinetics ISE Global Wealth NTR Index", "I:WEALTHGT": "Horizon Kinetics ISE Global Wealth TR Index", "I:WPEF": "Cboe EAFE One-Week PutWrite Index", "I:WPEM": "Cboe Emerging Markets One-Week PutWrite Index", "I:WPTR": "Cboe Russell 2000 One-Week Putwrite Index", "I:WPUT": "Cboe S&P 500 One-Week PutWrite Index", "I:XABQ": "ABA NASDAQ Community Bank Total Return", "I:XAI": "EXANTE Altcoin Cryptocurrency Index", "I:XAU": "PHLX Gold/Silver Sector", "I:XCLRIV": "Global X S&P 500 Collar 95-110 ETF Intraday Indicative Value", "I:XCMP": "NASDAQ Composite Total Return", "I:XCMPCAD": "NASDAQ Composite Total Return CAD", "I:XCMPCADMH": "NASDAQ Composite Monthly Currency Hedged CAD TR", "I:XCMPCADNNR": "NASDAQ Composite Net Total Return CAD", "I:XCMPCADNNRMH": "NASDAQ Composite Monthly Currency Hedged CAD NTR", "I:XCMPNNR": "NASDAQ Composite Net Total Return", "I:XDA": "PHLX Australian Dollar", "I:XDB": "PHLX British Pound", "I:XDC": "PHLX Canadian Dollar", "I:XDE": "PHLX Euro", "I:XDN": "PHLX Yen", "I:XDS": "PHLX Swiss Franc", "I:XDZ": "PHLX New Zealand Dollar", "I:XEO": "S&P 100 options with European-style exercise", "I:XHGX": "PHLX Housing Sector Total Return", "I:XLHK": "Dow Jones Hong Kong Titans 30 Index (HKD)", "I:XLM2KRP": "Cboe 2000 Stellar / US Dollar RealPrice Index", "I:XLM500RP": "Cboe 500 Stellar / US Dollar RealPrice Index", "I:XLM9KRP": "Cboe 9000 Stellar / US Dollar RealPrice Index", "I:XNBI": "NASDAQ Biotechnology Total Return", "I:XNBIJPY": "NASDAQ Biotechnology Total Return JPY", "I:XNBIJR": "Nasdaq Junior Biotechnology TR Index", "I:XNBIJRNR": "Nasdaq Junior Biotechnology NTR Index", "I:XNBINNR": "NASDAQ Biotechnology NTR", "I:XNBINNRJPY": "NASDAQ Biotechnology NTR JPY", "I:XND": "Nasdaq-100 Micro Index", "I:XNDX": "NASDAQ-100 Total Return", "I:XNDX2D": "Nasdaq 100 Total Return 2% Decrement Index", "I:XNDX5E": "Nasdaq 100 5% Target Volatility Index", "I:XNDXAUD": "Nasdaq-100 Total Return Index AUD", "I:XNDXAUDMH": "Nasdaq-100 Currency Hedged AUD TR Index", "I:XNDXCAD": "Nasdaq-100 Total Return Index CAD", "I:XNDXCHF": "Nasdaq-100 Total Return Index CHF", "I:XNDXCHFMH": "XNDXCHF Monthly Currency Hedged", "I:XNDXEUR": "Nasdaq-100 Total Return Index EUR", "I:XNDXEURMH": "XNDXEUR Monthly Currency Hedged", "I:XNDXGBP": "Nasdaq-100 Total Return Index GBP", "I:XNDXGBPMH": "XNDXGBP Monthly Currency Hedged", "I:XNDXHKD": "Nasdaq-100 Total Return Index HKD", "I:XNDXINR": "Nasdaq-100 Total Return INR", "I:XNDXJPY": "Nasdaq-100 Total Return Index JPY", "I:XNDXJPYMH": "NASDAQ -100 Currency Hedged JPY TR Index", "I:XNDXL": "NASDAQ-100 Leveraged Total Return Index", "I:XNDXL3TR": "NASDAQ-100 3x Leveraged Total Return Index", "I:XNDXNNR": "NASDAQ-100 Notional Net Total Return Index", "I:XNDXNNRAUD": "Nasdaq-100 Notional Net Return Index AUD", "I:XNDXNNRAUDMH": "Nasdaq-100 Currency Hedged AUD NTR Index", "I:XNDXNNRCAD": "Nasdaq-100 Notional Net Return CAD", "I:XNDXNNRCHF": "Nasdaq-100 Notional Net Return CHF", "I:XNDXNNREUR": "Nasdaq-100 Notional Net Return EUR", "I:XNDXNNRGBP": "Nasdaq-100 Notional Net Return GBP", "I:XNDXNNRHKD": "Nasdaq-100 HKD Notional Net Total Return", "I:XNDXNNRINR": "Nasdaq-100 Notional Net Total Return INR", "I:XNDXNNRJPY": "Nasdaq-100 Notional Net Return Index JPY", "I:XNDXNNRJPYMH": "NASDAQ -100 Currency Hedged JPY NTR Index", "I:XNDXNNRL": "NASDAQ-100 Leveraged Notional Net Total Return", "I:XNDXNNRL3": "NASDAQ-100 3x Leveraged Notional Net Total Return", "I:XNDXNNRS3": "NASDAQ-100 3x Inverse Notional Net Total Return In", "I:XNDXS1": "NASDAQ-100 1x Short Total Return Index", "I:XNDXS1NNR": "NASDAQ-100 1x Short Net Total Return Index", "I:XNDXS2": "NASDAQ-100 2x Short Total Return Index", "I:XNDXS2NNR": "NASDAQ-100 2x Short Net Total Return Index", "I:XNDXS3": "NASDAQ-100 3x Inverse Total Return Index", "I:XNDXT25": "NASDAQ-100 Target 25 Total Return Index", "I:XNDXT25E": "NASDAQ-100 Target 25 Excess Return Index", "I:XNDXT25NNER": "NASDAQ-100 Target 25 Net Excess Return Index", "I:XNDXT25NNR": "NASDAQ-100 Target 25 Notional Net Return Index", "I:XNDXTRND": "NASDAQ-100 Trendpilot TR Index", "I:XNDXTRND1": "NASDAQ-100 Trendpilot TR Index 1", "I:XNDXTRNDNNR": "NASDAQ-100 Trendpilot NTR Index", "I:XNDXTRNDNNR1": "NASDAQ-100 Trendpilot NTR Index 1", "I:XOSX": "PHLX Oil Service Sector Total Return", "I:XPPIV": "PROSHARES ULTRA FTSE CHINA 50 ETF", "I:XRMIIV": "Global X S&P 500 Risk Managed Income ETF Intraday Indicative Value", "I:XRP100K": "Cboe 100K Ripple / US Dollar RealPrice Index", "I:XRP200K": "Cboe 200K Ripple / US Dollar RealPrice Index", "I:XRP25KRP": "Cboe 25K Ripple / US Dollar RealPrice Index", "I:XRP50KRP": "Cboe 50K Ripple / US Dollar RealPrice Index", "I:XRP5KRP": "Cboe 5000 Ripple / US Dollar RealPrice Index", "I:XRPLX": "Ripple XRP Liquid Index", "I:XSOX": "PHLX Semiconductor Sector Total Return", "I:XSP": "Mini Standard & Poor's 500", "I:XSPAM": "Mini SPX Index (AM Settlement)", "I:XSR": "S&P 500 Settlement Reduced", "I:XTRIV": "Global X S&P 500 Tail Risk ETF Intraday Indicative Value", "I:XTZ100RP": "Cboe 100 Tezos / US Dollar RealPrice Index", "I:XTZ200RP": "Cboe 200 Tezos / US Dollar RealPrice Index", "I:XTZ50RP": "Cboe 50 Tezos / US Dollar RealPrice Index", "I:XTZ5KRP": "Cboe 5000 Tezos / US Dollar RealPrice Index", "I:XTZ75RP": "Cboe 75 Tezos / US Dollar RealPrice Index", "I:XUTY": "PHLX Utility Sector Total Return", "I:XXAU": "PHLX Gold/Silver Sector Total Return", "I:XYLGIV": "Global X S&P 500 Covered Call & Growth ETF Intraday Indicative Value", "I:YCLIV": "PROSHARES ULTRA YEN ETF", "I:YCSIV": "PROSHARES ULTRASHORT YEN ETFYXIIV - PROSHARES SHORT FTSE CHINA 50 ETFZIVIV - VelocityShares Daily Inverse VIX Medium-Term ETN Intraday Indicative Value", "I:YLDA": "ISE High Income Index", "I:YLDANTR": "ISE High Income Net Total Return Index", "I:YLDATR": "ISE High Income Total Return Index", "I:ZADOW": "Dow Jones South Africa Index", "I:ZADOWD": "Dow Jones South Africa Index (USD)", "I:ZEC100RP": "Cboe 100 Zcash / US Dollar RealPrice Index", "I:ZEC10RP": "Cboe 10 Zcash / US Dollar RealPrice Index", "I:ZEC20RP": "Cboe 20 Zcash / US Dollar RealPrice Index", "I:ZEC50RP": "Cboe 50 Zcash / US Dollar RealPrice Index", "I:ZEC5RP": "Cboe 5 Zcash / US Dollar RealPrice Index", "I:ZRX10KRP": "Cboe 10K 0x / US Dollar RealPrice Index", "I:ZRX1KRP": "Cboe 1000 0x / US Dollar RealPrice Index", "I:ZRX200K": "Cboe 200K 0x / US Dollar RealPrice Index", "I:ZRX3KRP": "Cboe 3000 0x / US Dollar RealPrice Index", "I:ZSLIV": "PROSHARES ULTRASHORT SILVER ETF"}




CRYPTO_HOOKS={
    "1INCH-USD": os.environ.get("1INCH_USD"),
    "AAVE-USD": os.environ.get("AAVE_USD"),
    "ACH-USD": os.environ.get("ACH_USD"),
    "ADA-USD": os.environ.get("ADA_USD"),
    "ALCX-USD": os.environ.get("ALCX_USD"),
    "ALGO-USD": os.environ.get("ALGO_USD"),
    "ALICE-USD": os.environ.get("ALICE_USD"),
    "AMP-USD": os.environ.get("AMP_USD"),
    "ANKR-USD": os.environ.get("ANKR_USD"),
    "ANT-USD": os.environ.get("ANT_USD"),
    "APE-USD": os.environ.get("APE_USD"),
    "API3-USD": os.environ.get("API3_USD"),
    "ARPA-USD": os.environ.get("ARPA_USD"),
    "ASM-USD": os.environ.get("ASM_USD"),
    "ATOM-USD": os.environ.get("ATOM_USD"),
    "AUCTION-USD": os.environ.get("AUCTION_USD"),
    "AVAX-USD": os.environ.get("AVAX_USD"),
    "AVT-USD": os.environ.get("AVT_USD"),
    "AXS-USD": os.environ.get("AXS_USD"),
    "BADGER-USD": os.environ.get("BADGER_USD"),
    "BAL-USD": os.environ.get("BAL_USD"),
    "BAND-USD": os.environ.get("BAND_USD"),
    "BAT-USD": os.environ.get("BAT_USD"),
    "BCH-EUR": os.environ.get("BCH_EUR"),
    "BCH-GBP": os.environ.get("BCH_GBP"),
    "BCH-USD": os.environ.get("BCH_USD"),
    "BNT-USD": os.environ.get("BNT_USD"),
    "BOBA-USD": os.environ.get("BOBA_USD"),
    "BOND-USD": os.environ.get("BOND_USD"),
    "BOSON-USD": os.environ.get("BOSON_USD"),
    "BTC-AUD": os.environ.get("BTC_AUD"),
    "BTC-EUR": os.environ.get("BTC_EUR"),
    "BTC-GBP": os.environ.get("BTC_GBP"),
    "BTC-JPY": os.environ.get("BTC_JPY"),
    "BTC-USD": os.environ.get("BTC_USD"),
    "BTRST-USD": os.environ.get("BTRST_USD"),
    "BTSE-USD": os.environ.get("BTSE_USD"),
    "BTT-USD": os.environ.get("BTT_USD"),
    "C98-USD": os.environ.get("C98_USD"),
    "CGLD-USD": os.environ.get("CGLD_USD"),
    "CHSB-USD": os.environ.get("CHSB_USD"),
    "CHZ-USD": os.environ.get("CHZ_USD"),
    "CLO-USD": os.environ.get("CLO_USD"),
    "CLV-USD": os.environ.get("CLV_USD"),
    "COMP-USD": os.environ.get("COMP_USD"),
    "COTI-USD": os.environ.get("COTI_USD"),
    "COVAL-USD": os.environ.get("COVAL_USD"),
    "CRO-USD": os.environ.get("CRO_USD"),
    "CRPT-USD": os.environ.get("CRPT_USD"),
    "CRV-USD": os.environ.get("CRV_USD"),
    "CTSI-USD": os.environ.get("CTSI_USD"),
    "CVC-USD": os.environ.get("CVC_USD"),
    "CVX-USD": os.environ.get("CVX_USD"),
    "DAI-USD": os.environ.get("DAI_USD"),
    "DASH-USD": os.environ.get("DASH_USD"),
    "DGB-USD": os.environ.get("DGB_USD"),
    "DNT-USD": os.environ.get("DNT_USD"),
    "DOGE-USD": os.environ.get("DOGE_USD"),
    "DOT-USD": os.environ.get("DOT_USD"),
    "DSH-USD": os.environ.get("DSH_USD"),
    "DUSK-USD": os.environ.get("DUSK_USD"),
    "DVF-USD": os.environ.get("DVF_USD"),
    "DYDX-USD": os.environ.get("DYDX_USD"),
    "EGLD-USD": os.environ.get("EGLD_USD"),
    "ENJ-USD": os.environ.get("ENJ_USD"),
    "EOS-USD": os.environ.get("EOS_USD"),
    "FARM-USD": os.environ.get("FARM_USD"),
    "FET-USD": os.environ.get("FET_USD"),
    "FIS-USD": os.environ.get("FIS_USD"),
    "FTM-USD": os.environ.get('FTM_USD'),
    "FCL-USD": os.environ.get('FCL_USD'),
    "FIL-USD": os.environ.get('FIL_USD'),
    "GALA-USD": os.environ.get('GALA_USD'),
    "GTC-USD": os.environ.get('GTC_USD'),
    "GRT-USD": os.environ.get('GRT_USD'),
    "HMT-USD": os.environ.get('HMT_USD'),
    "ICP-USD": os.environ.get('ICP_USD'),
    "IMX-USD": os.environ.get('IMX_USD'),
    "INJ-USD": os.environ.get('INJ_USD'),
    "IOTX-USD": os.environ.get('IOTX_USD'),
    "ELA-USD": os.environ.get('ELA_USD'),
    "ETC-USD": os.environ.get('ETC_USD'),
    "ETH-AUD": os.environ.get('ETH_AUD'),
    "ETH-USD": os.environ.get('ETH_USD'),
    "ETH-BTC": os.environ.get('ETH_BTC'),
    "HBAR-USD": os.environ.get('HBAR_USD'),
    'JASMY-USD': os.environ.get('JASMY_USD'),
    'JST-USD': os.environ.get('JST_USD'),
    'KAVA-USD': os.environ.get('KAVA_USD'),
    'KEEP-USD': os.environ.get('KEEP_USD'),
    'KNC-USD': os.environ.get('KNC_USD'),
    'KRL-USD': os.environ.get('KRL_USD'),
    'KSM-USD': os.environ.get('KSM_USD'),
    'LINK-USD': os.environ.get('LINK_USD'),
    'LRC-USD': os.environ.get('LRC_USD'),
    'LUNA-USD': os.environ.get('LUNA_USD'),
    'LTC-AUD': os.environ.get('LTC_AUD'),
    'LTC-USD': os.environ.get('LTC_USD'),
    'LTC-EUR': os.environ.get('LTC_EUR'),
    'LSK-USD': os.environ.get('LSK_USD'),
    'LYM-USD': os.environ.get('LYM_USD'),
    'MANA-USD': os.environ.get('MANA_USD'),
    'MASK-USD': os.environ.get('MASK_USD'),
    'MATIC-USD': os.environ.get('MATIC_USD'),
    'MIR-USD': os.environ.get('MIR_USD'),
    'MKR-USD': os.environ.get('MKR_USD'),
    'MLN-USD': os.environ.get('MLN_USD'),
    'MNA-USD': os.environ.get('MNA_USD'),
    'MOB-USD': os.environ.get('MOB_USD'),
    'NEAR-USD': os.environ.get('NEAR_USD'),
    'NMR-USD': os.environ.get('NMR_USD'),
    'NKN-USD': os.environ.get('NKN_USD'),
    'OCEAN-USD': os.environ.get('OCEAN_USD'),
    'OGN-USD': os.environ.get('OGN_USD'),
    'OXT-USD': os.environ.get('OXT_USD'),
    'PLANETS-USD': os.environ.get('PLANETS_USD'),
    'POLY-USD': os.environ.get('POLY_USD'),
    'QNT-USD': os.environ.get('QNT_USD'),
    'QTF-USD': os.environ.get('QTF_USD'),
    'QRDO-USD': os.environ.get('QRDO_USD'),
    'RAI-USD': os.environ.get('RAI_USD'),
    'REC-USD': os.environ.get('REC_USD'),
    'REQ-USD': os.environ.get('REQ_USD'),
    'RLC-USD': os.environ.get('RLC_USD'),
    'RNDR-USD': os.environ.get('RNDR_USD'),
    'ROSE-USD': os.environ.get('ROSE_USD'),
    'SGB-USD': os.environ.get('SGB_USD'),
    'SHIB-USD': os.environ.get('SHIB_USD'),
    'SOL-USD': os.environ.get('SOL_USD'),
    'SNX-USD': os.environ.get('SNX_USD'),
    'SPELL-USD': os.environ.get('SPELL_USD'),
    'STORJ-USD': os.environ.get('STORJ_USD'),
    'SUKU-USD': os.environ.get('SUKU_USD'),
    'SUSHI-USD': os.environ.get('SUSHI_USD'),
    'SWFTC-USD': os.environ.get('SWFTC_USD'),
    'STX-USD': os.environ.get('STX_USD'),
    'TRB-USD': os.environ.get('TRB_USD'),
    'TRU-USD': os.environ.get('TRU_USD'),
    'TRX-USD': os.environ.get('TRX_USD'),
    'UDC-USD': os.environ.get('UDC_USD'),
    'UOS-USD': os.environ.get('UOS_USD'),
    'UTK-USD': os.environ.get('UTK_USD'),
    'UNI-USD': os.environ.get('UNI_USD'),
    'USDT-USD': os.environ.get('USDT_USD'),
    'UST-USD': os.environ.get('UST_USD'),
    'VET-USD': os.environ.get('VET_USD'),
    'XAUT-USD': os.environ.get('XAUT_USD'),
    'XMR-USD': os.environ.get('XMR_USD'),
    'XRP-USD': os.environ.get('XRP_USD'),
    'XYO-USD': os.environ.get('XYO_USD'),
    'XLM-USD': os.environ.get('XLM_USD'),
    'XTZ-USD': os.environ.get('XTZ_USD'),
    'ZIL-USD': os.environ.get('ZIL_USD'),
    'ZEC-USD': os.environ.get('ZEC_USD'),
    'ZRX-USD': os.environ.get('ZRX_USD')}


CRYPTO_DESCRIPTIONS={
    '1INCH-USD': '1inch is a decentralized exchange aggregator that sources liquidity from various exchanges to provide the best possible trading rates for users.',
    'AAVE-USD': 'Aave is a decentralized finance (DeFi) protocol that allows users to lend, borrow, and earn interest on cryptocurrency assets.',
    'ACH-USD': 'Alchemy Pay (ACH) is a cryptocurrency payment and financial solution platform that aims to enable crypto payments for merchants and businesses.',
    'ADA-USD': 'Cardano (ADA) is a blockchain platform that aims to provide a secure and scalable infrastructure for the development of smart contracts and decentralized applications (DApps).',
    'ALCX-USD': 'Alchemix (ALCX) is a DeFi platform that offers synthetic assets backed by collateral, allowing users to create self-repaying loans.',
    'ALGO-USD': 'Algorand (ALGO) is a blockchain platform that focuses on speed and efficiency, designed for applications that require high-performance consensus algorithms.',
    'ALICE-USD': 'MyNeighborAlice (ALICE) is a blockchain-based multiplayer builder game that combines elements of virtual reality and decentralized finance.',
    'AMP-USD': 'Amp (AMP) is a digital collateral token used to secure and facilitate instant, verifiable transactions on the Flexa payment network.',
    'ANKR-USD': 'Ankr (ANKR) is a platform that aims to make blockchain infrastructure accessible and easy to use for developers and businesses.',
    'ANT-USD': 'Aragon (ANT) is a decentralized autonomous organization (DAO) platform that enables the creation and management of decentralized organizations.',
    'APE-USD': 'APE Token (APE) is a cryptocurrency used in various DeFi applications and decentralized exchanges.',
    'API3-USD': 'API3 (API3) is a decentralized oracle network that aims to provide accurate and secure data feeds for blockchain smart contracts.',
    'ARPA-USD': 'ARPA Chain (ARPA) is a privacy-preserving blockchain platform that enables secure data sharing and confidential computing.',
    'ASM-USD': 'Assemble Protocol (ASM) is a blockchain project that focuses on the tokenization of real-world assets and decentralized finance.',
    'ATOM-USD': 'Cosmos (ATOM) is a blockchain platform designed for interoperability between different blockchains, enabling them to communicate and share data.',
    'AUCTION-USD': 'Auction (AUCTION) is a cryptocurrency used in decentralized finance platforms and applications.',
    'AVAX-USD': 'Avalanche (AVAX) is a blockchain platform known for its high performance and customizable blockchain networks.',
    'AVT-USD': 'Aventus (AVT) is a blockchain-based event ticketing and data platform that aims to eliminate fraud and scalping in the ticketing industry.',
    'AXS-USD': 'Axie Infinity (AXS) is a blockchain-based game that allows players to collect, breed, and battle fantasy creatures called "Axies."',
    'BADGER-USD': 'Badger DAO (BADGER) is a DeFi platform that focuses on bringing Bitcoin to the Ethereum ecosystem through various products and strategies.',
    'BAL-USD': 'Balancer (BAL) is an automated portfolio manager and liquidity provision platform on Ethereum, allowing users to create and manage token pools.',
    'BAND-USD': 'Band Protocol (BAND) is a decentralized oracle network that provides secure and reliable data feeds for smart contracts on various blockchains.',
    'BAT-USD': 'Basic Attention Token (BAT) is the native cryptocurrency of the Brave browser, designed to reward users for their attention and enable micropayments for content creators.',
    'BCH-EUR': 'Bitcoin Cash (BCH) is a cryptocurrency that focuses on fast and low-cost peer-to-peer transactions, serving as an alternative to traditional payment systems.',
    'BCH-GBP': 'Bitcoin Cash (BCH) is a cryptocurrency that aims to provide a scalable and efficient payment solution for global users.',
    'BCH-USD': 'Bitcoin Cash (BCH) is a cryptocurrency that offers fast and low-cost transactions, making it suitable for daily use and online payments.',
    'BNT-USD': 'Bancor (BNT) is a decentralized liquidity protocol that enables users to swap between different tokens directly from their wallets.',
    'BOBA-USD': 'Bobacoin (BOBA) is a cryptocurrency used in various blockchain applications and platforms.',
    'BOND-USD': 'BarnBridge (BOND) is a DeFi platform that offers tokenized risk and yield management strategies for stablecoin assets.',
    'BOSON-USD': 'Boson Protocol (BOSON) is a decentralized commerce platform that leverages NFTs and blockchain technology to enable tokenized commerce.',
    'BTC-AUD': 'Bitcoin (BTC) is the first and most well-known cryptocurrency, designed as a digital store of value and medium of exchange.',
    'BTC-EUR': 'Bitcoin (BTC) is a decentralized digital currency that aims to provide a secure and borderless means of transferring value.',
    'BTC-GBP': 'Bitcoin (BTC) is a decentralized cryptocurrency that serves as a digital store of value and is often used for online and offline transactions.',
    'BTC-JPY': 'Bitcoin (BTC) is a digital currency that aims to provide a secure and censorship-resistant form of money and value transfer.',
    'BTC-USD': 'Bitcoin (BTC) is the original cryptocurrency, created as a decentralized and digital alternative to traditional fiat currencies.',
    'BTRST-USD': 'BTRST (BTRST) is a cryptocurrency used in DeFi applications and platforms.',
    'BTSE-USD': 'BTSE (BTSE) is a cryptocurrency exchange platform that offers various trading pairs and services for digital asset trading.',
    'BTT-USD': 'BitTorrent (BTT) is a cryptocurrency token that aims to incentivize and facilitate the sharing of content on the BitTorrent network.',
    'C98-USD': 'Crypto.com Coin (CRO) is the native cryptocurrency of the Crypto.com ecosystem, offering various services such as payments and trading.',
    'CGLD-USD': 'Celo Dollar (cUSD) is a stablecoin on the Celo blockchain, designed for easy use in digital payments and DeFi applications.',
    'CHSB-USD': 'SwissBorg (CHSB) is a cryptocurrency project that offers wealth management services and a crypto investment app.',
    'CHZ-USD': 'Chiliz (CHZ) is a blockchain platform that focuses on sports and entertainment, enabling fan engagement through tokenized assets and voting.',
    'CLO-USD': 'Callisto Network (CLO) is a cryptocurrency that aims to provide smart contract security and auditing services on the Ethereum network.',
    'CLV-USD': 'Clover Finance (CLV) is a DeFi platform that aims to bring cross-chain compatibility and liquidity to the blockchain ecosystem.',
    'COMP-USD': 'Compound (COMP) is a decentralized lending and borrowing protocol that allows users to earn interest on their cryptocurrency assets.',
    'COTI-USD': 'COTI (COTI) is a blockchain platform that focuses on creating a digital payment ecosystem with scalable and low-cost transactions.',
    'COVAL-USD': 'Circuits of Value (COVAL) is a cryptocurrency used in blockchain-based applications and platforms.',
    'CRO-USD': 'Crypto.com Coin (CRO) is a cryptocurrency used in various services offered by Crypto.com, including payments and trading.',
    'CRPT-USD': 'Crypterium (CRPT) is a cryptocurrency and payment platform that aims to make digital currencies accessible for everyday use.',
    'CRV-USD': 'Curve DAO (CRV) is a decentralized exchange and stablecoin platform that offers low-slippage trading and low fees for stablecoin swaps.',
    'CTSI-USD': 'Cartesi (CTSI) is a blockchain platform that aims to enable smart contracts to run off-chain, improving scalability and functionality.',
    'CVC-USD': 'Civic (CVC) is a blockchain-based identity verification platform that enables secure and privacy-preserving identity verification.',
    'CVX-USD': 'Convex Finance (CVX) is a DeFi platform that focuses on optimizing yield farming strategies for stablecoins.',
    'DAI-USD': 'Dai (DAI) is a stablecoin on the Ethereum blockchain that is collateralized by a variety of cryptocurrencies and aims to maintain a stable value.',
    'DASH-USD': 'Dash (DASH) is a cryptocurrency that focuses on fast and low-cost transactions, making it suitable for both digital payments and remittances.',
    'DGB-USD': 'DigiByte (DGB) is a blockchain platform that emphasizes security, speed, and decentralization, with a focus on secure digital payments.',
    'DNT-USD': 'district0x (DNT) is a network of decentralized marketplaces and communities that allows users to create and govern their own platforms.',
    'DOGE-USD': 'Dogecoin (DOGE) is a cryptocurrency that started as a meme but has gained popularity as a digital currency used for tipping and microtransactions.',
    'DOT-USD': 'Polkadot (DOT) is a multi-chain blockchain platform that aims to enable interoperability and scalability between different blockchains.',
    'DSH-USD': 'Dash (DASH) is a cryptocurrency known for its fast and low-cost transactions, designed for use in everyday digital payments.',
    'DUSK-USD': 'Dusk Network (DUSK) is a blockchain platform that focuses on privacy and confidentiality for blockchain transactions and smart contracts.',
    'DVF-USD': 'Davinci Coin (DVF) is a cryptocurrency used in blockchain-based applications and services.',
    'DYDX-USD': 'dYdX (DYDX) is a decentralized exchange and DeFi platform that offers margin trading, lending, and borrowing of cryptocurrencies.',
    'EGLD-USD': 'Elrond (EGLD) is a blockchain platform that aims to provide high throughput, security, and scalability for decentralized applications.',
    'ELA-USD': 'Elastos (ELA) is a blockchain-based operating system that aims to create a secure and decentralized internet.',
    'ENJ-USD': 'Enjin Coin (ENJ) is a cryptocurrency and platform that focuses on creating and managing blockchain-based virtual goods and assets for gaming.',
    'EOS-USD': 'EOS (EOS) is a blockchain platform that aims to provide high-performance smart contract capabilities and decentralized application hosting.',
    'ETC-USD': 'Ethereum Classic (ETC) is a blockchain that maintains the original Ethereum network after a contentious hard fork.',
    'ETH-AUD': 'Ethereum (ETH) is a blockchain platform known for smart contracts and decentralized applications, designed to enable programmable and trustless applications.',
    'ETH-BTC': 'Ethereum (ETH) is a blockchain platform that enables smart contracts and decentralized applications, aiming to create a more open and inclusive internet.',
    'ETH-USD': 'Ethereum (ETH) is a decentralized blockchain platform known for its smart contract capabilities and support for decentralized applications.',
    'FARM-USD': 'Harvest Finance (FARM) is a DeFi platform that offers yield farming and automated portfolio management services for cryptocurrency assets.',
    'FCL-USD': 'Fractal (FCL) is a cryptocurrency and platform that aims to create a decentralized marketplace for fractional ownership of assets.',
    'FET-USD': 'Fetch.ai (FET) is a blockchain platform that focuses on autonomous agents and artificial intelligence for decentralized applications.',
    'FIL-USD': 'Filecoin (FIL) is a decentralized storage network that enables users to rent out their storage space and earn cryptocurrency rewards.',
    'FIS-USD': 'StaFi (FIS) is a DeFi platform that offers liquid staking solutions, allowing users to stake and trade staked assets.',
    'FLOW-USD': 'Flow (FLOW) is a blockchain platform designed for digital collectibles, games, and decentralized applications.',
    'FORTH-USD': 'Ampleforth (FORTH) is a cryptocurrency that aims to create a stablecoin with a dynamic supply that adjusts based on market demand.',
    'FOX-USD': 'Shapeshift (FOX) is the native cryptocurrency of the Shapeshift exchange platform, which offers cryptocurrency trading and services.',
    'FTM-USD': 'Fantom (FTM) is a blockchain platform that focuses on scalability and speed for decentralized applications and smart contracts.',
    'FUN-USD': 'FunFair (FUN) is a blockchain-based platform that aims to provide fair and transparent online casino gaming experiences.',
    'FX-USD': 'Function X (FX) is a blockchain platform that aims to enable decentralized internet and communication services.',
    'GALA-USD': 'Gala (GALA) is the native cryptocurrency of the Gala Games ecosystem, which includes blockchain-based games and virtual worlds.',
    'GHST-USD': 'Aavegotchi (GHST) is a blockchain-based game that combines elements of decentralized finance and non-fungible tokens (NFTs).',
    'GLM-USD': 'Golem (GLM) is a decentralized marketplace for computing power, allowing users to rent out their idle computer resources.',
    'GNO-USD': 'Gnosis (GNO) is a decentralized prediction market platform that allows users to create and participate in prediction markets.',
    'GRT-USD': 'The Graph (GRT) is a decentralized indexing protocol that enables efficient and fast queries of blockchain data for developers.',
    'GTC-USD': 'Gitcoin (GTC) is a cryptocurrency used in the Gitcoin platform, which supports open-source software development and funding.',
    'GUSD-USD': 'Gemini Dollar (GUSD) is a stablecoin that is fully backed by US dollars held in reserve and is designed for easy use in digital transactions.',
    'GYEN-USD': 'GYEN is a digital currency pegged to the Japanese yen, aiming to provide a stable and efficient means of transferring value.',
    'HBAR-USD': 'Hedera Hashgraph (HBAR) is a distributed ledger technology platform known for its high throughput and security features.',
    'HMT-USD': 'Hedget (HMT) is a cryptocurrency used in the Hedget platform, which offers decentralized options trading and risk management.',
    'ICE-USD': 'iCEX (ICE) is a cryptocurrency used in the iCEX exchange platform, which offers various trading pairs and services for digital assets.',
    'ICP-USD': 'Internet Computer (ICP) is a blockchain platform that aims to create a decentralized and internet-scale computing environment.',
    'ICX-USD': 'ICON (ICX) is a blockchain platform that focuses on interoperability between different blockchains and creating a decentralized ecosystem.',
    'IMX-USD': 'Immutable X (IMX) is a Layer-2 scaling solution for NFTs on the Ethereum blockchain, offering fast and gas-free trading of NFTs.',
    'INJ-USD': 'Injective Protocol (INJ) is a decentralized derivatives exchange that enables users to trade a wide range of assets with minimal fees.',
    'IOT-USD': 'IOTA (IOT) is a blockchain platform that focuses on the Internet of Things (IoT) and aims to provide a scalable and feeless network for IoT devices.',
    'IOTX-USD': 'IoTeX (IOTX) is a blockchain platform designed for the Internet of Things (IoT), offering privacy and scalability for IoT data.',
    'JASMY-USD': 'JasmyCoin (JASMY) is a cryptocurrency used in various blockchain applications and platforms.',
    'JST-USD': 'JUST (JST) is a cryptocurrency used in the TRON ecosystem, offering various DeFi services and stablecoins.',
    'KAVA-USD': 'Kava (KAVA) is a DeFi platform that offers lending, borrowing, and stablecoin issuance on various blockchain networks.',
    'KEEP-USD': 'Keep3rV1 (KP3R) is a cryptocurrency used in the Keep3r network, which provides infrastructure services for DeFi applications.',
    'KNC-USD': 'Kyber Network (KNC) is a decentralized liquidity protocol that allows users to swap between different tokens directly from their wallets.',
    'KRL-USD': 'Kryll (KRL) is a cryptocurrency used in the Kryll trading platform, which offers automated trading strategies and tools for traders.',
    'KSM-USD': 'Kusama (KSM) is a blockchain platform that serves as a testing ground for new features and technologies before they are deployed on Polkadot.',
    'LCX-USD': 'LCX (LCX) is a cryptocurrency used in the LCX exchange platform, which offers various trading pairs and services for digital assets.',
    'LINK-USD': 'Chainlink (LINK) is a decentralized oracle network that provides secure and reliable data feeds for smart contracts on various blockchains.',
    'LPT-USD': 'Livepeer (LPT) is a blockchain platform that focuses on decentralized video streaming and transcoding services.',
    'LRC-USD': 'Loopring (LRC) is a Layer-2 scaling solution for Ethereum that aims to provide fast and low-cost decentralized exchanges.',
    'LSK-USD': 'Lisk (LSK) is a blockchain platform that aims to make blockchain development more accessible and user-friendly for developers.',
    'LTC-AUD': 'Litecoin (LTC) is a cryptocurrency that aims to provide fast and low-cost peer-to-peer transactions, often considered "silver" to Bitcoins "gold."',
    'LTC-BTC': 'Litecoin (LTC) is a cryptocurrency that offers fast and low-cost transactions, often used for digital payments and remittances.',
    'LTC-EUR': 'Litecoin (LTC) is a cryptocurrency known for its speed and low transaction fees, making it suitable for various digital payments.',
    'LTC-USD': 'Litecoin (LTC) is a cryptocurrency designed for fast and low-cost peer-to-peer transactions, serving as a digital alternative to fiat currencies.',
    'LUNA-USD': 'Terra (LUNA) is a blockchain platform that aims to provide stable digital currencies and enable cross-border payments.',
    'LYM-USD': 'Lympo (LYM) is a blockchain platform that focuses on health and fitness, rewarding users for healthy activities and data sharing.',
    'MANA-USD': 'Decentraland (MANA) is a virtual reality platform built on the Ethereum blockchain, allowing users to create, buy, and sell virtual real estate.',
    'MASK-USD': 'Mask Network (MASK) is a DeFi platform that offers privacy-focused tools and features for social media and web3 applications.',
    'MATIC-USD': 'Polygon (MATIC) is a Layer-2 scaling solution for Ethereum that aims to provide fast and low-cost transactions for decentralized applications.',
    "MIR-USD": "Mirror Protocol (MIR) is a decentralized finance (DeFi) platform on the Terra blockchain that allows users to mint and trade synthetic assets that mimic real-world assets such as stocks and commodities.",
    "MKR-USD": "Maker (MKR) is a cryptocurrency and governance token of the MakerDAO platform, which is a decentralized autonomous organization that manages the stablecoin DAI.",
    "MLN-USD": "Enzyme (MLN), formerly known as Melon, is a blockchain-based asset management platform that enables users to create and manage investment funds using smart contracts.",
    "MNA-USD": "MANTRA DAO (MNA) is a DeFi platform that focuses on providing financial services, governance, and staking for the Polkadot and Kusama ecosystems.",
    "MOB-USD": "MobiePay (MOB) is a cryptocurrency and payment platform that aims to facilitate cryptocurrency payments and rewards for users and merchants.",
    "NEAR-USD": "NEAR Protocol (NEAR) is a blockchain platform that aims to provide scalability and usability for decentralized applications and smart contracts.",
    "OCEAN-USD": "Ocean Protocol (OCEAN) is a decentralized data exchange platform that enables users to share, buy, and sell data while preserving privacy and security.",
    "OXT-USD": "Orchid (OXT) is a cryptocurrency and privacy-focused network that aims to provide secure and private internet access through a decentralized VPN service.",
'PLANETS-USD': 'Planets (PLANETS) is a cryptocurrency, but a specific description is needed.',
    'POLY-USD': 'Polymath (POLY) is a security token platform that aims to simplify the legal and technical processes of creating and managing security tokens.',
    'QNT-USD': 'Quant (QNT) is a cryptocurrency that focuses on enabling interoperability between different blockchain networks and facilitating the development of decentralized applications.',
    'QTF-USD': 'A specific description for QTF-USD is needed.',
    'QRDO-USD': 'A specific description for QRDO-USD is needed.',
    'RAI-USD': 'A specific description for RAI-USD is needed.',
    'REC-USD': 'A specific description for REC-USD is needed.',
    'REQ-USD': 'A specific description for REQ-USD is needed.',
    'RLC-USD': 'iExec (RLC) is a blockchain-based marketplace for decentralized cloud computing resources and applications.',
    'RNDR-USD': 'Render Token (RNDR) is a cryptocurrency that powers a blockchain-based rendering network for 3D artists and animators.',
    'ROSE-USD': 'Oasis Network (ROSE) is a blockchain platform designed for privacy and scalability, aiming to empower decentralized applications.',
    'SGB-USD': 'A specific description for SGB-USD is needed.',
    'SHIB-USD': 'Shiba Inu (SHIB) is a meme-based cryptocurrency token inspired by the Shiba Inu dog breed.',
    'SOL-USD': 'Solana (SOL) is a high-performance blockchain platform known for its fast transaction speeds and decentralized applications (dApps) ecosystem.',
    'SNX-USD': 'Synthetix (SNX) is a decentralized platform that enables the creation and trading of synthetic assets on the Ethereum blockchain.',
    'SPELL-USD': 'A specific description for SPELL-USD is needed.',
    'STORJ-USD': 'Storj (STORJ) is a decentralized cloud storage platform that allows users to rent their excess hard drive space in exchange for cryptocurrency.',
    'SUKU-USD': 'SUKU (SUKU) is a blockchain-based supply chain and sustainability platform.',
    'SUSHI-USD': 'SushiSwap (SUSHI) is a decentralized exchange and automated market maker (AMM) on the Ethereum blockchain.',
    'SWFTC-USD': 'A specific description for SWFTC-USD is needed.',
    'STX-USD': 'Blockstack (STX) is a blockchain platform that enables the development of decentralized applications and smart contracts.',
    'TRB-USD': 'Tellor (TRB) is a decentralized oracle platform that provides data to smart contracts on the Ethereum blockchain.',
    'TRU-USD': 'A specific description for TRU-USD is needed.',
    'TRX-USD': 'TRON (TRX) is a blockchain platform known for its high throughput and decentralized applications (dApps).',
    'UDC-USD': 'A specific description for UDC-USD is needed.',
    'UOS-USD': 'Ultra (UOS) is a blockchain-based gaming platform that aims to revolutionize the gaming industry.',
    'UTK-USD': 'Utrust (UTK) is a cryptocurrency payment platform that enables secure and efficient online payments.',
    'UNI-USD': 'Uniswap (UNI) is a decentralized exchange protocol that facilitates automated token swaps on the Ethereum blockchain.',
    'USDT-USD': 'Tether (USDT) is a stablecoin cryptocurrency that is pegged to the value of a fiat currency, such as the US dollar.',
    'UST-USD': 'TerraUSD (UST) is a stablecoin cryptocurrency within the Terra blockchain ecosystem.',
    'VET-USD': 'VeChain (VET) is a blockchain platform that focuses on supply chain management and enterprise solutions.',
    'XAUT-USD': 'A specific description for XAUT-USD is needed.',
    'XMR-USD': 'Monero (XMR) is a privacy-focused cryptocurrency that provides enhanced anonymity for its users.',
    'XRP-USD': 'Ripple (XRP) is a cryptocurrency and payment protocol that aims to enable fast and low-cost cross-border transactions.',
    'XYO-USD': 'XYO (XYO) is a blockchain-based location data network that aims to provide accurate and verifiable location information.',
    'XLM-USD': 'Stellar (XLM) is a blockchain platform designed for cross-border payments and asset transfers.',
    'XTZ-USD': 'Tezos (XTZ) is a blockchain platform that focuses on smart contracts and decentralized applications.',
    'ZIL-USD': 'Zilliqa (ZIL) is a blockchain platform known for its high throughput and scalability features.',
    'ZEC-USD': 'Zcash (ZEC) is a privacy-focused cryptocurrency that offers optional shielded transactions for enhanced privacy.',
    'ZRX-USD': '0x (ZRX) is a decentralized exchange protocol that facilitates peer-to-peer trading of Ethereum-based tokens.'
}

