from ck.pgm import PGM


class Hepar2(PGM):
    """
    This PGM is the well known 'Hepar2' Bayesian network.
    """

    def __init__(self):
        super().__init__(self.__class__.__name__)

        pgm_rv0 = self.new_rv('alcoholism', ('present', 'absent'))
        pgm_rv1 = self.new_rv('vh_amn', ('present', 'absent'))
        pgm_rv2 = self.new_rv('hepatotoxic', ('present', 'absent'))
        pgm_rv3 = self.new_rv('THepatitis', ('present', 'absent'))
        pgm_rv4 = self.new_rv('hospital', ('present', 'absent'))
        pgm_rv5 = self.new_rv('surgery', ('present', 'absent'))
        pgm_rv6 = self.new_rv('gallstones', ('present', 'absent'))
        pgm_rv7 = self.new_rv('choledocholithotomy', ('present', 'absent'))
        pgm_rv8 = self.new_rv('injections', ('present', 'absent'))
        pgm_rv9 = self.new_rv('transfusion', ('present', 'absent'))
        pgm_rv10 = self.new_rv('ChHepatitis', ('active', 'persistent', 'absent'))
        pgm_rv11 = self.new_rv('sex', ('female', 'male'))
        pgm_rv12 = self.new_rv('age', ('age65_100', 'age51_65', 'age31_50', 'age0_30'))
        pgm_rv13 = self.new_rv('PBC', ('present', 'absent'))
        pgm_rv14 = self.new_rv('fibrosis', ('present', 'absent'))
        pgm_rv15 = self.new_rv('diabetes', ('present', 'absent'))
        pgm_rv16 = self.new_rv('obesity', ('present', 'absent'))
        pgm_rv17 = self.new_rv('Steatosis', ('present', 'absent'))
        pgm_rv18 = self.new_rv('Cirrhosis', ('decompensate', 'compensate', 'absent'))
        pgm_rv19 = self.new_rv('Hyperbilirubinemia', ('present', 'absent'))
        pgm_rv20 = self.new_rv('triglycerides', ('a17_4', 'a3_2', 'a1_0'))
        pgm_rv21 = self.new_rv('RHepatitis', ('present', 'absent'))
        pgm_rv22 = self.new_rv('fatigue', ('present', 'absent'))
        pgm_rv23 = self.new_rv('bilirubin', ('a88_20', 'a19_7', 'a6_2', 'a1_0'))
        pgm_rv24 = self.new_rv('itching', ('present', 'absent'))
        pgm_rv25 = self.new_rv('upper_pain', ('present', 'absent'))
        pgm_rv26 = self.new_rv('fat', ('present', 'absent'))
        pgm_rv27 = self.new_rv('pain_ruq', ('present', 'absent'))
        pgm_rv28 = self.new_rv('pressure_ruq', ('present', 'absent'))
        pgm_rv29 = self.new_rv('phosphatase', ('a4000_700', 'a699_240', 'a239_0'))
        pgm_rv30 = self.new_rv('skin', ('present', 'absent'))
        pgm_rv31 = self.new_rv('ama', ('present', 'absent'))
        pgm_rv32 = self.new_rv('le_cells', ('present', 'absent'))
        pgm_rv33 = self.new_rv('joints', ('present', 'absent'))
        pgm_rv34 = self.new_rv('pain', ('present', 'absent'))
        pgm_rv35 = self.new_rv('proteins', ('a10_6', 'a5_2'))
        pgm_rv36 = self.new_rv('edema', ('present', 'absent'))
        pgm_rv37 = self.new_rv('platelet', ('a597_300', 'a299_150', 'a149_100', 'a99_0'))
        pgm_rv38 = self.new_rv('inr', ('a200_110', 'a109_70', 'a69_0'))
        pgm_rv39 = self.new_rv('bleeding', ('present', 'absent'))
        pgm_rv40 = self.new_rv('flatulence', ('present', 'absent'))
        pgm_rv41 = self.new_rv('alcohol', ('present', 'absent'))
        pgm_rv42 = self.new_rv('encephalopathy', ('present', 'absent'))
        pgm_rv43 = self.new_rv('urea', ('a165_50', 'a49_40', 'a39_0'))
        pgm_rv44 = self.new_rv('ascites', ('present', 'absent'))
        pgm_rv45 = self.new_rv('hepatomegaly', ('present', 'absent'))
        pgm_rv46 = self.new_rv('hepatalgia', ('present', 'absent'))
        pgm_rv47 = self.new_rv('density', ('present', 'absent'))
        pgm_rv48 = self.new_rv('ESR', ('a200_50', 'a49_15', 'a14_0'))
        pgm_rv49 = self.new_rv('alt', ('a850_200', 'a199_100', 'a99_35', 'a34_0'))
        pgm_rv50 = self.new_rv('ast', ('a700_400', 'a399_150', 'a149_40', 'a39_0'))
        pgm_rv51 = self.new_rv('amylase', ('a1400_500', 'a499_300', 'a299_0'))
        pgm_rv52 = self.new_rv('ggtp', ('a640_70', 'a69_30', 'a29_10', 'a9_0'))
        pgm_rv53 = self.new_rv('cholesterol', ('a999_350', 'a349_240', 'a239_0'))
        pgm_rv54 = self.new_rv('hbsag', ('present', 'absent'))
        pgm_rv55 = self.new_rv('hbsag_anti', ('present', 'absent'))
        pgm_rv56 = self.new_rv('anorexia', ('present', 'absent'))
        pgm_rv57 = self.new_rv('nausea', ('present', 'absent'))
        pgm_rv58 = self.new_rv('spleen', ('present', 'absent'))
        pgm_rv59 = self.new_rv('consciousness', ('present', 'absent'))
        pgm_rv60 = self.new_rv('spiders', ('present', 'absent'))
        pgm_rv61 = self.new_rv('jaundice', ('present', 'absent'))
        pgm_rv62 = self.new_rv('albumin', ('a70_50', 'a49_30', 'a29_0'))
        pgm_rv63 = self.new_rv('edge', ('present', 'absent'))
        pgm_rv64 = self.new_rv('irregular_liver', ('present', 'absent'))
        pgm_rv65 = self.new_rv('hbc_anti', ('present', 'absent'))
        pgm_rv66 = self.new_rv('hcv_anti', ('present', 'absent'))
        pgm_rv67 = self.new_rv('palms', ('present', 'absent'))
        pgm_rv68 = self.new_rv('hbeag', ('present', 'absent'))
        pgm_rv69 = self.new_rv('carcinoma', ('present', 'absent'))

        pgm_factor0 = self.new_factor(pgm_rv0)
        pgm_function_2774976234256 = pgm_factor0.set_dense()
        pgm_function_2774976234256.set_flat(0.1359084, 0.8640916)
        pgm_factor1 = self.new_factor(pgm_rv1)
        pgm_function_2774976231296 = pgm_factor1.set_dense()
        pgm_function_2774976231296.set_flat(0.1731044, 0.8268956)
        pgm_factor2 = self.new_factor(pgm_rv2)
        pgm_function_2774976231616 = pgm_factor2.set_dense()
        pgm_function_2774976231616.set_flat(0.08154506, 0.91845494)
        pgm_factor3 = self.new_factor(pgm_rv3, pgm_rv2, pgm_rv0)
        pgm_function_2774976232176 = pgm_factor3.set_dense()
        pgm_function_2774976232176.set_flat(
            0.2, 0.00191939, 0.08888889, 0.0326087, 0.8, 0.99808061, 0.91111111,
            0.9673913)
        pgm_factor4 = self.new_factor(pgm_rv4)
        pgm_function_2774976231056 = pgm_factor4.set_dense()
        pgm_function_2774976231056.set_flat(0.5350501, 0.4649499)
        pgm_factor5 = self.new_factor(pgm_rv5)
        pgm_function_2774976233536 = pgm_factor5.set_dense()
        pgm_function_2774976233536.set_flat(0.4234621, 0.5765379)
        pgm_factor6 = self.new_factor(pgm_rv6)
        pgm_function_2774976232816 = pgm_factor6.set_dense()
        pgm_function_2774976232816.set_flat(0.1530758, 0.8469242)
        pgm_factor7 = self.new_factor(pgm_rv7, pgm_rv6)
        pgm_function_2774976232896 = pgm_factor7.set_dense()
        pgm_function_2774976232896.set_flat(0.7102804, 0.03716216, 0.2897196, 0.96283784)
        pgm_factor8 = self.new_factor(pgm_rv8, pgm_rv4, pgm_rv5, pgm_rv7)
        pgm_function_2774976230416 = pgm_factor8.set_dense()
        pgm_function_2774976230416.set_flat(
            0.8, 0.715847, 0.8333333, 0.4818182, 0.375, 0.2333333, 0.01098901,
            0.0647482, 0.2, 0.284153, 0.1666667, 0.5181818, 0.625, 0.7666667,
            0.98901099, 0.9352518)
        pgm_factor9 = self.new_factor(pgm_rv9, pgm_rv4, pgm_rv5, pgm_rv7)
        pgm_function_2774976232416 = pgm_factor9.set_dense()
        pgm_function_2774976232416.set_flat(
            0.3333333, 0.2896175, 0.1666667, 0.1181818, 0.125, 0.3, 0.01098901,
            0.01079137, 0.6666667, 0.7103825, 0.8333333, 0.8818182, 0.875, 0.7,
            0.98901099, 0.98920863)
        pgm_factor10 = self.new_factor(pgm_rv10, pgm_rv9, pgm_rv1, pgm_rv8)
        pgm_function_2774976231456 = pgm_factor10.set_dense()
        pgm_function_2774976231456.set_flat(
            0.2094241, 0.4615385, 0.06, 0.13043478, 0.15384615, 0.24, 0.07692308,
            0.13095238, 0.0052356, 0.3076923, 0.06, 0.04347826, 0.05128205, 0.14,
            0.00591716, 0.05357143, 0.7853403, 0.2307692, 0.88, 0.82608696, 0.7948718,
            0.62, 0.91715976, 0.81547619)
        pgm_factor11 = self.new_factor(pgm_rv11)
        pgm_function_2774976231136 = pgm_factor11.set_dense()
        pgm_function_2774976231136.set_flat(0.5979971, 0.4020029)
        pgm_factor12 = self.new_factor(pgm_rv12)
        pgm_function_2774976230896 = pgm_factor12.set_dense()
        pgm_function_2774976230896.set_flat(0.07725322, 0.38769671, 0.39771102, 0.13733906)
        pgm_factor13 = self.new_factor(pgm_rv13, pgm_rv11, pgm_rv12)
        pgm_function_2774976232576 = pgm_factor13.set_dense()
        pgm_function_2774976232576.set_flat(
            0.6571429, 0.700565, 0.6149425, 0.125, 0.3684211, 0.08510638, 0.06730769,
            0.00156006, 0.3428571, 0.299435, 0.3850575, 0.875, 0.6315789, 0.91489362,
            0.93269231, 0.99843994)
        pgm_factor14 = self.new_factor(pgm_rv14, pgm_rv10)
        pgm_function_2774976230576 = pgm_factor14.set_dense()
        pgm_function_2774976230576.set_flat(0.3, 0.05, 0.001, 0.7, 0.95, 0.999)
        pgm_factor15 = self.new_factor(pgm_rv15)
        pgm_function_2774976233136 = pgm_factor15.set_dense()
        pgm_function_2774976233136.set_flat(0.03576538, 0.96423462)
        pgm_factor16 = self.new_factor(pgm_rv16, pgm_rv15)
        pgm_function_2774976231216 = pgm_factor16.set_dense()
        pgm_function_2774976231216.set_flat(0.24, 0.06231454, 0.76, 0.93768546)
        pgm_factor17 = self.new_factor(pgm_rv17, pgm_rv16, pgm_rv0)
        pgm_function_2774976230496 = pgm_factor17.set_dense()
        pgm_function_2774976230496.set_flat(
            0.3636364, 0.1891892, 0.2380952, 0.06349206, 0.6363636, 0.8108108,
            0.7619048, 0.93650794)
        pgm_factor18 = self.new_factor(pgm_rv18, pgm_rv14, pgm_rv17)
        pgm_function_2774976233696 = pgm_factor18.set_dense()
        pgm_function_2774976233696.set_flat(0.56, 0.49, 0.35, 0.001, 0.24, 0.21, 0.15, 0.001, 0.2, 0.3, 0.5, 0.998)
        pgm_factor19 = self.new_factor(pgm_rv19, pgm_rv12, pgm_rv11)
        pgm_function_2774976233856 = pgm_factor19.set_dense()
        pgm_function_2774976233856.set_flat(
            0.002849, 0.0052356, 0.01129944, 0.0212766, 0.04597701, 0.07692308, 0.21875,
            0.453125, 0.997151, 0.9947644, 0.98870056, 0.9787234, 0.95402299,
            0.92307692, 0.78125, 0.546875)
        pgm_factor20 = self.new_factor(pgm_rv20, pgm_rv17)
        pgm_function_2774976234336 = pgm_factor20.set_dense()
        pgm_function_2774976234336.set_flat(0.1791045, 0.02373418, 0.1641791, 0.03164557, 0.6567164, 0.94462025)
        pgm_factor21 = self.new_factor(pgm_rv21, pgm_rv2)
        pgm_function_2774976231376 = pgm_factor21.set_dense()
        pgm_function_2774976231376.set_flat(0.01754386, 0.02492212, 0.98245614, 0.97507788)
        pgm_factor22 = self.new_factor(pgm_rv22, pgm_rv10, pgm_rv3, pgm_rv21)
        pgm_function_2774976232256 = pgm_factor22.set_dense()
        pgm_function_2774976232256.set_flat(
            0.6363636, 0.625, 0.6236559, 0.6043956, 0.6071429, 0.5932203, 0.5892857,
            0.5277778, 0.6153846, 0.6666667, 0.7058823, 0.5359848, 0.3636364, 0.375,
            0.3763441, 0.3956044, 0.3928571, 0.4067797, 0.4107143, 0.4722222, 0.3846154,
            0.3333333, 0.2941177, 0.4640151)
        pgm_factor23 = self.new_factor(pgm_rv23, pgm_rv19, pgm_rv13, pgm_rv18, pgm_rv6, pgm_rv10)
        pgm_function_2774976234096 = pgm_factor23.set_dense()
        pgm_function_2774976234096.set_flat(
            0.04347826, 0.07407407, 0.07894737, 0.01923077, 0.01818182, 0.02189781,
            0.03571429, 0.05882353, 0.07692308, 0.02020202, 0.01941748, 0.02362205,
            0.04225352, 0.06, 0.07575758, 0.03030303, 0.02158273, 0.02061856,
            0.01449275, 0.00398406, 0.00662252, 0.00151286, 0.00144718, 0.00114811,
            0.00311526, 0.00892857, 0.01388889, 0.00178253, 0.00174825, 0.00144509,
            0.00255102, 0.0049505, 0.07692308, 0.00146843, 0.00127877, 0.00181159,
            0.04081633, 0.06818182, 0.07692308, 0.03030303, 0.02173913, 0.02590674,
            0.04255319, 0.05084746, 0.07042254, 0.032, 0.0234375, 0.02824859,
            0.04477612, 0.05555556, 0.08536585, 0.03910615, 0.02926829, 0.03030303,
            0.02830189, 0.01818182, 0.01923077, 0.01449275, 0.01282051, 0.01886792,
            0.00321543, 0.00621118, 0.04545455, 0.01818182, 0.01694915, 0.03448276,
            0.00980392, 0.07692308, 0.01587302, 0.01234568, 0.00284091, 0.00070872,
            0.2173913, 0.22222222, 0.23684211, 0.11538462, 0.11818182, 0.12408759,
            0.16071429, 0.20588235, 0.23076923, 0.11111111, 0.10679612, 0.11811024,
            0.15492958, 0.2, 0.22727273, 0.12121212, 0.11510791, 0.12371134, 0.11594203,
            0.11952191, 0.13245033, 0.04538578, 0.04341534, 0.05740528, 0.03115265,
            0.00892857, 0.01388889, 0.01782531,
            0.00174825, 0.00144509, 0.00255102, 0.0049505, 0.07692308, 0.01468429,
            0.00127877, 0.00181159, 0.14285714, 0.20454545, 0.23076923, 0.14393939,
            0.13768116, 0.15025907, 0.17021277, 0.20338983, 0.22535211, 0.136,
            0.1328125, 0.14124294, 0.1641791, 0.19444444, 0.24390244, 0.15083799,
            0.14634146, 0.16666667, 0.16037736, 0.16363636, 0.19230769, 0.07246377,
            0.07692308, 0.13207547, 0.09646302, 0.0621118, 0.04545455, 0.01818182,
            0.01694915, 0.03448276, 0.00980392, 0.07692308, 0.01587302, 0.02469136,
            0.00284091, 0.02126152, 0.34782609, 0.33333333, 0.34210526, 0.36538462,
            0.38181818, 0.41605839, 0.39285714, 0.38235294, 0.35897436, 0.34343434,
            0.34951456, 0.37795276, 0.36619718, 0.36, 0.36363636, 0.35606061,
            0.37410072, 0.40721649, 0.39130435, 0.35856574, 0.26490066, 0.34795764,
            0.37626628, 0.44776119, 0.43613707, 0.44642857, 0.41666667, 0.28520499,
            0.2972028, 0.36127168, 0.33163265, 0.2970297, 0.07692308, 0.30837004,
            0.33248082, 0.54347827, 0.40816327, 0.36363636, 0.35384615, 0.34090909,
            0.35507246, 0.38341969, 0.37234043, 0.37288136, 0.36619718, 0.312, 0.3125,
            0.33898305, 0.34328358, 0.35185185, 0.36585366, 0.32960894, 0.33658537,
            0.38888889, 0.36792453, 0.34545455,
            0.01923077, 0.24637681, 0.26923077, 0.43396226, 0.41800643, 0.43478261,
            0.45454545, 0.14545455, 0.10169492, 0.10344828, 0.19607843, 0.07692308,
            0.01587302, 0.14814815, 0.05681818, 0.13465627, 0.39130435, 0.37037037,
            0.34210526, 0.5, 0.48181818, 0.4379562, 0.41071429, 0.35294118, 0.33333333,
            0.52525253, 0.52427184, 0.48031496, 0.43661972, 0.38, 0.33333333,
            0.49242424, 0.48920863, 0.44845361, 0.47826087, 0.51792829, 0.59602649,
            0.60514372, 0.5788712, 0.49368542, 0.52959502, 0.53571429, 0.55555555,
            0.69518717, 0.6993007, 0.63583814, 0.66326531, 0.6930693, 0.76923076,
            0.67547724, 0.66496164, 0.45289855, 0.40816327, 0.36363636, 0.33846154,
            0.48484848, 0.48550725, 0.44041451, 0.41489362, 0.37288136, 0.33802817,
            0.52, 0.53125, 0.49152542, 0.44776119, 0.39814815, 0.30487805, 0.48044693,
            0.48780488, 0.41414141, 0.44339623, 0.47272727, 0.76923077, 0.66666667,
            0.64102564, 0.41509434, 0.48231511, 0.49689441, 0.45454545, 0.81818181,
            0.86440678, 0.8275862, 0.78431373, 0.76923076, 0.95238094, 0.81481481,
            0.9375, 0.84337349)
        pgm_factor24 = self.new_factor(pgm_rv24, pgm_rv23)
        pgm_function_2774976231536 = pgm_factor24.set_dense()
        pgm_function_2774976231536.set_flat(
            0.875, 0.6865672, 0.5477387, 0.3333333, 0.125, 0.3134328, 0.4522613,
            0.6666667)
        pgm_factor25 = self.new_factor(pgm_rv25, pgm_rv6)
        pgm_function_2774976232336 = pgm_factor25.set_dense()
        pgm_function_2774976232336.set_flat(0.411215, 0.3868243, 0.5887851, 0.6131757)
        pgm_factor26 = self.new_factor(pgm_rv26, pgm_rv6)
        pgm_function_2774976232496 = pgm_factor26.set_dense()
        pgm_function_2774976232496.set_flat(0.1775701, 0.2804054, 0.8224299, 0.7195946)
        pgm_factor27 = self.new_factor(pgm_rv27, pgm_rv17, pgm_rv19)
        pgm_function_2774976230736 = pgm_factor27.set_dense()
        pgm_function_2774976230736.set_flat(
            0.3934426, 0.4776119, 0.2857143, 0.421875, 0.6065574, 0.5223881, 0.7142857,
            0.578125)
        pgm_factor28 = self.new_factor(pgm_rv28, pgm_rv6, pgm_rv13, pgm_rv10)
        pgm_function_2774976233216 = pgm_factor28.set_dense()
        pgm_function_2774976233216.set_flat(
            0.3333333, 0.328125, 0.3292683, 0.4, 0.09090909, 0.2857143, 0.3424658,
            0.3227513, 0.2929293, 0.4691358, 0.4285714, 0.4532374, 0.6666667, 0.671875,
            0.6707317, 0.6, 0.90909091, 0.7142857, 0.6575342, 0.6772487, 0.7070707,
            0.5308642, 0.5714286, 0.5467626)
        pgm_factor29 = self.new_factor(pgm_rv29, pgm_rv21, pgm_rv3, pgm_rv18, pgm_rv10)
        pgm_function_2774976234176 = pgm_factor29.set_dense()
        pgm_function_2774976234176.set_flat(
            0.04166667, 0.04347826, 0.04166667, 0.03773585, 0.025, 0.02702703,
            0.03571429, 0.02272727, 0.02325581, 0.02898551, 0.03389831, 0.04545455,
            0.02985075, 0.02040816, 0.02083333, 0.02597403, 0.015625, 0.00584795,
            0.04761905, 0.04918033, 0.05555556, 0.04166667, 0.03703704, 0.05357143,
            0.04651163, 0.04054054, 0.07407407, 0.04597701, 0.04494382, 0.06896552,
            0.04494382, 0.03896104, 0.06451613, 0.03296703, 0.02777778, 0.2118451,
            0.29166667, 0.30434783, 0.33333333, 0.26415094, 0.25, 0.27027027,
            0.21428571, 0.20454545, 0.18604651, 0.28985507, 0.3220339, 0.37878788,
            0.29850746, 0.28571429, 0.3125, 0.24675325, 0.234375, 0.23391813,
            0.28571429, 0.31147541, 0.34722222, 0.27777778, 0.25925926, 0.26785714,
            0.22093023, 0.2027027, 0.14814815, 0.29885057, 0.33707865, 0.48275862,
            0.33707865, 0.31168831, 0.38709677, 0.21978022, 0.19444444, 0.3394077,
            0.66666666, 0.65217391, 0.625, 0.69811321, 0.725, 0.7027027, 0.75,
            0.77272728, 0.79069768, 0.68115942, 0.64406779, 0.57575757, 0.67164179,
            0.69387755, 0.66666667, 0.72727272, 0.75, 0.76023392, 0.66666666,
            0.63934426, 0.59722222, 0.68055555, 0.7037037, 0.67857143, 0.73255814,
            0.75675676, 0.77777778, 0.65517242,
            0.61797753, 0.44827586, 0.61797753, 0.64935065, 0.5483871, 0.74725275,
            0.77777778, 0.4487472)
        pgm_factor30 = self.new_factor(pgm_rv30, pgm_rv23)
        pgm_function_2774976232976 = pgm_factor30.set_dense()
        pgm_function_2774976232976.set_flat(
            0.99378882, 0.8955224, 0.7035176, 0.1822542, 0.00621118, 0.1044776,
            0.2964824, 0.8177458)
        pgm_factor31 = self.new_factor(pgm_rv31, pgm_rv13)
        pgm_function_2774976232736 = pgm_factor31.set_dense()
        pgm_function_2774976232736.set_flat(0.5678571, 0.01193317, 0.4321429, 0.98806683)
        pgm_factor32 = self.new_factor(pgm_rv32, pgm_rv13)
        pgm_function_2774976234016 = pgm_factor32.set_dense()
        pgm_function_2774976234016.set_flat(0.1214286, 0.04057279, 0.8785714, 0.95942721)
        pgm_factor33 = self.new_factor(pgm_rv33, pgm_rv13)
        pgm_function_2774976230816 = pgm_factor33.set_dense()
        pgm_function_2774976230816.set_flat(0.1285714, 0.1002387, 0.8714286, 0.8997613)
        pgm_factor34 = self.new_factor(pgm_rv34, pgm_rv13, pgm_rv33)
        pgm_function_2774976231856 = pgm_factor34.set_dense()
        pgm_function_2774976231856.set_flat(
            0.3888889, 0.147541, 0.8095238, 0.1830239, 0.6111111, 0.852459, 0.1904762,
            0.8169761)
        pgm_factor35 = self.new_factor(pgm_rv35, pgm_rv18)
        pgm_function_2774976233056 = pgm_factor35.set_dense()
        pgm_function_2774976233056.set_flat(0.99827883, 0.99678457, 0.98032787, 0.00172117, 0.00321543, 0.01967213)
        pgm_factor36 = self.new_factor(pgm_rv36, pgm_rv18)
        pgm_function_2774976233296 = pgm_factor36.set_dense()
        pgm_function_2774976233296.set_flat(0.3448276, 0.06451613, 0.1311475, 0.6551724, 0.93548387, 0.8688525)
        pgm_factor37 = self.new_factor(pgm_rv37, pgm_rv18, pgm_rv13)
        pgm_function_2774976233376 = pgm_factor37.set_dense()
        pgm_function_2774976233376.set_flat(
            0.06547619, 0.06896552, 0.06557377, 0.06451613, 0.06428571, 0.09393939,
            0.63690476, 0.46551724, 0.63934426, 0.64516129, 0.67142857, 0.73636364,
            0.17857143, 0.27586207, 0.17486339, 0.16129032, 0.15714286, 0.13939394,
            0.11904762, 0.18965517, 0.12021858, 0.12903226, 0.10714286, 0.03030303)
        pgm_factor38 = self.new_factor(pgm_rv38, pgm_rv10, pgm_rv18, pgm_rv3, pgm_rv19)
        pgm_function_2774976233456 = pgm_factor38.set_dense()
        pgm_function_2774976233456.set_flat(
            0.01754386, 0.01298701, 0.02150538, 0.01666667, 0.025, 0.01333333,
            0.02409639, 0.01960784, 0.02197802, 0.01923077, 0.024, 0.02197802,
            0.03030303, 0.03225806, 0.02898551, 0.02469136, 0.03508772, 0.04081633,
            0.03571429, 0.03333333, 0.05084746, 0.05, 0.05333333, 0.08333333,
            0.03448276, 0.01428571, 0.02173913, 0.00172117, 0.01785714, 0.01785714,
            0.02816901, 0.00321543, 0.03508772, 0.03703704, 0.05357143, 0.065,
            0.84210526, 0.81818182, 0.8172043, 0.8, 0.85, 0.86666667, 0.86746988,
            0.85294118, 0.89010989, 0.90384615, 0.904, 0.9010989, 0.84848485,
            0.79032259, 0.79710145, 0.75308642, 0.8245614, 0.83673469, 0.85714285,
            0.83333334, 0.88135593, 0.9, 0.90666667, 0.88888889, 0.81034483, 0.75714286,
            0.75, 0.60240964, 0.76785715, 0.78571429, 0.80281691, 0.67524116,
            0.84210526, 0.92592592, 0.89285714, 0.875, 0.14035088, 0.16883117,
            0.16129032, 0.18333333, 0.125, 0.12, 0.10843373, 0.12745098, 0.08791209,
            0.07692308, 0.072, 0.07692308, 0.12121212, 0.17741935, 0.17391304,
            0.22222222, 0.14035088, 0.12244898, 0.10714286, 0.13333333, 0.06779661,
            0.05, 0.04, 0.02777778, 0.15517241, 0.22857143, 0.22826087, 0.39586919,
            0.21428571, 0.19642857, 0.16901408, 0.32154341, 0.12280702, 0.03703704,
            0.05357143, 0.06)
        pgm_factor39 = self.new_factor(pgm_rv39, pgm_rv37, pgm_rv38)
        pgm_function_2774976010768 = pgm_factor39.set_dense()
        pgm_function_2774976010768.set_flat(
            0.1428571, 0.106383, 0.09090909, 0.1304348, 0.1373494, 0.425, 0.2,
            0.1333333, 0.25, 0.5, 0.255814, 0.6666667, 0.8571429, 0.893617, 0.90909091,
            0.8695652, 0.8626506, 0.575, 0.8, 0.8666667, 0.75, 0.5, 0.7441861,
            0.3333333)
        pgm_factor40 = self.new_factor(pgm_rv40, pgm_rv6)
        pgm_function_2774976010848 = pgm_factor40.set_dense()
        pgm_function_2774976010848.set_flat(0.3925234, 0.4307432, 0.6074766, 0.5692568)
        pgm_factor41 = self.new_factor(pgm_rv41, pgm_rv18)
        pgm_function_2774976009088 = pgm_factor41.set_dense()
        pgm_function_2774976009088.set_flat(0.2068966, 0.2258064, 0.1114754, 0.7931035, 0.7741936, 0.8885246)
        pgm_factor42 = self.new_factor(pgm_rv42, pgm_rv18, pgm_rv13)
        pgm_function_2774976008928 = pgm_factor42.set_dense()
        pgm_function_2774976008928.set_flat(
            0.05325444, 0.05172414, 0.04891304, 0.00321543, 0.05357143, 0.01515152,
            0.94674556, 0.94827586, 0.95108696, 0.99678457, 0.94642857, 0.98484848)
        pgm_factor43 = self.new_factor(pgm_rv43, pgm_rv42)
        pgm_function_2774976008528 = pgm_factor43.set_dense()
        pgm_function_2774976008528.set_flat(0.2173913, 0.03550296, 0.1304348, 0.06508876, 0.6521739, 0.89940828)
        pgm_factor44 = self.new_factor(pgm_rv44, pgm_rv35)
        pgm_function_2774976008208 = pgm_factor44.set_dense()
        pgm_function_2774976008208.set_flat(0.1280932, 0.5833333, 0.8719068, 0.4166667)
        pgm_factor45 = self.new_factor(pgm_rv45, pgm_rv21, pgm_rv3, pgm_rv17, pgm_rv19)
        pgm_function_2774976010608 = pgm_factor45.set_dense()
        pgm_function_2774976010608.set_flat(
            0.6097561, 0.68, 0.5918367, 0.673913, 0.5901639, 0.6527778, 0.5555556,
            0.7058823, 0.6, 0.6756757, 0.5897436, 0.7777778, 0.5866667, 0.6865672,
            0.375, 0.6973684, 0.3902439, 0.32, 0.4081633, 0.326087, 0.4098361,
            0.3472222, 0.4444444, 0.2941177, 0.4, 0.3243243, 0.4102564, 0.2222222,
            0.4133333, 0.3134328, 0.625, 0.3026316)
        pgm_factor46 = self.new_factor(pgm_rv46, pgm_rv45)
        pgm_function_2774976011328 = pgm_factor46.set_dense()
        pgm_function_2774976011328.set_flat(0.3142251, 0.03070175, 0.6857749, 0.96929825)
        pgm_factor47 = self.new_factor(pgm_rv47, pgm_rv42)
        pgm_function_2774976010528 = pgm_factor47.set_dense()
        pgm_function_2774976010528.set_flat(0.7391304, 0.3772189, 0.2608696, 0.6227811)
        pgm_factor48 = self.new_factor(pgm_rv48, pgm_rv13, pgm_rv10, pgm_rv17, pgm_rv19)
        pgm_function_2774976011248 = pgm_factor48.set_dense()
        pgm_function_2774976011248.set_flat(
            0.2704918, 0.2972973, 0.2941177, 0.3205575, 0.3093923, 0.3315508, 0.3333333,
            0.368, 0.3425926, 0.3629893, 0.3636364, 0.4321429, 0.2682927, 0.175,
            0.1045752, 0.03296703, 0.06024096, 0.08602151, 0.05434783, 0.05555556,
            0.07594937, 0.13432836, 0.01785714, 0.04733728, 0.1721312, 0.1837838,
            0.1911765, 0.2055749, 0.1767956, 0.171123, 0.172043, 0.184, 0.1712963,
            0.1779359, 0.1818182, 0.2107143, 0.1768293, 0.1625, 0.1633987, 0.21978022,
            0.12048193, 0.08602151, 0.07608696, 0.05555556, 0.06329114, 0.05970149,
            0.07142857, 0.05325444, 0.5573771, 0.5189189, 0.5147059, 0.4738676,
            0.5138122, 0.4973262, 0.4946237, 0.448, 0.4861111, 0.4590747, 0.4545455,
            0.3571429, 0.5548781, 0.6625, 0.7320261, 0.74725275, 0.81927711, 0.82795698,
            0.86956521, 0.88888888, 0.86075949, 0.80597015, 0.91071429, 0.89940828)
        pgm_factor49 = self.new_factor(pgm_rv49, pgm_rv10, pgm_rv21, pgm_rv3, pgm_rv17, pgm_rv18)
        pgm_function_2774976012048 = pgm_factor49.set_dense()
        pgm_function_2774976012048.set_flat(
            0.05882353, 0.05454545, 0.04761905, 0.06451613, 0.07017544, 0.07936508,
            0.06849315, 0.05882353, 0.0625, 0.075, 0.08333333, 0.08988764, 0.0617284,
            0.05479452, 0.05882353, 0.06976744, 0.07792208, 0.08333333, 0.06862745,
            0.0625, 0.064, 0.08148148, 0.08661417, 0.1208791, 0.05172414, 0.02173913,
            0.0021692, 0.02272727, 0.00269542, 0.00262467, 0.01923077, 0.002079,
            0.00181488, 0.01886792, 0.02272727, 0.02083333, 0.01724138, 0.00191939,
            0.00166389, 0.01724138, 0.02040816, 0.01818182, 0.02777778, 0.01492537,
            0.01190476, 0.03409091, 0.02631579, 0.02777778, 0.02, 0.00212314,
            0.00191939, 0.02, 0.00249377, 0.0023753, 0.01666667, 0.00178253, 0.00144718,
            0.02816901, 0.01724138, 0.00584795, 0.01818182, 0.00172117, 0.00131406,
            0.025, 0.01470588, 0.00369004, 0.02666667, 0.01176471, 0.00149031,
            0.06896552, 0.03225806, 0.04569892, 0.15686275, 0.16363636, 0.15873016,
            0.17741935, 0.19298246, 0.19047619, 0.16438356, 0.17647059, 0.175, 0.1875,
            0.20833333, 0.2247191, 0.1728395, 0.16438356, 0.15294118, 0.1627907,
            0.18181818, 0.1875, 0.16666667, 0.1666667, 0.168, 0.17777778, 0.19685039,
            0.2307692, 0.15517241, 0.13043478, 0.1084599, 0.11363636,
            0.13477089, 0.1312336, 0.11538462, 0.1247401, 0.12704174, 0.13207547,
            0.15909091, 0.16666667, 0.12068966, 0.11516315, 0.09983361, 0.10344828,
            0.12244898, 0.10909091, 0.11111111, 0.11940299, 0.10714286, 0.11363636,
            0.13157895, 0.13888889, 0.12, 0.12738854, 0.11516315, 0.12, 0.14962594,
            0.1425178, 0.11666667, 0.12477718, 0.11577424, 0.12676056, 0.15517241,
            0.23391813, 0.10909091, 0.10327022, 0.09198423, 0.1, 0.11764706, 0.07380074,
            0.09333333, 0.10588235, 0.08941878, 0.12068966, 0.19354839, 0.17473118,
            0.41176471, 0.41818182, 0.41269841, 0.41935484, 0.42105263, 0.41269841,
            0.42465753, 0.42647059, 0.4125, 0.425, 0.43055556, 0.41573034, 0.4197531,
            0.42465753, 0.41176471, 0.41860465, 0.41558442, 0.40625, 0.42156863,
            0.4270833, 0.416, 0.42222222, 0.42519685, 0.3956044, 0.39655172, 0.41304348,
            0.3904555, 0.40909091, 0.40431267, 0.36745407, 0.40384615, 0.4158004,
            0.39927405, 0.41509434, 0.40909091, 0.375, 0.39655172, 0.40307102,
            0.38269551, 0.39655172, 0.3877551, 0.34545455, 0.38888889, 0.40298507,
            0.38095238, 0.38636364, 0.39473684, 0.27777778, 0.4, 0.42462845, 0.42226488,
            0.44, 0.44887781, 0.4275534, 0.45, 0.46345811,
            0.44862518, 0.46478873, 0.48275862, 0.46783626, 0.43636364, 0.4475043,
            0.42049934, 0.425, 0.44117647, 0.36900369, 0.42666667, 0.44705882,
            0.41728763, 0.46551724, 0.51612903, 0.42741935, 0.37254902, 0.36363636,
            0.38095238, 0.33870968, 0.31578947, 0.31746032, 0.34246575, 0.33823529,
            0.35, 0.3125, 0.27777778, 0.26966292, 0.345679, 0.35616438, 0.37647059,
            0.34883721, 0.32467532, 0.32291667, 0.34313725, 0.34375, 0.352, 0.31851852,
            0.29133858, 0.2527472, 0.39655172, 0.43478261, 0.4989154, 0.45454545,
            0.45822102, 0.49868766, 0.46153846, 0.4573805, 0.47186933, 0.43396226,
            0.40909091, 0.4375, 0.46551724, 0.47984645, 0.51580699, 0.48275862,
            0.46938776, 0.52727272, 0.47222222, 0.46268657, 0.5, 0.46590909, 0.44736842,
            0.55555555, 0.46, 0.44585987, 0.46065259, 0.42, 0.39900249, 0.4275534,
            0.41666667, 0.40998217, 0.4341534, 0.38028169, 0.34482759, 0.29239766,
            0.43636364, 0.4475043, 0.48620237, 0.45, 0.42647059, 0.55350553, 0.45333333,
            0.43529412, 0.49180328, 0.34482759, 0.25806452, 0.35215054)
        pgm_factor50 = self.new_factor(pgm_rv50, pgm_rv10, pgm_rv21, pgm_rv3, pgm_rv17, pgm_rv18)
        pgm_function_2774976008848 = pgm_factor50.set_dense()
        pgm_function_2774976008848.set_flat(
            0.01960784, 0.01818182, 0.01612903, 0.01612903, 0.01818182, 0.03225806,
            0.02777778, 0.02941176, 0.02531646, 0.025, 0.02777778, 0.03370787,
            0.02469136, 0.02739726, 0.02380952, 0.02352941, 0.02597403, 0.03125,
            0.02912621, 0.03125, 0.03174603, 0.03676471, 0.03937008, 0.05494505,
            0.01754386, 0.00221729, 0.00212314, 0.00221729, 0.00269542, 0.00269542,
            0.00191939, 0.00203666, 0.00181488, 0.00184843, 0.00226757, 0.00212314,
            0.00172117, 0.00191939, 0.00166389, 0.00172117, 0.00203666, 0.00181488,
            0.00142653, 0.00149031, 0.00120337, 0.01136364, 0.01315789, 0.02777778,
            0.00199601, 0.00212314, 0.00191939, 0.00199601, 0.00249377, 0.00243309,
            0.00166389, 0.00175131, 0.00142653, 0.00140647, 0.00172117, 0.00584795,
            0.00181488, 0.00172117, 0.00133156, 0.00126422, 0.00149031, 0.00369004,
            0.00133156, 0.00116144, 0.00149031, 0.01724138, 0.03225806, 0.01075269,
            0.1372549, 0.12727273, 0.14516129, 0.16129032, 0.16363636, 0.17741935,
            0.15277778, 0.14705882, 0.15189873, 0.175, 0.18055556, 0.20224719,
            0.16049383, 0.1369863, 0.14285714, 0.16470588, 0.16883117, 0.1875,
            0.16504854, 0.15625, 0.15873016, 0.17647059, 0.18110236, 0.23076923,
            0.14035088, 0.0886918, 0.08492569, 0.11086475,
            0.08086253, 0.08086253, 0.09596929, 0.0814664, 0.0907441, 0.11090573,
            0.09070295, 0.10615711, 0.10327022, 0.07677543, 0.08319468, 0.10327022,
            0.0814664, 0.0907441, 0.09985735, 0.08941878, 0.08423586, 0.10227273,
            0.09210526, 0.11111111, 0.0998004, 0.08492569, 0.07677543, 0.0998004,
            0.07481297, 0.0729927, 0.09983361, 0.08756567, 0.08559201, 0.11251758,
            0.10327022, 0.11695906, 0.0907441, 0.06884682, 0.0665779, 0.08849558,
            0.07451565, 0.07380074, 0.09320905, 0.08130081, 0.07451565, 0.13793103,
            0.06451613, 0.22580645, 0.47058824, 0.49090909, 0.46774194, 0.48387097,
            0.50909091, 0.48387097, 0.48611111, 0.5, 0.48101266, 0.5, 0.52777777,
            0.50561797, 0.4691358, 0.47945205, 0.45238095, 0.45882353, 0.48051948,
            0.4583333, 0.46601942, 0.4791667, 0.46031746, 0.47058824, 0.49606299,
            0.46153846, 0.45614035, 0.48780488, 0.44585987, 0.46563193, 0.51212938,
            0.45822102, 0.46065259, 0.48879837, 0.45372051, 0.4805915, 0.52154195,
            0.48832272, 0.4475043, 0.46065259, 0.41597338, 0.4302926, 0.46843177,
            0.41742287, 0.44222539, 0.46199702, 0.433213, 0.44318182, 0.47368421,
            0.36111111, 0.45908184, 0.48832272, 0.46065259, 0.47904192, 0.54862842,
            0.51094891, 0.49916805, 0.52539405,
            0.49928673, 0.52039381, 0.58519794, 0.64327486, 0.47186933, 0.48192771,
            0.43941411, 0.4551201, 0.49180328, 0.36900369, 0.45272969, 0.48780488,
            0.43219076, 0.5, 0.67741936, 0.46774194, 0.37254902, 0.36363636, 0.37096774,
            0.33870968, 0.30909091, 0.30645161, 0.33333333, 0.32352941, 0.34177215, 0.3,
            0.26388889, 0.25842697, 0.34567901, 0.35616438, 0.38095238, 0.35294118,
            0.32467532, 0.3229167, 0.33980583, 0.3333333, 0.34920635, 0.31617647,
            0.28346457, 0.25274725, 0.38596491, 0.42128603, 0.4670913, 0.42128603,
            0.40431267, 0.45822102, 0.44145873, 0.42769857, 0.45372051, 0.40665434,
            0.38548753, 0.40339703, 0.4475043, 0.46065259, 0.49916805, 0.46471601,
            0.44806517, 0.49001815, 0.45649073, 0.44709389, 0.48134777, 0.44318182,
            0.42105263, 0.5, 0.43912176, 0.42462845, 0.46065259, 0.41916168, 0.37406484,
            0.4136253, 0.39933444, 0.38528897, 0.41369472, 0.36568214, 0.30981067,
            0.23391813, 0.43557169, 0.4475043, 0.49267643, 0.4551201, 0.43219076,
            0.55350553, 0.45272969, 0.42973287, 0.49180328, 0.34482759, 0.22580645,
            0.29569892)
        pgm_factor51 = self.new_factor(pgm_rv51, pgm_rv6)
        pgm_function_2774976009488 = pgm_factor51.set_dense()
        pgm_function_2774976009488.set_flat(0.01869159, 0.01013514, 0.04672897, 0.01689189, 0.93457944, 0.97297297)
        pgm_factor52 = self.new_factor(pgm_rv52, pgm_rv13, pgm_rv3, pgm_rv21, pgm_rv17, pgm_rv10, pgm_rv19)
        pgm_function_2774976011008 = pgm_factor52.set_dense()
        pgm_function_2774976011008.set_flat(
            0.1590909, 0.1696429, 0.1546392, 0.1730769, 0.1666667, 0.1854839, 0.1694915,
            0.1832061, 0.1759259, 0.1913044, 0.1885246, 0.2108843, 0.1666667, 0.1768707,
            0.1652893, 0.1742424, 0.1726619, 0.1893491, 0.1741935, 0.1857923, 0.1748252,
            0.19375, 0.1918605, 0.2142857, 0.1756757, 0.18, 0.1666667, 0.1782946,
            0.1764706, 0.1939394, 0.1776316, 0.1899441, 0.1785714, 0.1987179, 0.1964286,
            0.2207792, 0.178771, 0.1804878, 0.1698113, 0.1843575, 0.1822917, 0.1977612,
            0.1826087, 0.1939799, 0.1846847, 0.2007435, 0.1986755, 0.2392857, 0.1509434,
            0.10526316, 0.05555556, 0.06122449, 0.05649718, 0.07393715, 0.06557377,
            0.078125, 0.04166667, 0.04761905, 0.04338395, 0.06651885, 0.05714286,
            0.07142857, 0.04545455, 0.04615385, 0.04285714, 0.0617284, 0.06024096,
            0.07070707, 0.04166667, 0.03030303, 0.02702703, 0.07380074, 0.06349206,
            0.07594937, 0.0483871, 0.05, 0.04615385, 0.06756757, 0.06410256, 0.07692308,
            0.04545455, 0.03448276, 0.03076923, 0.11695906, 0.06493506, 0.07692308,
            0.04444444, 0.04210526, 0.03703704, 0.07462687, 0.05660377, 0.08791209,
            0.04395604, 0.00277008, 0.00177936, 0.08, 0.1477273, 0.1607143, 0.1443299,
            0.1538462,
            0.1481482, 0.1612903, 0.1610169, 0.1755725, 0.1574074, 0.173913, 0.1639344,
            0.1836735, 0.1590909, 0.1632653, 0.1487603, 0.1590909, 0.1510791, 0.1656805,
            0.1677419, 0.1857923, 0.1678322, 0.18125, 0.1744186, 0.1932773, 0.1621622,
            0.1666667, 0.15, 0.1627907, 0.1544118, 0.169697, 0.1710526, 0.1899441,
            0.1714286, 0.1858974, 0.1785714, 0.1991342, 0.1731844, 0.1756098, 0.1572327,
            0.1675978, 0.1614583, 0.1791045, 0.1782609, 0.1939799, 0.1846847, 0.197026,
            0.192053, 0.225, 0.1415094, 0.09210526, 0.03703704, 0.02040816, 0.00188324,
            0.00184843, 0.04918033, 0.078125, 0.02083333, 0.02380952, 0.0021692,
            0.00221729, 0.04285714, 0.07142857, 0.03030303, 0.03076923, 0.01428571,
            0.01234568, 0.04819277, 0.08080808, 0.04166667, 0.03030303, 0.01351351,
            0.00369004, 0.04761905, 0.07594937, 0.03225806, 0.03333333, 0.01538462,
            0.01351351, 0.05128205, 0.08791209, 0.04545455, 0.03448276, 0.01538462,
            0.00584795, 0.06493506, 0.08547009, 0.04444444, 0.04210526, 0.02777778,
            0.02985075, 0.06603774, 0.14285714, 0.07692308, 0.05540166, 0.00177936,
            0.096, 0.1136364, 0.125, 0.1134021, 0.125, 0.1111111, 0.1209677, 0.1186441,
            0.129771,
            0.1111111, 0.1217391, 0.1065574, 0.1156463, 0.1212121, 0.1292517, 0.1157025,
            0.1287879, 0.1151079, 0.1242604, 0.1225806, 0.1311475, 0.1188811, 0.125,
            0.1104651, 0.1176471, 0.1216216, 0.1333333, 0.125, 0.131783, 0.1176471,
            0.1272727, 0.125, 0.1340782, 0.1214286, 0.1282051, 0.1130952, 0.1212121,
            0.122905, 0.1365854, 0.1257862, 0.1340782, 0.1197917, 0.1268657, 0.126087,
            0.1371237, 0.1261261, 0.133829, 0.1225166, 0.1321429, 0.1226415, 0.13157895,
            0.09259259, 0.10204082, 0.07532957, 0.09242144, 0.09836066, 0.125,
            0.08333333, 0.0952381, 0.04338395, 0.0443459, 0.1, 0.13095238, 0.10606061,
            0.12307692, 0.08571429, 0.09876543, 0.09638554, 0.12121212, 0.09722222,
            0.10606061, 0.05405405, 0.03690037, 0.11111111, 0.13924051, 0.11290323,
            0.13333333, 0.09230769, 0.10810811, 0.1025641, 0.13186813, 0.10606061,
            0.12068966, 0.06153846, 0.05847953, 0.11688312, 0.14529915, 0.12222222,
            0.13684211, 0.10185185, 0.13432836, 0.12264151, 0.17582418, 0.13186813,
            0.19390582, 0.01779359, 0.144, 0.5795455, 0.5446429, 0.5876289, 0.5480769,
            0.5740741, 0.5322581, 0.5508475, 0.5114504, 0.5555556, 0.5130435, 0.5409836,
            0.4897959,
            0.5530303, 0.5306122, 0.5702479, 0.5378788, 0.5611511, 0.5207101, 0.5354839,
            0.4972678, 0.5384615, 0.5, 0.5232558, 0.4747899, 0.5405405, 0.52, 0.5583333,
            0.5271318, 0.5514706, 0.5090909, 0.5263158, 0.4860335, 0.5285714, 0.4871795,
            0.5119048, 0.4588745, 0.5251397, 0.5073171, 0.5471698, 0.5139665, 0.5364583,
            0.4962687, 0.5130435, 0.4749164, 0.5045045, 0.4684015, 0.486755, 0.4035714,
            0.5849057, 0.67105263, 0.81481481, 0.81632653, 0.86629001, 0.83179298,
            0.78688524, 0.71875, 0.85416667, 0.83333333, 0.9110629, 0.88691796, 0.8,
            0.72619048, 0.81818181, 0.8, 0.85714286, 0.82716049, 0.79518073, 0.72727273,
            0.81944444, 0.83333333, 0.90540541, 0.88560885, 0.77777778, 0.70886075,
            0.80645161, 0.78333334, 0.84615384, 0.81081081, 0.78205129, 0.7032967,
            0.80303029, 0.81034482, 0.89230769, 0.81871346, 0.75324676, 0.69230768,
            0.7888889, 0.77894737, 0.83333333, 0.76119402, 0.75471698, 0.59340659,
            0.74725275, 0.74792244, 0.97864769, 0.68)
        pgm_factor53 = self.new_factor(pgm_rv53, pgm_rv13, pgm_rv17, pgm_rv10)
        pgm_function_2774976009808 = pgm_factor53.set_dense()
        pgm_function_2774976009808.set_flat(
            0.08965517, 0.09659091, 0.1034483, 0.1015873, 0.1050955, 0.125, 0.09174312,
            0.06918239, 0.04477612, 0.03296703, 0.00277008, 0.00044425, 0.28275862,
            0.30113636, 0.3256705, 0.3047619, 0.3152866, 0.3642857, 0.27981651,
            0.23899371, 0.2238806, 0.06593407, 0.02770083, 0.09773434, 0.62758621,
            0.60227273, 0.5708812, 0.5936508, 0.5796178, 0.5107143, 0.62844037,
            0.6918239, 0.73134328, 0.9010989, 0.96952909, 0.90182141)
        pgm_factor54 = self.new_factor(pgm_rv54, pgm_rv1, pgm_rv10)
        pgm_function_2774976008368 = pgm_factor54.set_dense()
        pgm_function_2774976008368.set_flat(
            0.5, 0.4615385, 0.1125, 0.1904762, 0.04347826, 0.04674797, 0.5, 0.5384615,
            0.8875, 0.8095238, 0.95652174, 0.95325203)
        pgm_factor55 = self.new_factor(pgm_rv55, pgm_rv1, pgm_rv10, pgm_rv54)
        pgm_function_2774976010928 = pgm_factor55.set_dense()
        pgm_function_2774976010928.set_flat(
            0.0070922, 0.07142857, 0.01639344, 0.01408451, 0.01098901, 0.04225352,
            0.08333333, 0.00195695, 0.09090909, 0.00452489, 0.004329, 0.01492537,
            0.9929078, 0.92857143, 0.98360656, 0.98591549, 0.98901099, 0.95774648,
            0.91666667, 0.99804305, 0.90909091, 0.99547511, 0.995671, 0.98507463)
        pgm_factor56 = self.new_factor(pgm_rv56, pgm_rv21, pgm_rv3)
        pgm_function_2774976009168 = pgm_factor56.set_dense()
        pgm_function_2774976009168.set_flat(
            0.1818182, 0.1176471, 0.2222222, 0.280916, 0.8181818, 0.8823529, 0.7777778,
            0.719084)
        pgm_factor57 = self.new_factor(pgm_rv57, pgm_rv21, pgm_rv3)
        pgm_function_2774976008608 = pgm_factor57.set_dense()
        pgm_function_2774976008608.set_flat(
            0.3636364, 0.3529412, 0.3703704, 0.2854962, 0.6363636, 0.6470588, 0.6296296,
            0.7145038)
        pgm_factor58 = self.new_factor(pgm_rv58, pgm_rv18, pgm_rv21, pgm_rv3)
        pgm_function_2774976011088 = pgm_factor58.set_dense()
        pgm_function_2774976011088.set_flat(
            0.3235294, 0.3703704, 0.3623188, 0.4827586, 0.3023256, 0.2444444, 0.2156863,
            0.2580645, 0.1621622, 0.1176471, 0.1111111, 0.1007067, 0.6764706, 0.6296296,
            0.6376812, 0.5172414, 0.6976744, 0.7555556, 0.7843137, 0.7419355, 0.8378378,
            0.8823529, 0.8888889, 0.8992933)
        pgm_factor59 = self.new_factor(pgm_rv59, pgm_rv42)
        pgm_function_2774976011408 = pgm_factor59.set_dense()
        pgm_function_2774976011408.set_flat(0.3043478, 0.01627219, 0.6956522, 0.98372781)
        pgm_factor60 = self.new_factor(pgm_rv60, pgm_rv18)
        pgm_function_2774976011168 = pgm_factor60.set_dense()
        pgm_function_2774976011168.set_flat(0.6034483, 0.483871, 0.1836066, 0.3965517, 0.516129, 0.8163934)
        pgm_factor61 = self.new_factor(pgm_rv61, pgm_rv23)
        pgm_function_2774976009008 = pgm_factor61.set_dense()
        pgm_function_2774976009008.set_flat(
            0.75, 0.5671642, 0.3467337, 0.1942446, 0.25, 0.4328358, 0.6532663,
            0.8057554)
        pgm_factor62 = self.new_factor(pgm_rv62, pgm_rv18)
        pgm_function_2774976011648 = pgm_factor62.set_dense()
        pgm_function_2774976011648.set_flat(
            0.91222031, 0.96463023, 0.7393443, 0.08605852, 0.00321543, 0.1426229,
            0.00172117, 0.03215434, 0.1180328)
        pgm_factor63 = self.new_factor(pgm_rv63, pgm_rv18)
        pgm_function_2774976011488 = pgm_factor63.set_dense()
        pgm_function_2774976011488.set_flat(0.7586207, 0.4516129, 0.2344262, 0.2413793, 0.5483871, 0.7655738)
        pgm_factor64 = self.new_factor(pgm_rv64, pgm_rv18)
        pgm_function_2774976008128 = pgm_factor64.set_dense()
        pgm_function_2774976008128.set_flat(0.6034483, 0.3548387, 0.1065574, 0.3965517, 0.6451613, 0.8934426)
        pgm_factor65 = self.new_factor(pgm_rv65, pgm_rv1, pgm_rv10)
        pgm_function_2774976009408 = pgm_factor65.set_dense()
        pgm_function_2774976009408.set_flat(
            0.00355872, 0.00763359, 0.0875, 0.07936508, 0.1304348, 0.101626, 0.99644128,
            0.99236641, 0.9125, 0.92063492, 0.8695652, 0.898374)
        pgm_factor66 = self.new_factor(pgm_rv66, pgm_rv1, pgm_rv10)
        pgm_function_2774976008768 = pgm_factor66.set_dense()
        pgm_function_2774976008768.set_flat(
            0.00355872, 0.00763359, 0.00124844, 0.00158479, 0.004329, 0.00203252,
            0.99644128, 0.99236641, 0.99875156, 0.99841521, 0.995671, 0.99796748)
        pgm_factor67 = self.new_factor(pgm_rv67, pgm_rv18)
        pgm_function_2774976009328 = pgm_factor67.set_dense()
        pgm_function_2774976009328.set_flat(0.5, 0.2903226, 0.1409836, 0.5, 0.7096774, 0.8590164)
        pgm_factor68 = self.new_factor(pgm_rv68, pgm_rv1, pgm_rv10)
        pgm_function_2774976008288 = pgm_factor68.set_dense()
        pgm_function_2774976008288.set_flat(
            0.00355872, 0.00763359, 0.00124844, 0.00158479, 0.04347826, 0.00203252,
            0.99644128, 0.99236641, 0.99875156, 0.99841521, 0.95652174, 0.99796748)
        pgm_factor69 = self.new_factor(pgm_rv69, pgm_rv18, pgm_rv13)
        pgm_function_2774976011568 = pgm_factor69.set_dense()
        pgm_function_2774976011568.set_flat(
            0.3636364, 0.3, 0.2727273, 0.2, 0.1, 0.01, 0.6363636, 0.7, 0.7272727, 0.8,
            0.9, 0.99)
