from ck.pgm import PGM


class Munin(PGM):
    """
    This PGM is the well known 'Munin' Bayesian network.
    """

    def __init__(self):
        super().__init__(self.__class__.__name__)

        R_LNLW_MED_SEV = self.new_rv('R_LNLW_MED_SEV', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_LNLW_MED_PATHO = self.new_rv('R_LNLW_MED_PATHO', ('DEMY', 'BLOCK', 'AXONAL', 'V_E_REIN', 'E_REIN'))
        R_LNLW_MEDD2_DISP_WD = self.new_rv('R_LNLW_MEDD2_DISP_WD', ('NO', 'MILD', 'MOD', 'SEV'))
        DIFFN_SEV = self.new_rv('DIFFN_SEV', ('NO', 'MILD', 'MOD', 'SEV'))
        DIFFN_TYPE = self.new_rv('DIFFN_TYPE', ('MOTOR', 'MIXED', 'SENS'))
        DIFFN_SENS_SEV = self.new_rv('DIFFN_SENS_SEV', ('NO', 'MILD', 'MOD', 'SEV'))
        DIFFN_DISTR = self.new_rv('DIFFN_DISTR', ('DIST', 'PROX', 'RANDOM'))
        DIFFN_S_SEV_DIST = self.new_rv('DIFFN_S_SEV_DIST', ('NO', 'MILD', 'MOD', 'SEV'))
        DIFFN_PATHO = self.new_rv('DIFFN_PATHO', ('DEMY', 'BLOCK', 'AXONAL', 'V_E_REIN', 'E_REIN'))
        R_DIFFN_MEDD2_DISP = self.new_rv('R_DIFFN_MEDD2_DISP', ('NO', 'MILD', 'MOD', 'SEV'))
        R_DIFFN_LNLW_MEDD2_DISP_WD = self.new_rv('R_DIFFN_LNLW_MEDD2_DISP_WD', ('NO', 'MILD', 'MOD', 'SEV'))
        R_MEDD2_DISP_WD = self.new_rv('R_MEDD2_DISP_WD', ('NO', 'MILD', 'MOD', 'SEV'))
        R_LNLBE_MEDD2_DISP_EW = self.new_rv('R_LNLBE_MEDD2_DISP_EW', ('NO', 'MILD', 'MOD', 'SEV'))
        R_MEDD2_DISP_EW = self.new_rv('R_MEDD2_DISP_EW', ('NO', 'MILD', 'MOD', 'SEV'))
        R_MEDD2_DISP_EWD = self.new_rv('R_MEDD2_DISP_EWD', (
            'R0_15', 'R0_25', 'R0_35', 'R0_45', 'R0_55', 'R0_65', 'R0_75', 'R0_85', 'R0_95'))
        R_DIFFN_MEDD2_BLOCK = self.new_rv('R_DIFFN_MEDD2_BLOCK', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_LNLBE_MEDD2_BLOCK_EW = self.new_rv('R_LNLBE_MEDD2_BLOCK_EW', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_MEDD2_BLOCK_EW = self.new_rv('R_MEDD2_BLOCK_EW', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_MEDD2_AMPR_EW = self.new_rv('R_MEDD2_AMPR_EW', (
            'R0_0', 'R0_1', 'R0_2', 'R0_3', 'R0_4', 'R0_5', 'R0_6', 'R0_7', 'R0_8', 'R0_9', 'R1_0', 'R_1_1'))
        R_LNLBE_MEDD2_LD_EW = self.new_rv('R_LNLBE_MEDD2_LD_EW', ('NO', 'MILD', 'MOD', 'SEV'))
        R_MEDD2_LD_EW = self.new_rv('R_MEDD2_LD_EW', ('NO', 'MILD', 'MOD', 'SEV'))
        R_LNLBE_MEDD2_RD_EW = self.new_rv('R_LNLBE_MEDD2_RD_EW', ('NO', 'MOD', 'SEV'))
        R_MEDD2_RD_EW = self.new_rv('R_MEDD2_RD_EW', ('NO', 'MOD', 'SEV'))
        R_MEDD2_LSLOW_EW = self.new_rv('R_MEDD2_LSLOW_EW', ('NO', 'MILD', 'MOD', 'SEV', 'V_SEV'))
        R_LNLW_MEDD2_SALOSS_WD = self.new_rv('R_LNLW_MEDD2_SALOSS_WD', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_DIFFN_MEDD2_SALOSS = self.new_rv('R_DIFFN_MEDD2_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_DIFFN_LNLW_MEDD2_SALOSS = self.new_rv('R_DIFFN_LNLW_MEDD2_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_LNLBE_MEDD2_SALOSS_EW = self.new_rv('R_LNLBE_MEDD2_SALOSS_EW', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_MEDD2_SALOSS = self.new_rv('R_MEDD2_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_DIFFN_MEDD2_DIFSLOW = self.new_rv('R_DIFFN_MEDD2_DIFSLOW', ('NO', 'MILD', 'MOD', 'SEV'))
        R_MEDD2_DIFSLOW_EW = self.new_rv('R_MEDD2_DIFSLOW_EW', ('NO', 'MILD', 'MOD', 'SEV'))
        R_MEDD2_DSLOW_EW = self.new_rv('R_MEDD2_DSLOW_EW', (
            'M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        R_MEDD2_ALLCV_EW = self.new_rv('R_MEDD2_ALLCV_EW', (
            'M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        R_MEDD2_CV_EW = self.new_rv('R_MEDD2_CV_EW', (
            'M_S00', 'M_S04', 'M_S08', 'M_S12', 'M_S16', 'M_S20', 'M_S24', 'M_S28', 'M_S32', 'M_S36', 'M_S40', 'M_S44',
            'M_S48', 'M_S52', 'M_S56', 'M_S60', 'M_S64', 'M_S68', 'M_S72', 'M_S_76'))
        R_LNLW_MEDD2_BLOCK_WD = self.new_rv('R_LNLW_MEDD2_BLOCK_WD', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_MEDD2_BLOCK_WD = self.new_rv('R_MEDD2_BLOCK_WD', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_MEDD2_EFFAXLOSS = self.new_rv('R_MEDD2_EFFAXLOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_MEDD2_ALLAMP_WD = self.new_rv('R_MEDD2_ALLAMP_WD', ('ZERO', 'A0_01', 'A0_10', 'A0_30', 'A0_70', 'A1_00'))
        R_MEDD2_AMP_WD = self.new_rv('R_MEDD2_AMP_WD', (
            'UV_0_63', 'UV0_88', 'UV1_25', 'UV1_77', 'UV2_50', 'UV3_50', 'UV5_00', 'UV7_10', 'UV10_0', 'UV14_0',
            'UV20_0',
            'UV28_0', 'UV40_0', 'UV57_0', 'UV_80_0'))
        R_LNLW_MEDD2_LD_WD = self.new_rv('R_LNLW_MEDD2_LD_WD', ('NO', 'MILD', 'MOD', 'SEV'))
        R_MEDD2_LD_WD = self.new_rv('R_MEDD2_LD_WD', ('NO', 'MILD', 'MOD', 'SEV'))
        R_LNLW_MEDD2_RD_WD = self.new_rv('R_LNLW_MEDD2_RD_WD', ('NO', 'MOD', 'SEV'))
        R_MEDD2_RD_WD = self.new_rv('R_MEDD2_RD_WD', ('NO', 'MOD', 'SEV'))
        R_MEDD2_LSLOW_WD = self.new_rv('R_MEDD2_LSLOW_WD', ('NO', 'MILD', 'MOD', 'SEV', 'V_SEV'))
        R_LNLBE_MEDD2_DIFSLOW_WD = self.new_rv('R_LNLBE_MEDD2_DIFSLOW_WD', ('NO', 'MILD', 'MOD', 'SEV'))
        R_MEDD2_DIFSLOW_WD = self.new_rv('R_MEDD2_DIFSLOW_WD', ('NO', 'MILD', 'MOD', 'SEV'))
        R_MEDD2_DSLOW_WD = self.new_rv('R_MEDD2_DSLOW_WD', (
            'M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        R_MEDD2_ALLCV_WD = self.new_rv('R_MEDD2_ALLCV_WD', (
            'M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        R_MEDD2_CV_WD = self.new_rv('R_MEDD2_CV_WD', (
            'M_S00', 'M_S04', 'M_S08', 'M_S12', 'M_S16', 'M_S20', 'M_S24', 'M_S28', 'M_S32', 'M_S36', 'M_S40', 'M_S44',
            'M_S48', 'M_S52', 'M_S56', 'M_S60', 'M_S64', 'M_S68', 'M_S_72'))
        DIFFN_MOT_SEV = self.new_rv('DIFFN_MOT_SEV', ('NO', 'MILD', 'MOD', 'SEV'))
        DIFFN_M_SEV_DIST = self.new_rv('DIFFN_M_SEV_DIST', ('NO', 'MILD', 'MOD', 'SEV'))
        R_DIFFN_MED_BLOCK = self.new_rv('R_DIFFN_MED_BLOCK', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_LNLBE_MED_BLOCK = self.new_rv('R_LNLBE_MED_BLOCK', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_MED_BLOCK_EW = self.new_rv('R_MED_BLOCK_EW', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_MED_AMPR_EW = self.new_rv('R_MED_AMPR_EW', (
            'R_1_1', 'R1_0', 'R0_9', 'R0_8', 'R0_7', 'R0_6', 'R0_5', 'R0_4', 'R0_3', 'R0_2', 'R0_1', 'R0_0'))
        R_LNLT1_APB_MALOSS = self.new_rv('R_LNLT1_APB_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_LNLLP_APB_MALOSS = self.new_rv('R_LNLLP_APB_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_LNLT1_LP_APB_MALOSS = self.new_rv('R_LNLT1_LP_APB_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_LNLBE_APB_MALOSS = self.new_rv('R_LNLBE_APB_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_LNLT1_LP_BE_APB_MALOSS = self.new_rv('R_LNLT1_LP_BE_APB_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_LNLW_APB_MALOSS = self.new_rv('R_LNLW_APB_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_DIFFN_APB_MALOSS = self.new_rv('R_DIFFN_APB_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_DIFFN_LNLW_APB_MALOSS = self.new_rv('R_DIFFN_LNLW_APB_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_APB_MALOSS = self.new_rv('R_APB_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL', 'OTHER'))
        R_DIFFN_MED_DIFSLOW = self.new_rv('R_DIFFN_MED_DIFSLOW', ('NO', 'MILD', 'MOD', 'SEV'))
        R_MED_DIFSLOW_EW = self.new_rv('R_MED_DIFSLOW_EW', ('NO', 'MILD', 'MOD', 'SEV'))
        R_MED_DCV_EW = self.new_rv('R_MED_DCV_EW', (
            'M_S60', 'M_S56', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        R_MED_LD_EW = self.new_rv('R_MED_LD_EW', ('NO', 'MILD', 'MOD', 'SEV'))
        R_MED_RD_EW = self.new_rv('R_MED_RD_EW', ('NO', 'MOD', 'SEV'))
        R_MED_RDLDCV_EW = self.new_rv('R_MED_RDLDCV_EW', ('M_S60', 'M_S52', 'M_S44', 'M_S27', 'M_S15', 'M_S07'))
        R_MED_ALLCV_EW = self.new_rv('R_MED_ALLCV_EW', (
            'M_S60', 'M_S56', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        R_MED_CV_EW = self.new_rv('R_MED_CV_EW', (
            'M_S00', 'M_S04', 'M_S08', 'M_S12', 'M_S16', 'M_S20', 'M_S24', 'M_S28', 'M_S32', 'M_S36', 'M_S40', 'M_S44',
            'M_S48', 'M_S52', 'M_S56', 'M_S60', 'M_S64', 'M_S68', 'M_S72'))
        R_LNLT1_APB_DE_REGEN = self.new_rv('R_LNLT1_APB_DE_REGEN', ('NO', 'YES'))
        R_LNLLP_APB_DE_REGEN = self.new_rv('R_LNLLP_APB_DE_REGEN', ('NO', 'YES'))
        R_LNLT1_LP_APB_DE_REGEN = self.new_rv('R_LNLT1_LP_APB_DE_REGEN', ('NO', 'YES'))
        R_LNLBE_APB_DE_REGEN = self.new_rv('R_LNLBE_APB_DE_REGEN', ('NO', 'YES'))
        R_LNLT1_LP_BE_APB_DE_REGEN = self.new_rv('R_LNLT1_LP_BE_APB_DE_REGEN', ('NO', 'YES'))
        DIFFN_TIME = self.new_rv('DIFFN_TIME', ('ACUTE', 'SUBACUTE', 'CHRONIC', 'OLD'))
        R_DIFFN_APB_DE_REGEN = self.new_rv('R_DIFFN_APB_DE_REGEN', ('NO', 'YES'))
        R_LNLW_MED_TIME = self.new_rv('R_LNLW_MED_TIME', ('ACUTE', 'SUBACUTE', 'CHRONIC', 'OLD'))
        R_LNLW_APB_DE_REGEN = self.new_rv('R_LNLW_APB_DE_REGEN', ('NO', 'YES'))
        R_DIFFN_LNLW_APB_DE_REGEN = self.new_rv('R_DIFFN_LNLW_APB_DE_REGEN', ('NO', 'YES'))
        R_LNL_DIFFN_APB_DE_REGEN = self.new_rv('R_LNL_DIFFN_APB_DE_REGEN', ('NO', 'YES'))
        R_MYOP_APB_DE_REGEN = self.new_rv('R_MYOP_APB_DE_REGEN', ('NO', 'YES'))
        R_MYDY_APB_DE_REGEN = self.new_rv('R_MYDY_APB_DE_REGEN', ('NO', 'YES'))
        R_MYOP_MYDY_APB_DE_REGEN = self.new_rv('R_MYOP_MYDY_APB_DE_REGEN', ('NO', 'YES'))
        R_APB_DE_REGEN = self.new_rv('R_APB_DE_REGEN', ('NO', 'YES'))
        R_DE_REGEN_APB_NMT = self.new_rv('R_DE_REGEN_APB_NMT',
                                         ('NO', 'MOD_PRE', 'SEV_PRE', 'MLD_POST', 'MOD_POST', 'SEV_POST', 'MIXED'))
        R_MYAS_APB_NMT = self.new_rv('R_MYAS_APB_NMT',
                                     ('NO', 'MOD_PRE', 'SEV_PRE', 'MLD_POST', 'MOD_POST', 'SEV_POST', 'MIXED'))
        R_APB_NMT = self.new_rv('R_APB_NMT', ('NO', 'MOD_PRE', 'SEV_PRE', 'MLD_POST', 'MOD_POST', 'SEV_POST', 'MIXED'))
        R_MYDY_APB_MUSIZE = self.new_rv('R_MYDY_APB_MUSIZE', ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_MYOP_APB_MUSIZE = self.new_rv('R_MYOP_APB_MUSIZE', ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_MYOP_MYDY_APB_MUSIZE = self.new_rv('R_MYOP_MYDY_APB_MUSIZE',
                                             ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_LNLW_APB_MUSIZE = self.new_rv('R_LNLW_APB_MUSIZE', ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_DIFFN_APB_MUSIZE = self.new_rv('R_DIFFN_APB_MUSIZE',
                                         ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_DIFFN_LNLW_APB_MUSIZE = self.new_rv('R_DIFFN_LNLW_APB_MUSIZE',
                                              ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_LNLBE_APB_MUSIZE = self.new_rv('R_LNLBE_APB_MUSIZE',
                                         ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_LNLLP_APB_MUSIZE = self.new_rv('R_LNLLP_APB_MUSIZE',
                                         ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_LNLT1_APB_MUSIZE = self.new_rv('R_LNLT1_APB_MUSIZE',
                                         ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_LNLT1_LP_APB_MUSIZE = self.new_rv('R_LNLT1_LP_APB_MUSIZE',
                                            ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_LNLT1_LP_BE_APB_MUSIZE = self.new_rv('R_LNLT1_LP_BE_APB_MUSIZE',
                                               ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_LNL_DIFFN_APB_MUSIZE = self.new_rv('R_LNL_DIFFN_APB_MUSIZE',
                                             ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_APB_MUSIZE = self.new_rv('R_APB_MUSIZE', ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE', 'OTHER'))
        R_APB_EFFMUS = self.new_rv('R_APB_EFFMUS', ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE', 'OTHER'))
        R_LNLW_MED_BLOCK = self.new_rv('R_LNLW_MED_BLOCK', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_MED_BLOCK_WA = self.new_rv('R_MED_BLOCK_WA', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_APB_MULOSS = self.new_rv('R_APB_MULOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL', 'OTHER'))
        R_APB_ALLAMP_WA = self.new_rv('R_APB_ALLAMP_WA',
                                      ('ZERO', 'A0_01', 'A0_10', 'A0_30', 'A0_70', 'A1_00', 'A2_00', 'A4_00', 'A8_00'))
        R_MED_AMP_WA = self.new_rv('R_MED_AMP_WA', (
            'MV_000', 'MV_13', 'MV_18', 'MV_25', 'MV_35', 'MV_5', 'MV_71', 'MV1', 'MV1_4', 'MV2', 'MV2_8', 'MV4',
            'MV5_6',
            'MV8', 'MV11_3', 'MV16', 'MV22_6'))
        R_MED_LD_WA = self.new_rv('R_MED_LD_WA', ('NO', 'MILD', 'MOD', 'SEV'))
        R_MED_RD_WA = self.new_rv('R_MED_RD_WA', ('NO', 'MOD', 'SEV'))
        R_MED_RDLDDEL = self.new_rv('R_MED_RDLDDEL', ('MS3_1', 'MS3_9', 'MS4_7', 'MS10_1', 'MS20_1'))
        R_LNLBE_MED_DIFSLOW = self.new_rv('R_LNLBE_MED_DIFSLOW', ('NO', 'MILD', 'MOD', 'SEV'))
        R_MED_DIFSLOW_WA = self.new_rv('R_MED_DIFSLOW_WA', ('NO', 'MILD', 'MOD', 'SEV'))
        R_MED_DCV_WA = self.new_rv('R_MED_DCV_WA',
                                   ('M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        R_MED_ALLDEL_WA = self.new_rv('R_MED_ALLDEL_WA', (
            'MS0_0', 'MS0_4', 'MS0_8', 'MS1_6', 'MS3_2', 'MS6_4', 'MS12_8', 'MS25_6', 'INFIN'))
        R_MED_LAT_WA = self.new_rv('R_MED_LAT_WA', (
            'MS2_3', 'MS2_7', 'MS3_1', 'MS3_5', 'MS3_9', 'MS4_3', 'MS4_7', 'MS5_3', 'MS5_9', 'MS6_5', 'MS7_1', 'MS8_0',
            'MS9_0', 'MS10_0', 'MS12_0', 'MS14_0', 'MS16_0', 'MS18_0', 'INFIN'))
        R_APB_VOL_ACT = self.new_rv('R_APB_VOL_ACT', ('NORMAL', 'REDUCED', 'V_RED', 'ABSENT'))
        R_APB_FORCE = self.new_rv('R_APB_FORCE', ('x5', 'x4', 'x3', 'x2', 'x1', 'x0'))
        R_APB_MUSCLE_VOL = self.new_rv('R_APB_MUSCLE_VOL', ('ATROPHIC', 'NORMAL'))
        R_APB_MVA_RECRUIT = self.new_rv('R_APB_MVA_RECRUIT', ('FULL', 'REDUCED', 'DISCRETE', 'NO_UNITS'))
        R_APB_MVA_AMP = self.new_rv('R_APB_MVA_AMP', ('INCR', 'NORMAL', 'REDUCED'))
        R_APB_TA_CONCL = self.new_rv('R_APB_TA_CONCL', ('x_5ABOVE', 'x2_5ABOVE', 'NORMAL', 'x2_5BELOW', 'x_5BELOW'))
        R_APB_MUPAMP = self.new_rv('R_APB_MUPAMP', ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE', 'OTHER'))
        R_APB_QUAN_MUPAMP = self.new_rv('R_APB_QUAN_MUPAMP', (
            'UV34', 'UV44', 'UV58', 'UV74', 'UV94', 'UV122', 'UV156', 'UV200', 'UV260', 'UV330', 'UV420', 'UV540',
            'UV700',
            'UV900', 'UV1150', 'UV1480', 'UV1900', 'UV2440', 'UV3130', 'UV4020'))
        R_APB_QUAL_MUPAMP = self.new_rv('R_APB_QUAL_MUPAMP', ('V_RED', 'REDUCED', 'NORMAL', 'INCR', 'V_INCR'))
        R_APB_MUPDUR = self.new_rv('R_APB_MUPDUR', ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE', 'OTHER'))
        R_APB_QUAN_MUPDUR = self.new_rv('R_APB_QUAN_MUPDUR', (
            'MS3', 'MS4', 'MS5', 'MS6', 'MS7', 'MS8', 'MS9', 'MS10', 'MS11', 'MS12', 'MS13', 'MS14', 'MS15', 'MS16',
            'MS17',
            'MS18', 'MS19', 'MS20', 'MS_20'))
        R_APB_QUAL_MUPDUR = self.new_rv('R_APB_QUAL_MUPDUR', ('SMALL', 'NORMAL', 'INCR'))
        R_APB_QUAN_MUPPOLY = self.new_rv('R_APB_QUAN_MUPPOLY', ('x_12_', 'x12_24_', 'x_24_'))
        R_APB_QUAL_MUPPOLY = self.new_rv('R_APB_QUAL_MUPPOLY', ('NORMAL', 'INCR'))
        R_APB_MUPSATEL = self.new_rv('R_APB_MUPSATEL', ('NO', 'YES'))
        R_APB_MUPINSTAB = self.new_rv('R_APB_MUPINSTAB', ('NO', 'YES'))
        R_APB_REPSTIM_CMAPAMP = self.new_rv('R_APB_REPSTIM_CMAPAMP', (
            'MV_000', 'MV_032', 'MV_044', 'MV_063', 'MV_088', 'MV_13', 'MV_18', 'MV_25', 'MV_35', 'MV_5', 'MV_71',
            'MV1',
            'MV1_4', 'MV2', 'MV2_8', 'MV4', 'MV5_6', 'MV8', 'MV11_3', 'MV16', 'MV22_6'))
        R_APB_REPSTIM_DECR = self.new_rv('R_APB_REPSTIM_DECR', ('NO', 'MILD', 'MOD', 'SEV', 'INCON'))
        R_APB_REPSTIM_FACILI = self.new_rv('R_APB_REPSTIM_FACILI', ('NO', 'MOD', 'SEV', 'REDUCED'))
        R_APB_REPSTIM_POST_DECR = self.new_rv('R_APB_REPSTIM_POST_DECR', ('NO', 'MILD', 'MOD', 'SEV', 'INCON'))
        R_APB_SF_JITTER = self.new_rv('R_APB_SF_JITTER', ('NORMAL', 'x2_5', 'x5_10', 'x_10'))
        R_LNLT1_APB_MUDENS = self.new_rv('R_LNLT1_APB_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_LNLLP_APB_MUDENS = self.new_rv('R_LNLLP_APB_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_LNLT1_LP_APB_MUDENS = self.new_rv('R_LNLT1_LP_APB_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_LNLBE_APB_MUDENS = self.new_rv('R_LNLBE_APB_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_LNLT1_LP_BE_APB_MUDENS = self.new_rv('R_LNLT1_LP_BE_APB_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_DIFFN_APB_MUDENS = self.new_rv('R_DIFFN_APB_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_LNLW_APB_MUDENS = self.new_rv('R_LNLW_APB_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_DIFFN_LNLW_APB_MUDENS = self.new_rv('R_DIFFN_LNLW_APB_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_LNL_DIFFN_APB_MUDENS = self.new_rv('R_LNL_DIFFN_APB_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_MYOP_APB_MUDENS = self.new_rv('R_MYOP_APB_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_MYDY_APB_MUDENS = self.new_rv('R_MYDY_APB_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_MYOP_MYDY_APB_MUDENS = self.new_rv('R_MYOP_MYDY_APB_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_MYAS_APB_MUDENS = self.new_rv('R_MYAS_APB_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_MUSCLE_APB_MUDENS = self.new_rv('R_MUSCLE_APB_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_APB_MUDENS = self.new_rv('R_APB_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_APB_SF_DENSITY = self.new_rv('R_APB_SF_DENSITY', ('x_2SD', 'x2_4SD', 'x_4SD'))
        R_LNLT1_APB_NEUR_ACT = self.new_rv('R_LNLT1_APB_NEUR_ACT',
                                           ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        R_LNLLP_APB_NEUR_ACT = self.new_rv('R_LNLLP_APB_NEUR_ACT',
                                           ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        R_LNLT1_LP_APB_NEUR_ACT = self.new_rv('R_LNLT1_LP_APB_NEUR_ACT',
                                              ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        R_LNLBE_APB_NEUR_ACT = self.new_rv('R_LNLBE_APB_NEUR_ACT',
                                           ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        R_LNLT1_LP_BE_APB_NEUR_ACT = self.new_rv('R_LNLT1_LP_BE_APB_NEUR_ACT',
                                                 ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        R_DIFFN_APB_NEUR_ACT = self.new_rv('R_DIFFN_APB_NEUR_ACT',
                                           ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        R_LNLW_APB_NEUR_ACT = self.new_rv('R_LNLW_APB_NEUR_ACT',
                                          ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        R_DIFFN_LNLW_APB_NEUR_ACT = self.new_rv('R_DIFFN_LNLW_APB_NEUR_ACT',
                                                ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        R_APB_NEUR_ACT = self.new_rv('R_APB_NEUR_ACT', ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        R_APB_SPONT_NEUR_DISCH = self.new_rv('R_APB_SPONT_NEUR_DISCH',
                                             ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        R_MYOP_APB_DENERV = self.new_rv('R_MYOP_APB_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_MYDY_APB_DENERV = self.new_rv('R_MYDY_APB_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_MYOP_MYDY_APB_DENERV = self.new_rv('R_MYOP_MYDY_APB_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_NMT_APB_DENERV = self.new_rv('R_NMT_APB_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_MUSCLE_APB_DENERV = self.new_rv('R_MUSCLE_APB_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_LNLT1_APB_DENERV = self.new_rv('R_LNLT1_APB_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_LNLLP_APB_DENERV = self.new_rv('R_LNLLP_APB_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_LNLT1_LP_APB_DENERV = self.new_rv('R_LNLT1_LP_APB_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_LNLBE_APB_DENERV = self.new_rv('R_LNLBE_APB_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_LNLT1_LP_BE_APB_DENERV = self.new_rv('R_LNLT1_LP_BE_APB_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_DIFFN_APB_DENERV = self.new_rv('R_DIFFN_APB_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_LNLW_APB_DENERV = self.new_rv('R_LNLW_APB_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_DIFFN_LNLW_APB_DENERV = self.new_rv('R_DIFFN_LNLW_APB_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_LNL_DIFFN_APB_DENERV = self.new_rv('R_LNL_DIFFN_APB_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_APB_DENERV = self.new_rv('R_APB_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_APB_SPONT_DENERV_ACT = self.new_rv('R_APB_SPONT_DENERV_ACT', ('NO', 'SOME', 'MOD', 'ABUNDANT'))
        R_APB_SPONT_HF_DISCH = self.new_rv('R_APB_SPONT_HF_DISCH', ('NO', 'YES'))
        R_APB_SPONT_INS_ACT = self.new_rv('R_APB_SPONT_INS_ACT', ('NORMAL', 'INCR'))
        DIFFN_M_SEV_PROX = self.new_rv('DIFFN_M_SEV_PROX', ('NO', 'MILD', 'MOD', 'SEV'))
        DIFFN_DUMMY_1 = self.new_rv('DIFFN_DUMMY_1', ('dummy', 'State1'))
        DIFFN_DUMMY_2 = self.new_rv('DIFFN_DUMMY_2', ('dummy', 'State1'))
        DIFFN_DUMMY_3 = self.new_rv('DIFFN_DUMMY_3', ('dummy', 'State1'))
        R_OTHER_ULND5_DISP = self.new_rv('R_OTHER_ULND5_DISP', ('NO', 'MILD', 'MOD', 'SEV'))
        R_DIFFN_ULND5_DISP = self.new_rv('R_DIFFN_ULND5_DISP', ('NO', 'MILD', 'MOD', 'SEV'))
        R_LNLE_ULN_SEV = self.new_rv('R_LNLE_ULN_SEV', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_LNLE_ULN_PATHO = self.new_rv('R_LNLE_ULN_PATHO', ('DEMY', 'BLOCK', 'AXONAL', 'V_E_REIN', 'E_REIN'))
        R_LNLE_ULND5_DISP_E = self.new_rv('R_LNLE_ULND5_DISP_E', ('NO', 'MILD', 'MOD', 'SEV'))
        R_LNLE_DIFFN_ULND5_DISP_E = self.new_rv('R_LNLE_DIFFN_ULND5_DISP_E', ('NO', 'MILD', 'MOD', 'SEV'))
        R_ULND5_DISP_E = self.new_rv('R_ULND5_DISP_E', ('NO', 'MILD', 'MOD', 'SEV'))
        R_LNLW_ULND5_DISP_WD = self.new_rv('R_LNLW_ULND5_DISP_WD', ('NO', 'MILD', 'MOD', 'SEV'))
        R_DIFFN_LNLW_ULND5_DISP_WD = self.new_rv('R_DIFFN_LNLW_ULND5_DISP_WD', ('NO', 'MILD', 'MOD', 'SEV'))
        R_ULND5_DISP_WD = self.new_rv('R_ULND5_DISP_WD', ('NO', 'MILD', 'MOD', 'SEV'))
        R_ULND5_DISP_BEW = self.new_rv('R_ULND5_DISP_BEW', ('NO', 'MILD', 'MOD', 'SEV'))
        R_ULND5_DISP_BED = self.new_rv('R_ULND5_DISP_BED', ('NO', 'MILD', 'MOD', 'SEV'))
        R_ULND5_DISP_EED = self.new_rv('R_ULND5_DISP_EED', (
            'R0_15', 'R0_25', 'R0_35', 'R0_45', 'R0_55', 'R0_65', 'R0_75', 'R0_85', 'R0_95'))
        R_OTHER_ULND5_BLOCK = self.new_rv('R_OTHER_ULND5_BLOCK', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_DIFFN_ULND5_BLOCK = self.new_rv('R_DIFFN_ULND5_BLOCK', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_LNLE_ULND5_BLOCK_E = self.new_rv('R_LNLE_ULND5_BLOCK_E', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_LNLE_DIFFN_ULND5_BLOCK_E = self.new_rv('R_LNLE_DIFFN_ULND5_BLOCK_E', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_ULND5_BLOCK_E = self.new_rv('R_ULND5_BLOCK_E', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_ULND5_AMPR_E = self.new_rv('R_ULND5_AMPR_E', (
            'R0_0', 'R0_1', 'R0_2', 'R0_3', 'R0_4', 'R0_5', 'R0_6', 'R0_7', 'R0_8', 'R0_9', 'R1_0', 'R_1_1'))
        R_OTHER_ULND5_LD = self.new_rv('R_OTHER_ULND5_LD', ('NO', 'MILD', 'MOD', 'SEV'))
        R_LNLE_ULND5_LD_E = self.new_rv('R_LNLE_ULND5_LD_E', ('NO', 'MILD', 'MOD', 'SEV'))
        R_ULND5_LD_E = self.new_rv('R_ULND5_LD_E', ('NO', 'MILD', 'MOD', 'SEV'))
        R_OTHER_ULND5_RD = self.new_rv('R_OTHER_ULND5_RD', ('NO', 'MOD', 'SEV'))
        R_LNLE_ULND5_RD_E = self.new_rv('R_LNLE_ULND5_RD_E', ('NO', 'MOD', 'SEV'))
        R_ULND5_RD_E = self.new_rv('R_ULND5_RD_E', ('NO', 'MOD', 'SEV'))
        R_ULND5_LSLOW_E = self.new_rv('R_ULND5_LSLOW_E', ('NO', 'MILD', 'MOD', 'SEV', 'V_SEV'))
        R_OTHER_ULND5_SALOSS = self.new_rv('R_OTHER_ULND5_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_LNLW_ULND5_SALOSS = self.new_rv('R_LNLW_ULND5_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_DIFFN_ULND5_SALOSS = self.new_rv('R_DIFFN_ULND5_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_DIFFN_LNLW_ULND5_SALOSS = self.new_rv('R_DIFFN_LNLW_ULND5_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_LNLE_ULND5_SALOSS = self.new_rv('R_LNLE_ULND5_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_LNLLP_ULND5_SALOSS = self.new_rv('R_LNLLP_ULND5_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_LNLLP_E_ULND5_SALOSS = self.new_rv('R_LNLLP_E_ULND5_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_LNL_DIFFN_ULND5_SALOSS = self.new_rv('R_LNL_DIFFN_ULND5_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_ULND5_SALOSS = self.new_rv('R_ULND5_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_OTHER_ULND5_DIFSLOW = self.new_rv('R_OTHER_ULND5_DIFSLOW', ('NO', 'MILD', 'MOD', 'SEV'))
        R_LNLE_ULND5_DIFSLOW = self.new_rv('R_LNLE_ULND5_DIFSLOW', ('NO', 'MILD', 'MOD', 'SEV'))
        R_DIFFN_ULND5_DIFSLOW = self.new_rv('R_DIFFN_ULND5_DIFSLOW', ('NO', 'MILD', 'MOD', 'SEV'))
        R_LNLE_DIFFN_ULND5_DIFSLOW_E = self.new_rv('R_LNLE_DIFFN_ULND5_DIFSLOW_E', ('NO', 'MILD', 'MOD', 'SEV'))
        R_ULND5_DIFSLOW_E = self.new_rv('R_ULND5_DIFSLOW_E', ('NO', 'MILD', 'MOD', 'SEV'))
        R_ULND5_DSLOW_E = self.new_rv('R_ULND5_DSLOW_E',
                                      ('M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        R_ULND5_ALLCV_E = self.new_rv('R_ULND5_ALLCV_E',
                                      ('M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        R_ULND5_CV_E = self.new_rv('R_ULND5_CV_E', (
            'M_S00', 'M_S04', 'M_S08', 'M_S12', 'M_S16', 'M_S20', 'M_S24', 'M_S28', 'M_S32', 'M_S36', 'M_S40', 'M_S44',
            'M_S48', 'M_S52', 'M_S56', 'M_S60', 'M_S64', 'M_S68', 'M_S72', 'M_S_76'))
        R_ULND5_DISP_EWD = self.new_rv('R_ULND5_DISP_EWD', (
            'R0_15', 'R0_25', 'R0_35', 'R0_45', 'R0_55', 'R0_65', 'R0_75', 'R0_85', 'R0_95'))
        R_ULND5_BLOCK_EW = self.new_rv('R_ULND5_BLOCK_EW', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_ULND5_AMPR_EW = self.new_rv('R_ULND5_AMPR_EW', (
            'R0_0', 'R0_1', 'R0_2', 'R0_3', 'R0_4', 'R0_5', 'R0_6', 'R0_7', 'R0_8', 'R0_9', 'R1_0', 'R_1_1'))
        R_ULND5_DIFSLOW_EW = self.new_rv('R_ULND5_DIFSLOW_EW', ('NO', 'MILD', 'MOD', 'SEV'))
        R_ULND5_DSLOW_EW = self.new_rv('R_ULND5_DSLOW_EW', (
            'M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        R_ULND5_ALLCV_EW = self.new_rv('R_ULND5_ALLCV_EW', (
            'M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        R_ULND5_CV_EW = self.new_rv('R_ULND5_CV_EW', (
            'M_S00', 'M_S04', 'M_S08', 'M_S12', 'M_S16', 'M_S20', 'M_S24', 'M_S28', 'M_S32', 'M_S36', 'M_S40', 'M_S44',
            'M_S48', 'M_S52', 'M_S56', 'M_S60', 'M_S64', 'M_S68', 'M_S72', 'M_S_76'))
        R_LNLW_ULND5_BLOCK_WD = self.new_rv('R_LNLW_ULND5_BLOCK_WD', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_DIFFN_LNLW_ULND5_BLOCK_WD = self.new_rv('R_DIFFN_LNLW_ULND5_BLOCK_WD', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_ULND5_BLOCK_WD = self.new_rv('R_ULND5_BLOCK_WD', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_ULND5_EFFAXLOSS = self.new_rv('R_ULND5_EFFAXLOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_ULND5_ALLAMP_WD = self.new_rv('R_ULND5_ALLAMP_WD', ('ZERO', 'A0_01', 'A0_10', 'A0_30', 'A0_70', 'A1_00'))
        R_ULND5_AMP_WD = self.new_rv('R_ULND5_AMP_WD', (
            'UV_0_63', 'UV0_88', 'UV1_25', 'UV1_77', 'UV2_50', 'UV3_50', 'UV5_00', 'UV7_10', 'UV10_0', 'UV14_0',
            'UV20_0',
            'UV28_0', 'UV40_0', 'UV57_0', 'UV_80_0'))
        R_LNLW_ULND5_LD_WD = self.new_rv('R_LNLW_ULND5_LD_WD', ('NO', 'MILD', 'MOD', 'SEV'))
        R_ULND5_LD_WD = self.new_rv('R_ULND5_LD_WD', ('NO', 'MILD', 'MOD', 'SEV'))
        R_LNLW_ULND5_RD_WD = self.new_rv('R_LNLW_ULND5_RD_WD', ('NO', 'MOD', 'SEV'))
        R_ULND5_RD_WD = self.new_rv('R_ULND5_RD_WD', ('NO', 'MOD', 'SEV'))
        R_ULND5_LSLOW_WD = self.new_rv('R_ULND5_LSLOW_WD', ('NO', 'MILD', 'MOD', 'SEV', 'V_SEV'))
        R_LNLE_DIFFN_ULND5_DIFSLOW_WD = self.new_rv('R_LNLE_DIFFN_ULND5_DIFSLOW_WD', ('NO', 'MILD', 'MOD', 'SEV'))
        R_ULND5_DIFSLOW_WD = self.new_rv('R_ULND5_DIFSLOW_WD', ('NO', 'MILD', 'MOD', 'SEV'))
        R_ULND5_DSLOW_WD = self.new_rv('R_ULND5_DSLOW_WD', (
            'M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        R_ULND5_ALLCV_WD = self.new_rv('R_ULND5_ALLCV_WD', (
            'M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        R_ULND5_CV_WD = self.new_rv('R_ULND5_CV_WD', (
            'M_S00', 'M_S04', 'M_S08', 'M_S12', 'M_S16', 'M_S20', 'M_S24', 'M_S28', 'M_S32', 'M_S36', 'M_S40', 'M_S44',
            'M_S48', 'M_S52', 'M_S56', 'M_S60', 'M_S64', 'M_S68', 'M_S_72'))
        R_DIFFN_ULN_BLOCK = self.new_rv('R_DIFFN_ULN_BLOCK', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_LNLE_ULN_BLOCK = self.new_rv('R_LNLE_ULN_BLOCK', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_ULN_BLOCK_E = self.new_rv('R_ULN_BLOCK_E', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_ULN_AMPR_E = self.new_rv('R_ULN_AMPR_E', (
            'R_1_1', 'R1_0', 'R0_9', 'R0_8', 'R0_7', 'R0_6', 'R0_5', 'R0_4', 'R0_3', 'R0_2', 'R0_1', 'R0_0'))
        R_OTHER_ADM_MALOSS = self.new_rv('R_OTHER_ADM_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_LNLC8_ADM_MALOSS = self.new_rv('R_LNLC8_ADM_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_LNLLP_ADM_MALOSS = self.new_rv('R_LNLLP_ADM_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_LNLC8_LP_ADM_MALOSS = self.new_rv('R_LNLC8_LP_ADM_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_LNLE_ADM_MALOSS = self.new_rv('R_LNLE_ADM_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_LNLC8_LP_E_ADM_MALOSS = self.new_rv('R_LNLC8_LP_E_ADM_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_LNLW_ADM_MALOSS = self.new_rv('R_LNLW_ADM_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_DIFFN_ADM_MALOSS = self.new_rv('R_DIFFN_ADM_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_DIFFN_LNLW_ADM_MALOSS = self.new_rv('R_DIFFN_LNLW_ADM_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_LNL_DIFFN_ADM_MALOSS = self.new_rv('R_LNL_DIFFN_ADM_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_ADM_MALOSS = self.new_rv('R_ADM_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL', 'OTHER'))
        R_LNLE_ULN_DIFSLOW = self.new_rv('R_LNLE_ULN_DIFSLOW', ('NO', 'MILD', 'MOD', 'SEV'))
        R_DIFFN_ULN_DIFSLOW = self.new_rv('R_DIFFN_ULN_DIFSLOW', ('NO', 'MILD', 'MOD', 'SEV'))
        R_ULN_DIFSLOW_E = self.new_rv('R_ULN_DIFSLOW_E', ('NO', 'MILD', 'MOD', 'SEV'))
        R_ULN_DCV_E = self.new_rv('R_ULN_DCV_E', (
            'M_S60', 'M_S56', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        R_ULN_LD_EW = self.new_rv('R_ULN_LD_EW', ('NO', 'MILD', 'MOD', 'SEV'))
        R_ULN_RD_EW = self.new_rv('R_ULN_RD_EW', ('NO', 'MOD', 'SEV'))
        R_ULN_RDLDCV_E = self.new_rv('R_ULN_RDLDCV_E', ('M_S60', 'M_S52', 'M_S44', 'M_S27', 'M_S15', 'M_S07'))
        R_ULN_ALLCV_E = self.new_rv('R_ULN_ALLCV_E',
                                    ('M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        R_ULN_CV_E = self.new_rv('R_ULN_CV_E', (
            'M_S00', 'M_S04', 'M_S08', 'M_S12', 'M_S16', 'M_S20', 'M_S24', 'M_S28', 'M_S32', 'M_S36', 'M_S40', 'M_S44',
            'M_S48', 'M_S52', 'M_S56', 'M_S60', 'M_S64', 'M_S68', 'M_S72'))
        R_ULN_BLOCK_EW = self.new_rv('R_ULN_BLOCK_EW', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_ULN_AMPR_EW = self.new_rv('R_ULN_AMPR_EW', (
            'R_1_1', 'R1_0', 'R0_9', 'R0_8', 'R0_7', 'R0_6', 'R0_5', 'R0_4', 'R0_3', 'R0_2', 'R0_1', 'R0_0'))
        R_ULN_DIFSLOW_EW = self.new_rv('R_ULN_DIFSLOW_EW', ('NO', 'MILD', 'MOD', 'SEV'))
        R_ULN_DCV_EW = self.new_rv('R_ULN_DCV_EW', (
            'M_S60', 'M_S56', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        R_ULN_ALLCV_EW = self.new_rv('R_ULN_ALLCV_EW', (
            'M_S60', 'M_S56', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        R_ULN_CV_EW = self.new_rv('R_ULN_CV_EW', (
            'M_S00', 'M_S04', 'M_S08', 'M_S12', 'M_S16', 'M_S20', 'M_S24', 'M_S28', 'M_S32', 'M_S36', 'M_S40', 'M_S44',
            'M_S48', 'M_S52', 'M_S56', 'M_S60', 'M_S64', 'M_S68', 'M_S72'))
        R_OTHER_ADM_NMT = self.new_rv('R_OTHER_ADM_NMT',
                                      ('NO', 'MOD_PRE', 'SEV_PRE', 'MLD_POST', 'MOD_POST', 'SEV_POST', 'MIXED'))
        R_LNLC8_ADM_DE_REGEN = self.new_rv('R_LNLC8_ADM_DE_REGEN', ('NO', 'YES'))
        R_LNLLP_ADM_DE_REGEN = self.new_rv('R_LNLLP_ADM_DE_REGEN', ('NO', 'YES'))
        R_LNLC8_LP_ADM_DE_REGEN = self.new_rv('R_LNLC8_LP_ADM_DE_REGEN', ('NO', 'YES'))
        R_LNLE_ULN_TIME = self.new_rv('R_LNLE_ULN_TIME', ('ACUTE', 'SUBACUTE', 'CHRONIC', 'OLD'))
        R_LNLE_ADM_DE_REGEN = self.new_rv('R_LNLE_ADM_DE_REGEN', ('NO', 'YES'))
        R_LNLC8_LP_E_ADM_DE_REGEN = self.new_rv('R_LNLC8_LP_E_ADM_DE_REGEN', ('NO', 'YES'))
        R_DIFFN_ADM_DE_REGEN = self.new_rv('R_DIFFN_ADM_DE_REGEN', ('NO', 'YES'))
        R_LNLW_ADM_DE_REGEN = self.new_rv('R_LNLW_ADM_DE_REGEN', ('NO', 'YES'))
        R_DIFFN_LNLW_ADM_DE_REGEN = self.new_rv('R_DIFFN_LNLW_ADM_DE_REGEN', ('NO', 'YES'))
        R_LNL_DIFFN_ADM_DE_REGEN = self.new_rv('R_LNL_DIFFN_ADM_DE_REGEN', ('NO', 'YES'))
        R_MYOP_ADM_DE_REGEN = self.new_rv('R_MYOP_ADM_DE_REGEN', ('NO', 'YES'))
        R_MYDY_ADM_DE_REGEN = self.new_rv('R_MYDY_ADM_DE_REGEN', ('NO', 'YES'))
        R_MYOP_MYDY_ADM_DE_REGEN = self.new_rv('R_MYOP_MYDY_ADM_DE_REGEN', ('NO', 'YES'))
        R_OTHER_ADM_DE_REGEN = self.new_rv('R_OTHER_ADM_DE_REGEN', ('NO', 'YES'))
        R_MUSCLE_ADM_DE_REGEN = self.new_rv('R_MUSCLE_ADM_DE_REGEN', ('NO', 'YES'))
        R_ADM_DE_REGEN = self.new_rv('R_ADM_DE_REGEN', ('NO', 'YES'))
        R_DE_REGEN_ADM_NMT = self.new_rv('R_DE_REGEN_ADM_NMT',
                                         ('NO', 'MOD_PRE', 'SEV_PRE', 'MLD_POST', 'MOD_POST', 'SEV_POST', 'MIXED'))
        R_MYAS_ADM_NMT = self.new_rv('R_MYAS_ADM_NMT',
                                     ('NO', 'MOD_PRE', 'SEV_PRE', 'MLD_POST', 'MOD_POST', 'SEV_POST', 'MIXED'))
        R_MYAS_DE_REGEN_ADM_NMT = self.new_rv('R_MYAS_DE_REGEN_ADM_NMT',
                                              ('NO', 'MOD_PRE', 'SEV_PRE', 'MLD_POST', 'MOD_POST', 'SEV_POST', 'MIXED'))
        R_ADM_NMT = self.new_rv('R_ADM_NMT', ('NO', 'MOD_PRE', 'SEV_PRE', 'MLD_POST', 'MOD_POST', 'SEV_POST', 'MIXED'))
        R_OTHER_ADM_MUSIZE = self.new_rv('R_OTHER_ADM_MUSIZE',
                                         ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_MYDY_ADM_MUSIZE = self.new_rv('R_MYDY_ADM_MUSIZE', ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_MYOP_ADM_MUSIZE = self.new_rv('R_MYOP_ADM_MUSIZE', ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_MYOP_MYDY_ADM_MUSIZE = self.new_rv('R_MYOP_MYDY_ADM_MUSIZE',
                                             ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_MUSCLE_ADM_MUSIZE = self.new_rv('R_MUSCLE_ADM_MUSIZE',
                                          ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_LNLW_ADM_MUSIZE = self.new_rv('R_LNLW_ADM_MUSIZE', ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_DIFFN_ADM_MUSIZE = self.new_rv('R_DIFFN_ADM_MUSIZE',
                                         ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_DIFFN_LNLW_ADM_MUSIZE = self.new_rv('R_DIFFN_LNLW_ADM_MUSIZE',
                                              ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_LNLE_ADM_MUSIZE = self.new_rv('R_LNLE_ADM_MUSIZE', ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_LNLLP_ADM_MUSIZE = self.new_rv('R_LNLLP_ADM_MUSIZE',
                                         ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_LNLC8_ADM_MUSIZE = self.new_rv('R_LNLC8_ADM_MUSIZE',
                                         ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_LNLC8_LP_ADM_MUSIZE = self.new_rv('R_LNLC8_LP_ADM_MUSIZE',
                                            ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_LNLC8_LP_E_ADM_MUSIZE = self.new_rv('R_LNLC8_LP_E_ADM_MUSIZE',
                                              ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_LNL_DIFFN_ADM_MUSIZE = self.new_rv('R_LNL_DIFFN_ADM_MUSIZE',
                                             ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_ADM_MUSIZE = self.new_rv('R_ADM_MUSIZE', ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE', 'OTHER'))
        R_ADM_EFFMUS = self.new_rv('R_ADM_EFFMUS', ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE', 'OTHER'))
        R_OTHER_ULN_BLOCK_WA = self.new_rv('R_OTHER_ULN_BLOCK_WA', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_LNLW_ULN_BLOCK = self.new_rv('R_LNLW_ULN_BLOCK', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_DIFFN_LNLW_ULN_BLOCK_WA = self.new_rv('R_DIFFN_LNLW_ULN_BLOCK_WA', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_ULN_BLOCK_WA = self.new_rv('R_ULN_BLOCK_WA', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_ADM_MULOSS = self.new_rv('R_ADM_MULOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL', 'OTHER'))
        R_ADM_ALLAMP_WA = self.new_rv('R_ADM_ALLAMP_WA',
                                      ('ZERO', 'A0_01', 'A0_10', 'A0_30', 'A0_70', 'A1_00', 'A2_00', 'A4_00', 'A8_00'))
        R_ULN_AMP_WA = self.new_rv('R_ULN_AMP_WA', (
            'MV_000', 'MV_13', 'MV_18', 'MV_25', 'MV_35', 'MV_5', 'MV_71', 'MV1', 'MV1_4', 'MV2', 'MV2_8', 'MV4',
            'MV5_6',
            'MV8', 'MV11_3', 'MV16', 'MV22_6'))
        R_ULN_LD_WA = self.new_rv('R_ULN_LD_WA', ('NO', 'MILD', 'MOD', 'SEV'))
        R_ULN_RD_WA = self.new_rv('R_ULN_RD_WA', ('NO', 'MOD', 'SEV'))
        R_ULN_RDLDDEL = self.new_rv('R_ULN_RDLDDEL', ('MS3_1', 'MS3_9', 'MS4_7', 'MS10_1', 'MS20_1'))
        R_ULN_DIFSLOW_WA = self.new_rv('R_ULN_DIFSLOW_WA', ('NO', 'MILD', 'MOD', 'SEV'))
        R_ULN_DCV_WA = self.new_rv('R_ULN_DCV_WA',
                                   ('M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        R_ULN_ALLDEL_WA = self.new_rv('R_ULN_ALLDEL_WA', (
            'MS0_0', 'MS0_4', 'MS0_8', 'MS1_6', 'MS3_2', 'MS6_4', 'MS12_8', 'MS25_6', 'INFIN'))
        R_ULN_LAT_WA = self.new_rv('R_ULN_LAT_WA', (
            'MS2_3', 'MS2_7', 'MS3_1', 'MS3_5', 'MS3_9', 'MS4_3', 'MS4_7', 'MS5_3', 'MS5_9', 'MS6_5', 'MS7_1', 'MS8_0',
            'MS9_0', 'MS10_0', 'MS12_0', 'MS14_0', 'MS16_0', 'MS18_0', 'INFIN'))
        R_ADM_VOL_ACT = self.new_rv('R_ADM_VOL_ACT', ('NORMAL', 'REDUCED', 'V_RED', 'ABSENT'))
        R_ADM_FORCE = self.new_rv('R_ADM_FORCE', ('x5', 'x4', 'x3', 'x2', 'x1', 'x0'))
        R_ADM_MUSCLE_VOL = self.new_rv('R_ADM_MUSCLE_VOL', ('ATROPHIC', 'NORMAL'))
        R_ADM_MVA_RECRUIT = self.new_rv('R_ADM_MVA_RECRUIT', ('FULL', 'REDUCED', 'DISCRETE', 'NO_UNITS'))
        R_ADM_MVA_AMP = self.new_rv('R_ADM_MVA_AMP', ('INCR', 'NORMAL', 'REDUCED'))
        R_ADM_TA_CONCL = self.new_rv('R_ADM_TA_CONCL', ('x_5ABOVE', 'x2_5ABOVE', 'NORMAL', 'x2_5BELOW', 'x_5BELOW'))
        R_ADM_MUPAMP = self.new_rv('R_ADM_MUPAMP', ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE', 'OTHER'))
        R_ADM_QUAN_MUPAMP = self.new_rv('R_ADM_QUAN_MUPAMP', (
            'UV34', 'UV44', 'UV58', 'UV74', 'UV94', 'UV122', 'UV156', 'UV200', 'UV260', 'UV330', 'UV420', 'UV540',
            'UV700',
            'UV900', 'UV1150', 'UV1480', 'UV1900', 'UV2440', 'UV3130', 'UV4020'))
        R_ADM_QUAL_MUPAMP = self.new_rv('R_ADM_QUAL_MUPAMP', ('V_RED', 'REDUCED', 'NORMAL', 'INCR', 'V_INCR'))
        R_ADM_MUPDUR = self.new_rv('R_ADM_MUPDUR', ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE', 'OTHER'))
        R_ADM_QUAN_MUPDUR = self.new_rv('R_ADM_QUAN_MUPDUR', (
            'MS3', 'MS4', 'MS5', 'MS6', 'MS7', 'MS8', 'MS9', 'MS10', 'MS11', 'MS12', 'MS13', 'MS14', 'MS15', 'MS16',
            'MS17',
            'MS18', 'MS19', 'MS20', 'MS_20'))
        R_ADM_QUAL_MUPDUR = self.new_rv('R_ADM_QUAL_MUPDUR', ('SMALL', 'NORMAL', 'INCR'))
        R_ADM_QUAN_MUPPOLY = self.new_rv('R_ADM_QUAN_MUPPOLY', ('x_12_', 'x12_24_', 'x_24_'))
        R_ADM_QUAL_MUPPOLY = self.new_rv('R_ADM_QUAL_MUPPOLY', ('NORMAL', 'INCR'))
        R_ADM_MUPSATEL = self.new_rv('R_ADM_MUPSATEL', ('NO', 'YES'))
        R_ADM_MUPINSTAB = self.new_rv('R_ADM_MUPINSTAB', ('NO', 'YES'))
        R_ADM_REPSTIM_CMAPAMP = self.new_rv('R_ADM_REPSTIM_CMAPAMP', (
            'MV_000', 'MV_032', 'MV_044', 'MV_063', 'MV_088', 'MV_13', 'MV_18', 'MV_25', 'MV_35', 'MV_5', 'MV_71',
            'MV1',
            'MV1_4', 'MV2', 'MV2_8', 'MV4', 'MV5_6', 'MV8', 'MV11_3', 'MV16', 'MV22_6'))
        R_ADM_REPSTIM_DECR = self.new_rv('R_ADM_REPSTIM_DECR', ('NO', 'MILD', 'MOD', 'SEV', 'INCON'))
        R_ADM_REPSTIM_FACILI = self.new_rv('R_ADM_REPSTIM_FACILI', ('NO', 'MOD', 'SEV', 'REDUCED'))
        R_ADM_REPSTIM_POST_DECR = self.new_rv('R_ADM_REPSTIM_POST_DECR', ('NO', 'MILD', 'MOD', 'SEV', 'INCON'))
        R_ADM_SF_JITTER = self.new_rv('R_ADM_SF_JITTER', ('NORMAL', 'x2_5', 'x5_10', 'x_10'))
        R_LNLC8_ADM_MUDENS = self.new_rv('R_LNLC8_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_LNLLP_ADM_MUDENS = self.new_rv('R_LNLLP_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_LNLC8_LP_ADM_MUDENS = self.new_rv('R_LNLC8_LP_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_LNLE_ADM_MUDENS = self.new_rv('R_LNLE_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_LNLC8_LP_E_ADM_MUDENS = self.new_rv('R_LNLC8_LP_E_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_DIFFN_ADM_MUDENS = self.new_rv('R_DIFFN_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_LNLW_ADM_MUDENS = self.new_rv('R_LNLW_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_DIFFN_LNLW_ADM_MUDENS = self.new_rv('R_DIFFN_LNLW_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_LNL_DIFFN_ADM_MUDENS = self.new_rv('R_LNL_DIFFN_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_MYOP_ADM_MUDENS = self.new_rv('R_MYOP_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_MYDY_ADM_MUDENS = self.new_rv('R_MYDY_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_MYOP_MYDY_ADM_MUDENS = self.new_rv('R_MYOP_MYDY_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_MYAS_ADM_MUDENS = self.new_rv('R_MYAS_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_OTHER_ADM_MUDENS = self.new_rv('R_OTHER_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_MYAS_OTHER_ADM_MUDENS = self.new_rv('R_MYAS_OTHER_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_MUSCLE_ADM_MUDENS = self.new_rv('R_MUSCLE_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_ADM_MUDENS = self.new_rv('R_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_ADM_SF_DENSITY = self.new_rv('R_ADM_SF_DENSITY', ('x_2SD', 'x2_4SD', 'x_4SD'))
        R_LNLC8_ADM_NEUR_ACT = self.new_rv('R_LNLC8_ADM_NEUR_ACT',
                                           ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        R_LNLLP_ADM_NEUR_ACT = self.new_rv('R_LNLLP_ADM_NEUR_ACT',
                                           ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        R_LNLC8_LP_ADM_NEUR_ACT = self.new_rv('R_LNLC8_LP_ADM_NEUR_ACT',
                                              ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        R_LNLE_ADM_NEUR_ACT = self.new_rv('R_LNLE_ADM_NEUR_ACT',
                                          ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        R_LNLC8_LP_E_ADM_NEUR_ACT = self.new_rv('R_LNLC8_LP_E_ADM_NEUR_ACT',
                                                ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        R_DIFFN_ADM_NEUR_ACT = self.new_rv('R_DIFFN_ADM_NEUR_ACT',
                                           ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        R_LNLW_ADM_NEUR_ACT = self.new_rv('R_LNLW_ADM_NEUR_ACT',
                                          ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        R_DIFFN_LNLW_ADM_NEUR_ACT = self.new_rv('R_DIFFN_LNLW_ADM_NEUR_ACT',
                                                ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        R_LNL_DIFFN_ADM_NEUR_ACT = self.new_rv('R_LNL_DIFFN_ADM_NEUR_ACT',
                                               ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        R_OTHER_ADM_NEUR_ACT = self.new_rv('R_OTHER_ADM_NEUR_ACT',
                                           ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        R_ADM_NEUR_ACT = self.new_rv('R_ADM_NEUR_ACT', ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        R_ADM_SPONT_NEUR_DISCH = self.new_rv('R_ADM_SPONT_NEUR_DISCH',
                                             ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        R_MYOP_ADM_DENERV = self.new_rv('R_MYOP_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_MYDY_ADM_DENERV = self.new_rv('R_MYDY_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_MYOP_MYDY_ADM_DENERV = self.new_rv('R_MYOP_MYDY_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_OTHER_ADM_DENERV = self.new_rv('R_OTHER_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_NMT_ADM_DENERV = self.new_rv('R_NMT_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_OTHER_NMT_ADM_DENERV = self.new_rv('R_OTHER_NMT_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_MUSCLE_ADM_DENERV = self.new_rv('R_MUSCLE_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_LNLC8_ADM_DENERV = self.new_rv('R_LNLC8_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_LNLLP_ADM_DENERV = self.new_rv('R_LNLLP_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_LNLC8_LP_ADM_DENERV = self.new_rv('R_LNLC8_LP_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_LNLE_ADM_DENERV = self.new_rv('R_LNLE_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_LNLC8_LP_E_ADM_DENERV = self.new_rv('R_LNLC8_LP_E_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_DIFFN_ADM_DENERV = self.new_rv('R_DIFFN_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_LNLW_ADM_DENERV = self.new_rv('R_LNLW_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_DIFFN_LNLW_ADM_DENERV = self.new_rv('R_DIFFN_LNLW_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_LNL_DIFFN_ADM_DENERV = self.new_rv('R_LNL_DIFFN_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_ADM_DENERV = self.new_rv('R_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_ADM_SPONT_DENERV_ACT = self.new_rv('R_ADM_SPONT_DENERV_ACT', ('NO', 'SOME', 'MOD', 'ABUNDANT'))
        R_ADM_SPONT_HF_DISCH = self.new_rv('R_ADM_SPONT_HF_DISCH', ('NO', 'YES'))
        R_ADM_SPONT_INS_ACT = self.new_rv('R_ADM_SPONT_INS_ACT', ('NORMAL', 'INCR'))
        R_OTHER_DELT_NMT = self.new_rv('R_OTHER_DELT_NMT',
                                       ('NO', 'MOD_PRE', 'SEV_PRE', 'MLD_POST', 'MOD_POST', 'SEV_POST', 'MIXED'))
        R_LNLPC5_AXIL_SEV = self.new_rv('R_LNLPC5_AXIL_SEV', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_LNLPC5_AXIL_TIME = self.new_rv('R_LNLPC5_AXIL_TIME', ('ACUTE', 'SUBACUTE', 'CHRONIC', 'OLD'))
        R_LNLPC5_AXIL_PATHO = self.new_rv('R_LNLPC5_AXIL_PATHO', ('DEMY', 'BLOCK', 'AXONAL', 'V_E_REIN', 'E_REIN'))
        R_LNLPC5_DELT_DE_REGEN = self.new_rv('R_LNLPC5_DELT_DE_REGEN', ('NO', 'YES'))
        R_DIFFN_DELT_DE_REGEN = self.new_rv('R_DIFFN_DELT_DE_REGEN', ('NO', 'YES'))
        R_LNLPC5_DIFFN_DELT_DE_REGEN = self.new_rv('R_LNLPC5_DIFFN_DELT_DE_REGEN', ('NO', 'YES'))
        R_MYOP_DELT_DE_REGEN = self.new_rv('R_MYOP_DELT_DE_REGEN', ('NO', 'YES'))
        R_MYDY_DELT_DE_REGEN = self.new_rv('R_MYDY_DELT_DE_REGEN', ('NO', 'YES'))
        R_MYOP_MYDY_DELT_DE_REGEN = self.new_rv('R_MYOP_MYDY_DELT_DE_REGEN', ('NO', 'YES'))
        R_OTHER_DELT_DE_REGEN = self.new_rv('R_OTHER_DELT_DE_REGEN', ('NO', 'YES'))
        R_MUSCLE_DELT_DE_REGEN = self.new_rv('R_MUSCLE_DELT_DE_REGEN', ('NO', 'YES'))
        R_DELT_DE_REGEN = self.new_rv('R_DELT_DE_REGEN', ('NO', 'YES'))
        R_DE_REGEN_DELT_NMT = self.new_rv('R_DE_REGEN_DELT_NMT',
                                          ('NO', 'MOD_PRE', 'SEV_PRE', 'MLD_POST', 'MOD_POST', 'SEV_POST', 'MIXED'))
        R_MYAS_DELT_NMT = self.new_rv('R_MYAS_DELT_NMT',
                                      ('NO', 'MOD_PRE', 'SEV_PRE', 'MLD_POST', 'MOD_POST', 'SEV_POST', 'MIXED'))
        R_MYAS_DE_REGEN_DELT_NMT = self.new_rv('R_MYAS_DE_REGEN_DELT_NMT', (
            'NO', 'MOD_PRE', 'SEV_PRE', 'MLD_POST', 'MOD_POST', 'SEV_POST', 'MIXED'))
        R_DELT_NMT = self.new_rv('R_DELT_NMT',
                                 ('NO', 'MOD_PRE', 'SEV_PRE', 'MLD_POST', 'MOD_POST', 'SEV_POST', 'OTHER'))
        R_OTHER_DELT_MUSIZE = self.new_rv('R_OTHER_DELT_MUSIZE',
                                          ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_MYDY_DELT_MUSIZE = self.new_rv('R_MYDY_DELT_MUSIZE',
                                         ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_MYOP_DELT_MUSIZE = self.new_rv('R_MYOP_DELT_MUSIZE',
                                         ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_MYOP_MYDY_DELT_MUSIZE = self.new_rv('R_MYOP_MYDY_DELT_MUSIZE',
                                              ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_MUSCLE_DELT_MUSIZE = self.new_rv('R_MUSCLE_DELT_MUSIZE',
                                           ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_DIFFN_DELT_MUSIZE = self.new_rv('R_DIFFN_DELT_MUSIZE',
                                          ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_LNLPC5_DELT_MUSIZE = self.new_rv('R_LNLPC5_DELT_MUSIZE',
                                           ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_LNLPC5_DIFFN_DELT_MUSIZE = self.new_rv('R_LNLPC5_DIFFN_DELT_MUSIZE',
                                                 ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        R_DELT_MUSIZE = self.new_rv('R_DELT_MUSIZE',
                                    ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE', 'OTHER'))
        R_DELT_EFFMUS = self.new_rv('R_DELT_EFFMUS',
                                    ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE', 'OTHER'))
        R_DIFFN_AXIL_BLOCK = self.new_rv('R_DIFFN_AXIL_BLOCK', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_OTHER_AXIL_BLOCK = self.new_rv('R_OTHER_AXIL_BLOCK', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_AXIL_BLOCK_ED = self.new_rv('R_AXIL_BLOCK_ED', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_LNLPC5_DELT_MALOSS = self.new_rv('R_LNLPC5_DELT_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_DIFFN_DELT_MALOSS = self.new_rv('R_DIFFN_DELT_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_LNLPC5_DIFFN_DELT_MALOSS = self.new_rv('R_LNLPC5_DIFFN_DELT_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_OTHER_DELT_MALOSS = self.new_rv('R_OTHER_DELT_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_DELT_MALOSS = self.new_rv('R_DELT_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL', 'OTHER'))
        R_DELT_MULOSS = self.new_rv('R_DELT_MULOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL', 'OTHER'))
        R_DELT_ALLAMP = self.new_rv('R_DELT_ALLAMP',
                                    ('ZERO', 'A0_01', 'A0_10', 'A0_30', 'A0_70', 'A1_00', 'A2_00', 'A4_00', 'A8_00'))
        R_AXIL_AMP_E = self.new_rv('R_AXIL_AMP_E', (
            'MV_000', 'MV_13', 'MV_18', 'MV_25', 'MV_35', 'MV_5', 'MV_71', 'MV1', 'MV1_4', 'MV2', 'MV2_8', 'MV4',
            'MV5_6',
            'MV8', 'MV11_3', 'MV16', 'MV22_6'))
        R_AXIL_RD_ED = self.new_rv('R_AXIL_RD_ED', ('NO', 'MOD', 'SEV'))
        R_LNLPC5_AXIL_DIFSLOW = self.new_rv('R_LNLPC5_AXIL_DIFSLOW', ('NO', 'MILD', 'MOD', 'SEV'))
        R_DIFFN_AXIL_DIFSLOW = self.new_rv('R_DIFFN_AXIL_DIFSLOW', ('NO', 'MILD', 'MOD', 'SEV'))
        R_AXIL_DIFSLOW_ED = self.new_rv('R_AXIL_DIFSLOW_ED', ('NO', 'MILD', 'MOD', 'SEV'))
        R_AXIL_DCV = self.new_rv('R_AXIL_DCV',
                                 ('M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        R_AXIL_DEL = self.new_rv('R_AXIL_DEL',
                                 ('MS0_0', 'MS0_4', 'MS0_8', 'MS1_6', 'MS3_2', 'MS6_4', 'MS12_8', 'MS25_6', 'INFIN'))
        R_AXIL_LAT_ED = self.new_rv('R_AXIL_LAT_ED', (
            'MS3_1', 'MS3_5', 'MS3_9', 'MS4_3', 'MS4_7', 'MS5_3', 'MS5_9', 'MS6_5', 'MS7_1', 'MS8_0', 'MS9_0', 'MS10_0',
            'MS12_0', 'MS14_0', 'MS16_0', 'MS18_0', 'INFIN'))
        R_DELT_VOL_ACT = self.new_rv('R_DELT_VOL_ACT', ('NORMAL', 'REDUCED', 'V_RED', 'ABSENT'))
        R_DELT_FORCE = self.new_rv('R_DELT_FORCE', ('x5', 'x4', 'x3', 'x2', 'x1', 'x0'))
        R_DELT_MUSCLE_VOL = self.new_rv('R_DELT_MUSCLE_VOL', ('ATROPHIC', 'NORMAL'))
        R_DELT_MVA_RECRUIT = self.new_rv('R_DELT_MVA_RECRUIT', ('FULL', 'REDUCED', 'DISCRETE', 'NO_UNITS'))
        R_DELT_MVA_AMP = self.new_rv('R_DELT_MVA_AMP', ('INCR', 'NORMAL', 'REDUCED'))
        R_DELT_TA_CONCL = self.new_rv('R_DELT_TA_CONCL', ('x_5ABOVE', 'x2_5ABOVE', 'NORMAL', 'x2_5BELOW', 'x_5BELOW'))
        R_DELT_MUPAMP = self.new_rv('R_DELT_MUPAMP',
                                    ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE', 'OTHER'))
        R_DELT_QUAN_MUPAMP = self.new_rv('R_DELT_QUAN_MUPAMP', (
            'UV34', 'UV44', 'UV58', 'UV74', 'UV94', 'UV122', 'UV156', 'UV200', 'UV260', 'UV330', 'UV420', 'UV540',
            'UV700',
            'UV900', 'UV1150', 'UV1480', 'UV1900', 'UV2440', 'UV3130', 'UV4020'))
        R_DELT_QUAL_MUPAMP = self.new_rv('R_DELT_QUAL_MUPAMP', ('V_RED', 'REDUCED', 'NORMAL', 'INCR', 'V_INCR'))
        R_DELT_MUPDUR = self.new_rv('R_DELT_MUPDUR',
                                    ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE', 'OTHER'))
        R_DELT_QUAN_MUPDUR = self.new_rv('R_DELT_QUAN_MUPDUR', (
            'MS3', 'MS4', 'MS5', 'MS6', 'MS7', 'MS8', 'MS9', 'MS10', 'MS11', 'MS12', 'MS13', 'MS14', 'MS15', 'MS16',
            'MS17',
            'MS18', 'MS19', 'MS20', 'MS_20'))
        R_DELT_QUAL_MUPDUR = self.new_rv('R_DELT_QUAL_MUPDUR', ('SMALL', 'NORMAL', 'INCR'))
        R_DELT_QUAN_MUPPOLY = self.new_rv('R_DELT_QUAN_MUPPOLY', ('x_12_', 'x12_24_', 'x_24_'))
        R_DELT_QUAL_MUPPOLY = self.new_rv('R_DELT_QUAL_MUPPOLY', ('NORMAL', 'INCR'))
        R_DELT_MUPSATEL = self.new_rv('R_DELT_MUPSATEL', ('NO', 'YES'))
        R_DELT_MUPINSTAB = self.new_rv('R_DELT_MUPINSTAB', ('NO', 'YES'))
        R_DELT_REPSTIM_CMAPAMP = self.new_rv('R_DELT_REPSTIM_CMAPAMP', (
            'MV_000', 'MV_032', 'MV_044', 'MV_063', 'MV_088', 'MV_13', 'MV_18', 'MV_25', 'MV_35', 'MV_5', 'MV_71',
            'MV1',
            'MV1_4', 'MV2', 'MV2_8', 'MV4', 'MV5_6', 'MV8', 'MV11_3', 'MV16', 'MV22_6'))
        R_DELT_REPSTIM_DECR = self.new_rv('R_DELT_REPSTIM_DECR', ('NO', 'MILD', 'MOD', 'SEV', 'INCON'))
        R_DELT_REPSTIM_FACILI = self.new_rv('R_DELT_REPSTIM_FACILI', ('NO', 'MOD', 'SEV', 'REDUCED'))
        R_DELT_REPSTIM_POST_DECR = self.new_rv('R_DELT_REPSTIM_POST_DECR', ('NO', 'MILD', 'MOD', 'SEV', 'INCON'))
        R_DELT_SF_JITTER = self.new_rv('R_DELT_SF_JITTER', ('NORMAL', 'x2_5', 'x5_10', 'x_10'))
        R_LNLPC5_DELT_MUDENS = self.new_rv('R_LNLPC5_DELT_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_DIFFN_DELT_MUDENS = self.new_rv('R_DIFFN_DELT_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_LNLPC5_DIFFN_DELT_MUDENS = self.new_rv('R_LNLPC5_DIFFN_DELT_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_MYOP_DELT_MUDENS = self.new_rv('R_MYOP_DELT_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_MYDY_DELT_MUDENS = self.new_rv('R_MYDY_DELT_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_MYOP_MYDY_DELT_MUDENS = self.new_rv('R_MYOP_MYDY_DELT_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_MYAS_DELT_MUDENS = self.new_rv('R_MYAS_DELT_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_OTHER_DELT_MUDENS = self.new_rv('R_OTHER_DELT_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_MYAS_OTHER_DELT_MUDENS = self.new_rv('R_MYAS_OTHER_DELT_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_MUSCLE_DELT_MUDENS = self.new_rv('R_MUSCLE_DELT_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_DELT_MUDENS = self.new_rv('R_DELT_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        R_DELT_SF_DENSITY = self.new_rv('R_DELT_SF_DENSITY', ('x_2SD', 'x2_4SD', 'x_4SD'))
        R_LNLPC5_DELT_NEUR_ACT = self.new_rv('R_LNLPC5_DELT_NEUR_ACT',
                                             ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        R_DIFFN_DELT_NEUR_ACT = self.new_rv('R_DIFFN_DELT_NEUR_ACT',
                                            ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        R_LNLPC5_DIFFN_DELT_NEUR_ACT = self.new_rv('R_LNLPC5_DIFFN_DELT_NEUR_ACT',
                                                   ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        R_OTHER_DELT_NEUR_ACT = self.new_rv('R_OTHER_DELT_NEUR_ACT',
                                            ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        R_DELT_NEUR_ACT = self.new_rv('R_DELT_NEUR_ACT', ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        R_DELT_SPONT_NEUR_DISCH = self.new_rv('R_DELT_SPONT_NEUR_DISCH',
                                              ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        R_MYOP_DELT_DENERV = self.new_rv('R_MYOP_DELT_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_MYDY_DELT_DENERV = self.new_rv('R_MYDY_DELT_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_MYOP_MYDY_DELT_DENERV = self.new_rv('R_MYOP_MYDY_DELT_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_OTHER_DELT_DENERV = self.new_rv('R_OTHER_DELT_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_NMT_DELT_DENERV = self.new_rv('R_NMT_DELT_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_OTHER_NMT_DELT_DENERV = self.new_rv('R_OTHER_NMT_DELT_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_MUSCLE_DELT_DENERV = self.new_rv('R_MUSCLE_DELT_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_LNLPC5_DELT_DENERV = self.new_rv('R_LNLPC5_DELT_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_DIFFN_DELT_DENERV = self.new_rv('R_DIFFN_DELT_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_LNLPC5_DIFFN_DELT_DENERV = self.new_rv('R_LNLPC5_DIFFN_DELT_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_DELT_DENERV = self.new_rv('R_DELT_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        R_DELT_SPONT_DENERV_ACT = self.new_rv('R_DELT_SPONT_DENERV_ACT', ('NO', 'SOME', 'MOD', 'ABUNDANT'))
        R_DELT_SPONT_HF_DISCH = self.new_rv('R_DELT_SPONT_HF_DISCH', ('NO', 'YES'))
        R_DELT_SPONT_INS_ACT = self.new_rv('R_DELT_SPONT_INS_ACT', ('NORMAL', 'INCR'))
        R_OTHER_ISCH_DISP = self.new_rv('R_OTHER_ISCH_DISP', ('NO', 'MILD', 'MOD', 'SEV'))
        R_DIFFN_ISCH_DISP = self.new_rv('R_DIFFN_ISCH_DISP', ('NO', 'MILD', 'MOD', 'SEV'))
        R_SUR_DISP_CA = self.new_rv('R_SUR_DISP_CA', ('NO', 'MILD', 'MOD', 'SEV'))
        R_OTHER_ISCH_BLOCK = self.new_rv('R_OTHER_ISCH_BLOCK', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_DIFFN_ISCH_BLOCK = self.new_rv('R_DIFFN_ISCH_BLOCK', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_SUR_BLOCK_CA = self.new_rv('R_SUR_BLOCK_CA', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_OTHER_ISCH_SALOSS = self.new_rv('R_OTHER_ISCH_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_DIFFN_ISCH_SALOSS = self.new_rv('R_DIFFN_ISCH_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_LNL_ISCH_SEV = self.new_rv('R_LNL_ISCH_SEV', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_LNL_ISCH_PATHO = self.new_rv('R_LNL_ISCH_PATHO', ('DEMY', 'BLOCK', 'AXONAL', 'V_E_REIN', 'E_REIN'))
        R_LNL_ISCH_SALOSS_CA = self.new_rv('R_LNL_ISCH_SALOSS_CA', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_DIFFN_LNL_ISCH_SALOSS = self.new_rv('R_DIFFN_LNL_ISCH_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_SUR_SALOSS = self.new_rv('R_SUR_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_SUR_EFFAXLOSS = self.new_rv('R_SUR_EFFAXLOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        R_SUR_ALLAMP_CA = self.new_rv('R_SUR_ALLAMP_CA', ('ZERO', 'A0_01', 'A0_10', 'A0_30', 'A0_70', 'A1_00'))
        R_SUR_AMP_CA = self.new_rv('R_SUR_AMP_CA', (
            'UV_0_63', 'UV0_88', 'UV1_25', 'UV1_77', 'UV2_50', 'UV3_50', 'UV5_00', 'UV7_10', 'UV10_0', 'UV14_0',
            'UV20_0',
            'UV28_0', 'UV_40_0'))
        R_SUR_LD_CA = self.new_rv('R_SUR_LD_CA', ('NO', 'MILD', 'MOD', 'SEV'))
        R_SUR_RD_CA = self.new_rv('R_SUR_RD_CA', ('NO', 'MOD', 'SEV'))
        R_SUR_LSLOW_CA = self.new_rv('R_SUR_LSLOW_CA', ('NO', 'MILD', 'MOD', 'SEV', 'V_SEV'))
        R_OTHER_ISCH_DIFSLOW = self.new_rv('R_OTHER_ISCH_DIFSLOW', ('NO', 'MILD', 'MOD', 'SEV'))
        R_DIFFN_ISCH_DIFSLOW = self.new_rv('R_DIFFN_ISCH_DIFSLOW', ('NO', 'MILD', 'MOD', 'SEV'))
        R_SUR_DIFSLOW_CA = self.new_rv('R_SUR_DIFSLOW_CA', ('NO', 'MILD', 'MOD', 'SEV'))
        R_SUR_DSLOW_CA = self.new_rv('R_SUR_DSLOW_CA',
                                     ('M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        R_SUR_ALLCV_CA = self.new_rv('R_SUR_ALLCV_CA',
                                     ('M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        R_SUR_CV_CA = self.new_rv('R_SUR_CV_CA', (
            'M_S00', 'M_S04', 'M_S08', 'M_S12', 'M_S16', 'M_S20', 'M_S24', 'M_S28', 'M_S32', 'M_S36', 'M_S40', 'M_S44',
            'M_S48', 'M_S52', 'M_S56', 'M_S60', 'M_S_64'))
        L_LNLW_MED_SEV = self.new_rv('L_LNLW_MED_SEV', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_LNLW_MED_PATHO = self.new_rv('L_LNLW_MED_PATHO', ('DEMY', 'BLOCK', 'AXONAL', 'V_E_REIN', 'E_REIN'))
        L_LNLW_MEDD2_DISP_WD = self.new_rv('L_LNLW_MEDD2_DISP_WD', ('NO', 'MILD', 'MOD', 'SEV'))
        L_DIFFN_MEDD2_DISP = self.new_rv('L_DIFFN_MEDD2_DISP', ('NO', 'MILD', 'MOD', 'SEV'))
        L_DIFFN_LNLW_MEDD2_DISP_WD = self.new_rv('L_DIFFN_LNLW_MEDD2_DISP_WD', ('NO', 'MILD', 'MOD', 'SEV'))
        L_MEDD2_DISP_WD = self.new_rv('L_MEDD2_DISP_WD', ('NO', 'MILD', 'MOD', 'SEV'))
        L_LNLBE_MEDD2_DISP_EW = self.new_rv('L_LNLBE_MEDD2_DISP_EW', ('NO', 'MILD', 'MOD', 'SEV'))
        L_MEDD2_DISP_EW = self.new_rv('L_MEDD2_DISP_EW', ('NO', 'MILD', 'MOD', 'SEV'))
        L_MEDD2_DISP_EWD = self.new_rv('L_MEDD2_DISP_EWD', (
            'R0_15', 'R0_25', 'R0_35', 'R0_45', 'R0_55', 'R0_65', 'R0_75', 'R0_85', 'R0_95'))
        L_DIFFN_MEDD2_BLOCK = self.new_rv('L_DIFFN_MEDD2_BLOCK', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_LNLBE_MEDD2_BLOCK_EW = self.new_rv('L_LNLBE_MEDD2_BLOCK_EW', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_MEDD2_BLOCK_EW = self.new_rv('L_MEDD2_BLOCK_EW', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_MEDD2_AMPR_EW = self.new_rv('L_MEDD2_AMPR_EW', (
            'R0_0', 'R0_1', 'R0_2', 'R0_3', 'R0_4', 'R0_5', 'R0_6', 'R0_7', 'R0_8', 'R0_9', 'R1_0', 'R_1_1'))
        L_LNLBE_MEDD2_LD_EW = self.new_rv('L_LNLBE_MEDD2_LD_EW', ('NO', 'MILD', 'MOD', 'SEV'))
        L_MEDD2_LD_EW = self.new_rv('L_MEDD2_LD_EW', ('NO', 'MILD', 'MOD', 'SEV'))
        L_LNLBE_MEDD2_RD_EW = self.new_rv('L_LNLBE_MEDD2_RD_EW', ('NO', 'MOD', 'SEV'))
        L_MEDD2_RD_EW = self.new_rv('L_MEDD2_RD_EW', ('NO', 'MOD', 'SEV'))
        L_MEDD2_LSLOW_EW = self.new_rv('L_MEDD2_LSLOW_EW', ('NO', 'MILD', 'MOD', 'SEV', 'V_SEV'))
        L_LNLW_MEDD2_SALOSS_WD = self.new_rv('L_LNLW_MEDD2_SALOSS_WD', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_DIFFN_MEDD2_SALOSS = self.new_rv('L_DIFFN_MEDD2_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_DIFFN_LNLW_MEDD2_SALOSS = self.new_rv('L_DIFFN_LNLW_MEDD2_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_LNLBE_MEDD2_SALOSS_EW = self.new_rv('L_LNLBE_MEDD2_SALOSS_EW', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_MEDD2_SALOSS = self.new_rv('L_MEDD2_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_DIFFN_MEDD2_DIFSLOW = self.new_rv('L_DIFFN_MEDD2_DIFSLOW', ('NO', 'MILD', 'MOD', 'SEV'))
        L_MEDD2_DIFSLOW_EW = self.new_rv('L_MEDD2_DIFSLOW_EW', ('NO', 'MILD', 'MOD', 'SEV'))
        L_MEDD2_DSLOW_EW = self.new_rv('L_MEDD2_DSLOW_EW', (
            'M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        L_MEDD2_ALLCV_EW = self.new_rv('L_MEDD2_ALLCV_EW', (
            'M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        L_MEDD2_CV_EW = self.new_rv('L_MEDD2_CV_EW', (
            'M_S00', 'M_S04', 'M_S08', 'M_S12', 'M_S16', 'M_S20', 'M_S24', 'M_S28', 'M_S32', 'M_S36', 'M_S40', 'M_S44',
            'M_S48', 'M_S52', 'M_S56', 'M_S60', 'M_S64', 'M_S68', 'M_S72', 'M_S_76'))
        L_LNLW_MEDD2_BLOCK_WD = self.new_rv('L_LNLW_MEDD2_BLOCK_WD', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_MEDD2_BLOCK_WD = self.new_rv('L_MEDD2_BLOCK_WD', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_MEDD2_EFFAXLOSS = self.new_rv('L_MEDD2_EFFAXLOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_MEDD2_ALLAMP_WD = self.new_rv('L_MEDD2_ALLAMP_WD', ('ZERO', 'A0_01', 'A0_10', 'A0_30', 'A0_70', 'A1_00'))
        L_MEDD2_AMP_WD = self.new_rv('L_MEDD2_AMP_WD', (
            'UV_0_63', 'UV0_88', 'UV1_25', 'UV1_77', 'UV2_50', 'UV3_50', 'UV5_00', 'UV7_10', 'UV10_0', 'UV14_0',
            'UV20_0',
            'UV28_0', 'UV40_0', 'UV57_0', 'UV_80_0'))
        L_LNLW_MEDD2_LD_WD = self.new_rv('L_LNLW_MEDD2_LD_WD', ('NO', 'MILD', 'MOD', 'SEV'))
        L_MEDD2_LD_WD = self.new_rv('L_MEDD2_LD_WD', ('NO', 'MILD', 'MOD', 'SEV'))
        L_LNLW_MEDD2_RD_WD = self.new_rv('L_LNLW_MEDD2_RD_WD', ('NO', 'MOD', 'SEV'))
        L_MEDD2_RD_WD = self.new_rv('L_MEDD2_RD_WD', ('NO', 'MOD', 'SEV'))
        L_MEDD2_LSLOW_WD = self.new_rv('L_MEDD2_LSLOW_WD', ('NO', 'MILD', 'MOD', 'SEV', 'V_SEV'))
        L_LNLBE_MEDD2_DIFSLOW_WD = self.new_rv('L_LNLBE_MEDD2_DIFSLOW_WD', ('NO', 'MILD', 'MOD', 'SEV'))
        L_MEDD2_DIFSLOW_WD = self.new_rv('L_MEDD2_DIFSLOW_WD', ('NO', 'MILD', 'MOD', 'SEV'))
        L_MEDD2_DSLOW_WD = self.new_rv('L_MEDD2_DSLOW_WD', (
            'M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        L_MEDD2_ALLCV_WD = self.new_rv('L_MEDD2_ALLCV_WD', (
            'M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        L_MEDD2_CV_WD = self.new_rv('L_MEDD2_CV_WD', (
            'M_S00', 'M_S04', 'M_S08', 'M_S12', 'M_S16', 'M_S20', 'M_S24', 'M_S28', 'M_S32', 'M_S36', 'M_S40', 'M_S44',
            'M_S48', 'M_S52', 'M_S56', 'M_S60', 'M_S64', 'M_S68', 'M_S_72'))
        L_DIFFN_MED_BLOCK = self.new_rv('L_DIFFN_MED_BLOCK', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_LNLBE_MED_BLOCK = self.new_rv('L_LNLBE_MED_BLOCK', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_MED_BLOCK_EW = self.new_rv('L_MED_BLOCK_EW', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_MED_AMPR_EW = self.new_rv('L_MED_AMPR_EW', (
            'R_1_1', 'R1_0', 'R0_9', 'R0_8', 'R0_7', 'R0_6', 'R0_5', 'R0_4', 'R0_3', 'R0_2', 'R0_1', 'R0_0'))
        L_LNLT1_APB_MALOSS = self.new_rv('L_LNLT1_APB_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_LNLLP_APB_MALOSS = self.new_rv('L_LNLLP_APB_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_LNLT1_LP_APB_MALOSS = self.new_rv('L_LNLT1_LP_APB_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_LNLBE_APB_MALOSS = self.new_rv('L_LNLBE_APB_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_LNLT1_LP_BE_APB_MALOSS = self.new_rv('L_LNLT1_LP_BE_APB_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_LNLW_APB_MALOSS = self.new_rv('L_LNLW_APB_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_DIFFN_APB_MALOSS = self.new_rv('L_DIFFN_APB_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_DIFFN_LNLW_APB_MALOSS = self.new_rv('L_DIFFN_LNLW_APB_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_APB_MALOSS = self.new_rv('L_APB_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL', 'OTHER'))
        L_DIFFN_MED_DIFSLOW = self.new_rv('L_DIFFN_MED_DIFSLOW', ('NO', 'MILD', 'MOD', 'SEV'))
        L_MED_DIFSLOW_EW = self.new_rv('L_MED_DIFSLOW_EW', ('NO', 'MILD', 'MOD', 'SEV'))
        L_MED_DCV_EW = self.new_rv('L_MED_DCV_EW', (
            'M_S60', 'M_S56', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        L_MED_LD_EW = self.new_rv('L_MED_LD_EW', ('NO', 'MILD', 'MOD', 'SEV'))
        L_MED_RD_EW = self.new_rv('L_MED_RD_EW', ('NO', 'MOD', 'SEV'))
        L_MED_RDLDCV_EW = self.new_rv('L_MED_RDLDCV_EW', ('M_S60', 'M_S52', 'M_S44', 'M_S27', 'M_S15', 'M_S07'))
        L_MED_ALLCV_EW = self.new_rv('L_MED_ALLCV_EW', (
            'M_S60', 'M_S56', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        L_MED_CV_EW = self.new_rv('L_MED_CV_EW', (
            'M_S00', 'M_S04', 'M_S08', 'M_S12', 'M_S16', 'M_S20', 'M_S24', 'M_S28', 'M_S32', 'M_S36', 'M_S40', 'M_S44',
            'M_S48', 'M_S52', 'M_S56', 'M_S60', 'M_S64', 'M_S68', 'M_S72'))
        L_LNLT1_APB_DE_REGEN = self.new_rv('L_LNLT1_APB_DE_REGEN', ('NO', 'YES'))
        L_LNLLP_APB_DE_REGEN = self.new_rv('L_LNLLP_APB_DE_REGEN', ('NO', 'YES'))
        L_LNLT1_LP_APB_DE_REGEN = self.new_rv('L_LNLT1_LP_APB_DE_REGEN', ('NO', 'YES'))
        L_LNLBE_APB_DE_REGEN = self.new_rv('L_LNLBE_APB_DE_REGEN', ('NO', 'YES'))
        L_LNLT1_LP_BE_APB_DE_REGEN = self.new_rv('L_LNLT1_LP_BE_APB_DE_REGEN', ('NO', 'YES'))
        L_DIFFN_APB_DE_REGEN = self.new_rv('L_DIFFN_APB_DE_REGEN', ('NO', 'YES'))
        L_LNLW_MED_TIME = self.new_rv('L_LNLW_MED_TIME', ('ACUTE', 'SUBACUTE', 'CHRONIC', 'OLD'))
        L_LNLW_APB_DE_REGEN = self.new_rv('L_LNLW_APB_DE_REGEN', ('NO', 'YES'))
        L_DIFFN_LNLW_APB_DE_REGEN = self.new_rv('L_DIFFN_LNLW_APB_DE_REGEN', ('NO', 'YES'))
        L_LNL_DIFFN_APB_DE_REGEN = self.new_rv('L_LNL_DIFFN_APB_DE_REGEN', ('NO', 'YES'))
        L_MYOP_APB_DE_REGEN = self.new_rv('L_MYOP_APB_DE_REGEN', ('NO', 'YES'))
        L_MYDY_APB_DE_REGEN = self.new_rv('L_MYDY_APB_DE_REGEN', ('NO', 'YES'))
        L_MYOP_MYDY_APB_DE_REGEN = self.new_rv('L_MYOP_MYDY_APB_DE_REGEN', ('NO', 'YES'))
        L_APB_DE_REGEN = self.new_rv('L_APB_DE_REGEN', ('NO', 'YES'))
        L_DE_REGEN_APB_NMT = self.new_rv('L_DE_REGEN_APB_NMT',
                                         ('NO', 'MOD_PRE', 'SEV_PRE', 'MLD_POST', 'MOD_POST', 'SEV_POST', 'MIXED'))
        L_MYAS_APB_NMT = self.new_rv('L_MYAS_APB_NMT',
                                     ('NO', 'MOD_PRE', 'SEV_PRE', 'MLD_POST', 'MOD_POST', 'SEV_POST', 'MIXED'))
        L_APB_NMT = self.new_rv('L_APB_NMT', ('NO', 'MOD_PRE', 'SEV_PRE', 'MLD_POST', 'MOD_POST', 'SEV_POST', 'MIXED'))
        L_MYDY_APB_MUSIZE = self.new_rv('L_MYDY_APB_MUSIZE', ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_MYOP_APB_MUSIZE = self.new_rv('L_MYOP_APB_MUSIZE', ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_MYOP_MYDY_APB_MUSIZE = self.new_rv('L_MYOP_MYDY_APB_MUSIZE',
                                             ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_LNLW_APB_MUSIZE = self.new_rv('L_LNLW_APB_MUSIZE', ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_DIFFN_APB_MUSIZE = self.new_rv('L_DIFFN_APB_MUSIZE',
                                         ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_DIFFN_LNLW_APB_MUSIZE = self.new_rv('L_DIFFN_LNLW_APB_MUSIZE',
                                              ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_LNLBE_APB_MUSIZE = self.new_rv('L_LNLBE_APB_MUSIZE',
                                         ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_LNLLP_APB_MUSIZE = self.new_rv('L_LNLLP_APB_MUSIZE',
                                         ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_LNLT1_APB_MUSIZE = self.new_rv('L_LNLT1_APB_MUSIZE',
                                         ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_LNLT1_LP_APB_MUSIZE = self.new_rv('L_LNLT1_LP_APB_MUSIZE',
                                            ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_LNLT1_LP_BE_APB_MUSIZE = self.new_rv('L_LNLT1_LP_BE_APB_MUSIZE',
                                               ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_LNL_DIFFN_APB_MUSIZE = self.new_rv('L_LNL_DIFFN_APB_MUSIZE',
                                             ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_APB_MUSIZE = self.new_rv('L_APB_MUSIZE', ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE', 'OTHER'))
        L_APB_EFFMUS = self.new_rv('L_APB_EFFMUS', ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE', 'OTHER'))
        L_LNLW_MED_BLOCK = self.new_rv('L_LNLW_MED_BLOCK', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_MED_BLOCK_WA = self.new_rv('L_MED_BLOCK_WA', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_APB_MULOSS = self.new_rv('L_APB_MULOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL', 'OTHER'))
        L_APB_ALLAMP_WA = self.new_rv('L_APB_ALLAMP_WA',
                                      ('ZERO', 'A0_01', 'A0_10', 'A0_30', 'A0_70', 'A1_00', 'A2_00', 'A4_00', 'A8_00'))
        L_MED_AMP_WA = self.new_rv('L_MED_AMP_WA', (
            'MV_000', 'MV_13', 'MV_18', 'MV_25', 'MV_35', 'MV_5', 'MV_71', 'MV1', 'MV1_4', 'MV2', 'MV2_8', 'MV4',
            'MV5_6',
            'MV8', 'MV11_3', 'MV16', 'MV22_6'))
        L_MED_LD_WA = self.new_rv('L_MED_LD_WA', ('NO', 'MILD', 'MOD', 'SEV'))
        L_MED_RD_WA = self.new_rv('L_MED_RD_WA', ('NO', 'MOD', 'SEV'))
        L_MED_RDLDDEL = self.new_rv('L_MED_RDLDDEL', ('MS3_1', 'MS3_9', 'MS4_7', 'MS10_1', 'MS20_1'))
        L_LNLBE_MED_DIFSLOW = self.new_rv('L_LNLBE_MED_DIFSLOW', ('NO', 'MILD', 'MOD', 'SEV'))
        L_MED_DIFSLOW_WA = self.new_rv('L_MED_DIFSLOW_WA', ('NO', 'MILD', 'MOD', 'SEV'))
        L_MED_DCV_WA = self.new_rv('L_MED_DCV_WA',
                                   ('M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        L_MED_ALLDEL_WA = self.new_rv('L_MED_ALLDEL_WA', (
            'MS0_0', 'MS0_4', 'MS0_8', 'MS1_6', 'MS3_2', 'MS6_4', 'MS12_8', 'MS25_6', 'INFIN'))
        L_MED_LAT_WA = self.new_rv('L_MED_LAT_WA', (
            'MS2_3', 'MS2_7', 'MS3_1', 'MS3_5', 'MS3_9', 'MS4_3', 'MS4_7', 'MS5_3', 'MS5_9', 'MS6_5', 'MS7_1', 'MS8_0',
            'MS9_0', 'MS10_0', 'MS12_0', 'MS14_0', 'MS16_0', 'MS18_0', 'INFIN'))
        L_APB_VOL_ACT = self.new_rv('L_APB_VOL_ACT', ('NORMAL', 'REDUCED', 'V_RED', 'ABSENT'))
        L_APB_FORCE = self.new_rv('L_APB_FORCE', ('x5', 'x4', 'x3', 'x2', 'x1', 'x0'))
        L_APB_MUSCLE_VOL = self.new_rv('L_APB_MUSCLE_VOL', ('ATROPHIC', 'NORMAL'))
        L_APB_MVA_RECRUIT = self.new_rv('L_APB_MVA_RECRUIT', ('FULL', 'REDUCED', 'DISCRETE', 'NO_UNITS'))
        L_APB_MVA_AMP = self.new_rv('L_APB_MVA_AMP', ('INCR', 'NORMAL', 'REDUCED'))
        L_APB_TA_CONCL = self.new_rv('L_APB_TA_CONCL', ('x_5ABOVE', 'x2_5ABOVE', 'NORMAL', 'x2_5BELOW', 'x_5BELOW'))
        L_APB_MUPAMP = self.new_rv('L_APB_MUPAMP', ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE', 'OTHER'))
        L_APB_QUAN_MUPAMP = self.new_rv('L_APB_QUAN_MUPAMP', (
            'UV34', 'UV44', 'UV58', 'UV74', 'UV94', 'UV122', 'UV156', 'UV200', 'UV260', 'UV330', 'UV420', 'UV540',
            'UV700',
            'UV900', 'UV1150', 'UV1480', 'UV1900', 'UV2440', 'UV3130', 'UV4020'))
        L_APB_QUAL_MUPAMP = self.new_rv('L_APB_QUAL_MUPAMP', ('V_RED', 'REDUCED', 'NORMAL', 'INCR', 'V_INCR'))
        L_APB_MUPDUR = self.new_rv('L_APB_MUPDUR', ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE', 'OTHER'))
        L_APB_QUAN_MUPDUR = self.new_rv('L_APB_QUAN_MUPDUR', (
            'MS3', 'MS4', 'MS5', 'MS6', 'MS7', 'MS8', 'MS9', 'MS10', 'MS11', 'MS12', 'MS13', 'MS14', 'MS15', 'MS16',
            'MS17',
            'MS18', 'MS19', 'MS20', 'MS_20'))
        L_APB_QUAL_MUPDUR = self.new_rv('L_APB_QUAL_MUPDUR', ('SMALL', 'NORMAL', 'INCR'))
        L_APB_QUAN_MUPPOLY = self.new_rv('L_APB_QUAN_MUPPOLY', ('x_12_', 'x12_24_', 'x_24_'))
        L_APB_QUAL_MUPPOLY = self.new_rv('L_APB_QUAL_MUPPOLY', ('NORMAL', 'INCR'))
        L_APB_MUPSATEL = self.new_rv('L_APB_MUPSATEL', ('NO', 'YES'))
        L_APB_MUPINSTAB = self.new_rv('L_APB_MUPINSTAB', ('NO', 'YES'))
        L_APB_REPSTIM_CMAPAMP = self.new_rv('L_APB_REPSTIM_CMAPAMP', (
            'MV_000', 'MV_032', 'MV_044', 'MV_063', 'MV_088', 'MV_13', 'MV_18', 'MV_25', 'MV_35', 'MV_5', 'MV_71',
            'MV1',
            'MV1_4', 'MV2', 'MV2_8', 'MV4', 'MV5_6', 'MV8', 'MV11_3', 'MV16', 'MV22_6'))
        L_APB_REPSTIM_DECR = self.new_rv('L_APB_REPSTIM_DECR', ('NO', 'MILD', 'MOD', 'SEV', 'INCON'))
        L_APB_REPSTIM_FACILI = self.new_rv('L_APB_REPSTIM_FACILI', ('NO', 'MOD', 'SEV', 'REDUCED'))
        L_APB_REPSTIM_POST_DECR = self.new_rv('L_APB_REPSTIM_POST_DECR', ('NO', 'MILD', 'MOD', 'SEV', 'INCON'))
        L_APB_SF_JITTER = self.new_rv('L_APB_SF_JITTER', ('NORMAL', 'x2_5', 'x5_10', 'x_10'))
        L_LNLT1_APB_MUDENS = self.new_rv('L_LNLT1_APB_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_LNLLP_APB_MUDENS = self.new_rv('L_LNLLP_APB_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_LNLT1_LP_APB_MUDENS = self.new_rv('L_LNLT1_LP_APB_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_LNLBE_APB_MUDENS = self.new_rv('L_LNLBE_APB_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_LNLT1_LP_BE_APB_MUDENS = self.new_rv('L_LNLT1_LP_BE_APB_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_DIFFN_APB_MUDENS = self.new_rv('L_DIFFN_APB_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_LNLW_APB_MUDENS = self.new_rv('L_LNLW_APB_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_DIFFN_LNLW_APB_MUDENS = self.new_rv('L_DIFFN_LNLW_APB_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_LNL_DIFFN_APB_MUDENS = self.new_rv('L_LNL_DIFFN_APB_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_MYOP_APB_MUDENS = self.new_rv('L_MYOP_APB_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_MYDY_APB_MUDENS = self.new_rv('L_MYDY_APB_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_MYOP_MYDY_APB_MUDENS = self.new_rv('L_MYOP_MYDY_APB_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_MYAS_APB_MUDENS = self.new_rv('L_MYAS_APB_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_MUSCLE_APB_MUDENS = self.new_rv('L_MUSCLE_APB_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_APB_MUDENS = self.new_rv('L_APB_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_APB_SF_DENSITY = self.new_rv('L_APB_SF_DENSITY', ('x_2SD', 'x2_4SD', 'x_4SD'))
        L_LNLT1_APB_NEUR_ACT = self.new_rv('L_LNLT1_APB_NEUR_ACT',
                                           ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        L_LNLLP_APB_NEUR_ACT = self.new_rv('L_LNLLP_APB_NEUR_ACT',
                                           ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        L_LNLT1_LP_APB_NEUR_ACT = self.new_rv('L_LNLT1_LP_APB_NEUR_ACT',
                                              ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        L_LNLBE_APB_NEUR_ACT = self.new_rv('L_LNLBE_APB_NEUR_ACT',
                                           ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        L_LNLT1_LP_BE_APB_NEUR_ACT = self.new_rv('L_LNLT1_LP_BE_APB_NEUR_ACT',
                                                 ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        L_DIFFN_APB_NEUR_ACT = self.new_rv('L_DIFFN_APB_NEUR_ACT',
                                           ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        L_LNLW_APB_NEUR_ACT = self.new_rv('L_LNLW_APB_NEUR_ACT',
                                          ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        L_DIFFN_LNLW_APB_NEUR_ACT = self.new_rv('L_DIFFN_LNLW_APB_NEUR_ACT',
                                                ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        L_APB_NEUR_ACT = self.new_rv('L_APB_NEUR_ACT', ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        L_APB_SPONT_NEUR_DISCH = self.new_rv('L_APB_SPONT_NEUR_DISCH',
                                             ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        L_MYOP_APB_DENERV = self.new_rv('L_MYOP_APB_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_MYDY_APB_DENERV = self.new_rv('L_MYDY_APB_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_MYOP_MYDY_APB_DENERV = self.new_rv('L_MYOP_MYDY_APB_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_NMT_APB_DENERV = self.new_rv('L_NMT_APB_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_MUSCLE_APB_DENERV = self.new_rv('L_MUSCLE_APB_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_LNLT1_APB_DENERV = self.new_rv('L_LNLT1_APB_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_LNLLP_APB_DENERV = self.new_rv('L_LNLLP_APB_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_LNLT1_LP_APB_DENERV = self.new_rv('L_LNLT1_LP_APB_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_LNLBE_APB_DENERV = self.new_rv('L_LNLBE_APB_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_LNLT1_LP_BE_APB_DENERV = self.new_rv('L_LNLT1_LP_BE_APB_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_DIFFN_APB_DENERV = self.new_rv('L_DIFFN_APB_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_LNLW_APB_DENERV = self.new_rv('L_LNLW_APB_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_DIFFN_LNLW_APB_DENERV = self.new_rv('L_DIFFN_LNLW_APB_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_LNL_DIFFN_APB_DENERV = self.new_rv('L_LNL_DIFFN_APB_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_APB_DENERV = self.new_rv('L_APB_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_APB_SPONT_DENERV_ACT = self.new_rv('L_APB_SPONT_DENERV_ACT', ('NO', 'SOME', 'MOD', 'ABUNDANT'))
        L_APB_SPONT_HF_DISCH = self.new_rv('L_APB_SPONT_HF_DISCH', ('NO', 'YES'))
        L_APB_SPONT_INS_ACT = self.new_rv('L_APB_SPONT_INS_ACT', ('NORMAL', 'INCR'))
        L_OTHER_ULND5_DISP = self.new_rv('L_OTHER_ULND5_DISP', ('NO', 'MILD', 'MOD', 'SEV'))
        L_DIFFN_ULND5_DISP = self.new_rv('L_DIFFN_ULND5_DISP', ('NO', 'MILD', 'MOD', 'SEV'))
        L_LNLE_ULN_SEV = self.new_rv('L_LNLE_ULN_SEV', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_LNLE_ULN_PATHO = self.new_rv('L_LNLE_ULN_PATHO', ('DEMY', 'BLOCK', 'AXONAL', 'V_E_REIN', 'E_REIN'))
        L_LNLE_ULND5_DISP_E = self.new_rv('L_LNLE_ULND5_DISP_E', ('NO', 'MILD', 'MOD', 'SEV'))
        L_LNLE_DIFFN_ULND5_DISP_E = self.new_rv('L_LNLE_DIFFN_ULND5_DISP_E', ('NO', 'MILD', 'MOD', 'SEV'))
        L_ULND5_DISP_E = self.new_rv('L_ULND5_DISP_E', ('NO', 'MILD', 'MOD', 'SEV'))
        L_LNLW_ULND5_DISP_WD = self.new_rv('L_LNLW_ULND5_DISP_WD', ('NO', 'MILD', 'MOD', 'SEV'))
        L_DIFFN_LNLW_ULND5_DISP_WD = self.new_rv('L_DIFFN_LNLW_ULND5_DISP_WD', ('NO', 'MILD', 'MOD', 'SEV'))
        L_ULND5_DISP_WD = self.new_rv('L_ULND5_DISP_WD', ('NO', 'MILD', 'MOD', 'SEV'))
        L_ULND5_DISP_BEW = self.new_rv('L_ULND5_DISP_BEW', ('NO', 'MILD', 'MOD', 'SEV'))
        L_ULND5_DISP_BED = self.new_rv('L_ULND5_DISP_BED', ('NO', 'MILD', 'MOD', 'SEV'))
        L_ULND5_DISP_EED = self.new_rv('L_ULND5_DISP_EED', (
            'R0_15', 'R0_25', 'R0_35', 'R0_45', 'R0_55', 'R0_65', 'R0_75', 'R0_85', 'R0_95'))
        L_OTHER_ULND5_BLOCK = self.new_rv('L_OTHER_ULND5_BLOCK', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_DIFFN_ULND5_BLOCK = self.new_rv('L_DIFFN_ULND5_BLOCK', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_LNLE_ULND5_BLOCK_E = self.new_rv('L_LNLE_ULND5_BLOCK_E', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_LNLE_DIFFN_ULND5_BLOCK_E = self.new_rv('L_LNLE_DIFFN_ULND5_BLOCK_E', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_ULND5_BLOCK_E = self.new_rv('L_ULND5_BLOCK_E', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_ULND5_AMPR_E = self.new_rv('L_ULND5_AMPR_E', (
            'R0_0', 'R0_1', 'R0_2', 'R0_3', 'R0_4', 'R0_5', 'R0_6', 'R0_7', 'R0_8', 'R0_9', 'R1_0', 'R_1_1'))
        L_OTHER_ULND5_LD = self.new_rv('L_OTHER_ULND5_LD', ('NO', 'MILD', 'MOD', 'SEV'))
        L_LNLE_ULND5_LD_E = self.new_rv('L_LNLE_ULND5_LD_E', ('NO', 'MILD', 'MOD', 'SEV'))
        L_ULND5_LD_E = self.new_rv('L_ULND5_LD_E', ('NO', 'MILD', 'MOD', 'SEV'))
        L_OTHER_ULND5_RD = self.new_rv('L_OTHER_ULND5_RD', ('NO', 'MOD', 'SEV'))
        L_LNLE_ULND5_RD_E = self.new_rv('L_LNLE_ULND5_RD_E', ('NO', 'MOD', 'SEV'))
        L_ULND5_RD_E = self.new_rv('L_ULND5_RD_E', ('NO', 'MOD', 'SEV'))
        L_ULND5_LSLOW_E = self.new_rv('L_ULND5_LSLOW_E', ('NO', 'MILD', 'MOD', 'SEV', 'V_SEV'))
        L_OTHER_ULND5_SALOSS = self.new_rv('L_OTHER_ULND5_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_LNLW_ULND5_SALOSS = self.new_rv('L_LNLW_ULND5_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_DIFFN_ULND5_SALOSS = self.new_rv('L_DIFFN_ULND5_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_DIFFN_LNLW_ULND5_SALOSS = self.new_rv('L_DIFFN_LNLW_ULND5_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_LNLE_ULND5_SALOSS = self.new_rv('L_LNLE_ULND5_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_LNLLP_ULND5_SALOSS = self.new_rv('L_LNLLP_ULND5_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_LNLLP_E_ULND5_SALOSS = self.new_rv('L_LNLLP_E_ULND5_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_LNL_DIFFN_ULND5_SALOSS = self.new_rv('L_LNL_DIFFN_ULND5_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_ULND5_SALOSS = self.new_rv('L_ULND5_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_OTHER_ULND5_DIFSLOW = self.new_rv('L_OTHER_ULND5_DIFSLOW', ('NO', 'MILD', 'MOD', 'SEV'))
        L_LNLE_ULND5_DIFSLOW = self.new_rv('L_LNLE_ULND5_DIFSLOW', ('NO', 'MILD', 'MOD', 'SEV'))
        L_DIFFN_ULND5_DIFSLOW = self.new_rv('L_DIFFN_ULND5_DIFSLOW', ('NO', 'MILD', 'MOD', 'SEV'))
        L_LNLE_DIFFN_ULND5_DIFSLOW_E = self.new_rv('L_LNLE_DIFFN_ULND5_DIFSLOW_E', ('NO', 'MILD', 'MOD', 'SEV'))
        L_ULND5_DIFSLOW_E = self.new_rv('L_ULND5_DIFSLOW_E', ('NO', 'MILD', 'MOD', 'SEV'))
        L_ULND5_DSLOW_E = self.new_rv('L_ULND5_DSLOW_E',
                                      ('M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        L_ULND5_ALLCV_E = self.new_rv('L_ULND5_ALLCV_E',
                                      ('M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        L_ULND5_CV_E = self.new_rv('L_ULND5_CV_E', (
            'M_S00', 'M_S04', 'M_S08', 'M_S12', 'M_S16', 'M_S20', 'M_S24', 'M_S28', 'M_S32', 'M_S36', 'M_S40', 'M_S44',
            'M_S48', 'M_S52', 'M_S56', 'M_S60', 'M_S64', 'M_S68', 'M_S72', 'M_S_76'))
        L_ULND5_DISP_EWD = self.new_rv('L_ULND5_DISP_EWD', (
            'R0_15', 'R0_25', 'R0_35', 'R0_45', 'R0_55', 'R0_65', 'R0_75', 'R0_85', 'R0_95'))
        L_ULND5_BLOCK_EW = self.new_rv('L_ULND5_BLOCK_EW', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_ULND5_AMPR_EW = self.new_rv('L_ULND5_AMPR_EW', (
            'R0_0', 'R0_1', 'R0_2', 'R0_3', 'R0_4', 'R0_5', 'R0_6', 'R0_7', 'R0_8', 'R0_9', 'R1_0', 'R_1_1'))
        L_ULND5_DIFSLOW_EW = self.new_rv('L_ULND5_DIFSLOW_EW', ('NO', 'MILD', 'MOD', 'SEV'))
        L_ULND5_DSLOW_EW = self.new_rv('L_ULND5_DSLOW_EW', (
            'M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        L_ULND5_ALLCV_EW = self.new_rv('L_ULND5_ALLCV_EW', (
            'M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        L_ULND5_CV_EW = self.new_rv('L_ULND5_CV_EW', (
            'M_S00', 'M_S04', 'M_S08', 'M_S12', 'M_S16', 'M_S20', 'M_S24', 'M_S28', 'M_S32', 'M_S36', 'M_S40', 'M_S44',
            'M_S48', 'M_S52', 'M_S56', 'M_S60', 'M_S64', 'M_S68', 'M_S72', 'M_S_76'))
        L_LNLW_ULND5_BLOCK_WD = self.new_rv('L_LNLW_ULND5_BLOCK_WD', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_DIFFN_LNLW_ULND5_BLOCK_WD = self.new_rv('L_DIFFN_LNLW_ULND5_BLOCK_WD', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_ULND5_BLOCK_WD = self.new_rv('L_ULND5_BLOCK_WD', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_ULND5_EFFAXLOSS = self.new_rv('L_ULND5_EFFAXLOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_ULND5_ALLAMP_WD = self.new_rv('L_ULND5_ALLAMP_WD', ('ZERO', 'A0_01', 'A0_10', 'A0_30', 'A0_70', 'A1_00'))
        L_ULND5_AMP_WD = self.new_rv('L_ULND5_AMP_WD', (
            'UV_0_63', 'UV0_88', 'UV1_25', 'UV1_77', 'UV2_50', 'UV3_50', 'UV5_00', 'UV7_10', 'UV10_0', 'UV14_0',
            'UV20_0',
            'UV28_0', 'UV40_0', 'UV57_0', 'UV_80_0'))
        L_LNLW_ULND5_LD_WD = self.new_rv('L_LNLW_ULND5_LD_WD', ('NO', 'MILD', 'MOD', 'SEV'))
        L_ULND5_LD_WD = self.new_rv('L_ULND5_LD_WD', ('NO', 'MILD', 'MOD', 'SEV'))
        L_LNLW_ULND5_RD_WD = self.new_rv('L_LNLW_ULND5_RD_WD', ('NO', 'MOD', 'SEV'))
        L_ULND5_RD_WD = self.new_rv('L_ULND5_RD_WD', ('NO', 'MOD', 'SEV'))
        L_ULND5_LSLOW_WD = self.new_rv('L_ULND5_LSLOW_WD', ('NO', 'MILD', 'MOD', 'SEV', 'V_SEV'))
        L_LNLE_DIFFN_ULND5_DIFSLOW_WD = self.new_rv('L_LNLE_DIFFN_ULND5_DIFSLOW_WD', ('NO', 'MILD', 'MOD', 'SEV'))
        L_ULND5_DIFSLOW_WD = self.new_rv('L_ULND5_DIFSLOW_WD', ('NO', 'MILD', 'MOD', 'SEV'))
        L_ULND5_DSLOW_WD = self.new_rv('L_ULND5_DSLOW_WD', (
            'M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        L_ULND5_ALLCV_WD = self.new_rv('L_ULND5_ALLCV_WD', (
            'M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        L_ULND5_CV_WD = self.new_rv('L_ULND5_CV_WD', (
            'M_S00', 'M_S04', 'M_S08', 'M_S12', 'M_S16', 'M_S20', 'M_S24', 'M_S28', 'M_S32', 'M_S36', 'M_S40', 'M_S44',
            'M_S48', 'M_S52', 'M_S56', 'M_S60', 'M_S64', 'M_S68', 'M_S_72'))
        L_DIFFN_ULN_BLOCK = self.new_rv('L_DIFFN_ULN_BLOCK', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_LNLE_ULN_BLOCK = self.new_rv('L_LNLE_ULN_BLOCK', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_ULN_BLOCK_E = self.new_rv('L_ULN_BLOCK_E', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_ULN_AMPR_E = self.new_rv('L_ULN_AMPR_E', (
            'R_1_1', 'R1_0', 'R0_9', 'R0_8', 'R0_7', 'R0_6', 'R0_5', 'R0_4', 'R0_3', 'R0_2', 'R0_1', 'R0_0'))
        L_OTHER_ADM_MALOSS = self.new_rv('L_OTHER_ADM_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_LNLC8_ADM_MALOSS = self.new_rv('L_LNLC8_ADM_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_LNLLP_ADM_MALOSS = self.new_rv('L_LNLLP_ADM_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_LNLC8_LP_ADM_MALOSS = self.new_rv('L_LNLC8_LP_ADM_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_LNLE_ADM_MALOSS = self.new_rv('L_LNLE_ADM_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_LNLC8_LP_E_ADM_MALOSS = self.new_rv('L_LNLC8_LP_E_ADM_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_LNLW_ADM_MALOSS = self.new_rv('L_LNLW_ADM_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_DIFFN_ADM_MALOSS = self.new_rv('L_DIFFN_ADM_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_DIFFN_LNLW_ADM_MALOSS = self.new_rv('L_DIFFN_LNLW_ADM_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_LNL_DIFFN_ADM_MALOSS = self.new_rv('L_LNL_DIFFN_ADM_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_ADM_MALOSS = self.new_rv('L_ADM_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL', 'OTHER'))
        L_LNLE_ULN_DIFSLOW = self.new_rv('L_LNLE_ULN_DIFSLOW', ('NO', 'MILD', 'MOD', 'SEV'))
        L_DIFFN_ULN_DIFSLOW = self.new_rv('L_DIFFN_ULN_DIFSLOW', ('NO', 'MILD', 'MOD', 'SEV'))
        L_ULN_DIFSLOW_E = self.new_rv('L_ULN_DIFSLOW_E', ('NO', 'MILD', 'MOD', 'SEV'))
        L_ULN_DCV_E = self.new_rv('L_ULN_DCV_E', (
            'M_S60', 'M_S56', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        L_ULN_LD_EW = self.new_rv('L_ULN_LD_EW', ('NO', 'MILD', 'MOD', 'SEV'))
        L_ULN_RD_EW = self.new_rv('L_ULN_RD_EW', ('NO', 'MOD', 'SEV'))
        L_ULN_RDLDCV_E = self.new_rv('L_ULN_RDLDCV_E', ('M_S60', 'M_S52', 'M_S44', 'M_S27', 'M_S15', 'M_S07'))
        L_ULN_ALLCV_E = self.new_rv('L_ULN_ALLCV_E',
                                    ('M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        L_ULN_CV_E = self.new_rv('L_ULN_CV_E', (
            'M_S00', 'M_S04', 'M_S08', 'M_S12', 'M_S16', 'M_S20', 'M_S24', 'M_S28', 'M_S32', 'M_S36', 'M_S40', 'M_S44',
            'M_S48', 'M_S52', 'M_S56', 'M_S60', 'M_S64', 'M_S68', 'M_S72'))
        L_ULN_BLOCK_EW = self.new_rv('L_ULN_BLOCK_EW', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_ULN_AMPR_EW = self.new_rv('L_ULN_AMPR_EW', (
            'R_1_1', 'R1_0', 'R0_9', 'R0_8', 'R0_7', 'R0_6', 'R0_5', 'R0_4', 'R0_3', 'R0_2', 'R0_1', 'R0_0'))
        L_ULN_DIFSLOW_EW = self.new_rv('L_ULN_DIFSLOW_EW', ('NO', 'MILD', 'MOD', 'SEV'))
        L_ULN_DCV_EW = self.new_rv('L_ULN_DCV_EW', (
            'M_S60', 'M_S56', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        L_ULN_ALLCV_EW = self.new_rv('L_ULN_ALLCV_EW', (
            'M_S60', 'M_S56', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        L_ULN_CV_EW = self.new_rv('L_ULN_CV_EW', (
            'M_S00', 'M_S04', 'M_S08', 'M_S12', 'M_S16', 'M_S20', 'M_S24', 'M_S28', 'M_S32', 'M_S36', 'M_S40', 'M_S44',
            'M_S48', 'M_S52', 'M_S56', 'M_S60', 'M_S64', 'M_S68', 'M_S72'))
        L_OTHER_ADM_NMT = self.new_rv('L_OTHER_ADM_NMT',
                                      ('NO', 'MOD_PRE', 'SEV_PRE', 'MLD_POST', 'MOD_POST', 'SEV_POST', 'MIXED'))
        L_LNLC8_ADM_DE_REGEN = self.new_rv('L_LNLC8_ADM_DE_REGEN', ('NO', 'YES'))
        L_LNLLP_ADM_DE_REGEN = self.new_rv('L_LNLLP_ADM_DE_REGEN', ('NO', 'YES'))
        L_LNLC8_LP_ADM_DE_REGEN = self.new_rv('L_LNLC8_LP_ADM_DE_REGEN', ('NO', 'YES'))
        L_LNLE_ULN_TIME = self.new_rv('L_LNLE_ULN_TIME', ('ACUTE', 'SUBACUTE', 'CHRONIC', 'OLD'))
        L_LNLE_ADM_DE_REGEN = self.new_rv('L_LNLE_ADM_DE_REGEN', ('NO', 'YES'))
        L_LNLC8_LP_E_ADM_DE_REGEN = self.new_rv('L_LNLC8_LP_E_ADM_DE_REGEN', ('NO', 'YES'))
        L_DIFFN_ADM_DE_REGEN = self.new_rv('L_DIFFN_ADM_DE_REGEN', ('NO', 'YES'))
        L_LNLW_ADM_DE_REGEN = self.new_rv('L_LNLW_ADM_DE_REGEN', ('NO', 'YES'))
        L_DIFFN_LNLW_ADM_DE_REGEN = self.new_rv('L_DIFFN_LNLW_ADM_DE_REGEN', ('NO', 'YES'))
        L_LNL_DIFFN_ADM_DE_REGEN = self.new_rv('L_LNL_DIFFN_ADM_DE_REGEN', ('NO', 'YES'))
        L_MYOP_ADM_DE_REGEN = self.new_rv('L_MYOP_ADM_DE_REGEN', ('NO', 'YES'))
        L_MYDY_ADM_DE_REGEN = self.new_rv('L_MYDY_ADM_DE_REGEN', ('NO', 'YES'))
        L_MYOP_MYDY_ADM_DE_REGEN = self.new_rv('L_MYOP_MYDY_ADM_DE_REGEN', ('NO', 'YES'))
        L_OTHER_ADM_DE_REGEN = self.new_rv('L_OTHER_ADM_DE_REGEN', ('NO', 'YES'))
        L_MUSCLE_ADM_DE_REGEN = self.new_rv('L_MUSCLE_ADM_DE_REGEN', ('NO', 'YES'))
        L_ADM_DE_REGEN = self.new_rv('L_ADM_DE_REGEN', ('NO', 'YES'))
        L_DE_REGEN_ADM_NMT = self.new_rv('L_DE_REGEN_ADM_NMT',
                                         ('NO', 'MOD_PRE', 'SEV_PRE', 'MLD_POST', 'MOD_POST', 'SEV_POST', 'MIXED'))
        L_MYAS_ADM_NMT = self.new_rv('L_MYAS_ADM_NMT',
                                     ('NO', 'MOD_PRE', 'SEV_PRE', 'MLD_POST', 'MOD_POST', 'SEV_POST', 'MIXED'))
        L_MYAS_DE_REGEN_ADM_NMT = self.new_rv('L_MYAS_DE_REGEN_ADM_NMT',
                                              ('NO', 'MOD_PRE', 'SEV_PRE', 'MLD_POST', 'MOD_POST', 'SEV_POST', 'MIXED'))
        L_ADM_NMT = self.new_rv('L_ADM_NMT', ('NO', 'MOD_PRE', 'SEV_PRE', 'MLD_POST', 'MOD_POST', 'SEV_POST', 'MIXED'))
        L_OTHER_ADM_MUSIZE = self.new_rv('L_OTHER_ADM_MUSIZE',
                                         ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_MYDY_ADM_MUSIZE = self.new_rv('L_MYDY_ADM_MUSIZE', ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_MYOP_ADM_MUSIZE = self.new_rv('L_MYOP_ADM_MUSIZE', ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_MYOP_MYDY_ADM_MUSIZE = self.new_rv('L_MYOP_MYDY_ADM_MUSIZE',
                                             ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_MUSCLE_ADM_MUSIZE = self.new_rv('L_MUSCLE_ADM_MUSIZE',
                                          ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_LNLW_ADM_MUSIZE = self.new_rv('L_LNLW_ADM_MUSIZE', ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_DIFFN_ADM_MUSIZE = self.new_rv('L_DIFFN_ADM_MUSIZE',
                                         ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_DIFFN_LNLW_ADM_MUSIZE = self.new_rv('L_DIFFN_LNLW_ADM_MUSIZE',
                                              ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_LNLE_ADM_MUSIZE = self.new_rv('L_LNLE_ADM_MUSIZE', ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_LNLLP_ADM_MUSIZE = self.new_rv('L_LNLLP_ADM_MUSIZE',
                                         ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_LNLC8_ADM_MUSIZE = self.new_rv('L_LNLC8_ADM_MUSIZE',
                                         ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_LNLC8_LP_ADM_MUSIZE = self.new_rv('L_LNLC8_LP_ADM_MUSIZE',
                                            ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_LNLC8_LP_E_ADM_MUSIZE = self.new_rv('L_LNLC8_LP_E_ADM_MUSIZE',
                                              ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_LNL_DIFFN_ADM_MUSIZE = self.new_rv('L_LNL_DIFFN_ADM_MUSIZE',
                                             ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_ADM_MUSIZE = self.new_rv('L_ADM_MUSIZE', ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE', 'OTHER'))
        L_ADM_EFFMUS = self.new_rv('L_ADM_EFFMUS', ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE', 'OTHER'))
        L_OTHER_ULN_BLOCK_WA = self.new_rv('L_OTHER_ULN_BLOCK_WA', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_LNLW_ULN_BLOCK = self.new_rv('L_LNLW_ULN_BLOCK', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_DIFFN_LNLW_ULN_BLOCK_WA = self.new_rv('L_DIFFN_LNLW_ULN_BLOCK_WA', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_ULN_BLOCK_WA = self.new_rv('L_ULN_BLOCK_WA', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_ADM_MULOSS = self.new_rv('L_ADM_MULOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL', 'OTHER'))
        L_ADM_ALLAMP_WA = self.new_rv('L_ADM_ALLAMP_WA',
                                      ('ZERO', 'A0_01', 'A0_10', 'A0_30', 'A0_70', 'A1_00', 'A2_00', 'A4_00', 'A8_00'))
        L_ULN_AMP_WA = self.new_rv('L_ULN_AMP_WA', (
            'MV_000', 'MV_13', 'MV_18', 'MV_25', 'MV_35', 'MV_5', 'MV_71', 'MV1', 'MV1_4', 'MV2', 'MV2_8', 'MV4',
            'MV5_6',
            'MV8', 'MV11_3', 'MV16', 'MV22_6'))
        L_ULN_LD_WA = self.new_rv('L_ULN_LD_WA', ('NO', 'MILD', 'MOD', 'SEV'))
        L_ULN_RD_WA = self.new_rv('L_ULN_RD_WA', ('NO', 'MOD', 'SEV'))
        L_ULN_RDLDDEL = self.new_rv('L_ULN_RDLDDEL', ('MS3_1', 'MS3_9', 'MS4_7', 'MS10_1', 'MS20_1'))
        L_ULN_DIFSLOW_WA = self.new_rv('L_ULN_DIFSLOW_WA', ('NO', 'MILD', 'MOD', 'SEV'))
        L_ULN_DCV_WA = self.new_rv('L_ULN_DCV_WA',
                                   ('M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        L_ULN_ALLDEL_WA = self.new_rv('L_ULN_ALLDEL_WA', (
            'MS0_0', 'MS0_4', 'MS0_8', 'MS1_6', 'MS3_2', 'MS6_4', 'MS12_8', 'MS25_6', 'INFIN'))
        L_ULN_LAT_WA = self.new_rv('L_ULN_LAT_WA', (
            'MS2_3', 'MS2_7', 'MS3_1', 'MS3_5', 'MS3_9', 'MS4_3', 'MS4_7', 'MS5_3', 'MS5_9', 'MS6_5', 'MS7_1', 'MS8_0',
            'MS9_0', 'MS10_0', 'MS12_0', 'MS14_0', 'MS16_0', 'MS18_0', 'INFIN'))
        L_ADM_VOL_ACT = self.new_rv('L_ADM_VOL_ACT', ('NORMAL', 'REDUCED', 'V_RED', 'ABSENT'))
        L_ADM_FORCE = self.new_rv('L_ADM_FORCE', ('x5', 'x4', 'x3', 'x2', 'x1', 'x0'))
        L_ADM_MUSCLE_VOL = self.new_rv('L_ADM_MUSCLE_VOL', ('ATROPHIC', 'NORMAL'))
        L_ADM_MVA_RECRUIT = self.new_rv('L_ADM_MVA_RECRUIT', ('FULL', 'REDUCED', 'DISCRETE', 'NO_UNITS'))
        L_ADM_MVA_AMP = self.new_rv('L_ADM_MVA_AMP', ('INCR', 'NORMAL', 'REDUCED'))
        L_ADM_TA_CONCL = self.new_rv('L_ADM_TA_CONCL', ('x_5ABOVE', 'x2_5ABOVE', 'NORMAL', 'x2_5BELOW', 'x_5BELOW'))
        L_ADM_MUPAMP = self.new_rv('L_ADM_MUPAMP', ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE', 'OTHER'))
        L_ADM_QUAN_MUPAMP = self.new_rv('L_ADM_QUAN_MUPAMP', (
            'UV34', 'UV44', 'UV58', 'UV74', 'UV94', 'UV122', 'UV156', 'UV200', 'UV260', 'UV330', 'UV420', 'UV540',
            'UV700',
            'UV900', 'UV1150', 'UV1480', 'UV1900', 'UV2440', 'UV3130', 'UV4020'))
        L_ADM_QUAL_MUPAMP = self.new_rv('L_ADM_QUAL_MUPAMP', ('V_RED', 'REDUCED', 'NORMAL', 'INCR', 'V_INCR'))
        L_ADM_MUPDUR = self.new_rv('L_ADM_MUPDUR', ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE', 'OTHER'))
        L_ADM_QUAN_MUPDUR = self.new_rv('L_ADM_QUAN_MUPDUR', (
            'MS3', 'MS4', 'MS5', 'MS6', 'MS7', 'MS8', 'MS9', 'MS10', 'MS11', 'MS12', 'MS13', 'MS14', 'MS15', 'MS16',
            'MS17',
            'MS18', 'MS19', 'MS20', 'MS_20'))
        L_ADM_QUAL_MUPDUR = self.new_rv('L_ADM_QUAL_MUPDUR', ('SMALL', 'NORMAL', 'INCR'))
        L_ADM_QUAN_MUPPOLY = self.new_rv('L_ADM_QUAN_MUPPOLY', ('x_12_', 'x12_24_', 'x_24_'))
        L_ADM_QUAL_MUPPOLY = self.new_rv('L_ADM_QUAL_MUPPOLY', ('NORMAL', 'INCR'))
        L_ADM_MUPSATEL = self.new_rv('L_ADM_MUPSATEL', ('NO', 'YES'))
        L_ADM_MUPINSTAB = self.new_rv('L_ADM_MUPINSTAB', ('NO', 'YES'))
        L_ADM_REPSTIM_CMAPAMP = self.new_rv('L_ADM_REPSTIM_CMAPAMP', (
            'MV_000', 'MV_032', 'MV_044', 'MV_063', 'MV_088', 'MV_13', 'MV_18', 'MV_25', 'MV_35', 'MV_5', 'MV_71',
            'MV1',
            'MV1_4', 'MV2', 'MV2_8', 'MV4', 'MV5_6', 'MV8', 'MV11_3', 'MV16', 'MV22_6'))
        L_ADM_REPSTIM_DECR = self.new_rv('L_ADM_REPSTIM_DECR', ('NO', 'MILD', 'MOD', 'SEV', 'INCON'))
        L_ADM_REPSTIM_FACILI = self.new_rv('L_ADM_REPSTIM_FACILI', ('NO', 'MOD', 'SEV', 'REDUCED'))
        L_ADM_REPSTIM_POST_DECR = self.new_rv('L_ADM_REPSTIM_POST_DECR', ('NO', 'MILD', 'MOD', 'SEV', 'INCON'))
        L_ADM_SF_JITTER = self.new_rv('L_ADM_SF_JITTER', ('NORMAL', 'x2_5', 'x5_10', 'x_10'))
        L_LNLC8_ADM_MUDENS = self.new_rv('L_LNLC8_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_LNLLP_ADM_MUDENS = self.new_rv('L_LNLLP_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_LNLC8_LP_ADM_MUDENS = self.new_rv('L_LNLC8_LP_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_LNLE_ADM_MUDENS = self.new_rv('L_LNLE_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_LNLC8_LP_E_ADM_MUDENS = self.new_rv('L_LNLC8_LP_E_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_DIFFN_ADM_MUDENS = self.new_rv('L_DIFFN_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_LNLW_ADM_MUDENS = self.new_rv('L_LNLW_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_DIFFN_LNLW_ADM_MUDENS = self.new_rv('L_DIFFN_LNLW_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_LNL_DIFFN_ADM_MUDENS = self.new_rv('L_LNL_DIFFN_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_MYOP_ADM_MUDENS = self.new_rv('L_MYOP_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_MYDY_ADM_MUDENS = self.new_rv('L_MYDY_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_MYOP_MYDY_ADM_MUDENS = self.new_rv('L_MYOP_MYDY_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_MYAS_ADM_MUDENS = self.new_rv('L_MYAS_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_OTHER_ADM_MUDENS = self.new_rv('L_OTHER_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_MYAS_OTHER_ADM_MUDENS = self.new_rv('L_MYAS_OTHER_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_MUSCLE_ADM_MUDENS = self.new_rv('L_MUSCLE_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_ADM_MUDENS = self.new_rv('L_ADM_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_ADM_SF_DENSITY = self.new_rv('L_ADM_SF_DENSITY', ('x_2SD', 'x2_4SD', 'x_4SD'))
        L_LNLC8_ADM_NEUR_ACT = self.new_rv('L_LNLC8_ADM_NEUR_ACT',
                                           ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        L_LNLLP_ADM_NEUR_ACT = self.new_rv('L_LNLLP_ADM_NEUR_ACT',
                                           ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        L_LNLC8_LP_ADM_NEUR_ACT = self.new_rv('L_LNLC8_LP_ADM_NEUR_ACT',
                                              ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        L_LNLE_ADM_NEUR_ACT = self.new_rv('L_LNLE_ADM_NEUR_ACT',
                                          ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        L_LNLC8_LP_E_ADM_NEUR_ACT = self.new_rv('L_LNLC8_LP_E_ADM_NEUR_ACT',
                                                ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        L_DIFFN_ADM_NEUR_ACT = self.new_rv('L_DIFFN_ADM_NEUR_ACT',
                                           ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        L_LNLW_ADM_NEUR_ACT = self.new_rv('L_LNLW_ADM_NEUR_ACT',
                                          ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        L_DIFFN_LNLW_ADM_NEUR_ACT = self.new_rv('L_DIFFN_LNLW_ADM_NEUR_ACT',
                                                ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        L_LNL_DIFFN_ADM_NEUR_ACT = self.new_rv('L_LNL_DIFFN_ADM_NEUR_ACT',
                                               ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        L_OTHER_ADM_NEUR_ACT = self.new_rv('L_OTHER_ADM_NEUR_ACT',
                                           ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        L_ADM_NEUR_ACT = self.new_rv('L_ADM_NEUR_ACT', ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        L_ADM_SPONT_NEUR_DISCH = self.new_rv('L_ADM_SPONT_NEUR_DISCH',
                                             ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        L_MYOP_ADM_DENERV = self.new_rv('L_MYOP_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_MYDY_ADM_DENERV = self.new_rv('L_MYDY_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_MYOP_MYDY_ADM_DENERV = self.new_rv('L_MYOP_MYDY_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_OTHER_ADM_DENERV = self.new_rv('L_OTHER_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_NMT_ADM_DENERV = self.new_rv('L_NMT_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_OTHER_NMT_ADM_DENERV = self.new_rv('L_OTHER_NMT_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_MUSCLE_ADM_DENERV = self.new_rv('L_MUSCLE_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_LNLC8_ADM_DENERV = self.new_rv('L_LNLC8_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_LNLLP_ADM_DENERV = self.new_rv('L_LNLLP_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_LNLC8_LP_ADM_DENERV = self.new_rv('L_LNLC8_LP_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_LNLE_ADM_DENERV = self.new_rv('L_LNLE_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_LNLC8_LP_E_ADM_DENERV = self.new_rv('L_LNLC8_LP_E_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_DIFFN_ADM_DENERV = self.new_rv('L_DIFFN_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_LNLW_ADM_DENERV = self.new_rv('L_LNLW_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_DIFFN_LNLW_ADM_DENERV = self.new_rv('L_DIFFN_LNLW_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_LNL_DIFFN_ADM_DENERV = self.new_rv('L_LNL_DIFFN_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_ADM_DENERV = self.new_rv('L_ADM_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_ADM_SPONT_DENERV_ACT = self.new_rv('L_ADM_SPONT_DENERV_ACT', ('NO', 'SOME', 'MOD', 'ABUNDANT'))
        L_ADM_SPONT_HF_DISCH = self.new_rv('L_ADM_SPONT_HF_DISCH', ('NO', 'YES'))
        L_ADM_SPONT_INS_ACT = self.new_rv('L_ADM_SPONT_INS_ACT', ('NORMAL', 'INCR'))
        L_OTHER_DELT_NMT = self.new_rv('L_OTHER_DELT_NMT',
                                       ('NO', 'MOD_PRE', 'SEV_PRE', 'MLD_POST', 'MOD_POST', 'SEV_POST', 'MIXED'))
        L_LNLPC5_AXIL_SEV = self.new_rv('L_LNLPC5_AXIL_SEV', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_LNLPC5_AXIL_TIME = self.new_rv('L_LNLPC5_AXIL_TIME', ('ACUTE', 'SUBACUTE', 'CHRONIC', 'OLD'))
        L_LNLPC5_AXIL_PATHO = self.new_rv('L_LNLPC5_AXIL_PATHO', ('DEMY', 'BLOCK', 'AXONAL', 'V_E_REIN', 'E_REIN'))
        L_LNLPC5_DELT_DE_REGEN = self.new_rv('L_LNLPC5_DELT_DE_REGEN', ('NO', 'YES'))
        L_DIFFN_DELT_DE_REGEN = self.new_rv('L_DIFFN_DELT_DE_REGEN', ('NO', 'YES'))
        L_LNLPC5_DIFFN_DELT_DE_REGEN = self.new_rv('L_LNLPC5_DIFFN_DELT_DE_REGEN', ('NO', 'YES'))
        L_MYOP_DELT_DE_REGEN = self.new_rv('L_MYOP_DELT_DE_REGEN', ('NO', 'YES'))
        L_MYDY_DELT_DE_REGEN = self.new_rv('L_MYDY_DELT_DE_REGEN', ('NO', 'YES'))
        L_MYOP_MYDY_DELT_DE_REGEN = self.new_rv('L_MYOP_MYDY_DELT_DE_REGEN', ('NO', 'YES'))
        L_OTHER_DELT_DE_REGEN = self.new_rv('L_OTHER_DELT_DE_REGEN', ('NO', 'YES'))
        L_MUSCLE_DELT_DE_REGEN = self.new_rv('L_MUSCLE_DELT_DE_REGEN', ('NO', 'YES'))
        L_DELT_DE_REGEN = self.new_rv('L_DELT_DE_REGEN', ('NO', 'YES'))
        L_DE_REGEN_DELT_NMT = self.new_rv('L_DE_REGEN_DELT_NMT',
                                          ('NO', 'MOD_PRE', 'SEV_PRE', 'MLD_POST', 'MOD_POST', 'SEV_POST', 'MIXED'))
        L_MYAS_DELT_NMT = self.new_rv('L_MYAS_DELT_NMT',
                                      ('NO', 'MOD_PRE', 'SEV_PRE', 'MLD_POST', 'MOD_POST', 'SEV_POST', 'MIXED'))
        L_MYAS_DE_REGEN_DELT_NMT = self.new_rv('L_MYAS_DE_REGEN_DELT_NMT', (
            'NO', 'MOD_PRE', 'SEV_PRE', 'MLD_POST', 'MOD_POST', 'SEV_POST', 'MIXED'))
        L_DELT_NMT = self.new_rv('L_DELT_NMT',
                                 ('NO', 'MOD_PRE', 'SEV_PRE', 'MLD_POST', 'MOD_POST', 'SEV_POST', 'OTHER'))
        L_OTHER_DELT_MUSIZE = self.new_rv('L_OTHER_DELT_MUSIZE',
                                          ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_MYDY_DELT_MUSIZE = self.new_rv('L_MYDY_DELT_MUSIZE',
                                         ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_MYOP_DELT_MUSIZE = self.new_rv('L_MYOP_DELT_MUSIZE',
                                         ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_MYOP_MYDY_DELT_MUSIZE = self.new_rv('L_MYOP_MYDY_DELT_MUSIZE',
                                              ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_MUSCLE_DELT_MUSIZE = self.new_rv('L_MUSCLE_DELT_MUSIZE',
                                           ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_DIFFN_DELT_MUSIZE = self.new_rv('L_DIFFN_DELT_MUSIZE',
                                          ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_LNLPC5_DELT_MUSIZE = self.new_rv('L_LNLPC5_DELT_MUSIZE',
                                           ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_LNLPC5_DIFFN_DELT_MUSIZE = self.new_rv('L_LNLPC5_DIFFN_DELT_MUSIZE',
                                                 ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE'))
        L_DELT_MUSIZE = self.new_rv('L_DELT_MUSIZE',
                                    ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE', 'OTHER'))
        L_DELT_EFFMUS = self.new_rv('L_DELT_EFFMUS',
                                    ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE', 'OTHER'))
        L_DIFFN_AXIL_BLOCK = self.new_rv('L_DIFFN_AXIL_BLOCK', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_OTHER_AXIL_BLOCK = self.new_rv('L_OTHER_AXIL_BLOCK', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_AXIL_BLOCK_ED = self.new_rv('L_AXIL_BLOCK_ED', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_LNLPC5_DELT_MALOSS = self.new_rv('L_LNLPC5_DELT_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_DIFFN_DELT_MALOSS = self.new_rv('L_DIFFN_DELT_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_LNLPC5_DIFFN_DELT_MALOSS = self.new_rv('L_LNLPC5_DIFFN_DELT_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_OTHER_DELT_MALOSS = self.new_rv('L_OTHER_DELT_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_DELT_MALOSS = self.new_rv('L_DELT_MALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL', 'OTHER'))
        L_DELT_MULOSS = self.new_rv('L_DELT_MULOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL', 'OTHER'))
        L_DELT_ALLAMP = self.new_rv('L_DELT_ALLAMP',
                                    ('ZERO', 'A0_01', 'A0_10', 'A0_30', 'A0_70', 'A1_00', 'A2_00', 'A4_00', 'A8_00'))
        L_AXIL_AMP_E = self.new_rv('L_AXIL_AMP_E', (
            'MV_000', 'MV_13', 'MV_18', 'MV_25', 'MV_35', 'MV_5', 'MV_71', 'MV1', 'MV1_4', 'MV2', 'MV2_8', 'MV4',
            'MV5_6',
            'MV8', 'MV11_3', 'MV16', 'MV22_6'))
        L_AXIL_RD_ED = self.new_rv('L_AXIL_RD_ED', ('NO', 'MOD', 'SEV'))
        L_LNLPC5_AXIL_DIFSLOW = self.new_rv('L_LNLPC5_AXIL_DIFSLOW', ('NO', 'MILD', 'MOD', 'SEV'))
        L_DIFFN_AXIL_DIFSLOW = self.new_rv('L_DIFFN_AXIL_DIFSLOW', ('NO', 'MILD', 'MOD', 'SEV'))
        L_AXIL_DIFSLOW_ED = self.new_rv('L_AXIL_DIFSLOW_ED', ('NO', 'MILD', 'MOD', 'SEV'))
        L_AXIL_DCV = self.new_rv('L_AXIL_DCV',
                                 ('M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        L_AXIL_DEL = self.new_rv('L_AXIL_DEL',
                                 ('MS0_0', 'MS0_4', 'MS0_8', 'MS1_6', 'MS3_2', 'MS6_4', 'MS12_8', 'MS25_6', 'INFIN'))
        L_AXIL_LAT_ED = self.new_rv('L_AXIL_LAT_ED', (
            'MS3_1', 'MS3_5', 'MS3_9', 'MS4_3', 'MS4_7', 'MS5_3', 'MS5_9', 'MS6_5', 'MS7_1', 'MS8_0', 'MS9_0', 'MS10_0',
            'MS12_0', 'MS14_0', 'MS16_0', 'MS18_0', 'INFIN'))
        L_DELT_VOL_ACT = self.new_rv('L_DELT_VOL_ACT', ('NORMAL', 'REDUCED', 'V_RED', 'ABSENT'))
        L_DELT_FORCE = self.new_rv('L_DELT_FORCE', ('x5', 'x4', 'x3', 'x2', 'x1', 'x0'))
        L_DELT_MUSCLE_VOL = self.new_rv('L_DELT_MUSCLE_VOL', ('ATROPHIC', 'NORMAL'))
        L_DELT_MVA_RECRUIT = self.new_rv('L_DELT_MVA_RECRUIT', ('FULL', 'REDUCED', 'DISCRETE', 'NO_UNITS'))
        L_DELT_MVA_AMP = self.new_rv('L_DELT_MVA_AMP', ('INCR', 'NORMAL', 'REDUCED'))
        L_DELT_TA_CONCL = self.new_rv('L_DELT_TA_CONCL', ('x_5ABOVE', 'x2_5ABOVE', 'NORMAL', 'x2_5BELOW', 'x_5BELOW'))
        L_DELT_MUPAMP = self.new_rv('L_DELT_MUPAMP',
                                    ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE', 'OTHER'))
        L_DELT_QUAN_MUPAMP = self.new_rv('L_DELT_QUAN_MUPAMP', (
            'UV34', 'UV44', 'UV58', 'UV74', 'UV94', 'UV122', 'UV156', 'UV200', 'UV260', 'UV330', 'UV420', 'UV540',
            'UV700',
            'UV900', 'UV1150', 'UV1480', 'UV1900', 'UV2440', 'UV3130', 'UV4020'))
        L_DELT_QUAL_MUPAMP = self.new_rv('L_DELT_QUAL_MUPAMP', ('V_RED', 'REDUCED', 'NORMAL', 'INCR', 'V_INCR'))
        L_DELT_MUPDUR = self.new_rv('L_DELT_MUPDUR',
                                    ('V_SMALL', 'SMALL', 'NORMAL', 'INCR', 'LARGE', 'V_LARGE', 'OTHER'))
        L_DELT_QUAN_MUPDUR = self.new_rv('L_DELT_QUAN_MUPDUR', (
            'MS3', 'MS4', 'MS5', 'MS6', 'MS7', 'MS8', 'MS9', 'MS10', 'MS11', 'MS12', 'MS13', 'MS14', 'MS15', 'MS16',
            'MS17',
            'MS18', 'MS19', 'MS20', 'MS_20'))
        L_DELT_QUAL_MUPDUR = self.new_rv('L_DELT_QUAL_MUPDUR', ('SMALL', 'NORMAL', 'INCR'))
        L_DELT_QUAN_MUPPOLY = self.new_rv('L_DELT_QUAN_MUPPOLY', ('x_12_', 'x12_24_', 'x_24_'))
        L_DELT_QUAL_MUPPOLY = self.new_rv('L_DELT_QUAL_MUPPOLY', ('NORMAL', 'INCR'))
        L_DELT_MUPSATEL = self.new_rv('L_DELT_MUPSATEL', ('NO', 'YES'))
        L_DELT_MUPINSTAB = self.new_rv('L_DELT_MUPINSTAB', ('NO', 'YES'))
        L_DELT_REPSTIM_CMAPAMP = self.new_rv('L_DELT_REPSTIM_CMAPAMP', (
            'MV_000', 'MV_032', 'MV_044', 'MV_063', 'MV_088', 'MV_13', 'MV_18', 'MV_25', 'MV_35', 'MV_5', 'MV_71',
            'MV1',
            'MV1_4', 'MV2', 'MV2_8', 'MV4', 'MV5_6', 'MV8', 'MV11_3', 'MV16', 'MV22_6'))
        L_DELT_REPSTIM_DECR = self.new_rv('L_DELT_REPSTIM_DECR', ('NO', 'MILD', 'MOD', 'SEV', 'INCON'))
        L_DELT_REPSTIM_FACILI = self.new_rv('L_DELT_REPSTIM_FACILI', ('NO', 'MOD', 'SEV', 'REDUCED'))
        L_DELT_REPSTIM_POST_DECR = self.new_rv('L_DELT_REPSTIM_POST_DECR', ('NO', 'MILD', 'MOD', 'SEV', 'INCON'))
        L_DELT_SF_JITTER = self.new_rv('L_DELT_SF_JITTER', ('NORMAL', 'x2_5', 'x5_10', 'x_10'))
        L_LNLPC5_DELT_MUDENS = self.new_rv('L_LNLPC5_DELT_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_DIFFN_DELT_MUDENS = self.new_rv('L_DIFFN_DELT_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_LNLPC5_DIFFN_DELT_MUDENS = self.new_rv('L_LNLPC5_DIFFN_DELT_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_MYOP_DELT_MUDENS = self.new_rv('L_MYOP_DELT_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_MYDY_DELT_MUDENS = self.new_rv('L_MYDY_DELT_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_MYOP_MYDY_DELT_MUDENS = self.new_rv('L_MYOP_MYDY_DELT_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_MYAS_DELT_MUDENS = self.new_rv('L_MYAS_DELT_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_OTHER_DELT_MUDENS = self.new_rv('L_OTHER_DELT_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_MYAS_OTHER_DELT_MUDENS = self.new_rv('L_MYAS_OTHER_DELT_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_MUSCLE_DELT_MUDENS = self.new_rv('L_MUSCLE_DELT_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_DELT_MUDENS = self.new_rv('L_DELT_MUDENS', ('NORMAL', 'INCR', 'V_INCR'))
        L_DELT_SF_DENSITY = self.new_rv('L_DELT_SF_DENSITY', ('x_2SD', 'x2_4SD', 'x_4SD'))
        L_LNLPC5_DELT_NEUR_ACT = self.new_rv('L_LNLPC5_DELT_NEUR_ACT',
                                             ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        L_DIFFN_DELT_NEUR_ACT = self.new_rv('L_DIFFN_DELT_NEUR_ACT',
                                            ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        L_LNLPC5_DIFFN_DELT_NEUR_ACT = self.new_rv('L_LNLPC5_DIFFN_DELT_NEUR_ACT',
                                                   ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        L_OTHER_DELT_NEUR_ACT = self.new_rv('L_OTHER_DELT_NEUR_ACT',
                                            ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        L_DELT_NEUR_ACT = self.new_rv('L_DELT_NEUR_ACT', ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        L_DELT_SPONT_NEUR_DISCH = self.new_rv('L_DELT_SPONT_NEUR_DISCH',
                                              ('NO', 'FASCIC', 'NEUROMYO', 'MYOKYMIA', 'TETANUS', 'OTHER'))
        L_MYOP_DELT_DENERV = self.new_rv('L_MYOP_DELT_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_MYDY_DELT_DENERV = self.new_rv('L_MYDY_DELT_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_MYOP_MYDY_DELT_DENERV = self.new_rv('L_MYOP_MYDY_DELT_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_OTHER_DELT_DENERV = self.new_rv('L_OTHER_DELT_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_NMT_DELT_DENERV = self.new_rv('L_NMT_DELT_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_OTHER_NMT_DELT_DENERV = self.new_rv('L_OTHER_NMT_DELT_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_MUSCLE_DELT_DENERV = self.new_rv('L_MUSCLE_DELT_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_LNLPC5_DELT_DENERV = self.new_rv('L_LNLPC5_DELT_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_DIFFN_DELT_DENERV = self.new_rv('L_DIFFN_DELT_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_LNLPC5_DIFFN_DELT_DENERV = self.new_rv('L_LNLPC5_DIFFN_DELT_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_DELT_DENERV = self.new_rv('L_DELT_DENERV', ('NO', 'MILD', 'MOD', 'SEV'))
        L_DELT_SPONT_DENERV_ACT = self.new_rv('L_DELT_SPONT_DENERV_ACT', ('NO', 'SOME', 'MOD', 'ABUNDANT'))
        L_DELT_SPONT_HF_DISCH = self.new_rv('L_DELT_SPONT_HF_DISCH', ('NO', 'YES'))
        L_DELT_SPONT_INS_ACT = self.new_rv('L_DELT_SPONT_INS_ACT', ('NORMAL', 'INCR'))
        L_OTHER_ISCH_DISP = self.new_rv('L_OTHER_ISCH_DISP', ('NO', 'MILD', 'MOD', 'SEV'))
        L_DIFFN_ISCH_DISP = self.new_rv('L_DIFFN_ISCH_DISP', ('NO', 'MILD', 'MOD', 'SEV'))
        L_SUR_DISP_CA = self.new_rv('L_SUR_DISP_CA', ('NO', 'MILD', 'MOD', 'SEV'))
        L_OTHER_ISCH_BLOCK = self.new_rv('L_OTHER_ISCH_BLOCK', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_DIFFN_ISCH_BLOCK = self.new_rv('L_DIFFN_ISCH_BLOCK', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_SUR_BLOCK_CA = self.new_rv('L_SUR_BLOCK_CA', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_OTHER_ISCH_SALOSS = self.new_rv('L_OTHER_ISCH_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_DIFFN_ISCH_SALOSS = self.new_rv('L_DIFFN_ISCH_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_LNL_ISCH_SEV = self.new_rv('L_LNL_ISCH_SEV', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_LNL_ISCH_PATHO = self.new_rv('L_LNL_ISCH_PATHO', ('DEMY', 'BLOCK', 'AXONAL', 'V_E_REIN', 'E_REIN'))
        L_LNL_ISCH_SALOSS_CA = self.new_rv('L_LNL_ISCH_SALOSS_CA', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_DIFFN_LNL_ISCH_SALOSS = self.new_rv('L_DIFFN_LNL_ISCH_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_SUR_SALOSS = self.new_rv('L_SUR_SALOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_SUR_EFFAXLOSS = self.new_rv('L_SUR_EFFAXLOSS', ('NO', 'MILD', 'MOD', 'SEV', 'TOTAL'))
        L_SUR_ALLAMP_CA = self.new_rv('L_SUR_ALLAMP_CA', ('ZERO', 'A0_01', 'A0_10', 'A0_30', 'A0_70', 'A1_00'))
        L_SUR_AMP_CA = self.new_rv('L_SUR_AMP_CA', (
            'UV_0_63', 'UV0_88', 'UV1_25', 'UV1_77', 'UV2_50', 'UV3_50', 'UV5_00', 'UV7_10', 'UV10_0', 'UV14_0',
            'UV20_0',
            'UV28_0', 'UV_40_0'))
        L_SUR_LD_CA = self.new_rv('L_SUR_LD_CA', ('NO', 'MILD', 'MOD', 'SEV'))
        L_SUR_RD_CA = self.new_rv('L_SUR_RD_CA', ('NO', 'MOD', 'SEV'))
        L_SUR_LSLOW_CA = self.new_rv('L_SUR_LSLOW_CA', ('NO', 'MILD', 'MOD', 'SEV', 'V_SEV'))
        L_OTHER_ISCH_DIFSLOW = self.new_rv('L_OTHER_ISCH_DIFSLOW', ('NO', 'MILD', 'MOD', 'SEV'))
        L_DIFFN_ISCH_DIFSLOW = self.new_rv('L_DIFFN_ISCH_DIFSLOW', ('NO', 'MILD', 'MOD', 'SEV'))
        L_SUR_DIFSLOW_CA = self.new_rv('L_SUR_DIFSLOW_CA', ('NO', 'MILD', 'MOD', 'SEV'))
        L_SUR_DSLOW_CA = self.new_rv('L_SUR_DSLOW_CA',
                                     ('M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        L_SUR_ALLCV_CA = self.new_rv('L_SUR_ALLCV_CA',
                                     ('M_S60', 'M_S52', 'M_S44', 'M_S36', 'M_S28', 'M_S20', 'M_S14', 'M_S08', 'M_S00'))
        L_SUR_CV_CA = self.new_rv('L_SUR_CV_CA', (
            'M_S00', 'M_S04', 'M_S08', 'M_S12', 'M_S16', 'M_S20', 'M_S24', 'M_S28', 'M_S32', 'M_S36', 'M_S40', 'M_S44',
            'M_S48', 'M_S52', 'M_S56', 'M_S60', 'M_S_64'))
        pgm_factor0 = self.new_factor(R_LNLW_MED_SEV)
        pgm_function0 = pgm_factor0.set_cpt()
        pgm_function0.set_cpd((), (0.895, 0.06, 0.03, 0.01, 0.005))
        pgm_factor1 = self.new_factor(R_LNLW_MED_PATHO)
        pgm_function1 = pgm_factor1.set_cpt()
        pgm_function1.set_cpd((), (0.8, 0.12, 0.07, 0.005, 0.005))
        pgm_factor2 = self.new_factor(R_LNLW_MEDD2_DISP_WD, R_LNLW_MED_SEV, R_LNLW_MED_PATHO)
        pgm_function2 = pgm_factor2.set_cpt()
        pgm_function2.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function2.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function2.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function2.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function2.set_cpd((4, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function2.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function2.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0))
        pgm_function2.set_cpd((2, 1), (0.0, 0.5, 0.5, 0.0))
        pgm_function2.set_cpd((3, 1), (0.0, 0.1, 0.5, 0.4))
        pgm_function2.set_cpd((4, 1), (0.0, 0.0, 0.5, 0.5))
        pgm_function2.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function2.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function2.set_cpd((2, 2), (0.5, 0.5, 0.0, 0.0))
        pgm_function2.set_cpd((3, 2), (0.3, 0.5, 0.2, 0.0))
        pgm_function2.set_cpd((4, 2), (0.0, 0.5, 0.5, 0.0))
        pgm_function2.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function2.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function2.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function2.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function2.set_cpd((4, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function2.set_cpd((0, 4), (0.0, 0.0, 0.0, 1.0))
        pgm_function2.set_cpd((1, 4), (0.0, 0.0, 0.0, 1.0))
        pgm_function2.set_cpd((2, 4), (0.0, 0.0, 0.0, 1.0))
        pgm_function2.set_cpd((3, 4), (0.0, 0.0, 0.0, 1.0))
        pgm_function2.set_cpd((4, 4), (0.0, 0.0, 0.0, 1.0))
        pgm_factor3 = self.new_factor(DIFFN_SEV)
        pgm_function3 = pgm_factor3.set_cpt()
        pgm_function3.set_cpd((), (0.9, 0.05, 0.03, 0.02))
        pgm_factor4 = self.new_factor(DIFFN_TYPE)
        pgm_function4 = pgm_factor4.set_cpt()
        pgm_function4.set_cpd((), (0.06, 0.935, 0.005))
        pgm_factor5 = self.new_factor(DIFFN_SENS_SEV, DIFFN_SEV, DIFFN_TYPE)
        pgm_function5 = pgm_factor5.set_cpt()
        pgm_function5.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function5.set_cpd((1, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function5.set_cpd((2, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function5.set_cpd((3, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function5.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function5.set_cpd((1, 1), (0.0, 1.0, 0.0, 0.0))
        pgm_function5.set_cpd((2, 1), (0.0, 0.0, 1.0, 0.0))
        pgm_function5.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function5.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function5.set_cpd((1, 2), (0.0, 1.0, 0.0, 0.0))
        pgm_function5.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function5.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_factor6 = self.new_factor(DIFFN_DISTR)
        pgm_function6 = pgm_factor6.set_cpt()
        pgm_function6.set_cpd((), (0.93, 0.02, 0.05))
        pgm_factor7 = self.new_factor(DIFFN_S_SEV_DIST, DIFFN_SENS_SEV, DIFFN_DISTR)
        pgm_function7 = pgm_factor7.set_cpt()
        pgm_function7.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function7.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function7.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function7.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function7.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function7.set_cpd((1, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function7.set_cpd((2, 1), (0.5, 0.5, 0.0, 0.0))
        pgm_function7.set_cpd((3, 1), (0.0, 0.5, 0.5, 0.0))
        pgm_function7.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function7.set_cpd((1, 2), (0.25, 0.45, 0.25, 0.05))
        pgm_function7.set_cpd((2, 2), (0.1, 0.4, 0.4, 0.1))
        pgm_function7.set_cpd((3, 2), (0.05, 0.15, 0.4, 0.4))
        pgm_factor8 = self.new_factor(DIFFN_PATHO)
        pgm_function8 = pgm_factor8.set_cpt()
        pgm_function8.set_cpd((), (0.086, 0.01, 0.9, 0.002, 0.002))
        pgm_factor9 = self.new_factor(R_DIFFN_MEDD2_DISP, DIFFN_S_SEV_DIST, DIFFN_PATHO)
        pgm_function9 = pgm_factor9.set_cpt()
        pgm_function9.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function9.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function9.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function9.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function9.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function9.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0))
        pgm_function9.set_cpd((2, 1), (0.0, 0.5, 0.5, 0.0))
        pgm_function9.set_cpd((3, 1), (0.0, 0.1, 0.5, 0.4))
        pgm_function9.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function9.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function9.set_cpd((2, 2), (0.5, 0.5, 0.0, 0.0))
        pgm_function9.set_cpd((3, 2), (0.0, 0.5, 0.5, 0.0))
        pgm_function9.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function9.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function9.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function9.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function9.set_cpd((0, 4), (0.0, 0.0, 0.0, 1.0))
        pgm_function9.set_cpd((1, 4), (0.0, 0.0, 0.0, 1.0))
        pgm_function9.set_cpd((2, 4), (0.0, 0.0, 0.0, 1.0))
        pgm_function9.set_cpd((3, 4), (0.0, 0.0, 0.0, 1.0))
        pgm_factor10 = self.new_factor(R_DIFFN_LNLW_MEDD2_DISP_WD, R_LNLW_MEDD2_DISP_WD, R_DIFFN_MEDD2_DISP)
        pgm_function10 = pgm_factor10.set_cpt()
        pgm_function10.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function10.set_cpd((1, 0), (0.0749, 0.8229, 0.1022, 0.0))
        pgm_function10.set_cpd((2, 0), (0.0, 0.06260626, 0.93739374, 0.0))
        pgm_function10.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function10.set_cpd((0, 1), (0.0749, 0.8229, 0.1022, 0.0))
        pgm_function10.set_cpd((1, 1), (0.0047, 0.1786, 0.8167, 0.0))
        pgm_function10.set_cpd((2, 1), (0.0, 0.019, 0.9795, 0.0015))
        pgm_function10.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function10.set_cpd((0, 2), (0.0, 0.06260626, 0.93739374, 0.0))
        pgm_function10.set_cpd((1, 2), (0.0, 0.019, 0.9795, 0.0015))
        pgm_function10.set_cpd((2, 2), (0.0, 0.0001, 0.0833, 0.9166))
        pgm_function10.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function10.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function10.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function10.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function10.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor11 = self.new_factor(R_MEDD2_DISP_WD, R_DIFFN_LNLW_MEDD2_DISP_WD)
        pgm_function11 = pgm_factor11.set_cpt()
        pgm_function11.set_cpd((0,), (1.0, 0.0, 0.0, 0.0))
        pgm_function11.set_cpd((1,), (0.0, 1.0, 0.0, 0.0))
        pgm_function11.set_cpd((2,), (0.0, 0.0, 1.0, 0.0))
        pgm_function11.set_cpd((3,), (0.0, 0.0, 0.0, 1.0))
        pgm_factor12 = self.new_factor(R_LNLBE_MEDD2_DISP_EW)
        pgm_function12 = pgm_factor12.set_cpt()
        pgm_function12.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor13 = self.new_factor(R_MEDD2_DISP_EW, R_DIFFN_MEDD2_DISP, R_LNLBE_MEDD2_DISP_EW)
        pgm_function13 = pgm_factor13.set_cpt()
        pgm_function13.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function13.set_cpd((1, 0), (0.0749, 0.8229, 0.1022, 0.0))
        pgm_function13.set_cpd((2, 0), (0.0, 0.06260626, 0.93739374, 0.0))
        pgm_function13.set_cpd((3, 0), (0.0, 0.00790079, 0.60286029, 0.38923892))
        pgm_function13.set_cpd((0, 1), (0.0749, 0.8229, 0.1022, 0.0))
        pgm_function13.set_cpd((1, 1), (0.0047, 0.1786, 0.8167, 0.0))
        pgm_function13.set_cpd((2, 1), (0.0, 0.019, 0.9795, 0.0015))
        pgm_function13.set_cpd((3, 1), (0.0, 0.0001, 0.0069, 0.993))
        pgm_function13.set_cpd((0, 2), (0.0, 0.06260626, 0.93739374, 0.0))
        pgm_function13.set_cpd((1, 2), (0.0, 0.019, 0.9795, 0.0015))
        pgm_function13.set_cpd((2, 2), (0.0, 0.0001, 0.0833, 0.9166))
        pgm_function13.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function13.set_cpd((0, 3), (0.0, 0.00790079, 0.60286029, 0.38923892))
        pgm_function13.set_cpd((1, 3), (0.0, 0.0001, 0.0069, 0.993))
        pgm_function13.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function13.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor14 = self.new_factor(R_MEDD2_DISP_EWD, R_MEDD2_DISP_WD, R_MEDD2_DISP_EW)
        pgm_function14 = pgm_factor14.set_cpt()
        pgm_function14.set_cpd((0, 0), (0.0, 0.0, 0.0742, 0.9045, 0.0213, 0.0, 0.0, 0.0, 0.0))
        pgm_function14.set_cpd((1, 0), (0.0, 0.0, 0.0, 0.0, 0.0742, 0.9045, 0.0213, 0.0, 0.0))
        pgm_function14.set_cpd((2, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.133, 0.867))
        pgm_function14.set_cpd((3, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.133, 0.867))
        pgm_function14.set_cpd((0, 1), (0.0001, 0.2215, 0.7732, 0.0052, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function14.set_cpd((1, 1), (0.0, 0.0, 0.0, 0.13151315, 0.85768577, 0.01080108, 0.0, 0.0, 0.0))
        pgm_function14.set_cpd((2, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0108, 0.8577, 0.1315))
        pgm_function14.set_cpd((3, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0108, 0.8577, 0.1315))
        pgm_function14.set_cpd((0, 2), (0.1315, 0.8577, 0.0108, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function14.set_cpd((1, 2), (0.0, 0.0, 0.0742, 0.9045, 0.0213, 0.0, 0.0, 0.0, 0.0))
        pgm_function14.set_cpd((2, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0052, 0.7732, 0.2215, 0.0001))
        pgm_function14.set_cpd((3, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0052, 0.7732, 0.2215, 0.0001))
        pgm_function14.set_cpd((0, 3), (0.9933, 0.0067, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function14.set_cpd((1, 3), (0.0404, 0.9192, 0.0404, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function14.set_cpd((2, 3), (0.0, 0.0, 0.0213, 0.9045, 0.0742, 0.0, 0.0, 0.0, 0.0))
        pgm_function14.set_cpd((3, 3), (0.0, 0.0, 0.0213, 0.9045, 0.0742, 0.0, 0.0, 0.0, 0.0))
        pgm_factor15 = self.new_factor(R_DIFFN_MEDD2_BLOCK, DIFFN_S_SEV_DIST, DIFFN_PATHO)
        pgm_function15 = pgm_factor15.set_cpt()
        pgm_function15.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function15.set_cpd((1, 0), (0.8, 0.2, 0.0, 0.0, 0.0))
        pgm_function15.set_cpd((2, 0), (0.6, 0.4, 0.0, 0.0, 0.0))
        pgm_function15.set_cpd((3, 0), (0.25, 0.5, 0.25, 0.0, 0.0))
        pgm_function15.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function15.set_cpd((1, 1), (0.2, 0.5, 0.3, 0.0, 0.0))
        pgm_function15.set_cpd((2, 1), (0.0, 0.2, 0.5, 0.3, 0.0))
        pgm_function15.set_cpd((3, 1), (0.0, 0.0, 0.4, 0.5, 0.1))
        pgm_function15.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function15.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function15.set_cpd((2, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function15.set_cpd((3, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function15.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function15.set_cpd((1, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function15.set_cpd((2, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function15.set_cpd((3, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function15.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function15.set_cpd((1, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function15.set_cpd((2, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function15.set_cpd((3, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor16 = self.new_factor(R_LNLBE_MEDD2_BLOCK_EW)
        pgm_function16 = pgm_factor16.set_cpt()
        pgm_function16.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor17 = self.new_factor(R_MEDD2_BLOCK_EW, R_DIFFN_MEDD2_BLOCK, R_LNLBE_MEDD2_BLOCK_EW)
        pgm_function17 = pgm_factor17.set_cpt()
        pgm_function17.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function17.set_cpd((1, 0), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function17.set_cpd((2, 0), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function17.set_cpd((3, 0), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function17.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function17.set_cpd((0, 1), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function17.set_cpd((1, 1), (0.0001, 0.498, 0.5019, 0.0, 0.0))
        pgm_function17.set_cpd((2, 1), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function17.set_cpd((3, 1), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function17.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function17.set_cpd((0, 2), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function17.set_cpd((1, 2), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function17.set_cpd((2, 2), (0.0, 0.0007, 0.4328, 0.5665, 0.0))
        pgm_function17.set_cpd((3, 2), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function17.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function17.set_cpd((0, 3), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function17.set_cpd((1, 3), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function17.set_cpd((2, 3), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function17.set_cpd((3, 3), (0.00030003, 0.00110011, 0.01250125, 0.98609861, 0.0))
        pgm_function17.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function17.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function17.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function17.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function17.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function17.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor18 = self.new_factor(R_MEDD2_AMPR_EW, R_MEDD2_DISP_EWD, R_MEDD2_BLOCK_EW)
        pgm_function18 = pgm_factor18.set_cpt()
        pgm_function18.set_cpd((0, 0),
                               (0.0, 0.28267173, 0.71642836, 0.00089991, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function18.set_cpd((1, 0), (0.0, 0.0, 0.5547, 0.4268, 0.0183, 0.0002, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function18.set_cpd((2, 0), (
            0.0, 0.0, 0.0090009, 0.51275128, 0.41524152, 0.05890589, 0.00390039, 0.00020002, 0.0, 0.0, 0.0, 0.0))
        pgm_function18.set_cpd((3, 0),
                               (0.0, 0.0, 0.0, 0.0635, 0.4459, 0.3732, 0.0995, 0.0162, 0.0015, 0.0002, 0.0, 0.0))
        pgm_function18.set_cpd((4, 0), (
            0.0, 0.0, 0.0, 0.00290029, 0.11411141, 0.39513951, 0.31983198, 0.13151315, 0.02980298, 0.00580058,
            0.00090009,
            0.0))
        pgm_function18.set_cpd((5, 0),
                               (0.0, 0.0, 0.0, 0.0001, 0.0136, 0.1578, 0.3285, 0.2966, 0.1404, 0.0483, 0.0135, 0.0012))
        pgm_function18.set_cpd((6, 0), (
            0.0, 0.0, 0.0, 0.0, 0.00120024, 0.0385077, 0.17463493, 0.30156031, 0.26135227, 0.14472895, 0.06511302,
            0.01290258))
        pgm_function18.set_cpd((7, 0),
                               (0.0, 0.0, 0.0, 0.0, 0.0001, 0.0062, 0.058, 0.1828, 0.2779, 0.2392, 0.1675, 0.0683))
        pgm_function18.set_cpd((8, 0),
                               (0.0, 0.0, 0.0, 0.0, 0.0, 0.0009, 0.0157, 0.0823, 0.2012, 0.2516, 0.2559, 0.1924))
        pgm_function18.set_cpd((0, 1), (0.0, 0.9103, 0.0897, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function18.set_cpd((1, 1), (0.0, 0.0004, 0.8945, 0.1036, 0.0015, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function18.set_cpd((2, 1), (
            0.0, 0.0, 0.1140114, 0.7169717, 0.15981598, 0.00890089, 0.00030003, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function18.set_cpd((3, 1), (0.0, 0.0, 0.0026, 0.3111, 0.5155, 0.1499, 0.019, 0.0018, 0.0001, 0.0, 0.0, 0.0))
        pgm_function18.set_cpd((4, 1),
                               (0.0, 0.0, 0.0, 0.0451, 0.3717, 0.4039, 0.1433, 0.0313, 0.0041, 0.0005, 0.0001, 0.0))
        pgm_function18.set_cpd((5, 1),
                               (0.0, 0.0, 0.0, 0.0035, 0.1122, 0.3738, 0.3186, 0.1444, 0.0376, 0.0083, 0.0015, 0.0001))
        pgm_function18.set_cpd((6, 1), (
            0.0, 0.0, 0.0, 0.00020002, 0.02260226, 0.1890189, 0.33173317, 0.27442744, 0.12521252, 0.04310431,
            0.01240124,
            0.00130013))
        pgm_function18.set_cpd((7, 1), (
            0.0, 0.0, 0.0, 0.0, 0.00310031, 0.06150615, 0.21092109, 0.30513051, 0.23442344, 0.12171217, 0.05280528,
            0.01040104))
        pgm_function18.set_cpd((8, 1),
                               (0.0, 0.0, 0.0, 0.0, 0.0004, 0.0166, 0.1002, 0.2325, 0.2777, 0.2039, 0.1251, 0.0436))
        pgm_function18.set_cpd((0, 2), (0.0, 0.9974, 0.0026, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function18.set_cpd((1, 2), (0.0, 0.3856, 0.6048, 0.0095, 0.0001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function18.set_cpd((2, 2), (0.0, 0.0073, 0.8191, 0.1638, 0.0095, 0.0003, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function18.set_cpd((3, 2), (0.0, 0.0001, 0.386, 0.4993, 0.1036, 0.0101, 0.0008, 0.0001, 0.0, 0.0, 0.0, 0.0))
        pgm_function18.set_cpd((4, 2),
                               (0.0, 0.0, 0.0913, 0.5259, 0.3027, 0.0681, 0.0104, 0.0014, 0.0002, 0.0, 0.0, 0.0))
        pgm_function18.set_cpd((5, 2), (
            0.0, 0.0, 0.0149985, 0.30686931, 0.42035796, 0.19288071, 0.05119488, 0.01139886, 0.00189981, 0.00029997,
            9.999e-05, 0.0))
        pgm_function18.set_cpd((6, 2),
                               (0.0, 0.0, 0.0023, 0.1333, 0.3728, 0.3075, 0.1292, 0.0421, 0.0099, 0.0024, 0.0005, 0.0))
        pgm_function18.set_cpd((7, 2), (
            0.0, 0.0, 0.00030003, 0.04440444, 0.24132413, 0.34313431, 0.22082208, 0.10251025, 0.03370337, 0.01040104,
            0.0030003, 0.00040004))
        pgm_function18.set_cpd((8, 2),
                               (0.0, 0.0, 0.0, 0.0138, 0.1311, 0.2956, 0.2729, 0.1711, 0.0745, 0.0286, 0.0104, 0.002))
        pgm_function18.set_cpd((0, 3), (
            0.0, 0.94670533, 0.04919508, 0.00349965, 0.00049995, 9.999e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function18.set_cpd((1, 3), (
            0.0, 0.87211279, 0.1109889, 0.01349865, 0.00249975, 0.00059994, 0.00019998, 9.999e-05, 0.0, 0.0, 0.0, 0.0))
        pgm_function18.set_cpd((2, 3), (
            0.0, 0.77825565, 0.18013603, 0.03120624, 0.0075015, 0.0020004, 0.00060012, 0.00020004, 0.00010002, 0.0, 0.0,
            0.0))
        pgm_function18.set_cpd((3, 3),
                               (0.0, 0.678, 0.2436, 0.0548, 0.0156, 0.005, 0.0018, 0.0007, 0.0003, 0.0001, 0.0001, 0.0))
        pgm_function18.set_cpd((4, 3), (
            0.0, 0.5789, 0.2957, 0.082, 0.027, 0.0096, 0.0037, 0.0017, 0.0007, 0.0004, 0.0002, 0.0001))
        pgm_function18.set_cpd((5, 3), (
            0.0, 0.485, 0.334, 0.1106, 0.0411, 0.0162, 0.0068, 0.0033, 0.0015, 0.0008, 0.0004, 0.0003))
        pgm_function18.set_cpd((6, 3), (
            0.0, 0.40484048, 0.35663566, 0.13671367, 0.05620562, 0.0240024, 0.01080108, 0.00540054, 0.00270027,
            0.00140014,
            0.00080008, 0.00050005))
        pgm_function18.set_cpd((7, 3), (
            0.0, 0.33163367, 0.36712657, 0.16126775, 0.07268546, 0.0334933, 0.0159968, 0.0084983, 0.00439912,
            0.00239952,
            0.0014997, 0.0009998))
        pgm_function18.set_cpd((8, 3), (
            0.0, 0.2731, 0.3669, 0.1808, 0.0881, 0.0434, 0.0217, 0.012, 0.0064, 0.0036, 0.0023, 0.0017))
        pgm_function18.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function18.set_cpd((1, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function18.set_cpd((2, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function18.set_cpd((3, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function18.set_cpd((4, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function18.set_cpd((5, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function18.set_cpd((6, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function18.set_cpd((7, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function18.set_cpd((8, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor19 = self.new_factor(R_LNLBE_MEDD2_LD_EW)
        pgm_function19 = pgm_factor19.set_cpt()
        pgm_function19.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor20 = self.new_factor(R_MEDD2_LD_EW, R_LNLBE_MEDD2_LD_EW)
        pgm_function20 = pgm_factor20.set_cpt()
        pgm_function20.set_cpd((0,), (1.0, 0.0, 0.0, 0.0))
        pgm_function20.set_cpd((1,), (0.0, 1.0, 0.0, 0.0))
        pgm_function20.set_cpd((2,), (0.0, 0.0, 1.0, 0.0))
        pgm_function20.set_cpd((3,), (0.0, 0.0, 0.0, 1.0))
        pgm_factor21 = self.new_factor(R_LNLBE_MEDD2_RD_EW)
        pgm_function21 = pgm_factor21.set_cpt()
        pgm_function21.set_cpd((), (1.0, 0.0, 0.0))
        pgm_factor22 = self.new_factor(R_MEDD2_RD_EW, R_LNLBE_MEDD2_RD_EW)
        pgm_function22 = pgm_factor22.set_cpt()
        pgm_function22.set_cpd((0,), (1.0, 0.0, 0.0))
        pgm_function22.set_cpd((1,), (0.0, 1.0, 0.0))
        pgm_function22.set_cpd((2,), (0.0, 0.0, 1.0))
        pgm_factor23 = self.new_factor(R_MEDD2_LSLOW_EW, R_MEDD2_LD_EW, R_MEDD2_RD_EW)
        pgm_function23 = pgm_factor23.set_cpt()
        pgm_function23.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function23.set_cpd((1, 0), (0.0185, 0.9561, 0.0254, 0.0, 0.0))
        pgm_function23.set_cpd((2, 0), (0.0, 0.0166, 0.9834, 0.0, 0.0))
        pgm_function23.set_cpd((3, 0), (0.0007, 0.002, 0.0219, 0.9754, 0.0))
        pgm_function23.set_cpd((0, 1), (0.00840084, 0.01190119, 0.06190619, 0.91739174, 0.00040004))
        pgm_function23.set_cpd((1, 1), (0.00690069, 0.010001, 0.05350535, 0.92869287, 0.00090009))
        pgm_function23.set_cpd((2, 1), (0.00559944, 0.00829917, 0.04519548, 0.93890611, 0.0019998))
        pgm_function23.set_cpd((3, 1), (0.0023, 0.0036, 0.0217, 0.8326, 0.1398))
        pgm_function23.set_cpd((0, 2), (0.00529947, 0.00619938, 0.02639736, 0.20817918, 0.75392461))
        pgm_function23.set_cpd((1, 2), (0.0049, 0.0057, 0.0244, 0.1966, 0.7684))
        pgm_function23.set_cpd((2, 2), (0.00440044, 0.00520052, 0.02240224, 0.18391839, 0.78407841))
        pgm_function23.set_cpd((3, 2), (0.0028, 0.0033, 0.0145, 0.1304, 0.849))
        pgm_factor24 = self.new_factor(R_LNLW_MEDD2_SALOSS_WD, R_LNLW_MED_SEV, R_LNLW_MED_PATHO)
        pgm_function24 = pgm_factor24.set_cpt()
        pgm_function24.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function24.set_cpd((1, 0), (0.5, 0.5, 0.0, 0.0, 0.0))
        pgm_function24.set_cpd((2, 0), (0.0, 0.5, 0.5, 0.0, 0.0))
        pgm_function24.set_cpd((3, 0), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function24.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.4, 0.6))
        pgm_function24.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function24.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0, 0.0))
        pgm_function24.set_cpd((2, 1), (0.2, 0.5, 0.3, 0.0, 0.0))
        pgm_function24.set_cpd((3, 1), (0.0, 0.2, 0.5, 0.3, 0.0))
        pgm_function24.set_cpd((4, 1), (0.0, 0.1, 0.4, 0.4, 0.1))
        pgm_function24.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function24.set_cpd((1, 2), (0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function24.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function24.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function24.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function24.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function24.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function24.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function24.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function24.set_cpd((4, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function24.set_cpd((0, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function24.set_cpd((1, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function24.set_cpd((2, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function24.set_cpd((3, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function24.set_cpd((4, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_factor25 = self.new_factor(R_DIFFN_MEDD2_SALOSS, DIFFN_S_SEV_DIST, DIFFN_PATHO)
        pgm_function25 = pgm_factor25.set_cpt()
        pgm_function25.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function25.set_cpd((1, 0), (0.5, 0.5, 0.0, 0.0, 0.0))
        pgm_function25.set_cpd((2, 0), (0.0, 0.5, 0.5, 0.0, 0.0))
        pgm_function25.set_cpd((3, 0), (0.0, 0.0, 0.0, 0.7, 0.3))
        pgm_function25.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function25.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0, 0.0))
        pgm_function25.set_cpd((2, 1), (0.4, 0.3, 0.3, 0.0, 0.0))
        pgm_function25.set_cpd((3, 1), (0.0, 0.3, 0.5, 0.2, 0.0))
        pgm_function25.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function25.set_cpd((1, 2), (0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function25.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function25.set_cpd((3, 2), (0.0, 0.0, 0.0, 0.7, 0.3))
        pgm_function25.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function25.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function25.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function25.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function25.set_cpd((0, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function25.set_cpd((1, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function25.set_cpd((2, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function25.set_cpd((3, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_factor26 = self.new_factor(R_DIFFN_LNLW_MEDD2_SALOSS, R_LNLW_MEDD2_SALOSS_WD, R_DIFFN_MEDD2_SALOSS)
        pgm_function26 = pgm_factor26.set_cpt()
        pgm_function26.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function26.set_cpd((1, 0), (0.0073, 0.9812, 0.0115, 0.0, 0.0))
        pgm_function26.set_cpd((2, 0), (0.0017, 0.1306, 0.867, 0.0007, 0.0))
        pgm_function26.set_cpd((3, 0), (0.0, 0.0003, 0.0212, 0.9785, 0.0))
        pgm_function26.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function26.set_cpd((0, 1), (0.0073, 0.9812, 0.0115, 0.0, 0.0))
        pgm_function26.set_cpd((1, 1), (0.0, 0.0289, 0.9711, 0.0, 0.0))
        pgm_function26.set_cpd((2, 1), (0.0, 0.0097, 0.5989, 0.3914, 0.0))
        pgm_function26.set_cpd((3, 1), (0.0, 0.0, 0.0017, 0.9983, 0.0))
        pgm_function26.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function26.set_cpd((0, 2), (0.0017, 0.1306, 0.867, 0.0007, 0.0))
        pgm_function26.set_cpd((1, 2), (0.0, 0.0097, 0.5989, 0.3914, 0.0))
        pgm_function26.set_cpd((2, 2), (0.0, 0.00049995, 0.03309669, 0.96640336, 0.0))
        pgm_function26.set_cpd((3, 2), (0.0, 0.0, 0.0008, 0.9992, 0.0))
        pgm_function26.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function26.set_cpd((0, 3), (0.0, 0.0003, 0.0212, 0.9785, 0.0))
        pgm_function26.set_cpd((1, 3), (0.0, 0.0, 0.0017, 0.9983, 0.0))
        pgm_function26.set_cpd((2, 3), (0.0, 0.0, 0.0008, 0.9992, 0.0))
        pgm_function26.set_cpd((3, 3), (0.0, 0.0, 0.0001, 0.9999, 0.0))
        pgm_function26.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function26.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function26.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function26.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function26.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function26.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor27 = self.new_factor(R_LNLBE_MEDD2_SALOSS_EW)
        pgm_function27 = pgm_factor27.set_cpt()
        pgm_function27.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor28 = self.new_factor(R_MEDD2_SALOSS, R_DIFFN_LNLW_MEDD2_SALOSS, R_LNLBE_MEDD2_SALOSS_EW)
        pgm_function28 = pgm_factor28.set_cpt()
        pgm_function28.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function28.set_cpd((1, 0), (0.0073, 0.9812, 0.0115, 0.0, 0.0))
        pgm_function28.set_cpd((2, 0), (0.0017, 0.1306, 0.867, 0.0007, 0.0))
        pgm_function28.set_cpd((3, 0), (0.0, 0.0003, 0.0212, 0.9785, 0.0))
        pgm_function28.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function28.set_cpd((0, 1), (0.0073, 0.9812, 0.0115, 0.0, 0.0))
        pgm_function28.set_cpd((1, 1), (0.0, 0.0289, 0.9711, 0.0, 0.0))
        pgm_function28.set_cpd((2, 1), (0.0, 0.0097, 0.5989, 0.3914, 0.0))
        pgm_function28.set_cpd((3, 1), (0.0, 0.0, 0.0017, 0.9983, 0.0))
        pgm_function28.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function28.set_cpd((0, 2), (0.0017, 0.1306, 0.867, 0.0007, 0.0))
        pgm_function28.set_cpd((1, 2), (0.0, 0.0097, 0.5989, 0.3914, 0.0))
        pgm_function28.set_cpd((2, 2), (0.0, 0.00049995, 0.03309669, 0.96640336, 0.0))
        pgm_function28.set_cpd((3, 2), (0.0, 0.0, 0.0008, 0.9992, 0.0))
        pgm_function28.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function28.set_cpd((0, 3), (0.0, 0.0003, 0.0212, 0.9785, 0.0))
        pgm_function28.set_cpd((1, 3), (0.0, 0.0, 0.0017, 0.9983, 0.0))
        pgm_function28.set_cpd((2, 3), (0.0, 0.0, 0.0008, 0.9992, 0.0))
        pgm_function28.set_cpd((3, 3), (0.0, 0.0, 0.0001, 0.9999, 0.0))
        pgm_function28.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function28.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function28.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function28.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function28.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function28.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor29 = self.new_factor(R_DIFFN_MEDD2_DIFSLOW, DIFFN_S_SEV_DIST, DIFFN_PATHO)
        pgm_function29 = pgm_factor29.set_cpt()
        pgm_function29.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function29.set_cpd((1, 0), (0.0, 0.5, 0.5, 0.0))
        pgm_function29.set_cpd((2, 0), (0.0, 0.2, 0.6, 0.2))
        pgm_function29.set_cpd((3, 0), (0.0, 0.1, 0.6, 0.3))
        pgm_function29.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function29.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0))
        pgm_function29.set_cpd((2, 1), (0.2, 0.4, 0.3, 0.1))
        pgm_function29.set_cpd((3, 1), (0.2, 0.4, 0.3, 0.1))
        pgm_function29.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function29.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function29.set_cpd((2, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function29.set_cpd((3, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function29.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function29.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function29.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function29.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function29.set_cpd((0, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_function29.set_cpd((1, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_function29.set_cpd((2, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_function29.set_cpd((3, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_factor30 = self.new_factor(R_MEDD2_DIFSLOW_EW, R_DIFFN_MEDD2_DIFSLOW)
        pgm_function30 = pgm_factor30.set_cpt()
        pgm_function30.set_cpd((0,), (1.0, 0.0, 0.0, 0.0))
        pgm_function30.set_cpd((1,), (0.0, 1.0, 0.0, 0.0))
        pgm_function30.set_cpd((2,), (0.0, 0.0, 1.0, 0.0))
        pgm_function30.set_cpd((3,), (0.0, 0.0, 0.0, 1.0))
        pgm_factor31 = self.new_factor(R_MEDD2_DSLOW_EW, R_MEDD2_SALOSS, R_MEDD2_DIFSLOW_EW)
        pgm_function31 = pgm_factor31.set_cpt()
        pgm_function31.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function31.set_cpd((1, 0), (0.1036, 0.8964, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function31.set_cpd((2, 0), (0.00059994, 0.99730027, 0.00209979, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function31.set_cpd((3, 0), (0.0001, 0.0629, 0.9278, 0.0092, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function31.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function31.set_cpd((0, 1), (0.0532, 0.2387, 0.495, 0.2072, 0.0059, 0.0, 0.0, 0.0, 0.0))
        pgm_function31.set_cpd((1, 1), (0.01780178, 0.1190119, 0.44814481, 0.38543854, 0.02960296, 0.0, 0.0, 0.0, 0.0))
        pgm_function31.set_cpd((2, 1), (0.0048, 0.0476, 0.3148, 0.5311, 0.1016, 0.0001, 0.0, 0.0, 0.0))
        pgm_function31.set_cpd((3, 1),
                               (0.00060006, 0.00920092, 0.1160116, 0.48574857, 0.38353835, 0.00490049, 0.0, 0.0, 0.0))
        pgm_function31.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function31.set_cpd((0, 2), (0.0007, 0.0063, 0.0614, 0.3006, 0.5524, 0.0781, 0.0005, 0.0, 0.0))
        pgm_function31.set_cpd((1, 2), (0.0002, 0.0021, 0.0283, 0.1995, 0.5939, 0.1737, 0.0023, 0.0, 0.0))
        pgm_function31.set_cpd((2, 2),
                               (0.0, 0.00060006, 0.01140114, 0.11471147, 0.54455446, 0.31963196, 0.00910091, 0.0, 0.0))
        pgm_function31.set_cpd((3, 2),
                               (0.0, 0.00010001, 0.00240024, 0.03740374, 0.33273327, 0.56705671, 0.06030603, 0.0, 0.0))
        pgm_function31.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function31.set_cpd((0, 3), (0.0003, 0.0011, 0.005, 0.0205, 0.087, 0.2822, 0.4514, 0.1525, 0.0))
        pgm_function31.set_cpd((1, 3), (0.0002, 0.0006, 0.0029, 0.0133, 0.0634, 0.2436, 0.4657, 0.2103, 0.0))
        pgm_function31.set_cpd((2, 3), (
            0.00010001, 0.00030003, 0.00170017, 0.00830083, 0.04470447, 0.20312031, 0.46324632, 0.27852785, 0.0))
        pgm_function31.set_cpd((3, 3), (
            0.0, 0.00010001, 0.00070007, 0.00380038, 0.02430243, 0.14161416, 0.4240424, 0.40544054, 0.0))
        pgm_function31.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor32 = self.new_factor(R_MEDD2_ALLCV_EW, R_MEDD2_LSLOW_EW, R_MEDD2_DSLOW_EW)
        pgm_function32 = pgm_factor32.set_cpt()
        pgm_function32.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function32.set_cpd((1, 0), (0.0264, 0.9149, 0.0587, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function32.set_cpd((2, 0), (0.0, 0.0218, 0.9469, 0.0313, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function32.set_cpd((3, 0), (
            0.00030003, 0.00190019, 0.0140014, 0.07880788, 0.32383238, 0.45964596, 0.12121212, 0.00030003, 0.0))
        pgm_function32.set_cpd((4, 0),
                               (0.0, 0.0, 0.00010001, 0.00050005, 0.00410041, 0.03840384, 0.21452145, 0.74237424, 0.0))
        pgm_function32.set_cpd((0, 1), (0.03049695, 0.96720328, 0.00229977, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function32.set_cpd((1, 1), (0.0006, 0.0944, 0.8841, 0.0209, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function32.set_cpd((2, 1), (0.0, 0.0007, 0.2183, 0.779, 0.002, 0.0, 0.0, 0.0, 0.0))
        pgm_function32.set_cpd((3, 1), (
            9.999e-05, 0.00039996, 0.00429957, 0.03209679, 0.19558044, 0.50484952, 0.26037396, 0.00229977, 0.0))
        pgm_function32.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.00020002, 0.00210021, 0.02390239, 0.16481648, 0.8089809, 0.0))
        pgm_function32.set_cpd((0, 2), (0.00039996, 0.06189381, 0.88811119, 0.04959504, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function32.set_cpd((1, 2), (0.0, 0.0018, 0.1956, 0.786, 0.0166, 0.0, 0.0, 0.0, 0.0))
        pgm_function32.set_cpd((2, 2), (0.0, 0.0, 0.0077, 0.4577, 0.5345, 0.0001, 0.0, 0.0, 0.0))
        pgm_function32.set_cpd((3, 2), (0.0, 0.0001, 0.0007, 0.0074, 0.0735, 0.4044, 0.4938, 0.0201, 0.0))
        pgm_function32.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0001, 0.0008, 0.0123, 0.1119, 0.8749, 0.0))
        pgm_function32.set_cpd((0, 3), (0.0, 0.0001, 0.0655, 0.9082, 0.0262, 0.0, 0.0, 0.0, 0.0))
        pgm_function32.set_cpd((1, 3), (0.0, 0.0, 0.0026, 0.2655, 0.7316, 0.0003, 0.0, 0.0, 0.0))
        pgm_function32.set_cpd((2, 3), (0.0, 0.0, 0.0, 0.0166, 0.9182, 0.0652, 0.0, 0.0, 0.0))
        pgm_function32.set_cpd((3, 3), (0.0, 0.0, 0.0001, 0.001, 0.0172, 0.2179, 0.6479, 0.1159, 0.0))
        pgm_function32.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.0003, 0.0055, 0.0699, 0.9243, 0.0))
        pgm_function32.set_cpd((0, 4), (0.0, 0.0, 0.0001, 0.0555, 0.937, 0.0074, 0.0, 0.0, 0.0))
        pgm_function32.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0044, 0.5355, 0.46, 0.0001, 0.0, 0.0))
        pgm_function32.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 0.0398, 0.946, 0.0142, 0.0, 0.0))
        pgm_function32.set_cpd((3, 4), (0.0, 0.0, 0.0, 9.999e-05, 0.00179982, 0.05589441, 0.46005399, 0.48215178, 0.0))
        pgm_function32.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 0.0001, 0.0021, 0.039, 0.9588, 0.0))
        pgm_function32.set_cpd((0, 5), (0.0, 0.0, 0.0, 0.0002, 0.0491, 0.8863, 0.0644, 0.0, 0.0))
        pgm_function32.set_cpd((1, 5), (0.0, 0.0, 0.0, 0.0, 0.0047, 0.5053, 0.49, 0.0, 0.0))
        pgm_function32.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0002, 0.1104, 0.8881, 0.0013, 0.0))
        pgm_function32.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0001, 0.0041, 0.1033, 0.8925, 0.0))
        pgm_function32.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.00069993, 0.01889811, 0.98040196, 0.0))
        pgm_function32.set_cpd((0, 6), (0.0, 0.0, 0.0, 0.0, 0.00029997, 0.09559044, 0.89661034, 0.00749925, 0.0))
        pgm_function32.set_cpd((1, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0218, 0.8352, 0.143, 0.0))
        pgm_function32.set_cpd((2, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.002, 0.3203, 0.6777, 0.0))
        pgm_function32.set_cpd((3, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0003, 0.0194, 0.9803, 0.0))
        pgm_function32.set_cpd((4, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0002, 0.0093, 0.9905, 0.0))
        pgm_function32.set_cpd((0, 7), (
            0.00020002, 0.00060006, 0.00190019, 0.00640064, 0.02470247, 0.09740974, 0.28552855, 0.58325833, 0.0))
        pgm_function32.set_cpd((1, 7), (0.0001, 0.0003, 0.001, 0.0036, 0.0154, 0.0712, 0.2467, 0.6617, 0.0))
        pgm_function32.set_cpd((2, 7), (
            0.0, 0.00010001, 0.00050005, 0.00190019, 0.00930093, 0.05040504, 0.20722072, 0.73057306, 0.0))
        pgm_function32.set_cpd((3, 7), (0.0, 0.0, 0.0001, 0.0004, 0.0026, 0.019, 0.1153, 0.8626, 0.0))
        pgm_function32.set_cpd((4, 7), (0.0, 0.0, 0.0, 0.0001, 0.0006, 0.0062, 0.0562, 0.9369, 0.0))
        pgm_function32.set_cpd((0, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function32.set_cpd((1, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function32.set_cpd((2, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function32.set_cpd((3, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function32.set_cpd((4, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor33 = self.new_factor(R_MEDD2_CV_EW, R_MEDD2_ALLCV_EW)
        pgm_function33 = pgm_factor33.set_cpt()
        pgm_function33.set_cpd((0,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0012, 0.0172, 0.1126, 0.2484, 0.321, 0.1935,
            0.0803, 0.0258))
        pgm_function33.set_cpd((1,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0009999, 0.01489851, 0.09959004, 0.22617738, 0.29337066,
            0.22617738, 0.1019898, 0.02889711, 0.00649935, 0.00139986))
        pgm_function33.set_cpd((2,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00250025, 0.03170317, 0.14451445, 0.26392639, 0.29252925,
            0.1670167,
            0.06690669, 0.02450245, 0.00540054, 0.00090009, 0.00010001, 0.0))
        pgm_function33.set_cpd((3,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0005, 0.0189, 0.1567, 0.3371, 0.2862, 0.1429, 0.0465, 0.0095, 0.0014,
            0.0003,
            0.0, 0.0, 0.0, 0.0))
        pgm_function33.set_cpd((4,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.01049895, 0.15648435, 0.37786221, 0.30066993, 0.12518748, 0.02449755, 0.00419958,
            0.00049995, 9.999e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function33.set_cpd((5,), (
            0.0, 0.0, 0.0, 0.0045, 0.1674, 0.4536, 0.2834, 0.0774, 0.0118, 0.0017, 0.0002, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0))
        pgm_function33.set_cpd((6,), (
            0.0, 0.0, 0.01090109, 0.42284228, 0.44464446, 0.10661066, 0.01370137, 0.00120012, 0.00010001, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function33.set_cpd((7,), (
            0.0, 0.0199, 0.8041, 0.1629, 0.0125, 0.0006, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0,
            0.0))
        pgm_function33.set_cpd((8,), (
            1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor34 = self.new_factor(R_LNLW_MEDD2_BLOCK_WD, R_LNLW_MED_SEV, R_LNLW_MED_PATHO)
        pgm_function34 = pgm_factor34.set_cpt()
        pgm_function34.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function34.set_cpd((1, 0), (0.8, 0.2, 0.0, 0.0, 0.0))
        pgm_function34.set_cpd((2, 0), (0.3, 0.6, 0.1, 0.0, 0.0))
        pgm_function34.set_cpd((3, 0), (0.1, 0.5, 0.3, 0.1, 0.0))
        pgm_function34.set_cpd((4, 0), (0.0, 0.05, 0.2, 0.55, 0.2))
        pgm_function34.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function34.set_cpd((1, 1), (0.0, 0.5, 0.5, 0.0, 0.0))
        pgm_function34.set_cpd((2, 1), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function34.set_cpd((3, 1), (0.0, 0.0, 0.2, 0.6, 0.2))
        pgm_function34.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function34.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function34.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function34.set_cpd((2, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function34.set_cpd((3, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function34.set_cpd((4, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function34.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function34.set_cpd((1, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function34.set_cpd((2, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function34.set_cpd((3, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function34.set_cpd((4, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function34.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function34.set_cpd((1, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function34.set_cpd((2, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function34.set_cpd((3, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function34.set_cpd((4, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor35 = self.new_factor(R_MEDD2_BLOCK_WD, R_LNLW_MEDD2_BLOCK_WD, R_DIFFN_MEDD2_BLOCK)
        pgm_function35 = pgm_factor35.set_cpt()
        pgm_function35.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function35.set_cpd((1, 0), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function35.set_cpd((2, 0), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function35.set_cpd((3, 0), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function35.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function35.set_cpd((0, 1), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function35.set_cpd((1, 1), (0.0001, 0.498, 0.5019, 0.0, 0.0))
        pgm_function35.set_cpd((2, 1), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function35.set_cpd((3, 1), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function35.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function35.set_cpd((0, 2), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function35.set_cpd((1, 2), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function35.set_cpd((2, 2), (0.0, 0.0007, 0.4328, 0.5665, 0.0))
        pgm_function35.set_cpd((3, 2), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function35.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function35.set_cpd((0, 3), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function35.set_cpd((1, 3), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function35.set_cpd((2, 3), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function35.set_cpd((3, 3), (0.00030003, 0.00110011, 0.01250125, 0.98609861, 0.0))
        pgm_function35.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function35.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function35.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function35.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function35.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function35.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor36 = self.new_factor(R_MEDD2_EFFAXLOSS, R_MEDD2_BLOCK_WD, R_MEDD2_SALOSS)
        pgm_function36 = pgm_factor36.set_cpt()
        pgm_function36.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function36.set_cpd((1, 0), (0.0073, 0.9812, 0.0115, 0.0, 0.0))
        pgm_function36.set_cpd((2, 0), (0.0017, 0.1306, 0.867, 0.0007, 0.0))
        pgm_function36.set_cpd((3, 0), (0.0, 0.0003, 0.0212, 0.9785, 0.0))
        pgm_function36.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function36.set_cpd((0, 1), (0.0073, 0.9812, 0.0115, 0.0, 0.0))
        pgm_function36.set_cpd((1, 1), (0.0, 0.0289, 0.9711, 0.0, 0.0))
        pgm_function36.set_cpd((2, 1), (0.0, 0.0097, 0.5989, 0.3914, 0.0))
        pgm_function36.set_cpd((3, 1), (0.0, 0.0, 0.0017, 0.9983, 0.0))
        pgm_function36.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function36.set_cpd((0, 2), (0.0017, 0.1306, 0.867, 0.0007, 0.0))
        pgm_function36.set_cpd((1, 2), (0.0, 0.0097, 0.5989, 0.3914, 0.0))
        pgm_function36.set_cpd((2, 2), (0.0, 0.00049995, 0.03309669, 0.96640336, 0.0))
        pgm_function36.set_cpd((3, 2), (0.0, 0.0, 0.0008, 0.9992, 0.0))
        pgm_function36.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function36.set_cpd((0, 3), (0.0, 0.0003, 0.0212, 0.9785, 0.0))
        pgm_function36.set_cpd((1, 3), (0.0, 0.0, 0.0017, 0.9983, 0.0))
        pgm_function36.set_cpd((2, 3), (0.0, 0.0, 0.0008, 0.9992, 0.0))
        pgm_function36.set_cpd((3, 3), (0.0, 0.0, 0.0001, 0.9999, 0.0))
        pgm_function36.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function36.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function36.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function36.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function36.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function36.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor37 = self.new_factor(R_MEDD2_ALLAMP_WD, R_MEDD2_DISP_WD, R_MEDD2_EFFAXLOSS)
        pgm_function37 = pgm_factor37.set_cpt()
        pgm_function37.set_cpd((0, 0), (0.0, 0.0, 0.0, 0.0, 0.0215, 0.9785))
        pgm_function37.set_cpd((1, 0), (0.0, 0.0, 0.0, 0.3192, 0.6448, 0.036))
        pgm_function37.set_cpd((2, 0), (0.0, 0.0, 0.0051, 0.994, 0.0009, 0.0))
        pgm_function37.set_cpd((3, 0), (0.0, 0.0, 0.9945, 0.0055, 0.0, 0.0))
        pgm_function37.set_cpd((0, 1), (0.0, 0.0, 0.0, 0.3443, 0.6228, 0.0329))
        pgm_function37.set_cpd((1, 1), (0.0, 0.0, 0.04740474, 0.93949395, 0.01290129, 0.00020002))
        pgm_function37.set_cpd((2, 1), (0.0, 0.0, 0.9599, 0.0401, 0.0, 0.0))
        pgm_function37.set_cpd((3, 1), (0.0, 0.0, 0.9999, 0.0001, 0.0, 0.0))
        pgm_function37.set_cpd((0, 2), (0.0, 0.0, 0.0248, 0.9704, 0.0048, 0.0))
        pgm_function37.set_cpd((1, 2), (0.0, 0.0, 0.93309331, 0.06690669, 0.0, 0.0))
        pgm_function37.set_cpd((2, 2), (0.0, 0.0001, 0.9994, 0.0005, 0.0, 0.0))
        pgm_function37.set_cpd((3, 2), (0.0, 0.7508, 0.2492, 0.0, 0.0, 0.0))
        pgm_function37.set_cpd((0, 3), (0.0, 0.1028, 0.8793, 0.0178, 0.0001, 0.0))
        pgm_function37.set_cpd((1, 3), (0.0, 0.8756, 0.1237, 0.0007, 0.0, 0.0))
        pgm_function37.set_cpd((2, 3), (0.0, 0.9969, 0.0031, 0.0, 0.0, 0.0))
        pgm_function37.set_cpd((3, 3), (0.0, 0.9999, 0.0001, 0.0, 0.0, 0.0))
        pgm_function37.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function37.set_cpd((1, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function37.set_cpd((2, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function37.set_cpd((3, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor38 = self.new_factor(R_MEDD2_AMP_WD, R_MEDD2_ALLAMP_WD)
        pgm_function38 = pgm_factor38.set_cpt()
        pgm_function38.set_cpd((0,), (
            0.75007501, 0.18781878, 0.04760476, 0.01120112, 0.00260026, 0.00060006, 0.00010001, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0))
        pgm_function38.set_cpd((1,), (
            0.3184, 0.2478, 0.178, 0.1158, 0.0688, 0.038, 0.0189, 0.0086, 0.0036, 0.0014, 0.0005, 0.0002, 0.0, 0.0,
            0.0))
        pgm_function38.set_cpd((2,), (
            0.01170117, 0.03920392, 0.09350935, 0.16761676, 0.21892189, 0.20952095, 0.14651465, 0.07470747, 0.02870287,
            0.00780078, 0.00160016, 0.00020002, 0.0, 0.0, 0.0))
        pgm_function38.set_cpd((3,), (
            0.0, 0.0, 9.999e-05, 0.00129987, 0.01089891, 0.05269473, 0.15628437, 0.27017298, 0.27427257, 0.16358364,
            0.05689431, 0.01219878, 0.00149985, 9.999e-05, 0.0))
        pgm_function38.set_cpd((4,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 9.999e-05, 0.00219978, 0.02179782, 0.10328967, 0.25917408, 0.32546745, 0.20917908,
            0.06709329, 0.01079892, 0.00089991))
        pgm_function38.set_cpd((5,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0004, 0.0072, 0.0656, 0.2449, 0.3735, 0.2388, 0.0624, 0.0072))
        pgm_factor39 = self.new_factor(R_LNLW_MEDD2_LD_WD, R_LNLW_MED_SEV, R_LNLW_MED_PATHO)
        pgm_function39 = pgm_factor39.set_cpt()
        pgm_function39.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function39.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function39.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function39.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function39.set_cpd((4, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function39.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function39.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0))
        pgm_function39.set_cpd((2, 1), (0.25, 0.5, 0.25, 0.0))
        pgm_function39.set_cpd((3, 1), (0.05, 0.3, 0.5, 0.15))
        pgm_function39.set_cpd((4, 1), (0.25, 0.25, 0.25, 0.25))
        pgm_function39.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function39.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function39.set_cpd((2, 2), (0.5, 0.5, 0.0, 0.0))
        pgm_function39.set_cpd((3, 2), (0.0, 1.0, 0.0, 0.0))
        pgm_function39.set_cpd((4, 2), (0.0, 0.5, 0.5, 0.0))
        pgm_function39.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function39.set_cpd((1, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function39.set_cpd((2, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function39.set_cpd((3, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function39.set_cpd((4, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function39.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function39.set_cpd((1, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function39.set_cpd((2, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function39.set_cpd((3, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function39.set_cpd((4, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_factor40 = self.new_factor(R_MEDD2_LD_WD, R_LNLW_MEDD2_LD_WD)
        pgm_function40 = pgm_factor40.set_cpt()
        pgm_function40.set_cpd((0,), (1.0, 0.0, 0.0, 0.0))
        pgm_function40.set_cpd((1,), (0.0, 1.0, 0.0, 0.0))
        pgm_function40.set_cpd((2,), (0.0, 0.0, 1.0, 0.0))
        pgm_function40.set_cpd((3,), (0.0, 0.0, 0.0, 1.0))
        pgm_factor41 = self.new_factor(R_LNLW_MEDD2_RD_WD, R_LNLW_MED_PATHO)
        pgm_function41 = pgm_factor41.set_cpt()
        pgm_function41.set_cpd((0,), (1.0, 0.0, 0.0))
        pgm_function41.set_cpd((1,), (1.0, 0.0, 0.0))
        pgm_function41.set_cpd((2,), (1.0, 0.0, 0.0))
        pgm_function41.set_cpd((3,), (0.0, 0.0, 1.0))
        pgm_function41.set_cpd((4,), (0.0, 1.0, 0.0))
        pgm_factor42 = self.new_factor(R_MEDD2_RD_WD, R_LNLW_MEDD2_RD_WD)
        pgm_function42 = pgm_factor42.set_cpt()
        pgm_function42.set_cpd((0,), (1.0, 0.0, 0.0))
        pgm_function42.set_cpd((1,), (0.0, 1.0, 0.0))
        pgm_function42.set_cpd((2,), (0.0, 0.0, 1.0))
        pgm_factor43 = self.new_factor(R_MEDD2_LSLOW_WD, R_MEDD2_LD_WD, R_MEDD2_RD_WD)
        pgm_function43 = pgm_factor43.set_cpt()
        pgm_function43.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function43.set_cpd((1, 0), (0.0185, 0.9561, 0.0254, 0.0, 0.0))
        pgm_function43.set_cpd((2, 0), (0.0, 0.0166, 0.9834, 0.0, 0.0))
        pgm_function43.set_cpd((3, 0), (0.0007, 0.002, 0.0219, 0.9754, 0.0))
        pgm_function43.set_cpd((0, 1), (0.0021, 0.0042, 0.0295, 0.9642, 0.0))
        pgm_function43.set_cpd((1, 1), (0.0012, 0.0025, 0.0194, 0.9769, 0.0))
        pgm_function43.set_cpd((2, 1), (0.00069993, 0.00149985, 0.0119988, 0.98580142, 0.0))
        pgm_function43.set_cpd((3, 1), (0.00020002, 0.00050005, 0.00460046, 0.99449945, 0.00020002))
        pgm_function43.set_cpd((0, 2), (0.0001, 0.0002, 0.0014, 0.083, 0.9153))
        pgm_function43.set_cpd((1, 2), (0.0001, 0.0001, 0.0008, 0.0533, 0.9457))
        pgm_function43.set_cpd((2, 2), (0.0, 0.0001, 0.0004, 0.0319, 0.9676))
        pgm_function43.set_cpd((3, 2), (0.0, 0.0, 0.0, 0.00350035, 0.99649965))
        pgm_factor44 = self.new_factor(R_LNLBE_MEDD2_DIFSLOW_WD)
        pgm_function44 = pgm_factor44.set_cpt()
        pgm_function44.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor45 = self.new_factor(R_MEDD2_DIFSLOW_WD, R_LNLBE_MEDD2_DIFSLOW_WD, R_DIFFN_MEDD2_DIFSLOW)
        pgm_function45 = pgm_factor45.set_cpt()
        pgm_function45.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function45.set_cpd((1, 0), (0.0127, 0.9867, 0.0006, 0.0))
        pgm_function45.set_cpd((2, 0), (0.0, 0.01810181, 0.98189819, 0.0))
        pgm_function45.set_cpd((3, 0), (0.0, 0.0006, 0.0492, 0.9502))
        pgm_function45.set_cpd((0, 1), (0.0127, 0.9867, 0.0006, 0.0))
        pgm_function45.set_cpd((1, 1), (0.0001, 0.0952, 0.9047, 0.0))
        pgm_function45.set_cpd((2, 1), (0.0, 0.0011, 0.7402, 0.2587))
        pgm_function45.set_cpd((3, 1), (0.0, 0.0, 0.00880088, 0.99119912))
        pgm_function45.set_cpd((0, 2), (0.0, 0.01810181, 0.98189819, 0.0))
        pgm_function45.set_cpd((1, 2), (0.0, 0.0011, 0.7402, 0.2587))
        pgm_function45.set_cpd((2, 2), (0.0, 0.0, 0.004, 0.996))
        pgm_function45.set_cpd((3, 2), (0.0, 0.0, 0.0012, 0.9988))
        pgm_function45.set_cpd((0, 3), (0.0, 0.0006, 0.0492, 0.9502))
        pgm_function45.set_cpd((1, 3), (0.0, 0.0, 0.00880088, 0.99119912))
        pgm_function45.set_cpd((2, 3), (0.0, 0.0, 0.0012, 0.9988))
        pgm_function45.set_cpd((3, 3), (0.0, 0.0, 0.0009, 0.9991))
        pgm_factor46 = self.new_factor(R_MEDD2_DSLOW_WD, R_MEDD2_SALOSS, R_MEDD2_DIFSLOW_WD)
        pgm_function46 = pgm_factor46.set_cpt()
        pgm_function46.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function46.set_cpd((1, 0), (0.1036, 0.8964, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function46.set_cpd((2, 0), (0.00059994, 0.99730027, 0.00209979, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function46.set_cpd((3, 0), (0.0001, 0.0629, 0.9278, 0.0092, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function46.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function46.set_cpd((0, 1), (0.0532, 0.2387, 0.495, 0.2072, 0.0059, 0.0, 0.0, 0.0, 0.0))
        pgm_function46.set_cpd((1, 1), (0.01780178, 0.1190119, 0.44814481, 0.38543854, 0.02960296, 0.0, 0.0, 0.0, 0.0))
        pgm_function46.set_cpd((2, 1), (0.0048, 0.0476, 0.3148, 0.5311, 0.1016, 0.0001, 0.0, 0.0, 0.0))
        pgm_function46.set_cpd((3, 1),
                               (0.00060006, 0.00920092, 0.1160116, 0.48574857, 0.38353835, 0.00490049, 0.0, 0.0, 0.0))
        pgm_function46.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function46.set_cpd((0, 2), (0.0007, 0.0063, 0.0614, 0.3006, 0.5524, 0.0781, 0.0005, 0.0, 0.0))
        pgm_function46.set_cpd((1, 2), (0.0002, 0.0021, 0.0283, 0.1995, 0.5939, 0.1737, 0.0023, 0.0, 0.0))
        pgm_function46.set_cpd((2, 2),
                               (0.0, 0.00060006, 0.01140114, 0.11471147, 0.54455446, 0.31963196, 0.00910091, 0.0, 0.0))
        pgm_function46.set_cpd((3, 2),
                               (0.0, 0.00010001, 0.00240024, 0.03740374, 0.33273327, 0.56705671, 0.06030603, 0.0, 0.0))
        pgm_function46.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function46.set_cpd((0, 3), (0.0003, 0.0011, 0.005, 0.0205, 0.087, 0.2822, 0.4514, 0.1525, 0.0))
        pgm_function46.set_cpd((1, 3), (0.0002, 0.0006, 0.0029, 0.0133, 0.0634, 0.2436, 0.4657, 0.2103, 0.0))
        pgm_function46.set_cpd((2, 3), (
            0.00010001, 0.00030003, 0.00170017, 0.00830083, 0.04470447, 0.20312031, 0.46324632, 0.27852785, 0.0))
        pgm_function46.set_cpd((3, 3), (
            0.0, 0.00010001, 0.00070007, 0.00380038, 0.02430243, 0.14161416, 0.4240424, 0.40544054, 0.0))
        pgm_function46.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor47 = self.new_factor(R_MEDD2_ALLCV_WD, R_MEDD2_LSLOW_WD, R_MEDD2_DSLOW_WD)
        pgm_function47 = pgm_factor47.set_cpt()
        pgm_function47.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function47.set_cpd((1, 0), (0.02359764, 0.25787421, 0.64033597, 0.07809219, 9.999e-05, 0.0, 0.0, 0.0, 0.0))
        pgm_function47.set_cpd((2, 0), (0.0, 0.0021, 0.1149, 0.7277, 0.1553, 0.0, 0.0, 0.0, 0.0))
        pgm_function47.set_cpd((3, 0), (0.0003, 0.0011, 0.005, 0.0205, 0.087, 0.2822, 0.4514, 0.1525, 0.0))
        pgm_function47.set_cpd((4, 0),
                               (0.0, 0.0, 9.999e-05, 0.00029997, 0.00219978, 0.01919808, 0.12518748, 0.8530147, 0.0))
        pgm_function47.set_cpd((0, 1), (0.03049695, 0.96720328, 0.00229977, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function47.set_cpd((1, 1), (0.0017, 0.0421, 0.4597, 0.4852, 0.0113, 0.0, 0.0, 0.0, 0.0))
        pgm_function47.set_cpd((2, 1), (0.0, 0.0001, 0.0146, 0.3403, 0.6424, 0.0026, 0.0, 0.0, 0.0))
        pgm_function47.set_cpd((3, 1), (
            0.00010002, 0.00040008, 0.00210042, 0.01010202, 0.05161032, 0.21844369, 0.46469294, 0.25255051, 0.0))
        pgm_function47.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.00019998, 0.00139986, 0.01369863, 0.10288971, 0.88181182, 0.0))
        pgm_function47.set_cpd((0, 2), (0.00039996, 0.06189381, 0.88811119, 0.04959504, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function47.set_cpd((1, 2), (0.0, 0.00190019, 0.07490749, 0.56945695, 0.35323532, 0.00050005, 0.0, 0.0, 0.0))
        pgm_function47.set_cpd((2, 2), (0.0, 0.0, 0.0007, 0.0498, 0.764, 0.1854, 0.0001, 0.0, 0.0))
        pgm_function47.set_cpd((3, 2), (
            0.0, 0.00010001, 0.00060006, 0.00340034, 0.02230223, 0.13361336, 0.41454145, 0.42544254, 0.0))
        pgm_function47.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.00010001, 0.00070007, 0.00860086, 0.07820782, 0.91239124, 0.0))
        pgm_function47.set_cpd((0, 3), (0.0, 0.0001, 0.0655, 0.9082, 0.0262, 0.0, 0.0, 0.0, 0.0))
        pgm_function47.set_cpd((1, 3), (0.0, 0.0, 0.00220022, 0.10511051, 0.82518252, 0.06750675, 0.0, 0.0, 0.0))
        pgm_function47.set_cpd((2, 3), (0.0, 0.0, 0.0, 0.0012, 0.137, 0.8421, 0.0197, 0.0, 0.0))
        pgm_function47.set_cpd((3, 3), (0.0, 0.0, 0.0001, 0.0008, 0.0073, 0.0649, 0.3063, 0.6206, 0.0))
        pgm_function47.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.00030003, 0.0050005, 0.05640564, 0.93829383, 0.0))
        pgm_function47.set_cpd((0, 4), (0.0, 0.0, 0.0001, 0.0555, 0.937, 0.0074, 0.0, 0.0, 0.0))
        pgm_function47.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.00220022, 0.170017, 0.80628063, 0.02150215, 0.0, 0.0))
        pgm_function47.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 0.0034, 0.4375, 0.5591, 0.0, 0.0))
        pgm_function47.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.00010001, 0.00160016, 0.02260226, 0.17471747, 0.8009801, 0.0))
        pgm_function47.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 0.0001, 0.0026, 0.0379, 0.9594, 0.0))
        pgm_function47.set_cpd((0, 5), (0.0, 0.0, 0.0, 0.0002, 0.0491, 0.8863, 0.0644, 0.0, 0.0))
        pgm_function47.set_cpd((1, 5), (0.0, 0.0, 0.0, 0.0, 0.00219978, 0.23377662, 0.7620238, 0.0019998, 0.0))
        pgm_function47.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.02080208, 0.80948095, 0.16971697, 0.0))
        pgm_function47.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.00020002, 0.00520052, 0.07260726, 0.9219922, 0.0))
        pgm_function47.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0012, 0.023, 0.9758, 0.0))
        pgm_function47.set_cpd((0, 6), (0.0, 0.0, 0.0, 0.0, 0.00029997, 0.09559044, 0.89661034, 0.00749925, 0.0))
        pgm_function47.set_cpd((1, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.01009899, 0.48945105, 0.50044996, 0.0))
        pgm_function47.set_cpd((2, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.00010001, 0.03920392, 0.96069607, 0.0))
        pgm_function47.set_cpd((3, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.00120012, 0.02960296, 0.96919692, 0.0))
        pgm_function47.set_cpd((4, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0005, 0.014, 0.9855, 0.0))
        pgm_function47.set_cpd((0, 7), (
            0.00020002, 0.00060006, 0.00190019, 0.00640064, 0.02470247, 0.09740974, 0.28552855, 0.58325833, 0.0))
        pgm_function47.set_cpd((1, 7), (0.0001, 0.0002, 0.0007, 0.0026, 0.0117, 0.0585, 0.2222, 0.704, 0.0))
        pgm_function47.set_cpd((2, 7), (0.0, 0.0001, 0.0002, 0.0009, 0.0051, 0.0329, 0.1636, 0.7972, 0.0))
        pgm_function47.set_cpd((3, 7), (0.0, 0.0, 0.0001, 0.0004, 0.0022, 0.0159, 0.0994, 0.882, 0.0))
        pgm_function47.set_cpd((4, 7), (0.0, 0.0, 0.0, 0.0001, 0.0006, 0.0058, 0.0523, 0.9412, 0.0))
        pgm_function47.set_cpd((0, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function47.set_cpd((1, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function47.set_cpd((2, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function47.set_cpd((3, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function47.set_cpd((4, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor48 = self.new_factor(R_MEDD2_CV_WD, R_MEDD2_ALLCV_WD)
        pgm_function48 = pgm_factor48.set_cpt()
        pgm_function48.set_cpd((0,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00019998, 0.01089891, 0.09839016, 0.31656834,
            0.35316468, 0.17488251, 0.04029597, 0.00559944))
        pgm_function48.set_cpd((1,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00019998, 0.00849915, 0.07679232, 0.28107189, 0.33226677,
            0.20117988, 0.08159184, 0.01609839, 0.00209979, 0.00019998))
        pgm_function48.set_cpd((2,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00020002, 0.01390139, 0.1120112, 0.29182918, 0.31343134, 0.19151915,
            0.0610061, 0.0130013, 0.00280028, 0.00030003, 0.0, 0.0))
        pgm_function48.set_cpd((3,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00290029, 0.07060706, 0.31513151, 0.38363836, 0.17091709, 0.04760476,
            0.00820082, 0.00090009, 0.00010001, 0.0, 0.0, 0.0, 0.0))
        pgm_function48.set_cpd((4,), (
            0.0, 0.0, 0.0, 0.0, 0.00019998, 0.03939606, 0.31846815, 0.41945805, 0.17558244, 0.04189581, 0.00449955,
            0.00049995, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function48.set_cpd((5,), (
            0.0, 0.0, 0.0, 0.01569843, 0.31446855, 0.46605339, 0.17158284, 0.02909709, 0.00279972, 0.00029997, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function48.set_cpd((6,), (
            0.0, 0.0, 0.03080308, 0.5769577, 0.33983398, 0.04820482, 0.0040004, 0.00020002, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0,
            0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function48.set_cpd((7,), (
            0.0, 0.04650465, 0.84828483, 0.09990999, 0.00510051, 0.00020002, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0,
            0.0, 0.0, 0.0, 0.0))
        pgm_function48.set_cpd((8,), (
            1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor49 = self.new_factor(DIFFN_MOT_SEV, DIFFN_SEV, DIFFN_TYPE)
        pgm_function49 = pgm_factor49.set_cpt()
        pgm_function49.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function49.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function49.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function49.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function49.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function49.set_cpd((1, 1), (0.0, 1.0, 0.0, 0.0))
        pgm_function49.set_cpd((2, 1), (0.0, 0.0, 1.0, 0.0))
        pgm_function49.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function49.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function49.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function49.set_cpd((2, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function49.set_cpd((3, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_factor50 = self.new_factor(DIFFN_M_SEV_DIST, DIFFN_MOT_SEV, DIFFN_DISTR)
        pgm_function50 = pgm_factor50.set_cpt()
        pgm_function50.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function50.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function50.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function50.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function50.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function50.set_cpd((1, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function50.set_cpd((2, 1), (0.5, 0.5, 0.0, 0.0))
        pgm_function50.set_cpd((3, 1), (0.0, 0.5, 0.5, 0.0))
        pgm_function50.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function50.set_cpd((1, 2), (0.25, 0.45, 0.25, 0.05))
        pgm_function50.set_cpd((2, 2), (0.1, 0.4, 0.4, 0.1))
        pgm_function50.set_cpd((3, 2), (0.05, 0.15, 0.4, 0.4))
        pgm_factor51 = self.new_factor(R_DIFFN_MED_BLOCK, DIFFN_M_SEV_DIST, DIFFN_PATHO)
        pgm_function51 = pgm_factor51.set_cpt()
        pgm_function51.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function51.set_cpd((1, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function51.set_cpd((2, 0), (0.6, 0.4, 0.0, 0.0, 0.0))
        pgm_function51.set_cpd((3, 0), (0.25, 0.5, 0.25, 0.0, 0.0))
        pgm_function51.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function51.set_cpd((1, 1), (0.0, 0.5, 0.5, 0.0, 0.0))
        pgm_function51.set_cpd((2, 1), (0.0, 0.5, 0.5, 0.0, 0.0))
        pgm_function51.set_cpd((3, 1), (0.0, 0.0, 0.4, 0.5, 0.1))
        pgm_function51.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function51.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function51.set_cpd((2, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function51.set_cpd((3, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function51.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function51.set_cpd((1, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function51.set_cpd((2, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function51.set_cpd((3, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function51.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function51.set_cpd((1, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function51.set_cpd((2, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function51.set_cpd((3, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor52 = self.new_factor(R_LNLBE_MED_BLOCK)
        pgm_function52 = pgm_factor52.set_cpt()
        pgm_function52.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor53 = self.new_factor(R_MED_BLOCK_EW, R_DIFFN_MED_BLOCK, R_LNLBE_MED_BLOCK)
        pgm_function53 = pgm_factor53.set_cpt()
        pgm_function53.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function53.set_cpd((1, 0), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function53.set_cpd((2, 0), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function53.set_cpd((3, 0), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function53.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function53.set_cpd((0, 1), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function53.set_cpd((1, 1), (0.0001, 0.498, 0.5019, 0.0, 0.0))
        pgm_function53.set_cpd((2, 1), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function53.set_cpd((3, 1), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function53.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function53.set_cpd((0, 2), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function53.set_cpd((1, 2), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function53.set_cpd((2, 2), (0.0, 0.0007, 0.4328, 0.5665, 0.0))
        pgm_function53.set_cpd((3, 2), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function53.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function53.set_cpd((0, 3), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function53.set_cpd((1, 3), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function53.set_cpd((2, 3), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function53.set_cpd((3, 3), (0.00030003, 0.00110011, 0.01250125, 0.98609861, 0.0))
        pgm_function53.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function53.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function53.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function53.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function53.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function53.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor54 = self.new_factor(R_MED_AMPR_EW, R_MED_BLOCK_EW)
        pgm_function54 = pgm_factor54.set_cpt()
        pgm_function54.set_cpd((0,), (0.0879, 0.4192, 0.4232, 0.0693, 0.0004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function54.set_cpd((1,), (
            0.00189981, 0.03439656, 0.25667433, 0.52914709, 0.17348265, 0.00439956, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function54.set_cpd((2,),
                               (0.0001, 0.001, 0.0076, 0.0403, 0.172, 0.373, 0.342, 0.0633, 0.0007, 0.0, 0.0, 0.0))
        pgm_function54.set_cpd((3,), (
            0.00090009, 0.00150015, 0.00260026, 0.00490049, 0.00950095, 0.01760176, 0.03470347, 0.07680768, 0.16681668,
            0.34143414, 0.34323432, 0.0))
        pgm_function54.set_cpd((4,), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor55 = self.new_factor(R_LNLT1_APB_MALOSS)
        pgm_function55 = pgm_factor55.set_cpt()
        pgm_function55.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor56 = self.new_factor(R_LNLLP_APB_MALOSS)
        pgm_function56 = pgm_factor56.set_cpt()
        pgm_function56.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor57 = self.new_factor(R_LNLT1_LP_APB_MALOSS, R_LNLT1_APB_MALOSS, R_LNLLP_APB_MALOSS)
        pgm_function57 = pgm_factor57.set_cpt()
        pgm_function57.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function57.set_cpd((1, 0), (0.0022, 0.9977, 0.0001, 0.0, 0.0))
        pgm_function57.set_cpd((2, 0), (0.00019998, 0.03689631, 0.95880412, 0.00409959, 0.0))
        pgm_function57.set_cpd((3, 0), (0.0, 0.0002, 0.0329, 0.9669, 0.0))
        pgm_function57.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function57.set_cpd((0, 1), (0.0022, 0.9977, 0.0001, 0.0, 0.0))
        pgm_function57.set_cpd((1, 1), (0.0, 0.0282, 0.9718, 0.0, 0.0))
        pgm_function57.set_cpd((2, 1), (0.0, 0.0009, 0.3409, 0.6582, 0.0))
        pgm_function57.set_cpd((3, 1), (0.0, 0.0, 0.0038, 0.9962, 0.0))
        pgm_function57.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function57.set_cpd((0, 2), (0.00019998, 0.03689631, 0.95880412, 0.00409959, 0.0))
        pgm_function57.set_cpd((1, 2), (0.0, 0.0009, 0.3409, 0.6582, 0.0))
        pgm_function57.set_cpd((2, 2), (0.0, 0.0, 0.01, 0.99, 0.0))
        pgm_function57.set_cpd((3, 2), (0.0, 0.0, 0.0011, 0.9989, 0.0))
        pgm_function57.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function57.set_cpd((0, 3), (0.0, 0.0002, 0.0329, 0.9669, 0.0))
        pgm_function57.set_cpd((1, 3), (0.0, 0.0, 0.0038, 0.9962, 0.0))
        pgm_function57.set_cpd((2, 3), (0.0, 0.0, 0.0011, 0.9989, 0.0))
        pgm_function57.set_cpd((3, 3), (0.0, 0.0, 0.0004, 0.9996, 0.0))
        pgm_function57.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function57.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function57.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function57.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function57.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function57.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor58 = self.new_factor(R_LNLBE_APB_MALOSS)
        pgm_function58 = pgm_factor58.set_cpt()
        pgm_function58.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor59 = self.new_factor(R_LNLT1_LP_BE_APB_MALOSS, R_LNLT1_LP_APB_MALOSS, R_LNLBE_APB_MALOSS)
        pgm_function59 = pgm_factor59.set_cpt()
        pgm_function59.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function59.set_cpd((1, 0), (0.0022, 0.9977, 0.0001, 0.0, 0.0))
        pgm_function59.set_cpd((2, 0), (0.00019998, 0.03689631, 0.95880412, 0.00409959, 0.0))
        pgm_function59.set_cpd((3, 0), (0.0, 0.0002, 0.0329, 0.9669, 0.0))
        pgm_function59.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function59.set_cpd((0, 1), (0.0022, 0.9977, 0.0001, 0.0, 0.0))
        pgm_function59.set_cpd((1, 1), (0.0, 0.0282, 0.9718, 0.0, 0.0))
        pgm_function59.set_cpd((2, 1), (0.0, 0.0009, 0.3409, 0.6582, 0.0))
        pgm_function59.set_cpd((3, 1), (0.0, 0.0, 0.0038, 0.9962, 0.0))
        pgm_function59.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function59.set_cpd((0, 2), (0.00019998, 0.03689631, 0.95880412, 0.00409959, 0.0))
        pgm_function59.set_cpd((1, 2), (0.0, 0.0009, 0.3409, 0.6582, 0.0))
        pgm_function59.set_cpd((2, 2), (0.0, 0.0, 0.01, 0.99, 0.0))
        pgm_function59.set_cpd((3, 2), (0.0, 0.0, 0.0011, 0.9989, 0.0))
        pgm_function59.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function59.set_cpd((0, 3), (0.0, 0.0002, 0.0329, 0.9669, 0.0))
        pgm_function59.set_cpd((1, 3), (0.0, 0.0, 0.0038, 0.9962, 0.0))
        pgm_function59.set_cpd((2, 3), (0.0, 0.0, 0.0011, 0.9989, 0.0))
        pgm_function59.set_cpd((3, 3), (0.0, 0.0, 0.0004, 0.9996, 0.0))
        pgm_function59.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function59.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function59.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function59.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function59.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function59.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor60 = self.new_factor(R_LNLW_APB_MALOSS, R_LNLW_MED_SEV, R_LNLW_MED_PATHO)
        pgm_function60 = pgm_factor60.set_cpt()
        pgm_function60.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function60.set_cpd((1, 0), (0.5, 0.5, 0.0, 0.0, 0.0))
        pgm_function60.set_cpd((2, 0), (0.0, 0.5, 0.5, 0.0, 0.0))
        pgm_function60.set_cpd((3, 0), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function60.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.1, 0.9))
        pgm_function60.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function60.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0, 0.0))
        pgm_function60.set_cpd((2, 1), (0.4, 0.3, 0.3, 0.0, 0.0))
        pgm_function60.set_cpd((3, 1), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function60.set_cpd((4, 1), (0.25, 0.25, 0.25, 0.25, 0.0))
        pgm_function60.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function60.set_cpd((1, 2), (0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function60.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function60.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function60.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function60.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function60.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function60.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function60.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function60.set_cpd((4, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function60.set_cpd((0, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function60.set_cpd((1, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function60.set_cpd((2, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function60.set_cpd((3, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function60.set_cpd((4, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_factor61 = self.new_factor(R_DIFFN_APB_MALOSS, DIFFN_M_SEV_DIST, DIFFN_PATHO)
        pgm_function61 = pgm_factor61.set_cpt()
        pgm_function61.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function61.set_cpd((1, 0), (0.4, 0.6, 0.0, 0.0, 0.0))
        pgm_function61.set_cpd((2, 0), (0.0, 0.4, 0.6, 0.0, 0.0))
        pgm_function61.set_cpd((3, 0), (0.0, 0.0, 0.4, 0.6, 0.0))
        pgm_function61.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function61.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0, 0.0))
        pgm_function61.set_cpd((2, 1), (0.4, 0.3, 0.3, 0.0, 0.0))
        pgm_function61.set_cpd((3, 1), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function61.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function61.set_cpd((1, 2), (0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function61.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function61.set_cpd((3, 2), (0.0, 0.0, 0.0, 0.8, 0.2))
        pgm_function61.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function61.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function61.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function61.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function61.set_cpd((0, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function61.set_cpd((1, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function61.set_cpd((2, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function61.set_cpd((3, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_factor62 = self.new_factor(R_DIFFN_LNLW_APB_MALOSS, R_LNLW_APB_MALOSS, R_DIFFN_APB_MALOSS)
        pgm_function62 = pgm_factor62.set_cpt()
        pgm_function62.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function62.set_cpd((1, 0), (0.0022, 0.9977, 0.0001, 0.0, 0.0))
        pgm_function62.set_cpd((2, 0), (0.00019998, 0.03689631, 0.95880412, 0.00409959, 0.0))
        pgm_function62.set_cpd((3, 0), (0.0, 0.0002, 0.0329, 0.9669, 0.0))
        pgm_function62.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function62.set_cpd((0, 1), (0.0022, 0.9977, 0.0001, 0.0, 0.0))
        pgm_function62.set_cpd((1, 1), (0.0, 0.0282, 0.9718, 0.0, 0.0))
        pgm_function62.set_cpd((2, 1), (0.0, 0.0009, 0.3409, 0.6582, 0.0))
        pgm_function62.set_cpd((3, 1), (0.0, 0.0, 0.0038, 0.9962, 0.0))
        pgm_function62.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function62.set_cpd((0, 2), (0.00019998, 0.03689631, 0.95880412, 0.00409959, 0.0))
        pgm_function62.set_cpd((1, 2), (0.0, 0.0009, 0.3409, 0.6582, 0.0))
        pgm_function62.set_cpd((2, 2), (0.0, 0.0, 0.01, 0.99, 0.0))
        pgm_function62.set_cpd((3, 2), (0.0, 0.0, 0.0011, 0.9989, 0.0))
        pgm_function62.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function62.set_cpd((0, 3), (0.0, 0.0002, 0.0329, 0.9669, 0.0))
        pgm_function62.set_cpd((1, 3), (0.0, 0.0, 0.0038, 0.9962, 0.0))
        pgm_function62.set_cpd((2, 3), (0.0, 0.0, 0.0011, 0.9989, 0.0))
        pgm_function62.set_cpd((3, 3), (0.0, 0.0, 0.0004, 0.9996, 0.0))
        pgm_function62.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function62.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function62.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function62.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function62.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function62.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor63 = self.new_factor(R_APB_MALOSS, R_LNLT1_LP_BE_APB_MALOSS, R_DIFFN_LNLW_APB_MALOSS)
        pgm_function63 = pgm_factor63.set_cpt()
        pgm_function63.set_cpd((0, 0), (0.98, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function63.set_cpd((1, 0), (0.00219978, 0.97770223, 9.999e-05, 0.0, 0.0, 0.019998))
        pgm_function63.set_cpd((2, 0), (0.0002, 0.0471, 0.9297, 0.003, 0.0, 0.02))
        pgm_function63.set_cpd((3, 0), (0.0, 0.0003, 0.0424, 0.9373, 0.0, 0.02))
        pgm_function63.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function63.set_cpd((0, 1), (0.00219978, 0.97770223, 9.999e-05, 0.0, 0.0, 0.019998))
        pgm_function63.set_cpd((1, 1), (0.0, 0.0361, 0.9439, 0.0, 0.0, 0.02))
        pgm_function63.set_cpd((2, 1), (0.0, 0.0014, 0.3987, 0.5799, 0.0, 0.02))
        pgm_function63.set_cpd((3, 1), (0.0, 0.0, 0.005, 0.975, 0.0, 0.02))
        pgm_function63.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function63.set_cpd((0, 2), (0.0002, 0.0471, 0.9297, 0.003, 0.0, 0.02))
        pgm_function63.set_cpd((1, 2), (0.0, 0.0014, 0.3987, 0.5799, 0.0, 0.02))
        pgm_function63.set_cpd((2, 2), (0.0, 0.0, 0.013, 0.967, 0.0, 0.02))
        pgm_function63.set_cpd((3, 2), (0.0, 0.0, 0.0014, 0.9786, 0.0, 0.02))
        pgm_function63.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function63.set_cpd((0, 3), (0.0, 0.0003, 0.0424, 0.9373, 0.0, 0.02))
        pgm_function63.set_cpd((1, 3), (0.0, 0.0, 0.005, 0.975, 0.0, 0.02))
        pgm_function63.set_cpd((2, 3), (0.0, 0.0, 0.0014, 0.9786, 0.0, 0.02))
        pgm_function63.set_cpd((3, 3), (0.0, 0.0, 0.0005, 0.9795, 0.0, 0.02))
        pgm_function63.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function63.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function63.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function63.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function63.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function63.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_factor64 = self.new_factor(R_DIFFN_MED_DIFSLOW, DIFFN_M_SEV_DIST, DIFFN_PATHO)
        pgm_function64 = pgm_factor64.set_cpt()
        pgm_function64.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function64.set_cpd((1, 0), (0.0, 0.5, 0.5, 0.0))
        pgm_function64.set_cpd((2, 0), (0.0, 0.2, 0.6, 0.2))
        pgm_function64.set_cpd((3, 0), (0.0, 0.2, 0.6, 0.2))
        pgm_function64.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function64.set_cpd((1, 1), (0.4, 0.5, 0.1, 0.0))
        pgm_function64.set_cpd((2, 1), (0.2, 0.4, 0.3, 0.1))
        pgm_function64.set_cpd((3, 1), (0.2, 0.4, 0.3, 0.1))
        pgm_function64.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function64.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function64.set_cpd((2, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function64.set_cpd((3, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function64.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function64.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function64.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function64.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function64.set_cpd((0, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_function64.set_cpd((1, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_function64.set_cpd((2, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_function64.set_cpd((3, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_factor65 = self.new_factor(R_MED_DIFSLOW_EW, R_DIFFN_MED_DIFSLOW)
        pgm_function65 = pgm_factor65.set_cpt()
        pgm_function65.set_cpd((0,), (1.0, 0.0, 0.0, 0.0))
        pgm_function65.set_cpd((1,), (0.0126, 0.9869, 0.0005, 0.0))
        pgm_function65.set_cpd((2,), (0.0, 0.0179, 0.9821, 0.0))
        pgm_function65.set_cpd((3,), (0.0, 0.0003, 0.0252, 0.9745))
        pgm_factor66 = self.new_factor(R_MED_DCV_EW, R_APB_MALOSS, R_MED_DIFSLOW_EW)
        pgm_function66 = pgm_factor66.set_cpt()
        pgm_function66.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function66.set_cpd((1, 0), (0.109, 0.8903, 0.0007, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function66.set_cpd((2, 0), (0.0039996, 0.11438856, 0.86211379, 0.01949805, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function66.set_cpd((3, 0), (0.0001, 0.0028, 0.064, 0.9243, 0.0088, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function66.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function66.set_cpd((5, 0), (0.0835, 0.1153, 0.2417, 0.3746, 0.1682, 0.0167, 0.0, 0.0, 0.0, 0.0))
        pgm_function66.set_cpd((0, 1),
                               (0.00410041, 0.02470247, 0.15461546, 0.7389739, 0.07760776, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function66.set_cpd((1, 1), (0.0011, 0.0082, 0.0683, 0.7087, 0.2135, 0.0002, 0.0, 0.0, 0.0, 0.0))
        pgm_function66.set_cpd((2, 1), (
            9.999e-05, 0.00079992, 0.0089991, 0.3029697, 0.66543346, 0.02169783, 0.0, 0.0, 0.0, 0.0))
        pgm_function66.set_cpd((3, 1), (0.0, 0.0, 0.0006, 0.0547, 0.6199, 0.3247, 0.0001, 0.0, 0.0, 0.0))
        pgm_function66.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function66.set_cpd((5, 1), (
            0.00929907, 0.01809819, 0.05459454, 0.22767723, 0.39336066, 0.27757224, 0.01929807, 9.999e-05, 0.0, 0.0))
        pgm_function66.set_cpd((0, 2), (0.0004, 0.0012, 0.0055, 0.0628, 0.295, 0.5485, 0.0861, 0.0005, 0.0, 0.0))
        pgm_function66.set_cpd((1, 2), (
            0.00020002, 0.00050005, 0.00280028, 0.03890389, 0.23092309, 0.5829583, 0.14221422, 0.00150015, 0.0, 0.0))
        pgm_function66.set_cpd((2, 2), (
            0.0, 0.00010001, 0.00060006, 0.01230123, 0.11291129, 0.52725273, 0.33553355, 0.01130113, 0.0, 0.0))
        pgm_function66.set_cpd((3, 2), (
            0.0, 0.0, 9.999e-05, 0.00249975, 0.0359964, 0.32406759, 0.5710429, 0.06629337, 0.0, 0.0))
        pgm_function66.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function66.set_cpd((5, 2), (
            0.00059994, 0.00119988, 0.00419958, 0.02839716, 0.11488851, 0.35756424, 0.39636036, 0.09639036, 0.00039996,
            0.0))
        pgm_function66.set_cpd((0, 3), (
            0.0, 9.999e-05, 0.00019998, 0.00189981, 0.01069893, 0.06579342, 0.28457154, 0.50544946, 0.13128687, 0.0))
        pgm_function66.set_cpd((1, 3), (
            0.0, 0.0, 0.00010001, 0.00120012, 0.00750075, 0.0510051, 0.25242524, 0.51855186, 0.16921692, 0.0))
        pgm_function66.set_cpd((2, 3), (0.0, 0.0, 0.0, 0.0005, 0.0034, 0.028, 0.1822, 0.5098, 0.2761, 0.0))
        pgm_function66.set_cpd((3, 3), (
            0.0, 0.0, 0.0, 0.00010001, 0.00120012, 0.01250125, 0.11181118, 0.44524452, 0.42914291, 0.0))
        pgm_function66.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function66.set_cpd((5, 3), (0.0, 0.0, 0.0002, 0.0011, 0.0056, 0.033, 0.1653, 0.4414, 0.3534, 0.0))
        pgm_factor67 = self.new_factor(R_MED_LD_EW)
        pgm_function67 = pgm_factor67.set_cpt()
        pgm_function67.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor68 = self.new_factor(R_MED_RD_EW)
        pgm_function68 = pgm_factor68.set_cpt()
        pgm_function68.set_cpd((), (1.0, 0.0, 0.0))
        pgm_factor69 = self.new_factor(R_MED_RDLDCV_EW, R_MED_LD_EW, R_MED_RD_EW)
        pgm_function69 = pgm_factor69.set_cpt()
        pgm_function69.set_cpd((0, 0), (0.90449045, 0.09530953, 0.00020002, 0.0, 0.0, 0.0))
        pgm_function69.set_cpd((1, 0), (0.132, 0.6039, 0.2641, 0.0, 0.0, 0.0))
        pgm_function69.set_cpd((2, 0), (0.0139, 0.1839, 0.8022, 0.0, 0.0, 0.0))
        pgm_function69.set_cpd((3, 0), (0.00120012, 0.00670067, 0.05440544, 0.86008601, 0.07760776, 0.0))
        pgm_function69.set_cpd((0, 1), (0.0115, 0.0333, 0.1509, 0.7319, 0.0724, 0.0))
        pgm_function69.set_cpd((1, 1), (0.00340034, 0.01220122, 0.0690069, 0.71967197, 0.19531953, 0.00040004))
        pgm_function69.set_cpd((2, 1), (0.0011, 0.0045, 0.0299, 0.5742, 0.3876, 0.0027))
        pgm_function69.set_cpd((3, 1), (0.0001, 0.0002, 0.0018, 0.0914, 0.6093, 0.2972))
        pgm_function69.set_cpd((0, 2), (0.0, 9.999e-05, 0.00109989, 0.14618538, 0.8070193, 0.04559544))
        pgm_function69.set_cpd((1, 2), (0.0, 0.0, 0.0002, 0.0581, 0.795, 0.1467))
        pgm_function69.set_cpd((2, 2), (0.0, 0.0, 0.0001, 0.0228, 0.6344, 0.3427))
        pgm_function69.set_cpd((3, 2), (0.0, 0.0, 0.0, 0.0014, 0.1063, 0.8923))
        pgm_factor70 = self.new_factor(R_MED_ALLCV_EW, R_MED_DCV_EW, R_MED_RDLDCV_EW)
        pgm_function70 = pgm_factor70.set_cpt()
        pgm_function70.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function70.set_cpd((1, 0), (0.0699, 0.8102, 0.1199, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function70.set_cpd((2, 0), (0.0, 0.04790479, 0.95209521, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function70.set_cpd((3, 0),
                               (0.00089991, 0.0089991, 0.08879112, 0.81861814, 0.08269173, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function70.set_cpd((4, 0), (0.0, 0.0, 0.00050005, 0.10111011, 0.84778478, 0.05060506, 0.0, 0.0, 0.0, 0.0))
        pgm_function70.set_cpd((5, 0), (0.0, 0.0, 0.0, 0.00050005, 0.07910791, 0.90019002, 0.02020202, 0.0, 0.0, 0.0))
        pgm_function70.set_cpd((6, 0), (0.0, 0.0, 0.0, 0.0, 0.0006, 0.0734, 0.8393, 0.0867, 0.0, 0.0))
        pgm_function70.set_cpd((7, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.00030003, 0.09470947, 0.89458946, 0.01040104, 0.0))
        pgm_function70.set_cpd((8, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.002, 0.0932, 0.9048, 0.0))
        pgm_function70.set_cpd((9, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.9999))
        pgm_function70.set_cpd((0, 1), (0.00660066, 0.14551455, 0.83808381, 0.00980098, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function70.set_cpd((1, 1), (0.0005, 0.0239, 0.4369, 0.5387, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function70.set_cpd((2, 1), (0.0, 0.0003, 0.0239, 0.9748, 0.001, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function70.set_cpd((3, 1), (0.0, 0.0002, 0.0036, 0.2467, 0.7339, 0.0156, 0.0, 0.0, 0.0, 0.0))
        pgm_function70.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.005, 0.3134, 0.6811, 0.0005, 0.0, 0.0, 0.0))
        pgm_function70.set_cpd((5, 1), (0.0, 0.0, 0.0, 0.0, 0.00710071, 0.54935494, 0.44334433, 0.00020002, 0.0, 0.0))
        pgm_function70.set_cpd((6, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.00910091, 0.52835284, 0.46254625, 0.0, 0.0))
        pgm_function70.set_cpd((7, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0216, 0.8359, 0.1425, 0.0))
        pgm_function70.set_cpd((8, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0004, 0.0355, 0.9641, 0.0))
        pgm_function70.set_cpd((9, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.9999))
        pgm_function70.set_cpd((0, 2), (0.0, 0.0, 0.0047, 0.9951, 0.0002, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function70.set_cpd((1, 2), (0.0, 0.0, 0.0004, 0.9005, 0.0991, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function70.set_cpd((2, 2), (0.0, 0.0, 0.0, 0.1288, 0.8712, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function70.set_cpd((3, 2), (0.0, 0.0, 0.0, 0.01130113, 0.57115712, 0.41754175, 0.0, 0.0, 0.0, 0.0))
        pgm_function70.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 0.0214, 0.9354, 0.0432, 0.0, 0.0, 0.0))
        pgm_function70.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 9.999e-05, 0.05649435, 0.93230677, 0.01109889, 0.0, 0.0))
        pgm_function70.set_cpd((6, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0004, 0.143, 0.8551, 0.0015, 0.0))
        pgm_function70.set_cpd((7, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0019998, 0.3548645, 0.6431357, 0.0))
        pgm_function70.set_cpd((8, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.0122, 0.9877, 0.0))
        pgm_function70.set_cpd((9, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.9999))
        pgm_function70.set_cpd((0, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function70.set_cpd((1, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.997, 0.003, 0.0, 0.0, 0.0))
        pgm_function70.set_cpd((2, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.2336, 0.7664, 0.0, 0.0, 0.0))
        pgm_function70.set_cpd((3, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.00259974, 0.99340066, 0.0039996, 0.0, 0.0))
        pgm_function70.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.2469, 0.7531, 0.0, 0.0))
        pgm_function70.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.002, 0.9939, 0.0041, 0.0))
        pgm_function70.set_cpd((6, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0314, 0.9686, 0.0))
        pgm_function70.set_cpd((7, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0002, 0.9998, 0.0))
        pgm_function70.set_cpd((8, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0003, 0.9997, 0.0))
        pgm_function70.set_cpd((9, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function70.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0012, 0.1305, 0.8445, 0.0238, 0.0))
        pgm_function70.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0004, 0.074, 0.8589, 0.0667, 0.0))
        pgm_function70.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.00010001, 0.03730373, 0.80288029, 0.15971597, 0.0))
        pgm_function70.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.007, 0.3517, 0.6413, 0.0))
        pgm_function70.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0003, 0.0581, 0.9416, 0.0))
        pgm_function70.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.006, 0.994, 0.0))
        pgm_function70.set_cpd((6, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0008, 0.9992, 0.0))
        pgm_function70.set_cpd((7, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.9999, 0.0))
        pgm_function70.set_cpd((8, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0002, 0.9998, 0.0))
        pgm_function70.set_cpd((9, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function70.set_cpd((0, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0002, 0.0321, 0.9677, 0.0))
        pgm_function70.set_cpd((1, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.0184, 0.9815, 0.0))
        pgm_function70.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.01010101, 0.98989899, 0.0))
        pgm_function70.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0042, 0.9958, 0.0))
        pgm_function70.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0011, 0.9989, 0.0))
        pgm_function70.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0003, 0.9997, 0.0))
        pgm_function70.set_cpd((6, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.9999, 0.0))
        pgm_function70.set_cpd((7, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function70.set_cpd((8, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.9999, 0.0))
        pgm_function70.set_cpd((9, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor71 = self.new_factor(R_MED_CV_EW, R_MED_ALLCV_EW)
        pgm_function71 = pgm_factor71.set_cpt()
        pgm_function71.set_cpd((0,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0006, 0.0168, 0.1184, 0.296, 0.3227, 0.1783, 0.056,
            0.0112))
        pgm_function71.set_cpd((1,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.0005, 0.0155, 0.1165, 0.2969, 0.3229, 0.1782, 0.0564,
            0.0114, 0.0016))
        pgm_function71.set_cpd((2,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0006, 0.0039, 0.0589, 0.2434, 0.3586, 0.235, 0.0808, 0.0164,
            0.0022, 0.0002))
        pgm_function71.set_cpd((3,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0007, 0.0176, 0.1966, 0.2515, 0.2699, 0.1688, 0.069, 0.0203, 0.0046,
            0.0009, 0.0001, 0.0))
        pgm_function71.set_cpd((4,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00560056, 0.090009, 0.30563056, 0.30933093, 0.20392039, 0.06730673,
            0.01520152,
            0.00260026, 0.00040004, 0.0, 0.0, 0.0, 0.0))
        pgm_function71.set_cpd((5,), (
            0.0, 0.0, 0.0, 0.0, 0.0006, 0.0496, 0.2972, 0.4059, 0.2097, 0.0258, 0.0098, 0.0013, 0.0001, 0.0, 0.0, 0.0,
            0.0,
            0.0, 0.0))
        pgm_function71.set_cpd((6,), (
            0.0, 0.0, 0.0, 0.01789821, 0.29457054, 0.4469553, 0.19018098, 0.04339566, 0.00659934, 0.00029997, 9.999e-05,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function71.set_cpd((7,), (
            0.0, 0.0, 0.0265, 0.5431, 0.3624, 0.0622, 0.0054, 0.0004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0))
        pgm_function71.set_cpd((8,), (
            0.0, 0.12651265, 0.76547655, 0.10061006, 0.0070007, 0.00040004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0))
        pgm_function71.set_cpd((9,), (
            0.9999, 0.0001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor72 = self.new_factor(R_LNLT1_APB_DE_REGEN)
        pgm_function72 = pgm_factor72.set_cpt()
        pgm_function72.set_cpd((), (1.0, 0.0))
        pgm_factor73 = self.new_factor(R_LNLLP_APB_DE_REGEN)
        pgm_function73 = pgm_factor73.set_cpt()
        pgm_function73.set_cpd((), (1.0, 0.0))
        pgm_factor74 = self.new_factor(R_LNLT1_LP_APB_DE_REGEN, R_LNLT1_APB_DE_REGEN, R_LNLLP_APB_DE_REGEN)
        pgm_function74 = pgm_factor74.set_cpt()
        pgm_function74.set_cpd((0, 0), (1.0, 0.0))
        pgm_function74.set_cpd((1, 0), (0.0, 1.0))
        pgm_function74.set_cpd((0, 1), (0.0, 1.0))
        pgm_function74.set_cpd((1, 1), (0.0, 1.0))
        pgm_factor75 = self.new_factor(R_LNLBE_APB_DE_REGEN)
        pgm_function75 = pgm_factor75.set_cpt()
        pgm_function75.set_cpd((), (1.0, 0.0))
        pgm_factor76 = self.new_factor(R_LNLT1_LP_BE_APB_DE_REGEN, R_LNLT1_LP_APB_DE_REGEN, R_LNLBE_APB_DE_REGEN)
        pgm_function76 = pgm_factor76.set_cpt()
        pgm_function76.set_cpd((0, 0), (1.0, 0.0))
        pgm_function76.set_cpd((1, 0), (0.0, 1.0))
        pgm_function76.set_cpd((0, 1), (0.0, 1.0))
        pgm_function76.set_cpd((1, 1), (0.0, 1.0))
        pgm_factor77 = self.new_factor(DIFFN_TIME)
        pgm_function77 = pgm_factor77.set_cpt()
        pgm_function77.set_cpd((), (0.01, 0.25, 0.65, 0.09))
        pgm_factor78 = self.new_factor(R_DIFFN_APB_DE_REGEN, DIFFN_M_SEV_DIST, DIFFN_TIME, DIFFN_PATHO)
        pgm_function78 = pgm_factor78.set_cpt()
        pgm_function78.set_cpd((0, 0, 0), (1.0, 0.0))
        pgm_function78.set_cpd((1, 0, 0), (1.0, 0.0))
        pgm_function78.set_cpd((2, 0, 0), (1.0, 0.0))
        pgm_function78.set_cpd((3, 0, 0), (1.0, 0.0))
        pgm_function78.set_cpd((0, 1, 0), (1.0, 0.0))
        pgm_function78.set_cpd((1, 1, 0), (0.8, 0.2))
        pgm_function78.set_cpd((2, 1, 0), (0.2, 0.8))
        pgm_function78.set_cpd((3, 1, 0), (0.4, 0.6))
        pgm_function78.set_cpd((0, 2, 0), (1.0, 0.0))
        pgm_function78.set_cpd((1, 2, 0), (0.8, 0.2))
        pgm_function78.set_cpd((2, 2, 0), (0.2, 0.8))
        pgm_function78.set_cpd((3, 2, 0), (0.4, 0.6))
        pgm_function78.set_cpd((0, 3, 0), (1.0, 0.0))
        pgm_function78.set_cpd((1, 3, 0), (1.0, 0.0))
        pgm_function78.set_cpd((2, 3, 0), (0.8, 0.2))
        pgm_function78.set_cpd((3, 3, 0), (0.4, 0.6))
        pgm_function78.set_cpd((0, 0, 1), (1.0, 0.0))
        pgm_function78.set_cpd((1, 0, 1), (1.0, 0.0))
        pgm_function78.set_cpd((2, 0, 1), (1.0, 0.0))
        pgm_function78.set_cpd((3, 0, 1), (1.0, 0.0))
        pgm_function78.set_cpd((0, 1, 1), (1.0, 0.0))
        pgm_function78.set_cpd((1, 1, 1), (0.8, 0.2))
        pgm_function78.set_cpd((2, 1, 1), (0.2, 0.8))
        pgm_function78.set_cpd((3, 1, 1), (0.4, 0.6))
        pgm_function78.set_cpd((0, 2, 1), (1.0, 0.0))
        pgm_function78.set_cpd((1, 2, 1), (0.8, 0.2))
        pgm_function78.set_cpd((2, 2, 1), (0.2, 0.8))
        pgm_function78.set_cpd((3, 2, 1), (0.4, 0.6))
        pgm_function78.set_cpd((0, 3, 1), (1.0, 0.0))
        pgm_function78.set_cpd((1, 3, 1), (1.0, 0.0))
        pgm_function78.set_cpd((2, 3, 1), (0.8, 0.2))
        pgm_function78.set_cpd((3, 3, 1), (0.4, 0.6))
        pgm_function78.set_cpd((0, 0, 2), (1.0, 0.0))
        pgm_function78.set_cpd((1, 0, 2), (1.0, 0.0))
        pgm_function78.set_cpd((2, 0, 2), (1.0, 0.0))
        pgm_function78.set_cpd((3, 0, 2), (1.0, 0.0))
        pgm_function78.set_cpd((0, 1, 2), (1.0, 0.0))
        pgm_function78.set_cpd((1, 1, 2), (0.5, 0.5))
        pgm_function78.set_cpd((2, 1, 2), (0.2, 0.8))
        pgm_function78.set_cpd((3, 1, 2), (0.1, 0.9))
        pgm_function78.set_cpd((0, 2, 2), (1.0, 0.0))
        pgm_function78.set_cpd((1, 2, 2), (0.5, 0.5))
        pgm_function78.set_cpd((2, 2, 2), (0.2, 0.8))
        pgm_function78.set_cpd((3, 2, 2), (0.1, 0.9))
        pgm_function78.set_cpd((0, 3, 2), (1.0, 0.0))
        pgm_function78.set_cpd((1, 3, 2), (1.0, 0.0))
        pgm_function78.set_cpd((2, 3, 2), (0.8, 0.2))
        pgm_function78.set_cpd((3, 3, 2), (0.4, 0.6))
        pgm_function78.set_cpd((0, 0, 3), (0.0, 1.0))
        pgm_function78.set_cpd((1, 0, 3), (0.0, 1.0))
        pgm_function78.set_cpd((2, 0, 3), (0.0, 1.0))
        pgm_function78.set_cpd((3, 0, 3), (0.0, 1.0))
        pgm_function78.set_cpd((0, 1, 3), (0.0, 1.0))
        pgm_function78.set_cpd((1, 1, 3), (0.0, 1.0))
        pgm_function78.set_cpd((2, 1, 3), (0.0, 1.0))
        pgm_function78.set_cpd((3, 1, 3), (0.0, 1.0))
        pgm_function78.set_cpd((0, 2, 3), (0.0, 1.0))
        pgm_function78.set_cpd((1, 2, 3), (0.0, 1.0))
        pgm_function78.set_cpd((2, 2, 3), (0.0, 1.0))
        pgm_function78.set_cpd((3, 2, 3), (0.0, 1.0))
        pgm_function78.set_cpd((0, 3, 3), (0.0, 1.0))
        pgm_function78.set_cpd((1, 3, 3), (0.0, 1.0))
        pgm_function78.set_cpd((2, 3, 3), (0.0, 1.0))
        pgm_function78.set_cpd((3, 3, 3), (0.0, 1.0))
        pgm_function78.set_cpd((0, 0, 4), (0.0, 1.0))
        pgm_function78.set_cpd((1, 0, 4), (0.0, 1.0))
        pgm_function78.set_cpd((2, 0, 4), (0.0, 1.0))
        pgm_function78.set_cpd((3, 0, 4), (0.0, 1.0))
        pgm_function78.set_cpd((0, 1, 4), (0.0, 1.0))
        pgm_function78.set_cpd((1, 1, 4), (0.0, 1.0))
        pgm_function78.set_cpd((2, 1, 4), (0.0, 1.0))
        pgm_function78.set_cpd((3, 1, 4), (0.0, 1.0))
        pgm_function78.set_cpd((0, 2, 4), (0.0, 1.0))
        pgm_function78.set_cpd((1, 2, 4), (0.0, 1.0))
        pgm_function78.set_cpd((2, 2, 4), (0.0, 1.0))
        pgm_function78.set_cpd((3, 2, 4), (0.0, 1.0))
        pgm_function78.set_cpd((0, 3, 4), (0.0, 1.0))
        pgm_function78.set_cpd((1, 3, 4), (0.0, 1.0))
        pgm_function78.set_cpd((2, 3, 4), (0.0, 1.0))
        pgm_function78.set_cpd((3, 3, 4), (0.0, 1.0))
        pgm_factor79 = self.new_factor(R_LNLW_MED_TIME)
        pgm_function79 = pgm_factor79.set_cpt()
        pgm_function79.set_cpd((), (0.05, 0.33, 0.6, 0.02))
        pgm_factor80 = self.new_factor(R_LNLW_APB_DE_REGEN, R_LNLW_MED_SEV, R_LNLW_MED_TIME, R_LNLW_MED_PATHO)
        pgm_function80 = pgm_factor80.set_cpt()
        pgm_function80.set_cpd((0, 0, 0), (1.0, 0.0))
        pgm_function80.set_cpd((1, 0, 0), (1.0, 0.0))
        pgm_function80.set_cpd((2, 0, 0), (1.0, 0.0))
        pgm_function80.set_cpd((3, 0, 0), (1.0, 0.0))
        pgm_function80.set_cpd((4, 0, 0), (1.0, 0.0))
        pgm_function80.set_cpd((0, 1, 0), (1.0, 0.0))
        pgm_function80.set_cpd((1, 1, 0), (0.8, 0.2))
        pgm_function80.set_cpd((2, 1, 0), (0.2, 0.8))
        pgm_function80.set_cpd((3, 1, 0), (0.4, 0.6))
        pgm_function80.set_cpd((4, 1, 0), (1.0, 0.0))
        pgm_function80.set_cpd((0, 2, 0), (1.0, 0.0))
        pgm_function80.set_cpd((1, 2, 0), (0.8, 0.2))
        pgm_function80.set_cpd((2, 2, 0), (0.2, 0.8))
        pgm_function80.set_cpd((3, 2, 0), (0.4, 0.6))
        pgm_function80.set_cpd((4, 2, 0), (1.0, 0.0))
        pgm_function80.set_cpd((0, 3, 0), (1.0, 0.0))
        pgm_function80.set_cpd((1, 3, 0), (1.0, 0.0))
        pgm_function80.set_cpd((2, 3, 0), (0.8, 0.2))
        pgm_function80.set_cpd((3, 3, 0), (0.4, 0.6))
        pgm_function80.set_cpd((4, 3, 0), (1.0, 0.0))
        pgm_function80.set_cpd((0, 0, 1), (1.0, 0.0))
        pgm_function80.set_cpd((1, 0, 1), (1.0, 0.0))
        pgm_function80.set_cpd((2, 0, 1), (1.0, 0.0))
        pgm_function80.set_cpd((3, 0, 1), (1.0, 0.0))
        pgm_function80.set_cpd((4, 0, 1), (1.0, 0.0))
        pgm_function80.set_cpd((0, 1, 1), (1.0, 0.0))
        pgm_function80.set_cpd((1, 1, 1), (0.8, 0.2))
        pgm_function80.set_cpd((2, 1, 1), (0.2, 0.8))
        pgm_function80.set_cpd((3, 1, 1), (0.4, 0.6))
        pgm_function80.set_cpd((4, 1, 1), (1.0, 0.0))
        pgm_function80.set_cpd((0, 2, 1), (1.0, 0.0))
        pgm_function80.set_cpd((1, 2, 1), (0.8, 0.2))
        pgm_function80.set_cpd((2, 2, 1), (0.2, 0.8))
        pgm_function80.set_cpd((3, 2, 1), (0.4, 0.6))
        pgm_function80.set_cpd((4, 2, 1), (1.0, 0.0))
        pgm_function80.set_cpd((0, 3, 1), (1.0, 0.0))
        pgm_function80.set_cpd((1, 3, 1), (1.0, 0.0))
        pgm_function80.set_cpd((2, 3, 1), (0.8, 0.2))
        pgm_function80.set_cpd((3, 3, 1), (0.4, 0.6))
        pgm_function80.set_cpd((4, 3, 1), (1.0, 0.0))
        pgm_function80.set_cpd((0, 0, 2), (1.0, 0.0))
        pgm_function80.set_cpd((1, 0, 2), (1.0, 0.0))
        pgm_function80.set_cpd((2, 0, 2), (1.0, 0.0))
        pgm_function80.set_cpd((3, 0, 2), (1.0, 0.0))
        pgm_function80.set_cpd((4, 0, 2), (1.0, 0.0))
        pgm_function80.set_cpd((0, 1, 2), (1.0, 0.0))
        pgm_function80.set_cpd((1, 1, 2), (0.5, 0.5))
        pgm_function80.set_cpd((2, 1, 2), (0.2, 0.8))
        pgm_function80.set_cpd((3, 1, 2), (0.1, 0.9))
        pgm_function80.set_cpd((4, 1, 2), (1.0, 0.0))
        pgm_function80.set_cpd((0, 2, 2), (1.0, 0.0))
        pgm_function80.set_cpd((1, 2, 2), (0.5, 0.5))
        pgm_function80.set_cpd((2, 2, 2), (0.2, 0.8))
        pgm_function80.set_cpd((3, 2, 2), (0.1, 0.9))
        pgm_function80.set_cpd((4, 2, 2), (1.0, 0.0))
        pgm_function80.set_cpd((0, 3, 2), (1.0, 0.0))
        pgm_function80.set_cpd((1, 3, 2), (1.0, 0.0))
        pgm_function80.set_cpd((2, 3, 2), (0.8, 0.2))
        pgm_function80.set_cpd((3, 3, 2), (0.4, 0.6))
        pgm_function80.set_cpd((4, 3, 2), (1.0, 0.0))
        pgm_function80.set_cpd((0, 0, 3), (0.0, 1.0))
        pgm_function80.set_cpd((1, 0, 3), (0.0, 1.0))
        pgm_function80.set_cpd((2, 0, 3), (0.0, 1.0))
        pgm_function80.set_cpd((3, 0, 3), (0.0, 1.0))
        pgm_function80.set_cpd((4, 0, 3), (0.0, 1.0))
        pgm_function80.set_cpd((0, 1, 3), (0.0, 1.0))
        pgm_function80.set_cpd((1, 1, 3), (0.0, 1.0))
        pgm_function80.set_cpd((2, 1, 3), (0.0, 1.0))
        pgm_function80.set_cpd((3, 1, 3), (0.0, 1.0))
        pgm_function80.set_cpd((4, 1, 3), (0.0, 1.0))
        pgm_function80.set_cpd((0, 2, 3), (0.0, 1.0))
        pgm_function80.set_cpd((1, 2, 3), (0.0, 1.0))
        pgm_function80.set_cpd((2, 2, 3), (0.0, 1.0))
        pgm_function80.set_cpd((3, 2, 3), (0.0, 1.0))
        pgm_function80.set_cpd((4, 2, 3), (0.0, 1.0))
        pgm_function80.set_cpd((0, 3, 3), (0.0, 1.0))
        pgm_function80.set_cpd((1, 3, 3), (0.0, 1.0))
        pgm_function80.set_cpd((2, 3, 3), (0.0, 1.0))
        pgm_function80.set_cpd((3, 3, 3), (0.0, 1.0))
        pgm_function80.set_cpd((4, 3, 3), (0.0, 1.0))
        pgm_function80.set_cpd((0, 0, 4), (0.0, 1.0))
        pgm_function80.set_cpd((1, 0, 4), (0.0, 1.0))
        pgm_function80.set_cpd((2, 0, 4), (0.0, 1.0))
        pgm_function80.set_cpd((3, 0, 4), (0.0, 1.0))
        pgm_function80.set_cpd((4, 0, 4), (0.0, 1.0))
        pgm_function80.set_cpd((0, 1, 4), (0.0, 1.0))
        pgm_function80.set_cpd((1, 1, 4), (0.0, 1.0))
        pgm_function80.set_cpd((2, 1, 4), (0.0, 1.0))
        pgm_function80.set_cpd((3, 1, 4), (0.0, 1.0))
        pgm_function80.set_cpd((4, 1, 4), (0.0, 1.0))
        pgm_function80.set_cpd((0, 2, 4), (0.0, 1.0))
        pgm_function80.set_cpd((1, 2, 4), (0.0, 1.0))
        pgm_function80.set_cpd((2, 2, 4), (0.0, 1.0))
        pgm_function80.set_cpd((3, 2, 4), (0.0, 1.0))
        pgm_function80.set_cpd((4, 2, 4), (0.0, 1.0))
        pgm_function80.set_cpd((0, 3, 4), (0.0, 1.0))
        pgm_function80.set_cpd((1, 3, 4), (0.0, 1.0))
        pgm_function80.set_cpd((2, 3, 4), (0.0, 1.0))
        pgm_function80.set_cpd((3, 3, 4), (0.0, 1.0))
        pgm_function80.set_cpd((4, 3, 4), (0.0, 1.0))
        pgm_factor81 = self.new_factor(R_DIFFN_LNLW_APB_DE_REGEN, R_DIFFN_APB_DE_REGEN, R_LNLW_APB_DE_REGEN)
        pgm_function81 = pgm_factor81.set_cpt()
        pgm_function81.set_cpd((0, 0), (1.0, 0.0))
        pgm_function81.set_cpd((1, 0), (0.0, 1.0))
        pgm_function81.set_cpd((0, 1), (0.0, 1.0))
        pgm_function81.set_cpd((1, 1), (0.0, 1.0))
        pgm_factor82 = self.new_factor(R_LNL_DIFFN_APB_DE_REGEN, R_LNLT1_LP_BE_APB_DE_REGEN, R_DIFFN_LNLW_APB_DE_REGEN)
        pgm_function82 = pgm_factor82.set_cpt()
        pgm_function82.set_cpd((0, 0), (1.0, 0.0))
        pgm_function82.set_cpd((1, 0), (0.0, 1.0))
        pgm_function82.set_cpd((0, 1), (0.0, 1.0))
        pgm_function82.set_cpd((1, 1), (0.0, 1.0))
        pgm_factor83 = self.new_factor(R_MYOP_APB_DE_REGEN)
        pgm_function83 = pgm_factor83.set_cpt()
        pgm_function83.set_cpd((), (1.0, 0.0))
        pgm_factor84 = self.new_factor(R_MYDY_APB_DE_REGEN)
        pgm_function84 = pgm_factor84.set_cpt()
        pgm_function84.set_cpd((), (1.0, 0.0))
        pgm_factor85 = self.new_factor(R_MYOP_MYDY_APB_DE_REGEN, R_MYOP_APB_DE_REGEN, R_MYDY_APB_DE_REGEN)
        pgm_function85 = pgm_factor85.set_cpt()
        pgm_function85.set_cpd((0, 0), (1.0, 0.0))
        pgm_function85.set_cpd((1, 0), (0.0, 1.0))
        pgm_function85.set_cpd((0, 1), (0.0, 1.0))
        pgm_function85.set_cpd((1, 1), (0.0, 1.0))
        pgm_factor86 = self.new_factor(R_APB_DE_REGEN, R_LNL_DIFFN_APB_DE_REGEN, R_MYOP_MYDY_APB_DE_REGEN)
        pgm_function86 = pgm_factor86.set_cpt()
        pgm_function86.set_cpd((0, 0), (1.0, 0.0))
        pgm_function86.set_cpd((1, 0), (0.0, 1.0))
        pgm_function86.set_cpd((0, 1), (0.0, 1.0))
        pgm_function86.set_cpd((1, 1), (0.0, 1.0))
        pgm_factor87 = self.new_factor(R_DE_REGEN_APB_NMT, R_APB_DE_REGEN)
        pgm_function87 = pgm_factor87.set_cpt()
        pgm_function87.set_cpd((0,), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function87.set_cpd((1,), (0.949, 0.003, 0.001, 0.04, 0.003, 0.001, 0.003))
        pgm_factor88 = self.new_factor(R_MYAS_APB_NMT)
        pgm_function88 = pgm_factor88.set_cpt()
        pgm_function88.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor89 = self.new_factor(R_APB_NMT, R_DE_REGEN_APB_NMT, R_MYAS_APB_NMT)
        pgm_function89 = pgm_factor89.set_cpt()
        pgm_function89.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function89.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function89.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function89.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function89.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function89.set_cpd((5, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function89.set_cpd((6, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function89.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function89.set_cpd((1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function89.set_cpd((2, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function89.set_cpd((3, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function89.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function89.set_cpd((5, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function89.set_cpd((6, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function89.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function89.set_cpd((1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function89.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function89.set_cpd((3, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function89.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function89.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function89.set_cpd((6, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function89.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function89.set_cpd((1, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function89.set_cpd((2, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function89.set_cpd((3, 3), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function89.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function89.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function89.set_cpd((6, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function89.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function89.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function89.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function89.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function89.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function89.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function89.set_cpd((6, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function89.set_cpd((0, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function89.set_cpd((1, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function89.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function89.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function89.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function89.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function89.set_cpd((6, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function89.set_cpd((0, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function89.set_cpd((1, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function89.set_cpd((2, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function89.set_cpd((3, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function89.set_cpd((4, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function89.set_cpd((5, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function89.set_cpd((6, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor90 = self.new_factor(R_MYDY_APB_MUSIZE)
        pgm_function90 = pgm_factor90.set_cpt()
        pgm_function90.set_cpd((), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_factor91 = self.new_factor(R_MYOP_APB_MUSIZE)
        pgm_function91 = pgm_factor91.set_cpt()
        pgm_function91.set_cpd((), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_factor92 = self.new_factor(R_MYOP_MYDY_APB_MUSIZE, R_MYDY_APB_MUSIZE, R_MYOP_APB_MUSIZE)
        pgm_function92 = pgm_factor92.set_cpt()
        pgm_function92.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function92.set_cpd((1, 0), (0.9983, 0.0017, 0.0, 0.0, 0.0, 0.0))
        pgm_function92.set_cpd((2, 0), (0.9857, 0.0143, 0.0, 0.0, 0.0, 0.0))
        pgm_function92.set_cpd((3, 0), (0.3673, 0.6298, 0.0029, 0.0, 0.0, 0.0))
        pgm_function92.set_cpd((4, 0), (0.01150115, 0.86168617, 0.12491249, 0.00190019, 0.0, 0.0))
        pgm_function92.set_cpd((5, 0), (0.0, 0.1596, 0.7368, 0.1016, 0.002, 0.0))
        pgm_function92.set_cpd((0, 1), (0.9983, 0.0017, 0.0, 0.0, 0.0, 0.0))
        pgm_function92.set_cpd((1, 1), (0.8667, 0.1329, 0.0004, 0.0, 0.0, 0.0))
        pgm_function92.set_cpd((2, 1), (0.01390139, 0.96369637, 0.02240224, 0.0, 0.0, 0.0))
        pgm_function92.set_cpd((3, 1), (0.0003, 0.3514, 0.6035, 0.0443, 0.0005, 0.0))
        pgm_function92.set_cpd((4, 1), (0.0, 0.0105, 0.5726, 0.3806, 0.0359, 0.0004))
        pgm_function92.set_cpd((5, 1), (0.0, 0.0, 0.0792, 0.4758, 0.4066, 0.0384))
        pgm_function92.set_cpd((0, 2), (0.9857, 0.0143, 0.0, 0.0, 0.0, 0.0))
        pgm_function92.set_cpd((1, 2), (0.01390139, 0.96369637, 0.02240224, 0.0, 0.0, 0.0))
        pgm_function92.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function92.set_cpd((3, 2), (0.0, 0.0, 0.04060406, 0.92779278, 0.03160316, 0.0))
        pgm_function92.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0319, 0.9362, 0.0319))
        pgm_function92.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 0.0329, 0.9671))
        pgm_function92.set_cpd((0, 3), (0.3673, 0.6298, 0.0029, 0.0, 0.0, 0.0))
        pgm_function92.set_cpd((1, 3), (0.0003, 0.3514, 0.6035, 0.0443, 0.0005, 0.0))
        pgm_function92.set_cpd((2, 3), (0.0, 0.0, 0.04060406, 0.92779278, 0.03160316, 0.0))
        pgm_function92.set_cpd((3, 3), (0.0, 0.0, 0.00039996, 0.10988901, 0.77982202, 0.10988901))
        pgm_function92.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.00030003, 0.12341234, 0.87628763))
        pgm_function92.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0028, 0.9972))
        pgm_function92.set_cpd((0, 4), (0.01150115, 0.86168617, 0.12491249, 0.00190019, 0.0, 0.0))
        pgm_function92.set_cpd((1, 4), (0.0, 0.0105, 0.5726, 0.3806, 0.0359, 0.0004))
        pgm_function92.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0319, 0.9362, 0.0319))
        pgm_function92.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.00030003, 0.12341234, 0.87628763))
        pgm_function92.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 0.0028, 0.9972))
        pgm_function92.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0001, 0.9999))
        pgm_function92.set_cpd((0, 5), (0.0, 0.1596, 0.7368, 0.1016, 0.002, 0.0))
        pgm_function92.set_cpd((1, 5), (0.0, 0.0, 0.0792, 0.4758, 0.4066, 0.0384))
        pgm_function92.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0329, 0.9671))
        pgm_function92.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0028, 0.9972))
        pgm_function92.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0001, 0.9999))
        pgm_function92.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor93 = self.new_factor(R_LNLW_APB_MUSIZE, R_LNLW_MED_SEV, R_LNLW_MED_TIME, R_LNLW_MED_PATHO)
        pgm_function93 = pgm_factor93.set_cpt()
        pgm_function93.set_cpd((0, 0, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((1, 0, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((2, 0, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((3, 0, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((4, 0, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((0, 1, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((1, 1, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((2, 1, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((3, 1, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((4, 1, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((0, 2, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((1, 2, 0), (0.0, 0.0, 0.9, 0.1, 0.0, 0.0))
        pgm_function93.set_cpd((2, 2, 0), (0.0, 0.0, 0.2, 0.7, 0.1, 0.0))
        pgm_function93.set_cpd((3, 2, 0), (0.0, 0.0, 0.0, 0.2, 0.7, 0.1))
        pgm_function93.set_cpd((4, 2, 0), (0.0, 0.0, 0.0, 0.2, 0.7, 0.1))
        pgm_function93.set_cpd((0, 3, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((1, 3, 0), (0.0, 0.0, 0.9, 0.1, 0.0, 0.0))
        pgm_function93.set_cpd((2, 3, 0), (0.0, 0.0, 0.2, 0.7, 0.1, 0.0))
        pgm_function93.set_cpd((3, 3, 0), (0.0, 0.0, 0.0, 0.2, 0.7, 0.1))
        pgm_function93.set_cpd((4, 3, 0), (0.0, 0.0, 0.0, 0.2, 0.7, 0.1))
        pgm_function93.set_cpd((0, 0, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((1, 0, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((2, 0, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((3, 0, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((4, 0, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((0, 1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((1, 1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((2, 1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((3, 1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((4, 1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((0, 2, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((1, 2, 1), (0.0, 0.0, 0.95, 0.05, 0.0, 0.0))
        pgm_function93.set_cpd((2, 2, 1), (0.0, 0.0, 0.7, 0.25, 0.05, 0.0))
        pgm_function93.set_cpd((3, 2, 1), (0.0, 0.0, 0.0, 0.25, 0.7, 0.05))
        pgm_function93.set_cpd((4, 2, 1), (0.0, 0.0, 0.0, 0.25, 0.7, 0.05))
        pgm_function93.set_cpd((0, 3, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((1, 3, 1), (0.0, 0.0, 0.95, 0.05, 0.0, 0.0))
        pgm_function93.set_cpd((2, 3, 1), (0.0, 0.0, 0.7, 0.25, 0.05, 0.0))
        pgm_function93.set_cpd((3, 3, 1), (0.0, 0.0, 0.0, 0.25, 0.7, 0.05))
        pgm_function93.set_cpd((4, 3, 1), (0.0, 0.0, 0.0, 0.25, 0.7, 0.05))
        pgm_function93.set_cpd((0, 0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((1, 0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((2, 0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((3, 0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((4, 0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((0, 1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((1, 1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((2, 1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((3, 1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((4, 1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((0, 2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((1, 2, 2), (0.0, 0.0, 0.8, 0.2, 0.0, 0.0))
        pgm_function93.set_cpd((2, 2, 2), (0.0, 0.0, 0.0, 0.8, 0.2, 0.0))
        pgm_function93.set_cpd((3, 2, 2), (0.0, 0.0, 0.0, 0.1, 0.6, 0.3))
        pgm_function93.set_cpd((4, 2, 2), (0.0, 0.0, 0.0, 0.1, 0.6, 0.3))
        pgm_function93.set_cpd((0, 3, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((1, 3, 2), (0.0, 0.0, 0.8, 0.2, 0.0, 0.0))
        pgm_function93.set_cpd((2, 3, 2), (0.0, 0.0, 0.0, 0.8, 0.2, 0.0))
        pgm_function93.set_cpd((3, 3, 2), (0.0, 0.0, 0.0, 0.1, 0.6, 0.3))
        pgm_function93.set_cpd((4, 3, 2), (0.0, 0.0, 0.0, 0.1, 0.6, 0.3))
        pgm_function93.set_cpd((0, 0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((1, 0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((2, 0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((3, 0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((4, 0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((0, 1, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((1, 1, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((2, 1, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((3, 1, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((4, 1, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((0, 2, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((1, 2, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((2, 2, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((3, 2, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((4, 2, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((0, 3, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((1, 3, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((2, 3, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((3, 3, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((4, 3, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((0, 0, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((1, 0, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((2, 0, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((3, 0, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((4, 0, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((0, 1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((1, 1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((2, 1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((3, 1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((4, 1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((0, 2, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((1, 2, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((2, 2, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((3, 2, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((4, 2, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((0, 3, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((1, 3, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((2, 3, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((3, 3, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function93.set_cpd((4, 3, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor94 = self.new_factor(R_DIFFN_APB_MUSIZE, DIFFN_M_SEV_DIST, DIFFN_TIME, DIFFN_PATHO)
        pgm_function94 = pgm_factor94.set_cpt()
        pgm_function94.set_cpd((0, 0, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((1, 0, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((2, 0, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((3, 0, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((0, 1, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((1, 1, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((2, 1, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((3, 1, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((0, 2, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((1, 2, 0), (0.0, 0.0, 0.7, 0.3, 0.0, 0.0))
        pgm_function94.set_cpd((2, 2, 0), (0.0, 0.0, 0.0, 0.8, 0.2, 0.0))
        pgm_function94.set_cpd((3, 2, 0), (0.0, 0.0, 0.0, 0.0, 0.5, 0.5))
        pgm_function94.set_cpd((0, 3, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((1, 3, 0), (0.0, 0.0, 0.7, 0.3, 0.0, 0.0))
        pgm_function94.set_cpd((2, 3, 0), (0.0, 0.0, 0.0, 0.8, 0.2, 0.0))
        pgm_function94.set_cpd((3, 3, 0), (0.0, 0.0, 0.0, 0.0, 0.5, 0.5))
        pgm_function94.set_cpd((0, 0, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((1, 0, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((2, 0, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((3, 0, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((0, 1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((1, 1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((2, 1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((3, 1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((0, 2, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((1, 2, 1), (0.0, 0.0, 0.9, 0.1, 0.0, 0.0))
        pgm_function94.set_cpd((2, 2, 1), (0.0, 0.0, 0.7, 0.2, 0.1, 0.0))
        pgm_function94.set_cpd((3, 2, 1), (0.0, 0.0, 0.0, 0.25, 0.5, 0.25))
        pgm_function94.set_cpd((0, 3, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((1, 3, 1), (0.0, 0.0, 0.9, 0.1, 0.0, 0.0))
        pgm_function94.set_cpd((2, 3, 1), (0.0, 0.0, 0.7, 0.2, 0.1, 0.0))
        pgm_function94.set_cpd((3, 3, 1), (0.0, 0.0, 0.0, 0.25, 0.5, 0.25))
        pgm_function94.set_cpd((0, 0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((1, 0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((2, 0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((3, 0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((0, 1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((1, 1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((2, 1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((3, 1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((0, 2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((1, 2, 2), (0.0, 0.0, 0.7, 0.3, 0.0, 0.0))
        pgm_function94.set_cpd((2, 2, 2), (0.0, 0.0, 0.0, 0.7, 0.3, 0.0))
        pgm_function94.set_cpd((3, 2, 2), (0.0, 0.0, 0.0, 0.0, 0.5, 0.5))
        pgm_function94.set_cpd((0, 3, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((1, 3, 2), (0.0, 0.0, 0.7, 0.3, 0.0, 0.0))
        pgm_function94.set_cpd((2, 3, 2), (0.0, 0.0, 0.0, 0.7, 0.3, 0.0))
        pgm_function94.set_cpd((3, 3, 2), (0.0, 0.0, 0.0, 0.0, 0.5, 0.5))
        pgm_function94.set_cpd((0, 0, 3), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((1, 0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((2, 0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((3, 0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((0, 1, 3), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((1, 1, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((2, 1, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((3, 1, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((0, 2, 3), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((1, 2, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((2, 2, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((3, 2, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((0, 3, 3), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((1, 3, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((2, 3, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((3, 3, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((0, 0, 4), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((1, 0, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((2, 0, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((3, 0, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((0, 1, 4), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((1, 1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((2, 1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((3, 1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((0, 2, 4), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((1, 2, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((2, 2, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((3, 2, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((0, 3, 4), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((1, 3, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((2, 3, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function94.set_cpd((3, 3, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor95 = self.new_factor(R_DIFFN_LNLW_APB_MUSIZE, R_LNLW_APB_MUSIZE, R_DIFFN_APB_MUSIZE)
        pgm_function95 = pgm_factor95.set_cpt()
        pgm_function95.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function95.set_cpd((1, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function95.set_cpd((2, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function95.set_cpd((3, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function95.set_cpd((4, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function95.set_cpd((5, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function95.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function95.set_cpd((1, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function95.set_cpd((2, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function95.set_cpd((3, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function95.set_cpd((4, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function95.set_cpd((5, 1), (0.0, 0.99939994, 0.00050005, 0.00010001, 0.0, 0.0))
        pgm_function95.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function95.set_cpd((1, 2), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function95.set_cpd((2, 2), (0.0, 0.0, 0.9981, 0.0019, 0.0, 0.0))
        pgm_function95.set_cpd((3, 2), (0.0, 0.0, 0.0019, 0.9981, 0.0, 0.0))
        pgm_function95.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function95.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function95.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function95.set_cpd((1, 3), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function95.set_cpd((2, 3), (0.0, 0.0, 0.0019, 0.9981, 0.0, 0.0))
        pgm_function95.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function95.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function95.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function95.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function95.set_cpd((1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function95.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function95.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function95.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function95.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function95.set_cpd((0, 5), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function95.set_cpd((1, 5), (0.0, 0.99939994, 0.00050005, 0.00010001, 0.0, 0.0))
        pgm_function95.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function95.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function95.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function95.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor96 = self.new_factor(R_LNLBE_APB_MUSIZE)
        pgm_function96 = pgm_factor96.set_cpt()
        pgm_function96.set_cpd((), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_factor97 = self.new_factor(R_LNLLP_APB_MUSIZE)
        pgm_function97 = pgm_factor97.set_cpt()
        pgm_function97.set_cpd((), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_factor98 = self.new_factor(R_LNLT1_APB_MUSIZE)
        pgm_function98 = pgm_factor98.set_cpt()
        pgm_function98.set_cpd((), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_factor99 = self.new_factor(R_LNLT1_LP_APB_MUSIZE, R_LNLLP_APB_MUSIZE, R_LNLT1_APB_MUSIZE)
        pgm_function99 = pgm_factor99.set_cpt()
        pgm_function99.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function99.set_cpd((1, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function99.set_cpd((2, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function99.set_cpd((3, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function99.set_cpd((4, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function99.set_cpd((5, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function99.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function99.set_cpd((1, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function99.set_cpd((2, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function99.set_cpd((3, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function99.set_cpd((4, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function99.set_cpd((5, 1), (0.0, 0.99939994, 0.00050005, 0.00010001, 0.0, 0.0))
        pgm_function99.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function99.set_cpd((1, 2), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function99.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function99.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function99.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function99.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function99.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function99.set_cpd((1, 3), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function99.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function99.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function99.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function99.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function99.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function99.set_cpd((1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function99.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function99.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function99.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function99.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function99.set_cpd((0, 5), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function99.set_cpd((1, 5), (0.0, 0.99939994, 0.00050005, 0.00010001, 0.0, 0.0))
        pgm_function99.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function99.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function99.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function99.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor100 = self.new_factor(R_LNLT1_LP_BE_APB_MUSIZE, R_LNLBE_APB_MUSIZE, R_LNLT1_LP_APB_MUSIZE)
        pgm_function100 = pgm_factor100.set_cpt()
        pgm_function100.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function100.set_cpd((1, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function100.set_cpd((2, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function100.set_cpd((3, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function100.set_cpd((4, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function100.set_cpd((5, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function100.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function100.set_cpd((1, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function100.set_cpd((2, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function100.set_cpd((3, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function100.set_cpd((4, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function100.set_cpd((5, 1), (0.0, 0.99939994, 0.00050005, 0.00010001, 0.0, 0.0))
        pgm_function100.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function100.set_cpd((1, 2), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function100.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function100.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function100.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function100.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function100.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function100.set_cpd((1, 3), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function100.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function100.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function100.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function100.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function100.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function100.set_cpd((1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function100.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function100.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function100.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function100.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function100.set_cpd((0, 5), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function100.set_cpd((1, 5), (0.0, 0.99939994, 0.00050005, 0.00010001, 0.0, 0.0))
        pgm_function100.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function100.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function100.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function100.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor101 = self.new_factor(R_LNL_DIFFN_APB_MUSIZE, R_DIFFN_LNLW_APB_MUSIZE, R_LNLT1_LP_BE_APB_MUSIZE)
        pgm_function101 = pgm_factor101.set_cpt()
        pgm_function101.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function101.set_cpd((1, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function101.set_cpd((2, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function101.set_cpd((3, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function101.set_cpd((4, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function101.set_cpd((5, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function101.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function101.set_cpd((1, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function101.set_cpd((2, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function101.set_cpd((3, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function101.set_cpd((4, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function101.set_cpd((5, 1), (0.0, 0.99939994, 0.00050005, 0.00010001, 0.0, 0.0))
        pgm_function101.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function101.set_cpd((1, 2), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function101.set_cpd((2, 2), (0.0, 0.0, 0.9981, 0.0019, 0.0, 0.0))
        pgm_function101.set_cpd((3, 2), (0.0, 0.0, 0.0019, 0.9981, 0.0, 0.0))
        pgm_function101.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function101.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function101.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function101.set_cpd((1, 3), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function101.set_cpd((2, 3), (0.0, 0.0, 0.0019, 0.9981, 0.0, 0.0))
        pgm_function101.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function101.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function101.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function101.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function101.set_cpd((1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function101.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function101.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function101.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function101.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function101.set_cpd((0, 5), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function101.set_cpd((1, 5), (0.0, 0.99939994, 0.00050005, 0.00010001, 0.0, 0.0))
        pgm_function101.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function101.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function101.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function101.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor102 = self.new_factor(R_APB_MUSIZE, R_MYOP_MYDY_APB_MUSIZE, R_LNL_DIFFN_APB_MUSIZE)
        pgm_function102 = pgm_factor102.set_cpt()
        pgm_function102.set_cpd((0, 0), (0.9791, 0.0009, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function102.set_cpd((1, 0), (0.9637, 0.0163, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function102.set_cpd((2, 0), (0.92219222, 0.05780578, 0.0, 0.0, 0.0, 0.0, 0.020002))
        pgm_function102.set_cpd((3, 0), (0.39793979, 0.56635664, 0.01550155, 0.00020002, 0.0, 0.0, 0.020002))
        pgm_function102.set_cpd((4, 0), (0.0435, 0.7319, 0.193, 0.0114, 0.0002, 0.0, 0.02))
        pgm_function102.set_cpd((5, 0),
                                (0.00120012, 0.23172317, 0.58825883, 0.14741474, 0.01120112, 0.00020002, 0.020002))
        pgm_function102.set_cpd((0, 1), (0.9637, 0.0163, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function102.set_cpd((1, 1), (0.7493, 0.2257, 0.0049, 0.0001, 0.0, 0.0, 0.02))
        pgm_function102.set_cpd((2, 1), (0.0537, 0.8568, 0.0684, 0.0011, 0.0, 0.0, 0.02))
        pgm_function102.set_cpd((3, 1),
                                (0.00389961, 0.38106189, 0.50654935, 0.08409159, 0.00429957, 9.999e-05, 0.019998))
        pgm_function102.set_cpd((4, 1), (0.0, 0.0395, 0.5059, 0.355, 0.0758, 0.0038, 0.02))
        pgm_function102.set_cpd((5, 1), (0.0, 0.00110011, 0.13571357, 0.40254025, 0.36313631, 0.07750775, 0.020002))
        pgm_function102.set_cpd((0, 2), (0.92219222, 0.05780578, 0.0, 0.0, 0.0, 0.0, 0.020002))
        pgm_function102.set_cpd((1, 2), (0.0537, 0.8568, 0.0684, 0.0011, 0.0, 0.0, 0.02))
        pgm_function102.set_cpd((2, 2), (0.0, 0.0, 0.98, 0.0, 0.0, 0.0, 0.02))
        pgm_function102.set_cpd((3, 2), (0.0, 0.0, 0.09080908, 0.81858186, 0.07060706, 0.0, 0.020002))
        pgm_function102.set_cpd((4, 2), (0.0, 0.0, 0.0001, 0.0721, 0.8357, 0.0721, 0.02))
        pgm_function102.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0001, 0.0778, 0.9021, 0.02))
        pgm_function102.set_cpd((0, 3), (0.39793979, 0.56635664, 0.01550155, 0.00020002, 0.0, 0.0, 0.020002))
        pgm_function102.set_cpd((1, 3),
                                (0.00389961, 0.38106189, 0.50654935, 0.08409159, 0.00429957, 9.999e-05, 0.019998))
        pgm_function102.set_cpd((2, 3), (0.0, 0.0, 0.09080908, 0.81858186, 0.07060706, 0.0, 0.020002))
        pgm_function102.set_cpd((3, 3), (0.0, 0.0, 0.00359964, 0.16548345, 0.64543546, 0.16548345, 0.019998))
        pgm_function102.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0034, 0.1993, 0.7773, 0.02))
        pgm_function102.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.01620162, 0.96379638, 0.020002))
        pgm_function102.set_cpd((0, 4), (0.0435, 0.7319, 0.193, 0.0114, 0.0002, 0.0, 0.02))
        pgm_function102.set_cpd((1, 4), (0.0, 0.0395, 0.5059, 0.355, 0.0758, 0.0038, 0.02))
        pgm_function102.set_cpd((2, 4), (0.0, 0.0, 0.0001, 0.0721, 0.8357, 0.0721, 0.02))
        pgm_function102.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0034, 0.1993, 0.7773, 0.02))
        pgm_function102.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 0.01620162, 0.96379638, 0.020002))
        pgm_function102.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0011, 0.9789, 0.02))
        pgm_function102.set_cpd((0, 5),
                                (0.00120012, 0.23172317, 0.58825883, 0.14741474, 0.01120112, 0.00020002, 0.020002))
        pgm_function102.set_cpd((1, 5), (0.0, 0.00110011, 0.13571357, 0.40254025, 0.36313631, 0.07750775, 0.020002))
        pgm_function102.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0001, 0.0778, 0.9021, 0.02))
        pgm_function102.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.01620162, 0.96379638, 0.020002))
        pgm_function102.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0011, 0.9789, 0.02))
        pgm_function102.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0001, 0.9799, 0.02))
        pgm_factor103 = self.new_factor(R_APB_EFFMUS, R_APB_NMT, R_APB_MUSIZE)
        pgm_function103 = pgm_factor103.set_cpt()
        pgm_function103.set_cpd((0, 0), (0.9683, 0.0117, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function103.set_cpd((1, 0), (0.9794, 0.0006, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function103.set_cpd((2, 0), (0.9799, 0.0001, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function103.set_cpd((3, 0), (0.9742, 0.0058, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function103.set_cpd((4, 0), (0.9789, 0.0011, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function103.set_cpd((5, 0), (0.9799, 0.0001, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function103.set_cpd((6, 0), (0.7927, 0.1721, 0.0135, 0.0016, 0.0001, 0.0, 0.02))
        pgm_function103.set_cpd((0, 1), (0.0164, 0.9421, 0.0215, 0.0, 0.0, 0.0, 0.02))
        pgm_function103.set_cpd((1, 1), (0.8182, 0.1616, 0.0002, 0.0, 0.0, 0.0, 0.02))
        pgm_function103.set_cpd((2, 1), (0.9738, 0.0062, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function103.set_cpd((3, 1), (0.0329, 0.9359, 0.0112, 0.0, 0.0, 0.0, 0.02))
        pgm_function103.set_cpd((4, 1), (0.3885, 0.59, 0.0015, 0.0, 0.0, 0.0, 0.02))
        pgm_function103.set_cpd((5, 1), (0.9362, 0.0438, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function103.set_cpd((6, 1),
                                (0.4929507, 0.37036296, 0.09059094, 0.02169783, 0.00389961, 0.00049995, 0.019998))
        pgm_function103.set_cpd((0, 2), (0.0, 0.0, 0.97369737, 0.00630063, 0.0, 0.0, 0.020002))
        pgm_function103.set_cpd((1, 2), (0.00070007, 0.94039404, 0.03890389, 0.0, 0.0, 0.0, 0.020002))
        pgm_function103.set_cpd((2, 2), (0.7833, 0.1966, 0.0001, 0.0, 0.0, 0.0, 0.02))
        pgm_function103.set_cpd((3, 2), (0.0, 9.999e-05, 0.97830217, 0.00159984, 0.0, 0.0, 0.019998))
        pgm_function103.set_cpd((4, 2), (0.0, 0.3781, 0.6016, 0.0003, 0.0, 0.0, 0.02))
        pgm_function103.set_cpd((5, 2), (0.01149885, 0.96530347, 0.00319968, 0.0, 0.0, 0.0, 0.019998))
        pgm_function103.set_cpd((6, 2),
                                (0.15051505, 0.39773977, 0.27152715, 0.11721172, 0.03610361, 0.00690069, 0.020002))
        pgm_function103.set_cpd((0, 3), (0.0, 0.0, 0.0082, 0.9646, 0.0072, 0.0, 0.02))
        pgm_function103.set_cpd((1, 3), (0.0, 0.0571, 0.8829, 0.04, 0.0, 0.0, 0.02))
        pgm_function103.set_cpd((2, 3), (0.0541, 0.9055, 0.0203, 0.0001, 0.0, 0.0, 0.02))
        pgm_function103.set_cpd((3, 3), (0.0, 0.0, 0.03260326, 0.94569457, 0.00170017, 0.0, 0.020002))
        pgm_function103.set_cpd((4, 3), (0.0, 0.0, 0.7931, 0.1868, 0.0001, 0.0, 0.02))
        pgm_function103.set_cpd((5, 3), (0.0, 0.439, 0.5362, 0.0048, 0.0, 0.0, 0.02))
        pgm_function103.set_cpd((6, 3), (0.0391, 0.2318, 0.3318, 0.2294, 0.1131, 0.0348, 0.02))
        pgm_function103.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0072, 0.9656, 0.0072, 0.02))
        pgm_function103.set_cpd((1, 4), (0.0, 0.0001, 0.3198, 0.6276, 0.0325, 0.0, 0.02))
        pgm_function103.set_cpd((2, 4), (0.0004, 0.4664, 0.4912, 0.0219, 0.0001, 0.0, 0.02))
        pgm_function103.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0287, 0.9496, 0.0017, 0.02))
        pgm_function103.set_cpd((4, 4), (0.0, 0.0, 0.0071, 0.7665, 0.2063, 0.0001, 0.02))
        pgm_function103.set_cpd((5, 4), (0.0, 0.00150015, 0.70187019, 0.27382738, 0.00280028, 0.0, 0.020002))
        pgm_function103.set_cpd((6, 4), (0.0065, 0.0866, 0.2598, 0.2877, 0.2273, 0.1121, 0.02))
        pgm_function103.set_cpd((0, 5), (0.0, 0.0, 0.0, 0.0, 0.0072, 0.9728, 0.02))
        pgm_function103.set_cpd((1, 5), (0.0, 0.0, 0.0034, 0.2908, 0.6521, 0.0337, 0.02))
        pgm_function103.set_cpd((2, 5), (0.0, 0.01269746, 0.62637473, 0.32423515, 0.01659668, 9.998e-05, 0.019996))
        pgm_function103.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0287, 0.9513, 0.02))
        pgm_function103.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0062, 0.7673, 0.2065, 0.02))
        pgm_function103.set_cpd((5, 5), (0.0, 0.0, 0.03839616, 0.64913509, 0.28947105, 0.0029997, 0.019998))
        pgm_function103.set_cpd((6, 5),
                                (0.00079984, 0.02239552, 0.14087183, 0.24985003, 0.31623675, 0.24985003, 0.019996))
        pgm_function103.set_cpd((0, 6), (0.1111, 0.2284, 0.2388, 0.1875, 0.1354, 0.0788, 0.02))
        pgm_function103.set_cpd((1, 6),
                                (0.24267573, 0.30486951, 0.20687931, 0.12458754, 0.06949305, 0.03149685, 0.019998))
        pgm_function103.set_cpd((2, 6), (0.4236, 0.3196, 0.1381, 0.0628, 0.0267, 0.0092, 0.02))
        pgm_function103.set_cpd((3, 6), (0.1227, 0.2392, 0.2382, 0.1813, 0.127, 0.0716, 0.02))
        pgm_function103.set_cpd((4, 6),
                                (0.17768223, 0.27767223, 0.22747725, 0.15348465, 0.09559044, 0.04809519, 0.019998))
        pgm_function103.set_cpd((5, 6), (0.2958, 0.3186, 0.1878, 0.1033, 0.0527, 0.0218, 0.02))
        pgm_function103.set_cpd((6, 6),
                                (0.21972197, 0.26492649, 0.20142014, 0.14061406, 0.09640964, 0.05690569, 0.020002))
        pgm_factor104 = self.new_factor(R_LNLW_MED_BLOCK, R_LNLW_MED_SEV, R_LNLW_MED_PATHO)
        pgm_function104 = pgm_factor104.set_cpt()
        pgm_function104.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function104.set_cpd((1, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function104.set_cpd((2, 0), (0.6, 0.4, 0.0, 0.0, 0.0))
        pgm_function104.set_cpd((3, 0), (0.25, 0.5, 0.25, 0.0, 0.0))
        pgm_function104.set_cpd((4, 0), (0.2, 0.2, 0.2, 0.2, 0.2))
        pgm_function104.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function104.set_cpd((1, 1), (0.0, 0.5, 0.5, 0.0, 0.0))
        pgm_function104.set_cpd((2, 1), (0.0, 0.5, 0.5, 0.0, 0.0))
        pgm_function104.set_cpd((3, 1), (0.0, 0.0, 0.4, 0.5, 0.1))
        pgm_function104.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function104.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function104.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function104.set_cpd((2, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function104.set_cpd((3, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function104.set_cpd((4, 2), (0.2, 0.2, 0.2, 0.2, 0.2))
        pgm_function104.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function104.set_cpd((1, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function104.set_cpd((2, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function104.set_cpd((3, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function104.set_cpd((4, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function104.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function104.set_cpd((1, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function104.set_cpd((2, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function104.set_cpd((3, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function104.set_cpd((4, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor105 = self.new_factor(R_MED_BLOCK_WA, R_DIFFN_MED_BLOCK, R_LNLW_MED_BLOCK)
        pgm_function105 = pgm_factor105.set_cpt()
        pgm_function105.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function105.set_cpd((1, 0), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function105.set_cpd((2, 0), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function105.set_cpd((3, 0), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function105.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function105.set_cpd((0, 1), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function105.set_cpd((1, 1), (0.0001, 0.498, 0.5019, 0.0, 0.0))
        pgm_function105.set_cpd((2, 1), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function105.set_cpd((3, 1), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function105.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function105.set_cpd((0, 2), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function105.set_cpd((1, 2), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function105.set_cpd((2, 2), (0.0, 0.0007, 0.4328, 0.5665, 0.0))
        pgm_function105.set_cpd((3, 2), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function105.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function105.set_cpd((0, 3), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function105.set_cpd((1, 3), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function105.set_cpd((2, 3), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function105.set_cpd((3, 3), (0.00030003, 0.00110011, 0.01250125, 0.98609861, 0.0))
        pgm_function105.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function105.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function105.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function105.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function105.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function105.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor106 = self.new_factor(R_APB_MULOSS, R_MED_BLOCK_WA, R_APB_MALOSS)
        pgm_function106 = pgm_factor106.set_cpt()
        pgm_function106.set_cpd((0, 0), (0.98, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function106.set_cpd((1, 0), (0.9746, 0.0054, 0.0, 0.0, 0.0, 0.02))
        pgm_function106.set_cpd((2, 0), (0.0664, 0.9136, 0.0, 0.0, 0.0, 0.02))
        pgm_function106.set_cpd((3, 0), (0.016, 0.1801, 0.7138, 0.0701, 0.0, 0.02))
        pgm_function106.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function106.set_cpd((0, 1), (0.0167, 0.9613, 0.002, 0.0, 0.0, 0.02))
        pgm_function106.set_cpd((1, 1), (0.00340034, 0.9529953, 0.02360236, 0.0, 0.0, 0.020002))
        pgm_function106.set_cpd((2, 1), (0.0002, 0.2725, 0.7073, 0.0, 0.0, 0.02))
        pgm_function106.set_cpd((3, 1), (0.0009, 0.0263, 0.4192, 0.5336, 0.0, 0.02))
        pgm_function106.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function106.set_cpd((0, 2), (0.00019998, 0.05349465, 0.92370763, 0.00259974, 0.0, 0.019998))
        pgm_function106.set_cpd((1, 2), (0.0, 0.02340234, 0.94509451, 0.01150115, 0.0, 0.020002))
        pgm_function106.set_cpd((2, 2), (0.0, 0.0048, 0.7523, 0.2229, 0.0, 0.02))
        pgm_function106.set_cpd((3, 2), (0.0, 0.00130013, 0.06370637, 0.9149915, 0.0, 0.020002))
        pgm_function106.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function106.set_cpd((0, 3), (0.0, 0.00030003, 0.04810481, 0.93159316, 0.0, 0.020002))
        pgm_function106.set_cpd((1, 3), (0.0, 0.00010001, 0.0270027, 0.95289529, 0.0, 0.020002))
        pgm_function106.set_cpd((2, 3), (0.0, 0.0, 0.0091, 0.9709, 0.0, 0.02))
        pgm_function106.set_cpd((3, 3), (0.0, 0.0001, 0.0087, 0.9712, 0.0, 0.02))
        pgm_function106.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function106.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function106.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function106.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function106.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function106.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function106.set_cpd((0, 5), (0.1427, 0.2958, 0.4254, 0.1161, 0.0, 0.02))
        pgm_function106.set_cpd((1, 5), (0.1157, 0.2677, 0.4444, 0.1522, 0.0, 0.02))
        pgm_function106.set_cpd((2, 5), (0.06939306, 0.20107989, 0.45265473, 0.25687431, 0.0, 0.019998))
        pgm_function106.set_cpd((3, 5), (0.0173, 0.0696, 0.2854, 0.6077, 0.0, 0.02))
        pgm_function106.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_factor107 = self.new_factor(R_APB_ALLAMP_WA, R_APB_EFFMUS, R_APB_MULOSS)
        pgm_function107 = pgm_factor107.set_cpt()
        pgm_function107.set_cpd((0, 0),
                                (0.00260026, 0.36873687, 0.60756076, 0.02080208, 0.00030003, 0.0, 0.0, 0.0, 0.0))
        pgm_function107.set_cpd((1, 0), (0.0, 0.0002, 0.4149, 0.4809, 0.0802, 0.0218, 0.002, 0.0, 0.0))
        pgm_function107.set_cpd((2, 0), (0.0, 0.0, 0.0, 0.0, 0.0215, 0.9785, 0.0, 0.0, 0.0))
        pgm_function107.set_cpd((3, 0), (0.0, 0.0, 0.0, 0.0, 0.0018, 0.0536, 0.8696, 0.075, 0.0))
        pgm_function107.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0736, 0.8528, 0.0736))
        pgm_function107.set_cpd((5, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.0794, 0.9205))
        pgm_function107.set_cpd((6, 0), (0.0003, 0.006, 0.105, 0.205, 0.1633, 0.141, 0.1771, 0.1279, 0.0744))
        pgm_function107.set_cpd((0, 1), (0.0409, 0.8924, 0.0661, 0.0006, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function107.set_cpd((1, 1), (0.0, 0.01, 0.77, 0.2049, 0.0128, 0.0022, 0.0001, 0.0, 0.0))
        pgm_function107.set_cpd((2, 1), (0.0, 0.0, 0.0, 0.2489, 0.7398, 0.0113, 0.0, 0.0, 0.0))
        pgm_function107.set_cpd((3, 1),
                                (0.0, 0.0, 0.0, 0.00420042, 0.34683468, 0.53485349, 0.11371137, 0.00040004, 0.0))
        pgm_function107.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 0.0064, 0.0855, 0.788, 0.1197, 0.0004))
        pgm_function107.set_cpd((5, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.00029997, 0.11648835, 0.76672333, 0.11648835))
        pgm_function107.set_cpd((6, 1), (
            0.00190019, 0.0230023, 0.190019, 0.26232623, 0.16291629, 0.12441244, 0.12641264, 0.0740074, 0.0350035))
        pgm_function107.set_cpd((0, 2), (0.2926, 0.7043, 0.0031, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function107.set_cpd((1, 2), (0.0091, 0.4203, 0.5312, 0.038, 0.0012, 0.0002, 0.0, 0.0, 0.0))
        pgm_function107.set_cpd((2, 2), (0.0, 0.0, 0.30946905, 0.68073193, 0.00949905, 0.00029997, 0.0, 0.0, 0.0))
        pgm_function107.set_cpd((3, 2), (0.0, 0.0, 0.018, 0.6298, 0.2744, 0.0746, 0.0032, 0.0, 0.0))
        pgm_function107.set_cpd((4, 2),
                                (0.0, 0.0, 0.00010001, 0.10461046, 0.42814281, 0.35683568, 0.10711071, 0.00320032, 0.0))
        pgm_function107.set_cpd((5, 2),
                                (0.0, 0.0, 0.0, 0.00250025, 0.09780978, 0.24982498, 0.53235324, 0.11411141, 0.00340034))
        pgm_function107.set_cpd((6, 2), (
            0.01440144, 0.09930993, 0.30283028, 0.27022702, 0.12431243, 0.08210821, 0.06520652, 0.03020302, 0.01140114))
        pgm_function107.set_cpd((0, 3), (0.781, 0.2189, 0.0001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function107.set_cpd((1, 3), (0.26692669, 0.71617162, 0.01660166, 0.00030003, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function107.set_cpd((2, 3), (9.999e-05, 0.10278972, 0.87921208, 0.01779822, 9.999e-05, 0.0, 0.0, 0.0, 0.0))
        pgm_function107.set_cpd((3, 3),
                                (0.0, 0.00440044, 0.81118112, 0.17621762, 0.00730073, 0.00090009, 0.0, 0.0, 0.0))
        pgm_function107.set_cpd((4, 3),
                                (0.0, 9.999e-05, 0.4129587, 0.49655034, 0.07189281, 0.01729827, 0.00119988, 0.0, 0.0))
        pgm_function107.set_cpd((5, 3),
                                (0.0, 0.0, 0.07810781, 0.51965197, 0.2610261, 0.11671167, 0.02340234, 0.00110011, 0.0))
        pgm_function107.set_cpd((6, 3), (0.1169, 0.3697, 0.2867, 0.1411, 0.0431, 0.0234, 0.0133, 0.0045, 0.0013))
        pgm_function107.set_cpd((0, 4), (0.9907, 0.0093, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function107.set_cpd((1, 4), (0.9858, 0.0142, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function107.set_cpd((2, 4), (0.9865, 0.0135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function107.set_cpd((3, 4), (0.982, 0.018, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function107.set_cpd((4, 4), (0.9779, 0.0221, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function107.set_cpd((5, 4), (0.973, 0.027, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function107.set_cpd((6, 4), (0.9370063, 0.06289371, 9.999e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function107.set_cpd((0, 5), (
            0.35956404, 0.51474853, 0.09409059, 0.0239976, 0.00459954, 0.0019998, 0.00079992, 0.00019998, 0.0))
        pgm_function107.set_cpd((1, 5), (
            0.13358664, 0.38546145, 0.26977302, 0.13078692, 0.04009599, 0.02189781, 0.01269873, 0.00439956, 0.00129987))
        pgm_function107.set_cpd((2, 5), (0.0096, 0.0788, 0.2992, 0.2816, 0.1319, 0.0873, 0.0689, 0.0313, 0.0114))
        pgm_function107.set_cpd((3, 5), (
            0.00260052, 0.02890578, 0.20404081, 0.26575315, 0.15943189, 0.11992398, 0.1190238, 0.06841368, 0.03190638))
        pgm_function107.set_cpd((4, 5), (
            0.00049995, 0.00839916, 0.11818818, 0.21387861, 0.1629837, 0.13818618, 0.16908309, 0.11988801, 0.06889311))
        pgm_function107.set_cpd((5, 5), (0.0001, 0.0021, 0.0586, 0.1473, 0.1427, 0.1363, 0.2057, 0.1798, 0.1274))
        pgm_function107.set_cpd((6, 5), (
            0.05210521, 0.16081608, 0.22722272, 0.20132013, 0.10661066, 0.07920792, 0.08310831, 0.05590559, 0.03370337))
        pgm_factor108 = self.new_factor(R_MED_AMP_WA, R_APB_ALLAMP_WA)
        pgm_function108 = pgm_factor108.set_cpt()
        pgm_function108.set_cpd((0,),
                                (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function108.set_cpd((1,), (
            0.00030003, 0.2850285, 0.23462346, 0.17811781, 0.12451245, 0.08030803, 0.04760476, 0.02610261, 0.01320132,
            0.00610061, 0.00260026, 0.0010001, 0.00040004, 0.00010001, 0.0, 0.0, 0.0))
        pgm_function108.set_cpd((2,), (
            0.0, 0.01350135, 0.03690369, 0.07940794, 0.13531353, 0.18181818, 0.19321932, 0.16221622, 0.10771077,
            0.05640564,
            0.02340234, 0.00760076, 0.0020002, 0.00040004, 0.00010001, 0.0, 0.0))
        pgm_function108.set_cpd((3,), (
            0.0, 0.0, 9.999e-05, 0.00059994, 0.00359964, 0.01649835, 0.05349465, 0.12328767, 0.20127987, 0.23347665,
            0.19218078, 0.11208879, 0.04649535, 0.01369863, 0.00279972, 0.00039996, 0.0))
        pgm_function108.set_cpd((4,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.00010001, 0.0010001, 0.00690069, 0.03090309, 0.09260926, 0.18551855, 0.24962496,
            0.2250225, 0.13581358, 0.05490549, 0.01490149, 0.00270027))
        pgm_function108.set_cpd((5,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00030003, 0.00310031, 0.0190019, 0.07230723, 0.17361736, 0.26222622,
            0.24972497, 0.14971497, 0.05670567, 0.01330133))
        pgm_function108.set_cpd((6,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0002, 0.0017, 0.0093, 0.0355, 0.0964, 0.186, 0.2545, 0.2471,
            0.1693))
        pgm_function108.set_cpd((7,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0004, 0.0029, 0.0155, 0.0599, 0.1641, 0.3182, 0.439))
        pgm_function108.set_cpd((8,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00010001, 0.00150015, 0.01150115, 0.06310631,
            0.24452445, 0.67926793))
        pgm_factor109 = self.new_factor(R_MED_LD_WA, R_LNLW_MED_SEV, R_LNLW_MED_PATHO)
        pgm_function109 = pgm_factor109.set_cpt()
        pgm_function109.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function109.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function109.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function109.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function109.set_cpd((4, 0), (0.25, 0.25, 0.25, 0.25))
        pgm_function109.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function109.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0))
        pgm_function109.set_cpd((2, 1), (0.25, 0.5, 0.25, 0.0))
        pgm_function109.set_cpd((3, 1), (0.05, 0.3, 0.5, 0.15))
        pgm_function109.set_cpd((4, 1), (0.25, 0.25, 0.25, 0.25))
        pgm_function109.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function109.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function109.set_cpd((2, 2), (0.5, 0.5, 0.0, 0.0))
        pgm_function109.set_cpd((3, 2), (0.0, 1.0, 0.0, 0.0))
        pgm_function109.set_cpd((4, 2), (0.25, 0.25, 0.25, 0.25))
        pgm_function109.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function109.set_cpd((1, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function109.set_cpd((2, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function109.set_cpd((3, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function109.set_cpd((4, 3), (0.25, 0.25, 0.25, 0.25))
        pgm_function109.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function109.set_cpd((1, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function109.set_cpd((2, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function109.set_cpd((3, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function109.set_cpd((4, 4), (0.25, 0.25, 0.25, 0.25))
        pgm_factor110 = self.new_factor(R_MED_RD_WA, R_LNLW_MED_PATHO)
        pgm_function110 = pgm_factor110.set_cpt()
        pgm_function110.set_cpd((0,), (1.0, 0.0, 0.0))
        pgm_function110.set_cpd((1,), (1.0, 0.0, 0.0))
        pgm_function110.set_cpd((2,), (1.0, 0.0, 0.0))
        pgm_function110.set_cpd((3,), (0.0, 0.0, 1.0))
        pgm_function110.set_cpd((4,), (0.0, 1.0, 0.0))
        pgm_factor111 = self.new_factor(R_MED_RDLDDEL, R_MED_LD_WA, R_MED_RD_WA)
        pgm_function111 = pgm_factor111.set_cpt()
        pgm_function111.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function111.set_cpd((1, 0), (0.0964, 0.7981, 0.1055, 0.0, 0.0))
        pgm_function111.set_cpd((2, 0), (0.0032, 0.127, 0.8698, 0.0, 0.0))
        pgm_function111.set_cpd((3, 0), (0.00090009, 0.00280028, 0.01470147, 0.98159816, 0.0))
        pgm_function111.set_cpd((0, 1), (0.0019, 0.5257, 0.4724, 0.0, 0.0))
        pgm_function111.set_cpd((1, 1), (0.00019998, 0.04149585, 0.95830417, 0.0, 0.0))
        pgm_function111.set_cpd((2, 1), (0.0001, 0.0144, 0.9855, 0.0, 0.0))
        pgm_function111.set_cpd((3, 1), (0.00019998, 0.00059994, 0.00369963, 0.99550045, 0.0))
        pgm_function111.set_cpd((0, 2), (0.0002, 0.0304, 0.9694, 0.0, 0.0))
        pgm_function111.set_cpd((1, 2), (0.0001, 0.0142, 0.9857, 0.0, 0.0))
        pgm_function111.set_cpd((2, 2), (0.0, 0.009, 0.9808, 0.0102, 0.0))
        pgm_function111.set_cpd((3, 2), (0.0, 0.0002, 0.0012, 0.9984, 0.0002))
        pgm_factor112 = self.new_factor(R_LNLBE_MED_DIFSLOW)
        pgm_function112 = pgm_factor112.set_cpt()
        pgm_function112.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor113 = self.new_factor(R_MED_DIFSLOW_WA, R_LNLBE_MED_DIFSLOW, R_DIFFN_MED_DIFSLOW)
        pgm_function113 = pgm_factor113.set_cpt()
        pgm_function113.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function113.set_cpd((1, 0), (0.01319868, 0.98620138, 0.00059994, 0.0))
        pgm_function113.set_cpd((2, 0), (0.0, 0.01810181, 0.98189819, 0.0))
        pgm_function113.set_cpd((3, 0), (0.0, 0.0003, 0.0252, 0.9745))
        pgm_function113.set_cpd((0, 1), (0.01319868, 0.98620138, 0.00059994, 0.0))
        pgm_function113.set_cpd((1, 1), (0.0001, 0.0952, 0.9047, 0.0))
        pgm_function113.set_cpd((2, 1), (0.0, 0.0009, 0.588, 0.4111))
        pgm_function113.set_cpd((3, 1), (0.0, 0.0, 0.00440044, 0.99559956))
        pgm_function113.set_cpd((0, 2), (0.0, 0.01810181, 0.98189819, 0.0))
        pgm_function113.set_cpd((1, 2), (0.0, 0.0009, 0.588, 0.4111))
        pgm_function113.set_cpd((2, 2), (0.0, 0.0, 0.002, 0.998))
        pgm_function113.set_cpd((3, 2), (0.0, 0.0, 0.0006, 0.9994))
        pgm_function113.set_cpd((0, 3), (0.0, 0.0003, 0.0252, 0.9745))
        pgm_function113.set_cpd((1, 3), (0.0, 0.0, 0.00440044, 0.99559956))
        pgm_function113.set_cpd((2, 3), (0.0, 0.0, 0.0006, 0.9994))
        pgm_function113.set_cpd((3, 3), (0.0, 0.0, 0.0005, 0.9995))
        pgm_factor114 = self.new_factor(R_MED_DCV_WA, R_APB_MALOSS, R_MED_DIFSLOW_WA)
        pgm_function114 = pgm_factor114.set_cpt()
        pgm_function114.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function114.set_cpd((1, 0), (0.1136, 0.8864, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function114.set_cpd((2, 0), (0.0006, 0.0764, 0.8866, 0.0364, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function114.set_cpd((3, 0), (0.0, 0.0, 0.0655, 0.9299, 0.0046, 0.0, 0.0, 0.0, 0.0))
        pgm_function114.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function114.set_cpd((5, 0), (0.1523, 0.2904, 0.3678, 0.1726, 0.0169, 0.0, 0.0, 0.0, 0.0))
        pgm_function114.set_cpd((0, 1), (0.008, 0.168, 0.7407, 0.0833, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function114.set_cpd((1, 1),
                                (0.00089991, 0.03679632, 0.55764424, 0.40245975, 0.00219978, 0.0, 0.0, 0.0, 0.0))
        pgm_function114.set_cpd((2, 1),
                                (0.0, 0.00070007, 0.05250525, 0.57125713, 0.37523752, 0.00030003, 0.0, 0.0, 0.0))
        pgm_function114.set_cpd((3, 1), (0.0, 0.0, 0.0007, 0.0745, 0.8859, 0.0389, 0.0, 0.0, 0.0))
        pgm_function114.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function114.set_cpd((5, 1), (0.0168, 0.0618, 0.2223, 0.4015, 0.2803, 0.0172, 0.0001, 0.0, 0.0))
        pgm_function114.set_cpd((0, 2), (
            0.00069986, 0.00589882, 0.0614877, 0.30063987, 0.55258949, 0.07818436, 0.0004999, 0.0, 0.0))
        pgm_function114.set_cpd((1, 2), (0.0002, 0.0018, 0.0263, 0.1887, 0.5884, 0.1916, 0.003, 0.0, 0.0))
        pgm_function114.set_cpd((2, 2), (0.0, 0.0001, 0.0024, 0.0358, 0.316, 0.5741, 0.0716, 0.0, 0.0))
        pgm_function114.set_cpd((3, 2),
                                (0.0, 0.0, 9.999e-05, 0.00319968, 0.07809219, 0.59464054, 0.32356764, 0.00039996, 0.0))
        pgm_function114.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function114.set_cpd((5, 2), (
            0.0009999, 0.00469953, 0.0279972, 0.11838816, 0.36466353, 0.39226077, 0.09069093, 0.00029997, 0.0))
        pgm_function114.set_cpd((0, 3), (0.0001, 0.0003, 0.0018, 0.011, 0.067, 0.2945, 0.5047, 0.1206, 0.0))
        pgm_function114.set_cpd((1, 3), (
            0.0, 0.00010001, 0.00090009, 0.00590059, 0.04220422, 0.23562356, 0.52255226, 0.19271927, 0.0))
        pgm_function114.set_cpd((2, 3), (0.0, 0.0, 0.0001, 0.0012, 0.0121, 0.1131, 0.4415, 0.432, 0.0))
        pgm_function114.set_cpd((3, 3),
                                (0.0, 0.0, 0.0, 0.00020002, 0.00280028, 0.04390439, 0.29172917, 0.66136614, 0.0))
        pgm_function114.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function114.set_cpd((5, 3), (0.0, 0.0002, 0.0011, 0.0057, 0.0332, 0.1704, 0.4424, 0.347, 0.0))
        pgm_factor115 = self.new_factor(R_MED_ALLDEL_WA, R_MED_RDLDDEL, R_MED_DCV_WA)
        pgm_function115 = pgm_factor115.set_cpt()
        pgm_function115.set_cpd((0, 0), (0.9996, 0.0004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function115.set_cpd((1, 0), (0.05119488, 0.22907709, 0.56624338, 0.15348465, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function115.set_cpd((2, 0), (0.0001, 0.0035, 0.0632, 0.9326, 0.0006, 0.0, 0.0, 0.0, 0.0))
        pgm_function115.set_cpd((3, 0), (
            0.00129987, 0.0019998, 0.00439956, 0.01869813, 0.12128787, 0.74792521, 0.10438956, 0.0, 0.0))
        pgm_function115.set_cpd((4, 0), (
            0.00010001, 0.00010001, 0.00030003, 0.00090009, 0.00450045, 0.04340434, 0.57675768, 0.37393739, 0.0))
        pgm_function115.set_cpd((0, 1), (0.5607, 0.4393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function115.set_cpd((1, 1), (0.01929807, 0.12868713, 0.49285071, 0.35916408, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function115.set_cpd((2, 1), (0.0, 0.0011, 0.0283, 0.9651, 0.0055, 0.0, 0.0, 0.0, 0.0))
        pgm_function115.set_cpd((3, 1), (
            0.0010001, 0.00160016, 0.00370037, 0.01610161, 0.10931093, 0.74217422, 0.12611261, 0.0, 0.0))
        pgm_function115.set_cpd((4, 1), (0.0001, 0.0001, 0.0002, 0.0008, 0.0041, 0.0399, 0.5568, 0.398, 0.0))
        pgm_function115.set_cpd((0, 2), (0.0069, 0.7963, 0.1968, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function115.set_cpd((1, 2), (0.0027, 0.0328, 0.2398, 0.7246, 0.0001, 0.0, 0.0, 0.0, 0.0))
        pgm_function115.set_cpd((2, 2), (0.0, 0.0002, 0.0075, 0.8889, 0.1034, 0.0, 0.0, 0.0, 0.0))
        pgm_function115.set_cpd((3, 2), (
            0.00079992, 0.00119988, 0.00279972, 0.01249875, 0.09159084, 0.72352765, 0.16758324, 0.0, 0.0))
        pgm_function115.set_cpd((4, 2), (0.0001, 0.0001, 0.0002, 0.0007, 0.0034, 0.0348, 0.5239, 0.4368, 0.0))
        pgm_function115.set_cpd((0, 3), (0.0, 0.0184, 0.9806, 0.001, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function115.set_cpd((1, 3),
                                (0.00010001, 0.00330033, 0.05470547, 0.93819382, 0.00370037, 0.0, 0.0, 0.0, 0.0))
        pgm_function115.set_cpd((2, 3), (0.0, 0.0, 0.00030003, 0.1850185, 0.81468147, 0.0, 0.0, 0.0, 0.0))
        pgm_function115.set_cpd((3, 3), (
            0.00049995, 0.00079992, 0.00179982, 0.00869913, 0.07029297, 0.68023198, 0.23767623, 0.0, 0.0))
        pgm_function115.set_cpd((4, 3), (0.0001, 0.0001, 0.0001, 0.0005, 0.0027, 0.0287, 0.4783, 0.4895, 0.0))
        pgm_function115.set_cpd((0, 4), (0.0, 0.0001, 0.0179, 0.982, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function115.set_cpd((1, 4), (0.0, 0.00019998, 0.00479952, 0.50394961, 0.49105089, 0.0, 0.0, 0.0, 0.0))
        pgm_function115.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0032, 0.9968, 0.0, 0.0, 0.0, 0.0))
        pgm_function115.set_cpd((3, 4), (0.0002, 0.0004, 0.0009, 0.0047, 0.044, 0.5737, 0.3761, 0.0, 0.0))
        pgm_function115.set_cpd((4, 4),
                                (0.0, 0.0, 0.00010001, 0.00030003, 0.00180018, 0.0210021, 0.40724072, 0.56955696, 0.0))
        pgm_function115.set_cpd((0, 5), (0.0, 0.0002, 0.003, 0.1393, 0.8575, 0.0, 0.0, 0.0, 0.0))
        pgm_function115.set_cpd((1, 5), (0.0, 0.0, 0.0003, 0.0188, 0.9804, 0.0005, 0.0, 0.0, 0.0))
        pgm_function115.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.00150015, 0.93139314, 0.06710671, 0.0, 0.0, 0.0))
        pgm_function115.set_cpd((3, 5), (0.0001, 0.0001, 0.0002, 0.0013, 0.015, 0.3152, 0.6681, 0.0, 0.0))
        pgm_function115.set_cpd((4, 5),
                                (0.0, 0.0, 0.0, 0.00010002, 0.00080016, 0.01110222, 0.28045609, 0.70754151, 0.0))
        pgm_function115.set_cpd((0, 6), (0.0, 0.0, 0.0, 0.0006, 0.8145, 0.1849, 0.0, 0.0, 0.0))
        pgm_function115.set_cpd((1, 6), (0.0, 0.0, 0.0, 0.0, 0.0494, 0.9506, 0.0, 0.0, 0.0))
        pgm_function115.set_cpd((2, 6), (0.0, 0.0, 0.0, 0.0, 0.001, 0.999, 0.0, 0.0, 0.0))
        pgm_function115.set_cpd((3, 6), (0.0, 0.0, 0.0, 0.0001, 0.0017, 0.0786, 0.9196, 0.0, 0.0))
        pgm_function115.set_cpd((4, 6), (0.0, 0.0, 0.0, 0.0, 0.0002, 0.0035, 0.138, 0.8583, 0.0))
        pgm_function115.set_cpd((0, 7), (0.0, 0.0, 0.0, 0.00040004, 0.01130113, 0.59735974, 0.39093909, 0.0, 0.0))
        pgm_function115.set_cpd((1, 7), (0.0, 0.0, 0.0, 0.00010001, 0.00340034, 0.2990299, 0.69746975, 0.0, 0.0))
        pgm_function115.set_cpd((2, 7), (0.0, 0.0, 0.0, 0.0, 0.0007, 0.1112, 0.8881, 0.0, 0.0))
        pgm_function115.set_cpd((3, 7), (0.0, 0.0, 0.0, 0.0, 0.00010001, 0.00940094, 0.95939594, 0.03110311, 0.0))
        pgm_function115.set_cpd((4, 7), (0.0, 0.0, 0.0, 0.0, 0.0, 0.00030003, 0.02530253, 0.97439744, 0.0))
        pgm_function115.set_cpd((0, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function115.set_cpd((1, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function115.set_cpd((2, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function115.set_cpd((3, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function115.set_cpd((4, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor116 = self.new_factor(R_MED_LAT_WA, R_MED_ALLDEL_WA)
        pgm_function116 = pgm_factor116.set_cpt()
        pgm_function116.set_cpd((0,), (
            0.00590059, 0.13261326, 0.50325033, 0.32263226, 0.0350035, 0.00060006, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0,
            0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function116.set_cpd((1,), (
            0.00069993, 0.01959804, 0.1689831, 0.42545745, 0.31276872, 0.06719328, 0.00529947, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function116.set_cpd((2,), (
            0.0, 0.0007, 0.0194, 0.1669, 0.4202, 0.3089, 0.0829, 0.001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0,
            0.0))
        pgm_function116.set_cpd((3,), (
            0.0, 0.0, 0.0010001, 0.01090109, 0.06350635, 0.19471947, 0.39343934, 0.29212921, 0.04280428, 0.00150015,
            0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function116.set_cpd((4,), (
            0.0001, 0.0003, 0.0011, 0.0034, 0.009, 0.021, 0.0528, 0.137, 0.2128, 0.2375, 0.1826, 0.1229, 0.0179, 0.0016,
            0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function116.set_cpd((5,), (
            9.999e-05, 0.00019998, 0.00039996, 0.00079992, 0.00139986, 0.00249975, 0.00509949, 0.0119988, 0.02149785,
            0.03539646, 0.08919108, 0.13978602, 0.18288171, 0.28117188, 0.1889811, 0.03589641, 0.00259974, 9.999e-05,
            0.0))
        pgm_function116.set_cpd((6,), (
            0.0002, 0.0002, 0.0003, 0.0004, 0.0005, 0.0007, 0.0012, 0.0022, 0.0032, 0.0047, 0.0109, 0.0176, 0.028,
            0.0629,
            0.1563, 0.2269, 0.2569, 0.2269, 0.0))
        pgm_function116.set_cpd((7,), (
            0.00079992, 0.00089991, 0.00109989, 0.00119988, 0.00139986, 0.00169983, 0.00249975, 0.00369963, 0.00459954,
            0.00559944, 0.01059894, 0.01559844, 0.02139786, 0.04329567, 0.10068993, 0.16488351, 0.25357464, 0.36646335,
            0.0))
        pgm_function116.set_cpd((8,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor117 = self.new_factor(R_APB_VOL_ACT)
        pgm_function117 = pgm_factor117.set_cpt()
        pgm_function117.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor118 = self.new_factor(R_APB_FORCE, R_APB_VOL_ACT, R_APB_ALLAMP_WA)
        pgm_function118 = pgm_factor118.set_cpt()
        pgm_function118.set_cpd((0, 0), (0.0, 0.0, 0.0, 0.00409959, 0.19078092, 0.80511949))
        pgm_function118.set_cpd((1, 0), (0.0, 0.0, 0.0, 0.001, 0.0578, 0.9412))
        pgm_function118.set_cpd((2, 0), (0.0, 0.0, 0.0, 9.999e-05, 0.01259874, 0.98730127))
        pgm_function118.set_cpd((3, 0), (0.0, 0.0, 0.0, 0.0, 0.00590059, 0.99409941))
        pgm_function118.set_cpd((0, 1), (0.00159984, 0.01859814, 0.09359064, 0.26787321, 0.36586341, 0.25247475))
        pgm_function118.set_cpd((1, 1), (0.0002, 0.0034, 0.026, 0.1312, 0.3333, 0.5059))
        pgm_function118.set_cpd((2, 1), (0.0, 0.0003, 0.0044, 0.0446, 0.2226, 0.7281))
        pgm_function118.set_cpd((3, 1), (0.0, 0.0, 0.0005, 0.0098, 0.1058, 0.8839))
        pgm_function118.set_cpd((0, 2), (0.01490149, 0.23542354, 0.53315332, 0.20152015, 0.01490149, 0.00010001))
        pgm_function118.set_cpd((1, 2), (0.0009, 0.0256, 0.18, 0.4308, 0.3036, 0.0591))
        pgm_function118.set_cpd((2, 2), (0.0, 0.0005, 0.0128, 0.1328, 0.4061, 0.4478))
        pgm_function118.set_cpd((3, 2), (0.0, 0.0, 0.0003, 0.0091, 0.1181, 0.8725))
        pgm_function118.set_cpd((0, 3), (0.1538, 0.6493, 0.1936, 0.0033, 0.0, 0.0))
        pgm_function118.set_cpd((1, 3), (0.0098, 0.1589, 0.4714, 0.3101, 0.0485, 0.0013))
        pgm_function118.set_cpd((2, 3), (0.0001, 0.0049, 0.0751, 0.3632, 0.429, 0.1277))
        pgm_function118.set_cpd((3, 3), (0.0, 0.0, 0.0008, 0.0215, 0.1873, 0.7904))
        pgm_function118.set_cpd((0, 4), (0.6667, 0.3291, 0.0042, 0.0, 0.0, 0.0))
        pgm_function118.set_cpd((1, 4), (0.05370537, 0.42044204, 0.45484548, 0.0690069, 0.0020002, 0.0))
        pgm_function118.set_cpd((2, 4), (0.00050005, 0.02730273, 0.24332433, 0.50135014, 0.21182118, 0.01570157))
        pgm_function118.set_cpd((3, 4), (0.0, 9.999e-05, 0.00249975, 0.04719528, 0.27557244, 0.67463254))
        pgm_function118.set_cpd((0, 5), (0.94689469, 0.05310531, 0.0, 0.0, 0.0, 0.0))
        pgm_function118.set_cpd((1, 5), (0.11731173, 0.56585659, 0.3010301, 0.01570157, 0.00010001, 0.0))
        pgm_function118.set_cpd((2, 5), (0.00120012, 0.06020602, 0.38623862, 0.45424542, 0.09540954, 0.00270027))
        pgm_function118.set_cpd((3, 5), (0.0, 0.0001, 0.0044, 0.0713, 0.3326, 0.5916))
        pgm_function118.set_cpd((0, 6), (0.9782, 0.0218, 0.0, 0.0, 0.0, 0.0))
        pgm_function118.set_cpd((1, 6), (0.41015898, 0.47935206, 0.1069893, 0.00349965, 0.0, 0.0))
        pgm_function118.set_cpd((2, 6), (0.02560256, 0.2470247, 0.48384838, 0.21742174, 0.02560256, 0.00050005))
        pgm_function118.set_cpd((3, 6), (0.0, 0.0020002, 0.02790279, 0.18121812, 0.41124112, 0.37763776))
        pgm_function118.set_cpd((0, 7), (0.9971, 0.0029, 0.0, 0.0, 0.0, 0.0))
        pgm_function118.set_cpd((1, 7), (0.7017, 0.2755, 0.0226, 0.0002, 0.0, 0.0))
        pgm_function118.set_cpd((2, 7), (0.1171, 0.4443, 0.3699, 0.0654, 0.0033, 0.0))
        pgm_function118.set_cpd((3, 7), (0.0004, 0.0107, 0.0847, 0.3035, 0.3988, 0.2019))
        pgm_function118.set_cpd((0, 8), (0.9996, 0.0004, 0.0, 0.0, 0.0, 0.0))
        pgm_function118.set_cpd((1, 8), (0.8804, 0.1161, 0.0035, 0.0, 0.0, 0.0))
        pgm_function118.set_cpd((2, 8), (0.32706729, 0.4879512, 0.17268273, 0.0119988, 0.00029997, 0.0))
        pgm_function118.set_cpd((3, 8), (0.0030003, 0.04260426, 0.19481948, 0.38493849, 0.29292929, 0.08170817))
        pgm_factor119 = self.new_factor(R_APB_MUSCLE_VOL, R_APB_MUSIZE, R_APB_MALOSS)
        pgm_function119 = pgm_factor119.set_cpt()
        pgm_function119.set_cpd((0, 0), (0.9896, 0.0104))
        pgm_function119.set_cpd((1, 0), (0.8137, 0.1863))
        pgm_function119.set_cpd((2, 0), (0.0209, 0.9791))
        pgm_function119.set_cpd((3, 0), (0.009, 0.991))
        pgm_function119.set_cpd((4, 0), (0.003, 0.997))
        pgm_function119.set_cpd((5, 0), (0.0004, 0.9996))
        pgm_function119.set_cpd((6, 0), (0.4212, 0.5788))
        pgm_function119.set_cpd((0, 1), (0.9976, 0.0024))
        pgm_function119.set_cpd((1, 1), (0.9603, 0.0397))
        pgm_function119.set_cpd((2, 1), (0.5185, 0.4815))
        pgm_function119.set_cpd((3, 1), (0.1087, 0.8913))
        pgm_function119.set_cpd((4, 1), (0.0278, 0.9722))
        pgm_function119.set_cpd((5, 1), (0.0046, 0.9954))
        pgm_function119.set_cpd((6, 1), (0.5185, 0.4815))
        pgm_function119.set_cpd((0, 2), (0.999, 0.001))
        pgm_function119.set_cpd((1, 2), (0.9893, 0.0107))
        pgm_function119.set_cpd((2, 2), (0.9588, 0.0412))
        pgm_function119.set_cpd((3, 2), (0.6377, 0.3623))
        pgm_function119.set_cpd((4, 2), (0.2716, 0.7284))
        pgm_function119.set_cpd((5, 2), (0.0779, 0.9221))
        pgm_function119.set_cpd((6, 2), (0.6336, 0.3664))
        pgm_function119.set_cpd((0, 3), (0.9995, 0.0005))
        pgm_function119.set_cpd((1, 3), (0.9969, 0.0031))
        pgm_function119.set_cpd((2, 3), (0.9953, 0.0047))
        pgm_function119.set_cpd((3, 3), (0.9518, 0.0482))
        pgm_function119.set_cpd((4, 3), (0.8234, 0.1766))
        pgm_function119.set_cpd((5, 3), (0.5986, 0.4014))
        pgm_function119.set_cpd((6, 3), (0.7685, 0.2315))
        pgm_function119.set_cpd((0, 4), (0.9989, 0.0011))
        pgm_function119.set_cpd((1, 4), (0.9984, 0.0016))
        pgm_function119.set_cpd((2, 4), (0.9984, 0.0016))
        pgm_function119.set_cpd((3, 4), (0.9975, 0.0025))
        pgm_function119.set_cpd((4, 4), (0.9965, 0.0035))
        pgm_function119.set_cpd((5, 4), (0.9956, 0.0044))
        pgm_function119.set_cpd((6, 4), (0.9857, 0.0143))
        pgm_function119.set_cpd((0, 5), (0.9363, 0.0637))
        pgm_function119.set_cpd((1, 5), (0.8403, 0.1597))
        pgm_function119.set_cpd((2, 5), (0.6534, 0.3466))
        pgm_function119.set_cpd((3, 5), (0.4689, 0.5311))
        pgm_function119.set_cpd((4, 5), (0.3174, 0.6826))
        pgm_function119.set_cpd((5, 5), (0.1948, 0.8052))
        pgm_function119.set_cpd((6, 5), (0.5681, 0.4319))
        pgm_factor120 = self.new_factor(R_APB_MVA_RECRUIT, R_APB_MULOSS, R_APB_VOL_ACT)
        pgm_function120 = pgm_factor120.set_cpt()
        pgm_function120.set_cpd((0, 0), (0.9295, 0.0705, 0.0, 0.0))
        pgm_function120.set_cpd((1, 0), (0.4821, 0.5165, 0.0014, 0.0))
        pgm_function120.set_cpd((2, 0), (0.0661, 0.7993, 0.1346, 0.0))
        pgm_function120.set_cpd((3, 0), (0.00149985, 0.13658634, 0.86191381, 0.0))
        pgm_function120.set_cpd((4, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function120.set_cpd((5, 0), (0.2639736, 0.4343566, 0.3016698, 0.0))
        pgm_function120.set_cpd((0, 1), (0.1707, 0.7, 0.1293, 0.0))
        pgm_function120.set_cpd((1, 1), (0.0366, 0.5168, 0.4466, 0.0))
        pgm_function120.set_cpd((2, 1), (0.0043, 0.1788, 0.8169, 0.0))
        pgm_function120.set_cpd((3, 1), (0.00029997, 0.03479652, 0.96490351, 0.0))
        pgm_function120.set_cpd((4, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function120.set_cpd((5, 1), (0.1146, 0.3465, 0.5389, 0.0))
        pgm_function120.set_cpd((0, 2), (0.0038, 0.174, 0.8222, 0.0))
        pgm_function120.set_cpd((1, 2), (0.0005, 0.0594, 0.9401, 0.0))
        pgm_function120.set_cpd((2, 2), (0.0001, 0.0205, 0.9794, 0.0))
        pgm_function120.set_cpd((3, 2), (0.0, 0.0061, 0.9939, 0.0))
        pgm_function120.set_cpd((4, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function120.set_cpd((5, 2), (0.036, 0.2144, 0.7496, 0.0))
        pgm_function120.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function120.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function120.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function120.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function120.set_cpd((4, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function120.set_cpd((5, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor121 = self.new_factor(R_APB_MVA_AMP, R_APB_EFFMUS)
        pgm_function121 = pgm_factor121.set_cpt()
        pgm_function121.set_cpd((0,), (0.0, 0.04, 0.96))
        pgm_function121.set_cpd((1,), (0.01, 0.15, 0.84))
        pgm_function121.set_cpd((2,), (0.05, 0.9, 0.05))
        pgm_function121.set_cpd((3,), (0.5, 0.49, 0.01))
        pgm_function121.set_cpd((4,), (0.85, 0.15, 0.0))
        pgm_function121.set_cpd((5,), (0.96, 0.04, 0.0))
        pgm_function121.set_cpd((6,), (0.33, 0.34, 0.33))
        pgm_factor122 = self.new_factor(R_APB_TA_CONCL, R_APB_EFFMUS)
        pgm_function122 = pgm_factor122.set_cpt()
        pgm_function122.set_cpd((0,), (0.0, 0.0, 0.005, 0.045, 0.95))
        pgm_function122.set_cpd((1,), (0.0, 0.0, 0.05, 0.9, 0.05))
        pgm_function122.set_cpd((2,), (0.0, 0.03, 0.94, 0.03, 0.0))
        pgm_function122.set_cpd((3,), (0.195, 0.6, 0.2, 0.005, 0.0))
        pgm_function122.set_cpd((4,), (0.48, 0.5, 0.02, 0.0, 0.0))
        pgm_function122.set_cpd((5,), (0.8, 0.195, 0.005, 0.0, 0.0))
        pgm_function122.set_cpd((6,), (0.2, 0.2, 0.2, 0.2, 0.2))
        pgm_factor123 = self.new_factor(R_APB_MUPAMP, R_APB_EFFMUS)
        pgm_function123 = pgm_factor123.set_cpt()
        pgm_function123.set_cpd((0,), (0.782, 0.195, 0.003, 0.0, 0.0, 0.0, 0.02))
        pgm_function123.set_cpd((1,), (0.10431043, 0.77107711, 0.10431043, 0.00030003, 0.0, 0.0, 0.020002))
        pgm_function123.set_cpd((2,), (0.0, 0.0, 0.98, 0.0, 0.0, 0.0, 0.02))
        pgm_function123.set_cpd((3,), (0.0, 0.00029997, 0.10108989, 0.74712529, 0.13148685, 0.0, 0.019998))
        pgm_function123.set_cpd((4,), (0.0, 0.0, 0.0024, 0.1528, 0.7968, 0.028, 0.02))
        pgm_function123.set_cpd((5,), (0.0, 0.0, 0.0, 0.0028, 0.0968, 0.8804, 0.02))
        pgm_function123.set_cpd((6,), (0.1328, 0.1932, 0.2189, 0.1932, 0.1726, 0.0693, 0.02))
        pgm_factor124 = self.new_factor(R_APB_QUAN_MUPAMP, R_APB_MUPAMP)
        pgm_function124 = pgm_factor124.set_cpt()
        pgm_function124.set_cpd((0,), (
            0.00080024, 0.00370111, 0.01350405, 0.03811143, 0.08352506, 0.14254276, 0.18955687, 0.19635891, 0.1583475,
            0.09942983, 0.04861458, 0.01850555, 0.00550165, 0.00130039, 0.00020006, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function124.set_cpd((1,), (
            0.0, 0.00010002, 0.00080016, 0.00370074, 0.0135027, 0.03810762, 0.0835167, 0.14252851, 0.18953791,
            0.19633927,
            0.15833167, 0.09941988, 0.04860972, 0.0185037, 0.0055011, 0.00130026, 0.00020004, 0.0, 0.0, 0.0))
        pgm_function124.set_cpd((2,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.00050005, 0.00370037, 0.01870187, 0.06390639, 0.14751475, 0.23022302, 0.24312431,
            0.17371737, 0.0840084, 0.02750275, 0.00610061, 0.00090009, 0.00010001, 0.0, 0.0))
        pgm_function124.set_cpd((3,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.0008, 0.0037, 0.0135, 0.0381, 0.0835, 0.1426, 0.1896, 0.1963, 0.1583,
            0.0995,
            0.0487, 0.0185, 0.0055, 0.0013))
        pgm_function124.set_cpd((4,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.0008, 0.0038, 0.0136, 0.0383, 0.0841, 0.1435, 0.1909, 0.1977,
            0.1594, 0.1001, 0.049, 0.0187))
        pgm_function124.set_cpd((5,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.0006, 0.0024, 0.0082, 0.0232, 0.0542, 0.1041, 0.1645,
            0.2137, 0.2283, 0.2007))
        pgm_function124.set_cpd((6,), (
            0.0045, 0.0078, 0.0127, 0.0197, 0.0289, 0.0403, 0.0531, 0.0664, 0.0787, 0.0883, 0.0939, 0.0946, 0.0903,
            0.0817,
            0.07, 0.0569, 0.0438, 0.0319, 0.0221, 0.0144))
        pgm_factor125 = self.new_factor(R_APB_QUAL_MUPAMP, R_APB_MUPAMP)
        pgm_function125 = pgm_factor125.set_cpt()
        pgm_function125.set_cpd((0,), (0.4289, 0.5209, 0.0499, 0.0003, 0.0))
        pgm_function125.set_cpd((1,), (0.0647, 0.5494, 0.3679, 0.018, 0.0))
        pgm_function125.set_cpd((2,), (0.0, 0.04790479, 0.87538754, 0.07670767, 0.0))
        pgm_function125.set_cpd((3,), (0.0, 0.00869913, 0.28377162, 0.67793221, 0.02959704))
        pgm_function125.set_cpd((4,), (0.0, 0.0002, 0.0376, 0.6283, 0.3339))
        pgm_function125.set_cpd((5,), (0.0, 0.0, 0.001, 0.0788, 0.9202))
        pgm_function125.set_cpd((6,), (0.096, 0.1884, 0.283, 0.3014, 0.1312))
        pgm_factor126 = self.new_factor(R_APB_MUPDUR, R_APB_EFFMUS)
        pgm_function126 = pgm_factor126.set_cpt()
        pgm_function126.set_cpd((0,), (0.9388, 0.0412, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function126.set_cpd((1,), (0.0396, 0.9008, 0.0396, 0.0, 0.0, 0.0, 0.02))
        pgm_function126.set_cpd((2,), (0.0, 0.0, 0.98, 0.0, 0.0, 0.0, 0.02))
        pgm_function126.set_cpd((3,), (0.0, 0.0, 0.0396, 0.9008, 0.0396, 0.0, 0.02))
        pgm_function126.set_cpd((4,), (0.0, 0.0, 0.0, 0.0412, 0.938, 0.0008, 0.02))
        pgm_function126.set_cpd((5,), (0.0, 0.0, 0.0, 0.0039, 0.2546, 0.7215, 0.02))
        pgm_function126.set_cpd((6,), (0.09, 0.235, 0.3236, 0.235, 0.09, 0.0064, 0.02))
        pgm_factor127 = self.new_factor(R_APB_QUAN_MUPDUR, R_APB_MUPDUR)
        pgm_function127 = pgm_factor127.set_cpt()
        pgm_function127.set_cpd((0,), (
            0.09981996, 0.18333667, 0.24024805, 0.22454491, 0.14972995, 0.07121424, 0.02420484, 0.00580116, 0.0010002,
            0.00010002, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function127.set_cpd((1,), (
            0.01020102, 0.03690369, 0.09510951, 0.17471747, 0.22892289, 0.2140214, 0.14261426, 0.06780678, 0.0230023,
            0.00560056, 0.0010001, 0.00010001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function127.set_cpd((2,), (
            0.0, 0.0002, 0.0025, 0.0177, 0.0739, 0.1852, 0.2785, 0.2515, 0.1363, 0.0444, 0.0087, 0.001, 0.0001, 0.0,
            0.0,
            0.0, 0.0, 0.0, 0.0))
        pgm_function127.set_cpd((3,), (
            0.0, 0.0, 0.00029997, 0.0019998, 0.01019898, 0.03679632, 0.09489051, 0.17428257, 0.22837716, 0.21347865,
            0.14228577, 0.06769323, 0.0229977, 0.00559944, 0.0009999, 9.999e-05, 0.0, 0.0, 0.0))
        pgm_function127.set_cpd((4,), (
            0.0, 0.0, 0.0, 0.0, 0.00029997, 0.0019998, 0.01019898, 0.03679632, 0.09489051, 0.17428257, 0.22837716,
            0.21347865, 0.14228577, 0.06769323, 0.0229977, 0.00559944, 0.0009999, 9.999e-05, 0.0))
        pgm_function127.set_cpd((5,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 9.999e-05, 0.00039996, 0.00179982, 0.0069993, 0.02189781, 0.05409459, 0.10518948,
            0.16128387, 0.1949805, 0.1859814, 0.13988601, 0.08289171, 0.03879612, 0.00569943))
        pgm_function127.set_cpd((6,), (
            0.0201, 0.0341, 0.0529, 0.0748, 0.0966, 0.1138, 0.1224, 0.1202, 0.1078, 0.0882, 0.0658, 0.0449, 0.0279,
            0.0159,
            0.0082, 0.0039, 0.0017, 0.0007, 0.0001))
        pgm_factor128 = self.new_factor(R_APB_QUAL_MUPDUR, R_APB_MUPDUR)
        pgm_function128 = pgm_factor128.set_cpt()
        pgm_function128.set_cpd((0,), (0.8309, 0.1677, 0.0014))
        pgm_function128.set_cpd((1,), (0.49, 0.49, 0.02))
        pgm_function128.set_cpd((2,), (0.1065, 0.787, 0.1065))
        pgm_function128.set_cpd((3,), (0.02, 0.49, 0.49))
        pgm_function128.set_cpd((4,), (0.0014, 0.1677, 0.8309))
        pgm_function128.set_cpd((5,), (0.0001, 0.0392, 0.9607))
        pgm_function128.set_cpd((6,), (0.2597, 0.4806, 0.2597))
        pgm_factor129 = self.new_factor(R_APB_QUAN_MUPPOLY, R_APB_DE_REGEN, R_APB_EFFMUS)
        pgm_function129 = pgm_factor129.set_cpt()
        pgm_function129.set_cpd((0, 0), (0.109, 0.548, 0.343))
        pgm_function129.set_cpd((1, 0), (0.004, 0.122, 0.874))
        pgm_function129.set_cpd((0, 1), (0.34, 0.564, 0.096))
        pgm_function129.set_cpd((1, 1), (0.015, 0.261, 0.724))
        pgm_function129.set_cpd((0, 2), (0.925, 0.075, 0.0))
        pgm_function129.set_cpd((1, 2), (0.091, 0.526, 0.383))
        pgm_function129.set_cpd((0, 3), (0.796, 0.201, 0.003))
        pgm_function129.set_cpd((1, 3), (0.061, 0.465, 0.474))
        pgm_function129.set_cpd((0, 4), (0.637, 0.348, 0.015))
        pgm_function129.set_cpd((1, 4), (0.039, 0.396, 0.565))
        pgm_function129.set_cpd((0, 5), (0.34, 0.564, 0.096))
        pgm_function129.set_cpd((1, 5), (0.015, 0.261, 0.724))
        pgm_function129.set_cpd((0, 6), (0.34, 0.564, 0.096))
        pgm_function129.set_cpd((1, 6), (0.015, 0.261, 0.724))
        pgm_factor130 = self.new_factor(R_APB_QUAL_MUPPOLY, R_APB_QUAN_MUPPOLY)
        pgm_function130 = pgm_factor130.set_cpt()
        pgm_function130.set_cpd((0,), (0.95, 0.05))
        pgm_function130.set_cpd((1,), (0.3, 0.7))
        pgm_function130.set_cpd((2,), (0.05, 0.95))
        pgm_factor131 = self.new_factor(R_APB_MUPSATEL, R_APB_DE_REGEN)
        pgm_function131 = pgm_factor131.set_cpt()
        pgm_function131.set_cpd((0,), (0.95, 0.05))
        pgm_function131.set_cpd((1,), (0.2, 0.8))
        pgm_factor132 = self.new_factor(R_APB_MUPINSTAB, R_APB_NMT)
        pgm_function132 = pgm_factor132.set_cpt()
        pgm_function132.set_cpd((0,), (0.95, 0.05))
        pgm_function132.set_cpd((1,), (0.1, 0.9))
        pgm_function132.set_cpd((2,), (0.03, 0.97))
        pgm_function132.set_cpd((3,), (0.2, 0.8))
        pgm_function132.set_cpd((4,), (0.1, 0.9))
        pgm_function132.set_cpd((5,), (0.03, 0.97))
        pgm_function132.set_cpd((6,), (0.1, 0.9))
        pgm_factor133 = self.new_factor(R_APB_REPSTIM_CMAPAMP, R_APB_ALLAMP_WA)
        pgm_function133 = pgm_factor133.set_cpt()
        pgm_function133.set_cpd((0,), (
            1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function133.set_cpd((1,), (
            0.00130013, 0.11591159, 0.1280128, 0.1330133, 0.130013, 0.11941194, 0.10311031, 0.08380838, 0.06390639,
            0.04590459, 0.0310031, 0.01970197, 0.01170117, 0.00660066, 0.00350035, 0.00170017, 0.00080008, 0.00040004,
            0.00010001, 0.00010001, 0.0))
        pgm_function133.set_cpd((2,), (
            0.0, 0.00029997, 0.00129987, 0.00409959, 0.01119888, 0.02609739, 0.05159484, 0.08679132, 0.12468753,
            0.15248475,
            0.15888411, 0.14108589, 0.10678932, 0.06879312, 0.03779622, 0.01769823, 0.00709929, 0.00239976, 0.00069993,
            0.00019998, 0.0))
        pgm_function133.set_cpd((3,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 9.999e-05, 0.00069993, 0.00309969, 0.01109889, 0.03129687, 0.07039296, 0.12478752,
            0.17478252, 0.19348065, 0.16928307, 0.1169883, 0.0639936, 0.02759724, 0.00939906, 0.00249975, 0.00049995))
        pgm_function133.set_cpd((4,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00030003, 0.00210021, 0.01070107, 0.03860386, 0.0990099,
            0.17961796, 0.23162316, 0.21192119, 0.13751375, 0.06320632, 0.02070207, 0.00470047))
        pgm_function133.set_cpd((5,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00030003, 0.00310031, 0.0190019, 0.07230723,
            0.17361736, 0.26222622, 0.24972497, 0.14971497, 0.05670567, 0.01330133))
        pgm_function133.set_cpd((6,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.0007, 0.0037, 0.0151, 0.0464, 0.1065,
            0.1843,
            0.2393, 0.2335, 0.1704))
        pgm_function133.set_cpd((7,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00020002, 0.00110011, 0.00610061,
            0.02490249,
            0.07680768, 0.17791779, 0.30893089, 0.4040404))
        pgm_function133.set_cpd((8,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.0005, 0.0038, 0.0208, 0.086,
            0.2659, 0.6229))
        pgm_factor134 = self.new_factor(R_APB_REPSTIM_DECR, R_APB_NMT)
        pgm_function134 = pgm_factor134.set_cpt()
        pgm_function134.set_cpd((0,), (0.949, 0.02, 0.01, 0.001, 0.02))
        pgm_function134.set_cpd((1,), (0.04, 0.2, 0.7, 0.04, 0.02))
        pgm_function134.set_cpd((2,), (0.001, 0.01, 0.04, 0.929, 0.02))
        pgm_function134.set_cpd((3,), (0.35, 0.57, 0.05, 0.01, 0.02))
        pgm_function134.set_cpd((4,), (0.02, 0.1, 0.8, 0.06, 0.02))
        pgm_function134.set_cpd((5,), (0.001, 0.01, 0.04, 0.929, 0.02))
        pgm_function134.set_cpd((6,), (0.245, 0.245, 0.245, 0.245, 0.02))
        pgm_factor135 = self.new_factor(R_APB_REPSTIM_FACILI, R_APB_NMT)
        pgm_function135 = pgm_factor135.set_cpt()
        pgm_function135.set_cpd((0,), (0.95, 0.02, 0.01, 0.02))
        pgm_function135.set_cpd((1,), (0.01, 0.889, 0.1, 0.001))
        pgm_function135.set_cpd((2,), (0.01, 0.08, 0.909, 0.001))
        pgm_function135.set_cpd((3,), (0.89, 0.08, 0.01, 0.02))
        pgm_function135.set_cpd((4,), (0.48, 0.5, 0.01, 0.01))
        pgm_function135.set_cpd((5,), (0.02, 0.949, 0.03, 0.001))
        pgm_function135.set_cpd((6,), (0.25, 0.25, 0.25, 0.25))
        pgm_factor136 = self.new_factor(R_APB_REPSTIM_POST_DECR, R_APB_NMT)
        pgm_function136 = pgm_factor136.set_cpt()
        pgm_function136.set_cpd((0,), (0.949, 0.02, 0.01, 0.001, 0.02))
        pgm_function136.set_cpd((1,), (0.02, 0.1, 0.8, 0.06, 0.02))
        pgm_function136.set_cpd((2,), (0.001, 0.01, 0.02, 0.949, 0.02))
        pgm_function136.set_cpd((3,), (0.25, 0.61, 0.1, 0.02, 0.02))
        pgm_function136.set_cpd((4,), (0.01, 0.1, 0.8, 0.07, 0.02))
        pgm_function136.set_cpd((5,), (0.001, 0.01, 0.02, 0.949, 0.02))
        pgm_function136.set_cpd((6,), (0.23, 0.23, 0.22, 0.22, 0.1))
        pgm_factor137 = self.new_factor(R_APB_SF_JITTER, R_APB_NMT)
        pgm_function137 = pgm_factor137.set_cpt()
        pgm_function137.set_cpd((0,), (0.95, 0.05, 0.0, 0.0))
        pgm_function137.set_cpd((1,), (0.02, 0.2, 0.7, 0.08))
        pgm_function137.set_cpd((2,), (0.0, 0.1, 0.4, 0.5))
        pgm_function137.set_cpd((3,), (0.05, 0.7, 0.2, 0.05))
        pgm_function137.set_cpd((4,), (0.01, 0.19, 0.7, 0.1))
        pgm_function137.set_cpd((5,), (0.0, 0.1, 0.4, 0.5))
        pgm_function137.set_cpd((6,), (0.1, 0.3, 0.3, 0.3))
        pgm_factor138 = self.new_factor(R_LNLT1_APB_MUDENS)
        pgm_function138 = pgm_factor138.set_cpt()
        pgm_function138.set_cpd((), (1.0, 0.0, 0.0))
        pgm_factor139 = self.new_factor(R_LNLLP_APB_MUDENS)
        pgm_function139 = pgm_factor139.set_cpt()
        pgm_function139.set_cpd((), (1.0, 0.0, 0.0))
        pgm_factor140 = self.new_factor(R_LNLT1_LP_APB_MUDENS, R_LNLT1_APB_MUDENS, R_LNLLP_APB_MUDENS)
        pgm_function140 = pgm_factor140.set_cpt()
        pgm_function140.set_cpd((0, 0), (1.0, 0.0, 0.0))
        pgm_function140.set_cpd((1, 0), (0.0, 1.0, 0.0))
        pgm_function140.set_cpd((2, 0), (0.0, 0.0, 1.0))
        pgm_function140.set_cpd((0, 1), (0.0, 1.0, 0.0))
        pgm_function140.set_cpd((1, 1), (0.0, 0.0, 1.0))
        pgm_function140.set_cpd((2, 1), (0.0, 0.0, 1.0))
        pgm_function140.set_cpd((0, 2), (0.0, 0.0, 1.0))
        pgm_function140.set_cpd((1, 2), (0.0, 0.0, 1.0))
        pgm_function140.set_cpd((2, 2), (0.0, 0.0, 1.0))
        pgm_factor141 = self.new_factor(R_LNLBE_APB_MUDENS)
        pgm_function141 = pgm_factor141.set_cpt()
        pgm_function141.set_cpd((), (1.0, 0.0, 0.0))
        pgm_factor142 = self.new_factor(R_LNLT1_LP_BE_APB_MUDENS, R_LNLT1_LP_APB_MUDENS, R_LNLBE_APB_MUDENS)
        pgm_function142 = pgm_factor142.set_cpt()
        pgm_function142.set_cpd((0, 0), (1.0, 0.0, 0.0))
        pgm_function142.set_cpd((1, 0), (0.0, 1.0, 0.0))
        pgm_function142.set_cpd((2, 0), (0.0, 0.0, 1.0))
        pgm_function142.set_cpd((0, 1), (0.0, 1.0, 0.0))
        pgm_function142.set_cpd((1, 1), (0.0, 0.0, 1.0))
        pgm_function142.set_cpd((2, 1), (0.0, 0.0, 1.0))
        pgm_function142.set_cpd((0, 2), (0.0, 0.0, 1.0))
        pgm_function142.set_cpd((1, 2), (0.0, 0.0, 1.0))
        pgm_function142.set_cpd((2, 2), (0.0, 0.0, 1.0))
        pgm_factor143 = self.new_factor(R_DIFFN_APB_MUDENS, DIFFN_M_SEV_DIST, DIFFN_TIME, DIFFN_PATHO)
        pgm_function143 = pgm_factor143.set_cpt()
        pgm_function143.set_cpd((0, 0, 0), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((1, 0, 0), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((2, 0, 0), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((3, 0, 0), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((0, 1, 0), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((1, 1, 0), (0.9, 0.1, 0.0))
        pgm_function143.set_cpd((2, 1, 0), (0.8, 0.2, 0.0))
        pgm_function143.set_cpd((3, 1, 0), (0.6, 0.4, 0.0))
        pgm_function143.set_cpd((0, 2, 0), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((1, 2, 0), (0.8, 0.2, 0.0))
        pgm_function143.set_cpd((2, 2, 0), (0.7, 0.3, 0.0))
        pgm_function143.set_cpd((3, 2, 0), (0.6, 0.4, 0.0))
        pgm_function143.set_cpd((0, 3, 0), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((1, 3, 0), (0.8, 0.2, 0.0))
        pgm_function143.set_cpd((2, 3, 0), (0.7, 0.3, 0.0))
        pgm_function143.set_cpd((3, 3, 0), (0.6, 0.4, 0.0))
        pgm_function143.set_cpd((0, 0, 1), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((1, 0, 1), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((2, 0, 1), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((3, 0, 1), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((0, 1, 1), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((1, 1, 1), (0.9, 0.1, 0.0))
        pgm_function143.set_cpd((2, 1, 1), (0.8, 0.2, 0.0))
        pgm_function143.set_cpd((3, 1, 1), (0.6, 0.4, 0.0))
        pgm_function143.set_cpd((0, 2, 1), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((1, 2, 1), (0.8, 0.2, 0.0))
        pgm_function143.set_cpd((2, 2, 1), (0.7, 0.3, 0.0))
        pgm_function143.set_cpd((3, 2, 1), (0.6, 0.4, 0.0))
        pgm_function143.set_cpd((0, 3, 1), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((1, 3, 1), (0.8, 0.2, 0.0))
        pgm_function143.set_cpd((2, 3, 1), (0.7, 0.3, 0.0))
        pgm_function143.set_cpd((3, 3, 1), (0.6, 0.4, 0.0))
        pgm_function143.set_cpd((0, 0, 2), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((1, 0, 2), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((2, 0, 2), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((3, 0, 2), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((0, 1, 2), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((1, 1, 2), (0.6, 0.4, 0.0))
        pgm_function143.set_cpd((2, 1, 2), (0.5, 0.5, 0.0))
        pgm_function143.set_cpd((3, 1, 2), (0.5, 0.4, 0.1))
        pgm_function143.set_cpd((0, 2, 2), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((1, 2, 2), (0.7, 0.3, 0.0))
        pgm_function143.set_cpd((2, 2, 2), (0.1, 0.6, 0.3))
        pgm_function143.set_cpd((3, 2, 2), (0.0, 0.5, 0.5))
        pgm_function143.set_cpd((0, 3, 2), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((1, 3, 2), (0.5, 0.5, 0.0))
        pgm_function143.set_cpd((2, 3, 2), (0.15, 0.7, 0.15))
        pgm_function143.set_cpd((3, 3, 2), (0.0, 0.5, 0.5))
        pgm_function143.set_cpd((0, 0, 3), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((1, 0, 3), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((2, 0, 3), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((3, 0, 3), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((0, 1, 3), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((1, 1, 3), (0.05, 0.5, 0.45))
        pgm_function143.set_cpd((2, 1, 3), (0.05, 0.5, 0.45))
        pgm_function143.set_cpd((3, 1, 3), (0.05, 0.5, 0.45))
        pgm_function143.set_cpd((0, 2, 3), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((1, 2, 3), (0.05, 0.5, 0.45))
        pgm_function143.set_cpd((2, 2, 3), (0.05, 0.5, 0.45))
        pgm_function143.set_cpd((3, 2, 3), (0.05, 0.5, 0.45))
        pgm_function143.set_cpd((0, 3, 3), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((1, 3, 3), (0.05, 0.5, 0.45))
        pgm_function143.set_cpd((2, 3, 3), (0.05, 0.5, 0.45))
        pgm_function143.set_cpd((3, 3, 3), (0.05, 0.5, 0.45))
        pgm_function143.set_cpd((0, 0, 4), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((1, 0, 4), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((2, 0, 4), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((3, 0, 4), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((0, 1, 4), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((1, 1, 4), (0.2, 0.5, 0.3))
        pgm_function143.set_cpd((2, 1, 4), (0.2, 0.5, 0.3))
        pgm_function143.set_cpd((3, 1, 4), (0.2, 0.5, 0.3))
        pgm_function143.set_cpd((0, 2, 4), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((1, 2, 4), (0.2, 0.5, 0.3))
        pgm_function143.set_cpd((2, 2, 4), (0.2, 0.5, 0.3))
        pgm_function143.set_cpd((3, 2, 4), (0.2, 0.5, 0.3))
        pgm_function143.set_cpd((0, 3, 4), (1.0, 0.0, 0.0))
        pgm_function143.set_cpd((1, 3, 4), (0.2, 0.5, 0.3))
        pgm_function143.set_cpd((2, 3, 4), (0.2, 0.5, 0.3))
        pgm_function143.set_cpd((3, 3, 4), (0.2, 0.5, 0.3))
        pgm_factor144 = self.new_factor(R_LNLW_APB_MUDENS, R_LNLW_MED_SEV, R_LNLW_MED_TIME, R_LNLW_MED_PATHO)
        pgm_function144 = pgm_factor144.set_cpt()
        pgm_function144.set_cpd((0, 0, 0), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((1, 0, 0), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((2, 0, 0), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((3, 0, 0), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((4, 0, 0), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((0, 1, 0), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((1, 1, 0), (0.9, 0.1, 0.0))
        pgm_function144.set_cpd((2, 1, 0), (0.8, 0.2, 0.0))
        pgm_function144.set_cpd((3, 1, 0), (0.6, 0.4, 0.0))
        pgm_function144.set_cpd((4, 1, 0), (0.6, 0.4, 0.0))
        pgm_function144.set_cpd((0, 2, 0), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((1, 2, 0), (0.8, 0.2, 0.0))
        pgm_function144.set_cpd((2, 2, 0), (0.7, 0.3, 0.0))
        pgm_function144.set_cpd((3, 2, 0), (0.6, 0.4, 0.0))
        pgm_function144.set_cpd((4, 2, 0), (0.6, 0.4, 0.0))
        pgm_function144.set_cpd((0, 3, 0), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((1, 3, 0), (0.8, 0.2, 0.0))
        pgm_function144.set_cpd((2, 3, 0), (0.7, 0.3, 0.0))
        pgm_function144.set_cpd((3, 3, 0), (0.6, 0.4, 0.0))
        pgm_function144.set_cpd((4, 3, 0), (0.6, 0.4, 0.0))
        pgm_function144.set_cpd((0, 0, 1), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((1, 0, 1), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((2, 0, 1), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((3, 0, 1), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((4, 0, 1), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((0, 1, 1), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((1, 1, 1), (0.9, 0.1, 0.0))
        pgm_function144.set_cpd((2, 1, 1), (0.8, 0.2, 0.0))
        pgm_function144.set_cpd((3, 1, 1), (0.6, 0.4, 0.0))
        pgm_function144.set_cpd((4, 1, 1), (0.6, 0.4, 0.0))
        pgm_function144.set_cpd((0, 2, 1), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((1, 2, 1), (0.8, 0.2, 0.0))
        pgm_function144.set_cpd((2, 2, 1), (0.7, 0.3, 0.0))
        pgm_function144.set_cpd((3, 2, 1), (0.6, 0.4, 0.0))
        pgm_function144.set_cpd((4, 2, 1), (0.6, 0.4, 0.0))
        pgm_function144.set_cpd((0, 3, 1), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((1, 3, 1), (0.8, 0.2, 0.0))
        pgm_function144.set_cpd((2, 3, 1), (0.7, 0.3, 0.0))
        pgm_function144.set_cpd((3, 3, 1), (0.6, 0.4, 0.0))
        pgm_function144.set_cpd((4, 3, 1), (0.6, 0.4, 0.0))
        pgm_function144.set_cpd((0, 0, 2), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((1, 0, 2), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((2, 0, 2), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((3, 0, 2), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((4, 0, 2), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((0, 1, 2), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((1, 1, 2), (0.6, 0.4, 0.0))
        pgm_function144.set_cpd((2, 1, 2), (0.5, 0.5, 0.0))
        pgm_function144.set_cpd((3, 1, 2), (0.5, 0.4, 0.1))
        pgm_function144.set_cpd((4, 1, 2), (0.3, 0.6, 0.1))
        pgm_function144.set_cpd((0, 2, 2), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((1, 2, 2), (0.7, 0.3, 0.0))
        pgm_function144.set_cpd((2, 2, 2), (0.1, 0.6, 0.3))
        pgm_function144.set_cpd((3, 2, 2), (0.0, 0.5, 0.5))
        pgm_function144.set_cpd((4, 2, 2), (0.0, 0.5, 0.5))
        pgm_function144.set_cpd((0, 3, 2), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((1, 3, 2), (0.5, 0.5, 0.0))
        pgm_function144.set_cpd((2, 3, 2), (0.15, 0.7, 0.15))
        pgm_function144.set_cpd((3, 3, 2), (0.0, 0.5, 0.5))
        pgm_function144.set_cpd((4, 3, 2), (0.0, 0.5, 0.5))
        pgm_function144.set_cpd((0, 0, 3), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((1, 0, 3), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((2, 0, 3), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((3, 0, 3), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((4, 0, 3), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((0, 1, 3), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((1, 1, 3), (0.05, 0.5, 0.45))
        pgm_function144.set_cpd((2, 1, 3), (0.05, 0.5, 0.45))
        pgm_function144.set_cpd((3, 1, 3), (0.05, 0.5, 0.45))
        pgm_function144.set_cpd((4, 1, 3), (0.05, 0.5, 0.45))
        pgm_function144.set_cpd((0, 2, 3), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((1, 2, 3), (0.05, 0.5, 0.45))
        pgm_function144.set_cpd((2, 2, 3), (0.05, 0.5, 0.45))
        pgm_function144.set_cpd((3, 2, 3), (0.05, 0.5, 0.45))
        pgm_function144.set_cpd((4, 2, 3), (0.05, 0.5, 0.45))
        pgm_function144.set_cpd((0, 3, 3), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((1, 3, 3), (0.05, 0.5, 0.45))
        pgm_function144.set_cpd((2, 3, 3), (0.05, 0.5, 0.45))
        pgm_function144.set_cpd((3, 3, 3), (0.05, 0.5, 0.45))
        pgm_function144.set_cpd((4, 3, 3), (0.05, 0.5, 0.45))
        pgm_function144.set_cpd((0, 0, 4), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((1, 0, 4), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((2, 0, 4), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((3, 0, 4), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((4, 0, 4), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((0, 1, 4), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((1, 1, 4), (0.2, 0.5, 0.3))
        pgm_function144.set_cpd((2, 1, 4), (0.2, 0.5, 0.3))
        pgm_function144.set_cpd((3, 1, 4), (0.2, 0.5, 0.3))
        pgm_function144.set_cpd((4, 1, 4), (0.2, 0.5, 0.3))
        pgm_function144.set_cpd((0, 2, 4), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((1, 2, 4), (0.2, 0.5, 0.3))
        pgm_function144.set_cpd((2, 2, 4), (0.2, 0.5, 0.3))
        pgm_function144.set_cpd((3, 2, 4), (0.2, 0.5, 0.3))
        pgm_function144.set_cpd((4, 2, 4), (0.2, 0.5, 0.3))
        pgm_function144.set_cpd((0, 3, 4), (1.0, 0.0, 0.0))
        pgm_function144.set_cpd((1, 3, 4), (0.2, 0.5, 0.3))
        pgm_function144.set_cpd((2, 3, 4), (0.2, 0.5, 0.3))
        pgm_function144.set_cpd((3, 3, 4), (0.2, 0.5, 0.3))
        pgm_function144.set_cpd((4, 3, 4), (0.2, 0.5, 0.3))
        pgm_factor145 = self.new_factor(R_DIFFN_LNLW_APB_MUDENS, R_DIFFN_APB_MUDENS, R_LNLW_APB_MUDENS)
        pgm_function145 = pgm_factor145.set_cpt()
        pgm_function145.set_cpd((0, 0), (1.0, 0.0, 0.0))
        pgm_function145.set_cpd((1, 0), (0.0, 1.0, 0.0))
        pgm_function145.set_cpd((2, 0), (0.0, 0.0, 1.0))
        pgm_function145.set_cpd((0, 1), (0.0, 1.0, 0.0))
        pgm_function145.set_cpd((1, 1), (0.0, 0.0, 1.0))
        pgm_function145.set_cpd((2, 1), (0.0, 0.0, 1.0))
        pgm_function145.set_cpd((0, 2), (0.0, 0.0, 1.0))
        pgm_function145.set_cpd((1, 2), (0.0, 0.0, 1.0))
        pgm_function145.set_cpd((2, 2), (0.0, 0.0, 1.0))
        pgm_factor146 = self.new_factor(R_LNL_DIFFN_APB_MUDENS, R_LNLT1_LP_BE_APB_MUDENS, R_DIFFN_LNLW_APB_MUDENS)
        pgm_function146 = pgm_factor146.set_cpt()
        pgm_function146.set_cpd((0, 0), (1.0, 0.0, 0.0))
        pgm_function146.set_cpd((1, 0), (0.0, 1.0, 0.0))
        pgm_function146.set_cpd((2, 0), (0.0, 0.0, 1.0))
        pgm_function146.set_cpd((0, 1), (0.0, 1.0, 0.0))
        pgm_function146.set_cpd((1, 1), (0.0, 0.0, 1.0))
        pgm_function146.set_cpd((2, 1), (0.0, 0.0, 1.0))
        pgm_function146.set_cpd((0, 2), (0.0, 0.0, 1.0))
        pgm_function146.set_cpd((1, 2), (0.0, 0.0, 1.0))
        pgm_function146.set_cpd((2, 2), (0.0, 0.0, 1.0))
        pgm_factor147 = self.new_factor(R_MYOP_APB_MUDENS)
        pgm_function147 = pgm_factor147.set_cpt()
        pgm_function147.set_cpd((), (1.0, 0.0, 0.0))
        pgm_factor148 = self.new_factor(R_MYDY_APB_MUDENS)
        pgm_function148 = pgm_factor148.set_cpt()
        pgm_function148.set_cpd((), (1.0, 0.0, 0.0))
        pgm_factor149 = self.new_factor(R_MYOP_MYDY_APB_MUDENS, R_MYOP_APB_MUDENS, R_MYDY_APB_MUDENS)
        pgm_function149 = pgm_factor149.set_cpt()
        pgm_function149.set_cpd((0, 0), (1.0, 0.0, 0.0))
        pgm_function149.set_cpd((1, 0), (0.0, 1.0, 0.0))
        pgm_function149.set_cpd((2, 0), (0.0, 0.0, 1.0))
        pgm_function149.set_cpd((0, 1), (0.0, 1.0, 0.0))
        pgm_function149.set_cpd((1, 1), (0.0, 0.0, 1.0))
        pgm_function149.set_cpd((2, 1), (0.0, 0.0, 1.0))
        pgm_function149.set_cpd((0, 2), (0.0, 0.0, 1.0))
        pgm_function149.set_cpd((1, 2), (0.0, 0.0, 1.0))
        pgm_function149.set_cpd((2, 2), (0.0, 0.0, 1.0))
        pgm_factor150 = self.new_factor(R_MYAS_APB_MUDENS)
        pgm_function150 = pgm_factor150.set_cpt()
        pgm_function150.set_cpd((), (1.0, 0.0, 0.0))
        pgm_factor151 = self.new_factor(R_MUSCLE_APB_MUDENS, R_MYOP_MYDY_APB_MUDENS, R_MYAS_APB_MUDENS)
        pgm_function151 = pgm_factor151.set_cpt()
        pgm_function151.set_cpd((0, 0), (1.0, 0.0, 0.0))
        pgm_function151.set_cpd((1, 0), (0.0, 1.0, 0.0))
        pgm_function151.set_cpd((2, 0), (0.0, 0.0, 1.0))
        pgm_function151.set_cpd((0, 1), (0.0, 1.0, 0.0))
        pgm_function151.set_cpd((1, 1), (0.0, 0.0, 1.0))
        pgm_function151.set_cpd((2, 1), (0.0, 0.0, 1.0))
        pgm_function151.set_cpd((0, 2), (0.0, 0.0, 1.0))
        pgm_function151.set_cpd((1, 2), (0.0, 0.0, 1.0))
        pgm_function151.set_cpd((2, 2), (0.0, 0.0, 1.0))
        pgm_factor152 = self.new_factor(R_APB_MUDENS, R_LNL_DIFFN_APB_MUDENS, R_MUSCLE_APB_MUDENS)
        pgm_function152 = pgm_factor152.set_cpt()
        pgm_function152.set_cpd((0, 0), (1.0, 0.0, 0.0))
        pgm_function152.set_cpd((1, 0), (0.0, 1.0, 0.0))
        pgm_function152.set_cpd((2, 0), (0.0, 0.0, 1.0))
        pgm_function152.set_cpd((0, 1), (0.0, 1.0, 0.0))
        pgm_function152.set_cpd((1, 1), (0.0, 0.0, 1.0))
        pgm_function152.set_cpd((2, 1), (0.0, 0.0, 1.0))
        pgm_function152.set_cpd((0, 2), (0.0, 0.0, 1.0))
        pgm_function152.set_cpd((1, 2), (0.0, 0.0, 1.0))
        pgm_function152.set_cpd((2, 2), (0.0, 0.0, 1.0))
        pgm_factor153 = self.new_factor(R_APB_SF_DENSITY, R_APB_MUDENS)
        pgm_function153 = pgm_factor153.set_cpt()
        pgm_function153.set_cpd((0,), (0.97, 0.03, 0.0))
        pgm_function153.set_cpd((1,), (0.05, 0.9, 0.05))
        pgm_function153.set_cpd((2,), (0.01, 0.04, 0.95))
        pgm_factor154 = self.new_factor(R_LNLT1_APB_NEUR_ACT)
        pgm_function154 = pgm_factor154.set_cpt()
        pgm_function154.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor155 = self.new_factor(R_LNLLP_APB_NEUR_ACT)
        pgm_function155 = pgm_factor155.set_cpt()
        pgm_function155.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor156 = self.new_factor(R_LNLT1_LP_APB_NEUR_ACT, R_LNLT1_APB_NEUR_ACT, R_LNLLP_APB_NEUR_ACT)
        pgm_function156 = pgm_factor156.set_cpt()
        pgm_function156.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function156.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function156.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function156.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function156.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function156.set_cpd((5, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function156.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function156.set_cpd((1, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function156.set_cpd((2, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function156.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function156.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function156.set_cpd((5, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function156.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function156.set_cpd((1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function156.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function156.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function156.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function156.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function156.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function156.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function156.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function156.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function156.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function156.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function156.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function156.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function156.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function156.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function156.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function156.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function156.set_cpd((0, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function156.set_cpd((1, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function156.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function156.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function156.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function156.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor157 = self.new_factor(R_LNLBE_APB_NEUR_ACT)
        pgm_function157 = pgm_factor157.set_cpt()
        pgm_function157.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor158 = self.new_factor(R_LNLT1_LP_BE_APB_NEUR_ACT, R_LNLT1_LP_APB_NEUR_ACT, R_LNLBE_APB_NEUR_ACT)
        pgm_function158 = pgm_factor158.set_cpt()
        pgm_function158.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function158.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function158.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function158.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function158.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function158.set_cpd((5, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function158.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function158.set_cpd((1, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function158.set_cpd((2, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function158.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function158.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function158.set_cpd((5, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function158.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function158.set_cpd((1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function158.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function158.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function158.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function158.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function158.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function158.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function158.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function158.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function158.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function158.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function158.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function158.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function158.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function158.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function158.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function158.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function158.set_cpd((0, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function158.set_cpd((1, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function158.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function158.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function158.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function158.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor159 = self.new_factor(R_DIFFN_APB_NEUR_ACT, DIFFN_M_SEV_DIST, DIFFN_TIME)
        pgm_function159 = pgm_factor159.set_cpt()
        pgm_function159.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function159.set_cpd((1, 0), (0.9, 0.1, 0.0, 0.0, 0.0, 0.0))
        pgm_function159.set_cpd((2, 0), (0.9, 0.1, 0.0, 0.0, 0.0, 0.0))
        pgm_function159.set_cpd((3, 0), (0.9, 0.1, 0.0, 0.0, 0.0, 0.0))
        pgm_function159.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function159.set_cpd((1, 1), (0.7, 0.3, 0.0, 0.0, 0.0, 0.0))
        pgm_function159.set_cpd((2, 1), (0.7, 0.3, 0.0, 0.0, 0.0, 0.0))
        pgm_function159.set_cpd((3, 1), (0.7, 0.3, 0.0, 0.0, 0.0, 0.0))
        pgm_function159.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function159.set_cpd((1, 2), (0.5, 0.5, 0.0, 0.0, 0.0, 0.0))
        pgm_function159.set_cpd((2, 2), (0.5, 0.5, 0.0, 0.0, 0.0, 0.0))
        pgm_function159.set_cpd((3, 2), (0.3, 0.7, 0.0, 0.0, 0.0, 0.0))
        pgm_function159.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function159.set_cpd((1, 3), (0.1, 0.9, 0.0, 0.0, 0.0, 0.0))
        pgm_function159.set_cpd((2, 3), (0.7, 0.3, 0.0, 0.0, 0.0, 0.0))
        pgm_function159.set_cpd((3, 3), (0.3, 0.7, 0.0, 0.0, 0.0, 0.0))
        pgm_factor160 = self.new_factor(R_LNLW_APB_NEUR_ACT, R_LNLW_MED_SEV, R_LNLW_MED_TIME)
        pgm_function160 = pgm_factor160.set_cpt()
        pgm_function160.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function160.set_cpd((1, 0), (0.9, 0.1, 0.0, 0.0, 0.0, 0.0))
        pgm_function160.set_cpd((2, 0), (0.9, 0.1, 0.0, 0.0, 0.0, 0.0))
        pgm_function160.set_cpd((3, 0), (0.9, 0.1, 0.0, 0.0, 0.0, 0.0))
        pgm_function160.set_cpd((4, 0), (0.9, 0.1, 0.0, 0.0, 0.0, 0.0))
        pgm_function160.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function160.set_cpd((1, 1), (0.7, 0.3, 0.0, 0.0, 0.0, 0.0))
        pgm_function160.set_cpd((2, 1), (0.7, 0.3, 0.0, 0.0, 0.0, 0.0))
        pgm_function160.set_cpd((3, 1), (0.7, 0.3, 0.0, 0.0, 0.0, 0.0))
        pgm_function160.set_cpd((4, 1), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function160.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function160.set_cpd((1, 2), (0.5, 0.5, 0.0, 0.0, 0.0, 0.0))
        pgm_function160.set_cpd((2, 2), (0.5, 0.5, 0.0, 0.0, 0.0, 0.0))
        pgm_function160.set_cpd((3, 2), (0.3, 0.7, 0.0, 0.0, 0.0, 0.0))
        pgm_function160.set_cpd((4, 2), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function160.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function160.set_cpd((1, 3), (0.1, 0.9, 0.0, 0.0, 0.0, 0.0))
        pgm_function160.set_cpd((2, 3), (0.7, 0.3, 0.0, 0.0, 0.0, 0.0))
        pgm_function160.set_cpd((3, 3), (0.3, 0.7, 0.0, 0.0, 0.0, 0.0))
        pgm_function160.set_cpd((4, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor161 = self.new_factor(R_DIFFN_LNLW_APB_NEUR_ACT, R_DIFFN_APB_NEUR_ACT, R_LNLW_APB_NEUR_ACT)
        pgm_function161 = pgm_factor161.set_cpt()
        pgm_function161.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function161.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function161.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function161.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function161.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function161.set_cpd((5, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function161.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function161.set_cpd((1, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function161.set_cpd((2, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function161.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function161.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function161.set_cpd((5, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function161.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function161.set_cpd((1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function161.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function161.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function161.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function161.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function161.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function161.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function161.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function161.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function161.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function161.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function161.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function161.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function161.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function161.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function161.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function161.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function161.set_cpd((0, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function161.set_cpd((1, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function161.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function161.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function161.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function161.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor162 = self.new_factor(R_APB_NEUR_ACT, R_LNLT1_LP_BE_APB_NEUR_ACT, R_DIFFN_LNLW_APB_NEUR_ACT)
        pgm_function162 = pgm_factor162.set_cpt()
        pgm_function162.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function162.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function162.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function162.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function162.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function162.set_cpd((5, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function162.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function162.set_cpd((1, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function162.set_cpd((2, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function162.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function162.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function162.set_cpd((5, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function162.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function162.set_cpd((1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function162.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function162.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function162.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function162.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function162.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function162.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function162.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function162.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function162.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function162.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function162.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function162.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function162.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function162.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function162.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function162.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function162.set_cpd((0, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function162.set_cpd((1, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function162.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function162.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function162.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function162.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor163 = self.new_factor(R_APB_SPONT_NEUR_DISCH, R_APB_NEUR_ACT)
        pgm_function163 = pgm_factor163.set_cpt()
        pgm_function163.set_cpd((0,), (0.98, 0.02, 0.0, 0.0, 0.0, 0.0))
        pgm_function163.set_cpd((1,), (0.1, 0.9, 0.0, 0.0, 0.0, 0.0))
        pgm_function163.set_cpd((2,), (0.01, 0.04, 0.75, 0.05, 0.05, 0.1))
        pgm_function163.set_cpd((3,), (0.01, 0.04, 0.05, 0.75, 0.05, 0.1))
        pgm_function163.set_cpd((4,), (0.01, 0.04, 0.05, 0.05, 0.75, 0.1))
        pgm_function163.set_cpd((5,), (0.01, 0.05, 0.05, 0.05, 0.05, 0.79))
        pgm_factor164 = self.new_factor(R_MYOP_APB_DENERV)
        pgm_function164 = pgm_factor164.set_cpt()
        pgm_function164.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor165 = self.new_factor(R_MYDY_APB_DENERV)
        pgm_function165 = pgm_factor165.set_cpt()
        pgm_function165.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor166 = self.new_factor(R_MYOP_MYDY_APB_DENERV, R_MYOP_APB_DENERV, R_MYDY_APB_DENERV)
        pgm_function166 = pgm_factor166.set_cpt()
        pgm_function166.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function166.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function166.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function166.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function166.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0))
        pgm_function166.set_cpd((1, 1), (0.0, 0.0, 1.0, 0.0))
        pgm_function166.set_cpd((2, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function166.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function166.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function166.set_cpd((1, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function166.set_cpd((2, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function166.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function166.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function166.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function166.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function166.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor167 = self.new_factor(R_NMT_APB_DENERV, R_APB_NMT)
        pgm_function167 = pgm_factor167.set_cpt()
        pgm_function167.set_cpd((0,), (1.0, 0.0, 0.0, 0.0))
        pgm_function167.set_cpd((1,), (0.4, 0.45, 0.15, 0.0))
        pgm_function167.set_cpd((2,), (0.15, 0.35, 0.35, 0.15))
        pgm_function167.set_cpd((3,), (0.85, 0.15, 0.0, 0.0))
        pgm_function167.set_cpd((4,), (0.3, 0.45, 0.2, 0.05))
        pgm_function167.set_cpd((5,), (0.15, 0.35, 0.35, 0.15))
        pgm_function167.set_cpd((6,), (0.25, 0.25, 0.25, 0.25))
        pgm_factor168 = self.new_factor(R_MUSCLE_APB_DENERV, R_MYOP_MYDY_APB_DENERV, R_NMT_APB_DENERV)
        pgm_function168 = pgm_factor168.set_cpt()
        pgm_function168.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function168.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function168.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function168.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function168.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0))
        pgm_function168.set_cpd((1, 1), (0.0, 0.0, 1.0, 0.0))
        pgm_function168.set_cpd((2, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function168.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function168.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function168.set_cpd((1, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function168.set_cpd((2, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function168.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function168.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function168.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function168.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function168.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor169 = self.new_factor(R_LNLT1_APB_DENERV)
        pgm_function169 = pgm_factor169.set_cpt()
        pgm_function169.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor170 = self.new_factor(R_LNLLP_APB_DENERV)
        pgm_function170 = pgm_factor170.set_cpt()
        pgm_function170.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor171 = self.new_factor(R_LNLT1_LP_APB_DENERV, R_LNLT1_APB_DENERV, R_LNLLP_APB_DENERV)
        pgm_function171 = pgm_factor171.set_cpt()
        pgm_function171.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function171.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function171.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function171.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function171.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0))
        pgm_function171.set_cpd((1, 1), (0.0, 0.0, 1.0, 0.0))
        pgm_function171.set_cpd((2, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function171.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function171.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function171.set_cpd((1, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function171.set_cpd((2, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function171.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function171.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function171.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function171.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function171.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor172 = self.new_factor(R_LNLBE_APB_DENERV)
        pgm_function172 = pgm_factor172.set_cpt()
        pgm_function172.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor173 = self.new_factor(R_LNLT1_LP_BE_APB_DENERV, R_LNLT1_LP_APB_DENERV, R_LNLBE_APB_DENERV)
        pgm_function173 = pgm_factor173.set_cpt()
        pgm_function173.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function173.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function173.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function173.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function173.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0))
        pgm_function173.set_cpd((1, 1), (0.0, 0.0, 1.0, 0.0))
        pgm_function173.set_cpd((2, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function173.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function173.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function173.set_cpd((1, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function173.set_cpd((2, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function173.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function173.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function173.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function173.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function173.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor174 = self.new_factor(R_DIFFN_APB_DENERV, DIFFN_M_SEV_DIST, DIFFN_TIME, DIFFN_PATHO)
        pgm_function174 = pgm_factor174.set_cpt()
        pgm_function174.set_cpd((0, 0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function174.set_cpd((1, 0, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function174.set_cpd((2, 0, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function174.set_cpd((3, 0, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function174.set_cpd((0, 1, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function174.set_cpd((1, 1, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function174.set_cpd((2, 1, 0), (0.3, 0.5, 0.2, 0.0))
        pgm_function174.set_cpd((3, 1, 0), (0.1, 0.5, 0.4, 0.0))
        pgm_function174.set_cpd((0, 2, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function174.set_cpd((1, 2, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function174.set_cpd((2, 2, 0), (0.3, 0.5, 0.2, 0.0))
        pgm_function174.set_cpd((3, 2, 0), (0.1, 0.5, 0.4, 0.0))
        pgm_function174.set_cpd((0, 3, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function174.set_cpd((1, 3, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function174.set_cpd((2, 3, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function174.set_cpd((3, 3, 0), (0.5, 0.4, 0.1, 0.0))
        pgm_function174.set_cpd((0, 0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function174.set_cpd((1, 0, 1), (0.8, 0.2, 0.0, 0.0))
        pgm_function174.set_cpd((2, 0, 1), (0.8, 0.2, 0.0, 0.0))
        pgm_function174.set_cpd((3, 0, 1), (0.8, 0.2, 0.0, 0.0))
        pgm_function174.set_cpd((0, 1, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function174.set_cpd((1, 1, 1), (0.9, 0.1, 0.0, 0.0))
        pgm_function174.set_cpd((2, 1, 1), (0.6, 0.4, 0.0, 0.0))
        pgm_function174.set_cpd((3, 1, 1), (0.4, 0.5, 0.1, 0.0))
        pgm_function174.set_cpd((0, 2, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function174.set_cpd((1, 2, 1), (0.9, 0.1, 0.0, 0.0))
        pgm_function174.set_cpd((2, 2, 1), (0.6, 0.4, 0.0, 0.0))
        pgm_function174.set_cpd((3, 2, 1), (0.4, 0.5, 0.1, 0.0))
        pgm_function174.set_cpd((0, 3, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function174.set_cpd((1, 3, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function174.set_cpd((2, 3, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function174.set_cpd((3, 3, 1), (0.5, 0.5, 0.0, 0.0))
        pgm_function174.set_cpd((0, 0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function174.set_cpd((1, 0, 2), (0.8, 0.2, 0.0, 0.0))
        pgm_function174.set_cpd((2, 0, 2), (0.8, 0.2, 0.0, 0.0))
        pgm_function174.set_cpd((3, 0, 2), (0.8, 0.2, 0.0, 0.0))
        pgm_function174.set_cpd((0, 1, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function174.set_cpd((1, 1, 2), (0.0, 1.0, 0.0, 0.0))
        pgm_function174.set_cpd((2, 1, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function174.set_cpd((3, 1, 2), (0.0, 0.0, 0.5, 0.5))
        pgm_function174.set_cpd((0, 2, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function174.set_cpd((1, 2, 2), (0.0, 1.0, 0.0, 0.0))
        pgm_function174.set_cpd((2, 2, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function174.set_cpd((3, 2, 2), (0.0, 0.0, 0.5, 0.5))
        pgm_function174.set_cpd((0, 3, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function174.set_cpd((1, 3, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function174.set_cpd((2, 3, 2), (0.9, 0.1, 0.0, 0.0))
        pgm_function174.set_cpd((3, 3, 2), (0.6, 0.3, 0.1, 0.0))
        pgm_function174.set_cpd((0, 0, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function174.set_cpd((1, 0, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function174.set_cpd((2, 0, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function174.set_cpd((3, 0, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function174.set_cpd((0, 1, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function174.set_cpd((1, 1, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function174.set_cpd((2, 1, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function174.set_cpd((3, 1, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function174.set_cpd((0, 2, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function174.set_cpd((1, 2, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function174.set_cpd((2, 2, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function174.set_cpd((3, 2, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function174.set_cpd((0, 3, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function174.set_cpd((1, 3, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function174.set_cpd((2, 3, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function174.set_cpd((3, 3, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function174.set_cpd((0, 0, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function174.set_cpd((1, 0, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function174.set_cpd((2, 0, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function174.set_cpd((3, 0, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function174.set_cpd((0, 1, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function174.set_cpd((1, 1, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function174.set_cpd((2, 1, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function174.set_cpd((3, 1, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function174.set_cpd((0, 2, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function174.set_cpd((1, 2, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function174.set_cpd((2, 2, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function174.set_cpd((3, 2, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function174.set_cpd((0, 3, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function174.set_cpd((1, 3, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function174.set_cpd((2, 3, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function174.set_cpd((3, 3, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_factor175 = self.new_factor(R_LNLW_APB_DENERV, R_LNLW_MED_SEV, R_LNLW_MED_TIME, R_LNLW_MED_PATHO)
        pgm_function175 = pgm_factor175.set_cpt()
        pgm_function175.set_cpd((0, 0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function175.set_cpd((1, 0, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function175.set_cpd((2, 0, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function175.set_cpd((3, 0, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function175.set_cpd((4, 0, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function175.set_cpd((0, 1, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function175.set_cpd((1, 1, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function175.set_cpd((2, 1, 0), (0.3, 0.5, 0.2, 0.0))
        pgm_function175.set_cpd((3, 1, 0), (0.1, 0.5, 0.4, 0.0))
        pgm_function175.set_cpd((4, 1, 0), (0.0, 0.4, 0.4, 0.2))
        pgm_function175.set_cpd((0, 2, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function175.set_cpd((1, 2, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function175.set_cpd((2, 2, 0), (0.3, 0.5, 0.2, 0.0))
        pgm_function175.set_cpd((3, 2, 0), (0.1, 0.5, 0.4, 0.0))
        pgm_function175.set_cpd((4, 2, 0), (0.0, 0.4, 0.4, 0.2))
        pgm_function175.set_cpd((0, 3, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function175.set_cpd((1, 3, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function175.set_cpd((2, 3, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function175.set_cpd((3, 3, 0), (0.5, 0.4, 0.1, 0.0))
        pgm_function175.set_cpd((4, 3, 0), (0.1, 0.6, 0.25, 0.05))
        pgm_function175.set_cpd((0, 0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function175.set_cpd((1, 0, 1), (0.8, 0.2, 0.0, 0.0))
        pgm_function175.set_cpd((2, 0, 1), (0.8, 0.2, 0.0, 0.0))
        pgm_function175.set_cpd((3, 0, 1), (0.8, 0.2, 0.0, 0.0))
        pgm_function175.set_cpd((4, 0, 1), (0.8, 0.2, 0.0, 0.0))
        pgm_function175.set_cpd((0, 1, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function175.set_cpd((1, 1, 1), (0.8, 0.2, 0.0, 0.0))
        pgm_function175.set_cpd((2, 1, 1), (0.6, 0.4, 0.0, 0.0))
        pgm_function175.set_cpd((3, 1, 1), (0.4, 0.5, 0.1, 0.0))
        pgm_function175.set_cpd((4, 1, 1), (0.3, 0.4, 0.3, 0.0))
        pgm_function175.set_cpd((0, 2, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function175.set_cpd((1, 2, 1), (0.9, 0.1, 0.0, 0.0))
        pgm_function175.set_cpd((2, 2, 1), (0.6, 0.4, 0.0, 0.0))
        pgm_function175.set_cpd((3, 2, 1), (0.4, 0.5, 0.1, 0.0))
        pgm_function175.set_cpd((4, 2, 1), (0.3, 0.4, 0.3, 0.0))
        pgm_function175.set_cpd((0, 3, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function175.set_cpd((1, 3, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function175.set_cpd((2, 3, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function175.set_cpd((3, 3, 1), (0.5, 0.5, 0.0, 0.0))
        pgm_function175.set_cpd((4, 3, 1), (0.5, 0.5, 0.0, 0.0))
        pgm_function175.set_cpd((0, 0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function175.set_cpd((1, 0, 2), (0.8, 0.2, 0.0, 0.0))
        pgm_function175.set_cpd((2, 0, 2), (0.8, 0.2, 0.0, 0.0))
        pgm_function175.set_cpd((3, 0, 2), (0.8, 0.2, 0.0, 0.0))
        pgm_function175.set_cpd((4, 0, 2), (0.8, 0.2, 0.0, 0.0))
        pgm_function175.set_cpd((0, 1, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function175.set_cpd((1, 1, 2), (0.0, 1.0, 0.0, 0.0))
        pgm_function175.set_cpd((2, 1, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function175.set_cpd((3, 1, 2), (0.0, 0.0, 0.5, 0.5))
        pgm_function175.set_cpd((4, 1, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function175.set_cpd((0, 2, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function175.set_cpd((1, 2, 2), (0.0, 1.0, 0.0, 0.0))
        pgm_function175.set_cpd((2, 2, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function175.set_cpd((3, 2, 2), (0.0, 0.0, 0.5, 0.5))
        pgm_function175.set_cpd((4, 2, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function175.set_cpd((0, 3, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function175.set_cpd((1, 3, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function175.set_cpd((2, 3, 2), (0.9, 0.1, 0.0, 0.0))
        pgm_function175.set_cpd((3, 3, 2), (0.6, 0.3, 0.1, 0.0))
        pgm_function175.set_cpd((4, 3, 2), (0.45, 0.45, 0.1, 0.0))
        pgm_function175.set_cpd((0, 0, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function175.set_cpd((1, 0, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function175.set_cpd((2, 0, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function175.set_cpd((3, 0, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function175.set_cpd((4, 0, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function175.set_cpd((0, 1, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function175.set_cpd((1, 1, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function175.set_cpd((2, 1, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function175.set_cpd((3, 1, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function175.set_cpd((4, 1, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function175.set_cpd((0, 2, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function175.set_cpd((1, 2, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function175.set_cpd((2, 2, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function175.set_cpd((3, 2, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function175.set_cpd((4, 2, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function175.set_cpd((0, 3, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function175.set_cpd((1, 3, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function175.set_cpd((2, 3, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function175.set_cpd((3, 3, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function175.set_cpd((4, 3, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function175.set_cpd((0, 0, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function175.set_cpd((1, 0, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function175.set_cpd((2, 0, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function175.set_cpd((3, 0, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function175.set_cpd((4, 0, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function175.set_cpd((0, 1, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function175.set_cpd((1, 1, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function175.set_cpd((2, 1, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function175.set_cpd((3, 1, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function175.set_cpd((4, 1, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function175.set_cpd((0, 2, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function175.set_cpd((1, 2, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function175.set_cpd((2, 2, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function175.set_cpd((3, 2, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function175.set_cpd((4, 2, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function175.set_cpd((0, 3, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function175.set_cpd((1, 3, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function175.set_cpd((2, 3, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function175.set_cpd((3, 3, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function175.set_cpd((4, 3, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_factor176 = self.new_factor(R_DIFFN_LNLW_APB_DENERV, R_DIFFN_APB_DENERV, R_LNLW_APB_DENERV)
        pgm_function176 = pgm_factor176.set_cpt()
        pgm_function176.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function176.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function176.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function176.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function176.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0))
        pgm_function176.set_cpd((1, 1), (0.0, 0.0, 1.0, 0.0))
        pgm_function176.set_cpd((2, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function176.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function176.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function176.set_cpd((1, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function176.set_cpd((2, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function176.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function176.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function176.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function176.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function176.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor177 = self.new_factor(R_LNL_DIFFN_APB_DENERV, R_LNLT1_LP_BE_APB_DENERV, R_DIFFN_LNLW_APB_DENERV)
        pgm_function177 = pgm_factor177.set_cpt()
        pgm_function177.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function177.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function177.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function177.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function177.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0))
        pgm_function177.set_cpd((1, 1), (0.0, 0.0, 1.0, 0.0))
        pgm_function177.set_cpd((2, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function177.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function177.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function177.set_cpd((1, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function177.set_cpd((2, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function177.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function177.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function177.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function177.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function177.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor178 = self.new_factor(R_APB_DENERV, R_MUSCLE_APB_DENERV, R_LNL_DIFFN_APB_DENERV)
        pgm_function178 = pgm_factor178.set_cpt()
        pgm_function178.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function178.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function178.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function178.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function178.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0))
        pgm_function178.set_cpd((1, 1), (0.0, 0.0, 1.0, 0.0))
        pgm_function178.set_cpd((2, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function178.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function178.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function178.set_cpd((1, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function178.set_cpd((2, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function178.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function178.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function178.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function178.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function178.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor179 = self.new_factor(R_APB_SPONT_DENERV_ACT, R_APB_DENERV)
        pgm_function179 = pgm_factor179.set_cpt()
        pgm_function179.set_cpd((0,), (0.98, 0.02, 0.0, 0.0))
        pgm_function179.set_cpd((1,), (0.07, 0.85, 0.08, 0.0))
        pgm_function179.set_cpd((2,), (0.01, 0.07, 0.85, 0.07))
        pgm_function179.set_cpd((3,), (0.0, 0.01, 0.07, 0.92))
        pgm_factor180 = self.new_factor(R_APB_SPONT_HF_DISCH, R_APB_DENERV)
        pgm_function180 = pgm_factor180.set_cpt()
        pgm_function180.set_cpd((0,), (0.99, 0.01))
        pgm_function180.set_cpd((1,), (0.97, 0.03))
        pgm_function180.set_cpd((2,), (0.95, 0.05))
        pgm_function180.set_cpd((3,), (0.93, 0.07))
        pgm_factor181 = self.new_factor(R_APB_SPONT_INS_ACT, R_APB_DENERV)
        pgm_function181 = pgm_factor181.set_cpt()
        pgm_function181.set_cpd((0,), (0.98, 0.02))
        pgm_function181.set_cpd((1,), (0.1, 0.9))
        pgm_function181.set_cpd((2,), (0.05, 0.95))
        pgm_function181.set_cpd((3,), (0.05, 0.95))
        pgm_factor182 = self.new_factor(DIFFN_M_SEV_PROX, DIFFN_MOT_SEV, DIFFN_DISTR)
        pgm_function182 = pgm_factor182.set_cpt()
        pgm_function182.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function182.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function182.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function182.set_cpd((3, 0), (0.0, 0.5, 0.5, 0.0))
        pgm_function182.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function182.set_cpd((1, 1), (0.0, 1.0, 0.0, 0.0))
        pgm_function182.set_cpd((2, 1), (0.0, 0.0, 1.0, 0.0))
        pgm_function182.set_cpd((3, 1), (0.0, 0.5, 0.5, 0.0))
        pgm_function182.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function182.set_cpd((1, 2), (0.25, 0.45, 0.25, 0.05))
        pgm_function182.set_cpd((2, 2), (0.1, 0.4, 0.4, 0.1))
        pgm_function182.set_cpd((3, 2), (0.05, 0.15, 0.4, 0.4))
        pgm_factor183 = self.new_factor(DIFFN_DUMMY_1, DIFFN_M_SEV_PROX, DIFFN_PATHO, DIFFN_TIME)
        pgm_function183 = pgm_factor183.set_cpt()
        pgm_function183.set_cpd((0, 0, 0), (0.5, 0.5))
        pgm_function183.set_cpd((1, 0, 0), (0.5, 0.5))
        pgm_function183.set_cpd((2, 0, 0), (0.5, 0.5))
        pgm_function183.set_cpd((3, 0, 0), (0.5, 0.5))
        pgm_function183.set_cpd((0, 1, 0), (0.5, 0.5))
        pgm_function183.set_cpd((1, 1, 0), (0.5, 0.5))
        pgm_function183.set_cpd((2, 1, 0), (0.5, 0.5))
        pgm_function183.set_cpd((3, 1, 0), (0.5, 0.5))
        pgm_function183.set_cpd((0, 2, 0), (0.5, 0.5))
        pgm_function183.set_cpd((1, 2, 0), (0.5, 0.5))
        pgm_function183.set_cpd((2, 2, 0), (0.5, 0.5))
        pgm_function183.set_cpd((3, 2, 0), (0.5, 0.5))
        pgm_function183.set_cpd((0, 3, 0), (0.5, 0.5))
        pgm_function183.set_cpd((1, 3, 0), (0.5, 0.5))
        pgm_function183.set_cpd((2, 3, 0), (0.5, 0.5))
        pgm_function183.set_cpd((3, 3, 0), (0.5, 0.5))
        pgm_function183.set_cpd((0, 4, 0), (0.5, 0.5))
        pgm_function183.set_cpd((1, 4, 0), (0.5, 0.5))
        pgm_function183.set_cpd((2, 4, 0), (0.5, 0.5))
        pgm_function183.set_cpd((3, 4, 0), (0.5, 0.5))
        pgm_function183.set_cpd((0, 0, 1), (0.5, 0.5))
        pgm_function183.set_cpd((1, 0, 1), (0.5, 0.5))
        pgm_function183.set_cpd((2, 0, 1), (0.5, 0.5))
        pgm_function183.set_cpd((3, 0, 1), (0.5, 0.5))
        pgm_function183.set_cpd((0, 1, 1), (0.5, 0.5))
        pgm_function183.set_cpd((1, 1, 1), (0.5, 0.5))
        pgm_function183.set_cpd((2, 1, 1), (0.5, 0.5))
        pgm_function183.set_cpd((3, 1, 1), (0.5, 0.5))
        pgm_function183.set_cpd((0, 2, 1), (0.5, 0.5))
        pgm_function183.set_cpd((1, 2, 1), (0.5, 0.5))
        pgm_function183.set_cpd((2, 2, 1), (0.5, 0.5))
        pgm_function183.set_cpd((3, 2, 1), (0.5, 0.5))
        pgm_function183.set_cpd((0, 3, 1), (0.5, 0.5))
        pgm_function183.set_cpd((1, 3, 1), (0.5, 0.5))
        pgm_function183.set_cpd((2, 3, 1), (0.5, 0.5))
        pgm_function183.set_cpd((3, 3, 1), (0.5, 0.5))
        pgm_function183.set_cpd((0, 4, 1), (0.5, 0.5))
        pgm_function183.set_cpd((1, 4, 1), (0.5, 0.5))
        pgm_function183.set_cpd((2, 4, 1), (0.5, 0.5))
        pgm_function183.set_cpd((3, 4, 1), (0.5, 0.5))
        pgm_function183.set_cpd((0, 0, 2), (0.5, 0.5))
        pgm_function183.set_cpd((1, 0, 2), (0.5, 0.5))
        pgm_function183.set_cpd((2, 0, 2), (0.5, 0.5))
        pgm_function183.set_cpd((3, 0, 2), (0.5, 0.5))
        pgm_function183.set_cpd((0, 1, 2), (0.5, 0.5))
        pgm_function183.set_cpd((1, 1, 2), (0.5, 0.5))
        pgm_function183.set_cpd((2, 1, 2), (0.5, 0.5))
        pgm_function183.set_cpd((3, 1, 2), (0.5, 0.5))
        pgm_function183.set_cpd((0, 2, 2), (0.5, 0.5))
        pgm_function183.set_cpd((1, 2, 2), (0.5, 0.5))
        pgm_function183.set_cpd((2, 2, 2), (0.5, 0.5))
        pgm_function183.set_cpd((3, 2, 2), (0.5, 0.5))
        pgm_function183.set_cpd((0, 3, 2), (0.5, 0.5))
        pgm_function183.set_cpd((1, 3, 2), (0.5, 0.5))
        pgm_function183.set_cpd((2, 3, 2), (0.5, 0.5))
        pgm_function183.set_cpd((3, 3, 2), (0.5, 0.5))
        pgm_function183.set_cpd((0, 4, 2), (0.5, 0.5))
        pgm_function183.set_cpd((1, 4, 2), (0.5, 0.5))
        pgm_function183.set_cpd((2, 4, 2), (0.5, 0.5))
        pgm_function183.set_cpd((3, 4, 2), (0.5, 0.5))
        pgm_function183.set_cpd((0, 0, 3), (0.5, 0.5))
        pgm_function183.set_cpd((1, 0, 3), (0.5, 0.5))
        pgm_function183.set_cpd((2, 0, 3), (0.5, 0.5))
        pgm_function183.set_cpd((3, 0, 3), (0.5, 0.5))
        pgm_function183.set_cpd((0, 1, 3), (0.5, 0.5))
        pgm_function183.set_cpd((1, 1, 3), (0.5, 0.5))
        pgm_function183.set_cpd((2, 1, 3), (0.5, 0.5))
        pgm_function183.set_cpd((3, 1, 3), (0.5, 0.5))
        pgm_function183.set_cpd((0, 2, 3), (0.5, 0.5))
        pgm_function183.set_cpd((1, 2, 3), (0.5, 0.5))
        pgm_function183.set_cpd((2, 2, 3), (0.5, 0.5))
        pgm_function183.set_cpd((3, 2, 3), (0.5, 0.5))
        pgm_function183.set_cpd((0, 3, 3), (0.5, 0.5))
        pgm_function183.set_cpd((1, 3, 3), (0.5, 0.5))
        pgm_function183.set_cpd((2, 3, 3), (0.5, 0.5))
        pgm_function183.set_cpd((3, 3, 3), (0.5, 0.5))
        pgm_function183.set_cpd((0, 4, 3), (0.5, 0.5))
        pgm_function183.set_cpd((1, 4, 3), (0.5, 0.5))
        pgm_function183.set_cpd((2, 4, 3), (0.5, 0.5))
        pgm_function183.set_cpd((3, 4, 3), (0.5, 0.5))
        pgm_factor184 = self.new_factor(DIFFN_DUMMY_2, DIFFN_M_SEV_DIST, DIFFN_PATHO, DIFFN_TIME)
        pgm_function184 = pgm_factor184.set_cpt()
        pgm_function184.set_cpd((0, 0, 0), (0.5, 0.5))
        pgm_function184.set_cpd((1, 0, 0), (0.5, 0.5))
        pgm_function184.set_cpd((2, 0, 0), (0.5, 0.5))
        pgm_function184.set_cpd((3, 0, 0), (0.5, 0.5))
        pgm_function184.set_cpd((0, 1, 0), (0.5, 0.5))
        pgm_function184.set_cpd((1, 1, 0), (0.5, 0.5))
        pgm_function184.set_cpd((2, 1, 0), (0.5, 0.5))
        pgm_function184.set_cpd((3, 1, 0), (0.5, 0.5))
        pgm_function184.set_cpd((0, 2, 0), (0.5, 0.5))
        pgm_function184.set_cpd((1, 2, 0), (0.5, 0.5))
        pgm_function184.set_cpd((2, 2, 0), (0.5, 0.5))
        pgm_function184.set_cpd((3, 2, 0), (0.5, 0.5))
        pgm_function184.set_cpd((0, 3, 0), (0.5, 0.5))
        pgm_function184.set_cpd((1, 3, 0), (0.5, 0.5))
        pgm_function184.set_cpd((2, 3, 0), (0.5, 0.5))
        pgm_function184.set_cpd((3, 3, 0), (0.5, 0.5))
        pgm_function184.set_cpd((0, 4, 0), (0.5, 0.5))
        pgm_function184.set_cpd((1, 4, 0), (0.5, 0.5))
        pgm_function184.set_cpd((2, 4, 0), (0.5, 0.5))
        pgm_function184.set_cpd((3, 4, 0), (0.5, 0.5))
        pgm_function184.set_cpd((0, 0, 1), (0.5, 0.5))
        pgm_function184.set_cpd((1, 0, 1), (0.5, 0.5))
        pgm_function184.set_cpd((2, 0, 1), (0.5, 0.5))
        pgm_function184.set_cpd((3, 0, 1), (0.5, 0.5))
        pgm_function184.set_cpd((0, 1, 1), (0.5, 0.5))
        pgm_function184.set_cpd((1, 1, 1), (0.5, 0.5))
        pgm_function184.set_cpd((2, 1, 1), (0.5, 0.5))
        pgm_function184.set_cpd((3, 1, 1), (0.5, 0.5))
        pgm_function184.set_cpd((0, 2, 1), (0.5, 0.5))
        pgm_function184.set_cpd((1, 2, 1), (0.5, 0.5))
        pgm_function184.set_cpd((2, 2, 1), (0.5, 0.5))
        pgm_function184.set_cpd((3, 2, 1), (0.5, 0.5))
        pgm_function184.set_cpd((0, 3, 1), (0.5, 0.5))
        pgm_function184.set_cpd((1, 3, 1), (0.5, 0.5))
        pgm_function184.set_cpd((2, 3, 1), (0.5, 0.5))
        pgm_function184.set_cpd((3, 3, 1), (0.5, 0.5))
        pgm_function184.set_cpd((0, 4, 1), (0.5, 0.5))
        pgm_function184.set_cpd((1, 4, 1), (0.5, 0.5))
        pgm_function184.set_cpd((2, 4, 1), (0.5, 0.5))
        pgm_function184.set_cpd((3, 4, 1), (0.5, 0.5))
        pgm_function184.set_cpd((0, 0, 2), (0.5, 0.5))
        pgm_function184.set_cpd((1, 0, 2), (0.5, 0.5))
        pgm_function184.set_cpd((2, 0, 2), (0.5, 0.5))
        pgm_function184.set_cpd((3, 0, 2), (0.5, 0.5))
        pgm_function184.set_cpd((0, 1, 2), (0.5, 0.5))
        pgm_function184.set_cpd((1, 1, 2), (0.5, 0.5))
        pgm_function184.set_cpd((2, 1, 2), (0.5, 0.5))
        pgm_function184.set_cpd((3, 1, 2), (0.5, 0.5))
        pgm_function184.set_cpd((0, 2, 2), (0.5, 0.5))
        pgm_function184.set_cpd((1, 2, 2), (0.5, 0.5))
        pgm_function184.set_cpd((2, 2, 2), (0.5, 0.5))
        pgm_function184.set_cpd((3, 2, 2), (0.5, 0.5))
        pgm_function184.set_cpd((0, 3, 2), (0.5, 0.5))
        pgm_function184.set_cpd((1, 3, 2), (0.5, 0.5))
        pgm_function184.set_cpd((2, 3, 2), (0.5, 0.5))
        pgm_function184.set_cpd((3, 3, 2), (0.5, 0.5))
        pgm_function184.set_cpd((0, 4, 2), (0.5, 0.5))
        pgm_function184.set_cpd((1, 4, 2), (0.5, 0.5))
        pgm_function184.set_cpd((2, 4, 2), (0.5, 0.5))
        pgm_function184.set_cpd((3, 4, 2), (0.5, 0.5))
        pgm_function184.set_cpd((0, 0, 3), (0.5, 0.5))
        pgm_function184.set_cpd((1, 0, 3), (0.5, 0.5))
        pgm_function184.set_cpd((2, 0, 3), (0.5, 0.5))
        pgm_function184.set_cpd((3, 0, 3), (0.5, 0.5))
        pgm_function184.set_cpd((0, 1, 3), (0.5, 0.5))
        pgm_function184.set_cpd((1, 1, 3), (0.5, 0.5))
        pgm_function184.set_cpd((2, 1, 3), (0.5, 0.5))
        pgm_function184.set_cpd((3, 1, 3), (0.5, 0.5))
        pgm_function184.set_cpd((0, 2, 3), (0.5, 0.5))
        pgm_function184.set_cpd((1, 2, 3), (0.5, 0.5))
        pgm_function184.set_cpd((2, 2, 3), (0.5, 0.5))
        pgm_function184.set_cpd((3, 2, 3), (0.5, 0.5))
        pgm_function184.set_cpd((0, 3, 3), (0.5, 0.5))
        pgm_function184.set_cpd((1, 3, 3), (0.5, 0.5))
        pgm_function184.set_cpd((2, 3, 3), (0.5, 0.5))
        pgm_function184.set_cpd((3, 3, 3), (0.5, 0.5))
        pgm_function184.set_cpd((0, 4, 3), (0.5, 0.5))
        pgm_function184.set_cpd((1, 4, 3), (0.5, 0.5))
        pgm_function184.set_cpd((2, 4, 3), (0.5, 0.5))
        pgm_function184.set_cpd((3, 4, 3), (0.5, 0.5))
        pgm_factor185 = self.new_factor(DIFFN_DUMMY_3, DIFFN_S_SEV_DIST, DIFFN_PATHO, DIFFN_TIME)
        pgm_function185 = pgm_factor185.set_cpt()
        pgm_function185.set_cpd((0, 0, 0), (0.5, 0.5))
        pgm_function185.set_cpd((1, 0, 0), (0.5, 0.5))
        pgm_function185.set_cpd((2, 0, 0), (0.5, 0.5))
        pgm_function185.set_cpd((3, 0, 0), (0.5, 0.5))
        pgm_function185.set_cpd((0, 1, 0), (0.5, 0.5))
        pgm_function185.set_cpd((1, 1, 0), (0.5, 0.5))
        pgm_function185.set_cpd((2, 1, 0), (0.5, 0.5))
        pgm_function185.set_cpd((3, 1, 0), (0.5, 0.5))
        pgm_function185.set_cpd((0, 2, 0), (0.5, 0.5))
        pgm_function185.set_cpd((1, 2, 0), (0.5, 0.5))
        pgm_function185.set_cpd((2, 2, 0), (0.5, 0.5))
        pgm_function185.set_cpd((3, 2, 0), (0.5, 0.5))
        pgm_function185.set_cpd((0, 3, 0), (0.5, 0.5))
        pgm_function185.set_cpd((1, 3, 0), (0.5, 0.5))
        pgm_function185.set_cpd((2, 3, 0), (0.5, 0.5))
        pgm_function185.set_cpd((3, 3, 0), (0.5, 0.5))
        pgm_function185.set_cpd((0, 4, 0), (0.5, 0.5))
        pgm_function185.set_cpd((1, 4, 0), (0.5, 0.5))
        pgm_function185.set_cpd((2, 4, 0), (0.5, 0.5))
        pgm_function185.set_cpd((3, 4, 0), (0.5, 0.5))
        pgm_function185.set_cpd((0, 0, 1), (0.5, 0.5))
        pgm_function185.set_cpd((1, 0, 1), (0.5, 0.5))
        pgm_function185.set_cpd((2, 0, 1), (0.5, 0.5))
        pgm_function185.set_cpd((3, 0, 1), (0.5, 0.5))
        pgm_function185.set_cpd((0, 1, 1), (0.5, 0.5))
        pgm_function185.set_cpd((1, 1, 1), (0.5, 0.5))
        pgm_function185.set_cpd((2, 1, 1), (0.5, 0.5))
        pgm_function185.set_cpd((3, 1, 1), (0.5, 0.5))
        pgm_function185.set_cpd((0, 2, 1), (0.5, 0.5))
        pgm_function185.set_cpd((1, 2, 1), (0.5, 0.5))
        pgm_function185.set_cpd((2, 2, 1), (0.5, 0.5))
        pgm_function185.set_cpd((3, 2, 1), (0.5, 0.5))
        pgm_function185.set_cpd((0, 3, 1), (0.5, 0.5))
        pgm_function185.set_cpd((1, 3, 1), (0.5, 0.5))
        pgm_function185.set_cpd((2, 3, 1), (0.5, 0.5))
        pgm_function185.set_cpd((3, 3, 1), (0.5, 0.5))
        pgm_function185.set_cpd((0, 4, 1), (0.5, 0.5))
        pgm_function185.set_cpd((1, 4, 1), (0.5, 0.5))
        pgm_function185.set_cpd((2, 4, 1), (0.5, 0.5))
        pgm_function185.set_cpd((3, 4, 1), (0.5, 0.5))
        pgm_function185.set_cpd((0, 0, 2), (0.5, 0.5))
        pgm_function185.set_cpd((1, 0, 2), (0.5, 0.5))
        pgm_function185.set_cpd((2, 0, 2), (0.5, 0.5))
        pgm_function185.set_cpd((3, 0, 2), (0.5, 0.5))
        pgm_function185.set_cpd((0, 1, 2), (0.5, 0.5))
        pgm_function185.set_cpd((1, 1, 2), (0.5, 0.5))
        pgm_function185.set_cpd((2, 1, 2), (0.5, 0.5))
        pgm_function185.set_cpd((3, 1, 2), (0.5, 0.5))
        pgm_function185.set_cpd((0, 2, 2), (0.5, 0.5))
        pgm_function185.set_cpd((1, 2, 2), (0.5, 0.5))
        pgm_function185.set_cpd((2, 2, 2), (0.5, 0.5))
        pgm_function185.set_cpd((3, 2, 2), (0.5, 0.5))
        pgm_function185.set_cpd((0, 3, 2), (0.5, 0.5))
        pgm_function185.set_cpd((1, 3, 2), (0.5, 0.5))
        pgm_function185.set_cpd((2, 3, 2), (0.5, 0.5))
        pgm_function185.set_cpd((3, 3, 2), (0.5, 0.5))
        pgm_function185.set_cpd((0, 4, 2), (0.5, 0.5))
        pgm_function185.set_cpd((1, 4, 2), (0.5, 0.5))
        pgm_function185.set_cpd((2, 4, 2), (0.5, 0.5))
        pgm_function185.set_cpd((3, 4, 2), (0.5, 0.5))
        pgm_function185.set_cpd((0, 0, 3), (0.5, 0.5))
        pgm_function185.set_cpd((1, 0, 3), (0.5, 0.5))
        pgm_function185.set_cpd((2, 0, 3), (0.5, 0.5))
        pgm_function185.set_cpd((3, 0, 3), (0.5, 0.5))
        pgm_function185.set_cpd((0, 1, 3), (0.5, 0.5))
        pgm_function185.set_cpd((1, 1, 3), (0.5, 0.5))
        pgm_function185.set_cpd((2, 1, 3), (0.5, 0.5))
        pgm_function185.set_cpd((3, 1, 3), (0.5, 0.5))
        pgm_function185.set_cpd((0, 2, 3), (0.5, 0.5))
        pgm_function185.set_cpd((1, 2, 3), (0.5, 0.5))
        pgm_function185.set_cpd((2, 2, 3), (0.5, 0.5))
        pgm_function185.set_cpd((3, 2, 3), (0.5, 0.5))
        pgm_function185.set_cpd((0, 3, 3), (0.5, 0.5))
        pgm_function185.set_cpd((1, 3, 3), (0.5, 0.5))
        pgm_function185.set_cpd((2, 3, 3), (0.5, 0.5))
        pgm_function185.set_cpd((3, 3, 3), (0.5, 0.5))
        pgm_function185.set_cpd((0, 4, 3), (0.5, 0.5))
        pgm_function185.set_cpd((1, 4, 3), (0.5, 0.5))
        pgm_function185.set_cpd((2, 4, 3), (0.5, 0.5))
        pgm_function185.set_cpd((3, 4, 3), (0.5, 0.5))
        pgm_factor186 = self.new_factor(R_OTHER_ULND5_DISP)
        pgm_function186 = pgm_factor186.set_cpt()
        pgm_function186.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor187 = self.new_factor(R_DIFFN_ULND5_DISP, DIFFN_S_SEV_DIST, DIFFN_PATHO)
        pgm_function187 = pgm_factor187.set_cpt()
        pgm_function187.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function187.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function187.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function187.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function187.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function187.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0))
        pgm_function187.set_cpd((2, 1), (0.0, 0.5, 0.5, 0.0))
        pgm_function187.set_cpd((3, 1), (0.0, 0.1, 0.5, 0.4))
        pgm_function187.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function187.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function187.set_cpd((2, 2), (0.5, 0.5, 0.0, 0.0))
        pgm_function187.set_cpd((3, 2), (0.0, 0.5, 0.5, 0.0))
        pgm_function187.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function187.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function187.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function187.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function187.set_cpd((0, 4), (0.0, 0.0, 0.0, 1.0))
        pgm_function187.set_cpd((1, 4), (0.0, 0.0, 0.0, 1.0))
        pgm_function187.set_cpd((2, 4), (0.0, 0.0, 0.0, 1.0))
        pgm_function187.set_cpd((3, 4), (0.0, 0.0, 0.0, 1.0))
        pgm_factor188 = self.new_factor(R_LNLE_ULN_SEV)
        pgm_function188 = pgm_factor188.set_cpt()
        pgm_function188.set_cpd((), (0.945, 0.025, 0.015, 0.01, 0.005))
        pgm_factor189 = self.new_factor(R_LNLE_ULN_PATHO)
        pgm_function189 = pgm_factor189.set_cpt()
        pgm_function189.set_cpd((), (0.6, 0.19, 0.2, 0.005, 0.005))
        pgm_factor190 = self.new_factor(R_LNLE_ULND5_DISP_E, R_LNLE_ULN_SEV, R_LNLE_ULN_PATHO)
        pgm_function190 = pgm_factor190.set_cpt()
        pgm_function190.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function190.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function190.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function190.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function190.set_cpd((4, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function190.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function190.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0))
        pgm_function190.set_cpd((2, 1), (0.0, 0.5, 0.5, 0.0))
        pgm_function190.set_cpd((3, 1), (0.0, 0.1, 0.5, 0.4))
        pgm_function190.set_cpd((4, 1), (0.0, 0.0, 0.5, 0.5))
        pgm_function190.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function190.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function190.set_cpd((2, 2), (0.5, 0.5, 0.0, 0.0))
        pgm_function190.set_cpd((3, 2), (0.3, 0.5, 0.2, 0.0))
        pgm_function190.set_cpd((4, 2), (0.0, 0.5, 0.5, 0.0))
        pgm_function190.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function190.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function190.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function190.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function190.set_cpd((4, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function190.set_cpd((0, 4), (0.0, 0.0, 0.0, 1.0))
        pgm_function190.set_cpd((1, 4), (0.0, 0.0, 0.0, 1.0))
        pgm_function190.set_cpd((2, 4), (0.0, 0.0, 0.0, 1.0))
        pgm_function190.set_cpd((3, 4), (0.0, 0.0, 0.0, 1.0))
        pgm_function190.set_cpd((4, 4), (0.0, 0.0, 0.0, 1.0))
        pgm_factor191 = self.new_factor(R_LNLE_DIFFN_ULND5_DISP_E, R_DIFFN_ULND5_DISP, R_LNLE_ULND5_DISP_E)
        pgm_function191 = pgm_factor191.set_cpt()
        pgm_function191.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function191.set_cpd((1, 0), (0.0749, 0.8229, 0.1022, 0.0))
        pgm_function191.set_cpd((2, 0), (0.0, 0.06260626, 0.93739374, 0.0))
        pgm_function191.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function191.set_cpd((0, 1), (0.0749, 0.8229, 0.1022, 0.0))
        pgm_function191.set_cpd((1, 1), (0.0047, 0.1786, 0.8167, 0.0))
        pgm_function191.set_cpd((2, 1), (0.0, 0.019, 0.9795, 0.0015))
        pgm_function191.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function191.set_cpd((0, 2), (0.0, 0.06260626, 0.93739374, 0.0))
        pgm_function191.set_cpd((1, 2), (0.0, 0.019, 0.9795, 0.0015))
        pgm_function191.set_cpd((2, 2), (0.0, 0.0001, 0.0833, 0.9166))
        pgm_function191.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function191.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function191.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function191.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function191.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor192 = self.new_factor(R_ULND5_DISP_E, R_OTHER_ULND5_DISP, R_LNLE_DIFFN_ULND5_DISP_E)
        pgm_function192 = pgm_factor192.set_cpt()
        pgm_function192.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function192.set_cpd((1, 0), (0.0749, 0.8229, 0.1022, 0.0))
        pgm_function192.set_cpd((2, 0), (0.0, 0.06260626, 0.93739374, 0.0))
        pgm_function192.set_cpd((3, 0), (0.0, 0.00790079, 0.60286029, 0.38923892))
        pgm_function192.set_cpd((0, 1), (0.0749, 0.8229, 0.1022, 0.0))
        pgm_function192.set_cpd((1, 1), (0.0047, 0.1786, 0.8167, 0.0))
        pgm_function192.set_cpd((2, 1), (0.0, 0.019, 0.9795, 0.0015))
        pgm_function192.set_cpd((3, 1), (0.0, 0.0001, 0.0069, 0.993))
        pgm_function192.set_cpd((0, 2), (0.0, 0.06260626, 0.93739374, 0.0))
        pgm_function192.set_cpd((1, 2), (0.0, 0.019, 0.9795, 0.0015))
        pgm_function192.set_cpd((2, 2), (0.0, 0.0001, 0.0833, 0.9166))
        pgm_function192.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function192.set_cpd((0, 3), (0.0, 0.00790079, 0.60286029, 0.38923892))
        pgm_function192.set_cpd((1, 3), (0.0, 0.0001, 0.0069, 0.993))
        pgm_function192.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function192.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor193 = self.new_factor(R_LNLW_ULND5_DISP_WD)
        pgm_function193 = pgm_factor193.set_cpt()
        pgm_function193.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor194 = self.new_factor(R_DIFFN_LNLW_ULND5_DISP_WD, R_LNLW_ULND5_DISP_WD, R_DIFFN_ULND5_DISP)
        pgm_function194 = pgm_factor194.set_cpt()
        pgm_function194.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function194.set_cpd((1, 0), (0.0749, 0.8229, 0.1022, 0.0))
        pgm_function194.set_cpd((2, 0), (0.0, 0.06260626, 0.93739374, 0.0))
        pgm_function194.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function194.set_cpd((0, 1), (0.0749, 0.8229, 0.1022, 0.0))
        pgm_function194.set_cpd((1, 1), (0.0047, 0.1786, 0.8167, 0.0))
        pgm_function194.set_cpd((2, 1), (0.0, 0.019, 0.9795, 0.0015))
        pgm_function194.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function194.set_cpd((0, 2), (0.0, 0.06260626, 0.93739374, 0.0))
        pgm_function194.set_cpd((1, 2), (0.0, 0.019, 0.9795, 0.0015))
        pgm_function194.set_cpd((2, 2), (0.0, 0.0001, 0.0833, 0.9166))
        pgm_function194.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function194.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function194.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function194.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function194.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor195 = self.new_factor(R_ULND5_DISP_WD, R_OTHER_ULND5_DISP, R_DIFFN_LNLW_ULND5_DISP_WD)
        pgm_function195 = pgm_factor195.set_cpt()
        pgm_function195.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function195.set_cpd((1, 0), (0.0749, 0.8229, 0.1022, 0.0))
        pgm_function195.set_cpd((2, 0), (0.0, 0.06260626, 0.93739374, 0.0))
        pgm_function195.set_cpd((3, 0), (0.0, 0.00790079, 0.60286029, 0.38923892))
        pgm_function195.set_cpd((0, 1), (0.0749, 0.8229, 0.1022, 0.0))
        pgm_function195.set_cpd((1, 1), (0.0047, 0.1786, 0.8167, 0.0))
        pgm_function195.set_cpd((2, 1), (0.0, 0.019, 0.9795, 0.0015))
        pgm_function195.set_cpd((3, 1), (0.0, 0.0001, 0.0069, 0.993))
        pgm_function195.set_cpd((0, 2), (0.0, 0.06260626, 0.93739374, 0.0))
        pgm_function195.set_cpd((1, 2), (0.0, 0.019, 0.9795, 0.0015))
        pgm_function195.set_cpd((2, 2), (0.0, 0.0001, 0.0833, 0.9166))
        pgm_function195.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function195.set_cpd((0, 3), (0.0, 0.00790079, 0.60286029, 0.38923892))
        pgm_function195.set_cpd((1, 3), (0.0, 0.0001, 0.0069, 0.993))
        pgm_function195.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function195.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor196 = self.new_factor(R_ULND5_DISP_BEW, R_OTHER_ULND5_DISP, R_DIFFN_ULND5_DISP)
        pgm_function196 = pgm_factor196.set_cpt()
        pgm_function196.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function196.set_cpd((1, 0), (0.0749, 0.8229, 0.1022, 0.0))
        pgm_function196.set_cpd((2, 0), (0.0, 0.06260626, 0.93739374, 0.0))
        pgm_function196.set_cpd((3, 0), (0.0, 0.00790079, 0.60286029, 0.38923892))
        pgm_function196.set_cpd((0, 1), (0.0749, 0.8229, 0.1022, 0.0))
        pgm_function196.set_cpd((1, 1), (0.0047, 0.1786, 0.8167, 0.0))
        pgm_function196.set_cpd((2, 1), (0.0, 0.019, 0.9795, 0.0015))
        pgm_function196.set_cpd((3, 1), (0.0, 0.0001, 0.0069, 0.993))
        pgm_function196.set_cpd((0, 2), (0.0, 0.06260626, 0.93739374, 0.0))
        pgm_function196.set_cpd((1, 2), (0.0, 0.019, 0.9795, 0.0015))
        pgm_function196.set_cpd((2, 2), (0.0, 0.0001, 0.0833, 0.9166))
        pgm_function196.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function196.set_cpd((0, 3), (0.0, 0.00790079, 0.60286029, 0.38923892))
        pgm_function196.set_cpd((1, 3), (0.0, 0.0001, 0.0069, 0.993))
        pgm_function196.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function196.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor197 = self.new_factor(R_ULND5_DISP_BED, R_ULND5_DISP_WD, R_ULND5_DISP_BEW)
        pgm_function197 = pgm_factor197.set_cpt()
        pgm_function197.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function197.set_cpd((1, 0), (0.0749, 0.8229, 0.1022, 0.0))
        pgm_function197.set_cpd((2, 0), (0.0, 0.06260626, 0.93739374, 0.0))
        pgm_function197.set_cpd((3, 0), (0.0, 0.0008, 0.0097, 0.9895))
        pgm_function197.set_cpd((0, 1), (0.0749, 0.8229, 0.1022, 0.0))
        pgm_function197.set_cpd((1, 1), (0.0047, 0.1786, 0.8167, 0.0))
        pgm_function197.set_cpd((2, 1), (0.0, 0.019, 0.9795, 0.0015))
        pgm_function197.set_cpd((3, 1), (0.0, 0.0001, 0.0024, 0.9975))
        pgm_function197.set_cpd((0, 2), (0.0, 0.06260626, 0.93739374, 0.0))
        pgm_function197.set_cpd((1, 2), (0.0, 0.019, 0.9795, 0.0015))
        pgm_function197.set_cpd((2, 2), (0.0, 0.0001, 0.0833, 0.9166))
        pgm_function197.set_cpd((3, 2), (0.0, 0.0, 0.0004, 0.9996))
        pgm_function197.set_cpd((0, 3), (0.0, 0.0008, 0.0097, 0.9895))
        pgm_function197.set_cpd((1, 3), (0.0, 0.0001, 0.0024, 0.9975))
        pgm_function197.set_cpd((2, 3), (0.0, 0.0, 0.0004, 0.9996))
        pgm_function197.set_cpd((3, 3), (0.0, 0.0, 0.0002, 0.9998))
        pgm_factor198 = self.new_factor(R_ULND5_DISP_EED, R_ULND5_DISP_E, R_ULND5_DISP_BED)
        pgm_function198 = pgm_factor198.set_cpt()
        pgm_function198.set_cpd((0, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0404, 0.9192, 0.0404, 0.0))
        pgm_function198.set_cpd((1, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0213, 0.9045, 0.0742))
        pgm_function198.set_cpd((2, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.133, 0.867))
        pgm_function198.set_cpd((3, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.133, 0.867))
        pgm_function198.set_cpd((0, 1), (0.0, 0.0, 0.0, 0.0213, 0.9045, 0.0742, 0.0, 0.0, 0.0))
        pgm_function198.set_cpd((1, 1), (0.0, 0.0, 0.0, 0.0, 0.0004, 0.3477, 0.6496, 0.0023, 0.0))
        pgm_function198.set_cpd((2, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00230023, 0.64986499, 0.34783478))
        pgm_function198.set_cpd((3, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.133, 0.867))
        pgm_function198.set_cpd((0, 2), (0.0, 0.0004, 0.3477, 0.6496, 0.0023, 0.0, 0.0, 0.0, 0.0))
        pgm_function198.set_cpd((1, 2), (0.0, 0.0, 0.0, 0.001, 0.499, 0.499, 0.001, 0.0, 0.0))
        pgm_function198.set_cpd((2, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.2215, 0.7732, 0.0052))
        pgm_function198.set_cpd((3, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.133, 0.867))
        pgm_function198.set_cpd((0, 3), (0.4995, 0.4995, 0.001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function198.set_cpd((1, 3), (0.0004, 0.3477, 0.6496, 0.0023, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function198.set_cpd((2, 3), (0.0, 0.0, 0.0213, 0.9045, 0.0742, 0.0, 0.0, 0.0, 0.0))
        pgm_function198.set_cpd((3, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0213, 0.9045, 0.0742))
        pgm_factor199 = self.new_factor(R_OTHER_ULND5_BLOCK)
        pgm_function199 = pgm_factor199.set_cpt()
        pgm_function199.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor200 = self.new_factor(R_DIFFN_ULND5_BLOCK, DIFFN_S_SEV_DIST, DIFFN_PATHO)
        pgm_function200 = pgm_factor200.set_cpt()
        pgm_function200.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function200.set_cpd((1, 0), (0.8, 0.2, 0.0, 0.0, 0.0))
        pgm_function200.set_cpd((2, 0), (0.6, 0.4, 0.0, 0.0, 0.0))
        pgm_function200.set_cpd((3, 0), (0.25, 0.5, 0.25, 0.0, 0.0))
        pgm_function200.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function200.set_cpd((1, 1), (0.2, 0.5, 0.3, 0.0, 0.0))
        pgm_function200.set_cpd((2, 1), (0.0, 0.2, 0.5, 0.3, 0.0))
        pgm_function200.set_cpd((3, 1), (0.0, 0.0, 0.4, 0.5, 0.1))
        pgm_function200.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function200.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function200.set_cpd((2, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function200.set_cpd((3, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function200.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function200.set_cpd((1, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function200.set_cpd((2, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function200.set_cpd((3, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function200.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function200.set_cpd((1, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function200.set_cpd((2, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function200.set_cpd((3, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor201 = self.new_factor(R_LNLE_ULND5_BLOCK_E, R_LNLE_ULN_SEV, R_LNLE_ULN_PATHO)
        pgm_function201 = pgm_factor201.set_cpt()
        pgm_function201.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function201.set_cpd((1, 0), (0.8, 0.2, 0.0, 0.0, 0.0))
        pgm_function201.set_cpd((2, 0), (0.3, 0.6, 0.1, 0.0, 0.0))
        pgm_function201.set_cpd((3, 0), (0.1, 0.5, 0.3, 0.1, 0.0))
        pgm_function201.set_cpd((4, 0), (0.0, 0.05, 0.2, 0.55, 0.2))
        pgm_function201.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function201.set_cpd((1, 1), (0.0, 0.5, 0.5, 0.0, 0.0))
        pgm_function201.set_cpd((2, 1), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function201.set_cpd((3, 1), (0.0, 0.0, 0.2, 0.6, 0.2))
        pgm_function201.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function201.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function201.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function201.set_cpd((2, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function201.set_cpd((3, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function201.set_cpd((4, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function201.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function201.set_cpd((1, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function201.set_cpd((2, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function201.set_cpd((3, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function201.set_cpd((4, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function201.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function201.set_cpd((1, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function201.set_cpd((2, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function201.set_cpd((3, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function201.set_cpd((4, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor202 = self.new_factor(R_LNLE_DIFFN_ULND5_BLOCK_E, R_DIFFN_ULND5_BLOCK, R_LNLE_ULND5_BLOCK_E)
        pgm_function202 = pgm_factor202.set_cpt()
        pgm_function202.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function202.set_cpd((1, 0), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function202.set_cpd((2, 0), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function202.set_cpd((3, 0), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function202.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function202.set_cpd((0, 1), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function202.set_cpd((1, 1), (0.0001, 0.498, 0.5019, 0.0, 0.0))
        pgm_function202.set_cpd((2, 1), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function202.set_cpd((3, 1), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function202.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function202.set_cpd((0, 2), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function202.set_cpd((1, 2), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function202.set_cpd((2, 2), (0.0, 0.0007, 0.4328, 0.5665, 0.0))
        pgm_function202.set_cpd((3, 2), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function202.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function202.set_cpd((0, 3), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function202.set_cpd((1, 3), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function202.set_cpd((2, 3), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function202.set_cpd((3, 3), (0.00030003, 0.00110011, 0.01250125, 0.98609861, 0.0))
        pgm_function202.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function202.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function202.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function202.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function202.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function202.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor203 = self.new_factor(R_ULND5_BLOCK_E, R_OTHER_ULND5_BLOCK, R_LNLE_DIFFN_ULND5_BLOCK_E)
        pgm_function203 = pgm_factor203.set_cpt()
        pgm_function203.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function203.set_cpd((1, 0), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function203.set_cpd((2, 0), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function203.set_cpd((3, 0), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function203.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function203.set_cpd((0, 1), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function203.set_cpd((1, 1), (0.0001, 0.498, 0.5019, 0.0, 0.0))
        pgm_function203.set_cpd((2, 1), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function203.set_cpd((3, 1), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function203.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function203.set_cpd((0, 2), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function203.set_cpd((1, 2), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function203.set_cpd((2, 2), (0.0, 0.0007, 0.4328, 0.5665, 0.0))
        pgm_function203.set_cpd((3, 2), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function203.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function203.set_cpd((0, 3), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function203.set_cpd((1, 3), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function203.set_cpd((2, 3), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function203.set_cpd((3, 3), (0.00030003, 0.00110011, 0.01250125, 0.98609861, 0.0))
        pgm_function203.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function203.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function203.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function203.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function203.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function203.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor204 = self.new_factor(R_ULND5_AMPR_E, R_ULND5_DISP_EED, R_ULND5_BLOCK_E)
        pgm_function204 = pgm_factor204.set_cpt()
        pgm_function204.set_cpd((0, 0), (0.0, 0.0836, 0.9164, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function204.set_cpd((1, 0), (0.0, 0.0, 0.5059, 0.4935, 0.0006, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function204.set_cpd((2, 0), (0.0, 0.0, 0.0, 0.5217, 0.4707, 0.0076, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function204.set_cpd((3, 0), (
            0.0, 0.0, 0.0, 0.00440044, 0.51475148, 0.45034503, 0.02990299, 0.00060006, 0.0, 0.0, 0.0, 0.0))
        pgm_function204.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 0.0235, 0.5025, 0.4068, 0.0644, 0.0027, 0.0001, 0.0, 0.0))
        pgm_function204.set_cpd((5, 0), (
            0.0, 0.0, 0.0, 0.0, 0.00019998, 0.06389361, 0.43315668, 0.40265973, 0.08949105, 0.009999, 0.00059994, 0.0))
        pgm_function204.set_cpd((6, 0),
                                (0.0, 0.0, 0.0, 0.0, 0.0, 0.0026, 0.102, 0.4076, 0.3533, 0.1151, 0.0191, 0.0003))
        pgm_function204.set_cpd((7, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.008, 0.1231, 0.3775, 0.3319, 0.1488, 0.0107))
        pgm_function204.set_cpd((8, 0), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00039996, 0.01909809, 0.17038296, 0.34706529, 0.36056394, 0.10248975))
        pgm_function204.set_cpd((0, 1), (0.0, 0.9893, 0.0107, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function204.set_cpd((1, 1), (0.0, 0.0, 0.9815, 0.0185, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function204.set_cpd((2, 1), (0.0, 0.0, 0.0129, 0.9294, 0.0575, 0.0002, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function204.set_cpd((3, 1), (0.0, 0.0, 0.0, 0.1893, 0.7372, 0.0722, 0.0013, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function204.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0034, 0.3663, 0.5458, 0.0804, 0.004, 0.0001, 0.0, 0.0, 0.0))
        pgm_function204.set_cpd((5, 1), (0.0, 0.0, 0.0, 0.0, 0.0304, 0.4581, 0.4125, 0.092, 0.0066, 0.0004, 0.0, 0.0))
        pgm_function204.set_cpd((6, 1),
                                (0.0, 0.0, 0.0, 0.0, 0.0011, 0.1122, 0.4488, 0.3467, 0.0798, 0.0106, 0.0008, 0.0))
        pgm_function204.set_cpd((7, 1),
                                (0.0, 0.0, 0.0, 0.0, 0.0, 0.0108, 0.1733, 0.4244, 0.2869, 0.0885, 0.0158, 0.0003))
        pgm_function204.set_cpd((8, 1),
                                (0.0, 0.0, 0.0, 0.0, 0.0, 0.0007, 0.0357, 0.2319, 0.3899, 0.2461, 0.0897, 0.006))
        pgm_function204.set_cpd((0, 2), (0.0, 0.9998, 0.0002, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function204.set_cpd((1, 2), (0.0, 0.3122, 0.686, 0.0018, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function204.set_cpd((2, 2), (
            0.0, 0.00070007, 0.89578958, 0.10181018, 0.00170017, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function204.set_cpd((3, 2), (0.0, 0.0, 0.329, 0.6016, 0.067, 0.0023, 0.0001, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function204.set_cpd((4, 2), (0.0, 0.0, 0.0363, 0.6123, 0.3112, 0.0376, 0.0025, 0.0001, 0.0, 0.0, 0.0, 0.0))
        pgm_function204.set_cpd((5, 2),
                                (0.0, 0.0, 0.0025, 0.277, 0.5116, 0.1781, 0.0275, 0.0031, 0.0002, 0.0, 0.0, 0.0))
        pgm_function204.set_cpd((6, 2), (
            0.0, 0.0, 0.00020002, 0.08020802, 0.42864286, 0.35713571, 0.1090109, 0.02180218, 0.00270027, 0.00030003,
            0.0,
            0.0))
        pgm_function204.set_cpd((7, 2), (
            0.0, 0.0, 0.0, 0.01560156, 0.22332233, 0.41834183, 0.24072407, 0.08170817, 0.01670167, 0.00310031,
            0.00050005,
            0.0))
        pgm_function204.set_cpd((8, 2), (
            0.0, 0.0, 0.0, 0.00270027, 0.08970897, 0.33353335, 0.32823282, 0.17421742, 0.05420542, 0.01410141,
            0.00310031,
            0.00020002))
        pgm_function204.set_cpd((0, 3), (0.0, 0.9534, 0.0434, 0.0028, 0.0003, 0.0001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function204.set_cpd((1, 3), (0.0, 0.8829, 0.103, 0.0116, 0.002, 0.0004, 0.0001, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function204.set_cpd((2, 3), (
            0.0, 0.79044191, 0.17256549, 0.02809438, 0.00639872, 0.00169966, 0.0004999, 0.00019996, 9.998e-05, 0.0, 0.0,
            0.0))
        pgm_function204.set_cpd((3, 3), (
            0.0, 0.68976898, 0.23862386, 0.05110511, 0.01390139, 0.00420042, 0.00140014, 0.00060006, 0.00020002,
            0.00010001,
            0.00010001, 0.0))
        pgm_function204.set_cpd((4, 3), (
            0.0, 0.5883, 0.2943, 0.0784, 0.0248, 0.0085, 0.0032, 0.0014, 0.0006, 0.0003, 0.0001, 0.0001))
        pgm_function204.set_cpd((5, 3), (
            0.0, 0.4912, 0.3361, 0.1079, 0.0388, 0.0148, 0.006, 0.0028, 0.0013, 0.0006, 0.0003, 0.0002))
        pgm_function204.set_cpd((6, 3), (
            0.0, 0.408, 0.3613, 0.1352, 0.054, 0.0224, 0.0097, 0.0048, 0.0023, 0.0012, 0.0007, 0.0004))
        pgm_function204.set_cpd((7, 3), (
            0.0, 0.332, 0.3737, 0.1612, 0.0709, 0.0319, 0.0148, 0.0077, 0.0038, 0.002, 0.0012, 0.0008))
        pgm_function204.set_cpd((8, 3), (
            0.0, 0.27137286, 0.3739626, 0.1819818, 0.0869913, 0.04179582, 0.02039796, 0.01109889, 0.00579942,
            0.00319968,
            0.0019998, 0.00139986))
        pgm_function204.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function204.set_cpd((1, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function204.set_cpd((2, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function204.set_cpd((3, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function204.set_cpd((4, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function204.set_cpd((5, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function204.set_cpd((6, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function204.set_cpd((7, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function204.set_cpd((8, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor205 = self.new_factor(R_OTHER_ULND5_LD)
        pgm_function205 = pgm_factor205.set_cpt()
        pgm_function205.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor206 = self.new_factor(R_LNLE_ULND5_LD_E, R_LNLE_ULN_SEV, R_LNLE_ULN_PATHO)
        pgm_function206 = pgm_factor206.set_cpt()
        pgm_function206.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function206.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function206.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function206.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function206.set_cpd((4, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function206.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function206.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0))
        pgm_function206.set_cpd((2, 1), (0.25, 0.5, 0.25, 0.0))
        pgm_function206.set_cpd((3, 1), (0.05, 0.3, 0.5, 0.15))
        pgm_function206.set_cpd((4, 1), (0.25, 0.25, 0.25, 0.25))
        pgm_function206.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function206.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function206.set_cpd((2, 2), (0.5, 0.5, 0.0, 0.0))
        pgm_function206.set_cpd((3, 2), (0.0, 1.0, 0.0, 0.0))
        pgm_function206.set_cpd((4, 2), (0.0, 0.5, 0.5, 0.0))
        pgm_function206.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function206.set_cpd((1, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function206.set_cpd((2, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function206.set_cpd((3, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function206.set_cpd((4, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function206.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function206.set_cpd((1, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function206.set_cpd((2, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function206.set_cpd((3, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function206.set_cpd((4, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_factor207 = self.new_factor(R_ULND5_LD_E, R_OTHER_ULND5_LD, R_LNLE_ULND5_LD_E)
        pgm_function207 = pgm_factor207.set_cpt()
        pgm_function207.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function207.set_cpd((1, 0), (0.0186, 0.9584, 0.023, 0.0))
        pgm_function207.set_cpd((2, 0), (0.0, 0.0184, 0.9816, 0.0))
        pgm_function207.set_cpd((3, 0), (0.0010001, 0.00310031, 0.03020302, 0.96569657))
        pgm_function207.set_cpd((0, 1), (0.0186, 0.9584, 0.023, 0.0))
        pgm_function207.set_cpd((1, 1), (0.0, 0.0304, 0.9696, 0.0))
        pgm_function207.set_cpd((2, 1), (0.0, 0.0013, 0.9987, 0.0))
        pgm_function207.set_cpd((3, 1), (0.00039996, 0.00129987, 0.01409859, 0.98420158))
        pgm_function207.set_cpd((0, 2), (0.0, 0.0184, 0.9816, 0.0))
        pgm_function207.set_cpd((1, 2), (0.0, 0.0013, 0.9987, 0.0))
        pgm_function207.set_cpd((2, 2), (0.0, 0.00029997, 0.99960004, 9.999e-05))
        pgm_function207.set_cpd((3, 2), (0.0001, 0.0005, 0.006, 0.9934))
        pgm_function207.set_cpd((0, 3), (0.0010001, 0.00310031, 0.03020302, 0.96569657))
        pgm_function207.set_cpd((1, 3), (0.00039996, 0.00129987, 0.01409859, 0.98420158))
        pgm_function207.set_cpd((2, 3), (0.0001, 0.0005, 0.006, 0.9934))
        pgm_function207.set_cpd((3, 3), (0.00010001, 0.00030003, 0.00380038, 0.99579958))
        pgm_factor208 = self.new_factor(R_OTHER_ULND5_RD)
        pgm_function208 = pgm_factor208.set_cpt()
        pgm_function208.set_cpd((), (1.0, 0.0, 0.0))
        pgm_factor209 = self.new_factor(R_LNLE_ULND5_RD_E, R_LNLE_ULN_PATHO)
        pgm_function209 = pgm_factor209.set_cpt()
        pgm_function209.set_cpd((0,), (1.0, 0.0, 0.0))
        pgm_function209.set_cpd((1,), (1.0, 0.0, 0.0))
        pgm_function209.set_cpd((2,), (1.0, 0.0, 0.0))
        pgm_function209.set_cpd((3,), (0.0, 0.0, 1.0))
        pgm_function209.set_cpd((4,), (0.0, 1.0, 0.0))
        pgm_factor210 = self.new_factor(R_ULND5_RD_E, R_OTHER_ULND5_RD, R_LNLE_ULND5_RD_E)
        pgm_function210 = pgm_factor210.set_cpt()
        pgm_function210.set_cpd((0, 0), (1.0, 0.0, 0.0))
        pgm_function210.set_cpd((1, 0), (0.0941, 0.9038, 0.0021))
        pgm_function210.set_cpd((2, 0), (0.0677, 0.2563, 0.676))
        pgm_function210.set_cpd((0, 1), (0.0941, 0.9038, 0.0021))
        pgm_function210.set_cpd((1, 1), (0.014, 0.3525, 0.6335))
        pgm_function210.set_cpd((2, 1), (0.0324, 0.1629, 0.8047))
        pgm_function210.set_cpd((0, 2), (0.0677, 0.2563, 0.676))
        pgm_function210.set_cpd((1, 2), (0.0324, 0.1629, 0.8047))
        pgm_function210.set_cpd((2, 2), (0.0351, 0.1479, 0.817))
        pgm_factor211 = self.new_factor(R_ULND5_LSLOW_E, R_ULND5_LD_E, R_ULND5_RD_E)
        pgm_function211 = pgm_factor211.set_cpt()
        pgm_function211.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function211.set_cpd((1, 0), (0.0185, 0.9561, 0.0254, 0.0, 0.0))
        pgm_function211.set_cpd((2, 0), (0.0, 0.0166, 0.9834, 0.0, 0.0))
        pgm_function211.set_cpd((3, 0), (0.0007, 0.002, 0.0219, 0.9754, 0.0))
        pgm_function211.set_cpd((0, 1), (0.00840084, 0.01190119, 0.06190619, 0.91739174, 0.00040004))
        pgm_function211.set_cpd((1, 1), (0.00690069, 0.010001, 0.05350535, 0.92869287, 0.00090009))
        pgm_function211.set_cpd((2, 1), (0.00559944, 0.00829917, 0.04519548, 0.93890611, 0.0019998))
        pgm_function211.set_cpd((3, 1), (0.0023, 0.0036, 0.0217, 0.8326, 0.1398))
        pgm_function211.set_cpd((0, 2), (0.00529947, 0.00619938, 0.02639736, 0.20817918, 0.75392461))
        pgm_function211.set_cpd((1, 2), (0.0049, 0.0057, 0.0244, 0.1966, 0.7684))
        pgm_function211.set_cpd((2, 2), (0.00440044, 0.00520052, 0.02240224, 0.18391839, 0.78407841))
        pgm_function211.set_cpd((3, 2), (0.0028, 0.0033, 0.0145, 0.1304, 0.849))
        pgm_factor212 = self.new_factor(R_OTHER_ULND5_SALOSS)
        pgm_function212 = pgm_factor212.set_cpt()
        pgm_function212.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor213 = self.new_factor(R_LNLW_ULND5_SALOSS)
        pgm_function213 = pgm_factor213.set_cpt()
        pgm_function213.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor214 = self.new_factor(R_DIFFN_ULND5_SALOSS, DIFFN_S_SEV_DIST, DIFFN_PATHO)
        pgm_function214 = pgm_factor214.set_cpt()
        pgm_function214.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function214.set_cpd((1, 0), (0.5, 0.5, 0.0, 0.0, 0.0))
        pgm_function214.set_cpd((2, 0), (0.0, 0.5, 0.5, 0.0, 0.0))
        pgm_function214.set_cpd((3, 0), (0.0, 0.0, 0.0, 0.7, 0.3))
        pgm_function214.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function214.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0, 0.0))
        pgm_function214.set_cpd((2, 1), (0.4, 0.3, 0.3, 0.0, 0.0))
        pgm_function214.set_cpd((3, 1), (0.0, 0.3, 0.5, 0.2, 0.0))
        pgm_function214.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function214.set_cpd((1, 2), (0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function214.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function214.set_cpd((3, 2), (0.0, 0.0, 0.0, 0.7, 0.3))
        pgm_function214.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function214.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function214.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function214.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function214.set_cpd((0, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function214.set_cpd((1, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function214.set_cpd((2, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function214.set_cpd((3, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_factor215 = self.new_factor(R_DIFFN_LNLW_ULND5_SALOSS, R_LNLW_ULND5_SALOSS, R_DIFFN_ULND5_SALOSS)
        pgm_function215 = pgm_factor215.set_cpt()
        pgm_function215.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function215.set_cpd((1, 0), (0.0073, 0.9812, 0.0115, 0.0, 0.0))
        pgm_function215.set_cpd((2, 0), (0.0017, 0.1306, 0.867, 0.0007, 0.0))
        pgm_function215.set_cpd((3, 0), (0.0, 0.0003, 0.0212, 0.9785, 0.0))
        pgm_function215.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function215.set_cpd((0, 1), (0.0073, 0.9812, 0.0115, 0.0, 0.0))
        pgm_function215.set_cpd((1, 1), (0.0, 0.0289, 0.9711, 0.0, 0.0))
        pgm_function215.set_cpd((2, 1), (0.0, 0.0097, 0.5989, 0.3914, 0.0))
        pgm_function215.set_cpd((3, 1), (0.0, 0.0, 0.0017, 0.9983, 0.0))
        pgm_function215.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function215.set_cpd((0, 2), (0.0017, 0.1306, 0.867, 0.0007, 0.0))
        pgm_function215.set_cpd((1, 2), (0.0, 0.0097, 0.5989, 0.3914, 0.0))
        pgm_function215.set_cpd((2, 2), (0.0, 0.00049995, 0.03309669, 0.96640336, 0.0))
        pgm_function215.set_cpd((3, 2), (0.0, 0.0, 0.0008, 0.9992, 0.0))
        pgm_function215.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function215.set_cpd((0, 3), (0.0, 0.0003, 0.0212, 0.9785, 0.0))
        pgm_function215.set_cpd((1, 3), (0.0, 0.0, 0.0017, 0.9983, 0.0))
        pgm_function215.set_cpd((2, 3), (0.0, 0.0, 0.0008, 0.9992, 0.0))
        pgm_function215.set_cpd((3, 3), (0.0, 0.0, 0.0001, 0.9999, 0.0))
        pgm_function215.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function215.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function215.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function215.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function215.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function215.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor216 = self.new_factor(R_LNLE_ULND5_SALOSS, R_LNLE_ULN_SEV, R_LNLE_ULN_PATHO)
        pgm_function216 = pgm_factor216.set_cpt()
        pgm_function216.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function216.set_cpd((1, 0), (0.5, 0.5, 0.0, 0.0, 0.0))
        pgm_function216.set_cpd((2, 0), (0.0, 0.5, 0.5, 0.0, 0.0))
        pgm_function216.set_cpd((3, 0), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function216.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.4, 0.6))
        pgm_function216.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function216.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0, 0.0))
        pgm_function216.set_cpd((2, 1), (0.2, 0.5, 0.3, 0.0, 0.0))
        pgm_function216.set_cpd((3, 1), (0.0, 0.2, 0.5, 0.3, 0.0))
        pgm_function216.set_cpd((4, 1), (0.0, 0.1, 0.4, 0.4, 0.1))
        pgm_function216.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function216.set_cpd((1, 2), (0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function216.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function216.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function216.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function216.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function216.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function216.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function216.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function216.set_cpd((4, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function216.set_cpd((0, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function216.set_cpd((1, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function216.set_cpd((2, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function216.set_cpd((3, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function216.set_cpd((4, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_factor217 = self.new_factor(R_LNLLP_ULND5_SALOSS)
        pgm_function217 = pgm_factor217.set_cpt()
        pgm_function217.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor218 = self.new_factor(R_LNLLP_E_ULND5_SALOSS, R_LNLE_ULND5_SALOSS, R_LNLLP_ULND5_SALOSS)
        pgm_function218 = pgm_factor218.set_cpt()
        pgm_function218.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function218.set_cpd((1, 0), (0.0073, 0.9812, 0.0115, 0.0, 0.0))
        pgm_function218.set_cpd((2, 0), (0.0017, 0.1306, 0.867, 0.0007, 0.0))
        pgm_function218.set_cpd((3, 0), (0.0, 0.0003, 0.0212, 0.9785, 0.0))
        pgm_function218.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function218.set_cpd((0, 1), (0.0073, 0.9812, 0.0115, 0.0, 0.0))
        pgm_function218.set_cpd((1, 1), (0.0, 0.0289, 0.9711, 0.0, 0.0))
        pgm_function218.set_cpd((2, 1), (0.0, 0.0097, 0.5989, 0.3914, 0.0))
        pgm_function218.set_cpd((3, 1), (0.0, 0.0, 0.0017, 0.9983, 0.0))
        pgm_function218.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function218.set_cpd((0, 2), (0.0017, 0.1306, 0.867, 0.0007, 0.0))
        pgm_function218.set_cpd((1, 2), (0.0, 0.0097, 0.5989, 0.3914, 0.0))
        pgm_function218.set_cpd((2, 2), (0.0, 0.00049995, 0.03309669, 0.96640336, 0.0))
        pgm_function218.set_cpd((3, 2), (0.0, 0.0, 0.0008, 0.9992, 0.0))
        pgm_function218.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function218.set_cpd((0, 3), (0.0, 0.0003, 0.0212, 0.9785, 0.0))
        pgm_function218.set_cpd((1, 3), (0.0, 0.0, 0.0017, 0.9983, 0.0))
        pgm_function218.set_cpd((2, 3), (0.0, 0.0, 0.0008, 0.9992, 0.0))
        pgm_function218.set_cpd((3, 3), (0.0, 0.0, 0.0001, 0.9999, 0.0))
        pgm_function218.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function218.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function218.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function218.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function218.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function218.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor219 = self.new_factor(R_LNL_DIFFN_ULND5_SALOSS, R_DIFFN_LNLW_ULND5_SALOSS, R_LNLLP_E_ULND5_SALOSS)
        pgm_function219 = pgm_factor219.set_cpt()
        pgm_function219.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function219.set_cpd((1, 0), (0.0073, 0.9812, 0.0115, 0.0, 0.0))
        pgm_function219.set_cpd((2, 0), (0.0017, 0.1306, 0.867, 0.0007, 0.0))
        pgm_function219.set_cpd((3, 0), (0.0, 0.0003, 0.0212, 0.9785, 0.0))
        pgm_function219.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function219.set_cpd((0, 1), (0.0073, 0.9812, 0.0115, 0.0, 0.0))
        pgm_function219.set_cpd((1, 1), (0.0, 0.0289, 0.9711, 0.0, 0.0))
        pgm_function219.set_cpd((2, 1), (0.0, 0.0097, 0.5989, 0.3914, 0.0))
        pgm_function219.set_cpd((3, 1), (0.0, 0.0, 0.0017, 0.9983, 0.0))
        pgm_function219.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function219.set_cpd((0, 2), (0.0017, 0.1306, 0.867, 0.0007, 0.0))
        pgm_function219.set_cpd((1, 2), (0.0, 0.0097, 0.5989, 0.3914, 0.0))
        pgm_function219.set_cpd((2, 2), (0.0, 0.00049995, 0.03309669, 0.96640336, 0.0))
        pgm_function219.set_cpd((3, 2), (0.0, 0.0, 0.0008, 0.9992, 0.0))
        pgm_function219.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function219.set_cpd((0, 3), (0.0, 0.0003, 0.0212, 0.9785, 0.0))
        pgm_function219.set_cpd((1, 3), (0.0, 0.0, 0.0017, 0.9983, 0.0))
        pgm_function219.set_cpd((2, 3), (0.0, 0.0, 0.0008, 0.9992, 0.0))
        pgm_function219.set_cpd((3, 3), (0.0, 0.0, 0.0001, 0.9999, 0.0))
        pgm_function219.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function219.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function219.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function219.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function219.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function219.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor220 = self.new_factor(R_ULND5_SALOSS, R_OTHER_ULND5_SALOSS, R_LNL_DIFFN_ULND5_SALOSS)
        pgm_function220 = pgm_factor220.set_cpt()
        pgm_function220.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function220.set_cpd((1, 0), (0.0073, 0.9812, 0.0115, 0.0, 0.0))
        pgm_function220.set_cpd((2, 0), (0.0017, 0.1306, 0.867, 0.0007, 0.0))
        pgm_function220.set_cpd((3, 0), (0.0, 0.0003, 0.0212, 0.9785, 0.0))
        pgm_function220.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function220.set_cpd((0, 1), (0.0073, 0.9812, 0.0115, 0.0, 0.0))
        pgm_function220.set_cpd((1, 1), (0.0, 0.0289, 0.9711, 0.0, 0.0))
        pgm_function220.set_cpd((2, 1), (0.0, 0.0097, 0.5989, 0.3914, 0.0))
        pgm_function220.set_cpd((3, 1), (0.0, 0.0, 0.0017, 0.9983, 0.0))
        pgm_function220.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function220.set_cpd((0, 2), (0.0017, 0.1306, 0.867, 0.0007, 0.0))
        pgm_function220.set_cpd((1, 2), (0.0, 0.0097, 0.5989, 0.3914, 0.0))
        pgm_function220.set_cpd((2, 2), (0.0, 0.00049995, 0.03309669, 0.96640336, 0.0))
        pgm_function220.set_cpd((3, 2), (0.0, 0.0, 0.0008, 0.9992, 0.0))
        pgm_function220.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function220.set_cpd((0, 3), (0.0, 0.0003, 0.0212, 0.9785, 0.0))
        pgm_function220.set_cpd((1, 3), (0.0, 0.0, 0.0017, 0.9983, 0.0))
        pgm_function220.set_cpd((2, 3), (0.0, 0.0, 0.0008, 0.9992, 0.0))
        pgm_function220.set_cpd((3, 3), (0.0, 0.0, 0.0001, 0.9999, 0.0))
        pgm_function220.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function220.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function220.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function220.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function220.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function220.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor221 = self.new_factor(R_OTHER_ULND5_DIFSLOW)
        pgm_function221 = pgm_factor221.set_cpt()
        pgm_function221.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor222 = self.new_factor(R_LNLE_ULND5_DIFSLOW, R_LNLE_ULN_PATHO)
        pgm_function222 = pgm_factor222.set_cpt()
        pgm_function222.set_cpd((0,), (1.0, 0.0, 0.0, 0.0))
        pgm_function222.set_cpd((1,), (1.0, 0.0, 0.0, 0.0))
        pgm_function222.set_cpd((2,), (1.0, 0.0, 0.0, 0.0))
        pgm_function222.set_cpd((3,), (0.0, 0.0, 0.0, 1.0))
        pgm_function222.set_cpd((4,), (0.0, 0.0, 1.0, 0.0))
        pgm_factor223 = self.new_factor(R_DIFFN_ULND5_DIFSLOW, DIFFN_S_SEV_DIST, DIFFN_PATHO)
        pgm_function223 = pgm_factor223.set_cpt()
        pgm_function223.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function223.set_cpd((1, 0), (0.0, 0.5, 0.5, 0.0))
        pgm_function223.set_cpd((2, 0), (0.0, 0.2, 0.6, 0.2))
        pgm_function223.set_cpd((3, 0), (0.0, 0.1, 0.6, 0.3))
        pgm_function223.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function223.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0))
        pgm_function223.set_cpd((2, 1), (0.2, 0.4, 0.3, 0.1))
        pgm_function223.set_cpd((3, 1), (0.2, 0.4, 0.3, 0.1))
        pgm_function223.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function223.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function223.set_cpd((2, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function223.set_cpd((3, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function223.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function223.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function223.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function223.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function223.set_cpd((0, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_function223.set_cpd((1, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_function223.set_cpd((2, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_function223.set_cpd((3, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_factor224 = self.new_factor(R_LNLE_DIFFN_ULND5_DIFSLOW_E, R_LNLE_ULND5_DIFSLOW, R_DIFFN_ULND5_DIFSLOW)
        pgm_function224 = pgm_factor224.set_cpt()
        pgm_function224.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function224.set_cpd((1, 0), (0.0127, 0.9867, 0.0006, 0.0))
        pgm_function224.set_cpd((2, 0), (0.0, 0.01810181, 0.98189819, 0.0))
        pgm_function224.set_cpd((3, 0), (0.0, 0.0006, 0.0492, 0.9502))
        pgm_function224.set_cpd((0, 1), (0.0127, 0.9867, 0.0006, 0.0))
        pgm_function224.set_cpd((1, 1), (0.0001, 0.0952, 0.9047, 0.0))
        pgm_function224.set_cpd((2, 1), (0.0, 0.0011, 0.7402, 0.2587))
        pgm_function224.set_cpd((3, 1), (0.0, 0.0, 0.00880088, 0.99119912))
        pgm_function224.set_cpd((0, 2), (0.0, 0.01810181, 0.98189819, 0.0))
        pgm_function224.set_cpd((1, 2), (0.0, 0.0011, 0.7402, 0.2587))
        pgm_function224.set_cpd((2, 2), (0.0, 0.0, 0.004, 0.996))
        pgm_function224.set_cpd((3, 2), (0.0, 0.0, 0.0012, 0.9988))
        pgm_function224.set_cpd((0, 3), (0.0, 0.0006, 0.0492, 0.9502))
        pgm_function224.set_cpd((1, 3), (0.0, 0.0, 0.00880088, 0.99119912))
        pgm_function224.set_cpd((2, 3), (0.0, 0.0, 0.0012, 0.9988))
        pgm_function224.set_cpd((3, 3), (0.0, 0.0, 0.0009, 0.9991))
        pgm_factor225 = self.new_factor(R_ULND5_DIFSLOW_E, R_OTHER_ULND5_DIFSLOW, R_LNLE_DIFFN_ULND5_DIFSLOW_E)
        pgm_function225 = pgm_factor225.set_cpt()
        pgm_function225.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function225.set_cpd((1, 0), (0.0127, 0.9867, 0.0006, 0.0))
        pgm_function225.set_cpd((2, 0), (0.0, 0.01810181, 0.98189819, 0.0))
        pgm_function225.set_cpd((3, 0), (0.0, 0.0006, 0.0492, 0.9502))
        pgm_function225.set_cpd((0, 1), (0.0127, 0.9867, 0.0006, 0.0))
        pgm_function225.set_cpd((1, 1), (0.0001, 0.0952, 0.9047, 0.0))
        pgm_function225.set_cpd((2, 1), (0.0, 0.0011, 0.7402, 0.2587))
        pgm_function225.set_cpd((3, 1), (0.0, 0.0, 0.00880088, 0.99119912))
        pgm_function225.set_cpd((0, 2), (0.0, 0.01810181, 0.98189819, 0.0))
        pgm_function225.set_cpd((1, 2), (0.0, 0.0011, 0.7402, 0.2587))
        pgm_function225.set_cpd((2, 2), (0.0, 0.0, 0.004, 0.996))
        pgm_function225.set_cpd((3, 2), (0.0, 0.0, 0.0012, 0.9988))
        pgm_function225.set_cpd((0, 3), (0.0, 0.0006, 0.0492, 0.9502))
        pgm_function225.set_cpd((1, 3), (0.0, 0.0, 0.00880088, 0.99119912))
        pgm_function225.set_cpd((2, 3), (0.0, 0.0, 0.0012, 0.9988))
        pgm_function225.set_cpd((3, 3), (0.0, 0.0, 0.0009, 0.9991))
        pgm_factor226 = self.new_factor(R_ULND5_DSLOW_E, R_ULND5_SALOSS, R_ULND5_DIFSLOW_E)
        pgm_function226 = pgm_factor226.set_cpt()
        pgm_function226.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function226.set_cpd((1, 0), (0.1036, 0.8964, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function226.set_cpd((2, 0), (0.00059994, 0.99730027, 0.00209979, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function226.set_cpd((3, 0), (0.0001, 0.0629, 0.9278, 0.0092, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function226.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function226.set_cpd((0, 1), (0.0532, 0.2387, 0.495, 0.2072, 0.0059, 0.0, 0.0, 0.0, 0.0))
        pgm_function226.set_cpd((1, 1), (0.01780178, 0.1190119, 0.44814481, 0.38543854, 0.02960296, 0.0, 0.0, 0.0, 0.0))
        pgm_function226.set_cpd((2, 1), (0.0048, 0.0476, 0.3148, 0.5311, 0.1016, 0.0001, 0.0, 0.0, 0.0))
        pgm_function226.set_cpd((3, 1),
                                (0.00060006, 0.00920092, 0.1160116, 0.48574857, 0.38353835, 0.00490049, 0.0, 0.0, 0.0))
        pgm_function226.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function226.set_cpd((0, 2), (0.0007, 0.0063, 0.0614, 0.3006, 0.5524, 0.0781, 0.0005, 0.0, 0.0))
        pgm_function226.set_cpd((1, 2), (0.0002, 0.0021, 0.0283, 0.1995, 0.5939, 0.1737, 0.0023, 0.0, 0.0))
        pgm_function226.set_cpd((2, 2),
                                (0.0, 0.00060006, 0.01140114, 0.11471147, 0.54455446, 0.31963196, 0.00910091, 0.0, 0.0))
        pgm_function226.set_cpd((3, 2),
                                (0.0, 0.00010001, 0.00240024, 0.03740374, 0.33273327, 0.56705671, 0.06030603, 0.0, 0.0))
        pgm_function226.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function226.set_cpd((0, 3), (0.0003, 0.0011, 0.005, 0.0205, 0.087, 0.2822, 0.4514, 0.1525, 0.0))
        pgm_function226.set_cpd((1, 3), (0.0002, 0.0006, 0.0029, 0.0133, 0.0634, 0.2436, 0.4657, 0.2103, 0.0))
        pgm_function226.set_cpd((2, 3), (
            0.00010001, 0.00030003, 0.00170017, 0.00830083, 0.04470447, 0.20312031, 0.46324632, 0.27852785, 0.0))
        pgm_function226.set_cpd((3, 3), (
            0.0, 0.00010001, 0.00070007, 0.00380038, 0.02430243, 0.14161416, 0.4240424, 0.40544054, 0.0))
        pgm_function226.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor227 = self.new_factor(R_ULND5_ALLCV_E, R_ULND5_LSLOW_E, R_ULND5_DSLOW_E)
        pgm_function227 = pgm_factor227.set_cpt()
        pgm_function227.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function227.set_cpd((1, 0), (0.0264, 0.9149, 0.0587, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function227.set_cpd((2, 0), (0.0, 0.0218, 0.9469, 0.0313, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function227.set_cpd((3, 0), (
            0.00030003, 0.00190019, 0.0140014, 0.07880788, 0.32383238, 0.45964596, 0.12121212, 0.00030003, 0.0))
        pgm_function227.set_cpd((4, 0),
                                (0.0, 0.0, 0.00010001, 0.00050005, 0.00410041, 0.03840384, 0.21452145, 0.74237424, 0.0))
        pgm_function227.set_cpd((0, 1), (0.03049695, 0.96720328, 0.00229977, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function227.set_cpd((1, 1), (0.0006, 0.0944, 0.8841, 0.0209, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function227.set_cpd((2, 1), (0.0, 0.0007, 0.2183, 0.779, 0.002, 0.0, 0.0, 0.0, 0.0))
        pgm_function227.set_cpd((3, 1), (
            9.999e-05, 0.00039996, 0.00429957, 0.03209679, 0.19558044, 0.50484952, 0.26037396, 0.00229977, 0.0))
        pgm_function227.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.00020002, 0.00210021, 0.02390239, 0.16481648, 0.8089809, 0.0))
        pgm_function227.set_cpd((0, 2), (0.00039996, 0.06189381, 0.88811119, 0.04959504, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function227.set_cpd((1, 2), (0.0, 0.0018, 0.1956, 0.786, 0.0166, 0.0, 0.0, 0.0, 0.0))
        pgm_function227.set_cpd((2, 2), (0.0, 0.0, 0.0077, 0.4577, 0.5345, 0.0001, 0.0, 0.0, 0.0))
        pgm_function227.set_cpd((3, 2), (0.0, 0.0001, 0.0007, 0.0074, 0.0735, 0.4044, 0.4938, 0.0201, 0.0))
        pgm_function227.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0001, 0.0008, 0.0123, 0.1119, 0.8749, 0.0))
        pgm_function227.set_cpd((0, 3), (0.0, 0.0001, 0.0655, 0.9082, 0.0262, 0.0, 0.0, 0.0, 0.0))
        pgm_function227.set_cpd((1, 3), (0.0, 0.0, 0.0026, 0.2655, 0.7316, 0.0003, 0.0, 0.0, 0.0))
        pgm_function227.set_cpd((2, 3), (0.0, 0.0, 0.0, 0.0166, 0.9182, 0.0652, 0.0, 0.0, 0.0))
        pgm_function227.set_cpd((3, 3), (0.0, 0.0, 0.0001, 0.001, 0.0172, 0.2179, 0.6479, 0.1159, 0.0))
        pgm_function227.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.0003, 0.0055, 0.0699, 0.9243, 0.0))
        pgm_function227.set_cpd((0, 4), (0.0, 0.0, 0.0001, 0.0555, 0.937, 0.0074, 0.0, 0.0, 0.0))
        pgm_function227.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0044, 0.5355, 0.46, 0.0001, 0.0, 0.0))
        pgm_function227.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 0.0398, 0.946, 0.0142, 0.0, 0.0))
        pgm_function227.set_cpd((3, 4), (0.0, 0.0, 0.0, 9.999e-05, 0.00179982, 0.05589441, 0.46005399, 0.48215178, 0.0))
        pgm_function227.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 0.0001, 0.0021, 0.039, 0.9588, 0.0))
        pgm_function227.set_cpd((0, 5), (0.0, 0.0, 0.0, 0.0002, 0.0491, 0.8863, 0.0644, 0.0, 0.0))
        pgm_function227.set_cpd((1, 5), (0.0, 0.0, 0.0, 0.0, 0.0047, 0.5053, 0.49, 0.0, 0.0))
        pgm_function227.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0002, 0.1104, 0.8881, 0.0013, 0.0))
        pgm_function227.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0001, 0.0041, 0.1033, 0.8925, 0.0))
        pgm_function227.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.00069993, 0.01889811, 0.98040196, 0.0))
        pgm_function227.set_cpd((0, 6), (0.0, 0.0, 0.0, 0.0, 0.00029997, 0.09559044, 0.89661034, 0.00749925, 0.0))
        pgm_function227.set_cpd((1, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0218, 0.8352, 0.143, 0.0))
        pgm_function227.set_cpd((2, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.002, 0.3203, 0.6777, 0.0))
        pgm_function227.set_cpd((3, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0003, 0.0194, 0.9803, 0.0))
        pgm_function227.set_cpd((4, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0002, 0.0093, 0.9905, 0.0))
        pgm_function227.set_cpd((0, 7), (
            0.00020002, 0.00060006, 0.00190019, 0.00640064, 0.02470247, 0.09740974, 0.28552855, 0.58325833, 0.0))
        pgm_function227.set_cpd((1, 7), (0.0001, 0.0003, 0.001, 0.0036, 0.0154, 0.0712, 0.2467, 0.6617, 0.0))
        pgm_function227.set_cpd((2, 7), (
            0.0, 0.00010001, 0.00050005, 0.00190019, 0.00930093, 0.05040504, 0.20722072, 0.73057306, 0.0))
        pgm_function227.set_cpd((3, 7), (0.0, 0.0, 0.0001, 0.0004, 0.0026, 0.019, 0.1153, 0.8626, 0.0))
        pgm_function227.set_cpd((4, 7), (0.0, 0.0, 0.0, 0.0001, 0.0006, 0.0062, 0.0562, 0.9369, 0.0))
        pgm_function227.set_cpd((0, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function227.set_cpd((1, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function227.set_cpd((2, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function227.set_cpd((3, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function227.set_cpd((4, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor228 = self.new_factor(R_ULND5_CV_E, R_ULND5_ALLCV_E)
        pgm_function228 = pgm_factor228.set_cpt()
        pgm_function228.set_cpd((0,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.999e-05, 0.0009999, 0.01149885, 0.04829517, 0.13808619,
            0.21487851, 0.24807519, 0.17468253, 0.10678932, 0.05659434))
        pgm_function228.set_cpd((1,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00049995, 0.00729927, 0.03739626, 0.12428757, 0.19878012,
            0.23427657, 0.19878012, 0.12008799, 0.05119488, 0.01989801, 0.00749925))
        pgm_function228.set_cpd((2,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0004, 0.0094, 0.056, 0.1549, 0.2295, 0.2469, 0.1596, 0.0834, 0.0409,
            0.0139, 0.0038, 0.001, 0.0003))
        pgm_function228.set_cpd((3,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0027, 0.0385, 0.174, 0.2983, 0.2508, 0.146, 0.064, 0.0192, 0.0048, 0.0014,
            0.0003, 0.0, 0.0, 0.0))
        pgm_function228.set_cpd((4,), (
            0.0, 0.0, 0.0, 0.0, 0.0002, 0.0226, 0.1786, 0.3397, 0.2748, 0.1364, 0.0366, 0.009, 0.0018, 0.0003, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0))
        pgm_function228.set_cpd((5,), (
            0.0, 0.0, 0.0, 0.0092, 0.1868, 0.4188, 0.2744, 0.089, 0.0178, 0.0035, 0.0004, 0.0001, 0.0, 0.0, 0.0, 0.0,
            0.0,
            0.0, 0.0, 0.0))
        pgm_function228.set_cpd((6,), (
            0.0, 0.0, 0.01789821, 0.42015798, 0.42315768, 0.11728827, 0.0189981, 0.00229977, 0.00019998, 0.0, 0.0, 0.0,
            0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function228.set_cpd((7,), (
            0.0, 0.02639736, 0.78362164, 0.17308269, 0.01579842, 0.0009999, 9.999e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function228.set_cpd((8,), (
            1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor229 = self.new_factor(R_ULND5_DISP_EWD, R_ULND5_DISP_WD, R_ULND5_DISP_BEW)
        pgm_function229 = pgm_factor229.set_cpt()
        pgm_function229.set_cpd((0, 0), (0.0, 0.0, 0.0742, 0.9045, 0.0213, 0.0, 0.0, 0.0, 0.0))
        pgm_function229.set_cpd((1, 0), (0.0, 0.0, 0.0, 0.0, 0.0742, 0.9045, 0.0213, 0.0, 0.0))
        pgm_function229.set_cpd((2, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.133, 0.867))
        pgm_function229.set_cpd((3, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.133, 0.867))
        pgm_function229.set_cpd((0, 1), (0.0001, 0.2215, 0.7732, 0.0052, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function229.set_cpd((1, 1), (0.0, 0.0, 0.0, 0.13151315, 0.85768577, 0.01080108, 0.0, 0.0, 0.0))
        pgm_function229.set_cpd((2, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0108, 0.8577, 0.1315))
        pgm_function229.set_cpd((3, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0108, 0.8577, 0.1315))
        pgm_function229.set_cpd((0, 2), (0.1315, 0.8577, 0.0108, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function229.set_cpd((1, 2), (0.0, 0.0, 0.0742, 0.9045, 0.0213, 0.0, 0.0, 0.0, 0.0))
        pgm_function229.set_cpd((2, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0052, 0.7732, 0.2215, 0.0001))
        pgm_function229.set_cpd((3, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0052, 0.7732, 0.2215, 0.0001))
        pgm_function229.set_cpd((0, 3), (0.9933, 0.0067, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function229.set_cpd((1, 3), (0.0404, 0.9192, 0.0404, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function229.set_cpd((2, 3), (0.0, 0.0, 0.0213, 0.9045, 0.0742, 0.0, 0.0, 0.0, 0.0))
        pgm_function229.set_cpd((3, 3), (0.0, 0.0, 0.0213, 0.9045, 0.0742, 0.0, 0.0, 0.0, 0.0))
        pgm_factor230 = self.new_factor(R_ULND5_BLOCK_EW, R_OTHER_ULND5_BLOCK, R_DIFFN_ULND5_BLOCK)
        pgm_function230 = pgm_factor230.set_cpt()
        pgm_function230.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function230.set_cpd((1, 0), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function230.set_cpd((2, 0), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function230.set_cpd((3, 0), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function230.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function230.set_cpd((0, 1), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function230.set_cpd((1, 1), (0.0001, 0.498, 0.5019, 0.0, 0.0))
        pgm_function230.set_cpd((2, 1), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function230.set_cpd((3, 1), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function230.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function230.set_cpd((0, 2), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function230.set_cpd((1, 2), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function230.set_cpd((2, 2), (0.0, 0.0007, 0.4328, 0.5665, 0.0))
        pgm_function230.set_cpd((3, 2), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function230.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function230.set_cpd((0, 3), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function230.set_cpd((1, 3), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function230.set_cpd((2, 3), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function230.set_cpd((3, 3), (0.00030003, 0.00110011, 0.01250125, 0.98609861, 0.0))
        pgm_function230.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function230.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function230.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function230.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function230.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function230.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor231 = self.new_factor(R_ULND5_AMPR_EW, R_ULND5_DISP_EWD, R_ULND5_BLOCK_EW)
        pgm_function231 = pgm_factor231.set_cpt()
        pgm_function231.set_cpd((0, 0),
                                (0.0, 0.28267173, 0.71642836, 0.00089991, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function231.set_cpd((1, 0), (0.0, 0.0, 0.5547, 0.4268, 0.0183, 0.0002, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function231.set_cpd((2, 0), (
            0.0, 0.0, 0.0090009, 0.51275128, 0.41524152, 0.05890589, 0.00390039, 0.00020002, 0.0, 0.0, 0.0, 0.0))
        pgm_function231.set_cpd((3, 0),
                                (0.0, 0.0, 0.0, 0.0635, 0.4459, 0.3732, 0.0995, 0.0162, 0.0015, 0.0002, 0.0, 0.0))
        pgm_function231.set_cpd((4, 0), (
            0.0, 0.0, 0.0, 0.00290029, 0.11411141, 0.39513951, 0.31983198, 0.13151315, 0.02980298, 0.00580058,
            0.00090009,
            0.0))
        pgm_function231.set_cpd((5, 0),
                                (0.0, 0.0, 0.0, 0.0001, 0.0136, 0.1578, 0.3285, 0.2966, 0.1404, 0.0483, 0.0135, 0.0012))
        pgm_function231.set_cpd((6, 0), (
            0.0, 0.0, 0.0, 0.0, 0.00120024, 0.0385077, 0.17463493, 0.30156031, 0.26135227, 0.14472895, 0.06511302,
            0.01290258))
        pgm_function231.set_cpd((7, 0),
                                (0.0, 0.0, 0.0, 0.0, 0.0001, 0.0062, 0.058, 0.1828, 0.2779, 0.2392, 0.1675, 0.0683))
        pgm_function231.set_cpd((8, 0),
                                (0.0, 0.0, 0.0, 0.0, 0.0, 0.0009, 0.0157, 0.0823, 0.2012, 0.2516, 0.2559, 0.1924))
        pgm_function231.set_cpd((0, 1), (0.0, 0.9103, 0.0897, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function231.set_cpd((1, 1), (0.0, 0.0004, 0.8945, 0.1036, 0.0015, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function231.set_cpd((2, 1), (
            0.0, 0.0, 0.1140114, 0.7169717, 0.15981598, 0.00890089, 0.00030003, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function231.set_cpd((3, 1),
                                (0.0, 0.0, 0.0026, 0.3111, 0.5155, 0.1499, 0.019, 0.0018, 0.0001, 0.0, 0.0, 0.0))
        pgm_function231.set_cpd((4, 1),
                                (0.0, 0.0, 0.0, 0.0451, 0.3717, 0.4039, 0.1433, 0.0313, 0.0041, 0.0005, 0.0001, 0.0))
        pgm_function231.set_cpd((5, 1),
                                (0.0, 0.0, 0.0, 0.0035, 0.1122, 0.3738, 0.3186, 0.1444, 0.0376, 0.0083, 0.0015, 0.0001))
        pgm_function231.set_cpd((6, 1), (
            0.0, 0.0, 0.0, 0.00020002, 0.02260226, 0.1890189, 0.33173317, 0.27442744, 0.12521252, 0.04310431,
            0.01240124,
            0.00130013))
        pgm_function231.set_cpd((7, 1), (
            0.0, 0.0, 0.0, 0.0, 0.00310031, 0.06150615, 0.21092109, 0.30513051, 0.23442344, 0.12171217, 0.05280528,
            0.01040104))
        pgm_function231.set_cpd((8, 1),
                                (0.0, 0.0, 0.0, 0.0, 0.0004, 0.0166, 0.1002, 0.2325, 0.2777, 0.2039, 0.1251, 0.0436))
        pgm_function231.set_cpd((0, 2), (0.0, 0.9974, 0.0026, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function231.set_cpd((1, 2), (0.0, 0.3856, 0.6048, 0.0095, 0.0001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function231.set_cpd((2, 2), (0.0, 0.0073, 0.8191, 0.1638, 0.0095, 0.0003, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function231.set_cpd((3, 2),
                                (0.0, 0.0001, 0.386, 0.4993, 0.1036, 0.0101, 0.0008, 0.0001, 0.0, 0.0, 0.0, 0.0))
        pgm_function231.set_cpd((4, 2),
                                (0.0, 0.0, 0.0913, 0.5259, 0.3027, 0.0681, 0.0104, 0.0014, 0.0002, 0.0, 0.0, 0.0))
        pgm_function231.set_cpd((5, 2), (
            0.0, 0.0, 0.0149985, 0.30686931, 0.42035796, 0.19288071, 0.05119488, 0.01139886, 0.00189981, 0.00029997,
            9.999e-05, 0.0))
        pgm_function231.set_cpd((6, 2),
                                (0.0, 0.0, 0.0023, 0.1333, 0.3728, 0.3075, 0.1292, 0.0421, 0.0099, 0.0024, 0.0005, 0.0))
        pgm_function231.set_cpd((7, 2), (
            0.0, 0.0, 0.00030003, 0.04440444, 0.24132413, 0.34313431, 0.22082208, 0.10251025, 0.03370337, 0.01040104,
            0.0030003, 0.00040004))
        pgm_function231.set_cpd((8, 2),
                                (0.0, 0.0, 0.0, 0.0138, 0.1311, 0.2956, 0.2729, 0.1711, 0.0745, 0.0286, 0.0104, 0.002))
        pgm_function231.set_cpd((0, 3), (
            0.0, 0.94670533, 0.04919508, 0.00349965, 0.00049995, 9.999e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function231.set_cpd((1, 3), (
            0.0, 0.87211279, 0.1109889, 0.01349865, 0.00249975, 0.00059994, 0.00019998, 9.999e-05, 0.0, 0.0, 0.0, 0.0))
        pgm_function231.set_cpd((2, 3), (
            0.0, 0.77825565, 0.18013603, 0.03120624, 0.0075015, 0.0020004, 0.00060012, 0.00020004, 0.00010002, 0.0, 0.0,
            0.0))
        pgm_function231.set_cpd((3, 3), (
            0.0, 0.678, 0.2436, 0.0548, 0.0156, 0.005, 0.0018, 0.0007, 0.0003, 0.0001, 0.0001, 0.0))
        pgm_function231.set_cpd((4, 3), (
            0.0, 0.5789, 0.2957, 0.082, 0.027, 0.0096, 0.0037, 0.0017, 0.0007, 0.0004, 0.0002, 0.0001))
        pgm_function231.set_cpd((5, 3), (
            0.0, 0.485, 0.334, 0.1106, 0.0411, 0.0162, 0.0068, 0.0033, 0.0015, 0.0008, 0.0004, 0.0003))
        pgm_function231.set_cpd((6, 3), (
            0.0, 0.40484048, 0.35663566, 0.13671367, 0.05620562, 0.0240024, 0.01080108, 0.00540054, 0.00270027,
            0.00140014,
            0.00080008, 0.00050005))
        pgm_function231.set_cpd((7, 3), (
            0.0, 0.33163367, 0.36712657, 0.16126775, 0.07268546, 0.0334933, 0.0159968, 0.0084983, 0.00439912,
            0.00239952,
            0.0014997, 0.0009998))
        pgm_function231.set_cpd((8, 3), (
            0.0, 0.2731, 0.3669, 0.1808, 0.0881, 0.0434, 0.0217, 0.012, 0.0064, 0.0036, 0.0023, 0.0017))
        pgm_function231.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function231.set_cpd((1, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function231.set_cpd((2, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function231.set_cpd((3, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function231.set_cpd((4, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function231.set_cpd((5, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function231.set_cpd((6, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function231.set_cpd((7, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function231.set_cpd((8, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor232 = self.new_factor(R_ULND5_DIFSLOW_EW, R_OTHER_ULND5_DIFSLOW, R_DIFFN_ULND5_DIFSLOW)
        pgm_function232 = pgm_factor232.set_cpt()
        pgm_function232.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function232.set_cpd((1, 0), (0.0127, 0.9867, 0.0006, 0.0))
        pgm_function232.set_cpd((2, 0), (0.0, 0.01810181, 0.98189819, 0.0))
        pgm_function232.set_cpd((3, 0), (0.0, 0.0006, 0.0492, 0.9502))
        pgm_function232.set_cpd((0, 1), (0.0127, 0.9867, 0.0006, 0.0))
        pgm_function232.set_cpd((1, 1), (0.0001, 0.0952, 0.9047, 0.0))
        pgm_function232.set_cpd((2, 1), (0.0, 0.0011, 0.7402, 0.2587))
        pgm_function232.set_cpd((3, 1), (0.0, 0.0, 0.00880088, 0.99119912))
        pgm_function232.set_cpd((0, 2), (0.0, 0.01810181, 0.98189819, 0.0))
        pgm_function232.set_cpd((1, 2), (0.0, 0.0011, 0.7402, 0.2587))
        pgm_function232.set_cpd((2, 2), (0.0, 0.0, 0.004, 0.996))
        pgm_function232.set_cpd((3, 2), (0.0, 0.0, 0.0012, 0.9988))
        pgm_function232.set_cpd((0, 3), (0.0, 0.0006, 0.0492, 0.9502))
        pgm_function232.set_cpd((1, 3), (0.0, 0.0, 0.00880088, 0.99119912))
        pgm_function232.set_cpd((2, 3), (0.0, 0.0, 0.0012, 0.9988))
        pgm_function232.set_cpd((3, 3), (0.0, 0.0, 0.0009, 0.9991))
        pgm_factor233 = self.new_factor(R_ULND5_DSLOW_EW, R_ULND5_SALOSS, R_ULND5_DIFSLOW_EW)
        pgm_function233 = pgm_factor233.set_cpt()
        pgm_function233.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function233.set_cpd((1, 0), (0.1036, 0.8964, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function233.set_cpd((2, 0), (0.00059994, 0.99730027, 0.00209979, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function233.set_cpd((3, 0), (0.0001, 0.0629, 0.9278, 0.0092, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function233.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function233.set_cpd((0, 1), (0.0532, 0.2387, 0.495, 0.2072, 0.0059, 0.0, 0.0, 0.0, 0.0))
        pgm_function233.set_cpd((1, 1), (0.01780178, 0.1190119, 0.44814481, 0.38543854, 0.02960296, 0.0, 0.0, 0.0, 0.0))
        pgm_function233.set_cpd((2, 1), (0.0048, 0.0476, 0.3148, 0.5311, 0.1016, 0.0001, 0.0, 0.0, 0.0))
        pgm_function233.set_cpd((3, 1),
                                (0.00060006, 0.00920092, 0.1160116, 0.48574857, 0.38353835, 0.00490049, 0.0, 0.0, 0.0))
        pgm_function233.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function233.set_cpd((0, 2), (0.0007, 0.0063, 0.0614, 0.3006, 0.5524, 0.0781, 0.0005, 0.0, 0.0))
        pgm_function233.set_cpd((1, 2), (0.0002, 0.0021, 0.0283, 0.1995, 0.5939, 0.1737, 0.0023, 0.0, 0.0))
        pgm_function233.set_cpd((2, 2),
                                (0.0, 0.00060006, 0.01140114, 0.11471147, 0.54455446, 0.31963196, 0.00910091, 0.0, 0.0))
        pgm_function233.set_cpd((3, 2),
                                (0.0, 0.00010001, 0.00240024, 0.03740374, 0.33273327, 0.56705671, 0.06030603, 0.0, 0.0))
        pgm_function233.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function233.set_cpd((0, 3), (0.0003, 0.0011, 0.005, 0.0205, 0.087, 0.2822, 0.4514, 0.1525, 0.0))
        pgm_function233.set_cpd((1, 3), (0.0002, 0.0006, 0.0029, 0.0133, 0.0634, 0.2436, 0.4657, 0.2103, 0.0))
        pgm_function233.set_cpd((2, 3), (
            0.00010001, 0.00030003, 0.00170017, 0.00830083, 0.04470447, 0.20312031, 0.46324632, 0.27852785, 0.0))
        pgm_function233.set_cpd((3, 3), (
            0.0, 0.00010001, 0.00070007, 0.00380038, 0.02430243, 0.14161416, 0.4240424, 0.40544054, 0.0))
        pgm_function233.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor234 = self.new_factor(R_ULND5_ALLCV_EW, R_ULND5_DSLOW_EW)
        pgm_function234 = pgm_factor234.set_cpt()
        pgm_function234.set_cpd((0,), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function234.set_cpd((1,), (0.02689731, 0.97130287, 0.00179982, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function234.set_cpd((2,), (0.0003, 0.0598, 0.8924, 0.0475, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function234.set_cpd((3,), (0.0, 0.0001, 0.0637, 0.9111, 0.0251, 0.0, 0.0, 0.0, 0.0))
        pgm_function234.set_cpd((4,), (0.0, 0.0, 0.0001, 0.0544, 0.9384, 0.0071, 0.0, 0.0, 0.0))
        pgm_function234.set_cpd((5,), (0.0, 0.0, 0.0, 0.0002, 0.0486, 0.8875, 0.0637, 0.0, 0.0))
        pgm_function234.set_cpd((6,), (0.0, 0.0, 0.0, 0.0, 0.00020002, 0.0950095, 0.89738974, 0.00740074, 0.0))
        pgm_function234.set_cpd((7,), (
            0.00020002, 0.00060006, 0.00190019, 0.00640064, 0.02470247, 0.09730973, 0.28552855, 0.58335834, 0.0))
        pgm_function234.set_cpd((8,), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor235 = self.new_factor(R_ULND5_CV_EW, R_ULND5_ALLCV_EW)
        pgm_function235 = pgm_factor235.set_cpt()
        pgm_function235.set_cpd((0,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.0019, 0.0226, 0.089, 0.2126, 0.2696, 0.2267,
            0.1139,
            0.0467, 0.0169))
        pgm_function235.set_cpd((1,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00089991, 0.01459854, 0.07029297, 0.19968003, 0.25647435,
            0.22567743, 0.14648535, 0.06149385, 0.01829817, 0.00479952, 0.00129987))
        pgm_function235.set_cpd((2,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00070014, 0.01790358, 0.09681936, 0.22414483, 0.26935387, 0.22234447,
            0.10832166, 0.04080816, 0.01520304, 0.00360072, 0.00070014, 0.00010002, 0.0))
        pgm_function235.set_cpd((3,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00510102, 0.0670134, 0.24964993, 0.33976795, 0.21144229, 0.09141828,
            0.02840568,
            0.0060012, 0.0010002, 0.00020004, 0.0, 0.0, 0.0, 0.0))
        pgm_function235.set_cpd((4,), (
            0.0, 0.0, 0.0, 0.0, 0.00040004, 0.03970397, 0.25872587, 0.37933793, 0.22232223, 0.08110811, 0.01530153,
            0.00270027, 0.00040004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function235.set_cpd((5,), (
            0.0, 0.0, 0.0, 0.0161, 0.2633, 0.4429, 0.2163, 0.0524, 0.0077, 0.0012, 0.0001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0))
        pgm_function235.set_cpd((6,), (
            0.0, 0.0, 0.02939706, 0.51014899, 0.37516248, 0.07529247, 0.00909909, 0.00079992, 9.999e-05, 0.0, 0.0, 0.0,
            0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function235.set_cpd((7,), (
            0.0, 0.0411, 0.82, 0.1295, 0.009, 0.0004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0))
        pgm_function235.set_cpd((8,), (
            1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor236 = self.new_factor(R_LNLW_ULND5_BLOCK_WD)
        pgm_function236 = pgm_factor236.set_cpt()
        pgm_function236.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor237 = self.new_factor(R_DIFFN_LNLW_ULND5_BLOCK_WD, R_LNLW_ULND5_BLOCK_WD, R_DIFFN_ULND5_BLOCK)
        pgm_function237 = pgm_factor237.set_cpt()
        pgm_function237.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function237.set_cpd((1, 0), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function237.set_cpd((2, 0), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function237.set_cpd((3, 0), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function237.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function237.set_cpd((0, 1), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function237.set_cpd((1, 1), (0.0001, 0.498, 0.5019, 0.0, 0.0))
        pgm_function237.set_cpd((2, 1), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function237.set_cpd((3, 1), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function237.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function237.set_cpd((0, 2), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function237.set_cpd((1, 2), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function237.set_cpd((2, 2), (0.0, 0.0007, 0.4328, 0.5665, 0.0))
        pgm_function237.set_cpd((3, 2), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function237.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function237.set_cpd((0, 3), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function237.set_cpd((1, 3), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function237.set_cpd((2, 3), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function237.set_cpd((3, 3), (0.00030003, 0.00110011, 0.01250125, 0.98609861, 0.0))
        pgm_function237.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function237.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function237.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function237.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function237.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function237.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor238 = self.new_factor(R_ULND5_BLOCK_WD, R_OTHER_ULND5_BLOCK, R_DIFFN_LNLW_ULND5_BLOCK_WD)
        pgm_function238 = pgm_factor238.set_cpt()
        pgm_function238.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function238.set_cpd((1, 0), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function238.set_cpd((2, 0), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function238.set_cpd((3, 0), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function238.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function238.set_cpd((0, 1), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function238.set_cpd((1, 1), (0.0001, 0.498, 0.5019, 0.0, 0.0))
        pgm_function238.set_cpd((2, 1), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function238.set_cpd((3, 1), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function238.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function238.set_cpd((0, 2), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function238.set_cpd((1, 2), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function238.set_cpd((2, 2), (0.0, 0.0007, 0.4328, 0.5665, 0.0))
        pgm_function238.set_cpd((3, 2), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function238.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function238.set_cpd((0, 3), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function238.set_cpd((1, 3), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function238.set_cpd((2, 3), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function238.set_cpd((3, 3), (0.00030003, 0.00110011, 0.01250125, 0.98609861, 0.0))
        pgm_function238.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function238.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function238.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function238.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function238.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function238.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor239 = self.new_factor(R_ULND5_EFFAXLOSS, R_ULND5_BLOCK_WD, R_ULND5_SALOSS)
        pgm_function239 = pgm_factor239.set_cpt()
        pgm_function239.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function239.set_cpd((1, 0), (0.0073, 0.9812, 0.0115, 0.0, 0.0))
        pgm_function239.set_cpd((2, 0), (0.0017, 0.1306, 0.867, 0.0007, 0.0))
        pgm_function239.set_cpd((3, 0), (0.0, 0.0003, 0.0212, 0.9785, 0.0))
        pgm_function239.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function239.set_cpd((0, 1), (0.0073, 0.9812, 0.0115, 0.0, 0.0))
        pgm_function239.set_cpd((1, 1), (0.0, 0.0289, 0.9711, 0.0, 0.0))
        pgm_function239.set_cpd((2, 1), (0.0, 0.0097, 0.5989, 0.3914, 0.0))
        pgm_function239.set_cpd((3, 1), (0.0, 0.0, 0.0017, 0.9983, 0.0))
        pgm_function239.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function239.set_cpd((0, 2), (0.0017, 0.1306, 0.867, 0.0007, 0.0))
        pgm_function239.set_cpd((1, 2), (0.0, 0.0097, 0.5989, 0.3914, 0.0))
        pgm_function239.set_cpd((2, 2), (0.0, 0.00049995, 0.03309669, 0.96640336, 0.0))
        pgm_function239.set_cpd((3, 2), (0.0, 0.0, 0.0008, 0.9992, 0.0))
        pgm_function239.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function239.set_cpd((0, 3), (0.0, 0.0003, 0.0212, 0.9785, 0.0))
        pgm_function239.set_cpd((1, 3), (0.0, 0.0, 0.0017, 0.9983, 0.0))
        pgm_function239.set_cpd((2, 3), (0.0, 0.0, 0.0008, 0.9992, 0.0))
        pgm_function239.set_cpd((3, 3), (0.0, 0.0, 0.0001, 0.9999, 0.0))
        pgm_function239.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function239.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function239.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function239.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function239.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function239.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor240 = self.new_factor(R_ULND5_ALLAMP_WD, R_ULND5_DISP_WD, R_ULND5_EFFAXLOSS)
        pgm_function240 = pgm_factor240.set_cpt()
        pgm_function240.set_cpd((0, 0), (0.0, 0.0, 0.0, 0.0, 0.0215, 0.9785))
        pgm_function240.set_cpd((1, 0), (0.0, 0.0, 0.0, 0.3192, 0.6448, 0.036))
        pgm_function240.set_cpd((2, 0), (0.0, 0.0, 0.0051, 0.994, 0.0009, 0.0))
        pgm_function240.set_cpd((3, 0), (0.0, 0.0, 0.9945, 0.0055, 0.0, 0.0))
        pgm_function240.set_cpd((0, 1), (0.0, 0.0, 0.0, 0.3443, 0.6228, 0.0329))
        pgm_function240.set_cpd((1, 1), (0.0, 0.0, 0.04740474, 0.93949395, 0.01290129, 0.00020002))
        pgm_function240.set_cpd((2, 1), (0.0, 0.0, 0.9599, 0.0401, 0.0, 0.0))
        pgm_function240.set_cpd((3, 1), (0.0, 0.0, 0.9999, 0.0001, 0.0, 0.0))
        pgm_function240.set_cpd((0, 2), (0.0, 0.0, 0.0248, 0.9704, 0.0048, 0.0))
        pgm_function240.set_cpd((1, 2), (0.0, 0.0, 0.93309331, 0.06690669, 0.0, 0.0))
        pgm_function240.set_cpd((2, 2), (0.0, 0.0001, 0.9994, 0.0005, 0.0, 0.0))
        pgm_function240.set_cpd((3, 2), (0.0, 0.7508, 0.2492, 0.0, 0.0, 0.0))
        pgm_function240.set_cpd((0, 3), (0.0, 0.1028, 0.8793, 0.0178, 0.0001, 0.0))
        pgm_function240.set_cpd((1, 3), (0.0, 0.8756, 0.1237, 0.0007, 0.0, 0.0))
        pgm_function240.set_cpd((2, 3), (0.0, 0.9969, 0.0031, 0.0, 0.0, 0.0))
        pgm_function240.set_cpd((3, 3), (0.0, 0.9999, 0.0001, 0.0, 0.0, 0.0))
        pgm_function240.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function240.set_cpd((1, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function240.set_cpd((2, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function240.set_cpd((3, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor241 = self.new_factor(R_ULND5_AMP_WD, R_ULND5_ALLAMP_WD)
        pgm_function241 = pgm_factor241.set_cpt()
        pgm_function241.set_cpd((0,), (
            0.75777578, 0.18381838, 0.04520452, 0.01030103, 0.00230023, 0.00050005, 0.00010001, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0))
        pgm_function241.set_cpd((1,), (
            0.37932414, 0.26144771, 0.16726655, 0.09678064, 0.05118976, 0.02539492, 0.01129774, 0.00459908, 0.00179964,
            0.00059988, 0.00019996, 9.998e-05, 0.0, 0.0, 0.0))
        pgm_function241.set_cpd((2,), (
            0.0652, 0.1312, 0.1955, 0.2207, 0.1859, 0.1188, 0.0562, 0.0198, 0.0054, 0.0011, 0.0002, 0.0, 0.0, 0.0, 0.0))
        pgm_function241.set_cpd((3,), (
            0.0, 0.00070007, 0.00550055, 0.02960296, 0.09970997, 0.20582058, 0.27182718, 0.22332233, 0.11711171,
            0.03770377,
            0.00760076, 0.0010001, 0.00010001, 0.0, 0.0))
        pgm_function241.set_cpd((4,), (
            0.0, 0.0, 0.0, 0.00010001, 0.00120012, 0.01070107, 0.05790579, 0.17431743, 0.28932893, 0.27272727,
            0.14271427,
            0.04330433, 0.00710071, 0.00060006, 0.0))
        pgm_function241.set_cpd((5,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.00020002, 0.00370037, 0.03370337, 0.14181418, 0.30313031, 0.31273127, 0.16041604,
            0.03930393, 0.00470047, 0.00030003))
        pgm_factor242 = self.new_factor(R_LNLW_ULND5_LD_WD)
        pgm_function242 = pgm_factor242.set_cpt()
        pgm_function242.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor243 = self.new_factor(R_ULND5_LD_WD, R_OTHER_ULND5_LD, R_LNLW_ULND5_LD_WD)
        pgm_function243 = pgm_factor243.set_cpt()
        pgm_function243.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function243.set_cpd((1, 0), (0.0186, 0.9584, 0.023, 0.0))
        pgm_function243.set_cpd((2, 0), (0.0, 0.0184, 0.9816, 0.0))
        pgm_function243.set_cpd((3, 0), (0.0010001, 0.00310031, 0.03020302, 0.96569657))
        pgm_function243.set_cpd((0, 1), (0.0186, 0.9584, 0.023, 0.0))
        pgm_function243.set_cpd((1, 1), (0.0, 0.0304, 0.9696, 0.0))
        pgm_function243.set_cpd((2, 1), (0.0, 0.0013, 0.9987, 0.0))
        pgm_function243.set_cpd((3, 1), (0.00039996, 0.00129987, 0.01409859, 0.98420158))
        pgm_function243.set_cpd((0, 2), (0.0, 0.0184, 0.9816, 0.0))
        pgm_function243.set_cpd((1, 2), (0.0, 0.0013, 0.9987, 0.0))
        pgm_function243.set_cpd((2, 2), (0.0, 0.00029997, 0.99960004, 9.999e-05))
        pgm_function243.set_cpd((3, 2), (0.0001, 0.0005, 0.006, 0.9934))
        pgm_function243.set_cpd((0, 3), (0.0010001, 0.00310031, 0.03020302, 0.96569657))
        pgm_function243.set_cpd((1, 3), (0.00039996, 0.00129987, 0.01409859, 0.98420158))
        pgm_function243.set_cpd((2, 3), (0.0001, 0.0005, 0.006, 0.9934))
        pgm_function243.set_cpd((3, 3), (0.00010001, 0.00030003, 0.00380038, 0.99579958))
        pgm_factor244 = self.new_factor(R_LNLW_ULND5_RD_WD)
        pgm_function244 = pgm_factor244.set_cpt()
        pgm_function244.set_cpd((), (1.0, 0.0, 0.0))
        pgm_factor245 = self.new_factor(R_ULND5_RD_WD, R_OTHER_ULND5_RD, R_LNLW_ULND5_RD_WD)
        pgm_function245 = pgm_factor245.set_cpt()
        pgm_function245.set_cpd((0, 0), (1.0, 0.0, 0.0))
        pgm_function245.set_cpd((1, 0), (0.0139, 0.9821, 0.004))
        pgm_function245.set_cpd((2, 0), (0.0, 0.0150015, 0.9849985))
        pgm_function245.set_cpd((0, 1), (0.0139, 0.9821, 0.004))
        pgm_function245.set_cpd((1, 1), (0.0002, 0.1057, 0.8941))
        pgm_function245.set_cpd((2, 1), (0.0, 0.0037, 0.9963))
        pgm_function245.set_cpd((0, 2), (0.00070007, 0.09680968, 0.90249025))
        pgm_function245.set_cpd((1, 2), (0.0, 0.01550155, 0.98449845))
        pgm_function245.set_cpd((2, 2), (0.0, 0.003, 0.997))
        pgm_factor246 = self.new_factor(R_ULND5_LSLOW_WD, R_ULND5_LD_WD, R_ULND5_RD_WD)
        pgm_function246 = pgm_factor246.set_cpt()
        pgm_function246.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function246.set_cpd((1, 0), (0.0185, 0.9561, 0.0254, 0.0, 0.0))
        pgm_function246.set_cpd((2, 0), (0.0, 0.0166, 0.9834, 0.0, 0.0))
        pgm_function246.set_cpd((3, 0), (0.0007, 0.002, 0.0219, 0.9754, 0.0))
        pgm_function246.set_cpd((0, 1), (0.0021, 0.0042, 0.0295, 0.9642, 0.0))
        pgm_function246.set_cpd((1, 1), (0.0012, 0.0025, 0.0194, 0.9769, 0.0))
        pgm_function246.set_cpd((2, 1), (0.00069993, 0.00149985, 0.0119988, 0.98580142, 0.0))
        pgm_function246.set_cpd((3, 1), (0.00020002, 0.00050005, 0.00460046, 0.99449945, 0.00020002))
        pgm_function246.set_cpd((0, 2), (0.0001, 0.0002, 0.0014, 0.083, 0.9153))
        pgm_function246.set_cpd((1, 2), (0.0001, 0.0001, 0.0008, 0.0533, 0.9457))
        pgm_function246.set_cpd((2, 2), (0.0, 0.0001, 0.0004, 0.0319, 0.9676))
        pgm_function246.set_cpd((3, 2), (0.0, 0.0, 0.0, 0.00350035, 0.99649965))
        pgm_factor247 = self.new_factor(R_LNLE_DIFFN_ULND5_DIFSLOW_WD, R_LNLE_ULND5_DIFSLOW, R_DIFFN_ULND5_DIFSLOW)
        pgm_function247 = pgm_factor247.set_cpt()
        pgm_function247.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function247.set_cpd((1, 0), (0.0127, 0.9867, 0.0006, 0.0))
        pgm_function247.set_cpd((2, 0), (0.0, 0.01810181, 0.98189819, 0.0))
        pgm_function247.set_cpd((3, 0), (0.0, 0.0006, 0.0492, 0.9502))
        pgm_function247.set_cpd((0, 1), (0.0127, 0.9867, 0.0006, 0.0))
        pgm_function247.set_cpd((1, 1), (0.0001, 0.0952, 0.9047, 0.0))
        pgm_function247.set_cpd((2, 1), (0.0, 0.0011, 0.7402, 0.2587))
        pgm_function247.set_cpd((3, 1), (0.0, 0.0, 0.00880088, 0.99119912))
        pgm_function247.set_cpd((0, 2), (0.0, 0.01810181, 0.98189819, 0.0))
        pgm_function247.set_cpd((1, 2), (0.0, 0.0011, 0.7402, 0.2587))
        pgm_function247.set_cpd((2, 2), (0.0, 0.0, 0.004, 0.996))
        pgm_function247.set_cpd((3, 2), (0.0, 0.0, 0.0012, 0.9988))
        pgm_function247.set_cpd((0, 3), (0.0, 0.0006, 0.0492, 0.9502))
        pgm_function247.set_cpd((1, 3), (0.0, 0.0, 0.00880088, 0.99119912))
        pgm_function247.set_cpd((2, 3), (0.0, 0.0, 0.0012, 0.9988))
        pgm_function247.set_cpd((3, 3), (0.0, 0.0, 0.0009, 0.9991))
        pgm_factor248 = self.new_factor(R_ULND5_DIFSLOW_WD, R_OTHER_ULND5_DIFSLOW, R_LNLE_DIFFN_ULND5_DIFSLOW_WD)
        pgm_function248 = pgm_factor248.set_cpt()
        pgm_function248.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function248.set_cpd((1, 0), (0.0127, 0.9867, 0.0006, 0.0))
        pgm_function248.set_cpd((2, 0), (0.0, 0.01810181, 0.98189819, 0.0))
        pgm_function248.set_cpd((3, 0), (0.0, 0.0006, 0.0492, 0.9502))
        pgm_function248.set_cpd((0, 1), (0.0127, 0.9867, 0.0006, 0.0))
        pgm_function248.set_cpd((1, 1), (0.0001, 0.0952, 0.9047, 0.0))
        pgm_function248.set_cpd((2, 1), (0.0, 0.0011, 0.7402, 0.2587))
        pgm_function248.set_cpd((3, 1), (0.0, 0.0, 0.00880088, 0.99119912))
        pgm_function248.set_cpd((0, 2), (0.0, 0.01810181, 0.98189819, 0.0))
        pgm_function248.set_cpd((1, 2), (0.0, 0.0011, 0.7402, 0.2587))
        pgm_function248.set_cpd((2, 2), (0.0, 0.0, 0.004, 0.996))
        pgm_function248.set_cpd((3, 2), (0.0, 0.0, 0.0012, 0.9988))
        pgm_function248.set_cpd((0, 3), (0.0, 0.0006, 0.0492, 0.9502))
        pgm_function248.set_cpd((1, 3), (0.0, 0.0, 0.00880088, 0.99119912))
        pgm_function248.set_cpd((2, 3), (0.0, 0.0, 0.0012, 0.9988))
        pgm_function248.set_cpd((3, 3), (0.0, 0.0, 0.0009, 0.9991))
        pgm_factor249 = self.new_factor(R_ULND5_DSLOW_WD, R_ULND5_SALOSS, R_ULND5_DIFSLOW_WD)
        pgm_function249 = pgm_factor249.set_cpt()
        pgm_function249.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function249.set_cpd((1, 0), (0.1036, 0.8964, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function249.set_cpd((2, 0), (0.00059994, 0.99730027, 0.00209979, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function249.set_cpd((3, 0), (0.0001, 0.0629, 0.9278, 0.0092, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function249.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function249.set_cpd((0, 1), (0.0532, 0.2387, 0.495, 0.2072, 0.0059, 0.0, 0.0, 0.0, 0.0))
        pgm_function249.set_cpd((1, 1), (0.01780178, 0.1190119, 0.44814481, 0.38543854, 0.02960296, 0.0, 0.0, 0.0, 0.0))
        pgm_function249.set_cpd((2, 1), (0.0048, 0.0476, 0.3148, 0.5311, 0.1016, 0.0001, 0.0, 0.0, 0.0))
        pgm_function249.set_cpd((3, 1),
                                (0.00060006, 0.00920092, 0.1160116, 0.48574857, 0.38353835, 0.00490049, 0.0, 0.0, 0.0))
        pgm_function249.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function249.set_cpd((0, 2), (0.0007, 0.0063, 0.0614, 0.3006, 0.5524, 0.0781, 0.0005, 0.0, 0.0))
        pgm_function249.set_cpd((1, 2), (0.0002, 0.0021, 0.0283, 0.1995, 0.5939, 0.1737, 0.0023, 0.0, 0.0))
        pgm_function249.set_cpd((2, 2),
                                (0.0, 0.00060006, 0.01140114, 0.11471147, 0.54455446, 0.31963196, 0.00910091, 0.0, 0.0))
        pgm_function249.set_cpd((3, 2),
                                (0.0, 0.00010001, 0.00240024, 0.03740374, 0.33273327, 0.56705671, 0.06030603, 0.0, 0.0))
        pgm_function249.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function249.set_cpd((0, 3), (0.0003, 0.0011, 0.005, 0.0205, 0.087, 0.2822, 0.4514, 0.1525, 0.0))
        pgm_function249.set_cpd((1, 3), (0.0002, 0.0006, 0.0029, 0.0133, 0.0634, 0.2436, 0.4657, 0.2103, 0.0))
        pgm_function249.set_cpd((2, 3), (
            0.00010001, 0.00030003, 0.00170017, 0.00830083, 0.04470447, 0.20312031, 0.46324632, 0.27852785, 0.0))
        pgm_function249.set_cpd((3, 3), (
            0.0, 0.00010001, 0.00070007, 0.00380038, 0.02430243, 0.14161416, 0.4240424, 0.40544054, 0.0))
        pgm_function249.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor250 = self.new_factor(R_ULND5_ALLCV_WD, R_ULND5_LSLOW_WD, R_ULND5_DSLOW_WD)
        pgm_function250 = pgm_factor250.set_cpt()
        pgm_function250.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function250.set_cpd((1, 0), (0.02359764, 0.25787421, 0.64033597, 0.07809219, 9.999e-05, 0.0, 0.0, 0.0, 0.0))
        pgm_function250.set_cpd((2, 0), (0.0, 0.0021, 0.1149, 0.7277, 0.1553, 0.0, 0.0, 0.0, 0.0))
        pgm_function250.set_cpd((3, 0), (0.0003, 0.0011, 0.005, 0.0205, 0.087, 0.2822, 0.4514, 0.1525, 0.0))
        pgm_function250.set_cpd((4, 0),
                                (0.0, 0.0, 9.999e-05, 0.00029997, 0.00219978, 0.01919808, 0.12518748, 0.8530147, 0.0))
        pgm_function250.set_cpd((0, 1), (0.03049695, 0.96720328, 0.00229977, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function250.set_cpd((1, 1), (0.0017, 0.0421, 0.4597, 0.4852, 0.0113, 0.0, 0.0, 0.0, 0.0))
        pgm_function250.set_cpd((2, 1), (0.0, 0.0001, 0.0146, 0.3403, 0.6424, 0.0026, 0.0, 0.0, 0.0))
        pgm_function250.set_cpd((3, 1), (
            0.00010002, 0.00040008, 0.00210042, 0.01010202, 0.05161032, 0.21844369, 0.46469294, 0.25255051, 0.0))
        pgm_function250.set_cpd((4, 1),
                                (0.0, 0.0, 0.0, 0.00019998, 0.00139986, 0.01369863, 0.10288971, 0.88181182, 0.0))
        pgm_function250.set_cpd((0, 2), (0.00039996, 0.06189381, 0.88811119, 0.04959504, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function250.set_cpd((1, 2),
                                (0.0, 0.00190019, 0.07490749, 0.56945695, 0.35323532, 0.00050005, 0.0, 0.0, 0.0))
        pgm_function250.set_cpd((2, 2), (0.0, 0.0, 0.0007, 0.0498, 0.764, 0.1854, 0.0001, 0.0, 0.0))
        pgm_function250.set_cpd((3, 2), (
            0.0, 0.00010001, 0.00060006, 0.00340034, 0.02230223, 0.13361336, 0.41454145, 0.42544254, 0.0))
        pgm_function250.set_cpd((4, 2),
                                (0.0, 0.0, 0.0, 0.00010001, 0.00070007, 0.00860086, 0.07820782, 0.91239124, 0.0))
        pgm_function250.set_cpd((0, 3), (0.0, 0.0001, 0.0655, 0.9082, 0.0262, 0.0, 0.0, 0.0, 0.0))
        pgm_function250.set_cpd((1, 3), (0.0, 0.0, 0.00220022, 0.10511051, 0.82518252, 0.06750675, 0.0, 0.0, 0.0))
        pgm_function250.set_cpd((2, 3), (0.0, 0.0, 0.0, 0.0012, 0.137, 0.8421, 0.0197, 0.0, 0.0))
        pgm_function250.set_cpd((3, 3), (0.0, 0.0, 0.0001, 0.0008, 0.0073, 0.0649, 0.3063, 0.6206, 0.0))
        pgm_function250.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.00030003, 0.0050005, 0.05640564, 0.93829383, 0.0))
        pgm_function250.set_cpd((0, 4), (0.0, 0.0, 0.0001, 0.0555, 0.937, 0.0074, 0.0, 0.0, 0.0))
        pgm_function250.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.00220022, 0.170017, 0.80628063, 0.02150215, 0.0, 0.0))
        pgm_function250.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 0.0034, 0.4375, 0.5591, 0.0, 0.0))
        pgm_function250.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.00010001, 0.00160016, 0.02260226, 0.17471747, 0.8009801, 0.0))
        pgm_function250.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 0.0001, 0.0026, 0.0379, 0.9594, 0.0))
        pgm_function250.set_cpd((0, 5), (0.0, 0.0, 0.0, 0.0002, 0.0491, 0.8863, 0.0644, 0.0, 0.0))
        pgm_function250.set_cpd((1, 5), (0.0, 0.0, 0.0, 0.0, 0.00219978, 0.23377662, 0.7620238, 0.0019998, 0.0))
        pgm_function250.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.02080208, 0.80948095, 0.16971697, 0.0))
        pgm_function250.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.00020002, 0.00520052, 0.07260726, 0.9219922, 0.0))
        pgm_function250.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0012, 0.023, 0.9758, 0.0))
        pgm_function250.set_cpd((0, 6), (0.0, 0.0, 0.0, 0.0, 0.00029997, 0.09559044, 0.89661034, 0.00749925, 0.0))
        pgm_function250.set_cpd((1, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.01009899, 0.48945105, 0.50044996, 0.0))
        pgm_function250.set_cpd((2, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.00010001, 0.03920392, 0.96069607, 0.0))
        pgm_function250.set_cpd((3, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.00120012, 0.02960296, 0.96919692, 0.0))
        pgm_function250.set_cpd((4, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0005, 0.014, 0.9855, 0.0))
        pgm_function250.set_cpd((0, 7), (
            0.00020002, 0.00060006, 0.00190019, 0.00640064, 0.02470247, 0.09740974, 0.28552855, 0.58325833, 0.0))
        pgm_function250.set_cpd((1, 7), (0.0001, 0.0002, 0.0007, 0.0026, 0.0117, 0.0585, 0.2222, 0.704, 0.0))
        pgm_function250.set_cpd((2, 7), (0.0, 0.0001, 0.0002, 0.0009, 0.0051, 0.0329, 0.1636, 0.7972, 0.0))
        pgm_function250.set_cpd((3, 7), (0.0, 0.0, 0.0001, 0.0004, 0.0022, 0.0159, 0.0994, 0.882, 0.0))
        pgm_function250.set_cpd((4, 7), (0.0, 0.0, 0.0, 0.0001, 0.0006, 0.0058, 0.0523, 0.9412, 0.0))
        pgm_function250.set_cpd((0, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function250.set_cpd((1, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function250.set_cpd((2, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function250.set_cpd((3, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function250.set_cpd((4, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor251 = self.new_factor(R_ULND5_CV_WD, R_ULND5_ALLCV_WD)
        pgm_function251 = pgm_factor251.set_cpt()
        pgm_function251.set_cpd((0,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00089991, 0.02329767, 0.13318668, 0.31956804,
            0.31956804, 0.1569843, 0.03979602, 0.00669933))
        pgm_function251.set_cpd((1,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00050005, 0.0160016, 0.10241024, 0.2960296, 0.310031,
            0.18081808,
            0.07530753, 0.01620162, 0.00240024, 0.00030003))
        pgm_function251.set_cpd((2,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0005001, 0.0215043, 0.13622725, 0.29945989, 0.29575915, 0.17453491,
            0.05621124, 0.0125025, 0.00290058, 0.00040008, 0.0, 0.0))
        pgm_function251.set_cpd((3,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00520052, 0.09030903, 0.32943294, 0.3650365, 0.15671567, 0.04420442,
            0.0080008,
            0.0010001, 0.00010001, 0.0, 0.0, 0.0, 0.0))
        pgm_function251.set_cpd((4,), (
            0.0, 0.0, 0.0, 0.0, 0.00039996, 0.05179482, 0.33946605, 0.40265973, 0.16188381, 0.0389961, 0.00429957,
            0.00049995, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function251.set_cpd((5,), (
            0.0, 0.0, 0.0, 0.0206, 0.3368, 0.4519, 0.1606, 0.0272, 0.0026, 0.0003, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0,
            0.0))
        pgm_function251.set_cpd((6,), (
            0.0, 0.0, 0.03790379, 0.58865887, 0.32433243, 0.04510451, 0.00380038, 0.00020002, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0,
            0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function251.set_cpd((7,), (
            0.0, 0.05409459, 0.84511549, 0.09569043, 0.00489951, 0.00019998, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0,
            0.0, 0.0, 0.0, 0.0))
        pgm_function251.set_cpd((8,), (
            1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor252 = self.new_factor(R_DIFFN_ULN_BLOCK, DIFFN_M_SEV_DIST, DIFFN_PATHO)
        pgm_function252 = pgm_factor252.set_cpt()
        pgm_function252.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function252.set_cpd((1, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function252.set_cpd((2, 0), (0.6, 0.4, 0.0, 0.0, 0.0))
        pgm_function252.set_cpd((3, 0), (0.25, 0.5, 0.25, 0.0, 0.0))
        pgm_function252.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function252.set_cpd((1, 1), (0.0, 0.5, 0.5, 0.0, 0.0))
        pgm_function252.set_cpd((2, 1), (0.0, 0.5, 0.5, 0.0, 0.0))
        pgm_function252.set_cpd((3, 1), (0.0, 0.0, 0.4, 0.5, 0.1))
        pgm_function252.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function252.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function252.set_cpd((2, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function252.set_cpd((3, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function252.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function252.set_cpd((1, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function252.set_cpd((2, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function252.set_cpd((3, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function252.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function252.set_cpd((1, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function252.set_cpd((2, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function252.set_cpd((3, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor253 = self.new_factor(R_LNLE_ULN_BLOCK, R_LNLE_ULN_SEV, R_LNLE_ULN_PATHO)
        pgm_function253 = pgm_factor253.set_cpt()
        pgm_function253.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function253.set_cpd((1, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function253.set_cpd((2, 0), (0.6, 0.4, 0.0, 0.0, 0.0))
        pgm_function253.set_cpd((3, 0), (0.25, 0.5, 0.25, 0.0, 0.0))
        pgm_function253.set_cpd((4, 0), (0.2, 0.2, 0.2, 0.2, 0.2))
        pgm_function253.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function253.set_cpd((1, 1), (0.0, 0.5, 0.5, 0.0, 0.0))
        pgm_function253.set_cpd((2, 1), (0.0, 0.5, 0.5, 0.0, 0.0))
        pgm_function253.set_cpd((3, 1), (0.0, 0.0, 0.4, 0.5, 0.1))
        pgm_function253.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function253.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function253.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function253.set_cpd((2, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function253.set_cpd((3, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function253.set_cpd((4, 2), (0.2, 0.2, 0.2, 0.2, 0.2))
        pgm_function253.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function253.set_cpd((1, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function253.set_cpd((2, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function253.set_cpd((3, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function253.set_cpd((4, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function253.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function253.set_cpd((1, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function253.set_cpd((2, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function253.set_cpd((3, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function253.set_cpd((4, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor254 = self.new_factor(R_ULN_BLOCK_E, R_DIFFN_ULN_BLOCK, R_LNLE_ULN_BLOCK)
        pgm_function254 = pgm_factor254.set_cpt()
        pgm_function254.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function254.set_cpd((1, 0), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function254.set_cpd((2, 0), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function254.set_cpd((3, 0), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function254.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function254.set_cpd((0, 1), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function254.set_cpd((1, 1), (0.0001, 0.498, 0.5019, 0.0, 0.0))
        pgm_function254.set_cpd((2, 1), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function254.set_cpd((3, 1), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function254.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function254.set_cpd((0, 2), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function254.set_cpd((1, 2), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function254.set_cpd((2, 2), (0.0, 0.0007, 0.4328, 0.5665, 0.0))
        pgm_function254.set_cpd((3, 2), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function254.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function254.set_cpd((0, 3), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function254.set_cpd((1, 3), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function254.set_cpd((2, 3), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function254.set_cpd((3, 3), (0.00030003, 0.00110011, 0.01250125, 0.98609861, 0.0))
        pgm_function254.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function254.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function254.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function254.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function254.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function254.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor255 = self.new_factor(R_ULN_AMPR_E, R_ULN_BLOCK_E)
        pgm_function255 = pgm_factor255.set_cpt()
        pgm_function255.set_cpd((0,), (
            0.09979002, 0.56154385, 0.32036796, 0.01829817, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function255.set_cpd((1,), (
            0.00150015, 0.04260426, 0.31713171, 0.54345435, 0.09460946, 0.00070007, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function255.set_cpd((2,),
                                (0.0001, 0.0013, 0.0088, 0.0471, 0.1949, 0.3924, 0.3113, 0.0438, 0.0003, 0.0, 0.0, 0.0))
        pgm_function255.set_cpd((3,), (
            0.001, 0.0018, 0.0028, 0.0052, 0.0101, 0.0186, 0.0365, 0.0797, 0.171, 0.3425, 0.3308, 0.0))
        pgm_function255.set_cpd((4,), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor256 = self.new_factor(R_OTHER_ADM_MALOSS)
        pgm_function256 = pgm_factor256.set_cpt()
        pgm_function256.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor257 = self.new_factor(R_LNLC8_ADM_MALOSS)
        pgm_function257 = pgm_factor257.set_cpt()
        pgm_function257.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor258 = self.new_factor(R_LNLLP_ADM_MALOSS)
        pgm_function258 = pgm_factor258.set_cpt()
        pgm_function258.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor259 = self.new_factor(R_LNLC8_LP_ADM_MALOSS, R_LNLC8_ADM_MALOSS, R_LNLLP_ADM_MALOSS)
        pgm_function259 = pgm_factor259.set_cpt()
        pgm_function259.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function259.set_cpd((1, 0), (0.0022, 0.9977, 0.0001, 0.0, 0.0))
        pgm_function259.set_cpd((2, 0), (0.00019998, 0.03689631, 0.95880412, 0.00409959, 0.0))
        pgm_function259.set_cpd((3, 0), (0.0, 0.0002, 0.0329, 0.9669, 0.0))
        pgm_function259.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function259.set_cpd((0, 1), (0.0022, 0.9977, 0.0001, 0.0, 0.0))
        pgm_function259.set_cpd((1, 1), (0.0, 0.0282, 0.9718, 0.0, 0.0))
        pgm_function259.set_cpd((2, 1), (0.0, 0.0009, 0.3409, 0.6582, 0.0))
        pgm_function259.set_cpd((3, 1), (0.0, 0.0, 0.0038, 0.9962, 0.0))
        pgm_function259.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function259.set_cpd((0, 2), (0.00019998, 0.03689631, 0.95880412, 0.00409959, 0.0))
        pgm_function259.set_cpd((1, 2), (0.0, 0.0009, 0.3409, 0.6582, 0.0))
        pgm_function259.set_cpd((2, 2), (0.0, 0.0, 0.01, 0.99, 0.0))
        pgm_function259.set_cpd((3, 2), (0.0, 0.0, 0.0011, 0.9989, 0.0))
        pgm_function259.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function259.set_cpd((0, 3), (0.0, 0.0002, 0.0329, 0.9669, 0.0))
        pgm_function259.set_cpd((1, 3), (0.0, 0.0, 0.0038, 0.9962, 0.0))
        pgm_function259.set_cpd((2, 3), (0.0, 0.0, 0.0011, 0.9989, 0.0))
        pgm_function259.set_cpd((3, 3), (0.0, 0.0, 0.0004, 0.9996, 0.0))
        pgm_function259.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function259.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function259.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function259.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function259.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function259.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor260 = self.new_factor(R_LNLE_ADM_MALOSS, R_LNLE_ULN_SEV, R_LNLE_ULN_PATHO)
        pgm_function260 = pgm_factor260.set_cpt()
        pgm_function260.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function260.set_cpd((1, 0), (0.5, 0.5, 0.0, 0.0, 0.0))
        pgm_function260.set_cpd((2, 0), (0.0, 0.5, 0.5, 0.0, 0.0))
        pgm_function260.set_cpd((3, 0), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function260.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.1, 0.9))
        pgm_function260.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function260.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0, 0.0))
        pgm_function260.set_cpd((2, 1), (0.4, 0.3, 0.3, 0.0, 0.0))
        pgm_function260.set_cpd((3, 1), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function260.set_cpd((4, 1), (0.25, 0.25, 0.25, 0.25, 0.0))
        pgm_function260.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function260.set_cpd((1, 2), (0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function260.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function260.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function260.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function260.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function260.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function260.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function260.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function260.set_cpd((4, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function260.set_cpd((0, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function260.set_cpd((1, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function260.set_cpd((2, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function260.set_cpd((3, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function260.set_cpd((4, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_factor261 = self.new_factor(R_LNLC8_LP_E_ADM_MALOSS, R_LNLC8_LP_ADM_MALOSS, R_LNLE_ADM_MALOSS)
        pgm_function261 = pgm_factor261.set_cpt()
        pgm_function261.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function261.set_cpd((1, 0), (0.0022, 0.9977, 0.0001, 0.0, 0.0))
        pgm_function261.set_cpd((2, 0), (0.00019998, 0.03689631, 0.95880412, 0.00409959, 0.0))
        pgm_function261.set_cpd((3, 0), (0.0, 0.0002, 0.0329, 0.9669, 0.0))
        pgm_function261.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function261.set_cpd((0, 1), (0.0022, 0.9977, 0.0001, 0.0, 0.0))
        pgm_function261.set_cpd((1, 1), (0.0, 0.0282, 0.9718, 0.0, 0.0))
        pgm_function261.set_cpd((2, 1), (0.0, 0.0009, 0.3409, 0.6582, 0.0))
        pgm_function261.set_cpd((3, 1), (0.0, 0.0, 0.0038, 0.9962, 0.0))
        pgm_function261.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function261.set_cpd((0, 2), (0.00019998, 0.03689631, 0.95880412, 0.00409959, 0.0))
        pgm_function261.set_cpd((1, 2), (0.0, 0.0009, 0.3409, 0.6582, 0.0))
        pgm_function261.set_cpd((2, 2), (0.0, 0.0, 0.01, 0.99, 0.0))
        pgm_function261.set_cpd((3, 2), (0.0, 0.0, 0.0011, 0.9989, 0.0))
        pgm_function261.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function261.set_cpd((0, 3), (0.0, 0.0002, 0.0329, 0.9669, 0.0))
        pgm_function261.set_cpd((1, 3), (0.0, 0.0, 0.0038, 0.9962, 0.0))
        pgm_function261.set_cpd((2, 3), (0.0, 0.0, 0.0011, 0.9989, 0.0))
        pgm_function261.set_cpd((3, 3), (0.0, 0.0, 0.0004, 0.9996, 0.0))
        pgm_function261.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function261.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function261.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function261.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function261.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function261.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor262 = self.new_factor(R_LNLW_ADM_MALOSS)
        pgm_function262 = pgm_factor262.set_cpt()
        pgm_function262.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor263 = self.new_factor(R_DIFFN_ADM_MALOSS, DIFFN_M_SEV_DIST, DIFFN_PATHO)
        pgm_function263 = pgm_factor263.set_cpt()
        pgm_function263.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function263.set_cpd((1, 0), (0.4, 0.6, 0.0, 0.0, 0.0))
        pgm_function263.set_cpd((2, 0), (0.0, 0.4, 0.6, 0.0, 0.0))
        pgm_function263.set_cpd((3, 0), (0.0, 0.0, 0.4, 0.6, 0.0))
        pgm_function263.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function263.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0, 0.0))
        pgm_function263.set_cpd((2, 1), (0.4, 0.3, 0.3, 0.0, 0.0))
        pgm_function263.set_cpd((3, 1), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function263.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function263.set_cpd((1, 2), (0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function263.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function263.set_cpd((3, 2), (0.0, 0.0, 0.0, 0.8, 0.2))
        pgm_function263.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function263.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function263.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function263.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function263.set_cpd((0, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function263.set_cpd((1, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function263.set_cpd((2, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function263.set_cpd((3, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_factor264 = self.new_factor(R_DIFFN_LNLW_ADM_MALOSS, R_LNLW_ADM_MALOSS, R_DIFFN_ADM_MALOSS)
        pgm_function264 = pgm_factor264.set_cpt()
        pgm_function264.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function264.set_cpd((1, 0), (0.0022, 0.9977, 0.0001, 0.0, 0.0))
        pgm_function264.set_cpd((2, 0), (0.00019998, 0.03689631, 0.95880412, 0.00409959, 0.0))
        pgm_function264.set_cpd((3, 0), (0.0, 0.0002, 0.0329, 0.9669, 0.0))
        pgm_function264.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function264.set_cpd((0, 1), (0.0022, 0.9977, 0.0001, 0.0, 0.0))
        pgm_function264.set_cpd((1, 1), (0.0, 0.0282, 0.9718, 0.0, 0.0))
        pgm_function264.set_cpd((2, 1), (0.0, 0.0009, 0.3409, 0.6582, 0.0))
        pgm_function264.set_cpd((3, 1), (0.0, 0.0, 0.0038, 0.9962, 0.0))
        pgm_function264.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function264.set_cpd((0, 2), (0.00019998, 0.03689631, 0.95880412, 0.00409959, 0.0))
        pgm_function264.set_cpd((1, 2), (0.0, 0.0009, 0.3409, 0.6582, 0.0))
        pgm_function264.set_cpd((2, 2), (0.0, 0.0, 0.01, 0.99, 0.0))
        pgm_function264.set_cpd((3, 2), (0.0, 0.0, 0.0011, 0.9989, 0.0))
        pgm_function264.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function264.set_cpd((0, 3), (0.0, 0.0002, 0.0329, 0.9669, 0.0))
        pgm_function264.set_cpd((1, 3), (0.0, 0.0, 0.0038, 0.9962, 0.0))
        pgm_function264.set_cpd((2, 3), (0.0, 0.0, 0.0011, 0.9989, 0.0))
        pgm_function264.set_cpd((3, 3), (0.0, 0.0, 0.0004, 0.9996, 0.0))
        pgm_function264.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function264.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function264.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function264.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function264.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function264.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor265 = self.new_factor(R_LNL_DIFFN_ADM_MALOSS, R_LNLC8_LP_E_ADM_MALOSS, R_DIFFN_LNLW_ADM_MALOSS)
        pgm_function265 = pgm_factor265.set_cpt()
        pgm_function265.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function265.set_cpd((1, 0), (0.0001, 0.9998, 0.0001, 0.0, 0.0))
        pgm_function265.set_cpd((2, 0), (0.0, 0.0382, 0.9586, 0.0032, 0.0))
        pgm_function265.set_cpd((3, 0), (0.0, 0.0002, 0.042, 0.9578, 0.0))
        pgm_function265.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function265.set_cpd((0, 1), (0.0001, 0.9998, 0.0001, 0.0, 0.0))
        pgm_function265.set_cpd((1, 1), (0.0, 0.0292, 0.9708, 0.0, 0.0))
        pgm_function265.set_cpd((2, 1), (0.0, 0.00110011, 0.39953995, 0.59935994, 0.0))
        pgm_function265.set_cpd((3, 1), (0.0, 0.0, 0.0049, 0.9951, 0.0))
        pgm_function265.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function265.set_cpd((0, 2), (0.0, 0.0382, 0.9586, 0.0032, 0.0))
        pgm_function265.set_cpd((1, 2), (0.0, 0.00110011, 0.39953995, 0.59935994, 0.0))
        pgm_function265.set_cpd((2, 2), (0.0, 0.0, 0.01280128, 0.98719872, 0.0))
        pgm_function265.set_cpd((3, 2), (0.0, 0.0, 0.0014, 0.9986, 0.0))
        pgm_function265.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function265.set_cpd((0, 3), (0.0, 0.0002, 0.042, 0.9578, 0.0))
        pgm_function265.set_cpd((1, 3), (0.0, 0.0, 0.0049, 0.9951, 0.0))
        pgm_function265.set_cpd((2, 3), (0.0, 0.0, 0.0014, 0.9986, 0.0))
        pgm_function265.set_cpd((3, 3), (0.0, 0.0, 0.0005, 0.9995, 0.0))
        pgm_function265.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function265.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function265.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function265.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function265.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function265.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor266 = self.new_factor(R_ADM_MALOSS, R_OTHER_ADM_MALOSS, R_LNL_DIFFN_ADM_MALOSS)
        pgm_function266 = pgm_factor266.set_cpt()
        pgm_function266.set_cpd((0, 0), (0.98, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function266.set_cpd((1, 0), (0.00219978, 0.97770223, 9.999e-05, 0.0, 0.0, 0.019998))
        pgm_function266.set_cpd((2, 0), (0.0002, 0.0471, 0.9297, 0.003, 0.0, 0.02))
        pgm_function266.set_cpd((3, 0), (0.0, 0.0003, 0.0424, 0.9373, 0.0, 0.02))
        pgm_function266.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function266.set_cpd((0, 1), (0.00219978, 0.97770223, 9.999e-05, 0.0, 0.0, 0.019998))
        pgm_function266.set_cpd((1, 1), (0.0, 0.0361, 0.9439, 0.0, 0.0, 0.02))
        pgm_function266.set_cpd((2, 1), (0.0, 0.0014, 0.3987, 0.5799, 0.0, 0.02))
        pgm_function266.set_cpd((3, 1), (0.0, 0.0, 0.005, 0.975, 0.0, 0.02))
        pgm_function266.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function266.set_cpd((0, 2), (0.0002, 0.0471, 0.9297, 0.003, 0.0, 0.02))
        pgm_function266.set_cpd((1, 2), (0.0, 0.0014, 0.3987, 0.5799, 0.0, 0.02))
        pgm_function266.set_cpd((2, 2), (0.0, 0.0, 0.013, 0.967, 0.0, 0.02))
        pgm_function266.set_cpd((3, 2), (0.0, 0.0, 0.0014, 0.9786, 0.0, 0.02))
        pgm_function266.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function266.set_cpd((0, 3), (0.0, 0.0003, 0.0424, 0.9373, 0.0, 0.02))
        pgm_function266.set_cpd((1, 3), (0.0, 0.0, 0.005, 0.975, 0.0, 0.02))
        pgm_function266.set_cpd((2, 3), (0.0, 0.0, 0.0014, 0.9786, 0.0, 0.02))
        pgm_function266.set_cpd((3, 3), (0.0, 0.0, 0.0005, 0.9795, 0.0, 0.02))
        pgm_function266.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function266.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function266.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function266.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function266.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function266.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_factor267 = self.new_factor(R_LNLE_ULN_DIFSLOW, R_LNLE_ULN_PATHO)
        pgm_function267 = pgm_factor267.set_cpt()
        pgm_function267.set_cpd((0,), (1.0, 0.0, 0.0, 0.0))
        pgm_function267.set_cpd((1,), (1.0, 0.0, 0.0, 0.0))
        pgm_function267.set_cpd((2,), (1.0, 0.0, 0.0, 0.0))
        pgm_function267.set_cpd((3,), (0.0, 0.0, 0.0, 1.0))
        pgm_function267.set_cpd((4,), (0.0, 0.0, 1.0, 0.0))
        pgm_factor268 = self.new_factor(R_DIFFN_ULN_DIFSLOW, DIFFN_M_SEV_DIST, DIFFN_PATHO)
        pgm_function268 = pgm_factor268.set_cpt()
        pgm_function268.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function268.set_cpd((1, 0), (0.0, 0.5, 0.5, 0.0))
        pgm_function268.set_cpd((2, 0), (0.0, 0.2, 0.6, 0.2))
        pgm_function268.set_cpd((3, 0), (0.0, 0.2, 0.6, 0.2))
        pgm_function268.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function268.set_cpd((1, 1), (0.4, 0.5, 0.1, 0.0))
        pgm_function268.set_cpd((2, 1), (0.2, 0.4, 0.3, 0.1))
        pgm_function268.set_cpd((3, 1), (0.2, 0.4, 0.3, 0.1))
        pgm_function268.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function268.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function268.set_cpd((2, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function268.set_cpd((3, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function268.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function268.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function268.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function268.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function268.set_cpd((0, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_function268.set_cpd((1, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_function268.set_cpd((2, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_function268.set_cpd((3, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_factor269 = self.new_factor(R_ULN_DIFSLOW_E, R_LNLE_ULN_DIFSLOW, R_DIFFN_ULN_DIFSLOW)
        pgm_function269 = pgm_factor269.set_cpt()
        pgm_function269.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function269.set_cpd((1, 0), (0.01319868, 0.98620138, 0.00059994, 0.0))
        pgm_function269.set_cpd((2, 0), (0.0, 0.01810181, 0.98189819, 0.0))
        pgm_function269.set_cpd((3, 0), (0.0, 0.0003, 0.0252, 0.9745))
        pgm_function269.set_cpd((0, 1), (0.01319868, 0.98620138, 0.00059994, 0.0))
        pgm_function269.set_cpd((1, 1), (0.0001, 0.0952, 0.9047, 0.0))
        pgm_function269.set_cpd((2, 1), (0.0, 0.0009, 0.588, 0.4111))
        pgm_function269.set_cpd((3, 1), (0.0, 0.0, 0.00440044, 0.99559956))
        pgm_function269.set_cpd((0, 2), (0.0, 0.01810181, 0.98189819, 0.0))
        pgm_function269.set_cpd((1, 2), (0.0, 0.0009, 0.588, 0.4111))
        pgm_function269.set_cpd((2, 2), (0.0, 0.0, 0.002, 0.998))
        pgm_function269.set_cpd((3, 2), (0.0, 0.0, 0.0006, 0.9994))
        pgm_function269.set_cpd((0, 3), (0.0, 0.0003, 0.0252, 0.9745))
        pgm_function269.set_cpd((1, 3), (0.0, 0.0, 0.00440044, 0.99559956))
        pgm_function269.set_cpd((2, 3), (0.0, 0.0, 0.0006, 0.9994))
        pgm_function269.set_cpd((3, 3), (0.0, 0.0, 0.0005, 0.9995))
        pgm_factor270 = self.new_factor(R_ULN_DCV_E, R_ADM_MALOSS, R_ULN_DIFSLOW_E)
        pgm_function270 = pgm_factor270.set_cpt()
        pgm_function270.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function270.set_cpd((1, 0), (0.109, 0.8903, 0.0007, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function270.set_cpd((2, 0), (0.0039996, 0.11438856, 0.86211379, 0.01949805, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function270.set_cpd((3, 0), (0.0001, 0.0028, 0.064, 0.9243, 0.0088, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function270.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function270.set_cpd((5, 0), (0.0835, 0.1153, 0.2417, 0.3746, 0.1682, 0.0167, 0.0, 0.0, 0.0, 0.0))
        pgm_function270.set_cpd((0, 1),
                                (0.00410041, 0.02470247, 0.15461546, 0.7389739, 0.07760776, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function270.set_cpd((1, 1), (0.0011, 0.0082, 0.0683, 0.7087, 0.2135, 0.0002, 0.0, 0.0, 0.0, 0.0))
        pgm_function270.set_cpd((2, 1), (
            9.999e-05, 0.00079992, 0.0089991, 0.3029697, 0.66543346, 0.02169783, 0.0, 0.0, 0.0, 0.0))
        pgm_function270.set_cpd((3, 1), (0.0, 0.0, 0.0006, 0.0547, 0.6199, 0.3247, 0.0001, 0.0, 0.0, 0.0))
        pgm_function270.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function270.set_cpd((5, 1), (
            0.00929907, 0.01809819, 0.05459454, 0.22767723, 0.39336066, 0.27757224, 0.01929807, 9.999e-05, 0.0, 0.0))
        pgm_function270.set_cpd((0, 2), (0.0004, 0.0012, 0.0055, 0.0628, 0.295, 0.5485, 0.0861, 0.0005, 0.0, 0.0))
        pgm_function270.set_cpd((1, 2), (
            0.00020002, 0.00050005, 0.00280028, 0.03890389, 0.23092309, 0.5829583, 0.14221422, 0.00150015, 0.0, 0.0))
        pgm_function270.set_cpd((2, 2), (
            0.0, 0.00010001, 0.00060006, 0.01230123, 0.11291129, 0.52725273, 0.33553355, 0.01130113, 0.0, 0.0))
        pgm_function270.set_cpd((3, 2), (
            0.0, 0.0, 9.999e-05, 0.00249975, 0.0359964, 0.32406759, 0.5710429, 0.06629337, 0.0, 0.0))
        pgm_function270.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function270.set_cpd((5, 2), (
            0.00059994, 0.00119988, 0.00419958, 0.02839716, 0.11488851, 0.35756424, 0.39636036, 0.09639036, 0.00039996,
            0.0))
        pgm_function270.set_cpd((0, 3), (
            0.0, 9.999e-05, 0.00019998, 0.00189981, 0.01069893, 0.06579342, 0.28457154, 0.50544946, 0.13128687, 0.0))
        pgm_function270.set_cpd((1, 3), (
            0.0, 0.0, 0.00010001, 0.00120012, 0.00750075, 0.0510051, 0.25242524, 0.51855186, 0.16921692, 0.0))
        pgm_function270.set_cpd((2, 3), (0.0, 0.0, 0.0, 0.0005, 0.0034, 0.028, 0.1822, 0.5098, 0.2761, 0.0))
        pgm_function270.set_cpd((3, 3), (
            0.0, 0.0, 0.0, 0.00010001, 0.00120012, 0.01250125, 0.11181118, 0.44524452, 0.42914291, 0.0))
        pgm_function270.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function270.set_cpd((5, 3), (0.0, 0.0, 0.0002, 0.0011, 0.0056, 0.033, 0.1653, 0.4414, 0.3534, 0.0))
        pgm_factor271 = self.new_factor(R_ULN_LD_EW, R_LNLE_ULN_SEV, R_LNLE_ULN_PATHO)
        pgm_function271 = pgm_factor271.set_cpt()
        pgm_function271.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function271.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function271.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function271.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function271.set_cpd((4, 0), (0.25, 0.25, 0.25, 0.25))
        pgm_function271.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function271.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0))
        pgm_function271.set_cpd((2, 1), (0.25, 0.5, 0.25, 0.0))
        pgm_function271.set_cpd((3, 1), (0.05, 0.3, 0.5, 0.15))
        pgm_function271.set_cpd((4, 1), (0.25, 0.25, 0.25, 0.25))
        pgm_function271.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function271.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function271.set_cpd((2, 2), (0.5, 0.5, 0.0, 0.0))
        pgm_function271.set_cpd((3, 2), (0.0, 1.0, 0.0, 0.0))
        pgm_function271.set_cpd((4, 2), (0.25, 0.25, 0.25, 0.25))
        pgm_function271.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function271.set_cpd((1, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function271.set_cpd((2, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function271.set_cpd((3, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function271.set_cpd((4, 3), (0.25, 0.25, 0.25, 0.25))
        pgm_function271.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function271.set_cpd((1, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function271.set_cpd((2, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function271.set_cpd((3, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function271.set_cpd((4, 4), (0.25, 0.25, 0.25, 0.25))
        pgm_factor272 = self.new_factor(R_ULN_RD_EW, R_LNLE_ULN_PATHO)
        pgm_function272 = pgm_factor272.set_cpt()
        pgm_function272.set_cpd((0,), (1.0, 0.0, 0.0))
        pgm_function272.set_cpd((1,), (1.0, 0.0, 0.0))
        pgm_function272.set_cpd((2,), (1.0, 0.0, 0.0))
        pgm_function272.set_cpd((3,), (0.0, 0.0, 1.0))
        pgm_function272.set_cpd((4,), (0.0, 1.0, 0.0))
        pgm_factor273 = self.new_factor(R_ULN_RDLDCV_E, R_ULN_LD_EW, R_ULN_RD_EW)
        pgm_function273 = pgm_factor273.set_cpt()
        pgm_function273.set_cpd((0, 0), (0.90449045, 0.09530953, 0.00020002, 0.0, 0.0, 0.0))
        pgm_function273.set_cpd((1, 0), (0.132, 0.6039, 0.2641, 0.0, 0.0, 0.0))
        pgm_function273.set_cpd((2, 0), (0.0139, 0.1839, 0.8022, 0.0, 0.0, 0.0))
        pgm_function273.set_cpd((3, 0), (0.00120012, 0.00670067, 0.05440544, 0.86008601, 0.07760776, 0.0))
        pgm_function273.set_cpd((0, 1), (0.0115, 0.0333, 0.1509, 0.7319, 0.0724, 0.0))
        pgm_function273.set_cpd((1, 1), (0.00340034, 0.01220122, 0.0690069, 0.71967197, 0.19531953, 0.00040004))
        pgm_function273.set_cpd((2, 1), (0.0011, 0.0045, 0.0299, 0.5742, 0.3876, 0.0027))
        pgm_function273.set_cpd((3, 1), (0.0001, 0.0002, 0.0018, 0.0914, 0.6093, 0.2972))
        pgm_function273.set_cpd((0, 2), (0.0, 9.999e-05, 0.00109989, 0.14618538, 0.8070193, 0.04559544))
        pgm_function273.set_cpd((1, 2), (0.0, 0.0, 0.0002, 0.0581, 0.795, 0.1467))
        pgm_function273.set_cpd((2, 2), (0.0, 0.0, 0.0001, 0.0228, 0.6344, 0.3427))
        pgm_function273.set_cpd((3, 2), (0.0, 0.0, 0.0, 0.0014, 0.1063, 0.8923))
        pgm_factor274 = self.new_factor(R_ULN_ALLCV_E, R_ULN_DCV_E, R_ULN_RDLDCV_E)
        pgm_function274 = pgm_factor274.set_cpt()
        pgm_function274.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function274.set_cpd((1, 0), (0.3684, 0.6316, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function274.set_cpd((2, 0), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function274.set_cpd((3, 0), (0.00089991, 0.08959104, 0.8260174, 0.08349165, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function274.set_cpd((4, 0), (0.0, 0.0005, 0.1011, 0.8478, 0.0506, 0.0, 0.0, 0.0, 0.0))
        pgm_function274.set_cpd((5, 0), (0.0, 0.0, 0.00050005, 0.07910791, 0.90019002, 0.02020202, 0.0, 0.0, 0.0))
        pgm_function274.set_cpd((6, 0), (0.0, 0.0, 0.0, 0.0006, 0.0734, 0.8393, 0.0867, 0.0, 0.0))
        pgm_function274.set_cpd((7, 0), (0.0, 0.0, 0.0, 0.0, 0.00030003, 0.09470947, 0.89458946, 0.01040104, 0.0))
        pgm_function274.set_cpd((8, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.002, 0.0932, 0.9048, 0.0))
        pgm_function274.set_cpd((9, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.9999))
        pgm_function274.set_cpd((0, 1), (0.0077, 0.9808, 0.0115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function274.set_cpd((1, 1), (0.0005, 0.4476, 0.5519, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function274.set_cpd((2, 1), (0.0, 0.0239, 0.9751, 0.001, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function274.set_cpd((3, 1), (0.0, 0.0036, 0.2468, 0.734, 0.0156, 0.0, 0.0, 0.0, 0.0))
        pgm_function274.set_cpd((4, 1), (0.0, 0.0, 0.005, 0.3134, 0.6811, 0.0005, 0.0, 0.0, 0.0))
        pgm_function274.set_cpd((5, 1), (0.0, 0.0, 0.0, 0.00710071, 0.54935494, 0.44334433, 0.00020002, 0.0, 0.0))
        pgm_function274.set_cpd((6, 1), (0.0, 0.0, 0.0, 0.0, 0.00910091, 0.52835284, 0.46254625, 0.0, 0.0))
        pgm_function274.set_cpd((7, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0216, 0.8359, 0.1425, 0.0))
        pgm_function274.set_cpd((8, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0004, 0.0355, 0.9641, 0.0))
        pgm_function274.set_cpd((9, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.9999))
        pgm_function274.set_cpd((0, 2), (0.0, 0.0047, 0.9951, 0.0002, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function274.set_cpd((1, 2), (0.0, 0.0004, 0.9005, 0.0991, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function274.set_cpd((2, 2), (0.0, 0.0, 0.1288, 0.8712, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function274.set_cpd((3, 2), (0.0, 0.0, 0.01130113, 0.57115712, 0.41754175, 0.0, 0.0, 0.0, 0.0))
        pgm_function274.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0214, 0.9354, 0.0432, 0.0, 0.0, 0.0))
        pgm_function274.set_cpd((5, 2), (0.0, 0.0, 0.0, 9.999e-05, 0.05649435, 0.93230677, 0.01109889, 0.0, 0.0))
        pgm_function274.set_cpd((6, 2), (0.0, 0.0, 0.0, 0.0, 0.0004, 0.143, 0.8551, 0.0015, 0.0))
        pgm_function274.set_cpd((7, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0019998, 0.3548645, 0.6431357, 0.0))
        pgm_function274.set_cpd((8, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.0122, 0.9877, 0.0))
        pgm_function274.set_cpd((9, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.9999))
        pgm_function274.set_cpd((0, 3), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function274.set_cpd((1, 3), (0.0, 0.0, 0.0, 0.0, 0.997, 0.003, 0.0, 0.0, 0.0))
        pgm_function274.set_cpd((2, 3), (0.0, 0.0, 0.0, 0.0, 0.2336, 0.7664, 0.0, 0.0, 0.0))
        pgm_function274.set_cpd((3, 3), (0.0, 0.0, 0.0, 0.0, 0.00259974, 0.99340066, 0.0039996, 0.0, 0.0))
        pgm_function274.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.2469, 0.7531, 0.0, 0.0))
        pgm_function274.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.002, 0.9939, 0.0041, 0.0))
        pgm_function274.set_cpd((6, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0314, 0.9686, 0.0))
        pgm_function274.set_cpd((7, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0002, 0.9998, 0.0))
        pgm_function274.set_cpd((8, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0003, 0.9997, 0.0))
        pgm_function274.set_cpd((9, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function274.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 0.0012, 0.1305, 0.8445, 0.0238, 0.0))
        pgm_function274.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 0.0004, 0.074, 0.8589, 0.0667, 0.0))
        pgm_function274.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 0.00010001, 0.03730373, 0.80288029, 0.15971597, 0.0))
        pgm_function274.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.007, 0.3517, 0.6413, 0.0))
        pgm_function274.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0003, 0.0581, 0.9416, 0.0))
        pgm_function274.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.006, 0.994, 0.0))
        pgm_function274.set_cpd((6, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0008, 0.9992, 0.0))
        pgm_function274.set_cpd((7, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.9999, 0.0))
        pgm_function274.set_cpd((8, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0002, 0.9998, 0.0))
        pgm_function274.set_cpd((9, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function274.set_cpd((0, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0002, 0.0321, 0.9677, 0.0))
        pgm_function274.set_cpd((1, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.0184, 0.9815, 0.0))
        pgm_function274.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.01010101, 0.98989899, 0.0))
        pgm_function274.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0042, 0.9958, 0.0))
        pgm_function274.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0011, 0.9989, 0.0))
        pgm_function274.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0003, 0.9997, 0.0))
        pgm_function274.set_cpd((6, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.9999, 0.0))
        pgm_function274.set_cpd((7, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function274.set_cpd((8, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.9999, 0.0))
        pgm_function274.set_cpd((9, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor275 = self.new_factor(R_ULN_CV_E, R_ULN_ALLCV_E)
        pgm_function275 = pgm_factor275.set_cpt()
        pgm_function275.set_cpd((0,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00019998, 0.00389961, 0.02769723, 0.09749025,
            0.19478052,
            0.24787521, 0.21837816, 0.1389861, 0.07069293))
        pgm_function275.set_cpd((1,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.003, 0.01, 0.0587, 0.1638, 0.2511, 0.2403, 0.1583, 0.0769,
            0.0289, 0.009))
        pgm_function275.set_cpd((2,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00150015, 0.01940194, 0.150015, 0.19211921, 0.23642364, 0.19571957,
            0.11781178, 0.05550555, 0.02160216, 0.00720072, 0.00210021, 0.00060006))
        pgm_function275.set_cpd((3,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.0071, 0.0718, 0.2193, 0.2934, 0.2297, 0.1165, 0.0443, 0.0134, 0.0034,
            0.0008,
            0.0002, 0.0, 0.0))
        pgm_function275.set_cpd((4,), (
            0.0, 0.0, 0.0, 0.0, 0.00110011, 0.0450045, 0.23122312, 0.36273627, 0.25722572, 0.06290629, 0.03110311,
            0.00710071, 0.00140014, 0.00020002, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function275.set_cpd((5,), (
            0.0, 0.0, 0.0, 0.01690169, 0.23672367, 0.41364136, 0.23552355, 0.07760776, 0.01770177, 0.00130013,
            0.00050005,
            0.00010001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function275.set_cpd((6,), (
            0.0, 0.0, 0.02410241, 0.45734573, 0.40054005, 0.10241024, 0.0140014, 0.00150015, 0.00010001, 0.0, 0.0, 0.0,
            0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function275.set_cpd((7,), (
            0.0, 0.1031, 0.7506, 0.1328, 0.0124, 0.001, 0.0001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0))
        pgm_function275.set_cpd((8,), (
            0.9999, 0.0001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor276 = self.new_factor(R_ULN_BLOCK_EW, R_DIFFN_ULN_BLOCK)
        pgm_function276 = pgm_factor276.set_cpt()
        pgm_function276.set_cpd((0,), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function276.set_cpd((1,), (0.0038, 0.9962, 0.0, 0.0, 0.0))
        pgm_function276.set_cpd((2,), (0.0007, 0.0223, 0.977, 0.0, 0.0))
        pgm_function276.set_cpd((3,), (0.0019, 0.006, 0.0587, 0.9334, 0.0))
        pgm_function276.set_cpd((4,), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor277 = self.new_factor(R_ULN_AMPR_EW, R_ULN_BLOCK_EW)
        pgm_function277 = pgm_factor277.set_cpt()
        pgm_function277.set_cpd((0,), (0.0289, 0.2833, 0.517, 0.1684, 0.0024, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function277.set_cpd((1,), (0.0004, 0.0135, 0.1503, 0.5078, 0.3123, 0.0157, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function277.set_cpd((2,), (
            0.0, 0.0005001, 0.0040008, 0.02460492, 0.12742549, 0.34006801, 0.40008002, 0.10172034, 0.00160032, 0.0, 0.0,
            0.0))
        pgm_function277.set_cpd((3,), (
            0.00079992, 0.00139986, 0.00219978, 0.00419958, 0.00819918, 0.01549845, 0.03119688, 0.07079292, 0.15858414,
            0.33926607, 0.36786321, 0.0))
        pgm_function277.set_cpd((4,), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor278 = self.new_factor(R_ULN_DIFSLOW_EW, R_DIFFN_ULN_DIFSLOW)
        pgm_function278 = pgm_factor278.set_cpt()
        pgm_function278.set_cpd((0,), (1.0, 0.0, 0.0, 0.0))
        pgm_function278.set_cpd((1,), (0.0126, 0.9869, 0.0005, 0.0))
        pgm_function278.set_cpd((2,), (0.0, 0.0179, 0.9821, 0.0))
        pgm_function278.set_cpd((3,), (0.0, 0.0003, 0.0252, 0.9745))
        pgm_factor279 = self.new_factor(R_ULN_DCV_EW, R_ADM_MALOSS, R_ULN_DIFSLOW_EW)
        pgm_function279 = pgm_factor279.set_cpt()
        pgm_function279.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function279.set_cpd((1, 0), (0.109, 0.8903, 0.0007, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function279.set_cpd((2, 0), (0.0039996, 0.11438856, 0.86211379, 0.01949805, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function279.set_cpd((3, 0), (0.0001, 0.0028, 0.064, 0.9243, 0.0088, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function279.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function279.set_cpd((5, 0), (0.0835, 0.1153, 0.2417, 0.3746, 0.1682, 0.0167, 0.0, 0.0, 0.0, 0.0))
        pgm_function279.set_cpd((0, 1),
                                (0.00410041, 0.02470247, 0.15461546, 0.7389739, 0.07760776, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function279.set_cpd((1, 1), (0.0011, 0.0082, 0.0683, 0.7087, 0.2135, 0.0002, 0.0, 0.0, 0.0, 0.0))
        pgm_function279.set_cpd((2, 1), (
            9.999e-05, 0.00079992, 0.0089991, 0.3029697, 0.66543346, 0.02169783, 0.0, 0.0, 0.0, 0.0))
        pgm_function279.set_cpd((3, 1), (0.0, 0.0, 0.0006, 0.0547, 0.6199, 0.3247, 0.0001, 0.0, 0.0, 0.0))
        pgm_function279.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function279.set_cpd((5, 1), (
            0.00929907, 0.01809819, 0.05459454, 0.22767723, 0.39336066, 0.27757224, 0.01929807, 9.999e-05, 0.0, 0.0))
        pgm_function279.set_cpd((0, 2), (0.0004, 0.0012, 0.0055, 0.0628, 0.295, 0.5485, 0.0861, 0.0005, 0.0, 0.0))
        pgm_function279.set_cpd((1, 2), (
            0.00020002, 0.00050005, 0.00280028, 0.03890389, 0.23092309, 0.5829583, 0.14221422, 0.00150015, 0.0, 0.0))
        pgm_function279.set_cpd((2, 2), (
            0.0, 0.00010001, 0.00060006, 0.01230123, 0.11291129, 0.52725273, 0.33553355, 0.01130113, 0.0, 0.0))
        pgm_function279.set_cpd((3, 2), (
            0.0, 0.0, 9.999e-05, 0.00249975, 0.0359964, 0.32406759, 0.5710429, 0.06629337, 0.0, 0.0))
        pgm_function279.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function279.set_cpd((5, 2), (
            0.00059994, 0.00119988, 0.00419958, 0.02839716, 0.11488851, 0.35756424, 0.39636036, 0.09639036, 0.00039996,
            0.0))
        pgm_function279.set_cpd((0, 3), (
            0.0, 9.999e-05, 0.00019998, 0.00189981, 0.01069893, 0.06579342, 0.28457154, 0.50544946, 0.13128687, 0.0))
        pgm_function279.set_cpd((1, 3), (
            0.0, 0.0, 0.00010001, 0.00120012, 0.00750075, 0.0510051, 0.25242524, 0.51855186, 0.16921692, 0.0))
        pgm_function279.set_cpd((2, 3), (0.0, 0.0, 0.0, 0.0005, 0.0034, 0.028, 0.1822, 0.5098, 0.2761, 0.0))
        pgm_function279.set_cpd((3, 3), (
            0.0, 0.0, 0.0, 0.00010001, 0.00120012, 0.01250125, 0.11181118, 0.44524452, 0.42914291, 0.0))
        pgm_function279.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function279.set_cpd((5, 3), (0.0, 0.0, 0.0002, 0.0011, 0.0056, 0.033, 0.1653, 0.4414, 0.3534, 0.0))
        pgm_factor280 = self.new_factor(R_ULN_ALLCV_EW, R_ULN_DCV_EW)
        pgm_function280 = pgm_factor280.set_cpt()
        pgm_function280.set_cpd((0,), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function280.set_cpd((1,), (0.0558, 0.8486, 0.0956, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function280.set_cpd((2,), (0.0, 0.0369, 0.9631, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function280.set_cpd((3,), (0.0008, 0.0087, 0.0873, 0.8226, 0.0806, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function280.set_cpd((4,), (0.0, 0.0, 0.0005, 0.0994, 0.8508, 0.0493, 0.0, 0.0, 0.0, 0.0))
        pgm_function280.set_cpd((5,), (0.0, 0.0, 0.0, 0.0005, 0.0781, 0.9017, 0.0197, 0.0, 0.0, 0.0))
        pgm_function280.set_cpd((6,), (0.0, 0.0, 0.0, 0.0, 0.0006, 0.0728, 0.8406, 0.086, 0.0, 0.0))
        pgm_function280.set_cpd((7,), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0003, 0.0942, 0.8952, 0.0103, 0.0))
        pgm_function280.set_cpd((8,), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.002, 0.093, 0.905, 0.0))
        pgm_function280.set_cpd((9,), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.9999))
        pgm_factor281 = self.new_factor(R_ULN_CV_EW, R_ULN_ALLCV_EW)
        pgm_function281 = pgm_factor281.set_cpt()
        pgm_function281.set_cpd((0,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.999e-05, 0.00419958, 0.04879512, 0.19368063,
            0.3249675,
            0.26967303, 0.12318768, 0.03539646))
        pgm_function281.set_cpd((1,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.0042, 0.0505, 0.1995, 0.3255, 0.2622, 0.1185,
            0.0332, 0.0063))
        pgm_function281.set_cpd((2,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.999e-05, 0.00079992, 0.02079792, 0.13878612, 0.31686831,
            0.31146885, 0.15638436, 0.04529547, 0.00839916, 0.00109989))
        pgm_function281.set_cpd((3,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00019998, 0.00739926, 0.13408659, 0.19748025, 0.27547245, 0.21907809,
            0.11158884, 0.04039596, 0.01119888, 0.00249975, 0.00049995, 9.999e-05))
        pgm_function281.set_cpd((4,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.002, 0.0467, 0.2191, 0.3382, 0.2525, 0.105, 0.0294, 0.006, 0.001, 0.0001,
            0.0,
            0.0, 0.0))
        pgm_function281.set_cpd((5,), (
            0.0, 0.0, 0.0, 0.0, 0.0002, 0.0261, 0.2225, 0.4086, 0.2726, 0.0468, 0.0197, 0.0031, 0.0004, 0.0, 0.0, 0.0,
            0.0,
            0.0, 0.0))
        pgm_function281.set_cpd((6,), (
            0.0, 0.0, 0.0, 0.0095, 0.2235, 0.4483, 0.2397, 0.0663, 0.0119, 0.0006, 0.0002, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0))
        pgm_function281.set_cpd((7,), (
            0.0, 0.0, 0.0149, 0.4662, 0.4182, 0.0903, 0.0095, 0.0008, 0.0001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0,
            0.0))
        pgm_function281.set_cpd((8,), (
            0.0, 0.09020902, 0.77417742, 0.12491249, 0.010001, 0.00070007, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0,
            0.0, 0.0, 0.0))
        pgm_function281.set_cpd((9,), (
            0.9999, 0.0001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor282 = self.new_factor(R_OTHER_ADM_NMT)
        pgm_function282 = pgm_factor282.set_cpt()
        pgm_function282.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor283 = self.new_factor(R_LNLC8_ADM_DE_REGEN)
        pgm_function283 = pgm_factor283.set_cpt()
        pgm_function283.set_cpd((), (1.0, 0.0))
        pgm_factor284 = self.new_factor(R_LNLLP_ADM_DE_REGEN)
        pgm_function284 = pgm_factor284.set_cpt()
        pgm_function284.set_cpd((), (1.0, 0.0))
        pgm_factor285 = self.new_factor(R_LNLC8_LP_ADM_DE_REGEN, R_LNLC8_ADM_DE_REGEN, R_LNLLP_ADM_DE_REGEN)
        pgm_function285 = pgm_factor285.set_cpt()
        pgm_function285.set_cpd((0, 0), (1.0, 0.0))
        pgm_function285.set_cpd((1, 0), (0.0, 1.0))
        pgm_function285.set_cpd((0, 1), (0.0, 1.0))
        pgm_function285.set_cpd((1, 1), (0.0, 1.0))
        pgm_factor286 = self.new_factor(R_LNLE_ULN_TIME)
        pgm_function286 = pgm_factor286.set_cpt()
        pgm_function286.set_cpd((), (0.05, 0.6, 0.3, 0.05))
        pgm_factor287 = self.new_factor(R_LNLE_ADM_DE_REGEN, R_LNLE_ULN_SEV, R_LNLE_ULN_TIME, R_LNLE_ULN_PATHO)
        pgm_function287 = pgm_factor287.set_cpt()
        pgm_function287.set_cpd((0, 0, 0), (1.0, 0.0))
        pgm_function287.set_cpd((1, 0, 0), (1.0, 0.0))
        pgm_function287.set_cpd((2, 0, 0), (1.0, 0.0))
        pgm_function287.set_cpd((3, 0, 0), (1.0, 0.0))
        pgm_function287.set_cpd((4, 0, 0), (1.0, 0.0))
        pgm_function287.set_cpd((0, 1, 0), (1.0, 0.0))
        pgm_function287.set_cpd((1, 1, 0), (0.8, 0.2))
        pgm_function287.set_cpd((2, 1, 0), (0.2, 0.8))
        pgm_function287.set_cpd((3, 1, 0), (0.4, 0.6))
        pgm_function287.set_cpd((4, 1, 0), (1.0, 0.0))
        pgm_function287.set_cpd((0, 2, 0), (1.0, 0.0))
        pgm_function287.set_cpd((1, 2, 0), (0.8, 0.2))
        pgm_function287.set_cpd((2, 2, 0), (0.2, 0.8))
        pgm_function287.set_cpd((3, 2, 0), (0.4, 0.6))
        pgm_function287.set_cpd((4, 2, 0), (1.0, 0.0))
        pgm_function287.set_cpd((0, 3, 0), (1.0, 0.0))
        pgm_function287.set_cpd((1, 3, 0), (1.0, 0.0))
        pgm_function287.set_cpd((2, 3, 0), (0.8, 0.2))
        pgm_function287.set_cpd((3, 3, 0), (0.4, 0.6))
        pgm_function287.set_cpd((4, 3, 0), (1.0, 0.0))
        pgm_function287.set_cpd((0, 0, 1), (1.0, 0.0))
        pgm_function287.set_cpd((1, 0, 1), (1.0, 0.0))
        pgm_function287.set_cpd((2, 0, 1), (1.0, 0.0))
        pgm_function287.set_cpd((3, 0, 1), (1.0, 0.0))
        pgm_function287.set_cpd((4, 0, 1), (1.0, 0.0))
        pgm_function287.set_cpd((0, 1, 1), (1.0, 0.0))
        pgm_function287.set_cpd((1, 1, 1), (0.8, 0.2))
        pgm_function287.set_cpd((2, 1, 1), (0.2, 0.8))
        pgm_function287.set_cpd((3, 1, 1), (0.4, 0.6))
        pgm_function287.set_cpd((4, 1, 1), (1.0, 0.0))
        pgm_function287.set_cpd((0, 2, 1), (1.0, 0.0))
        pgm_function287.set_cpd((1, 2, 1), (0.8, 0.2))
        pgm_function287.set_cpd((2, 2, 1), (0.2, 0.8))
        pgm_function287.set_cpd((3, 2, 1), (0.4, 0.6))
        pgm_function287.set_cpd((4, 2, 1), (1.0, 0.0))
        pgm_function287.set_cpd((0, 3, 1), (1.0, 0.0))
        pgm_function287.set_cpd((1, 3, 1), (1.0, 0.0))
        pgm_function287.set_cpd((2, 3, 1), (0.8, 0.2))
        pgm_function287.set_cpd((3, 3, 1), (0.4, 0.6))
        pgm_function287.set_cpd((4, 3, 1), (1.0, 0.0))
        pgm_function287.set_cpd((0, 0, 2), (1.0, 0.0))
        pgm_function287.set_cpd((1, 0, 2), (1.0, 0.0))
        pgm_function287.set_cpd((2, 0, 2), (1.0, 0.0))
        pgm_function287.set_cpd((3, 0, 2), (1.0, 0.0))
        pgm_function287.set_cpd((4, 0, 2), (1.0, 0.0))
        pgm_function287.set_cpd((0, 1, 2), (1.0, 0.0))
        pgm_function287.set_cpd((1, 1, 2), (0.5, 0.5))
        pgm_function287.set_cpd((2, 1, 2), (0.2, 0.8))
        pgm_function287.set_cpd((3, 1, 2), (0.1, 0.9))
        pgm_function287.set_cpd((4, 1, 2), (1.0, 0.0))
        pgm_function287.set_cpd((0, 2, 2), (1.0, 0.0))
        pgm_function287.set_cpd((1, 2, 2), (0.5, 0.5))
        pgm_function287.set_cpd((2, 2, 2), (0.2, 0.8))
        pgm_function287.set_cpd((3, 2, 2), (0.1, 0.9))
        pgm_function287.set_cpd((4, 2, 2), (1.0, 0.0))
        pgm_function287.set_cpd((0, 3, 2), (1.0, 0.0))
        pgm_function287.set_cpd((1, 3, 2), (1.0, 0.0))
        pgm_function287.set_cpd((2, 3, 2), (0.8, 0.2))
        pgm_function287.set_cpd((3, 3, 2), (0.4, 0.6))
        pgm_function287.set_cpd((4, 3, 2), (1.0, 0.0))
        pgm_function287.set_cpd((0, 0, 3), (0.0, 1.0))
        pgm_function287.set_cpd((1, 0, 3), (0.0, 1.0))
        pgm_function287.set_cpd((2, 0, 3), (0.0, 1.0))
        pgm_function287.set_cpd((3, 0, 3), (0.0, 1.0))
        pgm_function287.set_cpd((4, 0, 3), (0.0, 1.0))
        pgm_function287.set_cpd((0, 1, 3), (0.0, 1.0))
        pgm_function287.set_cpd((1, 1, 3), (0.0, 1.0))
        pgm_function287.set_cpd((2, 1, 3), (0.0, 1.0))
        pgm_function287.set_cpd((3, 1, 3), (0.0, 1.0))
        pgm_function287.set_cpd((4, 1, 3), (0.0, 1.0))
        pgm_function287.set_cpd((0, 2, 3), (0.0, 1.0))
        pgm_function287.set_cpd((1, 2, 3), (0.0, 1.0))
        pgm_function287.set_cpd((2, 2, 3), (0.0, 1.0))
        pgm_function287.set_cpd((3, 2, 3), (0.0, 1.0))
        pgm_function287.set_cpd((4, 2, 3), (0.0, 1.0))
        pgm_function287.set_cpd((0, 3, 3), (0.0, 1.0))
        pgm_function287.set_cpd((1, 3, 3), (0.0, 1.0))
        pgm_function287.set_cpd((2, 3, 3), (0.0, 1.0))
        pgm_function287.set_cpd((3, 3, 3), (0.0, 1.0))
        pgm_function287.set_cpd((4, 3, 3), (0.0, 1.0))
        pgm_function287.set_cpd((0, 0, 4), (0.0, 1.0))
        pgm_function287.set_cpd((1, 0, 4), (0.0, 1.0))
        pgm_function287.set_cpd((2, 0, 4), (0.0, 1.0))
        pgm_function287.set_cpd((3, 0, 4), (0.0, 1.0))
        pgm_function287.set_cpd((4, 0, 4), (0.0, 1.0))
        pgm_function287.set_cpd((0, 1, 4), (0.0, 1.0))
        pgm_function287.set_cpd((1, 1, 4), (0.0, 1.0))
        pgm_function287.set_cpd((2, 1, 4), (0.0, 1.0))
        pgm_function287.set_cpd((3, 1, 4), (0.0, 1.0))
        pgm_function287.set_cpd((4, 1, 4), (0.0, 1.0))
        pgm_function287.set_cpd((0, 2, 4), (0.0, 1.0))
        pgm_function287.set_cpd((1, 2, 4), (0.0, 1.0))
        pgm_function287.set_cpd((2, 2, 4), (0.0, 1.0))
        pgm_function287.set_cpd((3, 2, 4), (0.0, 1.0))
        pgm_function287.set_cpd((4, 2, 4), (0.0, 1.0))
        pgm_function287.set_cpd((0, 3, 4), (0.0, 1.0))
        pgm_function287.set_cpd((1, 3, 4), (0.0, 1.0))
        pgm_function287.set_cpd((2, 3, 4), (0.0, 1.0))
        pgm_function287.set_cpd((3, 3, 4), (0.0, 1.0))
        pgm_function287.set_cpd((4, 3, 4), (0.0, 1.0))
        pgm_factor288 = self.new_factor(R_LNLC8_LP_E_ADM_DE_REGEN, R_LNLC8_LP_ADM_DE_REGEN, R_LNLE_ADM_DE_REGEN)
        pgm_function288 = pgm_factor288.set_cpt()
        pgm_function288.set_cpd((0, 0), (1.0, 0.0))
        pgm_function288.set_cpd((1, 0), (0.0, 1.0))
        pgm_function288.set_cpd((0, 1), (0.0, 1.0))
        pgm_function288.set_cpd((1, 1), (0.0, 1.0))
        pgm_factor289 = self.new_factor(R_DIFFN_ADM_DE_REGEN, DIFFN_M_SEV_DIST, DIFFN_TIME, DIFFN_PATHO)
        pgm_function289 = pgm_factor289.set_cpt()
        pgm_function289.set_cpd((0, 0, 0), (1.0, 0.0))
        pgm_function289.set_cpd((1, 0, 0), (1.0, 0.0))
        pgm_function289.set_cpd((2, 0, 0), (1.0, 0.0))
        pgm_function289.set_cpd((3, 0, 0), (1.0, 0.0))
        pgm_function289.set_cpd((0, 1, 0), (1.0, 0.0))
        pgm_function289.set_cpd((1, 1, 0), (0.8, 0.2))
        pgm_function289.set_cpd((2, 1, 0), (0.2, 0.8))
        pgm_function289.set_cpd((3, 1, 0), (0.4, 0.6))
        pgm_function289.set_cpd((0, 2, 0), (1.0, 0.0))
        pgm_function289.set_cpd((1, 2, 0), (0.8, 0.2))
        pgm_function289.set_cpd((2, 2, 0), (0.2, 0.8))
        pgm_function289.set_cpd((3, 2, 0), (0.4, 0.6))
        pgm_function289.set_cpd((0, 3, 0), (1.0, 0.0))
        pgm_function289.set_cpd((1, 3, 0), (1.0, 0.0))
        pgm_function289.set_cpd((2, 3, 0), (0.8, 0.2))
        pgm_function289.set_cpd((3, 3, 0), (0.4, 0.6))
        pgm_function289.set_cpd((0, 0, 1), (1.0, 0.0))
        pgm_function289.set_cpd((1, 0, 1), (1.0, 0.0))
        pgm_function289.set_cpd((2, 0, 1), (1.0, 0.0))
        pgm_function289.set_cpd((3, 0, 1), (1.0, 0.0))
        pgm_function289.set_cpd((0, 1, 1), (1.0, 0.0))
        pgm_function289.set_cpd((1, 1, 1), (0.8, 0.2))
        pgm_function289.set_cpd((2, 1, 1), (0.2, 0.8))
        pgm_function289.set_cpd((3, 1, 1), (0.4, 0.6))
        pgm_function289.set_cpd((0, 2, 1), (1.0, 0.0))
        pgm_function289.set_cpd((1, 2, 1), (0.8, 0.2))
        pgm_function289.set_cpd((2, 2, 1), (0.2, 0.8))
        pgm_function289.set_cpd((3, 2, 1), (0.4, 0.6))
        pgm_function289.set_cpd((0, 3, 1), (1.0, 0.0))
        pgm_function289.set_cpd((1, 3, 1), (1.0, 0.0))
        pgm_function289.set_cpd((2, 3, 1), (0.8, 0.2))
        pgm_function289.set_cpd((3, 3, 1), (0.4, 0.6))
        pgm_function289.set_cpd((0, 0, 2), (1.0, 0.0))
        pgm_function289.set_cpd((1, 0, 2), (1.0, 0.0))
        pgm_function289.set_cpd((2, 0, 2), (1.0, 0.0))
        pgm_function289.set_cpd((3, 0, 2), (1.0, 0.0))
        pgm_function289.set_cpd((0, 1, 2), (1.0, 0.0))
        pgm_function289.set_cpd((1, 1, 2), (0.5, 0.5))
        pgm_function289.set_cpd((2, 1, 2), (0.2, 0.8))
        pgm_function289.set_cpd((3, 1, 2), (0.1, 0.9))
        pgm_function289.set_cpd((0, 2, 2), (1.0, 0.0))
        pgm_function289.set_cpd((1, 2, 2), (0.5, 0.5))
        pgm_function289.set_cpd((2, 2, 2), (0.2, 0.8))
        pgm_function289.set_cpd((3, 2, 2), (0.1, 0.9))
        pgm_function289.set_cpd((0, 3, 2), (1.0, 0.0))
        pgm_function289.set_cpd((1, 3, 2), (1.0, 0.0))
        pgm_function289.set_cpd((2, 3, 2), (0.8, 0.2))
        pgm_function289.set_cpd((3, 3, 2), (0.4, 0.6))
        pgm_function289.set_cpd((0, 0, 3), (0.0, 1.0))
        pgm_function289.set_cpd((1, 0, 3), (0.0, 1.0))
        pgm_function289.set_cpd((2, 0, 3), (0.0, 1.0))
        pgm_function289.set_cpd((3, 0, 3), (0.0, 1.0))
        pgm_function289.set_cpd((0, 1, 3), (0.0, 1.0))
        pgm_function289.set_cpd((1, 1, 3), (0.0, 1.0))
        pgm_function289.set_cpd((2, 1, 3), (0.0, 1.0))
        pgm_function289.set_cpd((3, 1, 3), (0.0, 1.0))
        pgm_function289.set_cpd((0, 2, 3), (0.0, 1.0))
        pgm_function289.set_cpd((1, 2, 3), (0.0, 1.0))
        pgm_function289.set_cpd((2, 2, 3), (0.0, 1.0))
        pgm_function289.set_cpd((3, 2, 3), (0.0, 1.0))
        pgm_function289.set_cpd((0, 3, 3), (0.0, 1.0))
        pgm_function289.set_cpd((1, 3, 3), (0.0, 1.0))
        pgm_function289.set_cpd((2, 3, 3), (0.0, 1.0))
        pgm_function289.set_cpd((3, 3, 3), (0.0, 1.0))
        pgm_function289.set_cpd((0, 0, 4), (0.0, 1.0))
        pgm_function289.set_cpd((1, 0, 4), (0.0, 1.0))
        pgm_function289.set_cpd((2, 0, 4), (0.0, 1.0))
        pgm_function289.set_cpd((3, 0, 4), (0.0, 1.0))
        pgm_function289.set_cpd((0, 1, 4), (0.0, 1.0))
        pgm_function289.set_cpd((1, 1, 4), (0.0, 1.0))
        pgm_function289.set_cpd((2, 1, 4), (0.0, 1.0))
        pgm_function289.set_cpd((3, 1, 4), (0.0, 1.0))
        pgm_function289.set_cpd((0, 2, 4), (0.0, 1.0))
        pgm_function289.set_cpd((1, 2, 4), (0.0, 1.0))
        pgm_function289.set_cpd((2, 2, 4), (0.0, 1.0))
        pgm_function289.set_cpd((3, 2, 4), (0.0, 1.0))
        pgm_function289.set_cpd((0, 3, 4), (0.0, 1.0))
        pgm_function289.set_cpd((1, 3, 4), (0.0, 1.0))
        pgm_function289.set_cpd((2, 3, 4), (0.0, 1.0))
        pgm_function289.set_cpd((3, 3, 4), (0.0, 1.0))
        pgm_factor290 = self.new_factor(R_LNLW_ADM_DE_REGEN)
        pgm_function290 = pgm_factor290.set_cpt()
        pgm_function290.set_cpd((), (1.0, 0.0))
        pgm_factor291 = self.new_factor(R_DIFFN_LNLW_ADM_DE_REGEN, R_DIFFN_ADM_DE_REGEN, R_LNLW_ADM_DE_REGEN)
        pgm_function291 = pgm_factor291.set_cpt()
        pgm_function291.set_cpd((0, 0), (1.0, 0.0))
        pgm_function291.set_cpd((1, 0), (0.0, 1.0))
        pgm_function291.set_cpd((0, 1), (0.0, 1.0))
        pgm_function291.set_cpd((1, 1), (0.0, 1.0))
        pgm_factor292 = self.new_factor(R_LNL_DIFFN_ADM_DE_REGEN, R_LNLC8_LP_E_ADM_DE_REGEN, R_DIFFN_LNLW_ADM_DE_REGEN)
        pgm_function292 = pgm_factor292.set_cpt()
        pgm_function292.set_cpd((0, 0), (1.0, 0.0))
        pgm_function292.set_cpd((1, 0), (0.0, 1.0))
        pgm_function292.set_cpd((0, 1), (0.0, 1.0))
        pgm_function292.set_cpd((1, 1), (0.0, 1.0))
        pgm_factor293 = self.new_factor(R_MYOP_ADM_DE_REGEN)
        pgm_function293 = pgm_factor293.set_cpt()
        pgm_function293.set_cpd((), (1.0, 0.0))
        pgm_factor294 = self.new_factor(R_MYDY_ADM_DE_REGEN)
        pgm_function294 = pgm_factor294.set_cpt()
        pgm_function294.set_cpd((), (1.0, 0.0))
        pgm_factor295 = self.new_factor(R_MYOP_MYDY_ADM_DE_REGEN, R_MYOP_ADM_DE_REGEN, R_MYDY_ADM_DE_REGEN)
        pgm_function295 = pgm_factor295.set_cpt()
        pgm_function295.set_cpd((0, 0), (1.0, 0.0))
        pgm_function295.set_cpd((1, 0), (0.0, 1.0))
        pgm_function295.set_cpd((0, 1), (0.0, 1.0))
        pgm_function295.set_cpd((1, 1), (0.0, 1.0))
        pgm_factor296 = self.new_factor(R_OTHER_ADM_DE_REGEN)
        pgm_function296 = pgm_factor296.set_cpt()
        pgm_function296.set_cpd((), (1.0, 0.0))
        pgm_factor297 = self.new_factor(R_MUSCLE_ADM_DE_REGEN, R_MYOP_MYDY_ADM_DE_REGEN, R_OTHER_ADM_DE_REGEN)
        pgm_function297 = pgm_factor297.set_cpt()
        pgm_function297.set_cpd((0, 0), (1.0, 0.0))
        pgm_function297.set_cpd((1, 0), (0.0, 1.0))
        pgm_function297.set_cpd((0, 1), (0.0, 1.0))
        pgm_function297.set_cpd((1, 1), (0.0, 1.0))
        pgm_factor298 = self.new_factor(R_ADM_DE_REGEN, R_LNL_DIFFN_ADM_DE_REGEN, R_MUSCLE_ADM_DE_REGEN)
        pgm_function298 = pgm_factor298.set_cpt()
        pgm_function298.set_cpd((0, 0), (1.0, 0.0))
        pgm_function298.set_cpd((1, 0), (0.0, 1.0))
        pgm_function298.set_cpd((0, 1), (0.0, 1.0))
        pgm_function298.set_cpd((1, 1), (0.0, 1.0))
        pgm_factor299 = self.new_factor(R_DE_REGEN_ADM_NMT, R_ADM_DE_REGEN)
        pgm_function299 = pgm_factor299.set_cpt()
        pgm_function299.set_cpd((0,), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function299.set_cpd((1,), (0.949, 0.003, 0.001, 0.04, 0.003, 0.001, 0.003))
        pgm_factor300 = self.new_factor(R_MYAS_ADM_NMT)
        pgm_function300 = pgm_factor300.set_cpt()
        pgm_function300.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor301 = self.new_factor(R_MYAS_DE_REGEN_ADM_NMT, R_DE_REGEN_ADM_NMT, R_MYAS_ADM_NMT)
        pgm_function301 = pgm_factor301.set_cpt()
        pgm_function301.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function301.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function301.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function301.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function301.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function301.set_cpd((5, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function301.set_cpd((6, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function301.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function301.set_cpd((1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function301.set_cpd((2, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function301.set_cpd((3, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function301.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function301.set_cpd((5, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function301.set_cpd((6, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function301.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function301.set_cpd((1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function301.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function301.set_cpd((3, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function301.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function301.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function301.set_cpd((6, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function301.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function301.set_cpd((1, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function301.set_cpd((2, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function301.set_cpd((3, 3), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function301.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function301.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function301.set_cpd((6, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function301.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function301.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function301.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function301.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function301.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function301.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function301.set_cpd((6, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function301.set_cpd((0, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function301.set_cpd((1, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function301.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function301.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function301.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function301.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function301.set_cpd((6, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function301.set_cpd((0, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function301.set_cpd((1, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function301.set_cpd((2, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function301.set_cpd((3, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function301.set_cpd((4, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function301.set_cpd((5, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function301.set_cpd((6, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor302 = self.new_factor(R_ADM_NMT, R_OTHER_ADM_NMT, R_MYAS_DE_REGEN_ADM_NMT)
        pgm_function302 = pgm_factor302.set_cpt()
        pgm_function302.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function302.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function302.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function302.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function302.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function302.set_cpd((5, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function302.set_cpd((6, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function302.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function302.set_cpd((1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function302.set_cpd((2, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function302.set_cpd((3, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function302.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function302.set_cpd((5, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function302.set_cpd((6, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function302.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function302.set_cpd((1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function302.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function302.set_cpd((3, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function302.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function302.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function302.set_cpd((6, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function302.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function302.set_cpd((1, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function302.set_cpd((2, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function302.set_cpd((3, 3), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function302.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function302.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function302.set_cpd((6, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function302.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function302.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function302.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function302.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function302.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function302.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function302.set_cpd((6, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function302.set_cpd((0, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function302.set_cpd((1, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function302.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function302.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function302.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function302.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function302.set_cpd((6, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function302.set_cpd((0, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function302.set_cpd((1, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function302.set_cpd((2, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function302.set_cpd((3, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function302.set_cpd((4, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function302.set_cpd((5, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function302.set_cpd((6, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor303 = self.new_factor(R_OTHER_ADM_MUSIZE)
        pgm_function303 = pgm_factor303.set_cpt()
        pgm_function303.set_cpd((), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_factor304 = self.new_factor(R_MYDY_ADM_MUSIZE)
        pgm_function304 = pgm_factor304.set_cpt()
        pgm_function304.set_cpd((), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_factor305 = self.new_factor(R_MYOP_ADM_MUSIZE)
        pgm_function305 = pgm_factor305.set_cpt()
        pgm_function305.set_cpd((), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_factor306 = self.new_factor(R_MYOP_MYDY_ADM_MUSIZE, R_MYDY_ADM_MUSIZE, R_MYOP_ADM_MUSIZE)
        pgm_function306 = pgm_factor306.set_cpt()
        pgm_function306.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function306.set_cpd((1, 0), (0.9983, 0.0017, 0.0, 0.0, 0.0, 0.0))
        pgm_function306.set_cpd((2, 0), (0.9857, 0.0143, 0.0, 0.0, 0.0, 0.0))
        pgm_function306.set_cpd((3, 0), (0.3673, 0.6298, 0.0029, 0.0, 0.0, 0.0))
        pgm_function306.set_cpd((4, 0), (0.01150115, 0.86168617, 0.12491249, 0.00190019, 0.0, 0.0))
        pgm_function306.set_cpd((5, 0), (0.0, 0.1596, 0.7368, 0.1016, 0.002, 0.0))
        pgm_function306.set_cpd((0, 1), (0.9983, 0.0017, 0.0, 0.0, 0.0, 0.0))
        pgm_function306.set_cpd((1, 1), (0.8667, 0.1329, 0.0004, 0.0, 0.0, 0.0))
        pgm_function306.set_cpd((2, 1), (0.01390139, 0.96369637, 0.02240224, 0.0, 0.0, 0.0))
        pgm_function306.set_cpd((3, 1), (0.0003, 0.3514, 0.6035, 0.0443, 0.0005, 0.0))
        pgm_function306.set_cpd((4, 1), (0.0, 0.0105, 0.5726, 0.3806, 0.0359, 0.0004))
        pgm_function306.set_cpd((5, 1), (0.0, 0.0, 0.0792, 0.4758, 0.4066, 0.0384))
        pgm_function306.set_cpd((0, 2), (0.9857, 0.0143, 0.0, 0.0, 0.0, 0.0))
        pgm_function306.set_cpd((1, 2), (0.01390139, 0.96369637, 0.02240224, 0.0, 0.0, 0.0))
        pgm_function306.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function306.set_cpd((3, 2), (0.0, 0.0, 0.04060406, 0.92779278, 0.03160316, 0.0))
        pgm_function306.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0319, 0.9362, 0.0319))
        pgm_function306.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 0.0329, 0.9671))
        pgm_function306.set_cpd((0, 3), (0.3673, 0.6298, 0.0029, 0.0, 0.0, 0.0))
        pgm_function306.set_cpd((1, 3), (0.0003, 0.3514, 0.6035, 0.0443, 0.0005, 0.0))
        pgm_function306.set_cpd((2, 3), (0.0, 0.0, 0.04060406, 0.92779278, 0.03160316, 0.0))
        pgm_function306.set_cpd((3, 3), (0.0, 0.0, 0.00039996, 0.10988901, 0.77982202, 0.10988901))
        pgm_function306.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.00030003, 0.12341234, 0.87628763))
        pgm_function306.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0028, 0.9972))
        pgm_function306.set_cpd((0, 4), (0.01150115, 0.86168617, 0.12491249, 0.00190019, 0.0, 0.0))
        pgm_function306.set_cpd((1, 4), (0.0, 0.0105, 0.5726, 0.3806, 0.0359, 0.0004))
        pgm_function306.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0319, 0.9362, 0.0319))
        pgm_function306.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.00030003, 0.12341234, 0.87628763))
        pgm_function306.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 0.0028, 0.9972))
        pgm_function306.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0001, 0.9999))
        pgm_function306.set_cpd((0, 5), (0.0, 0.1596, 0.7368, 0.1016, 0.002, 0.0))
        pgm_function306.set_cpd((1, 5), (0.0, 0.0, 0.0792, 0.4758, 0.4066, 0.0384))
        pgm_function306.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0329, 0.9671))
        pgm_function306.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0028, 0.9972))
        pgm_function306.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0001, 0.9999))
        pgm_function306.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor307 = self.new_factor(R_MUSCLE_ADM_MUSIZE, R_OTHER_ADM_MUSIZE, R_MYOP_MYDY_ADM_MUSIZE)
        pgm_function307 = pgm_factor307.set_cpt()
        pgm_function307.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function307.set_cpd((1, 0), (0.9983, 0.0017, 0.0, 0.0, 0.0, 0.0))
        pgm_function307.set_cpd((2, 0), (0.9857, 0.0143, 0.0, 0.0, 0.0, 0.0))
        pgm_function307.set_cpd((3, 0), (0.3673, 0.6298, 0.0029, 0.0, 0.0, 0.0))
        pgm_function307.set_cpd((4, 0), (0.01150115, 0.86168617, 0.12491249, 0.00190019, 0.0, 0.0))
        pgm_function307.set_cpd((5, 0), (0.0, 0.1596, 0.7368, 0.1016, 0.002, 0.0))
        pgm_function307.set_cpd((0, 1), (0.9983, 0.0017, 0.0, 0.0, 0.0, 0.0))
        pgm_function307.set_cpd((1, 1), (0.8667, 0.1329, 0.0004, 0.0, 0.0, 0.0))
        pgm_function307.set_cpd((2, 1), (0.01390139, 0.96369637, 0.02240224, 0.0, 0.0, 0.0))
        pgm_function307.set_cpd((3, 1), (0.0003, 0.3514, 0.6035, 0.0443, 0.0005, 0.0))
        pgm_function307.set_cpd((4, 1), (0.0, 0.0105, 0.5726, 0.3806, 0.0359, 0.0004))
        pgm_function307.set_cpd((5, 1), (0.0, 0.0, 0.0792, 0.4758, 0.4066, 0.0384))
        pgm_function307.set_cpd((0, 2), (0.9857, 0.0143, 0.0, 0.0, 0.0, 0.0))
        pgm_function307.set_cpd((1, 2), (0.01390139, 0.96369637, 0.02240224, 0.0, 0.0, 0.0))
        pgm_function307.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function307.set_cpd((3, 2), (0.0, 0.0, 0.04060406, 0.92779278, 0.03160316, 0.0))
        pgm_function307.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0319, 0.9362, 0.0319))
        pgm_function307.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 0.0329, 0.9671))
        pgm_function307.set_cpd((0, 3), (0.3673, 0.6298, 0.0029, 0.0, 0.0, 0.0))
        pgm_function307.set_cpd((1, 3), (0.0003, 0.3514, 0.6035, 0.0443, 0.0005, 0.0))
        pgm_function307.set_cpd((2, 3), (0.0, 0.0, 0.04060406, 0.92779278, 0.03160316, 0.0))
        pgm_function307.set_cpd((3, 3), (0.0, 0.0, 0.00039996, 0.10988901, 0.77982202, 0.10988901))
        pgm_function307.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.00030003, 0.12341234, 0.87628763))
        pgm_function307.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0028, 0.9972))
        pgm_function307.set_cpd((0, 4), (0.01150115, 0.86168617, 0.12491249, 0.00190019, 0.0, 0.0))
        pgm_function307.set_cpd((1, 4), (0.0, 0.0105, 0.5726, 0.3806, 0.0359, 0.0004))
        pgm_function307.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0319, 0.9362, 0.0319))
        pgm_function307.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.00030003, 0.12341234, 0.87628763))
        pgm_function307.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 0.0028, 0.9972))
        pgm_function307.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0001, 0.9999))
        pgm_function307.set_cpd((0, 5), (0.0, 0.1596, 0.7368, 0.1016, 0.002, 0.0))
        pgm_function307.set_cpd((1, 5), (0.0, 0.0, 0.0792, 0.4758, 0.4066, 0.0384))
        pgm_function307.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0329, 0.9671))
        pgm_function307.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0028, 0.9972))
        pgm_function307.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0001, 0.9999))
        pgm_function307.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor308 = self.new_factor(R_LNLW_ADM_MUSIZE)
        pgm_function308 = pgm_factor308.set_cpt()
        pgm_function308.set_cpd((), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_factor309 = self.new_factor(R_DIFFN_ADM_MUSIZE, DIFFN_M_SEV_DIST, DIFFN_TIME, DIFFN_PATHO)
        pgm_function309 = pgm_factor309.set_cpt()
        pgm_function309.set_cpd((0, 0, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((1, 0, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((2, 0, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((3, 0, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((0, 1, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((1, 1, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((2, 1, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((3, 1, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((0, 2, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((1, 2, 0), (0.0, 0.0, 0.7, 0.3, 0.0, 0.0))
        pgm_function309.set_cpd((2, 2, 0), (0.0, 0.0, 0.0, 0.8, 0.2, 0.0))
        pgm_function309.set_cpd((3, 2, 0), (0.0, 0.0, 0.0, 0.0, 0.5, 0.5))
        pgm_function309.set_cpd((0, 3, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((1, 3, 0), (0.0, 0.0, 0.7, 0.3, 0.0, 0.0))
        pgm_function309.set_cpd((2, 3, 0), (0.0, 0.0, 0.0, 0.8, 0.2, 0.0))
        pgm_function309.set_cpd((3, 3, 0), (0.0, 0.0, 0.0, 0.0, 0.5, 0.5))
        pgm_function309.set_cpd((0, 0, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((1, 0, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((2, 0, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((3, 0, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((0, 1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((1, 1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((2, 1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((3, 1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((0, 2, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((1, 2, 1), (0.0, 0.0, 0.9, 0.1, 0.0, 0.0))
        pgm_function309.set_cpd((2, 2, 1), (0.0, 0.0, 0.7, 0.2, 0.1, 0.0))
        pgm_function309.set_cpd((3, 2, 1), (0.0, 0.0, 0.0, 0.25, 0.5, 0.25))
        pgm_function309.set_cpd((0, 3, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((1, 3, 1), (0.0, 0.0, 0.9, 0.1, 0.0, 0.0))
        pgm_function309.set_cpd((2, 3, 1), (0.0, 0.0, 0.7, 0.2, 0.1, 0.0))
        pgm_function309.set_cpd((3, 3, 1), (0.0, 0.0, 0.0, 0.25, 0.5, 0.25))
        pgm_function309.set_cpd((0, 0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((1, 0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((2, 0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((3, 0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((0, 1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((1, 1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((2, 1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((3, 1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((0, 2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((1, 2, 2), (0.0, 0.0, 0.7, 0.3, 0.0, 0.0))
        pgm_function309.set_cpd((2, 2, 2), (0.0, 0.0, 0.0, 0.7, 0.3, 0.0))
        pgm_function309.set_cpd((3, 2, 2), (0.0, 0.0, 0.0, 0.0, 0.5, 0.5))
        pgm_function309.set_cpd((0, 3, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((1, 3, 2), (0.0, 0.0, 0.7, 0.3, 0.0, 0.0))
        pgm_function309.set_cpd((2, 3, 2), (0.0, 0.0, 0.0, 0.7, 0.3, 0.0))
        pgm_function309.set_cpd((3, 3, 2), (0.0, 0.0, 0.0, 0.0, 0.5, 0.5))
        pgm_function309.set_cpd((0, 0, 3), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((1, 0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((2, 0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((3, 0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((0, 1, 3), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((1, 1, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((2, 1, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((3, 1, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((0, 2, 3), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((1, 2, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((2, 2, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((3, 2, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((0, 3, 3), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((1, 3, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((2, 3, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((3, 3, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((0, 0, 4), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((1, 0, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((2, 0, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((3, 0, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((0, 1, 4), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((1, 1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((2, 1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((3, 1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((0, 2, 4), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((1, 2, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((2, 2, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((3, 2, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((0, 3, 4), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((1, 3, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((2, 3, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function309.set_cpd((3, 3, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor310 = self.new_factor(R_DIFFN_LNLW_ADM_MUSIZE, R_LNLW_ADM_MUSIZE, R_DIFFN_ADM_MUSIZE)
        pgm_function310 = pgm_factor310.set_cpt()
        pgm_function310.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function310.set_cpd((1, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function310.set_cpd((2, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function310.set_cpd((3, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function310.set_cpd((4, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function310.set_cpd((5, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function310.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function310.set_cpd((1, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function310.set_cpd((2, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function310.set_cpd((3, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function310.set_cpd((4, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function310.set_cpd((5, 1), (0.0, 0.99939994, 0.00050005, 0.00010001, 0.0, 0.0))
        pgm_function310.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function310.set_cpd((1, 2), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function310.set_cpd((2, 2), (0.0, 0.0, 0.9981, 0.0019, 0.0, 0.0))
        pgm_function310.set_cpd((3, 2), (0.0, 0.0, 0.0019, 0.9981, 0.0, 0.0))
        pgm_function310.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function310.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function310.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function310.set_cpd((1, 3), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function310.set_cpd((2, 3), (0.0, 0.0, 0.0019, 0.9981, 0.0, 0.0))
        pgm_function310.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function310.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function310.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function310.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function310.set_cpd((1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function310.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function310.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function310.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function310.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function310.set_cpd((0, 5), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function310.set_cpd((1, 5), (0.0, 0.99939994, 0.00050005, 0.00010001, 0.0, 0.0))
        pgm_function310.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function310.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function310.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function310.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor311 = self.new_factor(R_LNLE_ADM_MUSIZE, R_LNLE_ULN_SEV, R_LNLE_ULN_TIME, R_LNLE_ULN_PATHO)
        pgm_function311 = pgm_factor311.set_cpt()
        pgm_function311.set_cpd((0, 0, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((1, 0, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((2, 0, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((3, 0, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((4, 0, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((0, 1, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((1, 1, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((2, 1, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((3, 1, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((4, 1, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((0, 2, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((1, 2, 0), (0.0, 0.0, 0.9, 0.1, 0.0, 0.0))
        pgm_function311.set_cpd((2, 2, 0), (0.0, 0.0, 0.2, 0.7, 0.1, 0.0))
        pgm_function311.set_cpd((3, 2, 0), (0.0, 0.0, 0.0, 0.2, 0.7, 0.1))
        pgm_function311.set_cpd((4, 2, 0), (0.0, 0.0, 0.0, 0.2, 0.7, 0.1))
        pgm_function311.set_cpd((0, 3, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((1, 3, 0), (0.0, 0.0, 0.9, 0.1, 0.0, 0.0))
        pgm_function311.set_cpd((2, 3, 0), (0.0, 0.0, 0.2, 0.7, 0.1, 0.0))
        pgm_function311.set_cpd((3, 3, 0), (0.0, 0.0, 0.0, 0.2, 0.7, 0.1))
        pgm_function311.set_cpd((4, 3, 0), (0.0, 0.0, 0.0, 0.2, 0.7, 0.1))
        pgm_function311.set_cpd((0, 0, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((1, 0, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((2, 0, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((3, 0, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((4, 0, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((0, 1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((1, 1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((2, 1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((3, 1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((4, 1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((0, 2, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((1, 2, 1), (0.0, 0.0, 0.95, 0.05, 0.0, 0.0))
        pgm_function311.set_cpd((2, 2, 1), (0.0, 0.0, 0.7, 0.25, 0.05, 0.0))
        pgm_function311.set_cpd((3, 2, 1), (0.0, 0.0, 0.0, 0.25, 0.7, 0.05))
        pgm_function311.set_cpd((4, 2, 1), (0.0, 0.0, 0.0, 0.25, 0.7, 0.05))
        pgm_function311.set_cpd((0, 3, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((1, 3, 1), (0.0, 0.0, 0.95, 0.05, 0.0, 0.0))
        pgm_function311.set_cpd((2, 3, 1), (0.0, 0.0, 0.7, 0.25, 0.05, 0.0))
        pgm_function311.set_cpd((3, 3, 1), (0.0, 0.0, 0.0, 0.25, 0.7, 0.05))
        pgm_function311.set_cpd((4, 3, 1), (0.0, 0.0, 0.0, 0.25, 0.7, 0.05))
        pgm_function311.set_cpd((0, 0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((1, 0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((2, 0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((3, 0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((4, 0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((0, 1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((1, 1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((2, 1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((3, 1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((4, 1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((0, 2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((1, 2, 2), (0.0, 0.0, 0.8, 0.2, 0.0, 0.0))
        pgm_function311.set_cpd((2, 2, 2), (0.0, 0.0, 0.0, 0.8, 0.2, 0.0))
        pgm_function311.set_cpd((3, 2, 2), (0.0, 0.0, 0.0, 0.1, 0.6, 0.3))
        pgm_function311.set_cpd((4, 2, 2), (0.0, 0.0, 0.0, 0.1, 0.6, 0.3))
        pgm_function311.set_cpd((0, 3, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((1, 3, 2), (0.0, 0.0, 0.8, 0.2, 0.0, 0.0))
        pgm_function311.set_cpd((2, 3, 2), (0.0, 0.0, 0.0, 0.8, 0.2, 0.0))
        pgm_function311.set_cpd((3, 3, 2), (0.0, 0.0, 0.0, 0.1, 0.6, 0.3))
        pgm_function311.set_cpd((4, 3, 2), (0.0, 0.0, 0.0, 0.1, 0.6, 0.3))
        pgm_function311.set_cpd((0, 0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((1, 0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((2, 0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((3, 0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((4, 0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((0, 1, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((1, 1, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((2, 1, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((3, 1, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((4, 1, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((0, 2, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((1, 2, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((2, 2, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((3, 2, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((4, 2, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((0, 3, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((1, 3, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((2, 3, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((3, 3, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((4, 3, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((0, 0, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((1, 0, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((2, 0, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((3, 0, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((4, 0, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((0, 1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((1, 1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((2, 1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((3, 1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((4, 1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((0, 2, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((1, 2, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((2, 2, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((3, 2, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((4, 2, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((0, 3, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((1, 3, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((2, 3, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((3, 3, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function311.set_cpd((4, 3, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor312 = self.new_factor(R_LNLLP_ADM_MUSIZE)
        pgm_function312 = pgm_factor312.set_cpt()
        pgm_function312.set_cpd((), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_factor313 = self.new_factor(R_LNLC8_ADM_MUSIZE)
        pgm_function313 = pgm_factor313.set_cpt()
        pgm_function313.set_cpd((), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_factor314 = self.new_factor(R_LNLC8_LP_ADM_MUSIZE, R_LNLLP_ADM_MUSIZE, R_LNLC8_ADM_MUSIZE)
        pgm_function314 = pgm_factor314.set_cpt()
        pgm_function314.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function314.set_cpd((1, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function314.set_cpd((2, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function314.set_cpd((3, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function314.set_cpd((4, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function314.set_cpd((5, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function314.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function314.set_cpd((1, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function314.set_cpd((2, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function314.set_cpd((3, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function314.set_cpd((4, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function314.set_cpd((5, 1), (0.0, 0.99939994, 0.00050005, 0.00010001, 0.0, 0.0))
        pgm_function314.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function314.set_cpd((1, 2), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function314.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function314.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function314.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function314.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function314.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function314.set_cpd((1, 3), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function314.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function314.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function314.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function314.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function314.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function314.set_cpd((1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function314.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function314.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function314.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function314.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function314.set_cpd((0, 5), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function314.set_cpd((1, 5), (0.0, 0.99939994, 0.00050005, 0.00010001, 0.0, 0.0))
        pgm_function314.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function314.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function314.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function314.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor315 = self.new_factor(R_LNLC8_LP_E_ADM_MUSIZE, R_LNLE_ADM_MUSIZE, R_LNLC8_LP_ADM_MUSIZE)
        pgm_function315 = pgm_factor315.set_cpt()
        pgm_function315.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function315.set_cpd((1, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function315.set_cpd((2, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function315.set_cpd((3, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function315.set_cpd((4, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function315.set_cpd((5, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function315.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function315.set_cpd((1, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function315.set_cpd((2, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function315.set_cpd((3, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function315.set_cpd((4, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function315.set_cpd((5, 1), (0.0, 0.99939994, 0.00050005, 0.00010001, 0.0, 0.0))
        pgm_function315.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function315.set_cpd((1, 2), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function315.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function315.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function315.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function315.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function315.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function315.set_cpd((1, 3), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function315.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function315.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function315.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function315.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function315.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function315.set_cpd((1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function315.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function315.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function315.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function315.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function315.set_cpd((0, 5), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function315.set_cpd((1, 5), (0.0, 0.99939994, 0.00050005, 0.00010001, 0.0, 0.0))
        pgm_function315.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function315.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function315.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function315.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor316 = self.new_factor(R_LNL_DIFFN_ADM_MUSIZE, R_DIFFN_LNLW_ADM_MUSIZE, R_LNLC8_LP_E_ADM_MUSIZE)
        pgm_function316 = pgm_factor316.set_cpt()
        pgm_function316.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function316.set_cpd((1, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function316.set_cpd((2, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function316.set_cpd((3, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function316.set_cpd((4, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function316.set_cpd((5, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function316.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function316.set_cpd((1, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function316.set_cpd((2, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function316.set_cpd((3, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function316.set_cpd((4, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function316.set_cpd((5, 1), (0.0, 0.99939994, 0.00050005, 0.00010001, 0.0, 0.0))
        pgm_function316.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function316.set_cpd((1, 2), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function316.set_cpd((2, 2), (0.0, 0.0, 0.9981, 0.0019, 0.0, 0.0))
        pgm_function316.set_cpd((3, 2), (0.0, 0.0, 0.0019, 0.9981, 0.0, 0.0))
        pgm_function316.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function316.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function316.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function316.set_cpd((1, 3), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function316.set_cpd((2, 3), (0.0, 0.0, 0.0019, 0.9981, 0.0, 0.0))
        pgm_function316.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function316.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function316.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function316.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function316.set_cpd((1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function316.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function316.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function316.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function316.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function316.set_cpd((0, 5), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function316.set_cpd((1, 5), (0.0, 0.99939994, 0.00050005, 0.00010001, 0.0, 0.0))
        pgm_function316.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function316.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function316.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function316.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor317 = self.new_factor(R_ADM_MUSIZE, R_MUSCLE_ADM_MUSIZE, R_LNL_DIFFN_ADM_MUSIZE)
        pgm_function317 = pgm_factor317.set_cpt()
        pgm_function317.set_cpd((0, 0), (0.9791, 0.0009, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function317.set_cpd((1, 0), (0.9637, 0.0163, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function317.set_cpd((2, 0), (0.92219222, 0.05780578, 0.0, 0.0, 0.0, 0.0, 0.020002))
        pgm_function317.set_cpd((3, 0), (0.39793979, 0.56635664, 0.01550155, 0.00020002, 0.0, 0.0, 0.020002))
        pgm_function317.set_cpd((4, 0), (0.0435, 0.7319, 0.193, 0.0114, 0.0002, 0.0, 0.02))
        pgm_function317.set_cpd((5, 0),
                                (0.00120012, 0.23172317, 0.58825883, 0.14741474, 0.01120112, 0.00020002, 0.020002))
        pgm_function317.set_cpd((0, 1), (0.9637, 0.0163, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function317.set_cpd((1, 1), (0.7493, 0.2257, 0.0049, 0.0001, 0.0, 0.0, 0.02))
        pgm_function317.set_cpd((2, 1), (0.0537, 0.8568, 0.0684, 0.0011, 0.0, 0.0, 0.02))
        pgm_function317.set_cpd((3, 1),
                                (0.00389961, 0.38106189, 0.50654935, 0.08409159, 0.00429957, 9.999e-05, 0.019998))
        pgm_function317.set_cpd((4, 1), (0.0, 0.0395, 0.5059, 0.355, 0.0758, 0.0038, 0.02))
        pgm_function317.set_cpd((5, 1), (0.0, 0.00110011, 0.13571357, 0.40254025, 0.36313631, 0.07750775, 0.020002))
        pgm_function317.set_cpd((0, 2), (0.92219222, 0.05780578, 0.0, 0.0, 0.0, 0.0, 0.020002))
        pgm_function317.set_cpd((1, 2), (0.0537, 0.8568, 0.0684, 0.0011, 0.0, 0.0, 0.02))
        pgm_function317.set_cpd((2, 2), (0.0, 0.0, 0.98, 0.0, 0.0, 0.0, 0.02))
        pgm_function317.set_cpd((3, 2), (0.0, 0.0, 0.09080908, 0.81858186, 0.07060706, 0.0, 0.020002))
        pgm_function317.set_cpd((4, 2), (0.0, 0.0, 0.0001, 0.0721, 0.8357, 0.0721, 0.02))
        pgm_function317.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0001, 0.0778, 0.9021, 0.02))
        pgm_function317.set_cpd((0, 3), (0.39793979, 0.56635664, 0.01550155, 0.00020002, 0.0, 0.0, 0.020002))
        pgm_function317.set_cpd((1, 3),
                                (0.00389961, 0.38106189, 0.50654935, 0.08409159, 0.00429957, 9.999e-05, 0.019998))
        pgm_function317.set_cpd((2, 3), (0.0, 0.0, 0.09080908, 0.81858186, 0.07060706, 0.0, 0.020002))
        pgm_function317.set_cpd((3, 3), (0.0, 0.0, 0.00359964, 0.16548345, 0.64543546, 0.16548345, 0.019998))
        pgm_function317.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0034, 0.1993, 0.7773, 0.02))
        pgm_function317.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.01620162, 0.96379638, 0.020002))
        pgm_function317.set_cpd((0, 4), (0.0435, 0.7319, 0.193, 0.0114, 0.0002, 0.0, 0.02))
        pgm_function317.set_cpd((1, 4), (0.0, 0.0395, 0.5059, 0.355, 0.0758, 0.0038, 0.02))
        pgm_function317.set_cpd((2, 4), (0.0, 0.0, 0.0001, 0.0721, 0.8357, 0.0721, 0.02))
        pgm_function317.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0034, 0.1993, 0.7773, 0.02))
        pgm_function317.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 0.01620162, 0.96379638, 0.020002))
        pgm_function317.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0011, 0.9789, 0.02))
        pgm_function317.set_cpd((0, 5),
                                (0.00120012, 0.23172317, 0.58825883, 0.14741474, 0.01120112, 0.00020002, 0.020002))
        pgm_function317.set_cpd((1, 5), (0.0, 0.00110011, 0.13571357, 0.40254025, 0.36313631, 0.07750775, 0.020002))
        pgm_function317.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0001, 0.0778, 0.9021, 0.02))
        pgm_function317.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.01620162, 0.96379638, 0.020002))
        pgm_function317.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0011, 0.9789, 0.02))
        pgm_function317.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0001, 0.9799, 0.02))
        pgm_factor318 = self.new_factor(R_ADM_EFFMUS, R_ADM_NMT, R_ADM_MUSIZE)
        pgm_function318 = pgm_factor318.set_cpt()
        pgm_function318.set_cpd((0, 0), (0.9683, 0.0117, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function318.set_cpd((1, 0), (0.9794, 0.0006, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function318.set_cpd((2, 0), (0.9799, 0.0001, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function318.set_cpd((3, 0), (0.9742, 0.0058, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function318.set_cpd((4, 0), (0.9789, 0.0011, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function318.set_cpd((5, 0), (0.9799, 0.0001, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function318.set_cpd((6, 0), (0.7927, 0.1721, 0.0135, 0.0016, 0.0001, 0.0, 0.02))
        pgm_function318.set_cpd((0, 1), (0.0164, 0.9421, 0.0215, 0.0, 0.0, 0.0, 0.02))
        pgm_function318.set_cpd((1, 1), (0.8182, 0.1616, 0.0002, 0.0, 0.0, 0.0, 0.02))
        pgm_function318.set_cpd((2, 1), (0.9738, 0.0062, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function318.set_cpd((3, 1), (0.0329, 0.9359, 0.0112, 0.0, 0.0, 0.0, 0.02))
        pgm_function318.set_cpd((4, 1), (0.3885, 0.59, 0.0015, 0.0, 0.0, 0.0, 0.02))
        pgm_function318.set_cpd((5, 1), (0.9362, 0.0438, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function318.set_cpd((6, 1),
                                (0.4929507, 0.37036296, 0.09059094, 0.02169783, 0.00389961, 0.00049995, 0.019998))
        pgm_function318.set_cpd((0, 2), (0.0, 0.0, 0.97369737, 0.00630063, 0.0, 0.0, 0.020002))
        pgm_function318.set_cpd((1, 2), (0.00070007, 0.94039404, 0.03890389, 0.0, 0.0, 0.0, 0.020002))
        pgm_function318.set_cpd((2, 2), (0.7833, 0.1966, 0.0001, 0.0, 0.0, 0.0, 0.02))
        pgm_function318.set_cpd((3, 2), (0.0, 9.999e-05, 0.97830217, 0.00159984, 0.0, 0.0, 0.019998))
        pgm_function318.set_cpd((4, 2), (0.0, 0.3781, 0.6016, 0.0003, 0.0, 0.0, 0.02))
        pgm_function318.set_cpd((5, 2), (0.01149885, 0.96530347, 0.00319968, 0.0, 0.0, 0.0, 0.019998))
        pgm_function318.set_cpd((6, 2),
                                (0.15051505, 0.39773977, 0.27152715, 0.11721172, 0.03610361, 0.00690069, 0.020002))
        pgm_function318.set_cpd((0, 3), (0.0, 0.0, 0.0082, 0.9646, 0.0072, 0.0, 0.02))
        pgm_function318.set_cpd((1, 3), (0.0, 0.0571, 0.8829, 0.04, 0.0, 0.0, 0.02))
        pgm_function318.set_cpd((2, 3), (0.0541, 0.9055, 0.0203, 0.0001, 0.0, 0.0, 0.02))
        pgm_function318.set_cpd((3, 3), (0.0, 0.0, 0.03260326, 0.94569457, 0.00170017, 0.0, 0.020002))
        pgm_function318.set_cpd((4, 3), (0.0, 0.0, 0.7931, 0.1868, 0.0001, 0.0, 0.02))
        pgm_function318.set_cpd((5, 3), (0.0, 0.439, 0.5362, 0.0048, 0.0, 0.0, 0.02))
        pgm_function318.set_cpd((6, 3), (0.0391, 0.2318, 0.3318, 0.2294, 0.1131, 0.0348, 0.02))
        pgm_function318.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0072, 0.9656, 0.0072, 0.02))
        pgm_function318.set_cpd((1, 4), (0.0, 0.0001, 0.3198, 0.6276, 0.0325, 0.0, 0.02))
        pgm_function318.set_cpd((2, 4), (0.0004, 0.4664, 0.4912, 0.0219, 0.0001, 0.0, 0.02))
        pgm_function318.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0287, 0.9496, 0.0017, 0.02))
        pgm_function318.set_cpd((4, 4), (0.0, 0.0, 0.0071, 0.7665, 0.2063, 0.0001, 0.02))
        pgm_function318.set_cpd((5, 4), (0.0, 0.00150015, 0.70187019, 0.27382738, 0.00280028, 0.0, 0.020002))
        pgm_function318.set_cpd((6, 4), (0.0065, 0.0866, 0.2598, 0.2877, 0.2273, 0.1121, 0.02))
        pgm_function318.set_cpd((0, 5), (0.0, 0.0, 0.0, 0.0, 0.0072, 0.9728, 0.02))
        pgm_function318.set_cpd((1, 5), (0.0, 0.0, 0.0034, 0.2908, 0.6521, 0.0337, 0.02))
        pgm_function318.set_cpd((2, 5), (0.0, 0.01269746, 0.62637473, 0.32423515, 0.01659668, 9.998e-05, 0.019996))
        pgm_function318.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0287, 0.9513, 0.02))
        pgm_function318.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0062, 0.7673, 0.2065, 0.02))
        pgm_function318.set_cpd((5, 5), (0.0, 0.0, 0.03839616, 0.64913509, 0.28947105, 0.0029997, 0.019998))
        pgm_function318.set_cpd((6, 5),
                                (0.00079984, 0.02239552, 0.14087183, 0.24985003, 0.31623675, 0.24985003, 0.019996))
        pgm_function318.set_cpd((0, 6), (0.1111, 0.2284, 0.2388, 0.1875, 0.1354, 0.0788, 0.02))
        pgm_function318.set_cpd((1, 6),
                                (0.24267573, 0.30486951, 0.20687931, 0.12458754, 0.06949305, 0.03149685, 0.019998))
        pgm_function318.set_cpd((2, 6), (0.4236, 0.3196, 0.1381, 0.0628, 0.0267, 0.0092, 0.02))
        pgm_function318.set_cpd((3, 6), (0.1227, 0.2392, 0.2382, 0.1813, 0.127, 0.0716, 0.02))
        pgm_function318.set_cpd((4, 6),
                                (0.17768223, 0.27767223, 0.22747725, 0.15348465, 0.09559044, 0.04809519, 0.019998))
        pgm_function318.set_cpd((5, 6), (0.2958, 0.3186, 0.1878, 0.1033, 0.0527, 0.0218, 0.02))
        pgm_function318.set_cpd((6, 6),
                                (0.21972197, 0.26492649, 0.20142014, 0.14061406, 0.09640964, 0.05690569, 0.020002))
        pgm_factor319 = self.new_factor(R_OTHER_ULN_BLOCK_WA)
        pgm_function319 = pgm_factor319.set_cpt()
        pgm_function319.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor320 = self.new_factor(R_LNLW_ULN_BLOCK)
        pgm_function320 = pgm_factor320.set_cpt()
        pgm_function320.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor321 = self.new_factor(R_DIFFN_LNLW_ULN_BLOCK_WA, R_DIFFN_ULN_BLOCK, R_LNLW_ULN_BLOCK)
        pgm_function321 = pgm_factor321.set_cpt()
        pgm_function321.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function321.set_cpd((1, 0), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function321.set_cpd((2, 0), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function321.set_cpd((3, 0), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function321.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function321.set_cpd((0, 1), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function321.set_cpd((1, 1), (0.0001, 0.498, 0.5019, 0.0, 0.0))
        pgm_function321.set_cpd((2, 1), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function321.set_cpd((3, 1), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function321.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function321.set_cpd((0, 2), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function321.set_cpd((1, 2), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function321.set_cpd((2, 2), (0.0, 0.0007, 0.4328, 0.5665, 0.0))
        pgm_function321.set_cpd((3, 2), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function321.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function321.set_cpd((0, 3), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function321.set_cpd((1, 3), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function321.set_cpd((2, 3), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function321.set_cpd((3, 3), (0.00030003, 0.00110011, 0.01250125, 0.98609861, 0.0))
        pgm_function321.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function321.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function321.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function321.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function321.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function321.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor322 = self.new_factor(R_ULN_BLOCK_WA, R_OTHER_ULN_BLOCK_WA, R_DIFFN_LNLW_ULN_BLOCK_WA)
        pgm_function322 = pgm_factor322.set_cpt()
        pgm_function322.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function322.set_cpd((1, 0), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function322.set_cpd((2, 0), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function322.set_cpd((3, 0), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function322.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function322.set_cpd((0, 1), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function322.set_cpd((1, 1), (0.0001, 0.498, 0.5019, 0.0, 0.0))
        pgm_function322.set_cpd((2, 1), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function322.set_cpd((3, 1), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function322.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function322.set_cpd((0, 2), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function322.set_cpd((1, 2), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function322.set_cpd((2, 2), (0.0, 0.0007, 0.4328, 0.5665, 0.0))
        pgm_function322.set_cpd((3, 2), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function322.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function322.set_cpd((0, 3), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function322.set_cpd((1, 3), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function322.set_cpd((2, 3), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function322.set_cpd((3, 3), (0.00030003, 0.00110011, 0.01250125, 0.98609861, 0.0))
        pgm_function322.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function322.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function322.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function322.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function322.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function322.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor323 = self.new_factor(R_ADM_MULOSS, R_ULN_BLOCK_WA, R_ADM_MALOSS)
        pgm_function323 = pgm_factor323.set_cpt()
        pgm_function323.set_cpd((0, 0), (0.98, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function323.set_cpd((1, 0), (0.9746, 0.0054, 0.0, 0.0, 0.0, 0.02))
        pgm_function323.set_cpd((2, 0), (0.0664, 0.9136, 0.0, 0.0, 0.0, 0.02))
        pgm_function323.set_cpd((3, 0), (0.016, 0.1801, 0.7138, 0.0701, 0.0, 0.02))
        pgm_function323.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function323.set_cpd((0, 1), (0.0167, 0.9613, 0.002, 0.0, 0.0, 0.02))
        pgm_function323.set_cpd((1, 1), (0.00340034, 0.9529953, 0.02360236, 0.0, 0.0, 0.020002))
        pgm_function323.set_cpd((2, 1), (0.0002, 0.2725, 0.7073, 0.0, 0.0, 0.02))
        pgm_function323.set_cpd((3, 1), (0.0009, 0.0263, 0.4192, 0.5336, 0.0, 0.02))
        pgm_function323.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function323.set_cpd((0, 2), (0.00019998, 0.05349465, 0.92370763, 0.00259974, 0.0, 0.019998))
        pgm_function323.set_cpd((1, 2), (0.0, 0.02340234, 0.94509451, 0.01150115, 0.0, 0.020002))
        pgm_function323.set_cpd((2, 2), (0.0, 0.0048, 0.7523, 0.2229, 0.0, 0.02))
        pgm_function323.set_cpd((3, 2), (0.0, 0.00130013, 0.06370637, 0.9149915, 0.0, 0.020002))
        pgm_function323.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function323.set_cpd((0, 3), (0.0, 0.00030003, 0.04810481, 0.93159316, 0.0, 0.020002))
        pgm_function323.set_cpd((1, 3), (0.0, 0.00010001, 0.0270027, 0.95289529, 0.0, 0.020002))
        pgm_function323.set_cpd((2, 3), (0.0, 0.0, 0.0091, 0.9709, 0.0, 0.02))
        pgm_function323.set_cpd((3, 3), (0.0, 0.0001, 0.0087, 0.9712, 0.0, 0.02))
        pgm_function323.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function323.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function323.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function323.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function323.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function323.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function323.set_cpd((0, 5), (0.1427, 0.2958, 0.4254, 0.1161, 0.0, 0.02))
        pgm_function323.set_cpd((1, 5), (0.1157, 0.2677, 0.4444, 0.1522, 0.0, 0.02))
        pgm_function323.set_cpd((2, 5), (0.06939306, 0.20107989, 0.45265473, 0.25687431, 0.0, 0.019998))
        pgm_function323.set_cpd((3, 5), (0.0173, 0.0696, 0.2854, 0.6077, 0.0, 0.02))
        pgm_function323.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_factor324 = self.new_factor(R_ADM_ALLAMP_WA, R_ADM_EFFMUS, R_ADM_MULOSS)
        pgm_function324 = pgm_factor324.set_cpt()
        pgm_function324.set_cpd((0, 0),
                                (0.00260026, 0.36873687, 0.60756076, 0.02080208, 0.00030003, 0.0, 0.0, 0.0, 0.0))
        pgm_function324.set_cpd((1, 0), (0.0, 0.0002, 0.4149, 0.4809, 0.0802, 0.0218, 0.002, 0.0, 0.0))
        pgm_function324.set_cpd((2, 0), (0.0, 0.0, 0.0, 0.0, 0.0215, 0.9785, 0.0, 0.0, 0.0))
        pgm_function324.set_cpd((3, 0), (0.0, 0.0, 0.0, 0.0, 0.0018, 0.0536, 0.8696, 0.075, 0.0))
        pgm_function324.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0736, 0.8528, 0.0736))
        pgm_function324.set_cpd((5, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.0794, 0.9205))
        pgm_function324.set_cpd((6, 0), (0.0003, 0.006, 0.105, 0.205, 0.1633, 0.141, 0.1771, 0.1279, 0.0744))
        pgm_function324.set_cpd((0, 1), (0.0409, 0.8924, 0.0661, 0.0006, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function324.set_cpd((1, 1), (0.0, 0.01, 0.77, 0.2049, 0.0128, 0.0022, 0.0001, 0.0, 0.0))
        pgm_function324.set_cpd((2, 1), (0.0, 0.0, 0.0, 0.2489, 0.7398, 0.0113, 0.0, 0.0, 0.0))
        pgm_function324.set_cpd((3, 1),
                                (0.0, 0.0, 0.0, 0.00420042, 0.34683468, 0.53485349, 0.11371137, 0.00040004, 0.0))
        pgm_function324.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 0.0064, 0.0855, 0.788, 0.1197, 0.0004))
        pgm_function324.set_cpd((5, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.00029997, 0.11648835, 0.76672333, 0.11648835))
        pgm_function324.set_cpd((6, 1), (
            0.00190019, 0.0230023, 0.190019, 0.26232623, 0.16291629, 0.12441244, 0.12641264, 0.0740074, 0.0350035))
        pgm_function324.set_cpd((0, 2), (0.2926, 0.7043, 0.0031, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function324.set_cpd((1, 2), (0.0091, 0.4203, 0.5312, 0.038, 0.0012, 0.0002, 0.0, 0.0, 0.0))
        pgm_function324.set_cpd((2, 2), (0.0, 0.0, 0.30946905, 0.68073193, 0.00949905, 0.00029997, 0.0, 0.0, 0.0))
        pgm_function324.set_cpd((3, 2), (0.0, 0.0, 0.018, 0.6298, 0.2744, 0.0746, 0.0032, 0.0, 0.0))
        pgm_function324.set_cpd((4, 2),
                                (0.0, 0.0, 0.00010001, 0.10461046, 0.42814281, 0.35683568, 0.10711071, 0.00320032, 0.0))
        pgm_function324.set_cpd((5, 2),
                                (0.0, 0.0, 0.0, 0.00250025, 0.09780978, 0.24982498, 0.53235324, 0.11411141, 0.00340034))
        pgm_function324.set_cpd((6, 2), (
            0.01440144, 0.09930993, 0.30283028, 0.27022702, 0.12431243, 0.08210821, 0.06520652, 0.03020302, 0.01140114))
        pgm_function324.set_cpd((0, 3), (0.781, 0.2189, 0.0001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function324.set_cpd((1, 3), (0.26692669, 0.71617162, 0.01660166, 0.00030003, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function324.set_cpd((2, 3), (9.999e-05, 0.10278972, 0.87921208, 0.01779822, 9.999e-05, 0.0, 0.0, 0.0, 0.0))
        pgm_function324.set_cpd((3, 3),
                                (0.0, 0.00440044, 0.81118112, 0.17621762, 0.00730073, 0.00090009, 0.0, 0.0, 0.0))
        pgm_function324.set_cpd((4, 3),
                                (0.0, 9.999e-05, 0.4129587, 0.49655034, 0.07189281, 0.01729827, 0.00119988, 0.0, 0.0))
        pgm_function324.set_cpd((5, 3),
                                (0.0, 0.0, 0.07810781, 0.51965197, 0.2610261, 0.11671167, 0.02340234, 0.00110011, 0.0))
        pgm_function324.set_cpd((6, 3), (0.1169, 0.3697, 0.2867, 0.1411, 0.0431, 0.0234, 0.0133, 0.0045, 0.0013))
        pgm_function324.set_cpd((0, 4), (0.9907, 0.0093, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function324.set_cpd((1, 4), (0.9858, 0.0142, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function324.set_cpd((2, 4), (0.9865, 0.0135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function324.set_cpd((3, 4), (0.982, 0.018, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function324.set_cpd((4, 4), (0.9779, 0.0221, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function324.set_cpd((5, 4), (0.973, 0.027, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function324.set_cpd((6, 4), (0.9370063, 0.06289371, 9.999e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function324.set_cpd((0, 5), (
            0.35956404, 0.51474853, 0.09409059, 0.0239976, 0.00459954, 0.0019998, 0.00079992, 0.00019998, 0.0))
        pgm_function324.set_cpd((1, 5), (
            0.13358664, 0.38546145, 0.26977302, 0.13078692, 0.04009599, 0.02189781, 0.01269873, 0.00439956, 0.00129987))
        pgm_function324.set_cpd((2, 5), (0.0096, 0.0788, 0.2992, 0.2816, 0.1319, 0.0873, 0.0689, 0.0313, 0.0114))
        pgm_function324.set_cpd((3, 5), (
            0.00260052, 0.02890578, 0.20404081, 0.26575315, 0.15943189, 0.11992398, 0.1190238, 0.06841368, 0.03190638))
        pgm_function324.set_cpd((4, 5), (
            0.00049995, 0.00839916, 0.11818818, 0.21387861, 0.1629837, 0.13818618, 0.16908309, 0.11988801, 0.06889311))
        pgm_function324.set_cpd((5, 5), (0.0001, 0.0021, 0.0586, 0.1473, 0.1427, 0.1363, 0.2057, 0.1798, 0.1274))
        pgm_function324.set_cpd((6, 5), (
            0.05210521, 0.16081608, 0.22722272, 0.20132013, 0.10661066, 0.07920792, 0.08310831, 0.05590559, 0.03370337))
        pgm_factor325 = self.new_factor(R_ULN_AMP_WA, R_ADM_ALLAMP_WA)
        pgm_function325 = pgm_factor325.set_cpt()
        pgm_function325.set_cpd((0,),
                                (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function325.set_cpd((1,), (
            0.0, 0.27192719, 0.23362336, 0.18271827, 0.12981298, 0.0840084, 0.04940494, 0.02640264, 0.01290129,
            0.00570057,
            0.00230023, 0.00080008, 0.00030003, 0.00010001, 0.0, 0.0, 0.0))
        pgm_function325.set_cpd((2,), (
            0.0, 0.0006, 0.0045, 0.0217, 0.071, 0.1571, 0.2357, 0.2391, 0.1642, 0.0762, 0.024, 0.0051, 0.0007, 0.0001,
            0.0,
            0.0, 0.0))
        pgm_function325.set_cpd((3,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00130013, 0.01820182, 0.10931093, 0.29312931, 0.34783478, 0.18291829,
            0.04270427, 0.00440044, 0.00020002, 0.0, 0.0))
        pgm_function325.set_cpd((4,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0016, 0.036, 0.2338, 0.4425, 0.2448, 0.0394, 0.0019, 0.0))
        pgm_function325.set_cpd((5,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0042, 0.1369, 0.5589, 0.2821, 0.0178, 0.0001))
        pgm_function325.set_cpd((6,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00030003, 0.00640064, 0.05730573, 0.22752275,
            0.39933993, 0.30913091))
        pgm_function325.set_cpd((7,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0010001, 0.02130213, 0.19281928,
            0.78487849))
        pgm_function325.set_cpd((8,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.0446, 0.9544))
        pgm_factor326 = self.new_factor(R_ULN_LD_WA)
        pgm_function326 = pgm_factor326.set_cpt()
        pgm_function326.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor327 = self.new_factor(R_ULN_RD_WA)
        pgm_function327 = pgm_factor327.set_cpt()
        pgm_function327.set_cpd((), (1.0, 0.0, 0.0))
        pgm_factor328 = self.new_factor(R_ULN_RDLDDEL, R_ULN_LD_WA, R_ULN_RD_WA)
        pgm_function328 = pgm_factor328.set_cpt()
        pgm_function328.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function328.set_cpd((1, 0), (0.0964, 0.7981, 0.1055, 0.0, 0.0))
        pgm_function328.set_cpd((2, 0), (0.0032, 0.127, 0.8698, 0.0, 0.0))
        pgm_function328.set_cpd((3, 0), (0.00090009, 0.00280028, 0.01470147, 0.98159816, 0.0))
        pgm_function328.set_cpd((0, 1), (0.0019, 0.5257, 0.4724, 0.0, 0.0))
        pgm_function328.set_cpd((1, 1), (0.00019998, 0.04149585, 0.95830417, 0.0, 0.0))
        pgm_function328.set_cpd((2, 1), (0.0001, 0.0144, 0.9855, 0.0, 0.0))
        pgm_function328.set_cpd((3, 1), (0.00019998, 0.00059994, 0.00369963, 0.99550045, 0.0))
        pgm_function328.set_cpd((0, 2), (0.0002, 0.0304, 0.9694, 0.0, 0.0))
        pgm_function328.set_cpd((1, 2), (0.0001, 0.0142, 0.9857, 0.0, 0.0))
        pgm_function328.set_cpd((2, 2), (0.0, 0.009, 0.9808, 0.0102, 0.0))
        pgm_function328.set_cpd((3, 2), (0.0, 0.0002, 0.0012, 0.9984, 0.0002))
        pgm_factor329 = self.new_factor(R_ULN_DIFSLOW_WA, R_LNLE_ULN_DIFSLOW, R_DIFFN_ULN_DIFSLOW)
        pgm_function329 = pgm_factor329.set_cpt()
        pgm_function329.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function329.set_cpd((1, 0), (0.01319868, 0.98620138, 0.00059994, 0.0))
        pgm_function329.set_cpd((2, 0), (0.0, 0.01810181, 0.98189819, 0.0))
        pgm_function329.set_cpd((3, 0), (0.0, 0.0003, 0.0252, 0.9745))
        pgm_function329.set_cpd((0, 1), (0.01319868, 0.98620138, 0.00059994, 0.0))
        pgm_function329.set_cpd((1, 1), (0.0001, 0.0952, 0.9047, 0.0))
        pgm_function329.set_cpd((2, 1), (0.0, 0.0009, 0.588, 0.4111))
        pgm_function329.set_cpd((3, 1), (0.0, 0.0, 0.00440044, 0.99559956))
        pgm_function329.set_cpd((0, 2), (0.0, 0.01810181, 0.98189819, 0.0))
        pgm_function329.set_cpd((1, 2), (0.0, 0.0009, 0.588, 0.4111))
        pgm_function329.set_cpd((2, 2), (0.0, 0.0, 0.002, 0.998))
        pgm_function329.set_cpd((3, 2), (0.0, 0.0, 0.0006, 0.9994))
        pgm_function329.set_cpd((0, 3), (0.0, 0.0003, 0.0252, 0.9745))
        pgm_function329.set_cpd((1, 3), (0.0, 0.0, 0.00440044, 0.99559956))
        pgm_function329.set_cpd((2, 3), (0.0, 0.0, 0.0006, 0.9994))
        pgm_function329.set_cpd((3, 3), (0.0, 0.0, 0.0005, 0.9995))
        pgm_factor330 = self.new_factor(R_ULN_DCV_WA, R_ADM_MALOSS, R_ULN_DIFSLOW_WA)
        pgm_function330 = pgm_factor330.set_cpt()
        pgm_function330.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function330.set_cpd((1, 0), (0.1136, 0.8864, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function330.set_cpd((2, 0), (0.0006, 0.0764, 0.8866, 0.0364, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function330.set_cpd((3, 0), (0.0, 0.0, 0.0655, 0.9299, 0.0046, 0.0, 0.0, 0.0, 0.0))
        pgm_function330.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function330.set_cpd((5, 0), (0.1523, 0.2904, 0.3678, 0.1726, 0.0169, 0.0, 0.0, 0.0, 0.0))
        pgm_function330.set_cpd((0, 1), (0.008, 0.168, 0.7407, 0.0833, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function330.set_cpd((1, 1),
                                (0.00089991, 0.03679632, 0.55764424, 0.40245975, 0.00219978, 0.0, 0.0, 0.0, 0.0))
        pgm_function330.set_cpd((2, 1),
                                (0.0, 0.00070007, 0.05250525, 0.57125713, 0.37523752, 0.00030003, 0.0, 0.0, 0.0))
        pgm_function330.set_cpd((3, 1), (0.0, 0.0, 0.0007, 0.0745, 0.8859, 0.0389, 0.0, 0.0, 0.0))
        pgm_function330.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function330.set_cpd((5, 1), (0.0168, 0.0618, 0.2223, 0.4015, 0.2803, 0.0172, 0.0001, 0.0, 0.0))
        pgm_function330.set_cpd((0, 2), (
            0.00069986, 0.00589882, 0.0614877, 0.30063987, 0.55258949, 0.07818436, 0.0004999, 0.0, 0.0))
        pgm_function330.set_cpd((1, 2), (0.0002, 0.0018, 0.0263, 0.1887, 0.5884, 0.1916, 0.003, 0.0, 0.0))
        pgm_function330.set_cpd((2, 2), (0.0, 0.0001, 0.0024, 0.0358, 0.316, 0.5741, 0.0716, 0.0, 0.0))
        pgm_function330.set_cpd((3, 2),
                                (0.0, 0.0, 9.999e-05, 0.00319968, 0.07809219, 0.59464054, 0.32356764, 0.00039996, 0.0))
        pgm_function330.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function330.set_cpd((5, 2), (
            0.0009999, 0.00469953, 0.0279972, 0.11838816, 0.36466353, 0.39226077, 0.09069093, 0.00029997, 0.0))
        pgm_function330.set_cpd((0, 3), (0.0001, 0.0003, 0.0018, 0.011, 0.067, 0.2945, 0.5047, 0.1206, 0.0))
        pgm_function330.set_cpd((1, 3), (
            0.0, 0.00010001, 0.00090009, 0.00590059, 0.04220422, 0.23562356, 0.52255226, 0.19271927, 0.0))
        pgm_function330.set_cpd((2, 3), (0.0, 0.0, 0.0001, 0.0012, 0.0121, 0.1131, 0.4415, 0.432, 0.0))
        pgm_function330.set_cpd((3, 3),
                                (0.0, 0.0, 0.0, 0.00020002, 0.00280028, 0.04390439, 0.29172917, 0.66136614, 0.0))
        pgm_function330.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function330.set_cpd((5, 3), (0.0, 0.0002, 0.0011, 0.0057, 0.0332, 0.1704, 0.4424, 0.347, 0.0))
        pgm_factor331 = self.new_factor(R_ULN_ALLDEL_WA, R_ULN_RDLDDEL, R_ULN_DCV_WA)
        pgm_function331 = pgm_factor331.set_cpt()
        pgm_function331.set_cpd((0, 0), (0.9996, 0.0004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function331.set_cpd((1, 0), (0.05119488, 0.22907709, 0.56624338, 0.15348465, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function331.set_cpd((2, 0), (0.0001, 0.0035, 0.0632, 0.9326, 0.0006, 0.0, 0.0, 0.0, 0.0))
        pgm_function331.set_cpd((3, 0), (
            0.00129987, 0.0019998, 0.00439956, 0.01869813, 0.12128787, 0.74792521, 0.10438956, 0.0, 0.0))
        pgm_function331.set_cpd((4, 0), (
            0.00010001, 0.00010001, 0.00030003, 0.00090009, 0.00450045, 0.04340434, 0.57675768, 0.37393739, 0.0))
        pgm_function331.set_cpd((0, 1), (0.5607, 0.4393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function331.set_cpd((1, 1), (0.01929807, 0.12868713, 0.49285071, 0.35916408, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function331.set_cpd((2, 1), (0.0, 0.0011, 0.0283, 0.9651, 0.0055, 0.0, 0.0, 0.0, 0.0))
        pgm_function331.set_cpd((3, 1), (
            0.0010001, 0.00160016, 0.00370037, 0.01610161, 0.10931093, 0.74217422, 0.12611261, 0.0, 0.0))
        pgm_function331.set_cpd((4, 1), (0.0001, 0.0001, 0.0002, 0.0008, 0.0041, 0.0399, 0.5568, 0.398, 0.0))
        pgm_function331.set_cpd((0, 2), (0.0069, 0.7963, 0.1968, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function331.set_cpd((1, 2), (0.0027, 0.0328, 0.2398, 0.7246, 0.0001, 0.0, 0.0, 0.0, 0.0))
        pgm_function331.set_cpd((2, 2), (0.0, 0.0002, 0.0075, 0.8889, 0.1034, 0.0, 0.0, 0.0, 0.0))
        pgm_function331.set_cpd((3, 2), (
            0.00079992, 0.00119988, 0.00279972, 0.01249875, 0.09159084, 0.72352765, 0.16758324, 0.0, 0.0))
        pgm_function331.set_cpd((4, 2), (0.0001, 0.0001, 0.0002, 0.0007, 0.0034, 0.0348, 0.5239, 0.4368, 0.0))
        pgm_function331.set_cpd((0, 3), (0.0, 0.0184, 0.9806, 0.001, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function331.set_cpd((1, 3),
                                (0.00010001, 0.00330033, 0.05470547, 0.93819382, 0.00370037, 0.0, 0.0, 0.0, 0.0))
        pgm_function331.set_cpd((2, 3), (0.0, 0.0, 0.00030003, 0.1850185, 0.81468147, 0.0, 0.0, 0.0, 0.0))
        pgm_function331.set_cpd((3, 3), (
            0.00049995, 0.00079992, 0.00179982, 0.00869913, 0.07029297, 0.68023198, 0.23767623, 0.0, 0.0))
        pgm_function331.set_cpd((4, 3), (0.0001, 0.0001, 0.0001, 0.0005, 0.0027, 0.0287, 0.4783, 0.4895, 0.0))
        pgm_function331.set_cpd((0, 4), (0.0, 0.0001, 0.0179, 0.982, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function331.set_cpd((1, 4), (0.0, 0.00019998, 0.00479952, 0.50394961, 0.49105089, 0.0, 0.0, 0.0, 0.0))
        pgm_function331.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0032, 0.9968, 0.0, 0.0, 0.0, 0.0))
        pgm_function331.set_cpd((3, 4), (0.0002, 0.0004, 0.0009, 0.0047, 0.044, 0.5737, 0.3761, 0.0, 0.0))
        pgm_function331.set_cpd((4, 4),
                                (0.0, 0.0, 0.00010001, 0.00030003, 0.00180018, 0.0210021, 0.40724072, 0.56955696, 0.0))
        pgm_function331.set_cpd((0, 5), (0.0, 0.0002, 0.003, 0.1393, 0.8575, 0.0, 0.0, 0.0, 0.0))
        pgm_function331.set_cpd((1, 5), (0.0, 0.0, 0.0003, 0.0188, 0.9804, 0.0005, 0.0, 0.0, 0.0))
        pgm_function331.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.00150015, 0.93139314, 0.06710671, 0.0, 0.0, 0.0))
        pgm_function331.set_cpd((3, 5), (0.0001, 0.0001, 0.0002, 0.0013, 0.015, 0.3152, 0.6681, 0.0, 0.0))
        pgm_function331.set_cpd((4, 5),
                                (0.0, 0.0, 0.0, 0.00010002, 0.00080016, 0.01110222, 0.28045609, 0.70754151, 0.0))
        pgm_function331.set_cpd((0, 6), (0.0, 0.0, 0.0, 0.0006, 0.8145, 0.1849, 0.0, 0.0, 0.0))
        pgm_function331.set_cpd((1, 6), (0.0, 0.0, 0.0, 0.0, 0.0494, 0.9506, 0.0, 0.0, 0.0))
        pgm_function331.set_cpd((2, 6), (0.0, 0.0, 0.0, 0.0, 0.001, 0.999, 0.0, 0.0, 0.0))
        pgm_function331.set_cpd((3, 6), (0.0, 0.0, 0.0, 0.0001, 0.0017, 0.0786, 0.9196, 0.0, 0.0))
        pgm_function331.set_cpd((4, 6), (0.0, 0.0, 0.0, 0.0, 0.0002, 0.0035, 0.138, 0.8583, 0.0))
        pgm_function331.set_cpd((0, 7), (0.0, 0.0, 0.0, 0.00040004, 0.01130113, 0.59735974, 0.39093909, 0.0, 0.0))
        pgm_function331.set_cpd((1, 7), (0.0, 0.0, 0.0, 0.00010001, 0.00340034, 0.2990299, 0.69746975, 0.0, 0.0))
        pgm_function331.set_cpd((2, 7), (0.0, 0.0, 0.0, 0.0, 0.0007, 0.1112, 0.8881, 0.0, 0.0))
        pgm_function331.set_cpd((3, 7), (0.0, 0.0, 0.0, 0.0, 0.00010001, 0.00940094, 0.95939594, 0.03110311, 0.0))
        pgm_function331.set_cpd((4, 7), (0.0, 0.0, 0.0, 0.0, 0.0, 0.00030003, 0.02530253, 0.97439744, 0.0))
        pgm_function331.set_cpd((0, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function331.set_cpd((1, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function331.set_cpd((2, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function331.set_cpd((3, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function331.set_cpd((4, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor332 = self.new_factor(R_ULN_LAT_WA, R_ULN_ALLDEL_WA)
        pgm_function332 = pgm_factor332.set_cpt()
        pgm_function332.set_cpd((0,), (
            0.2221, 0.5402, 0.2221, 0.0154, 0.0002, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0))
        pgm_function332.set_cpd((1,), (
            0.03780378, 0.23962396, 0.44344434, 0.23962396, 0.03780378, 0.00170017, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0,
            0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function332.set_cpd((2,), (
            0.00170017, 0.03770377, 0.23912391, 0.44244424, 0.23912391, 0.03770377, 0.00220022, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function332.set_cpd((3,), (
            0.0001, 0.0019, 0.0176, 0.0873, 0.2279, 0.3138, 0.2849, 0.0637, 0.0028, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0,
            0.0, 0.0))
        pgm_function332.set_cpd((4,), (
            0.0004, 0.0015, 0.0044, 0.0114, 0.0255, 0.0495, 0.1033, 0.2035, 0.24, 0.2035, 0.0989, 0.0529, 0.0049,
            0.0003,
            0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function332.set_cpd((5,), (
            0.00030003, 0.00050005, 0.00090009, 0.00160016, 0.00280028, 0.00450045, 0.00890089, 0.01950195, 0.03250325,
            0.04980498, 0.1110111, 0.16361636, 0.18941894, 0.25772577, 0.13571357, 0.02010201, 0.00110011, 0.0, 0.0))
        pgm_function332.set_cpd((6,), (
            0.00020002, 0.00030003, 0.00040004, 0.00060006, 0.00070007, 0.0010001, 0.00160016, 0.00290029, 0.00420042,
            0.00590059, 0.01340134, 0.02140214, 0.0330033, 0.07190719, 0.16781678, 0.22892289, 0.24362436, 0.20212021,
            0.0))
        pgm_function332.set_cpd((7,), (
            0.00079992, 0.0009999, 0.00119988, 0.00139986, 0.00159984, 0.00179982, 0.00269973, 0.0039996, 0.00489951,
            0.0059994, 0.01119888, 0.01649835, 0.02239776, 0.04509549, 0.10308969, 0.16628337, 0.25177482, 0.35826417,
            0.0))
        pgm_function332.set_cpd((8,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor333 = self.new_factor(R_ADM_VOL_ACT)
        pgm_function333 = pgm_factor333.set_cpt()
        pgm_function333.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor334 = self.new_factor(R_ADM_FORCE, R_ADM_VOL_ACT, R_ADM_ALLAMP_WA)
        pgm_function334 = pgm_factor334.set_cpt()
        pgm_function334.set_cpd((0, 0), (0.0, 0.0, 0.0, 0.00409959, 0.19078092, 0.80511949))
        pgm_function334.set_cpd((1, 0), (0.0, 0.0, 0.0, 0.001, 0.0578, 0.9412))
        pgm_function334.set_cpd((2, 0), (0.0, 0.0, 0.0, 9.999e-05, 0.01259874, 0.98730127))
        pgm_function334.set_cpd((3, 0), (0.0, 0.0, 0.0, 0.0, 0.00590059, 0.99409941))
        pgm_function334.set_cpd((0, 1), (9.999e-05, 0.00429957, 0.05219478, 0.26687331, 0.43305669, 0.24347565))
        pgm_function334.set_cpd((1, 1), (0.0, 0.0005, 0.0084, 0.0849, 0.3219, 0.5843))
        pgm_function334.set_cpd((2, 1), (0.0, 0.0, 0.0007, 0.0167, 0.1576, 0.825))
        pgm_function334.set_cpd((3, 1), (0.0, 0.0, 0.0, 0.00260026, 0.05860586, 0.93879388))
        pgm_function334.set_cpd((0, 2), (0.01490149, 0.23542354, 0.53315332, 0.20152015, 0.01490149, 0.00010001))
        pgm_function334.set_cpd((1, 2), (0.0009, 0.0256, 0.18, 0.4308, 0.3036, 0.0591))
        pgm_function334.set_cpd((2, 2), (0.0, 0.0005, 0.0128, 0.1328, 0.4061, 0.4478))
        pgm_function334.set_cpd((3, 2), (0.0, 0.0, 0.0003, 0.0091, 0.1181, 0.8725))
        pgm_function334.set_cpd((0, 3), (0.1538, 0.6493, 0.1936, 0.0033, 0.0, 0.0))
        pgm_function334.set_cpd((1, 3), (0.0098, 0.1589, 0.4714, 0.3101, 0.0485, 0.0013))
        pgm_function334.set_cpd((2, 3), (0.0001, 0.0049, 0.0751, 0.3632, 0.429, 0.1277))
        pgm_function334.set_cpd((3, 3), (0.0, 0.0, 0.0008, 0.0215, 0.1873, 0.7904))
        pgm_function334.set_cpd((0, 4), (0.6667, 0.3291, 0.0042, 0.0, 0.0, 0.0))
        pgm_function334.set_cpd((1, 4), (0.05370537, 0.42044204, 0.45484548, 0.0690069, 0.0020002, 0.0))
        pgm_function334.set_cpd((2, 4), (0.00050005, 0.02730273, 0.24332433, 0.50135014, 0.21182118, 0.01570157))
        pgm_function334.set_cpd((3, 4), (0.0, 9.999e-05, 0.00249975, 0.04719528, 0.27557244, 0.67463254))
        pgm_function334.set_cpd((0, 5), (0.94689469, 0.05310531, 0.0, 0.0, 0.0, 0.0))
        pgm_function334.set_cpd((1, 5), (0.11731173, 0.56585659, 0.3010301, 0.01570157, 0.00010001, 0.0))
        pgm_function334.set_cpd((2, 5), (0.00120012, 0.06020602, 0.38623862, 0.45424542, 0.09540954, 0.00270027))
        pgm_function334.set_cpd((3, 5), (0.0, 0.0001, 0.0044, 0.0713, 0.3326, 0.5916))
        pgm_function334.set_cpd((0, 6), (0.9782, 0.0218, 0.0, 0.0, 0.0, 0.0))
        pgm_function334.set_cpd((1, 6), (0.41015898, 0.47935206, 0.1069893, 0.00349965, 0.0, 0.0))
        pgm_function334.set_cpd((2, 6), (0.02560256, 0.2470247, 0.48384838, 0.21742174, 0.02560256, 0.00050005))
        pgm_function334.set_cpd((3, 6), (0.0, 0.0020002, 0.02790279, 0.18121812, 0.41124112, 0.37763776))
        pgm_function334.set_cpd((0, 7), (0.9971, 0.0029, 0.0, 0.0, 0.0, 0.0))
        pgm_function334.set_cpd((1, 7), (0.7017, 0.2755, 0.0226, 0.0002, 0.0, 0.0))
        pgm_function334.set_cpd((2, 7), (0.1171, 0.4443, 0.3699, 0.0654, 0.0033, 0.0))
        pgm_function334.set_cpd((3, 7), (0.0004, 0.0107, 0.0847, 0.3035, 0.3988, 0.2019))
        pgm_function334.set_cpd((0, 8), (0.9996, 0.0004, 0.0, 0.0, 0.0, 0.0))
        pgm_function334.set_cpd((1, 8), (0.8804, 0.1161, 0.0035, 0.0, 0.0, 0.0))
        pgm_function334.set_cpd((2, 8), (0.32706729, 0.4879512, 0.17268273, 0.0119988, 0.00029997, 0.0))
        pgm_function334.set_cpd((3, 8), (0.0030003, 0.04260426, 0.19481948, 0.38493849, 0.29292929, 0.08170817))
        pgm_factor335 = self.new_factor(R_ADM_MUSCLE_VOL, R_ADM_MUSIZE, R_ADM_MALOSS)
        pgm_function335 = pgm_factor335.set_cpt()
        pgm_function335.set_cpd((0, 0), (0.9896, 0.0104))
        pgm_function335.set_cpd((1, 0), (0.8137, 0.1863))
        pgm_function335.set_cpd((2, 0), (0.0209, 0.9791))
        pgm_function335.set_cpd((3, 0), (0.009, 0.991))
        pgm_function335.set_cpd((4, 0), (0.003, 0.997))
        pgm_function335.set_cpd((5, 0), (0.0004, 0.9996))
        pgm_function335.set_cpd((6, 0), (0.4212, 0.5788))
        pgm_function335.set_cpd((0, 1), (0.9976, 0.0024))
        pgm_function335.set_cpd((1, 1), (0.9603, 0.0397))
        pgm_function335.set_cpd((2, 1), (0.5185, 0.4815))
        pgm_function335.set_cpd((3, 1), (0.1087, 0.8913))
        pgm_function335.set_cpd((4, 1), (0.0278, 0.9722))
        pgm_function335.set_cpd((5, 1), (0.0046, 0.9954))
        pgm_function335.set_cpd((6, 1), (0.5185, 0.4815))
        pgm_function335.set_cpd((0, 2), (0.999, 0.001))
        pgm_function335.set_cpd((1, 2), (0.9893, 0.0107))
        pgm_function335.set_cpd((2, 2), (0.9588, 0.0412))
        pgm_function335.set_cpd((3, 2), (0.6377, 0.3623))
        pgm_function335.set_cpd((4, 2), (0.2716, 0.7284))
        pgm_function335.set_cpd((5, 2), (0.0779, 0.9221))
        pgm_function335.set_cpd((6, 2), (0.6336, 0.3664))
        pgm_function335.set_cpd((0, 3), (0.9995, 0.0005))
        pgm_function335.set_cpd((1, 3), (0.9969, 0.0031))
        pgm_function335.set_cpd((2, 3), (0.9953, 0.0047))
        pgm_function335.set_cpd((3, 3), (0.9518, 0.0482))
        pgm_function335.set_cpd((4, 3), (0.8234, 0.1766))
        pgm_function335.set_cpd((5, 3), (0.5986, 0.4014))
        pgm_function335.set_cpd((6, 3), (0.7685, 0.2315))
        pgm_function335.set_cpd((0, 4), (0.9989, 0.0011))
        pgm_function335.set_cpd((1, 4), (0.9984, 0.0016))
        pgm_function335.set_cpd((2, 4), (0.9984, 0.0016))
        pgm_function335.set_cpd((3, 4), (0.9975, 0.0025))
        pgm_function335.set_cpd((4, 4), (0.9965, 0.0035))
        pgm_function335.set_cpd((5, 4), (0.9956, 0.0044))
        pgm_function335.set_cpd((6, 4), (0.9857, 0.0143))
        pgm_function335.set_cpd((0, 5), (0.9363, 0.0637))
        pgm_function335.set_cpd((1, 5), (0.8403, 0.1597))
        pgm_function335.set_cpd((2, 5), (0.6534, 0.3466))
        pgm_function335.set_cpd((3, 5), (0.4689, 0.5311))
        pgm_function335.set_cpd((4, 5), (0.3174, 0.6826))
        pgm_function335.set_cpd((5, 5), (0.1948, 0.8052))
        pgm_function335.set_cpd((6, 5), (0.5681, 0.4319))
        pgm_factor336 = self.new_factor(R_ADM_MVA_RECRUIT, R_ADM_MULOSS, R_ADM_VOL_ACT)
        pgm_function336 = pgm_factor336.set_cpt()
        pgm_function336.set_cpd((0, 0), (0.9295, 0.0705, 0.0, 0.0))
        pgm_function336.set_cpd((1, 0), (0.4821, 0.5165, 0.0014, 0.0))
        pgm_function336.set_cpd((2, 0), (0.0661, 0.7993, 0.1346, 0.0))
        pgm_function336.set_cpd((3, 0), (0.00149985, 0.13658634, 0.86191381, 0.0))
        pgm_function336.set_cpd((4, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function336.set_cpd((5, 0), (0.2639736, 0.4343566, 0.3016698, 0.0))
        pgm_function336.set_cpd((0, 1), (0.1707, 0.7, 0.1293, 0.0))
        pgm_function336.set_cpd((1, 1), (0.0366, 0.5168, 0.4466, 0.0))
        pgm_function336.set_cpd((2, 1), (0.0043, 0.1788, 0.8169, 0.0))
        pgm_function336.set_cpd((3, 1), (0.00029997, 0.03479652, 0.96490351, 0.0))
        pgm_function336.set_cpd((4, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function336.set_cpd((5, 1), (0.1146, 0.3465, 0.5389, 0.0))
        pgm_function336.set_cpd((0, 2), (0.0038, 0.174, 0.8222, 0.0))
        pgm_function336.set_cpd((1, 2), (0.0005, 0.0594, 0.9401, 0.0))
        pgm_function336.set_cpd((2, 2), (0.0001, 0.0205, 0.9794, 0.0))
        pgm_function336.set_cpd((3, 2), (0.0, 0.0061, 0.9939, 0.0))
        pgm_function336.set_cpd((4, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function336.set_cpd((5, 2), (0.036, 0.2144, 0.7496, 0.0))
        pgm_function336.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function336.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function336.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function336.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function336.set_cpd((4, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function336.set_cpd((5, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor337 = self.new_factor(R_ADM_MVA_AMP, R_ADM_EFFMUS)
        pgm_function337 = pgm_factor337.set_cpt()
        pgm_function337.set_cpd((0,), (0.0, 0.04, 0.96))
        pgm_function337.set_cpd((1,), (0.01, 0.15, 0.84))
        pgm_function337.set_cpd((2,), (0.05, 0.9, 0.05))
        pgm_function337.set_cpd((3,), (0.5, 0.49, 0.01))
        pgm_function337.set_cpd((4,), (0.85, 0.15, 0.0))
        pgm_function337.set_cpd((5,), (0.96, 0.04, 0.0))
        pgm_function337.set_cpd((6,), (0.33, 0.34, 0.33))
        pgm_factor338 = self.new_factor(R_ADM_TA_CONCL, R_ADM_EFFMUS)
        pgm_function338 = pgm_factor338.set_cpt()
        pgm_function338.set_cpd((0,), (0.0, 0.0, 0.005, 0.045, 0.95))
        pgm_function338.set_cpd((1,), (0.0, 0.0, 0.05, 0.9, 0.05))
        pgm_function338.set_cpd((2,), (0.0, 0.03, 0.94, 0.03, 0.0))
        pgm_function338.set_cpd((3,), (0.195, 0.6, 0.2, 0.005, 0.0))
        pgm_function338.set_cpd((4,), (0.48, 0.5, 0.02, 0.0, 0.0))
        pgm_function338.set_cpd((5,), (0.8, 0.195, 0.005, 0.0, 0.0))
        pgm_function338.set_cpd((6,), (0.2, 0.2, 0.2, 0.2, 0.2))
        pgm_factor339 = self.new_factor(R_ADM_MUPAMP, R_ADM_EFFMUS)
        pgm_function339 = pgm_factor339.set_cpt()
        pgm_function339.set_cpd((0,), (0.782, 0.195, 0.003, 0.0, 0.0, 0.0, 0.02))
        pgm_function339.set_cpd((1,), (0.10431043, 0.77107711, 0.10431043, 0.00030003, 0.0, 0.0, 0.020002))
        pgm_function339.set_cpd((2,), (0.0, 0.0, 0.98, 0.0, 0.0, 0.0, 0.02))
        pgm_function339.set_cpd((3,), (0.0, 0.00029997, 0.10108989, 0.74712529, 0.13148685, 0.0, 0.019998))
        pgm_function339.set_cpd((4,), (0.0, 0.0, 0.0024, 0.1528, 0.7968, 0.028, 0.02))
        pgm_function339.set_cpd((5,), (0.0, 0.0, 0.0, 0.0028, 0.0968, 0.8804, 0.02))
        pgm_function339.set_cpd((6,), (0.1328, 0.1932, 0.2189, 0.1932, 0.1726, 0.0693, 0.02))
        pgm_factor340 = self.new_factor(R_ADM_QUAN_MUPAMP, R_ADM_MUPAMP)
        pgm_function340 = pgm_factor340.set_cpt()
        pgm_function340.set_cpd((0,), (
            0.00080024, 0.00370111, 0.01350405, 0.03811143, 0.08352506, 0.14254276, 0.18955687, 0.19635891, 0.1583475,
            0.09942983, 0.04861458, 0.01850555, 0.00550165, 0.00130039, 0.00020006, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function340.set_cpd((1,), (
            0.0, 0.00010002, 0.00080016, 0.00370074, 0.0135027, 0.03810762, 0.0835167, 0.14252851, 0.18953791,
            0.19633927,
            0.15833167, 0.09941988, 0.04860972, 0.0185037, 0.0055011, 0.00130026, 0.00020004, 0.0, 0.0, 0.0))
        pgm_function340.set_cpd((2,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.00050005, 0.00370037, 0.01870187, 0.06390639, 0.14751475, 0.23022302, 0.24312431,
            0.17371737, 0.0840084, 0.02750275, 0.00610061, 0.00090009, 0.00010001, 0.0, 0.0))
        pgm_function340.set_cpd((3,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.0008, 0.0037, 0.0135, 0.0381, 0.0835, 0.1426, 0.1896, 0.1963, 0.1583,
            0.0995,
            0.0487, 0.0185, 0.0055, 0.0013))
        pgm_function340.set_cpd((4,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.0008, 0.0038, 0.0136, 0.0383, 0.0841, 0.1435, 0.1909, 0.1977,
            0.1594, 0.1001, 0.049, 0.0187))
        pgm_function340.set_cpd((5,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.0006, 0.0024, 0.0082, 0.0232, 0.0542, 0.1041, 0.1645,
            0.2137, 0.2283, 0.2007))
        pgm_function340.set_cpd((6,), (
            0.0045, 0.0078, 0.0127, 0.0197, 0.0289, 0.0403, 0.0531, 0.0664, 0.0787, 0.0883, 0.0939, 0.0946, 0.0903,
            0.0817,
            0.07, 0.0569, 0.0438, 0.0319, 0.0221, 0.0144))
        pgm_factor341 = self.new_factor(R_ADM_QUAL_MUPAMP, R_ADM_MUPAMP)
        pgm_function341 = pgm_factor341.set_cpt()
        pgm_function341.set_cpd((0,), (0.4289, 0.5209, 0.0499, 0.0003, 0.0))
        pgm_function341.set_cpd((1,), (0.0647, 0.5494, 0.3679, 0.018, 0.0))
        pgm_function341.set_cpd((2,), (0.0, 0.04790479, 0.87538754, 0.07670767, 0.0))
        pgm_function341.set_cpd((3,), (0.0, 0.00869913, 0.28377162, 0.67793221, 0.02959704))
        pgm_function341.set_cpd((4,), (0.0, 0.0002, 0.0376, 0.6283, 0.3339))
        pgm_function341.set_cpd((5,), (0.0, 0.0, 0.001, 0.0788, 0.9202))
        pgm_function341.set_cpd((6,), (0.096, 0.1884, 0.283, 0.3014, 0.1312))
        pgm_factor342 = self.new_factor(R_ADM_MUPDUR, R_ADM_EFFMUS)
        pgm_function342 = pgm_factor342.set_cpt()
        pgm_function342.set_cpd((0,), (0.9388, 0.0412, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function342.set_cpd((1,), (0.0396, 0.9008, 0.0396, 0.0, 0.0, 0.0, 0.02))
        pgm_function342.set_cpd((2,), (0.0, 0.0, 0.98, 0.0, 0.0, 0.0, 0.02))
        pgm_function342.set_cpd((3,), (0.0, 0.0, 0.0396, 0.9008, 0.0396, 0.0, 0.02))
        pgm_function342.set_cpd((4,), (0.0, 0.0, 0.0, 0.0412, 0.938, 0.0008, 0.02))
        pgm_function342.set_cpd((5,), (0.0, 0.0, 0.0, 0.0039, 0.2546, 0.7215, 0.02))
        pgm_function342.set_cpd((6,), (0.09, 0.235, 0.3236, 0.235, 0.09, 0.0064, 0.02))
        pgm_factor343 = self.new_factor(R_ADM_QUAN_MUPDUR, R_ADM_MUPDUR)
        pgm_function343 = pgm_factor343.set_cpt()
        pgm_function343.set_cpd((0,), (
            0.09981996, 0.18333667, 0.24024805, 0.22454491, 0.14972995, 0.07121424, 0.02420484, 0.00580116, 0.0010002,
            0.00010002, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function343.set_cpd((1,), (
            0.01020102, 0.03690369, 0.09510951, 0.17471747, 0.22892289, 0.2140214, 0.14261426, 0.06780678, 0.0230023,
            0.00560056, 0.0010001, 0.00010001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function343.set_cpd((2,), (
            0.0, 0.0002, 0.0025, 0.0177, 0.0739, 0.1852, 0.2785, 0.2515, 0.1363, 0.0444, 0.0087, 0.001, 0.0001, 0.0,
            0.0,
            0.0, 0.0, 0.0, 0.0))
        pgm_function343.set_cpd((3,), (
            0.0, 0.0, 0.00029997, 0.0019998, 0.01019898, 0.03679632, 0.09489051, 0.17428257, 0.22837716, 0.21347865,
            0.14228577, 0.06769323, 0.0229977, 0.00559944, 0.0009999, 9.999e-05, 0.0, 0.0, 0.0))
        pgm_function343.set_cpd((4,), (
            0.0, 0.0, 0.0, 0.0, 0.00029997, 0.0019998, 0.01019898, 0.03679632, 0.09489051, 0.17428257, 0.22837716,
            0.21347865, 0.14228577, 0.06769323, 0.0229977, 0.00559944, 0.0009999, 9.999e-05, 0.0))
        pgm_function343.set_cpd((5,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 9.999e-05, 0.00039996, 0.00179982, 0.0069993, 0.02189781, 0.05409459, 0.10518948,
            0.16128387, 0.1949805, 0.1859814, 0.13988601, 0.08289171, 0.03879612, 0.00569943))
        pgm_function343.set_cpd((6,), (
            0.0201, 0.0341, 0.0529, 0.0748, 0.0966, 0.1138, 0.1224, 0.1202, 0.1078, 0.0882, 0.0658, 0.0449, 0.0279,
            0.0159,
            0.0082, 0.0039, 0.0017, 0.0007, 0.0001))
        pgm_factor344 = self.new_factor(R_ADM_QUAL_MUPDUR, R_ADM_MUPDUR)
        pgm_function344 = pgm_factor344.set_cpt()
        pgm_function344.set_cpd((0,), (0.8309, 0.1677, 0.0014))
        pgm_function344.set_cpd((1,), (0.49, 0.49, 0.02))
        pgm_function344.set_cpd((2,), (0.1065, 0.787, 0.1065))
        pgm_function344.set_cpd((3,), (0.02, 0.49, 0.49))
        pgm_function344.set_cpd((4,), (0.0014, 0.1677, 0.8309))
        pgm_function344.set_cpd((5,), (0.0001, 0.0392, 0.9607))
        pgm_function344.set_cpd((6,), (0.2597, 0.4806, 0.2597))
        pgm_factor345 = self.new_factor(R_ADM_QUAN_MUPPOLY, R_ADM_DE_REGEN, R_ADM_EFFMUS)
        pgm_function345 = pgm_factor345.set_cpt()
        pgm_function345.set_cpd((0, 0), (0.109, 0.548, 0.343))
        pgm_function345.set_cpd((1, 0), (0.004, 0.122, 0.874))
        pgm_function345.set_cpd((0, 1), (0.34, 0.564, 0.096))
        pgm_function345.set_cpd((1, 1), (0.015, 0.261, 0.724))
        pgm_function345.set_cpd((0, 2), (0.925, 0.075, 0.0))
        pgm_function345.set_cpd((1, 2), (0.091, 0.526, 0.383))
        pgm_function345.set_cpd((0, 3), (0.796, 0.201, 0.003))
        pgm_function345.set_cpd((1, 3), (0.061, 0.465, 0.474))
        pgm_function345.set_cpd((0, 4), (0.637, 0.348, 0.015))
        pgm_function345.set_cpd((1, 4), (0.039, 0.396, 0.565))
        pgm_function345.set_cpd((0, 5), (0.34, 0.564, 0.096))
        pgm_function345.set_cpd((1, 5), (0.015, 0.261, 0.724))
        pgm_function345.set_cpd((0, 6), (0.34, 0.564, 0.096))
        pgm_function345.set_cpd((1, 6), (0.015, 0.261, 0.724))
        pgm_factor346 = self.new_factor(R_ADM_QUAL_MUPPOLY, R_ADM_QUAN_MUPPOLY)
        pgm_function346 = pgm_factor346.set_cpt()
        pgm_function346.set_cpd((0,), (0.95, 0.05))
        pgm_function346.set_cpd((1,), (0.3, 0.7))
        pgm_function346.set_cpd((2,), (0.05, 0.95))
        pgm_factor347 = self.new_factor(R_ADM_MUPSATEL, R_ADM_DE_REGEN)
        pgm_function347 = pgm_factor347.set_cpt()
        pgm_function347.set_cpd((0,), (0.95, 0.05))
        pgm_function347.set_cpd((1,), (0.2, 0.8))
        pgm_factor348 = self.new_factor(R_ADM_MUPINSTAB, R_ADM_NMT)
        pgm_function348 = pgm_factor348.set_cpt()
        pgm_function348.set_cpd((0,), (0.95, 0.05))
        pgm_function348.set_cpd((1,), (0.1, 0.9))
        pgm_function348.set_cpd((2,), (0.03, 0.97))
        pgm_function348.set_cpd((3,), (0.2, 0.8))
        pgm_function348.set_cpd((4,), (0.1, 0.9))
        pgm_function348.set_cpd((5,), (0.03, 0.97))
        pgm_function348.set_cpd((6,), (0.1, 0.9))
        pgm_factor349 = self.new_factor(R_ADM_REPSTIM_CMAPAMP, R_ADM_ALLAMP_WA)
        pgm_function349 = pgm_factor349.set_cpt()
        pgm_function349.set_cpd((0,), (
            1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function349.set_cpd((1,), (
            0.00029988, 0.09616154, 0.11335466, 0.12485006, 0.12834866, 0.12315074, 0.1102559, 0.09226309, 0.07207117,
            0.05257897, 0.03578569, 0.02269092, 0.0134946, 0.007497, 0.00389844, 0.00189924, 0.00079968, 0.00039984,
            9.996e-05, 9.996e-05, 0.0))
        pgm_function349.set_cpd((2,), (
            0.0, 0.0, 9.998e-05, 0.00039992, 0.00169966, 0.0064987, 0.01959608, 0.04739052, 0.09228154, 0.14417117,
            0.18096381, 0.18246351, 0.14777045, 0.0959808, 0.05018996, 0.0209958, 0.00709858, 0.00189962, 0.00039992,
            9.998e-05, 0.0))
        pgm_function349.set_cpd((3,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00040004, 0.00330033, 0.01690169, 0.05950595, 0.14071407,
            0.22592259,
            0.24522452, 0.18011801, 0.08970897, 0.03010301, 0.00690069, 0.00110011, 0.00010001))
        pgm_function349.set_cpd((4,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0005, 0.0088, 0.0684, 0.236, 0.3599, 0.2433,
            0.0728, 0.0097, 0.0006))
        pgm_function349.set_cpd((5,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0042, 0.1369, 0.5589, 0.2821,
            0.0178, 0.0001))
        pgm_function349.set_cpd((6,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0002, 0.0028, 0.0211, 0.0937,
            0.2387,
            0.3496, 0.2939))
        pgm_function349.set_cpd((7,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00059994, 0.00749925,
            0.05829417, 0.259974, 0.67363264))
        pgm_function349.set_cpd((8,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00030003, 0.00810081,
            0.11031103, 0.88128813))
        pgm_factor350 = self.new_factor(R_ADM_REPSTIM_DECR, R_ADM_NMT)
        pgm_function350 = pgm_factor350.set_cpt()
        pgm_function350.set_cpd((0,), (0.949, 0.02, 0.01, 0.001, 0.02))
        pgm_function350.set_cpd((1,), (0.04, 0.2, 0.7, 0.04, 0.02))
        pgm_function350.set_cpd((2,), (0.001, 0.01, 0.04, 0.929, 0.02))
        pgm_function350.set_cpd((3,), (0.35, 0.57, 0.05, 0.01, 0.02))
        pgm_function350.set_cpd((4,), (0.02, 0.1, 0.8, 0.06, 0.02))
        pgm_function350.set_cpd((5,), (0.001, 0.01, 0.04, 0.929, 0.02))
        pgm_function350.set_cpd((6,), (0.245, 0.245, 0.245, 0.245, 0.02))
        pgm_factor351 = self.new_factor(R_ADM_REPSTIM_FACILI, R_ADM_NMT)
        pgm_function351 = pgm_factor351.set_cpt()
        pgm_function351.set_cpd((0,), (0.95, 0.02, 0.01, 0.02))
        pgm_function351.set_cpd((1,), (0.01, 0.889, 0.1, 0.001))
        pgm_function351.set_cpd((2,), (0.01, 0.08, 0.909, 0.001))
        pgm_function351.set_cpd((3,), (0.89, 0.08, 0.01, 0.02))
        pgm_function351.set_cpd((4,), (0.48, 0.5, 0.01, 0.01))
        pgm_function351.set_cpd((5,), (0.02, 0.949, 0.03, 0.001))
        pgm_function351.set_cpd((6,), (0.25, 0.25, 0.25, 0.25))
        pgm_factor352 = self.new_factor(R_ADM_REPSTIM_POST_DECR, R_ADM_NMT)
        pgm_function352 = pgm_factor352.set_cpt()
        pgm_function352.set_cpd((0,), (0.949, 0.02, 0.01, 0.001, 0.02))
        pgm_function352.set_cpd((1,), (0.02, 0.1, 0.8, 0.06, 0.02))
        pgm_function352.set_cpd((2,), (0.001, 0.01, 0.02, 0.949, 0.02))
        pgm_function352.set_cpd((3,), (0.25, 0.61, 0.1, 0.02, 0.02))
        pgm_function352.set_cpd((4,), (0.01, 0.1, 0.8, 0.07, 0.02))
        pgm_function352.set_cpd((5,), (0.001, 0.01, 0.02, 0.949, 0.02))
        pgm_function352.set_cpd((6,), (0.23, 0.23, 0.22, 0.22, 0.1))
        pgm_factor353 = self.new_factor(R_ADM_SF_JITTER, R_ADM_NMT)
        pgm_function353 = pgm_factor353.set_cpt()
        pgm_function353.set_cpd((0,), (0.95, 0.05, 0.0, 0.0))
        pgm_function353.set_cpd((1,), (0.02, 0.2, 0.7, 0.08))
        pgm_function353.set_cpd((2,), (0.0, 0.1, 0.4, 0.5))
        pgm_function353.set_cpd((3,), (0.05, 0.7, 0.2, 0.05))
        pgm_function353.set_cpd((4,), (0.01, 0.19, 0.7, 0.1))
        pgm_function353.set_cpd((5,), (0.0, 0.1, 0.4, 0.5))
        pgm_function353.set_cpd((6,), (0.1, 0.3, 0.3, 0.3))
        pgm_factor354 = self.new_factor(R_LNLC8_ADM_MUDENS)
        pgm_function354 = pgm_factor354.set_cpt()
        pgm_function354.set_cpd((), (1.0, 0.0, 0.0))
        pgm_factor355 = self.new_factor(R_LNLLP_ADM_MUDENS)
        pgm_function355 = pgm_factor355.set_cpt()
        pgm_function355.set_cpd((), (1.0, 0.0, 0.0))
        pgm_factor356 = self.new_factor(R_LNLC8_LP_ADM_MUDENS, R_LNLC8_ADM_MUDENS, R_LNLLP_ADM_MUDENS)
        pgm_function356 = pgm_factor356.set_cpt()
        pgm_function356.set_cpd((0, 0), (1.0, 0.0, 0.0))
        pgm_function356.set_cpd((1, 0), (0.0, 1.0, 0.0))
        pgm_function356.set_cpd((2, 0), (0.0, 0.0, 1.0))
        pgm_function356.set_cpd((0, 1), (0.0, 1.0, 0.0))
        pgm_function356.set_cpd((1, 1), (0.0, 0.0, 1.0))
        pgm_function356.set_cpd((2, 1), (0.0, 0.0, 1.0))
        pgm_function356.set_cpd((0, 2), (0.0, 0.0, 1.0))
        pgm_function356.set_cpd((1, 2), (0.0, 0.0, 1.0))
        pgm_function356.set_cpd((2, 2), (0.0, 0.0, 1.0))
        pgm_factor357 = self.new_factor(R_LNLE_ADM_MUDENS, R_LNLE_ULN_SEV, R_LNLE_ULN_TIME, R_LNLE_ULN_PATHO)
        pgm_function357 = pgm_factor357.set_cpt()
        pgm_function357.set_cpd((0, 0, 0), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((1, 0, 0), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((2, 0, 0), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((3, 0, 0), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((4, 0, 0), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((0, 1, 0), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((1, 1, 0), (0.9, 0.1, 0.0))
        pgm_function357.set_cpd((2, 1, 0), (0.8, 0.2, 0.0))
        pgm_function357.set_cpd((3, 1, 0), (0.6, 0.4, 0.0))
        pgm_function357.set_cpd((4, 1, 0), (0.6, 0.4, 0.0))
        pgm_function357.set_cpd((0, 2, 0), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((1, 2, 0), (0.8, 0.2, 0.0))
        pgm_function357.set_cpd((2, 2, 0), (0.7, 0.3, 0.0))
        pgm_function357.set_cpd((3, 2, 0), (0.6, 0.4, 0.0))
        pgm_function357.set_cpd((4, 2, 0), (0.6, 0.4, 0.0))
        pgm_function357.set_cpd((0, 3, 0), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((1, 3, 0), (0.8, 0.2, 0.0))
        pgm_function357.set_cpd((2, 3, 0), (0.7, 0.3, 0.0))
        pgm_function357.set_cpd((3, 3, 0), (0.6, 0.4, 0.0))
        pgm_function357.set_cpd((4, 3, 0), (0.6, 0.4, 0.0))
        pgm_function357.set_cpd((0, 0, 1), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((1, 0, 1), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((2, 0, 1), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((3, 0, 1), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((4, 0, 1), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((0, 1, 1), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((1, 1, 1), (0.9, 0.1, 0.0))
        pgm_function357.set_cpd((2, 1, 1), (0.8, 0.2, 0.0))
        pgm_function357.set_cpd((3, 1, 1), (0.6, 0.4, 0.0))
        pgm_function357.set_cpd((4, 1, 1), (0.6, 0.4, 0.0))
        pgm_function357.set_cpd((0, 2, 1), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((1, 2, 1), (0.8, 0.2, 0.0))
        pgm_function357.set_cpd((2, 2, 1), (0.7, 0.3, 0.0))
        pgm_function357.set_cpd((3, 2, 1), (0.6, 0.4, 0.0))
        pgm_function357.set_cpd((4, 2, 1), (0.6, 0.4, 0.0))
        pgm_function357.set_cpd((0, 3, 1), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((1, 3, 1), (0.8, 0.2, 0.0))
        pgm_function357.set_cpd((2, 3, 1), (0.7, 0.3, 0.0))
        pgm_function357.set_cpd((3, 3, 1), (0.6, 0.4, 0.0))
        pgm_function357.set_cpd((4, 3, 1), (0.6, 0.4, 0.0))
        pgm_function357.set_cpd((0, 0, 2), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((1, 0, 2), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((2, 0, 2), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((3, 0, 2), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((4, 0, 2), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((0, 1, 2), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((1, 1, 2), (0.6, 0.4, 0.0))
        pgm_function357.set_cpd((2, 1, 2), (0.5, 0.5, 0.0))
        pgm_function357.set_cpd((3, 1, 2), (0.5, 0.4, 0.1))
        pgm_function357.set_cpd((4, 1, 2), (0.3, 0.6, 0.1))
        pgm_function357.set_cpd((0, 2, 2), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((1, 2, 2), (0.7, 0.3, 0.0))
        pgm_function357.set_cpd((2, 2, 2), (0.1, 0.6, 0.3))
        pgm_function357.set_cpd((3, 2, 2), (0.0, 0.5, 0.5))
        pgm_function357.set_cpd((4, 2, 2), (0.0, 0.5, 0.5))
        pgm_function357.set_cpd((0, 3, 2), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((1, 3, 2), (0.5, 0.5, 0.0))
        pgm_function357.set_cpd((2, 3, 2), (0.15, 0.7, 0.15))
        pgm_function357.set_cpd((3, 3, 2), (0.0, 0.5, 0.5))
        pgm_function357.set_cpd((4, 3, 2), (0.0, 0.5, 0.5))
        pgm_function357.set_cpd((0, 0, 3), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((1, 0, 3), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((2, 0, 3), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((3, 0, 3), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((4, 0, 3), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((0, 1, 3), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((1, 1, 3), (0.05, 0.5, 0.45))
        pgm_function357.set_cpd((2, 1, 3), (0.05, 0.5, 0.45))
        pgm_function357.set_cpd((3, 1, 3), (0.05, 0.5, 0.45))
        pgm_function357.set_cpd((4, 1, 3), (0.05, 0.5, 0.45))
        pgm_function357.set_cpd((0, 2, 3), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((1, 2, 3), (0.05, 0.5, 0.45))
        pgm_function357.set_cpd((2, 2, 3), (0.05, 0.5, 0.45))
        pgm_function357.set_cpd((3, 2, 3), (0.05, 0.5, 0.45))
        pgm_function357.set_cpd((4, 2, 3), (0.05, 0.5, 0.45))
        pgm_function357.set_cpd((0, 3, 3), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((1, 3, 3), (0.05, 0.5, 0.45))
        pgm_function357.set_cpd((2, 3, 3), (0.05, 0.5, 0.45))
        pgm_function357.set_cpd((3, 3, 3), (0.05, 0.5, 0.45))
        pgm_function357.set_cpd((4, 3, 3), (0.05, 0.5, 0.45))
        pgm_function357.set_cpd((0, 0, 4), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((1, 0, 4), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((2, 0, 4), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((3, 0, 4), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((4, 0, 4), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((0, 1, 4), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((1, 1, 4), (0.2, 0.5, 0.3))
        pgm_function357.set_cpd((2, 1, 4), (0.2, 0.5, 0.3))
        pgm_function357.set_cpd((3, 1, 4), (0.2, 0.5, 0.3))
        pgm_function357.set_cpd((4, 1, 4), (0.2, 0.5, 0.3))
        pgm_function357.set_cpd((0, 2, 4), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((1, 2, 4), (0.2, 0.5, 0.3))
        pgm_function357.set_cpd((2, 2, 4), (0.2, 0.5, 0.3))
        pgm_function357.set_cpd((3, 2, 4), (0.2, 0.5, 0.3))
        pgm_function357.set_cpd((4, 2, 4), (0.2, 0.5, 0.3))
        pgm_function357.set_cpd((0, 3, 4), (1.0, 0.0, 0.0))
        pgm_function357.set_cpd((1, 3, 4), (0.2, 0.5, 0.3))
        pgm_function357.set_cpd((2, 3, 4), (0.2, 0.5, 0.3))
        pgm_function357.set_cpd((3, 3, 4), (0.2, 0.5, 0.3))
        pgm_function357.set_cpd((4, 3, 4), (0.2, 0.5, 0.3))
        pgm_factor358 = self.new_factor(R_LNLC8_LP_E_ADM_MUDENS, R_LNLC8_LP_ADM_MUDENS, R_LNLE_ADM_MUDENS)
        pgm_function358 = pgm_factor358.set_cpt()
        pgm_function358.set_cpd((0, 0), (1.0, 0.0, 0.0))
        pgm_function358.set_cpd((1, 0), (0.0, 1.0, 0.0))
        pgm_function358.set_cpd((2, 0), (0.0, 0.0, 1.0))
        pgm_function358.set_cpd((0, 1), (0.0, 1.0, 0.0))
        pgm_function358.set_cpd((1, 1), (0.0, 0.0, 1.0))
        pgm_function358.set_cpd((2, 1), (0.0, 0.0, 1.0))
        pgm_function358.set_cpd((0, 2), (0.0, 0.0, 1.0))
        pgm_function358.set_cpd((1, 2), (0.0, 0.0, 1.0))
        pgm_function358.set_cpd((2, 2), (0.0, 0.0, 1.0))
        pgm_factor359 = self.new_factor(R_DIFFN_ADM_MUDENS, DIFFN_M_SEV_DIST, DIFFN_TIME, DIFFN_PATHO)
        pgm_function359 = pgm_factor359.set_cpt()
        pgm_function359.set_cpd((0, 0, 0), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((1, 0, 0), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((2, 0, 0), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((3, 0, 0), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((0, 1, 0), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((1, 1, 0), (0.9, 0.1, 0.0))
        pgm_function359.set_cpd((2, 1, 0), (0.8, 0.2, 0.0))
        pgm_function359.set_cpd((3, 1, 0), (0.6, 0.4, 0.0))
        pgm_function359.set_cpd((0, 2, 0), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((1, 2, 0), (0.8, 0.2, 0.0))
        pgm_function359.set_cpd((2, 2, 0), (0.7, 0.3, 0.0))
        pgm_function359.set_cpd((3, 2, 0), (0.6, 0.4, 0.0))
        pgm_function359.set_cpd((0, 3, 0), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((1, 3, 0), (0.8, 0.2, 0.0))
        pgm_function359.set_cpd((2, 3, 0), (0.7, 0.3, 0.0))
        pgm_function359.set_cpd((3, 3, 0), (0.6, 0.4, 0.0))
        pgm_function359.set_cpd((0, 0, 1), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((1, 0, 1), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((2, 0, 1), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((3, 0, 1), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((0, 1, 1), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((1, 1, 1), (0.9, 0.1, 0.0))
        pgm_function359.set_cpd((2, 1, 1), (0.8, 0.2, 0.0))
        pgm_function359.set_cpd((3, 1, 1), (0.6, 0.4, 0.0))
        pgm_function359.set_cpd((0, 2, 1), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((1, 2, 1), (0.8, 0.2, 0.0))
        pgm_function359.set_cpd((2, 2, 1), (0.7, 0.3, 0.0))
        pgm_function359.set_cpd((3, 2, 1), (0.6, 0.4, 0.0))
        pgm_function359.set_cpd((0, 3, 1), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((1, 3, 1), (0.8, 0.2, 0.0))
        pgm_function359.set_cpd((2, 3, 1), (0.7, 0.3, 0.0))
        pgm_function359.set_cpd((3, 3, 1), (0.6, 0.4, 0.0))
        pgm_function359.set_cpd((0, 0, 2), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((1, 0, 2), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((2, 0, 2), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((3, 0, 2), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((0, 1, 2), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((1, 1, 2), (0.6, 0.4, 0.0))
        pgm_function359.set_cpd((2, 1, 2), (0.5, 0.5, 0.0))
        pgm_function359.set_cpd((3, 1, 2), (0.5, 0.4, 0.1))
        pgm_function359.set_cpd((0, 2, 2), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((1, 2, 2), (0.7, 0.3, 0.0))
        pgm_function359.set_cpd((2, 2, 2), (0.1, 0.6, 0.3))
        pgm_function359.set_cpd((3, 2, 2), (0.0, 0.5, 0.5))
        pgm_function359.set_cpd((0, 3, 2), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((1, 3, 2), (0.5, 0.5, 0.0))
        pgm_function359.set_cpd((2, 3, 2), (0.15, 0.7, 0.15))
        pgm_function359.set_cpd((3, 3, 2), (0.0, 0.5, 0.5))
        pgm_function359.set_cpd((0, 0, 3), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((1, 0, 3), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((2, 0, 3), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((3, 0, 3), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((0, 1, 3), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((1, 1, 3), (0.05, 0.5, 0.45))
        pgm_function359.set_cpd((2, 1, 3), (0.05, 0.5, 0.45))
        pgm_function359.set_cpd((3, 1, 3), (0.05, 0.5, 0.45))
        pgm_function359.set_cpd((0, 2, 3), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((1, 2, 3), (0.05, 0.5, 0.45))
        pgm_function359.set_cpd((2, 2, 3), (0.05, 0.5, 0.45))
        pgm_function359.set_cpd((3, 2, 3), (0.05, 0.5, 0.45))
        pgm_function359.set_cpd((0, 3, 3), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((1, 3, 3), (0.05, 0.5, 0.45))
        pgm_function359.set_cpd((2, 3, 3), (0.05, 0.5, 0.45))
        pgm_function359.set_cpd((3, 3, 3), (0.05, 0.5, 0.45))
        pgm_function359.set_cpd((0, 0, 4), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((1, 0, 4), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((2, 0, 4), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((3, 0, 4), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((0, 1, 4), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((1, 1, 4), (0.2, 0.5, 0.3))
        pgm_function359.set_cpd((2, 1, 4), (0.2, 0.5, 0.3))
        pgm_function359.set_cpd((3, 1, 4), (0.2, 0.5, 0.3))
        pgm_function359.set_cpd((0, 2, 4), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((1, 2, 4), (0.2, 0.5, 0.3))
        pgm_function359.set_cpd((2, 2, 4), (0.2, 0.5, 0.3))
        pgm_function359.set_cpd((3, 2, 4), (0.2, 0.5, 0.3))
        pgm_function359.set_cpd((0, 3, 4), (1.0, 0.0, 0.0))
        pgm_function359.set_cpd((1, 3, 4), (0.2, 0.5, 0.3))
        pgm_function359.set_cpd((2, 3, 4), (0.2, 0.5, 0.3))
        pgm_function359.set_cpd((3, 3, 4), (0.2, 0.5, 0.3))
        pgm_factor360 = self.new_factor(R_LNLW_ADM_MUDENS)
        pgm_function360 = pgm_factor360.set_cpt()
        pgm_function360.set_cpd((), (1.0, 0.0, 0.0))
        pgm_factor361 = self.new_factor(R_DIFFN_LNLW_ADM_MUDENS, R_DIFFN_ADM_MUDENS, R_LNLW_ADM_MUDENS)
        pgm_function361 = pgm_factor361.set_cpt()
        pgm_function361.set_cpd((0, 0), (1.0, 0.0, 0.0))
        pgm_function361.set_cpd((1, 0), (0.0, 1.0, 0.0))
        pgm_function361.set_cpd((2, 0), (0.0, 0.0, 1.0))
        pgm_function361.set_cpd((0, 1), (0.0, 1.0, 0.0))
        pgm_function361.set_cpd((1, 1), (0.0, 0.0, 1.0))
        pgm_function361.set_cpd((2, 1), (0.0, 0.0, 1.0))
        pgm_function361.set_cpd((0, 2), (0.0, 0.0, 1.0))
        pgm_function361.set_cpd((1, 2), (0.0, 0.0, 1.0))
        pgm_function361.set_cpd((2, 2), (0.0, 0.0, 1.0))
        pgm_factor362 = self.new_factor(R_LNL_DIFFN_ADM_MUDENS, R_LNLC8_LP_E_ADM_MUDENS, R_DIFFN_LNLW_ADM_MUDENS)
        pgm_function362 = pgm_factor362.set_cpt()
        pgm_function362.set_cpd((0, 0), (1.0, 0.0, 0.0))
        pgm_function362.set_cpd((1, 0), (0.0, 1.0, 0.0))
        pgm_function362.set_cpd((2, 0), (0.0, 0.0, 1.0))
        pgm_function362.set_cpd((0, 1), (0.0, 1.0, 0.0))
        pgm_function362.set_cpd((1, 1), (0.0, 0.0, 1.0))
        pgm_function362.set_cpd((2, 1), (0.0, 0.0, 1.0))
        pgm_function362.set_cpd((0, 2), (0.0, 0.0, 1.0))
        pgm_function362.set_cpd((1, 2), (0.0, 0.0, 1.0))
        pgm_function362.set_cpd((2, 2), (0.0, 0.0, 1.0))
        pgm_factor363 = self.new_factor(R_MYOP_ADM_MUDENS)
        pgm_function363 = pgm_factor363.set_cpt()
        pgm_function363.set_cpd((), (1.0, 0.0, 0.0))
        pgm_factor364 = self.new_factor(R_MYDY_ADM_MUDENS)
        pgm_function364 = pgm_factor364.set_cpt()
        pgm_function364.set_cpd((), (1.0, 0.0, 0.0))
        pgm_factor365 = self.new_factor(R_MYOP_MYDY_ADM_MUDENS, R_MYOP_ADM_MUDENS, R_MYDY_ADM_MUDENS)
        pgm_function365 = pgm_factor365.set_cpt()
        pgm_function365.set_cpd((0, 0), (1.0, 0.0, 0.0))
        pgm_function365.set_cpd((1, 0), (0.0, 1.0, 0.0))
        pgm_function365.set_cpd((2, 0), (0.0, 0.0, 1.0))
        pgm_function365.set_cpd((0, 1), (0.0, 1.0, 0.0))
        pgm_function365.set_cpd((1, 1), (0.0, 0.0, 1.0))
        pgm_function365.set_cpd((2, 1), (0.0, 0.0, 1.0))
        pgm_function365.set_cpd((0, 2), (0.0, 0.0, 1.0))
        pgm_function365.set_cpd((1, 2), (0.0, 0.0, 1.0))
        pgm_function365.set_cpd((2, 2), (0.0, 0.0, 1.0))
        pgm_factor366 = self.new_factor(R_MYAS_ADM_MUDENS)
        pgm_function366 = pgm_factor366.set_cpt()
        pgm_function366.set_cpd((), (1.0, 0.0, 0.0))
        pgm_factor367 = self.new_factor(R_OTHER_ADM_MUDENS)
        pgm_function367 = pgm_factor367.set_cpt()
        pgm_function367.set_cpd((), (1.0, 0.0, 0.0))
        pgm_factor368 = self.new_factor(R_MYAS_OTHER_ADM_MUDENS, R_MYAS_ADM_MUDENS, R_OTHER_ADM_MUDENS)
        pgm_function368 = pgm_factor368.set_cpt()
        pgm_function368.set_cpd((0, 0), (1.0, 0.0, 0.0))
        pgm_function368.set_cpd((1, 0), (0.0, 1.0, 0.0))
        pgm_function368.set_cpd((2, 0), (0.0, 0.0, 1.0))
        pgm_function368.set_cpd((0, 1), (0.0, 1.0, 0.0))
        pgm_function368.set_cpd((1, 1), (0.0, 0.0, 1.0))
        pgm_function368.set_cpd((2, 1), (0.0, 0.0, 1.0))
        pgm_function368.set_cpd((0, 2), (0.0, 0.0, 1.0))
        pgm_function368.set_cpd((1, 2), (0.0, 0.0, 1.0))
        pgm_function368.set_cpd((2, 2), (0.0, 0.0, 1.0))
        pgm_factor369 = self.new_factor(R_MUSCLE_ADM_MUDENS, R_MYOP_MYDY_ADM_MUDENS, R_MYAS_OTHER_ADM_MUDENS)
        pgm_function369 = pgm_factor369.set_cpt()
        pgm_function369.set_cpd((0, 0), (1.0, 0.0, 0.0))
        pgm_function369.set_cpd((1, 0), (0.0, 1.0, 0.0))
        pgm_function369.set_cpd((2, 0), (0.0, 0.0, 1.0))
        pgm_function369.set_cpd((0, 1), (0.0, 1.0, 0.0))
        pgm_function369.set_cpd((1, 1), (0.0, 0.0, 1.0))
        pgm_function369.set_cpd((2, 1), (0.0, 0.0, 1.0))
        pgm_function369.set_cpd((0, 2), (0.0, 0.0, 1.0))
        pgm_function369.set_cpd((1, 2), (0.0, 0.0, 1.0))
        pgm_function369.set_cpd((2, 2), (0.0, 0.0, 1.0))
        pgm_factor370 = self.new_factor(R_ADM_MUDENS, R_LNL_DIFFN_ADM_MUDENS, R_MUSCLE_ADM_MUDENS)
        pgm_function370 = pgm_factor370.set_cpt()
        pgm_function370.set_cpd((0, 0), (1.0, 0.0, 0.0))
        pgm_function370.set_cpd((1, 0), (0.0, 1.0, 0.0))
        pgm_function370.set_cpd((2, 0), (0.0, 0.0, 1.0))
        pgm_function370.set_cpd((0, 1), (0.0, 1.0, 0.0))
        pgm_function370.set_cpd((1, 1), (0.0, 0.0, 1.0))
        pgm_function370.set_cpd((2, 1), (0.0, 0.0, 1.0))
        pgm_function370.set_cpd((0, 2), (0.0, 0.0, 1.0))
        pgm_function370.set_cpd((1, 2), (0.0, 0.0, 1.0))
        pgm_function370.set_cpd((2, 2), (0.0, 0.0, 1.0))
        pgm_factor371 = self.new_factor(R_ADM_SF_DENSITY, R_ADM_MUDENS)
        pgm_function371 = pgm_factor371.set_cpt()
        pgm_function371.set_cpd((0,), (0.97, 0.03, 0.0))
        pgm_function371.set_cpd((1,), (0.05, 0.9, 0.05))
        pgm_function371.set_cpd((2,), (0.01, 0.04, 0.95))
        pgm_factor372 = self.new_factor(R_LNLC8_ADM_NEUR_ACT)
        pgm_function372 = pgm_factor372.set_cpt()
        pgm_function372.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor373 = self.new_factor(R_LNLLP_ADM_NEUR_ACT)
        pgm_function373 = pgm_factor373.set_cpt()
        pgm_function373.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor374 = self.new_factor(R_LNLC8_LP_ADM_NEUR_ACT, R_LNLC8_ADM_NEUR_ACT, R_LNLLP_ADM_NEUR_ACT)
        pgm_function374 = pgm_factor374.set_cpt()
        pgm_function374.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function374.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function374.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function374.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function374.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function374.set_cpd((5, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function374.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function374.set_cpd((1, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function374.set_cpd((2, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function374.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function374.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function374.set_cpd((5, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function374.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function374.set_cpd((1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function374.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function374.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function374.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function374.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function374.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function374.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function374.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function374.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function374.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function374.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function374.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function374.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function374.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function374.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function374.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function374.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function374.set_cpd((0, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function374.set_cpd((1, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function374.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function374.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function374.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function374.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor375 = self.new_factor(R_LNLE_ADM_NEUR_ACT, R_LNLE_ULN_SEV, R_LNLE_ULN_TIME)
        pgm_function375 = pgm_factor375.set_cpt()
        pgm_function375.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function375.set_cpd((1, 0), (0.9, 0.1, 0.0, 0.0, 0.0, 0.0))
        pgm_function375.set_cpd((2, 0), (0.9, 0.1, 0.0, 0.0, 0.0, 0.0))
        pgm_function375.set_cpd((3, 0), (0.9, 0.1, 0.0, 0.0, 0.0, 0.0))
        pgm_function375.set_cpd((4, 0), (0.9, 0.1, 0.0, 0.0, 0.0, 0.0))
        pgm_function375.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function375.set_cpd((1, 1), (0.7, 0.3, 0.0, 0.0, 0.0, 0.0))
        pgm_function375.set_cpd((2, 1), (0.7, 0.3, 0.0, 0.0, 0.0, 0.0))
        pgm_function375.set_cpd((3, 1), (0.7, 0.3, 0.0, 0.0, 0.0, 0.0))
        pgm_function375.set_cpd((4, 1), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function375.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function375.set_cpd((1, 2), (0.5, 0.5, 0.0, 0.0, 0.0, 0.0))
        pgm_function375.set_cpd((2, 2), (0.5, 0.5, 0.0, 0.0, 0.0, 0.0))
        pgm_function375.set_cpd((3, 2), (0.3, 0.7, 0.0, 0.0, 0.0, 0.0))
        pgm_function375.set_cpd((4, 2), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function375.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function375.set_cpd((1, 3), (0.1, 0.9, 0.0, 0.0, 0.0, 0.0))
        pgm_function375.set_cpd((2, 3), (0.7, 0.3, 0.0, 0.0, 0.0, 0.0))
        pgm_function375.set_cpd((3, 3), (0.3, 0.7, 0.0, 0.0, 0.0, 0.0))
        pgm_function375.set_cpd((4, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor376 = self.new_factor(R_LNLC8_LP_E_ADM_NEUR_ACT, R_LNLC8_LP_ADM_NEUR_ACT, R_LNLE_ADM_NEUR_ACT)
        pgm_function376 = pgm_factor376.set_cpt()
        pgm_function376.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function376.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function376.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function376.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function376.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function376.set_cpd((5, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function376.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function376.set_cpd((1, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function376.set_cpd((2, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function376.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function376.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function376.set_cpd((5, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function376.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function376.set_cpd((1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function376.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function376.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function376.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function376.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function376.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function376.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function376.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function376.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function376.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function376.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function376.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function376.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function376.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function376.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function376.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function376.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function376.set_cpd((0, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function376.set_cpd((1, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function376.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function376.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function376.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function376.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor377 = self.new_factor(R_DIFFN_ADM_NEUR_ACT, DIFFN_M_SEV_DIST, DIFFN_TIME)
        pgm_function377 = pgm_factor377.set_cpt()
        pgm_function377.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function377.set_cpd((1, 0), (0.9, 0.1, 0.0, 0.0, 0.0, 0.0))
        pgm_function377.set_cpd((2, 0), (0.9, 0.1, 0.0, 0.0, 0.0, 0.0))
        pgm_function377.set_cpd((3, 0), (0.9, 0.1, 0.0, 0.0, 0.0, 0.0))
        pgm_function377.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function377.set_cpd((1, 1), (0.7, 0.3, 0.0, 0.0, 0.0, 0.0))
        pgm_function377.set_cpd((2, 1), (0.7, 0.3, 0.0, 0.0, 0.0, 0.0))
        pgm_function377.set_cpd((3, 1), (0.7, 0.3, 0.0, 0.0, 0.0, 0.0))
        pgm_function377.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function377.set_cpd((1, 2), (0.5, 0.5, 0.0, 0.0, 0.0, 0.0))
        pgm_function377.set_cpd((2, 2), (0.5, 0.5, 0.0, 0.0, 0.0, 0.0))
        pgm_function377.set_cpd((3, 2), (0.3, 0.7, 0.0, 0.0, 0.0, 0.0))
        pgm_function377.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function377.set_cpd((1, 3), (0.1, 0.9, 0.0, 0.0, 0.0, 0.0))
        pgm_function377.set_cpd((2, 3), (0.7, 0.3, 0.0, 0.0, 0.0, 0.0))
        pgm_function377.set_cpd((3, 3), (0.3, 0.7, 0.0, 0.0, 0.0, 0.0))
        pgm_factor378 = self.new_factor(R_LNLW_ADM_NEUR_ACT)
        pgm_function378 = pgm_factor378.set_cpt()
        pgm_function378.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor379 = self.new_factor(R_DIFFN_LNLW_ADM_NEUR_ACT, R_DIFFN_ADM_NEUR_ACT, R_LNLW_ADM_NEUR_ACT)
        pgm_function379 = pgm_factor379.set_cpt()
        pgm_function379.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function379.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function379.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function379.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function379.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function379.set_cpd((5, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function379.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function379.set_cpd((1, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function379.set_cpd((2, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function379.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function379.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function379.set_cpd((5, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function379.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function379.set_cpd((1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function379.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function379.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function379.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function379.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function379.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function379.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function379.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function379.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function379.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function379.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function379.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function379.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function379.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function379.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function379.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function379.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function379.set_cpd((0, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function379.set_cpd((1, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function379.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function379.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function379.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function379.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor380 = self.new_factor(R_LNL_DIFFN_ADM_NEUR_ACT, R_LNLC8_LP_E_ADM_NEUR_ACT, R_DIFFN_LNLW_ADM_NEUR_ACT)
        pgm_function380 = pgm_factor380.set_cpt()
        pgm_function380.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function380.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function380.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function380.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function380.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function380.set_cpd((5, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function380.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function380.set_cpd((1, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function380.set_cpd((2, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function380.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function380.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function380.set_cpd((5, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function380.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function380.set_cpd((1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function380.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function380.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function380.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function380.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function380.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function380.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function380.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function380.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function380.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function380.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function380.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function380.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function380.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function380.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function380.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function380.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function380.set_cpd((0, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function380.set_cpd((1, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function380.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function380.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function380.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function380.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor381 = self.new_factor(R_OTHER_ADM_NEUR_ACT)
        pgm_function381 = pgm_factor381.set_cpt()
        pgm_function381.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor382 = self.new_factor(R_ADM_NEUR_ACT, R_LNL_DIFFN_ADM_NEUR_ACT, R_OTHER_ADM_NEUR_ACT)
        pgm_function382 = pgm_factor382.set_cpt()
        pgm_function382.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function382.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function382.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function382.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function382.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function382.set_cpd((5, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function382.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function382.set_cpd((1, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function382.set_cpd((2, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function382.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function382.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function382.set_cpd((5, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function382.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function382.set_cpd((1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function382.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function382.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function382.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function382.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function382.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function382.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function382.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function382.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function382.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function382.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function382.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function382.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function382.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function382.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function382.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function382.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function382.set_cpd((0, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function382.set_cpd((1, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function382.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function382.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function382.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function382.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor383 = self.new_factor(R_ADM_SPONT_NEUR_DISCH, R_ADM_NEUR_ACT)
        pgm_function383 = pgm_factor383.set_cpt()
        pgm_function383.set_cpd((0,), (0.98, 0.02, 0.0, 0.0, 0.0, 0.0))
        pgm_function383.set_cpd((1,), (0.1, 0.9, 0.0, 0.0, 0.0, 0.0))
        pgm_function383.set_cpd((2,), (0.01, 0.04, 0.75, 0.05, 0.05, 0.1))
        pgm_function383.set_cpd((3,), (0.01, 0.04, 0.05, 0.75, 0.05, 0.1))
        pgm_function383.set_cpd((4,), (0.01, 0.04, 0.05, 0.05, 0.75, 0.1))
        pgm_function383.set_cpd((5,), (0.01, 0.05, 0.05, 0.05, 0.05, 0.79))
        pgm_factor384 = self.new_factor(R_MYOP_ADM_DENERV)
        pgm_function384 = pgm_factor384.set_cpt()
        pgm_function384.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor385 = self.new_factor(R_MYDY_ADM_DENERV)
        pgm_function385 = pgm_factor385.set_cpt()
        pgm_function385.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor386 = self.new_factor(R_MYOP_MYDY_ADM_DENERV, R_MYOP_ADM_DENERV, R_MYDY_ADM_DENERV)
        pgm_function386 = pgm_factor386.set_cpt()
        pgm_function386.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function386.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function386.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function386.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function386.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0))
        pgm_function386.set_cpd((1, 1), (0.0, 0.0, 1.0, 0.0))
        pgm_function386.set_cpd((2, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function386.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function386.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function386.set_cpd((1, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function386.set_cpd((2, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function386.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function386.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function386.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function386.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function386.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor387 = self.new_factor(R_OTHER_ADM_DENERV)
        pgm_function387 = pgm_factor387.set_cpt()
        pgm_function387.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor388 = self.new_factor(R_NMT_ADM_DENERV, R_ADM_NMT)
        pgm_function388 = pgm_factor388.set_cpt()
        pgm_function388.set_cpd((0,), (1.0, 0.0, 0.0, 0.0))
        pgm_function388.set_cpd((1,), (0.4, 0.45, 0.15, 0.0))
        pgm_function388.set_cpd((2,), (0.15, 0.35, 0.35, 0.15))
        pgm_function388.set_cpd((3,), (0.85, 0.15, 0.0, 0.0))
        pgm_function388.set_cpd((4,), (0.3, 0.45, 0.2, 0.05))
        pgm_function388.set_cpd((5,), (0.15, 0.35, 0.35, 0.15))
        pgm_function388.set_cpd((6,), (0.25, 0.25, 0.25, 0.25))
        pgm_factor389 = self.new_factor(R_OTHER_NMT_ADM_DENERV, R_OTHER_ADM_DENERV, R_NMT_ADM_DENERV)
        pgm_function389 = pgm_factor389.set_cpt()
        pgm_function389.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function389.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function389.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function389.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function389.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0))
        pgm_function389.set_cpd((1, 1), (0.0, 0.0, 1.0, 0.0))
        pgm_function389.set_cpd((2, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function389.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function389.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function389.set_cpd((1, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function389.set_cpd((2, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function389.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function389.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function389.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function389.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function389.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor390 = self.new_factor(R_MUSCLE_ADM_DENERV, R_MYOP_MYDY_ADM_DENERV, R_OTHER_NMT_ADM_DENERV)
        pgm_function390 = pgm_factor390.set_cpt()
        pgm_function390.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function390.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function390.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function390.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function390.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0))
        pgm_function390.set_cpd((1, 1), (0.0, 0.0, 1.0, 0.0))
        pgm_function390.set_cpd((2, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function390.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function390.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function390.set_cpd((1, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function390.set_cpd((2, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function390.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function390.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function390.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function390.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function390.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor391 = self.new_factor(R_LNLC8_ADM_DENERV)
        pgm_function391 = pgm_factor391.set_cpt()
        pgm_function391.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor392 = self.new_factor(R_LNLLP_ADM_DENERV)
        pgm_function392 = pgm_factor392.set_cpt()
        pgm_function392.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor393 = self.new_factor(R_LNLC8_LP_ADM_DENERV, R_LNLC8_ADM_DENERV, R_LNLLP_ADM_DENERV)
        pgm_function393 = pgm_factor393.set_cpt()
        pgm_function393.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function393.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function393.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function393.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function393.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0))
        pgm_function393.set_cpd((1, 1), (0.0, 0.0, 1.0, 0.0))
        pgm_function393.set_cpd((2, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function393.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function393.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function393.set_cpd((1, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function393.set_cpd((2, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function393.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function393.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function393.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function393.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function393.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor394 = self.new_factor(R_LNLE_ADM_DENERV, R_LNLE_ULN_SEV, R_LNLE_ULN_TIME, R_LNLE_ULN_PATHO)
        pgm_function394 = pgm_factor394.set_cpt()
        pgm_function394.set_cpd((0, 0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function394.set_cpd((1, 0, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function394.set_cpd((2, 0, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function394.set_cpd((3, 0, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function394.set_cpd((4, 0, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function394.set_cpd((0, 1, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function394.set_cpd((1, 1, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function394.set_cpd((2, 1, 0), (0.3, 0.5, 0.2, 0.0))
        pgm_function394.set_cpd((3, 1, 0), (0.1, 0.5, 0.4, 0.0))
        pgm_function394.set_cpd((4, 1, 0), (0.0, 0.4, 0.4, 0.2))
        pgm_function394.set_cpd((0, 2, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function394.set_cpd((1, 2, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function394.set_cpd((2, 2, 0), (0.3, 0.5, 0.2, 0.0))
        pgm_function394.set_cpd((3, 2, 0), (0.1, 0.5, 0.4, 0.0))
        pgm_function394.set_cpd((4, 2, 0), (0.0, 0.4, 0.4, 0.2))
        pgm_function394.set_cpd((0, 3, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function394.set_cpd((1, 3, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function394.set_cpd((2, 3, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function394.set_cpd((3, 3, 0), (0.5, 0.4, 0.1, 0.0))
        pgm_function394.set_cpd((4, 3, 0), (0.1, 0.6, 0.25, 0.05))
        pgm_function394.set_cpd((0, 0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function394.set_cpd((1, 0, 1), (0.8, 0.2, 0.0, 0.0))
        pgm_function394.set_cpd((2, 0, 1), (0.8, 0.2, 0.0, 0.0))
        pgm_function394.set_cpd((3, 0, 1), (0.8, 0.2, 0.0, 0.0))
        pgm_function394.set_cpd((4, 0, 1), (0.8, 0.2, 0.0, 0.0))
        pgm_function394.set_cpd((0, 1, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function394.set_cpd((1, 1, 1), (0.8, 0.2, 0.0, 0.0))
        pgm_function394.set_cpd((2, 1, 1), (0.6, 0.4, 0.0, 0.0))
        pgm_function394.set_cpd((3, 1, 1), (0.4, 0.5, 0.1, 0.0))
        pgm_function394.set_cpd((4, 1, 1), (0.3, 0.4, 0.3, 0.0))
        pgm_function394.set_cpd((0, 2, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function394.set_cpd((1, 2, 1), (0.9, 0.1, 0.0, 0.0))
        pgm_function394.set_cpd((2, 2, 1), (0.6, 0.4, 0.0, 0.0))
        pgm_function394.set_cpd((3, 2, 1), (0.4, 0.5, 0.1, 0.0))
        pgm_function394.set_cpd((4, 2, 1), (0.3, 0.4, 0.3, 0.0))
        pgm_function394.set_cpd((0, 3, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function394.set_cpd((1, 3, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function394.set_cpd((2, 3, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function394.set_cpd((3, 3, 1), (0.5, 0.5, 0.0, 0.0))
        pgm_function394.set_cpd((4, 3, 1), (0.5, 0.5, 0.0, 0.0))
        pgm_function394.set_cpd((0, 0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function394.set_cpd((1, 0, 2), (0.8, 0.2, 0.0, 0.0))
        pgm_function394.set_cpd((2, 0, 2), (0.8, 0.2, 0.0, 0.0))
        pgm_function394.set_cpd((3, 0, 2), (0.8, 0.2, 0.0, 0.0))
        pgm_function394.set_cpd((4, 0, 2), (0.8, 0.2, 0.0, 0.0))
        pgm_function394.set_cpd((0, 1, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function394.set_cpd((1, 1, 2), (0.0, 1.0, 0.0, 0.0))
        pgm_function394.set_cpd((2, 1, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function394.set_cpd((3, 1, 2), (0.0, 0.0, 0.5, 0.5))
        pgm_function394.set_cpd((4, 1, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function394.set_cpd((0, 2, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function394.set_cpd((1, 2, 2), (0.0, 1.0, 0.0, 0.0))
        pgm_function394.set_cpd((2, 2, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function394.set_cpd((3, 2, 2), (0.0, 0.0, 0.5, 0.5))
        pgm_function394.set_cpd((4, 2, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function394.set_cpd((0, 3, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function394.set_cpd((1, 3, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function394.set_cpd((2, 3, 2), (0.9, 0.1, 0.0, 0.0))
        pgm_function394.set_cpd((3, 3, 2), (0.6, 0.3, 0.1, 0.0))
        pgm_function394.set_cpd((4, 3, 2), (0.45, 0.45, 0.1, 0.0))
        pgm_function394.set_cpd((0, 0, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function394.set_cpd((1, 0, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function394.set_cpd((2, 0, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function394.set_cpd((3, 0, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function394.set_cpd((4, 0, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function394.set_cpd((0, 1, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function394.set_cpd((1, 1, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function394.set_cpd((2, 1, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function394.set_cpd((3, 1, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function394.set_cpd((4, 1, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function394.set_cpd((0, 2, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function394.set_cpd((1, 2, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function394.set_cpd((2, 2, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function394.set_cpd((3, 2, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function394.set_cpd((4, 2, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function394.set_cpd((0, 3, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function394.set_cpd((1, 3, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function394.set_cpd((2, 3, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function394.set_cpd((3, 3, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function394.set_cpd((4, 3, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function394.set_cpd((0, 0, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function394.set_cpd((1, 0, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function394.set_cpd((2, 0, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function394.set_cpd((3, 0, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function394.set_cpd((4, 0, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function394.set_cpd((0, 1, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function394.set_cpd((1, 1, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function394.set_cpd((2, 1, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function394.set_cpd((3, 1, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function394.set_cpd((4, 1, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function394.set_cpd((0, 2, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function394.set_cpd((1, 2, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function394.set_cpd((2, 2, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function394.set_cpd((3, 2, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function394.set_cpd((4, 2, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function394.set_cpd((0, 3, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function394.set_cpd((1, 3, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function394.set_cpd((2, 3, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function394.set_cpd((3, 3, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function394.set_cpd((4, 3, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_factor395 = self.new_factor(R_LNLC8_LP_E_ADM_DENERV, R_LNLC8_LP_ADM_DENERV, R_LNLE_ADM_DENERV)
        pgm_function395 = pgm_factor395.set_cpt()
        pgm_function395.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function395.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function395.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function395.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function395.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0))
        pgm_function395.set_cpd((1, 1), (0.0, 0.0, 1.0, 0.0))
        pgm_function395.set_cpd((2, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function395.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function395.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function395.set_cpd((1, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function395.set_cpd((2, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function395.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function395.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function395.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function395.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function395.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor396 = self.new_factor(R_DIFFN_ADM_DENERV, DIFFN_M_SEV_DIST, DIFFN_TIME, DIFFN_PATHO)
        pgm_function396 = pgm_factor396.set_cpt()
        pgm_function396.set_cpd((0, 0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function396.set_cpd((1, 0, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function396.set_cpd((2, 0, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function396.set_cpd((3, 0, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function396.set_cpd((0, 1, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function396.set_cpd((1, 1, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function396.set_cpd((2, 1, 0), (0.3, 0.5, 0.2, 0.0))
        pgm_function396.set_cpd((3, 1, 0), (0.1, 0.5, 0.4, 0.0))
        pgm_function396.set_cpd((0, 2, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function396.set_cpd((1, 2, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function396.set_cpd((2, 2, 0), (0.3, 0.5, 0.2, 0.0))
        pgm_function396.set_cpd((3, 2, 0), (0.1, 0.5, 0.4, 0.0))
        pgm_function396.set_cpd((0, 3, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function396.set_cpd((1, 3, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function396.set_cpd((2, 3, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function396.set_cpd((3, 3, 0), (0.5, 0.4, 0.1, 0.0))
        pgm_function396.set_cpd((0, 0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function396.set_cpd((1, 0, 1), (0.8, 0.2, 0.0, 0.0))
        pgm_function396.set_cpd((2, 0, 1), (0.8, 0.2, 0.0, 0.0))
        pgm_function396.set_cpd((3, 0, 1), (0.8, 0.2, 0.0, 0.0))
        pgm_function396.set_cpd((0, 1, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function396.set_cpd((1, 1, 1), (0.9, 0.1, 0.0, 0.0))
        pgm_function396.set_cpd((2, 1, 1), (0.6, 0.4, 0.0, 0.0))
        pgm_function396.set_cpd((3, 1, 1), (0.4, 0.5, 0.1, 0.0))
        pgm_function396.set_cpd((0, 2, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function396.set_cpd((1, 2, 1), (0.9, 0.1, 0.0, 0.0))
        pgm_function396.set_cpd((2, 2, 1), (0.6, 0.4, 0.0, 0.0))
        pgm_function396.set_cpd((3, 2, 1), (0.4, 0.5, 0.1, 0.0))
        pgm_function396.set_cpd((0, 3, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function396.set_cpd((1, 3, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function396.set_cpd((2, 3, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function396.set_cpd((3, 3, 1), (0.5, 0.5, 0.0, 0.0))
        pgm_function396.set_cpd((0, 0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function396.set_cpd((1, 0, 2), (0.8, 0.2, 0.0, 0.0))
        pgm_function396.set_cpd((2, 0, 2), (0.8, 0.2, 0.0, 0.0))
        pgm_function396.set_cpd((3, 0, 2), (0.8, 0.2, 0.0, 0.0))
        pgm_function396.set_cpd((0, 1, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function396.set_cpd((1, 1, 2), (0.0, 1.0, 0.0, 0.0))
        pgm_function396.set_cpd((2, 1, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function396.set_cpd((3, 1, 2), (0.0, 0.0, 0.5, 0.5))
        pgm_function396.set_cpd((0, 2, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function396.set_cpd((1, 2, 2), (0.0, 1.0, 0.0, 0.0))
        pgm_function396.set_cpd((2, 2, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function396.set_cpd((3, 2, 2), (0.0, 0.0, 0.5, 0.5))
        pgm_function396.set_cpd((0, 3, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function396.set_cpd((1, 3, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function396.set_cpd((2, 3, 2), (0.9, 0.1, 0.0, 0.0))
        pgm_function396.set_cpd((3, 3, 2), (0.6, 0.3, 0.1, 0.0))
        pgm_function396.set_cpd((0, 0, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function396.set_cpd((1, 0, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function396.set_cpd((2, 0, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function396.set_cpd((3, 0, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function396.set_cpd((0, 1, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function396.set_cpd((1, 1, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function396.set_cpd((2, 1, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function396.set_cpd((3, 1, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function396.set_cpd((0, 2, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function396.set_cpd((1, 2, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function396.set_cpd((2, 2, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function396.set_cpd((3, 2, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function396.set_cpd((0, 3, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function396.set_cpd((1, 3, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function396.set_cpd((2, 3, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function396.set_cpd((3, 3, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function396.set_cpd((0, 0, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function396.set_cpd((1, 0, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function396.set_cpd((2, 0, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function396.set_cpd((3, 0, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function396.set_cpd((0, 1, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function396.set_cpd((1, 1, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function396.set_cpd((2, 1, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function396.set_cpd((3, 1, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function396.set_cpd((0, 2, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function396.set_cpd((1, 2, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function396.set_cpd((2, 2, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function396.set_cpd((3, 2, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function396.set_cpd((0, 3, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function396.set_cpd((1, 3, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function396.set_cpd((2, 3, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function396.set_cpd((3, 3, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_factor397 = self.new_factor(R_LNLW_ADM_DENERV)
        pgm_function397 = pgm_factor397.set_cpt()
        pgm_function397.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor398 = self.new_factor(R_DIFFN_LNLW_ADM_DENERV, R_DIFFN_ADM_DENERV, R_LNLW_ADM_DENERV)
        pgm_function398 = pgm_factor398.set_cpt()
        pgm_function398.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function398.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function398.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function398.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function398.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0))
        pgm_function398.set_cpd((1, 1), (0.0, 0.0, 1.0, 0.0))
        pgm_function398.set_cpd((2, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function398.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function398.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function398.set_cpd((1, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function398.set_cpd((2, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function398.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function398.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function398.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function398.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function398.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor399 = self.new_factor(R_LNL_DIFFN_ADM_DENERV, R_LNLC8_LP_E_ADM_DENERV, R_DIFFN_LNLW_ADM_DENERV)
        pgm_function399 = pgm_factor399.set_cpt()
        pgm_function399.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function399.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function399.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function399.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function399.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0))
        pgm_function399.set_cpd((1, 1), (0.0, 0.0, 1.0, 0.0))
        pgm_function399.set_cpd((2, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function399.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function399.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function399.set_cpd((1, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function399.set_cpd((2, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function399.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function399.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function399.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function399.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function399.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor400 = self.new_factor(R_ADM_DENERV, R_MUSCLE_ADM_DENERV, R_LNL_DIFFN_ADM_DENERV)
        pgm_function400 = pgm_factor400.set_cpt()
        pgm_function400.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function400.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function400.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function400.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function400.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0))
        pgm_function400.set_cpd((1, 1), (0.0, 0.0, 1.0, 0.0))
        pgm_function400.set_cpd((2, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function400.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function400.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function400.set_cpd((1, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function400.set_cpd((2, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function400.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function400.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function400.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function400.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function400.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor401 = self.new_factor(R_ADM_SPONT_DENERV_ACT, R_ADM_DENERV)
        pgm_function401 = pgm_factor401.set_cpt()
        pgm_function401.set_cpd((0,), (0.98, 0.02, 0.0, 0.0))
        pgm_function401.set_cpd((1,), (0.07, 0.85, 0.08, 0.0))
        pgm_function401.set_cpd((2,), (0.01, 0.07, 0.85, 0.07))
        pgm_function401.set_cpd((3,), (0.0, 0.01, 0.07, 0.92))
        pgm_factor402 = self.new_factor(R_ADM_SPONT_HF_DISCH, R_ADM_DENERV)
        pgm_function402 = pgm_factor402.set_cpt()
        pgm_function402.set_cpd((0,), (0.99, 0.01))
        pgm_function402.set_cpd((1,), (0.97, 0.03))
        pgm_function402.set_cpd((2,), (0.95, 0.05))
        pgm_function402.set_cpd((3,), (0.93, 0.07))
        pgm_factor403 = self.new_factor(R_ADM_SPONT_INS_ACT, R_ADM_DENERV)
        pgm_function403 = pgm_factor403.set_cpt()
        pgm_function403.set_cpd((0,), (0.98, 0.02))
        pgm_function403.set_cpd((1,), (0.1, 0.9))
        pgm_function403.set_cpd((2,), (0.05, 0.95))
        pgm_function403.set_cpd((3,), (0.05, 0.95))
        pgm_factor404 = self.new_factor(R_OTHER_DELT_NMT)
        pgm_function404 = pgm_factor404.set_cpt()
        pgm_function404.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor405 = self.new_factor(R_LNLPC5_AXIL_SEV)
        pgm_function405 = pgm_factor405.set_cpt()
        pgm_function405.set_cpd((), (0.98031378, 0.01069252, 0.0049965, 0.0029979, 0.0009993))
        pgm_factor406 = self.new_factor(R_LNLPC5_AXIL_TIME)
        pgm_function406 = pgm_factor406.set_cpt()
        pgm_function406.set_cpd((), (0.05, 0.6, 0.3, 0.05))
        pgm_factor407 = self.new_factor(R_LNLPC5_AXIL_PATHO)
        pgm_function407 = pgm_factor407.set_cpt()
        pgm_function407.set_cpd((), (0.6, 0.19, 0.2, 0.005, 0.005))
        pgm_factor408 = self.new_factor(R_LNLPC5_DELT_DE_REGEN, R_LNLPC5_AXIL_SEV, R_LNLPC5_AXIL_TIME,
                                        R_LNLPC5_AXIL_PATHO)
        pgm_function408 = pgm_factor408.set_cpt()
        pgm_function408.set_cpd((0, 0, 0), (1.0, 0.0))
        pgm_function408.set_cpd((1, 0, 0), (1.0, 0.0))
        pgm_function408.set_cpd((2, 0, 0), (1.0, 0.0))
        pgm_function408.set_cpd((3, 0, 0), (1.0, 0.0))
        pgm_function408.set_cpd((4, 0, 0), (1.0, 0.0))
        pgm_function408.set_cpd((0, 1, 0), (1.0, 0.0))
        pgm_function408.set_cpd((1, 1, 0), (0.8, 0.2))
        pgm_function408.set_cpd((2, 1, 0), (0.2, 0.8))
        pgm_function408.set_cpd((3, 1, 0), (0.4, 0.6))
        pgm_function408.set_cpd((4, 1, 0), (1.0, 0.0))
        pgm_function408.set_cpd((0, 2, 0), (1.0, 0.0))
        pgm_function408.set_cpd((1, 2, 0), (0.8, 0.2))
        pgm_function408.set_cpd((2, 2, 0), (0.2, 0.8))
        pgm_function408.set_cpd((3, 2, 0), (0.4, 0.6))
        pgm_function408.set_cpd((4, 2, 0), (1.0, 0.0))
        pgm_function408.set_cpd((0, 3, 0), (1.0, 0.0))
        pgm_function408.set_cpd((1, 3, 0), (1.0, 0.0))
        pgm_function408.set_cpd((2, 3, 0), (0.8, 0.2))
        pgm_function408.set_cpd((3, 3, 0), (0.4, 0.6))
        pgm_function408.set_cpd((4, 3, 0), (1.0, 0.0))
        pgm_function408.set_cpd((0, 0, 1), (1.0, 0.0))
        pgm_function408.set_cpd((1, 0, 1), (1.0, 0.0))
        pgm_function408.set_cpd((2, 0, 1), (1.0, 0.0))
        pgm_function408.set_cpd((3, 0, 1), (1.0, 0.0))
        pgm_function408.set_cpd((4, 0, 1), (1.0, 0.0))
        pgm_function408.set_cpd((0, 1, 1), (1.0, 0.0))
        pgm_function408.set_cpd((1, 1, 1), (0.8, 0.2))
        pgm_function408.set_cpd((2, 1, 1), (0.2, 0.8))
        pgm_function408.set_cpd((3, 1, 1), (0.4, 0.6))
        pgm_function408.set_cpd((4, 1, 1), (1.0, 0.0))
        pgm_function408.set_cpd((0, 2, 1), (1.0, 0.0))
        pgm_function408.set_cpd((1, 2, 1), (0.8, 0.2))
        pgm_function408.set_cpd((2, 2, 1), (0.2, 0.8))
        pgm_function408.set_cpd((3, 2, 1), (0.4, 0.6))
        pgm_function408.set_cpd((4, 2, 1), (1.0, 0.0))
        pgm_function408.set_cpd((0, 3, 1), (1.0, 0.0))
        pgm_function408.set_cpd((1, 3, 1), (1.0, 0.0))
        pgm_function408.set_cpd((2, 3, 1), (0.8, 0.2))
        pgm_function408.set_cpd((3, 3, 1), (0.4, 0.6))
        pgm_function408.set_cpd((4, 3, 1), (1.0, 0.0))
        pgm_function408.set_cpd((0, 0, 2), (1.0, 0.0))
        pgm_function408.set_cpd((1, 0, 2), (1.0, 0.0))
        pgm_function408.set_cpd((2, 0, 2), (1.0, 0.0))
        pgm_function408.set_cpd((3, 0, 2), (1.0, 0.0))
        pgm_function408.set_cpd((4, 0, 2), (1.0, 0.0))
        pgm_function408.set_cpd((0, 1, 2), (1.0, 0.0))
        pgm_function408.set_cpd((1, 1, 2), (0.5, 0.5))
        pgm_function408.set_cpd((2, 1, 2), (0.2, 0.8))
        pgm_function408.set_cpd((3, 1, 2), (0.1, 0.9))
        pgm_function408.set_cpd((4, 1, 2), (1.0, 0.0))
        pgm_function408.set_cpd((0, 2, 2), (1.0, 0.0))
        pgm_function408.set_cpd((1, 2, 2), (0.5, 0.5))
        pgm_function408.set_cpd((2, 2, 2), (0.2, 0.8))
        pgm_function408.set_cpd((3, 2, 2), (0.1, 0.9))
        pgm_function408.set_cpd((4, 2, 2), (1.0, 0.0))
        pgm_function408.set_cpd((0, 3, 2), (1.0, 0.0))
        pgm_function408.set_cpd((1, 3, 2), (1.0, 0.0))
        pgm_function408.set_cpd((2, 3, 2), (0.8, 0.2))
        pgm_function408.set_cpd((3, 3, 2), (0.4, 0.6))
        pgm_function408.set_cpd((4, 3, 2), (1.0, 0.0))
        pgm_function408.set_cpd((0, 0, 3), (0.0, 1.0))
        pgm_function408.set_cpd((1, 0, 3), (0.0, 1.0))
        pgm_function408.set_cpd((2, 0, 3), (0.0, 1.0))
        pgm_function408.set_cpd((3, 0, 3), (0.0, 1.0))
        pgm_function408.set_cpd((4, 0, 3), (0.0, 1.0))
        pgm_function408.set_cpd((0, 1, 3), (0.0, 1.0))
        pgm_function408.set_cpd((1, 1, 3), (0.0, 1.0))
        pgm_function408.set_cpd((2, 1, 3), (0.0, 1.0))
        pgm_function408.set_cpd((3, 1, 3), (0.0, 1.0))
        pgm_function408.set_cpd((4, 1, 3), (0.0, 1.0))
        pgm_function408.set_cpd((0, 2, 3), (0.0, 1.0))
        pgm_function408.set_cpd((1, 2, 3), (0.0, 1.0))
        pgm_function408.set_cpd((2, 2, 3), (0.0, 1.0))
        pgm_function408.set_cpd((3, 2, 3), (0.0, 1.0))
        pgm_function408.set_cpd((4, 2, 3), (0.0, 1.0))
        pgm_function408.set_cpd((0, 3, 3), (0.0, 1.0))
        pgm_function408.set_cpd((1, 3, 3), (0.0, 1.0))
        pgm_function408.set_cpd((2, 3, 3), (0.0, 1.0))
        pgm_function408.set_cpd((3, 3, 3), (0.0, 1.0))
        pgm_function408.set_cpd((4, 3, 3), (0.0, 1.0))
        pgm_function408.set_cpd((0, 0, 4), (0.0, 1.0))
        pgm_function408.set_cpd((1, 0, 4), (0.0, 1.0))
        pgm_function408.set_cpd((2, 0, 4), (0.0, 1.0))
        pgm_function408.set_cpd((3, 0, 4), (0.0, 1.0))
        pgm_function408.set_cpd((4, 0, 4), (0.0, 1.0))
        pgm_function408.set_cpd((0, 1, 4), (0.0, 1.0))
        pgm_function408.set_cpd((1, 1, 4), (0.0, 1.0))
        pgm_function408.set_cpd((2, 1, 4), (0.0, 1.0))
        pgm_function408.set_cpd((3, 1, 4), (0.0, 1.0))
        pgm_function408.set_cpd((4, 1, 4), (0.0, 1.0))
        pgm_function408.set_cpd((0, 2, 4), (0.0, 1.0))
        pgm_function408.set_cpd((1, 2, 4), (0.0, 1.0))
        pgm_function408.set_cpd((2, 2, 4), (0.0, 1.0))
        pgm_function408.set_cpd((3, 2, 4), (0.0, 1.0))
        pgm_function408.set_cpd((4, 2, 4), (0.0, 1.0))
        pgm_function408.set_cpd((0, 3, 4), (0.0, 1.0))
        pgm_function408.set_cpd((1, 3, 4), (0.0, 1.0))
        pgm_function408.set_cpd((2, 3, 4), (0.0, 1.0))
        pgm_function408.set_cpd((3, 3, 4), (0.0, 1.0))
        pgm_function408.set_cpd((4, 3, 4), (0.0, 1.0))
        pgm_factor409 = self.new_factor(R_DIFFN_DELT_DE_REGEN, DIFFN_M_SEV_PROX, DIFFN_TIME, DIFFN_PATHO)
        pgm_function409 = pgm_factor409.set_cpt()
        pgm_function409.set_cpd((0, 0, 0), (1.0, 0.0))
        pgm_function409.set_cpd((1, 0, 0), (1.0, 0.0))
        pgm_function409.set_cpd((2, 0, 0), (1.0, 0.0))
        pgm_function409.set_cpd((3, 0, 0), (1.0, 0.0))
        pgm_function409.set_cpd((0, 1, 0), (1.0, 0.0))
        pgm_function409.set_cpd((1, 1, 0), (0.8, 0.2))
        pgm_function409.set_cpd((2, 1, 0), (0.2, 0.8))
        pgm_function409.set_cpd((3, 1, 0), (0.4, 0.6))
        pgm_function409.set_cpd((0, 2, 0), (1.0, 0.0))
        pgm_function409.set_cpd((1, 2, 0), (0.8, 0.2))
        pgm_function409.set_cpd((2, 2, 0), (0.2, 0.8))
        pgm_function409.set_cpd((3, 2, 0), (0.4, 0.6))
        pgm_function409.set_cpd((0, 3, 0), (1.0, 0.0))
        pgm_function409.set_cpd((1, 3, 0), (1.0, 0.0))
        pgm_function409.set_cpd((2, 3, 0), (0.8, 0.2))
        pgm_function409.set_cpd((3, 3, 0), (0.4, 0.6))
        pgm_function409.set_cpd((0, 0, 1), (1.0, 0.0))
        pgm_function409.set_cpd((1, 0, 1), (1.0, 0.0))
        pgm_function409.set_cpd((2, 0, 1), (1.0, 0.0))
        pgm_function409.set_cpd((3, 0, 1), (1.0, 0.0))
        pgm_function409.set_cpd((0, 1, 1), (1.0, 0.0))
        pgm_function409.set_cpd((1, 1, 1), (0.8, 0.2))
        pgm_function409.set_cpd((2, 1, 1), (0.2, 0.8))
        pgm_function409.set_cpd((3, 1, 1), (0.4, 0.6))
        pgm_function409.set_cpd((0, 2, 1), (1.0, 0.0))
        pgm_function409.set_cpd((1, 2, 1), (0.8, 0.2))
        pgm_function409.set_cpd((2, 2, 1), (0.2, 0.8))
        pgm_function409.set_cpd((3, 2, 1), (0.4, 0.6))
        pgm_function409.set_cpd((0, 3, 1), (1.0, 0.0))
        pgm_function409.set_cpd((1, 3, 1), (1.0, 0.0))
        pgm_function409.set_cpd((2, 3, 1), (0.8, 0.2))
        pgm_function409.set_cpd((3, 3, 1), (0.4, 0.6))
        pgm_function409.set_cpd((0, 0, 2), (1.0, 0.0))
        pgm_function409.set_cpd((1, 0, 2), (1.0, 0.0))
        pgm_function409.set_cpd((2, 0, 2), (1.0, 0.0))
        pgm_function409.set_cpd((3, 0, 2), (1.0, 0.0))
        pgm_function409.set_cpd((0, 1, 2), (1.0, 0.0))
        pgm_function409.set_cpd((1, 1, 2), (0.5, 0.5))
        pgm_function409.set_cpd((2, 1, 2), (0.2, 0.8))
        pgm_function409.set_cpd((3, 1, 2), (0.1, 0.9))
        pgm_function409.set_cpd((0, 2, 2), (1.0, 0.0))
        pgm_function409.set_cpd((1, 2, 2), (0.5, 0.5))
        pgm_function409.set_cpd((2, 2, 2), (0.2, 0.8))
        pgm_function409.set_cpd((3, 2, 2), (0.1, 0.9))
        pgm_function409.set_cpd((0, 3, 2), (1.0, 0.0))
        pgm_function409.set_cpd((1, 3, 2), (1.0, 0.0))
        pgm_function409.set_cpd((2, 3, 2), (0.8, 0.2))
        pgm_function409.set_cpd((3, 3, 2), (0.4, 0.6))
        pgm_function409.set_cpd((0, 0, 3), (0.0, 1.0))
        pgm_function409.set_cpd((1, 0, 3), (0.0, 1.0))
        pgm_function409.set_cpd((2, 0, 3), (0.0, 1.0))
        pgm_function409.set_cpd((3, 0, 3), (0.0, 1.0))
        pgm_function409.set_cpd((0, 1, 3), (0.0, 1.0))
        pgm_function409.set_cpd((1, 1, 3), (0.0, 1.0))
        pgm_function409.set_cpd((2, 1, 3), (0.0, 1.0))
        pgm_function409.set_cpd((3, 1, 3), (0.0, 1.0))
        pgm_function409.set_cpd((0, 2, 3), (0.0, 1.0))
        pgm_function409.set_cpd((1, 2, 3), (0.0, 1.0))
        pgm_function409.set_cpd((2, 2, 3), (0.0, 1.0))
        pgm_function409.set_cpd((3, 2, 3), (0.0, 1.0))
        pgm_function409.set_cpd((0, 3, 3), (0.0, 1.0))
        pgm_function409.set_cpd((1, 3, 3), (0.0, 1.0))
        pgm_function409.set_cpd((2, 3, 3), (0.0, 1.0))
        pgm_function409.set_cpd((3, 3, 3), (0.0, 1.0))
        pgm_function409.set_cpd((0, 0, 4), (0.0, 1.0))
        pgm_function409.set_cpd((1, 0, 4), (0.0, 1.0))
        pgm_function409.set_cpd((2, 0, 4), (0.0, 1.0))
        pgm_function409.set_cpd((3, 0, 4), (0.0, 1.0))
        pgm_function409.set_cpd((0, 1, 4), (0.0, 1.0))
        pgm_function409.set_cpd((1, 1, 4), (0.0, 1.0))
        pgm_function409.set_cpd((2, 1, 4), (0.0, 1.0))
        pgm_function409.set_cpd((3, 1, 4), (0.0, 1.0))
        pgm_function409.set_cpd((0, 2, 4), (0.0, 1.0))
        pgm_function409.set_cpd((1, 2, 4), (0.0, 1.0))
        pgm_function409.set_cpd((2, 2, 4), (0.0, 1.0))
        pgm_function409.set_cpd((3, 2, 4), (0.0, 1.0))
        pgm_function409.set_cpd((0, 3, 4), (0.0, 1.0))
        pgm_function409.set_cpd((1, 3, 4), (0.0, 1.0))
        pgm_function409.set_cpd((2, 3, 4), (0.0, 1.0))
        pgm_function409.set_cpd((3, 3, 4), (0.0, 1.0))
        pgm_factor410 = self.new_factor(R_LNLPC5_DIFFN_DELT_DE_REGEN, R_LNLPC5_DELT_DE_REGEN, R_DIFFN_DELT_DE_REGEN)
        pgm_function410 = pgm_factor410.set_cpt()
        pgm_function410.set_cpd((0, 0), (1.0, 0.0))
        pgm_function410.set_cpd((1, 0), (0.0, 1.0))
        pgm_function410.set_cpd((0, 1), (0.0, 1.0))
        pgm_function410.set_cpd((1, 1), (0.0, 1.0))
        pgm_factor411 = self.new_factor(R_MYOP_DELT_DE_REGEN)
        pgm_function411 = pgm_factor411.set_cpt()
        pgm_function411.set_cpd((), (1.0, 0.0))
        pgm_factor412 = self.new_factor(R_MYDY_DELT_DE_REGEN)
        pgm_function412 = pgm_factor412.set_cpt()
        pgm_function412.set_cpd((), (1.0, 0.0))
        pgm_factor413 = self.new_factor(R_MYOP_MYDY_DELT_DE_REGEN, R_MYOP_DELT_DE_REGEN, R_MYDY_DELT_DE_REGEN)
        pgm_function413 = pgm_factor413.set_cpt()
        pgm_function413.set_cpd((0, 0), (1.0, 0.0))
        pgm_function413.set_cpd((1, 0), (0.0, 1.0))
        pgm_function413.set_cpd((0, 1), (0.0, 1.0))
        pgm_function413.set_cpd((1, 1), (0.0, 1.0))
        pgm_factor414 = self.new_factor(R_OTHER_DELT_DE_REGEN)
        pgm_function414 = pgm_factor414.set_cpt()
        pgm_function414.set_cpd((), (1.0, 0.0))
        pgm_factor415 = self.new_factor(R_MUSCLE_DELT_DE_REGEN, R_MYOP_MYDY_DELT_DE_REGEN, R_OTHER_DELT_DE_REGEN)
        pgm_function415 = pgm_factor415.set_cpt()
        pgm_function415.set_cpd((0, 0), (1.0, 0.0))
        pgm_function415.set_cpd((1, 0), (0.0, 1.0))
        pgm_function415.set_cpd((0, 1), (0.0, 1.0))
        pgm_function415.set_cpd((1, 1), (0.0, 1.0))
        pgm_factor416 = self.new_factor(R_DELT_DE_REGEN, R_LNLPC5_DIFFN_DELT_DE_REGEN, R_MUSCLE_DELT_DE_REGEN)
        pgm_function416 = pgm_factor416.set_cpt()
        pgm_function416.set_cpd((0, 0), (1.0, 0.0))
        pgm_function416.set_cpd((1, 0), (0.0, 1.0))
        pgm_function416.set_cpd((0, 1), (0.0, 1.0))
        pgm_function416.set_cpd((1, 1), (0.0, 1.0))
        pgm_factor417 = self.new_factor(R_DE_REGEN_DELT_NMT, R_DELT_DE_REGEN)
        pgm_function417 = pgm_factor417.set_cpt()
        pgm_function417.set_cpd((0,), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function417.set_cpd((1,), (0.949, 0.003, 0.001, 0.04, 0.003, 0.001, 0.003))
        pgm_factor418 = self.new_factor(R_MYAS_DELT_NMT)
        pgm_function418 = pgm_factor418.set_cpt()
        pgm_function418.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor419 = self.new_factor(R_MYAS_DE_REGEN_DELT_NMT, R_DE_REGEN_DELT_NMT, R_MYAS_DELT_NMT)
        pgm_function419 = pgm_factor419.set_cpt()
        pgm_function419.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function419.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function419.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function419.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function419.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function419.set_cpd((5, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function419.set_cpd((6, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function419.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function419.set_cpd((1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function419.set_cpd((2, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function419.set_cpd((3, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function419.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function419.set_cpd((5, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function419.set_cpd((6, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function419.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function419.set_cpd((1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function419.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function419.set_cpd((3, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function419.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function419.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function419.set_cpd((6, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function419.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function419.set_cpd((1, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function419.set_cpd((2, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function419.set_cpd((3, 3), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function419.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function419.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function419.set_cpd((6, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function419.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function419.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function419.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function419.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function419.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function419.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function419.set_cpd((6, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function419.set_cpd((0, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function419.set_cpd((1, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function419.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function419.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function419.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function419.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function419.set_cpd((6, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function419.set_cpd((0, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function419.set_cpd((1, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function419.set_cpd((2, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function419.set_cpd((3, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function419.set_cpd((4, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function419.set_cpd((5, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function419.set_cpd((6, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor420 = self.new_factor(R_DELT_NMT, R_OTHER_DELT_NMT, R_MYAS_DE_REGEN_DELT_NMT)
        pgm_function420 = pgm_factor420.set_cpt()
        pgm_function420.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function420.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function420.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function420.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function420.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function420.set_cpd((5, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function420.set_cpd((6, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function420.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function420.set_cpd((1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function420.set_cpd((2, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function420.set_cpd((3, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function420.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function420.set_cpd((5, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function420.set_cpd((6, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function420.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function420.set_cpd((1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function420.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function420.set_cpd((3, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function420.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function420.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function420.set_cpd((6, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function420.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function420.set_cpd((1, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function420.set_cpd((2, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function420.set_cpd((3, 3), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function420.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function420.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function420.set_cpd((6, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function420.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function420.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function420.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function420.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function420.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function420.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function420.set_cpd((6, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function420.set_cpd((0, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function420.set_cpd((1, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function420.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function420.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function420.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function420.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function420.set_cpd((6, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function420.set_cpd((0, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function420.set_cpd((1, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function420.set_cpd((2, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function420.set_cpd((3, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function420.set_cpd((4, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function420.set_cpd((5, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function420.set_cpd((6, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor421 = self.new_factor(R_OTHER_DELT_MUSIZE)
        pgm_function421 = pgm_factor421.set_cpt()
        pgm_function421.set_cpd((), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_factor422 = self.new_factor(R_MYDY_DELT_MUSIZE)
        pgm_function422 = pgm_factor422.set_cpt()
        pgm_function422.set_cpd((), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_factor423 = self.new_factor(R_MYOP_DELT_MUSIZE)
        pgm_function423 = pgm_factor423.set_cpt()
        pgm_function423.set_cpd((), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_factor424 = self.new_factor(R_MYOP_MYDY_DELT_MUSIZE, R_MYDY_DELT_MUSIZE, R_MYOP_DELT_MUSIZE)
        pgm_function424 = pgm_factor424.set_cpt()
        pgm_function424.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function424.set_cpd((1, 0), (0.9983, 0.0017, 0.0, 0.0, 0.0, 0.0))
        pgm_function424.set_cpd((2, 0), (0.9857, 0.0143, 0.0, 0.0, 0.0, 0.0))
        pgm_function424.set_cpd((3, 0), (0.3673, 0.6298, 0.0029, 0.0, 0.0, 0.0))
        pgm_function424.set_cpd((4, 0), (0.01150115, 0.86168617, 0.12491249, 0.00190019, 0.0, 0.0))
        pgm_function424.set_cpd((5, 0), (0.0, 0.1596, 0.7368, 0.1016, 0.002, 0.0))
        pgm_function424.set_cpd((0, 1), (0.9983, 0.0017, 0.0, 0.0, 0.0, 0.0))
        pgm_function424.set_cpd((1, 1), (0.8667, 0.1329, 0.0004, 0.0, 0.0, 0.0))
        pgm_function424.set_cpd((2, 1), (0.01390139, 0.96369637, 0.02240224, 0.0, 0.0, 0.0))
        pgm_function424.set_cpd((3, 1), (0.0003, 0.3514, 0.6035, 0.0443, 0.0005, 0.0))
        pgm_function424.set_cpd((4, 1), (0.0, 0.0105, 0.5726, 0.3806, 0.0359, 0.0004))
        pgm_function424.set_cpd((5, 1), (0.0, 0.0, 0.0792, 0.4758, 0.4066, 0.0384))
        pgm_function424.set_cpd((0, 2), (0.9857, 0.0143, 0.0, 0.0, 0.0, 0.0))
        pgm_function424.set_cpd((1, 2), (0.01390139, 0.96369637, 0.02240224, 0.0, 0.0, 0.0))
        pgm_function424.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function424.set_cpd((3, 2), (0.0, 0.0, 0.04060406, 0.92779278, 0.03160316, 0.0))
        pgm_function424.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0319, 0.9362, 0.0319))
        pgm_function424.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 0.0329, 0.9671))
        pgm_function424.set_cpd((0, 3), (0.3673, 0.6298, 0.0029, 0.0, 0.0, 0.0))
        pgm_function424.set_cpd((1, 3), (0.0003, 0.3514, 0.6035, 0.0443, 0.0005, 0.0))
        pgm_function424.set_cpd((2, 3), (0.0, 0.0, 0.04060406, 0.92779278, 0.03160316, 0.0))
        pgm_function424.set_cpd((3, 3), (0.0, 0.0, 0.00039996, 0.10988901, 0.77982202, 0.10988901))
        pgm_function424.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.00030003, 0.12341234, 0.87628763))
        pgm_function424.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0028, 0.9972))
        pgm_function424.set_cpd((0, 4), (0.01150115, 0.86168617, 0.12491249, 0.00190019, 0.0, 0.0))
        pgm_function424.set_cpd((1, 4), (0.0, 0.0105, 0.5726, 0.3806, 0.0359, 0.0004))
        pgm_function424.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0319, 0.9362, 0.0319))
        pgm_function424.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.00030003, 0.12341234, 0.87628763))
        pgm_function424.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 0.0028, 0.9972))
        pgm_function424.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0001, 0.9999))
        pgm_function424.set_cpd((0, 5), (0.0, 0.1596, 0.7368, 0.1016, 0.002, 0.0))
        pgm_function424.set_cpd((1, 5), (0.0, 0.0, 0.0792, 0.4758, 0.4066, 0.0384))
        pgm_function424.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0329, 0.9671))
        pgm_function424.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0028, 0.9972))
        pgm_function424.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0001, 0.9999))
        pgm_function424.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor425 = self.new_factor(R_MUSCLE_DELT_MUSIZE, R_OTHER_DELT_MUSIZE, R_MYOP_MYDY_DELT_MUSIZE)
        pgm_function425 = pgm_factor425.set_cpt()
        pgm_function425.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function425.set_cpd((1, 0), (0.9983, 0.0017, 0.0, 0.0, 0.0, 0.0))
        pgm_function425.set_cpd((2, 0), (0.9857, 0.0143, 0.0, 0.0, 0.0, 0.0))
        pgm_function425.set_cpd((3, 0), (0.3673, 0.6298, 0.0029, 0.0, 0.0, 0.0))
        pgm_function425.set_cpd((4, 0), (0.01150115, 0.86168617, 0.12491249, 0.00190019, 0.0, 0.0))
        pgm_function425.set_cpd((5, 0), (0.0, 0.1596, 0.7368, 0.1016, 0.002, 0.0))
        pgm_function425.set_cpd((0, 1), (0.9983, 0.0017, 0.0, 0.0, 0.0, 0.0))
        pgm_function425.set_cpd((1, 1), (0.8667, 0.1329, 0.0004, 0.0, 0.0, 0.0))
        pgm_function425.set_cpd((2, 1), (0.01390139, 0.96369637, 0.02240224, 0.0, 0.0, 0.0))
        pgm_function425.set_cpd((3, 1), (0.0003, 0.3514, 0.6035, 0.0443, 0.0005, 0.0))
        pgm_function425.set_cpd((4, 1), (0.0, 0.0105, 0.5726, 0.3806, 0.0359, 0.0004))
        pgm_function425.set_cpd((5, 1), (0.0, 0.0, 0.0792, 0.4758, 0.4066, 0.0384))
        pgm_function425.set_cpd((0, 2), (0.9857, 0.0143, 0.0, 0.0, 0.0, 0.0))
        pgm_function425.set_cpd((1, 2), (0.01390139, 0.96369637, 0.02240224, 0.0, 0.0, 0.0))
        pgm_function425.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function425.set_cpd((3, 2), (0.0, 0.0, 0.04060406, 0.92779278, 0.03160316, 0.0))
        pgm_function425.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0319, 0.9362, 0.0319))
        pgm_function425.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 0.0329, 0.9671))
        pgm_function425.set_cpd((0, 3), (0.3673, 0.6298, 0.0029, 0.0, 0.0, 0.0))
        pgm_function425.set_cpd((1, 3), (0.0003, 0.3514, 0.6035, 0.0443, 0.0005, 0.0))
        pgm_function425.set_cpd((2, 3), (0.0, 0.0, 0.04060406, 0.92779278, 0.03160316, 0.0))
        pgm_function425.set_cpd((3, 3), (0.0, 0.0, 0.00039996, 0.10988901, 0.77982202, 0.10988901))
        pgm_function425.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.00030003, 0.12341234, 0.87628763))
        pgm_function425.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0028, 0.9972))
        pgm_function425.set_cpd((0, 4), (0.01150115, 0.86168617, 0.12491249, 0.00190019, 0.0, 0.0))
        pgm_function425.set_cpd((1, 4), (0.0, 0.0105, 0.5726, 0.3806, 0.0359, 0.0004))
        pgm_function425.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0319, 0.9362, 0.0319))
        pgm_function425.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.00030003, 0.12341234, 0.87628763))
        pgm_function425.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 0.0028, 0.9972))
        pgm_function425.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0001, 0.9999))
        pgm_function425.set_cpd((0, 5), (0.0, 0.1596, 0.7368, 0.1016, 0.002, 0.0))
        pgm_function425.set_cpd((1, 5), (0.0, 0.0, 0.0792, 0.4758, 0.4066, 0.0384))
        pgm_function425.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0329, 0.9671))
        pgm_function425.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0028, 0.9972))
        pgm_function425.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0001, 0.9999))
        pgm_function425.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor426 = self.new_factor(R_DIFFN_DELT_MUSIZE, DIFFN_M_SEV_PROX, DIFFN_TIME, DIFFN_PATHO)
        pgm_function426 = pgm_factor426.set_cpt()
        pgm_function426.set_cpd((0, 0, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((1, 0, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((2, 0, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((3, 0, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((0, 1, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((1, 1, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((2, 1, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((3, 1, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((0, 2, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((1, 2, 0), (0.0, 0.0, 0.9, 0.1, 0.0, 0.0))
        pgm_function426.set_cpd((2, 2, 0), (0.0, 0.0, 0.2, 0.7, 0.1, 0.0))
        pgm_function426.set_cpd((3, 2, 0), (0.0, 0.0, 0.0, 0.2, 0.7, 0.1))
        pgm_function426.set_cpd((0, 3, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((1, 3, 0), (0.0, 0.0, 0.9, 0.1, 0.0, 0.0))
        pgm_function426.set_cpd((2, 3, 0), (0.0, 0.0, 0.2, 0.7, 0.1, 0.0))
        pgm_function426.set_cpd((3, 3, 0), (0.0, 0.0, 0.0, 0.2, 0.7, 0.1))
        pgm_function426.set_cpd((0, 0, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((1, 0, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((2, 0, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((3, 0, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((0, 1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((1, 1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((2, 1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((3, 1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((0, 2, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((1, 2, 1), (0.0, 0.0, 0.95, 0.05, 0.0, 0.0))
        pgm_function426.set_cpd((2, 2, 1), (0.0, 0.0, 0.7, 0.25, 0.05, 0.0))
        pgm_function426.set_cpd((3, 2, 1), (0.0, 0.0, 0.0, 0.25, 0.7, 0.05))
        pgm_function426.set_cpd((0, 3, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((1, 3, 1), (0.0, 0.0, 0.95, 0.05, 0.0, 0.0))
        pgm_function426.set_cpd((2, 3, 1), (0.0, 0.0, 0.7, 0.25, 0.05, 0.0))
        pgm_function426.set_cpd((3, 3, 1), (0.0, 0.0, 0.0, 0.25, 0.7, 0.05))
        pgm_function426.set_cpd((0, 0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((1, 0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((2, 0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((3, 0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((0, 1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((1, 1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((2, 1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((3, 1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((0, 2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((1, 2, 2), (0.0, 0.0, 0.8, 0.2, 0.0, 0.0))
        pgm_function426.set_cpd((2, 2, 2), (0.0, 0.0, 0.0, 0.8, 0.2, 0.0))
        pgm_function426.set_cpd((3, 2, 2), (0.0, 0.0, 0.0, 0.1, 0.6, 0.3))
        pgm_function426.set_cpd((0, 3, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((1, 3, 2), (0.0, 0.0, 0.8, 0.2, 0.0, 0.0))
        pgm_function426.set_cpd((2, 3, 2), (0.0, 0.0, 0.0, 0.8, 0.2, 0.0))
        pgm_function426.set_cpd((3, 3, 2), (0.0, 0.0, 0.0, 0.1, 0.6, 0.3))
        pgm_function426.set_cpd((0, 0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((1, 0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((2, 0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((3, 0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((0, 1, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((1, 1, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((2, 1, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((3, 1, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((0, 2, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((1, 2, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((2, 2, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((3, 2, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((0, 3, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((1, 3, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((2, 3, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((3, 3, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((0, 0, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((1, 0, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((2, 0, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((3, 0, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((0, 1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((1, 1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((2, 1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((3, 1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((0, 2, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((1, 2, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((2, 2, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((3, 2, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((0, 3, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((1, 3, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((2, 3, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function426.set_cpd((3, 3, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor427 = self.new_factor(R_LNLPC5_DELT_MUSIZE, R_LNLPC5_AXIL_SEV, R_LNLPC5_AXIL_TIME,
                                        R_LNLPC5_AXIL_PATHO)
        pgm_function427 = pgm_factor427.set_cpt()
        pgm_function427.set_cpd((0, 0, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((1, 0, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((2, 0, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((3, 0, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((4, 0, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((0, 1, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((1, 1, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((2, 1, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((3, 1, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((4, 1, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((0, 2, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((1, 2, 0), (0.0, 0.0, 0.9, 0.1, 0.0, 0.0))
        pgm_function427.set_cpd((2, 2, 0), (0.0, 0.0, 0.2, 0.7, 0.1, 0.0))
        pgm_function427.set_cpd((3, 2, 0), (0.0, 0.0, 0.0, 0.2, 0.7, 0.1))
        pgm_function427.set_cpd((4, 2, 0), (0.0, 0.0, 0.0, 0.2, 0.7, 0.1))
        pgm_function427.set_cpd((0, 3, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((1, 3, 0), (0.0, 0.0, 0.9, 0.1, 0.0, 0.0))
        pgm_function427.set_cpd((2, 3, 0), (0.0, 0.0, 0.2, 0.7, 0.1, 0.0))
        pgm_function427.set_cpd((3, 3, 0), (0.0, 0.0, 0.0, 0.2, 0.7, 0.1))
        pgm_function427.set_cpd((4, 3, 0), (0.0, 0.0, 0.0, 0.2, 0.7, 0.1))
        pgm_function427.set_cpd((0, 0, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((1, 0, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((2, 0, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((3, 0, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((4, 0, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((0, 1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((1, 1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((2, 1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((3, 1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((4, 1, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((0, 2, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((1, 2, 1), (0.0, 0.0, 0.95, 0.05, 0.0, 0.0))
        pgm_function427.set_cpd((2, 2, 1), (0.0, 0.0, 0.7, 0.25, 0.05, 0.0))
        pgm_function427.set_cpd((3, 2, 1), (0.0, 0.0, 0.0, 0.25, 0.7, 0.05))
        pgm_function427.set_cpd((4, 2, 1), (0.0, 0.0, 0.0, 0.25, 0.7, 0.05))
        pgm_function427.set_cpd((0, 3, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((1, 3, 1), (0.0, 0.0, 0.95, 0.05, 0.0, 0.0))
        pgm_function427.set_cpd((2, 3, 1), (0.0, 0.0, 0.7, 0.25, 0.05, 0.0))
        pgm_function427.set_cpd((3, 3, 1), (0.0, 0.0, 0.0, 0.25, 0.7, 0.05))
        pgm_function427.set_cpd((4, 3, 1), (0.0, 0.0, 0.0, 0.25, 0.7, 0.05))
        pgm_function427.set_cpd((0, 0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((1, 0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((2, 0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((3, 0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((4, 0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((0, 1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((1, 1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((2, 1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((3, 1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((4, 1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((0, 2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((1, 2, 2), (0.0, 0.0, 0.8, 0.2, 0.0, 0.0))
        pgm_function427.set_cpd((2, 2, 2), (0.0, 0.0, 0.0, 0.8, 0.2, 0.0))
        pgm_function427.set_cpd((3, 2, 2), (0.0, 0.0, 0.0, 0.1, 0.6, 0.3))
        pgm_function427.set_cpd((4, 2, 2), (0.0, 0.0, 0.0, 0.1, 0.6, 0.3))
        pgm_function427.set_cpd((0, 3, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((1, 3, 2), (0.0, 0.0, 0.8, 0.2, 0.0, 0.0))
        pgm_function427.set_cpd((2, 3, 2), (0.0, 0.0, 0.0, 0.8, 0.2, 0.0))
        pgm_function427.set_cpd((3, 3, 2), (0.0, 0.0, 0.0, 0.1, 0.6, 0.3))
        pgm_function427.set_cpd((4, 3, 2), (0.0, 0.0, 0.0, 0.1, 0.6, 0.3))
        pgm_function427.set_cpd((0, 0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((1, 0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((2, 0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((3, 0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((4, 0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((0, 1, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((1, 1, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((2, 1, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((3, 1, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((4, 1, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((0, 2, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((1, 2, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((2, 2, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((3, 2, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((4, 2, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((0, 3, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((1, 3, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((2, 3, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((3, 3, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((4, 3, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((0, 0, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((1, 0, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((2, 0, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((3, 0, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((4, 0, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((0, 1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((1, 1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((2, 1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((3, 1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((4, 1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((0, 2, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((1, 2, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((2, 2, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((3, 2, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((4, 2, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((0, 3, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((1, 3, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((2, 3, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((3, 3, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function427.set_cpd((4, 3, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor428 = self.new_factor(R_LNLPC5_DIFFN_DELT_MUSIZE, R_DIFFN_DELT_MUSIZE, R_LNLPC5_DELT_MUSIZE)
        pgm_function428 = pgm_factor428.set_cpt()
        pgm_function428.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function428.set_cpd((1, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function428.set_cpd((2, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function428.set_cpd((3, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function428.set_cpd((4, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function428.set_cpd((5, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function428.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function428.set_cpd((1, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function428.set_cpd((2, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function428.set_cpd((3, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function428.set_cpd((4, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function428.set_cpd((5, 1), (0.0, 0.99939994, 0.00050005, 0.00010001, 0.0, 0.0))
        pgm_function428.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function428.set_cpd((1, 2), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function428.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function428.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function428.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function428.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function428.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function428.set_cpd((1, 3), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function428.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function428.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function428.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function428.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function428.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function428.set_cpd((1, 4), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function428.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function428.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function428.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function428.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function428.set_cpd((0, 5), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function428.set_cpd((1, 5), (0.0, 0.99939994, 0.00050005, 0.00010001, 0.0, 0.0))
        pgm_function428.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function428.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function428.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function428.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor429 = self.new_factor(R_DELT_MUSIZE, R_MUSCLE_DELT_MUSIZE, R_LNLPC5_DIFFN_DELT_MUSIZE)
        pgm_function429 = pgm_factor429.set_cpt()
        pgm_function429.set_cpd((0, 0), (0.98, 0.0, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function429.set_cpd((1, 0), (0.98, 0.0, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function429.set_cpd((2, 0), (0.98, 0.0, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function429.set_cpd((3, 0), (0.98, 0.0, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function429.set_cpd((4, 0), (0.98, 0.0, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function429.set_cpd((5, 0), (0.98, 0.0, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function429.set_cpd((0, 1), (0.98, 0.0, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function429.set_cpd((1, 1), (0.0, 0.98, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function429.set_cpd((2, 1), (0.0, 0.98, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function429.set_cpd((3, 1), (0.0, 0.98, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function429.set_cpd((4, 1), (0.0, 0.98, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function429.set_cpd((5, 1), (0.0, 0.97939794, 0.00050005, 0.00010001, 0.0, 0.0, 0.020002))
        pgm_function429.set_cpd((0, 2), (0.98, 0.0, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function429.set_cpd((1, 2), (0.0, 0.98, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function429.set_cpd((2, 2), (0.0, 0.0, 0.9781, 0.0019, 0.0, 0.0, 0.02))
        pgm_function429.set_cpd((3, 2), (0.0, 0.0, 0.0019, 0.9781, 0.0, 0.0, 0.02))
        pgm_function429.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 0.98, 0.0, 0.02))
        pgm_function429.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function429.set_cpd((0, 3), (0.98, 0.0, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function429.set_cpd((1, 3), (0.0, 0.98, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function429.set_cpd((2, 3), (0.0, 0.0, 0.0019, 0.9781, 0.0, 0.0, 0.02))
        pgm_function429.set_cpd((3, 3), (0.0, 0.0, 0.0, 0.98, 0.0, 0.0, 0.02))
        pgm_function429.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.98, 0.0, 0.02))
        pgm_function429.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function429.set_cpd((0, 4), (0.98, 0.0, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function429.set_cpd((1, 4), (0.0, 0.98, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function429.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.0, 0.02))
        pgm_function429.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.0, 0.02))
        pgm_function429.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.0, 0.02))
        pgm_function429.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function429.set_cpd((0, 5), (0.98, 0.0, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function429.set_cpd((1, 5), (0.0, 0.97939794, 0.00050005, 0.00010001, 0.0, 0.0, 0.020002))
        pgm_function429.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function429.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function429.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function429.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_factor430 = self.new_factor(R_DELT_EFFMUS, R_DELT_NMT, R_DELT_MUSIZE)
        pgm_function430 = pgm_factor430.set_cpt()
        pgm_function430.set_cpd((0, 0), (0.9683, 0.0117, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function430.set_cpd((1, 0), (0.9794, 0.0006, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function430.set_cpd((2, 0), (0.9799, 0.0001, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function430.set_cpd((3, 0), (0.9742, 0.0058, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function430.set_cpd((4, 0), (0.9789, 0.0011, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function430.set_cpd((5, 0), (0.9799, 0.0001, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function430.set_cpd((6, 0), (0.7927, 0.1721, 0.0135, 0.0016, 0.0001, 0.0, 0.02))
        pgm_function430.set_cpd((0, 1), (0.0164, 0.9421, 0.0215, 0.0, 0.0, 0.0, 0.02))
        pgm_function430.set_cpd((1, 1), (0.8182, 0.1616, 0.0002, 0.0, 0.0, 0.0, 0.02))
        pgm_function430.set_cpd((2, 1), (0.9738, 0.0062, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function430.set_cpd((3, 1), (0.0329, 0.9359, 0.0112, 0.0, 0.0, 0.0, 0.02))
        pgm_function430.set_cpd((4, 1), (0.3885, 0.59, 0.0015, 0.0, 0.0, 0.0, 0.02))
        pgm_function430.set_cpd((5, 1), (0.9362, 0.0438, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function430.set_cpd((6, 1),
                                (0.4929507, 0.37036296, 0.09059094, 0.02169783, 0.00389961, 0.00049995, 0.019998))
        pgm_function430.set_cpd((0, 2), (0.0, 0.0, 0.97369737, 0.00630063, 0.0, 0.0, 0.020002))
        pgm_function430.set_cpd((1, 2), (0.00070007, 0.94039404, 0.03890389, 0.0, 0.0, 0.0, 0.020002))
        pgm_function430.set_cpd((2, 2), (0.7833, 0.1966, 0.0001, 0.0, 0.0, 0.0, 0.02))
        pgm_function430.set_cpd((3, 2), (0.0, 9.999e-05, 0.97830217, 0.00159984, 0.0, 0.0, 0.019998))
        pgm_function430.set_cpd((4, 2), (0.0, 0.3781, 0.6016, 0.0003, 0.0, 0.0, 0.02))
        pgm_function430.set_cpd((5, 2), (0.01149885, 0.96530347, 0.00319968, 0.0, 0.0, 0.0, 0.019998))
        pgm_function430.set_cpd((6, 2),
                                (0.15051505, 0.39773977, 0.27152715, 0.11721172, 0.03610361, 0.00690069, 0.020002))
        pgm_function430.set_cpd((0, 3), (0.0, 0.0, 0.0082, 0.9646, 0.0072, 0.0, 0.02))
        pgm_function430.set_cpd((1, 3), (0.0, 0.0571, 0.8829, 0.04, 0.0, 0.0, 0.02))
        pgm_function430.set_cpd((2, 3), (0.0541, 0.9055, 0.0203, 0.0001, 0.0, 0.0, 0.02))
        pgm_function430.set_cpd((3, 3), (0.0, 0.0, 0.03260326, 0.94569457, 0.00170017, 0.0, 0.020002))
        pgm_function430.set_cpd((4, 3), (0.0, 0.0, 0.7931, 0.1868, 0.0001, 0.0, 0.02))
        pgm_function430.set_cpd((5, 3), (0.0, 0.439, 0.5362, 0.0048, 0.0, 0.0, 0.02))
        pgm_function430.set_cpd((6, 3), (0.0391, 0.2318, 0.3318, 0.2294, 0.1131, 0.0348, 0.02))
        pgm_function430.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0072, 0.9656, 0.0072, 0.02))
        pgm_function430.set_cpd((1, 4), (0.0, 0.0001, 0.3198, 0.6276, 0.0325, 0.0, 0.02))
        pgm_function430.set_cpd((2, 4), (0.0004, 0.4664, 0.4912, 0.0219, 0.0001, 0.0, 0.02))
        pgm_function430.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0287, 0.9496, 0.0017, 0.02))
        pgm_function430.set_cpd((4, 4), (0.0, 0.0, 0.0071, 0.7665, 0.2063, 0.0001, 0.02))
        pgm_function430.set_cpd((5, 4), (0.0, 0.00150015, 0.70187019, 0.27382738, 0.00280028, 0.0, 0.020002))
        pgm_function430.set_cpd((6, 4), (0.0065, 0.0866, 0.2598, 0.2877, 0.2273, 0.1121, 0.02))
        pgm_function430.set_cpd((0, 5), (0.0, 0.0, 0.0, 0.0, 0.0072, 0.9728, 0.02))
        pgm_function430.set_cpd((1, 5), (0.0, 0.0, 0.0034, 0.2908, 0.6521, 0.0337, 0.02))
        pgm_function430.set_cpd((2, 5), (0.0, 0.01269746, 0.62637473, 0.32423515, 0.01659668, 9.998e-05, 0.019996))
        pgm_function430.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0287, 0.9513, 0.02))
        pgm_function430.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0062, 0.7673, 0.2065, 0.02))
        pgm_function430.set_cpd((5, 5), (0.0, 0.0, 0.03839616, 0.64913509, 0.28947105, 0.0029997, 0.019998))
        pgm_function430.set_cpd((6, 5),
                                (0.00079984, 0.02239552, 0.14087183, 0.24985003, 0.31623675, 0.24985003, 0.019996))
        pgm_function430.set_cpd((0, 6), (0.1111, 0.2284, 0.2388, 0.1875, 0.1354, 0.0788, 0.02))
        pgm_function430.set_cpd((1, 6),
                                (0.24267573, 0.30486951, 0.20687931, 0.12458754, 0.06949305, 0.03149685, 0.019998))
        pgm_function430.set_cpd((2, 6), (0.4236, 0.3196, 0.1381, 0.0628, 0.0267, 0.0092, 0.02))
        pgm_function430.set_cpd((3, 6), (0.1227, 0.2392, 0.2382, 0.1813, 0.127, 0.0716, 0.02))
        pgm_function430.set_cpd((4, 6),
                                (0.17768223, 0.27767223, 0.22747725, 0.15348465, 0.09559044, 0.04809519, 0.019998))
        pgm_function430.set_cpd((5, 6), (0.2958, 0.3186, 0.1878, 0.1033, 0.0527, 0.0218, 0.02))
        pgm_function430.set_cpd((6, 6),
                                (0.21972197, 0.26492649, 0.20142014, 0.14061406, 0.09640964, 0.05690569, 0.020002))
        pgm_factor431 = self.new_factor(R_DIFFN_AXIL_BLOCK, DIFFN_M_SEV_PROX, DIFFN_PATHO)
        pgm_function431 = pgm_factor431.set_cpt()
        pgm_function431.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function431.set_cpd((1, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function431.set_cpd((2, 0), (0.6, 0.4, 0.0, 0.0, 0.0))
        pgm_function431.set_cpd((3, 0), (0.25, 0.5, 0.25, 0.0, 0.0))
        pgm_function431.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function431.set_cpd((1, 1), (0.0, 0.5, 0.5, 0.0, 0.0))
        pgm_function431.set_cpd((2, 1), (0.0, 0.5, 0.5, 0.0, 0.0))
        pgm_function431.set_cpd((3, 1), (0.0, 0.0, 0.4, 0.5, 0.1))
        pgm_function431.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function431.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function431.set_cpd((2, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function431.set_cpd((3, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function431.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function431.set_cpd((1, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function431.set_cpd((2, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function431.set_cpd((3, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function431.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function431.set_cpd((1, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function431.set_cpd((2, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function431.set_cpd((3, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor432 = self.new_factor(R_OTHER_AXIL_BLOCK)
        pgm_function432 = pgm_factor432.set_cpt()
        pgm_function432.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor433 = self.new_factor(R_AXIL_BLOCK_ED, R_DIFFN_AXIL_BLOCK, R_OTHER_AXIL_BLOCK)
        pgm_function433 = pgm_factor433.set_cpt()
        pgm_function433.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function433.set_cpd((1, 0), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function433.set_cpd((2, 0), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function433.set_cpd((3, 0), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function433.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function433.set_cpd((0, 1), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function433.set_cpd((1, 1), (0.0001, 0.498, 0.5019, 0.0, 0.0))
        pgm_function433.set_cpd((2, 1), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function433.set_cpd((3, 1), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function433.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function433.set_cpd((0, 2), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function433.set_cpd((1, 2), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function433.set_cpd((2, 2), (0.0, 0.0007, 0.4328, 0.5665, 0.0))
        pgm_function433.set_cpd((3, 2), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function433.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function433.set_cpd((0, 3), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function433.set_cpd((1, 3), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function433.set_cpd((2, 3), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function433.set_cpd((3, 3), (0.00030003, 0.00110011, 0.01250125, 0.98609861, 0.0))
        pgm_function433.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function433.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function433.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function433.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function433.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function433.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor434 = self.new_factor(R_LNLPC5_DELT_MALOSS, R_LNLPC5_AXIL_SEV, R_LNLPC5_AXIL_PATHO)
        pgm_function434 = pgm_factor434.set_cpt()
        pgm_function434.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function434.set_cpd((1, 0), (0.5, 0.5, 0.0, 0.0, 0.0))
        pgm_function434.set_cpd((2, 0), (0.0, 0.5, 0.5, 0.0, 0.0))
        pgm_function434.set_cpd((3, 0), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function434.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.1, 0.9))
        pgm_function434.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function434.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0, 0.0))
        pgm_function434.set_cpd((2, 1), (0.4, 0.3, 0.3, 0.0, 0.0))
        pgm_function434.set_cpd((3, 1), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function434.set_cpd((4, 1), (0.25, 0.25, 0.25, 0.25, 0.0))
        pgm_function434.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function434.set_cpd((1, 2), (0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function434.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function434.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function434.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function434.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function434.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function434.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function434.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function434.set_cpd((4, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function434.set_cpd((0, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function434.set_cpd((1, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function434.set_cpd((2, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function434.set_cpd((3, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function434.set_cpd((4, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_factor435 = self.new_factor(R_DIFFN_DELT_MALOSS, DIFFN_M_SEV_PROX, DIFFN_PATHO)
        pgm_function435 = pgm_factor435.set_cpt()
        pgm_function435.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function435.set_cpd((1, 0), (0.4, 0.6, 0.0, 0.0, 0.0))
        pgm_function435.set_cpd((2, 0), (0.0, 0.4, 0.6, 0.0, 0.0))
        pgm_function435.set_cpd((3, 0), (0.0, 0.0, 0.4, 0.6, 0.0))
        pgm_function435.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function435.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0, 0.0))
        pgm_function435.set_cpd((2, 1), (0.4, 0.3, 0.3, 0.0, 0.0))
        pgm_function435.set_cpd((3, 1), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function435.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function435.set_cpd((1, 2), (0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function435.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function435.set_cpd((3, 2), (0.0, 0.0, 0.0, 0.8, 0.2))
        pgm_function435.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function435.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function435.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function435.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function435.set_cpd((0, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function435.set_cpd((1, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function435.set_cpd((2, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function435.set_cpd((3, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_factor436 = self.new_factor(R_LNLPC5_DIFFN_DELT_MALOSS, R_LNLPC5_DELT_MALOSS, R_DIFFN_DELT_MALOSS)
        pgm_function436 = pgm_factor436.set_cpt()
        pgm_function436.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function436.set_cpd((1, 0), (0.0022, 0.9977, 0.0001, 0.0, 0.0))
        pgm_function436.set_cpd((2, 0), (0.00019998, 0.03689631, 0.95880412, 0.00409959, 0.0))
        pgm_function436.set_cpd((3, 0), (0.0, 0.0002, 0.0329, 0.9669, 0.0))
        pgm_function436.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function436.set_cpd((0, 1), (0.0022, 0.9977, 0.0001, 0.0, 0.0))
        pgm_function436.set_cpd((1, 1), (0.0, 0.0282, 0.9718, 0.0, 0.0))
        pgm_function436.set_cpd((2, 1), (0.0, 0.0009, 0.3409, 0.6582, 0.0))
        pgm_function436.set_cpd((3, 1), (0.0, 0.0, 0.0038, 0.9962, 0.0))
        pgm_function436.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function436.set_cpd((0, 2), (0.00019998, 0.03689631, 0.95880412, 0.00409959, 0.0))
        pgm_function436.set_cpd((1, 2), (0.0, 0.0009, 0.3409, 0.6582, 0.0))
        pgm_function436.set_cpd((2, 2), (0.0, 0.0, 0.01, 0.99, 0.0))
        pgm_function436.set_cpd((3, 2), (0.0, 0.0, 0.0011, 0.9989, 0.0))
        pgm_function436.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function436.set_cpd((0, 3), (0.0, 0.0002, 0.0329, 0.9669, 0.0))
        pgm_function436.set_cpd((1, 3), (0.0, 0.0, 0.0038, 0.9962, 0.0))
        pgm_function436.set_cpd((2, 3), (0.0, 0.0, 0.0011, 0.9989, 0.0))
        pgm_function436.set_cpd((3, 3), (0.0, 0.0, 0.0004, 0.9996, 0.0))
        pgm_function436.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function436.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function436.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function436.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function436.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function436.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor437 = self.new_factor(R_OTHER_DELT_MALOSS)
        pgm_function437 = pgm_factor437.set_cpt()
        pgm_function437.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor438 = self.new_factor(R_DELT_MALOSS, R_LNLPC5_DIFFN_DELT_MALOSS, R_OTHER_DELT_MALOSS)
        pgm_function438 = pgm_factor438.set_cpt()
        pgm_function438.set_cpd((0, 0), (0.98, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function438.set_cpd((1, 0), (0.00219978, 0.97770223, 9.999e-05, 0.0, 0.0, 0.019998))
        pgm_function438.set_cpd((2, 0), (0.0002, 0.0471, 0.9297, 0.003, 0.0, 0.02))
        pgm_function438.set_cpd((3, 0), (0.0, 0.0003, 0.0424, 0.9373, 0.0, 0.02))
        pgm_function438.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function438.set_cpd((0, 1), (0.00219978, 0.97770223, 9.999e-05, 0.0, 0.0, 0.019998))
        pgm_function438.set_cpd((1, 1), (0.0, 0.0361, 0.9439, 0.0, 0.0, 0.02))
        pgm_function438.set_cpd((2, 1), (0.0, 0.0014, 0.3987, 0.5799, 0.0, 0.02))
        pgm_function438.set_cpd((3, 1), (0.0, 0.0, 0.005, 0.975, 0.0, 0.02))
        pgm_function438.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function438.set_cpd((0, 2), (0.0002, 0.0471, 0.9297, 0.003, 0.0, 0.02))
        pgm_function438.set_cpd((1, 2), (0.0, 0.0014, 0.3987, 0.5799, 0.0, 0.02))
        pgm_function438.set_cpd((2, 2), (0.0, 0.0, 0.013, 0.967, 0.0, 0.02))
        pgm_function438.set_cpd((3, 2), (0.0, 0.0, 0.0014, 0.9786, 0.0, 0.02))
        pgm_function438.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function438.set_cpd((0, 3), (0.0, 0.0003, 0.0424, 0.9373, 0.0, 0.02))
        pgm_function438.set_cpd((1, 3), (0.0, 0.0, 0.005, 0.975, 0.0, 0.02))
        pgm_function438.set_cpd((2, 3), (0.0, 0.0, 0.0014, 0.9786, 0.0, 0.02))
        pgm_function438.set_cpd((3, 3), (0.0, 0.0, 0.0005, 0.9795, 0.0, 0.02))
        pgm_function438.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function438.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function438.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function438.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function438.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function438.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_factor439 = self.new_factor(R_DELT_MULOSS, R_AXIL_BLOCK_ED, R_DELT_MALOSS)
        pgm_function439 = pgm_factor439.set_cpt()
        pgm_function439.set_cpd((0, 0), (0.98, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function439.set_cpd((1, 0), (0.9746, 0.0054, 0.0, 0.0, 0.0, 0.02))
        pgm_function439.set_cpd((2, 0), (0.0664, 0.9136, 0.0, 0.0, 0.0, 0.02))
        pgm_function439.set_cpd((3, 0), (0.016, 0.1801, 0.7138, 0.0701, 0.0, 0.02))
        pgm_function439.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function439.set_cpd((0, 1), (0.0167, 0.9613, 0.002, 0.0, 0.0, 0.02))
        pgm_function439.set_cpd((1, 1), (0.00340034, 0.9529953, 0.02360236, 0.0, 0.0, 0.020002))
        pgm_function439.set_cpd((2, 1), (0.0002, 0.2725, 0.7073, 0.0, 0.0, 0.02))
        pgm_function439.set_cpd((3, 1), (0.0009, 0.0263, 0.4192, 0.5336, 0.0, 0.02))
        pgm_function439.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function439.set_cpd((0, 2), (0.00019998, 0.05349465, 0.92370763, 0.00259974, 0.0, 0.019998))
        pgm_function439.set_cpd((1, 2), (0.0, 0.02340234, 0.94509451, 0.01150115, 0.0, 0.020002))
        pgm_function439.set_cpd((2, 2), (0.0, 0.0048, 0.7523, 0.2229, 0.0, 0.02))
        pgm_function439.set_cpd((3, 2), (0.0, 0.00130013, 0.06370637, 0.9149915, 0.0, 0.020002))
        pgm_function439.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function439.set_cpd((0, 3), (0.0, 0.00030003, 0.04810481, 0.93159316, 0.0, 0.020002))
        pgm_function439.set_cpd((1, 3), (0.0, 0.00010001, 0.0270027, 0.95289529, 0.0, 0.020002))
        pgm_function439.set_cpd((2, 3), (0.0, 0.0, 0.0091, 0.9709, 0.0, 0.02))
        pgm_function439.set_cpd((3, 3), (0.0, 0.0001, 0.0087, 0.9712, 0.0, 0.02))
        pgm_function439.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function439.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function439.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function439.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function439.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function439.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function439.set_cpd((0, 5), (0.1427, 0.2958, 0.4254, 0.1161, 0.0, 0.02))
        pgm_function439.set_cpd((1, 5), (0.1157, 0.2677, 0.4444, 0.1522, 0.0, 0.02))
        pgm_function439.set_cpd((2, 5), (0.06939306, 0.20107989, 0.45265473, 0.25687431, 0.0, 0.019998))
        pgm_function439.set_cpd((3, 5), (0.0173, 0.0696, 0.2854, 0.6077, 0.0, 0.02))
        pgm_function439.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_factor440 = self.new_factor(R_DELT_ALLAMP, R_DELT_EFFMUS, R_DELT_MULOSS)
        pgm_function440 = pgm_factor440.set_cpt()
        pgm_function440.set_cpd((0, 0),
                                (0.00260026, 0.36873687, 0.60756076, 0.02080208, 0.00030003, 0.0, 0.0, 0.0, 0.0))
        pgm_function440.set_cpd((1, 0), (0.0, 0.0002, 0.4149, 0.4809, 0.0802, 0.0218, 0.002, 0.0, 0.0))
        pgm_function440.set_cpd((2, 0), (0.0, 0.0, 0.0, 0.0, 0.0215, 0.9785, 0.0, 0.0, 0.0))
        pgm_function440.set_cpd((3, 0), (0.0, 0.0, 0.0, 0.0, 0.0018, 0.0536, 0.8696, 0.075, 0.0))
        pgm_function440.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0736, 0.8528, 0.0736))
        pgm_function440.set_cpd((5, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.0794, 0.9205))
        pgm_function440.set_cpd((6, 0), (0.0003, 0.006, 0.105, 0.205, 0.1633, 0.141, 0.1771, 0.1279, 0.0744))
        pgm_function440.set_cpd((0, 1), (0.0409, 0.8924, 0.0661, 0.0006, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function440.set_cpd((1, 1), (0.0, 0.01, 0.77, 0.2049, 0.0128, 0.0022, 0.0001, 0.0, 0.0))
        pgm_function440.set_cpd((2, 1), (0.0, 0.0, 0.0, 0.2489, 0.7398, 0.0113, 0.0, 0.0, 0.0))
        pgm_function440.set_cpd((3, 1),
                                (0.0, 0.0, 0.0, 0.00420042, 0.34683468, 0.53485349, 0.11371137, 0.00040004, 0.0))
        pgm_function440.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 0.0064, 0.0855, 0.788, 0.1197, 0.0004))
        pgm_function440.set_cpd((5, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.00029997, 0.11648835, 0.76672333, 0.11648835))
        pgm_function440.set_cpd((6, 1), (
            0.00190019, 0.0230023, 0.190019, 0.26232623, 0.16291629, 0.12441244, 0.12641264, 0.0740074, 0.0350035))
        pgm_function440.set_cpd((0, 2), (0.2926, 0.7043, 0.0031, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function440.set_cpd((1, 2), (0.0091, 0.4203, 0.5312, 0.038, 0.0012, 0.0002, 0.0, 0.0, 0.0))
        pgm_function440.set_cpd((2, 2), (0.0, 0.0, 0.30946905, 0.68073193, 0.00949905, 0.00029997, 0.0, 0.0, 0.0))
        pgm_function440.set_cpd((3, 2), (0.0, 0.0, 0.018, 0.6298, 0.2744, 0.0746, 0.0032, 0.0, 0.0))
        pgm_function440.set_cpd((4, 2),
                                (0.0, 0.0, 0.00010001, 0.10461046, 0.42814281, 0.35683568, 0.10711071, 0.00320032, 0.0))
        pgm_function440.set_cpd((5, 2),
                                (0.0, 0.0, 0.0, 0.00250025, 0.09780978, 0.24982498, 0.53235324, 0.11411141, 0.00340034))
        pgm_function440.set_cpd((6, 2), (
            0.01440144, 0.09930993, 0.30283028, 0.27022702, 0.12431243, 0.08210821, 0.06520652, 0.03020302, 0.01140114))
        pgm_function440.set_cpd((0, 3), (0.781, 0.2189, 0.0001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function440.set_cpd((1, 3), (0.26692669, 0.71617162, 0.01660166, 0.00030003, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function440.set_cpd((2, 3), (9.999e-05, 0.10278972, 0.87921208, 0.01779822, 9.999e-05, 0.0, 0.0, 0.0, 0.0))
        pgm_function440.set_cpd((3, 3),
                                (0.0, 0.00440044, 0.81118112, 0.17621762, 0.00730073, 0.00090009, 0.0, 0.0, 0.0))
        pgm_function440.set_cpd((4, 3),
                                (0.0, 9.999e-05, 0.4129587, 0.49655034, 0.07189281, 0.01729827, 0.00119988, 0.0, 0.0))
        pgm_function440.set_cpd((5, 3),
                                (0.0, 0.0, 0.07810781, 0.51965197, 0.2610261, 0.11671167, 0.02340234, 0.00110011, 0.0))
        pgm_function440.set_cpd((6, 3), (0.1169, 0.3697, 0.2867, 0.1411, 0.0431, 0.0234, 0.0133, 0.0045, 0.0013))
        pgm_function440.set_cpd((0, 4), (0.9907, 0.0093, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function440.set_cpd((1, 4), (0.9858, 0.0142, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function440.set_cpd((2, 4), (0.9865, 0.0135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function440.set_cpd((3, 4), (0.982, 0.018, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function440.set_cpd((4, 4), (0.9779, 0.0221, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function440.set_cpd((5, 4), (0.973, 0.027, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function440.set_cpd((6, 4), (0.9370063, 0.06289371, 9.999e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function440.set_cpd((0, 5), (
            0.35956404, 0.51474853, 0.09409059, 0.0239976, 0.00459954, 0.0019998, 0.00079992, 0.00019998, 0.0))
        pgm_function440.set_cpd((1, 5), (
            0.13358664, 0.38546145, 0.26977302, 0.13078692, 0.04009599, 0.02189781, 0.01269873, 0.00439956, 0.00129987))
        pgm_function440.set_cpd((2, 5), (0.0096, 0.0788, 0.2992, 0.2816, 0.1319, 0.0873, 0.0689, 0.0313, 0.0114))
        pgm_function440.set_cpd((3, 5), (
            0.00260052, 0.02890578, 0.20404081, 0.26575315, 0.15943189, 0.11992398, 0.1190238, 0.06841368, 0.03190638))
        pgm_function440.set_cpd((4, 5), (
            0.00049995, 0.00839916, 0.11818818, 0.21387861, 0.1629837, 0.13818618, 0.16908309, 0.11988801, 0.06889311))
        pgm_function440.set_cpd((5, 5), (0.0001, 0.0021, 0.0586, 0.1473, 0.1427, 0.1363, 0.2057, 0.1798, 0.1274))
        pgm_function440.set_cpd((6, 5), (
            0.05210521, 0.16081608, 0.22722272, 0.20132013, 0.10661066, 0.07920792, 0.08310831, 0.05590559, 0.03370337))
        pgm_factor441 = self.new_factor(R_AXIL_AMP_E, R_DELT_ALLAMP)
        pgm_function441 = pgm_factor441.set_cpt()
        pgm_function441.set_cpd((0,),
                                (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function441.set_cpd((1,), (
            0.00020002, 0.21532153, 0.19871987, 0.17091709, 0.13691369, 0.10221022, 0.07110711, 0.0460046, 0.02780278,
            0.01560156, 0.00820082, 0.0040004, 0.00180018, 0.00080008, 0.00030003, 0.00010001, 0.0))
        pgm_function441.set_cpd((2,), (
            0.0, 0.0087, 0.0213, 0.0441, 0.0778, 0.1167, 0.1489, 0.1614, 0.1488, 0.1166, 0.0777, 0.044, 0.0212, 0.0087,
            0.003, 0.0009, 0.0002))
        pgm_function441.set_cpd((3,), (
            0.0, 0.0, 0.00019998, 0.00089991, 0.00349965, 0.01139886, 0.029997, 0.06419358, 0.11158884, 0.15778422,
            0.18128187, 0.16938306, 0.12878712, 0.07949205, 0.03989601, 0.01629837, 0.00529947))
        pgm_function441.set_cpd((4,), (
            0.0, 0.0, 0.0, 0.0, 0.0001, 0.0003, 0.0017, 0.0065, 0.0201, 0.0495, 0.0972, 0.1523, 0.1901, 0.1893, 0.1502,
            0.0951, 0.0476))
        pgm_function441.set_cpd((5,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00019996, 0.0009998, 0.00439912, 0.01539692, 0.04229154, 0.09138172,
            0.15406919,
            0.20355929, 0.21035793, 0.17016597, 0.10717856))
        pgm_function441.set_cpd((6,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.0006, 0.0028, 0.0102, 0.0296, 0.0699, 0.1345, 0.2102, 0.2668,
            0.2753))
        pgm_function441.set_cpd((7,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0003, 0.0014, 0.0061, 0.0219, 0.064, 0.152, 0.293, 0.4613))
        pgm_function441.set_cpd((8,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0002, 0.001, 0.0055, 0.0245, 0.0884, 0.2588, 0.6216))
        pgm_factor442 = self.new_factor(R_AXIL_RD_ED, R_LNLPC5_AXIL_PATHO)
        pgm_function442 = pgm_factor442.set_cpt()
        pgm_function442.set_cpd((0,), (1.0, 0.0, 0.0))
        pgm_function442.set_cpd((1,), (1.0, 0.0, 0.0))
        pgm_function442.set_cpd((2,), (1.0, 0.0, 0.0))
        pgm_function442.set_cpd((3,), (0.0, 0.0, 1.0))
        pgm_function442.set_cpd((4,), (0.0, 1.0, 0.0))
        pgm_factor443 = self.new_factor(R_LNLPC5_AXIL_DIFSLOW, R_LNLPC5_AXIL_PATHO)
        pgm_function443 = pgm_factor443.set_cpt()
        pgm_function443.set_cpd((0,), (1.0, 0.0, 0.0, 0.0))
        pgm_function443.set_cpd((1,), (1.0, 0.0, 0.0, 0.0))
        pgm_function443.set_cpd((2,), (1.0, 0.0, 0.0, 0.0))
        pgm_function443.set_cpd((3,), (0.0, 0.0, 0.0, 1.0))
        pgm_function443.set_cpd((4,), (0.0, 0.0, 1.0, 0.0))
        pgm_factor444 = self.new_factor(R_DIFFN_AXIL_DIFSLOW, DIFFN_M_SEV_PROX, DIFFN_PATHO)
        pgm_function444 = pgm_factor444.set_cpt()
        pgm_function444.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function444.set_cpd((1, 0), (0.0, 0.5, 0.5, 0.0))
        pgm_function444.set_cpd((2, 0), (0.0, 0.2, 0.6, 0.2))
        pgm_function444.set_cpd((3, 0), (0.0, 0.2, 0.6, 0.2))
        pgm_function444.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function444.set_cpd((1, 1), (0.4, 0.5, 0.1, 0.0))
        pgm_function444.set_cpd((2, 1), (0.2, 0.4, 0.3, 0.1))
        pgm_function444.set_cpd((3, 1), (0.2, 0.4, 0.3, 0.1))
        pgm_function444.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function444.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function444.set_cpd((2, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function444.set_cpd((3, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function444.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function444.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function444.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function444.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function444.set_cpd((0, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_function444.set_cpd((1, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_function444.set_cpd((2, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_function444.set_cpd((3, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_factor445 = self.new_factor(R_AXIL_DIFSLOW_ED, R_LNLPC5_AXIL_DIFSLOW, R_DIFFN_AXIL_DIFSLOW)
        pgm_function445 = pgm_factor445.set_cpt()
        pgm_function445.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function445.set_cpd((1, 0), (0.01319868, 0.98620138, 0.00059994, 0.0))
        pgm_function445.set_cpd((2, 0), (0.0, 0.01810181, 0.98189819, 0.0))
        pgm_function445.set_cpd((3, 0), (0.0, 0.0003, 0.0252, 0.9745))
        pgm_function445.set_cpd((0, 1), (0.01319868, 0.98620138, 0.00059994, 0.0))
        pgm_function445.set_cpd((1, 1), (0.0001, 0.0952, 0.9047, 0.0))
        pgm_function445.set_cpd((2, 1), (0.0, 0.0009, 0.588, 0.4111))
        pgm_function445.set_cpd((3, 1), (0.0, 0.0, 0.00440044, 0.99559956))
        pgm_function445.set_cpd((0, 2), (0.0, 0.01810181, 0.98189819, 0.0))
        pgm_function445.set_cpd((1, 2), (0.0, 0.0009, 0.588, 0.4111))
        pgm_function445.set_cpd((2, 2), (0.0, 0.0, 0.002, 0.998))
        pgm_function445.set_cpd((3, 2), (0.0, 0.0, 0.0006, 0.9994))
        pgm_function445.set_cpd((0, 3), (0.0, 0.0003, 0.0252, 0.9745))
        pgm_function445.set_cpd((1, 3), (0.0, 0.0, 0.00440044, 0.99559956))
        pgm_function445.set_cpd((2, 3), (0.0, 0.0, 0.0006, 0.9994))
        pgm_function445.set_cpd((3, 3), (0.0, 0.0, 0.0005, 0.9995))
        pgm_factor446 = self.new_factor(R_AXIL_DCV, R_DELT_MALOSS, R_AXIL_DIFSLOW_ED)
        pgm_function446 = pgm_factor446.set_cpt()
        pgm_function446.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function446.set_cpd((1, 0), (0.1136, 0.8864, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function446.set_cpd((2, 0), (0.0006, 0.0764, 0.8866, 0.0364, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function446.set_cpd((3, 0), (0.0, 0.0, 0.0655, 0.9299, 0.0046, 0.0, 0.0, 0.0, 0.0))
        pgm_function446.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function446.set_cpd((5, 0), (0.1523, 0.2904, 0.3678, 0.1726, 0.0169, 0.0, 0.0, 0.0, 0.0))
        pgm_function446.set_cpd((0, 1), (0.008, 0.168, 0.7407, 0.0833, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function446.set_cpd((1, 1),
                                (0.00089991, 0.03679632, 0.55764424, 0.40245975, 0.00219978, 0.0, 0.0, 0.0, 0.0))
        pgm_function446.set_cpd((2, 1),
                                (0.0, 0.00070007, 0.05250525, 0.57125713, 0.37523752, 0.00030003, 0.0, 0.0, 0.0))
        pgm_function446.set_cpd((3, 1), (0.0, 0.0, 0.0007, 0.0745, 0.8859, 0.0389, 0.0, 0.0, 0.0))
        pgm_function446.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function446.set_cpd((5, 1), (0.0168, 0.0618, 0.2223, 0.4015, 0.2803, 0.0172, 0.0001, 0.0, 0.0))
        pgm_function446.set_cpd((0, 2), (
            0.00069986, 0.00589882, 0.0614877, 0.30063987, 0.55258949, 0.07818436, 0.0004999, 0.0, 0.0))
        pgm_function446.set_cpd((1, 2), (0.0002, 0.0018, 0.0263, 0.1887, 0.5884, 0.1916, 0.003, 0.0, 0.0))
        pgm_function446.set_cpd((2, 2), (0.0, 0.0001, 0.0024, 0.0358, 0.316, 0.5741, 0.0716, 0.0, 0.0))
        pgm_function446.set_cpd((3, 2),
                                (0.0, 0.0, 9.999e-05, 0.00319968, 0.07809219, 0.59464054, 0.32356764, 0.00039996, 0.0))
        pgm_function446.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function446.set_cpd((5, 2), (
            0.0009999, 0.00469953, 0.0279972, 0.11838816, 0.36466353, 0.39226077, 0.09069093, 0.00029997, 0.0))
        pgm_function446.set_cpd((0, 3), (0.0001, 0.0003, 0.0018, 0.011, 0.067, 0.2945, 0.5047, 0.1206, 0.0))
        pgm_function446.set_cpd((1, 3), (
            0.0, 0.00010001, 0.00090009, 0.00590059, 0.04220422, 0.23562356, 0.52255226, 0.19271927, 0.0))
        pgm_function446.set_cpd((2, 3), (0.0, 0.0, 0.0001, 0.0012, 0.0121, 0.1131, 0.4415, 0.432, 0.0))
        pgm_function446.set_cpd((3, 3),
                                (0.0, 0.0, 0.0, 0.00020002, 0.00280028, 0.04390439, 0.29172917, 0.66136614, 0.0))
        pgm_function446.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function446.set_cpd((5, 3), (0.0, 0.0002, 0.0011, 0.0057, 0.0332, 0.1704, 0.4424, 0.347, 0.0))
        pgm_factor447 = self.new_factor(R_AXIL_DEL, R_AXIL_RD_ED, R_AXIL_DCV)
        pgm_function447 = pgm_factor447.set_cpt()
        pgm_function447.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function447.set_cpd((1, 0), (0.0002, 0.0003, 0.0006, 0.0027, 0.021, 0.2666, 0.7086, 0.0, 0.0))
        pgm_function447.set_cpd((2, 0), (0.0, 0.0001, 0.0001, 0.0004, 0.0021, 0.0232, 0.4307, 0.5434, 0.0))
        pgm_function447.set_cpd((0, 1), (0.6514, 0.3486, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function447.set_cpd((1, 1), (
            0.00010002, 0.00020004, 0.0005001, 0.00220044, 0.01780356, 0.24224845, 0.73694739, 0.0, 0.0))
        pgm_function447.set_cpd((2, 1),
                                (0.0, 0.0, 0.00010001, 0.00030003, 0.00180018, 0.0210021, 0.40864086, 0.56815682, 0.0))
        pgm_function447.set_cpd((0, 2), (0.0003, 0.9337, 0.066, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function447.set_cpd((1, 2), (0.0001, 0.0002, 0.0004, 0.0016, 0.0137, 0.2066, 0.7774, 0.0, 0.0))
        pgm_function447.set_cpd((2, 2), (0.0, 0.0, 0.0001, 0.0003, 0.0015, 0.0178, 0.3739, 0.6064, 0.0))
        pgm_function447.set_cpd((0, 3), (0.0, 0.00380038, 0.99619962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function447.set_cpd((1, 3), (0.0001, 0.0001, 0.0002, 0.0011, 0.0095, 0.165, 0.824, 0.0, 0.0))
        pgm_function447.set_cpd((2, 3),
                                (0.0, 0.0, 9.999e-05, 0.00019998, 0.00109989, 0.01419858, 0.32926707, 0.65513449, 0.0))
        pgm_function447.set_cpd((0, 4), (0.0, 0.0, 0.01060106, 0.98939894, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function447.set_cpd((1, 4),
                                (0.0, 0.0, 0.00010001, 0.00050005, 0.00540054, 0.11491149, 0.87908791, 0.0, 0.0))
        pgm_function447.set_cpd((2, 4),
                                (0.0, 0.0, 0.0, 0.00010002, 0.00070014, 0.00980196, 0.26615323, 0.72324465, 0.0))
        pgm_function447.set_cpd((0, 5), (0.0, 0.00020002, 0.00260026, 0.13561356, 0.86158616, 0.0, 0.0, 0.0, 0.0))
        pgm_function447.set_cpd((1, 5), (0.0, 0.0, 0.0, 0.0002, 0.002, 0.058, 0.9396, 0.0002, 0.0))
        pgm_function447.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.00030003, 0.00480048, 0.16971697, 0.82518252, 0.0))
        pgm_function447.set_cpd((0, 6), (0.0, 0.0, 0.0, 0.0005, 0.8212, 0.1783, 0.0, 0.0, 0.0))
        pgm_function447.set_cpd((1, 6), (0.0, 0.0, 0.0, 0.0, 0.0004, 0.0184, 0.9779, 0.0033, 0.0))
        pgm_function447.set_cpd((2, 6), (0.0, 0.0, 0.0, 0.0, 0.0001, 0.0014, 0.0771, 0.9214, 0.0))
        pgm_function447.set_cpd((0, 7), (0.0, 0.0, 0.0, 0.00040004, 0.01130113, 0.59805981, 0.39023902, 0.0, 0.0))
        pgm_function447.set_cpd((1, 7), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0021, 0.401, 0.5969, 0.0))
        pgm_function447.set_cpd((2, 7), (0.0, 0.0, 0.0, 0.0, 0.0, 0.00010001, 0.01440144, 0.98549855, 0.0))
        pgm_function447.set_cpd((0, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function447.set_cpd((1, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function447.set_cpd((2, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor448 = self.new_factor(R_AXIL_LAT_ED, R_AXIL_DEL)
        pgm_function448 = pgm_factor448.set_cpt()
        pgm_function448.set_cpd((0,), (
            0.00990099, 0.07150715, 0.23392339, 0.34723472, 0.29242924, 0.04410441, 0.00090009, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function448.set_cpd((1,), (
            0.0017, 0.0166, 0.0866, 0.233, 0.4051, 0.2314, 0.025, 0.0006, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function448.set_cpd((2,), (
            0.0001, 0.0017, 0.0169, 0.0882, 0.2965, 0.4557, 0.1322, 0.0087, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0))
        pgm_function448.set_cpd((3,), (
            0.0, 0.00010001, 0.00110011, 0.00810081, 0.04770477, 0.25392539, 0.41724172, 0.25392539, 0.01630163,
            0.00160016,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function448.set_cpd((4,), (
            0.0, 0.00019998, 0.00059994, 0.00189981, 0.00659934, 0.02749725, 0.0709929, 0.13578642, 0.27427257,
            0.30906909,
            0.13458654, 0.03829617, 0.00019998, 0.0, 0.0, 0.0, 0.0))
        pgm_function448.set_cpd((5,), (
            9.999e-05, 0.00019998, 0.00029997, 0.00059994, 0.00129987, 0.00359964, 0.00749925, 0.01419858, 0.04569543,
            0.08109189, 0.13678632, 0.27307269, 0.31566843, 0.10558944, 0.01359864, 0.00069993, 0.0))
        pgm_function448.set_cpd((6,), (
            9.999e-05, 0.00019998, 0.00029997, 0.00039996, 0.00059994, 0.00119988, 0.00179982, 0.00269973, 0.00679932,
            0.01129887, 0.01919808, 0.0459954, 0.13018698, 0.2159784, 0.27987201, 0.28337166, 0.0))
        pgm_function448.set_cpd((7,), (
            0.0009, 0.001, 0.0012, 0.0014, 0.0021, 0.0031, 0.0039, 0.0049, 0.0093, 0.0138, 0.0193, 0.0398, 0.0956,
            0.1618,
            0.2573, 0.3846, 0.0))
        pgm_function448.set_cpd((8,),
                                (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor449 = self.new_factor(R_DELT_VOL_ACT)
        pgm_function449 = pgm_factor449.set_cpt()
        pgm_function449.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor450 = self.new_factor(R_DELT_FORCE, R_DELT_VOL_ACT, R_DELT_ALLAMP)
        pgm_function450 = pgm_factor450.set_cpt()
        pgm_function450.set_cpd((0, 0), (0.0, 0.0, 0.0, 0.00409959, 0.19078092, 0.80511949))
        pgm_function450.set_cpd((1, 0), (0.0, 0.0, 0.0, 0.001, 0.0578, 0.9412))
        pgm_function450.set_cpd((2, 0), (0.0, 0.0, 0.0, 9.999e-05, 0.01259874, 0.98730127))
        pgm_function450.set_cpd((3, 0), (0.0, 0.0, 0.0, 0.0, 0.00590059, 0.99409941))
        pgm_function450.set_cpd((0, 1), (9.999e-05, 0.00429957, 0.05219478, 0.26687331, 0.43305669, 0.24347565))
        pgm_function450.set_cpd((1, 1), (0.0, 0.0005, 0.0084, 0.0849, 0.3219, 0.5843))
        pgm_function450.set_cpd((2, 1), (0.0, 0.0, 0.0007, 0.0167, 0.1576, 0.825))
        pgm_function450.set_cpd((3, 1), (0.0, 0.0, 0.0, 0.00260026, 0.05860586, 0.93879388))
        pgm_function450.set_cpd((0, 2), (0.01490149, 0.23542354, 0.53315332, 0.20152015, 0.01490149, 0.00010001))
        pgm_function450.set_cpd((1, 2), (0.0009, 0.0256, 0.18, 0.4308, 0.3036, 0.0591))
        pgm_function450.set_cpd((2, 2), (0.0, 0.0005, 0.0128, 0.1328, 0.4061, 0.4478))
        pgm_function450.set_cpd((3, 2), (0.0, 0.0, 0.0003, 0.0091, 0.1181, 0.8725))
        pgm_function450.set_cpd((0, 3), (0.1538, 0.6493, 0.1936, 0.0033, 0.0, 0.0))
        pgm_function450.set_cpd((1, 3), (0.0098, 0.1589, 0.4714, 0.3101, 0.0485, 0.0013))
        pgm_function450.set_cpd((2, 3), (0.0001, 0.0049, 0.0751, 0.3632, 0.429, 0.1277))
        pgm_function450.set_cpd((3, 3), (0.0, 0.0, 0.0008, 0.0215, 0.1873, 0.7904))
        pgm_function450.set_cpd((0, 4), (0.6667, 0.3291, 0.0042, 0.0, 0.0, 0.0))
        pgm_function450.set_cpd((1, 4), (0.05370537, 0.42044204, 0.45484548, 0.0690069, 0.0020002, 0.0))
        pgm_function450.set_cpd((2, 4), (0.00050005, 0.02730273, 0.24332433, 0.50135014, 0.21182118, 0.01570157))
        pgm_function450.set_cpd((3, 4), (0.0, 9.999e-05, 0.00249975, 0.04719528, 0.27557244, 0.67463254))
        pgm_function450.set_cpd((0, 5), (0.94689469, 0.05310531, 0.0, 0.0, 0.0, 0.0))
        pgm_function450.set_cpd((1, 5), (0.11731173, 0.56585659, 0.3010301, 0.01570157, 0.00010001, 0.0))
        pgm_function450.set_cpd((2, 5), (0.00120012, 0.06020602, 0.38623862, 0.45424542, 0.09540954, 0.00270027))
        pgm_function450.set_cpd((3, 5), (0.0, 0.0001, 0.0044, 0.0713, 0.3326, 0.5916))
        pgm_function450.set_cpd((0, 6), (0.9782, 0.0218, 0.0, 0.0, 0.0, 0.0))
        pgm_function450.set_cpd((1, 6), (0.41015898, 0.47935206, 0.1069893, 0.00349965, 0.0, 0.0))
        pgm_function450.set_cpd((2, 6), (0.02560256, 0.2470247, 0.48384838, 0.21742174, 0.02560256, 0.00050005))
        pgm_function450.set_cpd((3, 6), (0.0, 0.0020002, 0.02790279, 0.18121812, 0.41124112, 0.37763776))
        pgm_function450.set_cpd((0, 7), (0.9971, 0.0029, 0.0, 0.0, 0.0, 0.0))
        pgm_function450.set_cpd((1, 7), (0.7017, 0.2755, 0.0226, 0.0002, 0.0, 0.0))
        pgm_function450.set_cpd((2, 7), (0.1171, 0.4443, 0.3699, 0.0654, 0.0033, 0.0))
        pgm_function450.set_cpd((3, 7), (0.0004, 0.0107, 0.0847, 0.3035, 0.3988, 0.2019))
        pgm_function450.set_cpd((0, 8), (0.9996, 0.0004, 0.0, 0.0, 0.0, 0.0))
        pgm_function450.set_cpd((1, 8), (0.8804, 0.1161, 0.0035, 0.0, 0.0, 0.0))
        pgm_function450.set_cpd((2, 8), (0.32706729, 0.4879512, 0.17268273, 0.0119988, 0.00029997, 0.0))
        pgm_function450.set_cpd((3, 8), (0.0030003, 0.04260426, 0.19481948, 0.38493849, 0.29292929, 0.08170817))
        pgm_factor451 = self.new_factor(R_DELT_MUSCLE_VOL, R_DELT_MUSIZE, R_DELT_MALOSS)
        pgm_function451 = pgm_factor451.set_cpt()
        pgm_function451.set_cpd((0, 0), (0.9896, 0.0104))
        pgm_function451.set_cpd((1, 0), (0.8137, 0.1863))
        pgm_function451.set_cpd((2, 0), (0.0209, 0.9791))
        pgm_function451.set_cpd((3, 0), (0.0209, 0.9791))
        pgm_function451.set_cpd((4, 0), (0.003, 0.997))
        pgm_function451.set_cpd((5, 0), (0.0004, 0.9996))
        pgm_function451.set_cpd((6, 0), (0.4212, 0.5788))
        pgm_function451.set_cpd((0, 1), (0.9976, 0.0024))
        pgm_function451.set_cpd((1, 1), (0.9603, 0.0397))
        pgm_function451.set_cpd((2, 1), (0.5185, 0.4815))
        pgm_function451.set_cpd((3, 1), (0.1492, 0.8508))
        pgm_function451.set_cpd((4, 1), (0.0278, 0.9722))
        pgm_function451.set_cpd((5, 1), (0.0046, 0.9954))
        pgm_function451.set_cpd((6, 1), (0.5185, 0.4815))
        pgm_function451.set_cpd((0, 2), (0.999, 0.001))
        pgm_function451.set_cpd((1, 2), (0.9893, 0.0107))
        pgm_function451.set_cpd((2, 2), (0.9588, 0.0412))
        pgm_function451.set_cpd((3, 2), (0.6221, 0.3779))
        pgm_function451.set_cpd((4, 2), (0.2716, 0.7284))
        pgm_function451.set_cpd((5, 2), (0.0779, 0.9221))
        pgm_function451.set_cpd((6, 2), (0.6336, 0.3664))
        pgm_function451.set_cpd((0, 3), (0.9995, 0.0005))
        pgm_function451.set_cpd((1, 3), (0.9969, 0.0031))
        pgm_function451.set_cpd((2, 3), (0.9953, 0.0047))
        pgm_function451.set_cpd((3, 3), (0.9358, 0.0642))
        pgm_function451.set_cpd((4, 3), (0.8234, 0.1766))
        pgm_function451.set_cpd((5, 3), (0.5986, 0.4014))
        pgm_function451.set_cpd((6, 3), (0.7685, 0.2315))
        pgm_function451.set_cpd((0, 4), (0.9989, 0.0011))
        pgm_function451.set_cpd((1, 4), (0.9984, 0.0016))
        pgm_function451.set_cpd((2, 4), (0.9984, 0.0016))
        pgm_function451.set_cpd((3, 4), (0.9972, 0.0028))
        pgm_function451.set_cpd((4, 4), (0.9965, 0.0035))
        pgm_function451.set_cpd((5, 4), (0.9956, 0.0044))
        pgm_function451.set_cpd((6, 4), (0.9857, 0.0143))
        pgm_function451.set_cpd((0, 5), (0.9363, 0.0637))
        pgm_function451.set_cpd((1, 5), (0.8403, 0.1597))
        pgm_function451.set_cpd((2, 5), (0.6534, 0.3466))
        pgm_function451.set_cpd((3, 5), (0.4719, 0.5281))
        pgm_function451.set_cpd((4, 5), (0.3174, 0.6826))
        pgm_function451.set_cpd((5, 5), (0.1948, 0.8052))
        pgm_function451.set_cpd((6, 5), (0.5681, 0.4319))
        pgm_factor452 = self.new_factor(R_DELT_MVA_RECRUIT, R_DELT_MULOSS, R_DELT_VOL_ACT)
        pgm_function452 = pgm_factor452.set_cpt()
        pgm_function452.set_cpd((0, 0), (0.9295, 0.0705, 0.0, 0.0))
        pgm_function452.set_cpd((1, 0), (0.4821, 0.5165, 0.0014, 0.0))
        pgm_function452.set_cpd((2, 0), (0.0661, 0.7993, 0.1346, 0.0))
        pgm_function452.set_cpd((3, 0), (0.00149985, 0.13658634, 0.86191381, 0.0))
        pgm_function452.set_cpd((4, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function452.set_cpd((5, 0), (0.2639736, 0.4343566, 0.3016698, 0.0))
        pgm_function452.set_cpd((0, 1), (0.1707, 0.7, 0.1293, 0.0))
        pgm_function452.set_cpd((1, 1), (0.0366, 0.5168, 0.4466, 0.0))
        pgm_function452.set_cpd((2, 1), (0.0043, 0.1788, 0.8169, 0.0))
        pgm_function452.set_cpd((3, 1), (0.00029997, 0.03479652, 0.96490351, 0.0))
        pgm_function452.set_cpd((4, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function452.set_cpd((5, 1), (0.1146, 0.3465, 0.5389, 0.0))
        pgm_function452.set_cpd((0, 2), (0.0038, 0.174, 0.8222, 0.0))
        pgm_function452.set_cpd((1, 2), (0.0005, 0.0594, 0.9401, 0.0))
        pgm_function452.set_cpd((2, 2), (0.0001, 0.0205, 0.9794, 0.0))
        pgm_function452.set_cpd((3, 2), (0.0, 0.0061, 0.9939, 0.0))
        pgm_function452.set_cpd((4, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function452.set_cpd((5, 2), (0.036, 0.2144, 0.7496, 0.0))
        pgm_function452.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function452.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function452.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function452.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function452.set_cpd((4, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function452.set_cpd((5, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor453 = self.new_factor(R_DELT_MVA_AMP, R_DELT_EFFMUS)
        pgm_function453 = pgm_factor453.set_cpt()
        pgm_function453.set_cpd((0,), (0.0, 0.04, 0.96))
        pgm_function453.set_cpd((1,), (0.01, 0.15, 0.84))
        pgm_function453.set_cpd((2,), (0.05, 0.9, 0.05))
        pgm_function453.set_cpd((3,), (0.5, 0.49, 0.01))
        pgm_function453.set_cpd((4,), (0.85, 0.15, 0.0))
        pgm_function453.set_cpd((5,), (0.96, 0.04, 0.0))
        pgm_function453.set_cpd((6,), (0.33, 0.34, 0.33))
        pgm_factor454 = self.new_factor(R_DELT_TA_CONCL, R_DELT_EFFMUS)
        pgm_function454 = pgm_factor454.set_cpt()
        pgm_function454.set_cpd((0,), (0.0, 0.0, 0.005, 0.045, 0.95))
        pgm_function454.set_cpd((1,), (0.0, 0.0, 0.05, 0.9, 0.05))
        pgm_function454.set_cpd((2,), (0.0, 0.03, 0.94, 0.03, 0.0))
        pgm_function454.set_cpd((3,), (0.195, 0.6, 0.2, 0.005, 0.0))
        pgm_function454.set_cpd((4,), (0.48, 0.5, 0.02, 0.0, 0.0))
        pgm_function454.set_cpd((5,), (0.8, 0.195, 0.005, 0.0, 0.0))
        pgm_function454.set_cpd((6,), (0.2, 0.2, 0.2, 0.2, 0.2))
        pgm_factor455 = self.new_factor(R_DELT_MUPAMP, R_DELT_EFFMUS)
        pgm_function455 = pgm_factor455.set_cpt()
        pgm_function455.set_cpd((0,), (0.782, 0.195, 0.003, 0.0, 0.0, 0.0, 0.02))
        pgm_function455.set_cpd((1,), (0.10431043, 0.77107711, 0.10431043, 0.00030003, 0.0, 0.0, 0.020002))
        pgm_function455.set_cpd((2,), (0.0, 0.0, 0.98, 0.0, 0.0, 0.0, 0.02))
        pgm_function455.set_cpd((3,), (0.0, 0.00029997, 0.10108989, 0.74712529, 0.13148685, 0.0, 0.019998))
        pgm_function455.set_cpd((4,), (0.0, 0.0, 0.0024, 0.1528, 0.7968, 0.028, 0.02))
        pgm_function455.set_cpd((5,), (0.0, 0.0, 0.0, 0.0028, 0.0968, 0.8804, 0.02))
        pgm_function455.set_cpd((6,), (0.1328, 0.1932, 0.2189, 0.1932, 0.1726, 0.0693, 0.02))
        pgm_factor456 = self.new_factor(R_DELT_QUAN_MUPAMP, R_DELT_MUPAMP)
        pgm_function456 = pgm_factor456.set_cpt()
        pgm_function456.set_cpd((0,), (
            0.04180418, 0.08970897, 0.15021502, 0.19571957, 0.19871987, 0.15711571, 0.09670967, 0.04640464, 0.01730173,
            0.0050005, 0.00110011, 0.00020002, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function456.set_cpd((1,), (
            0.00420042, 0.01480148, 0.0410041, 0.0880088, 0.14731473, 0.1920192, 0.19491949, 0.15411541, 0.09490949,
            0.04550455, 0.0170017, 0.00490049, 0.00110011, 0.00020002, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function456.set_cpd((2,), (
            0.0, 0.0001, 0.0006, 0.0043, 0.021, 0.0693, 0.155, 0.2345, 0.2401, 0.1663, 0.0779, 0.0247, 0.0053, 0.0008,
            0.0001, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function456.set_cpd((3,), (
            0.0, 0.0, 0.00020002, 0.00090009, 0.00420042, 0.01480148, 0.04090409, 0.08790879, 0.14721472, 0.19181918,
            0.19471947, 0.15391539, 0.09480948, 0.04540454, 0.0170017, 0.00490049, 0.00110011, 0.00020002, 0.0, 0.0))
        pgm_function456.set_cpd((4,), (
            0.0, 0.0, 0.0, 0.0, 0.00020002, 0.00090009, 0.00420042, 0.01480148, 0.04090409, 0.08790879, 0.14721472,
            0.19181918, 0.19471947, 0.15391539, 0.09480948, 0.04540454, 0.0170017, 0.00490049, 0.00110011, 0.00020002))
        pgm_function456.set_cpd((5,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.0005, 0.0021, 0.007, 0.0196, 0.0451, 0.0853, 0.1326, 0.1696, 0.1784,
            0.1544, 0.1099, 0.0644, 0.031))
        pgm_function456.set_cpd((6,), (
            0.02049795, 0.029997, 0.04159584, 0.05469453, 0.06809319, 0.08029197, 0.08969103, 0.0949905, 0.09529047,
            0.09059094, 0.08159184, 0.06959304, 0.05629437, 0.04319568, 0.03129687, 0.02159784, 0.01409859, 0.00869913,
            0.00509949, 0.00279972))
        pgm_factor457 = self.new_factor(R_DELT_QUAL_MUPAMP, R_DELT_MUPAMP)
        pgm_function457 = pgm_factor457.set_cpt()
        pgm_function457.set_cpd((0,), (0.4289, 0.5209, 0.0499, 0.0003, 0.0))
        pgm_function457.set_cpd((1,), (0.0647, 0.5494, 0.3679, 0.018, 0.0))
        pgm_function457.set_cpd((2,), (0.0, 0.04790479, 0.87538754, 0.07670767, 0.0))
        pgm_function457.set_cpd((3,), (0.0, 0.00869913, 0.28377162, 0.67793221, 0.02959704))
        pgm_function457.set_cpd((4,), (0.0, 0.0002, 0.0376, 0.6283, 0.3339))
        pgm_function457.set_cpd((5,), (0.0, 0.0, 0.001, 0.0788, 0.9202))
        pgm_function457.set_cpd((6,), (0.096, 0.1884, 0.283, 0.3014, 0.1312))
        pgm_factor458 = self.new_factor(R_DELT_MUPDUR, R_DELT_EFFMUS)
        pgm_function458 = pgm_factor458.set_cpt()
        pgm_function458.set_cpd((0,), (0.9388, 0.0412, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function458.set_cpd((1,), (0.0396, 0.9008, 0.0396, 0.0, 0.0, 0.0, 0.02))
        pgm_function458.set_cpd((2,), (0.0, 0.0, 0.98, 0.0, 0.0, 0.0, 0.02))
        pgm_function458.set_cpd((3,), (0.0, 0.0, 0.0396, 0.9008, 0.0396, 0.0, 0.02))
        pgm_function458.set_cpd((4,), (0.0, 0.0, 0.0, 0.0412, 0.938, 0.0008, 0.02))
        pgm_function458.set_cpd((5,), (0.0, 0.0, 0.0, 0.0039, 0.2546, 0.7215, 0.02))
        pgm_function458.set_cpd((6,), (0.09, 0.235, 0.3236, 0.235, 0.09, 0.0064, 0.02))
        pgm_factor459 = self.new_factor(R_DELT_QUAN_MUPDUR, R_DELT_MUPDUR)
        pgm_function459 = pgm_factor459.set_cpt()
        pgm_function459.set_cpd((0,), (
            0.01020102, 0.03690369, 0.09510951, 0.17471747, 0.22892289, 0.2140214, 0.14261426, 0.06780678, 0.0230023,
            0.00560056, 0.0010001, 0.00010001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function459.set_cpd((1,), (
            0.00029997, 0.0019998, 0.01019898, 0.03679632, 0.09489051, 0.17428257, 0.22837716, 0.21347865, 0.14228577,
            0.06769323, 0.0229977, 0.00559944, 0.0009999, 9.999e-05, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function459.set_cpd((2,), (
            0.0, 0.0, 0.0, 0.0002, 0.0025, 0.0177, 0.0739, 0.1852, 0.2785, 0.2515, 0.1363, 0.0444, 0.0087, 0.001,
            0.0001,
            0.0, 0.0, 0.0, 0.0))
        pgm_function459.set_cpd((3,), (
            0.0, 0.0, 0.0, 0.0, 0.00029997, 0.0019998, 0.01019898, 0.03679632, 0.09489051, 0.17428257, 0.22837716,
            0.21347865, 0.14228577, 0.06769323, 0.0229977, 0.00559944, 0.0009999, 9.999e-05, 0.0))
        pgm_function459.set_cpd((4,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00029994, 0.0019996, 0.01019796, 0.03689262, 0.094981, 0.17446511,
            0.22855429,
            0.21365727, 0.14247151, 0.06778644, 0.0229954, 0.00559888, 9.998e-05))
        pgm_function459.set_cpd((5,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00010001, 0.00040004, 0.00180018, 0.00730073, 0.02290229, 0.05640564,
            0.10971097, 0.16831683, 0.20352035, 0.19411941, 0.14591459, 0.08950895))
        pgm_function459.set_cpd((6,), (
            0.00520104, 0.01070214, 0.01980396, 0.03360672, 0.05211042, 0.07371474, 0.09511902, 0.11212242, 0.12062412,
            0.11842368, 0.10622124, 0.08681736, 0.06491298, 0.04420884, 0.0275055, 0.01560312, 0.00810162, 0.00380076,
            0.00140028))
        pgm_factor460 = self.new_factor(R_DELT_QUAL_MUPDUR, R_DELT_MUPDUR)
        pgm_function460 = pgm_factor460.set_cpt()
        pgm_function460.set_cpd((0,), (0.8309, 0.1677, 0.0014))
        pgm_function460.set_cpd((1,), (0.49, 0.49, 0.02))
        pgm_function460.set_cpd((2,), (0.1065, 0.787, 0.1065))
        pgm_function460.set_cpd((3,), (0.02, 0.49, 0.49))
        pgm_function460.set_cpd((4,), (0.0014, 0.1677, 0.8309))
        pgm_function460.set_cpd((5,), (0.0001, 0.0392, 0.9607))
        pgm_function460.set_cpd((6,), (0.2597, 0.4806, 0.2597))
        pgm_factor461 = self.new_factor(R_DELT_QUAN_MUPPOLY, R_DELT_DE_REGEN, R_DELT_EFFMUS)
        pgm_function461 = pgm_factor461.set_cpt()
        pgm_function461.set_cpd((0, 0), (0.109, 0.548, 0.343))
        pgm_function461.set_cpd((1, 0), (0.004, 0.122, 0.874))
        pgm_function461.set_cpd((0, 1), (0.34, 0.564, 0.096))
        pgm_function461.set_cpd((1, 1), (0.015, 0.261, 0.724))
        pgm_function461.set_cpd((0, 2), (0.925, 0.075, 0.0))
        pgm_function461.set_cpd((1, 2), (0.091, 0.526, 0.383))
        pgm_function461.set_cpd((0, 3), (0.796, 0.201, 0.003))
        pgm_function461.set_cpd((1, 3), (0.061, 0.465, 0.474))
        pgm_function461.set_cpd((0, 4), (0.637, 0.348, 0.015))
        pgm_function461.set_cpd((1, 4), (0.039, 0.396, 0.565))
        pgm_function461.set_cpd((0, 5), (0.34, 0.564, 0.096))
        pgm_function461.set_cpd((1, 5), (0.015, 0.261, 0.724))
        pgm_function461.set_cpd((0, 6), (0.34, 0.564, 0.096))
        pgm_function461.set_cpd((1, 6), (0.015, 0.261, 0.724))
        pgm_factor462 = self.new_factor(R_DELT_QUAL_MUPPOLY, R_DELT_QUAN_MUPPOLY)
        pgm_function462 = pgm_factor462.set_cpt()
        pgm_function462.set_cpd((0,), (0.95, 0.05))
        pgm_function462.set_cpd((1,), (0.3, 0.7))
        pgm_function462.set_cpd((2,), (0.05, 0.95))
        pgm_factor463 = self.new_factor(R_DELT_MUPSATEL, R_DELT_DE_REGEN)
        pgm_function463 = pgm_factor463.set_cpt()
        pgm_function463.set_cpd((0,), (0.95, 0.05))
        pgm_function463.set_cpd((1,), (0.2, 0.8))
        pgm_factor464 = self.new_factor(R_DELT_MUPINSTAB, R_DELT_NMT)
        pgm_function464 = pgm_factor464.set_cpt()
        pgm_function464.set_cpd((0,), (0.95, 0.05))
        pgm_function464.set_cpd((1,), (0.1, 0.9))
        pgm_function464.set_cpd((2,), (0.03, 0.97))
        pgm_function464.set_cpd((3,), (0.2, 0.8))
        pgm_function464.set_cpd((4,), (0.1, 0.9))
        pgm_function464.set_cpd((5,), (0.03, 0.97))
        pgm_function464.set_cpd((6,), (0.1, 0.9))
        pgm_factor465 = self.new_factor(R_DELT_REPSTIM_CMAPAMP, R_DELT_ALLAMP)
        pgm_function465 = pgm_factor465.set_cpt()
        pgm_function465.set_cpd((0,), (
            1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function465.set_cpd((1,), (
            0.0008, 0.0838, 0.0981, 0.1087, 0.114, 0.1131, 0.1062, 0.0944, 0.0794, 0.0632, 0.0476, 0.034, 0.0229,
            0.0146,
            0.0089, 0.0051, 0.0027, 0.0014, 0.0007, 0.0003, 0.0001))
        pgm_function465.set_cpd((2,), (
            0.0, 0.00029994, 0.0009998, 0.00279944, 0.0069986, 0.01539692, 0.03019396, 0.05238952, 0.08058388,
            0.10937812,
            0.13147371, 0.13967207, 0.13137373, 0.10927814, 0.0804839, 0.05238952, 0.03019396, 0.01539692, 0.00689862,
            0.00279944, 0.0009998))
        pgm_function465.set_cpd((3,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.00020004, 0.00070014, 0.0025005, 0.00730146, 0.01840368, 0.03930786, 0.07141428,
            0.11012202, 0.14452891, 0.16123225, 0.15283057, 0.12322464, 0.08441688, 0.04920984, 0.02440488, 0.01020204))
        pgm_function465.set_cpd((4,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.999e-05, 0.00059994, 0.00239976, 0.00839916, 0.02349765,
            0.05359464,
            0.09919008, 0.14958504, 0.18328167, 0.18258174, 0.14778522, 0.09729027, 0.05169483))
        pgm_function465.set_cpd((5,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00019996, 0.0009998, 0.00439912, 0.01539692, 0.04229154,
            0.09138172, 0.15406919, 0.20355929, 0.21035793, 0.17016597, 0.10717856))
        pgm_function465.set_cpd((6,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0003, 0.0012, 0.0045, 0.0139, 0.0361, 0.0776,
            0.1391,
            0.2072, 0.2564, 0.2637))
        pgm_function465.set_cpd((7,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.0005, 0.0024, 0.0092, 0.0286, 0.0745,
            0.1612, 0.2895, 0.434))
        pgm_function465.set_cpd((8,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.0003, 0.0019, 0.0086, 0.0327,
            0.1028,
            0.268, 0.5856))
        pgm_factor466 = self.new_factor(R_DELT_REPSTIM_DECR, R_DELT_NMT)
        pgm_function466 = pgm_factor466.set_cpt()
        pgm_function466.set_cpd((0,), (0.949, 0.02, 0.01, 0.001, 0.02))
        pgm_function466.set_cpd((1,), (0.04, 0.2, 0.7, 0.04, 0.02))
        pgm_function466.set_cpd((2,), (0.001, 0.01, 0.04, 0.929, 0.02))
        pgm_function466.set_cpd((3,), (0.35, 0.57, 0.05, 0.01, 0.02))
        pgm_function466.set_cpd((4,), (0.02, 0.1, 0.8, 0.06, 0.02))
        pgm_function466.set_cpd((5,), (0.001, 0.01, 0.04, 0.929, 0.02))
        pgm_function466.set_cpd((6,), (0.245, 0.245, 0.245, 0.245, 0.02))
        pgm_factor467 = self.new_factor(R_DELT_REPSTIM_FACILI, R_DELT_NMT)
        pgm_function467 = pgm_factor467.set_cpt()
        pgm_function467.set_cpd((0,), (0.95, 0.02, 0.01, 0.02))
        pgm_function467.set_cpd((1,), (0.01, 0.889, 0.1, 0.001))
        pgm_function467.set_cpd((2,), (0.01, 0.08, 0.909, 0.001))
        pgm_function467.set_cpd((3,), (0.89, 0.08, 0.01, 0.02))
        pgm_function467.set_cpd((4,), (0.48, 0.5, 0.01, 0.01))
        pgm_function467.set_cpd((5,), (0.02, 0.949, 0.03, 0.001))
        pgm_function467.set_cpd((6,), (0.25, 0.25, 0.25, 0.25))
        pgm_factor468 = self.new_factor(R_DELT_REPSTIM_POST_DECR, R_DELT_NMT)
        pgm_function468 = pgm_factor468.set_cpt()
        pgm_function468.set_cpd((0,), (0.949, 0.02, 0.01, 0.001, 0.02))
        pgm_function468.set_cpd((1,), (0.02, 0.1, 0.8, 0.06, 0.02))
        pgm_function468.set_cpd((2,), (0.001, 0.01, 0.02, 0.949, 0.02))
        pgm_function468.set_cpd((3,), (0.25, 0.61, 0.1, 0.02, 0.02))
        pgm_function468.set_cpd((4,), (0.01, 0.1, 0.8, 0.07, 0.02))
        pgm_function468.set_cpd((5,), (0.001, 0.01, 0.02, 0.949, 0.02))
        pgm_function468.set_cpd((6,), (0.23, 0.23, 0.22, 0.22, 0.1))
        pgm_factor469 = self.new_factor(R_DELT_SF_JITTER, R_DELT_NMT)
        pgm_function469 = pgm_factor469.set_cpt()
        pgm_function469.set_cpd((0,), (0.95, 0.05, 0.0, 0.0))
        pgm_function469.set_cpd((1,), (0.02, 0.2, 0.7, 0.08))
        pgm_function469.set_cpd((2,), (0.0, 0.1, 0.4, 0.5))
        pgm_function469.set_cpd((3,), (0.05, 0.7, 0.2, 0.05))
        pgm_function469.set_cpd((4,), (0.01, 0.19, 0.7, 0.1))
        pgm_function469.set_cpd((5,), (0.0, 0.1, 0.4, 0.5))
        pgm_function469.set_cpd((6,), (0.1, 0.3, 0.3, 0.3))
        pgm_factor470 = self.new_factor(R_LNLPC5_DELT_MUDENS, R_LNLPC5_AXIL_SEV, R_LNLPC5_AXIL_TIME,
                                        R_LNLPC5_AXIL_PATHO)
        pgm_function470 = pgm_factor470.set_cpt()
        pgm_function470.set_cpd((0, 0, 0), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((1, 0, 0), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((2, 0, 0), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((3, 0, 0), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((4, 0, 0), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((0, 1, 0), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((1, 1, 0), (0.9, 0.1, 0.0))
        pgm_function470.set_cpd((2, 1, 0), (0.8, 0.2, 0.0))
        pgm_function470.set_cpd((3, 1, 0), (0.6, 0.4, 0.0))
        pgm_function470.set_cpd((4, 1, 0), (0.6, 0.4, 0.0))
        pgm_function470.set_cpd((0, 2, 0), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((1, 2, 0), (0.8, 0.2, 0.0))
        pgm_function470.set_cpd((2, 2, 0), (0.7, 0.3, 0.0))
        pgm_function470.set_cpd((3, 2, 0), (0.6, 0.4, 0.0))
        pgm_function470.set_cpd((4, 2, 0), (0.6, 0.4, 0.0))
        pgm_function470.set_cpd((0, 3, 0), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((1, 3, 0), (0.8, 0.2, 0.0))
        pgm_function470.set_cpd((2, 3, 0), (0.7, 0.3, 0.0))
        pgm_function470.set_cpd((3, 3, 0), (0.6, 0.4, 0.0))
        pgm_function470.set_cpd((4, 3, 0), (0.6, 0.4, 0.0))
        pgm_function470.set_cpd((0, 0, 1), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((1, 0, 1), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((2, 0, 1), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((3, 0, 1), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((4, 0, 1), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((0, 1, 1), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((1, 1, 1), (0.9, 0.1, 0.0))
        pgm_function470.set_cpd((2, 1, 1), (0.8, 0.2, 0.0))
        pgm_function470.set_cpd((3, 1, 1), (0.6, 0.4, 0.0))
        pgm_function470.set_cpd((4, 1, 1), (0.6, 0.4, 0.0))
        pgm_function470.set_cpd((0, 2, 1), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((1, 2, 1), (0.8, 0.2, 0.0))
        pgm_function470.set_cpd((2, 2, 1), (0.7, 0.3, 0.0))
        pgm_function470.set_cpd((3, 2, 1), (0.6, 0.4, 0.0))
        pgm_function470.set_cpd((4, 2, 1), (0.6, 0.4, 0.0))
        pgm_function470.set_cpd((0, 3, 1), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((1, 3, 1), (0.8, 0.2, 0.0))
        pgm_function470.set_cpd((2, 3, 1), (0.7, 0.3, 0.0))
        pgm_function470.set_cpd((3, 3, 1), (0.6, 0.4, 0.0))
        pgm_function470.set_cpd((4, 3, 1), (0.6, 0.4, 0.0))
        pgm_function470.set_cpd((0, 0, 2), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((1, 0, 2), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((2, 0, 2), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((3, 0, 2), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((4, 0, 2), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((0, 1, 2), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((1, 1, 2), (0.6, 0.4, 0.0))
        pgm_function470.set_cpd((2, 1, 2), (0.5, 0.5, 0.0))
        pgm_function470.set_cpd((3, 1, 2), (0.5, 0.4, 0.1))
        pgm_function470.set_cpd((4, 1, 2), (0.3, 0.6, 0.1))
        pgm_function470.set_cpd((0, 2, 2), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((1, 2, 2), (0.7, 0.3, 0.0))
        pgm_function470.set_cpd((2, 2, 2), (0.1, 0.6, 0.3))
        pgm_function470.set_cpd((3, 2, 2), (0.0, 0.5, 0.5))
        pgm_function470.set_cpd((4, 2, 2), (0.0, 0.5, 0.5))
        pgm_function470.set_cpd((0, 3, 2), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((1, 3, 2), (0.5, 0.5, 0.0))
        pgm_function470.set_cpd((2, 3, 2), (0.15, 0.7, 0.15))
        pgm_function470.set_cpd((3, 3, 2), (0.0, 0.5, 0.5))
        pgm_function470.set_cpd((4, 3, 2), (0.0, 0.5, 0.5))
        pgm_function470.set_cpd((0, 0, 3), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((1, 0, 3), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((2, 0, 3), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((3, 0, 3), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((4, 0, 3), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((0, 1, 3), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((1, 1, 3), (0.05, 0.5, 0.45))
        pgm_function470.set_cpd((2, 1, 3), (0.05, 0.5, 0.45))
        pgm_function470.set_cpd((3, 1, 3), (0.05, 0.5, 0.45))
        pgm_function470.set_cpd((4, 1, 3), (0.05, 0.5, 0.45))
        pgm_function470.set_cpd((0, 2, 3), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((1, 2, 3), (0.05, 0.5, 0.45))
        pgm_function470.set_cpd((2, 2, 3), (0.05, 0.5, 0.45))
        pgm_function470.set_cpd((3, 2, 3), (0.05, 0.5, 0.45))
        pgm_function470.set_cpd((4, 2, 3), (0.05, 0.5, 0.45))
        pgm_function470.set_cpd((0, 3, 3), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((1, 3, 3), (0.05, 0.5, 0.45))
        pgm_function470.set_cpd((2, 3, 3), (0.05, 0.5, 0.45))
        pgm_function470.set_cpd((3, 3, 3), (0.05, 0.5, 0.45))
        pgm_function470.set_cpd((4, 3, 3), (0.05, 0.5, 0.45))
        pgm_function470.set_cpd((0, 0, 4), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((1, 0, 4), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((2, 0, 4), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((3, 0, 4), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((4, 0, 4), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((0, 1, 4), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((1, 1, 4), (0.2, 0.5, 0.3))
        pgm_function470.set_cpd((2, 1, 4), (0.2, 0.5, 0.3))
        pgm_function470.set_cpd((3, 1, 4), (0.2, 0.5, 0.3))
        pgm_function470.set_cpd((4, 1, 4), (0.2, 0.5, 0.3))
        pgm_function470.set_cpd((0, 2, 4), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((1, 2, 4), (0.2, 0.5, 0.3))
        pgm_function470.set_cpd((2, 2, 4), (0.2, 0.5, 0.3))
        pgm_function470.set_cpd((3, 2, 4), (0.2, 0.5, 0.3))
        pgm_function470.set_cpd((4, 2, 4), (0.2, 0.5, 0.3))
        pgm_function470.set_cpd((0, 3, 4), (1.0, 0.0, 0.0))
        pgm_function470.set_cpd((1, 3, 4), (0.2, 0.5, 0.3))
        pgm_function470.set_cpd((2, 3, 4), (0.2, 0.5, 0.3))
        pgm_function470.set_cpd((3, 3, 4), (0.2, 0.5, 0.3))
        pgm_function470.set_cpd((4, 3, 4), (0.2, 0.5, 0.3))
        pgm_factor471 = self.new_factor(R_DIFFN_DELT_MUDENS, DIFFN_M_SEV_PROX, DIFFN_TIME, DIFFN_PATHO)
        pgm_function471 = pgm_factor471.set_cpt()
        pgm_function471.set_cpd((0, 0, 0), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((1, 0, 0), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((2, 0, 0), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((3, 0, 0), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((0, 1, 0), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((1, 1, 0), (0.9, 0.1, 0.0))
        pgm_function471.set_cpd((2, 1, 0), (0.8, 0.2, 0.0))
        pgm_function471.set_cpd((3, 1, 0), (0.6, 0.4, 0.0))
        pgm_function471.set_cpd((0, 2, 0), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((1, 2, 0), (0.8, 0.2, 0.0))
        pgm_function471.set_cpd((2, 2, 0), (0.7, 0.3, 0.0))
        pgm_function471.set_cpd((3, 2, 0), (0.6, 0.4, 0.0))
        pgm_function471.set_cpd((0, 3, 0), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((1, 3, 0), (0.8, 0.2, 0.0))
        pgm_function471.set_cpd((2, 3, 0), (0.7, 0.3, 0.0))
        pgm_function471.set_cpd((3, 3, 0), (0.6, 0.4, 0.0))
        pgm_function471.set_cpd((0, 0, 1), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((1, 0, 1), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((2, 0, 1), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((3, 0, 1), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((0, 1, 1), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((1, 1, 1), (0.9, 0.1, 0.0))
        pgm_function471.set_cpd((2, 1, 1), (0.8, 0.2, 0.0))
        pgm_function471.set_cpd((3, 1, 1), (0.6, 0.4, 0.0))
        pgm_function471.set_cpd((0, 2, 1), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((1, 2, 1), (0.8, 0.2, 0.0))
        pgm_function471.set_cpd((2, 2, 1), (0.7, 0.3, 0.0))
        pgm_function471.set_cpd((3, 2, 1), (0.6, 0.4, 0.0))
        pgm_function471.set_cpd((0, 3, 1), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((1, 3, 1), (0.8, 0.2, 0.0))
        pgm_function471.set_cpd((2, 3, 1), (0.7, 0.3, 0.0))
        pgm_function471.set_cpd((3, 3, 1), (0.6, 0.4, 0.0))
        pgm_function471.set_cpd((0, 0, 2), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((1, 0, 2), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((2, 0, 2), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((3, 0, 2), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((0, 1, 2), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((1, 1, 2), (0.6, 0.4, 0.0))
        pgm_function471.set_cpd((2, 1, 2), (0.5, 0.5, 0.0))
        pgm_function471.set_cpd((3, 1, 2), (0.5, 0.4, 0.1))
        pgm_function471.set_cpd((0, 2, 2), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((1, 2, 2), (0.7, 0.3, 0.0))
        pgm_function471.set_cpd((2, 2, 2), (0.1, 0.6, 0.3))
        pgm_function471.set_cpd((3, 2, 2), (0.0, 0.5, 0.5))
        pgm_function471.set_cpd((0, 3, 2), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((1, 3, 2), (0.5, 0.5, 0.0))
        pgm_function471.set_cpd((2, 3, 2), (0.15, 0.7, 0.15))
        pgm_function471.set_cpd((3, 3, 2), (0.0, 0.5, 0.5))
        pgm_function471.set_cpd((0, 0, 3), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((1, 0, 3), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((2, 0, 3), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((3, 0, 3), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((0, 1, 3), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((1, 1, 3), (0.05, 0.5, 0.45))
        pgm_function471.set_cpd((2, 1, 3), (0.05, 0.5, 0.45))
        pgm_function471.set_cpd((3, 1, 3), (0.05, 0.5, 0.45))
        pgm_function471.set_cpd((0, 2, 3), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((1, 2, 3), (0.05, 0.5, 0.45))
        pgm_function471.set_cpd((2, 2, 3), (0.05, 0.5, 0.45))
        pgm_function471.set_cpd((3, 2, 3), (0.05, 0.5, 0.45))
        pgm_function471.set_cpd((0, 3, 3), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((1, 3, 3), (0.05, 0.5, 0.45))
        pgm_function471.set_cpd((2, 3, 3), (0.05, 0.5, 0.45))
        pgm_function471.set_cpd((3, 3, 3), (0.05, 0.5, 0.45))
        pgm_function471.set_cpd((0, 0, 4), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((1, 0, 4), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((2, 0, 4), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((3, 0, 4), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((0, 1, 4), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((1, 1, 4), (0.2, 0.5, 0.3))
        pgm_function471.set_cpd((2, 1, 4), (0.2, 0.5, 0.3))
        pgm_function471.set_cpd((3, 1, 4), (0.2, 0.5, 0.3))
        pgm_function471.set_cpd((0, 2, 4), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((1, 2, 4), (0.2, 0.5, 0.3))
        pgm_function471.set_cpd((2, 2, 4), (0.2, 0.5, 0.3))
        pgm_function471.set_cpd((3, 2, 4), (0.2, 0.5, 0.3))
        pgm_function471.set_cpd((0, 3, 4), (1.0, 0.0, 0.0))
        pgm_function471.set_cpd((1, 3, 4), (0.2, 0.5, 0.3))
        pgm_function471.set_cpd((2, 3, 4), (0.2, 0.5, 0.3))
        pgm_function471.set_cpd((3, 3, 4), (0.2, 0.5, 0.3))
        pgm_factor472 = self.new_factor(R_LNLPC5_DIFFN_DELT_MUDENS, R_LNLPC5_DELT_MUDENS, R_DIFFN_DELT_MUDENS)
        pgm_function472 = pgm_factor472.set_cpt()
        pgm_function472.set_cpd((0, 0), (1.0, 0.0, 0.0))
        pgm_function472.set_cpd((1, 0), (0.0, 1.0, 0.0))
        pgm_function472.set_cpd((2, 0), (0.0, 0.0, 1.0))
        pgm_function472.set_cpd((0, 1), (0.0, 1.0, 0.0))
        pgm_function472.set_cpd((1, 1), (0.0, 0.0, 1.0))
        pgm_function472.set_cpd((2, 1), (0.0, 0.0, 1.0))
        pgm_function472.set_cpd((0, 2), (0.0, 0.0, 1.0))
        pgm_function472.set_cpd((1, 2), (0.0, 0.0, 1.0))
        pgm_function472.set_cpd((2, 2), (0.0, 0.0, 1.0))
        pgm_factor473 = self.new_factor(R_MYOP_DELT_MUDENS)
        pgm_function473 = pgm_factor473.set_cpt()
        pgm_function473.set_cpd((), (1.0, 0.0, 0.0))
        pgm_factor474 = self.new_factor(R_MYDY_DELT_MUDENS)
        pgm_function474 = pgm_factor474.set_cpt()
        pgm_function474.set_cpd((), (1.0, 0.0, 0.0))
        pgm_factor475 = self.new_factor(R_MYOP_MYDY_DELT_MUDENS, R_MYOP_DELT_MUDENS, R_MYDY_DELT_MUDENS)
        pgm_function475 = pgm_factor475.set_cpt()
        pgm_function475.set_cpd((0, 0), (1.0, 0.0, 0.0))
        pgm_function475.set_cpd((1, 0), (0.0, 1.0, 0.0))
        pgm_function475.set_cpd((2, 0), (0.0, 0.0, 1.0))
        pgm_function475.set_cpd((0, 1), (0.0, 1.0, 0.0))
        pgm_function475.set_cpd((1, 1), (0.0, 0.0, 1.0))
        pgm_function475.set_cpd((2, 1), (0.0, 0.0, 1.0))
        pgm_function475.set_cpd((0, 2), (0.0, 0.0, 1.0))
        pgm_function475.set_cpd((1, 2), (0.0, 0.0, 1.0))
        pgm_function475.set_cpd((2, 2), (0.0, 0.0, 1.0))
        pgm_factor476 = self.new_factor(R_MYAS_DELT_MUDENS)
        pgm_function476 = pgm_factor476.set_cpt()
        pgm_function476.set_cpd((), (1.0, 0.0, 0.0))
        pgm_factor477 = self.new_factor(R_OTHER_DELT_MUDENS)
        pgm_function477 = pgm_factor477.set_cpt()
        pgm_function477.set_cpd((), (1.0, 0.0, 0.0))
        pgm_factor478 = self.new_factor(R_MYAS_OTHER_DELT_MUDENS, R_MYAS_DELT_MUDENS, R_OTHER_DELT_MUDENS)
        pgm_function478 = pgm_factor478.set_cpt()
        pgm_function478.set_cpd((0, 0), (1.0, 0.0, 0.0))
        pgm_function478.set_cpd((1, 0), (0.0, 1.0, 0.0))
        pgm_function478.set_cpd((2, 0), (0.0, 0.0, 1.0))
        pgm_function478.set_cpd((0, 1), (0.0, 1.0, 0.0))
        pgm_function478.set_cpd((1, 1), (0.0, 0.0, 1.0))
        pgm_function478.set_cpd((2, 1), (0.0, 0.0, 1.0))
        pgm_function478.set_cpd((0, 2), (0.0, 0.0, 1.0))
        pgm_function478.set_cpd((1, 2), (0.0, 0.0, 1.0))
        pgm_function478.set_cpd((2, 2), (0.0, 0.0, 1.0))
        pgm_factor479 = self.new_factor(R_MUSCLE_DELT_MUDENS, R_MYOP_MYDY_DELT_MUDENS, R_MYAS_OTHER_DELT_MUDENS)
        pgm_function479 = pgm_factor479.set_cpt()
        pgm_function479.set_cpd((0, 0), (1.0, 0.0, 0.0))
        pgm_function479.set_cpd((1, 0), (0.0, 1.0, 0.0))
        pgm_function479.set_cpd((2, 0), (0.0, 0.0, 1.0))
        pgm_function479.set_cpd((0, 1), (0.0, 1.0, 0.0))
        pgm_function479.set_cpd((1, 1), (0.0, 0.0, 1.0))
        pgm_function479.set_cpd((2, 1), (0.0, 0.0, 1.0))
        pgm_function479.set_cpd((0, 2), (0.0, 0.0, 1.0))
        pgm_function479.set_cpd((1, 2), (0.0, 0.0, 1.0))
        pgm_function479.set_cpd((2, 2), (0.0, 0.0, 1.0))
        pgm_factor480 = self.new_factor(R_DELT_MUDENS, R_LNLPC5_DIFFN_DELT_MUDENS, R_MUSCLE_DELT_MUDENS)
        pgm_function480 = pgm_factor480.set_cpt()
        pgm_function480.set_cpd((0, 0), (1.0, 0.0, 0.0))
        pgm_function480.set_cpd((1, 0), (0.0, 1.0, 0.0))
        pgm_function480.set_cpd((2, 0), (0.0, 0.0, 1.0))
        pgm_function480.set_cpd((0, 1), (0.0, 1.0, 0.0))
        pgm_function480.set_cpd((1, 1), (0.0, 0.0, 1.0))
        pgm_function480.set_cpd((2, 1), (0.0, 0.0, 1.0))
        pgm_function480.set_cpd((0, 2), (0.0, 0.0, 1.0))
        pgm_function480.set_cpd((1, 2), (0.0, 0.0, 1.0))
        pgm_function480.set_cpd((2, 2), (0.0, 0.0, 1.0))
        pgm_factor481 = self.new_factor(R_DELT_SF_DENSITY, R_DELT_MUDENS)
        pgm_function481 = pgm_factor481.set_cpt()
        pgm_function481.set_cpd((0,), (0.97, 0.03, 0.0))
        pgm_function481.set_cpd((1,), (0.05, 0.9, 0.05))
        pgm_function481.set_cpd((2,), (0.01, 0.04, 0.95))
        pgm_factor482 = self.new_factor(R_LNLPC5_DELT_NEUR_ACT, R_LNLPC5_AXIL_SEV, R_LNLPC5_AXIL_TIME)
        pgm_function482 = pgm_factor482.set_cpt()
        pgm_function482.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function482.set_cpd((1, 0), (0.9, 0.1, 0.0, 0.0, 0.0, 0.0))
        pgm_function482.set_cpd((2, 0), (0.9, 0.1, 0.0, 0.0, 0.0, 0.0))
        pgm_function482.set_cpd((3, 0), (0.9, 0.1, 0.0, 0.0, 0.0, 0.0))
        pgm_function482.set_cpd((4, 0), (0.9, 0.1, 0.0, 0.0, 0.0, 0.0))
        pgm_function482.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function482.set_cpd((1, 1), (0.7, 0.3, 0.0, 0.0, 0.0, 0.0))
        pgm_function482.set_cpd((2, 1), (0.7, 0.3, 0.0, 0.0, 0.0, 0.0))
        pgm_function482.set_cpd((3, 1), (0.7, 0.3, 0.0, 0.0, 0.0, 0.0))
        pgm_function482.set_cpd((4, 1), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function482.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function482.set_cpd((1, 2), (0.5, 0.5, 0.0, 0.0, 0.0, 0.0))
        pgm_function482.set_cpd((2, 2), (0.5, 0.5, 0.0, 0.0, 0.0, 0.0))
        pgm_function482.set_cpd((3, 2), (0.3, 0.7, 0.0, 0.0, 0.0, 0.0))
        pgm_function482.set_cpd((4, 2), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function482.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function482.set_cpd((1, 3), (0.1, 0.9, 0.0, 0.0, 0.0, 0.0))
        pgm_function482.set_cpd((2, 3), (0.7, 0.3, 0.0, 0.0, 0.0, 0.0))
        pgm_function482.set_cpd((3, 3), (0.3, 0.7, 0.0, 0.0, 0.0, 0.0))
        pgm_function482.set_cpd((4, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor483 = self.new_factor(R_DIFFN_DELT_NEUR_ACT, DIFFN_M_SEV_PROX, DIFFN_TIME)
        pgm_function483 = pgm_factor483.set_cpt()
        pgm_function483.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function483.set_cpd((1, 0), (0.9, 0.1, 0.0, 0.0, 0.0, 0.0))
        pgm_function483.set_cpd((2, 0), (0.9, 0.1, 0.0, 0.0, 0.0, 0.0))
        pgm_function483.set_cpd((3, 0), (0.9, 0.1, 0.0, 0.0, 0.0, 0.0))
        pgm_function483.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function483.set_cpd((1, 1), (0.7, 0.3, 0.0, 0.0, 0.0, 0.0))
        pgm_function483.set_cpd((2, 1), (0.7, 0.3, 0.0, 0.0, 0.0, 0.0))
        pgm_function483.set_cpd((3, 1), (0.7, 0.3, 0.0, 0.0, 0.0, 0.0))
        pgm_function483.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function483.set_cpd((1, 2), (0.5, 0.5, 0.0, 0.0, 0.0, 0.0))
        pgm_function483.set_cpd((2, 2), (0.5, 0.5, 0.0, 0.0, 0.0, 0.0))
        pgm_function483.set_cpd((3, 2), (0.3, 0.7, 0.0, 0.0, 0.0, 0.0))
        pgm_function483.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function483.set_cpd((1, 3), (0.1, 0.9, 0.0, 0.0, 0.0, 0.0))
        pgm_function483.set_cpd((2, 3), (0.7, 0.3, 0.0, 0.0, 0.0, 0.0))
        pgm_function483.set_cpd((3, 3), (0.3, 0.7, 0.0, 0.0, 0.0, 0.0))
        pgm_factor484 = self.new_factor(R_LNLPC5_DIFFN_DELT_NEUR_ACT, R_LNLPC5_DELT_NEUR_ACT, R_DIFFN_DELT_NEUR_ACT)
        pgm_function484 = pgm_factor484.set_cpt()
        pgm_function484.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function484.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function484.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function484.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function484.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function484.set_cpd((5, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function484.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function484.set_cpd((1, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function484.set_cpd((2, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function484.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function484.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function484.set_cpd((5, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function484.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function484.set_cpd((1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function484.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function484.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function484.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function484.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function484.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function484.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function484.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function484.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function484.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function484.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function484.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function484.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function484.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function484.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function484.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function484.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function484.set_cpd((0, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function484.set_cpd((1, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function484.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function484.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function484.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function484.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor485 = self.new_factor(R_OTHER_DELT_NEUR_ACT)
        pgm_function485 = pgm_factor485.set_cpt()
        pgm_function485.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor486 = self.new_factor(R_DELT_NEUR_ACT, R_LNLPC5_DIFFN_DELT_NEUR_ACT, R_OTHER_DELT_NEUR_ACT)
        pgm_function486 = pgm_factor486.set_cpt()
        pgm_function486.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function486.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function486.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function486.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function486.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function486.set_cpd((5, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function486.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function486.set_cpd((1, 1), (0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function486.set_cpd((2, 1), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function486.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function486.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function486.set_cpd((5, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function486.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function486.set_cpd((1, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function486.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function486.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function486.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function486.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function486.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function486.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function486.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function486.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function486.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function486.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function486.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function486.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function486.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function486.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function486.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function486.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function486.set_cpd((0, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function486.set_cpd((1, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function486.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function486.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function486.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function486.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor487 = self.new_factor(R_DELT_SPONT_NEUR_DISCH, R_DELT_NEUR_ACT)
        pgm_function487 = pgm_factor487.set_cpt()
        pgm_function487.set_cpd((0,), (0.98, 0.02, 0.0, 0.0, 0.0, 0.0))
        pgm_function487.set_cpd((1,), (0.1, 0.9, 0.0, 0.0, 0.0, 0.0))
        pgm_function487.set_cpd((2,), (0.01, 0.04, 0.75, 0.05, 0.05, 0.1))
        pgm_function487.set_cpd((3,), (0.01, 0.04, 0.05, 0.75, 0.05, 0.1))
        pgm_function487.set_cpd((4,), (0.01, 0.04, 0.05, 0.05, 0.75, 0.1))
        pgm_function487.set_cpd((5,), (0.01, 0.05, 0.05, 0.05, 0.05, 0.79))
        pgm_factor488 = self.new_factor(R_MYOP_DELT_DENERV)
        pgm_function488 = pgm_factor488.set_cpt()
        pgm_function488.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor489 = self.new_factor(R_MYDY_DELT_DENERV)
        pgm_function489 = pgm_factor489.set_cpt()
        pgm_function489.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor490 = self.new_factor(R_MYOP_MYDY_DELT_DENERV, R_MYOP_DELT_DENERV, R_MYDY_DELT_DENERV)
        pgm_function490 = pgm_factor490.set_cpt()
        pgm_function490.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function490.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function490.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function490.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function490.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0))
        pgm_function490.set_cpd((1, 1), (0.0, 0.0, 1.0, 0.0))
        pgm_function490.set_cpd((2, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function490.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function490.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function490.set_cpd((1, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function490.set_cpd((2, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function490.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function490.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function490.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function490.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function490.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor491 = self.new_factor(R_OTHER_DELT_DENERV)
        pgm_function491 = pgm_factor491.set_cpt()
        pgm_function491.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor492 = self.new_factor(R_NMT_DELT_DENERV, R_DELT_NMT)
        pgm_function492 = pgm_factor492.set_cpt()
        pgm_function492.set_cpd((0,), (1.0, 0.0, 0.0, 0.0))
        pgm_function492.set_cpd((1,), (0.4, 0.45, 0.15, 0.0))
        pgm_function492.set_cpd((2,), (0.15, 0.35, 0.35, 0.15))
        pgm_function492.set_cpd((3,), (0.85, 0.15, 0.0, 0.0))
        pgm_function492.set_cpd((4,), (0.3, 0.45, 0.2, 0.05))
        pgm_function492.set_cpd((5,), (0.15, 0.35, 0.35, 0.15))
        pgm_function492.set_cpd((6,), (0.25, 0.25, 0.25, 0.25))
        pgm_factor493 = self.new_factor(R_OTHER_NMT_DELT_DENERV, R_OTHER_DELT_DENERV, R_NMT_DELT_DENERV)
        pgm_function493 = pgm_factor493.set_cpt()
        pgm_function493.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function493.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function493.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function493.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function493.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0))
        pgm_function493.set_cpd((1, 1), (0.0, 0.0, 1.0, 0.0))
        pgm_function493.set_cpd((2, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function493.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function493.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function493.set_cpd((1, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function493.set_cpd((2, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function493.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function493.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function493.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function493.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function493.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor494 = self.new_factor(R_MUSCLE_DELT_DENERV, R_MYOP_MYDY_DELT_DENERV, R_OTHER_NMT_DELT_DENERV)
        pgm_function494 = pgm_factor494.set_cpt()
        pgm_function494.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function494.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function494.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function494.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function494.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0))
        pgm_function494.set_cpd((1, 1), (0.0, 0.0, 1.0, 0.0))
        pgm_function494.set_cpd((2, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function494.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function494.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function494.set_cpd((1, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function494.set_cpd((2, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function494.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function494.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function494.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function494.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function494.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor495 = self.new_factor(R_LNLPC5_DELT_DENERV, R_LNLPC5_AXIL_SEV, R_LNLPC5_AXIL_TIME,
                                        R_LNLPC5_AXIL_PATHO)
        pgm_function495 = pgm_factor495.set_cpt()
        pgm_function495.set_cpd((0, 0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function495.set_cpd((1, 0, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function495.set_cpd((2, 0, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function495.set_cpd((3, 0, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function495.set_cpd((4, 0, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function495.set_cpd((0, 1, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function495.set_cpd((1, 1, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function495.set_cpd((2, 1, 0), (0.3, 0.5, 0.2, 0.0))
        pgm_function495.set_cpd((3, 1, 0), (0.1, 0.5, 0.4, 0.0))
        pgm_function495.set_cpd((4, 1, 0), (0.0, 0.4, 0.4, 0.2))
        pgm_function495.set_cpd((0, 2, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function495.set_cpd((1, 2, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function495.set_cpd((2, 2, 0), (0.3, 0.5, 0.2, 0.0))
        pgm_function495.set_cpd((3, 2, 0), (0.1, 0.5, 0.4, 0.0))
        pgm_function495.set_cpd((4, 2, 0), (0.0, 0.4, 0.4, 0.2))
        pgm_function495.set_cpd((0, 3, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function495.set_cpd((1, 3, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function495.set_cpd((2, 3, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function495.set_cpd((3, 3, 0), (0.5, 0.4, 0.1, 0.0))
        pgm_function495.set_cpd((4, 3, 0), (0.1, 0.6, 0.25, 0.05))
        pgm_function495.set_cpd((0, 0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function495.set_cpd((1, 0, 1), (0.8, 0.2, 0.0, 0.0))
        pgm_function495.set_cpd((2, 0, 1), (0.8, 0.2, 0.0, 0.0))
        pgm_function495.set_cpd((3, 0, 1), (0.8, 0.2, 0.0, 0.0))
        pgm_function495.set_cpd((4, 0, 1), (0.8, 0.2, 0.0, 0.0))
        pgm_function495.set_cpd((0, 1, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function495.set_cpd((1, 1, 1), (0.8, 0.2, 0.0, 0.0))
        pgm_function495.set_cpd((2, 1, 1), (0.6, 0.4, 0.0, 0.0))
        pgm_function495.set_cpd((3, 1, 1), (0.4, 0.5, 0.1, 0.0))
        pgm_function495.set_cpd((4, 1, 1), (0.3, 0.4, 0.3, 0.0))
        pgm_function495.set_cpd((0, 2, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function495.set_cpd((1, 2, 1), (0.9, 0.1, 0.0, 0.0))
        pgm_function495.set_cpd((2, 2, 1), (0.6, 0.4, 0.0, 0.0))
        pgm_function495.set_cpd((3, 2, 1), (0.4, 0.5, 0.1, 0.0))
        pgm_function495.set_cpd((4, 2, 1), (0.3, 0.4, 0.3, 0.0))
        pgm_function495.set_cpd((0, 3, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function495.set_cpd((1, 3, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function495.set_cpd((2, 3, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function495.set_cpd((3, 3, 1), (0.5, 0.5, 0.0, 0.0))
        pgm_function495.set_cpd((4, 3, 1), (0.5, 0.5, 0.0, 0.0))
        pgm_function495.set_cpd((0, 0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function495.set_cpd((1, 0, 2), (0.8, 0.2, 0.0, 0.0))
        pgm_function495.set_cpd((2, 0, 2), (0.8, 0.2, 0.0, 0.0))
        pgm_function495.set_cpd((3, 0, 2), (0.8, 0.2, 0.0, 0.0))
        pgm_function495.set_cpd((4, 0, 2), (0.8, 0.2, 0.0, 0.0))
        pgm_function495.set_cpd((0, 1, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function495.set_cpd((1, 1, 2), (0.0, 1.0, 0.0, 0.0))
        pgm_function495.set_cpd((2, 1, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function495.set_cpd((3, 1, 2), (0.0, 0.0, 0.5, 0.5))
        pgm_function495.set_cpd((4, 1, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function495.set_cpd((0, 2, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function495.set_cpd((1, 2, 2), (0.0, 1.0, 0.0, 0.0))
        pgm_function495.set_cpd((2, 2, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function495.set_cpd((3, 2, 2), (0.0, 0.0, 0.5, 0.5))
        pgm_function495.set_cpd((4, 2, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function495.set_cpd((0, 3, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function495.set_cpd((1, 3, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function495.set_cpd((2, 3, 2), (0.9, 0.1, 0.0, 0.0))
        pgm_function495.set_cpd((3, 3, 2), (0.6, 0.3, 0.1, 0.0))
        pgm_function495.set_cpd((4, 3, 2), (0.45, 0.45, 0.1, 0.0))
        pgm_function495.set_cpd((0, 0, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function495.set_cpd((1, 0, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function495.set_cpd((2, 0, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function495.set_cpd((3, 0, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function495.set_cpd((4, 0, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function495.set_cpd((0, 1, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function495.set_cpd((1, 1, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function495.set_cpd((2, 1, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function495.set_cpd((3, 1, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function495.set_cpd((4, 1, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function495.set_cpd((0, 2, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function495.set_cpd((1, 2, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function495.set_cpd((2, 2, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function495.set_cpd((3, 2, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function495.set_cpd((4, 2, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function495.set_cpd((0, 3, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function495.set_cpd((1, 3, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function495.set_cpd((2, 3, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function495.set_cpd((3, 3, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function495.set_cpd((4, 3, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function495.set_cpd((0, 0, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function495.set_cpd((1, 0, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function495.set_cpd((2, 0, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function495.set_cpd((3, 0, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function495.set_cpd((4, 0, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function495.set_cpd((0, 1, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function495.set_cpd((1, 1, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function495.set_cpd((2, 1, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function495.set_cpd((3, 1, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function495.set_cpd((4, 1, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function495.set_cpd((0, 2, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function495.set_cpd((1, 2, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function495.set_cpd((2, 2, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function495.set_cpd((3, 2, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function495.set_cpd((4, 2, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function495.set_cpd((0, 3, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function495.set_cpd((1, 3, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function495.set_cpd((2, 3, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function495.set_cpd((3, 3, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function495.set_cpd((4, 3, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_factor496 = self.new_factor(R_DIFFN_DELT_DENERV, DIFFN_M_SEV_PROX, DIFFN_TIME, DIFFN_PATHO)
        pgm_function496 = pgm_factor496.set_cpt()
        pgm_function496.set_cpd((0, 0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function496.set_cpd((1, 0, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function496.set_cpd((2, 0, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function496.set_cpd((3, 0, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function496.set_cpd((0, 1, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function496.set_cpd((1, 1, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function496.set_cpd((2, 1, 0), (0.3, 0.5, 0.2, 0.0))
        pgm_function496.set_cpd((3, 1, 0), (0.1, 0.5, 0.4, 0.0))
        pgm_function496.set_cpd((0, 2, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function496.set_cpd((1, 2, 0), (0.8, 0.2, 0.0, 0.0))
        pgm_function496.set_cpd((2, 2, 0), (0.3, 0.5, 0.2, 0.0))
        pgm_function496.set_cpd((3, 2, 0), (0.1, 0.5, 0.4, 0.0))
        pgm_function496.set_cpd((0, 3, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function496.set_cpd((1, 3, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function496.set_cpd((2, 3, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function496.set_cpd((3, 3, 0), (0.5, 0.4, 0.1, 0.0))
        pgm_function496.set_cpd((0, 0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function496.set_cpd((1, 0, 1), (0.8, 0.2, 0.0, 0.0))
        pgm_function496.set_cpd((2, 0, 1), (0.8, 0.2, 0.0, 0.0))
        pgm_function496.set_cpd((3, 0, 1), (0.8, 0.2, 0.0, 0.0))
        pgm_function496.set_cpd((0, 1, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function496.set_cpd((1, 1, 1), (0.9, 0.1, 0.0, 0.0))
        pgm_function496.set_cpd((2, 1, 1), (0.6, 0.4, 0.0, 0.0))
        pgm_function496.set_cpd((3, 1, 1), (0.4, 0.5, 0.1, 0.0))
        pgm_function496.set_cpd((0, 2, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function496.set_cpd((1, 2, 1), (0.9, 0.1, 0.0, 0.0))
        pgm_function496.set_cpd((2, 2, 1), (0.6, 0.4, 0.0, 0.0))
        pgm_function496.set_cpd((3, 2, 1), (0.4, 0.5, 0.1, 0.0))
        pgm_function496.set_cpd((0, 3, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function496.set_cpd((1, 3, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function496.set_cpd((2, 3, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function496.set_cpd((3, 3, 1), (0.5, 0.5, 0.0, 0.0))
        pgm_function496.set_cpd((0, 0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function496.set_cpd((1, 0, 2), (0.8, 0.2, 0.0, 0.0))
        pgm_function496.set_cpd((2, 0, 2), (0.8, 0.2, 0.0, 0.0))
        pgm_function496.set_cpd((3, 0, 2), (0.8, 0.2, 0.0, 0.0))
        pgm_function496.set_cpd((0, 1, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function496.set_cpd((1, 1, 2), (0.0, 1.0, 0.0, 0.0))
        pgm_function496.set_cpd((2, 1, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function496.set_cpd((3, 1, 2), (0.0, 0.0, 0.5, 0.5))
        pgm_function496.set_cpd((0, 2, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function496.set_cpd((1, 2, 2), (0.0, 1.0, 0.0, 0.0))
        pgm_function496.set_cpd((2, 2, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function496.set_cpd((3, 2, 2), (0.0, 0.0, 0.5, 0.5))
        pgm_function496.set_cpd((0, 3, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function496.set_cpd((1, 3, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function496.set_cpd((2, 3, 2), (0.9, 0.1, 0.0, 0.0))
        pgm_function496.set_cpd((3, 3, 2), (0.6, 0.3, 0.1, 0.0))
        pgm_function496.set_cpd((0, 0, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function496.set_cpd((1, 0, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function496.set_cpd((2, 0, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function496.set_cpd((3, 0, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function496.set_cpd((0, 1, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function496.set_cpd((1, 1, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function496.set_cpd((2, 1, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function496.set_cpd((3, 1, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function496.set_cpd((0, 2, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function496.set_cpd((1, 2, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function496.set_cpd((2, 2, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function496.set_cpd((3, 2, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function496.set_cpd((0, 3, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function496.set_cpd((1, 3, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function496.set_cpd((2, 3, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function496.set_cpd((3, 3, 3), (0.0, 0.0, 0.5, 0.5))
        pgm_function496.set_cpd((0, 0, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function496.set_cpd((1, 0, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function496.set_cpd((2, 0, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function496.set_cpd((3, 0, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function496.set_cpd((0, 1, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function496.set_cpd((1, 1, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function496.set_cpd((2, 1, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function496.set_cpd((3, 1, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function496.set_cpd((0, 2, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function496.set_cpd((1, 2, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function496.set_cpd((2, 2, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function496.set_cpd((3, 2, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function496.set_cpd((0, 3, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function496.set_cpd((1, 3, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function496.set_cpd((2, 3, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_function496.set_cpd((3, 3, 4), (0.05, 0.4, 0.5, 0.05))
        pgm_factor497 = self.new_factor(R_LNLPC5_DIFFN_DELT_DENERV, R_LNLPC5_DELT_DENERV, R_DIFFN_DELT_DENERV)
        pgm_function497 = pgm_factor497.set_cpt()
        pgm_function497.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function497.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function497.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function497.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function497.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0))
        pgm_function497.set_cpd((1, 1), (0.0, 0.0, 1.0, 0.0))
        pgm_function497.set_cpd((2, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function497.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function497.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function497.set_cpd((1, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function497.set_cpd((2, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function497.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function497.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function497.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function497.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function497.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor498 = self.new_factor(R_DELT_DENERV, R_MUSCLE_DELT_DENERV, R_LNLPC5_DIFFN_DELT_DENERV)
        pgm_function498 = pgm_factor498.set_cpt()
        pgm_function498.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function498.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function498.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function498.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function498.set_cpd((0, 1), (0.0, 1.0, 0.0, 0.0))
        pgm_function498.set_cpd((1, 1), (0.0, 0.0, 1.0, 0.0))
        pgm_function498.set_cpd((2, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function498.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function498.set_cpd((0, 2), (0.0, 0.0, 1.0, 0.0))
        pgm_function498.set_cpd((1, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function498.set_cpd((2, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function498.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function498.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function498.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function498.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function498.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor499 = self.new_factor(R_DELT_SPONT_DENERV_ACT, R_DELT_DENERV)
        pgm_function499 = pgm_factor499.set_cpt()
        pgm_function499.set_cpd((0,), (0.98, 0.02, 0.0, 0.0))
        pgm_function499.set_cpd((1,), (0.07, 0.85, 0.08, 0.0))
        pgm_function499.set_cpd((2,), (0.01, 0.07, 0.85, 0.07))
        pgm_function499.set_cpd((3,), (0.0, 0.01, 0.07, 0.92))
        pgm_factor500 = self.new_factor(R_DELT_SPONT_HF_DISCH, R_DELT_DENERV)
        pgm_function500 = pgm_factor500.set_cpt()
        pgm_function500.set_cpd((0,), (0.99, 0.01))
        pgm_function500.set_cpd((1,), (0.97, 0.03))
        pgm_function500.set_cpd((2,), (0.95, 0.05))
        pgm_function500.set_cpd((3,), (0.93, 0.07))
        pgm_factor501 = self.new_factor(R_DELT_SPONT_INS_ACT, R_DELT_DENERV)
        pgm_function501 = pgm_factor501.set_cpt()
        pgm_function501.set_cpd((0,), (0.98, 0.02))
        pgm_function501.set_cpd((1,), (0.1, 0.9))
        pgm_function501.set_cpd((2,), (0.05, 0.95))
        pgm_function501.set_cpd((3,), (0.05, 0.95))
        pgm_factor502 = self.new_factor(R_OTHER_ISCH_DISP)
        pgm_function502 = pgm_factor502.set_cpt()
        pgm_function502.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor503 = self.new_factor(R_DIFFN_ISCH_DISP, DIFFN_S_SEV_DIST, DIFFN_PATHO)
        pgm_function503 = pgm_factor503.set_cpt()
        pgm_function503.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function503.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function503.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function503.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function503.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function503.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0))
        pgm_function503.set_cpd((2, 1), (0.0, 0.5, 0.5, 0.0))
        pgm_function503.set_cpd((3, 1), (0.0, 0.1, 0.5, 0.4))
        pgm_function503.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function503.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function503.set_cpd((2, 2), (0.5, 0.5, 0.0, 0.0))
        pgm_function503.set_cpd((3, 2), (0.0, 0.5, 0.5, 0.0))
        pgm_function503.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function503.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function503.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function503.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function503.set_cpd((0, 4), (0.0, 0.0, 0.0, 1.0))
        pgm_function503.set_cpd((1, 4), (0.0, 0.0, 0.0, 1.0))
        pgm_function503.set_cpd((2, 4), (0.0, 0.0, 0.0, 1.0))
        pgm_function503.set_cpd((3, 4), (0.0, 0.0, 0.0, 1.0))
        pgm_factor504 = self.new_factor(R_SUR_DISP_CA, R_OTHER_ISCH_DISP, R_DIFFN_ISCH_DISP)
        pgm_function504 = pgm_factor504.set_cpt()
        pgm_function504.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function504.set_cpd((1, 0), (0.0749, 0.8229, 0.1022, 0.0))
        pgm_function504.set_cpd((2, 0), (0.0, 0.06260626, 0.93739374, 0.0))
        pgm_function504.set_cpd((3, 0), (0.0, 0.00790079, 0.60286029, 0.38923892))
        pgm_function504.set_cpd((0, 1), (0.0749, 0.8229, 0.1022, 0.0))
        pgm_function504.set_cpd((1, 1), (0.0047, 0.1786, 0.8167, 0.0))
        pgm_function504.set_cpd((2, 1), (0.0, 0.019, 0.9795, 0.0015))
        pgm_function504.set_cpd((3, 1), (0.0, 0.0001, 0.0069, 0.993))
        pgm_function504.set_cpd((0, 2), (0.0, 0.06260626, 0.93739374, 0.0))
        pgm_function504.set_cpd((1, 2), (0.0, 0.019, 0.9795, 0.0015))
        pgm_function504.set_cpd((2, 2), (0.0, 0.0001, 0.0833, 0.9166))
        pgm_function504.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function504.set_cpd((0, 3), (0.0, 0.00790079, 0.60286029, 0.38923892))
        pgm_function504.set_cpd((1, 3), (0.0, 0.0001, 0.0069, 0.993))
        pgm_function504.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function504.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor505 = self.new_factor(R_OTHER_ISCH_BLOCK)
        pgm_function505 = pgm_factor505.set_cpt()
        pgm_function505.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor506 = self.new_factor(R_DIFFN_ISCH_BLOCK, DIFFN_S_SEV_DIST, DIFFN_PATHO)
        pgm_function506 = pgm_factor506.set_cpt()
        pgm_function506.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function506.set_cpd((1, 0), (0.8, 0.2, 0.0, 0.0, 0.0))
        pgm_function506.set_cpd((2, 0), (0.6, 0.4, 0.0, 0.0, 0.0))
        pgm_function506.set_cpd((3, 0), (0.25, 0.5, 0.25, 0.0, 0.0))
        pgm_function506.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function506.set_cpd((1, 1), (0.2, 0.5, 0.3, 0.0, 0.0))
        pgm_function506.set_cpd((2, 1), (0.0, 0.2, 0.5, 0.3, 0.0))
        pgm_function506.set_cpd((3, 1), (0.0, 0.0, 0.4, 0.5, 0.1))
        pgm_function506.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function506.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function506.set_cpd((2, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function506.set_cpd((3, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function506.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function506.set_cpd((1, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function506.set_cpd((2, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function506.set_cpd((3, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function506.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function506.set_cpd((1, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function506.set_cpd((2, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function506.set_cpd((3, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor507 = self.new_factor(R_SUR_BLOCK_CA, R_OTHER_ISCH_BLOCK, R_DIFFN_ISCH_BLOCK)
        pgm_function507 = pgm_factor507.set_cpt()
        pgm_function507.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function507.set_cpd((1, 0), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function507.set_cpd((2, 0), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function507.set_cpd((3, 0), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function507.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function507.set_cpd((0, 1), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function507.set_cpd((1, 1), (0.0001, 0.498, 0.5019, 0.0, 0.0))
        pgm_function507.set_cpd((2, 1), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function507.set_cpd((3, 1), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function507.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function507.set_cpd((0, 2), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function507.set_cpd((1, 2), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function507.set_cpd((2, 2), (0.0, 0.0007, 0.4328, 0.5665, 0.0))
        pgm_function507.set_cpd((3, 2), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function507.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function507.set_cpd((0, 3), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function507.set_cpd((1, 3), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function507.set_cpd((2, 3), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function507.set_cpd((3, 3), (0.00030003, 0.00110011, 0.01250125, 0.98609861, 0.0))
        pgm_function507.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function507.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function507.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function507.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function507.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function507.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor508 = self.new_factor(R_OTHER_ISCH_SALOSS)
        pgm_function508 = pgm_factor508.set_cpt()
        pgm_function508.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor509 = self.new_factor(R_DIFFN_ISCH_SALOSS, DIFFN_S_SEV_DIST, DIFFN_PATHO)
        pgm_function509 = pgm_factor509.set_cpt()
        pgm_function509.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function509.set_cpd((1, 0), (0.5, 0.5, 0.0, 0.0, 0.0))
        pgm_function509.set_cpd((2, 0), (0.0, 0.5, 0.5, 0.0, 0.0))
        pgm_function509.set_cpd((3, 0), (0.0, 0.0, 0.0, 0.7, 0.3))
        pgm_function509.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function509.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0, 0.0))
        pgm_function509.set_cpd((2, 1), (0.4, 0.3, 0.3, 0.0, 0.0))
        pgm_function509.set_cpd((3, 1), (0.0, 0.3, 0.5, 0.2, 0.0))
        pgm_function509.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function509.set_cpd((1, 2), (0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function509.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function509.set_cpd((3, 2), (0.0, 0.0, 0.0, 0.7, 0.3))
        pgm_function509.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function509.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function509.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function509.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function509.set_cpd((0, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function509.set_cpd((1, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function509.set_cpd((2, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function509.set_cpd((3, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_factor510 = self.new_factor(R_LNL_ISCH_SEV)
        pgm_function510 = pgm_factor510.set_cpt()
        pgm_function510.set_cpd((), (0.96, 0.02, 0.01, 0.005, 0.005))
        pgm_factor511 = self.new_factor(R_LNL_ISCH_PATHO)
        pgm_function511 = pgm_factor511.set_cpt()
        pgm_function511.set_cpd((), (0.25, 0.25, 0.5, 0.0, 0.0))
        pgm_factor512 = self.new_factor(R_LNL_ISCH_SALOSS_CA, R_LNL_ISCH_SEV, R_LNL_ISCH_PATHO)
        pgm_function512 = pgm_factor512.set_cpt()
        pgm_function512.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function512.set_cpd((1, 0), (0.5, 0.5, 0.0, 0.0, 0.0))
        pgm_function512.set_cpd((2, 0), (0.0, 0.5, 0.5, 0.0, 0.0))
        pgm_function512.set_cpd((3, 0), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function512.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.4, 0.6))
        pgm_function512.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function512.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0, 0.0))
        pgm_function512.set_cpd((2, 1), (0.2, 0.5, 0.3, 0.0, 0.0))
        pgm_function512.set_cpd((3, 1), (0.0, 0.2, 0.5, 0.3, 0.0))
        pgm_function512.set_cpd((4, 1), (0.0, 0.1, 0.4, 0.4, 0.1))
        pgm_function512.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function512.set_cpd((1, 2), (0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function512.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function512.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function512.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function512.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function512.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function512.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function512.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function512.set_cpd((4, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function512.set_cpd((0, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function512.set_cpd((1, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function512.set_cpd((2, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function512.set_cpd((3, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function512.set_cpd((4, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_factor513 = self.new_factor(R_DIFFN_LNL_ISCH_SALOSS, R_DIFFN_ISCH_SALOSS, R_LNL_ISCH_SALOSS_CA)
        pgm_function513 = pgm_factor513.set_cpt()
        pgm_function513.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function513.set_cpd((1, 0), (0.0073, 0.9812, 0.0115, 0.0, 0.0))
        pgm_function513.set_cpd((2, 0), (0.0017, 0.1306, 0.867, 0.0007, 0.0))
        pgm_function513.set_cpd((3, 0), (0.0, 0.0003, 0.0212, 0.9785, 0.0))
        pgm_function513.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function513.set_cpd((0, 1), (0.0073, 0.9812, 0.0115, 0.0, 0.0))
        pgm_function513.set_cpd((1, 1), (0.0, 0.0289, 0.9711, 0.0, 0.0))
        pgm_function513.set_cpd((2, 1), (0.0, 0.0097, 0.5989, 0.3914, 0.0))
        pgm_function513.set_cpd((3, 1), (0.0, 0.0, 0.0017, 0.9983, 0.0))
        pgm_function513.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function513.set_cpd((0, 2), (0.0017, 0.1306, 0.867, 0.0007, 0.0))
        pgm_function513.set_cpd((1, 2), (0.0, 0.0097, 0.5989, 0.3914, 0.0))
        pgm_function513.set_cpd((2, 2), (0.0, 0.00049995, 0.03309669, 0.96640336, 0.0))
        pgm_function513.set_cpd((3, 2), (0.0, 0.0, 0.0008, 0.9992, 0.0))
        pgm_function513.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function513.set_cpd((0, 3), (0.0, 0.0003, 0.0212, 0.9785, 0.0))
        pgm_function513.set_cpd((1, 3), (0.0, 0.0, 0.0017, 0.9983, 0.0))
        pgm_function513.set_cpd((2, 3), (0.0, 0.0, 0.0008, 0.9992, 0.0))
        pgm_function513.set_cpd((3, 3), (0.0, 0.0, 0.0001, 0.9999, 0.0))
        pgm_function513.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function513.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function513.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function513.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function513.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function513.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor514 = self.new_factor(R_SUR_SALOSS, R_OTHER_ISCH_SALOSS, R_DIFFN_LNL_ISCH_SALOSS)
        pgm_function514 = pgm_factor514.set_cpt()
        pgm_function514.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function514.set_cpd((1, 0), (0.0073, 0.9812, 0.0115, 0.0, 0.0))
        pgm_function514.set_cpd((2, 0), (0.0017, 0.1306, 0.867, 0.0007, 0.0))
        pgm_function514.set_cpd((3, 0), (0.0, 0.0003, 0.0212, 0.9785, 0.0))
        pgm_function514.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function514.set_cpd((0, 1), (0.0073, 0.9812, 0.0115, 0.0, 0.0))
        pgm_function514.set_cpd((1, 1), (0.0, 0.0289, 0.9711, 0.0, 0.0))
        pgm_function514.set_cpd((2, 1), (0.0, 0.0097, 0.5989, 0.3914, 0.0))
        pgm_function514.set_cpd((3, 1), (0.0, 0.0, 0.0017, 0.9983, 0.0))
        pgm_function514.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function514.set_cpd((0, 2), (0.0017, 0.1306, 0.867, 0.0007, 0.0))
        pgm_function514.set_cpd((1, 2), (0.0, 0.0097, 0.5989, 0.3914, 0.0))
        pgm_function514.set_cpd((2, 2), (0.0, 0.00049995, 0.03309669, 0.96640336, 0.0))
        pgm_function514.set_cpd((3, 2), (0.0, 0.0, 0.0008, 0.9992, 0.0))
        pgm_function514.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function514.set_cpd((0, 3), (0.0, 0.0003, 0.0212, 0.9785, 0.0))
        pgm_function514.set_cpd((1, 3), (0.0, 0.0, 0.0017, 0.9983, 0.0))
        pgm_function514.set_cpd((2, 3), (0.0, 0.0, 0.0008, 0.9992, 0.0))
        pgm_function514.set_cpd((3, 3), (0.0, 0.0, 0.0001, 0.9999, 0.0))
        pgm_function514.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function514.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function514.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function514.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function514.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function514.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor515 = self.new_factor(R_SUR_EFFAXLOSS, R_SUR_BLOCK_CA, R_SUR_SALOSS)
        pgm_function515 = pgm_factor515.set_cpt()
        pgm_function515.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function515.set_cpd((1, 0), (0.0073, 0.9812, 0.0115, 0.0, 0.0))
        pgm_function515.set_cpd((2, 0), (0.0017, 0.1306, 0.867, 0.0007, 0.0))
        pgm_function515.set_cpd((3, 0), (0.0, 0.0003, 0.0212, 0.9785, 0.0))
        pgm_function515.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function515.set_cpd((0, 1), (0.0073, 0.9812, 0.0115, 0.0, 0.0))
        pgm_function515.set_cpd((1, 1), (0.0, 0.0289, 0.9711, 0.0, 0.0))
        pgm_function515.set_cpd((2, 1), (0.0, 0.0097, 0.5989, 0.3914, 0.0))
        pgm_function515.set_cpd((3, 1), (0.0, 0.0, 0.0017, 0.9983, 0.0))
        pgm_function515.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function515.set_cpd((0, 2), (0.0017, 0.1306, 0.867, 0.0007, 0.0))
        pgm_function515.set_cpd((1, 2), (0.0, 0.0097, 0.5989, 0.3914, 0.0))
        pgm_function515.set_cpd((2, 2), (0.0, 0.00049995, 0.03309669, 0.96640336, 0.0))
        pgm_function515.set_cpd((3, 2), (0.0, 0.0, 0.0008, 0.9992, 0.0))
        pgm_function515.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function515.set_cpd((0, 3), (0.0, 0.0003, 0.0212, 0.9785, 0.0))
        pgm_function515.set_cpd((1, 3), (0.0, 0.0, 0.0017, 0.9983, 0.0))
        pgm_function515.set_cpd((2, 3), (0.0, 0.0, 0.0008, 0.9992, 0.0))
        pgm_function515.set_cpd((3, 3), (0.0, 0.0, 0.0001, 0.9999, 0.0))
        pgm_function515.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function515.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function515.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function515.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function515.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function515.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor516 = self.new_factor(R_SUR_ALLAMP_CA, R_SUR_DISP_CA, R_SUR_EFFAXLOSS)
        pgm_function516 = pgm_factor516.set_cpt()
        pgm_function516.set_cpd((0, 0), (0.0, 0.0, 0.0, 0.0, 0.0215, 0.9785))
        pgm_function516.set_cpd((1, 0), (0.0, 0.0, 0.0, 0.3192, 0.6448, 0.036))
        pgm_function516.set_cpd((2, 0), (0.0, 0.0, 0.0051, 0.994, 0.0009, 0.0))
        pgm_function516.set_cpd((3, 0), (0.0, 0.0, 0.9945, 0.0055, 0.0, 0.0))
        pgm_function516.set_cpd((0, 1), (0.0, 0.0, 0.0, 0.3443, 0.6228, 0.0329))
        pgm_function516.set_cpd((1, 1), (0.0, 0.0, 0.04740474, 0.93949395, 0.01290129, 0.00020002))
        pgm_function516.set_cpd((2, 1), (0.0, 0.0, 0.9599, 0.0401, 0.0, 0.0))
        pgm_function516.set_cpd((3, 1), (0.0, 0.0, 0.9999, 0.0001, 0.0, 0.0))
        pgm_function516.set_cpd((0, 2), (0.0, 0.0, 0.0248, 0.9704, 0.0048, 0.0))
        pgm_function516.set_cpd((1, 2), (0.0, 0.0, 0.93309331, 0.06690669, 0.0, 0.0))
        pgm_function516.set_cpd((2, 2), (0.0, 0.0001, 0.9994, 0.0005, 0.0, 0.0))
        pgm_function516.set_cpd((3, 2), (0.0, 0.7508, 0.2492, 0.0, 0.0, 0.0))
        pgm_function516.set_cpd((0, 3), (0.0, 0.1028, 0.8793, 0.0178, 0.0001, 0.0))
        pgm_function516.set_cpd((1, 3), (0.0, 0.8756, 0.1237, 0.0007, 0.0, 0.0))
        pgm_function516.set_cpd((2, 3), (0.0, 0.9969, 0.0031, 0.0, 0.0, 0.0))
        pgm_function516.set_cpd((3, 3), (0.0, 0.9999, 0.0001, 0.0, 0.0, 0.0))
        pgm_function516.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function516.set_cpd((1, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function516.set_cpd((2, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function516.set_cpd((3, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor517 = self.new_factor(R_SUR_AMP_CA, R_SUR_ALLAMP_CA)
        pgm_function517 = pgm_factor517.set_cpt()
        pgm_function517.set_cpd((0,),
                                (0.7619, 0.1816, 0.0438, 0.0099, 0.0022, 0.0005, 0.0001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function517.set_cpd((1,), (
            0.38293829, 0.26322632, 0.16731673, 0.09570957, 0.04980498, 0.02420242, 0.01050105, 0.00410041, 0.00150015,
            0.00050005, 0.00020002, 0.0, 0.0))
        pgm_function517.set_cpd((2,), (
            0.04670467, 0.11351135, 0.1930193, 0.23662366, 0.20492049, 0.12771277, 0.05570557, 0.01720172, 0.00390039,
            0.00060006, 0.00010001, 0.0, 0.0))
        pgm_function517.set_cpd((3,), (
            0.0, 9.999e-05, 0.00109989, 0.01139886, 0.06489351, 0.19078092, 0.30886911, 0.26467353, 0.12378762,
            0.03019698,
            0.00389961, 0.00029997, 0.0))
        pgm_function517.set_cpd((4,), (
            0.0, 0.0, 0.0, 0.0, 0.00010001, 0.00170017, 0.02270227, 0.13181318, 0.31883188, 0.3390339, 0.15251525,
            0.03080308, 0.00250025))
        pgm_function517.set_cpd((5,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00010001, 0.00580058, 0.07460746, 0.31883188, 0.4120412, 0.16811681,
            0.02050205))
        pgm_factor518 = self.new_factor(R_SUR_LD_CA)
        pgm_function518 = pgm_factor518.set_cpt()
        pgm_function518.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor519 = self.new_factor(R_SUR_RD_CA)
        pgm_function519 = pgm_factor519.set_cpt()
        pgm_function519.set_cpd((), (1.0, 0.0, 0.0))
        pgm_factor520 = self.new_factor(R_SUR_LSLOW_CA, R_SUR_LD_CA, R_SUR_RD_CA)
        pgm_function520 = pgm_factor520.set_cpt()
        pgm_function520.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function520.set_cpd((1, 0), (0.0185, 0.9561, 0.0254, 0.0, 0.0))
        pgm_function520.set_cpd((2, 0), (0.0, 0.0166, 0.9834, 0.0, 0.0))
        pgm_function520.set_cpd((3, 0), (0.0007, 0.002, 0.0219, 0.9754, 0.0))
        pgm_function520.set_cpd((0, 1), (0.0021, 0.0042, 0.0295, 0.9642, 0.0))
        pgm_function520.set_cpd((1, 1), (0.0012, 0.0025, 0.0194, 0.9769, 0.0))
        pgm_function520.set_cpd((2, 1), (0.00069993, 0.00149985, 0.0119988, 0.98580142, 0.0))
        pgm_function520.set_cpd((3, 1), (0.00020002, 0.00050005, 0.00460046, 0.99449945, 0.00020002))
        pgm_function520.set_cpd((0, 2), (0.0001, 0.0002, 0.0014, 0.083, 0.9153))
        pgm_function520.set_cpd((1, 2), (0.0001, 0.0001, 0.0008, 0.0533, 0.9457))
        pgm_function520.set_cpd((2, 2), (0.0, 0.0001, 0.0004, 0.0319, 0.9676))
        pgm_function520.set_cpd((3, 2), (0.0, 0.0, 0.0, 0.00350035, 0.99649965))
        pgm_factor521 = self.new_factor(R_OTHER_ISCH_DIFSLOW)
        pgm_function521 = pgm_factor521.set_cpt()
        pgm_function521.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor522 = self.new_factor(R_DIFFN_ISCH_DIFSLOW, DIFFN_S_SEV_DIST, DIFFN_PATHO)
        pgm_function522 = pgm_factor522.set_cpt()
        pgm_function522.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function522.set_cpd((1, 0), (0.0, 0.5, 0.5, 0.0))
        pgm_function522.set_cpd((2, 0), (0.0, 0.2, 0.6, 0.2))
        pgm_function522.set_cpd((3, 0), (0.0, 0.1, 0.6, 0.3))
        pgm_function522.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function522.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0))
        pgm_function522.set_cpd((2, 1), (0.2, 0.4, 0.3, 0.1))
        pgm_function522.set_cpd((3, 1), (0.2, 0.4, 0.3, 0.1))
        pgm_function522.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function522.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function522.set_cpd((2, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function522.set_cpd((3, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function522.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function522.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function522.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function522.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function522.set_cpd((0, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_function522.set_cpd((1, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_function522.set_cpd((2, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_function522.set_cpd((3, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_factor523 = self.new_factor(R_SUR_DIFSLOW_CA, R_OTHER_ISCH_DIFSLOW, R_DIFFN_ISCH_DIFSLOW)
        pgm_function523 = pgm_factor523.set_cpt()
        pgm_function523.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function523.set_cpd((1, 0), (0.0127, 0.9867, 0.0006, 0.0))
        pgm_function523.set_cpd((2, 0), (0.0, 0.01810181, 0.98189819, 0.0))
        pgm_function523.set_cpd((3, 0), (0.0, 0.0006, 0.0492, 0.9502))
        pgm_function523.set_cpd((0, 1), (0.0127, 0.9867, 0.0006, 0.0))
        pgm_function523.set_cpd((1, 1), (0.0001, 0.0952, 0.9047, 0.0))
        pgm_function523.set_cpd((2, 1), (0.0, 0.0011, 0.7402, 0.2587))
        pgm_function523.set_cpd((3, 1), (0.0, 0.0, 0.00880088, 0.99119912))
        pgm_function523.set_cpd((0, 2), (0.0, 0.01810181, 0.98189819, 0.0))
        pgm_function523.set_cpd((1, 2), (0.0, 0.0011, 0.7402, 0.2587))
        pgm_function523.set_cpd((2, 2), (0.0, 0.0, 0.004, 0.996))
        pgm_function523.set_cpd((3, 2), (0.0, 0.0, 0.0012, 0.9988))
        pgm_function523.set_cpd((0, 3), (0.0, 0.0006, 0.0492, 0.9502))
        pgm_function523.set_cpd((1, 3), (0.0, 0.0, 0.00880088, 0.99119912))
        pgm_function523.set_cpd((2, 3), (0.0, 0.0, 0.0012, 0.9988))
        pgm_function523.set_cpd((3, 3), (0.0, 0.0, 0.0009, 0.9991))
        pgm_factor524 = self.new_factor(R_SUR_DSLOW_CA, R_SUR_SALOSS, R_SUR_DIFSLOW_CA)
        pgm_function524 = pgm_factor524.set_cpt()
        pgm_function524.set_cpd((0, 0), (0.8825, 0.1175, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function524.set_cpd((1, 0), (0.3460346, 0.65076508, 0.00320032, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function524.set_cpd((2, 0), (0.0641, 0.8105, 0.1254, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function524.set_cpd((3, 0), (0.00410041, 0.15271527, 0.78487849, 0.05830583, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function524.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function524.set_cpd((0, 1),
                                (0.06390639, 0.24022402, 0.46154615, 0.22352235, 0.01080108, 0.0, 0.0, 0.0, 0.0))
        pgm_function524.set_cpd((1, 1), (0.0245, 0.1308, 0.4221, 0.38, 0.0426, 0.0, 0.0, 0.0, 0.0))
        pgm_function524.set_cpd((2, 1), (0.0078, 0.0585, 0.3098, 0.5006, 0.123, 0.0003, 0.0, 0.0, 0.0))
        pgm_function524.set_cpd((3, 1), (0.0012, 0.0133, 0.1276, 0.4624, 0.3871, 0.0084, 0.0, 0.0, 0.0))
        pgm_function524.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function524.set_cpd((0, 2), (0.0011, 0.0083, 0.0684, 0.2984, 0.5331, 0.0899, 0.0008, 0.0, 0.0))
        pgm_function524.set_cpd((1, 2), (0.0003, 0.003, 0.0335, 0.2043, 0.5689, 0.1865, 0.0035, 0.0, 0.0))
        pgm_function524.set_cpd((2, 2), (
            0.00010001, 0.0010001, 0.01440144, 0.12231223, 0.52405241, 0.32563256, 0.01250125, 0.0, 0.0))
        pgm_function524.set_cpd((3, 2), (0.0, 0.0002, 0.0034, 0.043, 0.3319, 0.551, 0.0705, 0.0, 0.0))
        pgm_function524.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function524.set_cpd((0, 3), (
            0.00040004, 0.00120012, 0.00530053, 0.02140214, 0.08840884, 0.28082808, 0.4470447, 0.15541554, 0.0))
        pgm_function524.set_cpd((1, 3), (
            0.00019996, 0.00069986, 0.00319936, 0.0139972, 0.064987, 0.24325135, 0.46090782, 0.21275745, 0.0))
        pgm_function524.set_cpd((2, 3), (0.0001, 0.0004, 0.0018, 0.0089, 0.0461, 0.2037, 0.4588, 0.2802, 0.0))
        pgm_function524.set_cpd((3, 3), (
            0.0, 0.00010001, 0.00080008, 0.00410041, 0.02540254, 0.14331433, 0.42124212, 0.4050405, 0.0))
        pgm_function524.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor525 = self.new_factor(R_SUR_ALLCV_CA, R_SUR_LSLOW_CA, R_SUR_DSLOW_CA)
        pgm_function525 = pgm_factor525.set_cpt()
        pgm_function525.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function525.set_cpd((1, 0), (0.02359764, 0.25787421, 0.64033597, 0.07809219, 9.999e-05, 0.0, 0.0, 0.0, 0.0))
        pgm_function525.set_cpd((2, 0), (0.0, 0.0021, 0.1149, 0.7277, 0.1553, 0.0, 0.0, 0.0, 0.0))
        pgm_function525.set_cpd((3, 0), (0.0003, 0.0011, 0.005, 0.0205, 0.087, 0.2822, 0.4514, 0.1525, 0.0))
        pgm_function525.set_cpd((4, 0),
                                (0.0, 0.0, 9.999e-05, 0.00029997, 0.00219978, 0.01919808, 0.12518748, 0.8530147, 0.0))
        pgm_function525.set_cpd((0, 1), (0.03049695, 0.96720328, 0.00229977, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function525.set_cpd((1, 1), (0.0017, 0.0421, 0.4597, 0.4852, 0.0113, 0.0, 0.0, 0.0, 0.0))
        pgm_function525.set_cpd((2, 1), (0.0, 0.0001, 0.0146, 0.3403, 0.6424, 0.0026, 0.0, 0.0, 0.0))
        pgm_function525.set_cpd((3, 1), (
            0.00010002, 0.00040008, 0.00210042, 0.01010202, 0.05161032, 0.21844369, 0.46469294, 0.25255051, 0.0))
        pgm_function525.set_cpd((4, 1),
                                (0.0, 0.0, 0.0, 0.00019998, 0.00139986, 0.01369863, 0.10288971, 0.88181182, 0.0))
        pgm_function525.set_cpd((0, 2), (0.00039996, 0.06189381, 0.88811119, 0.04959504, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function525.set_cpd((1, 2),
                                (0.0, 0.00190019, 0.07490749, 0.56945695, 0.35323532, 0.00050005, 0.0, 0.0, 0.0))
        pgm_function525.set_cpd((2, 2), (0.0, 0.0, 0.0007, 0.0498, 0.764, 0.1854, 0.0001, 0.0, 0.0))
        pgm_function525.set_cpd((3, 2), (
            0.0, 0.00010001, 0.00060006, 0.00340034, 0.02230223, 0.13361336, 0.41454145, 0.42544254, 0.0))
        pgm_function525.set_cpd((4, 2),
                                (0.0, 0.0, 0.0, 0.00010001, 0.00070007, 0.00860086, 0.07820782, 0.91239124, 0.0))
        pgm_function525.set_cpd((0, 3), (0.0, 0.0001, 0.0655, 0.9082, 0.0262, 0.0, 0.0, 0.0, 0.0))
        pgm_function525.set_cpd((1, 3), (0.0, 0.0, 0.00220022, 0.10511051, 0.82518252, 0.06750675, 0.0, 0.0, 0.0))
        pgm_function525.set_cpd((2, 3), (0.0, 0.0, 0.0, 0.0012, 0.137, 0.8421, 0.0197, 0.0, 0.0))
        pgm_function525.set_cpd((3, 3), (0.0, 0.0, 0.0001, 0.0008, 0.0073, 0.0649, 0.3063, 0.6206, 0.0))
        pgm_function525.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.00030003, 0.0050005, 0.05640564, 0.93829383, 0.0))
        pgm_function525.set_cpd((0, 4), (0.0, 0.0, 0.0001, 0.0555, 0.937, 0.0074, 0.0, 0.0, 0.0))
        pgm_function525.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.00220022, 0.170017, 0.80628063, 0.02150215, 0.0, 0.0))
        pgm_function525.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 0.0034, 0.4375, 0.5591, 0.0, 0.0))
        pgm_function525.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.00010001, 0.00160016, 0.02260226, 0.17471747, 0.8009801, 0.0))
        pgm_function525.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 0.0001, 0.0026, 0.0379, 0.9594, 0.0))
        pgm_function525.set_cpd((0, 5), (0.0, 0.0, 0.0, 0.0002, 0.0491, 0.8863, 0.0644, 0.0, 0.0))
        pgm_function525.set_cpd((1, 5), (0.0, 0.0, 0.0, 0.0, 0.00219978, 0.23377662, 0.7620238, 0.0019998, 0.0))
        pgm_function525.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.02080208, 0.80948095, 0.16971697, 0.0))
        pgm_function525.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.00020002, 0.00520052, 0.07260726, 0.9219922, 0.0))
        pgm_function525.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0012, 0.023, 0.9758, 0.0))
        pgm_function525.set_cpd((0, 6), (0.0, 0.0, 0.0, 0.0, 0.00029997, 0.09559044, 0.89661034, 0.00749925, 0.0))
        pgm_function525.set_cpd((1, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.01009899, 0.48945105, 0.50044996, 0.0))
        pgm_function525.set_cpd((2, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.00010001, 0.03920392, 0.96069607, 0.0))
        pgm_function525.set_cpd((3, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.00120012, 0.02960296, 0.96919692, 0.0))
        pgm_function525.set_cpd((4, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0005, 0.014, 0.9855, 0.0))
        pgm_function525.set_cpd((0, 7), (
            0.00020002, 0.00060006, 0.00190019, 0.00640064, 0.02470247, 0.09740974, 0.28552855, 0.58325833, 0.0))
        pgm_function525.set_cpd((1, 7), (0.0001, 0.0002, 0.0007, 0.0026, 0.0117, 0.0585, 0.2222, 0.704, 0.0))
        pgm_function525.set_cpd((2, 7), (0.0, 0.0001, 0.0002, 0.0009, 0.0051, 0.0329, 0.1636, 0.7972, 0.0))
        pgm_function525.set_cpd((3, 7), (0.0, 0.0, 0.0001, 0.0004, 0.0022, 0.0159, 0.0994, 0.882, 0.0))
        pgm_function525.set_cpd((4, 7), (0.0, 0.0, 0.0, 0.0001, 0.0006, 0.0058, 0.0523, 0.9412, 0.0))
        pgm_function525.set_cpd((0, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function525.set_cpd((1, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function525.set_cpd((2, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function525.set_cpd((3, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function525.set_cpd((4, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor526 = self.new_factor(R_SUR_CV_CA, R_SUR_ALLCV_CA)
        pgm_function526 = pgm_factor526.set_cpt()
        pgm_function526.set_cpd((0,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00109989, 0.03779622, 0.29927007, 0.42315768,
            0.19018098,
            0.04509549, 0.00339966))
        pgm_function526.set_cpd((1,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00020002, 0.01570157, 0.17281728, 0.38253825, 0.31873187,
            0.09460946,
            0.01350135, 0.00180018, 0.00010001))
        pgm_function526.set_cpd((2,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.0103, 0.1527, 0.389, 0.3032, 0.1168, 0.0247, 0.003, 0.0002, 0.0,
            0.0))
        pgm_function526.set_cpd((3,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0006, 0.0554, 0.3435, 0.4067, 0.1669, 0.0241, 0.0026, 0.0002, 0.0, 0.0, 0.0,
            0.0))
        pgm_function526.set_cpd((4,), (
            0.0, 0.0, 0.0, 0.0, 0.0054, 0.2321, 0.5116, 0.2174, 0.0304, 0.003, 0.0001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function526.set_cpd((5,), (
            0.0, 0.0, 0.0, 0.09980998, 0.56675668, 0.28572857, 0.0440044, 0.00350035, 0.00020002, 0.0, 0.0, 0.0, 0.0,
            0.0,
            0.0, 0.0, 0.0))
        pgm_function526.set_cpd((6,), (
            0.0, 0.0, 0.14628537, 0.69093091, 0.15288471, 0.00949905, 0.00039996, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0,
            0.0, 0.0))
        pgm_function526.set_cpd((7,), (
            0.0, 0.1754, 0.7847, 0.0388, 0.0011, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function526.set_cpd((8,),
                                (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor527 = self.new_factor(L_LNLW_MED_SEV)
        pgm_function527 = pgm_factor527.set_cpt()
        pgm_function527.set_cpd((), (0.895, 0.06, 0.03, 0.01, 0.005))
        pgm_factor528 = self.new_factor(L_LNLW_MED_PATHO)
        pgm_function528 = pgm_factor528.set_cpt()
        pgm_function528.set_cpd((), (0.8, 0.12, 0.07, 0.005, 0.005))
        pgm_factor529 = self.new_factor(L_LNLW_MEDD2_DISP_WD, L_LNLW_MED_SEV, L_LNLW_MED_PATHO)
        pgm_function529 = pgm_factor529.set_cpt()
        pgm_function529.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function529.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function529.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function529.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function529.set_cpd((4, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function529.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function529.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0))
        pgm_function529.set_cpd((2, 1), (0.0, 0.5, 0.5, 0.0))
        pgm_function529.set_cpd((3, 1), (0.0, 0.1, 0.5, 0.4))
        pgm_function529.set_cpd((4, 1), (0.0, 0.0, 0.5, 0.5))
        pgm_function529.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function529.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function529.set_cpd((2, 2), (0.5, 0.5, 0.0, 0.0))
        pgm_function529.set_cpd((3, 2), (0.3, 0.5, 0.2, 0.0))
        pgm_function529.set_cpd((4, 2), (0.0, 0.5, 0.5, 0.0))
        pgm_function529.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function529.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function529.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function529.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function529.set_cpd((4, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function529.set_cpd((0, 4), (0.0, 0.0, 0.0, 1.0))
        pgm_function529.set_cpd((1, 4), (0.0, 0.0, 0.0, 1.0))
        pgm_function529.set_cpd((2, 4), (0.0, 0.0, 0.0, 1.0))
        pgm_function529.set_cpd((3, 4), (0.0, 0.0, 0.0, 1.0))
        pgm_function529.set_cpd((4, 4), (0.0, 0.0, 0.0, 1.0))
        pgm_factor530 = self.new_factor(L_DIFFN_MEDD2_DISP, DIFFN_S_SEV_DIST, DIFFN_PATHO)
        pgm_function530 = pgm_factor530.set_cpt()
        pgm_function530.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function530.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function530.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function530.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function530.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function530.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0))
        pgm_function530.set_cpd((2, 1), (0.0, 0.5, 0.5, 0.0))
        pgm_function530.set_cpd((3, 1), (0.0, 0.1, 0.5, 0.4))
        pgm_function530.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function530.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function530.set_cpd((2, 2), (0.5, 0.5, 0.0, 0.0))
        pgm_function530.set_cpd((3, 2), (0.0, 0.5, 0.5, 0.0))
        pgm_function530.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function530.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function530.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function530.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function530.set_cpd((0, 4), (0.0, 0.0, 0.0, 1.0))
        pgm_function530.set_cpd((1, 4), (0.0, 0.0, 0.0, 1.0))
        pgm_function530.set_cpd((2, 4), (0.0, 0.0, 0.0, 1.0))
        pgm_function530.set_cpd((3, 4), (0.0, 0.0, 0.0, 1.0))
        pgm_factor531 = self.new_factor(L_DIFFN_LNLW_MEDD2_DISP_WD, L_LNLW_MEDD2_DISP_WD, L_DIFFN_MEDD2_DISP)
        pgm_function531 = pgm_factor531.set_cpt()
        pgm_function531.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function531.set_cpd((1, 0), (0.0749, 0.8229, 0.1022, 0.0))
        pgm_function531.set_cpd((2, 0), (0.0, 0.06260626, 0.93739374, 0.0))
        pgm_function531.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function531.set_cpd((0, 1), (0.0749, 0.8229, 0.1022, 0.0))
        pgm_function531.set_cpd((1, 1), (0.0047, 0.1786, 0.8167, 0.0))
        pgm_function531.set_cpd((2, 1), (0.0, 0.019, 0.9795, 0.0015))
        pgm_function531.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function531.set_cpd((0, 2), (0.0, 0.06260626, 0.93739374, 0.0))
        pgm_function531.set_cpd((1, 2), (0.0, 0.019, 0.9795, 0.0015))
        pgm_function531.set_cpd((2, 2), (0.0, 0.0001, 0.0833, 0.9166))
        pgm_function531.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function531.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function531.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function531.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function531.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor532 = self.new_factor(L_MEDD2_DISP_WD, L_DIFFN_LNLW_MEDD2_DISP_WD)
        pgm_function532 = pgm_factor532.set_cpt()
        pgm_function532.set_cpd((0,), (1.0, 0.0, 0.0, 0.0))
        pgm_function532.set_cpd((1,), (0.0, 1.0, 0.0, 0.0))
        pgm_function532.set_cpd((2,), (0.0, 0.0, 1.0, 0.0))
        pgm_function532.set_cpd((3,), (0.0, 0.0, 0.0, 1.0))
        pgm_factor533 = self.new_factor(L_LNLBE_MEDD2_DISP_EW)
        pgm_function533 = pgm_factor533.set_cpt()
        pgm_function533.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor534 = self.new_factor(L_MEDD2_DISP_EW, L_DIFFN_MEDD2_DISP, L_LNLBE_MEDD2_DISP_EW)
        pgm_function534 = pgm_factor534.set_cpt()
        pgm_function534.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function534.set_cpd((1, 0), (0.0749, 0.8229, 0.1022, 0.0))
        pgm_function534.set_cpd((2, 0), (0.0, 0.06260626, 0.93739374, 0.0))
        pgm_function534.set_cpd((3, 0), (0.0, 0.00790079, 0.60286029, 0.38923892))
        pgm_function534.set_cpd((0, 1), (0.0749, 0.8229, 0.1022, 0.0))
        pgm_function534.set_cpd((1, 1), (0.0047, 0.1786, 0.8167, 0.0))
        pgm_function534.set_cpd((2, 1), (0.0, 0.019, 0.9795, 0.0015))
        pgm_function534.set_cpd((3, 1), (0.0, 0.0001, 0.0069, 0.993))
        pgm_function534.set_cpd((0, 2), (0.0, 0.06260626, 0.93739374, 0.0))
        pgm_function534.set_cpd((1, 2), (0.0, 0.019, 0.9795, 0.0015))
        pgm_function534.set_cpd((2, 2), (0.0, 0.0001, 0.0833, 0.9166))
        pgm_function534.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function534.set_cpd((0, 3), (0.0, 0.00790079, 0.60286029, 0.38923892))
        pgm_function534.set_cpd((1, 3), (0.0, 0.0001, 0.0069, 0.993))
        pgm_function534.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function534.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor535 = self.new_factor(L_MEDD2_DISP_EWD, L_MEDD2_DISP_WD, L_MEDD2_DISP_EW)
        pgm_function535 = pgm_factor535.set_cpt()
        pgm_function535.set_cpd((0, 0), (0.0, 0.0, 0.0742, 0.9045, 0.0213, 0.0, 0.0, 0.0, 0.0))
        pgm_function535.set_cpd((1, 0), (0.0, 0.0, 0.0, 0.0, 0.0742, 0.9045, 0.0213, 0.0, 0.0))
        pgm_function535.set_cpd((2, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.133, 0.867))
        pgm_function535.set_cpd((3, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.133, 0.867))
        pgm_function535.set_cpd((0, 1), (0.0001, 0.2215, 0.7732, 0.0052, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function535.set_cpd((1, 1), (0.0, 0.0, 0.0, 0.13151315, 0.85768577, 0.01080108, 0.0, 0.0, 0.0))
        pgm_function535.set_cpd((2, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0108, 0.8577, 0.1315))
        pgm_function535.set_cpd((3, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0108, 0.8577, 0.1315))
        pgm_function535.set_cpd((0, 2), (0.1315, 0.8577, 0.0108, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function535.set_cpd((1, 2), (0.0, 0.0, 0.0742, 0.9045, 0.0213, 0.0, 0.0, 0.0, 0.0))
        pgm_function535.set_cpd((2, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0052, 0.7732, 0.2215, 0.0001))
        pgm_function535.set_cpd((3, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0052, 0.7732, 0.2215, 0.0001))
        pgm_function535.set_cpd((0, 3), (0.9933, 0.0067, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function535.set_cpd((1, 3), (0.0404, 0.9192, 0.0404, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function535.set_cpd((2, 3), (0.0, 0.0, 0.0213, 0.9045, 0.0742, 0.0, 0.0, 0.0, 0.0))
        pgm_function535.set_cpd((3, 3), (0.0, 0.0, 0.0213, 0.9045, 0.0742, 0.0, 0.0, 0.0, 0.0))
        pgm_factor536 = self.new_factor(L_DIFFN_MEDD2_BLOCK, DIFFN_S_SEV_DIST, DIFFN_PATHO)
        pgm_function536 = pgm_factor536.set_cpt()
        pgm_function536.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function536.set_cpd((1, 0), (0.8, 0.2, 0.0, 0.0, 0.0))
        pgm_function536.set_cpd((2, 0), (0.6, 0.4, 0.0, 0.0, 0.0))
        pgm_function536.set_cpd((3, 0), (0.25, 0.5, 0.25, 0.0, 0.0))
        pgm_function536.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function536.set_cpd((1, 1), (0.2, 0.5, 0.3, 0.0, 0.0))
        pgm_function536.set_cpd((2, 1), (0.0, 0.2, 0.5, 0.3, 0.0))
        pgm_function536.set_cpd((3, 1), (0.0, 0.0, 0.4, 0.5, 0.1))
        pgm_function536.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function536.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function536.set_cpd((2, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function536.set_cpd((3, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function536.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function536.set_cpd((1, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function536.set_cpd((2, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function536.set_cpd((3, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function536.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function536.set_cpd((1, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function536.set_cpd((2, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function536.set_cpd((3, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor537 = self.new_factor(L_LNLBE_MEDD2_BLOCK_EW)
        pgm_function537 = pgm_factor537.set_cpt()
        pgm_function537.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor538 = self.new_factor(L_MEDD2_BLOCK_EW, L_DIFFN_MEDD2_BLOCK, L_LNLBE_MEDD2_BLOCK_EW)
        pgm_function538 = pgm_factor538.set_cpt()
        pgm_function538.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function538.set_cpd((1, 0), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function538.set_cpd((2, 0), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function538.set_cpd((3, 0), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function538.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function538.set_cpd((0, 1), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function538.set_cpd((1, 1), (0.0001, 0.498, 0.5019, 0.0, 0.0))
        pgm_function538.set_cpd((2, 1), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function538.set_cpd((3, 1), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function538.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function538.set_cpd((0, 2), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function538.set_cpd((1, 2), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function538.set_cpd((2, 2), (0.0, 0.0007, 0.4328, 0.5665, 0.0))
        pgm_function538.set_cpd((3, 2), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function538.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function538.set_cpd((0, 3), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function538.set_cpd((1, 3), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function538.set_cpd((2, 3), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function538.set_cpd((3, 3), (0.00030003, 0.00110011, 0.01250125, 0.98609861, 0.0))
        pgm_function538.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function538.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function538.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function538.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function538.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function538.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor539 = self.new_factor(L_MEDD2_AMPR_EW, L_MEDD2_DISP_EWD, L_MEDD2_BLOCK_EW)
        pgm_function539 = pgm_factor539.set_cpt()
        pgm_function539.set_cpd((0, 0),
                                (0.0, 0.28267173, 0.71642836, 0.00089991, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function539.set_cpd((1, 0), (0.0, 0.0, 0.5547, 0.4268, 0.0183, 0.0002, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function539.set_cpd((2, 0), (
            0.0, 0.0, 0.0090009, 0.51275128, 0.41524152, 0.05890589, 0.00390039, 0.00020002, 0.0, 0.0, 0.0, 0.0))
        pgm_function539.set_cpd((3, 0),
                                (0.0, 0.0, 0.0, 0.0635, 0.4459, 0.3732, 0.0995, 0.0162, 0.0015, 0.0002, 0.0, 0.0))
        pgm_function539.set_cpd((4, 0), (
            0.0, 0.0, 0.0, 0.00290029, 0.11411141, 0.39513951, 0.31983198, 0.13151315, 0.02980298, 0.00580058,
            0.00090009,
            0.0))
        pgm_function539.set_cpd((5, 0),
                                (0.0, 0.0, 0.0, 0.0001, 0.0136, 0.1578, 0.3285, 0.2966, 0.1404, 0.0483, 0.0135, 0.0012))
        pgm_function539.set_cpd((6, 0), (
            0.0, 0.0, 0.0, 0.0, 0.00120024, 0.0385077, 0.17463493, 0.30156031, 0.26135227, 0.14472895, 0.06511302,
            0.01290258))
        pgm_function539.set_cpd((7, 0),
                                (0.0, 0.0, 0.0, 0.0, 0.0001, 0.0062, 0.058, 0.1828, 0.2779, 0.2392, 0.1675, 0.0683))
        pgm_function539.set_cpd((8, 0),
                                (0.0, 0.0, 0.0, 0.0, 0.0, 0.0009, 0.0157, 0.0823, 0.2012, 0.2516, 0.2559, 0.1924))
        pgm_function539.set_cpd((0, 1), (0.0, 0.9103, 0.0897, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function539.set_cpd((1, 1), (0.0, 0.0004, 0.8945, 0.1036, 0.0015, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function539.set_cpd((2, 1), (
            0.0, 0.0, 0.1140114, 0.7169717, 0.15981598, 0.00890089, 0.00030003, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function539.set_cpd((3, 1),
                                (0.0, 0.0, 0.0026, 0.3111, 0.5155, 0.1499, 0.019, 0.0018, 0.0001, 0.0, 0.0, 0.0))
        pgm_function539.set_cpd((4, 1),
                                (0.0, 0.0, 0.0, 0.0451, 0.3717, 0.4039, 0.1433, 0.0313, 0.0041, 0.0005, 0.0001, 0.0))
        pgm_function539.set_cpd((5, 1),
                                (0.0, 0.0, 0.0, 0.0035, 0.1122, 0.3738, 0.3186, 0.1444, 0.0376, 0.0083, 0.0015, 0.0001))
        pgm_function539.set_cpd((6, 1), (
            0.0, 0.0, 0.0, 0.00020002, 0.02260226, 0.1890189, 0.33173317, 0.27442744, 0.12521252, 0.04310431,
            0.01240124,
            0.00130013))
        pgm_function539.set_cpd((7, 1), (
            0.0, 0.0, 0.0, 0.0, 0.00310031, 0.06150615, 0.21092109, 0.30513051, 0.23442344, 0.12171217, 0.05280528,
            0.01040104))
        pgm_function539.set_cpd((8, 1),
                                (0.0, 0.0, 0.0, 0.0, 0.0004, 0.0166, 0.1002, 0.2325, 0.2777, 0.2039, 0.1251, 0.0436))
        pgm_function539.set_cpd((0, 2), (0.0, 0.9974, 0.0026, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function539.set_cpd((1, 2), (0.0, 0.3856, 0.6048, 0.0095, 0.0001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function539.set_cpd((2, 2), (0.0, 0.0073, 0.8191, 0.1638, 0.0095, 0.0003, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function539.set_cpd((3, 2),
                                (0.0, 0.0001, 0.386, 0.4993, 0.1036, 0.0101, 0.0008, 0.0001, 0.0, 0.0, 0.0, 0.0))
        pgm_function539.set_cpd((4, 2),
                                (0.0, 0.0, 0.0913, 0.5259, 0.3027, 0.0681, 0.0104, 0.0014, 0.0002, 0.0, 0.0, 0.0))
        pgm_function539.set_cpd((5, 2), (
            0.0, 0.0, 0.0149985, 0.30686931, 0.42035796, 0.19288071, 0.05119488, 0.01139886, 0.00189981, 0.00029997,
            9.999e-05, 0.0))
        pgm_function539.set_cpd((6, 2),
                                (0.0, 0.0, 0.0023, 0.1333, 0.3728, 0.3075, 0.1292, 0.0421, 0.0099, 0.0024, 0.0005, 0.0))
        pgm_function539.set_cpd((7, 2), (
            0.0, 0.0, 0.00030003, 0.04440444, 0.24132413, 0.34313431, 0.22082208, 0.10251025, 0.03370337, 0.01040104,
            0.0030003, 0.00040004))
        pgm_function539.set_cpd((8, 2),
                                (0.0, 0.0, 0.0, 0.0138, 0.1311, 0.2956, 0.2729, 0.1711, 0.0745, 0.0286, 0.0104, 0.002))
        pgm_function539.set_cpd((0, 3), (
            0.0, 0.94670533, 0.04919508, 0.00349965, 0.00049995, 9.999e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function539.set_cpd((1, 3), (
            0.0, 0.87211279, 0.1109889, 0.01349865, 0.00249975, 0.00059994, 0.00019998, 9.999e-05, 0.0, 0.0, 0.0, 0.0))
        pgm_function539.set_cpd((2, 3), (
            0.0, 0.77825565, 0.18013603, 0.03120624, 0.0075015, 0.0020004, 0.00060012, 0.00020004, 0.00010002, 0.0, 0.0,
            0.0))
        pgm_function539.set_cpd((3, 3), (
            0.0, 0.678, 0.2436, 0.0548, 0.0156, 0.005, 0.0018, 0.0007, 0.0003, 0.0001, 0.0001, 0.0))
        pgm_function539.set_cpd((4, 3), (
            0.0, 0.5789, 0.2957, 0.082, 0.027, 0.0096, 0.0037, 0.0017, 0.0007, 0.0004, 0.0002, 0.0001))
        pgm_function539.set_cpd((5, 3), (
            0.0, 0.485, 0.334, 0.1106, 0.0411, 0.0162, 0.0068, 0.0033, 0.0015, 0.0008, 0.0004, 0.0003))
        pgm_function539.set_cpd((6, 3), (
            0.0, 0.40484048, 0.35663566, 0.13671367, 0.05620562, 0.0240024, 0.01080108, 0.00540054, 0.00270027,
            0.00140014,
            0.00080008, 0.00050005))
        pgm_function539.set_cpd((7, 3), (
            0.0, 0.33163367, 0.36712657, 0.16126775, 0.07268546, 0.0334933, 0.0159968, 0.0084983, 0.00439912,
            0.00239952,
            0.0014997, 0.0009998))
        pgm_function539.set_cpd((8, 3), (
            0.0, 0.2731, 0.3669, 0.1808, 0.0881, 0.0434, 0.0217, 0.012, 0.0064, 0.0036, 0.0023, 0.0017))
        pgm_function539.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function539.set_cpd((1, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function539.set_cpd((2, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function539.set_cpd((3, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function539.set_cpd((4, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function539.set_cpd((5, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function539.set_cpd((6, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function539.set_cpd((7, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function539.set_cpd((8, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor540 = self.new_factor(L_LNLBE_MEDD2_LD_EW)
        pgm_function540 = pgm_factor540.set_cpt()
        pgm_function540.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor541 = self.new_factor(L_MEDD2_LD_EW, L_LNLBE_MEDD2_LD_EW)
        pgm_function541 = pgm_factor541.set_cpt()
        pgm_function541.set_cpd((0,), (1.0, 0.0, 0.0, 0.0))
        pgm_function541.set_cpd((1,), (0.0, 1.0, 0.0, 0.0))
        pgm_function541.set_cpd((2,), (0.0, 0.0, 1.0, 0.0))
        pgm_function541.set_cpd((3,), (0.0, 0.0, 0.0, 1.0))
        pgm_factor542 = self.new_factor(L_LNLBE_MEDD2_RD_EW)
        pgm_function542 = pgm_factor542.set_cpt()
        pgm_function542.set_cpd((), (1.0, 0.0, 0.0))
        pgm_factor543 = self.new_factor(L_MEDD2_RD_EW, L_LNLBE_MEDD2_RD_EW)
        pgm_function543 = pgm_factor543.set_cpt()
        pgm_function543.set_cpd((0,), (1.0, 0.0, 0.0))
        pgm_function543.set_cpd((1,), (0.0, 1.0, 0.0))
        pgm_function543.set_cpd((2,), (0.0, 0.0, 1.0))
        pgm_factor544 = self.new_factor(L_MEDD2_LSLOW_EW, L_MEDD2_LD_EW, L_MEDD2_RD_EW)
        pgm_function544 = pgm_factor544.set_cpt()
        pgm_function544.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function544.set_cpd((1, 0), (0.0185, 0.9561, 0.0254, 0.0, 0.0))
        pgm_function544.set_cpd((2, 0), (0.0, 0.0166, 0.9834, 0.0, 0.0))
        pgm_function544.set_cpd((3, 0), (0.0007, 0.002, 0.0219, 0.9754, 0.0))
        pgm_function544.set_cpd((0, 1), (0.00840084, 0.01190119, 0.06190619, 0.91739174, 0.00040004))
        pgm_function544.set_cpd((1, 1), (0.00690069, 0.010001, 0.05350535, 0.92869287, 0.00090009))
        pgm_function544.set_cpd((2, 1), (0.00559944, 0.00829917, 0.04519548, 0.93890611, 0.0019998))
        pgm_function544.set_cpd((3, 1), (0.0023, 0.0036, 0.0217, 0.8326, 0.1398))
        pgm_function544.set_cpd((0, 2), (0.00529947, 0.00619938, 0.02639736, 0.20817918, 0.75392461))
        pgm_function544.set_cpd((1, 2), (0.0049, 0.0057, 0.0244, 0.1966, 0.7684))
        pgm_function544.set_cpd((2, 2), (0.00440044, 0.00520052, 0.02240224, 0.18391839, 0.78407841))
        pgm_function544.set_cpd((3, 2), (0.0028, 0.0033, 0.0145, 0.1304, 0.849))
        pgm_factor545 = self.new_factor(L_LNLW_MEDD2_SALOSS_WD, L_LNLW_MED_SEV, L_LNLW_MED_PATHO)
        pgm_function545 = pgm_factor545.set_cpt()
        pgm_function545.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function545.set_cpd((1, 0), (0.5, 0.5, 0.0, 0.0, 0.0))
        pgm_function545.set_cpd((2, 0), (0.0, 0.5, 0.5, 0.0, 0.0))
        pgm_function545.set_cpd((3, 0), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function545.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.4, 0.6))
        pgm_function545.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function545.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0, 0.0))
        pgm_function545.set_cpd((2, 1), (0.2, 0.5, 0.3, 0.0, 0.0))
        pgm_function545.set_cpd((3, 1), (0.0, 0.2, 0.5, 0.3, 0.0))
        pgm_function545.set_cpd((4, 1), (0.0, 0.1, 0.4, 0.4, 0.1))
        pgm_function545.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function545.set_cpd((1, 2), (0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function545.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function545.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function545.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function545.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function545.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function545.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function545.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function545.set_cpd((4, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function545.set_cpd((0, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function545.set_cpd((1, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function545.set_cpd((2, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function545.set_cpd((3, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function545.set_cpd((4, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_factor546 = self.new_factor(L_DIFFN_MEDD2_SALOSS, DIFFN_S_SEV_DIST, DIFFN_PATHO)
        pgm_function546 = pgm_factor546.set_cpt()
        pgm_function546.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function546.set_cpd((1, 0), (0.5, 0.5, 0.0, 0.0, 0.0))
        pgm_function546.set_cpd((2, 0), (0.0, 0.5, 0.5, 0.0, 0.0))
        pgm_function546.set_cpd((3, 0), (0.0, 0.0, 0.0, 0.7, 0.3))
        pgm_function546.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function546.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0, 0.0))
        pgm_function546.set_cpd((2, 1), (0.4, 0.3, 0.3, 0.0, 0.0))
        pgm_function546.set_cpd((3, 1), (0.0, 0.3, 0.5, 0.2, 0.0))
        pgm_function546.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function546.set_cpd((1, 2), (0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function546.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function546.set_cpd((3, 2), (0.0, 0.0, 0.0, 0.7, 0.3))
        pgm_function546.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function546.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function546.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function546.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function546.set_cpd((0, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function546.set_cpd((1, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function546.set_cpd((2, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function546.set_cpd((3, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_factor547 = self.new_factor(L_DIFFN_LNLW_MEDD2_SALOSS, L_LNLW_MEDD2_SALOSS_WD, L_DIFFN_MEDD2_SALOSS)
        pgm_function547 = pgm_factor547.set_cpt()
        pgm_function547.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function547.set_cpd((1, 0), (0.0073, 0.9812, 0.0115, 0.0, 0.0))
        pgm_function547.set_cpd((2, 0), (0.0017, 0.1306, 0.867, 0.0007, 0.0))
        pgm_function547.set_cpd((3, 0), (0.0, 0.0003, 0.0212, 0.9785, 0.0))
        pgm_function547.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function547.set_cpd((0, 1), (0.0073, 0.9812, 0.0115, 0.0, 0.0))
        pgm_function547.set_cpd((1, 1), (0.0, 0.0289, 0.9711, 0.0, 0.0))
        pgm_function547.set_cpd((2, 1), (0.0, 0.0097, 0.5989, 0.3914, 0.0))
        pgm_function547.set_cpd((3, 1), (0.0, 0.0, 0.0017, 0.9983, 0.0))
        pgm_function547.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function547.set_cpd((0, 2), (0.0017, 0.1306, 0.867, 0.0007, 0.0))
        pgm_function547.set_cpd((1, 2), (0.0, 0.0097, 0.5989, 0.3914, 0.0))
        pgm_function547.set_cpd((2, 2), (0.0, 0.00049995, 0.03309669, 0.96640336, 0.0))
        pgm_function547.set_cpd((3, 2), (0.0, 0.0, 0.0008, 0.9992, 0.0))
        pgm_function547.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function547.set_cpd((0, 3), (0.0, 0.0003, 0.0212, 0.9785, 0.0))
        pgm_function547.set_cpd((1, 3), (0.0, 0.0, 0.0017, 0.9983, 0.0))
        pgm_function547.set_cpd((2, 3), (0.0, 0.0, 0.0008, 0.9992, 0.0))
        pgm_function547.set_cpd((3, 3), (0.0, 0.0, 0.0001, 0.9999, 0.0))
        pgm_function547.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function547.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function547.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function547.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function547.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function547.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor548 = self.new_factor(L_LNLBE_MEDD2_SALOSS_EW)
        pgm_function548 = pgm_factor548.set_cpt()
        pgm_function548.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor549 = self.new_factor(L_MEDD2_SALOSS, L_DIFFN_LNLW_MEDD2_SALOSS, L_LNLBE_MEDD2_SALOSS_EW)
        pgm_function549 = pgm_factor549.set_cpt()
        pgm_function549.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function549.set_cpd((1, 0), (0.0073, 0.9812, 0.0115, 0.0, 0.0))
        pgm_function549.set_cpd((2, 0), (0.0017, 0.1306, 0.867, 0.0007, 0.0))
        pgm_function549.set_cpd((3, 0), (0.0, 0.0003, 0.0212, 0.9785, 0.0))
        pgm_function549.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function549.set_cpd((0, 1), (0.0073, 0.9812, 0.0115, 0.0, 0.0))
        pgm_function549.set_cpd((1, 1), (0.0, 0.0289, 0.9711, 0.0, 0.0))
        pgm_function549.set_cpd((2, 1), (0.0, 0.0097, 0.5989, 0.3914, 0.0))
        pgm_function549.set_cpd((3, 1), (0.0, 0.0, 0.0017, 0.9983, 0.0))
        pgm_function549.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function549.set_cpd((0, 2), (0.0017, 0.1306, 0.867, 0.0007, 0.0))
        pgm_function549.set_cpd((1, 2), (0.0, 0.0097, 0.5989, 0.3914, 0.0))
        pgm_function549.set_cpd((2, 2), (0.0, 0.00049995, 0.03309669, 0.96640336, 0.0))
        pgm_function549.set_cpd((3, 2), (0.0, 0.0, 0.0008, 0.9992, 0.0))
        pgm_function549.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function549.set_cpd((0, 3), (0.0, 0.0003, 0.0212, 0.9785, 0.0))
        pgm_function549.set_cpd((1, 3), (0.0, 0.0, 0.0017, 0.9983, 0.0))
        pgm_function549.set_cpd((2, 3), (0.0, 0.0, 0.0008, 0.9992, 0.0))
        pgm_function549.set_cpd((3, 3), (0.0, 0.0, 0.0001, 0.9999, 0.0))
        pgm_function549.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function549.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function549.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function549.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function549.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function549.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor550 = self.new_factor(L_DIFFN_MEDD2_DIFSLOW, DIFFN_S_SEV_DIST, DIFFN_PATHO)
        pgm_function550 = pgm_factor550.set_cpt()
        pgm_function550.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function550.set_cpd((1, 0), (0.0, 0.5, 0.5, 0.0))
        pgm_function550.set_cpd((2, 0), (0.0, 0.2, 0.6, 0.2))
        pgm_function550.set_cpd((3, 0), (0.0, 0.1, 0.6, 0.3))
        pgm_function550.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function550.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0))
        pgm_function550.set_cpd((2, 1), (0.2, 0.4, 0.3, 0.1))
        pgm_function550.set_cpd((3, 1), (0.2, 0.4, 0.3, 0.1))
        pgm_function550.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function550.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function550.set_cpd((2, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function550.set_cpd((3, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function550.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function550.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function550.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function550.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function550.set_cpd((0, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_function550.set_cpd((1, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_function550.set_cpd((2, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_function550.set_cpd((3, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_factor551 = self.new_factor(L_MEDD2_DIFSLOW_EW, L_DIFFN_MEDD2_DIFSLOW)
        pgm_function551 = pgm_factor551.set_cpt()
        pgm_function551.set_cpd((0,), (1.0, 0.0, 0.0, 0.0))
        pgm_function551.set_cpd((1,), (0.0, 1.0, 0.0, 0.0))
        pgm_function551.set_cpd((2,), (0.0, 0.0, 1.0, 0.0))
        pgm_function551.set_cpd((3,), (0.0, 0.0, 0.0, 1.0))
        pgm_factor552 = self.new_factor(L_MEDD2_DSLOW_EW, L_MEDD2_SALOSS, L_MEDD2_DIFSLOW_EW)
        pgm_function552 = pgm_factor552.set_cpt()
        pgm_function552.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function552.set_cpd((1, 0), (0.1036, 0.8964, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function552.set_cpd((2, 0), (0.00059994, 0.99730027, 0.00209979, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function552.set_cpd((3, 0), (0.0001, 0.0629, 0.9278, 0.0092, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function552.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function552.set_cpd((0, 1), (0.0532, 0.2387, 0.495, 0.2072, 0.0059, 0.0, 0.0, 0.0, 0.0))
        pgm_function552.set_cpd((1, 1), (0.01780178, 0.1190119, 0.44814481, 0.38543854, 0.02960296, 0.0, 0.0, 0.0, 0.0))
        pgm_function552.set_cpd((2, 1), (0.0048, 0.0476, 0.3148, 0.5311, 0.1016, 0.0001, 0.0, 0.0, 0.0))
        pgm_function552.set_cpd((3, 1),
                                (0.00060006, 0.00920092, 0.1160116, 0.48574857, 0.38353835, 0.00490049, 0.0, 0.0, 0.0))
        pgm_function552.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function552.set_cpd((0, 2), (0.0007, 0.0063, 0.0614, 0.3006, 0.5524, 0.0781, 0.0005, 0.0, 0.0))
        pgm_function552.set_cpd((1, 2), (0.0002, 0.0021, 0.0283, 0.1995, 0.5939, 0.1737, 0.0023, 0.0, 0.0))
        pgm_function552.set_cpd((2, 2),
                                (0.0, 0.00060006, 0.01140114, 0.11471147, 0.54455446, 0.31963196, 0.00910091, 0.0, 0.0))
        pgm_function552.set_cpd((3, 2),
                                (0.0, 0.00010001, 0.00240024, 0.03740374, 0.33273327, 0.56705671, 0.06030603, 0.0, 0.0))
        pgm_function552.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function552.set_cpd((0, 3), (0.0003, 0.0011, 0.005, 0.0205, 0.087, 0.2822, 0.4514, 0.1525, 0.0))
        pgm_function552.set_cpd((1, 3), (0.0002, 0.0006, 0.0029, 0.0133, 0.0634, 0.2436, 0.4657, 0.2103, 0.0))
        pgm_function552.set_cpd((2, 3), (
            0.00010001, 0.00030003, 0.00170017, 0.00830083, 0.04470447, 0.20312031, 0.46324632, 0.27852785, 0.0))
        pgm_function552.set_cpd((3, 3), (
            0.0, 0.00010001, 0.00070007, 0.00380038, 0.02430243, 0.14161416, 0.4240424, 0.40544054, 0.0))
        pgm_function552.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor553 = self.new_factor(L_MEDD2_ALLCV_EW, L_MEDD2_LSLOW_EW, L_MEDD2_DSLOW_EW)
        pgm_function553 = pgm_factor553.set_cpt()
        pgm_function553.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function553.set_cpd((1, 0), (0.0264, 0.9149, 0.0587, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function553.set_cpd((2, 0), (0.0, 0.0218, 0.9469, 0.0313, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function553.set_cpd((3, 0), (
            0.00030003, 0.00190019, 0.0140014, 0.07880788, 0.32383238, 0.45964596, 0.12121212, 0.00030003, 0.0))
        pgm_function553.set_cpd((4, 0),
                                (0.0, 0.0, 0.00010001, 0.00050005, 0.00410041, 0.03840384, 0.21452145, 0.74237424, 0.0))
        pgm_function553.set_cpd((0, 1), (0.03049695, 0.96720328, 0.00229977, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function553.set_cpd((1, 1), (0.0006, 0.0944, 0.8841, 0.0209, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function553.set_cpd((2, 1), (0.0, 0.0007, 0.2183, 0.779, 0.002, 0.0, 0.0, 0.0, 0.0))
        pgm_function553.set_cpd((3, 1), (
            9.999e-05, 0.00039996, 0.00429957, 0.03209679, 0.19558044, 0.50484952, 0.26037396, 0.00229977, 0.0))
        pgm_function553.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.00020002, 0.00210021, 0.02390239, 0.16481648, 0.8089809, 0.0))
        pgm_function553.set_cpd((0, 2), (0.00039996, 0.06189381, 0.88811119, 0.04959504, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function553.set_cpd((1, 2), (0.0, 0.0018, 0.1956, 0.786, 0.0166, 0.0, 0.0, 0.0, 0.0))
        pgm_function553.set_cpd((2, 2), (0.0, 0.0, 0.0077, 0.4577, 0.5345, 0.0001, 0.0, 0.0, 0.0))
        pgm_function553.set_cpd((3, 2), (0.0, 0.0001, 0.0007, 0.0074, 0.0735, 0.4044, 0.4938, 0.0201, 0.0))
        pgm_function553.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0001, 0.0008, 0.0123, 0.1119, 0.8749, 0.0))
        pgm_function553.set_cpd((0, 3), (0.0, 0.0001, 0.0655, 0.9082, 0.0262, 0.0, 0.0, 0.0, 0.0))
        pgm_function553.set_cpd((1, 3), (0.0, 0.0, 0.0026, 0.2655, 0.7316, 0.0003, 0.0, 0.0, 0.0))
        pgm_function553.set_cpd((2, 3), (0.0, 0.0, 0.0, 0.0166, 0.9182, 0.0652, 0.0, 0.0, 0.0))
        pgm_function553.set_cpd((3, 3), (0.0, 0.0, 0.0001, 0.001, 0.0172, 0.2179, 0.6479, 0.1159, 0.0))
        pgm_function553.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.0003, 0.0055, 0.0699, 0.9243, 0.0))
        pgm_function553.set_cpd((0, 4), (0.0, 0.0, 0.0001, 0.0555, 0.937, 0.0074, 0.0, 0.0, 0.0))
        pgm_function553.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0044, 0.5355, 0.46, 0.0001, 0.0, 0.0))
        pgm_function553.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 0.0398, 0.946, 0.0142, 0.0, 0.0))
        pgm_function553.set_cpd((3, 4), (0.0, 0.0, 0.0, 9.999e-05, 0.00179982, 0.05589441, 0.46005399, 0.48215178, 0.0))
        pgm_function553.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 0.0001, 0.0021, 0.039, 0.9588, 0.0))
        pgm_function553.set_cpd((0, 5), (0.0, 0.0, 0.0, 0.0002, 0.0491, 0.8863, 0.0644, 0.0, 0.0))
        pgm_function553.set_cpd((1, 5), (0.0, 0.0, 0.0, 0.0, 0.0047, 0.5053, 0.49, 0.0, 0.0))
        pgm_function553.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0002, 0.1104, 0.8881, 0.0013, 0.0))
        pgm_function553.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0001, 0.0041, 0.1033, 0.8925, 0.0))
        pgm_function553.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.00069993, 0.01889811, 0.98040196, 0.0))
        pgm_function553.set_cpd((0, 6), (0.0, 0.0, 0.0, 0.0, 0.00029997, 0.09559044, 0.89661034, 0.00749925, 0.0))
        pgm_function553.set_cpd((1, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0218, 0.8352, 0.143, 0.0))
        pgm_function553.set_cpd((2, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.002, 0.3203, 0.6777, 0.0))
        pgm_function553.set_cpd((3, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0003, 0.0194, 0.9803, 0.0))
        pgm_function553.set_cpd((4, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0002, 0.0093, 0.9905, 0.0))
        pgm_function553.set_cpd((0, 7), (
            0.00020002, 0.00060006, 0.00190019, 0.00640064, 0.02470247, 0.09740974, 0.28552855, 0.58325833, 0.0))
        pgm_function553.set_cpd((1, 7), (0.0001, 0.0003, 0.001, 0.0036, 0.0154, 0.0712, 0.2467, 0.6617, 0.0))
        pgm_function553.set_cpd((2, 7), (
            0.0, 0.00010001, 0.00050005, 0.00190019, 0.00930093, 0.05040504, 0.20722072, 0.73057306, 0.0))
        pgm_function553.set_cpd((3, 7), (0.0, 0.0, 0.0001, 0.0004, 0.0026, 0.019, 0.1153, 0.8626, 0.0))
        pgm_function553.set_cpd((4, 7), (0.0, 0.0, 0.0, 0.0001, 0.0006, 0.0062, 0.0562, 0.9369, 0.0))
        pgm_function553.set_cpd((0, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function553.set_cpd((1, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function553.set_cpd((2, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function553.set_cpd((3, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function553.set_cpd((4, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor554 = self.new_factor(L_MEDD2_CV_EW, L_MEDD2_ALLCV_EW)
        pgm_function554 = pgm_factor554.set_cpt()
        pgm_function554.set_cpd((0,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0012, 0.0172, 0.1126, 0.2484, 0.321, 0.1935,
            0.0803, 0.0258))
        pgm_function554.set_cpd((1,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0009999, 0.01489851, 0.09959004, 0.22617738, 0.29337066,
            0.22617738, 0.1019898, 0.02889711, 0.00649935, 0.00139986))
        pgm_function554.set_cpd((2,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00250025, 0.03170317, 0.14451445, 0.26392639, 0.29252925,
            0.1670167,
            0.06690669, 0.02450245, 0.00540054, 0.00090009, 0.00010001, 0.0))
        pgm_function554.set_cpd((3,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0005, 0.0189, 0.1567, 0.3371, 0.2862, 0.1429, 0.0465, 0.0095, 0.0014,
            0.0003,
            0.0, 0.0, 0.0, 0.0))
        pgm_function554.set_cpd((4,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.01049895, 0.15648435, 0.37786221, 0.30066993, 0.12518748, 0.02449755, 0.00419958,
            0.00049995, 9.999e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function554.set_cpd((5,), (
            0.0, 0.0, 0.0, 0.0045, 0.1674, 0.4536, 0.2834, 0.0774, 0.0118, 0.0017, 0.0002, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0))
        pgm_function554.set_cpd((6,), (
            0.0, 0.0, 0.01090109, 0.42284228, 0.44464446, 0.10661066, 0.01370137, 0.00120012, 0.00010001, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function554.set_cpd((7,), (
            0.0, 0.0199, 0.8041, 0.1629, 0.0125, 0.0006, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0,
            0.0))
        pgm_function554.set_cpd((8,), (
            1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor555 = self.new_factor(L_LNLW_MEDD2_BLOCK_WD, L_LNLW_MED_SEV, L_LNLW_MED_PATHO)
        pgm_function555 = pgm_factor555.set_cpt()
        pgm_function555.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function555.set_cpd((1, 0), (0.8, 0.2, 0.0, 0.0, 0.0))
        pgm_function555.set_cpd((2, 0), (0.3, 0.6, 0.1, 0.0, 0.0))
        pgm_function555.set_cpd((3, 0), (0.1, 0.5, 0.3, 0.1, 0.0))
        pgm_function555.set_cpd((4, 0), (0.0, 0.05, 0.2, 0.55, 0.2))
        pgm_function555.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function555.set_cpd((1, 1), (0.0, 0.5, 0.5, 0.0, 0.0))
        pgm_function555.set_cpd((2, 1), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function555.set_cpd((3, 1), (0.0, 0.0, 0.2, 0.6, 0.2))
        pgm_function555.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function555.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function555.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function555.set_cpd((2, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function555.set_cpd((3, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function555.set_cpd((4, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function555.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function555.set_cpd((1, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function555.set_cpd((2, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function555.set_cpd((3, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function555.set_cpd((4, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function555.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function555.set_cpd((1, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function555.set_cpd((2, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function555.set_cpd((3, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function555.set_cpd((4, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor556 = self.new_factor(L_MEDD2_BLOCK_WD, L_LNLW_MEDD2_BLOCK_WD, L_DIFFN_MEDD2_BLOCK)
        pgm_function556 = pgm_factor556.set_cpt()
        pgm_function556.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function556.set_cpd((1, 0), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function556.set_cpd((2, 0), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function556.set_cpd((3, 0), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function556.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function556.set_cpd((0, 1), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function556.set_cpd((1, 1), (0.0001, 0.498, 0.5019, 0.0, 0.0))
        pgm_function556.set_cpd((2, 1), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function556.set_cpd((3, 1), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function556.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function556.set_cpd((0, 2), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function556.set_cpd((1, 2), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function556.set_cpd((2, 2), (0.0, 0.0007, 0.4328, 0.5665, 0.0))
        pgm_function556.set_cpd((3, 2), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function556.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function556.set_cpd((0, 3), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function556.set_cpd((1, 3), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function556.set_cpd((2, 3), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function556.set_cpd((3, 3), (0.00030003, 0.00110011, 0.01250125, 0.98609861, 0.0))
        pgm_function556.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function556.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function556.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function556.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function556.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function556.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor557 = self.new_factor(L_MEDD2_EFFAXLOSS, L_MEDD2_BLOCK_WD, L_MEDD2_SALOSS)
        pgm_function557 = pgm_factor557.set_cpt()
        pgm_function557.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function557.set_cpd((1, 0), (0.0073, 0.9812, 0.0115, 0.0, 0.0))
        pgm_function557.set_cpd((2, 0), (0.0017, 0.1306, 0.867, 0.0007, 0.0))
        pgm_function557.set_cpd((3, 0), (0.0, 0.0003, 0.0212, 0.9785, 0.0))
        pgm_function557.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function557.set_cpd((0, 1), (0.0073, 0.9812, 0.0115, 0.0, 0.0))
        pgm_function557.set_cpd((1, 1), (0.0, 0.0289, 0.9711, 0.0, 0.0))
        pgm_function557.set_cpd((2, 1), (0.0, 0.0097, 0.5989, 0.3914, 0.0))
        pgm_function557.set_cpd((3, 1), (0.0, 0.0, 0.0017, 0.9983, 0.0))
        pgm_function557.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function557.set_cpd((0, 2), (0.0017, 0.1306, 0.867, 0.0007, 0.0))
        pgm_function557.set_cpd((1, 2), (0.0, 0.0097, 0.5989, 0.3914, 0.0))
        pgm_function557.set_cpd((2, 2), (0.0, 0.00049995, 0.03309669, 0.96640336, 0.0))
        pgm_function557.set_cpd((3, 2), (0.0, 0.0, 0.0008, 0.9992, 0.0))
        pgm_function557.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function557.set_cpd((0, 3), (0.0, 0.0003, 0.0212, 0.9785, 0.0))
        pgm_function557.set_cpd((1, 3), (0.0, 0.0, 0.0017, 0.9983, 0.0))
        pgm_function557.set_cpd((2, 3), (0.0, 0.0, 0.0008, 0.9992, 0.0))
        pgm_function557.set_cpd((3, 3), (0.0, 0.0, 0.0001, 0.9999, 0.0))
        pgm_function557.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function557.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function557.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function557.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function557.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function557.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor558 = self.new_factor(L_MEDD2_ALLAMP_WD, L_MEDD2_DISP_WD, L_MEDD2_EFFAXLOSS)
        pgm_function558 = pgm_factor558.set_cpt()
        pgm_function558.set_cpd((0, 0), (0.0, 0.0, 0.0, 0.0, 0.0215, 0.9785))
        pgm_function558.set_cpd((1, 0), (0.0, 0.0, 0.0, 0.3192, 0.6448, 0.036))
        pgm_function558.set_cpd((2, 0), (0.0, 0.0, 0.0051, 0.994, 0.0009, 0.0))
        pgm_function558.set_cpd((3, 0), (0.0, 0.0, 0.9945, 0.0055, 0.0, 0.0))
        pgm_function558.set_cpd((0, 1), (0.0, 0.0, 0.0, 0.3443, 0.6228, 0.0329))
        pgm_function558.set_cpd((1, 1), (0.0, 0.0, 0.04740474, 0.93949395, 0.01290129, 0.00020002))
        pgm_function558.set_cpd((2, 1), (0.0, 0.0, 0.9599, 0.0401, 0.0, 0.0))
        pgm_function558.set_cpd((3, 1), (0.0, 0.0, 0.9999, 0.0001, 0.0, 0.0))
        pgm_function558.set_cpd((0, 2), (0.0, 0.0, 0.0248, 0.9704, 0.0048, 0.0))
        pgm_function558.set_cpd((1, 2), (0.0, 0.0, 0.93309331, 0.06690669, 0.0, 0.0))
        pgm_function558.set_cpd((2, 2), (0.0, 0.0001, 0.9994, 0.0005, 0.0, 0.0))
        pgm_function558.set_cpd((3, 2), (0.0, 0.7508, 0.2492, 0.0, 0.0, 0.0))
        pgm_function558.set_cpd((0, 3), (0.0, 0.1028, 0.8793, 0.0178, 0.0001, 0.0))
        pgm_function558.set_cpd((1, 3), (0.0, 0.8756, 0.1237, 0.0007, 0.0, 0.0))
        pgm_function558.set_cpd((2, 3), (0.0, 0.9969, 0.0031, 0.0, 0.0, 0.0))
        pgm_function558.set_cpd((3, 3), (0.0, 0.9999, 0.0001, 0.0, 0.0, 0.0))
        pgm_function558.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function558.set_cpd((1, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function558.set_cpd((2, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function558.set_cpd((3, 4), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor559 = self.new_factor(L_MEDD2_AMP_WD, L_MEDD2_ALLAMP_WD)
        pgm_function559 = pgm_factor559.set_cpt()
        pgm_function559.set_cpd((0,), (
            0.75007501, 0.18781878, 0.04760476, 0.01120112, 0.00260026, 0.00060006, 0.00010001, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0))
        pgm_function559.set_cpd((1,), (
            0.3184, 0.2478, 0.178, 0.1158, 0.0688, 0.038, 0.0189, 0.0086, 0.0036, 0.0014, 0.0005, 0.0002, 0.0, 0.0,
            0.0))
        pgm_function559.set_cpd((2,), (
            0.01170117, 0.03920392, 0.09350935, 0.16761676, 0.21892189, 0.20952095, 0.14651465, 0.07470747, 0.02870287,
            0.00780078, 0.00160016, 0.00020002, 0.0, 0.0, 0.0))
        pgm_function559.set_cpd((3,), (
            0.0, 0.0, 9.999e-05, 0.00129987, 0.01089891, 0.05269473, 0.15628437, 0.27017298, 0.27427257, 0.16358364,
            0.05689431, 0.01219878, 0.00149985, 9.999e-05, 0.0))
        pgm_function559.set_cpd((4,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 9.999e-05, 0.00219978, 0.02179782, 0.10328967, 0.25917408, 0.32546745, 0.20917908,
            0.06709329, 0.01079892, 0.00089991))
        pgm_function559.set_cpd((5,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0004, 0.0072, 0.0656, 0.2449, 0.3735, 0.2388, 0.0624, 0.0072))
        pgm_factor560 = self.new_factor(L_LNLW_MEDD2_LD_WD, L_LNLW_MED_SEV, L_LNLW_MED_PATHO)
        pgm_function560 = pgm_factor560.set_cpt()
        pgm_function560.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function560.set_cpd((1, 0), (0.0, 1.0, 0.0, 0.0))
        pgm_function560.set_cpd((2, 0), (0.0, 0.0, 1.0, 0.0))
        pgm_function560.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function560.set_cpd((4, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function560.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function560.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0))
        pgm_function560.set_cpd((2, 1), (0.25, 0.5, 0.25, 0.0))
        pgm_function560.set_cpd((3, 1), (0.05, 0.3, 0.5, 0.15))
        pgm_function560.set_cpd((4, 1), (0.25, 0.25, 0.25, 0.25))
        pgm_function560.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function560.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function560.set_cpd((2, 2), (0.5, 0.5, 0.0, 0.0))
        pgm_function560.set_cpd((3, 2), (0.0, 1.0, 0.0, 0.0))
        pgm_function560.set_cpd((4, 2), (0.0, 0.5, 0.5, 0.0))
        pgm_function560.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function560.set_cpd((1, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function560.set_cpd((2, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function560.set_cpd((3, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function560.set_cpd((4, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function560.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function560.set_cpd((1, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function560.set_cpd((2, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function560.set_cpd((3, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_function560.set_cpd((4, 4), (1.0, 0.0, 0.0, 0.0))
        pgm_factor561 = self.new_factor(L_MEDD2_LD_WD, L_LNLW_MEDD2_LD_WD)
        pgm_function561 = pgm_factor561.set_cpt()
        pgm_function561.set_cpd((0,), (1.0, 0.0, 0.0, 0.0))
        pgm_function561.set_cpd((1,), (0.0, 1.0, 0.0, 0.0))
        pgm_function561.set_cpd((2,), (0.0, 0.0, 1.0, 0.0))
        pgm_function561.set_cpd((3,), (0.0, 0.0, 0.0, 1.0))
        pgm_factor562 = self.new_factor(L_LNLW_MEDD2_RD_WD, L_LNLW_MED_PATHO)
        pgm_function562 = pgm_factor562.set_cpt()
        pgm_function562.set_cpd((0,), (1.0, 0.0, 0.0))
        pgm_function562.set_cpd((1,), (1.0, 0.0, 0.0))
        pgm_function562.set_cpd((2,), (1.0, 0.0, 0.0))
        pgm_function562.set_cpd((3,), (0.0, 0.0, 1.0))
        pgm_function562.set_cpd((4,), (0.0, 1.0, 0.0))
        pgm_factor563 = self.new_factor(L_MEDD2_RD_WD, L_LNLW_MEDD2_RD_WD)
        pgm_function563 = pgm_factor563.set_cpt()
        pgm_function563.set_cpd((0,), (1.0, 0.0, 0.0))
        pgm_function563.set_cpd((1,), (0.0, 1.0, 0.0))
        pgm_function563.set_cpd((2,), (0.0, 0.0, 1.0))
        pgm_factor564 = self.new_factor(L_MEDD2_LSLOW_WD, L_MEDD2_LD_WD, L_MEDD2_RD_WD)
        pgm_function564 = pgm_factor564.set_cpt()
        pgm_function564.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function564.set_cpd((1, 0), (0.0185, 0.9561, 0.0254, 0.0, 0.0))
        pgm_function564.set_cpd((2, 0), (0.0, 0.0166, 0.9834, 0.0, 0.0))
        pgm_function564.set_cpd((3, 0), (0.0007, 0.002, 0.0219, 0.9754, 0.0))
        pgm_function564.set_cpd((0, 1), (0.0021, 0.0042, 0.0295, 0.9642, 0.0))
        pgm_function564.set_cpd((1, 1), (0.0012, 0.0025, 0.0194, 0.9769, 0.0))
        pgm_function564.set_cpd((2, 1), (0.00069993, 0.00149985, 0.0119988, 0.98580142, 0.0))
        pgm_function564.set_cpd((3, 1), (0.00020002, 0.00050005, 0.00460046, 0.99449945, 0.00020002))
        pgm_function564.set_cpd((0, 2), (0.0001, 0.0002, 0.0014, 0.083, 0.9153))
        pgm_function564.set_cpd((1, 2), (0.0001, 0.0001, 0.0008, 0.0533, 0.9457))
        pgm_function564.set_cpd((2, 2), (0.0, 0.0001, 0.0004, 0.0319, 0.9676))
        pgm_function564.set_cpd((3, 2), (0.0, 0.0, 0.0, 0.00350035, 0.99649965))
        pgm_factor565 = self.new_factor(L_LNLBE_MEDD2_DIFSLOW_WD)
        pgm_function565 = pgm_factor565.set_cpt()
        pgm_function565.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor566 = self.new_factor(L_MEDD2_DIFSLOW_WD, L_LNLBE_MEDD2_DIFSLOW_WD, L_DIFFN_MEDD2_DIFSLOW)
        pgm_function566 = pgm_factor566.set_cpt()
        pgm_function566.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function566.set_cpd((1, 0), (0.0127, 0.9867, 0.0006, 0.0))
        pgm_function566.set_cpd((2, 0), (0.0, 0.01810181, 0.98189819, 0.0))
        pgm_function566.set_cpd((3, 0), (0.0, 0.0006, 0.0492, 0.9502))
        pgm_function566.set_cpd((0, 1), (0.0127, 0.9867, 0.0006, 0.0))
        pgm_function566.set_cpd((1, 1), (0.0001, 0.0952, 0.9047, 0.0))
        pgm_function566.set_cpd((2, 1), (0.0, 0.0011, 0.7402, 0.2587))
        pgm_function566.set_cpd((3, 1), (0.0, 0.0, 0.00880088, 0.99119912))
        pgm_function566.set_cpd((0, 2), (0.0, 0.01810181, 0.98189819, 0.0))
        pgm_function566.set_cpd((1, 2), (0.0, 0.0011, 0.7402, 0.2587))
        pgm_function566.set_cpd((2, 2), (0.0, 0.0, 0.004, 0.996))
        pgm_function566.set_cpd((3, 2), (0.0, 0.0, 0.0012, 0.9988))
        pgm_function566.set_cpd((0, 3), (0.0, 0.0006, 0.0492, 0.9502))
        pgm_function566.set_cpd((1, 3), (0.0, 0.0, 0.00880088, 0.99119912))
        pgm_function566.set_cpd((2, 3), (0.0, 0.0, 0.0012, 0.9988))
        pgm_function566.set_cpd((3, 3), (0.0, 0.0, 0.0009, 0.9991))
        pgm_factor567 = self.new_factor(L_MEDD2_DSLOW_WD, L_MEDD2_SALOSS, L_MEDD2_DIFSLOW_WD)
        pgm_function567 = pgm_factor567.set_cpt()
        pgm_function567.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function567.set_cpd((1, 0), (0.1036, 0.8964, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function567.set_cpd((2, 0), (0.00059994, 0.99730027, 0.00209979, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function567.set_cpd((3, 0), (0.0001, 0.0629, 0.9278, 0.0092, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function567.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function567.set_cpd((0, 1), (0.0532, 0.2387, 0.495, 0.2072, 0.0059, 0.0, 0.0, 0.0, 0.0))
        pgm_function567.set_cpd((1, 1), (0.01780178, 0.1190119, 0.44814481, 0.38543854, 0.02960296, 0.0, 0.0, 0.0, 0.0))
        pgm_function567.set_cpd((2, 1), (0.0048, 0.0476, 0.3148, 0.5311, 0.1016, 0.0001, 0.0, 0.0, 0.0))
        pgm_function567.set_cpd((3, 1),
                                (0.00060006, 0.00920092, 0.1160116, 0.48574857, 0.38353835, 0.00490049, 0.0, 0.0, 0.0))
        pgm_function567.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function567.set_cpd((0, 2), (0.0007, 0.0063, 0.0614, 0.3006, 0.5524, 0.0781, 0.0005, 0.0, 0.0))
        pgm_function567.set_cpd((1, 2), (0.0002, 0.0021, 0.0283, 0.1995, 0.5939, 0.1737, 0.0023, 0.0, 0.0))
        pgm_function567.set_cpd((2, 2),
                                (0.0, 0.00060006, 0.01140114, 0.11471147, 0.54455446, 0.31963196, 0.00910091, 0.0, 0.0))
        pgm_function567.set_cpd((3, 2),
                                (0.0, 0.00010001, 0.00240024, 0.03740374, 0.33273327, 0.56705671, 0.06030603, 0.0, 0.0))
        pgm_function567.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function567.set_cpd((0, 3), (0.0003, 0.0011, 0.005, 0.0205, 0.087, 0.2822, 0.4514, 0.1525, 0.0))
        pgm_function567.set_cpd((1, 3), (0.0002, 0.0006, 0.0029, 0.0133, 0.0634, 0.2436, 0.4657, 0.2103, 0.0))
        pgm_function567.set_cpd((2, 3), (
            0.00010001, 0.00030003, 0.00170017, 0.00830083, 0.04470447, 0.20312031, 0.46324632, 0.27852785, 0.0))
        pgm_function567.set_cpd((3, 3), (
            0.0, 0.00010001, 0.00070007, 0.00380038, 0.02430243, 0.14161416, 0.4240424, 0.40544054, 0.0))
        pgm_function567.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor568 = self.new_factor(L_MEDD2_ALLCV_WD, L_MEDD2_LSLOW_WD, L_MEDD2_DSLOW_WD)
        pgm_function568 = pgm_factor568.set_cpt()
        pgm_function568.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function568.set_cpd((1, 0), (0.02359764, 0.25787421, 0.64033597, 0.07809219, 9.999e-05, 0.0, 0.0, 0.0, 0.0))
        pgm_function568.set_cpd((2, 0), (0.0, 0.0021, 0.1149, 0.7277, 0.1553, 0.0, 0.0, 0.0, 0.0))
        pgm_function568.set_cpd((3, 0), (0.0003, 0.0011, 0.005, 0.0205, 0.087, 0.2822, 0.4514, 0.1525, 0.0))
        pgm_function568.set_cpd((4, 0),
                                (0.0, 0.0, 9.999e-05, 0.00029997, 0.00219978, 0.01919808, 0.12518748, 0.8530147, 0.0))
        pgm_function568.set_cpd((0, 1), (0.03049695, 0.96720328, 0.00229977, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function568.set_cpd((1, 1), (0.0017, 0.0421, 0.4597, 0.4852, 0.0113, 0.0, 0.0, 0.0, 0.0))
        pgm_function568.set_cpd((2, 1), (0.0, 0.0001, 0.0146, 0.3403, 0.6424, 0.0026, 0.0, 0.0, 0.0))
        pgm_function568.set_cpd((3, 1), (
            0.00010002, 0.00040008, 0.00210042, 0.01010202, 0.05161032, 0.21844369, 0.46469294, 0.25255051, 0.0))
        pgm_function568.set_cpd((4, 1),
                                (0.0, 0.0, 0.0, 0.00019998, 0.00139986, 0.01369863, 0.10288971, 0.88181182, 0.0))
        pgm_function568.set_cpd((0, 2), (0.00039996, 0.06189381, 0.88811119, 0.04959504, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function568.set_cpd((1, 2),
                                (0.0, 0.00190019, 0.07490749, 0.56945695, 0.35323532, 0.00050005, 0.0, 0.0, 0.0))
        pgm_function568.set_cpd((2, 2), (0.0, 0.0, 0.0007, 0.0498, 0.764, 0.1854, 0.0001, 0.0, 0.0))
        pgm_function568.set_cpd((3, 2), (
            0.0, 0.00010001, 0.00060006, 0.00340034, 0.02230223, 0.13361336, 0.41454145, 0.42544254, 0.0))
        pgm_function568.set_cpd((4, 2),
                                (0.0, 0.0, 0.0, 0.00010001, 0.00070007, 0.00860086, 0.07820782, 0.91239124, 0.0))
        pgm_function568.set_cpd((0, 3), (0.0, 0.0001, 0.0655, 0.9082, 0.0262, 0.0, 0.0, 0.0, 0.0))
        pgm_function568.set_cpd((1, 3), (0.0, 0.0, 0.00220022, 0.10511051, 0.82518252, 0.06750675, 0.0, 0.0, 0.0))
        pgm_function568.set_cpd((2, 3), (0.0, 0.0, 0.0, 0.0012, 0.137, 0.8421, 0.0197, 0.0, 0.0))
        pgm_function568.set_cpd((3, 3), (0.0, 0.0, 0.0001, 0.0008, 0.0073, 0.0649, 0.3063, 0.6206, 0.0))
        pgm_function568.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.00030003, 0.0050005, 0.05640564, 0.93829383, 0.0))
        pgm_function568.set_cpd((0, 4), (0.0, 0.0, 0.0001, 0.0555, 0.937, 0.0074, 0.0, 0.0, 0.0))
        pgm_function568.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.00220022, 0.170017, 0.80628063, 0.02150215, 0.0, 0.0))
        pgm_function568.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 0.0034, 0.4375, 0.5591, 0.0, 0.0))
        pgm_function568.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.00010001, 0.00160016, 0.02260226, 0.17471747, 0.8009801, 0.0))
        pgm_function568.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 0.0001, 0.0026, 0.0379, 0.9594, 0.0))
        pgm_function568.set_cpd((0, 5), (0.0, 0.0, 0.0, 0.0002, 0.0491, 0.8863, 0.0644, 0.0, 0.0))
        pgm_function568.set_cpd((1, 5), (0.0, 0.0, 0.0, 0.0, 0.00219978, 0.23377662, 0.7620238, 0.0019998, 0.0))
        pgm_function568.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.02080208, 0.80948095, 0.16971697, 0.0))
        pgm_function568.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.00020002, 0.00520052, 0.07260726, 0.9219922, 0.0))
        pgm_function568.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0012, 0.023, 0.9758, 0.0))
        pgm_function568.set_cpd((0, 6), (0.0, 0.0, 0.0, 0.0, 0.00029997, 0.09559044, 0.89661034, 0.00749925, 0.0))
        pgm_function568.set_cpd((1, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.01009899, 0.48945105, 0.50044996, 0.0))
        pgm_function568.set_cpd((2, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.00010001, 0.03920392, 0.96069607, 0.0))
        pgm_function568.set_cpd((3, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.00120012, 0.02960296, 0.96919692, 0.0))
        pgm_function568.set_cpd((4, 6), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0005, 0.014, 0.9855, 0.0))
        pgm_function568.set_cpd((0, 7), (
            0.00020002, 0.00060006, 0.00190019, 0.00640064, 0.02470247, 0.09740974, 0.28552855, 0.58325833, 0.0))
        pgm_function568.set_cpd((1, 7), (0.0001, 0.0002, 0.0007, 0.0026, 0.0117, 0.0585, 0.2222, 0.704, 0.0))
        pgm_function568.set_cpd((2, 7), (0.0, 0.0001, 0.0002, 0.0009, 0.0051, 0.0329, 0.1636, 0.7972, 0.0))
        pgm_function568.set_cpd((3, 7), (0.0, 0.0, 0.0001, 0.0004, 0.0022, 0.0159, 0.0994, 0.882, 0.0))
        pgm_function568.set_cpd((4, 7), (0.0, 0.0, 0.0, 0.0001, 0.0006, 0.0058, 0.0523, 0.9412, 0.0))
        pgm_function568.set_cpd((0, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function568.set_cpd((1, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function568.set_cpd((2, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function568.set_cpd((3, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function568.set_cpd((4, 8), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor569 = self.new_factor(L_MEDD2_CV_WD, L_MEDD2_ALLCV_WD)
        pgm_function569 = pgm_factor569.set_cpt()
        pgm_function569.set_cpd((0,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00019998, 0.01089891, 0.09839016, 0.31656834,
            0.35316468, 0.17488251, 0.04029597, 0.00559944))
        pgm_function569.set_cpd((1,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00019998, 0.00849915, 0.07679232, 0.28107189, 0.33226677,
            0.20117988, 0.08159184, 0.01609839, 0.00209979, 0.00019998))
        pgm_function569.set_cpd((2,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00020002, 0.01390139, 0.1120112, 0.29182918, 0.31343134, 0.19151915,
            0.0610061, 0.0130013, 0.00280028, 0.00030003, 0.0, 0.0))
        pgm_function569.set_cpd((3,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00290029, 0.07060706, 0.31513151, 0.38363836, 0.17091709, 0.04760476,
            0.00820082, 0.00090009, 0.00010001, 0.0, 0.0, 0.0, 0.0))
        pgm_function569.set_cpd((4,), (
            0.0, 0.0, 0.0, 0.0, 0.00019998, 0.03939606, 0.31846815, 0.41945805, 0.17558244, 0.04189581, 0.00449955,
            0.00049995, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function569.set_cpd((5,), (
            0.0, 0.0, 0.0, 0.01569843, 0.31446855, 0.46605339, 0.17158284, 0.02909709, 0.00279972, 0.00029997, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function569.set_cpd((6,), (
            0.0, 0.0, 0.03080308, 0.5769577, 0.33983398, 0.04820482, 0.0040004, 0.00020002, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0,
            0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function569.set_cpd((7,), (
            0.0, 0.04650465, 0.84828483, 0.09990999, 0.00510051, 0.00020002, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0,
            0.0, 0.0, 0.0, 0.0))
        pgm_function569.set_cpd((8,), (
            1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor570 = self.new_factor(L_DIFFN_MED_BLOCK, DIFFN_M_SEV_DIST, DIFFN_PATHO)
        pgm_function570 = pgm_factor570.set_cpt()
        pgm_function570.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function570.set_cpd((1, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function570.set_cpd((2, 0), (0.6, 0.4, 0.0, 0.0, 0.0))
        pgm_function570.set_cpd((3, 0), (0.25, 0.5, 0.25, 0.0, 0.0))
        pgm_function570.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function570.set_cpd((1, 1), (0.0, 0.5, 0.5, 0.0, 0.0))
        pgm_function570.set_cpd((2, 1), (0.0, 0.5, 0.5, 0.0, 0.0))
        pgm_function570.set_cpd((3, 1), (0.0, 0.0, 0.4, 0.5, 0.1))
        pgm_function570.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function570.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function570.set_cpd((2, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function570.set_cpd((3, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function570.set_cpd((0, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function570.set_cpd((1, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function570.set_cpd((2, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function570.set_cpd((3, 3), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function570.set_cpd((0, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function570.set_cpd((1, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function570.set_cpd((2, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function570.set_cpd((3, 4), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor571 = self.new_factor(L_LNLBE_MED_BLOCK)
        pgm_function571 = pgm_factor571.set_cpt()
        pgm_function571.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor572 = self.new_factor(L_MED_BLOCK_EW, L_DIFFN_MED_BLOCK, L_LNLBE_MED_BLOCK)
        pgm_function572 = pgm_factor572.set_cpt()
        pgm_function572.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function572.set_cpd((1, 0), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function572.set_cpd((2, 0), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function572.set_cpd((3, 0), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function572.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function572.set_cpd((0, 1), (0.0077, 0.9923, 0.0, 0.0, 0.0))
        pgm_function572.set_cpd((1, 1), (0.0001, 0.498, 0.5019, 0.0, 0.0))
        pgm_function572.set_cpd((2, 1), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function572.set_cpd((3, 1), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function572.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function572.set_cpd((0, 2), (0.0007, 0.0234, 0.9759, 0.0, 0.0))
        pgm_function572.set_cpd((1, 2), (0.0, 0.0032, 0.9968, 0.0, 0.0))
        pgm_function572.set_cpd((2, 2), (0.0, 0.0007, 0.4328, 0.5665, 0.0))
        pgm_function572.set_cpd((3, 2), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function572.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function572.set_cpd((0, 3), (0.0019, 0.006, 0.0588, 0.9333, 0.0))
        pgm_function572.set_cpd((1, 3), (0.001, 0.0033, 0.0376, 0.9581, 0.0))
        pgm_function572.set_cpd((2, 3), (0.0003, 0.0011, 0.0159, 0.9827, 0.0))
        pgm_function572.set_cpd((3, 3), (0.00030003, 0.00110011, 0.01250125, 0.98609861, 0.0))
        pgm_function572.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function572.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function572.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function572.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function572.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function572.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor573 = self.new_factor(L_MED_AMPR_EW, L_MED_BLOCK_EW)
        pgm_function573 = pgm_factor573.set_cpt()
        pgm_function573.set_cpd((0,), (0.0879, 0.4192, 0.4232, 0.0693, 0.0004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function573.set_cpd((1,), (
            0.00189981, 0.03439656, 0.25667433, 0.52914709, 0.17348265, 0.00439956, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function573.set_cpd((2,),
                                (0.0001, 0.001, 0.0076, 0.0403, 0.172, 0.373, 0.342, 0.0633, 0.0007, 0.0, 0.0, 0.0))
        pgm_function573.set_cpd((3,), (
            0.00090009, 0.00150015, 0.00260026, 0.00490049, 0.00950095, 0.01760176, 0.03470347, 0.07680768, 0.16681668,
            0.34143414, 0.34323432, 0.0))
        pgm_function573.set_cpd((4,), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor574 = self.new_factor(L_LNLT1_APB_MALOSS)
        pgm_function574 = pgm_factor574.set_cpt()
        pgm_function574.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor575 = self.new_factor(L_LNLLP_APB_MALOSS)
        pgm_function575 = pgm_factor575.set_cpt()
        pgm_function575.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor576 = self.new_factor(L_LNLT1_LP_APB_MALOSS, L_LNLT1_APB_MALOSS, L_LNLLP_APB_MALOSS)
        pgm_function576 = pgm_factor576.set_cpt()
        pgm_function576.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function576.set_cpd((1, 0), (0.0022, 0.9977, 0.0001, 0.0, 0.0))
        pgm_function576.set_cpd((2, 0), (0.00019998, 0.03689631, 0.95880412, 0.00409959, 0.0))
        pgm_function576.set_cpd((3, 0), (0.0, 0.0002, 0.0329, 0.9669, 0.0))
        pgm_function576.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function576.set_cpd((0, 1), (0.0022, 0.9977, 0.0001, 0.0, 0.0))
        pgm_function576.set_cpd((1, 1), (0.0, 0.0282, 0.9718, 0.0, 0.0))
        pgm_function576.set_cpd((2, 1), (0.0, 0.0009, 0.3409, 0.6582, 0.0))
        pgm_function576.set_cpd((3, 1), (0.0, 0.0, 0.0038, 0.9962, 0.0))
        pgm_function576.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function576.set_cpd((0, 2), (0.00019998, 0.03689631, 0.95880412, 0.00409959, 0.0))
        pgm_function576.set_cpd((1, 2), (0.0, 0.0009, 0.3409, 0.6582, 0.0))
        pgm_function576.set_cpd((2, 2), (0.0, 0.0, 0.01, 0.99, 0.0))
        pgm_function576.set_cpd((3, 2), (0.0, 0.0, 0.0011, 0.9989, 0.0))
        pgm_function576.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function576.set_cpd((0, 3), (0.0, 0.0002, 0.0329, 0.9669, 0.0))
        pgm_function576.set_cpd((1, 3), (0.0, 0.0, 0.0038, 0.9962, 0.0))
        pgm_function576.set_cpd((2, 3), (0.0, 0.0, 0.0011, 0.9989, 0.0))
        pgm_function576.set_cpd((3, 3), (0.0, 0.0, 0.0004, 0.9996, 0.0))
        pgm_function576.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function576.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function576.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function576.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function576.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function576.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor577 = self.new_factor(L_LNLBE_APB_MALOSS)
        pgm_function577 = pgm_factor577.set_cpt()
        pgm_function577.set_cpd((), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor578 = self.new_factor(L_LNLT1_LP_BE_APB_MALOSS, L_LNLT1_LP_APB_MALOSS, L_LNLBE_APB_MALOSS)
        pgm_function578 = pgm_factor578.set_cpt()
        pgm_function578.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function578.set_cpd((1, 0), (0.0022, 0.9977, 0.0001, 0.0, 0.0))
        pgm_function578.set_cpd((2, 0), (0.00019998, 0.03689631, 0.95880412, 0.00409959, 0.0))
        pgm_function578.set_cpd((3, 0), (0.0, 0.0002, 0.0329, 0.9669, 0.0))
        pgm_function578.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function578.set_cpd((0, 1), (0.0022, 0.9977, 0.0001, 0.0, 0.0))
        pgm_function578.set_cpd((1, 1), (0.0, 0.0282, 0.9718, 0.0, 0.0))
        pgm_function578.set_cpd((2, 1), (0.0, 0.0009, 0.3409, 0.6582, 0.0))
        pgm_function578.set_cpd((3, 1), (0.0, 0.0, 0.0038, 0.9962, 0.0))
        pgm_function578.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function578.set_cpd((0, 2), (0.00019998, 0.03689631, 0.95880412, 0.00409959, 0.0))
        pgm_function578.set_cpd((1, 2), (0.0, 0.0009, 0.3409, 0.6582, 0.0))
        pgm_function578.set_cpd((2, 2), (0.0, 0.0, 0.01, 0.99, 0.0))
        pgm_function578.set_cpd((3, 2), (0.0, 0.0, 0.0011, 0.9989, 0.0))
        pgm_function578.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function578.set_cpd((0, 3), (0.0, 0.0002, 0.0329, 0.9669, 0.0))
        pgm_function578.set_cpd((1, 3), (0.0, 0.0, 0.0038, 0.9962, 0.0))
        pgm_function578.set_cpd((2, 3), (0.0, 0.0, 0.0011, 0.9989, 0.0))
        pgm_function578.set_cpd((3, 3), (0.0, 0.0, 0.0004, 0.9996, 0.0))
        pgm_function578.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function578.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function578.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function578.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function578.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function578.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor579 = self.new_factor(L_LNLW_APB_MALOSS, L_LNLW_MED_SEV, L_LNLW_MED_PATHO)
        pgm_function579 = pgm_factor579.set_cpt()
        pgm_function579.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function579.set_cpd((1, 0), (0.5, 0.5, 0.0, 0.0, 0.0))
        pgm_function579.set_cpd((2, 0), (0.0, 0.5, 0.5, 0.0, 0.0))
        pgm_function579.set_cpd((3, 0), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function579.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.1, 0.9))
        pgm_function579.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function579.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0, 0.0))
        pgm_function579.set_cpd((2, 1), (0.4, 0.3, 0.3, 0.0, 0.0))
        pgm_function579.set_cpd((3, 1), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function579.set_cpd((4, 1), (0.25, 0.25, 0.25, 0.25, 0.0))
        pgm_function579.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function579.set_cpd((1, 2), (0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function579.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function579.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function579.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function579.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function579.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function579.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function579.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function579.set_cpd((4, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function579.set_cpd((0, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function579.set_cpd((1, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function579.set_cpd((2, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function579.set_cpd((3, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function579.set_cpd((4, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_factor580 = self.new_factor(L_DIFFN_APB_MALOSS, DIFFN_M_SEV_DIST, DIFFN_PATHO)
        pgm_function580 = pgm_factor580.set_cpt()
        pgm_function580.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function580.set_cpd((1, 0), (0.4, 0.6, 0.0, 0.0, 0.0))
        pgm_function580.set_cpd((2, 0), (0.0, 0.4, 0.6, 0.0, 0.0))
        pgm_function580.set_cpd((3, 0), (0.0, 0.0, 0.4, 0.6, 0.0))
        pgm_function580.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function580.set_cpd((1, 1), (0.5, 0.5, 0.0, 0.0, 0.0))
        pgm_function580.set_cpd((2, 1), (0.4, 0.3, 0.3, 0.0, 0.0))
        pgm_function580.set_cpd((3, 1), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function580.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function580.set_cpd((1, 2), (0.0, 1.0, 0.0, 0.0, 0.0))
        pgm_function580.set_cpd((2, 2), (0.0, 0.0, 1.0, 0.0, 0.0))
        pgm_function580.set_cpd((3, 2), (0.0, 0.0, 0.0, 0.8, 0.2))
        pgm_function580.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function580.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function580.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function580.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function580.set_cpd((0, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function580.set_cpd((1, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function580.set_cpd((2, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_function580.set_cpd((3, 4), (0.0, 0.0, 0.5, 0.5, 0.0))
        pgm_factor581 = self.new_factor(L_DIFFN_LNLW_APB_MALOSS, L_LNLW_APB_MALOSS, L_DIFFN_APB_MALOSS)
        pgm_function581 = pgm_factor581.set_cpt()
        pgm_function581.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function581.set_cpd((1, 0), (0.0022, 0.9977, 0.0001, 0.0, 0.0))
        pgm_function581.set_cpd((2, 0), (0.00019998, 0.03689631, 0.95880412, 0.00409959, 0.0))
        pgm_function581.set_cpd((3, 0), (0.0, 0.0002, 0.0329, 0.9669, 0.0))
        pgm_function581.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function581.set_cpd((0, 1), (0.0022, 0.9977, 0.0001, 0.0, 0.0))
        pgm_function581.set_cpd((1, 1), (0.0, 0.0282, 0.9718, 0.0, 0.0))
        pgm_function581.set_cpd((2, 1), (0.0, 0.0009, 0.3409, 0.6582, 0.0))
        pgm_function581.set_cpd((3, 1), (0.0, 0.0, 0.0038, 0.9962, 0.0))
        pgm_function581.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function581.set_cpd((0, 2), (0.00019998, 0.03689631, 0.95880412, 0.00409959, 0.0))
        pgm_function581.set_cpd((1, 2), (0.0, 0.0009, 0.3409, 0.6582, 0.0))
        pgm_function581.set_cpd((2, 2), (0.0, 0.0, 0.01, 0.99, 0.0))
        pgm_function581.set_cpd((3, 2), (0.0, 0.0, 0.0011, 0.9989, 0.0))
        pgm_function581.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function581.set_cpd((0, 3), (0.0, 0.0002, 0.0329, 0.9669, 0.0))
        pgm_function581.set_cpd((1, 3), (0.0, 0.0, 0.0038, 0.9962, 0.0))
        pgm_function581.set_cpd((2, 3), (0.0, 0.0, 0.0011, 0.9989, 0.0))
        pgm_function581.set_cpd((3, 3), (0.0, 0.0, 0.0004, 0.9996, 0.0))
        pgm_function581.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function581.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function581.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function581.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function581.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function581.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor582 = self.new_factor(L_APB_MALOSS, L_LNLT1_LP_BE_APB_MALOSS, L_DIFFN_LNLW_APB_MALOSS)
        pgm_function582 = pgm_factor582.set_cpt()
        pgm_function582.set_cpd((0, 0), (0.98, 0.0, 0.0, 0.0, 0.0, 0.02))
        pgm_function582.set_cpd((1, 0), (0.00219978, 0.97770223, 9.999e-05, 0.0, 0.0, 0.019998))
        pgm_function582.set_cpd((2, 0), (0.0002, 0.0471, 0.9297, 0.003, 0.0, 0.02))
        pgm_function582.set_cpd((3, 0), (0.0, 0.0003, 0.0424, 0.9373, 0.0, 0.02))
        pgm_function582.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function582.set_cpd((0, 1), (0.00219978, 0.97770223, 9.999e-05, 0.0, 0.0, 0.019998))
        pgm_function582.set_cpd((1, 1), (0.0, 0.0361, 0.9439, 0.0, 0.0, 0.02))
        pgm_function582.set_cpd((2, 1), (0.0, 0.0014, 0.3987, 0.5799, 0.0, 0.02))
        pgm_function582.set_cpd((3, 1), (0.0, 0.0, 0.005, 0.975, 0.0, 0.02))
        pgm_function582.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function582.set_cpd((0, 2), (0.0002, 0.0471, 0.9297, 0.003, 0.0, 0.02))
        pgm_function582.set_cpd((1, 2), (0.0, 0.0014, 0.3987, 0.5799, 0.0, 0.02))
        pgm_function582.set_cpd((2, 2), (0.0, 0.0, 0.013, 0.967, 0.0, 0.02))
        pgm_function582.set_cpd((3, 2), (0.0, 0.0, 0.0014, 0.9786, 0.0, 0.02))
        pgm_function582.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function582.set_cpd((0, 3), (0.0, 0.0003, 0.0424, 0.9373, 0.0, 0.02))
        pgm_function582.set_cpd((1, 3), (0.0, 0.0, 0.005, 0.975, 0.0, 0.02))
        pgm_function582.set_cpd((2, 3), (0.0, 0.0, 0.0014, 0.9786, 0.0, 0.02))
        pgm_function582.set_cpd((3, 3), (0.0, 0.0, 0.0005, 0.9795, 0.0, 0.02))
        pgm_function582.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function582.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function582.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function582.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function582.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_function582.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 0.98, 0.02))
        pgm_factor583 = self.new_factor(L_DIFFN_MED_DIFSLOW, DIFFN_M_SEV_DIST, DIFFN_PATHO)
        pgm_function583 = pgm_factor583.set_cpt()
        pgm_function583.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function583.set_cpd((1, 0), (0.0, 0.5, 0.5, 0.0))
        pgm_function583.set_cpd((2, 0), (0.0, 0.2, 0.6, 0.2))
        pgm_function583.set_cpd((3, 0), (0.0, 0.2, 0.6, 0.2))
        pgm_function583.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function583.set_cpd((1, 1), (0.4, 0.5, 0.1, 0.0))
        pgm_function583.set_cpd((2, 1), (0.2, 0.4, 0.3, 0.1))
        pgm_function583.set_cpd((3, 1), (0.2, 0.4, 0.3, 0.1))
        pgm_function583.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function583.set_cpd((1, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function583.set_cpd((2, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function583.set_cpd((3, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function583.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function583.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function583.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function583.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function583.set_cpd((0, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_function583.set_cpd((1, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_function583.set_cpd((2, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_function583.set_cpd((3, 4), (0.0, 0.0, 0.7, 0.3))
        pgm_factor584 = self.new_factor(L_MED_DIFSLOW_EW, L_DIFFN_MED_DIFSLOW)
        pgm_function584 = pgm_factor584.set_cpt()
        pgm_function584.set_cpd((0,), (1.0, 0.0, 0.0, 0.0))
        pgm_function584.set_cpd((1,), (0.0126, 0.9869, 0.0005, 0.0))
        pgm_function584.set_cpd((2,), (0.0, 0.0179, 0.9821, 0.0))
        pgm_function584.set_cpd((3,), (0.0, 0.0003, 0.0252, 0.9745))
        pgm_factor585 = self.new_factor(L_MED_DCV_EW, L_APB_MALOSS, L_MED_DIFSLOW_EW)
        pgm_function585 = pgm_factor585.set_cpt()
        pgm_function585.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function585.set_cpd((1, 0), (0.109, 0.8903, 0.0007, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function585.set_cpd((2, 0), (0.0039996, 0.11438856, 0.86211379, 0.01949805, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function585.set_cpd((3, 0), (0.0001, 0.0028, 0.064, 0.9243, 0.0088, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function585.set_cpd((4, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function585.set_cpd((5, 0), (0.0835, 0.1153, 0.2417, 0.3746, 0.1682, 0.0167, 0.0, 0.0, 0.0, 0.0))
        pgm_function585.set_cpd((0, 1),
                                (0.00410041, 0.02470247, 0.15461546, 0.7389739, 0.07760776, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function585.set_cpd((1, 1), (0.0011, 0.0082, 0.0683, 0.7087, 0.2135, 0.0002, 0.0, 0.0, 0.0, 0.0))
        pgm_function585.set_cpd((2, 1), (
            9.999e-05, 0.00079992, 0.0089991, 0.3029697, 0.66543346, 0.02169783, 0.0, 0.0, 0.0, 0.0))
        pgm_function585.set_cpd((3, 1), (0.0, 0.0, 0.0006, 0.0547, 0.6199, 0.3247, 0.0001, 0.0, 0.0, 0.0))
        pgm_function585.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function585.set_cpd((5, 1), (
            0.00929907, 0.01809819, 0.05459454, 0.22767723, 0.39336066, 0.27757224, 0.01929807, 9.999e-05, 0.0, 0.0))
        pgm_function585.set_cpd((0, 2), (0.0004, 0.0012, 0.0055, 0.0628, 0.295, 0.5485, 0.0861, 0.0005, 0.0, 0.0))
        pgm_function585.set_cpd((1, 2), (
            0.00020002, 0.00050005, 0.00280028, 0.03890389, 0.23092309, 0.5829583, 0.14221422, 0.00150015, 0.0, 0.0))
        pgm_function585.set_cpd((2, 2), (
            0.0, 0.00010001, 0.00060006, 0.01230123, 0.11291129, 0.52725273, 0.33553355, 0.01130113, 0.0, 0.0))
        pgm_function585.set_cpd((3, 2), (
            0.0, 0.0, 9.999e-05, 0.00249975, 0.0359964, 0.32406759, 0.5710429, 0.06629337, 0.0, 0.0))
        pgm_function585.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function585.set_cpd((5, 2), (
            0.00059994, 0.00119988, 0.00419958, 0.02839716, 0.11488851, 0.35756424, 0.39636036, 0.09639036, 0.00039996,
            0.0))
        pgm_function585.set_cpd((0, 3), (
            0.0, 9.999e-05, 0.00019998, 0.00189981, 0.01069893, 0.06579342, 0.28457154, 0.50544946, 0.13128687, 0.0))
        pgm_function585.set_cpd((1, 3), (
            0.0, 0.0, 0.00010001, 0.00120012, 0.00750075, 0.0510051, 0.25242524, 0.51855186, 0.16921692, 0.0))
        pgm_function585.set_cpd((2, 3), (0.0, 0.0, 0.0, 0.0005, 0.0034, 0.028, 0.1822, 0.5098, 0.2761, 0.0))
        pgm_function585.set_cpd((3, 3), (
            0.0, 0.0, 0.0, 0.00010001, 0.00120012, 0.01250125, 0.11181118, 0.44524452, 0.42914291, 0.0))
        pgm_function585.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function585.set_cpd((5, 3), (0.0, 0.0, 0.0002, 0.0011, 0.0056, 0.033, 0.1653, 0.4414, 0.3534, 0.0))
        pgm_factor586 = self.new_factor(L_MED_LD_EW)
        pgm_function586 = pgm_factor586.set_cpt()
        pgm_function586.set_cpd((), (1.0, 0.0, 0.0, 0.0))
        pgm_factor587 = self.new_factor(L_MED_RD_EW)
        pgm_function587 = pgm_factor587.set_cpt()
        pgm_function587.set_cpd((), (1.0, 0.0, 0.0))
        pgm_factor588 = self.new_factor(L_MED_RDLDCV_EW, L_MED_LD_EW, L_MED_RD_EW)
        pgm_function588 = pgm_factor588.set_cpt()
        pgm_function588.set_cpd((0, 0), (0.90449045, 0.09530953, 0.00020002, 0.0, 0.0, 0.0))
        pgm_function588.set_cpd((1, 0), (0.132, 0.6039, 0.2641, 0.0, 0.0, 0.0))
        pgm_function588.set_cpd((2, 0), (0.0139, 0.1839, 0.8022, 0.0, 0.0, 0.0))
        pgm_function588.set_cpd((3, 0), (0.00120012, 0.00670067, 0.05440544, 0.86008601, 0.07760776, 0.0))
        pgm_function588.set_cpd((0, 1), (0.0115, 0.0333, 0.1509, 0.7319, 0.0724, 0.0))
        pgm_function588.set_cpd((1, 1), (0.00340034, 0.01220122, 0.0690069, 0.71967197, 0.19531953, 0.00040004))
        pgm_function588.set_cpd((2, 1), (0.0011, 0.0045, 0.0299, 0.5742, 0.3876, 0.0027))
        pgm_function588.set_cpd((3, 1), (0.0001, 0.0002, 0.0018, 0.0914, 0.6093, 0.2972))
        pgm_function588.set_cpd((0, 2), (0.0, 9.999e-05, 0.00109989, 0.14618538, 0.8070193, 0.04559544))
        pgm_function588.set_cpd((1, 2), (0.0, 0.0, 0.0002, 0.0581, 0.795, 0.1467))
        pgm_function588.set_cpd((2, 2), (0.0, 0.0, 0.0001, 0.0228, 0.6344, 0.3427))
        pgm_function588.set_cpd((3, 2), (0.0, 0.0, 0.0, 0.0014, 0.1063, 0.8923))
        pgm_factor589 = self.new_factor(L_MED_ALLCV_EW, L_MED_DCV_EW, L_MED_RDLDCV_EW)
        pgm_function589 = pgm_factor589.set_cpt()
        pgm_function589.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function589.set_cpd((1, 0), (0.0699, 0.8102, 0.1199, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function589.set_cpd((2, 0), (0.0, 0.04790479, 0.95209521, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function589.set_cpd((3, 0),
                                (0.00089991, 0.0089991, 0.08879112, 0.81861814, 0.08269173, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function589.set_cpd((4, 0), (0.0, 0.0, 0.00050005, 0.10111011, 0.84778478, 0.05060506, 0.0, 0.0, 0.0, 0.0))
        pgm_function589.set_cpd((5, 0), (0.0, 0.0, 0.0, 0.00050005, 0.07910791, 0.90019002, 0.02020202, 0.0, 0.0, 0.0))
        pgm_function589.set_cpd((6, 0), (0.0, 0.0, 0.0, 0.0, 0.0006, 0.0734, 0.8393, 0.0867, 0.0, 0.0))
        pgm_function589.set_cpd((7, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.00030003, 0.09470947, 0.89458946, 0.01040104, 0.0))
        pgm_function589.set_cpd((8, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.002, 0.0932, 0.9048, 0.0))
        pgm_function589.set_cpd((9, 0), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.9999))
        pgm_function589.set_cpd((0, 1), (0.00660066, 0.14551455, 0.83808381, 0.00980098, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function589.set_cpd((1, 1), (0.0005, 0.0239, 0.4369, 0.5387, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function589.set_cpd((2, 1), (0.0, 0.0003, 0.0239, 0.9748, 0.001, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function589.set_cpd((3, 1), (0.0, 0.0002, 0.0036, 0.2467, 0.7339, 0.0156, 0.0, 0.0, 0.0, 0.0))
        pgm_function589.set_cpd((4, 1), (0.0, 0.0, 0.0, 0.005, 0.3134, 0.6811, 0.0005, 0.0, 0.0, 0.0))
        pgm_function589.set_cpd((5, 1), (0.0, 0.0, 0.0, 0.0, 0.00710071, 0.54935494, 0.44334433, 0.00020002, 0.0, 0.0))
        pgm_function589.set_cpd((6, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.00910091, 0.52835284, 0.46254625, 0.0, 0.0))
        pgm_function589.set_cpd((7, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0216, 0.8359, 0.1425, 0.0))
        pgm_function589.set_cpd((8, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0004, 0.0355, 0.9641, 0.0))
        pgm_function589.set_cpd((9, 1), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.9999))
        pgm_function589.set_cpd((0, 2), (0.0, 0.0, 0.0047, 0.9951, 0.0002, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function589.set_cpd((1, 2), (0.0, 0.0, 0.0004, 0.9005, 0.0991, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function589.set_cpd((2, 2), (0.0, 0.0, 0.0, 0.1288, 0.8712, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function589.set_cpd((3, 2), (0.0, 0.0, 0.0, 0.01130113, 0.57115712, 0.41754175, 0.0, 0.0, 0.0, 0.0))
        pgm_function589.set_cpd((4, 2), (0.0, 0.0, 0.0, 0.0, 0.0214, 0.9354, 0.0432, 0.0, 0.0, 0.0))
        pgm_function589.set_cpd((5, 2), (0.0, 0.0, 0.0, 0.0, 9.999e-05, 0.05649435, 0.93230677, 0.01109889, 0.0, 0.0))
        pgm_function589.set_cpd((6, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0004, 0.143, 0.8551, 0.0015, 0.0))
        pgm_function589.set_cpd((7, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0019998, 0.3548645, 0.6431357, 0.0))
        pgm_function589.set_cpd((8, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.0122, 0.9877, 0.0))
        pgm_function589.set_cpd((9, 2), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.9999))
        pgm_function589.set_cpd((0, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function589.set_cpd((1, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.997, 0.003, 0.0, 0.0, 0.0))
        pgm_function589.set_cpd((2, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.2336, 0.7664, 0.0, 0.0, 0.0))
        pgm_function589.set_cpd((3, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.00259974, 0.99340066, 0.0039996, 0.0, 0.0))
        pgm_function589.set_cpd((4, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.2469, 0.7531, 0.0, 0.0))
        pgm_function589.set_cpd((5, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.002, 0.9939, 0.0041, 0.0))
        pgm_function589.set_cpd((6, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0314, 0.9686, 0.0))
        pgm_function589.set_cpd((7, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0002, 0.9998, 0.0))
        pgm_function589.set_cpd((8, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0003, 0.9997, 0.0))
        pgm_function589.set_cpd((9, 3), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function589.set_cpd((0, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0012, 0.1305, 0.8445, 0.0238, 0.0))
        pgm_function589.set_cpd((1, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0004, 0.074, 0.8589, 0.0667, 0.0))
        pgm_function589.set_cpd((2, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.00010001, 0.03730373, 0.80288029, 0.15971597, 0.0))
        pgm_function589.set_cpd((3, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.007, 0.3517, 0.6413, 0.0))
        pgm_function589.set_cpd((4, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0003, 0.0581, 0.9416, 0.0))
        pgm_function589.set_cpd((5, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.006, 0.994, 0.0))
        pgm_function589.set_cpd((6, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0008, 0.9992, 0.0))
        pgm_function589.set_cpd((7, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.9999, 0.0))
        pgm_function589.set_cpd((8, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0002, 0.9998, 0.0))
        pgm_function589.set_cpd((9, 4), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function589.set_cpd((0, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0002, 0.0321, 0.9677, 0.0))
        pgm_function589.set_cpd((1, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.0184, 0.9815, 0.0))
        pgm_function589.set_cpd((2, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.01010101, 0.98989899, 0.0))
        pgm_function589.set_cpd((3, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0042, 0.9958, 0.0))
        pgm_function589.set_cpd((4, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0011, 0.9989, 0.0))
        pgm_function589.set_cpd((5, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0003, 0.9997, 0.0))
        pgm_function589.set_cpd((6, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.9999, 0.0))
        pgm_function589.set_cpd((7, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function589.set_cpd((8, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.9999, 0.0))
        pgm_function589.set_cpd((9, 5), (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_factor590 = self.new_factor(L_MED_CV_EW, L_MED_ALLCV_EW)
        pgm_function590 = pgm_factor590.set_cpt()
        pgm_function590.set_cpd((0,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0006, 0.0168, 0.1184, 0.296, 0.3227, 0.1783, 0.056,
            0.0112))
        pgm_function590.set_cpd((1,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0001, 0.0005, 0.0155, 0.1165, 0.2969, 0.3229, 0.1782, 0.0564,
            0.0114, 0.0016))
        pgm_function590.set_cpd((2,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0006, 0.0039, 0.0589, 0.2434, 0.3586, 0.235, 0.0808, 0.0164,
            0.0022, 0.0002))
        pgm_function590.set_cpd((3,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0007, 0.0176, 0.1966, 0.2515, 0.2699, 0.1688, 0.069, 0.0203, 0.0046,
            0.0009, 0.0001, 0.0))
        pgm_function590.set_cpd((4,), (
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00560056, 0.090009, 0.30563056, 0.30933093, 0.20392039, 0.06730673,
            0.01520152,
            0.00260026, 0.00040004, 0.0, 0.0, 0.0, 0.0))
        pgm_function590.set_cpd((5,), (
            0.0, 0.0, 0.0, 0.0, 0.0006, 0.0496, 0.2972, 0.4059, 0.2097, 0.0258, 0.0098, 0.0013, 0.0001, 0.0, 0.0, 0.0,
            0.0,
            0.0, 0.0))
        pgm_function590.set_cpd((6,), (
            0.0, 0.0, 0.0, 0.01789821, 0.29457054, 0.4469553, 0.19018098, 0.04339566, 0.00659934, 0.00029997, 9.999e-05,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_function590.set_cpd((7,), (
            0.0, 0.0, 0.0265, 0.5431, 0.3624, 0.0622, 0.0054, 0.0004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0))
        pgm_function590.set_cpd((8,), (
            0.0, 0.12651265, 0.76547655, 0.10061006, 0.0070007, 0.00040004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0))
        pgm_function590.set_cpd((9,), (
            0.9999, 0.0001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0))
        pgm_factor591 = self.new_factor(L_LNLT1_APB_DE_REGEN)
        pgm_function591 = pgm_factor591.set_cpt()
        pgm_function591.set_cpd((), (1.0, 0.0))
        pgm_factor592 = self.new_factor(L_LNLLP_APB_DE_REGEN)
        pgm_function592 = pgm_factor592.set_cpt()
        pgm_function592.set_cpd((), (1.0, 0.0))
        pgm_factor593 = self.new_factor(L_LNLT1_LP_APB_DE_REGEN, L_LNLT1_APB_DE_REGEN, L_LNLLP_APB_DE_REGEN)
        pgm_function593 = pgm_factor593.set_cpt()
        pgm_function593.set_cpd((0, 0), (1.0, 0.0))
        pgm_function593.set_cpd((1, 0), (0.0, 1.0))
        pgm_function593.set_cpd((0, 1), (0.0, 1.0))
        pgm_function593.set_cpd((1, 1), (0.0, 1.0))
        pgm_factor594 = self.new_factor(L_LNLBE_APB_DE_REGEN)
        pgm_function594 = pgm_factor594.set_cpt()
        pgm_function594.set_cpd((), (1.0, 0.0))
        pgm_factor595 = self.new_factor(L_LNLT1_LP_BE_APB_DE_REGEN, L_LNLT1_LP_APB_DE_REGEN, L_LNLBE_APB_DE_REGEN)
        pgm_function595 = pgm_factor595.set_cpt()
        pgm_function595.set_cpd((0, 0), (1.0, 0.0))
        pgm_function595.set_cpd((1, 0), (0.0, 1.0))
        pgm_function595.set_cpd((0, 1), (0.0, 1.0))
        pgm_function595.set_cpd((1, 1), (0.0, 1.0))
        pgm_factor596 = self.new_factor(L_DIFFN_APB_DE_REGEN, DIFFN_M_SEV_DIST, DIFFN_TIME, DIFFN_PATHO)
        pgm_function596 = pgm_factor596.set_cpt()
        pgm_function596.set_cpd((0, 0, 0), (1.0, 0.0))
        pgm_function596.set_cpd((1, 0, 0), (1.0, 0.0))
        pgm_function596.set_cpd((2, 0, 0), (1.0, 0.0))
        pgm_function596.set_cpd((3, 0, 0), (1.0, 0.0))
        pgm_function596.set_cpd((0, 1, 0), (1.0, 0.0))
        pgm_function596.set_cpd((1, 1, 0), (0.8, 0.2))
        pgm_function596.set_cpd((2, 1, 0), (0.2, 0.8))
        pgm_function596.set_cpd((3, 1, 0), (0.4, 0.6))
        pgm_function596.set_cpd((0, 2, 0), (1.0, 0.0))
        pgm_function596.set_cpd((1, 2, 0), (0.8, 0.2))
        pgm_function596.set_cpd((2, 2, 0), (0.2, 0.8))
        pgm_function596.set_cpd((3, 2, 0), (0.4, 0.6))
        pgm_function596.set_cpd((0, 3, 0), (1.0, 0.0))
        pgm_function596.set_cpd((1, 3, 0), (1.0, 0.0))
        pgm_function596.set_cpd((2, 3, 0), (0.8, 0.2))
        pgm_function596.set_cpd((3, 3, 0), (0.4, 0.6))
        pgm_function596.set_cpd((0, 0, 1), (1.0, 0.0))
        pgm_function596.set_cpd((1, 0, 1), (1.0, 0.0))
        pgm_function596.set_cpd((2, 0, 1), (1.0, 0.0))
        pgm_function596.set_cpd((3, 0, 1), (1.0, 0.0))
        pgm_function596.set_cpd((0, 1, 1), (1.0, 0.0))
        pgm_function596.set_cpd((1, 1, 1), (0.8, 0.2))
        pgm_function596.set_cpd((2, 1, 1), (0.2, 0.8))
        pgm_function596.set_cpd((3, 1, 1), (0.4, 0.6))
        pgm_function596.set_cpd((0, 2, 1), (1.0, 0.0))
        pgm_function596.set_cpd((1, 2, 1), (0.8, 0.2))
        pgm_function596.set_cpd((2, 2, 1), (0.2, 0.8))
        pgm_function596.set_cpd((3, 2, 1), (0.4, 0.6))
        pgm_function596.set_cpd((0, 3, 1), (1.0, 0.0))
        pgm_function596.set_cpd((1, 3, 1), (1.0, 0.0))
        pgm_function596.set_cpd((2, 3, 1), (0.8, 0.2))
        pgm_function596.set_cpd((3, 3, 1), (0.4, 0.6))
        pgm_function596.set_cpd((0, 0, 2), (1.0, 0.0))
        pgm_function596.set_cpd((1, 0, 2), (1.0, 0.0))
        pgm_function596.set_cpd((2, 0, 2), (1.0, 0.0))
        pgm_function596.set_cpd((3, 0, 2), (1.0, 0.0))
        pgm_function596.set_cpd((0, 1, 2), (1.0, 0.0))
        pgm_function596.set_cpd((1, 1, 2), (0.5, 0.5))
        pgm_function596.set_cpd((2, 1, 2), (0.2, 0.8))
        pgm_function596.set_cpd((3, 1, 2), (0.1, 0.9))
        pgm_function596.set_cpd((0, 2, 2), (1.0, 0.0))
        pgm_function596.set_cpd((1, 2, 2), (0.5, 0.5))
        pgm_function596.set_cpd((2, 2, 2), (0.2, 0.8))
        pgm_function596.set_cpd((3, 2, 2), (0.1, 0.9))
        pgm_function596.set_cpd((0, 3, 2), (1.0, 0.0))
        pgm_function596.set_cpd((1, 3, 2), (1.0, 0.0))
        pgm_function596.set_cpd((2, 3, 2), (0.8, 0.2))
        pgm_function596.set_cpd((3, 3, 2), (0.4, 0.6))
        pgm_function596.set_cpd((0, 0, 3), (0.0, 1.0))
        pgm_function596.set_cpd((1, 0, 3), (0.0, 1.0))
        pgm_function596.set_cpd((2, 0, 3), (0.0, 1.0))
        pgm_function596.set_cpd((3, 0, 3), (0.0, 1.0))
        pgm_function596.set_cpd((0, 1, 3), (0.0, 1.0))
        pgm_function596.set_cpd((1, 1, 3), (0.0, 1.0))
        pgm_function596.set_cpd((2, 1, 3), (0.0, 1.0))
        pgm_function596.set_cpd((3, 1, 3), (0.0, 1.0))
        pgm_function596.set_cpd((0, 2, 3), (0.0, 1.0))
        pgm_function596.set_cpd((1, 2, 3), (0.0, 1.0))
        pgm_function596.set_cpd((2, 2, 3), (0.0, 1.0))
        pgm_function596.set_cpd((3, 2, 3), (0.0, 1.0))
        pgm_function596.set_cpd((0, 3, 3), (0.0, 1.0))
        pgm_function596.set_cpd((1, 3, 3), (0.0, 1.0))
        pgm_function596.set_cpd((2, 3, 3), (0.0, 1.0))
        pgm_function596.set_cpd((3, 3, 3), (0.0, 1.0))
        pgm_function596.set_cpd((0, 0, 4), (0.0, 1.0))
        pgm_function596.set_cpd((1, 0, 4), (0.0, 1.0))
        pgm_function596.set_cpd((2, 0, 4), (0.0, 1.0))
        pgm_function596.set_cpd((3, 0, 4), (0.0, 1.0))
        pgm_function596.set_cpd((0, 1, 4), (0.0, 1.0))
        pgm_function596.set_cpd((1, 1, 4), (0.0, 1.0))
        pgm_function596.set_cpd((2, 1, 4), (0.0, 1.0))
        pgm_function596.set_cpd((3, 1, 4), (0.0, 1.0))
        pgm_function596.set_cpd((0, 2, 4), (0.0, 1.0))
        pgm_function596.set_cpd((1, 2, 4), (0.0, 1.0))
        pgm_function596.set_cpd((2, 2, 4), (0.0, 1.0))
        pgm_function596.set_cpd((3, 2, 4), (0.0, 1.0))
        pgm_function596.set_cpd((0, 3, 4), (0.0, 1.0))
        pgm_function596.set_cpd((1, 3, 4), (0.0, 1.0))
        pgm_function596.set_cpd((2, 3, 4), (0.0, 1.0))
        pgm_function596.set_cpd((3, 3, 4), (0.0, 1.0))
        pgm_factor597 = self.new_factor(L_LNLW_MED_TIME)
        pgm_function597 = pgm_factor597.set_cpt()
        pgm_function597.set_cpd((), (0.05, 0.33, 0.6, 0.02))
        pgm_factor598 = self.new_factor(L_LNLW_APB_DE_REGEN, L_LNLW_MED_SEV, L_LNLW_MED_TIME, L_LNLW_MED_PATHO)
        pgm_function598 = pgm_factor598.set_cpt()
        pgm_function598.set_cpd((0, 0, 0), (1.0, 0.0))
        pgm_function598.set_cpd((1, 0, 0), (1.0, 0.0))
        pgm_function598.set_cpd((2, 0, 0), (1.0, 0.0))
        pgm_function598.set_cpd((3, 0, 0), (1.0, 0.0))
        pgm_function598.set_cpd((4, 0, 0), (1.0, 0.0))
        pgm_function598.set_cpd((0, 1, 0), (1.0, 0.0))
        pgm_function598.set_cpd((1, 1, 0), (0.8, 0.2))
        pgm_function598.set_cpd((2, 1, 0), (0.2, 0.8))
        pgm_function598.set_cpd((3, 1, 0), (0.4, 0.6))
        pgm_function598.set_cpd((4, 1, 0), (1.0, 0.0))
        pgm_function598.set_cpd((0, 2, 0), (1.0, 0.0))
        pgm_function598.set_cpd((1, 2, 0), (0.8, 0.2))
        pgm_function598.set_cpd((2, 2, 0), (0.2, 0.8))
        pgm_function598.set_cpd((3, 2, 0), (0.4, 0.6))
        pgm_function598.set_cpd((4, 2, 0), (1.0, 0.0))
        pgm_function598.set_cpd((0, 3, 0), (1.0, 0.0))
        pgm_function598.set_cpd((1, 3, 0), (1.0, 0.0))
        pgm_function598.set_cpd((2, 3, 0), (0.8, 0.2))
        pgm_function598.set_cpd((3, 3, 0), (0.4, 0.6))
        pgm_function598.set_cpd((4, 3, 0), (1.0, 0.0))
        pgm_function598.set_cpd((0, 0, 1), (1.0, 0.0))
        pgm_function598.set_cpd((1, 0, 1), (1.0, 0.0))
        pgm_function598.set_cpd((2, 0, 1), (1.0, 0.0))
    