# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import List, Union, Optional
from typing_extensions import Literal

from ..._models import BaseModel
from .function_and_custom_tool_call_output import FunctionAndCustomToolCallOutput

__all__ = ["CustomToolCallOutput"]


class CustomToolCallOutput(BaseModel):
    call_id: str
    """The call ID, used to map this custom tool call output to a custom tool call."""

    output: Union[str, List[FunctionAndCustomToolCallOutput]]
    """
    The output from the custom tool call generated by your code. Can be a string or
    an list of output content.
    """

    type: Literal["custom_tool_call_output"]
    """The type of the custom tool call output. Always `custom_tool_call_output`."""

    id: Optional[str] = None
    """The unique ID of the custom tool call output in the OpenAI platform."""
