# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Union, Iterable
from typing_extensions import Literal, Required, TypedDict

from .function_and_custom_tool_call_output_param import FunctionAndCustomToolCallOutputParam

__all__ = ["CustomToolCallOutputParam"]


class CustomToolCallOutputParam(TypedDict, total=False):
    call_id: Required[str]
    """The call ID, used to map this custom tool call output to a custom tool call."""

    output: Required[Union[str, Iterable[FunctionAndCustomToolCallOutputParam]]]
    """
    The output from the custom tool call generated by your code. Can be a string or
    an list of output content.
    """

    type: Required[Literal["custom_tool_call_output"]]
    """The type of the custom tool call output. Always `custom_tool_call_output`."""

    id: str
    """The unique ID of the custom tool call output in the OpenAI platform."""
