# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import List, Union, Optional
from typing_extensions import Literal

from ..._models import BaseModel
from .function_and_custom_tool_call_output import FunctionAndCustomToolCallOutput

__all__ = ["FunctionToolCallOutputResource"]


class FunctionToolCallOutputResource(BaseModel):
    id: str
    """The unique ID of the function call tool output."""

    call_id: str
    """The unique ID of the function tool call generated by the model."""

    output: Union[str, List[FunctionAndCustomToolCallOutput]]
    """
    The output from the function call generated by your code. Can be a string or an
    list of output content.
    """

    type: Literal["function_call_output"]
    """The type of the function tool call output. Always `function_call_output`."""

    status: Optional[Literal["in_progress", "completed", "incomplete"]] = None
    """The status of the item.

    One of `in_progress`, `completed`, or `incomplete`. Populated when items are
    returned via API.
    """
