# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import List, Union, Optional
from typing_extensions import Literal, Annotated, TypeAlias

from ..._utils import PropertyInfo
from ..._models import BaseModel
from .input_message import InputMessage
from .mcp_tool_call import McpToolCall
from .mcp_list_tools import McpListTools
from .output_message import OutputMessage
from .reasoning_item import ReasoningItem
from .custom_tool_call import CustomToolCall
from .computer_tool_call import ComputerToolCall
from .easy_input_message import EasyInputMessage
from .function_tool_call import FunctionToolCall
from .image_gen_tool_call import ImageGenToolCall
from .mcp_approval_request import McpApprovalRequest
from .web_search_tool_call import WebSearchToolCall
from .file_search_tool_call import FileSearchToolCall
from .local_shell_tool_call import LocalShellToolCall
from .custom_tool_call_output import CustomToolCallOutput
from .computer_screenshot_image import ComputerScreenshotImage
from .function_call_item_status import FunctionCallItemStatus
from .code_interpreter_tool_call import CodeInterpreterToolCall
from .local_shell_tool_call_output import LocalShellToolCallOutput

__all__ = [
    "InputItem",
    "ComputerCallOutput",
    "ComputerCallOutputAcknowledgedSafetyCheck",
    "FunctionCallOutput",
    "FunctionCallOutputOutputUnionMember1",
    "FunctionCallOutputOutputUnionMember1InputText",
    "FunctionCallOutputOutputUnionMember1InputImage",
    "FunctionCallOutputOutputUnionMember1InputFile",
    "McpApprovalResponse",
    "ItemReference",
]


class ComputerCallOutputAcknowledgedSafetyCheck(BaseModel):
    id: str
    """The ID of the pending safety check."""

    code: Optional[str] = None
    """The type of the pending safety check."""

    message: Optional[str] = None
    """Details about the pending safety check."""


class ComputerCallOutput(BaseModel):
    call_id: str
    """The ID of the computer tool call that produced the output."""

    output: ComputerScreenshotImage
    """A computer screenshot image used with the computer use tool."""

    type: Literal["computer_call_output"]
    """The type of the computer tool call output. Always `computer_call_output`."""

    id: Optional[str] = None
    """The ID of the computer tool call output."""

    acknowledged_safety_checks: Optional[List[ComputerCallOutputAcknowledgedSafetyCheck]] = None
    """
    The safety checks reported by the API that have been acknowledged by the
    developer.
    """

    status: Optional[FunctionCallItemStatus] = None
    """The status of the message input.

    One of `in_progress`, `completed`, or `incomplete`. Populated when input items
    are returned via API.
    """


class FunctionCallOutputOutputUnionMember1InputText(BaseModel):
    text: str
    """The text input to the model."""

    type: Literal["input_text"]
    """The type of the input item. Always `input_text`."""


class FunctionCallOutputOutputUnionMember1InputImage(BaseModel):
    type: Literal["input_image"]
    """The type of the input item. Always `input_image`."""

    detail: Optional[Literal["low", "high", "auto"]] = None
    """The detail level of the image to be sent to the model.

    One of `high`, `low`, or `auto`. Defaults to `auto`.
    """

    file_id: Optional[str] = None
    """The ID of the file to be sent to the model."""

    image_url: Optional[str] = None
    """The URL of the image to be sent to the model.

    A fully qualified URL or base64 encoded image in a data URL.
    """


class FunctionCallOutputOutputUnionMember1InputFile(BaseModel):
    type: Literal["input_file"]
    """The type of the input item. Always `input_file`."""

    file_data: Optional[str] = None
    """The base64-encoded data of the file to be sent to the model."""

    file_id: Optional[str] = None
    """The ID of the file to be sent to the model."""

    file_url: Optional[str] = None
    """The URL of the file to be sent to the model."""

    filename: Optional[str] = None
    """The name of the file to be sent to the model."""


FunctionCallOutputOutputUnionMember1: TypeAlias = Annotated[
    Union[
        FunctionCallOutputOutputUnionMember1InputText,
        FunctionCallOutputOutputUnionMember1InputImage,
        FunctionCallOutputOutputUnionMember1InputFile,
    ],
    PropertyInfo(discriminator="type"),
]


class FunctionCallOutput(BaseModel):
    call_id: str
    """The unique ID of the function tool call generated by the model."""

    output: Union[str, List[FunctionCallOutputOutputUnionMember1]]
    """Text, image, or file output of the function tool call."""

    type: Literal["function_call_output"]
    """The type of the function tool call output. Always `function_call_output`."""

    id: Optional[str] = None
    """The unique ID of the function tool call output.

    Populated when this item is returned via API.
    """

    status: Optional[FunctionCallItemStatus] = None
    """The status of the item.

    One of `in_progress`, `completed`, or `incomplete`. Populated when items are
    returned via API.
    """


class McpApprovalResponse(BaseModel):
    approval_request_id: str
    """The ID of the approval request being answered."""

    approve: bool
    """Whether the request was approved."""

    type: Literal["mcp_approval_response"]
    """The type of the item. Always `mcp_approval_response`."""

    id: Optional[str] = None
    """The unique ID of the approval response"""

    reason: Optional[str] = None
    """Optional reason for the decision."""


class ItemReference(BaseModel):
    id: str
    """The ID of the item to reference."""

    type: Optional[Literal["item_reference"]] = None
    """The type of item to reference. Always `item_reference`."""


InputItem: TypeAlias = Annotated[
    Union[
        EasyInputMessage,
        InputMessage,
        OutputMessage,
        FileSearchToolCall,
        ComputerToolCall,
        ComputerCallOutput,
        WebSearchToolCall,
        FunctionToolCall,
        FunctionCallOutput,
        ReasoningItem,
        ImageGenToolCall,
        CodeInterpreterToolCall,
        LocalShellToolCall,
        LocalShellToolCallOutput,
        McpListTools,
        McpApprovalRequest,
        McpApprovalResponse,
        McpToolCall,
        CustomToolCallOutput,
        CustomToolCall,
        ItemReference,
    ],
    PropertyInfo(discriminator="type"),
]
