# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Union, Iterable, Optional
from typing_extensions import Literal, Required, TypeAlias, TypedDict

from .input_message_param import InputMessageParam
from .mcp_tool_call_param import McpToolCallParam
from .mcp_list_tools_param import McpListToolsParam
from .output_message_param import OutputMessageParam
from .reasoning_item_param import ReasoningItemParam
from .custom_tool_call_param import CustomToolCallParam
from .computer_tool_call_param import ComputerToolCallParam
from .easy_input_message_param import EasyInputMessageParam
from .function_tool_call_param import FunctionToolCallParam
from .function_call_item_status import FunctionCallItemStatus
from .image_gen_tool_call_param import ImageGenToolCallParam
from .mcp_approval_request_param import McpApprovalRequestParam
from .web_search_tool_call_param import WebSearchToolCallParam
from .file_search_tool_call_param import FileSearchToolCallParam
from .local_shell_tool_call_param import LocalShellToolCallParam
from .custom_tool_call_output_param import CustomToolCallOutputParam
from .computer_screenshot_image_param import ComputerScreenshotImageParam
from .code_interpreter_tool_call_param import CodeInterpreterToolCallParam
from .local_shell_tool_call_output_param import LocalShellToolCallOutputParam

__all__ = [
    "InputItemParam",
    "ComputerCallOutput",
    "ComputerCallOutputAcknowledgedSafetyCheck",
    "FunctionCallOutput",
    "FunctionCallOutputOutputUnionMember1",
    "FunctionCallOutputOutputUnionMember1InputText",
    "FunctionCallOutputOutputUnionMember1InputImage",
    "FunctionCallOutputOutputUnionMember1InputFile",
    "McpApprovalResponse",
    "ItemReference",
]


class ComputerCallOutputAcknowledgedSafetyCheck(TypedDict, total=False):
    id: Required[str]
    """The ID of the pending safety check."""

    code: Optional[str]
    """The type of the pending safety check."""

    message: Optional[str]
    """Details about the pending safety check."""


class ComputerCallOutput(TypedDict, total=False):
    call_id: Required[str]
    """The ID of the computer tool call that produced the output."""

    output: Required[ComputerScreenshotImageParam]
    """A computer screenshot image used with the computer use tool."""

    type: Required[Literal["computer_call_output"]]
    """The type of the computer tool call output. Always `computer_call_output`."""

    id: Optional[str]
    """The ID of the computer tool call output."""

    acknowledged_safety_checks: Optional[Iterable[ComputerCallOutputAcknowledgedSafetyCheck]]
    """
    The safety checks reported by the API that have been acknowledged by the
    developer.
    """

    status: Optional[FunctionCallItemStatus]
    """The status of the message input.

    One of `in_progress`, `completed`, or `incomplete`. Populated when input items
    are returned via API.
    """


class FunctionCallOutputOutputUnionMember1InputText(TypedDict, total=False):
    text: Required[str]
    """The text input to the model."""

    type: Required[Literal["input_text"]]
    """The type of the input item. Always `input_text`."""


class FunctionCallOutputOutputUnionMember1InputImage(TypedDict, total=False):
    type: Required[Literal["input_image"]]
    """The type of the input item. Always `input_image`."""

    detail: Optional[Literal["low", "high", "auto"]]
    """The detail level of the image to be sent to the model.

    One of `high`, `low`, or `auto`. Defaults to `auto`.
    """

    file_id: Optional[str]
    """The ID of the file to be sent to the model."""

    image_url: Optional[str]
    """The URL of the image to be sent to the model.

    A fully qualified URL or base64 encoded image in a data URL.
    """


class FunctionCallOutputOutputUnionMember1InputFile(TypedDict, total=False):
    type: Required[Literal["input_file"]]
    """The type of the input item. Always `input_file`."""

    file_data: Optional[str]
    """The base64-encoded data of the file to be sent to the model."""

    file_id: Optional[str]
    """The ID of the file to be sent to the model."""

    file_url: Optional[str]
    """The URL of the file to be sent to the model."""

    filename: Optional[str]
    """The name of the file to be sent to the model."""


FunctionCallOutputOutputUnionMember1: TypeAlias = Union[
    FunctionCallOutputOutputUnionMember1InputText,
    FunctionCallOutputOutputUnionMember1InputImage,
    FunctionCallOutputOutputUnionMember1InputFile,
]


class FunctionCallOutput(TypedDict, total=False):
    call_id: Required[str]
    """The unique ID of the function tool call generated by the model."""

    output: Required[Union[str, Iterable[FunctionCallOutputOutputUnionMember1]]]
    """Text, image, or file output of the function tool call."""

    type: Required[Literal["function_call_output"]]
    """The type of the function tool call output. Always `function_call_output`."""

    id: Optional[str]
    """The unique ID of the function tool call output.

    Populated when this item is returned via API.
    """

    status: Optional[FunctionCallItemStatus]
    """The status of the item.

    One of `in_progress`, `completed`, or `incomplete`. Populated when items are
    returned via API.
    """


class McpApprovalResponse(TypedDict, total=False):
    approval_request_id: Required[str]
    """The ID of the approval request being answered."""

    approve: Required[bool]
    """Whether the request was approved."""

    type: Required[Literal["mcp_approval_response"]]
    """The type of the item. Always `mcp_approval_response`."""

    id: Optional[str]
    """The unique ID of the approval response"""

    reason: Optional[str]
    """Optional reason for the decision."""


class ItemReference(TypedDict, total=False):
    id: Required[str]
    """The ID of the item to reference."""

    type: Optional[Literal["item_reference"]]
    """The type of item to reference. Always `item_reference`."""


InputItemParam: TypeAlias = Union[
    EasyInputMessageParam,
    InputMessageParam,
    OutputMessageParam,
    FileSearchToolCallParam,
    ComputerToolCallParam,
    ComputerCallOutput,
    WebSearchToolCallParam,
    FunctionToolCallParam,
    FunctionCallOutput,
    ReasoningItemParam,
    ImageGenToolCallParam,
    CodeInterpreterToolCallParam,
    LocalShellToolCallParam,
    LocalShellToolCallOutputParam,
    McpListToolsParam,
    McpApprovalRequestParam,
    McpApprovalResponse,
    McpToolCallParam,
    CustomToolCallOutputParam,
    CustomToolCallParam,
    ItemReference,
]
