# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Dict, Optional
from typing_extensions import Literal, Required, TypedDict

from ..._types import SequenceNotStr

__all__ = ["LocalShellToolCallParam", "Action"]


class Action(TypedDict, total=False):
    command: Required[SequenceNotStr[str]]
    """The command to run."""

    env: Required[Dict[str, str]]
    """Environment variables to set for the command."""

    type: Required[Literal["exec"]]
    """The type of the local shell action. Always `exec`."""

    timeout_ms: Optional[int]
    """Optional timeout in milliseconds for the command."""

    user: Optional[str]
    """Optional user to run the command as."""

    working_directory: Optional[str]
    """Optional working directory to run the command in."""


class LocalShellToolCallParam(TypedDict, total=False):
    id: Required[str]
    """The unique ID of the local shell call."""

    action: Required[Action]
    """Execute a shell command on the server."""

    call_id: Required[str]
    """The unique ID of the local shell tool call generated by the model."""

    status: Required[Literal["in_progress", "completed", "incomplete"]]
    """The status of the local shell call."""

    type: Required[Literal["local_shell_call"]]
    """The type of the local shell call. Always `local_shell_call`."""
