# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import List, Union, Optional
from typing_extensions import Literal, Annotated, TypeAlias

from .._utils import PropertyInfo
from .._models import BaseModel
from .response_properties import ResponseProperties
from .conversations.input_item import InputItem
from .conversations.mcp_tool_call import McpToolCall
from .conversations.mcp_list_tools import McpListTools
from .conversations.output_message import OutputMessage
from .conversations.reasoning_item import ReasoningItem
from .conversations.custom_tool_call import CustomToolCall
from .conversations.computer_tool_call import ComputerToolCall
from .conversations.function_tool_call import FunctionToolCall
from .conversations.image_gen_tool_call import ImageGenToolCall
from .conversations.mcp_approval_request import McpApprovalRequest
from .conversations.web_search_tool_call import WebSearchToolCall
from .model_response_properties_standard import ModelResponsePropertiesStandard
from .conversations.file_search_tool_call import FileSearchToolCall
from .conversations.local_shell_tool_call import LocalShellToolCall
from .conversations.code_interpreter_tool_call import CodeInterpreterToolCall

__all__ = [
    "Response",
    "ResponseError",
    "ResponseIncompleteDetails",
    "ResponseOutput",
    "ResponseUsage",
    "ResponseUsageInputTokensDetails",
    "ResponseUsageOutputTokensDetails",
]


class ResponseError(BaseModel):
    code: Literal[
        "server_error",
        "rate_limit_exceeded",
        "invalid_prompt",
        "vector_store_timeout",
        "invalid_image",
        "invalid_image_format",
        "invalid_base64_image",
        "invalid_image_url",
        "image_too_large",
        "image_too_small",
        "image_parse_error",
        "image_content_policy_violation",
        "invalid_image_mode",
        "image_file_too_large",
        "unsupported_image_media_type",
        "empty_image_file",
        "failed_to_download_image",
        "image_file_not_found",
    ]
    """The error code for the response."""

    message: str
    """A human-readable description of the error."""


class ResponseIncompleteDetails(BaseModel):
    reason: Optional[Literal["max_output_tokens", "content_filter"]] = None
    """The reason why the response is incomplete."""


ResponseOutput: TypeAlias = Annotated[
    Union[
        OutputMessage,
        FileSearchToolCall,
        FunctionToolCall,
        WebSearchToolCall,
        ComputerToolCall,
        ReasoningItem,
        ImageGenToolCall,
        CodeInterpreterToolCall,
        LocalShellToolCall,
        McpToolCall,
        McpListTools,
        McpApprovalRequest,
        CustomToolCall,
    ],
    PropertyInfo(discriminator="type"),
]


class ResponseUsageInputTokensDetails(BaseModel):
    cached_tokens: int
    """
    The number of tokens that were retrieved from the cache.
    [More on prompt caching](https://platform.openai.com/docs/guides/prompt-caching).
    """


class ResponseUsageOutputTokensDetails(BaseModel):
    reasoning_tokens: int
    """The number of reasoning tokens."""


class ResponseUsage(BaseModel):
    input_tokens: int
    """The number of input tokens."""

    input_tokens_details: ResponseUsageInputTokensDetails
    """A detailed breakdown of the input tokens."""

    output_tokens: int
    """The number of output tokens."""

    output_tokens_details: ResponseUsageOutputTokensDetails
    """A detailed breakdown of the output tokens."""

    total_tokens: int
    """The total number of tokens used."""


class Response(ModelResponsePropertiesStandard, ResponseProperties):
    id: str
    """Unique identifier for this Response."""

    created_at: float
    """Unix timestamp (in seconds) of when this Response was created."""

    error: Optional[ResponseError] = None
    """An error object returned when the model fails to generate a Response."""

    incomplete_details: Optional[ResponseIncompleteDetails] = None
    """Details about why the response is incomplete."""

    instructions: Union[str, List[InputItem], None] = None
    """A system (or developer) message inserted into the model's context.

    When using along with `previous_response_id`, the instructions from a previous
    response will not be carried over to the next response. This makes it simple to
    swap out system (or developer) messages in new responses.
    """

    object: Literal["response"]
    """The object type of this resource - always set to `response`."""

    output: List[ResponseOutput]
    """An array of content items generated by the model.

    - The length and order of items in the `output` array is dependent on the
      model's response.
    - Rather than accessing the first item in the `output` array and assuming it's
      an `assistant` message with the content generated by the model, you might
      consider using the `output_text` property where supported in SDKs.
    """

    parallel_tool_calls: bool
    """Whether to allow the model to run tool calls in parallel."""

    status: Optional[Literal["completed", "failed", "in_progress", "cancelled", "queued", "incomplete"]] = None
    """The status of the response generation.

    One of `completed`, `failed`, `in_progress`, `cancelled`, `queued`, or
    `incomplete`.
    """

    usage: Optional[ResponseUsage] = None
    """
    Represents token usage details including input tokens, output tokens, a
    breakdown of output tokens, and the total tokens used.
    """
