# -*- coding: utf8 -*-
# Copyright (c) 2017-2021 THL A29 Limited, a Tencent company. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AcceptAttachCcnInstancesRequest(AbstractModel):
    """AcceptAttachCcnInstances request structure.

    """

    def __init__(self):
        r"""
        :param _CcnId: The CCN instance ID, such as `ccn-f49l6u0z`.
        :type CcnId: str
        :param _Instances: List of associated instances.
        :type Instances: list of CcnInstance
        """
        self._CcnId = None
        self._Instances = None

    @property
    def CcnId(self):
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def Instances(self):
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = CcnInstance()
                obj._deserialize(item)
                self._Instances.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AcceptAttachCcnInstancesResponse(AbstractModel):
    """AcceptAttachCcnInstances response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AccountAttribute(AbstractModel):
    """Account attribute object

    """

    def __init__(self):
        r"""
        :param _AttributeName: Attribute name
        :type AttributeName: str
        :param _AttributeValues: Attribute values
        :type AttributeValues: list of str
        """
        self._AttributeName = None
        self._AttributeValues = None

    @property
    def AttributeName(self):
        return self._AttributeName

    @AttributeName.setter
    def AttributeName(self, AttributeName):
        self._AttributeName = AttributeName

    @property
    def AttributeValues(self):
        return self._AttributeValues

    @AttributeValues.setter
    def AttributeValues(self, AttributeValues):
        self._AttributeValues = AttributeValues


    def _deserialize(self, params):
        self._AttributeName = params.get("AttributeName")
        self._AttributeValues = params.get("AttributeValues")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddBandwidthPackageResourcesRequest(AbstractModel):
    """AddBandwidthPackageResources request structure.

    """

    def __init__(self):
        r"""
        :param _ResourceIds: The unique ID of the source, such as 'eip-xxxx' and 'lb-xxxx'. EIP and LB resources are currently supported.
        :type ResourceIds: list of str
        :param _BandwidthPackageId: The unique ID of the bandwidth package, such as 'bwp-xxxx'.
        :type BandwidthPackageId: str
        :param _NetworkType: The network type of the bandwidth package. Valid value: `BGP`, indicating that the internal resource is a BGP IP.
        :type NetworkType: str
        :param _ResourceType: The resource type, including `Address` and `LoadBalance`.
        :type ResourceType: str
        :param _Protocol: The protocol type of the bandwidth package. Valid values: `ipv4` and `ipv6`.
        :type Protocol: str
        """
        self._ResourceIds = None
        self._BandwidthPackageId = None
        self._NetworkType = None
        self._ResourceType = None
        self._Protocol = None

    @property
    def ResourceIds(self):
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def BandwidthPackageId(self):
        return self._BandwidthPackageId

    @BandwidthPackageId.setter
    def BandwidthPackageId(self, BandwidthPackageId):
        self._BandwidthPackageId = BandwidthPackageId

    @property
    def NetworkType(self):
        return self._NetworkType

    @NetworkType.setter
    def NetworkType(self, NetworkType):
        self._NetworkType = NetworkType

    @property
    def ResourceType(self):
        return self._ResourceType

    @ResourceType.setter
    def ResourceType(self, ResourceType):
        self._ResourceType = ResourceType

    @property
    def Protocol(self):
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol


    def _deserialize(self, params):
        self._ResourceIds = params.get("ResourceIds")
        self._BandwidthPackageId = params.get("BandwidthPackageId")
        self._NetworkType = params.get("NetworkType")
        self._ResourceType = params.get("ResourceType")
        self._Protocol = params.get("Protocol")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddBandwidthPackageResourcesResponse(AbstractModel):
    """AddBandwidthPackageResources response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class Address(AbstractModel):
    """Detailed EIP information

    """

    def __init__(self):
        r"""
        :param _AddressId: `EIP` `ID`, the unique ID of the `EIP`.
        :type AddressId: str
        :param _AddressName: The `EIP` name.
        :type AddressName: str
        :param _AddressStatus: Possible `EIP` states are 'CREATING', 'BINDING', 'BIND', 'UNBINDING', 'UNBIND', 'OFFLINING', and 'BIND_ENI'.
        :type AddressStatus: str
        :param _AddressIp: The public IP address
        :type AddressIp: str
        :param _InstanceId: The ID of the bound resource instance. This can be a `CVM` or `NAT`.
        :type InstanceId: str
        :param _CreatedTime: The creation time, which follows the `ISO8601` standard and uses `UTC` time in the format of `YYYY-MM-DDThh:mm:ssZ`.
        :type CreatedTime: str
        :param _NetworkInterfaceId: The ID of the bound ENI
        :type NetworkInterfaceId: str
        :param _PrivateAddressIp: The private IP of the bound resources
        :type PrivateAddressIp: str
        :param _IsArrears: The isolation status of the resource. `True` indicates the EIP is isolated. `False` indicates that the resource is not isolated.
        :type IsArrears: bool
        :param _IsBlocked: The block status of the resource. `True` indicates the EIP is blocked. `False` indicates that the EIP is not blocked.
        :type IsBlocked: bool
        :param _IsEipDirectConnection: Whether the EIP supports direct connection mode. `True` indicates the EIP supports direct connection. `False` indicates that the resource does not support direct connection.
        :type IsEipDirectConnection: bool
        :param _AddressType: IP type. Valid values: `CalcIP` (device IP), `WanIP` (public network IP), `EIP` (general elastic IP), `AnycastEIP` (accelerated EIP), and `AntiDDoSEIP` (Anti DDoS EIP).
        :type AddressType: str
        :param _CascadeRelease: Whether the EIP is automatically released after being unbound. `True` indicates the EIP will be automatically released after being unbound. `False` indicates the EIP will not be automatically released after being unbound.
        :type CascadeRelease: bool
        :param _EipAlgType: Type of the protocol used in EIP ALG
        :type EipAlgType: :class:`tencentcloud.vpc.v20170312.models.AlgType`
        :param _InternetServiceProvider: The ISP of an EIP/Elastic IP, with possible return values currently including "CMCC", "CTCC", "CUCC" and "BGP"
        :type InternetServiceProvider: str
        :param _LocalBgp: Whether the EIP is in a local BGP.
        :type LocalBgp: bool
        :param _Bandwidth: Bandwidth value of EIP. The EIP for the bill-by-CVM account will return `null`.
Note: this field may return `null`, indicating that no valid value was found.
        :type Bandwidth: int
        :param _InternetChargeType: Network billing mode of EIP. The EIP for the bill-by-CVM account will return `null`.
Note: this field may return `null`, indicating that no valid value was found.
Including:
<li><strong>BANDWIDTH_PREPAID_BY_MONTH</strong></li>
<p style="padding-left: 30px;">Prepaid by monthly-subscribed bandwidth.</p>
<li><strong>TRAFFIC_POSTPAID_BY_HOUR</strong></li>
<p style="padding-left: 30px;">Pay-as-you-go billing by hourly traffic.</p>
<li><strong>BANDWIDTH_POSTPAID_BY_HOUR</strong></li>
<p style="padding-left: 30px;">Pay-as-you-go billing by hourly bandwidth.</p>
<li><strong>BANDWIDTH_PACKAGE</strong></li>
<p style="padding-left: 30px;">Bandwidth package.</p>
Note: this field may return `null`, indicating that no valid value was found.
        :type InternetChargeType: str
        :param _TagSet: List of tags associated with the EIP
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type TagSet: list of Tag
        :param _DeadlineDate: The expiration time.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type DeadlineDate: str
        :param _InstanceType: The type of instance bound with the EIP
Note: this field may return `null`, indicating that no valid value was found.
        :type InstanceType: str
        :param _AntiDDoSPackageId: ID of the Anti-DDoS service package. It is returned if the EIP is an u200dAnti-DDoS EIP. 
        :type AntiDDoSPackageId: str
        """
        self._AddressId = None
        self._AddressName = None
        self._AddressStatus = None
        self._AddressIp = None
        self._InstanceId = None
        self._CreatedTime = None
        self._NetworkInterfaceId = None
        self._PrivateAddressIp = None
        self._IsArrears = None
        self._IsBlocked = None
        self._IsEipDirectConnection = None
        self._AddressType = None
        self._CascadeRelease = None
        self._EipAlgType = None
        self._InternetServiceProvider = None
        self._LocalBgp = None
        self._Bandwidth = None
        self._InternetChargeType = None
        self._TagSet = None
        self._DeadlineDate = None
        self._InstanceType = None
        self._AntiDDoSPackageId = None

    @property
    def AddressId(self):
        return self._AddressId

    @AddressId.setter
    def AddressId(self, AddressId):
        self._AddressId = AddressId

    @property
    def AddressName(self):
        return self._AddressName

    @AddressName.setter
    def AddressName(self, AddressName):
        self._AddressName = AddressName

    @property
    def AddressStatus(self):
        return self._AddressStatus

    @AddressStatus.setter
    def AddressStatus(self, AddressStatus):
        self._AddressStatus = AddressStatus

    @property
    def AddressIp(self):
        return self._AddressIp

    @AddressIp.setter
    def AddressIp(self, AddressIp):
        self._AddressIp = AddressIp

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def CreatedTime(self):
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def NetworkInterfaceId(self):
        return self._NetworkInterfaceId

    @NetworkInterfaceId.setter
    def NetworkInterfaceId(self, NetworkInterfaceId):
        self._NetworkInterfaceId = NetworkInterfaceId

    @property
    def PrivateAddressIp(self):
        return self._PrivateAddressIp

    @PrivateAddressIp.setter
    def PrivateAddressIp(self, PrivateAddressIp):
        self._PrivateAddressIp = PrivateAddressIp

    @property
    def IsArrears(self):
        return self._IsArrears

    @IsArrears.setter
    def IsArrears(self, IsArrears):
        self._IsArrears = IsArrears

    @property
    def IsBlocked(self):
        return self._IsBlocked

    @IsBlocked.setter
    def IsBlocked(self, IsBlocked):
        self._IsBlocked = IsBlocked

    @property
    def IsEipDirectConnection(self):
        return self._IsEipDirectConnection

    @IsEipDirectConnection.setter
    def IsEipDirectConnection(self, IsEipDirectConnection):
        self._IsEipDirectConnection = IsEipDirectConnection

    @property
    def AddressType(self):
        return self._AddressType

    @AddressType.setter
    def AddressType(self, AddressType):
        self._AddressType = AddressType

    @property
    def CascadeRelease(self):
        return self._CascadeRelease

    @CascadeRelease.setter
    def CascadeRelease(self, CascadeRelease):
        self._CascadeRelease = CascadeRelease

    @property
    def EipAlgType(self):
        return self._EipAlgType

    @EipAlgType.setter
    def EipAlgType(self, EipAlgType):
        self._EipAlgType = EipAlgType

    @property
    def InternetServiceProvider(self):
        return self._InternetServiceProvider

    @InternetServiceProvider.setter
    def InternetServiceProvider(self, InternetServiceProvider):
        self._InternetServiceProvider = InternetServiceProvider

    @property
    def LocalBgp(self):
        return self._LocalBgp

    @LocalBgp.setter
    def LocalBgp(self, LocalBgp):
        self._LocalBgp = LocalBgp

    @property
    def Bandwidth(self):
        return self._Bandwidth

    @Bandwidth.setter
    def Bandwidth(self, Bandwidth):
        self._Bandwidth = Bandwidth

    @property
    def InternetChargeType(self):
        return self._InternetChargeType

    @InternetChargeType.setter
    def InternetChargeType(self, InternetChargeType):
        self._InternetChargeType = InternetChargeType

    @property
    def TagSet(self):
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet

    @property
    def DeadlineDate(self):
        return self._DeadlineDate

    @DeadlineDate.setter
    def DeadlineDate(self, DeadlineDate):
        self._DeadlineDate = DeadlineDate

    @property
    def InstanceType(self):
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def AntiDDoSPackageId(self):
        return self._AntiDDoSPackageId

    @AntiDDoSPackageId.setter
    def AntiDDoSPackageId(self, AntiDDoSPackageId):
        self._AntiDDoSPackageId = AntiDDoSPackageId


    def _deserialize(self, params):
        self._AddressId = params.get("AddressId")
        self._AddressName = params.get("AddressName")
        self._AddressStatus = params.get("AddressStatus")
        self._AddressIp = params.get("AddressIp")
        self._InstanceId = params.get("InstanceId")
        self._CreatedTime = params.get("CreatedTime")
        self._NetworkInterfaceId = params.get("NetworkInterfaceId")
        self._PrivateAddressIp = params.get("PrivateAddressIp")
        self._IsArrears = params.get("IsArrears")
        self._IsBlocked = params.get("IsBlocked")
        self._IsEipDirectConnection = params.get("IsEipDirectConnection")
        self._AddressType = params.get("AddressType")
        self._CascadeRelease = params.get("CascadeRelease")
        if params.get("EipAlgType") is not None:
            self._EipAlgType = AlgType()
            self._EipAlgType._deserialize(params.get("EipAlgType"))
        self._InternetServiceProvider = params.get("InternetServiceProvider")
        self._LocalBgp = params.get("LocalBgp")
        self._Bandwidth = params.get("Bandwidth")
        self._InternetChargeType = params.get("InternetChargeType")
        if params.get("TagSet") is not None:
            self._TagSet = []
            for item in params.get("TagSet"):
                obj = Tag()
                obj._deserialize(item)
                self._TagSet.append(obj)
        self._DeadlineDate = params.get("DeadlineDate")
        self._InstanceType = params.get("InstanceType")
        self._AntiDDoSPackageId = params.get("AntiDDoSPackageId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddressChargePrepaid(AbstractModel):
    """EIP cost object

    """

    def __init__(self):
        r"""
        :param _Period: Purchased usage period, in month. Valid values: 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 24, 36
        :type Period: int
        :param _AutoRenewFlag: Setting of renewal. Valid values: 0: manual renewal; 1: auto-renewal; 2: no renewal after expiration. Default value: 0
        :type AutoRenewFlag: int
        """
        self._Period = None
        self._AutoRenewFlag = None

    @property
    def Period(self):
        return self._Period

    @Period.setter
    def Period(self, Period):
        self._Period = Period

    @property
    def AutoRenewFlag(self):
        return self._AutoRenewFlag

    @AutoRenewFlag.setter
    def AutoRenewFlag(self, AutoRenewFlag):
        self._AutoRenewFlag = AutoRenewFlag


    def _deserialize(self, params):
        self._Period = params.get("Period")
        self._AutoRenewFlag = params.get("AutoRenewFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddressInfo(AbstractModel):
    """IP address template information

    """

    def __init__(self):
        r"""
        :param _Address: IP address
        :type Address: str
        :param _Description: Remarks
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type Description: str
        """
        self._Address = None
        self._Description = None

    @property
    def Address(self):
        return self._Address

    @Address.setter
    def Address(self, Address):
        self._Address = Address

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._Address = params.get("Address")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddressTemplate(AbstractModel):
    """IP address template

    """

    def __init__(self):
        r"""
        :param _AddressTemplateName: IP address template name.
        :type AddressTemplateName: str
        :param _AddressTemplateId: The unique ID of the IP address template instance.
        :type AddressTemplateId: str
        :param _AddressSet: IP address information.
        :type AddressSet: list of str
        :param _CreatedTime: Creation Time.
        :type CreatedTime: str
        :param _AddressExtraSet: IP address information with remarks
        :type AddressExtraSet: list of AddressInfo
        """
        self._AddressTemplateName = None
        self._AddressTemplateId = None
        self._AddressSet = None
        self._CreatedTime = None
        self._AddressExtraSet = None

    @property
    def AddressTemplateName(self):
        return self._AddressTemplateName

    @AddressTemplateName.setter
    def AddressTemplateName(self, AddressTemplateName):
        self._AddressTemplateName = AddressTemplateName

    @property
    def AddressTemplateId(self):
        return self._AddressTemplateId

    @AddressTemplateId.setter
    def AddressTemplateId(self, AddressTemplateId):
        self._AddressTemplateId = AddressTemplateId

    @property
    def AddressSet(self):
        return self._AddressSet

    @AddressSet.setter
    def AddressSet(self, AddressSet):
        self._AddressSet = AddressSet

    @property
    def CreatedTime(self):
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def AddressExtraSet(self):
        return self._AddressExtraSet

    @AddressExtraSet.setter
    def AddressExtraSet(self, AddressExtraSet):
        self._AddressExtraSet = AddressExtraSet


    def _deserialize(self, params):
        self._AddressTemplateName = params.get("AddressTemplateName")
        self._AddressTemplateId = params.get("AddressTemplateId")
        self._AddressSet = params.get("AddressSet")
        self._CreatedTime = params.get("CreatedTime")
        if params.get("AddressExtraSet") is not None:
            self._AddressExtraSet = []
            for item in params.get("AddressExtraSet"):
                obj = AddressInfo()
                obj._deserialize(item)
                self._AddressExtraSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddressTemplateGroup(AbstractModel):
    """IP address template group

    """

    def __init__(self):
        r"""
        :param _AddressTemplateGroupName: IP address template group name.
        :type AddressTemplateGroupName: str
        :param _AddressTemplateGroupId: IP address template group instance ID, such as `ipmg-dih8xdbq`.
        :type AddressTemplateGroupId: str
        :param _AddressTemplateIdSet: IP address template ID.
        :type AddressTemplateIdSet: list of str
        :param _CreatedTime: Creation Time.
        :type CreatedTime: str
        :param _AddressTemplateSet: IP address template instance
        :type AddressTemplateSet: list of AddressTemplateItem
        """
        self._AddressTemplateGroupName = None
        self._AddressTemplateGroupId = None
        self._AddressTemplateIdSet = None
        self._CreatedTime = None
        self._AddressTemplateSet = None

    @property
    def AddressTemplateGroupName(self):
        return self._AddressTemplateGroupName

    @AddressTemplateGroupName.setter
    def AddressTemplateGroupName(self, AddressTemplateGroupName):
        self._AddressTemplateGroupName = AddressTemplateGroupName

    @property
    def AddressTemplateGroupId(self):
        return self._AddressTemplateGroupId

    @AddressTemplateGroupId.setter
    def AddressTemplateGroupId(self, AddressTemplateGroupId):
        self._AddressTemplateGroupId = AddressTemplateGroupId

    @property
    def AddressTemplateIdSet(self):
        return self._AddressTemplateIdSet

    @AddressTemplateIdSet.setter
    def AddressTemplateIdSet(self, AddressTemplateIdSet):
        self._AddressTemplateIdSet = AddressTemplateIdSet

    @property
    def CreatedTime(self):
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def AddressTemplateSet(self):
        return self._AddressTemplateSet

    @AddressTemplateSet.setter
    def AddressTemplateSet(self, AddressTemplateSet):
        self._AddressTemplateSet = AddressTemplateSet


    def _deserialize(self, params):
        self._AddressTemplateGroupName = params.get("AddressTemplateGroupName")
        self._AddressTemplateGroupId = params.get("AddressTemplateGroupId")
        self._AddressTemplateIdSet = params.get("AddressTemplateIdSet")
        self._CreatedTime = params.get("CreatedTime")
        if params.get("AddressTemplateSet") is not None:
            self._AddressTemplateSet = []
            for item in params.get("AddressTemplateSet"):
                obj = AddressTemplateItem()
                obj._deserialize(item)
                self._AddressTemplateSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddressTemplateItem(AbstractModel):
    """Address information

    """

    def __init__(self):
        r"""
        :param _AddressTemplateId: ipm-xxxxxxxx
        :type AddressTemplateId: str
        :param _AddressTemplateName: IP template name
        :type AddressTemplateName: str
        :param _From: Disused
        :type From: str
        :param _To: Disused
        :type To: str
        """
        self._AddressTemplateId = None
        self._AddressTemplateName = None
        self._From = None
        self._To = None

    @property
    def AddressTemplateId(self):
        return self._AddressTemplateId

    @AddressTemplateId.setter
    def AddressTemplateId(self, AddressTemplateId):
        self._AddressTemplateId = AddressTemplateId

    @property
    def AddressTemplateName(self):
        return self._AddressTemplateName

    @AddressTemplateName.setter
    def AddressTemplateName(self, AddressTemplateName):
        self._AddressTemplateName = AddressTemplateName

    @property
    def From(self):
        return self._From

    @From.setter
    def From(self, From):
        self._From = From

    @property
    def To(self):
        return self._To

    @To.setter
    def To(self, To):
        self._To = To


    def _deserialize(self, params):
        self._AddressTemplateId = params.get("AddressTemplateId")
        self._AddressTemplateName = params.get("AddressTemplateName")
        self._From = params.get("From")
        self._To = params.get("To")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddressTemplateSpecification(AbstractModel):
    """IP address template

    """

    def __init__(self):
        r"""
        :param _AddressId: The ID of the IP address, such as `ipm-2uw6ujo6`.
        :type AddressId: str
        :param _AddressGroupId: The ID of the IP address group, such as `ipmg-2uw6ujo6`.
        :type AddressGroupId: str
        """
        self._AddressId = None
        self._AddressGroupId = None

    @property
    def AddressId(self):
        return self._AddressId

    @AddressId.setter
    def AddressId(self, AddressId):
        self._AddressId = AddressId

    @property
    def AddressGroupId(self):
        return self._AddressGroupId

    @AddressGroupId.setter
    def AddressGroupId(self, AddressGroupId):
        self._AddressGroupId = AddressGroupId


    def _deserialize(self, params):
        self._AddressId = params.get("AddressId")
        self._AddressGroupId = params.get("AddressGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdjustPublicAddressRequest(AbstractModel):
    """AdjustPublicAddress request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: The unique ID of the CVM instance, such as `ins-11112222`.
        :type InstanceId: str
        :param _AddressId: The unique ID of the EIP, such as `eip-11112222`.
        :type AddressId: str
        """
        self._InstanceId = None
        self._AddressId = None

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def AddressId(self):
        return self._AddressId

    @AddressId.setter
    def AddressId(self, AddressId):
        self._AddressId = AddressId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._AddressId = params.get("AddressId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdjustPublicAddressResponse(AbstractModel):
    """AdjustPublicAddress response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: The async task ID. You can use the [DescribeTaskResult](https://intl.cloud.tencent.com/document/api/215/36271?from_cn_redirect=1) API to query the task status.
        :type TaskId: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class AlgType(AbstractModel):
    """ALG protocol type

    """

    def __init__(self):
        r"""
        :param _Ftp: Whether FTP ALG is enabled
        :type Ftp: bool
        :param _Sip: Whether SIP ALG is enabled
        :type Sip: bool
        """
        self._Ftp = None
        self._Sip = None

    @property
    def Ftp(self):
        return self._Ftp

    @Ftp.setter
    def Ftp(self, Ftp):
        self._Ftp = Ftp

    @property
    def Sip(self):
        return self._Sip

    @Sip.setter
    def Sip(self, Sip):
        self._Sip = Sip


    def _deserialize(self, params):
        self._Ftp = params.get("Ftp")
        self._Sip = params.get("Sip")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AllocateAddressesRequest(AbstractModel):
    """AllocateAddresses request structure.

    """

    def __init__(self):
        r"""
        :param _AddressCount: The number of EIPs. Default: 1.
        :type AddressCount: int
        :param _InternetServiceProvider: The EIP line type. Default: BGP.
<ul style="margin:0"><li>For a user who has activated the static single-line IP allowlist, possible values are:<ul><li>CMCC: China Mobile</li>
<li>CTCC: China Telecom</li>
<li>CUCC: China Unicom</li></ul>Note: Only certain regions support static single-line IP addresses.</li></ul>
        :type InternetServiceProvider: str
        :param _InternetChargeType: The EIP billing method.
<ul style="margin:0"><li>For bill-by-IP account beta users, valid values: <ul><li>BANDWIDTH_PACKAGE: paid by the [bandwidth package](https://intl.cloud.tencent.com/document/product/684/15255?from_cn_redirect=1)(who must also be bandwidth package beta users)</li>
<li>BANDWIDTH_POSTPAID_BY_HOUR: billed by hourly bandwidth on a pay-as-you-go basis</li>
<li>BANDWIDTH_PREPAID_BY_MONTH: monthly bandwidth subscription</li>
<li>TRAFFIC_POSTPAID_BY_HOUR: billed by hourly traffic on a pay-as-you-go basis</li></ul>Default value: TRAFFIC_POSTPAID_BY_HOUR</li>
<li>If you are not a bill-by-IP account beta user, the EIP billing is the same as that for the instance bound to the EIP. Therefore, you do not need to pass in this parameter.</li></ul>
        :type InternetChargeType: str
        :param _InternetMaxBandwidthOut: The EIP outbound bandwidth cap, in Mbps.
<ul style="margin:0"><li>For bill-by-IP account beta users, the bandwidth cap range is determined by the EIP billing mode. <ul><li>`BANDWIDTH_PACKAGE`: 1 Mbps to 2000 Mbps</li>
<li>`BANDWIDTH_POSTPAID_BY_HOUR`: 1 Mbps to 100 Mbps</li>
<li>`BANDWIDTH_PREPAID_BY_MONTH`: 1 Mbps to 200 Mbps</li>
<li>`TRAFFIC_POSTPAID_BY_HOUR`: 1 Mbps to 100 Mbps</li></ul>Default value: 1 Mbps </li>
<li>If you are not a bill-by-IP account beta user, the EIP outbound bandwidth cap is subject to the bandwidth cap of the instance bound to the EIP. Therefore, you do not need to pass in this parameter. </li></ul>
        :type InternetMaxBandwidthOut: int
        :param _AddressChargePrepaid: A required billing parameter for an EIP billed by monthly bandwidth subscription. For EIPs using other billing modes, it can be ignored.
        :type AddressChargePrepaid: :class:`tencentcloud.vpc.v20170312.models.AddressChargePrepaid`
        :param _AddressType: EIP type. Default value: EIP.
<ul style="margin:0"><li>For beta users of AIA, the value can be:</li></ul>`AnycastEIP`: an AIA IP address. For more information, see [Anycast Internet Acceleration](https://intl.cloud.tencent.com/document/product/644?from_cn_redirect=1).</li></ul>Note: Anycast EIPs are supported only in partial regions. </li></ul>
<ul style="margin:0"><li>For beta users of dedicated IP, the value can be: <ul><li>`HighQualityEIP`: Dedicated IP</li></ul>Note that dedicated IPs are only available in partial regions. </li></ul>
</ul>
<ul style="margin:0"><li>For beta users of Anti-DDoS IP, the value can be: <ul><li>`AntiDDoSEIP`: Anti-DDoS EIP</li></ul>Note that Anti-DDoS IPs are only available in partial regions. </li></ul>
        :type AddressType: str
        :param _AnycastZone: Anycast publishing region
<ul style="margin:0"><li>Valid for users who have activated AIA. Values:<ul><li>ANYCAST_ZONE_GLOBAL: global publishing region </li><li>ANYCAST_ZONE_OVERSEAS: overseas publishing region</li><li><b>**[Disused]**</b> ANYCAST_ZONE_A: publishing region A (updated to ANYCAST_ZONE_GLOBAL)</li><li><b>**[Disused]**</b> ANYCAST_ZONE_B: publishing region B (updated to ANYCAST_ZONE_GLOBAL)</li></ul>Default: ANYCAST_ZONE_OVERSEAS.</li></ul>
        :type AnycastZone: str
        :param _ApplicableForCLB: <b>**[Disused]**</b>
Whether the Anycast EIP can be bound to CLB instances.
<ul style="margin:0"><li>Valid for users who have activated the AIA. Values:<ul><li>TRUE: the Anycast EIP can be bound to CLB instances.</li>
<li>FALSE: the Anycast EIP can be bound to CVMs, NAT gateways, and HAVIPs.</li></ul>Default: FALSE.</li></ul>
        :type ApplicableForCLB: bool
        :param _Tags: List of tags to be bound.
        :type Tags: list of Tag
        :param _BandwidthPackageId: The unique ID of a BGP bandwidth package. If you configure this parameter and set InternetChargeType as BANDWIDTH_PACKAGE, the new EIP is added to this package and billed by the bandwidth package mode.
        :type BandwidthPackageId: str
        :param _AddressName: EIP name, which is the custom EIP name given by the user when applying for the EIP. Default: not named
        :type AddressName: str
        :param _Egress: Network egress. It defaults to `center_egress1`.
        :type Egress: str
        :param _AntiDDoSPackageId: Anti-DDoS service package ID. This is required when you want to request an u200dAnti-DDoS IP.
        :type AntiDDoSPackageId: str
        :param _ClientToken: A string used to ensure the idempotency of the request. Generate a value based on your client. This can ensure that the value is unique for different requests. It only supports ASCII characters and can contain up to 64 characters. 
        :type ClientToken: str
        """
        self._AddressCount = None
        self._InternetServiceProvider = None
        self._InternetChargeType = None
        self._InternetMaxBandwidthOut = None
        self._AddressChargePrepaid = None
        self._AddressType = None
        self._AnycastZone = None
        self._ApplicableForCLB = None
        self._Tags = None
        self._BandwidthPackageId = None
        self._AddressName = None
        self._Egress = None
        self._AntiDDoSPackageId = None
        self._ClientToken = None

    @property
    def AddressCount(self):
        return self._AddressCount

    @AddressCount.setter
    def AddressCount(self, AddressCount):
        self._AddressCount = AddressCount

    @property
    def InternetServiceProvider(self):
        return self._InternetServiceProvider

    @InternetServiceProvider.setter
    def InternetServiceProvider(self, InternetServiceProvider):
        self._InternetServiceProvider = InternetServiceProvider

    @property
    def InternetChargeType(self):
        return self._InternetChargeType

    @InternetChargeType.setter
    def InternetChargeType(self, InternetChargeType):
        self._InternetChargeType = InternetChargeType

    @property
    def InternetMaxBandwidthOut(self):
        return self._InternetMaxBandwidthOut

    @InternetMaxBandwidthOut.setter
    def InternetMaxBandwidthOut(self, InternetMaxBandwidthOut):
        self._InternetMaxBandwidthOut = InternetMaxBandwidthOut

    @property
    def AddressChargePrepaid(self):
        return self._AddressChargePrepaid

    @AddressChargePrepaid.setter
    def AddressChargePrepaid(self, AddressChargePrepaid):
        self._AddressChargePrepaid = AddressChargePrepaid

    @property
    def AddressType(self):
        return self._AddressType

    @AddressType.setter
    def AddressType(self, AddressType):
        self._AddressType = AddressType

    @property
    def AnycastZone(self):
        return self._AnycastZone

    @AnycastZone.setter
    def AnycastZone(self, AnycastZone):
        self._AnycastZone = AnycastZone

    @property
    def ApplicableForCLB(self):
        return self._ApplicableForCLB

    @ApplicableForCLB.setter
    def ApplicableForCLB(self, ApplicableForCLB):
        self._ApplicableForCLB = ApplicableForCLB

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def BandwidthPackageId(self):
        return self._BandwidthPackageId

    @BandwidthPackageId.setter
    def BandwidthPackageId(self, BandwidthPackageId):
        self._BandwidthPackageId = BandwidthPackageId

    @property
    def AddressName(self):
        return self._AddressName

    @AddressName.setter
    def AddressName(self, AddressName):
        self._AddressName = AddressName

    @property
    def Egress(self):
        return self._Egress

    @Egress.setter
    def Egress(self, Egress):
        self._Egress = Egress

    @property
    def AntiDDoSPackageId(self):
        return self._AntiDDoSPackageId

    @AntiDDoSPackageId.setter
    def AntiDDoSPackageId(self, AntiDDoSPackageId):
        self._AntiDDoSPackageId = AntiDDoSPackageId

    @property
    def ClientToken(self):
        return self._ClientToken

    @ClientToken.setter
    def ClientToken(self, ClientToken):
        self._ClientToken = ClientToken


    def _deserialize(self, params):
        self._AddressCount = params.get("AddressCount")
        self._InternetServiceProvider = params.get("InternetServiceProvider")
        self._InternetChargeType = params.get("InternetChargeType")
        self._InternetMaxBandwidthOut = params.get("InternetMaxBandwidthOut")
        if params.get("AddressChargePrepaid") is not None:
            self._AddressChargePrepaid = AddressChargePrepaid()
            self._AddressChargePrepaid._deserialize(params.get("AddressChargePrepaid"))
        self._AddressType = params.get("AddressType")
        self._AnycastZone = params.get("AnycastZone")
        self._ApplicableForCLB = params.get("ApplicableForCLB")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._BandwidthPackageId = params.get("BandwidthPackageId")
        self._AddressName = params.get("AddressName")
        self._Egress = params.get("Egress")
        self._AntiDDoSPackageId = params.get("AntiDDoSPackageId")
        self._ClientToken = params.get("ClientToken")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AllocateAddressesResponse(AbstractModel):
    """AllocateAddresses response structure.

    """

    def __init__(self):
        r"""
        :param _AddressSet: List of the unique IDs of the requested EIPs.
        :type AddressSet: list of str
        :param _TaskId: The Async task ID. You can use the [DescribeTaskResult](https://intl.cloud.tencent.com/document/api/215/36271?from_cn_redirect=1) API to query the task status.
        :type TaskId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AddressSet = None
        self._TaskId = None
        self._RequestId = None

    @property
    def AddressSet(self):
        return self._AddressSet

    @AddressSet.setter
    def AddressSet(self, AddressSet):
        self._AddressSet = AddressSet

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AddressSet = params.get("AddressSet")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class AssignIpv6AddressesRequest(AbstractModel):
    """AssignIpv6Addresses request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkInterfaceId: The `ID` of the ENI instance, such as `eni-m6dyj72l`.
        :type NetworkInterfaceId: str
        :param _Ipv6Addresses: A list of `IPv6` addresses. You can specify a maximum of 10 at one time. The quota is calculated together with that of `Ipv6AddressCount`, a required input parameter alternative to this one.
        :type Ipv6Addresses: list of Ipv6Address
        :param _Ipv6AddressCount: The number of automatically assigned `IPv6` addresses. The total number of private IP addresses cannot exceed the quota. The quota is calculated together with that of `Ipv6Addresses`, a required input parameter alternative to this one.
        :type Ipv6AddressCount: int
        """
        self._NetworkInterfaceId = None
        self._Ipv6Addresses = None
        self._Ipv6AddressCount = None

    @property
    def NetworkInterfaceId(self):
        return self._NetworkInterfaceId

    @NetworkInterfaceId.setter
    def NetworkInterfaceId(self, NetworkInterfaceId):
        self._NetworkInterfaceId = NetworkInterfaceId

    @property
    def Ipv6Addresses(self):
        return self._Ipv6Addresses

    @Ipv6Addresses.setter
    def Ipv6Addresses(self, Ipv6Addresses):
        self._Ipv6Addresses = Ipv6Addresses

    @property
    def Ipv6AddressCount(self):
        return self._Ipv6AddressCount

    @Ipv6AddressCount.setter
    def Ipv6AddressCount(self, Ipv6AddressCount):
        self._Ipv6AddressCount = Ipv6AddressCount


    def _deserialize(self, params):
        self._NetworkInterfaceId = params.get("NetworkInterfaceId")
        if params.get("Ipv6Addresses") is not None:
            self._Ipv6Addresses = []
            for item in params.get("Ipv6Addresses"):
                obj = Ipv6Address()
                obj._deserialize(item)
                self._Ipv6Addresses.append(obj)
        self._Ipv6AddressCount = params.get("Ipv6AddressCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssignIpv6AddressesResponse(AbstractModel):
    """AssignIpv6Addresses response structure.

    """

    def __init__(self):
        r"""
        :param _Ipv6AddressSet: The list of `IPv6` addresses assigned to ENIs.
        :type Ipv6AddressSet: list of Ipv6Address
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Ipv6AddressSet = None
        self._RequestId = None

    @property
    def Ipv6AddressSet(self):
        return self._Ipv6AddressSet

    @Ipv6AddressSet.setter
    def Ipv6AddressSet(self, Ipv6AddressSet):
        self._Ipv6AddressSet = Ipv6AddressSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Ipv6AddressSet") is not None:
            self._Ipv6AddressSet = []
            for item in params.get("Ipv6AddressSet"):
                obj = Ipv6Address()
                obj._deserialize(item)
                self._Ipv6AddressSet.append(obj)
        self._RequestId = params.get("RequestId")


class AssignIpv6CidrBlockRequest(AbstractModel):
    """AssignIpv6CidrBlock request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: The `ID` of the `VPC`, such as `vpc-f49l6u0z`.
        :type VpcId: str
        """
        self._VpcId = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssignIpv6CidrBlockResponse(AbstractModel):
    """AssignIpv6CidrBlock response structure.

    """

    def __init__(self):
        r"""
        :param _Ipv6CidrBlock: The assigned `IPv6` IP range, such as `3402:4e00:20:1000::/56`
        :type Ipv6CidrBlock: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Ipv6CidrBlock = None
        self._RequestId = None

    @property
    def Ipv6CidrBlock(self):
        return self._Ipv6CidrBlock

    @Ipv6CidrBlock.setter
    def Ipv6CidrBlock(self, Ipv6CidrBlock):
        self._Ipv6CidrBlock = Ipv6CidrBlock

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Ipv6CidrBlock = params.get("Ipv6CidrBlock")
        self._RequestId = params.get("RequestId")


class AssignIpv6SubnetCidrBlockRequest(AbstractModel):
    """AssignIpv6SubnetCidrBlock request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: The `ID` of the VPC where the subnet is located, such as `vpc-f49l6u0z`.
        :type VpcId: str
        :param _Ipv6SubnetCidrBlocks: The assigned `IPv6` subnet IP range list.
        :type Ipv6SubnetCidrBlocks: list of Ipv6SubnetCidrBlock
        """
        self._VpcId = None
        self._Ipv6SubnetCidrBlocks = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def Ipv6SubnetCidrBlocks(self):
        return self._Ipv6SubnetCidrBlocks

    @Ipv6SubnetCidrBlocks.setter
    def Ipv6SubnetCidrBlocks(self, Ipv6SubnetCidrBlocks):
        self._Ipv6SubnetCidrBlocks = Ipv6SubnetCidrBlocks


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        if params.get("Ipv6SubnetCidrBlocks") is not None:
            self._Ipv6SubnetCidrBlocks = []
            for item in params.get("Ipv6SubnetCidrBlocks"):
                obj = Ipv6SubnetCidrBlock()
                obj._deserialize(item)
                self._Ipv6SubnetCidrBlocks.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssignIpv6SubnetCidrBlockResponse(AbstractModel):
    """AssignIpv6SubnetCidrBlock response structure.

    """

    def __init__(self):
        r"""
        :param _Ipv6SubnetCidrBlockSet: The assigned `IPv6` subnet IP range list.
        :type Ipv6SubnetCidrBlockSet: list of Ipv6SubnetCidrBlock
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Ipv6SubnetCidrBlockSet = None
        self._RequestId = None

    @property
    def Ipv6SubnetCidrBlockSet(self):
        return self._Ipv6SubnetCidrBlockSet

    @Ipv6SubnetCidrBlockSet.setter
    def Ipv6SubnetCidrBlockSet(self, Ipv6SubnetCidrBlockSet):
        self._Ipv6SubnetCidrBlockSet = Ipv6SubnetCidrBlockSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Ipv6SubnetCidrBlockSet") is not None:
            self._Ipv6SubnetCidrBlockSet = []
            for item in params.get("Ipv6SubnetCidrBlockSet"):
                obj = Ipv6SubnetCidrBlock()
                obj._deserialize(item)
                self._Ipv6SubnetCidrBlockSet.append(obj)
        self._RequestId = params.get("RequestId")


class AssignPrivateIpAddressesRequest(AbstractModel):
    """AssignPrivateIpAddresses request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkInterfaceId: The ID of the ENI instance, such as `eni-m6dyj72l`.
        :type NetworkInterfaceId: str
        :param _PrivateIpAddresses: The information on private IP addresses, of which you can specify a maximum of 10 at a time. You should provide either this parameter or SecondaryPrivateIpAddressCount, or both.
        :type PrivateIpAddresses: list of PrivateIpAddressSpecification
        :param _SecondaryPrivateIpAddressCount: The number of newly-applied private IP addresses. You should provide either this parameter or PrivateIpAddresses, or both. The total number of private IP addresses cannot exceed the quota. For more information, see<a href="/document/product/576/18527">ENI Use Limits</a>.
        :type SecondaryPrivateIpAddressCount: int
        :param _QosLevel: IP u200dservice level. It is used together with `SecondaryPrivateIpAddressCount`. Values: PT` u200d(Gold), `AU` u200d(Silver), `AG `(Bronze) and DEFAULT (Default).
        :type QosLevel: str
        """
        self._NetworkInterfaceId = None
        self._PrivateIpAddresses = None
        self._SecondaryPrivateIpAddressCount = None
        self._QosLevel = None

    @property
    def NetworkInterfaceId(self):
        return self._NetworkInterfaceId

    @NetworkInterfaceId.setter
    def NetworkInterfaceId(self, NetworkInterfaceId):
        self._NetworkInterfaceId = NetworkInterfaceId

    @property
    def PrivateIpAddresses(self):
        return self._PrivateIpAddresses

    @PrivateIpAddresses.setter
    def PrivateIpAddresses(self, PrivateIpAddresses):
        self._PrivateIpAddresses = PrivateIpAddresses

    @property
    def SecondaryPrivateIpAddressCount(self):
        return self._SecondaryPrivateIpAddressCount

    @SecondaryPrivateIpAddressCount.setter
    def SecondaryPrivateIpAddressCount(self, SecondaryPrivateIpAddressCount):
        self._SecondaryPrivateIpAddressCount = SecondaryPrivateIpAddressCount

    @property
    def QosLevel(self):
        return self._QosLevel

    @QosLevel.setter
    def QosLevel(self, QosLevel):
        self._QosLevel = QosLevel


    def _deserialize(self, params):
        self._NetworkInterfaceId = params.get("NetworkInterfaceId")
        if params.get("PrivateIpAddresses") is not None:
            self._PrivateIpAddresses = []
            for item in params.get("PrivateIpAddresses"):
                obj = PrivateIpAddressSpecification()
                obj._deserialize(item)
                self._PrivateIpAddresses.append(obj)
        self._SecondaryPrivateIpAddressCount = params.get("SecondaryPrivateIpAddressCount")
        self._QosLevel = params.get("QosLevel")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssignPrivateIpAddressesResponse(AbstractModel):
    """AssignPrivateIpAddresses response structure.

    """

    def __init__(self):
        r"""
        :param _PrivateIpAddressSet: The detailed information of the Private IP.
        :type PrivateIpAddressSet: list of PrivateIpAddressSpecification
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._PrivateIpAddressSet = None
        self._RequestId = None

    @property
    def PrivateIpAddressSet(self):
        return self._PrivateIpAddressSet

    @PrivateIpAddressSet.setter
    def PrivateIpAddressSet(self, PrivateIpAddressSet):
        self._PrivateIpAddressSet = PrivateIpAddressSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("PrivateIpAddressSet") is not None:
            self._PrivateIpAddressSet = []
            for item in params.get("PrivateIpAddressSet"):
                obj = PrivateIpAddressSpecification()
                obj._deserialize(item)
                self._PrivateIpAddressSet.append(obj)
        self._RequestId = params.get("RequestId")


class AssistantCidr(AbstractModel):
    """Information about the secondary CIDR of the VPC.

    """

    def __init__(self):
        r"""
        :param _VpcId: The `ID` of a `VPC` instance, such as `vpc-6v2ht8q5`.
        :type VpcId: str
        :param _CidrBlock: The secondary CIDR, such as `172.16.0.0/16`.
        :type CidrBlock: str
        :param _AssistantType: The secondary CIDR block type. 0: common secondary CIDR block. 1: container secondary CIDR block. Default: 0.
        :type AssistantType: int
        :param _SubnetSet: Subnets divided by the secondary CIDR.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SubnetSet: list of Subnet
        """
        self._VpcId = None
        self._CidrBlock = None
        self._AssistantType = None
        self._SubnetSet = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def CidrBlock(self):
        return self._CidrBlock

    @CidrBlock.setter
    def CidrBlock(self, CidrBlock):
        self._CidrBlock = CidrBlock

    @property
    def AssistantType(self):
        return self._AssistantType

    @AssistantType.setter
    def AssistantType(self, AssistantType):
        self._AssistantType = AssistantType

    @property
    def SubnetSet(self):
        return self._SubnetSet

    @SubnetSet.setter
    def SubnetSet(self, SubnetSet):
        self._SubnetSet = SubnetSet


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._CidrBlock = params.get("CidrBlock")
        self._AssistantType = params.get("AssistantType")
        if params.get("SubnetSet") is not None:
            self._SubnetSet = []
            for item in params.get("SubnetSet"):
                obj = Subnet()
                obj._deserialize(item)
                self._SubnetSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssociateAddressRequest(AbstractModel):
    """AssociateAddress request structure.

    """

    def __init__(self):
        r"""
        :param _AddressId: The unique ID of the EIP, such as `eip-11112222`.
        :type AddressId: str
        :param _InstanceId: The ID of the instance to be bound, such as `ins-11112222`, `lb-11112222`. You can query the instance ID by logging into the [Console](https://console.cloud.tencent.com/cvm). You can also obtain the parameter value from the `InstanceId` field in the returned result of [DescribeInstances](https://intl.cloud.tencent.com/document/api/213/15728?from_cn_redirect=1) API.
        :type InstanceId: str
        :param _NetworkInterfaceId: The ID of the ENI to be bonud, such as `eni-11112222`. `NetworkInterfaceId` and `InstanceId` cannot be specified at the same time. You can query the ENI ID by logging into the [Console](https://console.cloud.tencent.com/vpc/eni). You can also obtain the parameter value from the `networkInterfaceId` field in the returned result of [DescribeNetworkInterfaces](https://intl.cloud.tencent.com/document/api/215/15817?from_cn_redirect=1) API.
        :type NetworkInterfaceId: str
        :param _PrivateIpAddress: The private IP to be bound. If you specify `NetworkInterfaceId`, then you must also specify `PrivateIpAddress`, indicating the EIP is bound to the specified private IP of the specified ENI. At the same time, you must ensure the specified `PrivateIpAddress` is a private IP on the `NetworkInterfaceId`. You can query the private IP of the specified ENI by logging into the [Console](https://console.cloud.tencent.com/vpc/eni). You can also obtain the parameter value from the `privateIpAddress` field in the returned result of [DescribeNetworkInterfaces](https://intl.cloud.tencent.com/document/api/215/15817?from_cn_redirect=1) API.
        :type PrivateIpAddress: str
        :param _EipDirectConnection: Specify whether to configure direct access when binding EIPs. For details, see [EIP Direct Access](https://intl.cloud.tencent.com/document/product/213/12540). Valid values: `True` and `False` (default). This parameter can be set to `True` when binding EIPs to a CVM instance or EKS cluster. It is in a beta test. To try it out, please [submit a ticket](https://console.cloud.tencent.com/workorder/category?level1_id=6&level2_id=163&source=0&data_title=%E8%B4%9F%E8%BD%BD%E5%9D%87%E8%A1%A1%20CLB&level3_id=1071&queue=96&scene_code=34639&step=2).
        :type EipDirectConnection: bool
        """
        self._AddressId = None
        self._InstanceId = None
        self._NetworkInterfaceId = None
        self._PrivateIpAddress = None
        self._EipDirectConnection = None

    @property
    def AddressId(self):
        return self._AddressId

    @AddressId.setter
    def AddressId(self, AddressId):
        self._AddressId = AddressId

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def NetworkInterfaceId(self):
        return self._NetworkInterfaceId

    @NetworkInterfaceId.setter
    def NetworkInterfaceId(self, NetworkInterfaceId):
        self._NetworkInterfaceId = NetworkInterfaceId

    @property
    def PrivateIpAddress(self):
        return self._PrivateIpAddress

    @PrivateIpAddress.setter
    def PrivateIpAddress(self, PrivateIpAddress):
        self._PrivateIpAddress = PrivateIpAddress

    @property
    def EipDirectConnection(self):
        return self._EipDirectConnection

    @EipDirectConnection.setter
    def EipDirectConnection(self, EipDirectConnection):
        self._EipDirectConnection = EipDirectConnection


    def _deserialize(self, params):
        self._AddressId = params.get("AddressId")
        self._InstanceId = params.get("InstanceId")
        self._NetworkInterfaceId = params.get("NetworkInterfaceId")
        self._PrivateIpAddress = params.get("PrivateIpAddress")
        self._EipDirectConnection = params.get("EipDirectConnection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssociateAddressResponse(AbstractModel):
    """AssociateAddress response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: The async task ID. You can use the [DescribeTaskResult](https://intl.cloud.tencent.com/document/api/215/36271?from_cn_redirect=1) API to query the task status.
        :type TaskId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class AssociateDirectConnectGatewayNatGatewayRequest(AbstractModel):
    """AssociateDirectConnectGatewayNatGateway request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC instance ID. VPC instance ID, which can be obtained from the `VpcId` field in the response of the `DescribeVpcs` API.
        :type VpcId: str
        :param _NatGatewayId: The NAT Gateway ID.
        :type NatGatewayId: str
        :param _DirectConnectGatewayId: The direct connect gateway ID.
        :type DirectConnectGatewayId: str
        """
        self._VpcId = None
        self._NatGatewayId = None
        self._DirectConnectGatewayId = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def NatGatewayId(self):
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def DirectConnectGatewayId(self):
        return self._DirectConnectGatewayId

    @DirectConnectGatewayId.setter
    def DirectConnectGatewayId(self, DirectConnectGatewayId):
        self._DirectConnectGatewayId = DirectConnectGatewayId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._NatGatewayId = params.get("NatGatewayId")
        self._DirectConnectGatewayId = params.get("DirectConnectGatewayId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssociateDirectConnectGatewayNatGatewayResponse(AbstractModel):
    """AssociateDirectConnectGatewayNatGateway response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AssociateNatGatewayAddressRequest(AbstractModel):
    """AssociateNatGatewayAddress request structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: The ID of the NAT gateway, such as `nat-df45454`.
        :type NatGatewayId: str
        :param _AddressCount: The number of EIPs you want to apply for. Either `AddressCount` or `PublicAddresses` must be passed in.
        :type AddressCount: int
        :param _PublicIpAddresses: Array of the EIPs bound to the NAT gateway. Either `AddressCount` or `PublicAddresses` must be passed in.
        :type PublicIpAddresses: list of str
        :param _Zone: The availability zone of the EIP, which is passed in when the EIP is automatically assigned.
        :type Zone: str
        :param _StockPublicIpAddressesBandwidthOut: The bandwidth size (in Mbps) of the EIP bound to the NAT gateway, which defaults to the maximum value applicable for the current user type.
        :type StockPublicIpAddressesBandwidthOut: int
        :param _PublicIpAddressesBandwidthOut: The size of the public network IP bandwidth to be applied for (in Mbps), which defaults to the maximum value applicable for the current user type.
        :type PublicIpAddressesBandwidthOut: int
        :param _PublicIpFromSameZone: Whether the public IP and the NAT gateway must be in the same availability zone. Valid values: `true` and `false`. This parameter is valid only when `Zone` is specified.
        :type PublicIpFromSameZone: bool
        """
        self._NatGatewayId = None
        self._AddressCount = None
        self._PublicIpAddresses = None
        self._Zone = None
        self._StockPublicIpAddressesBandwidthOut = None
        self._PublicIpAddressesBandwidthOut = None
        self._PublicIpFromSameZone = None

    @property
    def NatGatewayId(self):
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def AddressCount(self):
        return self._AddressCount

    @AddressCount.setter
    def AddressCount(self, AddressCount):
        self._AddressCount = AddressCount

    @property
    def PublicIpAddresses(self):
        return self._PublicIpAddresses

    @PublicIpAddresses.setter
    def PublicIpAddresses(self, PublicIpAddresses):
        self._PublicIpAddresses = PublicIpAddresses

    @property
    def Zone(self):
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def StockPublicIpAddressesBandwidthOut(self):
        return self._StockPublicIpAddressesBandwidthOut

    @StockPublicIpAddressesBandwidthOut.setter
    def StockPublicIpAddressesBandwidthOut(self, StockPublicIpAddressesBandwidthOut):
        self._StockPublicIpAddressesBandwidthOut = StockPublicIpAddressesBandwidthOut

    @property
    def PublicIpAddressesBandwidthOut(self):
        return self._PublicIpAddressesBandwidthOut

    @PublicIpAddressesBandwidthOut.setter
    def PublicIpAddressesBandwidthOut(self, PublicIpAddressesBandwidthOut):
        self._PublicIpAddressesBandwidthOut = PublicIpAddressesBandwidthOut

    @property
    def PublicIpFromSameZone(self):
        return self._PublicIpFromSameZone

    @PublicIpFromSameZone.setter
    def PublicIpFromSameZone(self, PublicIpFromSameZone):
        self._PublicIpFromSameZone = PublicIpFromSameZone


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        self._AddressCount = params.get("AddressCount")
        self._PublicIpAddresses = params.get("PublicIpAddresses")
        self._Zone = params.get("Zone")
        self._StockPublicIpAddressesBandwidthOut = params.get("StockPublicIpAddressesBandwidthOut")
        self._PublicIpAddressesBandwidthOut = params.get("PublicIpAddressesBandwidthOut")
        self._PublicIpFromSameZone = params.get("PublicIpFromSameZone")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssociateNatGatewayAddressResponse(AbstractModel):
    """AssociateNatGatewayAddress response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AssociateNetworkAclSubnetsRequest(AbstractModel):
    """AssociateNetworkAclSubnets request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkAclId: Network ACL instance ID, such as `acl-12345678`.
        :type NetworkAclId: str
        :param _SubnetIds: Array of subnet instance IDs, such as [subnet-12345678]
        :type SubnetIds: list of str
        """
        self._NetworkAclId = None
        self._SubnetIds = None

    @property
    def NetworkAclId(self):
        return self._NetworkAclId

    @NetworkAclId.setter
    def NetworkAclId(self, NetworkAclId):
        self._NetworkAclId = NetworkAclId

    @property
    def SubnetIds(self):
        return self._SubnetIds

    @SubnetIds.setter
    def SubnetIds(self, SubnetIds):
        self._SubnetIds = SubnetIds


    def _deserialize(self, params):
        self._NetworkAclId = params.get("NetworkAclId")
        self._SubnetIds = params.get("SubnetIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssociateNetworkAclSubnetsResponse(AbstractModel):
    """AssociateNetworkAclSubnets response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AssociateNetworkInterfaceSecurityGroupsRequest(AbstractModel):
    """AssociateNetworkInterfaceSecurityGroups request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkInterfaceIds: ENI instance ID, e.g. eni-pxir56ns. You can enter up to 100 instances for each request.
        :type NetworkInterfaceIds: list of str
        :param _SecurityGroupIds: The security group instance ID, such as `sg-33ocnj9n`. It can be obtained through DescribeSecurityGroups. You can enter up to 100 instances for each request.
        :type SecurityGroupIds: list of str
        """
        self._NetworkInterfaceIds = None
        self._SecurityGroupIds = None

    @property
    def NetworkInterfaceIds(self):
        return self._NetworkInterfaceIds

    @NetworkInterfaceIds.setter
    def NetworkInterfaceIds(self, NetworkInterfaceIds):
        self._NetworkInterfaceIds = NetworkInterfaceIds

    @property
    def SecurityGroupIds(self):
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds


    def _deserialize(self, params):
        self._NetworkInterfaceIds = params.get("NetworkInterfaceIds")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssociateNetworkInterfaceSecurityGroupsResponse(AbstractModel):
    """AssociateNetworkInterfaceSecurityGroups response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AttachCcnInstancesRequest(AbstractModel):
    """AttachCcnInstances request structure.

    """

    def __init__(self):
        r"""
        :param _CcnId: The CCN instance ID, such as `ccn-f49l6u0z`.
        :type CcnId: str
        :param _Instances: List of associated network instances
        :type Instances: list of CcnInstance
        :param _CcnUin: The UIN (root account) of the CCN. By default, the current account belongs to the UIN
        :type CcnUin: str
        """
        self._CcnId = None
        self._Instances = None
        self._CcnUin = None

    @property
    def CcnId(self):
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def Instances(self):
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def CcnUin(self):
        return self._CcnUin

    @CcnUin.setter
    def CcnUin(self, CcnUin):
        self._CcnUin = CcnUin


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = CcnInstance()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._CcnUin = params.get("CcnUin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttachCcnInstancesResponse(AbstractModel):
    """AttachCcnInstances response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AttachClassicLinkVpcRequest(AbstractModel):
    """AttachClassicLinkVpc request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC instance ID
        :type VpcId: str
        :param _InstanceIds: CVM Instance ID
        :type InstanceIds: list of str
        """
        self._VpcId = None
        self._InstanceIds = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def InstanceIds(self):
        return self._InstanceIds

    @InstanceIds.setter
    def InstanceIds(self, InstanceIds):
        self._InstanceIds = InstanceIds


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._InstanceIds = params.get("InstanceIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttachClassicLinkVpcResponse(AbstractModel):
    """AttachClassicLinkVpc response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AttachNetworkInterfaceRequest(AbstractModel):
    """AttachNetworkInterface request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkInterfaceId: The ID of the ENI instance, such as `eni-m6dyj72l`.
        :type NetworkInterfaceId: str
        :param _InstanceId: The ID of the CVM instance, such as `ins-r8hr2upy`.
        :type InstanceId: str
        :param _AttachType: ENI mounting type. Valid values: `0` (standard); `1` (extension); default value: `0`
        :type AttachType: int
        """
        self._NetworkInterfaceId = None
        self._InstanceId = None
        self._AttachType = None

    @property
    def NetworkInterfaceId(self):
        return self._NetworkInterfaceId

    @NetworkInterfaceId.setter
    def NetworkInterfaceId(self, NetworkInterfaceId):
        self._NetworkInterfaceId = NetworkInterfaceId

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def AttachType(self):
        return self._AttachType

    @AttachType.setter
    def AttachType(self, AttachType):
        self._AttachType = AttachType


    def _deserialize(self, params):
        self._NetworkInterfaceId = params.get("NetworkInterfaceId")
        self._InstanceId = params.get("InstanceId")
        self._AttachType = params.get("AttachType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttachNetworkInterfaceResponse(AbstractModel):
    """AttachNetworkInterface response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AttachSnapshotInstancesRequest(AbstractModel):
    """AttachSnapshotInstances request structure.

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicyId: Snapshot policy IDs
        :type SnapshotPolicyId: str
        :param _Instances: Information of associated instances
        :type Instances: list of SnapshotInstance
        """
        self._SnapshotPolicyId = None
        self._Instances = None

    @property
    def SnapshotPolicyId(self):
        return self._SnapshotPolicyId

    @SnapshotPolicyId.setter
    def SnapshotPolicyId(self, SnapshotPolicyId):
        self._SnapshotPolicyId = SnapshotPolicyId

    @property
    def Instances(self):
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances


    def _deserialize(self, params):
        self._SnapshotPolicyId = params.get("SnapshotPolicyId")
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = SnapshotInstance()
                obj._deserialize(item)
                self._Instances.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttachSnapshotInstancesResponse(AbstractModel):
    """AttachSnapshotInstances response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AuditCrossBorderComplianceRequest(AbstractModel):
    """AuditCrossBorderCompliance request structure.

    """

    def __init__(self):
        r"""
        :param _ServiceProvider: Service provider. Valid values: `UNICOM`.
        :type ServiceProvider: str
        :param _ComplianceId: Unique ID of compliance review request.
        :type ComplianceId: int
        :param _AuditBehavior: Audit behavior. Valid values: `APPROVED` and `DENY`.
        :type AuditBehavior: str
        """
        self._ServiceProvider = None
        self._ComplianceId = None
        self._AuditBehavior = None

    @property
    def ServiceProvider(self):
        return self._ServiceProvider

    @ServiceProvider.setter
    def ServiceProvider(self, ServiceProvider):
        self._ServiceProvider = ServiceProvider

    @property
    def ComplianceId(self):
        return self._ComplianceId

    @ComplianceId.setter
    def ComplianceId(self, ComplianceId):
        self._ComplianceId = ComplianceId

    @property
    def AuditBehavior(self):
        return self._AuditBehavior

    @AuditBehavior.setter
    def AuditBehavior(self, AuditBehavior):
        self._AuditBehavior = AuditBehavior


    def _deserialize(self, params):
        self._ServiceProvider = params.get("ServiceProvider")
        self._ComplianceId = params.get("ComplianceId")
        self._AuditBehavior = params.get("AuditBehavior")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AuditCrossBorderComplianceResponse(AbstractModel):
    """AuditCrossBorderCompliance response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class BackupPolicy(AbstractModel):
    """Details of scheduled snapshot policy

    """

    def __init__(self):
        r"""
        :param _BackupDay: Scheduled backup day. Values: `monday`, `tuesday`, `wednesday`, `thursday`, `friday`, `saturday`, `sunday`.
        :type BackupDay: str
        :param _BackupTime: Backup point in time. Format: HH:mm:ss.
        :type BackupTime: str
        """
        self._BackupDay = None
        self._BackupTime = None

    @property
    def BackupDay(self):
        return self._BackupDay

    @BackupDay.setter
    def BackupDay(self, BackupDay):
        self._BackupDay = BackupDay

    @property
    def BackupTime(self):
        return self._BackupTime

    @BackupTime.setter
    def BackupTime(self, BackupTime):
        self._BackupTime = BackupTime


    def _deserialize(self, params):
        self._BackupDay = params.get("BackupDay")
        self._BackupTime = params.get("BackupTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BandwidthPackage(AbstractModel):
    """The structure of information of the bandwidth package.

    """

    def __init__(self):
        r"""
        :param _BandwidthPackageId: The unique ID of the bandwidth package.
        :type BandwidthPackageId: str
        :param _NetworkType: Bandwidth package type. Values: `BGP`, `SINGLEISP`, `ANYCAST`, `SINGLEISP_CMCC`, `SINGLEISP_CTCC`, `SINGLEISP_CUCC`
        :type NetworkType: str
        :param _ChargeType: The bandwidth package billing mode. Valid values: 'TOP5_POSTPAID_BY_MONTH' and 'PERCENT95_POSTPAID_BY_MONTH'
        :type ChargeType: str
        :param _BandwidthPackageName: The name of the bandwidth package.
        :type BandwidthPackageName: str
        :param _CreatedTime: The creation time of the bandwidth package, which follows the `ISO8601` standard and uses `UTC` time in the format of `YYYY-MM-DDThh:mm:ssZ`.
        :type CreatedTime: str
        :param _Status: The status of the bandwidth package. Valid values: 'CREATING', 'CREATED', 'DELETING', and 'DELETED'.
        :type Status: str
        :param _ResourceSet: The resource information of the bandwidth package.
        :type ResourceSet: list of Resource
        :param _Bandwidth: The limit of the bandwidth package in Mbps. The value '-1' indicates there is no limit.
        :type Bandwidth: int
        """
        self._BandwidthPackageId = None
        self._NetworkType = None
        self._ChargeType = None
        self._BandwidthPackageName = None
        self._CreatedTime = None
        self._Status = None
        self._ResourceSet = None
        self._Bandwidth = None

    @property
    def BandwidthPackageId(self):
        return self._BandwidthPackageId

    @BandwidthPackageId.setter
    def BandwidthPackageId(self, BandwidthPackageId):
        self._BandwidthPackageId = BandwidthPackageId

    @property
    def NetworkType(self):
        return self._NetworkType

    @NetworkType.setter
    def NetworkType(self, NetworkType):
        self._NetworkType = NetworkType

    @property
    def ChargeType(self):
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def BandwidthPackageName(self):
        return self._BandwidthPackageName

    @BandwidthPackageName.setter
    def BandwidthPackageName(self, BandwidthPackageName):
        self._BandwidthPackageName = BandwidthPackageName

    @property
    def CreatedTime(self):
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ResourceSet(self):
        return self._ResourceSet

    @ResourceSet.setter
    def ResourceSet(self, ResourceSet):
        self._ResourceSet = ResourceSet

    @property
    def Bandwidth(self):
        return self._Bandwidth

    @Bandwidth.setter
    def Bandwidth(self, Bandwidth):
        self._Bandwidth = Bandwidth


    def _deserialize(self, params):
        self._BandwidthPackageId = params.get("BandwidthPackageId")
        self._NetworkType = params.get("NetworkType")
        self._ChargeType = params.get("ChargeType")
        self._BandwidthPackageName = params.get("BandwidthPackageName")
        self._CreatedTime = params.get("CreatedTime")
        self._Status = params.get("Status")
        if params.get("ResourceSet") is not None:
            self._ResourceSet = []
            for item in params.get("ResourceSet"):
                obj = Resource()
                obj._deserialize(item)
                self._ResourceSet.append(obj)
        self._Bandwidth = params.get("Bandwidth")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BandwidthPackageBillBandwidth(AbstractModel):
    """Current billable usage of a pay-as-you-go bandwidth package

    """

    def __init__(self):
        r"""
        :param _BandwidthUsage: Current billable usage, in Mbps
        :type BandwidthUsage: int
        """
        self._BandwidthUsage = None

    @property
    def BandwidthUsage(self):
        return self._BandwidthUsage

    @BandwidthUsage.setter
    def BandwidthUsage(self, BandwidthUsage):
        self._BandwidthUsage = BandwidthUsage


    def _deserialize(self, params):
        self._BandwidthUsage = params.get("BandwidthUsage")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchModifySnapshotPolicy(AbstractModel):
    """Modify attributes of a scheduled snapshot policy

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicyId: Snapshot policy IDs
        :type SnapshotPolicyId: str
        :param _SnapshotPolicyName: Snapshot policy name
        :type SnapshotPolicyName: str
        :param _BackupPolicies: Backup policy
        :type BackupPolicies: list of BackupPolicy
        :param _KeepTime: Snapshot retention period. Range: 1 to 365 days
        :type KeepTime: int
        """
        self._SnapshotPolicyId = None
        self._SnapshotPolicyName = None
        self._BackupPolicies = None
        self._KeepTime = None

    @property
    def SnapshotPolicyId(self):
        return self._SnapshotPolicyId

    @SnapshotPolicyId.setter
    def SnapshotPolicyId(self, SnapshotPolicyId):
        self._SnapshotPolicyId = SnapshotPolicyId

    @property
    def SnapshotPolicyName(self):
        return self._SnapshotPolicyName

    @SnapshotPolicyName.setter
    def SnapshotPolicyName(self, SnapshotPolicyName):
        self._SnapshotPolicyName = SnapshotPolicyName

    @property
    def BackupPolicies(self):
        return self._BackupPolicies

    @BackupPolicies.setter
    def BackupPolicies(self, BackupPolicies):
        self._BackupPolicies = BackupPolicies

    @property
    def KeepTime(self):
        return self._KeepTime

    @KeepTime.setter
    def KeepTime(self, KeepTime):
        self._KeepTime = KeepTime


    def _deserialize(self, params):
        self._SnapshotPolicyId = params.get("SnapshotPolicyId")
        self._SnapshotPolicyName = params.get("SnapshotPolicyName")
        if params.get("BackupPolicies") is not None:
            self._BackupPolicies = []
            for item in params.get("BackupPolicies"):
                obj = BackupPolicy()
                obj._deserialize(item)
                self._BackupPolicies.append(obj)
        self._KeepTime = params.get("KeepTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CCN(AbstractModel):
    """The CCN object

    """

    def __init__(self):
        r"""
        :param _CcnId: The unique ID of the CCN
        :type CcnId: str
        :param _CcnName: The name of the CCN
        :type CcnName: str
        :param _CcnDescription: The detailed information of the CCN
        :type CcnDescription: str
        :param _InstanceCount: The number of associated instances
        :type InstanceCount: int
        :param _CreateTime: The creation time
        :type CreateTime: str
        :param _State: The instance status. 'ISOLATED': Being isolated (instance is in arrears and service is suspended). 'AVAILABLE': Operating.
        :type State: str
        :param _QosLevel: The instance service quality. ’PT’: Platinum , 'AU': Gold, 'AG': Silver.
        :type QosLevel: str
        :param _InstanceChargeType: The billing method. POSTPAID indicates postpaid.
Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceChargeType: str
        :param _BandwidthLimitType: The limit type. INTER_REGION_LIMIT is the limit between regions. OUTER_REGION_LIMIT is a region egress limit.
Note: This field may return null, indicating no valid value.
        :type BandwidthLimitType: str
        :param _TagSet: Tag key-value pairs.
        :type TagSet: list of Tag
        :param _RoutePriorityFlag: Whether the CCN route priority feature is supported. Valid values: False: do not support; True: support.
        :type RoutePriorityFlag: bool
        :param _RouteTableCount: Number of route tables associated with the instance.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type RouteTableCount: int
        :param _RouteTableFlag: Whether the multiple route tables feature is enabled for the CCN instance. Valid values: `False`: no; `True`: yes. Default value: `False`.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type RouteTableFlag: bool
        :param _IsSecurityLock: 
        :type IsSecurityLock: bool
        :param _RouteBroadcastPolicyFlag: Status of CCN route broadcasting policy. Values: `False` (Disabled), `True` (Enabled)
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type RouteBroadcastPolicyFlag: bool
        """
        self._CcnId = None
        self._CcnName = None
        self._CcnDescription = None
        self._InstanceCount = None
        self._CreateTime = None
        self._State = None
        self._QosLevel = None
        self._InstanceChargeType = None
        self._BandwidthLimitType = None
        self._TagSet = None
        self._RoutePriorityFlag = None
        self._RouteTableCount = None
        self._RouteTableFlag = None
        self._IsSecurityLock = None
        self._RouteBroadcastPolicyFlag = None

    @property
    def CcnId(self):
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def CcnName(self):
        return self._CcnName

    @CcnName.setter
    def CcnName(self, CcnName):
        self._CcnName = CcnName

    @property
    def CcnDescription(self):
        return self._CcnDescription

    @CcnDescription.setter
    def CcnDescription(self, CcnDescription):
        self._CcnDescription = CcnDescription

    @property
    def InstanceCount(self):
        return self._InstanceCount

    @InstanceCount.setter
    def InstanceCount(self, InstanceCount):
        self._InstanceCount = InstanceCount

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def State(self):
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def QosLevel(self):
        return self._QosLevel

    @QosLevel.setter
    def QosLevel(self, QosLevel):
        self._QosLevel = QosLevel

    @property
    def InstanceChargeType(self):
        return self._InstanceChargeType

    @InstanceChargeType.setter
    def InstanceChargeType(self, InstanceChargeType):
        self._InstanceChargeType = InstanceChargeType

    @property
    def BandwidthLimitType(self):
        return self._BandwidthLimitType

    @BandwidthLimitType.setter
    def BandwidthLimitType(self, BandwidthLimitType):
        self._BandwidthLimitType = BandwidthLimitType

    @property
    def TagSet(self):
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet

    @property
    def RoutePriorityFlag(self):
        return self._RoutePriorityFlag

    @RoutePriorityFlag.setter
    def RoutePriorityFlag(self, RoutePriorityFlag):
        self._RoutePriorityFlag = RoutePriorityFlag

    @property
    def RouteTableCount(self):
        return self._RouteTableCount

    @RouteTableCount.setter
    def RouteTableCount(self, RouteTableCount):
        self._RouteTableCount = RouteTableCount

    @property
    def RouteTableFlag(self):
        return self._RouteTableFlag

    @RouteTableFlag.setter
    def RouteTableFlag(self, RouteTableFlag):
        self._RouteTableFlag = RouteTableFlag

    @property
    def IsSecurityLock(self):
        return self._IsSecurityLock

    @IsSecurityLock.setter
    def IsSecurityLock(self, IsSecurityLock):
        self._IsSecurityLock = IsSecurityLock

    @property
    def RouteBroadcastPolicyFlag(self):
        return self._RouteBroadcastPolicyFlag

    @RouteBroadcastPolicyFlag.setter
    def RouteBroadcastPolicyFlag(self, RouteBroadcastPolicyFlag):
        self._RouteBroadcastPolicyFlag = RouteBroadcastPolicyFlag


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        self._CcnName = params.get("CcnName")
        self._CcnDescription = params.get("CcnDescription")
        self._InstanceCount = params.get("InstanceCount")
        self._CreateTime = params.get("CreateTime")
        self._State = params.get("State")
        self._QosLevel = params.get("QosLevel")
        self._InstanceChargeType = params.get("InstanceChargeType")
        self._BandwidthLimitType = params.get("BandwidthLimitType")
        if params.get("TagSet") is not None:
            self._TagSet = []
            for item in params.get("TagSet"):
                obj = Tag()
                obj._deserialize(item)
                self._TagSet.append(obj)
        self._RoutePriorityFlag = params.get("RoutePriorityFlag")
        self._RouteTableCount = params.get("RouteTableCount")
        self._RouteTableFlag = params.get("RouteTableFlag")
        self._IsSecurityLock = params.get("IsSecurityLock")
        self._RouteBroadcastPolicyFlag = params.get("RouteBroadcastPolicyFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CcnAttachedInstance(AbstractModel):
    """The instance object associated with a CCN

    """

    def __init__(self):
        r"""
        :param _CcnId: The ID of a CCN instance.
        :type CcnId: str
        :param _InstanceType: The type of associated instances:
<li>`VPC`: VPC</li>
<li>`DIRECTCONNECT`: Direct Connect</li>
<li>`BMVPC`: BM VPC</li>
        :type InstanceType: str
        :param _InstanceId: The ID of the associated instance.
        :type InstanceId: str
        :param _InstanceName: The name of the associated instance.
        :type InstanceName: str
        :param _InstanceRegion: The region to which the associated instance belongs, such as `ap-guangzhou`.
        :type InstanceRegion: str
        :param _InstanceUin: The UIN (root account) to which the associated instance belongs.
        :type InstanceUin: str
        :param _CidrBlock: The CIDR of the associated instance.
        :type CidrBlock: list of str
        :param _State: The status of the associated instance:
<li>`PENDING`: In application</li>
<li>`ACTIVE`: Connected</li>
<li>`EXPIRED`: Expired</li>
<li>`REJECTED`: Rejected</li>
<li>`DELETED`: Deleted</li>
<li>`FAILED`: Failed (it will be asynchronously unbound after 2 hours)</li>
<li>`ATTACHING`: binding</li>
<li>`DETACHING`: Unbinding</li>
<li>`DETACHFAILED`: The unbinding failed (it will be asynchronously unbound after 2 hours)</li>
        :type State: str
        :param _AttachedTime: Association Time.
        :type AttachedTime: str
        :param _CcnUin: The UIN (root account) to which the CCN belongs.
        :type CcnUin: str
        :param _InstanceArea: General location of the associated instance, such as CHINA_MAINLAND.
        :type InstanceArea: str
        :param _Description: Description
        :type Description: str
        :param _RouteTableId: Route table ID
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type RouteTableId: str
        :param _RouteTableName: Route table name
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type RouteTableName: str
        """
        self._CcnId = None
        self._InstanceType = None
        self._InstanceId = None
        self._InstanceName = None
        self._InstanceRegion = None
        self._InstanceUin = None
        self._CidrBlock = None
        self._State = None
        self._AttachedTime = None
        self._CcnUin = None
        self._InstanceArea = None
        self._Description = None
        self._RouteTableId = None
        self._RouteTableName = None

    @property
    def CcnId(self):
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def InstanceType(self):
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def InstanceRegion(self):
        return self._InstanceRegion

    @InstanceRegion.setter
    def InstanceRegion(self, InstanceRegion):
        self._InstanceRegion = InstanceRegion

    @property
    def InstanceUin(self):
        return self._InstanceUin

    @InstanceUin.setter
    def InstanceUin(self, InstanceUin):
        self._InstanceUin = InstanceUin

    @property
    def CidrBlock(self):
        return self._CidrBlock

    @CidrBlock.setter
    def CidrBlock(self, CidrBlock):
        self._CidrBlock = CidrBlock

    @property
    def State(self):
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def AttachedTime(self):
        return self._AttachedTime

    @AttachedTime.setter
    def AttachedTime(self, AttachedTime):
        self._AttachedTime = AttachedTime

    @property
    def CcnUin(self):
        return self._CcnUin

    @CcnUin.setter
    def CcnUin(self, CcnUin):
        self._CcnUin = CcnUin

    @property
    def InstanceArea(self):
        return self._InstanceArea

    @InstanceArea.setter
    def InstanceArea(self, InstanceArea):
        self._InstanceArea = InstanceArea

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def RouteTableId(self):
        return self._RouteTableId

    @RouteTableId.setter
    def RouteTableId(self, RouteTableId):
        self._RouteTableId = RouteTableId

    @property
    def RouteTableName(self):
        return self._RouteTableName

    @RouteTableName.setter
    def RouteTableName(self, RouteTableName):
        self._RouteTableName = RouteTableName


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        self._InstanceType = params.get("InstanceType")
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._InstanceRegion = params.get("InstanceRegion")
        self._InstanceUin = params.get("InstanceUin")
        self._CidrBlock = params.get("CidrBlock")
        self._State = params.get("State")
        self._AttachedTime = params.get("AttachedTime")
        self._CcnUin = params.get("CcnUin")
        self._InstanceArea = params.get("InstanceArea")
        self._Description = params.get("Description")
        self._RouteTableId = params.get("RouteTableId")
        self._RouteTableName = params.get("RouteTableName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CcnBandwidthInfo(AbstractModel):
    """The information of the cross-region bandwidth limit for CCN instances.

    """

    def __init__(self):
        r"""
        :param _CcnId: The CCN ID that the bandwidth belongs to.
Note: this field may return null, indicating that no valid value was found.
        :type CcnId: str
        :param _CreatedTime: The creation time of the instance.
Note: this field may return null, indicating that no valid value was found.
        :type CreatedTime: str
        :param _ExpiredTime: The expiration time of the instance.
Note: this field may return null, indicating that no valid value was found.
        :type ExpiredTime: str
        :param _RegionFlowControlId: The unique ID of the bandwidth instance.
Note: this field may return null, indicating that no valid value was found.
        :type RegionFlowControlId: str
        :param _RenewFlag: The billing flag.
Note: this field may return null, indicating that no valid value was found.
        :type RenewFlag: str
        :param _CcnRegionBandwidthLimit: The information of the bandwidth regions and bandwidth caps. The parameter is only returned for the cross-region limit mode, but not for egress limit.
Note: this field may return null, indicating that no valid value was found.
        :type CcnRegionBandwidthLimit: :class:`tencentcloud.vpc.v20170312.models.CcnRegionBandwidthLimit`
        :param _MarketId: Cloud marketplace instance ID.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type MarketId: str
        :param _TagSet: The list of tags to be bound.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type TagSet: list of Tag
        """
        self._CcnId = None
        self._CreatedTime = None
        self._ExpiredTime = None
        self._RegionFlowControlId = None
        self._RenewFlag = None
        self._CcnRegionBandwidthLimit = None
        self._MarketId = None
        self._TagSet = None

    @property
    def CcnId(self):
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def CreatedTime(self):
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def ExpiredTime(self):
        return self._ExpiredTime

    @ExpiredTime.setter
    def ExpiredTime(self, ExpiredTime):
        self._ExpiredTime = ExpiredTime

    @property
    def RegionFlowControlId(self):
        return self._RegionFlowControlId

    @RegionFlowControlId.setter
    def RegionFlowControlId(self, RegionFlowControlId):
        self._RegionFlowControlId = RegionFlowControlId

    @property
    def RenewFlag(self):
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def CcnRegionBandwidthLimit(self):
        return self._CcnRegionBandwidthLimit

    @CcnRegionBandwidthLimit.setter
    def CcnRegionBandwidthLimit(self, CcnRegionBandwidthLimit):
        self._CcnRegionBandwidthLimit = CcnRegionBandwidthLimit

    @property
    def MarketId(self):
        return self._MarketId

    @MarketId.setter
    def MarketId(self, MarketId):
        self._MarketId = MarketId

    @property
    def TagSet(self):
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        self._CreatedTime = params.get("CreatedTime")
        self._ExpiredTime = params.get("ExpiredTime")
        self._RegionFlowControlId = params.get("RegionFlowControlId")
        self._RenewFlag = params.get("RenewFlag")
        if params.get("CcnRegionBandwidthLimit") is not None:
            self._CcnRegionBandwidthLimit = CcnRegionBandwidthLimit()
            self._CcnRegionBandwidthLimit._deserialize(params.get("CcnRegionBandwidthLimit"))
        self._MarketId = params.get("MarketId")
        if params.get("TagSet") is not None:
            self._TagSet = []
            for item in params.get("TagSet"):
                obj = Tag()
                obj._deserialize(item)
                self._TagSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CcnInstance(AbstractModel):
    """The instance object associated with a CCN.

    """

    def __init__(self):
        r"""
        :param _InstanceId: The ID of the associated instance.
        :type InstanceId: str
        :param _InstanceRegion: The region to which the associated instance ID belongs, such as `ap-guangzhou`.
        :type InstanceRegion: str
        :param _InstanceType: The type of the associated instance. Available values are:
<li>`VPC`: VPC</li>
<li>`DIRECTCONNECT`: Direct Connect</li>
<li>`BMVPC`: BM VPC</li>
        :type InstanceType: str
        :param _Description: Description
        :type Description: str
        :param _RouteTableId: The ID of the route table associated with the instance
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type RouteTableId: str
        """
        self._InstanceId = None
        self._InstanceRegion = None
        self._InstanceType = None
        self._Description = None
        self._RouteTableId = None

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceRegion(self):
        return self._InstanceRegion

    @InstanceRegion.setter
    def InstanceRegion(self, InstanceRegion):
        self._InstanceRegion = InstanceRegion

    @property
    def InstanceType(self):
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def RouteTableId(self):
        return self._RouteTableId

    @RouteTableId.setter
    def RouteTableId(self, RouteTableId):
        self._RouteTableId = RouteTableId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._InstanceRegion = params.get("InstanceRegion")
        self._InstanceType = params.get("InstanceType")
        self._Description = params.get("Description")
        self._RouteTableId = params.get("RouteTableId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CcnRegionBandwidthLimit(AbstractModel):
    """The outbound bandwidth cap of the CCN region

    """

    def __init__(self):
        r"""
        :param _Region: Region, such as `ap-guangzhou`
        :type Region: str
        :param _BandwidthLimit: The outbound bandwidth cap. Units: Mbps
        :type BandwidthLimit: int
        :param _IsBm: Whether it is a BM region. The default is `false`.
        :type IsBm: bool
        :param _DstRegion: The target region, such as `ap-shanghai`
Note: This field may return null, indicating no valid value.
        :type DstRegion: str
        :param _DstIsBm: Whether the target region is a BM region. The default is `false`.
        :type DstIsBm: bool
        """
        self._Region = None
        self._BandwidthLimit = None
        self._IsBm = None
        self._DstRegion = None
        self._DstIsBm = None

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def BandwidthLimit(self):
        return self._BandwidthLimit

    @BandwidthLimit.setter
    def BandwidthLimit(self, BandwidthLimit):
        self._BandwidthLimit = BandwidthLimit

    @property
    def IsBm(self):
        return self._IsBm

    @IsBm.setter
    def IsBm(self, IsBm):
        self._IsBm = IsBm

    @property
    def DstRegion(self):
        return self._DstRegion

    @DstRegion.setter
    def DstRegion(self, DstRegion):
        self._DstRegion = DstRegion

    @property
    def DstIsBm(self):
        return self._DstIsBm

    @DstIsBm.setter
    def DstIsBm(self, DstIsBm):
        self._DstIsBm = DstIsBm


    def _deserialize(self, params):
        self._Region = params.get("Region")
        self._BandwidthLimit = params.get("BandwidthLimit")
        self._IsBm = params.get("IsBm")
        self._DstRegion = params.get("DstRegion")
        self._DstIsBm = params.get("DstIsBm")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CcnRoute(AbstractModel):
    """The CCN routing policy object

    """

    def __init__(self):
        r"""
        :param _RouteId: The ID of the routing policy
        :type RouteId: str
        :param _DestinationCidrBlock: Destination
        :type DestinationCidrBlock: str
        :param _InstanceType: The type of the next hop (associated instance type). Available types: VPC, DIRECTCONNECT
        :type InstanceType: str
        :param _InstanceId: The next hop (associated instance)
        :type InstanceId: str
        :param _InstanceName: The name of the next hop (associated instance name)
        :type InstanceName: str
        :param _InstanceRegion: The region of the next hop (the region of the associated instance)
        :type InstanceRegion: str
        :param _UpdateTime: Update Time
        :type UpdateTime: str
        :param _Enabled: Whether the route is enabled
        :type Enabled: bool
        :param _InstanceUin: The UIN (root account) to which the associated instance belongs
        :type InstanceUin: str
        :param _ExtraState: Additional status of the route
        :type ExtraState: str
        :param _IsBgp: Whether it is a dynamic route
        :type IsBgp: bool
        :param _RoutePriority: Route priority
        :type RoutePriority: int
        :param _InstanceExtraName: Next hop port name (associated instance’s port name)
        :type InstanceExtraName: str
        """
        self._RouteId = None
        self._DestinationCidrBlock = None
        self._InstanceType = None
        self._InstanceId = None
        self._InstanceName = None
        self._InstanceRegion = None
        self._UpdateTime = None
        self._Enabled = None
        self._InstanceUin = None
        self._ExtraState = None
        self._IsBgp = None
        self._RoutePriority = None
        self._InstanceExtraName = None

    @property
    def RouteId(self):
        return self._RouteId

    @RouteId.setter
    def RouteId(self, RouteId):
        self._RouteId = RouteId

    @property
    def DestinationCidrBlock(self):
        return self._DestinationCidrBlock

    @DestinationCidrBlock.setter
    def DestinationCidrBlock(self, DestinationCidrBlock):
        self._DestinationCidrBlock = DestinationCidrBlock

    @property
    def InstanceType(self):
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def InstanceRegion(self):
        return self._InstanceRegion

    @InstanceRegion.setter
    def InstanceRegion(self, InstanceRegion):
        self._InstanceRegion = InstanceRegion

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Enabled(self):
        return self._Enabled

    @Enabled.setter
    def Enabled(self, Enabled):
        self._Enabled = Enabled

    @property
    def InstanceUin(self):
        return self._InstanceUin

    @InstanceUin.setter
    def InstanceUin(self, InstanceUin):
        self._InstanceUin = InstanceUin

    @property
    def ExtraState(self):
        return self._ExtraState

    @ExtraState.setter
    def ExtraState(self, ExtraState):
        self._ExtraState = ExtraState

    @property
    def IsBgp(self):
        return self._IsBgp

    @IsBgp.setter
    def IsBgp(self, IsBgp):
        self._IsBgp = IsBgp

    @property
    def RoutePriority(self):
        return self._RoutePriority

    @RoutePriority.setter
    def RoutePriority(self, RoutePriority):
        self._RoutePriority = RoutePriority

    @property
    def InstanceExtraName(self):
        return self._InstanceExtraName

    @InstanceExtraName.setter
    def InstanceExtraName(self, InstanceExtraName):
        self._InstanceExtraName = InstanceExtraName


    def _deserialize(self, params):
        self._RouteId = params.get("RouteId")
        self._DestinationCidrBlock = params.get("DestinationCidrBlock")
        self._InstanceType = params.get("InstanceType")
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._InstanceRegion = params.get("InstanceRegion")
        self._UpdateTime = params.get("UpdateTime")
        self._Enabled = params.get("Enabled")
        self._InstanceUin = params.get("InstanceUin")
        self._ExtraState = params.get("ExtraState")
        self._IsBgp = params.get("IsBgp")
        self._RoutePriority = params.get("RoutePriority")
        self._InstanceExtraName = params.get("InstanceExtraName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckAssistantCidrRequest(AbstractModel):
    """CheckAssistantCidr request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: `VPC` instance `ID`, e.g. `vpc-6v2ht8q5`.
        :type VpcId: str
        :param _NewCidrBlocks: Load CIDR blocks to add. CIDR block set; format: e.g. ["10.0.0.0/16", "172.16.0.0/16"]
        :type NewCidrBlocks: list of str
        :param _OldCidrBlocks: Load CIDR blocks to delete. CIDR block set; Format: e.g. ["10.0.0.0/16", "172.16.0.0/16"]
        :type OldCidrBlocks: list of str
        """
        self._VpcId = None
        self._NewCidrBlocks = None
        self._OldCidrBlocks = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def NewCidrBlocks(self):
        return self._NewCidrBlocks

    @NewCidrBlocks.setter
    def NewCidrBlocks(self, NewCidrBlocks):
        self._NewCidrBlocks = NewCidrBlocks

    @property
    def OldCidrBlocks(self):
        return self._OldCidrBlocks

    @OldCidrBlocks.setter
    def OldCidrBlocks(self, OldCidrBlocks):
        self._OldCidrBlocks = OldCidrBlocks


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._NewCidrBlocks = params.get("NewCidrBlocks")
        self._OldCidrBlocks = params.get("OldCidrBlocks")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckAssistantCidrResponse(AbstractModel):
    """CheckAssistantCidr response structure.

    """

    def __init__(self):
        r"""
        :param _ConflictSourceSet: Array of conflict resources.
        :type ConflictSourceSet: list of ConflictSource
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ConflictSourceSet = None
        self._RequestId = None

    @property
    def ConflictSourceSet(self):
        return self._ConflictSourceSet

    @ConflictSourceSet.setter
    def ConflictSourceSet(self, ConflictSourceSet):
        self._ConflictSourceSet = ConflictSourceSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ConflictSourceSet") is not None:
            self._ConflictSourceSet = []
            for item in params.get("ConflictSourceSet"):
                obj = ConflictSource()
                obj._deserialize(item)
                self._ConflictSourceSet.append(obj)
        self._RequestId = params.get("RequestId")


class CheckNetDetectStateRequest(AbstractModel):
    """CheckNetDetectState request structure.

    """

    def __init__(self):
        r"""
        :param _DetectDestinationIp: The array of detection destination IPv4 addresses, which contains at most two IP addresses.
        :type DetectDestinationIp: list of str
        :param _NextHopType: The type of the next hop. Currently supported types are:
VPN: VPN gateway;
DIRECTCONNECT: direct connect gateway;
PEERCONNECTION: peering connection;
NAT: NAT gateway;
NORMAL_CVM: normal CVM.
        :type NextHopType: str
        :param _NextHopDestination: The next-hop destination gateway. The value is related to NextHopType.
If NextHopType is set to VPN, the value of this parameter is the VPN gateway ID, such as vpngw-12345678.
If NextHopType is set to DIRECTCONNECT, the value of this parameter is the direct connect gateway ID, such as dcg-12345678.
If NextHopType is set to PEERCONNECTION, the value of this parameter is the peering connection ID, such as pcx-12345678.
If NextHopType is set to NAT, the value of this parameter is the NAT gateway ID, such as nat-12345678.
If NextHopType is set to NORMAL_CVM, the value of this parameter is the IPv4 address of the CVM, such as 10.0.0.12.
        :type NextHopDestination: str
        :param _NetDetectId: ID of a network inspector instance, e.g. netd-12345678. Enter at least one of this parameter, VpcId, SubnetId, and NetDetectName. Use NetDetectId if it is present.
        :type NetDetectId: str
        :param _VpcId: ID of a `VPC` instance, e.g. `vpc-12345678`, which is used together with SubnetId and NetDetectName. You should enter either this parameter or NetDetectId, or both. Use NetDetectId if it is present.
        :type VpcId: str
        :param _SubnetId: ID of a subnet instance, e.g. `subnet-12345678`, which is used together with VpcId and NetDetectName. You should enter either this parameter or NetDetectId, or both. Use NetDetectId if it is present.
        :type SubnetId: str
        :param _NetDetectName: The name of a network inspector, up to 60 bytes in length. It is used together with VpcId and NetDetectName. You should enter either this parameter or NetDetectId, or both. Use NetDetectId if it is present.
        :type NetDetectName: str
        """
        self._DetectDestinationIp = None
        self._NextHopType = None
        self._NextHopDestination = None
        self._NetDetectId = None
        self._VpcId = None
        self._SubnetId = None
        self._NetDetectName = None

    @property
    def DetectDestinationIp(self):
        return self._DetectDestinationIp

    @DetectDestinationIp.setter
    def DetectDestinationIp(self, DetectDestinationIp):
        self._DetectDestinationIp = DetectDestinationIp

    @property
    def NextHopType(self):
        return self._NextHopType

    @NextHopType.setter
    def NextHopType(self, NextHopType):
        self._NextHopType = NextHopType

    @property
    def NextHopDestination(self):
        return self._NextHopDestination

    @NextHopDestination.setter
    def NextHopDestination(self, NextHopDestination):
        self._NextHopDestination = NextHopDestination

    @property
    def NetDetectId(self):
        return self._NetDetectId

    @NetDetectId.setter
    def NetDetectId(self, NetDetectId):
        self._NetDetectId = NetDetectId

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def NetDetectName(self):
        return self._NetDetectName

    @NetDetectName.setter
    def NetDetectName(self, NetDetectName):
        self._NetDetectName = NetDetectName


    def _deserialize(self, params):
        self._DetectDestinationIp = params.get("DetectDestinationIp")
        self._NextHopType = params.get("NextHopType")
        self._NextHopDestination = params.get("NextHopDestination")
        self._NetDetectId = params.get("NetDetectId")
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._NetDetectName = params.get("NetDetectName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckNetDetectStateResponse(AbstractModel):
    """CheckNetDetectState response structure.

    """

    def __init__(self):
        r"""
        :param _NetDetectIpStateSet: The array of network detection verification results.
        :type NetDetectIpStateSet: list of NetDetectIpState
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NetDetectIpStateSet = None
        self._RequestId = None

    @property
    def NetDetectIpStateSet(self):
        return self._NetDetectIpStateSet

    @NetDetectIpStateSet.setter
    def NetDetectIpStateSet(self, NetDetectIpStateSet):
        self._NetDetectIpStateSet = NetDetectIpStateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetDetectIpStateSet") is not None:
            self._NetDetectIpStateSet = []
            for item in params.get("NetDetectIpStateSet"):
                obj = NetDetectIpState()
                obj._deserialize(item)
                self._NetDetectIpStateSet.append(obj)
        self._RequestId = params.get("RequestId")


class CidrForCcn(AbstractModel):
    """Publishes the routing policy of the VPC subnet to CCN

    """

    def __init__(self):
        r"""
        :param _Cidr: Local CIDR block, including subnet CIDR block and secondary CIDR block
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type Cidr: str
        :param _PublishedToVbc: Whether the routing policy of the VPC subnet is published to CCN.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type PublishedToVbc: bool
        """
        self._Cidr = None
        self._PublishedToVbc = None

    @property
    def Cidr(self):
        return self._Cidr

    @Cidr.setter
    def Cidr(self, Cidr):
        self._Cidr = Cidr

    @property
    def PublishedToVbc(self):
        return self._PublishedToVbc

    @PublishedToVbc.setter
    def PublishedToVbc(self, PublishedToVbc):
        self._PublishedToVbc = PublishedToVbc


    def _deserialize(self, params):
        self._Cidr = params.get("Cidr")
        self._PublishedToVbc = params.get("PublishedToVbc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClassicLinkInstance(AbstractModel):
    """Classiclink instance

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC instance ID
        :type VpcId: str
        :param _InstanceId: The unique ID of the CVM instance
        :type InstanceId: str
        """
        self._VpcId = None
        self._InstanceId = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloneSecurityGroupRequest(AbstractModel):
    """CloneSecurityGroup request structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroupId: Security group instance ID, such as `esg-33ocnj9n`, which can be obtained through the <a href="https://intl.cloud.tencent.com/document/product/215/15808?from_cn_redirect=1">DescribeSecurityGroups</a> API.
        :type SecurityGroupId: str
        :param _GroupName: The name of security group clone. You can enter any name within 60 characters. If this parameter is left empty, the security group clone will use the name of the source security group.
        :type GroupName: str
        :param _GroupDescription: Description of the security group clone. You can enter up to 100 characters. If this parameter is left empty, the security group clone will use the description of the source security group.
        :type GroupDescription: str
        :param _ProjectId: Project ID. Default value: 0. You can query it on the <a href="https://console.cloud.tencent.com/project">project management page</a> of the Tencent Cloud console.
        :type ProjectId: str
        :param _RemoteRegion: The region of the source security group for a cross-region clone. For example, to clone the security group in Guangzhou to Shanghai, set it to `ap-guangzhou`.
        :type RemoteRegion: str
        """
        self._SecurityGroupId = None
        self._GroupName = None
        self._GroupDescription = None
        self._ProjectId = None
        self._RemoteRegion = None

    @property
    def SecurityGroupId(self):
        return self._SecurityGroupId

    @SecurityGroupId.setter
    def SecurityGroupId(self, SecurityGroupId):
        self._SecurityGroupId = SecurityGroupId

    @property
    def GroupName(self):
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def GroupDescription(self):
        return self._GroupDescription

    @GroupDescription.setter
    def GroupDescription(self, GroupDescription):
        self._GroupDescription = GroupDescription

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RemoteRegion(self):
        return self._RemoteRegion

    @RemoteRegion.setter
    def RemoteRegion(self, RemoteRegion):
        self._RemoteRegion = RemoteRegion


    def _deserialize(self, params):
        self._SecurityGroupId = params.get("SecurityGroupId")
        self._GroupName = params.get("GroupName")
        self._GroupDescription = params.get("GroupDescription")
        self._ProjectId = params.get("ProjectId")
        self._RemoteRegion = params.get("RemoteRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloneSecurityGroupResponse(AbstractModel):
    """CloneSecurityGroup response structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroup: Security group object
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type SecurityGroup: :class:`tencentcloud.vpc.v20170312.models.SecurityGroup`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SecurityGroup = None
        self._RequestId = None

    @property
    def SecurityGroup(self):
        return self._SecurityGroup

    @SecurityGroup.setter
    def SecurityGroup(self, SecurityGroup):
        self._SecurityGroup = SecurityGroup

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SecurityGroup") is not None:
            self._SecurityGroup = SecurityGroup()
            self._SecurityGroup._deserialize(params.get("SecurityGroup"))
        self._RequestId = params.get("RequestId")


class ConflictItem(AbstractModel):
    """Conflict resource items.

    """

    def __init__(self):
        r"""
        :param _ConfilctId: Conflict resource ID
        :type ConfilctId: str
        :param _DestinationItem: Conflict destination resource
        :type DestinationItem: str
        """
        self._ConfilctId = None
        self._DestinationItem = None

    @property
    def ConfilctId(self):
        return self._ConfilctId

    @ConfilctId.setter
    def ConfilctId(self, ConfilctId):
        self._ConfilctId = ConfilctId

    @property
    def DestinationItem(self):
        return self._DestinationItem

    @DestinationItem.setter
    def DestinationItem(self, DestinationItem):
        self._DestinationItem = DestinationItem


    def _deserialize(self, params):
        self._ConfilctId = params.get("ConfilctId")
        self._DestinationItem = params.get("DestinationItem")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConflictSource(AbstractModel):
    """Conflict resource.

    """

    def __init__(self):
        r"""
        :param _ConflictSourceId: Conflict resource ID
        :type ConflictSourceId: str
        :param _SourceItem: Conflict resource
        :type SourceItem: str
        :param _ConflictItemSet: Conflict resource items
        :type ConflictItemSet: list of ConflictItem
        """
        self._ConflictSourceId = None
        self._SourceItem = None
        self._ConflictItemSet = None

    @property
    def ConflictSourceId(self):
        return self._ConflictSourceId

    @ConflictSourceId.setter
    def ConflictSourceId(self, ConflictSourceId):
        self._ConflictSourceId = ConflictSourceId

    @property
    def SourceItem(self):
        return self._SourceItem

    @SourceItem.setter
    def SourceItem(self, SourceItem):
        self._SourceItem = SourceItem

    @property
    def ConflictItemSet(self):
        return self._ConflictItemSet

    @ConflictItemSet.setter
    def ConflictItemSet(self, ConflictItemSet):
        self._ConflictItemSet = ConflictItemSet


    def _deserialize(self, params):
        self._ConflictSourceId = params.get("ConflictSourceId")
        self._SourceItem = params.get("SourceItem")
        if params.get("ConflictItemSet") is not None:
            self._ConflictItemSet = []
            for item in params.get("ConflictItemSet"):
                obj = ConflictItem()
                obj._deserialize(item)
                self._ConflictItemSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAddressTemplateGroupRequest(AbstractModel):
    """CreateAddressTemplateGroup request structure.

    """

    def __init__(self):
        r"""
        :param _AddressTemplateGroupName: Name of the IP address template group
        :type AddressTemplateGroupName: str
        :param _AddressTemplateIds: IP address template instance ID, such as `ipm-mdunqeb6`.
        :type AddressTemplateIds: list of str
        """
        self._AddressTemplateGroupName = None
        self._AddressTemplateIds = None

    @property
    def AddressTemplateGroupName(self):
        return self._AddressTemplateGroupName

    @AddressTemplateGroupName.setter
    def AddressTemplateGroupName(self, AddressTemplateGroupName):
        self._AddressTemplateGroupName = AddressTemplateGroupName

    @property
    def AddressTemplateIds(self):
        return self._AddressTemplateIds

    @AddressTemplateIds.setter
    def AddressTemplateIds(self, AddressTemplateIds):
        self._AddressTemplateIds = AddressTemplateIds


    def _deserialize(self, params):
        self._AddressTemplateGroupName = params.get("AddressTemplateGroupName")
        self._AddressTemplateIds = params.get("AddressTemplateIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAddressTemplateGroupResponse(AbstractModel):
    """CreateAddressTemplateGroup response structure.

    """

    def __init__(self):
        r"""
        :param _AddressTemplateGroup: Group object of the IP address template.
        :type AddressTemplateGroup: :class:`tencentcloud.vpc.v20170312.models.AddressTemplateGroup`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AddressTemplateGroup = None
        self._RequestId = None

    @property
    def AddressTemplateGroup(self):
        return self._AddressTemplateGroup

    @AddressTemplateGroup.setter
    def AddressTemplateGroup(self, AddressTemplateGroup):
        self._AddressTemplateGroup = AddressTemplateGroup

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AddressTemplateGroup") is not None:
            self._AddressTemplateGroup = AddressTemplateGroup()
            self._AddressTemplateGroup._deserialize(params.get("AddressTemplateGroup"))
        self._RequestId = params.get("RequestId")


class CreateAddressTemplateRequest(AbstractModel):
    """CreateAddressTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _AddressTemplateName: IP address template name.
        :type AddressTemplateName: str
        :param _Addresses: The address information can be presented by the IP, CIDR block or IP address range. Either Addresses or AddressesExtra is required.
        :type Addresses: list of str
        :param _AddressesExtra: The address information can contain remarks and be presented by the IP, CIDR block or IP address range. Either Addresses or AddressesExtra is required.
        :type AddressesExtra: list of AddressInfo
        """
        self._AddressTemplateName = None
        self._Addresses = None
        self._AddressesExtra = None

    @property
    def AddressTemplateName(self):
        return self._AddressTemplateName

    @AddressTemplateName.setter
    def AddressTemplateName(self, AddressTemplateName):
        self._AddressTemplateName = AddressTemplateName

    @property
    def Addresses(self):
        return self._Addresses

    @Addresses.setter
    def Addresses(self, Addresses):
        self._Addresses = Addresses

    @property
    def AddressesExtra(self):
        return self._AddressesExtra

    @AddressesExtra.setter
    def AddressesExtra(self, AddressesExtra):
        self._AddressesExtra = AddressesExtra


    def _deserialize(self, params):
        self._AddressTemplateName = params.get("AddressTemplateName")
        self._Addresses = params.get("Addresses")
        if params.get("AddressesExtra") is not None:
            self._AddressesExtra = []
            for item in params.get("AddressesExtra"):
                obj = AddressInfo()
                obj._deserialize(item)
                self._AddressesExtra.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAddressTemplateResponse(AbstractModel):
    """CreateAddressTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _AddressTemplate: The template object of the IP address.
        :type AddressTemplate: :class:`tencentcloud.vpc.v20170312.models.AddressTemplate`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AddressTemplate = None
        self._RequestId = None

    @property
    def AddressTemplate(self):
        return self._AddressTemplate

    @AddressTemplate.setter
    def AddressTemplate(self, AddressTemplate):
        self._AddressTemplate = AddressTemplate

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AddressTemplate") is not None:
            self._AddressTemplate = AddressTemplate()
            self._AddressTemplate._deserialize(params.get("AddressTemplate"))
        self._RequestId = params.get("RequestId")


class CreateAndAttachNetworkInterfaceRequest(AbstractModel):
    """CreateAndAttachNetworkInterface request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: The ID of the VPC instance. You can obtain the parameter value from the `VpcId` field in the returned result of the `DescribeVpcs` API.
        :type VpcId: str
        :param _NetworkInterfaceName: The name of the ENI. The maximum length is 60 bytes.
        :type NetworkInterfaceName: str
        :param _SubnetId: The subnet instance ID of the ENI, such as 'subnet-0ap8nwca'.
        :type SubnetId: str
        :param _InstanceId: CVM instance ID.
        :type InstanceId: str
        :param _PrivateIpAddresses: The information of the specified private IPs. You can specify a maximum of 10 IPs each time.
        :type PrivateIpAddresses: list of PrivateIpAddressSpecification
        :param _SecondaryPrivateIpAddressCount: The number of private IP addresses you apply for. The total number of private IP addresses cannot exceed the quota.
        :type SecondaryPrivateIpAddressCount: int
        :param _QosLevel: IP u200dservice level. It is used together with `SecondaryPrivateIpAddressCount`. Values: `PT` u200d(Gold), `AU` u200d(Silver), `AG` (Bronze) and `DEFAULT` (Default).
        :type QosLevel: str
        :param _SecurityGroupIds: The security group to be bound with, such as ['sg-1dd51d'].
        :type SecurityGroupIds: list of str
        :param _NetworkInterfaceDescription: The ENI description. You can enter any information within 60 characters.
        :type NetworkInterfaceDescription: str
        :param _Tags: Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :type Tags: list of Tag
        :param _AttachType: ENI mounting type. Valid values: `0` (standard); `1` (extension); default value: `0`
        :type AttachType: int
        """
        self._VpcId = None
        self._NetworkInterfaceName = None
        self._SubnetId = None
        self._InstanceId = None
        self._PrivateIpAddresses = None
        self._SecondaryPrivateIpAddressCount = None
        self._QosLevel = None
        self._SecurityGroupIds = None
        self._NetworkInterfaceDescription = None
        self._Tags = None
        self._AttachType = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def NetworkInterfaceName(self):
        return self._NetworkInterfaceName

    @NetworkInterfaceName.setter
    def NetworkInterfaceName(self, NetworkInterfaceName):
        self._NetworkInterfaceName = NetworkInterfaceName

    @property
    def SubnetId(self):
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def PrivateIpAddresses(self):
        return self._PrivateIpAddresses

    @PrivateIpAddresses.setter
    def PrivateIpAddresses(self, PrivateIpAddresses):
        self._PrivateIpAddresses = PrivateIpAddresses

    @property
    def SecondaryPrivateIpAddressCount(self):
        return self._SecondaryPrivateIpAddressCount

    @SecondaryPrivateIpAddressCount.setter
    def SecondaryPrivateIpAddressCount(self, SecondaryPrivateIpAddressCount):
        self._SecondaryPrivateIpAddressCount = SecondaryPrivateIpAddressCount

    @property
    def QosLevel(self):
        return self._QosLevel

    @QosLevel.setter
    def QosLevel(self, QosLevel):
        self._QosLevel = QosLevel

    @property
    def SecurityGroupIds(self):
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def NetworkInterfaceDescription(self):
        return self._NetworkInterfaceDescription

    @NetworkInterfaceDescription.setter
    def NetworkInterfaceDescription(self, NetworkInterfaceDescription):
        self._NetworkInterfaceDescription = NetworkInterfaceDescription

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def AttachType(self):
        return self._AttachType

    @AttachType.setter
    def AttachType(self, AttachType):
        self._AttachType = AttachType


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._NetworkInterfaceName = params.get("NetworkInterfaceName")
        self._SubnetId = params.get("SubnetId")
        self._InstanceId = params.get("InstanceId")
        if params.get("PrivateIpAddresses") is not None:
            self._PrivateIpAddresses = []
            for item in params.get("PrivateIpAddresses"):
                obj = PrivateIpAddressSpecification()
                obj._deserialize(item)
                self._PrivateIpAddresses.append(obj)
        self._SecondaryPrivateIpAddressCount = params.get("SecondaryPrivateIpAddressCount")
        self._QosLevel = params.get("QosLevel")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        self._NetworkInterfaceDescription = params.get("NetworkInterfaceDescription")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._AttachType = params.get("AttachType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAndAttachNetworkInterfaceResponse(AbstractModel):
    """CreateAndAttachNetworkInterface response structure.

    """

    def __init__(self):
        r"""
        :param _NetworkInterface: The ENI instance.
        :type NetworkInterface: :class:`tencentcloud.vpc.v20170312.models.NetworkInterface`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NetworkInterface = None
        self._RequestId = None

    @property
    def NetworkInterface(self):
        return self._NetworkInterface

    @NetworkInterface.setter
    def NetworkInterface(self, NetworkInterface):
        self._NetworkInterface = NetworkInterface

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetworkInterface") is not None:
            self._NetworkInterface = NetworkInterface()
            self._NetworkInterface._deserialize(params.get("NetworkInterface"))
        self._RequestId = params.get("RequestId")


class CreateAssistantCidrRequest(AbstractModel):
    """CreateAssistantCidr request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: `VPC` instance `ID`, such as `vpc-6v2ht8q5`.
        :type VpcId: str
        :param _CidrBlocks: Array of CIDR blocks, such as ["10.0.0.0/16", "172.16.0.0/16"]
        :type CidrBlocks: list of str
        """
        self._VpcId = None
        self._CidrBlocks = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def CidrBlocks(self):
        return self._CidrBlocks

    @CidrBlocks.setter
    def CidrBlocks(self, CidrBlocks):
        self._CidrBlocks = CidrBlocks


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._CidrBlocks = params.get("CidrBlocks")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAssistantCidrResponse(AbstractModel):
    """CreateAssistantCidr response structure.

    """

    def __init__(self):
        r"""
        :param _AssistantCidrSet: Array of secondary CIDR blocks.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AssistantCidrSet: list of AssistantCidr
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AssistantCidrSet = None
        self._RequestId = None

    @property
    def AssistantCidrSet(self):
        return self._AssistantCidrSet

    @AssistantCidrSet.setter
    def AssistantCidrSet(self, AssistantCidrSet):
        self._AssistantCidrSet = AssistantCidrSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AssistantCidrSet") is not None:
            self._AssistantCidrSet = []
            for item in params.get("AssistantCidrSet"):
                obj = AssistantCidr()
                obj._deserialize(item)
                self._AssistantCidrSet.append(obj)
        self._RequestId = params.get("RequestId")


class CreateBandwidthPackageRequest(AbstractModel):
    """CreateBandwidthPackage request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkType: The network type of the bandwidth package. Default value: `BGP`. Valid values:
`BGP` 
`HIGH_QUALITY_BGP`
        :type NetworkType: str
        :param _ChargeType: The billing mode of the bandwidth package. Default value: `TOP5_POSTPAID_BY_MONTH`. Valid values:
<li>`TOP5_POSTPAID_BY_MONTH`: monthly top 5 </li>
<li>`PERCENT95_POSTPAID_BY_MONTH`: monthly 95th percentile</li>
<li>`FIXED_PREPAID_BY_MONTH`: monthly subscription</li>
        :type ChargeType: str
        :param _BandwidthPackageName: The name of the bandwidth package.
        :type BandwidthPackageName: str
        :param _BandwidthPackageCount: The number of bandwidth packages to create. Valid range: 1-20. It can only be “1” for bill-by-CVM accounts.
        :type BandwidthPackageCount: int
        :param _InternetMaxBandwidth: The limit of the bandwidth package in Mbps. The value '-1' indicates there is no limit. This feature is currently in beta.
        :type InternetMaxBandwidth: int
        :param _Tags: The list of tags to be bound.
        :type Tags: list of Tag
        :param _Protocol: The protocol type of the bandwidth package. Valid values: 'ipv4' and 'ipv6'. Default value: 'ipv4'.
        :type Protocol: str
        """
        self._NetworkType = None
        self._ChargeType = None
        self._BandwidthPackageName = None
        self._BandwidthPackageCount = None
        self._InternetMaxBandwidth = None
        self._Tags = None
        self._Protocol = None

    @property
    def NetworkType(self):
        return self._NetworkType

    @NetworkType.setter
    def NetworkType(self, NetworkType):
        self._NetworkType = NetworkType

    @property
    def ChargeType(self):
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def BandwidthPackageName(self):
        return self._BandwidthPackageName

    @BandwidthPackageName.setter
    def BandwidthPackageName(self, BandwidthPackageName):
        self._BandwidthPackageName = BandwidthPackageName

    @property
    def BandwidthPackageCount(self):
        return self._BandwidthPackageCount

    @BandwidthPackageCount.setter
    def BandwidthPackageCount(self, BandwidthPackageCount):
        self._BandwidthPackageCount = BandwidthPackageCount

    @property
    def InternetMaxBandwidth(self):
        return self._InternetMaxBandwidth

    @InternetMaxBandwidth.setter
    def InternetMaxBandwidth(self, InternetMaxBandwidth):
        self._InternetMaxBandwidth = InternetMaxBandwidth

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def Protocol(self):
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol


    def _deserialize(self, params):
        self._NetworkType = params.get("NetworkType")
        self._ChargeType = params.get("ChargeType")
        self._BandwidthPackageName = params.get("BandwidthPackageName")
        self._BandwidthPackageCount = params.get("BandwidthPackageCount")
        self._InternetMaxBandwidth = params.get("InternetMaxBandwidth")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._Protocol = params.get("Protocol")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateBandwidthPackageResponse(AbstractModel):
    """CreateBandwidthPackage response structure.

    """

    def __init__(self):
        r"""
        :param _BandwidthPackageId: The unique ID of the bandwidth package.
        :type BandwidthPackageId: str
        :param _BandwidthPackageIds: The unique ID list of the bandwidth package (effective only when you apply for more than 1 bandwidth packages).
        :type BandwidthPackageIds: list of str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._BandwidthPackageId = None
        self._BandwidthPackageIds = None
        self._RequestId = None

    @property
    def BandwidthPackageId(self):
        return self._BandwidthPackageId

    @BandwidthPackageId.setter
    def BandwidthPackageId(self, BandwidthPackageId):
        self._BandwidthPackageId = BandwidthPackageId

    @property
    def BandwidthPackageIds(self):
        return self._BandwidthPackageIds

    @BandwidthPackageIds.setter
    def BandwidthPackageIds(self, BandwidthPackageIds):
        self._BandwidthPackageIds = BandwidthPackageIds

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._BandwidthPackageId = params.get("BandwidthPackageId")
        self._BandwidthPackageIds = params.get("BandwidthPackageIds")
        self._RequestId = params.get("RequestId")


class CreateCcnRequest(AbstractModel):
    """CreateCcn request structure.

    """

    def __init__(self):
        r"""
        :param _CcnName: The name of the CCN. The maximum length is 60 characters.
        :type CcnName: str
        :param _CcnDescription: The description of the CCN. The maximum length is 100 characters.
        :type CcnDescription: str
        :param _QosLevel: CCN service quality, 'PT': Platinum, 'AU': Gold, 'AG': Silver. The default is 'AU'.
        :type QosLevel: str
        :param _InstanceChargeType: The billing method. POSTPAID: postpaid by traffic. Default: POSTPAID.
        :type InstanceChargeType: str
        :param _BandwidthLimitType: The bandwidth limit type. Valid values: OUTER_REGION_LIMIT: region outbound bandwidth limit; INTER_REGION_LIMIT: inter-region bandwidth limit. Default value: OUTER_REGION_LIMIT. Monthly-subscribed CCN instances only support inter-region bandwidth limit, while pay-as-you-go CCN instances support the both bandwidth limit types.
        :type BandwidthLimitType: str
        :param _Tags: Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :type Tags: list of Tag
        """
        self._CcnName = None
        self._CcnDescription = None
        self._QosLevel = None
        self._InstanceChargeType = None
        self._BandwidthLimitType = None
        self._Tags = None

    @property
    def CcnName(self):
        return self._CcnName

    @CcnName.setter
    def CcnName(self, CcnName):
        self._CcnName = CcnName

    @property
    def CcnDescription(self):
        return self._CcnDescription

    @CcnDescription.setter
    def CcnDescription(self, CcnDescription):
        self._CcnDescription = CcnDescription

    @property
    def QosLevel(self):
        return self._QosLevel

    @QosLevel.setter
    def QosLevel(self, QosLevel):
        self._QosLevel = QosLevel

    @property
    def InstanceChargeType(self):
        return self._InstanceChargeType

    @InstanceChargeType.setter
    def InstanceChargeType(self, InstanceChargeType):
        self._InstanceChargeType = InstanceChargeType

    @property
    def BandwidthLimitType(self):
        return self._BandwidthLimitType

    @BandwidthLimitType.setter
    def BandwidthLimitType(self, BandwidthLimitType):
        self._BandwidthLimitType = BandwidthLimitType

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._CcnName = params.get("CcnName")
        self._CcnDescription = params.get("CcnDescription")
        self._QosLevel = params.get("QosLevel")
        self._InstanceChargeType = params.get("InstanceChargeType")
        self._BandwidthLimitType = params.get("BandwidthLimitType")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCcnResponse(AbstractModel):
    """CreateCcn response structure.

    """

    def __init__(self):
        r"""
        :param _Ccn: The CCN object.
        :type Ccn: :class:`tencentcloud.vpc.v20170312.models.CCN`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Ccn = None
        self._RequestId = None

    @property
    def Ccn(self):
        return self._Ccn

    @Ccn.setter
    def Ccn(self, Ccn):
        self._Ccn = Ccn

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Ccn") is not None:
            self._Ccn = CCN()
            self._Ccn._deserialize(params.get("Ccn"))
        self._RequestId = params.get("RequestId")


class CreateCustomerGatewayRequest(AbstractModel):
    """CreateCustomerGateway request structure.

    """

    def __init__(self):
        r"""
        :param _CustomerGatewayName: Customer gateway can be named freely, but the maximum length is 60 characters.
        :type CustomerGatewayName: str
        :param _IpAddress: Customer gateway public IP.
        :type IpAddress: str
        :param _Tags: Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :type Tags: list of Tag
        """
        self._CustomerGatewayName = None
        self._IpAddress = None
        self._Tags = None

    @property
    def CustomerGatewayName(self):
        return self._CustomerGatewayName

    @CustomerGatewayName.setter
    def CustomerGatewayName(self, CustomerGatewayName):
        self._CustomerGatewayName = CustomerGatewayName

    @property
    def IpAddress(self):
        return self._IpAddress

    @IpAddress.setter
    def IpAddress(self, IpAddress):
        self._IpAddress = IpAddress

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._CustomerGatewayName = params.get("CustomerGatewayName")
        self._IpAddress = params.get("IpAddress")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCustomerGatewayResponse(AbstractModel):
    """CreateCustomerGateway response structure.

    """

    def __init__(self):
        r"""
        :param _CustomerGateway: Customer gateway object
        :type CustomerGateway: :class:`tencentcloud.vpc.v20170312.models.CustomerGateway`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._CustomerGateway = None
        self._RequestId = None

    @property
    def CustomerGateway(self):
        return self._CustomerGateway

    @CustomerGateway.setter
    def CustomerGateway(self, CustomerGateway):
        self._CustomerGateway = CustomerGateway

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CustomerGateway") is not None:
            self._CustomerGateway = CustomerGateway()
            self._CustomerGateway._deserialize(params.get("CustomerGateway"))
        self._RequestId = params.get("RequestId")


class CreateDefaultVpcRequest(AbstractModel):
    """CreateDefaultVpc request structure.

    """

    def __init__(self):
        r"""
        :param _Zone: The ID of the availability zone in which the subnet resides. This parameter can be obtained through the [`DescribeZones`](https://intl.cloud.tencent.com/document/product/213/15707?from_cn_redirect=1) API, such as `ap-guangzhou-1`. If it’s not specified, a random availability zone will be used.
        :type Zone: str
        :param _Force: Whether to forcibly return a default VPC
        :type Force: bool
        """
        self._Zone = None
        self._Force = None

    @property
    def Zone(self):
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def Force(self):
        return self._Force

    @Force.setter
    def Force(self, Force):
        self._Force = Force


    def _deserialize(self, params):
        self._Zone = params.get("Zone")
        self._Force = params.get("Force")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDefaultVpcResponse(AbstractModel):
    """CreateDefaultVpc response structure.

    """

    def __init__(self):
        r"""
        :param _Vpc: Default VPC and subnet IDs
        :type Vpc: :class:`tencentcloud.vpc.v20170312.models.DefaultVpcSubnet`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Vpc = None
        self._RequestId = None

    @property
    def Vpc(self):
        return self._Vpc

    @Vpc.setter
    def Vpc(self, Vpc):
        self._Vpc = Vpc

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Vpc") is not None:
            self._Vpc = DefaultVpcSubnet()
            self._Vpc._deserialize(params.get("Vpc"))
        self._RequestId = params.get("RequestId")


class CreateDirectConnectGatewayCcnRoutesRequest(AbstractModel):
    """CreateDirectConnectGatewayCcnRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _DirectConnectGatewayId: The ID of the Direct Connect gateway, such as `dcg-prpqlmg1`
        :type DirectConnectGatewayId: str
        :param _Routes: The list of IDC IP range that must be connected
        :type Routes: list of DirectConnectGatewayCcnRoute
        """
        self._DirectConnectGatewayId = None
        self._Routes = None

    @property
    def DirectConnectGatewayId(self):
        return self._DirectConnectGatewayId

    @DirectConnectGatewayId.setter
    def DirectConnectGatewayId(self, DirectConnectGatewayId):
        self._DirectConnectGatewayId = DirectConnectGatewayId

    @property
    def Routes(self):
        return self._Routes

    @Routes.setter
    def Routes(self, Routes):
        self._Routes = Routes


    def _deserialize(self, params):
        self._DirectConnectGatewayId = params.get("DirectConnectGatewayId")
        if params.get("Routes") is not None:
            self._Routes = []
            for item in params.get("Routes"):
                obj = DirectConnectGatewayCcnRoute()
                obj._deserialize(item)
                self._Routes.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDirectConnectGatewayCcnRoutesResponse(AbstractModel):
    """CreateDirectConnectGatewayCcnRoutes response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateDirectConnectGatewayRequest(AbstractModel):
    """CreateDirectConnectGateway request structure.

    """

    def __init__(self):
        r"""
        :param _DirectConnectGatewayName: The name of the direct connect gateway.
        :type DirectConnectGatewayName: str
        :param _NetworkType: The type of the associated network. Valid values:
<li>VPC</li>
<li>CCN</li>
        :type NetworkType: str
        :param _NetworkInstanceId: <li>When the NetworkType is VPC, this value is the VPC instance ID</li>
<li>When the NetworkType is CCN, this value is the CCN instance ID</li>
        :type NetworkInstanceId: str
        :param _GatewayType: The type of the gateway. Valid values:
<li>NORMAL - (Default) Standard type. Note: CCN only supports the standard type</li>
<li>NAT - NAT type</li>NAT gateway supports network address translation. The specified type cannot be modified. A VPC can create one NAT direct connect gateway and one non-NAT direct connect gateway
        :type GatewayType: str
        :param _ModeType: CCN route publishing method. Valid values: `standard` and `exquisite`. This parameter is only valid for the CCN direct connect gateway.
        :type ModeType: str
        :param _Zone: Availability zone where the direct connect gateway resides.
        :type Zone: str
        :param _HaZoneGroupId: ID of DC highly available placement group
        :type HaZoneGroupId: str
        """
        self._DirectConnectGatewayName = None
        self._NetworkType = None
        self._NetworkInstanceId = None
        self._GatewayType = None
        self._ModeType = None
        self._Zone = None
        self._HaZoneGroupId = None

    @property
    def DirectConnectGatewayName(self):
        return self._DirectConnectGatewayName

    @DirectConnectGatewayName.setter
    def DirectConnectGatewayName(self, DirectConnectGatewayName):
        self._DirectConnectGatewayName = DirectConnectGatewayName

    @property
    def NetworkType(self):
        return self._NetworkType

    @NetworkType.setter
    def NetworkType(self, NetworkType):
        self._NetworkType = NetworkType

    @property
    def NetworkInstanceId(self):
        return self._NetworkInstanceId

    @NetworkInstanceId.setter
    def NetworkInstanceId(self, NetworkInstanceId):
        self._NetworkInstanceId = NetworkInstanceId

    @property
    def GatewayType(self):
        return self._GatewayType

    @GatewayType.setter
    def GatewayType(self, GatewayType):
        self._GatewayType = GatewayType

    @property
    def ModeType(self):
        return self._ModeType

    @ModeType.setter
    def ModeType(self, ModeType):
        self._ModeType = ModeType

    @property
    def Zone(self):
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def HaZoneGroupId(self):
        return self._HaZoneGroupId

    @HaZoneGroupId.setter
    def HaZoneGroupId(self, HaZoneGroupId):
        self._HaZoneGroupId = HaZoneGroupId


    def _deserialize(self, params):
        self._DirectConnectGatewayName = params.get("DirectConnectGatewayName")
        self._NetworkType = params.get("NetworkType")
        self._NetworkInstanceId = params.get("NetworkInstanceId")
        self._GatewayType = params.get("GatewayType")
        self._ModeType = params.get("ModeType")
        self._Zone = params.get("Zone")
        self._HaZoneGroupId = params.get("HaZoneGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDirectConnectGatewayResponse(AbstractModel):
    """CreateDirectConnectGateway response structure.

    """

    def __init__(self):
        r"""
        :param _DirectConnectGateway: The object of the direct connect gateway.
        :type DirectConnectGateway: :class:`tencentcloud.vpc.v20170312.models.DirectConnectGateway`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DirectConnectGateway = None
        self._RequestId = None

    @property
    def DirectConnectGateway(self):
        return self._DirectConnectGateway

    @DirectConnectGateway.setter
    def DirectConnectGateway(self, DirectConnectGateway):
        self._DirectConnectGateway = DirectConnectGateway

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DirectConnectGateway") is not None:
            self._DirectConnectGateway = DirectConnectGateway()
            self._DirectConnectGateway._deserialize(params.get("DirectConnectGateway"))
        self._RequestId = params.get("RequestId")


class CreateFlowLogRequest(AbstractModel):
    """CreateFlowLog request structure.

    """

    def __init__(self):
        r"""
        :param _FlowLogName: The name of the flow log instance.
        :type FlowLogName: str
        :param _ResourceType: The type of resource associated with the flow log. Valid values: `VPC`, `SUBNET`, `NETWORKINTERFACE`, `CCN`, `NAT`, and `DCG`.
        :type ResourceType: str
        :param _ResourceId: The unique ID of the resource.
        :type ResourceId: str
        :param _TrafficType: Type of the flow logs to be collected. Valid values: `ACCEPT`, `REJECT` and `ALL`.
        :type TrafficType: str
        :param _VpcId: The VPC ID or unique ID of the resource. We recommend using the unique ID. This parameter is required unless the `ResourceType` is set to `CCN`.
        :type VpcId: str
        :param _FlowLogDescription: The description of the flow log.
        :type FlowLogDescription: str
        :param _CloudLogId: The storage ID of the flow log.
        :type CloudLogId: str
        :param _Tags: Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :type Tags: list of Tag
        :param _StorageType: Consumer types: `cls` and `ckafka`
        :type StorageType: str
        :param _FlowLogStorage: Information of the flow log consumer, which is required when the consumer type is `ckafka`.
        :type FlowLogStorage: :class:`tencentcloud.vpc.v20170312.models.FlowLogStorage`
        :param _CloudLogRegion: The region corresponding to the flow log storage ID. If not passed in, this field defaults to the current region.
        :type CloudLogRegion: str
        """
        self._FlowLogName = None
        self._ResourceType = None
        self._ResourceId = None
        self._TrafficType = None
        self._VpcId = None
        self._FlowLogDescription = None
        self._CloudLogId = None
        self._Tags = None
        self._StorageType = None
        self._FlowLogStorage = None
        self._CloudLogRegion = None

    @property
    def FlowLogName(self):
        return self._FlowLogName

    @FlowLogName.setter
    def FlowLogName(self, FlowLogName):
        self._FlowLogName = FlowLogName

    @property
    def ResourceType(self):
        return self._ResourceType

    @ResourceType.setter
    def ResourceType(self, ResourceType):
        self._ResourceType = ResourceType

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId

    @property
    def TrafficType(self):
        return self._TrafficType

    @TrafficType.setter
    def TrafficType(self, TrafficType):
        self._TrafficType = TrafficType

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def FlowLogDescription(self):
        return self._FlowLogDescription

    @FlowLogDescription.setter
    def FlowLogDescription(self, FlowLogDescription):
        self._FlowLogDescription = FlowLogDescription

    @property
    def CloudLogId(self):
        return self._CloudLogId

    @CloudLogId.setter
    def CloudLogId(self, CloudLogId):
        self._CloudLogId = CloudLogId

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def StorageType(self):
        return self._StorageType

    @StorageType.setter
    def StorageType(self, StorageType):
        self._StorageType = StorageType

    @property
    def FlowLogStorage(self):
        return self._FlowLogStorage

    @FlowLogStorage.setter
    def FlowLogStorage(self, FlowLogStorage):
        self._FlowLogStorage = FlowLogStorage

    @property
    def CloudLogRegion(self):
        return self._CloudLogRegion

    @CloudLogRegion.setter
    def CloudLogRegion(self, CloudLogRegion):
        self._CloudLogRegion = CloudLogRegion


    def _deserialize(self, params):
        self._FlowLogName = params.get("FlowLogName")
        self._ResourceType = params.get("ResourceType")
        self._ResourceId = params.get("ResourceId")
        self._TrafficType = params.get("TrafficType")
        self._VpcId = params.get("VpcId")
        self._FlowLogDescription = params.get("FlowLogDescription")
        self._CloudLogId = params.get("CloudLogId")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._StorageType = params.get("StorageType")
        if params.get("FlowLogStorage") is not None:
            self._FlowLogStorage = FlowLogStorage()
            self._FlowLogStorage._deserialize(params.get("FlowLogStorage"))
        self._CloudLogRegion = params.get("CloudLogRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateFlowLogResponse(AbstractModel):
    """CreateFlowLog response structure.

    """

    def __init__(self):
        r"""
        :param _FlowLog: The information of the flow log created.
        :type FlowLog: list of FlowLog
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowLog = None
        self._RequestId = None

    @property
    def FlowLog(self):
        return self._FlowLog

    @FlowLog.setter
    def FlowLog(self, FlowLog):
        self._FlowLog = FlowLog

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("FlowLog") is not None:
            self._FlowLog = []
            for item in params.get("FlowLog"):
                obj = FlowLog()
                obj._deserialize(item)
                self._FlowLog.append(obj)
        self._RequestId = params.get("RequestId")


class CreateHaVipRequest(AbstractModel):
    """CreateHaVip request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: The `ID` of the VPC to which the `HAVIP` belongs.
        :type VpcId: str
        :param _SubnetId: The `ID` of the subnet to which the `HAVIP` belongs.
        :type SubnetId: str
        :param _HaVipName: The name of the `HAVIP`.
        :type HaVipName: str
        :param _Vip: The specified virtual IP address, which must be within the IP range of the `VPC` and not in use. It will be automatically assigned if not specified.
        :type Vip: str
        :param _NetworkInterfaceId: The ID of the ENI associated with the HAVIP.
        :type NetworkInterfaceId: str
        """
        self._VpcId = None
        self._SubnetId = None
        self._HaVipName = None
        self._Vip = None
        self._NetworkInterfaceId = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def HaVipName(self):
        return self._HaVipName

    @HaVipName.setter
    def HaVipName(self, HaVipName):
        self._HaVipName = HaVipName

    @property
    def Vip(self):
        return self._Vip

    @Vip.setter
    def Vip(self, Vip):
        self._Vip = Vip

    @property
    def NetworkInterfaceId(self):
        return self._NetworkInterfaceId

    @NetworkInterfaceId.setter
    def NetworkInterfaceId(self, NetworkInterfaceId):
        self._NetworkInterfaceId = NetworkInterfaceId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._HaVipName = params.get("HaVipName")
        self._Vip = params.get("Vip")
        self._NetworkInterfaceId = params.get("NetworkInterfaceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateHaVipResponse(AbstractModel):
    """CreateHaVip response structure.

    """

    def __init__(self):
        r"""
        :param _HaVip: `HAVIP` object.
        :type HaVip: :class:`tencentcloud.vpc.v20170312.models.HaVip`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._HaVip = None
        self._RequestId = None

    @property
    def HaVip(self):
        return self._HaVip

    @HaVip.setter
    def HaVip(self, HaVip):
        self._HaVip = HaVip

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("HaVip") is not None:
            self._HaVip = HaVip()
            self._HaVip._deserialize(params.get("HaVip"))
        self._RequestId = params.get("RequestId")


class CreateLocalGatewayRequest(AbstractModel):
    """CreateLocalGateway request structure.

    """

    def __init__(self):
        r"""
        :param _LocalGatewayName: Local gateway name
        :type LocalGatewayName: str
        :param _VpcId: VPC instance ID
        :type VpcId: str
        :param _CdcId: CDC instance ID
        :type CdcId: str
        """
        self._LocalGatewayName = None
        self._VpcId = None
        self._CdcId = None

    @property
    def LocalGatewayName(self):
        return self._LocalGatewayName

    @LocalGatewayName.setter
    def LocalGatewayName(self, LocalGatewayName):
        self._LocalGatewayName = LocalGatewayName

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def CdcId(self):
        return self._CdcId

    @CdcId.setter
    def CdcId(self, CdcId):
        self._CdcId = CdcId


    def _deserialize(self, params):
        self._LocalGatewayName = params.get("LocalGatewayName")
        self._VpcId = params.get("VpcId")
        self._CdcId = params.get("CdcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLocalGatewayResponse(AbstractModel):
    """CreateLocalGateway response structure.

    """

    def __init__(self):
        r"""
        :param _LocalGateway: Local gateway information
        :type LocalGateway: :class:`tencentcloud.vpc.v20170312.models.LocalGateway`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._LocalGateway = None
        self._RequestId = None

    @property
    def LocalGateway(self):
        return self._LocalGateway

    @LocalGateway.setter
    def LocalGateway(self, LocalGateway):
        self._LocalGateway = LocalGateway

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("LocalGateway") is not None:
            self._LocalGateway = LocalGateway()
            self._LocalGateway._deserialize(params.get("LocalGateway"))
        self._RequestId = params.get("RequestId")


class CreateNatGatewayDestinationIpPortTranslationNatRuleRequest(AbstractModel):
    """CreateNatGatewayDestinationIpPortTranslationNatRule request structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: The ID of the NAT gateway, such as `nat-df45454`.
        :type NatGatewayId: str
        :param _DestinationIpPortTranslationNatRules: The port forwarding rules of the NAT gateway.
        :type DestinationIpPortTranslationNatRules: list of DestinationIpPortTranslationNatRule
        """
        self._NatGatewayId = None
        self._DestinationIpPortTranslationNatRules = None

    @property
    def NatGatewayId(self):
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def DestinationIpPortTranslationNatRules(self):
        return self._DestinationIpPortTranslationNatRules

    @DestinationIpPortTranslationNatRules.setter
    def DestinationIpPortTranslationNatRules(self, DestinationIpPortTranslationNatRules):
        self._DestinationIpPortTranslationNatRules = DestinationIpPortTranslationNatRules


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        if params.get("DestinationIpPortTranslationNatRules") is not None:
            self._DestinationIpPortTranslationNatRules = []
            for item in params.get("DestinationIpPortTranslationNatRules"):
                obj = DestinationIpPortTranslationNatRule()
                obj._deserialize(item)
                self._DestinationIpPortTranslationNatRules.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNatGatewayDestinationIpPortTranslationNatRuleResponse(AbstractModel):
    """CreateNatGatewayDestinationIpPortTranslationNatRule response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateNatGatewayRequest(AbstractModel):
    """CreateNatGateway request structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewayName: NAT gateway name
        :type NatGatewayName: str
        :param _VpcId: The ID of the VPC instance, which can be obtained from the `VpcId` field in response of the `DescribeVpcs` API.
        :type VpcId: str
        :param _InternetMaxBandwidthOut: The maximum outbound bandwidth of the NAT gateway (unit: Mbps). Supported parameter values: `20, 50, 100, 200, 500, 1000, 2000, 5000`. Default: `100`.
        :type InternetMaxBandwidthOut: int
        :param _MaxConcurrentConnection: The concurrent connection cap of the NAT gateway. Values: `1000000, 3000000, 10000000`. The default value is `1000000`.
        :type MaxConcurrentConnection: int
        :param _AddressCount: The number of EIPs that you want to apply for. Either `AddressCount` or `PublicIpAddresses` must be passed in.
        :type AddressCount: int
        :param _PublicIpAddresses: The EIP array bound to the NAT gateway. Either AddressCount or PublicIpAddresses must be passed in.
        :type PublicIpAddresses: list of str
        :param _Zone: The availability zone, such as `ap-guangzhou-1`.
        :type Zone: str
        :param _Tags: Bound tags, such as [{"Key": "city", "Value": "shanghai"}]
        :type Tags: list of Tag
        :param _SubnetId: Subnet of the NAT gateway
        :type SubnetId: str
        :param _StockPublicIpAddressesBandwidthOut: The bandwidth size (in Mbps) of the EIP bound to the NAT gateway, which defaults to the maximum value applicable for the current user type.
        :type StockPublicIpAddressesBandwidthOut: int
        :param _PublicIpAddressesBandwidthOut: The size of the public network IP bandwidth to be applied for (in Mbps), which defaults to the maximum value applicable for the current user type.
        :type PublicIpAddressesBandwidthOut: int
        :param _PublicIpFromSameZone: Whether the public IP and the NAT gateway must be in the same availability zone. Valid values: `true` and `false`. This parameter is valid only when `Zone` is specified.
        :type PublicIpFromSameZone: bool
        """
        self._NatGatewayName = None
        self._VpcId = None
        self._InternetMaxBandwidthOut = None
        self._MaxConcurrentConnection = None
        self._AddressCount = None
        self._PublicIpAddresses = None
        self._Zone = None
        self._Tags = None
        self._SubnetId = None
        self._StockPublicIpAddressesBandwidthOut = None
        self._PublicIpAddressesBandwidthOut = None
        self._PublicIpFromSameZone = None

    @property
    def NatGatewayName(self):
        return self._NatGatewayName

    @NatGatewayName.setter
    def NatGatewayName(self, NatGatewayName):
        self._NatGatewayName = NatGatewayName

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def InternetMaxBandwidthOut(self):
        return self._InternetMaxBandwidthOut

    @InternetMaxBandwidthOut.setter
    def InternetMaxBandwidthOut(self, InternetMaxBandwidthOut):
        self._InternetMaxBandwidthOut = InternetMaxBandwidthOut

    @property
    def MaxConcurrentConnection(self):
        return self._MaxConcurrentConnection

    @MaxConcurrentConnection.setter
    def MaxConcurrentConnection(self, MaxConcurrentConnection):
        self._MaxConcurrentConnection = MaxConcurrentConnection

    @property
    def AddressCount(self):
        return self._AddressCount

    @AddressCount.setter
    def AddressCount(self, AddressCount):
        self._AddressCount = AddressCount

    @property
    def PublicIpAddresses(self):
        return self._PublicIpAddresses

    @PublicIpAddresses.setter
    def PublicIpAddresses(self, PublicIpAddresses):
        self._PublicIpAddresses = PublicIpAddresses

    @property
    def Zone(self):
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def SubnetId(self):
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def StockPublicIpAddressesBandwidthOut(self):
        return self._StockPublicIpAddressesBandwidthOut

    @StockPublicIpAddressesBandwidthOut.setter
    def StockPublicIpAddressesBandwidthOut(self, StockPublicIpAddressesBandwidthOut):
        self._StockPublicIpAddressesBandwidthOut = StockPublicIpAddressesBandwidthOut

    @property
    def PublicIpAddressesBandwidthOut(self):
        return self._PublicIpAddressesBandwidthOut

    @PublicIpAddressesBandwidthOut.setter
    def PublicIpAddressesBandwidthOut(self, PublicIpAddressesBandwidthOut):
        self._PublicIpAddressesBandwidthOut = PublicIpAddressesBandwidthOut

    @property
    def PublicIpFromSameZone(self):
        return self._PublicIpFromSameZone

    @PublicIpFromSameZone.setter
    def PublicIpFromSameZone(self, PublicIpFromSameZone):
        self._PublicIpFromSameZone = PublicIpFromSameZone


    def _deserialize(self, params):
        self._NatGatewayName = params.get("NatGatewayName")
        self._VpcId = params.get("VpcId")
        self._InternetMaxBandwidthOut = params.get("InternetMaxBandwidthOut")
        self._MaxConcurrentConnection = params.get("MaxConcurrentConnection")
        self._AddressCount = params.get("AddressCount")
        self._PublicIpAddresses = params.get("PublicIpAddresses")
        self._Zone = params.get("Zone")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._SubnetId = params.get("SubnetId")
        self._StockPublicIpAddressesBandwidthOut = params.get("StockPublicIpAddressesBandwidthOut")
        self._PublicIpAddressesBandwidthOut = params.get("PublicIpAddressesBandwidthOut")
        self._PublicIpFromSameZone = params.get("PublicIpFromSameZone")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNatGatewayResponse(AbstractModel):
    """CreateNatGateway response structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewaySet: NAT gateway object array.
        :type NatGatewaySet: list of NatGateway
        :param _TotalCount: The number of eligible NAT gateway objects.
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NatGatewaySet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def NatGatewaySet(self):
        return self._NatGatewaySet

    @NatGatewaySet.setter
    def NatGatewaySet(self, NatGatewaySet):
        self._NatGatewaySet = NatGatewaySet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NatGatewaySet") is not None:
            self._NatGatewaySet = []
            for item in params.get("NatGatewaySet"):
                obj = NatGateway()
                obj._deserialize(item)
                self._NatGatewaySet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class CreateNatGatewaySourceIpTranslationNatRuleRequest(AbstractModel):
    """CreateNatGatewaySourceIpTranslationNatRule request structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: The ID of the NAT Gateway, such as `nat-df45454`
        :type NatGatewayId: str
        :param _SourceIpTranslationNatRules: The SNAT forwarding rule of the NAT Gateway
        :type SourceIpTranslationNatRules: list of SourceIpTranslationNatRule
        """
        self._NatGatewayId = None
        self._SourceIpTranslationNatRules = None

    @property
    def NatGatewayId(self):
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def SourceIpTranslationNatRules(self):
        return self._SourceIpTranslationNatRules

    @SourceIpTranslationNatRules.setter
    def SourceIpTranslationNatRules(self, SourceIpTranslationNatRules):
        self._SourceIpTranslationNatRules = SourceIpTranslationNatRules


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        if params.get("SourceIpTranslationNatRules") is not None:
            self._SourceIpTranslationNatRules = []
            for item in params.get("SourceIpTranslationNatRules"):
                obj = SourceIpTranslationNatRule()
                obj._deserialize(item)
                self._SourceIpTranslationNatRules.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNatGatewaySourceIpTranslationNatRuleResponse(AbstractModel):
    """CreateNatGatewaySourceIpTranslationNatRule response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateNetDetectRequest(AbstractModel):
    """CreateNetDetect request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: The ID of a VPC instance, such as `vpc-12345678`.
        :type VpcId: str
        :param _SubnetId: The ID of a subnet instance, such as subnet-12345678.
        :type SubnetId: str
        :param _NetDetectName: The name of a network detection instance. The maximum length is 60 characters.
        :type NetDetectName: str
        :param _DetectDestinationIp: The array of detection destination IPv4 addresses, which contains at most two IP addresses.
        :type DetectDestinationIp: list of str
        :param _NextHopType: Type of the next hop. Valid values:
`VPN`: VPN gateway;
`DIRECTCONNECT`: Direct connect gateway;
`PEERCONNECTION`: Peering connection;
`NAT`: NAT gateway;
`NORMAL_CVM`: CVM instance;
`CCN`: CCN instance;
`NONEXTHOP`: No next hop.
        :type NextHopType: str
        :param _NextHopDestination: ID of the next-hop gateway.
If NextHopType is set to VPN, the value of this parameter is the VPN gateway ID, such as vpngw-12345678.
`NextHopType` = `DIRECTCONNECT`: Direct connect gateway ID, such as `dcg-12345678`.
`NextHopType` = `PEERCONNECTION`: Peering connection ID, such as `pcx-12345678`.
`NextHopType` = `NAT`: NAT gateway ID, such as `nat-12345678`.
If NextHopType is set to NORMAL_CVM, the value of this parameter is the IPv4 address of the CVM, such as 10.0.0.12.
`NextHopType` = `CCN`: CCN instance ID, such as `ccn-12345678`.
`NextHopType` = `NONEXTHOP`: No next hop.
        :type NextHopDestination: str
        :param _NetDetectDescription: Network detection description.
        :type NetDetectDescription: str
        """
        self._VpcId = None
        self._SubnetId = None
        self._NetDetectName = None
        self._DetectDestinationIp = None
        self._NextHopType = None
        self._NextHopDestination = None
        self._NetDetectDescription = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def NetDetectName(self):
        return self._NetDetectName

    @NetDetectName.setter
    def NetDetectName(self, NetDetectName):
        self._NetDetectName = NetDetectName

    @property
    def DetectDestinationIp(self):
        return self._DetectDestinationIp

    @DetectDestinationIp.setter
    def DetectDestinationIp(self, DetectDestinationIp):
        self._DetectDestinationIp = DetectDestinationIp

    @property
    def NextHopType(self):
        return self._NextHopType

    @NextHopType.setter
    def NextHopType(self, NextHopType):
        self._NextHopType = NextHopType

    @property
    def NextHopDestination(self):
        return self._NextHopDestination

    @NextHopDestination.setter
    def NextHopDestination(self, NextHopDestination):
        self._NextHopDestination = NextHopDestination

    @property
    def NetDetectDescription(self):
        return self._NetDetectDescription

    @NetDetectDescription.setter
    def NetDetectDescription(self, NetDetectDescription):
        self._NetDetectDescription = NetDetectDescription


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._NetDetectName = params.get("NetDetectName")
        self._DetectDestinationIp = params.get("DetectDestinationIp")
        self._NextHopType = params.get("NextHopType")
        self._NextHopDestination = params.get("NextHopDestination")
        self._NetDetectDescription = params.get("NetDetectDescription")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNetDetectResponse(AbstractModel):
    """CreateNetDetect response structure.

    """

    def __init__(self):
        r"""
        :param _NetDetect: The network detection (NetDetect) object.
        :type NetDetect: :class:`tencentcloud.vpc.v20170312.models.NetDetect`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NetDetect = None
        self._RequestId = None

    @property
    def NetDetect(self):
        return self._NetDetect

    @NetDetect.setter
    def NetDetect(self, NetDetect):
        self._NetDetect = NetDetect

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetDetect") is not None:
            self._NetDetect = NetDetect()
            self._NetDetect._deserialize(params.get("NetDetect"))
        self._RequestId = params.get("RequestId")


class CreateNetworkAclQuintupleEntriesRequest(AbstractModel):
    """CreateNetworkAclQuintupleEntries request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkAclId: Network ACL instance ID, such as `acl-12345678`.
        :type NetworkAclId: str
        :param _NetworkAclQuintupleSet: Network ACL quintuple rule set.
        :type NetworkAclQuintupleSet: :class:`tencentcloud.vpc.v20170312.models.NetworkAclQuintupleEntries`
        """
        self._NetworkAclId = None
        self._NetworkAclQuintupleSet = None

    @property
    def NetworkAclId(self):
        return self._NetworkAclId

    @NetworkAclId.setter
    def NetworkAclId(self, NetworkAclId):
        self._NetworkAclId = NetworkAclId

    @property
    def NetworkAclQuintupleSet(self):
        return self._NetworkAclQuintupleSet

    @NetworkAclQuintupleSet.setter
    def NetworkAclQuintupleSet(self, NetworkAclQuintupleSet):
        self._NetworkAclQuintupleSet = NetworkAclQuintupleSet


    def _deserialize(self, params):
        self._NetworkAclId = params.get("NetworkAclId")
        if params.get("NetworkAclQuintupleSet") is not None:
            self._NetworkAclQuintupleSet = NetworkAclQuintupleEntries()
            self._NetworkAclQuintupleSet._deserialize(params.get("NetworkAclQuintupleSet"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNetworkAclQuintupleEntriesResponse(AbstractModel):
    """CreateNetworkAclQuintupleEntries response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateNetworkAclRequest(AbstractModel):
    """CreateNetworkAcl request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC instance ID, which can be obtained from the `VpcId` field in the response of the [`DescribeVpcs`](https://intl.cloud.tencent.com/document/product/215/15778?from_cn_redirect=1) API.
        :type VpcId: str
        :param _NetworkAclName: Network ACL name, which can contain up to 60 bytes.
        :type NetworkAclName: str
        :param _NetworkAclType: Network ACL type. Valid values: `TRIPLE` and `QUINTUPLE`.
        :type NetworkAclType: str
        :param _Tags: Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :type Tags: list of Tag
        """
        self._VpcId = None
        self._NetworkAclName = None
        self._NetworkAclType = None
        self._Tags = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def NetworkAclName(self):
        return self._NetworkAclName

    @NetworkAclName.setter
    def NetworkAclName(self, NetworkAclName):
        self._NetworkAclName = NetworkAclName

    @property
    def NetworkAclType(self):
        return self._NetworkAclType

    @NetworkAclType.setter
    def NetworkAclType(self, NetworkAclType):
        self._NetworkAclType = NetworkAclType

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._NetworkAclName = params.get("NetworkAclName")
        self._NetworkAclType = params.get("NetworkAclType")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNetworkAclResponse(AbstractModel):
    """CreateNetworkAcl response structure.

    """

    def __init__(self):
        r"""
        :param _NetworkAcl: Network ACL instance
        :type NetworkAcl: :class:`tencentcloud.vpc.v20170312.models.NetworkAcl`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NetworkAcl = None
        self._RequestId = None

    @property
    def NetworkAcl(self):
        return self._NetworkAcl

    @NetworkAcl.setter
    def NetworkAcl(self, NetworkAcl):
        self._NetworkAcl = NetworkAcl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetworkAcl") is not None:
            self._NetworkAcl = NetworkAcl()
            self._NetworkAcl._deserialize(params.get("NetworkAcl"))
        self._RequestId = params.get("RequestId")


class CreateNetworkInterfaceRequest(AbstractModel):
    """CreateNetworkInterface request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: The ID of the VPC instance. You can obtain the parameter value from the VpcId field in the returned result of DescribeVpcs API.
        :type VpcId: str
        :param _NetworkInterfaceName: The name of the ENI. The maximum length is 60 characters.
        :type NetworkInterfaceName: str
        :param _SubnetId: The subnet instance ID of the ENI, such as `subnet-0ap8nwca`.
        :type SubnetId: str
        :param _NetworkInterfaceDescription: ENI description can be named freely, but the maximum length is 60 characters.
        :type NetworkInterfaceDescription: str
        :param _SecondaryPrivateIpAddressCount: The number of private IP addresses you apply for. The total number of private IP addresses cannot exceed the quota.
        :type SecondaryPrivateIpAddressCount: int
        :param _QosLevel: IP u200dservice level. It is used together with `SecondaryPrivateIpAddressCount`. Values: `PT` u200d(Gold), `AU` u200d(Silver), `AG` (Bronze) and `DEFAULT` (Default).
        :type QosLevel: str
        :param _SecurityGroupIds: Specifies the security group to be bound with, such as ['sg-1dd51d'].
        :type SecurityGroupIds: list of str
        :param _PrivateIpAddresses: The information of the specified private IPs. You can specify a maximum of 10 each time.
        :type PrivateIpAddresses: list of PrivateIpAddressSpecification
        :param _Tags: Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :type Tags: list of Tag
        :param _TrunkingFlag: Configuration of the ENI trunking mode. Valid values: `Enable` and `Disable`. Default value: `Disable`.
        :type TrunkingFlag: str
        """
        self._VpcId = None
        self._NetworkInterfaceName = None
        self._SubnetId = None
        self._NetworkInterfaceDescription = None
        self._SecondaryPrivateIpAddressCount = None
        self._QosLevel = None
        self._SecurityGroupIds = None
        self._PrivateIpAddresses = None
        self._Tags = None
        self._TrunkingFlag = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def NetworkInterfaceName(self):
        return self._NetworkInterfaceName

    @NetworkInterfaceName.setter
    def NetworkInterfaceName(self, NetworkInterfaceName):
        self._NetworkInterfaceName = NetworkInterfaceName

    @property
    def SubnetId(self):
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def NetworkInterfaceDescription(self):
        return self._NetworkInterfaceDescription

    @NetworkInterfaceDescription.setter
    def NetworkInterfaceDescription(self, NetworkInterfaceDescription):
        self._NetworkInterfaceDescription = NetworkInterfaceDescription

    @property
    def SecondaryPrivateIpAddressCount(self):
        return self._SecondaryPrivateIpAddressCount

    @SecondaryPrivateIpAddressCount.setter
    def SecondaryPrivateIpAddressCount(self, SecondaryPrivateIpAddressCount):
        self._SecondaryPrivateIpAddressCount = SecondaryPrivateIpAddressCount

    @property
    def QosLevel(self):
        return self._QosLevel

    @QosLevel.setter
    def QosLevel(self, QosLevel):
        self._QosLevel = QosLevel

    @property
    def SecurityGroupIds(self):
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def PrivateIpAddresses(self):
        return self._PrivateIpAddresses

    @PrivateIpAddresses.setter
    def PrivateIpAddresses(self, PrivateIpAddresses):
        self._PrivateIpAddresses = PrivateIpAddresses

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def TrunkingFlag(self):
        return self._TrunkingFlag

    @TrunkingFlag.setter
    def TrunkingFlag(self, TrunkingFlag):
        self._TrunkingFlag = TrunkingFlag


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._NetworkInterfaceName = params.get("NetworkInterfaceName")
        self._SubnetId = params.get("SubnetId")
        self._NetworkInterfaceDescription = params.get("NetworkInterfaceDescription")
        self._SecondaryPrivateIpAddressCount = params.get("SecondaryPrivateIpAddressCount")
        self._QosLevel = params.get("QosLevel")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        if params.get("PrivateIpAddresses") is not None:
            self._PrivateIpAddresses = []
            for item in params.get("PrivateIpAddresses"):
                obj = PrivateIpAddressSpecification()
                obj._deserialize(item)
                self._PrivateIpAddresses.append(obj)
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._TrunkingFlag = params.get("TrunkingFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNetworkInterfaceResponse(AbstractModel):
    """CreateNetworkInterface response structure.

    """

    def __init__(self):
        r"""
        :param _NetworkInterface: ENI instance.
        :type NetworkInterface: :class:`tencentcloud.vpc.v20170312.models.NetworkInterface`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NetworkInterface = None
        self._RequestId = None

    @property
    def NetworkInterface(self):
        return self._NetworkInterface

    @NetworkInterface.setter
    def NetworkInterface(self, NetworkInterface):
        self._NetworkInterface = NetworkInterface

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetworkInterface") is not None:
            self._NetworkInterface = NetworkInterface()
            self._NetworkInterface._deserialize(params.get("NetworkInterface"))
        self._RequestId = params.get("RequestId")


class CreateRouteTableRequest(AbstractModel):
    """CreateRouteTable request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: The ID of the VPC instance to be operated on. You can obtain the parameter value from the VpcId field in the returned result of DescribeVpcs API.
        :type VpcId: str
        :param _RouteTableName: The route table name. The maximum length is 60 characters.
        :type RouteTableName: str
        :param _Tags: Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :type Tags: list of Tag
        """
        self._VpcId = None
        self._RouteTableName = None
        self._Tags = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def RouteTableName(self):
        return self._RouteTableName

    @RouteTableName.setter
    def RouteTableName(self, RouteTableName):
        self._RouteTableName = RouteTableName

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._RouteTableName = params.get("RouteTableName")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRouteTableResponse(AbstractModel):
    """CreateRouteTable response structure.

    """

    def __init__(self):
        r"""
        :param _RouteTable: Route table object.
        :type RouteTable: :class:`tencentcloud.vpc.v20170312.models.RouteTable`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RouteTable = None
        self._RequestId = None

    @property
    def RouteTable(self):
        return self._RouteTable

    @RouteTable.setter
    def RouteTable(self, RouteTable):
        self._RouteTable = RouteTable

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RouteTable") is not None:
            self._RouteTable = RouteTable()
            self._RouteTable._deserialize(params.get("RouteTable"))
        self._RequestId = params.get("RequestId")


class CreateRoutesRequest(AbstractModel):
    """CreateRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _RouteTableId: Route table instance ID.
        :type RouteTableId: str
        :param _Routes: Routing policy object.
        :type Routes: list of Route
        """
        self._RouteTableId = None
        self._Routes = None

    @property
    def RouteTableId(self):
        return self._RouteTableId

    @RouteTableId.setter
    def RouteTableId(self, RouteTableId):
        self._RouteTableId = RouteTableId

    @property
    def Routes(self):
        return self._Routes

    @Routes.setter
    def Routes(self, Routes):
        self._Routes = Routes


    def _deserialize(self, params):
        self._RouteTableId = params.get("RouteTableId")
        if params.get("Routes") is not None:
            self._Routes = []
            for item in params.get("Routes"):
                obj = Route()
                obj._deserialize(item)
                self._Routes.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRoutesResponse(AbstractModel):
    """CreateRoutes response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of newly added instances.
        :type TotalCount: int
        :param _RouteTableSet: Route table object.
        :type RouteTableSet: list of RouteTable
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._RouteTableSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RouteTableSet(self):
        return self._RouteTableSet

    @RouteTableSet.setter
    def RouteTableSet(self, RouteTableSet):
        self._RouteTableSet = RouteTableSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RouteTableSet") is not None:
            self._RouteTableSet = []
            for item in params.get("RouteTableSet"):
                obj = RouteTable()
                obj._deserialize(item)
                self._RouteTableSet.append(obj)
        self._RequestId = params.get("RequestId")


class CreateSecurityGroupPoliciesRequest(AbstractModel):
    """CreateSecurityGroupPolicies request structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroupId: The security group instance ID, such as `sg-33ocnj9n`. This can be obtained through DescribeSecurityGroups.
        :type SecurityGroupId: str
        :param _SecurityGroupPolicySet: Security group policy set.
        :type SecurityGroupPolicySet: :class:`tencentcloud.vpc.v20170312.models.SecurityGroupPolicySet`
        """
        self._SecurityGroupId = None
        self._SecurityGroupPolicySet = None

    @property
    def SecurityGroupId(self):
        return self._SecurityGroupId

    @SecurityGroupId.setter
    def SecurityGroupId(self, SecurityGroupId):
        self._SecurityGroupId = SecurityGroupId

    @property
    def SecurityGroupPolicySet(self):
        return self._SecurityGroupPolicySet

    @SecurityGroupPolicySet.setter
    def SecurityGroupPolicySet(self, SecurityGroupPolicySet):
        self._SecurityGroupPolicySet = SecurityGroupPolicySet


    def _deserialize(self, params):
        self._SecurityGroupId = params.get("SecurityGroupId")
        if params.get("SecurityGroupPolicySet") is not None:
            self._SecurityGroupPolicySet = SecurityGroupPolicySet()
            self._SecurityGroupPolicySet._deserialize(params.get("SecurityGroupPolicySet"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSecurityGroupPoliciesResponse(AbstractModel):
    """CreateSecurityGroupPolicies response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateSecurityGroupRequest(AbstractModel):
    """CreateSecurityGroup request structure.

    """

    def __init__(self):
        r"""
        :param _GroupName: Security group can be named freely, but cannot exceed 60 characters.
        :type GroupName: str
        :param _GroupDescription: The remarks for the security group. The maximum length is 100 characters.
        :type GroupDescription: str
        :param _ProjectId: Project ID. The default is 0. You can query it on the project management page of the Qcloud console.
        :type ProjectId: str
        :param _Tags: Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :type Tags: list of Tag
        """
        self._GroupName = None
        self._GroupDescription = None
        self._ProjectId = None
        self._Tags = None

    @property
    def GroupName(self):
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def GroupDescription(self):
        return self._GroupDescription

    @GroupDescription.setter
    def GroupDescription(self, GroupDescription):
        self._GroupDescription = GroupDescription

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._GroupName = params.get("GroupName")
        self._GroupDescription = params.get("GroupDescription")
        self._ProjectId = params.get("ProjectId")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSecurityGroupResponse(AbstractModel):
    """CreateSecurityGroup response structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroup: Security group object.
        :type SecurityGroup: :class:`tencentcloud.vpc.v20170312.models.SecurityGroup`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SecurityGroup = None
        self._RequestId = None

    @property
    def SecurityGroup(self):
        return self._SecurityGroup

    @SecurityGroup.setter
    def SecurityGroup(self, SecurityGroup):
        self._SecurityGroup = SecurityGroup

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SecurityGroup") is not None:
            self._SecurityGroup = SecurityGroup()
            self._SecurityGroup._deserialize(params.get("SecurityGroup"))
        self._RequestId = params.get("RequestId")


class CreateSecurityGroupWithPoliciesRequest(AbstractModel):
    """CreateSecurityGroupWithPolicies request structure.

    """

    def __init__(self):
        r"""
        :param _GroupName: Security group can be named freely, but cannot exceed 60 characters.
        :type GroupName: str
        :param _GroupDescription: The remarks for the security group. The maximum length is 100 characters.
        :type GroupDescription: str
        :param _ProjectId: Project ID. Default value: 0. You can query it on the <a href="https://console.cloud.tencent.com/project">project management page</a> of the Tencent Cloud console.
        :type ProjectId: str
        :param _SecurityGroupPolicySet: Security group policy set.
        :type SecurityGroupPolicySet: :class:`tencentcloud.vpc.v20170312.models.SecurityGroupPolicySet`
        """
        self._GroupName = None
        self._GroupDescription = None
        self._ProjectId = None
        self._SecurityGroupPolicySet = None

    @property
    def GroupName(self):
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def GroupDescription(self):
        return self._GroupDescription

    @GroupDescription.setter
    def GroupDescription(self, GroupDescription):
        self._GroupDescription = GroupDescription

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def SecurityGroupPolicySet(self):
        return self._SecurityGroupPolicySet

    @SecurityGroupPolicySet.setter
    def SecurityGroupPolicySet(self, SecurityGroupPolicySet):
        self._SecurityGroupPolicySet = SecurityGroupPolicySet


    def _deserialize(self, params):
        self._GroupName = params.get("GroupName")
        self._GroupDescription = params.get("GroupDescription")
        self._ProjectId = params.get("ProjectId")
        if params.get("SecurityGroupPolicySet") is not None:
            self._SecurityGroupPolicySet = SecurityGroupPolicySet()
            self._SecurityGroupPolicySet._deserialize(params.get("SecurityGroupPolicySet"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSecurityGroupWithPoliciesResponse(AbstractModel):
    """CreateSecurityGroupWithPolicies response structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroup: Security group object.
        :type SecurityGroup: :class:`tencentcloud.vpc.v20170312.models.SecurityGroup`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SecurityGroup = None
        self._RequestId = None

    @property
    def SecurityGroup(self):
        return self._SecurityGroup

    @SecurityGroup.setter
    def SecurityGroup(self, SecurityGroup):
        self._SecurityGroup = SecurityGroup

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SecurityGroup") is not None:
            self._SecurityGroup = SecurityGroup()
            self._SecurityGroup._deserialize(params.get("SecurityGroup"))
        self._RequestId = params.get("RequestId")


class CreateServiceTemplateGroupRequest(AbstractModel):
    """CreateServiceTemplateGroup request structure.

    """

    def __init__(self):
        r"""
        :param _ServiceTemplateGroupName: Group name of the protocol port template.
        :type ServiceTemplateGroupName: str
        :param _ServiceTemplateIds: Instance ID of the protocol port template, such as `ppm-4dw6agho`.
        :type ServiceTemplateIds: list of str
        """
        self._ServiceTemplateGroupName = None
        self._ServiceTemplateIds = None

    @property
    def ServiceTemplateGroupName(self):
        return self._ServiceTemplateGroupName

    @ServiceTemplateGroupName.setter
    def ServiceTemplateGroupName(self, ServiceTemplateGroupName):
        self._ServiceTemplateGroupName = ServiceTemplateGroupName

    @property
    def ServiceTemplateIds(self):
        return self._ServiceTemplateIds

    @ServiceTemplateIds.setter
    def ServiceTemplateIds(self, ServiceTemplateIds):
        self._ServiceTemplateIds = ServiceTemplateIds


    def _deserialize(self, params):
        self._ServiceTemplateGroupName = params.get("ServiceTemplateGroupName")
        self._ServiceTemplateIds = params.get("ServiceTemplateIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateServiceTemplateGroupResponse(AbstractModel):
    """CreateServiceTemplateGroup response structure.

    """

    def __init__(self):
        r"""
        :param _ServiceTemplateGroup: Group object of the protocol port template.
        :type ServiceTemplateGroup: :class:`tencentcloud.vpc.v20170312.models.ServiceTemplateGroup`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ServiceTemplateGroup = None
        self._RequestId = None

    @property
    def ServiceTemplateGroup(self):
        return self._ServiceTemplateGroup

    @ServiceTemplateGroup.setter
    def ServiceTemplateGroup(self, ServiceTemplateGroup):
        self._ServiceTemplateGroup = ServiceTemplateGroup

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ServiceTemplateGroup") is not None:
            self._ServiceTemplateGroup = ServiceTemplateGroup()
            self._ServiceTemplateGroup._deserialize(params.get("ServiceTemplateGroup"))
        self._RequestId = params.get("RequestId")


class CreateServiceTemplateRequest(AbstractModel):
    """CreateServiceTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _ServiceTemplateName: Template name of the protocol port
        :type ServiceTemplateName: str
        :param _Services: Supported ports inlcude single port, multiple ports, consecutive ports and all ports. Supported protocols include TCP, UDP, ICMP and GRE. Either Services or ServicesExtra is required.
        :type Services: list of str
        :param _ServicesExtra: You can add remarks. Supported ports include single port, multiple ports, consecutive ports and all ports. Supported protocols include TCP, UDP, ICMP and GRE. Either Services or ServicesExtra is required.
        :type ServicesExtra: list of ServicesInfo
        """
        self._ServiceTemplateName = None
        self._Services = None
        self._ServicesExtra = None

    @property
    def ServiceTemplateName(self):
        return self._ServiceTemplateName

    @ServiceTemplateName.setter
    def ServiceTemplateName(self, ServiceTemplateName):
        self._ServiceTemplateName = ServiceTemplateName

    @property
    def Services(self):
        return self._Services

    @Services.setter
    def Services(self, Services):
        self._Services = Services

    @property
    def ServicesExtra(self):
        return self._ServicesExtra

    @ServicesExtra.setter
    def ServicesExtra(self, ServicesExtra):
        self._ServicesExtra = ServicesExtra


    def _deserialize(self, params):
        self._ServiceTemplateName = params.get("ServiceTemplateName")
        self._Services = params.get("Services")
        if params.get("ServicesExtra") is not None:
            self._ServicesExtra = []
            for item in params.get("ServicesExtra"):
                obj = ServicesInfo()
                obj._deserialize(item)
                self._ServicesExtra.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateServiceTemplateResponse(AbstractModel):
    """CreateServiceTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _ServiceTemplate: Protocol port template object.
        :type ServiceTemplate: :class:`tencentcloud.vpc.v20170312.models.ServiceTemplate`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ServiceTemplate = None
        self._RequestId = None

    @property
    def ServiceTemplate(self):
        return self._ServiceTemplate

    @ServiceTemplate.setter
    def ServiceTemplate(self, ServiceTemplate):
        self._ServiceTemplate = ServiceTemplate

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ServiceTemplate") is not None:
            self._ServiceTemplate = ServiceTemplate()
            self._ServiceTemplate._deserialize(params.get("ServiceTemplate"))
        self._RequestId = params.get("RequestId")


class CreateSnapshotPoliciesRequest(AbstractModel):
    """CreateSnapshotPolicies request structure.

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicies: Details of a snapshot policy
        :type SnapshotPolicies: list of SnapshotPolicy
        """
        self._SnapshotPolicies = None

    @property
    def SnapshotPolicies(self):
        return self._SnapshotPolicies

    @SnapshotPolicies.setter
    def SnapshotPolicies(self, SnapshotPolicies):
        self._SnapshotPolicies = SnapshotPolicies


    def _deserialize(self, params):
        if params.get("SnapshotPolicies") is not None:
            self._SnapshotPolicies = []
            for item in params.get("SnapshotPolicies"):
                obj = SnapshotPolicy()
                obj._deserialize(item)
                self._SnapshotPolicies.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSnapshotPoliciesResponse(AbstractModel):
    """CreateSnapshotPolicies response structure.

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicies: Snapshot policies
        :type SnapshotPolicies: list of SnapshotPolicy
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SnapshotPolicies = None
        self._RequestId = None

    @property
    def SnapshotPolicies(self):
        return self._SnapshotPolicies

    @SnapshotPolicies.setter
    def SnapshotPolicies(self, SnapshotPolicies):
        self._SnapshotPolicies = SnapshotPolicies

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SnapshotPolicies") is not None:
            self._SnapshotPolicies = []
            for item in params.get("SnapshotPolicies"):
                obj = SnapshotPolicy()
                obj._deserialize(item)
                self._SnapshotPolicies.append(obj)
        self._RequestId = params.get("RequestId")


class CreateSubnetRequest(AbstractModel):
    """CreateSubnet request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: The ID of the VPC instance to be operated on. You can obtain the parameter value from the VpcId field in the returned result of DescribeVpcs API.
        :type VpcId: str
        :param _SubnetName: The subnet name. The maximum length is 60 bytes.
        :type SubnetName: str
        :param _CidrBlock: The subnet IP address range. It must be within the VPC IP address range. Subnet IP address ranges cannot overlap with each other within the same VPC.
        :type CidrBlock: str
        :param _Zone: The ID of the availability zone in which the subnet resides. You can set up disaster recovery across availability zones by choosing different availability zones for different subnets.
        :type Zone: str
        :param _Tags: Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :type Tags: list of Tag
        :param _CdcId: CDC instance ID
        :type CdcId: str
        """
        self._VpcId = None
        self._SubnetName = None
        self._CidrBlock = None
        self._Zone = None
        self._Tags = None
        self._CdcId = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetName(self):
        return self._SubnetName

    @SubnetName.setter
    def SubnetName(self, SubnetName):
        self._SubnetName = SubnetName

    @property
    def CidrBlock(self):
        return self._CidrBlock

    @CidrBlock.setter
    def CidrBlock(self, CidrBlock):
        self._CidrBlock = CidrBlock

    @property
    def Zone(self):
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def CdcId(self):
        return self._CdcId

    @CdcId.setter
    def CdcId(self, CdcId):
        self._CdcId = CdcId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._SubnetName = params.get("SubnetName")
        self._CidrBlock = params.get("CidrBlock")
        self._Zone = params.get("Zone")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._CdcId = params.get("CdcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSubnetResponse(AbstractModel):
    """CreateSubnet response structure.

    """

    def __init__(self):
        r"""
        :param _Subnet: Subnet object.
        :type Subnet: :class:`tencentcloud.vpc.v20170312.models.Subnet`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Subnet = None
        self._RequestId = None

    @property
    def Subnet(self):
        return self._Subnet

    @Subnet.setter
    def Subnet(self, Subnet):
        self._Subnet = Subnet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Subnet") is not None:
            self._Subnet = Subnet()
            self._Subnet._deserialize(params.get("Subnet"))
        self._RequestId = params.get("RequestId")


class CreateSubnetsRequest(AbstractModel):
    """CreateSubnets request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: The `ID` of the `VPC` instance, such as `vpc-6v2ht8q5`.
        :type VpcId: str
        :param _Subnets: The subnet object list.
        :type Subnets: list of SubnetInput
        :param _Tags: Bound tags. Note that the collection of tags here is shared by all subnet objects in the list. You cannot specify tags for each subnet. Example: [{"Key": "city", "Value": "shanghai"}].
        :type Tags: list of Tag
        :param _CdcId: ID of the CDC instance to which the subnets will be created
        :type CdcId: str
        """
        self._VpcId = None
        self._Subnets = None
        self._Tags = None
        self._CdcId = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def Subnets(self):
        return self._Subnets

    @Subnets.setter
    def Subnets(self, Subnets):
        self._Subnets = Subnets

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def CdcId(self):
        return self._CdcId

    @CdcId.setter
    def CdcId(self, CdcId):
        self._CdcId = CdcId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        if params.get("Subnets") is not None:
            self._Subnets = []
            for item in params.get("Subnets"):
                obj = SubnetInput()
                obj._deserialize(item)
                self._Subnets.append(obj)
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._CdcId = params.get("CdcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSubnetsResponse(AbstractModel):
    """CreateSubnets response structure.

    """

    def __init__(self):
        r"""
        :param _SubnetSet: The list of newly created subnets.
        :type SubnetSet: list of Subnet
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SubnetSet = None
        self._RequestId = None

    @property
    def SubnetSet(self):
        return self._SubnetSet

    @SubnetSet.setter
    def SubnetSet(self, SubnetSet):
        self._SubnetSet = SubnetSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SubnetSet") is not None:
            self._SubnetSet = []
            for item in params.get("SubnetSet"):
                obj = Subnet()
                obj._deserialize(item)
                self._SubnetSet.append(obj)
        self._RequestId = params.get("RequestId")


class CreateVpcEndPointRequest(AbstractModel):
    """CreateVpcEndPoint request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC instance ID
        :type VpcId: str
        :param _SubnetId: Subnet instance ID
        :type SubnetId: str
        :param _EndPointName: Endpoint name
        :type EndPointName: str
        :param _EndPointServiceId: Endpoint service ID
        :type EndPointServiceId: str
        :param _EndPointVip: Endpoint VIP. You can apply for a specified IP.
        :type EndPointVip: str
        :param _SecurityGroupId: Security group ID
        :type SecurityGroupId: str
        """
        self._VpcId = None
        self._SubnetId = None
        self._EndPointName = None
        self._EndPointServiceId = None
        self._EndPointVip = None
        self._SecurityGroupId = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def EndPointName(self):
        return self._EndPointName

    @EndPointName.setter
    def EndPointName(self, EndPointName):
        self._EndPointName = EndPointName

    @property
    def EndPointServiceId(self):
        return self._EndPointServiceId

    @EndPointServiceId.setter
    def EndPointServiceId(self, EndPointServiceId):
        self._EndPointServiceId = EndPointServiceId

    @property
    def EndPointVip(self):
        return self._EndPointVip

    @EndPointVip.setter
    def EndPointVip(self, EndPointVip):
        self._EndPointVip = EndPointVip

    @property
    def SecurityGroupId(self):
        return self._SecurityGroupId

    @SecurityGroupId.setter
    def SecurityGroupId(self, SecurityGroupId):
        self._SecurityGroupId = SecurityGroupId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._EndPointName = params.get("EndPointName")
        self._EndPointServiceId = params.get("EndPointServiceId")
        self._EndPointVip = params.get("EndPointVip")
        self._SecurityGroupId = params.get("SecurityGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVpcEndPointResponse(AbstractModel):
    """CreateVpcEndPoint response structure.

    """

    def __init__(self):
        r"""
        :param _EndPoint: Endpoint details
        :type EndPoint: :class:`tencentcloud.vpc.v20170312.models.EndPoint`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._EndPoint = None
        self._RequestId = None

    @property
    def EndPoint(self):
        return self._EndPoint

    @EndPoint.setter
    def EndPoint(self, EndPoint):
        self._EndPoint = EndPoint

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EndPoint") is not None:
            self._EndPoint = EndPoint()
            self._EndPoint._deserialize(params.get("EndPoint"))
        self._RequestId = params.get("RequestId")


class CreateVpcEndPointServiceRequest(AbstractModel):
    """CreateVpcEndPointService request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC instance ID
        :type VpcId: str
        :param _EndPointServiceName: Endpoint service name
        :type EndPointServiceName: str
        :param _AutoAcceptFlag: Whether to automatically accept
        :type AutoAcceptFlag: bool
        :param _ServiceInstanceId: Real server ID, such as `lb-xxx`.
        :type ServiceInstanceId: str
        :param _IsPassService: (Disused) Whether it’s a PaaS service
        :type IsPassService: bool
        :param _ServiceType: Mounted PaaS service type. Values: `CLB` (default), `CDB`, `CRS`
        :type ServiceType: str
        """
        self._VpcId = None
        self._EndPointServiceName = None
        self._AutoAcceptFlag = None
        self._ServiceInstanceId = None
        self._IsPassService = None
        self._ServiceType = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def EndPointServiceName(self):
        return self._EndPointServiceName

    @EndPointServiceName.setter
    def EndPointServiceName(self, EndPointServiceName):
        self._EndPointServiceName = EndPointServiceName

    @property
    def AutoAcceptFlag(self):
        return self._AutoAcceptFlag

    @AutoAcceptFlag.setter
    def AutoAcceptFlag(self, AutoAcceptFlag):
        self._AutoAcceptFlag = AutoAcceptFlag

    @property
    def ServiceInstanceId(self):
        return self._ServiceInstanceId

    @ServiceInstanceId.setter
    def ServiceInstanceId(self, ServiceInstanceId):
        self._ServiceInstanceId = ServiceInstanceId

    @property
    def IsPassService(self):
        return self._IsPassService

    @IsPassService.setter
    def IsPassService(self, IsPassService):
        self._IsPassService = IsPassService

    @property
    def ServiceType(self):
        return self._ServiceType

    @ServiceType.setter
    def ServiceType(self, ServiceType):
        self._ServiceType = ServiceType


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._EndPointServiceName = params.get("EndPointServiceName")
        self._AutoAcceptFlag = params.get("AutoAcceptFlag")
        self._ServiceInstanceId = params.get("ServiceInstanceId")
        self._IsPassService = params.get("IsPassService")
        self._ServiceType = params.get("ServiceType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVpcEndPointServiceResponse(AbstractModel):
    """CreateVpcEndPointService response structure.

    """

    def __init__(self):
        r"""
        :param _EndPointService: Endpoint service details
        :type EndPointService: :class:`tencentcloud.vpc.v20170312.models.EndPointService`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._EndPointService = None
        self._RequestId = None

    @property
    def EndPointService(self):
        return self._EndPointService

    @EndPointService.setter
    def EndPointService(self, EndPointService):
        self._EndPointService = EndPointService

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EndPointService") is not None:
            self._EndPointService = EndPointService()
            self._EndPointService._deserialize(params.get("EndPointService"))
        self._RequestId = params.get("RequestId")


class CreateVpcEndPointServiceWhiteListRequest(AbstractModel):
    """CreateVpcEndPointServiceWhiteList request structure.

    """

    def __init__(self):
        r"""
        :param _UserUin: UIN
        :type UserUin: str
        :param _EndPointServiceId: Endpoint service ID
        :type EndPointServiceId: str
        :param _Description: Allowlist description
        :type Description: str
        """
        self._UserUin = None
        self._EndPointServiceId = None
        self._Description = None

    @property
    def UserUin(self):
        return self._UserUin

    @UserUin.setter
    def UserUin(self, UserUin):
        self._UserUin = UserUin

    @property
    def EndPointServiceId(self):
        return self._EndPointServiceId

    @EndPointServiceId.setter
    def EndPointServiceId(self, EndPointServiceId):
        self._EndPointServiceId = EndPointServiceId

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._UserUin = params.get("UserUin")
        self._EndPointServiceId = params.get("EndPointServiceId")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVpcEndPointServiceWhiteListResponse(AbstractModel):
    """CreateVpcEndPointServiceWhiteList response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateVpcRequest(AbstractModel):
    """CreateVpc request structure.

    """

    def __init__(self):
        r"""
        :param _VpcName: The VPC name. The maximum length is 60 bytes.
        :type VpcName: str
        :param _CidrBlock: VPC CIDR block, which must fall within the following three private network IP ranges: 10.0.0.0/12, 172.16.0.0/12, and 192.168.0.0/16.
        :type CidrBlock: str
        :param _EnableMulticast: Whether multicast is enabled. `true`: Enabled. `false`: Not enabled.
        :type EnableMulticast: str
        :param _DnsServers: DNS address. A maximum of 4 addresses is supported.
        :type DnsServers: list of str
        :param _DomainName: Domain name of DHCP
        :type DomainName: str
        :param _Tags: Bound tags, such as [{"Key": "city", "Value": "shanghai"}]
        :type Tags: list of Tag
        """
        self._VpcName = None
        self._CidrBlock = None
        self._EnableMulticast = None
        self._DnsServers = None
        self._DomainName = None
        self._Tags = None

    @property
    def VpcName(self):
        return self._VpcName

    @VpcName.setter
    def VpcName(self, VpcName):
        self._VpcName = VpcName

    @property
    def CidrBlock(self):
        return self._CidrBlock

    @CidrBlock.setter
    def CidrBlock(self, CidrBlock):
        self._CidrBlock = CidrBlock

    @property
    def EnableMulticast(self):
        return self._EnableMulticast

    @EnableMulticast.setter
    def EnableMulticast(self, EnableMulticast):
        self._EnableMulticast = EnableMulticast

    @property
    def DnsServers(self):
        return self._DnsServers

    @DnsServers.setter
    def DnsServers(self, DnsServers):
        self._DnsServers = DnsServers

    @property
    def DomainName(self):
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._VpcName = params.get("VpcName")
        self._CidrBlock = params.get("CidrBlock")
        self._EnableMulticast = params.get("EnableMulticast")
        self._DnsServers = params.get("DnsServers")
        self._DomainName = params.get("DomainName")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVpcResponse(AbstractModel):
    """CreateVpc response structure.

    """

    def __init__(self):
        r"""
        :param _Vpc: The VPC object.
        :type Vpc: :class:`tencentcloud.vpc.v20170312.models.Vpc`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Vpc = None
        self._RequestId = None

    @property
    def Vpc(self):
        return self._Vpc

    @Vpc.setter
    def Vpc(self, Vpc):
        self._Vpc = Vpc

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Vpc") is not None:
            self._Vpc = Vpc()
            self._Vpc._deserialize(params.get("Vpc"))
        self._RequestId = params.get("RequestId")


class CreateVpnConnectionRequest(AbstractModel):
    """CreateVpnConnection request structure.

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: The ID of the VPN gateway instance.
        :type VpnGatewayId: str
        :param _CustomerGatewayId: The ID of the customer gateway, such as `cgw-2wqq41m9`. You can query the customer gateway by using the [DescribeCustomerGateways](https://intl.cloud.tencent.com/document/product/215/17516?from_cn_redirect=1) API.
        :type CustomerGatewayId: str
        :param _VpnConnectionName: Gateway can be named freely, but the maximum length is 60 characters.
        :type VpnConnectionName: str
        :param _PreShareKey: The pre-shared key.
        :type PreShareKey: str
        :param _VpcId: VPC instance ID, which can be obtained from the `VpcId` field in the response of the [`DescribeVpcs`](https://intl.cloud.tencent.com/document/product/215/15778?from_cn_redirect=1) API.
This parameter is optional for a CCN-based VPN tunnel.
        :type VpcId: str
        :param _SecurityPolicyDatabases: The SPD policy group, for example: {"10.0.0.5/24":["172.123.10.5/16"]}. 10.0.0.5/24 is the VPC internal IP range, and 172.123.10.5/16 is the IDC IP range. The user specifies the IP range in the VPC that can communicate with the IP range in the IDC.
        :type SecurityPolicyDatabases: list of SecurityPolicyDatabase
        :param _IKEOptionsSpecification: Internet Key Exchange (IKE) configuration. IKE has a self-protection mechanism. The network security protocol is configured by the user.
        :type IKEOptionsSpecification: :class:`tencentcloud.vpc.v20170312.models.IKEOptionsSpecification`
        :param _IPSECOptionsSpecification: IPSec configuration. The IPSec secure session configuration is provided by Tencent Cloud.
        :type IPSECOptionsSpecification: :class:`tencentcloud.vpc.v20170312.models.IPSECOptionsSpecification`
        :param _Tags: Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :type Tags: list of Tag
        :param _EnableHealthCheck: Whether the tunnel health check is supported. The default value is `False`.
        :type EnableHealthCheck: bool
        :param _HealthCheckLocalIp: Local IP of health check. It defaults to a random IP within 169.254.128.0/17.
        :type HealthCheckLocalIp: str
        :param _HealthCheckRemoteIp: Peer IP of health check. It defaults to a random IP within 169.254.128.0/17.
        :type HealthCheckRemoteIp: str
        :param _RouteType: Tunnel type. Valid values: `STATIC`, `StaticRoute`, and `Policy`.
        :type RouteType: str
        :param _NegotiationType: Negotiation type. Valid values: `active` (default value), `passive` and `flowTrigger`.
        :type NegotiationType: str
        :param _DpdEnable: Specifies whether to enable DPD. Valid values: `0` (disable) and `1` (enable)
        :type DpdEnable: int
        :param _DpdTimeout: DPD timeout period. Default: 30; unit: second. If the request is not responded within this period, the peer end is considered not exists. This parameter is valid when the value of `DpdEnable` is 1. 
        :type DpdTimeout: str
        :param _DpdAction: The action after DPD timeout. Valid values: `clear` (disconnect) and `restart` (try again). It’s valid when `DpdEnable` is `1`. 
        :type DpdAction: str
        """
        self._VpnGatewayId = None
        self._CustomerGatewayId = None
        self._VpnConnectionName = None
        self._PreShareKey = None
        self._VpcId = None
        self._SecurityPolicyDatabases = None
        self._IKEOptionsSpecification = None
        self._IPSECOptionsSpecification = None
        self._Tags = None
        self._EnableHealthCheck = None
        self._HealthCheckLocalIp = None
        self._HealthCheckRemoteIp = None
        self._RouteType = None
        self._NegotiationType = None
        self._DpdEnable = None
        self._DpdTimeout = None
        self._DpdAction = None

    @property
    def VpnGatewayId(self):
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId

    @property
    def CustomerGatewayId(self):
        return self._CustomerGatewayId

    @CustomerGatewayId.setter
    def CustomerGatewayId(self, CustomerGatewayId):
        self._CustomerGatewayId = CustomerGatewayId

    @property
    def VpnConnectionName(self):
        return self._VpnConnectionName

    @VpnConnectionName.setter
    def VpnConnectionName(self, VpnConnectionName):
        self._VpnConnectionName = VpnConnectionName

    @property
    def PreShareKey(self):
        return self._PreShareKey

    @PreShareKey.setter
    def PreShareKey(self, PreShareKey):
        self._PreShareKey = PreShareKey

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SecurityPolicyDatabases(self):
        return self._SecurityPolicyDatabases

    @SecurityPolicyDatabases.setter
    def SecurityPolicyDatabases(self, SecurityPolicyDatabases):
        self._SecurityPolicyDatabases = SecurityPolicyDatabases

    @property
    def IKEOptionsSpecification(self):
        return self._IKEOptionsSpecification

    @IKEOptionsSpecification.setter
    def IKEOptionsSpecification(self, IKEOptionsSpecification):
        self._IKEOptionsSpecification = IKEOptionsSpecification

    @property
    def IPSECOptionsSpecification(self):
        return self._IPSECOptionsSpecification

    @IPSECOptionsSpecification.setter
    def IPSECOptionsSpecification(self, IPSECOptionsSpecification):
        self._IPSECOptionsSpecification = IPSECOptionsSpecification

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def EnableHealthCheck(self):
        return self._EnableHealthCheck

    @EnableHealthCheck.setter
    def EnableHealthCheck(self, EnableHealthCheck):
        self._EnableHealthCheck = EnableHealthCheck

    @property
    def HealthCheckLocalIp(self):
        return self._HealthCheckLocalIp

    @HealthCheckLocalIp.setter
    def HealthCheckLocalIp(self, HealthCheckLocalIp):
        self._HealthCheckLocalIp = HealthCheckLocalIp

    @property
    def HealthCheckRemoteIp(self):
        return self._HealthCheckRemoteIp

    @HealthCheckRemoteIp.setter
    def HealthCheckRemoteIp(self, HealthCheckRemoteIp):
        self._HealthCheckRemoteIp = HealthCheckRemoteIp

    @property
    def RouteType(self):
        return self._RouteType

    @RouteType.setter
    def RouteType(self, RouteType):
        self._RouteType = RouteType

    @property
    def NegotiationType(self):
        return self._NegotiationType

    @NegotiationType.setter
    def NegotiationType(self, NegotiationType):
        self._NegotiationType = NegotiationType

    @property
    def DpdEnable(self):
        return self._DpdEnable

    @DpdEnable.setter
    def DpdEnable(self, DpdEnable):
        self._DpdEnable = DpdEnable

    @property
    def DpdTimeout(self):
        return self._DpdTimeout

    @DpdTimeout.setter
    def DpdTimeout(self, DpdTimeout):
        self._DpdTimeout = DpdTimeout

    @property
    def DpdAction(self):
        return self._DpdAction

    @DpdAction.setter
    def DpdAction(self, DpdAction):
        self._DpdAction = DpdAction


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        self._CustomerGatewayId = params.get("CustomerGatewayId")
        self._VpnConnectionName = params.get("VpnConnectionName")
        self._PreShareKey = params.get("PreShareKey")
        self._VpcId = params.get("VpcId")
        if params.get("SecurityPolicyDatabases") is not None:
            self._SecurityPolicyDatabases = []
            for item in params.get("SecurityPolicyDatabases"):
                obj = SecurityPolicyDatabase()
                obj._deserialize(item)
                self._SecurityPolicyDatabases.append(obj)
        if params.get("IKEOptionsSpecification") is not None:
            self._IKEOptionsSpecification = IKEOptionsSpecification()
            self._IKEOptionsSpecification._deserialize(params.get("IKEOptionsSpecification"))
        if params.get("IPSECOptionsSpecification") is not None:
            self._IPSECOptionsSpecification = IPSECOptionsSpecification()
            self._IPSECOptionsSpecification._deserialize(params.get("IPSECOptionsSpecification"))
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._EnableHealthCheck = params.get("EnableHealthCheck")
        self._HealthCheckLocalIp = params.get("HealthCheckLocalIp")
        self._HealthCheckRemoteIp = params.get("HealthCheckRemoteIp")
        self._RouteType = params.get("RouteType")
        self._NegotiationType = params.get("NegotiationType")
        self._DpdEnable = params.get("DpdEnable")
        self._DpdTimeout = params.get("DpdTimeout")
        self._DpdAction = params.get("DpdAction")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVpnConnectionResponse(AbstractModel):
    """CreateVpnConnection response structure.

    """

    def __init__(self):
        r"""
        :param _VpnConnection: Tunnel instance object.
        :type VpnConnection: :class:`tencentcloud.vpc.v20170312.models.VpnConnection`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._VpnConnection = None
        self._RequestId = None

    @property
    def VpnConnection(self):
        return self._VpnConnection

    @VpnConnection.setter
    def VpnConnection(self, VpnConnection):
        self._VpnConnection = VpnConnection

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("VpnConnection") is not None:
            self._VpnConnection = VpnConnection()
            self._VpnConnection._deserialize(params.get("VpnConnection"))
        self._RequestId = params.get("RequestId")


class CreateVpnGatewayRequest(AbstractModel):
    """CreateVpnGateway request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC instance ID, which can be obtained from the `VpcId` field in the response of the [`DescribeVpcs`](https://intl.cloud.tencent.com/document/product/215/15778?from_cn_redirect=1) API.
        :type VpcId: str
        :param _VpnGatewayName: The VPN gateway name. The maximum length is 60 bytes.
        :type VpnGatewayName: str
        :param _InternetMaxBandwidthOut: The public network bandwidth configuration. Available bandwidth specifications: 5, 10, 20, 50, and 100. Unit: Mbps
        :type InternetMaxBandwidthOut: int
        :param _InstanceChargeType: The VPN gateway billing mode. PREPAID: prepaid means monthly subscription. POSTPAID_BY_HOUR: postpaid means pay-as-you-go. Default: POSTPAID_BY_HOUR. If prepaid mode is specified, the `InstanceChargePrepaid` parameter must be entered.
        :type InstanceChargeType: str
        :param _InstanceChargePrepaid: Parameter settings for prepaid billing mode, also known as monthly subscription. This parameter can specify the purchase period and other attributes such as auto-renewal. This parameter is mandatory for prepaid instances.
        :type InstanceChargePrepaid: :class:`tencentcloud.vpc.v20170312.models.InstanceChargePrepaid`
        :param _Zone: The availability zone, such as `ap-guangzhou-2`.
        :type Zone: str
        :param _Type: VPN gateway type. Values: `CCN` (CCN VPN gateway), `SSL` (SSL VPN gateway)
        :type Type: str
        :param _Tags: Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :type Tags: list of Tag
        :param _CdcId: CDC instance ID
        :type CdcId: str
        :param _MaxConnection: Maximum number of connected clients allowed for the SSL VPN gateway. Valid values: [5, 10, 20, 50, 100]. This parameter is only required for SSL VPN gateways.
        :type MaxConnection: int
        """
        self._VpcId = None
        self._VpnGatewayName = None
        self._InternetMaxBandwidthOut = None
        self._InstanceChargeType = None
        self._InstanceChargePrepaid = None
        self._Zone = None
        self._Type = None
        self._Tags = None
        self._CdcId = None
        self._MaxConnection = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def VpnGatewayName(self):
        return self._VpnGatewayName

    @VpnGatewayName.setter
    def VpnGatewayName(self, VpnGatewayName):
        self._VpnGatewayName = VpnGatewayName

    @property
    def InternetMaxBandwidthOut(self):
        return self._InternetMaxBandwidthOut

    @InternetMaxBandwidthOut.setter
    def InternetMaxBandwidthOut(self, InternetMaxBandwidthOut):
        self._InternetMaxBandwidthOut = InternetMaxBandwidthOut

    @property
    def InstanceChargeType(self):
        return self._InstanceChargeType

    @InstanceChargeType.setter
    def InstanceChargeType(self, InstanceChargeType):
        self._InstanceChargeType = InstanceChargeType

    @property
    def InstanceChargePrepaid(self):
        return self._InstanceChargePrepaid

    @InstanceChargePrepaid.setter
    def InstanceChargePrepaid(self, InstanceChargePrepaid):
        self._InstanceChargePrepaid = InstanceChargePrepaid

    @property
    def Zone(self):
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def CdcId(self):
        return self._CdcId

    @CdcId.setter
    def CdcId(self, CdcId):
        self._CdcId = CdcId

    @property
    def MaxConnection(self):
        return self._MaxConnection

    @MaxConnection.setter
    def MaxConnection(self, MaxConnection):
        self._MaxConnection = MaxConnection


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._VpnGatewayName = params.get("VpnGatewayName")
        self._InternetMaxBandwidthOut = params.get("InternetMaxBandwidthOut")
        self._InstanceChargeType = params.get("InstanceChargeType")
        if params.get("InstanceChargePrepaid") is not None:
            self._InstanceChargePrepaid = InstanceChargePrepaid()
            self._InstanceChargePrepaid._deserialize(params.get("InstanceChargePrepaid"))
        self._Zone = params.get("Zone")
        self._Type = params.get("Type")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._CdcId = params.get("CdcId")
        self._MaxConnection = params.get("MaxConnection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVpnGatewayResponse(AbstractModel):
    """CreateVpnGateway response structure.

    """

    def __init__(self):
        r"""
        :param _VpnGateway: VPN gateway object.
        :type VpnGateway: :class:`tencentcloud.vpc.v20170312.models.VpnGateway`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._VpnGateway = None
        self._RequestId = None

    @property
    def VpnGateway(self):
        return self._VpnGateway

    @VpnGateway.setter
    def VpnGateway(self, VpnGateway):
        self._VpnGateway = VpnGateway

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("VpnGateway") is not None:
            self._VpnGateway = VpnGateway()
            self._VpnGateway._deserialize(params.get("VpnGateway"))
        self._RequestId = params.get("RequestId")


class CreateVpnGatewayRoutesRequest(AbstractModel):
    """CreateVpnGatewayRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: VPN gateway ID
        :type VpnGatewayId: str
        :param _Routes: Destination route list of a VPN gateway
        :type Routes: list of VpnGatewayRoute
        """
        self._VpnGatewayId = None
        self._Routes = None

    @property
    def VpnGatewayId(self):
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId

    @property
    def Routes(self):
        return self._Routes

    @Routes.setter
    def Routes(self, Routes):
        self._Routes = Routes


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        if params.get("Routes") is not None:
            self._Routes = []
            for item in params.get("Routes"):
                obj = VpnGatewayRoute()
                obj._deserialize(item)
                self._Routes.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVpnGatewayRoutesResponse(AbstractModel):
    """CreateVpnGatewayRoutes response structure.

    """

    def __init__(self):
        r"""
        :param _Routes: Destination routes of a VPN gateway
        :type Routes: list of VpnGatewayRoute
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Routes = None
        self._RequestId = None

    @property
    def Routes(self):
        return self._Routes

    @Routes.setter
    def Routes(self, Routes):
        self._Routes = Routes

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Routes") is not None:
            self._Routes = []
            for item in params.get("Routes"):
                obj = VpnGatewayRoute()
                obj._deserialize(item)
                self._Routes.append(obj)
        self._RequestId = params.get("RequestId")


class CrossBorderCompliance(AbstractModel):
    """Compliance review request

    """

    def __init__(self):
        r"""
        :param _ServiceProvider: Service provider. Valid values: `UNICOM`.
        :type ServiceProvider: str
        :param _ComplianceId: ID of compliance review request.
        :type ComplianceId: int
        :param _Company: Full company name.
        :type Company: str
        :param _UniformSocialCreditCode: Unified Social Credit Code.
        :type UniformSocialCreditCode: str
        :param _LegalPerson: Legal person.
        :type LegalPerson: str
        :param _IssuingAuthority: Issuing authority.
        :type IssuingAuthority: str
        :param _BusinessLicense: Business license.
        :type BusinessLicense: str
        :param _BusinessAddress: Business address.
        :type BusinessAddress: str
        :param _PostCode: Zip code.
        :type PostCode: int
        :param _Manager: Operator.
        :type Manager: str
        :param _ManagerId: Operator ID card number.
        :type ManagerId: str
        :param _ManagerIdCard: Operator ID card.
        :type ManagerIdCard: str
        :param _ManagerAddress: Operator address.
        :type ManagerAddress: str
        :param _ManagerTelephone: Operator phone number.
        :type ManagerTelephone: str
        :param _Email: Email.
        :type Email: str
        :param _ServiceHandlingForm: Service handling form.
        :type ServiceHandlingForm: str
        :param _AuthorizationLetter: Authorization letter.
        :type AuthorizationLetter: str
        :param _SafetyCommitment: Information security commitment.
        :type SafetyCommitment: str
        :param _ServiceStartDate: Service start date.
        :type ServiceStartDate: str
        :param _ServiceEndDate: Service end date.
        :type ServiceEndDate: str
        :param _State: Status. Valid values: `PENDING`, `APPROVED`, and `DENY`.
        :type State: str
        :param _CreatedTime: Creation time of the review form.
        :type CreatedTime: str
        """
        self._ServiceProvider = None
        self._ComplianceId = None
        self._Company = None
        self._UniformSocialCreditCode = None
        self._LegalPerson = None
        self._IssuingAuthority = None
        self._BusinessLicense = None
        self._BusinessAddress = None
        self._PostCode = None
        self._Manager = None
        self._ManagerId = None
        self._ManagerIdCard = None
        self._ManagerAddress = None
        self._ManagerTelephone = None
        self._Email = None
        self._ServiceHandlingForm = None
        self._AuthorizationLetter = None
        self._SafetyCommitment = None
        self._ServiceStartDate = None
        self._ServiceEndDate = None
        self._State = None
        self._CreatedTime = None

    @property
    def ServiceProvider(self):
        return self._ServiceProvider

    @ServiceProvider.setter
    def ServiceProvider(self, ServiceProvider):
        self._ServiceProvider = ServiceProvider

    @property
    def ComplianceId(self):
        return self._ComplianceId

    @ComplianceId.setter
    def ComplianceId(self, ComplianceId):
        self._ComplianceId = ComplianceId

    @property
    def Company(self):
        return self._Company

    @Company.setter
    def Company(self, Company):
        self._Company = Company

    @property
    def UniformSocialCreditCode(self):
        return self._UniformSocialCreditCode

    @UniformSocialCreditCode.setter
    def UniformSocialCreditCode(self, UniformSocialCreditCode):
        self._UniformSocialCreditCode = UniformSocialCreditCode

    @property
    def LegalPerson(self):
        return self._LegalPerson

    @LegalPerson.setter
    def LegalPerson(self, LegalPerson):
        self._LegalPerson = LegalPerson

    @property
    def IssuingAuthority(self):
        return self._IssuingAuthority

    @IssuingAuthority.setter
    def IssuingAuthority(self, IssuingAuthority):
        self._IssuingAuthority = IssuingAuthority

    @property
    def BusinessLicense(self):
        return self._BusinessLicense

    @BusinessLicense.setter
    def BusinessLicense(self, BusinessLicense):
        self._BusinessLicense = BusinessLicense

    @property
    def BusinessAddress(self):
        return self._BusinessAddress

    @BusinessAddress.setter
    def BusinessAddress(self, BusinessAddress):
        self._BusinessAddress = BusinessAddress

    @property
    def PostCode(self):
        return self._PostCode

    @PostCode.setter
    def PostCode(self, PostCode):
        self._PostCode = PostCode

    @property
    def Manager(self):
        return self._Manager

    @Manager.setter
    def Manager(self, Manager):
        self._Manager = Manager

    @property
    def ManagerId(self):
        return self._ManagerId

    @ManagerId.setter
    def ManagerId(self, ManagerId):
        self._ManagerId = ManagerId

    @property
    def ManagerIdCard(self):
        return self._ManagerIdCard

    @ManagerIdCard.setter
    def ManagerIdCard(self, ManagerIdCard):
        self._ManagerIdCard = ManagerIdCard

    @property
    def ManagerAddress(self):
        return self._ManagerAddress

    @ManagerAddress.setter
    def ManagerAddress(self, ManagerAddress):
        self._ManagerAddress = ManagerAddress

    @property
    def ManagerTelephone(self):
        return self._ManagerTelephone

    @ManagerTelephone.setter
    def ManagerTelephone(self, ManagerTelephone):
        self._ManagerTelephone = ManagerTelephone

    @property
    def Email(self):
        return self._Email

    @Email.setter
    def Email(self, Email):
        self._Email = Email

    @property
    def ServiceHandlingForm(self):
        return self._ServiceHandlingForm

    @ServiceHandlingForm.setter
    def ServiceHandlingForm(self, ServiceHandlingForm):
        self._ServiceHandlingForm = ServiceHandlingForm

    @property
    def AuthorizationLetter(self):
        return self._AuthorizationLetter

    @AuthorizationLetter.setter
    def AuthorizationLetter(self, AuthorizationLetter):
        self._AuthorizationLetter = AuthorizationLetter

    @property
    def SafetyCommitment(self):
        return self._SafetyCommitment

    @SafetyCommitment.setter
    def SafetyCommitment(self, SafetyCommitment):
        self._SafetyCommitment = SafetyCommitment

    @property
    def ServiceStartDate(self):
        return self._ServiceStartDate

    @ServiceStartDate.setter
    def ServiceStartDate(self, ServiceStartDate):
        self._ServiceStartDate = ServiceStartDate

    @property
    def ServiceEndDate(self):
        return self._ServiceEndDate

    @ServiceEndDate.setter
    def ServiceEndDate(self, ServiceEndDate):
        self._ServiceEndDate = ServiceEndDate

    @property
    def State(self):
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def CreatedTime(self):
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime


    def _deserialize(self, params):
        self._ServiceProvider = params.get("ServiceProvider")
        self._ComplianceId = params.get("ComplianceId")
        self._Company = params.get("Company")
        self._UniformSocialCreditCode = params.get("UniformSocialCreditCode")
        self._LegalPerson = params.get("LegalPerson")
        self._IssuingAuthority = params.get("IssuingAuthority")
        self._BusinessLicense = params.get("BusinessLicense")
        self._BusinessAddress = params.get("BusinessAddress")
        self._PostCode = params.get("PostCode")
        self._Manager = params.get("Manager")
        self._ManagerId = params.get("ManagerId")
        self._ManagerIdCard = params.get("ManagerIdCard")
        self._ManagerAddress = params.get("ManagerAddress")
        self._ManagerTelephone = params.get("ManagerTelephone")
        self._Email = params.get("Email")
        self._ServiceHandlingForm = params.get("ServiceHandlingForm")
        self._AuthorizationLetter = params.get("AuthorizationLetter")
        self._SafetyCommitment = params.get("SafetyCommitment")
        self._ServiceStartDate = params.get("ServiceStartDate")
        self._ServiceEndDate = params.get("ServiceEndDate")
        self._State = params.get("State")
        self._CreatedTime = params.get("CreatedTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CustomerGateway(AbstractModel):
    """Customer Gateway

    """

    def __init__(self):
        r"""
        :param _CustomerGatewayId: The unique ID of the customer gateway
        :type CustomerGatewayId: str
        :param _CustomerGatewayName: Gateway Name
        :type CustomerGatewayName: str
        :param _IpAddress: Public network address
        :type IpAddress: str
        :param _CreatedTime: The creation time.
        :type CreatedTime: str
        """
        self._CustomerGatewayId = None
        self._CustomerGatewayName = None
        self._IpAddress = None
        self._CreatedTime = None

    @property
    def CustomerGatewayId(self):
        return self._CustomerGatewayId

    @CustomerGatewayId.setter
    def CustomerGatewayId(self, CustomerGatewayId):
        self._CustomerGatewayId = CustomerGatewayId

    @property
    def CustomerGatewayName(self):
        return self._CustomerGatewayName

    @CustomerGatewayName.setter
    def CustomerGatewayName(self, CustomerGatewayName):
        self._CustomerGatewayName = CustomerGatewayName

    @property
    def IpAddress(self):
        return self._IpAddress

    @IpAddress.setter
    def IpAddress(self, IpAddress):
        self._IpAddress = IpAddress

    @property
    def CreatedTime(self):
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime


    def _deserialize(self, params):
        self._CustomerGatewayId = params.get("CustomerGatewayId")
        self._CustomerGatewayName = params.get("CustomerGatewayName")
        self._IpAddress = params.get("IpAddress")
        self._CreatedTime = params.get("CreatedTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CustomerGatewayVendor(AbstractModel):
    """Customer gateway vendor information object.

    """

    def __init__(self):
        r"""
        :param _Platform: Platform.
        :type Platform: str
        :param _SoftwareVersion: Software version.
        :type SoftwareVersion: str
        :param _VendorName: Vendor name.
        :type VendorName: str
        """
        self._Platform = None
        self._SoftwareVersion = None
        self._VendorName = None

    @property
    def Platform(self):
        return self._Platform

    @Platform.setter
    def Platform(self, Platform):
        self._Platform = Platform

    @property
    def SoftwareVersion(self):
        return self._SoftwareVersion

    @SoftwareVersion.setter
    def SoftwareVersion(self, SoftwareVersion):
        self._SoftwareVersion = SoftwareVersion

    @property
    def VendorName(self):
        return self._VendorName

    @VendorName.setter
    def VendorName(self, VendorName):
        self._VendorName = VendorName


    def _deserialize(self, params):
        self._Platform = params.get("Platform")
        self._SoftwareVersion = params.get("SoftwareVersion")
        self._VendorName = params.get("VendorName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CvmInstance(AbstractModel):
    """A CVM instance.

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC instance ID.
        :type VpcId: str
        :param _SubnetId: Subnet instance ID.
        :type SubnetId: str
        :param _InstanceId: CVM instance ID.
        :type InstanceId: str
        :param _InstanceName: CVM Name
        :type InstanceName: str
        :param _InstanceState: CVM status.
        :type InstanceState: str
        :param _CPU: Number of CPU cores in an instance (in core).
        :type CPU: int
        :param _Memory: Instance’s memory capacity. Unit: GB.
        :type Memory: int
        :param _CreatedTime: The creation time.
        :type CreatedTime: str
        :param _InstanceType: Instance type.
        :type InstanceType: str
        :param _EniLimit: Instance ENI quota (including primary ENIs).
        :type EniLimit: int
        :param _EniIpLimit: Private IP quoata for instance ENIs (including primary ENIs).
        :type EniIpLimit: int
        :param _InstanceEniCount: The number of ENIs (including primary ENIs) bound to a instance.
        :type InstanceEniCount: int
        """
        self._VpcId = None
        self._SubnetId = None
        self._InstanceId = None
        self._InstanceName = None
        self._InstanceState = None
        self._CPU = None
        self._Memory = None
        self._CreatedTime = None
        self._InstanceType = None
        self._EniLimit = None
        self._EniIpLimit = None
        self._InstanceEniCount = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def InstanceState(self):
        return self._InstanceState

    @InstanceState.setter
    def InstanceState(self, InstanceState):
        self._InstanceState = InstanceState

    @property
    def CPU(self):
        return self._CPU

    @CPU.setter
    def CPU(self, CPU):
        self._CPU = CPU

    @property
    def Memory(self):
        return self._Memory

    @Memory.setter
    def Memory(self, Memory):
        self._Memory = Memory

    @property
    def CreatedTime(self):
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def InstanceType(self):
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def EniLimit(self):
        return self._EniLimit

    @EniLimit.setter
    def EniLimit(self, EniLimit):
        self._EniLimit = EniLimit

    @property
    def EniIpLimit(self):
        return self._EniIpLimit

    @EniIpLimit.setter
    def EniIpLimit(self, EniIpLimit):
        self._EniIpLimit = EniIpLimit

    @property
    def InstanceEniCount(self):
        return self._InstanceEniCount

    @InstanceEniCount.setter
    def InstanceEniCount(self, InstanceEniCount):
        self._InstanceEniCount = InstanceEniCount


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._InstanceState = params.get("InstanceState")
        self._CPU = params.get("CPU")
        self._Memory = params.get("Memory")
        self._CreatedTime = params.get("CreatedTime")
        self._InstanceType = params.get("InstanceType")
        self._EniLimit = params.get("EniLimit")
        self._EniIpLimit = params.get("EniIpLimit")
        self._InstanceEniCount = params.get("InstanceEniCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DefaultVpcSubnet(AbstractModel):
    """Default VPC and subnet

    """

    def __init__(self):
        r"""
        :param _VpcId: Default VPC ID
        :type VpcId: str
        :param _SubnetId: Default subnet ID
        :type SubnetId: str
        :param _VpcName: Default VPC name
        :type VpcName: str
        :param _SubnetName: Default subnet name
        :type SubnetName: str
        :param _CidrBlock: Default subnet IP range
        :type CidrBlock: str
        """
        self._VpcId = None
        self._SubnetId = None
        self._VpcName = None
        self._SubnetName = None
        self._CidrBlock = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def VpcName(self):
        return self._VpcName

    @VpcName.setter
    def VpcName(self, VpcName):
        self._VpcName = VpcName

    @property
    def SubnetName(self):
        return self._SubnetName

    @SubnetName.setter
    def SubnetName(self, SubnetName):
        self._SubnetName = SubnetName

    @property
    def CidrBlock(self):
        return self._CidrBlock

    @CidrBlock.setter
    def CidrBlock(self, CidrBlock):
        self._CidrBlock = CidrBlock


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._VpcName = params.get("VpcName")
        self._SubnetName = params.get("SubnetName")
        self._CidrBlock = params.get("CidrBlock")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAddressTemplateGroupRequest(AbstractModel):
    """DeleteAddressTemplateGroup request structure.

    """

    def __init__(self):
        r"""
        :param _AddressTemplateGroupId: The IP address template group instance ID, such as `ipmg-90cex8mq`.
        :type AddressTemplateGroupId: str
        """
        self._AddressTemplateGroupId = None

    @property
    def AddressTemplateGroupId(self):
        return self._AddressTemplateGroupId

    @AddressTemplateGroupId.setter
    def AddressTemplateGroupId(self, AddressTemplateGroupId):
        self._AddressTemplateGroupId = AddressTemplateGroupId


    def _deserialize(self, params):
        self._AddressTemplateGroupId = params.get("AddressTemplateGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAddressTemplateGroupResponse(AbstractModel):
    """DeleteAddressTemplateGroup response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAddressTemplateRequest(AbstractModel):
    """DeleteAddressTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _AddressTemplateId: The IP address template instance ID, such as `ipm-09o5m8kc`.
        :type AddressTemplateId: str
        """
        self._AddressTemplateId = None

    @property
    def AddressTemplateId(self):
        return self._AddressTemplateId

    @AddressTemplateId.setter
    def AddressTemplateId(self, AddressTemplateId):
        self._AddressTemplateId = AddressTemplateId


    def _deserialize(self, params):
        self._AddressTemplateId = params.get("AddressTemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAddressTemplateResponse(AbstractModel):
    """DeleteAddressTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAssistantCidrRequest(AbstractModel):
    """DeleteAssistantCidr request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: `VPC` instance `ID`, such as `vpc-6v2ht8q5`.
        :type VpcId: str
        :param _CidrBlocks: Array of CIDR blocks, such as ["10.0.0.0/16", "172.16.0.0/16"]
        :type CidrBlocks: list of str
        """
        self._VpcId = None
        self._CidrBlocks = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def CidrBlocks(self):
        return self._CidrBlocks

    @CidrBlocks.setter
    def CidrBlocks(self, CidrBlocks):
        self._CidrBlocks = CidrBlocks


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._CidrBlocks = params.get("CidrBlocks")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAssistantCidrResponse(AbstractModel):
    """DeleteAssistantCidr response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteBandwidthPackageRequest(AbstractModel):
    """DeleteBandwidthPackage request structure.

    """

    def __init__(self):
        r"""
        :param _BandwidthPackageId: The unique ID of the bandwidth package to be deleted.
        :type BandwidthPackageId: str
        """
        self._BandwidthPackageId = None

    @property
    def BandwidthPackageId(self):
        return self._BandwidthPackageId

    @BandwidthPackageId.setter
    def BandwidthPackageId(self, BandwidthPackageId):
        self._BandwidthPackageId = BandwidthPackageId


    def _deserialize(self, params):
        self._BandwidthPackageId = params.get("BandwidthPackageId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteBandwidthPackageResponse(AbstractModel):
    """DeleteBandwidthPackage response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteCcnRequest(AbstractModel):
    """DeleteCcn request structure.

    """

    def __init__(self):
        r"""
        :param _CcnId: The CCN instance ID, such as `ccn-f49l6u0z`.
        :type CcnId: str
        """
        self._CcnId = None

    @property
    def CcnId(self):
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCcnResponse(AbstractModel):
    """DeleteCcn response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteCustomerGatewayRequest(AbstractModel):
    """DeleteCustomerGateway request structure.

    """

    def __init__(self):
        r"""
        :param _CustomerGatewayId: The ID of the customer gateway, such as `cgw-2wqq41m9`. You can query the customer gateway by using the [DescribeCustomerGateways](https://intl.cloud.tencent.com/document/api/215/17516?from_cn_redirect=1) API.
        :type CustomerGatewayId: str
        """
        self._CustomerGatewayId = None

    @property
    def CustomerGatewayId(self):
        return self._CustomerGatewayId

    @CustomerGatewayId.setter
    def CustomerGatewayId(self, CustomerGatewayId):
        self._CustomerGatewayId = CustomerGatewayId


    def _deserialize(self, params):
        self._CustomerGatewayId = params.get("CustomerGatewayId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCustomerGatewayResponse(AbstractModel):
    """DeleteCustomerGateway response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteDirectConnectGatewayCcnRoutesRequest(AbstractModel):
    """DeleteDirectConnectGatewayCcnRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _DirectConnectGatewayId: The ID of the Direct Connect gateway, such as `dcg-prpqlmg1`
        :type DirectConnectGatewayId: str
        :param _RouteIds: The route ID, such as `ccnr-f49l6u0z`.
        :type RouteIds: list of str
        """
        self._DirectConnectGatewayId = None
        self._RouteIds = None

    @property
    def DirectConnectGatewayId(self):
        return self._DirectConnectGatewayId

    @DirectConnectGatewayId.setter
    def DirectConnectGatewayId(self, DirectConnectGatewayId):
        self._DirectConnectGatewayId = DirectConnectGatewayId

    @property
    def RouteIds(self):
        return self._RouteIds

    @RouteIds.setter
    def RouteIds(self, RouteIds):
        self._RouteIds = RouteIds


    def _deserialize(self, params):
        self._DirectConnectGatewayId = params.get("DirectConnectGatewayId")
        self._RouteIds = params.get("RouteIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteDirectConnectGatewayCcnRoutesResponse(AbstractModel):
    """DeleteDirectConnectGatewayCcnRoutes response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteDirectConnectGatewayRequest(AbstractModel):
    """DeleteDirectConnectGateway request structure.

    """

    def __init__(self):
        r"""
        :param _DirectConnectGatewayId: The unique `ID` of the direct connect gateway, such as `dcg-9o233uri`.
        :type DirectConnectGatewayId: str
        """
        self._DirectConnectGatewayId = None

    @property
    def DirectConnectGatewayId(self):
        return self._DirectConnectGatewayId

    @DirectConnectGatewayId.setter
    def DirectConnectGatewayId(self, DirectConnectGatewayId):
        self._DirectConnectGatewayId = DirectConnectGatewayId


    def _deserialize(self, params):
        self._DirectConnectGatewayId = params.get("DirectConnectGatewayId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteDirectConnectGatewayResponse(AbstractModel):
    """DeleteDirectConnectGateway response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteFlowLogRequest(AbstractModel):
    """DeleteFlowLog request structure.

    """

    def __init__(self):
        r"""
        :param _FlowLogId: The unique ID of the flow log.
        :type FlowLogId: str
        :param _VpcId: The VPC ID or unique ID of the resource. We recommend using the unique ID. This parameter is required unless a CCN flow log is deleted.
        :type VpcId: str
        """
        self._FlowLogId = None
        self._VpcId = None

    @property
    def FlowLogId(self):
        return self._FlowLogId

    @FlowLogId.setter
    def FlowLogId(self, FlowLogId):
        self._FlowLogId = FlowLogId

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId


    def _deserialize(self, params):
        self._FlowLogId = params.get("FlowLogId")
        self._VpcId = params.get("VpcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteFlowLogResponse(AbstractModel):
    """DeleteFlowLog response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteHaVipRequest(AbstractModel):
    """DeleteHaVip request structure.

    """

    def __init__(self):
        r"""
        :param _HaVipId: The unique `ID` of the `HAVIP`, such as `havip-9o233uri`.
        :type HaVipId: str
        """
        self._HaVipId = None

    @property
    def HaVipId(self):
        return self._HaVipId

    @HaVipId.setter
    def HaVipId(self, HaVipId):
        self._HaVipId = HaVipId


    def _deserialize(self, params):
        self._HaVipId = params.get("HaVipId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteHaVipResponse(AbstractModel):
    """DeleteHaVip response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLocalGatewayRequest(AbstractModel):
    """DeleteLocalGateway request structure.

    """

    def __init__(self):
        r"""
        :param _LocalGatewayId: Local gateway instance ID
        :type LocalGatewayId: str
        :param _CdcId: CDC instance ID
        :type CdcId: str
        :param _VpcId: VPC instance ID
        :type VpcId: str
        """
        self._LocalGatewayId = None
        self._CdcId = None
        self._VpcId = None

    @property
    def LocalGatewayId(self):
        return self._LocalGatewayId

    @LocalGatewayId.setter
    def LocalGatewayId(self, LocalGatewayId):
        self._LocalGatewayId = LocalGatewayId

    @property
    def CdcId(self):
        return self._CdcId

    @CdcId.setter
    def CdcId(self, CdcId):
        self._CdcId = CdcId

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId


    def _deserialize(self, params):
        self._LocalGatewayId = params.get("LocalGatewayId")
        self._CdcId = params.get("CdcId")
        self._VpcId = params.get("VpcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLocalGatewayResponse(AbstractModel):
    """DeleteLocalGateway response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteNatGatewayDestinationIpPortTranslationNatRuleRequest(AbstractModel):
    """DeleteNatGatewayDestinationIpPortTranslationNatRule request structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: The ID of the NAT gateway, such as `nat-df45454`.
        :type NatGatewayId: str
        :param _DestinationIpPortTranslationNatRules: The port forwarding rules of the NAT gateway.
        :type DestinationIpPortTranslationNatRules: list of DestinationIpPortTranslationNatRule
        """
        self._NatGatewayId = None
        self._DestinationIpPortTranslationNatRules = None

    @property
    def NatGatewayId(self):
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def DestinationIpPortTranslationNatRules(self):
        return self._DestinationIpPortTranslationNatRules

    @DestinationIpPortTranslationNatRules.setter
    def DestinationIpPortTranslationNatRules(self, DestinationIpPortTranslationNatRules):
        self._DestinationIpPortTranslationNatRules = DestinationIpPortTranslationNatRules


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        if params.get("DestinationIpPortTranslationNatRules") is not None:
            self._DestinationIpPortTranslationNatRules = []
            for item in params.get("DestinationIpPortTranslationNatRules"):
                obj = DestinationIpPortTranslationNatRule()
                obj._deserialize(item)
                self._DestinationIpPortTranslationNatRules.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNatGatewayDestinationIpPortTranslationNatRuleResponse(AbstractModel):
    """DeleteNatGatewayDestinationIpPortTranslationNatRule response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteNatGatewayRequest(AbstractModel):
    """DeleteNatGateway request structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: The ID of the NAT gateway, such as `nat-df45454`.
        :type NatGatewayId: str
        """
        self._NatGatewayId = None

    @property
    def NatGatewayId(self):
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNatGatewayResponse(AbstractModel):
    """DeleteNatGateway response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteNatGatewaySourceIpTranslationNatRuleRequest(AbstractModel):
    """DeleteNatGatewaySourceIpTranslationNatRule request structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: The ID of the NAT Gateway, such as `nat-df45454`
        :type NatGatewayId: str
        :param _NatGatewaySnatIds: The list of SNAT rule IDs of a NAT Gateway, such as `snat-df43254`
        :type NatGatewaySnatIds: list of str
        """
        self._NatGatewayId = None
        self._NatGatewaySnatIds = None

    @property
    def NatGatewayId(self):
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def NatGatewaySnatIds(self):
        return self._NatGatewaySnatIds

    @NatGatewaySnatIds.setter
    def NatGatewaySnatIds(self, NatGatewaySnatIds):
        self._NatGatewaySnatIds = NatGatewaySnatIds


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        self._NatGatewaySnatIds = params.get("NatGatewaySnatIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNatGatewaySourceIpTranslationNatRuleResponse(AbstractModel):
    """DeleteNatGatewaySourceIpTranslationNatRule response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteNetDetectRequest(AbstractModel):
    """DeleteNetDetect request structure.

    """

    def __init__(self):
        r"""
        :param _NetDetectId: ID of a network probe, such as `netd-12345678`.
        :type NetDetectId: str
        """
        self._NetDetectId = None

    @property
    def NetDetectId(self):
        return self._NetDetectId

    @NetDetectId.setter
    def NetDetectId(self, NetDetectId):
        self._NetDetectId = NetDetectId


    def _deserialize(self, params):
        self._NetDetectId = params.get("NetDetectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNetDetectResponse(AbstractModel):
    """DeleteNetDetect response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteNetworkAclQuintupleEntriesRequest(AbstractModel):
    """DeleteNetworkAclQuintupleEntries request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkAclId: Network ACL instance ID, such as `acl-12345678`.
        :type NetworkAclId: str
        :param _NetworkAclQuintupleSet: Network ACL quintuple rule set.
        :type NetworkAclQuintupleSet: :class:`tencentcloud.vpc.v20170312.models.NetworkAclQuintupleEntries`
        """
        self._NetworkAclId = None
        self._NetworkAclQuintupleSet = None

    @property
    def NetworkAclId(self):
        return self._NetworkAclId

    @NetworkAclId.setter
    def NetworkAclId(self, NetworkAclId):
        self._NetworkAclId = NetworkAclId

    @property
    def NetworkAclQuintupleSet(self):
        return self._NetworkAclQuintupleSet

    @NetworkAclQuintupleSet.setter
    def NetworkAclQuintupleSet(self, NetworkAclQuintupleSet):
        self._NetworkAclQuintupleSet = NetworkAclQuintupleSet


    def _deserialize(self, params):
        self._NetworkAclId = params.get("NetworkAclId")
        if params.get("NetworkAclQuintupleSet") is not None:
            self._NetworkAclQuintupleSet = NetworkAclQuintupleEntries()
            self._NetworkAclQuintupleSet._deserialize(params.get("NetworkAclQuintupleSet"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNetworkAclQuintupleEntriesResponse(AbstractModel):
    """DeleteNetworkAclQuintupleEntries response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteNetworkAclRequest(AbstractModel):
    """DeleteNetworkAcl request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkAclId: Network ACL instance ID, such as `acl-12345678`.
        :type NetworkAclId: str
        """
        self._NetworkAclId = None

    @property
    def NetworkAclId(self):
        return self._NetworkAclId

    @NetworkAclId.setter
    def NetworkAclId(self, NetworkAclId):
        self._NetworkAclId = NetworkAclId


    def _deserialize(self, params):
        self._NetworkAclId = params.get("NetworkAclId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNetworkAclResponse(AbstractModel):
    """DeleteNetworkAcl response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteNetworkInterfaceRequest(AbstractModel):
    """DeleteNetworkInterface request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkInterfaceId: The ID of the ENI instance, such as `eni-m6dyj72l`.
        :type NetworkInterfaceId: str
        """
        self._NetworkInterfaceId = None

    @property
    def NetworkInterfaceId(self):
        return self._NetworkInterfaceId

    @NetworkInterfaceId.setter
    def NetworkInterfaceId(self, NetworkInterfaceId):
        self._NetworkInterfaceId = NetworkInterfaceId


    def _deserialize(self, params):
        self._NetworkInterfaceId = params.get("NetworkInterfaceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNetworkInterfaceResponse(AbstractModel):
    """DeleteNetworkInterface response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRouteTableRequest(AbstractModel):
    """DeleteRouteTable request structure.

    """

    def __init__(self):
        r"""
        :param _RouteTableId: The route table instance ID, such as `rtb-azd4dt1c`.
        :type RouteTableId: str
        """
        self._RouteTableId = None

    @property
    def RouteTableId(self):
        return self._RouteTableId

    @RouteTableId.setter
    def RouteTableId(self, RouteTableId):
        self._RouteTableId = RouteTableId


    def _deserialize(self, params):
        self._RouteTableId = params.get("RouteTableId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRouteTableResponse(AbstractModel):
    """DeleteRouteTable response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRoutesRequest(AbstractModel):
    """DeleteRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _RouteTableId: Route table instance ID.
        :type RouteTableId: str
        :param _Routes: Routing policy object. Only the `RouteId` field is required when deleting a routing policy.
        :type Routes: list of Route
        """
        self._RouteTableId = None
        self._Routes = None

    @property
    def RouteTableId(self):
        return self._RouteTableId

    @RouteTableId.setter
    def RouteTableId(self, RouteTableId):
        self._RouteTableId = RouteTableId

    @property
    def Routes(self):
        return self._Routes

    @Routes.setter
    def Routes(self, Routes):
        self._Routes = Routes


    def _deserialize(self, params):
        self._RouteTableId = params.get("RouteTableId")
        if params.get("Routes") is not None:
            self._Routes = []
            for item in params.get("Routes"):
                obj = Route()
                obj._deserialize(item)
                self._Routes.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRoutesResponse(AbstractModel):
    """DeleteRoutes response structure.

    """

    def __init__(self):
        r"""
        :param _RouteSet: Details of the routing policy that has been deleted.
        :type RouteSet: list of Route
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RouteSet = None
        self._RequestId = None

    @property
    def RouteSet(self):
        return self._RouteSet

    @RouteSet.setter
    def RouteSet(self, RouteSet):
        self._RouteSet = RouteSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RouteSet") is not None:
            self._RouteSet = []
            for item in params.get("RouteSet"):
                obj = Route()
                obj._deserialize(item)
                self._RouteSet.append(obj)
        self._RequestId = params.get("RequestId")


class DeleteSecurityGroupPoliciesRequest(AbstractModel):
    """DeleteSecurityGroupPolicies request structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroupId: The security group instance ID, such as `sg-33ocnj9n`. This can be obtained through DescribeSecurityGroups.
        :type SecurityGroupId: str
        :param _SecurityGroupPolicySet: The policy set of the security group. One request can only delete one or more policies in one direction. Both PolicyIndex-matching deletion and security group policy-matching deletion methods are supported. Each request can use only one matching method.
        :type SecurityGroupPolicySet: :class:`tencentcloud.vpc.v20170312.models.SecurityGroupPolicySet`
        """
        self._SecurityGroupId = None
        self._SecurityGroupPolicySet = None

    @property
    def SecurityGroupId(self):
        return self._SecurityGroupId

    @SecurityGroupId.setter
    def SecurityGroupId(self, SecurityGroupId):
        self._SecurityGroupId = SecurityGroupId

    @property
    def SecurityGroupPolicySet(self):
        return self._SecurityGroupPolicySet

    @SecurityGroupPolicySet.setter
    def SecurityGroupPolicySet(self, SecurityGroupPolicySet):
        self._SecurityGroupPolicySet = SecurityGroupPolicySet


    def _deserialize(self, params):
        self._SecurityGroupId = params.get("SecurityGroupId")
        if params.get("SecurityGroupPolicySet") is not None:
            self._SecurityGroupPolicySet = SecurityGroupPolicySet()
            self._SecurityGroupPolicySet._deserialize(params.get("SecurityGroupPolicySet"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSecurityGroupPoliciesResponse(AbstractModel):
    """DeleteSecurityGroupPolicies response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSecurityGroupRequest(AbstractModel):
    """DeleteSecurityGroup request structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroupId: The security group instance ID, such as `sg-33ocnj9n`. This can be obtained through DescribeSecurityGroups.
        :type SecurityGroupId: str
        """
        self._SecurityGroupId = None

    @property
    def SecurityGroupId(self):
        return self._SecurityGroupId

    @SecurityGroupId.setter
    def SecurityGroupId(self, SecurityGroupId):
        self._SecurityGroupId = SecurityGroupId


    def _deserialize(self, params):
        self._SecurityGroupId = params.get("SecurityGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSecurityGroupResponse(AbstractModel):
    """DeleteSecurityGroup response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteServiceTemplateGroupRequest(AbstractModel):
    """DeleteServiceTemplateGroup request structure.

    """

    def __init__(self):
        r"""
        :param _ServiceTemplateGroupId: The protocol port template group instance ID, such as `ppmg-n17uxvve`.
        :type ServiceTemplateGroupId: str
        """
        self._ServiceTemplateGroupId = None

    @property
    def ServiceTemplateGroupId(self):
        return self._ServiceTemplateGroupId

    @ServiceTemplateGroupId.setter
    def ServiceTemplateGroupId(self, ServiceTemplateGroupId):
        self._ServiceTemplateGroupId = ServiceTemplateGroupId


    def _deserialize(self, params):
        self._ServiceTemplateGroupId = params.get("ServiceTemplateGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteServiceTemplateGroupResponse(AbstractModel):
    """DeleteServiceTemplateGroup response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteServiceTemplateRequest(AbstractModel):
    """DeleteServiceTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _ServiceTemplateId: Protocol port template instance ID, such as `ppm-e6dy460g`.
        :type ServiceTemplateId: str
        """
        self._ServiceTemplateId = None

    @property
    def ServiceTemplateId(self):
        return self._ServiceTemplateId

    @ServiceTemplateId.setter
    def ServiceTemplateId(self, ServiceTemplateId):
        self._ServiceTemplateId = ServiceTemplateId


    def _deserialize(self, params):
        self._ServiceTemplateId = params.get("ServiceTemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteServiceTemplateResponse(AbstractModel):
    """DeleteServiceTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSnapshotPoliciesRequest(AbstractModel):
    """DeleteSnapshotPolicies request structure.

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicyIds: Snapshot policy IDs
        :type SnapshotPolicyIds: list of str
        """
        self._SnapshotPolicyIds = None

    @property
    def SnapshotPolicyIds(self):
        return self._SnapshotPolicyIds

    @SnapshotPolicyIds.setter
    def SnapshotPolicyIds(self, SnapshotPolicyIds):
        self._SnapshotPolicyIds = SnapshotPolicyIds


    def _deserialize(self, params):
        self._SnapshotPolicyIds = params.get("SnapshotPolicyIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSnapshotPoliciesResponse(AbstractModel):
    """DeleteSnapshotPolicies response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSubnetRequest(AbstractModel):
    """DeleteSubnet request structure.

    """

    def __init__(self):
        r"""
        :param _SubnetId: The ID of the subnet instance. You can obtain the parameter value from the SubnetId field in the returned result of DescribeSubnets API.
        :type SubnetId: str
        """
        self._SubnetId = None

    @property
    def SubnetId(self):
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId


    def _deserialize(self, params):
        self._SubnetId = params.get("SubnetId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSubnetResponse(AbstractModel):
    """DeleteSubnet response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteTrafficPackagesRequest(AbstractModel):
    """DeleteTrafficPackages request structure.

    """

    def __init__(self):
        r"""
        :param _TrafficPackageIds: The unique ID array of traffic packages to delete
        :type TrafficPackageIds: list of str
        """
        self._TrafficPackageIds = None

    @property
    def TrafficPackageIds(self):
        return self._TrafficPackageIds

    @TrafficPackageIds.setter
    def TrafficPackageIds(self, TrafficPackageIds):
        self._TrafficPackageIds = TrafficPackageIds


    def _deserialize(self, params):
        self._TrafficPackageIds = params.get("TrafficPackageIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTrafficPackagesResponse(AbstractModel):
    """DeleteTrafficPackages response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteVpcEndPointRequest(AbstractModel):
    """DeleteVpcEndPoint request structure.

    """

    def __init__(self):
        r"""
        :param _EndPointId: Endpoint ID
        :type EndPointId: str
        """
        self._EndPointId = None

    @property
    def EndPointId(self):
        return self._EndPointId

    @EndPointId.setter
    def EndPointId(self, EndPointId):
        self._EndPointId = EndPointId


    def _deserialize(self, params):
        self._EndPointId = params.get("EndPointId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVpcEndPointResponse(AbstractModel):
    """DeleteVpcEndPoint response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteVpcEndPointServiceRequest(AbstractModel):
    """DeleteVpcEndPointService request structure.

    """

    def __init__(self):
        r"""
        :param _EndPointServiceId: Endpoint ID
        :type EndPointServiceId: str
        """
        self._EndPointServiceId = None

    @property
    def EndPointServiceId(self):
        return self._EndPointServiceId

    @EndPointServiceId.setter
    def EndPointServiceId(self, EndPointServiceId):
        self._EndPointServiceId = EndPointServiceId


    def _deserialize(self, params):
        self._EndPointServiceId = params.get("EndPointServiceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVpcEndPointServiceResponse(AbstractModel):
    """DeleteVpcEndPointService response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteVpcEndPointServiceWhiteListRequest(AbstractModel):
    """DeleteVpcEndPointServiceWhiteList request structure.

    """

    def __init__(self):
        r"""
        :param _UserUin: Array of user UINs
        :type UserUin: list of str
        :param _EndPointServiceId: Endpoint service ID
        :type EndPointServiceId: str
        """
        self._UserUin = None
        self._EndPointServiceId = None

    @property
    def UserUin(self):
        return self._UserUin

    @UserUin.setter
    def UserUin(self, UserUin):
        self._UserUin = UserUin

    @property
    def EndPointServiceId(self):
        return self._EndPointServiceId

    @EndPointServiceId.setter
    def EndPointServiceId(self, EndPointServiceId):
        self._EndPointServiceId = EndPointServiceId


    def _deserialize(self, params):
        self._UserUin = params.get("UserUin")
        self._EndPointServiceId = params.get("EndPointServiceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVpcEndPointServiceWhiteListResponse(AbstractModel):
    """DeleteVpcEndPointServiceWhiteList response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteVpcRequest(AbstractModel):
    """DeleteVpc request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: The ID of the VPC instance. You can obtain the parameter value from the VpcId field in the returned result of DescribeVpcs API.
        :type VpcId: str
        """
        self._VpcId = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVpcResponse(AbstractModel):
    """DeleteVpc response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteVpnConnectionRequest(AbstractModel):
    """DeleteVpnConnection request structure.

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: The ID of the VPN gateway instance.
        :type VpnGatewayId: str
        :param _VpnConnectionId: The ID of the VPN tunnel instance, such as `vpnx-f49l6u0z`.
        :type VpnConnectionId: str
        """
        self._VpnGatewayId = None
        self._VpnConnectionId = None

    @property
    def VpnGatewayId(self):
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId

    @property
    def VpnConnectionId(self):
        return self._VpnConnectionId

    @VpnConnectionId.setter
    def VpnConnectionId(self, VpnConnectionId):
        self._VpnConnectionId = VpnConnectionId


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        self._VpnConnectionId = params.get("VpnConnectionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVpnConnectionResponse(AbstractModel):
    """DeleteVpnConnection response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteVpnGatewayRequest(AbstractModel):
    """DeleteVpnGateway request structure.

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: The ID of the VPN gateway instance.
        :type VpnGatewayId: str
        """
        self._VpnGatewayId = None

    @property
    def VpnGatewayId(self):
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVpnGatewayResponse(AbstractModel):
    """DeleteVpnGateway response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteVpnGatewayRoutesRequest(AbstractModel):
    """DeleteVpnGatewayRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: Instance ID of the VPN gateway
        :type VpnGatewayId: str
        :param _RouteIds: List of route IDs
        :type RouteIds: list of str
        """
        self._VpnGatewayId = None
        self._RouteIds = None

    @property
    def VpnGatewayId(self):
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId

    @property
    def RouteIds(self):
        return self._RouteIds

    @RouteIds.setter
    def RouteIds(self, RouteIds):
        self._RouteIds = RouteIds


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        self._RouteIds = params.get("RouteIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVpnGatewayRoutesResponse(AbstractModel):
    """DeleteVpnGatewayRoutes response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeAccountAttributesRequest(AbstractModel):
    """DescribeAccountAttributes request structure.

    """


class DescribeAccountAttributesResponse(AbstractModel):
    """DescribeAccountAttributes response structure.

    """

    def __init__(self):
        r"""
        :param _AccountAttributeSet: User account attribute object
        :type AccountAttributeSet: list of AccountAttribute
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AccountAttributeSet = None
        self._RequestId = None

    @property
    def AccountAttributeSet(self):
        return self._AccountAttributeSet

    @AccountAttributeSet.setter
    def AccountAttributeSet(self, AccountAttributeSet):
        self._AccountAttributeSet = AccountAttributeSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AccountAttributeSet") is not None:
            self._AccountAttributeSet = []
            for item in params.get("AccountAttributeSet"):
                obj = AccountAttribute()
                obj._deserialize(item)
                self._AccountAttributeSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAddressQuotaRequest(AbstractModel):
    """DescribeAddressQuota request structure.

    """


class DescribeAddressQuotaResponse(AbstractModel):
    """DescribeAddressQuota response structure.

    """

    def __init__(self):
        r"""
        :param _QuotaSet: The quota information of EIPs in an account.
        :type QuotaSet: list of Quota
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._QuotaSet = None
        self._RequestId = None

    @property
    def QuotaSet(self):
        return self._QuotaSet

    @QuotaSet.setter
    def QuotaSet(self, QuotaSet):
        self._QuotaSet = QuotaSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("QuotaSet") is not None:
            self._QuotaSet = []
            for item in params.get("QuotaSet"):
                obj = Quota()
                obj._deserialize(item)
                self._QuotaSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAddressTemplateGroupsRequest(AbstractModel):
    """DescribeAddressTemplateGroups request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter conditions.
<li>address-template-group-name - String - (Filter condition) IP address template group name.</li>
<li>address-template-group-id - String - (Filter condition) IP address template group instance ID, such as `ipmg-mdunqeb6`.</li>
        :type Filters: list of Filter
        :param _Offset: Offset. The default value is 0.
        :type Offset: str
        :param _Limit: Number of values to be returned. The default value is 20. Maximum is 100.
        :type Limit: str
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAddressTemplateGroupsResponse(AbstractModel):
    """DescribeAddressTemplateGroups response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of instances meeting the filter condition.
        :type TotalCount: int
        :param _AddressTemplateGroupSet: IP address template.
        :type AddressTemplateGroupSet: list of AddressTemplateGroup
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._AddressTemplateGroupSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AddressTemplateGroupSet(self):
        return self._AddressTemplateGroupSet

    @AddressTemplateGroupSet.setter
    def AddressTemplateGroupSet(self, AddressTemplateGroupSet):
        self._AddressTemplateGroupSet = AddressTemplateGroupSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AddressTemplateGroupSet") is not None:
            self._AddressTemplateGroupSet = []
            for item in params.get("AddressTemplateGroupSet"):
                obj = AddressTemplateGroup()
                obj._deserialize(item)
                self._AddressTemplateGroupSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAddressTemplatesRequest(AbstractModel):
    """DescribeAddressTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filters
<li>address-template-name - IP address template name.</li>
<li>address-template-id - IP address template ID, such as `ipm-mdunqeb6`.</li>
<li>address-ip - IP address.</li>
        :type Filters: list of Filter
        :param _Offset: Offset. The default value is 0.
        :type Offset: str
        :param _Limit: Number of values to be returned. The default value is 20. Maximum is 100.
        :type Limit: str
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAddressTemplatesResponse(AbstractModel):
    """DescribeAddressTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of instances meeting the filter condition.
        :type TotalCount: int
        :param _AddressTemplateSet: IP address template.
        :type AddressTemplateSet: list of AddressTemplate
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._AddressTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AddressTemplateSet(self):
        return self._AddressTemplateSet

    @AddressTemplateSet.setter
    def AddressTemplateSet(self, AddressTemplateSet):
        self._AddressTemplateSet = AddressTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AddressTemplateSet") is not None:
            self._AddressTemplateSet = []
            for item in params.get("AddressTemplateSet"):
                obj = AddressTemplate()
                obj._deserialize(item)
                self._AddressTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAddressesRequest(AbstractModel):
    """DescribeAddresses request structure.

    """

    def __init__(self):
        r"""
        :param _AddressIds: The list of unique IDs of EIPs in the format of `eip-11112222`. `AddressIds` and `Filters.address-id` cannot be specified at the same time.
        :type AddressIds: list of str
        :param _Filters: Each request can have up to 10 `Filters` and 100 `Filter.Values`. Detailed filter conditions:
<li> address-id - String - Optional - Filter by unique EIP ID, such as `eip-11112222`.</li>
<li> address-name - String - Optional - Filter by EIP name. Fuzzy filtering is not supported.</li>
<li> address-ip - String - Optional - Filter by EIP address.</li>
<li> address-status - String - Optional - Filter by EIP status. Valid values: `CREATING`, `BINDING`, `BIND`, `UNBINDING`, `UNBIND`, `OFFLINING`, and `BIND_ENI`.</li>
<li> instance-id - String - Optional - Filter by the ID of the instance bound to the EIP, such as `ins-11112222`.</li>
<li> private-ip-address - String - Optional - Filter by the private IP address bound to the EIP.</li>
<li> network-interface-id - String - Optional - Filter by ID of the ENI bound to the EIP, such as `eni-11112222`.</li>
<li> is-arrears - String - Optional - Filter by the fact whether the EIP is overdue (TRUE: the EIP is overdue | FALSE: the billing status of the EIP is normal).</li>
<li> address-type - String - Optional - Filter by IP type. Valid values: `WanIP`, `EIP`, `AnycastEIP`, and `HighQualityEIP`. Default value: `EIP`.</li>
<li> address-isp - String - Optional - Filter by ISP type. Valid values: `BGP`, `CMCC`, `CUCC`, and `CTCC`.</li>
<li> dedicated-cluster-id - String - Optional - Filter by unique CDC ID, such as `cluster-11112222`.</li>
<li> tag-key - String - Optional - Filter by tag key.</li>
<li> tag-value - String - Optional - Filter by tag value.</li>
<li> tag:tag-key - String - Optional - Filter by tag key-value pair. Use a specific tag key to replace `tag-key`.</li>
        :type Filters: list of Filter
        :param _Offset: The Offset. The default value is 0. For more information about `Offset`, see the relevant section in the API documentation.
        :type Offset: int
        :param _Limit: Number of returned results. Default value: 20. Maximum value: 100. For more information on `Limit`, see the relevant section in the API documentation.
        :type Limit: int
        """
        self._AddressIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def AddressIds(self):
        return self._AddressIds

    @AddressIds.setter
    def AddressIds(self, AddressIds):
        self._AddressIds = AddressIds

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._AddressIds = params.get("AddressIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAddressesResponse(AbstractModel):
    """DescribeAddresses response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of EIPs meeting the condition.
        :type TotalCount: int
        :param _AddressSet: List of EIPs details.
        :type AddressSet: list of Address
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._AddressSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AddressSet(self):
        return self._AddressSet

    @AddressSet.setter
    def AddressSet(self, AddressSet):
        self._AddressSet = AddressSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AddressSet") is not None:
            self._AddressSet = []
            for item in params.get("AddressSet"):
                obj = Address()
                obj._deserialize(item)
                self._AddressSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssistantCidrRequest(AbstractModel):
    """DescribeAssistantCidr request structure.

    """

    def __init__(self):
        r"""
        :param _VpcIds: The ID of a VPC instance set, such as `vpc-6v2ht8q5`.
        :type VpcIds: list of str
        :param _Filters: Filter condition. `VpcIds` and `Filters` cannot be specified at the same time.
<li>vpc-id - String - (Filter condition) VPC instance ID, such as `vpc-f49l6u0z`.</li>
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned results. Default value: 20. Maximum value: 100.
        :type Limit: int
        """
        self._VpcIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def VpcIds(self):
        return self._VpcIds

    @VpcIds.setter
    def VpcIds(self, VpcIds):
        self._VpcIds = VpcIds

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._VpcIds = params.get("VpcIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssistantCidrResponse(AbstractModel):
    """DescribeAssistantCidr response structure.

    """

    def __init__(self):
        r"""
        :param _AssistantCidrSet: A set of eligible secondary CIDR blocks
Note: This field may return null, indicating that no valid value was found.
        :type AssistantCidrSet: list of AssistantCidr
        :param _TotalCount: Number of eligible instances.
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AssistantCidrSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def AssistantCidrSet(self):
        return self._AssistantCidrSet

    @AssistantCidrSet.setter
    def AssistantCidrSet(self, AssistantCidrSet):
        self._AssistantCidrSet = AssistantCidrSet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AssistantCidrSet") is not None:
            self._AssistantCidrSet = []
            for item in params.get("AssistantCidrSet"):
                obj = AssistantCidr()
                obj._deserialize(item)
                self._AssistantCidrSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeBandwidthPackageBillUsageRequest(AbstractModel):
    """DescribeBandwidthPackageBillUsage request structure.

    """

    def __init__(self):
        r"""
        :param _BandwidthPackageId: Unique ID of the pay-as-you-go bandwidth package.
        :type BandwidthPackageId: str
        """
        self._BandwidthPackageId = None

    @property
    def BandwidthPackageId(self):
        return self._BandwidthPackageId

    @BandwidthPackageId.setter
    def BandwidthPackageId(self, BandwidthPackageId):
        self._BandwidthPackageId = BandwidthPackageId


    def _deserialize(self, params):
        self._BandwidthPackageId = params.get("BandwidthPackageId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBandwidthPackageBillUsageResponse(AbstractModel):
    """DescribeBandwidthPackageBillUsage response structure.

    """

    def __init__(self):
        r"""
        :param _BandwidthPackageBillBandwidthSet: Current billable usage.
        :type BandwidthPackageBillBandwidthSet: list of BandwidthPackageBillBandwidth
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._BandwidthPackageBillBandwidthSet = None
        self._RequestId = None

    @property
    def BandwidthPackageBillBandwidthSet(self):
        return self._BandwidthPackageBillBandwidthSet

    @BandwidthPackageBillBandwidthSet.setter
    def BandwidthPackageBillBandwidthSet(self, BandwidthPackageBillBandwidthSet):
        self._BandwidthPackageBillBandwidthSet = BandwidthPackageBillBandwidthSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("BandwidthPackageBillBandwidthSet") is not None:
            self._BandwidthPackageBillBandwidthSet = []
            for item in params.get("BandwidthPackageBillBandwidthSet"):
                obj = BandwidthPackageBillBandwidth()
                obj._deserialize(item)
                self._BandwidthPackageBillBandwidthSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBandwidthPackageQuotaRequest(AbstractModel):
    """DescribeBandwidthPackageQuota request structure.

    """


class DescribeBandwidthPackageQuotaResponse(AbstractModel):
    """DescribeBandwidthPackageQuota response structure.

    """

    def __init__(self):
        r"""
        :param _QuotaSet: The quota of the bandwidth package.
        :type QuotaSet: list of Quota
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._QuotaSet = None
        self._RequestId = None

    @property
    def QuotaSet(self):
        return self._QuotaSet

    @QuotaSet.setter
    def QuotaSet(self, QuotaSet):
        self._QuotaSet = QuotaSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("QuotaSet") is not None:
            self._QuotaSet = []
            for item in params.get("QuotaSet"):
                obj = Quota()
                obj._deserialize(item)
                self._QuotaSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBandwidthPackageResourcesRequest(AbstractModel):
    """DescribeBandwidthPackageResources request structure.

    """

    def __init__(self):
        r"""
        :param _BandwidthPackageId: Unique ID of the bandwidth package in the form of `bwp-11112222`.
        :type BandwidthPackageId: str
        :param _Filters: Each request can have up to 10 `Filters` and 5 `Filter.Values`. `AddressIds` and `Filters` cannot be specified at the same time. The specific filter conditions are as follows:
<li>resource-id - String - Required: no -  (Filter condition) Filters by the unique ID of resources in a bandwidth package, such as `eip-11112222`.</li>
<li>resource-type - String - Required: no - (Filter condition) Filters by the type of resources in a bandwidth package. It now supports only EIP (`Address`) and load balancer (`LoadBalance`).</li>
        :type Filters: list of Filter
        :param _Offset: The offset. Default value: 0. For more information on `Offset`, see the relevant sections in API [Introduction](https://intl.cloud.tencent.com/document/api/213/11646?from_cn_redirect=1).
        :type Offset: int
        :param _Limit: The number of returned results. Default value: 20. Maximum value: 100. For more information on `Limit`, see the relevant sections in API [Introduction](https://intl.cloud.tencent.com/document/api/213/11646?from_cn_redirect=1).
        :type Limit: int
        """
        self._BandwidthPackageId = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def BandwidthPackageId(self):
        return self._BandwidthPackageId

    @BandwidthPackageId.setter
    def BandwidthPackageId(self, BandwidthPackageId):
        self._BandwidthPackageId = BandwidthPackageId

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._BandwidthPackageId = params.get("BandwidthPackageId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBandwidthPackageResourcesResponse(AbstractModel):
    """DescribeBandwidthPackageResources response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of eligible resources in the bandwidth package.
        :type TotalCount: int
        :param _ResourceSet: The list of resources in the bandwidth package.
        :type ResourceSet: list of Resource
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ResourceSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ResourceSet(self):
        return self._ResourceSet

    @ResourceSet.setter
    def ResourceSet(self, ResourceSet):
        self._ResourceSet = ResourceSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ResourceSet") is not None:
            self._ResourceSet = []
            for item in params.get("ResourceSet"):
                obj = Resource()
                obj._deserialize(item)
                self._ResourceSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBandwidthPackagesRequest(AbstractModel):
    """DescribeBandwidthPackages request structure.

    """

    def __init__(self):
        r"""
        :param _BandwidthPackageIds: The unique ID list of bandwidth packages.
        :type BandwidthPackageIds: list of str
        :param _Filters: Each request can have up to 10 `Filters`. `BandwidthPackageIds` and `Filters` cannot be specified at the same time. The specific filter conditions are as follows:
<li> bandwidth-package_id - String - Required: No - (Filter condition) Filter by the unique ID of the bandwidth package.</li>
<li> bandwidth-package-name - String - Required: No - (Filter condition) Filter by the bandwidth package name. Fuzzy filtering is not supported.</li>
<li> network-type - String - Required: No - (Filter condition) Filter by the bandwidth package type. Valid values: `HIGH_QUALITY_BGP`, `BGP`, `SINGLEISP`, and `ANYCAST`.</li>
<li> charge-type - String - Required: No - (Filter condition) Filter by the bandwidth package billing mode. Valid values: `TOP5_POSTPAID_BY_MONTH` and `PERCENT95_POSTPAID_BY_MONTH`.</li>
<li> resource.resource-type - String - Required: No - (Filter condition) Filter by the bandwidth package resource type. Valid values: `Address` and `LoadBalance`.</li>
<li> resource.resource-id - String - Required: No - (Filter condition) Filter by the bandwidth package resource ID, such as `eip-xxxx` and `lb-xxxx`.</li>
<li> resource.address-ip - String - Required: No - (Filter condition) Filter by the bandwidth package resource IP.</li>
<li> tag-key - String - Required: No - (Filter condition) Filter by tag key.</li>
<li> tag-value - String - Required: No - (Filter condition) Filter by tag value.</li>
<li> tag:tag-key - String - Required: No - (Filter condition) Filter by tag key-value pair. Use a specific tag key to replace `tag-key`.</li>
        :type Filters: list of Filter
        :param _Offset: Offset. This value defaults to 0. For more information, see the relevant sections in API [Overview](https://intl.cloud.tencent.com/document/api/213/15688?from_cn_redirect=1).
        :type Offset: int
        :param _Limit: Number of bandwidth packages returned. This value defaults to 20. The maximum is 100. For more information, see the relevant sections in API [Overview](https://intl.cloud.tencent.com/document/api/213/15688?from_cn_redirect=1).
        :type Limit: int
        """
        self._BandwidthPackageIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def BandwidthPackageIds(self):
        return self._BandwidthPackageIds

    @BandwidthPackageIds.setter
    def BandwidthPackageIds(self, BandwidthPackageIds):
        self._BandwidthPackageIds = BandwidthPackageIds

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._BandwidthPackageIds = params.get("BandwidthPackageIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBandwidthPackagesResponse(AbstractModel):
    """DescribeBandwidthPackages response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of eligible bandwidth packages.
        :type TotalCount: int
        :param _BandwidthPackageSet: Detail information of the bandwidth package.
        :type BandwidthPackageSet: list of BandwidthPackage
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._BandwidthPackageSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def BandwidthPackageSet(self):
        return self._BandwidthPackageSet

    @BandwidthPackageSet.setter
    def BandwidthPackageSet(self, BandwidthPackageSet):
        self._BandwidthPackageSet = BandwidthPackageSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("BandwidthPackageSet") is not None:
            self._BandwidthPackageSet = []
            for item in params.get("BandwidthPackageSet"):
                obj = BandwidthPackage()
                obj._deserialize(item)
                self._BandwidthPackageSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCcnAttachedInstancesRequest(AbstractModel):
    """DescribeCcnAttachedInstances request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Offset
        :type Offset: int
        :param _Limit: The returned quantity
        :type Limit: int
        :param _Filters: Filter conditions:
<li>`ccn-id` - String - The CCN instance ID. </li>
<li>`instance-type` - String - The associated instance type. </li>
<li>`instance-region` - String - The associated instance region. </li>
<li>`instance-id` - String - The instance ID of the associated instance. </li>
        :type Filters: list of Filter
        :param _CcnId: The ID of the CCN instance
        :type CcnId: str
        :param _OrderField: The order field supports `CcnId`, `InstanceType`, `InstanceId`, `InstanceName`, `InstanceRegion`, `AttachedTime`, and `State`.
        :type OrderField: str
        :param _OrderDirection: Order methods. Ascending: `ASC`, Descending: `DESC`.
        :type OrderDirection: str
        """
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._CcnId = None
        self._OrderField = None
        self._OrderDirection = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def CcnId(self):
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def OrderField(self):
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def OrderDirection(self):
        return self._OrderDirection

    @OrderDirection.setter
    def OrderDirection(self, OrderDirection):
        self._OrderDirection = OrderDirection


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._CcnId = params.get("CcnId")
        self._OrderField = params.get("OrderField")
        self._OrderDirection = params.get("OrderDirection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCcnAttachedInstancesResponse(AbstractModel):
    """DescribeCcnAttachedInstances response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of objects meeting the condition.
        :type TotalCount: int
        :param _InstanceSet: The list of associated instances.
        :type InstanceSet: list of CcnAttachedInstance
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._InstanceSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def InstanceSet(self):
        return self._InstanceSet

    @InstanceSet.setter
    def InstanceSet(self, InstanceSet):
        self._InstanceSet = InstanceSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("InstanceSet") is not None:
            self._InstanceSet = []
            for item in params.get("InstanceSet"):
                obj = CcnAttachedInstance()
                obj._deserialize(item)
                self._InstanceSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCcnRegionBandwidthLimitsRequest(AbstractModel):
    """DescribeCcnRegionBandwidthLimits request structure.

    """

    def __init__(self):
        r"""
        :param _CcnId: The CCN instance ID in the format of `ccn-f49l6u0z`.
        :type CcnId: str
        """
        self._CcnId = None

    @property
    def CcnId(self):
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCcnRegionBandwidthLimitsResponse(AbstractModel):
    """DescribeCcnRegionBandwidthLimits response structure.

    """

    def __init__(self):
        r"""
        :param _CcnRegionBandwidthLimitSet: The outbound bandwidth caps of all regions connected with the specified CCN instance
        :type CcnRegionBandwidthLimitSet: list of CcnRegionBandwidthLimit
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._CcnRegionBandwidthLimitSet = None
        self._RequestId = None

    @property
    def CcnRegionBandwidthLimitSet(self):
        return self._CcnRegionBandwidthLimitSet

    @CcnRegionBandwidthLimitSet.setter
    def CcnRegionBandwidthLimitSet(self, CcnRegionBandwidthLimitSet):
        self._CcnRegionBandwidthLimitSet = CcnRegionBandwidthLimitSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CcnRegionBandwidthLimitSet") is not None:
            self._CcnRegionBandwidthLimitSet = []
            for item in params.get("CcnRegionBandwidthLimitSet"):
                obj = CcnRegionBandwidthLimit()
                obj._deserialize(item)
                self._CcnRegionBandwidthLimitSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCcnRoutesRequest(AbstractModel):
    """DescribeCcnRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _CcnId: The CCN instance ID, such as `ccn-gree226l`.
        :type CcnId: str
        :param _RouteIds: The unique ID of the CCN routing policy, such as `ccnr-f49l6u0z`.
        :type RouteIds: list of str
        :param _Filters: Filter condition. `RouteIds` and `Filters` cannot be specified at the same time.
<li>route-id - String - (Filter condition) Routing policy ID.</li>
<li>cidr-block - String - (Filter condition) Destination.</li>
<li>instance-type - String - (Filter condition) The next hop type.</li>
<li>instance-region - String - (Filter condition) The next hop region.</li>
<li>instance-id - String - (Filter condition) The instance ID of the next hop.</li>
<li>route-table-id - String - (Filter condition) The list of route table IDs in the format of `ccntr-1234edfr`. Filters by the route table ID.</li>
        :type Filters: list of Filter
        :param _Offset: Offset
        :type Offset: int
        :param _Limit: The returned quantity
        :type Limit: int
        """
        self._CcnId = None
        self._RouteIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def CcnId(self):
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def RouteIds(self):
        return self._RouteIds

    @RouteIds.setter
    def RouteIds(self, RouteIds):
        self._RouteIds = RouteIds

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        self._RouteIds = params.get("RouteIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCcnRoutesResponse(AbstractModel):
    """DescribeCcnRoutes response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of objects meeting the condition.
        :type TotalCount: int
        :param _RouteSet: The CCN routing policy object.
        :type RouteSet: list of CcnRoute
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._RouteSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RouteSet(self):
        return self._RouteSet

    @RouteSet.setter
    def RouteSet(self, RouteSet):
        self._RouteSet = RouteSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RouteSet") is not None:
            self._RouteSet = []
            for item in params.get("RouteSet"):
                obj = CcnRoute()
                obj._deserialize(item)
                self._RouteSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCcnsRequest(AbstractModel):
    """DescribeCcns request structure.

    """

    def __init__(self):
        r"""
        :param _CcnIds: The CCN instance ID, such as `ccn-f49l6u0z`. Each request can have a maximum of 100 instances. `CcnIds` and `Filters` cannot be specified at the same time
        :type CcnIds: list of str
        :param _Filters: Filter conditions. `CcnIds` and `Filters` cannot be specified at the same time.
<li>ccn-id - String - (Filter condition) The unique ID of the CCN, such as `vpc-f49l6u0z`.</li>
<li>ccn-name - String - (Filter condition) The CCN name.</li>
<li>ccn-description - String - (Filter condition) CCN description.</li>
<li>state - String - (Filter condition) The instance status. 'ISOLATED': Isolated (the account is in arrears and the service is suspended.) 'AVAILABLE': Running.</li>
<li>tag-key - String - Required: no - (Filter condition) Filters by tag key.</li>
<li>`tag:tag-key` - String - Required: no - (Filter condition) Filters by tag key pair. For this parameter, `tag-key` will be replaced with a specific tag key. For more information, see this example: **Querying the list of CCNs bound to tags**.</li>
        :type Filters: list of Filter
        :param _Offset: Offset
        :type Offset: int
        :param _Limit: The returned quantity
        :type Limit: int
        :param _OrderField: Order fields support `CcnId`, `CcnName`, `CreateTime`, `State`, and `QosLevel`
        :type OrderField: str
        :param _OrderDirection: Order methods. Ascending: `ASC`, Descending: `DESC`.
        :type OrderDirection: str
        """
        self._CcnIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._OrderField = None
        self._OrderDirection = None

    @property
    def CcnIds(self):
        return self._CcnIds

    @CcnIds.setter
    def CcnIds(self, CcnIds):
        self._CcnIds = CcnIds

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderField(self):
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def OrderDirection(self):
        return self._OrderDirection

    @OrderDirection.setter
    def OrderDirection(self, OrderDirection):
        self._OrderDirection = OrderDirection


    def _deserialize(self, params):
        self._CcnIds = params.get("CcnIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._OrderField = params.get("OrderField")
        self._OrderDirection = params.get("OrderDirection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCcnsResponse(AbstractModel):
    """DescribeCcns response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of objects meeting the condition.
        :type TotalCount: int
        :param _CcnSet: CCN object.
        :type CcnSet: list of CCN
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._CcnSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def CcnSet(self):
        return self._CcnSet

    @CcnSet.setter
    def CcnSet(self, CcnSet):
        self._CcnSet = CcnSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("CcnSet") is not None:
            self._CcnSet = []
            for item in params.get("CcnSet"):
                obj = CCN()
                obj._deserialize(item)
                self._CcnSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeClassicLinkInstancesRequest(AbstractModel):
    """DescribeClassicLinkInstances request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter conditions.
<li>vpc-id - String - (Filter condition) The VPC instance ID.</li>
<li>vm-ip - String - (Filter condition) The IP address of the CVM on the basic network.</li>
        :type Filters: list of FilterObject
        :param _Offset: Offset
        :type Offset: str
        :param _Limit: The returned quantity
        :type Limit: str
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FilterObject()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClassicLinkInstancesResponse(AbstractModel):
    """DescribeClassicLinkInstances response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of instances meeting the filter condition.
        :type TotalCount: int
        :param _ClassicLinkInstanceSet: Classiclink instance.
        :type ClassicLinkInstanceSet: list of ClassicLinkInstance
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ClassicLinkInstanceSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ClassicLinkInstanceSet(self):
        return self._ClassicLinkInstanceSet

    @ClassicLinkInstanceSet.setter
    def ClassicLinkInstanceSet(self, ClassicLinkInstanceSet):
        self._ClassicLinkInstanceSet = ClassicLinkInstanceSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ClassicLinkInstanceSet") is not None:
            self._ClassicLinkInstanceSet = []
            for item in params.get("ClassicLinkInstanceSet"):
                obj = ClassicLinkInstance()
                obj._deserialize(item)
                self._ClassicLinkInstanceSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCrossBorderComplianceRequest(AbstractModel):
    """DescribeCrossBorderCompliance request structure.

    """

    def __init__(self):
        r"""
        :param _ServiceProvider: (Exact match) Service provider. Valid values: `UNICOM`.
        :type ServiceProvider: str
        :param _ComplianceId: (Exact match) ID of compliance review request.
        :type ComplianceId: int
        :param _Company: (Fuzzy match) Company name.
        :type Company: str
        :param _UniformSocialCreditCode: (Fuzzy match) Unified Social Credit Code.
        :type UniformSocialCreditCode: str
        :param _LegalPerson: (Fuzzy match) Legal person.
        :type LegalPerson: str
        :param _IssuingAuthority: (Fuzzy match) Issuing authority.
        :type IssuingAuthority: str
        :param _BusinessAddress: (Fuzzy match) Business address.
        :type BusinessAddress: str
        :param _PostCode: (Exact match) Zip code.
        :type PostCode: int
        :param _Manager: (Fuzzy match) Operator.
        :type Manager: str
        :param _ManagerId: (Exact match) Operator ID card number.
        :type ManagerId: str
        :param _ManagerAddress: (Fuzzy match) Operator address.
        :type ManagerAddress: str
        :param _ManagerTelephone: (Exact match) Operator phone number.
        :type ManagerTelephone: str
        :param _Email: (Exact match) Email.
        :type Email: str
        :param _ServiceStartDate: (Exact match) Service start date, such as `2020-07-28`.
        :type ServiceStartDate: str
        :param _ServiceEndDate: (Exact match) Service end date, such as `2020-07-28`.
        :type ServiceEndDate: str
        :param _State: (Exact match) Status. Valid values: `PENDING`, `APPROVED`, and `DENY`.
        :type State: str
        :param _Offset: The offset value
        :type Offset: int
        :param _Limit: Quantity of returned items
        :type Limit: int
        """
        self._ServiceProvider = None
        self._ComplianceId = None
        self._Company = None
        self._UniformSocialCreditCode = None
        self._LegalPerson = None
        self._IssuingAuthority = None
        self._BusinessAddress = None
        self._PostCode = None
        self._Manager = None
        self._ManagerId = None
        self._ManagerAddress = None
        self._ManagerTelephone = None
        self._Email = None
        self._ServiceStartDate = None
        self._ServiceEndDate = None
        self._State = None
        self._Offset = None
        self._Limit = None

    @property
    def ServiceProvider(self):
        return self._ServiceProvider

    @ServiceProvider.setter
    def ServiceProvider(self, ServiceProvider):
        self._ServiceProvider = ServiceProvider

    @property
    def ComplianceId(self):
        return self._ComplianceId

    @ComplianceId.setter
    def ComplianceId(self, ComplianceId):
        self._ComplianceId = ComplianceId

    @property
    def Company(self):
        return self._Company

    @Company.setter
    def Company(self, Company):
        self._Company = Company

    @property
    def UniformSocialCreditCode(self):
        return self._UniformSocialCreditCode

    @UniformSocialCreditCode.setter
    def UniformSocialCreditCode(self, UniformSocialCreditCode):
        self._UniformSocialCreditCode = UniformSocialCreditCode

    @property
    def LegalPerson(self):
        return self._LegalPerson

    @LegalPerson.setter
    def LegalPerson(self, LegalPerson):
        self._LegalPerson = LegalPerson

    @property
    def IssuingAuthority(self):
        return self._IssuingAuthority

    @IssuingAuthority.setter
    def IssuingAuthority(self, IssuingAuthority):
        self._IssuingAuthority = IssuingAuthority

    @property
    def BusinessAddress(self):
        return self._BusinessAddress

    @BusinessAddress.setter
    def BusinessAddress(self, BusinessAddress):
        self._BusinessAddress = BusinessAddress

    @property
    def PostCode(self):
        return self._PostCode

    @PostCode.setter
    def PostCode(self, PostCode):
        self._PostCode = PostCode

    @property
    def Manager(self):
        return self._Manager

    @Manager.setter
    def Manager(self, Manager):
        self._Manager = Manager

    @property
    def ManagerId(self):
        return self._ManagerId

    @ManagerId.setter
    def ManagerId(self, ManagerId):
        self._ManagerId = ManagerId

    @property
    def ManagerAddress(self):
        return self._ManagerAddress

    @ManagerAddress.setter
    def ManagerAddress(self, ManagerAddress):
        self._ManagerAddress = ManagerAddress

    @property
    def ManagerTelephone(self):
        return self._ManagerTelephone

    @ManagerTelephone.setter
    def ManagerTelephone(self, ManagerTelephone):
        self._ManagerTelephone = ManagerTelephone

    @property
    def Email(self):
        return self._Email

    @Email.setter
    def Email(self, Email):
        self._Email = Email

    @property
    def ServiceStartDate(self):
        return self._ServiceStartDate

    @ServiceStartDate.setter
    def ServiceStartDate(self, ServiceStartDate):
        self._ServiceStartDate = ServiceStartDate

    @property
    def ServiceEndDate(self):
        return self._ServiceEndDate

    @ServiceEndDate.setter
    def ServiceEndDate(self, ServiceEndDate):
        self._ServiceEndDate = ServiceEndDate

    @property
    def State(self):
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._ServiceProvider = params.get("ServiceProvider")
        self._ComplianceId = params.get("ComplianceId")
        self._Company = params.get("Company")
        self._UniformSocialCreditCode = params.get("UniformSocialCreditCode")
        self._LegalPerson = params.get("LegalPerson")
        self._IssuingAuthority = params.get("IssuingAuthority")
        self._BusinessAddress = params.get("BusinessAddress")
        self._PostCode = params.get("PostCode")
        self._Manager = params.get("Manager")
        self._ManagerId = params.get("ManagerId")
        self._ManagerAddress = params.get("ManagerAddress")
        self._ManagerTelephone = params.get("ManagerTelephone")
        self._Email = params.get("Email")
        self._ServiceStartDate = params.get("ServiceStartDate")
        self._ServiceEndDate = params.get("ServiceEndDate")
        self._State = params.get("State")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCrossBorderComplianceResponse(AbstractModel):
    """DescribeCrossBorderCompliance response structure.

    """

    def __init__(self):
        r"""
        :param _CrossBorderComplianceSet: List of compliance review requests.
        :type CrossBorderComplianceSet: list of CrossBorderCompliance
        :param _TotalCount: Total number of compliance review requests.
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._CrossBorderComplianceSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def CrossBorderComplianceSet(self):
        return self._CrossBorderComplianceSet

    @CrossBorderComplianceSet.setter
    def CrossBorderComplianceSet(self, CrossBorderComplianceSet):
        self._CrossBorderComplianceSet = CrossBorderComplianceSet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CrossBorderComplianceSet") is not None:
            self._CrossBorderComplianceSet = []
            for item in params.get("CrossBorderComplianceSet"):
                obj = CrossBorderCompliance()
                obj._deserialize(item)
                self._CrossBorderComplianceSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeCustomerGatewayVendorsRequest(AbstractModel):
    """DescribeCustomerGatewayVendors request structure.

    """


class DescribeCustomerGatewayVendorsResponse(AbstractModel):
    """DescribeCustomerGatewayVendors response structure.

    """

    def __init__(self):
        r"""
        :param _CustomerGatewayVendorSet: Customer gateway vendor information object.
        :type CustomerGatewayVendorSet: list of CustomerGatewayVendor
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._CustomerGatewayVendorSet = None
        self._RequestId = None

    @property
    def CustomerGatewayVendorSet(self):
        return self._CustomerGatewayVendorSet

    @CustomerGatewayVendorSet.setter
    def CustomerGatewayVendorSet(self, CustomerGatewayVendorSet):
        self._CustomerGatewayVendorSet = CustomerGatewayVendorSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CustomerGatewayVendorSet") is not None:
            self._CustomerGatewayVendorSet = []
            for item in params.get("CustomerGatewayVendorSet"):
                obj = CustomerGatewayVendor()
                obj._deserialize(item)
                self._CustomerGatewayVendorSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCustomerGatewaysRequest(AbstractModel):
    """DescribeCustomerGateways request structure.

    """

    def __init__(self):
        r"""
        :param _CustomerGatewayIds: Customer gateway ID, such as `cgw-2wqq41m9`. Each request can have a maximum of 100 instances. `CustomerGatewayIds` and `Filters` cannot be specified at the same time.
        :type CustomerGatewayIds: list of str
        :param _Filters: The filter condition. For details, see the Instance Filter Conditions Table. The upper limit for `Filters` in each request is 10 and 5 for `Filter.Values`. `CustomerGatewayIds` and `Filters` cannot be specified at the same time.
<li>customer-gateway-id - String - (Filter condition) The unique ID of the user gateway, such as `cgw-mgp33pll`.</li>
<li>customer-gateway-name - String - (Filter condition) The name of the user gateway, such as `test-cgw`.</li>
<li>ip-address - String - (Filter condition) The public IP address, such as `58.211.1.12`.</li>
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: 0. For more information on Offset, see the relevant section in the API [Introduction](https://intl.cloud.tencent.com/document/api/213/11646?from_cn_redirect=1).
        :type Offset: int
        :param _Limit: Number of returned results. Default value: 20. Maximum value: 100.
        :type Limit: int
        """
        self._CustomerGatewayIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def CustomerGatewayIds(self):
        return self._CustomerGatewayIds

    @CustomerGatewayIds.setter
    def CustomerGatewayIds(self, CustomerGatewayIds):
        self._CustomerGatewayIds = CustomerGatewayIds

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._CustomerGatewayIds = params.get("CustomerGatewayIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCustomerGatewaysResponse(AbstractModel):
    """DescribeCustomerGateways response structure.

    """

    def __init__(self):
        r"""
        :param _CustomerGatewaySet: Customer gateway object list
        :type CustomerGatewaySet: list of CustomerGateway
        :param _TotalCount: Number of eligible instances
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._CustomerGatewaySet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def CustomerGatewaySet(self):
        return self._CustomerGatewaySet

    @CustomerGatewaySet.setter
    def CustomerGatewaySet(self, CustomerGatewaySet):
        self._CustomerGatewaySet = CustomerGatewaySet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CustomerGatewaySet") is not None:
            self._CustomerGatewaySet = []
            for item in params.get("CustomerGatewaySet"):
                obj = CustomerGateway()
                obj._deserialize(item)
                self._CustomerGatewaySet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeDirectConnectGatewayCcnRoutesRequest(AbstractModel):
    """DescribeDirectConnectGatewayCcnRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _DirectConnectGatewayId: The ID of the Direct Connect gateway, such as `dcg-prpqlmg1`.
        :type DirectConnectGatewayId: str
        :param _CcnRouteType: The route learning type of the CCN. Available values:
<li>`BGP` - Automatic learning.</li>
<li>`STATIC` - Static means user-configured. This is the default value.</li>
        :type CcnRouteType: str
        :param _Offset: Offset.
        :type Offset: int
        :param _Limit: The returned quantity.
        :type Limit: int
        """
        self._DirectConnectGatewayId = None
        self._CcnRouteType = None
        self._Offset = None
        self._Limit = None

    @property
    def DirectConnectGatewayId(self):
        return self._DirectConnectGatewayId

    @DirectConnectGatewayId.setter
    def DirectConnectGatewayId(self, DirectConnectGatewayId):
        self._DirectConnectGatewayId = DirectConnectGatewayId

    @property
    def CcnRouteType(self):
        return self._CcnRouteType

    @CcnRouteType.setter
    def CcnRouteType(self, CcnRouteType):
        self._CcnRouteType = CcnRouteType

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._DirectConnectGatewayId = params.get("DirectConnectGatewayId")
        self._CcnRouteType = params.get("CcnRouteType")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDirectConnectGatewayCcnRoutesResponse(AbstractModel):
    """DescribeDirectConnectGatewayCcnRoutes response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of objects meeting the condition.
        :type TotalCount: int
        :param _RouteSet: The CCN route (IDC IP range) list.
        :type RouteSet: list of DirectConnectGatewayCcnRoute
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._RouteSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RouteSet(self):
        return self._RouteSet

    @RouteSet.setter
    def RouteSet(self, RouteSet):
        self._RouteSet = RouteSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RouteSet") is not None:
            self._RouteSet = []
            for item in params.get("RouteSet"):
                obj = DirectConnectGatewayCcnRoute()
                obj._deserialize(item)
                self._RouteSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDirectConnectGatewaysRequest(AbstractModel):
    """DescribeDirectConnectGateways request structure.

    """

    def __init__(self):
        r"""
        :param _DirectConnectGatewayIds: The unique ID of the direct connect gateway, such as `dcg-9o233uri`.
        :type DirectConnectGatewayIds: list of str
        :param _Filters: Filter condition. `DirectConnectGatewayIds` and `Filters` cannot be specified at the same time.
<li>direct-connect-gateway-id - String - The unique ID of the direct connect gateway, such as `dcg-9o233uri`.</li>
<li>direct-connect-gateway-name - String - The name of the direct connect gateway. The default is fuzzy query.</li>
<li>direct-connect-gateway-ip - String - The IP of the direct connect gateway.</li>
<li>gateway-type - String - The gateway type. Valid values: `NORMAL` (Standard type), `NAT` (NAT type).</li>
<li>network-type- String - The network type. Valid values: `VPC` (VPC type), `CCN` (CCN type).</li>
<li>ccn-id - String - The ID of the CCN where the direct connect gateway resides.</li>
<li>vpc-id - String - The ID of the VPC where the direct connect gateway resides.</li>
        :type Filters: list of Filter
        :param _Offset: The offset.
        :type Offset: int
        :param _Limit: Max number of results returned
        :type Limit: int
        """
        self._DirectConnectGatewayIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def DirectConnectGatewayIds(self):
        return self._DirectConnectGatewayIds

    @DirectConnectGatewayIds.setter
    def DirectConnectGatewayIds(self, DirectConnectGatewayIds):
        self._DirectConnectGatewayIds = DirectConnectGatewayIds

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._DirectConnectGatewayIds = params.get("DirectConnectGatewayIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDirectConnectGatewaysResponse(AbstractModel):
    """DescribeDirectConnectGateways response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of eligible objects.
        :type TotalCount: int
        :param _DirectConnectGatewaySet: The object array of the direct connect gateway.
        :type DirectConnectGatewaySet: list of DirectConnectGateway
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._DirectConnectGatewaySet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DirectConnectGatewaySet(self):
        return self._DirectConnectGatewaySet

    @DirectConnectGatewaySet.setter
    def DirectConnectGatewaySet(self, DirectConnectGatewaySet):
        self._DirectConnectGatewaySet = DirectConnectGatewaySet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DirectConnectGatewaySet") is not None:
            self._DirectConnectGatewaySet = []
            for item in params.get("DirectConnectGatewaySet"):
                obj = DirectConnectGateway()
                obj._deserialize(item)
                self._DirectConnectGatewaySet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeFlowLogRequest(AbstractModel):
    """DescribeFlowLog request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: ID of the VPC instance.
        :type VpcId: str
        :param _FlowLogId: The unique ID of the flow log.
        :type FlowLogId: str
        """
        self._VpcId = None
        self._FlowLogId = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def FlowLogId(self):
        return self._FlowLogId

    @FlowLogId.setter
    def FlowLogId(self, FlowLogId):
        self._FlowLogId = FlowLogId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._FlowLogId = params.get("FlowLogId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFlowLogResponse(AbstractModel):
    """DescribeFlowLog response structure.

    """

    def __init__(self):
        r"""
        :param _FlowLog: The flow log information.
        :type FlowLog: list of FlowLog
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowLog = None
        self._RequestId = None

    @property
    def FlowLog(self):
        return self._FlowLog

    @FlowLog.setter
    def FlowLog(self, FlowLog):
        self._FlowLog = FlowLog

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("FlowLog") is not None:
            self._FlowLog = []
            for item in params.get("FlowLog"):
                obj = FlowLog()
                obj._deserialize(item)
                self._FlowLog.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeFlowLogsRequest(AbstractModel):
    """DescribeFlowLogs request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: ID of the VPC instance
        :type VpcId: str
        :param _FlowLogId: The unique ID of the flow log.
        :type FlowLogId: str
        :param _FlowLogName: The name of the flow log instance.
        :type FlowLogName: str
        :param _ResourceType: The resource type of the flow log. Valid values: 'VPC', 'SUBNET', and 'NETWORKINTERFACE'.
        :type ResourceType: str
        :param _ResourceId: The unique ID of the resource.
        :type ResourceId: str
        :param _TrafficType: Type of flow logs to be collected. Valid values: 'ACCEPT', 'REJECT' and 'ALL'.
        :type TrafficType: str
        :param _CloudLogId: The storage ID of the flow log.
        :type CloudLogId: str
        :param _CloudLogState: The storage ID status of the flow log.
        :type CloudLogState: str
        :param _OrderField: Order by field. Valid values: 'flowLogName' and 'createTime'. Default value: 'createTime'.
        :type OrderField: str
        :param _OrderDirection: In ascending (`asc`) or descending (`desc`) order. Default value: 'desc'.
        :type OrderDirection: str
        :param _Offset: The offset. Default value: 0.
        :type Offset: int
        :param _Limit: The number of rows per page. Default value: 10.
        :type Limit: int
        :param _Filters: Filter condition. `FlowLogId` and `Filters` cannot be specified at the same time.
<li> `tag-key` - String - Optional - Filter by the tag key.</li>
<li> `tag:tag-key` - String - Optional - Filter by the tag key-value pair. The tag-key should be replaced with a specified tag key.</li>
        :type Filters: :class:`tencentcloud.vpc.v20170312.models.Filter`
        :param _CloudLogRegion: The region corresponding to the flow log storage ID.
        :type CloudLogRegion: str
        """
        self._VpcId = None
        self._FlowLogId = None
        self._FlowLogName = None
        self._ResourceType = None
        self._ResourceId = None
        self._TrafficType = None
        self._CloudLogId = None
        self._CloudLogState = None
        self._OrderField = None
        self._OrderDirection = None
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._CloudLogRegion = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def FlowLogId(self):
        return self._FlowLogId

    @FlowLogId.setter
    def FlowLogId(self, FlowLogId):
        self._FlowLogId = FlowLogId

    @property
    def FlowLogName(self):
        return self._FlowLogName

    @FlowLogName.setter
    def FlowLogName(self, FlowLogName):
        self._FlowLogName = FlowLogName

    @property
    def ResourceType(self):
        return self._ResourceType

    @ResourceType.setter
    def ResourceType(self, ResourceType):
        self._ResourceType = ResourceType

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId

    @property
    def TrafficType(self):
        return self._TrafficType

    @TrafficType.setter
    def TrafficType(self, TrafficType):
        self._TrafficType = TrafficType

    @property
    def CloudLogId(self):
        return self._CloudLogId

    @CloudLogId.setter
    def CloudLogId(self, CloudLogId):
        self._CloudLogId = CloudLogId

    @property
    def CloudLogState(self):
        return self._CloudLogState

    @CloudLogState.setter
    def CloudLogState(self, CloudLogState):
        self._CloudLogState = CloudLogState

    @property
    def OrderField(self):
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def OrderDirection(self):
        return self._OrderDirection

    @OrderDirection.setter
    def OrderDirection(self, OrderDirection):
        self._OrderDirection = OrderDirection

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def CloudLogRegion(self):
        return self._CloudLogRegion

    @CloudLogRegion.setter
    def CloudLogRegion(self, CloudLogRegion):
        self._CloudLogRegion = CloudLogRegion


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._FlowLogId = params.get("FlowLogId")
        self._FlowLogName = params.get("FlowLogName")
        self._ResourceType = params.get("ResourceType")
        self._ResourceId = params.get("ResourceId")
        self._TrafficType = params.get("TrafficType")
        self._CloudLogId = params.get("CloudLogId")
        self._CloudLogState = params.get("CloudLogState")
        self._OrderField = params.get("OrderField")
        self._OrderDirection = params.get("OrderDirection")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = Filter()
            self._Filters._deserialize(params.get("Filters"))
        self._CloudLogRegion = params.get("CloudLogRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFlowLogsResponse(AbstractModel):
    """DescribeFlowLogs response structure.

    """

    def __init__(self):
        r"""
        :param _FlowLog: The instance set of flow logs.
        :type FlowLog: list of FlowLog
        :param _TotalNum: The total number of flow logs.
        :type TotalNum: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowLog = None
        self._TotalNum = None
        self._RequestId = None

    @property
    def FlowLog(self):
        return self._FlowLog

    @FlowLog.setter
    def FlowLog(self, FlowLog):
        self._FlowLog = FlowLog

    @property
    def TotalNum(self):
        return self._TotalNum

    @TotalNum.setter
    def TotalNum(self, TotalNum):
        self._TotalNum = TotalNum

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("FlowLog") is not None:
            self._FlowLog = []
            for item in params.get("FlowLog"):
                obj = FlowLog()
                obj._deserialize(item)
                self._FlowLog.append(obj)
        self._TotalNum = params.get("TotalNum")
        self._RequestId = params.get("RequestId")


class DescribeGatewayFlowMonitorDetailRequest(AbstractModel):
    """DescribeGatewayFlowMonitorDetail request structure.

    """

    def __init__(self):
        r"""
        :param _TimePoint: The point in time. This indicates details of this minute will be queried. For example, in `2019-02-28 18:15:20`, details at `18:15` will be queried.
        :type TimePoint: str
        :param _VpnId: The instance ID of the VPN gateway, such as `vpn-ltjahce6`.
        :type VpnId: str
        :param _DirectConnectGatewayId: The instance ID of the Direct Connect gateway, such as `dcg-ltjahce6`.
        :type DirectConnectGatewayId: str
        :param _PeeringConnectionId: The instance ID of the peering connection, such as `pcx-ltjahce6`.
        :type PeeringConnectionId: str
        :param _NatId: The instance ID of the NAT gateway, such as `nat-ltjahce6`.
        :type NatId: str
        :param _Offset: Offset.
        :type Offset: int
        :param _Limit: The returned quantity.
        :type Limit: int
        :param _OrderField: The order field supports `InPkg`, `OutPkg`, `InTraffic`, and `OutTraffic`.
        :type OrderField: str
        :param _OrderDirection: Order methods. Ascending: `ASC`, Descending: `DESC`.
        :type OrderDirection: str
        """
        self._TimePoint = None
        self._VpnId = None
        self._DirectConnectGatewayId = None
        self._PeeringConnectionId = None
        self._NatId = None
        self._Offset = None
        self._Limit = None
        self._OrderField = None
        self._OrderDirection = None

    @property
    def TimePoint(self):
        return self._TimePoint

    @TimePoint.setter
    def TimePoint(self, TimePoint):
        self._TimePoint = TimePoint

    @property
    def VpnId(self):
        return self._VpnId

    @VpnId.setter
    def VpnId(self, VpnId):
        self._VpnId = VpnId

    @property
    def DirectConnectGatewayId(self):
        return self._DirectConnectGatewayId

    @DirectConnectGatewayId.setter
    def DirectConnectGatewayId(self, DirectConnectGatewayId):
        self._DirectConnectGatewayId = DirectConnectGatewayId

    @property
    def PeeringConnectionId(self):
        return self._PeeringConnectionId

    @PeeringConnectionId.setter
    def PeeringConnectionId(self, PeeringConnectionId):
        self._PeeringConnectionId = PeeringConnectionId

    @property
    def NatId(self):
        return self._NatId

    @NatId.setter
    def NatId(self, NatId):
        self._NatId = NatId

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderField(self):
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def OrderDirection(self):
        return self._OrderDirection

    @OrderDirection.setter
    def OrderDirection(self, OrderDirection):
        self._OrderDirection = OrderDirection


    def _deserialize(self, params):
        self._TimePoint = params.get("TimePoint")
        self._VpnId = params.get("VpnId")
        self._DirectConnectGatewayId = params.get("DirectConnectGatewayId")
        self._PeeringConnectionId = params.get("PeeringConnectionId")
        self._NatId = params.get("NatId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._OrderField = params.get("OrderField")
        self._OrderDirection = params.get("OrderDirection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGatewayFlowMonitorDetailResponse(AbstractModel):
    """DescribeGatewayFlowMonitorDetail response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of objects meeting the condition.
        :type TotalCount: int
        :param _GatewayFlowMonitorDetailSet: The gateway traffic monitoring details.
        :type GatewayFlowMonitorDetailSet: list of GatewayFlowMonitorDetail
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._GatewayFlowMonitorDetailSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def GatewayFlowMonitorDetailSet(self):
        return self._GatewayFlowMonitorDetailSet

    @GatewayFlowMonitorDetailSet.setter
    def GatewayFlowMonitorDetailSet(self, GatewayFlowMonitorDetailSet):
        self._GatewayFlowMonitorDetailSet = GatewayFlowMonitorDetailSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("GatewayFlowMonitorDetailSet") is not None:
            self._GatewayFlowMonitorDetailSet = []
            for item in params.get("GatewayFlowMonitorDetailSet"):
                obj = GatewayFlowMonitorDetail()
                obj._deserialize(item)
                self._GatewayFlowMonitorDetailSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeGatewayFlowQosRequest(AbstractModel):
    """DescribeGatewayFlowQos request structure.

    """

    def __init__(self):
        r"""
        :param _GatewayId: Gateway instance ID. Supported types:
Direct connect gateway instance, such as `dcg-ltjahce6`;
NAT gateway instance, such as `nat-ltjahce6`;
VPN gateway instance, such as `vpn-ltjahce6`.
        :type GatewayId: str
        :param _IpAddresses: CVM private IP addresses with limited bandwidth.
        :type IpAddresses: list of str
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned results. Default value: 20. Maximum value: 100.
        :type Limit: int
        """
        self._GatewayId = None
        self._IpAddresses = None
        self._Offset = None
        self._Limit = None

    @property
    def GatewayId(self):
        return self._GatewayId

    @GatewayId.setter
    def GatewayId(self, GatewayId):
        self._GatewayId = GatewayId

    @property
    def IpAddresses(self):
        return self._IpAddresses

    @IpAddresses.setter
    def IpAddresses(self, IpAddresses):
        self._IpAddresses = IpAddresses

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._GatewayId = params.get("GatewayId")
        self._IpAddresses = params.get("IpAddresses")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGatewayFlowQosResponse(AbstractModel):
    """DescribeGatewayFlowQos response structure.

    """

    def __init__(self):
        r"""
        :param _GatewayQosSet: List of instance details
        :type GatewayQosSet: list of GatewayQos
        :param _TotalCount: Number of eligible instances.
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._GatewayQosSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def GatewayQosSet(self):
        return self._GatewayQosSet

    @GatewayQosSet.setter
    def GatewayQosSet(self, GatewayQosSet):
        self._GatewayQosSet = GatewayQosSet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("GatewayQosSet") is not None:
            self._GatewayQosSet = []
            for item in params.get("GatewayQosSet"):
                obj = GatewayQos()
                obj._deserialize(item)
                self._GatewayQosSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeHaVipsRequest(AbstractModel):
    """DescribeHaVips request structure.

    """

    def __init__(self):
        r"""
        :param _HaVipIds: The unique `ID` of the `HAVIP`, such as `havip-9o233uri`.
        :type HaVipIds: list of str
        :param _Filters: Filter condition. `HaVipIds` and `Filters` cannot be specified at the same time.
li>havip-id - String - The unique ID of the HAVIP, such as `havip-9o233uri`.</li>
<li>havip-name - String - HAVIP name.</li>
<li>vpc-id - String - VPC ID of the HAVIP.</li>
<li>subnet-id - String - Subnet ID of the HAVIP.</li>
<li>vip - String - Virtual IP address of the HAVIP.</li>
<li>address-ip - String - Bound EIP.</li>
        :type Filters: list of Filter
        :param _Offset: Offset
        :type Offset: int
        :param _Limit: The returned quantity
        :type Limit: int
        """
        self._HaVipIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def HaVipIds(self):
        return self._HaVipIds

    @HaVipIds.setter
    def HaVipIds(self, HaVipIds):
        self._HaVipIds = HaVipIds

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._HaVipIds = params.get("HaVipIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeHaVipsResponse(AbstractModel):
    """DescribeHaVips response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of objects meeting the condition.
        :type TotalCount: int
        :param _HaVipSet: `HAVIP` object array.
        :type HaVipSet: list of HaVip
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._HaVipSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def HaVipSet(self):
        return self._HaVipSet

    @HaVipSet.setter
    def HaVipSet(self, HaVipSet):
        self._HaVipSet = HaVipSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("HaVipSet") is not None:
            self._HaVipSet = []
            for item in params.get("HaVipSet"):
                obj = HaVip()
                obj._deserialize(item)
                self._HaVipSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeIpGeolocationDatabaseUrlRequest(AbstractModel):
    """DescribeIpGeolocationDatabaseUrl request structure.

    """

    def __init__(self):
        r"""
        :param _Type: Protocol type for an IP location database. Valid value: `ipv4`.
        :type Type: str
        """
        self._Type = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIpGeolocationDatabaseUrlResponse(AbstractModel):
    """DescribeIpGeolocationDatabaseUrl response structure.

    """

    def __init__(self):
        r"""
        :param _DownLoadUrl: Download link of an IP location database
        :type DownLoadUrl: str
        :param _ExpiredAt: Link expiration time in UTC format following the ISO8601 standard.
        :type ExpiredAt: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DownLoadUrl = None
        self._ExpiredAt = None
        self._RequestId = None

    @property
    def DownLoadUrl(self):
        return self._DownLoadUrl

    @DownLoadUrl.setter
    def DownLoadUrl(self, DownLoadUrl):
        self._DownLoadUrl = DownLoadUrl

    @property
    def ExpiredAt(self):
        return self._ExpiredAt

    @ExpiredAt.setter
    def ExpiredAt(self, ExpiredAt):
        self._ExpiredAt = ExpiredAt

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownLoadUrl = params.get("DownLoadUrl")
        self._ExpiredAt = params.get("ExpiredAt")
        self._RequestId = params.get("RequestId")


class DescribeIpGeolocationInfosRequest(AbstractModel):
    """DescribeIpGeolocationInfos request structure.

    """

    def __init__(self):
        r"""
        :param _AddressIps: The list of IP addresses (only IPv4 addresses are available currently) to be queried; upper limit: 100
        :type AddressIps: list of str
        :param _Fields: Fields of the IP addresses to be queried.
        :type Fields: :class:`tencentcloud.vpc.v20170312.models.IpField`
        """
        self._AddressIps = None
        self._Fields = None

    @property
    def AddressIps(self):
        return self._AddressIps

    @AddressIps.setter
    def AddressIps(self, AddressIps):
        self._AddressIps = AddressIps

    @property
    def Fields(self):
        return self._Fields

    @Fields.setter
    def Fields(self, Fields):
        self._Fields = Fields


    def _deserialize(self, params):
        self._AddressIps = params.get("AddressIps")
        if params.get("Fields") is not None:
            self._Fields = IpField()
            self._Fields._deserialize(params.get("Fields"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIpGeolocationInfosResponse(AbstractModel):
    """DescribeIpGeolocationInfos response structure.

    """

    def __init__(self):
        r"""
        :param _AddressInfo: IP address details
        :type AddressInfo: list of IpGeolocationInfo
        :param _Total: Number of IP addresses
        :type Total: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AddressInfo = None
        self._Total = None
        self._RequestId = None

    @property
    def AddressInfo(self):
        return self._AddressInfo

    @AddressInfo.setter
    def AddressInfo(self, AddressInfo):
        self._AddressInfo = AddressInfo

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AddressInfo") is not None:
            self._AddressInfo = []
            for item in params.get("AddressInfo"):
                obj = IpGeolocationInfo()
                obj._deserialize(item)
                self._AddressInfo.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeLocalGatewayRequest(AbstractModel):
    """DescribeLocalGateway request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Query criteria:
vpc-id: filter by VPC ID; local-gateway-name: filter by local gateway name (fuzzy search is supported); local-gateway-id: filter by local gateway instance ID; cdc-id: filter by CDC instance ID.
        :type Filters: list of Filter
        :param _Offset: The offset. Default value: 0. For more information on `Offset`, see the relevant sections in API [Introduction](https://intl.cloud.tencent.com/document/api/213/11646?from_cn_redirect=1).
        :type Offset: int
        :param _Limit: The number of returned results. Default value: 20. Maximum value: 100. For more information on `Limit`, see the relevant sections in API [Introduction](https://intl.cloud.tencent.com/document/api/213/11646?from_cn_redirect=1).
        :type Limit: int
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLocalGatewayResponse(AbstractModel):
    """DescribeLocalGateway response structure.

    """

    def __init__(self):
        r"""
        :param _LocalGatewaySet: Information set of local gateways
        :type LocalGatewaySet: list of LocalGateway
        :param _TotalCount: Total number of local gateways
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._LocalGatewaySet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def LocalGatewaySet(self):
        return self._LocalGatewaySet

    @LocalGatewaySet.setter
    def LocalGatewaySet(self, LocalGatewaySet):
        self._LocalGatewaySet = LocalGatewaySet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("LocalGatewaySet") is not None:
            self._LocalGatewaySet = []
            for item in params.get("LocalGatewaySet"):
                obj = LocalGateway()
                obj._deserialize(item)
                self._LocalGatewaySet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeNatGatewayDestinationIpPortTranslationNatRulesRequest(AbstractModel):
    """DescribeNatGatewayDestinationIpPortTranslationNatRules request structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewayIds: NAT gateway ID.
        :type NatGatewayIds: list of str
        :param _Filters: Filters:
`NatGatewayIds` and `Filters` cannot be specified at the same time.
<li> `nat-gateway-id`: The NAT gateway ID, such as `nat-0yi4hekt`.</li>
<li> `vpc-id`: The VPC ID, such as `vpc-0yi4hekt`.</li>
<li> `public-ip-address`: The EIP, such as `139.199.232.238`.</li>
<li>`public-port`: The public network port.</li>
<li>`private-ip-address`: The private IP, such as `10.0.0.1`.</li>
<li>`private-port`. The private network port.</li>
<li>`description`. The rule description.</li>
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned results. Default value: 20. Maximum value: 100.
        :type Limit: int
        """
        self._NatGatewayIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def NatGatewayIds(self):
        return self._NatGatewayIds

    @NatGatewayIds.setter
    def NatGatewayIds(self, NatGatewayIds):
        self._NatGatewayIds = NatGatewayIds

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._NatGatewayIds = params.get("NatGatewayIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNatGatewayDestinationIpPortTranslationNatRulesResponse(AbstractModel):
    """DescribeNatGatewayDestinationIpPortTranslationNatRules response structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewayDestinationIpPortTranslationNatRuleSet: The object array of port forwarding rules for the NAT gateway.
        :type NatGatewayDestinationIpPortTranslationNatRuleSet: list of NatGatewayDestinationIpPortTranslationNatRule
        :param _TotalCount: The number of eligible object arrays of NAT port forwarding rules.
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NatGatewayDestinationIpPortTranslationNatRuleSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def NatGatewayDestinationIpPortTranslationNatRuleSet(self):
        return self._NatGatewayDestinationIpPortTranslationNatRuleSet

    @NatGatewayDestinationIpPortTranslationNatRuleSet.setter
    def NatGatewayDestinationIpPortTranslationNatRuleSet(self, NatGatewayDestinationIpPortTranslationNatRuleSet):
        self._NatGatewayDestinationIpPortTranslationNatRuleSet = NatGatewayDestinationIpPortTranslationNatRuleSet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NatGatewayDestinationIpPortTranslationNatRuleSet") is not None:
            self._NatGatewayDestinationIpPortTranslationNatRuleSet = []
            for item in params.get("NatGatewayDestinationIpPortTranslationNatRuleSet"):
                obj = NatGatewayDestinationIpPortTranslationNatRule()
                obj._deserialize(item)
                self._NatGatewayDestinationIpPortTranslationNatRuleSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeNatGatewayDirectConnectGatewayRouteRequest(AbstractModel):
    """DescribeNatGatewayDirectConnectGatewayRoute request structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: Unique ID of the NAT gateway
        :type NatGatewayId: str
        :param _VpcId: Unique ID of VPC
        :type VpcId: str
        :param _Limit: Valid range: 0-200
        :type Limit: int
        :param _Offset: Greater than 0
        :type Offset: int
        """
        self._NatGatewayId = None
        self._VpcId = None
        self._Limit = None
        self._Offset = None

    @property
    def NatGatewayId(self):
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        self._VpcId = params.get("VpcId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNatGatewayDirectConnectGatewayRouteResponse(AbstractModel):
    """DescribeNatGatewayDirectConnectGatewayRoute response structure.

    """

    def __init__(self):
        r"""
        :param _NatDirectConnectGatewayRouteSet: Route data
        :type NatDirectConnectGatewayRouteSet: list of NatDirectConnectGatewayRoute
        :param _Total: Total number of routes
        :type Total: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NatDirectConnectGatewayRouteSet = None
        self._Total = None
        self._RequestId = None

    @property
    def NatDirectConnectGatewayRouteSet(self):
        return self._NatDirectConnectGatewayRouteSet

    @NatDirectConnectGatewayRouteSet.setter
    def NatDirectConnectGatewayRouteSet(self, NatDirectConnectGatewayRouteSet):
        self._NatDirectConnectGatewayRouteSet = NatDirectConnectGatewayRouteSet

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NatDirectConnectGatewayRouteSet") is not None:
            self._NatDirectConnectGatewayRouteSet = []
            for item in params.get("NatDirectConnectGatewayRouteSet"):
                obj = NatDirectConnectGatewayRoute()
                obj._deserialize(item)
                self._NatDirectConnectGatewayRouteSet.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeNatGatewaySourceIpTranslationNatRulesRequest(AbstractModel):
    """DescribeNatGatewaySourceIpTranslationNatRules request structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: The unique ID of the NAT Gateway, such as `nat-123xx454`.
        :type NatGatewayId: str
        :param _Filters: Filter:
<li>`resource-id`: The subnet ID (such as `subnet-0yi4hekt`) or CVM ID</li>
<li>`public-ip-address`: The EIP, such as `139.199.232.238`</li>
<li>`description` The rule description</li>
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned results. Default value: 20. Maximum value: 100.
        :type Limit: int
        """
        self._NatGatewayId = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def NatGatewayId(self):
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNatGatewaySourceIpTranslationNatRulesResponse(AbstractModel):
    """DescribeNatGatewaySourceIpTranslationNatRules response structure.

    """

    def __init__(self):
        r"""
        :param _SourceIpTranslationNatRuleSet: Array of objects of a NAT gateway's SNAT rules.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type SourceIpTranslationNatRuleSet: list of SourceIpTranslationNatRule
        :param _TotalCount: The number of eligible object arrays of a NAT gateway's forwarding rules.
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SourceIpTranslationNatRuleSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SourceIpTranslationNatRuleSet(self):
        return self._SourceIpTranslationNatRuleSet

    @SourceIpTranslationNatRuleSet.setter
    def SourceIpTranslationNatRuleSet(self, SourceIpTranslationNatRuleSet):
        self._SourceIpTranslationNatRuleSet = SourceIpTranslationNatRuleSet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SourceIpTranslationNatRuleSet") is not None:
            self._SourceIpTranslationNatRuleSet = []
            for item in params.get("SourceIpTranslationNatRuleSet"):
                obj = SourceIpTranslationNatRule()
                obj._deserialize(item)
                self._SourceIpTranslationNatRuleSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeNatGatewaysRequest(AbstractModel):
    """DescribeNatGateways request structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewayIds: The unified ID of the NAT gateways, such as `nat-123xx454`.
        :type NatGatewayIds: list of str
        :param _Filters: Filters. `NatGatewayIds` and `Filters` cannot be specified at the same time.
<li>nat-gateway-id - String - (Filter) The ID of the protocol port template instance, such as `nat-123xx454`.</li>
<li>vpc-id - String - (Filter) The unique ID of the VPC, such as `vpc-123xx454`.</li>
<li>nat-gateway-name - String - (Filter) The ID of the protocol port template instance, such as `test_nat`.</li>
<li>tag-key - String - (Filter) The tag key, such as `test-key`.</li>
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned results. Default value: 20. Maximum value: 100.
        :type Limit: int
        """
        self._NatGatewayIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def NatGatewayIds(self):
        return self._NatGatewayIds

    @NatGatewayIds.setter
    def NatGatewayIds(self, NatGatewayIds):
        self._NatGatewayIds = NatGatewayIds

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._NatGatewayIds = params.get("NatGatewayIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNatGatewaysResponse(AbstractModel):
    """DescribeNatGateways response structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewaySet: NAT gateway object array.
        :type NatGatewaySet: list of NatGateway
        :param _TotalCount: The number of eligible NAT gateway objects.
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NatGatewaySet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def NatGatewaySet(self):
        return self._NatGatewaySet

    @NatGatewaySet.setter
    def NatGatewaySet(self, NatGatewaySet):
        self._NatGatewaySet = NatGatewaySet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NatGatewaySet") is not None:
            self._NatGatewaySet = []
            for item in params.get("NatGatewaySet"):
                obj = NatGateway()
                obj._deserialize(item)
                self._NatGatewaySet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeNetDetectStatesRequest(AbstractModel):
    """DescribeNetDetectStates request structure.

    """

    def __init__(self):
        r"""
        :param _NetDetectIds: The array of network probe IDs, such as [`netd-12345678`].
        :type NetDetectIds: list of str
        :param _Filters: Filter conditions. `NetDetectIds` and `Filters` cannot be specified at the same time.
<li>`net-detect-id` - String - The network probe ID, such as `netd-12345678`.</li>
        :type Filters: list of Filter
        :param _Offset: The offset. Default: 0.
        :type Offset: int
        :param _Limit: The number of returned values. Default: 20. Maximum: 100.
        :type Limit: int
        """
        self._NetDetectIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def NetDetectIds(self):
        return self._NetDetectIds

    @NetDetectIds.setter
    def NetDetectIds(self, NetDetectIds):
        self._NetDetectIds = NetDetectIds

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._NetDetectIds = params.get("NetDetectIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetDetectStatesResponse(AbstractModel):
    """DescribeNetDetectStates response structure.

    """

    def __init__(self):
        r"""
        :param _NetDetectStateSet: The array of network detection verification results that meet requirements.
Note: This field may return null, indicating that no valid values can be obtained.
        :type NetDetectStateSet: list of NetDetectState
        :param _TotalCount: The number of network detection verification results that meet requirements.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NetDetectStateSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def NetDetectStateSet(self):
        return self._NetDetectStateSet

    @NetDetectStateSet.setter
    def NetDetectStateSet(self, NetDetectStateSet):
        self._NetDetectStateSet = NetDetectStateSet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetDetectStateSet") is not None:
            self._NetDetectStateSet = []
            for item in params.get("NetDetectStateSet"):
                obj = NetDetectState()
                obj._deserialize(item)
                self._NetDetectStateSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeNetDetectsRequest(AbstractModel):
    """DescribeNetDetects request structure.

    """

    def __init__(self):
        r"""
        :param _NetDetectIds: The array of network probe IDs, such as [`netd-12345678`].
        :type NetDetectIds: list of str
        :param _Filters: Filter conditions. `NetDetectIds` and `Filters` cannot be specified at the same time.
<li>vpc-id - String - (Filter condition) The VPC instance ID, such as vpc-12345678.</li>
<li>net-detect-id - String - (Filter condition) The network detection instance ID, such as netd-12345678.</li>
<li>subnet-id - String - (Filter condition) The subnet instance ID, such as subnet-12345678.</li>
<li>net-detect-name - String - (Filter condition) The network detection name.</li>
        :type Filters: list of Filter
        :param _Offset: The offset. Default: 0.
        :type Offset: int
        :param _Limit: The number of returned values. Default: 20. Maximum: 100.
        :type Limit: int
        """
        self._NetDetectIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def NetDetectIds(self):
        return self._NetDetectIds

    @NetDetectIds.setter
    def NetDetectIds(self, NetDetectIds):
        self._NetDetectIds = NetDetectIds

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._NetDetectIds = params.get("NetDetectIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetDetectsResponse(AbstractModel):
    """DescribeNetDetects response structure.

    """

    def __init__(self):
        r"""
        :param _NetDetectSet: The array of network detection objects that meet requirements.
Note: This field may return null, indicating that no valid values can be obtained.
        :type NetDetectSet: list of NetDetect
        :param _TotalCount: The number of network detection objects that meet requirements.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NetDetectSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def NetDetectSet(self):
        return self._NetDetectSet

    @NetDetectSet.setter
    def NetDetectSet(self, NetDetectSet):
        self._NetDetectSet = NetDetectSet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetDetectSet") is not None:
            self._NetDetectSet = []
            for item in params.get("NetDetectSet"):
                obj = NetDetect()
                obj._deserialize(item)
                self._NetDetectSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeNetworkAclQuintupleEntriesRequest(AbstractModel):
    """DescribeNetworkAclQuintupleEntries request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkAclId: Network ACL instance ID, such as `acl-12345678`.
        :type NetworkAclId: str
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Returned quantity. Default: 20. Value range: 1-100.
        :type Limit: int
        :param _Filters: Filter condition. `HaVipIds` and `Filters` cannot be specified at the same time.
<li>`protocol` - String - Such as `TCP`</li>
<li>`description` - String - Description</li>
<li>`destination-cidr` - String - Destination CIDR block, such as `192.168.0.0/24`</li>
<li>`source-cidr` - String - Source CIDR block, such as `192.168.0.0/24`</li>
<li>`action` - String - ·Values: `ACCEPT`, `DROP`</li>
<li>`network-acl-quintuple-entry-id` - String - Unique ID of the quintuple, such as `acli45-ahnu4rv5`</li>
<li>`network-acl-direction` - String - Direction of the policy. Values: `INGRESS` or `EGRESS`.</li>
        :type Filters: list of Filter
        """
        self._NetworkAclId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def NetworkAclId(self):
        return self._NetworkAclId

    @NetworkAclId.setter
    def NetworkAclId(self, NetworkAclId):
        self._NetworkAclId = NetworkAclId

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._NetworkAclId = params.get("NetworkAclId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkAclQuintupleEntriesResponse(AbstractModel):
    """DescribeNetworkAclQuintupleEntries response structure.

    """

    def __init__(self):
        r"""
        :param _NetworkAclQuintupleSet: The list of the network ACL quintuple entries
        :type NetworkAclQuintupleSet: list of NetworkAclQuintupleEntry
        :param _TotalCount: Number of eligible instances.
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NetworkAclQuintupleSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def NetworkAclQuintupleSet(self):
        return self._NetworkAclQuintupleSet

    @NetworkAclQuintupleSet.setter
    def NetworkAclQuintupleSet(self, NetworkAclQuintupleSet):
        self._NetworkAclQuintupleSet = NetworkAclQuintupleSet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetworkAclQuintupleSet") is not None:
            self._NetworkAclQuintupleSet = []
            for item in params.get("NetworkAclQuintupleSet"):
                obj = NetworkAclQuintupleEntry()
                obj._deserialize(item)
                self._NetworkAclQuintupleSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeNetworkAclsRequest(AbstractModel):
    """DescribeNetworkAcls request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkAclIds: Array of network ACL instance IDs, such as [acl-12345678]. Up to 100 instances are allowed for each request. This parameter does not support specifying `NetworkAclIds` and `Filters` at the same time.
        :type NetworkAclIds: list of str
        :param _Filters: Filter condition. `NetworkAclIds` and `Filters` cannot be specified at the same time.
<li>vpc-id - String - (Filter condition) VPC instance ID, such as vpc-12345678.</li>
<li>network-acl-id - String - (Filter condition) Network ACL instance ID, such as acl-12345678.</li>
<li>network-acl-name - String - (Filter condition) Network ACL instance name.</li>
        :type Filters: list of Filter
        :param _Offset: Offset. Default: 0.
        :type Offset: int
        :param _Limit: Returned quantity. Default: 20. Value range: 1-100.
        :type Limit: int
        """
        self._NetworkAclIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def NetworkAclIds(self):
        return self._NetworkAclIds

    @NetworkAclIds.setter
    def NetworkAclIds(self, NetworkAclIds):
        self._NetworkAclIds = NetworkAclIds

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._NetworkAclIds = params.get("NetworkAclIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkAclsResponse(AbstractModel):
    """DescribeNetworkAcls response structure.

    """

    def __init__(self):
        r"""
        :param _NetworkAclSet: List of instance details.
        :type NetworkAclSet: list of NetworkAcl
        :param _TotalCount: Number of eligible instances.
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NetworkAclSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def NetworkAclSet(self):
        return self._NetworkAclSet

    @NetworkAclSet.setter
    def NetworkAclSet(self, NetworkAclSet):
        self._NetworkAclSet = NetworkAclSet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetworkAclSet") is not None:
            self._NetworkAclSet = []
            for item in params.get("NetworkAclSet"):
                obj = NetworkAcl()
                obj._deserialize(item)
                self._NetworkAclSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeNetworkInterfaceLimitRequest(AbstractModel):
    """DescribeNetworkInterfaceLimit request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: ID of a CVM instance or ENI to query
        :type InstanceId: str
        """
        self._InstanceId = None

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkInterfaceLimitResponse(AbstractModel):
    """DescribeNetworkInterfaceLimit response structure.

    """

    def __init__(self):
        r"""
        :param _EniQuantity: Quota of ENIs mounted to a CVM instance in a standard way
        :type EniQuantity: int
        :param _EniPrivateIpAddressQuantity: Quota of IP addresses that can be allocated to each standard-mounted ENI
        :type EniPrivateIpAddressQuantity: int
        :param _ExtendEniQuantity: Quota of ENIs mounted to a CVM instance as an extension
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type ExtendEniQuantity: int
        :param _ExtendEniPrivateIpAddressQuantity: Quota of IP addresses that can be allocated to each extension-mounted ENI.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type ExtendEniPrivateIpAddressQuantity: int
        :param _SubEniQuantity: The quota of relayed ENIs
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type SubEniQuantity: int
        :param _SubEniPrivateIpAddressQuantity: The quota of IPs that can be assigned to each relayed ENI.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type SubEniPrivateIpAddressQuantity: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._EniQuantity = None
        self._EniPrivateIpAddressQuantity = None
        self._ExtendEniQuantity = None
        self._ExtendEniPrivateIpAddressQuantity = None
        self._SubEniQuantity = None
        self._SubEniPrivateIpAddressQuantity = None
        self._RequestId = None

    @property
    def EniQuantity(self):
        return self._EniQuantity

    @EniQuantity.setter
    def EniQuantity(self, EniQuantity):
        self._EniQuantity = EniQuantity

    @property
    def EniPrivateIpAddressQuantity(self):
        return self._EniPrivateIpAddressQuantity

    @EniPrivateIpAddressQuantity.setter
    def EniPrivateIpAddressQuantity(self, EniPrivateIpAddressQuantity):
        self._EniPrivateIpAddressQuantity = EniPrivateIpAddressQuantity

    @property
    def ExtendEniQuantity(self):
        return self._ExtendEniQuantity

    @ExtendEniQuantity.setter
    def ExtendEniQuantity(self, ExtendEniQuantity):
        self._ExtendEniQuantity = ExtendEniQuantity

    @property
    def ExtendEniPrivateIpAddressQuantity(self):
        return self._ExtendEniPrivateIpAddressQuantity

    @ExtendEniPrivateIpAddressQuantity.setter
    def ExtendEniPrivateIpAddressQuantity(self, ExtendEniPrivateIpAddressQuantity):
        self._ExtendEniPrivateIpAddressQuantity = ExtendEniPrivateIpAddressQuantity

    @property
    def SubEniQuantity(self):
        return self._SubEniQuantity

    @SubEniQuantity.setter
    def SubEniQuantity(self, SubEniQuantity):
        self._SubEniQuantity = SubEniQuantity

    @property
    def SubEniPrivateIpAddressQuantity(self):
        return self._SubEniPrivateIpAddressQuantity

    @SubEniPrivateIpAddressQuantity.setter
    def SubEniPrivateIpAddressQuantity(self, SubEniPrivateIpAddressQuantity):
        self._SubEniPrivateIpAddressQuantity = SubEniPrivateIpAddressQuantity

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._EniQuantity = params.get("EniQuantity")
        self._EniPrivateIpAddressQuantity = params.get("EniPrivateIpAddressQuantity")
        self._ExtendEniQuantity = params.get("ExtendEniQuantity")
        self._ExtendEniPrivateIpAddressQuantity = params.get("ExtendEniPrivateIpAddressQuantity")
        self._SubEniQuantity = params.get("SubEniQuantity")
        self._SubEniPrivateIpAddressQuantity = params.get("SubEniPrivateIpAddressQuantity")
        self._RequestId = params.get("RequestId")


class DescribeNetworkInterfacesRequest(AbstractModel):
    """DescribeNetworkInterfaces request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkInterfaceIds: Queries the ID of the ENI instance, such as `eni-pxir56ns`. Each request can have a maximum of 100 instances. `NetworkInterfaceIds` and `Filters` cannot be specified at the same time.
        :type NetworkInterfaceIds: list of str
        :param _Filters: Filter. `NetworkInterfaceIds` and `Filters` cannot be specified at the same time.
<li>`vpc-id` - String - VPC ID, such as `vpc-f49l6u0z`. </li>
<li>`subnet-id` - String - Subnet ID, such as `subnet-f49l6u0z`. </li>
<li>`network-interface-id` - String - ENI ID, such as `eni-5k56k7k7`. </li>
<li>`attachment.instance-id` - String - ID of the bound CVM instance, such as `ins-3nqpdn3i`. </li>
<li>`groups.security-group-id` - String - ID of the bound security group, such as `sg-f9ekbxeq`. </li>
<li>`network-interface-name` - String - ENI instance name. </li>
<li>`network-interface-description` - String - ENI instance description. </li>
<li>`address-ip` - String - Private IPv4 address. A single IP will be fuzzily matched with the suffix, while multiple IPs will be exactly matched. It can be used with `ip-exact-match` to query and exactly match a single IP. </li>
<li>`ip-exact-match` - Boolean - Exact match by private IPv4 address. The first value will be returned if multiple values are found. </li>
<li>`tag-key` - String - u200dOptional - u200dTag key. See Example 2 to learn more details. </li>
<li>`tag:tag-key` - String - Optional - Tag key-value pair. The `tag-key` should be replaced with a specific tag key. See Example 2 to learn more details. </li>
<li>`is-primary` - Boolean - Optional - Filter based on whether it is a primary ENI. Values: `true`, `false`. If this parameter is not specified, filter the both. </li>
<li>`eni-type` - String - Optional - Filter by ENI type. Values: `0` (Secondary ENI), `1` (Primary ENI), `2` (Relayed ENI) </li>
<li>`eni-qos` - String - Optional - Filter by ENI service level. Values: `AG` (Bronze), `AU` (Silver) </li>
<li>`address-ipv6` - String - Optional - Filter by private IPv6 address. Multiple IPv6 addresses can be used for query. If this field is used together with `address-ip`, their intersection will be used. </li>
<li>`public-address-ip` - String - Public IPv4 address. It supports exact matching. </li>
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned results. Default value: 20. Maximum value: 100.
        :type Limit: int
        """
        self._NetworkInterfaceIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def NetworkInterfaceIds(self):
        return self._NetworkInterfaceIds

    @NetworkInterfaceIds.setter
    def NetworkInterfaceIds(self, NetworkInterfaceIds):
        self._NetworkInterfaceIds = NetworkInterfaceIds

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._NetworkInterfaceIds = params.get("NetworkInterfaceIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkInterfacesResponse(AbstractModel):
    """DescribeNetworkInterfaces response structure.

    """

    def __init__(self):
        r"""
        :param _NetworkInterfaceSet: List of instance details.
        :type NetworkInterfaceSet: list of NetworkInterface
        :param _TotalCount: Number of eligible instances.
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NetworkInterfaceSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def NetworkInterfaceSet(self):
        return self._NetworkInterfaceSet

    @NetworkInterfaceSet.setter
    def NetworkInterfaceSet(self, NetworkInterfaceSet):
        self._NetworkInterfaceSet = NetworkInterfaceSet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetworkInterfaceSet") is not None:
            self._NetworkInterfaceSet = []
            for item in params.get("NetworkInterfaceSet"):
                obj = NetworkInterface()
                obj._deserialize(item)
                self._NetworkInterfaceSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeRouteTablesRequest(AbstractModel):
    """DescribeRouteTables request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter condition. `RouteTableIds` and `Filters` cannot be specified at the same time.
<li>route-table-id - String - (Filter condition) Route table instance ID.</li>
<li>route-table-name - String - (Filter condition) Route table name.</li>
<li>vpc-id - String - (Filter condition) VPC instance ID, such as `vpc-f49l6u0z`.</li>
<li>association.main - String - (Filter condition) Whether it is the main route table.</li>
<li>tag-key - String - Required: no - (Filter condition) Filter by tag key.</li>
<li>tag:tag-key - String - Required: no - (Filter condition) Filter by tag key-value pair. Use a specific tag key to replace `tag-key`. See Example 2 for the detailed usage.</li>
        :type Filters: list of Filter
        :param _RouteTableIds: The route table instance ID, such as `rtb-azd4dt1c`.
        :type RouteTableIds: list of str
        :param _Offset: Offset.
        :type Offset: str
        :param _Limit: The number of request objects.
        :type Limit: str
        """
        self._Filters = None
        self._RouteTableIds = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def RouteTableIds(self):
        return self._RouteTableIds

    @RouteTableIds.setter
    def RouteTableIds(self, RouteTableIds):
        self._RouteTableIds = RouteTableIds

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._RouteTableIds = params.get("RouteTableIds")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRouteTablesResponse(AbstractModel):
    """DescribeRouteTables response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible instances.
        :type TotalCount: int
        :param _RouteTableSet: Route table object.
        :type RouteTableSet: list of RouteTable
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._RouteTableSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RouteTableSet(self):
        return self._RouteTableSet

    @RouteTableSet.setter
    def RouteTableSet(self, RouteTableSet):
        self._RouteTableSet = RouteTableSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RouteTableSet") is not None:
            self._RouteTableSet = []
            for item in params.get("RouteTableSet"):
                obj = RouteTable()
                obj._deserialize(item)
                self._RouteTableSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSecurityGroupAssociationStatisticsRequest(AbstractModel):
    """DescribeSecurityGroupAssociationStatistics request structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroupIds: The Security instance ID, such as `sg-33ocnj9n`. It can be obtained through DescribeSecurityGroups.
        :type SecurityGroupIds: list of str
        """
        self._SecurityGroupIds = None

    @property
    def SecurityGroupIds(self):
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds


    def _deserialize(self, params):
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecurityGroupAssociationStatisticsResponse(AbstractModel):
    """DescribeSecurityGroupAssociationStatistics response structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroupAssociationStatisticsSet: Statistics on the instances associated with a security group.
        :type SecurityGroupAssociationStatisticsSet: list of SecurityGroupAssociationStatistics
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SecurityGroupAssociationStatisticsSet = None
        self._RequestId = None

    @property
    def SecurityGroupAssociationStatisticsSet(self):
        return self._SecurityGroupAssociationStatisticsSet

    @SecurityGroupAssociationStatisticsSet.setter
    def SecurityGroupAssociationStatisticsSet(self, SecurityGroupAssociationStatisticsSet):
        self._SecurityGroupAssociationStatisticsSet = SecurityGroupAssociationStatisticsSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SecurityGroupAssociationStatisticsSet") is not None:
            self._SecurityGroupAssociationStatisticsSet = []
            for item in params.get("SecurityGroupAssociationStatisticsSet"):
                obj = SecurityGroupAssociationStatistics()
                obj._deserialize(item)
                self._SecurityGroupAssociationStatisticsSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSecurityGroupPoliciesRequest(AbstractModel):
    """DescribeSecurityGroupPolicies request structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroupId: The security group instance ID, such as `sg-33ocnj9n`. It can be obtained through DescribeSecurityGroups.
        :type SecurityGroupId: str
        :param _Filters: Filters
<li>`security-group-id` - String - Security group ID in the rule.</li>
<li>`ip` - String - IP. IPV4 and IPV6 fuzzy matching is supported.</li>
<li>`address-module` - String - IP address or address group template ID.</li>
<li>`service-module` - String - Protocol port or port group template ID.</li>
<li>`protocol-type` - String - Protocol supported by the security group policy. Valid values: `TCP`, `UDP`, `ICMP`, `ICMPV6`, `GRE`, `ALL`.</li>
<li>`port` - String - Optional - Port. Fuzzy matching is supported. Query all ports when the protocol value is `ALL`.</li>
<li>`poly` - String - Policy type. Valid values: `ALL`, `ACCEPT` and `DROP`.</li>
<li>`direction` - String - Direction of the rule. Valid values: `ALL`, `INBOUND` and `OUTBOUND`.</li>
<li>`description` - String - Policy description. Fuzzy matching is supported.</li>
        :type Filters: list of Filter
        """
        self._SecurityGroupId = None
        self._Filters = None

    @property
    def SecurityGroupId(self):
        return self._SecurityGroupId

    @SecurityGroupId.setter
    def SecurityGroupId(self, SecurityGroupId):
        self._SecurityGroupId = SecurityGroupId

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._SecurityGroupId = params.get("SecurityGroupId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecurityGroupPoliciesResponse(AbstractModel):
    """DescribeSecurityGroupPolicies response structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroupPolicySet: Security group policy set.
        :type SecurityGroupPolicySet: :class:`tencentcloud.vpc.v20170312.models.SecurityGroupPolicySet`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SecurityGroupPolicySet = None
        self._RequestId = None

    @property
    def SecurityGroupPolicySet(self):
        return self._SecurityGroupPolicySet

    @SecurityGroupPolicySet.setter
    def SecurityGroupPolicySet(self, SecurityGroupPolicySet):
        self._SecurityGroupPolicySet = SecurityGroupPolicySet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SecurityGroupPolicySet") is not None:
            self._SecurityGroupPolicySet = SecurityGroupPolicySet()
            self._SecurityGroupPolicySet._deserialize(params.get("SecurityGroupPolicySet"))
        self._RequestId = params.get("RequestId")


class DescribeSecurityGroupReferencesRequest(AbstractModel):
    """DescribeSecurityGroupReferences request structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroupIds: A set of security group instance IDs, e.g. ['sg-12345678']
        :type SecurityGroupIds: list of str
        """
        self._SecurityGroupIds = None

    @property
    def SecurityGroupIds(self):
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds


    def _deserialize(self, params):
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecurityGroupReferencesResponse(AbstractModel):
    """DescribeSecurityGroupReferences response structure.

    """

    def __init__(self):
        r"""
        :param _ReferredSecurityGroupSet: Referred security groups.
        :type ReferredSecurityGroupSet: list of ReferredSecurityGroup
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ReferredSecurityGroupSet = None
        self._RequestId = None

    @property
    def ReferredSecurityGroupSet(self):
        return self._ReferredSecurityGroupSet

    @ReferredSecurityGroupSet.setter
    def ReferredSecurityGroupSet(self, ReferredSecurityGroupSet):
        self._ReferredSecurityGroupSet = ReferredSecurityGroupSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ReferredSecurityGroupSet") is not None:
            self._ReferredSecurityGroupSet = []
            for item in params.get("ReferredSecurityGroupSet"):
                obj = ReferredSecurityGroup()
                obj._deserialize(item)
                self._ReferredSecurityGroupSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSecurityGroupsRequest(AbstractModel):
    """DescribeSecurityGroups request structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroupIds: Security group ID, such as `sg-33ocnj9n`. Each request can contain up to 100 instances at a time. `SecurityGroupIds` and `Filters` cannot be specified at the same time.
        :type SecurityGroupIds: list of str
        :param _Filters: Filter conditions. `SecurityGroupIds` and `Filters` cannot be specified at the same time.
<li>security-group-id - String - (Filter condition) The security group ID.</li>
<li>project-id - Integer - (Filter condition) The project ID.</li>
<li>security-group-name - String - (Filter condition) The security group name.</li>
<li>tag-key - String - Required: no - (Filter condition) Filters by tag key. For more information, see Example 2.</li>
<li> `tag:tag-key` - String - Required: no - (Filter condition) Filters by tag key pair. For this parameter, `tag-key` will be replaced with a specific tag key. For more information, see Example 3.</li>
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: 0.
        :type Offset: str
        :param _Limit: Number of returned results. Default value: 20. Maximum value: 100.
        :type Limit: str
        :param _OrderField: Sorting field. Values: `CreatedTime`, `UpdateTime` Note: This field does not have default value.
        :type OrderField: str
        :param _OrderDirection: Sorting method Order methods. Ascending: `ASC`, Descending: `DESC`. Default: `ASC`
        :type OrderDirection: str
        """
        self._SecurityGroupIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._OrderField = None
        self._OrderDirection = None

    @property
    def SecurityGroupIds(self):
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderField(self):
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def OrderDirection(self):
        return self._OrderDirection

    @OrderDirection.setter
    def OrderDirection(self, OrderDirection):
        self._OrderDirection = OrderDirection


    def _deserialize(self, params):
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._OrderField = params.get("OrderField")
        self._OrderDirection = params.get("OrderDirection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecurityGroupsResponse(AbstractModel):
    """DescribeSecurityGroups response structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroupSet: Security group object.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type SecurityGroupSet: list of SecurityGroup
        :param _TotalCount: The number of instances meeting the filter condition.
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SecurityGroupSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SecurityGroupSet(self):
        return self._SecurityGroupSet

    @SecurityGroupSet.setter
    def SecurityGroupSet(self, SecurityGroupSet):
        self._SecurityGroupSet = SecurityGroupSet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SecurityGroupSet") is not None:
            self._SecurityGroupSet = []
            for item in params.get("SecurityGroupSet"):
                obj = SecurityGroup()
                obj._deserialize(item)
                self._SecurityGroupSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeServiceTemplateGroupsRequest(AbstractModel):
    """DescribeServiceTemplateGroups request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter conditions.
<li>service-template-group-name - String - (Filter condition) Protocol port template group name.</li>
<li>service-template-group-id - String - (Filter condition) Protocol port template group instance ID, such as `ppmg-e6dy460g`.</li>
        :type Filters: list of Filter
        :param _Offset: Offset. The default value is 0.
        :type Offset: str
        :param _Limit: Number of values to be returned. The default value is 20. Maximum is 100.
        :type Limit: str
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeServiceTemplateGroupsResponse(AbstractModel):
    """DescribeServiceTemplateGroups response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of instances meeting the filter condition.
        :type TotalCount: int
        :param _ServiceTemplateGroupSet: Protocol port template group.
        :type ServiceTemplateGroupSet: list of ServiceTemplateGroup
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ServiceTemplateGroupSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ServiceTemplateGroupSet(self):
        return self._ServiceTemplateGroupSet

    @ServiceTemplateGroupSet.setter
    def ServiceTemplateGroupSet(self, ServiceTemplateGroupSet):
        self._ServiceTemplateGroupSet = ServiceTemplateGroupSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ServiceTemplateGroupSet") is not None:
            self._ServiceTemplateGroupSet = []
            for item in params.get("ServiceTemplateGroupSet"):
                obj = ServiceTemplateGroup()
                obj._deserialize(item)
                self._ServiceTemplateGroupSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeServiceTemplatesRequest(AbstractModel):
    """DescribeServiceTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filters
<li>service-template-name - Protocol port template name.</li>
<li>service-template-id - Protocol port template ID, such as `ppm-e6dy460g`.</li>
<li>service-port-Protocol port.</li>
        :type Filters: list of Filter
        :param _Offset: Offset. The default value is 0.
        :type Offset: str
        :param _Limit: Number of values to be returned. The default value is 20. Maximum is 100.
        :type Limit: str
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeServiceTemplatesResponse(AbstractModel):
    """DescribeServiceTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of instances meeting the filter condition.
        :type TotalCount: int
        :param _ServiceTemplateSet: Protocol port template object.
        :type ServiceTemplateSet: list of ServiceTemplate
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ServiceTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ServiceTemplateSet(self):
        return self._ServiceTemplateSet

    @ServiceTemplateSet.setter
    def ServiceTemplateSet(self, ServiceTemplateSet):
        self._ServiceTemplateSet = ServiceTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ServiceTemplateSet") is not None:
            self._ServiceTemplateSet = []
            for item in params.get("ServiceTemplateSet"):
                obj = ServiceTemplate()
                obj._deserialize(item)
                self._ServiceTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSgSnapshotFileContentRequest(AbstractModel):
    """DescribeSgSnapshotFileContent request structure.

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicyId: Snapshot policy IDs
        :type SnapshotPolicyId: str
        :param _SnapshotFileId: Snapshot file ID
        :type SnapshotFileId: str
        :param _SecurityGroupId: Security group ID
        :type SecurityGroupId: str
        """
        self._SnapshotPolicyId = None
        self._SnapshotFileId = None
        self._SecurityGroupId = None

    @property
    def SnapshotPolicyId(self):
        return self._SnapshotPolicyId

    @SnapshotPolicyId.setter
    def SnapshotPolicyId(self, SnapshotPolicyId):
        self._SnapshotPolicyId = SnapshotPolicyId

    @property
    def SnapshotFileId(self):
        return self._SnapshotFileId

    @SnapshotFileId.setter
    def SnapshotFileId(self, SnapshotFileId):
        self._SnapshotFileId = SnapshotFileId

    @property
    def SecurityGroupId(self):
        return self._SecurityGroupId

    @SecurityGroupId.setter
    def SecurityGroupId(self, SecurityGroupId):
        self._SecurityGroupId = SecurityGroupId


    def _deserialize(self, params):
        self._SnapshotPolicyId = params.get("SnapshotPolicyId")
        self._SnapshotFileId = params.get("SnapshotFileId")
        self._SecurityGroupId = params.get("SecurityGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSgSnapshotFileContentResponse(AbstractModel):
    """DescribeSgSnapshotFileContent response structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Security group ID
        :type InstanceId: str
        :param _SnapshotPolicyId: Snapshot policy IDs
        :type SnapshotPolicyId: str
        :param _SnapshotFileId: Snapshot file ID
        :type SnapshotFileId: str
        :param _BackupTime: Backup time
        :type BackupTime: str
        :param _Operator: Operator
        :type Operator: str
        :param _OriginalData: Original data
        :type OriginalData: list of SecurityGroupPolicy
        :param _BackupData: Backup data
        :type BackupData: list of SecurityGroupPolicy
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._InstanceId = None
        self._SnapshotPolicyId = None
        self._SnapshotFileId = None
        self._BackupTime = None
        self._Operator = None
        self._OriginalData = None
        self._BackupData = None
        self._RequestId = None

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def SnapshotPolicyId(self):
        return self._SnapshotPolicyId

    @SnapshotPolicyId.setter
    def SnapshotPolicyId(self, SnapshotPolicyId):
        self._SnapshotPolicyId = SnapshotPolicyId

    @property
    def SnapshotFileId(self):
        return self._SnapshotFileId

    @SnapshotFileId.setter
    def SnapshotFileId(self, SnapshotFileId):
        self._SnapshotFileId = SnapshotFileId

    @property
    def BackupTime(self):
        return self._BackupTime

    @BackupTime.setter
    def BackupTime(self, BackupTime):
        self._BackupTime = BackupTime

    @property
    def Operator(self):
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def OriginalData(self):
        return self._OriginalData

    @OriginalData.setter
    def OriginalData(self, OriginalData):
        self._OriginalData = OriginalData

    @property
    def BackupData(self):
        return self._BackupData

    @BackupData.setter
    def BackupData(self, BackupData):
        self._BackupData = BackupData

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._SnapshotPolicyId = params.get("SnapshotPolicyId")
        self._SnapshotFileId = params.get("SnapshotFileId")
        self._BackupTime = params.get("BackupTime")
        self._Operator = params.get("Operator")
        if params.get("OriginalData") is not None:
            self._OriginalData = []
            for item in params.get("OriginalData"):
                obj = SecurityGroupPolicy()
                obj._deserialize(item)
                self._OriginalData.append(obj)
        if params.get("BackupData") is not None:
            self._BackupData = []
            for item in params.get("BackupData"):
                obj = SecurityGroupPolicy()
                obj._deserialize(item)
                self._BackupData.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSnapshotAttachedInstancesRequest(AbstractModel):
    """DescribeSnapshotAttachedInstances request structure.

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicyId: Snapshot policy IDs
        :type SnapshotPolicyId: str
        :param _Filters: Filters
Values:
<li>`instance-id`: Instance ID</li>
<li>`instance-region`: Instance region</li>
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Limit: Number of returned results. Default value: 20. Maximum value: 200.
        :type Limit: int
        """
        self._SnapshotPolicyId = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def SnapshotPolicyId(self):
        return self._SnapshotPolicyId

    @SnapshotPolicyId.setter
    def SnapshotPolicyId(self, SnapshotPolicyId):
        self._SnapshotPolicyId = SnapshotPolicyId

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SnapshotPolicyId = params.get("SnapshotPolicyId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSnapshotAttachedInstancesResponse(AbstractModel):
    """DescribeSnapshotAttachedInstances response structure.

    """

    def __init__(self):
        r"""
        :param _InstanceSet: List of instances
        :type InstanceSet: list of SnapshotInstance
        :param _TotalCount: The number of eligible objects.
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._InstanceSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def InstanceSet(self):
        return self._InstanceSet

    @InstanceSet.setter
    def InstanceSet(self, InstanceSet):
        self._InstanceSet = InstanceSet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("InstanceSet") is not None:
            self._InstanceSet = []
            for item in params.get("InstanceSet"):
                obj = SnapshotInstance()
                obj._deserialize(item)
                self._InstanceSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeSnapshotFilesRequest(AbstractModel):
    """DescribeSnapshotFiles request structure.

    """

    def __init__(self):
        r"""
        :param _BusinessType: Type of associated resource. Values: `securitygroup`
        :type BusinessType: str
        :param _InstanceId: Service instance ID. It's corresponding to the `BusinessType`. 
        :type InstanceId: str
        :param _StartDate: Start time. Format: %Y-%m-%d %H:%M:%S
        :type StartDate: str
        :param _EndDate: End time. Format: %Y-%m-%d %H:%M:%S
        :type EndDate: str
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Limit: Number of returned results. Default value: 20. Maximum value: 100.
        :type Limit: int
        """
        self._BusinessType = None
        self._InstanceId = None
        self._StartDate = None
        self._EndDate = None
        self._Offset = None
        self._Limit = None

    @property
    def BusinessType(self):
        return self._BusinessType

    @BusinessType.setter
    def BusinessType(self, BusinessType):
        self._BusinessType = BusinessType

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def StartDate(self):
        return self._StartDate

    @StartDate.setter
    def StartDate(self, StartDate):
        self._StartDate = StartDate

    @property
    def EndDate(self):
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._BusinessType = params.get("BusinessType")
        self._InstanceId = params.get("InstanceId")
        self._StartDate = params.get("StartDate")
        self._EndDate = params.get("EndDate")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSnapshotFilesResponse(AbstractModel):
    """DescribeSnapshotFiles response structure.

    """

    def __init__(self):
        r"""
        :param _SnapshotFileSet: Snapshot files
        :type SnapshotFileSet: list of SnapshotFileInfo
        :param _TotalCount: The number of eligible objects.
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SnapshotFileSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SnapshotFileSet(self):
        return self._SnapshotFileSet

    @SnapshotFileSet.setter
    def SnapshotFileSet(self, SnapshotFileSet):
        self._SnapshotFileSet = SnapshotFileSet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SnapshotFileSet") is not None:
            self._SnapshotFileSet = []
            for item in params.get("SnapshotFileSet"):
                obj = SnapshotFileInfo()
                obj._deserialize(item)
                self._SnapshotFileSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeSnapshotPoliciesRequest(AbstractModel):
    """DescribeSnapshotPolicies request structure.

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicyIds: Snapshot policy IDs
        :type SnapshotPolicyIds: list of str
        :param _Filters: Filter conditions. `SnapshotPolicyIds` and `Filters` cannot be both specified.
<li>`snapshot-policy-id` - String - Snapshot policy ID</li>
<li>`snapshot-policy-name` - String - Snapshot policy name</li>
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Limit: Number of returned results. Default value: 20. Maximum value: 200.
        :type Limit: int
        """
        self._SnapshotPolicyIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def SnapshotPolicyIds(self):
        return self._SnapshotPolicyIds

    @SnapshotPolicyIds.setter
    def SnapshotPolicyIds(self, SnapshotPolicyIds):
        self._SnapshotPolicyIds = SnapshotPolicyIds

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SnapshotPolicyIds = params.get("SnapshotPolicyIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSnapshotPoliciesResponse(AbstractModel):
    """DescribeSnapshotPolicies response structure.

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicySet: Snapshot policies
        :type SnapshotPolicySet: list of SnapshotPolicy
        :param _TotalCount: The number of eligible objects.
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SnapshotPolicySet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SnapshotPolicySet(self):
        return self._SnapshotPolicySet

    @SnapshotPolicySet.setter
    def SnapshotPolicySet(self, SnapshotPolicySet):
        self._SnapshotPolicySet = SnapshotPolicySet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SnapshotPolicySet") is not None:
            self._SnapshotPolicySet = []
            for item in params.get("SnapshotPolicySet"):
                obj = SnapshotPolicy()
                obj._deserialize(item)
                self._SnapshotPolicySet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeSubnetResourceDashboardRequest(AbstractModel):
    """DescribeSubnetResourceDashboard request structure.

    """

    def __init__(self):
        r"""
        :param _SubnetIds: Subnet instance ID, such as `subnet-f1xjkw1b`.
        :type SubnetIds: list of str
        """
        self._SubnetIds = None

    @property
    def SubnetIds(self):
        return self._SubnetIds

    @SubnetIds.setter
    def SubnetIds(self, SubnetIds):
        self._SubnetIds = SubnetIds


    def _deserialize(self, params):
        self._SubnetIds = params.get("SubnetIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSubnetResourceDashboardResponse(AbstractModel):
    """DescribeSubnetResourceDashboard response structure.

    """

    def __init__(self):
        r"""
        :param _ResourceStatisticsSet: Information of resources returned
        :type ResourceStatisticsSet: list of ResourceStatistics
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ResourceStatisticsSet = None
        self._RequestId = None

    @property
    def ResourceStatisticsSet(self):
        return self._ResourceStatisticsSet

    @ResourceStatisticsSet.setter
    def ResourceStatisticsSet(self, ResourceStatisticsSet):
        self._ResourceStatisticsSet = ResourceStatisticsSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ResourceStatisticsSet") is not None:
            self._ResourceStatisticsSet = []
            for item in params.get("ResourceStatisticsSet"):
                obj = ResourceStatistics()
                obj._deserialize(item)
                self._ResourceStatisticsSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSubnetsRequest(AbstractModel):
    """DescribeSubnets request structure.

    """

    def __init__(self):
        r"""
        :param _SubnetIds: Queries the ID of the subnet instance, such as `subnet-pxir56ns`. Each request can have a maximum of 100 instances. `SubnetIds` and `Filters` cannot be specified at the same time.
        :type SubnetIds: list of str
        :param _Filters: Filter condition. `SubnetIds` and `Filters` cannot be specified at the same time.
<li>subnet-id - String - (Filter condition) Subnet instance name.</li>
<li>vpc-id - String - (Filter condition) VPC instance ID, such as `vpc-f49l6u0z`.</li>
<li>cidr-block - String - (Filter condition) Subnet IP range, such as `192.168.1.0`.</li>
<li>is-default - Boolean - (Filter condition) Whether it is the default subnet.</li>
<li>is-remote-vpc-snat - Boolean - (Filter condition) Whether it is a VPC SNAT address pool subnet.</li>
<li>subnet-name - String - (Filter condition) Subnet name.</li>
<li>zone - String - (Filter condition) Availability zone.</li>
<li> tag-key - String - Required: No - (Filter condition) Filter by tag key.</li>
<li>tag:tag-key - String - Required: No - (Filter condition) Filter by tag key-value pair. Use a specific tag key to replace `tag-key`. For its usage, see example 2.</li>
<li>cdc-id - String - Required: No - (Filter condition) Filter by CDC ID to obtain subnets in the specified CDC.</li>
<li>is-cdc-subnet - String - Required: No - (Filter condition) Whether it is a CDC subnet. Valid values: `0` (no); `1` (yes).</li>
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: 0.
        :type Offset: str
        :param _Limit: Number of returned results. Default value: 20. Maximum value: 100.
        :type Limit: str
        """
        self._SubnetIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def SubnetIds(self):
        return self._SubnetIds

    @SubnetIds.setter
    def SubnetIds(self, SubnetIds):
        self._SubnetIds = SubnetIds

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubnetIds = params.get("SubnetIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSubnetsResponse(AbstractModel):
    """DescribeSubnets response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of instances meeting the filter condition.
        :type TotalCount: int
        :param _SubnetSet: Subnet object.
        :type SubnetSet: list of Subnet
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._SubnetSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SubnetSet(self):
        return self._SubnetSet

    @SubnetSet.setter
    def SubnetSet(self, SubnetSet):
        self._SubnetSet = SubnetSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("SubnetSet") is not None:
            self._SubnetSet = []
            for item in params.get("SubnetSet"):
                obj = Subnet()
                obj._deserialize(item)
                self._SubnetSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTaskResultRequest(AbstractModel):
    """DescribeTaskResult request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Async task ID. Either TaskId or DealName must be entered.
        :type TaskId: int
        :param _DealName: Billing order No. Either TaskId or DealName must be entered.
        :type DealName: str
        """
        self._TaskId = None
        self._DealName = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def DealName(self):
        return self._DealName

    @DealName.setter
    def DealName(self, DealName):
        self._DealName = DealName


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._DealName = params.get("DealName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskResultResponse(AbstractModel):
    """DescribeTaskResult response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Job ID
        :type TaskId: int
        :param _Result: The execution results, including `SUCCESS`, `FAILED`, and `RUNNING`
        :type Result: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._Result = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DescribeTrafficPackagesRequest(AbstractModel):
    """DescribeTrafficPackages request structure.

    """

    def __init__(self):
        r"""
        :param _TrafficPackageIds: Traffic package IDs. Multiple values can be used.
        :type TrafficPackageIds: list of str
        :param _Filters: Each request can have up to 10 `Filters`. `TrafficPackageIds` and `Filters` cannot be specified at the same time. The specific filter conditions are as follows:
<li> `traffic-package_id` - String - Optional - Filter by the traffic package ID.</li>
<li> `traffic-package-name` - String - Optional - Filter by the traffic package name. Fuzzy match is not supported.</li>
<li> `status` - String - Optional - Filter by the traffic package status. Values: [AVAILABLE|EXPIRED|EXHAUSTED].</li>
        :type Filters: list of Filter
        :param _Offset: Pagination parameter
        :type Offset: int
        :param _Limit: Pagination parameter
        :type Limit: int
        """
        self._TrafficPackageIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def TrafficPackageIds(self):
        return self._TrafficPackageIds

    @TrafficPackageIds.setter
    def TrafficPackageIds(self, TrafficPackageIds):
        self._TrafficPackageIds = TrafficPackageIds

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._TrafficPackageIds = params.get("TrafficPackageIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTrafficPackagesResponse(AbstractModel):
    """DescribeTrafficPackages response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible traffic packages
        :type TotalCount: int
        :param _TrafficPackageSet: Traffic package information
        :type TrafficPackageSet: list of TrafficPackage
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._TrafficPackageSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TrafficPackageSet(self):
        return self._TrafficPackageSet

    @TrafficPackageSet.setter
    def TrafficPackageSet(self, TrafficPackageSet):
        self._TrafficPackageSet = TrafficPackageSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("TrafficPackageSet") is not None:
            self._TrafficPackageSet = []
            for item in params.get("TrafficPackageSet"):
                obj = TrafficPackage()
                obj._deserialize(item)
                self._TrafficPackageSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeUsedIpAddressRequest(AbstractModel):
    """DescribeUsedIpAddress request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC instance ID.
        :type VpcId: str
        :param _SubnetId: Subnet instance ID
        :type SubnetId: str
        :param _IpAddresses: List of IPs to be queried. The IPs must be within the VPC or subnet. Up to 100 IPs can be queried at a time.
        :type IpAddresses: list of str
        :param _Offset: The offset. Default value: 0
        :type Offset: int
        :param _Limit: The number of returned results. Default value: 20. Maximum value: 100.
        :type Limit: int
        """
        self._VpcId = None
        self._SubnetId = None
        self._IpAddresses = None
        self._Offset = None
        self._Limit = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def IpAddresses(self):
        return self._IpAddresses

    @IpAddresses.setter
    def IpAddresses(self, IpAddresses):
        self._IpAddresses = IpAddresses

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._IpAddresses = params.get("IpAddresses")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUsedIpAddressResponse(AbstractModel):
    """DescribeUsedIpAddress response structure.

    """

    def __init__(self):
        r"""
        :param _IpAddressStates: Information of resources bound with the queried IPs 
Note: This parameter may return null, indicating that no valid values can be obtained.
        :type IpAddressStates: list of IpAddressStates
        :param _TotalCount: Number of taken IPs 
Note: This parameter may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._IpAddressStates = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def IpAddressStates(self):
        return self._IpAddressStates

    @IpAddressStates.setter
    def IpAddressStates(self, IpAddressStates):
        self._IpAddressStates = IpAddressStates

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("IpAddressStates") is not None:
            self._IpAddressStates = []
            for item in params.get("IpAddressStates"):
                obj = IpAddressStates()
                obj._deserialize(item)
                self._IpAddressStates.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeVpcEndPointRequest(AbstractModel):
    """DescribeVpcEndPoint request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter condition
<li> end-point-service-id - String - (Filter condition) Endpoint service ID.</li>
<li>end-point-name - String - (Filter condition) Endpoint instance name.</li>
<li> end-point-id - String - (Filter condition) Endpoint instance ID.</li>
<li> vpc-id - String - (Filter condition) VPC instance ID.</li>
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of results per page; default value: 20; maximum value: 100.
        :type Limit: int
        :param _EndPointId: Endpoint ID list
        :type EndPointId: list of str
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._EndPointId = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def EndPointId(self):
        return self._EndPointId

    @EndPointId.setter
    def EndPointId(self, EndPointId):
        self._EndPointId = EndPointId


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._EndPointId = params.get("EndPointId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcEndPointResponse(AbstractModel):
    """DescribeVpcEndPoint response structure.

    """

    def __init__(self):
        r"""
        :param _EndPointSet: Endpoint
        :type EndPointSet: list of EndPoint
        :param _TotalCount: Number of matched endpoints
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._EndPointSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def EndPointSet(self):
        return self._EndPointSet

    @EndPointSet.setter
    def EndPointSet(self, EndPointSet):
        self._EndPointSet = EndPointSet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EndPointSet") is not None:
            self._EndPointSet = []
            for item in params.get("EndPointSet"):
                obj = EndPoint()
                obj._deserialize(item)
                self._EndPointSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeVpcEndPointServiceRequest(AbstractModel):
    """DescribeVpcEndPointService request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filters. `EndPointServiceIds` and `Filters` cannot be both passed in. 
<li>`service-id` - String - Unique endpoint service ID. </li>
<li>`service-name` - String - Endpoint service instance name. </li>
<li>`service-instance-id` - String - Unique backend service ID in the format of `lb-xxx`. </li>
<li>`service-type` - String - Backend PaaS service type. It can be `CLB`, `CDB` or `CRS`. It defaults to `CLB` if not specified. </li>
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of results per page; default value: 20; maximum value: 100.
        :type Limit: int
        :param _EndPointServiceIds: Endpoint service ID `EndPointServiceIds` and `Filters` cannot be both passed in. 
        :type EndPointServiceIds: list of str
        :param _IsListAuthorizedEndPointService: 
        :type IsListAuthorizedEndPointService: bool
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._EndPointServiceIds = None
        self._IsListAuthorizedEndPointService = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def EndPointServiceIds(self):
        return self._EndPointServiceIds

    @EndPointServiceIds.setter
    def EndPointServiceIds(self, EndPointServiceIds):
        self._EndPointServiceIds = EndPointServiceIds

    @property
    def IsListAuthorizedEndPointService(self):
        return self._IsListAuthorizedEndPointService

    @IsListAuthorizedEndPointService.setter
    def IsListAuthorizedEndPointService(self, IsListAuthorizedEndPointService):
        self._IsListAuthorizedEndPointService = IsListAuthorizedEndPointService


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._EndPointServiceIds = params.get("EndPointServiceIds")
        self._IsListAuthorizedEndPointService = params.get("IsListAuthorizedEndPointService")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcEndPointServiceResponse(AbstractModel):
    """DescribeVpcEndPointService response structure.

    """

    def __init__(self):
        r"""
        :param _EndPointServiceSet: Array of endpoint services
        :type EndPointServiceSet: list of EndPointService
        :param _TotalCount: Number of matched results
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._EndPointServiceSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def EndPointServiceSet(self):
        return self._EndPointServiceSet

    @EndPointServiceSet.setter
    def EndPointServiceSet(self, EndPointServiceSet):
        self._EndPointServiceSet = EndPointServiceSet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EndPointServiceSet") is not None:
            self._EndPointServiceSet = []
            for item in params.get("EndPointServiceSet"):
                obj = EndPointService()
                obj._deserialize(item)
                self._EndPointServiceSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeVpcEndPointServiceWhiteListRequest(AbstractModel):
    """DescribeVpcEndPointServiceWhiteList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of results per page; default value: 20; maximum value: 100.
        :type Limit: int
        :param _Filters: Filter condition
<li> user-uin - String - (Filter condition) UIN.</li>
<li> end-point-service-id - String - (Filter condition) Endpoint service ID.</li>
        :type Filters: list of Filter
        """
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcEndPointServiceWhiteListResponse(AbstractModel):
    """DescribeVpcEndPointServiceWhiteList response structure.

    """

    def __init__(self):
        r"""
        :param _VpcEndpointServiceUserSet: Array of allowed endpoint services
        :type VpcEndpointServiceUserSet: list of VpcEndPointServiceUser
        :param _TotalCount: Number of matched allowlists
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._VpcEndpointServiceUserSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def VpcEndpointServiceUserSet(self):
        return self._VpcEndpointServiceUserSet

    @VpcEndpointServiceUserSet.setter
    def VpcEndpointServiceUserSet(self, VpcEndpointServiceUserSet):
        self._VpcEndpointServiceUserSet = VpcEndpointServiceUserSet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("VpcEndpointServiceUserSet") is not None:
            self._VpcEndpointServiceUserSet = []
            for item in params.get("VpcEndpointServiceUserSet"):
                obj = VpcEndPointServiceUser()
                obj._deserialize(item)
                self._VpcEndpointServiceUserSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeVpcInstancesRequest(AbstractModel):
    """DescribeVpcInstances request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter condition. `RouteTableIds` and `Filters` cannot be specified at the same time.
<li>vpc-id - String - (Filter condition) VPC instance ID, such as `vpc-f49l6u0z`.</li>
<li>instance-type - String - (Filter condition) CVM instance ID.</li>
<li>instance-name - String - (Filter condition) CVM name.</li>
        :type Filters: list of Filter
        :param _Offset: Offset.
        :type Offset: int
        :param _Limit: The number of requested objects.
        :type Limit: int
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcInstancesResponse(AbstractModel):
    """DescribeVpcInstances response structure.

    """

    def __init__(self):
        r"""
        :param _InstanceSet: List of CVM instances.
        :type InstanceSet: list of CvmInstance
        :param _TotalCount: The number of eligible CVM instances.
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._InstanceSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def InstanceSet(self):
        return self._InstanceSet

    @InstanceSet.setter
    def InstanceSet(self, InstanceSet):
        self._InstanceSet = InstanceSet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("InstanceSet") is not None:
            self._InstanceSet = []
            for item in params.get("InstanceSet"):
                obj = CvmInstance()
                obj._deserialize(item)
                self._InstanceSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeVpcIpv6AddressesRequest(AbstractModel):
    """DescribeVpcIpv6Addresses request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: The `ID` of the `VPC`, such as `vpc-f49l6u0z`.
        :type VpcId: str
        :param _Ipv6Addresses: The `IP` address list. Each request supports a maximum of `10` batch querying.
        :type Ipv6Addresses: list of str
        :param _Offset: Offset.
        :type Offset: int
        :param _Limit: The returned quantity.
        :type Limit: int
        """
        self._VpcId = None
        self._Ipv6Addresses = None
        self._Offset = None
        self._Limit = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def Ipv6Addresses(self):
        return self._Ipv6Addresses

    @Ipv6Addresses.setter
    def Ipv6Addresses(self, Ipv6Addresses):
        self._Ipv6Addresses = Ipv6Addresses

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._Ipv6Addresses = params.get("Ipv6Addresses")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcIpv6AddressesResponse(AbstractModel):
    """DescribeVpcIpv6Addresses response structure.

    """

    def __init__(self):
        r"""
        :param _Ipv6AddressSet: The `IPv6` address list.
        :type Ipv6AddressSet: list of VpcIpv6Address
        :param _TotalCount: The total number of `IPv6` addresses.
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Ipv6AddressSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def Ipv6AddressSet(self):
        return self._Ipv6AddressSet

    @Ipv6AddressSet.setter
    def Ipv6AddressSet(self, Ipv6AddressSet):
        self._Ipv6AddressSet = Ipv6AddressSet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Ipv6AddressSet") is not None:
            self._Ipv6AddressSet = []
            for item in params.get("Ipv6AddressSet"):
                obj = VpcIpv6Address()
                obj._deserialize(item)
                self._Ipv6AddressSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeVpcPrivateIpAddressesRequest(AbstractModel):
    """DescribeVpcPrivateIpAddresses request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: The `ID` of the `VPC`, such as `vpc-f49l6u0z`.
        :type VpcId: str
        :param _PrivateIpAddresses: The private `IP` address list. Each request supports a maximum of `10` batch querying.
        :type PrivateIpAddresses: list of str
        """
        self._VpcId = None
        self._PrivateIpAddresses = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def PrivateIpAddresses(self):
        return self._PrivateIpAddresses

    @PrivateIpAddresses.setter
    def PrivateIpAddresses(self, PrivateIpAddresses):
        self._PrivateIpAddresses = PrivateIpAddresses


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._PrivateIpAddresses = params.get("PrivateIpAddresses")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcPrivateIpAddressesResponse(AbstractModel):
    """DescribeVpcPrivateIpAddresses response structure.

    """

    def __init__(self):
        r"""
        :param _VpcPrivateIpAddressSet: The list of private `IP` address information.
        :type VpcPrivateIpAddressSet: list of VpcPrivateIpAddress
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._VpcPrivateIpAddressSet = None
        self._RequestId = None

    @property
    def VpcPrivateIpAddressSet(self):
        return self._VpcPrivateIpAddressSet

    @VpcPrivateIpAddressSet.setter
    def VpcPrivateIpAddressSet(self, VpcPrivateIpAddressSet):
        self._VpcPrivateIpAddressSet = VpcPrivateIpAddressSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("VpcPrivateIpAddressSet") is not None:
            self._VpcPrivateIpAddressSet = []
            for item in params.get("VpcPrivateIpAddressSet"):
                obj = VpcPrivateIpAddress()
                obj._deserialize(item)
                self._VpcPrivateIpAddressSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeVpcResourceDashboardRequest(AbstractModel):
    """DescribeVpcResourceDashboard request structure.

    """

    def __init__(self):
        r"""
        :param _VpcIds: Vpc instance ID, e.g. vpc-f1xjkw1b.
        :type VpcIds: list of str
        """
        self._VpcIds = None

    @property
    def VpcIds(self):
        return self._VpcIds

    @VpcIds.setter
    def VpcIds(self, VpcIds):
        self._VpcIds = VpcIds


    def _deserialize(self, params):
        self._VpcIds = params.get("VpcIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcResourceDashboardResponse(AbstractModel):
    """DescribeVpcResourceDashboard response structure.

    """

    def __init__(self):
        r"""
        :param _ResourceDashboardSet: List of resource objects.
        :type ResourceDashboardSet: list of ResourceDashboard
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ResourceDashboardSet = None
        self._RequestId = None

    @property
    def ResourceDashboardSet(self):
        return self._ResourceDashboardSet

    @ResourceDashboardSet.setter
    def ResourceDashboardSet(self, ResourceDashboardSet):
        self._ResourceDashboardSet = ResourceDashboardSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ResourceDashboardSet") is not None:
            self._ResourceDashboardSet = []
            for item in params.get("ResourceDashboardSet"):
                obj = ResourceDashboard()
                obj._deserialize(item)
                self._ResourceDashboardSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeVpcTaskResultRequest(AbstractModel):
    """DescribeVpcTaskResult request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: `RequestId` returned by an async task
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcTaskResultResponse(AbstractModel):
    """DescribeVpcTaskResult response structure.

    """

    def __init__(self):
        r"""
        :param _Status: The execution results of an async task. Valid values: `SUCCESS`(task executed successfully), `FAILED` (task execution failed), and `RUNNING` (task in progress). 
        :type Status: str
        :param _Output: Output of the async task execution result
        :type Output: str
        :param _Result: Detailed result of an async task, such as the result of batch deleting ENIs.
Note: this field may return `null`, indicating that no valid value can be obtained.
        :type Result: list of VpcTaskResultDetailInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Status = None
        self._Output = None
        self._Result = None
        self._RequestId = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._Output = params.get("Output")
        if params.get("Result") is not None:
            self._Result = []
            for item in params.get("Result"):
                obj = VpcTaskResultDetailInfo()
                obj._deserialize(item)
                self._Result.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeVpcsRequest(AbstractModel):
    """DescribeVpcs request structure.

    """

    def __init__(self):
        r"""
        :param _VpcIds: The VPC instance ID, such as `vpc-f49l6u0z`. Each request supports a maximum of 100 instances. `VpcIds` and `Filters` cannot be specified at the same time.
        :type VpcIds: list of str
        :param _Filters: Filter condition. `VpcIds` and `Filters` cannot be specified at the same time.
Valid filters include:
<li>`vpc-name`: VPC instance name, which supports fuzzy search.</li>
<li>`is-default`: Indicates whether it is the default VPC</li>
<li>`vpc-id`: VPC instance ID, such as `vpc-f49l6u0z`</li>
<li>`cidr-block`: VPC CIDR block</li>
<li>`tag-key`: (Optional) tag key</li>
<li>`tag:tag-key`: (Optional) tag key-value pair. Replace the `tag-key` with a specified tag value. For its usage, refer to Example 2.</li>
  **Note:** If one filter has multiple values, the logical relationship between these values is `OR`. The logical relationship between filters is `AND`.
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: 0.
        :type Offset: str
        :param _Limit: Number of returned results. Default value: 20. Maximum value: 100.
        :type Limit: str
        """
        self._VpcIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def VpcIds(self):
        return self._VpcIds

    @VpcIds.setter
    def VpcIds(self, VpcIds):
        self._VpcIds = VpcIds

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._VpcIds = params.get("VpcIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcsResponse(AbstractModel):
    """DescribeVpcs response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of objects meeting the condition.
        :type TotalCount: int
        :param _VpcSet: The VPC object.
        :type VpcSet: list of Vpc
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._VpcSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def VpcSet(self):
        return self._VpcSet

    @VpcSet.setter
    def VpcSet(self, VpcSet):
        self._VpcSet = VpcSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("VpcSet") is not None:
            self._VpcSet = []
            for item in params.get("VpcSet"):
                obj = Vpc()
                obj._deserialize(item)
                self._VpcSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeVpnConnectionsRequest(AbstractModel):
    """DescribeVpnConnections request structure.

    """

    def __init__(self):
        r"""
        :param _VpnConnectionIds: The instance ID of the VPN tunnel, such as `vpnx-f49l6u0z`. Each request can have a maximum of 100 instances. `VpnConnectionIds` and `Filters` cannot be specified at the same time.
        :type VpnConnectionIds: list of str
        :param _Filters: Filter condition. In each request, the upper limit for `Filters` is 10 and 5 for `Filter.Values`. `VpnConnectionIds` and `Filters` cannot be specified at the same time.
<li>vpc-id - String - VPC instance ID, such as `vpc-0a36uwkr`.</li>
<li>vpn-gateway-id - String - VPN gateway instance ID, such as `vpngw-p4lmqawn`.</li>
<li>customer-gateway-id - String - Customer gateway instance ID, such as `cgw-l4rblw63`.</li>
<li>vpn-connection-name - String - Connection name, such as `test-vpn`.</li>
<li>vpn-connection-id - String - Connection instance ID, such as `vpnx-5p7vkch8"`.</li>
        :type Filters: list of Filter
        :param _Offset: The Offset. The default value is 0. For more information about Offset, see the relevant section in the API Introduction.
        :type Offset: int
        :param _Limit: Number of values to be returned. The default value is 20. Maximum is 100.
        :type Limit: int
        """
        self._VpnConnectionIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def VpnConnectionIds(self):
        return self._VpnConnectionIds

    @VpnConnectionIds.setter
    def VpnConnectionIds(self, VpnConnectionIds):
        self._VpnConnectionIds = VpnConnectionIds

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._VpnConnectionIds = params.get("VpnConnectionIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpnConnectionsResponse(AbstractModel):
    """DescribeVpnConnections response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of instances meeting the filter condition.
        :type TotalCount: int
        :param _VpnConnectionSet: VPN tunnel instance.
        :type VpnConnectionSet: list of VpnConnection
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._VpnConnectionSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def VpnConnectionSet(self):
        return self._VpnConnectionSet

    @VpnConnectionSet.setter
    def VpnConnectionSet(self, VpnConnectionSet):
        self._VpnConnectionSet = VpnConnectionSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("VpnConnectionSet") is not None:
            self._VpnConnectionSet = []
            for item in params.get("VpnConnectionSet"):
                obj = VpnConnection()
                obj._deserialize(item)
                self._VpnConnectionSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeVpnGatewayCcnRoutesRequest(AbstractModel):
    """DescribeVpnGatewayCcnRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: Instance ID of the VPN gateway
        :type VpnGatewayId: str
        :param _Offset: Offset.
        :type Offset: int
        :param _Limit: The returned quantity
        :type Limit: int
        """
        self._VpnGatewayId = None
        self._Offset = None
        self._Limit = None

    @property
    def VpnGatewayId(self):
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpnGatewayCcnRoutesResponse(AbstractModel):
    """DescribeVpnGatewayCcnRoutes response structure.

    """

    def __init__(self):
        r"""
        :param _RouteSet: The CCN route (IDC IP range) list.
        :type RouteSet: list of VpngwCcnRoutes
        :param _TotalCount: Number of objects that meet the condition.
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RouteSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def RouteSet(self):
        return self._RouteSet

    @RouteSet.setter
    def RouteSet(self, RouteSet):
        self._RouteSet = RouteSet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RouteSet") is not None:
            self._RouteSet = []
            for item in params.get("RouteSet"):
                obj = VpngwCcnRoutes()
                obj._deserialize(item)
                self._RouteSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeVpnGatewayRoutesRequest(AbstractModel):
    """DescribeVpnGatewayRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: Instance ID of the VPN gateway
        :type VpnGatewayId: str
        :param _Filters: Filter condition. Valid values: `DestinationCidr`, `InstanceId`, and `InstanceType`.
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: 0
        :type Offset: int
        :param _Limit: Number of returned results per page. Default value: 20; maximum value: 100
        :type Limit: int
        """
        self._VpnGatewayId = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def VpnGatewayId(self):
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpnGatewayRoutesResponse(AbstractModel):
    """DescribeVpnGatewayRoutes response structure.

    """

    def __init__(self):
        r"""
        :param _Routes: Destination routes of the VPN gateway
        :type Routes: list of VpnGatewayRoute
        :param _TotalCount: 
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Routes = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def Routes(self):
        return self._Routes

    @Routes.setter
    def Routes(self, Routes):
        self._Routes = Routes

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Routes") is not None:
            self._Routes = []
            for item in params.get("Routes"):
                obj = VpnGatewayRoute()
                obj._deserialize(item)
                self._Routes.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeVpnGatewaysRequest(AbstractModel):
    """DescribeVpnGateways request structure.

    """

    def __init__(self):
        r"""
        :param _VpnGatewayIds: The VPN gateway instance ID, such as `vpngw-f49l6u0z`. Each request can have a maximum of 100 instances. `VpnGatewayIds` and `Filters` cannot be specified at the same time.
        :type VpnGatewayIds: list of str
        :param _Filters: Filter condition. `VpnGatewayIds` and `Filters` cannot be specified at the same time.
<li>vpc-id - String - (Filter condition) VPC instance ID, such as `vpc-f49l6u0z`.</li>
<li>vpn-gateway-id - String - (Filter condition) VPN instance ID, such as `vpngw-5aluhh9t`.</li>
<li>vpn-gateway-name - String - (Filter condition) VPN instance name.</li>
<li>type - String - (Filter condition) VPN gateway type: 'IPSEC', 'SSL'.</li>
<li>public-ip-address- String - (Filter condition) Public IP.</li>
<li>renew-flag - String - (Filter condition) Gateway renewal type. Manual renewal: `NOTIFY_AND_MANUAL_RENEW`, Automatic renewal: `NOTIFY_AND_AUTO_RENEW`.</li>
<li>zone - String - (Filter condition) The availability zone where the VPN is located, such as `ap-guangzhou-2`.</li>
        :type Filters: list of FilterObject
        :param _Offset: Offset
        :type Offset: int
        :param _Limit: The number of request objects.
        :type Limit: int
        """
        self._VpnGatewayIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def VpnGatewayIds(self):
        return self._VpnGatewayIds

    @VpnGatewayIds.setter
    def VpnGatewayIds(self, VpnGatewayIds):
        self._VpnGatewayIds = VpnGatewayIds

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._VpnGatewayIds = params.get("VpnGatewayIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FilterObject()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpnGatewaysResponse(AbstractModel):
    """DescribeVpnGateways response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of instances meeting the filter condition.
        :type TotalCount: int
        :param _VpnGatewaySet: The list of details of VPN gateway instances.
        :type VpnGatewaySet: list of VpnGateway
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._VpnGatewaySet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def VpnGatewaySet(self):
        return self._VpnGatewaySet

    @VpnGatewaySet.setter
    def VpnGatewaySet(self, VpnGatewaySet):
        self._VpnGatewaySet = VpnGatewaySet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("VpnGatewaySet") is not None:
            self._VpnGatewaySet = []
            for item in params.get("VpnGatewaySet"):
                obj = VpnGateway()
                obj._deserialize(item)
                self._VpnGatewaySet.append(obj)
        self._RequestId = params.get("RequestId")


class DestinationIpPortTranslationNatRule(AbstractModel):
    """The port forwarding rules of the NAT gateway

    """

    def __init__(self):
        r"""
        :param _IpProtocol: Network protocol. Valid values: `TCP`, `UDP`.
        :type IpProtocol: str
        :param _PublicIpAddress: EIP.
        :type PublicIpAddress: str
        :param _PublicPort: Public network port.
        :type PublicPort: int
        :param _PrivateIpAddress: Private network address.
        :type PrivateIpAddress: str
        :param _PrivatePort: Private network port.
        :type PrivatePort: int
        :param _Description: Description of NAT gateway forwarding rules.
        :type Description: str
        """
        self._IpProtocol = None
        self._PublicIpAddress = None
        self._PublicPort = None
        self._PrivateIpAddress = None
        self._PrivatePort = None
        self._Description = None

    @property
    def IpProtocol(self):
        return self._IpProtocol

    @IpProtocol.setter
    def IpProtocol(self, IpProtocol):
        self._IpProtocol = IpProtocol

    @property
    def PublicIpAddress(self):
        return self._PublicIpAddress

    @PublicIpAddress.setter
    def PublicIpAddress(self, PublicIpAddress):
        self._PublicIpAddress = PublicIpAddress

    @property
    def PublicPort(self):
        return self._PublicPort

    @PublicPort.setter
    def PublicPort(self, PublicPort):
        self._PublicPort = PublicPort

    @property
    def PrivateIpAddress(self):
        return self._PrivateIpAddress

    @PrivateIpAddress.setter
    def PrivateIpAddress(self, PrivateIpAddress):
        self._PrivateIpAddress = PrivateIpAddress

    @property
    def PrivatePort(self):
        return self._PrivatePort

    @PrivatePort.setter
    def PrivatePort(self, PrivatePort):
        self._PrivatePort = PrivatePort

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._IpProtocol = params.get("IpProtocol")
        self._PublicIpAddress = params.get("PublicIpAddress")
        self._PublicPort = params.get("PublicPort")
        self._PrivateIpAddress = params.get("PrivateIpAddress")
        self._PrivatePort = params.get("PrivatePort")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DetachCcnInstancesRequest(AbstractModel):
    """DetachCcnInstances request structure.

    """

    def __init__(self):
        r"""
        :param _CcnId: The CCN instance ID, such as `ccn-f49l6u0z`.
        :type CcnId: str
        :param _Instances: The list of network instances to be unbound
        :type Instances: list of CcnInstance
        """
        self._CcnId = None
        self._Instances = None

    @property
    def CcnId(self):
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def Instances(self):
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = CcnInstance()
                obj._deserialize(item)
                self._Instances.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DetachCcnInstancesResponse(AbstractModel):
    """DetachCcnInstances response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DetachClassicLinkVpcRequest(AbstractModel):
    """DetachClassicLinkVpc request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: The ID of the VPC instance. You can obtain the parameter value from the VpcId field in the returned result of DescribeVpcs API.
        :type VpcId: str
        :param _InstanceIds: Queries the ID of the CVM instance, such as `ins-r8hr2upy`.
        :type InstanceIds: list of str
        """
        self._VpcId = None
        self._InstanceIds = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def InstanceIds(self):
        return self._InstanceIds

    @InstanceIds.setter
    def InstanceIds(self, InstanceIds):
        self._InstanceIds = InstanceIds


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._InstanceIds = params.get("InstanceIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DetachClassicLinkVpcResponse(AbstractModel):
    """DetachClassicLinkVpc response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DetachNetworkInterfaceRequest(AbstractModel):
    """DetachNetworkInterface request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkInterfaceId: The ID of the ENI instance, such as `eni-m6dyj72l`.
        :type NetworkInterfaceId: str
        :param _InstanceId: The ID of the CVM instance, such as `ins-r8hr2upy`.
        :type InstanceId: str
        """
        self._NetworkInterfaceId = None
        self._InstanceId = None

    @property
    def NetworkInterfaceId(self):
        return self._NetworkInterfaceId

    @NetworkInterfaceId.setter
    def NetworkInterfaceId(self, NetworkInterfaceId):
        self._NetworkInterfaceId = NetworkInterfaceId

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._NetworkInterfaceId = params.get("NetworkInterfaceId")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DetachNetworkInterfaceResponse(AbstractModel):
    """DetachNetworkInterface response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DetachSnapshotInstancesRequest(AbstractModel):
    """DetachSnapshotInstances request structure.

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicyId: Snapshot policy IDs
        :type SnapshotPolicyId: str
        :param _Instances: Information of instances
        :type Instances: list of SnapshotInstance
        """
        self._SnapshotPolicyId = None
        self._Instances = None

    @property
    def SnapshotPolicyId(self):
        return self._SnapshotPolicyId

    @SnapshotPolicyId.setter
    def SnapshotPolicyId(self, SnapshotPolicyId):
        self._SnapshotPolicyId = SnapshotPolicyId

    @property
    def Instances(self):
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances


    def _deserialize(self, params):
        self._SnapshotPolicyId = params.get("SnapshotPolicyId")
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = SnapshotInstance()
                obj._deserialize(item)
                self._Instances.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DetachSnapshotInstancesResponse(AbstractModel):
    """DetachSnapshotInstances response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DirectConnectGateway(AbstractModel):
    """Direct Connect gateway object.

    """

    def __init__(self):
        r"""
        :param _DirectConnectGatewayId: Direct Connect `ID`.
        :type DirectConnectGatewayId: str
        :param _DirectConnectGatewayName: Direct Connect gateway name.
        :type DirectConnectGatewayName: str
        :param _VpcId: The `ID` of the `VPC` instance associated with the Direct Connect gateway.
        :type VpcId: str
        :param _NetworkType: The associated network type:
<li>`VPC` - VPC</li>
<li>`CCN` - CCN</li>
        :type NetworkType: str
        :param _NetworkInstanceId: The `ID` of the associated network instance:
<li>When the NetworkType is `VPC`, this value is the VPC instance `ID`</li>
<li>When the NetworkType is `CCN`, this value is the CCN instance `ID`</li>
        :type NetworkInstanceId: str
        :param _GatewayType: Gateway type:
<li>NORMAL - Standard type. Note: CCN only supports the standard type</li>
<li>NAT - NAT type</li>
NAT type supports network address switch configuration. After the type is confirmed, it cannot be modified. A VPC can create one NAT-type Direct Connect gateway and one non-NAT-type Direct Connect gateway
        :type GatewayType: str
        :param _CreateTime: Creation Time.
        :type CreateTime: str
        :param _DirectConnectGatewayIp: Direct Connect gateway IP.
        :type DirectConnectGatewayIp: str
        :param _CcnId: The `ID` of the `CCN` instance associated with the Direct Connect gateway.
        :type CcnId: str
        :param _CcnRouteType: The route-learning type of the CCN:
<li>`BGP` - Automatic learning.</li>
<li>`STATIC` - Static, that is, user-configured.</li>
        :type CcnRouteType: str
        :param _EnableBGP: Whether BGP is enabled.
        :type EnableBGP: bool
        :param _EnableBGPCommunity: Whether to enable BGP's `community` attribute. Valid values: enable, disable
        :type EnableBGPCommunity: bool
        :param _NatGatewayId: ID of the NAT gateway bound.
Note: this field may return `null`, indicating that no valid value was found.
        :type NatGatewayId: str
        :param _VXLANSupport: Whether the direct connect gateway supports the VXLAN architecture.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type VXLANSupport: list of bool
        :param _ModeType: CCN route publishing mode. Valid values: `standard` and `exquisite`.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type ModeType: str
        :param _LocalZone: Whether the direct connect gateway is for an edge zone.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type LocalZone: bool
        :param _Zone: Availability zone where the direct connect gateway resides.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type Zone: str
        :param _EnableFlowDetails: The status of gateway traffic monitoring
0: disable
1: enable
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type EnableFlowDetails: int
        :param _FlowDetailsUpdateTime: The last time when the gateway traffic monitoring is enabled/disabled
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type FlowDetailsUpdateTime: str
        :param _NewAfc: Whether gateway traffic monitoring is supported
0: No
1: Yes
Note: this field may return `null`, indicating that no valid values can be found.
        :type NewAfc: int
        :param _AccessNetworkType: Direct connect gateway access network types:
<li>`VXLAN` - VXLAN type.</li>
<li>`MPLS` - MPLS type.</li>
<li>`Hybrid` - Hybrid type.</li>
Note: this field may return `null`, indicating that no valid values can be found.
        :type AccessNetworkType: str
        :param _HaZoneList: AZ list of direct connect gateway with cross-AZ placement groups
Note: this field may return `null`, indicating that no valid values can be found.
        :type HaZoneList: list of str
        """
        self._DirectConnectGatewayId = None
        self._DirectConnectGatewayName = None
        self._VpcId = None
        self._NetworkType = None
        self._NetworkInstanceId = None
        self._GatewayType = None
        self._CreateTime = None
        self._DirectConnectGatewayIp = None
        self._CcnId = None
        self._CcnRouteType = None
        self._EnableBGP = None
        self._EnableBGPCommunity = None
        self._NatGatewayId = None
        self._VXLANSupport = None
        self._ModeType = None
        self._LocalZone = None
        self._Zone = None
        self._EnableFlowDetails = None
        self._FlowDetailsUpdateTime = None
        self._NewAfc = None
        self._AccessNetworkType = None
        self._HaZoneList = None

    @property
    def DirectConnectGatewayId(self):
        return self._DirectConnectGatewayId

    @DirectConnectGatewayId.setter
    def DirectConnectGatewayId(self, DirectConnectGatewayId):
        self._DirectConnectGatewayId = DirectConnectGatewayId

    @property
    def DirectConnectGatewayName(self):
        return self._DirectConnectGatewayName

    @DirectConnectGatewayName.setter
    def DirectConnectGatewayName(self, DirectConnectGatewayName):
        self._DirectConnectGatewayName = DirectConnectGatewayName

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def NetworkType(self):
        return self._NetworkType

    @NetworkType.setter
    def NetworkType(self, NetworkType):
        self._NetworkType = NetworkType

    @property
    def NetworkInstanceId(self):
        return self._NetworkInstanceId

    @NetworkInstanceId.setter
    def NetworkInstanceId(self, NetworkInstanceId):
        self._NetworkInstanceId = NetworkInstanceId

    @property
    def GatewayType(self):
        return self._GatewayType

    @GatewayType.setter
    def GatewayType(self, GatewayType):
        self._GatewayType = GatewayType

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def DirectConnectGatewayIp(self):
        return self._DirectConnectGatewayIp

    @DirectConnectGatewayIp.setter
    def DirectConnectGatewayIp(self, DirectConnectGatewayIp):
        self._DirectConnectGatewayIp = DirectConnectGatewayIp

    @property
    def CcnId(self):
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def CcnRouteType(self):
        return self._CcnRouteType

    @CcnRouteType.setter
    def CcnRouteType(self, CcnRouteType):
        self._CcnRouteType = CcnRouteType

    @property
    def EnableBGP(self):
        return self._EnableBGP

    @EnableBGP.setter
    def EnableBGP(self, EnableBGP):
        self._EnableBGP = EnableBGP

    @property
    def EnableBGPCommunity(self):
        return self._EnableBGPCommunity

    @EnableBGPCommunity.setter
    def EnableBGPCommunity(self, EnableBGPCommunity):
        self._EnableBGPCommunity = EnableBGPCommunity

    @property
    def NatGatewayId(self):
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def VXLANSupport(self):
        return self._VXLANSupport

    @VXLANSupport.setter
    def VXLANSupport(self, VXLANSupport):
        self._VXLANSupport = VXLANSupport

    @property
    def ModeType(self):
        return self._ModeType

    @ModeType.setter
    def ModeType(self, ModeType):
        self._ModeType = ModeType

    @property
    def LocalZone(self):
        return self._LocalZone

    @LocalZone.setter
    def LocalZone(self, LocalZone):
        self._LocalZone = LocalZone

    @property
    def Zone(self):
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def EnableFlowDetails(self):
        return self._EnableFlowDetails

    @EnableFlowDetails.setter
    def EnableFlowDetails(self, EnableFlowDetails):
        self._EnableFlowDetails = EnableFlowDetails

    @property
    def FlowDetailsUpdateTime(self):
        return self._FlowDetailsUpdateTime

    @FlowDetailsUpdateTime.setter
    def FlowDetailsUpdateTime(self, FlowDetailsUpdateTime):
        self._FlowDetailsUpdateTime = FlowDetailsUpdateTime

    @property
    def NewAfc(self):
        return self._NewAfc

    @NewAfc.setter
    def NewAfc(self, NewAfc):
        self._NewAfc = NewAfc

    @property
    def AccessNetworkType(self):
        return self._AccessNetworkType

    @AccessNetworkType.setter
    def AccessNetworkType(self, AccessNetworkType):
        self._AccessNetworkType = AccessNetworkType

    @property
    def HaZoneList(self):
        return self._HaZoneList

    @HaZoneList.setter
    def HaZoneList(self, HaZoneList):
        self._HaZoneList = HaZoneList


    def _deserialize(self, params):
        self._DirectConnectGatewayId = params.get("DirectConnectGatewayId")
        self._DirectConnectGatewayName = params.get("DirectConnectGatewayName")
        self._VpcId = params.get("VpcId")
        self._NetworkType = params.get("NetworkType")
        self._NetworkInstanceId = params.get("NetworkInstanceId")
        self._GatewayType = params.get("GatewayType")
        self._CreateTime = params.get("CreateTime")
        self._DirectConnectGatewayIp = params.get("DirectConnectGatewayIp")
        self._CcnId = params.get("CcnId")
        self._CcnRouteType = params.get("CcnRouteType")
        self._EnableBGP = params.get("EnableBGP")
        self._EnableBGPCommunity = params.get("EnableBGPCommunity")
        self._NatGatewayId = params.get("NatGatewayId")
        self._VXLANSupport = params.get("VXLANSupport")
        self._ModeType = params.get("ModeType")
        self._LocalZone = params.get("LocalZone")
        self._Zone = params.get("Zone")
        self._EnableFlowDetails = params.get("EnableFlowDetails")
        self._FlowDetailsUpdateTime = params.get("FlowDetailsUpdateTime")
        self._NewAfc = params.get("NewAfc")
        self._AccessNetworkType = params.get("AccessNetworkType")
        self._HaZoneList = params.get("HaZoneList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DirectConnectGatewayCcnRoute(AbstractModel):
    """The object of the CCN route (IDC IP range) of the Direct Connect gateway

    """

    def __init__(self):
        r"""
        :param _RouteId: Route ID.
        :type RouteId: str
        :param _DestinationCidrBlock: IDC IP range.
        :type DestinationCidrBlock: str
        :param _ASPath: The `AS-Path` attribute of `BGP`.
        :type ASPath: list of str
        :param _Description: Remarks
        :type Description: str
        :param _UpdateTime: Last updated time
        :type UpdateTime: str
        """
        self._RouteId = None
        self._DestinationCidrBlock = None
        self._ASPath = None
        self._Description = None
        self._UpdateTime = None

    @property
    def RouteId(self):
        return self._RouteId

    @RouteId.setter
    def RouteId(self, RouteId):
        self._RouteId = RouteId

    @property
    def DestinationCidrBlock(self):
        return self._DestinationCidrBlock

    @DestinationCidrBlock.setter
    def DestinationCidrBlock(self, DestinationCidrBlock):
        self._DestinationCidrBlock = DestinationCidrBlock

    @property
    def ASPath(self):
        return self._ASPath

    @ASPath.setter
    def ASPath(self, ASPath):
        self._ASPath = ASPath

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._RouteId = params.get("RouteId")
        self._DestinationCidrBlock = params.get("DestinationCidrBlock")
        self._ASPath = params.get("ASPath")
        self._Description = params.get("Description")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DirectConnectSubnet(AbstractModel):
    """IDC subnet information

    """

    def __init__(self):
        r"""
        :param _DirectConnectGatewayId: The direct connect gateway ID.
        :type DirectConnectGatewayId: str
        :param _CidrBlock: IDC subnet IP range
        :type CidrBlock: str
        """
        self._DirectConnectGatewayId = None
        self._CidrBlock = None

    @property
    def DirectConnectGatewayId(self):
        return self._DirectConnectGatewayId

    @DirectConnectGatewayId.setter
    def DirectConnectGatewayId(self, DirectConnectGatewayId):
        self._DirectConnectGatewayId = DirectConnectGatewayId

    @property
    def CidrBlock(self):
        return self._CidrBlock

    @CidrBlock.setter
    def CidrBlock(self, CidrBlock):
        self._CidrBlock = CidrBlock


    def _deserialize(self, params):
        self._DirectConnectGatewayId = params.get("DirectConnectGatewayId")
        self._CidrBlock = params.get("CidrBlock")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableCcnRoutesRequest(AbstractModel):
    """DisableCcnRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _CcnId: The CCN instance ID, such as `ccn-f49l6u0z`.
        :type CcnId: str
        :param _RouteIds: The unique ID of the CCN routing policy, such as `ccnr-f49l6u0z`.
        :type RouteIds: list of str
        """
        self._CcnId = None
        self._RouteIds = None

    @property
    def CcnId(self):
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def RouteIds(self):
        return self._RouteIds

    @RouteIds.setter
    def RouteIds(self, RouteIds):
        self._RouteIds = RouteIds


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        self._RouteIds = params.get("RouteIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableCcnRoutesResponse(AbstractModel):
    """DisableCcnRoutes response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DisableFlowLogsRequest(AbstractModel):
    """DisableFlowLogs request structure.

    """

    def __init__(self):
        r"""
        :param _FlowLogIds: Flow log ID.
        :type FlowLogIds: list of str
        """
        self._FlowLogIds = None

    @property
    def FlowLogIds(self):
        return self._FlowLogIds

    @FlowLogIds.setter
    def FlowLogIds(self, FlowLogIds):
        self._FlowLogIds = FlowLogIds


    def _deserialize(self, params):
        self._FlowLogIds = params.get("FlowLogIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableFlowLogsResponse(AbstractModel):
    """DisableFlowLogs response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DisableGatewayFlowMonitorRequest(AbstractModel):
    """DisableGatewayFlowMonitor request structure.

    """

    def __init__(self):
        r"""
        :param _GatewayId: Gateway instance ID. Supported types:
Direct connect gateway instance, such as `dcg-ltjahce6`;
NAT gateway instance, such as `nat-ltjahce6`;
VPN gateway instance, such as `vpn-ltjahce6`.
        :type GatewayId: str
        """
        self._GatewayId = None

    @property
    def GatewayId(self):
        return self._GatewayId

    @GatewayId.setter
    def GatewayId(self, GatewayId):
        self._GatewayId = GatewayId


    def _deserialize(self, params):
        self._GatewayId = params.get("GatewayId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableGatewayFlowMonitorResponse(AbstractModel):
    """DisableGatewayFlowMonitor response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DisableSnapshotPoliciesRequest(AbstractModel):
    """DisableSnapshotPolicies request structure.

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicyIds: Snapshot policy IDs
        :type SnapshotPolicyIds: list of str
        """
        self._SnapshotPolicyIds = None

    @property
    def SnapshotPolicyIds(self):
        return self._SnapshotPolicyIds

    @SnapshotPolicyIds.setter
    def SnapshotPolicyIds(self, SnapshotPolicyIds):
        self._SnapshotPolicyIds = SnapshotPolicyIds


    def _deserialize(self, params):
        self._SnapshotPolicyIds = params.get("SnapshotPolicyIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableSnapshotPoliciesResponse(AbstractModel):
    """DisableSnapshotPolicies response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DisassociateAddressRequest(AbstractModel):
    """DisassociateAddress request structure.

    """

    def __init__(self):
        r"""
        :param _AddressId: The unique ID of the EIP, such as `eip-11112222`.
        :type AddressId: str
        :param _ReallocateNormalPublicIp: Whether a common public IP is assigned after the EIP is unbound. Value range:<br><li>TRUE: Indicates that after the EIP is unbound, a common public IP is assigned.<br><li>FALSE: Indicates that after the EIP is unbound, a common public IP is not assigned.<br>Default value: FALSE.<br><br>The parameter can be specified only under the following conditions:<br><li>It can only be specified when you unbind an EIP from the primary private IP of the primary ENI.<br><li>After an EIP is unbound, you can assign public IPs to an account up to 10 times per day. For more information, use the [DescribeAddressQuota] (https://intl.cloud.tencent.com/document/api/213/1378?from_cn_redirect=1) API.
        :type ReallocateNormalPublicIp: bool
        """
        self._AddressId = None
        self._ReallocateNormalPublicIp = None

    @property
    def AddressId(self):
        return self._AddressId

    @AddressId.setter
    def AddressId(self, AddressId):
        self._AddressId = AddressId

    @property
    def ReallocateNormalPublicIp(self):
        return self._ReallocateNormalPublicIp

    @ReallocateNormalPublicIp.setter
    def ReallocateNormalPublicIp(self, ReallocateNormalPublicIp):
        self._ReallocateNormalPublicIp = ReallocateNormalPublicIp


    def _deserialize(self, params):
        self._AddressId = params.get("AddressId")
        self._ReallocateNormalPublicIp = params.get("ReallocateNormalPublicIp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisassociateAddressResponse(AbstractModel):
    """DisassociateAddress response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: The async task ID. You can use the [DescribeTaskResult](https://intl.cloud.tencent.com/document/api/215/36271?from_cn_redirect=1) API to query the task status.
        :type TaskId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class DisassociateDirectConnectGatewayNatGatewayRequest(AbstractModel):
    """DisassociateDirectConnectGatewayNatGateway request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: The direct connect gateway ID.
        :type VpcId: str
        :param _NatGatewayId: The NAT Gateway ID.
        :type NatGatewayId: str
        :param _DirectConnectGatewayId: The ID of the VPC instance, which can be obtained from the `VpcId` field in response of the `DescribeVpcs` API.
        :type DirectConnectGatewayId: str
        """
        self._VpcId = None
        self._NatGatewayId = None
        self._DirectConnectGatewayId = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def NatGatewayId(self):
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def DirectConnectGatewayId(self):
        return self._DirectConnectGatewayId

    @DirectConnectGatewayId.setter
    def DirectConnectGatewayId(self, DirectConnectGatewayId):
        self._DirectConnectGatewayId = DirectConnectGatewayId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._NatGatewayId = params.get("NatGatewayId")
        self._DirectConnectGatewayId = params.get("DirectConnectGatewayId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisassociateDirectConnectGatewayNatGatewayResponse(AbstractModel):
    """DisassociateDirectConnectGatewayNatGateway response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DisassociateNatGatewayAddressRequest(AbstractModel):
    """DisassociateNatGatewayAddress request structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: The ID of the NAT gateway, such as `nat-df45454`.
        :type NatGatewayId: str
        :param _PublicIpAddresses: Array of the EIPs to be unbound from the NAT gateway.
        :type PublicIpAddresses: list of str
        """
        self._NatGatewayId = None
        self._PublicIpAddresses = None

    @property
    def NatGatewayId(self):
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def PublicIpAddresses(self):
        return self._PublicIpAddresses

    @PublicIpAddresses.setter
    def PublicIpAddresses(self, PublicIpAddresses):
        self._PublicIpAddresses = PublicIpAddresses


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        self._PublicIpAddresses = params.get("PublicIpAddresses")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisassociateNatGatewayAddressResponse(AbstractModel):
    """DisassociateNatGatewayAddress response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DisassociateNetworkAclSubnetsRequest(AbstractModel):
    """DisassociateNetworkAclSubnets request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkAclId: Network ACL instance ID, such as `acl-12345678`.
        :type NetworkAclId: str
        :param _SubnetIds: Array of subnet instance IDs, such as [subnet-12345678].
        :type SubnetIds: list of str
        """
        self._NetworkAclId = None
        self._SubnetIds = None

    @property
    def NetworkAclId(self):
        return self._NetworkAclId

    @NetworkAclId.setter
    def NetworkAclId(self, NetworkAclId):
        self._NetworkAclId = NetworkAclId

    @property
    def SubnetIds(self):
        return self._SubnetIds

    @SubnetIds.setter
    def SubnetIds(self, SubnetIds):
        self._SubnetIds = SubnetIds


    def _deserialize(self, params):
        self._NetworkAclId = params.get("NetworkAclId")
        self._SubnetIds = params.get("SubnetIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisassociateNetworkAclSubnetsResponse(AbstractModel):
    """DisassociateNetworkAclSubnets response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DisassociateNetworkInterfaceSecurityGroupsRequest(AbstractModel):
    """DisassociateNetworkInterfaceSecurityGroups request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkInterfaceIds: ENI instance ID, e.g. eni-pxir56ns. You can enter up to 100 instances for each request.
        :type NetworkInterfaceIds: list of str
        :param _SecurityGroupIds: The security group instance ID, such as `sg-33ocnj9n`. It can be obtained through DescribeSecurityGroups. You can enter up to 100 instances for each request.
        :type SecurityGroupIds: list of str
        """
        self._NetworkInterfaceIds = None
        self._SecurityGroupIds = None

    @property
    def NetworkInterfaceIds(self):
        return self._NetworkInterfaceIds

    @NetworkInterfaceIds.setter
    def NetworkInterfaceIds(self, NetworkInterfaceIds):
        self._NetworkInterfaceIds = NetworkInterfaceIds

    @property
    def SecurityGroupIds(self):
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds


    def _deserialize(self, params):
        self._NetworkInterfaceIds = params.get("NetworkInterfaceIds")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisassociateNetworkInterfaceSecurityGroupsResponse(AbstractModel):
    """DisassociateNetworkInterfaceSecurityGroups response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DisassociateVpcEndPointSecurityGroupsRequest(AbstractModel):
    """DisassociateVpcEndPointSecurityGroups request structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroupIds: Array of security group IDs
        :type SecurityGroupIds: list of str
        :param _EndPointId: Endpoint ID
        :type EndPointId: str
        """
        self._SecurityGroupIds = None
        self._EndPointId = None

    @property
    def SecurityGroupIds(self):
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def EndPointId(self):
        return self._EndPointId

    @EndPointId.setter
    def EndPointId(self, EndPointId):
        self._EndPointId = EndPointId


    def _deserialize(self, params):
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        self._EndPointId = params.get("EndPointId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisassociateVpcEndPointSecurityGroupsResponse(AbstractModel):
    """DisassociateVpcEndPointSecurityGroups response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DownloadCustomerGatewayConfigurationRequest(AbstractModel):
    """DownloadCustomerGatewayConfiguration request structure.

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: The ID of the VPN gateway instance.
        :type VpnGatewayId: str
        :param _VpnConnectionId: The ID of the VPN tunnel instance, such as `vpnx-f49l6u0z`.
        :type VpnConnectionId: str
        :param _CustomerGatewayVendor: Customer gateway vendor information object, which can be obtained through DescribeCustomerGatewayVendors.
        :type CustomerGatewayVendor: :class:`tencentcloud.vpc.v20170312.models.CustomerGatewayVendor`
        :param _InterfaceName: Name of the physical API for tunnel access device.
        :type InterfaceName: str
        """
        self._VpnGatewayId = None
        self._VpnConnectionId = None
        self._CustomerGatewayVendor = None
        self._InterfaceName = None

    @property
    def VpnGatewayId(self):
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId

    @property
    def VpnConnectionId(self):
        return self._VpnConnectionId

    @VpnConnectionId.setter
    def VpnConnectionId(self, VpnConnectionId):
        self._VpnConnectionId = VpnConnectionId

    @property
    def CustomerGatewayVendor(self):
        return self._CustomerGatewayVendor

    @CustomerGatewayVendor.setter
    def CustomerGatewayVendor(self, CustomerGatewayVendor):
        self._CustomerGatewayVendor = CustomerGatewayVendor

    @property
    def InterfaceName(self):
        return self._InterfaceName

    @InterfaceName.setter
    def InterfaceName(self, InterfaceName):
        self._InterfaceName = InterfaceName


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        self._VpnConnectionId = params.get("VpnConnectionId")
        if params.get("CustomerGatewayVendor") is not None:
            self._CustomerGatewayVendor = CustomerGatewayVendor()
            self._CustomerGatewayVendor._deserialize(params.get("CustomerGatewayVendor"))
        self._InterfaceName = params.get("InterfaceName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DownloadCustomerGatewayConfigurationResponse(AbstractModel):
    """DownloadCustomerGatewayConfiguration response structure.

    """

    def __init__(self):
        r"""
        :param _CustomerGatewayConfiguration: Configuration information in XML format.
        :type CustomerGatewayConfiguration: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._CustomerGatewayConfiguration = None
        self._RequestId = None

    @property
    def CustomerGatewayConfiguration(self):
        return self._CustomerGatewayConfiguration

    @CustomerGatewayConfiguration.setter
    def CustomerGatewayConfiguration(self, CustomerGatewayConfiguration):
        self._CustomerGatewayConfiguration = CustomerGatewayConfiguration

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._CustomerGatewayConfiguration = params.get("CustomerGatewayConfiguration")
        self._RequestId = params.get("RequestId")


class EnableCcnRoutesRequest(AbstractModel):
    """EnableCcnRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _CcnId: The CCN instance ID, such as `ccn-f49l6u0z`.
        :type CcnId: str
        :param _RouteIds: The unique ID of the CCN routing policy, such as `ccnr-f49l6u0z`.
        :type RouteIds: list of str
        """
        self._CcnId = None
        self._RouteIds = None

    @property
    def CcnId(self):
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def RouteIds(self):
        return self._RouteIds

    @RouteIds.setter
    def RouteIds(self, RouteIds):
        self._RouteIds = RouteIds


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        self._RouteIds = params.get("RouteIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableCcnRoutesResponse(AbstractModel):
    """EnableCcnRoutes response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class EnableFlowLogsRequest(AbstractModel):
    """EnableFlowLogs request structure.

    """

    def __init__(self):
        r"""
        :param _FlowLogIds: Flow log ID.
        :type FlowLogIds: list of str
        """
        self._FlowLogIds = None

    @property
    def FlowLogIds(self):
        return self._FlowLogIds

    @FlowLogIds.setter
    def FlowLogIds(self, FlowLogIds):
        self._FlowLogIds = FlowLogIds


    def _deserialize(self, params):
        self._FlowLogIds = params.get("FlowLogIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableFlowLogsResponse(AbstractModel):
    """EnableFlowLogs response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class EnableGatewayFlowMonitorRequest(AbstractModel):
    """EnableGatewayFlowMonitor request structure.

    """

    def __init__(self):
        r"""
        :param _GatewayId: Gateway instance ID. Supported types:
Direct connect gateway instance, such as `dcg-ltjahce6`;
NAT gateway instance, such as `nat-ltjahce6`;
VPN gateway instance, such as `vpn-ltjahce6`.
        :type GatewayId: str
        """
        self._GatewayId = None

    @property
    def GatewayId(self):
        return self._GatewayId

    @GatewayId.setter
    def GatewayId(self, GatewayId):
        self._GatewayId = GatewayId


    def _deserialize(self, params):
        self._GatewayId = params.get("GatewayId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableGatewayFlowMonitorResponse(AbstractModel):
    """EnableGatewayFlowMonitor response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class EnableSnapshotPoliciesRequest(AbstractModel):
    """EnableSnapshotPolicies request structure.

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicyIds: Snapshot policy IDs
        :type SnapshotPolicyIds: list of str
        """
        self._SnapshotPolicyIds = None

    @property
    def SnapshotPolicyIds(self):
        return self._SnapshotPolicyIds

    @SnapshotPolicyIds.setter
    def SnapshotPolicyIds(self, SnapshotPolicyIds):
        self._SnapshotPolicyIds = SnapshotPolicyIds


    def _deserialize(self, params):
        self._SnapshotPolicyIds = params.get("SnapshotPolicyIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableSnapshotPoliciesResponse(AbstractModel):
    """EnableSnapshotPolicies response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class EnableVpcEndPointConnectRequest(AbstractModel):
    """EnableVpcEndPointConnect request structure.

    """

    def __init__(self):
        r"""
        :param _EndPointServiceId: Endpoint service ID
        :type EndPointServiceId: str
        :param _EndPointId: Endpoint ID
        :type EndPointId: list of str
        :param _AcceptFlag: Whether to accept the request of connecting with an endpoint

        :type AcceptFlag: bool
        """
        self._EndPointServiceId = None
        self._EndPointId = None
        self._AcceptFlag = None

    @property
    def EndPointServiceId(self):
        return self._EndPointServiceId

    @EndPointServiceId.setter
    def EndPointServiceId(self, EndPointServiceId):
        self._EndPointServiceId = EndPointServiceId

    @property
    def EndPointId(self):
        return self._EndPointId

    @EndPointId.setter
    def EndPointId(self, EndPointId):
        self._EndPointId = EndPointId

    @property
    def AcceptFlag(self):
        return self._AcceptFlag

    @AcceptFlag.setter
    def AcceptFlag(self, AcceptFlag):
        self._AcceptFlag = AcceptFlag


    def _deserialize(self, params):
        self._EndPointServiceId = params.get("EndPointServiceId")
        self._EndPointId = params.get("EndPointId")
        self._AcceptFlag = params.get("AcceptFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableVpcEndPointConnectResponse(AbstractModel):
    """EnableVpcEndPointConnect response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class EndPoint(AbstractModel):
    """Endpoint details

    """

    def __init__(self):
        r"""
        :param _EndPointId: Endpoint ID
        :type EndPointId: str
        :param _VpcId: VPC ID
        :type VpcId: str
        :param _SubnetId: Subnet ID
        :type SubnetId: str
        :param _EndPointOwner: APP ID
        :type EndPointOwner: str
        :param _EndPointName: Endpoint name
        :type EndPointName: str
        :param _ServiceVpcId: Endpoint service VPC ID
        :type ServiceVpcId: str
        :param _ServiceVip: Endpoint service VIP
        :type ServiceVip: str
        :param _EndPointServiceId: Endpoint service ID
        :type EndPointServiceId: str
        :param _EndPointVip: Endpoint VIP
        :type EndPointVip: str
        :param _State: Endpoint status. Valid values: `ACTIVE` (available), `PENDING` (to be accepted), `ACCEPTING` (being accepted), `REJECTED` (rejected), and `FAILED` (failed).
        :type State: str
        :param _CreateTime: Creation time
        :type CreateTime: str
        :param _GroupSet: ID list of security group instances bound with endpoints
        :type GroupSet: list of str
        :param _ServiceName: Endpoint service name
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type ServiceName: str
        """
        self._EndPointId = None
        self._VpcId = None
        self._SubnetId = None
        self._EndPointOwner = None
        self._EndPointName = None
        self._ServiceVpcId = None
        self._ServiceVip = None
        self._EndPointServiceId = None
        self._EndPointVip = None
        self._State = None
        self._CreateTime = None
        self._GroupSet = None
        self._ServiceName = None

    @property
    def EndPointId(self):
        return self._EndPointId

    @EndPointId.setter
    def EndPointId(self, EndPointId):
        self._EndPointId = EndPointId

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def EndPointOwner(self):
        return self._EndPointOwner

    @EndPointOwner.setter
    def EndPointOwner(self, EndPointOwner):
        self._EndPointOwner = EndPointOwner

    @property
    def EndPointName(self):
        return self._EndPointName

    @EndPointName.setter
    def EndPointName(self, EndPointName):
        self._EndPointName = EndPointName

    @property
    def ServiceVpcId(self):
        return self._ServiceVpcId

    @ServiceVpcId.setter
    def ServiceVpcId(self, ServiceVpcId):
        self._ServiceVpcId = ServiceVpcId

    @property
    def ServiceVip(self):
        return self._ServiceVip

    @ServiceVip.setter
    def ServiceVip(self, ServiceVip):
        self._ServiceVip = ServiceVip

    @property
    def EndPointServiceId(self):
        return self._EndPointServiceId

    @EndPointServiceId.setter
    def EndPointServiceId(self, EndPointServiceId):
        self._EndPointServiceId = EndPointServiceId

    @property
    def EndPointVip(self):
        return self._EndPointVip

    @EndPointVip.setter
    def EndPointVip(self, EndPointVip):
        self._EndPointVip = EndPointVip

    @property
    def State(self):
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def GroupSet(self):
        return self._GroupSet

    @GroupSet.setter
    def GroupSet(self, GroupSet):
        self._GroupSet = GroupSet

    @property
    def ServiceName(self):
        return self._ServiceName

    @ServiceName.setter
    def ServiceName(self, ServiceName):
        self._ServiceName = ServiceName


    def _deserialize(self, params):
        self._EndPointId = params.get("EndPointId")
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._EndPointOwner = params.get("EndPointOwner")
        self._EndPointName = params.get("EndPointName")
        self._ServiceVpcId = params.get("ServiceVpcId")
        self._ServiceVip = params.get("ServiceVip")
        self._EndPointServiceId = params.get("EndPointServiceId")
        self._EndPointVip = params.get("EndPointVip")
        self._State = params.get("State")
        self._CreateTime = params.get("CreateTime")
        self._GroupSet = params.get("GroupSet")
        self._ServiceName = params.get("ServiceName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EndPointService(AbstractModel):
    """Endpoint service

    """

    def __init__(self):
        r"""
        :param _EndPointServiceId: Endpoint service ID
        :type EndPointServiceId: str
        :param _VpcId: VPC ID
        :type VpcId: str
        :param _ServiceOwner: APP ID
        :type ServiceOwner: str
        :param _ServiceName: Endpoint service name
        :type ServiceName: str
        :param _ServiceVip: Real server VIP
        :type ServiceVip: str
        :param _ServiceInstanceId: Real server ID in the format of `lb-xxx`.
        :type ServiceInstanceId: str
        :param _AutoAcceptFlag: Whether to automatically accept
        :type AutoAcceptFlag: bool
        :param _EndPointCount: Number of associated endpoints
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type EndPointCount: int
        :param _EndPointSet: Array of endpoints
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type EndPointSet: list of EndPoint
        :param _CreateTime: Creation time
        :type CreateTime: str
        :param _ServiceType: Mounted PaaS service type. Values: `CLB`, `CDB`, `CRS`
        :type ServiceType: str
        """
        self._EndPointServiceId = None
        self._VpcId = None
        self._ServiceOwner = None
        self._ServiceName = None
        self._ServiceVip = None
        self._ServiceInstanceId = None
        self._AutoAcceptFlag = None
        self._EndPointCount = None
        self._EndPointSet = None
        self._CreateTime = None
        self._ServiceType = None

    @property
    def EndPointServiceId(self):
        return self._EndPointServiceId

    @EndPointServiceId.setter
    def EndPointServiceId(self, EndPointServiceId):
        self._EndPointServiceId = EndPointServiceId

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def ServiceOwner(self):
        return self._ServiceOwner

    @ServiceOwner.setter
    def ServiceOwner(self, ServiceOwner):
        self._ServiceOwner = ServiceOwner

    @property
    def ServiceName(self):
        return self._ServiceName

    @ServiceName.setter
    def ServiceName(self, ServiceName):
        self._ServiceName = ServiceName

    @property
    def ServiceVip(self):
        return self._ServiceVip

    @ServiceVip.setter
    def ServiceVip(self, ServiceVip):
        self._ServiceVip = ServiceVip

    @property
    def ServiceInstanceId(self):
        return self._ServiceInstanceId

    @ServiceInstanceId.setter
    def ServiceInstanceId(self, ServiceInstanceId):
        self._ServiceInstanceId = ServiceInstanceId

    @property
    def AutoAcceptFlag(self):
        return self._AutoAcceptFlag

    @AutoAcceptFlag.setter
    def AutoAcceptFlag(self, AutoAcceptFlag):
        self._AutoAcceptFlag = AutoAcceptFlag

    @property
    def EndPointCount(self):
        return self._EndPointCount

    @EndPointCount.setter
    def EndPointCount(self, EndPointCount):
        self._EndPointCount = EndPointCount

    @property
    def EndPointSet(self):
        return self._EndPointSet

    @EndPointSet.setter
    def EndPointSet(self, EndPointSet):
        self._EndPointSet = EndPointSet

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ServiceType(self):
        return self._ServiceType

    @ServiceType.setter
    def ServiceType(self, ServiceType):
        self._ServiceType = ServiceType


    def _deserialize(self, params):
        self._EndPointServiceId = params.get("EndPointServiceId")
        self._VpcId = params.get("VpcId")
        self._ServiceOwner = params.get("ServiceOwner")
        self._ServiceName = params.get("ServiceName")
        self._ServiceVip = params.get("ServiceVip")
        self._ServiceInstanceId = params.get("ServiceInstanceId")
        self._AutoAcceptFlag = params.get("AutoAcceptFlag")
        self._EndPointCount = params.get("EndPointCount")
        if params.get("EndPointSet") is not None:
            self._EndPointSet = []
            for item in params.get("EndPointSet"):
                obj = EndPoint()
                obj._deserialize(item)
                self._EndPointSet.append(obj)
        self._CreateTime = params.get("CreateTime")
        self._ServiceType = params.get("ServiceType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Filter(AbstractModel):
    """Filter

    """

    def __init__(self):
        r"""
        :param _Name: The attribute name. If more than one Filter exists, the logical relation between these Filters is `AND`.
        :type Name: str
        :param _Values: Attribute value. If multiple values exist in one filter, the logical relationship between these values is `OR`. For a `bool` parameter, the valid values include `TRUE` and `FALSE`.
        :type Values: list of str
        """
        self._Name = None
        self._Values = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FilterObject(AbstractModel):
    """Filter key-value pair

    """

    def __init__(self):
        r"""
        :param _Name: The attribute name. If more than one Filter exists, the logical relation between these Filters is `AND`.
        :type Name: str
        :param _Values: The attribute value. If there are multiple Values for one Filter, the logical relation between these Values under the same Filter is `OR`.
        :type Values: list of str
        """
        self._Name = None
        self._Values = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FlowLog(AbstractModel):
    """Flow Log

    """

    def __init__(self):
        r"""
        :param _VpcId: ID of the VPC instance.
        :type VpcId: str
        :param _FlowLogId: The unique ID of the flow log.
        :type FlowLogId: str
        :param _FlowLogName: The name of the flow log instance.
        :type FlowLogName: str
        :param _ResourceType: The type of resource associated with the flow log. Valid values: `VPC`, `SUBNET`, `NETWORKINTERFACE`, `CCN`, `NAT`, and `DCG`.
        :type ResourceType: str
        :param _ResourceId: The unique ID of the resource
        :type ResourceId: str
        :param _TrafficType: Type of flow logs to be collected. Valid values: `ACCEPT`, `REJECT` and `ALL`.
        :type TrafficType: str
        :param _CloudLogId: The storage ID of the flow log
        :type CloudLogId: str
        :param _CloudLogState: Flow log storage ID status.
        :type CloudLogState: str
        :param _FlowLogDescription: The flow log description.
        :type FlowLogDescription: str
        :param _CreatedTime: The creation time of the flow log.
        :type CreatedTime: str
        :param _TagSet: Tag list, such as [{"Key": "city", "Value": "shanghai"}].
        :type TagSet: list of Tag
        :param _Enable: Whether to enable. `true`: yes; `false`: no.
        :type Enable: bool
        :param _StorageType: Consumer end types: cls and ckafka
Note: this field may return `null`, indicating that no valid value can be found.
        :type StorageType: str
        :param _FlowLogStorage: Information of the consumer, which is returned when the consumer type is `ckafka`.
Note: this field may return `null`, indicating that no valid value can be found.
        :type FlowLogStorage: :class:`tencentcloud.vpc.v20170312.models.FlowLogStorage`
        :param _CloudLogRegion: The region corresponding to the flow log storage ID.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type CloudLogRegion: str
        """
        self._VpcId = None
        self._FlowLogId = None
        self._FlowLogName = None
        self._ResourceType = None
        self._ResourceId = None
        self._TrafficType = None
        self._CloudLogId = None
        self._CloudLogState = None
        self._FlowLogDescription = None
        self._CreatedTime = None
        self._TagSet = None
        self._Enable = None
        self._StorageType = None
        self._FlowLogStorage = None
        self._CloudLogRegion = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def FlowLogId(self):
        return self._FlowLogId

    @FlowLogId.setter
    def FlowLogId(self, FlowLogId):
        self._FlowLogId = FlowLogId

    @property
    def FlowLogName(self):
        return self._FlowLogName

    @FlowLogName.setter
    def FlowLogName(self, FlowLogName):
        self._FlowLogName = FlowLogName

    @property
    def ResourceType(self):
        return self._ResourceType

    @ResourceType.setter
    def ResourceType(self, ResourceType):
        self._ResourceType = ResourceType

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId

    @property
    def TrafficType(self):
        return self._TrafficType

    @TrafficType.setter
    def TrafficType(self, TrafficType):
        self._TrafficType = TrafficType

    @property
    def CloudLogId(self):
        return self._CloudLogId

    @CloudLogId.setter
    def CloudLogId(self, CloudLogId):
        self._CloudLogId = CloudLogId

    @property
    def CloudLogState(self):
        return self._CloudLogState

    @CloudLogState.setter
    def CloudLogState(self, CloudLogState):
        self._CloudLogState = CloudLogState

    @property
    def FlowLogDescription(self):
        return self._FlowLogDescription

    @FlowLogDescription.setter
    def FlowLogDescription(self, FlowLogDescription):
        self._FlowLogDescription = FlowLogDescription

    @property
    def CreatedTime(self):
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def TagSet(self):
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet

    @property
    def Enable(self):
        return self._Enable

    @Enable.setter
    def Enable(self, Enable):
        self._Enable = Enable

    @property
    def StorageType(self):
        return self._StorageType

    @StorageType.setter
    def StorageType(self, StorageType):
        self._StorageType = StorageType

    @property
    def FlowLogStorage(self):
        return self._FlowLogStorage

    @FlowLogStorage.setter
    def FlowLogStorage(self, FlowLogStorage):
        self._FlowLogStorage = FlowLogStorage

    @property
    def CloudLogRegion(self):
        return self._CloudLogRegion

    @CloudLogRegion.setter
    def CloudLogRegion(self, CloudLogRegion):
        self._CloudLogRegion = CloudLogRegion


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._FlowLogId = params.get("FlowLogId")
        self._FlowLogName = params.get("FlowLogName")
        self._ResourceType = params.get("ResourceType")
        self._ResourceId = params.get("ResourceId")
        self._TrafficType = params.get("TrafficType")
        self._CloudLogId = params.get("CloudLogId")
        self._CloudLogState = params.get("CloudLogState")
        self._FlowLogDescription = params.get("FlowLogDescription")
        self._CreatedTime = params.get("CreatedTime")
        if params.get("TagSet") is not None:
            self._TagSet = []
            for item in params.get("TagSet"):
                obj = Tag()
                obj._deserialize(item)
                self._TagSet.append(obj)
        self._Enable = params.get("Enable")
        self._StorageType = params.get("StorageType")
        if params.get("FlowLogStorage") is not None:
            self._FlowLogStorage = FlowLogStorage()
            self._FlowLogStorage._deserialize(params.get("FlowLogStorage"))
        self._CloudLogRegion = params.get("CloudLogRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FlowLogStorage(AbstractModel):
    """Flow log storage information

    """

    def __init__(self):
        r"""
        :param _StorageId: Storage instance ID, which is required when `StorageType` is `ckafka`.
        :type StorageId: str
        :param _StorageTopic: Topic ID, which is required when `StorageType` is `ckafka`.
Note: this field may return `null`, indicating that no valid value can be found.
        :type StorageTopic: str
        """
        self._StorageId = None
        self._StorageTopic = None

    @property
    def StorageId(self):
        return self._StorageId

    @StorageId.setter
    def StorageId(self, StorageId):
        self._StorageId = StorageId

    @property
    def StorageTopic(self):
        return self._StorageTopic

    @StorageTopic.setter
    def StorageTopic(self, StorageTopic):
        self._StorageTopic = StorageTopic


    def _deserialize(self, params):
        self._StorageId = params.get("StorageId")
        self._StorageTopic = params.get("StorageTopic")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GatewayFlowMonitorDetail(AbstractModel):
    """The gateway traffic monitoring details

    """

    def __init__(self):
        r"""
        :param _PrivateIpAddress: Origin `IP`.
        :type PrivateIpAddress: str
        :param _InPkg: Inbound packets.
        :type InPkg: int
        :param _OutPkg: Outbound packets.
        :type OutPkg: int
        :param _InTraffic: Inbound traffic, in Byte.
        :type InTraffic: int
        :param _OutTraffic: Outbound traffic, in Byte.
        :type OutTraffic: int
        """
        self._PrivateIpAddress = None
        self._InPkg = None
        self._OutPkg = None
        self._InTraffic = None
        self._OutTraffic = None

    @property
    def PrivateIpAddress(self):
        return self._PrivateIpAddress

    @PrivateIpAddress.setter
    def PrivateIpAddress(self, PrivateIpAddress):
        self._PrivateIpAddress = PrivateIpAddress

    @property
    def InPkg(self):
        return self._InPkg

    @InPkg.setter
    def InPkg(self, InPkg):
        self._InPkg = InPkg

    @property
    def OutPkg(self):
        return self._OutPkg

    @OutPkg.setter
    def OutPkg(self, OutPkg):
        self._OutPkg = OutPkg

    @property
    def InTraffic(self):
        return self._InTraffic

    @InTraffic.setter
    def InTraffic(self, InTraffic):
        self._InTraffic = InTraffic

    @property
    def OutTraffic(self):
        return self._OutTraffic

    @OutTraffic.setter
    def OutTraffic(self, OutTraffic):
        self._OutTraffic = OutTraffic


    def _deserialize(self, params):
        self._PrivateIpAddress = params.get("PrivateIpAddress")
        self._InPkg = params.get("InPkg")
        self._OutPkg = params.get("OutPkg")
        self._InTraffic = params.get("InTraffic")
        self._OutTraffic = params.get("OutTraffic")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GatewayQos(AbstractModel):
    """Information of the gateway bandwidth limit

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC instance ID.
        :type VpcId: str
        :param _IpAddress: CVM Private IP.
        :type IpAddress: str
        :param _Bandwidth: Bandwidth limit value.
        :type Bandwidth: int
        :param _CreateTime: Creation time.
        :type CreateTime: str
        """
        self._VpcId = None
        self._IpAddress = None
        self._Bandwidth = None
        self._CreateTime = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def IpAddress(self):
        return self._IpAddress

    @IpAddress.setter
    def IpAddress(self, IpAddress):
        self._IpAddress = IpAddress

    @property
    def Bandwidth(self):
        return self._Bandwidth

    @Bandwidth.setter
    def Bandwidth(self, Bandwidth):
        self._Bandwidth = Bandwidth

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._IpAddress = params.get("IpAddress")
        self._Bandwidth = params.get("Bandwidth")
        self._CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GenerateVpnConnectionDefaultHealthCheckIpRequest(AbstractModel):
    """GenerateVpnConnectionDefaultHealthCheckIp request structure.

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: VPN gateway ID, such as `vpngw-1w9tue3d`
        :type VpnGatewayId: str
        """
        self._VpnGatewayId = None

    @property
    def VpnGatewayId(self):
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GenerateVpnConnectionDefaultHealthCheckIpResponse(AbstractModel):
    """GenerateVpnConnectionDefaultHealthCheckIp response structure.

    """

    def __init__(self):
        r"""
        :param _HealthCheckLocalIp: Local IP used for VPN tunnel health check
        :type HealthCheckLocalIp: str
        :param _HealthCheckRemoteIp: Remote IP used for VPN tunnel health check
        :type HealthCheckRemoteIp: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._HealthCheckLocalIp = None
        self._HealthCheckRemoteIp = None
        self._RequestId = None

    @property
    def HealthCheckLocalIp(self):
        return self._HealthCheckLocalIp

    @HealthCheckLocalIp.setter
    def HealthCheckLocalIp(self, HealthCheckLocalIp):
        self._HealthCheckLocalIp = HealthCheckLocalIp

    @property
    def HealthCheckRemoteIp(self):
        return self._HealthCheckRemoteIp

    @HealthCheckRemoteIp.setter
    def HealthCheckRemoteIp(self, HealthCheckRemoteIp):
        self._HealthCheckRemoteIp = HealthCheckRemoteIp

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._HealthCheckLocalIp = params.get("HealthCheckLocalIp")
        self._HealthCheckRemoteIp = params.get("HealthCheckRemoteIp")
        self._RequestId = params.get("RequestId")


class GetCcnRegionBandwidthLimitsRequest(AbstractModel):
    """GetCcnRegionBandwidthLimits request structure.

    """

    def __init__(self):
        r"""
        :param _CcnId: The CCN instance ID, such as `ccn-f49l6u0z`.
        :type CcnId: str
        :param _Filters: The filter condition.
<li>sregion - String - (Filter condition) Filter by the source region, such as 'ap-guangzhou'.</li>
<li>dregion - String - (Filter condition) Filter by the destination region, such as 'ap-shanghai-bm'.</li>
        :type Filters: list of Filter
        :param _SortedBy: The sorting condition. Valid values: `BandwidthLimit` and `ExpireTime`.
        :type SortedBy: str
        :param _Offset: Offset
        :type Offset: int
        :param _Limit: Quantity of returned items
        :type Limit: int
        :param _OrderBy: In ascending or descending order. Valid values: 'ASC' and 'DESC'.
        :type OrderBy: str
        """
        self._CcnId = None
        self._Filters = None
        self._SortedBy = None
        self._Offset = None
        self._Limit = None
        self._OrderBy = None

    @property
    def CcnId(self):
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def SortedBy(self):
        return self._SortedBy

    @SortedBy.setter
    def SortedBy(self, SortedBy):
        self._SortedBy = SortedBy

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderBy(self):
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._SortedBy = params.get("SortedBy")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._OrderBy = params.get("OrderBy")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetCcnRegionBandwidthLimitsResponse(AbstractModel):
    """GetCcnRegionBandwidthLimits response structure.

    """

    def __init__(self):
        r"""
        :param _CcnBandwidthSet: The outbound bandwidth limits of regions in a CCN instance.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CcnBandwidthSet: list of CcnBandwidthInfo
        :param _TotalCount: The number of eligible objects.
Note: this field may return null, indicating that no valid value was found.
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._CcnBandwidthSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def CcnBandwidthSet(self):
        return self._CcnBandwidthSet

    @CcnBandwidthSet.setter
    def CcnBandwidthSet(self, CcnBandwidthSet):
        self._CcnBandwidthSet = CcnBandwidthSet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CcnBandwidthSet") is not None:
            self._CcnBandwidthSet = []
            for item in params.get("CcnBandwidthSet"):
                obj = CcnBandwidthInfo()
                obj._deserialize(item)
                self._CcnBandwidthSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class HaVip(AbstractModel):
    """HAVIP description information

    """

    def __init__(self):
        r"""
        :param _HaVipId: The `ID` of the `HAVIP`. This is the unique identifier of the `HAVIP`.
        :type HaVipId: str
        :param _HaVipName: The name of the `HAVIP`.
        :type HaVipName: str
        :param _Vip: The virtual IP address.
        :type Vip: str
        :param _VpcId: The `ID` of the VPC to which the `HAVIP` belongs.
        :type VpcId: str
        :param _SubnetId: The `ID` of the subnet to which the `HAVIP` belongs.
        :type SubnetId: str
        :param _NetworkInterfaceId: The `ID` of the ENI associated with the `HAVIP`.
        :type NetworkInterfaceId: str
        :param _InstanceId: The `ID` of the bound instance.
        :type InstanceId: str
        :param _AddressIp: Bound `EIP`.
        :type AddressIp: str
        :param _State: Status:
<li>`AVAILABLE`: Operating</li>
<li>`UNBIND`: Not bound</li>
        :type State: str
        :param _CreatedTime: Creation Time.
        :type CreatedTime: str
        :param _Business: Identifier for businesses that use HAVIP.
        :type Business: str
        """
        self._HaVipId = None
        self._HaVipName = None
        self._Vip = None
        self._VpcId = None
        self._SubnetId = None
        self._NetworkInterfaceId = None
        self._InstanceId = None
        self._AddressIp = None
        self._State = None
        self._CreatedTime = None
        self._Business = None

    @property
    def HaVipId(self):
        return self._HaVipId

    @HaVipId.setter
    def HaVipId(self, HaVipId):
        self._HaVipId = HaVipId

    @property
    def HaVipName(self):
        return self._HaVipName

    @HaVipName.setter
    def HaVipName(self, HaVipName):
        self._HaVipName = HaVipName

    @property
    def Vip(self):
        return self._Vip

    @Vip.setter
    def Vip(self, Vip):
        self._Vip = Vip

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def NetworkInterfaceId(self):
        return self._NetworkInterfaceId

    @NetworkInterfaceId.setter
    def NetworkInterfaceId(self, NetworkInterfaceId):
        self._NetworkInterfaceId = NetworkInterfaceId

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def AddressIp(self):
        return self._AddressIp

    @AddressIp.setter
    def AddressIp(self, AddressIp):
        self._AddressIp = AddressIp

    @property
    def State(self):
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def CreatedTime(self):
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def Business(self):
        return self._Business

    @Business.setter
    def Business(self, Business):
        self._Business = Business


    def _deserialize(self, params):
        self._HaVipId = params.get("HaVipId")
        self._HaVipName = params.get("HaVipName")
        self._Vip = params.get("Vip")
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._NetworkInterfaceId = params.get("NetworkInterfaceId")
        self._InstanceId = params.get("InstanceId")
        self._AddressIp = params.get("AddressIp")
        self._State = params.get("State")
        self._CreatedTime = params.get("CreatedTime")
        self._Business = params.get("Business")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HaVipAssociateAddressIpRequest(AbstractModel):
    """HaVipAssociateAddressIp request structure.

    """

    def __init__(self):
        r"""
        :param _HaVipId: The unique `ID` of the `HAVIP`, such as `havip-9o233uri`. This must be a `HAVIP` that has not been bound to an `EIP`
        :type HaVipId: str
        :param _AddressIp: The Elastic `IP`. This must be an `EIP` that has not been bound to a `HAVIP`
        :type AddressIp: str
        """
        self._HaVipId = None
        self._AddressIp = None

    @property
    def HaVipId(self):
        return self._HaVipId

    @HaVipId.setter
    def HaVipId(self, HaVipId):
        self._HaVipId = HaVipId

    @property
    def AddressIp(self):
        return self._AddressIp

    @AddressIp.setter
    def AddressIp(self, AddressIp):
        self._AddressIp = AddressIp


    def _deserialize(self, params):
        self._HaVipId = params.get("HaVipId")
        self._AddressIp = params.get("AddressIp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HaVipAssociateAddressIpResponse(AbstractModel):
    """HaVipAssociateAddressIp response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class HaVipDisassociateAddressIpRequest(AbstractModel):
    """HaVipDisassociateAddressIp request structure.

    """

    def __init__(self):
        r"""
        :param _HaVipId: The unique `ID` of the `HAVIP`, such as `havip-9o233uri`. This must be an `HAVIP` that has been bound to an `EIP`.
        :type HaVipId: str
        """
        self._HaVipId = None

    @property
    def HaVipId(self):
        return self._HaVipId

    @HaVipId.setter
    def HaVipId(self, HaVipId):
        self._HaVipId = HaVipId


    def _deserialize(self, params):
        self._HaVipId = params.get("HaVipId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HaVipDisassociateAddressIpResponse(AbstractModel):
    """HaVipDisassociateAddressIp response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class IKEOptionsSpecification(AbstractModel):
    """Internet Key Exchange (IKE) configuration. IKE has a self-protection mechanism. The network security protocol is configured by the user.

    """

    def __init__(self):
        r"""
        :param _PropoEncryAlgorithm: Encryption algorithm. Valid values: `3DES-CBC`, `AES-CBC-128`, `AES-CBS-192`, `AES-CBC-256`, `DES-CBC`, and `SM4`; default value: `3DES-CBC`.
        :type PropoEncryAlgorithm: str
        :param _PropoAuthenAlgorithm: Authentication algorithm. Valid values: `MD5`, `SHA1` and `SHA-256`; default value: `MD5`.
        :type PropoAuthenAlgorithm: str
        :param _ExchangeMode: Negotiation mode. Available values: 'AGGRESSIVE' and 'MAIN'. Default is MAIN.
        :type ExchangeMode: str
        :param _LocalIdentity: Type of local identity. Available values: 'ADDRESS' and 'FQDN'. Default is ADDRESS.
        :type LocalIdentity: str
        :param _RemoteIdentity: Type of remote identity. Available values: 'ADDRESS' and 'FQDN'. Default is ADDRESS.
        :type RemoteIdentity: str
        :param _LocalAddress: Local identity. When ADDRESS is selected for LocalIdentity, LocalAddress is required. The default LocalAddress is the public IP of the VPN gateway.
        :type LocalAddress: str
        :param _RemoteAddress: Remote identity. When ADDRESS is selected for RemoteIdentity, RemoteAddress is required.
        :type RemoteAddress: str
        :param _LocalFqdnName: Local identity. When FQDN is selected for LocalIdentity, LocalFqdnName is required.
        :type LocalFqdnName: str
        :param _RemoteFqdnName: Remote identity. When FQDN is selected for RemoteIdentity, RemoteFqdnName is required.
        :type RemoteFqdnName: str
        :param _DhGroupName: DH group. Specify the DH group used for exchanging the key via IKE. Available values: 'GROUP1', 'GROUP2', 'GROUP5', 'GROUP14', and 'GROUP24'.
        :type DhGroupName: str
        :param _IKESaLifetimeSeconds: IKE SA lifetime (in sec). Value range: 60-604800
        :type IKESaLifetimeSeconds: int
        :param _IKEVersion: IKE version
        :type IKEVersion: str
        """
        self._PropoEncryAlgorithm = None
        self._PropoAuthenAlgorithm = None
        self._ExchangeMode = None
        self._LocalIdentity = None
        self._RemoteIdentity = None
        self._LocalAddress = None
        self._RemoteAddress = None
        self._LocalFqdnName = None
        self._RemoteFqdnName = None
        self._DhGroupName = None
        self._IKESaLifetimeSeconds = None
        self._IKEVersion = None

    @property
    def PropoEncryAlgorithm(self):
        return self._PropoEncryAlgorithm

    @PropoEncryAlgorithm.setter
    def PropoEncryAlgorithm(self, PropoEncryAlgorithm):
        self._PropoEncryAlgorithm = PropoEncryAlgorithm

    @property
    def PropoAuthenAlgorithm(self):
        return self._PropoAuthenAlgorithm

    @PropoAuthenAlgorithm.setter
    def PropoAuthenAlgorithm(self, PropoAuthenAlgorithm):
        self._PropoAuthenAlgorithm = PropoAuthenAlgorithm

    @property
    def ExchangeMode(self):
        return self._ExchangeMode

    @ExchangeMode.setter
    def ExchangeMode(self, ExchangeMode):
        self._ExchangeMode = ExchangeMode

    @property
    def LocalIdentity(self):
        return self._LocalIdentity

    @LocalIdentity.setter
    def LocalIdentity(self, LocalIdentity):
        self._LocalIdentity = LocalIdentity

    @property
    def RemoteIdentity(self):
        return self._RemoteIdentity

    @RemoteIdentity.setter
    def RemoteIdentity(self, RemoteIdentity):
        self._RemoteIdentity = RemoteIdentity

    @property
    def LocalAddress(self):
        return self._LocalAddress

    @LocalAddress.setter
    def LocalAddress(self, LocalAddress):
        self._LocalAddress = LocalAddress

    @property
    def RemoteAddress(self):
        return self._RemoteAddress

    @RemoteAddress.setter
    def RemoteAddress(self, RemoteAddress):
        self._RemoteAddress = RemoteAddress

    @property
    def LocalFqdnName(self):
        return self._LocalFqdnName

    @LocalFqdnName.setter
    def LocalFqdnName(self, LocalFqdnName):
        self._LocalFqdnName = LocalFqdnName

    @property
    def RemoteFqdnName(self):
        return self._RemoteFqdnName

    @RemoteFqdnName.setter
    def RemoteFqdnName(self, RemoteFqdnName):
        self._RemoteFqdnName = RemoteFqdnName

    @property
    def DhGroupName(self):
        return self._DhGroupName

    @DhGroupName.setter
    def DhGroupName(self, DhGroupName):
        self._DhGroupName = DhGroupName

    @property
    def IKESaLifetimeSeconds(self):
        return self._IKESaLifetimeSeconds

    @IKESaLifetimeSeconds.setter
    def IKESaLifetimeSeconds(self, IKESaLifetimeSeconds):
        self._IKESaLifetimeSeconds = IKESaLifetimeSeconds

    @property
    def IKEVersion(self):
        return self._IKEVersion

    @IKEVersion.setter
    def IKEVersion(self, IKEVersion):
        self._IKEVersion = IKEVersion


    def _deserialize(self, params):
        self._PropoEncryAlgorithm = params.get("PropoEncryAlgorithm")
        self._PropoAuthenAlgorithm = params.get("PropoAuthenAlgorithm")
        self._ExchangeMode = params.get("ExchangeMode")
        self._LocalIdentity = params.get("LocalIdentity")
        self._RemoteIdentity = params.get("RemoteIdentity")
        self._LocalAddress = params.get("LocalAddress")
        self._RemoteAddress = params.get("RemoteAddress")
        self._LocalFqdnName = params.get("LocalFqdnName")
        self._RemoteFqdnName = params.get("RemoteFqdnName")
        self._DhGroupName = params.get("DhGroupName")
        self._IKESaLifetimeSeconds = params.get("IKESaLifetimeSeconds")
        self._IKEVersion = params.get("IKEVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IPSECOptionsSpecification(AbstractModel):
    """IPSec configuration. The IPSec secure session configuration is provided by Tencent Cloud.

    """

    def __init__(self):
        r"""
        :param _EncryptAlgorithm: Encryption algorithm. Valid values: `3DES-CBC`, `AES-CBC-128`, `AES-CBC-192`, `AES-CBC-256`, `DES-CBC`, `SM4`, and `NULL`; default value: `AES-CBC-128`.
        :type EncryptAlgorithm: str
        :param _IntegrityAlgorith: Authentication algorithm. Valid values: `MD5`, `SHA1` and `SHA-256`; default value: `SHA1`.
        :type IntegrityAlgorith: str
        :param _IPSECSaLifetimeSeconds: IPsec SA lifetime (in sec). Value range: 180-604800
        :type IPSECSaLifetimeSeconds: int
        :param _PfsDhGroup: PFS. Available value: 'NULL', 'DH-GROUP1', 'DH-GROUP2', 'DH-GROUP5', 'DH-GROUP14', and 'DH-GROUP24'. Default is NULL.
        :type PfsDhGroup: str
        :param _IPSECSaLifetimeTraffic: IPsec SA lifetime (in KB). Value range: 2560-604800
        :type IPSECSaLifetimeTraffic: int
        """
        self._EncryptAlgorithm = None
        self._IntegrityAlgorith = None
        self._IPSECSaLifetimeSeconds = None
        self._PfsDhGroup = None
        self._IPSECSaLifetimeTraffic = None

    @property
    def EncryptAlgorithm(self):
        return self._EncryptAlgorithm

    @EncryptAlgorithm.setter
    def EncryptAlgorithm(self, EncryptAlgorithm):
        self._EncryptAlgorithm = EncryptAlgorithm

    @property
    def IntegrityAlgorith(self):
        return self._IntegrityAlgorith

    @IntegrityAlgorith.setter
    def IntegrityAlgorith(self, IntegrityAlgorith):
        self._IntegrityAlgorith = IntegrityAlgorith

    @property
    def IPSECSaLifetimeSeconds(self):
        return self._IPSECSaLifetimeSeconds

    @IPSECSaLifetimeSeconds.setter
    def IPSECSaLifetimeSeconds(self, IPSECSaLifetimeSeconds):
        self._IPSECSaLifetimeSeconds = IPSECSaLifetimeSeconds

    @property
    def PfsDhGroup(self):
        return self._PfsDhGroup

    @PfsDhGroup.setter
    def PfsDhGroup(self, PfsDhGroup):
        self._PfsDhGroup = PfsDhGroup

    @property
    def IPSECSaLifetimeTraffic(self):
        return self._IPSECSaLifetimeTraffic

    @IPSECSaLifetimeTraffic.setter
    def IPSECSaLifetimeTraffic(self, IPSECSaLifetimeTraffic):
        self._IPSECSaLifetimeTraffic = IPSECSaLifetimeTraffic


    def _deserialize(self, params):
        self._EncryptAlgorithm = params.get("EncryptAlgorithm")
        self._IntegrityAlgorith = params.get("IntegrityAlgorith")
        self._IPSECSaLifetimeSeconds = params.get("IPSECSaLifetimeSeconds")
        self._PfsDhGroup = params.get("PfsDhGroup")
        self._IPSECSaLifetimeTraffic = params.get("IPSECSaLifetimeTraffic")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InquirePriceCreateDirectConnectGatewayRequest(AbstractModel):
    """InquirePriceCreateDirectConnectGateway request structure.

    """


class InquirePriceCreateDirectConnectGatewayResponse(AbstractModel):
    """InquirePriceCreateDirectConnectGateway response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCost: Standard access fee for a direct connect gateway
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type TotalCost: int
        :param _RealTotalCost: Actual access fee for a direct connect gateway
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type RealTotalCost: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCost = None
        self._RealTotalCost = None
        self._RequestId = None

    @property
    def TotalCost(self):
        return self._TotalCost

    @TotalCost.setter
    def TotalCost(self, TotalCost):
        self._TotalCost = TotalCost

    @property
    def RealTotalCost(self):
        return self._RealTotalCost

    @RealTotalCost.setter
    def RealTotalCost(self, RealTotalCost):
        self._RealTotalCost = RealTotalCost

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCost = params.get("TotalCost")
        self._RealTotalCost = params.get("RealTotalCost")
        self._RequestId = params.get("RequestId")


class InquiryPriceRenewVpnGatewayRequest(AbstractModel):
    """InquiryPriceRenewVpnGateway request structure.

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: The ID of the VPN gateway instance.
        :type VpnGatewayId: str
        :param _InstanceChargePrepaid: Specifies the purchased validity period, whether to enable auto-renewal. This parameter is required for monthly-subscription instances.
        :type InstanceChargePrepaid: :class:`tencentcloud.vpc.v20170312.models.InstanceChargePrepaid`
        """
        self._VpnGatewayId = None
        self._InstanceChargePrepaid = None

    @property
    def VpnGatewayId(self):
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId

    @property
    def InstanceChargePrepaid(self):
        return self._InstanceChargePrepaid

    @InstanceChargePrepaid.setter
    def InstanceChargePrepaid(self, InstanceChargePrepaid):
        self._InstanceChargePrepaid = InstanceChargePrepaid


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        if params.get("InstanceChargePrepaid") is not None:
            self._InstanceChargePrepaid = InstanceChargePrepaid()
            self._InstanceChargePrepaid._deserialize(params.get("InstanceChargePrepaid"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InquiryPriceRenewVpnGatewayResponse(AbstractModel):
    """InquiryPriceRenewVpnGateway response structure.

    """

    def __init__(self):
        r"""
        :param _Price: Product price.
        :type Price: :class:`tencentcloud.vpc.v20170312.models.Price`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Price = None
        self._RequestId = None

    @property
    def Price(self):
        return self._Price

    @Price.setter
    def Price(self, Price):
        self._Price = Price

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Price") is not None:
            self._Price = Price()
            self._Price._deserialize(params.get("Price"))
        self._RequestId = params.get("RequestId")


class InquiryPriceResetVpnGatewayInternetMaxBandwidthRequest(AbstractModel):
    """InquiryPriceResetVpnGatewayInternetMaxBandwidth request structure.

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: The ID of the VPN gateway instance.
        :type VpnGatewayId: str
        :param _InternetMaxBandwidthOut: The public network bandwidth configuration. Available bandwidth specifications: 5, 10, 20, 50, and 100. Unit: Mbps.
        :type InternetMaxBandwidthOut: int
        """
        self._VpnGatewayId = None
        self._InternetMaxBandwidthOut = None

    @property
    def VpnGatewayId(self):
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId

    @property
    def InternetMaxBandwidthOut(self):
        return self._InternetMaxBandwidthOut

    @InternetMaxBandwidthOut.setter
    def InternetMaxBandwidthOut(self, InternetMaxBandwidthOut):
        self._InternetMaxBandwidthOut = InternetMaxBandwidthOut


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        self._InternetMaxBandwidthOut = params.get("InternetMaxBandwidthOut")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InquiryPriceResetVpnGatewayInternetMaxBandwidthResponse(AbstractModel):
    """InquiryPriceResetVpnGatewayInternetMaxBandwidth response structure.

    """

    def __init__(self):
        r"""
        :param _Price: Product price.
        :type Price: :class:`tencentcloud.vpc.v20170312.models.Price`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Price = None
        self._RequestId = None

    @property
    def Price(self):
        return self._Price

    @Price.setter
    def Price(self, Price):
        self._Price = Price

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Price") is not None:
            self._Price = Price()
            self._Price._deserialize(params.get("Price"))
        self._RequestId = params.get("RequestId")


class InstanceChargePrepaid(AbstractModel):
    """Prepaid (monthly subscription) billing object.

    """

    def __init__(self):
        r"""
        :param _Period: Purchased usage period (in month). Value range: [1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36].
        :type Period: int
        :param _RenewFlag: Auto-renewal ID. Value range: NOTIFY_AND_AUTO_RENEW: notify expiry and renew automatically, NOTIFY_AND_MANUAL_RENEW: notify expiry but do not renew automatically. The default is NOTIFY_AND_MANUAL_RENEW
        :type RenewFlag: str
        """
        self._Period = None
        self._RenewFlag = None

    @property
    def Period(self):
        return self._Period

    @Period.setter
    def Period(self, Period):
        self._Period = Period

    @property
    def RenewFlag(self):
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag


    def _deserialize(self, params):
        self._Period = params.get("Period")
        self._RenewFlag = params.get("RenewFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceStatistic(AbstractModel):
    """Statistics used to describe the instance

    """

    def __init__(self):
        r"""
        :param _InstanceType: Type of instance
        :type InstanceType: str
        :param _InstanceCount: Number of instances
        :type InstanceCount: int
        """
        self._InstanceType = None
        self._InstanceCount = None

    @property
    def InstanceType(self):
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def InstanceCount(self):
        return self._InstanceCount

    @InstanceCount.setter
    def InstanceCount(self, InstanceCount):
        self._InstanceCount = InstanceCount


    def _deserialize(self, params):
        self._InstanceType = params.get("InstanceType")
        self._InstanceCount = params.get("InstanceCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IpAddressStates(AbstractModel):
    """Information of resources bound with the queried IPs

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC instance ID
        :type VpcId: str
        :param _SubnetId: Subnet instance ID
        :type SubnetId: str
        :param _IpAddress: IP address
        :type IpAddress: str
        :param _ResourceType: Resource type
        :type ResourceType: str
        :param _ResourceId: Resource ID
        :type ResourceId: str
        """
        self._VpcId = None
        self._SubnetId = None
        self._IpAddress = None
        self._ResourceType = None
        self._ResourceId = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def IpAddress(self):
        return self._IpAddress

    @IpAddress.setter
    def IpAddress(self, IpAddress):
        self._IpAddress = IpAddress

    @property
    def ResourceType(self):
        return self._ResourceType

    @ResourceType.setter
    def ResourceType(self, ResourceType):
        self._ResourceType = ResourceType

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._IpAddress = params.get("IpAddress")
        self._ResourceType = params.get("ResourceType")
        self._ResourceId = params.get("ResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IpField(AbstractModel):
    """IP information to be queried

    """

    def __init__(self):
        r"""
        :param _Country: Country/region of the IP
        :type Country: bool
        :param _Province: Province/municipality/state of the IP
        :type Province: bool
        :param _City: City of the IP
        :type City: bool
        :param _Region: City district of the IP
        :type Region: bool
        :param _Isp: Access ISP field
        :type Isp: bool
        :param _AsName: ISP backbone network’s AS field
        :type AsName: bool
        :param _AsId: Backbone AS ID
        :type AsId: bool
        :param _Comment: Comment
        :type Comment: bool
        """
        self._Country = None
        self._Province = None
        self._City = None
        self._Region = None
        self._Isp = None
        self._AsName = None
        self._AsId = None
        self._Comment = None

    @property
    def Country(self):
        return self._Country

    @Country.setter
    def Country(self, Country):
        self._Country = Country

    @property
    def Province(self):
        return self._Province

    @Province.setter
    def Province(self, Province):
        self._Province = Province

    @property
    def City(self):
        return self._City

    @City.setter
    def City(self, City):
        self._City = City

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Isp(self):
        return self._Isp

    @Isp.setter
    def Isp(self, Isp):
        self._Isp = Isp

    @property
    def AsName(self):
        return self._AsName

    @AsName.setter
    def AsName(self, AsName):
        self._AsName = AsName

    @property
    def AsId(self):
        return self._AsId

    @AsId.setter
    def AsId(self, AsId):
        self._AsId = AsId

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment


    def _deserialize(self, params):
        self._Country = params.get("Country")
        self._Province = params.get("Province")
        self._City = params.get("City")
        self._Region = params.get("Region")
        self._Isp = params.get("Isp")
        self._AsName = params.get("AsName")
        self._AsId = params.get("AsId")
        self._Comment = params.get("Comment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IpGeolocationInfo(AbstractModel):
    """IP location

    """

    def __init__(self):
        r"""
        :param _Country: Country/region
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type Country: str
        :param _Province: Province- or municipality-level administrative region
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type Province: str
        :param _City: Municipal administrative region
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type City: str
        :param _Region: Urban area
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type Region: str
        :param _Isp: Access ISP
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type Isp: str
        :param _AsName: ISP backbone network’s AS name
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type AsName: str
        :param _AsId: ISP backbone network’s AS ID
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type AsId: str
        :param _Comment: Comment. The APN value of mobile users is entered currently. If there is no APN attribute, this is `null`.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type Comment: str
        :param _AddressIp: IP address
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type AddressIp: str
        """
        self._Country = None
        self._Province = None
        self._City = None
        self._Region = None
        self._Isp = None
        self._AsName = None
        self._AsId = None
        self._Comment = None
        self._AddressIp = None

    @property
    def Country(self):
        return self._Country

    @Country.setter
    def Country(self, Country):
        self._Country = Country

    @property
    def Province(self):
        return self._Province

    @Province.setter
    def Province(self, Province):
        self._Province = Province

    @property
    def City(self):
        return self._City

    @City.setter
    def City(self, City):
        self._City = City

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Isp(self):
        return self._Isp

    @Isp.setter
    def Isp(self, Isp):
        self._Isp = Isp

    @property
    def AsName(self):
        return self._AsName

    @AsName.setter
    def AsName(self, AsName):
        self._AsName = AsName

    @property
    def AsId(self):
        return self._AsId

    @AsId.setter
    def AsId(self, AsId):
        self._AsId = AsId

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def AddressIp(self):
        return self._AddressIp

    @AddressIp.setter
    def AddressIp(self, AddressIp):
        self._AddressIp = AddressIp


    def _deserialize(self, params):
        self._Country = params.get("Country")
        self._Province = params.get("Province")
        self._City = params.get("City")
        self._Region = params.get("Region")
        self._Isp = params.get("Isp")
        self._AsName = params.get("AsName")
        self._AsId = params.get("AsId")
        self._Comment = params.get("Comment")
        self._AddressIp = params.get("AddressIp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Ipv6Address(AbstractModel):
    """`IPv6` address information.

    """

    def __init__(self):
        r"""
        :param _Address: `IPv6` address, such as `3402:4e00:20:100:0:8cd9:2a67:71f3`
        :type Address: str
        :param _Primary: Whether it is a primary `IP`.
        :type Primary: bool
        :param _AddressId: The `ID` of the `EIP` instance, such as `eip-hxlqja90`.
        :type AddressId: str
        :param _Description: Message description
        :type Description: str
        :param _IsWanIpBlocked: Whether the public IP is blocked.
        :type IsWanIpBlocked: bool
        :param _State: `IPv6` address status:
<li>`PENDING`: Creating</li>
<li>`MIGRATING`: Migrating</li>
<li>`DELETING`: Deleting</li>
<li>`AVAILABLE`: Available</li>
        :type State: str
        """
        self._Address = None
        self._Primary = None
        self._AddressId = None
        self._Description = None
        self._IsWanIpBlocked = None
        self._State = None

    @property
    def Address(self):
        return self._Address

    @Address.setter
    def Address(self, Address):
        self._Address = Address

    @property
    def Primary(self):
        return self._Primary

    @Primary.setter
    def Primary(self, Primary):
        self._Primary = Primary

    @property
    def AddressId(self):
        return self._AddressId

    @AddressId.setter
    def AddressId(self, AddressId):
        self._AddressId = AddressId

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def IsWanIpBlocked(self):
        return self._IsWanIpBlocked

    @IsWanIpBlocked.setter
    def IsWanIpBlocked(self, IsWanIpBlocked):
        self._IsWanIpBlocked = IsWanIpBlocked

    @property
    def State(self):
        return self._State

    @State.setter
    def State(self, State):
        self._State = State


    def _deserialize(self, params):
        self._Address = params.get("Address")
        self._Primary = params.get("Primary")
        self._AddressId = params.get("AddressId")
        self._Description = params.get("Description")
        self._IsWanIpBlocked = params.get("IsWanIpBlocked")
        self._State = params.get("State")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Ipv6SubnetCidrBlock(AbstractModel):
    """IPv6 subnet IP range object.

    """

    def __init__(self):
        r"""
        :param _SubnetId: The `ID` of the subnet instance, such as `subnet-pxir56ns`.
        :type SubnetId: str
        :param _Ipv6CidrBlock: The `IPv6` subnet IP range, such as `3402:4e00:20:1001::/64`
        :type Ipv6CidrBlock: str
        """
        self._SubnetId = None
        self._Ipv6CidrBlock = None

    @property
    def SubnetId(self):
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def Ipv6CidrBlock(self):
        return self._Ipv6CidrBlock

    @Ipv6CidrBlock.setter
    def Ipv6CidrBlock(self, Ipv6CidrBlock):
        self._Ipv6CidrBlock = Ipv6CidrBlock


    def _deserialize(self, params):
        self._SubnetId = params.get("SubnetId")
        self._Ipv6CidrBlock = params.get("Ipv6CidrBlock")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ItemPrice(AbstractModel):
    """The pricing information of a single billing item

    """

    def __init__(self):
        r"""
        :param _UnitPrice: The pay-as-you-go billing method. Unit: CNY.
        :type UnitPrice: float
        :param _ChargeUnit: Pay-as-you-go billing method. Value Range: HOUR: Indicates billing by the hour. Scenarios using this hourly billing unit include: Instances postpaid on an hourly basis (POSTPAID_BY_HOUR), and bandwidth postpaid on an hourly basis (BANDWIDTH_POSTPAID_BY_HOUR). GB: Indicates billing on a per-GB basis. Scenarios using this billing unit include: Traffic postpaid on an hourly basis (TRAFFIC_POSTPAID_BY_HOUR).
        :type ChargeUnit: str
        :param _OriginalPrice: Original price of the prepaid product. Unit: CNY.
        :type OriginalPrice: float
        :param _DiscountPrice: Discount price of the prepaid product. Unit: CNY.
        :type DiscountPrice: float
        """
        self._UnitPrice = None
        self._ChargeUnit = None
        self._OriginalPrice = None
        self._DiscountPrice = None

    @property
    def UnitPrice(self):
        return self._UnitPrice

    @UnitPrice.setter
    def UnitPrice(self, UnitPrice):
        self._UnitPrice = UnitPrice

    @property
    def ChargeUnit(self):
        return self._ChargeUnit

    @ChargeUnit.setter
    def ChargeUnit(self, ChargeUnit):
        self._ChargeUnit = ChargeUnit

    @property
    def OriginalPrice(self):
        return self._OriginalPrice

    @OriginalPrice.setter
    def OriginalPrice(self, OriginalPrice):
        self._OriginalPrice = OriginalPrice

    @property
    def DiscountPrice(self):
        return self._DiscountPrice

    @DiscountPrice.setter
    def DiscountPrice(self, DiscountPrice):
        self._DiscountPrice = DiscountPrice


    def _deserialize(self, params):
        self._UnitPrice = params.get("UnitPrice")
        self._ChargeUnit = params.get("ChargeUnit")
        self._OriginalPrice = params.get("OriginalPrice")
        self._DiscountPrice = params.get("DiscountPrice")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LocalGateway(AbstractModel):
    """Local gateway information

    """

    def __init__(self):
        r"""
        :param _CdcId: CDC instance ID
        :type CdcId: str
        :param _VpcId: VPC instance ID
        :type VpcId: str
        :param _UniqLocalGwId: Local gateway instance ID
        :type UniqLocalGwId: str
        :param _LocalGatewayName: Local gateway name
        :type LocalGatewayName: str
        :param _LocalGwIp: Local gateway IP
        :type LocalGwIp: str
        :param _CreateTime: Creation time of the local gateway
        :type CreateTime: str
        """
        self._CdcId = None
        self._VpcId = None
        self._UniqLocalGwId = None
        self._LocalGatewayName = None
        self._LocalGwIp = None
        self._CreateTime = None

    @property
    def CdcId(self):
        return self._CdcId

    @CdcId.setter
    def CdcId(self, CdcId):
        self._CdcId = CdcId

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def UniqLocalGwId(self):
        return self._UniqLocalGwId

    @UniqLocalGwId.setter
    def UniqLocalGwId(self, UniqLocalGwId):
        self._UniqLocalGwId = UniqLocalGwId

    @property
    def LocalGatewayName(self):
        return self._LocalGatewayName

    @LocalGatewayName.setter
    def LocalGatewayName(self, LocalGatewayName):
        self._LocalGatewayName = LocalGatewayName

    @property
    def LocalGwIp(self):
        return self._LocalGwIp

    @LocalGwIp.setter
    def LocalGwIp(self, LocalGwIp):
        self._LocalGwIp = LocalGwIp

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime


    def _deserialize(self, params):
        self._CdcId = params.get("CdcId")
        self._VpcId = params.get("VpcId")
        self._UniqLocalGwId = params.get("UniqLocalGwId")
        self._LocalGatewayName = params.get("LocalGatewayName")
        self._LocalGwIp = params.get("LocalGwIp")
        self._CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MigrateNetworkInterfaceRequest(AbstractModel):
    """MigrateNetworkInterface request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkInterfaceId: The ID of the ENI instance, such as `eni-m6dyj72l`.
        :type NetworkInterfaceId: str
        :param _SourceInstanceId: The ID of the CVM bound to the ENI, such as `ins-r8hr2upy`.
        :type SourceInstanceId: str
        :param _DestinationInstanceId: ID of the destination CVM instance to be migrated.
        :type DestinationInstanceId: str
        :param _AttachType: ENI mount method. Valid values: 0: standard; 1: extension; default value: 0
        :type AttachType: int
        """
        self._NetworkInterfaceId = None
        self._SourceInstanceId = None
        self._DestinationInstanceId = None
        self._AttachType = None

    @property
    def NetworkInterfaceId(self):
        return self._NetworkInterfaceId

    @NetworkInterfaceId.setter
    def NetworkInterfaceId(self, NetworkInterfaceId):
        self._NetworkInterfaceId = NetworkInterfaceId

    @property
    def SourceInstanceId(self):
        return self._SourceInstanceId

    @SourceInstanceId.setter
    def SourceInstanceId(self, SourceInstanceId):
        self._SourceInstanceId = SourceInstanceId

    @property
    def DestinationInstanceId(self):
        return self._DestinationInstanceId

    @DestinationInstanceId.setter
    def DestinationInstanceId(self, DestinationInstanceId):
        self._DestinationInstanceId = DestinationInstanceId

    @property
    def AttachType(self):
        return self._AttachType

    @AttachType.setter
    def AttachType(self, AttachType):
        self._AttachType = AttachType


    def _deserialize(self, params):
        self._NetworkInterfaceId = params.get("NetworkInterfaceId")
        self._SourceInstanceId = params.get("SourceInstanceId")
        self._DestinationInstanceId = params.get("DestinationInstanceId")
        self._AttachType = params.get("AttachType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MigrateNetworkInterfaceResponse(AbstractModel):
    """MigrateNetworkInterface response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class MigratePrivateIpAddressRequest(AbstractModel):
    """MigratePrivateIpAddress request structure.

    """

    def __init__(self):
        r"""
        :param _SourceNetworkInterfaceId: ID of the ENI instance bound with the private IP, such as `eni-m6dyj72l`.
        :type SourceNetworkInterfaceId: str
        :param _DestinationNetworkInterfaceId: ID of the destination ENI instance to be migrated.
        :type DestinationNetworkInterfaceId: str
        :param _PrivateIpAddress: The private IP to be migrated, such as 10.0.0.6.
        :type PrivateIpAddress: str
        """
        self._SourceNetworkInterfaceId = None
        self._DestinationNetworkInterfaceId = None
        self._PrivateIpAddress = None

    @property
    def SourceNetworkInterfaceId(self):
        return self._SourceNetworkInterfaceId

    @SourceNetworkInterfaceId.setter
    def SourceNetworkInterfaceId(self, SourceNetworkInterfaceId):
        self._SourceNetworkInterfaceId = SourceNetworkInterfaceId

    @property
    def DestinationNetworkInterfaceId(self):
        return self._DestinationNetworkInterfaceId

    @DestinationNetworkInterfaceId.setter
    def DestinationNetworkInterfaceId(self, DestinationNetworkInterfaceId):
        self._DestinationNetworkInterfaceId = DestinationNetworkInterfaceId

    @property
    def PrivateIpAddress(self):
        return self._PrivateIpAddress

    @PrivateIpAddress.setter
    def PrivateIpAddress(self, PrivateIpAddress):
        self._PrivateIpAddress = PrivateIpAddress


    def _deserialize(self, params):
        self._SourceNetworkInterfaceId = params.get("SourceNetworkInterfaceId")
        self._DestinationNetworkInterfaceId = params.get("DestinationNetworkInterfaceId")
        self._PrivateIpAddress = params.get("PrivateIpAddress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MigratePrivateIpAddressResponse(AbstractModel):
    """MigratePrivateIpAddress response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyAddressAttributeRequest(AbstractModel):
    """ModifyAddressAttribute request structure.

    """

    def __init__(self):
        r"""
        :param _AddressId: The unique ID of the EIP, such as `eip-11112222`.
        :type AddressId: str
        :param _AddressName: The EIP name after modification. The maximum length is 20 characters.
        :type AddressName: str
        :param _EipDirectConnection: Whether the set EIP is a direct connection EIP. TRUE: yes. FALSE: no. Note that this parameter is available only to users who have activated the EIP direct connection function.
        :type EipDirectConnection: str
        """
        self._AddressId = None
        self._AddressName = None
        self._EipDirectConnection = None

    @property
    def AddressId(self):
        return self._AddressId

    @AddressId.setter
    def AddressId(self, AddressId):
        self._AddressId = AddressId

    @property
    def AddressName(self):
        return self._AddressName

    @AddressName.setter
    def AddressName(self, AddressName):
        self._AddressName = AddressName

    @property
    def EipDirectConnection(self):
        return self._EipDirectConnection

    @EipDirectConnection.setter
    def EipDirectConnection(self, EipDirectConnection):
        self._EipDirectConnection = EipDirectConnection


    def _deserialize(self, params):
        self._AddressId = params.get("AddressId")
        self._AddressName = params.get("AddressName")
        self._EipDirectConnection = params.get("EipDirectConnection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAddressAttributeResponse(AbstractModel):
    """ModifyAddressAttribute response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyAddressInternetChargeTypeRequest(AbstractModel):
    """ModifyAddressInternetChargeType request structure.

    """

    def __init__(self):
        r"""
        :param _AddressId: Unique EIP ID, such as "eip-xxxx"
        :type AddressId: str
        :param _InternetChargeType: The target billing method. It can be `BANDWIDTH_PREPAID_BY_MONTH` or `TRAFFIC_POSTPAID_BY_HOUR`
        :type InternetChargeType: str
        :param _InternetMaxBandwidthOut: The target bandwidth value
        :type InternetMaxBandwidthOut: int
        :param _AddressChargePrepaid: Billing details of monthly-subscribed network bandwidth. This parameter is required if the target billing method is `BANDWIDTH_PREPAID_BY_MONTH`.
        :type AddressChargePrepaid: :class:`tencentcloud.vpc.v20170312.models.AddressChargePrepaid`
        """
        self._AddressId = None
        self._InternetChargeType = None
        self._InternetMaxBandwidthOut = None
        self._AddressChargePrepaid = None

    @property
    def AddressId(self):
        return self._AddressId

    @AddressId.setter
    def AddressId(self, AddressId):
        self._AddressId = AddressId

    @property
    def InternetChargeType(self):
        return self._InternetChargeType

    @InternetChargeType.setter
    def InternetChargeType(self, InternetChargeType):
        self._InternetChargeType = InternetChargeType

    @property
    def InternetMaxBandwidthOut(self):
        return self._InternetMaxBandwidthOut

    @InternetMaxBandwidthOut.setter
    def InternetMaxBandwidthOut(self, InternetMaxBandwidthOut):
        self._InternetMaxBandwidthOut = InternetMaxBandwidthOut

    @property
    def AddressChargePrepaid(self):
        return self._AddressChargePrepaid

    @AddressChargePrepaid.setter
    def AddressChargePrepaid(self, AddressChargePrepaid):
        self._AddressChargePrepaid = AddressChargePrepaid


    def _deserialize(self, params):
        self._AddressId = params.get("AddressId")
        self._InternetChargeType = params.get("InternetChargeType")
        self._InternetMaxBandwidthOut = params.get("InternetMaxBandwidthOut")
        if params.get("AddressChargePrepaid") is not None:
            self._AddressChargePrepaid = AddressChargePrepaid()
            self._AddressChargePrepaid._deserialize(params.get("AddressChargePrepaid"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAddressInternetChargeTypeResponse(AbstractModel):
    """ModifyAddressInternetChargeType response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyAddressTemplateAttributeRequest(AbstractModel):
    """ModifyAddressTemplateAttribute request structure.

    """

    def __init__(self):
        r"""
        :param _AddressTemplateId: IP address template instance ID, such as `ipm-mdunqeb6`.
        :type AddressTemplateId: str
        :param _AddressTemplateName: IP address template name.
        :type AddressTemplateName: str
        :param _Addresses: Address information, including IP, CIDR and IP address range.
        :type Addresses: list of str
        :param _AddressesExtra: Address information with remarks, including the IP, CIDR block or IP address range.
        :type AddressesExtra: list of AddressInfo
        """
        self._AddressTemplateId = None
        self._AddressTemplateName = None
        self._Addresses = None
        self._AddressesExtra = None

    @property
    def AddressTemplateId(self):
        return self._AddressTemplateId

    @AddressTemplateId.setter
    def AddressTemplateId(self, AddressTemplateId):
        self._AddressTemplateId = AddressTemplateId

    @property
    def AddressTemplateName(self):
        return self._AddressTemplateName

    @AddressTemplateName.setter
    def AddressTemplateName(self, AddressTemplateName):
        self._AddressTemplateName = AddressTemplateName

    @property
    def Addresses(self):
        return self._Addresses

    @Addresses.setter
    def Addresses(self, Addresses):
        self._Addresses = Addresses

    @property
    def AddressesExtra(self):
        return self._AddressesExtra

    @AddressesExtra.setter
    def AddressesExtra(self, AddressesExtra):
        self._AddressesExtra = AddressesExtra


    def _deserialize(self, params):
        self._AddressTemplateId = params.get("AddressTemplateId")
        self._AddressTemplateName = params.get("AddressTemplateName")
        self._Addresses = params.get("Addresses")
        if params.get("AddressesExtra") is not None:
            self._AddressesExtra = []
            for item in params.get("AddressesExtra"):
                obj = AddressInfo()
                obj._deserialize(item)
                self._AddressesExtra.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAddressTemplateAttributeResponse(AbstractModel):
    """ModifyAddressTemplateAttribute response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyAddressTemplateGroupAttributeRequest(AbstractModel):
    """ModifyAddressTemplateGroupAttribute request structure.

    """

    def __init__(self):
        r"""
        :param _AddressTemplateGroupId: IP address template group instance ID, such as `ipmg-2uw6ujo6`.
        :type AddressTemplateGroupId: str
        :param _AddressTemplateGroupName: IP address template group name.
        :type AddressTemplateGroupName: str
        :param _AddressTemplateIds: IP address template instance ID, such as `ipm-mdunqeb6`.
        :type AddressTemplateIds: list of str
        """
        self._AddressTemplateGroupId = None
        self._AddressTemplateGroupName = None
        self._AddressTemplateIds = None

    @property
    def AddressTemplateGroupId(self):
        return self._AddressTemplateGroupId

    @AddressTemplateGroupId.setter
    def AddressTemplateGroupId(self, AddressTemplateGroupId):
        self._AddressTemplateGroupId = AddressTemplateGroupId

    @property
    def AddressTemplateGroupName(self):
        return self._AddressTemplateGroupName

    @AddressTemplateGroupName.setter
    def AddressTemplateGroupName(self, AddressTemplateGroupName):
        self._AddressTemplateGroupName = AddressTemplateGroupName

    @property
    def AddressTemplateIds(self):
        return self._AddressTemplateIds

    @AddressTemplateIds.setter
    def AddressTemplateIds(self, AddressTemplateIds):
        self._AddressTemplateIds = AddressTemplateIds


    def _deserialize(self, params):
        self._AddressTemplateGroupId = params.get("AddressTemplateGroupId")
        self._AddressTemplateGroupName = params.get("AddressTemplateGroupName")
        self._AddressTemplateIds = params.get("AddressTemplateIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAddressTemplateGroupAttributeResponse(AbstractModel):
    """ModifyAddressTemplateGroupAttribute response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyAddressesBandwidthRequest(AbstractModel):
    """ModifyAddressesBandwidth request structure.

    """

    def __init__(self):
        r"""
        :param _AddressIds: List of EIP IDs, such as “eip-xxxx”.
        :type AddressIds: list of str
        :param _InternetMaxBandwidthOut: Target bandwidth value adjustment
        :type InternetMaxBandwidthOut: int
        :param _StartTime: (Disused) The start time of the monthly bandwidth subscription
        :type StartTime: str
        :param _EndTime: (Disused) The end time of the monthly bandwidth subscription
        :type EndTime: str
        """
        self._AddressIds = None
        self._InternetMaxBandwidthOut = None
        self._StartTime = None
        self._EndTime = None

    @property
    def AddressIds(self):
        return self._AddressIds

    @AddressIds.setter
    def AddressIds(self, AddressIds):
        self._AddressIds = AddressIds

    @property
    def InternetMaxBandwidthOut(self):
        return self._InternetMaxBandwidthOut

    @InternetMaxBandwidthOut.setter
    def InternetMaxBandwidthOut(self, InternetMaxBandwidthOut):
        self._InternetMaxBandwidthOut = InternetMaxBandwidthOut

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._AddressIds = params.get("AddressIds")
        self._InternetMaxBandwidthOut = params.get("InternetMaxBandwidthOut")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAddressesBandwidthResponse(AbstractModel):
    """ModifyAddressesBandwidth response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: The async task ID. You can use the [DescribeTaskResult](https://intl.cloud.tencent.com/document/api/215/36271?from_cn_redirect=1) API to query the task status.
        :type TaskId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class ModifyAssistantCidrRequest(AbstractModel):
    """ModifyAssistantCidr request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: `VPC` instance `ID`, such as `vpc-6v2ht8q5`.
        :type VpcId: str
        :param _NewCidrBlocks: Array of the secondary CIDR blocks to be added, such as ["10.0.0.0/16", "172.16.0.0/16"]. At least one of `NewCidrBlocks` and `OldCidrBlocks` must be specified.
        :type NewCidrBlocks: list of str
        :param _OldCidrBlocks: Array of the secondary CIDR blocks to be deleted, such as ["10.0.0.0/16", "172.16.0.0/16"]. At least one of `NewCidrBlocks` or `OldCidrBlocks` must be specified.
        :type OldCidrBlocks: list of str
        """
        self._VpcId = None
        self._NewCidrBlocks = None
        self._OldCidrBlocks = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def NewCidrBlocks(self):
        return self._NewCidrBlocks

    @NewCidrBlocks.setter
    def NewCidrBlocks(self, NewCidrBlocks):
        self._NewCidrBlocks = NewCidrBlocks

    @property
    def OldCidrBlocks(self):
        return self._OldCidrBlocks

    @OldCidrBlocks.setter
    def OldCidrBlocks(self, OldCidrBlocks):
        self._OldCidrBlocks = OldCidrBlocks


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._NewCidrBlocks = params.get("NewCidrBlocks")
        self._OldCidrBlocks = params.get("OldCidrBlocks")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAssistantCidrResponse(AbstractModel):
    """ModifyAssistantCidr response structure.

    """

    def __init__(self):
        r"""
        :param _AssistantCidrSet: Array of secondary CIDR blocks.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AssistantCidrSet: list of AssistantCidr
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AssistantCidrSet = None
        self._RequestId = None

    @property
    def AssistantCidrSet(self):
        return self._AssistantCidrSet

    @AssistantCidrSet.setter
    def AssistantCidrSet(self, AssistantCidrSet):
        self._AssistantCidrSet = AssistantCidrSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AssistantCidrSet") is not None:
            self._AssistantCidrSet = []
            for item in params.get("AssistantCidrSet"):
                obj = AssistantCidr()
                obj._deserialize(item)
                self._AssistantCidrSet.append(obj)
        self._RequestId = params.get("RequestId")


class ModifyBandwidthPackageAttributeRequest(AbstractModel):
    """ModifyBandwidthPackageAttribute request structure.

    """

    def __init__(self):
        r"""
        :param _BandwidthPackageId: The unique ID of the bandwidth package.
        :type BandwidthPackageId: str
        :param _BandwidthPackageName: The name of the bandwidth package.
        :type BandwidthPackageName: str
        :param _ChargeType: The billing mode of the bandwidth package. Values: 
`TOP5_POSTPAID_BY_MONTH`: Bill by the top 5 bandwidth value of the current month in a postpaid manner
        :type ChargeType: str
        """
        self._BandwidthPackageId = None
        self._BandwidthPackageName = None
        self._ChargeType = None

    @property
    def BandwidthPackageId(self):
        return self._BandwidthPackageId

    @BandwidthPackageId.setter
    def BandwidthPackageId(self, BandwidthPackageId):
        self._BandwidthPackageId = BandwidthPackageId

    @property
    def BandwidthPackageName(self):
        return self._BandwidthPackageName

    @BandwidthPackageName.setter
    def BandwidthPackageName(self, BandwidthPackageName):
        self._BandwidthPackageName = BandwidthPackageName

    @property
    def ChargeType(self):
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType


    def _deserialize(self, params):
        self._BandwidthPackageId = params.get("BandwidthPackageId")
        self._BandwidthPackageName = params.get("BandwidthPackageName")
        self._ChargeType = params.get("ChargeType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyBandwidthPackageAttributeResponse(AbstractModel):
    """ModifyBandwidthPackageAttribute response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyCcnAttachedInstancesAttributeRequest(AbstractModel):
    """ModifyCcnAttachedInstancesAttribute request structure.

    """

    def __init__(self):
        r"""
        :param _CcnId: CCN instance ID in the format of `ccn-f49l6u0z`
        :type CcnId: str
        :param _Instances: List of associated network instances
        :type Instances: list of CcnInstance
        """
        self._CcnId = None
        self._Instances = None

    @property
    def CcnId(self):
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def Instances(self):
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = CcnInstance()
                obj._deserialize(item)
                self._Instances.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyCcnAttachedInstancesAttributeResponse(AbstractModel):
    """ModifyCcnAttachedInstancesAttribute response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyCcnAttributeRequest(AbstractModel):
    """ModifyCcnAttribute request structure.

    """

    def __init__(self):
        r"""
        :param _CcnId: The CCN instance ID, such as `ccn-f49l6u0z`.
        :type CcnId: str
        :param _CcnName: The name of CCN instance. Up to 60 characters allowed. It can contain up to 60 bytes. Either `CcnName` or `CcnDescription` must be specified.
        :type CcnName: str
        :param _CcnDescription: The description of CCN instance. Up to 100 characters allowed. It can contain up to 60 bytes. Either `CcnName` or `CcnDescription` must be specified.
        :type CcnDescription: str
        """
        self._CcnId = None
        self._CcnName = None
        self._CcnDescription = None

    @property
    def CcnId(self):
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def CcnName(self):
        return self._CcnName

    @CcnName.setter
    def CcnName(self, CcnName):
        self._CcnName = CcnName

    @property
    def CcnDescription(self):
        return self._CcnDescription

    @CcnDescription.setter
    def CcnDescription(self, CcnDescription):
        self._CcnDescription = CcnDescription


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        self._CcnName = params.get("CcnName")
        self._CcnDescription = params.get("CcnDescription")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyCcnAttributeResponse(AbstractModel):
    """ModifyCcnAttribute response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyCcnRegionBandwidthLimitsTypeRequest(AbstractModel):
    """ModifyCcnRegionBandwidthLimitsType request structure.

    """

    def __init__(self):
        r"""
        :param _CcnId: CCN instance ID.
        :type CcnId: str
        :param _BandwidthLimitType: CCN bandwidth limit type. INTER_REGION_LIMIT: limit between regions. OUTER_REGION_LIMIT: region egress limit.
        :type BandwidthLimitType: str
        """
        self._CcnId = None
        self._BandwidthLimitType = None

    @property
    def CcnId(self):
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def BandwidthLimitType(self):
        return self._BandwidthLimitType

    @BandwidthLimitType.setter
    def BandwidthLimitType(self, BandwidthLimitType):
        self._BandwidthLimitType = BandwidthLimitType


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        self._BandwidthLimitType = params.get("BandwidthLimitType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyCcnRegionBandwidthLimitsTypeResponse(AbstractModel):
    """ModifyCcnRegionBandwidthLimitsType response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyCustomerGatewayAttributeRequest(AbstractModel):
    """ModifyCustomerGatewayAttribute request structure.

    """

    def __init__(self):
        r"""
        :param _CustomerGatewayId: The ID of the customer gateway, such as `cgw-2wqq41m9`. You can query the customer gateway by using the [DescribeCustomerGateways](https://intl.cloud.tencent.com/document/api/215/17516?from_cn_redirect=1) API.
        :type CustomerGatewayId: str
        :param _CustomerGatewayName: Customer gateway can be named freely, but the maximum length is 60 characters.
        :type CustomerGatewayName: str
        """
        self._CustomerGatewayId = None
        self._CustomerGatewayName = None

    @property
    def CustomerGatewayId(self):
        return self._CustomerGatewayId

    @CustomerGatewayId.setter
    def CustomerGatewayId(self, CustomerGatewayId):
        self._CustomerGatewayId = CustomerGatewayId

    @property
    def CustomerGatewayName(self):
        return self._CustomerGatewayName

    @CustomerGatewayName.setter
    def CustomerGatewayName(self, CustomerGatewayName):
        self._CustomerGatewayName = CustomerGatewayName


    def _deserialize(self, params):
        self._CustomerGatewayId = params.get("CustomerGatewayId")
        self._CustomerGatewayName = params.get("CustomerGatewayName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyCustomerGatewayAttributeResponse(AbstractModel):
    """ModifyCustomerGatewayAttribute response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyDirectConnectGatewayAttributeRequest(AbstractModel):
    """ModifyDirectConnectGatewayAttribute request structure.

    """

    def __init__(self):
        r"""
        :param _DirectConnectGatewayId: The unique ID of the direct connect gateway, such as `dcg-9o233uri`.
        :type DirectConnectGatewayId: str
        :param _DirectConnectGatewayName: The direct connect gateway name. You can enter any name within 60 characters.
        :type DirectConnectGatewayName: str
        :param _CcnRouteType: The CCN route-learning type. Valid values: `BGP` (Automatic learning), `STATIC` (Static, that is, user-configured). You can only modify `CcnRouteType` for a CCN direct connect gateway with BGP enabled.
        :type CcnRouteType: str
        :param _ModeType: CCN route publishing method. Valid values: `standard` and `exquisite`. You can only modify `ModeType` for a CCN direct connect gateway.
        :type ModeType: str
        """
        self._DirectConnectGatewayId = None
        self._DirectConnectGatewayName = None
        self._CcnRouteType = None
        self._ModeType = None

    @property
    def DirectConnectGatewayId(self):
        return self._DirectConnectGatewayId

    @DirectConnectGatewayId.setter
    def DirectConnectGatewayId(self, DirectConnectGatewayId):
        self._DirectConnectGatewayId = DirectConnectGatewayId

    @property
    def DirectConnectGatewayName(self):
        return self._DirectConnectGatewayName

    @DirectConnectGatewayName.setter
    def DirectConnectGatewayName(self, DirectConnectGatewayName):
        self._DirectConnectGatewayName = DirectConnectGatewayName

    @property
    def CcnRouteType(self):
        return self._CcnRouteType

    @CcnRouteType.setter
    def CcnRouteType(self, CcnRouteType):
        self._CcnRouteType = CcnRouteType

    @property
    def ModeType(self):
        return self._ModeType

    @ModeType.setter
    def ModeType(self, ModeType):
        self._ModeType = ModeType


    def _deserialize(self, params):
        self._DirectConnectGatewayId = params.get("DirectConnectGatewayId")
        self._DirectConnectGatewayName = params.get("DirectConnectGatewayName")
        self._CcnRouteType = params.get("CcnRouteType")
        self._ModeType = params.get("ModeType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyDirectConnectGatewayAttributeResponse(AbstractModel):
    """ModifyDirectConnectGatewayAttribute response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyFlowLogAttributeRequest(AbstractModel):
    """ModifyFlowLogAttribute request structure.

    """

    def __init__(self):
        r"""
        :param _FlowLogId: The unique ID of the flow log.
        :type FlowLogId: str
        :param _VpcId: The VPC ID or unique ID of the resource. We recommend using the unique ID. This parameter is required unless the attributes of a CCN flow log is modified.
        :type VpcId: str
        :param _FlowLogName: The name of the flow log instance.
        :type FlowLogName: str
        :param _FlowLogDescription: The description of the flow log.
        :type FlowLogDescription: str
        """
        self._FlowLogId = None
        self._VpcId = None
        self._FlowLogName = None
        self._FlowLogDescription = None

    @property
    def FlowLogId(self):
        return self._FlowLogId

    @FlowLogId.setter
    def FlowLogId(self, FlowLogId):
        self._FlowLogId = FlowLogId

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def FlowLogName(self):
        return self._FlowLogName

    @FlowLogName.setter
    def FlowLogName(self, FlowLogName):
        self._FlowLogName = FlowLogName

    @property
    def FlowLogDescription(self):
        return self._FlowLogDescription

    @FlowLogDescription.setter
    def FlowLogDescription(self, FlowLogDescription):
        self._FlowLogDescription = FlowLogDescription


    def _deserialize(self, params):
        self._FlowLogId = params.get("FlowLogId")
        self._VpcId = params.get("VpcId")
        self._FlowLogName = params.get("FlowLogName")
        self._FlowLogDescription = params.get("FlowLogDescription")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyFlowLogAttributeResponse(AbstractModel):
    """ModifyFlowLogAttribute response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyGatewayFlowQosRequest(AbstractModel):
    """ModifyGatewayFlowQos request structure.

    """

    def __init__(self):
        r"""
        :param _GatewayId: Gateway instance ID. Supported types:
Direct connect gateway instance, such as `dcg-ltjahce6`;
NAT gateway instance, such as `nat-ltjahce6`;
VPN gateway instance, such as `vpn-ltjahce6`.
        :type GatewayId: str
        :param _Bandwidth: Bandwidth limit value in Mbps. Valid values: >0: Set the limit to the specified value. 0: Block all traffic. -1: No bandwidth limit.
        :type Bandwidth: int
        :param _IpAddresses: CVM private IP addresses with limited bandwidth.
        :type IpAddresses: list of str
        """
        self._GatewayId = None
        self._Bandwidth = None
        self._IpAddresses = None

    @property
    def GatewayId(self):
        return self._GatewayId

    @GatewayId.setter
    def GatewayId(self, GatewayId):
        self._GatewayId = GatewayId

    @property
    def Bandwidth(self):
        return self._Bandwidth

    @Bandwidth.setter
    def Bandwidth(self, Bandwidth):
        self._Bandwidth = Bandwidth

    @property
    def IpAddresses(self):
        return self._IpAddresses

    @IpAddresses.setter
    def IpAddresses(self, IpAddresses):
        self._IpAddresses = IpAddresses


    def _deserialize(self, params):
        self._GatewayId = params.get("GatewayId")
        self._Bandwidth = params.get("Bandwidth")
        self._IpAddresses = params.get("IpAddresses")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyGatewayFlowQosResponse(AbstractModel):
    """ModifyGatewayFlowQos response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyHaVipAttributeRequest(AbstractModel):
    """ModifyHaVipAttribute request structure.

    """

    def __init__(self):
        r"""
        :param _HaVipId: The unique `ID` of the `HAVIP`, such as `havip-9o233uri`.
        :type HaVipId: str
        :param _HaVipName: `HAVIP` can be named freely, but the maximum length is 60 characters.
        :type HaVipName: str
        """
        self._HaVipId = None
        self._HaVipName = None

    @property
    def HaVipId(self):
        return self._HaVipId

    @HaVipId.setter
    def HaVipId(self, HaVipId):
        self._HaVipId = HaVipId

    @property
    def HaVipName(self):
        return self._HaVipName

    @HaVipName.setter
    def HaVipName(self, HaVipName):
        self._HaVipName = HaVipName


    def _deserialize(self, params):
        self._HaVipId = params.get("HaVipId")
        self._HaVipName = params.get("HaVipName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyHaVipAttributeResponse(AbstractModel):
    """ModifyHaVipAttribute response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyIpv6AddressesAttributeRequest(AbstractModel):
    """ModifyIpv6AddressesAttribute request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkInterfaceId: The `ID` of the ENI instance, such as `eni-m6dyj72l`.
        :type NetworkInterfaceId: str
        :param _Ipv6Addresses: The information of the specified private `IPv6` addresses.
        :type Ipv6Addresses: list of Ipv6Address
        """
        self._NetworkInterfaceId = None
        self._Ipv6Addresses = None

    @property
    def NetworkInterfaceId(self):
        return self._NetworkInterfaceId

    @NetworkInterfaceId.setter
    def NetworkInterfaceId(self, NetworkInterfaceId):
        self._NetworkInterfaceId = NetworkInterfaceId

    @property
    def Ipv6Addresses(self):
        return self._Ipv6Addresses

    @Ipv6Addresses.setter
    def Ipv6Addresses(self, Ipv6Addresses):
        self._Ipv6Addresses = Ipv6Addresses


    def _deserialize(self, params):
        self._NetworkInterfaceId = params.get("NetworkInterfaceId")
        if params.get("Ipv6Addresses") is not None:
            self._Ipv6Addresses = []
            for item in params.get("Ipv6Addresses"):
                obj = Ipv6Address()
                obj._deserialize(item)
                self._Ipv6Addresses.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyIpv6AddressesAttributeResponse(AbstractModel):
    """ModifyIpv6AddressesAttribute response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyLocalGatewayRequest(AbstractModel):
    """ModifyLocalGateway request structure.

    """

    def __init__(self):
        r"""
        :param _LocalGatewayName: Local gateway name
        :type LocalGatewayName: str
        :param _CdcId: CDC instance ID
        :type CdcId: str
        :param _LocalGatewayId: Local gateway instance ID
        :type LocalGatewayId: str
        :param _VpcId: VPC instance ID
        :type VpcId: str
        """
        self._LocalGatewayName = None
        self._CdcId = None
        self._LocalGatewayId = None
        self._VpcId = None

    @property
    def LocalGatewayName(self):
        return self._LocalGatewayName

    @LocalGatewayName.setter
    def LocalGatewayName(self, LocalGatewayName):
        self._LocalGatewayName = LocalGatewayName

    @property
    def CdcId(self):
        return self._CdcId

    @CdcId.setter
    def CdcId(self, CdcId):
        self._CdcId = CdcId

    @property
    def LocalGatewayId(self):
        return self._LocalGatewayId

    @LocalGatewayId.setter
    def LocalGatewayId(self, LocalGatewayId):
        self._LocalGatewayId = LocalGatewayId

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId


    def _deserialize(self, params):
        self._LocalGatewayName = params.get("LocalGatewayName")
        self._CdcId = params.get("CdcId")
        self._LocalGatewayId = params.get("LocalGatewayId")
        self._VpcId = params.get("VpcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyLocalGatewayResponse(AbstractModel):
    """ModifyLocalGateway response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyNatGatewayAttributeRequest(AbstractModel):
    """ModifyNatGatewayAttribute request structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: The ID of the NAT gateway, such as `nat-df45454`.
        :type NatGatewayId: str
        :param _NatGatewayName: The NAT gateway name, such as `test_nat`.
        :type NatGatewayName: str
        :param _InternetMaxBandwidthOut: The maximum outbound bandwidth of the NAT gateway. Unit: Mbps.
        :type InternetMaxBandwidthOut: int
        :param _ModifySecurityGroup: Whether to modify the security group bound to the NAT gateway
        :type ModifySecurityGroup: bool
        :param _SecurityGroupIds: The final security groups bound to the NAT Gateway, such as `['sg-1n232323', 'sg-o4242424']`. An empty list indicates that all the security groups have been deleted.
        :type SecurityGroupIds: list of str
        """
        self._NatGatewayId = None
        self._NatGatewayName = None
        self._InternetMaxBandwidthOut = None
        self._ModifySecurityGroup = None
        self._SecurityGroupIds = None

    @property
    def NatGatewayId(self):
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def NatGatewayName(self):
        return self._NatGatewayName

    @NatGatewayName.setter
    def NatGatewayName(self, NatGatewayName):
        self._NatGatewayName = NatGatewayName

    @property
    def InternetMaxBandwidthOut(self):
        return self._InternetMaxBandwidthOut

    @InternetMaxBandwidthOut.setter
    def InternetMaxBandwidthOut(self, InternetMaxBandwidthOut):
        self._InternetMaxBandwidthOut = InternetMaxBandwidthOut

    @property
    def ModifySecurityGroup(self):
        return self._ModifySecurityGroup

    @ModifySecurityGroup.setter
    def ModifySecurityGroup(self, ModifySecurityGroup):
        self._ModifySecurityGroup = ModifySecurityGroup

    @property
    def SecurityGroupIds(self):
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        self._NatGatewayName = params.get("NatGatewayName")
        self._InternetMaxBandwidthOut = params.get("InternetMaxBandwidthOut")
        self._ModifySecurityGroup = params.get("ModifySecurityGroup")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyNatGatewayAttributeResponse(AbstractModel):
    """ModifyNatGatewayAttribute response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyNatGatewayDestinationIpPortTranslationNatRuleRequest(AbstractModel):
    """ModifyNatGatewayDestinationIpPortTranslationNatRule request structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: The ID of the NAT gateway, such as `nat-df45454`.
        :type NatGatewayId: str
        :param _SourceNatRule: The port forwarding rule of the source NAT gateway.
        :type SourceNatRule: :class:`tencentcloud.vpc.v20170312.models.DestinationIpPortTranslationNatRule`
        :param _DestinationNatRule: The port forwarding rule of the destination NAT gateway.
        :type DestinationNatRule: :class:`tencentcloud.vpc.v20170312.models.DestinationIpPortTranslationNatRule`
        """
        self._NatGatewayId = None
        self._SourceNatRule = None
        self._DestinationNatRule = None

    @property
    def NatGatewayId(self):
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def SourceNatRule(self):
        return self._SourceNatRule

    @SourceNatRule.setter
    def SourceNatRule(self, SourceNatRule):
        self._SourceNatRule = SourceNatRule

    @property
    def DestinationNatRule(self):
        return self._DestinationNatRule

    @DestinationNatRule.setter
    def DestinationNatRule(self, DestinationNatRule):
        self._DestinationNatRule = DestinationNatRule


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        if params.get("SourceNatRule") is not None:
            self._SourceNatRule = DestinationIpPortTranslationNatRule()
            self._SourceNatRule._deserialize(params.get("SourceNatRule"))
        if params.get("DestinationNatRule") is not None:
            self._DestinationNatRule = DestinationIpPortTranslationNatRule()
            self._DestinationNatRule._deserialize(params.get("DestinationNatRule"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyNatGatewayDestinationIpPortTranslationNatRuleResponse(AbstractModel):
    """ModifyNatGatewayDestinationIpPortTranslationNatRule response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyNatGatewaySourceIpTranslationNatRuleRequest(AbstractModel):
    """ModifyNatGatewaySourceIpTranslationNatRule request structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: The ID of the NAT Gateway, such as `nat-df453454`
        :type NatGatewayId: str
        :param _SourceIpTranslationNatRule: The SNAT forwarding rule of the NAT Gateway
        :type SourceIpTranslationNatRule: :class:`tencentcloud.vpc.v20170312.models.SourceIpTranslationNatRule`
        """
        self._NatGatewayId = None
        self._SourceIpTranslationNatRule = None

    @property
    def NatGatewayId(self):
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def SourceIpTranslationNatRule(self):
        return self._SourceIpTranslationNatRule

    @SourceIpTranslationNatRule.setter
    def SourceIpTranslationNatRule(self, SourceIpTranslationNatRule):
        self._SourceIpTranslationNatRule = SourceIpTranslationNatRule


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        if params.get("SourceIpTranslationNatRule") is not None:
            self._SourceIpTranslationNatRule = SourceIpTranslationNatRule()
            self._SourceIpTranslationNatRule._deserialize(params.get("SourceIpTranslationNatRule"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyNatGatewaySourceIpTranslationNatRuleResponse(AbstractModel):
    """ModifyNatGatewaySourceIpTranslationNatRule response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyNetDetectRequest(AbstractModel):
    """ModifyNetDetect request structure.

    """

    def __init__(self):
        r"""
        :param _NetDetectId: The ID of a network detection instance, such as `netd-12345678`.
        :type NetDetectId: str
        :param _NetDetectName: The name of a network detection instance. The maximum length is 60 characters.
        :type NetDetectName: str
        :param _DetectDestinationIp: The array of detection destination IPv4 addresses, which contains at most two IP addresses.
        :type DetectDestinationIp: list of str
        :param _NextHopType: Type of the next hop. Valid values:
`VPN`: VPN gateway;
`DIRECTCONNECT`: Direct connect gateway;
`PEERCONNECTION`: Peering connection;
`NAT`: NAT gateway;
`NORMAL_CVM`: CVM instance;
`CCN`: CCN instance;
`NONEXTHOP`: No next hop.
        :type NextHopType: str
        :param _NextHopDestination: ID of the next-hop gateway.
If NextHopType is set to VPN, the value of this parameter is the VPN gateway ID, such as vpngw-12345678.
`NextHopType` = `DIRECTCONNECT`: Direct connect gateway ID, such as `dcg-12345678`.
`NextHopType` = `PEERCONNECTION`: Peering connection ID, such as `pcx-12345678`.
`NextHopType` = `NAT`: NAT gateway ID, such as `nat-12345678`.
If NextHopType is set to NORMAL_CVM, the value of this parameter is the IPv4 address of the CVM, such as 10.0.0.12.
`NextHopType` = `CCN`: CCN instance ID, such as `ccn-12345678`.
`NextHopType` = `NONEXTHOP`: No next hop.
        :type NextHopDestination: str
        :param _NetDetectDescription: Network detection description.
        :type NetDetectDescription: str
        """
        self._NetDetectId = None
        self._NetDetectName = None
        self._DetectDestinationIp = None
        self._NextHopType = None
        self._NextHopDestination = None
        self._NetDetectDescription = None

    @property
    def NetDetectId(self):
        return self._NetDetectId

    @NetDetectId.setter
    def NetDetectId(self, NetDetectId):
        self._NetDetectId = NetDetectId

    @property
    def NetDetectName(self):
        return self._NetDetectName

    @NetDetectName.setter
    def NetDetectName(self, NetDetectName):
        self._NetDetectName = NetDetectName

    @property
    def DetectDestinationIp(self):
        return self._DetectDestinationIp

    @DetectDestinationIp.setter
    def DetectDestinationIp(self, DetectDestinationIp):
        self._DetectDestinationIp = DetectDestinationIp

    @property
    def NextHopType(self):
        return self._NextHopType

    @NextHopType.setter
    def NextHopType(self, NextHopType):
        self._NextHopType = NextHopType

    @property
    def NextHopDestination(self):
        return self._NextHopDestination

    @NextHopDestination.setter
    def NextHopDestination(self, NextHopDestination):
        self._NextHopDestination = NextHopDestination

    @property
    def NetDetectDescription(self):
        return self._NetDetectDescription

    @NetDetectDescription.setter
    def NetDetectDescription(self, NetDetectDescription):
        self._NetDetectDescription = NetDetectDescription


    def _deserialize(self, params):
        self._NetDetectId = params.get("NetDetectId")
        self._NetDetectName = params.get("NetDetectName")
        self._DetectDestinationIp = params.get("DetectDestinationIp")
        self._NextHopType = params.get("NextHopType")
        self._NextHopDestination = params.get("NextHopDestination")
        self._NetDetectDescription = params.get("NetDetectDescription")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyNetDetectResponse(AbstractModel):
    """ModifyNetDetect response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyNetworkAclAttributeRequest(AbstractModel):
    """ModifyNetworkAclAttribute request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkAclId: Network ACL instance ID, such as `acl-12345678`.
        :type NetworkAclId: str
        :param _NetworkAclName: Network ACL name, which can contain up to 60 bytes.
        :type NetworkAclName: str
        """
        self._NetworkAclId = None
        self._NetworkAclName = None

    @property
    def NetworkAclId(self):
        return self._NetworkAclId

    @NetworkAclId.setter
    def NetworkAclId(self, NetworkAclId):
        self._NetworkAclId = NetworkAclId

    @property
    def NetworkAclName(self):
        return self._NetworkAclName

    @NetworkAclName.setter
    def NetworkAclName(self, NetworkAclName):
        self._NetworkAclName = NetworkAclName


    def _deserialize(self, params):
        self._NetworkAclId = params.get("NetworkAclId")
        self._NetworkAclName = params.get("NetworkAclName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyNetworkAclAttributeResponse(AbstractModel):
    """ModifyNetworkAclAttribute response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyNetworkAclEntriesRequest(AbstractModel):
    """ModifyNetworkAclEntries request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkAclId: Network ACL instance ID, such as `acl-12345678`.
        :type NetworkAclId: str
        :param _NetworkAclEntrySet: Network ACL rule set. `NetworkAclEntrySet` and `NetworkAclQuintupleSet` cannot be entered at the same time.
        :type NetworkAclEntrySet: :class:`tencentcloud.vpc.v20170312.models.NetworkAclEntrySet`
        :param _NetworkAclQuintupleSet: Network ACL quintuple rule set. `NetworkAclEntrySet` and `NetworkAclQuintupleSet` cannot be entered at the same time.
        :type NetworkAclQuintupleSet: :class:`tencentcloud.vpc.v20170312.models.NetworkAclQuintupleEntries`
        """
        self._NetworkAclId = None
        self._NetworkAclEntrySet = None
        self._NetworkAclQuintupleSet = None

    @property
    def NetworkAclId(self):
        return self._NetworkAclId

    @NetworkAclId.setter
    def NetworkAclId(self, NetworkAclId):
        self._NetworkAclId = NetworkAclId

    @property
    def NetworkAclEntrySet(self):
        return self._NetworkAclEntrySet

    @NetworkAclEntrySet.setter
    def NetworkAclEntrySet(self, NetworkAclEntrySet):
        self._NetworkAclEntrySet = NetworkAclEntrySet

    @property
    def NetworkAclQuintupleSet(self):
        return self._NetworkAclQuintupleSet

    @NetworkAclQuintupleSet.setter
    def NetworkAclQuintupleSet(self, NetworkAclQuintupleSet):
        self._NetworkAclQuintupleSet = NetworkAclQuintupleSet


    def _deserialize(self, params):
        self._NetworkAclId = params.get("NetworkAclId")
        if params.get("NetworkAclEntrySet") is not None:
            self._NetworkAclEntrySet = NetworkAclEntrySet()
            self._NetworkAclEntrySet._deserialize(params.get("NetworkAclEntrySet"))
        if params.get("NetworkAclQuintupleSet") is not None:
            self._NetworkAclQuintupleSet = NetworkAclQuintupleEntries()
            self._NetworkAclQuintupleSet._deserialize(params.get("NetworkAclQuintupleSet"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyNetworkAclEntriesResponse(AbstractModel):
    """ModifyNetworkAclEntries response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyNetworkAclQuintupleEntriesRequest(AbstractModel):
    """ModifyNetworkAclQuintupleEntries request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkAclId: Network ACL instance ID, such as `acl-12345678`.
        :type NetworkAclId: str
        :param _NetworkAclQuintupleSet: Network ACL quintuple rule set.
        :type NetworkAclQuintupleSet: :class:`tencentcloud.vpc.v20170312.models.NetworkAclQuintupleEntries`
        """
        self._NetworkAclId = None
        self._NetworkAclQuintupleSet = None

    @property
    def NetworkAclId(self):
        return self._NetworkAclId

    @NetworkAclId.setter
    def NetworkAclId(self, NetworkAclId):
        self._NetworkAclId = NetworkAclId

    @property
    def NetworkAclQuintupleSet(self):
        return self._NetworkAclQuintupleSet

    @NetworkAclQuintupleSet.setter
    def NetworkAclQuintupleSet(self, NetworkAclQuintupleSet):
        self._NetworkAclQuintupleSet = NetworkAclQuintupleSet


    def _deserialize(self, params):
        self._NetworkAclId = params.get("NetworkAclId")
        if params.get("NetworkAclQuintupleSet") is not None:
            self._NetworkAclQuintupleSet = NetworkAclQuintupleEntries()
            self._NetworkAclQuintupleSet._deserialize(params.get("NetworkAclQuintupleSet"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyNetworkAclQuintupleEntriesResponse(AbstractModel):
    """ModifyNetworkAclQuintupleEntries response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyNetworkInterfaceAttributeRequest(AbstractModel):
    """ModifyNetworkInterfaceAttribute request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkInterfaceId: The ID of the ENI instance, such as `eni-pxir56ns`.
        :type NetworkInterfaceId: str
        :param _NetworkInterfaceName: The name of the ENI. The maximum length is 60 characters.
        :type NetworkInterfaceName: str
        :param _NetworkInterfaceDescription: ENI description can be named freely, but the maximum length is 60 characters.
        :type NetworkInterfaceDescription: str
        :param _SecurityGroupIds: The specified security groups to be bound with, such as ['sg-1dd51d'].
        :type SecurityGroupIds: list of str
        :param _TrunkingFlag: Configuration of the ENI trunking mode. Valid values: `Enable` and `Disable`. Default value: `Disable`.
        :type TrunkingFlag: str
        """
        self._NetworkInterfaceId = None
        self._NetworkInterfaceName = None
        self._NetworkInterfaceDescription = None
        self._SecurityGroupIds = None
        self._TrunkingFlag = None

    @property
    def NetworkInterfaceId(self):
        return self._NetworkInterfaceId

    @NetworkInterfaceId.setter
    def NetworkInterfaceId(self, NetworkInterfaceId):
        self._NetworkInterfaceId = NetworkInterfaceId

    @property
    def NetworkInterfaceName(self):
        return self._NetworkInterfaceName

    @NetworkInterfaceName.setter
    def NetworkInterfaceName(self, NetworkInterfaceName):
        self._NetworkInterfaceName = NetworkInterfaceName

    @property
    def NetworkInterfaceDescription(self):
        return self._NetworkInterfaceDescription

    @NetworkInterfaceDescription.setter
    def NetworkInterfaceDescription(self, NetworkInterfaceDescription):
        self._NetworkInterfaceDescription = NetworkInterfaceDescription

    @property
    def SecurityGroupIds(self):
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def TrunkingFlag(self):
        return self._TrunkingFlag

    @TrunkingFlag.setter
    def TrunkingFlag(self, TrunkingFlag):
        self._TrunkingFlag = TrunkingFlag


    def _deserialize(self, params):
        self._NetworkInterfaceId = params.get("NetworkInterfaceId")
        self._NetworkInterfaceName = params.get("NetworkInterfaceName")
        self._NetworkInterfaceDescription = params.get("NetworkInterfaceDescription")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        self._TrunkingFlag = params.get("TrunkingFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyNetworkInterfaceAttributeResponse(AbstractModel):
    """ModifyNetworkInterfaceAttribute response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyPrivateIpAddressesAttributeRequest(AbstractModel):
    """ModifyPrivateIpAddressesAttribute request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkInterfaceId: The ID of the ENI instance, such as `eni-m6dyj72l`.
        :type NetworkInterfaceId: str
        :param _PrivateIpAddresses: The specified private IP information.
        :type PrivateIpAddresses: list of PrivateIpAddressSpecification
        """
        self._NetworkInterfaceId = None
        self._PrivateIpAddresses = None

    @property
    def NetworkInterfaceId(self):
        return self._NetworkInterfaceId

    @NetworkInterfaceId.setter
    def NetworkInterfaceId(self, NetworkInterfaceId):
        self._NetworkInterfaceId = NetworkInterfaceId

    @property
    def PrivateIpAddresses(self):
        return self._PrivateIpAddresses

    @PrivateIpAddresses.setter
    def PrivateIpAddresses(self, PrivateIpAddresses):
        self._PrivateIpAddresses = PrivateIpAddresses


    def _deserialize(self, params):
        self._NetworkInterfaceId = params.get("NetworkInterfaceId")
        if params.get("PrivateIpAddresses") is not None:
            self._PrivateIpAddresses = []
            for item in params.get("PrivateIpAddresses"):
                obj = PrivateIpAddressSpecification()
                obj._deserialize(item)
                self._PrivateIpAddresses.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyPrivateIpAddressesAttributeResponse(AbstractModel):
    """ModifyPrivateIpAddressesAttribute response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyRouteTableAttributeRequest(AbstractModel):
    """ModifyRouteTableAttribute request structure.

    """

    def __init__(self):
        r"""
        :param _RouteTableId: The route table instance ID, such as `rtb-azd4dt1c`.
        :type RouteTableId: str
        :param _RouteTableName: Route table name.
        :type RouteTableName: str
        """
        self._RouteTableId = None
        self._RouteTableName = None

    @property
    def RouteTableId(self):
        return self._RouteTableId

    @RouteTableId.setter
    def RouteTableId(self, RouteTableId):
        self._RouteTableId = RouteTableId

    @property
    def RouteTableName(self):
        return self._RouteTableName

    @RouteTableName.setter
    def RouteTableName(self, RouteTableName):
        self._RouteTableName = RouteTableName


    def _deserialize(self, params):
        self._RouteTableId = params.get("RouteTableId")
        self._RouteTableName = params.get("RouteTableName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyRouteTableAttributeResponse(AbstractModel):
    """ModifyRouteTableAttribute response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifySecurityGroupAttributeRequest(AbstractModel):
    """ModifySecurityGroupAttribute request structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroupId: The security group instance ID, such as `sg-33ocnj9n`. This can be obtained through DescribeSecurityGroups.
        :type SecurityGroupId: str
        :param _GroupName: Security group can be named freely, but cannot exceed 60 characters.
        :type GroupName: str
        :param _GroupDescription: The remarks for the security group. The maximum length is 100 characters.
        :type GroupDescription: str
        """
        self._SecurityGroupId = None
        self._GroupName = None
        self._GroupDescription = None

    @property
    def SecurityGroupId(self):
        return self._SecurityGroupId

    @SecurityGroupId.setter
    def SecurityGroupId(self, SecurityGroupId):
        self._SecurityGroupId = SecurityGroupId

    @property
    def GroupName(self):
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def GroupDescription(self):
        return self._GroupDescription

    @GroupDescription.setter
    def GroupDescription(self, GroupDescription):
        self._GroupDescription = GroupDescription


    def _deserialize(self, params):
        self._SecurityGroupId = params.get("SecurityGroupId")
        self._GroupName = params.get("GroupName")
        self._GroupDescription = params.get("GroupDescription")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifySecurityGroupAttributeResponse(AbstractModel):
    """ModifySecurityGroupAttribute response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifySecurityGroupPoliciesRequest(AbstractModel):
    """ModifySecurityGroupPolicies request structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroupId: The security group instance ID, such as `sg-33ocnj9n`. This can be obtained through DescribeSecurityGroups.
        :type SecurityGroupId: str
        :param _SecurityGroupPolicySet: The security group policy set. SecurityGroupPolicySet object must specify new egress and ingress policies at the same time. SecurityGroupPolicy object does not support custom index (PolicyIndex).
        :type SecurityGroupPolicySet: :class:`tencentcloud.vpc.v20170312.models.SecurityGroupPolicySet`
        :param _SortPolicys: Whether the security group rule is sorted. Default value: False. If it is set to `True`, security group rules will be strictly sorted according to the sequence specified in the `SecurityGroupPolicySet` parameter. Manual entry may cause omission, so we recommend sorting security group rules in the console.
        :type SortPolicys: bool
        """
        self._SecurityGroupId = None
        self._SecurityGroupPolicySet = None
        self._SortPolicys = None

    @property
    def SecurityGroupId(self):
        return self._SecurityGroupId

    @SecurityGroupId.setter
    def SecurityGroupId(self, SecurityGroupId):
        self._SecurityGroupId = SecurityGroupId

    @property
    def SecurityGroupPolicySet(self):
        return self._SecurityGroupPolicySet

    @SecurityGroupPolicySet.setter
    def SecurityGroupPolicySet(self, SecurityGroupPolicySet):
        self._SecurityGroupPolicySet = SecurityGroupPolicySet

    @property
    def SortPolicys(self):
        return self._SortPolicys

    @SortPolicys.setter
    def SortPolicys(self, SortPolicys):
        self._SortPolicys = SortPolicys


    def _deserialize(self, params):
        self._SecurityGroupId = params.get("SecurityGroupId")
        if params.get("SecurityGroupPolicySet") is not None:
            self._SecurityGroupPolicySet = SecurityGroupPolicySet()
            self._SecurityGroupPolicySet._deserialize(params.get("SecurityGroupPolicySet"))
        self._SortPolicys = params.get("SortPolicys")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifySecurityGroupPoliciesResponse(AbstractModel):
    """ModifySecurityGroupPolicies response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyServiceTemplateAttributeRequest(AbstractModel):
    """ModifyServiceTemplateAttribute request structure.

    """

    def __init__(self):
        r"""
        :param _ServiceTemplateId: Protocol port template instance ID, such as `ppm-529nwwj8`.
        :type ServiceTemplateId: str
        :param _ServiceTemplateName: Protocol port template name.
        :type ServiceTemplateName: str
        :param _Services: It supports single port, multiple ports, consecutive ports and all ports. Supported protocols include TCP, UDP, ICMP, and GRE.
        :type Services: list of str
        :param _ServicesExtra: Protocol port information with remarks. Supported ports include single port, multiple ports, consecutive ports and other ports. Supported protocols include TCP, UDP, ICMP, and GRE.
        :type ServicesExtra: list of ServicesInfo
        """
        self._ServiceTemplateId = None
        self._ServiceTemplateName = None
        self._Services = None
        self._ServicesExtra = None

    @property
    def ServiceTemplateId(self):
        return self._ServiceTemplateId

    @ServiceTemplateId.setter
    def ServiceTemplateId(self, ServiceTemplateId):
        self._ServiceTemplateId = ServiceTemplateId

    @property
    def ServiceTemplateName(self):
        return self._ServiceTemplateName

    @ServiceTemplateName.setter
    def ServiceTemplateName(self, ServiceTemplateName):
        self._ServiceTemplateName = ServiceTemplateName

    @property
    def Services(self):
        return self._Services

    @Services.setter
    def Services(self, Services):
        self._Services = Services

    @property
    def ServicesExtra(self):
        return self._ServicesExtra

    @ServicesExtra.setter
    def ServicesExtra(self, ServicesExtra):
        self._ServicesExtra = ServicesExtra


    def _deserialize(self, params):
        self._ServiceTemplateId = params.get("ServiceTemplateId")
        self._ServiceTemplateName = params.get("ServiceTemplateName")
        self._Services = params.get("Services")
        if params.get("ServicesExtra") is not None:
            self._ServicesExtra = []
            for item in params.get("ServicesExtra"):
                obj = ServicesInfo()
                obj._deserialize(item)
                self._ServicesExtra.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyServiceTemplateAttributeResponse(AbstractModel):
    """ModifyServiceTemplateAttribute response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyServiceTemplateGroupAttributeRequest(AbstractModel):
    """ModifyServiceTemplateGroupAttribute request structure.

    """

    def __init__(self):
        r"""
        :param _ServiceTemplateGroupId: The protocol port template group instance ID, such as `ppmg-ei8hfd9a`.
        :type ServiceTemplateGroupId: str
        :param _ServiceTemplateGroupName: Protocol port template group name.
        :type ServiceTemplateGroupName: str
        :param _ServiceTemplateIds: Instance ID of the protocol port template, such as `ppm-4dw6agho`.
        :type ServiceTemplateIds: list of str
        """
        self._ServiceTemplateGroupId = None
        self._ServiceTemplateGroupName = None
        self._ServiceTemplateIds = None

    @property
    def ServiceTemplateGroupId(self):
        return self._ServiceTemplateGroupId

    @ServiceTemplateGroupId.setter
    def ServiceTemplateGroupId(self, ServiceTemplateGroupId):
        self._ServiceTemplateGroupId = ServiceTemplateGroupId

    @property
    def ServiceTemplateGroupName(self):
        return self._ServiceTemplateGroupName

    @ServiceTemplateGroupName.setter
    def ServiceTemplateGroupName(self, ServiceTemplateGroupName):
        self._ServiceTemplateGroupName = ServiceTemplateGroupName

    @property
    def ServiceTemplateIds(self):
        return self._ServiceTemplateIds

    @ServiceTemplateIds.setter
    def ServiceTemplateIds(self, ServiceTemplateIds):
        self._ServiceTemplateIds = ServiceTemplateIds


    def _deserialize(self, params):
        self._ServiceTemplateGroupId = params.get("ServiceTemplateGroupId")
        self._ServiceTemplateGroupName = params.get("ServiceTemplateGroupName")
        self._ServiceTemplateIds = params.get("ServiceTemplateIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyServiceTemplateGroupAttributeResponse(AbstractModel):
    """ModifyServiceTemplateGroupAttribute response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifySnapshotPoliciesRequest(AbstractModel):
    """ModifySnapshotPolicies request structure.

    """

    def __init__(self):
        r"""
        :param _SnapshotPoliciesInfo: Modify snapshot policies
        :type SnapshotPoliciesInfo: list of BatchModifySnapshotPolicy
        """
        self._SnapshotPoliciesInfo = None

    @property
    def SnapshotPoliciesInfo(self):
        return self._SnapshotPoliciesInfo

    @SnapshotPoliciesInfo.setter
    def SnapshotPoliciesInfo(self, SnapshotPoliciesInfo):
        self._SnapshotPoliciesInfo = SnapshotPoliciesInfo


    def _deserialize(self, params):
        if params.get("SnapshotPoliciesInfo") is not None:
            self._SnapshotPoliciesInfo = []
            for item in params.get("SnapshotPoliciesInfo"):
                obj = BatchModifySnapshotPolicy()
                obj._deserialize(item)
                self._SnapshotPoliciesInfo.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifySnapshotPoliciesResponse(AbstractModel):
    """ModifySnapshotPolicies response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifySubnetAttributeRequest(AbstractModel):
    """ModifySubnetAttribute request structure.

    """

    def __init__(self):
        r"""
        :param _SubnetId: Subnet instance ID, such as `subnet-pxir56ns`.
        :type SubnetId: str
        :param _SubnetName: The subnet name. The maximum length is 60 bytes.
        :type SubnetName: str
        :param _EnableBroadcast: Whether the subnet has broadcast enabled.
        :type EnableBroadcast: str
        """
        self._SubnetId = None
        self._SubnetName = None
        self._EnableBroadcast = None

    @property
    def SubnetId(self):
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def SubnetName(self):
        return self._SubnetName

    @SubnetName.setter
    def SubnetName(self, SubnetName):
        self._SubnetName = SubnetName

    @property
    def EnableBroadcast(self):
        return self._EnableBroadcast

    @EnableBroadcast.setter
    def EnableBroadcast(self, EnableBroadcast):
        self._EnableBroadcast = EnableBroadcast


    def _deserialize(self, params):
        self._SubnetId = params.get("SubnetId")
        self._SubnetName = params.get("SubnetName")
        self._EnableBroadcast = params.get("EnableBroadcast")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifySubnetAttributeResponse(AbstractModel):
    """ModifySubnetAttribute response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyVpcAttributeRequest(AbstractModel):
    """ModifyVpcAttribute request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: Security group can be named freely, but cannot exceed 60 characters.
        :type VpcId: str
        :param _VpcName: VPC can be named freely, but the maximum length is 60 characters.
        :type VpcName: str
        :param _EnableMulticast: Whether multicast is enabled. `true`: Enabled. `false`: Off.
        :type EnableMulticast: str
        :param _DnsServers: DNS address. A maximum of 4 addresses is supported. The first one is primary server by default, and the rest are secondary servers.
        :type DnsServers: list of str
        :param _DomainName: Domain name
        :type DomainName: str
        :param _EnableCdcPublish: Whether to publish the CDC subnet to CCN. `true`: Publish; `false`: u200dDo not publish
        :type EnableCdcPublish: bool
        """
        self._VpcId = None
        self._VpcName = None
        self._EnableMulticast = None
        self._DnsServers = None
        self._DomainName = None
        self._EnableCdcPublish = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def VpcName(self):
        return self._VpcName

    @VpcName.setter
    def VpcName(self, VpcName):
        self._VpcName = VpcName

    @property
    def EnableMulticast(self):
        return self._EnableMulticast

    @EnableMulticast.setter
    def EnableMulticast(self, EnableMulticast):
        self._EnableMulticast = EnableMulticast

    @property
    def DnsServers(self):
        return self._DnsServers

    @DnsServers.setter
    def DnsServers(self, DnsServers):
        self._DnsServers = DnsServers

    @property
    def DomainName(self):
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def EnableCdcPublish(self):
        return self._EnableCdcPublish

    @EnableCdcPublish.setter
    def EnableCdcPublish(self, EnableCdcPublish):
        self._EnableCdcPublish = EnableCdcPublish


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._VpcName = params.get("VpcName")
        self._EnableMulticast = params.get("EnableMulticast")
        self._DnsServers = params.get("DnsServers")
        self._DomainName = params.get("DomainName")
        self._EnableCdcPublish = params.get("EnableCdcPublish")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyVpcAttributeResponse(AbstractModel):
    """ModifyVpcAttribute response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyVpcEndPointAttributeRequest(AbstractModel):
    """ModifyVpcEndPointAttribute request structure.

    """

    def __init__(self):
        r"""
        :param _EndPointId: Endpoint ID
        :type EndPointId: str
        :param _EndPointName: Endpoint name
        :type EndPointName: str
        :param _SecurityGroupIds: List of security group IDs
        :type SecurityGroupIds: list of str
        """
        self._EndPointId = None
        self._EndPointName = None
        self._SecurityGroupIds = None

    @property
    def EndPointId(self):
        return self._EndPointId

    @EndPointId.setter
    def EndPointId(self, EndPointId):
        self._EndPointId = EndPointId

    @property
    def EndPointName(self):
        return self._EndPointName

    @EndPointName.setter
    def EndPointName(self, EndPointName):
        self._EndPointName = EndPointName

    @property
    def SecurityGroupIds(self):
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds


    def _deserialize(self, params):
        self._EndPointId = params.get("EndPointId")
        self._EndPointName = params.get("EndPointName")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyVpcEndPointAttributeResponse(AbstractModel):
    """ModifyVpcEndPointAttribute response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyVpcEndPointServiceAttributeRequest(AbstractModel):
    """ModifyVpcEndPointServiceAttribute request structure.

    """

    def __init__(self):
        r"""
        :param _EndPointServiceId: Endpoint service ID
        :type EndPointServiceId: str
        :param _VpcId: VPC ID
        :type VpcId: str
        :param _EndPointServiceName: Endpoint service name
        :type EndPointServiceName: str
        :param _AutoAcceptFlag: Whether to automatically accept VPC endpoint connection requests. Valid values: <ui><li>`true`: yes<li>`false`: no</ul>
        :type AutoAcceptFlag: bool
        :param _ServiceInstanceId: Real server ID in the format of `lb-xxx`.
        :type ServiceInstanceId: str
        """
        self._EndPointServiceId = None
        self._VpcId = None
        self._EndPointServiceName = None
        self._AutoAcceptFlag = None
        self._ServiceInstanceId = None

    @property
    def EndPointServiceId(self):
        return self._EndPointServiceId

    @EndPointServiceId.setter
    def EndPointServiceId(self, EndPointServiceId):
        self._EndPointServiceId = EndPointServiceId

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def EndPointServiceName(self):
        return self._EndPointServiceName

    @EndPointServiceName.setter
    def EndPointServiceName(self, EndPointServiceName):
        self._EndPointServiceName = EndPointServiceName

    @property
    def AutoAcceptFlag(self):
        return self._AutoAcceptFlag

    @AutoAcceptFlag.setter
    def AutoAcceptFlag(self, AutoAcceptFlag):
        self._AutoAcceptFlag = AutoAcceptFlag

    @property
    def ServiceInstanceId(self):
        return self._ServiceInstanceId

    @ServiceInstanceId.setter
    def ServiceInstanceId(self, ServiceInstanceId):
        self._ServiceInstanceId = ServiceInstanceId


    def _deserialize(self, params):
        self._EndPointServiceId = params.get("EndPointServiceId")
        self._VpcId = params.get("VpcId")
        self._EndPointServiceName = params.get("EndPointServiceName")
        self._AutoAcceptFlag = params.get("AutoAcceptFlag")
        self._ServiceInstanceId = params.get("ServiceInstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyVpcEndPointServiceAttributeResponse(AbstractModel):
    """ModifyVpcEndPointServiceAttribute response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyVpcEndPointServiceWhiteListRequest(AbstractModel):
    """ModifyVpcEndPointServiceWhiteList request structure.

    """

    def __init__(self):
        r"""
        :param _UserUin: User UIN
        :type UserUin: str
        :param _EndPointServiceId: Endpoint service ID
        :type EndPointServiceId: str
        :param _Description: Allowlist description
        :type Description: str
        """
        self._UserUin = None
        self._EndPointServiceId = None
        self._Description = None

    @property
    def UserUin(self):
        return self._UserUin

    @UserUin.setter
    def UserUin(self, UserUin):
        self._UserUin = UserUin

    @property
    def EndPointServiceId(self):
        return self._EndPointServiceId

    @EndPointServiceId.setter
    def EndPointServiceId(self, EndPointServiceId):
        self._EndPointServiceId = EndPointServiceId

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._UserUin = params.get("UserUin")
        self._EndPointServiceId = params.get("EndPointServiceId")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyVpcEndPointServiceWhiteListResponse(AbstractModel):
    """ModifyVpcEndPointServiceWhiteList response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyVpnConnectionAttributeRequest(AbstractModel):
    """ModifyVpnConnectionAttribute request structure.

    """

    def __init__(self):
        r"""
        :param _VpnConnectionId: The ID of the VPN tunnel instance, such as `vpnx-f49l6u0z`.
        :type VpnConnectionId: str
        :param _VpnConnectionName: VPN tunnel can be named freely, but the maximum length is 60 characters.
        :type VpnConnectionName: str
        :param _PreShareKey: The pre-shared key.
        :type PreShareKey: str
        :param _SecurityPolicyDatabases: SPD policy group. Taking {"10.0.0.5/24":["172.123.10.5/16"]} as an example, 10.0.0.5/24 is the VPC private IP range, and 172.123.10.5/16 is the IDC IP range. The user specifies the IP range in the VPC that can communicate with the IP range in the IDC.
        :type SecurityPolicyDatabases: list of SecurityPolicyDatabase
        :param _IKEOptionsSpecification: IKE (Internet Key Exchange) configuration. IKE comes with a self-protection mechanism. The network security protocol is configured by the user.
        :type IKEOptionsSpecification: :class:`tencentcloud.vpc.v20170312.models.IKEOptionsSpecification`
        :param _IPSECOptionsSpecification: IPSec configuration. The IPSec secure session configuration is provided by Tencent Cloud.
        :type IPSECOptionsSpecification: :class:`tencentcloud.vpc.v20170312.models.IPSECOptionsSpecification`
        :param _EnableHealthCheck: Whether to enable the tunnel health check. The default value is `False`.
        :type EnableHealthCheck: bool
        :param _HealthCheckLocalIp: Local IP address for the tunnel health check
        :type HealthCheckLocalIp: str
        :param _HealthCheckRemoteIp: Peer IP address for the tunnel health check
        :type HealthCheckRemoteIp: str
        :param _NegotiationType: Negotiation type. Valid values: `active` (default value), `passive` and `flowTrigger`.
        :type NegotiationType: str
        :param _DpdEnable: Specifies whether to enable DPD. Valid values: `0` (disable) and `1` (enable)
        :type DpdEnable: int
        :param _DpdTimeout: DPD timeout period. Default: 30; unit: second. If the request is not responded within this period, the peer end is considered not exists. This parameter is valid when the value of `DpdEnable` is 1. 
        :type DpdTimeout: str
        :param _DpdAction: The action after DPD timeout. Valid values: `clear` (disconnect) and `restart` (try again). It’s valid when `DpdEnable` is `1`. 
        :type DpdAction: str
        :param _CustomerGatewayId: Peer gateway ID. You can update tunnels of V4.0 and later gateways.
        :type CustomerGatewayId: str
        """
        self._VpnConnectionId = None
        self._VpnConnectionName = None
        self._PreShareKey = None
        self._SecurityPolicyDatabases = None
        self._IKEOptionsSpecification = None
        self._IPSECOptionsSpecification = None
        self._EnableHealthCheck = None
        self._HealthCheckLocalIp = None
        self._HealthCheckRemoteIp = None
        self._NegotiationType = None
        self._DpdEnable = None
        self._DpdTimeout = None
        self._DpdAction = None
        self._CustomerGatewayId = None

    @property
    def VpnConnectionId(self):
        return self._VpnConnectionId

    @VpnConnectionId.setter
    def VpnConnectionId(self, VpnConnectionId):
        self._VpnConnectionId = VpnConnectionId

    @property
    def VpnConnectionName(self):
        return self._VpnConnectionName

    @VpnConnectionName.setter
    def VpnConnectionName(self, VpnConnectionName):
        self._VpnConnectionName = VpnConnectionName

    @property
    def PreShareKey(self):
        return self._PreShareKey

    @PreShareKey.setter
    def PreShareKey(self, PreShareKey):
        self._PreShareKey = PreShareKey

    @property
    def SecurityPolicyDatabases(self):
        return self._SecurityPolicyDatabases

    @SecurityPolicyDatabases.setter
    def SecurityPolicyDatabases(self, SecurityPolicyDatabases):
        self._SecurityPolicyDatabases = SecurityPolicyDatabases

    @property
    def IKEOptionsSpecification(self):
        return self._IKEOptionsSpecification

    @IKEOptionsSpecification.setter
    def IKEOptionsSpecification(self, IKEOptionsSpecification):
        self._IKEOptionsSpecification = IKEOptionsSpecification

    @property
    def IPSECOptionsSpecification(self):
        return self._IPSECOptionsSpecification

    @IPSECOptionsSpecification.setter
    def IPSECOptionsSpecification(self, IPSECOptionsSpecification):
        self._IPSECOptionsSpecification = IPSECOptionsSpecification

    @property
    def EnableHealthCheck(self):
        return self._EnableHealthCheck

    @EnableHealthCheck.setter
    def EnableHealthCheck(self, EnableHealthCheck):
        self._EnableHealthCheck = EnableHealthCheck

    @property
    def HealthCheckLocalIp(self):
        return self._HealthCheckLocalIp

    @HealthCheckLocalIp.setter
    def HealthCheckLocalIp(self, HealthCheckLocalIp):
        self._HealthCheckLocalIp = HealthCheckLocalIp

    @property
    def HealthCheckRemoteIp(self):
        return self._HealthCheckRemoteIp

    @HealthCheckRemoteIp.setter
    def HealthCheckRemoteIp(self, HealthCheckRemoteIp):
        self._HealthCheckRemoteIp = HealthCheckRemoteIp

    @property
    def NegotiationType(self):
        return self._NegotiationType

    @NegotiationType.setter
    def NegotiationType(self, NegotiationType):
        self._NegotiationType = NegotiationType

    @property
    def DpdEnable(self):
        return self._DpdEnable

    @DpdEnable.setter
    def DpdEnable(self, DpdEnable):
        self._DpdEnable = DpdEnable

    @property
    def DpdTimeout(self):
        return self._DpdTimeout

    @DpdTimeout.setter
    def DpdTimeout(self, DpdTimeout):
        self._DpdTimeout = DpdTimeout

    @property
    def DpdAction(self):
        return self._DpdAction

    @DpdAction.setter
    def DpdAction(self, DpdAction):
        self._DpdAction = DpdAction

    @property
    def CustomerGatewayId(self):
        return self._CustomerGatewayId

    @CustomerGatewayId.setter
    def CustomerGatewayId(self, CustomerGatewayId):
        self._CustomerGatewayId = CustomerGatewayId


    def _deserialize(self, params):
        self._VpnConnectionId = params.get("VpnConnectionId")
        self._VpnConnectionName = params.get("VpnConnectionName")
        self._PreShareKey = params.get("PreShareKey")
        if params.get("SecurityPolicyDatabases") is not None:
            self._SecurityPolicyDatabases = []
            for item in params.get("SecurityPolicyDatabases"):
                obj = SecurityPolicyDatabase()
                obj._deserialize(item)
                self._SecurityPolicyDatabases.append(obj)
        if params.get("IKEOptionsSpecification") is not None:
            self._IKEOptionsSpecification = IKEOptionsSpecification()
            self._IKEOptionsSpecification._deserialize(params.get("IKEOptionsSpecification"))
        if params.get("IPSECOptionsSpecification") is not None:
            self._IPSECOptionsSpecification = IPSECOptionsSpecification()
            self._IPSECOptionsSpecification._deserialize(params.get("IPSECOptionsSpecification"))
        self._EnableHealthCheck = params.get("EnableHealthCheck")
        self._HealthCheckLocalIp = params.get("HealthCheckLocalIp")
        self._HealthCheckRemoteIp = params.get("HealthCheckRemoteIp")
        self._NegotiationType = params.get("NegotiationType")
        self._DpdEnable = params.get("DpdEnable")
        self._DpdTimeout = params.get("DpdTimeout")
        self._DpdAction = params.get("DpdAction")
        self._CustomerGatewayId = params.get("CustomerGatewayId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyVpnConnectionAttributeResponse(AbstractModel):
    """ModifyVpnConnectionAttribute response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyVpnGatewayAttributeRequest(AbstractModel):
    """ModifyVpnGatewayAttribute request structure.

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: The ID of the VPN gateway instance.
        :type VpnGatewayId: str
        :param _VpnGatewayName: The VPN gateway name. The maximum length is 60 bytes.
        :type VpnGatewayName: str
        :param _InstanceChargeType: VPN gateway billing mode. Currently, only the conversion of prepaid (monthly subscription) to postpaid (that is, pay-as-you-go) is supported. That is, the parameters only supports POSTPAID_BY_HOUR.
        :type InstanceChargeType: str
        """
        self._VpnGatewayId = None
        self._VpnGatewayName = None
        self._InstanceChargeType = None

    @property
    def VpnGatewayId(self):
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId

    @property
    def VpnGatewayName(self):
        return self._VpnGatewayName

    @VpnGatewayName.setter
    def VpnGatewayName(self, VpnGatewayName):
        self._VpnGatewayName = VpnGatewayName

    @property
    def InstanceChargeType(self):
        return self._InstanceChargeType

    @InstanceChargeType.setter
    def InstanceChargeType(self, InstanceChargeType):
        self._InstanceChargeType = InstanceChargeType


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        self._VpnGatewayName = params.get("VpnGatewayName")
        self._InstanceChargeType = params.get("InstanceChargeType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyVpnGatewayAttributeResponse(AbstractModel):
    """ModifyVpnGatewayAttribute response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyVpnGatewayCcnRoutesRequest(AbstractModel):
    """ModifyVpnGatewayCcnRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: Instance ID of the VPN gateway
        :type VpnGatewayId: str
        :param _Routes: The CCN route (IDC IP range) list.
        :type Routes: list of VpngwCcnRoutes
        """
        self._VpnGatewayId = None
        self._Routes = None

    @property
    def VpnGatewayId(self):
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId

    @property
    def Routes(self):
        return self._Routes

    @Routes.setter
    def Routes(self, Routes):
        self._Routes = Routes


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        if params.get("Routes") is not None:
            self._Routes = []
            for item in params.get("Routes"):
                obj = VpngwCcnRoutes()
                obj._deserialize(item)
                self._Routes.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyVpnGatewayCcnRoutesResponse(AbstractModel):
    """ModifyVpnGatewayCcnRoutes response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyVpnGatewayRoutesRequest(AbstractModel):
    """ModifyVpnGatewayRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: Instance ID of the VPN gateway
        :type VpnGatewayId: str
        :param _Routes: Route parameters to modify
        :type Routes: list of VpnGatewayRouteModify
        """
        self._VpnGatewayId = None
        self._Routes = None

    @property
    def VpnGatewayId(self):
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId

    @property
    def Routes(self):
        return self._Routes

    @Routes.setter
    def Routes(self, Routes):
        self._Routes = Routes


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        if params.get("Routes") is not None:
            self._Routes = []
            for item in params.get("Routes"):
                obj = VpnGatewayRouteModify()
                obj._deserialize(item)
                self._Routes.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyVpnGatewayRoutesResponse(AbstractModel):
    """ModifyVpnGatewayRoutes response structure.

    """

    def __init__(self):
        r"""
        :param _Routes: Route information of the VPN gateway
Note: this field may return `null`, indicating that no valid value is obtained.
        :type Routes: list of VpnGatewayRoute
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Routes = None
        self._RequestId = None

    @property
    def Routes(self):
        return self._Routes

    @Routes.setter
    def Routes(self, Routes):
        self._Routes = Routes

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Routes") is not None:
            self._Routes = []
            for item in params.get("Routes"):
                obj = VpnGatewayRoute()
                obj._deserialize(item)
                self._Routes.append(obj)
        self._RequestId = params.get("RequestId")


class NatDirectConnectGatewayRoute(AbstractModel):
    """Query the returned object of a NAT route

    """

    def __init__(self):
        r"""
        :param _DestinationCidrBlock: The `IPv4` `CIDR` of the subnet.
        :type DestinationCidrBlock: str
        :param _GatewayType: The type of the next-hop gateway. Supported types:
`DIRECTCONNECT`: Direct connect gateway
        :type GatewayType: str
        :param _GatewayId: ID of the next-hop gateway
        :type GatewayId: str
        :param _CreateTime: The creation time of the route
        :type CreateTime: str
        :param _UpdateTime: The update time of the route
        :type UpdateTime: str
        """
        self._DestinationCidrBlock = None
        self._GatewayType = None
        self._GatewayId = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def DestinationCidrBlock(self):
        return self._DestinationCidrBlock

    @DestinationCidrBlock.setter
    def DestinationCidrBlock(self, DestinationCidrBlock):
        self._DestinationCidrBlock = DestinationCidrBlock

    @property
    def GatewayType(self):
        return self._GatewayType

    @GatewayType.setter
    def GatewayType(self, GatewayType):
        self._GatewayType = GatewayType

    @property
    def GatewayId(self):
        return self._GatewayId

    @GatewayId.setter
    def GatewayId(self, GatewayId):
        self._GatewayId = GatewayId

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._DestinationCidrBlock = params.get("DestinationCidrBlock")
        self._GatewayType = params.get("GatewayType")
        self._GatewayId = params.get("GatewayId")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NatGateway(AbstractModel):
    """NAT gateway object.

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: NAT gateway ID.
        :type NatGatewayId: str
        :param _NatGatewayName: NAT gateway name.
        :type NatGatewayName: str
        :param _CreatedTime: NAT gateway creation time.
        :type CreatedTime: str
        :param _State: The status of the NAT gateway.
 `PENDING`: Being created, `DELETING`: Being deleted, `AVAILABLE`: Running, `UPDATING`: Being upgraded,
`FAILED`: Failed.
        :type State: str
        :param _InternetMaxBandwidthOut: The maximum outbound bandwidth of the gateway. Unit: Mbps.
        :type InternetMaxBandwidthOut: int
        :param _MaxConcurrentConnection: The concurrent connections cap of the gateway.
        :type MaxConcurrentConnection: int
        :param _PublicIpAddressSet: The public IP object array of the bound NAT gateway.
        :type PublicIpAddressSet: list of NatGatewayAddress
        :param _NetworkState: The NAT gateway status. `AVAILABLE`: Operating, `UNAVAILABLE`: Unavailable, `INSUFFICIENT`: Service suspended due to account overdue.
        :type NetworkState: str
        :param _DestinationIpPortTranslationNatRuleSet: The port forwarding rules of the NAT gateway.
        :type DestinationIpPortTranslationNatRuleSet: list of DestinationIpPortTranslationNatRule
        :param _VpcId: VPC instance ID.
        :type VpcId: str
        :param _Zone: The availability zone in which the NAT gateway is located.
        :type Zone: str
        :param _DirectConnectGatewayIds: ID of the direct connect gateway bound.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type DirectConnectGatewayIds: list of str
        :param _SubnetId: Subnet ID.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type SubnetId: str
        :param _TagSet: Tag key-value pairs.
        :type TagSet: list of Tag
        :param _SecurityGroupSet: The list of the security groups bound to the NAT Gateway
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type SecurityGroupSet: list of str
        :param _SourceIpTranslationNatRuleSet: SNAT forwarding rule of the NAT gateway.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type SourceIpTranslationNatRuleSet: list of SourceIpTranslationNatRule
        :param _IsExclusive: Whether the NAT gateway is dedicated.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type IsExclusive: bool
        :param _ExclusiveGatewayBandwidth: Bandwidth of the gateway cluster where the dedicated NAT Gateway resides. Unit: Mbps. This field does not exist when the `IsExclusive` field is set to `false`.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type ExclusiveGatewayBandwidth: int
        :param _RestrictState: Whether the NAT gateway is blocked. Values: `NORMAL`, `RESTRICTED`
Note: This field may return null, indicating that no valid values can be obtained.
        :type RestrictState: str
        :param _NatProductVersion: NAT gateway major version. `1`: Classic, `2`: Standard
Note: This field may return null, indicating that no valid values can be obtained.
        :type NatProductVersion: int
        """
        self._NatGatewayId = None
        self._NatGatewayName = None
        self._CreatedTime = None
        self._State = None
        self._InternetMaxBandwidthOut = None
        self._MaxConcurrentConnection = None
        self._PublicIpAddressSet = None
        self._NetworkState = None
        self._DestinationIpPortTranslationNatRuleSet = None
        self._VpcId = None
        self._Zone = None
        self._DirectConnectGatewayIds = None
        self._SubnetId = None
        self._TagSet = None
        self._SecurityGroupSet = None
        self._SourceIpTranslationNatRuleSet = None
        self._IsExclusive = None
        self._ExclusiveGatewayBandwidth = None
        self._RestrictState = None
        self._NatProductVersion = None

    @property
    def NatGatewayId(self):
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def NatGatewayName(self):
        return self._NatGatewayName

    @NatGatewayName.setter
    def NatGatewayName(self, NatGatewayName):
        self._NatGatewayName = NatGatewayName

    @property
    def CreatedTime(self):
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def State(self):
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def InternetMaxBandwidthOut(self):
        return self._InternetMaxBandwidthOut

    @InternetMaxBandwidthOut.setter
    def InternetMaxBandwidthOut(self, InternetMaxBandwidthOut):
        self._InternetMaxBandwidthOut = InternetMaxBandwidthOut

    @property
    def MaxConcurrentConnection(self):
        return self._MaxConcurrentConnection

    @MaxConcurrentConnection.setter
    def MaxConcurrentConnection(self, MaxConcurrentConnection):
        self._MaxConcurrentConnection = MaxConcurrentConnection

    @property
    def PublicIpAddressSet(self):
        return self._PublicIpAddressSet

    @PublicIpAddressSet.setter
    def PublicIpAddressSet(self, PublicIpAddressSet):
        self._PublicIpAddressSet = PublicIpAddressSet

    @property
    def NetworkState(self):
        return self._NetworkState

    @NetworkState.setter
    def NetworkState(self, NetworkState):
        self._NetworkState = NetworkState

    @property
    def DestinationIpPortTranslationNatRuleSet(self):
        return self._DestinationIpPortTranslationNatRuleSet

    @DestinationIpPortTranslationNatRuleSet.setter
    def DestinationIpPortTranslationNatRuleSet(self, DestinationIpPortTranslationNatRuleSet):
        self._DestinationIpPortTranslationNatRuleSet = DestinationIpPortTranslationNatRuleSet

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def Zone(self):
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def DirectConnectGatewayIds(self):
        return self._DirectConnectGatewayIds

    @DirectConnectGatewayIds.setter
    def DirectConnectGatewayIds(self, DirectConnectGatewayIds):
        self._DirectConnectGatewayIds = DirectConnectGatewayIds

    @property
    def SubnetId(self):
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def TagSet(self):
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet

    @property
    def SecurityGroupSet(self):
        return self._SecurityGroupSet

    @SecurityGroupSet.setter
    def SecurityGroupSet(self, SecurityGroupSet):
        self._SecurityGroupSet = SecurityGroupSet

    @property
    def SourceIpTranslationNatRuleSet(self):
        return self._SourceIpTranslationNatRuleSet

    @SourceIpTranslationNatRuleSet.setter
    def SourceIpTranslationNatRuleSet(self, SourceIpTranslationNatRuleSet):
        self._SourceIpTranslationNatRuleSet = SourceIpTranslationNatRuleSet

    @property
    def IsExclusive(self):
        return self._IsExclusive

    @IsExclusive.setter
    def IsExclusive(self, IsExclusive):
        self._IsExclusive = IsExclusive

    @property
    def ExclusiveGatewayBandwidth(self):
        return self._ExclusiveGatewayBandwidth

    @ExclusiveGatewayBandwidth.setter
    def ExclusiveGatewayBandwidth(self, ExclusiveGatewayBandwidth):
        self._ExclusiveGatewayBandwidth = ExclusiveGatewayBandwidth

    @property
    def RestrictState(self):
        return self._RestrictState

    @RestrictState.setter
    def RestrictState(self, RestrictState):
        self._RestrictState = RestrictState

    @property
    def NatProductVersion(self):
        return self._NatProductVersion

    @NatProductVersion.setter
    def NatProductVersion(self, NatProductVersion):
        self._NatProductVersion = NatProductVersion


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        self._NatGatewayName = params.get("NatGatewayName")
        self._CreatedTime = params.get("CreatedTime")
        self._State = params.get("State")
        self._InternetMaxBandwidthOut = params.get("InternetMaxBandwidthOut")
        self._MaxConcurrentConnection = params.get("MaxConcurrentConnection")
        if params.get("PublicIpAddressSet") is not None:
            self._PublicIpAddressSet = []
            for item in params.get("PublicIpAddressSet"):
                obj = NatGatewayAddress()
                obj._deserialize(item)
                self._PublicIpAddressSet.append(obj)
        self._NetworkState = params.get("NetworkState")
        if params.get("DestinationIpPortTranslationNatRuleSet") is not None:
            self._DestinationIpPortTranslationNatRuleSet = []
            for item in params.get("DestinationIpPortTranslationNatRuleSet"):
                obj = DestinationIpPortTranslationNatRule()
                obj._deserialize(item)
                self._DestinationIpPortTranslationNatRuleSet.append(obj)
        self._VpcId = params.get("VpcId")
        self._Zone = params.get("Zone")
        self._DirectConnectGatewayIds = params.get("DirectConnectGatewayIds")
        self._SubnetId = params.get("SubnetId")
        if params.get("TagSet") is not None:
            self._TagSet = []
            for item in params.get("TagSet"):
                obj = Tag()
                obj._deserialize(item)
                self._TagSet.append(obj)
        self._SecurityGroupSet = params.get("SecurityGroupSet")
        if params.get("SourceIpTranslationNatRuleSet") is not None:
            self._SourceIpTranslationNatRuleSet = []
            for item in params.get("SourceIpTranslationNatRuleSet"):
                obj = SourceIpTranslationNatRule()
                obj._deserialize(item)
                self._SourceIpTranslationNatRuleSet.append(obj)
        self._IsExclusive = params.get("IsExclusive")
        self._ExclusiveGatewayBandwidth = params.get("ExclusiveGatewayBandwidth")
        self._RestrictState = params.get("RestrictState")
        self._NatProductVersion = params.get("NatProductVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NatGatewayAddress(AbstractModel):
    """The EIP bound to the NAT gateway

    """

    def __init__(self):
        r"""
        :param _AddressId: The unique ID of the Elastic IP (EIP), such as `eip-11112222`.
        :type AddressId: str
        :param _PublicIpAddress: The public IP address, such as `123.121.34.33`.
        :type PublicIpAddress: str
        :param _IsBlocked: The block status of the resource. `true` indicates the EIP is blocked. `false` indicates that the EIP is not blocked.
        :type IsBlocked: bool
        """
        self._AddressId = None
        self._PublicIpAddress = None
        self._IsBlocked = None

    @property
    def AddressId(self):
        return self._AddressId

    @AddressId.setter
    def AddressId(self, AddressId):
        self._AddressId = AddressId

    @property
    def PublicIpAddress(self):
        return self._PublicIpAddress

    @PublicIpAddress.setter
    def PublicIpAddress(self, PublicIpAddress):
        self._PublicIpAddress = PublicIpAddress

    @property
    def IsBlocked(self):
        return self._IsBlocked

    @IsBlocked.setter
    def IsBlocked(self, IsBlocked):
        self._IsBlocked = IsBlocked


    def _deserialize(self, params):
        self._AddressId = params.get("AddressId")
        self._PublicIpAddress = params.get("PublicIpAddress")
        self._IsBlocked = params.get("IsBlocked")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NatGatewayDestinationIpPortTranslationNatRule(AbstractModel):
    """The port forwarding rules of the NAT gateway

    """

    def __init__(self):
        r"""
        :param _IpProtocol: Network protocol. Available choices: `TCP`, `UDP`.
        :type IpProtocol: str
        :param _PublicIpAddress: EIP.
        :type PublicIpAddress: str
        :param _PublicPort: Public port.
        :type PublicPort: int
        :param _PrivateIpAddress: Private IP.
        :type PrivateIpAddress: str
        :param _PrivatePort: Private port.
        :type PrivatePort: int
        :param _Description: NAT gateway forwarding rule description.
        :type Description: str
        :param _NatGatewayId: NAT gateway ID.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type NatGatewayId: str
        :param _VpcId: VPC ID.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type VpcId: str
        :param _CreatedTime: The creation time of the NAT gateway forwarding rule.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type CreatedTime: str
        """
        self._IpProtocol = None
        self._PublicIpAddress = None
        self._PublicPort = None
        self._PrivateIpAddress = None
        self._PrivatePort = None
        self._Description = None
        self._NatGatewayId = None
        self._VpcId = None
        self._CreatedTime = None

    @property
    def IpProtocol(self):
        return self._IpProtocol

    @IpProtocol.setter
    def IpProtocol(self, IpProtocol):
        self._IpProtocol = IpProtocol

    @property
    def PublicIpAddress(self):
        return self._PublicIpAddress

    @PublicIpAddress.setter
    def PublicIpAddress(self, PublicIpAddress):
        self._PublicIpAddress = PublicIpAddress

    @property
    def PublicPort(self):
        return self._PublicPort

    @PublicPort.setter
    def PublicPort(self, PublicPort):
        self._PublicPort = PublicPort

    @property
    def PrivateIpAddress(self):
        return self._PrivateIpAddress

    @PrivateIpAddress.setter
    def PrivateIpAddress(self, PrivateIpAddress):
        self._PrivateIpAddress = PrivateIpAddress

    @property
    def PrivatePort(self):
        return self._PrivatePort

    @PrivatePort.setter
    def PrivatePort(self, PrivatePort):
        self._PrivatePort = PrivatePort

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def NatGatewayId(self):
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def CreatedTime(self):
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime


    def _deserialize(self, params):
        self._IpProtocol = params.get("IpProtocol")
        self._PublicIpAddress = params.get("PublicIpAddress")
        self._PublicPort = params.get("PublicPort")
        self._PrivateIpAddress = params.get("PrivateIpAddress")
        self._PrivatePort = params.get("PrivatePort")
        self._Description = params.get("Description")
        self._NatGatewayId = params.get("NatGatewayId")
        self._VpcId = params.get("VpcId")
        self._CreatedTime = params.get("CreatedTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NetDetect(AbstractModel):
    """The network detection object.

    """

    def __init__(self):
        r"""
        :param _VpcId: The ID of a VPC instance, such as `vpc-12345678`.
        :type VpcId: str
        :param _VpcName: The name of a VPC instance.
        :type VpcName: str
        :param _SubnetId: The ID of a subnet instance, such as subnet-12345678.
        :type SubnetId: str
        :param _SubnetName: The name of a subnet instance.
        :type SubnetName: str
        :param _NetDetectId: The ID of a network detection instance, such as netd-12345678.
        :type NetDetectId: str
        :param _NetDetectName: The name of a network detection instance. The maximum length is 60 characters.
        :type NetDetectName: str
        :param _DetectDestinationIp: The array of detection destination IPv4 addresses, which contains at most two IP addresses.
        :type DetectDestinationIp: list of str
        :param _DetectSourceIp: The array of detection source IPv4 addresses automatically allocated by the system. The length is 2.
        :type DetectSourceIp: list of str
        :param _NextHopType: Type of the next hop. Currently supported types are:
VPN: VPN gateway;
`DIRECTCONNECT`: Direct connect gateway;
`PEERCONNECTION`: Peering connection;
`NAT`: NAT gateway;
`NORMAL_CVM`: CVM instance;
`CCN`: CCN instance;
`NONEXTHOP`: No next hop.
        :type NextHopType: str
        :param _NextHopDestination: ID of the next-hop gateway.
If NextHopType is set to VPN, the value of this parameter is the VPN gateway ID, such as vpngw-12345678.
`NextHopType` = `DIRECTCONNECT`: Direct connect gateway ID, such as `dcg-12345678`.
`NextHopType` = `PEERCONNECTION`: Peering connection ID, such as `pcx-12345678`.
`NextHopType` = `NAT`: NAT gateway ID, such as `nat-12345678`.
If NextHopType is set to NORMAL_CVM, the value of this parameter is the IPv4 address of the CVM, such as 10.0.0.12.
`NextHopType` = `CCN`: CCN instance ID, such as `ccn-12345678`.
`NextHopType` = `NONEXTHOP`: No next hop.
        :type NextHopDestination: str
        :param _NextHopName: The name of the next-hop gateway.
Note: This field may return null, indicating that no valid values can be obtained.
        :type NextHopName: str
        :param _NetDetectDescription: Network detection description.
Note: This field may return null, indicating that no valid values can be obtained.
        :type NetDetectDescription: str
        :param _CreateTime: The creation time.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        """
        self._VpcId = None
        self._VpcName = None
        self._SubnetId = None
        self._SubnetName = None
        self._NetDetectId = None
        self._NetDetectName = None
        self._DetectDestinationIp = None
        self._DetectSourceIp = None
        self._NextHopType = None
        self._NextHopDestination = None
        self._NextHopName = None
        self._NetDetectDescription = None
        self._CreateTime = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def VpcName(self):
        return self._VpcName

    @VpcName.setter
    def VpcName(self, VpcName):
        self._VpcName = VpcName

    @property
    def SubnetId(self):
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def SubnetName(self):
        return self._SubnetName

    @SubnetName.setter
    def SubnetName(self, SubnetName):
        self._SubnetName = SubnetName

    @property
    def NetDetectId(self):
        return self._NetDetectId

    @NetDetectId.setter
    def NetDetectId(self, NetDetectId):
        self._NetDetectId = NetDetectId

    @property
    def NetDetectName(self):
        return self._NetDetectName

    @NetDetectName.setter
    def NetDetectName(self, NetDetectName):
        self._NetDetectName = NetDetectName

    @property
    def DetectDestinationIp(self):
        return self._DetectDestinationIp

    @DetectDestinationIp.setter
    def DetectDestinationIp(self, DetectDestinationIp):
        self._DetectDestinationIp = DetectDestinationIp

    @property
    def DetectSourceIp(self):
        return self._DetectSourceIp

    @DetectSourceIp.setter
    def DetectSourceIp(self, DetectSourceIp):
        self._DetectSourceIp = DetectSourceIp

    @property
    def NextHopType(self):
        return self._NextHopType

    @NextHopType.setter
    def NextHopType(self, NextHopType):
        self._NextHopType = NextHopType

    @property
    def NextHopDestination(self):
        return self._NextHopDestination

    @NextHopDestination.setter
    def NextHopDestination(self, NextHopDestination):
        self._NextHopDestination = NextHopDestination

    @property
    def NextHopName(self):
        return self._NextHopName

    @NextHopName.setter
    def NextHopName(self, NextHopName):
        self._NextHopName = NextHopName

    @property
    def NetDetectDescription(self):
        return self._NetDetectDescription

    @NetDetectDescription.setter
    def NetDetectDescription(self, NetDetectDescription):
        self._NetDetectDescription = NetDetectDescription

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._VpcName = params.get("VpcName")
        self._SubnetId = params.get("SubnetId")
        self._SubnetName = params.get("SubnetName")
        self._NetDetectId = params.get("NetDetectId")
        self._NetDetectName = params.get("NetDetectName")
        self._DetectDestinationIp = params.get("DetectDestinationIp")
        self._DetectSourceIp = params.get("DetectSourceIp")
        self._NextHopType = params.get("NextHopType")
        self._NextHopDestination = params.get("NextHopDestination")
        self._NextHopName = params.get("NextHopName")
        self._NetDetectDescription = params.get("NetDetectDescription")
        self._CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NetDetectIpState(AbstractModel):
    """The verification result of the network detection destination IP address.

    """

    def __init__(self):
        r"""
        :param _DetectDestinationIp: The destination IPv4 address of network detection.
        :type DetectDestinationIp: str
        :param _State: The detection result.
0: successful;
-1: no packet loss occurred during routing;
-2: packet loss occurred when outbound traffic is blocked by the ACL;
-3: packet loss occurred when inbound traffic is blocked by the ACL;
-4: other errors.
        :type State: int
        :param _Delay: The latency. Unit: ms.
        :type Delay: int
        :param _PacketLossRate: The packet loss rate.
        :type PacketLossRate: int
        """
        self._DetectDestinationIp = None
        self._State = None
        self._Delay = None
        self._PacketLossRate = None

    @property
    def DetectDestinationIp(self):
        return self._DetectDestinationIp

    @DetectDestinationIp.setter
    def DetectDestinationIp(self, DetectDestinationIp):
        self._DetectDestinationIp = DetectDestinationIp

    @property
    def State(self):
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def Delay(self):
        return self._Delay

    @Delay.setter
    def Delay(self, Delay):
        self._Delay = Delay

    @property
    def PacketLossRate(self):
        return self._PacketLossRate

    @PacketLossRate.setter
    def PacketLossRate(self, PacketLossRate):
        self._PacketLossRate = PacketLossRate


    def _deserialize(self, params):
        self._DetectDestinationIp = params.get("DetectDestinationIp")
        self._State = params.get("State")
        self._Delay = params.get("Delay")
        self._PacketLossRate = params.get("PacketLossRate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NetDetectState(AbstractModel):
    """The network detection verification result.

    """

    def __init__(self):
        r"""
        :param _NetDetectId: The ID of a network detection instance, such as netd-12345678.
        :type NetDetectId: str
        :param _NetDetectIpStateSet: The array of network detection destination IP verification results.
        :type NetDetectIpStateSet: list of NetDetectIpState
        """
        self._NetDetectId = None
        self._NetDetectIpStateSet = None

    @property
    def NetDetectId(self):
        return self._NetDetectId

    @NetDetectId.setter
    def NetDetectId(self, NetDetectId):
        self._NetDetectId = NetDetectId

    @property
    def NetDetectIpStateSet(self):
        return self._NetDetectIpStateSet

    @NetDetectIpStateSet.setter
    def NetDetectIpStateSet(self, NetDetectIpStateSet):
        self._NetDetectIpStateSet = NetDetectIpStateSet


    def _deserialize(self, params):
        self._NetDetectId = params.get("NetDetectId")
        if params.get("NetDetectIpStateSet") is not None:
            self._NetDetectIpStateSet = []
            for item in params.get("NetDetectIpStateSet"):
                obj = NetDetectIpState()
                obj._deserialize(item)
                self._NetDetectIpStateSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NetworkAcl(AbstractModel):
    """Network ACL

    """

    def __init__(self):
        r"""
        :param _VpcId: `ID` of the `VPC` instance.
        :type VpcId: str
        :param _NetworkAclId: `ID` of the network ACL instance.
        :type NetworkAclId: str
        :param _NetworkAclName: Name of the network ACL. The maximum length is 60 bytes.
        :type NetworkAclName: str
        :param _CreatedTime: Creation time.
        :type CreatedTime: str
        :param _SubnetSet: Array of subnets associated with the network ACL.
        :type SubnetSet: list of Subnet
        :param _IngressEntries: Inbound rules of the network ACL.
        :type IngressEntries: list of NetworkAclEntry
        :param _EgressEntries: Outbound rules of the network ACL.
        :type EgressEntries: list of NetworkAclEntry
        :param _NetworkAclType: Network ACL type. Valid values: `TRIPLE` and `QUINTUPLE`.
        :type NetworkAclType: str
        :param _TagSet: Tag key-value pairs
        :type TagSet: list of Tag
        """
        self._VpcId = None
        self._NetworkAclId = None
        self._NetworkAclName = None
        self._CreatedTime = None
        self._SubnetSet = None
        self._IngressEntries = None
        self._EgressEntries = None
        self._NetworkAclType = None
        self._TagSet = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def NetworkAclId(self):
        return self._NetworkAclId

    @NetworkAclId.setter
    def NetworkAclId(self, NetworkAclId):
        self._NetworkAclId = NetworkAclId

    @property
    def NetworkAclName(self):
        return self._NetworkAclName

    @NetworkAclName.setter
    def NetworkAclName(self, NetworkAclName):
        self._NetworkAclName = NetworkAclName

    @property
    def CreatedTime(self):
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def SubnetSet(self):
        return self._SubnetSet

    @SubnetSet.setter
    def SubnetSet(self, SubnetSet):
        self._SubnetSet = SubnetSet

    @property
    def IngressEntries(self):
        return self._IngressEntries

    @IngressEntries.setter
    def IngressEntries(self, IngressEntries):
        self._IngressEntries = IngressEntries

    @property
    def EgressEntries(self):
        return self._EgressEntries

    @EgressEntries.setter
    def EgressEntries(self, EgressEntries):
        self._EgressEntries = EgressEntries

    @property
    def NetworkAclType(self):
        return self._NetworkAclType

    @NetworkAclType.setter
    def NetworkAclType(self, NetworkAclType):
        self._NetworkAclType = NetworkAclType

    @property
    def TagSet(self):
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._NetworkAclId = params.get("NetworkAclId")
        self._NetworkAclName = params.get("NetworkAclName")
        self._CreatedTime = params.get("CreatedTime")
        if params.get("SubnetSet") is not None:
            self._SubnetSet = []
            for item in params.get("SubnetSet"):
                obj = Subnet()
                obj._deserialize(item)
                self._SubnetSet.append(obj)
        if params.get("IngressEntries") is not None:
            self._IngressEntries = []
            for item in params.get("IngressEntries"):
                obj = NetworkAclEntry()
                obj._deserialize(item)
                self._IngressEntries.append(obj)
        if params.get("EgressEntries") is not None:
            self._EgressEntries = []
            for item in params.get("EgressEntries"):
                obj = NetworkAclEntry()
                obj._deserialize(item)
                self._EgressEntries.append(obj)
        self._NetworkAclType = params.get("NetworkAclType")
        if params.get("TagSet") is not None:
            self._TagSet = []
            for item in params.get("TagSet"):
                obj = Tag()
                obj._deserialize(item)
                self._TagSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NetworkAclEntry(AbstractModel):
    """Network ACL rules.

    """

    def __init__(self):
        r"""
        :param _ModifyTime: Modification time.
        :type ModifyTime: str
        :param _Protocol: Protocol. Valid values: TCP, UDP, ICMP, ALL.
        :type Protocol: str
        :param _Port: Port. Valid values: all, single port, range. When Protocol takes the value `ALL` or `ICMP`, Port cannot be specified.
        :type Port: str
        :param _CidrBlock: IP range or IP address (mutually exclusive).
        :type CidrBlock: str
        :param _Ipv6CidrBlock: CIDR block or IPv6 address (mutually exclusive).
        :type Ipv6CidrBlock: str
        :param _Action: ACCEPT or DROP.
        :type Action: str
        :param _Description: Rule description, which is up to 100 bytes.
        :type Description: str
        """
        self._ModifyTime = None
        self._Protocol = None
        self._Port = None
        self._CidrBlock = None
        self._Ipv6CidrBlock = None
        self._Action = None
        self._Description = None

    @property
    def ModifyTime(self):
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def Protocol(self):
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def Port(self):
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def CidrBlock(self):
        return self._CidrBlock

    @CidrBlock.setter
    def CidrBlock(self, CidrBlock):
        self._CidrBlock = CidrBlock

    @property
    def Ipv6CidrBlock(self):
        return self._Ipv6CidrBlock

    @Ipv6CidrBlock.setter
    def Ipv6CidrBlock(self, Ipv6CidrBlock):
        self._Ipv6CidrBlock = Ipv6CidrBlock

    @property
    def Action(self):
        return self._Action

    @Action.setter
    def Action(self, Action):
        self._Action = Action

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._ModifyTime = params.get("ModifyTime")
        self._Protocol = params.get("Protocol")
        self._Port = params.get("Port")
        self._CidrBlock = params.get("CidrBlock")
        self._Ipv6CidrBlock = params.get("Ipv6CidrBlock")
        self._Action = params.get("Action")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NetworkAclEntrySet(AbstractModel):
    """Network ACL rule set

    """

    def __init__(self):
        r"""
        :param _Ingress: Inbound rules.
        :type Ingress: list of NetworkAclEntry
        :param _Egress: Outbound rules.
        :type Egress: list of NetworkAclEntry
        """
        self._Ingress = None
        self._Egress = None

    @property
    def Ingress(self):
        return self._Ingress

    @Ingress.setter
    def Ingress(self, Ingress):
        self._Ingress = Ingress

    @property
    def Egress(self):
        return self._Egress

    @Egress.setter
    def Egress(self, Egress):
        self._Egress = Egress


    def _deserialize(self, params):
        if params.get("Ingress") is not None:
            self._Ingress = []
            for item in params.get("Ingress"):
                obj = NetworkAclEntry()
                obj._deserialize(item)
                self._Ingress.append(obj)
        if params.get("Egress") is not None:
            self._Egress = []
            for item in params.get("Egress"):
                obj = NetworkAclEntry()
                obj._deserialize(item)
                self._Egress.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NetworkAclQuintupleEntries(AbstractModel):
    """Network ACL quintuple

    """

    def __init__(self):
        r"""
        :param _Ingress: Network ACL quintuple inbound rule.
        :type Ingress: list of NetworkAclQuintupleEntry
        :param _Egress: Network ACL quintuple outbound rule.
        :type Egress: list of NetworkAclQuintupleEntry
        """
        self._Ingress = None
        self._Egress = None

    @property
    def Ingress(self):
        return self._Ingress

    @Ingress.setter
    def Ingress(self, Ingress):
        self._Ingress = Ingress

    @property
    def Egress(self):
        return self._Egress

    @Egress.setter
    def Egress(self, Egress):
        self._Egress = Egress


    def _deserialize(self, params):
        if params.get("Ingress") is not None:
            self._Ingress = []
            for item in params.get("Ingress"):
                obj = NetworkAclQuintupleEntry()
                obj._deserialize(item)
                self._Ingress.append(obj)
        if params.get("Egress") is not None:
            self._Egress = []
            for item in params.get("Egress"):
                obj = NetworkAclQuintupleEntry()
                obj._deserialize(item)
                self._Egress.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NetworkAclQuintupleEntry(AbstractModel):
    """Network ACL quintuple entry

    """

    def __init__(self):
        r"""
        :param _Protocol: Protocol. Valid values: `TCP`, `UDP`, `ICMP`, `ALL`.
        :type Protocol: str
        :param _Description: Description
        :type Description: str
        :param _SourcePort: Source port. Valid values: all, single port, range. When `Protocol` is `ALL` or `ICMP`, `Port` cannot be specified.
        :type SourcePort: str
        :param _SourceCidr: Source CIDR block.
        :type SourceCidr: str
        :param _DestinationPort: Destination port. Valid values: all, single port, range. When `Protocol` is `ALL` or `ICMP`, `Port` cannot be specified.
        :type DestinationPort: str
        :param _DestinationCidr: Destination CIDR block.
        :type DestinationCidr: str
        :param _Action: Action. Valid values: `ACCEPT` and `DROP`.
        :type Action: str
        :param _NetworkAclQuintupleEntryId: Unique ID of a network ACL entry.
        :type NetworkAclQuintupleEntryId: str
        :param _Priority: Priority. `1` refers to the highest priority.
        :type Priority: int
        :param _CreateTime: Creation time. It’s returned by `DescribeNetworkAclQuintupleEntries`.
        :type CreateTime: str
        :param _NetworkAclDirection: Direction of the rule. It’s returned by `DescribeNetworkAclQuintupleEntries`. Valid values: `INGRESS` and `EGRESS`.
        :type NetworkAclDirection: str
        """
        self._Protocol = None
        self._Description = None
        self._SourcePort = None
        self._SourceCidr = None
        self._DestinationPort = None
        self._DestinationCidr = None
        self._Action = None
        self._NetworkAclQuintupleEntryId = None
        self._Priority = None
        self._CreateTime = None
        self._NetworkAclDirection = None

    @property
    def Protocol(self):
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def SourcePort(self):
        return self._SourcePort

    @SourcePort.setter
    def SourcePort(self, SourcePort):
        self._SourcePort = SourcePort

    @property
    def SourceCidr(self):
        return self._SourceCidr

    @SourceCidr.setter
    def SourceCidr(self, SourceCidr):
        self._SourceCidr = SourceCidr

    @property
    def DestinationPort(self):
        return self._DestinationPort

    @DestinationPort.setter
    def DestinationPort(self, DestinationPort):
        self._DestinationPort = DestinationPort

    @property
    def DestinationCidr(self):
        return self._DestinationCidr

    @DestinationCidr.setter
    def DestinationCidr(self, DestinationCidr):
        self._DestinationCidr = DestinationCidr

    @property
    def Action(self):
        return self._Action

    @Action.setter
    def Action(self, Action):
        self._Action = Action

    @property
    def NetworkAclQuintupleEntryId(self):
        return self._NetworkAclQuintupleEntryId

    @NetworkAclQuintupleEntryId.setter
    def NetworkAclQuintupleEntryId(self, NetworkAclQuintupleEntryId):
        self._NetworkAclQuintupleEntryId = NetworkAclQuintupleEntryId

    @property
    def Priority(self):
        return self._Priority

    @Priority.setter
    def Priority(self, Priority):
        self._Priority = Priority

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def NetworkAclDirection(self):
        return self._NetworkAclDirection

    @NetworkAclDirection.setter
    def NetworkAclDirection(self, NetworkAclDirection):
        self._NetworkAclDirection = NetworkAclDirection


    def _deserialize(self, params):
        self._Protocol = params.get("Protocol")
        self._Description = params.get("Description")
        self._SourcePort = params.get("SourcePort")
        self._SourceCidr = params.get("SourceCidr")
        self._DestinationPort = params.get("DestinationPort")
        self._DestinationCidr = params.get("DestinationCidr")
        self._Action = params.get("Action")
        self._NetworkAclQuintupleEntryId = params.get("NetworkAclQuintupleEntryId")
        self._Priority = params.get("Priority")
        self._CreateTime = params.get("CreateTime")
        self._NetworkAclDirection = params.get("NetworkAclDirection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NetworkInterface(AbstractModel):
    """ENI

    """

    def __init__(self):
        r"""
        :param _NetworkInterfaceId: The ID of the ENI instance, such as `eni-f1xjkw1b`.
        :type NetworkInterfaceId: str
        :param _NetworkInterfaceName: ENI Name
        :type NetworkInterfaceName: str
        :param _NetworkInterfaceDescription: ENI description.
        :type NetworkInterfaceDescription: str
        :param _SubnetId: Subnet instance ID.
        :type SubnetId: str
        :param _VpcId: VPC instance ID.
        :type VpcId: str
        :param _GroupSet: Bound security group.
        :type GroupSet: list of str
        :param _Primary: Whether it is the primary ENI.
        :type Primary: bool
        :param _MacAddress: MAC address
        :type MacAddress: str
        :param _State: ENI status:
<li>`PENDING`: Creating</li>
<li>`AVAILABLE`: Available</li>
<li>`ATTACHING`: Binding</li>
<li>`DETACHING`: Unbinding</li>
<li>`DELETING`: Deleting</li>
        :type State: str
        :param _PrivateIpAddressSet: Private IP information.
        :type PrivateIpAddressSet: list of PrivateIpAddressSpecification
        :param _Attachment: Bound CVM object.
Note: This field may return null, indicating no valid value.
        :type Attachment: :class:`tencentcloud.vpc.v20170312.models.NetworkInterfaceAttachment`
        :param _Zone: Availability Zone.
        :type Zone: str
        :param _CreatedTime: Creation Time.
        :type CreatedTime: str
        :param _Ipv6AddressSet: The `IPv6` address list.
        :type Ipv6AddressSet: list of Ipv6Address
        :param _TagSet: Tag key-value pair.
        :type TagSet: list of Tag
        :param _EniType: The ENI type. 0: ENI. 1: EVM ENI.
        :type EniType: int
        :param _Business: Type of the resource bound with an ENI. Valid values: cvm, eks.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type Business: str
        :param _CdcId: ID of the CDC instance associated with the ENI
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type CdcId: str
        :param _AttachType: ENI type. Valid values: `0` (standard); `1` (extension). Default value: `0`.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type AttachType: int
        :param _ResourceId: The ID of resource to retain the ENI primary IP. It’s used as the request parameters for deleting an ENI.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type ResourceId: str
        :param _QosLevel: Service level
<li>`DEFAULT`: Default level</lil>
<li>`PT`: Gold</li>
<li>`AU`: Silver</li>
<li>`AG`: Bronze</li>
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type QosLevel: str
        """
        self._NetworkInterfaceId = None
        self._NetworkInterfaceName = None
        self._NetworkInterfaceDescription = None
        self._SubnetId = None
        self._VpcId = None
        self._GroupSet = None
        self._Primary = None
        self._MacAddress = None
        self._State = None
        self._PrivateIpAddressSet = None
        self._Attachment = None
        self._Zone = None
        self._CreatedTime = None
        self._Ipv6AddressSet = None
        self._TagSet = None
        self._EniType = None
        self._Business = None
        self._CdcId = None
        self._AttachType = None
        self._ResourceId = None
        self._QosLevel = None

    @property
    def NetworkInterfaceId(self):
        return self._NetworkInterfaceId

    @NetworkInterfaceId.setter
    def NetworkInterfaceId(self, NetworkInterfaceId):
        self._NetworkInterfaceId = NetworkInterfaceId

    @property
    def NetworkInterfaceName(self):
        return self._NetworkInterfaceName

    @NetworkInterfaceName.setter
    def NetworkInterfaceName(self, NetworkInterfaceName):
        self._NetworkInterfaceName = NetworkInterfaceName

    @property
    def NetworkInterfaceDescription(self):
        return self._NetworkInterfaceDescription

    @NetworkInterfaceDescription.setter
    def NetworkInterfaceDescription(self, NetworkInterfaceDescription):
        self._NetworkInterfaceDescription = NetworkInterfaceDescription

    @property
    def SubnetId(self):
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def GroupSet(self):
        return self._GroupSet

    @GroupSet.setter
    def GroupSet(self, GroupSet):
        self._GroupSet = GroupSet

    @property
    def Primary(self):
        return self._Primary

    @Primary.setter
    def Primary(self, Primary):
        self._Primary = Primary

    @property
    def MacAddress(self):
        return self._MacAddress

    @MacAddress.setter
    def MacAddress(self, MacAddress):
        self._MacAddress = MacAddress

    @property
    def State(self):
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def PrivateIpAddressSet(self):
        return self._PrivateIpAddressSet

    @PrivateIpAddressSet.setter
    def PrivateIpAddressSet(self, PrivateIpAddressSet):
        self._PrivateIpAddressSet = PrivateIpAddressSet

    @property
    def Attachment(self):
        return self._Attachment

    @Attachment.setter
    def Attachment(self, Attachment):
        self._Attachment = Attachment

    @property
    def Zone(self):
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def CreatedTime(self):
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def Ipv6AddressSet(self):
        return self._Ipv6AddressSet

    @Ipv6AddressSet.setter
    def Ipv6AddressSet(self, Ipv6AddressSet):
        self._Ipv6AddressSet = Ipv6AddressSet

    @property
    def TagSet(self):
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet

    @property
    def EniType(self):
        return self._EniType

    @EniType.setter
    def EniType(self, EniType):
        self._EniType = EniType

    @property
    def Business(self):
        return self._Business

    @Business.setter
    def Business(self, Business):
        self._Business = Business

    @property
    def CdcId(self):
        return self._CdcId

    @CdcId.setter
    def CdcId(self, CdcId):
        self._CdcId = CdcId

    @property
    def AttachType(self):
        return self._AttachType

    @AttachType.setter
    def AttachType(self, AttachType):
        self._AttachType = AttachType

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId

    @property
    def QosLevel(self):
        return self._QosLevel

    @QosLevel.setter
    def QosLevel(self, QosLevel):
        self._QosLevel = QosLevel


    def _deserialize(self, params):
        self._NetworkInterfaceId = params.get("NetworkInterfaceId")
        self._NetworkInterfaceName = params.get("NetworkInterfaceName")
        self._NetworkInterfaceDescription = params.get("NetworkInterfaceDescription")
        self._SubnetId = params.get("SubnetId")
        self._VpcId = params.get("VpcId")
        self._GroupSet = params.get("GroupSet")
        self._Primary = params.get("Primary")
        self._MacAddress = params.get("MacAddress")
        self._State = params.get("State")
        if params.get("PrivateIpAddressSet") is not None:
            self._PrivateIpAddressSet = []
            for item in params.get("PrivateIpAddressSet"):
                obj = PrivateIpAddressSpecification()
                obj._deserialize(item)
                self._PrivateIpAddressSet.append(obj)
        if params.get("Attachment") is not None:
            self._Attachment = NetworkInterfaceAttachment()
            self._Attachment._deserialize(params.get("Attachment"))
        self._Zone = params.get("Zone")
        self._CreatedTime = params.get("CreatedTime")
        if params.get("Ipv6AddressSet") is not None:
            self._Ipv6AddressSet = []
            for item in params.get("Ipv6AddressSet"):
                obj = Ipv6Address()
                obj._deserialize(item)
                self._Ipv6AddressSet.append(obj)
        if params.get("TagSet") is not None:
            self._TagSet = []
            for item in params.get("TagSet"):
                obj = Tag()
                obj._deserialize(item)
                self._TagSet.append(obj)
        self._EniType = params.get("EniType")
        self._Business = params.get("Business")
        self._CdcId = params.get("CdcId")
        self._AttachType = params.get("AttachType")
        self._ResourceId = params.get("ResourceId")
        self._QosLevel = params.get("QosLevel")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NetworkInterfaceAttachment(AbstractModel):
    """Binding relationship of the ENI

    """

    def __init__(self):
        r"""
        :param _InstanceId: CVM instance ID.
        :type InstanceId: str
        :param _DeviceIndex: The serial number of ENI in the CVM instance.
        :type DeviceIndex: int
        :param _InstanceAccountId: The account information of the CVM owner.
        :type InstanceAccountId: str
        :param _AttachTime: Binding time
        :type AttachTime: str
        """
        self._InstanceId = None
        self._DeviceIndex = None
        self._InstanceAccountId = None
        self._AttachTime = None

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def DeviceIndex(self):
        return self._DeviceIndex

    @DeviceIndex.setter
    def DeviceIndex(self, DeviceIndex):
        self._DeviceIndex = DeviceIndex

    @property
    def InstanceAccountId(self):
        return self._InstanceAccountId

    @InstanceAccountId.setter
    def InstanceAccountId(self, InstanceAccountId):
        self._InstanceAccountId = InstanceAccountId

    @property
    def AttachTime(self):
        return self._AttachTime

    @AttachTime.setter
    def AttachTime(self, AttachTime):
        self._AttachTime = AttachTime


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._DeviceIndex = params.get("DeviceIndex")
        self._InstanceAccountId = params.get("InstanceAccountId")
        self._AttachTime = params.get("AttachTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NotifyRoutesRequest(AbstractModel):
    """NotifyRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _RouteTableId: The unique ID of the route table
        :type RouteTableId: str
        :param _RouteItemIds: The unique ID of the route
        :type RouteItemIds: list of str
        """
        self._RouteTableId = None
        self._RouteItemIds = None

    @property
    def RouteTableId(self):
        return self._RouteTableId

    @RouteTableId.setter
    def RouteTableId(self, RouteTableId):
        self._RouteTableId = RouteTableId

    @property
    def RouteItemIds(self):
        return self._RouteItemIds

    @RouteItemIds.setter
    def RouteItemIds(self, RouteItemIds):
        self._RouteItemIds = RouteItemIds


    def _deserialize(self, params):
        self._RouteTableId = params.get("RouteTableId")
        self._RouteItemIds = params.get("RouteItemIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NotifyRoutesResponse(AbstractModel):
    """NotifyRoutes response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class Price(AbstractModel):
    """Price

    """

    def __init__(self):
        r"""
        :param _InstancePrice: Instance price.
        :type InstancePrice: :class:`tencentcloud.vpc.v20170312.models.ItemPrice`
        :param _BandwidthPrice: Bandwidth price
        :type BandwidthPrice: :class:`tencentcloud.vpc.v20170312.models.ItemPrice`
        """
        self._InstancePrice = None
        self._BandwidthPrice = None

    @property
    def InstancePrice(self):
        return self._InstancePrice

    @InstancePrice.setter
    def InstancePrice(self, InstancePrice):
        self._InstancePrice = InstancePrice

    @property
    def BandwidthPrice(self):
        return self._BandwidthPrice

    @BandwidthPrice.setter
    def BandwidthPrice(self, BandwidthPrice):
        self._BandwidthPrice = BandwidthPrice


    def _deserialize(self, params):
        if params.get("InstancePrice") is not None:
            self._InstancePrice = ItemPrice()
            self._InstancePrice._deserialize(params.get("InstancePrice"))
        if params.get("BandwidthPrice") is not None:
            self._BandwidthPrice = ItemPrice()
            self._BandwidthPrice._deserialize(params.get("BandwidthPrice"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PrivateIpAddressSpecification(AbstractModel):
    """Private IP information

    """

    def __init__(self):
        r"""
        :param _PrivateIpAddress: Private IP address.
        :type PrivateIpAddress: str
        :param _Primary: Whether it is a primary IP.
        :type Primary: bool
        :param _PublicIpAddress: Public IP address.
        :type PublicIpAddress: str
        :param _AddressId: EIP instance ID, such as `eip-11112222`.
        :type AddressId: str
        :param _Description: Private IP description.
        :type Description: str
        :param _IsWanIpBlocked: Whether the public IP is blocked.
        :type IsWanIpBlocked: bool
        :param _State: IP status:
PENDING: Creating
MIGRATING: Migrating
DELETING: Deleting
AVAILABLE: Available
        :type State: str
        :param _QosLevel: IP u200dservice level. Values: PT` u200d(Gold), `AU` u200d(Silver), `AG `(Bronze) and DEFAULT` (Default).
        :type QosLevel: str
        """
        self._PrivateIpAddress = None
        self._Primary = None
        self._PublicIpAddress = None
        self._AddressId = None
        self._Description = None
        self._IsWanIpBlocked = None
        self._State = None
        self._QosLevel = None

    @property
    def PrivateIpAddress(self):
        return self._PrivateIpAddress

    @PrivateIpAddress.setter
    def PrivateIpAddress(self, PrivateIpAddress):
        self._PrivateIpAddress = PrivateIpAddress

    @property
    def Primary(self):
        return self._Primary

    @Primary.setter
    def Primary(self, Primary):
        self._Primary = Primary

    @property
    def PublicIpAddress(self):
        return self._PublicIpAddress

    @PublicIpAddress.setter
    def PublicIpAddress(self, PublicIpAddress):
        self._PublicIpAddress = PublicIpAddress

    @property
    def AddressId(self):
        return self._AddressId

    @AddressId.setter
    def AddressId(self, AddressId):
        self._AddressId = AddressId

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def IsWanIpBlocked(self):
        return self._IsWanIpBlocked

    @IsWanIpBlocked.setter
    def IsWanIpBlocked(self, IsWanIpBlocked):
        self._IsWanIpBlocked = IsWanIpBlocked

    @property
    def State(self):
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def QosLevel(self):
        return self._QosLevel

    @QosLevel.setter
    def QosLevel(self, QosLevel):
        self._QosLevel = QosLevel


    def _deserialize(self, params):
        self._PrivateIpAddress = params.get("PrivateIpAddress")
        self._Primary = params.get("Primary")
        self._PublicIpAddress = params.get("PublicIpAddress")
        self._AddressId = params.get("AddressId")
        self._Description = params.get("Description")
        self._IsWanIpBlocked = params.get("IsWanIpBlocked")
        self._State = params.get("State")
        self._QosLevel = params.get("QosLevel")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Quota(AbstractModel):
    """Quota description information

    """

    def __init__(self):
        r"""
        :param _QuotaId: Quota name. Value range:<br><li>`TOTAL_EIP_QUOTA`:EIP quota under the user's current region<br><li>`DAILY_EIP_APPLY`: Number of EIP applications submitted daily under the user's current region<br><li>`DAILY_PUBLIC_IP_ASSIGN`: Number of public IP reassignments under the user's current region.
        :type QuotaId: str
        :param _QuotaCurrent: Current count
        :type QuotaCurrent: int
        :param _QuotaLimit: Quota
        :type QuotaLimit: int
        """
        self._QuotaId = None
        self._QuotaCurrent = None
        self._QuotaLimit = None

    @property
    def QuotaId(self):
        return self._QuotaId

    @QuotaId.setter
    def QuotaId(self, QuotaId):
        self._QuotaId = QuotaId

    @property
    def QuotaCurrent(self):
        return self._QuotaCurrent

    @QuotaCurrent.setter
    def QuotaCurrent(self, QuotaCurrent):
        self._QuotaCurrent = QuotaCurrent

    @property
    def QuotaLimit(self):
        return self._QuotaLimit

    @QuotaLimit.setter
    def QuotaLimit(self, QuotaLimit):
        self._QuotaLimit = QuotaLimit


    def _deserialize(self, params):
        self._QuotaId = params.get("QuotaId")
        self._QuotaCurrent = params.get("QuotaCurrent")
        self._QuotaLimit = params.get("QuotaLimit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ReferredSecurityGroup(AbstractModel):
    """Referred security groups

    """

    def __init__(self):
        r"""
        :param _SecurityGroupId: Security group instance ID.
        :type SecurityGroupId: str
        :param _ReferredSecurityGroupIds: IDs of all referred security group instances.
        :type ReferredSecurityGroupIds: list of str
        """
        self._SecurityGroupId = None
        self._ReferredSecurityGroupIds = None

    @property
    def SecurityGroupId(self):
        return self._SecurityGroupId

    @SecurityGroupId.setter
    def SecurityGroupId(self, SecurityGroupId):
        self._SecurityGroupId = SecurityGroupId

    @property
    def ReferredSecurityGroupIds(self):
        return self._ReferredSecurityGroupIds

    @ReferredSecurityGroupIds.setter
    def ReferredSecurityGroupIds(self, ReferredSecurityGroupIds):
        self._ReferredSecurityGroupIds = ReferredSecurityGroupIds


    def _deserialize(self, params):
        self._SecurityGroupId = params.get("SecurityGroupId")
        self._ReferredSecurityGroupIds = params.get("ReferredSecurityGroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RefreshDirectConnectGatewayRouteToNatGatewayRequest(AbstractModel):
    """RefreshDirectConnectGatewayRouteToNatGateway request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC ID
        :type VpcId: str
        :param _NatGatewayId: The NAT gateway ID.
        :type NatGatewayId: str
        :param _DryRun: Whether it is pre-refresh. Valid values: `True` (yes) and `False` (no)
        :type DryRun: bool
        """
        self._VpcId = None
        self._NatGatewayId = None
        self._DryRun = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def NatGatewayId(self):
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def DryRun(self):
        return self._DryRun

    @DryRun.setter
    def DryRun(self, DryRun):
        self._DryRun = DryRun


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._NatGatewayId = params.get("NatGatewayId")
        self._DryRun = params.get("DryRun")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RefreshDirectConnectGatewayRouteToNatGatewayResponse(AbstractModel):
    """RefreshDirectConnectGatewayRouteToNatGateway response structure.

    """

    def __init__(self):
        r"""
        :param _DirectConnectSubnetSet: IDC subnet information
        :type DirectConnectSubnetSet: list of DirectConnectSubnet
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DirectConnectSubnetSet = None
        self._RequestId = None

    @property
    def DirectConnectSubnetSet(self):
        return self._DirectConnectSubnetSet

    @DirectConnectSubnetSet.setter
    def DirectConnectSubnetSet(self, DirectConnectSubnetSet):
        self._DirectConnectSubnetSet = DirectConnectSubnetSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DirectConnectSubnetSet") is not None:
            self._DirectConnectSubnetSet = []
            for item in params.get("DirectConnectSubnetSet"):
                obj = DirectConnectSubnet()
                obj._deserialize(item)
                self._DirectConnectSubnetSet.append(obj)
        self._RequestId = params.get("RequestId")


class RejectAttachCcnInstancesRequest(AbstractModel):
    """RejectAttachCcnInstances request structure.

    """

    def __init__(self):
        r"""
        :param _CcnId: The CCN instance ID, such as `ccn-f49l6u0z`.
        :type CcnId: str
        :param _Instances: The list of instances whose association is rejected.
        :type Instances: list of CcnInstance
        """
        self._CcnId = None
        self._Instances = None

    @property
    def CcnId(self):
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def Instances(self):
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = CcnInstance()
                obj._deserialize(item)
                self._Instances.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RejectAttachCcnInstancesResponse(AbstractModel):
    """RejectAttachCcnInstances response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ReleaseAddressesRequest(AbstractModel):
    """ReleaseAddresses request structure.

    """

    def __init__(self):
        r"""
        :param _AddressIds: The unique ID list of the EIP. The unique ID of an EIP is as follows: `eip-11112222`.
        :type AddressIds: list of str
        """
        self._AddressIds = None

    @property
    def AddressIds(self):
        return self._AddressIds

    @AddressIds.setter
    def AddressIds(self, AddressIds):
        self._AddressIds = AddressIds


    def _deserialize(self, params):
        self._AddressIds = params.get("AddressIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ReleaseAddressesResponse(AbstractModel):
    """ReleaseAddresses response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: The async task ID. You can use the [DescribeTaskResult](https://intl.cloud.tencent.com/document/api/215/36271?from_cn_redirect=1) API to query the task status.
        :type TaskId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class RemoveBandwidthPackageResourcesRequest(AbstractModel):
    """RemoveBandwidthPackageResources request structure.

    """

    def __init__(self):
        r"""
        :param _BandwidthPackageId: The unique ID of the bandwidth package, such as `bwp-xxxx`.
        :type BandwidthPackageId: str
        :param _ResourceType: The resource type. Valid values: `Address` and `LoadBalance`.
        :type ResourceType: str
        :param _ResourceIds: The resource IP, such as `eip-xxxx` and `lb-xxxx`.
        :type ResourceIds: list of str
        """
        self._BandwidthPackageId = None
        self._ResourceType = None
        self._ResourceIds = None

    @property
    def BandwidthPackageId(self):
        return self._BandwidthPackageId

    @BandwidthPackageId.setter
    def BandwidthPackageId(self, BandwidthPackageId):
        self._BandwidthPackageId = BandwidthPackageId

    @property
    def ResourceType(self):
        return self._ResourceType

    @ResourceType.setter
    def ResourceType(self, ResourceType):
        self._ResourceType = ResourceType

    @property
    def ResourceIds(self):
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds


    def _deserialize(self, params):
        self._BandwidthPackageId = params.get("BandwidthPackageId")
        self._ResourceType = params.get("ResourceType")
        self._ResourceIds = params.get("ResourceIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RemoveBandwidthPackageResourcesResponse(AbstractModel):
    """RemoveBandwidthPackageResources response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class RenewVpnGatewayRequest(AbstractModel):
    """RenewVpnGateway request structure.

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: The ID of the VPN gateway instance.
        :type VpnGatewayId: str
        :param _InstanceChargePrepaid: Billing Methods
        :type InstanceChargePrepaid: :class:`tencentcloud.vpc.v20170312.models.InstanceChargePrepaid`
        """
        self._VpnGatewayId = None
        self._InstanceChargePrepaid = None

    @property
    def VpnGatewayId(self):
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId

    @property
    def InstanceChargePrepaid(self):
        return self._InstanceChargePrepaid

    @InstanceChargePrepaid.setter
    def InstanceChargePrepaid(self, InstanceChargePrepaid):
        self._InstanceChargePrepaid = InstanceChargePrepaid


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        if params.get("InstanceChargePrepaid") is not None:
            self._InstanceChargePrepaid = InstanceChargePrepaid()
            self._InstanceChargePrepaid._deserialize(params.get("InstanceChargePrepaid"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RenewVpnGatewayResponse(AbstractModel):
    """RenewVpnGateway response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ReplaceDirectConnectGatewayCcnRoutesRequest(AbstractModel):
    """ReplaceDirectConnectGatewayCcnRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _DirectConnectGatewayId: The ID of the Direct Connect gateway, such as `dcg-prpqlmg1`
        :type DirectConnectGatewayId: str
        :param _Routes: The list of IDC IP range that must be connected
        :type Routes: list of DirectConnectGatewayCcnRoute
        """
        self._DirectConnectGatewayId = None
        self._Routes = None

    @property
    def DirectConnectGatewayId(self):
        return self._DirectConnectGatewayId

    @DirectConnectGatewayId.setter
    def DirectConnectGatewayId(self, DirectConnectGatewayId):
        self._DirectConnectGatewayId = DirectConnectGatewayId

    @property
    def Routes(self):
        return self._Routes

    @Routes.setter
    def Routes(self, Routes):
        self._Routes = Routes


    def _deserialize(self, params):
        self._DirectConnectGatewayId = params.get("DirectConnectGatewayId")
        if params.get("Routes") is not None:
            self._Routes = []
            for item in params.get("Routes"):
                obj = DirectConnectGatewayCcnRoute()
                obj._deserialize(item)
                self._Routes.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ReplaceDirectConnectGatewayCcnRoutesResponse(AbstractModel):
    """ReplaceDirectConnectGatewayCcnRoutes response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ReplaceRouteTableAssociationRequest(AbstractModel):
    """ReplaceRouteTableAssociation request structure.

    """

    def __init__(self):
        r"""
        :param _SubnetId: Subnet instance ID, such as `subnet-3x5lf5q0`. This can be queried using the DescribeSubnets API.
        :type SubnetId: str
        :param _RouteTableId: The route table instance ID, such as `rtb-azd4dt1c`.
        :type RouteTableId: str
        """
        self._SubnetId = None
        self._RouteTableId = None

    @property
    def SubnetId(self):
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def RouteTableId(self):
        return self._RouteTableId

    @RouteTableId.setter
    def RouteTableId(self, RouteTableId):
        self._RouteTableId = RouteTableId


    def _deserialize(self, params):
        self._SubnetId = params.get("SubnetId")
        self._RouteTableId = params.get("RouteTableId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ReplaceRouteTableAssociationResponse(AbstractModel):
    """ReplaceRouteTableAssociation response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ReplaceRoutesRequest(AbstractModel):
    """ReplaceRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _RouteTableId: The route table instance ID, such as `rtb-azd4dt1c`.
        :type RouteTableId: str
        :param _Routes: Routing policy object. The routing policy ID (RouteId) must be specified.
        :type Routes: list of Route
        """
        self._RouteTableId = None
        self._Routes = None

    @property
    def RouteTableId(self):
        return self._RouteTableId

    @RouteTableId.setter
    def RouteTableId(self, RouteTableId):
        self._RouteTableId = RouteTableId

    @property
    def Routes(self):
        return self._Routes

    @Routes.setter
    def Routes(self, Routes):
        self._Routes = Routes


    def _deserialize(self, params):
        self._RouteTableId = params.get("RouteTableId")
        if params.get("Routes") is not None:
            self._Routes = []
            for item in params.get("Routes"):
                obj = Route()
                obj._deserialize(item)
                self._Routes.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ReplaceRoutesResponse(AbstractModel):
    """ReplaceRoutes response structure.

    """

    def __init__(self):
        r"""
        :param _OldRouteSet: Old routing policy
        :type OldRouteSet: list of Route
        :param _NewRouteSet: New routing policy
        :type NewRouteSet: list of Route
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._OldRouteSet = None
        self._NewRouteSet = None
        self._RequestId = None

    @property
    def OldRouteSet(self):
        return self._OldRouteSet

    @OldRouteSet.setter
    def OldRouteSet(self, OldRouteSet):
        self._OldRouteSet = OldRouteSet

    @property
    def NewRouteSet(self):
        return self._NewRouteSet

    @NewRouteSet.setter
    def NewRouteSet(self, NewRouteSet):
        self._NewRouteSet = NewRouteSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("OldRouteSet") is not None:
            self._OldRouteSet = []
            for item in params.get("OldRouteSet"):
                obj = Route()
                obj._deserialize(item)
                self._OldRouteSet.append(obj)
        if params.get("NewRouteSet") is not None:
            self._NewRouteSet = []
            for item in params.get("NewRouteSet"):
                obj = Route()
                obj._deserialize(item)
                self._NewRouteSet.append(obj)
        self._RequestId = params.get("RequestId")


class ReplaceSecurityGroupPoliciesRequest(AbstractModel):
    """ReplaceSecurityGroupPolicies request structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroupId: The security group instance ID, such as `sg-33ocnj9n`. This can be obtained through the `DescribeSecurityGroups` API.
        :type SecurityGroupId: str
        :param _SecurityGroupPolicySet: Security group policy set object.
        :type SecurityGroupPolicySet: :class:`tencentcloud.vpc.v20170312.models.SecurityGroupPolicySet`
        :param _OriginalSecurityGroupPolicySet: (Optional) The old policy set of the security group, which is used for log records.
        :type OriginalSecurityGroupPolicySet: :class:`tencentcloud.vpc.v20170312.models.SecurityGroupPolicySet`
        """
        self._SecurityGroupId = None
        self._SecurityGroupPolicySet = None
        self._OriginalSecurityGroupPolicySet = None

    @property
    def SecurityGroupId(self):
        return self._SecurityGroupId

    @SecurityGroupId.setter
    def SecurityGroupId(self, SecurityGroupId):
        self._SecurityGroupId = SecurityGroupId

    @property
    def SecurityGroupPolicySet(self):
        return self._SecurityGroupPolicySet

    @SecurityGroupPolicySet.setter
    def SecurityGroupPolicySet(self, SecurityGroupPolicySet):
        self._SecurityGroupPolicySet = SecurityGroupPolicySet

    @property
    def OriginalSecurityGroupPolicySet(self):
        return self._OriginalSecurityGroupPolicySet

    @OriginalSecurityGroupPolicySet.setter
    def OriginalSecurityGroupPolicySet(self, OriginalSecurityGroupPolicySet):
        self._OriginalSecurityGroupPolicySet = OriginalSecurityGroupPolicySet


    def _deserialize(self, params):
        self._SecurityGroupId = params.get("SecurityGroupId")
        if params.get("SecurityGroupPolicySet") is not None:
            self._SecurityGroupPolicySet = SecurityGroupPolicySet()
            self._SecurityGroupPolicySet._deserialize(params.get("SecurityGroupPolicySet"))
        if params.get("OriginalSecurityGroupPolicySet") is not None:
            self._OriginalSecurityGroupPolicySet = SecurityGroupPolicySet()
            self._OriginalSecurityGroupPolicySet._deserialize(params.get("OriginalSecurityGroupPolicySet"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ReplaceSecurityGroupPoliciesResponse(AbstractModel):
    """ReplaceSecurityGroupPolicies response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ReplaceSecurityGroupPolicyRequest(AbstractModel):
    """ReplaceSecurityGroupPolicy request structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroupId: The security group instance ID, such as `sg-33ocnj9n`. This can be obtained through DescribeSecurityGroups.
        :type SecurityGroupId: str
        :param _SecurityGroupPolicySet: Security group policy set object.
        :type SecurityGroupPolicySet: :class:`tencentcloud.vpc.v20170312.models.SecurityGroupPolicySet`
        :param _OriginalSecurityGroupPolicySet: (Optional) The old policy set of the security group, which is used for log records.
        :type OriginalSecurityGroupPolicySet: :class:`tencentcloud.vpc.v20170312.models.SecurityGroupPolicySet`
        """
        self._SecurityGroupId = None
        self._SecurityGroupPolicySet = None
        self._OriginalSecurityGroupPolicySet = None

    @property
    def SecurityGroupId(self):
        return self._SecurityGroupId

    @SecurityGroupId.setter
    def SecurityGroupId(self, SecurityGroupId):
        self._SecurityGroupId = SecurityGroupId

    @property
    def SecurityGroupPolicySet(self):
        return self._SecurityGroupPolicySet

    @SecurityGroupPolicySet.setter
    def SecurityGroupPolicySet(self, SecurityGroupPolicySet):
        self._SecurityGroupPolicySet = SecurityGroupPolicySet

    @property
    def OriginalSecurityGroupPolicySet(self):
        return self._OriginalSecurityGroupPolicySet

    @OriginalSecurityGroupPolicySet.setter
    def OriginalSecurityGroupPolicySet(self, OriginalSecurityGroupPolicySet):
        self._OriginalSecurityGroupPolicySet = OriginalSecurityGroupPolicySet


    def _deserialize(self, params):
        self._SecurityGroupId = params.get("SecurityGroupId")
        if params.get("SecurityGroupPolicySet") is not None:
            self._SecurityGroupPolicySet = SecurityGroupPolicySet()
            self._SecurityGroupPolicySet._deserialize(params.get("SecurityGroupPolicySet"))
        if params.get("OriginalSecurityGroupPolicySet") is not None:
            self._OriginalSecurityGroupPolicySet = SecurityGroupPolicySet()
            self._OriginalSecurityGroupPolicySet._deserialize(params.get("OriginalSecurityGroupPolicySet"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ReplaceSecurityGroupPolicyResponse(AbstractModel):
    """ReplaceSecurityGroupPolicy response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ResetAttachCcnInstancesRequest(AbstractModel):
    """ResetAttachCcnInstances request structure.

    """

    def __init__(self):
        r"""
        :param _CcnId: The CCN instance ID, such as `ccn-f49l6u0z`.
        :type CcnId: str
        :param _CcnUin: The UIN (root account) to which the CCN belongs.
        :type CcnUin: str
        :param _Instances: The list of network instances that re-apply for association.
        :type Instances: list of CcnInstance
        """
        self._CcnId = None
        self._CcnUin = None
        self._Instances = None

    @property
    def CcnId(self):
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def CcnUin(self):
        return self._CcnUin

    @CcnUin.setter
    def CcnUin(self, CcnUin):
        self._CcnUin = CcnUin

    @property
    def Instances(self):
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        self._CcnUin = params.get("CcnUin")
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = CcnInstance()
                obj._deserialize(item)
                self._Instances.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResetAttachCcnInstancesResponse(AbstractModel):
    """ResetAttachCcnInstances response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ResetNatGatewayConnectionRequest(AbstractModel):
    """ResetNatGatewayConnection request structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: The NAT gateway ID.
        :type NatGatewayId: str
        :param _MaxConcurrentConnection: Concurrent connections cap of the NAT gateway, such as 1000000, 3000000, 10000000.
        :type MaxConcurrentConnection: int
        """
        self._NatGatewayId = None
        self._MaxConcurrentConnection = None

    @property
    def NatGatewayId(self):
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def MaxConcurrentConnection(self):
        return self._MaxConcurrentConnection

    @MaxConcurrentConnection.setter
    def MaxConcurrentConnection(self, MaxConcurrentConnection):
        self._MaxConcurrentConnection = MaxConcurrentConnection


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        self._MaxConcurrentConnection = params.get("MaxConcurrentConnection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResetNatGatewayConnectionResponse(AbstractModel):
    """ResetNatGatewayConnection response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ResetRoutesRequest(AbstractModel):
    """ResetRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _RouteTableId: The route table instance ID, such as `rtb-azd4dt1c`.
        :type RouteTableId: str
        :param _RouteTableName: The route table name. The maximum length is 60 characters.
        :type RouteTableName: str
        :param _Routes: Routing policy.
        :type Routes: list of Route
        """
        self._RouteTableId = None
        self._RouteTableName = None
        self._Routes = None

    @property
    def RouteTableId(self):
        return self._RouteTableId

    @RouteTableId.setter
    def RouteTableId(self, RouteTableId):
        self._RouteTableId = RouteTableId

    @property
    def RouteTableName(self):
        return self._RouteTableName

    @RouteTableName.setter
    def RouteTableName(self, RouteTableName):
        self._RouteTableName = RouteTableName

    @property
    def Routes(self):
        return self._Routes

    @Routes.setter
    def Routes(self, Routes):
        self._Routes = Routes


    def _deserialize(self, params):
        self._RouteTableId = params.get("RouteTableId")
        self._RouteTableName = params.get("RouteTableName")
        if params.get("Routes") is not None:
            self._Routes = []
            for item in params.get("Routes"):
                obj = Route()
                obj._deserialize(item)
                self._Routes.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResetRoutesResponse(AbstractModel):
    """ResetRoutes response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ResetVpnConnectionRequest(AbstractModel):
    """ResetVpnConnection request structure.

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: The ID of the VPN gateway instance.
        :type VpnGatewayId: str
        :param _VpnConnectionId: The ID of the VPN tunnel instance, such as `vpnx-f49l6u0z`.
        :type VpnConnectionId: str
        """
        self._VpnGatewayId = None
        self._VpnConnectionId = None

    @property
    def VpnGatewayId(self):
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId

    @property
    def VpnConnectionId(self):
        return self._VpnConnectionId

    @VpnConnectionId.setter
    def VpnConnectionId(self, VpnConnectionId):
        self._VpnConnectionId = VpnConnectionId


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        self._VpnConnectionId = params.get("VpnConnectionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResetVpnConnectionResponse(AbstractModel):
    """ResetVpnConnection response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ResetVpnGatewayInternetMaxBandwidthRequest(AbstractModel):
    """ResetVpnGatewayInternetMaxBandwidth request structure.

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: The ID of the VPN gateway instance.
        :type VpnGatewayId: str
        :param _InternetMaxBandwidthOut: The new bandwidth cap in Mbps. Values: `5`, `10`, `20`, `50`, `100`, `200`, `500` and `1000`. The adjustment of the VPN gateway bandwidth is limited to [5,100] Mbps and [200,1000] Mbps.
        :type InternetMaxBandwidthOut: int
        """
        self._VpnGatewayId = None
        self._InternetMaxBandwidthOut = None

    @property
    def VpnGatewayId(self):
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId

    @property
    def InternetMaxBandwidthOut(self):
        return self._InternetMaxBandwidthOut

    @InternetMaxBandwidthOut.setter
    def InternetMaxBandwidthOut(self, InternetMaxBandwidthOut):
        self._InternetMaxBandwidthOut = InternetMaxBandwidthOut


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        self._InternetMaxBandwidthOut = params.get("InternetMaxBandwidthOut")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResetVpnGatewayInternetMaxBandwidthResponse(AbstractModel):
    """ResetVpnGatewayInternetMaxBandwidth response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class Resource(AbstractModel):
    """The structure of information of the bandwidth package.

    """

    def __init__(self):
        r"""
        :param _ResourceType: The bandwidth package resource type, including `Address`, and `LoadBalance`
        :type ResourceType: str
        :param _ResourceId: The bandwidth package ID, such as `eip-xxxx` and `lb-xxxx`.
        :type ResourceId: str
        :param _AddressIp: The bandwidth package resource IP.
        :type AddressIp: str
        """
        self._ResourceType = None
        self._ResourceId = None
        self._AddressIp = None

    @property
    def ResourceType(self):
        return self._ResourceType

    @ResourceType.setter
    def ResourceType(self, ResourceType):
        self._ResourceType = ResourceType

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId

    @property
    def AddressIp(self):
        return self._AddressIp

    @AddressIp.setter
    def AddressIp(self, AddressIp):
        self._AddressIp = AddressIp


    def _deserialize(self, params):
        self._ResourceType = params.get("ResourceType")
        self._ResourceId = params.get("ResourceId")
        self._AddressIp = params.get("AddressIp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResourceDashboard(AbstractModel):
    """VPC resource dashboard (all resource counts)

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC instance ID, such as `vpc-bq4bzxpj`.
        :type VpcId: str
        :param _SubnetId: Subnet instance ID, such as subnet-bthucmmy.
        :type SubnetId: str
        :param _Classiclink: Classiclink.
        :type Classiclink: int
        :param _Dcg: Direct Connect gateway.
        :type Dcg: int
        :param _Pcx: Peering connection.
        :type Pcx: int
        :param _Ip: Total number of used IPs except for CVM IP, EIP and network probe IP. The three IP types will be independently counted.
        :type Ip: int
        :param _Nat: NAT gateway.
        :type Nat: int
        :param _Vpngw: VPN gateway.
        :type Vpngw: int
        :param _FlowLog: Flow log.
        :type FlowLog: int
        :param _NetworkDetect: Network probing.
        :type NetworkDetect: int
        :param _NetworkACL: Network ACL.
        :type NetworkACL: int
        :param _CVM: Cloud Virtual Machine.
        :type CVM: int
        :param _LB: Load balancer.
        :type LB: int
        :param _CDB: Relational database.
        :type CDB: int
        :param _Cmem: TencentDB for Memcached.
        :type Cmem: int
        :param _CTSDB: Cloud time series database.
        :type CTSDB: int
        :param _MariaDB: TencentDB for MariaDB (TDSQL).
        :type MariaDB: int
        :param _SQLServer: TencentDB for SQL Server.
        :type SQLServer: int
        :param _Postgres: TencentDB for PostgreSQL.
        :type Postgres: int
        :param _NAS: Network attached storage.
        :type NAS: int
        :param _Greenplumn: Snova data warehouse.
        :type Greenplumn: int
        :param _Ckafka: Cloud Kafka (CKafka).
        :type Ckafka: int
        :param _Grocery: Grocery.
        :type Grocery: int
        :param _HSM: Data encryption service.
        :type HSM: int
        :param _Tcaplus: Game storage - Tcaplus.
        :type Tcaplus: int
        :param _Cnas: Cnas.
        :type Cnas: int
        :param _TiDB: HTAP database - TiDB.
        :type TiDB: int
        :param _Emr: EMR cluster.
        :type Emr: int
        :param _SEAL: SEAL.
        :type SEAL: int
        :param _CFS: Cloud file storage - CFS.
        :type CFS: int
        :param _Oracle: Oracle.
        :type Oracle: int
        :param _ElasticSearch: ElasticSearch Service.
        :type ElasticSearch: int
        :param _TBaaS: Blockchain service.
        :type TBaaS: int
        :param _Itop: Itop.
        :type Itop: int
        :param _DBAudit: Cloud database audit.
        :type DBAudit: int
        :param _CynosDBPostgres: Enterprise TencentDB - CynosDB for Postgres.
        :type CynosDBPostgres: int
        :param _Redis: TencentDB for Redis.
        :type Redis: int
        :param _MongoDB: TencentDB for MongoDB.
        :type MongoDB: int
        :param _DCDB: A distributed cloud database - TencentDB for TDSQL.
        :type DCDB: int
        :param _CynosDBMySQL: An enterprise-grade TencentDB - CynosDB for MySQL.
        :type CynosDBMySQL: int
        :param _Subnet: Subnets.
        :type Subnet: int
        :param _RouteTable: Route table.
        :type RouteTable: int
        """
        self._VpcId = None
        self._SubnetId = None
        self._Classiclink = None
        self._Dcg = None
        self._Pcx = None
        self._Ip = None
        self._Nat = None
        self._Vpngw = None
        self._FlowLog = None
        self._NetworkDetect = None
        self._NetworkACL = None
        self._CVM = None
        self._LB = None
        self._CDB = None
        self._Cmem = None
        self._CTSDB = None
        self._MariaDB = None
        self._SQLServer = None
        self._Postgres = None
        self._NAS = None
        self._Greenplumn = None
        self._Ckafka = None
        self._Grocery = None
        self._HSM = None
        self._Tcaplus = None
        self._Cnas = None
        self._TiDB = None
        self._Emr = None
        self._SEAL = None
        self._CFS = None
        self._Oracle = None
        self._ElasticSearch = None
        self._TBaaS = None
        self._Itop = None
        self._DBAudit = None
        self._CynosDBPostgres = None
        self._Redis = None
        self._MongoDB = None
        self._DCDB = None
        self._CynosDBMySQL = None
        self._Subnet = None
        self._RouteTable = None

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def Classiclink(self):
        return self._Classiclink

    @Classiclink.setter
    def Classiclink(self, Classiclink):
        self._Classiclink = Classiclink

    @property
    def Dcg(self):
        return self._Dcg

    @Dcg.setter
    def Dcg(self, Dcg):
        self._Dcg = Dcg

    @property
    def Pcx(self):
        return self._Pcx

    @Pcx.setter
    def Pcx(self, Pcx):
        self._Pcx = Pcx

    @property
    def Ip(self):
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def Nat(self):
        return self._Nat

    @Nat.setter
    def Nat(self, Nat):
        self._Nat = Nat

    @property
    def Vpngw(self):
        return self._Vpngw

    @Vpngw.setter
    def Vpngw(self, Vpngw):
        self._Vpngw = Vpngw

    @property
    def FlowLog(self):
        return self._FlowLog

    @FlowLog.setter
    def FlowLog(self, FlowLog):
        self._FlowLog = FlowLog

    @property
    def NetworkDetect(self):
        return self._NetworkDetect

    @NetworkDetect.setter
    def NetworkDetect(self, NetworkDetect):
        self._NetworkDetect = NetworkDetect

    @property
    def NetworkACL(self):
        return self._NetworkACL

    @NetworkACL.setter
    def NetworkACL(self, NetworkACL):
        self._NetworkACL = NetworkACL

    @property
    def CVM(self):
        return self._CVM

    @CVM.setter
    def CVM(self, CVM):
        self._CVM = CVM

    @property
    def LB(self):
        return self._LB

    @LB.setter
    def LB(self, LB):
        self._LB = LB

    @property
    def CDB(self):
        return self._CDB

    @CDB.setter
    def CDB(self, CDB):
        self._CDB = CDB

    @property
    def Cmem(self):
        return self._Cmem

    @Cmem.setter
    def Cmem(self, Cmem):
        self._Cmem = Cmem

    @property
    def CTSDB(self):
        return self._CTSDB

    @CTSDB.setter
    def CTSDB(self, CTSDB):
        self._CTSDB = CTSDB

    @property
    def MariaDB(self):
        return self._MariaDB

    @MariaDB.setter
    def MariaDB(self, MariaDB):
        self._MariaDB = MariaDB

    @property
    def SQLServer(self):
        return self._SQLServer

    @SQLServer.setter
    def SQLServer(self, SQLServer):
        self._SQLServer = SQLServer

    @property
    def Postgres(self):
        return self._Postgres

    @Postgres.setter
    def Postgres(self, Postgres):
        self._Postgres = Postgres

    @property
    def NAS(self):
        return self._NAS

    @NAS.setter
    def NAS(self, NAS):
        self._NAS = NAS

    @property
    def Greenplumn(self):
        return self._Greenplumn

    @Greenplumn.setter
    def Greenplumn(self, Greenplumn):
        self._Greenplumn = Greenplumn

    @property
    def Ckafka(self):
        return self._Ckafka

    @Ckafka.setter
    def Ckafka(self, Ckafka):
        self._Ckafka = Ckafka

    @property
    def Grocery(self):
        return self._Grocery

    @Grocery.setter
    def Grocery(self, Grocery):
        self._Grocery = Grocery

    @property
    def HSM(self):
        return self._HSM

    @HSM.setter
    def HSM(self, HSM):
        self._HSM = HSM

    @property
    def Tcaplus(self):
        return self._Tcaplus

    @Tcaplus.setter
    def Tcaplus(self, Tcaplus):
        self._Tcaplus = Tcaplus

    @property
    def Cnas(self):
        return self._Cnas

    @Cnas.setter
    def Cnas(self, Cnas):
        self._Cnas = Cnas

    @property
    def TiDB(self):
        return self._TiDB

    @TiDB.setter
    def TiDB(self, TiDB):
        self._TiDB = TiDB

    @property
    def Emr(self):
        return self._Emr

    @Emr.setter
    def Emr(self, Emr):
        self._Emr = Emr

    @property
    def SEAL(self):
        return self._SEAL

    @SEAL.setter
    def SEAL(self, SEAL):
        self._SEAL = SEAL

    @property
    def CFS(self):
        return self._CFS

    @CFS.setter
    def CFS(self, CFS):
        self._CFS = CFS

    @property
    def Oracle(self):
        return self._Oracle

    @Oracle.setter
    def Oracle(self, Oracle):
        self._Oracle = Oracle

    @property
    def ElasticSearch(self):
        return self._ElasticSearch

    @ElasticSearch.setter
    def ElasticSearch(self, ElasticSearch):
        self._ElasticSearch = ElasticSearch

    @property
    def TBaaS(self):
        return self._TBaaS

    @TBaaS.setter
    def TBaaS(self, TBaaS):
        self._TBaaS = TBaaS

    @property
    def Itop(self):
        return self._Itop

    @Itop.setter
    def Itop(self, Itop):
        self._Itop = Itop

    @property
    def DBAudit(self):
        return self._DBAudit

    @DBAudit.setter
    def DBAudit(self, DBAudit):
        self._DBAudit = DBAudit

    @property
    def CynosDBPostgres(self):
        return self._CynosDBPostgres

    @CynosDBPostgres.setter
    def CynosDBPostgres(self, CynosDBPostgres):
        self._CynosDBPostgres = CynosDBPostgres

    @property
    def Redis(self):
        return self._Redis

    @Redis.setter
    def Redis(self, Redis):
        self._Redis = Redis

    @property
    def MongoDB(self):
        return self._MongoDB

    @MongoDB.setter
    def MongoDB(self, MongoDB):
        self._MongoDB = MongoDB

    @property
    def DCDB(self):
        return self._DCDB

    @DCDB.setter
    def DCDB(self, DCDB):
        self._DCDB = DCDB

    @property
    def CynosDBMySQL(self):
        return self._CynosDBMySQL

    @CynosDBMySQL.setter
    def CynosDBMySQL(self, CynosDBMySQL):
        self._CynosDBMySQL = CynosDBMySQL

    @property
    def Subnet(self):
        return self._Subnet

    @Subnet.setter
    def Subnet(self, Subnet):
        self._Subnet = Subnet

    @property
    def RouteTable(self):
        return self._RouteTable

    @RouteTable.setter
    def RouteTable(self, RouteTable):
        self._RouteTable = RouteTable


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._Classiclink = params.get("Classiclink")
        self._D