# -*- coding: utf-8 -*-
# Copyright (c) 2025-2025 Huawei Technologies Co., Ltd.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from ..base import NodeChecker
from ...utils import get_model_type


class MIESConfigChecker(NodeChecker):
    def __init__(self, *, error_handler=None, rule_manager=None):
        super().__init__(error_handler=error_handler, rule_manager=rule_manager)
        self.error_handler.type = "mies config"

    def _get_rules(self):
        model_type = get_model_type()
        if not model_type or "deepseek" not in model_type:
            self.rule_manager.scene = "pd_mix"
        else:
            self.rule_manager.scene = "pd_mix_dsr1"
        return self.rule_manager.get_rules()['mies_config']
