# -*- coding: utf-8 -*-
# Copyright (c) 2025-2025 Huawei Technologies Co., Ltd.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import argparse
from textwrap import dedent


def setup_compare_parser(subparsers):
    compare_parser = subparsers.add_parser(
        'compare',
        formatter_class=argparse.RawDescriptionHelpFormatter,
        description=dedent('''\
            COMPARE - Compare the results of multiple msprechecker dump runs.

            This command compares the outputs (JSON files) generated by previous runs of msprechecker dump.
            It highlights differences in both the main check results and configuration sections.

            Typical use cases:
              - Regression testing between different environments or code versions.
              - Verifying consistency across multiple deployments.
        '''),
        usage='msprechecker compare FILE1 FILE2 [FILE3 ...]',
        epilog=dedent('''\
            Examples:
              msprechecker compare result_a.json result_b.json
              msprechecker compare ./out1.json ./out2.json ./out3.json
        ''',
        ),
        help="  Compare the results of multiple msprechecker dump runs"
    )
    compare_parser.add_argument(
        'dumped_path',
        nargs='+',
        metavar='FILE',
        help='Paths to msprechecker output JSON files to compare (at least two required)'
    )
    return compare_parser
