/**
 * Generated by orval v7.9.0 🍺
 * Do not edit manually.
 * FastAPI
 * OpenAPI spec version: 0.1.0
 */
import { fetchAPI } from './instance'
export type ApiExceptionPayloadStatus = number | null

export type ApiExceptionPayloadTrigger = string | null

export type ApiExceptionPayloadType = string | null

export type ApiExceptionPayloadDescription = string | null

export type ApiExceptionPayloadTraceback = string | null

export type ApiExceptionPayloadStack = string[] | null

export interface ApiExceptionPayload {
  timestamp: number
  message: string
  origin: string
  status?: ApiExceptionPayloadStatus
  trigger?: ApiExceptionPayloadTrigger
  type?: ApiExceptionPayloadType
  description?: ApiExceptionPayloadDescription
  traceback?: ApiExceptionPayloadTraceback
  stack?: ApiExceptionPayloadStack
}

export interface BackfillDetails {
  name: string
  view_name: string
  node_type?: NodeType
  parents?: string[]
  interval: string[]
  batches: number
}

export type BackfillTaskEnd = number | null

export type BackfillTaskInterval = string[] | null

export interface BackfillTask {
  name: string
  view_name: string
  node_type?: NodeType
  parents?: string[]
  completed: number
  total: number
  start: number
  end?: BackfillTaskEnd
  interval?: BackfillTaskInterval
}

export type BodyInitiateApplyApiCommandsApplyPostEnvironment = string | null

export type BodyInitiateApplyApiCommandsApplyPostPlanDates = PlanDates | null

export type BodyInitiateApplyApiCommandsApplyPostPlanOptions =
  PlanOptions | null

export type BodyInitiateApplyApiCommandsApplyPostCategoriesAnyOf = {
  [key: string]: SnapshotChangeCategory
}

export type BodyInitiateApplyApiCommandsApplyPostCategories =
  BodyInitiateApplyApiCommandsApplyPostCategoriesAnyOf | null

export interface BodyInitiateApplyApiCommandsApplyPost {
  environment?: BodyInitiateApplyApiCommandsApplyPostEnvironment
  plan_dates?: BodyInitiateApplyApiCommandsApplyPostPlanDates
  plan_options?: BodyInitiateApplyApiCommandsApplyPostPlanOptions
  categories?: BodyInitiateApplyApiCommandsApplyPostCategories
}

export type BodyInitiatePlanApiPlanPostEnvironment = string | null

export type BodyInitiatePlanApiPlanPostPlanDates = PlanDates | null

export type BodyInitiatePlanApiPlanPostPlanOptions = PlanOptions | null

export type BodyInitiatePlanApiPlanPostCategoriesAnyOf = {
  [key: string]: SnapshotChangeCategory
}

export type BodyInitiatePlanApiPlanPostCategories =
  BodyInitiatePlanApiPlanPostCategoriesAnyOf | null

export interface BodyInitiatePlanApiPlanPost {
  environment?: BodyInitiatePlanApiPlanPostEnvironment
  plan_dates?: BodyInitiatePlanApiPlanPostPlanDates
  plan_options?: BodyInitiatePlanApiPlanPostPlanOptions
  categories?: BodyInitiatePlanApiPlanPostCategories
}

export type BodyWriteDirectoryApiDirectoriesPathPostNewPath = string | null

export interface BodyWriteDirectoryApiDirectoriesPathPost {
  new_path?: BodyWriteDirectoryApiDirectoriesPathPostNewPath
}

export type BodyWriteFileApiFilesPathPostNewPath = string | null

export interface BodyWriteFileApiFilesPathPost {
  content?: string
  new_path?: BodyWriteFileApiFilesPathPostNewPath
}

export type ChangeDirectChangeCategory = SnapshotChangeCategory | null

export interface ChangeDirect {
  name: string
  view_name: string
  node_type?: NodeType
  parents?: string[]
  diff: string
  indirect?: ChangeDisplay[]
  direct?: ChangeDisplay[]
  change_category?: ChangeDirectChangeCategory
}

export interface ChangeDisplay {
  name: string
  view_name: string
  node_type?: NodeType
  parents?: string[]
}

export interface ChangeIndirect {
  name: string
  view_name: string
  node_type?: NodeType
  parents?: string[]
}

export type ColumnDescription = string | null

export interface Column {
  name: string
  type: string
  description?: ColumnDescription
}

export interface Directory {
  name: string
  path: string
  directories?: Directory[]
  files?: File[]
}

export type EnvironmentStartAt = string | string | string | number | number

export type EnvironmentEndAt = string | string | string | number | number | null

export type EnvironmentPreviousPlanId = string | null

export type EnvironmentExpirationTs = number | null

export type EnvironmentFinalizedTs = number | null

export type EnvironmentCatalogNameOverride = string | null

export type EnvironmentPromotedSnapshotIds = unknown[] | null

export type EnvironmentPreviousFinalizedSnapshots = unknown[] | null

export type EnvironmentRequirements = { [key: string]: string }

/**
 * Represents an isolated environment.

Environments are isolated workspaces that hold pointers to physical tables.

Args:
    snapshots: The snapshots that are part of this environment.
    promoted_snapshot_ids: The IDs of the snapshots that are promoted in this environment
        (i.e. for which the views are created). If not specified, all snapshots are promoted.
    previous_finalized_snapshots: Snapshots that were part of this environment last time it was finalized.
    requirements: A mapping of library versions for all the snapshots in this environment.
 */
export interface Environment {
  name?: string
  start_at: EnvironmentStartAt
  end_at?: EnvironmentEndAt
  plan_id: string
  previous_plan_id?: EnvironmentPreviousPlanId
  expiration_ts?: EnvironmentExpirationTs
  finalized_ts?: EnvironmentFinalizedTs
  suffix_target?: EnvironmentSuffixTarget
  catalog_name_override?: EnvironmentCatalogNameOverride
  normalize_name?: boolean
  gateway_managed?: boolean
  snapshots: unknown[]
  promoted_snapshot_ids?: EnvironmentPromotedSnapshotIds
  previous_finalized_snapshots?: EnvironmentPreviousFinalizedSnapshots
  requirements?: EnvironmentRequirements
}

export type EnvironmentSuffixTarget =
  (typeof EnvironmentSuffixTarget)[keyof typeof EnvironmentSuffixTarget]

// eslint-disable-next-line @typescript-eslint/no-redeclare
export const EnvironmentSuffixTarget = {
  schema: 'schema',
  table: 'table',
} as const

export type EnvironmentsEnvironments = { [key: string]: Environment }

export interface Environments {
  environments?: EnvironmentsEnvironments
  pinned_environments?: string[]
  default_target_environment?: string
}

export type EvaluateInputStart = string | string | string | number | number

export type EvaluateInputEnd = string | string | string | number | number

export type EvaluateInputExecutionTime =
  | string
  | string
  | string
  | number
  | number

export interface EvaluateInput {
  model: string
  start: EvaluateInputStart
  end: EvaluateInputEnd
  execution_time: EvaluateInputExecutionTime
  limit?: number
}

export interface FetchdfInput {
  sql: string
  limit?: number
}

export type FileContent = string | null

export interface File {
  name: string
  path: string
  extension?: string
  content?: FileContent
}

export interface HTTPValidationError {
  detail?: ValidationError[]
}

/**
 * IntervalUnit is the inferred granularity of an incremental node.

IntervalUnit can be one of 5 types, YEAR, MONTH, DAY, HOUR, MINUTE. The unit is inferred
based on the cron schedule of a node. The minimum time delta between a sample set of dates
is used to determine which unit a node's schedule is.
 */
export type IntervalUnit = (typeof IntervalUnit)[keyof typeof IntervalUnit]

// eslint-disable-next-line @typescript-eslint/no-redeclare
export const IntervalUnit = {
  year: 'year',
  month: 'month',
  day: 'day',
  hour: 'hour',
  half_hour: 'half_hour',
  quarter_hour: 'quarter_hour',
  five_minute: 'five_minute',
} as const

export type LineageColumnSource = string | null

export type LineageColumnExpression = string | null

export type LineageColumnModels = { [key: string]: string[] }

export interface LineageColumn {
  source?: LineageColumnSource
  expression?: LineageColumnExpression
  models: LineageColumnModels
}

export interface Meta {
  version: string
  has_running_task?: boolean
}

export type ModelDescription = string | null

export type ModelDetailsProperty = ModelDetails | null

export type ModelSql = string | null

export type ModelDefinition = string | null

export type ModelDefaultCatalog = string | null

export interface Model {
  name: string
  fqn: string
  path: string
  full_path: string
  dialect: string
  type: ModelType
  columns: Column[]
  description?: ModelDescription
  details?: ModelDetailsProperty
  sql?: ModelSql
  definition?: ModelDefinition
  default_catalog?: ModelDefaultCatalog
  hash: string
}

export type ModelDetailsOwner = string | null

export type ModelDetailsKind = string | null

export type ModelDetailsBatchSize = number | null

export type ModelDetailsCron = string | null

export type ModelDetailsStamp =
  | string
  | string
  | string
  | number
  | number
  | null

export type ModelDetailsStart =
  | string
  | string
  | string
  | number
  | number
  | null

export type ModelDetailsRetention = number | null

export type ModelDetailsTableFormat = string | null

export type ModelDetailsStorageFormat = string | null

export type ModelDetailsTimeColumn = string | null

export type ModelDetailsTags = string | null

export type ModelDetailsPartitionedBy = string | null

export type ModelDetailsClusteredBy = string | null

export type ModelDetailsLookback = number | null

export type ModelDetailsCronPrev =
  | string
  | string
  | string
  | number
  | number
  | null

export type ModelDetailsCronNext =
  | string
  | string
  | string
  | number
  | number
  | null

export type ModelDetailsIntervalUnit = IntervalUnit | null

export type ModelDetailsAnnotated = boolean | null

export interface ModelDetails {
  owner?: ModelDetailsOwner
  kind?: ModelDetailsKind
  batch_size?: ModelDetailsBatchSize
  cron?: ModelDetailsCron
  stamp?: ModelDetailsStamp
  start?: ModelDetailsStart
  retention?: ModelDetailsRetention
  table_format?: ModelDetailsTableFormat
  storage_format?: ModelDetailsStorageFormat
  time_column?: ModelDetailsTimeColumn
  tags?: ModelDetailsTags
  references?: Reference[]
  partitioned_by?: ModelDetailsPartitionedBy
  clustered_by?: ModelDetailsClusteredBy
  lookback?: ModelDetailsLookback
  cron_prev?: ModelDetailsCronPrev
  cron_next?: ModelDetailsCronNext
  interval_unit?: ModelDetailsIntervalUnit
  annotated?: ModelDetailsAnnotated
}

export type ModelType = (typeof ModelType)[keyof typeof ModelType]

// eslint-disable-next-line @typescript-eslint/no-redeclare
export const ModelType = {
  python: 'python',
  sql: 'sql',
  seed: 'seed',
  external: 'external',
  source: 'source',
} as const

export interface ModelsDiff {
  direct?: ChangeDirect[]
  indirect?: ChangeIndirect[]
  metadata?: ChangeDisplay[]
}

export type Modules = (typeof Modules)[keyof typeof Modules]

// eslint-disable-next-line @typescript-eslint/no-redeclare
export const Modules = {
  editor: 'editor',
  files: 'files',
  'data-catalog': 'data-catalog',
  plans: 'plans',
  tests: 'tests',
  audits: 'audits',
  errors: 'errors',
  data: 'data',
  lineage: 'lineage',
} as const

export type NodeType = (typeof NodeType)[keyof typeof NodeType]

// eslint-disable-next-line @typescript-eslint/no-redeclare
export const NodeType = {
  model: 'model',
  audit: 'audit',
} as const

export type PlanApplyStageTrackerStart =
  | string
  | string
  | string
  | number
  | number
  | null

export type PlanApplyStageTrackerEnd =
  | string
  | string
  | string
  | number
  | number
  | null

export type PlanApplyStageTrackerEnvironment = string | null

export type PlanApplyStageTrackerPlanOptions = PlanOptions | null

export type PlanApplyStageTrackerCreation = PlanStageCreation | null

export type PlanApplyStageTrackerRestate = PlanStageRestate | null

export type PlanApplyStageTrackerBackfill = PlanStageBackfill | null

export type PlanApplyStageTrackerPromote = PlanStagePromote | null

export interface PlanApplyStageTracker {
  start?: PlanApplyStageTrackerStart
  end?: PlanApplyStageTrackerEnd
  meta?: TrackableMeta
  environment?: PlanApplyStageTrackerEnvironment
  plan_options?: PlanApplyStageTrackerPlanOptions
  creation?: PlanApplyStageTrackerCreation
  restate?: PlanApplyStageTrackerRestate
  backfill?: PlanApplyStageTrackerBackfill
  promote?: PlanApplyStageTrackerPromote
}

export type PlanCancelStageTrackerStart =
  | string
  | string
  | string
  | number
  | number
  | null

export type PlanCancelStageTrackerEnd =
  | string
  | string
  | string
  | number
  | number
  | null

export type PlanCancelStageTrackerEnvironment = string | null

export type PlanCancelStageTrackerPlanOptions = PlanOptions | null

export type PlanCancelStageTrackerCancel = PlanStageCancel | null

export interface PlanCancelStageTracker {
  start?: PlanCancelStageTrackerStart
  end?: PlanCancelStageTrackerEnd
  meta?: TrackableMeta
  environment?: PlanCancelStageTrackerEnvironment
  plan_options?: PlanCancelStageTrackerPlanOptions
  cancel?: PlanCancelStageTrackerCancel
}

export type PlanDatesStart = string | string | string | number | number | null

export type PlanDatesEnd = string | string | string | number | number | null

export interface PlanDates {
  start?: PlanDatesStart
  end?: PlanDatesEnd
}

export type PlanOptionsCreateFrom = string | null

export type PlanOptionsRestateModels = string | null

export interface PlanOptions {
  skip_tests?: boolean
  skip_backfill?: boolean
  no_gaps?: boolean
  forward_only?: boolean
  no_auto_categorization?: boolean
  include_unmodified?: boolean
  create_from?: PlanOptionsCreateFrom
  restate_models?: PlanOptionsRestateModels
  auto_apply?: boolean
}

export type PlanOverviewStageTrackerStart =
  | string
  | string
  | string
  | number
  | number
  | null

export type PlanOverviewStageTrackerEnd =
  | string
  | string
  | string
  | number
  | number
  | null

export type PlanOverviewStageTrackerEnvironment = string | null

export type PlanOverviewStageTrackerPlanOptions = PlanOptions | null

export type PlanOverviewStageTrackerValidation = PlanStageValidation | null

export type PlanOverviewStageTrackerChanges = PlanStageChanges | null

export type PlanOverviewStageTrackerBackfills = PlanStageBackfills | null

export interface PlanOverviewStageTracker {
  start?: PlanOverviewStageTrackerStart
  end?: PlanOverviewStageTrackerEnd
  meta?: TrackableMeta
  environment?: PlanOverviewStageTrackerEnvironment
  plan_options?: PlanOverviewStageTrackerPlanOptions
  validation?: PlanOverviewStageTrackerValidation
  changes?: PlanOverviewStageTrackerChanges
  backfills?: PlanOverviewStageTrackerBackfills
}

export type PlanStageBackfillTasks = { [key: string]: BackfillTask }

export interface PlanStageBackfill {
  meta?: TrackableMeta
  queue?: string[]
  tasks?: PlanStageBackfillTasks
}

export type PlanStageBackfillsModels = BackfillDetails[] | null

export interface PlanStageBackfills {
  meta?: TrackableMeta
  models?: PlanStageBackfillsModels
}

export interface PlanStageCancel {
  meta?: TrackableMeta
}

export type PlanStageChangesAdded = ChangeDisplay[] | null

export type PlanStageChangesRemoved = ChangeDisplay[] | null

export type PlanStageChangesModified = ModelsDiff | null

export interface PlanStageChanges {
  added?: PlanStageChangesAdded
  removed?: PlanStageChangesRemoved
  modified?: PlanStageChangesModified
  meta?: TrackableMeta
}

export interface PlanStageCreation {
  meta?: TrackableMeta
  total_tasks: number
  num_tasks: number
}

export interface PlanStagePromote {
  meta?: TrackableMeta
  total_tasks: number
  num_tasks: number
  target_environment: string
}

export interface PlanStageRestate {
  meta?: TrackableMeta
}

export interface PlanStageValidation {
  meta?: TrackableMeta
}

export interface Query {
  sql: string
}

export interface Reference {
  name: string
  expression: string
  unique: boolean
}

export type RenderInputStart = string | string | string | number | number | null

export type RenderInputEnd = string | string | string | number | number | null

export type RenderInputExecutionTime =
  | string
  | string
  | string
  | number
  | number
  | null

export type RenderInputExpand = boolean | string[]

export type RenderInputDialect = string | null

export interface RenderInput {
  model: string
  start?: RenderInputStart
  end?: RenderInputEnd
  execution_time?: RenderInputExecutionTime
  expand?: RenderInputExpand
  pretty?: boolean
  dialect?: RenderInputDialect
}

export type RowDiffStats = { [key: string]: number }

export type RowDiffSample = { [key: string]: unknown }

export interface RowDiff {
  source: string
  target: string
  stats: RowDiffStats
  sample: RowDiffSample
  source_count: number
  target_count: number
  count_pct_change: number
}

export type SchemaDiffSourceSchema = { [key: string]: string }

export type SchemaDiffTargetSchema = { [key: string]: string }

export type SchemaDiffAdded = { [key: string]: string }

export type SchemaDiffRemoved = { [key: string]: string }

export type SchemaDiffModified = { [key: string]: string }

export interface SchemaDiff {
  source: string
  target: string
  source_schema: SchemaDiffSourceSchema
  target_schema: SchemaDiffTargetSchema
  added: SchemaDiffAdded
  removed: SchemaDiffRemoved
  modified: SchemaDiffModified
}

/**
 * Values are ordered by decreasing severity and that ordering is required.

BREAKING: The change requires that snapshot modified and downstream dependencies be rebuilt
NON_BREAKING: The change requires that only the snapshot modified be rebuilt
FORWARD_ONLY: The change requires no rebuilding
INDIRECT_BREAKING: The change was caused indirectly and is breaking.
INDIRECT_NON_BREAKING: The change was caused indirectly by a non-breaking change.
METADATA: The change was caused by a metadata update.
 */
export type SnapshotChangeCategory =
  (typeof SnapshotChangeCategory)[keyof typeof SnapshotChangeCategory]

// eslint-disable-next-line @typescript-eslint/no-redeclare
export const SnapshotChangeCategory = {
  NUMBER_1: 1,
  NUMBER_2: 2,
  NUMBER_3: 3,
  NUMBER_4: 4,
  NUMBER_5: 5,
  NUMBER_6: 6,
} as const

/**
 * An enumeration of statuses.
 */
export type Status = (typeof Status)[keyof typeof Status]

// eslint-disable-next-line @typescript-eslint/no-redeclare
export const Status = {
  init: 'init',
  success: 'success',
  fail: 'fail',
} as const

export interface TableDiff {
  schema_diff: SchemaDiff
  row_diff: RowDiff
  on: string[][]
}

export interface TestCase {
  name: string
  path: string
}

export interface TestErrorOrFailure {
  name: string
  path: string
  tb: string
}

export interface TestResult {
  tests_run: number
  failures: TestErrorOrFailure[]
  errors: TestErrorOrFailure[]
  skipped: TestSkipped[]
  successes: TestCase[]
}

export interface TestSkipped {
  name: string
  path: string
  reason: string
}

export type TrackableMetaEnd = number | null

export interface TrackableMeta {
  status?: Status
  start?: number
  end?: TrackableMetaEnd
  done?: boolean
}

export type ValidationErrorLocItem = string | number

export interface ValidationError {
  loc: ValidationErrorLocItem[]
  msg: string
  type: string
}

/**
 * Verbosity levels for SQLMesh output.
 */
export type Verbosity = (typeof Verbosity)[keyof typeof Verbosity]

// eslint-disable-next-line @typescript-eslint/no-redeclare
export const Verbosity = {
  NUMBER_0: 0,
  NUMBER_1: 1,
  NUMBER_2: 2,
} as const

export type InitiateApplyApiCommandsApplyPost200 = PlanApplyStageTracker | null

export type TestApiCommandsTestGetParams = {
  test?: string | null
  verbosity?: Verbosity
}

export type WriteFileApiFilesPathPost200 = File | null

export type InitiatePlanApiPlanPost200 = PlanOverviewStageTracker | null

export type CancelPlanApiPlanCancelPost200 = PlanCancelStageTracker | null

export type ColumnLineageApiLineageModelNameColumnNameGetParams = {
  models_only?: boolean
}

export type ColumnLineageApiLineageModelNameColumnNameGet200 = {
  [key: string]: { [key: string]: LineageColumn }
}

export type ModelLineageApiLineageModelNameGet200 = { [key: string]: string[] }

export type GetModelsApiModelsGet200 = Model[] | ApiExceptionPayload

export type GetTableDiffApiTableDiffGetParams = {
  source: string
  target: string
  on?: string | null
  model_or_snapshot?: string | null
  where?: string | null
  temp_schema?: string | null
  limit?: number
}

export type GetTableDiffApiTableDiffGet200 = TableDiff | null

type SecondParameter<T extends (...args: never) => unknown> = Parameters<T>[1]

/**
 * Apply a plan
 * @summary Initiate Apply
 */
export const initiateApplyApiCommandsApplyPost = (
  bodyInitiateApplyApiCommandsApplyPost: BodyInitiateApplyApiCommandsApplyPost,
  options?: SecondParameter<typeof fetchAPI>,
) => {
  return fetchAPI<InitiateApplyApiCommandsApplyPost200>(
    {
      url: `/api/commands/apply`,
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      data: bodyInitiateApplyApiCommandsApplyPost,
    },
    options,
  )
}

/**
 * Evaluate a model with a default limit of 1000
 * @summary Evaluate
 */
export const evaluateApiCommandsEvaluatePost = (
  evaluateInput: EvaluateInput,
  options?: SecondParameter<typeof fetchAPI>,
) => {
  return fetchAPI<unknown>(
    {
      url: `/api/commands/evaluate`,
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      data: evaluateInput,
    },
    options,
  )
}

/**
 * Fetches a dataframe given a sql string
 * @summary Fetchdf
 */
export const fetchdfApiCommandsFetchdfPost = (
  fetchdfInput: FetchdfInput,
  options?: SecondParameter<typeof fetchAPI>,
) => {
  return fetchAPI<unknown>(
    {
      url: `/api/commands/fetchdf`,
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      data: fetchdfInput,
    },
    options,
  )
}

/**
 * Renders a model's query, optionally expanding referenced models
 * @summary Render
 */
export const renderApiCommandsRenderPost = (
  renderInput: RenderInput,
  options?: SecondParameter<typeof fetchAPI>,
) => {
  return fetchAPI<Query>(
    {
      url: `/api/commands/render`,
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      data: renderInput,
    },
    options,
  )
}

/**
 * Run one or all model tests
 * @summary Test
 */
export const testApiCommandsTestGet = (
  params?: TestApiCommandsTestGetParams,
  options?: SecondParameter<typeof fetchAPI>,
) => {
  return fetchAPI<TestResult>(
    { url: `/api/commands/test`, method: 'GET', params },
    options,
  )
}

/**
 * Get all project files.
 * @summary Get Files
 */
export const getFilesApiFilesGet = (
  options?: SecondParameter<typeof fetchAPI>,
) => {
  return fetchAPI<Directory>({ url: `/api/files`, method: 'GET' }, options)
}

/**
 * Get a file, including its contents.
 * @summary Get File
 */
export const getFileApiFilesPathGet = (
  path: string,
  options?: SecondParameter<typeof fetchAPI>,
) => {
  return fetchAPI<File>({ url: `/api/files/${path}`, method: 'GET' }, options)
}

/**
 * Create, update, or rename a file.
 * @summary Write File
 */
export const writeFileApiFilesPathPost = (
  path: string,
  bodyWriteFileApiFilesPathPost: BodyWriteFileApiFilesPathPost,
  options?: SecondParameter<typeof fetchAPI>,
) => {
  return fetchAPI<WriteFileApiFilesPathPost200>(
    {
      url: `/api/files/${path}`,
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      data: bodyWriteFileApiFilesPathPost,
    },
    options,
  )
}

/**
 * Delete a file.
 * @summary Delete File
 */
export const deleteFileApiFilesPathDelete = (
  path: string,
  options?: SecondParameter<typeof fetchAPI>,
) => {
  return fetchAPI<null>(
    { url: `/api/files/${path}`, method: 'DELETE' },
    options,
  )
}

/**
 * Create or rename a directory.
 * @summary Write Directory
 */
export const writeDirectoryApiDirectoriesPathPost = (
  path: string,
  bodyWriteDirectoryApiDirectoriesPathPost: BodyWriteDirectoryApiDirectoriesPathPost,
  options?: SecondParameter<typeof fetchAPI>,
) => {
  return fetchAPI<Directory>(
    {
      url: `/api/directories/${path}`,
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      data: bodyWriteDirectoryApiDirectoriesPathPost,
    },
    options,
  )
}

/**
 * Delete a directory.
 * @summary Delete Directory
 */
export const deleteDirectoryApiDirectoriesPathDelete = (
  path: string,
  options?: SecondParameter<typeof fetchAPI>,
) => {
  return fetchAPI<unknown>(
    { url: `/api/directories/${path}`, method: 'DELETE' },
    options,
  )
}

/**
 * Get a plan for an environment.
 * @summary Initiate Plan
 */
export const initiatePlanApiPlanPost = (
  bodyInitiatePlanApiPlanPost: BodyInitiatePlanApiPlanPost,
  options?: SecondParameter<typeof fetchAPI>,
) => {
  return fetchAPI<InitiatePlanApiPlanPost200>(
    {
      url: `/api/plan`,
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      data: bodyInitiatePlanApiPlanPost,
    },
    options,
  )
}

/**
 * Cancel a plan application
 * @summary Cancel Plan
 */
export const cancelPlanApiPlanCancelPost = (
  options?: SecondParameter<typeof fetchAPI>,
) => {
  return fetchAPI<CancelPlanApiPlanCancelPost200>(
    { url: `/api/plan/cancel`, method: 'POST' },
    options,
  )
}

/**
 * Get the environments
 * @summary Get Environments
 */
export const getEnvironmentsApiEnvironmentsGet = (
  options?: SecondParameter<typeof fetchAPI>,
) => {
  return fetchAPI<Environments>(
    { url: `/api/environments`, method: 'GET' },
    options,
  )
}

/**
 * Invalidate and delete an environment
 * @summary Delete Environment
 */
export const deleteEnvironmentApiEnvironmentsEnvironmentDelete = (
  environment: string,
  options?: SecondParameter<typeof fetchAPI>,
) => {
  return fetchAPI<unknown>(
    { url: `/api/environments/${environment}`, method: 'DELETE' },
    options,
  )
}

/**
 * SQLMesh console server sent events
 * @summary Events
 */
export const eventsApiEventsGet = (
  options?: SecondParameter<typeof fetchAPI>,
) => {
  return fetchAPI<unknown>({ url: `/api/events`, method: 'GET' }, options)
}

/**
 * Get a column's lineage
 * @summary Column Lineage
 */
export const columnLineageApiLineageModelNameColumnNameGet = (
  modelName: string,
  columnName: string,
  params?: ColumnLineageApiLineageModelNameColumnNameGetParams,
  options?: SecondParameter<typeof fetchAPI>,
) => {
  return fetchAPI<ColumnLineageApiLineageModelNameColumnNameGet200>(
    { url: `/api/lineage/${modelName}/${columnName}`, method: 'GET', params },
    options,
  )
}

/**
 * Get a model's lineage
 * @summary Model Lineage
 */
export const modelLineageApiLineageModelNameGet = (
  modelName: string,
  options?: SecondParameter<typeof fetchAPI>,
) => {
  return fetchAPI<ModelLineageApiLineageModelNameGet200>(
    { url: `/api/lineage/${modelName}`, method: 'GET' },
    options,
  )
}

/**
 * Get a list of models
 * @summary Get Models
 */
export const getModelsApiModelsGet = (
  options?: SecondParameter<typeof fetchAPI>,
) => {
  return fetchAPI<GetModelsApiModelsGet200>(
    { url: `/api/models`, method: 'GET' },
    options,
  )
}

/**
 * Get a single model
 * @summary Get Model
 */
export const getModelApiModelsNameGet = (
  name: string,
  options?: SecondParameter<typeof fetchAPI>,
) => {
  return fetchAPI<Model>({ url: `/api/models/${name}`, method: 'GET' }, options)
}

/**
 * Get the metadata
 * @summary Get Api Meta
 */
export const getApiMetaApiMetaGet = (
  options?: SecondParameter<typeof fetchAPI>,
) => {
  return fetchAPI<Meta>({ url: `/api/meta`, method: 'GET' }, options)
}

/**
 * Get the modules
 * @summary Get Api Modules
 */
export const getApiModulesApiModulesGet = (
  options?: SecondParameter<typeof fetchAPI>,
) => {
  return fetchAPI<Modules[]>({ url: `/api/modules`, method: 'GET' }, options)
}

/**
 * Calculate differences between tables, taking into account schema and row level differences.
 * @summary Get Table Diff
 */
export const getTableDiffApiTableDiffGet = (
  params: GetTableDiffApiTableDiffGetParams,
  options?: SecondParameter<typeof fetchAPI>,
) => {
  return fetchAPI<GetTableDiffApiTableDiffGet200>(
    { url: `/api/table_diff`, method: 'GET', params },
    options,
  )
}

/**
 * @summary Health
 */
export const healthHealthGet = (options?: SecondParameter<typeof fetchAPI>) => {
  return fetchAPI<string>({ url: `/health`, method: 'GET' }, options)
}

/**
 * @summary Index
 */
export const indexFullPathGet = (
  fullPath: string,
  options?: SecondParameter<typeof fetchAPI>,
) => {
  return fetchAPI<unknown>({ url: `/${fullPath}`, method: 'GET' }, options)
}

export type InitiateApplyApiCommandsApplyPostResult = NonNullable<
  Awaited<ReturnType<typeof initiateApplyApiCommandsApplyPost>>
>
export type EvaluateApiCommandsEvaluatePostResult = NonNullable<
  Awaited<ReturnType<typeof evaluateApiCommandsEvaluatePost>>
>
export type FetchdfApiCommandsFetchdfPostResult = NonNullable<
  Awaited<ReturnType<typeof fetchdfApiCommandsFetchdfPost>>
>
export type RenderApiCommandsRenderPostResult = NonNullable<
  Awaited<ReturnType<typeof renderApiCommandsRenderPost>>
>
export type TestApiCommandsTestGetResult = NonNullable<
  Awaited<ReturnType<typeof testApiCommandsTestGet>>
>
export type GetFilesApiFilesGetResult = NonNullable<
  Awaited<ReturnType<typeof getFilesApiFilesGet>>
>
export type GetFileApiFilesPathGetResult = NonNullable<
  Awaited<ReturnType<typeof getFileApiFilesPathGet>>
>
export type WriteFileApiFilesPathPostResult = NonNullable<
  Awaited<ReturnType<typeof writeFileApiFilesPathPost>>
>
export type DeleteFileApiFilesPathDeleteResult = NonNullable<
  Awaited<ReturnType<typeof deleteFileApiFilesPathDelete>>
>
export type WriteDirectoryApiDirectoriesPathPostResult = NonNullable<
  Awaited<ReturnType<typeof writeDirectoryApiDirectoriesPathPost>>
>
export type DeleteDirectoryApiDirectoriesPathDeleteResult = NonNullable<
  Awaited<ReturnType<typeof deleteDirectoryApiDirectoriesPathDelete>>
>
export type InitiatePlanApiPlanPostResult = NonNullable<
  Awaited<ReturnType<typeof initiatePlanApiPlanPost>>
>
export type CancelPlanApiPlanCancelPostResult = NonNullable<
  Awaited<ReturnType<typeof cancelPlanApiPlanCancelPost>>
>
export type GetEnvironmentsApiEnvironmentsGetResult = NonNullable<
  Awaited<ReturnType<typeof getEnvironmentsApiEnvironmentsGet>>
>
export type DeleteEnvironmentApiEnvironmentsEnvironmentDeleteResult =
  NonNullable<
    Awaited<
      ReturnType<typeof deleteEnvironmentApiEnvironmentsEnvironmentDelete>
    >
  >
export type EventsApiEventsGetResult = NonNullable<
  Awaited<ReturnType<typeof eventsApiEventsGet>>
>
export type ColumnLineageApiLineageModelNameColumnNameGetResult = NonNullable<
  Awaited<ReturnType<typeof columnLineageApiLineageModelNameColumnNameGet>>
>
export type ModelLineageApiLineageModelNameGetResult = NonNullable<
  Awaited<ReturnType<typeof modelLineageApiLineageModelNameGet>>
>
export type GetModelsApiModelsGetResult = NonNullable<
  Awaited<ReturnType<typeof getModelsApiModelsGet>>
>
export type GetModelApiModelsNameGetResult = NonNullable<
  Awaited<ReturnType<typeof getModelApiModelsNameGet>>
>
export type GetApiMetaApiMetaGetResult = NonNullable<
  Awaited<ReturnType<typeof getApiMetaApiMetaGet>>
>
export type GetApiModulesApiModulesGetResult = NonNullable<
  Awaited<ReturnType<typeof getApiModulesApiModulesGet>>
>
export type GetTableDiffApiTableDiffGetResult = NonNullable<
  Awaited<ReturnType<typeof getTableDiffApiTableDiffGet>>
>
export type HealthHealthGetResult = NonNullable<
  Awaited<ReturnType<typeof healthHealthGet>>
>
export type IndexFullPathGetResult = NonNullable<
  Awaited<ReturnType<typeof indexFullPathGet>>
>
