from pydantic import Field, model_validator
from typing import Annotated, Generic, Self
from maleo.schemas.mixins.identity import Passport as BasePassport
from maleo.types.string import OptStr, OptStrT
from .common import IdCard


class Passport(BasePassport, Generic[OptStrT]):
    passport: Annotated[OptStrT, Field(..., description="Passport", max_length=9)]


class PatientIdentifier(
    Passport[OptStr],
    IdCard[OptStr],
):
    @model_validator(mode="after")
    def chk_id_card_or_passport(self) -> Self:
        if self.id_card is None and self.passport is None:
            raise ValueError("Either ID Card or Passport must exist")
        return self
