import bluesky.plan_stubs as bps
import pytest
from bluesky import RunEngine

from dodal.devices.i24.focus_mirrors import FocusMirrorsMode, HFocusMode, VFocusMode


@pytest.fixture
async def fake_mirrors() -> FocusMirrorsMode:
    mirrors = FocusMirrorsMode("", name="fake_morrors")
    await mirrors.connect(mock=True)

    return mirrors


async def test_setting_mirror_focus_returns_correct_beam_size(
    fake_mirrors: FocusMirrorsMode, run_engine: RunEngine
):
    def set_mirrors():
        yield from bps.abs_set(
            fake_mirrors.horizontal, HFocusMode.FOCUS_3010D, wait=True
        )
        yield from bps.abs_set(fake_mirrors.vertical, VFocusMode.FOCUS_3010D, wait=True)

    run_engine(set_mirrors())

    assert await fake_mirrors.beam_size_x.get_value() == 30
    assert await fake_mirrors.beam_size_y.get_value() == 10
