from ophyd_async.core import init_devices
from ophyd_async.testing import assert_reading, partial_reading

from dodal.devices.baton import Baton


async def test_mock_baton_can_be_initialised_and_read():
    with init_devices(mock=True):
        baton = Baton("")
    await assert_reading(
        baton,
        {
            "baton-current_user": partial_reading(""),
            "baton-requested_user": partial_reading(""),
            "baton-commissioning": partial_reading(False),
        },
    )
