# -*- coding: utf-8 -*-

"""Translation strings extracted from the legacy JSON configuration.

This module exposes the `LANGUAGE_SETTINGS` dictionary used across the project.
"""

LANGUAGE_SETTINGS = {
    "EN": {
        "info": "Info",
        "cusp": "Cusp",
        "longitude": "Longitude",
        "latitude": "Latitude",
        "north": "North",
        "east": "East",
        "south": "South",
        "west": "West",
        "fire": "Fire",
        "earth": "Earth",
        "air": "Air",
        "water": "Water",
        "and_word": "and",
        "transits": "Transits for",
        "type": "Type",
        "couple_aspects": "Couple aspects",
        "transit_aspects": "Transit aspects",
        "planets_and_house": "Points for",
        "transit_name": "At the time of the transit",
        "lunar_phase": "Lunar phase",
        "lunation_day": "Lunation Day",
        "day": "Day",
        "composite_chart": "Composite Chart",
        "midpoints": "Midpoints",
        "north_letter": "N",
        "east_letter": "E",
        "south_letter": "S",
        "west_letter": "W",
        "tropical": "Tropical",
        "sidereal": "Sidereal",
        "zodiac": "Zodiac",
        "ayanamsa": "Ayanamsa",
        "apparent_geocentric": "Apparent Geocentric",
        "heliocentric": "Heliocentric",
        "topocentric": "Topocentric",
        "true_geocentric": "True Geocentric",
        "new_moon": "New Moon",
        "waxing_crescent": "Waxing Crescent",
        "first_quarter": "First Quarter",
        "waxing_gibbous": "Waxing Gibbous",
        "full_moon": "Full Moon",
        "waning_gibbous": "Waning Gibbous",
        "last_quarter": "Last Quarter",
        "waning_crescent": "Waning Crescent",
        "houses": "Houses",
        "domification": "Domification",
        "houses_system_A": "Equal",
        "houses_system_B": "Alcabitius",
        "houses_system_C": "Campanus",
        "houses_system_D": "Equal (MC)",
        "houses_system_F": "Carter poli-equ.",
        "houses_system_H": "Horizon/Azimut",
        "houses_system_I": "Sunshine",
        "houses_system_i": "Sunshine/alt.",
        "houses_system_K": "Koch",
        "houses_system_L": "Pullen SD",
        "houses_system_M": "Morinus",
        "houses_system_N": "Equal/1=Aries",
        "houses_system_O": "Porphyry",
        "houses_system_P": "Placidus",
        "houses_system_Q": "Pullen SR",
        "houses_system_R": "Regiomontanus",
        "houses_system_S": "Sripati",
        "houses_system_T": "Polich/Page",
        "houses_system_U": "Krusinski-Pisa-Goelzer",
        "houses_system_V": "Equal/Vehlow",
        "houses_system_W": "Equal/Whole sign",
        "houses_system_X": "Axial rotation system/Meridian houses",
        "houses_system_Y": "APC houses",
        "Natal": "Natal",
        "ExternalNatal": "External Natal",
        "Synastry": "Synastry",
        "Transit": "Transit",
        "Composite": "Composite",
        "solar_return": "Solar Return",
        "lunar_return": "Lunar Return",
        "return_aspects": "Natal-Return Aspects",
        "inner_wheel": "Inner Wheel",
        "outer_wheel": "Outer Wheel",
        "house_position_comparison": "House Position Comparison",
        "return_point": "Return Point",
        "Return": "Return",
        "natal": "Natal",
        "perspective_type": "Perspective",
        "location": "Location",
        "day_of_week": "Day of Week",
        "weekdays": {
            "Monday": "Monday",
            "Tuesday": "Tuesday",
            "Wednesday": "Wednesday",
            "Thursday": "Thursday",
            "Friday": "Friday",
            "Saturday": "Saturday",
            "Sunday": "Sunday",
        },
        "elements": "Elements",
        "qualities": "Qualities",
        "cardinal": "Cardinal",
        "fixed": "Fixed",
        "mutable": "Mutable",
        "birth_chart": "Birth Chart",
        "celestial_points": {
            "Sun": "Sun",
            "Moon": "Moon",
            "Mercury": "Mercury",
            "Venus": "Venus",
            "Mars": "Mars",
            "Jupiter": "Jupiter",
            "Saturn": "Saturn",
            "Uranus": "Uranus",
            "Neptune": "Neptune",
            "Pluto": "Pluto",
            "Ascendant": "Asc",
            "Medium_Coeli": "Mc",
            "Descendant": "Dsc",
            "Imum_Coeli": "Ic",
            "True_North_Lunar_Node": "N. Node (T)",
            "Mean_North_Lunar_Node": "N. Node (M)",
            "Chiron": "Chiron",
            "Mean_Lilith": "Lilith",
            "True_South_Lunar_Node": "S. Node (T)",
            "Mean_South_Lunar_Node": "S. Node (M)",
            "True_Lilith": "Lilith (T)",
            "Earth": "Earth",
            "Pholus": "Pholus",
            "Ceres": "Ceres",
            "Pallas": "Pallas",
            "Juno": "Juno",
            "Vesta": "Vesta",
            "Eris": "Eris",
            "Sedna": "Sedna",
            "Haumea": "Haumea",
            "Makemake": "Makemake",
            "Ixion": "Ixion",
            "Orcus": "Orcus",
            "Quaoar": "Quaoar",
            "Regulus": "Regulus",
            "Spica": "Spica",
            "Pars_Fortunae": "Part of Fortune",
            "Pars_Spiritus": "Part of Spirit",
            "Pars_Amoris": "Part of Love",
            "Pars_Fidei": "Part of Faith",
            "Vertex": "Vertex",
            "Anti_Vertex": "Anti-Vertex",
        },
    },
    "FR": {
        "info": "Informations",
        "cusp": "Maison",
        "longitude": "Longitude",
        "latitude": "Latitude",
        "north": "Nord",
        "east": "Est",
        "south": "Sud",
        "west": "Ouest",
        "fire": "Feu",
        "earth": "Terre",
        "air": "Air",
        "water": "Eau",
        "and_word": "et",
        "transits": "Transites pour",
        "type": "Type",
        "couple_aspects": "Les aspects",
        "transit_aspects": "Les aspects de transit",
        "planets_and_house": "Points pour",
        "transit_name": "Au moment de la transition",
        "lunar_phase": "Phase Lunaire",
        "lunation_day": "Jour de Lunaison",
        "day": "Jour",
        "composite_chart": "Carte Composite",
        "midpoints": "Milieux",
        "north_letter": "N",
        "east_letter": "E",
        "south_letter": "S",
        "west_letter": "W",
        "tropical": "Tropical",
        "sidereal": "Sidéral",
        "zodiac": "Zodiaque",
        "ayanamsa": "Ayanamsa",
        "apparent_geocentric": "Géocentrique Apparent",
        "heliocentric": "Héliocentrique",
        "topocentric": "Topocentrique",
        "true_geocentric": "Géocentrique Vrai",
        "new_moon": "Nouvelle Lune",
        "waxing_crescent": "Premier Croissant",
        "first_quarter": "Premier Quartier",
        "waxing_gibbous": "Lune Gibbeuse Croissante",
        "full_moon": "Pleine Lune",
        "waning_gibbous": "Lune Gibbeuse Décroissante",
        "last_quarter": "Dernier Quartier",
        "waning_crescent": "Dernier Croissant",
        "houses": "Maisons",
        "domification": "Domification",
        "houses_system_A": "Égales",
        "houses_system_B": "Alcabitius",
        "houses_system_C": "Campanus",
        "houses_system_D": "Égales (MC)",
        "houses_system_F": "Carter poli-equ.",
        "houses_system_H": "Horizon/Azimut",
        "houses_system_I": "Sunshine",
        "houses_system_i": "Sunshine/alt.",
        "houses_system_K": "Koch",
        "houses_system_L": "Pullen SD",
        "houses_system_M": "Morinus",
        "houses_system_N": "Égales/1=Bélier",
        "houses_system_O": "Porphyre",
        "houses_system_P": "Placidus",
        "houses_system_Q": "Pullen SR",
        "houses_system_R": "Regiomontanus",
        "houses_system_S": "Sripati",
        "houses_system_T": "Polich/Page",
        "houses_system_U": "Krusinski-Pisa-Goelzer",
        "houses_system_V": "Égales/Vehlow",
        "houses_system_W": "Égales/Signe entier",
        "houses_system_X": "Système de rotation axiale/Maisons méridiennes",
        "houses_system_Y": "Maisons APC",
        "Natal": "Natal",
        "ExternalNatal": "Natal Externe",
        "Synastry": "Synastrie",
        "Transit": "Transit",
        "Composite": "Composite",
        "solar_return": "Retour Solaire",
        "lunar_return": "Retour Lunaire",
        "return_aspects": "Aspects natal-retour",
        "inner_wheel": "Cercle intérieur",
        "outer_wheel": "Cercle extérieur",
        "house_position_comparison": "Comparaison des positions en maisons",
        "return_point": "Point (rév.)",
        "Return": "Révolution",
        "natal": "Radix",
        "perspective_type": "Perspective",
        "location": "Lieu",
        "day_of_week": "Jour de la semaine",
        "weekdays": {
            "Monday": "Lundi",
            "Tuesday": "Mardi",
            "Wednesday": "Mercredi",
            "Thursday": "Jeudi",
            "Friday": "Vendredi",
            "Saturday": "Samedi",
            "Sunday": "Dimanche",
        },
        "elements": "Éléments",
        "qualities": "Qualités",
        "cardinal": "Cardinal",
        "fixed": "Fixe",
        "mutable": "Mutable",
        "birth_chart": "Thème Natal",
        "celestial_points": {
            "Sun": "Soleil",
            "Moon": "Lune",
            "Mercury": "Mercure",
            "Venus": "Vénus",
            "Mars": "Mars",
            "Jupiter": "Jupiter",
            "Saturn": "Saturne",
            "Uranus": "Uranus",
            "Neptune": "Neptune",
            "Pluto": "Pluton",
            "Ascendant": "Asc",
            "Medium_Coeli": "Mc",
            "Descendant": "Dsc",
            "Imum_Coeli": "Ic",
            "True_North_Lunar_Node": "Nœud N. (V)",
            "Mean_North_Lunar_Node": "Nœud N. (M)",
            "True_South_Lunar_Node": "Nœud S. (V)",
            "Mean_South_Lunar_Node": "Nœud S. (M)",
            "Chiron": "Chiron",
            "Mean_Lilith": "Lilith",
            "True_Lilith": "Lilith (V)",
            "Earth": "Terre",
            "Pholus": "Pholus",
            "Ceres": "Cérès",
            "Pallas": "Pallas",
            "Juno": "Junon",
            "Vesta": "Vesta",
            "Eris": "Eris",
            "Sedna": "Sedna",
            "Haumea": "Haumea",
            "Makemake": "Makemake",
            "Ixion": "Ixion",
            "Orcus": "Orcus",
            "Quaoar": "Quaoar",
            "Regulus": "Regulus",
            "Spica": "Spica",
            "Pars_Fortunae": "Pars Fortunae",
            "Pars_Spiritus": "Pars Spiritus",
            "Pars_Amoris": "Pars Amoris",
            "Pars_Fidei": "Pars Fidei",
            "Vertex": "Vertex",
            "Anti_Vertex": "Anti-Vertex",
        },
    },
    "PT": {
        "info": "Informações",
        "cusp": "Casa",
        "longitude": "Longitude",
        "latitude": "Latitude",
        "north": "Norte",
        "east": "Leste",
        "south": "Sul",
        "west": "Oeste",
        "fire": "Fogo",
        "earth": "Terra",
        "air": "Ar",
        "water": "Água",
        "and_word": "e",
        "transits": "Trânsitos para",
        "type": "Tipo",
        "couple_aspects": "Aspectos do casal",
        "transit_aspects": "Aspectos do trânsito",
        "planets_and_house": "Pontos para",
        "transit_name": "No momento do trânsito",
        "lunar_phase": "Fase lunar",
        "lunation_day": "Dia de Lunação",
        "day": "Dia",
        "composite_chart": "Carta Composta",
        "midpoints": "Meios",
        "north_letter": "N",
        "east_letter": "E",
        "south_letter": "S",
        "west_letter": "W",
        "tropical": "Tropical",
        "sidereal": "Sideral",
        "zodiac": "Zodíaco",
        "ayanamsa": "Ayanamsa",
        "apparent_geocentric": "Geocêntrico Aparente",
        "heliocentric": "Heliocêntrico",
        "topocentric": "Topocêntrico",
        "true_geocentric": "Geocêntrico Verdadeiro",
        "new_moon": "Lua Nova",
        "waxing_crescent": "Lua Crescente",
        "first_quarter": "Quarto Crescente",
        "waxing_gibbous": "Lua Gibosa Crescente",
        "full_moon": "Lua Cheia",
        "waning_gibbous": "Lua Gibosa Minguante",
        "last_quarter": "Quarto Minguante",
        "waning_crescent": "Lua Minguante",
        "houses": "Casas",
        "domification": "Domificação",
        "houses_system_A": "Igual",
        "houses_system_B": "Alcabítio",
        "houses_system_C": "Campanus",
        "houses_system_D": "Igual (MC)",
        "houses_system_F": "Carter poli-equ.",
        "houses_system_H": "Horizonte/Azimute",
        "houses_system_I": "Sunshine",
        "houses_system_i": "Sunshine/alt.",
        "houses_system_K": "Koch",
        "houses_system_L": "Pullen SD",
        "houses_system_M": "Morinus",
        "houses_system_N": "Igual/1=Áries",
        "houses_system_O": "Porfírio",
        "houses_system_P": "Placidus",
        "houses_system_Q": "Pullen SR",
        "houses_system_R": "Regiomontanus",
        "houses_system_S": "Sripati",
        "houses_system_T": "Polich/Page",
        "houses_system_U": "Krusinski-Pisa-Goelzer",
        "houses_system_V": "Igual/Vehlow",
        "houses_system_W": "Igual/Signo inteiro",
        "houses_system_X": "Sistema de rotação axial/Casas meridianas",
        "houses_system_Y": "Casas APC",
        "Natal": "Natal",
        "ExternalNatal": "Natal Externo",
        "Synastry": "Sinastria",
        "Transit": "Trânsito",
        "Composite": "Composto",
        "Return": "Retorno",
        "solar_return": "Retorno Solar",
        "lunar_return": "Retorno Lunar",
        "return_aspects": "Aspectos do natal para o retorno",
        "inner_wheel": "Roda interna",
        "outer_wheel": "Roda externa",
        "house_position_comparison": "Comparação das posições nas casas",
        "return_point": "Ponto (ret.)",
        "natal": "Natal",
        "perspective_type": "Perspectiva",
        "location": "Localização",
        "day_of_week": "Dia da semana",
        "weekdays": {
            "Monday": "Segunda",
            "Tuesday": "Terça",
            "Wednesday": "Quarta",
            "Thursday": "Quinta",
            "Friday": "Sexta",
            "Saturday": "Sábado",
            "Sunday": "Domingo",
        },
        "elements": "Elementos",
        "qualities": "Qualidades",
        "cardinal": "Cardinal",
        "fixed": "Fixo",
        "mutable": "Mutável",
        "birth_chart": "Mapa Natal",
        "celestial_points": {
            "Sun": "Sol",
            "Moon": "Lua",
            "Mercury": "Mercúrio",
            "Venus": "Vênus",
            "Mars": "Marte",
            "Jupiter": "Júpiter",
            "Saturn": "Saturno",
            "Uranus": "Urano",
            "Neptune": "Netuno",
            "Pluto": "Plutão",
            "Ascendant": "Asc",
            "Medium_Coeli": "Mc",
            "Descendant": "Dsc",
            "Imum_Coeli": "Ic",
            "True_North_Lunar_Node": "Nodo N. (V)",
            "Mean_North_Lunar_Node": "Nodo N. (M)",
            "True_South_Lunar_Node": "Nodo S. (V)",
            "Mean_South_Lunar_Node": "Nodo S. (M)",
            "Chiron": "Quíron",
            "Mean_Lilith": "Lilith",
            "True_Lilith": "Lilith (V)",
            "Earth": "Terra",
            "Pholus": "Pholus",
            "Ceres": "Ceres",
            "Pallas": "Palas",
            "Juno": "Juno",
            "Vesta": "Vesta",
            "Eris": "Éris",
            "Sedna": "Sedna",
            "Haumea": "Haumea",
            "Makemake": "Makemake",
            "Ixion": "Ixion",
            "Orcus": "Orcus",
            "Quaoar": "Quaoar",
            "Regulus": "Régulo",
            "Spica": "Spica",
            "Pars_Fortunae": "Pars Fortunae",
            "Pars_Spiritus": "Pars Spiritus",
            "Pars_Amoris": "Pars Amoris",
            "Pars_Fidei": "Pars Fidei",
            "Vertex": "Vertex",
            "Anti_Vertex": "Anti-Vertex",
        },
    },
    "IT": {
        "info": "Info",
        "cusp": "Cuspide",
        "longitude": "Longitudine",
        "latitude": "Latitudine",
        "north": "Nord",
        "east": "Est",
        "south": "Sud",
        "west": "Ovest",
        "fire": "Fuoco",
        "earth": "Terra",
        "air": "Aria",
        "water": "Acqua",
        "and_word": "e",
        "transits": "Transiti per",
        "type": "Tipo",
        "couple_aspects": "Aspetti di coppia",
        "transit_aspects": "Aspetti di transito",
        "planets_and_house": "Punti per",
        "transit_name": "Al momento del transito",
        "lunar_phase": "Fase lunare",
        "lunation_day": "Giorno di Lunazione",
        "day": "Giorno",
        "composite_chart": "Tema Composito",
        "midpoints": "Punti Medi",
        "north_letter": "N",
        "east_letter": "E",
        "south_letter": "S",
        "west_letter": "W",
        "tropical": "Tropicale",
        "sidereal": "Siderale",
        "zodiac": "Zodiaco",
        "ayanamsa": "Ayanamsa",
        "apparent_geocentric": "Geocentrico Apparente",
        "heliocentric": "Eliocentrico",
        "topocentric": "Topocentrico",
        "true_geocentric": "Geocentrico Vero",
        "new_moon": "Luna Nuova",
        "waxing_crescent": "Luna Crescente",
        "first_quarter": "Primo Quarto",
        "waxing_gibbous": "Gibbosa Crescente",
        "full_moon": "Luna Piena",
        "waning_gibbous": "Gibbosa Calante",
        "last_quarter": "Ultimo Quarto",
        "waning_crescent": "Luna Calante",
        "houses": "Domificazione",
        "domification": "Domificazione",
        "houses_system_A": "Uguale",
        "houses_system_B": "Alcabizio",
        "houses_system_C": "Campano",
        "houses_system_D": "Uguale (MC)",
        "houses_system_F": "Carter poli-equ.",
        "houses_system_H": "Orizzonte/Azimut",
        "houses_system_I": "Sunshine",
        "houses_system_i": "Sunshine/alt.",
        "houses_system_K": "Koch",
        "houses_system_L": "Pullen SD",
        "houses_system_M": "Morinus",
        "houses_system_N": "Uguale/1=Ariete",
        "houses_system_O": "Porfirio",
        "houses_system_P": "Placido",
        "houses_system_Q": "Pullen SR",
        "houses_system_R": "Regiomontano",
        "houses_system_S": "Sripati",
        "houses_system_T": "Polich/Page",
        "houses_system_U": "Krusinski-Pisa-Goelzer",
        "houses_system_V": "Uguale/Vehlow",
        "houses_system_W": "Uguale/Segno intero",
        "houses_system_X": "Sistema di rotazione assiale/Case meridiane",
        "houses_system_Y": "Case APC",
        "Natal": "Natale",
        "ExternalNatal": "Natale Esterno",
        "Synastry": "Sinastria",
        "Transit": "Transito",
        "Composite": "Composito",
        "solar_return": "Ritorno Solare",
        "lunar_return": "Ritorno Lunare",
        "return_aspects": "Aspetti tra Tema Natale e Ritorno Solare",
        "inner_wheel": "Cerchio Interno",
        "outer_wheel": "Cerchio Esterno",
        "house_position_comparison": "Confronto posizioni nelle case",
        "return_point": "Punto del rit.",
        "Return": "Ritorno",
        "natal": "Radix",
        "perspective_type": "Prospettiva",
        "location": "Località",
        "day_of_week": "Giorno della settimana",
        "weekdays": {
            "Monday": "Lunedì",
            "Tuesday": "Martedì",
            "Wednesday": "Mercoledì",
            "Thursday": "Giovedì",
            "Friday": "Venerdì",
            "Saturday": "Sabato",
            "Sunday": "Domenica",
        },
        "elements": "Elementi",
        "qualities": "Qualità",
        "cardinal": "Cardinale",
        "fixed": "Fisso",
        "mutable": "Mutevole",
        "birth_chart": "Tema Natale",
        "celestial_points": {
            "Sun": "Sole",
            "Moon": "Luna",
            "Mercury": "Mercurio",
            "Venus": "Venere",
            "Mars": "Marte",
            "Jupiter": "Giove",
            "Saturn": "Saturno",
            "Uranus": "Urano",
            "Neptune": "Nettuno",
            "Pluto": "Plutone",
            "Ascendant": "Asc",
            "Medium_Coeli": "Mc",
            "Descendant": "Dsc",
            "Imum_Coeli": "Ic",
            "True_North_Lunar_Node": "Nodo N. (V)",
            "Mean_North_Lunar_Node": "Nodo N. (M)",
            "True_South_Lunar_Node": "Nodo S. (V)",
            "Mean_South_Lunar_Node": "Nodo S. (M)",
            "Chiron": "Chirone",
            "Mean_Lilith": "Lilith",
            "True_Lilith": "Lilith (V)",
            "Earth": "Terra",
            "Pholus": "Pholus",
            "Ceres": "Cerere",
            "Pallas": "Pallade",
            "Juno": "Giunone",
            "Vesta": "Vesta",
            "Eris": "Eris",
            "Sedna": "Sedna",
            "Haumea": "Haumea",
            "Makemake": "Makemake",
            "Ixion": "Issione",
            "Orcus": "Orco",
            "Quaoar": "Quaoar",
            "Regulus": "Regolo",
            "Spica": "Spica",
            "Pars_Fortunae": "Pars Fortunae",
            "Pars_Spiritus": "Pars Spiritus",
            "Pars_Amoris": "Pars Amoris",
            "Pars_Fidei": "Pars Fidei",
            "Vertex": "Vertex",
            "Anti_Vertex": "Anti-Vertex",
        },
    },
    "CN": {
        "info": "命盤資訊",
        "cusp": "宮",
        "longitude": "經度",
        "latitude": "緯度",
        "north": "北",
        "east": "東",
        "south": "南",
        "west": "西",
        "fire": "火",
        "earth": "土",
        "air": "風",
        "water": "水",
        "and_word": "與",
        "transits": "流年合盤",
        "type": "盤型",
        "couple_aspects": "相位",
        "transit_aspects": "流年相位",
        "planets_and_house": "行星 與 宫位",
        "transit_name": "流年名稱",
        "lunar_phase": "月相",
        "lunation_day": "朔望月日",
        "day": "日",
        "composite_chart": "合盤",
        "midpoints": "中點",
        "north_letter": "北",
        "east_letter": "東",
        "south_letter": "南",
        "west_letter": "西",
        "tropical": "熱帶",
        "sidereal": "恆星",
        "zodiac": "黃道",
        "ayanamsa": "阿揚那姆沙",
        "apparent_geocentric": "視地心",
        "heliocentric": "日心",
        "topocentric": "站心",
        "true_geocentric": "真地心",
        "new_moon": "新月",
        "waxing_crescent": "娥眉月",
        "first_quarter": "上弦月",
        "waxing_gibbous": "盈凸月",
        "full_moon": "滿月",
        "waning_gibbous": "虧凸月",
        "last_quarter": "下弦月",
        "waning_crescent": "殘月",
        "houses": "宮位系統",
        "domification": "宫位划分",
        "houses_system_A": "等宮",
        "houses_system_B": "阿卡比提烏斯",
        "houses_system_C": "坎帕努斯",
        "houses_system_D": "等宮 (MC)",
        "houses_system_F": "卡特極-等",
        "houses_system_H": "地平/方位",
        "houses_system_I": "日照",
        "houses_system_i": "日照/高度",
        "houses_system_K": "科赫",
        "houses_system_L": "普倫 SD",
        "houses_system_M": "莫里努斯",
        "houses_system_N": "等宮/1=白羊",
        "houses_system_O": "波菲里",
        "houses_system_P": "普拉西達斯",
        "houses_system_Q": "普倫 SR",
        "houses_system_R": "雷焦蒙塔努斯",
        "houses_system_S": "斯里帕蒂",
        "houses_system_T": "波利奇/佩奇",
        "houses_system_U": "克魯辛斯基-比薩-戈爾澤",
        "houses_system_V": "等宮/韋洛",
        "houses_system_W": "等宮/整體星座",
        "houses_system_X": "軸向旋轉系統/子午線宮",
        "houses_system_Y": "APC宮位",
        "Natal": "本命盤",
        "ExternalNatal": "外部本命盤",
        "Synastry": "合盤",
        "Transit": "運行",
        "Composite": "合成盤",
        "solar_return": "太陽回歸",
        "lunar_return": "月亮回歸",
        "return_aspects": "本命与回归相位",
        "inner_wheel": "内轮",
        "outer_wheel": "外轮",
        "house_position_comparison": "宫位比较",
        "return_point": "回归点",
        "Return": "回归",
        "natal": "本命",
        "perspective_type": "视角",
        "location": "位置",
        "day_of_week": "星期",
        "weekdays": {
            "Monday": "星期一",
            "Tuesday": "星期二",
            "Wednesday": "星期三",
            "Thursday": "星期四",
            "Friday": "星期五",
            "Saturday": "星期六",
            "Sunday": "星期日",
        },
        "elements": "元素",
        "qualities": "性质",
        "cardinal": "本位",
        "fixed": "固定",
        "mutable": "变动",
        "birth_chart": "出生图",
        "celestial_points": {
            "Sun": "太陽",
            "Moon": "月亮",
            "Mercury": "水星",
            "Venus": "金星",
            "Mars": "火星",
            "Jupiter": "木星",
            "Saturn": "土星",
            "Uranus": "天王星",
            "Neptune": "海王星",
            "Pluto": "冥王星",
            "Ascendant": "上升點",
            "Medium_Coeli": "上中天",
            "Descendant": "下降點",
            "Imum_Coeli": "下中天",
            "True_North_Lunar_Node": "真北交点",
            "Mean_North_Lunar_Node": "平均北交点",
            "True_South_Lunar_Node": "真南交点",
            "Mean_South_Lunar_Node": "平均南交点",
            "Chiron": "凱龍星",
            "Mean_Lilith": "黑月亮",
            "True_Lilith": "真黑月亮",
            "Earth": "地球",
            "Pholus": "福路斯",
            "Ceres": "穀神星",
            "Pallas": "智神星",
            "Juno": "婚神星",
            "Vesta": "灶神星",
            "Eris": "鬩神星",
            "Sedna": "塞德娜",
            "Haumea": "妊神星",
            "Makemake": "鳥神星",
            "Ixion": "伊克西翁",
            "Orcus": "奥库斯",
            "Quaoar": "夸瓦尔",
            "Regulus": "軒轅十四",
            "Spica": "角宿一",
            "Pars_Fortunae": "財富點",
            "Pars_Spiritus": "精神點",
            "Pars_Amoris": "愛情點",
            "Pars_Fidei": "信仰點",
            "Vertex": "命運點",
            "Anti_Vertex": "反命運點",
        },
    },
    "ES": {
        "info": "Información",
        "cusp": "Casa",
        "longitude": "Longitud",
        "latitude": "Latitud",
        "north": "Norte",
        "east": "Este",
        "south": "Sur",
        "west": "Oeste",
        "fire": "Fuego",
        "earth": "Tierra",
        "air": "Aire",
        "water": "Agua",
        "and_word": "y",
        "transits": "Tránsitos para",
        "type": "Tipo",
        "couple_aspects": "Aspectos de la pareja",
        "transit_aspects": "Aspectos de tránsito",
        "planets_and_house": "Puntos para",
        "transit_name": "En el momento del tránsito",
        "lunar_phase": "Fase lunar",
        "lunation_day": "Día de Lunación",
        "day": "Día",
        "composite_chart": "Carta Compuesta",
        "midpoints": "Puntos Medios",
        "north_letter": "N",
        "east_letter": "E",
        "south_letter": "S",
        "west_letter": "W",
        "tropical": "Tropical",
        "sidereal": "Sideral",
        "zodiac": "Zodiaco",
        "ayanamsa": "Ayanamsa",
        "apparent_geocentric": "Geocéntrico Aparente",
        "heliocentric": "Heliocéntrico",
        "topocentric": "Topocéntrico",
        "true_geocentric": "Geocéntrico Verdadero",
        "new_moon": "Luna Nueva",
        "waxing_crescent": "Luna Creciente",
        "first_quarter": "Cuarto Creciente",
        "waxing_gibbous": "Luna Gibosa Creciente",
        "full_moon": "Luna Llena",
        "waning_gibbous": "Luna Gibosa Menguante",
        "last_quarter": "Cuarto Menguante",
        "waning_crescent": "Luna Menguante",
        "houses": "Casas",
        "domification": "Domificación",
        "houses_system_A": "Iguales",
        "houses_system_B": "Alcabicio",
        "houses_system_C": "Campanus",
        "houses_system_D": "Iguales (MC)",
        "houses_system_F": "Carter poli-equ.",
        "houses_system_H": "Horizonte/Azimut",
        "houses_system_I": "Sunshine",
        "houses_system_i": "Sunshine/alt.",
        "houses_system_K": "Koch",
        "houses_system_L": "Pullen SD",
        "houses_system_M": "Morinus",
        "houses_system_N": "Iguales/1=Aries",
        "houses_system_O": "Porfirio",
        "houses_system_P": "Placidus",
        "houses_system_Q": "Pullen SR",
        "houses_system_R": "Regiomontanus",
        "houses_system_S": "Sripati",
        "houses_system_T": "Polich/Page",
        "houses_system_U": "Krusinski-Pisa-Goelzer",
        "houses_system_V": "Iguales/Vehlow",
        "houses_system_W": "Iguales/Signo completo",
        "houses_system_X": "Sistema de rotación axial/Casas meridianas",
        "houses_system_Y": "Casas APC",
        "Natal": "Natal",
        "ExternalNatal": "Natal Externo",
        "Synastry": "Sinastría",
        "Transit": "Tránsito",
        "Composite": "Compuesto",
        "Return": "Retorno",
        "solar_return": "Retorno Solar",
        "lunar_return": "Retorno Lunar",
        "return_aspects": "Aspectos entre natal y retorno",
        "inner_wheel": "Rueda interna",
        "outer_wheel": "Rueda externa",
        "house_position_comparison": "Comparación de posiciones en casas",
        "return_point": "Punto (rev.)",
        "natal": "Radix",
        "perspective_type": "Perspectiva",
        "location": "Ubicación",
        "day_of_week": "Día de la semana",
        "weekdays": {
            "Monday": "Lunes",
            "Tuesday": "Martes",
            "Wednesday": "Miércoles",
            "Thursday": "Jueves",
            "Friday": "Viernes",
            "Saturday": "Sábado",
            "Sunday": "Domingo",
        },
        "elements": "Elementos",
        "qualities": "Cualidades",
        "cardinal": "Cardinal",
        "fixed": "Fijo",
        "mutable": "Mutable",
        "birth_chart": "Carta Natal",
        "celestial_points": {
            "Sun": "Sol",
            "Moon": "Luna",
            "Mercury": "Mercurio",
            "Venus": "Venus",
            "Mars": "Marte",
            "Jupiter": "Júpiter",
            "Saturn": "Saturno",
            "Uranus": "Urano",
            "Neptune": "Neptuno",
            "Pluto": "Plutón",
            "Ascendant": "Asc",
            "Medium_Coeli": "Mc",
            "Descendant": "Dsc",
            "Imum_Coeli": "Ic",
            "True_North_Lunar_Node": "Nodo N. (V)",
            "Mean_North_Lunar_Node": "Nodo N. (M)",
            "True_South_Lunar_Node": "Nodo S. (V)",
            "Mean_South_Lunar_Node": "Nodo S. (M)",
            "Chiron": "Quirón",
            "Mean_Lilith": "Lilith",
            "True_Lilith": "Lilith (V)",
            "Earth": "Tierra",
            "Pholus": "Pholus",
            "Ceres": "Ceres",
            "Pallas": "Palas",
            "Juno": "Juno",
            "Vesta": "Vesta",
            "Eris": "Eris",
            "Sedna": "Sedna",
            "Haumea": "Haumea",
            "Makemake": "Makemake",
            "Ixion": "Ixión",
            "Orcus": "Orco",
            "Quaoar": "Quaoar",
            "Regulus": "Régulo",
            "Spica": "Spica",
            "Pars_Fortunae": "Pars Fortunae",
            "Pars_Spiritus": "Pars Spiritus",
            "Pars_Amoris": "Pars Amoris",
            "Pars_Fidei": "Pars Fidei",
            "Vertex": "Vertex",
            "Anti_Vertex": "Anti-Vertex",
        },
    },
    "RU": {
        "info": "Информация",
        "cusp": "Дом",
        "longitude": "Долгота",
        "latitude": "Широта",
        "north": "Север",
        "east": "Восток",
        "south": "Юг",
        "west": "Запад",
        "fire": "Огонь",
        "earth": "Земля",
        "air": "Воздух",
        "water": "Вода",
        "and_word": "и",
        "transits": "Транзиты для",
        "type": "Тип",
        "couple_aspects": "Аспекты пары",
        "transit_aspects": "Транзитные аспекты",
        "planets_and_house": "Пункты для",
        "transit_name": "В момент транзита",
        "lunar_phase": "Лунная фаза",
        "lunation_day": "Лунационный день",
        "day": "День",
        "composite_chart": "Композитная карта",
        "midpoints": "Средние точки",
        "north_letter": "С",
        "east_letter": "В",
        "south_letter": "Ю",
        "west_letter": "З",
        "tropical": "Тропический",
        "sidereal": "Сидереальный",
        "zodiac": "Зодиак",
        "ayanamsa": "Аянамса",
        "apparent_geocentric": "Видимый Геоцентрический",
        "heliocentric": "Гелиоцентрический",
        "topocentric": "Топоцентрический",
        "true_geocentric": "Истинный Геоцентрический",
        "new_moon": "Новолуние",
        "waxing_crescent": "Растущий Серп",
        "first_quarter": "Первая Четверть",
        "waxing_gibbous": "Растущая Луна",
        "full_moon": "Полнолуние",
        "waning_gibbous": "Убывающая Луна",
        "last_quarter": "Последняя Четверть",
        "waning_crescent": "Убывающий Серп",
        "houses": "Дома",
        "domification": "Домификация",
        "houses_system_A": "Равные",
        "houses_system_B": "Алькабитиус",
        "houses_system_C": "Кампанус",
        "houses_system_D": "Равные (MC)",
        "houses_system_F": "Картер поли-экв.",
        "houses_system_H": "Горизонт/Азимут",
        "houses_system_I": "Саншайн",
        "houses_system_i": "Саншайн/альт.",
        "houses_system_K": "Кох",
        "houses_system_L": "Пуллен SD",
        "houses_system_M": "Моринус",
        "houses_system_N": "Равные/1=Овен",
        "houses_system_O": "Порфирий",
        "houses_system_P": "Плацидус",
        "houses_system_Q": "Пуллен SR",
        "houses_system_R": "Региомонтанус",
        "houses_system_S": "Шрипати",
        "houses_system_T": "Полич/Пейдж",
        "houses_system_U": "Крусински-Пиза-Гольцер",
        "houses_system_V": "Равные/Велоу",
        "houses_system_W": "Равные/Целый знак",
        "houses_system_X": "Осевая система вращения/Меридианные дома",
        "houses_system_Y": "Дома APC",
        "Natal": "Натальная",
        "ExternalNatal": "Внешняя Натальная",
        "Synastry": "Синастрия",
        "Transit": "Транзит",
        "Composite": "Композит",
        "solar_return": "Солнечное возвращение",
        "lunar_return": "Лунное возвращение",
        "return_aspects": "Аспекты от натала к возвращению",
        "inner_wheel": "Внутреннее колесо",
        "outer_wheel": "Внешнее колесо",
        "house_position_comparison": "Сравнение положений в домах",
        "return_point": "Точка воз.",
        "Return": "Возвращение",
        "natal": "Радикс",
        "perspective_type": "Перспектива",
        "location": "Местоположение",
        "day_of_week": "День недели",
        "weekdays": {
            "Monday": "Понедельник",
            "Tuesday": "Вторник",
            "Wednesday": "Среда",
            "Thursday": "Четверг",
            "Friday": "Пятница",
            "Saturday": "Суббота",
            "Sunday": "Воскресенье",
        },
        "elements": "Стихии",
        "qualities": "Качества",
        "cardinal": "Кардинальный",
        "fixed": "Фиксированный",
        "mutable": "Мутабельный",
        "birth_chart": "Натальная Карта",
        "celestial_points": {
            "Sun": "Солнце",
            "Moon": "Луна",
            "Mercury": "Меркурий",
            "Venus": "Венера",
            "Mars": "Марс",
            "Jupiter": "Юпитер",
            "Saturn": "Сатурн",
            "Uranus": "Уран",
            "Neptune": "Нептун",
            "Pluto": "Плутон",
            "Ascendant": "Асц",
            "Medium_Coeli": "MC",
            "Descendant": "ДСЦ",
            "Imum_Coeli": "IC",
            "True_North_Lunar_Node": "С. Узел (И)",
            "Mean_North_Lunar_Node": "С. Узел (С)",
            "True_South_Lunar_Node": "Ю. Узел (И)",
            "Mean_South_Lunar_Node": "Ю. Узел (С)",
            "Chiron": "Хирон",
            "Mean_Lilith": "Лилит",
            "True_Lilith": "Лилит (И)",
            "Earth": "Земля",
            "Pholus": "Фолус",
            "Ceres": "Церера",
            "Pallas": "Паллада",
            "Juno": "Юнона",
            "Vesta": "Веста",
            "Eris": "Эрида",
            "Sedna": "Седна",
            "Haumea": "Хаумеа",
            "Makemake": "Макемаке",
            "Ixion": "Иксион",
            "Orcus": "Оркус",
            "Quaoar": "Квавар",
            "Regulus": "Регул",
            "Spica": "Спика",
            "Pars_Fortunae": "Жребий Фортуны",
            "Pars_Spiritus": "Жребий Духа",
            "Pars_Amoris": "Жребий Любви",
            "Pars_Fidei": "Жребий Веры",
            "Vertex": "Вертекс",
            "Anti_Vertex": "Анти-Вертекс",
        },
    },
    "TR": {
        "info": "Bilgi",
        "cusp": "Ev",
        "longitude": "Boylam",
        "latitude": "Enlem",
        "north": "Kuzey",
        "east": "Doğu",
        "south": "Güney",
        "west": "Batı",
        "fire": "Ateş",
        "earth": "Toprak",
        "air": "Hava",
        "water": "Su",
        "and_word": "ve",
        "transits": "Geçişler için",
        "type": "Tür",
        "couple_aspects": "Çiftin Açılar",
        "transit_aspects": "Geçiş Açıları",
        "planets_and_house": "Puanlar için",
        "transit_name": "Geçiş anında",
        "lunar_phase": "Ay Aşaması",
        "lunation_day": "Ay Döngüsü Günü",
        "day": "Gün",
        "composite_chart": "Kompozit Harita",
        "midpoints": "Orta Noktalar",
        "north_letter": "K",
        "east_letter": "D",
        "south_letter": "G",
        "west_letter": "B",
        "tropical": "Tropikal",
        "sidereal": "Sidereal",
        "zodiac": "Burçlar",
        "ayanamsa": "Ayanamsa",
        "apparent_geocentric": "Görünen Jeosentrik",
        "heliocentric": "Helyosentrik",
        "topocentric": "Toposentrik",
        "true_geocentric": "Gerçek Jeosentrik",
        "new_moon": "Yeni Ay",
        "waxing_crescent": "Hilal",
        "first_quarter": "İlk Dördün",
        "waxing_gibbous": "Şişkin Ay",
        "full_moon": "Dolunay",
        "waning_gibbous": "Küçülen Şişkin Ay",
        "last_quarter": "Son Dördün",
        "waning_crescent": "Küçülen Hilal",
        "houses": "Evler",
        "domification": "Domifikasyon",
        "houses_system_A": "Eşit",
        "houses_system_B": "Alkabisyus",
        "houses_system_C": "Kampanus",
        "houses_system_D": "Eşit (MC)",
        "houses_system_F": "Carter poli-equ.",
        "houses_system_H": "Ufuk/Azimut",
        "houses_system_I": "Sunshine",
        "houses_system_i": "Sunshine/alt.",
        "houses_system_K": "Koch",
        "houses_system_L": "Pullen SD",
        "houses_system_M": "Morinus",
        "houses_system_N": "Eşit/1=Koç",
        "houses_system_O": "Porfiryus",
        "houses_system_P": "Placidus",
        "houses_system_Q": "Pullen SR",
        "houses_system_R": "Regiomontanus",
        "houses_system_S": "Sripati",
        "houses_system_T": "Polich/Page",
        "houses_system_U": "Krusinski-Pisa-Goelzer",
        "houses_system_V": "Eşit/Vehlow",
        "houses_system_W": "Eşit/Tam burç",
        "houses_system_X": "Eksenel dönüş sistemi/Meridyen evleri",
        "houses_system_Y": "APC evleri",
        "Natal": "Doğum",
        "ExternalNatal": "Harici Doğum",
        "Synastry": "Sinastri",
        "Transit": "Geçiş",
        "Composite": "Kompozit",
        "solar_return": "Güneş Dönüşü",
        "lunar_return": "Ay Dönüşü",
        "return_aspects": "Doğumdan dönüşe açılar",
        "inner_wheel": "İç çember",
        "outer_wheel": "Dış çember",
        "house_position_comparison": "Ev konumu karşılaştırması",
        "return_point": "Dönüş noktası",
        "Return": "Dönüş",
        "natal": "Doğum haritası",
        "perspective_type": "Perspektif",
        "location": "Konum",
        "day_of_week": "Haftanın günü",
        "weekdays": {
            "Monday": "Pazartesi",
            "Tuesday": "Salı",
            "Wednesday": "Çarşamba",
            "Thursday": "Perşembe",
            "Friday": "Cuma",
            "Saturday": "Cumartesi",
            "Sunday": "Pazar",
        },
        "elements": "Elementler",
        "qualities": "Nitelikler",
        "cardinal": "Kardinal",
        "fixed": "Sabit",
        "mutable": "Değişken",
        "birth_chart": "Doğum Haritası",
        "celestial_points": {
            "Sun": "Güneş",
            "Moon": "Ay",
            "Mercury": "Merkür",
            "Venus": "Venüs",
            "Mars": "Mars",
            "Jupiter": "Jüpiter",
            "Saturn": "Satürn",
            "Uranus": "Uranüs",
            "Neptune": "Neptün",
            "Pluto": "Plüton",
            "Ascendant": "Yükselen",
            "Medium_Coeli": "MC",
            "Descendant": "İK",
            "Imum_Coeli": "IC",
            "True_North_Lunar_Node": "K. Düğümü (T)",
            "Mean_North_Lunar_Node": "K. Düğümü (M)",
            "Chiron": "Kiron",
            "Mean_Lilith": "Lilith",
            "True_South_Lunar_Node": "G. Düğümü (T)",
            "Mean_South_Lunar_Node": "G. Düğümü (M)",
            "True_Lilith": "Lilith (T)",
            "Earth": "Dünya",
            "Pholus": "Pholus",
            "Ceres": "Ceres",
            "Pallas": "Pallas",
            "Juno": "Juno",
            "Vesta": "Vesta",
            "Eris": "Eris",
            "Sedna": "Sedna",
            "Haumea": "Haumea",
            "Makemake": "Makemake",
            "Ixion": "Ixion",
            "Orcus": "Orcus",
            "Quaoar": "Quaoar",
            "Regulus": "Regulus",
            "Spica": "Spica",
            "Pars_Fortunae": "Talih Payı",
            "Pars_Spiritus": "Ruh Payı",
            "Pars_Amoris": "Aşk Payı",
            "Pars_Fidei": "İnanç Payı",
            "Vertex": "Vertex",
            "Anti_Vertex": "Anti-Vertex",
        },
    },
    "DE": {
        "info": "Informationen",
        "cusp": "Haus",
        "longitude": "Längengrad",
        "latitude": "Breitengrad",
        "north": "Norden",
        "east": "Osten",
        "south": "Süden",
        "west": "Westen",
        "fire": "Feuer",
        "earth": "Erde",
        "air": "Luft",
        "water": "Wasser",
        "and_word": "und",
        "transits": "Transite für",
        "type": "Typ",
        "couple_aspects": "Aspekte des Paares",
        "transit_aspects": "Transitaspekte",
        "planets_and_house": "Punkte für",
        "transit_name": "Zum Zeitpunkt des Transits",
        "lunar_phase": "Mondphase",
        "lunation_day": "Lunationstag",
        "day": "Tag",
        "composite_chart": "Komposit-Chart",
        "midpoints": "Mittelpunkte",
        "north_letter": "N",
        "east_letter": "E",
        "south_letter": "S",
        "west_letter": "W",
        "tropical": "Tropisch",
        "sidereal": "Siderisch",
        "zodiac": "Tierkreis",
        "ayanamsa": "Ayanamsa",
        "apparent_geocentric": "Scheinbar Geozentrisch",
        "heliocentric": "Heliozentrisch",
        "topocentric": "Topozentrisch",
        "true_geocentric": "Wahrhaft Geozentrisch",
        "new_moon": "Neumond",
        "waxing_crescent": "Zunehmende Sichel",
        "first_quarter": "Erstes Viertel",
        "waxing_gibbous": "Zunehmender Mond",
        "full_moon": "Vollmond",
        "waning_gibbous": "Abnehmender Mond",
        "last_quarter": "Letztes Viertel",
        "waning_crescent": "Abnehmende Sichel",
        "houses": "Häuser",
        "domification": "Domifikation",
        "houses_system_A": "Gleich",
        "houses_system_B": "Alcabitius",
        "houses_system_C": "Campanus",
        "houses_system_D": "Gleich (MC)",
        "houses_system_F": "Carter poli-äqu.",
        "houses_system_H": "Horizont/Azimut",
        "houses_system_I": "Sunshine",
        "houses_system_i": "Sunshine/alt.",
        "houses_system_K": "Koch",
        "houses_system_L": "Pullen SD",
        "houses_system_M": "Morinus",
        "houses_system_N": "Gleich/1=Widder",
        "houses_system_O": "Porphyrius",
        "houses_system_P": "Placidus",
        "houses_system_Q": "Pullen SR",
        "houses_system_R": "Regiomontanus",
        "houses_system_S": "Sripati",
        "houses_system_T": "Polich/Page",
        "houses_system_U": "Krusinski-Pisa-Goelzer",
        "houses_system_V": "Gleich/Vehlow",
        "houses_system_W": "Gleich/Ganzes Zeichen",
        "houses_system_X": "Axiales Rotationssystem/Meridianhäuser",
        "houses_system_Y": "APC Häuser",
        "Natal": "Radix",
        "ExternalNatal": "Externes Radix",
        "Synastry": "Synastrie",
        "Transit": "Transit",
        "Composite": "Composit",
        "Return": "Rückkehr",
        "solar_return": "Sonnenrückkehr",
        "lunar_return": "Mondrückkehr",
        "return_aspects": "Aspekte vom Radix zum Return",
        "inner_wheel": "Innerer Kreis",
        "outer_wheel": "Äußerer Kreis",
        "house_position_comparison": "Vergleich der Häuserpositionen",
        "return_point": "Rückkehrpunkt",
        "natal": "Radix",
        "perspective_type": "Perspektive",
        "location": "Ort",
        "day_of_week": "Wochentag",
        "weekdays": {
            "Monday": "Montag",
            "Tuesday": "Dienstag",
            "Wednesday": "Mittwoch",
            "Thursday": "Donnerstag",
            "Friday": "Freitag",
            "Saturday": "Samstag",
            "Sunday": "Sonntag",
        },
        "elements": "Elemente",
        "qualities": "Qualitäten",
        "cardinal": "Kardinal",
        "fixed": "Fix",
        "mutable": "Veränderlich",
        "birth_chart": "Geburtshoroskop",
        "celestial_points": {
            "Sun": "Sonne",
            "Moon": "Mond",
            "Mercury": "Merkur",
            "Venus": "Venus",
            "Mars": "Mars",
            "Jupiter": "Jupiter",
            "Saturn": "Saturn",
            "Uranus": "Uranus",
            "Neptune": "Neptun",
            "Pluto": "Pluto",
            "Ascendant": "Asz",
            "Medium_Coeli": "MC",
            "Descendant": "DSC",
            "Imum_Coeli": "IC",
            "True_North_Lunar_Node": "Nordknoten (T)",
            "Mean_North_Lunar_Node": "Nordknoten (M)",
            "True_South_Lunar_Node": "Südknoten (T)",
            "Mean_South_Lunar_Node": "Südknoten (M)",
            "Chiron": "Chiron",
            "Mean_Lilith": "Lilith",
            "True_Lilith": "Lilith (T)",
            "Earth": "Erde",
            "Pholus": "Pholus",
            "Ceres": "Ceres",
            "Pallas": "Pallas",
            "Juno": "Juno",
            "Vesta": "Vesta",
            "Eris": "Eris",
            "Sedna": "Sedna",
            "Haumea": "Haumea",
            "Makemake": "Makemake",
            "Ixion": "Ixion",
            "Orcus": "Orcus",
            "Quaoar": "Quaoar",
            "Regulus": "Regulus",
            "Spica": "Spica",
            "Pars_Fortunae": "Glückspunkt",
            "Pars_Spiritus": "Geistpunkt",
            "Pars_Amoris": "Liebespunkt",
            "Pars_Fidei": "Glaubenspunkt",
            "Vertex": "Vertex",
            "Anti_Vertex": "Anti-Vertex",
        },
    },
    "HI": {
        "info": "जानकारी",
        "cusp": "घर",
        "longitude": "देशांतर",
        "latitude": "अक्षांश",
        "north": "उत्तर",
        "east": "पूर्व",
        "south": "दक्षिण",
        "west": "पश्चिम",
        "fire": "अग्नि",
        "earth": "पृथ्वी",
        "air": "वायु",
        "water": "जल",
        "and_word": "और",
        "transits": "गोचर के लिए",
        "type": "प्रकार",
        "couple_aspects": "जोड़ी के पहलू",
        "transit_aspects": "गोचर के पहलू",
        "planets_and_house": "अंक के लिए",
        "transit_name": "गोचर के समय",
        "lunar_phase": "चंद्र चरण",
        "lunation_day": "चंद्र चक्र दिन",
        "day": "दिन",
        "composite_chart": "संयुक्त चार्ट",
        "midpoints": "मध्य बिंदु",
        "north_letter": "उ",
        "east_letter": "पू",
        "south_letter": "द",
        "west_letter": "प",
        "tropical": "ट्रॉपिकल",
        "sidereal": "साइडीरियल",
        "zodiac": "राशि",
        "ayanamsa": "अयनांश",
        "apparent_geocentric": "आभासी भूकेंद्रीय",
        "heliocentric": "सूर्यकेंद्रीय",
        "topocentric": "स्थानकेंद्रीय",
        "true_geocentric": "वास्तविक भूकेंद्रीय",
        "new_moon": "अमावस्या",
        "waxing_crescent": "शुक्ल पक्ष प्रथमा",
        "first_quarter": "शुक्ल पक्ष सप्तमी",
        "waxing_gibbous": "शुक्ल पक्ष त्रयोदशी",
        "full_moon": "पूर्णिमा",
        "waning_gibbous": "कृष्ण पक्ष त्रयोदशी",
        "last_quarter": "कृष्ण पक्ष सप्तमी",
        "waning_crescent": "कृष्ण पक्ष प्रथमा",
        "houses": "भावों",
        "domification": "गृह",
        "houses_system_A": "समान",
        "houses_system_B": "अल्काबितियस",
        "houses_system_C": "कैम्पानस",
        "houses_system_D": "समान (MC)",
        "houses_system_F": "कार्टर बहु-सम",
        "houses_system_H": "क्षितिज/अज़ीमुथ",
        "houses_system_I": "सनशाइन",
        "houses_system_i": "सनशाइन/वैकल्पिक",
        "houses_system_K": "कोच",
        "houses_system_L": "पुल्लेन SD",
        "houses_system_M": "मोरिनस",
        "houses_system_N": "समान/1=मेष",
        "houses_system_O": "पोरफिरी",
        "houses_system_P": "प्लासिडस",
        "houses_system_Q": "पुल्लेन SR",
        "houses_system_R": "रेजियोमोंटेनस",
        "houses_system_S": "श्रीपति",
        "houses_system_T": "पोलिच/पेज",
        "houses_system_U": "क्रुसिंस्की-पिसा-गोल्ज़र",
        "houses_system_V": "समान/वेहलो",
        "houses_system_W": "समान/पूर्ण राशि",
        "houses_system_X": "धुरी घूर्णन प्रणाली/मेरिडियन भाव",
        "houses_system_Y": "APC भाव",
        "Natal": "जन्म",
        "ExternalNatal": "बाहरी जन्म",
        "Synastry": "सिनेस्ट्री",
        "Transit": "गोचर",
        "Composite": "संयुक्त",
        "Return": "वापसी",
        "solar_return": "सौर वापसी",
        "lunar_return": "चंद्र वापसी",
        "return_aspects": "जन्म से रिटर्न तक के पहलू",
        "inner_wheel": "भीतरी चक्र",
        "outer_wheel": "बाहरी चक्र",
        "house_position_comparison": "भाव स्थिति तुलना",
        "return_point": "पुनरागमन बिंदु",
        "natal": "जन्म कुंडली",
        "perspective_type": "दृष्टिकोण",
        "location": "स्थान",
        "day_of_week": "सप्ताह का दिन",
        "weekdays": {
            "Monday": "सोमवार",
            "Tuesday": "मंगलवार",
            "Wednesday": "बुधवार",
            "Thursday": "गुरुवार",
            "Friday": "शुक्रवार",
            "Saturday": "शनिवार",
            "Sunday": "रविवार",
        },
        "elements": "तत्व",
        "qualities": "गुण",
        "cardinal": "चल",
        "fixed": "स्थिर",
        "mutable": "द्विस्वभाव",
        "birth_chart": "जन्म चार्ट",
        "celestial_points": {
            "Sun": "सूर्य",
            "Moon": "चंद्रमा",
            "Mercury": "बुध",
            "Venus": "शुक्र",
            "Mars": "मंगल",
            "Jupiter": "गुरु",
            "Saturn": "शनि",
            "Uranus": "यूरेनस",
            "Neptune": "नेपच्यून",
            "Pluto": "प्लूटो",
            "Ascendant": "आस",
            "Medium_Coeli": "एमसी",
            "Descendant": "डीएससी",
            "Imum_Coeli": "आईसी",
            "True_North_Lunar_Node": "उत्तर नोड (T)",
            "Mean_North_Lunar_Node": "उत्तर नोड (M)",
            "True_South_Lunar_Node": "दक्षिण नोड (T)",
            "Mean_South_Lunar_Node": "दक्षिण नोड (M)",
            "Chiron": "किरोन",
            "Mean_Lilith": "लिलिथ",
            "True_Lilith": "लिलिथ (T)",
            "Earth": "पृथ्वी",
            "Pholus": "फोलस",
            "Ceres": "सेरेस",
            "Pallas": "पैलास",
            "Juno": "जूनो",
            "Vesta": "वेस्टा",
            "Eris": "एरिस",
            "Sedna": "सेदना",
            "Haumea": "हौमेया",
            "Makemake": "माकेमाके",
            "Ixion": "इक्षियन",
            "Orcus": "ऑरकस",
            "Quaoar": "क्वाओर",
            "Regulus": "रेगुलस",
            "Spica": "स्पाइका",
            "Pars_Fortunae": "भाग्य अंश",
            "Pars_Spiritus": "आत्मा अंश",
            "Pars_Amoris": "प्रेम अंश",
            "Pars_Fidei": "विश्वास अंश",
            "Vertex": "वर्टेक्स",
            "Anti_Vertex": "एंटी-वर्टेक्स",
        },
    },
}
