# Release v4.14.0: Lilith Implementation

I am excited to announce the release of version 1.2.0 of our library! This update brings significant enhancements, including the implementation of Lilith in both `astrological_subject.py` and `charts/kerykeion_chart_svg.py`. Below are the details of what's new and how to use these features.

## What's New

### Lilith Implementation

- Lilith has been added to the astrological calculations and chart rendering.
- You can now include Lilith in your astrological subjects and charts.

### Backward Compatibility

- The old argument `disable_chiron` is now deprecated and replaced with `disable_chiron_and_lilith`.
- A deprecation warning will be issued if `disable_chiron` is used, ensuring a smooth transition.

## How to Use

### In `astrological_subject.py`

#### Initialization

- The constructor now accepts `disable_chiron_and_lilith` to control the inclusion of both Chiron and Lilith.
- Example:
  ```python
  subject = AstrologicalSubject(
      ...,
      disable_chiron_and_lilith=True
  )
  ```

#### Backward Compatibility

- If you still use `disable_chiron`, a warning will be issued, and it will be mapped to `disable_chiron_and_lilith`.

### In `charts/kerykeion_chart_svg.py`

#### Rendering Lilith

- Lilith is now included in the aspect list and rendered in the chart.
- To disable Lilith rendering in the chart, you should update the `kr.config.json` file:
  ```json
  {
    "id": 17,
    "name": "Mean_Lilith",
    "color": "#000",
    "is_active": false,
    "element_points": 0,
    "related_zodiac_signs": [],
    "label": "Mean_Lilith"
  }
  ```

## Deprecation Notice

- The `disable_chiron` argument is deprecated and will be removed in a future version. Please update your code to use `disable_chiron_and_lilith`.

## Conclusion

I hope these enhancements improve your experience with our library. As always, I appreciate your feedback and contributions. Please report any issues or suggestions on our GitHub Issues page.

Happy charting!

Giacomo
